/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool;

import com.sun.electric.Main;
import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.Environment;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.id.IdManager;
import com.sun.electric.database.network.NetworkTool;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.Setting;
import com.sun.electric.database.text.Version;
import com.sun.electric.technology.TechFactory;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.ToolSettings;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.User;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;

public class StandAlone {
    public static void initPrefs(Map<String, Object> initPrefs) {
        Pref.forbidPreferences();
        StandAlone.initTools();
        Pref.lockCreation(initPrefs);
        Job.setUserInterface(new StandAloneUserInterface());
    }

    public static void startElectric(Map<String, Object> settingChanges) {
        String[] techNames = new String[]{"artwork", "schematic"};
        StandAlone.startElectric(techNames, settingChanges);
    }

    public static void startElectric(String[] techNames, Map<String, Object> settingChanges) {
        System.out.println("Electric Version: " + Version.getVersion());
        EDatabase database = new EDatabase(IdManager.stdIdManager.getInitialSnapshot(), "serverDB");
        EDatabase.setServerDatabase(database);
        database.lock(true);
        database.setToolSettings((Setting.RootGroup)ToolSettings.getToolSettings(""));
        assert (database.getGeneric() == null);
        Generic generic = Generic.newInst(database.getIdManager());
        database.addTech(generic);
        Map<String, TechFactory> techFactories = TechFactory.getKnownTechs();
        Map<TechFactory.Param, Object> paramValues = Collections.emptyMap();
        for (String techName : techNames) {
            database.addTech(techFactories.get(techName).newInst(generic, paramValues));
        }
        database.lowLevelBeginChanging(null);
        Setting.SettingChangeBatch changeBatch = new Setting.SettingChangeBatch();
        for (Map.Entry<Setting, Object> e : database.getSettings().entrySet()) {
            Setting setting = e.getKey();
            Object value = e.getValue();
            if (!settingChanges.containsKey(setting.getXmlPath())) continue;
            assert (value.getClass() == setting.getFactoryValue().getClass());
            changeBatch.add(setting, settingChanges.get(setting.getXmlPath()));
        }
        database.implementSettingChanges(changeBatch);
        Environment.setThreadEnvironment(database.getEnvironment());
        EditingPreferences.lowLevelSetThreadLocalEditingPreferences(new EditingPreferences(true, database.getTechPool()));
    }

    public static void closeElectric() {
        EditingPreferences.lowLevelSetThreadLocalEditingPreferences(null);
        Environment.setThreadEnvironment(null);
        EDatabase.setServerDatabase(null);
    }

    private static void initTools() {
        User.getUserTool();
        IOTool.getIOTool().init();
        NetworkTool.getNetworkTool();
    }

    private static class StandAloneUserInterface
    extends Main.UserInterfaceDummy {
        private StandAloneUserInterface() {
        }

        @Override
        public EDatabase getDatabase() {
            return EDatabase.serverDatabase();
        }

        @Override
        public void termLogging(ErrorLogger logger, boolean explain, boolean terminate) {
            System.out.println(logger.getInfo());
            Iterator<ErrorLogger.MessageLog> it = logger.getLogs();
            while (it.hasNext()) {
                System.out.println(it.next().getMessage());
            }
        }
    }
}

