/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.netlist;

import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.ncc.netlist.NetObject;
import com.sun.electric.tool.ncc.netlist.Wire;
import com.sun.electric.tool.ncc.result.PortReport;
import com.sun.electric.tool.ncc.trees.Circuit;
import com.sun.electric.util.TextUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public class Port
extends NetObject
implements PortReport.PortReportable {
    private Wire wire;
    private List<String> names = new ArrayList<String>();
    private List<PortCharacteristic> types = new ArrayList<PortCharacteristic>();
    private boolean toBeRenamed = false;

    public Port(String name, PortCharacteristic type, Wire w) {
        this.wire = w;
        this.names.add(name);
        this.types.add(type);
    }

    @Override
    public String getName() {
        Job.error(this.names.size() == 0, "Port with no name?");
        return this.names.iterator().next();
    }

    @Override
    public NetObject.Type getNetObjType() {
        return NetObject.Type.PORT;
    }

    @Override
    public Iterator<NetObject> getConnected() {
        return new ArrayList().iterator();
    }

    public void addExport(String nm, PortCharacteristic type, boolean oneNamePerPort) {
        if (oneNamePerPort) {
            Job.error(this.names.size() != 1, "expect exactly one Port name");
            if (TextUtils.STRING_NUMBER_ORDER.compare(this.names.get(0), nm) > 0) {
                this.names.set(0, nm);
            }
        } else {
            this.names.add(nm);
        }
        this.types.add(type);
    }

    public PortCharacteristic getType() {
        HashMap<PortCharacteristic, Integer> typeToCount = new HashMap<PortCharacteristic, Integer>();
        for (PortCharacteristic t : this.types) {
            Integer count = (Integer)typeToCount.get((Object)t);
            int c = count != null ? count : 0;
            typeToCount.put(t, c + 1);
        }
        int popularCount = 0;
        PortCharacteristic popularType = null;
        for (PortCharacteristic t : typeToCount.keySet()) {
            int count = (Integer)typeToCount.get((Object)t);
            if (count <= popularCount && (count != popularCount || t == PortCharacteristic.UNKNOWN)) continue;
            popularCount = count;
            popularType = t;
        }
        return popularType;
    }

    public Wire getWire() {
        return this.wire;
    }

    @Override
    public String getWireName() {
        return this.wire.getName();
    }

    @Override
    public void checkMe(Circuit parent) {
        Port.error(parent != this.getParent(), "wrong parent");
        Port.error(this.wire == null, this.instanceDescription() + " has null connection");
        Port.error(!this.wire.touches(this), this.instanceDescription() + " has inconsistant connection to " + this.wire.instanceDescription());
    }

    @Override
    public String exportNamesString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{ ");
        for (String s : new TreeSet<String>(this.names)) {
            if (sb.length() > 2) {
                sb.append(", ");
            }
            sb.append(s);
        }
        sb.append(" }");
        return sb.toString();
    }

    public Iterator<String> getExportNames() {
        return this.names.iterator();
    }

    @Override
    public boolean isDeleted() {
        return false;
    }

    @Override
    public boolean isImplied() {
        return !this.getWire().getNameProxy().getNet().getExports().hasNext();
    }

    public void setToBeRenamed() {
        this.toBeRenamed = true;
    }

    public boolean getToBeRenamed() {
        return this.toBeRenamed;
    }

    @Override
    public String instanceDescription() {
        return "Port " + this.exportNamesString();
    }

    @Override
    public String valueDescription() {
        return "";
    }

    @Override
    public String connectionDescription(int n) {
        return "is on Wire: " + this.wire.getName();
    }
}

