/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout.fill;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.IdMapper;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.routing.AutoStitch;
import com.sun.electric.tool.routing.Route;
import com.sun.electric.tool.routing.Router;
import com.sun.electric.tool.routing.SimpleWirer;
import com.sun.electric.tool.user.CellChangeJobs;
import com.sun.electric.tool.user.ExportChanges;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.FixpRectangle;
import com.sun.electric.util.math.FixpTransform;
import com.sun.electric.util.math.Orientation;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class StitchFillJob
extends Job {
    private Cell topCell;
    private Library outLibrary;
    private List<Cell> generatedCells = new ArrayList<Cell>();
    private boolean evenHorizontal = true;
    private List<String> globalLayersWithExports = new ArrayList<String>();
    private static final PinsArcPairSort pinsArcSort = new PinsArcPairSort();

    public StitchFillJob(Cell cell, Library lib, boolean doItNow) {
        super("Fill generator job", null, Job.Type.CHANGE, null, null, Job.Priority.USER);
        this.topCell = cell;
        this.outLibrary = lib;
        if (doItNow) {
            try {
                if (this.doIt()) {
                    this.terminateOK();
                }
            }
            catch (JobException e) {
                e.printStackTrace();
            }
        } else {
            this.startJob();
        }
    }

    private static Cell cleanReplacement(Cell oldC, Library lib, String fillCellName, EditingPreferences ep) {
        if (oldC != null) {
            String fakeName = oldC.getName() + "TMPStitch";
            assert (lib.findNodeProto(fakeName) == null);
            IdMapper idMapper = oldC.rename(fakeName, null);
            oldC = idMapper.get(oldC.getId()).inDatabase(EDatabase.serverDatabase());
        }
        Cell newCell = Cell.makeInstance(ep, lib, fillCellName);
        if (oldC != null) {
            ArrayList<NodeInst> nodesToReplace = new ArrayList<NodeInst>();
            Iterator<NodeInst> nIt = oldC.getInstancesOf();
            while (nIt.hasNext()) {
                nodesToReplace.add(nIt.next());
            }
            for (NodeInst ni : nodesToReplace) {
                NodeInst replaced = ni.replace(newCell, ep, false, false, false);
                if (replaced != null) continue;
                System.out.println("Warning: conflicts while replacing existing cell in StitchFill");
            }
            oldC.kill();
        }
        return newCell;
    }

    @Override
    public boolean doIt() throws JobException {
        EditingPreferences ep = this.getEditingPreferences();
        Point2D.Double center = new Point2D.Double(0.0, 0.0);
        if (this.topCell == null) {
            Technology tech = null;
            ArrayList<NodeInst> fillCells = new ArrayList<NodeInst>();
            ArrayList<Geometric> fillGeoms = new ArrayList<Geometric>();
            String fillCellName = "NewFill{lay}";
            Library lib = Library.getCurrent();
            if (lib == null) {
                System.out.println("No current library available.");
                return false;
            }
            Cell oldCell = lib.findNodeProto(fillCellName);
            Cell newCell = StitchFillJob.cleanReplacement(oldCell, lib, fillCellName, ep);
            Iterator<WindowFrame> itW = WindowFrame.getWindows();
            while (itW.hasNext()) {
                WindowFrame w = itW.next();
                Cell c = w.getContent().getCell();
                if (c == null) {
                    System.out.println("No cell in window '" + w.getTitle() + "'");
                    continue;
                }
                if (c.getView() != View.LAYOUT) {
                    System.out.println("Cell '" + c + "' is not a layout cell");
                    continue;
                }
                Technology t = c.getTechnology();
                if (tech == null) {
                    tech = t;
                } else if (tech != t) {
                    System.out.println("Mixing technologies in fill generator: " + tech.getTechName() + " " + t.getTechName());
                }
                NodeInst ni = NodeInst.makeInstance(c, ep, center, c.getDefWidth(), c.getDefHeight(), newCell);
                fillCells.add(ni);
                fillGeoms.add(ni);
            }
            StitchFillJob.doTheJob(newCell, fillCellName, fillCells, fillGeoms, null, false, Collections.emptyList(), this, ep);
            return true;
        }
        String[] instructions = this.topCell.getTextViewContents();
        if (instructions == null) {
            System.out.println("No fill instructions found.");
            return false;
        }
        for (String line : instructions) {
            String value;
            if (line.startsWith("//")) continue;
            if (line.startsWith("$")) {
                StringTokenizer parse = new StringTokenizer(line, "= $", false);
                int count = 0;
                while (parse.hasMoreTokens()) {
                    assert (count < 2);
                    value = parse.nextToken();
                    switch (count) {
                        case 0: {
                            assert (value.toLowerCase().equals("horizontal"));
                            break;
                        }
                        case 1: {
                            if (value.toLowerCase().equals("odd")) {
                                this.evenHorizontal = false;
                                break;
                            }
                            if (value.toLowerCase().equals("even")) {
                                this.evenHorizontal = true;
                                break;
                            }
                            System.out.println("Invalid instruction '" + value + "' in stitch instructions doc.");
                            break;
                        }
                        default: {
                            assert (false);
                            break;
                        }
                    }
                    ++count;
                }
                continue;
            }
            if (line.startsWith("@exports")) {
                int index = line.indexOf("=");
                assert (index != -1);
                StringTokenizer parse = new StringTokenizer(line.substring(index + 1), " {,}", false);
                while (parse.hasMoreTokens()) {
                    value = parse.nextToken();
                    this.globalLayersWithExports.add(value);
                }
                continue;
            }
            StringTokenizer parse = new StringTokenizer(line, ":", false);
            int count = 0;
            Object fillCellName = null;
            String rest = null;
            while (parse.hasMoreTokens()) {
                assert (count < 2);
                String value2 = parse.nextToken();
                switch (count) {
                    case 0: {
                        fillCellName = value2;
                        break;
                    }
                    default: {
                        rest = value2;
                    }
                }
                ++count;
            }
            if (fillCellName == null) continue;
            int index = ((String)fillCellName).indexOf("(");
            boolean wideOption = false;
            ArrayList<TileInfo> tileList = new ArrayList<TileInfo>();
            ArrayList<String> localLayersWithExports = new ArrayList<String>();
            localLayersWithExports.addAll(this.globalLayersWithExports);
            if (index != -1) {
                String options = ((String)fillCellName).substring(index);
                fillCellName = ((String)fillCellName).substring(0, index);
                parse = new StringTokenizer(options, "(), ", false);
                while (parse.hasMoreTokens()) {
                    String option = parse.nextToken();
                    String lowerCase = option.toLowerCase();
                    if (lowerCase.equals("w")) {
                        wideOption = true;
                        fillCellName = (String)fillCellName + "W";
                        continue;
                    }
                    if (lowerCase.startsWith("e")) {
                        localLayersWithExports.clear();
                        StringTokenizer lNames = new StringTokenizer(option.substring(1), "[];", false);
                        while (lNames.hasMoreTokens()) {
                            String lName = lNames.nextToken();
                            localLayersWithExports.add(lName);
                        }
                        continue;
                    }
                    if (!lowerCase.contains("x")) continue;
                    index = lowerCase.indexOf("x");
                    String str = lowerCase.substring(0, index);
                    int x = Integer.valueOf(str);
                    str = lowerCase.substring(index + 1, lowerCase.length());
                    int y = Integer.valueOf(str);
                    TileInfo tile = new TileInfo(x, y);
                    tileList.add(tile);
                }
            }
            if (rest == null) {
                System.out.println("Error parsing the fill instructions");
                return false;
            }
            parse = new StringTokenizer(rest, " ,", false);
            String newName = (String)fillCellName + "{lay}";
            Cell oldCell = this.outLibrary.findNodeProto(newName);
            Cell newCell = StitchFillJob.cleanReplacement(oldCell, this.outLibrary, newName, ep);
            Technology tech = null;
            ArrayList<NodeInst> fillCells = new ArrayList<NodeInst>();
            ArrayList<Geometric> fillGeoms = new ArrayList<Geometric>();
            while (parse.hasMoreTokens()) {
                Cell c;
                String fillCell = parse.nextToken();
                index = fillCell.indexOf("(");
                boolean instanceFlag = false;
                if (index != -1) {
                    instanceFlag = fillCell.toLowerCase().indexOf("(i") != -1;
                    fillCell = fillCell.substring(0, index);
                }
                if ((c = this.topCell.getLibrary().findNodeProto(fillCell + "{lay}")) == null) {
                    System.out.println("Cell '" + fillCell + "' does not exist");
                    continue;
                }
                if (c.getView() != View.LAYOUT) {
                    System.out.println("Cell '" + c + "' is not a layout cell");
                    continue;
                }
                Technology t = c.getTechnology();
                if (tech == null) {
                    tech = t;
                } else if (tech != t) {
                    System.out.println("Mixing technologies in fill generator: " + tech.getTechName() + " " + t.getTechName());
                }
                NodeInst ni = NodeInst.makeInstance(c, ep, center, c.getDefWidth(), c.getDefHeight(), newCell);
                if (!instanceFlag) {
                    fillCells.add(ni);
                }
                fillGeoms.add(ni);
            }
            newCell.setTechnology(tech);
            this.generatedCells.add(newCell);
            StitchFillJob.doTheJob(newCell, (String)fillCellName, fillCells, fillGeoms, tileList, wideOption, localLayersWithExports, this, ep);
        }
        return true;
    }

    public List<Cell> getGeneratedCells() {
        return this.generatedCells;
    }

    private static void doTheJob(Cell newCell, String fillCellName, List<NodeInst> fillCells, List<Geometric> fillGeoms, List<TileInfo> tileList, boolean wideOption, List<String> layersWithExports, StitchFillJob job, EditingPreferences ep) {
        ExportChanges.reExportNodes(newCell, fillGeoms, false, true, false, true, true, ep);
        new CellChangeJobs.ExtractCellInstances(newCell, fillCells, Integer.MAX_VALUE, true, true, true);
        StitchFillJob.generateFill(newCell, wideOption, job.evenHorizontal, layersWithExports, job.getEditingPreferences());
        StitchFillJob.generateTiles(newCell, fillCellName, tileList, job);
    }

    private static void generateTiles(Cell template, String fillCellName, List<TileInfo> tileList, Job job) {
        if (tileList == null) {
            return;
        }
        EditingPreferences ep = job.getEditingPreferences();
        for (TileInfo info : tileList) {
            String newTileName = fillCellName + info.x + "x" + info.y + "{lay}";
            Cell newTile = Cell.makeInstance(ep, template.getLibrary(), newTileName);
            ArrayList<NodeInst> niList = new ArrayList<NodeInst>();
            ERectangle rect = template.getBounds();
            double width = ((RectangularShape)rect).getWidth();
            double height = ((RectangularShape)rect).getHeight();
            double xPos = 0.0;
            for (int i = 0; i < info.x; ++i) {
                double yPos = 0.0;
                for (int j = 0; j < info.y; ++j) {
                    NodeInst newNi = NodeInst.makeInstance(template, ep, new Point2D.Double(xPos, yPos), width, height, newTile, Orientation.IDENT, null);
                    niList.add(newNi);
                    yPos += height;
                }
                xPos += width;
            }
            AutoStitch.AutoOptions prefs = new AutoStitch.AutoOptions(true);
            prefs.createExports = true;
            AutoStitch.runAutoStitch(newTile, niList, null, job, null, null, true, false, ep, prefs, true, null);
        }
    }

    private static boolean generateFill(Cell theCell, boolean wideOption, boolean evenHor, List<String> exportNames, EditingPreferences ep) {
        PrimitiveNode n;
        Export exp;
        String rootName;
        SimpleWirer router = new SimpleWirer(ep);
        ArrayList<Layer> listOfLayers = new ArrayList<Layer>(12);
        Iterator<Layer> itL = theCell.getTechnology().getLayers();
        while (itL.hasNext()) {
            Layer l = itL.next();
            if (!l.getFunction().isMetal()) continue;
            l.getFunction().getLevel();
            listOfLayers.add(l);
        }
        Layer.getLayersSortedByRule(listOfLayers, Layer.LayerSortingType.ByFunctionLevel);
        HashMap<ArcProto, Integer> arcsCreatedMap = new HashMap<ArcProto, Integer>();
        HashMap<NodeProto, Integer> nodesCreatedMap = new HashMap<NodeProto, Integer>();
        ArrayList<Route> routeList = new ArrayList<Route>();
        Layer[] topLayers = new Layer[2];
        Layer bottomLayer = null;
        HashMap<String, Area> totalAreas = new HashMap<String, Area>();
        for (int i = 0; i < listOfLayers.size() - 1; ++i) {
            Route r;
            Layer bottom = (Layer)listOfLayers.get(i);
            boolean horizontal = StitchFillJob.isLayerHorizontal(bottom, evenHor);
            List<ArcInst> arcs = StitchFillJob.getArcsInGivenLayer(theCell.getArcs(), horizontal, bottom, null, null);
            Layer top = (Layer)listOfLayers.get(i + 1);
            HashMap<String, Area> remainingGeos = new HashMap<String, Area>();
            for (ArcInst arcInst : arcs) {
                Iterator nai;
                Netlist netlist;
                String bottomName = StitchFillJob.getExportRootName(arcInst, netlist = theCell.getNetlist());
                if (bottomName == null) continue;
                ArrayList<PinsArcPair> pairs = new ArrayList<PinsArcPair>();
                ERectangle bounds = arcInst.getBounds();
                Area bottomA = new Area(bounds);
                if (bottomLayer == null || bottom == bottomLayer) {
                    Area totalA = (Area)totalAreas.get(bottomName);
                    if (totalA == null) {
                        totalA = new Area();
                        totalAreas.put(bottomName, totalA);
                    }
                    totalA.add(bottomA);
                }
                Iterator<Geometric> it = theCell.searchIterator(bounds);
                while (it.hasNext()) {
                    boolean fullCoverageY;
                    String topName;
                    Layer nl;
                    Geometric geometric = it.next();
                    if (!(geometric instanceof ArcInst) || (nl = ((ArcInst)((Object)(nai = (ArcInst)geometric))).getProto().getLayer(0)) != top || !StitchFillJob.isArcAligned((ArcInst)((Object)nai), !horizontal) || (topName = StitchFillJob.getExportRootName(nai, netlist)) == null || !topName.equals(bottomName)) continue;
                    ERectangle nBnds = ((ArcInst)((Object)nai)).getBounds();
                    Area topA = new Area(nBnds);
                    topA.intersect(bottomA);
                    Rectangle2D resultBnd = topA.getBounds2D();
                    boolean fullCoverageX = horizontal ? DBMath.areEquals(resultBnd.getWidth(), ((RectangularShape)nBnds).getWidth()) : DBMath.areEquals(resultBnd.getHeight(), ((RectangularShape)nBnds).getHeight());
                    boolean bl = fullCoverageY = horizontal ? DBMath.areEquals(resultBnd.getHeight(), ((RectangularShape)bounds).getHeight()) : DBMath.areEquals(resultBnd.getWidth(), ((RectangularShape)bounds).getWidth());
                    if (!fullCoverageX || !fullCoverageY) {
                        Area a = (Area)remainingGeos.get(bottomName);
                        if (a == null) {
                            a = new Area();
                            remainingGeos.put(bottomName, a);
                        }
                        a.add(topA);
                        continue;
                    }
                    EPoint insert = EPoint.fromLambda(resultBnd.getCenterX(), resultBnd.getCenterY());
                    boolean insertedAlready = false;
                    for (PinsArcPair pp : pairs) {
                        if (!pp.insert.equals(insert) || !pp.cut.equals(resultBnd)) continue;
                        insertedAlready = true;
                        break;
                    }
                    if (insertedAlready) continue;
                    pairs.add(new PinsArcPair((ArcInst)((Object)nai), insert, resultBnd));
                }
                Collections.sort(pairs, pinsArcSort);
                ArcInst mostLeft = arcInst;
                routeList.clear();
                if (bottomLayer == null) {
                    bottomLayer = bottom;
                }
                if (!pairs.isEmpty()) {
                    topLayers[0] = bottom;
                    topLayers[1] = top;
                }
                Area area = (Area)remainingGeos.get(bottomName);
                for (PinsArcPair pair : pairs) {
                    r = router.planRoute(theCell, mostLeft, pair.topArc, pair.insert, null, ep, true, true, pair.cut, null, evenHor);
                    routeList.add(r);
                    if (area == null) continue;
                    Area remove = new Area(pair.cut);
                    area.subtract(remove);
                }
                nai = routeList.iterator();
                while (nai.hasNext()) {
                    Route r2 = (Route)nai.next();
                    Router.createRouteNoJob(r2, theCell, arcsCreatedMap, nodesCreatedMap, ep);
                }
            }
            for (Map.Entry entry : remainingGeos.entrySet()) {
                Area a = (Area)entry.getValue();
                Netlist netlist = theCell.getNetlist();
                List<PolyBase> list = PolyBase.getPointsInArea(a, bottom, false, false);
                List<ArcInst> at = StitchFillJob.getArcsInGivenLayer(theCell.getArcs(), !horizontal, top, (String)entry.getKey(), netlist);
                ArrayList<PinsArcPair> pairs = new ArrayList<PinsArcPair>(2);
                for (PolyBase polyBase : list) {
                    FixpRectangle resultBnd = polyBase.getBounds2D();
                    ArcInst topA = StitchFillJob.getArcInstOverlappingWithArea(resultBnd, at, horizontal, true);
                    if (topA == null) continue;
                    EPoint insert = EPoint.fromLambda(((RectangularShape)resultBnd).getCenterX(), ((RectangularShape)resultBnd).getCenterY());
                    pairs.add(new PinsArcPair(topA, insert, resultBnd));
                }
                Collections.sort(pairs, pinsArcSort);
                List<ArcInst> ab = StitchFillJob.getArcsInGivenLayer(theCell.getArcs(), horizontal, bottom, (String)entry.getKey(), netlist);
                routeList.clear();
                for (PinsArcPair pair : pairs) {
                    ArcInst bottomA = StitchFillJob.getArcInstOverlappingWithArea(pair.cut, ab, horizontal, false);
                    if (bottomA != null) {
                        r = router.planRoute(theCell, bottomA, pair.topArc, pair.insert, null, ep, true, true, pair.cut, null, evenHor);
                        ab.remove(bottomA);
                        topLayers[0] = bottom;
                        topLayers[1] = top;
                        routeList.add(r);
                        continue;
                    }
                    if (!Job.getDebug()) continue;
                    StitchFillJob.getArcInstOverlappingWithArea(pair.cut, ab, horizontal, false);
                    System.out.println("AFG: It couldn't find bottom layer for " + pair.cut);
                }
                for (Route r3 : routeList) {
                    Router.createRouteNoJob(r3, theCell, arcsCreatedMap, nodesCreatedMap, ep);
                }
            }
        }
        Iterator<NodeInst> itNi = theCell.getNodes();
        while (itNi.hasNext()) {
            NodeInst ni = itNi.next();
            if (!ni.isCellInstance()) continue;
            ArrayList<String> doneExports = new ArrayList<String>();
            routeList.clear();
            SimpleWirer niRouter = new SimpleWirer(ep);
            Netlist netlist = theCell.getNetlist();
            Iterator<Export> itE = ni.getExports();
            while (itE.hasNext()) {
                Export ex = itE.next();
                String string = ex.getName();
                rootName = StitchFillJob.extractRootName(string);
                boolean getAllPossibleConnection = true;
                if (!getAllPossibleConnection && doneExports.contains(rootName)) continue;
                PrimitiveNode n2 = ex.getBasePort().getParent();
                Layer layer = n2.getLayerIterator().next();
                PortInst pi = ex.getOriginalPort();
                PortProto epi = pi.getPortProto();
                EPoint ePoint = pi.getCenter();
                NodeProto np = epi.getParent();
                if (!(np instanceof Cell)) continue;
                Cell c = (Cell)np;
                Netlist netl = c.getNetlist();
                Network jExp = netl.getNetwork((Export)epi, 0);
                Cell jCell = jExp.getParent();
                SearchInHierarchy searchElems = new SearchInHierarchy(jExp, layer);
                HierarchyEnumerator.enumerateCell(jCell, VarContext.globalContext, (HierarchyEnumerator.Visitor)searchElems);
                Area expA = searchElems.expA;
                FixpRectangle bestCut = null;
                ArcInst bestArc = null;
                EPoint bestCenter = null;
                double bestDistance = Double.MAX_VALUE;
                List<Network> netList = StitchFillJob.getNetworkFromName(netlist, rootName);
                Area[] theInters = new Area[]{new Area(), new Area()};
                Layer[] theLayers = new Layer[2];
                ArrayList<ArcInst> ab = new ArrayList<ArcInst>();
                for (Network jNet : netList) {
                    Iterator<ArcInst> itA = jNet.getArcs();
                    while (itA.hasNext()) {
                        ArcInst ai = itA.next();
                        Layer l = ai.getProto().getLayer(0);
                        if (l == layer) {
                            System.out.println("found in same layer " + layer.getName() + " in export " + ex.getName());
                            continue;
                        }
                        int level = Layer.getNeighborLevel(l, layer);
                        if (Math.abs(level) != 1) continue;
                        int pos = level == 1 ? 1 : 0;
                        Area bnd = new Area(ai.getBounds());
                        bnd.intersect(expA);
                        if (bnd.isEmpty()) continue;
                        assert (theLayers[pos] == null || theLayers[pos] == l);
                        theInters[pos].add(bnd);
                        theLayers[pos] = l;
                        ab.add(ai);
                    }
                }
                for (int i = 0; i < theLayers.length; ++i) {
                    Area a;
                    Layer l = theLayers[i];
                    if (l == null || (a = theInters[i]).isEmpty()) continue;
                    List<PolyBase> pols = Poly.getLoopsFromArea(a, l);
                    for (PolyBase p : pols) {
                        FixpRectangle cut = p.getBounds2D();
                        EPoint center = EPoint.fromLambda(((RectangularShape)cut).getCenterX(), ((RectangularShape)cut).getCenterY());
                        ArcInst ai = StitchFillJob.getArcInstOverlappingWithArea(cut, ab);
                        boolean horOrVer = DBMath.areEquals(((Point2D)center).getX(), ePoint.getX()) || DBMath.areEquals(((Point2D)center).getY(), ePoint.getY());
                        if (!horOrVer) continue;
                        if (getAllPossibleConnection) {
                            Route r = niRouter.planRoute(theCell, ai, pi, center, null, ep, true, true, cut, null);
                            routeList.add(r);
                            doneExports.add(rootName);
                            continue;
                        }
                        double dist = DBMath.distBetweenPoints(center, ePoint);
                        if (bestCenter != null && !DBMath.isLessThan(dist, bestDistance)) continue;
                        bestCenter = center;
                        bestCut = cut;
                        bestArc = ai;
                        bestDistance = dist;
                    }
                }
                if (getAllPossibleConnection || bestCut == null) continue;
                Route r = niRouter.planRoute(theCell, bestArc, pi, bestCenter, null, ep, true, true, bestCut, null);
                routeList.add(r);
                doneExports.add(rootName);
            }
            for (Route r : routeList) {
                Router.createRouteNoJob(r, theCell, arcsCreatedMap, nodesCreatedMap, ep);
            }
        }
        HashSet<Export> toDelete = new HashSet<Export>();
        HashMap<String, Export> inBottomLayer = new HashMap<String, Export>();
        Netlist netlist = theCell.getNetlist();
        HashMap<Network, Layer> maximumLayer = new HashMap<Network, Layer>();
        Iterator<Export> itE = theCell.getExports();
        while (itE.hasNext()) {
            exp = itE.next();
            n = exp.getBasePort().getParent();
            Network network = netlist.getNetwork(exp, 0);
            Layer l = (Layer)maximumLayer.get(network);
            Iterator<Layer> itL2 = n.getLayerIterator();
            while (itL2.hasNext()) {
                Layer lnew = itL2.next();
                if (l == null) {
                    l = lnew;
                    continue;
                }
                if (lnew.getFunction().getLevel() <= l.getFunction().getLevel()) continue;
                l = lnew;
            }
            maximumLayer.put(network, l);
        }
        itE = theCell.getExports();
        while (itE.hasNext()) {
            boolean bl;
            exp = itE.next();
            n = exp.getBasePort().getParent();
            boolean bl2 = false;
            rootName = StitchFillJob.extractRootName(exp.getName());
            Layer topLayer = (Layer)maximumLayer.get(netlist.getNetwork(exp, 0));
            int levelMax = topLayer.getFunction().getLevel();
            Iterator<Layer> itL3 = n.getLayerIterator();
            while (itL3.hasNext()) {
                boolean bl3;
                Layer l = itL3.next();
                int level = l.getFunction().getLevel();
                boolean bl4 = exportNames.isEmpty() ? level == levelMax || level == levelMax - 1 : (bl3 = exportNames.contains(l.getName()));
                if (bl3) {
                    bl = true;
                    continue;
                }
                inBottomLayer.put(rootName, exp);
            }
            if (bl) continue;
            toDelete.add(exp);
        }
        if (wideOption) {
            HashMap newExports = new HashMap();
            if (bottomLayer == null) {
                System.out.println("Error: No bottom layer found");
                return false;
            }
            boolean horizontal = StitchFillJob.isLayerHorizontal(bottomLayer, evenHor);
            assert (netlist == theCell.getNetlist());
            for (Map.Entry entry : inBottomLayer.entrySet()) {
                Export exp2 = (Export)entry.getValue();
                String rootName2 = StitchFillJob.extractRootName(exp2.getName());
                Network net = netlist.getNetwork(exp2, 0);
                List<ArcInst> arcs = StitchFillJob.getArcsInGivenLayer(net.getArcs(), horizontal, bottomLayer, null, null);
                Area area = (Area)totalAreas.get(rootName2);
                ArrayList<PinsArcPair> l = new ArrayList<PinsArcPair>();
                List<PolyBase> list = PolyBase.getPointsInArea(area, bottomLayer, false, false);
                if (list == null) continue;
                block23: for (PolyBase b : list) {
                    FixpRectangle resultBnd = b.getBounds2D();
                    EPoint insert = EPoint.fromLambda(((RectangularShape)resultBnd).getCenterX(), ((RectangularShape)resultBnd).getCenterY());
                    for (ArcInst ai : arcs) {
                        ERectangle bnd = ai.getBounds();
                        if (!bnd.contains(insert.getX(), insert.getY())) continue;
                        PinsArcPair split = new PinsArcPair(ai, insert, null);
                        l.add(split);
                        continue block23;
                    }
                }
                newExports.put(rootName2, l);
            }
            for (Map.Entry entry : newExports.entrySet()) {
                List pairs = (List)entry.getValue();
                for (PinsArcPair pair : pairs) {
                    SplitContainter split = StitchFillJob.splitArcAtPoint(pair.topArc, pair.insert, ep);
                    Export.newInst(theCell, split.splitPin.getPortInst(0), (String)entry.getKey(), ep, PortCharacteristic.UNKNOWN);
                }
            }
        }
        if (topLayers[0] != null || topLayers[1] != null) {
            theCell.killExports(toDelete);
        }
        ArrayList<Network> nets = new ArrayList<Network>();
        Iterator<Network> itN = theCell.getNetlist().getNetworks();
        while (itN.hasNext()) {
            nets.add(itN.next());
        }
        HashMap<Export, String> map = new HashMap<Export, String>();
        for (Network network : nets) {
            String rootName3;
            String name;
            if (!network.isExported() || (name = network.getName()).equals(rootName3 = StitchFillJob.extractRootName(name))) continue;
            Export exp3 = network.getExports().next();
            map.put(exp3, rootName3);
        }
        for (Map.Entry entry : map.entrySet()) {
            ((Export)entry.getKey()).rename((String)entry.getValue());
        }
        return true;
    }

    private static ArcInst getArcInstOverlappingWithArea(Rectangle2D resultBnd, List<ArcInst> at) {
        new Area(resultBnd);
        for (ArcInst ai : at) {
            ERectangle r = ai.getBounds();
            if (!r.intersects(resultBnd)) continue;
            return ai;
        }
        return null;
    }

    private static ArcInst getArcInstOverlappingWithArea(Rectangle2D resultBnd, List<ArcInst> at, boolean horizontal, boolean topLayer) {
        Area topArea = new Area(resultBnd);
        for (ArcInst ai : at) {
            ERectangle r = ai.getBounds();
            if (!r.intersects(resultBnd)) continue;
            Area rArea = new Area(r);
            rArea.intersect(topArea);
            Rectangle2D rect = rArea.getBounds2D();
            boolean validArc = horizontal && topLayer || !horizontal && !topLayer ? DBMath.areEquals(rect.getWidth(), ((RectangularShape)r).getWidth()) : DBMath.areEquals(rect.getHeight(), ((RectangularShape)r).getHeight());
            if (!validArc) continue;
            return ai;
        }
        return null;
    }

    private static List<Network> getNetworkFromName(Netlist netlist, String rootName) {
        ArrayList<Network> list = new ArrayList<Network>();
        Iterator<Network> it = netlist.getNetworks();
        while (it.hasNext()) {
            Network net = it.next();
            if (!net.getName().startsWith(rootName)) continue;
            list.add(net);
        }
        return list;
    }

    private static boolean isLayerHorizontal(Layer layer, boolean evenH) {
        if (layer == null || layer.getFunction() == null) {
            System.out.println(" ");
        }
        int metalNumber = layer.getFunction().getLevel();
        return evenH && metalNumber % 2 == 0 || !evenH && metalNumber % 2 == 1;
    }

    private static List<ArcInst> getArcsInGivenLayer(Iterator<ArcInst> itAi, boolean horizontal, Layer layer, String exportName, Netlist netlist) {
        ArrayList<ArcInst> arcs = new ArrayList<ArcInst>();
        while (itAi.hasNext()) {
            Layer l;
            ArcInst ai = itAi.next();
            if (!StitchFillJob.isArcAligned(ai, horizontal) || (l = ai.getProto().getLayer(0)) != layer) continue;
            if (exportName != null) {
                Network jNet = netlist.getNetwork(ai, 0);
                Iterator<Export> itE = jNet.getExports();
                if (!itE.hasNext()) {
                    if (!Job.getDebug()) continue;
                    System.out.println("AFG: No export name associated to ArcInst '" + ai.getName() + "'");
                    continue;
                }
                Export exp = itE.next();
                String expName = StitchFillJob.extractRootName(exp.getName());
                if (!expName.equals(exportName)) continue;
            }
            arcs.add(ai);
        }
        return arcs;
    }

    private static boolean isArcAligned(ArcInst ai, boolean horizontal) {
        EPoint head = ai.getHeadLocation();
        EPoint tail = ai.getTailLocation();
        if (horizontal) {
            return DBMath.areEquals(head.getY(), tail.getY());
        }
        return DBMath.areEquals(head.getX(), tail.getX());
    }

    private static String extractRootName(String name) {
        int index = name.indexOf("_");
        if (index != -1) {
            name = name.substring(0, index);
        }
        return name;
    }

    private static String getExportRootName(ArcInst ai, Netlist netlist) {
        Network jNet = netlist.getNetwork(ai, 0);
        if (jNet == null) {
            return null;
        }
        assert (jNet != null);
        Iterator<String> exportNames = jNet.getExportedNames();
        if (!exportNames.hasNext()) {
            return null;
        }
        return StitchFillJob.extractRootName(exportNames.next());
    }

    private static SplitContainter splitArcAtPoint(ArcInst ai, EPoint insert, EditingPreferences ep) {
        ArcProto ap = ai.getProto();
        PrimitiveNode np = ap.findPinProto();
        if (np == null) {
            return null;
        }
        NodeInst ni = NodeInst.makeInstance(np, ep, insert, np.getDefWidth(ep), np.getDefHeight(ep), ai.getParent());
        if (ni == null) {
            System.out.println("Cannot create pin " + np.describe(true));
            return null;
        }
        SplitContainter container = new SplitContainter();
        container.splitPin = ni;
        PortInst pi = ni.getOnlyPortInst();
        PortInst headPort = ai.getHeadPortInst();
        PortInst tailPort = ai.getTailPortInst();
        EPoint headPt = ai.getHeadLocation();
        EPoint tailPt = ai.getTailLocation();
        double width = ai.getLambdaBaseWidth();
        ArcInst newAi1 = ArcInst.makeInstanceBase(ap, ep, width, headPort, pi, headPt, insert, null);
        ArcInst newAi2 = ArcInst.makeInstanceBase(ap, ep, width, pi, tailPort, insert, tailPt, null);
        newAi1.setHeadNegated(ai.isHeadNegated());
        newAi1.setHeadExtended(ai.isHeadExtended());
        newAi1.setHeadArrowed(ai.isHeadArrowed());
        newAi1.setTailNegated(ai.isTailNegated());
        newAi1.setTailExtended(ai.isTailExtended());
        newAi1.setTailArrowed(ai.isTailArrowed());
        newAi2.setHeadNegated(ai.isHeadNegated());
        newAi2.setHeadExtended(ai.isHeadExtended());
        newAi2.setHeadArrowed(ai.isHeadArrowed());
        newAi2.setTailNegated(ai.isTailNegated());
        newAi2.setTailExtended(ai.isTailExtended());
        newAi2.setTailArrowed(ai.isTailArrowed());
        ai.kill();
        return container;
    }

    private static boolean isLeftTop(Point2D p1, Point2D p2) {
        if (DBMath.areEquals(p1.getX(), p2.getX())) {
            return !DBMath.isGreaterThan(p1.getY(), p2.getY());
        }
        if (DBMath.areEquals(p1.getY(), p2.getY())) {
            return !DBMath.isGreaterThan(p1.getX(), p2.getX());
        }
        return !DBMath.isGreaterThan(p1.getX(), p2.getX());
    }

    private class TileInfo {
        int x;
        int y;

        TileInfo(int a, int b) {
            this.x = a;
            this.y = b;
        }
    }

    private static class PinsArcPair {
        private ArcInst topArc;
        private EPoint insert;
        private Rectangle2D cut;

        PinsArcPair(ArcInst topA, EPoint point, Rectangle2D c) {
            this.topArc = topA;
            this.insert = point;
            this.cut = c;
        }
    }

    private static class PinsArcPairSort
    implements Comparator<PinsArcPair> {
        private PinsArcPairSort() {
        }

        @Override
        public int compare(PinsArcPair l1, PinsArcPair l2) {
            EPoint p2 = l2.insert;
            EPoint p1 = l1.insert;
            return StitchFillJob.isLeftTop(p2, p1) ? 1 : -1;
        }
    }

    private static class SearchInHierarchy
    extends HierarchyEnumerator.Visitor {
        Layer layer;
        Layer.Function.Set layerSet;
        Network jExp;
        Area expA;

        SearchInHierarchy(Network exp, Layer l) {
            this.jExp = exp;
            this.layer = l;
            this.layerSet = new Layer.Function.Set(l);
            this.expA = new Area();
        }

        @Override
        public boolean enterCell(HierarchyEnumerator.CellInfo info) {
            Cell cell = info.getCell();
            FixpTransform rTrans = info.getTransformToRoot();
            Iterator<ArcInst> it = cell.getArcs();
            while (it.hasNext()) {
                ArcInst ai = it.next();
                Network aNet = info.getNetlist().getNetwork(ai, 0);
                boolean found = HierarchyEnumerator.searchInExportNetwork(aNet, info, this.jExp);
                if (!found) continue;
                Technology tech = ai.getProto().getTechnology();
                for (Poly poly : tech.getShapeOfArc(ai)) {
                    Layer l = poly.getLayer();
                    if (l != this.layer) continue;
                    poly.transform(rTrans);
                    this.expA.add(new Area(poly.getBounds2D()));
                }
            }
            return true;
        }

        @Override
        public void exitCell(HierarchyEnumerator.CellInfo info) {
        }

        @Override
        public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
            NodeInst ni = no.getNodeInst();
            if (ni.isCellInstance()) {
                return true;
            }
            if (NodeInst.isSpecialNode(ni)) {
                return true;
            }
            boolean found = false;
            Iterator<PortInst> pIt = ni.getPortInsts();
            while (pIt.hasNext()) {
                PortInst pi = pIt.next();
                Network nNet = info.getNetlist().getNetwork(no, pi.getPortProto(), 0);
                found = HierarchyEnumerator.searchInExportNetwork(nNet, info, this.jExp);
                if (!found) continue;
                break;
            }
            if (found) {
                Technology tech = ni.getProto().getTechnology();
                Poly[] nodeInstPolyList = tech.getShapeOfNode(ni, true, true, this.layerSet);
                assert (nodeInstPolyList.length < 2);
                if (nodeInstPolyList.length == 1) {
                    FixpTransform rTrans = info.getTransformToRoot();
                    Poly poly = nodeInstPolyList[0];
                    poly.transform(rTrans);
                    this.expA.add(new Area(poly.getBounds2D()));
                }
            }
            return true;
        }
    }

    private static class SplitContainter {
        NodeInst splitPin;

        private SplitContainter() {
        }
    }
}

