/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.projectSettings;

import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.text.Setting;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.projectSettings.ProjSettingsNode;
import com.sun.electric.util.TextUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ProjSettings {
    private static ProjSettings settings;
    private ProjSettingsNode rootNode = new ProjSettingsNode();
    private File lastProjectSettingsFile = null;
    private static final String entry = "e";

    public static ProjSettings getSettings() {
        return settings;
    }

    public void putValue(String xmlPath, Object value) {
        int pos;
        ProjSettingsNode node = this.rootNode;
        while ((pos = xmlPath.indexOf(46)) >= 0) {
            String key = xmlPath.substring(0, pos);
            node = node.getNode(key);
            xmlPath = xmlPath.substring(pos + 1);
        }
        node.data.put(xmlPath, value);
    }

    public Object getValue(String xmlPath) {
        int pos;
        ProjSettingsNode node = this.rootNode;
        while ((pos = xmlPath.indexOf(46)) >= 0) {
            String key = xmlPath.substring(0, pos);
            Object n = node.data.get(key);
            if (!(n instanceof ProjSettingsNode)) {
                return null;
            }
            node = (ProjSettingsNode)n;
            xmlPath = xmlPath.substring(pos + 1);
        }
        Object v = node.data.get(xmlPath);
        if (v instanceof ProjSettingsNode) {
            return null;
        }
        return v;
    }

    public void putAllSettings(Map<Setting, Object> settings) {
        for (Map.Entry<Setting, Object> e : settings.entrySet()) {
            Setting setting = e.getKey();
            Object value = e.getValue();
            this.putValue(setting.getXmlPath(), value);
        }
    }

    public static void writeSettings(Map<Setting, Object> addSettings, File file) {
        if (settings == null) {
            settings = new ProjSettings();
        }
        settings.putAllSettings(addSettings);
        settings.write(file.getPath(), ProjSettings.settings.rootNode);
    }

    public static File getLastProjectSettingsFile() {
        return settings != null ? ProjSettings.settings.lastProjectSettingsFile : null;
    }

    public static void readSettings(File file, EDatabase database, boolean allowOverride, boolean disablePopups) {
        File oldFile = ProjSettings.getLastProjectSettingsFile();
        ProjSettings newSettings = ProjSettings.read(file);
        if (newSettings == null) {
            return;
        }
        System.out.println("Read Project Preferences from " + file);
        if (settings == null) {
            allowOverride = true;
        }
        if (newSettings.commit(database, allowOverride)) {
            if (!disablePopups) {
                String message = "Warning: Project Preferences conflicts;" + (allowOverride ? "" : " ignoring new settings.") + " See messages window";
                Job.getUserInterface().showInformationMessage(message, "Project Preferences Conflict");
            }
            String oldFileName = "Stored Settings";
            if (oldFile != null) {
                oldFileName = oldFile.getPath();
            }
            if (oldFileName.equals(file.getPath())) {
                System.out.println("Project Preferences conflicts found in: " + oldFileName);
            } else {
                System.out.println("Project Preferences conflicts found: " + oldFileName + " vs " + file.getPath());
            }
        }
        settings = newSettings;
    }

    private boolean commit(EDatabase database, boolean allowOverride) {
        Setting.SettingChangeBatch commitBatch = new Setting.SettingChangeBatch();
        for (Map.Entry<Setting, Object> e : database.getSettings().entrySet()) {
            Setting setting = e.getKey();
            Object oldVal = e.getValue();
            Object xmlVal = this.getValue(setting.getXmlPath());
            if (xmlVal == null) {
                xmlVal = setting.getFactoryValue();
            }
            if (xmlVal.equals(oldVal)) continue;
            if (xmlVal.getClass() != oldVal.getClass()) {
                System.out.println("Setting type mismatch " + setting);
                continue;
            }
            commitBatch.add(setting, xmlVal);
            if (xmlVal instanceof Double && ((Double)xmlVal).floatValue() == ((Double)oldVal).floatValue()) continue;
            if (allowOverride) {
                System.out.println("Warning: Setting \"" + setting.getPrefName() + "\" set to \"" + xmlVal + "\", overrides current value of \"" + oldVal + "\"");
                continue;
            }
            System.out.println("Warning: Setting \"" + setting.getPrefName() + "\" retains current value of \"" + oldVal + "\", while ignoring projectsettings.xml value of \"" + xmlVal + "\"");
        }
        if (allowOverride) {
            database.implementSettingChanges(commitBatch);
        }
        return !commitBatch.changesForSettings.isEmpty();
    }

    public static void exportSettings() {
        File outputFile = new File(FileType.LIBRARYFORMATS.getGroupPath(), "projsettings.xml");
        String ofile = OpenFile.chooseOutputFile(FileType.XML, "Export Project Preferences", outputFile.getPath());
        if (ofile == null) {
            return;
        }
        outputFile = new File(ofile);
        ProjSettings.writeSettings(EDatabase.clientDatabase().getSettings(), outputFile);
    }

    public static void importSettings() {
        String ifile = OpenFile.chooseInputFile(FileType.XML, "Import Project Preferences", false, FileType.LIBRARYFORMATS.getGroupPath(), false, null);
        if (ifile == null) {
            return;
        }
        new ImportSettingsJob(ifile);
    }

    public void write(String file) {
        this.write(file, this.rootNode);
    }

    private void write(String file, ProjSettingsNode node) {
        File ofile = new File(file);
        Writer wr = new Writer(ofile);
        if (wr.write("ProjectSettings", node)) {
            System.out.println("Wrote Project Preferences to " + file);
            this.lastProjectSettingsFile = ofile;
        }
        wr.close();
    }

    private static String replaceSpecialChars(String str) {
        str = str.replace("&", "&amp;");
        str = str.replace("=", "&eq;");
        str = str.replace(">", "&gt;");
        str = str.replace("<", "&lt;");
        str = str.replace("'", "&apos;");
        str = str.replace("\"", "&quot;");
        str = str.replace("\n", "&#xA;");
        return str;
    }

    public static ProjSettings read(File file) {
        Reader rd = new Reader(file);
        return rd.read();
    }

    public static String describeContext(Stack<String> context) {
        StringBuffer buf = new StringBuffer();
        boolean first = true;
        for (String name : context) {
            if (first) {
                first = false;
            } else {
                buf.append(".");
            }
            buf.append(name);
        }
        if (buf.length() == 0) {
            return "RootContext";
        }
        return buf.toString();
    }

    public static void main(String[] args) {
        ProjSettings.test();
    }

    public static void test() {
    }

    public static class ImportSettingsJob
    extends Job {
        private String fileName;

        public ImportSettingsJob(String fileName) {
            super("Import Settings", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.fileName = fileName;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            ProjSettings.readSettings(new File(this.fileName), this.getDatabase(), true, false);
            return true;
        }

        @Override
        public void terminateOK() {
            this.getDatabase().getEnvironment().saveToPreferences();
        }
    }

    private static class Writer {
        private File file;
        PrintWriter out;
        private int indent;
        private static final int indentVal = 4;
        Set<Object> visited = new HashSet<Object>();

        private Writer(File file) {
            this.file = file;
        }

        private boolean write(String nodeName, ProjSettingsNode node) {
            this.out = new PrintWriter(new BufferedOutputStream(System.out));
            if (this.file != null) {
                try {
                    this.out = new PrintWriter(new BufferedOutputStream(new FileOutputStream(this.file)));
                }
                catch (IOException e) {
                    System.out.println("Error opening " + this.file + " for write: " + e.getMessage());
                    this.file = null;
                    return false;
                }
            }
            this.writeNode(nodeName, node);
            return true;
        }

        private void prIndent(String msg) {
            for (int i = 0; i < this.indent * 4; ++i) {
                this.out.print(" ");
            }
            this.out.println(msg);
        }

        private void writeNode(String name, ProjSettingsNode node) {
            if (this.visited.contains(node)) {
                System.out.println("ERROR: recursive loop in Project Preferences; ignoring second instantiation of ProjSettingsNode \"" + name + "\".");
                return;
            }
            this.visited.add(node);
            String classDef = "";
            if (node.getKeys().size() != 0) {
                this.prIndent("<node key=\"" + name + "\"" + classDef + ">");
                ++this.indent;
                for (String key : node.getKeys()) {
                    this.writeSetting(key, node.get(key));
                }
                --this.indent;
                this.prIndent("</node>");
            }
        }

        private void writeSetting(String key, Object value) {
            if (value instanceof ProjSettingsNode) {
                ProjSettingsNode node = (ProjSettingsNode)value;
                this.writeNode(key, node);
            } else {
                this.writeValue(key, value);
            }
        }

        private void writeValue(String key, Object value) {
            if (value instanceof Integer) {
                this.prIndent("<e key=\"" + key + "\"\t int=\"" + value.toString() + "\" />");
            } else if (value instanceof Double) {
                this.prIndent("<e key=\"" + key + "\"\t double=\"" + value.toString() + "\" />");
            } else if (value instanceof Long) {
                this.prIndent("<e key=\"" + key + "\"\t long=\"" + value.toString() + "\" />");
            } else if (value instanceof Boolean) {
                this.prIndent("<e key=\"" + key + "\"\t boolean=\"" + value.toString() + "\" />");
            } else if (value instanceof String) {
                String str = (String)value;
                this.prIndent("<e key=\"" + key + "\"\t string=\"" + ProjSettings.replaceSpecialChars(str) + "\" />");
            } else {
                this.prIndent("<e key=\"" + key + "\"\t string=\"" + value + "\" />");
            }
        }

        private void close() {
            if (this.file != null) {
                this.out.close();
            }
        }
    }

    private static class Reader
    extends DefaultHandler {
        private URL url;
        private Stack<ProjSettingsNode> context;
        private Locator locator;
        private ProjSettings settings = new ProjSettings();
        private static final boolean DEBUG = false;

        private Reader(File file) {
            this.url = TextUtils.makeURLToFile(file.getPath());
            this.settings.lastProjectSettingsFile = file;
            this.context = new Stack();
            this.locator = null;
        }

        private ProjSettings read() {
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setValidating(true);
                factory.setNamespaceAware(true);
                URLConnection conn = this.url.openConnection();
                InputStream is = conn.getInputStream();
                LineNumberReader readShort = new LineNumberReader(new InputStreamReader(is, "UTF-8"));
                String line = readShort.readLine();
                if (!line.contains("<node")) {
                    System.out.println("File '" + this.url + "' is not a Project Preferences File");
                    return null;
                }
                readShort.close();
                conn = this.url.openConnection();
                is = conn.getInputStream();
                factory.newSAXParser().parse(is, (DefaultHandler)this);
                return this.settings;
            }
            catch (IOException e) {
                System.out.println("Error reading file " + this.url.toString() + ": " + e.getMessage());
            }
            catch (SAXParseException e) {
                System.out.println("Error parsing file " + this.url.toString() + " on line " + e.getLineNumber() + ", column " + e.getColumnNumber() + ": " + e.getMessage());
            }
            catch (ParserConfigurationException e) {
                System.out.println("Configuration error reading file " + this.url.toString() + ": " + e.getMessage());
            }
            catch (SAXException e) {
                System.out.println("Exception reading file " + this.url.toString() + ": " + e.getMessage());
            }
            return null;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            String key = attributes.getValue("key");
            if (key == null) {
                throw this.parseException("Entry " + qName + " is missing \"key\" attribute");
            }
            if (qName.equals("node")) {
                if (this.context.isEmpty()) {
                    this.context.push(this.settings.rootNode);
                } else {
                    ProjSettingsNode node = this.context.peek().getNode(key);
                    if (node == null) {
                        System.out.println("Error: No Project Preferences Node named " + key + " in Electric");
                    } else {
                        this.context.push(node);
                    }
                }
            } else if (qName.equals(ProjSettings.entry)) {
                if (this.context.isEmpty()) {
                    throw this.parseException("No node for key-value pair " + qName);
                }
                ProjSettingsNode currentNode = this.context.peek();
                String valueStr = null;
                Object value = null;
                try {
                    valueStr = attributes.getValue("string");
                    if (valueStr != null) {
                        value = valueStr;
                    } else {
                        valueStr = attributes.getValue("int");
                        if (valueStr != null) {
                            value = Integer.valueOf(valueStr);
                        } else {
                            valueStr = attributes.getValue("double");
                            if (valueStr != null) {
                                value = Double.valueOf(valueStr);
                            } else {
                                valueStr = attributes.getValue("boolean");
                                if (valueStr != null) {
                                    value = Boolean.valueOf(valueStr);
                                } else {
                                    valueStr = attributes.getValue("long");
                                    if (valueStr != null) {
                                        value = Long.valueOf(valueStr);
                                    } else {
                                        System.out.println("Error: Unsupported value for key " + key + ", at line " + this.locator.getLineNumber() + ": must be string, int, double, boolean, or long");
                                    }
                                }
                            }
                        }
                    }
                }
                catch (NumberFormatException e) {
                    System.out.println("Error converting " + valueStr + " to a number at line " + this.locator.getLineNumber() + ": " + e.getMessage());
                }
                if (value != null) {
                    currentNode.put(key, value);
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equals("node")) {
                if (this.context.isEmpty()) {
                    throw this.parseException("Empty context, too many closing </> brackets");
                }
                this.context.pop();
            }
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        private SAXParseException parseException(String msg) {
            return new SAXParseException(msg, this.locator);
        }
    }
}

