/*
 * Decompiled with CFR 0.152.
 */
package javax.security.sasl;

import java.security.Provider;
import java.security.Security;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;

public class Sasl {
    public static final String QOP = "javax.security.sasl.qop";
    public static final String STRENGTH = "javax.security.sasl.strength";
    public static final String SERVER_AUTH = "javax.security.sasl.server.authentication";
    public static final String MAX_BUFFER = "javax.security.sasl.maxbuffer";
    public static final String RAW_SEND_SIZE = "javax.security.sasl.rawsendsize";
    public static final String POLICY_NOPLAINTEXT = "javax.security.sasl.policy.noplaintext";
    public static final String POLICY_NOACTIVE = "javax.security.sasl.policy.noactive";
    public static final String POLICY_NODICTIONARY = "javax.security.sasl.policy.nodictionary";
    public static final String POLICY_NOANONYMOUS = "javax.security.sasl.policy.noanonymous";
    public static final String POLICY_FORWARD_SECRECY = "javax.security.sasl.policy.forward";
    public static final String POLICY_PASS_CREDENTIALS = "javax.security.sasl.policy.credentials";
    public static final String REUSE = "javax.security.sasl.reuse";
    private static final String CLIENT_FACTORY_SVC = "SaslClientFactory.";
    private static final String SERVER_FACTORY_SVC = "SaslServerFactory.";
    private static final String ALIAS = "Alg.Alias.";

    private Sasl() {
    }

    public static SaslClient createSaslClient(String[] mechanisms, String authorizationID, String protocol, String serverName, Map props, CallbackHandler cbh) throws SaslException {
        if (mechanisms == null) {
            return null;
        }
        Provider[] providers = Security.getProviders();
        if (providers == null || providers.length == 0) {
            return null;
        }
        SaslClient result = null;
        SaslClientFactory factory = null;
        for (int i = 0; i < mechanisms.length; ++i) {
            String m = mechanisms[i];
            if (m == null) continue;
            for (int j = 0; j < providers.length; ++j) {
                String upper;
                Provider p = providers[j];
                if (p == null) continue;
                String clazz = ((Properties)p).getProperty(CLIENT_FACTORY_SVC + m);
                if (clazz == null && (clazz = ((Properties)p).getProperty(CLIENT_FACTORY_SVC + (upper = m.toUpperCase()))) == null) {
                    String alias = ((Properties)p).getProperty("Alg.Alias.SaslClientFactory." + m);
                    if (alias == null && (alias = ((Properties)p).getProperty("Alg.Alias.SaslClientFactory." + upper)) == null) continue;
                    clazz = ((Properties)p).getProperty(CLIENT_FACTORY_SVC + alias);
                }
                if (clazz == null) continue;
                clazz = clazz.trim();
                try {
                    result = null;
                    factory = (SaslClientFactory)Class.forName(clazz).newInstance();
                    result = factory.createSaslClient(mechanisms, authorizationID, protocol, serverName, props, cbh);
                }
                catch (ClassCastException ignored) {
                }
                catch (ClassNotFoundException ignored) {
                }
                catch (InstantiationException ignored) {
                }
                catch (IllegalAccessException ignored) {
                    // empty catch block
                }
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    public static Enumeration getSaslClientFactories() {
        Iterator<Object> it;
        Vector<SaslClientFactory> result = new Vector<SaslClientFactory>();
        HashSet<String> names = new HashSet<String>();
        Provider[] providers = Security.getProviders();
        if (providers == null) {
            block5: for (int i = 0; i < providers.length; ++i) {
                Provider p = providers[i];
                it = ((Hashtable)p).keySet().iterator();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    if (!key.startsWith(CLIENT_FACTORY_SVC) || key.indexOf(" ") != -1) continue;
                    names.add(((Properties)p).getProperty(key));
                    continue block5;
                }
            }
        }
        it = names.iterator();
        while (it.hasNext()) {
            String c = (String)it.next();
            try {
                SaslClientFactory f = (SaslClientFactory)Class.forName(c).newInstance();
                if (f == null) continue;
                result.add(f);
            }
            catch (ClassCastException ignored) {
            }
            catch (ClassNotFoundException ignored) {
            }
            catch (InstantiationException ignored) {
            }
            catch (IllegalAccessException ignored) {}
        }
        return result.elements();
    }

    public static SaslServer createSaslServer(String mechanism, String protocol, String serverName, Map props, CallbackHandler cbh) throws SaslException {
        if (mechanism == null) {
            return null;
        }
        Provider[] providers = Security.getProviders();
        if (providers == null || providers.length == 0) {
            return null;
        }
        SaslServer result = null;
        SaslServerFactory factory = null;
        for (int j = 0; j < providers.length; ++j) {
            String upper;
            Provider p = providers[j];
            if (p == null) continue;
            String clazz = ((Properties)p).getProperty(SERVER_FACTORY_SVC + mechanism);
            if (clazz == null && (clazz = ((Properties)p).getProperty(SERVER_FACTORY_SVC + (upper = mechanism.toUpperCase()))) == null) {
                String alias = ((Properties)p).getProperty("Alg.Alias.SaslServerFactory." + mechanism);
                if (alias == null && (alias = ((Properties)p).getProperty("Alg.Alias.SaslServerFactory." + upper)) == null) continue;
                clazz = ((Properties)p).getProperty(SERVER_FACTORY_SVC + alias);
            }
            if (clazz == null) continue;
            clazz = clazz.trim();
            try {
                result = null;
                factory = (SaslServerFactory)Class.forName(clazz).newInstance();
                result = factory.createSaslServer(mechanism, protocol, serverName, props, cbh);
            }
            catch (ClassCastException ignored) {
            }
            catch (ClassNotFoundException ignored) {
            }
            catch (InstantiationException ignored) {
            }
            catch (IllegalAccessException ignored) {
                // empty catch block
            }
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static Enumeration getSaslServerFactories() {
        Iterator<Object> it;
        Vector<SaslServerFactory> result = new Vector<SaslServerFactory>();
        HashSet<String> names = new HashSet<String>();
        Provider[] providers = Security.getProviders();
        if (providers == null) {
            block5: for (int i = 0; i < providers.length; ++i) {
                Provider p = providers[i];
                it = ((Hashtable)p).keySet().iterator();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    if (!key.startsWith(SERVER_FACTORY_SVC) || key.indexOf(" ") != -1) continue;
                    names.add(((Properties)p).getProperty(key));
                    continue block5;
                }
            }
        }
        it = names.iterator();
        while (it.hasNext()) {
            String c = (String)it.next();
            try {
                SaslServerFactory f = (SaslServerFactory)Class.forName(c).newInstance();
                if (f == null) continue;
                result.add(f);
            }
            catch (ClassCastException ignored) {
            }
            catch (ClassNotFoundException ignored) {
            }
            catch (InstantiationException ignored) {
            }
            catch (IllegalAccessException ignored) {}
        }
        return result.elements();
    }
}

