/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.ArrayType;
import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Method;
import gnu.bytecode.Type;

public class PrimType
extends Type {
    public PrimType(String nam, String sig, int siz, Class reflectClass) {
        super(nam, sig);
        this.size = siz;
        this.reflectClass = reflectClass;
        Type.registerTypeForClass(reflectClass, this);
    }

    protected PrimType(PrimType type) {
        super(type.this_name, type.signature);
        this.size = type.size;
        this.reflectClass = type.reflectClass;
    }

    public Object coerceFromObject(Object obj) {
        if (obj.getClass() == this.reflectClass) {
            return obj;
        }
        int sig1 = this.signature == null || this.signature.length() != 1 ? 32 : (int)this.signature.charAt(0);
        switch (sig1) {
            case 66: {
                return ((Number)obj).byteValue();
            }
            case 83: {
                return ((Number)obj).shortValue();
            }
            case 73: {
                return ((Number)obj).intValue();
            }
            case 74: {
                return ((Number)obj).longValue();
            }
            case 70: {
                return Float.valueOf(((Number)obj).floatValue());
            }
            case 68: {
                return ((Number)obj).doubleValue();
            }
            case 90: {
                return (boolean)((Boolean)obj);
            }
        }
        throw new ClassCastException("don't know how to coerce " + obj.getClass().getName() + " to " + this.getName());
    }

    public char charValue(Object value) {
        return ((Character)value).charValue();
    }

    public static boolean booleanValue(Object value) {
        return !(value instanceof Boolean) || (Boolean)value != false;
    }

    public void emitCoerceToObject(CodeAttr code) {
        Method method;
        String cname;
        char sig1 = this.getSignature().charAt(0);
        switch (sig1) {
            case 'Z': {
                ClassType clas = ClassType.make("java.lang.Boolean");
                code.emitIfIntNotZero();
                code.emitGetStatic(clas.getDeclaredField("TRUE"));
                code.emitElse();
                code.emitGetStatic(clas.getDeclaredField("FALSE"));
                code.emitFi();
                return;
            }
            case 'C': {
                cname = "java.lang.Character";
                break;
            }
            case 'B': {
                cname = "java.lang.Byte";
                break;
            }
            case 'S': {
                cname = "java.lang.Short";
                break;
            }
            case 'I': {
                cname = "java.lang.Integer";
                break;
            }
            case 'J': {
                cname = "java.lang.Long";
                break;
            }
            case 'F': {
                cname = "java.lang.Float";
                break;
            }
            case 'D': {
                cname = "java.lang.Double";
                break;
            }
            default: {
                cname = null;
            }
        }
        ClassType clas = ClassType.make(cname);
        Type[] args = new Type[]{this};
        if (code.getMethod().getDeclaringClass().classfileFormatVersion >= 0x310000) {
            method = clas.getDeclaredMethod("valueOf", args);
        } else {
            method = clas.getDeclaredMethod("<init>", args);
            code.emitNew(clas);
            code.emitDupX();
            code.emitSwap();
        }
        code.emitInvoke(method);
    }

    public void emitIsInstance(CodeAttr code) {
        int sig1;
        int n = sig1 = this.signature == null || this.signature.length() != 1 ? 32 : (int)this.signature.charAt(0);
        if (sig1 == 90) {
            javalangBooleanType.emitIsInstance(code);
        } else if (sig1 == 86) {
            code.emitPop(1);
            code.emitPushInt(1);
        } else {
            javalangNumberType.emitIsInstance(code);
        }
    }

    public void emitCoerceFromObject(CodeAttr code) {
        int sig1;
        int n = sig1 = this.signature == null || this.signature.length() != 1 ? 32 : (int)this.signature.charAt(0);
        if (sig1 == 90) {
            code.emitCheckcast(javalangBooleanType);
            code.emitInvokeVirtual(booleanValue_method);
        } else if (sig1 == 86) {
            code.emitPop(1);
        } else {
            code.emitCheckcast(javalangNumberType);
            if (sig1 == 73 || sig1 == 83 || sig1 == 66) {
                code.emitInvokeVirtual(intValue_method);
            } else if (sig1 == 74) {
                code.emitInvokeVirtual(longValue_method);
            } else if (sig1 == 68) {
                code.emitInvokeVirtual(doubleValue_method);
            } else if (sig1 == 70) {
                code.emitInvokeVirtual(floatValue_method);
            } else {
                super.emitCoerceFromObject(code);
            }
        }
    }

    public static int compare(PrimType type1, PrimType type2) {
        char sig2;
        char sig1 = type1.signature.charAt(0);
        if (sig1 == (sig2 = type2.signature.charAt(0))) {
            return 0;
        }
        if (sig1 == 'V') {
            return 1;
        }
        if (sig2 == 'V') {
            return -1;
        }
        if (sig1 == 'Z' || sig2 == 'Z') {
            return -3;
        }
        if (sig1 == 'C') {
            return type2.size > 2 ? -1 : -3;
        }
        if (sig2 == 'C') {
            return type1.size > 2 ? 1 : -3;
        }
        if (sig1 == 'D') {
            return 1;
        }
        if (sig2 == 'D') {
            return -1;
        }
        if (sig1 == 'F') {
            return 1;
        }
        if (sig2 == 'F') {
            return -1;
        }
        if (sig1 == 'J') {
            return 1;
        }
        if (sig2 == 'J') {
            return -1;
        }
        if (sig1 == 'I') {
            return 1;
        }
        if (sig2 == 'I') {
            return -1;
        }
        if (sig1 == 'S') {
            return 1;
        }
        if (sig2 == 'S') {
            return -1;
        }
        return -3;
    }

    public Type promotedType() {
        switch (this.signature.charAt(0)) {
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return Type.intType;
            }
        }
        return this.getImplementationType();
    }

    public int compare(Type other) {
        if (other instanceof PrimType) {
            return PrimType.compare(this, (PrimType)other);
        }
        if (!(other instanceof ClassType)) {
            if (other instanceof ArrayType) {
                return -3;
            }
            return PrimType.swappedCompareResult(other.compare(this));
        }
        char sig1 = this.signature.charAt(0);
        String otherName = other.getName();
        if (otherName == null) {
            return -1;
        }
        switch (sig1) {
            case 'V': {
                return 1;
            }
            case 'C': 
            case 'Z': {
                break;
            }
            case 'D': {
                if (otherName.equals("java.lang.Double") || otherName.equals("gnu.math.DFloNum")) {
                    return 0;
                }
                if (!otherName.equals("java.lang.Float")) break;
                return 1;
            }
            case 'F': {
                if (otherName.equals("java.lang.Double") || otherName.equals("gnu.math.DFloNum")) {
                    return -1;
                }
                if (!otherName.equals("java.lang.Float")) break;
                return 0;
            }
            case 'I': {
                if (otherName.equals("java.lang.Integer")) {
                    return 0;
                }
                if (otherName.equals("gnu.math.IntNum")) {
                    return -1;
                }
            }
            default: {
                if (!otherName.equals("java.lang.Double") && !otherName.equals("java.lang.Float") && !otherName.equals("gnu.math.DFloNum")) break;
                return -1;
            }
        }
        if (otherName.equals("java.lang.Object") || other == toStringType) {
            return -1;
        }
        return -2;
    }
}

