/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.lists.Consumer;
import gnu.mapping.Environment;
import gnu.mapping.OutPort;
import gnu.mapping.ThreadLocation;
import gnu.mapping.TtyInPort;
import gnu.text.LineBufferedReader;
import gnu.text.Printable;
import gnu.text.URI_utils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public class InPort
extends LineBufferedReader
implements Printable {
    private static InPort systemInPort = new TtyInPort(System.in, "<stdin>", OutPort.outInitial);
    public static final ThreadLocation inLocation = new ThreadLocation("in-default");

    public InPort(Reader in) {
        super(in);
    }

    public InPort(Reader in, Object name) {
        this(in);
        this.setName(name);
    }

    public InPort(InputStream in) {
        super(in);
    }

    public InPort(InputStream in, Object name) {
        this(in);
        this.setName(name);
    }

    public static Reader convertToReader(InputStream in, Object conv) {
        if (conv != null && conv != Boolean.TRUE) {
            String enc = conv == Boolean.FALSE ? "8859_1" : conv.toString();
            try {
                return new InputStreamReader(in, enc);
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException("unknown character encoding: " + enc);
            }
        }
        return new InputStreamReader(in);
    }

    public InPort(InputStream in, Object name, Object conv) throws UnsupportedEncodingException {
        this(InPort.convertToReader(in, conv), name);
        if (conv == Boolean.FALSE) {
            try {
                this.setBuffer(new char[2048]);
            }
            catch (IOException ex) {}
        } else {
            this.setConvertCR(true);
        }
    }

    public static InPort inDefault() {
        return (InPort)inLocation.get();
    }

    public static void setInDefault(InPort in) {
        inLocation.set(in);
    }

    public static boolean uriSchemeSpecified(String name) {
        int ulen = InPort.uriSchemeLength(name);
        if (ulen == 1 && File.separatorChar == '\\') {
            char drive = name.charAt(0);
            return !(drive >= 'a' && drive <= 'z' || drive >= 'A' && drive <= 'Z');
        }
        return ulen > 1;
    }

    public static int uriSchemeLength(String uri) {
        int len = uri.length();
        for (int i = 0; i < len; ++i) {
            char ch = uri.charAt(i);
            if (ch == ':') {
                return i;
            }
            if (!(i == 0 ? !Character.isLetter(ch) : !Character.isLetterOrDigit(ch) && ch != '+' && ch != '-' && ch != '.')) continue;
            return -1;
        }
        return -1;
    }

    public static InPort openFile(Object fname) throws IOException {
        InputStream strm = URI_utils.getInputStream(fname);
        strm = new BufferedInputStream(strm);
        return InPort.openFile(strm, fname);
    }

    public static InPort openFile(InputStream strm, Object fname) throws UnsupportedEncodingException {
        return new InPort(strm, fname, Environment.user().get("port-char-encoding"));
    }

    public void print(Consumer out) {
        out.write("#<input-port");
        String name = this.getName();
        if (name != null) {
            out.write(32);
            out.write(name);
        }
        out.write(62);
    }

    static {
        inLocation.setGlobal(systemInPort);
    }
}

