/*
 * Decompiled with CFR 0.152.
 */
package gnu.text;

import gnu.lists.FString;
import gnu.mapping.WrappedException;
import gnu.mapping.WrongType;
import gnu.text.Path;
import gnu.text.URIPath;
import gnu.text.URLPath;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;

public class FilePath
extends Path
implements Comparable {
    File file;
    String path;

    private FilePath(File file) {
        this.file = file;
        this.path = file.toString();
    }

    private FilePath(File file, String path) {
        this.file = file;
        this.path = path;
    }

    public static FilePath valueOf(String str) {
        String orig = str;
        return new FilePath(new File(str), orig);
    }

    public static FilePath valueOf(File file) {
        return new FilePath(file);
    }

    /*
     * WARNING - void declaration
     */
    public static FilePath coerceToFilePathOrNull(Object path) {
        void var1_1;
        String str;
        if (path instanceof FilePath) {
            return (FilePath)path;
        }
        if (path instanceof URIPath) {
            return FilePath.valueOf(new File(((URIPath)path).uri));
        }
        if (path instanceof URI) {
            return FilePath.valueOf(new File((URI)path));
        }
        if (path instanceof File) {
            return FilePath.valueOf((File)path);
        }
        if (path instanceof FString) {
            str = path.toString();
        } else if (path instanceof String) {
            str = (String)path;
        } else {
            return null;
        }
        return FilePath.valueOf((String)var1_1);
    }

    public static FilePath makeFilePath(Object arg) {
        FilePath path = FilePath.coerceToFilePathOrNull(arg);
        if (path == null) {
            throw new WrongType((String)null, -4, arg, "filepath");
        }
        return path;
    }

    public boolean isAbsolute() {
        return this == Path.userDirPath || this.file.isAbsolute();
    }

    public boolean isDirectory() {
        char last;
        int len;
        if (this.file.isDirectory()) {
            return true;
        }
        return !this.file.exists() && (len = this.path.length()) > 0 && ((last = this.path.charAt(len - 1)) == '/' || last == File.separatorChar);
    }

    public long getLastModified() {
        return this.file.lastModified();
    }

    public boolean exists() {
        return this.file.exists();
    }

    public long getContentLength() {
        long length = this.file.length();
        return length == 0L && !this.file.exists() ? -1L : length;
    }

    public String getPath() {
        return this.file.getPath();
    }

    public String getLast() {
        return this.file.getName();
    }

    public Path getParent() {
        return FilePath.valueOf(this.file.getParentFile());
    }

    public int compareTo(FilePath path) {
        return this.file.compareTo(path.file);
    }

    public int compareTo(Object obj) {
        return this.compareTo((FilePath)obj);
    }

    public boolean equals(Object obj) {
        return obj instanceof FilePath && this.file.equals(((FilePath)obj).file);
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public String toString() {
        return this.path;
    }

    public File toFile() {
        return this.file;
    }

    public URL toURL() {
        if (this == Path.userDirPath) {
            return this.resolve("").toURL();
        }
        if (!this.isAbsolute()) {
            return this.getAbsolute().toURL();
        }
        try {
            return this.file.toURI().toURL();
        }
        catch (Throwable ex) {
            throw WrappedException.wrapIfNeeded(ex);
        }
    }

    private static URI toURI(File file) {
        try {
            if (file.isAbsolute()) {
                return file.toURI();
            }
            String fname = file.toString();
            char fileSep = File.separatorChar;
            if (fileSep != '/') {
                fname = fname.replace(fileSep, '/');
            }
            return new URI(null, null, fname, null);
        }
        catch (Throwable ex) {
            throw WrappedException.wrapIfNeeded(ex);
        }
    }

    public URI toURI() {
        if (this == Path.userDirPath) {
            return this.resolve("").toURI();
        }
        return FilePath.toURI(this.file);
    }

    public InputStream openInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    public OutputStream openOutputStream() throws IOException {
        return new FileOutputStream(this.file);
    }

    public String getScheme() {
        return this.isAbsolute() ? "file" : null;
    }

    public Path resolve(String relative) {
        if (Path.uriSchemeSpecified(relative)) {
            return URLPath.valueOf(relative);
        }
        File rfile = new File(relative);
        if (rfile.isAbsolute()) {
            return FilePath.valueOf(rfile);
        }
        char sep = File.separatorChar;
        if (sep != '/') {
            relative = relative.replace('/', sep);
        }
        File nfile = this == Path.userDirPath ? new File(System.getProperty("user.dir"), relative) : new File(this.isDirectory() ? this.file : this.file.getParentFile(), relative);
        return FilePath.valueOf(nfile);
    }

    public Path getCanonical() {
        try {
            File canon = this.file.getCanonicalFile();
            if (!canon.equals(this.file)) {
                return FilePath.valueOf(canon);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this;
    }
}

