/*
 * Decompiled with CFR 0.152.
 */
package gnu.jemacs.lang;

import gnu.bytecode.Type;
import gnu.commonlisp.lang.Lisp2;
import gnu.commonlisp.lang.UnwindProtect;
import gnu.commonlisp.lang.defun;
import gnu.commonlisp.lang.defvar;
import gnu.commonlisp.lang.function;
import gnu.commonlisp.lang.prog1;
import gnu.commonlisp.lang.setq;
import gnu.expr.Language;
import gnu.jemacs.buffer.SelfInsertCommand;
import gnu.jemacs.buffer.Signal;
import gnu.jemacs.lang.ELispReader;
import gnu.jemacs.lang.Print;
import gnu.jemacs.lang.SaveExcursion;
import gnu.jemacs.lang.While;
import gnu.jemacs.lang.defcustom;
import gnu.jemacs.lang.defgroup;
import gnu.jemacs.lang.lambda;
import gnu.kawa.functions.IsEq;
import gnu.kawa.functions.IsEqual;
import gnu.kawa.lispexpr.LangPrimType;
import gnu.kawa.lispexpr.ReadTable;
import gnu.kawa.reflect.InstanceOf;
import gnu.lists.AbstractFormat;
import gnu.mapping.CallContext;
import gnu.mapping.Environment;
import gnu.mapping.InPort;
import gnu.mapping.LocationEnumeration;
import gnu.math.IntNum;
import gnu.math.Numeric;
import gnu.text.Char;
import gnu.text.Lexer;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import java.io.IOException;
import javax.swing.text.Position;
import kawa.lang.Quote;
import kawa.repl;
import kawa.standard.Scheme;
import kawa.standard.begin;
import kawa.standard.fluid_let;
import kawa.standard.let;
import kawa.standard.not;

public class ELisp
extends Lisp2 {
    static boolean charIsInt = false;
    static final ELisp instance;
    public static final Environment elispEnvironment;
    static final AbstractFormat writeFormat;
    static final AbstractFormat displayFormat;
    LangPrimType booleanType;

    public static Object getCharacter(int n) {
        if (charIsInt) {
            return IntNum.make(n);
        }
        return Char.make((char)n);
    }

    public static Numeric asNumber(Object object2) {
        if (object2 instanceof Char) {
            return IntNum.make(((Char)object2).intValue());
        }
        if (object2 instanceof Position) {
            return IntNum.make(1 + ((Position)object2).getOffset());
        }
        return (Numeric)object2;
    }

    public static char asChar(Object object2) {
        if (object2 instanceof Char) {
            return ((Char)object2).charValue();
        }
        int n = object2 instanceof Numeric ? ((Numeric)object2).intValue() : (object2 instanceof Position ? ((Position)object2).getOffset() + 1 : -1);
        if (n < 0 || n > 65535) {
            throw new Signal("error", "not a character value");
        }
        return (char)n;
    }

    public Lexer getLexer(InPort inPort, SourceMessages sourceMessages) {
        return new ELispReader(inPort, sourceMessages);
    }

    public String getName() {
        return "Emacs-Lisp";
    }

    ELisp() {
        this.environ = elispEnvironment;
    }

    private void initELisp() {
        try {
            this.loadClass("gnu.commonlisp.lisp.PrimOps");
            this.loadClass("gnu.jemacs.lang.NumberOps");
            this.loadClass("gnu.jemacs.lang.MiscOps");
            this.defProcStFld("emacs", "gnu.jemacs.buffer.emacs");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.defSntxStFld("if", "gnu.jemacs.lang.MiscOps", "if");
        this.defProcStFld("invoke", "gnu.kawa.reflect.Invoke", "invoke");
        this.defProcStFld("+", "gnu.jemacs.lang.AddOp", "$Pl");
        this.defProcStFld("-", "gnu.jemacs.lang.AddOp", "$Mn");
        this.defProcStFld("/", "gnu.jemacs.lang.DivideOp", "$Sl");
        this.defProcStFld("=", "gnu.jemacs.lang.NumberCompare", "$Eq");
        this.defProcStFld("<", "gnu.jemacs.lang.NumberCompare", "$Ls");
        this.defProcStFld(">", "gnu.jemacs.lang.NumberCompare", "$Gr");
        this.defProcStFld("<=", "gnu.jemacs.lang.NumberCompare", "$Ls$Eq");
        this.defProcStFld(">=", "gnu.jemacs.lang.NumberCompare", "$Gr$Eq");
        this.defun("self-insert-command", (Object)new SelfInsertCommand());
        lambda lambda2 = new lambda();
        lambda2.setKeywords(this.getSymbol("&optional"), this.getSymbol("&rest"), this.getSymbol("&key"));
        lambda2.defaultDefault = nilExpr;
        this.defun("lambda", (Object)lambda2);
        this.defun("defun", (Object)new defun(lambda2));
        this.defun("function", (Object)new function(lambda2));
        this.defun("quote", (Object)Quote.plainQuote);
        this.defun("defgroup", (Object)new defgroup());
        this.defun("defcustom", (Object)new defcustom());
        this.defun("defvar", (Object)new defvar(false));
        this.defun("defconst", (Object)new defvar(true));
        this.defun("defsubst", (Object)new defun(lambda2));
        this.defun("setq", (Object)new setq());
        this.defun("prog1", (Object)prog1.prog1);
        this.defun("prog2", (Object)prog1.prog2);
        this.defun("progn", (Object)new begin());
        this.defun("while", (Object)new While());
        this.defun("unwind-protect", (Object)new UnwindProtect());
        this.defun("save-excursion", (Object)new SaveExcursion(false));
        this.defun("save-current-buffer", (Object)new SaveExcursion(true));
        this.defun("let", (Object)new fluid_let(false, nilExpr));
        this.defun("%let", (Object)let.let);
        this.defun("let*", (Object)new fluid_let(true, nilExpr));
        this.defProcStFld("concat", "kawa.lib.strings", "string$Mnappend");
        not not2 = new not(this);
        this.defun("not", (Object)not2);
        this.defun("null", (Object)not2);
        this.defun("eq", (Object)new IsEq(this, "eq"));
        this.defun("equal", (Object)new IsEqual(this, "equal"));
        this.defun("typep", (Object)new InstanceOf(this));
        this.defun("princ", (Object)displayFormat);
        this.defun("prin1", (Object)writeFormat);
        LocationEnumeration locationEnumeration = Scheme.builtin().enumerateAllLocations();
        while (locationEnumeration.hasMoreElements()) {
            this.importLocation(locationEnumeration.nextLocation());
        }
        try {
            this.loadClass("gnu.jemacs.lisp.primitives");
            this.loadClass("gnu.jemacs.buffer.emacs");
            this.loadClass("gnu.jemacs.lisp.simple");
            this.loadClass("gnu.jemacs.lisp.autoloads");
            this.loadClass("gnu.jemacs.lisp.keymap");
            this.loadClass("gnu.jemacs.lisp.editfns");
            this.loadClass("gnu.jemacs.lisp.keydefs");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public static ELisp getInstance() {
        return instance;
    }

    public static void registerEnvironment() {
        Language.setDefaults(instance);
    }

    public Object read(InPort inPort) throws IOException, SyntaxException {
        return ELispReader.readObject(inPort);
    }

    public AbstractFormat getFormat(boolean bl) {
        return bl ? writeFormat : displayFormat;
    }

    public Type getTypeFor(String string) {
        if (string == "t") {
            string = "java.lang.Object";
        } else if (string == "marker") {
            string = "gnu.jemacs.buffer.Marker";
        } else if (string == "buffer") {
            string = "gnu.jemacs.buffer.Buffer";
        } else if (string == "window") {
            string = "gnu.jemacs.buffer.Window";
        }
        return Scheme.string2Type(string);
    }

    public Type getTypeFor(Class clazz) {
        if (clazz.isPrimitive()) {
            String string = clazz.getName();
            if (string.equals("boolean")) {
                if (this.booleanType == null) {
                    this.booleanType = new LangPrimType(Type.boolean_type, this);
                }
                return this.booleanType;
            }
            return Scheme.getNamedType(string);
        }
        return Type.make(clazz);
    }

    public ReadTable createReadTable() {
        return ELispReader.createReadTable();
    }

    public static void readableChar(char c, StringBuffer stringBuffer, boolean bl) {
        if (bl && (c == '\\' || c == '\'' || c == '\"')) {
            stringBuffer.append('\\');
            stringBuffer.append(c);
        } else if (c > '\u007f') {
            stringBuffer.append("\\u");
            String string = Integer.toHexString(c);
            for (int i = string.length(); i < 4; ++i) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string);
        } else if (c >= ' ') {
            stringBuffer.append(c);
        } else if (c == '\t') {
            stringBuffer.append("\\t");
        } else if (c == '\r') {
            stringBuffer.append("\\r");
        } else if (c == '\n') {
            stringBuffer.append("\\n");
        } else {
            stringBuffer.append("\\0");
            stringBuffer.append(c >> 3 & 7);
            stringBuffer.append(c & 7);
        }
    }

    public static String readableString(Object object2) {
        String string = object2.toString();
        StringBuffer stringBuffer = new StringBuffer(200);
        for (int i = 0; i < string.length(); ++i) {
            ELisp.readableChar(string.charAt(i), stringBuffer, false);
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        repl.processArgs(new String[]{"--elisp"}, 0, 1);
        if (stringArray.length == 0) {
            stringArray = new String[]{"-e", "(emacs)", "--"};
        }
        repl.main(stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        elispEnvironment = Environment.make("elisp-environment");
        instance = new ELisp();
        instance.define("t", TRUE);
        instance.define("nil", FALSE);
        CallContext callContext = CallContext.getInstance();
        Environment environment = callContext.getEnvironmentRaw();
        try {
            callContext.setEnvironmentRaw(elispEnvironment);
            instance.initELisp();
        }
        finally {
            callContext.setEnvironmentRaw(environment);
        }
        writeFormat = new Print(true);
        displayFormat = new Print(false);
    }
}

