/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.Label;
import gnu.bytecode.TryState;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;

public class ExitableBlock {
    Variable resultVariable;
    CodeAttr code;
    Type resultType;
    TryState initialTryState;
    Label endLabel;
    ExitableBlock outer;
    TryState currentTryState;
    ExitableBlock nextCase;
    int switchCase;

    ExitableBlock(Type type, CodeAttr codeAttr, boolean bl) {
        this.code = codeAttr;
        this.resultType = type;
        this.initialTryState = codeAttr.try_stack;
        if (bl && type != null) {
            Variable variable;
            codeAttr.pushScope();
            this.resultVariable = variable = codeAttr.addLocal(type);
            codeAttr.emitStoreDefaultValue(variable);
            this.switchCase = ++codeAttr.exitableBlockLevel;
        }
        this.endLabel = new Label(codeAttr);
    }

    void finish() {
        if (this.resultVariable != null && this.code.reachableHere()) {
            this.code.emitStore(this.resultVariable);
        }
        this.endLabel.define(this.code);
        if (this.resultVariable != null) {
            this.code.emitLoad(this.resultVariable);
            this.code.popScope();
            --this.code.exitableBlockLevel;
        }
    }

    public void exit() {
        if (this.resultVariable != null) {
            this.code.emitStore(this.resultVariable);
        }
        this.exit(TryState.outerHandler(this.code.try_stack, this.initialTryState));
    }

    public Label exitIsGoto() {
        if (TryState.outerHandler(this.code.try_stack, this.initialTryState) == this.initialTryState) {
            return this.endLabel;
        }
        return null;
    }

    void exit(TryState tryState) {
        if (tryState == this.initialTryState) {
            this.code.emitGoto(this.endLabel);
        } else if (this.code.useJsr()) {
            TryState tryState2 = this.code.try_stack;
            while (tryState2 != this.initialTryState) {
                if (tryState2.finally_subr != null && tryState2.finally_ret_addr == null) {
                    this.code.emitJsr(tryState2.finally_subr);
                }
                tryState2 = tryState2.previous;
            }
            this.code.emitGoto(this.endLabel);
        } else {
            if (this.currentTryState == null) {
                this.linkCase(tryState);
            }
            if (tryState.saved_result != null) {
                this.code.emitStoreDefaultValue(tryState.saved_result);
            }
            this.code.emitPushInt(this.switchCase);
            this.code.emitPushNull();
            this.code.emitGoto(tryState.finally_subr);
        }
    }

    void linkCase(TryState tryState) {
        if (this.currentTryState != tryState) {
            if (this.currentTryState != null) {
                throw new Error();
            }
            this.nextCase = tryState.exitCases;
            tryState.exitCases = this;
            this.currentTryState = tryState;
        }
    }
}

