/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.Type;
import gnu.expr.CatchClause;
import gnu.expr.Compilation;
import gnu.expr.ConditionalTarget;
import gnu.expr.ConsumerTarget;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.IgnoreTarget;
import gnu.expr.StackTarget;
import gnu.expr.Target;
import gnu.mapping.CallContext;
import gnu.mapping.OutPort;

public class TryExp
extends Expression {
    Expression try_clause;
    CatchClause catch_clauses;
    Expression finally_clause;

    public final CatchClause getCatchClauses() {
        return this.catch_clauses;
    }

    public final Expression getFinallyClause() {
        return this.finally_clause;
    }

    public final void setCatchClauses(CatchClause catchClause) {
        this.catch_clauses = catchClause;
    }

    public TryExp(Expression expression, Expression expression2) {
        this.try_clause = expression;
        this.finally_clause = expression2;
    }

    protected boolean mustCompile() {
        return this.catch_clauses != null;
    }

    public void apply(CallContext callContext) throws Throwable {
        if (this.catch_clauses != null) {
            throw new RuntimeException("internal error - TryExp.eval called");
        }
        try {
            this.try_clause.apply(callContext);
            callContext.runUntilDone();
        }
        catch (Throwable throwable) {
            CatchClause catchClause = this.catch_clauses;
            while (catchClause != null) {
                catchClause = catchClause.next;
            }
            throw throwable;
        }
        finally {
            this.finally_clause.eval(callContext);
        }
    }

    public void compile(Compilation compilation, Target target) {
        CodeAttr codeAttr = compilation.getCode();
        boolean bl = this.finally_clause != null;
        Target target2 = target instanceof StackTarget || target instanceof ConsumerTarget || target instanceof IgnoreTarget || target instanceof ConditionalTarget && this.finally_clause == null ? target : Target.pushValue(target.getType());
        codeAttr.emitTryStart(bl, target2 instanceof StackTarget ? target2.getType() : null);
        this.try_clause.compileWithPosition(compilation, target2);
        for (CatchClause catchClause = this.catch_clauses; catchClause != null; catchClause = catchClause.getNext()) {
            catchClause.compile(compilation, target2);
        }
        if (this.finally_clause != null) {
            codeAttr.emitFinallyStart();
            this.finally_clause.compileWithPosition(compilation, Target.Ignore);
            codeAttr.emitFinallyEnd();
        }
        codeAttr.emitTryCatchEnd();
        if (target2 != target) {
            target.compileFromStack(compilation, target.getType());
        }
    }

    protected Expression walk(ExpWalker expWalker) {
        return expWalker.walkTryExp(this);
    }

    protected void walkChildren(ExpWalker expWalker) {
        this.try_clause = expWalker.walk(this.try_clause);
        for (CatchClause catchClause = this.catch_clauses; expWalker.exitValue == null && catchClause != null; catchClause = catchClause.getNext()) {
            expWalker.walk(catchClause);
        }
        if (expWalker.exitValue == null && this.finally_clause != null) {
            this.finally_clause = expWalker.walk(this.finally_clause);
        }
    }

    public Type getType() {
        if (this.catch_clauses == null) {
            return this.try_clause.getType();
        }
        return super.getType();
    }

    public void print(OutPort outPort) {
        outPort.startLogicalBlock("(Try", ")", 2);
        outPort.writeSpaceFill();
        this.try_clause.print(outPort);
        for (CatchClause catchClause = this.catch_clauses; catchClause != null; catchClause = catchClause.getNext()) {
            catchClause.print(outPort);
        }
        if (this.finally_clause != null) {
            outPort.writeSpaceLinear();
            outPort.print(" finally: ");
            this.finally_clause.print(outPort);
        }
        outPort.endLogicalBlock(")");
    }
}

