/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.servlet;

import gnu.expr.Compilation;
import gnu.expr.Language;
import gnu.expr.ModuleBody;
import gnu.expr.ModuleContext;
import gnu.expr.ModuleExp;
import gnu.expr.ModuleInfo;
import gnu.expr.ModuleManager;
import gnu.kawa.servlet.KawaServlet;
import gnu.kawa.servlet.ServletCallContext;
import gnu.mapping.CallContext;
import gnu.mapping.Environment;
import gnu.mapping.InPort;
import gnu.text.Path;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class KawaPageServlet
extends KawaServlet {
    private ServletContext context;
    private static final String MODULE_MAP_ATTRIBUTE = "gnu.kawa.module-map";

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.context = servletConfig.getServletContext();
    }

    public void run(CallContext callContext) throws Throwable {
        ServletCallContext servletCallContext = (ServletCallContext)callContext;
        HttpServletRequest httpServletRequest = servletCallContext.request;
        HttpServletResponse httpServletResponse = servletCallContext.response;
        boolean bl = httpServletRequest.getParameter("qexo-save-class") != null;
        String string = httpServletRequest.getServletPath();
        Object object2 = this.getModule(servletCallContext, string, bl, httpServletResponse);
        if (object2 instanceof ModuleBody) {
            ((ModuleBody)object2).run(servletCallContext);
        }
    }

    private Object getModule(ServletCallContext servletCallContext, String string, boolean bl, HttpServletResponse httpServletResponse) throws Exception {
        ModuleExp moduleExp;
        Compilation compilation;
        String string2;
        ModuleContext moduleContext;
        Hashtable<String, ModuleInfo> hashtable2 = (Hashtable<String, ModuleInfo>)this.context.getAttribute(MODULE_MAP_ATTRIBUTE);
        if (hashtable2 == null) {
            hashtable2 = new Hashtable<String, ModuleInfo>();
            this.context.setAttribute(MODULE_MAP_ATTRIBUTE, hashtable2);
        }
        if ((moduleContext = (ModuleContext)this.context.getAttribute("gnu.kawa.module-context")) == null) {
            moduleContext = ModuleContext.getContext();
        }
        ModuleInfo moduleInfo = (ModuleInfo)hashtable2.get(string);
        long l = System.currentTimeMillis();
        ModuleManager moduleManager = moduleContext.getManager();
        if (moduleInfo != null && l - moduleInfo.lastCheckedTime < moduleManager.lastModifiedCacheTime) {
            return moduleContext.findInstance(moduleInfo);
        }
        int n = string.length();
        URL uRL = n == 0 || string.charAt(n - 1) == '/' ? null : this.context.getResource(string);
        String string3 = string;
        if (uRL == null) {
            int n2;
            string2 = string;
            do {
                if ((n2 = string2.lastIndexOf(47)) >= 0) continue;
                servletCallContext.response.reset();
                servletCallContext.response.sendError(404, string);
                return null;
            } while ((uRL = this.context.getResource(string3 = (string2 = string2.substring(0, n2)) + "/+default+")) == null);
        }
        if (uRL == null) {
            servletCallContext.response.reset();
            servletCallContext.response.sendError(404, string);
            return null;
        }
        string2 = uRL.toExternalForm();
        if (moduleInfo == null || !string2.equals(moduleInfo.getSourceAbsPathname())) {
            moduleInfo = moduleManager.findWithURL(uRL);
        }
        if (moduleInfo.checkCurrent(moduleManager, l)) {
            return moduleContext.findInstance(moduleInfo);
        }
        hashtable2.put(string, moduleInfo);
        Path path = moduleInfo.getSourceAbsPath();
        InputStream inputStream = path.openInputStream();
        Language language = Language.getInstanceFromFilenameExtension(string);
        if (language != null) {
            servletCallContext.getServletContext().log("Compile " + string + " - a " + language.getName() + " source file (based on extension)");
        } else {
            language = Language.detect(inputStream);
            if (language != null) {
                servletCallContext.getServletContext().log("Compile " + string + " - a " + language.getName() + " source file (detected from content)");
            } else {
                int n3;
                if (string != string3) {
                    servletCallContext.response.reset();
                    servletCallContext.response.sendError(404, string);
                    return null;
                }
                String string4 = this.context.getMimeType(string);
                httpServletResponse.setContentType(string4);
                ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
                byte[] byArray = new byte[4096];
                while ((n3 = inputStream.read(byArray)) >= 0) {
                    servletOutputStream.write(byArray, 0, n3);
                }
                inputStream.close();
                return null;
            }
        }
        InPort inPort = new InPort(inputStream, path);
        Language.setDefaultLanguage(language);
        SourceMessages sourceMessages = new SourceMessages();
        try {
            compilation = language.parse(inPort, sourceMessages, moduleInfo);
            compilation.immediate = true;
        }
        catch (SyntaxException syntaxException) {
            if (syntaxException.getMessages() != sourceMessages) {
                throw syntaxException;
            }
            compilation = null;
        }
        Class clazz = null;
        if (!sourceMessages.seenErrors()) {
            moduleExp = compilation.getModule();
            Environment environment = Environment.getCurrent();
            clazz = (Class)ModuleExp.evalModule1(environment, compilation, uRL, null);
        }
        if (sourceMessages.seenErrors()) {
            servletCallContext.response.reset();
            moduleExp = servletCallContext.response.getOutputStream();
            moduleExp.print(sourceMessages.toString(20));
            return null;
        }
        moduleInfo.setModuleClass(clazz);
        if (bl) {
            compilation.outputClass(this.context.getRealPath("WEB-INF/classes") + '/');
        }
        return moduleContext.findInstance(moduleInfo);
    }
}

