/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.xml;

import gnu.bytecode.ClassType;
import gnu.kawa.xml.XDataType;
import gnu.math.DateTime;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class XTimeType
extends XDataType {
    static ClassType typeDateTime = ClassType.make("gnu.math.DateTime");
    public static final XTimeType dateTimeType = new XTimeType("dateTime", 20);
    public static final XTimeType dateType = new XTimeType("date", 21);
    public static final XTimeType timeType = new XTimeType("time", 22);
    public static final XTimeType gYearMonthType = new XTimeType("gYearMonth", 23);
    public static final XTimeType gYearType = new XTimeType("gYear", 24);
    public static final XTimeType gMonthType = new XTimeType("gMonth", 27);
    public static final XTimeType gMonthDayType = new XTimeType("gMonthDay", 25);
    public static final XTimeType gDayType = new XTimeType("gDay", 26);
    private static TimeZone fixedTimeZone;

    XTimeType(String string, int n) {
        super(string, typeDateTime, n);
    }

    static int components(int n) {
        switch (n) {
            case 20: {
                return 126;
            }
            case 21: {
                return 14;
            }
            case 22: {
                return 112;
            }
            case 23: {
                return 6;
            }
            case 24: {
                return 2;
            }
            case 25: {
                return 12;
            }
            case 26: {
                return 8;
            }
            case 27: {
                return 4;
            }
            case 28: {
                return 126;
            }
            case 29: {
                return 6;
            }
            case 30: {
                return 120;
            }
        }
        return 0;
    }

    public DateTime now() {
        return new DateTime(XTimeType.components(this.typeCode) | 0x80, (GregorianCalendar)Calendar.getInstance(XTimeType.fixedTimeZone()));
    }

    private static synchronized TimeZone fixedTimeZone() {
        if (fixedTimeZone == null) {
            int n = TimeZone.getDefault().getRawOffset() / 60000;
            fixedTimeZone = DateTime.minutesToTimeZone(n);
        }
        return fixedTimeZone;
    }

    public static DateTime parseDateTime(String string, int n) {
        DateTime dateTime = DateTime.parse(string, n);
        if (dateTime.isZoneUnspecified()) {
            dateTime.setTimeZone(XTimeType.fixedTimeZone());
        }
        return dateTime;
    }

    public Object valueOf(String string) {
        return XTimeType.parseDateTime(string, XTimeType.components(this.typeCode));
    }

    public boolean isInstance(Object object2) {
        int n;
        if (!(object2 instanceof DateTime)) {
            return false;
        }
        int n2 = XTimeType.components(this.typeCode);
        return n2 == (n = ((DateTime)object2).components());
    }
}

