/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.lists.AbstractFormat;
import gnu.lists.Consumable;
import gnu.lists.Consumer;
import gnu.lists.PrintConsumer;
import gnu.mapping.Environment;
import gnu.mapping.LogWriter;
import gnu.mapping.ThreadLocation;
import gnu.text.Path;
import gnu.text.PrettyWriter;
import gnu.text.Printable;
import gnu.text.WriterManager;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.NumberFormat;

public class OutPort
extends PrintConsumer
implements Printable {
    Path path;
    private Writer base;
    protected PrettyWriter bout;
    protected Object unregisterRef;
    public boolean printReadable;
    static OutPort outInitial = new OutPort(new LogWriter(new BufferedWriter(new OutputStreamWriter(System.out))), true, true, Path.valueOf("/dev/stdout"));
    private static OutPort errInitial = new OutPort(new LogWriter(new OutputStreamWriter(System.err)), true, true, Path.valueOf("/dev/stderr"));
    public static final ThreadLocation outLocation = new ThreadLocation("out-default");
    public static final ThreadLocation errLocation;
    static Writer logFile;
    NumberFormat numberFormat;
    public AbstractFormat objectFormat;

    protected OutPort(Writer writer, PrettyWriter prettyWriter, boolean bl) {
        super(prettyWriter, bl);
        this.bout = prettyWriter;
        this.base = writer;
        if (this.closeOnExit()) {
            this.unregisterRef = WriterManager.instance.register(prettyWriter);
        }
    }

    protected OutPort(OutPort outPort, boolean bl) {
        this((Writer)outPort, outPort.bout, bl);
    }

    protected OutPort(Writer writer, boolean bl) {
        this(writer, writer instanceof OutPort ? ((OutPort)writer).bout : new PrettyWriter(writer, true), bl);
    }

    public OutPort(Writer writer, boolean bl, boolean bl2) {
        this(writer, new PrettyWriter(writer, bl), bl2);
    }

    public OutPort(Writer writer, boolean bl, boolean bl2, Path path) {
        this(writer, new PrettyWriter(writer, bl), bl2);
        this.path = path;
    }

    public OutPort(OutputStream outputStream) {
        this(outputStream, null);
    }

    public OutPort(OutputStream outputStream, Path path) {
        this((Writer)new OutputStreamWriter(outputStream), true, path);
    }

    public OutPort(Writer writer) {
        this(writer, writer instanceof OutPort ? ((OutPort)writer).bout : new PrettyWriter(writer, false), false);
    }

    public OutPort(Writer writer, Path path) {
        this(writer, false, false);
        this.path = path;
    }

    public OutPort(Writer writer, boolean bl, Path path) {
        this(writer, false, bl);
        this.path = path;
    }

    public static OutPort outDefault() {
        return (OutPort)outLocation.get();
    }

    public static void setOutDefault(OutPort outPort) {
        outLocation.set(outPort);
    }

    public static OutPort errDefault() {
        return (OutPort)errLocation.get();
    }

    public static void setErrDefault(OutPort outPort) {
        errLocation.set(outPort);
    }

    public static OutPort openFile(Object object2) throws IOException {
        OutputStreamWriter outputStreamWriter;
        Object object3 = Environment.user().get("port-char-encoding");
        Path path = Path.valueOf(object2);
        OutputStream outputStream = path.openOutputStream();
        outputStream = new BufferedOutputStream(outputStream);
        if (object3 == null || object3 == Boolean.TRUE) {
            outputStreamWriter = new OutputStreamWriter(outputStream);
        } else {
            if (object3 == Boolean.FALSE) {
                object3 = "8859_1";
            }
            outputStreamWriter = new OutputStreamWriter(outputStream, object3.toString());
        }
        return new OutPort((Writer)outputStreamWriter, path);
    }

    public void echo(char[] cArray, int n, int n2) throws IOException {
        if (this.base instanceof LogWriter) {
            ((LogWriter)this.base).echo(cArray, n, n2);
        }
    }

    public static void closeLogFile() throws IOException {
        if (logFile != null) {
            logFile.close();
            logFile = null;
        }
        if (OutPort.outInitial.base instanceof LogWriter) {
            ((LogWriter)OutPort.outInitial.base).setLogFile((Writer)null);
        }
        if (OutPort.errInitial.base instanceof LogWriter) {
            ((LogWriter)OutPort.errInitial.base).setLogFile((Writer)null);
        }
    }

    public static void setLogFile(String string) throws IOException {
        if (logFile != null) {
            OutPort.closeLogFile();
        }
        logFile = new PrintWriter(new BufferedWriter(new FileWriter(string)));
        if (OutPort.outInitial.base instanceof LogWriter) {
            ((LogWriter)OutPort.outInitial.base).setLogFile(logFile);
        }
        if (OutPort.errInitial.base instanceof LogWriter) {
            ((LogWriter)OutPort.errInitial.base).setLogFile(logFile);
        }
    }

    protected static final boolean isWordChar(char c) {
        return Character.isJavaIdentifierPart(c) || c == '-' || c == '+';
    }

    public void print(int n) {
        if (this.numberFormat == null) {
            super.print(n);
        } else {
            this.print(this.numberFormat.format(n));
        }
    }

    public void print(long l) {
        if (this.numberFormat == null) {
            super.print(l);
        } else {
            this.print(this.numberFormat.format(l));
        }
    }

    public void print(double d) {
        if (this.numberFormat == null) {
            super.print(d);
        } else {
            this.print(this.numberFormat.format(d));
        }
    }

    public void print(float f) {
        if (this.numberFormat == null) {
            super.print(f);
        } else {
            this.print(this.numberFormat.format(f));
        }
    }

    public void print(boolean bl) {
        if (this.objectFormat == null) {
            super.print(bl);
        } else {
            this.objectFormat.writeBoolean(bl, this);
        }
    }

    public void print(String string) {
        this.write(string == null ? "(null)" : string);
    }

    public void print(Object object2) {
        if (this.objectFormat != null) {
            this.objectFormat.writeObject(object2, this);
        } else if (object2 instanceof Consumable) {
            ((Consumable)object2).consume(this);
        } else {
            super.print(object2 == null ? "null" : object2);
        }
    }

    public void print(Consumer consumer) {
        consumer.write("#<output-port");
        if (this.path != null) {
            consumer.write(32);
            consumer.write(this.path.toString());
        }
        consumer.write(62);
    }

    public void startElement(Object object2) {
        if (this.objectFormat != null) {
            this.objectFormat.startElement(object2, this);
        } else {
            this.print('(');
            this.print(object2);
        }
    }

    public void endElement() {
        if (this.objectFormat != null) {
            this.objectFormat.endElement(this);
        } else {
            this.print(')');
        }
    }

    public void startAttribute(Object object2) {
        if (this.objectFormat != null) {
            this.objectFormat.startAttribute(object2, this);
        } else {
            this.print(' ');
            this.print(object2);
            this.print(": ");
        }
    }

    public void endAttribute() {
        if (this.objectFormat != null) {
            this.objectFormat.endAttribute(this);
        } else {
            this.print(' ');
        }
    }

    public void writeWordEnd() {
        this.bout.writeWordEnd();
    }

    public void writeWordStart() {
        this.bout.writeWordStart();
    }

    public void freshLine() {
        int n = this.bout.getColumnNumber();
        if (n != 0) {
            this.println();
        }
    }

    public int getColumnNumber() {
        return this.bout.getColumnNumber();
    }

    public void setColumnNumber(int n) {
        this.bout.setColumnNumber(n);
    }

    public void clearBuffer() {
        this.bout.clearBuffer();
    }

    public void closeThis() {
        try {
            if (!(this.base instanceof OutPort) || ((OutPort)this.base).bout != this.bout) {
                this.bout.closeThis();
            }
        }
        catch (IOException iOException) {
            this.setError();
        }
        WriterManager.instance.unregister(this.unregisterRef);
    }

    public void close() {
        try {
            if (this.base instanceof OutPort && ((OutPort)this.base).bout == this.bout) {
                this.base.close();
            } else {
                this.out.close();
            }
        }
        catch (IOException iOException) {
            this.setError();
        }
        WriterManager.instance.unregister(this.unregisterRef);
    }

    protected boolean closeOnExit() {
        return true;
    }

    public static void runCleanups() {
        WriterManager.instance.run();
    }

    public void startLogicalBlock(String string, boolean bl, String string2) {
        this.bout.startLogicalBlock(string, bl, string2);
    }

    public void startLogicalBlock(String string, String string2, int n) {
        this.bout.startLogicalBlock(string, false, string2);
        this.bout.addIndentation(string == null ? n : n - string.length(), false);
    }

    public void endLogicalBlock(String string) {
        this.bout.endLogicalBlock(string);
    }

    public void writeBreak(int n) {
        this.bout.writeBreak(n);
    }

    public void writeSpaceLinear() {
        this.write(32);
        this.writeBreak(78);
    }

    public void writeBreakLinear() {
        this.writeBreak(78);
    }

    public void writeSpaceFill() {
        this.write(32);
        this.writeBreak(70);
    }

    public void writeBreakFill() {
        this.writeBreak(70);
    }

    public void setIndentation(int n, boolean bl) {
        this.bout.addIndentation(n, bl);
    }

    static {
        outLocation.setGlobal(outInitial);
        errLocation = new ThreadLocation("err-default");
        errLocation.setGlobal(errInitial);
    }
}

