/*
 * Decompiled with CFR 0.152.
 */
package gnu.math;

import gnu.math.IntNum;
import gnu.math.MPN;

public class BitOps {
    static final byte[] bit4_count = new byte[]{0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4};

    private BitOps() {
    }

    public static boolean bitValue(IntNum intNum, int n) {
        int n2 = intNum.ival;
        if (intNum.words == null) {
            return n >= 32 ? n2 < 0 : (n2 >> n & 1) != 0;
        }
        int n3 = n >> 5;
        return n3 >= n2 ? intNum.words[n2 - 1] < 0 : (intNum.words[n3] >> n & 1) != 0;
    }

    static int[] dataBufferFor(IntNum intNum, int n) {
        int[] nArray;
        block6: {
            int n2;
            int n3;
            block5: {
                n3 = intNum.ival;
                n2 = n + 1 >> 5;
                if (intNum.words != null) break block5;
                if (n2 == 0) {
                    n2 = 1;
                }
                nArray = new int[n2];
                nArray[0] = n3;
                if (n3 >= 0) break block6;
                for (int i = 1; i < n2; ++i) {
                    nArray[i] = -1;
                }
                break block6;
            }
            n2 = n + 1 >> 5;
            nArray = new int[n2 > n3 ? n2 : n3];
            int n4 = n3;
            while (--n4 >= 0) {
                nArray[n4] = intNum.words[n4];
            }
            if (nArray[n3 - 1] < 0) {
                for (n4 = n3; n4 < n2; ++n4) {
                    nArray[n4] = -1;
                }
            }
        }
        return nArray;
    }

    public static IntNum setBitValue(IntNum intNum, int n, int n2) {
        n2 &= 1;
        int n3 = intNum.ival;
        if (intNum.words == null) {
            int n4 = n3 >> (n < 31 ? n : 31) & 1;
            if (n4 == n2) {
                return intNum;
            }
            if (n < 63) {
                return IntNum.make((long)n3 ^ (long)(1 << n));
            }
        } else {
            int n5 = n >> 5;
            int n6 = n5 >= n3 ? (intNum.words[n3 - 1] < 0 ? 1 : 0) : intNum.words[n5] >> n & 1;
            if (n6 == n2) {
                return intNum;
            }
        }
        int[] nArray = BitOps.dataBufferFor(intNum, n);
        int n7 = n >> 5;
        nArray[n7] = nArray[n7] ^ 1 << (n & 0x1F);
        return IntNum.make(nArray, nArray.length);
    }

    public static boolean test(IntNum intNum, int n) {
        if (intNum.words == null) {
            return (intNum.ival & n) != 0;
        }
        return n < 0 || (intNum.words[0] & n) != 0;
    }

    public static boolean test(IntNum intNum, IntNum intNum2) {
        if (intNum2.words == null) {
            return BitOps.test(intNum, intNum2.ival);
        }
        if (intNum.words == null) {
            return BitOps.test(intNum2, intNum.ival);
        }
        if (intNum.ival < intNum2.ival) {
            IntNum intNum3 = intNum;
            intNum = intNum2;
            intNum2 = intNum3;
        }
        for (int i = 0; i < intNum2.ival; ++i) {
            if ((intNum.words[i] & intNum2.words[i]) == 0) continue;
            return true;
        }
        return intNum2.isNegative();
    }

    public static IntNum and(IntNum intNum, int n) {
        if (intNum.words == null) {
            return IntNum.make(intNum.ival & n);
        }
        if (n >= 0) {
            return IntNum.make(intNum.words[0] & n);
        }
        int n2 = intNum.ival;
        int[] nArray = new int[n2];
        nArray[0] = intNum.words[0] & n;
        while (--n2 > 0) {
            nArray[n2] = intNum.words[n2];
        }
        return IntNum.make(nArray, intNum.ival);
    }

    public static IntNum and(IntNum intNum, IntNum intNum2) {
        int n;
        if (intNum2.words == null) {
            return BitOps.and(intNum, intNum2.ival);
        }
        if (intNum.words == null) {
            return BitOps.and(intNum2, intNum.ival);
        }
        if (intNum.ival < intNum2.ival) {
            IntNum intNum3 = intNum;
            intNum = intNum2;
            intNum2 = intNum3;
        }
        int n2 = intNum2.isNegative() ? intNum.ival : intNum2.ival;
        int[] nArray = new int[n2];
        for (n = 0; n < intNum2.ival; ++n) {
            nArray[n] = intNum.words[n] & intNum2.words[n];
        }
        while (n < n2) {
            nArray[n] = intNum.words[n];
            ++n;
        }
        return IntNum.make(nArray, n2);
    }

    public static IntNum ior(IntNum intNum, IntNum intNum2) {
        return BitOps.bitOp(7, intNum, intNum2);
    }

    public static IntNum xor(IntNum intNum, IntNum intNum2) {
        return BitOps.bitOp(6, intNum, intNum2);
    }

    public static IntNum not(IntNum intNum) {
        return BitOps.bitOp(12, intNum, IntNum.zero());
    }

    public static int swappedOp(int n) {
        return "\u0000\u0001\u0004\u0005\u0002\u0003\u0006\u0007\b\t\f\r\n\u000b\u000e\u000f".charAt(n);
    }

    public static IntNum bitOp(int n, IntNum intNum, IntNum intNum2) {
        switch (n) {
            case 0: {
                return IntNum.zero();
            }
            case 1: {
                return BitOps.and(intNum, intNum2);
            }
            case 3: {
                return intNum;
            }
            case 5: {
                return intNum2;
            }
            case 15: {
                return IntNum.minusOne();
            }
        }
        IntNum intNum3 = new IntNum();
        BitOps.setBitOp(intNum3, n, intNum, intNum2);
        return intNum3.canonicalize();
    }

    public static void setBitOp(IntNum intNum, int n, IntNum intNum2, IntNum intNum3) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        if (intNum3.words != null && (intNum2.words == null || intNum2.ival < intNum3.ival)) {
            IntNum intNum4 = intNum2;
            intNum2 = intNum3;
            intNum3 = intNum4;
            n = BitOps.swappedOp(n);
        }
        if (intNum3.words == null) {
            n6 = intNum3.ival;
            n5 = 1;
        } else {
            n6 = intNum3.words[0];
            n5 = intNum3.ival;
        }
        if (intNum2.words == null) {
            n4 = intNum2.ival;
            n3 = 1;
        } else {
            n4 = intNum2.words[0];
            n3 = intNum2.ival;
        }
        if (n3 > 1) {
            intNum.realloc(n3);
        }
        int[] nArray = intNum.words;
        int n7 = 0;
        int n8 = 0;
        block0 : switch (n) {
            case 0: {
                n2 = 0;
                break;
            }
            case 1: {
                while (true) {
                    n2 = n4 & n6;
                    if (n7 + 1 >= n5) break;
                    nArray[n7++] = n2;
                    n4 = intNum2.words[n7];
                    n6 = intNum3.words[n7];
                }
                if (n6 >= 0) break;
                n8 = 1;
                break;
            }
            case 2: {
                while (true) {
                    n2 = n4 & ~n6;
                    if (n7 + 1 >= n5) break;
                    nArray[n7++] = n2;
                    n4 = intNum2.words[n7];
                    n6 = intNum3.words[n7];
                }
                if (n6 < 0) break;
                n8 = 1;
                break;
            }
            case 3: {
                n2 = n4;
                n8 = 1;
                break;
            }
            case 4: {
                while (true) {
                    n2 = ~n4 & n6;
                    if (n7 + 1 >= n5) break;
                    nArray[n7++] = n2;
                    n4 = intNum2.words[n7];
                    n6 = intNum3.words[n7];
                }
                if (n6 >= 0) break;
                n8 = 2;
                break;
            }
            case 5: {
                while (true) {
                    n2 = n6;
                    if (n7 + 1 >= n5) break block0;
                    nArray[n7++] = n2;
                    n4 = intNum2.words[n7];
                    n6 = intNum3.words[n7];
                }
            }
            case 6: {
                while (true) {
                    n2 = n4 ^ n6;
                    if (n7 + 1 >= n5) break;
                    nArray[n7++] = n2;
                    n4 = intNum2.words[n7];
                    n6 = intNum3.words[n7];
                }
                n8 = n6 < 0 ? 2 : 1;
                break;
            }
            case 7: {
                while (true) {
                    n2 = n4 | n6;
                    if (n7 + 1 >= n5) break;
                    nArray[n7++] = n2;
                    n4 = intNum2.words[n7];
                    n6 = intNum3.words[n7];
                }
                if (n6 < 0) break;
                n8 = 1;
                break;
            }
            case 8: {
                while (true) {
                    n2 = ~(n4 | n6);
                    if (n7 + 1 >= n5) break;
                    nArray[n7++] = n2;
                    n4 = intNum2.words[n7];
                    n6 = intNum3.words[n7];
                }
                if (n6 < 0) break;
                n8 = 2;
                break;
            }
            case 9: {
                while (true) {
                    n2 = ~(n4 ^ n6);
                    if (n7 + 1 >= n5) break;
                    nArray[n7++] = n2;
                    n4 = intNum2.words[n7];
                    n6 = intNum3.words[n7];
                }
                n8 = n6 >= 0 ? 2 : 1;
                break;
            }
            case 10: {
                while (true) {
                    n2 = ~n6;
                    if (n7 + 1 >= n5) break block0;
                    nArray[n7++] = n2;
                    n4 = intNum2.words[n7];
                    n6 = intNum3.words[n7];
                }
            }
            case 11: {
                while (true) {
                    n2 = n4 | ~n6;
                    if (n7 + 1 >= n5) break;
                    nArray[n7++] = n2;
                    n4 = intNum2.words[n7];
                    n6 = intNum3.words[n7];
                }
                if (n6 >= 0) break;
                n8 = 1;
                break;
            }
            case 12: {
                n2 = ~n4;
                n8 = 2;
                break;
            }
            case 13: {
                while (true) {
                    n2 = ~n4 | n6;
                    if (n7 + 1 >= n5) break;
                    nArray[n7++] = n2;
                    n4 = intNum2.words[n7];
                    n6 = intNum3.words[n7];
                }
                if (n6 < 0) break;
                n8 = 2;
                break;
            }
            case 14: {
                while (true) {
                    n2 = ~(n4 & n6);
                    if (n7 + 1 >= n5) break;
                    nArray[n7++] = n2;
                    n4 = intNum2.words[n7];
                    n6 = intNum3.words[n7];
                }
                if (n6 >= 0) break;
                n8 = 2;
                break;
            }
            default: {
                n2 = -1;
            }
        }
        if (n7 + 1 == n3) {
            n8 = 0;
        }
        switch (n8) {
            case 0: {
                if (n7 == 0 && nArray == null) {
                    intNum.ival = n2;
                    return;
                }
                nArray[n7++] = n2;
                break;
            }
            case 1: {
                nArray[n7] = n2;
                while (++n7 < n3) {
                    nArray[n7] = intNum2.words[n7];
                }
                break;
            }
            case 2: {
                nArray[n7] = n2;
                while (++n7 < n3) {
                    nArray[n7] = ~intNum2.words[n7];
                }
                break;
            }
        }
        intNum.ival = n7;
    }

    public static IntNum extract(IntNum intNum, int n, int n2) {
        int n3;
        int n4;
        if (n2 < 32) {
            int n5 = intNum.words == null ? intNum.ival : intNum.words[0];
            return IntNum.make((n5 & ~(-1 << n2)) >> n);
        }
        if (intNum.words == null) {
            if (intNum.ival >= 0) {
                return IntNum.make(n >= 31 ? 0 : intNum.ival >> n);
            }
            n4 = 1;
        } else {
            n4 = intNum.ival;
        }
        boolean bl = intNum.isNegative();
        if (n2 > 32 * n4) {
            n2 = 32 * n4;
            if (!bl && n == 0) {
                return intNum;
            }
        } else {
            n4 = n2 + 31 >> 5;
        }
        if ((n3 = n2 - n) < 64) {
            long l = intNum.words == null ? (long)(intNum.ival >> (n >= 32 ? 31 : n)) : MPN.rshift_long(intNum.words, n4, n);
            return IntNum.make(l & (-1L << n3 ^ 0xFFFFFFFFFFFFFFFFL));
        }
        int n6 = n >> 5;
        int n7 = (n2 >> 5) + 1 - n6;
        int[] nArray = new int[n7];
        if (intNum.words == null) {
            nArray[0] = n >= 32 ? -1 : intNum.ival >> n;
        } else {
            MPN.rshift0(nArray, intNum.words, n6, n4 -= n6, n &= 0x1F);
        }
        int n8 = n4 = n3 >> 5;
        nArray[n8] = nArray[n8] & ~(-1 << n3);
        return IntNum.make(nArray, n4 + 1);
    }

    public static int lowestBitSet(int n) {
        if (n == 0) {
            return -1;
        }
        int n2 = 0;
        while ((n & 0xFF) == 0) {
            n >>>= 8;
            n2 += 8;
        }
        while ((n & 3) == 0) {
            n >>>= 2;
            n2 += 2;
        }
        if ((n & 1) == 0) {
            ++n2;
        }
        return n2;
    }

    public static int lowestBitSet(IntNum intNum) {
        int[] nArray = intNum.words;
        if (nArray == null) {
            return BitOps.lowestBitSet(intNum.ival);
        }
        int n = intNum.ival;
        int n2 = 0;
        while (n2 < n) {
            int n3 = BitOps.lowestBitSet(nArray[n2]);
            if (n3 < 0) continue;
            return 32 * n2 + n3;
        }
        return -1;
    }

    public static int bitCount(int n) {
        int n2 = 0;
        while (n != 0) {
            n2 += bit4_count[n & 0xF];
            n >>>= 4;
        }
        return n2;
    }

    public static int bitCount(int[] nArray, int n) {
        int n2 = 0;
        while (--n >= 0) {
            n2 += BitOps.bitCount(nArray[n]);
        }
        return n2;
    }

    public static int bitCount(IntNum intNum) {
        int n;
        int n2;
        int[] nArray = intNum.words;
        if (nArray == null) {
            n2 = 1;
            n = BitOps.bitCount(intNum.ival);
        } else {
            n2 = intNum.ival;
            n = BitOps.bitCount(nArray, n2);
        }
        return intNum.isNegative() ? n2 * 32 - n : n;
    }

    public static IntNum reverseBits(IntNum intNum, int n, int n2) {
        int n3 = intNum.ival;
        int[] nArray = intNum.words;
        if (nArray == null && n2 < 63) {
            long l = n3;
            int n4 = n;
            for (int i = n2 - 1; n4 < i; ++n4, --i) {
                long l2 = l >> n4 & 1L;
                long l3 = l >> i & 1L;
                l &= (1L << n4 | 1L << i) ^ 0xFFFFFFFFFFFFFFFFL;
                l = l | l2 << i | l3 << n4;
            }
            return IntNum.make(l);
        }
        int[] nArray2 = BitOps.dataBufferFor(intNum, n2 - 1);
        int n5 = n;
        for (int i = n2 - 1; n5 < i; ++n5, --i) {
            int n6;
            int n7 = n5 >> 5;
            int n8 = i >> 5;
            int n9 = nArray2[n7];
            int n10 = n9 >> n5 & 1;
            if (n7 == n8) {
                n6 = n9 >> i & 1;
                n9 = (int)((long)n9 & ((1L << n5 | 1L << i) ^ 0xFFFFFFFFFFFFFFFFL));
                n9 = n9 | n10 << i | n6 << n5;
            } else {
                n6 = nArray2[n8];
                int n11 = n6 >> (i & 0x1F) & 1;
                n9 &= ~(1 << (n5 & 0x1F));
                n6 &= ~(1 << (i & 0x1F));
                n9 |= n11 << (n5 & 0x1F);
                nArray2[n8] = n6 |= n10 << (i & 0x1F);
            }
            nArray2[n7] = n9;
        }
        return IntNum.make(nArray2, nArray2.length);
    }
}

