/*
 * Decompiled with CFR 0.152.
 */
package gnu.xquery.util;

import gnu.kawa.xml.KElement;
import gnu.kawa.xml.KNode;
import gnu.kawa.xml.UntypedAtomic;
import gnu.kawa.xml.XStringType;
import gnu.mapping.Symbol;
import gnu.mapping.Values;
import gnu.mapping.WrongType;
import gnu.text.Path;
import gnu.text.URIPath;
import gnu.xml.NamespaceBinding;
import gnu.xml.TextUtils;
import gnu.xml.XName;
import java.net.URISyntaxException;

public class QNameUtils {
    public static Object resolveQNameUsingElement(Object object2, KElement kElement) {
        String string;
        String string2;
        if ((object2 = KNode.atomicValue(object2)) == Values.empty || object2 == null) {
            return object2;
        }
        if (object2 instanceof Values || !(object2 instanceof String) && !(object2 instanceof UntypedAtomic)) {
            throw new RuntimeException("bad argument to QName");
        }
        String string3 = TextUtils.replaceWhitespace(object2.toString(), true);
        int n = string3.indexOf(58);
        if (n < 0) {
            string2 = null;
            string = string3;
        } else {
            string2 = string3.substring(0, n).intern();
            string = string3.substring(n + 1);
        }
        String string4 = kElement.lookupNamespaceURI(string2);
        if (string4 == null) {
            if (string2 == null) {
                string4 = "";
            } else {
                throw new RuntimeException("unknown namespace for '" + string3 + "'");
            }
        }
        if (!QNameUtils.validNCName(string) || string2 != null && !QNameUtils.validNCName(string2)) {
            throw new RuntimeException("invalid QName syntax '" + string3 + "'");
        }
        return Symbol.make(string4, string, string2 == null ? "" : string2);
    }

    public static Object resolveQName(Object object2, NamespaceBinding namespaceBinding, NamespaceBinding namespaceBinding2) {
        String string;
        String string2;
        if ((object2 = KNode.atomicValue(object2)) instanceof Symbol) {
            return object2;
        }
        if (object2 instanceof Values || !(object2 instanceof String) && !(object2 instanceof UntypedAtomic)) {
            throw new RuntimeException("bad argument to QName");
        }
        String string3 = TextUtils.replaceWhitespace(object2.toString(), true);
        int n = string3.indexOf(58);
        if (n < 0) {
            string2 = string3;
            string = null;
        } else {
            string = string3.substring(0, n).intern();
            string2 = string3.substring(n + 1);
        }
        if (!QNameUtils.validNCName(string2) || string != null && !QNameUtils.validNCName(string)) {
            throw new RuntimeException("invalid QName syntax '" + string3 + "'");
        }
        String string4 = QNameUtils.resolvePrefix(string, namespaceBinding, namespaceBinding2);
        return Symbol.make(string4, string2, string == null ? "" : string);
    }

    public static String lookupPrefix(String string, NamespaceBinding namespaceBinding, NamespaceBinding namespaceBinding2) {
        String string2;
        NamespaceBinding namespaceBinding3 = namespaceBinding;
        while (true) {
            if (namespaceBinding3 == null) {
                string2 = namespaceBinding2.resolve(string);
                break;
            }
            if (namespaceBinding3.getPrefix() == string) {
                string2 = namespaceBinding3.getUri();
                break;
            }
            namespaceBinding3 = namespaceBinding3.getNext();
        }
        if (string2 == null && string == null) {
            string2 = "";
        }
        return string2;
    }

    public static String resolvePrefix(String string, NamespaceBinding namespaceBinding, NamespaceBinding namespaceBinding2) {
        String string2 = QNameUtils.lookupPrefix(string, namespaceBinding, namespaceBinding2);
        if (string2 == null) {
            throw new RuntimeException("unknown namespace prefix '" + string + "'");
        }
        return string2;
    }

    public static boolean validNCName(String string) {
        return XName.isName(string);
    }

    public static Symbol makeQName(Object object2, String string) {
        String string2;
        String string3;
        if (object2 == null || object2 == Values.empty) {
            object2 = "";
        }
        int n = string.indexOf(58);
        String string4 = (String)object2;
        if (n < 0) {
            string3 = string;
            string2 = "";
        } else {
            string3 = string.substring(n + 1);
            string2 = string.substring(0, n).intern();
        }
        if (!QNameUtils.validNCName(string3) || n >= 0 && !QNameUtils.validNCName(string2)) {
            throw new IllegalArgumentException("invalid QName syntax '" + string + "'");
        }
        if (n >= 0 && string4.length() == 0) {
            throw new IllegalArgumentException("empty uri for '" + string + "'");
        }
        return Symbol.make(string4, string3, string2);
    }

    public static Object localNameFromQName(Object object2) {
        if (object2 == Values.empty || object2 == null) {
            return object2;
        }
        if (!(object2 instanceof Symbol)) {
            throw new WrongType("local-name-from-QName", 1, object2, "xs:QName");
        }
        return XStringType.makeNCName(((Symbol)object2).getName());
    }

    public static Object prefixFromQName(Object object2) {
        if (object2 == Values.empty || object2 == null) {
            return object2;
        }
        if (object2 instanceof Symbol) {
            String string = ((Symbol)object2).getPrefix();
            if (string == null || string.length() == 0) {
                return Values.empty;
            }
            return XStringType.makeNCName(string);
        }
        throw new WrongType("prefix-from-QName", 1, object2, "xs:QName");
    }

    public static Object namespaceURIFromQName(Object object2) {
        if (object2 == Values.empty || object2 == null) {
            return object2;
        }
        try {
            return URIPath.makeURI(((Symbol)object2).getNamespaceURI());
        }
        catch (ClassCastException classCastException) {
            throw new WrongType("namespace-uri", 1, object2, "xs:QName");
        }
    }

    public static Object namespaceURIForPrefix(Object object2, Object object3) {
        String string;
        KNode kNode = KNode.coerce(object3);
        if (kNode == null) {
            throw new WrongType("namespace-uri-for-prefix", 2, object3, "node()");
        }
        if (object2 == null || object2 == Values.empty) {
            string = null;
        } else {
            if (!(object2 instanceof String) && !(object2 instanceof UntypedAtomic)) {
                throw new WrongType("namespace-uri-for-prefix", 1, object3, "xs:string");
            }
            string = object2.toString().intern();
            if (string == "") {
                string = null;
            }
        }
        String string2 = kNode.lookupNamespaceURI(string);
        if (string2 == null) {
            return Values.empty;
        }
        return string2;
    }

    public static Object resolveURI(Object object2, Object object3) throws URISyntaxException {
        Path path;
        if (object2 instanceof KNode) {
            object2 = KNode.atomicValue(object2);
        }
        if (object3 instanceof KNode) {
            object3 = KNode.atomicValue(object3);
        }
        if (object2 == Values.empty || object2 == null) {
            return object2;
        }
        if (object2 instanceof UntypedAtomic) {
            object2 = object2.toString();
        }
        if (object3 instanceof UntypedAtomic) {
            object3 = object3.toString();
        }
        Path path2 = path = object3 instanceof Path ? (Path)object3 : URIPath.makeURI(object3);
        if (object2 instanceof Path) {
            return path.resolve((Path)object2);
        }
        return path.resolve(object2.toString());
    }
}

