/*
 * Decompiled with CFR 0.152.
 */
package kawa;

import gnu.kawa.models.Paintable;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.View;

class PaintableView
extends View {
    Paintable p;
    Rectangle2D bounds;

    public PaintableView(Element element, Paintable paintable) {
        super(element);
        this.p = paintable;
        this.bounds = paintable.getBounds2D();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics, Shape shape) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Rectangle rectangle = shape.getBounds();
        AffineTransform affineTransform = graphics2D.getTransform();
        Paint paint = graphics2D.getPaint();
        try {
            graphics2D.translate(rectangle.x, rectangle.y);
            graphics2D.setPaint(Color.BLACK);
            this.p.paint(graphics2D);
        }
        finally {
            graphics2D.setTransform(affineTransform);
            graphics2D.setPaint(paint);
        }
    }

    public float getAlignment(int n) {
        switch (n) {
            case 1: {
                return 1.0f;
            }
        }
        return super.getAlignment(n);
    }

    public float getPreferredSpan(int n) {
        switch (n) {
            case 0: {
                return (float)this.bounds.getWidth();
            }
            case 1: {
                return (float)this.bounds.getHeight();
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + n);
    }

    public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
        int n2 = this.getStartOffset();
        int n3 = this.getEndOffset();
        if (n >= n2 && n <= n3) {
            Rectangle rectangle = shape.getBounds();
            if (n == n3) {
                rectangle.x += rectangle.width;
            }
            rectangle.width = 0;
            return rectangle;
        }
        throw new BadLocationException(n + " not in range " + n2 + "," + n3, n);
    }

    public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
        Rectangle rectangle = (Rectangle)shape;
        if (f < (float)(rectangle.x + rectangle.width / 2)) {
            biasArray[0] = Position.Bias.Forward;
            return this.getStartOffset();
        }
        biasArray[0] = Position.Bias.Backward;
        return this.getEndOffset();
    }
}

