/*
 * Decompiled with CFR 0.152.
 */
package kawa;

import gnu.expr.Language;
import gnu.expr.ModuleBody;
import gnu.lists.AbstractFormat;
import gnu.lists.Consumer;
import gnu.lists.VoidConsumer;
import gnu.mapping.Environment;
import gnu.mapping.InPort;
import gnu.mapping.OutPort;
import gnu.mapping.Procedure;
import gnu.mapping.TtyInPort;
import gnu.mapping.WrongArguments;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import java.io.FileNotFoundException;
import java.lang.reflect.Method;
import java.net.URL;
import kawa.standard.load;

public class Shell {
    private static Class[] noClasses = new Class[0];
    private static Class[] boolClasses = new Class[]{Boolean.TYPE};
    private static Class[] xmlPrinterClasses = new Class[]{OutPort.class, Object.class};
    private static Class[] httpPrinterClasses = new Class[]{OutPort.class};
    private static Object portArg = "(port)";
    static Object[][] formats = new Object[][]{{"scheme", "gnu.kawa.functions.DisplayFormat", "getSchemeFormat", boolClasses, Boolean.FALSE}, {"readable-scheme", "gnu.kawa.functions.DisplayFormat", "getSchemeFormat", boolClasses, Boolean.TRUE}, {"elisp", "gnu.kawa.functions.DisplayFormat", "getEmacsLispFormat", boolClasses, Boolean.FALSE}, {"readable-elisp", "gnu.kawa.functions.DisplayFormat", "getEmacsLispFormat", boolClasses, Boolean.TRUE}, {"clisp", "gnu.kawa.functions.DisplayFormat", "getCommonLispFormat", boolClasses, Boolean.FALSE}, {"readable-clisp", "gnu.kawa.functions.DisplayFormat", "getCommonLispFormat", boolClasses, Boolean.TRUE}, {"commonlisp", "gnu.kawa.functions.DisplayFormat", "getCommonLispFormat", boolClasses, Boolean.FALSE}, {"readable-commonlisp", "gnu.kawa.functions.DisplayFormat", "getCommonLispFormat", boolClasses, Boolean.TRUE}, {"xml", "gnu.xml.XMLPrinter", "make", xmlPrinterClasses, portArg, null}, {"html", "gnu.xml.XMLPrinter", "make", xmlPrinterClasses, portArg, "html"}, {"xhtml", "gnu.xml.XMLPrinter", "make", xmlPrinterClasses, portArg, "xhtml"}, {"cgi", "gnu.kawa.xml.HttpPrinter", "make", httpPrinterClasses, portArg}, {"ignore", "gnu.lists.VoidConsumer", "getInstance", noClasses}, {null}};
    public static String defaultFormatName;
    public static Object[] defaultFormatInfo;
    public static Method defaultFormatMethod;

    public static void setDefaultFormat(String string) {
        defaultFormatName = string = string.intern();
        int n = 0;
        while (true) {
            Object[] objectArray;
            Object object2;
            if ((object2 = (objectArray = formats[n])[0]) == null) {
                System.err.println("kawa: unknown output format '" + string + "'");
                System.exit(-1);
            } else if (object2 == string) {
                defaultFormatInfo = objectArray;
                try {
                    Class<?> clazz = Class.forName((String)objectArray[1]);
                    defaultFormatMethod = clazz.getMethod((String)objectArray[2], (Class[])objectArray[3]);
                }
                catch (Throwable throwable) {
                    System.err.println("kawa:  caught " + throwable + " while looking for format '" + string + "'");
                    System.exit(-1);
                }
                break;
            }
            ++n;
        }
        if (!defaultFormatInfo[1].equals("gnu.lists.VoidConsumer")) {
            ModuleBody.setMainPrintValues(true);
        }
    }

    public static Consumer getOutputConsumer(OutPort outPort) {
        Object[] objectArray = defaultFormatInfo;
        if (outPort == null) {
            return VoidConsumer.getInstance();
        }
        if (objectArray == null) {
            return Language.getDefaultLanguage().getOutputConsumer(outPort);
        }
        try {
            Object[] objectArray2 = new Object[objectArray.length - 4];
            System.arraycopy(objectArray, 4, objectArray2, 0, objectArray2.length);
            int n = objectArray2.length;
            while (--n >= 0) {
                if (objectArray2[n] != portArg) continue;
                objectArray2[n] = outPort;
            }
            Object object2 = defaultFormatMethod.invoke(null, objectArray2);
            if (object2 instanceof AbstractFormat) {
                outPort.objectFormat = (AbstractFormat)object2;
                return outPort;
            }
            return (Consumer)object2;
        }
        catch (Throwable throwable) {
            throw new RuntimeException("cannot get output-format '" + defaultFormatName + "' - caught " + throwable);
        }
    }

    public static boolean run(Language language, Environment environment) {
        OutPort outPort;
        Object object2;
        InPort inPort = InPort.inDefault();
        SourceMessages sourceMessages = new SourceMessages();
        if (inPort instanceof TtyInPort) {
            object2 = language.getPrompter();
            if (object2 != null) {
                ((TtyInPort)inPort).setPrompter((Procedure)object2);
            }
            outPort = OutPort.errDefault();
        } else {
            outPort = null;
        }
        object2 = Shell.run(language, environment, inPort, OutPort.outDefault(), outPort, sourceMessages);
        if (object2 == null) {
            return true;
        }
        Shell.printError((Throwable)object2, sourceMessages, OutPort.errDefault());
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Throwable run(Language language, Environment environment, InPort inPort, OutPort outPort, OutPort outPort2, SourceMessages sourceMessages) {
        AbstractFormat abstractFormat = null;
        if (outPort != null) {
            abstractFormat = outPort.objectFormat;
        }
        Consumer consumer = Shell.getOutputConsumer(outPort);
        try {
            Throwable throwable = Shell.run(language, environment, inPort, consumer, outPort2, null, sourceMessages);
            return throwable;
        }
        finally {
            if (outPort != null) {
                outPort.objectFormat = abstractFormat;
            }
        }
    }

    public static boolean run(Language language, Environment environment, InPort inPort, Consumer consumer, OutPort outPort, URL uRL) {
        SourceMessages sourceMessages = new SourceMessages();
        Throwable throwable = Shell.run(language, environment, inPort, consumer, outPort, uRL, sourceMessages);
        if (throwable != null) {
            Shell.printError(throwable, sourceMessages, outPort);
        }
        return throwable == null;
    }

    /*
     * Exception decompiling
     */
    public static Throwable run(Language var0, Environment var1_1, InPort var2_2, Consumer var3_3, OutPort var4_4, URL var5_5, SourceMessages var6_6) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[UNCONDITIONALDOLOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void printError(Throwable throwable, SourceMessages sourceMessages, OutPort outPort) {
        SyntaxException syntaxException;
        if (throwable instanceof WrongArguments) {
            WrongArguments wrongArguments = (WrongArguments)throwable;
            sourceMessages.printAll(outPort, 20);
            if (wrongArguments.usage != null) {
                outPort.println("usage: " + wrongArguments.usage);
            }
            wrongArguments.printStackTrace(outPort);
        } else if (throwable instanceof ClassCastException) {
            sourceMessages.printAll(outPort, 20);
            outPort.println("Invalid parameter, was: " + throwable.getMessage());
            throwable.printStackTrace(outPort);
        } else if (throwable instanceof SyntaxException && (syntaxException = (SyntaxException)throwable).getMessages() == sourceMessages) {
            syntaxException.printAll(outPort, 20);
            syntaxException.clear();
        } else {
            sourceMessages.printAll(outPort, 20);
            throwable.printStackTrace(outPort);
        }
    }

    public static boolean runFile(String string, int n) {
        Environment environment = Environment.getCurrent();
        try {
            if (string.equals("-")) {
                InPort inPort = InPort.inDefault();
                while (--n >= 0) {
                    inPort.skipRestOfLine();
                }
                load.loadSource(inPort, environment, null);
            } else {
                load.apply(string, environment, false, n);
            }
            return true;
        }
        catch (SyntaxException syntaxException) {
            syntaxException.printAll(OutPort.errDefault(), 20);
            return false;
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Cannot open file " + string);
            return false;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.err);
            return false;
        }
    }
}

