/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.vectorgraphics2d.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public class Base64EncodeStream
extends FilterOutputStream {
    private static final int BASE = 64;
    private static final int[] POW_64 = new int[]{262144, 4096, 64, 1};
    private static final char[] CHAR_MAP = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
    private boolean closed;
    private final byte[] data = new byte[3];
    private int dataSize;
    private final byte[] encoded = new byte[4];

    public Base64EncodeStream(OutputStream out) {
        super(out);
    }

    @Override
    public void write(int b) throws IOException {
        if (this.closed) {
            return;
        }
        if (this.dataSize == this.data.length) {
            this.writeChunk();
            this.dataSize = 0;
        }
        this.data[this.dataSize++] = (byte)(b & 0xFF);
    }

    private void writeChunk() throws IOException {
        if (this.dataSize == 0) {
            return;
        }
        long uint32 = Base64EncodeStream.toUInt32(this.data, this.dataSize);
        int padByteCount = this.data.length - this.dataSize;
        int encodedSize = this.encodeChunk(uint32, padByteCount);
        this.out.write(this.encoded, 0, encodedSize);
    }

    private static long toUInt32(byte[] bytes, int size) {
        long uint32 = 0L;
        int offset = (3 - size) * 8;
        for (int i = size - 1; i >= 0; --i) {
            uint32 |= (long)((bytes[i] & 0xFF) << offset);
            offset += 8;
        }
        return Base64EncodeStream.toUnsignedInt(uint32);
    }

    private static long toUnsignedInt(long x) {
        return x & 0xFFFFFFFFL;
    }

    private int encodeChunk(long uint32, int padByteCount) {
        Arrays.fill(this.encoded, (byte)61);
        int size = this.encoded.length - padByteCount;
        for (int i = 0; i < size; ++i) {
            this.encoded[i] = (byte)CHAR_MAP[(int)(uint32 / (long)POW_64[i] % 64L)];
        }
        return this.encoded.length;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.writeChunk();
        super.close();
        this.closed = true;
    }
}

