/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.Consumer;
import gnu.lists.IntSequence;
import gnu.lists.LongVector;

public class S64Vector
extends LongVector<Long> {
    public S64Vector() {
        this.data = empty;
    }

    public S64Vector(int size, long value) {
        long[] array = new long[size];
        this.data = array;
        if (value != 0L) {
            while (--size >= 0) {
                array[size] = value;
            }
        }
    }

    public S64Vector(int size) {
        this(new long[size]);
    }

    public S64Vector(long[] data) {
        this.data = data;
    }

    public S64Vector(long[] data, IntSequence indexes) {
        this.data = data;
        this.indexes = indexes;
    }

    public S64Vector(long[] values, int offset, int length) {
        this(length);
        System.arraycopy(values, offset, this.data, 0, length);
    }

    @Override
    public final Long get(int index) {
        if (this.indexes != null) {
            index = this.indexes.intAt(index);
        }
        return this.data[index];
    }

    @Override
    public final Long getBuffer(int index) {
        return this.data[index];
    }

    @Override
    public final void setBuffer(int index, Long value) {
        this.data[index] = value;
    }

    protected S64Vector withIndexes(IntSequence ind) {
        return new S64Vector(this.data, ind);
    }

    @Override
    public S64Vector subList(int fromIx, int toIx) {
        return new S64Vector(this.data, this.indexesSubList(fromIx, toIx));
    }

    public int getElementKind() {
        return 24;
    }

    @Override
    public String getTag() {
        return "s64";
    }

    @Override
    public void consumePosRange(int iposStart, int iposEnd, Consumer out) {
        if (out.ignoring()) {
            return;
        }
        int end = this.nextIndex(iposEnd);
        for (int i = this.nextIndex(iposStart); i < end; ++i) {
            out.writeLong(this.longAt(i));
        }
    }

    public int compareTo(Object obj) {
        S64Vector vec2 = (S64Vector)obj;
        long[] arr1 = this.data;
        long[] arr2 = vec2.data;
        int n1 = this.size();
        int n2 = vec2.size();
        IntSequence inds1 = this.getIndexesForce();
        IntSequence inds2 = vec2.getIndexesForce();
        int n = n1 > n2 ? n2 : n1;
        for (int i = 0; i < n; ++i) {
            long v2;
            long v1 = arr1[inds1.intAt(i)];
            if (v1 == (v2 = arr2[inds2.intAt(i)])) continue;
            return v1 > v2 ? 1 : -1;
        }
        return n1 - n2;
    }
}

