/*
 * Decompiled with CFR 0.152.
 */
package org.jline.terminal;

import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ServiceLoader;
import org.jline.terminal.Attributes;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.terminal.impl.AbstractPosixTerminal;
import org.jline.terminal.impl.DumbTerminal;
import org.jline.terminal.impl.ExecPty;
import org.jline.terminal.impl.ExternalTerminal;
import org.jline.terminal.impl.PosixPtyTerminal;
import org.jline.terminal.impl.PosixSysTerminal;
import org.jline.terminal.spi.JansiSupport;
import org.jline.terminal.spi.JnaSupport;
import org.jline.terminal.spi.Pty;
import org.jline.utils.Log;
import org.jline.utils.OSUtils;

public final class TerminalBuilder {
    private String name;
    private InputStream in;
    private OutputStream out;
    private String type;
    private String encoding;
    private Boolean system;
    private boolean jna = true;
    private Boolean dumb;
    private Attributes attributes;
    private Size size;
    private boolean nativeSignals = false;
    private Terminal.SignalHandler signalHandler = Terminal.SignalHandler.SIG_DFL;

    public static Terminal terminal() throws IOException {
        return TerminalBuilder.builder().build();
    }

    public static TerminalBuilder builder() {
        return new TerminalBuilder();
    }

    private TerminalBuilder() {
    }

    public TerminalBuilder name(String name) {
        this.name = name;
        return this;
    }

    public TerminalBuilder streams(InputStream in, OutputStream out) {
        this.in = in;
        this.out = out;
        return this;
    }

    public TerminalBuilder system(boolean system) {
        this.system = system;
        return this;
    }

    public TerminalBuilder jna(boolean jna) {
        this.jna = jna;
        return this;
    }

    public TerminalBuilder dumb(boolean dumb) {
        this.dumb = dumb;
        return this;
    }

    public TerminalBuilder type(String type) {
        this.type = type;
        return this;
    }

    public TerminalBuilder encoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    public TerminalBuilder attributes(Attributes attributes) {
        this.attributes = attributes;
        return this;
    }

    public TerminalBuilder size(Size size) {
        this.size = size;
        return this;
    }

    public TerminalBuilder nativeSignals(boolean nativeSignals) {
        this.nativeSignals = nativeSignals;
        return this;
    }

    public TerminalBuilder signalHandler(Terminal.SignalHandler signalHandler) {
        this.signalHandler = signalHandler;
        return this;
    }

    public Terminal build() throws IOException {
        Terminal terminal = this.doBuild();
        Log.debug(() -> "Using terminal " + terminal.getClass().getSimpleName());
        if (terminal instanceof AbstractPosixTerminal) {
            Log.debug(() -> "Using pty " + ((AbstractPosixTerminal)terminal).getPty().getClass().getSimpleName());
        }
        return terminal;
    }

    private Terminal doBuild() throws IOException {
        String str;
        Boolean dumb;
        String type;
        String encoding;
        String name = this.name;
        if (name == null) {
            name = "JLine terminal";
        }
        if ((encoding = this.encoding) == null) {
            encoding = Charset.defaultCharset().name();
        }
        if ((type = this.type) == null) {
            type = System.getProperty("org.jline.terminal.type");
        }
        if (type == null) {
            type = System.getenv("TERM");
        }
        if ((dumb = this.dumb) == null && (str = System.getProperty("org.jline.terminal.dumb")) != null) {
            dumb = Boolean.parseBoolean(str);
        }
        if (this.system != null && this.system.booleanValue() || this.system == null && this.in == null && this.out == null) {
            IllegalStateException exception;
            block33: {
                if (this.attributes != null || this.size != null) {
                    Log.warn("Attributes and size fields are ignored when creating a system terminal");
                }
                exception = new IllegalStateException("Unable to create a system terminal");
                if (OSUtils.IS_CYGWIN || OSUtils.IS_MINGW) {
                    try {
                        Pty pty = ExecPty.current();
                        return new PosixSysTerminal(name, type, pty, encoding, this.nativeSignals, this.signalHandler);
                    }
                    catch (IOException e) {
                        Log.debug("Error creating exec based pty: ", e.getMessage(), e);
                        exception.addSuppressed(e);
                    }
                } else {
                    if (OSUtils.IS_WINDOWS) {
                        if (this.useJna()) {
                            try {
                                return this.load(JnaSupport.class).winSysTerminal(name, this.nativeSignals, this.signalHandler);
                            }
                            catch (Throwable t) {
                                Log.debug("Error creating JNA based terminal: ", t.getMessage(), t);
                                exception.addSuppressed(t);
                            }
                        }
                        try {
                            return this.load(JansiSupport.class).winSysTerminal(name, this.nativeSignals, this.signalHandler);
                        }
                        catch (Throwable t) {
                            Log.debug("Error creating JANSI based terminal: ", t.getMessage(), t);
                            exception.addSuppressed(t);
                            break block33;
                        }
                    }
                    Pty pty = null;
                    if (this.useJna()) {
                        try {
                            pty = this.load(JnaSupport.class).current();
                        }
                        catch (Throwable t) {
                            Log.debug("Error creating JNA based pty: ", t.getMessage(), t);
                            exception.addSuppressed(t);
                        }
                    }
                    if (pty == null) {
                        try {
                            pty = ExecPty.current();
                        }
                        catch (Throwable t) {
                            Log.debug("Error creating exec based pty: ", t.getMessage(), t);
                            exception.addSuppressed(t);
                        }
                    }
                    if (pty != null) {
                        return new PosixSysTerminal(name, type, pty, encoding, this.nativeSignals, this.signalHandler);
                    }
                }
            }
            if (dumb == null || dumb.booleanValue()) {
                if (dumb == null) {
                    if (Log.isDebugEnabled()) {
                        Log.warn("Creating a dumb terminal", exception);
                    } else {
                        Log.warn("Unable to create a system terminal, creating a dumb terminal (enable debug logging for more information)");
                    }
                }
                return new DumbTerminal(name, type != null ? type : "dumb", new FileInputStream(FileDescriptor.in), new FileOutputStream(FileDescriptor.out), encoding, this.signalHandler);
            }
            throw exception;
        }
        if (this.useJna()) {
            try {
                Pty pty = this.load(JnaSupport.class).open(this.attributes, this.size);
                return new PosixPtyTerminal(name, type, pty, this.in, this.out, encoding, this.signalHandler);
            }
            catch (Throwable t) {
                Log.debug("Error creating JNA based pty: ", t.getMessage(), t);
            }
        }
        ExternalTerminal terminal = new ExternalTerminal(name, type, this.in, this.out, encoding, this.signalHandler);
        if (this.attributes != null) {
            terminal.setAttributes(this.attributes);
        }
        if (this.size != null) {
            terminal.setSize(this.size);
        }
        return terminal;
    }

    private boolean useJna() {
        return this.jna;
    }

    private <S> S load(Class<S> clazz) {
        return ServiceLoader.load(clazz, clazz.getClassLoader()).iterator().next();
    }
}

