/*
 * Decompiled with CFR 0.152.
 */
package executable;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import sun.misc.Signal;

final class LogFileOutputStream
extends FilterOutputStream {
    private final File file;
    private static final OutputStream NULL = new OutputStream(){

        @Override
        public void write(int b) {
        }

        @Override
        public void write(@NonNull byte[] b, int off, int len) {
        }
    };

    LogFileOutputStream(File file) throws FileNotFoundException {
        super(null);
        this.file = file;
        this.out = new FileOutputStream(file, true);
        if (File.pathSeparatorChar == ':') {
            Signal.handle(new Signal("ALRM"), signal -> {
                try {
                    this.reopen();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
    }

    public synchronized void reopen() throws IOException {
        this.out.close();
        this.out = NULL;
        this.out = new FileOutputStream(this.file, true);
    }

    @Override
    public synchronized void write(@NonNull byte[] b) throws IOException {
        this.out.write(b);
    }

    @Override
    public synchronized void write(@NonNull byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    @Override
    public synchronized void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public synchronized void close() throws IOException {
        this.out.close();
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.out.write(b);
    }

    public String toString() {
        return this.getClass().getName() + " -> " + this.file;
    }
}

