/*
 * Decompiled with CFR 0.152.
 */
package executable;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import executable.LogFileOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.MissingResourceException;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Main {
    private static final NavigableSet<Integer> SUPPORTED_JAVA_VERSIONS = new TreeSet<Integer>(Arrays.asList(11, 17));
    private static final Logger LOGGER = Logger.getLogger(Main.class.getName());
    private static final String JSESSIONID_COOKIE_NAME = System.getProperty("executableWar.jetty.sessionIdCookieName");
    private static final boolean DISABLE_CUSTOM_JSESSIONID_COOKIE_NAME = Boolean.getBoolean("executableWar.jetty.disableCustomSessionIdCookieName");
    private static final String ENABLE_FUTURE_JAVA_CLI_SWITCH = "--enable-future-java";
    private static final String[] HOME_NAMES = new String[]{"JENKINS_HOME", "HUDSON_HOME"};

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void verifyJavaVersion(int releaseVersion, boolean enableFutureJava) {
        if (SUPPORTED_JAVA_VERSIONS.contains(releaseVersion)) return;
        if (releaseVersion < (Integer)SUPPORTED_JAVA_VERSIONS.first()) throw new UnsupportedClassVersionError(String.format("Running with Java %d from %s, which is older than the minimum required version (Java %d).%nSupported Java versions are: %s", releaseVersion, System.getProperty("java.home"), SUPPORTED_JAVA_VERSIONS.first(), SUPPORTED_JAVA_VERSIONS));
        if (enableFutureJava) {
            LOGGER.log(Level.WARNING, "Running with Java {0} from {1}, which is not fully supported. Continuing because {2} is set. Supported Java versions are: {3}. See https://jenkins.io/redirect/java-support/ for more information.", new Object[]{releaseVersion, System.getProperty("java.home"), ENABLE_FUTURE_JAVA_CLI_SWITCH, SUPPORTED_JAVA_VERSIONS});
            return;
        } else {
            if (releaseVersion <= (Integer)SUPPORTED_JAVA_VERSIONS.last()) throw new UnsupportedClassVersionError(String.format("Running with Java %d from %s, which is not fully supported.%nRun the command again with the %s flag to bypass this error.%nSupported Java versions are: %s", releaseVersion, System.getProperty("java.home"), ENABLE_FUTURE_JAVA_CLI_SWITCH, SUPPORTED_JAVA_VERSIONS));
            throw new UnsupportedClassVersionError(String.format("Running with Java %d from %s, which is not yet fully supported.%nRun the command again with the %s flag to enable preview support for future Java versions.%nSupported Java versions are: %s", releaseVersion, System.getProperty("java.home"), ENABLE_FUTURE_JAVA_CLI_SWITCH, SUPPORTED_JAVA_VERSIONS));
        }
    }

    private static int getReleaseVersion() {
        String version = System.getProperty("java.specification.version");
        if ((version = version.trim()).startsWith("1.")) {
            String[] split = version.split("\\.");
            if (split.length != 2) {
                throw new NumberFormatException("Invalid Java specification version: " + version);
            }
            version = split[1];
        }
        return Integer.parseInt(version);
    }

    private static boolean isFutureJavaEnabled(String[] args) {
        return Main.hasArgument(ENABLE_FUTURE_JAVA_CLI_SWITCH, args) || Boolean.parseBoolean(System.getenv("JENKINS_ENABLE_FUTURE_JAVA"));
    }

    private static boolean hasArgument(@NonNull String argument, @NonNull String[] args) {
        for (String arg : args) {
            if (!argument.equals(arg)) continue;
            return true;
        }
        return false;
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="User provided values for running the program")
    public static void main(String[] args) throws IllegalAccessException {
        Field usage;
        Method mainMethod;
        Class<?> launcher;
        URLClassLoader cl;
        File tempFile;
        ArrayList<String> arguments;
        try {
            Main.verifyJavaVersion(Main.getReleaseVersion(), Main.isFutureJavaEnabled(args));
        }
        catch (UnsupportedClassVersionError e) {
            System.err.println(e.getMessage());
            System.err.println("See https://jenkins.io/redirect/java-support/ for more information.");
            System.exit(1);
        }
        if (Main.hasArgument("--paramsFromStdIn", args)) {
            System.out.println("--paramsFromStdIn detected. Parameters are going to be read from stdin. Other parameters passed directly will be ignored.");
            String argsInStdIn = Main.readStringNonBlocking(System.in, 131072).trim();
            args = argsInStdIn.split(" +");
        }
        if ((arguments = new ArrayList<String>(Arrays.asList(args))).contains("--version")) {
            System.out.println(Main.getVersion("?"));
            return;
        }
        File extractedFilesFolder = null;
        for (String arg : args) {
            if (!arg.startsWith("--extractedFilesFolder=") || (extractedFilesFolder = new File(arg.substring("--extractedFilesFolder=".length()))).isDirectory()) continue;
            System.err.println("The extractedFilesFolder value is not a directory. Ignoring.");
            extractedFilesFolder = null;
        }
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].startsWith("--logfile=")) continue;
            PrintStream ps = Main.createLogFileStream(new File(args[i].substring("--logfile=".length())));
            System.setOut(ps);
            System.setErr(ps);
            ArrayList<String> _args = new ArrayList<String>(Arrays.asList(args));
            _args.remove(i);
            args = _args.toArray(new String[0]);
            break;
        }
        for (String arg : args) {
            if (!arg.startsWith("--pluginroot=")) continue;
            System.setProperty("hudson.PluginManager.workDir", new File(arg.substring("--pluginroot=".length())).getAbsolutePath());
            break;
        }
        System.setProperty("java.awt.headless", "true");
        File me = Main.whoAmI(extractedFilesFolder);
        System.out.println("Running from: " + me);
        System.setProperty("executable-war", me.getAbsolutePath());
        Main.trimOffOurOptions(arguments);
        arguments.add(0, "--warfile=" + me.getAbsolutePath());
        if (!Main.hasOption(arguments, "--webroot=")) {
            File jenkinsHome = Main.getJenkinsHome();
            File webRoot = new File(jenkinsHome, "war");
            System.out.println("webroot: " + webRoot);
            arguments.add("--webroot=" + webRoot);
        }
        if (extractedFilesFolder != null) {
            Main.deleteContentsFromFolder(extractedFilesFolder, "winstone.*\\.jar");
        }
        File tmpJar = Main.extractFromJar("winstone.jar", "winstone", ".jar", extractedFilesFolder);
        tmpJar.deleteOnExit();
        try {
            tempFile = File.createTempFile("dummy", "dummy");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        Main.deleteWinstoneTempContents(new File(tempFile.getParent(), "winstone/" + me.getName()));
        if (!tempFile.delete()) {
            LOGGER.log(Level.WARNING, "Failed to delete the temporary file {0}", tempFile);
        }
        try {
            cl = new URLClassLoader(new URL[]{tmpJar.toURI().toURL()});
        }
        catch (MalformedURLException e) {
            throw new UncheckedIOException(e);
        }
        try {
            launcher = cl.loadClass("winstone.Launcher");
            mainMethod = launcher.getMethod("main", String[].class);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
        try {
            usage = launcher.getField("USAGE");
        }
        catch (NoSuchFieldException e) {
            throw new AssertionError((Object)e);
        }
        usage.set(null, "Jenkins Automation Server Engine " + Main.getVersion("") + "\nUsage: java -jar jenkins.war [--option=value] [--option=value]\n\nOptions:\n   --webroot                = folder where the WAR file is expanded into. Default is ${JENKINS_HOME}/war\n   --pluginroot             = folder where the plugin archives are expanded into. Default is ${JENKINS_HOME}/plugins\n                              (NOTE: this option does not change the directory where the plugin archives are stored)\n   --extractedFilesFolder   = folder where extracted files are to be located. Default is the temp folder\n   --logfile                = redirect log messages to this file\n   " + ENABLE_FUTURE_JAVA_CLI_SWITCH + "     = allows running with Java versions which are not fully supported\n   --paramsFromStdIn        = Read parameters from standard input (stdin)\n   --version                = Print version to standard output (stdout) and exit\n{OPTIONS}");
        if (!DISABLE_CUSTOM_JSESSIONID_COOKIE_NAME) {
            try {
                Field f = cl.loadClass("winstone.WinstoneSession").getField("SESSION_COOKIE_NAME");
                f.setAccessible(true);
                if (JSESSIONID_COOKIE_NAME != null) {
                    f.set(null, JSESSIONID_COOKIE_NAME);
                } else {
                    f.set(null, "JSESSIONID." + UUID.randomUUID().toString().replace("-", "").substring(0, 8));
                }
            }
            catch (ClassNotFoundException | NoSuchFieldException e) {
                throw new AssertionError((Object)e);
            }
        }
        Thread.currentThread().setContextClassLoader(cl);
        try {
            mainMethod.invoke(null, new Object[]{arguments.toArray(new String[0])});
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof IOException) {
                throw new UncheckedIOException((IOException)t);
            }
            if (t instanceof Exception) {
                throw new RuntimeException(t);
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new RuntimeException(e);
        }
    }

    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"}, justification="--logfile relies on the default encoding, fine")
    private static PrintStream createLogFileStream(File file) {
        LogFileOutputStream los;
        try {
            los = new LogFileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new UncheckedIOException(e);
        }
        return new PrintStream(los);
    }

    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING", "RR_NOT_CHECKED"}, justification="Legacy behavior, We expect less input than maxToRead")
    private static String readStringNonBlocking(InputStream in, int maxToRead) {
        byte[] buffer;
        try {
            buffer = new byte[Math.min(in.available(), maxToRead)];
            in.read(buffer);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return new String(buffer);
    }

    private static void trimOffOurOptions(List<String> arguments) {
        arguments.removeIf(arg -> arg.startsWith("--daemon") || arg.startsWith("--logfile") || arg.startsWith("--extractedFilesFolder") || arg.startsWith("--pluginroot") || arg.startsWith(ENABLE_FUTURE_JAVA_CLI_SWITCH));
    }

    private static String getVersion(String fallback) {
        try {
            Enumeration<URL> manifests = Main.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (manifests.hasMoreElements()) {
                URL res = manifests.nextElement();
                Manifest manifest = new Manifest(res.openStream());
                String v = manifest.getMainAttributes().getValue("Jenkins-Version");
                if (v == null) continue;
                return v;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return fallback;
    }

    private static boolean hasOption(List<String> args, String prefix) {
        for (String s : args) {
            if (!s.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN", "URLCONNECTION_SSRF_FD"}, justification="User provided values for running the program.")
    public static File whoAmI(File directory) {
        try {
            URL classFile = Main.class.getClassLoader().getResource("executable/Main.class");
            JarFile jf = ((JarURLConnection)classFile.openConnection()).getJarFile();
            return new File(jf.getName());
        }
        catch (Exception x) {
            File myself;
            System.err.println("ZipFile.name trick did not work, using fallback: " + x);
            try {
                myself = File.createTempFile("jenkins", ".jar", directory);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            myself.deleteOnExit();
            try (InputStream is = Main.class.getProtectionDomain().getCodeSource().getLocation().openStream();
                 FileOutputStream os = new FileOutputStream(myself);){
                Main.copyStream(is, os);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return myself;
        }
    }

    private static void copyStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[8192];
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="User provided values for running the program.")
    private static File extractFromJar(String resource, String fileName, String suffix, File directory) {
        File tmp;
        URL res = Main.class.getResource(resource);
        if (res == null) {
            throw new MissingResourceException("Unable to find the resource: " + resource, Main.class.getName(), resource);
        }
        try {
            tmp = File.createTempFile(fileName, suffix, directory);
        }
        catch (IOException e) {
            String tmpdir = directory == null ? System.getProperty("java.io.tmpdir") : directory.getAbsolutePath();
            throw new UncheckedIOException("Jenkins failed to create a temporary file in " + tmpdir + ": " + e, e);
        }
        try (InputStream is = res.openStream();
             FileOutputStream os = new FileOutputStream(tmp);){
            Main.copyStream(is, os);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        tmp.deleteOnExit();
        return tmp;
    }

    private static void deleteContentsFromFolder(File folder, String ... patterns) {
        File[] files = folder.listFiles();
        if (files != null) {
            for (File file : files) {
                for (String pattern : patterns) {
                    if (!file.getName().matches(pattern)) continue;
                    LOGGER.log(Level.FINE, "Deleting the temporary file {0}", file);
                    Main.deleteWinstoneTempContents(file);
                }
            }
        }
    }

    private static void deleteWinstoneTempContents(File file) {
        File[] files;
        if (!file.exists()) {
            LOGGER.log(Level.FINEST, "No file found at {0}, nothing to delete.", file);
            return;
        }
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File value : files) {
                Main.deleteWinstoneTempContents(value);
            }
        }
        if (!file.delete()) {
            LOGGER.log(Level.WARNING, "Failed to delete the temporary Winstone file {0}", file);
        }
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="User provided values for running the program.")
    private static File getJenkinsHome() {
        for (String name : HOME_NAMES) {
            String sysProp = System.getProperty(name);
            if (sysProp == null) continue;
            return new File(sysProp.trim());
        }
        for (String name : HOME_NAMES) {
            String env = System.getenv(name);
            if (env == null) continue;
            return new File(env.trim());
        }
        File legacyHome = new File(new File(System.getProperty("user.home")), ".hudson");
        if (legacyHome.exists()) {
            return legacyHome;
        }
        return new File(new File(System.getProperty("user.home")), ".jenkins");
    }
}

