/*
 * Decompiled with CFR 0.152.
 */
package wrappers;

import java.sql.SQLException;
import java.util.Hashtable;
import javax.sql.DataSource;
import oracle.jdbc.pool.OracleDataSource;
import wrappers.JdbcInterface;

public class OracleInterface
extends JdbcInterface {
    public OracleInterface() {
        this(true);
    }

    public OracleInterface(boolean b) {
        super(b);
        if (dst == null) {
            dst = new Hashtable();
        }
    }

    @Override
    public int JdbcConnect(String[] parms, int fsize, boolean scrollable) {
        int rc = 0;
        String url = parms[1];
        DataSource ds = null;
        OracleDataSource ods = null;
        if (this.DEBUG) {
            System.out.println("Connecting to Oracle data source");
        }
        try {
            this.CheckURL(url, "oracle");
            ds = (DataSource)dst.get(url);
            if (ds == null) {
                ods = new OracleDataSource();
                ods.setURL(url);
                if (parms[2] != null) {
                    ods.setUser(parms[2]);
                }
                if (parms[3] != null) {
                    ods.setPassword(parms[3]);
                }
                ds = ods;
                dst.put(url, ds);
            }
            this.conn = ds.getConnection();
            this.dbmd = this.conn.getMetaData();
            this.stmt = this.GetStmt(fsize, scrollable);
        }
        catch (SQLException se) {
            this.SetErrmsg(se);
            rc = -2;
        }
        catch (Exception e) {
            this.SetErrmsg(e);
            rc = -3;
        }
        return rc;
    }
}

