import{Color as t,ObjectWrapper as e,Settings as i}from"../common/common.js";import{Platform as s}from"../host/host.js";import{i18n as o}from"../i18n/i18n.js";import{NumberUtilities as r}from"../platform/platform.js";import{SDKModel as n,PerformanceMetricsModel as a}from"../sdk/sdk.js";import{ThemeSupport as l}from"../theme_support/theme_support.js";import{Widget as c,ARIAUtils as h,Icon as m}from"../ui/ui.js";const d={graphsDisplayingARealtimeViewOf:"Graphs displaying a real-time view of performance metrics",paused:"Paused",cpuUsage:"CPU usage",jsHeapSize:"JS heap size",domNodes:"DOM Nodes",jsEventListeners:"JS event listeners",documents:"Documents",documentFrames:"Document Frames",layoutsSec:"Layouts / sec",styleRecalcsSec:"Style recalcs / sec"},_=o.registerUIStrings("performance_monitor/PerformanceMonitor.js",d),g=o.getLocalizedString.bind(void 0,_);class f extends c.HBox{constructor(){super(!0),this.registerRequiredCSS("performance_monitor/performanceMonitor.css",{enableLegacyPatching:!0}),this.contentElement.classList.add("perfmon-pane"),this._metricsBuffer=[],this._pixelsPerMs=.01,this._pollIntervalMs=500,this._scaleHeight=16,this._graphHeight=90,this._gridColor=l.instance().patchColorText("rgba(0, 0, 0, 0.08)",l.ColorUsage.Foreground),this._controlPane=new u(this.contentElement);const t=this.contentElement.createChild("div","perfmon-chart-container");this._canvas=t.createChild("canvas"),this._canvas.tabIndex=-1,h.setAccessibleName(this._canvas,g(d.graphsDisplayingARealtimeViewOf)),this.contentElement.createChild("div","perfmon-chart-suspend-overlay fill").createChild("div").textContent=g(d.paused),this._controlPane.addEventListener(v.MetricChanged,this._recalcChartHeight,this),n.TargetManager.instance().observeModels(a.PerformanceMetricsModel,this),this._animationId,this._width,this._height}wasShown(){this._model&&(n.TargetManager.instance().addEventListener(n.Events.SuspendStateChanged,this._suspendStateChanged,this),this._model.enable(),this._suspendStateChanged())}willHide(){this._model&&(n.TargetManager.instance().removeEventListener(n.Events.SuspendStateChanged,this._suspendStateChanged,this),this._stopPolling(),this._model.disable())}modelAdded(t){this._model||(this._model=t,this.isShowing()&&this.wasShown())}modelRemoved(t){this._model===t&&(this.isShowing()&&this.willHide(),this._model=null)}_suspendStateChanged(){const t=n.TargetManager.instance().allTargetsSuspended();t?this._stopPolling():this._startPolling(),this.contentElement.classList.toggle("suspended",t)}_startPolling(){this._startTimestamp=0,this._pollTimer=window.setInterval((()=>this._poll()),this._pollIntervalMs),this.onResize();const t=()=>{this._draw(),this._animationId=this.contentElement.window().requestAnimationFrame((()=>{t()}))};t()}_stopPolling(){window.clearInterval(this._pollTimer),this.contentElement.window().cancelAnimationFrame(this._animationId),this._metricsBuffer=[]}async _poll(){if(!this._model)return;const t=await this._model.requestMetrics(),e=t.timestamp,i=t.metrics;this._metricsBuffer.push({timestamp:e,metrics:i});const s=this._width/this._pixelsPerMs,o=Math.ceil(s/this._pollIntervalMs*2);this._metricsBuffer.length>2*o&&this._metricsBuffer.splice(0,this._metricsBuffer.length-o),this._controlPane.updateMetrics(i)}_draw(){const t=this._canvas.getContext("2d");t.save(),t.scale(window.devicePixelRatio,window.devicePixelRatio),t.clearRect(0,0,this._width,this._height),t.save(),t.translate(0,this._scaleHeight);for(const e of this._controlPane.charts())this._controlPane.isActive(e.metrics[0].name)&&(this._drawChart(t,e,this._graphHeight),t.translate(0,this._graphHeight));t.restore(),this._drawHorizontalGrid(t),t.restore()}_drawHorizontalGrid(t){const e=l.instance().patchColorText("rgba(0, 0, 0, 0.02)",l.ColorUsage.Foreground);t.font="10px "+s.fontFamily(),t.fillStyle=l.instance().patchColorText("rgba(0, 0, 0, 0.55)",l.ColorUsage.Foreground);const i=Date.now()/1e3;for(let s=Math.ceil(i);;--s){const o=this._width-(1e3*(i-s)-this._pollIntervalMs)*this._pixelsPerMs;if(o<-50)break;t.beginPath(),t.moveTo(o,0),t.lineTo(o,this._height),s>=0&&s%10==0&&t.fillText(new Date(1e3*s).toLocaleTimeString(),o+4,12),t.strokeStyle=s%10?e:this._gridColor,t.stroke()}}_drawChart(e,i,o){e.save(),e.rect(0,0,this._width,o),e.clip();const r=1.05*this._calcMax(i),n=i.stacked?new Map:null,a=[];for(let t=i.metrics.length-1;t>=0;--t){const e=i.metrics[t];a.push({path:this._buildMetricPath(i,e,o-8,r,t?n:null),color:e.color})}const c=t.Color.parse(l.instance().patchColorText("white",l.ColorUsage.Background));if(c)for(const i of a.reverse()){const s=i.color;e.save();const o=t.Color.parse(s);o&&(e.fillStyle=c.blendWith(o.setAlpha(.2)).asString(null)||"",e.fill(i.path),e.strokeStyle=s,e.lineWidth=.5,e.stroke(i.path),e.restore())}e.fillStyle=l.instance().patchColorText("rgba(0, 0, 0, 0.55)",l.ColorUsage.Foreground),e.font="10px  "+s.fontFamily(),e.fillText(i.title,8,10),this._drawVerticalGrid(e,o-8,r,i),e.restore()}_calcMax(t){if(t.max)return t.max;const e=this._width,i=performance.now()-this._pollIntervalMs-e/this._pixelsPerMs;let s=-1/0;for(const e of t.metrics)for(let t=this._metricsBuffer.length-1;t>=0;--t){const o=this._metricsBuffer[t],r=o.metrics.get(e.name);if(void 0!==r&&(s=Math.max(s,r)),o.timestamp<i)break}if(!this._metricsBuffer.length)return 10;const o=Math.pow(10,Math.floor(Math.log10(s)));s=Math.ceil(s/o/2)*o*2;return t.currentMax=.2*s+.8*(t.currentMax||s),t.currentMax}_drawVerticalGrid(t,e,i,s){let o=Math.pow(10,Math.floor(Math.log10(i)));const r=Math.floor(i/o);1!==r&&r%2==1&&(o*=2);let n=Math.floor(i/o)*o;const a=i,c=e-18;t.fillStyle=l.instance().patchColorText("rgba(0, 0, 0, 0.55)",l.ColorUsage.Foreground),t.strokeStyle=this._gridColor,t.beginPath();for(let e=0;e<2;++e){const e=h(n),i=S._formatNumber(n,s);t.moveTo(0,e),t.lineTo(4,e),t.moveTo(t.measureText(i).width+12,e),t.lineTo(this._width,e),t.fillText(i,8,h(n)+3),n/=2}function h(t){return Math.round(e-c*t/a)+.5}t.stroke(),t.beginPath(),t.moveTo(0,e+.5),t.lineTo(this._width,e+.5),t.strokeStyle=l.instance().patchColorText("rgba(0, 0, 0, 0.2)",l.ColorUsage.Foreground),t.stroke()}_buildMetricPath(t,e,i,s,o){const n=new Path2D,a=i-18;if(a<1)return n;const l=s,c=e.name,h=this._pixelsPerMs,m=performance.now()-this._pollIntervalMs-this._width/h,d=t.smooth;let _=0,g=0,f=0;this._metricsBuffer.length&&(_=(this._metricsBuffer[0].timestamp-m)*h,n.moveTo(_,p(0)),n.lineTo(this._width+5,p(0)),g=p(this._metricsBuffer[this._metricsBuffer.length-1].metrics.get(c)||0),f=this._width+5,n.lineTo(f,g));for(let t=this._metricsBuffer.length-1;t>=0;--t){const e=this._metricsBuffer[t],i=e.timestamp;let s=e.metrics.get(c)||0;o&&(s+=o.get(i)||0,s=r.clamp(s,0,1),o.set(i,s));const a=p(s);if(_=(i-m)*h,d){const t=(f+_)/2;n.bezierCurveTo(t,g,t,a,_,a)}else n.lineTo(_,g),n.lineTo(_,a);if(f=_,g=a,i<m)break}return n;function p(t){return Math.round(i-a*t/l)+.5}}onResize(){super.onResize(),this._width=this._canvas.offsetWidth,this._canvas.width=Math.round(this._width*window.devicePixelRatio),this._recalcChartHeight()}_recalcChartHeight(){let t=this._scaleHeight;for(const e of this._controlPane.charts())this._controlPane.isActive(e.metrics[0].name)&&(t+=this._graphHeight);this._height=Math.ceil(t*window.devicePixelRatio),this._canvas.height=this._height,this._canvas.style.height=this._height/window.devicePixelRatio+"px"}}const p={Percent:Symbol("Percent"),Bytes:Symbol("Bytes")};class u extends e.ObjectWrapper{constructor(t){super(),this.element=t.createChild("div","perfmon-control-pane"),this._enabledChartsSetting=i.Settings.instance().createSetting("perfmonActiveIndicators2",["TaskDuration","JSHeapTotalSize","Nodes"]),this._enabledCharts=new Set(this._enabledChartsSetting.get());const e=p,s={color:void 0,format:void 0,currentMax:void 0,max:void 0,smooth:void 0,stacked:void 0};this._chartsInfo=[{...s,title:g(d.cpuUsage),metrics:[{name:"TaskDuration",color:"#999"},{name:"ScriptDuration",color:"orange"},{name:"LayoutDuration",color:"blueviolet"},{name:"RecalcStyleDuration",color:"violet"}],format:e.Percent,smooth:!0,stacked:!0,color:"red",max:1,currentMax:void 0},{...s,title:g(d.jsHeapSize),metrics:[{name:"JSHeapTotalSize",color:"#99f"},{name:"JSHeapUsedSize",color:"blue"}],format:e.Bytes,color:"blue"},{...s,title:g(d.domNodes),metrics:[{name:"Nodes",color:"green"}]},{...s,title:g(d.jsEventListeners),metrics:[{name:"JSEventListeners",color:"yellowgreen"}]},{...s,title:g(d.documents),metrics:[{name:"Documents",color:"darkblue"}]},{...s,title:g(d.documentFrames),metrics:[{name:"Frames",color:"darkcyan"}]},{...s,title:g(d.layoutsSec),metrics:[{name:"LayoutCount",color:"hotpink"}]},{...s,title:g(d.styleRecalcsSec),metrics:[{name:"RecalcStyleCount",color:"deeppink"}]}];for(const t of this._chartsInfo){t.color&&(t.color=l.instance().patchColorText(t.color,l.ColorUsage.Foreground));for(const e of t.metrics)e.color=l.instance().patchColorText(e.color,l.ColorUsage.Foreground)}this._indicators=new Map;for(const t of this._chartsInfo){const e=t.metrics[0].name,i=this._enabledCharts.has(e),s=new S(this.element,t,i,this._onToggle.bind(this,e));this._indicators.set(e,s)}}_onToggle(t,e){e?this._enabledCharts.add(t):this._enabledCharts.delete(t),this._enabledChartsSetting.set(Array.from(this._enabledCharts)),this.dispatchEventToListeners(v.MetricChanged)}charts(){return this._chartsInfo}isActive(t){return this._enabledCharts.has(t)}updateMetrics(t){for(const e of this._indicators.keys()){const i=t.get(e);if(void 0!==i){const t=this._indicators.get(e);t&&t.setValue(i)}}}}const v={MetricChanged:Symbol("MetricChanged")};let w,C;class S{constructor(t,e,i,s){const o=e.color||e.metrics[0].color;this._info=e,this._active=i,this._onToggle=s,this.element=t.createChild("div","perfmon-indicator"),this._swatchElement=m.Icon.create("smallicon-checkmark-square","perfmon-indicator-swatch"),this._swatchElement.style.backgroundColor=o,this.element.appendChild(this._swatchElement),this.element.createChild("div","perfmon-indicator-title").textContent=e.title,this._valueElement=this.element.createChild("div","perfmon-indicator-value"),this._valueElement.style.color=o,this.element.addEventListener("click",(()=>this._toggleIndicator())),this.element.addEventListener("keypress",(t=>this._handleKeypress(t))),this.element.classList.toggle("active",i),h.markAsCheckbox(this.element),h.setChecked(this.element,this._active),this.element.tabIndex=0}static _formatNumber(t,e){switch(w||(w=new Intl.NumberFormat("en-US",{maximumFractionDigits:1}),C=new Intl.NumberFormat("en-US",{maximumFractionDigits:1,style:"percent"})),e.format){case p.Percent:return C.format(t);case p.Bytes:return r.bytesToString(t);default:return w.format(t)}}setValue(t){this._valueElement.textContent=S._formatNumber(t,this._info)}_toggleIndicator(){this._active=!this._active,this.element.classList.toggle("active",this._active),h.setChecked(this.element,this._active),this._onToggle(this._active)}_handleKeypress(t){const e=t;" "!==e.key&&"Enter"!==e.key||this._toggleIndicator()}}const M=new Intl.NumberFormat("en-US",{maximumFractionDigits:1});var b=Object.freeze({__proto__:null,UIStrings:d,PerformanceMonitorImpl:f,Format:p,ControlPane:u,Events:v,MetricIndicator:S,format:M,MetricInfo:undefined,ChartInfo:undefined});export{b as PerformanceMonitor};
