import{NetworkProject as e}from"../bindings/bindings.js";import{Settings as t,ParsedURL as s,ResourceType as i,ObjectWrapper as n,Console as o,EventTarget as r,Throttler as d,CharacterIdMap as a,Trie as l,Revealer as c}from"../common/common.js";import{i18n as h}from"../i18n/i18n.js";import{Multimap as u,ArrayUtilities as m,StringUtilities as p}from"../platform/platform.js";import{SDKModel as _,NetworkManager as f,Resource as S}from"../sdk/sdk.js";import{Workspace as g,UISourceCode as y,FileManager as F}from"../workspace/workspace.js";import{TextUtils as v}from"../text_utils/text_utils.js";import{InspectorFrontendHost as C,Platform as w,userMetrics as P,UserMetrics as k,InspectorFrontendHostAPI as I}from"../host/host.js";import{Linkifier as b}from"../components/components.js";import{Icon as E,Tooltip as x,Widget as T,UIUtils as U,ListWidget as R,ARIAUtils as L,Toolbar as j}from"../ui/ui.js";const M={unableToReadFilesWithThis:"Unable to read files with this implementation."},W=h.registerUIStrings("persistence/PlatformFileSystem.js",M),A=h.getLocalizedString.bind(void 0,W);class B{constructor(e,t){this._path=e,this._type=t}getMetadata(e){return Promise.resolve(null)}initialFilePaths(){return[]}initialGitFolders(){return[]}path(){return this._path}embedderPath(){throw new Error("Not implemented")}type(){return this._type}async createFile(e,t){return Promise.resolve(null)}deleteFile(e){return Promise.resolve(!1)}requestFileBlob(e){return Promise.resolve(null)}async requestFileContent(e){return{content:null,error:A(M.unableToReadFilesWithThis),isEncoded:!1}}setFileContent(e,t,s){throw new Error("Not implemented")}renameFile(e,t,s){s(!1)}addExcludedFolder(e){}removeExcludedFolder(e){}fileSystemRemoved(){}isFileExcluded(e){return!1}excludedFolders(){return new Set}searchInPath(e,t){return Promise.resolve([])}indexContent(e){queueMicrotask((()=>{e.done()}))}mimeFromPath(e){throw new Error("Not implemented")}canExcludeFolder(e){return!1}contentType(e){throw new Error("Not implemented")}tooltipForURL(e){throw new Error("Not implemented")}supportsAutomapping(){throw new Error("Not implemented")}}var N=Object.freeze({__proto__:null,UIStrings:M,PlatformFileSystem:B});const H={fileSystemErrorS:"File system error: {PH1}",blobCouldNotBeLoaded:"Blob could not be loaded.",cantReadFileSS:"Can't read file: {PH1}: {PH2}",unknownErrorReadingFileS:"Unknown error reading file: {PH1}",linkedToS:"Linked to {PH1}"},q=h.registerUIStrings("persistence/IsolatedFileSystem.js",H),O=h.getLocalizedString.bind(void 0,q);class z extends B{constructor(e,s,i,n,o){super(s,o),this._manager=e,this._embedderPath=i,this._domFileSystem=n,this._excludedFoldersSetting=t.Settings.instance().createLocalSetting("workspaceExcludedFolders",{}),this._excludedFolders=new Set(this._excludedFoldersSetting.get()[s]||[]),this._excludedEmbedderFolders=[],this._initialFilePaths=new Set,this._initialGitFolders=new Set,this._fileLocks=new Map}static create(e,t,s,i,n,o){const r=C.InspectorFrontendHostInstance.isolatedFileSystem(n,o);if(!r)return Promise.resolve(null);const d=new z(e,t,s,r,i);return d._initializeFilePaths().then((()=>d)).catch((e=>(console.error(e),null)))}static errorMessage(e){return O(H.fileSystemErrorS,{PH1:e.message})}_serializedFileOperation(e,t){const s=Promise.resolve(this._fileLocks.get(e)).then((()=>t.call(null)));return this._fileLocks.set(e,s),s}getMetadata(e){let t;const s=new Promise((e=>{t=e}));return this._domFileSystem.root.getFile(e,void 0,(function(e){e.getMetadata(t,i)}),i),s;function i(s){const i=z.errorMessage(s);console.error(i+" when getting file metadata '"+e),t(null)}}initialFilePaths(){return[...this._initialFilePaths]}initialGitFolders(){return[...this._initialGitFolders]}embedderPath(){return this._embedderPath}_initializeFilePaths(){return new Promise((e=>{let t=1;const i=function(n){for(let e=0;e<n.length;++e){const o=n[e];if(o.isDirectory){if(o.fullPath.endsWith("/.git")){const e=o.fullPath.lastIndexOf("/"),t=o.fullPath.substring(1,e);this._initialGitFolders.add(t)}if(this.isFileExcluded(o.fullPath+"/")){this._excludedEmbedderFolders.push(s.ParsedURL.urlToPlatformPath(this.path()+o.fullPath,w.isWin()));continue}++t,this._requestEntries(o.fullPath,i)}else{if(this.isFileExcluded(o.fullPath))continue;this._initialFilePaths.add(o.fullPath.substr(1))}}0==--t&&e()}.bind(this);this._requestEntries("",i)}))}async _createFoldersIfNotExist(e){let t=await new Promise((t=>this._domFileSystem.root.getDirectory(e,void 0,t,(()=>t(null)))));if(t)return t;const s=e.split("/");let i="";for(const e of s)if(i=i+"/"+e,t=await this._innerCreateFolderIfNeeded(i),!t)return null;return t}_innerCreateFolderIfNeeded(e){return new Promise((t=>{this._domFileSystem.root.getDirectory(e,{create:!0},(e=>t(e)),(s=>{const i=z.errorMessage(s);console.error(i+" trying to create directory '"+e+"'"),t(null)}))}))}async createFile(e,t){const s=await this._createFoldersIfNotExist(e);if(!s)return null;const i=await this._serializedFileOperation(e,function t(i,n){return new Promise((o=>{const r=i+(n||"");s.getFile(r,{create:!0,exclusive:!0},o,(s=>{if("InvalidModificationError"===s.name)return void o(t.call(this,i,n?n+1:1));const d=z.errorMessage(s);console.error(d+" when testing if file exists '"+this.path()+"/"+e+"/"+r+"'"),o(null)}))}))}.bind(this,t||"NewFile"));return i?i.fullPath.substr(1):null}deleteFile(e){let t;const s=new Promise((e=>{t=e}));return this._domFileSystem.root.getFile(e,void 0,function(e){e.remove(i,n.bind(this))}.bind(this),n.bind(this)),s;function i(){t(!0)}function n(s){const i=z.errorMessage(s);console.error(i+" when deleting file '"+this.path()+"/"+e+"'"),t(!1)}}requestFileBlob(e){return new Promise((t=>{function s(s){if("NotFoundError"===s.name)return void t(null);const i=z.errorMessage(s);console.error(i+" when getting content for file '"+this.path()+"/"+e+"'"),t(null)}this._domFileSystem.root.getFile(e,void 0,(e=>{e.file(t,s.bind(this))}),s.bind(this))}))}requestFileContent(e){return this._serializedFileOperation(e,(()=>this._innerRequestFileContent(e)))}async _innerRequestFileContent(e){const t=await this.requestFileBlob(e);if(!t)return{content:null,error:O(H.blobCouldNotBeLoaded),isEncoded:!1};const i=new FileReader,n=s.ParsedURL.extractExtension(e),o=J.has(n),r=new Promise((e=>{i.onloadend=e}));if(o?i.readAsBinaryString(t):i.readAsText(t),await r,i.error){const t=O(H.cantReadFileSS,{PH1:e,PH2:i.error});return console.error(t),{content:null,isEncoded:!1,error:t}}let d=null,a=null;try{d=i.result}catch(t){d=null,a=O(H.cantReadFileSS,{PH1:e,PH2:t.message})}return null==d?(a=a||O(H.unknownErrorReadingFileS,{PH1:e}),console.error(a),{content:null,isEncoded:!1,error:a}):{isEncoded:o,content:o?btoa(d):d}}async setFileContent(e,t,s){let i;P.actionTaken(k.Action.FileSavedInWorkspace);function n(e){e.createWriter(o.bind(this),r.bind(this))}async function o(e){let n;e.onerror=r.bind(this),e.onwriteend=function(){e.onwriteend=i,e.truncate(n.size)},n=s?await(await fetch("data:application/octet-stream;base64,"+t)).blob():new Blob([t],{type:"text/plain"}),e.write(n)}function r(t){const s=z.errorMessage(t);console.error(s+" when setting content for file '"+this.path()+"/"+e+"'"),i(void 0)}this._serializedFileOperation(e,(()=>{const t=new Promise((e=>{i=e}));return this._domFileSystem.root.getFile(e,{create:!0},n.bind(this),r.bind(this)),t}))}renameFile(e,t,s){if(!(t=t?t.trim():t)||-1!==t.indexOf("/"))return void s(!1);let i,n;function o(e){n=e,n.getFile(t,void 0,r,d.bind(this))}function r(e){s(!1)}function d(e){"NotFoundError"===e.name?i.moveTo(n,t,a,l.bind(this)):s(!1)}function a(e){s(!0,e.name)}function l(i){const n=z.errorMessage(i);console.error(n+" when renaming file '"+this.path()+"/"+e+"' to '"+t+"'"),s(!1)}this._domFileSystem.root.getFile(e,void 0,function(e){if(e.name===t)return void s(!1);i=e,i.getParent(o.bind(this),l.bind(this))}.bind(this),l.bind(this))}_readDirectory(e,t){const s=e.createReader();let i=[];function n(s){const i=z.errorMessage(s);console.error(i+" when reading directory '"+e.fullPath+"'"),t([])}s.readEntries((function e(o){var r;o.length?(i=i.concat((r=o,Array.prototype.slice.call(r||[],0))),s.readEntries(e,n)):t(i.sort())}),n)}_requestEntries(e,t){this._domFileSystem.root.getDirectory(e,void 0,function(e){this._readDirectory(e,t)}.bind(this),(function(s){const i=z.errorMessage(s);console.error(i+" when requesting entry '"+e+"'"),t([])}))}_saveExcludedFolders(){const e=this._excludedFoldersSetting.get();e[this.path()]=[...this._excludedFolders],this._excludedFoldersSetting.set(e)}addExcludedFolder(e){this._excludedFolders.add(e),this._saveExcludedFolders(),this._manager.dispatchEventToListeners(te.ExcludedFolderAdded,e)}removeExcludedFolder(e){this._excludedFolders.delete(e),this._saveExcludedFolders(),this._manager.dispatchEventToListeners(te.ExcludedFolderRemoved,e)}fileSystemRemoved(){const e=this._excludedFoldersSetting.get();delete e[this.path()],this._excludedFoldersSetting.set(e)}isFileExcluded(e){if(this._excludedFolders.has(e))return!0;const t=this._manager.workspaceFolderExcludePatternSetting().asRegExp();return Boolean(t&&t.test(e))}excludedFolders(){return this._excludedFolders}searchInPath(e,t){return new Promise((i=>{const n=this._manager.registerCallback((function(e){i(e.map((e=>s.ParsedURL.platformPathToURL(e)))),t.worked(1)}));C.InspectorFrontendHostInstance.searchInPath(n,this._embedderPath,e)}))}indexContent(e){e.setTotalWork(1);const t=this._manager.registerProgress(e);C.InspectorFrontendHostInstance.indexPath(t,this._embedderPath,JSON.stringify(this._excludedEmbedderFolders))}mimeFromPath(e){return i.ResourceType.mimeFromURL(e)||"text/plain"}canExcludeFolder(e){return Boolean(e)&&"overrides"!==this.type()}contentType(e){const t=s.ParsedURL.extractExtension(e);return D.has(t)?i.resourceTypes.Stylesheet:G.has(t)?i.resourceTypes.Document:$.has(t)?i.resourceTypes.Image:V.has(t)?i.resourceTypes.Script:J.has(t)?i.resourceTypes.Other:i.resourceTypes.Document}tooltipForURL(e){const t=s.ParsedURL.urlToPlatformPath(e,w.isWin()).trimMiddle(150);return O(H.linkedToS,{PH1:t})}supportsAutomapping(){return"overrides"!==this.type()}}const D=new Set(["css","scss","sass","less"]),G=new Set(["htm","html","asp","aspx","phtml","jsp"]),V=new Set(["asp","aspx","c","cc","cljs","coffee","cpp","cs","dart","java","js","jsp","jsx","h","m","mjs","mm","py","sh","ts","tsx","ls"]),$=new Set(["jpeg","jpg","svg","gif","webp","png","ico","tiff","tif","bmp"]),J=new Set(["cmd","com","exe","a","ar","iso","tar","bz2","gz","lz","lzma","z","7z","apk","arc","cab","dmg","jar","pak","rar","zip","3gp","aac","aiff","flac","m4a","mmf","mp3","ogg","oga","raw","sln","wav","wma","webm","mkv","flv","vob","ogv","gifv","avi","mov","qt","mp4","m4p","m4v","mpg","mpeg","jpeg","jpg","gif","webp","png","ico","tiff","tif","bmp"]);var Y=Object.freeze({__proto__:null,UIStrings:H,IsolatedFileSystem:z,BinaryExtensions:J});const K={unableToAddFilesystemS:"Unable to add filesystem: {PH1}"},Q=h.registerUIStrings("persistence/IsolatedFileSystemManager.js",K),X=h.getLocalizedString.bind(void 0,Q);let Z;class ee extends n.ObjectWrapper{constructor(){super(),this._fileSystems=new Map,this._callbacks=new Map,this._progresses=new Map,C.InspectorFrontendHostInstance.events.addEventListener(I.Events.FileSystemRemoved,this._onFileSystemRemoved,this),C.InspectorFrontendHostInstance.events.addEventListener(I.Events.FileSystemAdded,(e=>{this._onFileSystemAdded(e)}),this),C.InspectorFrontendHostInstance.events.addEventListener(I.Events.FileSystemFilesChangedAddedRemoved,this._onFileSystemFilesChanged,this),C.InspectorFrontendHostInstance.events.addEventListener(I.Events.IndexingTotalWorkCalculated,this._onIndexingTotalWorkCalculated,this),C.InspectorFrontendHostInstance.events.addEventListener(I.Events.IndexingWorked,this._onIndexingWorked,this),C.InspectorFrontendHostInstance.events.addEventListener(I.Events.IndexingDone,this._onIndexingDone,this),C.InspectorFrontendHostInstance.events.addEventListener(I.Events.SearchCompleted,this._onSearchCompleted,this);const e=["/Thumbs.db$","/ehthumbs.db$","/Desktop.ini$","/\\$RECYCLE.BIN/"],s=["/\\.DS_Store$","/\\.Trashes$","/\\.Spotlight-V100$","/\\.AppleDouble$","/\\.LSOverride$","/Icon$","/\\._.*$"],i=["/.*~$"];let n=["/node_modules/","/bower_components/","/\\.devtools","/\\.git/","/\\.sass-cache/","/\\.hg/","/\\.idea/","/\\.svn/","/\\.cache/","/\\.project/"];n=w.isWin()?n.concat(e):w.isMac()?n.concat(s):n.concat(i);const o=n.join("|");this._workspaceFolderExcludePatternSetting=t.Settings.instance().createRegExpSetting("workspaceFolderExcludePattern",o,w.isWin()?"i":""),this._fileSystemRequestResolve=null,this._fileSystemsLoadedPromise=this._requestFileSystems()}static instance(e={forceNew:null}){const{forceNew:t}=e;return Z&&!t||(Z=new ee),Z}_requestFileSystems(){let e;const t=new Promise((t=>{e=t}));return C.InspectorFrontendHostInstance.events.addEventListener(I.Events.FileSystemsLoaded,(function(e){const t=e.data,i=[];for(let e=0;e<t.length;++e)i.push(this._innerAddFileSystem(t[e],!1));Promise.all(i).then(s)}),this),C.InspectorFrontendHostInstance.requestFileSystems(),t;function s(t){e(t.filter((e=>Boolean(e))))}}addFileSystem(e){return new Promise((t=>{this._fileSystemRequestResolve=t,C.InspectorFrontendHostInstance.addFileSystem(e||"")}))}removeFileSystem(e){C.InspectorFrontendHostInstance.removeFileSystem(e.embedderPath())}waitForFileSystems(){return this._fileSystemsLoadedPromise}_innerAddFileSystem(e,t){const i=e.fileSystemPath,n=s.ParsedURL.platformPathToURL(e.fileSystemPath);return z.create(this,n,i,e.type,e.fileSystemName,e.rootURL).then(function(e){if(!e)return null;this._fileSystems.set(n,e),t&&this.dispatchEventToListeners(te.FileSystemAdded,e);return e}.bind(this))}addPlatformFileSystem(e,t){this._fileSystems.set(e,t),this.dispatchEventToListeners(te.FileSystemAdded,t)}_onFileSystemAdded(e){const t=e.data.errorMessage,s=e.data.fileSystem;if(t){if("<selection cancelled>"!==t&&o.Console.instance().error(X(K.unableToAddFilesystemS,{PH1:t})),!this._fileSystemRequestResolve)return;this._fileSystemRequestResolve.call(null,null),this._fileSystemRequestResolve=null}else s&&this._innerAddFileSystem(s,!0).then((e=>{this._fileSystemRequestResolve&&(this._fileSystemRequestResolve.call(null,e),this._fileSystemRequestResolve=null)}))}_onFileSystemRemoved(e){const t=e.data,i=s.ParsedURL.platformPathToURL(t),n=this._fileSystems.get(i);n&&(this._fileSystems.delete(i),n.fileSystemRemoved(),this.dispatchEventToListeners(te.FileSystemRemoved,n))}_onFileSystemFilesChanged(e){const t={changed:i.call(this,e.data.changed),added:i.call(this,e.data.added),removed:i.call(this,e.data.removed)};function i(e){const t=new u;for(const i of e){const e=s.ParsedURL.platformPathToURL(i);for(const s of this._fileSystems.keys()){const n=this._fileSystems.get(s);if(n&&n.isFileExcluded(i))continue;const o=s.endsWith("/")?s:s+"/";e.startsWith(o)&&t.set(s,e)}}return t}this.dispatchEventToListeners(te.FileSystemFilesChanged,t)}fileSystems(){return[...this._fileSystems.values()]}fileSystem(e){return this._fileSystems.get(e)||null}workspaceFolderExcludePatternSetting(){return this._workspaceFolderExcludePatternSetting}registerCallback(e){const t=++se;return this._callbacks.set(t,e),t}registerProgress(e){const t=++se;return this._progresses.set(t,e),t}_onIndexingTotalWorkCalculated(e){const t=e.data.requestId,s=e.data.totalWork,i=this._progresses.get(t);i&&i.setTotalWork(s)}_onIndexingWorked(e){const t=e.data.requestId,s=e.data.worked,i=this._progresses.get(t);i&&(i.worked(s),i.isCanceled()&&(C.InspectorFrontendHostInstance.stopIndexing(t),this._onIndexingDone(e)))}_onIndexingDone(e){const t=e.data.requestId,s=this._progresses.get(t);s&&(s.done(),this._progresses.delete(t))}_onSearchCompleted(e){const t=e.data.requestId,s=e.data.files,i=this._callbacks.get(t);i&&(i.call(null,s),this._callbacks.delete(t))}}const te={FileSystemAdded:Symbol("FileSystemAdded"),FileSystemRemoved:Symbol("FileSystemRemoved"),FileSystemFilesChanged:Symbol("FileSystemFilesChanged"),ExcludedFolderAdded:Symbol("ExcludedFolderAdded"),ExcludedFolderRemoved:Symbol("ExcludedFolderRemoved")};let se=0;var ie=Object.freeze({__proto__:null,UIStrings:K,IsolatedFileSystemManager:ee,Events:te,FileSystem:undefined});class ne{constructor(e,t){this._isolatedFileSystemManager=e,this._workspace=t,this._eventListeners=[this._isolatedFileSystemManager.addEventListener(te.FileSystemAdded,this._onFileSystemAdded,this),this._isolatedFileSystemManager.addEventListener(te.FileSystemRemoved,this._onFileSystemRemoved,this),this._isolatedFileSystemManager.addEventListener(te.FileSystemFilesChanged,this._fileSystemFilesChanged,this)],this._boundFileSystems=new Map,this._isolatedFileSystemManager.waitForFileSystems().then(this._onFileSystemsLoaded.bind(this))}static projectId(e){return e}static relativePath(e){const t=e.project()._fileSystemBaseURL;return e.url().substring(t.length).split("/")}static tooltipForUISourceCode(e){return e.project()._fileSystem.tooltipForURL(e.url())}static fileSystemType(e){return e._fileSystem.type()}static fileSystemSupportsAutomapping(e){return e._fileSystem.supportsAutomapping()}static completeURL(e,t){return e._fileSystemBaseURL+t}static fileSystemPath(e){return e}fileSystemManager(){return this._isolatedFileSystemManager}_onFileSystemsLoaded(e){for(const t of e)this._addFileSystem(t)}_onFileSystemAdded(e){const t=e.data;this._addFileSystem(t)}_addFileSystem(e){const t=new oe(this,e,this._workspace);this._boundFileSystems.set(e.path(),t)}_onFileSystemRemoved(e){const t=e.data,s=this._boundFileSystems.get(t.path());s&&s.dispose(),this._boundFileSystems.delete(t.path())}_fileSystemFilesChanged(e){const t=e.data;for(const e of t.changed.keysArray()){const s=this._boundFileSystems.get(e);s&&t.changed.get(e).forEach((e=>s._fileChanged(e)))}for(const e of t.added.keysArray()){const s=this._boundFileSystems.get(e);s&&t.added.get(e).forEach((e=>s._fileChanged(e)))}for(const e of t.removed.keysArray()){const s=this._boundFileSystems.get(e);s&&t.removed.get(e).forEach((e=>s.removeUISourceCode(e)))}}dispose(){r.EventTarget.removeEventListeners(this._eventListeners);for(const e of this._boundFileSystems.values())e.dispose(),this._boundFileSystems.delete(e._fileSystem.path())}}class oe extends g.ProjectStore{constructor(e,t,s){const i=t.path(),n=ne.projectId(i);console.assert(!s.project(n));const o=i.substr(i.lastIndexOf("/")+1);super(s,n,g.projectTypes.FileSystem,o),this._fileSystem=t,this._fileSystemBaseURL=this._fileSystem.path()+"/",this._fileSystemParentURL=this._fileSystemBaseURL.substr(0,i.lastIndexOf("/")+1),this._fileSystemWorkspaceBinding=e,this._fileSystemPath=i,this._creatingFilesGuard=new Set,s.addProject(this),this.populate()}fileSystemPath(){return this._fileSystemPath}fileSystem(){return this._fileSystem}mimeType(e){return this._fileSystem.mimeFromPath(e.url())}initialGitFolders(){return this._fileSystem.initialGitFolders().map((e=>this._fileSystemPath+"/"+e))}_filePathForUISourceCode(e){return e.url().substring(this._fileSystemPath.length)}isServiceProject(){return!1}requestMetadata(e){const t=re.get(e);if(t)return t;const s=this._filePathForUISourceCode(e),i=this._fileSystem.getMetadata(s).then((function(e){if(!e)return null;return new y.UISourceCodeMetadata(e.modificationTime,e.size)}));return re.set(e,i),i}requestFileBlob(e){return this._fileSystem.requestFileBlob(this._filePathForUISourceCode(e))}requestFileContent(e){const t=this._filePathForUISourceCode(e);return this._fileSystem.requestFileContent(t)}canSetFileContent(){return!0}async setFileContent(e,t,s){const i=this._filePathForUISourceCode(e);await this._fileSystem.setFileContent(i,t,s)}fullDisplayName(e){const t=e.project()._fileSystemParentURL;return e.url().substring(t.length)}canRename(){return!0}rename(e,t,s){if(t===e.name())return void s(!0,e.name(),e.url(),e.contentType());let i=this._filePathForUISourceCode(e);this._fileSystem.renameFile(i,t,function(t,n){if(!t||!n)return void s(!1,n);console.assert(Boolean(n));const o=i.lastIndexOf("/"),r=i.substring(0,o);i=r+"/"+n,i=i.substr(1);const d=this._fileSystemBaseURL+i,a=this._fileSystem.contentType(n);this.renameUISourceCode(e,n),s(!0,n,d,a)}.bind(this))}async searchInFileContent(e,t,s,i){const n=this._filePathForUISourceCode(e),{content:o}=await this._fileSystem.requestFileContent(n);return o?v.performSearchInContent(o,t,s,i):[]}async findFilesMatchingSearchRequest(e,t,s){let i=t;const n=e.queries().slice();n.length||n.push(""),s.setTotalWork(n.length);for(const t of n){const n=await this._fileSystem.searchInPath(e.isRegex()?"":t,s);i=m.intersectOrdered(i,n.sort(),String.naturalOrderComparator),s.worked(1)}return s.done(),i}indexContent(e){this._fileSystem.indexContent(e)}populate(){const e=this._fileSystem.initialFilePaths();(function t(s){const i=Math.min(s+1e3,e.length);for(let t=s;t<i;++t)this._addFile(e[t]);i<e.length&&setTimeout(t.bind(this,i),100)}).call(this,0)}excludeFolder(e){let t=e.substring(this._fileSystemBaseURL.length);t.startsWith("/")||(t="/"+t),t.endsWith("/")||(t+="/"),this._fileSystem.addExcludedFolder(t);const s=this.uiSourceCodes().slice();for(let t=0;t<s.length;++t){const i=s[t];i.url().startsWith(e)&&this.removeUISourceCode(i.url())}}canExcludeFolder(e){return this._fileSystem.canExcludeFolder(e)}canCreateFile(){return!0}async createFile(e,t,s,i){const n=this._fileSystemPath+e+(e.endsWith("/")?"":"/")+t;this._creatingFilesGuard.add(n);const o=await this._fileSystem.createFile(e,t);if(!o)return null;const r=this._addFile(o);return r.setContent(s,Boolean(i)),this._creatingFilesGuard.delete(n),r}deleteFile(e){const t=this._filePathForUISourceCode(e);this._fileSystem.deleteFile(t).then((t=>{t&&this.removeUISourceCode(e.url())}))}remove(){this._fileSystemWorkspaceBinding._isolatedFileSystemManager.removeFileSystem(this._fileSystem)}_addFile(e){const t=this._fileSystem.contentType(e),s=this.createUISourceCode(this._fileSystemBaseURL+e,t);return this.addUISourceCode(s),s}_fileChanged(e){if(this._creatingFilesGuard.has(e))return;const t=this.uiSourceCodeForURL(e);if(t)re.delete(t),t.checkContentUpdated();else{const t=this._fileSystem.contentType(e);this.addUISourceCode(this.createUISourceCode(e,t))}}tooltipForURL(e){return this._fileSystem.tooltipForURL(e)}dispose(){this.removeProject()}}const re=new WeakMap;var de=Object.freeze({__proto__:null,FileSystemWorkspaceBinding:ne,FileSystem:oe,FilesChangedData:undefined});let ae;class le extends n.ObjectWrapper{constructor(e){super(),this._bindings=new WeakMap,this._originalResponseContentPromises=new WeakMap,this._savingForOverrides=new WeakSet,this._savingSymbol=Symbol("SavingForOverrides"),this._enabledSetting=t.Settings.instance().moduleSetting("persistenceNetworkOverridesEnabled"),this._enabledSetting.addChangeListener(this._enabledChanged,this),this._workspace=e,this._networkUISourceCodeForEncodedPath=new Map,this._interceptionHandlerBound=this._interceptionHandler.bind(this),this._updateInterceptionThrottler=new d.Throttler(50),this._project=null,this._activeProject=null,this._active=!1,this._enabled=!1,this._workspace.addEventListener(g.Events.ProjectAdded,(e=>{this._onProjectAdded(e.data)})),this._workspace.addEventListener(g.Events.ProjectRemoved,(e=>{this._onProjectRemoved(e.data)})),Fe.instance().addNetworkInterceptor(this._canHandleNetworkUISourceCode.bind(this)),this._eventDescriptors=[],this._enabledChanged()}static instance(e={forceNew:null,workspace:null}){const{forceNew:t,workspace:s}=e;if(!ae||t){if(!s)throw new Error("Missing workspace for NetworkPersistenceManager");ae=new le(s)}return ae}active(){return this._active}project(){return this._project}originalContentForUISourceCode(e){const t=this._bindings.get(e);if(!t)return null;const s=t.fileSystem;return this._originalResponseContentPromises.get(s)||null}async _enabledChanged(){this._enabled!==this._enabledSetting.get()&&(this._enabled=this._enabledSetting.get(),this._enabled?(this._eventDescriptors=[g.WorkspaceImpl.instance().addEventListener(g.Events.UISourceCodeRenamed,(e=>{this._uiSourceCodeRenamedListener(e)})),g.WorkspaceImpl.instance().addEventListener(g.Events.UISourceCodeAdded,(e=>{this._uiSourceCodeAdded(e)})),g.WorkspaceImpl.instance().addEventListener(g.Events.UISourceCodeRemoved,(e=>{this._uiSourceCodeRemovedListener(e)})),g.WorkspaceImpl.instance().addEventListener(g.Events.WorkingCopyCommitted,(e=>this._onUISourceCodeWorkingCopyCommitted(e.data.uiSourceCode)))],await this._updateActiveProject()):(r.EventTarget.removeEventListeners(this._eventDescriptors),await this._updateActiveProject()))}async _uiSourceCodeRenamedListener(e){const t=e.data.uiSourceCode;await this._onUISourceCodeRemoved(t),await this._onUISourceCodeAdded(t)}async _uiSourceCodeRemovedListener(e){await this._onUISourceCodeRemoved(e.data)}async _uiSourceCodeAdded(e){await this._onUISourceCodeAdded(e.data)}async _updateActiveProject(){const e=this._active;if(this._active=Boolean(this._enabledSetting.get()&&_.TargetManager.instance().mainTarget()&&this._project),this._active!==e){if(this._active&&this._project){await Promise.all(this._project.uiSourceCodes().map((e=>this._filesystemUISourceCodeAdded(e))));const e=this._workspace.projectsForType(g.projectTypes.Network);for(const t of e)await Promise.all(t.uiSourceCodes().map((e=>this._networkUISourceCodeAdded(e))))}else this._project&&(await Promise.all(this._project.uiSourceCodes().map((e=>this._filesystemUISourceCodeRemoved(e)))),this._networkUISourceCodeForEncodedPath.clear());Fe.instance().refreshAutomapping()}}_encodedPathFromUrl(e){if(!this._active||!this._project)return"";let t=s.ParsedURL.urlWithoutHash(e.replace(/^https?:\/\//,""));t.endsWith("/")&&-1===t.indexOf("?")&&(t+="index.html");let i=function(e){const t=[];for(const i of function(e){const t=(e=s.ParsedURL.urlWithoutHash(e)).indexOf("?");if(-1===t)return e.split("/");if(0===t)return[e];const i=e.substr(t),n=e.substr(0,e.length-i.length).split("/");return n[n.length-1]+=i,n}(e)){if(!i)continue;let e=encodeURI(i).replace(/[\/:\?\*]/g,(e=>"%"+e[0].charCodeAt(0).toString(16)));ce.has(e.toLowerCase())&&(e=e.split("").map((e=>"%"+e.charCodeAt(0).toString(16))).join(""));"."===e.charAt(e.length-1)&&(e=e.substr(0,e.length-1)+"%2e"),t.push(e)}return t}(t);const n=ne.fileSystemPath(this._project.id()),o=i.join("/");if(n.length+o.length>200){const e=i[0],n=i[i.length-1],r=n?n.substr(0,10)+"-":"",d=s.ParsedURL.extractExtension(t),a=d?"."+d.substr(0,10):"";i=[e,"longurls",r+p.hashCode(o).toString(16)+a]}return i.join("/")}_decodeLocalPathToUrlPath(e){try{return unescape(e)}catch(e){console.error(e)}return e}async _unbind(e){const t=this._bindings.get(e);t&&(this._bindings.delete(t.network),this._bindings.delete(t.fileSystem),await Fe.instance().removeBinding(t))}async _bind(e,t){this._bindings.has(e)&&await this._unbind(e),this._bindings.has(t)&&await this._unbind(t);const s=new Te(e,t);this._bindings.set(e,s),this._bindings.set(t,s),await Fe.instance().addBinding(s);const i=this._savingForOverrides.has(e)?e:t,[{content:n},o]=await Promise.all([i.requestContent(),i.contentEncoded()]);Fe.instance().syncContent(i,n||"",o)}_onUISourceCodeWorkingCopyCommitted(e){this.saveUISourceCodeForOverrides(e)}canSaveUISourceCodeForOverrides(e){return this._active&&e.project().type()===g.projectTypes.Network&&!this._bindings.has(e)&&!this._savingForOverrides.has(e)}async saveUISourceCodeForOverrides(e){if(!this.canSaveUISourceCodeForOverrides(e))return;this._savingForOverrides.add(e);let t=this._encodedPathFromUrl(e.url());const s=(await e.requestContent()).content||"",i=await e.contentEncoded(),n=t.lastIndexOf("/"),o=t.substr(n+1);t=t.substr(0,n),this._project&&await this._project.createFile(t,o,s,i),this._fileCreatedForTest(t,o),this._savingForOverrides.delete(e)}_fileCreatedForTest(e,t){}_patternForFileSystemUISourceCode(e){const t=ne.relativePath(e);return t.length<2?"":"longurls"===t[1]&&2!==t.length?"http?://"+t[0]+"/*":"http?://"+this._decodeLocalPathToUrlPath(t.join("/"))}async _onUISourceCodeAdded(e){await this._networkUISourceCodeAdded(e),await this._filesystemUISourceCodeAdded(e)}_canHandleNetworkUISourceCode(e){return this._active&&!e.url().startsWith("snippet://")}async _networkUISourceCodeAdded(e){if(e.project().type()!==g.projectTypes.Network||!this._canHandleNetworkUISourceCode(e))return;const t=s.ParsedURL.urlWithoutHash(e.url());this._networkUISourceCodeForEncodedPath.set(this._encodedPathFromUrl(t),e);const i=this._project,n=i.uiSourceCodeForURL(i.fileSystemPath()+"/"+this._encodedPathFromUrl(t));n&&await this._bind(e,n)}async _filesystemUISourceCodeAdded(e){if(!this._active||e.project()!==this._project)return;this._updateInterceptionPatterns();const t=ne.relativePath(e),s=this._networkUISourceCodeForEncodedPath.get(t.join("/"));s&&await this._bind(s,e)}_updateInterceptionPatterns(){this._updateInterceptionThrottler.schedule(function(){if(!this._active||!this._project)return f.MultitargetNetworkManager.instance().setInterceptionHandlerForPatterns([],this._interceptionHandlerBound);const e=new Set,t="index.html";for(const s of this._project.uiSourceCodes()){const i=this._patternForFileSystemUISourceCode(s);e.add(i),i.endsWith("/index.html")&&e.add(i.substr(0,i.length-t.length))}return f.MultitargetNetworkManager.instance().setInterceptionHandlerForPatterns(Array.from(e).map((e=>({urlPattern:e,interceptionStage:Protocol.Network.InterceptionStage.HeadersReceived}))),this._interceptionHandlerBound)}.bind(this))}async _onUISourceCodeRemoved(e){await this._networkUISourceCodeRemoved(e),await this._filesystemUISourceCodeRemoved(e)}async _networkUISourceCodeRemoved(e){e.project().type()===g.projectTypes.Network&&(await this._unbind(e),this._networkUISourceCodeForEncodedPath.delete(this._encodedPathFromUrl(e.url())))}async _filesystemUISourceCodeRemoved(e){e.project()===this._project&&(this._updateInterceptionPatterns(),this._originalResponseContentPromises.delete(e),await this._unbind(e))}async _setProject(e){e!==this._project&&(this._project&&await Promise.all(this._project.uiSourceCodes().map((e=>this._filesystemUISourceCodeRemoved(e)))),this._project=e,this._project&&await Promise.all(this._project.uiSourceCodes().map((e=>this._filesystemUISourceCodeAdded(e)))),await this._updateActiveProject(),this.dispatchEventToListeners(he.ProjectChanged,this._project))}async _onProjectAdded(e){if(e.type()!==g.projectTypes.FileSystem||"overrides"!==ne.fileSystemType(e))return;ne.fileSystemPath(e.id())&&(this._project&&this._project.remove(),await this._setProject(e))}async _onProjectRemoved(e){e===this._project&&await this._setProject(null)}async _interceptionHandler(e){const t=e.request.method;if(!this._active||"GET"!==t&&"POST"!==t)return;const s=this._project,n=s.fileSystemPath()+"/"+this._encodedPathFromUrl(e.request.url),o=s.uiSourceCodeForURL(n);if(!o)return;let r="";if(e.responseHeaders){r=f.NetworkManager.lowercaseHeaders(e.responseHeaders)["content-type"]}if(!r){const t=i.resourceTypes[e.resourceType]||i.resourceTypes.Other;r=o.mimeType(),i.ResourceType.fromMimeType(r)!==t&&(r=t.canonicalMimeType())}const d=o.project();this._originalResponseContentPromises.set(o,e.responseBody().then((e=>e.error||null===e.content?null:e.encoded?atob(e.content):e.content)));const a=await d.requestFileBlob(o);a&&e.continueRequestWithContent(new Blob([a],{type:r}))}}const ce=new Set(["con","prn","aux","nul","com1","com2","com3","com4","com5","com6","com7","com8","com9","lpt1","lpt2","lpt3","lpt4","lpt5","lpt6","lpt7","lpt8","lpt9"]),he={ProjectChanged:Symbol("ProjectChanged")};var ue=Object.freeze({__proto__:null,NetworkPersistenceManager:le,Events:he});const me={linkedToSourceMapS:"Linked to source map: {PH1}",linkedToS:"Linked to {PH1}"},pe=h.registerUIStrings("persistence/PersistenceUtils.js",me),_e=h.getLocalizedString.bind(void 0,pe);class fe{static tooltipForUISourceCode(e){const t=Fe.instance().binding(e);return t?e===t.network?ne.tooltipForUISourceCode(t.fileSystem):t.network.contentType().isFromSourceMap()?_e(me.linkedToSourceMapS,{PH1:t.network.url().trimMiddle(150)}):_e(me.linkedToS,{PH1:t.network.url().trimMiddle(150)}):""}static iconForUISourceCode(e){const t=Fe.instance().binding(e);if(t){if(!t.fileSystem.url().startsWith("file://"))return null;const e=E.Icon.create("mediumicon-file-sync");return x.Tooltip.install(e,fe.tooltipForUISourceCode(t.network)),le.instance().project()===t.fileSystem.project()&&(e.style.filter="hue-rotate(160deg)"),e}if(e.project().type()!==g.projectTypes.FileSystem||!e.url().startsWith("file://"))return null;const s=E.Icon.create("mediumicon-file");return x.Tooltip.install(s,fe.tooltipForUISourceCode(e)),s}}class Se extends n.ObjectWrapper{constructor(e){super(),e.addEventListener(Ee.BindingCreated,this._bindingChanged,this),e.addEventListener(Ee.BindingRemoved,this._bindingChanged,this)}_bindingChanged(e){const t=e.data;this.dispatchEventToListeners(b.LinkDecorator.Events.LinkIconChanged,t.network)}linkIcon(e){return fe.iconForUISourceCode(e)}}var ge=Object.freeze({__proto__:null,UIStrings:me,PersistenceUtils:fe,LinkDecorator:Se});let ye;class Fe extends n.ObjectWrapper{constructor(e,t){super(),this._workspace=e,this._breakpointManager=t,this._filePathPrefixesToBindingCount=new Map,this._subscribedBindingEventListeners=new u;const s=new Se(this);b.Linkifier.setLinkDecorator(s),this._mapping=new Me(this._workspace,this._onStatusAdded.bind(this),this._onStatusRemoved.bind(this))}static instance(e={forceNew:null,workspace:null,breakpointManager:null}){const{forceNew:t,workspace:s,breakpointManager:i}=e;if(!ye||t){if(!s||!i)throw new Error("Missing arguments for workspace");ye=new Fe(s,i)}return ye}addNetworkInterceptor(e){this._mapping.addNetworkInterceptor(e)}refreshAutomapping(){this._mapping.scheduleRemap()}async addBinding(e){await this._innerAddBinding(e)}async addBindingForTest(e){await this._innerAddBinding(e)}async removeBinding(e){await this._innerRemoveBinding(e)}async removeBindingForTest(e){await this._innerRemoveBinding(e)}async _innerAddBinding(e){ve.set(e.network,e),ve.set(e.fileSystem,e),e.fileSystem.forceLoadOnCheckContent(),e.network.addEventListener(y.Events.WorkingCopyCommitted,this._onWorkingCopyCommitted,this),e.fileSystem.addEventListener(y.Events.WorkingCopyCommitted,this._onWorkingCopyCommitted,this),e.network.addEventListener(y.Events.WorkingCopyChanged,this._onWorkingCopyChanged,this),e.fileSystem.addEventListener(y.Events.WorkingCopyChanged,this._onWorkingCopyChanged,this),this._addFilePathBindingPrefixes(e.fileSystem.url()),await this._moveBreakpoints(e.fileSystem,e.network),console.assert(!e.fileSystem.isDirty()||!e.network.isDirty()),e.fileSystem.isDirty()?this._syncWorkingCopy(e.fileSystem):e.network.isDirty()?this._syncWorkingCopy(e.network):e.network.hasCommits()&&e.network.content()!==e.fileSystem.content()&&(e.network.setWorkingCopy(e.network.content()),this._syncWorkingCopy(e.network)),this._notifyBindingEvent(e.network),this._notifyBindingEvent(e.fileSystem),this.dispatchEventToListeners(Ee.BindingCreated,e)}async _innerRemoveBinding(e){ve.get(e.network)===e&&(console.assert(ve.get(e.network)===ve.get(e.fileSystem),"ERROR: inconsistent binding for networkURL "+e.network.url()),ve.delete(e.network),ve.delete(e.fileSystem),e.network.removeEventListener(y.Events.WorkingCopyCommitted,this._onWorkingCopyCommitted,this),e.fileSystem.removeEventListener(y.Events.WorkingCopyCommitted,this._onWorkingCopyCommitted,this),e.network.removeEventListener(y.Events.WorkingCopyChanged,this._onWorkingCopyChanged,this),e.fileSystem.removeEventListener(y.Events.WorkingCopyChanged,this._onWorkingCopyChanged,this),this._removeFilePathBindingPrefixes(e.fileSystem.url()),await this._breakpointManager.copyBreakpoints(e.network.url(),e.fileSystem),this._notifyBindingEvent(e.network),this._notifyBindingEvent(e.fileSystem),this.dispatchEventToListeners(Ee.BindingRemoved,e))}async _onStatusAdded(e){const t=new Te(e.network,e.fileSystem);Ce.set(e,t),await this._innerAddBinding(t)}async _onStatusRemoved(e){const t=Ce.get(e);await this._innerRemoveBinding(t)}_onWorkingCopyChanged(e){const t=e.data;this._syncWorkingCopy(t)}_syncWorkingCopy(t){const s=ve.get(t);if(!s||Pe.has(s))return;const i=s.network===t?s.fileSystem:s.network;if(!t.isDirty())return Pe.add(s),i.resetWorkingCopy(),Pe.delete(s),void this._contentSyncedForTest();const n=e.NetworkProject.targetForUISourceCode(s.network);if(n&&n.type()===_.Type.Node){const e=t.workingCopy();i.requestContent().then((()=>{const t=Fe.rewrapNodeJSContent(i,i.workingCopy(),e);o.call(this,(()=>t))}))}else o.call(this,(()=>t.workingCopy()));function o(e){s&&Pe.add(s),i.setWorkingCopyGetter(e),s&&Pe.delete(s),this._contentSyncedForTest()}}_onWorkingCopyCommitted(e){const t=e.data.uiSourceCode,s=e.data.content;this.syncContent(t,s,e.data.encoded)}syncContent(t,s,i){const n=ve.get(t);if(!n||we.has(n))return;const o=n.network===t?n.fileSystem:n.network,r=e.NetworkProject.targetForUISourceCode(n.network);function d(e){n&&we.add(n),o.setContent(e,i),n&&we.delete(n),this._contentSyncedForTest()}r&&r.type()===_.Type.Node?o.requestContent().then((e=>{const t=Fe.rewrapNodeJSContent(o,e.content||"",s);d.call(this,t)})):d.call(this,s)}static rewrapNodeJSContent(e,t,s){return e.project().type()===g.projectTypes.FileSystem?(s.startsWith(ke)&&s.endsWith(Ie)&&(s=s.substring(ke.length,s.length-Ie.length)),t.startsWith(be)&&(s=be+s)):(s.startsWith(be)&&(s=s.substring(be.length)),t.startsWith(ke)&&t.endsWith(Ie)&&(s=ke+s+Ie)),s}_contentSyncedForTest(){}async _moveBreakpoints(e,t){const s=this._breakpointManager.breakpointLocationsForUISourceCode(e).map((e=>e.breakpoint));await Promise.all(s.map((e=>(e.remove(!1),this._breakpointManager.setBreakpoint(t,e.lineNumber(),e.columnNumber(),e.condition(),e.enabled())))))}hasUnsavedCommittedChanges(e){return!this._workspace.hasResourceContentTrackingExtensions()&&(!e.project().canSetFileContent()&&(!ve.has(e)&&Boolean(e.hasCommits())))}binding(e){return ve.get(e)||null}subscribeForBindingEvent(e,t){this._subscribedBindingEventListeners.set(e,t)}unsubscribeFromBindingEvent(e,t){this._subscribedBindingEventListeners.delete(e,t)}_notifyBindingEvent(e){if(!this._subscribedBindingEventListeners.has(e))return;const t=Array.from(this._subscribedBindingEventListeners.get(e));for(const e of t)e.call(null)}fileSystem(e){const t=this.binding(e);return t?t.fileSystem:null}network(e){const t=this.binding(e);return t?t.network:null}_addFilePathBindingPrefixes(e){let t="";for(const s of e.split("/")){t+=s+"/";const e=this._filePathPrefixesToBindingCount.get(t)||0;this._filePathPrefixesToBindingCount.set(t,e+1)}}_removeFilePathBindingPrefixes(e){let t="";for(const s of e.split("/")){t+=s+"/";const e=this._filePathPrefixesToBindingCount.get(t);1===e?this._filePathPrefixesToBindingCount.delete(t):void 0!==e&&this._filePathPrefixesToBindingCount.set(t,e-1)}}filePathHasBindings(e){return e.endsWith("/")||(e+="/"),this._filePathPrefixesToBindingCount.has(e)}}const ve=new WeakMap,Ce=new WeakMap,we=new WeakSet,Pe=new WeakSet,ke="(function (exports, require, module, __filename, __dirname) { ",Ie="\n});",be="#!/usr/bin/env node",Ee={BindingCreated:Symbol("BindingCreated"),BindingRemoved:Symbol("BindingRemoved")};class xe{constructor(){this._encoder=new a.CharacterIdMap}encode(e){return e.split("/").map((e=>this._encoder.toChar(e))).join("")}decode(e){return e.split("").map((e=>this._encoder.fromChar(e))).join("/")}}class Te{constructor(e,t){this.network=e,this.fileSystem=t}}var Ue=Object.freeze({__proto__:null,PersistenceImpl:Fe,NodePrefix:ke,NodeSuffix:Ie,NodeShebang:be,Events:Ee,PathEncoder:xe,PersistenceBinding:Te});const Re={theAttemptToBindSInTheWorkspace:'The attempt to bind "{PH1}" in the workspace failed as this URI is malformed.'},Le=h.registerUIStrings("persistence/Automapping.js",Re),je=h.getLocalizedString.bind(void 0,Le);class Me{constructor(e,t,s){this._workspace=e,this._onStatusAdded=t,this._onStatusRemoved=s,this._statuses=new Set,this._fileSystemUISourceCodes=new Map,this._sweepThrottler=new d.Throttler(100),this._sourceCodeToProcessingPromiseMap=new WeakMap,this._sourceCodeToAutoMappingStatusMap=new WeakMap,this._sourceCodeToMetadataMap=new WeakMap;const i=new xe;this._filesIndex=new We(i),this._projectFoldersIndex=new Ae(i),this._activeFoldersIndex=new Ae(i),this._interceptors=[],this._workspace.addEventListener(g.Events.UISourceCodeAdded,(e=>this._onUISourceCodeAdded(e.data))),this._workspace.addEventListener(g.Events.UISourceCodeRemoved,(e=>this._onUISourceCodeRemoved(e.data))),this._workspace.addEventListener(g.Events.UISourceCodeRenamed,this._onUISourceCodeRenamed,this),this._workspace.addEventListener(g.Events.ProjectAdded,(e=>this._onProjectAdded(e.data)),this),this._workspace.addEventListener(g.Events.ProjectRemoved,(e=>this._onProjectRemoved(e.data)),this);for(const t of e.projects())this._onProjectAdded(t);for(const t of e.uiSourceCodes())this._onUISourceCodeAdded(t)}addNetworkInterceptor(e){this._interceptors.push(e),this.scheduleRemap()}scheduleRemap(){for(const e of this._statuses.values())this._clearNetworkStatus(e.network);this._scheduleSweep()}_scheduleSweep(){this._sweepThrottler.schedule(function(){const e=this._workspace.projectsForType(g.projectTypes.Network);for(const t of e)for(const e of t.uiSourceCodes())this._computeNetworkStatus(e);return this._onSweepHappenedForTest(),Promise.resolve()}.bind(this))}_onSweepHappenedForTest(){}_onProjectRemoved(e){for(const t of e.uiSourceCodes())this._onUISourceCodeRemoved(t);if(e.type()!==g.projectTypes.FileSystem)return;const t=e;for(const e of t.initialGitFolders())this._projectFoldersIndex.removeFolder(e);this._projectFoldersIndex.removeFolder(t.fileSystemPath()),this.scheduleRemap()}_onProjectAdded(e){if(e.type()!==g.projectTypes.FileSystem)return;const t=e;for(const e of t.initialGitFolders())this._projectFoldersIndex.addFolder(e);this._projectFoldersIndex.addFolder(t.fileSystemPath()),e.uiSourceCodes().forEach(this._onUISourceCodeAdded.bind(this)),this.scheduleRemap()}_onUISourceCodeAdded(e){const t=e.project();if(t.type()===g.projectTypes.FileSystem){if(!ne.fileSystemSupportsAutomapping(t))return;this._filesIndex.addPath(e.url()),this._fileSystemUISourceCodes.set(e.url(),e),this._scheduleSweep()}else t.type()===g.projectTypes.Network&&this._computeNetworkStatus(e)}_onUISourceCodeRemoved(e){if(e.project().type()===g.projectTypes.FileSystem){this._filesIndex.removePath(e.url()),this._fileSystemUISourceCodes.delete(e.url());const t=this._sourceCodeToAutoMappingStatusMap.get(e);t&&this._clearNetworkStatus(t.network)}else e.project().type()===g.projectTypes.Network&&this._clearNetworkStatus(e)}_onUISourceCodeRenamed(e){const t=e.data.uiSourceCode,s=e.data.oldURL;if(t.project().type()!==g.projectTypes.FileSystem)return;this._filesIndex.removePath(s),this._fileSystemUISourceCodes.delete(s);const i=this._sourceCodeToAutoMappingStatusMap.get(t);i&&this._clearNetworkStatus(i.network),this._filesIndex.addPath(t.url()),this._fileSystemUISourceCodes.set(t.url(),t),this._scheduleSweep()}_computeNetworkStatus(t){if(this._sourceCodeToProcessingPromiseMap.has(t)||this._sourceCodeToAutoMappingStatusMap.has(t))return;if(this._interceptors.some((e=>e(t))))return;if(t.url().startsWith("wasm://"))return;const s=this._createBinding(t).then(async function(i){if(!i)return null;if(this._sourceCodeToProcessingPromiseMap.get(t)!==s)return null;if(i.network.contentType().isFromSourceMap()||!i.fileSystem.contentType().isTextType())return i;if(i.fileSystem.isDirty()&&(i.network.isDirty()||i.network.hasCommits()))return null;const[n,o]=await Promise.all([i.fileSystem.requestContent(),i.network.project().requestFileContent(i.network)]);if(null===n.content||null===o)return null;if(this._sourceCodeToProcessingPromiseMap.get(t)!==s)return null;const r=e.NetworkProject.targetForUISourceCode(i.network);let d=!1;const a=n.content;if(r&&r.type()===_.Type.Node){if(o.content){const e=Fe.rewrapNodeJSContent(i.fileSystem,a,o.content);d=a===e}}else o.content&&(d=a.trimRight()===o.content.trimRight());if(!d)return this._prevalidationFailedForTest(i),null;return i}.bind(this)).then(function(e){if(this._sourceCodeToProcessingPromiseMap.get(t)!==s)return;if(this._sourceCodeToProcessingPromiseMap.delete(t),!e)return void this._onBindingFailedForTest();if(this._sourceCodeToAutoMappingStatusMap.has(e.network)||this._sourceCodeToAutoMappingStatusMap.has(e.fileSystem))return;if(this._statuses.add(e),this._sourceCodeToAutoMappingStatusMap.set(e.network,e),this._sourceCodeToAutoMappingStatusMap.set(e.fileSystem,e),e.exactMatch){const t=this._projectFoldersIndex.closestParentFolder(e.fileSystem.url());!!t&&this._activeFoldersIndex.addFolder(t)&&this._scheduleSweep()}this._onStatusAdded.call(null,e)}.bind(this));this._sourceCodeToProcessingPromiseMap.set(t,s)}_prevalidationFailedForTest(e){}_onBindingFailedForTest(){}_clearNetworkStatus(e){if(this._sourceCodeToProcessingPromiseMap.has(e))return void this._sourceCodeToProcessingPromiseMap.delete(e);const t=this._sourceCodeToAutoMappingStatusMap.get(e);if(t){if(this._statuses.delete(t),this._sourceCodeToAutoMappingStatusMap.delete(t.network),this._sourceCodeToAutoMappingStatusMap.delete(t.fileSystem),t.exactMatch){const e=this._projectFoldersIndex.closestParentFolder(t.fileSystem.url());e&&this._activeFoldersIndex.removeFolder(e)}this._onStatusRemoved.call(null,t)}}_createBinding(e){const t=e.url();if(t.startsWith("file://")||t.startsWith("snippet://")){const s=d(t);if(!s)return Promise.resolve(null);const i=this._fileSystemUISourceCodes.get(s),n=i?new Be(e,i,!1):null;return Promise.resolve(n)}let i=s.ParsedURL.extractPath(t);if(null===i)return Promise.resolve(null);i.endsWith("/")&&(i+="index.html");const n=d(i);if(!n)return Promise.resolve(null);const r=this._filesIndex.similarFiles(n).map((e=>this._fileSystemUISourceCodes.get(e)));return r.length?this._pullMetadatas(r.concat(e)).then(function(){const t=r.filter((e=>Boolean(e)&&Boolean(this._activeFoldersIndex.closestParentFolder(e.url())))),s=this._sourceCodeToMetadataMap.get(e);if(!s||!s.modificationTime&&"number"!=typeof s.contentSize)return 1!==t.length?null:new Be(e,t[0],!1);let i=this._filterWithMetadata(t,s);i.length||(i=this._filterWithMetadata(r,s));if(1!==i.length)return null;return new Be(e,i[0],!0)}.bind(this)):Promise.resolve(null);function d(e){try{return decodeURI(e)}catch(t){return o.Console.instance().error(je(Re.theAttemptToBindSInTheWorkspace,{PH1:e})),null}}}_pullMetadatas(e){return Promise.all(e.map((async e=>{this._sourceCodeToMetadataMap.set(e,await e.requestMetadata())})))}_filterWithMetadata(e,t){return e.filter((e=>{const s=this._sourceCodeToMetadataMap.get(e);if(!s)return!1;const i=!t.modificationTime||!s.modificationTime||Math.abs(t.modificationTime.getTime()-s.modificationTime.getTime())<1e3,n=!t.contentSize||s.contentSize===t.contentSize;return i&&n}))}}class We{constructor(e){this._encoder=e,this._reversedIndex=new l.Trie}addPath(e){const t=this._encoder.encode(e);this._reversedIndex.add(p.reverse(t))}removePath(e){const t=this._encoder.encode(e);this._reversedIndex.remove(p.reverse(t))}similarFiles(e){const t=this._encoder.encode(e),s=p.reverse(t),i=this._reversedIndex.longestPrefix(s,!1);return i?this._reversedIndex.words(i).map((e=>this._encoder.decode(p.reverse(e)))):[]}}class Ae{constructor(e){this._encoder=e,this._index=new l.Trie,this._folderCount=new Map}addFolder(e){e.endsWith("/")&&(e=e.substring(0,e.length-1));const t=this._encoder.encode(e);this._index.add(t);const s=this._folderCount.get(t)||0;return this._folderCount.set(t,s+1),0===s}removeFolder(e){e.endsWith("/")&&(e=e.substring(0,e.length-1));const t=this._encoder.encode(e),s=this._folderCount.get(t)||0;return!!s&&(s>1?(this._folderCount.set(t,s-1),!1):(this._index.remove(t),this._folderCount.delete(t),!0))}closestParentFolder(e){const t=this._encoder.encode(e),s=this._index.longestPrefix(t,!0);return this._encoder.decode(s)}}class Be{constructor(e,t,s){this.network=e,this.fileSystem=t,this.exactMatch=s}}var Ne=Object.freeze({__proto__:null,UIStrings:Re,Automapping:Me,AutomappingStatus:Be});const He={excludedFolders:"Excluded folders",add:"Add",none:"None",sViaDevtools:"{PH1} (via .devtools)",folderPath:"Folder path",enterAPath:"Enter a path",enterAUniquePath:"Enter a unique path"},qe=h.registerUIStrings("persistence/EditFileSystemView.js",He),Oe=h.getLocalizedString.bind(void 0,qe);class ze extends T.VBox{constructor(e){super(!0),this.registerRequiredCSS("persistence/editFileSystemView.css",{enableLegacyPatching:!1}),this._fileSystemPath=e,this._excludedFolders=[],this._eventListeners=[ee.instance().addEventListener(te.ExcludedFolderAdded,this._update,this),ee.instance().addEventListener(te.ExcludedFolderRemoved,this._update,this)];const t=this.contentElement.createChild("div","file-system-header");t.createChild("div","file-system-header-text").textContent=Oe(He.excludedFolders),t.appendChild(U.createTextButton(Oe(He.add),this._addExcludedFolderButtonClicked.bind(this),"add-button")),this._excludedFoldersList=new R.ListWidget(this),this._excludedFoldersList.element.classList.add("file-system-list"),this._excludedFoldersList.registerRequiredCSS("persistence/editFileSystemView.css",{enableLegacyPatching:!1});const s=document.createElement("div");s.classList.add("file-system-list-empty"),s.textContent=Oe(He.none),this._excludedFoldersList.setEmptyPlaceholder(s),this._excludedFoldersList.show(this.contentElement),this._update()}dispose(){r.EventTarget.removeEventListeners(this._eventListeners)}_getFileSystem(){return ee.instance().fileSystem(this._fileSystemPath)}_update(){if(!this._muteUpdate){this._excludedFoldersList.clear(),this._excludedFolders=[];for(const e of this._getFileSystem().excludedFolders().values())this._excludedFolders.push(e),this._excludedFoldersList.appendItem(e,!0)}}_addExcludedFolderButtonClicked(){this._excludedFoldersList.addNewItem(0,"")}renderItem(e,t){const s=document.createElement("div");s.classList.add("file-system-list-item");const i=t?e:Oe(He.sViaDevtools,{PH1:e}),n=s.createChild("div","file-system-value");return n.textContent=i,x.Tooltip.install(n,i),s}removeItemRequested(e,t){this._getFileSystem().removeExcludedFolder(this._excludedFolders[t])}commitEdit(e,t,s){this._muteUpdate=!0,s||this._getFileSystem().removeExcludedFolder(e),this._getFileSystem().addExcludedFolder(this._normalizePrefix(t.control("pathPrefix").value)),this._muteUpdate=!1,this._update()}beginEdit(e){const t=this._createExcludedFolderEditor();return t.control("pathPrefix").value=e,t}_createExcludedFolderEditor(){if(this._excludedFolderEditor)return this._excludedFolderEditor;const e=new R.Editor;this._excludedFolderEditor=e;const t=e.contentElement();t.createChild("div","file-system-edit-row").createChild("div","file-system-value").textContent=Oe(He.folderPath);return t.createChild("div","file-system-edit-row").createChild("div","file-system-value").appendChild(e.createInput("pathPrefix","text","/path/to/folder/",function(e,t,s){const i=this._normalizePrefix(s.value.trim());if(!i)return{valid:!1,errorMessage:Oe(He.enterAPath)};const n=this._getFileSystem().excludedFolders().size;for(let e=0;e<n;++e)if(e!==t&&this._excludedFolders[e]===i)return{valid:!1,errorMessage:Oe(He.enterAUniquePath)};return{valid:!0,errorMessage:void 0}}.bind(this))),e}_normalizePrefix(e){return e?e+("/"===e[e.length-1]?"":"/"):""}}var De=Object.freeze({__proto__:null,UIStrings:He,EditFileSystemView:ze});const Ge={saveAs:"Save as...",saveImage:"Save image",saveForOverrides:"Save for overrides",openInContainingFolder:"Open in containing folder"},Ve=h.registerUIStrings("persistence/PersistenceActions.js",Ge),$e=h.getLocalizedString.bind(void 0,Ve);var Je=Object.freeze({__proto__:null,UIStrings:Ge,ContextMenuProvider:class{appendApplicableItems(e,t,i){const n=i;n.contentType().isDocumentOrScriptOrStyleSheet()?t.saveSection().appendItem($e(Ge.saveAs),(async function(){n instanceof y.UISourceCode&&n.commitWorkingCopy();let e=(await n.requestContent()).content||"";await n.contentEncoded()&&(e=window.atob(e));const t=n.contentURL();F.FileManager.instance().save(t,e,!0),F.FileManager.instance().close(t)})):n instanceof S.Resource&&n.contentType().isImage()&&t.saveSection().appendItem($e(Ge.saveImage),(async function(){const e=n,t=(await e.requestContent()).content||"",s=document.createElement("a");s.download=e.displayName,s.href="data:"+e.mimeType+";base64,"+t,s.click()}));const o=g.WorkspaceImpl.instance().uiSourceCodeForURL(n.contentURL());o&&le.instance().canSaveUISourceCodeForOverrides(o)&&t.saveSection().appendItem($e(Ge.saveForOverrides),(()=>{o.commitWorkingCopy(),le.instance().saveUISourceCodeForOverrides(o),c.reveal(o)}));const r=o&&Fe.instance().binding(o),d=r?r.fileSystem.contentURL():n.contentURL();if(d.startsWith("file://")){const e=s.ParsedURL.urlToPlatformPath(d,w.isWin());t.revealSection().appendItem($e(Ge.openInContainingFolder),(()=>C.InspectorFrontendHostInstance.showItemInFolder(e)))}}}});const Ye={workspace:"Workspace",mappingsAreInferredAutomatically:"Mappings are inferred automatically.",addFolder:"Add folder…",folderExcludePattern:"Folder exclude pattern",remove:"Remove"},Ke=h.registerUIStrings("persistence/WorkspaceSettingsTab.js",Ye),Qe=h.getLocalizedString.bind(void 0,Ke);class Xe extends T.VBox{constructor(){super(),this.registerRequiredCSS("persistence/workspaceSettingsTab.css",{enableLegacyPatching:!0});const e=this.element.createChild("header");U.createTextChild(e.createChild("h1"),Qe(Ye.workspace)),this.containerElement=this.element.createChild("div","settings-container-wrapper").createChild("div","settings-tab settings-content settings-container"),ee.instance().addEventListener(te.FileSystemAdded,(e=>this._fileSystemAdded(e.data)),this),ee.instance().addEventListener(te.FileSystemRemoved,(e=>this._fileSystemRemoved(e.data)),this);const t=this._createFolderExcludePatternInput();t.classList.add("folder-exclude-pattern"),this.containerElement.appendChild(t);const s=this.containerElement.createChild("div","settings-info-message");U.createTextChild(s,Qe(Ye.mappingsAreInferredAutomatically)),this._fileSystemsListContainer=this.containerElement.createChild("div","");const i=U.createTextButton(Qe(Ye.addFolder),this._addFileSystemClicked.bind(this));this.containerElement.appendChild(i),this.setDefaultFocusedElement(i),this._elementByPath=new Map,this._mappingViewByPath=new Map;const n=ee.instance().fileSystems();for(let e=0;e<n.length;++e)this._addItem(n[e])}_createFolderExcludePatternInput(){const e=document.createElement("p"),t=e.createChild("label");t.textContent=Qe(Ye.folderExcludePattern);const s=U.createInput("","text");L.bindLabelToControl(t,s),e.appendChild(s),s.style.width="270px";const i=ee.instance().workspaceFolderExcludePatternSetting(),n=U.bindInput(s,i.set.bind(i),(function(e){let t;try{t=new RegExp(e)}catch(e){}return{valid:Boolean(t),errorMessage:void 0}}),!1);return i.addChangeListener((()=>n.call(null,i.get()))),n(i.get()),e}_addItem(e){if(!(e instanceof z))return;const t=le.instance().project();if(t&&ee.instance().fileSystem(t.fileSystemPath())===e)return;const s=this._renderFileSystem(e);this._elementByPath.set(e.path(),s),this._fileSystemsListContainer.appendChild(s);const i=new ze(e.path());this._mappingViewByPath.set(e.path(),i),i.element.classList.add("file-system-mapping-view"),i.show(s)}_renderFileSystem(e){const t=e.path(),s=t.lastIndexOf("/"),i=t.substr(s+1),n=document.createElement("div");n.classList.add("file-system-container");const o=n.createChild("div","file-system-header"),r=o.createChild("div","file-system-name");r.textContent=i,L.markAsHeading(r,2);const d=o.createChild("div","file-system-path");d.textContent=t,x.Tooltip.install(d,t);const a=new j.Toolbar(""),l=new j.ToolbarButton(Qe(Ye.remove),"largeicon-delete");return l.addEventListener(j.ToolbarButton.Events.Click,this._removeFileSystemClicked.bind(this,e)),a.appendToolbarItem(l),o.appendChild(a.element),n}_removeFileSystemClicked(e){ee.instance().removeFileSystem(e)}_addFileSystemClicked(){ee.instance().addFileSystem()}_fileSystemAdded(e){this._addItem(e)}_fileSystemRemoved(e){const t=this._mappingViewByPath.get(e.path());t&&(t.dispose(),this._mappingViewByPath.delete(e.path()));const s=this._elementByPath.get(e.path());s&&(this._elementByPath.delete(e.path()),s.remove())}}var Ze=Object.freeze({__proto__:null,UIStrings:Ye,WorkspaceSettingsTab:Xe});export{Ne as Automapping,De as EditFileSystemView,de as FileSystemWorkspaceBinding,Y as IsolatedFileSystem,ie as IsolatedFileSystemManager,ue as NetworkPersistenceManager,Ue as Persistence,Je as PersistenceActions,ge as PersistenceUtils,N as PlatformFileSystem,Ze as WorkspaceSettingsTab};
