// @ts-nocheck - Prevent tsc stepping into any required bundles.
/*!
 * Lighthouse v7.0.0 96eda60804e5d0b10c9e367b964278f5b7d4d91d (December 17th 2020)
 * 
 * Automated auditing, performance metrics, and best practices for the web.
 * 
 * @homepage https://github.com/GoogleChrome/lighthouse#readme
 * @author   The Lighthouse Authors
 * @license  Apache-2.0
 */
globalThis.require=function r(e,t,n){function o(a,s){if(!t[a]){if(!e[a]){var l="function"==typeof require&&require;if(!s&&l)return l(a,!0);if(i)return i(a,!0);var c=new Error("Cannot find module '"+a+"'");throw c.code="MODULE_NOT_FOUND",c}var u=t[a]={exports:{}};e[a][0].call(u.exports,(function(t){return o(e[a][1][t]||t)}),u,u.exports,r,e,t,n)}return t[a].exports}for(var i="function"==typeof require&&require,a=0;a<n.length;a++)o(n[a]);return o}({"../audits/accessibility/accesskeys":[function(e,t,n){(function(n){"use strict";const i=e("./axe-audit.js"),a=e("../../lib/i18n/i18n.js"),s={title:"`[accesskey]` values are unique",failureTitle:"`[accesskey]` values are not unique",description:"Access keys let users quickly focus a part of the page. For proper navigation, each access key must be unique. [Learn more](https://web.dev/accesskeys/)."},l=a.createMessageInstanceIdFn(n,s);t.exports=class Accesskeys extends i{static get meta(){return{id:"accesskeys",title:l(s.title),
failureTitle:l(s.failureTitle),description:l(s.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/accessibility/accesskeys.js")},{"../../lib/i18n/i18n.js":84,"./axe-audit.js":2}],"../audits/accessibility/aria-allowed-attr":[function(e,t,n){(function(n){"use strict";const i=e("./axe-audit.js"),a=e("../../lib/i18n/i18n.js"),s={title:"`[aria-*]` attributes match their roles",failureTitle:"`[aria-*]` attributes do not match their roles",description:"Each ARIA `role` supports a specific subset of `aria-*` attributes. Mismatching these invalidates the `aria-*` attributes. [Learn more](https://web.dev/aria-allowed-attr/)."},l=a.createMessageInstanceIdFn(n,s);t.exports=class ARIAAllowedAttr extends i{static get meta(){return{id:"aria-allowed-attr",title:l(s.title),failureTitle:l(s.failureTitle),description:l(s.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=s
}).call(this,"/lighthouse-core/audits/accessibility/aria-allowed-attr.js")},{"../../lib/i18n/i18n.js":84,"./axe-audit.js":2}],"../audits/accessibility/aria-command-name":[function(e,t,n){(function(n){"use strict";const i=e("./axe-audit.js"),a=e("../../lib/i18n/i18n.js"),s={title:"`button`, `link`, and `menuitem` elements have accessible names",failureTitle:"`button`, `link`, and `menuitem` elements do not have accessible names.",description:"When an element doesn't have an accessible name, screen readers announce it with a generic name, making it unusable for users who rely on screen readers. [Learn more](https://web.dev/aria-name/)."},l=a.createMessageInstanceIdFn(n,s);t.exports=class AriaCommandName extends i{static get meta(){return{id:"aria-command-name",title:l(s.title),failureTitle:l(s.failureTitle),description:l(s.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/accessibility/aria-command-name.js")},{
"../../lib/i18n/i18n.js":84,"./axe-audit.js":2}],"../audits/accessibility/aria-hidden-body":[function(e,t,n){(function(n){"use strict";const i=e("./axe-audit.js"),a=e("../../lib/i18n/i18n.js"),s={title:'`[aria-hidden="true"]` is not present on the document `<body>`',failureTitle:'`[aria-hidden="true"]` is present on the document `<body>`',description:'Assistive technologies, like screen readers, work inconsistently when `aria-hidden="true"` is set on the document `<body>`. [Learn more](https://web.dev/aria-hidden-body/).'},l=a.createMessageInstanceIdFn(n,s);t.exports=class AriaHiddenBody extends i{static get meta(){return{id:"aria-hidden-body",title:l(s.title),failureTitle:l(s.failureTitle),description:l(s.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/accessibility/aria-hidden-body.js")},{"../../lib/i18n/i18n.js":84,"./axe-audit.js":2}],"../audits/accessibility/aria-hidden-focus":[function(e,t,n){(function(n){"use strict"
;const i=e("./axe-audit.js"),a=e("../../lib/i18n/i18n.js"),s={title:'`[aria-hidden="true"]` elements do not contain focusable descendents',failureTitle:'`[aria-hidden="true"]` elements contain focusable descendents',description:'Focusable descendents within an `[aria-hidden="true"]` element prevent those interactive elements from being available to users of assistive technologies like screen readers. [Learn more](https://web.dev/aria-hidden-focus/).'},l=a.createMessageInstanceIdFn(n,s);t.exports=class AriaHiddenFocus extends i{static get meta(){return{id:"aria-hidden-focus",title:l(s.title),failureTitle:l(s.failureTitle),description:l(s.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/accessibility/aria-hidden-focus.js")},{"../../lib/i18n/i18n.js":84,"./axe-audit.js":2}],"../audits/accessibility/aria-input-field-name":[function(e,t,n){(function(n){"use strict";const i=e("./axe-audit.js"),a=e("../../lib/i18n/i18n.js"),s={
title:"ARIA input fields have accessible names",failureTitle:"ARIA input fields do not have accessible names",description:"When an input field doesn't have an accessible name, screen readers announce it with a generic name, making it unusable for users who rely on screen readers. [Learn more](https://web.dev/aria-name/)."},l=a.createMessageInstanceIdFn(n,s);t.exports=class AriaInputFieldName extends i{static get meta(){return{id:"aria-input-field-name",title:l(s.title),failureTitle:l(s.failureTitle),description:l(s.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/accessibility/aria-input-field-name.js")},{"../../lib/i18n/i18n.js":84,"./axe-audit.js":2}],"../audits/accessibility/aria-meter-name":[function(e,t,n){(function(n){"use strict";const i=e("./axe-audit.js"),a=e("../../lib/i18n/i18n.js"),s={title:"ARIA `meter` elements have accessible names",failureTitle:"ARIA `meter` elements do not have accessible names.",
description:"When an element doesn't have an accessible name, screen readers announce it with a generic name, making it unusable for users who rely on screen readers. [Learn more](https://web.dev/aria-name/)."},l=a.createMessageInstanceIdFn(n,s);t.exports=class AriaMeterName extends i{static get meta(){return{id:"aria-meter-name",title:l(s.title),failureTitle:l(s.failureTitle),description:l(s.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/accessibility/aria-meter-name.js")},{"../../lib/i18n/i18n.js":84,"./axe-audit.js":2}],"../audits/accessibility/aria-progressbar-name":[function(e,t,n){(function(n){"use strict";const i=e("./axe-audit.js"),a=e("../../lib/i18n/i18n.js"),s={title:"ARIA `progressbar` elements have accessible names",failureTitle:"ARIA `progressbar` elements do not have accessible names.",
description:"When an element doesn't have an accessible name, screen readers announce it with a generic name, making it unusable for users who rely on screen readers. [Learn more](https://web.dev/aria-name/)."},l=a.createMessageInstanceIdFn(n,s);t.exports=class AriaProgressbarName extends i{static get meta(){return{id:"aria-progressbar-name",title:l(s.title),failureTitle:l(s.failureTitle),description:l(s.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/accessibility/aria-progressbar-name.js")},{"../../lib/i18n/i18n.js":84,"./axe-audit.js":2}],"../audits/accessibility/aria-required-attr":[function(e,t,n){(function(n){"use strict";const i=e("./axe-audit.js"),a=e("../../lib/i18n/i18n.js"),s={title:"`[role]`s have all required `[aria-*]` attributes",failureTitle:"`[role]`s do not have all required `[aria-*]` attributes",
description:"Some ARIA roles have required attributes that describe the state of the element to screen readers. [Learn more](https://web.dev/aria-required-attr/)."},l=a.createMessageInstanceIdFn(n,s);t.exports=class ARIARequiredAttr extends i{static get meta(){return{id:"aria-required-attr",title:l(s.title),failureTitle:l(s.failureTitle),description:l(s.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/accessibility/aria-required-attr.js")},{"../../lib/i18n/i18n.js":84,"./axe-audit.js":2}],"../audits/accessibility/aria-required-children":[function(e,t,n){(function(n){"use strict";const i=e("./axe-audit.js"),a=e("../../lib/i18n/i18n.js"),s={title:"Elements with an ARIA `[role]` that require children to contain a specific `[role]` have all required children.",failureTitle:"Elements with an ARIA `[role]` that require children to contain a specific `[role]` are missing some or all of those required children.",
description:"Some ARIA parent roles must contain specific child roles to perform their intended accessibility functions. [Learn more](https://web.dev/aria-required-children/)."},l=a.createMessageInstanceIdFn(n,s);t.exports=class AriaRequiredChildren extends i{static get meta(){return{id:"aria-required-children",title:l(s.title),failureTitle:l(s.failureTitle),description:l(s.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/accessibility/aria-required-children.js")},{"../../lib/i18n/i18n.js":84,"./axe-audit.js":2}],"../audits/accessibility/aria-required-parent":[function(e,t,n){(function(n){"use strict";const i=e("./axe-audit.js"),a=e("../../lib/i18n/i18n.js"),s={title:"`[role]`s are contained by their required parent element",failureTitle:"`[role]`s are not contained by their required parent element",
description:"Some ARIA child roles must be contained by specific parent roles to properly perform their intended accessibility functions. [Learn more](https://web.dev/aria-required-parent/)."},l=a.createMessageInstanceIdFn(n,s);t.exports=class AriaRequiredParent extends i{static get meta(){return{id:"aria-required-parent",title:l(s.title),failureTitle:l(s.failureTitle),description:l(s.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/accessibility/aria-required-parent.js")},{"../../lib/i18n/i18n.js":84,"./axe-audit.js":2}],"../audits/accessibility/aria-roles":[function(e,t,n){(function(n){"use strict";const i=e("./axe-audit.js"),a=e("../../lib/i18n/i18n.js"),s={title:"`[role]` values are valid",failureTitle:"`[role]` values are not valid",description:"ARIA roles must have valid values in order to perform their intended accessibility functions. [Learn more](https://web.dev/aria-roles/)."},l=a.createMessageInstanceIdFn(n,s)
;t.exports=class AriaRoles extends i{static get meta(){return{id:"aria-roles",title:l(s.title),failureTitle:l(s.failureTitle),description:l(s.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/accessibility/aria-roles.js")},{"../../lib/i18n/i18n.js":84,"./axe-audit.js":2}],"../audits/accessibility/aria-toggle-field-name":[function(e,t,n){(function(n){"use strict";const i=e("./axe-audit.js"),a=e("../../lib/i18n/i18n.js"),s={title:"ARIA toggle fields have accessible names",failureTitle:"ARIA toggle fields do not have accessible names",description:"When a toggle field doesn't have an accessible name, screen readers announce it with a generic name, making it unusable for users who rely on screen readers. [Learn more](https://web.dev/aria-name/)."},l=a.createMessageInstanceIdFn(n,s);t.exports=class AriaToggleFieldName extends i{static get meta(){return{id:"aria-toggle-field-name",title:l(s.title),failureTitle:l(s.failureTitle),
description:l(s.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/accessibility/aria-toggle-field-name.js")},{"../../lib/i18n/i18n.js":84,"./axe-audit.js":2}],"../audits/accessibility/aria-tooltip-name":[function(e,t,n){(function(n){"use strict";const i=e("./axe-audit.js"),a=e("../../lib/i18n/i18n.js"),s={title:"ARIA `tooltip` elements have accessible names",failureTitle:"ARIA `tooltip` elements do not have accessible names.",description:"When an element doesn't have an accessible name, screen readers announce it with a generic name, making it unusable for users who rely on screen readers. [Learn more](https://web.dev/aria-name/)."},l=a.createMessageInstanceIdFn(n,s);t.exports=class AriaTooltipName extends i{static get meta(){return{id:"aria-tooltip-name",title:l(s.title),failureTitle:l(s.failureTitle),description:l(s.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=s
}).call(this,"/lighthouse-core/audits/accessibility/aria-tooltip-name.js")},{"../../lib/i18n/i18n.js":84,"./axe-audit.js":2}],"../audits/accessibility/aria-treeitem-name":[function(e,t,n){(function(n){"use strict";const i=e("./axe-audit.js"),a=e("../../lib/i18n/i18n.js"),s={title:"ARIA `treeitem` elements have accessible names",failureTitle:"ARIA `treeitem` elements do not have accessible names.",description:"When an element doesn't have an accessible name, screen readers announce it with a generic name, making it unusable for users who rely on screen readers. [Learn more](https://web.dev/aria-name/)."},l=a.createMessageInstanceIdFn(n,s);t.exports=class AriaTreeitemName extends i{static get meta(){return{id:"aria-treeitem-name",title:l(s.title),failureTitle:l(s.failureTitle),description:l(s.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/accessibility/aria-treeitem-name.js")},{"../../lib/i18n/i18n.js":84,"./axe-audit.js":2
}],"../audits/accessibility/aria-valid-attr-value":[function(e,t,n){(function(n){"use strict";const i=e("./axe-audit.js"),a=e("../../lib/i18n/i18n.js"),s={title:"`[aria-*]` attributes have valid values",failureTitle:"`[aria-*]` attributes do not have valid values",description:"Assistive technologies, like screen readers, can't interpret ARIA attributes with invalid values. [Learn more](https://web.dev/aria-valid-attr-value/)."},l=a.createMessageInstanceIdFn(n,s);t.exports=class ARIAValidAttr extends i{static get meta(){return{id:"aria-valid-attr-value",title:l(s.title),failureTitle:l(s.failureTitle),description:l(s.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/accessibility/aria-valid-attr-value.js")},{"../../lib/i18n/i18n.js":84,"./axe-audit.js":2}],"../audits/accessibility/aria-valid-attr":[function(e,t,n){(function(n){"use strict";const i=e("./axe-audit.js"),a=e("../../lib/i18n/i18n.js"),s={
title:"`[aria-*]` attributes are valid and not misspelled",failureTitle:"`[aria-*]` attributes are not valid or misspelled",description:"Assistive technologies, like screen readers, can't interpret ARIA attributes with invalid names. [Learn more](https://web.dev/aria-valid-attr/)."},l=a.createMessageInstanceIdFn(n,s);t.exports=class ARIAValidAttr extends i{static get meta(){return{id:"aria-valid-attr",title:l(s.title),failureTitle:l(s.failureTitle),description:l(s.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/accessibility/aria-valid-attr.js")},{"../../lib/i18n/i18n.js":84,"./axe-audit.js":2}],"../audits/accessibility/button-name":[function(e,t,n){(function(n){"use strict";const i=e("./axe-audit.js"),a=e("../../lib/i18n/i18n.js"),s={title:"Buttons have an accessible name",failureTitle:"Buttons do not have an accessible name",
description:'When a button doesn\'t have an accessible name, screen readers announce it as "button", making it unusable for users who rely on screen readers. [Learn more](https://web.dev/button-name/).'},l=a.createMessageInstanceIdFn(n,s);t.exports=class ButtonName extends i{static get meta(){return{id:"button-name",title:l(s.title),failureTitle:l(s.failureTitle),description:l(s.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/accessibility/button-name.js")},{"../../lib/i18n/i18n.js":84,"./axe-audit.js":2}],"../audits/accessibility/bypass":[function(e,t,n){(function(n){"use strict";const i=e("./axe-audit.js"),a=e("../../lib/i18n/i18n.js"),s={title:"The page contains a heading, skip link, or landmark region",failureTitle:"The page does not contain a heading, skip link, or landmark region",
description:"Adding ways to bypass repetitive content lets keyboard users navigate the page more efficiently. [Learn more](https://web.dev/bypass/)."},l=a.createMessageInstanceIdFn(n,s);t.exports=class Bypass extends i{static get meta(){return{id:"bypass",title:l(s.title),failureTitle:l(s.failureTitle),description:l(s.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/accessibility/bypass.js")},{"../../lib/i18n/i18n.js":84,"./axe-audit.js":2}],"../audits/accessibility/color-contrast":[function(e,t,n){(function(n){"use strict";const i=e("./axe-audit.js"),a=e("../../lib/i18n/i18n.js"),s={title:"Background and foreground colors have a sufficient contrast ratio",failureTitle:"Background and foreground colors do not have a sufficient contrast ratio.",description:"Low-contrast text is difficult or impossible for many users to read. [Learn more](https://web.dev/color-contrast/)."},l=a.createMessageInstanceIdFn(n,s)
;t.exports=class ColorContrast extends i{static get meta(){return{id:"color-contrast",title:l(s.title),failureTitle:l(s.failureTitle),description:l(s.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/accessibility/color-contrast.js")},{"../../lib/i18n/i18n.js":84,"./axe-audit.js":2}],"../audits/accessibility/definition-list":[function(e,t,n){(function(n){"use strict";const i=e("./axe-audit.js"),a=e("../../lib/i18n/i18n.js"),s={title:"`<dl>`'s contain only properly-ordered `<dt>` and `<dd>` groups, `<script>`, `<template>` or `<div>` elements.",failureTitle:"`<dl>`'s do not contain only properly-ordered `<dt>` and `<dd>` groups, `<script>`, `<template>` or `<div>` elements.",description:"When definition lists are not properly marked up, screen readers may produce confusing or inaccurate output. [Learn more](https://web.dev/definition-list/)."},l=a.createMessageInstanceIdFn(n,s);t.exports=class DefinitionList extends i{
static get meta(){return{id:"definition-list",title:l(s.title),failureTitle:l(s.failureTitle),description:l(s.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/accessibility/definition-list.js")},{"../../lib/i18n/i18n.js":84,"./axe-audit.js":2}],"../audits/accessibility/dlitem":[function(e,t,n){(function(n){"use strict";const i=e("./axe-audit.js"),a=e("../../lib/i18n/i18n.js"),s={title:"Definition list items are wrapped in `<dl>` elements",failureTitle:"Definition list items are not wrapped in `<dl>` elements",description:"Definition list items (`<dt>` and `<dd>`) must be wrapped in a parent `<dl>` element to ensure that screen readers can properly announce them. [Learn more](https://web.dev/dlitem/)."},l=a.createMessageInstanceIdFn(n,s);t.exports=class DLItem extends i{static get meta(){return{id:"dlitem",title:l(s.title),failureTitle:l(s.failureTitle),description:l(s.description),requiredArtifacts:["Accessibility"]}}},
t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/accessibility/dlitem.js")},{"../../lib/i18n/i18n.js":84,"./axe-audit.js":2}],"../audits/accessibility/document-title":[function(e,t,n){(function(n){"use strict";const i=e("./axe-audit.js"),a=e("../../lib/i18n/i18n.js"),s={title:"Document has a `<title>` element",failureTitle:"Document doesn't have a `<title>` element",description:"The title gives screen reader users an overview of the page, and search engine users rely on it heavily to determine if a page is relevant to their search. [Learn more](https://web.dev/document-title/)."},l=a.createMessageInstanceIdFn(n,s);t.exports=class DocumentTitle extends i{static get meta(){return{id:"document-title",title:l(s.title),failureTitle:l(s.failureTitle),description:l(s.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/accessibility/document-title.js")},{"../../lib/i18n/i18n.js":84,"./axe-audit.js":2}],
"../audits/accessibility/duplicate-id-active":[function(e,t,n){(function(n){"use strict";const i=e("./axe-audit.js"),a=e("../../lib/i18n/i18n.js"),s={title:"`[id]` attributes on active, focusable elements are unique",failureTitle:"`[id]` attributes on active, focusable elements are not unique",description:"All focusable elements must have a unique `id` to ensure that they're visible to assistive technologies. [Learn more](https://web.dev/duplicate-id-active/)."},l=a.createMessageInstanceIdFn(n,s);t.exports=class DuplicateIdActive extends i{static get meta(){return{id:"duplicate-id-active",title:l(s.title),failureTitle:l(s.failureTitle),description:l(s.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/accessibility/duplicate-id-active.js")},{"../../lib/i18n/i18n.js":84,"./axe-audit.js":2}],"../audits/accessibility/duplicate-id-aria":[function(e,t,n){(function(n){"use strict"
;const i=e("./axe-audit.js"),a=e("../../lib/i18n/i18n.js"),s={title:"ARIA IDs are unique",failureTitle:"ARIA IDs are not unique",description:"The value of an ARIA ID must be unique to prevent other instances from being overlooked by assistive technologies. [Learn more](https://web.dev/duplicate-id-aria/)."},l=a.createMessageInstanceIdFn(n,s);t.exports=class DuplicateIdAria extends i{static get meta(){return{id:"duplicate-id-aria",title:l(s.title),failureTitle:l(s.failureTitle),description:l(s.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/accessibility/duplicate-id-aria.js")},{"../../lib/i18n/i18n.js":84,"./axe-audit.js":2}],"../audits/accessibility/form-field-multiple-labels":[function(e,t,n){(function(n){"use strict";const i=e("./axe-audit.js"),a=e("../../lib/i18n/i18n.js"),s={title:"No form fields have multiple labels",failureTitle:"Form fields have multiple labels",
description:"Form fields with multiple labels can be confusingly announced by assistive technologies like screen readers which use either the first, the last, or all of the labels. [Learn more](https://web.dev/form-field-multiple-labels/)."},l=a.createMessageInstanceIdFn(n,s);t.exports=class FormFieldMultipleLabels extends i{static get meta(){return{id:"form-field-multiple-labels",title:l(s.title),failureTitle:l(s.failureTitle),description:l(s.description),scoreDisplayMode:i.SCORING_MODES.INFORMATIVE,requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/accessibility/form-field-multiple-labels.js")},{"../../lib/i18n/i18n.js":84,"./axe-audit.js":2}],"../audits/accessibility/frame-title":[function(e,t,n){(function(n){"use strict";const i=e("./axe-audit.js"),a=e("../../lib/i18n/i18n.js"),s={title:"`<frame>` or `<iframe>` elements have a title",failureTitle:"`<frame>` or `<iframe>` elements do not have a title",
description:"Screen reader users rely on frame titles to describe the contents of frames. [Learn more](https://web.dev/frame-title/)."},l=a.createMessageInstanceIdFn(n,s);t.exports=class FrameTitle extends i{static get meta(){return{id:"frame-title",title:l(s.title),failureTitle:l(s.failureTitle),description:l(s.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/accessibility/frame-title.js")},{"../../lib/i18n/i18n.js":84,"./axe-audit.js":2}],"../audits/accessibility/heading-order":[function(e,t,n){(function(n){"use strict";const i=e("./axe-audit.js"),a=e("../../lib/i18n/i18n.js"),s={title:"Heading elements appear in a sequentially-descending order",failureTitle:"Heading elements are not in a sequentially-descending order",
description:"Properly ordered headings that do not skip levels convey the semantic structure of the page, making it easier to navigate and understand when using assistive technologies. [Learn more](https://web.dev/heading-order/)."},l=a.createMessageInstanceIdFn(n,s);t.exports=class HeadingOrder extends i{static get meta(){return{id:"heading-order",title:l(s.title),failureTitle:l(s.failureTitle),description:l(s.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/accessibility/heading-order.js")},{"../../lib/i18n/i18n.js":84,"./axe-audit.js":2}],"../audits/accessibility/html-has-lang":[function(e,t,n){(function(n){"use strict";const i=e("./axe-audit.js"),a=e("../../lib/i18n/i18n.js"),s={title:"`<html>` element has a `[lang]` attribute",failureTitle:"`<html>` element does not have a `[lang]` attribute",
description:"If a page doesn't specify a lang attribute, a screen reader assumes that the page is in the default language that the user chose when setting up the screen reader. If the page isn't actually in the default language, then the screen reader might not announce the page's text correctly. [Learn more](https://web.dev/html-has-lang/)."},l=a.createMessageInstanceIdFn(n,s);t.exports=class HTMLHasLang extends i{static get meta(){return{id:"html-has-lang",title:l(s.title),failureTitle:l(s.failureTitle),description:l(s.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/accessibility/html-has-lang.js")},{"../../lib/i18n/i18n.js":84,"./axe-audit.js":2}],"../audits/accessibility/html-lang-valid":[function(e,t,n){(function(n){"use strict";const i=e("./axe-audit.js"),a=e("../../lib/i18n/i18n.js"),s={title:"`<html>` element has a valid value for its `[lang]` attribute",
failureTitle:"`<html>` element does not have a valid value for its `[lang]` attribute.",description:"Specifying a valid [BCP 47 language](https://www.w3.org/International/questions/qa-choosing-language-tags#question) helps screen readers announce text properly. [Learn more](https://web.dev/html-lang-valid/)."},l=a.createMessageInstanceIdFn(n,s);t.exports=class HTMLLangValid extends i{static get meta(){return{id:"html-lang-valid",title:l(s.title),failureTitle:l(s.failureTitle),description:l(s.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/accessibility/html-lang-valid.js")},{"../../lib/i18n/i18n.js":84,"./axe-audit.js":2}],"../audits/accessibility/image-alt":[function(e,t,n){(function(n){"use strict";const i=e("./axe-audit.js"),a=e("../../lib/i18n/i18n.js"),s={title:"Image elements have `[alt]` attributes",failureTitle:"Image elements do not have `[alt]` attributes",
description:"Informative elements should aim for short, descriptive alternate text. Decorative elements can be ignored with an empty alt attribute. [Learn more](https://web.dev/image-alt/)."},l=a.createMessageInstanceIdFn(n,s);t.exports=class ImageAlt extends i{static get meta(){return{id:"image-alt",title:l(s.title),failureTitle:l(s.failureTitle),description:l(s.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/accessibility/image-alt.js")},{"../../lib/i18n/i18n.js":84,"./axe-audit.js":2}],"../audits/accessibility/input-image-alt":[function(e,t,n){(function(n){"use strict";const i=e("./axe-audit.js"),a=e("../../lib/i18n/i18n.js"),s={title:'`<input type="image">` elements have `[alt]` text',failureTitle:'`<input type="image">` elements do not have `[alt]` text',
description:"When an image is being used as an `<input>` button, providing alternative text can help screen reader users understand the purpose of the button. [Learn more](https://web.dev/input-image-alt/)."},l=a.createMessageInstanceIdFn(n,s);t.exports=class InputImageAlt extends i{static get meta(){return{id:"input-image-alt",title:l(s.title),failureTitle:l(s.failureTitle),description:l(s.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/accessibility/input-image-alt.js")},{"../../lib/i18n/i18n.js":84,"./axe-audit.js":2}],"../audits/accessibility/label":[function(e,t,n){(function(n){"use strict";const i=e("./axe-audit.js"),a=e("../../lib/i18n/i18n.js"),s={title:"Form elements have associated labels",failureTitle:"Form elements do not have associated labels",description:"Labels ensure that form controls are announced properly by assistive technologies, like screen readers. [Learn more](https://web.dev/label/)."
},l=a.createMessageInstanceIdFn(n,s);t.exports=class Label extends i{static get meta(){return{id:"label",title:l(s.title),failureTitle:l(s.failureTitle),description:l(s.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/accessibility/label.js")},{"../../lib/i18n/i18n.js":84,"./axe-audit.js":2}],"../audits/accessibility/link-name":[function(e,t,n){(function(n){"use strict";const i=e("./axe-audit.js"),a=e("../../lib/i18n/i18n.js"),s={title:"Links have a discernible name",failureTitle:"Links do not have a discernible name",description:"Link text (and alternate text for images, when used as links) that is discernible, unique, and focusable improves the navigation experience for screen reader users. [Learn more](https://web.dev/link-name/)."},l=a.createMessageInstanceIdFn(n,s);t.exports=class LinkName extends i{static get meta(){return{id:"link-name",title:l(s.title),failureTitle:l(s.failureTitle),description:l(s.description),
requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/accessibility/link-name.js")},{"../../lib/i18n/i18n.js":84,"./axe-audit.js":2}],"../audits/accessibility/listitem":[function(e,t,n){(function(n){"use strict";const i=e("./axe-audit.js"),a=e("../../lib/i18n/i18n.js"),s={title:"List items (`<li>`) are contained within `<ul>` or `<ol>` parent elements",failureTitle:"List items (`<li>`) are not contained within `<ul>` or `<ol>` parent elements.",description:"Screen readers require list items (`<li>`) to be contained within a parent `<ul>` or `<ol>` to be announced properly. [Learn more](https://web.dev/listitem/)."},l=a.createMessageInstanceIdFn(n,s);t.exports=class ListItem extends i{static get meta(){return{id:"listitem",title:l(s.title),failureTitle:l(s.failureTitle),description:l(s.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/accessibility/listitem.js")},{
"../../lib/i18n/i18n.js":84,"./axe-audit.js":2}],"../audits/accessibility/list":[function(e,t,n){(function(n){"use strict";const i=e("./axe-audit.js"),a=e("../../lib/i18n/i18n.js"),s={title:"Lists contain only `<li>` elements and script supporting elements (`<script>` and `<template>`).",failureTitle:"Lists do not contain only `<li>` elements and script supporting elements (`<script>` and `<template>`).",description:"Screen readers have a specific way of announcing lists. Ensuring proper list structure aids screen reader output. [Learn more](https://web.dev/list/)."},l=a.createMessageInstanceIdFn(n,s);t.exports=class List extends i{static get meta(){return{id:"list",title:l(s.title),failureTitle:l(s.failureTitle),description:l(s.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/accessibility/list.js")},{"../../lib/i18n/i18n.js":84,"./axe-audit.js":2}],"../audits/accessibility/manual/custom-controls-labels":[function(e,t,n){
"use strict";const i=e("../../manual/manual-audit.js");t.exports=class CustomControlsLabels extends i{static get meta(){return Object.assign({id:"custom-controls-labels",description:"Custom interactive controls have associated labels, provided by aria-label or aria-labelledby. [Learn more](https://web.dev/custom-controls-labels/).",title:"Custom controls have associated labels"},super.partialMeta)}}},{"../../manual/manual-audit.js":6}],"../audits/accessibility/manual/custom-controls-roles":[function(e,t,n){"use strict";const i=e("../../manual/manual-audit.js");t.exports=class CustomControlsRoles extends i{static get meta(){return Object.assign({id:"custom-controls-roles",description:"Custom interactive controls have appropriate ARIA roles. [Learn more](https://web.dev/custom-control-roles/).",title:"Custom controls have ARIA roles"},super.partialMeta)}}},{"../../manual/manual-audit.js":6}],"../audits/accessibility/manual/focus-traps":[function(e,t,n){"use strict"
;const i=e("../../manual/manual-audit.js");t.exports=class FocusTraps extends i{static get meta(){return Object.assign({id:"focus-traps",description:"A user can tab into and out of any control or region without accidentally trapping their focus. [Learn more](https://web.dev/focus-traps/).",title:"User focus is not accidentally trapped in a region"},super.partialMeta)}}},{"../../manual/manual-audit.js":6}],"../audits/accessibility/manual/focusable-controls":[function(e,t,n){"use strict";const i=e("../../manual/manual-audit.js");t.exports=class FocusableControls extends i{static get meta(){return Object.assign({id:"focusable-controls",description:"Custom interactive controls are keyboard focusable and display a focus indicator. [Learn more](https://web.dev/focusable-controls/).",title:"Interactive controls are keyboard focusable"},super.partialMeta)}}},{"../../manual/manual-audit.js":6}],"../audits/accessibility/manual/interactive-element-affordance":[function(e,t,n){"use strict"
;const i=e("../../manual/manual-audit.js");t.exports=class InteractiveElementAffordance extends i{static get meta(){return Object.assign({id:"interactive-element-affordance",description:"Interactive elements, such as links and buttons, should indicate their state and be distinguishable from non-interactive elements. [Learn more](https://web.dev/interactive-element-affordance/).",title:"Interactive elements indicate their purpose and state"},super.partialMeta)}}},{"../../manual/manual-audit.js":6}],"../audits/accessibility/manual/logical-tab-order":[function(e,t,n){"use strict";const i=e("../../manual/manual-audit.js");t.exports=class LogicalTabOrder extends i{static get meta(){return Object.assign({id:"logical-tab-order",description:"Tabbing through the page follows the visual layout. Users cannot focus elements that are offscreen. [Learn more](https://web.dev/logical-tab-order/).",title:"The page has a logical tab order"},super.partialMeta)}}},{"../../manual/manual-audit.js":6}],
"../audits/accessibility/manual/managed-focus":[function(e,t,n){"use strict";const i=e("../../manual/manual-audit.js");t.exports=class ManagedFocus extends i{static get meta(){return Object.assign({id:"managed-focus",description:"If new content, such as a dialog, is added to the page, the user's focus is directed to it. [Learn more](https://web.dev/managed-focus/).",title:"The user's focus is directed to new content added to the page"},super.partialMeta)}}},{"../../manual/manual-audit.js":6}],"../audits/accessibility/manual/offscreen-content-hidden":[function(e,t,n){"use strict";const i=e("../../manual/manual-audit.js");t.exports=class OffscreenContentHidden extends i{static get meta(){return Object.assign({id:"offscreen-content-hidden",description:"Offscreen content is hidden with display: none or aria-hidden=true. [Learn more](https://web.dev/offscreen-content-hidden/).",title:"Offscreen content is hidden from assistive technology"},super.partialMeta)}}},{
"../../manual/manual-audit.js":6}],"../audits/accessibility/manual/use-landmarks":[function(e,t,n){"use strict";const i=e("../../manual/manual-audit.js");t.exports=class UseLandmarks extends i{static get meta(){return Object.assign({id:"use-landmarks",description:"Landmark elements (<main>, <nav>, etc.) are used to improve the keyboard navigation of the page for assistive technology. [Learn more](https://web.dev/use-landmarks/).",title:"HTML5 landmark elements are used to improve navigation"},super.partialMeta)}}},{"../../manual/manual-audit.js":6}],"../audits/accessibility/manual/visual-order-follows-dom":[function(e,t,n){"use strict";const i=e("../../manual/manual-audit.js");t.exports=class VisualOrderFollowsDOM extends i{static get meta(){return Object.assign({id:"visual-order-follows-dom",description:"DOM order matches the visual order, improving navigation for assistive technology. [Learn more](https://web.dev/visual-order-follows-dom/).",
title:"Visual order on the page follows DOM order"},super.partialMeta)}}},{"../../manual/manual-audit.js":6}],"../audits/accessibility/meta-refresh":[function(e,t,n){(function(n){"use strict";const i=e("./axe-audit.js"),a=e("../../lib/i18n/i18n.js"),s={title:'The document does not use `<meta http-equiv="refresh">`',failureTitle:'The document uses `<meta http-equiv="refresh">`',description:"Users do not expect a page to refresh automatically, and doing so will move focus back to the top of the page. This may create a frustrating or confusing experience. [Learn more](https://web.dev/meta-refresh/)."},l=a.createMessageInstanceIdFn(n,s);t.exports=class MetaRefresh extends i{static get meta(){return{id:"meta-refresh",title:l(s.title),failureTitle:l(s.failureTitle),description:l(s.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/accessibility/meta-refresh.js")},{"../../lib/i18n/i18n.js":84,"./axe-audit.js":2}],
"../audits/accessibility/meta-viewport":[function(e,t,n){(function(n){"use strict";const i=e("./axe-audit.js"),a=e("../../lib/i18n/i18n.js"),s={title:'`[user-scalable="no"]` is not used in the `<meta name="viewport">` element and the `[maximum-scale]` attribute is not less than 5.',failureTitle:'`[user-scalable="no"]` is used in the `<meta name="viewport">` element or the `[maximum-scale]` attribute is less than 5.',description:"Disabling zooming is problematic for users with low vision who rely on screen magnification to properly see the contents of a web page. [Learn more](https://web.dev/meta-viewport/)."},l=a.createMessageInstanceIdFn(n,s);t.exports=class MetaViewport extends i{static get meta(){return{id:"meta-viewport",title:l(s.title),failureTitle:l(s.failureTitle),description:l(s.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/accessibility/meta-viewport.js")},{"../../lib/i18n/i18n.js":84,"./axe-audit.js":2}],
"../audits/accessibility/object-alt":[function(e,t,n){(function(n){"use strict";const i=e("./axe-audit.js"),a=e("../../lib/i18n/i18n.js"),s={title:"`<object>` elements have `[alt]` text",failureTitle:"`<object>` elements do not have `[alt]` text",description:"Screen readers cannot translate non-text content. Adding alt text to `<object>` elements helps screen readers convey meaning to users. [Learn more](https://web.dev/object-alt/)."},l=a.createMessageInstanceIdFn(n,s);t.exports=class ObjectAlt extends i{static get meta(){return{id:"object-alt",title:l(s.title),failureTitle:l(s.failureTitle),description:l(s.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/accessibility/object-alt.js")},{"../../lib/i18n/i18n.js":84,"./axe-audit.js":2}],"../audits/accessibility/tabindex":[function(e,t,n){(function(n){"use strict";const i=e("./axe-audit.js"),a=e("../../lib/i18n/i18n.js"),s={
title:"No element has a `[tabindex]` value greater than 0",failureTitle:"Some elements have a `[tabindex]` value greater than 0",description:"A value greater than 0 implies an explicit navigation ordering. Although technically valid, this often creates frustrating experiences for users who rely on assistive technologies. [Learn more](https://web.dev/tabindex/)."},l=a.createMessageInstanceIdFn(n,s);t.exports=class TabIndex extends i{static get meta(){return{id:"tabindex",title:l(s.title),failureTitle:l(s.failureTitle),description:l(s.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/accessibility/tabindex.js")},{"../../lib/i18n/i18n.js":84,"./axe-audit.js":2}],"../audits/accessibility/td-headers-attr":[function(e,t,n){(function(n){"use strict";const i=e("./axe-audit.js"),a=e("../../lib/i18n/i18n.js"),s={title:"Cells in a `<table>` element that use the `[headers]` attribute refer to table cells within the same table.",
failureTitle:"Cells in a `<table>` element that use the `[headers]` attribute refer to an element `id` not found within the same table.",description:"Screen readers have features to make navigating tables easier. Ensuring `<td>` cells using the `[headers]` attribute only refer to other cells in the same table may improve the experience for screen reader users. [Learn more](https://web.dev/td-headers-attr/)."},l=a.createMessageInstanceIdFn(n,s);t.exports=class TDHeadersAttr extends i{static get meta(){return{id:"td-headers-attr",title:l(s.title),failureTitle:l(s.failureTitle),description:l(s.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/accessibility/td-headers-attr.js")},{"../../lib/i18n/i18n.js":84,"./axe-audit.js":2}],"../audits/accessibility/th-has-data-cells":[function(e,t,n){(function(n){"use strict";const i=e("./axe-audit.js"),a=e("../../lib/i18n/i18n.js"),s={
title:'`<th>` elements and elements with `[role="columnheader"/"rowheader"]` have data cells they describe.',failureTitle:'`<th>` elements and elements with `[role="columnheader"/"rowheader"]` do not have data cells they describe.',description:"Screen readers have features to make navigating tables easier. Ensuring table headers always refer to some set of cells may improve the experience for screen reader users. [Learn more](https://web.dev/th-has-data-cells/)."},l=a.createMessageInstanceIdFn(n,s);t.exports=class THHasDataCells extends i{static get meta(){return{id:"th-has-data-cells",title:l(s.title),failureTitle:l(s.failureTitle),description:l(s.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/accessibility/th-has-data-cells.js")},{"../../lib/i18n/i18n.js":84,"./axe-audit.js":2}],"../audits/accessibility/valid-lang":[function(e,t,n){(function(n){"use strict";const i=e("./axe-audit.js"),a=e("../../lib/i18n/i18n.js"),s={
title:"`[lang]` attributes have a valid value",failureTitle:"`[lang]` attributes do not have a valid value",description:"Specifying a valid [BCP 47 language](https://www.w3.org/International/questions/qa-choosing-language-tags#question) on elements helps ensure that text is pronounced correctly by a screen reader. [Learn more](https://web.dev/valid-lang/)."},l=a.createMessageInstanceIdFn(n,s);t.exports=class ValidLang extends i{static get meta(){return{id:"valid-lang",title:l(s.title),failureTitle:l(s.failureTitle),description:l(s.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/accessibility/valid-lang.js")},{"../../lib/i18n/i18n.js":84,"./axe-audit.js":2}],"../audits/accessibility/video-caption":[function(e,t,n){(function(n){"use strict";const i=e("./axe-audit.js"),a=e("../../lib/i18n/i18n.js"),s={title:'`<video>` elements contain a `<track>` element with `[kind="captions"]`',
failureTitle:'`<video>` elements do not contain a `<track>` element with `[kind="captions"]`.',description:"When a video provides a caption it is easier for deaf and hearing impaired users to access its information. [Learn more](https://web.dev/video-caption/)."},l=a.createMessageInstanceIdFn(n,s);t.exports=class VideoCaption extends i{static get meta(){return{id:"video-caption",title:l(s.title),failureTitle:l(s.failureTitle),description:l(s.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/accessibility/video-caption.js")},{"../../lib/i18n/i18n.js":84,"./axe-audit.js":2}],"../audits/apple-touch-icon":[function(e,t,n){(function(n){"use strict";const i=e("./audit.js"),a=e("../lib/i18n/i18n.js"),s={title:"Provides a valid `apple-touch-icon`",failureTitle:"Does not provide a valid `apple-touch-icon`",
description:"For ideal appearance on iOS when users add a progressive web app to the home screen, define an `apple-touch-icon`. It must point to a non-transparent 192px (or 180px) square PNG. [Learn More](https://web.dev/apple-touch-icon/).",precomposedWarning:"`apple-touch-icon-precomposed` is out of date; `apple-touch-icon` is preferred."},l=a.createMessageInstanceIdFn(n,s);t.exports=class AppleTouchIcon extends i{static get meta(){return{id:"apple-touch-icon",title:l(s.title),failureTitle:l(s.failureTitle),description:l(s.description),requiredArtifacts:["LinkElements"]}}static audit(e){const t=e.LinkElements.filter((e=>"apple-touch-icon"===e.rel||"apple-touch-icon-precomposed"===e.rel)).filter((e=>!!e.href)),n=0!==t.length,i=[];return 0!==t.filter((e=>"apple-touch-icon-precomposed"===e.rel)).length&&0===t.filter((e=>"apple-touch-icon"===e.rel)).length&&i.push(l(s.precomposedWarning)),{score:n?1:0,warnings:i}}},t.exports.UIStrings=s
}).call(this,"/lighthouse-core/audits/apple-touch-icon.js")},{"../lib/i18n/i18n.js":84,"./audit.js":3}],"../audits/autocomplete":[function(e,t,n){(function(n){"use strict";const i=e("./audit.js"),a=e("../lib/i18n/i18n.js"),s=e("lighthouse-logger"),l={title:"`<input>` elements correctly use `autocomplete`",failureTitle:"`<input>` elements do not have correct `autocomplete` attributes",description:"`autocomplete` helps users submit forms quicker. To reduce user effort, consider enabling by setting the `autocomplete` attribute to a valid value. [Learn more](https://developers.google.com/web/fundamentals/design-and-ux/input/forms#use_metadata_to_enable_auto-complete)",columnSuggestions:"Suggested Token",columnCurrent:"Current Value",warningInvalid:'`autocomplete` token(s): "{token}" is invalid in {snippet}',warningOrder:'Review order of tokens: "{tokens}" in {snippet}',reviewOrder:"Review order of tokens",manualReview:"Requires manual review"
},c=a.createMessageInstanceIdFn(n,l),u=["name","honorific-prefix","given-name","additional-name","family-name","honorific-suffix","nickname","username","new-password","current-password","one-time-code","organization-title","organization","street-address","address-line1","address-line2","address-line3","address-level4","address-level3","address-level2","address-level1","country","country-name","postal-code","cc-name","cc-given-name","cc-additional-name","cc-family-name","cc-number","cc-exp","cc-exp-month","cc-exp-year","cc-csc","cc-type","transaction-currency","transaction-amount","language","bday","bday-day","bday-month","bday-year","sex","url","photo","tel","tel-country-code","tel-national","tel-area-code","on","tel-local","tel-local-prefix","tel-local-suffix","tel-extension","email","impp","off","additional-name-initial","home","work","mobile","fax","pager","shipping","billing"],d=["NO_SERVER_DATA","UNKNOWN_TYPE","EMPTY_TYPE","HTML_TYPE_UNSPECIFIED","HTML_TYPE_UNRECOGNIZED"],m={
NO_SERVER_DATA:c(l.manualReview),UNKNOWN_TYPE:c(l.manualReview),EMPTY_TYPE:c(l.manualReview),NAME_FIRST:"given-name",NAME_MIDDLE:"additional-name",NAME_LAST:"family-name",NAME_FULL:"name",NAME_MIDDLE_INITIAL:"additional-name-initial",NAME_SUFFIX:"honorific-suffix",NAME_BILLING_FIRST:"billing given-name",NAME_BILLING_MIDDLE:"billing additional-name",NAME_BILLING_LAST:"billing family-name",NAME_BILLING_MIDDLE_INITIAL:"billing additional-name-initial",NAME_BILLING_FULL:"billing name",NAME_BILLING_SUFFIX:"billing honorific-suffix",EMAIL_ADDRESS:"email",MERCHANT_EMAIL_SIGNUP:"email",PHONE_HOME_NUMBER:"tel-local",PHONE_HOME_CITY_CODE:"tel-area-code",PHONE_HOME_COUNTRY_CODE:"tel-country-code",PHONE_HOME_CITY_AND_NUMBER:"tel-national",PHONE_HOME_WHOLE_NUMBER:"tel",PHONE_HOME_EXTENSION:"tel-extension",PHONE_BILLING_NUMBER:"billing tel-local",PHONE_BILLING_CITY_CODE:"billing tel-area-code",PHONE_BILLING_COUNTRY_CODE:"tel-country-code",PHONE_BILLING_CITY_AND_NUMBER:"tel-national",
PHONE_BILLING_WHOLE_NUMBER:"tel",ADDRESS_HOME_STREET_ADDRESS:"street-address",ADDRESS_HOME_LINE1:"address-line1",ADDRESS_HOME_LINE2:"address-line2",ADDRESS_HOME_LINE3:"address-line3",ADDRESS_HOME_STATE:"address-level1",ADDRESS_HOME_CITY:"address-level2",ADDRESS_HOME_DEPENDENT_LOCALITY:"address-level3",ADDRESS_HOME_ZIP:"postal-code",ADDRESS_HOME_COUNTRY:"country-name",ADDRESS_BILLING_DEPENDENT_LOCALITY:"billing address-level3",ADDRESS_BILLING_STREET_ADDRESS:"billing street-address",ADDRESS_BILLING_LINE1:"billing address-line1",ADDRESS_BILLING_LINE2:"billing address-line2",ADDRESS_BILLING_LINE3:"billing address-line3",ADDRESS_BILLING_APT_NUM:"billing address-level3",ADDRESS_BILLING_CITY:"billing address-level2",ADDRESS_BILLING_STATE:"billing address-level1",ADDRESS_BILLING_ZIP:"billing postal-code",ADDRESS_BILLING_COUNTRY:"billing country-name",CREDIT_CARD_NAME_FULL:"cc-name",CREDIT_CARD_NAME_FIRST:"cc-given-name",CREDIT_CARD_NAME_LAST:"cc-family-name",CREDIT_CARD_NUMBER:"cc-number",
CREDIT_CARD_EXP_MONTH:"cc-exp-month",CREDIT_CARD_EXP_2_DIGIT_YEAR:"cc-exp-year",CREDIT_CARD_EXP_4_DIGIT_YEAR:"cc-exp-year",CREDIT_CARD_EXP_DATE_2_DIGIT_YEAR:"cc-exp",CREDIT_CARD_EXP_DATE_4_DIGIT_YEAR:"cc-exp",CREDIT_CARD_TYPE:"cc-type",CREDIT_CARD_VERIFICATION_CODE:"cc-csc",COMPANY_NAME:"organization",PASSWORD:"current-password",ACCOUNT_CREATION_PASSWORD:"new-password",HTML_TYPE_UNSPECIFIED:c(l.manualReview),HTML_TYPE_NAME:"name",HTML_TYPE_HONORIFIC_PREFIX:"honorific-prefix",HTML_TYPE_GIVEN_NAME:"given-name",HTML_TYPE_ADDITIONAL_NAME:"additional-name",HTML_TYPE_FAMILY_NAME:"family-name",HTML_TYPE_ORGANIZATION:"organization",HTML_TYPE_STREET_ADDRESS:"street-address",HTML_TYPE_ADDRESS_LINE1:"address-line1",HTML_TYPE_ADDRESS_LINE2:"address-line2",HTML_TYPE_ADDRESS_LINE3:"address-line3",HTML_TYPE_ADDRESS_LEVEL1:"address-level1",HTML_TYPE_ADDRESS_LEVEL2:"address-level2",HTML_TYPE_ADDRESS_LEVEL3:"address-level3",HTML_TYPE_COUNTRY_CODE:"tel-country-code",HTML_TYPE_COUNTRY_NAME:"country-name",
HTML_TYPE_POSTAL_CODE:"postal-code",HTML_TYPE_FULL_ADDRESS:"street-address",HTML_TYPE_CREDIT_CARD_NAME_FULL:"cc-name",HTML_TYPE_CREDIT_CARD_NAME_FIRST:"cc-given-name",HTML_TYPE_CREDIT_CARD_NAME_LAST:"cc-family-name",HTML_TYPE_CREDIT_CARD_NUMBER:"cc-number",HTML_TYPE_CREDIT_CARD_EXP:"cc-exp",HTML_TYPE_CREDIT_CARD_EXP_MONTH:"cc-exp-month",HTML_TYPE_CREDIT_CARD_EXP_YEAR:"cc-exp-year",HTML_TYPE_CREDIT_CARD_VERIFICATION_CODE:"cc-csc",HTML_TYPE_CREDIT_CARD_TYPE:"cc-csc",HTML_TYPE_TEL:"tel",HTML_TYPE_TEL_COUNTRY_CODE:"tel-country-code",HTML_TYPE_TEL_NATIONAL:"tel-national",HTML_TYPE_TEL_AREA_CODE:"tel-area-code",HTML_TYPE_TEL_LOCAL:"tel-local",HTML_TYPE_TEL_LOCAL_PREFIX:"tel-local-prefix",HTML_TYPE_TEL_LOCAL_SUFFIX:"tel-local-suffix",HTML_TYPE_TEL_EXTENSION:"tel-extension",HTML_TYPE_EMAIL:"email",HTML_TYPE_ADDITIONAL_NAME_INITIAL:"additional-name-initial",HTML_TYPE_CREDIT_CARD_EXP_DATE_2_DIGIT_YEAR:"cc-exp-year",HTML_TYPE_CREDIT_CARD_EXP_DATE_4_DIGIT_YEAR:"cc-exp-year",
HTML_TYPE_CREDIT_CARD_EXP_2_DIGIT_YEAR:"cc-exp-year",HTML_TYPE_CREDIT_CARD_EXP_4_DIGIT_YEAR:"cc-exp-year",HTML_TYPE_UPI_VPA:c(l.manualReview),HTML_TYPE_ONE_TIME_CODE:"one-time-code",HTML_TYPE_UNRECOGNIZED:c(l.manualReview),HTML_TYPE_TRANSACTION_AMOUNT:"transaction-amount",HTML_TYPE_TRANSACTION_CURRENCY:"transaction-currency"};t.exports=class AutocompleteAudit extends i{static get meta(){return{id:"autocomplete",title:c(l.title),failureTitle:c(l.failureTitle),description:c(l.description),requiredArtifacts:["FormElements"]}}static checkAttributeValidity(e){if(!e.autocomplete.attribute)return{hasValidTokens:!1};const t=e.autocomplete.attribute.split(" ");for(const e of t)if("section-"!==e.slice(0,8)&&!u.includes(e))return{hasValidTokens:!1};return e.autocomplete.property?{hasValidTokens:!0,isValidOrder:!0}:{hasValidTokens:!0,isValidOrder:!1}}static audit(e){const t=e.FormElements,n=[],u=[];let p=!1;for(const e of t)for(const t of e.inputs){const e=this.checkAttributeValidity(t)
;if(e.hasValidTokens&&e.isValidOrder)continue;if(!t.autocomplete.prediction)continue;if(d.includes(t.autocomplete.prediction)&&!t.autocomplete.attribute)continue;p=!0;let i=m[t.autocomplete.prediction];t.autocomplete.attribute||(t.autocomplete.attribute=""),t.autocomplete.attribute&&u.push(c(l.warningInvalid,{token:t.autocomplete.attribute,snippet:t.node.snippet})),!1===e.isValidOrder&&(u.push(c(l.warningOrder,{tokens:t.autocomplete.attribute,snippet:t.node.snippet})),i=l.reviewOrder),t.autocomplete.prediction in m||!e.isValidOrder?n.push({node:{type:"node",snippet:t.node.snippet,nodeLabel:t.node.nodeLabel},suggestion:i,current:t.autocomplete.attribute}):s.warn(`Autocomplete prediction (${t.autocomplete.prediction})\n             not found in our mapping`)}const h=[{key:"node",itemType:"node",text:c(a.UIStrings.columnFailingElem)},{key:"current",itemType:"text",text:c(l.columnCurrent)},{key:"suggestion",itemType:"text",text:c(l.columnSuggestions)}],f=i.makeTableDetails(h,n);let g
;return n.length>0&&(g=c(a.UIStrings.displayValueElementsFound,{nodeCount:n.length})),{score:n.length>0?0:1,notApplicable:!p,displayValue:g,details:f,warnings:u}}},t.exports.UIStrings=l}).call(this,"/lighthouse-core/audits/autocomplete.js")},{"../lib/i18n/i18n.js":84,"./audit.js":3,"lighthouse-logger":115}],"../audits/bootup-time":[function(e,t,n){(function(n){"use strict";const i=e("./audit.js"),a=e("../lib/network-request.js"),{taskGroups:s}=e("../lib/tracehouse/task-groups.js"),l=e("../lib/i18n/i18n.js"),c=e("../computed/network-records.js"),u=e("../computed/main-thread-tasks.js"),d={title:"JavaScript execution time",failureTitle:"Reduce JavaScript execution time",description:"Consider reducing the time spent parsing, compiling, and executing JS. You may find delivering smaller JS payloads helps with this. [Learn more](https://web.dev/bootup-time/).",columnTotal:"Total CPU Time",columnScriptEval:"Script Evaluation",columnScriptParse:"Script Parse",
chromeExtensionsWarning:"Chrome extensions negatively affected this page's load performance. Try auditing the page in incognito mode or from a Chrome profile without extensions."},m=l.createMessageInstanceIdFn(n,d),p=new Set(["CpuProfiler::StartProfiling"]),h=new Set(["V8.GCCompactor","MajorGC","MinorGC"]);class BootupTime extends i{static get meta(){return{id:"bootup-time",title:m(d.title),failureTitle:m(d.failureTitle),description:m(d.description),scoreDisplayMode:i.SCORING_MODES.NUMERIC,requiredArtifacts:["traces","devtoolsLogs"]}}static get defaultOptions(){return{p10:1282,median:3500,thresholdInMs:50}}static getJavaScriptURLs(e){const t=new Set;for(const n of e)n.resourceType===a.TYPES.Script&&t.add(n.url);return t}static getAttributableURLForTask(e,t){const n=e.attributableURLs.find((e=>t.has(e))),i=e.attributableURLs[0];let a=n||i;return a&&"about:blank"!==a||(a=p.has(e.event.name)?"Browser":h.has(e.event.name)?"Browser GC":"Unattributable"),a}
static getExecutionTimingsByURL(e,t){const n=new Map;for(const i of e){const e=BootupTime.getAttributableURLForTask(i,t),a=n.get(e)||{},s=a[i.group.id]||0;a[i.group.id]=s+i.selfTime,n.set(e,a)}return n}static async audit(e,t){const n=t.settings||{},a=e.traces[BootupTime.DEFAULT_PASS],p=e.devtoolsLogs[BootupTime.DEFAULT_PASS],h=await c.request(p,t),f=await u.request(a,t),g="simulate"===n.throttlingMethod?n.throttling.cpuSlowdownMultiplier:1,y=BootupTime.getJavaScriptURLs(h),b=BootupTime.getExecutionTimingsByURL(f,y);let v=!1,w=0;const T=Array.from(b).map((([e,n])=>{let i=0;for(const[e,t]of Object.entries(n))n[e]=t*g,i+=t*g;const a=n[s.scriptEvaluation.id]||0,l=n[s.scriptParseCompile.id]||0;return i>=t.options.thresholdInMs&&(w+=a+l),v=v||e.startsWith("chrome-extension:")&&a>100,{url:e,total:i,scripting:a,scriptParseCompile:l}})).filter((e=>e.total>=t.options.thresholdInMs)).sort(((e,t)=>t.total-e.total));let S;v&&(S=[m(d.chromeExtensionsWarning)]);const E={wastedMs:w},x=[{key:"url",
itemType:"url",text:m(l.UIStrings.columnURL)},{key:"total",granularity:1,itemType:"ms",text:m(d.columnTotal)},{key:"scripting",granularity:1,itemType:"ms",text:m(d.columnScriptEval)},{key:"scriptParseCompile",granularity:1,itemType:"ms",text:m(d.columnScriptParse)}],_=BootupTime.makeTableDetails(x,T,E);return{score:i.computeLogNormalScore({p10:t.options.p10,median:t.options.median},w),numericValue:w,numericUnit:"millisecond",displayValue:w>0?m(l.UIStrings.seconds,{timeInMs:w}):"",details:_,runWarnings:S}}}t.exports=BootupTime,t.exports.UIStrings=d}).call(this,"/lighthouse-core/audits/bootup-time.js")},{"../computed/main-thread-tasks.js":14,"../computed/network-records.js":42,"../lib/i18n/i18n.js":84,"../lib/network-request.js":96,"../lib/tracehouse/task-groups.js":106,"./audit.js":3}],"../audits/byte-efficiency/duplicated-javascript":[function(e,t,n){(function(n){"use strict"
;const i=e("./byte-efficiency-audit.js"),a=e("../../computed/module-duplication.js"),s=e("../../lib/dependency-graph/simulator/network-analyzer.js"),l=e("../../lib/i18n/i18n.js"),c={title:"Remove duplicate modules in JavaScript bundles",description:"Remove large, duplicate JavaScript modules from bundles to reduce unnecessary bytes consumed by network activity. "},u=l.createMessageInstanceIdFn(n,c);function indexOfOrEnd(e,t,n=0){const i=e.indexOf(t,n);return-1===i?e.length:i}class DuplicatedJavascript extends i{static get meta(){return{id:"duplicated-javascript",title:u(c.title),description:u(c.description),scoreDisplayMode:i.SCORING_MODES.NUMERIC,requiredArtifacts:["devtoolsLogs","traces","SourceMaps","ScriptElements","URL"]}}static _getNodeModuleName(e){const t=e.split("node_modules/"),n=indexOfOrEnd(e=t[t.length-1],"/");return"@"===e[0]?e.slice(0,indexOfOrEnd(e,"/",n+1)):e.slice(0,n)}static async _getDuplicationGroupedByNodeModules(e,t){const n=await a.request(e,t),i=new Map
;for(const[e,t]of n.entries()){if(!e.includes("node_modules")){i.set(e,t);continue}const n="node_modules/"+DuplicatedJavascript._getNodeModuleName(e),a=i.get(n)||[];for(const{scriptUrl:e,resourceSize:n}of t){let t=a.find((t=>t.scriptUrl===e));t||(t={scriptUrl:e,resourceSize:0},a.push(t)),t.resourceSize+=n}i.set(n,a)}for(const e of n.values())e.sort(((e,t)=>t.resourceSize-e.resourceSize));return i}static _estimateTransferRatio(e,t){return i.estimateTransferSize(e,t,"Script")/t}static async audit_(e,t,n){const i=n.options&&n.options.ignoreThresholdInBytes||1024,a=await DuplicatedJavascript._getDuplicationGroupedByNodeModules(e,n),c=await s.findMainDocument(t),d=new Map,m=[];let p=0;const h=new Set,f=new Map;for(const[n,s]of a.entries()){const a=[];let l=0;for(let n=0;n<s.length;n++){const i=s[n],u=i.scriptUrl;let m=d.get(u);if(void 0===m){const n=u===e.URL.finalUrl?c:t.find((e=>e.url===u)),i=e.ScriptElements.find((e=>e.src===u));if(!i||null===i.content)continue;const a=i.content.length
;m=DuplicatedJavascript._estimateTransferRatio(n,a),d.set(u,m)}if(void 0===m)continue;const p=Math.round(i.resourceSize*m);a.push({url:u,sourceTransferBytes:p}),0!==n&&(l+=p,f.set(u,(f.get(u)||0)+p))}if(l<=i){p+=l;for(const e of a)h.add(e.url)}else m.push({source:n,wastedBytes:l,url:"",totalBytes:0,subItems:{type:"subitems",items:a}})}p>i&&m.push({source:"Other",wastedBytes:p,url:"",totalBytes:0,subItems:{type:"subitems",items:Array.from(h).map((e=>({url:e})))}});return{items:m,headings:[{key:"source",valueType:"code",subItemsHeading:{key:"url",valueType:"url"},label:u(l.UIStrings.columnSource)},{key:null,valueType:"bytes",subItemsHeading:{key:"sourceTransferBytes"},granularity:.05,label:u(l.UIStrings.columnTransferSize)},{key:"wastedBytes",valueType:"bytes",granularity:.05,label:u(l.UIStrings.columnWastedBytes)}],wastedBytesByUrl:f}}}t.exports=DuplicatedJavascript,t.exports.UIStrings=c}).call(this,"/lighthouse-core/audits/byte-efficiency/duplicated-javascript.js")},{
"../../computed/module-duplication.js":40,"../../lib/dependency-graph/simulator/network-analyzer.js":79,"../../lib/i18n/i18n.js":84,"./byte-efficiency-audit.js":4}],"../audits/byte-efficiency/efficient-animated-content":[function(e,t,n){(function(n){"use strict";const i=e("../../lib/network-request.js"),a=e("./byte-efficiency-audit.js"),s=e("../../lib/i18n/i18n.js"),l={title:"Use video formats for animated content",description:"Large GIFs are inefficient for delivering animated content. Consider using MPEG4/WebM videos for animations and PNG/WebP for static images instead of GIF to save network bytes. [Learn more](https://web.dev/efficient-animated-content/)"},c=s.createMessageInstanceIdFn(n,l);class EfficientAnimatedContent extends a{static get meta(){return{id:"efficient-animated-content",title:c(l.title),description:c(l.description),scoreDisplayMode:a.SCORING_MODES.NUMERIC,requiredArtifacts:["devtoolsLogs","traces"]}}static getPercentSavings(e){
return Math.round(29.1*Math.log10(e)-100.7)/100}static audit_(e,t){return{items:t.filter((e=>"image/gif"===e.mimeType&&e.resourceType===i.TYPES.Image&&(e.resourceSize||0)>102400)).map((e=>{const t=e.resourceSize||0;return{url:e.url,totalBytes:t,wastedBytes:Math.round(t*EfficientAnimatedContent.getPercentSavings(t))}})),headings:[{key:"url",valueType:"url",label:c(s.UIStrings.columnURL)},{key:"totalBytes",valueType:"bytes",label:c(s.UIStrings.columnResourceSize)},{key:"wastedBytes",valueType:"bytes",label:c(s.UIStrings.columnWastedBytes)}]}}}t.exports=EfficientAnimatedContent,t.exports.UIStrings=l}).call(this,"/lighthouse-core/audits/byte-efficiency/efficient-animated-content.js")},{"../../lib/i18n/i18n.js":84,"../../lib/network-request.js":96,"./byte-efficiency-audit.js":4}],"../audits/byte-efficiency/legacy-javascript":[function(e,t,n){(function(n){"use strict"
;const i=e("./byte-efficiency-audit.js"),a=e("../../computed/js-bundles.js"),s=e("../../lib/i18n/i18n.js"),l=e("../../lib/third-party-web.js"),c=e("../../lib/dependency-graph/simulator/network-analyzer.js"),u={title:"Avoid serving legacy JavaScript to modern browsers",description:"Polyfills and transforms enable legacy browsers to use new JavaScript features. However, many aren't necessary for modern browsers. For your bundled JavaScript, adopt a modern script deployment strategy using module/nomodule feature detection to reduce the amount of code shipped to modern browsers, while retaining support for legacy browsers. [Learn More](https://philipwalton.com/articles/deploying-es2015-code-in-production-today/)"},d=s.createMessageInstanceIdFn(n,u);class CodePatternMatcher{constructor(e){const t=e.map((e=>`(${e.expression})`)).join("|");this.re=new RegExp("(^\r\n|\r|\n)|"+t,"g"),this.patterns=e}match(e){this.re.lastIndex=0;const t=new Set,n=[];let i,a=0,s=0
;for(;null!==(i=this.re.exec(e));){const e=i.slice(1),[l,...c]=e;if(l){a++,s=i.index+1;continue}const u=this.patterns[c.findIndex(Boolean)];if(t.has(u)){const e=n.find((e=>e.name===u.name));e&&(e.count+=1)}else t.add(u),n.push({name:u.name,line:a,column:i.index-s,count:1})}return n}}t.exports=class LegacyJavascript extends i{static get meta(){return{id:"legacy-javascript",scoreDisplayMode:i.SCORING_MODES.NUMERIC,description:d(u.description),title:d(u.title),requiredArtifacts:["devtoolsLogs","traces","ScriptElements","SourceMaps","URL"]}}static buildPolyfillExpression(e,t){const qt=e=>`['"]${e}['"]`;let n="";if(n+=e?`${e}\\.${t}\\s?=[^=]`:`(?:window\\.|[\\s;]+)${t}\\s?=[^=]`,e&&(n+=`|${e}\\[${qt(t)}\\]\\s?=[^=]`),n+=`|defineProperty\\(${e||"window"},\\s?${qt(t)}`,e){const i=e.replace(".prototype","");n+=`|\\$export\\([^,]+,${qt(i)},{${t}:`,n+=`|{target:${qt(i)}\\S*},{${t}:`}else n+=`|function ${t}\\(`;return n}static getPolyfillData(){
return[["Array.prototype.fill","es6.array.fill"],["Array.prototype.filter","es6.array.filter"],["Array.prototype.find","es6.array.find"],["Array.prototype.findIndex","es6.array.find-index"],["Array.prototype.forEach","es6.array.for-each"],["Array.from","es6.array.from"],["Array.isArray","es6.array.is-array"],["Array.prototype.map","es6.array.map"],["Array.of","es6.array.of"],["Array.prototype.reduce","es6.array.reduce"],["Array.prototype.reduceRight","es6.array.reduce-right"],["Array.prototype.some","es6.array.some"],["Date.now","es6.date.now"],["Date.prototype.toISOString","es6.date.to-iso-string"],["Date.prototype.toJSON","es6.date.to-json"],["Date.prototype.toString","es6.date.to-string"],["Function.prototype.name","es6.function.name"],["Number.isInteger","es6.number.is-integer"],["Number.isSafeInteger","es6.number.is-safe-integer"],["Number.parseInt","es6.number.parse-int"],["Object.defineProperties","es6.object.define-properties"],["Object.defineProperty","es6.object.define-property"],["Object.freeze","es6.object.freeze"],["Object.getOwnPropertyNames","es6.object.get-own-property-names"],["Object.getPrototypeOf","es6.object.get-prototype-of"],["Object.isExtensible","es6.object.is-extensible"],["Object.isFrozen","es6.object.is-frozen"],["Object.isSealed","es6.object.is-sealed"],["Object.keys","es6.object.keys"],["Object.preventExtensions","es6.object.prevent-extensions"],["Object.seal","es6.object.seal"],["Object.setPrototypeOf","es6.object.set-prototype-of"],["Reflect.apply","es6.reflect.apply"],["Reflect.construct","es6.reflect.construct"],["Reflect.defineProperty","es6.reflect.define-property"],["Reflect.deleteProperty","es6.reflect.delete-property"],["Reflect.get","es6.reflect.get"],["Reflect.getOwnPropertyDescriptor","es6.reflect.get-own-property-descriptor"],["Reflect.getPrototypeOf","es6.reflect.get-prototype-of"],["Reflect.has","es6.reflect.has"],["Reflect.isExtensible","es6.reflect.is-extensible"],["Reflect.ownKeys","es6.reflect.own-keys"],["Reflect.preventExtensions","es6.reflect.prevent-extensions"],["Reflect.setPrototypeOf","es6.reflect.set-prototype-of"],["String.prototype.codePointAt","es6.string.code-point-at"],["String.fromCodePoint","es6.string.from-code-point"],["String.raw","es6.string.raw"],["String.prototype.repeat","es6.string.repeat"],["Array.prototype.includes","es7.array.includes"],["Object.entries","es7.object.entries"],["Object.getOwnPropertyDescriptors","es7.object.get-own-property-descriptors"],["Object.values","es7.object.values"]].map((e=>{
const[t,n]=e;return{name:t,coreJs2Module:n,coreJs3Module:n.replace("es6.","es.").replace("es7.","es.").replace("typed.","typed-array.")}}))}static getPolyfillPatterns(){return this.getPolyfillData().map((({name:e})=>{const t=e.split("."),n=t.length>1?t.slice(0,t.length-1).join("."):null,i=t[t.length-1];return{name:e,expression:this.buildPolyfillExpression(n,i)}}))}static getTransformPatterns(){return[{name:"@babel/plugin-transform-classes",expression:"Cannot call a class as a function",estimateBytes:e=>150+e.count*"_classCallCheck()".length},{name:"@babel/plugin-transform-regenerator",expression:/regeneratorRuntime\.a?wrap/.source,estimateBytes:e=>80*e.count},{name:"@babel/plugin-transform-spread",expression:/\.apply\(void 0,\s?_toConsumableArray/.source,estimateBytes:e=>1169+e.count*"_toConsumableArray()".length}]}static detectAcrossScripts(e,t,n,i){const a=new Map,s=this.getPolyfillData();for(const{requestId:l,content:c}of Object.values(t)){if(!c)continue
;const t=n.find((e=>e.requestId===l));if(!t)continue;const u=e.match(c),d=i.find((e=>e.script.src===t.url));if(d)for(const{coreJs2Module:e,coreJs3Module:t,name:n}of s){if(u.some((e=>e.name===n)))continue;const i=d.rawMap.sources.find((n=>n.endsWith(e+".js")||n.endsWith(t+".js")));if(!i)continue;const a=d.map.mappings().find((e=>e.sourceURL===i));a?u.push({name:n,line:a.lineNumber,column:a.columnNumber,count:1}):u.push({name:n,line:0,column:0,count:1})}u.length&&a.set(t.url,u)}return a}static estimateWastedBytes(t){const n=t.filter((e=>!e.name.startsWith("@"))),i=t.filter((e=>e.name.startsWith("@")));let a=0;const s=e("./polyfill-graph-data.json"),l=new Set;for(const e of n){const t=s.dependencies[e.name];if(t)for(const e of t)l.add(e)}n.length>0&&(a+=s.baseSize),a+=[...l].reduce(((e,t)=>e+s.moduleSizes[t]),0),a=Math.min(a,s.maxSize);let c=0;for(const e of i){const t=this.getTransformPatterns().find((t=>t.name===e.name));t&&t.estimateBytes&&(c+=t.estimateBytes(e))}return a+c}
static async estimateTransferRatioForScript(e,t,n,a){let s=e.get(t);if(void 0!==s)return s;const l=await c.findMainDocument(a),u=t===n.URL.finalUrl?l:a.find((e=>e.url===t)),d=n.ScriptElements.find((e=>e.src===t));if(d&&null!==d.content){const e=d.content.length;s=i.estimateTransferSize(u,e,"Script")/e}else s=1;return e.set(t,s),s}static async audit_(e,t,n){const i=l.getEntity(e.URL.finalUrl),c=await a.request(e,n),u=[],m=new CodePatternMatcher([...this.getPolyfillPatterns(),...this.getTransformPatterns()]),p=new Map,h=this.detectAcrossScripts(m,e.ScriptElements,t,c);for(const[n,i]of h.entries()){const a=await this.estimateTransferRatioForScript(p,n,e,t),s={url:n,wastedBytes:Math.round(this.estimateWastedBytes(i)*a),subItems:{type:"subitems",items:[]},totalBytes:0};for(const e of i){const{name:t,line:i,column:a}=e,l={signal:t,location:{type:"source-location",url:n,line:i,column:a,urlProvider:"network"}};s.subItems.items.push(l)}u.push(s)}const f=new Map
;for(const e of u)l.isFirstParty(e.url,i)&&f.set(e.url,e.wastedBytes);return{items:u,headings:[{key:"url",valueType:"url",subItemsHeading:{key:"location",valueType:"source-location"},label:d(s.UIStrings.columnURL)},{key:null,valueType:"code",subItemsHeading:{key:"signal"},label:""},{key:"wastedBytes",valueType:"bytes",label:d(s.UIStrings.columnWastedBytes)}],wastedBytesByUrl:f}}},t.exports.UIStrings=u}).call(this,"/lighthouse-core/audits/byte-efficiency/legacy-javascript.js")},{"../../computed/js-bundles.js":11,"../../lib/dependency-graph/simulator/network-analyzer.js":79,"../../lib/i18n/i18n.js":84,"../../lib/third-party-web.js":104,"./byte-efficiency-audit.js":4,"./polyfill-graph-data.json":5}],"../audits/byte-efficiency/offscreen-images":[function(e,t,n){(function(n){"use strict"
;const i=e("./byte-efficiency-audit.js"),a=e("../../lib/sentry.js"),s=e("../../lib/url-shim.js"),l=e("../../lib/i18n/i18n.js"),c=e("../../computed/metrics/interactive.js"),u=e("../../computed/trace-of-tab.js"),d={title:"Defer offscreen images",description:"Consider lazy-loading offscreen and hidden images after all critical resources have finished loading to lower time to interactive. [Learn more](https://web.dev/offscreen-images/)."},m=l.createMessageInstanceIdFn(n,d);class OffscreenImages extends i{static get meta(){return{id:"offscreen-images",title:m(d.title),description:m(d.description),scoreDisplayMode:i.SCORING_MODES.NUMERIC,requiredArtifacts:["ImageElements","ViewportDimensions","devtoolsLogs","traces"]}}static computeVisiblePixels(e,t){const n=t.innerWidth,i=t.innerHeight,a=3*t.innerHeight,s=Math.max(e.top,-100),l=Math.min(e.right,n+100),c=Math.min(e.bottom,i+a),u=Math.max(e.left,-100);return Math.max(l-u,0)*Math.max(c-s,0)}static computeWaste(e,t,n){
const i=n.find((t=>t.url===e.src));if(!i)return null;if("lazy"===e.loading||"eager"===e.loading)return null;const a=s.elideDataURI(e.src),l=e.displayedWidth*e.displayedHeight,c=this.computeVisiblePixels(e.clientRect,t),u=0===l?1:1-c/l,{resourceSize:d=0,transferSize:m=0}=i,p=Math.min(d,m),h=Math.round(p*u);return Number.isFinite(u)?{url:a,requestStartTime:i.startTime,totalBytes:p,wastedBytes:h,wastedPercent:100*u}:new Error("Invalid image sizing information "+a)}static filterLanternResults(e,t){const n=t.pessimisticEstimate.nodeTimings;let i=0;const a=new Map;for(const[e,t]of n)"cpu"===e.type&&t.duration>=50?i=Math.max(i,t.startTime):"network"===e.type&&a.set(e.record.url,t.startTime);return e.filter((e=>{if(e.wastedBytes<2048)return!1;if(e.wastedPercent<75)return!1;return(a.get(e.url)||0)<i-50}))}static filterObservedResults(e,t){return e.filter((e=>!(e.wastedBytes<2048)&&(!(e.wastedPercent<75)&&e.requestStartTime<t/1e6-.05)))}static computeWasteWithTTIGraph(e,t,n){
return super.computeWasteWithTTIGraph(e,t,n,{includeLoad:!1})}static async audit_(e,t,n){const s=e.ImageElements,d=e.ViewportDimensions,p=e.traces[i.DEFAULT_PASS],h=e.devtoolsLogs[i.DEFAULT_PASS],f=[],g=s.reduce(((e,n)=>{const i=OffscreenImages.computeWaste(n,d,t);if(null===i)return e;if(i instanceof Error)return f.push(i.message),a.captureException(i,{tags:{audit:this.meta.id},level:"warning"}),e;const s=e.get(i.url);return(!s||s.wastedBytes>i.wastedBytes)&&e.set(i.url,i),e}),new Map),y=n.settings;let b;const v=Array.from(g.values());try{const e=await c.request({trace:p,devtoolsLog:h,settings:y},n),t=e;b="simulate"===n.settings.throttlingMethod?OffscreenImages.filterLanternResults(v,t):OffscreenImages.filterObservedResults(v,e.timestamp)}catch(e){if("simulate"===n.settings.throttlingMethod)throw e;b=OffscreenImages.filterObservedResults(v,await u.request(p,n).then((e=>e.timestamps.traceEnd)))}const w=[{key:"url",valueType:"thumbnail",label:""},{key:"url",valueType:"url",
label:m(l.UIStrings.columnURL)},{key:"totalBytes",valueType:"bytes",label:m(l.UIStrings.columnResourceSize)},{key:"wastedBytes",valueType:"bytes",label:m(l.UIStrings.columnWastedBytes)}];return{warnings:f,items:b,headings:w}}}t.exports=OffscreenImages,t.exports.UIStrings=d}).call(this,"/lighthouse-core/audits/byte-efficiency/offscreen-images.js")},{"../../computed/metrics/interactive.js":22,"../../computed/trace-of-tab.js":47,"../../lib/i18n/i18n.js":84,"../../lib/sentry.js":99,"../../lib/url-shim.js":"url","./byte-efficiency-audit.js":4}],"../audits/byte-efficiency/render-blocking-resources":[function(e,t,n){(function(n){"use strict";const i=e("../audit.js"),a=e("../../lib/i18n/i18n.js"),s=e("../../lib/dependency-graph/base-node.js"),l=e("./byte-efficiency-audit.js"),c=e("../../computed/unused-css.js"),u=e("../../lib/network-request.js"),d=e("../../computed/trace-of-tab.js"),m=e("../../computed/load-simulator.js"),p=e("../../computed/metrics/first-contentful-paint.js"),h={
title:"Eliminate render-blocking resources",description:"Resources are blocking the first paint of your page. Consider delivering critical JS/CSS inline and deferring all non-critical JS/styles. [Learn more](https://web.dev/render-blocking-resources/)."},f=a.createMessageInstanceIdFn(n,h);function computeStackSpecificTiming(e,t,n){const i={...t};return n.some((e=>"amp"===e.id))&&e.type===s.TYPES.NETWORK&&e.record.resourceType===u.TYPES.Stylesheet&&t.endTime>2100&&(i.endTime=Math.max(t.startTime,2100),i.duration=i.endTime-i.startTime),i}class RenderBlockingResources extends i{static get meta(){return{id:"render-blocking-resources",title:f(h.title),scoreDisplayMode:i.SCORING_MODES.NUMERIC,description:f(h.description),requiredArtifacts:["URL","TagsBlockingFirstPaint","traces","devtoolsLogs","CSSUsage","Stacks"]}}static async computeResults(e,t){const n=e.traces[i.DEFAULT_PASS],a=e.devtoolsLogs[i.DEFAULT_PASS],s={devtoolsLog:a,settings:t.settings
},l=await d.request(n,t),c=await m.request(s,t),u=await RenderBlockingResources.computeWastedCSSBytes(e,t),h={trace:n,devtoolsLog:a,simulator:c,settings:{throttlingMethod:"simulate"}},f=await p.request(h,t),g=l.timestamps.firstContentfulPaint/1e3,y=function getNodesAndTimingByUrl(e){const t={};return Array.from(e.keys()).forEach((n=>{if("network"!==n.type)return;const i=e.get(n);i&&(t[n.record.url]={node:n,nodeTiming:i})})),t}(f.optimisticEstimate.nodeTimings),b=[],v=new Set;for(const t of e.TagsBlockingFirstPaint){if(1e3*t.endTime>g)continue;if(!y[t.tag.url])continue;const{node:n,nodeTiming:i}=y[t.tag.url],a=computeStackSpecificTiming(n,i,e.Stacks);n.traverse((e=>v.add(e.id)));const s=Math.round(a.duration);s<50||b.push({url:t.tag.url,totalBytes:t.transferSize,wastedMs:s})}if(!b.length)return{results:b,wastedMs:0};return{results:b,wastedMs:RenderBlockingResources.estimateSavingsWithGraphs(c,f.optimisticGraph,v,u,e.Stacks)}}static estimateSavingsWithGraphs(e,t,n,i,a){
const{nodeTimings:l}=e.simulate(t),c=new Map(l);let d=0;const m=t.cloneWithRelationships((e=>{!function adjustNodeTimings(e,t,n){const i=e.get(t);if(!i)return;const a=computeStackSpecificTiming(t,i,n);i.duration-a.duration&&(t.traverse((t=>{e.delete(t)})),e.set(t,a))}(c,e,a);const t=n.has(e.id);if(e.type!==s.TYPES.NETWORK)return!t;const l=e.record.resourceType===u.TYPES.Stylesheet;if(t&&l){const t=i.get(e.record.url)||0;d+=(e.record.transferSize||0)-t}return!t}));if("network"!==m.type)throw new Error("minimalFCPGraph not a NetworkNode");const p=Math.max(...Array.from(Array.from(c).map((e=>e[1].endTime)))),h=m.record.transferSize,f=h||0;m.record.transferSize=f+d;const g=e.simulate(m).timeInMs;return m.record.transferSize=h,Math.round(Math.max(p-g,0))}static async computeWastedCSSBytes(e,t){const n=new Map;try{const a=await c.request({CSSUsage:e.CSSUsage,URL:e.URL,devtoolsLog:e.devtoolsLogs[i.DEFAULT_PASS]},t);for(const e of a)n.set(e.url,e.wastedBytes)}catch(e){}return n}
static async audit(e,t){const{results:n,wastedMs:s}=await RenderBlockingResources.computeResults(e,t);let c;n.length>0&&(c=f(a.UIStrings.displayValueMsSavings,{wastedMs:s}));const u=[{key:"url",valueType:"url",label:f(a.UIStrings.columnURL)},{key:"totalBytes",valueType:"bytes",label:f(a.UIStrings.columnTransferSize)},{key:"wastedMs",valueType:"timespanMs",label:f(a.UIStrings.columnWastedMs)}],d=i.makeOpportunityDetails(u,n,s);return{displayValue:c,score:l.scoreForWastedMs(s),numericValue:s,numericUnit:"millisecond",details:d}}}t.exports=RenderBlockingResources,t.exports.UIStrings=h}).call(this,"/lighthouse-core/audits/byte-efficiency/render-blocking-resources.js")},{"../../computed/load-simulator.js":12,"../../computed/metrics/first-contentful-paint.js":19,"../../computed/trace-of-tab.js":47,"../../computed/unused-css.js":48,"../../lib/dependency-graph/base-node.js":74,"../../lib/i18n/i18n.js":84,"../../lib/network-request.js":96,"../audit.js":3,"./byte-efficiency-audit.js":4}],
"../audits/byte-efficiency/total-byte-weight":[function(e,t,n){(function(n){"use strict";const i=e("./byte-efficiency-audit.js"),a=e("../../lib/i18n/i18n.js"),s=e("../../computed/network-records.js"),l={title:"Avoids enormous network payloads",failureTitle:"Avoid enormous network payloads",description:"Large network payloads cost users real money and are highly correlated with long load times. [Learn more](https://web.dev/total-byte-weight/).",displayValue:"Total size was {totalBytes, number, bytes} KiB"},c=a.createMessageInstanceIdFn(n,l);t.exports=class TotalByteWeight extends i{static get meta(){return{id:"total-byte-weight",title:c(l.title),failureTitle:c(l.failureTitle),description:c(l.description),scoreDisplayMode:i.SCORING_MODES.NUMERIC,requiredArtifacts:["devtoolsLogs","traces"]}}static get defaultOptions(){return{p10:2731008,median:4096e3}}static async audit(e,t){const n=e.devtoolsLogs[i.DEFAULT_PASS],u=await s.request(n,t);let d=0,m=[];u.forEach((e=>{
if("data"===e.parsedURL.scheme||!e.finished)return;const t={url:e.url,totalBytes:e.transferSize};d+=t.totalBytes,m.push(t)})),m=m.sort(((e,t)=>t.totalBytes-e.totalBytes||e.url.localeCompare(t.url))).slice(0,10);const p=i.computeLogNormalScore({p10:t.options.p10,median:t.options.median},d),h=[{key:"url",itemType:"url",text:c(a.UIStrings.columnURL)},{key:"totalBytes",itemType:"bytes",text:c(a.UIStrings.columnTransferSize)}],f=i.makeTableDetails(h,m);return{score:p,numericValue:d,numericUnit:"byte",displayValue:c(l.displayValue,{totalBytes:d}),details:f}}},t.exports.UIStrings=l}).call(this,"/lighthouse-core/audits/byte-efficiency/total-byte-weight.js")},{"../../computed/network-records.js":42,"../../lib/i18n/i18n.js":84,"./byte-efficiency-audit.js":4}],"../audits/byte-efficiency/unminified-css":[function(e,t,n){(function(n){"use strict"
;const i=e("./byte-efficiency-audit.js"),a=e("../../computed/unused-css.js"),s=e("../../lib/i18n/i18n.js"),l=e("../../lib/minification-estimator.js").computeCSSTokenLength,c={title:"Minify CSS",description:"Minifying CSS files can reduce network payload sizes. [Learn more](https://web.dev/unminified-css/)."},u=s.createMessageInstanceIdFn(n,c);class UnminifiedCSS extends i{static get meta(){return{id:"unminified-css",title:u(c.title),description:u(c.description),scoreDisplayMode:i.SCORING_MODES.NUMERIC,requiredArtifacts:["CSSUsage","devtoolsLogs","traces","URL"]}}static computeTokenLength(e){return l(e)}static computeWaste(e,t,n){const s=e.content,l=UnminifiedCSS.computeTokenLength(s);let c=e.header.sourceURL;if(!c||c===n){c=a.determineContentPreview(e.content)}const u=i.estimateTransferSize(t,s.length,"Stylesheet"),d=1-l/s.length;return{url:c,totalBytes:u,wastedBytes:Math.round(u*d),wastedPercent:100*d}}static audit_(e,t){const n=e.URL.finalUrl,i=[]
;for(const a of e.CSSUsage.stylesheets){const e=t.find((e=>e.url===a.header.sourceURL));if(!a.content)continue;const s=UnminifiedCSS.computeWaste(a,e,n);s.wastedPercent<5||s.wastedBytes<2048||!Number.isFinite(s.wastedBytes)||i.push(s)}return{items:i,headings:[{key:"url",valueType:"url",label:u(s.UIStrings.columnURL)},{key:"totalBytes",valueType:"bytes",label:u(s.UIStrings.columnTransferSize)},{key:"wastedBytes",valueType:"bytes",label:u(s.UIStrings.columnWastedBytes)}]}}}t.exports=UnminifiedCSS,t.exports.UIStrings=c}).call(this,"/lighthouse-core/audits/byte-efficiency/unminified-css.js")},{"../../computed/unused-css.js":48,"../../lib/i18n/i18n.js":84,"../../lib/minification-estimator.js":94,"./byte-efficiency-audit.js":4}],"../audits/byte-efficiency/unminified-javascript":[function(e,t,n){(function(n){"use strict";const i=e("./byte-efficiency-audit.js"),a=e("../../lib/i18n/i18n.js"),s=e("../../lib/minification-estimator.js").computeJSTokenLength,l={title:"Minify JavaScript",
description:"Minifying JavaScript files can reduce payload sizes and script parse time. [Learn more](https://web.dev/unminified-javascript/)."},c=a.createMessageInstanceIdFn(n,l);class UnminifiedJavaScript extends i{static get meta(){return{id:"unminified-javascript",title:c(l.title),description:c(l.description),scoreDisplayMode:i.SCORING_MODES.NUMERIC,requiredArtifacts:["ScriptElements","devtoolsLogs","traces"]}}static computeWaste(e,t,n){const a=e.length,l=s(e),c=i.estimateTransferSize(n,a,"Script"),u=1-l/a;return{url:t,totalBytes:c,wastedBytes:Math.round(c*u),wastedPercent:100*u}}static audit_(e,t){const n=[],i=[];for(const{requestId:a,src:s,content:l}of e.ScriptElements){if(!l)continue;const e=t.find((e=>e.requestId===a)),c=s&&e?e.url:`inline: ${l.substr(0,40)}...`;try{const t=UnminifiedJavaScript.computeWaste(l,c,e);if(t.wastedPercent<10||t.wastedBytes<2048||!Number.isFinite(t.wastedBytes))continue;n.push(t)}catch(t){const n=e?e.url:"?"
;i.push(`Unable to process script ${n}: ${t.message}`)}}return{items:n,warnings:i,headings:[{key:"url",valueType:"url",label:c(a.UIStrings.columnURL)},{key:"totalBytes",valueType:"bytes",label:c(a.UIStrings.columnTransferSize)},{key:"wastedBytes",valueType:"bytes",label:c(a.UIStrings.columnWastedBytes)}]}}}t.exports=UnminifiedJavaScript,t.exports.UIStrings=l}).call(this,"/lighthouse-core/audits/byte-efficiency/unminified-javascript.js")},{"../../lib/i18n/i18n.js":84,"../../lib/minification-estimator.js":94,"./byte-efficiency-audit.js":4}],"../audits/byte-efficiency/unused-css-rules":[function(e,t,n){(function(n){"use strict";const i=e("./byte-efficiency-audit.js"),a=e("../../computed/unused-css.js"),s=e("../../lib/i18n/i18n.js"),l={title:"Remove unused CSS",description:"Remove dead rules from stylesheets and defer the loading of CSS not used for above-the-fold content to reduce unnecessary bytes consumed by network activity. [Learn more](https://web.dev/unused-css-rules/)."
},c=s.createMessageInstanceIdFn(n,l);t.exports=class UnusedCSSRules extends i{static get meta(){return{id:"unused-css-rules",title:c(l.title),description:c(l.description),scoreDisplayMode:i.SCORING_MODES.NUMERIC,requiredArtifacts:["CSSUsage","URL","devtoolsLogs","traces"]}}static async audit_(e,t,n){return{items:(await a.request({CSSUsage:e.CSSUsage,URL:e.URL,devtoolsLog:e.devtoolsLogs[i.DEFAULT_PASS]},n)).filter((e=>e&&e.wastedBytes>10240)),headings:[{key:"url",valueType:"url",label:c(s.UIStrings.columnURL)},{key:"totalBytes",valueType:"bytes",label:c(s.UIStrings.columnTransferSize)},{key:"wastedBytes",valueType:"bytes",label:c(s.UIStrings.columnWastedBytes)}]}}},t.exports.UIStrings=l}).call(this,"/lighthouse-core/audits/byte-efficiency/unused-css-rules.js")},{"../../computed/unused-css.js":48,"../../lib/i18n/i18n.js":84,"./byte-efficiency-audit.js":4}],"../audits/byte-efficiency/unused-javascript":[function(e,t,n){(function(n){"use strict"
;const i=e("./byte-efficiency-audit.js"),a=e("../../computed/unused-javascript-summary.js"),s=e("../../computed/js-bundles.js"),l=e("../../lib/i18n/i18n.js"),c={title:"Remove unused JavaScript",description:"Remove unused JavaScript to reduce bytes consumed by network activity. [Learn more](https://web.dev/unused-javascript/)."},u=l.createMessageInstanceIdFn(n,c),d=20480,m=512;function commonPrefix(e){if(!e.length)return"";const t=e.reduce(((e,t)=>e>t?e:t));let n=e.reduce(((e,t)=>e>t?t:e));for(;!t.startsWith(n);)n=n.slice(0,-1);return n}function trimCommonPrefix(e,t){return t&&e.startsWith(t)?"…"+e.slice(t.length):e}t.exports=class UnusedJavaScript extends i{static get meta(){return{id:"unused-javascript",title:u(c.title),description:u(c.description),scoreDisplayMode:i.SCORING_MODES.NUMERIC,requiredArtifacts:["JsUsage","ScriptElements","SourceMaps","devtoolsLogs","traces"]}}static async audit_(e,t,n){
const c=await s.request(e,n),{unusedThreshold:p=d,bundleSourceUnusedThreshold:h=m}=n.options||{},f=[];for(const[s,l]of Object.entries(e.JsUsage)){const e=t.find((e=>e.url===s));if(!e)continue;const u=c.find((e=>e.script.src===s)),d=await a.request({url:s,scriptCoverages:l,bundle:u},n),m=i.estimateTransferSize(e,d.totalBytes,"Script")/d.totalBytes,g={url:d.url,totalBytes:Math.round(m*d.totalBytes),wastedBytes:Math.round(m*d.wastedBytes),wastedPercent:d.wastedPercent};if(g.wastedBytes<=p)continue;if(f.push(g),!u||"errorMessage"in u.sizes)continue;const y=u.sizes;if(d.sourcesWastedBytes){const e=Object.entries(d.sourcesWastedBytes).sort(((e,t)=>t[1]-e[1])).slice(0,5).map((([e,t])=>{const n="(unmapped)"===e?y.unmappedBytes:y.files[e];return{source:e,unused:Math.round(t*m),total:Math.round(n*m)}})).filter((e=>e.unused>=h)),t=commonPrefix([...u.map._sourceInfos.keys()]);g.subItems={type:"subitems",items:e.map((({source:e,unused:n,total:i})=>({source:trimCommonPrefix(e,t),sourceBytes:i,
sourceWastedBytes:n})))}}}return{items:f,headings:[{key:"url",valueType:"url",subItemsHeading:{key:"source",valueType:"code"},label:u(l.UIStrings.columnURL)},{key:"totalBytes",valueType:"bytes",subItemsHeading:{key:"sourceBytes"},label:u(l.UIStrings.columnTransferSize)},{key:"wastedBytes",valueType:"bytes",subItemsHeading:{key:"sourceWastedBytes"},label:u(l.UIStrings.columnWastedBytes)}]}}},t.exports.UIStrings=c}).call(this,"/lighthouse-core/audits/byte-efficiency/unused-javascript.js")},{"../../computed/js-bundles.js":11,"../../computed/unused-javascript-summary.js":49,"../../lib/i18n/i18n.js":84,"./byte-efficiency-audit.js":4}],"../audits/byte-efficiency/uses-long-cache-ttl":[function(e,t,n){(function(n){"use strict";const i=e("parse-cache-control"),a=e("../audit.js"),s=e("../../lib/network-request.js"),l=e("../../lib/url-shim.js"),c=e("../../lib/statistics.js").linearInterpolation,u=e("../../lib/i18n/i18n.js"),d=e("../../computed/network-records.js"),m={
title:"Uses efficient cache policy on static assets",failureTitle:"Serve static assets with an efficient cache policy",description:"A long cache lifetime can speed up repeat visits to your page. [Learn more](https://web.dev/uses-long-cache-ttl/).",displayValue:"{itemCount, plural,\n    =1 {1 resource found}\n    other {# resources found}\n    }"},p=u.createMessageInstanceIdFn(n,m);class CacheHeaders extends a{static get meta(){return{id:"uses-long-cache-ttl",title:p(m.title),failureTitle:p(m.failureTitle),description:p(m.description),scoreDisplayMode:a.SCORING_MODES.NUMERIC,requiredArtifacts:["devtoolsLogs","traces"]}}static get defaultOptions(){return{p10:28672,median:131072}}static getCacheHitProbability(e){const t=[0,.2,1,3,8,12,24,48,72,168,8760,1/0];if(12!==t.length)throw new Error("deciles 0-10 and 1 for overflow");const n=e/3600,i=t.findIndex((e=>e>=n));if(i===t.length-1)return 1;if(0===i)return 0;const a=t[i],s=t[i-1];return c(s,(i-1)/10,a,i/10,n)}
static computeCacheLifetimeInSeconds(e,t){if(t&&void 0!==t["max-age"])return t["max-age"];const n=e.get("expires");if(n){const e=new Date(n).getTime();return e?Math.ceil((e-Date.now())/1e3):0}return null}static isCacheableAsset(e){const t=new Set([200,203,206]),n=new Set([s.TYPES.Font,s.TYPES.Image,s.TYPES.Media,s.TYPES.Script,s.TYPES.Stylesheet]);return!l.NON_NETWORK_PROTOCOLS.includes(e.protocol)&&(t.has(e.statusCode)&&n.has(e.resourceType||"Other"))}static shouldSkipRecord(e,t){return!(t||!(e.get("pragma")||"").includes("no-cache"))||!(!t||!(t["must-revalidate"]||t["no-cache"]||t["no-store"]||t.private))}static audit(e,t){const n=e.devtoolsLogs[a.DEFAULT_PASS];return d.request(n,t).then((e=>{const n=[];let s=0;for(const t of e){if(!CacheHeaders.isCacheableAsset(t))continue;const e=new Map;for(const n of t.responseHeaders||[])if(e.has(n.name.toLowerCase())){const t=e.get(n.name.toLowerCase());e.set(n.name.toLowerCase(),`${t}, ${n.value}`)}else e.set(n.name.toLowerCase(),n.value)
;const a=i(e.get("cache-control"));if(this.shouldSkipRecord(e,a))continue;let c=CacheHeaders.computeCacheLifetimeInSeconds(e,a);if(null!==c&&(!Number.isFinite(c)||c<=0))continue;c=c||0;const u=CacheHeaders.getCacheHitProbability(c);if(u>.925)continue;const d=l.elideDataURI(t.url),m=t.transferSize||0,p=(1-u)*m;let h;s+=p,a&&(h={type:"debugdata",...a}),n.push({url:d,debugData:h,cacheLifetimeMs:1e3*c,cacheHitProbability:u,totalBytes:m,wastedBytes:p})}n.sort(((e,t)=>e.cacheLifetimeMs-t.cacheLifetimeMs||t.totalBytes-e.totalBytes||e.url.localeCompare(t.url)));const c=a.computeLogNormalScore({p10:t.options.p10,median:t.options.median},s),d=[{key:"url",itemType:"url",text:p(u.UIStrings.columnURL)},{key:"cacheLifetimeMs",itemType:"ms",text:p(u.UIStrings.columnCacheTTL),displayUnit:"duration"},{key:"totalBytes",itemType:"bytes",text:p(u.UIStrings.columnTransferSize),displayUnit:"kb",granularity:1}],h={wastedBytes:s},f=a.makeTableDetails(d,n,h);return{score:c,numericValue:s,numericUnit:"byte",
displayValue:p(m.displayValue,{itemCount:n.length}),details:f}}))}}t.exports=CacheHeaders,t.exports.UIStrings=m}).call(this,"/lighthouse-core/audits/byte-efficiency/uses-long-cache-ttl.js")},{"../../computed/network-records.js":42,"../../lib/i18n/i18n.js":84,"../../lib/network-request.js":96,"../../lib/statistics.js":102,"../../lib/url-shim.js":"url","../audit.js":3,"parse-cache-control":187}],"../audits/byte-efficiency/uses-optimized-images":[function(e,t,n){(function(n){"use strict";const i=e("./byte-efficiency-audit.js"),a=e("../../lib/url-shim.js"),s=e("../../lib/i18n/i18n.js"),l={title:"Efficiently encode images",description:"Optimized images load faster and consume less cellular data. [Learn more](https://web.dev/uses-optimized-images/)."},c=s.createMessageInstanceIdFn(n,l);class UsesOptimizedImages extends i{static get meta(){return{id:"uses-optimized-images",title:c(l.title),description:c(l.description),scoreDisplayMode:i.SCORING_MODES.NUMERIC,
requiredArtifacts:["OptimizedImages","ImageElements","devtoolsLogs","traces","URL"]}}static computeSavings(e){const t=e.originalSize-e.jpegSize;return{bytes:t,percent:100*t/e.originalSize}}static estimateJPEGSizeFromDimensions(e){const t=e.naturalWidth*e.naturalHeight;return Math.round(t*(2/8))}static audit_(e){const t=e.URL.finalUrl,n=e.OptimizedImages,i=e.ImageElements,l=new Map;i.forEach((e=>l.set(e.src,e)));const u=[],d=[];for(const e of n){if(e.failed){d.push("Unable to decode "+a.getURLDisplayName(e.url));continue}if(!1===/(jpeg|bmp)/.test(e.mimeType))continue;let n=e.jpegSize,i=!0;if(void 0===n){const t=l.get(e.url);if(!t){d.push("Unable to locate resource "+a.getURLDisplayName(e.url));continue}const s=t.naturalHeight,c=t.naturalWidth;if(!s||!c)continue;n=UsesOptimizedImages.estimateJPEGSizeFromDimensions({naturalHeight:s,naturalWidth:c}),i=!1}if(e.originalSize<n+4096)continue;const s=a.elideDataURI(e.url),c=!a.originsMatch(t,e.url),m=UsesOptimizedImages.computeSavings({...e,
jpegSize:n});u.push({url:s,fromProtocol:i,isCrossOrigin:c,totalBytes:e.originalSize,wastedBytes:m.bytes})}return{warnings:d,items:u,headings:[{key:"url",valueType:"thumbnail",label:""},{key:"url",valueType:"url",label:c(s.UIStrings.columnURL)},{key:"totalBytes",valueType:"bytes",label:c(s.UIStrings.columnResourceSize)},{key:"wastedBytes",valueType:"bytes",label:c(s.UIStrings.columnWastedBytes)}]}}}t.exports=UsesOptimizedImages,t.exports.UIStrings=l}).call(this,"/lighthouse-core/audits/byte-efficiency/uses-optimized-images.js")},{"../../lib/i18n/i18n.js":84,"../../lib/url-shim.js":"url","./byte-efficiency-audit.js":4}],"../audits/byte-efficiency/uses-responsive-images":[function(e,t,n){(function(n){"use strict";const i=e("./byte-efficiency-audit.js"),a=e("../../lib/url-shim.js"),s=e("../../lib/i18n/i18n.js"),l={title:"Properly size images",
description:"Serve images that are appropriately-sized to save cellular data and improve load time. [Learn more](https://web.dev/uses-responsive-images/)."},c=s.createMessageInstanceIdFn(n,l);class UsesResponsiveImages extends i{static get meta(){return{id:"uses-responsive-images",title:c(l.title),description:c(l.description),scoreDisplayMode:i.SCORING_MODES.NUMERIC,requiredArtifacts:["ImageElements","ViewportDimensions","devtoolsLogs","traces"]}}static computeWaste(e,t,n){const i=n.find((t=>t.url===e.src));if(!i)return null;let s=e.displayedWidth*e.displayedHeight*Math.pow(t.devicePixelRatio,2);if(!s){const n=t.innerWidth,i=2*t.innerHeight,a=e.naturalWidth/e.naturalHeight;let l=n,c=i;a>n/i?c=n/a:l=i*a,s=l*c*Math.pow(t.devicePixelRatio,2)}const l=a.elideDataURI(e.src),c=1-s/(e.naturalWidth*e.naturalHeight),{resourceSize:u=0,transferSize:d=0}=i,m=Math.min(u,d);return{url:l,totalBytes:m,wastedBytes:Math.round(m*c),wastedPercent:100*c}}static audit_(e,t){
const n=e.ImageElements,i=e.ViewportDimensions,a=new Map;for(const e of n){if("image/svg+xml"===e.mimeType||e.isCss)continue;const n=e.naturalHeight,s=e.naturalWidth;if(!s||!n)continue;const l=UsesResponsiveImages.computeWaste({...e,naturalHeight:n,naturalWidth:s},i,t);if(!l)continue;const c=a.get(l.url);(!c||c.wastedBytes>l.wastedBytes)&&a.set(l.url,l)}return{items:Array.from(a.values()).filter((e=>e.wastedBytes>4096)),headings:[{key:"url",valueType:"thumbnail",label:""},{key:"url",valueType:"url",label:c(s.UIStrings.columnURL)},{key:"totalBytes",valueType:"bytes",label:c(s.UIStrings.columnResourceSize)},{key:"wastedBytes",valueType:"bytes",label:c(s.UIStrings.columnWastedBytes)}]}}}t.exports=UsesResponsiveImages,t.exports.UIStrings=l}).call(this,"/lighthouse-core/audits/byte-efficiency/uses-responsive-images.js")},{"../../lib/i18n/i18n.js":84,"../../lib/url-shim.js":"url","./byte-efficiency-audit.js":4}],"../audits/byte-efficiency/uses-text-compression":[function(e,t,n){(function(n){
"use strict";const i=e("./byte-efficiency-audit.js"),a=e("../../lib/url-shim.js"),s=e("../../lib/i18n/i18n.js"),l={title:"Enable text compression",description:"Text-based resources should be served with compression (gzip, deflate or brotli) to minimize total network bytes. [Learn more](https://web.dev/uses-text-compression/)."},c=s.createMessageInstanceIdFn(n,l);t.exports=class ResponsesAreCompressed extends i{static get meta(){return{id:"uses-text-compression",title:c(l.title),description:c(l.description),scoreDisplayMode:i.SCORING_MODES.NUMERIC,requiredArtifacts:["ResponseCompression","devtoolsLogs","traces"]}}static audit_(e){const t=e.ResponseCompression,n=[];t.forEach((e=>{if(!e.gzipSize||e.gzipSize<0)return;const t=e.resourceSize,i=e.gzipSize,s=t-i;if(1-i/t<.1||s<1400||e.transferSize<i)return;const l=a.elideDataURI(e.url);n.find((t=>t.url===l&&t.totalBytes===e.resourceSize))||n.push({url:l,totalBytes:t,wastedBytes:s})}));const i=[{key:"url",valueType:"url",
label:c(s.UIStrings.columnURL)},{key:"totalBytes",valueType:"bytes",label:c(s.UIStrings.columnTransferSize)},{key:"wastedBytes",valueType:"bytes",label:c(s.UIStrings.columnWastedBytes)}];return{items:n,headings:i}}},t.exports.UIStrings=l}).call(this,"/lighthouse-core/audits/byte-efficiency/uses-text-compression.js")},{"../../lib/i18n/i18n.js":84,"../../lib/url-shim.js":"url","./byte-efficiency-audit.js":4}],"../audits/byte-efficiency/uses-webp-images":[function(e,t,n){(function(n){"use strict";const i=e("./byte-efficiency-audit.js"),a=e("../../lib/url-shim.js"),s=e("../../lib/i18n/i18n.js"),l={title:"Serve images in next-gen formats",description:"Image formats like JPEG 2000, JPEG XR, and WebP often provide better compression than PNG or JPEG, which means faster downloads and less data consumption. [Learn more](https://web.dev/uses-webp-images/)."},c=s.createMessageInstanceIdFn(n,l);class UsesWebPImages extends i{static get meta(){return{id:"uses-webp-images",title:c(l.title),
description:c(l.description),scoreDisplayMode:i.SCORING_MODES.NUMERIC,requiredArtifacts:["OptimizedImages","devtoolsLogs","traces","URL","ImageElements"]}}static computeSavings(e){const t=e.originalSize-e.webpSize;return{bytes:t,percent:100*t/e.originalSize}}static estimateWebPSizeFromDimensions(e){const t=e.naturalWidth*e.naturalHeight;return Math.round(.2*t)}static audit_(e){const t=e.URL.finalUrl,n=e.OptimizedImages,i=e.ImageElements,l=new Map;i.forEach((e=>l.set(e.src,e)));const u=[],d=[];for(const e of n){if(e.failed){d.push("Unable to decode "+a.getURLDisplayName(e.url));continue}let n=e.webpSize,i=!0;if(void 0===n){const t=l.get(e.url);if(!t){d.push("Unable to locate resource "+a.getURLDisplayName(e.url));continue}const s=t.naturalHeight,c=t.naturalWidth;if(!c||!s)continue;n=UsesWebPImages.estimateWebPSizeFromDimensions({naturalHeight:s,naturalWidth:c}),i=!1}if(e.originalSize<n+8192)continue
;const s=a.elideDataURI(e.url),c=!a.originsMatch(t,e.url),m=UsesWebPImages.computeSavings({...e,webpSize:n});u.push({url:s,fromProtocol:i,isCrossOrigin:c,totalBytes:e.originalSize,wastedBytes:m.bytes})}return{warnings:d,items:u,headings:[{key:"url",valueType:"thumbnail",label:""},{key:"url",valueType:"url",label:c(s.UIStrings.columnURL)},{key:"totalBytes",valueType:"bytes",label:c(s.UIStrings.columnResourceSize)},{key:"wastedBytes",valueType:"bytes",label:c(s.UIStrings.columnWastedBytes)}]}}}t.exports=UsesWebPImages,t.exports.UIStrings=l}).call(this,"/lighthouse-core/audits/byte-efficiency/uses-webp-images.js")},{"../../lib/i18n/i18n.js":84,"../../lib/url-shim.js":"url","./byte-efficiency-audit.js":4}],"../audits/content-width":[function(e,t,n){(function(n){"use strict";const i=e("./audit.js"),a=e("../lib/i18n/i18n.js"),s={title:"Content is sized correctly for the viewport",failureTitle:"Content is not sized correctly for the viewport",
description:"If the width of your app's content doesn't match the width of the viewport, your app might not be optimized for mobile screens. [Learn more](https://web.dev/content-width/).",explanation:"The viewport size of {innerWidth}px does not match the window size of {outerWidth}px."},l=a.createMessageInstanceIdFn(n,s);t.exports=class ContentWidth extends i{static get meta(){return{id:"content-width",title:l(s.title),failureTitle:l(s.failureTitle),description:l(s.description),requiredArtifacts:["ViewportDimensions"]}}static audit(e,t){const n=e.ViewportDimensions.innerWidth===e.ViewportDimensions.outerWidth;if("desktop"===t.settings.formFactor)return{score:1,notApplicable:!0};let i;return n||(i=l(s.explanation,{innerWidth:e.ViewportDimensions.innerWidth,outerWidth:e.ViewportDimensions.outerWidth})),{score:Number(n),explanation:i}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/content-width.js")},{"../lib/i18n/i18n.js":84,"./audit.js":3}],
"../audits/critical-request-chains":[function(e,t,n){(function(n){"use strict";const i=e("./audit.js"),a=e("../lib/i18n/i18n.js"),s=e("../computed/critical-request-chains.js"),l={title:"Avoid chaining critical requests",description:"The Critical Request Chains below show you what resources are loaded with a high priority. Consider reducing the length of chains, reducing the download size of resources, or deferring the download of unnecessary resources to improve page load. [Learn more](https://web.dev/critical-request-chains/).",displayValue:"{itemCount, plural,\n    =1 {1 chain found}\n    other {# chains found}\n    }"},c=a.createMessageInstanceIdFn(n,l);class CriticalRequestChains extends i{static get meta(){return{id:"critical-request-chains",title:c(l.title),description:c(l.description),scoreDisplayMode:i.SCORING_MODES.INFORMATIVE,requiredArtifacts:["traces","devtoolsLogs","URL"]}}static _traverse(e,t){!function walk(e,n,i,a=0){const s=Object.keys(e);0!==s.length&&s.forEach((s=>{
const l=e[s];i||(i=l.request.startTime),t({depth:n,id:s,node:l,chainDuration:1e3*(l.request.endTime-i),chainTransferSize:a+l.request.transferSize}),l.children&&walk(l.children,n+1,i)}),"")}(e,0)}static _getLongestChain(e){const t={duration:0,length:0,transferSize:0};return CriticalRequestChains._traverse(e,(e=>{const n=e.chainDuration;n>t.duration&&(t.duration=n,t.transferSize=e.chainTransferSize,t.length=e.depth)})),t.length++,t}static flattenRequests(e){const t={},n=new Map;return CriticalRequestChains._traverse(e,(function flatten(e){const i=e.node.request,a={url:i.url,startTime:i.startTime,endTime:i.endTime,responseReceivedTime:i.responseReceivedTime,transferSize:i.transferSize};let s=n.get(e.id);if(s?s.request=a:(s={request:a},t[e.id]=s),e.node.children)for(const t of Object.keys(e.node.children)){const e={request:{}};n.set(t,e),s.children||(s.children={}),s.children[t]=e}n.set(e.id,s)})),t}static audit(e,t){const n=e.traces[i.DEFAULT_PASS],a=e.devtoolsLogs[i.DEFAULT_PASS],u=e.URL
;return s.request({devtoolsLog:a,trace:n,URL:u},t).then((e=>{let t=0;const n=CriticalRequestChains.flattenRequests(e),i=Object.keys(n)[0],a=i&&n[i].children;a&&Object.keys(a).length>0&&function walk(e,n){Object.keys(e).forEach((i=>{const a=e[i];a.children?walk(a.children,n+1):t++}),"")}(a,0);const s=CriticalRequestChains._getLongestChain(n);return{score:Number(0===t),notApplicable:0===t,displayValue:t?c(l.displayValue,{itemCount:t}):"",details:{type:"criticalrequestchain",chains:n,longestChain:s}}}))}}t.exports=CriticalRequestChains,t.exports.UIStrings=l}).call(this,"/lighthouse-core/audits/critical-request-chains.js")},{"../computed/critical-request-chains.js":10,"../lib/i18n/i18n.js":84,"./audit.js":3}],"../audits/deprecations":[function(e,t,n){(function(n){"use strict";const i=e("./audit.js"),a=e("../lib/i18n/i18n.js"),s={title:"Avoids deprecated APIs",failureTitle:"Uses deprecated APIs",
description:"Deprecated APIs will eventually be removed from the browser. [Learn more](https://web.dev/deprecations/).",displayValue:"{itemCount, plural,\n    =1 {1 warning found}\n    other {# warnings found}\n    }",columnDeprecate:"Deprecation / Warning",columnLine:"Line"},l=a.createMessageInstanceIdFn(n,s);t.exports=class Deprecations extends i{static get meta(){return{id:"deprecations",title:l(s.title),failureTitle:l(s.failureTitle),description:l(s.description),requiredArtifacts:["ConsoleMessages"]}}static audit(e){const t=e.ConsoleMessages.filter((e=>"deprecation"===e.source)).map((e=>{let t;if(e.url){const n=e.stackTrace&&e.stackTrace.callFrames[0],i=e.lineNumber||0,a=n?n.columnNumber:0;t={type:"source-location",url:e.url,urlProvider:"network",line:i,column:a}}return{value:e.text,source:t}})),n=[{key:"value",itemType:"text",text:l(s.columnDeprecate)},{key:"source",itemType:"source-location",text:l(a.UIStrings.columnURL)}],c=i.makeTableDetails(n,t);let u
;return t.length>0&&(u=l(s.displayValue,{itemCount:t.length})),{score:Number(0===t.length),displayValue:u,details:c}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/deprecations.js")},{"../lib/i18n/i18n.js":84,"./audit.js":3}],"../audits/diagnostics":[function(e,t,n){"use strict";const i=e("./audit.js"),a=e("../computed/main-thread-tasks.js"),s=e("../computed/network-records.js"),l=e("../computed/network-analysis.js"),c=e("../lib/dependency-graph/simulator/network-analyzer.js");t.exports=class Diagnostics extends i{static get meta(){return{id:"diagnostics",scoreDisplayMode:i.SCORING_MODES.INFORMATIVE,title:"Diagnostics",description:"Collection of useful page vitals.",requiredArtifacts:["traces","devtoolsLogs"]}}static async audit(e,t){
const n=e.traces[i.DEFAULT_PASS],u=e.devtoolsLogs[i.DEFAULT_PASS],d=await a.request(n,t),m=await s.request(u,t),p=await l.request(u,t),h=d.filter((e=>!e.parent)),f=c.findMainDocument(m).transferSize,g=m.reduce(((e,t)=>e+(t.transferSize||0)),0),y=h.reduce(((e,t)=>e+(t.duration||0)),0),b=Math.max(...p.additionalRttByOrigin.values())+p.rtt,v=Math.max(...p.serverResponseTimeByOrigin.values());return{score:1,details:{type:"debugdata",items:[{numRequests:m.length,numScripts:m.filter((e=>"Script"===e.resourceType)).length,numStylesheets:m.filter((e=>"Stylesheet"===e.resourceType)).length,numFonts:m.filter((e=>"Font"===e.resourceType)).length,numTasks:h.length,numTasksOver10ms:h.filter((e=>e.duration>10)).length,numTasksOver25ms:h.filter((e=>e.duration>25)).length,numTasksOver50ms:h.filter((e=>e.duration>50)).length,numTasksOver100ms:h.filter((e=>e.duration>100)).length,numTasksOver500ms:h.filter((e=>e.duration>500)).length,rtt:p.rtt,throughput:p.throughput,maxRtt:b,maxServerLatency:v,
totalByteWeight:g,totalTaskTime:y,mainDocumentTransferSize:f}]}}}}},{"../computed/main-thread-tasks.js":14,"../computed/network-analysis.js":41,"../computed/network-records.js":42,"../lib/dependency-graph/simulator/network-analyzer.js":79,"./audit.js":3}],"../audits/dobetterweb/appcache-manifest":[function(e,t,n){(function(n){"use strict";const i=e("../audit.js"),a=e("../../lib/i18n/i18n.js"),s={title:"Avoids Application Cache",failureTitle:"Uses Application Cache",description:"Application Cache is deprecated. [Learn more](https://web.dev/appcache-manifest/).",displayValue:'Found "{AppCacheManifest}"'},l=a.createMessageInstanceIdFn(n,s);t.exports=class AppCacheManifestAttr extends i{static get meta(){return{id:"appcache-manifest",title:l(s.title),failureTitle:l(s.failureTitle),description:l(s.description),requiredArtifacts:["AppCacheManifest"]}}static audit(e){return null!==e.AppCacheManifest?{score:0,displayValue:l(s.displayValue,{AppCacheManifest:e.AppCacheManifest})}:{score:1}}},
t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/dobetterweb/appcache-manifest.js")},{"../../lib/i18n/i18n.js":84,"../audit.js":3}],"../audits/dobetterweb/charset":[function(e,t,n){(function(n){"use strict";const i=e("../audit.js"),a=e("../../lib/i18n/i18n.js"),s=e("../../computed/main-resource.js"),l={title:"Properly defines charset",failureTitle:"Charset declaration is missing or occurs too late in the HTML",description:"A character encoding declaration is required. It can be done with a `<meta>` tag in the first 1024 bytes of the HTML or in the Content-Type HTTP response header. [Learn more](https://web.dev/charset/)."},c=a.createMessageInstanceIdFn(n,l),u=/^[a-zA-Z0-9-_:.()]{2,}$/,d=/<meta[^>]+charset[^<]+>/i,m=/charset\s*=\s*[a-zA-Z0-9-_:.()]{2,}/i;t.exports=class CharsetDefined extends i{static get meta(){return{id:"charset",title:c(l.title),failureTitle:c(l.failureTitle),description:c(l.description),
requiredArtifacts:["MainDocumentContent","URL","devtoolsLogs","MetaElements"]}}static async audit(e,t){const n=e.devtoolsLogs[i.DEFAULT_PASS],a=await s.request({devtoolsLog:n,URL:e.URL},t);let l=!1;if(a.responseHeaders){const e=a.responseHeaders.find((e=>"content-type"===e.name.toLowerCase()));e&&(l=m.test(e.value))}return l=l||65279===e.MainDocumentContent.charCodeAt(0),d.test(e.MainDocumentContent.slice(0,1024))&&(l=l||e.MetaElements.some((e=>e.charset&&u.test(e.charset)||"content-type"===e.httpEquiv&&e.content&&m.test(e.content)))),{score:Number(l)}}},t.exports.UIStrings=l,t.exports.CHARSET_HTML_REGEX=d,t.exports.CHARSET_HTTP_REGEX=m,t.exports.IANA_REGEX=u}).call(this,"/lighthouse-core/audits/dobetterweb/charset.js")},{"../../computed/main-resource.js":13,"../../lib/i18n/i18n.js":84,"../audit.js":3}],"../audits/dobetterweb/doctype":[function(e,t,n){(function(n){"use strict";const i=e("../audit.js"),a=e("../../lib/i18n/i18n.js"),s={title:"Page has the HTML doctype",
failureTitle:"Page lacks the HTML doctype, thus triggering quirks-mode",description:"Specifying a doctype prevents the browser from switching to quirks-mode. [Learn more](https://web.dev/doctype/).",explanationNoDoctype:"Document must contain a doctype",explanationPublicId:"Expected publicId to be an empty string",explanationSystemId:"Expected systemId to be an empty string",explanationBadDoctype:"Doctype name must be the lowercase string `html`"},l=a.createMessageInstanceIdFn(n,s);t.exports=class Doctype extends i{static get meta(){return{id:"doctype",title:l(s.title),failureTitle:l(s.failureTitle),description:l(s.description),requiredArtifacts:["Doctype"]}}static audit(e){if(!e.Doctype)return{score:0,explanation:l(s.explanationNoDoctype)};const t=e.Doctype.name.trim(),n=e.Doctype.publicId,i=e.Doctype.systemId;return""!==n?{score:0,explanation:l(s.explanationPublicId)}:""!==i?{score:0,explanation:l(s.explanationSystemId)}:"html"===t?{score:1}:{score:0,
explanation:l(s.explanationBadDoctype)}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/dobetterweb/doctype.js")},{"../../lib/i18n/i18n.js":84,"../audit.js":3}],"../audits/dobetterweb/dom-size":[function(e,t,n){(function(n){"use strict";const i=e("../audit.js"),a=e("../../lib/i18n/i18n.js"),s={title:"Avoids an excessive DOM size",failureTitle:"Avoid an excessive DOM size",description:"A large DOM will increase memory usage, cause longer [style calculations](https://developers.google.com/web/fundamentals/performance/rendering/reduce-the-scope-and-complexity-of-style-calculations), and produce costly [layout reflows](https://developers.google.com/speed/articles/reflow). [Learn more](https://web.dev/dom-size/).",columnStatistic:"Statistic",columnValue:"Value",displayValue:"{itemCount, plural,\n    =1 {1 element}\n    other {# elements}\n    }",statisticDOMElements:"Total DOM Elements",statisticDOMDepth:"Maximum DOM Depth",statisticDOMWidth:"Maximum Child Elements"
},l=a.createMessageInstanceIdFn(n,s);t.exports=class DOMSize extends i{static get meta(){return{id:"dom-size",title:l(s.title),failureTitle:l(s.failureTitle),description:l(s.description),scoreDisplayMode:i.SCORING_MODES.NUMERIC,requiredArtifacts:["DOMStats"]}}static get defaultOptions(){return{p10:818,median:1400}}static audit(e,t){const n=e.DOMStats,c=i.computeLogNormalScore({p10:t.options.p10,median:t.options.median},n.totalBodyElements),u=[{key:"statistic",itemType:"text",text:l(s.columnStatistic)},{key:"node",itemType:"node",text:l(a.UIStrings.columnElement)},{key:"value",itemType:"numeric",text:l(s.columnValue)}],d=[{statistic:l(s.statisticDOMElements),value:n.totalBodyElements},{node:{type:"node",path:n.depth.devtoolsNodePath,snippet:n.depth.snippet,selector:n.depth.selector,nodeLabel:n.depth.nodeLabel},statistic:l(s.statisticDOMDepth),value:n.depth.max},{node:{type:"node",path:n.width.devtoolsNodePath,snippet:n.width.snippet,selector:n.width.selector,nodeLabel:n.width.nodeLabel
},statistic:l(s.statisticDOMWidth),value:n.width.max}];return{score:c,numericValue:n.totalBodyElements,numericUnit:"element",displayValue:l(s.displayValue,{itemCount:n.totalBodyElements}),details:i.makeTableDetails(u,d)}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/dobetterweb/dom-size.js")},{"../../lib/i18n/i18n.js":84,"../audit.js":3}],"../audits/dobetterweb/external-anchors-use-rel-noopener":[function(e,t,n){(function(n){"use strict";const i=e("../../lib/url-shim.js"),a=e("../audit.js"),s=e("../../lib/i18n/i18n.js"),l={title:"Links to cross-origin destinations are safe",failureTitle:"Links to cross-origin destinations are unsafe",description:'Add `rel="noopener"` or `rel="noreferrer"` to any external links to improve performance and prevent security vulnerabilities. [Learn more](https://web.dev/external-anchors-use-rel-noopener/).',warning:"Unable to determine the destination for anchor ({anchorHTML}). If not used as a hyperlink, consider removing target=_blank.",
columnFailingAnchors:"Failing Anchors"},c=s.createMessageInstanceIdFn(n,l);t.exports=class ExternalAnchorsUseRelNoopenerAudit extends a{static get meta(){return{id:"external-anchors-use-rel-noopener",title:c(l.title),failureTitle:c(l.failureTitle),description:c(l.description),requiredArtifacts:["URL","AnchorElements"]}}static audit(e){const t=[],n=new i(e.URL.finalUrl).host,s=e.AnchorElements.filter((e=>"_blank"===e.target&&!e.rel.includes("noopener")&&!e.rel.includes("noreferrer"))).filter((e=>{try{return new i(e.href).host!==n}catch(n){return t.push(c(l.warning,{anchorHTML:e.node.snippet})),!0}})).filter((e=>!e.href||e.href.toLowerCase().startsWith("http"))).map((e=>({node:{type:"node",path:e.node.devtoolsNodePath||"",selector:e.node.selector||"",nodeLabel:e.node.nodeLabel||"",snippet:e.node.snippet||""},href:e.href||"Unknown",target:e.target||"",rel:e.rel||"",outerHTML:e.node.snippet||""}))),u=[{key:"node",itemType:"node",text:c(l.columnFailingAnchors)}],d=a.makeTableDetails(u,s)
;return{score:Number(0===s.length),details:d,warnings:t}}},t.exports.UIStrings=l}).call(this,"/lighthouse-core/audits/dobetterweb/external-anchors-use-rel-noopener.js")},{"../../lib/i18n/i18n.js":84,"../../lib/url-shim.js":"url","../audit.js":3}],"../audits/dobetterweb/geolocation-on-start":[function(e,t,n){(function(n){"use strict";const i=e("../violation-audit.js"),a=e("../../lib/i18n/i18n.js"),s={title:"Avoids requesting the geolocation permission on page load",failureTitle:"Requests the geolocation permission on page load",description:"Users are mistrustful of or confused by sites that request their location without context. Consider tying the request to a user action instead. [Learn more](https://web.dev/geolocation-on-start/)."},l=a.createMessageInstanceIdFn(n,s);t.exports=class GeolocationOnStart extends i{static get meta(){return{id:"geolocation-on-start",title:l(s.title),failureTitle:l(s.failureTitle),description:l(s.description),requiredArtifacts:["ConsoleMessages"]}}
static audit(e){const t=i.getViolationResults(e,/geolocation/),n=[{key:"url",itemType:"url",text:l(a.UIStrings.columnURL)},{key:"label",itemType:"text",text:l(a.UIStrings.columnLocation)}],s=i.makeTableDetails(n,t);return{score:Number(0===t.length),details:s}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/dobetterweb/geolocation-on-start.js")},{"../../lib/i18n/i18n.js":84,"../violation-audit.js":8}],"../audits/dobetterweb/inspector-issues":[function(e,t,n){(function(n){"use strict";const i=e("../audit.js"),a=e("../../lib/i18n/i18n.js"),s={title:"No issues in the `Issues` panel in Chrome Devtools",failureTitle:"Issues were logged in the `Issues` panel in Chrome Devtools",description:"Issues logged to the `Issues` panel in Chrome Devtools indicate unresolved problems. They can come from network request failures, insufficient security controls, and other browser concerns. Open up the Issues panel in Chrome DevTools for more details on each issue.",
columnIssueType:"Issue type",issueTypeBlockedByResponse:"Blocked by cross-origin policy",issueTypeHeavyAds:"Heavy resource usage by ads"},l=a.createMessageInstanceIdFn(n,s);t.exports=class IssuesPanelEntries extends i{static get meta(){return{id:"inspector-issues",title:l(s.title),failureTitle:l(s.failureTitle),description:l(s.description),requiredArtifacts:["InspectorIssues"]}}static getMixedContentRow(e){const t=new Set;for(const n of e){const e=n.request&&n.request.url||n.mainResourceURL;t.add(e)}return{issueType:"Mixed content",subItems:{type:"subitems",items:Array.from(t).map((e=>({url:e})))}}}static getSameSiteCookieRow(e){const t=new Set;for(const n of e){const e=n.request&&n.request.url||n.cookieUrl;e&&t.add(e)}return{issueType:"SameSite cookie",subItems:{type:"subitems",items:Array.from(t).map((e=>({url:e})))}}}static getBlockedByResponseRow(e){const t=new Set;for(const n of e){const e=n.request&&n.request.url;e&&t.add(e)}return{issueType:l(s.issueTypeBlockedByResponse),
subItems:{type:"subitems",items:Array.from(t).map((e=>({url:e})))}}}static getContentSecurityPolicyRow(e){const t=new Set;for(const n of e){const e=n.blockedURL;e&&t.add(e)}return{issueType:"Content security policy",subItems:{type:"subitems",items:Array.from(t).map((e=>({url:e})))}}}static audit(e){const t=[{key:"issueType",itemType:"text",subItemsHeading:{key:"url",itemType:"url"},text:l(s.columnIssueType)}],n=e.InspectorIssues,a=[];n.mixedContent.length&&a.push(this.getMixedContentRow(n.mixedContent)),n.sameSiteCookies.length&&a.push(this.getSameSiteCookieRow(n.sameSiteCookies)),n.blockedByResponse.length&&a.push(this.getBlockedByResponseRow(n.blockedByResponse)),n.heavyAds.length&&a.push({issueType:l(s.issueTypeHeavyAds)});const c=n.contentSecurityPolicy.filter((e=>"kTrustedTypesSinkViolation"!==e.contentSecurityPolicyViolationType&&"kTrustedTypesPolicyViolation"!==e.contentSecurityPolicyViolationType));return c.length&&a.push(this.getContentSecurityPolicyRow(c)),{
score:a.length>0?0:1,details:i.makeTableDetails(t,a)}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/dobetterweb/inspector-issues.js")},{"../../lib/i18n/i18n.js":84,"../audit.js":3}],"../audits/dobetterweb/js-libraries":[function(e,t,n){(function(n){"use strict";const i=e("../audit.js"),a=e("../../lib/i18n/i18n.js"),s={title:"Detected JavaScript libraries",description:"All front-end JavaScript libraries detected on the page. [Learn more](https://web.dev/js-libraries/).",columnVersion:"Version"},l=a.createMessageInstanceIdFn(n,s);t.exports=class JsLibrariesAudit extends i{static get meta(){return{id:"js-libraries",title:l(s.title),description:l(s.description),requiredArtifacts:["Stacks"]}}static audit(e){const t=e.Stacks.filter((e=>"js"===e.detector)).filter((e=>!e.id.endsWith("-fast"))).map((e=>({name:e.name,version:e.version,npm:e.npm}))),n=[{key:"name",itemType:"text",text:l(a.UIStrings.columnName)},{key:"version",itemType:"text",text:l(s.columnVersion)}];return{
score:1,details:{...i.makeTableDetails(n,t,{}),debugData:{type:"debugdata",stacks:e.Stacks.map((e=>({id:e.id,version:e.version})))}}}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/dobetterweb/js-libraries.js")},{"../../lib/i18n/i18n.js":84,"../audit.js":3}],"../audits/dobetterweb/no-document-write":[function(e,t,n){(function(n){"use strict";const i=e("../violation-audit.js"),a=e("../../lib/i18n/i18n.js"),s={title:"Avoids `document.write()`",failureTitle:"Avoid `document.write()`",description:"For users on slow connections, external scripts dynamically injected via `document.write()` can delay page load by tens of seconds. [Learn more](https://web.dev/no-document-write/)."},l=a.createMessageInstanceIdFn(n,s);t.exports=class NoDocWriteAudit extends i{static get meta(){return{id:"no-document-write",title:l(s.title),failureTitle:l(s.failureTitle),description:l(s.description),requiredArtifacts:["ConsoleMessages"]}}static audit(e){
const t=i.getViolationResults(e,/document\.write/),n=[{key:"url",itemType:"url",text:l(a.UIStrings.columnURL)},{key:"label",itemType:"text",text:l(a.UIStrings.columnLocation)}],s=i.makeTableDetails(n,t);return{score:Number(0===t.length),details:s}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/dobetterweb/no-document-write.js")},{"../../lib/i18n/i18n.js":84,"../violation-audit.js":8}],"../audits/dobetterweb/no-vulnerable-libraries":[function(e,t,n){(function(n){"use strict";const i=e("../audit.js"),a=e("../../lib/sentry.js"),s=e("semver"),l=e("../../../third-party/snyk/snapshot.json"),c=e("../../lib/i18n/i18n.js"),u={title:"Avoids front-end JavaScript libraries with known security vulnerabilities",failureTitle:"Includes front-end JavaScript libraries with known security vulnerabilities",
description:"Some third-party scripts may contain known security vulnerabilities that are easily identified and exploited by attackers. [Learn more](https://web.dev/no-vulnerable-libraries/).",displayValue:"{itemCount, plural,\n    =1 {1 vulnerability detected}\n    other {# vulnerabilities detected}\n    }",columnVersion:"Library Version",columnVuln:"Vulnerability Count",columnSeverity:"Highest Severity",rowSeverityLow:"Low",rowSeverityMedium:"Medium",rowSeverityHigh:"High"},d=c.createMessageInstanceIdFn(n,u),m=/^(\d+\.\d+\.\d+)[^-0-9]+/,p={low:d(u.rowSeverityLow),medium:d(u.rowSeverityMedium),high:d(u.rowSeverityHigh)};class NoVulnerableLibrariesAudit extends i{static get meta(){return{id:"no-vulnerable-libraries",title:d(u.title),failureTitle:d(u.failureTitle),description:d(u.description),requiredArtifacts:["Stacks"]}}static get snykDB(){return l}static get severityMap(){return{high:3,medium:2,low:1}}static normalizeVersion(e){if(!e)return e;if(s.valid(e))return e
;if(/^\d+\.\d+$/.test(e))return e+".0";const t=e.match(m);return t?t[1]:e}static getVulnerabilities(e,t,n){if(!t.npm||!n.npm[t.npm])return[];try{s.satisfies(e,"*")}catch(e){return e.pkgName=t.npm,a.captureException(e,{level:"warning"}),[]}return n.npm[t.npm].filter((t=>t.semver.vulnerable.some((t=>s.satisfies(e,t))))).map((n=>({severity:p[n.severity],numericSeverity:this.severityMap[n.severity],library:`${t.name}@${e}`,url:"https://snyk.io/vuln/"+n.id})))}static highestSeverity(e){return e.sort(((e,t)=>t.numericSeverity-e.numericSeverity))[0].severity}static audit(e){const t=e.Stacks.filter((e=>"js"===e.detector)),n=NoVulnerableLibrariesAudit.snykDB;if(!t.length)return{score:1};let a=0;const s=[];for(const e of t){const t=this.normalizeVersion(e.version)||"",i=this.getVulnerabilities(t,e,n),l=i.length;let c;a+=l,i.length>0&&(c=this.highestSeverity(i),s.push({highestSeverity:c,vulnCount:l,detectedLib:{text:e.name+"@"+t,
url:`https://snyk.io/vuln/npm:${e.npm}?lh=${t}&utm_source=lighthouse&utm_medium=ref&utm_campaign=audit`,type:"link"}}))}let l;a>0&&(l=d(u.displayValue,{itemCount:a}));const c=[{key:"detectedLib",itemType:"link",text:d(u.columnVersion)},{key:"vulnCount",itemType:"text",text:d(u.columnVuln)},{key:"highestSeverity",itemType:"text",text:d(u.columnSeverity)}],m=i.makeTableDetails(c,s,{});return{score:Number(0===a),displayValue:l,details:m}}}t.exports=NoVulnerableLibrariesAudit,t.exports.UIStrings=u}).call(this,"/lighthouse-core/audits/dobetterweb/no-vulnerable-libraries.js")},{"../../../third-party/snyk/snapshot.json":226,"../../lib/i18n/i18n.js":84,"../../lib/sentry.js":99,"../audit.js":3,semver:211}],"../audits/dobetterweb/notification-on-start":[function(e,t,n){(function(n){"use strict";const i=e("../violation-audit.js"),a=e("../../lib/i18n/i18n.js"),s={title:"Avoids requesting the notification permission on page load",failureTitle:"Requests the notification permission on page load",
description:"Users are mistrustful of or confused by sites that request to send notifications without context. Consider tying the request to user gestures instead. [Learn more](https://web.dev/notification-on-start/)."},l=a.createMessageInstanceIdFn(n,s);t.exports=class NotificationOnStart extends i{static get meta(){return{id:"notification-on-start",title:l(s.title),failureTitle:l(s.failureTitle),description:l(s.description),requiredArtifacts:["ConsoleMessages"]}}static audit(e){const t=i.getViolationResults(e,/notification permission/),n=[{key:"url",itemType:"url",text:l(a.UIStrings.columnURL)},{key:"label",itemType:"text",text:l(a.UIStrings.columnLocation)}],s=i.makeTableDetails(n,t);return{score:Number(0===t.length),details:s}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/dobetterweb/notification-on-start.js")},{"../../lib/i18n/i18n.js":84,"../violation-audit.js":8}],"../audits/dobetterweb/password-inputs-can-be-pasted-into":[function(e,t,n){(function(n){"use strict"
;const i=e("../audit.js"),a=e("../../lib/i18n/i18n.js"),s={title:"Allows users to paste into password fields",failureTitle:"Prevents users to paste into password fields",description:"Preventing password pasting undermines good security policy. [Learn more](https://web.dev/password-inputs-can-be-pasted-into/)."},l=a.createMessageInstanceIdFn(n,s);t.exports=class PasswordInputsCanBePastedIntoAudit extends i{static get meta(){return{id:"password-inputs-can-be-pasted-into",title:l(s.title),failureTitle:l(s.failureTitle),description:l(s.description),requiredArtifacts:["PasswordInputsWithPreventedPaste"]}}static audit(e){const t=e.PasswordInputsWithPreventedPaste,n=[];t.forEach((e=>{n.push({node:{type:"node",snippet:e.node.snippet,path:e.node.devtoolsNodePath}})}));const s=[{key:"node",itemType:"node",text:l(a.UIStrings.columnFailingElem)}];return{score:Number(0===t.length),details:i.makeTableDetails(s,n)}}},t.exports.UIStrings=s
}).call(this,"/lighthouse-core/audits/dobetterweb/password-inputs-can-be-pasted-into.js")},{"../../lib/i18n/i18n.js":84,"../audit.js":3}],"../audits/dobetterweb/uses-http2":[function(e,t,n){(function(n){"use strict";const i=e("../audit.js"),a=e("../../lib/third-party-web.js"),s=e("../byte-efficiency/byte-efficiency-audit.js"),l=e("../../computed/metrics/lantern-interactive.js"),c=e("../../lib/network-request.js"),u=e("../../computed/network-records.js"),d=e("../../computed/load-simulator.js"),m=e("../../computed/page-dependency-graph.js"),p=e("../../lib/i18n/i18n.js"),h={title:"Use HTTP/2",description:"HTTP/2 offers many benefits over HTTP/1.1, including binary headers and multiplexing. [Learn more](https://web.dev/uses-http2/).",displayValue:"{itemCount, plural,\n    =1 {1 request not served via HTTP/2}\n    other {# requests not served via HTTP/2}\n    }",columnProtocol:"Protocol"
},f=p.createMessageInstanceIdFn(n,h),g=new Set([c.TYPES.Document,c.TYPES.Font,c.TYPES.Image,c.TYPES.Stylesheet,c.TYPES.Script,c.TYPES.Media]);class UsesHTTP2Audit extends i{static get meta(){return{id:"uses-http2",title:f(h.title),description:f(h.description),requiredArtifacts:["URL","devtoolsLogs","traces"]}}static computeWasteWithTTIGraph(e,t,n){const i=new Set(e.map((e=>e.url))),a=n.simulate(t,{label:"uses-http2-before",flexibleOrdering:true}),s=new Map;t.traverse((e=>{"network"===e.type&&i.has(e.record.url)&&(s.set(e.record.requestId,e.record.protocol),e.record.protocol="h2")}));const c=n.simulate(t,{label:"uses-http2-after",flexibleOrdering:true});t.traverse((e=>{if("network"!==e.type)return;const t=s.get(e.record.requestId);void 0!==t&&(e.record.protocol=t)}));const u=a.timeInMs-c.timeInMs,d=l.getLastLongTaskEndTime(a.nodeTimings)-l.getLastLongTaskEndTime(c.nodeTimings),m=Math.max(d,u);return 10*Math.round(Math.max(m,0)/10)}static isStaticAsset(e){
if(!g.has(e.resourceType))return!1;if(e.resourceSize<100){if(a.getEntity(e.url))return!1}return!0}static determineNonHttp2Resources(e){const t=[],n=new Set,i=new Map;for(const t of e){if(!UsesHTTP2Audit.isStaticAsset(t))continue;const e=i.get(t.parsedURL.securityOrigin)||[];e.push(t),i.set(t.parsedURL.securityOrigin,e)}for(const a of e){if(n.has(a.url))continue;if(a.fetchedViaServiceWorker)continue;if(!/HTTP\/[01][.\d]?/i.test(a.protocol))continue;(i.get(a.parsedURL.securityOrigin)||[]).length<6||(n.add(a.url),t.push({protocol:a.protocol,url:a.url}))}return t}static async audit(e,t){const n=e.traces[i.DEFAULT_PASS],a=e.devtoolsLogs[i.DEFAULT_PASS],l={devtoolsLog:a,settings:t&&t.settings||{}},c=await u.request(a,t),g=await m.request({trace:n,devtoolsLog:a},t),y=await d.request(l,t),b=UsesHTTP2Audit.determineNonHttp2Resources(c),v=UsesHTTP2Audit.computeWasteWithTTIGraph(b,g,y);let w;b.length>0&&(w=f(h.displayValue,{itemCount:b.length}));const T=[{key:"url",valueType:"url",
label:f(p.UIStrings.columnURL)},{key:"protocol",valueType:"text",label:f(h.columnProtocol)}],S=i.makeOpportunityDetails(T,b,v);return{displayValue:w,numericValue:v,numericUnit:"millisecond",score:s.scoreForWastedMs(v),details:S}}}t.exports=UsesHTTP2Audit,t.exports.UIStrings=h}).call(this,"/lighthouse-core/audits/dobetterweb/uses-http2.js")},{"../../computed/load-simulator.js":12,"../../computed/metrics/lantern-interactive.js":27,"../../computed/network-records.js":42,"../../computed/page-dependency-graph.js":43,"../../lib/i18n/i18n.js":84,"../../lib/network-request.js":96,"../../lib/third-party-web.js":104,"../audit.js":3,"../byte-efficiency/byte-efficiency-audit.js":4}],"../audits/dobetterweb/uses-passive-event-listeners":[function(e,t,n){(function(n){"use strict";const i=e("../violation-audit.js"),a=e("../../lib/i18n/i18n.js"),s={title:"Uses passive listeners to improve scrolling performance",failureTitle:"Does not use passive listeners to improve scrolling performance",
description:"Consider marking your touch and wheel event listeners as `passive` to improve your page's scroll performance. [Learn more](https://web.dev/uses-passive-event-listeners/)."},l=a.createMessageInstanceIdFn(n,s);t.exports=class PassiveEventsAudit extends i{static get meta(){return{id:"uses-passive-event-listeners",title:l(s.title),failureTitle:l(s.failureTitle),description:l(s.description),requiredArtifacts:["ConsoleMessages"]}}static audit(e){const t=i.getViolationResults(e,/passive event listener/),n=[{key:"url",itemType:"url",text:l(a.UIStrings.columnURL)},{key:"label",itemType:"text",text:l(a.UIStrings.columnLocation)}],s=i.makeTableDetails(n,t);return{score:Number(0===t.length),details:s}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/dobetterweb/uses-passive-event-listeners.js")},{"../../lib/i18n/i18n.js":84,"../violation-audit.js":8}],"../audits/errors-in-console":[function(e,t,n){(function(n){"use strict"
;const i=e("lighthouse-logger"),a=e("./audit.js"),s=e("../lib/i18n/i18n.js"),l={title:"No browser errors logged to the console",failureTitle:"Browser errors were logged to the console",description:"Errors logged to the console indicate unresolved problems. They can come from network request failures and other browser concerns. [Learn more](https://web.dev/errors-in-console/)"},c=s.createMessageInstanceIdFn(n,l);class ErrorLogs extends a{static get meta(){return{id:"errors-in-console",title:c(l.title),failureTitle:c(l.failureTitle),description:c(l.description),requiredArtifacts:["ConsoleMessages"]}}static defaultOptions(){return{}}static filterAccordingToOptions(e,t){const{ignoredPatterns:n,...a}=t,s=Object.keys(a);return s.length&&i.warn(this.meta.id,"Unrecognized options",s),n?e.filter((({description:e})=>{if(!e)return!0;for(const t of n){if(t instanceof RegExp&&t.test(e))return!1;if("string"==typeof t&&e.includes(t))return!1}return!0})):e}static audit(e,t){
const n=t.options,i=e.ConsoleMessages.filter((e=>"error"===e.level)).map((e=>({source:e.source,description:e.text,url:e.url}))),l=ErrorLogs.filterAccordingToOptions(i,n).sort(((e,t)=>(e.description||"").localeCompare(t.description||""))),u=[{key:"url",itemType:"url",text:c(s.UIStrings.columnURL)},{key:"description",itemType:"code",text:c(s.UIStrings.columnDescription)}],d=a.makeTableDetails(u,l),m=l.length;return{score:Number(0===m),details:d}}}t.exports=ErrorLogs,t.exports.UIStrings=l}).call(this,"/lighthouse-core/audits/errors-in-console.js")},{"../lib/i18n/i18n.js":84,"./audit.js":3,"lighthouse-logger":115}],"../audits/final-screenshot":[function(e,t,n){"use strict";const i=e("./audit.js"),a=e("../lib/lh-error.js"),s=e("../computed/trace-of-tab.js"),l=e("../computed/screenshots.js");t.exports=class FinalScreenshot extends i{static get meta(){return{id:"final-screenshot",scoreDisplayMode:i.SCORING_MODES.INFORMATIVE,title:"Final Screenshot",
description:"The last screenshot captured of the pageload.",requiredArtifacts:["traces"]}}static async audit(e,t){const n=e.traces[i.DEFAULT_PASS],c=await s.request(n,t),u=await l.request(n,t),{timeOrigin:d}=c.timestamps,m=u[u.length-1];if(!m)throw new a(a.errors.NO_SCREENSHOTS);return{score:1,details:{type:"screenshot",timing:Math.round((m.timestamp-d)/1e3),timestamp:m.timestamp,data:m.datauri}}}}},{"../computed/screenshots.js":45,"../computed/trace-of-tab.js":47,"../lib/lh-error.js":92,"./audit.js":3}],"../audits/font-display":[function(e,t,n){(function(n){"use strict";const i=e("./audit.js"),a=e("../lib/url-shim.js"),s=/^(block|fallback|optional|swap)$/,l=/url\((.*?)\)/,c=new RegExp(l,"g"),u=e("../lib/i18n/i18n.js"),d=e("../lib/sentry.js"),m=e("../computed/network-records.js"),p={title:"All text remains visible during webfont loads",failureTitle:"Ensure text remains visible during webfont load",
description:"Leverage the font-display CSS feature to ensure text is user-visible while webfonts are loading. [Learn more](https://web.dev/font-display/).",undeclaredFontOriginWarning:"{fontCountForOrigin, plural, =1 {Lighthouse was unable to automatically check the `font-display` value for the origin {fontOrigin}.} other {Lighthouse was unable to automatically check the `font-display` values for the origin {fontOrigin}.}}"},h=u.createMessageInstanceIdFn(n,p);class FontDisplay extends i{static get meta(){return{id:"font-display",title:h(p.title),failureTitle:h(p.failureTitle),description:h(p.description),requiredArtifacts:["devtoolsLogs","CSSUsage","URL"]}}static findFontDisplayDeclarations(e,t){const n=new Set,i=new Set;for(const s of e.CSSUsage.stylesheets){const u=s.content.replace(/(\r|\n)+/g," ").match(/@font-face\s*{(.*?)}/g)||[];for(const m of u){const u=m.match(c);if(!u)continue
;const p=m.match(/font-display\s*:\s*(\w+)\s*(;|\})/),h=p&&p[1]||"",f=t.test(h)?n:i,g=u.map((e=>e.match(l)[1].trim())).map((e=>/^('|").*\1$/.test(e)?e.substr(1,e.length-2):e));for(const t of g)try{const n=a.isValid(s.header.sourceURL)?s.header.sourceURL:e.URL.finalUrl,i=new a(t,n);f.add(i.href)}catch(e){d.captureException(e,{tags:{audit:this.meta.id}})}}}return{passingURLs:n,failingURLs:i}}static getWarningsForFontUrls(e){const t=new Map;for(const n of e){const e=a.getOrigin(n);if(!e)continue;const i=t.get(e)||0;t.set(e,i+1)}return[...t].map((([e,t])=>h(p.undeclaredFontOriginWarning,{fontCountForOrigin:t,fontOrigin:e})))}static async audit(e,t){const n=e.devtoolsLogs[this.DEFAULT_PASS],a=await m.request(n,t),{passingURLs:l,failingURLs:c}=FontDisplay.findFontDisplayDeclarations(e,s),d=[],p=a.filter((e=>"Font"===e.resourceType)).filter((e=>!/^data:/.test(e.url))).filter((e=>!/^blob:/.test(e.url))).filter((e=>!!c.has(e.url)||(l.has(e.url)||d.push(e.url),!1))).map((e=>{
const t=Math.min(1e3*(e.endTime-e.startTime),3e3);return{url:e.url,wastedMs:t}})),f=[{key:"url",itemType:"url",text:h(u.UIStrings.columnURL)},{key:"wastedMs",itemType:"ms",text:h(u.UIStrings.columnWastedMs)}],g=i.makeTableDetails(f,p);return{score:Number(0===p.length),details:g,warnings:FontDisplay.getWarningsForFontUrls(d)}}}t.exports=FontDisplay,t.exports.UIStrings=p}).call(this,"/lighthouse-core/audits/font-display.js")},{"../computed/network-records.js":42,"../lib/i18n/i18n.js":84,"../lib/sentry.js":99,"../lib/url-shim.js":"url","./audit.js":3}],"../audits/full-page-screenshot":[function(e,t,n){"use strict";const i=e("./audit.js");t.exports=class FullPageScreenshot extends i{static get meta(){return{id:"full-page-screenshot",scoreDisplayMode:i.SCORING_MODES.INFORMATIVE,title:"Full-page screenshot",description:"A full-height screenshot of the final rendered page",requiredArtifacts:["FullPageScreenshot"]}}static async audit(e){return e.FullPageScreenshot?{score:1,details:{
type:"full-page-screenshot",...e.FullPageScreenshot}}:{score:0,notApplicable:!0}}}},{"./audit.js":3}],"../audits/image-aspect-ratio":[function(e,t,n){(function(n){"use strict";const i=e("./audit.js"),a=e("../lib/url-shim.js"),s=e("../lib/i18n/i18n.js"),l={title:"Displays images with correct aspect ratio",failureTitle:"Displays images with incorrect aspect ratio",description:"Image display dimensions should match natural aspect ratio. [Learn more](https://web.dev/image-aspect-ratio/).",columnDisplayed:"Aspect Ratio (Displayed)",columnActual:"Aspect Ratio (Actual)"},c=s.createMessageInstanceIdFn(n,l);class ImageAspectRatio extends i{static get meta(){return{id:"image-aspect-ratio",title:c(l.title),failureTitle:c(l.failureTitle),description:c(l.description),requiredArtifacts:["ImageElements"]}}static computeAspectRatios(e){const t=a.elideDataURI(e.src),n=e.naturalWidth/e.naturalHeight,i=e.displayedWidth/e.displayedHeight,s=e.displayedWidth/n,l=Math.abs(s-e.displayedHeight)<2;return{url:t,
displayedAspectRatio:`${e.displayedWidth} x ${e.displayedHeight}\n        (${i.toFixed(2)})`,actualAspectRatio:`${e.naturalWidth} x ${e.naturalHeight}\n        (${n.toFixed(2)})`,doRatiosMatch:l}}static audit(e){const t=e.ImageElements,n=[];t.filter((e=>!e.isCss&&e.mimeType&&"image/svg+xml"!==e.mimeType&&e.naturalHeight&&e.naturalHeight>5&&e.naturalWidth&&e.naturalWidth>5&&e.displayedWidth&&e.displayedHeight&&"fill"===e.cssComputedObjectFit)).forEach((e=>{const t=e,i=ImageAspectRatio.computeAspectRatios(t);i.doRatiosMatch||n.push(i)}));const a=[{key:"url",itemType:"thumbnail",text:""},{key:"url",itemType:"url",text:c(s.UIStrings.columnURL)},{key:"displayedAspectRatio",itemType:"text",text:c(l.columnDisplayed)},{key:"actualAspectRatio",itemType:"text",text:c(l.columnActual)}];return{score:Number(0===n.length),details:i.makeTableDetails(a,n)}}}t.exports=ImageAspectRatio,t.exports.UIStrings=l}).call(this,"/lighthouse-core/audits/image-aspect-ratio.js")},{"../lib/i18n/i18n.js":84,
"../lib/url-shim.js":"url","./audit.js":3}],"../audits/image-size-responsive":[function(e,t,n){(function(n){"use strict";const i=e("./audit.js"),a=e("../lib/url-shim.js"),s=e("../lib/i18n/i18n.js"),l={title:"Serves images with appropriate resolution",failureTitle:"Serves images with low resolution",description:"Image natural dimensions should be proportional to the display size and the pixel ratio to maximize image clarity. [Learn more](https://web.dev/serve-responsive-images/).",columnDisplayed:"Displayed size",columnActual:"Actual size",columnExpected:"Expected size"},c=s.createMessageInstanceIdFn(n,l);function isCandidate(e){return!(e.displayedWidth<=1||e.displayedHeight<=1)&&(!(!e.naturalWidth||!e.naturalHeight)&&("image/svg+xml"!==e.mimeType&&(!e.isCss&&("fill"===e.cssComputedObjectFit&&(!["pixelated","crisp-edges"].includes(e.cssComputedImageRendering)&&!/ \d+(\.\d+)?x/.test(e.srcset))))))}function imageHasNaturalDimensions(e){
return void 0!==e.naturalHeight&&void 0!==e.naturalWidth}function imageHasRightSize(e,t){const[n,i]=function allowedImageSize(e,t,n){let i=1;(e>64||t>64)&&(i=.75);const a=quantizeDpr(n),s=Math.ceil(i*a*e),l=Math.ceil(i*a*t);return[s,l]}(e.displayedWidth,e.displayedHeight,t);return e.naturalWidth>=n&&e.naturalHeight>=i}function getResult(e,t){const[n,i]=function expectedImageSize(e,t,n){const i=Math.ceil(quantizeDpr(n)*e),a=Math.ceil(quantizeDpr(n)*t);return[i,a]}(e.displayedWidth,e.displayedHeight,t);return{url:e.src,elidedUrl:a.elideDataURI(e.src),displayedSize:`${e.displayedWidth} x ${e.displayedHeight}`,actualSize:`${e.naturalWidth} x ${e.naturalHeight}`,actualPixels:e.naturalWidth*e.naturalHeight,expectedSize:`${n} x ${i}`,expectedPixels:n*i}}function quantizeDpr(e){return e>=2?2:e>=1.5?1.5:1}t.exports=class ImageSizeResponsive extends i{static get meta(){return{id:"image-size-responsive",title:c(l.title),failureTitle:c(l.failureTitle),description:c(l.description),
requiredArtifacts:["ImageElements","ViewportDimensions"]}}static audit(e){const t=e.ViewportDimensions.devicePixelRatio,n=Array.from(e.ImageElements).filter(isCandidate).filter(imageHasNaturalDimensions).filter((e=>!imageHasRightSize(e,t))).filter((t=>function isVisible(e,t){return(e.bottom-e.top)*(e.right-e.left)>0&&e.top<=t.innerHeight&&e.bottom>=0&&e.left<=t.innerWidth&&e.right>=0}(t.clientRect,e.ViewportDimensions))).map((e=>getResult(e,t))),a=[{key:"url",itemType:"thumbnail",text:""},{key:"elidedUrl",itemType:"url",text:c(s.UIStrings.columnURL)},{key:"displayedSize",itemType:"text",text:c(l.columnDisplayed)},{key:"actualSize",itemType:"text",text:c(l.columnActual)},{key:"expectedSize",itemType:"text",text:c(l.columnExpected)}],u=function sortResultsBySizeDelta(e){return e.sort(((e,t)=>t.expectedPixels-t.actualPixels-(e.expectedPixels-e.actualPixels)))}(function deduplicateResultsByUrl(e){e.sort(((e,t)=>e.url===t.url?0:e.url<t.url?-1:1));const t=[];for(const n of e){
const e=t[t.length-1];e&&e.url===n.url?e.expectedPixels<n.expectedPixels&&(t[t.length-1]=n):t.push(n)}return t}(n));return{score:Number(0===n.length),details:i.makeTableDetails(a,u)}}},t.exports.UIStrings=l}).call(this,"/lighthouse-core/audits/image-size-responsive.js")},{"../lib/i18n/i18n.js":84,"../lib/url-shim.js":"url","./audit.js":3}],"../audits/installable-manifest":[function(e,t,n){(function(n){"use strict";const i=e("./audit.js"),a=e("../lib/i18n/i18n.js"),s=e("../computed/manifest-values.js"),l={title:"Web app manifest and service worker meet the installability requirements",failureTitle:"Web app manifest or service worker do not meet the installability requirements",
description:"Service worker is the technology that enables your app to use many Progressive Web App features, such as offline, add to homescreen, and push notifications. With proper service worker and manifest implementations, browsers can proactively prompt users to add your app to their homescreen, which can lead to higher engagement. [Learn more](https://web.dev/installable-manifest/).",columnValue:"Failure reason",displayValue:"{itemCount, plural,\n    =1 {1 reason}\n    other {# reasons}\n    }",noErrorId:"Installability error id '{errorId}' is not recognized","not-in-main-frame":"Page is not loaded in the main frame","not-from-secure-origin":"Page is not served from a secure origin","no-manifest":"Page has no manifest <link> URL","start-url-not-valid":"Manifest start URL is not valid","manifest-missing-name-or-short-name":"Manifest does not contain a 'name' or 'short_name' field",
"manifest-display-not-supported":"Manifest 'display' property must be one of 'standalone', 'fullscreen', or 'minimal-ui'","manifest-empty":"Manifest could not be fetched, is empty, or could not be parsed","no-matching-service-worker":"No matching service worker detected. You may need to reload the page, or check that the scope of the service worker for the current page encloses the scope and start URL from the manifest.","manifest-missing-suitable-icon":'Manifest does not contain a suitable icon - PNG, SVG or WebP format of at least {value0} px is required, the sizes attribute must be set, and the purpose attribute, if set, must include "any" or "maskable".',"no-acceptable-icon":"No supplied icon is at least {value0} px square in PNG, SVG or WebP format","cannot-download-icon":"Downloaded icon was empty or corrupted","no-icon-available":"Downloaded icon was empty or corrupted","platform-not-supported-on-android":"The specified application platform is not supported on Android",
"no-id-specified":"No Play store ID provided","ids-do-not-match":"The Play Store app URL and Play Store ID do not match","already-installed":"The app is already installed","url-not-supported-for-webapk":"A URL in the manifest contains a username, password, or port","in-incognito":"Page is loaded in an incognito window","not-offline-capable":"Page does not work offline","no-url-for-service-worker":"Could not check service worker without a 'start_url' field in the manifest","prefer-related-applications":"Manifest specifies prefer_related_applications: true","prefer-related-applications-only-beta-stable":"prefer_related_applications is only supported on Chrome Beta and Stable channels on Android.","manifest-display-override-not-supported":"Manifest contains 'display_override' field, and the first supported display mode must be one of 'standalone', 'fullscreen', or 'minimal-ui'","manifest-location-changed":"Manifest URL changed while the manifest was being fetched.",
"warn-not-offline-capable":"Page does not work offline. The page will not be regarded as installable after Chrome 93, stable release August 2021."},c=a.createMessageInstanceIdFn(n,l);class InstallableManifest extends i{static get meta(){return{id:"installable-manifest",title:c(l.title),failureTitle:c(l.failureTitle),description:c(l.description),requiredArtifacts:["URL","WebAppManifest","InstallabilityErrors"]}}static getInstallabilityErrors(e){const t=e.InstallabilityErrors.errors,n=[],i=[],a=/{([^}]+)}/g;for(const e of t){if("in-incognito"===e.errorId)continue;if("warn-not-offline-capable"===e.errorId){i.push(c(l[e.errorId]));continue}const t=l[e.errorId];if(void 0===t){n.push(c(l.noErrorId,{errorId:e.errorId}));continue}const s=t.match(a)||[],u=e.errorArguments&&e.errorArguments.length&&e.errorArguments[0].value;if(t&&e.errorArguments.length!==s.length){
const t=JSON.stringify(e.errorArguments),i=e.errorArguments.length>s.length?`${e.errorId} has unexpected arguments ${t}`:e.errorId+" does not have the expected number of arguments.";n.push(i)}else t&&u?n.push(c(t,{value0:u})):t&&n.push(c(t))}return{i18nErrors:n,warnings:i}}static async audit(e,t){const n=await s.request(e,t),{i18nErrors:a,warnings:u}=InstallableManifest.getInstallabilityErrors(e),d=e.WebAppManifest?e.WebAppManifest.url:null,m=[{key:"reason",itemType:"text",text:c(l.columnValue)}],p=a.map((e=>({reason:e})));n.isParseFailure&&p.push({reason:n.parseFailureReason});const h={type:"debugdata",manifestUrl:d};return p.length>0?{score:0,warnings:u,numericValue:p.length,numericUnit:"element",displayValue:c(l.displayValue,{itemCount:p.length}),details:{...i.makeTableDetails(m,p),debugData:h}}:{score:1,warnings:u,details:{...i.makeTableDetails(m,p),debugData:h}}}}t.exports=InstallableManifest,t.exports.UIStrings=l}).call(this,"/lighthouse-core/audits/installable-manifest.js")},{
"../computed/manifest-values.js":15,"../lib/i18n/i18n.js":84,"./audit.js":3}],"../audits/is-on-https":[function(e,t,n){(function(n){"use strict";const i=e("./audit.js"),a=e("../lib/url-shim.js"),s=e("../computed/network-records.js"),l=e("../lib/i18n/i18n.js"),c={title:"Uses HTTPS",failureTitle:"Does not use HTTPS",description:"All sites should be protected with HTTPS, even ones that don't handle sensitive data. This includes avoiding [mixed content](https://developers.google.com/web/fundamentals/security/prevent-mixed-content/what-is-mixed-content), where some resources are loaded over HTTP despite the initial request being served over HTTPS. HTTPS prevents intruders from tampering with or passively listening in on the communications between your app and your users, and is a prerequisite for HTTP/2 and many new web platform APIs. [Learn more](https://web.dev/is-on-https/).",
displayValue:"{itemCount, plural,\n    =1 {1 insecure request found}\n    other {# insecure requests found}\n    }",columnInsecureURL:"Insecure URL",columnResolution:"Request Resolution",allowed:"Allowed",blocked:"Blocked",warning:"Allowed with warning",upgraded:"Automatically upgraded to HTTPS"},u={MixedContentAutomaticallyUpgraded:c.upgraded,MixedContentBlocked:c.blocked,MixedContentWarning:c.warning},d=l.createMessageInstanceIdFn(n,c),m=["data","https","wss","blob","chrome","chrome-extension","about","filesystem"],p=["localhost","127.0.0.1"];class HTTPS extends i{static get meta(){return{id:"is-on-https",title:d(c.title),failureTitle:d(c.failureTitle),description:d(c.description),requiredArtifacts:["devtoolsLogs","InspectorIssues"]}}static isSecureRecord(e){return m.includes(e.parsedURL.scheme)||m.includes(e.protocol)||p.includes(e.parsedURL.host)}static audit(e,t){const n=e.devtoolsLogs[i.DEFAULT_PASS];return s.request(n,t).then((t=>{
const n=t.filter((e=>!HTTPS.isSecureRecord(e))).map((e=>a.elideDataURI(e.url))),s=Array.from(new Set(n)).map((e=>({url:e,resolution:void 0}))),l=[{key:"url",itemType:"url",text:d(c.columnInsecureURL)},{key:"resolution",itemType:"text",text:d(c.columnResolution)}];for(const t of e.InspectorIssues.mixedContent){let e=s.find((e=>e.url===t.insecureURL));e||(e={url:t.insecureURL},s.push(e)),e.resolution=u[t.resolutionStatus]?d(u[t.resolutionStatus]):t.resolutionStatus}for(const e of s)e.resolution||(e.resolution=d(c.allowed));let m;return s.length>0&&(m=d(c.displayValue,{itemCount:s.length})),{score:Number(0===s.length),displayValue:m,details:i.makeTableDetails(l,s)}}))}}t.exports=HTTPS,t.exports.UIStrings=c}).call(this,"/lighthouse-core/audits/is-on-https.js")},{"../computed/network-records.js":42,"../lib/i18n/i18n.js":84,"../lib/url-shim.js":"url","./audit.js":3}],"../audits/large-javascript-libraries":[function(e,t,n){(function(n){"use strict"
;const i=e("../lib/large-javascript-libraries/bundlephobia-database.json"),a=e("../lib/large-javascript-libraries/library-suggestions.js").suggestions,s=e("./audit.js"),l=e("../lib/i18n/i18n.js"),c={title:"Avoids large JavaScript libraries with smaller alternatives",failureTitle:"Replace unnecessarily large JavaScript libraries",description:"Large JavaScript libraries can lead to poor performance. Prefer smaller, functionally equivalent libraries to reduce your bundle size. [Learn more](https://developers.google.com/web/fundamentals/performance/webpack/decrease-frontend-size#optimize_dependencies).",columnLibraryName:"Library",displayValue:"{libraryCount, plural,\n    =1 {1 large library found}\n    other {# large libraries found}\n    }"},u=l.createMessageInstanceIdFn(n,c);t.exports=class LargeJavascriptLibraries extends s{static get meta(){return{id:"large-javascript-libraries",title:u(c.title),failureTitle:u(c.failureTitle),description:u(c.description),requiredArtifacts:["Stacks"]}}
static audit(e){const t=[],n=e.Stacks,d=new Set;for(const e of n){if(!e.npm||!i[e.npm])continue;const n=a[e.npm];if(!n)continue;if(d.has(e.npm))continue;d.add(e.npm);let s="latest";e.version&&i[e.npm].versions[e.version]&&(s=e.version);const l=i[e.npm].versions[s],c=[];for(const e of n)i[e].versions.latest.gzip>=l.gzip||c.push({name:e,repository:i[e].repository,gzip:i[e].versions.latest.gzip});c.sort(((e,t)=>e.gzip-t.gzip)),c.length&&t.push({original:{gzip:l.gzip,name:e.npm,repository:i[e.npm].repository},suggestions:c})}const m=t.map((e=>{const t=e.original,n=e.suggestions.map((e=>({suggestion:{type:"link",text:e.name,url:e.repository},transferSize:e.gzip,wastedBytes:t.gzip-e.gzip})));return{name:{type:"link",text:t.name,url:t.repository},transferSize:t.gzip,subItems:{type:"subitems",items:n}}})),p=[{key:"name",itemType:"text",subItemsHeading:{key:"suggestion"},text:u(c.columnLibraryName)},{key:"transferSize",itemType:"bytes",subItemsHeading:{key:"transferSize"},
text:u(l.UIStrings.columnTransferSize)},{key:null,itemType:"bytes",subItemsHeading:{key:"wastedBytes"},text:u(l.UIStrings.columnWastedBytes)}],h=u(c.displayValue,{libraryCount:m.length}),f=s.makeTableDetails(p,m,{});return{score:t.length>0?0:1,displayValue:h,details:f}}},t.exports.UIStrings=c}).call(this,"/lighthouse-core/audits/large-javascript-libraries.js")},{"../lib/i18n/i18n.js":84,"../lib/large-javascript-libraries/bundlephobia-database.json":88,"../lib/large-javascript-libraries/library-suggestions.js":89,"./audit.js":3}],"../audits/largest-contentful-paint-element":[function(e,t,n){(function(n){"use strict";const i=e("./audit.js"),a=e("../lib/i18n/i18n.js"),s={title:"Largest Contentful Paint element",description:"This is the largest contentful element painted within the viewport. [Learn More](https://web.dev/lighthouse-largest-contentful-paint/)"},l=a.createMessageInstanceIdFn(n,s);t.exports=class LargestContentfulPaintElement extends i{static get meta(){return{
id:"largest-contentful-paint-element",title:l(s.title),description:l(s.description),scoreDisplayMode:i.SCORING_MODES.INFORMATIVE,requiredArtifacts:["traces","TraceElements"]}}static audit(e){const t=e.TraceElements.find((e=>"largest-contentful-paint"===e.traceEventType)),n=[];t&&n.push({node:{type:"node",lhId:t.node.lhId,path:t.node.devtoolsNodePath,selector:t.node.selector,nodeLabel:t.node.nodeLabel,snippet:t.node.snippet,boundingRect:t.node.boundingRect}});const s=[{key:"node",itemType:"node",text:l(a.UIStrings.columnElement)}],c=i.makeTableDetails(s,n),u=l(a.UIStrings.displayValueElementsFound,{nodeCount:n.length});return{score:1,notApplicable:0===n.length,displayValue:u,details:c}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/largest-contentful-paint-element.js")},{"../lib/i18n/i18n.js":84,"./audit.js":3}],"../audits/layout-shift-elements":[function(e,t,n){(function(n){"use strict";const i=e("./audit.js"),a=e("../lib/i18n/i18n.js"),s={
title:"Avoid large layout shifts",description:"These DOM elements contribute most to the CLS of the page.",columnContribution:"CLS Contribution"},l=a.createMessageInstanceIdFn(n,s);t.exports=class LayoutShiftElements extends i{static get meta(){return{id:"layout-shift-elements",title:l(s.title),description:l(s.description),scoreDisplayMode:i.SCORING_MODES.INFORMATIVE,requiredArtifacts:["traces","TraceElements"]}}static audit(e){const t=e.TraceElements.filter((e=>"layout-shift"===e.traceEventType)).map((e=>({node:{type:"node",lhId:e.node.lhId,path:e.node.devtoolsNodePath,selector:e.node.selector,nodeLabel:e.node.nodeLabel,snippet:e.node.snippet,boundingRect:e.node.boundingRect},score:e.score}))),n=[{key:"node",itemType:"node",text:l(a.UIStrings.columnElement)},{key:"score",itemType:"numeric",granularity:.001,text:l(s.columnContribution)}],c=i.makeTableDetails(n,t);let u;return t.length>0&&(u=l(a.UIStrings.displayValueElementsFound,{nodeCount:t.length})),{score:1,
notApplicable:0===c.items.length,displayValue:u,details:c}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/layout-shift-elements.js")},{"../lib/i18n/i18n.js":84,"./audit.js":3}],"../audits/long-tasks":[function(e,t,n){(function(n){"use strict";const i=e("./audit.js"),a=e("../computed/network-records.js"),s=e("../lib/i18n/i18n.js"),l=e("../computed/main-thread-tasks.js"),c=e("./bootup-time.js"),u=e("../computed/page-dependency-graph.js"),d=e("../computed/load-simulator.js"),m={startTime:0,endTime:0,duration:0},p={title:"Avoid long main-thread tasks",description:"Lists the longest tasks on the main thread, useful for identifying worst contributors to input delay. [Learn more](https://web.dev/long-tasks-devtools/)",displayValue:"{itemCount, plural,\n  =1 {# long task found}\n  other {# long tasks found}\n  }"},h=s.createMessageInstanceIdFn(n,p);class LongTasks extends i{static get meta(){return{id:"long-tasks",scoreDisplayMode:i.SCORING_MODES.INFORMATIVE,title:h(p.title),
description:h(p.description),requiredArtifacts:["traces","devtoolsLogs"]}}static async audit(e,t){const n=t.settings||{},f=e.traces[i.DEFAULT_PASS],g=await l.request(f,t),y=e.devtoolsLogs[LongTasks.DEFAULT_PASS],b=await a.request(y,t),v=new Map;if("simulate"===n.throttlingMethod){const e={trace:f,devtoolsLog:y,settings:t.settings},n=await u.request({trace:f,devtoolsLog:y},t),i=await d.request(e,t),a=await i.simulate(n,{label:"long-tasks-diagnostic"});for(const[e,t]of a.nodeTimings.entries())"cpu"===e.type&&v.set(e.event,t)}else for(const e of g)e.unbounded||e.parent||v.set(e.event,e);const w=c.getJavaScriptURLs(b),T=g.map((e=>{const t=v.get(e.event)||m;return{...e,duration:t.duration,startTime:t.startTime}})).filter((e=>e.duration>=50&&!e.unbounded&&!e.parent)).sort(((e,t)=>t.duration-e.duration)).slice(0,20).map((e=>({url:c.getAttributableURLForTask(e,w),duration:e.duration,startTime:e.startTime}))),S=[{key:"url",itemType:"url",text:h(s.UIStrings.columnURL)},{key:"startTime",
itemType:"ms",granularity:1,text:h(s.UIStrings.columnStartTime)},{key:"duration",itemType:"ms",granularity:1,text:h(s.UIStrings.columnDuration)}],E=i.makeTableDetails(S,T);let x;return T.length>0&&(x=h(p.displayValue,{itemCount:T.length})),{score:0===T.length?1:0,notApplicable:0===T.length,details:E,displayValue:x}}}t.exports=LongTasks,t.exports.UIStrings=p}).call(this,"/lighthouse-core/audits/long-tasks.js")},{"../computed/load-simulator.js":12,"../computed/main-thread-tasks.js":14,"../computed/network-records.js":42,"../computed/page-dependency-graph.js":43,"../lib/i18n/i18n.js":84,"./audit.js":3,"./bootup-time.js":"../audits/bootup-time"}],"../audits/main-thread-tasks":[function(e,t,n){"use strict";const i=e("./audit.js"),a=e("../computed/main-thread-tasks.js");t.exports=class MainThreadTasks extends i{static get meta(){return{id:"main-thread-tasks",scoreDisplayMode:i.SCORING_MODES.INFORMATIVE,title:"Tasks",
description:"Lists the toplevel main thread tasks that executed during page load.",requiredArtifacts:["traces"]}}static async audit(e,t){const n=e.traces[i.DEFAULT_PASS],s=(await a.request(n,t)).filter((e=>e.duration>5&&!e.parent)).map((e=>({duration:e.duration,startTime:e.startTime})));return{score:1,details:i.makeTableDetails([{key:"startTime",itemType:"ms",granularity:1,text:"Start Time"},{key:"duration",itemType:"ms",granularity:1,text:"End Time"}],s)}}}},{"../computed/main-thread-tasks.js":14,"./audit.js":3}],"../audits/mainthread-work-breakdown":[function(e,t,n){(function(n){"use strict";const i=e("./audit.js"),{taskGroups:a}=e("../lib/tracehouse/task-groups.js"),s=e("../lib/i18n/i18n.js"),l=e("../computed/main-thread-tasks.js"),c={title:"Minimizes main-thread work",failureTitle:"Minimize main-thread work",
description:"Consider reducing the time spent parsing, compiling and executing JS. You may find delivering smaller JS payloads helps with this. [Learn more](https://web.dev/mainthread-work-breakdown/)",columnCategory:"Category"},u=s.createMessageInstanceIdFn(n,c);class MainThreadWorkBreakdown extends i{static get meta(){return{id:"mainthread-work-breakdown",title:u(c.title),failureTitle:u(c.failureTitle),description:u(c.description),scoreDisplayMode:i.SCORING_MODES.NUMERIC,requiredArtifacts:["traces"]}}static get defaultOptions(){return{p10:2017,median:4e3}}static getExecutionTimingsByGroup(e){const t=new Map;for(const n of e){const e=t.get(n.group.id)||0;t.set(n.group.id,e+n.selfTime)}return t}static async audit(e,t){const n=t.settings||{},d=e.traces[MainThreadWorkBreakdown.DEFAULT_PASS],m=await l.request(d,t),p="simulate"===n.throttlingMethod?n.throttling.cpuSlowdownMultiplier:1,h=MainThreadWorkBreakdown.getExecutionTimingsByGroup(m);let f=0;const g={},y=Array.from(h).map((([e,t])=>{
const n=t*p;f+=n;const i=g[e]||0;return g[e]=i+n,{group:e,groupLabel:a[e].label,duration:n}})),b=[{key:"groupLabel",itemType:"text",text:u(c.columnCategory)},{key:"duration",itemType:"ms",granularity:1,text:u(s.UIStrings.columnTimeSpent)}];y.sort(((e,t)=>g[t.group]-g[e.group]));const v=MainThreadWorkBreakdown.makeTableDetails(b,y);return{score:i.computeLogNormalScore({p10:t.options.p10,median:t.options.median},f),numericValue:f,numericUnit:"millisecond",displayValue:u(s.UIStrings.seconds,{timeInMs:f}),details:v}}}t.exports=MainThreadWorkBreakdown,t.exports.UIStrings=c}).call(this,"/lighthouse-core/audits/mainthread-work-breakdown.js")},{"../computed/main-thread-tasks.js":14,"../lib/i18n/i18n.js":84,"../lib/tracehouse/task-groups.js":106,"./audit.js":3}],"../audits/manual/pwa-cross-browser":[function(e,t,n){(function(n){"use strict";const i=e("./manual-audit.js"),a=e("../../lib/i18n/i18n.js"),s={title:"Site works cross-browser",
description:"To reach the most number of users, sites should work across every major browser. [Learn more](https://web.dev/pwa-cross-browser/)."},l=a.createMessageInstanceIdFn(n,s);t.exports=class PWACrossBrowser extends i{static get meta(){return Object.assign({id:"pwa-cross-browser",title:l(s.title),description:l(s.description)},super.partialMeta)}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/manual/pwa-cross-browser.js")},{"../../lib/i18n/i18n.js":84,"./manual-audit.js":6}],"../audits/manual/pwa-each-page-has-url":[function(e,t,n){(function(n){"use strict";const i=e("./manual-audit.js"),a=e("../../lib/i18n/i18n.js"),s={title:"Each page has a URL",description:"Ensure individual pages are deep linkable via URL and that URLs are unique for the purpose of shareability on social media. [Learn more](https://web.dev/pwa-each-page-has-url/)."},l=a.createMessageInstanceIdFn(n,s);t.exports=class PWAEachPageHasURL extends i{static get meta(){return Object.assign({
id:"pwa-each-page-has-url",title:l(s.title),description:l(s.description)},super.partialMeta)}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/manual/pwa-each-page-has-url.js")},{"../../lib/i18n/i18n.js":84,"./manual-audit.js":6}],"../audits/manual/pwa-page-transitions":[function(e,t,n){(function(n){"use strict";const i=e("./manual-audit.js"),a=e("../../lib/i18n/i18n.js"),s={title:"Page transitions don't feel like they block on the network",description:"Transitions should feel snappy as you tap around, even on a slow network. This experience is key to a user's perception of performance. [Learn more](https://web.dev/pwa-page-transitions/)."},l=a.createMessageInstanceIdFn(n,s);t.exports=class PWAPageTransitions extends i{static get meta(){return Object.assign({id:"pwa-page-transitions",title:l(s.title),description:l(s.description)},super.partialMeta)}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/manual/pwa-page-transitions.js")},{"../../lib/i18n/i18n.js":84,
"./manual-audit.js":6}],"../audits/maskable-icon":[function(e,t,n){(function(n){"use strict";const i=e("./audit.js"),a=e("../computed/manifest-values.js"),s=e("../lib/i18n/i18n.js"),l={title:"Manifest has a maskable icon",failureTitle:"Manifest doesn't have a maskable icon",description:"A maskable icon ensures that the image fills the entire shape without being letterboxed when installing the app on a device. [Learn more](https://web.dev/maskable-icon-audit/)."},c=s.createMessageInstanceIdFn(n,l);t.exports=class MaskableIcon extends i{static get meta(){return{id:"maskable-icon",title:c(l.title),failureTitle:c(l.failureTitle),description:c(l.description),requiredArtifacts:["WebAppManifest","InstallabilityErrors"]}}static async audit(e,t){const n=await a.request(e,t);if(n.isParseFailure)return{score:0,explanation:n.parseFailureReason};const i=n.allChecks.find((e=>"hasMaskableIcon"===e.id));return{score:i&&i.passing?1:0}}},t.exports.UIStrings=l
}).call(this,"/lighthouse-core/audits/maskable-icon.js")},{"../computed/manifest-values.js":15,"../lib/i18n/i18n.js":84,"./audit.js":3}],"../audits/metrics/cumulative-layout-shift":[function(e,t,n){(function(n){"use strict";const i=e("../audit.js"),a=e("../../computed/metrics/cumulative-layout-shift.js"),s=e("../../lib/i18n/i18n.js"),l={description:"Cumulative Layout Shift measures the movement of visible elements within the viewport. [Learn more](https://web.dev/cls/)."},c=s.createMessageInstanceIdFn(n,l);t.exports=class CumulativeLayoutShift extends i{static get meta(){return{id:"cumulative-layout-shift",title:c(s.UIStrings.cumulativeLayoutShiftMetric),description:c(l.description),scoreDisplayMode:i.SCORING_MODES.NUMERIC,requiredArtifacts:["traces"]}}static get defaultOptions(){return{p10:.1,median:.25}}static async audit(e,t){const n=e.traces[i.DEFAULT_PASS],s=await a.request(n,t),l={type:"debugdata",items:[s.debugInfo]};return{score:i.computeLogNormalScore({p10:t.options.p10,
median:t.options.median},s.value),numericValue:s.value,numericUnit:"unitless",displayValue:s.value.toLocaleString(t.settings.locale),details:l}}},t.exports.UIStrings=l}).call(this,"/lighthouse-core/audits/metrics/cumulative-layout-shift.js")},{"../../computed/metrics/cumulative-layout-shift.js":17,"../../lib/i18n/i18n.js":84,"../audit.js":3}],"../audits/metrics/estimated-input-latency":[function(e,t,n){(function(n){"use strict";const i=e("../audit.js"),a=e("../../lib/i18n/i18n.js"),s=e("../../computed/metrics/estimated-input-latency.js"),l={description:"Estimated Input Latency is an estimate of how long your app takes to respond to user input, in milliseconds, during the busiest 5s window of page load. If your latency is higher than 50 ms, users may perceive your app as laggy. [Learn more](https://web.dev/estimated-input-latency/)."},c=a.createMessageInstanceIdFn(n,l);t.exports=class EstimatedInputLatency extends i{static get meta(){return{id:"estimated-input-latency",
title:c(a.UIStrings.estimatedInputLatencyMetric),description:c(l.description),scoreDisplayMode:i.SCORING_MODES.NUMERIC,requiredArtifacts:["traces","devtoolsLogs"]}}static get defaultOptions(){return{p10:58,median:100}}static async audit(e,t){const n={trace:e.traces[i.DEFAULT_PASS],devtoolsLog:e.devtoolsLogs[i.DEFAULT_PASS],settings:t.settings},l=await s.request(n,t);return{score:i.computeLogNormalScore({p10:t.options.p10,median:t.options.median},l.timing),numericValue:l.timing,numericUnit:"millisecond",displayValue:c(a.UIStrings.ms,{timeInMs:l.timing})}}},t.exports.UIStrings=l}).call(this,"/lighthouse-core/audits/metrics/estimated-input-latency.js")},{"../../computed/metrics/estimated-input-latency.js":18,"../../lib/i18n/i18n.js":84,"../audit.js":3}],"../audits/metrics/first-contentful-paint-3g":[function(e,t,n){"use strict";const i=e("../audit.js"),a=e("../../config/constants.js").throttling.mobileRegular3G,s=e("../../computed/metrics/first-contentful-paint.js")
;t.exports=class FirstContentfulPaint3G extends i{static get meta(){return{id:"first-contentful-paint-3g",title:"First Contentful Paint (3G)",description:"First Contentful Paint 3G marks the time at which the first text or image is painted while on a 3G network. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/first-contentful-paint).",scoreDisplayMode:i.SCORING_MODES.NUMERIC,requiredArtifacts:["traces","devtoolsLogs"]}}static get defaultOptions(){return{p10:3504,median:6e3}}static async audit(e,t){const n={trace:e.traces[i.DEFAULT_PASS],devtoolsLog:e.devtoolsLogs[i.DEFAULT_PASS],settings:{...t.settings,throttlingMethod:"simulate",throttling:a}},l=await s.request(n,t);return{score:i.computeLogNormalScore({p10:t.options.p10,median:t.options.median},l.timing),numericValue:l.timing,numericUnit:"millisecond",displayValue:l.timing+" ms"}}}},{"../../computed/metrics/first-contentful-paint.js":19,"../../config/constants.js":56,"../audit.js":3}],
"../audits/metrics/first-contentful-paint":[function(e,t,n){(function(n){"use strict";const i=e("../audit.js"),a=e("../../lib/i18n/i18n.js"),s=e("../../computed/metrics/first-contentful-paint.js"),l={description:"First Contentful Paint marks the time at which the first text or image is painted. [Learn more](https://web.dev/first-contentful-paint/)."},c=a.createMessageInstanceIdFn(n,l);t.exports=class FirstContentfulPaint extends i{static get meta(){return{id:"first-contentful-paint",title:c(a.UIStrings.firstContentfulPaintMetric),description:c(l.description),scoreDisplayMode:i.SCORING_MODES.NUMERIC,requiredArtifacts:["traces","devtoolsLogs"]}}static get defaultOptions(){return{mobile:{scoring:{p10:2336,median:4e3}},desktop:{scoring:{p10:934,median:1600}}}}static async audit(e,t){const n={trace:e.traces[i.DEFAULT_PASS],devtoolsLog:e.devtoolsLogs[i.DEFAULT_PASS],settings:t.settings},l=await s.request(n,t),u=t.options[t.settings.formFactor];return{
score:i.computeLogNormalScore(u.scoring,l.timing),numericValue:l.timing,numericUnit:"millisecond",displayValue:c(a.UIStrings.seconds,{timeInMs:l.timing})}}},t.exports.UIStrings=l}).call(this,"/lighthouse-core/audits/metrics/first-contentful-paint.js")},{"../../computed/metrics/first-contentful-paint.js":19,"../../lib/i18n/i18n.js":84,"../audit.js":3}],"../audits/metrics/first-cpu-idle":[function(e,t,n){(function(n){"use strict";const i=e("../audit.js"),a=e("../../lib/i18n/i18n.js"),s=e("../../computed/metrics/first-cpu-idle.js"),l={description:"First CPU Idle marks the first time at which the page's main thread is quiet enough to handle input.  [Learn more](https://web.dev/first-cpu-idle/)."},c=a.createMessageInstanceIdFn(n,l);t.exports=class FirstCPUIdle extends i{static get meta(){return{id:"first-cpu-idle",title:c(a.UIStrings.firstCPUIdleMetric),description:c(l.description),scoreDisplayMode:i.SCORING_MODES.NUMERIC,requiredArtifacts:["traces","devtoolsLogs"]}}
static get defaultOptions(){return{mobile:{scoring:{p10:3572,median:6500}},desktop:{scoring:{p10:2468,median:4500}}}}static async audit(e,t){const n={trace:e.traces[i.DEFAULT_PASS],devtoolsLog:e.devtoolsLogs[i.DEFAULT_PASS],settings:t.settings},l=await s.request(n,t),u=t.options[t.settings.formFactor];return{score:i.computeLogNormalScore(u.scoring,l.timing),numericValue:l.timing,numericUnit:"millisecond",displayValue:c(a.UIStrings.seconds,{timeInMs:l.timing})}}},t.exports.UIStrings=l}).call(this,"/lighthouse-core/audits/metrics/first-cpu-idle.js")},{"../../computed/metrics/first-cpu-idle.js":20,"../../lib/i18n/i18n.js":84,"../audit.js":3}],"../audits/metrics/first-meaningful-paint":[function(e,t,n){(function(n){"use strict";const i=e("../audit.js"),a=e("../../lib/i18n/i18n.js"),s=e("../../computed/metrics/first-meaningful-paint.js"),l={description:"First Meaningful Paint measures when the primary content of a page is visible. [Learn more](https://web.dev/first-meaningful-paint/)."
},c=a.createMessageInstanceIdFn(n,l);t.exports=class FirstMeaningfulPaint extends i{static get meta(){return{id:"first-meaningful-paint",title:c(a.UIStrings.firstMeaningfulPaintMetric),description:c(l.description),scoreDisplayMode:i.SCORING_MODES.NUMERIC,requiredArtifacts:["traces","devtoolsLogs"]}}static get defaultOptions(){return{mobile:{scoring:{p10:2336,median:4e3}},desktop:{scoring:{p10:934,median:1600}}}}static async audit(e,t){const n={trace:e.traces[i.DEFAULT_PASS],devtoolsLog:e.devtoolsLogs[i.DEFAULT_PASS],settings:t.settings},l=await s.request(n,t),u=t.options[t.settings.formFactor];return{score:i.computeLogNormalScore(u.scoring,l.timing),numericValue:l.timing,numericUnit:"millisecond",displayValue:c(a.UIStrings.seconds,{timeInMs:l.timing})}}},t.exports.UIStrings=l}).call(this,"/lighthouse-core/audits/metrics/first-meaningful-paint.js")},{"../../computed/metrics/first-meaningful-paint.js":21,"../../lib/i18n/i18n.js":84,"../audit.js":3}],
"../audits/metrics/interactive":[function(e,t,n){(function(n){"use strict";const i=e("../audit.js"),a=e("../../lib/i18n/i18n.js"),s=e("../../computed/metrics/interactive.js"),l={description:"Time to interactive is the amount of time it takes for the page to become fully interactive. [Learn more](https://web.dev/interactive/)."},c=a.createMessageInstanceIdFn(n,l);t.exports=class InteractiveMetric extends i{static get meta(){return{id:"interactive",title:c(a.UIStrings.interactiveMetric),description:c(l.description),scoreDisplayMode:i.SCORING_MODES.NUMERIC,requiredArtifacts:["traces","devtoolsLogs"]}}static get defaultOptions(){return{mobile:{scoring:{p10:3785,median:7300}},desktop:{scoring:{p10:2468,median:4500}}}}static async audit(e,t){const n={trace:e.traces[i.DEFAULT_PASS],devtoolsLog:e.devtoolsLogs[i.DEFAULT_PASS],settings:t.settings},l=(await s.request(n,t)).timing,u=t.options[t.settings.formFactor];return{score:i.computeLogNormalScore(u.scoring,l),numericValue:l,
numericUnit:"millisecond",displayValue:c(a.UIStrings.seconds,{timeInMs:l})}}},t.exports.UIStrings=l}).call(this,"/lighthouse-core/audits/metrics/interactive.js")},{"../../computed/metrics/interactive.js":22,"../../lib/i18n/i18n.js":84,"../audit.js":3}],"../audits/metrics/largest-contentful-paint":[function(e,t,n){(function(n){"use strict";const i=e("../audit.js"),a=e("../../lib/i18n/i18n.js"),s=e("../../computed/metrics/largest-contentful-paint.js"),l=e("../../lib/lh-error.js"),c={description:"Largest Contentful Paint marks the time at which the largest text or image is painted. [Learn More](https://web.dev/lighthouse-largest-contentful-paint/)"},u=a.createMessageInstanceIdFn(n,c);t.exports=class LargestContentfulPaint extends i{static get meta(){return{id:"largest-contentful-paint",title:u(a.UIStrings.largestContentfulPaintMetric),description:u(c.description),scoreDisplayMode:i.SCORING_MODES.NUMERIC,requiredArtifacts:["HostUserAgent","traces","devtoolsLogs"]}}
static get defaultOptions(){return{mobile:{scoring:{p10:2500,median:4e3}},desktop:{scoring:{p10:1200,median:2400}}}}static async audit(e,t){const n={trace:e.traces[i.DEFAULT_PASS],devtoolsLog:e.devtoolsLogs[i.DEFAULT_PASS],settings:t.settings};let c;try{c=await s.request(n,t)}catch(t){const n=e.HostUserAgent.match(/Chrome\/(\d+)/);if(!n)throw t;if(Number(n[1])<79&&"NO_LCP"===t.code)throw new l(l.errors.UNSUPPORTED_OLD_CHROME,{featureName:"Largest Contentful Paint"});throw t}const d=t.options[t.settings.formFactor];return{score:i.computeLogNormalScore(d.scoring,c.timing),numericValue:c.timing,numericUnit:"millisecond",displayValue:u(a.UIStrings.seconds,{timeInMs:c.timing})}}},t.exports.UIStrings=c}).call(this,"/lighthouse-core/audits/metrics/largest-contentful-paint.js")},{"../../computed/metrics/largest-contentful-paint.js":34,"../../lib/i18n/i18n.js":84,"../../lib/lh-error.js":92,"../audit.js":3}],"../audits/metrics/max-potential-fid":[function(e,t,n){(function(n){"use strict"
;const i=e("../audit.js"),a=e("../../computed/metrics/max-potential-fid.js"),s=e("../../lib/i18n/i18n.js"),l={description:"The maximum potential First Input Delay that your users could experience is the duration of the longest task. [Learn more](https://web.dev/lighthouse-max-potential-fid/)."},c=s.createMessageInstanceIdFn(n,l);t.exports=class MaxPotentialFID extends i{static get meta(){return{id:"max-potential-fid",title:c(s.UIStrings.maxPotentialFIDMetric),description:c(l.description),scoreDisplayMode:i.SCORING_MODES.NUMERIC,requiredArtifacts:["traces","devtoolsLogs"]}}static get defaultOptions(){return{p10:130,median:250}}static async audit(e,t){const n={trace:e.traces[i.DEFAULT_PASS],devtoolsLog:e.devtoolsLogs[i.DEFAULT_PASS],settings:t.settings},l=await a.request(n,t);return{score:i.computeLogNormalScore({p10:t.options.p10,median:t.options.median},l.timing),numericValue:l.timing,numericUnit:"millisecond",displayValue:c(s.UIStrings.ms,{timeInMs:l.timing})}}},t.exports.UIStrings=l
}).call(this,"/lighthouse-core/audits/metrics/max-potential-fid.js")},{"../../computed/metrics/max-potential-fid.js":35,"../../lib/i18n/i18n.js":84,"../audit.js":3}],"../audits/metrics/speed-index":[function(e,t,n){(function(n){"use strict";const i=e("../audit.js"),a=e("../../lib/i18n/i18n.js"),s=e("../../computed/metrics/speed-index.js"),l={description:"Speed Index shows how quickly the contents of a page are visibly populated. [Learn more](https://web.dev/speed-index/)."},c=a.createMessageInstanceIdFn(n,l);t.exports=class SpeedIndex extends i{static get meta(){return{id:"speed-index",title:c(a.UIStrings.speedIndexMetric),description:c(l.description),scoreDisplayMode:i.SCORING_MODES.NUMERIC,requiredArtifacts:["traces","devtoolsLogs"]}}static get defaultOptions(){return{mobile:{scoring:{p10:3387,median:5800}},desktop:{scoring:{p10:1311,median:2300}}}}static async audit(e,t){const n={trace:e.traces[i.DEFAULT_PASS],devtoolsLog:e.devtoolsLogs[i.DEFAULT_PASS],settings:t.settings
},l=await s.request(n,t),u=t.options[t.settings.formFactor];return{score:i.computeLogNormalScore(u.scoring,l.timing),numericValue:l.timing,numericUnit:"millisecond",displayValue:c(a.UIStrings.seconds,{timeInMs:l.timing})}}},t.exports.UIStrings=l}).call(this,"/lighthouse-core/audits/metrics/speed-index.js")},{"../../computed/metrics/speed-index.js":37,"../../lib/i18n/i18n.js":84,"../audit.js":3}],"../audits/metrics/total-blocking-time":[function(e,t,n){(function(n){"use strict";const i=e("../audit.js"),a=e("../../computed/metrics/total-blocking-time.js"),s=e("../../lib/i18n/i18n.js"),l={description:"Sum of all time periods between FCP and Time to Interactive, when task length exceeded 50ms, expressed in milliseconds. [Learn more](https://web.dev/lighthouse-total-blocking-time/)."},c=s.createMessageInstanceIdFn(n,l);t.exports=class TotalBlockingTime extends i{static get meta(){return{id:"total-blocking-time",title:c(s.UIStrings.totalBlockingTimeMetric),description:c(l.description),
scoreDisplayMode:i.SCORING_MODES.NUMERIC,requiredArtifacts:["traces","devtoolsLogs"]}}static get defaultOptions(){return{mobile:{scoring:{p10:287,median:600}},desktop:{scoring:{p10:150,median:350}}}}static async audit(e,t){const n={trace:e.traces[i.DEFAULT_PASS],devtoolsLog:e.devtoolsLogs[i.DEFAULT_PASS],settings:t.settings},l=await a.request(n,t),u=t.options[t.settings.formFactor];return{score:i.computeLogNormalScore(u.scoring,l.timing),numericValue:l.timing,numericUnit:"millisecond",displayValue:c(s.UIStrings.ms,{timeInMs:l.timing})}}},t.exports.UIStrings=l}).call(this,"/lighthouse-core/audits/metrics/total-blocking-time.js")},{"../../computed/metrics/total-blocking-time.js":39,"../../lib/i18n/i18n.js":84,"../audit.js":3}],"../audits/metrics":[function(e,t,n){"use strict";const i=e("./audit.js"),a=e("../computed/metrics/timing-summary.js"),s=new Set(["cumulativeLayoutShift","cumulativeLayoutShiftAllFrames","observedCumulativeLayoutShift","observedCumulativeLayoutShiftAllFrames"])
;t.exports=class Metrics extends i{static get meta(){return{id:"metrics",scoreDisplayMode:i.SCORING_MODES.INFORMATIVE,title:"Metrics",description:"Collects all available metrics.",requiredArtifacts:["traces","devtoolsLogs"]}}static async audit(e,t){const n=e.traces[i.DEFAULT_PASS],l=e.devtoolsLogs[i.DEFAULT_PASS],c=await a.request({trace:n,devtoolsLog:l},t),u=c.metrics,d=c.debugInfo;for(const[e,t]of Object.entries(u)){const n=e;"number"!=typeof t||s.has(n)||(u[n]=Math.round(t))}const m={type:"debugdata",items:[u,d]};return{score:1,numericValue:u.interactive||0,numericUnit:"millisecond",details:m}}}},{"../computed/metrics/timing-summary.js":38,"./audit.js":3}],"../audits/network-requests":[function(e,t,n){"use strict";const i=e("./audit.js"),a=e("../lib/url-shim.js"),s=e("../computed/network-records.js");t.exports=class NetworkRequests extends i{static get meta(){return{id:"network-requests",scoreDisplayMode:i.SCORING_MODES.INFORMATIVE,title:"Network Requests",
description:"Lists the network requests that were made during page load.",requiredArtifacts:["devtoolsLogs"]}}static audit(e,t){const n=e.devtoolsLogs[i.DEFAULT_PASS];return s.request(n,t).then((e=>{const t=e.reduce(((e,t)=>Math.min(e,t.startTime)),1/0),timeToMs=e=>e<t||!Number.isFinite(e)?void 0:1e3*(e-t),n=e.map((e=>{const t=e.lrStatistics&&e.lrStatistics.endTimeDeltaMs,n=e.lrStatistics&&e.lrStatistics.TCPMs,i=e.lrStatistics&&e.lrStatistics.requestMs,s=e.lrStatistics&&e.lrStatistics.responseMs;return{url:a.elideDataURI(e.url),protocol:e.protocol,startTime:timeToMs(e.startTime),endTime:timeToMs(e.endTime),finished:e.finished,transferSize:e.transferSize,resourceSize:e.resourceSize,statusCode:e.statusCode,mimeType:e.mimeType,resourceType:e.resourceType,lrEndTimeDeltaMs:t,lrTCPMs:n,lrRequestMs:i,lrResponseMs:s}}));return{score:1,details:i.makeTableDetails([{key:"url",itemType:"url",text:"URL"},{key:"protocol",itemType:"text",text:"Protocol"},{key:"startTime",itemType:"ms",granularity:1,
text:"Start Time"},{key:"endTime",itemType:"ms",granularity:1,text:"End Time"},{key:"transferSize",itemType:"bytes",displayUnit:"kb",granularity:1,text:"Transfer Size"},{key:"resourceSize",itemType:"bytes",displayUnit:"kb",granularity:1,text:"Resource Size"},{key:"statusCode",itemType:"text",text:"Status Code"},{key:"mimeType",itemType:"text",text:"MIME Type"},{key:"resourceType",itemType:"text",text:"Resource Type"}],n)}}))}}},{"../computed/network-records.js":42,"../lib/url-shim.js":"url","./audit.js":3}],"../audits/network-rtt":[function(e,t,n){(function(n){"use strict";const i=e("./audit.js"),a=e("../lib/i18n/i18n.js"),s=e("../computed/network-analysis.js"),l={title:"Network Round Trip Times",description:"Network round trip times (RTT) have a large impact on performance. If the RTT to an origin is high, it's an indication that servers closer to the user could improve performance. [Learn more](https://hpbn.co/primer-on-latency-and-bandwidth/)."},c=a.createMessageInstanceIdFn(n,l)
;t.exports=class NetworkRTT extends i{static get meta(){return{id:"network-rtt",scoreDisplayMode:i.SCORING_MODES.INFORMATIVE,title:c(l.title),description:c(l.description),requiredArtifacts:["devtoolsLogs"]}}static async audit(e,t){const n=e.devtoolsLogs[i.DEFAULT_PASS],l=await s.request(n,t);let u=0;const d=l.rtt,m=[];for(const[e,t]of l.additionalRttByOrigin.entries()){if(!e.startsWith("http"))continue;const n=t+d;m.push({origin:e,rtt:n}),u=Number.isFinite(n)?Math.max(n,u):u}m.sort(((e,t)=>t.rtt-e.rtt));const p=[{key:"origin",itemType:"text",text:c(a.UIStrings.columnURL)},{key:"rtt",itemType:"ms",granularity:1,text:c(a.UIStrings.columnTimeSpent)}],h=i.makeTableDetails(p,m);return{score:1,numericValue:u,numericUnit:"millisecond",displayValue:c(a.UIStrings.ms,{timeInMs:u}),details:h}}},t.exports.UIStrings=l}).call(this,"/lighthouse-core/audits/network-rtt.js")},{"../computed/network-analysis.js":41,"../lib/i18n/i18n.js":84,"./audit.js":3}],
"../audits/network-server-latency":[function(e,t,n){(function(n){"use strict";const i=e("./audit.js"),a=e("../lib/i18n/i18n.js"),s=e("../computed/network-analysis.js"),l={title:"Server Backend Latencies",description:"Server latencies can impact web performance. If the server latency of an origin is high, it's an indication the server is overloaded or has poor backend performance. [Learn more](https://hpbn.co/primer-on-web-performance/#analyzing-the-resource-waterfall)."},c=a.createMessageInstanceIdFn(n,l);t.exports=class NetworkServerLatency extends i{static get meta(){return{id:"network-server-latency",scoreDisplayMode:i.SCORING_MODES.INFORMATIVE,title:c(l.title),description:c(l.description),requiredArtifacts:["devtoolsLogs"]}}static async audit(e,t){const n=e.devtoolsLogs[i.DEFAULT_PASS],l=await s.request(n,t);let u=0;const d=[];for(const[e,t]of l.serverResponseTimeByOrigin.entries())e.startsWith("http")&&(u=Math.max(t,u),d.push({origin:e,serverResponseTime:t}))
;d.sort(((e,t)=>t.serverResponseTime-e.serverResponseTime));const m=[{key:"origin",itemType:"text",text:c(a.UIStrings.columnURL)},{key:"serverResponseTime",itemType:"ms",granularity:1,text:c(a.UIStrings.columnTimeSpent)}],p=i.makeTableDetails(m,d);return{score:Math.max(1-u/500,0),numericValue:u,numericUnit:"millisecond",displayValue:c(a.UIStrings.ms,{timeInMs:u}),details:p}}},t.exports.UIStrings=l}).call(this,"/lighthouse-core/audits/network-server-latency.js")},{"../computed/network-analysis.js":41,"../lib/i18n/i18n.js":84,"./audit.js":3}],"../audits/no-unload-listeners":[function(e,t,n){(function(n){"use strict";const i=e("./audit.js"),a=e("./../lib/i18n/i18n.js"),s={title:"Avoids `unload` event listeners",failureTitle:"Registers an `unload` listener",
description:"The `unload` event does not fire reliably and listening for it can prevent browser optimizations like the Back-Forward Cache. Consider using the `pagehide` or `visibilitychange` events instead. [Learn More](https://developers.google.com/web/updates/2018/07/page-lifecycle-api#the-unload-event)"},l=a.createMessageInstanceIdFn(n,s);t.exports=class NoUnloadListeners extends i{static get meta(){return{id:"no-unload-listeners",title:l(s.title),failureTitle:l(s.failureTitle),description:l(s.description),requiredArtifacts:["GlobalListeners","JsUsage"]}}static audit(e){const t=e.GlobalListeners.filter((e=>"unload"===e.type));if(!t.length)return{score:1};const n=[{key:"source",itemType:"source-location",text:l(a.UIStrings.columnURL)}],s=new Map;for(const[t,n]of Object.entries(e.JsUsage))for(const e of n)s.set(e.scriptId,t);const c=t.map((e=>{const t=s.get(e.scriptId);return t?{source:{type:"source-location",url:t,urlProvider:"network",line:e.lineNumber,column:e.columnNumber}}:{
source:{type:"url",value:"(unknown)"}}}));return{score:0,details:i.makeTableDetails(n,c)}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/no-unload-listeners.js")},{"./../lib/i18n/i18n.js":84,"./audit.js":3}],"../audits/non-composited-animations":[function(e,t,n){(function(n){"use strict";const i=e("./audit.js"),a=e("../lib/i18n/i18n.js"),s={title:"Avoid non-composited animations",description:"Animations which are not composited can be janky and increase CLS. [Learn more](https://web.dev/non-composited-animations)",displayValue:"{itemCount, plural,\n  =1 {# animated element found}\n  other {# animated elements found}\n  }",unsupportedCSSProperty:"{propertyCount, plural,\n    =1 {Unsupported CSS Property: {properties}}\n    other {Unsupported CSS Properties: {properties}}\n  }",transformDependsBoxSize:"Transform-related property depends on box size",filterMayMovePixels:"Filter-related property may move pixels",
nonReplaceCompositeMode:'Effect has composite mode other than "replace"',incompatibleAnimations:"Target has another animation which is incompatible",unsupportedTimingParameters:"Effect has unsupported timing parameters"},l=a.createMessageInstanceIdFn(n,s),c=[{flag:8192,text:s.unsupportedCSSProperty},{flag:2048,text:s.transformDependsBoxSize},{flag:4096,text:s.filterMayMovePixels},{flag:16,text:s.nonReplaceCompositeMode},{flag:64,text:s.incompatibleAnimations},{flag:8,text:s.unsupportedTimingParameters}];function getActionableFailureReasons(e,t){return c.filter((t=>e&t.flag)).map((e=>e.text===s.unsupportedCSSProperty?l(e.text,{propertyCount:t.length,properties:t.join(", ")}):l(e.text)))}t.exports=class NonCompositedAnimations extends i{static get meta(){return{id:"non-composited-animations",scoreDisplayMode:i.SCORING_MODES.INFORMATIVE,title:l(s.title),description:l(s.description),requiredArtifacts:["TraceElements","HostUserAgent"]}}static async audit(e){
const t=e.HostUserAgent.match(/Chrome\/(\d+)/);if(!t||Number(t[1])<86)return{score:1,notApplicable:!0};const n=[];let c=!1;e.TraceElements.forEach((e=>{if("animation"!==e.traceEventType)return;const t={type:"node",path:e.node.devtoolsNodePath,selector:e.node.selector,nodeLabel:e.node.nodeLabel,snippet:e.node.snippet},i=e.animations||[],a=new Map;for(const{name:e,failureReasonsMask:t,unsupportedProperties:n}of i){if(!t)continue;const i=getActionableFailureReasons(t,n||[]);for(const t of i){e&&(c=!0);const n=a.get(e)||new Set;n.add(t),a.set(e,n)}}if(!a.size)return;const s=[];for(const[e,t]of a)for(const n of t)s.push({failureReason:n,animation:e});n.push({node:t,subItems:{type:"subitems",items:s}})}));const u=[{key:"node",itemType:"node",subItemsHeading:{key:"failureReason",itemType:"text"},text:l(a.UIStrings.columnElement)}];c&&u.push({key:null,itemType:"text",subItemsHeading:{key:"animation",itemType:"text"},text:l(a.UIStrings.columnName)});const d=i.makeTableDetails(u,n);let m
;return n.length>0&&(m=l(s.displayValue,{itemCount:n.length})),{score:0===n.length?1:0,notApplicable:0===n.length,details:d,displayValue:m}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/non-composited-animations.js")},{"../lib/i18n/i18n.js":84,"./audit.js":3}],"../audits/performance-budget":[function(e,t,n){(function(n){"use strict";const i=e("./audit.js"),a=e("../computed/resource-summary.js"),s=e("../computed/main-resource.js"),l=e("../config/budget.js"),c=e("../lib/i18n/i18n.js"),u={title:"Performance budget",description:"Keep the quantity and size of network requests under the targets set by the provided performance budget. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/budgets).",requestCountOverBudget:"{count, plural,\n    =1 {1 request}\n    other {# requests}\n   }"},d=c.createMessageInstanceIdFn(n,u);t.exports=class ResourceBudget extends i{static get meta(){return{id:"performance-budget",title:d(u.title),description:d(u.description),
scoreDisplayMode:i.SCORING_MODES.INFORMATIVE,requiredArtifacts:["devtoolsLogs","URL"]}}static getRowLabel(e){return{total:c.UIStrings.totalResourceType,document:c.UIStrings.documentResourceType,script:c.UIStrings.scriptResourceType,stylesheet:c.UIStrings.stylesheetResourceType,image:c.UIStrings.imageResourceType,media:c.UIStrings.mediaResourceType,font:c.UIStrings.fontResourceType,other:c.UIStrings.otherResourceType,"third-party":c.UIStrings.thirdPartyResourceType}[e]}static tableItems(e,t){return Object.keys(t).map((n=>{const i=d(this.getRowLabel(n)),a=t[n].count,s=t[n].transferSize;let l,c;if(e.resourceSizes){const t=e.resourceSizes.find((e=>e.resourceType===n));t&&s>1024*t.budget&&(l=s-1024*t.budget)}if(e.resourceCounts){const t=e.resourceCounts.find((e=>e.resourceType===n));if(t&&a>t.budget){const e=a-t.budget;c=d(u.requestCountOverBudget,{count:e})}}return{resourceType:n,label:i,requestCount:a,transferSize:s,countOverBudget:c,sizeOverBudget:l}
})).filter((t=>!(!e.resourceSizes||!e.resourceSizes.some((e=>e.resourceType===t.resourceType)))||!(!e.resourceCounts||!e.resourceCounts.some((e=>e.resourceType===t.resourceType))))).sort(((e,t)=>(t.sizeOverBudget||0)-(e.sizeOverBudget||0)))}static async audit(e,t){const n=e.devtoolsLogs[i.DEFAULT_PASS],u=await a.request({devtoolsLog:n,URL:e.URL},t),m=await s.request({URL:e.URL,devtoolsLog:n},t),p=l.getMatchingBudget(t.settings.budgets,m.url);if(!p)return{score:0,notApplicable:!0};const h=[{key:"label",itemType:"text",text:d(c.UIStrings.columnResourceType)},{key:"requestCount",itemType:"numeric",text:d(c.UIStrings.columnRequests)},{key:"transferSize",itemType:"bytes",text:d(c.UIStrings.columnTransferSize)},{key:"countOverBudget",itemType:"text",text:""},{key:"sizeOverBudget",itemType:"bytes",text:d(c.UIStrings.columnOverBudget)}];return{details:i.makeTableDetails(h,this.tableItems(p,u)),score:1}}},t.exports.UIStrings=u}).call(this,"/lighthouse-core/audits/performance-budget.js")},{
"../computed/main-resource.js":13,"../computed/resource-summary.js":44,"../config/budget.js":52,"../lib/i18n/i18n.js":84,"./audit.js":3}],"../audits/predictive-perf":[function(e,t,n){"use strict";const i=e("./audit.js"),a=e("../report/html/renderer/i18n.js"),s=e("../computed/metrics/lantern-first-contentful-paint.js"),l=e("../computed/metrics/lantern-first-meaningful-paint.js"),c=e("../computed/metrics/lantern-interactive.js"),u=e("../computed/metrics/lantern-first-cpu-idle.js"),d=e("../computed/metrics/lantern-speed-index.js"),m=e("../computed/metrics/lantern-estimated-input-latency.js"),p=e("../computed/metrics/lantern-largest-contentful-paint.js");t.exports=class PredictivePerf extends i{static get meta(){return{id:"predictive-perf",title:"Predicted Performance (beta)",description:"Predicted performance evaluates how your site will perform under a cellular connection on a mobile device.",scoreDisplayMode:i.SCORING_MODES.NUMERIC,requiredArtifacts:["traces","devtoolsLogs"]}}
static async audit(e,t){const n=e.traces[i.DEFAULT_PASS],h=e.devtoolsLogs[i.DEFAULT_PASS],f={},g=await s.request({trace:n,devtoolsLog:h,settings:f},t),y=await l.request({trace:n,devtoolsLog:h,settings:f},t),b=await c.request({trace:n,devtoolsLog:h,settings:f},t),v=await u.request({trace:n,devtoolsLog:h,settings:f},t),w=await d.request({trace:n,devtoolsLog:h,settings:f},t),T=await m.request({trace:n,devtoolsLog:h,settings:f},t),S=await p.request({trace:n,devtoolsLog:h,settings:f},t),E={roughEstimateOfFCP:g.timing,optimisticFCP:g.optimisticEstimate.timeInMs,pessimisticFCP:g.pessimisticEstimate.timeInMs,roughEstimateOfFMP:y.timing,optimisticFMP:y.optimisticEstimate.timeInMs,pessimisticFMP:y.pessimisticEstimate.timeInMs,roughEstimateOfTTI:b.timing,optimisticTTI:b.optimisticEstimate.timeInMs,pessimisticTTI:b.pessimisticEstimate.timeInMs,roughEstimateOfTTFCPUI:v.timing,optimisticTTFCPUI:v.optimisticEstimate.timeInMs,pessimisticTTFCPUI:v.pessimisticEstimate.timeInMs,
roughEstimateOfSI:w.timing,optimisticSI:w.optimisticEstimate.timeInMs,pessimisticSI:w.pessimisticEstimate.timeInMs,roughEstimateOfEIL:T.timing,optimisticEIL:T.optimisticEstimate.timeInMs,pessimisticEIL:T.pessimisticEstimate.timeInMs,roughEstimateOfLCP:S.timing,optimisticLCP:S.optimisticEstimate.timeInMs,pessimisticLCP:S.pessimisticEstimate.timeInMs},x=i.computeLogNormalScore({p10:3651,median:1e4},E.roughEstimateOfTTI),_=new a(t.settings.locale);return{score:x,numericValue:E.roughEstimateOfTTI,numericUnit:"millisecond",displayValue:_.formatMilliseconds(E.roughEstimateOfTTI),details:{type:"debugdata",items:[E]}}}}},{"../computed/metrics/lantern-estimated-input-latency.js":23,"../computed/metrics/lantern-first-contentful-paint.js":24,"../computed/metrics/lantern-first-cpu-idle.js":25,"../computed/metrics/lantern-first-meaningful-paint.js":26,"../computed/metrics/lantern-interactive.js":27,"../computed/metrics/lantern-largest-contentful-paint.js":28,
"../computed/metrics/lantern-speed-index.js":31,"../report/html/renderer/i18n.js":110,"./audit.js":3}],"../audits/preload-fonts":[function(e,t,n){(function(n){"use strict";const i=e("./audit.js"),a=e("./../lib/i18n/i18n.js"),s=e("./../audits/font-display.js"),l=/^(optional)$/,c=e("../computed/network-records.js"),u={title:"Fonts with `font-display: optional` are preloaded",failureTitle:"Fonts with `font-display: optional` are not preloaded",description:"Preload `optional` fonts so first-time visitors may use them. [Learn More](https://web.dev/preload-optional-fonts/)"},d=a.createMessageInstanceIdFn(n,u);class PreloadFontsAudit extends i{static get meta(){return{id:"preload-fonts",title:d(u.title),failureTitle:d(u.failureTitle),description:d(u.description),requiredArtifacts:["devtoolsLogs","URL","CSSUsage"]}}static getURLsAttemptedToPreload(e){const t=e.filter((e=>"Font"===e.resourceType)).filter((e=>e.isLinkPreload)).map((e=>e.url));return new Set(t)}static async audit(e,t){
const n=e.devtoolsLogs[this.DEFAULT_PASS],u=await c.request(n,t),m=s.findFontDisplayDeclarations(e,l).passingURLs,p=PreloadFontsAudit.getURLsAttemptedToPreload(u),h=Array.from(m).filter((e=>!p.has(e))).map((e=>({url:e}))),f=[{key:"url",itemType:"url",text:d(a.UIStrings.columnURL)}];return{score:h.length>0?0:1,details:i.makeTableDetails(f,h),notApplicable:0===m.size}}}t.exports=PreloadFontsAudit,t.exports.UIStrings=u}).call(this,"/lighthouse-core/audits/preload-fonts.js")},{"../computed/network-records.js":42,"./../audits/font-display.js":"../audits/font-display","./../lib/i18n/i18n.js":84,"./audit.js":3}],"../audits/preload-lcp-image":[function(e,t,n){(function(n){"use strict";const i=e("../lib/url-shim.js"),a=e("./audit.js"),s=e("../lib/i18n/i18n.js"),l=e("../computed/main-resource.js"),c=e("../computed/metrics/lantern-largest-contentful-paint.js"),u=e("../computed/load-simulator.js"),d=e("./byte-efficiency/byte-efficiency-audit.js"),m={title:"Preload Largest Contentful Paint image",
description:"Preload the image used by the LCP element in order to improve your LCP time. [Learn more](https://web.dev/optimize-lcp/#preload-important-resources)."},p=s.createMessageInstanceIdFn(n,m);class PreloadLCPImageAudit extends a{static get meta(){return{id:"preload-lcp-image",title:p(m.title),description:p(m.description),requiredArtifacts:["traces","devtoolsLogs","URL","TraceElements","ImageElements"],scoreDisplayMode:a.SCORING_MODES.NUMERIC}}static shouldPreloadRequest(e,t,n){const a=t.redirects?t.redirects.length:0;return!e.isLinkPreload&&(!i.NON_NETWORK_PROTOCOLS.includes(e.protocol)&&(!(n.length<=a)&&e.frameId===t.frameId))}static findLCPNode(e,t){let n,i;return e.traverse(((e,a)=>{"network"===e.type&&e.record.url===t&&(n=e,i=a.slice(1).filter((e=>"network"===e.type)))})),{lcpNode:n,path:i}}static getLCPNodeToPreload(e,t,n,i){if(!n)return;const a=i.find((e=>e.node.devtoolsNodePath===n.node.devtoolsNodePath));if(!a)return
;const s=a.src,{lcpNode:l,path:c}=PreloadLCPImageAudit.findLCPNode(t,s);if(!l||!c)return;return PreloadLCPImageAudit.shouldPreloadRequest(l.record,e,c)?l:void 0}static computeWasteWithGraph(e,t,n){if(!e)return{wastedMs:0,results:[]};const i=t.cloneWithRelationships(),a=new Set;for(const t of e.getDependencies())a.add(t.id);let s=null,l=null;for(const{node:t}of i.traverseGenerator())"network"===t.type&&(t.isMainDocument()?l=t:t.id===e.id&&(s=t));if(!l)throw new Error("Could not find main document node");if(!s)throw new Error("Could not find the LCP node");s.removeAllDependencies(),s.addDependency(l);const c=n.simulate(t,{flexibleOrdering:!0}),u=n.simulate(i,{flexibleOrdering:!0}),d=c.nodeTimings.get(e);if(!d)throw new Error("Impossible - node timings should never be undefined");const m=u.nodeTimings.get(s);if(!m)throw new Error("Impossible - node timings should never be undefined");const p=Array.from(u.nodeTimings.keys()).reduce(((e,t)=>e.set(t.id,t)),new Map);let h=0
;for(const e of Array.from(a)){const t=p.get(e);if(!t)throw new Error("Impossible - node should never be undefined");const n=u.nodeTimings.get(t),i=n&&n.endTime||0;h=Math.max(h,i)}const f=d.endTime-Math.max(m.endTime,h);return{wastedMs:f,results:[{url:e.record.url,wastedMs:f}]}}static async audit(e,t){const n=e.traces[PreloadLCPImageAudit.DEFAULT_PASS],i=e.devtoolsLogs[PreloadLCPImageAudit.DEFAULT_PASS],m=e.URL,h={trace:n,devtoolsLog:i,settings:t.settings},f=e.TraceElements.find((e=>"largest-contentful-paint"===e.traceEventType)),[g,y,b]=await Promise.all([l.request({devtoolsLog:i,URL:m},t),c.request(h,t),u.request(h,t)]),v=y.pessimisticGraph,w=PreloadLCPImageAudit.getLCPNodeToPreload(g,v,f,e.ImageElements),{results:T,wastedMs:S}=PreloadLCPImageAudit.computeWasteWithGraph(w,v,b),E=[{key:"url",valueType:"thumbnail",label:""},{key:"url",valueType:"url",label:p(s.UIStrings.columnURL)},{key:"wastedMs",valueType:"timespanMs",label:p(s.UIStrings.columnWastedMs)
}],x=a.makeOpportunityDetails(E,T,S);return{score:d.scoreForWastedMs(S),numericValue:S,numericUnit:"millisecond",displayValue:S?p(s.UIStrings.displayValueMsSavings,{wastedMs:S}):"",details:x}}}t.exports=PreloadLCPImageAudit,t.exports.UIStrings=m}).call(this,"/lighthouse-core/audits/preload-lcp-image.js")},{"../computed/load-simulator.js":12,"../computed/main-resource.js":13,"../computed/metrics/lantern-largest-contentful-paint.js":28,"../lib/i18n/i18n.js":84,"../lib/url-shim.js":"url","./audit.js":3,"./byte-efficiency/byte-efficiency-audit.js":4}],"../audits/redirects-http":[function(e,t,n){(function(n){"use strict";const i=e("./audit.js"),a=e("../lib/i18n/i18n.js"),s={title:"Redirects HTTP traffic to HTTPS",failureTitle:"Does not redirect HTTP traffic to HTTPS",description:"If you've already set up HTTPS, make sure that you redirect all HTTP traffic to HTTPS in order to enable secure web features for all your users. [Learn more](https://web.dev/redirects-http/)."
},l=a.createMessageInstanceIdFn(n,s);t.exports=class RedirectsHTTP extends i{static get meta(){return{id:"redirects-http",title:l(s.title),failureTitle:l(s.failureTitle),description:l(s.description),requiredArtifacts:["HTTPRedirect"]}}static audit(e){return{score:Number(e.HTTPRedirect.value)}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/redirects-http.js")},{"../lib/i18n/i18n.js":84,"./audit.js":3}],"../audits/redirects":[function(e,t,n){(function(n){"use strict";const i=e("./audit.js"),a=e("./byte-efficiency/byte-efficiency-audit.js"),s=e("../lib/i18n/i18n.js"),l=e("../computed/trace-of-tab.js"),c=e("../computed/network-records.js"),u=e("../computed/main-resource.js"),d=e("../computed/metrics/lantern-interactive.js"),m={title:"Avoid multiple page redirects",description:"Redirects introduce additional delays before the page can be loaded. [Learn more](https://web.dev/redirects/)."},p=s.createMessageInstanceIdFn(n,m);class Redirects extends i{static get meta(){return{
id:"redirects",title:p(m.title),description:p(m.description),scoreDisplayMode:i.SCORING_MODES.NUMERIC,requiredArtifacts:["URL","devtoolsLogs","traces"]}}static getDocumentRequestChain(e,t,n){const i=[];for(const e of n.processEvents){if("navigationStart"!==e.name)continue;const n=e.args.data||{};if(!n.documentLoaderURL||!n.isLoadingMainFrame)continue;let a=t.find((e=>e.url===n.documentLoaderURL));for(;a;)i.push(a),a=a.redirectDestination}return i.length?i:(e.redirects||[]).concat(e)}static async audit(e,t){const n=t.settings,m=e.traces[i.DEFAULT_PASS],h=e.devtoolsLogs[i.DEFAULT_PASS],f=await l.request(m,t),g=await c.request(h,t),y=await u.request({URL:e.URL,devtoolsLog:h},t),b={trace:m,devtoolsLog:h,traceOfTab:f,networkRecords:g,settings:n},v=await d.request(b,t),w=new Map;for(const[e,t]of v.pessimisticEstimate.nodeTimings.entries())"network"===e.type&&w.set(e.record.url,t);const T=Redirects.getDocumentRequestChain(y,g,f);let S=0;const E=[];for(let e=0;e<T.length&&!(T.length<2);e++){
const t=T[e],i=T[e+1]||t,a=w.get(t.url),s=w.get(i.url);if(!a||!s)throw new Error("Could not find redirects in graph");const l=s.startTime-a.startTime,c=i.startTime-t.startTime,u="simulate"===n.throttlingMethod?l:1e3*c;S+=u,E.push({url:t.url,wastedMs:u})}const x=[{key:"url",valueType:"url",label:p(s.UIStrings.columnURL)},{key:"wastedMs",valueType:"timespanMs",label:p(s.UIStrings.columnTimeSpent)}],_=i.makeOpportunityDetails(x,E,S);return{score:T.length<=2?1:a.scoreForWastedMs(S),numericValue:S,numericUnit:"millisecond",displayValue:S?p(s.UIStrings.displayValueMsSavings,{wastedMs:S}):"",details:_}}}t.exports=Redirects,t.exports.UIStrings=m}).call(this,"/lighthouse-core/audits/redirects.js")},{"../computed/main-resource.js":13,"../computed/metrics/lantern-interactive.js":27,"../computed/network-records.js":42,"../computed/trace-of-tab.js":47,"../lib/i18n/i18n.js":84,"./audit.js":3,"./byte-efficiency/byte-efficiency-audit.js":4}],"../audits/resource-summary":[function(e,t,n){(function(n){
"use strict";const i=e("./audit.js"),a=e("../computed/resource-summary.js"),s=e("../lib/i18n/i18n.js"),l={title:"Keep request counts low and transfer sizes small",description:"To set budgets for the quantity and size of page resources, add a budget.json file. [Learn more](https://web.dev/use-lighthouse-for-performance-budgets/).",displayValue:"{requestCount, plural, =1 {1 request • {byteCount, number, bytes} KiB} other {# requests • {byteCount, number, bytes} KiB}}"},c=s.createMessageInstanceIdFn(n,l);t.exports=class ResourceSummary extends i{static get meta(){return{id:"resource-summary",title:c(l.title),description:c(l.description),scoreDisplayMode:i.SCORING_MODES.INFORMATIVE,requiredArtifacts:["devtoolsLogs","URL"]}}static async audit(e,t){const n=e.devtoolsLogs[i.DEFAULT_PASS],u=await a.request({devtoolsLog:n,URL:e.URL},t),d=[{key:"label",itemType:"text",text:c(s.UIStrings.columnResourceType)},{key:"requestCount",itemType:"numeric",text:c(s.UIStrings.columnRequests)},{
key:"transferSize",itemType:"bytes",text:c(s.UIStrings.columnTransferSize)}],m={total:c(s.UIStrings.totalResourceType),document:c(s.UIStrings.documentResourceType),script:c(s.UIStrings.scriptResourceType),stylesheet:c(s.UIStrings.stylesheetResourceType),image:c(s.UIStrings.imageResourceType),media:c(s.UIStrings.mediaResourceType),font:c(s.UIStrings.fontResourceType),other:c(s.UIStrings.otherResourceType),"third-party":c(s.UIStrings.thirdPartyResourceType)},p=Object.keys(u).map((e=>({resourceType:e,label:m[e],requestCount:u[e].count,transferSize:u[e].transferSize}))),h=p.find((e=>"third-party"===e.resourceType))||[],f=p.filter((e=>"third-party"!==e.resourceType)).sort(((e,t)=>t.transferSize-e.transferSize)).concat(h);return{details:i.makeTableDetails(d,f),score:1,displayValue:c(l.displayValue,{requestCount:u.total.count,byteCount:u.total.transferSize})}}},t.exports.UIStrings=l}).call(this,"/lighthouse-core/audits/resource-summary.js")},{"../computed/resource-summary.js":44,
"../lib/i18n/i18n.js":84,"./audit.js":3}],"../audits/screenshot-thumbnails":[function(e,t,n){"use strict";const i=e("./audit.js"),a=e("../lib/lh-error.js"),s=e("jpeg-js"),l=e("../computed/speedline.js"),c=e("../computed/metrics/interactive.js");class ScreenshotThumbnails extends i{static get meta(){return{id:"screenshot-thumbnails",scoreDisplayMode:i.SCORING_MODES.INFORMATIVE,title:"Screenshot Thumbnails",description:"This is what the load of your site looked like.",requiredArtifacts:["traces","devtoolsLogs"]}}static scaleImageToThumbnail(e){const t=120,n=e.width/t,i=Math.floor(e.height/n),a=new Uint8Array(t*i*4);for(let s=0;s<t;s++)for(let l=0;l<i;l++){const i=Math.floor(s*n),c=4*(Math.floor(l*n)*e.width+i),u=4*(l*t+s);a[u]=e.data[c],a[u+1]=e.data[c+1],a[u+2]=e.data[c+2],a[u+3]=e.data[c+3]}return{width:t,height:i,data:a}}static async audit(e,t){const n=e.traces[i.DEFAULT_PASS],u=new Map,d=await l.request(n,t);let m=t.options.minimumTimelineDuration||3e3
;if("simulate"!==t.settings.throttlingMethod){const a={trace:n,devtoolsLog:e.devtoolsLogs[i.DEFAULT_PASS],settings:t.settings},s=c.request(a,t);try{m=Math.max((await s).timing,m)}catch(e){}}const p=[],h=d.frames.filter((e=>!e.isProgressInterpolated())),f=d.complete||Math.max(...d.frames.map((e=>e.getTimeStamp()-d.beginning))),g=Math.max(f,m);if(!h.length||!Number.isFinite(g))throw new a(a.errors.INVALID_SPEEDLINE);for(let e=1;e<=10;e++){const t=d.beginning+g*e/10;let n,i=null;10===e?i=h[h.length-1]:h.forEach((e=>{e.getTimeStamp()<=t&&(i=e)}));const a=u.get(i);if(a)n=a;else{const e=i.getParsedImage(),t=ScreenshotThumbnails.scaleImageToThumbnail(e);n=s.encode(t,90).data.toString("base64"),u.set(i,n)}p.push({timing:Math.round(t-d.beginning),timestamp:1e3*t,data:"data:image/jpeg;base64,"+n})}return{score:1,details:{type:"filmstrip",scale:g,items:p}}}}t.exports=ScreenshotThumbnails},{"../computed/metrics/interactive.js":22,"../computed/speedline.js":46,"../lib/lh-error.js":92,
"./audit.js":3,"jpeg-js":148}],"../audits/script-treemap-data":[function(e,t,n){"use strict";const i=e("./audit.js"),a=e("../computed/js-bundles.js"),s=e("../computed/unused-javascript-summary.js"),l=e("../computed/module-duplication.js");class ScriptTreemapDataAudit extends i{static get meta(){return{id:"script-treemap-data",scoreDisplayMode:i.SCORING_MODES.INFORMATIVE,title:"Script Treemap Data",description:"Used for treemap app",requiredArtifacts:["traces","devtoolsLogs","SourceMaps","ScriptElements","JsUsage","URL"]}}static prepareTreemapNodes(e,t){function newNode(e){return{name:e,resourceBytes:0}}const n=newNode(e);function addAllNodesInSourcePath(t,i){let a=n;n.resourceBytes+=i.resourceBytes,i.unusedBytes&&(n.unusedBytes=(n.unusedBytes||0)+i.unusedBytes);const s=t.replace(e,"").split(/\/+/);s.forEach(((e,t)=>{const n=t===s.length-1;let l=a.children&&a.children.find((t=>t.name===e));l||(l=newNode(e),a.children=a.children||[],a.children.push(l)),a=l,
a.resourceBytes+=i.resourceBytes,i.unusedBytes&&(a.unusedBytes=(a.unusedBytes||0)+i.unusedBytes),n&&void 0!==i.duplicatedNormalizedModuleName&&(a.duplicatedNormalizedModuleName=i.duplicatedNormalizedModuleName)}))}for(const[e,n]of Object.entries(t))addAllNodesInSourcePath(e,n);return function collapseAll(e){for(;e.children&&1===e.children.length;)e.name+="/"+e.children[0].name,e.children=e.children[0].children;if(e.children)for(const t of e.children)collapseAll(t)}(n),n}static async makeRootNodes(e,t){const n=[];let i=0;for(const t of e.ScriptElements)t.src||(i+=(t.content||"").length);if(i){const t=e.URL.finalUrl;n.push({name:t,node:{name:t,resourceBytes:i}})}const c=await a.request(e,t),u=await l.request(e,t);for(const i of e.ScriptElements){if(!i.src)continue;const a=i.src,d=c.find((e=>i.src===e.script.src)),m=e.JsUsage[i.src]||[];if(!d&&0===m.length){n.push({name:a,node:{name:a,resourceBytes:i.src.length}});continue}const p=await s.request({url:i.src,scriptCoverages:m,bundle:d},t)
;let h;if(d&&!("errorMessage"in d.sizes)){const e={};for(const t of Object.keys(d.sizes.files)){const n={resourceBytes:d.sizes.files[t]};p.sourcesWastedBytes&&(n.unusedBytes=p.sourcesWastedBytes[t]);let i=t;d.rawMap.sourceRoot&&t.startsWith(d.rawMap.sourceRoot)&&(i=t.replace(d.rawMap.sourceRoot,""));const a=l.normalizeSource(i);u.has(a)&&(n.duplicatedNormalizedModuleName=a),e[t]=n}h=this.prepareTreemapNodes(d.rawMap.sourceRoot||"",e)}else h={name:a,resourceBytes:p.totalBytes,unusedBytes:p.wastedBytes};n.push({name:a,node:h})}return n}static async audit(e,t){return{score:1,details:{type:"debugdata",treemapData:await ScriptTreemapDataAudit.makeRootNodes(e,t)}}}}t.exports=ScriptTreemapDataAudit},{"../computed/js-bundles.js":11,"../computed/module-duplication.js":40,"../computed/unused-javascript-summary.js":49,"./audit.js":3}],"../audits/seo/canonical":[function(e,t,n){(function(n){"use strict"
;const i=e("../audit.js"),a=e("../../lib/url-shim.js"),s=e("../../computed/main-resource.js"),l=e("../../lib/i18n/i18n.js"),c={title:"Document has a valid `rel=canonical`",failureTitle:"Document does not have a valid `rel=canonical`",description:"Canonical links suggest which URL to show in search results. [Learn more](https://web.dev/canonical/).",explanationConflict:"Multiple conflicting URLs ({urlList})",explanationInvalid:"Invalid URL ({url})",explanationRelative:"Relative URL ({url})",explanationPointsElsewhere:"Points to another `hreflang` location ({url})",explanationDifferentDomain:"Points to a different domain ({url})",explanationRoot:"Points to the domain's root URL (the homepage), instead of an equivalent page of content"},u=l.createMessageInstanceIdFn(n,c);class Canonical extends i{static get meta(){return{id:"canonical",title:u(c.title),failureTitle:u(c.failureTitle),description:u(c.description),requiredArtifacts:["LinkElements","URL","devtoolsLogs"]}}
static collectCanonicalURLs(e){const t=new Set,n=new Set;let i,s;for(const l of e)if("body"!==l.source)if("canonical"===l.rel){if(!l.hrefRaw)continue;l.href?a.isValid(l.hrefRaw)?t.add(l.href):s=l:i=l}else"alternate"===l.rel&&l.href&&l.hreflang&&n.add(l.href);return{uniqueCanonicalURLs:t,hreflangURLs:n,invalidCanonicalLink:i,relativeCanonicallink:s}}static findInvalidCanonicalURLReason(e){const{uniqueCanonicalURLs:t,invalidCanonicalLink:n,relativeCanonicallink:i}=e;if(n)return{score:0,explanation:u(c.explanationInvalid,{url:n.hrefRaw})};if(i)return{score:0,explanation:u(c.explanationRelative,{url:i.hrefRaw})};const a=Array.from(t);return 0===a.length?{score:1,notApplicable:!0}:a.length>1?{score:0,explanation:u(c.explanationConflict,{urlList:a.join(", ")})}:void 0}static findCommonCanonicalURLMistakes(e,t,n){const{hreflangURLs:i}=e;return i.has(n.href)&&i.has(t.href)&&n.href!==t.href?{score:0,explanation:u(c.explanationPointsElsewhere,{url:n.href})
}:a.rootDomainsMatch(t,n)?t.origin===n.origin&&"/"===t.pathname&&"/"!==n.pathname?{score:0,explanation:u(c.explanationRoot)}:void 0:{score:0,explanation:u(c.explanationDifferentDomain,{url:t.href})}}static async audit(e,t){const n=e.devtoolsLogs[i.DEFAULT_PASS],l=await s.request({devtoolsLog:n,URL:e.URL},t),c=new a(l.url),u=Canonical.collectCanonicalURLs(e.LinkElements),d=Canonical.findInvalidCanonicalURLReason(u);if(d)return d;const m=new a([...u.uniqueCanonicalURLs][0]),p=Canonical.findCommonCanonicalURLMistakes(u,m,c);return p||{score:1}}}t.exports=Canonical,t.exports.UIStrings=c}).call(this,"/lighthouse-core/audits/seo/canonical.js")},{"../../computed/main-resource.js":13,"../../lib/i18n/i18n.js":84,"../../lib/url-shim.js":"url","../audit.js":3}],"../audits/seo/crawlable-anchors":[function(e,t,n){(function(n){"use strict";const i=e("../audit.js"),a=e("../../lib/i18n/i18n.js"),s={title:"Links are crawlable",failureTitle:"Links are not crawlable",
description:"Search engines may use `href` attributes on links to crawl websites. Ensure that the `href` attribute of anchor elements links to an appropriate destination, so more pages of the site can be discovered. [Learn More](https://support.google.com/webmasters/answer/9112205)",columnFailingLink:"Uncrawlable Link"},l=a.createMessageInstanceIdFn(n,s);t.exports=class CrawlableAnchors extends i{static get meta(){return{id:"crawlable-anchors",title:l(s.title),failureTitle:l(s.failureTitle),description:l(s.description),requiredArtifacts:["AnchorElements"]}}static audit({AnchorElements:e}){const t=e.filter((({rawHref:e,listeners:t=[],onclick:n="",name:i="",role:a=""})=>{if(n=n.replace(/\s/g,""),e=e.replace(/\s/g,""),i=i.trim(),(a=a.trim()).length>0)return;if(e.startsWith("mailto:"))return;if(e.startsWith("file:"))return!0;if(/window\.location=/.test(n))return!0;if(/window\.open\(/.test(n))return!0
;return t.some((({type:e})=>"click"===e))||i.length>0?void 0:""===e||(!!/javascript:void(\(|)0(\)|)/.test(e)||void 0)})),n=[{key:"node",itemType:"node",text:l(s.columnFailingLink)}],a=t.map((e=>({node:{type:"node",path:e.node.devtoolsNodePath||"",selector:e.node.selector||"",nodeLabel:e.node.nodeLabel||"",snippet:e.node.snippet||""}})));return{score:Number(0===t.length),details:i.makeTableDetails(n,a)}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/seo/crawlable-anchors.js")},{"../../lib/i18n/i18n.js":84,"../audit.js":3}],"../audits/seo/font-size":[function(e,t,n){(function(n){"use strict";const i=e("../../lib/i18n/i18n.js"),a=e("../audit.js"),s=e("../../computed/viewport-meta.js"),l={title:"Document uses legible font sizes",failureTitle:"Document doesn't use legible font sizes",
description:"Font sizes less than 12px are too small to be legible and require mobile visitors to “pinch to zoom” in order to read. Strive to have >60% of page text ≥12px. [Learn more](https://web.dev/font-size/).",displayValue:"{decimalProportion, number, extendedPercent} legible text",explanationViewport:"Text is illegible because there's no viewport meta tag optimized for mobile screens.",additionalIllegibleText:"Add'l illegible text",legibleText:"Legible text",columnSelector:"Selector",columnPercentPageText:"% of Page Text",columnFontSize:"Font Size"},c=i.createMessageInstanceIdFn(n,l);function getSelector(e){const t=function getAttributeMap(e=[]){const t=new Map;for(let n=0;n<e.length;n+=2){const i=e[n].toLowerCase(),a=e[n+1].trim();a&&t.set(i,a)}return t}(e.attributes);if(t.has("id"))return"#"+t.get("id");{const e=t.get("class");if(e)return"."+e.split(/\s+/).join(".")}return e.nodeName.toLowerCase()}function nodeToTableNode(e){
const t=(e.attributes||[]).map(((e,t)=>t%2==0?" "+e:`="${e}"`)).join("");return{type:"node",selector:e.parentNode?getSelector(e.parentNode):"",snippet:`<${e.nodeName.toLowerCase()}${t}>`}}t.exports=class FontSize extends a{static get meta(){return{id:"font-size",title:c(l.title),failureTitle:c(l.failureTitle),description:c(l.description),requiredArtifacts:["FontSize","URL","MetaElements"]}}static async audit(e,t){if("desktop"===t.settings.formFactor)return{score:1,notApplicable:!0};if(!(await s.request(e.MetaElements,t)).isMobileOptimized)return{score:0,explanation:c(l.explanationViewport)};const{analyzedFailingNodesData:n,analyzedFailingTextLength:u,failingTextLength:d,totalTextLength:m}=e.FontSize;if(0===m)return{score:1};const p=function getUniqueFailingRules(e){const t=new Map;return e.forEach((e=>{const{nodeId:n,cssRule:i,fontSize:a,textLength:s,parentNode:l}=e,c=function getFontArtifactId(e,t){if(e&&"Regular"===e.type){
const t=e.range?e.range.startLine:0,n=e.range?e.range.startColumn:0;return`${e.styleSheetId}@${t}:${n}`}return"node_"+t}(i,n),u=t.get(c);u?u.textLength+=s:t.set(c,{nodeId:n,parentNode:l,cssRule:i,fontSize:a,textLength:s})})),[...t.values()]}(n),h=(m-d)/m*100,f=e.URL.finalUrl,g=[{key:"source",itemType:"source-location",text:c(i.UIStrings.columnSource)},{key:"selector",itemType:"code",text:c(l.columnSelector)},{key:"coverage",itemType:"text",text:c(l.columnPercentPageText)},{key:"fontSize",itemType:"text",text:c(l.columnFontSize)}],y=p.sort(((e,t)=>t.textLength-e.textLength)).map((({cssRule:e,textLength:t,fontSize:n,parentNode:i})=>{const a=t/m*100,s=function findStyleRuleSource(e,t,n){if(!t||"Attributes"===t.type||"Inline"===t.type)return{source:{type:"url",value:e},selector:nodeToTableNode(n)};if(t.parentRule&&"user-agent"===t.parentRule.origin)return{source:{type:"code",value:"User Agent Stylesheet"},selector:t.parentRule.selectors.map((e=>e.text)).join(", ")};let i=""
;t.parentRule&&(i=t.parentRule.selectors.map((e=>e.text)).join(", "));if(t.stylesheet&&!t.stylesheet.sourceURL)return{source:{type:"code",value:"dynamic"},selector:i};if(t.stylesheet&&t.range){const{range:e,stylesheet:n}=t,a=n.hasSourceURL?"comment":"network";let s=e.startLine,l=e.startColumn;return n.isInline&&"comment"!==a&&(s+=n.startLine,0===e.startLine&&(l+=n.startColumn)),{source:{type:"source-location",url:n.sourceURL,urlProvider:a,line:s,column:l},selector:i}}return{selector:i,source:{type:"code",value:"Unknown"}}}(f,e,i);return{source:s.source,selector:s.selector,coverage:a.toFixed(2)+"%",fontSize:n+"px"}}));if(u<d){const e=(d-u)/m*100;y.push({source:{type:"code",value:c(l.additionalIllegibleText)},selector:"",coverage:e.toFixed(2)+"%",fontSize:"< 12px"})}h>0&&y.push({source:{type:"code",value:c(l.legibleText)},selector:"",coverage:h.toFixed(2)+"%",fontSize:"≥ 12px"});const b=c(l.displayValue,{decimalProportion:h/100}),v=a.makeTableDetails(g,y);return{score:Number(h>=60),
details:v,displayValue:b}}},t.exports.UIStrings=l}).call(this,"/lighthouse-core/audits/seo/font-size.js")},{"../../computed/viewport-meta.js":51,"../../lib/i18n/i18n.js":84,"../audit.js":3}],"../audits/seo/hreflang":[function(require,module,exports){(function(__filename){"use strict";const Audit=require("../audit.js"),i18n=require("../../lib/i18n/i18n.js"),axeLibSource=require("../../lib/axe.js").source,VALID_LANGS=importValidLangs(),NO_LANGUAGE="x-default",UIStrings={title:"Document has a valid `hreflang`",failureTitle:"Document doesn't have a valid `hreflang`",description:"hreflang links tell search engines what version of a page they should list in search results for a given language or region. [Learn more](https://web.dev/hreflang/).",unexpectedLanguage:"Unexpected language code",notFullyQualified:"Relative href value"},str_=i18n.createMessageInstanceIdFn(__filename,UIStrings);function importValidLangs(){const window={getComputedStyle:()=>{}};return eval(axeLibSource),
window.axe.utils.validLangs()}function isFullyQualified(e){return e.startsWith("http:")||e.startsWith("https:")}function isExpectedLanguageCode(e){if(e.toLowerCase()===NO_LANGUAGE)return!0;const[t]=e.split("-");return VALID_LANGS.includes(t.toLowerCase())}class Hreflang extends Audit{static get meta(){return{id:"hreflang",title:str_(UIStrings.title),failureTitle:str_(UIStrings.failureTitle),description:str_(UIStrings.description),requiredArtifacts:["LinkElements","URL"]}}static audit({LinkElements:e}){const t=[],n=e.filter((e=>{const t="alternate"===e.rel,n=e.hreflang,i="body"===e.source;return t&&n&&!i}));for(const e of n){const n=[];let i;isExpectedLanguageCode(e.hreflang)||n.push(str_(UIStrings.unexpectedLanguage)),isFullyQualified(e.hrefRaw.toLowerCase())||n.push(str_(UIStrings.notFullyQualified)),"head"===e.source?i={type:"node",snippet:`<link rel="alternate" hreflang="${e.hreflang}" href="${e.hrefRaw}" />`,path:null!==e.node?e.node.devtoolsNodePath:"",
selector:null!==e.node?e.node.selector:"",nodeLabel:null!==e.node?e.node.nodeLabel:""}:"headers"===e.source&&(i=`Link: <${e.hrefRaw}>; rel="alternate"; hreflang="${e.hreflang}"`),i&&n.length&&t.push({source:i,subItems:{type:"subitems",items:n.map((e=>({reason:e})))}})}const i=Audit.makeTableDetails([{key:"source",itemType:"code",subItemsHeading:{key:"reason",itemType:"text"},text:""}],t);return{score:Number(0===t.length),details:i}}}module.exports=Hreflang,module.exports.UIStrings=UIStrings}).call(this,"/lighthouse-core/audits/seo/hreflang.js")},{"../../lib/axe.js":70,"../../lib/i18n/i18n.js":84,"../audit.js":3}],"../audits/seo/http-status-code":[function(e,t,n){(function(n){"use strict";const i=e("../audit.js"),a=e("../../computed/main-resource.js"),s=e("../../lib/i18n/i18n.js"),l={title:"Page has successful HTTP status code",failureTitle:"Page has unsuccessful HTTP status code",
description:"Pages with unsuccessful HTTP status codes may not be indexed properly. [Learn more](https://web.dev/http-status-code/)."},c=s.createMessageInstanceIdFn(n,l);t.exports=class HTTPStatusCode extends i{static get meta(){return{id:"http-status-code",title:c(l.title),failureTitle:c(l.failureTitle),description:c(l.description),requiredArtifacts:["devtoolsLogs","URL"]}}static audit(e,t){const n=e.devtoolsLogs[i.DEFAULT_PASS],s=e.URL;return a.request({devtoolsLog:n,URL:s},t).then((e=>{const t=e.statusCode;return t>=400&&t<=599?{score:0,displayValue:""+t}:{score:1}}))}},t.exports.UIStrings=l}).call(this,"/lighthouse-core/audits/seo/http-status-code.js")},{"../../computed/main-resource.js":13,"../../lib/i18n/i18n.js":84,"../audit.js":3}],"../audits/seo/is-crawlable":[function(e,t,n){(function(n){"use strict"
;const i=e("../audit.js"),a=e("robots-parser"),s=e("../../lib/url-shim.js"),l=e("../../computed/main-resource.js"),c=new Set(["noindex","none"]),u="unavailable_after",d=e("../../lib/i18n/i18n.js"),m={title:"Page isn’t blocked from indexing",failureTitle:"Page is blocked from indexing",description:"Search engines are unable to include your pages in search results if they don't have permission to crawl them. [Learn more](https://web.dev/is-crawable/)."},p=d.createMessageInstanceIdFn(n,m);function hasBlockingDirective(e){return e.split(",").map((e=>e.toLowerCase().trim())).some((e=>c.has(e)||function isUnavailable(e){const t=e.split(":");if(t.length<=1||t[0]!==u)return!1;const n=Date.parse(t.slice(1).join(":"));return!isNaN(n)&&n<Date.now()}(e)))}t.exports=class IsCrawlable extends i{static get meta(){return{id:"is-crawlable",title:p(m.title),failureTitle:p(m.failureTitle),description:p(m.description),requiredArtifacts:["MetaElements","RobotsTxt","URL","devtoolsLogs"]}}static audit(e,t){
const n=e.devtoolsLogs[i.DEFAULT_PASS],c=e.MetaElements.find((e=>"robots"===e.name));return l.request({devtoolsLog:n,URL:e.URL},t).then((t=>{const n=[];if(c){const e=c.content||"";hasBlockingDirective(e)&&n.push({source:{type:"node",snippet:`<meta name="robots" content="${e}" />`}})}if(t.responseHeaders&&t.responseHeaders.filter((e=>"x-robots-tag"===e.name.toLowerCase()&&!function hasUserAgent(e){const t=e.match(/^([^,:]+):/);return!!t&&t[1].toLowerCase()!==u}(e.value)&&hasBlockingDirective(e.value))).forEach((e=>n.push({source:`${e.name}: ${e.value}`}))),e.RobotsTxt.content){const i=new s("/robots.txt",t.url),l=a(i.href,e.RobotsTxt.content);if(!l.isAllowed(t.url)){const e=l.getMatchingLineNumber(t.url)||1;n.push({source:{type:"source-location",url:i.href,urlProvider:"network",line:e-1,column:0}})}}const l=i.makeTableDetails([{key:"source",itemType:"code",text:"Blocking Directive Source"}],n);return{score:Number(0===n.length),details:l}}))}},t.exports.UIStrings=m
}).call(this,"/lighthouse-core/audits/seo/is-crawlable.js")},{"../../computed/main-resource.js":13,"../../lib/i18n/i18n.js":84,"../../lib/url-shim.js":"url","../audit.js":3,"robots-parser":210}],"../audits/seo/link-text":[function(e,t,n){(function(n){"use strict";const i=e("../audit.js"),a=e("../../lib/url-shim.js"),s=new Set(["click here","click this","go","here","information","learn more","more","more info","more information","right here","read more","see more","start","this","ここをクリック","こちらをクリック","リンク","続きを読む","続く","全文表示","click aquí","click aqui","clicka aquí","clicka aqui","pincha aquí","pincha aqui","aquí","aqui","más","mas","más información","más informacion","mas información","mas informacion","este","enlace","este enlace","empezar","clique aqui","ir","mais informação","mais informações","mais","veja mais","여기","여기를 클릭","클릭","링크","자세히","자세히 보기","계속","이동","전체 보기","här","klicka här","läs mer","mer","mer info","mer information"]),l=e("../../lib/i18n/i18n.js"),c={
title:"Links have descriptive text",failureTitle:"Links do not have descriptive text",description:"Descriptive link text helps search engines understand your content. [Learn more](https://web.dev/link-text/).",displayValue:"{itemCount, plural,\n    =1 {1 link found}\n    other {# links found}\n    }"},u=l.createMessageInstanceIdFn(n,c);t.exports=class LinkText extends i{static get meta(){return{id:"link-text",title:u(c.title),failureTitle:u(c.failureTitle),description:u(c.description),requiredArtifacts:["URL","AnchorElements"]}}static audit(e){const t=e.AnchorElements.filter((e=>e.href&&!e.rel.includes("nofollow"))).filter((t=>{const n=t.href.toLowerCase();return!(n.startsWith("javascript:")||n.startsWith("mailto:")||a.equalWithExcludedFragments(t.href,e.URL.finalUrl))&&s.has(t.text.trim().toLowerCase())})).map((e=>({href:e.href,text:e.text.trim()}))),n=i.makeTableDetails([{key:"href",itemType:"url",text:"Link destination"},{key:"text",itemType:"text",text:"Link Text"}],t,{});let l
;return t.length&&(l=u(c.displayValue,{itemCount:t.length})),{score:Number(0===t.length),details:n,displayValue:l}}},t.exports.UIStrings=c}).call(this,"/lighthouse-core/audits/seo/link-text.js")},{"../../lib/i18n/i18n.js":84,"../../lib/url-shim.js":"url","../audit.js":3}],"../audits/seo/manual/structured-data":[function(e,t,n){(function(n){"use strict";const i=e("../../manual/manual-audit.js"),a=e("../../../lib/i18n/i18n.js"),s={description:"Run the [Structured Data Testing Tool](https://search.google.com/structured-data/testing-tool/) and the [Structured Data Linter](http://linter.structured-data.org/) to validate structured data. [Learn more](https://web.dev/structured-data/).",title:"Structured data is valid"},l=a.createMessageInstanceIdFn(n,s);t.exports=class StructuredData extends i{static get meta(){return Object.assign({id:"structured-data",description:l(s.description),title:l(s.title)},super.partialMeta)}},t.exports.UIStrings=s
}).call(this,"/lighthouse-core/audits/seo/manual/structured-data.js")},{"../../../lib/i18n/i18n.js":84,"../../manual/manual-audit.js":6}],"../audits/seo/meta-description":[function(e,t,n){(function(n){"use strict";const i=e("../audit.js"),a=e("../../lib/i18n/i18n.js"),s={title:"Document has a meta description",failureTitle:"Document does not have a meta description",description:"Meta descriptions may be included in search results to concisely summarize page content. [Learn more](https://web.dev/meta-description/).",explanation:"Description text is empty."},l=a.createMessageInstanceIdFn(n,s);t.exports=class Description extends i{static get meta(){return{id:"meta-description",title:l(s.title),failureTitle:l(s.failureTitle),description:l(s.description),requiredArtifacts:["MetaElements"]}}static audit(e){const t=e.MetaElements.find((e=>"description"===e.name));if(!t)return{score:0};return 0===(t.content||"").trim().length?{score:0,explanation:l(s.explanation)}:{score:1}}},
t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/seo/meta-description.js")},{"../../lib/i18n/i18n.js":84,"../audit.js":3}],"../audits/seo/plugins":[function(e,t,n){(function(n){"use strict";const i=e("../audit.js"),a=e("../../lib/url-shim.js"),s="application/x-java-applet",l="application/x-java-bean",c=new Set(["application/x-shockwave-flash",s,l,"application/x-silverlight","application/x-silverlight-2"]),u=new Set(["swf","flv","class","xap"]),d=new Set(["code","movie","source","src"]),m=e("../../lib/i18n/i18n.js"),p={title:"Document avoids plugins",failureTitle:"Document uses plugins",description:"Search engines can't index plugin content, and many devices restrict plugins or don't support them. [Learn more](https://web.dev/plugins/)."},h=m.createMessageInstanceIdFn(n,p);function isPluginURL(e){try{const t=new a(e,"http://example.com").pathname.split(".");if(t.length<2)return!1;const n=t[t.length-1];return u.has(n.trim().toLowerCase())}catch(e){return!1}}
t.exports=class Plugins extends i{static get meta(){return{id:"plugins",title:h(p.title),failureTitle:h(p.failureTitle),description:h(p.description),requiredArtifacts:["EmbeddedContent"]}}static audit(e){const t=e.EmbeddedContent.filter((e=>{if("APPLET"===e.tagName)return!0;if(("EMBED"===e.tagName||"OBJECT"===e.tagName)&&e.type&&function isPluginType(e){return e=e.trim().toLowerCase(),c.has(e)||e.startsWith(s)||e.startsWith(l)}(e.type))return!0;const t=e.src||e.code;if("EMBED"===e.tagName&&t&&isPluginURL(t))return!0;if("OBJECT"===e.tagName&&e.data&&isPluginURL(e.data))return!0;return e.params.filter((e=>d.has(e.name.trim().toLowerCase())&&isPluginURL(e.value))).length>0})).map((e=>{const t=e.tagName.toLowerCase();return{source:{type:"node",snippet:`<${t}${["src","data","code","type"].reduce(((t,n)=>(null!==e[n]&&(t+=` ${n}="${e[n]}"`),t)),"")}>${e.params.filter((e=>d.has(e.name.trim().toLowerCase()))).map((e=>`<param ${e.name}="${e.value}" />`)).join("")}</${t}>`}}
})),n=i.makeTableDetails([{key:"source",itemType:"code",text:"Element source"}],t);return{score:Number(0===t.length),details:n}}},t.exports.UIStrings=p}).call(this,"/lighthouse-core/audits/seo/plugins.js")},{"../../lib/i18n/i18n.js":84,"../../lib/url-shim.js":"url","../audit.js":3}],"../audits/seo/robots-txt":[function(e,t,n){(function(n){"use strict";const i=e("../audit.js"),a=e("../../lib/url-shim.js"),s="sitemap",l="user-agent",c="allow",u="disallow",d=new Set([c,u]),m=new Set([l,u,c,s,"crawl-delay","clean-param","host","request-rate","visit-time","noindex"]),p=new Set(["https:","http:","ftp:"]),h=e("../../lib/i18n/i18n.js"),f={title:"robots.txt is valid",failureTitle:"robots.txt is not valid",description:"If your robots.txt file is malformed, crawlers may not be able to understand how you want your website to be crawled or indexed. [Learn more](https://web.dev/robots-txt/).",displayValueHttpBadCode:"Request for robots.txt returned HTTP status: {statusCode}",
displayValueValidationError:"{itemCount, plural,\n    =1 {1 error found}\n    other {# errors found}\n    }",explanation:"Lighthouse was unable to download a robots.txt file"},g=h.createMessageInstanceIdFn(n,f);function parseLine(e){const t=e.indexOf("#");if(-1!==t&&(e=e.substr(0,t)),0===(e=e.trim()).length)return null;const n=e.indexOf(":");if(-1===n)throw new Error("Syntax not understood");const i=e.slice(0,n).trim().toLowerCase(),d=e.slice(n+1).trim();return function verifyDirective(e,t){if(!m.has(e))throw new Error("Unknown directive");if(e===s){let e;try{e=new a(t)}catch(e){throw new Error("Invalid sitemap URL")}if(!p.has(e.protocol))throw new Error("Invalid sitemap URL protocol")}if(e===l&&!t)throw new Error("No user-agent specified");if(e===c||e===u){if(""!==t&&"/"!==t[0]&&"*"!==t[0])throw new Error('Pattern should either be empty, start with "/" or "*"');const e=t.indexOf("$");if(-1!==e&&e!==t.length-1)throw new Error('"$" should only be used at the end of the pattern')}}(i,d),
{directive:i,value:d}}t.exports=class RobotsTxt extends i{static get meta(){return{id:"robots-txt",title:g(f.title),failureTitle:g(f.failureTitle),description:g(f.description),requiredArtifacts:["RobotsTxt"]}}static audit(e){const{status:t,content:n}=e.RobotsTxt;if(!t)return{score:0,explanation:g(f.explanation)};if(t>=500)return{score:0,displayValue:g(f.displayValueHttpBadCode,{statusCode:t})};if(t>=400||""===n)return{score:1,notApplicable:!0};if(null===n)throw new Error(`Status ${t} was valid, but content was null`);const a=function validateRobots(e){const t=[];let n=!1;return e.split(/\r\n|\r|\n/).forEach(((e,i)=>{let a;try{a=parseLine(e)}catch(n){t.push({index:(i+1).toString(),line:e,message:n.message.toString()})}a&&(a.directive===l?n=!0:!n&&d.has(a.directive)&&t.push({index:(i+1).toString(),line:e,message:"No user-agent specified"}))})),t}(n),s=i.makeTableDetails([{key:"index",itemType:"text",text:"Line #"},{key:"line",itemType:"code",text:"Content"},{key:"message",
itemType:"code",text:"Error"}],a,{});let c;return a.length&&(c=g(f.displayValueValidationError,{itemCount:a.length})),{score:Number(0===a.length),details:s,displayValue:c}}},t.exports.UIStrings=f}).call(this,"/lighthouse-core/audits/seo/robots-txt.js")},{"../../lib/i18n/i18n.js":84,"../../lib/url-shim.js":"url","../audit.js":3}],"../audits/seo/tap-targets":[function(e,t,n){(function(n){"use strict";const i=e("../audit.js"),a=e("../../computed/viewport-meta.js"),{rectsTouchOrOverlap:s,getRectOverlapArea:l,getRectAtCenter:c,allRectsContainedWithinEachOther:u,getLargestRect:d,getBoundingRectWithPadding:m,getBoundingRect:p}=e("../../lib/rect-helpers.js"),{getTappableRectsFromClientRects:h}=e("../../lib/tappable-rects.js"),f=e("../../lib/i18n/i18n.js"),g={title:"Tap targets are sized appropriately",failureTitle:"Tap targets are not sized appropriately",
description:"Interactive elements like buttons and links should be large enough (48x48px), and have enough space around them, to be easy enough to tap without overlapping onto other elements. [Learn more](https://web.dev/tap-targets/).",tapTargetHeader:"Tap Target",overlappingTargetHeader:"Overlapping Target",explanationViewportMetaNotOptimized:"Tap targets are too small because there's no viewport meta tag optimized for mobile screens",displayValue:"{decimalProportion, number, percent} appropriately sized tap targets"},y=f.createMessageInstanceIdFn(n,g);function clientRectBelowMinimumSize(e){return e.width<48||e.height<48}function getOverlapFailureForTargetPair(e,t){let n=null;for(const i of e){const e=c(i,48),a=l(e,i);for(const i of t){const t=l(e,i),s=t/a;s<.25||(!n||s>n.overlapScoreRatio)&&(n={overlapScoreRatio:s,tapTargetScore:a,overlappingTargetScore:t})}}return n}function targetToTableNode(e){const t=p(e.clientRects);return{type:"node",lhId:e.node.lhId,snippet:e.node.snippet,
path:e.node.devtoolsNodePath,selector:e.node.selector,boundingRect:t,nodeLabel:e.node.nodeLabel}}class TapTargets extends i{static get meta(){return{id:"tap-targets",title:y(g.title),failureTitle:y(g.failureTitle),description:y(g.description),requiredArtifacts:["MetaElements","TapTargets"]}}static async audit(e,t){if("desktop"===t.settings.formFactor)return{score:1,notApplicable:!0};if(!(await a.request(e.MetaElements,t)).isMobileOptimized)return{score:0,explanation:y(g.explanationViewportMetaNotOptimized)};const n=function getBoundedTapTargets(e){return e.map((e=>({tapTarget:e,paddedBoundsRect:m(e.clientRects,48)})))}(e.TapTargets),l=function getAllOverlapFailures(e,t){const n=[];return e.forEach((e=>{const i=h(e.tapTarget.clientRects);for(const a of t){if(a===e)continue;if(!s(e.paddedBoundsRect,a.paddedBoundsRect))continue;if(e.tapTarget.href===a.tapTarget.href&&/https?:\/\//.test(e.tapTarget.href))continue;const t=a.tapTarget.clientRects;if(u(i,t))continue
;const l=getOverlapFailureForTargetPair(i,t);l&&n.push({...l,tapTarget:e.tapTarget,overlappingTarget:a.tapTarget})}})),n}(function getTooSmallTargets(e){return e.filter((e=>e.tapTarget.clientRects.every(clientRectBelowMinimumSize)))}(n),n),c=function getTableItems(e){const t=e.map((e=>{const t=d(e.tapTarget.clientRects),n=Math.floor(t.width),i=Math.floor(t.height),a=n+"x"+i;return{tapTarget:targetToTableNode(e.tapTarget),overlappingTarget:targetToTableNode(e.overlappingTarget),tapTargetScore:e.tapTargetScore,overlappingTargetScore:e.overlappingTargetScore,overlapScoreRatio:e.overlapScoreRatio,size:a,width:n,height:i}}));return t.sort(((e,t)=>t.overlapScoreRatio-e.overlapScoreRatio)),t}(function mergeSymmetricFailures(e){const t=[];return e.forEach(((n,i)=>{const a=e.find((e=>e.tapTarget===n.overlappingTarget&&e.overlappingTarget===n.tapTarget));if(!a)return void t.push(n);const{overlapScoreRatio:s}=n,{overlapScoreRatio:l}=a;(s>l||s===l&&i<e.indexOf(a))&&t.push(n)})),t}(l)),p=[{
key:"tapTarget",itemType:"node",text:y(g.tapTargetHeader)},{key:"size",itemType:"text",text:y(f.UIStrings.columnSize)},{key:"overlappingTarget",itemType:"node",text:y(g.overlappingTargetHeader)}],b=i.makeTableDetails(p,c),v=e.TapTargets.length,w=new Set(l.map((e=>e.tapTarget))).size;let T=1,S=1;w>0&&(S=(v-w)/v,T=.89*S);return{score:T,details:b,displayValue:y(g.displayValue,{decimalProportion:S})}}}TapTargets.FINGER_SIZE_PX=48,t.exports=TapTargets,t.exports.UIStrings=g}).call(this,"/lighthouse-core/audits/seo/tap-targets.js")},{"../../computed/viewport-meta.js":51,"../../lib/i18n/i18n.js":84,"../../lib/rect-helpers.js":98,"../../lib/tappable-rects.js":103,"../audit.js":3}],"../audits/server-response-time":[function(e,t,n){(function(n){"use strict";const i=e("./audit.js"),a=e("../lib/i18n/i18n.js"),s=e("../computed/main-resource.js"),l={title:"Initial server response time was short",failureTitle:"Reduce initial server response time",
description:"Keep the server response time for the main document short because all other requests depend on it. [Learn more](https://web.dev/time-to-first-byte/).",displayValue:"Root document took {timeInMs, number, milliseconds} ms"},c=a.createMessageInstanceIdFn(n,l);class ServerResponseTime extends i{static get meta(){return{id:"server-response-time",title:c(l.title),failureTitle:c(l.failureTitle),description:c(l.description),requiredArtifacts:["devtoolsLogs","URL"]}}static calculateResponseTime(e){const t=e.timing;return t?t.receiveHeadersEnd-t.sendEnd:0}static async audit(e,t){const n=e.devtoolsLogs[i.DEFAULT_PASS],u=await s.request({devtoolsLog:n,URL:e.URL},t),d=ServerResponseTime.calculateResponseTime(u),m=d<600,p=c(l.displayValue,{timeInMs:d}),h=[{key:"url",valueType:"url",label:c(a.UIStrings.columnURL)},{key:"responseTime",valueType:"timespanMs",label:c(a.UIStrings.columnTimeSpent)}],f=i.makeOpportunityDetails(h,[{url:u.url,responseTime:d}],d-100);return{numericValue:d,
numericUnit:"millisecond",score:Number(m),displayValue:p,details:f}}}t.exports=ServerResponseTime,t.exports.UIStrings=l}).call(this,"/lighthouse-core/audits/server-response-time.js")},{"../computed/main-resource.js":13,"../lib/i18n/i18n.js":84,"./audit.js":3}],"../audits/service-worker":[function(e,t,n){(function(n){"use strict";const i=e("../lib/url-shim.js"),a=e("./audit.js"),s=e("../lib/i18n/i18n.js"),l={title:"Registers a service worker that controls page and `start_url`",failureTitle:"Does not register a service worker that controls page and `start_url`",description:"The service worker is the technology that enables your app to use many Progressive Web App features, such as offline, add to homescreen, and push notifications. [Learn more](https://web.dev/service-worker/).",explanationOutOfScope:"This origin has one or more service workers, however the page ({pageUrl}) is not in scope.",
explanationNoManifest:"This page is controlled by a service worker, however no `start_url` was found because no manifest was fetched.",explanationBadManifest:"This page is controlled by a service worker, however no `start_url` was found because manifest failed to parse as valid JSON",explanationBadStartUrl:"This page is controlled by a service worker, however the `start_url` ({startUrl}) is not in the service worker's scope ({scopeUrl})"},c=s.createMessageInstanceIdFn(n,l);class ServiceWorker extends a{static get meta(){return{id:"service-worker",title:c(l.title),failureTitle:c(l.failureTitle),description:c(l.description),requiredArtifacts:["URL","ServiceWorker","WebAppManifest"]}}static getVersionsForOrigin(e,t){return e.filter((e=>"activated"===e.status)).filter((e=>new i(e.scriptURL).origin===t.origin))}static getControllingServiceWorker(e,t,n){const a=[];for(const n of e){const e=t.find((e=>e.registrationId===n.registrationId));if(e){
const t=new i(e.scopeURL).href,s=new i(n.scriptURL).href;a.push({scopeUrl:t,scriptUrl:s})}}return a.filter((e=>n.href.startsWith(e.scopeUrl))).sort(((e,t)=>e.scopeUrl.length-t.scopeUrl.length)).pop()}static checkStartUrl(e,t){if(!e)return c(l.explanationNoManifest);if(!e.value)return c(l.explanationBadManifest);const n=e.value.start_url.value;return n.startsWith(t)?void 0:c(l.explanationBadStartUrl,{startUrl:n,scopeUrl:t})}static audit(e){const t=new i(e.URL.finalUrl),{versions:n,registrations:a}=e.ServiceWorker,s=ServiceWorker.getVersionsForOrigin(n,t);if(0===s.length)return{score:0};const u=ServiceWorker.getControllingServiceWorker(s,a,t);if(!u)return{score:0,explanation:c(l.explanationOutOfScope,{pageUrl:t.href})};const{scriptUrl:d,scopeUrl:m}=u,p={type:"debugdata",scriptUrl:d,scopeUrl:m},h=ServiceWorker.checkStartUrl(e.WebAppManifest,u.scopeUrl);return h?{score:0,details:p,explanation:h}:{score:1,details:p}}}t.exports=ServiceWorker,t.exports.UIStrings=l
}).call(this,"/lighthouse-core/audits/service-worker.js")},{"../lib/i18n/i18n.js":84,"../lib/url-shim.js":"url","./audit.js":3}],"../audits/splash-screen":[function(e,t,n){(function(n){"use strict";const i=e("./multi-check-audit.js"),a=e("../computed/manifest-values.js"),s=e("../lib/i18n/i18n.js"),l={title:"Configured for a custom splash screen",failureTitle:"Is not configured for a custom splash screen",description:"A themed splash screen ensures a high-quality experience when users launch your app from their homescreens. [Learn more](https://web.dev/splash-screen/)."},c=s.createMessageInstanceIdFn(n,l);class SplashScreen extends i{static get meta(){return{id:"splash-screen",title:c(l.title),failureTitle:c(l.failureTitle),description:c(l.description),requiredArtifacts:["WebAppManifest","InstallabilityErrors"]}}static assessManifest(e,t){if(e.isParseFailure&&e.parseFailureReason)return void t.push(e.parseFailureReason)
;const n=["hasName","hasBackgroundColor","hasThemeColor","hasIconsAtLeast512px"];e.allChecks.filter((e=>n.includes(e.id))).forEach((e=>{e.passing||t.push(e.failureText)}))}static async audit_(e,t){const n=[],i=await a.request(e,t);return SplashScreen.assessManifest(i,n),{failures:n,manifestValues:i}}}t.exports=SplashScreen,t.exports.UIStrings=l}).call(this,"/lighthouse-core/audits/splash-screen.js")},{"../computed/manifest-values.js":15,"../lib/i18n/i18n.js":84,"./multi-check-audit.js":7}],"../audits/themed-omnibox":[function(e,t,n){(function(n){"use strict";const i=e("./multi-check-audit.js"),a=e("../computed/manifest-values.js"),s=e("cssstyle/lib/parsers"),l=e("../lib/i18n/i18n.js"),c={title:"Sets a theme color for the address bar.",failureTitle:"Does not set a theme color for the address bar.",description:"The browser address bar can be themed to match your site. [Learn more](https://web.dev/themed-omnibox/)."},u=l.createMessageInstanceIdFn(n,c);class ThemedOmnibox extends i{
static get meta(){return{id:"themed-omnibox",title:u(c.title),failureTitle:u(c.failureTitle),description:u(c.description),requiredArtifacts:["WebAppManifest","InstallabilityErrors","MetaElements"]}}static isValidColor(e){return s.valueType(e)===s.TYPES.COLOR}static assessMetaThemecolor(e,t){e?ThemedOmnibox.isValidColor(e.content||"")||t.push("The theme-color meta tag did not contain a valid CSS color"):t.push('No `<meta name="theme-color">` tag found')}static assessManifest(e,t){if(e.isParseFailure&&e.parseFailureReason)return void t.push(e.parseFailureReason);const n=e.allChecks.find((e=>"hasThemeColor"===e.id));n&&!n.passing&&t.push(n.failureText)}static async audit_(e,t){const n=[],i=e.MetaElements.find((e=>"theme-color"===e.name)),s=await a.request(e,t);return ThemedOmnibox.assessManifest(s,n),ThemedOmnibox.assessMetaThemecolor(i,n),{failures:n,manifestValues:s,themeColor:i&&i.content||null}}}t.exports=ThemedOmnibox,t.exports.UIStrings=c
}).call(this,"/lighthouse-core/audits/themed-omnibox.js")},{"../computed/manifest-values.js":15,"../lib/i18n/i18n.js":84,"./multi-check-audit.js":7,"cssstyle/lib/parsers":133}],"../audits/third-party-facades":[function(e,t,n){(function(n){"use strict";const i=e("./audit.js"),a=e("../lib/i18n/i18n.js"),s=e("../lib/third-party-web.js"),l=e("../computed/network-records.js"),c=e("../computed/main-resource.js"),u=e("../computed/main-thread-tasks.js"),d=e("./third-party-summary.js"),m={title:"Lazy load third-party resources with facades",failureTitle:"Some third-party resources can be lazy loaded with a facade",description:"Some third-party embeds can be lazy loaded. Consider replacing them with a facade until they are required. [Learn more](https://web.dev/third-party-facades/).",displayValue:"{itemCount, plural,\n  =1 {# facade alternative available}\n  other {# facade alternatives available}\n  }",columnProduct:"Product",categoryVideo:"{productName} (Video)",
categoryCustomerSuccess:"{productName} (Customer Success)",categoryMarketing:"{productName} (Marketing)",categorySocial:"{productName} (Social)"},p=a.createMessageInstanceIdFn(n,m),h={video:m.categoryVideo,"customer-success":m.categoryCustomerSuccess,marketing:m.categoryMarketing,social:m.categorySocial};class ThirdPartyFacades extends i{static get meta(){return{id:"third-party-facades",title:p(m.title),failureTitle:p(m.failureTitle),description:p(m.description),requiredArtifacts:["traces","devtoolsLogs","URL"]}}static condenseItems(e){e.sort(((e,t)=>t.transferSize-e.transferSize));let t=e.findIndex((e=>e.transferSize<1e3))||1;if((-1===t||t>5)&&(t=5),t>=e.length-1)return;const n=e.splice(t).reduce(((e,t)=>(e.transferSize+=t.transferSize,e.blockingTime+=t.blockingTime,e)));n.transferSize<1e3||(n.url=p(a.UIStrings.otherResourcesLabel),e.push(n))}static getProductsWithFacade(e,t){const n=new Map;for(const i of e.keys()){const e=s.getEntity(i);if(!e||s.isFirstParty(i,t))continue
;const a=s.getProduct(i);a&&a.facades&&a.facades.length&&(n.has(a.name)||n.set(a.name,{product:a,entity:e}))}return Array.from(n.values())}static async audit(e,t){const n=t.settings,f=e.traces[i.DEFAULT_PASS],g=e.devtoolsLogs[i.DEFAULT_PASS],y=await l.request(g,t),b=await c.request({devtoolsLog:g,URL:e.URL},t),v=s.getEntity(b.url),w=await u.request(f,t),T="simulate"===n.throttlingMethod?n.throttling.cpuSlowdownMultiplier:1,S=d.getSummaries(y,w,T),E=ThirdPartyFacades.getProductsWithFacade(S.byURL,v),x=[];for(const{product:e,entity:t}of E){const n=h[e.categories[0]];let i;i=n?p(n,{productName:e.name}):e.name;const a=S.urls.get(t),s=S.byEntity.get(t);if(!a||!s)continue;const l=Array.from(a).map((e=>({url:e,...S.byURL.get(e)})));this.condenseItems(l),x.push({product:i,transferSize:s.transferSize,blockingTime:s.blockingTime,subItems:{type:"subitems",items:l}})}if(!x.length)return{score:1,notApplicable:!0};const _=[{key:"product",itemType:"text",subItemsHeading:{key:"url",itemType:"url"},
text:p(m.columnProduct)},{key:"transferSize",itemType:"bytes",subItemsHeading:{key:"transferSize"},granularity:1,text:p(a.UIStrings.columnTransferSize)},{key:"blockingTime",itemType:"ms",subItemsHeading:{key:"blockingTime"},granularity:1,text:p(a.UIStrings.columnBlockingTime)}];return{score:0,displayValue:p(m.displayValue,{itemCount:x.length}),details:i.makeTableDetails(_,x)}}}t.exports=ThirdPartyFacades,t.exports.UIStrings=m}).call(this,"/lighthouse-core/audits/third-party-facades.js")},{"../computed/main-resource.js":13,"../computed/main-thread-tasks.js":14,"../computed/network-records.js":42,"../lib/i18n/i18n.js":84,"../lib/third-party-web.js":104,"./audit.js":3,"./third-party-summary.js":"../audits/third-party-summary"}],"../audits/third-party-summary":[function(e,t,n){(function(n){"use strict"
;const i=e("./audit.js"),a=e("./bootup-time.js"),s=e("../lib/i18n/i18n.js"),l=e("../lib/third-party-web.js"),c=e("../computed/network-records.js"),u=e("../computed/main-resource.js"),d=e("../computed/main-thread-tasks.js"),m={title:"Minimize third-party usage",failureTitle:"Reduce the impact of third-party code",description:"Third-party code can significantly impact load performance. Limit the number of redundant third-party providers and try to load third-party code after your page has primarily finished loading. [Learn more](https://developers.google.com/web/fundamentals/performance/optimizing-content-efficiency/loading-third-party-javascript/).",columnThirdParty:"Third-Party",displayValue:"Third-party code blocked the main thread for {timeInMs, number, milliseconds} ms"},p=s.createMessageInstanceIdFn(n,m);class ThirdPartySummary extends i{static get meta(){return{id:"third-party-summary",title:p(m.title),failureTitle:p(m.failureTitle),description:p(m.description),
requiredArtifacts:["traces","devtoolsLogs","URL"]}}static getSummaries(e,t,n){const i=new Map,s=new Map,c={mainThreadTime:0,blockingTime:0,transferSize:0};for(const t of e){const e=i.get(t.url)||{...c};e.transferSize+=t.transferSize,i.set(t.url,e)}const u=a.getJavaScriptURLs(e);for(const e of t){const t=a.getAttributableURLForTask(e,u),s=i.get(t)||{...c},l=e.selfTime*n;s.mainThreadTime+=l,s.blockingTime+=Math.max(l-50,0),i.set(t,s)}const d=new Map;for(const[e,t]of i.entries()){const n=l.getEntity(e);if(!n){i.delete(e);continue}const a=s.get(n)||{...c};a.transferSize+=t.transferSize,a.mainThreadTime+=t.mainThreadTime,a.blockingTime+=t.blockingTime,s.set(n,a);const u=d.get(n)||[];u.push(e),d.set(n,u)}return{byURL:i,byEntity:s,urls:d}}static makeSubItems(e,t,n){let i=(t.urls.get(e)||[]).map((e=>({url:e,...t.byURL.get(e)}))).filter((e=>e.transferSize>0)).sort(((e,t)=>t.blockingTime-e.blockingTime||t.transferSize-e.transferSize));const a={transferSize:0,blockingTime:0
},l=Math.max(4096,n.transferSize/20),c=Math.min(5,i.length);let u=0;for(;u<c;){const e=i[u];if(0===e.blockingTime&&e.transferSize<l)break;u++,a.transferSize+=e.transferSize,a.blockingTime+=e.blockingTime}if(!a.blockingTime&&!a.transferSize)return[];i=i.slice(0,u);const d={url:p(s.UIStrings.otherResourcesLabel),transferSize:n.transferSize-a.transferSize,blockingTime:n.blockingTime-a.blockingTime};return d.transferSize>l&&i.push(d),i}static async audit(e,t){const n=t.settings||{},a=e.traces[i.DEFAULT_PASS],h=e.devtoolsLogs[i.DEFAULT_PASS],f=await c.request(h,t),g=await u.request({devtoolsLog:h,URL:e.URL},t),y=l.getEntity(g.url),b=await d.request(a,t),v="simulate"===n.throttlingMethod?n.throttling.cpuSlowdownMultiplier:1,w=ThirdPartySummary.getSummaries(f,b,v),T={wastedBytes:0,wastedMs:0},S=Array.from(w.byEntity.entries()).filter((([e])=>!(y&&y.name===e.name))).map((([e,t])=>(T.wastedBytes+=t.transferSize,T.wastedMs+=t.blockingTime,{...t,entity:{type:"link",text:e.name,url:e.homepage||""
},subItems:{type:"subitems",items:ThirdPartySummary.makeSubItems(e,w,t)}}))).sort(((e,t)=>t.blockingTime-e.blockingTime||t.transferSize-e.transferSize)),E=[{key:"entity",itemType:"link",text:p(m.columnThirdParty),subItemsHeading:{key:"url",itemType:"url"}},{key:"transferSize",granularity:1,itemType:"bytes",text:p(s.UIStrings.columnTransferSize),subItemsHeading:{key:"transferSize"}},{key:"blockingTime",granularity:1,itemType:"ms",text:p(s.UIStrings.columnBlockingTime),subItemsHeading:{key:"blockingTime"}}];return S.length?{score:Number(T.wastedMs<=250),displayValue:p(m.displayValue,{timeInMs:T.wastedMs}),details:i.makeTableDetails(E,S,T)}:{score:1,notApplicable:!0}}}t.exports=ThirdPartySummary,t.exports.UIStrings=m}).call(this,"/lighthouse-core/audits/third-party-summary.js")},{"../computed/main-resource.js":13,"../computed/main-thread-tasks.js":14,"../computed/network-records.js":42,"../lib/i18n/i18n.js":84,"../lib/third-party-web.js":104,"./audit.js":3,
"./bootup-time.js":"../audits/bootup-time"}],"../audits/timing-budget":[function(e,t,n){(function(n){"use strict";const i=e("./audit.js"),a=e("../computed/metrics/timing-summary.js"),s=e("../computed/main-resource.js"),l=e("../config/budget.js"),c=e("../lib/i18n/i18n.js"),u={title:"Timing budget",description:"Set a timing budget to help you keep an eye on the performance of your site. Performant sites load fast and respond to user input events quickly. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/budgets).",columnTimingMetric:"Metric",columnMeasurement:"Measurement"},d=c.createMessageInstanceIdFn(n,u);t.exports=class TimingBudget extends i{static get meta(){return{id:"timing-budget",title:d(u.title),description:d(u.description),scoreDisplayMode:i.SCORING_MODES.INFORMATIVE,requiredArtifacts:["devtoolsLogs","traces","URL"]}}static getRowLabel(e){const t={"first-contentful-paint":c.UIStrings.firstContentfulPaintMetric,
"first-cpu-idle":c.UIStrings.firstCPUIdleMetric,interactive:c.UIStrings.interactiveMetric,"first-meaningful-paint":c.UIStrings.firstMeaningfulPaintMetric,"max-potential-fid":c.UIStrings.maxPotentialFIDMetric,"estimated-input-latency":c.UIStrings.estimatedInputLatencyMetric,"total-blocking-time":c.UIStrings.totalBlockingTimeMetric,"speed-index":c.UIStrings.speedIndexMetric,"largest-contentful-paint":c.UIStrings.largestContentfulPaintMetric,"cumulative-layout-shift":c.UIStrings.cumulativeLayoutShiftMetric};return d(t[e])}static getMeasurement(e,t){return{"first-contentful-paint":t.firstContentfulPaint,"first-cpu-idle":t.firstCPUIdle,interactive:t.interactive,"first-meaningful-paint":t.firstMeaningfulPaint,"max-potential-fid":t.maxPotentialFID,"estimated-input-latency":t.estimatedInputLatency,"total-blocking-time":t.totalBlockingTime,"speed-index":t.speedIndex,"largest-contentful-paint":t.largestContentfulPaint,"cumulative-layout-shift":t.cumulativeLayoutShift}[e]}static tableItems(e,t){
let n=[];if(!e.timings)return n;n=e.timings.map((e=>{const n=e.metric,i=this.getRowLabel(n),a=this.getMeasurement(n,t);return{metric:n,label:i,measurement:a,overBudget:a&&a>e.budget?a-e.budget:void 0}})).sort(((e,t)=>(t.overBudget||0)-(e.overBudget||0)));const i=n.find((e=>"cumulative-layout-shift"===e.metric));return i&&("object"!=typeof i.measurement&&(i.measurement={type:"numeric",value:Number(i.measurement),granularity:.01}),"object"!=typeof i.overBudget&&(i.overBudget={type:"numeric",value:Number(i.overBudget),granularity:.01})),n}static async audit(e,t){const n=e.devtoolsLogs[i.DEFAULT_PASS],m=e.traces[i.DEFAULT_PASS],p=await s.request({URL:e.URL,devtoolsLog:n},t),h=(await a.request({trace:m,devtoolsLog:n},t)).metrics,f=l.getMatchingBudget(t.settings.budgets,p.url);if(!f)return{score:0,notApplicable:!0};const g=[{key:"label",itemType:"text",text:d(u.columnTimingMetric)},{key:"measurement",itemType:"ms",text:d(u.columnMeasurement)},{key:"overBudget",itemType:"ms",
text:d(c.UIStrings.columnOverBudget)}];return{details:i.makeTableDetails(g,this.tableItems(f,h)),score:1}}},t.exports.UIStrings=u}).call(this,"/lighthouse-core/audits/timing-budget.js")},{"../computed/main-resource.js":13,"../computed/metrics/timing-summary.js":38,"../config/budget.js":52,"../lib/i18n/i18n.js":84,"./audit.js":3}],"../audits/unsized-images":[function(e,t,n){(function(n){"use strict";const i=e("./audit.js"),a=e("./../lib/i18n/i18n.js"),s=e("./../lib/url-shim.js"),l={title:"Image elements have explicit `width` and `height`",failureTitle:"Image elements do not have explicit `width` and `height`",description:"Set an explicit width and height on image elements to reduce layout shifts and improve CLS. [Learn more](https://web.dev/optimize-cls/#images-without-dimensions)"},c=a.createMessageInstanceIdFn(n,l);class UnsizedImages extends i{static get meta(){return{id:"unsized-images",title:c(l.title),failureTitle:c(l.failureTitle),description:c(l.description),
requiredArtifacts:["ImageElements"]}}static isValidAttr(e){return/^\d+$/.test(e)&&!/^0+$/.test(e)}static isValidCss(e){return!!e&&"auto"!==e}static isSizedImage(e){const t=e.attributeWidth,n=e.attributeHeight,i=e.cssWidth,a=e.cssHeight,s=UnsizedImages.isValidAttr(t),l=UnsizedImages.isValidCss(i),c=UnsizedImages.isValidAttr(n),u=UnsizedImages.isValidCss(a);return(s||l)&&(c||u)}static async audit(e){const t=e.ImageElements.filter((e=>!e.isCss&&!e.isInShadowDOM)),n=[];for(const e of t){if("fixed"===e.cssComputedPosition||"absolute"===e.cssComputedPosition||UnsizedImages.isSizedImage(e))continue;const t=s.elideDataURI(e.src);n.push({url:t,node:{type:"node",path:e.node.devtoolsNodePath,selector:e.node.selector,nodeLabel:e.node.nodeLabel,snippet:e.node.snippet}})}const l=[{key:"url",itemType:"thumbnail",text:""},{key:"url",itemType:"url",text:c(a.UIStrings.columnURL)},{key:"node",itemType:"node",text:c(a.UIStrings.columnFailingElem)}];return{score:n.length>0?0:1,notApplicable:0===t.length,
details:i.makeTableDetails(l,n)}}}t.exports=UnsizedImages,t.exports.UIStrings=l}).call(this,"/lighthouse-core/audits/unsized-images.js")},{"./../lib/i18n/i18n.js":84,"./../lib/url-shim.js":"url","./audit.js":3}],"../audits/user-timings":[function(e,t,n){(function(n){"use strict";const i=e("./audit.js"),a=e("../lib/i18n/i18n.js"),s=e("../computed/user-timings.js"),l={title:"User Timing marks and measures",description:"Consider instrumenting your app with the User Timing API to measure your app's real-world performance during key user experiences. [Learn more](https://web.dev/user-timings/).",displayValue:"{itemCount, plural,\n    =1 {1 user timing}\n    other {# user timings}\n    }",columnType:"Type"},c=a.createMessageInstanceIdFn(n,l);class UserTimings extends i{static get meta(){return{id:"user-timings",title:c(l.title),description:c(l.description),scoreDisplayMode:i.SCORING_MODES.INFORMATIVE,requiredArtifacts:["traces"]}}static get excludedPrefixes(){return["goog_"]}
static excludeEvent(e){return UserTimings.excludedPrefixes.every((t=>!e.name.startsWith(t)))}static audit(e,t){const n=e.traces[i.DEFAULT_PASS];return s.request(n,t).then((e=>{const t=e.filter(UserTimings.excludeEvent),n=t.map((e=>({name:e.name,startTime:e.startTime,duration:e.isMark?void 0:e.duration,timingType:e.isMark?"Mark":"Measure"}))).sort(((e,t)=>e.timingType===t.timingType?e.startTime-t.startTime:"Measure"===e.timingType?-1:1)),s=[{key:"name",itemType:"text",text:c(a.UIStrings.columnName)},{key:"timingType",itemType:"text",text:c(l.columnType)},{key:"startTime",itemType:"ms",granularity:.01,text:c(a.UIStrings.columnStartTime)},{key:"duration",itemType:"ms",granularity:.01,text:c(a.UIStrings.columnDuration)}],u=i.makeTableDetails(s,n);let d;return t.length&&(d=c(l.displayValue,{itemCount:t.length})),{score:Number(0===t.length),notApplicable:0===t.length,displayValue:d,details:u}}))}}t.exports=UserTimings,t.exports.UIStrings=l
}).call(this,"/lighthouse-core/audits/user-timings.js")},{"../computed/user-timings.js":50,"../lib/i18n/i18n.js":84,"./audit.js":3}],"../audits/uses-rel-preconnect":[function(e,t,n){(function(n){"use strict";const i=e("./audit.js"),a=e("./byte-efficiency/byte-efficiency-audit.js"),s=e("../lib/url-shim.js"),l=e("../lib/i18n/i18n.js"),c=e("../computed/network-records.js"),u=e("../computed/main-resource.js"),d=e("../computed/load-simulator.js"),m=e("../computed/trace-of-tab.js"),p=e("../computed/page-dependency-graph.js"),h=e("../computed/metrics/lantern-largest-contentful-paint.js"),f={title:"Preconnect to required origins",description:"Consider adding `preconnect` or `dns-prefetch` resource hints to establish early connections to important third-party origins. [Learn more](https://web.dev/uses-rel-preconnect/).",
unusedWarning:'A `<link rel=preconnect>` was found for "{securityOrigin}" but was not used by the browser. Only use `preconnect` for important origins that the page will certainly request.',crossoriginWarning:'A `<link rel=preconnect>` was found for "{securityOrigin}" but was not used by the browser. Check that you are using the `crossorigin` attribute properly.',tooManyPreconnectLinksWarning:"More than 2 `<link rel=preconnect>` connections were found. These should be used sparingly and only to the most important origins."},g=l.createMessageInstanceIdFn(n,f);class UsesRelPreconnectAudit extends i{static get meta(){return{id:"uses-rel-preconnect",title:g(f.title),description:g(f.description),requiredArtifacts:["traces","devtoolsLogs","URL","LinkElements"],scoreDisplayMode:i.SCORING_MODES.NUMERIC}}static hasValidTiming(e){return!!e.timing&&e.timing.connectEnd>0&&e.timing.connectStart>0}static hasAlreadyConnectedToOrigin(e){
return!!e.timing&&e.timing.dnsEnd-e.timing.dnsStart==0&&e.timing.connectEnd-e.timing.connectStart==0}static socketStartTimeIsBelowThreshold(e,t){return Math.max(0,e.startTime-t.endTime)<15}static async audit(e,t){const n=e.traces[UsesRelPreconnectAudit.DEFAULT_PASS],y=e.devtoolsLogs[UsesRelPreconnectAudit.DEFAULT_PASS],b=t.settings;let v=0;const w=[],[T,S,E,x,_]=await Promise.all([c.request(y,t),u.request({devtoolsLog:y,URL:e.URL},t),d.request({devtoolsLog:y,settings:b},t),m.request(n,t),p.request({trace:n,devtoolsLog:y},t)]),{rtt:k,additionalRttByOrigin:A}=E.getOptions(),D=await h.getPessimisticGraph(_,x),R=new Set;D.traverse((e=>{"network"===e.type&&R.add(e.record.url)}));const j=new Map;T.forEach((e=>{
if(!UsesRelPreconnectAudit.hasValidTiming(e)||e.initiator.url===S.url||!e.parsedURL||!e.parsedURL.securityOrigin||S.parsedURL.securityOrigin===e.parsedURL.securityOrigin||!R.has(e.url)||UsesRelPreconnectAudit.hasAlreadyConnectedToOrigin(e)||!UsesRelPreconnectAudit.socketStartTimeIsBelowThreshold(e,S))return;const t=e.parsedURL.securityOrigin,n=j.get(t)||[];n.push(e),j.set(t,n)}));const I=e.LinkElements.filter((e=>"preconnect"===e.rel)),C=new Set(I.map((e=>s.getOrigin(e.href||""))));let N=[];j.forEach((e=>{const t=e.reduce(((e,t)=>t.startTime<e.startTime?t:e));if(!t.timing)return;const n=t.parsedURL.securityOrigin,i=A.get(n)||0;let a=k+i;"https"===t.parsedURL.scheme&&(a*=2);const s=1e3*t.startTime-1e3*S.endTime+t.timing.dnsStart,l=Math.min(a,s);l<50||(C.has(n)?w.push(g(f.crossoriginWarning,{securityOrigin:n})):(v=Math.max(l,v),N.push({url:n,wastedMs:l})))})),N=N.sort(((e,t)=>t.wastedMs-e.wastedMs))
;for(const e of C)e&&(T.some((t=>e===t.parsedURL.securityOrigin))||w.push(g(f.unusedWarning,{securityOrigin:e})));if(I.length>=2)return{score:1,warnings:I.length>=3?[...w,g(f.tooManyPreconnectLinksWarning)]:w};const L=[{key:"url",valueType:"url",label:g(l.UIStrings.columnURL)},{key:"wastedMs",valueType:"timespanMs",label:g(l.UIStrings.columnWastedMs)}],M=i.makeOpportunityDetails(L,N,v);return{score:a.scoreForWastedMs(v),numericValue:v,numericUnit:"millisecond",displayValue:v?g(l.UIStrings.displayValueMsSavings,{wastedMs:v}):"",warnings:w,details:M}}}t.exports=UsesRelPreconnectAudit,t.exports.UIStrings=f}).call(this,"/lighthouse-core/audits/uses-rel-preconnect.js")},{"../computed/load-simulator.js":12,"../computed/main-resource.js":13,"../computed/metrics/lantern-largest-contentful-paint.js":28,"../computed/network-records.js":42,"../computed/page-dependency-graph.js":43,"../computed/trace-of-tab.js":47,"../lib/i18n/i18n.js":84,"../lib/url-shim.js":"url","./audit.js":3,
"./byte-efficiency/byte-efficiency-audit.js":4}],"../audits/uses-rel-preload":[function(e,t,n){(function(n){"use strict";const i=e("../lib/url-shim.js"),a=e("./audit.js"),s=e("./byte-efficiency/byte-efficiency-audit.js"),l=e("../computed/critical-request-chains.js"),c=e("../lib/i18n/i18n.js"),u=e("../computed/main-resource.js"),d=e("../computed/page-dependency-graph.js"),m=e("../computed/load-simulator.js"),p={title:"Preload key requests",description:"Consider using `<link rel=preload>` to prioritize fetching resources that are currently requested later in page load. [Learn more](https://web.dev/uses-rel-preload/).",crossoriginWarning:'A preload `<link>` was found for "{preloadURL}" but was not used by the browser. Check that you are using the `crossorigin` attribute properly.'},h=c.createMessageInstanceIdFn(n,p);class UsesRelPreloadAudit extends a{static get meta(){return{id:"uses-rel-preload",title:h(p.title),description:h(p.description),
requiredArtifacts:["devtoolsLogs","traces","URL"],scoreDisplayMode:a.SCORING_MODES.NUMERIC}}static getURLsToPreload(e,t){const n=new Set;return t.traverse(((t,i)=>{if("network"!==t.type)return;const a=i.slice(1).filter((e=>"network"===e.type));UsesRelPreloadAudit.shouldPreloadRequest(t.record,e,a)&&n.add(t.record.url)})),n}static getURLsFailedToPreload(e){const t=[];e.traverse((e=>"network"===e.type&&t.push(e.record)));const n=t.filter((e=>e.isLinkPreload)),i=new Map;for(const e of n){const t=i.get(e.frameId)||new Set;t.add(e.url),i.set(e.frameId,t)}const a=t.filter((e=>{const t=i.get(e.frameId);return!!t&&(!!t.has(e.url)&&!e.isLinkPreload)}));return new Set(a.map((e=>e.url)))}static shouldPreloadRequest(e,t,n){const a=t.redirects?t.redirects.length:0;return!e.isLinkPreload&&(!!l.isCritical(e,t)&&(!i.NON_NETWORK_PROTOCOLS.includes(e.protocol)&&(n.length===a+2&&(e.frameId===t.frameId&&i.rootDomainsMatch(e.url,t.url)))))}static computeWasteWithGraph(e,t,n){if(!e.size)return{wastedMs:0,
results:[]};const i=n.simulate(t,{flexibleOrdering:!0}),a=t.cloneWithRelationships(),s=[];let l=null;if(a.traverse((t=>{"network"===t.type&&(t.isMainDocument()?l=t:t.record&&e.has(t.record.url)&&s.push(t))})),!l)throw new Error("Could not find main document node");for(const e of s)e.removeAllDependencies(),e.addDependency(l);const c=n.simulate(a,{flexibleOrdering:!0}),u=Array.from(i.nodeTimings.keys()).reduce(((e,t)=>e.set(t.record,t)),new Map),d=[];for(const e of s){const t=u.get(e.record),n=c.nodeTimings.get(e),a=i.nodeTimings.get(t);if(!a||!n)throw new Error("Missing preload node");const s=Math.round(a.endTime-n.endTime);s<100||d.push({url:e.record.url,wastedMs:s})}return d.length?{wastedMs:Math.max(...d.map((e=>e.wastedMs))),results:d}:{wastedMs:0,results:d}}static async audit(e,t){const n=e.traces[UsesRelPreloadAudit.DEFAULT_PASS],i=e.devtoolsLogs[UsesRelPreloadAudit.DEFAULT_PASS],l=e.URL,f={trace:n,devtoolsLog:i,settings:t.settings},[g,y,b]=await Promise.all([u.request({
devtoolsLog:i,URL:l},t),d.request({trace:n,devtoolsLog:i},t),m.request(f,t)]),v=UsesRelPreloadAudit.getURLsToPreload(g,y),{results:w,wastedMs:T}=UsesRelPreloadAudit.computeWasteWithGraph(v,y,b);let S;w.sort(((e,t)=>t.wastedMs-e.wastedMs));const E=UsesRelPreloadAudit.getURLsFailedToPreload(y);E.size&&(S=Array.from(E).map((e=>h(p.crossoriginWarning,{preloadURL:e}))));const x=[{key:"url",valueType:"url",label:h(c.UIStrings.columnURL)},{key:"wastedMs",valueType:"timespanMs",label:h(c.UIStrings.columnWastedMs)}],_=a.makeOpportunityDetails(x,w,T);return{score:s.scoreForWastedMs(T),numericValue:T,numericUnit:"millisecond",displayValue:T?h(c.UIStrings.displayValueMsSavings,{wastedMs:T}):"",details:_,warnings:S}}}t.exports=UsesRelPreloadAudit,t.exports.UIStrings=p}).call(this,"/lighthouse-core/audits/uses-rel-preload.js")},{"../computed/critical-request-chains.js":10,"../computed/load-simulator.js":12,"../computed/main-resource.js":13,"../computed/page-dependency-graph.js":43,
"../lib/i18n/i18n.js":84,"../lib/url-shim.js":"url","./audit.js":3,"./byte-efficiency/byte-efficiency-audit.js":4}],"../audits/valid-source-maps":[function(e,t,n){(function(n){"use strict";const i=e("../lib/third-party-web.js"),a=e("./audit.js"),s=e("../lib/i18n/i18n.js"),l={title:"Page has valid source maps",failureTitle:"Missing source maps for large first-party JavaScript",description:"Source maps translate minified code to the original source code. This helps developers debug in production. In addition, Lighthouse is able to provide further insights. Consider deploying source maps to take advantage of these benefits. [Learn more](https://developers.google.com/web/tools/chrome-devtools/javascript/source-maps).",columnMapURL:"Map URL",missingSourceMapErrorMessage:"Large JavaScript file is missing a source map",
missingSourceMapItemsWarningMesssage:"{missingItems, plural,\n    =1 {Warning: missing 1 item in `.sourcesContent`}\n    other {Warning: missing # items in `.sourcesContent`}\n    }"},c=s.createMessageInstanceIdFn(n,l);t.exports=class ValidSourceMaps extends a{static get meta(){return{id:"valid-source-maps",title:c(l.title),failureTitle:c(l.failureTitle),description:c(l.description),requiredArtifacts:["ScriptElements","SourceMaps","URL"]}}static isLargeFirstPartyJS(e,t){if(null===e.content)return!1;const n=e.content.length>=512e3,a=!!e.src&&i.isFirstParty(e.src,i.getEntity(t));return n&&a}static async audit(e){const{SourceMaps:t}=e,n=new Set;let i=!1;const u=[];for(const a of e.ScriptElements){if(!a.src)continue;const s=t.find((e=>e.scriptUrl===a.src)),d=[];if(!this.isLargeFirstPartyJS(a,e.URL.finalUrl)||s&&s.map||(i=!0,n.add(a.src),d.push({error:c(l.missingSourceMapErrorMessage)})),s&&!s.map&&d.push({error:s.errorMessage}),s&&s.map){const e=s.map.sourcesContent||[];let t=0
;for(let n=0;n<s.map.sources.length;n++)(e.length<n||!e[n])&&(t+=1);t>0&&d.push({error:c(l.missingSourceMapItemsWarningMesssage,{missingItems:t})})}(s||d.length)&&u.push({scriptUrl:a.src,sourceMapUrl:s&&s.sourceMapUrl,subItems:{type:"subitems",items:d}})}const d=[{key:"scriptUrl",itemType:"url",subItemsHeading:{key:"error"},text:c(s.UIStrings.columnURL)},{key:"sourceMapUrl",itemType:"url",text:c(l.columnMapURL)}];return u.sort(((e,t)=>{const i=n.has(e.scriptUrl),a=n.has(t.scriptUrl);return i&&!a?-1:!i&&a?1:e.subItems.items.length&&!t.subItems.items.length?-1:!e.subItems.items.length&&t.subItems.items.length?1:t.scriptUrl.localeCompare(e.scriptUrl)})),{score:i?0:1,details:a.makeTableDetails(d,u)}}},t.exports.UIStrings=l}).call(this,"/lighthouse-core/audits/valid-source-maps.js")},{"../lib/i18n/i18n.js":84,"../lib/third-party-web.js":104,"./audit.js":3}],"../audits/viewport":[function(e,t,n){(function(n){"use strict"
;const i=e("./audit.js"),a=e("../computed/viewport-meta.js"),s=e("../lib/i18n/i18n.js"),l={title:'Has a `<meta name="viewport">` tag with `width` or `initial-scale`',failureTitle:'Does not have a `<meta name="viewport">` tag with `width` or `initial-scale`',description:'Add a `<meta name="viewport">` tag to optimize your app for mobile screens. [Learn more](https://web.dev/viewport/).',explanationNoTag:'No `<meta name="viewport">` tag found'},c=s.createMessageInstanceIdFn(n,l);t.exports=class Viewport extends i{static get meta(){return{id:"viewport",title:c(l.title),failureTitle:c(l.failureTitle),description:c(l.description),requiredArtifacts:["MetaElements"]}}static async audit(e,t){const n=await a.request(e.MetaElements,t);return n.hasViewportTag?{score:Number(n.isMobileOptimized),warnings:n.parserWarnings}:{score:0,explanation:c(l.explanationNoTag)}}},t.exports.UIStrings=l}).call(this,"/lighthouse-core/audits/viewport.js")},{"../computed/viewport-meta.js":51,
"../lib/i18n/i18n.js":84,"./audit.js":3}],"../gather/gatherers/accessibility":[function(e,t,n){"use strict";const i=e("./gatherer.js"),a=e("../../lib/axe.js").source,s=e("../../lib/page-functions.js");async function runA11yChecks(){const e=window.axe,t=await e.run(document,{elementRef:!0,runOnly:{type:"tag",values:["wcag2a","wcag2aa"]},resultTypes:["violations","inapplicable"],rules:{tabindex:{enabled:!0},accesskeys:{enabled:!0},"heading-order":{enabled:!0},"meta-viewport":{enabled:!0},"duplicate-id":{enabled:!1},"table-fake-caption":{enabled:!1},"td-has-header":{enabled:!1},marquee:{enabled:!1},"area-alt":{enabled:!1},"html-xml-lang-mismatch":{enabled:!1},blink:{enabled:!1},"server-side-image-map":{enabled:!1},"identical-links-same-purpose":{enabled:!1},"no-autoplay-audio":{enabled:!1},"svg-img-alt":{enabled:!1},"audio-caption":{enabled:!1},"aria-treeitem-name":{enabled:!0}}});document.documentElement.scrollTop=0;const augmentAxeNodes=e=>{e.nodes.forEach((e=>{
e.node=getNodeDetails(e.element),e.element=e.any=e.all=e.none=void 0}));const t=e.error;t instanceof Error&&(e.error={name:t.name,message:t.message,stack:t.stack,errorNode:t.errorNode})};return t.violations.forEach(augmentAxeNodes),t.incomplete.forEach(augmentAxeNodes),{violations:t.violations,notApplicable:t.inapplicable,incomplete:t.incomplete,version:t.testEngine.version}}t.exports=class Accessibility extends i{afterPass(e){const t=e.driver,n=`(function () {\n      ${s.getNodeDetailsString};\n      ${a};\n      return (${runA11yChecks.toString()}());\n    })()`;return t.evaluateAsync(n,{useIsolation:!0}).then((e=>{if(!e)throw new Error("No axe-core results returned");if(!Array.isArray(e.violations))throw new Error("Unable to parse axe results"+e);return e}))}}},{"../../lib/axe.js":70,"../../lib/page-functions.js":97,"./gatherer.js":66}],"../gather/gatherers/anchor-elements":[function(e,t,n){"use strict";const i=e("./gatherer.js"),a=e("../../lib/page-functions.js")
;function collectAnchorElements(){const resolveURLOrEmpty=e=>{try{return new URL(e,window.location.href).href}catch(e){return""}};function getTruncatedOnclick(e){return(e.getAttribute("onclick")||"").slice(0,1024)}return getElementsInDocument("a").map((e=>e instanceof HTMLAnchorElement?{href:e.href,rawHref:e.getAttribute("href")||"",onclick:getTruncatedOnclick(e),role:e.getAttribute("role")||"",name:e.name,text:e.innerText,rel:e.rel,target:e.target,node:getNodeDetails(e)}:{href:resolveURLOrEmpty(e.href.baseVal),rawHref:e.getAttribute("href")||"",onclick:getTruncatedOnclick(e),role:e.getAttribute("role")||"",text:e.textContent||"",rel:"",target:e.target.baseVal||"",node:getNodeDetails(e)}))}t.exports=class AnchorElements extends i{async afterPass(e){const t=e.driver,n=`(() => {\n      ${a.getElementsInDocumentString};\n      ${a.getNodeDetailsString};\n\n      return (${collectAnchorElements})();\n    })()`,i=await t.evaluateAsync(n,{useIsolation:!0});await t.sendCommand("DOM.enable"),
await t.sendCommand("DOM.getDocument",{depth:-1,pierce:!0});const s=i.map((async e=>{const n=await async function getEventListeners(e,t){const n=await e.resolveDevtoolsNodePathToObjectId(t);return n?(await e.sendCommand("DOMDebugger.getEventListeners",{objectId:n})).listeners.map((({type:e})=>({type:e}))):[]}(t,e.node.devtoolsNodePath);return{...e,listeners:n}})),l=await Promise.all(s);return await t.sendCommand("DOM.disable"),l}}},{"../../lib/page-functions.js":97,"./gatherer.js":66}],"../gather/gatherers/cache-contents":[function(e,t,n){"use strict";const i=e("./gatherer.js");function getCacheContents(){return caches.keys().then((e=>Promise.all(e.map((e=>caches.open(e)))))).then((e=>{const t=[];return Promise.all(e.map((e=>e.keys().then((e=>{t.push(...e.map((e=>e.url)))}))))).then((e=>t))}))}t.exports=class CacheContents extends i{async afterPass(e){const t=e.driver,n=await t.evaluateAsync(`(${getCacheContents.toString()}())`)
;if(!n||!Array.isArray(n))throw new Error("Unable to retrieve cache contents");return n}}},{"./gatherer.js":66}],"../gather/gatherers/console-messages":[function(e,t,n){"use strict";const i=e("./gatherer.js");function remoteObjectToString(e){if(void 0!==e.value||"undefined"===e.type)return String(e.value);if("string"==typeof e.description&&e.description!==e.className)return e.description;return`[${e.subtype||e.type} ${e.className||"Object"}]`}t.exports=class ConsoleMessages extends i{constructor(){super(),this._logEntries=[],this._onConsoleAPICalled=this.onConsoleAPICalled.bind(this),this._onExceptionThrown=this.onExceptionThrown.bind(this),this._onLogEntryAdded=this.onLogEntry.bind(this)}onConsoleAPICalled(e){const{type:t}=e;if("warning"!==t&&"error"!==t)return;const n=(e.args||[]).map(remoteObjectToString).join(" ");if(!n&&!e.stackTrace)return;const{url:i,lineNumber:a,columnNumber:s}=e.stackTrace&&e.stackTrace.callFrames[0]||{},l={eventType:"consoleAPI",
source:"warning"===t?"console.warn":"console.error",level:t,text:n,stackTrace:e.stackTrace,timestamp:e.timestamp,url:i,lineNumber:a,columnNumber:s};this._logEntries.push(l)}onExceptionThrown(e){const t=e.exceptionDetails.exception?e.exceptionDetails.exception.description:e.exceptionDetails.text;if(!t)return;const n={eventType:"exception",source:"exception",level:"error",text:t,stackTrace:e.exceptionDetails.stackTrace,timestamp:e.timestamp,url:e.exceptionDetails.url,lineNumber:e.exceptionDetails.lineNumber,columnNumber:e.exceptionDetails.columnNumber};this._logEntries.push(n)}onLogEntry(e){const{source:t,level:n,text:i,stackTrace:a,timestamp:s,url:l,lineNumber:c}=e.entry;this._logEntries.push({eventType:"protocolLog",source:t,level:n,text:i,stackTrace:a,timestamp:s,url:l,lineNumber:c})}async beforePass(e){const t=e.driver;t.on("Log.entryAdded",this._onLogEntryAdded),await t.sendCommand("Log.enable"),await t.sendCommand("Log.startViolationsReport",{config:[{name:"discouragedAPIUse",
threshold:-1}]}),t.on("Runtime.consoleAPICalled",this._onConsoleAPICalled),t.on("Runtime.exceptionThrown",this._onExceptionThrown),await t.sendCommand("Runtime.enable")}async afterPass({driver:e}){return await e.sendCommand("Log.stopViolationsReport"),await e.off("Log.entryAdded",this._onLogEntryAdded),await e.sendCommand("Log.disable"),await e.off("Runtime.consoleAPICalled",this._onConsoleAPICalled),await e.off("Runtime.exceptionThrown",this._onExceptionThrown),await e.sendCommand("Runtime.disable"),this._logEntries}}},{"./gatherer.js":66}],"../gather/gatherers/css-usage":[function(e,t,n){"use strict";const i=e("./gatherer.js");t.exports=class CSSUsage extends i{async afterPass(e){const t=e.driver,n=[],onStylesheetAdded=e=>n.push(e);t.on("CSS.styleSheetAdded",onStylesheetAdded),await t.sendCommand("DOM.enable"),await t.sendCommand("CSS.enable"),await t.sendCommand("CSS.startRuleUsageTracking"),await t.evaluateAsync("getComputedStyle(document.body)"),
t.off("CSS.styleSheetAdded",onStylesheetAdded);const i=n.map((e=>{const n=e.header.styleSheetId;return t.sendCommand("CSS.getStyleSheetText",{styleSheetId:n}).then((t=>({header:e.header,content:t.text})))})),a=await Promise.all(i),s=await t.sendCommand("CSS.stopRuleUsageTracking");await t.sendCommand("CSS.disable"),await t.sendCommand("DOM.disable");const l=new Map(a.map((e=>[e.content,e])));return{rules:s.ruleUsage,stylesheets:Array.from(l.values())}}}},{"./gatherer.js":66}],"../gather/gatherers/dobetterweb/appcache":[function(e,t,n){"use strict";const i=e("../gatherer.js");t.exports=class AppCacheManifest extends i{afterPass(e){return e.driver.querySelector("html").then((e=>e&&e.getAttribute("manifest")))}}},{"../gatherer.js":66}],"../gather/gatherers/dobetterweb/doctype":[function(e,t,n){"use strict";const i=e("../gatherer.js");function getDoctype(){if(!document.doctype)return null;const{name:e,publicId:t,systemId:n}=document.doctype;return{name:e,publicId:t,systemId:n}}
t.exports=class Doctype extends i{afterPass(e){return e.driver.evaluateAsync(`(${getDoctype.toString()}())`)}}},{"../gatherer.js":66}],"../gather/gatherers/dobetterweb/domstats":[function(e,t,n){"use strict";const i=e("../gatherer.js"),a=e("../../../lib/page-functions.js");function getDOMStats(e,t=!0){let n=null,i=-1,a=-1,s=0,l=null;const _calcDOMWidthAndHeight=function(e,c=1){c>i&&(n=e,i=c),e.children.length>a&&(l=e,a=e.children.length);let u=e.firstElementChild;for(;u;)_calcDOMWidthAndHeight(u,c+1),t&&u.shadowRoot&&_calcDOMWidthAndHeight(u.shadowRoot,c+1),u=u.nextElementSibling,s++;return{maxDepth:i,maxWidth:a,numElements:s}},c=_calcDOMWidthAndHeight(e);return{depth:{max:c.maxDepth,...getNodeDetails(n)},width:{max:c.maxWidth,...getNodeDetails(l)},totalBodyElements:c.numElements}}t.exports=class DOMStats extends i{async afterPass(e){const t=e.driver,n=`(function() {\n      ${a.getNodeDetailsString};\n      return (${getDOMStats.toString()}(document.body));\n    })()`
;await t.sendCommand("DOM.enable");const i=await t.evaluateAsync(n,{useIsolation:!0});return await t.sendCommand("DOM.disable"),i}}},{"../../../lib/page-functions.js":97,"../gatherer.js":66}],"../gather/gatherers/dobetterweb/optimized-images":[function(e,t,n){"use strict";const i=e("lighthouse-logger"),a=e("../gatherer.js"),s=e("../../../lib/url-shim.js"),l=e("../../../lib/network-request.js"),c=e("../../../lib/sentry.js"),u=(e("../../driver.js"),/^image\/((x|ms|x-ms)-)?(png|bmp|jpeg)$/);class OptimizedImages extends a{constructor(){super(),this._encodingStartAt=0}static filterImageRequests(e){const t=new Set;return e.reduce(((e,n)=>{if(t.has(n.url)||!n.finished||n.sessionId)return e;t.add(n.url);const i=n.resourceType===l.TYPES.Image&&u.test(n.mimeType),a=Math.min(n.resourceSize||0,n.transferSize||0);return i&&a>4096&&e.push({requestId:n.requestId,url:n.url,mimeType:n.mimeType,resourceSize:a}),e}),[])}_getEncodedResponse(e,t,n){const i={requestId:t=l.getRequestIdForBackend(t),
encoding:n,quality:"jpeg"===n?.92:.85,sizeOnly:!0};return e.sendCommand("Audits.getEncodedResponse",i)}async calculateImageStats(e,t){const n=t.resourceSize;if(Date.now()-this._encodingStartAt>5e3||n>2048e3)return{originalSize:n,jpegSize:void 0,webpSize:void 0};const i=await this._getEncodedResponse(e,t.requestId,"jpeg"),a=await this._getEncodedResponse(e,t.requestId,"webp");return{originalSize:n,jpegSize:i.encodedSize,webpSize:a.encodedSize}}async computeOptimizedImages(e,t){this._encodingStartAt=Date.now();const n=[];for(const a of t)try{const t={failed:!1,...await this.calculateImageStats(e,a),...a};n.push(t)}catch(e){i.warn("optimized-images",e.message),c.captureException(e,{tags:{gatherer:"OptimizedImages"},extra:{imageUrl:s.elideDataURI(a.url)},level:"warning"});const t={failed:!0,errMsg:e.message,...a};n.push(t)}return n}afterPass(e,t){const n=t.networkRecords,i=OptimizedImages.filterImageRequests(n).sort(((e,t)=>t.resourceSize-e.resourceSize))
;return Promise.resolve().then((t=>this.computeOptimizedImages(e.driver,i))).then((e=>{const t=e.filter((e=>!e.failed));if(e.length&&!t.length)throw new Error("All image optimizations failed");return e}))}}t.exports=OptimizedImages},{"../../../lib/network-request.js":96,"../../../lib/sentry.js":99,"../../../lib/url-shim.js":"url","../../driver.js":61,"../gatherer.js":66,"lighthouse-logger":115}],"../gather/gatherers/dobetterweb/password-inputs-with-prevented-paste":[function(e,t,n){"use strict";const i=e("../gatherer.js"),a=e("../../../lib/page-functions.js");function findPasswordInputsWithPreventedPaste(){return Array.from(document.querySelectorAll('input[type="password"]')).filter((e=>!e.dispatchEvent(new ClipboardEvent("paste",{cancelable:!0})))).map((e=>({node:getNodeDetails(e)})))}t.exports=class PasswordInputsWithPreventedPaste extends i{afterPass(e){
const t=`(() => {\n      ${a.getNodeDetailsString};\n      return (${findPasswordInputsWithPreventedPaste.toString()}());\n    })()`;return e.driver.evaluateAsync(t)}}},{"../../../lib/page-functions.js":97,"../gatherer.js":66}],"../gather/gatherers/dobetterweb/response-compression":[function(e,t,n){(function(n){"use strict";const i=e("../gatherer.js"),a=e("../../../lib/url-shim.js"),s=e("../../../lib/sentry.js"),l=e("../../../lib/network-request.js"),c=e("zlib").gzip,u=["content-encoding","x-original-content-encoding"],d=["gzip","br","deflate"],m=["image","audio","video"],p=[l.TYPES.Document,l.TYPES.Script,l.TYPES.Stylesheet,l.TYPES.XHR,l.TYPES.Fetch,l.TYPES.EventSource];class ResponseCompression extends i{static filterUnoptimizedResponses(e){const t=[];return e.forEach((e=>{if(e.sessionId)return;const n=e.mimeType,i=e.resourceType||l.TYPES.Other,a=e.resourceSize,s=!(n&&m.some((e=>n.startsWith(e))))&&p.includes(i),c=e.url.startsWith("chrome-extension:")
;if(!s||!a||!e.finished||c||!e.transferSize||304===e.statusCode)return;(e.responseHeaders||[]).find((e=>u.includes(e.name.toLowerCase())&&d.includes(e.value)))||t.push({requestId:e.requestId,url:e.url,mimeType:n,transferSize:e.transferSize,resourceSize:a,gzipSize:0})})),t}afterPass(e,t){const i=t.networkRecords,l=ResponseCompression.filterUnoptimizedResponses(i),u=e.driver;return Promise.all(l.map((e=>u.getRequestContent(e.requestId).then((t=>t?new Promise(((i,a)=>c(t,((t,s)=>{if(t)return a(t);e.gzipSize=n.byteLength(s,"utf8"),i(e)})))):e)).catch((t=>(s.captureException(t,{tags:{gatherer:"ResponseCompression"},extra:{url:a.elideDataURI(e.url)},level:"warning"}),e.gzipSize=void 0,e))))))}}t.exports=ResponseCompression}).call(this,e("buffer").Buffer)},{"../../../lib/network-request.js":96,"../../../lib/sentry.js":99,"../../../lib/url-shim.js":"url","../gatherer.js":66,buffer:130,zlib:128}],"../gather/gatherers/dobetterweb/tags-blocking-first-paint":[function(e,t,n){"use strict"
;const i=e("../gatherer.js");e("../../driver.js");function installMediaListener(){window.___linkMediaChanges=[],Object.defineProperty(HTMLLinkElement.prototype,"media",{set:function(e){return window.___linkMediaChanges.push({href:this.href,media:e,msSinceHTMLEnd:Date.now()-window.performance.timing.responseEnd,matches:window.matchMedia(e).matches}),this.setAttribute("media",e)}})}function collectTagsThatBlockFirstPaint(){return new Promise(((e,t)=>{try{e([...document.querySelectorAll("link, head script[src]")].filter((e=>{if("SCRIPT"===e.tagName){const t=e;return!(t.hasAttribute("async")||t.hasAttribute("defer")||/^data:/.test(t.src)||/^blob:/.test(t.src)||"module"===t.getAttribute("type"))}if("LINK"===e.tagName){const t=e,n="stylesheet"===t.rel&&window.matchMedia(t.media).matches&&!t.disabled,i="import"===t.rel&&!t.hasAttribute("async");return n||i}return!1})).map((e=>({tagName:e.tagName,url:"LINK"===e.tagName?e.href:e.src,src:e.src,href:e.href,rel:e.rel,media:e.media,
disabled:e.disabled,mediaChanges:window.___linkMediaChanges.filter((t=>t.href===e.href))}))))}catch(e){t(new Error(`${"Unable to gather Scripts/Stylesheets/HTML Imports on the page"}: ${e.message}`))}}))}class TagsBlockingFirstPaint extends i{static _filteredAndIndexedByUrl(e){return e.reduce(((e,t)=>{if(!t.finished)return e;const n="parser"===t.initiator.type,i=/(css|script)/.test(t.mimeType)&&n,a=t._failed;return(t.mimeType&&t.mimeType.includes("html")||i||a&&n)&&(e[t.url]={isLinkPreload:!!t.isLinkPreload,transferSize:t.transferSize,startTime:t.startTime,endTime:t.endTime}),e}),{})}static findBlockingTags(e,t){const n=`(${collectTagsThatBlockFirstPaint.toString()}())`,i=t.reduce(((e,t)=>Math.min(e,t.endTime)),1/0);return e.evaluateAsync(n).then((e=>{const n=TagsBlockingFirstPaint._filteredAndIndexedByUrl(t);return e.reduce(((e,t)=>{const a=n[t.url];if(a&&!a.isLinkPreload){
const s=(t.mediaChanges||[]).filter((e=>!e.matches)).map((e=>e.msSinceHTMLEnd)),l=Math.min(...s),c=Math.max(a.startTime,i+l/1e3);e.push({tag:t,transferSize:a.transferSize||0,startTime:a.startTime,endTime:Math.min(a.endTime,c)}),n[t.url]=null}return e}),[])}))}beforePass(e){return e.driver.evaluateScriptOnNewDocument(`(${installMediaListener.toString()})()`)}afterPass(e,t){return TagsBlockingFirstPaint.findBlockingTags(e.driver,t.networkRecords)}}t.exports=TagsBlockingFirstPaint},{"../../driver.js":61,"../gatherer.js":66}],"../gather/gatherers/form-elements":[function(e,t,n){"use strict";const i=e("./gatherer.js"),a=e("../../lib/page-functions.js");function collectFormElements(){const e=getElementsInDocument("textarea, input, label, select"),t=new Map,n={node:null,inputs:[],labels:[]};for(const i of e){if(i instanceof HTMLInputElement&&("submit"===i.type||"button"===i.type))continue;const e=i.form;if(!!e&&!t.has(e)){const n={attributes:{id:e.id,name:e.name,autocomplete:e.autocomplete},
node:getNodeDetails(e),inputs:[],labels:[]};t.set(e,n)}const a=t.get(e)||n;(i instanceof HTMLInputElement||i instanceof HTMLTextAreaElement||i instanceof HTMLSelectElement)&&a.inputs.push({id:i.id,name:i.name,placeholder:i instanceof HTMLSelectElement?void 0:i.placeholder,autocomplete:{property:i.autocomplete,attribute:i.getAttribute("autocomplete"),prediction:i.getAttribute("autofill-prediction")},node:getNodeDetails(i)}),i instanceof HTMLLabelElement&&a.labels.push({for:i.htmlFor,node:getNodeDetails(i)})}return(n.inputs.length>0||n.labels.length>0)&&t.set("formless",{node:n.node,inputs:n.inputs,labels:n.labels}),[...t.values()]}t.exports=class FormElements extends i{async afterPass(e){const t=e.driver,n=`(() => {\n      ${a.getElementsInDocumentString};\n      ${a.getNodeDetailsString};\n      return (${collectFormElements})();\n    })()`;return await t.evaluateAsync(n,{useIsolation:!0})}}},{"../../lib/page-functions.js":97,"./gatherer.js":66}],
"../gather/gatherers/full-page-screenshot":[function(e,t,n){"use strict";const i=e("./gatherer.js"),a=e("../../lib/page-functions.js"),s=16384;t.exports=class FullPageScreenshot extends i{async _takeScreenshot(e){const t=e.driver,n=await t.sendCommand("Page.getLayoutMetrics"),i=Math.min(n.layoutViewport.clientWidth,s),a=Math.min(n.contentSize.height,s);await t.sendCommand("Emulation.setDeviceMetricsOverride",{mobile:e.settings.screenEmulation.mobile,height:a,width:i,deviceScaleFactor:1,scale:1,screenOrientation:{angle:0,type:"portraitPrimary"}});return{width:i,height:a,data:"data:image/jpeg;base64,"+(await t.sendCommand("Page.captureScreenshot",{format:"jpeg",quality:30})).data}}async _resolveNodes(e){const t=`(function () {\n      ${a.getBoundingClientRectString};\n      return (${function resolveNodes(){const e={};if(!window.__lighthouseNodesDontTouchOrAllVarianceGoesAway)return e;const t=window.__lighthouseNodesDontTouchOrAllVarianceGoesAway;for(const[n,i]of t.entries()){
const t=getBoundingClientRect(n);(t.width||t.height)&&(e[i]=t)}return e}.toString()}());\n    })()`;return{...await e.driver.evaluateAsync(t,{useIsolation:!1}),...await e.driver.evaluateAsync(t,{useIsolation:!0})}}async afterPass(e){const{driver:t}=e,n=!e.settings.screenEmulation.disabled;try{return{screenshot:await this._takeScreenshot(e),nodes:await this._resolveNodes(e)}}finally{if(n)await t.beginEmulation(e.settings);else{const n=await t.evaluateAsync("(function() {\n          return {\n            width: document.documentElement.clientWidth,\n            height: document.documentElement.clientHeight,\n            screenOrientation: {\n              type: window.screen.orientation.type,\n              angle: window.screen.orientation.angle,\n            },\n            deviceScaleFactor: window.devicePixelRatio,\n          };\n        })()",{useIsolation:!0});n.screenOrientation.type=function snakeCaseToCamelCase(e){return e.replace(/(-\w)/g,(e=>e[1].toUpperCase()))
}(n.screenOrientation.type),await t.sendCommand("Emulation.setDeviceMetricsOverride",{mobile:"mobile"===e.settings.formFactor,...n})}}}},t.exports.MAX_SCREENSHOT_HEIGHT=s},{"../../lib/page-functions.js":97,"./gatherer.js":66}],"../gather/gatherers/global-listeners":[function(e,t,n){"use strict";const i=e("./gatherer.js");class GlobalListeners extends i{static _filterForAllowlistedTypes(e){return"pagehide"===e.type||"unload"===e.type||"visibilitychange"===e.type}getListenerIndentifier(e){return`${e.type}:${e.scriptId}:${e.columnNumber}:${e.lineNumber}`}dedupeListeners(e){const t=new Set;return e.filter((e=>{const n=this.getListenerIndentifier(e);return!t.has(n)&&(t.add(n),!0)}))}async afterPass(e){const t=e.driver,{result:{objectId:n}}=await t.sendCommand("Runtime.evaluate",{expression:"window",returnByValue:!1});if(!n)throw new Error("Error fetching information about the global object");const{listeners:i}=await t.sendCommand("DOMDebugger.getEventListeners",{objectId:n
}),a=i.filter(GlobalListeners._filterForAllowlistedTypes).map((e=>{const{type:t,scriptId:n,lineNumber:i,columnNumber:a}=e;return{type:t,scriptId:n,lineNumber:i,columnNumber:a}}));return this.dedupeListeners(a)}}t.exports=GlobalListeners},{"./gatherer.js":66}],"../gather/gatherers/http-redirect":[function(e,t,n){"use strict";const i=e("./gatherer.js");t.exports=class HTTPRedirect extends i{constructor(){super(),this._preRedirectURL=""}beforePass(e){this._preRedirectURL=e.url,e.url=this._preRedirectURL.replace(/^https/,"http")}async afterPass(e){e.url=this._preRedirectURL;return{value:await e.driver.evaluateAsync("new URL(window.location).protocol === 'https:'",{useIsolation:!0})}}}},{"./gatherer.js":66}],"../gather/gatherers/iframe-elements":[function(e,t,n){"use strict";const i=e("./gatherer.js"),a=e("../../lib/page-functions.js");function collectIFrameElements(){return getElementsInDocument("iframe").map((e=>{
const t=e.getBoundingClientRect(),{top:n,bottom:i,left:a,right:s,width:l,height:c}=t;return{id:e.id,src:e.src,clientRect:{top:n,bottom:i,left:a,right:s,width:l,height:c},isPositionFixed:isPositionFixed(e),node:getNodeDetails(e)}}))}t.exports=class IFrameElements extends i{async afterPass(e){const t=e.driver,n=`(() => {\n      ${a.getElementsInDocumentString};\n      ${a.isPositionFixedString};\n      ${a.getNodeDetailsString};\n      return (${collectIFrameElements})();\n    })()`;return await t.evaluateAsync(n,{useIsolation:!0})}}},{"../../lib/page-functions.js":97,"./gatherer.js":66}],"../gather/gatherers/image-elements":[function(e,t,n){"use strict";const i=e("./gatherer.js"),a=e("../../lib/page-functions.js"),s=(e("../driver.js"),e("./seo/font-size.js"));function getClientRect(e){const t=e.getBoundingClientRect();return{top:t.top,bottom:t.bottom,left:t.left,right:t.right}}function getPosition(e,t){if(e.parentElement&&"PICTURE"===e.parentElement.tagName){
return window.getComputedStyle(e.parentElement).getPropertyValue("position")}return t.getPropertyValue("position")}function getHTMLImages(e){return e.filter((e=>"img"===e.localName)).map((e=>{const t=window.getComputedStyle(e),n=!!e.parentElement&&"PICTURE"===e.parentElement.tagName,i=!n&&!e.srcset;return{src:e.currentSrc,srcset:e.srcset,displayedWidth:e.width,displayedHeight:e.height,clientRect:getClientRect(e),naturalWidth:i?e.naturalWidth:void 0,naturalHeight:i?e.naturalHeight:void 0,attributeWidth:e.getAttribute("width")||"",attributeHeight:e.getAttribute("height")||"",cssWidth:void 0,cssHeight:void 0,cssComputedPosition:getPosition(e,t),isCss:!1,isPicture:n,loading:e.loading,cssComputedObjectFit:t.getPropertyValue("object-fit"),cssComputedImageRendering:t.getPropertyValue("image-rendering"),isInShadowDOM:e.getRootNode()instanceof ShadowRoot,node:getNodeDetails(e)}}))}function getCSSImages(e){const t=/^url\("([^"]+)"\)$/,n=[];for(const i of e){const e=window.getComputedStyle(i)
;if(!e.backgroundImage||!t.test(e.backgroundImage))continue;const a=e.backgroundImage.match(t)[1];n.push({src:a,srcset:"",displayedWidth:i.clientWidth,displayedHeight:i.clientHeight,clientRect:getClientRect(i),attributeWidth:"",attributeHeight:"",cssWidth:void 0,cssHeight:void 0,cssComputedPosition:getPosition(i,e),isCss:!0,isPicture:!1,isInShadowDOM:i.getRootNode()instanceof ShadowRoot,cssComputedObjectFit:"",cssComputedImageRendering:e.getPropertyValue("image-rendering"),node:getNodeDetails(i)})}return n}function collectImageElementInfo(){const e=getElementsInDocument();return getHTMLImages(e).concat(getCSSImages(e))}function determineNaturalSize(e){return new Promise(((t,n)=>{const i=new Image;i.addEventListener("error",(e=>n(new Error("determineNaturalSize failed img load")))),i.addEventListener("load",(()=>{t({naturalWidth:i.naturalWidth,naturalHeight:i.naturalHeight})})),i.src=e}))}function findSizeDeclaration(e,t){if(!e||!e.cssProperties)return
;const n=e.cssProperties.find((({name:e})=>e===t));return n?n.value:void 0}function getEffectiveSizingRule({attributesStyle:e,inlineStyle:t,matchedCSSRules:n},i){const a=findSizeDeclaration(t,i);if(a)return a;const l=findSizeDeclaration(e,i);if(l)return l;const c=function findMostSpecificCSSRule(e,t){const n=s.findMostSpecificMatchedCSSRule(e,(e=>findSizeDeclaration(e,t)));if(n)return findSizeDeclaration(n,t)}(n,i);return c||void 0}t.exports=class ImageElements extends i{constructor(){super(),this._naturalSizeCache=new Map}async fetchElementWithSizeInformation(e,t){const n=JSON.stringify(t.src);if(this._naturalSizeCache.has(n))return Object.assign(t,this._naturalSizeCache.get(n));try{e.setNextProtocolTimeout(250);const i=await e.evaluateAsync(`(${determineNaturalSize.toString()})(${n})`);return this._naturalSizeCache.set(n,i),Object.assign(t,i)}catch(e){return t}}async fetchSourceRules(e,t,n){try{const{nodeId:i}=await e.sendCommand("DOM.pushNodeByPathToFrontend",{path:t});if(!i)return
;const a=await e.sendCommand("CSS.getMatchedStylesForNode",{nodeId:i}),s=getEffectiveSizingRule(a,"width"),l={cssWidth:s,cssHeight:getEffectiveSizingRule(a,"height")};Object.assign(n,l)}catch(e){if(/No node.*found/.test(e.message))return;throw e}}async afterPass(e,t){const n=e.driver,i=t.networkRecords.reduce(((e,t)=>((/^image/.test(t.mimeType)||/\.(avif|webp)$/i.test(t.url))&&t.finished&&200===t.statusCode&&(e[t.url]=t),e)),{}),s=`(function() {\n      ${a.getElementsInDocumentString}; // define function on page\n      ${a.getBoundingClientRectString};\n      ${a.getNodeDetailsString};\n      ${getClientRect.toString()};\n      ${getPosition.toString()};\n      ${getHTMLImages.toString()};\n      ${getCSSImages.toString()};\n      ${collectImageElementInfo.toString()};\n\n      return collectImageElementInfo();\n    })()`,l=await n.evaluateAsync(s),c=[],u=Object.values(i).sort(((e,t)=>t.resourceSize-e.resourceSize)).slice(0,50)
;await Promise.all([n.sendCommand("DOM.enable"),n.sendCommand("CSS.enable"),n.sendCommand("DOM.getDocument",{depth:-1,pierce:!0})]);for(let e of l){const t=i[e.src]||{};e.mimeType=t.mimeType,e.isInShadowDOM||e.isCss||await this.fetchSourceRules(n,e.node.devtoolsNodePath,e),(e.isPicture||e.isCss||e.srcset)&&u.includes(t)&&(e=await this.fetchElementWithSizeInformation(n,e)),c.push(e)}return await Promise.all([n.sendCommand("DOM.disable"),n.sendCommand("CSS.disable")]),c}}},{"../../lib/page-functions.js":97,"../driver.js":61,"./gatherer.js":66,"./seo/font-size.js":"../gather/gatherers/seo/font-size"}],"../gather/gatherers/inspector-issues":[function(e,t,n){"use strict";const i=e("./gatherer.js");t.exports=class InspectorIssues extends i{constructor(){super(),this._issues=[],this._onIssueAdded=this.onIssueAdded.bind(this)}onIssueAdded(e){this._issues.push(e.issue)}async beforePass(e){const t=e.driver;t.on("Audits.issueAdded",this._onIssueAdded),await t.sendCommand("Audits.enable")}
async afterPass(e,t){const n=e.driver,i=t.networkRecords;n.off("Audits.issueAdded",this._onIssueAdded),await n.sendCommand("Audits.disable");const a={mixedContent:[],sameSiteCookies:[],blockedByResponse:[],heavyAds:[],contentSecurityPolicy:[]};for(const e of this._issues){if(e.details.mixedContentIssueDetails){const t=e.details.mixedContentIssueDetails,n=t.request&&t.request.requestId;n&&i.find((e=>e.requestId===n))&&a.mixedContent.push(t)}if(e.details.sameSiteCookieIssueDetails){const t=e.details.sameSiteCookieIssueDetails,n=t.request&&t.request.requestId;n&&i.find((e=>e.requestId===n))&&a.sameSiteCookies.push(t)}if(e.details.blockedByResponseIssueDetails){const t=e.details.blockedByResponseIssueDetails,n=t.request&&t.request.requestId;n&&i.find((e=>e.requestId===n))&&a.blockedByResponse.push(t)}e.details.heavyAdIssueDetails&&a.heavyAds.push(e.details.heavyAdIssueDetails),
e.details.contentSecurityPolicyIssueDetails&&a.contentSecurityPolicy.push(e.details.contentSecurityPolicyIssueDetails)}return a}}},{"./gatherer.js":66}],"../gather/gatherers/js-usage":[function(e,t,n){"use strict";const i=e("./gatherer.js");t.exports=class JsUsage extends i{constructor(){super(),this._scriptParsedEvents=[],this.onScriptParsed=this.onScriptParsed.bind(this)}onScriptParsed(e){e.embedderName&&this._scriptParsedEvents.push(e)}async beforePass(e){await e.driver.sendCommand("Profiler.enable"),await e.driver.sendCommand("Profiler.startPreciseCoverage",{detailed:!1}),await e.driver.sendCommand("Debugger.enable"),await e.driver.on("Debugger.scriptParsed",this.onScriptParsed)}async afterPass(e){const t=e.driver,n=(await t.sendCommand("Profiler.takePreciseCoverage")).result;await t.sendCommand("Profiler.stopPreciseCoverage"),await t.sendCommand("Profiler.disable"),await e.driver.sendCommand("Debugger.disable");const i={};for(const e of n){let t=e.url
;const n=this._scriptParsedEvents.find((t=>t.scriptId===e.scriptId));if(n&&n.embedderName&&(t=n.embedderName),""===e.url||n&&""===n.embedderName)continue;const a=i[t]||[];a.push(e),i[t]=a}return i}}},{"./gatherer.js":66}],"../gather/gatherers/link-elements":[function(e,t,n){"use strict";const i=e("http-link-header"),a=e("./gatherer.js"),{URL:s}=e("../../lib/url-shim.js"),l=e("../../lib/dependency-graph/simulator/network-analyzer.js"),c=e("../../lib/page-functions.js");function normalizeUrlOrNull(e,t){try{return new s(e,t).href}catch(e){return null}}function getLinkElementsInDOM(){const e=getElementsInDocument("link"),t=[];for(const n of e){if(!(n instanceof HTMLLinkElement))continue;const e=n.getAttribute("href")||"",i=n.closest("head")?"head":"body";t.push({rel:n.rel,href:n.href,hreflang:n.hreflang,as:n.as,crossOrigin:n.crossOrigin,hrefRaw:e,source:i,node:getNodeDetails(n)})}return t}class LinkElements extends a{static getLinkElementsInDOM(e){
return e.driver.evaluate(getLinkElementsInDOM,{args:[],useIsolation:!0,deps:[c.getNodeDetailsString,c.getElementsInDocument]})}static getLinkElementsInHeaders(e,t){const n=e.url,a=t.networkRecords,s=l.findMainDocument(a,n),c=[];for(const e of s.responseHeaders)if("link"===e.name.toLowerCase())for(const t of i.parse(e.value).refs)c.push({rel:t.rel||"",href:normalizeUrlOrNull(t.uri,n),hrefRaw:t.uri||"",hreflang:t.hreflang||"",as:t.as||"",crossOrigin:(u=t.crossorigin,"anonymous"===u?"anonymous":"use-credentials"===u?"use-credentials":null),source:"headers",node:null});var u;return c}async afterPass(e,t){const n=await LinkElements.getLinkElementsInDOM(e),i=LinkElements.getLinkElementsInHeaders(e,t),a=n.concat(i);for(const e of a)e.rel=e.rel.toLowerCase();return a}}t.exports=LinkElements},{"../../lib/dependency-graph/simulator/network-analyzer.js":79,"../../lib/page-functions.js":97,"../../lib/url-shim.js":"url","./gatherer.js":66,"http-link-header":135}],
"../gather/gatherers/main-document-content":[function(e,t,n){"use strict";const i=e("./gatherer.js"),a=e("../../lib/dependency-graph/simulator/network-analyzer.js");t.exports=class MainDocumentContent extends i{async afterPass(e,t){const n=a.findMainDocument(t.networkRecords,e.url);return e.driver.getRequestContent(n.requestId)}}},{"../../lib/dependency-graph/simulator/network-analyzer.js":79,"./gatherer.js":66}],"../gather/gatherers/meta-elements":[function(e,t,n){"use strict";const i=e("./gatherer.js"),a=e("../../lib/page-functions.js");function collectMetaElements(){return getElementsInDocument("head meta").map((e=>{const getAttribute=t=>{const n=e.attributes.getNamedItem(t);if(n)return n.value};return{name:e.name.toLowerCase(),content:e.content,property:getAttribute("property"),httpEquiv:e.httpEquiv?e.httpEquiv.toLowerCase():void 0,charset:getAttribute("charset")}}))}t.exports=class MetaElements extends i{async afterPass(e){return e.driver.evaluate(collectMetaElements,{args:[],
useIsolation:!0,deps:[a.getElementsInDocument]})}}},{"../../lib/page-functions.js":97,"./gatherer.js":66}],"../gather/gatherers/script-elements":[function(e,t,n){"use strict";const i=e("./gatherer.js"),a=e("../../lib/dependency-graph/simulator/network-analyzer.js"),s=e("../../lib/network-request.js"),l=e("../../lib/page-functions.js");function collectAllScriptElements(){return getElementsInDocument("script").map((e=>({type:e.type||null,src:e.src||null,id:e.id||null,async:e.async,defer:e.defer,source:e.closest("head")?"head":"body",content:e.src?null:e.text,requestId:null,node:getNodeDetails(e)})))}t.exports=class ScriptElements extends i{async afterPass(e,t){const n=e.driver,i=a.findMainDocument(t.networkRecords,e.url),c=await n.evaluate(collectAllScriptElements,{args:[],useIsolation:!0,deps:[l.getNodeDetailsString,l.getElementsInDocument]});for(const e of c)e.content&&(e.requestId=i.requestId)
;const u=t.networkRecords.filter((e=>!e.sessionId)).filter((e=>e.resourceType===s.TYPES.Script)),d=await async function runInSeriesOrParallel(e,t,n){if(n){const n=[];for(const i of e){const e=await t(i);n.push(e)}return n}{const n=e.map(t);return await Promise.all(n)}}(u,(e=>n.getRequestContent(e.requestId).catch((()=>""))),"mobile"===e.baseArtifacts.HostFormFactor);for(let e=0;e<u.length;e++){const t=u[e],n=d[e];if(!n)continue;const i=c.find((e=>e.src===t.url));i?(i.requestId=t.requestId,i.content=n):c.push({type:null,src:t.url,id:null,async:!1,defer:!1,source:"network",requestId:t.requestId,content:n,node:null})}return c}}},{"../../lib/dependency-graph/simulator/network-analyzer.js":79,"../../lib/network-request.js":96,"../../lib/page-functions.js":97,"./gatherer.js":66}],"../gather/gatherers/seo/embedded-content":[function(e,t,n){"use strict";const i=e("../gatherer.js"),a=e("../../../lib/page-functions.js");t.exports=class EmbeddedContent extends i{afterPass(e){
const t=`(function() {\n      ${a.getElementsInDocumentString}; // define function on page\n      const selector = 'object, embed, applet';\n      const elements = getElementsInDocument(selector);\n      return elements\n        .map(node => ({\n          tagName: node.tagName,\n          type: node.getAttribute('type'),\n          src: node.getAttribute('src'),\n          data: node.getAttribute('data'),\n          code: node.getAttribute('code'),\n          params: Array.from(node.children)\n            .filter(el => el.tagName === 'PARAM')\n            .map(el => ({\n              name: el.getAttribute('name') || '',\n              value: el.getAttribute('value') || '',\n            })),\n        }));\n    })()`;return e.driver.evaluateAsync(t)}}},{"../../../lib/page-functions.js":97,"../gatherer.js":66}],"../gather/gatherers/seo/font-size":[function(e,t,n){"use strict";const i=e("../gatherer.js");function hasFontSizeDeclaration(e){
return!!e&&!!e.cssProperties.find((({name:e})=>"font-size"===e))}function computeSelectorSpecificity(e){const t=e.split(" ");let n=0,i=0,a=0;for(const e of t){const t=e.match(/\b#[a-z0-9]+/g)||[],s=e.match(/\b\.[a-z0-9]+/g)||[],l=e.match(/^[a-z]+/)?[1]:[];n+=t.length,i+=s.length,a+=l.length}return 100*Math.min(9,n)+10*Math.min(9,i)+Math.min(9,a)}function findMostSpecificMatchedCSSRule(e=[],t){let n,i=-1/0;for(const{rule:a,matchingSelectors:s}of e)if(t(a.style)){const e=s.map((e=>computeSelectorSpecificity(a.selectorList.selectors[e].text))),t=Math.max(...e);t>=i&&(i=t,n=a)}if(n)return{type:"Regular",...n.style,parentRule:{origin:n.origin,selectors:n.selectorList.selectors}}}function getEffectiveFontRule({attributesStyle:e,inlineStyle:t,matchedCSSRules:n,inherited:i}){if(hasFontSizeDeclaration(t))return{type:"Inline",...t};const a=findMostSpecificMatchedCSSRule(n,hasFontSizeDeclaration);if(a)return a;if(hasFontSizeDeclaration(e))return{type:"Attributes",...e}
;const s=function findInheritedCSSRule(e=[]){for(const{inlineStyle:t,matchedCSSRules:n}of e){if(hasFontSizeDeclaration(t))return{type:"Inline",...t};const e=findMostSpecificMatchedCSSRule(n,hasFontSizeDeclaration);if(e)return e}}(i);return s||void 0}function getTextLength(e){return e?Array.from(e.trim()).length:0}class FontSize extends i{static async fetchFailingNodeSourceRules(e,t){const n=t.sort(((e,t)=>t.textLength-e.textLength)).slice(0,50);await e.sendCommand("DOM.getDocument",{depth:-1,pierce:!0});const{nodeIds:i}=await e.sendCommand("DOM.pushNodesByBackendIdsToFrontend",{backendNodeIds:n.map((e=>e.parentNode.backendNodeId))}),a=n.map((async(t,n)=>{t.nodeId=i[n];try{const a=await async function fetchSourceRule(e,t){const n=getEffectiveFontRule(await e.sendCommand("CSS.getMatchedStylesForNode",{nodeId:t}));if(n)return{type:n.type,range:n.range,styleSheetId:n.styleSheetId,parentRule:n.parentRule&&{origin:n.parentRule.origin,selectors:n.parentRule.selectors}}}(e,i[n]);t.cssRule=a
}catch(e){t.cssRule=void 0}return t})),s=await Promise.all(a),l=s.reduce(((e,{textLength:t})=>e+t),0);return{analyzedFailingNodesData:s,analyzedFailingTextLength:l}}getTextNodesInLayoutFromSnapshot(e){const t=e.strings,getString=e=>t[e],n=[];for(let i=0;i<e.documents.length;i++){const a=e.documents[i];if(!(a.nodes.backendNodeId&&a.nodes.parentIndex&&a.nodes.attributes&&a.nodes.nodeName))throw new Error("Unexpected response from DOMSnapshot.captureSnapshot.");const s=a.nodes,getParentData=e=>({backendNodeId:s.backendNodeId[e],attributes:s.attributes[e].map(getString),nodeName:getString(s.nodeName[e])});for(const e of a.textBoxes.layoutIndex){const i=t[a.layout.text[e]];if(!i)continue;const l=a.layout.nodeIndex[e],c=a.layout.styles[e],[u]=c,d=parseFloat(t[u]),m=s.parentIndex[l],p=s.parentIndex[m],h=getParentData(m),f=void 0!==p?getParentData(p):void 0;n.push({nodeIndex:l,backendNodeId:s.backendNodeId[l],fontSize:d,textLength:getTextLength(i),parentNode:{...h,parentNode:f}})}}return n}
findFailingNodes(e){const t=[];let n=0,i=0;for(const a of this.getTextNodesInLayoutFromSnapshot(e))n+=a.textLength,a.fontSize<12&&(i+=a.textLength,t.push({nodeId:0,parentNode:a.parentNode,textLength:a.textLength,fontSize:a.fontSize}));return{totalTextLength:n,failingTextLength:i,failingNodes:t}}async afterPass(e){const t=new Map,onStylesheetAdded=e=>t.set(e.header.styleSheetId,e.header);e.driver.on("CSS.styleSheetAdded",onStylesheetAdded),await Promise.all([e.driver.sendCommand("DOMSnapshot.enable"),e.driver.sendCommand("DOM.enable"),e.driver.sendCommand("CSS.enable")]);const n=await e.driver.sendCommand("DOMSnapshot.captureSnapshot",{computedStyles:["font-size"]}),{totalTextLength:i,failingTextLength:a,failingNodes:s}=this.findFailingNodes(n),{analyzedFailingNodesData:l,analyzedFailingTextLength:c}=await FontSize.fetchFailingNodeSourceRules(e.driver,s);return e.driver.off("CSS.styleSheetAdded",onStylesheetAdded),
l.filter((e=>e.cssRule&&e.cssRule.styleSheetId)).forEach((e=>e.cssRule.stylesheet=t.get(e.cssRule.styleSheetId))),await Promise.all([e.driver.sendCommand("DOMSnapshot.disable"),e.driver.sendCommand("DOM.disable"),e.driver.sendCommand("CSS.disable")]),{analyzedFailingNodesData:l,analyzedFailingTextLength:c,failingTextLength:a,totalTextLength:i}}}t.exports=FontSize,t.exports.computeSelectorSpecificity=computeSelectorSpecificity,t.exports.getEffectiveFontRule=getEffectiveFontRule,t.exports.findMostSpecificMatchedCSSRule=findMostSpecificMatchedCSSRule},{"../gatherer.js":66}],"../gather/gatherers/seo/robots-txt":[function(e,t,n){"use strict";const i=e("../gatherer.js");async function getRobotsTxtContent(){try{const e=await fetch(new URL("/robots.txt",location.href).href);if(!e.ok)return{status:e.status,content:null};const t=await e.text();return{status:e.status,content:t}}catch(e){return{status:null,content:null}}}t.exports=class RobotsTxt extends i{afterPass(e){
return e.driver.evaluateAsync(`(${getRobotsTxtContent.toString()}())`,{useIsolation:!0})}}},{"../gatherer.js":66}],"../gather/gatherers/seo/tap-targets":[function(e,t,n){"use strict";const i=e("../gatherer.js"),a=e("../../../lib/page-functions.js"),s=e("../../../lib/rect-helpers.js"),l=["button","a","input","textarea","select","option","[role=button]","[role=checkbox]","[role=link]","[role=menuitem]","[role=menuitemcheckbox]","[role=menuitemradio]","[role=option]","[role=scrollbar]","[role=slider]","[role=spinbutton]"].join(",");function elementIsVisible(e){return!!(e.offsetWidth||e.offsetHeight||e.getClientRects().length)}function getClientRects(e){const t=Array.from(e.getClientRects()).map((e=>{const{width:t,height:n,left:i,top:a,right:s,bottom:l}=e;return{width:t,height:n,left:i,top:a,right:s,bottom:l}}));for(const n of e.children)t.push(...getClientRects(n));return t}function elementHasAncestorTapTarget(e,t){
return!!e.parentElement&&(!!e.parentElement.matches(t)||elementHasAncestorTapTarget(e.parentElement,t))}function hasTextNodeSiblingsFormingTextBlock(e){if(!e.parentElement)return!1;const t=e.parentElement,n=e.textContent||"";if((t.textContent||"").length-n.length<5)return!1;for(const t of e.parentElement.childNodes){if(t===e)continue;const n=(t.textContent||"").trim();if(t.nodeType===Node.TEXT_NODE&&n.length>0)return!0}return!1}function elementIsInTextBlock(e){const{display:t}=getComputedStyle(e);return("inline"===t||"inline-block"===t)&&(!!hasTextNodeSiblingsFormingTextBlock(e)||!!e.parentElement&&elementIsInTextBlock(e.parentElement))}function elementCenterIsAtZAxisTop(e,t){const n=window.innerHeight,i=Math.floor(t.y/n)*n;window.scrollY!==i&&window.scrollTo(0,i);const a=document.elementFromPoint(t.x,t.y-window.scrollY);return a===e||e.contains(a)}function disableFixedAndStickyElementPointerEvents(){const e="lighthouse-disable-pointer-events",t=document.createElement("style")
;return t.textContent=`.${e} { pointer-events: none !important }`,document.body.appendChild(t),document.querySelectorAll("*").forEach((t=>{const n=getComputedStyle(t).position;"fixed"!==n&&"sticky"!==n||t.classList.add(e)})),function undo(){Array.from(document.getElementsByClassName(e)).forEach((t=>{t.classList.remove(e)})),t.remove()}}function gatherTapTargets(e){const t=[];window.scrollTo(0,0);const n=getElementsInDocument(e),i=[];n.forEach((t=>{elementHasAncestorTapTarget(t,e)||elementIsInTextBlock(t)||elementIsVisible(t)&&i.push({tapTargetElement:t,clientRects:getClientRects(t)})}));const a=disableFixedAndStickyElementPointerEvents(),s=[];i.forEach((({tapTargetElement:e,clientRects:t})=>{let n=t.filter((e=>0!==e.width&&0!==e.height));n=n.filter((t=>{const n=getRectCenterPoint(t);return elementCenterIsAtZAxisTop(e,n)})),n.length>0&&s.push({tapTargetElement:e,visibleClientRects:n})}));for(const{tapTargetElement:e,visibleClientRects:n}of s)t.push({clientRects:n,href:e.href||"",
node:getNodeDetails(e)});return a(),t}t.exports=class TapTargets extends i{afterPass(e){return e.driver.evaluate(gatherTapTargets,{args:[l],useIsolation:!0,deps:[a.getNodeDetailsString,a.getElementsInDocument,disableFixedAndStickyElementPointerEvents,elementIsVisible,elementHasAncestorTapTarget,elementCenterIsAtZAxisTop,getClientRects,hasTextNodeSiblingsFormingTextBlock,elementIsInTextBlock,s.getRectCenterPoint,a.getNodePath,a.getNodeSelector,a.getNodeLabel]})}}},{"../../../lib/page-functions.js":97,"../../../lib/rect-helpers.js":98,"../gatherer.js":66}],"../gather/gatherers/service-worker":[function(e,t,n){"use strict";const i=e("./gatherer.js");t.exports=class ServiceWorker extends i{async beforePass(e){const{versions:t}=await e.driver.getServiceWorkerVersions(),{registrations:n}=await e.driver.getServiceWorkerRegistrations();return{versions:t,registrations:n}}}},{"./gatherer.js":66}],"../gather/gatherers/source-maps":[function(e,t,n){(function(n){"use strict"
;const i=e("./gatherer.js"),a=e("../../lib/url-shim.js");t.exports=class SourceMaps extends i{constructor(){super(),this._scriptParsedEvents=[],this.onScriptParsed=this.onScriptParsed.bind(this)}async fetchSourceMap(e,t){const n=await e.fetcher.fetchResource(t,{timeout:1500});return JSON.parse(n)}parseSourceMapFromDataUrl(e){const t=n.from(e.split(",")[1],"base64");return JSON.parse(t.toString())}onScriptParsed(e){e.sourceMapURL&&this._scriptParsedEvents.push(e)}async beforePass(e){const t=e.driver;t.on("Debugger.scriptParsed",this.onScriptParsed),await t.sendCommand("Debugger.enable")}_resolveUrl(e,t){try{return new a(e,t).href}catch(e){return}}async _retrieveMapFromScriptParsedEvent(e,t){if(!t.sourceMapURL)throw new Error("precondition failed: event.sourceMapURL should exist");const n=t.sourceMapURL.startsWith("data:"),i=t.url,a=n?t.sourceMapURL:this._resolveUrl(t.sourceMapURL,t.url);if(!a)return{scriptUrl:i,errorMessage:"Could not resolve map url: "+t.sourceMapURL}
;const s=n?void 0:a;try{const t=n?this.parseSourceMapFromDataUrl(a):await this.fetchSourceMap(e,a);return t.sections&&(t.sections=t.sections.filter((e=>e.map))),{scriptUrl:i,sourceMapUrl:s,map:t}}catch(e){return{scriptUrl:i,sourceMapUrl:s,errorMessage:e.toString()}}}async afterPass(e){const t=e.driver;t.off("Debugger.scriptParsed",this.onScriptParsed),await t.sendCommand("Debugger.disable"),await t.fetcher.enableRequestInterception();const n=this._scriptParsedEvents.map((e=>this._retrieveMapFromScriptParsedEvent(t,e)));return Promise.all(n)}}}).call(this,e("buffer").Buffer)},{"../../lib/url-shim.js":"url","./gatherer.js":66,buffer:130}],"../gather/gatherers/trace-elements":[function(e,t,n){"use strict";const i=e("./gatherer.js"),a=e("../../lib/page-functions.js"),s=e("../../lib/tracehouse/trace-processor.js"),l=e("../../lib/rect-helpers.js"),c=e("../../lib/sentry.js");function getNodeDetailsData(){const e=this.nodeType===document.ELEMENT_NODE?this:this.parentElement;let t
;return e&&(t={node:getNodeDetails(e)}),t}class TraceElements extends i{static getNodeIDFromTraceEvent(e){return e&&e.args&&e.args.data&&e.args.data.nodeId}static getAnimationIDFromTraceEvent(e){return e&&e.args&&e.args.data&&e.args.data.id}static getFailureReasonsFromTraceEvent(e){return e&&e.args&&e.args.data&&e.args.data.compositeFailed}static getUnsupportedPropertiesFromTraceEvent(e){return e&&e.args&&e.args.data&&e.args.data.unsupportedProperties}static traceRectToLHRect(e){const t={x:e[0],y:e[1],width:e[2],height:e[3]};return l.addRectTopAndBottom(t)}static async resolveAnimationName(e,t){const n=e.driver;try{const e=(await n.sendCommand("Animation.resolveAnimation",{animationId:t})).remoteObject.objectId;if(!e)return;const i=(await n.sendCommand("Runtime.getProperties",{objectId:e})).result.find((e=>"animationName"===e.name)),a=i&&i.value&&i.value.value;if(""===a)return;return a}catch(e){return void c.captureException(e,{tags:{gatherer:TraceElements.name},level:"error"})}}
static getTopLayoutShiftElements(e){const t=new Map,n=e.filter((e=>"LayoutShift"===e.name)).map((e=>e.args&&e.args.data)),i=n.findIndex((e=>e&&!e.had_recent_input));n.forEach(((e,n)=>{if(!e||!e.impacted_nodes||!e.score)return;if(-1!==i&&n>=i&&e.had_recent_input)return;let a=0;const s=new Map;e.impacted_nodes.forEach((e=>{if(!e.node_id||!e.old_rect||!e.new_rect)return;const t=TraceElements.traceRectToLHRect(e.old_rect),n=TraceElements.traceRectToLHRect(e.new_rect),i=l.getRectArea(t)+l.getRectArea(n)-l.getRectOverlapArea(t,n);s.set(e.node_id,i),a+=i}));for(const[n,i]of s.entries()){let s=t.get(n)||0;s+=i/a*e.score,t.set(n,s)}}));return[...t.entries()].sort(((e,t)=>t[1]-e[1])).slice(0,5).map((([e,t])=>({nodeId:e,score:t})))}static async getAnimatedElements(e,t){const n=new Map;for(const e of t){if("Animation"!==e.name)continue;if(!e.id2||!e.id2.local)continue;const t=e.id2.local,i=n.get(t)||{begin:void 0,status:void 0}
;"b"===e.ph?i.begin=e:"n"===e.ph&&e.args.data&&void 0!==e.args.data.compositeFailed&&(i.status=e),n.set(t,i)}const i=new Map;for(const{begin:e,status:t}of n.values()){const n=this.getNodeIDFromTraceEvent(e),a=this.getAnimationIDFromTraceEvent(e),s=this.getFailureReasonsFromTraceEvent(t),l=this.getUnsupportedPropertiesFromTraceEvent(t);if(!n||!a)continue;const c=i.get(n)||new Set;c.add({animationId:a,failureReasonsMask:s,unsupportedProperties:l}),i.set(n,c)}const a=[];for(const[t,n]of i){const i=[];for(const{animationId:t,failureReasonsMask:a,unsupportedProperties:s}of n){const n=await this.resolveAnimationName(e,t);i.push({name:n,failureReasonsMask:a,unsupportedProperties:s})}a.push({nodeId:t,animations:i})}return a}async beforePass(e){await e.driver.sendCommand("Animation.enable")}async afterPass(e,t){const n=e.driver;if(!t.trace)throw new Error("Trace is missing!")
;const{largestContentfulPaintEvt:i,mainThreadEvents:l}=s.computeTraceOfTab(t.trace),u=TraceElements.getNodeIDFromTraceEvent(i),d=TraceElements.getTopLayoutShiftElements(l),m=await TraceElements.getAnimatedElements(e,l),p=new Map([["largest-contentful-paint",u?[{nodeId:u}]:[]],["layout-shift",d],["animation",m]]),h=[];for(const[e,t]of p)for(let i=0;i<t.length;i++){const s=t[i].nodeId;let l;try{const e=await n.resolveNodeIdToObjectId(s);if(!e)continue;l=await n.sendCommand("Runtime.callFunctionOn",{objectId:e,functionDeclaration:`function () {\n              ${getNodeDetailsData.toString()};\n              ${a.getNodeDetailsString};\n              return getNodeDetailsData.call(this);\n            }`,returnByValue:!0,awaitPromise:!0})}catch(e){c.captureException(e,{tags:{gatherer:this.name},level:"error"});continue}l&&l.result&&l.result.value&&h.push({traceEventType:e,...l.result.value,score:t[i].score,animations:t[i].animations,nodeId:s})}return await n.sendCommand("Animation.disable"),
h}}t.exports=TraceElements},{"../../lib/page-functions.js":97,"../../lib/rect-helpers.js":98,"../../lib/sentry.js":99,"../../lib/tracehouse/trace-processor.js":107,"./gatherer.js":66}],"../gather/gatherers/viewport-dimensions":[function(e,t,n){"use strict";const i=e("./gatherer.js");function getViewportDimensions(){return Promise.resolve({innerWidth:window.innerWidth,innerHeight:window.innerHeight,outerWidth:window.outerWidth,outerHeight:window.outerHeight,devicePixelRatio:window.devicePixelRatio})}t.exports=class ViewportDimensions extends i{async afterPass(e){const t=e.driver,n=await t.evaluateAsync(`(${getViewportDimensions.toString()}())`,{useIsolation:!0});if(!Object.values(n).every(Number.isFinite)){const e=JSON.stringify(n);throw new Error("ViewportDimensions results were not numeric: "+e)}return n}}},{"./gatherer.js":66}],1:[function(e,t,n){(function(n){"use strict"
;const i=e("../lighthouse-core/index.js"),a=e("../lighthouse-core/gather/connections/raw.js"),s=e("lighthouse-logger"),{registerLocaleData:l,lookupLocale:c}=e("../lighthouse-core/lib/i18n/i18n.js"),u=e("../lighthouse-core/config/constants.js");void 0!==t&&t.exports&&(n.runBundledLighthouse=i),"undefined"!=typeof self&&(n.isDevtools=!0,self.setUpWorkerConnection=function setUpWorkerConnection(e){return new a(e)},self.runLighthouse=i,self.createConfig=function createConfig(e,t){const n={onlyCategories:e,screenEmulation:{disabled:!0}};return"desktop"===t&&(n.throttling=u.throttling.desktopDense4G,n.emulatedUserAgent=u.userAgents.desktop,n.formFactor="desktop"),{extends:"lighthouse:default",plugins:["lighthouse-plugin-publisher-ads"],settings:n}},self.listenForStatus=function listenForStatus(e){s.events.addListener("status",e)},self.registerLocaleData=l,self.lookupLocale=c)}).call(this,"undefined"!=typeof global?global:"undefined"!=typeof self?self:"undefined"!=typeof window?window:{})},{
"../lighthouse-core/config/constants.js":56,"../lighthouse-core/gather/connections/raw.js":59,"../lighthouse-core/index.js":67,"../lighthouse-core/lib/i18n/i18n.js":84,"lighthouse-logger":115}],2:[function(e,t,n){(function(n){"use strict";const i=e("../audit.js"),a=e("../../lib/i18n/i18n.js"),s={failingElementsHeader:"Failing Elements"},l=a.createMessageInstanceIdFn(n,s);t.exports=class AxeAudit extends i{static audit(e){if((e.Accessibility.notApplicable||[]).find((e=>e.id===this.meta.id)))return{score:1,notApplicable:!0};const t=e.Accessibility.incomplete||[],n=t.find((e=>e.id===this.meta.id));if(n&&n.error)return{score:null,errorMessage:"axe-core Error: "+(n.error.message||"Unknown error")};const a=this.meta.scoreDisplayMode===i.SCORING_MODES.INFORMATIVE,c=e.Accessibility.violations||[],u=(a?c.concat(t):c).find((e=>e.id===this.meta.id)),d=u&&u.impact,m=u&&u.tags;if(a&&!u)return{score:1,notApplicable:!0};let p=[];u&&u.nodes&&(p=u.nodes.map((e=>({node:{type:"node",lhId:e.node.lhId,
selector:e.node.selector,path:e.node.devtoolsNodePath,snippet:e.node.snippet,boundingRect:e.node.boundingRect,explanation:e.failureSummary,nodeLabel:e.node.nodeLabel}}))));const h=[{key:"node",itemType:"node",text:l(s.failingElementsHeader)}];let f;return(d||m)&&(f={type:"debugdata",impact:d,tags:m}),{score:Number(void 0===u),details:{...i.makeTableDetails(h,p),debugData:f}}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/accessibility/axe-audit.js")},{"../../lib/i18n/i18n.js":84,"../audit.js":3}],3:[function(e,t,n){"use strict";const{isUnderTest:i}=e("../lib/lh-env.js"),a=e("../lib/statistics.js"),s=e("../report/html/renderer/util.js"),clampTo2Decimals=e=>Math.round(100*e)/100;class Audit{static get DEFAULT_PASS(){return"defaultPass"}static get SCORING_MODES(){return{NUMERIC:"numeric",BINARY:"binary",MANUAL:"manual",INFORMATIVE:"informative",NOT_APPLICABLE:"notApplicable",ERROR:"error"}}static get meta(){throw new Error("Audit meta information must be overridden.")}
static get defaultOptions(){return{}}static audit(e,t){throw new Error("audit() method must be overriden")}static computeLogNormalScore(e,t){const n=a.getLogNormalScore(e,t);return clampTo2Decimals(n)}static assertHeadingKeysExist(e,t){if(t.length&&i)for(const n of e){if(null===n.key)continue;const e=n.key;if(!t.some((t=>e in t)))throw new Error(`"${n.key}" is missing from items`)}}static makeTableDetails(e,t,n){return 0===t.length?{type:"table",headings:[],items:[],summary:n}:(Audit.assertHeadingKeysExist(e,t),{type:"table",headings:e,items:t,summary:n})}static makeListDetails(e){return{type:"list",items:e}}static makeSnippetDetails({content:e,title:t,lineMessages:n,generalMessages:i,node:a,maxLineLength:l=200,maxLinesAroundMessage:c=20}){const u=Audit._makeSnippetLinesArray(e,l);return{type:"snippet",lines:s.filterRelevantLines(u,n,c),title:t,lineMessages:n,generalMessages:i,lineCount:u.length,node:a}}static _makeSnippetLinesArray(e,t){return e.split("\n").map(((e,n)=>{
const i=n+1,a={content:e.slice(0,t),lineNumber:i};return e.length>t&&(a.truncated=!0),a}))}static makeOpportunityDetails(e,t,n,i){return Audit.assertHeadingKeysExist(e,t),{type:"opportunity",headings:0===t.length?[]:e,items:t,overallSavingsMs:n,overallSavingsBytes:i}}static _normalizeAuditScore(e,t,n){if(t!==Audit.SCORING_MODES.BINARY&&t!==Audit.SCORING_MODES.NUMERIC)return null;if(null===e||!Number.isFinite(e))throw new Error(`Invalid score for ${n}: ${e}`);if(e>1)throw new Error(`Audit score for ${n} is > 1`);if(e<0)throw new Error(`Audit score for ${n} is < 0`);return e=clampTo2Decimals(e)}static generateErrorAuditResult(e,t){return Audit.generateAuditResult(e,{score:null,errorMessage:t})}static generateAuditResult(e,t){if(void 0===t.score)throw new Error("generateAuditResult requires a score");let n=e.meta.scoreDisplayMode||Audit.SCORING_MODES.BINARY;t.errorMessage?n=Audit.SCORING_MODES.ERROR:t.notApplicable&&(n=Audit.SCORING_MODES.NOT_APPLICABLE)
;const i=Audit._normalizeAuditScore(t.score,n,e.meta.id);let a=e.meta.title;e.meta.failureTitle&&null!==i&&i<s.PASS_THRESHOLD&&(a=e.meta.failureTitle);const l="numericUnit"in t?t:void 0;return{id:e.meta.id,title:a,description:e.meta.description,score:i,scoreDisplayMode:n,numericValue:l&&l.numericValue,numericUnit:l&&l.numericUnit,displayValue:t.displayValue,explanation:t.explanation,errorMessage:t.errorMessage,warnings:t.warnings,details:t.details}}}t.exports=Audit},{"../lib/lh-env.js":91,"../lib/statistics.js":102,"../report/html/renderer/util.js":111}],4:[function(e,t,n){(function(n){"use strict";const i=e("../audit.js"),a=e("../../lib/statistics.js").linearInterpolation,s=e("../../computed/metrics/lantern-interactive.js"),l=e("../../lib/i18n/i18n.js"),c=e("../../computed/network-records.js"),u=e("../../computed/load-simulator.js"),d=e("../../computed/page-dependency-graph.js"),m=l.createMessageInstanceIdFn(n,{});class UnusedBytes extends i{static scoreForWastedMs(e){
return 0===e?1:e<300?a(0,1,300,.75,e):e<750?a(300,.75,750,.5,e):Math.max(0,a(750,.5,5e3,0,e))}static estimateTransferSize(e,t,n){if(e){if(e.resourceType===n)return e.transferSize||0;{const n=e.transferSize||0,i=e.resourceSize||0,a=Number.isFinite(i)&&i>0?n/i:1;return Math.round(t*a)}}switch(n){case"Stylesheet":return Math.round(.2*t);case"Script":case"Document":return Math.round(.33*t);default:return Math.round(.5*t)}}static audit(e,t){const n=e.traces[i.DEFAULT_PASS],a=e.devtoolsLogs[i.DEFAULT_PASS],s=t&&t.settings||{},l={devtoolsLog:a,settings:s};return c.request(a,t).then((i=>Promise.all([this.audit_(e,i,t),d.request({trace:n,devtoolsLog:a},t),u.request(l,t)]))).then((([e,t,n])=>this.createAuditProduct(e,t,n)))}static computeWasteWithTTIGraph(e,t,n,i){const a=(i=Object.assign({includeLoad:!0,label:this.meta.id},i)).label+"-before",l=i.label+"-after",c=n.simulate(t,{label:a}),u=i.providedWastedBytesByUrl||new Map
;if(!i.providedWastedBytesByUrl)for(const{url:t,wastedBytes:n}of e)u.set(t,(u.get(t)||0)+n);const d=new Map;t.traverse((e=>{if("network"!==e.type)return;const t=u.get(e.record.url);if(!t)return;const n=e.record.transferSize;d.set(e.record.requestId,n),e.record.transferSize=Math.max(n-t,0)}));const m=n.simulate(t,{label:l});t.traverse((e=>{if("network"!==e.type)return;const t=d.get(e.record.requestId);void 0!==t&&(e.record.transferSize=t)}));const p=c.timeInMs-m.timeInMs;let h=s.getLastLongTaskEndTime(c.nodeTimings)-s.getLastLongTaskEndTime(m.nodeTimings);return i.includeLoad&&(h=Math.max(h,p)),10*Math.round(Math.max(h,0)/10)}static createAuditProduct(e,t,n){const a=e.items.sort(((e,t)=>t.wastedBytes-e.wastedBytes)),s=a.reduce(((e,t)=>e+t.wastedBytes),0),c=this.computeWasteWithTTIGraph(a,t,n,{providedWastedBytesByUrl:e.wastedBytesByUrl});let u=e.displayValue||"";void 0===e.displayValue&&s&&(u=m(l.UIStrings.displayValueByteSavings,{wastedBytes:s}))
;const d=i.makeOpportunityDetails(e.headings,a,c,s);return{explanation:e.explanation,warnings:e.warnings,displayValue:u,numericValue:c,numericUnit:"millisecond",score:UnusedBytes.scoreForWastedMs(c),details:d}}static audit_(e,t,n){throw new Error("audit_ unimplemented")}}t.exports=UnusedBytes}).call(this,"/lighthouse-core/audits/byte-efficiency/byte-efficiency-audit.js")},{"../../computed/load-simulator.js":12,"../../computed/metrics/lantern-interactive.js":27,"../../computed/network-records.js":42,"../../computed/page-dependency-graph.js":43,"../../lib/i18n/i18n.js":84,"../../lib/statistics.js":102,"../audit.js":3}],5:[function(e,t,n){t.exports={
moduleSizes:[498,155,242,615,220,657,651,1664,790,1534,558,279,868,974,618,356,720,133,826,732,235,552,170,585,1030,210,349,179,546,167,1634,118,199,478,849,470,452,417,147,60,180,433,360,303,1325,1518,397,201,550,226,132,156,198,312,544,2125,658,778,1084,701,401,81,716,632,321,428,648,804,718,130,1443,142,374,259,286,403,821,938,514,654,280,328,186,233,243,553,267,187,206,879,105,343,779,833,773,275,477,696,224,759,671,772,746,716,182,304,658,473,592,235,334,277,404,420,280,675,1034,508,725,526,498,498,499,752,661,276,275,843,1698,962,562,609,573,1048,205,374,226,625,632,308,772,641,233],dependencies:{"Array.prototype.fill":[3,5,8,17,19,21,22,29,30,35,38,39,40,42,43,45,48,51,52,53,55,56,58,60,61,63,64,65,68,69,70,71,72,73,74,75,80,81,82,83,84,87,88,89,91],"Array.prototype.filter":[1,8,9,10,12,14,17,19,21,22,27,28,29,30,33,35,38,39,42,43,45,47,48,51,52,53,58,60,61,63,65,68,69,70,71,72,73,74,75,80,81,82,83,84,87,88,89,92],
"Array.prototype.find":[1,3,8,9,12,14,17,19,21,22,29,30,33,35,38,39,40,42,43,45,47,48,51,52,53,55,56,58,60,61,63,64,65,68,69,70,71,72,73,74,75,80,81,82,83,84,87,88,89,94],"Array.prototype.findIndex":[1,3,8,9,12,14,17,19,21,22,29,30,33,35,38,39,40,42,43,45,47,48,51,52,53,55,56,58,60,61,63,64,65,68,69,70,71,72,73,74,75,80,81,82,83,84,87,88,89,93],"Array.prototype.forEach":[1,6,8,9,11,12,14,17,19,21,22,29,30,33,35,38,39,42,43,45,47,48,51,52,53,58,60,61,63,65,68,69,70,71,72,73,74,75,80,81,82,83,84,87,88,89,95],"Array.from":[1,7,8,15,16,17,18,19,21,22,23,29,30,33,35,36,38,39,42,43,45,46,48,51,52,53,58,60,61,63,65,68,69,70,71,72,73,74,75,80,81,82,83,84,86,87,88,89,96],"Array.isArray":[8,17,19,21,22,29,30,35,38,39,42,43,45,47,48,51,53,58,60,61,63,65,68,69,70,71,72,73,74,75,80,81,82,83,87,98],"Array.prototype.map":[1,8,9,10,12,14,17,19,21,22,27,28,29,30,33,35,38,39,42,43,45,47,48,51,52,53,58,60,61,63,65,68,69,70,71,72,73,74,75,80,81,82,83,84,87,88,89,99],
"Array.of":[8,17,19,21,22,23,29,30,35,38,39,42,43,45,48,51,53,58,60,61,63,65,68,69,70,71,72,73,74,75,80,81,82,83,87,100],"Array.prototype.reduce":[1,8,11,12,13,17,19,21,22,29,30,35,38,39,42,43,45,48,51,53,58,60,61,63,65,68,69,70,71,72,73,74,75,80,81,82,83,84,87,102],"Array.prototype.reduceRight":[1,8,11,12,13,17,19,21,22,29,30,35,38,39,42,43,45,48,51,53,58,60,61,63,65,68,69,70,71,72,73,74,75,80,81,82,83,84,87,101],"Array.prototype.some":[1,8,9,11,12,14,17,19,21,22,29,30,33,35,38,39,42,43,45,47,48,51,52,53,58,60,61,63,65,68,69,70,71,72,73,74,75,80,81,82,83,84,87,88,89,103],"Date.now":[8,17,19,21,22,29,30,35,38,39,42,43,45,48,51,53,58,60,61,63,65,68,69,70,71,72,73,74,75,80,81,82,83,87,104],"Date.prototype.toISOString":[8,17,19,21,22,24,29,30,35,38,39,42,43,45,48,51,53,58,60,61,63,65,68,69,70,71,72,73,74,75,77,78,80,81,82,83,87,105],"Date.prototype.toJSON":[8,17,19,21,22,29,30,35,38,39,42,43,45,48,51,53,58,60,61,63,65,68,69,70,71,72,73,74,75,80,81,82,83,84,87,106],
"Date.prototype.toString":[21,22,38,39,43,45,51,53,70,72,73,74,75,87,107],"Function.prototype.name":[108],"Number.isInteger":[8,17,19,21,22,29,30,35,38,39,42,43,45,48,49,51,53,58,60,61,63,65,68,69,70,71,72,73,74,75,80,81,82,83,87,109],"Number.isSafeInteger":[8,17,19,21,22,29,30,35,38,39,42,43,45,48,49,51,53,58,60,61,63,65,68,69,70,71,72,73,74,75,80,81,82,83,87,110],"Number.parseInt":[8,17,19,21,22,29,30,35,38,39,42,43,45,48,51,53,54,58,60,61,63,65,68,69,70,71,72,73,74,75,79,80,81,82,83,87,90,111],"Object.defineProperties":[8,17,19,21,22,29,30,35,38,39,42,43,45,48,51,53,56,58,60,61,63,64,65,68,69,70,71,72,73,74,75,80,81,82,83,87,112],"Object.defineProperty":[8,17,19,21,22,29,30,35,38,39,42,43,45,48,51,53,58,60,61,63,65,68,69,70,71,72,73,74,75,80,81,82,83,87,113],"Object.freeze":[8,17,19,21,22,29,30,32,35,38,39,42,43,44,45,48,51,53,58,60,61,63,65,68,69,70,71,72,73,74,75,80,81,82,83,87,115],
"Object.getOwnPropertyNames":[8,17,19,21,22,29,30,35,38,39,42,43,45,48,51,53,58,59,60,61,63,65,68,69,70,71,72,73,74,75,80,81,82,83,87,117],"Object.getPrototypeOf":[8,17,19,20,21,22,29,30,35,38,39,42,43,45,48,51,53,58,60,61,62,63,65,68,69,70,71,72,73,74,75,80,81,82,83,84,87,118],"Object.isExtensible":[8,17,19,21,22,29,30,35,38,39,42,43,45,48,51,53,58,60,61,63,65,68,69,70,71,72,73,74,75,80,81,82,83,87,119],"Object.isFrozen":[8,17,19,21,22,29,30,35,38,39,42,43,45,48,51,53,58,60,61,63,65,68,69,70,71,72,73,74,75,80,81,82,83,87,120],"Object.isSealed":[8,17,19,21,22,29,30,35,38,39,42,43,45,48,51,53,58,60,61,63,65,68,69,70,71,72,73,74,75,80,81,82,83,87,121],"Object.keys":[8,17,19,21,22,29,30,35,38,39,42,43,45,48,51,53,58,60,61,63,64,65,68,69,70,71,72,73,74,75,80,81,82,83,84,87,122],"Object.preventExtensions":[8,17,19,21,22,29,30,32,35,38,39,42,43,44,45,48,51,53,58,60,61,63,65,68,69,70,71,72,73,74,75,80,81,82,83,87,123],
"Object.seal":[8,17,19,21,22,29,30,32,35,38,39,42,43,44,45,48,51,53,58,60,61,63,65,68,69,70,71,72,73,74,75,80,81,82,83,87,124],"Object.setPrototypeOf":[2,8,17,19,21,22,29,30,35,38,39,42,43,45,48,51,53,58,60,61,63,65,66,68,69,70,71,72,73,74,75,80,81,82,83,87,125],"Reflect.apply":[1,8,17,19,21,22,29,30,35,38,39,42,43,45,48,51,53,58,60,61,63,65,68,69,70,71,72,73,74,75,80,81,82,83,87,127],"Reflect.construct":[1,8,17,19,21,22,29,30,34,35,38,39,40,42,43,45,48,51,53,55,56,58,60,61,63,64,65,68,69,70,71,72,73,74,75,80,81,82,83,87,128],"Reflect.defineProperty":[8,17,19,21,22,29,30,35,38,39,42,43,45,48,51,53,58,60,61,63,65,68,69,70,71,72,73,74,75,80,81,82,83,87,129],"Reflect.deleteProperty":[8,17,19,21,22,29,30,35,38,39,42,43,45,48,51,53,58,60,61,63,65,68,69,70,71,72,73,74,75,80,81,82,83,87,130],"Reflect.get":[8,17,19,20,21,22,29,30,35,38,39,42,43,45,48,51,53,58,60,61,62,63,65,68,69,70,71,72,73,74,75,80,81,82,83,84,87,133],
"Reflect.getOwnPropertyDescriptor":[8,17,19,21,22,29,30,35,38,39,42,43,45,48,51,53,58,60,61,63,65,68,69,70,71,72,73,74,75,80,81,82,83,87,131],"Reflect.getPrototypeOf":[8,17,19,20,21,22,29,30,35,38,39,42,43,45,48,51,53,58,60,61,62,63,65,68,69,70,71,72,73,74,75,80,81,82,83,84,87,132],"Reflect.has":[8,17,19,21,22,29,30,35,38,39,42,43,45,48,51,53,58,60,61,63,65,68,69,70,71,72,73,74,75,80,81,82,83,87,134],"Reflect.isExtensible":[8,17,19,21,22,29,30,35,38,39,42,43,45,48,51,53,58,60,61,63,65,68,69,70,71,72,73,74,75,80,81,82,83,87,135],"Reflect.ownKeys":[8,17,19,21,22,29,30,35,38,39,42,43,45,48,51,53,58,60,61,63,65,68,69,70,71,72,73,74,75,80,81,82,83,87,136],"Reflect.preventExtensions":[8,17,19,21,22,29,30,32,35,38,39,42,43,45,48,51,53,58,60,61,63,65,68,69,70,71,72,73,74,75,80,81,82,83,87,137],"Reflect.setPrototypeOf":[2,8,17,19,21,22,29,30,35,38,39,42,43,45,48,51,53,58,60,61,63,65,66,68,69,70,71,72,73,74,75,80,81,82,83,87,138],
"String.prototype.codePointAt":[8,17,19,21,22,29,30,35,38,39,42,43,45,48,51,53,58,60,61,63,65,68,69,70,71,72,73,74,75,76,80,81,82,83,87,139],"String.fromCodePoint":[8,17,19,21,22,29,30,35,38,39,42,43,45,48,51,53,58,60,61,63,65,68,69,70,71,72,73,74,75,80,81,82,83,87,140],"String.raw":[8,17,19,21,22,29,30,35,38,39,42,43,45,48,51,53,58,60,61,63,65,68,69,70,71,72,73,74,75,80,81,82,83,87,141],"String.prototype.repeat":[8,17,19,21,22,29,30,35,38,39,42,43,45,48,51,53,58,60,61,63,65,68,69,70,71,72,73,74,75,78,80,81,82,83,87,142],"Array.prototype.includes":[3,8,12,17,19,21,22,29,30,35,38,39,40,42,43,45,48,51,52,53,55,56,58,60,61,63,64,65,68,69,70,71,72,73,74,75,80,81,82,83,87,88,89,97],"Object.entries":[8,17,19,21,22,29,30,35,38,39,42,43,45,48,51,53,58,60,61,63,64,65,67,68,69,70,71,72,73,74,75,80,81,82,83,87,114],"Object.getOwnPropertyDescriptors":[8,17,19,21,22,23,29,30,35,38,39,42,43,45,48,51,53,58,60,61,63,65,68,69,70,71,72,73,74,75,80,81,82,83,87,116],
"Object.values":[8,17,19,21,22,29,30,35,38,39,42,43,45,48,51,53,58,60,61,63,64,65,67,68,69,70,71,72,73,74,75,80,81,82,83,87,126]},maxSize:77759,baseSize:3708}},{}],6:[function(e,t,n){"use strict";const i=e("../audit.js");t.exports=class ManualAudit extends i{static get partialMeta(){return{scoreDisplayMode:i.SCORING_MODES.MANUAL,requiredArtifacts:[]}}static audit(){return{score:0}}}},{"../audit.js":3}],7:[function(e,t,n){"use strict";const i=e("./audit.js");t.exports=class MultiCheckAudit extends i{static async audit(e,t){const n=await this.audit_(e,t);return this.createAuditProduct(n)}static createAuditProduct(e){const t={...e,...e.manifestValues,manifestValues:void 0,allChecks:void 0};e.manifestValues&&e.manifestValues.allChecks&&e.manifestValues.allChecks.forEach((e=>{t[e.id]=e.passing}));const n={type:"debugdata",items:[t]};return e.failures.length>0?{score:0,explanation:`Failures: ${e.failures.join(",\n")}.`,details:n}:{score:1,details:n}}static audit_(e,t){
throw new Error("audit_ unimplemented")}}},{"./audit.js":3}],8:[function(e,t,n){"use strict";const i=e("./audit.js");t.exports=class ViolationAudit extends i{static getViolationResults(e,t){const n=new Set;return e.ConsoleMessages.filter((e=>e.url&&"violation"===e.source&&t.test(e.text))).map((e=>({label:"line: "+e.lineNumber,url:e.url}))).filter((e=>{const t=`${e.url}!${e.label}`;return!n.has(t)&&(n.add(t),!0)}))}}},{"./audit.js":3}],9:[function(e,t,n){"use strict";const i=e("../lib/arbitrary-equality-map.js"),a=e("lighthouse-logger");t.exports=function makeComputedArtifact(e){return Object.assign(e,{request:(t,n)=>{const s=n.computedCache,l=e.name,c=s.get(l)||new i;s.set(l,c);const u=c.get(t);if(u)return u;const d={msg:"Computing artifact: "+l,id:"lh:computed:"+l};a.time(d,"verbose");const m=e.compute_(t,n);return c.set(t,m),m.then((()=>a.timeEnd(d))).catch((()=>a.timeEnd(d))),m}})}},{"../lib/arbitrary-equality-map.js":68,"lighthouse-logger":115}],10:[function(e,t,n){"use strict"
;const i=e("./computed-artifact.js"),a=e("../lib/network-request.js"),s=e("./main-resource.js"),l=e("./page-dependency-graph.js");class CriticalRequestChains{static isCritical(e,t){if(!t)throw new Error("mainResource not provided");if(e.requestId===t.requestId)return!0;if(e.isLinkPreload)return!1;for(;e.redirectDestination;)e=e.redirectDestination;const n=e.resourceType===a.TYPES.Document&&e.frameId!==t.frameId;return!([a.TYPES.Image,a.TYPES.XHR,a.TYPES.Fetch,a.TYPES.EventSource].includes(e.resourceType||"Other")||n||e.mimeType&&e.mimeType.startsWith("image/"))&&(!!e.initiatorRequest&&["VeryHigh","High","Medium"].includes(e.priority))}static extractChainsFromGraph(e,t){const n={};const i=new Set;return t.traverse(((t,a)=>{if(i.add(t),"network"!==t.type)return;if(!CriticalRequestChains.isCritical(t.record,e))return;const s=a.filter((e=>"network"===e.type)).reverse().map((e=>e.record));s.some((t=>!CriticalRequestChains.isCritical(t,e)))||function addChain(e){let t=n
;for(const n of e)t[n.requestId]||(t[n.requestId]={request:n,children:{}}),t=t[n.requestId].children}(s)}),(function getNextNodes(e){return e.getDependents().filter((e=>e.getDependencies().every((e=>i.has(e)))))})),n}static async compute_(e,t){const n=await s.request({URL:e.URL,devtoolsLog:e.devtoolsLog},t),i=await l.request({trace:e.trace,devtoolsLog:e.devtoolsLog},t);return CriticalRequestChains.extractChainsFromGraph(n,i)}}t.exports=i(CriticalRequestChains)},{"../lib/network-request.js":96,"./computed-artifact.js":9,"./main-resource.js":13,"./page-dependency-graph.js":43}],11:[function(e,t,n){"use strict";const i=e("lighthouse-logger"),a=e("./computed-artifact.js"),s=e("../lib/cdt/SDK.js");function computeGeneratedFileSizes(e,t){const n=t.split("\n"),a={},s=t.length;let l=s;e.computeLastGeneratedColumns();for(const t of e.mappings()){const s=t.sourceURL,c=t.lineNumber,u=t.columnNumber,d=t.lastColumnNumber;if(!s)continue;const m=n[c];if(null==m){
const t=`${e.url()} mapping for line out of bounds: ${c+1}`;return i.error("JSBundles",t),{errorMessage:t}}if(u>m.length){const t=`${e.url()} mapping for column out of bounds: ${c+1}:${u}`;return i.error("JSBundles",t),{errorMessage:t}}let p=0;if(void 0!==d){if(d>m.length){const t=`${e.url()} mapping for last column out of bounds: ${c+1}:${d}`;return i.error("JSBundles",t),{errorMessage:t}}p=d-u}else p=m.length-u+1;a[s]=(a[s]||0)+p,l-=p}return{files:a,unmappedBytes:l,totalBytes:s}}t.exports=a(class JSBundles{static async compute_(e){const{SourceMaps:t,ScriptElements:n}=e,i=[];for(const e of t){if(!e.map)continue;const{scriptUrl:t,map:a}=e;if(!a.mappings)continue;const l=n.find((e=>e.src===t));if(!l)continue;const c=e.scriptUrl||"compiled.js",u=e.sourceMapUrl||"compiled.js.map",d=a,m=new s.TextSourceMap(c,u,d),p={rawMap:a,script:l,map:m,sizes:computeGeneratedFileSizes(m,l&&l.content?l.content:"")};i.push(p)}return i}})},{"../lib/cdt/SDK.js":72,"./computed-artifact.js":9,
"lighthouse-logger":115}],12:[function(e,t,n){"use strict";const i=e("./computed-artifact.js"),a=e("../config/constants.js"),s=e("../lib/dependency-graph/simulator/simulator.js"),l=e("./network-analysis.js");t.exports=i(class LoadSimulator{static async compute_(e,t){const{throttlingMethod:n,throttling:i,precomputedLanternData:c}=e.settings,u=await l.request(e.devtoolsLog,t),d={additionalRttByOrigin:u.additionalRttByOrigin,serverResponseTimeByOrigin:u.serverResponseTimeByOrigin};switch(c&&(d.additionalRttByOrigin=new Map(Object.entries(c.additionalRttByOrigin)),d.serverResponseTimeByOrigin=new Map(Object.entries(c.serverResponseTimeByOrigin))),n){case"provided":d.rtt=u.rtt,d.throughput=u.throughput,d.cpuSlowdownMultiplier=1,d.layoutTaskMultiplier=1;break;case"devtools":i&&(d.rtt=i.requestLatencyMs/a.throttling.DEVTOOLS_RTT_ADJUSTMENT_FACTOR,d.throughput=1024*i.downloadThroughputKbps/a.throttling.DEVTOOLS_THROUGHPUT_ADJUSTMENT_FACTOR),d.cpuSlowdownMultiplier=1,d.layoutTaskMultiplier=1
;break;case"simulate":i&&(d.rtt=i.rttMs,d.throughput=1024*i.throughputKbps,d.cpuSlowdownMultiplier=i.cpuSlowdownMultiplier)}return new s(d)}static convertAnalysisToSaveableLanternData(e){const t={additionalRttByOrigin:{},serverResponseTimeByOrigin:{}};for(const[n,i]of e.additionalRttByOrigin.entries())n.startsWith("http")&&(t.additionalRttByOrigin[n]=i);for(const[n,i]of e.serverResponseTimeByOrigin.entries())n.startsWith("http")&&(t.serverResponseTimeByOrigin[n]=i);return t}})},{"../config/constants.js":56,"../lib/dependency-graph/simulator/simulator.js":81,"./computed-artifact.js":9,"./network-analysis.js":41}],13:[function(e,t,n){"use strict";const i=e("./computed-artifact.js"),a=e("../lib/dependency-graph/simulator/network-analyzer.js"),s=e("./network-records.js");t.exports=i(class MainResource{static async compute_(e,t){const n=e.URL.finalUrl,i=await s.request(e.devtoolsLog,t),l=a.findMainDocument(i,n);if(!l)throw new Error("Unable to identify the main resource");return l}})},{
"../lib/dependency-graph/simulator/network-analyzer.js":79,"./computed-artifact.js":9,"./network-records.js":42}],14:[function(e,t,n){"use strict";const i=e("./computed-artifact.js"),a=e("../lib/tracehouse/main-thread-tasks.js"),s=e("./trace-of-tab.js");t.exports=i(class MainThreadTasks{static async compute_(e,t){const{mainThreadEvents:n,frames:i,timestamps:l}=await s.request(e,t);return a.getMainThreadTasks(n,i,l.traceEnd)}})},{"../lib/tracehouse/main-thread-tasks.js":105,"./computed-artifact.js":9,"./trace-of-tab.js":47}],15:[function(e,t,n){"use strict";const i=e("./computed-artifact.js"),a=e("../lib/icons.js"),s=["minimal-ui","fullscreen","standalone"];class ManifestValues{static get manifestChecks(){return[{id:"hasStartUrl",failureText:"Manifest does not contain a `start_url`",validate:e=>!!e.start_url.value},{id:"hasIconsAtLeast144px",failureText:"Manifest does not have a PNG icon of at least 144px",validate:e=>a.doExist(e)&&a.pngSizedAtLeast(144,e).length>0},{
id:"hasIconsAtLeast512px",failureText:"Manifest does not have a PNG icon of at least 512px",validate:e=>a.doExist(e)&&a.pngSizedAtLeast(512,e).length>0},{id:"fetchesIcon",failureText:"Manifest icon failed to be fetched",validate:(e,t)=>{const n=["cannot-download-icon","no-icon-available"];return a.doExist(e)&&!t.some((e=>n.includes(e.errorId)))}},{id:"hasPWADisplayValue",failureText:"Manifest's `display` value is not one of: "+s.join(" | "),validate:e=>s.includes(e.display.value)},{id:"hasBackgroundColor",failureText:"Manifest does not have `background_color`",validate:e=>!!e.background_color.value},{id:"hasThemeColor",failureText:"Manifest does not have `theme_color`",validate:e=>!!e.theme_color.value},{id:"hasShortName",failureText:"Manifest does not have `short_name`",validate:e=>!!e.short_name.value},{id:"shortNameLength",failureText:"Manifest's `short_name` is too long (>12 characters) to be displayed on a homescreen without truncation",
validate:e=>!!e.short_name.value&&e.short_name.value.length<=12},{id:"hasName",failureText:"Manifest does not have `name`",validate:e=>!!e.name.value},{id:"hasMaskableIcon",failureText:"Manifest does not have at least one icon that is maskable",validate:e=>a.doExist(e)&&a.containsMaskableIcon(e)}]}static async compute_({WebAppManifest:e,InstallabilityErrors:t}){if(null===e)return{isParseFailure:!0,parseFailureReason:"No manifest was fetched",allChecks:[]};const n=e.value;if(void 0===n)return{isParseFailure:!0,parseFailureReason:"Manifest failed to parse as valid JSON",allChecks:[]};return{isParseFailure:!1,allChecks:ManifestValues.manifestChecks.map((e=>({id:e.id,failureText:e.failureText,passing:e.validate(n,t.errors)})))}}}t.exports=i(ManifestValues)},{"../lib/icons.js":86,"./computed-artifact.js":9}],16:[function(e,t,n){"use strict";const i=e("../computed-artifact.js");t.exports=i(class CumulativeLayoutShiftAllFrames{static async compute_(e){return{
value:e.traceEvents.filter((e=>"LayoutShift"===e.name&&e.args&&e.args.data&&e.args.data.score&&!e.args.data.had_recent_input)).map((e=>e.args.data.score)).reduce(((e,t)=>e+t),0)}}})},{"../computed-artifact.js":9}],17:[function(e,t,n){"use strict";const i=e("../computed-artifact.js"),a=e("../trace-of-tab.js"),s=e("../../lib/lh-error.js");t.exports=i(class CumulativeLayoutShift{static async compute_(e,t){const n=await a.request(e,t);let i;for(let e=n.mainThreadEvents.length-1;e>=0;e--){const t=n.mainThreadEvents[e];if("LayoutShift"===t.name&&t.args&&t.args.data&&t.args.data.is_main_frame){i=t;break}}const l=!!i;if(!i)return{value:0,debugInfo:{finalLayoutShiftTraceEventFound:l}};let c=i.args&&i.args.data&&i.args.data.cumulative_score;if(void 0===c)throw new s(s.errors.LAYOUT_SHIFT_MISSING_DATA);for(let e=0;e<n.mainThreadEvents.length;e++){const t=n.mainThreadEvents[e];if("LayoutShift"===t.name&&t.args&&t.args.data&&t.args.data.is_main_frame){if(!t.args.data.had_recent_input)break
;if("number"!=typeof t.args.data.score)continue;c+=t.args.data.score}}return{value:c,debugInfo:{finalLayoutShiftTraceEventFound:l}}}})},{"../../lib/lh-error.js":92,"../computed-artifact.js":9,"../trace-of-tab.js":47}],18:[function(e,t,n){"use strict";const i=e("../computed-artifact.js"),a=e("./metric.js"),s=e("../../lib/lh-error.js"),l=e("../../lib/tracehouse/trace-processor.js"),c=e("./lantern-estimated-input-latency.js");class EstimatedInputLatency extends a{static calculateRollingWindowEIL(e){const t=e.filter((e=>e.duration>=10));let n=16;for(const i of t){const t=l.getRiskToResponsiveness(e,i.start,i.start+5e3,[.9]);n=Math.max(t[0].time,n)}return n}static computeSimulatedMetric(e,t){return c.request(e,t)}static computeObservedMetric(e){const{firstMeaningfulPaint:t}=e.traceOfTab.timings;if(!t)throw new s(s.errors.NO_FMP);const n=l.getMainThreadTopLevelEvents(e.traceOfTab,t).filter((e=>e.duration>=1));return Promise.resolve({timing:EstimatedInputLatency.calculateRollingWindowEIL(n)})
}}t.exports=i(EstimatedInputLatency)},{"../../lib/lh-error.js":92,"../../lib/tracehouse/trace-processor.js":107,"../computed-artifact.js":9,"./lantern-estimated-input-latency.js":23,"./metric.js":36}],19:[function(e,t,n){"use strict";const i=e("../computed-artifact.js"),a=e("./metric.js"),s=e("./lantern-first-contentful-paint.js");t.exports=i(class FirstContentfulPaint extends a{static computeSimulatedMetric(e,t){return s.request(e,t)}static async computeObservedMetric(e){const{traceOfTab:t}=e;return{timing:t.timings.firstContentfulPaint,timestamp:t.timestamps.firstContentfulPaint}}})},{"../computed-artifact.js":9,"./lantern-first-contentful-paint.js":24,"./metric.js":36}],20:[function(e,t,n){"use strict";const i=e("../computed-artifact.js"),a=e("./metric.js"),s=e("../../lib/tracehouse/trace-processor.js"),l=e("../../lib/lh-error.js"),c=e("./lantern-first-cpu-idle.js"),u=1e3,d=-Math.log(2)/15;class FirstCPUIdle extends a{static getRequiredWindowSizeInMs(e){const t=e/1e3
;return 1e3*(4*Math.exp(d*t)+1)}static getTaskClustersInWindow(e,t,n){const i=[];let a=-1/0,s=[];const l=n+u,isInClusteringWindow=e=>e.start<l;for(let n=t;n<e.length&&isInClusteringWindow(e[n]);n++){const t=e[n];t.start-a>u&&(s=[],i.push(s)),s.push(t),a=t.end}return i.map((e=>{const t=e[0].start,n=e[e.length-1].end;return{start:t,end:n,duration:n-t}})).filter((e=>e.start<n))}static findQuietWindow(e,t,n){if(0===n.length||n[0].start>e+FirstCPUIdle.getRequiredWindowSizeInMs(0))return e;const isBadCluster=t=>(t=>t.start<e+5e3)(t)||(e=>e.duration>250)(t);for(let i=0;i<n.length;i++){const a=n[i].end,s=a+FirstCPUIdle.getRequiredWindowSizeInMs(a-e);if(s>t)throw new l(l.errors.NO_FCPUI_IDLE_PERIOD);if(i+1<n.length&&n[i+1].start-a<=u)continue;if(!FirstCPUIdle.getTaskClustersInWindow(n,i+1,s).some(isBadCluster))return a}throw new l(l.errors.NO_FCPUI_IDLE_PERIOD)}static computeSimulatedMetric(e,t){return c.request(e,t)}static async computeObservedMetric(e){
const{traceOfTab:t}=e,n=t.timestamps.timeOrigin,i=t.timings.firstMeaningfulPaint,a=t.timings.domContentLoaded,c=t.timings.traceEnd;if(!i||!a)throw new l(i?l.errors.NO_DCL:l.errors.NO_FMP);if(c-i<5e3)throw new l(l.errors.FMP_TOO_LATE_FOR_FCPUI);const u=s.getMainThreadTopLevelEvents(t,i).filter((e=>e.duration>=50)),d=FirstCPUIdle.findQuietWindow(i,c,u),m=Math.max(d,a);return Promise.resolve({timing:m,timestamp:1e3*m+n})}}t.exports=i(FirstCPUIdle)},{"../../lib/lh-error.js":92,"../../lib/tracehouse/trace-processor.js":107,"../computed-artifact.js":9,"./lantern-first-cpu-idle.js":25,"./metric.js":36}],21:[function(e,t,n){"use strict";const i=e("../computed-artifact.js"),a=e("./metric.js"),s=e("../../lib/lh-error.js"),l=e("./lantern-first-meaningful-paint.js");t.exports=i(class FirstMeaningfulPaint extends a{static computeSimulatedMetric(e,t){return l.request(e,t)}static async computeObservedMetric(e){const{traceOfTab:t}=e
;if(void 0===t.timings.firstMeaningfulPaint)throw new s(s.errors.NO_FMP);return{timing:t.timings.firstMeaningfulPaint,timestamp:t.timestamps.firstMeaningfulPaint}}})},{"../../lib/lh-error.js":92,"../computed-artifact.js":9,"./lantern-first-meaningful-paint.js":26,"./metric.js":36}],22:[function(e,t,n){"use strict";const i=e("../computed-artifact.js"),a=e("./metric.js"),s=e("./lantern-interactive.js"),l=e("../../lib/network-recorder.js"),c=e("../../lib/tracehouse/trace-processor.js"),u=e("../../lib/lh-error.js"),d=5e3;class Interactive extends a{static _findNetworkQuietPeriods(e,t){const n=t.timestamps.traceEnd/1e3,i=e.filter((e=>e.finished&&"GET"===e.requestMethod&&!e.failed&&e.statusCode<400));return l.findNetworkQuietPeriods(i,2,n)}static _findCPUQuietPeriods(e,t){const n=t.timestamps.timeOrigin/1e3,i=t.timestamps.traceEnd/1e3;if(0===e.length)return[{start:0,end:i}];const a=[];return e.forEach(((t,s)=>{0===s&&a.push({start:0,end:t.start+n}),s===e.length-1?a.push({start:t.end+n,end:i
}):a.push({start:t.end+n,end:e[s+1].start+n})})),a}static findOverlappingQuietPeriods(e,t,n){const i=n.timestamps.firstContentfulPaint/1e3,isLongEnoughQuietPeriod=e=>e.end>i+d&&e.end-e.start>=d,a=this._findNetworkQuietPeriods(t,n).filter(isLongEnoughQuietPeriod),s=this._findCPUQuietPeriods(e,n).filter(isLongEnoughQuietPeriod),l=s.slice(),c=a.slice();let m=l.shift(),p=c.shift();for(;m&&p;)if(m.start>=p.start){if(p.end>=m.start+d)return{cpuQuietPeriod:m,networkQuietPeriod:p,cpuQuietPeriods:s,networkQuietPeriods:a};p=c.shift()}else{if(m.end>=p.start+d)return{cpuQuietPeriod:m,networkQuietPeriod:p,cpuQuietPeriods:s,networkQuietPeriods:a};m=l.shift()}throw new u(m?u.errors.NO_TTI_NETWORK_IDLE_PERIOD:u.errors.NO_TTI_CPU_IDLE_PERIOD)}static computeSimulatedMetric(e,t){return s.request(e,t)}static computeObservedMetric(e){const{traceOfTab:t,networkRecords:n}=e;if(!t.timestamps.domContentLoaded)throw new u(u.errors.NO_DCL)
;const i=c.getMainThreadTopLevelEvents(t).filter((e=>e.duration>=50)),a=Interactive.findOverlappingQuietPeriods(i,n,t).cpuQuietPeriod,s=1e3*Math.max(a.start,t.timestamps.firstContentfulPaint/1e3,t.timestamps.domContentLoaded/1e3),l=(s-t.timestamps.timeOrigin)/1e3;return Promise.resolve({timing:l,timestamp:s})}}t.exports=i(Interactive)},{"../../lib/lh-error.js":92,"../../lib/network-recorder.js":95,"../../lib/tracehouse/trace-processor.js":107,"../computed-artifact.js":9,"./lantern-interactive.js":27,"./metric.js":36}],23:[function(e,t,n){"use strict";const i=e("../computed-artifact.js"),a=e("./lantern-metric.js"),s=e("../../lib/dependency-graph/base-node.js"),l=e("./lantern-first-meaningful-paint.js");class LanternEstimatedInputLatency extends a{static get COEFFICIENTS(){return{intercept:0,optimistic:.4,pessimistic:.4}}static getOptimisticGraph(e){return e}static getPessimisticGraph(e){return e}static getEstimateFromSimulation(t,n){if(!n.fmpResult)throw new Error("missing fmpResult")
;const i=n.optimistic?n.fmpResult.pessimisticEstimate.timeInMs:n.fmpResult.optimisticEstimate.timeInMs,a=LanternEstimatedInputLatency.getEventsAfterFMP(t.nodeTimings,i);return{timeInMs:e("./estimated-input-latency.js").calculateRollingWindowEIL(a),nodeTimings:t.nodeTimings}}static async compute_(e,t){const n=await l.request(e,t);return this.computeMetricWithGraphs(e,t,{fmpResult:n})}static getEventsAfterFMP(e,t){const n=[];for(const[i,a]of e.entries())i.type===s.TYPES.CPU&&(a.endTime<t||n.push({start:a.startTime,end:a.endTime,duration:a.duration}));return n.sort(((e,t)=>e.start-t.start))}}t.exports=i(LanternEstimatedInputLatency)},{"../../lib/dependency-graph/base-node.js":74,"../computed-artifact.js":9,"./estimated-input-latency.js":18,"./lantern-first-meaningful-paint.js":26,"./lantern-metric.js":30}],24:[function(e,t,n){"use strict";const i=e("../computed-artifact.js"),a=e("./lantern-metric.js"),s=e("../../lib/dependency-graph/base-node.js")
;t.exports=i(class LanternFirstContentfulPaint extends a{static get COEFFICIENTS(){return{intercept:0,optimistic:.5,pessimistic:.5}}static getBlockingNodeData(e,t,n,i){const l=new Map,c=[];e.traverse((e=>{if(e.type===s.TYPES.CPU){e.startTime<=t&&c.push(e);const n=e.getEvaluateScriptURLs();for(const t of n){const n=l.get(t)||e;l.set(t,e.startTime<n.startTime?e:n)}}})),c.sort(((e,t)=>e.startTime-t.startTime));const u=a.getScriptUrls(e,(e=>e.endTime<=t&&n(e))),d=new Set,m=new Set;for(const e of u){const t=l.get(e);t&&(c.includes(t)?m.add(t.id):d.add(e))}const p=c.find((e=>e.didPerformLayout()));p&&m.add(p.id);const h=c.find((e=>e.childEvents.some((e=>"Paint"===e.name))));h&&m.add(h.id);const f=c.find((e=>e.childEvents.some((e=>"ParseHTML"===e.name))));return f&&m.add(f.id),i&&c.filter(i).forEach((e=>m.add(e.id))),{definitelyNotRenderBlockingScriptUrls:d,blockingCpuNodeIds:m}}static getFirstPaintBasedGraph(e,t,n,i){
const{definitelyNotRenderBlockingScriptUrls:a,blockingCpuNodeIds:l}=this.getBlockingNodeData(e,t,n,i);return e.cloneWithRelationships((e=>{if(e.type===s.TYPES.NETWORK){if(e.endTime>t&&!e.isMainDocument())return!1;const i=e.record.url;return!a.has(i)&&n(e)}return l.has(e.id)}))}static getOptimisticGraph(e,t){return this.getFirstPaintBasedGraph(e,t.timestamps.firstContentfulPaint,(e=>e.hasRenderBlockingPriority()&&"script"!==e.initiatorType))}static getPessimisticGraph(e,t){return this.getFirstPaintBasedGraph(e,t.timestamps.firstContentfulPaint,(e=>e.hasRenderBlockingPriority()))}})},{"../../lib/dependency-graph/base-node.js":74,"../computed-artifact.js":9,"./lantern-metric.js":30}],25:[function(e,t,n){"use strict";const i=e("../computed-artifact.js"),a=e("../../lib/dependency-graph/base-node.js"),s=e("./lantern-interactive.js");class LanternFirstCPUIdle extends s{static get COEFFICIENTS(){return{intercept:0,optimistic:1,pessimistic:0}}static getEstimateFromSimulation(e,t){
const n=t.optimistic?t.fmpResult.optimisticEstimate.timeInMs:t.fmpResult.pessimisticEstimate.timeInMs;return{timeInMs:LanternFirstCPUIdle.getFirstCPUIdleWindowStart(e.nodeTimings,n),nodeTimings:e.nodeTimings}}static getFirstCPUIdleWindowStart(t,n,i=50){const s=[];for(const[e,n]of t.entries())e.type===a.TYPES.CPU&&(n.duration<i||s.push({start:n.startTime,end:n.endTime}));s.sort(((e,t)=>e.start-t.start));return e("./first-cpu-idle.js").findQuietWindow(n,1/0,s)}static async compute_(e,t){return super.compute_(e,t)}}t.exports=i(LanternFirstCPUIdle)},{"../../lib/dependency-graph/base-node.js":74,"../computed-artifact.js":9,"./first-cpu-idle.js":20,"./lantern-interactive.js":27}],26:[function(e,t,n){"use strict";const i=e("../computed-artifact.js"),a=e("./lantern-metric.js"),s=e("../../lib/lh-error.js"),l=e("./lantern-first-contentful-paint.js");t.exports=i(class LanternFirstMeaningfulPaint extends a{static get COEFFICIENTS(){return{intercept:0,optimistic:.5,pessimistic:.5}}
static getOptimisticGraph(e,t){const n=t.timestamps.firstMeaningfulPaint;if(!n)throw new s(s.errors.NO_FMP);return l.getFirstPaintBasedGraph(e,n,(e=>e.hasRenderBlockingPriority()&&"script"!==e.initiatorType))}static getPessimisticGraph(e,t){const n=t.timestamps.firstMeaningfulPaint;if(!n)throw new s(s.errors.NO_FMP);return l.getFirstPaintBasedGraph(e,n,(e=>e.hasRenderBlockingPriority()),(e=>e.didPerformLayout()))}static async compute_(e,t){const n=await l.request(e,t),i=await this.computeMetricWithGraphs(e,t);return i.timing=Math.max(i.timing,n.timing),i}})},{"../../lib/lh-error.js":92,"../computed-artifact.js":9,"./lantern-first-contentful-paint.js":24,"./lantern-metric.js":30}],27:[function(e,t,n){"use strict";const i=e("../computed-artifact.js"),a=e("./lantern-metric.js"),s=e("../../lib/dependency-graph/base-node.js"),l=e("../../lib/network-request.js"),c=e("./lantern-first-meaningful-paint.js");class LanternInteractive extends a{static get COEFFICIENTS(){return{intercept:0,
optimistic:.5,pessimistic:.5}}static getOptimisticGraph(e){return e.cloneWithRelationships((e=>{if(e.type===s.TYPES.CPU)return e.event.dur>2e4;const t=e.record.resourceType===l.TYPES.Image,n=e.record.resourceType===l.TYPES.Script;return!t&&(n||"High"===e.record.priority||"VeryHigh"===e.record.priority)}))}static getPessimisticGraph(e){return e}static getEstimateFromSimulation(e,t){if(!t.fmpResult)throw new Error("missing fmpResult");const n=LanternInteractive.getLastLongTaskEndTime(e.nodeTimings),i=t.optimistic?t.fmpResult.optimisticEstimate.timeInMs:t.fmpResult.pessimisticEstimate.timeInMs;return{timeInMs:Math.max(i,n),nodeTimings:e.nodeTimings}}static async compute_(e,t){const n=await c.request(e,t),i=await this.computeMetricWithGraphs(e,t,{fmpResult:n});return i.timing=Math.max(i.timing,n.timing),i}static getLastLongTaskEndTime(e,t=50){return Array.from(e.entries()).filter((([e,n])=>e.type===s.TYPES.CPU&&n.duration>t)).map((([e,t])=>t.endTime)).reduce(((e,t)=>Math.max(e||0,t||0)),0)
}}t.exports=i(LanternInteractive)},{"../../lib/dependency-graph/base-node.js":74,"../../lib/network-request.js":96,"../computed-artifact.js":9,"./lantern-first-meaningful-paint.js":26,"./lantern-metric.js":30}],28:[function(e,t,n){"use strict";const i=e("../computed-artifact.js"),a=e("./lantern-metric.js"),s=e("../../lib/lh-error.js"),l=e("./lantern-first-contentful-paint.js");class LanternLargestContentfulPaint extends a{static get COEFFICIENTS(){return{intercept:0,optimistic:.5,pessimistic:.5}}static isNotLowPriorityImageNode(e){if("network"!==e.type)return!0;const t="Image"===e.record.resourceType,n="Low"===e.record.priority||"VeryLow"===e.record.priority;return!t||!n}static getOptimisticGraph(e,t){const n=t.timestamps.largestContentfulPaint;if(!n)throw new s(s.errors.NO_LCP);return l.getFirstPaintBasedGraph(e,n,LanternLargestContentfulPaint.isNotLowPriorityImageNode)}static getPessimisticGraph(e,t){const n=t.timestamps.largestContentfulPaint;if(!n)throw new s(s.errors.NO_LCP)
;return l.getFirstPaintBasedGraph(e,n,(e=>!0),(e=>e.didPerformLayout()))}static getEstimateFromSimulation(e){const t=Array.from(e.nodeTimings.entries()).filter((e=>LanternLargestContentfulPaint.isNotLowPriorityImageNode(e[0]))).map((e=>e[1].endTime));return{timeInMs:Math.max(...t),nodeTimings:e.nodeTimings}}static async compute_(e,t){const n=await l.request(e,t),i=await this.computeMetricWithGraphs(e,t);return i.timing=Math.max(i.timing,n.timing),i}}t.exports=i(LanternLargestContentfulPaint)},{"../../lib/lh-error.js":92,"../computed-artifact.js":9,"./lantern-first-contentful-paint.js":24,"./lantern-metric.js":30}],29:[function(e,t,n){"use strict";const i=e("../computed-artifact.js"),a=e("./lantern-metric.js"),s=e("../../lib/dependency-graph/base-node.js"),l=e("./lantern-first-contentful-paint.js");class LanternMaxPotentialFID extends a{static get COEFFICIENTS(){return{intercept:0,optimistic:.5,pessimistic:.5}}static getOptimisticGraph(e){return e}static getPessimisticGraph(e){return e}
static getEstimateFromSimulation(e,t){if(!t.fcpResult)throw new Error("missing fcpResult");const n=t.optimistic?t.fcpResult.pessimisticEstimate.timeInMs:t.fcpResult.optimisticEstimate.timeInMs,i=LanternMaxPotentialFID.getTimingsAfterFCP(e.nodeTimings,n);return{timeInMs:Math.max(...i.map((e=>e.duration)),16),nodeTimings:e.nodeTimings}}static async compute_(e,t){const n=await l.request(e,t);return super.computeMetricWithGraphs(e,t,{fcpResult:n})}static getTimingsAfterFCP(e,t){return Array.from(e.entries()).filter((([e,n])=>e.type===s.TYPES.CPU&&n.endTime>t)).map((([e,t])=>t))}}t.exports=i(LanternMaxPotentialFID)},{"../../lib/dependency-graph/base-node.js":74,"../computed-artifact.js":9,"./lantern-first-contentful-paint.js":24,"./lantern-metric.js":30}],30:[function(e,t,n){"use strict";const i=e("../../lib/dependency-graph/base-node.js"),a=e("../../lib/network-request.js"),s=e("../trace-of-tab.js"),l=e("../page-dependency-graph.js"),c=e("../load-simulator.js")
;t.exports=class LanternMetricArtifact{static getScriptUrls(e,t){const n=new Set;return e.traverse((e=>{e.type!==i.TYPES.CPU&&e.record.resourceType===a.TYPES.Script&&(t&&!t(e)||n.add(e.record.url))})),n}static get COEFFICIENTS(){throw new Error("COEFFICIENTS unimplemented!")}static getScaledCoefficients(e){return this.COEFFICIENTS}static getOptimisticGraph(e,t){throw new Error("Optimistic graph unimplemented!")}static getPessimisticGraph(e,t){throw new Error("Pessmistic graph unimplemented!")}static getEstimateFromSimulation(e,t){return e}static async computeMetricWithGraphs(e,t,n){const{trace:i,devtoolsLog:a,settings:u}=e,d=this.name.replace("Lantern",""),m=await l.request({trace:i,devtoolsLog:a},t),p=await s.request(i,t),h=e.simulator||await c.request({devtoolsLog:a,settings:u},t),f=this.getOptimisticGraph(m,p),g=this.getPessimisticGraph(m,p);let y={label:"optimistic"+d};const b=h.simulate(f,y);y={label:"optimisticFlex"+d,flexibleOrdering:!0};const v=h.simulate(f,y);y={
label:"pessimistic"+d};const w=h.simulate(g,y),T=this.getEstimateFromSimulation(b.timeInMs<v.timeInMs?b:v,{...n,optimistic:!0}),S=this.getEstimateFromSimulation(w,{...n,optimistic:!1}),E=this.getScaledCoefficients(h.rtt),x=E.intercept>0?Math.min(1,T.timeInMs/1e3):1;return{timing:E.intercept*x+E.optimistic*T.timeInMs+E.pessimistic*S.timeInMs,optimisticEstimate:T,pessimisticEstimate:S,optimisticGraph:f,pessimisticGraph:g}}static async compute_(e,t){return this.computeMetricWithGraphs(e,t)}}},{"../../lib/dependency-graph/base-node.js":74,"../../lib/network-request.js":96,"../load-simulator.js":12,"../page-dependency-graph.js":43,"../trace-of-tab.js":47}],31:[function(e,t,n){"use strict";const i=e("../computed-artifact.js"),a=e("./lantern-metric.js"),s=e("../../lib/dependency-graph/base-node.js"),l=e("../speedline.js"),c=e("./lantern-first-contentful-paint.js"),u=e("../../config/constants.js").throttling;class LanternSpeedIndex extends a{static get COEFFICIENTS(){return{intercept:-250,
optimistic:1.4,pessimistic:.65}}static getScaledCoefficients(e){const t=this.COEFFICIENTS,n=u.mobileSlow4G.rttMs-30,i=Math.max((e-30)/n,0);return{intercept:t.intercept*i,optimistic:.5+(t.optimistic-.5)*i,pessimistic:.5+(t.pessimistic-.5)*i}}static getOptimisticGraph(e){return e}static getPessimisticGraph(e){return e}static getEstimateFromSimulation(e,t){if(!t.fcpResult)throw new Error("missing fcpResult");if(!t.speedline)throw new Error("missing speedline");const n=t.fcpResult.pessimisticEstimate.timeInMs;return{timeInMs:t.optimistic?t.speedline.speedIndex:LanternSpeedIndex.computeLayoutBasedSpeedIndex(e.nodeTimings,n),nodeTimings:e.nodeTimings}}static async compute_(e,t){const n=await l.request(e.trace,t),i=await c.request(e,t),a=await this.computeMetricWithGraphs(e,t,{speedline:n,fcpResult:i});return a.timing=Math.max(a.timing,i.timing),a}static computeLayoutBasedSpeedIndex(e,t){const n=[]
;for(const[t,i]of e.entries())if(t.type===s.TYPES.CPU&&t.childEvents.some((e=>"Layout"===e.name))){const e=Math.max(Math.log2(i.endTime-i.startTime),0);n.push({time:i.endTime,weight:e})}const i=n.map((e=>e.weight*Math.max(e.time,t))).reduce(((e,t)=>e+t),0),a=n.map((e=>e.weight)).reduce(((e,t)=>e+t),0);return a?i/a:t}}t.exports=i(LanternSpeedIndex)},{"../../config/constants.js":56,"../../lib/dependency-graph/base-node.js":74,"../computed-artifact.js":9,"../speedline.js":46,"./lantern-first-contentful-paint.js":24,"./lantern-metric.js":30}],32:[function(e,t,n){"use strict";const i=e("../computed-artifact.js"),a=e("./lantern-metric.js"),s=e("../../lib/dependency-graph/base-node.js"),l=e("./lantern-first-contentful-paint.js"),c=e("./lantern-interactive.js");class LanternTotalBlockingTime extends a{static get COEFFICIENTS(){return{intercept:0,optimistic:.5,pessimistic:.5}}static getOptimisticGraph(e){return e}static getPessimisticGraph(e){return e}static getEstimateFromSimulation(t,n){
if(!n.fcpResult)throw new Error("missing fcpResult");if(!n.interactiveResult)throw new Error("missing interactiveResult");const i=n.optimistic?n.fcpResult.pessimisticEstimate.timeInMs:n.fcpResult.optimisticEstimate.timeInMs,a=n.optimistic?n.interactiveResult.optimisticEstimate.timeInMs:n.interactiveResult.pessimisticEstimate.timeInMs,s=e("./total-blocking-time.js"),l=s.BLOCKING_TIME_THRESHOLD,c=LanternTotalBlockingTime.getTopLevelEvents(t.nodeTimings,l);return{timeInMs:s.calculateSumOfBlockingTime(c,i,a),nodeTimings:t.nodeTimings}}static async compute_(e,t){const n=await l.request(e,t),i=await c.request(e,t);return this.computeMetricWithGraphs(e,t,{fcpResult:n,interactiveResult:i})}static getTopLevelEvents(e,t){const n=[];for(const[i,a]of e.entries())i.type===s.TYPES.CPU&&(a.duration<t||n.push({start:a.startTime,end:a.endTime,duration:a.duration}));return n}}t.exports=i(LanternTotalBlockingTime)},{"../../lib/dependency-graph/base-node.js":74,"../computed-artifact.js":9,
"./lantern-first-contentful-paint.js":24,"./lantern-interactive.js":27,"./lantern-metric.js":30,"./total-blocking-time.js":39}],33:[function(e,t,n){"use strict";const i=e("../computed-artifact.js"),a=e("./metric.js"),s=e("../../lib/lh-error.js");t.exports=i(class LargestContentfulPaintAllFrames extends a{static async computeSimulatedMetric(){throw new Error("LCP All Frames not implemented in lantern")}static async computeObservedMetric(e){const{traceOfTab:t}=e;if(void 0===t.timings.largestContentfulPaintAllFrames)throw new s(s.errors.NO_LCP_ALL_FRAMES);return{timing:t.timings.largestContentfulPaintAllFrames,timestamp:t.timestamps.largestContentfulPaintAllFrames}}})},{"../../lib/lh-error.js":92,"../computed-artifact.js":9,"./metric.js":36}],34:[function(e,t,n){"use strict";const i=e("../computed-artifact.js"),a=e("./metric.js"),s=e("../../lib/lh-error.js"),l=e("./lantern-largest-contentful-paint.js");t.exports=i(class LargestContentfulPaint extends a{static computeSimulatedMetric(e,t){
return l.request(e,t)}static async computeObservedMetric(e){const{traceOfTab:t}=e;if(void 0===t.timings.largestContentfulPaint)throw new s(s.errors.NO_LCP);return{timing:t.timings.largestContentfulPaint,timestamp:t.timestamps.largestContentfulPaint}}})},{"../../lib/lh-error.js":92,"../computed-artifact.js":9,"./lantern-largest-contentful-paint.js":28,"./metric.js":36}],35:[function(e,t,n){"use strict";const i=e("../computed-artifact.js"),a=e("./metric.js"),s=e("./lantern-max-potential-fid.js"),l=e("../../lib/lh-error.js"),c=e("../../lib/tracehouse/trace-processor.js");t.exports=i(class MaxPotentialFID extends a{static computeSimulatedMetric(e,t){return s.request(e,t)}static computeObservedMetric(e){const{firstContentfulPaint:t}=e.traceOfTab.timings;if(!t)throw new l(l.errors.NO_FCP);const n=c.getMainThreadTopLevelEvents(e.traceOfTab,t).filter((e=>e.duration>=1));return Promise.resolve({timing:Math.max(...n.map((e=>e.duration)),16)})}})},{"../../lib/lh-error.js":92,
"../../lib/tracehouse/trace-processor.js":107,"../computed-artifact.js":9,"./lantern-max-potential-fid.js":29,"./metric.js":36}],36:[function(e,t,n){"use strict";const i=e("../../lib/tracehouse/trace-processor.js"),a=e("../trace-of-tab.js"),s=e("../network-records.js");t.exports=class ComputedMetric{constructor(){}static computeSimulatedMetric(e,t){throw new Error("Unimplemented")}static computeObservedMetric(e,t){throw new Error("Unimplemented")}static async compute_(e,t){const{trace:n,devtoolsLog:l,settings:c}=e;if(!n||!l||!c)throw new Error("Did not provide necessary metric computation data");const u=Object.assign({networkRecords:await s.request(l,t),traceOfTab:await a.request(n,t)},e);switch(i.assertHasToplevelEvents(u.traceOfTab.mainThreadEvents),c.throttlingMethod){case"simulate":return this.computeSimulatedMetric(u,t);case"provided":case"devtools":return this.computeObservedMetric(u,t);default:throw new TypeError("Unrecognized throttling method: "+c.throttlingMethod)}}}},{
"../../lib/tracehouse/trace-processor.js":107,"../network-records.js":42,"../trace-of-tab.js":47}],37:[function(e,t,n){"use strict";const i=e("../computed-artifact.js"),a=e("./metric.js"),s=e("./lantern-speed-index.js"),l=e("../speedline.js");t.exports=i(class SpeedIndex extends a{static computeSimulatedMetric(e,t){return s.request(e,t)}static async computeObservedMetric(e,t){const n=await l.request(e.trace,t),i=Math.round(n.speedIndex),a=1e3*(i+n.beginning);return Promise.resolve({timing:i,timestamp:a})}})},{"../computed-artifact.js":9,"../speedline.js":46,"./lantern-speed-index.js":31,"./metric.js":36}],38:[function(e,t,n){"use strict"
;const i=e("../trace-of-tab.js"),a=e("../speedline.js"),s=e("./first-contentful-paint.js"),l=e("./first-meaningful-paint.js"),c=e("./largest-contentful-paint.js"),u=e("./largest-contentful-paint-all-frames.js"),d=e("./first-cpu-idle.js"),m=e("./interactive.js"),p=e("./cumulative-layout-shift.js"),h=e("./cumulative-layout-shift-all-frames.js"),f=e("./speed-index.js"),g=e("./estimated-input-latency.js"),y=e("./max-potential-fid.js"),b=e("./total-blocking-time.js"),v=e("../computed-artifact.js");class TimingSummary{static async summarize(e,t,n){const v={trace:e,devtoolsLog:t,settings:n.settings
},requestOrUndefined=(e,t)=>e.request(t,n).catch((e=>{})),w=await i.request(e,n),T=await a.request(e,n),S=await s.request(v,n),E=await l.request(v,n),x=await requestOrUndefined(c,v),_=await requestOrUndefined(u,v),k=await requestOrUndefined(d,v),A=await requestOrUndefined(m,v),D=await requestOrUndefined(p,e),R=await requestOrUndefined(h,e),j=await requestOrUndefined(y,v),I=await requestOrUndefined(f,v),C=await g.request(v,n),N=await b.request(v,n),L=D&&null!==D.value?D.value:void 0,M=R?R.value:void 0;return{metrics:{firstContentfulPaint:S.timing,firstContentfulPaintTs:S.timestamp,firstMeaningfulPaint:E.timing,firstMeaningfulPaintTs:E.timestamp,largestContentfulPaint:x&&x.timing,largestContentfulPaintTs:x&&x.timestamp,largestContentfulPaintAllFrames:_&&_.timing,largestContentfulPaintAllFramesTs:_&&_.timestamp,firstCPUIdle:k&&k.timing,firstCPUIdleTs:k&&k.timestamp,interactive:A&&A.timing,interactiveTs:A&&A.timestamp,speedIndex:I&&I.timing,speedIndexTs:I&&I.timestamp,
estimatedInputLatency:C.timing,estimatedInputLatencyTs:C.timestamp,totalBlockingTime:N.timing,maxPotentialFID:j&&j.timing,cumulativeLayoutShift:L,cumulativeLayoutShiftAllFrames:M,observedTimeOrigin:w.timings.timeOrigin,observedTimeOriginTs:w.timestamps.timeOrigin,observedNavigationStart:w.timings.timeOrigin,observedNavigationStartTs:w.timestamps.timeOrigin,observedFirstPaint:w.timings.firstPaint,observedFirstPaintTs:w.timestamps.firstPaint,observedFirstContentfulPaint:w.timings.firstContentfulPaint,observedFirstContentfulPaintTs:w.timestamps.firstContentfulPaint,observedFirstMeaningfulPaint:w.timings.firstMeaningfulPaint,observedFirstMeaningfulPaintTs:w.timestamps.firstMeaningfulPaint,observedLargestContentfulPaint:w.timings.largestContentfulPaint,observedLargestContentfulPaintTs:w.timestamps.largestContentfulPaint,observedLargestContentfulPaintAllFrames:w.timings.largestContentfulPaintAllFrames,observedLargestContentfulPaintAllFramesTs:w.timestamps.largestContentfulPaintAllFrames,
observedTraceEnd:w.timings.traceEnd,observedTraceEndTs:w.timestamps.traceEnd,observedLoad:w.timings.load,observedLoadTs:w.timestamps.load,observedDomContentLoaded:w.timings.domContentLoaded,observedDomContentLoadedTs:w.timestamps.domContentLoaded,observedCumulativeLayoutShift:L,observedCumulativeLayoutShiftAllFrames:M,observedFirstVisualChange:T.first,observedFirstVisualChangeTs:1e3*(T.first+T.beginning),observedLastVisualChange:T.complete,observedLastVisualChangeTs:1e3*(T.complete+T.beginning),observedSpeedIndex:T.speedIndex,observedSpeedIndexTs:1e3*(T.speedIndex+T.beginning)},debugInfo:{lcpInvalidated:w.lcpInvalidated}}}static async compute_(e,t){return TimingSummary.summarize(e.trace,e.devtoolsLog,t)}}t.exports=v(TimingSummary)},{"../computed-artifact.js":9,"../speedline.js":46,"../trace-of-tab.js":47,"./cumulative-layout-shift-all-frames.js":16,"./cumulative-layout-shift.js":17,"./estimated-input-latency.js":18,"./first-contentful-paint.js":19,"./first-cpu-idle.js":20,
"./first-meaningful-paint.js":21,"./interactive.js":22,"./largest-contentful-paint-all-frames.js":33,"./largest-contentful-paint.js":34,"./max-potential-fid.js":35,"./speed-index.js":37,"./total-blocking-time.js":39}],39:[function(e,t,n){"use strict";const i=e("../computed-artifact.js"),a=e("./metric.js"),s=e("../../lib/lh-error.js"),l=e("../../lib/tracehouse/trace-processor.js"),c=e("./lantern-total-blocking-time.js"),u=e("./interactive.js");class TotalBlockingTime extends a{static get BLOCKING_TIME_THRESHOLD(){return 50}static calculateSumOfBlockingTime(e,t,n){if(n<=t)return 0;const i=TotalBlockingTime.BLOCKING_TIME_THRESHOLD;let a=0;for(const s of e){if(s.duration<i)continue;if(s.end<t)continue;if(s.start>n)continue;const e=Math.max(s.start,t),l=Math.min(s.end,n)-e;l<i||(a+=l-i)}return a}static computeSimulatedMetric(e,t){return c.request(e,t)}static async computeObservedMetric(e,t){const{firstContentfulPaint:n}=e.traceOfTab.timings;if(!n)throw new s(s.errors.NO_FCP)
;const i=(await u.request(e,t)).timing,a=l.getMainThreadTopLevelEvents(e.traceOfTab);return{timing:TotalBlockingTime.calculateSumOfBlockingTime(a,n,i)}}}t.exports=i(TotalBlockingTime)},{"../../lib/lh-error.js":92,"../../lib/tracehouse/trace-processor.js":107,"../computed-artifact.js":9,"./interactive.js":22,"./lantern-total-blocking-time.js":32,"./metric.js":36}],40:[function(e,t,n){"use strict";const i=e("./computed-artifact.js"),a=e("./js-bundles.js");class ModuleDuplication{static normalizeSource(e){const t=(e=e.replace(/\?$/,"")).lastIndexOf("node_modules");return-1!==t&&(e=e.substring(t)),e}static _shouldIgnoreSource(e){return!!e.includes("webpack/bootstrap")||(!!e.includes("(webpack)/buildin")||!!e.includes("external "))}static _normalizeAggregatedData(e){for(const[t,n]of e.entries()){let i=n;if(i.sort(((e,t)=>t.resourceSize-e.resourceSize)),i.length>1){const e=i[0].resourceSize;i=i.filter((t=>t.resourceSize/e>=.1))}i=i.filter((e=>e.resourceSize>=512)),
i.length>1?e.set(t,i):e.delete(t)}}static async compute_(e,t){const n=await a.request(e,t),i=new Map;for(const{rawMap:e,sizes:t}of n){if("errorMessage"in t)continue;const n=[];i.set(e,n);for(let i=0;i<e.sources.length;i++){if(this._shouldIgnoreSource(e.sources[i]))continue;const a=(e.sourceRoot||"")+e.sources[i],s=t.files[a];n.push({source:ModuleDuplication.normalizeSource(e.sources[i]),resourceSize:s})}}const s=new Map;for(const{rawMap:e,script:t}of n){const n=i.get(e);if(n)for(const e of n){let n=s.get(e.source);n||(n=[],s.set(e.source,n)),n.push({scriptUrl:t.src||"",resourceSize:e.resourceSize})}}return this._normalizeAggregatedData(s),s}}t.exports=i(ModuleDuplication)},{"./computed-artifact.js":9,"./js-bundles.js":11}],41:[function(e,t,n){"use strict";const i=e("./computed-artifact.js"),a=e("../lib/dependency-graph/simulator/network-analyzer.js"),s=e("./network-records.js");class NetworkAnalysis{static computeRTTAndServerResponseTime(e){const t=new Map
;for(const[n,i]of a.estimateRTTByOrigin(e).entries())t.set(n,i.min);const n=Math.min(...Array.from(t.values())),i=a.estimateServerResponseTimeByOrigin(e,{rttByOrigin:t}),s=new Map,l=new Map;for(const[e,a]of i.entries()){const i=t.get(e)||n;s.set(e,i-n),l.set(e,a.median)}return{rtt:n,additionalRttByOrigin:s,serverResponseTimeByOrigin:l}}static async compute_(e,t){const n=await s.request(e,t);return{throughput:a.estimateThroughput(n),...NetworkAnalysis.computeRTTAndServerResponseTime(n)}}}t.exports=i(NetworkAnalysis)},{"../lib/dependency-graph/simulator/network-analyzer.js":79,"./computed-artifact.js":9,"./network-records.js":42}],42:[function(e,t,n){"use strict";const i=e("./computed-artifact.js"),a=e("../lib/network-recorder.js");t.exports=i(class NetworkRecords{static async compute_(e){return a.recordsFromLogs(e)}})},{"../lib/network-recorder.js":95,"./computed-artifact.js":9}],43:[function(e,t,n){"use strict"
;const i=e("./computed-artifact.js"),a=e("../lib/dependency-graph/network-node.js"),s=e("../lib/dependency-graph/cpu-node.js"),l=e("../lib/dependency-graph/simulator/network-analyzer.js"),c=e("../lib/tracehouse/trace-processor.js"),u=e("../lib/network-request.js"),d=e("./trace-of-tab.js"),m=e("./network-records.js"),p=/^video/;class PageDependencyGraph{static getNetworkInitiators(e){if(!e.initiator)return[];if(e.initiator.url)return[e.initiator.url];if("script"===e.initiator.type){const t=new Set;let n=e.initiator.stack;for(;n;){const e=n.callFrames||[];for(const n of e)n.url&&t.add(n.url);n=n.parent}return Array.from(t)}return[]}static getNetworkNodeOutput(e){const t=[],n=new Map,i=new Map,s=new Map;return e.forEach((e=>{if(p.test(e.mimeType))return;for(;n.has(e.requestId);)e.requestId+=":duplicate";const l=new a(e);t.push(l);const c=i.get(e.url)||[];if(c.push(l),n.set(e.requestId,l),i.set(e.url,c),e.frameId&&e.resourceType===u.TYPES.Document&&e.documentURL===e.url){
const t=s.has(e.frameId)?null:l;s.set(e.frameId,t)}})),{nodes:t,idToNodeMap:n,urlToNodeMap:i,frameIdToNodeMap:s}}static getCPUNodes(e){const t=[];let n=0;for(c.assertHasToplevelEvents(e.mainThreadEvents);n<e.mainThreadEvents.length;){const i=e.mainThreadEvents[n];if(n++,!c.isScheduleableTask(i)||!i.dur)continue;const a=[];for(const t=i.ts+i.dur;n<e.mainThreadEvents.length&&e.mainThreadEvents[n].ts<t;n++)a.push(e.mainThreadEvents[n]);t.push(new s(i,a))}return t}static linkNetworkNodes(e,t){t.nodes.forEach((n=>{const i=n.record.initiatorRequest||e.record,a=t.idToNodeMap.get(i.requestId)||e,s=PageDependencyGraph.getNetworkInitiators(n.record);if(s.length?s.forEach((e=>{const i=t.urlToNodeMap.get(e)||[];1===i.length&&i[0].startTime<=n.startTime&&!i[0].isDependentOn(n)?n.addDependency(i[0]):a.isDependentOn(n)||a.addDependent(n)})):a.isDependentOn(n)||a.addDependent(n),n!==e&&0===n.getDependencies().length&&n.addDependency(e),!n.record.redirects)return
;const l=[...n.record.redirects,n.record];for(let e=1;e<l.length;e++){const n=t.idToNodeMap.get(l[e-1].requestId),i=t.idToNodeMap.get(l[e].requestId);i&&n&&i.addDependency(n)}}))}static linkCPUNodes(e,t,n){const i=new Set([u.TYPES.XHR,u.TYPES.Fetch,u.TYPES.Script]);function addDependentNetworkRequest(e,n){const a=t.idToNodeMap.get(n);if(!a||a.startTime<=e.startTime)return;const{record:s}=a,l=s.resourceType||s.redirectDestination&&s.redirectDestination.resourceType;i.has(l)&&e.addDependent(a)}function addDependencyOnFrame(e,n){if(!n)return;const i=t.frameIdToNodeMap.get(n);i&&(i.startTime>=e.startTime||e.addDependency(i))}function addDependencyOnUrl(e,n){if(!n)return;const i=t.urlToNodeMap.get(n)||[];let a=null,s=1/0;for(const t of i){if(e.startTime<=t.startTime)return;const n=e.startTime-t.endTime;n>=-1e5&&n<s&&(a=t,s=n)}a&&e.addDependency(a)}const a=new Map;for(const t of n){for(const e of t.childEvents){if(!e.args.data)continue
;const n=e.args.data.url,i=(e.args.data.stackTrace||[]).map((e=>e.url)).filter(Boolean);switch(e.name){case"TimerInstall":a.set(e.args.data.timerId,t),i.forEach((e=>addDependencyOnUrl(t,e)));break;case"TimerFire":{const n=a.get(e.args.data.timerId);if(!n||n.endTime>t.startTime)break;n.addDependent(t);break}case"InvalidateLayout":case"ScheduleStyleRecalculation":addDependencyOnFrame(t,e.args.data.frame),i.forEach((e=>addDependencyOnUrl(t,e)));break;case"EvaluateScript":addDependencyOnFrame(t,e.args.data.frame),addDependencyOnUrl(t,n),i.forEach((e=>addDependencyOnUrl(t,e)));break;case"XHRReadyStateChange":if(4!==e.args.data.readyState)break;addDependencyOnUrl(t,n),i.forEach((e=>addDependencyOnUrl(t,e)));break;case"FunctionCall":case"v8.compile":addDependencyOnFrame(t,e.args.data.frame),addDependencyOnUrl(t,n);break;case"ParseAuthorStyleSheet":addDependencyOnFrame(t,e.args.data.frame),addDependencyOnUrl(t,e.args.data.styleSheetUrl);break;case"ResourceSendRequest":
addDependencyOnFrame(t,e.args.data.frame),addDependentNetworkRequest(t,e.args.data.requestId),i.forEach((e=>addDependencyOnUrl(t,e)))}}0===t.getNumberOfDependencies()&&t.addDependency(e)}let s=!1,l=!1,c=!1;for(const e of n){let t=!1;!s&&e.childEvents.some((e=>"Layout"===e.name))&&(t=s=!0),!l&&e.childEvents.some((e=>"Paint"===e.name))&&(t=l=!0),!c&&e.childEvents.some((e=>"ParseHTML"===e.name))&&(t=c=!0),t||e.event.dur>=1e4||(1===e.getNumberOfDependencies()||e.getNumberOfDependents()<=1)&&PageDependencyGraph._pruneNode(e)}}static _pruneNode(e){const t=e.getDependencies(),n=e.getDependents();for(const i of t){e.removeDependency(i);for(const e of n)i.addDependent(e)}for(const t of n)e.removeDependent(t)}static createGraph(e,t){const n=PageDependencyGraph.getNetworkNodeOutput(t),i=PageDependencyGraph.getCPUNodes(e),s=t.reduce(((e,t)=>t.startTime<e.startTime?t:e)),c=n.idToNodeMap.get(s.requestId),u=l.findMainDocument(t),d=n.idToNodeMap.get(u.requestId)
;if(!c||!d)throw new Error((c?"mainDocument":"root")+"Node not found.");if(!(d===c||d.record.redirects&&d.record.redirects.includes(c.record)))throw new Error("Root node was not in redirect chain of mainDocument");if(PageDependencyGraph.linkNetworkNodes(c,n),PageDependencyGraph.linkCPUNodes(c,n,i),d.setIsMainDocument(!0),a.hasCycle(c))throw new Error("Invalid dependency graph created, cycle detected");return c}static printGraph(e,t=100){function padRight(e,t,n=" "){return e+n.repeat(Math.max(t-e.length,0))}const n=[];e.traverse((e=>n.push(e))),n.sort(((e,t)=>e.startTime-t.startTime));const i=n[0].startTime,a=(n.reduce(((e,t)=>Math.max(e,t.endTime)),0)-i)/t;n.forEach((e=>{const n=Math.round((e.startTime-i)/a),s=Math.ceil((e.endTime-e.startTime)/a),l=padRight("",n)+padRight("",s,"="),c=e.record?e.record.url:e.type;console.log(padRight(l,t),"| "+c.slice(0,30))}))}static async compute_(e,t){const n=e.trace,i=e.devtoolsLog,[a,s]=await Promise.all([d.request(n,t),m.request(i,t)])
;return PageDependencyGraph.createGraph(a,s)}}t.exports=i(PageDependencyGraph)},{"../lib/dependency-graph/cpu-node.js":75,"../lib/dependency-graph/network-node.js":76,"../lib/dependency-graph/simulator/network-analyzer.js":79,"../lib/network-request.js":96,"../lib/tracehouse/trace-processor.js":107,"./computed-artifact.js":9,"./network-records.js":42,"./trace-of-tab.js":47}],44:[function(e,t,n){"use strict";const i=e("./computed-artifact.js"),a=e("./network-records.js"),s=e("../lib/url-shim.js"),l=e("./main-resource.js"),c=e("../config/budget.js"),u=e("../report/html/renderer/util.js");class ResourceSummary{static determineResourceType(e){if(!e.resourceType)return"other";return{Stylesheet:"stylesheet",Image:"image",Media:"media",Font:"font",Script:"script",Document:"document"}[e.resourceType]||"other"}static summarize(e,t,n){const i={stylesheet:{count:0,resourceSize:0,transferSize:0},image:{count:0,resourceSize:0,transferSize:0},media:{count:0,resourceSize:0,transferSize:0},font:{
count:0,resourceSize:0,transferSize:0},script:{count:0,resourceSize:0,transferSize:0},document:{count:0,resourceSize:0,transferSize:0},other:{count:0,resourceSize:0,transferSize:0},total:{count:0,resourceSize:0,transferSize:0},"third-party":{count:0,resourceSize:0,transferSize:0}},a=c.getMatchingBudget(n.settings.budgets,t);let l=[];if(a&&a.options&&a.options.firstPartyHostnames)l=a.options.firstPartyHostnames;else{const e=u.getRootDomain(t);l=["*."+e]}return e.filter((e=>{if("other"===this.determineResourceType(e)&&e.url.endsWith("/favicon.ico"))return!1;const t=new s(e.url).protocol.slice(0,-1);return!s.NON_NETWORK_PROTOCOLS.includes(t)})).forEach((e=>{const t=this.determineResourceType(e);i[t].count++,i[t].resourceSize+=e.resourceSize,i[t].transferSize+=e.transferSize,i.total.count++,i.total.resourceSize+=e.resourceSize,i.total.transferSize+=e.transferSize;l.some((t=>{const n=new s(e.url);return t.startsWith("*.")?n.hostname.endsWith(t.slice(2)):n.hostname===t
}))||(i["third-party"].count++,i["third-party"].resourceSize+=e.resourceSize,i["third-party"].transferSize+=e.transferSize)})),i}static async compute_(e,t){const[n,i]=await Promise.all([a.request(e.devtoolsLog,t),l.request(e,t)]);return ResourceSummary.summarize(n,i.url,t)}}t.exports=i(ResourceSummary)},{"../config/budget.js":52,"../lib/url-shim.js":"url","../report/html/renderer/util.js":111,"./computed-artifact.js":9,"./main-resource.js":13,"./network-records.js":42}],45:[function(e,t,n){"use strict";const i=e("./computed-artifact.js");t.exports=i(class Screenshots{static async compute_(e){return e.traceEvents.filter((e=>"Screenshot"===e.name)).map((e=>({timestamp:e.ts,datauri:"data:image/jpeg;base64,"+e.args.snapshot})))}})},{"./computed-artifact.js":9}],46:[function(e,t,n){"use strict";const i=e("./computed-artifact.js"),a=e("speedline-core"),s=e("../lib/lh-error.js"),l=e("./trace-of-tab.js");t.exports=i(class Speedline{static async compute_(e,t){return l.request(e,t).then((t=>{
const n=e.traceEvents.slice(),i=t.timestamps.timeOrigin;return a(n,{timeOrigin:i,fastMode:!0,include:"speedIndex"})})).catch((e=>{if(/No screenshots found in trace/.test(e.message))throw new s(s.errors.NO_SCREENSHOTS);throw e})).then((e=>{if(0===e.frames.length)throw new s(s.errors.NO_SPEEDLINE_FRAMES);if(0===e.speedIndex)throw new s(s.errors.SPEEDINDEX_OF_ZERO);return e}))}})},{"../lib/lh-error.js":92,"./computed-artifact.js":9,"./trace-of-tab.js":47,"speedline-core":213}],47:[function(e,t,n){"use strict";const i=e("./computed-artifact.js"),a=e("../lib/lh-error.js"),s=e("../lib/tracehouse/trace-processor.js");class LHTraceProcessor extends s{static createNoNavstartError(){return new a(a.errors.NO_NAVSTART)}static createNoResourceSendRequestError(){return new a(a.errors.NO_RESOURCE_REQUEST)}static createNoTracingStartedError(){return new a(a.errors.NO_TRACING_STARTED)}}t.exports=i(class TraceOfTab{static async compute_(e){
const t=await LHTraceProcessor.computeTraceOfTab(e),{timings:n,timestamps:i,firstContentfulPaintEvt:s}=t,{firstContentfulPaint:l}=n,{firstContentfulPaint:c}=i;if(!s||void 0===l||void 0===c)throw new a(a.errors.NO_FCP);return{...t,firstContentfulPaintEvt:s,timings:{...n,firstContentfulPaint:l},timestamps:{...i,firstContentfulPaint:c}}}})},{"../lib/lh-error.js":92,"../lib/tracehouse/trace-processor.js":107,"./computed-artifact.js":9}],48:[function(e,t,n){"use strict";const i=e("./computed-artifact.js"),a=e("../audits/byte-efficiency/byte-efficiency-audit.js"),s=e("./network-records.js"),l=100;class UnusedCSS{static indexStylesheetsById(e,t){const n=t.filter((e=>e.resourceSize>0)).reduce(((e,t)=>(e[t.url]=t,e)),{});return e.reduce(((e,t)=>(e[t.header.styleSheetId]=Object.assign({usedRules:[],networkRecord:n[t.header.sourceURL]},t),e)),{})}static indexUsedRules(e,t){e.forEach((e=>{const n=t[e.styleSheetId];n&&e.used&&n.usedRules.push(e)}))}static computeUsage(e){let t=0
;const n=e.content.length;for(const n of e.usedRules)t+=n.endOffset-n.startOffset;const i=a.estimateTransferSize(e.networkRecord,n,"Stylesheet"),s=(n-t)/n;return{wastedBytes:Math.round(s*i),wastedPercent:100*s,totalBytes:i}}static determineContentPreview(e){let t=(e||"").slice(0,500).replace(/( {2,}|\t)+/g,"  ").replace(/\n\s+}/g,"\n}").trim();if(t.length>l){const e=t.indexOf("{"),n=t.indexOf("}");if(-1===e||-1===n||e>n||e>l)t=t.slice(0,l)+"...";else if(n<l)t=t.slice(0,n+1)+" ...";else{const n=t.slice(0,l).lastIndexOf(";");t=n<e?t.slice(0,l)+"... } ...":t.slice(0,n+1)+" ... } ..."}}return t}static mapSheetToResult(e,t){let n=e.header.sourceURL;if(!n||n===t){n=UnusedCSS.determineContentPreview(e.content)}return{url:n,...UnusedCSS.computeUsage(e)}}static async compute_(e,t){const{CSSUsage:n,URL:i,devtoolsLog:a}=e,l=await s.request(a,t),c=UnusedCSS.indexStylesheetsById(n.stylesheets,l);UnusedCSS.indexUsedRules(n.rules,c)
;return Object.keys(c).map((e=>UnusedCSS.mapSheetToResult(c[e],i.finalUrl)))}}t.exports=i(UnusedCSS)},{"../audits/byte-efficiency/byte-efficiency-audit.js":4,"./computed-artifact.js":9,"./network-records.js":42}],49:[function(e,t,n){"use strict";const i=e("./computed-artifact.js");class UnusedJavascriptSummary{static computeWaste(e){let t=0;for(const n of e.functions)t=Math.max(t,...n.ranges.map((e=>e.endOffset)));const n=new Uint8Array(t);for(const t of e.functions)for(const e of t.ranges)if(0===e.count)for(let t=e.startOffset;t<e.endOffset;t++)n[t]=1;let i=0;for(const e of n)i+=e;return{unusedByIndex:n,unusedLength:i,contentLength:t}}static createItem(e,t){const n=t.unused/t.content||0,i=Math.round(t.content*n);return{url:e,totalBytes:t.content,wastedBytes:i,wastedPercent:100*n}}static determineLengths(e){let t=0,n=0;for(const i of e)t+=i.unusedLength,n+=i.contentLength;return{content:n,unused:t}}static createSourceWastedBytes(e,t){if(!t.script.content)return
;const n={},i=t.script.content.split("\n").map((e=>e.length));let a=0;const s=i.map((e=>{const t=a;return a+=e+1,t}));t.map.computeLastGeneratedColumns();for(const a of t.map.mappings()){let t=s[a.lineNumber];t+=a.columnNumber;const l=a.lastColumnNumber-1||i[a.lineNumber];for(let i=a.columnNumber;i<=l;i++){if(e.every((e=>1===e.unusedByIndex[t]))){const e=a.sourceURL||"(unmapped)";n[e]=(n[e]||0)+1}t+=1}}const l=Object.entries(n).sort((([e,t],[n,i])=>i-t)),c={};for(const[e,t]of l)c[e]=t;return c}static async compute_(e){const{url:t,scriptCoverages:n,bundle:i}=e,a=n.map(UnusedJavascriptSummary.computeWaste),s=UnusedJavascriptSummary.determineLengths(a),l=UnusedJavascriptSummary.createItem(t,s);return i?{...l,sourcesWastedBytes:UnusedJavascriptSummary.createSourceWastedBytes(a,i)}:l}}t.exports=i(UnusedJavascriptSummary)},{"./computed-artifact.js":9}],50:[function(e,t,n){"use strict";const i=e("./computed-artifact.js"),a=e("./trace-of-tab.js");t.exports=i(class UserTimings{
static async compute_(e,t){const n=await a.request(e,t),i=[],s={};return n.processEvents.filter((e=>!!e.cat.includes("blink.user_timing")&&("requestStart"!==e.name&&"navigationStart"!==e.name&&"paintNonDefaultBackgroundColor"!==e.name&&void 0===e.args.frame))).forEach((e=>{"R"===e.ph||"I"===e.ph.toUpperCase()?i.push({name:e.name,isMark:!0,args:e.args,startTime:e.ts}):"b"===e.ph.toLowerCase()?s[e.name]=e.ts:"e"===e.ph.toLowerCase()&&i.push({name:e.name,isMark:!1,args:e.args,startTime:s[e.name],endTime:e.ts,duration:e.ts-s[e.name]})})),i.forEach((e=>{e.startTime=(e.startTime-n.timeOriginEvt.ts)/1e3,e.isMark||(e.endTime=(e.endTime-n.timeOriginEvt.ts)/1e3,e.duration=e.duration/1e3)})),i}})},{"./computed-artifact.js":9,"./trace-of-tab.js":47}],51:[function(e,t,n){"use strict";const i=e("metaviewport-parser"),a=e("./computed-artifact.js");t.exports=a(class ViewportMeta{static async compute_(e){const t=e.find((e=>"viewport"===e.name));if(!t)return{hasViewportTag:!1,isMobileOptimized:!1,
parserWarnings:[]};const n=[],a=i.parseMetaViewPortContent(t.content||"");Object.keys(a.unknownProperties).length&&n.push("Invalid properties found: "+JSON.stringify(a.unknownProperties)),Object.keys(a.invalidValues).length&&n.push("Invalid values found: "+JSON.stringify(a.invalidValues));const s=a.validProperties;return{hasViewportTag:!0,isMobileOptimized:Boolean(s.width||s["initial-scale"]),parserWarnings:n}}})},{"./computed-artifact.js":9,"metaviewport-parser":178}],52:[function(e,t,n){"use strict";function isArrayOfUnknownObjects(e){return Array.isArray(e)&&e.every(isObjectOfUnknownProperties)}function isObjectOfUnknownProperties(e){return"object"==typeof e&&null!==e&&!Array.isArray(e)}function isNumber(e){return"number"==typeof e&&!isNaN(e)}class Budget{static assertNoExcessProperties(e,t){const n=Object.keys(e);if(n.length>0){const e=n.join(", ");throw new Error(`${t} has unrecognized properties: [${e}]`)}}static assertNoDuplicateStrings(e,t){const n=new Set;for(const i of e){
if(n.has(i))throw new Error(`${t} has duplicate entry of type '${i}'`);n.add(i)}}static validateResourceBudget(e){const{resourceType:t,budget:n,...i}=e;Budget.assertNoExcessProperties(i,"Resource Budget");const a=["total","document","script","stylesheet","image","media","font","other","third-party"];if(!a.includes(t))throw new Error(`Invalid resource type: ${t}. \nValid resource types are: `+a.join(", "));if(!isNumber(n))throw new Error("Invalid budget: "+n);return{resourceType:t,budget:n}}static throwInvalidPathError(e,t){throw new Error(`Invalid path ${e}. ${t}\n'Path' should be specified using the 'robots.txt' format.\nLearn more about the 'robots.txt' format here:\nhttps://developers.google.com/search/reference/robots_txt#url-matching-based-on-path-values`)}static validatePath(e){if(void 0!==e){
if("string"==typeof e)return e.startsWith("/")?(e.match(/\*/g)||[]).length>1?this.throwInvalidPathError(e,"Path should only contain one '*'."):(e.match(/\$/g)||[]).length>1?this.throwInvalidPathError(e,"Path should only contain one '$' character."):e.includes("$")&&!e.endsWith("$")&&this.throwInvalidPathError(e,"'$' character should only occur at end of path."):this.throwInvalidPathError(e,"Path should start with '/'."),e;this.throwInvalidPathError(e,"Path should be a string.")}}static getMatchingBudget(e,t){if(null!==e)for(let n=e.length-1;n>=0;n--){const i=e[n];if(this.urlMatchesPattern(t,i.path))return i}}static urlMatchesPattern(e,t="/"){const n=new URL(e),i=n.pathname+n.search,a=t.includes("*"),s=t.includes("$");if(!a&&!s)return i.startsWith(t);if(!a&&s)return i===t.slice(0,-1);if(a&&!s){const[e,n]=t.split("*"),a=i.slice(e.length);return i.startsWith(e)&&a.includes(n)}if(a&&s){const[e,n]=t.split("*"),a=i.slice(e.length);return i.startsWith(e)&&a.endsWith(n.slice(0,-1))}return!1}
static validateTimingBudget(e){const{metric:t,budget:n,...i}=e;Budget.assertNoExcessProperties(i,"Timing Budget");const a=["first-contentful-paint","first-cpu-idle","interactive","first-meaningful-paint","max-potential-fid","estimated-input-latency","total-blocking-time","speed-index","largest-contentful-paint","cumulative-layout-shift"];if(!a.includes(t))throw new Error(`Invalid timing metric: ${t}. \nValid timing metrics are: `+a.join(", "));if(!isNumber(n))throw new Error("Invalid budget: "+n);return{metric:t,budget:n}}static validateHostname(e){const t=e+" is not a valid hostname.";if(0===e.length)throw new Error(t);if(e.includes("/"))throw new Error(t);if(e.includes(":"))throw new Error(t);if(e.includes("*")&&(!e.startsWith("*.")||e.lastIndexOf("*")>0))throw new Error(t);return e}static validateHostnames(e){if(Array.isArray(e)&&e.every((e=>"string"==typeof e)))return e.map(Budget.validateHostname)
;if(void 0!==e)throw new Error("firstPartyHostnames should be defined as an array of strings.")}static initializeBudget(e){if(!isArrayOfUnknownObjects(e=JSON.parse(JSON.stringify(e))))throw new Error("Budget file is not defined as an array of budgets.");return e.map(((e,t)=>{const n={},{path:i,options:a,resourceSizes:s,resourceCounts:l,timings:c,...u}=e;if(Budget.assertNoExcessProperties(u,"Budget"),n.path=Budget.validatePath(i),isObjectOfUnknownProperties(a)){const{firstPartyHostnames:e,...t}=a;Budget.assertNoExcessProperties(t,"Options property"),n.options={},n.options.firstPartyHostnames=Budget.validateHostnames(e)}else if(void 0!==a)throw new Error("Invalid options property in budget at index "+t);if(isArrayOfUnknownObjects(s))n.resourceSizes=s.map(Budget.validateResourceBudget),Budget.assertNoDuplicateStrings(n.resourceSizes.map((e=>e.resourceType)),`budgets[${t}].resourceSizes`);else if(void 0!==s)throw new Error("Invalid resourceSizes entry in budget at index "+t)
;if(isArrayOfUnknownObjects(l))n.resourceCounts=l.map(Budget.validateResourceBudget),Budget.assertNoDuplicateStrings(n.resourceCounts.map((e=>e.resourceType)),`budgets[${t}].resourceCounts`);else if(void 0!==l)throw new Error("Invalid resourceCounts entry in budget at index "+t);if(isArrayOfUnknownObjects(c))n.timings=c.map(Budget.validateTimingBudget),Budget.assertNoDuplicateStrings(n.timings.map((e=>e.metric)),`budgets[${t}].timings`);else if(void 0!==c)throw new Error("Invalid timings entry in budget at index "+t);return n}))}}t.exports=Budget},{}],53:[function(e,t,n){(function(n,i,a){"use strict";const s=e("path"),l=e("../audits/audit.js"),c=e("../runner.js"),u=e("../lib/i18n/i18n.js"),mergeOptionsOfItems=function(e){const t=[];for(const n of e){const e=n.path&&t.find((e=>e.path===n.path));e?e.options=Object.assign({},e.options,n.options):t.push(n)}return t};function resolveModule(t,i,l){try{return e.resolve(t)}catch(e){}try{return e.resolve(t,{paths:[n.cwd()]})}catch(e){}
const c=s.resolve(n.cwd(),t);try{return e.resolve(c)}catch(e){}const u="Unable to locate "+(l?l+": ":"")+`\`${t}\`.\n     Tried to require() from these locations:\n       ${a}\n       ${c}`;if(!i)throw new Error(u);const d=s.resolve(i,t);try{return e.resolve(d)}catch(e){}try{return e.resolve(t,{paths:[i]})}catch(e){}throw new Error(u+"\n       "+d)}t.exports={mergeOptionsOfItems,requireAudits:function requireAudits(t,n){const d=function expandAuditShorthand(e){return e?e.map((e=>{if("string"==typeof e)return{path:e,options:{}};if("implementation"in e&&"function"==typeof e.implementation.audit)return e;if("path"in e&&"string"==typeof e.path)return e;if("audit"in e&&"function"==typeof e.audit)return{implementation:e,options:{}};throw new Error("Invalid Audit type "+JSON.stringify(e))})):null}(t);if(!d)return null;const m=c.getAuditList(),p=d.map((t=>{let l;if("implementation"in t)l=t.implementation;else{const c=t.path+".js",u=m.find((e=>e===c));let d="../audits/"+t.path
;if(!u)if(i.isDevtools||i.isLightrider)d=t.path;else{const e=resolveModule(t.path,n,"audit");d=s.relative(a,e)}l=e(d)}return{implementation:l,path:t.path,options:t.options||{}}})),h=mergeOptionsOfItems(p);return h.forEach((e=>function assertValidAudit(e){const{implementation:t,path:n}=e,i=n||t&&t.meta&&t.meta.id||"Unknown audit";if("function"!=typeof t.audit||t.audit===l.audit)throw new Error(i+" has no audit() method.");if("string"!=typeof t.meta.id)throw new Error(i+" has no meta.id property, or the property is not a string.");if(!u.isStringOrIcuMessage(t.meta.title))throw new Error(i+" has no meta.title property, or the property is not a string.");if(!u.isStringOrIcuMessage(t.meta.failureTitle)&&t.meta.scoreDisplayMode===l.SCORING_MODES.BINARY)throw new Error(i+" has no failureTitle and should.");if(!u.isStringOrIcuMessage(t.meta.description))throw new Error(i+" has no meta.description property, or the property is not a string.")
;if(""===t.meta.description)throw new Error(i+" has an empty meta.description string. Please add a description for the UI.");if(!Array.isArray(t.meta.requiredArtifacts))throw new Error(i+" has no meta.requiredArtifacts property, or the property is not an array.")}(e))),h},resolveModule}}).call(this,e("_process"),"undefined"!=typeof global?global:"undefined"!=typeof self?self:"undefined"!=typeof window?window:{},"/lighthouse-core/config")},{"../audits/audit.js":3,"../lib/i18n/i18n.js":84,"../runner.js":113,_process:190,path:188}],54:[function(e,t,n){"use strict";const i=e("../lib/i18n/i18n.js");function isArrayOfUnknownObjects(e){return Array.isArray(e)&&e.every(isObjectOfUnknownProperties)}function isObjectOfUnknownProperties(e){return"object"==typeof e&&null!==e&&!Array.isArray(e)}function assertNoExcessProperties(e,t,n=""){n&&(n+=" ");const i=Object.keys(e);if(i.length>0){const e=i.join(", ");throw new Error(`${t} has unrecognized ${n}properties: [${e}]`)}}class ConfigPlugin{
static _parseAuditsList(e,t){if(void 0!==e){if(!isArrayOfUnknownObjects(e))throw new Error(t+" has an invalid audits array.");return e.map((e=>{const{path:n,...i}=e;if(assertNoExcessProperties(i,t,"audit"),"string"!=typeof n)throw new Error(t+" has a missing audit path.");return{path:n}}))}}static _parseAuditRefsList(e,t){if(!isArrayOfUnknownObjects(e))throw new Error(t+" has no valid auditsRefs.");return e.map((e=>{const{id:n,weight:i,group:a,...s}=e;if(assertNoExcessProperties(s,t,"auditRef"),"string"!=typeof n)throw new Error(t+" has an invalid auditRef id.");if("number"!=typeof i)throw new Error(t+" has an invalid auditRef weight.");if("string"!=typeof a&&void 0!==a)throw new Error(t+" has an invalid auditRef group.");return{id:n,weight:i,group:a?`${t}-${a}`:a}}))}static _parseCategory(e,t){if(!isObjectOfUnknownProperties(e))throw new Error(t+" has no valid category.");const{title:n,description:a,manualDescription:s,auditRefs:l,...c}=e;if(assertNoExcessProperties(c,t,"category"),
!i.isStringOrIcuMessage(n))throw new Error(t+" has an invalid category tile.");if(!i.isStringOrIcuMessage(a)&&void 0!==a)throw new Error(t+" has an invalid category description.");if(!i.isStringOrIcuMessage(s)&&void 0!==s)throw new Error(t+" has an invalid category manualDescription.");return{title:n,auditRefs:ConfigPlugin._parseAuditRefsList(l,t),description:a,manualDescription:s}}static _parseGroups(e,t){if(void 0===e)return;if(!isObjectOfUnknownProperties(e))throw new Error(t+" groups json is not defined as an object.");const n=Object.entries(e),a={};return n.forEach((([e,n])=>{if(!isObjectOfUnknownProperties(n))throw new Error(t+" has a group not defined as an object.");const{title:s,description:l,...c}=n;if(assertNoExcessProperties(c,t,"group"),!i.isStringOrIcuMessage(s))throw new Error(t+" has an invalid group title.");if(!i.isStringOrIcuMessage(l)&&void 0!==l)throw new Error(t+" has an invalid group description.");a[`${t}-${e}`]={title:s,description:l}})),a}
static parsePlugin(e,t){if(!isObjectOfUnknownProperties(e=JSON.parse(JSON.stringify(e))))throw new Error(t+" is not defined as an object.");const{audits:n,category:i,groups:a,...s}=e;return assertNoExcessProperties(s,t),{audits:ConfigPlugin._parseAuditsList(n,t),categories:{[t]:ConfigPlugin._parseCategory(i,t)},groups:ConfigPlugin._parseGroups(a,t)}}}t.exports=ConfigPlugin},{"../lib/i18n/i18n.js":84}],55:[function(e,t,n){(function(n,i){"use strict";const a=e("./default-config.js"),s=e("./constants.js"),l=e("./../lib/i18n/i18n.js"),c=e("lodash.isequal"),u=e("lighthouse-logger"),d=e("path"),m=e("../runner.js"),p=e("./config-plugin.js"),h=e("./budget.js"),{requireAudits:f,resolveModule:g}=e("./config-helpers.js"),y=Object.keys({fetchTime:"",LighthouseRunWarnings:"",HostFormFactor:"",HostUserAgent:"",NetworkUserAgent:"",BenchmarkIndex:"",WebAppManifest:"",InstallabilityErrors:"",Stacks:"",traces:"",devtoolsLogs:"",settings:"",URL:"",Timing:"",PageLoadError:""})
;function assertValidPluginName(e,t){if(!t.startsWith("lighthouse-plugin-"))throw new Error(`plugin name '${t}' does not start with 'lighthouse-plugin-'`);if(e.categories&&e.categories[t])throw new Error(`plugin name '${t}' not allowed because it is the id of a category already found in config`)}const b=function _merge(e,t,n=!1){if(null==e)return t;if(void 0===t)return e;if(Array.isArray(t)){if(n)return t;if(!Array.isArray(e))throw new TypeError("Expected array but got "+typeof e);const i=e.slice();return t.forEach((e=>{i.some((t=>c(t,e)))||i.push(e)})),i}if("object"==typeof t){if("object"!=typeof e)throw new TypeError("Expected object but got "+typeof e);if(Array.isArray(e))throw new TypeError("Expected object but got Array");return Object.keys(t).forEach((i=>{const a=n||"settings"===i&&"object"==typeof e[i];e[i]=_merge(e[i],t[i],a)})),e}return t};function cloneArrayWithPluginSafety(e){return e.map((e=>"object"==typeof e?Object.assign(Object.create(Object.getPrototypeOf(e)),e):e))}
function deepClone(e){return JSON.parse(JSON.stringify(e))}function deepCloneConfigJson(e){const t=deepClone(e);if(Array.isArray(t.passes)&&Array.isArray(e.passes))for(let n=0;n<t.passes.length;n++){t.passes[n].gatherers=cloneArrayWithPluginSafety(e.passes[n].gatherers||[])}return Array.isArray(e.audits)&&(t.audits=cloneArrayWithPluginSafety(e.audits)),t}class Config{constructor(e,t){const n={msg:"Create config",id:"lh:init:config"};u.time(n,"verbose");let s=t&&t.configPath;if(e||(e=a,s=d.resolve(i,"./default-config.js")),s&&!d.isAbsolute(s))throw new Error("configPath must be an absolute path.");if((e=deepCloneConfigJson(e)).extends){if("lighthouse:default"!==e.extends)throw new Error("`lighthouse:default` is the only valid extension method.");e=Config.extendConfigJSON(deepCloneConfigJson(a),e)}const l=s?d.dirname(s):void 0;e=Config.mergePlugins(e,t,l),t&&function assertValidFlags(e){if("devtools"===e.channel&&e.internalDisableDeviceScreenEmulation&&(e.formFactor=e.emulatedFormFactor,
e.emulatedFormFactor=e.internalDisableDeviceScreenEmulation=void 0),e.emulatedFormFactor||e.internalDisableDeviceScreenEmulation)throw new Error("Invalid emulation flag. Emulation configuration changed in LH 7.0. See https://github.com/GoogleChrome/lighthouse/blob/master/docs/emulation.md")}(t);const c=Config.initSettings(e.settings,t),m=Config.augmentPassesWithDefaults(e.passes);Config.adjustDefaultPassForThrottling(c,m);const p=Config.requireGatherers(m,l);this.settings=c,this.passes=p,this.audits=Config.requireAudits(e.audits,l),this.categories=e.categories||null,this.groups=e.groups||null,Config.filterConfigIfNeeded(this),function assertValidSettings(e){if(!e.formFactor)throw new Error("`settings.formFactor` must be defined as 'mobile' or 'desktop'. See https://github.com/GoogleChrome/lighthouse/blob/master/docs/emulation.md")
;if(!e.screenEmulation.disabled&&e.screenEmulation.mobile!==("mobile"===e.formFactor))throw new Error(`Screen emulation mobile setting (${e.screenEmulation.mobile}) does not match formFactor setting (${e.formFactor}). See https://github.com/GoogleChrome/lighthouse/blob/master/docs/emulation.md`)}(this.settings),function assertValidPasses(e,t){if(!Array.isArray(e))return;const n=Config.getGatherersRequestedByAudits(t),i=new Set(y);e.forEach(((e,t)=>{0===t&&"fatal"!==e.loadFailureMode&&(u.warn(`"${e.passName}" is the first pass but was marked as non-fatal. The first pass will always be treated as loadFailureMode=fatal.`),e.loadFailureMode="fatal"),e.gatherers.forEach((e=>{const t=e.instance;if(i.add(t.name),!n.has(t.name)){const e=t.name+" gatherer requested, however no audit requires it.";u.warn("config",e)}}))}));for(const e of t||[]){const t=e.implementation.meta
;for(const e of t.requiredArtifacts)if(!i.has(e))throw new Error(`${e} gatherer, required by audit ${t.id}, was not found in config.`)}const a=new Set;e.forEach((e=>{const t=e.passName;if(a.has(t))throw new Error(`Passes must have unique names (repeated passName: ${t}.`);a.add(t)}))}(this.passes,this.audits),function assertValidCategories(e,t,n){if(!e)return;const i=new Map((t||[]).map((e=>[e.implementation.meta.id,e])));Object.keys(e).forEach((t=>{e[t].auditRefs.forEach(((e,a)=>{if(!e.id)throw new Error(`missing an audit id at ${t}[${a}]`);const s=i.get(e.id);if(!s)throw new Error(`could not find ${e.id} audit for category ${t}`);const l="manual"===s.implementation.meta.scoreDisplayMode;if("accessibility"===t&&!e.group&&!l)throw new Error(e.id+" accessibility audit does not have a group");if(e.weight>0&&l)throw new Error(e.id+" is manual but has a positive weight");if(e.group&&(!n||!n[e.group]))throw new Error(`${e.id} references unknown group ${e.group}`)}))}))
}(this.categories,this.audits,this.groups),u.timeEnd(n)}getPrintString(){const e=deepClone(this);if(e.passes)for(const t of e.passes)for(const e of t.gatherers)e.implementation=void 0,e.instance=void 0;if(e.audits)for(const t of e.audits)t.implementation=void 0,0===Object.keys(t.options).length&&(t.options=void 0);return l.replaceIcuMessages(e,e.settings.locale),JSON.stringify(e,null,2)}static extendConfigJSON(e,t){if(t.passes&&e.passes){for(const n of t.passes){const t=n.passName||s.defaultPassConfig.passName,i=e.passes.find((e=>e.passName===t));i?b(i,n):e.passes.push(n)}delete t.passes}return b(e,t)}static mergePlugins(t,i,a){const s=t.plugins||[],l=i&&i.plugins||[],c=new Set([...s,...l]);for(const i of c){assertValidPluginName(t,i);const s=n.isDevtools||n.isLightrider?i:g(i,a,"plugin"),l=e(s),c=p.parsePlugin(l,i);t=Config.extendConfigJSON(t,c)}return t}static augmentPassesWithDefaults(e){if(!e)return null;const{defaultPassConfig:t}=s;return e.map((e=>b(deepClone(t),e)))}
static initSettings(e={},t){const n=l.lookupLocale(t&&t.locale||e.locale),{defaultSettings:i}=s,a=b(deepClone(i),e,!0),c=b(a||{},function cleanFlagsForSettings(e={}){const t={};for(const n of Object.keys(e))n in s.defaultSettings&&(t[n]=e[n]);return t}(t),!0);return c.budgets&&(c.budgets=h.initializeBudget(c.budgets)),c.locale=n,!0===c.emulatedUserAgent&&(c.emulatedUserAgent=s.userAgents[c.formFactor]),c}static expandGathererShorthand(e){return e.map((e=>{if("string"==typeof e)return{path:e,options:{}};if("implementation"in e||"instance"in e)return e;if("path"in e){if("string"!=typeof e.path)throw new Error("Invalid Gatherer type "+JSON.stringify(e));return e}if("function"==typeof e)return{implementation:e,options:{}};if(e&&"function"==typeof e.beforePass)return{instance:e,options:{}};throw new Error("Invalid Gatherer type "+JSON.stringify(e))}))}static adjustDefaultPassForThrottling(e,t){if(!t||"devtools"!==e.throttlingMethod&&"provided"!==e.throttlingMethod)return
;const n=t.find((e=>"defaultPass"===e.passName));if(!n)return;const i=s.nonSimulatedPassConfigOverrides;n.pauseAfterFcpMs=Math.max(i.pauseAfterFcpMs,n.pauseAfterFcpMs),n.pauseAfterLoadMs=Math.max(i.pauseAfterLoadMs,n.pauseAfterLoadMs),n.cpuQuietThresholdMs=Math.max(i.cpuQuietThresholdMs,n.cpuQuietThresholdMs),n.networkQuietThresholdMs=Math.max(i.networkQuietThresholdMs,n.networkQuietThresholdMs)}static filterConfigIfNeeded(e){const t=e.settings;if(!t.onlyCategories&&!t.onlyAudits&&!t.skipAudits)return;const{categories:n,requestedAuditNames:i}=Config.filterCategoriesAndAudits(e.categories,t),a=e.audits&&e.audits.filter((e=>i.has(e.implementation.meta.id))),s=Config.getGatherersRequestedByAudits(a),l=Config.generatePassesNeededByGatherers(e.passes,s);e.categories=n,e.audits=a,e.passes=l}static filterCategoriesAndAudits(e,t){if(!e)return{categories:null,requestedAuditNames:new Set};if(t.onlyAudits&&t.skipAudits)throw new Error("Cannot set both skipAudits and onlyAudits")
;const n={},i=!!t.onlyCategories,a=!!t.onlyAudits,s=t.onlyCategories||[],l=t.onlyAudits||[],c=t.skipAudits||[];s.forEach((t=>{e[t]||u.warn("config","unrecognized category in 'onlyCategories': "+t)}));const d=new Set(l.concat(c));for(const t of d){const n=Object.keys(e).find((n=>!!e[n].auditRefs.find((e=>e.id===t))));if(n)l.includes(t)&&s.includes(n)&&u.warn("config",t+" in 'onlyAudits' is already included by "+n+" in 'onlyCategories'");else{const e=c.includes(t)?"skipAudits":"onlyAudits";u.warn("config",`unrecognized audit in '${e}': ${t}`)}}const m=new Set(l);if(c.forEach((e=>m.delete(e))),Object.keys(e).forEach((t=>{const u=deepClone(e[t]);if(i&&a)s.includes(t)||(u.auditRefs=u.auditRefs.filter((e=>l.includes(e.id))));else if(i){if(!s.includes(t))return}else a&&(u.auditRefs=u.auditRefs.filter((e=>l.includes(e.id))));u.auditRefs=u.auditRefs.filter((e=>!c.includes(e.id))),u.auditRefs.length&&(n[t]=u,u.auditRefs.forEach((e=>m.add(e.id))))})),t.onlyCategories){
t.skipAudits&&t.skipAudits.includes("full-page-screenshot")||m.add("full-page-screenshot")}return{categories:n,requestedAuditNames:m}}static getGatherersRequestedByAudits(e){if(!e)return new Set;const t=new Set;for(const n of e){const{requiredArtifacts:e,__internalOptionalArtifacts:i}=n.implementation.meta;e.forEach((e=>t.add(e))),i&&i.forEach((e=>t.add(e)))}return t}static generatePassesNeededByGatherers(e,t){if(!e)return null;const n=t.has("traces");return e.map((e=>{if(e.gatherers=e.gatherers.filter((e=>{const n=e.instance;return t.has(n.name)})),e.recordTrace&&!n){const t=e.passName||"unknown pass";u.warn("config","Trace not requested by an audit, dropping trace in "+t),e.recordTrace=!1}return e})).filter((e=>!!e.recordTrace||("defaultPass"===e.passName||e.gatherers.length>0)))}static requireAudits(e,t){const n={msg:"Requiring audits",id:"lh:config:requireAudits"};u.time(n,"verbose");const i=f(e,t);return u.timeEnd(n),i}static requireGathererFromPath(t,n,i){
const a=n.find((e=>e===t+".js"));let s="../gather/gatherers/"+t;a||(s=g(t,i,"gatherer"));const l=e(s);return{instance:new l,implementation:l,path:t}}static requireGatherers(e,t){if(!e)return null;const n={msg:"Requiring gatherers",id:"lh:config:requireGatherers"};u.time(n,"verbose");const i=m.getGathererList(),a=e.map((e=>{const n=Config.expandGathererShorthand(e.gatherers).map((e=>{if(e.instance)return{instance:e.instance,implementation:e.implementation,path:e.path};if(e.implementation){return{instance:new(0,e.implementation),implementation:e.implementation,path:e.path}}if(e.path){const n=e.path;return Config.requireGathererFromPath(n,i,t)}throw new Error("Invalid expanded Gatherer: "+JSON.stringify(e))})),a=Array.from(new Map(n.map((e=>[e.instance.name,e]))).values());return a.forEach((e=>function assertValidGatherer(e,t){if(t=t||e.name||"gatherer","function"!=typeof e.beforePass)throw new Error(t+" has no beforePass() method.")
;if("function"!=typeof e.pass)throw new Error(t+" has no pass() method.");if("function"!=typeof e.afterPass)throw new Error(t+" has no afterPass() method.")}(e.instance,e.path))),Object.assign(e,{gatherers:a})}));return u.timeEnd(n),a}}t.exports=Config}).call(this,"undefined"!=typeof global?global:"undefined"!=typeof self?self:"undefined"!=typeof window?window:{},"/lighthouse-core/config")},{"../runner.js":113,"./../lib/i18n/i18n.js":84,"./budget.js":52,"./config-helpers.js":53,"./config-plugin.js":54,"./constants.js":56,"./default-config.js":57,"lighthouse-logger":115,"lodash.isequal":176,path:188}],56:[function(e,t,n){"use strict";const i=3.75,a=.9,s={DEVTOOLS_RTT_ADJUSTMENT_FACTOR:i,DEVTOOLS_THROUGHPUT_ADJUSTMENT_FACTOR:a,mobileSlow4G:{rttMs:150,throughputKbps:1638.4,requestLatencyMs:562.5,downloadThroughputKbps:1474.5600000000002,uploadThroughputKbps:675,cpuSlowdownMultiplier:4},mobileRegular3G:{rttMs:300,throughputKbps:700,requestLatencyMs:1125,downloadThroughputKbps:630,
uploadThroughputKbps:630,cpuSlowdownMultiplier:4},desktopDense4G:{rttMs:40,throughputKbps:10240,cpuSlowdownMultiplier:1,requestLatencyMs:0,downloadThroughputKbps:0,uploadThroughputKbps:0}},l={mobile:{mobile:!0,width:360,height:640,deviceScaleFactor:2.625,disabled:!1},desktop:{mobile:!1,width:1350,height:940,deviceScaleFactor:1,disabled:!1}},c={mobile:"Mozilla/5.0 (Linux; Android 7.0; Moto G (4)) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4143.7 Mobile Safari/537.36 Chrome-Lighthouse",desktop:"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4143.7 Safari/537.36 Chrome-Lighthouse"},u={output:"json",maxWaitForFcp:3e4,maxWaitForLoad:45e3,formFactor:"mobile",throttling:s.mobileSlow4G,throttlingMethod:"simulate",screenEmulation:l.mobile,emulatedUserAgent:c.mobile,auditMode:!1,gatherMode:!1,disableStorageReset:!1,channel:"node",budgets:null,locale:"en-US",blockedUrlPatterns:null,additionalTraceCategories:null,extraHeaders:null,
precomputedLanternData:null,onlyAudits:null,onlyCategories:null,skipAudits:null};t.exports={throttling:s,screenEmulationMetrics:l,userAgents:c,defaultSettings:u,defaultPassConfig:{passName:"defaultPass",loadFailureMode:"fatal",recordTrace:!1,useThrottling:!1,pauseAfterFcpMs:0,pauseAfterLoadMs:0,networkQuietThresholdMs:0,cpuQuietThresholdMs:0,blockedUrlPatterns:[],blankPage:"about:blank",gatherers:[]},nonSimulatedPassConfigOverrides:{pauseAfterFcpMs:5250,pauseAfterLoadMs:5250,networkQuietThresholdMs:5250,cpuQuietThresholdMs:5250}}},{}],57:[function(e,t,n){(function(n){"use strict";const i=e("./constants.js"),a=e("../lib/i18n/i18n.js"),s={performanceCategoryTitle:"Performance",budgetsGroupTitle:"Budgets",budgetsGroupDescription:"Performance budgets set standards for the performance of your site.",metricGroupTitle:"Metrics",loadOpportunitiesGroupTitle:"Opportunities",
loadOpportunitiesGroupDescription:"These suggestions can help your page load faster. They don't [directly affect](https://web.dev/performance-scoring/) the Performance score.",firstPaintImprovementsGroupTitle:"First Paint Improvements",firstPaintImprovementsGroupDescription:"The most critical aspect of performance is how quickly pixels are rendered onscreen. Key metrics: First Contentful Paint, First Meaningful Paint",overallImprovementsGroupTitle:"Overall Improvements",overallImprovementsGroupDescription:"Enhance the overall loading experience, so the page is responsive and ready to use as soon as possible. Key metrics: Time to Interactive, Speed Index",diagnosticsGroupTitle:"Diagnostics",diagnosticsGroupDescription:"More information about the performance of your application. These numbers don't [directly affect](https://web.dev/performance-scoring/) the Performance score.",a11yCategoryTitle:"Accessibility",
a11yCategoryDescription:"These checks highlight opportunities to [improve the accessibility of your web app](https://developers.google.com/web/fundamentals/accessibility). Only a subset of accessibility issues can be automatically detected so manual testing is also encouraged.",a11yCategoryManualDescription:"These items address areas which an automated testing tool cannot cover. Learn more in our guide on [conducting an accessibility review](https://developers.google.com/web/fundamentals/accessibility/how-to-review).",a11yBestPracticesGroupTitle:"Best practices",a11yBestPracticesGroupDescription:"These items highlight common accessibility best practices.",a11yColorContrastGroupTitle:"Contrast",a11yColorContrastGroupDescription:"These are opportunities to improve the legibility of your content.",a11yNamesLabelsGroupTitle:"Names and labels",
a11yNamesLabelsGroupDescription:"These are opportunities to improve the semantics of the controls in your application. This may enhance the experience for users of assistive technology, like a screen reader.",a11yNavigationGroupTitle:"Navigation",a11yNavigationGroupDescription:"These are opportunities to improve keyboard navigation in your application.",a11yAriaGroupTitle:"ARIA",a11yAriaGroupDescription:"These are opportunities to improve the usage of ARIA in your application which may enhance the experience for users of assistive technology, like a screen reader.",a11yLanguageGroupTitle:"Internationalization and localization",a11yLanguageGroupDescription:"These are opportunities to improve the interpretation of your content by users in different locales.",a11yAudioVideoGroupTitle:"Audio and video",a11yAudioVideoGroupDescription:"These are opportunities to provide alternative content for audio and video. This may improve the experience for users with hearing or vision impairments.",
a11yTablesListsVideoGroupTitle:"Tables and lists",a11yTablesListsVideoGroupDescription:"These are opportunities to improve the experience of reading tabular or list data using assistive technology, like a screen reader.",seoCategoryTitle:"SEO",seoCategoryDescription:"These checks ensure that your page is optimized for search engine results ranking. There are additional factors Lighthouse does not check that may affect your search ranking. [Learn more](https://support.google.com/webmasters/answer/35769).",seoCategoryManualDescription:"Run these additional validators on your site to check additional SEO best practices.",seoMobileGroupTitle:"Mobile Friendly",seoMobileGroupDescription:"Make sure your pages are mobile friendly so users don’t have to pinch or zoom in order to read the content pages. [Learn more](https://developers.google.com/search/mobile-sites/).",seoContentGroupTitle:"Content Best Practices",
seoContentGroupDescription:"Format your HTML in a way that enables crawlers to better understand your app’s content.",seoCrawlingGroupTitle:"Crawling and Indexing",seoCrawlingGroupDescription:"To appear in search results, crawlers need access to your app.",pwaCategoryTitle:"Progressive Web App",pwaCategoryDescription:"These checks validate the aspects of a Progressive Web App. [Learn more](https://developers.google.com/web/progressive-web-apps/checklist).",pwaCategoryManualDescription:"These checks are required by the baseline [PWA Checklist](https://developers.google.com/web/progressive-web-apps/checklist) but are not automatically checked by Lighthouse. They do not affect your score but it's important that you verify them manually.",bestPracticesCategoryTitle:"Best Practices",bestPracticesTrustSafetyGroupTitle:"Trust and Safety",bestPracticesUXGroupTitle:"User Experience",bestPracticesBrowserCompatGroupTitle:"Browser Compatibility",bestPracticesGeneralGroupTitle:"General",
pwaInstallableGroupTitle:"Installable",pwaOptimizedGroupTitle:"PWA Optimized"},l=a.createMessageInstanceIdFn(n,s),c={settings:i.defaultSettings,passes:[{passName:"defaultPass",recordTrace:!0,useThrottling:!0,pauseAfterFcpMs:1e3,pauseAfterLoadMs:1e3,networkQuietThresholdMs:1e3,cpuQuietThresholdMs:1e3,gatherers:["css-usage","js-usage","viewport-dimensions","console-messages","anchor-elements","image-elements","link-elements","meta-elements","script-elements","iframe-elements","form-elements","main-document-content","global-listeners","dobetterweb/appcache","dobetterweb/doctype","dobetterweb/domstats","dobetterweb/optimized-images","dobetterweb/password-inputs-with-prevented-paste","dobetterweb/response-compression","dobetterweb/tags-blocking-first-paint","seo/font-size","seo/embedded-content","seo/robots-txt","seo/tap-targets","accessibility","trace-elements","inspector-issues","source-maps","full-page-screenshot"]},{passName:"offlinePass",loadFailureMode:"ignore",
gatherers:["service-worker"]},{passName:"redirectPass",loadFailureMode:"warn",blockedUrlPatterns:["*.css","*.jpg","*.jpeg","*.png","*.gif","*.svg","*.ttf","*.woff","*.woff2"],gatherers:["http-redirect"]}],
audits:["is-on-https","redirects-http","service-worker","viewport","metrics/first-contentful-paint","metrics/largest-contentful-paint","metrics/first-meaningful-paint","metrics/speed-index","screenshot-thumbnails","final-screenshot","metrics/estimated-input-latency","metrics/total-blocking-time","metrics/max-potential-fid","metrics/cumulative-layout-shift","errors-in-console","server-response-time","metrics/first-cpu-idle","metrics/interactive","user-timings","critical-request-chains","redirects","installable-manifest","apple-touch-icon","splash-screen","themed-omnibox","maskable-icon","content-width","image-aspect-ratio","image-size-responsive","preload-fonts","deprecations","mainthread-work-breakdown","bootup-time","uses-rel-preload","uses-rel-preconnect","font-display","diagnostics","network-requests","network-rtt","network-server-latency","main-thread-tasks","metrics","performance-budget","timing-budget","resource-summary","third-party-summary","third-party-facades","largest-contentful-paint-element","layout-shift-elements","long-tasks","no-unload-listeners","non-composited-animations","unsized-images","valid-source-maps","preload-lcp-image","full-page-screenshot","manual/pwa-cross-browser","manual/pwa-page-transitions","manual/pwa-each-page-has-url","accessibility/accesskeys","accessibility/aria-allowed-attr","accessibility/aria-command-name","accessibility/aria-hidden-body","accessibility/aria-hidden-focus","accessibility/aria-input-field-name","accessibility/aria-meter-name","accessibility/aria-progressbar-name","accessibility/aria-required-attr","accessibility/aria-required-children","accessibility/aria-required-parent","accessibility/aria-roles","accessibility/aria-toggle-field-name","accessibility/aria-tooltip-name","accessibility/aria-treeitem-name","accessibility/aria-valid-attr-value","accessibility/aria-valid-attr","accessibility/button-name","accessibility/bypass","accessibility/color-contrast","accessibility/definition-list","accessibility/dlitem","accessibility/document-title","accessibility/duplicate-id-active","accessibility/duplicate-id-aria","accessibility/form-field-multiple-labels","accessibility/frame-title","accessibility/heading-order","accessibility/html-has-lang","accessibility/html-lang-valid","accessibility/image-alt","accessibility/input-image-alt","accessibility/label","accessibility/link-name","accessibility/list","accessibility/listitem","accessibility/meta-refresh","accessibility/meta-viewport","accessibility/object-alt","accessibility/tabindex","accessibility/td-headers-attr","accessibility/th-has-data-cells","accessibility/valid-lang","accessibility/video-caption","accessibility/manual/custom-controls-labels","accessibility/manual/custom-controls-roles","accessibility/manual/focus-traps","accessibility/manual/focusable-controls","accessibility/manual/interactive-element-affordance","accessibility/manual/logical-tab-order","accessibility/manual/managed-focus","accessibility/manual/offscreen-content-hidden","accessibility/manual/use-landmarks","accessibility/manual/visual-order-follows-dom","byte-efficiency/uses-long-cache-ttl","byte-efficiency/total-byte-weight","byte-efficiency/offscreen-images","byte-efficiency/render-blocking-resources","byte-efficiency/unminified-css","byte-efficiency/unminified-javascript","byte-efficiency/unused-css-rules","byte-efficiency/unused-javascript","byte-efficiency/uses-webp-images","byte-efficiency/uses-optimized-images","byte-efficiency/uses-text-compression","byte-efficiency/uses-responsive-images","byte-efficiency/efficient-animated-content","byte-efficiency/duplicated-javascript","byte-efficiency/legacy-javascript","dobetterweb/appcache-manifest","dobetterweb/doctype","dobetterweb/charset","dobetterweb/dom-size","dobetterweb/external-anchors-use-rel-noopener","dobetterweb/geolocation-on-start","dobetterweb/inspector-issues","dobetterweb/no-document-write","dobetterweb/no-vulnerable-libraries","dobetterweb/js-libraries","dobetterweb/notification-on-start","dobetterweb/password-inputs-can-be-pasted-into","dobetterweb/uses-http2","dobetterweb/uses-passive-event-listeners","seo/meta-description","seo/http-status-code","seo/font-size","seo/link-text","seo/crawlable-anchors","seo/is-crawlable","seo/robots-txt","seo/tap-targets","seo/hreflang","seo/plugins","seo/canonical","seo/manual/structured-data"],
groups:{metrics:{title:l(s.metricGroupTitle)},"load-opportunities":{title:l(s.loadOpportunitiesGroupTitle),description:l(s.loadOpportunitiesGroupDescription)},budgets:{title:l(s.budgetsGroupTitle),description:l(s.budgetsGroupDescription)},diagnostics:{title:l(s.diagnosticsGroupTitle),description:l(s.diagnosticsGroupDescription)},"pwa-installable":{title:l(s.pwaInstallableGroupTitle)},"pwa-optimized":{title:l(s.pwaOptimizedGroupTitle)},"a11y-best-practices":{title:l(s.a11yBestPracticesGroupTitle),description:l(s.a11yBestPracticesGroupDescription)},"a11y-color-contrast":{title:l(s.a11yColorContrastGroupTitle),description:l(s.a11yColorContrastGroupDescription)},"a11y-names-labels":{title:l(s.a11yNamesLabelsGroupTitle),description:l(s.a11yNamesLabelsGroupDescription)},"a11y-navigation":{title:l(s.a11yNavigationGroupTitle),description:l(s.a11yNavigationGroupDescription)},"a11y-aria":{title:l(s.a11yAriaGroupTitle),description:l(s.a11yAriaGroupDescription)},"a11y-language":{
title:l(s.a11yLanguageGroupTitle),description:l(s.a11yLanguageGroupDescription)},"a11y-audio-video":{title:l(s.a11yAudioVideoGroupTitle),description:l(s.a11yAudioVideoGroupDescription)},"a11y-tables-lists":{title:l(s.a11yTablesListsVideoGroupTitle),description:l(s.a11yTablesListsVideoGroupDescription)},"seo-mobile":{title:l(s.seoMobileGroupTitle),description:l(s.seoMobileGroupDescription)},"seo-content":{title:l(s.seoContentGroupTitle),description:l(s.seoContentGroupDescription)},"seo-crawl":{title:l(s.seoCrawlingGroupTitle),description:l(s.seoCrawlingGroupDescription)},"best-practices-trust-safety":{title:l(s.bestPracticesTrustSafetyGroupTitle)},"best-practices-ux":{title:l(s.bestPracticesUXGroupTitle)},"best-practices-browser-compat":{title:l(s.bestPracticesBrowserCompatGroupTitle)},"best-practices-general":{title:l(s.bestPracticesGeneralGroupTitle)}},categories:{performance:{title:l(s.performanceCategoryTitle),auditRefs:[{id:"first-contentful-paint",weight:15,group:"metrics"},{
id:"speed-index",weight:15,group:"metrics"},{id:"largest-contentful-paint",weight:25,group:"metrics"},{id:"interactive",weight:15,group:"metrics"},{id:"total-blocking-time",weight:25,group:"metrics"},{id:"cumulative-layout-shift",weight:5,group:"metrics"},{id:"first-cpu-idle",weight:0},{id:"max-potential-fid",weight:0},{id:"first-meaningful-paint",weight:0},{id:"estimated-input-latency",weight:0},{id:"render-blocking-resources",weight:0,group:"load-opportunities"},{id:"uses-responsive-images",weight:0,group:"load-opportunities"},{id:"offscreen-images",weight:0,group:"load-opportunities"},{id:"unminified-css",weight:0,group:"load-opportunities"},{id:"unminified-javascript",weight:0,group:"load-opportunities"},{id:"unused-css-rules",weight:0,group:"load-opportunities"},{id:"unused-javascript",weight:0,group:"load-opportunities"},{id:"uses-optimized-images",weight:0,group:"load-opportunities"},{id:"uses-webp-images",weight:0,group:"load-opportunities"},{id:"uses-text-compression",
weight:0,group:"load-opportunities"},{id:"uses-rel-preconnect",weight:0,group:"load-opportunities"},{id:"server-response-time",weight:0,group:"load-opportunities"},{id:"redirects",weight:0,group:"load-opportunities"},{id:"uses-rel-preload",weight:0,group:"load-opportunities"},{id:"uses-http2",weight:0,group:"load-opportunities"},{id:"efficient-animated-content",weight:0,group:"load-opportunities"},{id:"duplicated-javascript",weight:0,group:"load-opportunities"},{id:"legacy-javascript",weight:0,group:"load-opportunities"},{id:"preload-lcp-image",weight:0,group:"load-opportunities"},{id:"total-byte-weight",weight:0,group:"diagnostics"},{id:"uses-long-cache-ttl",weight:0,group:"diagnostics"},{id:"dom-size",weight:0,group:"diagnostics"},{id:"critical-request-chains",weight:0,group:"diagnostics"},{id:"user-timings",weight:0,group:"diagnostics"},{id:"bootup-time",weight:0,group:"diagnostics"},{id:"mainthread-work-breakdown",weight:0,group:"diagnostics"},{id:"font-display",weight:0,
group:"diagnostics"},{id:"performance-budget",weight:0,group:"budgets"},{id:"timing-budget",weight:0,group:"budgets"},{id:"resource-summary",weight:0,group:"diagnostics"},{id:"third-party-summary",weight:0,group:"diagnostics"},{id:"third-party-facades",weight:0,group:"diagnostics"},{id:"largest-contentful-paint-element",weight:0,group:"diagnostics"},{id:"layout-shift-elements",weight:0,group:"diagnostics"},{id:"uses-passive-event-listeners",weight:0,group:"diagnostics"},{id:"no-document-write",weight:0,group:"diagnostics"},{id:"long-tasks",weight:0,group:"diagnostics"},{id:"non-composited-animations",weight:0,group:"diagnostics"},{id:"unsized-images",weight:0,group:"diagnostics"},{id:"network-requests",weight:0},{id:"network-rtt",weight:0},{id:"network-server-latency",weight:0},{id:"main-thread-tasks",weight:0},{id:"diagnostics",weight:0},{id:"metrics",weight:0},{id:"screenshot-thumbnails",weight:0},{id:"final-screenshot",weight:0}]},accessibility:{title:l(s.a11yCategoryTitle),
description:l(s.a11yCategoryDescription),manualDescription:l(s.a11yCategoryManualDescription),auditRefs:[{id:"accesskeys",weight:3,group:"a11y-navigation"},{id:"aria-allowed-attr",weight:10,group:"a11y-aria"},{id:"aria-command-name",weight:3,group:"a11y-aria"},{id:"aria-hidden-body",weight:10,group:"a11y-aria"},{id:"aria-hidden-focus",weight:3,group:"a11y-aria"},{id:"aria-input-field-name",weight:3,group:"a11y-aria"},{id:"aria-meter-name",weight:3,group:"a11y-aria"},{id:"aria-progressbar-name",weight:3,group:"a11y-aria"},{id:"aria-required-attr",weight:10,group:"a11y-aria"},{id:"aria-required-children",weight:10,group:"a11y-aria"},{id:"aria-required-parent",weight:10,group:"a11y-aria"},{id:"aria-roles",weight:10,group:"a11y-aria"},{id:"aria-toggle-field-name",weight:3,group:"a11y-aria"},{id:"aria-tooltip-name",weight:3,group:"a11y-aria"},{id:"aria-treeitem-name",weight:3,group:"a11y-aria"},{id:"aria-valid-attr-value",weight:10,group:"a11y-aria"},{id:"aria-valid-attr",weight:10,
group:"a11y-aria"},{id:"button-name",weight:10,group:"a11y-names-labels"},{id:"bypass",weight:3,group:"a11y-navigation"},{id:"color-contrast",weight:3,group:"a11y-color-contrast"},{id:"definition-list",weight:3,group:"a11y-tables-lists"},{id:"dlitem",weight:3,group:"a11y-tables-lists"},{id:"document-title",weight:3,group:"a11y-names-labels"},{id:"duplicate-id-active",weight:3,group:"a11y-navigation"},{id:"duplicate-id-aria",weight:10,group:"a11y-aria"},{id:"form-field-multiple-labels",weight:2,group:"a11y-names-labels"},{id:"frame-title",weight:3,group:"a11y-names-labels"},{id:"heading-order",weight:2,group:"a11y-navigation"},{id:"html-has-lang",weight:3,group:"a11y-language"},{id:"html-lang-valid",weight:3,group:"a11y-language"},{id:"image-alt",weight:10,group:"a11y-names-labels"},{id:"input-image-alt",weight:10,group:"a11y-names-labels"},{id:"label",weight:10,group:"a11y-names-labels"},{id:"link-name",weight:3,group:"a11y-names-labels"},{id:"list",weight:3,group:"a11y-tables-lists"
},{id:"listitem",weight:3,group:"a11y-tables-lists"},{id:"meta-refresh",weight:10,group:"a11y-best-practices"},{id:"meta-viewport",weight:10,group:"a11y-best-practices"},{id:"object-alt",weight:3,group:"a11y-names-labels"},{id:"tabindex",weight:3,group:"a11y-navigation"},{id:"td-headers-attr",weight:3,group:"a11y-tables-lists"},{id:"th-has-data-cells",weight:3,group:"a11y-tables-lists"},{id:"valid-lang",weight:3,group:"a11y-language"},{id:"video-caption",weight:10,group:"a11y-audio-video"},{id:"logical-tab-order",weight:0},{id:"focusable-controls",weight:0},{id:"interactive-element-affordance",weight:0},{id:"managed-focus",weight:0},{id:"focus-traps",weight:0},{id:"custom-controls-labels",weight:0},{id:"custom-controls-roles",weight:0},{id:"visual-order-follows-dom",weight:0},{id:"offscreen-content-hidden",weight:0},{id:"use-landmarks",weight:0}]},"best-practices":{title:l(s.bestPracticesCategoryTitle),auditRefs:[{id:"is-on-https",weight:1,group:"best-practices-trust-safety"},{
id:"external-anchors-use-rel-noopener",weight:1,group:"best-practices-trust-safety"},{id:"geolocation-on-start",weight:1,group:"best-practices-trust-safety"},{id:"notification-on-start",weight:1,group:"best-practices-trust-safety"},{id:"no-vulnerable-libraries",weight:1,group:"best-practices-trust-safety"},{id:"password-inputs-can-be-pasted-into",weight:1,group:"best-practices-ux"},{id:"image-aspect-ratio",weight:1,group:"best-practices-ux"},{id:"image-size-responsive",weight:1,group:"best-practices-ux"},{id:"preload-fonts",weight:1,group:"best-practices-ux"},{id:"doctype",weight:1,group:"best-practices-browser-compat"},{id:"charset",weight:1,group:"best-practices-browser-compat"},{id:"no-unload-listeners",weight:1,group:"best-practices-general"},{id:"appcache-manifest",weight:1,group:"best-practices-general"},{id:"js-libraries",weight:0,group:"best-practices-general"},{id:"deprecations",weight:1,group:"best-practices-general"},{id:"errors-in-console",weight:1,
group:"best-practices-general"},{id:"valid-source-maps",weight:0,group:"best-practices-general"},{id:"inspector-issues",weight:1,group:"best-practices-general"}]},seo:{title:l(s.seoCategoryTitle),description:l(s.seoCategoryDescription),manualDescription:l(s.seoCategoryManualDescription),auditRefs:[{id:"viewport",weight:1,group:"seo-mobile"},{id:"document-title",weight:1,group:"seo-content"},{id:"meta-description",weight:1,group:"seo-content"},{id:"http-status-code",weight:1,group:"seo-crawl"},{id:"link-text",weight:1,group:"seo-content"},{id:"crawlable-anchors",weight:1,group:"seo-crawl"},{id:"is-crawlable",weight:1,group:"seo-crawl"},{id:"robots-txt",weight:1,group:"seo-crawl"},{id:"image-alt",weight:1,group:"seo-content"},{id:"hreflang",weight:1,group:"seo-content"},{id:"canonical",weight:1,group:"seo-content"},{id:"font-size",weight:1,group:"seo-mobile"},{id:"plugins",weight:1,group:"seo-content"},{id:"tap-targets",weight:1,group:"seo-mobile"},{id:"structured-data",weight:0}]},pwa:{
title:l(s.pwaCategoryTitle),description:l(s.pwaCategoryDescription),manualDescription:l(s.pwaCategoryManualDescription),auditRefs:[{id:"installable-manifest",weight:2,group:"pwa-installable"},{id:"service-worker",weight:1,group:"pwa-optimized"},{id:"redirects-http",weight:2,group:"pwa-optimized"},{id:"splash-screen",weight:1,group:"pwa-optimized"},{id:"themed-omnibox",weight:1,group:"pwa-optimized"},{id:"content-width",weight:1,group:"pwa-optimized"},{id:"viewport",weight:2,group:"pwa-optimized"},{id:"apple-touch-icon",weight:1,group:"pwa-optimized"},{id:"maskable-icon",weight:1,group:"pwa-optimized"},{id:"pwa-cross-browser",weight:0},{id:"pwa-page-transitions",weight:0},{id:"pwa-each-page-has-url",weight:0}]}}};t.exports=c,Object.defineProperty(t.exports,"UIStrings",{enumerable:!1,get:()=>s})}).call(this,"/lighthouse-core/config/default-config.js")},{"../lib/i18n/i18n.js":84,"./constants.js":56}],58:[function(e,t,n){"use strict"
;const i=e("events").EventEmitter,a=e("lighthouse-logger"),s=e("../../lib/lh-error.js");t.exports=class Connection{constructor(){this._lastCommandId=0,this._callbacks=new Map,this._eventEmitter=new i}connect(){return Promise.reject(new Error("Not implemented"))}disconnect(){return Promise.reject(new Error("Not implemented"))}wsEndpoint(){return Promise.reject(new Error("Not implemented"))}sendCommand(e,t,...n){const i=n.length?n[0]:void 0;a.formatProtocol("method => browser",{method:e,params:i},"verbose");const s=++this._lastCommandId,l=JSON.stringify({id:s,sessionId:t,method:e,params:i});return this.sendRawMessage(l),new Promise((t=>{this._callbacks.set(s,{method:e,resolve:t})}))}on(e,t){if("protocolevent"!==e)throw new Error('Only supports "protocolevent" events');if(!this._eventEmitter)throw new Error("Attempted to add event listener after connection disposed.");this._eventEmitter.on(e,t)}sendRawMessage(e){throw new Error("Not implemented")}handleRawMessage(e){const t=JSON.parse(e)
;if(!("id"in t))return a.formatProtocol("<= event",{method:t.method,params:t.params},"verbose"),void this.emitProtocolEvent(t);const n=this._callbacks.get(t.id);if(n)this._callbacks.delete(t.id),n.resolve(Promise.resolve().then((e=>{if(t.error)throw a.formatProtocol("method <= browser ERR",{method:n.method},"error"),s.fromProtocolMessage(n.method,t.error);return a.formatProtocol("method <= browser OK",{method:n.method,params:t.result},"verbose"),t.result})));else{const e=t.error&&t.error.message;a.formatProtocol("disowned method <= browser "+(e?"ERR":"OK"),{method:"UNKNOWN",params:e||t.result},"verbose")}}emitProtocolEvent(e){if(!this._eventEmitter)throw new Error("Attempted to emit event after connection disposed.");this._eventEmitter.emit("protocolevent",e)}dispose(){this._eventEmitter&&(this._eventEmitter.removeAllListeners(),this._eventEmitter=null)}}},{"../../lib/lh-error.js":92,events:134,"lighthouse-logger":115}],59:[function(e,t,n){"use strict";const i=e("./connection.js")
;t.exports=class RawConnection extends i{constructor(e){super(),this._port=e,this._port.on("message",this.handleRawMessage.bind(this)),this._port.on("close",this.dispose.bind(this))}connect(){return Promise.resolve()}disconnect(){return this._port.close(),Promise.resolve()}sendRawMessage(e){this._port.send(e)}}},{"./connection.js":58}],60:[function(e,t,n){"use strict";t.exports=class DevtoolsLog{constructor(e){this._filter=e,this._messages=[],this._isRecording=!1}get messages(){return this._messages}reset(){this._messages=[]}beginRecording(){this._isRecording=!0}endRecording(){this._isRecording=!1}record(e){!this._isRecording||this._filter&&!this._filter.test(e.method)||this._messages.push(e)}}},{}],61:[function(e,t,n){(function(n,i){"use strict"
;const a=e("./fetcher.js"),s=e("./driver/execution-context.js"),{waitForFullyLoaded:l,waitForFrameNavigated:c}=e("./driver/wait-for-condition.js"),u=e("../lib/network-recorder.js"),d=e("../lib/emulation.js"),m=e("../lib/lh-element.js"),p=e("../lib/lh-error.js"),h=e("../lib/network-request.js"),f=e("events").EventEmitter,g=e("../lib/i18n/i18n.js"),y=e("../lib/url-shim.js"),b=e("../config/constants.js"),v=e("lighthouse-logger"),w=e("./devtools-log.js"),T=e("../lib/page-functions.js"),S=(e("./connections/connection.js"),{warningData:"{locationCount, plural,\n    =1 {There may be stored data affecting loading performance in this location: {locations}. Audit this page in an incognito window to prevent those resources from affecting your scores.}\n    other {There may be stored data affecting loading performance in these locations: {locations}. Audit this page in an incognito window to prevent those resources from affecting your scores.}\n  }"}),E=g.createMessageInstanceIdFn(i,S),x=3e4
;class Driver{_traceCategories=Driver.traceCategories;_eventEmitter=new f;_devtoolsLog=new w(/^(Page|Network)\./);_domainEnabledCounts=new Map;_networkStatusMonitor=null;_monitoredUrl=null;_monitoredUrlNavigations=[];_nextProtocolTimeout=x;online=!0;fetcher=new a(this);_executionContext=new s(this);defaultSession=this;constructor(e){this._connection=e,this.on("Target.attachedToTarget",(e=>{this._handleTargetAttached(e).catch(this._handleEventError)})),this.on("Page.frameNavigated",(e=>this._monitoredUrlNavigations.push(e.frame))),this.on("Debugger.paused",(()=>this.sendCommand("Debugger.resume"))),e.on("protocolevent",this._handleProtocolEvent.bind(this))}static get traceCategories(){return["-*","disabled-by-default-lighthouse","loading","v8","v8.execute","blink.user_timing","blink.console","devtools.timeline","disabled-by-default-devtools.timeline","disabled-by-default-devtools.screenshot","disabled-by-default-devtools.timeline.stack"]}async getBrowserVersion(){const e={
msg:"Getting browser version",id:"lh:gather:getVersion"};v.time(e,"verbose");const t=await this.sendCommand("Browser.getVersion"),n=t.product.match(/\/(\d+)/),i=n?parseInt(n[1]):0;return v.timeEnd(e),Object.assign(t,{milestone:i})}async getBenchmarkIndex(){const e={msg:"Benchmarking machine",id:"lh:gather:getBenchmarkIndex"};v.time(e);const t=await this.evaluateAsync(`(${T.computeBenchmarkIndexString})()`);return v.timeEnd(e),t}async connect(){const e={msg:"Connecting to browser",id:"lh:init:connect"};v.time(e),await this._connection.connect(),v.timeEnd(e)}disconnect(){return this._connection.disconnect()}wsEndpoint(){return this._connection.wsEndpoint()}on(e,t){if(null===this._eventEmitter)throw new Error("connect() must be called before attempting to listen to events.");v.formatProtocol("listen for event =>",{method:e},"verbose"),this._eventEmitter.on(e,t)}once(e,t){if(null===this._eventEmitter)throw new Error("connect() must be called before attempting to listen to events.")
;v.formatProtocol("listen once for event =>",{method:e},"verbose"),this._eventEmitter.once(e,t)}off(e,t){if(null===this._eventEmitter)throw new Error("connect() must be called before attempting to remove an event listener.");this._eventEmitter.removeListener(e,t)}_shouldToggleDomain(e,t,n){const i=e+(t||""),a=(this._domainEnabledCounts.get(i)||0)+(n?1:-1);return this._domainEnabledCounts.set(i,Math.max(0,a)),n&&1===a||!n&&0===a?(v.verbose("Driver",`${e}.${n?"enable":"disable"}`),!0):(a<0&&v.error("Driver",`Attempted to disable domain '${e}' when already disabled.`),!1)}hasNextProtocolTimeout(){return this._nextProtocolTimeout!==x}getNextProtocolTimeout(){return this._nextProtocolTimeout}setNextProtocolTimeout(e){this._nextProtocolTimeout=e}_handleProtocolEvent(e){this._devtoolsLog.record(e),this._networkStatusMonitor&&this._networkStatusMonitor.dispatch(e),this._eventEmitter.emit(e.method,e.params)}_handleEventError(e){v.error("Driver","Unhandled event error",e.message)}
async _handleTargetAttached(e){"iframe"===e.targetInfo.type?(await this.sendCommandToSession("Network.enable",e.sessionId),await this.sendCommandToSession("Target.setAutoAttach",e.sessionId,{autoAttach:!0,flatten:!0,waitForDebuggerOnStart:!0}),await this.sendCommandToSession("Runtime.runIfWaitingForDebugger",e.sessionId)):await this.sendCommandToSession("Runtime.runIfWaitingForDebugger",e.sessionId)}sendCommandToSession(e,t,...n){const i=this._nextProtocolTimeout;return this._nextProtocolTimeout=x,new Promise((async(a,s)=>{const l=setTimeout((()=>{const t=new p(p.errors.PROTOCOL_TIMEOUT,{protocolMethod:e});s(t)}),i);try{a(await this._innerSendCommand(e,t,...n))}catch(e){s(e)}finally{clearTimeout(l)}}))}sendCommand(e,...t){return this.sendCommandToSession(e,void 0,...t)}_innerSendCommand(e,t,...n){const i=/^(\w+)\.(enable|disable)$/.exec(e);if(i){const e="enable"===i[2];if(!this._shouldToggleDomain(i[1],t,e))return Promise.resolve()}return this._connection.sendCommand(e,t,...n)}
isDomainEnabled(e){return!!this._domainEnabledCounts.get(e)}evaluateScriptOnNewDocument(e){return this.sendCommand("Page.addScriptToEvaluateOnLoad",{scriptSource:e})}evaluateAsync(e,t){return this._executionContext.evaluateAsync(e,t)}async evaluate(e,t){return this._executionContext.evaluate(e,t)}async getAppManifest(){let e;this.setNextProtocolTimeout(1e4);try{e=await this.sendCommand("Page.getAppManifest")}catch(e){if("PROTOCOL_TIMEOUT"===e.code)return v.error("Driver","Failed fetching manifest",e),null;throw e}let t=e.data;if(!t)return null;return 65279===t.charCodeAt(0)&&(t=n.from(t).slice(3).toString()),{...e,data:t}}getServiceWorkerVersions(){return new Promise(((e,t)=>{const versionUpdatedListener=n=>{const i=n.versions.filter((e=>"redundant"!==e.status)),a=i.find((e=>"activated"===e.status));i.length&&!a||(this.off("ServiceWorker.workerVersionUpdated",versionUpdatedListener),this.sendCommand("ServiceWorker.disable").then((t=>e(n)),t))}
;this.on("ServiceWorker.workerVersionUpdated",versionUpdatedListener),this.sendCommand("ServiceWorker.enable").catch(t)}))}getServiceWorkerRegistrations(){return new Promise(((e,t)=>{this.once("ServiceWorker.workerRegistrationUpdated",(n=>{this.sendCommand("ServiceWorker.disable").then((t=>e(n)),t)})),this.sendCommand("ServiceWorker.enable").catch(t)}))}assertNoSameOriginServiceWorkerClients(e){let t,n;return this.getServiceWorkerRegistrations().then((e=>{t=e.registrations})).then((e=>this.getServiceWorkerVersions())).then((e=>{n=e.versions})).then((i=>{const a=new y(e).origin;t.filter((e=>{const t=new y(e.scopeURL).origin;return a===t})).forEach((e=>{n.forEach((t=>{if(t.registrationId===e.registrationId&&t.controlledClients&&t.controlledClients.length>0)throw new Error("You probably have multiple tabs open to the same origin.")}))}))}))}_beginNetworkStatusMonitoring(e){return this._networkStatusMonitor=new u,this._monitoredUrl=e,this._monitoredUrlNavigations=[],
this.sendCommand("Network.enable")}async _endNetworkStatusMonitoring(){const e=this._monitoredUrl,t=this._monitoredUrlNavigations,n=(await this.sendCommand("Page.getResourceTree")).frameTree.frame.id,i=t.filter((e=>e.id===n)),a=i[i.length-1];this._networkStatusMonitor=null,this._monitoredUrl=null,this._monitoredUrlNavigations=[];const s=a&&a.url||e;if(a||v.warn("Driver","No detected navigations"),!s)throw new Error("Unable to determine finalUrl");return s}async gotoURL(e,t={}){const n=t.waitForFcp||!1,i=t.waitForNavigated||!1,a=t.waitForLoad||!1,s=t.passContext||{};if(i&&(n||a))throw new Error("Cannot use both waitForNavigated and another event, pick just one");await this._beginNetworkStatusMonitoring(e),await this._executionContext.clearContextId(),await this.sendCommand("Target.setAutoAttach",{flatten:!0,autoAttach:!0,waitForDebuggerOnStart:!0}),await this.sendCommand("Page.enable"),await this.sendCommand("Page.setLifecycleEventsEnabled",{enabled:!0})
;const u=this._innerSendCommand("Page.navigate",void 0,{url:e});let d=!1;if(i)await c(this).promise;else if(a){const e=this._networkStatusMonitor,t=s.passConfig||{};let{pauseAfterFcpMs:i,pauseAfterLoadMs:a,networkQuietThresholdMs:c,cpuQuietThresholdMs:u}=t,m=s.settings&&s.settings.maxWaitForLoad,p=s.settings&&s.settings.maxWaitForFcp;if("number"!=typeof i&&(i=0),"number"!=typeof a&&(a=0),"number"!=typeof c&&(c=5e3),"number"!=typeof u&&(u=0),"number"!=typeof m&&(m=b.defaultSettings.maxWaitForLoad),"number"!=typeof p&&(p=b.defaultSettings.maxWaitForFcp),!e)throw new Error("Failed to instantiate networkStatusMonitor");n||(p=void 0);const h={pauseAfterFcpMs:i,pauseAfterLoadMs:a,networkQuietThresholdMs:c,cpuQuietThresholdMs:u,maxWaitForLoadedMs:m,maxWaitForFcpMs:p};d=(await l(this,e,h)).timedOut}return await u,{finalUrl:await this._endNetworkStatusMonitoring(),timedOut:d}}async getObjectProperty(e,t){const n=(await this.sendCommand("Runtime.getProperties",{objectId:e,
accessorPropertiesOnly:!0,generatePreview:!1,ownProperties:!1})).result.find((e=>e.name===t));return n&&n.value?n.value.value:null}async getRequestContent(e,t=1e3){e=h.getRequestIdForBackend(e),this.setNextProtocolTimeout(t);return(await this.sendCommand("Network.getResponseBody",{requestId:e})).body}async querySelector(e){const t=(await this.sendCommand("DOM.getDocument")).root.nodeId,n=await this.sendCommand("DOM.querySelector",{nodeId:t,selector:e});return 0===n.nodeId?null:new m(n,this)}async resolveNodeIdToObjectId(e){try{return(await this.sendCommand("DOM.resolveNode",{backendNodeId:e})).object.objectId}catch(e){if(/No node.*found/.test(e.message)||/Node.*does not belong to the document/.test(e.message))return;throw e}}async resolveDevtoolsNodePathToObjectId(e){try{const{nodeId:t}=await this.sendCommand("DOM.pushNodeByPathToFrontend",{path:e}),{object:{objectId:n}}=await this.sendCommand("DOM.resolveNode",{nodeId:t});return n}catch(e){if(/No node.*found/.test(e.message))return
;throw e}}scrollTo(e){const t=`window.scrollTo(${e.x}, ${e.y})`;return this.evaluateAsync(t,{useIsolation:!0})}getScrollPosition(){return this.evaluateAsync("({x: window.scrollX, y: window.scrollY})",{useIsolation:!0})}async beginTrace(e){const t=e&&e.additionalTraceCategories&&e.additionalTraceCategories.split(",")||[],n=this._traceCategories.concat(t);if((await this.getBrowserVersion()).milestone<71){const e=n.indexOf("disabled-by-default-lighthouse");n[e]="toplevel"}const i=Array.from(new Set(n));if(this.isDomainEnabled("CSS"))throw new Error("CSS domain enabled when starting trace");if(this.isDomainEnabled("DOM"))throw new Error("DOM domain enabled when starting trace");return this.sendCommand("Page.enable").then((e=>this.sendCommand("Tracing.start",{categories:i.join(","),options:"sampling-frequency=10000"})))}endTrace(){const e=[],dataListener=function(t){e.push(...t.value)};return this.on("Tracing.dataCollected",dataListener),new Promise(((t,n)=>{
this.once("Tracing.tracingComplete",(n=>{this.off("Tracing.dataCollected",dataListener),t({traceEvents:e})})),this.sendCommand("Tracing.end").catch(n)}))}beginDevtoolsLog(){this._devtoolsLog.reset(),this._devtoolsLog.beginRecording()}endDevtoolsLog(){return this._devtoolsLog.endRecording(),this._devtoolsLog.messages}enableRuntimeEvents(){return this.sendCommand("Runtime.enable")}async enableAsyncStacks(){await this.sendCommand("Debugger.enable"),await this.sendCommand("Debugger.setSkipAllPauses",{skip:!0}),await this.sendCommand("Debugger.setAsyncCallStackDepth",{maxDepth:8})}async beginEmulation(e){await d.emulate(this,e),await this.setThrottling(e,{useThrottling:!0})}async setThrottling(e,t){if("devtools"!==e.throttlingMethod)return d.clearAllNetworkEmulation(this);const n=t.useThrottling?d.enableCPUThrottling(this,e.throttling):d.disableCPUThrottling(this),i=t.useThrottling?d.enableNetworkThrottling(this,e.throttling):d.clearAllNetworkEmulation(this);await Promise.all([n,i])}
async goOffline(){await this.sendCommand("Network.enable"),await d.goOffline(this),this.online=!1}async goOnline(e){await this.setThrottling(e.settings,e.passConfig),this.online=!0}async cleanBrowserCaches(){const e={msg:"Cleaning browser cache",id:"lh:driver:cleanBrowserCaches"};v.time(e),await this.sendCommand("Network.clearBrowserCache"),await this.sendCommand("Network.setCacheDisabled",{cacheDisabled:!0}),await this.sendCommand("Network.setCacheDisabled",{cacheDisabled:!1}),v.timeEnd(e)}async setExtraHTTPHeaders(e){if(e)return this.sendCommand("Network.setExtraHTTPHeaders",{headers:e})}async clearDataForOrigin(e){const t=new y(e).origin,n=["appcache","file_systems","shader_cache","service_workers","cache_storage"].join(",");this.setNextProtocolTimeout(5e3);try{await this.sendCommand("Storage.clearDataForOrigin",{origin:t,storageTypes:n})}catch(e){if("PROTOCOL_TIMEOUT"!==e.code)throw e;v.warn("Driver","clearDataForOrigin timed out")}}async getImportantStorageWarning(e){
const t=await this.sendCommand("Storage.getUsageAndQuota",{origin:e}),n={local_storage:"Local Storage",indexeddb:"IndexedDB",websql:"Web SQL"},i=t.usageBreakdown.filter((e=>e.usage)).map((e=>n[e.storageType]||"")).filter(Boolean);if(i.length)return E(S.warningData,{locations:i.join(", "),locationCount:i.length})}async cacheNatives(){await this.evaluateScriptOnNewDocument("\n        window.__nativePromise = Promise;\n        window.__nativeError = Error;\n        window.__nativeURL = URL;\n        window.__ElementMatches = Element.prototype.matches;\n        window.__perfNow = performance.now.bind(performance);\n    ")}async registerPerformanceObserver(){const e=`(${T.registerPerformanceObserverInPageString})()`;await this.evaluateScriptOnNewDocument(e)}async registerRequestIdleCallbackWrap(e){if("simulate"===e.throttlingMethod){const t=`(${T.wrapRequestIdleCallbackString})\n        (${e.throttling.cpuSlowdownMultiplier})`;await this.evaluateScriptOnNewDocument(t)}}blockUrlPatterns(e){
return this.sendCommand("Network.setBlockedURLs",{urls:e}).catch((e=>{if(!/wasn't found/.test(e.message))throw e}))}async dismissJavaScriptDialogs(){this.on("Page.javascriptDialogOpening",(e=>{v.warn("Driver",e.type+" dialog opened by the page automatically suppressed."),this.sendCommand("Page.handleJavaScriptDialog",{accept:!0,promptText:"Lighthouse prompt response"}).catch((e=>v.warn("Driver",e)))})),await this.sendCommand("Page.enable")}}t.exports=Driver,t.exports.UIStrings=S}).call(this,e("buffer").Buffer,"/lighthouse-core/gather/driver.js")},{"../config/constants.js":56,"../lib/emulation.js":83,"../lib/i18n/i18n.js":84,"../lib/lh-element.js":90,"../lib/lh-error.js":92,"../lib/network-recorder.js":95,"../lib/network-request.js":96,"../lib/page-functions.js":97,"../lib/url-shim.js":"url","./connections/connection.js":58,"./devtools-log.js":60,"./driver/execution-context.js":62,"./driver/wait-for-condition.js":63,"./fetcher.js":64,buffer:130,events:134,"lighthouse-logger":115}],
62:[function(e,t,n){"use strict";const i=e("../../lib/page-functions.js");t.exports=class ExecutionContext{constructor(e){this._session=e,this._executionContextId=void 0,e.on("Page.frameNavigated",(()=>this.clearContextId())),e.on("Runtime.executionContextDestroyed",(e=>{e.executionContextId===this._executionContextId&&this.clearContextId()}))}getContextId(){return this._executionContextId}clearContextId(){this._executionContextId=void 0}async _getOrCreateIsolatedContextId(){if("number"==typeof this._executionContextId)return this._executionContextId;const e=(await this._session.sendCommand("Page.getResourceTree")).frameTree.frame.id,t=await this._session.sendCommand("Page.createIsolatedWorld",{frameId:e,worldName:"lighthouse_isolated_context"});return this._executionContextId=t.executionContextId,t.executionContextId}async _evaluateInContext(e,t){const n=this._session.hasNextProtocolTimeout()?this._session.getNextProtocolTimeout():6e4,a={
expression:`(function wrapInNativePromise() {\n        const __nativePromise = globalThis.__nativePromise || Promise;\n        const URL = globalThis.__nativeURL || globalThis.URL;\n        globalThis.__lighthouseExecutionContextId = ${t};\n        return new __nativePromise(function (resolve) {\n          return __nativePromise.resolve()\n            .then(_ => ${e})\n            .catch(${i.wrapRuntimeEvalErrorInBrowserString})\n            .then(resolve);\n        });\n      }())`,includeCommandLineAPI:!0,awaitPromise:!0,returnByValue:!0,timeout:n,contextId:t};this._session.setNextProtocolTimeout(n);const s=await this._session.sendCommand("Runtime.evaluate",a);if(s.exceptionDetails){const e=s.exceptionDetails.exception?s.exceptionDetails.exception.description:s.exceptionDetails.text;return Promise.reject(new Error("Evaluation exception: "+e))}if(void 0===s.result)return Promise.reject(new Error('Runtime.evaluate response did not contain a "result" object'));const l=s.result.value
;return l&&l.__failedInBrowser?Promise.reject(Object.assign(new Error,l)):l}async evaluateAsync(e,t={}){const n=t.useIsolation?await this._getOrCreateIsolatedContextId():void 0;try{return await this._evaluateInContext(e,n)}catch(t){if(n&&t.message.includes("Cannot find context")){this.clearContextId();const t=await this._getOrCreateIsolatedContextId();return this._evaluateInContext(e,t)}throw t}}evaluate(e,t){const n=t.args.map((e=>JSON.stringify(e))).join(","),i=`(() => {\n      ${t.deps?t.deps.join("\n"):""}\n      ${e}\n      return ${e.name}(${n});\n    })()`;return this.evaluateAsync(i,t)}}},{"../../lib/page-functions.js":97}],63:[function(e,t,n){"use strict";const i=e("lighthouse-logger"),a=e("../../lib/lh-error.js"),s=e("./execution-context.js"),l=e("../../lib/page-functions.js");function waitForNothing(){return{promise:Promise.resolve(),cancel(){}}}function waitForFcp(e,t,n){let cancel=()=>{throw new Error("waitForFcp.cancel() called before it was defined")};return{
promise:new Promise(((i,s)=>{const l=setTimeout((()=>{s(new a(a.errors.NO_FCP))}),n);let c;const lifecycleListener=e=>{"firstContentfulPaint"===e.name&&(c=setTimeout((()=>{i(),cancel()}),t))};e.on("Page.lifecycleEvent",lifecycleListener);let u=!1;cancel=()=>{u||(u=!0,e.off("Page.lifecycleEvent",lifecycleListener),l&&clearTimeout(l),c&&clearTimeout(c),s(new Error("Wait for FCP canceled")))}})),cancel}}function waitForNetworkIdle(e,t,n){let a,s=!1,cancel=()=>{throw new Error("waitForNetworkIdle.cancel() called before it was defined")};const{networkQuietThresholdMs:l,busyEvent:c,idleEvent:u,isIdle:d}=n;return{promise:new Promise(((n,m)=>{const onIdle=()=>{t.once(c,onBusy),a=setTimeout((()=>{cancel(),n()}),l)},onBusy=()=>{t.once(u,onIdle),a&&clearTimeout(a)},domContentLoadedListener=()=>{s=!0,d(t)?onIdle():onBusy()},logStatus=()=>{if(!s)return void i.verbose("waitFor","Waiting on DomContentLoaded");const e=t.getInflightRecords()
;if(e.length<20)for(const t of e)i.verbose("waitFor",`Waiting on ${t.url.slice(0,120)} to finish`)};t.on("requeststarted",logStatus),t.on("requestloaded",logStatus),t.on(c,logStatus),e.once("Page.domContentEventFired",domContentLoadedListener);let p=!1;cancel=()=>{p||(p=!0,a&&clearTimeout(a),e.off("Page.domContentEventFired",domContentLoadedListener),t.removeListener(c,onBusy),t.removeListener(u,onIdle),t.removeListener("requeststarted",logStatus),t.removeListener("requestloaded",logStatus),t.removeListener(c,logStatus))}})),cancel}}function waitForCPUIdle(e,t){if(!t)return{promise:Promise.resolve(),cancel:()=>{}};let n,a=!1;const c=`(${l.checkTimeSinceLastLongTaskString})()`;async function checkForQuiet(e,s){if(a)return;const l=await e.evaluateAsync(c);if(!a&&"number"==typeof l)if(l>=t)i.verbose("waitFor",`CPU has been idle for ${l} ms`),s();else{i.verbose("waitFor",`CPU has been idle for ${l} ms`);n=setTimeout((()=>checkForQuiet(e,s)),t-l)}}let cancel=()=>{
throw new Error("waitForCPUIdle.cancel() called before it was defined")};return{promise:new Promise(((t,i)=>{checkForQuiet(new s(e),t).catch(i),cancel=()=>{a||(a=!0,n&&clearTimeout(n),i(new Error("Wait for CPU idle canceled")))}})),cancel}}function waitForLoadEvent(e,t){let cancel=()=>{throw new Error("waitForLoadEvent.cancel() called before it was defined")};return{promise:new Promise(((n,i)=>{let a;const loadListener=function(){a=setTimeout(n,t)};e.once("Page.loadEventFired",loadListener);let s=!1;cancel=()=>{s||(s=!0,e.off("Page.loadEventFired",loadListener),a&&clearTimeout(a))}})),cancel}}const c={waitForFcp,waitForLoadEvent,waitForCPUIdle,waitForNetworkIdle};t.exports={waitForNothing,waitForFrameNavigated:function waitForFrameNavigated(e){let cancel=()=>{throw new Error("waitForFrameNavigated.cancel() called before it was defined")};return{promise:new Promise(((t,n)=>{e.once("Page.frameNavigated",t),cancel=()=>{e.off("Page.frameNavigated",t),
n(new Error("Wait for navigated cancelled"))}})),cancel}},waitForFcp,waitForLoadEvent,waitForNetworkIdle,waitForCPUIdle,waitForFullyLoaded:async function waitForFullyLoaded(e,t,n){const{pauseAfterFcpMs:s,pauseAfterLoadMs:l,networkQuietThresholdMs:u,cpuQuietThresholdMs:d,maxWaitForLoadedMs:m,maxWaitForFcpMs:p}=n,{waitForFcp:h,waitForLoadEvent:f,waitForNetworkIdle:g,waitForCPUIdle:y}=n._waitForTestOverrides||c;let b;const v=p?h(e,s,p):waitForNothing(),w=f(e,l),T=g(e,t,{networkQuietThresholdMs:u,busyEvent:"network-2-busy",idleEvent:"network-2-idle",isIdle:e=>e.is2Idle()}),S=g(e,t,{networkQuietThresholdMs:u,busyEvent:"network-critical-busy",idleEvent:"network-critical-idle",isIdle:e=>e.isCriticalIdle()});let E=waitForNothing();const x=Promise.all([v.promise,w.promise,T.promise,S.promise]).then((()=>(E=y(e,d),E.promise))).then((()=>async function(){return i.verbose("waitFor","loadEventFired and network considered idle"),{timedOut:!1}})).catch((e=>function(){throw e
})),_=new Promise(((e,t)=>{b=setTimeout(e,m)})).then((t=>async()=>{if(i.warn("waitFor","Timed out waiting for page load. Checking if page is hung..."),await async function isPageHung(e){try{return e.setNextProtocolTimeout(1e3),await e.sendCommand("Runtime.evaluate",{expression:'"ping"',returnByValue:!0,timeout:1e3}),!1}catch(e){return!0}}(e))throw i.warn("waitFor","Page appears to be hung, killing JavaScript..."),await e.sendCommand("Emulation.setScriptExecutionDisabled",{value:!0}),await e.sendCommand("Runtime.terminateExecution"),new a(a.errors.PAGE_HUNG);return{timedOut:!0}})),k=await Promise.race([x,_]);return b&&clearTimeout(b),v.cancel(),w.cancel(),T.cancel(),E.cancel(),k()}}},{"../../lib/lh-error.js":92,"../../lib/page-functions.js":97,"./execution-context.js":62,"lighthouse-logger":115}],64:[function(e,t,n){(function(n){"use strict";const i=e("lighthouse-logger");t.exports=class Fetcher{constructor(e){this.driver=e,this._onRequestPausedHandlers=new Map,
this._onRequestPaused=this._onRequestPaused.bind(this),this._enabled=!1}async enableRequestInterception(){this._enabled||(this._enabled=!0,await this.driver.sendCommand("Fetch.enable",{patterns:[{requestStage:"Request"},{requestStage:"Response"}]}),await this.driver.on("Fetch.requestPaused",this._onRequestPaused))}async disableRequestInterception(){this._enabled&&(this._enabled=!1,await this.driver.off("Fetch.requestPaused",this._onRequestPaused),await this.driver.sendCommand("Fetch.disable"),this._onRequestPausedHandlers.clear())}async _setOnRequestPausedHandler(e,t){this._onRequestPausedHandlers.set(e,t)}_onRequestPaused(e){const t=this._onRequestPausedHandlers.get(e.request.url);t?t(e):this.driver.sendCommand("Fetch.continueRequest",{requestId:e.requestId}).catch((e=>{i.error("Fetcher","Failed to continueRequest: "+e.message)}))}async fetchResource(e,{timeout:t=500}){if(!this._enabled)throw new Error("Must call `enableRequestInterception` before using fetchResource")
;const i=new Promise(((t,i)=>{const handlerAsync=async e=>{const{requestId:a,responseStatusCode:s}=e;if(!s){const t=Object.entries(e.request.headers).filter((([e])=>"Cookie"!==e)).map((([e,t])=>({name:e,value:t})));return void await this.driver.sendCommand("Fetch.continueRequest",{requestId:a,headers:t})}if(!(s>=200&&s<300))return void i(new Error("Invalid response status code: "+s));const l=await this.driver.sendCommand("Fetch.getResponseBody",{requestId:a});l.base64Encoded?t(n.from(l.body,"base64").toString()):t(l.body),await this.driver.sendCommand("Fetch.failRequest",{requestId:a,errorReason:"Aborted"})};this._setOnRequestPausedHandler(e,(e=>handlerAsync(e).catch(i)))}));let a;const s=new Promise(((e,n)=>{a=setTimeout((()=>n(new Error("Timed out fetching resource."))),t)})),l=Promise.race([s,i]).finally((()=>clearTimeout(a))),c=this.driver.evaluate((function injectIframe(e){const t=document.createElement("iframe");t.style.display="none",t.style.visibility="hidden",
t.style.position="absolute",t.style.top="-1000px",t.style.left="-1000px",t.style.width="1px",t.style.height="1px",t.src=e,t.onload=t.onerror=()=>{t.remove(),t.onload=null,t.onerror=null},document.body.appendChild(t)}),{args:[e],useIsolation:!0}),[u]=await Promise.all([l,c]);return u}}}).call(this,e("buffer").Buffer)},{buffer:130,"lighthouse-logger":115}],65:[function(e,t,n){(function(n){"use strict";const i=e("lighthouse-logger"),a=e("../lib/manifest-parser.js"),s=e("../lib/stack-collector.js"),l=e("../lib/lh-error.js"),c=e("../lib/dependency-graph/simulator/network-analyzer.js"),u=e("../lib/network-recorder.js"),d=e("../config/constants.js"),m=e("../lib/i18n/i18n.js"),p=e("../lib/url-shim.js"),h={warningRedirected:"The page may not be loading as expected because your test URL ({requested}) was redirected to {final}. Try testing the second URL directly.",warningTimeout:"The page loaded too slowly to finish within the time limit. Results may be incomplete.",
warningSlowHostCpu:"The tested device appears to have a slower CPU than  Lighthouse expects. This can negatively affect your performance score. Learn more about [calibrating an appropriate CPU slowdown multiplier](https://github.com/GoogleChrome/lighthouse/blob/master/docs/throttling.md#cpu-throttling)."},f=m.createMessageInstanceIdFn(n,h);class GatherRunner{static async loadBlank(e,t=d.defaultPassConfig.blankPage){const n={msg:"Resetting state with about:blank",id:"lh:gather:loadBlank"};i.time(n),await e.gotoURL(t,{waitForNavigated:!0}),i.timeEnd(n)}static async loadPage(e,t){const n={msg:"Loading page & waiting for onload",id:"lh:gather:loadPage-"+t.passConfig.passName};i.time(n);try{const{finalUrl:a,timedOut:s}=await e.gotoURL(t.url,{waitForFcp:t.passConfig.recordTrace,waitForLoad:!0,passContext:t});t.url=a,s&&t.LighthouseRunWarnings.push(f(h.warningTimeout))}catch(e){if("NO_FCP"===e.code||"PAGE_HUNG"===e.code)return{navigationError:e};throw e}finally{i.timeEnd(n)}return{}}
static async setupDriver(e,t,n){const a={msg:"Initializing…",id:"lh:gather:setupDriver"};i.time(a);const s=!t.settings.disableStorageReset;if(await e.assertNoSameOriginServiceWorkerClients(t.requestedUrl),await e.beginEmulation(t.settings),await e.enableRuntimeEvents(),await e.enableAsyncStacks(),await e.cacheNatives(),await e.registerPerformanceObserver(),await e.dismissJavaScriptDialogs(),await e.registerRequestIdleCallbackWrap(t.settings),s){const i=await e.getImportantStorageWarning(t.requestedUrl);i&&n.push(i),await e.clearDataForOrigin(t.requestedUrl)}i.timeEnd(a)}static async disposeDriver(e,t){const n={msg:"Disconnecting from browser...",id:"lh:gather:disconnect"};i.time(n);try{!t.settings.disableStorageReset&&await e.clearDataForOrigin(t.requestedUrl),await e.fetcher.disableRequestInterception(),await e.disconnect()}catch(e){/close\/.*status: (500|404)$/.test(e.message)||i.error("GatherRunner disconnect",e.message)}i.timeEnd(n)}static getNetworkError(e){
if(!e)return new l(l.errors.NO_DOCUMENT_REQUEST);if(e.failed){const t=e.localizedFailDescription;return"net::ERR_NAME_NOT_RESOLVED"===t||"net::ERR_NAME_RESOLUTION_FAILED"===t||t.startsWith("net::ERR_DNS_")?new l(l.errors.DNS_FAILURE):new l(l.errors.FAILED_DOCUMENT_REQUEST,{errorDetails:t})}return e.hasErrorStatusCode()?new l(l.errors.ERRORED_DOCUMENT_REQUEST,{statusCode:""+e.statusCode}):void 0}static getInterstitialError(e,t){if(!e)return;return t.find((e=>e.documentURL.startsWith("chrome-error://")))&&e.failed?e.localizedFailDescription.startsWith("net::ERR_CERT")?new l(l.errors.INSECURE_DOCUMENT_REQUEST,{securityMessages:e.localizedFailDescription}):new l(l.errors.CHROME_INTERSTITIAL_ERROR):void 0}static getNonHtmlError(e){if(e)return"text/html"!==e.mimeType?new l(l.errors.NOT_HTML,{mimeType:e.mimeType}):void 0}static getPageLoadError(e,t,n){const{networkRecords:i}=t;let a,s;try{a=c.findMainDocument(i,e.url)}catch(e){}a&&(s=c.resolveRedirects(a))
;const l=GatherRunner.getNetworkError(a),u=GatherRunner.getInterstitialError(a,i),d=GatherRunner.getNonHtmlError(s);if("ignore"!==e.passConfig.loadFailureMode)return u||(l||(d||n))}static getSlowHostCpuWarning(e){const{settings:t,baseArtifacts:n}=e,{throttling:i,throttlingMethod:a}=t,s=d.defaultSettings.throttling;if("cli"!==t.channel)return;const l="simulate"===a||"devtools"===a,c=i.cpuSlowdownMultiplier===s.cpuSlowdownMultiplier;return!l||!c||n.BenchmarkIndex>1e3?void 0:f(h.warningSlowHostCpu)}static async setupPassNetwork(e){const t={msg:"Setting up network for the pass trace",id:"lh:gather:setupPassNetwork"};i.time(t);const n=e.passConfig;await e.driver.setThrottling(e.settings,n);const a=(e.passConfig.blockedUrlPatterns||[]).concat(e.settings.blockedUrlPatterns||[]);await e.driver.blockUrlPatterns(a),await e.driver.setExtraHTTPHeaders(e.settings.extraHeaders),i.timeEnd(t)}static async beginRecording(e){const t={msg:"Beginning devtoolsLog and trace",id:"lh:gather:beginRecording"}
;i.time(t);const{driver:n,passConfig:a,settings:s}=e;await n.beginDevtoolsLog(),a.recordTrace&&await n.beginTrace(s),i.timeEnd(t)}static async endRecording(e){const{driver:t,passConfig:n}=e;let a;if(n.recordTrace){const e={msg:"Gathering trace",id:"lh:gather:getTrace"};i.time(e),a=await t.endTrace(),i.timeEnd(e)}const s={msg:"Gathering devtoolsLog & network records",id:"lh:gather:getDevtoolsLog"};i.time(s);const l=t.endDevtoolsLog(),c=u.recordsFromLogs(l);return i.timeEnd(s),{networkRecords:c,devtoolsLog:l,trace:a}}static async beforePass(e,t){const n={msg:"Running beforePass methods",id:"lh:gather:beforePass"};i.time(n,"verbose");for(const n of e.passConfig.gatherers){const a=n.instance,s={msg:"Gathering setup: "+a.name,id:"lh:gather:beforePass:"+a.name};i.time(s,"verbose");const l=Promise.resolve().then((t=>a.beforePass(e)));t[a.name]=[l],await l.catch((()=>{})),i.timeEnd(s)}i.timeEnd(n)}static async pass(e,t){const n=e.passConfig.gatherers,a={msg:"Running pass methods",
id:"lh:gather:pass"};i.time(a,"verbose");for(const a of n){const n=a.instance,s={msg:"Gathering in-page: "+n.name,id:"lh:gather:pass:"+n.name};i.time(s);const l=Promise.resolve().then((t=>n.pass(e))),c=t[n.name]||[];c.push(l),t[n.name]=c,await l.catch((()=>{}))}i.timeEnd(a)}static async afterPass(e,t,n){const a=e.driver,s=e.passConfig.gatherers,l={msg:"Running afterPass methods",id:"lh:gather:afterPass"};i.time(l,"verbose");const c=await a.getScrollPosition();for(const l of s){const s=l.instance,u={msg:"Gathering: "+s.name,id:"lh:gather:afterPass:"+s.name};i.time(u);const d=Promise.resolve().then((n=>s.afterPass(e,t))),m=n[s.name]||[];m.push(d),n[s.name]=m,await d.catch((()=>{})),await a.scrollTo(c),i.timeEnd(u)}i.timeEnd(l)}static async collectArtifacts(e){const t={},n=Object.entries(e);for(const[e,i]of n){try{const n=(await Promise.all(i)).filter((e=>void 0!==e)),a=n[n.length-1];t[e]=a}catch(n){t[e]=n}if(void 0===t[e])throw new Error(e+" failed to provide an artifact.")}return{
artifacts:t}}static async initializeBaseArtifacts(e){const t=(await e.driver.getBrowserVersion()).userAgent,n=t.includes("Android")||t.includes("Mobile")?"mobile":"desktop";return{fetchTime:(new Date).toJSON(),LighthouseRunWarnings:[],HostFormFactor:n,HostUserAgent:t,NetworkUserAgent:"",BenchmarkIndex:0,WebAppManifest:null,InstallabilityErrors:{errors:[]},Stacks:[],traces:{},devtoolsLogs:{},settings:e.settings,URL:{requestedUrl:e.requestedUrl,finalUrl:e.requestedUrl},Timing:[],PageLoadError:null}}static async getInstallabilityErrors(e){const t={msg:"Get webapp installability errors",id:"lh:gather:getInstallabilityErrors"};i.time(t);const n=(await e.driver.sendCommand("Page.getInstallabilityErrors")).installabilityErrors;return i.timeEnd(t),{errors:n}}static async populateBaseArtifacts(e){const t={msg:"Populate base artifacts",id:"lh:gather:populateBaseArtifacts"};i.time(t);const n=e.baseArtifacts;n.URL.finalUrl=e.url,
p.equalWithExcludedFragments(n.URL.requestedUrl,n.URL.finalUrl)||n.LighthouseRunWarnings.push(f(h.warningRedirected,{requested:n.URL.requestedUrl,final:n.URL.finalUrl})),n.WebAppManifest=await GatherRunner.getWebAppManifest(e),n.WebAppManifest&&(n.InstallabilityErrors=await GatherRunner.getInstallabilityErrors(e)),n.Stacks=await s(e);const a=n.devtoolsLogs[e.passConfig.passName].find((e=>"Network.requestWillBeSent"===e.method&&!!e.params.request.headers["User-Agent"]));a&&(n.NetworkUserAgent=a.params.request.headers["User-Agent"]);const l=GatherRunner.getSlowHostCpuWarning(e);l&&n.LighthouseRunWarnings.push(l),i.timeEnd(t)}static finalizeBaseArtifacts(e){e.LighthouseRunWarnings=Array.from(new Set(e.LighthouseRunWarnings)),e.Timing=i.getTimeEntries()}static async getWebAppManifest(e){const t={msg:"Get webapp manifest",id:"lh:gather:getWebAppManifest"};i.time(t);const n=await e.driver.getAppManifest();if(!n)return null;const s=a(n.data,n.url,e.url);return i.timeEnd(t),s}
static async run(e,t){const n=t.driver,i={};try{await n.connect(),await GatherRunner.loadBlank(n);const a=await GatherRunner.initializeBaseArtifacts(t);a.BenchmarkIndex=await t.driver.getBenchmarkIndex(),await GatherRunner.setupDriver(n,t,a.LighthouseRunWarnings);let s=!0;for(const l of e){const e={driver:n,url:t.requestedUrl,settings:t.settings,passConfig:l,baseArtifacts:a,LighthouseRunWarnings:a.LighthouseRunWarnings},c=await GatherRunner.runPass(e);if(Object.assign(i,c.artifacts),c.pageLoadError&&"fatal"===l.loadFailureMode){a.PageLoadError=c.pageLoadError;break}s&&(await GatherRunner.populateBaseArtifacts(e),s=!1),await n.fetcher.disableRequestInterception()}return await GatherRunner.disposeDriver(n,t),GatherRunner.finalizeBaseArtifacts(a),{...a,...i}}catch(e){throw GatherRunner.disposeDriver(n,t),e}}static shouldClearCaches(e){const{settings:t,passConfig:n}=e;return!t.disableStorageReset&&n.recordTrace&&n.useThrottling}static _addLoadDataToBaseArtifacts(e,t,n){
const i=e.baseArtifacts;i.devtoolsLogs[n]=t.devtoolsLog,t.trace&&(i.traces[n]=t.trace)}static async runPass(e){const t={msg:`Running ${e.passConfig.passName} pass`,id:"lh:gather:runPass-"+e.passConfig.passName,args:[e.passConfig.gatherers.map((e=>e.instance.name)).join(", ")]};i.time(t);const n={},{driver:a,passConfig:s}=e;await GatherRunner.loadBlank(a,s.blankPage),await GatherRunner.setupPassNetwork(e),GatherRunner.shouldClearCaches(e)&&await a.cleanBrowserCaches(),await GatherRunner.beforePass(e,n),await GatherRunner.beginRecording(e);const{navigationError:l}=await GatherRunner.loadPage(a,e);await GatherRunner.pass(e,n);const c=await GatherRunner.endRecording(e);await a.setThrottling(e.settings,{useThrottling:!1});const u=GatherRunner.getPageLoadError(e,c,l);if(u){const n=m.getFormatted(u.friendlyMessage,e.settings.locale);return i.error("GatherRunner",n,e.url),e.LighthouseRunWarnings.push(u.friendlyMessage),GatherRunner._addLoadDataToBaseArtifacts(e,c,"pageLoadError-"+s.passName),
i.timeEnd(t),{artifacts:{},pageLoadError:u}}GatherRunner._addLoadDataToBaseArtifacts(e,c,s.passName),await GatherRunner.afterPass(e,c,n);const d=GatherRunner.collectArtifacts(n);return i.timeEnd(t),d}}t.exports=GatherRunner,t.exports.UIStrings=h}).call(this,"/lighthouse-core/gather/gather-runner.js")},{"../config/constants.js":56,"../lib/dependency-graph/simulator/network-analyzer.js":79,"../lib/i18n/i18n.js":84,"../lib/lh-error.js":92,"../lib/manifest-parser.js":93,"../lib/network-recorder.js":95,"../lib/stack-collector.js":100,"../lib/url-shim.js":"url","lighthouse-logger":115}],66:[function(e,t,n){"use strict";t.exports=class Gatherer{get name(){return this.constructor.name}beforePass(e){}pass(e){}afterPass(e,t){}}},{}],67:[function(e,t,n){"use strict";const i=e("./runner.js"),a=e("lighthouse-logger"),s=e("./gather/connections/cri.js"),l=e("./config/config.js");async function lighthouse(e,t={},n,l){t.logLevel=t.logLevel||"error",a.setLevel(t.logLevel);const c={url:e,
config:generateConfig(n,t)},u=l||new s(t.port,t.hostname);return i.run((({requestedUrl:e})=>i._gatherArtifactsFromBrowser(e,c,u)),c)}function generateConfig(e,t){return new l(e,t)}lighthouse.generateConfig=generateConfig,lighthouse.getAuditList=i.getAuditList,lighthouse.traceCategories=e("./gather/driver.js").traceCategories,lighthouse.Audit=e("./audits/audit.js"),lighthouse.Gatherer=e("./gather/gatherers/gatherer.js"),lighthouse.NetworkRecords=e("./computed/network-records.js"),t.exports=lighthouse},{"./audits/audit.js":3,"./computed/network-records.js":42,"./config/config.js":55,"./gather/connections/cri.js":129,"./gather/driver.js":61,"./gather/gatherers/gatherer.js":66,"./runner.js":113,"lighthouse-logger":115}],68:[function(e,t,n){"use strict";const i=e("lodash.isequal");class ArbitraryEqualityMap{constructor(){this._equalsFn=ArbitraryEqualityMap.deepEquals,this._entries=[]}setEqualityFn(e){this._equalsFn=e}has(e){return-1!==this._findIndexOf(e)}get(e){
const t=this._entries[this._findIndexOf(e)];return t&&t.value}set(e,t){let n=this._findIndexOf(e);-1===n&&(n=this._entries.length),this._entries[n]={key:e,value:t}}_findIndexOf(e){for(let t=0;t<this._entries.length;t++)if(this._equalsFn(e,this._entries[t].key))return t;return-1}static deepEquals(e,t){return i(e,t)}}t.exports=ArbitraryEqualityMap},{"lodash.isequal":176}],69:[function(e,t,n){(function(n){"use strict";const i=e("fs"),a=e("path"),s=e("lighthouse-logger"),l=e("stream"),c=e("./dependency-graph/simulator/simulator.js"),u=e("./lantern-trace-saver.js"),d=e("./traces/pwmetrics-events.js"),m=e("rimraf"),p=e("../computed/network-analysis.js"),h=e("../computed/load-simulator.js"),f=e("../lib/lh-error.js"),g="artifacts.json",y=".trace.json",b=".devtoolslog.json";function stringifyReplacer(e,t){return t instanceof Error?f.stringifyReplacer(t):t}async function prepareAssets(e,t){const n=Object.keys(e.traces),i=[];for(const a of n){
const n=e.traces[a],s=e.devtoolsLogs[a],l=Object.assign({},n);if(t){const e=new d(l.traceEvents,t).generateFakeEvents();l.traceEvents=l.traceEvents.concat(e)}i.push({passName:a,traceData:l,devtoolsLog:s})}return i}function saveTrace(e,t){return new Promise(((n,a)=>{const s=function*traceJsonGenerator(e){const t=Object.keys(e);if(yield"{\n",yield'"traceEvents": [\n',e.traceEvents.length>0){const t=e.traceEvents[Symbol.iterator](),n=t.next().value;yield"  "+JSON.stringify(n);let i=500,a="";for(const e of t)a+=",\n  "+JSON.stringify(e),i--,0===i&&(yield a,i=500,a="");yield a}if(yield"\n]",t.length>1)for(const n of t)"traceEvents"!==n&&(yield`,\n"${n}": ${JSON.stringify(e[n],null,2)}`);yield"}\n"}(e),c=new l.Readable({read(){const e=s.next();this.push(e.done?null:e.value)}}),u=i.createWriteStream(t);u.on("finish",n),u.on("error",a),c.pipe(u)}))}t.exports={saveArtifacts:async function saveArtifacts(e,t){const n={msg:"Saving artifacts",id:"lh:assetSaver:saveArtifacts"};s.time(n),
i.mkdirSync(t,{recursive:!0}),m.sync(t+"/*.trace.json"),m.sync(t+"/artifacts.json");const{traces:a,devtoolsLogs:l,...c}=e;for(const[e,n]of Object.entries(a))await saveTrace(n,`${t}/${e}.trace.json`);for(const[e,n]of Object.entries(l)){const a=JSON.stringify(n);i.writeFileSync(`${t}/${e}.devtoolslog.json`,a,"utf8")}const u=JSON.stringify(c,stringifyReplacer,2);i.writeFileSync(t+"/artifacts.json",u,"utf8"),s.log("Artifacts saved to disk in folder:",t),s.timeEnd(n)},saveLhr:function saveLhr(e,t){i.writeFileSync(t+"/lhr.report.json",JSON.stringify(e,null,2))},loadArtifacts:function loadArtifacts(e){if(s.log("Reading artifacts from disk:",e),!i.existsSync(e))throw new Error("No saved artifacts found at "+e);const t=i.readFileSync(a.join(e,g),"utf8"),n=JSON.parse(t,f.parseReviver),l=i.readdirSync(e);return n.devtoolsLogs={},l.filter((e=>e.endsWith(b))).forEach((t=>{const s=t.replace(b,""),l=JSON.parse(i.readFileSync(a.join(e,t),"utf8"));n.devtoolsLogs[s]=l})),n.traces={},
l.filter((e=>e.endsWith(y))).forEach((t=>{const s=i.readFileSync(a.join(e,t),{encoding:"utf-8"}),l=JSON.parse(s),c=t.replace(y,"");n.traces[c]=Array.isArray(l)?{traceEvents:l}:l})),Array.isArray(n.Timing)&&n.Timing.forEach((e=>e.gather=!0)),n},saveAssets:async function saveAssets(e,t,a){const l=(await prepareAssets(e,t)).map((async(e,t)=>{const n=`${a}-${t}.devtoolslog.json`;i.writeFileSync(n,JSON.stringify(e.devtoolsLog,null,2)),s.log("saveAssets","devtools log saved to disk: "+n);const l=`${a}-${t}.trace.json`;s.log("saveAssets","streaming trace file to disk: "+l),await saveTrace(e.traceData,l),s.log("saveAssets","trace file streamed to disk: "+l)}));await Promise.all(l),await async function saveLanternDebugTraces(e){if(n.env.LANTERN_DEBUG)for(const[t,n]of c.ALL_NODE_TIMINGS){if(u.simulationNamesToIgnore.includes(t))continue;const i=`${e}-${t}.trace.json`;await saveTrace(u.convertNodeTimingsToTrace(n),i),s.log("saveAssets",`${t} lantern trace file streamed to disk: ${i}`)}}(a)},
prepareAssets,saveTrace,saveLanternNetworkData:async function saveLanternNetworkData(e,t){const n={computedCache:new Map},a=await p.request(e,n),s=h.convertAnalysisToSaveableLanternData(a);i.writeFileSync(t,JSON.stringify(s))},stringifyReplacer}}).call(this,e("_process"))},{"../computed/load-simulator.js":12,"../computed/network-analysis.js":41,"../lib/lh-error.js":92,"./dependency-graph/simulator/simulator.js":81,"./lantern-trace-saver.js":87,"./traces/pwmetrics-events.js":108,_process:190,fs:129,"lighthouse-logger":115,path:188,rimraf:129,stream:215}],70:[function(e,t,n){"use strict";t.exports={
source:'/*! axe v4.1.1\n * Copyright (c) 2020 Deque Systems, Inc.\n *\n * Your use of this Source Code Form is subject to the terms of the Mozilla Public\n * License, v. 2.0. If a copy of the MPL was not distributed with this\n * file, You can obtain one at http://mozilla.org/MPL/2.0/.\n *\n * This entire copyright notice must appear in every copy of this file you\n * distribute or in any file that contains substantial portions of this source\n * code.\n */\n!function e(window){var Ws=window,document=window.document;function Gs(e){return(Gs="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}var axe=axe||{};function Ys(e){this.name="SupportError",this.cause=e.cause,this.message="`".concat(e.cause,"` - feature unsupported in your environment."),e.ruleId&&(this.ruleId=e.ruleId,this.message+=" Skipping ".concat(this.ruleId," rule.")),this.stack=(new Error).stack}function Ks(e,t){if(null==e)return{};var r,a=function(e,t){if(null==e)return{};var r,a,n={},o=Object.keys(e);for(a=0;a<o.length;a++)r=o[a],0<=t.indexOf(r)||(n[r]=e[r]);return n}(e,t);if(Object.getOwnPropertySymbols)for(var n=Object.getOwnPropertySymbols(e),o=0;o<n.length;o++)r=n[o],0<=t.indexOf(r)||Object.prototype.propertyIsEnumerable.call(e,r)&&(a[r]=e[r]);return a}function Xs(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function");e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,writable:!0,configurable:!0}}),t&&r(e,t)}function r(e,t){return(r=Object.setPrototypeOf||function(e,t){return e.__proto__=t,e})(e,t)}function Js(o){var i=function(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Date.prototype.toString.call(Reflect.construct(Date,[],function(){})),!0}catch(e){return!1}}();return function(){var e,t,r,a,n=l(o);return t=i?(e=l(this).constructor,Reflect.construct(n,arguments,e)):n.apply(this,arguments),r=this,!(a=t)||"object"!==Gs(a)&&"function"!=typeof a?Qs(r):a}}function Qs(e){if(void 0===e)throw new ReferenceError("this hasn\'t been initialised - super() hasn\'t been called");return e}function l(e){return(l=Object.setPrototypeOf?Object.getPrototypeOf:function(e){return e.__proto__||Object.getPrototypeOf(e)})(e)}function Zs(e){return function(e){if(Array.isArray(e))return n(e)}(e)||function(e){if("undefined"!=typeof Symbol&&Symbol.iterator in Object(e))return Array.from(e)}(e)||nc(e)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function ec(){return(ec=Object.assign||function(e){for(var t=1;t<arguments.length;t++){var r=arguments[t];for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(e[a]=r[a])}return e}).apply(this,arguments)}function tc(e,t){return function(e){if(Array.isArray(e))return e}(e)||function(e,t){if("undefined"==typeof Symbol||!(Symbol.iterator in Object(e)))return;var r=[],a=!0,n=!1,o=void 0;try{for(var i,l=e[Symbol.iterator]();!(a=(i=l.next()).done)&&(r.push(i.value),!t||r.length!==t);a=!0);}catch(e){n=!0,o=e}finally{try{a||null==l.return||l.return()}finally{if(n)throw o}}return r}(e,t)||nc(e,t)||function(){throw new TypeError("Invalid attempt to destructure non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function rc(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}function a(e,t){for(var r=0;r<t.length;r++){var a=t[r];a.enumerable=a.enumerable||!1,a.configurable=!0,"value"in a&&(a.writable=!0),Object.defineProperty(e,a.key,a)}}function ac(e,t,r){return t&&a(e.prototype,t),r&&a(e,r),e}function nc(e,t){if(e){if("string"==typeof e)return n(e,t);var r=Object.prototype.toString.call(e).slice(8,-1);return"Object"===r&&e.constructor&&(r=e.constructor.name),"Map"===r||"Set"===r?Array.from(e):"Arguments"===r||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(r)?n(e,t):void 0}}function n(e,t){(null==t||t>e.length)&&(t=e.length);for(var r=0,a=new Array(t);r<t;r++)a[r]=e[r];return a}function Gs(e){return(Gs="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}axe.version="4.1.1","function"==typeof define&&define.amd&&define("axe-core",[],function(){return axe}),"object"===("undefined"==typeof module?"undefined":Gs(module))&&module.exports&&"function"==typeof e.toString&&(axe.source="("+e.toString()+\')(typeof window === "object" ? window : this);\',module.exports=axe),"function"==typeof window.getComputedStyle&&(window.axe=axe),(Ys.prototype=Object.create(Error.prototype)).constructor=Ys,function(){function o(e){return i(e,"__esModule",{value:!0})}function e(e,t){return function(){return t||e((t={exports:{}}).exports,t),t.exports}}function t(e,t){for(var r in o(e),t)i(e,r,{get:t[r],enumerable:!0})}function r(t,r){if(o(t),"object"===Gs(r)||"function"==typeof r){var a,n=function(e,t){var r;if("undefined"==typeof Symbol||null==e[Symbol.iterator]){if(Array.isArray(e)||(r=nc(e))||t&&e&&"number"==typeof e.length){r&&(e=r);function a(){}var n=0;return{s:a,n:function(){return n>=e.length?{done:!0}:{done:!1,value:e[n++]}},e:function(e){throw e},f:a}}throw new TypeError("Invalid attempt to iterate non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}var o,i=!0,l=!1;return{s:function(){r=e[Symbol.iterator]()},n:function(){var e=r.next();return i=e.done,e},e:function(e){l=!0,o=e},f:function(){try{i||null==r.return||r.return()}finally{if(l)throw o}}}}(s(r));try{for(n.s();!(a=n.n()).done;)!function(){var e=a.value;u.call(t,e)||"default"===e||i(t,e,{get:function(){return r[e]},enumerable:c(r,e).enumerable})}()}catch(e){n.e(e)}finally{n.f()}}return t}function a(e){return e&&e.__esModule?e:r(i(n(l(e)),"default",{value:e,enumerable:!0}),e)}var n=Object.create,i=Object.defineProperty,l=Object.getPrototypeOf,u=Object.prototype.hasOwnProperty,s=Object.getOwnPropertyNames,c=Object.getOwnPropertyDescriptor,d=e(function(l){"use strict";Object.defineProperty(l,"__esModule",{value:!0}),l.isIdentStart=function(e){return"a"<=e&&e<="z"||"A"<=e&&e<="Z"||"-"===e||"_"===e},l.isIdent=function(e){return"a"<=e&&e<="z"||"A"<=e&&e<="Z"||"0"<=e&&e<="9"||"-"===e||"_"===e},l.isHex=function(e){return"a"<=e&&e<="f"||"A"<=e&&e<="F"||"0"<=e&&e<="9"},l.escapeIdentifier=function(e){for(var t=e.length,r="",a=0;a<t;){var n=e.charAt(a);if(l.identSpecialChars[n])r+="\\\\"+n;else if("_"===n||"-"===n||"A"<=n&&n<="Z"||"a"<=n&&n<="z"||0!==a&&"0"<=n&&n<="9")r+=n;else{var o=n.charCodeAt(0);if(55296==(63488&o)){var i=e.charCodeAt(a++);if(55296!=(64512&o)||56320!=(64512&i))throw Error("UCS-2(decode): illegal sequence");o=((1023&o)<<10)+(1023&i)+65536}r+="\\\\"+o.toString(16)+" "}a++}return r},l.escapeStr=function(e){for(var t,r=e.length,a="",n=0;n<r;){var o=e.charAt(n);\'"\'===o?o=\'\\\\"\':"\\\\"===o?o="\\\\\\\\":void 0!==(t=l.strReplacementsRev[o])&&(o=t),a+=o,n++}return\'"\'+a+\'"\'},l.identSpecialChars={"!":!0,\'"\':!0,"#":!0,$:!0,"%":!0,"&":!0,"\'":!0,"(":!0,")":!0,"*":!0,"+":!0,",":!0,".":!0,"/":!0,";":!0,"<":!0,"=":!0,">":!0,"?":!0,"@":!0,"[":!0,"\\\\":!0,"]":!0,"^":!0,"`":!0,"{":!0,"|":!0,"}":!0,"~":!0},l.strReplacementsRev={"\\n":"\\\\n","\\r":"\\\\r","\\t":"\\\\t","\\f":"\\\\f","\\v":"\\\\v"},l.singleQuoteEscapeChars={n:"\\n",r:"\\r",t:"\\t",f:"\\f","\\\\":"\\\\","\'":"\'"},l.doubleQuotesEscapeChars={n:"\\n",r:"\\r",t:"\\t",f:"\\f","\\\\":"\\\\",\'"\':\'"\'}}),p=e(function(e){"use strict";Object.defineProperty(e,"__esModule",{value:!0});var b=d();e.parseCssSelector=function(l,u,s,c,n,d){var p=l.length,f="";function m(e,t){var r="";for(u++,f=l.charAt(u);u<p;){if(f===e)return u++,r;if("\\\\"===f){u++;var a;if((f=l.charAt(u))===e)r+=e;else if(void 0!==(a=t[f]))r+=a;else{if(b.isHex(f)){var n=f;for(u++,f=l.charAt(u);b.isHex(f);)n+=f,u++,f=l.charAt(u);" "===f&&(u++,f=l.charAt(u)),r+=String.fromCharCode(parseInt(n,16));continue}r+=f}}else r+=f;u++,f=l.charAt(u)}return r}function h(){var e="";for(f=l.charAt(u);u<p;){if(b.isIdent(f))e+=f;else{if("\\\\"!==f)return e;if(p<=++u)throw Error("Expected symbol but end of file reached.");if(f=l.charAt(u),b.identSpecialChars[f])e+=f;else{if(b.isHex(f)){var t=f;for(u++,f=l.charAt(u);b.isHex(f);)t+=f,u++,f=l.charAt(u);" "===f&&(u++,f=l.charAt(u)),e+=String.fromCharCode(parseInt(t,16));continue}e+=f}}u++,f=l.charAt(u)}return e}function g(){f=l.charAt(u);for(var e=!1;" "===f||"\\t"===f||"\\n"===f||"\\r"===f||"\\f"===f;)e=!0,u++,f=l.charAt(u);return e}function v(){var e=r();if(!e)return null;var t=e;for(f=l.charAt(u);","===f;){if(u++,g(),"selectors"!==t.type&&(t={type:"selectors",selectors:[e]}),!(e=r()))throw Error(\'Rule expected after ",".\');t.selectors.push(e)}return t}function r(){g();var e={type:"ruleSet"},t=o();if(!t)return null;for(var r=e;t&&(t.type="rule",r.rule=t,r=t,g(),f=l.charAt(u),!(p<=u||","===f||")"===f));)if(n[f]){var a=f;if(u++,g(),!(t=o()))throw Error(\'Rule expected after "\'+a+\'".\');t.nestingOperator=a}else(t=o())&&(t.nestingOperator=null);return e}function o(){for(var e=null;u<p;)if("*"===(f=l.charAt(u)))u++,(e=e||{}).tagName="*";else if(b.isIdentStart(f)||"\\\\"===f)(e=e||{}).tagName=h();else if("."===f)u++,((e=e||{}).classNames=e.classNames||[]).push(h());else if("#"===f)u++,(e=e||{}).id=h();else if("["===f){u++,g();var t={name:h()};if(g(),"]"===f)u++;else{var r="";if(c[f]&&(r=f,u++,f=l.charAt(u)),p<=u)throw Error(\'Expected "=" but end of file reached.\');if("="!==f)throw Error(\'Expected "=" but "\'+f+\'" found.\');t.operator=r+"=",u++,g();var a="";if(t.valueType="string",\'"\'===f)a=m(\'"\',b.doubleQuotesEscapeChars);else if("\'"===f)a=m("\'",b.singleQuoteEscapeChars);else if(d&&"$"===f)u++,a=h(),t.valueType="substitute";else{for(;u<p&&"]"!==f;)a+=f,u++,f=l.charAt(u);a=a.trim()}if(g(),p<=u)throw Error(\'Expected "]" but end of file reached.\');if("]"!==f)throw Error(\'Expected "]" but "\'+f+\'" found.\');u++,t.value=a}((e=e||{}).attrs=e.attrs||[]).push(t)}else{if(":"!==f)break;u++;var n=h(),o={name:n};if("("===f){u++;var i="";if(g(),"selector"===s[n])o.valueType="selector",i=v();else{if(o.valueType=s[n]||"string",\'"\'===f)i=m(\'"\',b.doubleQuotesEscapeChars);else if("\'"===f)i=m("\'",b.singleQuoteEscapeChars);else if(d&&"$"===f)u++,i=h(),o.valueType="substitute";else{for(;u<p&&")"!==f;)i+=f,u++,f=l.charAt(u);i=i.trim()}g()}if(p<=u)throw Error(\'Expected ")" but end of file reached.\');if(")"!==f)throw Error(\'Expected ")" but "\'+f+\'" found.\');u++,o.value=i}((e=e||{}).pseudos=e.pseudos||[]).push(o)}return e}return function(){var e=v();if(u<p)throw Error(\'Rule expected but "\'+l.charAt(u)+\'" found.\');return e}()}}),f=e(function(e){"use strict";Object.defineProperty(e,"__esModule",{value:!0});var o=d();e.renderEntity=function t(e){var r="";switch(e.type){case"ruleSet":for(var a=e.rule,n=[];a;)a.nestingOperator&&n.push(a.nestingOperator),n.push(t(a)),a=a.rule;r=n.join(" ");break;case"selectors":r=e.selectors.map(t).join(", ");break;case"rule":e.tagName&&(r="*"===e.tagName?"*":o.escapeIdentifier(e.tagName)),e.id&&(r+="#"+o.escapeIdentifier(e.id)),e.classNames&&(r+=e.classNames.map(function(e){return"."+o.escapeIdentifier(e)}).join("")),e.attrs&&(r+=e.attrs.map(function(e){return"operator"in e?"substitute"===e.valueType?"["+o.escapeIdentifier(e.name)+e.operator+"$"+e.value+"]":"["+o.escapeIdentifier(e.name)+e.operator+o.escapeStr(e.value)+"]":"["+o.escapeIdentifier(e.name)+"]"}).join("")),e.pseudos&&(r+=e.pseudos.map(function(e){return e.valueType?"selector"===e.valueType?":"+o.escapeIdentifier(e.name)+"("+t(e.value)+")":"substitute"===e.valueType?":"+o.escapeIdentifier(e.name)+"($"+e.value+")":"numeric"===e.valueType?":"+o.escapeIdentifier(e.name)+"("+e.value+")":":"+o.escapeIdentifier(e.name)+"("+o.escapeIdentifier(e.value)+")":":"+o.escapeIdentifier(e.name)}).join(""));break;default:throw Error(\'Unknown entity type: "\'+e.type+\'".\')}return r}}),m=e(function(e){"use strict";Object.defineProperty(e,"__esModule",{value:!0});var t=p(),r=f(),a=(n.prototype.registerSelectorPseudos=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];for(var r=0,a=e;r<a.length;r++){var n=a[r];this.pseudos[n]="selector"}return this},n.prototype.unregisterSelectorPseudos=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];for(var r=0,a=e;r<a.length;r++){var n=a[r];delete this.pseudos[n]}return this},n.prototype.registerNumericPseudos=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];for(var r=0,a=e;r<a.length;r++){var n=a[r];this.pseudos[n]="numeric"}return this},n.prototype.unregisterNumericPseudos=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];for(var r=0,a=e;r<a.length;r++){var n=a[r];delete this.pseudos[n]}return this},n.prototype.registerNestingOperators=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];for(var r=0,a=e;r<a.length;r++){var n=a[r];this.ruleNestingOperators[n]=!0}return this},n.prototype.unregisterNestingOperators=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];for(var r=0,a=e;r<a.length;r++){var n=a[r];delete this.ruleNestingOperators[n]}return this},n.prototype.registerAttrEqualityMods=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];for(var r=0,a=e;r<a.length;r++){var n=a[r];this.attrEqualityMods[n]=!0}return this},n.prototype.unregisterAttrEqualityMods=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];for(var r=0,a=e;r<a.length;r++){var n=a[r];delete this.attrEqualityMods[n]}return this},n.prototype.enableSubstitutes=function(){return this.substitutesEnabled=!0,this},n.prototype.disableSubstitutes=function(){return this.substitutesEnabled=!1,this},n.prototype.parse=function(e){return t.parseCssSelector(e,0,this.pseudos,this.attrEqualityMods,this.ruleNestingOperators,this.substitutesEnabled)},n.prototype.render=function(e){return r.renderEntity(e).trim()},n);function n(){this.pseudos={},this.attrEqualityMods={},this.ruleNestingOperators={},this.substitutesEnabled=!1}e.CssSelectorParser=a}),h=e(function(e,t){"use strict";t.exports=function(){}}),C=e(function(e,t){"use strict";var r=h()();t.exports=function(e){return e!==r&&null!==e}}),g=e(function(e,t){"use strict";var r=C(),a=Array.prototype.forEach,n=Object.create;t.exports=function(e){var t=n(null);return a.call(arguments,function(e){r(e)&&function(e,t){var r;for(r in e)t[r]=e[r]}(Object(e),t)}),t}}),v=e(function(e,t){"use strict";t.exports=function(){var e=Math.sign;return"function"==typeof e&&(1===e(10)&&-1===e(-20))}}),b=e(function(e,t){"use strict";t.exports=function(e){return e=Number(e),isNaN(e)||0===e?e:0<e?1:-1}}),y=e(function(e,t){"use strict";t.exports=v()()?Math.sign:b()}),D=e(function(e,t){"use strict";var r=y(),a=Math.abs,n=Math.floor;t.exports=function(e){return isNaN(e)?0:0!==(e=Number(e))&&isFinite(e)?r(e)*n(a(e)):e}}),F=e(function(e,t){"use strict";var r=D(),a=Math.max;t.exports=function(e){return a(0,r(e))}}),w=e(function(e,t){"use strict";var a=F();t.exports=function(e,t,r){return isNaN(e)?0<=t?r&&t?t-1:t:1:!1!==e&&a(e)}}),k=e(function(e,t){"use strict";t.exports=function(e){if("function"!=typeof e)throw new TypeError(e+" is not a function");return e}}),R=e(function(e,t){"use strict";var r=C();t.exports=function(e){if(!r(e))throw new TypeError("Cannot use null or undefined");return e}}),x=e(function(e,t){"use strict";var l=k(),u=R(),s=Function.prototype.bind,c=Function.prototype.call,d=Object.keys,p=Object.prototype.propertyIsEnumerable;t.exports=function(o,i){return function(r,a){var e,n=arguments[2],t=arguments[3];return r=Object(u(r)),l(a),e=d(r),t&&e.sort("function"==typeof t?s.call(t,r):void 0),"function"!=typeof o&&(o=e[o]),c.call(o,e,function(e,t){return p.call(r,e)?c.call(a,n,r[e],e,r,t):i})}}}),E=e(function(e,t){"use strict";t.exports=x()("forEach")}),A=e(function(){}),T=e(function(e,t){"use strict";t.exports=function(){var e,t=Object.assign;return"function"==typeof t&&(t(e={foo:"raz"},{bar:"dwa"},{trzy:"trzy"}),e.foo+e.bar+e.trzy==="razdwatrzy")}}),N=e(function(e,t){"use strict";t.exports=function(){try{return Object.keys("primitive"),!0}catch(e){return!1}}}),_=e(function(e,t){"use strict";var r=C(),a=Object.keys;t.exports=function(e){return a(r(e)?Object(e):e)}}),O=e(function(e,t){"use strict";t.exports=N()()?Object.keys:_()}),S=e(function(e,t){"use strict";var i=O(),l=R(),u=Math.max;t.exports=function(t,r){var a,e,n,o=u(arguments.length,2);for(t=Object(l(t)),n=function(e){try{t[e]=r[e]}catch(e){a=a||e}},e=1;e<o;++e)i(r=arguments[e]).forEach(n);if(void 0!==a)throw a;return t}}),P=e(function(e,t){"use strict";t.exports=T()()?Object.assign:S()}),I=e(function(e,t){"use strict";var r=C(),a={function:!0,object:!0};t.exports=function(e){return r(e)&&a[Gs(e)]||!1}}),B=e(function(e,n){"use strict";var o=P(),i=I(),l=C(),u=Error.captureStackTrace;n.exports=function(e){var t=new Error(e),r=arguments[1],a=arguments[2];return l(a)||i(r)&&(a=r,r=null),l(a)&&o(t,a),l(r)&&(t.code=r),u&&u(t,n.exports),t}}),L=e(function(e,t){"use strict";var n=R(),o=Object.defineProperty,i=Object.getOwnPropertyDescriptor,l=Object.getOwnPropertyNames,u=Object.getOwnPropertySymbols;t.exports=function(t,r){var a,e=Object(n(r));if(t=Object(n(t)),l(e).forEach(function(e){try{o(t,e,i(r,e))}catch(e){a=e}}),"function"==typeof u&&u(e).forEach(function(e){try{o(t,e,i(r,e))}catch(e){a=e}}),void 0!==a)throw a;return t}}),q=e(function(e,t){"use strict";function r(e,t){return t}var a,n,o,i,l,u=F();try{Object.defineProperty(r,"length",{configurable:!0,writable:!1,enumerable:!1,value:1})}catch(e){}1===r.length?(a={configurable:!0,writable:!1,enumerable:!1},n=Object.defineProperty,t.exports=function(e,t){return t=u(t),e.length===t?e:(a.value=t,n(e,"length",a))}):(i=L(),l=[],o=function(e){var t,r=0;if(l[e])return l[e];for(t=[];e--;)t.push("a"+(++r).toString(36));return new Function("fn","return function ("+t.join(", ")+") { return fn.apply(this, arguments); };")},t.exports=function(e,t){var r;if(t=u(t),e.length===t)return e;r=o(t)(e);try{i(r,e)}catch(e){}return r})}),j=e(function(e,t){"use strict";t.exports=function(e){return null!=e}}),M=e(function(e,t){"use strict";var r=j(),a={object:!0,function:!0,undefined:!0};t.exports=function(e){return!!r(e)&&hasOwnProperty.call(a,Gs(e))}}),U=e(function(e,t){"use strict";var r=M();t.exports=function(e){if(!r(e))return!1;try{return e.constructor?e.constructor.prototype===e:!1}catch(e){return!1}}}),V=e(function(e,t){"use strict";var r=U();t.exports=function(e){if("function"!=typeof e)return!1;if(!hasOwnProperty.call(e,"length"))return!1;try{if("number"!=typeof e.length)return!1;if("function"!=typeof e.call)return!1;if("function"!=typeof e.apply)return!1}catch(e){return!1}return!r(e)}}),H=e(function(e,t){"use strict";var r=V(),a=/^\\s*class[\\s{/}]/,n=Function.prototype.toString;t.exports=function(e){return!!r(e)&&!a.test(n.call(e))}}),z=e(function(e,t){"use strict";var r="razdwatrzy";t.exports=function(){return"function"==typeof r.contains&&(!0===r.contains("dwa")&&!1===r.contains("foo"))}}),$=e(function(e,t){"use strict";var r=String.prototype.indexOf;t.exports=function(e){return-1<r.call(this,e,arguments[1])}}),W=e(function(e,t){"use strict";t.exports=z()()?String.prototype.contains:$()}),G=e(function(e,t){"use strict";var l=j(),u=H(),s=P(),c=g(),d=W();(t.exports=function(e,t){var r,a,n,o,i;return arguments.length<2||"string"!=typeof e?(o=t,t=e,e=null):o=arguments[2],l(e)?(r=d.call(e,"c"),a=d.call(e,"e"),n=d.call(e,"w")):a=!(r=n=!0),i={value:t,configurable:r,enumerable:a,writable:n},o?s(c(o),i):i}).gs=function(e,t,r){var a,n,o,i;return"string"!=typeof e?(o=r,r=t,t=e,e=null):o=arguments[3],l(t)?u(t)?l(r)?u(r)||(o=r,r=void 0):r=void 0:(o=t,t=r=void 0):t=void 0,n=l(e)?(a=d.call(e,"c"),d.call(e,"e")):!(a=!0),i={get:t,set:r,configurable:a,enumerable:n},o?s(c(o),i):i}}),Y=e(function(e,t){"use strict";var r=G(),i=k(),u=Function.prototype.apply,s=Function.prototype.call,a=Object.create,n=Object.defineProperty,o=Object.defineProperties,c=Object.prototype.hasOwnProperty,l={configurable:!0,enumerable:!1,writable:!0},d=function(e,t){var r;return i(t),c.call(this,"__ee__")?r=this.__ee__:(r=l.value=a(null),n(this,"__ee__",l),l.value=null),r[e]?"object"===Gs(r[e])?r[e].push(t):r[e]=[r[e],t]:r[e]=t,this},p=function(e,t){var r,a;return i(t),d.call(a=this,e,r=function(){f.call(a,e,r),u.call(t,this,arguments)}),r.__eeOnceListener__=t,this},f=function(e,t){var r,a,n,o;if(i(t),!c.call(this,"__ee__"))return this;if(!(r=this.__ee__)[e])return this;if(a=r[e],"object"===Gs(a))for(o=0;n=a[o];++o)n!==t&&n.__eeOnceListener__!==t||(2===a.length?r[e]=a[o?0:1]:a.splice(o,1));else a!==t&&a.__eeOnceListener__!==t||delete r[e];return this},m=function(e,t,r){var a,n,o,i,l;if(c.call(this,"__ee__")&&(i=this.__ee__[e]))if("object"===Gs(i)){for(n=arguments.length,l=new Array(n-1),a=1;a<n;++a)l[a-1]=arguments[a];for(i=i.slice(),a=0;o=i[a];++a)u.call(o,this,l)}else switch(arguments.length){case 1:s.call(i,this);break;case 2:s.call(i,this,t);break;case 3:s.call(i,this,t,r);break;default:for(n=arguments.length,l=new Array(n-1),a=1;a<n;++a)l[a-1]=arguments[a];u.call(i,this,l)}},h={on:d,once:p,off:f,emit:m},g={on:r(d),once:r(p),off:r(f),emit:r(m)},v=o({},g);t.exports=e=function(e){return null==e?a(v):o(Object(e),g)},e.methods=h}),K=e(function(e,t){"use strict";t.exports=function(){var e,t,r=Array.from;return"function"==typeof r&&(t=r(e=["raz","dwa"]),Boolean(t&&t!==e&&"dwa"===t[1]))}}),X=e(function(e,t){"use strict";t.exports=function(){return"object"===("undefined"==typeof globalThis?"undefined":Gs(globalThis))&&(!!globalThis&&globalThis.Array===Array)}}),J=e(function(e,t){function r(){if("object"===("undefined"==typeof self?"undefined":Gs(self))&&self)return self;if("object"===(void 0===window?"undefined":Gs(window))&&window)return window;throw new Error("Unable to resolve global `this`")}t.exports=function(){if(this)return this;try{Object.defineProperty(Object.prototype,"__global__",{get:function(){return this},configurable:!0})}catch(e){return r()}try{return __global__?__global__:r()}finally{delete Object.prototype.__global__}}()}),Q=e(function(e,t){"use strict";t.exports=X()()?globalThis:J()}),Z=e(function(e,t){"use strict";var r=Q(),a={object:!0,symbol:!0};t.exports=function(){var e,t=r.Symbol;if("function"!=typeof t)return!1;e=t("test symbol");try{String(e)}catch(e){return!1}return!!a[Gs(t.iterator)]&&(!!a[Gs(t.toPrimitive)]&&!!a[Gs(t.toStringTag)])}}),ee=e(function(e,t){"use strict";t.exports=function(e){return!!e&&("symbol"===Gs(e)||!!e.constructor&&("Symbol"===e.constructor.name&&"Symbol"===e[e.constructor.toStringTag]))}}),te=e(function(e,t){"use strict";var r=ee();t.exports=function(e){if(!r(e))throw new TypeError(e+" is not a symbol");return e}}),re=e(function(e,t){"use strict";var n=G(),r=Object.create,o=Object.defineProperty,i=Object.prototype,l=r(null);t.exports=function(e){for(var t,r,a=0;l[e+(a||"")];)++a;return l[e+=a||""]=!0,o(i,t="@@"+e,n.gs(null,function(e){r||(r=!0,o(this,t,n(e)),r=!1)})),t}}),ae=e(function(e,t){"use strict";var r=G(),a=Q().Symbol;t.exports=function(e){return Object.defineProperties(e,{hasInstance:r("",a&&a.hasInstance||e("hasInstance")),isConcatSpreadable:r("",a&&a.isConcatSpreadable||e("isConcatSpreadable")),iterator:r("",a&&a.iterator||e("iterator")),match:r("",a&&a.match||e("match")),replace:r("",a&&a.replace||e("replace")),search:r("",a&&a.search||e("search")),species:r("",a&&a.species||e("species")),split:r("",a&&a.split||e("split")),toPrimitive:r("",a&&a.toPrimitive||e("toPrimitive")),toStringTag:r("",a&&a.toStringTag||e("toStringTag")),unscopables:r("",a&&a.unscopables||e("unscopables"))})}}),ne=e(function(e,t){"use strict";var r=G(),a=te(),n=Object.create(null);t.exports=function(t){return Object.defineProperties(t,{for:r(function(e){return n[e]?n[e]:n[e]=t(String(e))}),keyFor:r(function(e){var t;for(t in a(e),n)if(n[t]===e)return t})})}}),oe=e(function(e,t){"use strict";var r,a,n,o=G(),i=te(),l=Q().Symbol,u=re(),s=ae(),c=ne(),d=Object.create,p=Object.defineProperties,f=Object.defineProperty;if("function"==typeof l)try{String(l()),n=!0}catch(e){}else l=null;a=function(e){if(this instanceof a)throw new TypeError("Symbol is not a constructor");return r(e)},t.exports=r=function e(t){var r;if(this instanceof e)throw new TypeError("Symbol is not a constructor");return n?l(t):(r=d(a.prototype),t=void 0===t?"":String(t),p(r,{__description__:o("",t),__name__:o("",u(t))}))},s(r),c(r),p(a.prototype,{constructor:o(r),toString:o("",function(){return this.__name__})}),p(r.prototype,{toString:o(function(){return"Symbol ("+i(this).__description__+")"}),valueOf:o(function(){return i(this)})}),f(r.prototype,r.toPrimitive,o("",function(){var e=i(this);return"symbol"===Gs(e)?e:e.toString()})),f(r.prototype,r.toStringTag,o("c","Symbol")),f(a.prototype,r.toStringTag,o("c",r.prototype[r.toStringTag])),f(a.prototype,r.toPrimitive,o("c",r.prototype[r.toPrimitive]))}),ie=e(function(e,t){"use strict";t.exports=Z()()?Q().Symbol:oe()}),le=e(function(e,t){"use strict";var r=Object.prototype.toString,a=r.call(function(){return arguments}());t.exports=function(e){return r.call(e)===a}}),ue=e(function(e,t){"use strict";var r=Object.prototype.toString,a=RegExp.prototype.test.bind(/^[object [A-Za-z0-9]*Function]$/);t.exports=function(e){return"function"==typeof e&&a(r.call(e))}}),se=e(function(e,t){"use strict";var r=Object.prototype.toString,a=r.call("");t.exports=function(e){return"string"==typeof e||e&&"object"===Gs(e)&&(e instanceof String||r.call(e)===a)||!1}}),ce=e(function(e,t){"use strict";var f=ie().iterator,m=le(),h=ue(),g=F(),v=k(),b=R(),y=C(),D=se(),w=Array.isArray,x=Function.prototype.call,E={configurable:!0,enumerable:!0,writable:!0,value:null},A=Object.defineProperty;t.exports=function(e){var t,r,a,n,o,i,l,u,s,c,d=arguments[1],p=arguments[2];if(e=Object(b(e)),y(d)&&v(d),this&&this!==Array&&h(this))t=this;else{if(!d){if(m(e))return 1!==(o=e.length)?Array.apply(null,e):((n=new Array(1))[0]=e[0],n);if(w(e)){for(n=new Array(o=e.length),r=0;r<o;++r)n[r]=e[r];return n}}n=[]}if(!w(e))if(void 0!==(s=e[f])){for(l=v(s).call(e),t&&(n=new t),u=l.next(),r=0;!u.done;)c=d?x.call(d,p,u.value,r):u.value,t?(E.value=c,A(n,r,E)):n[r]=c,u=l.next(),++r;o=r}else if(D(e)){for(o=e.length,t&&(n=new t),a=r=0;r<o;++r)c=e[r],r+1<o&&55296<=(i=c.charCodeAt(0))&&i<=56319&&(c+=e[++r]),c=d?x.call(d,p,c,a):c,t?(E.value=c,A(n,a,E)):n[a]=c,++a;o=a}if(void 0===o)for(o=g(e.length),t&&(n=new t(o)),r=0;r<o;++r)c=d?x.call(d,p,e[r],r):e[r],t?(E.value=c,A(n,r,E)):n[r]=c;return t&&(E.value=null,n.length=o),n}}),de=e(function(e,t){"use strict";t.exports=K()()?Array.from:ce()}),pe=e(function(e,t){"use strict";var r=de(),a=Array.isArray;t.exports=function(e){return a(e)?e:r(e)}}),fe=e(function(e,t){"use strict";var r=pe(),a=C(),n=k(),o=Array.prototype.slice,i=function(r){return this.map(function(e,t){return e?e(r[t]):r[t]}).concat(o.call(r,this.length))};t.exports=function(e){return(e=r(e)).forEach(function(e){a(e)&&n(e)}),i.bind(e)}}),me=e(function(e,t){"use strict";var r=k();t.exports=function(e){var t;return"function"==typeof e?{set:e,get:e}:(t={get:r(e.get)},void 0!==e.set?(t.set=r(e.set),e.delete&&(t.delete=r(e.delete)),e.clear&&(t.clear=r(e.clear))):t.set=t.get,t)}}),he=e(function(e,t){"use strict";var y=B(),D=q(),w=G(),r=Y().methods,x=fe(),E=me(),A=Function.prototype.apply,C=Function.prototype.call,F=Object.create,k=Object.defineProperties,R=r.on,T=r.emit;t.exports=function(n,r,e){var o,i,l,a,t,u,s,c,d,p,f,m,h,g,v=F(null),b=!1!==r?r:isNaN(n.length)?1:n.length;return e.normalizer&&(d=E(e.normalizer),i=d.get,l=d.set,a=d.delete,t=d.clear),null!=e.resolvers&&(g=x(e.resolvers)),h=i?D(function(e){var t,r,a=arguments;if(g&&(a=g(a)),null!==(t=i(a))&&hasOwnProperty.call(v,t))return p&&o.emit("get",t,a,this),v[t];if(r=1===a.length?C.call(n,this,a[0]):A.call(n,this,a),null===t){if(null!==(t=i(a)))throw y("Circular invocation","CIRCULAR_INVOCATION");t=l(a)}else if(hasOwnProperty.call(v,t))throw y("Circular invocation","CIRCULAR_INVOCATION");return v[t]=r,f&&o.emit("set",t,null,r),r},b):0===r?function(){var e;if(hasOwnProperty.call(v,"data"))return p&&o.emit("get","data",arguments,this),v.data;if(e=arguments.length?A.call(n,this,arguments):C.call(n,this),hasOwnProperty.call(v,"data"))throw y("Circular invocation","CIRCULAR_INVOCATION");return v.data=e,f&&o.emit("set","data",null,e),e}:function(e){var t,r,a=arguments;if(g&&(a=g(arguments)),r=String(a[0]),hasOwnProperty.call(v,r))return p&&o.emit("get",r,a,this),v[r];if(t=1===a.length?C.call(n,this,a[0]):A.call(n,this,a),hasOwnProperty.call(v,r))throw y("Circular invocation","CIRCULAR_INVOCATION");return v[r]=t,f&&o.emit("set",r,null,t),t},o={original:n,memoized:h,profileName:e.profileName,get:function(e){return g&&(e=g(e)),i?i(e):String(e[0])},has:function(e){return hasOwnProperty.call(v,e)},delete:function(e){var t;hasOwnProperty.call(v,e)&&(a&&a(e),t=v[e],delete v[e],m&&o.emit("delete",e,t))},clear:function(){var e=v;t&&t(),v=F(null),o.emit("clear",e)},on:function(e,t){return"get"===e?p=!0:"set"===e?f=!0:"delete"===e&&(m=!0),R.call(this,e,t)},emit:T,updateEnv:function(){n=o.original}},u=i?D(function(e){var t,r=arguments;g&&(r=g(r)),null!==(t=i(r))&&o.delete(t)},b):0===r?function(){return o.delete("data")}:function(e){return g&&(e=g(arguments)[0]),o.delete(e)},s=D(function(){var e,t=arguments;return 0===r?v.data:(g&&(t=g(t)),e=i?i(t):String(t[0]),v[e])}),c=D(function(){var e,t=arguments;return 0===r?o.has("data"):(g&&(t=g(t)),null!==(e=i?i(t):String(t[0]))&&o.has(e))}),k(h,{__memoized__:w(!0),delete:w(u),clear:w(o.clear),_get:w(s),_has:w(c)}),o}}),ge=e(function(e,t){"use strict";var o=k(),i=E(),l=A(),u=he(),s=w();t.exports=function e(t){var r,a,n;if(o(t),(r=Object(arguments[1])).async&&r.promise)throw new Error("Options \'async\' and \'promise\' cannot be used together");return hasOwnProperty.call(t,"__memoized__")&&!r.force?t:(a=s(r.length,t.length,r.async&&l.async),n=u(t,a,r),i(l,function(e,t){r[t]&&e(r[t],n,r)}),e.__profiler__&&e.__profiler__(n),n.updateEnv(),n.memoized)}}),ve=e(function(e,t){"use strict";t.exports=function(e){var t,r,a=e.length;if(!a)return"";for(t=String(e[r=0]);--a;)t+=""+e[++r];return t}}),be=e(function(e,t){"use strict";t.exports=function(n){return n?function(e){for(var t=String(e[0]),r=0,a=n;--a;)t+=""+e[++r];return t}:function(){return""}}}),ye=e(function(e,t){"use strict";t.exports=function(){var e=Number.isNaN;return"function"==typeof e&&(!e({})&&e(NaN)&&!e(34))}}),De=e(function(e,t){"use strict";t.exports=function(e){return e!=e}}),we=e(function(e,t){"use strict";t.exports=ye()()?Number.isNaN:De()}),xe=e(function(e,t){"use strict";var o=we(),i=F(),l=R(),u=Array.prototype.indexOf,s=Object.prototype.hasOwnProperty,c=Math.abs,d=Math.floor;t.exports=function(e){var t,r,a,n;if(!o(e))return u.apply(this,arguments);for(r=i(l(this).length),a=arguments[1],t=a=isNaN(a)?0:0<=a?d(a):i(this.length)-d(c(a));t<r;++t)if(s.call(this,t)&&(n=this[t],o(n)))return t;return-1}}),Ee=e(function(e,t){"use strict";var s=xe(),r=Object.create;t.exports=function(){var o=0,l=[],u=r(null);return{get:function(e){var t,r=0,a=l,n=e.length;if(0===n)return a[n]||null;if(a=a[n]){for(;r<n-1;){if(-1===(t=s.call(a[0],e[r])))return null;a=a[1][t],++r}return-1!==(t=s.call(a[0],e[r]))&&a[1][t]||null}return null},set:function(e){var t,r=0,a=l,n=e.length;if(0===n)a[n]=++o;else{for(a[n]||(a[n]=[[],[]]),a=a[n];r<n-1;)-1===(t=s.call(a[0],e[r]))&&(t=a[0].push(e[r])-1,a[1].push([[],[]])),a=a[1][t],++r;-1===(t=s.call(a[0],e[r]))&&(t=a[0].push(e[r])-1),a[1][t]=++o}return u[o]=e,o},delete:function(e){var t,r=0,a=l,n=u[e],o=n.length,i=[];if(0===o)delete a[o];else if(a=a[o]){for(;r<o-1;){if(-1===(t=s.call(a[0],n[r])))return;i.push(a,t),a=a[1][t],++r}if(-1===(t=s.call(a[0],n[r])))return;for(e=a[1][t],a[0].splice(t,1),a[1].splice(t,1);!a[0].length&&i.length;)t=i.pop(),(a=i.pop())[0].splice(t,1),a[1].splice(t,1)}delete u[e]},clear:function(){l=[],u=r(null)}}}}),Ae=e(function(e,t){"use strict";var n=xe();t.exports=function(){var t=0,r=[],a=[];return{get:function(e){var t=n.call(r,e[0]);return-1===t?null:a[t]},set:function(e){return r.push(e[0]),a.push(++t),t},delete:function(e){var t=n.call(a,e);-1!==t&&(r.splice(t,1),a.splice(t,1))},clear:function(){r=[],a=[]}}}}),Ce=e(function(e,t){"use strict";var s=xe(),r=Object.create;t.exports=function(i){var n=0,l=[[],[]],u=r(null);return{get:function(e){for(var t,r=0,a=l;r<i-1;){if(-1===(t=s.call(a[0],e[r])))return null;a=a[1][t],++r}return-1!==(t=s.call(a[0],e[r]))&&a[1][t]||null},set:function(e){for(var t,r=0,a=l;r<i-1;)-1===(t=s.call(a[0],e[r]))&&(t=a[0].push(e[r])-1,a[1].push([[],[]])),a=a[1][t],++r;return-1===(t=s.call(a[0],e[r]))&&(t=a[0].push(e[r])-1),a[1][t]=++n,u[n]=e,n},delete:function(e){for(var t,r=0,a=l,n=[],o=u[e];r<i-1;){if(-1===(t=s.call(a[0],o[r])))return;n.push(a,t),a=a[1][t],++r}if(-1!==(t=s.call(a[0],o[r]))){for(e=a[1][t],a[0].splice(t,1),a[1].splice(t,1);!a[0].length&&n.length;)t=n.pop(),(a=n.pop())[0].splice(t,1),a[1].splice(t,1);delete u[e]}},clear:function(){l=[[],[]],u=r(null)}}}}),Fe=e(function(e,t){"use strict";var r=k(),a=E(),l=Function.prototype.call;t.exports=function(e,n){var o={},i=arguments[2];return r(n),a(e,function(e,t,r,a){o[t]=l.call(n,i,e,t,r,a)}),o}}),ke=e(function(e,t){"use strict";var o=function(e){if("function"!=typeof e)throw new TypeError(e+" is not a function");return e},r=function(e){var t,r,a=document.createTextNode(""),n=0;return new e(function(){var e;if(t)r&&(t=r.concat(t));else{if(!r)return;t=r}if(r=t,t=null,"function"==typeof r)return e=r,r=null,void e();for(a.data=n=++n%2;r;)e=r.shift(),r.length||(r=null),e()}).observe(a,{characterData:!0}),function(e){o(e),t?"function"==typeof t?t=[t,e]:t.push(e):(t=e,a.data=n=++n%2)}};t.exports=function(){if("object"===("undefined"==typeof process?"undefined":Gs(process))&&process&&"function"==typeof process.nextTick)return process.nextTick;if("object"===(void 0===document?"undefined":Gs(document))&&document){if("function"==typeof MutationObserver)return r(MutationObserver);if("function"==typeof WebKitMutationObserver)return r(WebKitMutationObserver)}return"function"==typeof setImmediate?function(e){setImmediate(o(e))}:"function"==typeof setTimeout||"object"===("undefined"==typeof setTimeout?"undefined":Gs(setTimeout))?function(e){setTimeout(o(e),0)}:null}()}),Re=e(function(){"use strict";var p=de(),t=Fe(),r=L(),n=q(),f=ke(),m=Array.prototype.slice,h=Function.prototype.apply,g=Object.create;A().async=function(e,i){var l,u,s,c=g(null),d=g(null),o=i.memoized,a=i.original;i.memoized=n(function(e){var t=arguments,r=t[t.length-1];return"function"==typeof r&&(l=r,t=m.call(t,0,-1)),o.apply(u=this,s=t)},o);try{r(i.memoized,o)}catch(e){}i.on("get",function(t){var r,a,n;if(l){if(c[t])return"function"==typeof c[t]?c[t]=[c[t],l]:c[t].push(l),void(l=null);r=l,a=u,n=s,l=u=s=null,f(function(){var e;hasOwnProperty.call(d,t)?(e=d[t],i.emit("getasync",t,n,a),h.call(r,e.context,e.args)):(l=r,u=a,s=n,o.apply(a,n))})}}),i.original=function(){var e,t,r,o;return l?(e=p(arguments),t=function e(t){var r,a,n=e.id;if(null!=n){if(delete e.id,r=c[n],delete c[n],r)return a=p(arguments),i.has(n)&&(t?i.delete(n):(d[n]={context:this,args:a},i.emit("setasync",n,"function"==typeof r?1:r.length))),"function"==typeof r?o=h.call(r,this,a):r.forEach(function(e){o=h.call(e,this,a)},this),o}else f(h.bind(e,this,arguments))},r=l,l=u=s=null,e.push(t),o=h.call(a,this,e),t.cb=r,l=t,o):h.call(a,this,arguments)},i.on("set",function(e){l?(c[e]?"function"==typeof c[e]?c[e]=[c[e],l.cb]:c[e].push(l.cb):c[e]=l.cb,delete l.cb,l.id=e,l=null):i.delete(e)}),i.on("delete",function(e){var t;hasOwnProperty.call(c,e)||d[e]&&(t=d[e],delete d[e],i.emit("deleteasync",e,m.call(t.args,1)))}),i.on("clear",function(){var e=d;d=g(null),i.emit("clearasync",t(e,function(e){return m.call(e.args,1)}))})}}),Te=e(function(e,t){"use strict";var r=Array.prototype.forEach,a=Object.create;t.exports=function(e){var t=a(null);return r.call(arguments,function(e){t[e]=!0}),t}}),Ne=e(function(e,t){"use strict";t.exports=function(e){return"function"==typeof e}}),_e=e(function(e,t){"use strict";var r=Ne();t.exports=function(e){try{return e&&r(e.toString)?e.toString():String(e)}catch(e){throw new TypeError("Passed argument cannot be stringifed")}}}),Oe=e(function(e,t){"use strict";var r=R(),a=_e();t.exports=function(e){return a(r(e))}}),Se=e(function(e,t){"use strict";var r=Ne();t.exports=function(e){try{return e&&r(e.toString)?e.toString():String(e)}catch(e){return"<Non-coercible to string value>"}}}),Pe=e(function(e,t){"use strict";var r=Se(),a=/[\\n\\r\\u2028\\u2029]/g;t.exports=function(e){var t=r(e);return 100<t.length&&(t=t.slice(0,99)+"…"),t=t.replace(a,function(e){return JSON.stringify(e).slice(1,-1)})}}),Ie=e(function(e,t){function r(e){return!!e&&("object"===Gs(e)||"function"==typeof e)&&"function"==typeof e.then}t.exports=r,t.exports.default=r}),Be=e(function(){"use strict";var t=Fe(),e=Te(),r=Oe(),a=Pe(),f=Ie(),m=ke(),n=Object.create,o=e("then","then:finally","done","done:finally");A().promise=function(u,s){var c=n(null),d=n(null),p=n(null);if(!0===u)u=null;else if(u=r(u),!o[u])throw new TypeError("\'"+a(u)+"\' is not valid promise mode");s.on("set",function(r,e,t){var a=!1;if(!f(t))return d[r]=t,void s.emit("setasync",r,1);c[r]=1,p[r]=t;function n(e){var t=c[r];if(a)throw new Error("Memoizee error: Detected unordered then|done & finally resolution, which in turn makes proper detection of success/failure impossible (when in \'done:finally\' mode)\\nConsider to rely on \'then\' or \'done\' mode instead.");t&&(delete c[r],d[r]=e,s.emit("setasync",r,t))}function o(){a=!0,c[r]&&(delete c[r],delete p[r],s.delete(r))}var i=u;if("then"===(i=i||"then")){var l=function(){m(o)};"function"==typeof(t=t.then(function(e){m(n.bind(this,e))},l)).finally&&t.finally(l)}else if("done"===i){if("function"!=typeof t.done)throw new Error("Memoizee error: Retrieved promise does not implement \'done\' in \'done\' mode");t.done(n,o)}else if("done:finally"===i){if("function"!=typeof t.done)throw new Error("Memoizee error: Retrieved promise does not implement \'done\' in \'done:finally\' mode");if("function"!=typeof t.finally)throw new Error("Memoizee error: Retrieved promise does not implement \'finally\' in \'done:finally\' mode");t.done(n),t.finally(o)}}),s.on("get",function(e,t,r){var a,n;c[e]?++c[e]:(a=p[e],n=function(){s.emit("getasync",e,t,r)},f(a)?"function"==typeof a.done?a.done(n):a.then(function(){m(n)}):n())}),s.on("delete",function(e){var t;delete p[e],c[e]?delete c[e]:hasOwnProperty.call(d,e)&&(t=d[e],delete d[e],s.emit("deleteasync",e,[t]))}),s.on("clear",function(){var e=d;d=n(null),c=n(null),p=n(null),s.emit("clearasync",t(e,function(e){return[e]}))})}}),Le=e(function(){"use strict";var n=k(),o=E(),i=A(),l=Function.prototype.apply;i.dispose=function(r,e,t){var a;if(n(r),t.async&&i.async||t.promise&&i.promise)return e.on("deleteasync",a=function(e,t){l.call(r,null,t)}),void e.on("clearasync",function(e){o(e,function(e,t){a(t,e)})});e.on("delete",a=function(e,t){r(t)}),e.on("clear",function(e){o(e,function(e,t){a(t,e)})})}}),qe=e(function(e,t){"use strict";t.exports=2147483647}),je=e(function(e,t){"use strict";var r=F(),a=qe();t.exports=function(e){if(e=r(e),a<e)throw new TypeError(e+" exceeds maximum possible timeout");return e}}),Me=e(function(){"use strict";var l=de(),u=E(),s=ke(),c=Ie(),d=je(),p=A(),f=Function.prototype,m=Math.max,h=Math.min,g=Object.create;p.maxAge=function(t,n,o){var r,e,a,i;(t=d(t))&&(r=g(null),e=o.async&&p.async||o.promise&&p.promise?"async":"",n.on("set"+e,function(e){r[e]=setTimeout(function(){n.delete(e)},t),"function"==typeof r[e].unref&&r[e].unref(),i&&(i[e]&&"nextTick"!==i[e]&&clearTimeout(i[e]),i[e]=setTimeout(function(){delete i[e]},a),"function"==typeof i[e].unref&&i[e].unref())}),n.on("delete"+e,function(e){clearTimeout(r[e]),delete r[e],i&&("nextTick"!==i[e]&&clearTimeout(i[e]),delete i[e])}),o.preFetch&&(a=!0===o.preFetch||isNaN(o.preFetch)?.333:m(h(Number(o.preFetch),1),0))&&(i={},a=(1-a)*t,n.on("get"+e,function(t,r,a){i[t]||(i[t]="nextTick",s(function(){var e;"nextTick"===i[t]&&(delete i[t],n.delete(t),o.async&&(r=l(r)).push(f),e=n.memoized.apply(a,r),o.promise&&c(e)&&("function"==typeof e.done?e.done(f,f):e.then(f,f)))}))})),n.on("clear"+e,function(){u(r,function(e){clearTimeout(e)}),r={},i&&(u(i,function(e){"nextTick"!==e&&clearTimeout(e)}),i={})}))}}),Ue=e(function(e,t){"use strict";var r=F(),c=Object.create,d=Object.prototype.hasOwnProperty;t.exports=function(a){var n,o=0,i=1,l=c(null),u=c(null),s=0;return a=r(a),{hit:function(e){var t=u[e],r=++s;if(l[r]=e,u[e]=r,!t){if(++o<=a)return;return e=l[i],n(e),e}if(delete l[t],i===t)for(;!d.call(l,++i););},delete:n=function(e){var t=u[e];if(t&&(delete l[t],delete u[e],--o,i===t)){if(!o)return s=0,void(i=1);for(;!d.call(l,++i););}},clear:function(){o=0,i=1,l=c(null),u=c(null),s=0}}}}),Ve=e(function(){"use strict";var i=F(),l=Ue(),u=A();u.max=function(e,t,r){var a,n,o;(e=i(e))&&(n=l(e),a=r.async&&u.async||r.promise&&u.promise?"async":"",t.on("set"+a,o=function(e){void 0!==(e=n.hit(e))&&t.delete(e)}),t.on("get"+a,o),t.on("delete"+a,n.delete),t.on("clear"+a,n.clear))}}),He=e(function(){"use strict";var o=G(),i=A(),l=Object.create,u=Object.defineProperties;i.refCounter=function(e,t,r){var a=l(null),n=r.async&&i.async||r.promise&&i.promise?"async":"";t.on("set"+n,function(e,t){a[e]=t||1}),t.on("get"+n,function(e){++a[e]}),t.on("delete"+n,function(e){delete a[e]}),t.on("clear"+n,function(){a={}}),u(t.memoized,{deleteRef:o(function(){var e=t.get(arguments);return null!==e&&a[e]?!--a[e]&&(t.delete(e),!0):null}),getRefCount:o(function(){var e=t.get(arguments);return null!==e&&a[e]?a[e]:0})})}}),ze=e(function(e,t){"use strict";var a=g(),n=w(),o=ge();t.exports=function(e){var t,r=a(arguments[1]);return r.normalizer||0!==(t=r.length=n(r.length,e.length,r.async))&&(r.primitive?!1===t?r.normalizer=ve():1<t&&(r.normalizer=be()(t)):r.normalizer=!1===t?Ee()():1===t?Ae()():Ce()(t)),r.async&&Re(),r.promise&&Be(),r.dispose&&Le(),r.maxAge&&Me(),r.max&&Ve(),r.refCounter&&He(),o(e,r)}}),$e=e(function(e,t){"use strict";t.exports=function(){return/\\uD83C\\uDFF4\\uDB40\\uDC67\\uDB40\\uDC62(?:\\uDB40\\uDC65\\uDB40\\uDC6E\\uDB40\\uDC67|\\uDB40\\uDC73\\uDB40\\uDC63\\uDB40\\uDC74|\\uDB40\\uDC77\\uDB40\\uDC6C\\uDB40\\uDC73)\\uDB40\\uDC7F|\\uD83D\\uDC68(?:\\uD83C\\uDFFC\\u200D(?:\\uD83E\\uDD1D\\u200D\\uD83D\\uDC68\\uD83C\\uDFFB|\\uD83C[\\uDF3E\\uDF73\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD])|\\uD83C\\uDFFF\\u200D(?:\\uD83E\\uDD1D\\u200D\\uD83D\\uDC68(?:\\uD83C[\\uDFFB-\\uDFFE])|\\uD83C[\\uDF3E\\uDF73\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD])|\\uD83C\\uDFFE\\u200D(?:\\uD83E\\uDD1D\\u200D\\uD83D\\uDC68(?:\\uD83C[\\uDFFB-\\uDFFD])|\\uD83C[\\uDF3E\\uDF73\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD])|\\uD83C\\uDFFD\\u200D(?:\\uD83E\\uDD1D\\u200D\\uD83D\\uDC68(?:\\uD83C[\\uDFFB\\uDFFC])|\\uD83C[\\uDF3E\\uDF73\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD])|\\u200D(?:\\u2764\\uFE0F\\u200D(?:\\uD83D\\uDC8B\\u200D)?\\uD83D\\uDC68|(?:\\uD83D[\\uDC68\\uDC69])\\u200D(?:\\uD83D\\uDC66\\u200D\\uD83D\\uDC66|\\uD83D\\uDC67\\u200D(?:\\uD83D[\\uDC66\\uDC67]))|\\uD83D\\uDC66\\u200D\\uD83D\\uDC66|\\uD83D\\uDC67\\u200D(?:\\uD83D[\\uDC66\\uDC67])|(?:\\uD83D[\\uDC68\\uDC69])\\u200D(?:\\uD83D[\\uDC66\\uDC67])|[\\u2695\\u2696\\u2708]\\uFE0F|\\uD83D[\\uDC66\\uDC67]|\\uD83C[\\uDF3E\\uDF73\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD])|(?:\\uD83C\\uDFFB\\u200D[\\u2695\\u2696\\u2708]|\\uD83C\\uDFFF\\u200D[\\u2695\\u2696\\u2708]|\\uD83C\\uDFFE\\u200D[\\u2695\\u2696\\u2708]|\\uD83C\\uDFFD\\u200D[\\u2695\\u2696\\u2708]|\\uD83C\\uDFFC\\u200D[\\u2695\\u2696\\u2708])\\uFE0F|\\uD83C\\uDFFB\\u200D(?:\\uD83C[\\uDF3E\\uDF73\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD])|\\uD83C[\\uDFFB-\\uDFFF])|(?:\\uD83E\\uDDD1\\uD83C\\uDFFB\\u200D\\uD83E\\uDD1D\\u200D\\uD83E\\uDDD1|\\uD83D\\uDC69\\uD83C\\uDFFC\\u200D\\uD83E\\uDD1D\\u200D\\uD83D\\uDC69)\\uD83C\\uDFFB|\\uD83E\\uDDD1(?:\\uD83C\\uDFFF\\u200D\\uD83E\\uDD1D\\u200D\\uD83E\\uDDD1(?:\\uD83C[\\uDFFB-\\uDFFF])|\\u200D\\uD83E\\uDD1D\\u200D\\uD83E\\uDDD1)|(?:\\uD83E\\uDDD1\\uD83C\\uDFFE\\u200D\\uD83E\\uDD1D\\u200D\\uD83E\\uDDD1|\\uD83D\\uDC69\\uD83C\\uDFFF\\u200D\\uD83E\\uDD1D\\u200D(?:\\uD83D[\\uDC68\\uDC69]))(?:\\uD83C[\\uDFFB-\\uDFFE])|(?:\\uD83E\\uDDD1\\uD83C\\uDFFC\\u200D\\uD83E\\uDD1D\\u200D\\uD83E\\uDDD1|\\uD83D\\uDC69\\uD83C\\uDFFD\\u200D\\uD83E\\uDD1D\\u200D\\uD83D\\uDC69)(?:\\uD83C[\\uDFFB\\uDFFC])|\\uD83D\\uDC69(?:\\uD83C\\uDFFE\\u200D(?:\\uD83E\\uDD1D\\u200D\\uD83D\\uDC68(?:\\uD83C[\\uDFFB-\\uDFFD\\uDFFF])|\\uD83C[\\uDF3E\\uDF73\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD])|\\uD83C\\uDFFC\\u200D(?:\\uD83E\\uDD1D\\u200D\\uD83D\\uDC68(?:\\uD83C[\\uDFFB\\uDFFD-\\uDFFF])|\\uD83C[\\uDF3E\\uDF73\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD])|\\uD83C\\uDFFB\\u200D(?:\\uD83E\\uDD1D\\u200D\\uD83D\\uDC68(?:\\uD83C[\\uDFFC-\\uDFFF])|\\uD83C[\\uDF3E\\uDF73\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD])|\\uD83C\\uDFFD\\u200D(?:\\uD83E\\uDD1D\\u200D\\uD83D\\uDC68(?:\\uD83C[\\uDFFB\\uDFFC\\uDFFE\\uDFFF])|\\uD83C[\\uDF3E\\uDF73\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD])|\\u200D(?:\\u2764\\uFE0F\\u200D(?:\\uD83D\\uDC8B\\u200D(?:\\uD83D[\\uDC68\\uDC69])|\\uD83D[\\uDC68\\uDC69])|\\uD83C[\\uDF3E\\uDF73\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD])|\\uD83C\\uDFFF\\u200D(?:\\uD83C[\\uDF3E\\uDF73\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]))|\\uD83D\\uDC69\\u200D\\uD83D\\uDC69\\u200D(?:\\uD83D\\uDC66\\u200D\\uD83D\\uDC66|\\uD83D\\uDC67\\u200D(?:\\uD83D[\\uDC66\\uDC67]))|(?:\\uD83E\\uDDD1\\uD83C\\uDFFD\\u200D\\uD83E\\uDD1D\\u200D\\uD83E\\uDDD1|\\uD83D\\uDC69\\uD83C\\uDFFE\\u200D\\uD83E\\uDD1D\\u200D\\uD83D\\uDC69)(?:\\uD83C[\\uDFFB-\\uDFFD])|\\uD83D\\uDC69\\u200D\\uD83D\\uDC66\\u200D\\uD83D\\uDC66|\\uD83D\\uDC69\\u200D\\uD83D\\uDC69\\u200D(?:\\uD83D[\\uDC66\\uDC67])|(?:\\uD83D\\uDC41\\uFE0F\\u200D\\uD83D\\uDDE8|\\uD83D\\uDC69(?:\\uD83C\\uDFFF\\u200D[\\u2695\\u2696\\u2708]|\\uD83C\\uDFFE\\u200D[\\u2695\\u2696\\u2708]|\\uD83C\\uDFFC\\u200D[\\u2695\\u2696\\u2708]|\\uD83C\\uDFFB\\u200D[\\u2695\\u2696\\u2708]|\\uD83C\\uDFFD\\u200D[\\u2695\\u2696\\u2708]|\\u200D[\\u2695\\u2696\\u2708])|(?:(?:\\u26F9|\\uD83C[\\uDFCB\\uDFCC]|\\uD83D\\uDD75)\\uFE0F|\\uD83D\\uDC6F|\\uD83E[\\uDD3C\\uDDDE\\uDDDF])\\u200D[\\u2640\\u2642]|(?:\\u26F9|\\uD83C[\\uDFCB\\uDFCC]|\\uD83D\\uDD75)(?:\\uD83C[\\uDFFB-\\uDFFF])\\u200D[\\u2640\\u2642]|(?:\\uD83C[\\uDFC3\\uDFC4\\uDFCA]|\\uD83D[\\uDC6E\\uDC71\\uDC73\\uDC77\\uDC81\\uDC82\\uDC86\\uDC87\\uDE45-\\uDE47\\uDE4B\\uDE4D\\uDE4E\\uDEA3\\uDEB4-\\uDEB6]|\\uD83E[\\uDD26\\uDD37-\\uDD39\\uDD3D\\uDD3E\\uDDB8\\uDDB9\\uDDCD-\\uDDCF\\uDDD6-\\uDDDD])(?:(?:\\uD83C[\\uDFFB-\\uDFFF])\\u200D[\\u2640\\u2642]|\\u200D[\\u2640\\u2642])|\\uD83C\\uDFF4\\u200D\\u2620)\\uFE0F|\\uD83D\\uDC69\\u200D\\uD83D\\uDC67\\u200D(?:\\uD83D[\\uDC66\\uDC67])|\\uD83C\\uDFF3\\uFE0F\\u200D\\uD83C\\uDF08|\\uD83D\\uDC15\\u200D\\uD83E\\uDDBA|\\uD83D\\uDC69\\u200D\\uD83D\\uDC66|\\uD83D\\uDC69\\u200D\\uD83D\\uDC67|\\uD83C\\uDDFD\\uD83C\\uDDF0|\\uD83C\\uDDF4\\uD83C\\uDDF2|\\uD83C\\uDDF6\\uD83C\\uDDE6|[#\\*0-9]\\uFE0F\\u20E3|\\uD83C\\uDDE7(?:\\uD83C[\\uDDE6\\uDDE7\\uDDE9-\\uDDEF\\uDDF1-\\uDDF4\\uDDF6-\\uDDF9\\uDDFB\\uDDFC\\uDDFE\\uDDFF])|\\uD83C\\uDDF9(?:\\uD83C[\\uDDE6\\uDDE8\\uDDE9\\uDDEB-\\uDDED\\uDDEF-\\uDDF4\\uDDF7\\uDDF9\\uDDFB\\uDDFC\\uDDFF])|\\uD83C\\uDDEA(?:\\uD83C[\\uDDE6\\uDDE8\\uDDEA\\uDDEC\\uDDED\\uDDF7-\\uDDFA])|\\uD83E\\uDDD1(?:\\uD83C[\\uDFFB-\\uDFFF])|\\uD83C\\uDDF7(?:\\uD83C[\\uDDEA\\uDDF4\\uDDF8\\uDDFA\\uDDFC])|\\uD83D\\uDC69(?:\\uD83C[\\uDFFB-\\uDFFF])|\\uD83C\\uDDF2(?:\\uD83C[\\uDDE6\\uDDE8-\\uDDED\\uDDF0-\\uDDFF])|\\uD83C\\uDDE6(?:\\uD83C[\\uDDE8-\\uDDEC\\uDDEE\\uDDF1\\uDDF2\\uDDF4\\uDDF6-\\uDDFA\\uDDFC\\uDDFD\\uDDFF])|\\uD83C\\uDDF0(?:\\uD83C[\\uDDEA\\uDDEC-\\uDDEE\\uDDF2\\uDDF3\\uDDF5\\uDDF7\\uDDFC\\uDDFE\\uDDFF])|\\uD83C\\uDDED(?:\\uD83C[\\uDDF0\\uDDF2\\uDDF3\\uDDF7\\uDDF9\\uDDFA])|\\uD83C\\uDDE9(?:\\uD83C[\\uDDEA\\uDDEC\\uDDEF\\uDDF0\\uDDF2\\uDDF4\\uDDFF])|\\uD83C\\uDDFE(?:\\uD83C[\\uDDEA\\uDDF9])|\\uD83C\\uDDEC(?:\\uD83C[\\uDDE6\\uDDE7\\uDDE9-\\uDDEE\\uDDF1-\\uDDF3\\uDDF5-\\uDDFA\\uDDFC\\uDDFE])|\\uD83C\\uDDF8(?:\\uD83C[\\uDDE6-\\uDDEA\\uDDEC-\\uDDF4\\uDDF7-\\uDDF9\\uDDFB\\uDDFD-\\uDDFF])|\\uD83C\\uDDEB(?:\\uD83C[\\uDDEE-\\uDDF0\\uDDF2\\uDDF4\\uDDF7])|\\uD83C\\uDDF5(?:\\uD83C[\\uDDE6\\uDDEA-\\uDDED\\uDDF0-\\uDDF3\\uDDF7-\\uDDF9\\uDDFC\\uDDFE])|\\uD83C\\uDDFB(?:\\uD83C[\\uDDE6\\uDDE8\\uDDEA\\uDDEC\\uDDEE\\uDDF3\\uDDFA])|\\uD83C\\uDDF3(?:\\uD83C[\\uDDE6\\uDDE8\\uDDEA-\\uDDEC\\uDDEE\\uDDF1\\uDDF4\\uDDF5\\uDDF7\\uDDFA\\uDDFF])|\\uD83C\\uDDE8(?:\\uD83C[\\uDDE6\\uDDE8\\uDDE9\\uDDEB-\\uDDEE\\uDDF0-\\uDDF5\\uDDF7\\uDDFA-\\uDDFF])|\\uD83C\\uDDF1(?:\\uD83C[\\uDDE6-\\uDDE8\\uDDEE\\uDDF0\\uDDF7-\\uDDFB\\uDDFE])|\\uD83C\\uDDFF(?:\\uD83C[\\uDDE6\\uDDF2\\uDDFC])|\\uD83C\\uDDFC(?:\\uD83C[\\uDDEB\\uDDF8])|\\uD83C\\uDDFA(?:\\uD83C[\\uDDE6\\uDDEC\\uDDF2\\uDDF3\\uDDF8\\uDDFE\\uDDFF])|\\uD83C\\uDDEE(?:\\uD83C[\\uDDE8-\\uDDEA\\uDDF1-\\uDDF4\\uDDF6-\\uDDF9])|\\uD83C\\uDDEF(?:\\uD83C[\\uDDEA\\uDDF2\\uDDF4\\uDDF5])|(?:\\uD83C[\\uDFC3\\uDFC4\\uDFCA]|\\uD83D[\\uDC6E\\uDC71\\uDC73\\uDC77\\uDC81\\uDC82\\uDC86\\uDC87\\uDE45-\\uDE47\\uDE4B\\uDE4D\\uDE4E\\uDEA3\\uDEB4-\\uDEB6]|\\uD83E[\\uDD26\\uDD37-\\uDD39\\uDD3D\\uDD3E\\uDDB8\\uDDB9\\uDDCD-\\uDDCF\\uDDD6-\\uDDDD])(?:\\uD83C[\\uDFFB-\\uDFFF])|(?:\\u26F9|\\uD83C[\\uDFCB\\uDFCC]|\\uD83D\\uDD75)(?:\\uD83C[\\uDFFB-\\uDFFF])|(?:[\\u261D\\u270A-\\u270D]|\\uD83C[\\uDF85\\uDFC2\\uDFC7]|\\uD83D[\\uDC42\\uDC43\\uDC46-\\uDC50\\uDC66\\uDC67\\uDC6B-\\uDC6D\\uDC70\\uDC72\\uDC74-\\uDC76\\uDC78\\uDC7C\\uDC83\\uDC85\\uDCAA\\uDD74\\uDD7A\\uDD90\\uDD95\\uDD96\\uDE4C\\uDE4F\\uDEC0\\uDECC]|\\uD83E[\\uDD0F\\uDD18-\\uDD1C\\uDD1E\\uDD1F\\uDD30-\\uDD36\\uDDB5\\uDDB6\\uDDBB\\uDDD2-\\uDDD5])(?:\\uD83C[\\uDFFB-\\uDFFF])|(?:[\\u231A\\u231B\\u23E9-\\u23EC\\u23F0\\u23F3\\u25FD\\u25FE\\u2614\\u2615\\u2648-\\u2653\\u267F\\u2693\\u26A1\\u26AA\\u26AB\\u26BD\\u26BE\\u26C4\\u26C5\\u26CE\\u26D4\\u26EA\\u26F2\\u26F3\\u26F5\\u26FA\\u26FD\\u2705\\u270A\\u270B\\u2728\\u274C\\u274E\\u2753-\\u2755\\u2757\\u2795-\\u2797\\u27B0\\u27BF\\u2B1B\\u2B1C\\u2B50\\u2B55]|\\uD83C[\\uDC04\\uDCCF\\uDD8E\\uDD91-\\uDD9A\\uDDE6-\\uDDFF\\uDE01\\uDE1A\\uDE2F\\uDE32-\\uDE36\\uDE38-\\uDE3A\\uDE50\\uDE51\\uDF00-\\uDF20\\uDF2D-\\uDF35\\uDF37-\\uDF7C\\uDF7E-\\uDF93\\uDFA0-\\uDFCA\\uDFCF-\\uDFD3\\uDFE0-\\uDFF0\\uDFF4\\uDFF8-\\uDFFF]|\\uD83D[\\uDC00-\\uDC3E\\uDC40\\uDC42-\\uDCFC\\uDCFF-\\uDD3D\\uDD4B-\\uDD4E\\uDD50-\\uDD67\\uDD7A\\uDD95\\uDD96\\uDDA4\\uDDFB-\\uDE4F\\uDE80-\\uDEC5\\uDECC\\uDED0-\\uDED2\\uDED5\\uDEEB\\uDEEC\\uDEF4-\\uDEFA\\uDFE0-\\uDFEB]|\\uD83E[\\uDD0D-\\uDD3A\\uDD3C-\\uDD45\\uDD47-\\uDD71\\uDD73-\\uDD76\\uDD7A-\\uDDA2\\uDDA5-\\uDDAA\\uDDAE-\\uDDCA\\uDDCD-\\uDDFF\\uDE70-\\uDE73\\uDE78-\\uDE7A\\uDE80-\\uDE82\\uDE90-\\uDE95])|(?:[#\\*0-9\\xA9\\xAE\\u203C\\u2049\\u2122\\u2139\\u2194-\\u2199\\u21A9\\u21AA\\u231A\\u231B\\u2328\\u23CF\\u23E9-\\u23F3\\u23F8-\\u23FA\\u24C2\\u25AA\\u25AB\\u25B6\\u25C0\\u25FB-\\u25FE\\u2600-\\u2604\\u260E\\u2611\\u2614\\u2615\\u2618\\u261D\\u2620\\u2622\\u2623\\u2626\\u262A\\u262E\\u262F\\u2638-\\u263A\\u2640\\u2642\\u2648-\\u2653\\u265F\\u2660\\u2663\\u2665\\u2666\\u2668\\u267B\\u267E\\u267F\\u2692-\\u2697\\u2699\\u269B\\u269C\\u26A0\\u26A1\\u26AA\\u26AB\\u26B0\\u26B1\\u26BD\\u26BE\\u26C4\\u26C5\\u26C8\\u26CE\\u26CF\\u26D1\\u26D3\\u26D4\\u26E9\\u26EA\\u26F0-\\u26F5\\u26F7-\\u26FA\\u26FD\\u2702\\u2705\\u2708-\\u270D\\u270F\\u2712\\u2714\\u2716\\u271D\\u2721\\u2728\\u2733\\u2734\\u2744\\u2747\\u274C\\u274E\\u2753-\\u2755\\u2757\\u2763\\u2764\\u2795-\\u2797\\u27A1\\u27B0\\u27BF\\u2934\\u2935\\u2B05-\\u2B07\\u2B1B\\u2B1C\\u2B50\\u2B55\\u3030\\u303D\\u3297\\u3299]|\\uD83C[\\uDC04\\uDCCF\\uDD70\\uDD71\\uDD7E\\uDD7F\\uDD8E\\uDD91-\\uDD9A\\uDDE6-\\uDDFF\\uDE01\\uDE02\\uDE1A\\uDE2F\\uDE32-\\uDE3A\\uDE50\\uDE51\\uDF00-\\uDF21\\uDF24-\\uDF93\\uDF96\\uDF97\\uDF99-\\uDF9B\\uDF9E-\\uDFF0\\uDFF3-\\uDFF5\\uDFF7-\\uDFFF]|\\uD83D[\\uDC00-\\uDCFD\\uDCFF-\\uDD3D\\uDD49-\\uDD4E\\uDD50-\\uDD67\\uDD6F\\uDD70\\uDD73-\\uDD7A\\uDD87\\uDD8A-\\uDD8D\\uDD90\\uDD95\\uDD96\\uDDA4\\uDDA5\\uDDA8\\uDDB1\\uDDB2\\uDDBC\\uDDC2-\\uDDC4\\uDDD1-\\uDDD3\\uDDDC-\\uDDDE\\uDDE1\\uDDE3\\uDDE8\\uDDEF\\uDDF3\\uDDFA-\\uDE4F\\uDE80-\\uDEC5\\uDECB-\\uDED2\\uDED5\\uDEE0-\\uDEE5\\uDEE9\\uDEEB\\uDEEC\\uDEF0\\uDEF3-\\uDEFA\\uDFE0-\\uDFEB]|\\uD83E[\\uDD0D-\\uDD3A\\uDD3C-\\uDD45\\uDD47-\\uDD71\\uDD73-\\uDD76\\uDD7A-\\uDDA2\\uDDA5-\\uDDAA\\uDDAE-\\uDDCA\\uDDCD-\\uDDFF\\uDE70-\\uDE73\\uDE78-\\uDE7A\\uDE80-\\uDE82\\uDE90-\\uDE95])\\uFE0F|(?:[\\u261D\\u26F9\\u270A-\\u270D]|\\uD83C[\\uDF85\\uDFC2-\\uDFC4\\uDFC7\\uDFCA-\\uDFCC]|\\uD83D[\\uDC42\\uDC43\\uDC46-\\uDC50\\uDC66-\\uDC78\\uDC7C\\uDC81-\\uDC83\\uDC85-\\uDC87\\uDC8F\\uDC91\\uDCAA\\uDD74\\uDD75\\uDD7A\\uDD90\\uDD95\\uDD96\\uDE45-\\uDE47\\uDE4B-\\uDE4F\\uDEA3\\uDEB4-\\uDEB6\\uDEC0\\uDECC]|\\uD83E[\\uDD0F\\uDD18-\\uDD1F\\uDD26\\uDD30-\\uDD39\\uDD3C-\\uDD3E\\uDDB5\\uDDB6\\uDDB8\\uDDB9\\uDDBB\\uDDCD-\\uDDCF\\uDDD1-\\uDDDD])/g}}),We=e(function(e,t){!function(){"use strict";var u={name:"doT",version:"1.1.1",templateSettings:{evaluate:/\\{\\{([\\s\\S]+?(\\}?)+)\\}\\}/g,interpolate:/\\{\\{=([\\s\\S]+?)\\}\\}/g,encode:/\\{\\{!([\\s\\S]+?)\\}\\}/g,use:/\\{\\{#([\\s\\S]+?)\\}\\}/g,useParams:/(^|[^\\w$])def(?:\\.|\\[[\\\'\\"])([\\w$\\.]+)(?:[\\\'\\"]\\])?\\s*\\:\\s*([\\w$\\.]+|\\"[^\\"]+\\"|\\\'[^\\\']+\\\'|\\{[^\\}]+\\})/g,define:/\\{\\{##\\s*([\\w\\.$]+)\\s*(\\:|=)([\\s\\S]+?)#\\}\\}/g,defineParams:/^\\s*([\\w$]+):([\\s\\S]+)/,conditional:/\\{\\{\\?(\\?)?\\s*([\\s\\S]*?)\\s*\\}\\}/g,iterate:/\\{\\{~\\s*(?:\\}\\}|([\\s\\S]+?)\\s*\\:\\s*([\\w$]+)\\s*(?:\\:\\s*([\\w$]+))?\\s*\\}\\})/g,varname:"it",strip:!0,append:!0,selfcontained:!1,doNotSkipEncoded:!1},template:void 0,compile:void 0,log:!0};!function(){if("object"!==("undefined"==typeof globalThis?"undefined":Gs(globalThis)))try{Object.defineProperty(Object.prototype,"__magic__",{get:function(){return this},configurable:!0}),__magic__.globalThis=__magic__,delete Object.prototype.__magic__}catch(e){window.globalThis=function(){if("undefined"!=typeof self)return self;if(void 0!==window)return window;if(void 0!==Ws)return Ws;if(void 0!==this)return this;throw new Error("Unable to locate global `this`")}()}}(),u.encodeHTMLSource=function(e){var t={"&":"&#38;","<":"&#60;",">":"&#62;",\'"\':"&#34;","\'":"&#39;","/":"&#47;"},r=e?/[&<>"\'\\/]/g:/&(?!#?\\w+;)|<|>|"|\'|\\//g;return function(e){return e?e.toString().replace(r,function(e){return t[e]||e}):""}},void 0!==t&&t.exports?t.exports=u:"function"==typeof define&&define.amd?define(function(){return u}):globalThis.doT=u;var s={append:{start:"\'+(",end:")+\'",startencode:"\'+encodeHTML("},split:{start:"\';out+=(",end:");out+=\'",startencode:"\';out+=encodeHTML("}},c=/$^/;function d(e){return e.replace(/\\\\(\'|\\\\)/g,"$1").replace(/[\\r\\t\\n]/g," ")}u.template=function(e,t,r){var a,n,o=(t=t||u.templateSettings).append?s.append:s.split,i=0,l=t.use||t.define?function a(n,e,o){return("string"==typeof e?e:e.toString()).replace(n.define||c,function(e,a,t,r){return 0===a.indexOf("def.")&&(a=a.substring(4)),a in o||(":"===t?(n.defineParams&&r.replace(n.defineParams,function(e,t,r){o[a]={arg:t,text:r}}),a in o||(o[a]=r)):new Function("def","def[\'"+a+"\']="+r)(o)),""}).replace(n.use||c,function(e,t){n.useParams&&(t=t.replace(n.useParams,function(e,t,r,a){if(o[r]&&o[r].arg&&a){var n=(r+":"+a).replace(/\'|\\\\/g,"_");return o.__exp=o.__exp||{},o.__exp[n]=o[r].text.replace(new RegExp("(^|[^\\\\w$])"+o[r].arg+"([^\\\\w$])","g"),"$1"+a+"$2"),t+"def.__exp[\'"+n+"\']"}}));var r=new Function("def","return "+t)(o);return r?a(n,r,o):r})}(t,e,r||{}):e,l=("var out=\'"+(t.strip?l.replace(/(^|\\r|\\n)\\t* +| +\\t*(\\r|\\n|$)/g," ").replace(/\\r|\\n|\\t|\\/\\*[\\s\\S]*?\\*\\//g,""):l).replace(/\'|\\\\/g,"\\\\$&").replace(t.interpolate||c,function(e,t){return o.start+d(t)+o.end}).replace(t.encode||c,function(e,t){return a=!0,o.startencode+d(t)+o.end}).replace(t.conditional||c,function(e,t,r){return t?r?"\';}else if("+d(r)+"){out+=\'":"\';}else{out+=\'":r?"\';if("+d(r)+"){out+=\'":"\';}out+=\'"}).replace(t.iterate||c,function(e,t,r,a){return t?(i+=1,n=a||"i"+i,t=d(t),"\';var arr"+i+"="+t+";if(arr"+i+"){var "+r+","+n+"=-1,l"+i+"=arr"+i+".length-1;while("+n+"<l"+i+"){"+r+"=arr"+i+"["+n+"+=1];out+=\'"):"\';} } out+=\'"}).replace(t.evaluate||c,function(e,t){return"\';"+d(t)+"out+=\'"})+"\';return out;").replace(/\\n/g,"\\\\n").replace(/\\t/g,"\\\\t").replace(/\\r/g,"\\\\r").replace(/(\\s|;|\\}|^|\\{)out\\+=\'\';/g,"$1").replace(/\\+\'\'/g,"");a&&(t.selfcontained||!globalThis||globalThis._encodeHTML||(globalThis._encodeHTML=u.encodeHTMLSource(t.doNotSkipEncoded)),l="var encodeHTML = typeof _encodeHTML !== \'undefined\' ? _encodeHTML : ("+u.encodeHTMLSource.toString()+"("+(t.doNotSkipEncoded||"")+"));"+l);try{return new Function(t.varname,l)}catch(e){throw"undefined"!=typeof console&&console.log("Could not create a template function: "+l),e}},u.compile=function(e,t){return u.template(e,null,t)}}()}),Ge=e(function(e,t){var r,a;a=function(){"use strict";function u(e){return"function"==typeof e}var r=Array.isArray?Array.isArray:function(e){return"[object Array]"===Object.prototype.toString.call(e)},a=0,t=void 0,n=void 0,i=function(e,t){p[a]=e,p[a+1]=t,2===(a+=2)&&(n?n(f):b())};var e=void 0!==window?window:void 0,o=e||{},l=o.MutationObserver||o.WebKitMutationObserver,s="undefined"==typeof self&&"undefined"!=typeof process&&"[object process]"==={}.toString.call(process),c="undefined"!=typeof Uint8ClampedArray&&"undefined"!=typeof importScripts&&"undefined"!=typeof MessageChannel;function d(){var e=setTimeout;return function(){return e(f,1)}}var p=new Array(1e3);function f(){for(var e=0;e<a;e+=2){(0,p[e])(p[e+1]),p[e]=void 0,p[e+1]=void 0}a=0}var m,h,g,v,b=void 0;function y(e,t){var r=this,a=new this.constructor(x);void 0===a[w]&&B(a);var n,o=r._state;return o?(n=arguments[o-1],i(function(){return P(o,a,n,r._result)})):O(r,a,e,t),a}function D(e){if(e&&"object"===Gs(e)&&e.constructor===this)return e;var t=new this(x);return R(t,e),t}b=s?function(){return process.nextTick(f)}:l?(h=0,g=new l(f),v=document.createTextNode(""),g.observe(v,{characterData:!0}),function(){v.data=h=++h%2}):c?((m=new MessageChannel).port1.onmessage=f,function(){return m.port2.postMessage(0)}):(void 0===e?function(){try{var e=Function("return this")().require("vertx");return void 0!==(t=e.runOnLoop||e.runOnContext)?function(){t(f)}:d()}catch(e){return d()}}:d)();var w=Math.random().toString(36).substring(2);function x(){}var E=void 0,A=1,C=2;function F(e,a,n){i(function(t){var r=!1,e=function(e,t,r,a){try{e.call(t,r,a)}catch(e){return e}}(n,a,function(e){r||(r=!0,(a!==e?R:N)(t,e))},function(e){r||(r=!0,_(t,e))},t._label);!r&&e&&(r=!0,_(t,e))},e)}function k(e,t,r){var a,n;t.constructor===e.constructor&&r===y&&t.constructor.resolve===D?(a=e,(n=t)._state===A?N(a,n._result):n._state===C?_(a,n._result):O(n,void 0,function(e){return R(a,e)},function(e){return _(a,e)})):void 0!==r&&u(r)?F(e,t,r):N(e,t)}function R(t,e){if(t===e)_(t,new TypeError("You cannot resolve a promise with itself"));else if(n=Gs(a=e),null===a||"object"!==n&&"function"!==n)N(t,e);else{var r=void 0;try{r=e.then}catch(e){return void _(t,e)}k(t,e,r)}var a,n}function T(e){e._onerror&&e._onerror(e._result),S(e)}function N(e,t){e._state===E&&(e._result=t,e._state=A,0!==e._subscribers.length&&i(S,e))}function _(e,t){e._state===E&&(e._state=C,e._result=t,i(T,e))}function O(e,t,r,a){var n=e._subscribers,o=n.length;e._onerror=null,n[o]=t,n[o+A]=r,n[o+C]=a,0===o&&e._state&&i(S,e)}function S(e){var t=e._subscribers,r=e._state;if(0!==t.length){for(var a,n=void 0,o=e._result,i=0;i<t.length;i+=3)a=t[i],n=t[i+r],a?P(r,a,n,o):n(o);e._subscribers.length=0}}function P(e,t,r,a){var n=u(r),o=void 0,i=void 0,l=!0;if(n){try{o=r(a)}catch(e){l=!1,i=e}if(t===o)return void _(t,new TypeError("A promises callback cannot return that same promise."))}else o=a;t._state!==E||(n&&l?R(t,o):!1===l?_(t,i):e===A?N(t,o):e===C&&_(t,o))}var I=0;function B(e){e[w]=I++,e._state=void 0,e._result=void 0,e._subscribers=[]}var L=(q.prototype._enumerate=function(e){for(var t=0;this._state===E&&t<e.length;t++)this._eachEntry(e[t],t)},q.prototype._eachEntry=function(t,e){var r=this._instanceConstructor,a=r.resolve;if(a===D){var n,o=void 0,i=void 0,l=!1;try{o=t.then}catch(e){l=!0,i=e}o===y&&t._state!==E?this._settledAt(t._state,e,t._result):"function"!=typeof o?(this._remaining--,this._result[e]=t):r===j?(n=new r(x),l?_(n,i):k(n,t,o),this._willSettleAt(n,e)):this._willSettleAt(new r(function(e){return e(t)}),e)}else this._willSettleAt(a(t),e)},q.prototype._settledAt=function(e,t,r){var a=this.promise;a._state===E&&(this._remaining--,e===C?_(a,r):this._result[t]=r),0===this._remaining&&N(a,this._result)},q.prototype._willSettleAt=function(e,t){var r=this;O(e,void 0,function(e){return r._settledAt(A,t,e)},function(e){return r._settledAt(C,t,e)})},q);function q(e,t){this._instanceConstructor=e,this.promise=new e(x),this.promise[w]||B(this.promise),r(t)?(this.length=t.length,this._remaining=t.length,this._result=new Array(this.length),0===this.length?N(this.promise,this._result):(this.length=this.length||0,this._enumerate(t),0===this._remaining&&N(this.promise,this._result))):_(this.promise,new Error("Array Methods must be provided an Array"))}var j=(M.prototype.catch=function(e){return this.then(null,e)},M.prototype.finally=function(t){var r=this.constructor;return u(t)?this.then(function(e){return r.resolve(t()).then(function(){return e})},function(e){return r.resolve(t()).then(function(){throw e})}):this.then(t,t)},M);function M(e){this[w]=I++,this._result=this._state=void 0,this._subscribers=[],x!==e&&("function"!=typeof e&&function(){throw new TypeError("You must pass a resolver function as the first argument to the promise constructor")}(),this instanceof M?function(t,e){try{e(function(e){R(t,e)},function(e){_(t,e)})}catch(e){_(t,e)}}(this,e):function(){throw new TypeError("Failed to construct \'Promise\': Please use the \'new\' operator, this object constructor cannot be called as a function.")}())}return j.prototype.then=y,j.all=function(e){return new L(this,e).promise},j.race=function(n){var o=this;return r(n)?new o(function(e,t){for(var r=n.length,a=0;a<r;a++)o.resolve(n[a]).then(e,t)}):new o(function(e,t){return t(new TypeError("You must pass an array to race."))})},j.resolve=D,j.reject=function(e){var t=new this(x);return _(t,e),t},j._setScheduler=function(e){n=e},j._setAsap=function(e){i=e},j._asap=i,j.polyfill=function(){var e=void 0;if(void 0!==Ws)e=Ws;else if("undefined"!=typeof self)e=self;else try{e=Function("return this")()}catch(e){throw new Error("polyfill failed because global object is unavailable in this environment")}var t=e.Promise;if(t){var r=null;try{r=Object.prototype.toString.call(t.resolve())}catch(e){}if("[object Promise]"===r&&!t.cast)return}e.Promise=j},j.Promise=j},"object"===Gs(r=e)&&void 0!==t?t.exports=a():"function"==typeof define&&define.amd?define(a):r.ES6Promise=a()}),Ye=e(function(p){var t,r,a,n=1e5,f=(t=Object.prototype.toString,r=Object.prototype.hasOwnProperty,{Class:function(e){return t.call(e).replace(/^\\[object *|\\]$/g,"")},HasProperty:function(e,t){return t in e},HasOwnProperty:function(e,t){return r.call(e,t)},IsCallable:function(e){return"function"==typeof e},ToInt32:function(e){return e>>0},ToUint32:function(e){return e>>>0}}),m=Math.LN2,h=Math.abs,g=Math.floor,v=Math.log,b=Math.min,y=Math.pow,o=Math.round;function D(e){if(i&&a)for(var t=i(e),r=0;r<t.length;r+=1)a(e,t[r],{value:e[t[r]],writable:!1,enumerable:!1,configurable:!1})}a=Object.defineProperty&&function(){try{return Object.defineProperty({},"x",{}),1}catch(e){return}}()?Object.defineProperty:function(e,t,r){if(!e===Object(e))throw new TypeError("Object.defineProperty called on non-object");return f.HasProperty(r,"get")&&Object.prototype.__defineGetter__&&Object.prototype.__defineGetter__.call(e,t,r.get),f.HasProperty(r,"set")&&Object.prototype.__defineSetter__&&Object.prototype.__defineSetter__.call(e,t,r.set),f.HasProperty(r,"value")&&(e[t]=r.value),e};var e,u,i=Object.getOwnPropertyNames||function(e){if(e!==Object(e))throw new TypeError("Object.getOwnPropertyNames called on non-object");var t,r=[];for(t in e)f.HasOwnProperty(e,t)&&r.push(t);return r};function w(r){if(a){if(r.length>n)throw new RangeError("Array too large for polyfill");for(var e=0;e<r.length;e+=1)!function(t){a(r,t,{get:function(){return r._getter(t)},set:function(e){r._setter(t,e)},enumerable:!0,configurable:!1})}(e)}}function l(e,t){var r=32-t;return e<<r>>r}function s(e,t){var r=32-t;return e<<r>>>r}function x(e){return[255&e]}function E(e){return l(e[0],8)}function A(e){return[255&e]}function C(e){return s(e[0],8)}function F(e){return[(e=o(Number(e)))<0?0:255<e?255:255&e]}function k(e){return[e>>8&255,255&e]}function R(e){return l(e[0]<<8|e[1],16)}function T(e){return[e>>8&255,255&e]}function N(e){return s(e[0]<<8|e[1],16)}function _(e){return[e>>24&255,e>>16&255,e>>8&255,255&e]}function O(e){return l(e[0]<<24|e[1]<<16|e[2]<<8|e[3],32)}function S(e){return[e>>24&255,e>>16&255,e>>8&255,255&e]}function P(e){return s(e[0]<<24|e[1]<<16|e[2]<<8|e[3],32)}function c(e,t,r){var a,n,o,i,l,u,s,c=(1<<t-1)-1;function d(e){var t=g(e),r=e-t;return!(r<.5)&&(.5<r||t%2)?t+1:t}for(e!=e?(n=(1<<t)-1,o=y(2,r-1),a=0):e===1/0||e===-1/0?(n=(1<<t)-1,a=e<(o=0)?1:0):0===e?a=1/e==-1/(o=n=0)?1:0:(a=e<0,(e=h(e))>=y(2,1-c)?(n=b(g(v(e)/m),1023),2<=(o=d(e/y(2,n)*y(2,r)))/y(2,r)&&(n+=1,o=1),c<n?(n=(1<<t)-1,o=0):(n+=c,o-=y(2,r))):(n=0,o=d(e/y(2,1-c-r)))),l=[],i=r;i;--i)l.push(o%2?1:0),o=g(o/2);for(i=t;i;--i)l.push(n%2?1:0),n=g(n/2);for(l.push(a?1:0),l.reverse(),u=l.join(""),s=[];u.length;)s.push(parseInt(u.substring(0,8),2)),u=u.substring(8);return s}function d(e,t,r){for(var a,n,o,i,l,u,s,c=[],d=e.length;d;--d)for(n=e[d-1],a=8;a;--a)c.push(n%2?1:0),n>>=1;return c.reverse(),o=c.join(""),i=(1<<t-1)-1,l=parseInt(o.substring(0,1),2)?-1:1,u=parseInt(o.substring(1,1+t),2),s=parseInt(o.substring(1+t),2),u===(1<<t)-1?0!==s?NaN:1/0*l:0<u?l*y(2,u-i)*(1+s/y(2,r)):0!==s?l*y(2,-(i-1))*(s/y(2,r)):l<0?-0:0}function I(e){return d(e,11,52)}function B(e){return c(e,11,52)}function L(e){return d(e,8,23)}function q(e){return c(e,8,23)}function j(e,t){return f.IsCallable(e.get)?e.get(t):e[t]}function M(e,t,r){if(0===arguments.length)e=new p.ArrayBuffer(0);else if(!(e instanceof p.ArrayBuffer||"ArrayBuffer"===f.Class(e)))throw new TypeError("TypeError");if(this.buffer=e||new p.ArrayBuffer(0),this.byteOffset=f.ToUint32(t),this.byteOffset>this.buffer.byteLength)throw new RangeError("byteOffset out of range");if(this.byteLength=arguments.length<3?this.buffer.byteLength-this.byteOffset:f.ToUint32(r),this.byteOffset+this.byteLength>this.buffer.byteLength)throw new RangeError("byteOffset and length reference an area beyond the end of the buffer");D(this)}function U(o){return function(e,t){if((e=f.ToUint32(e))+o.BYTES_PER_ELEMENT>this.byteLength)throw new RangeError("Array index out of range");e+=this.byteOffset;for(var r=new p.Uint8Array(this.buffer,e,o.BYTES_PER_ELEMENT),a=[],n=0;n<o.BYTES_PER_ELEMENT;n+=1)a.push(j(r,n));return Boolean(t)===Boolean(u)&&a.reverse(),j(new o(new p.Uint8Array(a).buffer),0)}}function V(l){return function(e,t,r){if((e=f.ToUint32(e))+l.BYTES_PER_ELEMENT>this.byteLength)throw new RangeError("Array index out of range");for(var a=new l([t]),n=new p.Uint8Array(a.buffer),o=[],i=0;i<l.BYTES_PER_ELEMENT;i+=1)o.push(j(n,i));Boolean(r)===Boolean(u)&&o.reverse(),new p.Uint8Array(this.buffer,e,l.BYTES_PER_ELEMENT).set(o)}}!function(){function u(e){if((e=f.ToInt32(e))<0)throw new RangeError("ArrayBuffer size is not a small enough positive integer");var t;for(this.byteLength=e,this._bytes=[],this._bytes.length=e,t=0;t<this.byteLength;t+=1)this._bytes[t]=0;D(this)}p.ArrayBuffer=p.ArrayBuffer||u;function a(){}function e(e,t,r){var l=function(e,t,r){var a,n,o,i;if(arguments.length&&"number"!=typeof e)if("object"===Gs(e)&&e.constructor===l)for(a=e,this.length=a.length,this.byteLength=this.length*this.BYTES_PER_ELEMENT,this.buffer=new u(this.byteLength),o=this.byteOffset=0;o<this.length;o+=1)this._setter(o,a._getter(o));else if("object"!==Gs(e)||(e instanceof u||"ArrayBuffer"===f.Class(e))){if("object"!==Gs(e)||!(e instanceof u||"ArrayBuffer"===f.Class(e)))throw new TypeError("Unexpected argument type(s)");if(this.buffer=e,this.byteOffset=f.ToUint32(t),this.byteOffset>this.buffer.byteLength)throw new RangeError("byteOffset out of range");if(this.byteOffset%this.BYTES_PER_ELEMENT)throw new RangeError("ArrayBuffer length minus the byteOffset is not a multiple of the element size.");if(arguments.length<3){if(this.byteLength=this.buffer.byteLength-this.byteOffset,this.byteLength%this.BYTES_PER_ELEMENT)throw new RangeError("length of buffer minus byteOffset not a multiple of the element size");this.length=this.byteLength/this.BYTES_PER_ELEMENT}else this.length=f.ToUint32(r),this.byteLength=this.length*this.BYTES_PER_ELEMENT;if(this.byteOffset+this.byteLength>this.buffer.byteLength)throw new RangeError("byteOffset and length reference an area beyond the end of the buffer")}else for(n=e,this.length=f.ToUint32(n.length),this.byteLength=this.length*this.BYTES_PER_ELEMENT,this.buffer=new u(this.byteLength),o=this.byteOffset=0;o<this.length;o+=1)i=n[o],this._setter(o,Number(i));else{if(this.length=f.ToInt32(e),r<0)throw new RangeError("ArrayBufferView size is not a small enough positive integer");this.byteLength=this.length*this.BYTES_PER_ELEMENT,this.buffer=new u(this.byteLength),this.byteOffset=0}this.constructor=l,D(this),w(this)};return l.prototype=new a,l.prototype.BYTES_PER_ELEMENT=e,l.prototype._pack=t,l.prototype._unpack=r,l.BYTES_PER_ELEMENT=e,l.prototype._getter=function(e){if(arguments.length<1)throw new SyntaxError("Not enough arguments");if(!((e=f.ToUint32(e))>=this.length)){for(var t=[],r=0,a=this.byteOffset+e*this.BYTES_PER_ELEMENT;r<this.BYTES_PER_ELEMENT;r+=1,a+=1)t.push(this.buffer._bytes[a]);return this._unpack(t)}},l.prototype.get=l.prototype._getter,l.prototype._setter=function(e,t){if(arguments.length<2)throw new SyntaxError("Not enough arguments");if(!((e=f.ToUint32(e))>=this.length))for(var r=this._pack(t),a=0,n=this.byteOffset+e*this.BYTES_PER_ELEMENT;a<this.BYTES_PER_ELEMENT;a+=1,n+=1)this.buffer._bytes[n]=r[a]},l.prototype.set=function(e,t){if(arguments.length<1)throw new SyntaxError("Not enough arguments");var r,a,n,o,i,l,u,s,c,d;if("object"===Gs(e)&&e.constructor===this.constructor){if(r=e,(n=f.ToUint32(t))+r.length>this.length)throw new RangeError("Offset plus length of array is out of range");if(s=this.byteOffset+n*this.BYTES_PER_ELEMENT,c=r.length*this.BYTES_PER_ELEMENT,r.buffer===this.buffer){for(d=[],i=0,l=r.byteOffset;i<c;i+=1,l+=1)d[i]=r.buffer._bytes[l];for(i=0,u=s;i<c;i+=1,u+=1)this.buffer._bytes[u]=d[i]}else for(i=0,l=r.byteOffset,u=s;i<c;i+=1,l+=1,u+=1)this.buffer._bytes[u]=r.buffer._bytes[l]}else{if("object"!==Gs(e)||void 0===e.length)throw new TypeError("Unexpected argument type(s)");if(a=e,o=f.ToUint32(a.length),(n=f.ToUint32(t))+o>this.length)throw new RangeError("Offset plus length of array is out of range");for(i=0;i<o;i+=1)l=a[i],this._setter(n+i,Number(l))}},l.prototype.subarray=function(e,t){function r(e,t,r){return e<t?t:r<e?r:e}e=f.ToInt32(e),t=f.ToInt32(t),arguments.length<1&&(e=0),arguments.length<2&&(t=this.length),e<0&&(e=this.length+e),t<0&&(t=this.length+t),e=r(e,0,this.length);var a=(t=r(t,0,this.length))-e;return a<0&&(a=0),new this.constructor(this.buffer,this.byteOffset+e*this.BYTES_PER_ELEMENT,a)},l}var t=e(1,x,E),r=e(1,A,C),n=e(1,F,C),o=e(2,k,R),i=e(2,T,N),l=e(4,_,O),s=e(4,S,P),c=e(4,q,L),d=e(8,B,I);p.Int8Array=p.Int8Array||t,p.Uint8Array=p.Uint8Array||r,p.Uint8ClampedArray=p.Uint8ClampedArray||n,p.Int16Array=p.Int16Array||o,p.Uint16Array=p.Uint16Array||i,p.Int32Array=p.Int32Array||l,p.Uint32Array=p.Uint32Array||s,p.Float32Array=p.Float32Array||c,p.Float64Array=p.Float64Array||d}(),e=new p.Uint16Array([4660]),u=18===j(new p.Uint8Array(e.buffer),0),M.prototype.getUint8=U(p.Uint8Array),M.prototype.getInt8=U(p.Int8Array),M.prototype.getUint16=U(p.Uint16Array),M.prototype.getInt16=U(p.Int16Array),M.prototype.getUint32=U(p.Uint32Array),M.prototype.getInt32=U(p.Int32Array),M.prototype.getFloat32=U(p.Float32Array),M.prototype.getFloat64=U(p.Float64Array),M.prototype.setUint8=V(p.Uint8Array),M.prototype.setInt8=V(p.Int8Array),M.prototype.setUint16=V(p.Uint16Array),M.prototype.setInt16=V(p.Int16Array),M.prototype.setUint32=V(p.Uint32Array),M.prototype.setInt32=V(p.Int32Array),M.prototype.setFloat32=V(p.Float32Array),M.prototype.setFloat64=V(p.Float64Array),p.DataView=p.DataView||M}),Ke=e(function(e){!function(e){"use strict";var r,a;function t(){if(void 0===this)throw new TypeError("Constructor WeakMap requires \'new\'");if(a(this,"_id","_WeakMap_"+o()+"."+o()),0<arguments.length)throw new TypeError("WeakMap iterable is not supported")}function n(e,t){if(!i(e)||!r.call(e,"_id"))throw new TypeError(t+" method called on incompatible receiver "+Gs(e))}function o(){return Math.random().toString().substring(2)}function i(e){return Object(e)===e}e.WeakMap||(r=Object.prototype.hasOwnProperty,a=function(e,t,r){Object.defineProperty?Object.defineProperty(e,t,{configurable:!0,writable:!0,value:r}):e[t]=r},e.WeakMap=(a(t.prototype,"delete",function(e){if(n(this,"delete"),!i(e))return!1;var t=e[this._id];return!(!t||t[0]!==e||(delete e[this._id],0))}),a(t.prototype,"get",function(e){if(n(this,"get"),i(e)){var t=e[this._id];return t&&t[0]===e?t[1]:void 0}}),a(t.prototype,"has",function(e){if(n(this,"has"),!i(e))return!1;var t=e[this._id];return!(!t||t[0]!==e)}),a(t.prototype,"set",function(e,t){if(n(this,"set"),!i(e))throw new TypeError("Invalid value used as weak map key");var r=e[this._id];return r&&r[0]===e?r[1]=t:a(e,this._id,[e,t]),this}),a(t,"_polyfill",!0),t))}("undefined"!=typeof self?self:void 0!==window?window:void 0!==Ws?Ws:e)}),Xe={helpUrlBase:"https://dequeuniversity.com/rules/",results:[],resultGroups:[],resultGroupMap:{},impact:Object.freeze(["minor","moderate","serious","critical"]),preload:Object.freeze({assets:["cssom","media"],timeout:1e4})};[{name:"NA",value:"inapplicable",priority:0,group:"inapplicable"},{name:"PASS",value:"passed",priority:1,group:"passes"},{name:"CANTTELL",value:"cantTell",priority:2,group:"incomplete"},{name:"FAIL",value:"failed",priority:3,group:"violations"}].forEach(function(e){var t=e.name,r=e.value,a=e.priority,n=e.group;Xe[t]=r,Xe[t+"_PRIO"]=a,Xe[t+"_GROUP"]=n,Xe.results[a]=r,Xe.resultGroups[a]=n,Xe.resultGroupMap[r]=n}),Object.freeze(Xe.results),Object.freeze(Xe.resultGroups),Object.freeze(Xe.resultGroupMap),Object.freeze(Xe);var Je=Xe;var Qe=function(){"object"===("undefined"==typeof console?"undefined":Gs(console))&&console.log&&Function.prototype.apply.call(console.log,console,arguments)},Ze=/[\\t\\r\\n\\f]/g;function et(){rc(this,et),this.parent=void 0}var tt=(ac(et,[{key:"attr",value:function(){throw new Error(\'VirtualNode class must have a "attr" function\')}},{key:"hasAttr",value:function(){throw new Error(\'VirtualNode class must have a "hasAttr" function\')}},{key:"hasClass",value:function(e){var t=this.attr("class");if(!t)return!1;var r=" "+e+" ";return 0<=(" "+t+" ").replace(Ze," ").indexOf(r)}},{key:"props",get:function(){throw new Error(\'VirtualNode class must have a "props" object consisting of "nodeType" and "nodeName" properties\')}}]),et),rt={};t(rt,{DqElement:function(){return Ut},aggregate:function(){return at},aggregateChecks:function(){return st},aggregateNodeResults:function(){return dt},aggregateResult:function(){return ft},areStylesSet:function(){return mt},assert:function(){return ht},checkHelper:function(){return Vt},clone:function(){return Ht},closest:function(){return er},collectResultsFromFrames:function(){return jr},contains:function(){return Mr},convertSelector:function(){return Jt},cssParser:function(){return $t},deepMerge:function(){return Ur},escapeSelector:function(){return vt},extendMetaData:function(){return Vr},finalizeRuleResult:function(){return ct},findBy:function(){return Lr},getAllChecks:function(){return Ir},getAncestry:function(){return qt},getBaseLang:function(){return cn},getCheckMessage:function(){return yn},getCheckOption:function(){return Dn},getFlattenedTree:function(){return sn},getFriendlyUriEnd:function(){return Dt},getNodeAttributes:function(){return xt},getNodeFromTree:function(){return wn},getPreloadConfig:function(){return eo},getRootNode:function(){return Wr},getScroll:function(){return xn},getScrollState:function(){return En},getSelector:function(){return Bt},getSelectorData:function(){return Ot},getShadowSelector:function(){return Ft},getStyleSheetFactory:function(){return Cn},getXpath:function(){return jt},injectStyle:function(){return Fn},isHidden:function(){return kn},isHtmlElement:function(){return Tn},isNodeInContext:function(){return _n},isShadowRoot:function(){return zr},isValidLang:function(){return mo},isXHTML:function(){return At},matches:function(){return Zt},matchesExpression:function(){return Qt},matchesSelector:function(){return Et},memoize:function(){return Sn},mergeResults:function(){return qr},nodeSorter:function(){return Br},parseCrossOriginStylesheet:function(){return qn},parseSameOriginStylesheet:function(){return Pn},parseStylesheet:function(){return In},performanceTimer:function(){return Vn},pollyfillElementsFromPoint:function(){return Hn},preload:function(){return to},preloadCssom:function(){return Kn},preloadMedia:function(){return Qn},processMessage:function(){return bn},publishMetaData:function(){return ao},querySelectorAll:function(){return no},querySelectorAllFilter:function(){return Yn},queue:function(){return lr},respondable:function(){return Or},ruleShouldRun:function(){return io},select:function(){return lo},sendCommandToFrame:function(){return Pr},setScrollState:function(){return uo},shouldPreload:function(){return Zn},toArray:function(){return gt},tokenList:function(){return so},uniqueArray:function(){return Wn},validInputTypes:function(){return co},validLangs:function(){return fo}});var at=function(t,e,r){e=e.slice(),r&&e.push(r);var a=e.map(function(e){return t.indexOf(e)}).sort();return t[a.pop()]},nt=Je.CANTTELL_PRIO,ot=Je.FAIL_PRIO,it=[];it[Je.PASS_PRIO]=!0,it[Je.CANTTELL_PRIO]=null,it[Je.FAIL_PRIO]=!1;var lt=["any","all","none"];function ut(r,a){return lt.reduce(function(e,t){return e[t]=(r[t]||[]).map(function(e){return a(e,t)}),e},{})}var st=function(e){var r=Object.assign({},e);ut(r,function(e,t){var r=void 0===e.result?-1:it.indexOf(e.result);e.priority=-1!==r?r:Je.CANTTELL_PRIO,"none"===t&&(e.priority===Je.PASS_PRIO?e.priority=Je.FAIL_PRIO:e.priority===Je.FAIL_PRIO&&(e.priority=Je.PASS_PRIO))});var a={all:r.all.reduce(function(e,t){return Math.max(e,t.priority)},0),none:r.none.reduce(function(e,t){return Math.max(e,t.priority)},0),any:r.any.reduce(function(e,t){return Math.min(e,t.priority)},4)%4};r.priority=Math.max(a.all,a.none,a.any);var n=[];return lt.forEach(function(t){r[t]=r[t].filter(function(e){return e.priority===r.priority&&e.priority===a[t]}),r[t].forEach(function(e){return n.push(e.impact)})}),[nt,ot].includes(r.priority)?r.impact=at(Je.impact,n):r.impact=null,ut(r,function(e){delete e.result,delete e.priority}),r.result=Je.results[r.priority],delete r.priority,r};var ct=function(t){var r=axe._audit.rules.find(function(e){return e.id===t.id});return r&&r.impact&&t.nodes.forEach(function(t){["any","all","none"].forEach(function(e){(t[e]||[]).forEach(function(e){e.impact=r.impact})})}),Object.assign(t,dt(t.nodes)),delete t.nodes,t};var dt=function(e){var t,r={};(e=e.map(function(e){if(e.any&&e.all&&e.none)return st(e);if(Array.isArray(e.node))return ct(e);throw new TypeError("Invalid Result type")}))&&e.length?(t=e.map(function(e){return e.result}),r.result=at(Je.results,t,r.result)):r.result="inapplicable",Je.resultGroups.forEach(function(e){return r[e]=[]}),e.forEach(function(e){var t=Je.resultGroupMap[e.result];r[t].push(e)});var a,n=Je.FAIL_GROUP;return 0===r[n].length&&(n=Je.CANTTELL_GROUP),0<r[n].length?(a=r[n].map(function(e){return e.impact}),r.impact=at(Je.impact,a)||null):r.impact=null,r};function pt(e,t,r){var a=Object.assign({},t);a.nodes=(a[r]||[]).concat(),Je.resultGroups.forEach(function(e){delete a[e]}),e[r].push(a)}var ft=function(e){var r={};return Je.resultGroups.forEach(function(e){return r[e]=[]}),e.forEach(function(t){t.error?pt(r,t,Je.CANTTELL_GROUP):t.result===Je.NA?pt(r,t,Je.NA_GROUP):Je.resultGroups.forEach(function(e){Array.isArray(t[e])&&0<t[e].length&&pt(r,t,e)})}),r};var mt=function e(t,r,a){var n=window.getComputedStyle(t,null);if(!n)return!1;for(var o=0;o<r.length;++o){var i=r[o];if(n.getPropertyValue(i.property)===i.value)return!0}return!(!t.parentNode||t.nodeName.toUpperCase()===a.toUpperCase())&&e(t.parentNode,r,a)};var ht=function(e,t){if(!e)throw new Error(t)};var gt=function(e){return Array.prototype.slice.call(e)};var vt=function(e){for(var t,r=String(e),a=r.length,n=-1,o="",i=r.charCodeAt(0);++n<a;)0!=(t=r.charCodeAt(n))?o+=1<=t&&t<=31||127==t||0==n&&48<=t&&t<=57||1==n&&48<=t&&t<=57&&45==i?"\\\\"+t.toString(16)+" ":(0!=n||1!=a||45!=t)&&(128<=t||45==t||95==t||48<=t&&t<=57||65<=t&&t<=90||97<=t&&t<=122)?r.charAt(n):"\\\\"+r.charAt(n):o+="�";return o};function bt(e,t){return[e.substring(0,t),e.substring(t)]}function yt(e){return e.replace(/\\s+$/,"")}var Dt=function(){var e=0<arguments.length&&void 0!==arguments[0]?arguments[0]:"",t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{};if(!(e.length<=1||"data:"===e.substr(0,5)||"javascript:"===e.substr(0,11)||e.includes("?"))){var r,a,n,o,i,l,u,s,c,d,p,f,m,h=t.currentDomain,g=t.maxLength,v=void 0===g?25:g,b=(m=f=p=d=c="",(s=r=e).includes("#")&&(r=(a=tc(bt(r,r.indexOf("#")),2))[0],m=a[1]),r.includes("?")&&(r=(n=tc(bt(r,r.indexOf("?")),2))[0],f=n[1]),r.includes("://")?(c=(o=tc(r.split("://"),2))[0],d=(i=tc(bt(r=o[1],r.indexOf("/")),2))[0],r=i[1]):"//"===r.substr(0,2)&&(d=(l=tc(bt(r=r.substr(2),r.indexOf("/")),2))[0],r=l[1]),"www."===d.substr(0,4)&&(d=d.substr(4)),d&&d.includes(":")&&(d=(u=tc(bt(d,d.indexOf(":")),2))[0],p=u[1]),{original:s,protocol:c,domain:d,port:p,path:r,query:f,hash:m}),y=b.path,D=b.domain,w=b.hash,x=y.substr(y.substr(0,y.length-2).lastIndexOf("/")+1);if(w)return x&&(x+w).length<=v?yt(x+w):x.length<2&&2<w.length&&w.length<=v?yt(w):void 0;if(D&&D.length<v&&y.length<=1)return yt(D+y);if(y==="/"+x&&D&&h&&D!==h&&(D+y).length<=v)return yt(D+y);var E=x.lastIndexOf(".");return(-1===E||1<E)&&(-1!==E||2<x.length)&&x.length<=v&&!x.match(/index(\\.[a-zA-Z]{2-4})?/)&&!function(e){var t=0<arguments.length&&void 0!==e?e:"";return 0!==t.length&&(t.match(/[0-9]/g)||"").length>=t.length/2}(x)?yt(x):void 0}};var wt,xt=function(e){return e.attributes instanceof window.NamedNodeMap?e.attributes:e.cloneNode(!1).attributes},Et=function(e,t){return wt&&e[wt]||(wt=function(e){for(var t,r=["matches","matchesSelector","mozMatchesSelector","webkitMatchesSelector","msMatchesSelector"],a=r.length,n=0;n<a;n++)if(e[t=r[n]])return t}(e)),!!e[wt]&&e[wt](t)};var At=function(e){return!!e.createElement&&"A"===e.createElement("A").localName};var Ct,Ft=function(a,e){var n=2<arguments.length&&void 0!==arguments[2]?arguments[2]:{};if(!e)return"";var t=e.getRootNode&&e.getRootNode()||document;if(11!==t.nodeType)return a(e,n,t);for(var r=[];11===t.nodeType;){if(!t.host)return"";r.unshift({elm:e,doc:t}),t=(e=t.host).getRootNode()}return r.unshift({elm:e,doc:t}),r.map(function(e){var t=e.elm,r=e.doc;return a(t,n,r)})},kt=["class","style","id","selected","checked","disabled","tabindex","aria-checked","aria-selected","aria-invalid","aria-activedescendant","aria-busy","aria-disabled","aria-expanded","aria-grabbed","aria-pressed","aria-valuenow"],Rt=31;function Tt(e,t){var r,a=t.name;if(-1!==a.indexOf("href")||-1!==a.indexOf("src")){var n=Dt(e.getAttribute(a));if(n){var o=encodeURI(n);if(!o)return;r=vt(t.name)+\'$="\'+vt(o)+\'"\'}else r=vt(t.name)+\'="\'+vt(e.getAttribute(a))+\'"\'}else r=vt(a)+\'="\'+vt(t.value)+\'"\';return r}function Nt(e,t){return e.count<t.count?-1:e.count===t.count?0:1}function _t(e){return!kt.includes(e.name)&&-1===e.name.indexOf(":")&&(!e.value||e.value.length<Rt)}function Ot(e){for(var a={classes:{},tags:{},attributes:{}},n=(e=Array.isArray(e)?e:[e]).slice(),o=[];n.length;)!function(){var e,t=n.pop(),r=t.actualNode;for(r.querySelectorAll&&(e=r.nodeName,a.tags[e]?a.tags[e]++:a.tags[e]=1,r.classList&&Array.from(r.classList).forEach(function(e){var t=vt(e);a.classes[t]?a.classes[t]++:a.classes[t]=1}),r.hasAttributes()&&Array.from(xt(r)).filter(_t).forEach(function(e){var t=Tt(r,e);t&&(a.attributes[t]?a.attributes[t]++:a.attributes[t]=1)})),t.children.length&&(o.push(n),n=t.children.slice());!n.length&&o.length;)n=o.pop()}();return a}function St(e){return void 0===Ct&&(Ct=At(document)),vt(Ct?e.localName:e.nodeName.toLowerCase())}function Pt(e,t){var r,a,n,o,i,l,u,s,c,d,p,f="",m=(a=e,o=[],i=(n=t).classes,l=n.tags,a.classList&&Array.from(a.classList).forEach(function(e){var t=vt(e);i[t]<l[a.nodeName]&&o.push({name:t,count:i[t],species:"class"})}),o.sort(Nt)),h=(u=e,c=[],d=(s=t).attributes,p=s.tags,u.hasAttributes()&&Array.from(xt(u)).filter(_t).forEach(function(e){var t=Tt(u,e);t&&d[t]<p[u.nodeName]&&c.push({name:t,count:d[t],species:"attribute"})}),c.sort(Nt));return m.length&&1===m[0].count?r=[m[0]]:h.length&&1===h[0].count?(r=[h[0]],f=St(e)):((r=m.concat(h)).sort(Nt),(r=r.slice(0,3)).some(function(e){return"class"===e.species})?r.sort(function(e,t){return e.species!==t.species&&"class"===e.species?-1:e.species===t.species?0:1}):f=St(e)),f+r.reduce(function(e,t){switch(t.species){case"class":return e+"."+t.name;case"attribute":return e+"["+t.name+"]"}return e},"")}function It(e,t,r){if(!axe._selectorData)throw new Error("Expect axe._selectorData to be set up");var a,n,o=t.toRoot,i=void 0!==o&&o;do{var l=function(e){if(e.getAttribute("id")){var t=e.getRootNode&&e.getRootNode()||document,r="#"+vt(e.getAttribute("id")||"");return r.match(/player_uid_/)||1!==t.querySelectorAll(r).length?void 0:r}}(e);l||(l=Pt(e,axe._selectorData),l+=function(t,r){var e=t.parentNode&&Array.from(t.parentNode.children||"")||[];return e.find(function(e){return e!==t&&Et(e,r)})?":nth-child("+(1+e.indexOf(t))+")":""}(e,l)),a=a?l+" > "+a:l,n=n?n.filter(function(e){return Et(e,a)}):Array.from(r.querySelectorAll(a)),e=e.parentElement}while((1<n.length||i)&&e&&11!==e.nodeType);return 1===n.length?a:-1!==a.indexOf(" > ")?":root"+a.substring(a.indexOf(" > ")):":root"}function Bt(e,t){return Ft(It,e,t)}function Lt(e){var t=e.nodeName.toLowerCase(),r=e.parentElement;if(!r)return t;var a,n="";return"head"!==t&&"body"!==t&&1<r.children.length&&(a=Array.prototype.indexOf.call(r.children,e)+1,n=":nth-child(".concat(a,")")),Lt(r)+" > "+t+n}function qt(e,t){return Ft(Lt,e,t)}var jt=function(e){return function e(t,r){var a,n,o,i;if(!t)return[];if(!r&&9===t.nodeType)return r=[{str:"html"}];if(r=r||[],t.parentNode&&t.parentNode!==t&&(r=e(t.parentNode,r)),t.previousSibling){for(n=1,a=t.previousSibling;1===a.nodeType&&a.nodeName===t.nodeName&&n++,a=a.previousSibling;);1===n&&(n=null)}else if(t.nextSibling)for(a=t.nextSibling;a=1===a.nodeType&&a.nodeName===t.nodeName?(n=1,null):(n=null,a.previousSibling););return 1===t.nodeType&&((o={}).str=t.nodeName.toLowerCase(),(i=t.getAttribute&&vt(t.getAttribute("id")))&&1===t.ownerDocument.querySelectorAll("#"+i).length&&(o.id=t.getAttribute("id")),1<n&&(o.count=n),r.push(o)),r}(e).reduce(function(e,t){return t.id?"/".concat(t.str,"[@id=\'").concat(t.id,"\']"):e+"/".concat(t.str)+(0<t.count?"[".concat(t.count,"]"):"")},"")};function Mt(e,t,r){var a,n,o,i,l;this._fromFrame=!!r,this.spec=r||{},t&&t.absolutePaths&&(this._options={toRoot:!0}),this.source=void 0!==this.spec.source?this.spec.source:((l=(a=e).outerHTML)||"function"!=typeof XMLSerializer||(l=(new XMLSerializer).serializeToString(a)),(n=l||"").length>(o=o||300)&&(i=n.indexOf(">"),n=n.substring(0,i+1)),n),this._element=e}Mt.prototype={get selector(){return this.spec.selector||[Bt(this.element,this._options)]},get ancestry(){return this.spec.ancestry||[qt(this.element)]},get xpath(){return this.spec.xpath||[jt(this.element)]},get element(){return this._element},get fromFrame(){return this._fromFrame},toJSON:function(){return{selector:this.selector,source:this.source,xpath:this.xpath,ancestry:this.ancestry}}},Mt.fromFrame=function(e,t,r){var a=ec({},e,{selector:[].concat(Zs(r.selector),Zs(e.selector)),ancestry:[].concat(Zs(r.ancestry),Zs(e.ancestry)),xpath:[].concat(Zs(r.xpath),Zs(e.xpath))});return new Mt(r.element,t,a)};var Ut=Mt;var Vt=function(t,r,a,n){return{isAsync:!1,async:function(){return this.isAsync=!0,function(e){e instanceof Error==!1?(t.result=e,a(t)):n(e)}},data:function(e){t.data=e},relatedNodes:function(e){e=e instanceof window.Node?[e]:gt(e),t.relatedNodes=e.map(function(e){return new Ut(e,r)})}}};var Ht=function e(t){var r,a,n=t;if(null!==t&&"object"===Gs(t))if(Array.isArray(t))for(n=[],r=0,a=t.length;r<a;r++)n[r]=e(t[r]);else for(r in n={},t)n[r]=e(t[r]);return n},zt=new(a(m()).CssSelectorParser);zt.registerSelectorPseudos("not"),zt.registerNestingOperators(">"),zt.registerAttrEqualityMods("^","$","*","~");var $t=zt;function Wt(e,t){return d=t,1===(c=e).props.nodeType&&("*"===d.tag||c.props.nodeName===d.tag)&&(u=e,!(s=t).classes||s.classes.every(function(e){return u.hasClass(e.value)}))&&(i=e,!(l=t).attributes||l.attributes.every(function(e){var t=i.attr(e.key);return null!==t&&(!e.value||e.test(t))}))&&(n=e,!(o=t).id||n.props.id===o.id)&&(r=e,!((a=t).pseudos&&!a.pseudos.every(function(e){if("not"===e.name)return!Qt(r,e.expressions[0]);throw new Error("the pseudo selector "+e.name+" has not yet been implemented")})));var r,a,n,o,i,l,u,s,c,d}var Gt,Yt=(Gt=/(?=[\\-\\[\\]{}()*+?.\\\\\\^$|,#\\s])/g,function(e){return e.replace(Gt,"\\\\")}),Kt=/\\\\/g;function Xt(e){return e.map(function(e){for(var t=[],r=e.rule;r;)t.push({tag:r.tagName?r.tagName.toLowerCase():"*",combinator:r.nestingOperator?r.nestingOperator:" ",id:r.id,attributes:function(e){if(e)return e.map(function(e){var t,r,a=e.name.replace(Kt,""),n=(e.value||"").replace(Kt,"");switch(e.operator){case"^=":r=new RegExp("^"+Yt(n));break;case"$=":r=new RegExp(Yt(n)+"$");break;case"~=":r=new RegExp("(^|\\\\s)"+Yt(n)+"(\\\\s|$)");break;case"|=":r=new RegExp("^"+Yt(n)+"(-|$)");break;case"=":t=function(e){return n===e};break;case"*=":t=function(e){return e&&e.includes(n)};break;case"!=":t=function(e){return n!==e};break;default:t=function(e){return!!e}}return""===n&&/^[*$^]=$/.test(e.operator)&&(t=function(){return!1}),{key:a,value:n,test:t=t||function(e){return e&&r.test(e)}}})}(r.attrs),classes:function(e){if(e)return e.map(function(e){return{value:e=e.replace(Kt,""),regexp:new RegExp("(^|\\\\s)"+Yt(e)+"(\\\\s|$)")}})}(r.classNames),pseudos:function(e){if(e)return e.map(function(e){var t;return"not"===e.name&&(t=Xt(t=(t=e.value).selectors?t.selectors:[t])),{name:e.name,expressions:t,value:e.value}})}(r.pseudos)}),r=r.rule;return t})}function Jt(e){var t=$t.parse(e);return Xt(t=t.selectors?t.selectors:[t])}function Qt(e,t,r){for(var a=[].concat(t),n=a.pop(),o=Wt(e,n);!o&&r&&e.parent;)o=Wt(e=e.parent,n);if(a.length){if(!1===[" ",">"].includes(n.combinator))throw new Error("axe.utils.matchesExpression does not support the combinator: "+n.combinator);o=o&&Qt(e.parent,a," "===n.combinator)}return o}var Zt=function(t,e){return Jt(e).some(function(e){return Qt(t,e)})};var er=function(e,t){for(;e;){if(Zt(e,t))return e;if(void 0===e.parent)throw new TypeError("Cannot resolve parent for non-DOM nodes");e=e.parent}return null};function tr(){}function rr(e){if("function"!=typeof e)throw new TypeError("Queue methods require functions as arguments")}var ar,nr,or,ir,lr=function(){function t(e){a=e,setTimeout(function(){null!=a&&Qe("Uncaught error (of queue)",a)},1)}var a,n=[],r=0,o=0,i=tr,l=!1,u=t;function s(e){return i=tr,u(e),n}function c(){for(var e=n.length;r<e;r++){var t=n[r];try{t.call(null,function(t){return function(e){n[t]=e,--o||i===tr||(l=!0,i(n))}}(r),s)}catch(e){s(e)}}}var d={defer:function(e){var r;if("object"===Gs(e)&&e.then&&e.catch&&(r=e,e=function(e,t){r.then(e).catch(t)}),rr(e),void 0===a){if(l)throw new Error("Queue already completed");return n.push(e),++o,c(),d}},then:function(e){if(rr(e),i!==tr)throw new Error("queue `then` already set");return a||(i=e,o||(l=!0,i(n))),d},catch:function(e){if(rr(e),u!==t)throw new Error("queue `catch` already set");return a?(e(a),a=null):u=e,d},abort:s};return d},ur=window.crypto||window.msCrypto;!or&&ur&&ur.getRandomValues&&(nr=new Uint8Array(16),or=function(){return ur.getRandomValues(nr),nr}),or||(ir=new Array(16),or=function(){for(var e,t=0;t<16;t++)0==(3&t)&&(e=4294967296*Math.random()),ir[t]=e>>>((3&t)<<3)&255;return ir});for(var sr="function"==typeof window.Buffer?window.Buffer:Array,cr=[],dr={},pr=0;pr<256;pr++)cr[pr]=(pr+256).toString(16).substr(1),dr[cr[pr]]=pr;function fr(e,t){var r=t||0;return cr[e[r++]]+cr[e[r++]]+cr[e[r++]]+cr[e[r++]]+"-"+cr[e[r++]]+cr[e[r++]]+"-"+cr[e[r++]]+cr[e[r++]]+"-"+cr[e[r++]]+cr[e[r++]]+"-"+cr[e[r++]]+cr[e[r++]]+cr[e[r++]]+cr[e[r++]]+cr[e[r++]]+cr[e[r++]]}var mr=or(),hr=[1|mr[0],mr[1],mr[2],mr[3],mr[4],mr[5]],gr=16383&(mr[6]<<8|mr[7]),vr=0,br=0;function yr(e,t,r){var a=t&&r||0,n=t||[],o=null!=(e=e||{}).clockseq?e.clockseq:gr,i=null!=e.msecs?e.msecs:(new Date).getTime(),l=null!=e.nsecs?e.nsecs:br+1,u=i-vr+(l-br)/1e4;if(u<0&&null==e.clockseq&&(o=o+1&16383),(u<0||vr<i)&&null==e.nsecs&&(l=0),1e4<=l)throw new Error("uuid.v1(): Can\'t create more than 10M uuids/sec");vr=i,gr=o;var s=(1e4*(268435455&(i+=122192928e5))+(br=l))%4294967296;n[a++]=s>>>24&255,n[a++]=s>>>16&255,n[a++]=s>>>8&255,n[a++]=255&s;var c=i/4294967296*1e4&268435455;n[a++]=c>>>8&255,n[a++]=255&c,n[a++]=c>>>24&15|16,n[a++]=c>>>16&255,n[a++]=o>>>8|128,n[a++]=255&o;for(var d=e.node||hr,p=0;p<6;p++)n[a+p]=d[p];return t||fr(n)}function Dr(e,t,r){var a=t&&r||0;"string"==typeof e&&(t="binary"==e?new sr(16):null,e=null);var n=(e=e||{}).random||(e.rng||or)();if(n[6]=15&n[6]|64,n[8]=63&n[8]|128,t)for(var o=0;o<16;o++)t[a+o]=n[o];return t||fr(n)}(ar=Dr).v1=yr,ar.v4=Dr,ar.parse=function(e,t,r){var a=t&&r||0,n=0;for(t=t||[],e.toLowerCase().replace(/[0-9a-f]{2}/g,function(e){n<16&&(t[a+n++]=dr[e])});n<16;)t[a+n++]=0;return t},ar.unparse=fr,ar.BufferClass=sr,axe._uuid=yr();var wr={},xr={set:function(e,t){wr[e]=t},get:function(e){return wr[e]},clear:function(){wr={}}},Er={},Ar={},Cr=Object.freeze(["EvalError","RangeError","ReferenceError","SyntaxError","TypeError","URIError"]);function Fr(){var e="axeAPI",t="";return void 0!==axe&&axe._audit&&axe._audit.application&&(e=axe._audit.application),void 0!==axe&&(t=axe.version),e+"."+t}function kr(e,t,r,a,n,o){var i;r instanceof Error&&(i={name:r.name,message:r.message,stack:r.stack},r=void 0);var l={uuid:a,topic:t,message:r,error:i,_respondable:!0,_source:Fr(),_axeuuid:axe._uuid,_keepalive:n},u=xr.get("axeRespondables");u||(u={},xr.set("axeRespondables",u)),u[a]=!0,"function"==typeof o&&(Er[a]=o),e.postMessage(JSON.stringify(l),"*")}function Rr(e,t,r,a,n){kr(e,t,r,yr(),a,n)}function Tr(a,n,o){return function(e,t,r){kr(a,n,e,o,t,r)}}function Nr(e,t,r){var a,n=t.topic,o=Ar[n];o&&(a=Tr(e,null,t.uuid),o(t.message,r,a))}function _r(e){var t,r,a,n,o;if("string"==typeof e){try{t=JSON.parse(e)}catch(e){}if(function(e){if("object"===Gs(e)&&"string"==typeof e.uuid&&!0===e._respondable){var t=Fr();return e._source===t||"axeAPI.x.y.z"===e._source||"axeAPI.x.y.z"===t}}(t))return"object"===Gs(t.error)?t.error=(r=t.error,a=r.message||"Unknown error occurred",n=Cr.includes(r.name)?r.name:"Error",o=window[n]||Error,r.stack&&(a+="\\n"+r.stack.replace(r.message,"")),new o(a)):t.error=void 0,t}}Rr.subscribe=function(e,t){Ar[e]=t},Rr.isInFrame=function(e){return!!(e=e||window).frameElement},Rr._publish=Nr,"function"==typeof window.addEventListener&&window.addEventListener("message",function(t){var e=_r(t.data);if(e&&e._axeuuid){var r=e.uuid;if(!(xr.get("axeRespondables")||{})[r]||e._axeuuid!==axe._uuid){var a=e._keepalive,n=Er[r];if(n&&(n(e.error||e.message,a,Tr(t.source,e.topic,r)),a||delete Er[r]),!e.error)try{Nr(t.source,e,a)}catch(e){kr(t.source,null,e,r,!1)}}}},!1);var Or=Rr;function Sr(e,t){var r;return axe._tree&&(r=Bt(t)),new Error(e+": "+(r||t))}var Pr=function(t,r,a,n){var o=t.contentWindow;if(!o)return Qe("Frame does not have a content window",t),void a(null);var i=setTimeout(function(){i=setTimeout(function(){r.debug?n(Sr("No response from frame",t)):a(null)},0)},500);Or(o,"axe.ping",null,void 0,function(){clearTimeout(i);var e=r.options&&r.options.frameWaitTime||6e4;i=setTimeout(function(){n(Sr("Axe in frame timed out",t))},e),Or(o,"axe.start",r,void 0,function(e){clearTimeout(i),(e instanceof Error==!1?a:n)(e)})})};var Ir=function(e){return[].concat(e.any||[]).concat(e.all||[]).concat(e.none||[])};var Br=function(e,t){return(e=e.actualNode||e)===(t=t.actualNode||t)?0:4&e.compareDocumentPosition(t)?-1:1};var Lr=function(e,t,r){if(Array.isArray(e))return e.find(function(e){return"object"===Gs(e)&&e[t]===r})};var qr=function(e,i){var l=[];return e.forEach(function(e){var t,r,o,a=(t=e)&&t.results?Array.isArray(t.results)?t.results.length?t.results:null:[t.results]:null;a&&a.length&&(e.frameElement&&(r={selector:[e.frame]},o=new Ut(e.frameElement,i,r)),a.forEach(function(e){var t,r,a;e.nodes&&o&&(t=e.nodes,r=o,a=i,t.forEach(function(e){e.node=Ut.fromFrame(e.node,a,r),Ir(e).forEach(function(e){e.relatedNodes=e.relatedNodes.map(function(e){return Ut.fromFrame(e,a,r)})})}));var n=Lr(l,"id",e.id);n?e.nodes.length&&function(e,t){for(var r=t[0].node,a=0;a<e.length;a++){var n=e[a].node,o=Br({actualNode:n.element},{actualNode:r.element});if(0<o||0===o&&r.selector.length<n.selector.length)return e.splice.apply(e,[a,0].concat(t))}e.push.apply(e,t)}(n.nodes,e.nodes):l.push(e)}))}),1<e.length&&window&&window.Node&&l.forEach(function(e){e.nodes&&e.nodes.sort(function(e,t){var r=e.node.element,a=t.node.element;return r!==a&&(e.node._fromFrame||t.node._fromFrame)?Br(r,a):0})}),l};var jr=function(e,t,r,o,a,n){var i=lr();e.frames.forEach(function(a){var n={options:t,command:r,parameter:o,context:{initiator:!1,page:e.page,include:a.include||[],exclude:a.exclude||[]}};i.defer(function(t,e){var r=a.node;Pr(r,n,function(e){return e?t({results:e,frameElement:r,frame:Bt(r)}):void t(null)},e)})}),i.then(function(e){a(qr(e,t))}).catch(n)};var Mr=function(e,t){if(e.shadowId||t.shadowId)return function t(e,r){return e.shadowId===r.shadowId||!!e.children.find(function(e){return t(e,r)})}(e,t);if(e.actualNode)return"function"==typeof e.actualNode.contains?e.actualNode.contains(t.actualNode):!!(16&e.actualNode.compareDocumentPosition(t.actualNode));do{if(t===e)return!0}while(t=t&&t.parent);return!1};var Ur=function n(){for(var o={},e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];return t.forEach(function(e){if(e&&"object"===Gs(e)&&!Array.isArray(e))for(var t=0,r=Object.keys(e);t<r.length;t++){var a=r[t];!o.hasOwnProperty(a)||"object"!==Gs(e[a])||Array.isArray(o[a])?o[a]=e[a]:o[a]=n(o[a],e[a])}}),o};var Vr=function(t,r){Object.assign(t,r),Object.keys(r).filter(function(e){return"function"==typeof r[e]}).forEach(function(e){t[e]=null;try{t[e]=r[e](t)}catch(e){}})},Hr=["article","aside","blockquote","body","div","footer","h1","h2","h3","h4","h5","h6","header","main","nav","p","section","span"];var zr=function(e){if(e.shadowRoot){var t=e.nodeName.toLowerCase();if(Hr.includes(t)||/^[a-z][a-z0-9_.-]*-[a-z0-9_.-]*$/.test(t))return!0}return!1},$r={};t($r,{findElmsInContext:function(){return Yr},findUp:function(){return Xr},findUpVirtual:function(){return Kr},getComposedParent:function(){return Jr},getElementByReference:function(){return Qr},getElementCoordinates:function(){return ea},getElementStack:function(){return ma},getRootNode:function(){return Gr},getScrollOffset:function(){return Zr},getTabbableElements:function(){return ha},getTextElementStack:function(){return va},getViewportSize:function(){return ta},hasContent:function(){return Ca},hasContentVirtual:function(){return Aa},idrefs:function(){return Da},insertedIntoFocusOrder:function(){return Oa},isFocusable:function(){return _a},isHTML5:function(){return Sa},isHiddenWithCSS:function(){return Ra},isInTextBlock:function(){return Ba},isModalOpen:function(){return La},isNativelyFocusable:function(){return Na},isNode:function(){return qa},isOffscreen:function(){return ra},isOpaque:function(){return Xa},isSkipLink:function(){return Qa},isVisible:function(){return ia},isVisualContent:function(){return ya},reduceToElementsBelowFloating:function(){return Za},shadowElementsFromPoint:function(){return rn},urlPropsFromAttribute:function(){return an},visuallyContains:function(){return tn},visuallyOverlaps:function(){return on}});var Wr=function(e){var t=e.getRootNode&&e.getRootNode()||document;return t===e&&(t=document),t},Gr=Wr;var Yr=function(e){var t=e.context,r=e.value,a=e.attr,n=e.elm,o=void 0===n?"":n,i=vt(r),l=9===t.nodeType||11===t.nodeType?t:Gr(t);return Array.from(l.querySelectorAll(o+"["+a+"="+i+"]"))};var Kr=function(e,t){var r=e.actualNode;if(!e.shadowId&&"function"==typeof e.actualNode.closest){var a=e.actualNode.closest(t);return a?a:null}for(;(r=r.assignedSlot?r.assignedSlot:r.parentNode)&&11===r.nodeType&&(r=r.host),r&&!Et(r,t)&&r!==document.documentElement;);return r&&Et(r,t)?r:null};var Xr=function(e,t){return Kr(wn(e),t)};var Jr=function e(t){if(t.assignedSlot)return e(t.assignedSlot);if(t.parentNode){var r=t.parentNode;if(1===r.nodeType)return r;if(r.host)return r.host}return null};var Qr=function(e,t){var r=e.getAttribute(t);if(!r)return null;"#"===r.charAt(0)?r=decodeURIComponent(r.substring(1)):"/#"===r.substr(0,2)&&(r=decodeURIComponent(r.substring(2)));var a=document.getElementById(r);return a||((a=document.getElementsByName(r)).length?a[0]:null)};var Zr=function(e){if(!e.nodeType&&e.document&&(e=e.document),9!==e.nodeType)return{left:e.scrollLeft,top:e.scrollTop};var t=e.documentElement,r=e.body;return{left:t&&t.scrollLeft||r&&r.scrollLeft||0,top:t&&t.scrollTop||r&&r.scrollTop||0}};var ea=function(e){var t=Zr(document),r=t.left,a=t.top,n=e.getBoundingClientRect();return{top:n.top+a,right:n.right+r,bottom:n.bottom+a,left:n.left+r,width:n.right-n.left,height:n.bottom-n.top}};var ta=function(e){var t=e.document,r=t.documentElement;if(e.innerWidth)return{width:e.innerWidth,height:e.innerHeight};if(r)return{width:r.clientWidth,height:r.clientHeight};var a=t.body;return{width:a.clientWidth,height:a.clientHeight}};var ra=function(e){var t,r=document.documentElement,a=window.getComputedStyle(e),n=window.getComputedStyle(document.body||r).getPropertyValue("direction"),o=ea(e);if(o.bottom<0&&(function(e,t){for(e=Jr(e);e&&"html"!==e.nodeName.toLowerCase();){if(e.scrollTop&&0<=(t+=e.scrollTop))return;e=Jr(e)}return 1}(e,o.bottom)||"absolute"===a.position))return!0;if(0===o.left&&0===o.right)return!1;if("ltr"===n){if(o.right<=0)return!0}else if(t=Math.max(r.scrollWidth,ta(window).width),o.left>=t)return!0;return!1},aa=/rect\\s*\\(([0-9]+)px,?\\s*([0-9]+)px,?\\s*([0-9]+)px,?\\s*([0-9]+)px\\s*\\)/,na=/(\\w+)\\((\\d+)/;function oa(e,t,r){if(!e)throw new TypeError("Cannot determine if element is visible for non-DOM nodes");var a=wn(e),n="_isVisible"+(t?"ScreenReader":"");if(9===e.nodeType)return!0;if(11===e.nodeType&&(e=e.host),a&&void 0!==a[n])return a[n];var o=window.getComputedStyle(e,null);if(null===o)return!1;var i=e.nodeName.toUpperCase();if("AREA"===i)return function(e,t,r){var a=Xr(e,"map");if(!a)return!1;var n=a.getAttribute("name");if(!n)return!1;var o=Gr(e);if(!o||9!==o.nodeType)return!1;var i=no(axe._tree,\'img[usemap="#\'.concat(vt(n),\'"]\'));return!(!i||!i.length)&&i.some(function(e){return oa(e.actualNode,t,r)})}(e,t,r);if("none"===o.getPropertyValue("display")||["STYLE","SCRIPT","NOSCRIPT","TEMPLATE"].includes(i))return!1;if(t&&"true"===e.getAttribute("aria-hidden"))return!1;if(!t&&(function(e){var t=e.getPropertyValue("clip").match(aa),r=e.getPropertyValue("clip-path").match(na);if(t&&5===t.length)return t[3]-t[1]<=0&&t[2]-t[4]<=0;if(r){var a=r[1],n=parseInt(r[2],10);switch(a){case"inset":return 50<=n;case"circle":return 0===n}}}(o)||"0"===o.getPropertyValue("opacity")||xn(e)&&0===parseInt(o.getPropertyValue("height"))))return!1;if(!r&&("hidden"===o.getPropertyValue("visibility")||!t&&ra(e)))return!1;var l=e.assignedSlot?e.assignedSlot:e.parentNode,u=!1;return l&&(u=oa(l,t,!0)),a&&(a[n]=u),u}var ia=oa,la=200;function ua(e){return"static"===e.getComputedStylePropertyValue("position")?-1!==e.getComputedStylePropertyValue("display").indexOf("inline")?2:function e(t){if(!t)return!1;if(void 0!==t._isFloated)return t._isFloated;if("none"!==t.getComputedStylePropertyValue("float"))return t._isFloated=!0;var r=e(t.parent);return t._isFloated=r}(e)?1:0:3}function sa(e,t){for(var r=0;r<e._stackingOrder.length;r++){if(void 0===t._stackingOrder[r])return-1;if(t._stackingOrder[r]>e._stackingOrder[r])return 1;if(t._stackingOrder[r]<e._stackingOrder[r])return-1}var a=e.actualNode,n=t.actualNode;if(a.getRootNode&&a.getRootNode()!==n.getRootNode()){for(var o=[];a;)o.push({root:a.getRootNode(),node:a}),a=a.getRootNode().host;for(;n&&!o.find(function(e){return e.root===n.getRootNode()});)n=n.getRootNode().host;if((a=o.find(function(e){return e.root===n.getRootNode()}).node)===n)return e.actualNode.getRootNode()!==a.getRootNode()?-1:1}var i=window.Node,l=i.DOCUMENT_POSITION_FOLLOWING,u=i.DOCUMENT_POSITION_CONTAINS,s=i.DOCUMENT_POSITION_CONTAINED_BY,c=a.compareDocumentPosition(n),d=c&l?1:-1,p=c&u||c&s,f=ua(e),m=ua(t);return f===m||p?d:m-f}function ca(e,t){var r=t._stackingOrder.slice(),a=e.getComputedStylePropertyValue("z-index");return"auto"!==a&&(r[r.length-1]=parseInt(a)),function(e,t){var r=e.getComputedStylePropertyValue("position"),a=e.getComputedStylePropertyValue("z-index");if("fixed"===r||"sticky"===r)return 1;if("auto"!==a&&"static"!==r)return 1;if("1"!==e.getComputedStylePropertyValue("opacity"))return 1;if("none"!==(e.getComputedStylePropertyValue("-webkit-transform")||e.getComputedStylePropertyValue("-ms-transform")||e.getComputedStylePropertyValue("transform")||"none"))return 1;var n=e.getComputedStylePropertyValue("mix-blend-mode");if(n&&"normal"!==n)return 1;var o=e.getComputedStylePropertyValue("filter");if(o&&"none"!==o)return 1;var i=e.getComputedStylePropertyValue("perspective");if(i&&"none"!==i)return 1;var l=e.getComputedStylePropertyValue("clip-path");if(l&&"none"!==l)return 1;if("none"!==(e.getComputedStylePropertyValue("-webkit-mask")||e.getComputedStylePropertyValue("mask")||"none"))return 1;if("none"!==(e.getComputedStylePropertyValue("-webkit-mask-image")||e.getComputedStylePropertyValue("mask-image")||"none"))return 1;if("none"!==(e.getComputedStylePropertyValue("-webkit-mask-border")||e.getComputedStylePropertyValue("mask-border")||"none"))return 1;if("isolate"===e.getComputedStylePropertyValue("isolation"))return 1;var u=e.getComputedStylePropertyValue("will-change");if("transform"===u||"opacity"===u)return 1;if("touch"===e.getComputedStylePropertyValue("-webkit-overflow-scrolling"))return 1;var s=e.getComputedStylePropertyValue("contain");if(["layout","paint","strict","content"].includes(s))return 1;if("auto"!==a&&t){var c=t.getComputedStylePropertyValue("display");if(["flex","inline-flex","inline flex","grid","inline-grid","inline grid"].includes(c))return 1}}(e,t)&&r.push(0),r}function da(s,c){c._grid=s,c.clientRects.forEach(function(e){for(var t=e.left,r=e.top,a=r/la|0,n=t/la|0,o=(r+e.height)/la|0,i=(t+e.width)/la|0,l=a;l<=o;l++){s.cells[l]=s.cells[l]||[];for(var u=n;u<=i;u++)s.cells[l][u]=s.cells[l][u]||[],s.cells[l][u].includes(c)||s.cells[l][u].push(c)}})}function pa(e,t,r){var a,n,o=0<arguments.length&&void 0!==e?e:document.body,i=1<arguments.length&&void 0!==t?t:{container:null,cells:[]},l=2<arguments.length&&void 0!==r?r:null;l||((n=(n=wn(document.documentElement))||new ln(document.documentElement))._stackingOrder=[0],da(i,n),xn(n.actualNode)&&(a={container:n,cells:[]},n._subGrid=a));for(var u=document.createTreeWalker(o,window.NodeFilter.SHOW_ELEMENT,null,!1),s=l?u.nextNode():u.currentNode;s;){var c=wn(s);s.parentElement?l=wn(s.parentElement):s.parentNode&&wn(s.parentNode)&&(l=wn(s.parentNode)),(c=c||new axe.VirtualNode(s,l))._stackingOrder=ca(c,l);var d,p=function(e,t){for(var r=null,a=[e];t;){if(t._scrollRegionParent){r=t._scrollRegionParent;break}if(xn(t.actualNode)){r=t;break}a.push(t),t=wn(t.actualNode.parentElement||t.actualNode.parentNode)}return a.forEach(function(e){return e._scrollRegionParent=r}),r}(c,l),f=p?p._subGrid:i;xn(c.actualNode)&&(d={container:c,cells:[]},c._subGrid=d);var m=c.boundingClientRect;0!==m.width&&0!==m.height&&ia(s)&&da(f,c),zr(s)&&pa(s.shadowRoot,f,c),s=u.nextNode()}}function fa(e,t,r){var a=2<arguments.length&&void 0!==r&&r,n=t.left+t.width/2,o=t.top+t.height/2,i=o/la|0,l=n/la|0,u=e.cells[i][l].filter(function(e){return e.clientRects.find(function(e){var t=e.left,r=e.top;return n<=t+e.width&&t<=n&&o<=r+e.height&&r<=o})}),s=e.container;return s&&(u=fa(s._grid,s.boundingClientRect,!0).concat(u)),a||(u=u.sort(sa).map(function(e){return e.actualNode}).concat(document.documentElement).filter(function(e,t,r){return r.indexOf(e)===t})),u}var ma=function(e){xr.get("gridCreated")||(pa(),xr.set("gridCreated",!0));var t=wn(e),r=t._grid;return r?fa(r,t.boundingClientRect):[]};var ha=function(e){return no(e,"*").filter(function(e){var t=e.isFocusable,r=e.actualNode.getAttribute("tabindex");return(r=r&&!isNaN(parseInt(r,10))?parseInt(r):null)?t&&0<=r:t})};var ga=function(e){return e?e.replace(/\\r\\n/g,"\\n").replace(/\\u00A0/g," ").replace(/[\\s]{2,}/g," ").trim():""};var va=function(e){xr.get("gridCreated")||(pa(),xr.set("gridCreated",!0));var t=wn(e),r=t._grid;if(!r)return[];var o=t.boundingClientRect,i=[];return Array.from(e.childNodes).forEach(function(e){if(3===e.nodeType&&""!==ga(e.textContent)){var t=document.createRange();t.selectNodeContents(e);var r=t.getClientRects();if(Array.from(r).some(function(e){return e.width>o.width}))return;for(var a=0;a<r.length;a++){var n=r[a];1<=n.width&&1<=n.height&&i.push(n)}}}),i.length?i.map(function(e){return fa(r,e)}):[ma(e)]},ba=["checkbox","img","radio","range","slider","spinbutton","textbox"];var ya=function(e){var t=e.getAttribute("role");if(t)return-1!==ba.indexOf(t);switch(e.nodeName.toUpperCase()){case"IMG":case"IFRAME":case"OBJECT":case"VIDEO":case"AUDIO":case"CANVAS":case"SVG":case"MATH":case"BUTTON":case"SELECT":case"TEXTAREA":case"KEYGEN":case"PROGRESS":case"METER":return!0;case"INPUT":return"hidden"!==e.type;default:return!1}};var Da=function(e,t){e=e.actualNode||e;try{var r=Gr(e),a=[],n=e.getAttribute(t);if(n){n=so(n);for(var o=0;o<n.length;o++)a.push(r.getElementById(n[o]))}return a}catch(e){throw new TypeError("Cannot resolve id references for non-DOM nodes")}};var wa=function n(e,o,i){var t=e instanceof tt?e:wn(e),l=!e.actualNode||e.actualNode&&ia(e.actualNode,o),r=t.children.map(function(e){var t=e.props,r=t.nodeType,a=t.nodeValue;if(3===r){if(a&&l)return a}else if(!i)return n(e,o)}).join("");return ga(r)};var xa=function(e){var t;return e.attr("aria-labelledby")&&(t=Da(e.actualNode,"aria-labelledby").map(function(e){var t=wn(e);return t?wa(t,!0):""}).join(" ").trim())||(t=(t=e.attr("aria-label"))&&ga(t))?t:null},Ea=["HEAD","TITLE","TEMPLATE","SCRIPT","STYLE","IFRAME","OBJECT","VIDEO","AUDIO","NOSCRIPT"];var Aa=function t(e,r,a){return function(e){if(!Ea.includes(e.actualNode.nodeName.toUpperCase()))return e.children.some(function(e){var t=e.actualNode;return 3===t.nodeType&&t.nodeValue.trim()})}(e)||ya(e.actualNode)||!a&&!!xa(e)||!r&&e.children.some(function(e){return 1===e.actualNode.nodeType&&t(e)})};var Ca=function(e,t,r){return e=wn(e),Aa(e,t,r)};function Fa(e,t){var r=wn(e);return r?(void 0===r._isHiddenWithCSS&&(r._isHiddenWithCSS=ka(e,t)),r._isHiddenWithCSS):ka(e,t)}function ka(e,t){if(9===e.nodeType)return!1;if(11===e.nodeType&&(e=e.host),["STYLE","SCRIPT"].includes(e.nodeName.toUpperCase()))return!1;var r=window.getComputedStyle(e,null);if(!r)throw new Error("Style does not exist for the given element.");if("none"===r.getPropertyValue("display"))return!0;var a=["hidden","collapse"],n=r.getPropertyValue("visibility");if(a.includes(n)&&!t)return!0;if(a.includes(n)&&t&&a.includes(t))return!0;var o=Jr(e);return!(!o||a.includes(n))&&Fa(o,n)}var Ra=Fa;var Ta=function(e){var t=e instanceof tt?e:wn(e);return!!t.hasAttr("disabled")||"area"!==t.props.nodeName&&(!!t.actualNode&&Ra(t.actualNode))};var Na=function(e){var t=e instanceof tt?e:wn(e);if(!t||Ta(t))return!1;switch(t.props.nodeName){case"a":case"area":if(t.hasAttr("href"))return!0;break;case"input":return"hidden"!==t.props.type;case"textarea":case"select":case"summary":case"button":return!0;case"details":return!no(t,"summary").length}return!1};var _a=function(e){var t=e instanceof tt?e:wn(e);if(Ta(t))return!1;if(Na(t))return!0;var r=t.attr("tabindex");return!(!r||isNaN(parseInt(r,10)))};var Oa=function(e){return-1<parseInt(e.getAttribute("tabindex"),10)&&_a(e)&&!Na(e)};var Sa=function(e){var t=e.doctype;return null!==t&&("html"===t.name&&!t.publicId&&!t.systemId)};var Pa=["block","list-item","table","flex","grid","inline-block"];function Ia(e){var t=window.getComputedStyle(e).getPropertyValue("display");return Pa.includes(t)||"table-"===t.substr(0,6)}var Ba=function(r){if(Ia(r))return!1;var e=function(e){for(var t=Jr(e);t&&!Ia(t);)t=Jr(t);return wn(t)}(r),a="",n="",o=0;return function t(e,r){!1!==r(e.actualNode)&&e.children.forEach(function(e){return t(e,r)})}(e,function(e){if(2===o)return!1;if(3===e.nodeType&&(a+=e.nodeValue),1===e.nodeType){var t=(e.nodeName||"").toUpperCase();if(["BR","HR"].includes(t))0===o?n=a="":o=2;else{if("none"===e.style.display||"hidden"===e.style.overflow||!["",null,"none"].includes(e.style.float)||!["",null,"relative"].includes(e.style.position))return!1;if("A"===t&&e.href||"link"===(e.getAttribute("role")||"").toLowerCase())return e===r&&(o=1),n+=e.textContent,!1}}}),a=ga(a),n=ga(n),a.length>n.length};var La=function(e){var t=(e=e||{}).modalPercent||.75;if(xr.get("isModalOpen"))return xr.get("isModalOpen");if(Yn(axe._tree[0],"dialog, [role=dialog], [aria-modal=true]",function(e){return ia(e.actualNode)}).length)return xr.set("isModalOpen",!0),!0;for(var r=ta(window),a=r.width*t,n=r.height*t,o=(r.width-a)/2,i=(r.height-n)/2,l=[{x:o,y:i},{x:r.width-o,y:i},{x:r.width/2,y:r.height/2},{x:o,y:r.height-i},{x:r.width-o,y:r.height-i}].map(function(e){return Array.from(document.elementsFromPoint(e.x,e.y))}),u=0;u<l.length;u++){var s=function(e){var t=l[e].find(function(e){var t=window.getComputedStyle(e);return parseInt(t.width,10)>=a&&parseInt(t.height,10)>=n&&"none"!==t.getPropertyValue("pointer-events")&&("absolute"===t.position||"fixed"===t.position)});if(t&&l.every(function(e){return e.includes(t)}))return xr.set("isModalOpen",!0),{v:!0}}(u);if("object"===Gs(s))return s.v}xr.set("isModalOpen",void 0)};var qa=function(e){return e instanceof window.Node},ja={},Ma={set:function(e,t){if("string"!=typeof e)throw new Error("Incomplete data: key must be a string");return t&&(ja[e]=t),ja[e]},get:function(e){return ja[e]},clear:function(){ja={}}};var Ua=function(e,t){var r=e.nodeName.toUpperCase();if(["IMG","CANVAS","OBJECT","IFRAME","VIDEO","SVG"].includes(r))return Ma.set("bgColor","imgNode"),!0;var a,n=(t=t||window.getComputedStyle(e)).getPropertyValue("background-image"),o="none"!==n;return o&&(a=/gradient/.test(n),Ma.set("bgColor",a?"bgGradient":"bgImage")),o},Va={alert:{type:"widget",allowedAttrs:["aria-expanded"],superclassRole:["section"]},alertdialog:{type:"widget",allowedAttrs:["aria-expanded","aria-modal"],superclassRole:["alert","dialog"],accessibleNameRequired:!0},application:{type:"landmark",allowedAttrs:["aria-activedescendant","aria-expanded"],superclassRole:["structure"],accessibleNameRequired:!0},article:{type:"structure",allowedAttrs:["aria-posinset","aria-setsize","aria-expanded"],superclassRole:["document"]},banner:{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},blockquote:{type:"structure",superclassRole:["section"]},button:{type:"widget",allowedAttrs:["aria-expanded","aria-pressed"],superclassRole:["command"],accessibleNameRequired:!0,nameFromContent:!0},caption:{type:"structure",requiredContext:["figure","table","grid","treegrid"],superclassRole:["section"]},cell:{type:"structure",requiredContext:["row"],allowedAttrs:["aria-colindex","aria-colspan","aria-rowindex","aria-rowspan","aria-expanded"],superclassRole:["section"],nameFromContent:!0},checkbox:{type:"widget",allowedAttrs:["aria-checked","aria-readonly","aria-required"],superclassRole:["input"],accessibleNameRequired:!0,nameFromContent:!0},code:{type:"structure",superclassRole:["section"]},columnheader:{type:"structure",requiredContext:["row"],allowedAttrs:["aria-sort","aria-colindex","aria-colspan","aria-expanded","aria-readonly","aria-required","aria-rowindex","aria-rowspan","aria-selected"],superclassRole:["cell","gridcell","sectionhead"],accessibleNameRequired:!1,nameFromContent:!0},combobox:{type:"composite",requiredOwned:["listbox","tree","grid","dialog","textbox"],requiredAttrs:["aria-expanded"],allowedAttrs:["aria-controls","aria-autocomplete","aria-readonly","aria-required","aria-activedescendant","aria-orientation"],superclassRole:["select"],accessibleNameRequired:!0},command:{type:"abstract",superclassRole:["widget"]},complementary:{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},composite:{type:"abstract",superclassRole:["widget"]},contentinfo:{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},definition:{type:"structure",allowedAttrs:["aria-expanded"],superclassRole:["section"]},deletion:{type:"structure",superclassRole:["section"]},dialog:{type:"widget",allowedAttrs:["aria-expanded","aria-modal"],superclassRole:["window"],accessibleNameRequired:!0},directory:{type:"structure",allowedAttrs:["aria-expanded"],superclassRole:["list"],nameFromContent:!0},document:{type:"structure",allowedAttrs:["aria-expanded"],superclassRole:["structure"]},emphasis:{type:"structure",superclassRole:["section"]},feed:{type:"structure",requiredOwned:["article"],allowedAttrs:["aria-expanded"],superclassRole:["list"]},figure:{type:"structure",allowedAttrs:["aria-expanded"],superclassRole:["section"],nameFromContent:!0},form:{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},grid:{type:"composite",requiredOwned:["rowgroup","row"],allowedAttrs:["aria-level","aria-multiselectable","aria-readonly","aria-activedescendant","aria-colcount","aria-expanded","aria-rowcount"],superclassRole:["composite","table"],accessibleNameRequired:!1},gridcell:{type:"widget",requiredContext:["row"],allowedAttrs:["aria-readonly","aria-required","aria-selected","aria-colindex","aria-colspan","aria-expanded","aria-rowindex","aria-rowspan"],superclassRole:["cell","widget"],nameFromContent:!0},group:{type:"structure",allowedAttrs:["aria-activedescendant","aria-expanded"],superclassRole:["section"]},heading:{type:"structure",requiredAttrs:["aria-level"],allowedAttrs:["aria-expanded"],superclassRole:["sectionhead"],accessibleNameRequired:!1,nameFromContent:!0},img:{type:"structure",allowedAttrs:["aria-expanded"],superclassRole:["section"],accessibleNameRequired:!0},input:{type:"abstract",superclassRole:["widget"]},insertion:{type:"structure",superclassRole:["section"]},landmark:{type:"abstract",superclassRole:["section"]},link:{type:"widget",allowedAttrs:["aria-expanded"],superclassRole:["command"],accessibleNameRequired:!0,nameFromContent:!0},list:{type:"structure",requiredOwned:["listitem"],allowedAttrs:["aria-expanded"],superclassRole:["section"]},listbox:{type:"composite",requiredOwned:["option"],allowedAttrs:["aria-multiselectable","aria-readonly","aria-required","aria-activedescendant","aria-expanded","aria-orientation"],superclassRole:["select"],accessibleNameRequired:!0},listitem:{type:"structure",requiredContext:["list"],allowedAttrs:["aria-level","aria-posinset","aria-setsize","aria-expanded"],superclassRole:["section"],nameFromContent:!0},log:{type:"widget",allowedAttrs:["aria-expanded"],superclassRole:["section"]},main:{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},marquee:{type:"widget",allowedAttrs:["aria-expanded"],superclassRole:["section"]},math:{type:"structure",allowedAttrs:["aria-expanded"],superclassRole:["section"]},menu:{type:"composite",requiredOwned:["menuitemradio","menuitem","menuitemcheckbox"],allowedAttrs:["aria-activedescendant","aria-expanded","aria-orientation"],superclassRole:["select"]},menubar:{type:"composite",requiredOwned:["menuitemradio","menuitem","menuitemcheckbox"],allowedAttrs:["aria-activedescendant","aria-expanded","aria-orientation"],superclassRole:["menu"]},menuitem:{type:"widget",requiredContext:["menu","menubar"],allowedAttrs:["aria-posinset","aria-setsize","aria-expanded"],superclassRole:["command"],accessibleNameRequired:!0,nameFromContent:!0},menuitemcheckbox:{type:"widget",requiredContext:["menu","menubar"],allowedAttrs:["aria-checked","aria-posinset","aria-readonly","aria-setsize"],superclassRole:["checkbox","menuitem"],accessibleNameRequired:!0,nameFromContent:!0},menuitemradio:{type:"widget",requiredContext:["menu","menubar","group"],allowedAttrs:["aria-checked","aria-posinset","aria-readonly","aria-setsize"],superclassRole:["menuitemcheckbox","radio"],accessibleNameRequired:!0,nameFromContent:!0},meter:{type:"structure",allowedAttrs:["aria-valuetext"],requiredAttrs:["aria-valuemax","aria-valuemin","aria-valuenow"],superclassRole:["range"],accessibleNameRequired:!0},navigation:{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},none:{type:"structure",superclassRole:["structure"]},note:{type:"structure",allowedAttrs:["aria-expanded"],superclassRole:["section"]},option:{type:"widget",requiredContext:["listbox"],allowedAttrs:["aria-selected","aria-checked","aria-posinset","aria-setsize"],superclassRole:["input"],accessibleNameRequired:!0,nameFromContent:!0},paragraph:{type:"structure",superclassRole:["section"]},presentation:{type:"structure",superclassRole:["structure"]},progressbar:{type:"widget",allowedAttrs:["aria-expanded","aria-valuemax","aria-valuemin","aria-valuenow","aria-valuetext"],superclassRole:["range"],accessibleNameRequired:!0},radio:{type:"widget",allowedAttrs:["aria-checked","aria-posinset","aria-setsize","aria-required"],superclassRole:["input"],accessibleNameRequired:!0,nameFromContent:!0},radiogroup:{type:"composite",requiredOwned:["radio"],allowedAttrs:["aria-readonly","aria-required","aria-activedescendant","aria-expanded","aria-orientation"],superclassRole:["select"],accessibleNameRequired:!1},range:{type:"abstract",superclassRole:["widget"]},region:{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"],accessibleNameRequired:!1},roletype:{type:"abstract",superclassRole:[]},row:{type:"structure",requiredContext:["grid","rowgroup","table","treegrid"],requiredOwned:["cell","columnheader","gridcell","rowheader"],allowedAttrs:["aria-colindex","aria-level","aria-rowindex","aria-selected","aria-activedescendant","aria-expanded"],superclassRole:["group","widget"],nameFromContent:!0},rowgroup:{type:"structure",requiredContext:["grid","table","treegrid"],requiredOwned:["row"],superclassRole:["structure"],nameFromContent:!0},rowheader:{type:"structure",requiredContext:["row"],allowedAttrs:["aria-sort","aria-colindex","aria-colspan","aria-expanded","aria-readonly","aria-required","aria-rowindex","aria-rowspan","aria-selected"],superclassRole:["cell","gridcell","sectionhead"],accessibleNameRequired:!1,nameFromContent:!0},scrollbar:{type:"widget",requiredAttrs:["aria-valuenow"],allowedAttrs:["aria-controls","aria-orientation","aria-valuemax","aria-valuemin","aria-valuetext"],superclassRole:["range"]},search:{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},searchbox:{type:"widget",allowedAttrs:["aria-activedescendant","aria-autocomplete","aria-multiline","aria-placeholder","aria-readonly","aria-required"],superclassRole:["textbox"],accessibleNameRequired:!0},section:{type:"abstract",superclassRole:["structure"],nameFromContent:!0},sectionhead:{type:"abstract",superclassRole:["structure"],nameFromContent:!0},select:{type:"abstract",superclassRole:["composite","group"]},separator:{type:"structure",allowedAttrs:["aria-valuemax","aria-valuemin","aria-valuenow","aria-orientation","aria-valuetext"],superclassRole:["structure","widget"]},slider:{type:"widget",requiredAttrs:["aria-valuenow"],allowedAttrs:["aria-valuemax","aria-valuemin","aria-orientation","aria-readonly","aria-valuetext"],superclassRole:["input","range"],accessibleNameRequired:!0},spinbutton:{type:"widget",requiredAttrs:["aria-valuenow"],allowedAttrs:["aria-valuemax","aria-valuemin","aria-readonly","aria-required","aria-activedescendant","aria-valuetext"],superclassRole:["composite","input","range"],accessibleNameRequired:!0},status:{type:"widget",allowedAttrs:["aria-expanded"],superclassRole:["section"]},strong:{type:"structure",superclassRole:["section"]},structure:{type:"abstract",superclassRole:["roletype"]},subscript:{type:"structure",superclassRole:["section"]},superscript:{type:"structure",superclassRole:["section"]},switch:{type:"widget",requiredAttrs:["aria-checked"],allowedAttrs:["aria-readonly"],superclassRole:["checkbox"],accessibleNameRequired:!0,nameFromContent:!0},tab:{type:"widget",requiredContext:["tablist"],allowedAttrs:["aria-posinset","aria-selected","aria-setsize","aria-expanded"],superclassRole:["sectionhead","widget"],nameFromContent:!0},table:{type:"structure",requiredOwned:["rowgroup","row"],allowedAttrs:["aria-colcount","aria-rowcount","aria-expanded"],superclassRole:["section"],accessibleNameRequired:!1,nameFromContent:!0},tablist:{type:"composite",requiredOwned:["tab"],allowedAttrs:["aria-level","aria-multiselectable","aria-orientation","aria-activedescendant","aria-expanded"],superclassRole:["composite"]},tabpanel:{type:"widget",allowedAttrs:["aria-expanded"],superclassRole:["section"],accessibleNameRequired:!1},term:{type:"structure",allowedAttrs:["aria-expanded"],superclassRole:["section"],nameFromContent:!0},textbox:{type:"widget",allowedAttrs:["aria-activedescendant","aria-autocomplete","aria-multiline","aria-placeholder","aria-readonly","aria-required"],superclassRole:["input"],accessibleNameRequired:!0},time:{type:"structure",superclassRole:["section"]},timer:{type:"widget",allowedAttrs:["aria-expanded"],superclassRole:["status"]},toolbar:{type:"structure",allowedAttrs:["aria-orientation","aria-activedescendant","aria-expanded"],superclassRole:["group"],accessibleNameRequired:!0},tooltip:{type:"structure",allowedAttrs:["aria-expanded"],superclassRole:["section"],nameFromContent:!0},tree:{type:"composite",requiredOwned:["treeitem"],allowedAttrs:["aria-multiselectable","aria-required","aria-activedescendant","aria-expanded","aria-orientation"],superclassRole:["select"],accessibleNameRequired:!1},treegrid:{type:"composite",requiredOwned:["rowgroup","row"],allowedAttrs:["aria-activedescendant","aria-colcount","aria-expanded","aria-level","aria-multiselectable","aria-orientation","aria-readonly","aria-required","aria-rowcount"],superclassRole:["grid","tree"],accessibleNameRequired:!1},treeitem:{type:"widget",requiredContext:["group","tree"],allowedAttrs:["aria-checked","aria-expanded","aria-level","aria-posinset","aria-selected","aria-setsize"],superclassRole:["listitem","option"],accessibleNameRequired:!0,nameFromContent:!0},widget:{type:"abstract",superclassRole:["roletype"]},window:{type:"abstract",superclassRole:["roletype"]}},Ha={a:{variant:{href:{matches:"[href]",contentTypes:["interactive","phrasing","flow"],allowedRoles:["button","checkbox","menuitem","menuitemcheckbox","menuitemradio","option","radio","switch","tab","treeitem","doc-backlink","doc-biblioref","doc-glossref","doc-noteref"],namingMethods:["subtreeText"]},default:{contentTypes:["phrasing","flow"],allowedRoles:!0}}},abbr:{contentTypes:["phrasing","flow"],allowedRoles:!0},addres:{contentTypes:["flow"],allowedRoles:!0},area:{contentTypes:["phrasing","flow"],allowedRoles:!1,namingMethods:["altText"]},article:{contentTypes:["sectioning","flow"],allowedRoles:["feed","presentation","none","document","application","main","region"],shadowRoot:!0},aside:{contentTypes:["sectioning","flow"],allowedRoles:["feed","note","presentation","none","region","search","doc-dedication","doc-example","doc-footnote","doc-pullquote","doc-tip"]},audio:{variant:{controls:{matches:"[controls]",contentTypes:["interactive","embedded","phrasing","flow"]},default:{contentTypes:["embedded","phrasing","flow"]}},allowedRoles:["application"]},b:{contentTypes:["phrasing","flow"],allowedRoles:!1},base:{allowedRoles:!1,noAriaAttrs:!0},bdi:{contentTypes:["phrasing","flow"],allowedRoles:!0},bdo:{contentTypes:["phrasing","flow"],allowedRoles:!0},blockquote:{contentTypes:["flow"],allowedRoles:!0,shadowRoot:!0},body:{allowedRoles:!1,shadowRoot:!0},br:{contentTypes:["phrasing","flow"],allowedRoles:["presentation","none"],namingMethods:["titleText","singleSpace"]},button:{contentTypes:["interactive","phrasing","flow"],allowedRoles:["checkbox","link","menuitem","menuitemcheckbox","menuitemradio","option","radio","switch","tab"],namingMethods:["subtreeText"]},canvas:{allowedRoles:!0,contentTypes:["embedded","phrasing","flow"]},caption:{allowedRoles:!1},cite:{contentTypes:["phrasing","flow"],allowedRoles:!0},code:{contentTypes:["phrasing","flow"],allowedRoles:!0},col:{allowedRoles:!1,noAriaAttrs:!0},colgroup:{allowedRoles:!1,noAriaAttrs:!0},data:{contentTypes:["phrasing","flow"],allowedRoles:!0},datalist:{contentTypes:["phrasing","flow"],allowedRoles:!1,implicitAttrs:{"aria-multiselectable":"false"}},dd:{allowedRoles:!1},del:{contentTypes:["phrasing","flow"],allowedRoles:!0},dfn:{contentTypes:["phrasing","flow"],allowedRoles:!0},details:{contentTypes:["interactive","flow"],allowedRoles:!1},dialog:{contentTypes:["flow"],allowedRoles:["alertdialog"]},div:{contentTypes:["flow"],allowedRoles:!0,shadowRoot:!0},dl:{contentTypes:["flow"],allowedRoles:["group","list","presentation","none"]},dt:{allowedRoles:["listitem"]},em:{contentTypes:["phrasing","flow"],allowedRoles:!0},embed:{contentTypes:["interactive","embedded","phrasing","flow"],allowedRoles:["application","document","img","presentation","none"]},fieldset:{contentTypes:["flow"],allowedRoles:["none","presentation","radiogroup"],namingMethods:["fieldsetLegendText"]},figcaption:{allowedRoles:["group","none","presentation"]},figure:{contentTypes:["flow"],allowedRoles:!0,namingMethods:["figureText","titleText"]},footer:{contentTypes:["flow"],allowedRoles:["group","none","presentation","doc-footnote"],shadowRoot:!0},form:{contentTypes:["flow"],allowedRoles:["search","none","presentation"]},h1:{contentTypes:["heading","flow"],allowedRoles:["none","presentation","tab","doc-subtitle"],shadowRoot:!0,implicitAttrs:{"aria-level":"1"}},h2:{contentTypes:["heading","flow"],allowedRoles:["none","presentation","tab","doc-subtitle"],shadowRoot:!0,implicitAttrs:{"aria-level":"2"}},h3:{contentTypes:["heading","flow"],allowedRoles:["none","presentation","tab","doc-subtitle"],shadowRoot:!0,implicitAttrs:{"aria-level":"3"}},h4:{contentTypes:["heading","flow"],allowedRoles:["none","presentation","tab","doc-subtitle"],shadowRoot:!0,implicitAttrs:{"aria-level":"4"}},h5:{contentTypes:["heading","flow"],allowedRoles:["none","presentation","tab","doc-subtitle"],shadowRoot:!0,implicitAttrs:{"aria-level":"5"}},h6:{contentTypes:["heading","flow"],allowedRoles:["none","presentation","tab","doc-subtitle"],shadowRoot:!0,implicitAttrs:{"aria-level":"6"}},head:{allowedRoles:!1,noAriaAttrs:!0},header:{contentTypes:["flow"],allowedRoles:["group","none","presentation","doc-footnote"],shadowRoot:!0},hgroup:{contentTypes:["heading","flow"],allowedRoles:!0},hr:{contentTypes:["flow"],allowedRoles:["none","presentation","doc-pagebreak"],namingMethods:["titleText","singleSpace"]},html:{allowedRoles:!1,noAriaAttrs:!0},i:{contentTypes:["phrasing","flow"],allowedRoles:!0},iframe:{contentTypes:["interactive","embedded","phrasing","flow"],allowedRoles:["application","document","img","none","presentation"]},img:{variant:{nonEmptyAlt:{matches:{attributes:{alt:"/.+/"}},allowedRoles:["button","checkbox","link","menuitem","menuitemcheckbox","menuitemradio","option","progressbar","scrollbar","separator","slider","switch","tab","treeitem","doc-cover"]},usemap:{matches:"[usemap]",contentTypes:["interactive","embedded","phrasing","flow"]},default:{allowedRoles:["presentation","none"],contentTypes:["embedded","phrasing","flow"]}},namingMethods:["altText"]},input:{variant:{button:{matches:{properties:{type:"button"}},allowedRoles:["link","menuitem","menuitemcheckbox","menuitemradio","option","radio","switch","tab"]},buttonType:{matches:{properties:{type:["button","submit","reset"]}},namingMethods:["valueText","titleText","buttonDefaultText"]},checkboxPressed:{matches:{properties:{type:"checkbox"},attributes:{"aria-pressed":"/.*/"}},allowedRoles:["button","menuitemcheckbox","option","switch"],implicitAttrs:{"aria-checked":"false"}},checkbox:{matches:{properties:{type:"checkbox"},attributes:{"aria-pressed":null}},allowedRoles:["menuitemcheckbox","option","switch"],implicitAttrs:{"aria-checked":"false"}},noRoles:{matches:{properties:{type:["color","date","datetime-local","file","month","number","password","range","reset","submit","time","week"]}},allowedRoles:!1},hidden:{matches:{properties:{type:"hidden"}},contentTypes:["phrasing","flow"],allowedRoles:!1,noAriaAttrs:!0},image:{matches:{properties:{type:"image"}},allowedRoles:["link","menuitem","menuitemcheckbox","menuitemradio","radio","switch"],namingMethods:["altText","valueText","labelText","titleText","buttonDefaultText"]},radio:{matches:{properties:{type:"radio"}},allowedRoles:["menuitemradio"],implicitAttrs:{"aria-checked":"false"}},textWithList:{matches:{properties:{type:"text"},attributes:{list:"/.*/"}},allowedRoles:!1},default:{contentTypes:["interactive","phrasing","flow"],allowedRoles:["combobox","searchbox","spinbutton"],implicitAttrs:{"aria-valuenow":""},namingMethods:["labelText","placeholderText"]}}},ins:{contentTypes:["phrasing","flow"],allowedRoles:!0},kbd:{contentTypes:["phrasing","flow"],allowedRoles:!0},label:{contentTypes:["interactive","phrasing","flow"],allowedRoles:!1},legend:{allowedRoles:!1},li:{allowedRoles:["menuitem","menuitemcheckbox","menuitemradio","option","none","presentation","radio","separator","tab","treeitem","doc-biblioentry","doc-endnote"],implicitAttrs:{"aria-setsize":"1","aria-posinset":"1"}},link:{contentTypes:["phrasing","flow"],allowedRoles:!1,noAriaAttrs:!0},main:{contentTypes:["flow"],allowedRoles:!1,shadowRoot:!0},map:{contentTypes:["phrasing","flow"],allowedRoles:!1,noAriaAttrs:!0},math:{contentTypes:["embedded","phrasing","flow"],allowedRoles:!1},mark:{contentTypes:["phrasing","flow"],allowedRoles:!0},menu:{contentTypes:["flow"],allowedRoles:["directory","group","listbox","menu","menubar","none","presentation","radiogroup","tablist","toolbar","tree"]},meta:{variant:{itemprop:{matches:"[itemprop]",contentTypes:["phrasing","flow"]}},allowedRoles:!1,noAriaAttrs:!0},meter:{contentTypes:["phrasing","flow"],allowedRoles:!1},nav:{contentTypes:["sectioning","flow"],allowedRoles:["doc-index","doc-pagelist","doc-toc"],shadowRoot:!0},noscript:{contentTypes:["phrasing","flow"],allowedRoles:!1,noAriaAttrs:!0},object:{variant:{usemap:{matches:"[usemap]",contentTypes:["interactive","embedded","phrasing","flow"]},default:{contentTypes:["embedded","phrasing","flow"]}},allowedRoles:["application","document","img"]},ol:{contentTypes:["flow"],allowedRoles:["directory","group","listbox","menu","menubar","none","presentation","radiogroup","tablist","toolbar","tree"]},optgroup:{allowedRoles:!1},option:{allowedRoles:!1,implicitAttrs:{"aria-selected":"false"}},output:{contentTypes:["phrasing","flow"],allowedRoles:!0,namingMethods:["subtreeText"]},p:{contentTypes:["flow"],allowedRoles:!0,shadowRoot:!0},param:{allowedRoles:!1,noAriaAttrs:!0},picture:{contentTypes:["embedded","phrasing","flow"],allowedRoles:!1,noAriaAttrs:!0},pre:{contentTypes:["flow"],allowedRoles:!0},progress:{contentTypes:["phrasing","flow"],allowedRoles:!0,implicitAttrs:{"aria-valuemax":"100","aria-valuemin":"0","aria-valuenow":"0"}},q:{contentTypes:["phrasing","flow"],allowedRoles:!0},rp:{allowedRoles:!0},rt:{allowedRoles:!0},ruby:{contentTypes:["phrasing","flow"],allowedRoles:!0},s:{contentTypes:["phrasing","flow"],allowedRoles:!0},samp:{contentTypes:["phrasing","flow"],allowedRoles:!0},script:{contentTypes:["phrasing","flow"],allowedRoles:!1,noAriaAttrs:!0},section:{contentTypes:["sectioning","flow"],allowedRoles:["alert","alertdialog","application","banner","complementary","contentinfo","dialog","document","feed","log","main","marquee","navigation","none","note","presentation","search","status","tabpanel","doc-abstract","doc-acknowledgments","doc-afterword","doc-appendix","doc-bibliography","doc-chapter","doc-colophon","doc-conclusion","doc-credit","doc-credits","doc-dedication","doc-endnotes","doc-epigraph","doc-epilogue","doc-errata","doc-example","doc-foreword","doc-glossary","doc-index","doc-introduction","doc-notice","doc-pagelist","doc-part","doc-preface","doc-prologue","doc-pullquote","doc-qna","doc-toc"],shadowRoot:!0},select:{variant:{combobox:{matches:{attributes:{multiple:null,size:[null,"1"]}},allowedRoles:["menu"]},default:{allowedRoles:!1}},contentTypes:["interactive","phrasing","flow"],implicitAttrs:{"aria-valuenow":""},namingMethods:["labelText"]},slot:{contentTypes:["phrasing","flow"],allowedRoles:!1,noAriaAttrs:!0},small:{contentTypes:["phrasing","flow"],allowedRoles:!0},source:{allowedRoles:!1,noAriaAttrs:!0},span:{contentTypes:["phrasing","flow"],allowedRoles:!0,shadowRoot:!0},strong:{contentTypes:["phrasing","flow"],allowedRoles:!0},style:{allowedRoles:!1,noAriaAttrs:!0},svg:{contentTypes:["embedded","phrasing","flow"],allowedRoles:["application","document","img"],namingMethods:["svgTitleText"]},sub:{contentTypes:["phrasing","flow"],allowedRoles:!0},summary:{allowedRoles:!1,namingMethods:["subtreeText"]},sup:{contentTypes:["phrasing","flow"],allowedRoles:!0},table:{contentTypes:["flow"],allowedRoles:!0,namingMethods:["tableCaptionText","tableSummaryText"]},tbody:{allowedRoles:!0},template:{contentTypes:["phrasing","flow"],allowedRoles:!1,noAriaAttrs:!0},textarea:{contentTypes:["interactive","phrasing","flow"],allowedRoles:!1,implicitAttrs:{"aria-valuenow":"","aria-multiline":"true"},namingMethods:["labelText","placeholderText"]},tfoot:{allowedRoles:!0},thead:{allowedRoles:!0},time:{contentTypes:["phrasing","flow"],allowedRoles:!0},title:{allowedRoles:!1,noAriaAttrs:!0},td:{allowedRoles:!0},th:{allowedRoles:!0},tr:{allowedRoles:!0},track:{allowedRoles:!1,noAriaAttrs:!0},u:{contentTypes:["phrasing","flow"],allowedRoles:!0},ul:{contentTypes:["flow"],allowedRoles:["directory","group","listbox","menu","menubar","none","presentation","radiogroup","tablist","toolbar","tree"]},var:{contentTypes:["phrasing","flow"],allowedRoles:!0},video:{variant:{controls:{matches:"[controls]",contentTypes:["interactive","embedded","phrasing","flow"]},default:{contentTypes:["embedded","phrasing","flow"]}},allowedRoles:["application"]},wbr:{contentTypes:["phrasing","flow"],allowedRoles:!0}},za={aliceblue:[240,248,255],antiquewhite:[250,235,215],aqua:[0,255,255],aquamarine:[127,255,212],azure:[240,255,255],beige:[245,245,220],bisque:[255,228,196],black:[0,0,0],blanchedalmond:[255,235,205],blue:[0,0,255],blueviolet:[138,43,226],brown:[165,42,42],burlywood:[222,184,135],cadetblue:[95,158,160],chartreuse:[127,255,0],chocolate:[210,105,30],coral:[255,127,80],cornflowerblue:[100,149,237],cornsilk:[255,248,220],crimson:[220,20,60],cyan:[0,255,255],darkblue:[0,0,139],darkcyan:[0,139,139],darkgoldenrod:[184,134,11],darkgray:[169,169,169],darkgreen:[0,100,0],darkgrey:[169,169,169],darkkhaki:[189,183,107],darkmagenta:[139,0,139],darkolivegreen:[85,107,47],darkorange:[255,140,0],darkorchid:[153,50,204],darkred:[139,0,0],darksalmon:[233,150,122],darkseagreen:[143,188,143],darkslateblue:[72,61,139],darkslategray:[47,79,79],darkslategrey:[47,79,79],darkturquoise:[0,206,209],darkviolet:[148,0,211],deeppink:[255,20,147],deepskyblue:[0,191,255],dimgray:[105,105,105],dimgrey:[105,105,105],dodgerblue:[30,144,255],firebrick:[178,34,34],floralwhite:[255,250,240],forestgreen:[34,139,34],fuchsia:[255,0,255],gainsboro:[220,220,220],ghostwhite:[248,248,255],gold:[255,215,0],goldenrod:[218,165,32],gray:[128,128,128],green:[0,128,0],greenyellow:[173,255,47],grey:[128,128,128],honeydew:[240,255,240],hotpink:[255,105,180],indianred:[205,92,92],indigo:[75,0,130],ivory:[255,255,240],khaki:[240,230,140],lavender:[230,230,250],lavenderblush:[255,240,245],lawngreen:[124,252,0],lemonchiffon:[255,250,205],lightblue:[173,216,230],lightcoral:[240,128,128],lightcyan:[224,255,255],lightgoldenrodyellow:[250,250,210],lightgray:[211,211,211],lightgreen:[144,238,144],lightgrey:[211,211,211],lightpink:[255,182,193],lightsalmon:[255,160,122],lightseagreen:[32,178,170],lightskyblue:[135,206,250],lightslategray:[119,136,153],lightslategrey:[119,136,153],lightsteelblue:[176,196,222],lightyellow:[255,255,224],lime:[0,255,0],limegreen:[50,205,50],linen:[250,240,230],magenta:[255,0,255],maroon:[128,0,0],mediumaquamarine:[102,205,170],mediumblue:[0,0,205],mediumorchid:[186,85,211],mediumpurple:[147,112,219],mediumseagreen:[60,179,113],mediumslateblue:[123,104,238],mediumspringgreen:[0,250,154],mediumturquoise:[72,209,204],mediumvioletred:[199,21,133],midnightblue:[25,25,112],mintcream:[245,255,250],mistyrose:[255,228,225],moccasin:[255,228,181],navajowhite:[255,222,173],navy:[0,0,128],oldlace:[253,245,230],olive:[128,128,0],olivedrab:[107,142,35],orange:[255,165,0],orangered:[255,69,0],orchid:[218,112,214],palegoldenrod:[238,232,170],palegreen:[152,251,152],paleturquoise:[175,238,238],palevioletred:[219,112,147],papayawhip:[255,239,213],peachpuff:[255,218,185],peru:[205,133,63],pink:[255,192,203],plum:[221,160,221],powderblue:[176,224,230],purple:[128,0,128],rebeccapurple:[102,51,153],red:[255,0,0],rosybrown:[188,143,143],royalblue:[65,105,225],saddlebrown:[139,69,19],salmon:[250,128,114],sandybrown:[244,164,96],seagreen:[46,139,87],seashell:[255,245,238],sienna:[160,82,45],silver:[192,192,192],skyblue:[135,206,235],slateblue:[106,90,205],slategray:[112,128,144],slategrey:[112,128,144],snow:[255,250,250],springgreen:[0,255,127],steelblue:[70,130,180],tan:[210,180,140],teal:[0,128,128],thistle:[216,191,216],tomato:[255,99,71],turquoise:[64,224,208],violet:[238,130,238],wheat:[245,222,179],white:[255,255,255],whitesmoke:[245,245,245],yellow:[255,255,0],yellowgreen:[154,205,50]},$a={ariaAttrs:{"aria-activedescendant":{type:"idref",allowEmpty:!0},"aria-atomic":{type:"boolean",global:!0},"aria-autocomplete":{type:"nmtoken",values:["inline","list","both","none"]},"aria-busy":{type:"boolean",global:!0},"aria-checked":{type:"nmtoken",values:["false","mixed","true","undefined"]},"aria-colcount":{type:"int"},"aria-colindex":{type:"int"},"aria-colspan":{type:"int"},"aria-controls":{type:"idrefs",allowEmpty:!0,global:!0},"aria-current":{type:"nmtoken",allowEmpty:!0,values:["page","step","location","date","time","true","false"],global:!0},"aria-describedby":{type:"idrefs",allowEmpty:!0,global:!0},"aria-details":{type:"idref",allowEmpty:!0,global:!0},"aria-disabled":{type:"boolean",global:!0},"aria-dropeffect":{type:"nmtokens",values:["copy","execute","link","move","none","popup"],global:!0},"aria-errormessage":{type:"idref",allowEmpty:!0,global:!0},"aria-expanded":{type:"nmtoken",values:["true","false","undefined"]},"aria-flowto":{type:"idrefs",allowEmpty:!0,global:!0},"aria-grabbed":{type:"nmtoken",values:["true","false","undefined"],global:!0},"aria-haspopup":{type:"nmtoken",allowEmpty:!0,values:["true","false","menu","listbox","tree","grid","dialog"],global:!0},"aria-hidden":{type:"nmtoken",values:["true","false","undefined"],global:!0},"aria-invalid":{type:"nmtoken",allowEmpty:!0,values:["grammar","false","spelling","true"],global:!0},"aria-keyshortcuts":{type:"string",allowEmpty:!0,global:!0},"aria-label":{type:"string",allowEmpty:!0,global:!0},"aria-labelledby":{type:"idrefs",allowEmpty:!0,global:!0},"aria-level":{type:"int"},"aria-live":{type:"nmtoken",values:["assertive","off","polite"],global:!0},"aria-modal":{type:"boolean"},"aria-multiline":{type:"boolean"},"aria-multiselectable":{type:"boolean"},"aria-orientation":{type:"nmtoken",values:["horizontal","undefined","vertical"]},"aria-owns":{type:"idrefs",allowEmpty:!0,global:!0},"aria-placeholder":{type:"string",allowEmpty:!0},"aria-posinset":{type:"int"},"aria-pressed":{type:"nmtoken",values:["false","mixed","true","undefined"]},"aria-readonly":{type:"boolean"},"aria-relevant":{type:"nmtokens",values:["additions","all","removals","text"],global:!0},"aria-required":{type:"boolean"},"aria-roledescription":{type:"string",allowEmpty:!0,global:!0},"aria-rowcount":{type:"int"},"aria-rowindex":{type:"int"},"aria-rowspan":{type:"int"},"aria-selected":{type:"nmtoken",values:["false","true","undefined"]},"aria-setsize":{type:"int"},"aria-sort":{type:"nmtoken",values:["ascending","descending","none","other"]},"aria-valuemax":{type:"decimal"},"aria-valuemin":{type:"decimal"},"aria-valuenow":{type:"decimal"},"aria-valuetext":{type:"string"}},ariaRoles:ec({},Va,{"doc-abstract":{type:"section",allowedAttrs:["aria-expanded"],superclassRole:["section"]},"doc-acknowledgments":{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},"doc-afterword":{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},"doc-appendix":{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},"doc-backlink":{type:"link",allowedAttrs:["aria-expanded"],nameFromContent:!0,superclassRole:["link"]},"doc-biblioentry":{type:"listitem",requiredContext:["doc-bibliography"],allowedAttrs:["aria-expanded","aria-level","aria-posinset","aria-setsize"],superclassRole:["listitem"]},"doc-bibliography":{type:"landmark",requiredOwned:["doc-biblioentry"],allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},"doc-biblioref":{type:"link",allowedAttrs:["aria-expanded"],nameFromContent:!0,superclassRole:["link"]},"doc-chapter":{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},"doc-colophon":{type:"section",allowedAttrs:["aria-expanded"],superclassRole:["section"]},"doc-conclusion":{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},"doc-cover":{type:"img",allowedAttrs:["aria-expanded"],superclassRole:["img"]},"doc-credit":{type:"section",allowedAttrs:["aria-expanded"],superclassRole:["section"]},"doc-credits":{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},"doc-dedication":{type:"section",allowedAttrs:["aria-expanded"],superclassRole:["section"]},"doc-endnote":{type:"listitem",requiredContext:["doc-endnotes"],allowedAttrs:["aria-expanded","aria-level","aria-posinset","aria-setsize"],superclassRole:["listitem"]},"doc-endnotes":{type:"landmark",requiredOwned:["doc-endnote"],allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},"doc-epigraph":{type:"section",allowedAttrs:["aria-expanded"],superclassRole:["section"]},"doc-epilogue":{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},"doc-errata":{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},"doc-example":{type:"section",allowedAttrs:["aria-expanded"],superclassRole:["section"]},"doc-footnote":{type:"section",allowedAttrs:["aria-expanded"],superclassRole:["section"]},"doc-foreword":{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},"doc-glossary":{type:"landmark",requiredOwned:["definition","term"],allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},"doc-glossref":{type:"link",allowedAttrs:["aria-expanded"],nameFromContent:!0,superclassRole:["link"]},"doc-index":{type:"navigation",allowedAttrs:["aria-expanded"],superclassRole:["navigation"]},"doc-introduction":{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},"doc-noteref":{type:"link",allowedAttrs:["aria-expanded"],nameFromContent:!0,superclassRole:["link"]},"doc-notice":{type:"note",allowedAttrs:["aria-expanded"],superclassRole:["note"]},"doc-pagebreak":{type:"separator",allowedAttrs:["aria-expanded","aria-orientation"],superclassRole:["separator"]},"doc-pagelist":{type:"navigation",allowedAttrs:["aria-expanded"],superclassRole:["navigation"]},"doc-part":{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},"doc-preface":{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},"doc-prologue":{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},"doc-pullquote":{type:"none",superclassRole:["none"]},"doc-qna":{type:"section",allowedAttrs:["aria-expanded"],superclassRole:["section"]},"doc-subtitle":{type:"sectionhead",allowedAttrs:["aria-expanded"],superclassRole:["sectionhead"]},"doc-tip":{type:"note",allowedAttrs:["aria-expanded"],superclassRole:["note"]},"doc-toc":{type:"navigation",allowedAttrs:["aria-expanded"],superclassRole:["navigation"]}}),htmlElms:Ha,cssColors:za},Wa=ec({},$a);var Ga=Wa;var Ya=function(e,t,r,a){this.red=e,this.green=t,this.blue=r,this.alpha=a,this.toHexString=function(){var e=Math.round(this.red).toString(16),t=Math.round(this.green).toString(16),r=Math.round(this.blue).toString(16);return"#"+(15.5<this.red?e:"0"+e)+(15.5<this.green?t:"0"+t)+(15.5<this.blue?r:"0"+r)};var l=/^#[0-9a-f]{3,8}$/i,o=/^((?:rgb|hsl)a?)\\s*\\(([^\\)]*)\\)/i;this.parseString=function(e){if(Ga.cssColors[e]||"transparent"===e){var t=tc(Ga.cssColors[e]||[0,0,0],3),r=t[0],a=t[1],n=t[2];return this.red=r,this.green=a,this.blue=n,void(this.alpha="transparent"===e?0:1)}if(e.match(o))this.parseColorFnString(e);else{if(!e.match(l))throw new Error(\'Unable to parse color "\'.concat(e,\'"\'));this.parseHexString(e)}},this.parseRgbString=function(e){if("transparent"===e)return this.red=0,this.green=0,this.blue=0,void(this.alpha=0);this.parseColorFnString(e)},this.parseHexString=function(e){var t,r,a,n,o,i;e.match(l)&&![6,8].includes(e.length)&&((e=e.replace("#","")).length<6&&(e=(r=(t=tc(e,4))[0])+r+(a=t[1])+a+(n=t[2])+n,(o=t[3])&&(e+=o+o)),i=e.match(/.{1,2}/g),this.red=parseInt(i[0],16),this.green=parseInt(i[1],16),this.blue=parseInt(i[2],16),i[3]?this.alpha=parseInt(i[3],16)/255:this.alpha=1)},this.parseColorFnString=function(e){var t,r=tc(e.match(o)||[],3),a=r[1],n=r[2];a&&n&&(t=n.split(/\\s*[,\\/\\s]\\s*/).map(function(e){return e.replace(",","").trim()}).filter(function(e){return""!==e}).map(function(e,t){return function(e,t,r){if(/%$/.test(t))return 3===r?parseFloat(t)/100:255*parseFloat(t)/100;if("h"===e[r]){if(/turn$/.test(t))return 360*parseFloat(t);if(/rad$/.test(t))return 57.3*parseFloat(t)}return parseFloat(t)}(a,e,t)}),"hsl"===a.substr(0,3)&&(t=function(e){var t=tc(e,4),r=t[0],a=t[1],n=t[2],o=t[3];a/=255,n/=255;var i=(1-Math.abs(2*n-1))*a,l=i*(1-Math.abs(r/60%2-1)),u=n-i/2,s=r<60?[i,l,0]:r<120?[l,i,0]:r<180?[0,i,l]:r<240?[0,l,i]:r<300?[l,0,i]:[i,0,l];return s.map(function(e){return Math.round(255*(e+u))}).concat(o)}(t)),this.red=t[0],this.green=t[1],this.blue=t[2],this.alpha="number"==typeof t[3]?t[3]:1)},this.getRelativeLuminance=function(){var e=this.red/255,t=this.green/255,r=this.blue/255;return.2126*(e<=.03928?e/12.92:Math.pow((.055+e)/1.055,2.4))+.7152*(t<=.03928?t/12.92:Math.pow((.055+t)/1.055,2.4))+.0722*(r<=.03928?r/12.92:Math.pow((.055+r)/1.055,2.4))}};var Ka=function(e){var t,r=new Ya;return r.parseString(e.getPropertyValue("background-color")),0!==r.alpha&&(t=e.getPropertyValue("opacity"),r.alpha=r.alpha*t),r};var Xa=function(e){var t=window.getComputedStyle(e);return Ua(e,t)||1===Ka(t).alpha},Ja=/^\\/?#[^/!]/;var Qa=function(e){return!!Ja.test(e.getAttribute("href"))&&(void 0!==xr.get("firstPageLink")?t=xr.get("firstPageLink"):(t=no(axe._tree,\'a:not([href^="#"]):not([href^="/#"]):not([href^="javascript"])\')[0],xr.set("firstPageLink",t||null)),!t||e.compareDocumentPosition(t.actualNode)===e.DOCUMENT_POSITION_FOLLOWING);var t};var Za=function(e,t){for(var r=["fixed","sticky"],a=[],n=!1,o=0;o<e.length;++o){var i=e[o];i===t&&(n=!0);var l=window.getComputedStyle(i);n||-1===r.indexOf(l.position)?a.push(i):a=[]}return a};function en(e){for(var t=wn(e).parent;t;){if(xn(t.actualNode))return t.actualNode;t=t.parent}}var tn=function(e,t){var r,a,n,o,i,l,u,s,c,d,p,f,m,h,g=en(t);do{var v=en(e);if(v===g||v===t)return r=t,h=m=f=p=d=c=s=u=l=i=o=n=a=void 0,a=e.getBoundingClientRect(),n=a.top+.01,o=a.bottom-.01,i=a.left+.01,l=a.right-.01,u=r.getBoundingClientRect(),s=u.top,c=u.left,d=s-r.scrollTop,p=s-r.scrollTop+r.scrollHeight,f=c-r.scrollLeft,m=c-r.scrollLeft+r.scrollWidth,"inline"===(h=window.getComputedStyle(r)).getPropertyValue("display")||!(i<f&&i<u.left||n<d&&n<u.top||m<l&&l>u.right||p<o&&o>u.bottom)&&(!(l>u.right||o>u.bottom)||"scroll"===h.overflow||"auto"===h.overflow||"hidden"===h.overflow||r instanceof window.HTMLBodyElement||r instanceof window.HTMLHtmlElement);e=v}while(e);return!1};var rn=function a(n,o){var t=2<arguments.length&&void 0!==arguments[2]?arguments[2]:document,i=3<arguments.length&&void 0!==arguments[3]?arguments[3]:0;if(999<i)throw new Error("Infinite loop detected");return Array.from(t.elementsFromPoint(n,o)||[]).filter(function(e){return Gr(e)===t}).reduce(function(e,t){var r;return zr(t)?(r=a(n,o,t.shadowRoot,i+1),(e=e.concat(r)).length&&tn(e[0],t)&&e.push(t)):e.push(t),e},[])};var an=function(e,t){if(e.hasAttribute(t)){var r=e.nodeName.toUpperCase(),a=e;["A","AREA"].includes(r)&&!e.ownerSVGElement||((a=document.createElement("a")).href=e.getAttribute(t));var n,o,i,l=["https:","ftps:"].includes(a.protocol)?a.protocol.replace(/s:$/,":"):a.protocol,u=/^\\//.test(a.pathname)?a.pathname:"/".concat(a.pathname),s=(o=(n=u).split("/").pop())&&-1!==o.indexOf(".")?{pathname:n.replace(o,""),filename:/index./.test(o)?"":o}:{pathname:n,filename:""},c=s.pathname,d=s.filename;return{protocol:l,hostname:a.hostname,port:(i=a.port,["443","80"].includes(i)?"":i),pathname:/\\/$/.test(c)?c:"".concat(c,"/"),search:function(e){var t={};if(!e||!e.length)return t;var r=e.substring(1).split("&");if(!r||!r.length)return t;for(var a=0;a<r.length;a++){var n=tc(r[a].split("="),2),o=n[0],i=n[1],l=void 0===i?"":i;t[decodeURIComponent(o)]=decodeURIComponent(l)}return t}(a.search),hash:function(e){if(!e)return"";var t=e.match(/#!?\\/?/g);return t&&"#"!==tc(t,1)[0]?e:""}(a.hash),filename:d}}};var nn,on=function(e,t){var r=t.getBoundingClientRect(),a=r.top,n=r.left,o=a-t.scrollTop,i=a-t.scrollTop+t.scrollHeight,l=n-t.scrollLeft,u=n-t.scrollLeft+t.scrollWidth;if(e.left>u&&e.left>r.right||e.top>i&&e.top>r.bottom||e.right<l&&e.right<r.left||e.bottom<o&&e.bottom<r.top)return!1;var s=window.getComputedStyle(t);return!(e.left>r.right||e.top>r.bottom)||("scroll"===s.overflow||"auto"===s.overflow||t instanceof window.HTMLBodyElement||t instanceof window.HTMLHtmlElement)},ln=function(){Xs(i,tt);var o=Js(i);function i(e,t,r){var a,n;return rc(this,i),(a=o.call(this)).shadowId=r,a.children=[],a.actualNode=e,a.parent=t,a._isHidden=null,a._cache={},void 0===nn&&(nn=At(e.ownerDocument)),a._isXHTML=nn,"input"===e.nodeName.toLowerCase()&&(n=e.getAttribute("type"),n=a._isXHTML?n:(n||"").toLowerCase(),co().includes(n)||(n="text"),a._type=n),xr.get("nodeMap")&&xr.get("nodeMap").set(e,Qs(a)),a}return ac(i,[{key:"attr",value:function(e){return"function"!=typeof this.actualNode.getAttribute?null:this.actualNode.getAttribute(e)}},{key:"hasAttr",value:function(e){return"function"==typeof this.actualNode.hasAttribute&&this.actualNode.hasAttribute(e)}},{key:"getComputedStylePropertyValue",value:function(e){var t="computedStyle_"+e;return this._cache.hasOwnProperty(t)||(this._cache.hasOwnProperty("computedStyle")||(this._cache.computedStyle=window.getComputedStyle(this.actualNode)),this._cache[t]=this._cache.computedStyle.getPropertyValue(e)),this._cache[t]}},{key:"props",get:function(){var e=this.actualNode,t=e.nodeType,r=e.nodeName,a=e.id,n=e.multiple,o=e.nodeValue,i=e.value;return{nodeType:t,nodeName:this._isXHTML?r:r.toLowerCase(),id:a,type:this._type,multiple:n,nodeValue:o,value:i}}},{key:"isFocusable",get:function(){return this._cache.hasOwnProperty("isFocusable")||(this._cache.isFocusable=_a(this.actualNode)),this._cache.isFocusable}},{key:"tabbableElements",get:function(){return this._cache.hasOwnProperty("tabbableElements")||(this._cache.tabbableElements=ha(this)),this._cache.tabbableElements}},{key:"clientRects",get:function(){return this._cache.hasOwnProperty("clientRects")||(this._cache.clientRects=Array.from(this.actualNode.getClientRects()).filter(function(e){return 0<e.width})),this._cache.clientRects}},{key:"boundingClientRect",get:function(){return this._cache.hasOwnProperty("boundingClientRect")||(this._cache.boundingClientRect=this.actualNode.getBoundingClientRect()),this._cache.boundingClientRect}}]),i}();function un(e,n,r){var a,t,o;function i(e,t,r){var a=un(t,n,r);return a&&(e=e.concat(a)),e}if(e.documentElement&&(e=e.documentElement),o=e.nodeName.toLowerCase(),zr(e))return a=new ln(e,r,n),n="a"+Math.random().toString().substring(2),t=Array.from(e.shadowRoot.childNodes),a.children=t.reduce(function(e,t){return i(e,t,a)},[]),[a];if("content"===o&&"function"==typeof e.getDistributedNodes)return(t=Array.from(e.getDistributedNodes())).reduce(function(e,t){return i(e,t,r)},[]);if("slot"!==o||"function"!=typeof e.assignedNodes)return 1===e.nodeType?(a=new ln(e,r,n),t=Array.from(e.childNodes),a.children=t.reduce(function(e,t){return i(e,t,a)},[]),[a]):3===e.nodeType?[new ln(e,r)]:void 0;(t=Array.from(e.assignedNodes())).length||(t=function(e){var t=[];for(e=e.firstChild;e;)t.push(e),e=e.nextSibling;return t}(e));window.getComputedStyle(e);return t.reduce(function(e,t){return i(e,t,r)},[])}var sn=function(){var e=0<arguments.length&&void 0!==arguments[0]?arguments[0]:document.documentElement,t=1<arguments.length?arguments[1]:void 0;return xr.set("nodeMap",new WeakMap),un(e,t,null)};var cn=function(e){return e?e.trim().split("-")[0].toLowerCase():""};var dn=function(e){var r={};return r.none=e.none.concat(e.all),r.any=e.any,Object.keys(r).map(function(e){if(r[e].length){var t=axe._audit.data.failureSummaries[e];return t&&"function"==typeof t.failureMessage?t.failureMessage(r[e].map(function(e){return e.message||""})):void 0}}).filter(function(e){return void 0!==e}).join("\\n\\n")};var pn=function(){var e=0<arguments.length&&void 0!==arguments[0]?arguments[0]:window,t=e.screen,r=void 0===t?{}:t,a=e.navigator,n=void 0===a?{}:a,o=e.location,i=void 0===o?{}:o,l=e.innerHeight,u=e.innerWidth,s=r.msOrientation||r.orientation||r.mozOrientation||{};return{testEngine:{name:"axe-core",version:axe.version},testRunner:{name:axe._audit.brand},testEnvironment:{userAgent:n.userAgent,windowWidth:u,windowHeight:l,orientationAngle:s.angle,orientationType:s.type},timestamp:(new Date).toISOString(),url:i.href}};var fn=function(){return"function"==typeof axe._audit.data.incompleteFallbackMessage?axe._audit.data.incompleteFallbackMessage():axe._audit.data.incompleteFallbackMessage};var mn=Je.resultGroups;var hn=function(e,a){var t=axe.utils.aggregateResult(e);return mn.forEach(function(e){a.resultTypes&&!a.resultTypes.includes(e)&&(t[e]||[]).forEach(function(e){Array.isArray(e.nodes)&&0<e.nodes.length&&(e.nodes=[e.nodes[0]])}),t[e]=(t[e]||[]).map(function(t){return t=Object.assign({},t),Array.isArray(t.nodes)&&0<t.nodes.length&&(t.nodes=t.nodes.map(function(e){var t,r;return"object"===Gs(e.node)&&(e.html=e.node.source,a.elementRef&&!e.node.fromFrame&&(e.element=e.node.element),!1===a.selectors&&!e.node.fromFrame||(e.target=e.node.selector),a.ancestry&&(e.ancestry=e.node.ancestry),a.xpath&&(e.xpath=e.node.xpath)),delete e.result,delete e.node,t=e,r=a,["any","all","none"].forEach(function(e){Array.isArray(t[e])&&t[e].filter(function(e){return Array.isArray(e.relatedNodes)}).forEach(function(e){e.relatedNodes=e.relatedNodes.map(function(e){var t={html:e.source};return r.elementRef&&!e.fromFrame&&(t.element=e.element),!1===r.selectors&&!e.fromFrame||(t.target=e.selector),r.ancestry&&(t.ancestry=e.ancestry),r.xpath&&(t.xpath=e.xpath),t})})}),e})),mn.forEach(function(e){return delete t[e]}),delete t.pageLevel,delete t.result,t})}),t};axe._thisWillBeDeletedDoNotUse=axe._thisWillBeDeletedDoNotUse||{},axe._thisWillBeDeletedDoNotUse.helpers={failureSummary:dn,getEnvironmentData:pn,incompleteFallbackMessage:fn,processAggregate:hn};var gn=/\\$\\{\\s?data\\s?\\}/g;function vn(e,t){if("string"==typeof t)return e.replace(gn,t);for(var r in t){var a;t.hasOwnProperty(r)&&(a=new RegExp("\\\\${\\\\s?data\\\\."+r+"\\\\s?}","g"),e=e.replace(a,t[r]))}return e}var bn=function e(t,r){if(t){if(Array.isArray(r))return r.values=r.join(", "),"string"!=typeof t.singular||"string"!=typeof t.plural?vn(t,r):vn(1===r.length?t.singular:t.plural,r);if("string"==typeof t)return vn(t,r);if("string"==typeof r)return vn(t[r],r);var a=t.default||fn();return r&&r.messageKey&&t[r.messageKey]&&(a=t[r.messageKey]),e(a,r)}};var yn=function(e,t,r){var a=axe._audit.data.checks[e];if(!a)throw new Error("Cannot get message for unknown check: ".concat(e,"."));if(!a.messages[t])throw new Error(\'Check "\'.concat(e,\'"" does not have a "\').concat(t,\'" message.\'));return bn(a.messages[t],r)};var Dn=function(e,t,r){var a=((r.rules&&r.rules[t]||{}).checks||{})[e.id],n=(r.checks||{})[e.id],o=e.enabled,i=e.options;return n&&(n.hasOwnProperty("enabled")&&(o=n.enabled),n.hasOwnProperty("options")&&(i=n.options)),a&&(a.hasOwnProperty("enabled")&&(o=a.enabled),a.hasOwnProperty("options")&&(i=a.options)),{enabled:o,options:i,absolutePaths:r.absolutePaths}};var wn=function(e,t){var r=t||e;return xr.get("nodeMap")?xr.get("nodeMap").get(r):null};var xn=function(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:0,r=e.scrollWidth>e.clientWidth+t,a=e.scrollHeight>e.clientHeight+t;if(r||a){var n=window.getComputedStyle(e),o=n.getPropertyValue("overflow-x"),i=n.getPropertyValue("overflow-y");return r&&("visible"!==o&&"hidden"!==o)||a&&("visible"!==i&&"hidden"!==i)?{elm:e,top:e.scrollTop,left:e.scrollLeft}:void 0}};var En=function(){var e=0<arguments.length&&void 0!==arguments[0]?arguments[0]:window,t=e.document.documentElement;return[void 0!==e.pageXOffset?{elm:e,top:e.pageYOffset,left:e.pageXOffset}:{elm:t,top:t.scrollTop,left:t.scrollLeft}].concat(function a(e){return Array.from(e.children||e.childNodes||[]).reduce(function(e,t){var r=xn(t);return r&&e.push(r),e.concat(a(t))},[])}(document.body))};var An,Cn=function(d){if(!d)throw new Error("axe.utils.getStyleSheetFactory should be invoked with an argument");return function(e){var t,r=e.data,a=e.isCrossOrigin,n=void 0!==a&&a,o=e.shadowId,i=e.root,l=e.priority,u=e.isLink,s=void 0!==u&&u,c=d.createElement("style");return s?(t=d.createTextNode(\'@import "\'.concat(r.href,\'"\')),c.appendChild(t)):c.appendChild(d.createTextNode(r)),d.head.appendChild(c),{sheet:c.sheet,isCrossOrigin:n,shadowId:o,root:i,priority:l}}};var Fn=function(e){if(An&&An.parentNode)return void 0===An.styleSheet?An.appendChild(document.createTextNode(e)):An.styleSheet.cssText+=e,An;if(e){var t=document.head||document.getElementsByTagName("head")[0];return(An=document.createElement("style")).type="text/css",void 0===An.styleSheet?An.appendChild(document.createTextNode(e)):An.styleSheet.cssText=e,t.appendChild(An),An}};var kn=function e(t,r){var a=wn(t);if(9===t.nodeType)return!1;if(11===t.nodeType&&(t=t.host),a&&null!==a._isHidden)return a._isHidden;var n=window.getComputedStyle(t,null);if(!n||!t.parentNode||"none"===n.getPropertyValue("display")||!r&&"hidden"===n.getPropertyValue("visibility")||"true"===t.getAttribute("aria-hidden"))return!0;var o=e(t.assignedSlot?t.assignedSlot:t.parentNode,!0);return a&&(a._isHidden=o),o},Rn=["a","abbr","address","area","article","aside","audio","b","base","bdi","bdo","blockquote","body","br","button","canvas","caption","cite","code","col","colgroup","data","datalist","dd","del","details","dfn","dialog","div","dl","dt","em","embed","fieldset","figcaption","figure","footer","form","h1","h2","h3","h4","h5","h6","head","header","hgroup","hr","html","i","iframe","img","input","ins","kbd","keygen","label","legend","li","link","main","map","mark","math","menu","menuitem","meta","meter","nav","noscript","object","ol","optgroup","option","output","p","param","picture","pre","progress","q","rb","rp","rt","rtc","ruby","s","samp","script","section","select","slot","small","source","span","strong","style","sub","summary","sup","svg","table","tbody","td","template","textarea","tfoot","th","thead","time","title","tr","track","u","ul","var","video","wbr"];var Tn=function(e){return"http://www.w3.org/2000/svg"!==e.namespaceURI&&Rn.includes(e.nodeName.toLowerCase())};function Nn(e){return e.sort(function(e,t){return Mr(e,t)?1:-1})[0]}var _n=function(t,e){var r=e.include&&Nn(e.include.filter(function(e){return Mr(e,t)})),a=e.exclude&&Nn(e.exclude.filter(function(e){return Mr(e,t)}));return!!(!a&&r||a&&Mr(a,r))},On=a(ze());axe._memoizedFns=[];var Sn=function(e){var t=On.default(e);return axe._memoizedFns.push(t),t};var Pn=function(e,n,o,i){var t=4<arguments.length&&void 0!==arguments[4]&&arguments[4],r=Array.from(e.cssRules);if(!r)return Promise.resolve();var a=r.filter(function(e){return 3===e.type});if(!a.length)return Promise.resolve({isCrossOrigin:t,priority:o,root:n.rootNode,shadowId:n.shadowId,sheet:e});var l=a.filter(function(e){return e.href}).map(function(e){return e.href}).filter(function(e){return!i.includes(e)}).map(function(e,t){var r=[].concat(Zs(o),[t]),a=/^https?:\\/\\/|^\\/\\//i.test(e);return qn(e,n,r,i,a)}),u=r.filter(function(e){return 3!==e.type});return u.length&&l.push(Promise.resolve(n.convertDataToStylesheet({data:u.map(function(e){return e.cssText}).join(),isCrossOrigin:t,priority:o,root:n.rootNode,shadowId:n.shadowId}))),Promise.all(l)};var In=function(e,t,r,a){var n=4<arguments.length&&void 0!==arguments[4]&&arguments[4];return function(e){try{return!e.cssRules&&e.href?!1:!0}catch(e){return!1}}(e)?Pn(e,t,r,a,n):qn(e.href,t,r,a,!0)};var Bn,Ln,qn=function(e,r,a,n,o){return n.push(e),new Promise(function(t,r){var a=new XMLHttpRequest;a.open("GET",e),a.timeout=Je.preload.timeout,a.addEventListener("error",r),a.addEventListener("timeout",r),a.addEventListener("loadend",function(e){return e.loaded&&a.responseText?t(a.responseText):void r(a.responseText)}),a.send()}).then(function(e){var t=r.convertDataToStylesheet({data:e,isCrossOrigin:o,priority:a,root:r.rootNode,shadowId:r.shadowId});return In(t.sheet,r,a,n,t.isCrossOrigin)})};function jn(){if(window.performance&&window.performance)return window.performance.now()}var Mn,Un,Vn=(Bn=null,Ln=jn(),{start:function(){this.mark("mark_axe_start")},end:function(){this.mark("mark_axe_end"),this.measure("axe","mark_axe_start","mark_axe_end"),this.logMeasures("axe")},auditStart:function(){this.mark("mark_audit_start")},auditEnd:function(){this.mark("mark_audit_end"),this.measure("audit_start_to_end","mark_audit_start","mark_audit_end"),this.logMeasures()},mark:function(e){window.performance&&void 0!==window.performance.mark&&window.performance.mark(e)},measure:function(e,t,r){window.performance&&void 0!==window.performance.measure&&window.performance.measure(e,t,r)},logMeasures:function(e){function t(e){Qe("Measure "+e.name+" took "+e.duration+"ms")}if(window.performance&&void 0!==window.performance.getEntriesByType)for(var r=window.performance.getEntriesByName("mark_axe_start")[0],a=window.performance.getEntriesByType("measure").filter(function(e){return e.startTime>=r.startTime}),n=0;n<a.length;++n){var o=a[n];if(o.name===e)return void t(o);t(o)}},timeElapsed:function(){return jn()-Ln},reset:function(){Bn=Bn||jn(),Ln=jn()}});function Hn(){if(document.elementsFromPoint)return document.elementsFromPoint;if(document.msElementsFromPoint)return document.msElementsFromPoint;var e,t=((e=document.createElement("x")).style.cssText="pointer-events:auto","auto"===e.style.pointerEvents),l=t?"pointer-events":"visibility",u=t?"none":"hidden",s=document.createElement("style");return s.innerHTML=t?"* { pointer-events: all }":"* { visibility: visible }",function(e,t){var r,a,n,o=[],i=[];for(document.head.appendChild(s);(r=document.elementFromPoint(e,t))&&-1===o.indexOf(r);)o.push(r),i.push({value:r.style.getPropertyValue(l),priority:r.style.getPropertyPriority(l)}),r.style.setProperty(l,u,"important");for(o.indexOf(document.documentElement)<o.length-1&&(o.splice(o.indexOf(document.documentElement),1),o.push(document.documentElement)),a=i.length;n=i[--a];)o[a].style.setProperty(l,n.value?n.value:"",n.priority);return document.head.removeChild(s),o}}function zn(e){return"function"==typeof e||"[object Function]"===Mn.call(e)}function $n(e){var t,r=(t=Number(e),isNaN(t)?0:0!==t&&isFinite(t)?(0<t?1:-1)*Math.floor(Math.abs(t)):t);return Math.min(Math.max(r,0),Un)}"function"!=typeof Object.assign&&(Object.assign=function(e){if(null==e)throw new TypeError("Cannot convert undefined or null to object");for(var t=Object(e),r=1;r<arguments.length;r++){var a=arguments[r];if(null!=a)for(var n in a)a.hasOwnProperty(n)&&(t[n]=a[n])}return t}),Array.prototype.find||Object.defineProperty(Array.prototype,"find",{value:function(e){if(null===this)throw new TypeError("Array.prototype.find called on null or undefined");if("function"!=typeof e)throw new TypeError("predicate must be a function");for(var t,r=Object(this),a=r.length>>>0,n=arguments[1],o=0;o<a;o++)if(t=r[o],e.call(n,t,o,r))return t}}),"function"==typeof window.addEventListener&&(document.elementsFromPoint=Hn()),Array.prototype.includes||Object.defineProperty(Array.prototype,"includes",{value:function(e,t){var r=Object(this),a=parseInt(r.length,10)||0;if(0===a)return!1;var n,o,i=parseInt(t,10)||0;for(0<=i?n=i:(n=a+i)<0&&(n=0);n<a;){if(e===(o=r[n])||e!=e&&o!=o)return!0;n++}return!1}}),Array.prototype.some||Object.defineProperty(Array.prototype,"some",{value:function(e,t){if(null==this)throw new TypeError("Array.prototype.some called on null or undefined");if("function"!=typeof e)throw new TypeError;for(var r=Object(this),a=r.length>>>0,n=2<=arguments.length?t:void 0,o=0;o<a;o++)if(o in r&&e.call(n,r[o],o,r))return!0;return!1}}),Array.from||Object.defineProperty(Array,"from",{value:(Mn=Object.prototype.toString,Un=Math.pow(2,53)-1,function(e,t,r){var a=Object(e);if(null==e)throw new TypeError("Array.from requires an array-like object - not null or undefined");var n,o=1<arguments.length?t:void 0;if(void 0!==o){if(!zn(o))throw new TypeError("Array.from: when provided, the second argument must be a function");2<arguments.length&&(n=r)}for(var i,l=$n(a.length),u=zn(this)?Object(new this(l)):new Array(l),s=0;s<l;)i=a[s],u[s]=o?void 0===n?o(i,s):o.call(n,i,s):i,s+=1;return u.length=l,u})}),String.prototype.includes||(String.prototype.includes=function(e,t){return"number"!=typeof t&&(t=0),!(t+e.length>this.length)&&-1!==this.indexOf(e,t)});var Wn=function(e,t){return e.concat(t).filter(function(e,t,r){return r.indexOf(e)===t})};function Gn(e,t,r,a){var n={vNodes:e.slice(),anyLevel:t,thisLevel:r,parentShadowId:a};return n.vNodes.reverse(),n}var Yn=function(e,t,r){return function(e,t,r){for(var a=[],n=Gn(Array.isArray(e)?e:[e],t,[],e[0].shadowId),o=[];n.vNodes.length;){for(var i=n.vNodes.pop(),l=[],u=[],s=n.anyLevel.slice().concat(n.thisLevel),c=!1,d=0;d<s.length;d++){var p=s[d];if((!p[0].id||i.shadowId===n.parentShadowId)&&Qt(i,p[0]))if(1===p.length)c||r&&!r(i)||(o.push(i),c=!0);else{var f=p.slice(1);if(!1===[" ",">"].includes(f[0].combinator))throw new Error("axe.utils.querySelectorAll does not support the combinator: "+p[1].combinator);">"===f[0].combinator?l.push(f):u.push(f)}p[0].id&&i.shadowId!==n.parentShadowId||!n.anyLevel.includes(p)||u.push(p)}for(i.children&&i.children.length&&(a.push(n),n=Gn(i.children,u,l,i.shadowId));!n.vNodes.length&&a.length;)n=a.pop()}return o}(e=Array.isArray(e)?e:[e],Jt(t),r)};var Kn=function(e){var t,r,a=e.treeRoot,n=void 0===a?axe._tree[0]:a,o=(t=[],r=Yn(n,"*",function(e){return!t.includes(e.shadowId)&&(t.push(e.shadowId),!0)}).map(function(e){return{shadowId:e.shadowId,rootNode:Wr(e.actualNode)}}),Wn(r,[]));if(!o.length)return Promise.resolve();var s,c,i=document.implementation.createHTMLDocument("Dynamic document for loading cssom"),l=Cn(i);return s=l,c=[],o.forEach(function(e,t){var r=e.rootNode,a=e.shadowId,n=function(e,t,r){return function(e){var t=[];return e.filter(function(e){return!e.href||!t.includes(e.href)&&(t.push(e.href),!0)})}(11===e.nodeType&&t?function(o,i){return Array.from(o.children).filter(Xn).reduce(function(e,t){var r=t.nodeName.toUpperCase(),a="STYLE"===r?t.textContent:t,n=i({data:a,isLink:"LINK"===r,root:o});return e.push(n.sheet),e},[])}(e,r):function(e){return Array.from(e.styleSheets).filter(function(e){return Jn(e.media.mediaText)})}(e))}(r,a,s);if(!n)return Promise.all(c);var o=t+1,i={rootNode:r,shadowId:a,convertDataToStylesheet:s,rootIndex:o},l=[],u=Promise.all(n.map(function(e,t){return In(e,i,[o,t],l)}));c.push(u)}),Promise.all(c).then(function r(e){return e.reduce(function(e,t){return Array.isArray(t)?e.concat(r(t)):e.concat(t)},[])})};function Xn(e){var t=e.nodeName.toUpperCase(),r=e.getAttribute("href"),a=e.getAttribute("rel"),n="LINK"===t&&r&&a&&e.rel.toUpperCase().includes("STYLESHEET");return"STYLE"===t||n&&Jn(e.media)}function Jn(e){return!e||!e.toUpperCase().includes("PRINT")}var Qn=function(e){var t=e.treeRoot,r=void 0===t?axe._tree[0]:t,a=Yn(r,"video, audio",function(e){var t=e.actualNode;return t.hasAttribute("src")?!!t.getAttribute("src"):!(Array.from(t.getElementsByTagName("source")).filter(function(e){return!!e.getAttribute("src")}).length<=0)});return Promise.all(a.map(function(e){var r,t=e.actualNode;return r=t,new Promise(function(t){0<r.readyState&&t(r),r.addEventListener("loadedmetadata",function e(){r.removeEventListener("loadedmetadata",e),t(r)})})}))};function Zn(e){return!e||void 0===e.preload||null===e.preload||("boolean"==typeof e.preload?e.preload:(t=e.preload,"object"===Gs(t)&&Array.isArray(t.assets)));var t}function eo(e){var t=Je.preload,r=t.assets,a=t.timeout,n={assets:r,timeout:a};if(!e.preload)return n;if("boolean"==typeof e.preload)return n;if(!e.preload.assets.every(function(e){return r.includes(e.toLowerCase())}))throw new Error("Requested assets, not supported. Supported assets are: ".concat(r.join(", "),"."));return n.assets=Wn(e.preload.assets.map(function(e){return e.toLowerCase()}),[]),e.preload.timeout&&"number"==typeof e.preload.timeout&&!isNaN(e.preload.timeout)&&(n.timeout=e.preload.timeout),n}var to=function(i){var l={cssom:Kn,media:Qn};return Zn(i)?new Promise(function(r,t){var e=eo(i),a=e.assets,n=e.timeout,o=setTimeout(function(){return t(new Error("Preload assets timed out."))},n);Promise.all(a.map(function(n){return l[n](i).then(function(e){return a=e,(r=n)in(t={})?Object.defineProperty(t,r,{value:a,enumerable:!0,configurable:!0,writable:!0}):t[r]=a,t;var t,r,a})})).then(function(e){var t=e.reduce(function(e,t){return ec({},e,t)},{});clearTimeout(o),r(t)}).catch(function(e){clearTimeout(o),t(e)})}):Promise.resolve()};function ro(n,o){return function(e){var t=n[e.id]||{},r=t.messages||{},a=Object.assign({},t);delete a.messages,void 0===e.result?("object"!==Gs(r.incomplete)||Array.isArray(e.data)||(a.message=function(t,r){function a(e){return e.incomplete&&e.incomplete.default?e.incomplete.default:fn()}if(!t||!t.missingData)return t&&t.messageKey?r.incomplete[t.messageKey]:a(r);try{var e=r.incomplete[t.missingData[0].reason];if(!e)throw new Error;return e}catch(e){return"string"==typeof t.missingData?r.incomplete[t.missingData]:a(r)}}(e.data,r)),a.message||(a.message=r.incomplete)):a.message=e.result===o?r.pass:r.fail,"function"!=typeof a.message&&(a.message=bn(a.message,e.data)),Vr(e,a)}}var ao=function(e){var t=axe._audit.data.checks||{},r=axe._audit.data.rules||{},a=Lr(axe._audit.rules,"id",e.id)||{};e.tags=Ht(a.tags||[]);var n=ro(t,!0),o=ro(t,!1);e.nodes.forEach(function(e){e.any.forEach(n),e.all.forEach(n),e.none.forEach(o)}),Vr(e,Ht(r[e.id]||{}))};var no=function(e,t){return Yn(e,t)};function oo(t,e){var r,a=axe._audit&&axe._audit.tagExclude?axe._audit.tagExclude:[],n=e.hasOwnProperty("include")||e.hasOwnProperty("exclude")?(r=e.include||[],r=Array.isArray(r)?r:[r],n=e.exclude||[],(n=Array.isArray(n)?n:[n]).concat(a.filter(function(e){return-1===r.indexOf(e)}))):(r=Array.isArray(e)?e:[e],a.filter(function(e){return-1===r.indexOf(e)}));return!!(r.some(function(e){return-1!==t.tags.indexOf(e)})||0===r.length&&!1!==t.enabled)&&n.every(function(e){return-1===t.tags.indexOf(e)})}var io=function(e,t,r){var a=r.runOnly||{},n=(r.rules||{})[e.id];return!(e.pageLevel&&!t.page)&&("rule"===a.type?-1!==a.values.indexOf(e.id):n&&"boolean"==typeof n.enabled?n.enabled:"tag"===a.type&&a.values?oo(e,a.values):oo(e,[]))};var lo=function(e,t){var r,a=[];if(axe._selectCache)for(var n=0,o=axe._selectCache.length;n<o;n++){var i=axe._selectCache[n];if(i.selector===e)return i.result}function l(e){return _n(e,u)}for(var u,s=(u=t).include.reduce(function(e,t){return e.length&&Mr(e[e.length-1],t)||e.push(t),e},[]),c=0;c<s.length;c++)r=s[c],a=function(e,t){var r;if(0===e.length)return t;e.length<t.length&&(r=e,e=t,t=r);for(var a=0,n=t.length;a<n;a++)e.includes(t[a])||e.push(t[a]);return e}(a,Yn(r,e,l));return axe._selectCache&&axe._selectCache.push({selector:e,result:a}),a};var uo=function(e){e.forEach(function(e){return function(e,t,r){if(e===window)return e.scroll(r,t);e.scrollTop=t,e.scrollLeft=r}(e.elm,e.top,e.left)})};var so=function(e){return(e||"").trim().replace(/\\s{2,}/g," ").split(" ")};var co=function(){return["hidden","text","search","tel","url","email","password","date","month","week","time","datetime-local","number","range","color","checkbox","radio","file","submit","image","reset","button"]},po=[,[,[1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,,1,1,1,1,1,1,,1],[1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,,1,1,1,,1,1,,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1],[,1,1,,1,1,1,1,1,1,1,,1,,1,1,1,1,1,1,1,1,,1,1,1,1],[1,1,1,1,1,1,,,,,,1,1,1,1,,,1,1,1,,1,,1,,1,1],[1,1,1,,1,1,,1,1,1,,1,,,1,1,1,,,1,1,1,,,,,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,,,,,1,1,1,,1,1,1,1,1,1,,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,,1,1,1],[,1,,,,,,1,,1,,,,,1,,1,,,,1,1,,1,,,1],[1,,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1],[,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,,,1,1,1,1,,,1,,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,,1,1,,,1,,,,,1,1,1,,1,,1,,1,,,,,,1],[1,,1,1,1,1,,,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1],[1,,1,,1,,,,,1,,1,1,1,1,1,,,,1,1,1,1],[,1,1,1,1,1,,1,1,1,,1,,1,1,1,,,1,1,1,1,1,1,1,1],[,,1,,,1,,1,,,,1,1,1,,,,,,,,,,,1],[1,1,1,1,1,1,,1,1,1,,1,1,,1,1,1,1,1,1,1,1,,,1,1,1],[1,1,1,1,1,,,1,,,1,,,1,1,1,,,,,1,,,,,,1]],[,[1,1,1,1,1,1,1,1,1,1,1,,1,,1,1,1,,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,,1,,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1],[1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,,,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1],[,1,1,,1,,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]],[,[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1],[,1,1,1,1,1,,1,1,1,1,1,1,,1,1,,1,1,1,1,1,1,1,,1],[,1,,1,1,1,,1,1,,1,,1,1,1,1,1,1,1,1],[,1,,1,1,1,1,1,1,1,1,,,1,1,1,,,1,1,,,,,,1,1],[1,1,1,,,,,1,,,,1,1,,1,,,,,,1,,,,,1],[,1,,,1,,,1,,,,,,1],[,1,,1,,,,1,,,,1],[1,,1,1,1,,1,1,1,,1,1,1,1,1,1,1,1,1,,1,,,1,1,1,1],[,1,1,1,1,1,,,1,,,1,,1,1,,1,,1,,,,,1,,1],[,1,,,,1,,,1,1,,1,,1,1,1,1,,1,1,,,1,,,1],[,1,1,,,,,,1,,,,1,1,1,1,,1,1,1,1,1,1,,1,1,1],[,1,,1,1,1,,,1,1,1,1,1,1,,1,,,,,1,1,,1,,1],[,1,,1,,1,,1,,1,,1,1,1,1,1,,,1,1,1],[,1,1,1,,,,1,1,1,,1,1,,,1,1,,1,1,1,1,,1,1],[1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,,,1,1,1,1,1,1,1],[,1,1,1,,1,1,1,,1,,,,,1,1,1,,,1,,1,,,1,1],[,,,,1,,,,,,,,,,,,,,,,,1],[1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1],[,1,,1,1,1,,1,1,,,,1,1,1,1,1,,,1,1,1,,,,,1],[1,1,1,1,,,,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1],[1,,,,,,,1,,,,,,,1],[,1,1,,1,1,,1,,,,,,,,,,,,,1],,[1,1,1,,,,,,,,,,,,,1],[,,,,,,,,1,,,1,,,1,1,,,,,1]],[,[1,1,,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,,1,1,1,1,1,1],[,1,1,,1,1,1,1,,1,1,,1,1,1,1,1,1,1,,1,1,1,1,,1],[,,,1,,,,,,,,,,,,,,,1],[,1,,,1,1,,1,,1,1,,,,1,1,,,1,1,,,,1],[1,,,1,1,1,1,1,1,1,,1,1,1,1,,1,1,1,1,,,1,,,,1],,[,1,1,1,1,1,,1,1,1,,1,1,,1,1,,,1,1,1,1,,1,1,,1],[,1,,,1,,,1,,1,,,1,1,1,1,,,1,1,,1,1,1,1],[,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1],[,1,1,1,1,1,1,,,1,1,1,1,1,1,1,,,1,,,1,,1],[,1,,,,,,,,,,1,1,,,,,,1,1,,,,,1],[,,,,,,,1,,,,1,,1,1],[,1,1,1,1,1,1,1,,,,1,1,1,1,1,,,1,1,,1,1,1,1,1],[,1,,,1,1,,1,,1,1,1,,,1,1,,,1,,1,1,1,1,,1],[,1,1,1,,1,1,,1,1,,1,1,,1,1,1,1,1,1,1,,1,1,1,1,1],[,,,,,,,,,,,,,,,,1],,[,1,1,1,1,1,,1,1,1,,,1,,1,1,,1,1,1,1,1,,1,,1],[,,1,,,1,,,1,1,,,1,,1,1,,1],[,1,1,,1,,,,1,1,,1,,1,1,1,1,,1,1,1,1,,,,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1],[1,1],[,1,,,,,,,,,,1,1,,,,,,1,1,,1,,1,,1,1],,[,1,1,,1,,,1,,1,,,,1,1,1,,,,,,1,,,,1],[1,1,,,1,1,,1,,,,,1,,1]],[,[,1],[,,,1,,,,1,,,,1,,,,1,,,1,,,1],[,,,,,,,,,,,,,,,,,,1,1,,,,,,1],,[1,,,,,1],[,1,,,,1,,,,1],[,1,,,,,,,,,,,1,,,1,,,,,,,,,1,1],[,,,,,,,,,,,,,,,,,,,,,1],[,,,,,,,,,,,,,,,,1,,,,1,,1],[,1],[,1,,1,,1,,1,,1,,1,1,1,,1,1,,1,,,,,,,1],[1,,,,,1,,,1,1,,1,,1,,1,1,,,,,1,,,1],[,1,1,,,1,,1,,1,,1,,1,1,1,1,,,1,,1,,1,1,1],[1,1,1,1,1,,1,,1,,,,1,1,1,1,,1,1,,,1,1,1,1],[1,,,,,,,,,,,,,,,,,,,,1],[,,,,,,,,,1],,[,1,,,,,,1,1,1,,1,,,,1,,,1,1,1,,,1],[1,,,,,1,,1,1,1,,1,1,1,1,1,,1,,1,,1,,,1,1],[1,,1,1,,,,,1,,,,,,1,1,,,1,1,1,1,,,1,,1],[1,,,,,,,,,,,,,,,,,1],[,,,,,1,,,1,,,,,,1],[,,,,,,,,,,,,,,,1],[,,,,,,,,,,,,,,,,,,,,1],[,1,,,,,,,,,,,,,,1],[,1,,,,1]],[,[1,1,1,,1,,1,1,1,1,1,1,1,1,1,,1,,1,,1,1,,,1,1,1],[,,,,,,,,,,,,1],[,,,,,,,,,,,,,,,,,,,1],,[,,,,,,,,,,,,,,,,,,1],[1,,,,,,,,,1,,,,1],[,,,,,,,,,,,,,,,,,,1],,[1,1,,,,1,1,,,,,,1,,,,1,,1,,1,1,,1],[1],[,,,,,,,,,,,1,,,,,,,,,,,1],[,1,,,,,,,1,1,,,1,,1,,,,1,,,,,,,1],[,,,,,,,,,,,,,,,,1,,,,,1],[,,1,,,,,1,,1],[1,,,,1,,,,,1,,,,1,1,,,,1,1,,,,,1],[,,,,,1],[,,,,,,,,,,,,,,,,,,,1],[1,,,1,1,,,,,,,1,,1,,1,1,1,1,1,1],[,,,,,1,,,,,,,1,,,,,,,1],,[,,1,1,1,1,1,,1,1,1,,,1,1,,,1,1,,1,1,1,,,1],[,,,,,,,,,,,,,,,,,,1],[,1,,,,1],,[1]],[,[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1],[,,,1,1,1,1,,,,,,1,,1,,,,1,,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,,,1],[,1,1,1,1,,1,1,1,1,1,1,1,1,,,,1,,1,,,1,1,1,1,1],[,,,,,,,,,,,1,,,,,,,,,1,,,,1],[,1,1,,1,1,,1,,,,1,1,,1,1,,,1,,1,1,,1],[,1,,1,,1,,,1,,,1,1,,1,1,,,1,1,1],[,1,1,1,1,1,,1,1,,,,1,1,1,1,1,1,1,1,1,1,,1,1,1,1],[,,,,,,,,,1,,1,,1,1,,,,1,,,1],[,1,,,1,1,,,,,,,,,1,1,1,,,,,1],[1,,,1,1,,,,1,1,1,1,1,,,1,,,1,,,1,,1,,1],[,1,1,,1,1,,1,1,,,,1,1,1,,,1,1,,,1,1,1,1,1,1],[1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,,1,1,,1,1,,1,,,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1],[,1,,,,1,,,,,,,,,1],[,1,,,,,,,,1,,,,,1,,,,1,,,1],[,1,1,1,1,,,1,1,1,1,1,,1,,1,,1,1,1,1,1,1,1,1,1,1],[,,,,,1,,1,,,,,1,1,1,1,1,,,1,,,,1],[,1,,,,,,,,1,,,,,,,,,,,,1],[1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1],[1,1,,1,,1,1,,,,1,,1,1,1,1,1,,1,1,,,,,,1],[,1,1,1,1,1,1,1,,1,1,,,1,1,,,,1,,1,1,,1,1],[,,,,,,,,,,,,,,,,,,,,,,,,1],[,1,1,,1,1,1,1,,1,,,1,1,1,1,,,1,,,,,,,1],[,1,,,,,,,,1,,,,,1]],[,[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,,1,1,1,1,1],[,1,1,,,,,,,,,,,,1,1,,,,,,1],[,1,,,,,,,1],[,,,,,,,,,,,,,,1,,,,,1,,,,,,1],[1,1,,,1,,,1,1,1,,,,1],,[,,,,,,,,,,,,,1,,,,,,,,,,1],[,,,,,,,,,1,,,,,,,,,1,,,,,,,1],[1,1,1,,1,,1,1,1,1,1,1,1,1,,1,,,1,,1,,,1,1],[,,,,,,,,,1],[,1,,,,1,,,,,,1,,,1,,,,,1],[,1,1,,1,1,,,,,,,,,,,,,,,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1],[,1,,,1,1,,1,1,1,1,,,,1,1,,,,1,,1],[1,1,1,1,1,1,,,1,1,1,1,1,1,,1,1,,1,1,1,,1,1,,1,1],[,,,,,,,,,,,,,,,1,,,,1],,[1,1,,1,,1,,,,,,1,,1,,1,1,,1,,1,1,,1,1,,1],[,,1,,,,,,1,,,,1,,1,,,,,1],[1,,,,,,,,,1,,,,,,1,,,,1,,1,,,1],[1,,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1],[,,,1,,1,,,,,,1,,,1,,,,,,,,1],[,1,,1,,,,,,,,,,,,1],,[1,1,,,,,,,,,,,,,,,,,,,,,,1,1],[1]],[,[1,,,,,,,,,1,,,,,1,,1,,1],[,1,1,,1,1,,1,1,1,,,1,1,1,,,,1,,,1,,,,1],[,1,,,,,,,1,,,,1,,,,,,1],[1,1,1,1,1,1,,,,1,,,,,,,,,1,1,1,1],[1],[,1,1,,,1,1,,,,,1,,1,,,,,,,,1,,,,1],[1,,1,,,1,,1,,,,,1,1,1,1,,,,1,,,,1],[,,1,,,,,,,1,,,,,,,1,,,,,,,1],[1,,,,,,,,,,,,,,1,,,,1],[,,,1,,1,,,,,1,,,,1,1,,,,1],[1,,,,,1,,,,1,,1,1,,,1,1,,1,1,1,,1,1,1,,1],[,1,1,,,,,1,,1,,1,1,1,,1,1,,,1,,1,1,1],[,1,,,,1,,,,1,,,1,,1,1,,,1,1,,,,,,1],[1,,1,1,,1,,1,1,,1,,1,1,1,1,1,,,1,1,,,,,,1],[1,,,,,,,,,,,,,,,,,,1,,,1,,1],[,,,,,,,,,1,,,,,,1],[,,,,,,,,,,,,,,,,,,,,,1,,1],[,1,,,,1,,,1,1,,1,,,1,1,,,1,,,1,,,1,1],[1,1,,1,1,1,,1,1,1,,1,,1,1,1,,,1,,1,1],[1,,1,1,1,1,,,,1,,1,1,1,,1,,,1,1,1,,1,1,1,1,1],[1,,,,,,,,,,,,,1],[,,1,,,,,,,,,,,,,,,,,,,,1],[1,,,,,,,,,,,1,,1,,1,,,,1],[,,,1,,,,,,,,,1],[,1,,,,,,,,,,,,,,1,,,,,,,,,1],[,,,,,,,,1,1,,,,,,,,,1,,,,,,,,1]],[,[1,1,1,1,1,1,1,,1,,1,1,1,1,1,1,,1,1,1,1,1,,,1,1,1],[,,,,,1,,,,1,1,1,,,1,1,,,1,,1,1,,1],[,,,,,,,,,,,,,,,,,,,1,1],[,1,,,,,,1,,,,,,,,,,,,,1],[,,1,,,1,,1,1,1,,1,1,,1,,,,1,,1,1],,[,,1,,,1,,,,,,1,,,,1],[,,,,,,,,,1,,,,,,,,,,1],[1,1,1,1,1,1,,1,1,1,,,1,1,,1,,1,,,1,1,1,,,1],[,,,,,1,,,,,,,,,,,,,1],[,1,,,,,,,,,,,,1,,1,1,,1,,,1],[,,,,,1,,,,,,,,,,,,,,1],[,1,1,1,1,,,,,1,,,1,,1,,,,1,1,,,,1,1],[,1,,,1,,,1,,1,1,,1,,,,,,,1],[,,1,,1,,,1,,,,,,,,,,,1,1,,,,1],[,1,,,,,,,,,,,,,,,,,1,,,,,,1],[,,,,,,,,,,,,,,,,,,1],[,1,1,,,,,,,,,,,,,,,,1,,1,1],[,,,,,,,,,,,,1],,[,1,1,1,1,,,,1,1,,1,1,1,1,1,1,,1,1,1,1,,1,,1],[1,,,,1,,,,,,,,,,1],[1,,,,,,,,,1],,[,1,,,,1,,,,,,,,,,,,,,,,,,,,1]],[,[1,1,1,1,1,1,1,1,1,1,1,1,,1,,1,1,1,1,,,,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,,1,1,,1,1,1,,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,,1,1,1,1,1,1,1,1,1,1,,,1,1,1,,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]],[,[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,,1,,1,1,1,1],[1,1,1,1,,1,1,1,,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1],[,,,1,1,1,1,,1,,,,1,1,,,1,1,,1],[,1,1,,1,,,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,,,,,,,,,,,,,1],[1,1,1,,,,,1,1,1,,1,1,1,1,,,1,1,,1,1,,,,,1],[,1,,,,,,,1,1,,,1,1,1,,1,,,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,,,1,1,1,1,1,,1,1,1,1,1,1],[,1,,,,1,,,,1,,,1,,,,1,,,,,,,1,1],[,1,1,1,1,1,,,1,1,1,,1,1,1,1,,,1,1,1,1,,,,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,,1,,,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,,1,1,1,1,1,1],[1,1,1,,1,,,1,1,1,1,,1,1,1,1,,,,1,,1,,1,,,1],[1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,,,,1,,,,,,,,,1,1,,,,,,,,,1],,[,1,,1,,1,,1,,1,,1,1,1,1,1,,,1,,1,,1,,,,1],[,1,,,1,1,,1,1,1,,,1,1,1,1,1,,1,1,1,,1,,,1],[1,,,1,,,,1,1,1,,,,,1,1,,,,1,,1],[1,1,,1,1,1,1,,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1],[1,1,,,,,,,,1,,1,,,,,,,,1,,1],[,1,,,,1,,1,1,,,,1,1,,1,,,,1,1,1,,1],,[,1,,,,,,1,,,,,,,1],[,,,,,,,,1,,,,1,,1,,,,,,,,,,,,1]],[,[,1,1,,1,1,1,1,,1,1,1,,1,1,,1,1,,1,1,1,1,1,1,,1],[,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1],[,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,,1,1,1,1,1,1,1,1,1,,1,,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1],[,1,1,,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]],[,[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,,1,,1],[1,1,1,1,1,,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,,1,1,1,1,1,1,1,1,1,1],[,1,,,1,,,,,,,,1,,,,,,1,,,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,,1,,1,1,1,1,1,1,,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1],[,1,1,,1,,,,1,1,1,,1,1,1,1,,,1,1,1,1,,,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,,1],[1,1,,1,,1,,1,,1,1,1,1,1,1,1,,1,1,,,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1],[1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,,1,1],[,1,1,,,,,1,1,1,,,1,,1,1,,,,1,,1,,,1,1],[,,,,,,,1,,,,1,1,1,1,1,,1,,,,,,,,1],[1,1,1,1,,1,1,1,,1,,1,1,1,1,,1,,1,,1,1,,,1,,1],[,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,,,,1,1,,1,,1,1,1,,1,,1,1,,1,1,,1,,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,,,,,,,,1,,,,,1,,1],[,1,1,1,,1,,1,,1,,,,1,,1,,,1,,,,,,1,1],[,1,,,1,1,,1,,1,,1,1,1,1,1,,1,1,,,1,,,1],[1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,,1,,,,,1,,1,,1,,,,,,1,,1,,,,1,1]],[,[,1,,1,,,,,,,,,,,,,,,1,,,,1],[,,,,,,,,,1,,1,1,1,,1,,,1,,1,1],[1,1,,,,,,,1,,,,,,,1,,,,,,1],[,1,,,,,,,,,,1,,,,,,,,,1,1],,[,,,,,,,,,,,,,,,1,,,,1,,1],[,,1,1,,1,,1,,,,,,,,1,,,,,,1],[,,,,,,,,,,,,,,,,,,,,1,1],[,1,,,,,,,,,,,,,1],[1,,1,1,,,,1,,,,,,,,,1,,,1,,,1,1],[,1,1,,1,1,,1,1,1,1,1,1,1,1,1,,,1,1,,1,1,,1],[,1,,,1,1,,,,,,1,,1,,1,,,1,,1,1],[1,1,1,1,,1,,1,,1,,1,1,,1,1,1,1,1,,1,1,1,1,1],[,1,1,,,1,,1,,1,1,1,,,1,1,1,,1,1,1,1,,1,1],[,,,,1,,,1,,,,,,,1,,,,1,1],[,1,,,,,,,,,,1,,1,,1,,,,,1,,,,,1],,[1,1,,1,,1,,1,1,,,,,,1,1,,,1,1,1,1,1,1,1,1,1],[1,1,,1,,,,,,1,,,,,,1,1,,,,1,1,,,1],[,1,1,,1,1,,,,1,,1,1,1,1,1,,1,1,1,1,1,,1,1,1,1],[,1,1,,,1,,,,1,,,,1,1],[,,,,1],[,,,,,,,,,1,,,1],,[,,1,,1,,,,,,,,,1,,,,,,,,,,,,1],[,,,,,,,,,,,,,1]],[,[1,1,1,1,1,1,1,1,1,1,,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1],[,,1,1,,1,1,1,1,1,,,1,1,1,1,1,,1,1,1,1,1,,,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,,1,,,,,1],[,1,,1,,,,,,1,,,,,1,1,,,,,1,1],[,1,1,,1,1,1,1,1,1,1,1,1,1,,1,1,1,,1,,,1,,1,1,1],[,1,,,,1,,,,,,,1],[,1,,,1,,,1,,1,,1,1,,1,,,,,1,,1,,,,1,1],[,1,,,1,,,1,1,1,,1,1,1,1,1,,1,1,,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,,1,1,1,1,1,1,1,1,1],[,,,,,,,,,,,,,,,,,,,,1],[,1,1,1,,,,1,1,,,,,,1,1,1,,1,1,1,1],[1,1,1,1,1,1,1,1,1,,1,1,1,,1,1,1,1,1,1,1,1,1,1,,1,1],[,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,,1,1,1,1,1,,1,1,1,1],[,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,,,1,1,1,1,1,1,1,,1,,1,1,1,1,1,,1,1,,1,1,1,1,1],[,1,,,,1,,,,1,,1,1,1,1,1,1,1,1,1,1,1],[,1,,,,1,,,,,,,,1,,,,,,,,,,1],[,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1],[1,1,,1,1,1,,1,1,1,,,1,1,1,1,1,1,1,1,1,1,,1,,1],[1,1,,,,,,,1,1,,,,,1,1,1,1,1,,1,1,1,1,,1],[,1,1,1,1,1,1,1,,1,1,1,,1,,1,1,1,1,,1,1,,1,1,1,1],,[,1,1,,,,,1,,1,,,,1,1,1,,,1,,,,,1],[,,,,,,,,,,,,,1],[,,,,,1,,,,,,,,1,1,,,,,1,,1,,,1,1],[,,,,,,,,,,,,,,1]],[,[,1],,,,,,,,,,,,,,,,,,,,[1,1,1,1,1,,1,1,1,1,,1,1,1,1,,1,1,1,1,,,1,1,1,1,1],[,1,,1,,1,,,1,1,1,,1,1,1,1,1,,,1,,,,1,,1,1],[,1,,1,,1,,,1,,,,,1,,,,,,1,1],[,1,,1,,,,,1,,,,1,,1,1,1,1,1,1,1,1,,1],[,1,,,,,,,,,,,,,,,1]],[,[,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,,1,,,,,,,,,1,1,,,,1],[,,,,,,1],[,,1],[,1,1,,,1,,1,,1,1,,1,1,1,,,,1,1,1,,,,,1],,[,1,,,,1,,,,,,1,,,1,,,,1,1,,1],[,,,,,,,1,,,,,,,,,1],[,1,,,,1,1,,,,,,1,1,1,,,,1,,1,1],[,,,,,,,1,,1,,,,,,,,,,1],[,1,1,,,,,,1,1,,,,1,,,,,,,1,,,1],,[1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,,,1,,,1,,,,,1,,1,,1,,1,,,,,1],[1,1,1,1,1,1,1,1,,,,,1,1,,1,1,,1,,,1,,1],[,,,,,,,,,,,,,,1,,,,,,1],,[,,,,,,,,,1,,,,,,1,,,,,1],[,,1,,,,,,,1,,,1,1],[,,,1,,,,,1,,,,,1,,,,,,1,,,,1],[1,,1,1,,1,1,1,1,1,,1,,,,1,1,1,,,1,1,,,,1,1],,[1,1,,,,,,,,,,1,,1,,1,,,1],[,,,,1,,,,,,,,,,,,,,,,,,,1],[,,,,,,,,,,,,,,1,,,,,1,,1],[,,,,,,,,1]],[,[1,1,1,1,1,1,1,,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,,,1,1,1,1,1,,1,1,,1,1,1,1,,1,1,1,1,1,1],[1,1,1,1,,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1],[,,1,,,1,,,,,,,,1,,,,,,1,,,,1],[1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,,1,1,1,1],[1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,,1,1,,1,,,,1,1,1,1,1,1,,1,1,1,1,,1],[1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,,1,1,1,1,1,1,1,1,,1,1,1,,1,1,1,1,1,1,,1,1,1,1],[1,1,1,1,1,,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1],[1,,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1],[1,1,1,1,1,1,,1,1,1,1,1,1,,1,1,1,1,1,1,,1,1,1,1,1,1],[,,1,1,1,1,,1,,1,,1,1,1,1,1,1,1,1,1,1,1,1,,1,1],[1,1,,,,,,,1,,1,1,,1,1,1,,1,1,1,1,1],[1,1,1,1,,1,1,1,1,1,,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1],[1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1],[1,1,1,1,,1,,1,,1,1,1,1,1,,,,1,1,1,1,,1,1,1,1,1],[1,1,1,1,,1,,,,,,1,,1,,,,,1,1,,,,,1],[1,,1,1,,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,,1,1,,1,,1,,,,1,1,1,1,1,,,1,1,,1,,1],[,1,1,1,1,,,,,1,,1,1,1,1,1,,,1,1,,,,1,1,1],[,1,1,1,1,1,,1,,,,,1,,1,,1,,,1,,,1,1,,1]],[,[1,1,1,1,1,1,1,1,,1,1,1,1,,1,1,1,1,1,1,,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,,1,1,1,,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,,1,1],[1,1,1,1,1,1,1,1,1,1,,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,,,,,,,,,1,,,,,1,1,,,1,,1],[1,1,1,1,1,1,1,1,1,1,1,,,,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,,,1,1,1,1,,1,1,,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1],[1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1],[,1,,,,,,1,,1,1,,1,1,1,1,1,,,1,,1,,1],[1,1,1,,1,1,1,1,,,,1,1,1,1,,1,1,1,1,1,1,1,1,1,,1],[1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1],[1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,,1,1,1,1,1,1,1,1,1,,1,1,,1,1,1,1,1,,1,1,1,1,1,1],[,1,,1,,1,1,1,,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1],[,,1,,,,,,,,,,1,1,1,1,1,1,1,,1,1,,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,,,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1],[,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,,1,1,1,1,1,1,1,1],[,1,,,1,1,,,,,,1,1,1,1,1,,,,1,1,1,,1,1,1],[1,1,1,1,1,1,1,1,1,,,,1,1,1,1,1,1,1,,1,1,,1,1,1],[,1,1,1,,1,,1,1,1,1,,,1,1,1,,1,1,1,1,1,,,1,1],[1,1,,,,1,,,1,1,1,,1,,1,,1,,1,1,1,1,1,,1,,1],[,1,,,,,,,1,,1,,1,1,1,1,,,,,,,,,1]],[,[,,,,,,,,,,,,,1,1,,,,1],[,1,,,,,,,,1,,,1,,,,,,1,,,1,,,,1],,[,1,,,,1,,1,,1,1,,1,1,,,,,,,,1],[,,,,,,,,,,,,,,,,,,,1],[,,,,,,,,,1],[1,1,1,,,1,,,,,,,,,1,1,,,,,,,,,,1],[,1,,,,,,,,,,,,,1],[,,,,,,,,,,,,,,,,,,,1,,,1],[,,,,,,,,,1],[1,1,,,,,,1,1,1,,1,1,,,,1,1,,1,,1,1,1,,1],[,1,1,1,,1,1,,,1,,1,1,1,1,,,,,,,1,,1],[,1,1,1,1,,,1,,1,,,,1,1,1,1,,1,1,,1],[,1,,,1,1,,1,,,,1,,1,1,,1,,1,,,1,,,1,,1],[,,,,,,,,,,,1],[,,,,,,,,,1,,,,,,,,,,,,,1],,[1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,,1,,1,1,1,1,1,1,1],[,1,,,,,,,1,1,,1,,,,,1,,,1,,1],[,1,,,,1,,,1,,,,,,,,1,,1,,,1],[,,,,,,,,,,,,,1,1,,,,1,,,1],[,,,,,1,,,1,,,,1],[,1],,[,1],[1,,,,,,,,,,,,,,1,,,,,1]],[,[,1,,,,1,1,1,1,1,1,,1,1,1,1,1,,1,1,,1,1,,,1],[,,1,,,,,,,,,1],,,[1,,,1,1,,,,,,,,1,1,,1,1,,1],,[,,,,,,,,,,,,,,,,,,1,,1],,[1,,,1,1,,1,1,,,,,1,,1,,,,,1,1,,1],,[,1,,,,,,,,1,1,1,1,1,,1,1,,,,1,1],[,,,,,,,,,,,,,,,,1,,,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,,,1,1,1,1,,1,1,1,1,1,1],[,,,,,,,,,,,1,,1,,,1],[1,,,,,,,,,,,,,,,,,,1,,1],,,[,1,,,,,,,,,,,,,,1,,,,1,1],[,,,,,,,,,1,,,1,,,,,,,,,,1],[,,,,,,,,,,,,,,,1],[,,,,,,,,,,,,,1,1,,,,,,1],,[,1]],[,[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,,,1,1,,1,1,1,1,1,1,,,1,1,1,1,1,,1,1],[,1,,,,,,,,1],[,,,,1,,,1,,,1,1,,,,,,,,,,1,,,,1],[,1,,1,1,,,1,1,1,,,,1,1,1,1,,1,1,1,1,,1],[,,,,,,,1],[,1,1,,,,,1,,1,,,,,,1,,,,,,1,,1,,1],[,1,,,,,,1,,,,1,,,,,,,,,,1],[,,1,1,,1,1,1,1,1,1,1,1,1,1,,,,1,,1,1,1,1,,1],[,1,,,,,,,,1],[,1,1,,1,,,,,,,,1,,,,,,1,,,1,,1,,1],[,1,,1,,1,,1,1,1,,1,1,1,,1,,,1,1,,1,1,1,1,1],[,1,1,1,1,1,,,1,1,,,,1,1,1,,,,1,1,,,1,1],[,,1,1,1,1,,1,,1,,1,,1,1,1,1,,,,,1,,1,,1],[1,1,1,1,1,1,1,1,,1,,1,,1,1,1,,,1,1,,,,1,,1],[,,,1],,[,1,1,,1,,,1,1,1,,1,1,1,1,1,1,,1,1,,1,1,1,1,1,1],[,1,,,,,,1,,1,,1,,,,,,,1,1,,1,1],[,,,,,,1,,1,1,,1,,1,,,,,,,,,,1],[,1,1,,1,,,,1,,,,1,1,1,,,,1,,1,1,1,,1,1],,[,1,1,,,,,,,,,,,,,1,,,1,,,,,1],[,1,,,,,,,,,,,,,,,,,,,,,,1],[,1,1,,,,,,,1,,,,1,,,,,1,,,,,,,1]],[,[,1,1,1,1,1,,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1],[,1,1,1,1,1,,1,,1,1,,,1,1,1,1,,1,,,,,1,1,1],[,,1,1,,1,,1,1,,,,1,1,1,1,,,1,,1,1,1,1,,1],[,1,,1,,,,,,,,1,,1,,1,,,,,,,,,,1],[,,1,,1,,,1,,,,,1,1,,,1,,1,1,1,1],[,1],[,1,1,,1,,1,1,,1,,,1,1,1,,,,1,,,1,,1],[1,1,,1,1,1,,,,,,,,,,,,,1,,1,1,1],[,1,1,,,,,,,1,,,1,,1,,1,,1,1,,,1,,,1],[,,1,,,,,,,,,,,,,,,,,,1],[,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,,1,,1,,,,,1,1,1,,,1,,1,,,,1],[,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,,1,,,1,1,1,,1,,1,1,1,,,1,1,1,1,,,,1,1],[,,,1,1,,,1,,1,,1,,1,1,1,1,,1,,,,,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,,,,,,,,,,,,,,,,,,,1],[,1,1,,1,1,,1,,1,,,,1,1,,,1,1,,1,1,,1],[,1,1,1,1,1,,,1,1,1,,1,1,1,1,1,1,1,1,,1,1,,,1],[,1,1,1,1,1,,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,,1,1],[,1,1,,1,,,1,,,1,,1,1,1,1,1,,1,,1,1],[,,,,,1,,,,1,,,,,1,1,,,,1],[,1,,1,1,1,,1,,,1,1,1,,,1,,,1,,1,,,1],[,,1,,,,,,,,,1,,1,,,,,1,,1],[,1,1,,,,,,,,1,1,1,,,,,,,,1,,,,,1],[,,,,,,,,1,,,,,1,,,1]],[,[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,,1,1,,,1,1,1,1,1,1,1,1,,,,,,,,,1,1],[,,,,,,,,1,,,,1,,1,,1],[,1,,,1,1,,1,,,,1,,,,,,,,1],[,1,,1,,1,,,,1,1,,1,,1,,,,1,1,1,1,1,,,1],,[,1,,,,,,,,1,,,1,1,,,1,,1,1,,1,,1],[,1,,,1,,,,,,,,1,,,,,,,1],[1,1,,,,,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,,1,1,1],,[,1,,,,,,1,,1,,1,1,1,1,1,,,1,,1,1,,,,1],[,1,1,,,1,,1,,1,,,1,1,1,1,,,1,,,1,,,,1],[,1,1,1,1,1,,1,1,1,,1,1,1,1,1,1,1,1,1,1,,,,1,,1],[,1,,,1,1,,1,1,,,1,1,,1,1,,1,,1,,1],[1,,1,,,,,1,,1,,1,1,1,1,,,,,1,1,,,,1,1],[,1,1,,,,,1,1,,,1,,1,1,1,1,,,,,,,,,,1],,[,1,1,,,1,,,,1,,1,1,1,1,1,,,,1,,,,1,,1],[,,,1,1,,,1,,,,,1,,1,1,1,,1,1,,,,,,1],[,1,,,,,,,,,,,1,,,,1,,,,,,,1,,1],[,1,1,1,1,1,1,1,,1,1,1,1,1,1,,1,1,1,,1,1,,1,1,1,1],[,1,,,,,,,,,,,,,,,,,,,1],[,1,,,,,,1,,,,,1,,1,,,1,1,,1,1,,1],[,1,,,,,,1,,,,,1,1,,,,,,,,1,,,,1],[,,,,,,,,,,,,,,,,,,1,,,1,,,,,1],[,,,,,,,1,,,,1]],[,[1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1],[,1,,1,,1,,,,,,,1,,,,,,,,1,,,1],[,1,,,,,,,1],[,,,,,,,,,,1],[,1,,,,,,1,1,,,,,,1],,[,1,1,,,,,,1,,,,,1,1,,,,1],[1,,1,,1,,,,,1,,,,,1,,,,,,,,,1,1],[,1,1,,,,,,,,,1,1,1,1,,,,1,,,,,1,,,1],,[,1,1,,1,,,1,1,,,1,,,1,1,1,,1,,1,1,1,,,,1],[,,,,,1,,,,,1,,,1,1,,,1,,1,,,,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,,,1,1,,1,,,,1,,,,,,,,1],[,,,1,,,,,1,,,,,1,,1,,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,,,,,1],[,1,,,,,,1,,,,,,,1,1,1,,,1],[,1,,,,,,,,,,1,1,1,,,,,1,,,1],[,,,,,1,,1,,,,,1,1,1,,1,1,,1,1,1,,,1,1],[1,1,,,,,,,1,,,,,1,1,,,,,,,,,,,1],,[,1],[,,,,,,,,,,,,,,,,,,,,,,,,1],[,,1,,,,,1,,,1,,,,1,,1],[,1,,,,,,,,,1]]];function fo(e){e=Array.isArray(e)?e:po;var a=[];return e.forEach(function(e,t){var r=String.fromCharCode(t+96).replace("`","");Array.isArray(e)?a=a.concat(fo(e).map(function(e){return r+e})):a.push(r)}),a}var mo=function(e){for(var t=po;e.length<3;)e+="`";for(var r=0;r<=e.length-1;r++){if(!(t=t[e.charCodeAt(r)-96]))return!1}return!0};var ho=function(){Xs(i,tt);var o=Js(i);function i(e){var t,r,a,n;return rc(this,i),(t=o.call(this))._props=function(e){var t=e.nodeName,r=e.nodeType,a=void 0===r?1:r;ht("number"==typeof a,"nodeType has to be a number, got \'".concat(a,"\'")),ht("string"==typeof t,"nodeName has to be a string, got \'".concat(t,"\'")),t=t.toLowerCase();var n=null;"input"===t&&(n=(e.type||e.attributes&&e.attributes.type||"").toLowerCase(),co().includes(n)||(n="text"));var o=ec({},e,{nodeType:a,nodeName:t});n&&(o.type=n);return delete o.attributes,Object.freeze(o)}(e),t._attrs=(r=e.attributes,a=void 0===r?{}:r,n={htmlFor:"for",className:"class"},Object.keys(a).reduce(function(e,t){var r=a[t];return ht("object"!==Gs(r)||null===r,"expects attributes not to be an object, \'".concat(t,"\' was")),void 0!==r&&(e[n[t]||t]=null!==r?String(r):null),e},{})),t}return ac(i,[{key:"attr",value:function(e){return this._attrs[e]||null}},{key:"hasAttr",value:function(e){return void 0!==this._attrs[e]}},{key:"props",get:function(){return this._props}}]),i}(),go={};t(go,{allowedAttr:function(){return bo},arialabelText:function(){return yo},arialabelledbyText:function(){return Fi},getAccessibleRefs:function(){return $i},getElementUnallowedRoles:function(){return Ki},getExplicitRole:function(){return xo},getOwnedVirtual:function(){return ei},getRole:function(){return Bo},getRoleType:function(){return Wi},getRolesByType:function(){return Ji},getRolesWithNameFromContents:function(){return tl},implicitNodes:function(){return nl},implicitRole:function(){return Oo},isAccessibleRef:function(){return ol},isAriaRoleAllowedOnElement:function(){return Gi},isUnsupportedRole:function(){return Do},isValidRole:function(){return wo},label:function(){return il},labelVirtual:function(){return xa},lookupTable:function(){return al},namedFromContents:function(){return Zo},requiredAttr:function(){return ll},requiredContext:function(){return ul},requiredOwned:function(){return sl},validateAttr:function(){return dl},validateAttrValue:function(){return cl}});var vo=function(){if(xr.get("globalAriaAttrs"))return xr.get("globalAriaAttrs");var e=Object.keys(Ga.ariaAttrs).filter(function(e){return Ga.ariaAttrs[e].global});return xr.set("globalAriaAttrs",e),e};var bo=function(e){var t=Ga.ariaRoles[e],r=Zs(vo());return t&&(t.allowedAttrs&&r.push.apply(r,Zs(t.allowedAttrs)),t.requiredAttrs&&r.push.apply(r,Zs(t.requiredAttrs))),r};var yo=function(e){if(!(e instanceof tt)){if(1!==e.nodeType)return"";e=wn(e)}return e.attr("aria-label")||""};var Do=function(e){var t=Ga.ariaRoles[e];return!!t&&!!t.unsupported};var wo=function(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},r=t.allowAbstract,a=t.flagUnsupported,n=void 0!==a&&a,o=Ga.ariaRoles[e],i=Do(e);return!(!o||n&&i)&&(!!r||"abstract"!==o.type)};var xo=function(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},r=t.fallback,a=t.abstracts,n=t.dpub;if(1!==(e=e instanceof tt?e:wn(e)).props.nodeType)return null;var o=(e.attr("role")||"").trim().toLowerCase();return(r?so(o):[o]).find(function(e){return!(!n&&"doc-"===e.substr(0,4))&&wo(e,{allowAbstract:a})})||null};var Eo=function(r){return Object.keys(Ga.htmlElms).filter(function(e){var t=Ga.htmlElms[e];return t.contentTypes?t.contentTypes.includes(r):!!t.variant&&(!(!t.variant.default||!t.variant.default.contentTypes)&&t.variant.default.contentTypes.includes(r))})};var Ao=Sn(function(e){for(var t=[],r=e.rows,a=0,n=r.length;a<n;a++){var o=r[a].cells;t[a]=t[a]||[];for(var i=0,l=0,u=o.length;l<u;l++)for(var s=0;s<o[l].colSpan;s++){for(var c=0;c<o[l].rowSpan;c++){for(t[a+c]=t[a+c]||[];t[a+c][i];)i++;t[a+c][i]=o[l]}i++}}return t});var Co=Sn(function(e,t){var r,a;for(t=t||Ao(Xr(e,"table")),r=0;r<t.length;r++)if(t[r]&&-1!==(a=t[r].indexOf(e)))return{x:a,y:r}});var Fo=function(e){var t=e.getAttribute("scope"),r=e.getAttribute("role");if(e instanceof window.Element==!1||-1===["TD","TH"].indexOf(e.nodeName.toUpperCase()))throw new TypeError("Expected TD or TH element");if("columnheader"===r)return"col";if("rowheader"===r)return"row";if("col"===t||"row"===t)return t;if("TH"!==e.nodeName.toUpperCase())return!1;var a=Ao(Xr(e,"table")),n=Co(e,a);return a[n.y].reduce(function(e,t){return e&&"TH"===t.nodeName.toUpperCase()},!0)?"col":a.map(function(e){return e[n.x]}).reduce(function(e,t){return e&&t&&"TH"===t.nodeName.toUpperCase()},!0)?"row":"auto"};var ko=function(e){return-1!==["col","auto"].indexOf(Fo(e))};var Ro=function(e){return["row","auto"].includes(Fo(e))},To=Eo("sectioning").map(function(e){return"".concat(e,":not([role])")}).join(", ")+" , main:not([role]), [role=article], [role=complementary], [role=main], [role=navigation], [role=region]";function No(e){var t=ga(Fi(e)),r=ga(yo(e));return t||r}var _o={a:function(e){return e.hasAttr("href")?"link":null},area:function(e){return e.hasAttr("href")?"link":null},article:"article",aside:"complementary",body:"document",button:"button",datalist:"listbox",dd:"definition",dfn:"term",details:"group",dialog:"dialog",dt:"term",fieldset:"group",figure:"figure",footer:function(e){return er(e,To)?null:"contentinfo"},form:function(e){return No(e)?"form":null},h1:"heading",h2:"heading",h3:"heading",h4:"heading",h5:"heading",h6:"heading",header:function(e){return er(e,To)?null:"banner"},hr:"separator",img:function(t){var e=t.hasAttr("alt")&&!t.attr("alt"),r=vo().find(function(e){return t.hasAttr(e)});return!e||r||_a(t)?"img":"presentation"},input:function(e){var t,r;switch(e.hasAttr("list")&&(r=(t=Da(e.actualNode,"list").filter(function(e){return!!e})[0])&&"datalist"===t.nodeName.toLowerCase()),e.props.type){case"button":case"image":case"reset":case"submit":return"button";case"checkbox":return"checkbox";case"email":case"tel":case"text":case"url":case"":return r?"combobox":"textbox";case"number":return"spinbutton";case"radio":return"radio";case"range":return"slider";case"search":return r?"combobox":"searchbox"}},li:"listitem",main:"main",math:"math",menu:"list",nav:"navigation",ol:"list",optgroup:"group",option:"option",output:"status",progress:"progressbar",section:function(e){return No(e)?"region":null},select:function(e){return e.hasAttr("multiple")||1<parseInt(e.attr("size"))?"listbox":"combobox"},summary:"button",table:"table",tbody:"rowgroup",td:function(e){var t=er(e,"table"),r=xo(t);return["grid","treegrid"].includes(r)?"gridcell":"cell"},textarea:"textbox",tfoot:"rowgroup",th:function(e){return ko(e.actualNode)?"columnheader":Ro(e.actualNode)?"rowheader":void 0},thead:"rowgroup",tr:"row",ul:"list"};var Oo=function(e){var t=e instanceof tt?e:wn(e);if(e=t.actualNode,!t)throw new ReferenceError("Cannot get implicit role of a node outside the current scope.");if(e&&"http://www.w3.org/2000/svg"===e.namespaceURI)return null;var r=t.props.nodeName,a=_o[r];return a?"function"==typeof a?a(t):a:null},So={td:["tr"],th:["tr"],tr:["thead","tbody","tfoot","table"],thead:["table"],tbody:["table"],tfoot:["table"],li:["ol","ul"],dt:["dl","div"],dd:["dl","div"],div:["dl"]};function Po(e,t){var r=Oo(e);if(!r)return null;var a=function e(t,r){var a=So[t.props.nodeName];if(!a)return null;if(!t.parent)throw new ReferenceError("Cannot determine role presentational inheritance of a required parent outside the current scope.");if(!a.includes(t.parent.props.nodeName))return null;var n=xo(t.parent,r);return["none","presentation"].includes(n)&&!Io(t.parent)?n:n?null:e(t.parent,r)}(e,t);return a||r}function Io(t){return vo().some(function(e){return t.hasAttr(e)})||_a(t)}var Bo=function(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},r=t.noPresentational,a=function(e,t){var r=1<arguments.length&&void 0!==t?t:{},a=r.noImplicit,n=Ks(r,["noImplicit"]),o=e instanceof tt?e:wn(e);if(1!==o.props.nodeType)return null;var i=xo(o,n);return!i||["presentation","none"].includes(i)&&Io(o)?a?null:Po(o,n):i}(e,Ks(t,["noPresentational"]));return r&&["presentation","none"].includes(a)?null:a};var Lo=function(e,t){var r=Gs(t);if(Array.isArray(t)&&void 0!==e)return t.includes(e);if("function"===r)return!!t(e);if(null!=e){if(t instanceof RegExp)return t.test(e);if(/^\\/.*\\/$/.test(t)){var a=t.substring(1,t.length-1);return new RegExp(a).test(e)}}return t===e};var qo=function(t,r){if("object"!==Gs(r)||Array.isArray(r)||r instanceof RegExp)throw new Error("Expect matcher to be an object");return Object.keys(r).every(function(e){return Lo(t(e),r[e])})};function jo(t,e){return t instanceof tt||(t=wn(t)),qo(function(e){return t.attr(e)},e)}function Mo(e,t){return!!t(e)}function Uo(e,t){return Lo(xo(e),t)}function Vo(e,t){return Lo(Oo(e),t)}function Ho(e,t){return e instanceof tt||(e=wn(e)),Lo(e.props.nodeName,t)}function zo(t,e){return t instanceof tt||(t=wn(t)),qo(function(e){return t.props[e]},e)}function $o(e,t){return Lo(Bo(e),t)}var Wo={attributes:jo,condition:Mo,explicitRole:Uo,implicitRole:Vo,nodeName:Ho,properties:zo,semanticRole:$o};var Go=function t(a,n){return a instanceof tt||(a=wn(a)),Array.isArray(n)?n.some(function(e){return t(a,e)}):"string"==typeof n?Zt(a,n):Object.keys(n).every(function(e){if(!Wo[e])throw new Error(\'Unknown matcher type "\'.concat(e,\'"\'));var t=Wo[e],r=n[e];return t(a,r)})};var Yo=function(e,t){return Go(e,t)};Yo.attributes=jo,Yo.condition=Mo,Yo.explicitRole=Uo,Yo.fromDefinition=Go,Yo.fromFunction=qo,Yo.fromPrimative=Lo,Yo.implicitRole=Vo,Yo.nodeName=Ho,Yo.properties=zo,Yo.semanticRole=$o;var Ko=Yo;var Xo=function(e){var t=Ga.htmlElms[e.props.nodeName];if(!t)return{};if(!t.variant)return t;var r=t.variant,a=Ks(t,["variant"]);for(var n in r)if(r.hasOwnProperty(n)&&"default"!==n){var o=r[n],i=o.matches,l=Ks(o,["matches"]);if(Ko(e,i))for(var u in l)l.hasOwnProperty(u)&&(a[u]=l[u])}for(var s in r.default)r.default.hasOwnProperty(s)&&void 0===a[s]&&(a[s]=r.default[s]);return a},Jo=["iframe"];var Qo=function(e){var t=e instanceof tt?e:wn(e);return 1!==t.props.nodeType||!e.hasAttr("title")||!Yo(t,Jo)&&["none","presentation"].includes(Bo(t))?"":t.attr("title")};var Zo=function(e){var t=(1<arguments.length&&void 0!==arguments[1]?arguments[1]:{}).strict;if(1!==(e=e instanceof tt?e:wn(e)).props.nodeType)return!1;var r=Bo(e),a=Ga.ariaRoles[r];return!(!a||!a.nameFromContent)||!t&&(!a||["presentation","none"].includes(r))};var ei=function(e){var t=e.actualNode,r=e.children;if(!r)throw new Error("getOwnedVirtual requires a virtual node");if(e.hasAttr("aria-owns")){var a=Da(t,"aria-owns").filter(function(e){return!!e}).map(function(e){return axe.utils.getNodeFromTree(e)});return[].concat(Zs(r),Zs(a))}return Zs(r)};var ti=["#text","a","abbr","area","b","bdi","bdo","button","canvas","cite","code","command","datalist","del","dfn","em","i","ins","kbd","keygen","label","map","mark","meter","noscript","output","progress","q","ruby","s","samp","small","span","strong","sub","sup","time","u","var","wbr"];var ri=function(e){var r=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},t=Ai.alreadyProcessed;r.startNode=r.startNode||e;var a=r.strict,n=r.inControlContext,o=r.inLabelledByContext;return!t(e,r)&&1===e.props.nodeType&&(Zo(e,{strict:a})||r.subtreeDescendant)?(a||(r=ec({subtreeDescendant:!n&&!o},r)),ei(e).reduce(function(e,t){return function(e,t,r){var a=t.props.nodeName,n=Ai(t,r);if(!n)return e;ti.includes(a)||(" "!==n[0]&&(n+=" "),e&&" "!==e[e.length-1]&&(n=" "+n));return e+n}(e,t,r)},"")):""};var ai=function(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},r=Ai.alreadyProcessed;if(t.inControlContext||t.inLabelledByContext||r(e,t))return"";t.startNode||(t.startNode=e);var a,n=ec({inControlContext:!0},t),o=function(e){if(!e.attr("id"))return[];if(e.actualNode)return Yr({elm:"label",attr:"for",value:e.attr("id"),context:e.actualNode});throw new TypeError("Cannot resolve explicit label reference for non-DOM nodes")}(e),i=er(e,"label");return i?(a=[].concat(Zs(o),[i.actualNode])).sort(Br):a=o,a.map(function(e){return Ci(e,n)}).filter(function(e){return""!==e}).join(" ")},ni={submit:"Submit",image:"Submit",reset:"Reset",button:""};function oi(e,t){return t.attr(e)||""}function ii(e,t,r){var a=t.actualNode,n=[e=e.toLowerCase(),a.nodeName.toLowerCase()].join(","),o=a.querySelector(n);return o&&o.nodeName.toLowerCase()===e?Ci(o,r):""}var li={valueText:function(e){return e.actualNode.value||""},buttonDefaultText:function(e){var t=e.actualNode;return ni[t.type]||""},tableCaptionText:ii.bind(null,"caption"),figureText:ii.bind(null,"figcaption"),svgTitleText:ii.bind(null,"title"),fieldsetLegendText:ii.bind(null,"legend"),altText:oi.bind(null,"alt"),tableSummaryText:oi.bind(null,"summary"),titleText:Qo,subtreeText:ri,labelText:ai,singleSpace:function(){return" "},placeholderText:oi.bind(null,"placeholder")};function ui(r){var a=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},e=r.actualNode;if(1!==r.props.nodeType||["presentation","none"].includes(Bo(r)))return"";var t=(Xo(r).namingMethods||[]).map(function(e){return li[e]}).reduce(function(e,t){return e||t(r,a)},"");return a.debug&&axe.log(t||"{empty-value}",e,a),t}var si={accessibleNameFromFieldValue:["combobox","listbox","progressbar"]},ci=["button","checkbox","color","file","hidden","image","password","radio","reset","submit"];var di=function(e){var t=(e=e instanceof tt?e:wn(e)).props.nodeName;return"textarea"===t||"input"===t&&!ci.includes((e.attr("type")||"").toLowerCase())};var pi=function(e){return"select"===(e=e instanceof tt?e:wn(e)).props.nodeName};var fi=function(e){return"textbox"===xo(e)};var mi=function(e){return"listbox"===xo(e)};var hi=function(e){return"combobox"===xo(e)},gi=["progressbar","scrollbar","slider","spinbutton"];var vi=function(e){var t=xo(e);return gi.includes(t)},bi=["textbox","progressbar","scrollbar","slider","spinbutton","combobox","listbox"],yi={nativeTextboxValue:function(e){var t=e instanceof tt?e:wn(e);if(di(t))return t.props.value||"";return""},nativeSelectValue:function(e){var t=e instanceof tt?e:wn(e);if(!pi(t))return"";var r=no(t,"option"),a=r.filter(function(e){return e.hasAttr("selected")});a.length||a.push(r[0]);return a.map(function(e){return wa(e)}).join(" ")||""},ariaTextboxValue:function(e){var t=e instanceof tt?e:wn(e),r=t.actualNode;if(!fi(t))return"";return!r||r&&!Ra(r)?wa(t,!0):r.textContent},ariaListboxValue:Di,ariaComboboxValue:function(e,t){var r,a=e instanceof tt?e:wn(e);return hi(a)&&(r=ei(a).filter(function(e){return"listbox"===Bo(e)})[0])?Di(r,t):""},ariaRangeValue:function(e){var t=e instanceof tt?e:wn(e);if(!vi(t)||!t.hasAttr("aria-valuenow"))return"";var r=+t.attr("aria-valuenow");return isNaN(r)?"0":String(r)}};function Di(e,t){var r=e instanceof tt?e:wn(e);if(!mi(r))return"";var a=ei(r).filter(function(e){return"option"===Bo(e)&&"true"===e.attr("aria-selected")});return 0===a.length?"":Ai(a[0],t)}function wi(r){var a=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},e=r.actualNode,t=si.accessibleNameFromFieldValue||[],n=Bo(r);if(a.startNode===r||!bi.includes(n)||t.includes(n))return"";var o=Object.keys(yi).map(function(e){return yi[e]}).reduce(function(e,t){return e||t(r,a)},"");return a.debug&&Qe(o||"{empty-value}",e,a),o}function xi(r){var a=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},e=r.actualNode,a=function(e,t){var r=e.actualNode;t.startNode||(t=ec({startNode:e},t));if(!r)return t;1===r.nodeType&&t.inLabelledByContext&&void 0===t.includeHidden&&(t=ec({includeHidden:!ia(r,!0)},t));return t}(r,a);if(function(e,t){var r=e.actualNode;if(!r)return!1;if(1!==r.nodeType||t.includeHidden)return!1;return!ia(r,!0)}(r,a))return"";var t=[Fi,yo,ui,wi,ri,Ei,Qo].reduce(function(e,t){return a.startNode===r&&(e=ga(e)),""!==e?e:t(r,a)},"");return a.debug&&axe.log(t||"{empty-value}",e,a),t}function Ei(e){return 3!==e.props.nodeType?"":e.props.nodeValue}xi.alreadyProcessed=function(e,t){return t.processed=t.processed||[],!!t.processed.includes(e)||(t.processed.push(e),!1)};var Ai=xi;var Ci=function(e,t){var r=wn(e);return Ai(r,t)};var Fi=function(a){var n=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{};if(!(a instanceof tt)){if(1!==a.nodeType)return"";a=wn(a)}return 1!==a.props.nodeType||n.inLabelledByContext||n.inControlContext||!a.attr("aria-labelledby")?"":Da(a,"aria-labelledby").filter(function(e){return e}).reduce(function(e,t){var r=Ci(t,ec({inLabelledByContext:!0,startNode:n.startNode||a},n));return e?"".concat(e," ").concat(r):r},"")},ki={};function Ri(){return/[\\u1D00-\\u1D7F\\u1D80-\\u1DBF\\u1DC0-\\u1DFF\\u20A0-\\u20CF\\u20D0-\\u20FF\\u2100-\\u214F\\u2150-\\u218F\\u2190-\\u21FF\\u2200-\\u22FF\\u2300-\\u23FF\\u2400-\\u243F\\u2440-\\u245F\\u2460-\\u24FF\\u2500-\\u257F\\u2580-\\u259F\\u25A0-\\u25FF\\u2600-\\u26FF\\u2700-\\u27BF\\uE000-\\uF8FF]/g}function Ti(){return/[\\u2000-\\u206F\\u2E00-\\u2E7F\\\\\'!"#$%&\\xa3\\xa2\\xa5\\xa7\\u20ac()*+,\\-.\\/:;<=>?@\\[\\]^_`{|}~\\xb1]/g}function Ni(){return/[\\uDB80-\\uDBBF][\\uDC00-\\uDFFF]/g}t(ki,{accessibleText:function(){return Ci},accessibleTextVirtual:function(){return Ai},autocomplete:function(){return Li},formControlValue:function(){return wi},formControlValueMethods:function(){return yi},hasUnicode:function(){return Oi},isHumanInterpretable:function(){return Ii},isIconLigature:function(){return Bi},isValidAutocomplete:function(){return qi},label:function(){return Ui},labelText:function(){return ai},labelVirtual:function(){return Mi},nativeElementType:function(){return Vi},nativeTextAlternative:function(){return ui},nativeTextMethods:function(){return li},removeUnicode:function(){return Pi},sanitize:function(){return ga},subtreeText:function(){return ri},titleText:function(){return Qo},unsupported:function(){return si},visible:function(){return ji},visibleTextNodes:function(){return Hi},visibleVirtual:function(){return wa}});var _i=a($e());var Oi=function(e,t){var r=t.emoji,a=t.nonBmp,n=t.punctuations;return r?_i.default().test(e):a?Ri().test(e)||Ni().test(e):!!n&&Ti().test(e)},Si=a($e());var Pi=function(e,t){var r=t.emoji,a=t.nonBmp,n=t.punctuations;return r&&(e=e.replace(Si.default(),"")),a&&(e=(e=e.replace(Ri(),"")).replace(Ni(),"")),n&&(e=e.replace(Ti(),"")),e};var Ii=function(e){if(!e.length)return 0;if(["x","i"].includes(e))return 0;var t=Pi(e,{emoji:!0,nonBmp:!0,punctuations:!0});return ga(t)?1:0};var Bi=function(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:.15,r=2<arguments.length&&void 0!==arguments[2]?arguments[2]:3,a=e.actualNode.nodeValue.trim();if(!ga(a)||Oi(a,{emoji:!0,nonBmp:!0}))return!1;xr.get("canvasContext")||xr.set("canvasContext",document.createElement("canvas").getContext("2d"));var n=xr.get("canvasContext"),o=n.canvas;xr.get("fonts")||xr.set("fonts",{});var i=xr.get("fonts"),l=window.getComputedStyle(e.parent.actualNode).getPropertyValue("font-family");i[l]||(i[l]={occurances:0,numLigatures:0});var u=i[l];if(u.occurances>=r){if(u.numLigatures/u.occurances==1)return!0;if(0===u.numLigatures)return!1}u.occurances++;var s=30,c="".concat(s,"px ").concat(l);n.font=c;var d,p=a.charAt(0),f=n.measureText(p).width;f<30&&(f*=d=30/f,c="".concat(s*=d,"px ").concat(l)),o.width=f,o.height=s,n.font=c,n.textAlign="left",n.textBaseline="top",n.fillText(p,0,0);var m=new Uint32Array(n.getImageData(0,0,f,s).data.buffer);if(!m.some(function(e){return e}))return u.numLigatures++,!0;n.clearRect(0,0,f,s),n.fillText(a,0,0);var h=new Uint32Array(n.getImageData(0,0,f,s).data.buffer),g=m.reduce(function(e,t,r){return 0===t&&0===h[r]||0!==t&&0!==h[r]?e:++e},0),v=a.split("").reduce(function(e,t){return e+n.measureText(t).width},0),b=n.measureText(a).width;return t<=g/m.length&&t<=1-b/v&&(u.numLigatures++,!0)},Li={stateTerms:["on","off"],standaloneTerms:["name","honorific-prefix","given-name","additional-name","family-name","honorific-suffix","nickname","username","new-password","current-password","organization-title","organization","street-address","address-line1","address-line2","address-line3","address-level4","address-level3","address-level2","address-level1","country","country-name","postal-code","cc-name","cc-given-name","cc-additional-name","cc-family-name","cc-number","cc-exp","cc-exp-month","cc-exp-year","cc-csc","cc-type","transaction-currency","transaction-amount","language","bday","bday-day","bday-month","bday-year","sex","url","photo","one-time-code"],qualifiers:["home","work","mobile","fax","pager"],qualifiedTerms:["tel","tel-country-code","tel-national","tel-area-code","tel-local","tel-local-prefix","tel-local-suffix","tel-extension","email","impp"],locations:["billing","shipping"]};var qi=function(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},r=t.looseTyped,a=void 0!==r&&r,n=t.stateTerms,o=void 0===n?[]:n,i=t.locations,l=void 0===i?[]:i,u=t.qualifiers,s=void 0===u?[]:u,c=t.standaloneTerms,d=void 0===c?[]:c,p=t.qualifiedTerms,f=void 0===p?[]:p;if(e=e.toLowerCase().trim(),(o=o.concat(Li.stateTerms)).includes(e)||""===e)return!0;s=s.concat(Li.qualifiers),l=l.concat(Li.locations),d=d.concat(Li.standaloneTerms),f=f.concat(Li.qualifiedTerms);var m=e.split(/\\s+/g);if(!a&&(8<m[0].length&&"section-"===m[0].substr(0,8)&&m.shift(),l.includes(m[0])&&m.shift(),s.includes(m[0])&&(m.shift(),d=[]),1!==m.length))return!1;var h=m[m.length-1];return d.includes(h)||f.includes(h)};var ji=function(e,t,r){return e=wn(e),wa(e,t,r)};var Mi=function(e){if(r=xa(e))return r;if(e.attr("id")){if(!e.actualNode)throw new TypeError("Cannot resolve explicit label reference for non-DOM nodes");var t,r,a=vt(e.attr("id"));if(r=(t=Gr(e.actualNode).querySelector(\'label[for="\'+a+\'"]\'))&&ji(t,!0))return r}return(r=(t=er(e,"label"))&&wa(t,!0))||null};var Ui=function(e){return e=wn(e),Mi(e)},Vi=[{matches:[{nodeName:"textarea"},{nodeName:"input",properties:{type:["text","password","search","tel","email","url"]}}],namingMethods:"labelText"},{matches:{nodeName:"input",properties:{type:["button","submit","reset"]}},namingMethods:["valueText","titleText","buttonDefaultText"]},{matches:{nodeName:"input",properties:{type:"image"}},namingMethods:["altText","valueText","labelText","titleText","buttonDefaultText"]},{matches:"button",namingMethods:"subtreeText"},{matches:"fieldset",namingMethods:"fieldsetLegendText"},{matches:"OUTPUT",namingMethods:"subtreeText"},{matches:[{nodeName:"select"},{nodeName:"input",properties:{type:/^(?!text|password|search|tel|email|url|button|submit|reset)/}}],namingMethods:"labelText"},{matches:"summary",namingMethods:"subtreeText"},{matches:"figure",namingMethods:["figureText","titleText"]},{matches:"img",namingMethods:"altText"},{matches:"table",namingMethods:["tableCaptionText","tableSummaryText"]},{matches:["hr","br"],namingMethods:["titleText","singleSpace"]}];var Hi=function t(e){var r=ia(e.actualNode),a=[];return e.children.forEach(function(e){3===e.actualNode.nodeType?r&&a.push(e):a=a.concat(t(e))}),a},zi=/^idrefs?$/;var $i=function(e){e=e.actualNode||e;var t=(t=Gr(e)).documentElement||t,r=xr.get("idRefsByRoot");r||(r=new WeakMap,xr.set("idRefsByRoot",r));var a=r.get(t);return a||(a={},r.set(t,a),function e(t,r,a){if(t.hasAttribute){var n;"LABEL"===t.nodeName.toUpperCase()&&t.hasAttribute("for")&&(r[n=t.getAttribute("for")]=r[n]||[],r[n].push(t));for(var o=0;o<a.length;++o){var i=a[o],l=ga(t.getAttribute(i)||"");if(l)for(var u=so(l),s=0;s<u.length;++s)r[u[s]]=r[u[s]]||[],r[u[s]].push(t)}}for(var c=0;c<t.children.length;c++)e(t.children[c],r,a)}(t,a,Object.keys(Ga.ariaAttrs).filter(function(e){var t=Ga.ariaAttrs[e].type;return zi.test(t)}))),a[e.id]||[]};var Wi=function(e){var t=Ga.ariaRoles[e];return t?t.type:null};var Gi=function(e,t){var r=e instanceof tt?e:wn(e);if(t===Oo(r))return!0;var a=Xo(r);return Array.isArray(a.allowedRoles)?a.allowedRoles.includes(t):!!a.allowedRoles},Yi=["doc-backlink","doc-biblioentry","doc-biblioref","doc-cover","doc-endnote","doc-glossref","doc-noteref"];var Ki=function(r){var a=!(1<arguments.length&&void 0!==arguments[1])||arguments[1],n=r.nodeName.toUpperCase();if(!Tn(r))return[];var e,t,o,i,l=(i=[],(e=r)?(e.hasAttribute("role")&&(t=so(e.getAttribute("role").toLowerCase()),i=i.concat(t)),e.hasAttributeNS("http://www.idpf.org/2007/ops","type")&&(o=so(e.getAttributeNS("http://www.idpf.org/2007/ops","type").toLowerCase()).map(function(e){return"doc-".concat(e)}),i=i.concat(o)),i=i.filter(function(e){return wo(e)})):i),u=Oo(r);return l.filter(function(e){if(a&&e===u)return!1;if(a&&Yi.includes(e)){var t=Wi(e);if(u!==t)return!0}return!(a||"row"===e&&"TR"===n&&Et(r,\'table[role="grid"] > tr\'))||!Gi(r,e)})};var Xi=function(t){return Object.keys(Ga.ariaRoles).filter(function(e){return Ga.ariaRoles[e].type===t})};var Ji=function(e){return Xi(e)};var Qi=function(){if(xr.get("ariaRolesNameFromContent"))return xr.get("ariaRolesNameFromContent");var e=Object.keys(Ga.ariaRoles).filter(function(e){return Ga.ariaRoles[e].nameFromContent});return xr.set("ariaRolesNameFromContent",e),e};function Zi(e){return null===e}function el(e){return null!==e}var tl=function(){return Qi()},rl={attributes:{"aria-activedescendant":{type:"idref",allowEmpty:!0,unsupported:!1},"aria-atomic":{type:"boolean",values:["true","false"],unsupported:!1},"aria-autocomplete":{type:"nmtoken",values:["inline","list","both","none"],unsupported:!1},"aria-busy":{type:"boolean",values:["true","false"],unsupported:!1},"aria-checked":{type:"nmtoken",values:["true","false","mixed","undefined"],unsupported:!1},"aria-colcount":{type:"int",unsupported:!1},"aria-colindex":{type:"int",unsupported:!1},"aria-colspan":{type:"int",unsupported:!1},"aria-controls":{type:"idrefs",allowEmpty:!0,unsupported:!1},"aria-current":{type:"nmtoken",allowEmpty:!0,values:["page","step","location","date","time","true","false"],unsupported:!1},"aria-describedby":{type:"idrefs",allowEmpty:!0,unsupported:!1},"aria-describedat":{unsupported:!0,unstandardized:!0},"aria-details":{type:"idref",allowEmpty:!0,unsupported:!1},"aria-disabled":{type:"boolean",values:["true","false"],unsupported:!1},"aria-dropeffect":{type:"nmtokens",values:["copy","move","reference","execute","popup","none"],unsupported:!1},"aria-errormessage":{type:"idref",allowEmpty:!0,unsupported:!1},"aria-expanded":{type:"nmtoken",values:["true","false","undefined"],unsupported:!1},"aria-flowto":{type:"idrefs",allowEmpty:!0,unsupported:!1},"aria-grabbed":{type:"nmtoken",values:["true","false","undefined"],unsupported:!1},"aria-haspopup":{type:"nmtoken",allowEmpty:!0,values:["true","false","menu","listbox","tree","grid","dialog"],unsupported:!1},"aria-hidden":{type:"boolean",values:["true","false"],unsupported:!1},"aria-invalid":{type:"nmtoken",allowEmpty:!0,values:["true","false","spelling","grammar"],unsupported:!1},"aria-keyshortcuts":{type:"string",allowEmpty:!0,unsupported:!1},"aria-label":{type:"string",allowEmpty:!0,unsupported:!1},"aria-labelledby":{type:"idrefs",allowEmpty:!0,unsupported:!1},"aria-level":{type:"int",unsupported:!1},"aria-live":{type:"nmtoken",values:["off","polite","assertive"],unsupported:!1},"aria-modal":{type:"boolean",values:["true","false"],unsupported:!1},"aria-multiline":{type:"boolean",values:["true","false"],unsupported:!1},"aria-multiselectable":{type:"boolean",values:["true","false"],unsupported:!1},"aria-orientation":{type:"nmtoken",values:["horizontal","vertical"],unsupported:!1},"aria-owns":{type:"idrefs",allowEmpty:!0,unsupported:!1},"aria-placeholder":{type:"string",allowEmpty:!0,unsupported:!1},"aria-posinset":{type:"int",unsupported:!1},"aria-pressed":{type:"nmtoken",values:["true","false","mixed","undefined"],unsupported:!1},"aria-readonly":{type:"boolean",values:["true","false"],unsupported:!1},"aria-relevant":{type:"nmtokens",values:["additions","removals","text","all"],unsupported:!1},"aria-required":{type:"boolean",values:["true","false"],unsupported:!1},"aria-roledescription":{type:"string",allowEmpty:!0,unsupported:!1},"aria-rowcount":{type:"int",unsupported:!1},"aria-rowindex":{type:"int",unsupported:!1},"aria-rowspan":{type:"int",unsupported:!1},"aria-selected":{type:"nmtoken",values:["true","false","undefined"],unsupported:!1},"aria-setsize":{type:"int",unsupported:!1},"aria-sort":{type:"nmtoken",values:["ascending","descending","other","none"],unsupported:!1},"aria-valuemax":{type:"decimal",unsupported:!1},"aria-valuemin":{type:"decimal",unsupported:!1},"aria-valuenow":{type:"decimal",unsupported:!1},"aria-valuetext":{type:"string",unsupported:!1}},globalAttributes:["aria-atomic","aria-busy","aria-controls","aria-current","aria-describedby","aria-details","aria-disabled","aria-dropeffect","aria-flowto","aria-grabbed","aria-haspopup","aria-hidden","aria-invalid","aria-keyshortcuts","aria-label","aria-labelledby","aria-live","aria-owns","aria-relevant","aria-roledescription"]};rl.role={alert:{type:"widget",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},alertdialog:{type:"widget",attributes:{allowed:["aria-expanded","aria-modal","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,unsupported:!1,allowedElements:["dialog","section"]},application:{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage","aria-activedescendant"]},owned:null,nameFrom:["author"],context:null,unsupported:!1,allowedElements:["article","audio","embed","iframe","object","section","svg","video"]},article:{type:"structure",attributes:{allowed:["aria-expanded","aria-posinset","aria-setsize","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["article"],unsupported:!1},banner:{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["header"],unsupported:!1,allowedElements:["section"]},button:{type:"widget",attributes:{allowed:["aria-expanded","aria-pressed","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:null,implicit:["button",\'input[type="button"]\',\'input[type="image"]\',\'input[type="reset"]\',\'input[type="submit"]\',"summary"],unsupported:!1,allowedElements:[{nodeName:"a",attributes:{href:el}}]},cell:{type:"structure",attributes:{allowed:["aria-colindex","aria-colspan","aria-rowindex","aria-rowspan","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:["row"],implicit:["td","th"],unsupported:!1},checkbox:{type:"widget",attributes:{allowed:["aria-checked","aria-required","aria-readonly","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:null,implicit:[\'input[type="checkbox"]\'],unsupported:!1,allowedElements:["button"]},columnheader:{type:"structure",attributes:{allowed:["aria-colindex","aria-colspan","aria-expanded","aria-rowindex","aria-rowspan","aria-required","aria-readonly","aria-selected","aria-sort","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:["row"],implicit:["th"],unsupported:!1},combobox:{type:"composite",attributes:{allowed:["aria-autocomplete","aria-required","aria-activedescendant","aria-orientation","aria-errormessage"],required:["aria-expanded"]},owned:{all:["listbox","tree","grid","dialog","textbox"]},nameFrom:["author"],context:null,unsupported:!1,allowedElements:[{nodeName:"input",properties:{type:["text","search","tel","url","email"]}}]},command:{nameFrom:["author"],type:"abstract",unsupported:!1},complementary:{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["aside"],unsupported:!1,allowedElements:["section"]},composite:{nameFrom:["author"],type:"abstract",unsupported:!1},contentinfo:{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["footer"],unsupported:!1,allowedElements:["section"]},definition:{type:"structure",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["dd","dfn"],unsupported:!1},dialog:{type:"widget",attributes:{allowed:["aria-expanded","aria-modal","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["dialog"],unsupported:!1,allowedElements:["section"]},directory:{type:"structure",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:null,unsupported:!1,allowedElements:["ol","ul"]},document:{type:"structure",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["body"],unsupported:!1,allowedElements:["article","embed","iframe","object","section","svg"]},"doc-abstract":{type:"section",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-acknowledgments":{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-afterword":{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-appendix":{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-backlink":{type:"link",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:null,unsupported:!1,allowedElements:[{nodeName:"a",attributes:{href:el}}]},"doc-biblioentry":{type:"listitem",attributes:{allowed:["aria-expanded","aria-level","aria-posinset","aria-setsize","aria-errormessage"]},owned:null,nameFrom:["author"],context:["doc-bibliography"],unsupported:!1,allowedElements:["li"]},"doc-bibliography":{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:{one:["doc-biblioentry"]},nameFrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-biblioref":{type:"link",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:null,unsupported:!1,allowedElements:[{nodeName:"a",attributes:{href:el}}]},"doc-chapter":{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-colophon":{type:"section",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-conclusion":{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-cover":{type:"img",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1},"doc-credit":{type:"section",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-credits":{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-dedication":{type:"section",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-endnote":{type:"listitem",attributes:{allowed:["aria-expanded","aria-level","aria-posinset","aria-setsize","aria-errormessage"]},owned:null,namefrom:["author"],context:["doc-endnotes"],unsupported:!1,allowedElements:["li"]},"doc-endnotes":{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:{one:["doc-endnote"]},namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-epigraph":{type:"section",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1},"doc-epilogue":{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-errata":{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-example":{type:"section",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["aside","section"]},"doc-footnote":{type:"section",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["aside","footer","header"]},"doc-foreword":{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-glossary":{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:["term","definition"],namefrom:["author"],context:null,unsupported:!1,allowedElements:["dl"]},"doc-glossref":{type:"link",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author","contents"],context:null,unsupported:!1,allowedElements:[{nodeName:"a",attributes:{href:el}}]},"doc-index":{type:"navigation",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["nav","section"]},"doc-introduction":{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-noteref":{type:"link",attributes:{allowed:["aria-expanded"]},owned:null,namefrom:["author","contents"],context:null,unsupported:!1,allowedElements:[{nodeName:"a",attributes:{href:el}}]},"doc-notice":{type:"note",attributes:{allowed:["aria-expanded"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-pagebreak":{type:"separator",attributes:{allowed:["aria-expanded"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["hr"]},"doc-pagelist":{type:"navigation",attributes:{allowed:["aria-expanded"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["nav","section"]},"doc-part":{type:"landmark",attributes:{allowed:["aria-expanded"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-preface":{type:"landmark",attributes:{allowed:["aria-expanded"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-prologue":{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-pullquote":{type:"none",attributes:{allowed:["aria-expanded"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["aside","section"]},"doc-qna":{type:"section",attributes:{allowed:["aria-expanded"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-subtitle":{type:"sectionhead",attributes:{allowed:["aria-expanded"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:{nodeName:["h1","h2","h3","h4","h5","h6"]}},"doc-tip":{type:"note",attributes:{allowed:["aria-expanded"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["aside"]},"doc-toc":{type:"navigation",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["nav","section"]},feed:{type:"structure",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:{one:["article"]},nameFrom:["author"],context:null,unsupported:!1,allowedElements:["article","aside","section"]},figure:{type:"structure",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:null,implicit:["figure"],unsupported:!1},form:{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["form"],unsupported:!1},grid:{type:"composite",attributes:{allowed:["aria-activedescendant","aria-expanded","aria-colcount","aria-level","aria-multiselectable","aria-readonly","aria-rowcount","aria-errormessage"]},owned:{one:["rowgroup","row"]},nameFrom:["author"],context:null,implicit:["table"],unsupported:!1},gridcell:{type:"widget",attributes:{allowed:["aria-colindex","aria-colspan","aria-expanded","aria-rowindex","aria-rowspan","aria-selected","aria-readonly","aria-required","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:["row"],implicit:["td","th"],unsupported:!1},group:{type:"structure",attributes:{allowed:["aria-activedescendant","aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["details","optgroup"],unsupported:!1,allowedElements:["dl","figcaption","fieldset","figure","footer","header","ol","ul"]},heading:{type:"structure",attributes:{required:["aria-level"],allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:null,implicit:["h1","h2","h3","h4","h5","h6"],unsupported:!1},img:{type:"structure",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["img"],unsupported:!1,allowedElements:["embed","iframe","object","svg"]},input:{nameFrom:["author"],type:"abstract",unsupported:!1},landmark:{nameFrom:["author"],type:"abstract",unsupported:!1},link:{type:"widget",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:null,implicit:["a[href]","area[href]"],unsupported:!1,allowedElements:["button",{nodeName:"input",properties:{type:["image","button"]}}]},list:{type:"structure",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:{all:["listitem"]},nameFrom:["author"],context:null,implicit:["ol","ul","dl"],unsupported:!1},listbox:{type:"composite",attributes:{allowed:["aria-activedescendant","aria-multiselectable","aria-readonly","aria-required","aria-expanded","aria-orientation","aria-errormessage"]},owned:{all:["option"]},nameFrom:["author"],context:null,implicit:["select"],unsupported:!1,allowedElements:["ol","ul"]},listitem:{type:"structure",attributes:{allowed:["aria-level","aria-posinset","aria-setsize","aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:["list"],implicit:["li","dt"],unsupported:!1},log:{type:"widget",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},main:{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["main"],unsupported:!1,allowedElements:["article","section"]},marquee:{type:"widget",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},math:{type:"structure",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["math"],unsupported:!1},menu:{type:"composite",attributes:{allowed:["aria-activedescendant","aria-expanded","aria-orientation","aria-errormessage"]},owned:{one:["menuitem","menuitemradio","menuitemcheckbox"]},nameFrom:["author"],context:null,implicit:[\'menu[type="context"]\'],unsupported:!1,allowedElements:["ol","ul"]},menubar:{type:"composite",attributes:{allowed:["aria-activedescendant","aria-expanded","aria-orientation","aria-errormessage"]},owned:{one:["menuitem","menuitemradio","menuitemcheckbox"]},nameFrom:["author"],context:null,unsupported:!1,allowedElements:["ol","ul"]},menuitem:{type:"widget",attributes:{allowed:["aria-posinset","aria-setsize","aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:["menu","menubar"],implicit:[\'menuitem[type="command"]\'],unsupported:!1,allowedElements:["button","li",{nodeName:"iput",properties:{type:["image","button"]}},{nodeName:"a",attributes:{href:el}}]},menuitemcheckbox:{type:"widget",attributes:{allowed:["aria-checked","aria-posinset","aria-setsize","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:["menu","menubar"],implicit:[\'menuitem[type="checkbox"]\'],unsupported:!1,allowedElements:[{nodeName:["button","li"]},{nodeName:"input",properties:{type:["checkbox","image","button"]}},{nodeName:"a",attributes:{href:el}}]},menuitemradio:{type:"widget",attributes:{allowed:["aria-checked","aria-selected","aria-posinset","aria-setsize","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:["menu","menubar"],implicit:[\'menuitem[type="radio"]\'],unsupported:!1,allowedElements:[{nodeName:["button","li"]},{nodeName:"input",properties:{type:["image","button","radio"]}},{nodeName:"a",attributes:{href:el}}]},navigation:{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["nav"],unsupported:!1,allowedElements:["section"]},none:{type:"structure",attributes:null,owned:null,nameFrom:["author"],context:null,unsupported:!1,allowedElements:[{nodeName:["article","aside","dl","embed","figcaption","fieldset","figure","footer","form","h1","h2","h3","h4","h5","h6","header","hr","iframe","li","ol","section","ul"]},{nodeName:"img",attributes:{alt:el}}]},note:{type:"structure",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,unsupported:!1,allowedElements:["aside"]},option:{type:"widget",attributes:{allowed:["aria-selected","aria-posinset","aria-setsize","aria-checked","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:["listbox"],implicit:["option"],unsupported:!1,allowedElements:[{nodeName:["button","li"]},{nodeName:"input",properties:{type:["checkbox","button"]}},{nodeName:"a",attributes:{href:el}}]},presentation:{type:"structure",attributes:null,owned:null,nameFrom:["author"],context:null,unsupported:!1,allowedElements:[{nodeName:["article","aside","dl","embed","figcaption","fieldset","figure","footer","form","h1","h2","h3","h4","h5","h6","header","hr","iframe","li","ol","section","ul"]},{nodeName:"img",attributes:{alt:el}}]},progressbar:{type:"widget",attributes:{allowed:["aria-valuetext","aria-valuenow","aria-valuemax","aria-valuemin","aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["progress"],unsupported:!1},radio:{type:"widget",attributes:{allowed:["aria-selected","aria-posinset","aria-setsize","aria-required","aria-errormessage","aria-checked"]},owned:null,nameFrom:["author","contents"],context:null,implicit:[\'input[type="radio"]\'],unsupported:!1,allowedElements:[{nodeName:["button","li"]},{nodeName:"input",properties:{type:["image","button"]}}]},radiogroup:{type:"composite",attributes:{allowed:["aria-activedescendant","aria-required","aria-expanded","aria-readonly","aria-errormessage","aria-orientation"]},owned:{all:["radio"]},nameFrom:["author"],context:null,unsupported:!1,allowedElements:{nodeName:["ol","ul","fieldset"]}},range:{nameFrom:["author"],type:"abstract",unsupported:!1},region:{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["section[aria-label]","section[aria-labelledby]","section[title]"],unsupported:!1,allowedElements:{nodeName:["article","aside"]}},roletype:{type:"abstract",unsupported:!1},row:{type:"structure",attributes:{allowed:["aria-activedescendant","aria-colindex","aria-expanded","aria-level","aria-selected","aria-rowindex","aria-errormessage"]},owned:{one:["cell","columnheader","rowheader","gridcell"]},nameFrom:["author","contents"],context:["rowgroup","grid","treegrid","table"],implicit:["tr"],unsupported:!1},rowgroup:{type:"structure",attributes:{allowed:["aria-activedescendant","aria-expanded","aria-errormessage"]},owned:{all:["row"]},nameFrom:["author","contents"],context:["grid","table","treegrid"],implicit:["tbody","thead","tfoot"],unsupported:!1},rowheader:{type:"structure",attributes:{allowed:["aria-colindex","aria-colspan","aria-expanded","aria-rowindex","aria-rowspan","aria-required","aria-readonly","aria-selected","aria-sort","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:["row"],implicit:["th"],unsupported:!1},scrollbar:{type:"widget",attributes:{required:["aria-controls","aria-valuenow"],allowed:["aria-valuetext","aria-orientation","aria-errormessage","aria-valuemax","aria-valuemin"]},owned:null,nameFrom:["author"],context:null,unsupported:!1},search:{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,unsupported:!1,allowedElements:{nodeName:["aside","form","section"]}},searchbox:{type:"widget",attributes:{allowed:["aria-activedescendant","aria-autocomplete","aria-multiline","aria-readonly","aria-required","aria-placeholder","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:[\'input[type="search"]\'],unsupported:!1,allowedElements:{nodeName:"input",properties:{type:"text"}}},section:{nameFrom:["author","contents"],type:"abstract",unsupported:!1},sectionhead:{nameFrom:["author","contents"],type:"abstract",unsupported:!1},select:{nameFrom:["author"],type:"abstract",unsupported:!1},separator:{type:"structure",attributes:{allowed:["aria-expanded","aria-orientation","aria-valuenow","aria-valuemax","aria-valuemin","aria-valuetext","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["hr"],unsupported:!1,allowedElements:["li"]},slider:{type:"widget",attributes:{allowed:["aria-valuetext","aria-orientation","aria-readonly","aria-errormessage","aria-valuemax","aria-valuemin"],required:["aria-valuenow"]},owned:null,nameFrom:["author"],context:null,implicit:[\'input[type="range"]\'],unsupported:!1},spinbutton:{type:"widget",attributes:{allowed:["aria-valuetext","aria-required","aria-readonly","aria-errormessage","aria-valuemax","aria-valuemin"],required:["aria-valuenow"]},owned:null,nameFrom:["author"],context:null,implicit:[\'input[type="number"]\'],unsupported:!1,allowedElements:{nodeName:"input",properties:{type:["text","tel"]}}},status:{type:"widget",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["output"],unsupported:!1,allowedElements:["section"]},structure:{type:"abstract",unsupported:!1},switch:{type:"widget",attributes:{allowed:["aria-errormessage"],required:["aria-checked"]},owned:null,nameFrom:["author","contents"],context:null,unsupported:!1,allowedElements:["button",{nodeName:"input",properties:{type:["checkbox","image","button"]}},{nodeName:"a",attributes:{href:el}}]},tab:{type:"widget",attributes:{allowed:["aria-selected","aria-expanded","aria-setsize","aria-posinset","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:["tablist"],unsupported:!1,allowedElements:[{nodeName:["button","h1","h2","h3","h4","h5","h6","li"]},{nodeName:"input",properties:{type:"button"}},{nodeName:"a",attributes:{href:el}}]},table:{type:"structure",attributes:{allowed:["aria-colcount","aria-rowcount","aria-errormessage"]},owned:{one:["rowgroup","row"]},nameFrom:["author","contents"],context:null,implicit:["table"],unsupported:!1},tablist:{type:"composite",attributes:{allowed:["aria-activedescendant","aria-expanded","aria-level","aria-multiselectable","aria-orientation","aria-errormessage"]},owned:{all:["tab"]},nameFrom:["author"],context:null,unsupported:!1,allowedElements:["ol","ul"]},tabpanel:{type:"widget",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},term:{type:"structure",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:null,implicit:["dt"],unsupported:!1},textbox:{type:"widget",attributes:{allowed:["aria-activedescendant","aria-autocomplete","aria-multiline","aria-readonly","aria-required","aria-placeholder","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:[\'input[type="text"]\',\'input[type="email"]\',\'input[type="password"]\',\'input[type="tel"]\',\'input[type="url"]\',"input:not([type])","textarea"],unsupported:!1},timer:{type:"widget",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,unsupported:!1},toolbar:{type:"structure",attributes:{allowed:["aria-activedescendant","aria-expanded","aria-orientation","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:[\'menu[type="toolbar"]\'],unsupported:!1,allowedElements:["ol","ul"]},tooltip:{type:"structure",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:null,unsupported:!1},tree:{type:"composite",attributes:{allowed:["aria-activedescendant","aria-multiselectable","aria-required","aria-expanded","aria-orientation","aria-errormessage"]},owned:{all:["treeitem"]},nameFrom:["author"],context:null,unsupported:!1,allowedElements:["ol","ul"]},treegrid:{type:"composite",attributes:{allowed:["aria-activedescendant","aria-colcount","aria-expanded","aria-level","aria-multiselectable","aria-readonly","aria-required","aria-rowcount","aria-orientation","aria-errormessage"]},owned:{one:["rowgroup","row"]},nameFrom:["author"],context:null,unsupported:!1},treeitem:{type:"widget",attributes:{allowed:["aria-checked","aria-selected","aria-expanded","aria-level","aria-posinset","aria-setsize","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:["group","tree"],unsupported:!1,allowedElements:["li",{nodeName:"a",attributes:{href:el}}]},widget:{type:"abstract",unsupported:!1},window:{nameFrom:["author"],type:"abstract",unsupported:!1}},rl.implicitHtmlRole=_o,rl.elementsAllowedNoRole=[{nodeName:["base","body","caption","col","colgroup","datalist","dd","details","dt","head","html","keygen","label","legend","main","map","math","meta","meter","noscript","optgroup","param","picture","progress","script","source","style","template","textarea","title","track"]},{nodeName:"area",attributes:{href:el}},{nodeName:"input",properties:{type:["color","data","datatime","file","hidden","month","number","password","range","reset","submit","time","week"]}},{nodeName:"link",attributes:{href:el}},{nodeName:"menu",attributes:{type:"context"}},{nodeName:"menuitem",attributes:{type:["command","checkbox","radio"]}},{nodeName:"select",condition:function(e){return e instanceof axe.AbstractVirtualNode||(e=axe.utils.getNodeFromTree(e)),1<Number(e.attr("size"))},properties:{multiple:!0}},{nodeName:["clippath","cursor","defs","desc","feblend","fecolormatrix","fecomponenttransfer","fecomposite","feconvolvematrix","fediffuselighting","fedisplacementmap","fedistantlight","fedropshadow","feflood","fefunca","fefuncb","fefuncg","fefuncr","fegaussianblur","feimage","femerge","femergenode","femorphology","feoffset","fepointlight","fespecularlighting","fespotlight","fetile","feturbulence","filter","hatch","hatchpath","lineargradient","marker","mask","meshgradient","meshpatch","meshrow","metadata","mpath","pattern","radialgradient","solidcolor","stop","switch","view"]}],rl.elementsAllowedAnyRole=[{nodeName:"a",attributes:{href:Zi}},{nodeName:"img",attributes:{alt:Zi}},{nodeName:["abbr","address","canvas","div","p","pre","blockquote","ins","del","output","span","table","tbody","thead","tfoot","td","em","strong","small","s","cite","q","dfn","abbr","time","code","var","samp","kbd","sub","sup","i","b","u","mark","ruby","rt","rp","bdi","bdo","br","wbr","th","tr"]}],rl.evaluateRoleForElement={A:function(e){var t=e.node,r=e.out;return"http://www.w3.org/2000/svg"===t.namespaceURI||(!t.href.length||r)},AREA:function(e){return!e.node.href},BUTTON:function(e){var t=e.node,r=e.role,a=e.out;return"menu"===t.getAttribute("type")?"menuitem"===r:a},IMG:function(e){var t=e.node,r=e.role,a=e.out;switch(t.alt){case null:return a;case"":return"presentation"===r||"none"===r;default:return"presentation"!==r&&"none"!==r}},INPUT:function(e){var t=e.node,r=e.role,a=e.out;switch(t.type){case"button":case"image":return a;case"checkbox":return"button"===r&&t.hasAttribute("aria-pressed")?!0:a;case"radio":return"menuitemradio"===r;case"text":return"combobox"===r||"searchbox"===r||"spinbutton"===r;case"tel":return"combobox"===r||"spinbutton"===r;case"url":case"search":case"email":return"combobox"===r;default:return!1}},LI:function(e){var t=e.node,r=e.out;return!axe.utils.matchesSelector(t,"ol li, ul li")||r},MENU:function(e){return"context"!==e.node.getAttribute("type")},OPTION:function(e){var t=e.node;return!axe.utils.matchesSelector(t,"select > option, datalist > option, optgroup > option")},SELECT:function(e){var t=e.node,r=e.role;return!t.multiple&&t.size<=1&&"menu"===r},SVG:function(e){var t=e.node,r=e.out;return!(!t.parentNode||"http://www.w3.org/2000/svg"!==t.parentNode.namespaceURI)||r}},rl.rolesOfType={widget:["button","checkbox","dialog","gridcell","link","log","marquee","menuitem","menuitemcheckbox","menuitemradio","option","progressbar","radio","scrollbar","searchbox","slider","spinbutton","status","switch","tab","tabpanel","textbox","timer","tooltip","tree","treeitem"]};var al=rl;var nl=function(e){var t=null,r=al.role[e];return r&&r.implicit&&(t=Ht(r.implicit)),t};var ol=function(e){return!!$i(e).length};var il=function(e){return e=wn(e),xa(e)};var ll=function(e){var t=Ga.ariaRoles[e];return t&&Array.isArray(t.requiredAttrs)?Zs(t.requiredAttrs):[]};var ul=function(e){var t=Ga.ariaRoles[e];return t&&Array.isArray(t.requiredContext)?Zs(t.requiredContext):null};var sl=function(e){var t=Ga.ariaRoles[e];return t&&Array.isArray(t.requiredOwned)?Zs(t.requiredOwned):null};var cl=function(e,t){var r,a,n=e.getAttribute(t),o=Ga.ariaAttrs[t],i=Gr(e);if(!o)return!0;if(o.allowEmpty&&(!n||""===n.trim()))return!0;switch(o.type){case"boolean":return["true","false"].includes(n.toLowerCase());case"nmtoken":return"string"==typeof n&&o.values.includes(n.toLowerCase());case"nmtokens":return(a=so(n)).reduce(function(e,t){return e&&o.values.includes(t)},0!==a.length);case"idref":return!(!n||!i.getElementById(n));case"idrefs":return(a=so(n)).some(function(e){return i.getElementById(e)});case"string":return""!==n.trim();case"decimal":return!(!(r=n.match(/^[-+]?([0-9]*)\\.?([0-9]*)$/))||!r[1]&&!r[2]);case"int":return/^[-+]?[0-9]+$/.test(n)}};var dl=function(e){return!!Ga.ariaAttrs[e]};function pl(e,t,r){var a=so(r.attr("role")).filter(function(e){return"abstract"===Wi(e)});return 0<a.length&&(this.data(a),!0)}function fl(e,t){var r=[],a=Bo(e),n=xt(e),o=bo(a);if(Array.isArray(t[a])&&(o=Wn(t[a].concat(o))),a&&o)for(var i=0;i<n.length;i++){var l=n[i],u=l.name;dl(u)&&!o.includes(u)&&r.push(u+\'="\'+l.nodeValue+\'"\')}return!r.length||(this.data(r),!1)}function ml(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},r=t.allowImplicit,a=void 0===r||r,n=t.ignoredTags,o=void 0===n?[]:n,i=e.nodeName.toUpperCase();if(o.map(function(e){return e.toUpperCase()}).includes(i))return!0;var l=Ki(e,a);if(l.length){if(this.data(l),!ia(e,!0))return;return!1}return!0}function hl(r,e){e=Array.isArray(e)?e:[];var t=r.getAttribute("aria-errormessage"),a=r.hasAttribute("aria-errormessage"),n=Gr(r);return-1!==e.indexOf(t)||!a||(this.data(so(t)),function(e){if(""===e.trim())return Ga.ariaAttrs["aria-errormessage"].allowEmpty;var t=e&&n.getElementById(e);return t?"alert"===t.getAttribute("role")||"assertive"===t.getAttribute("aria-live")||"polite"===t.getAttribute("aria-live")||-1<so(r.getAttribute("aria-describedby")).indexOf(e):void 0}(t))}function gl(e,t,r){return"true"!==r.attr("aria-hidden")}var vl={};t(vl,{getAriaRolesByType:function(){return Xi},getAriaRolesSupportingNameFromContent:function(){return Qi},getElementSpec:function(){return Xo},getElementsByContentType:function(){return Eo},getGlobalAriaAttrs:function(){return vo},implicitHtmlRoles:function(){return _o}});function bl(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},r=wn(e),a=[];if(e.hasAttributes()){var n=e.getAttribute("role"),o=ll(n),i=Xo(r);if(Array.isArray(t[n])&&(o=Wn(t[n],o)),n&&o)for(var l=0,u=o.length;l<u;l++){var s=o[l];e.getAttribute(s)||i.implicitAttrs&&void 0!==i.implicitAttrs[s]||a.push(s)}}return!a.length||(this.data(a),!1)}function yl(e,t,r){var a=t&&Array.isArray(t.reviewEmpty)?t.reviewEmpty:[],n=xo(r,{dpub:!0}),o=sl(n);if(!o)return!0;var i=function(e){for(var t=[],r=ei(e),a=0;a<r.length;a++){var n=r[a],o=Bo(n);["presentation","none",null].includes(o)?r.push.apply(r,Zs(n.children)):o&&t.push(o)}return t}(r),l=function(e,t,r,a){var n,o,i,l,u="combobox"===t;u&&(("input"===e.props.nodeName&&["text","search","email","url","tel"].includes(e.props.type)||a.includes("searchbox"))&&(r=r.filter(function(e){return"textbox"!==e})),n=["listbox","tree","grid","dialog"],o=e.attr("aria-expanded"),i=o&&"false"!==o.toLowerCase(),l=(e.attr("aria-haspopup")||"listbox").toLowerCase(),r=r.filter(function(e){return!n.includes(e)||i&&e===l}));for(var s=0;s<a.length;s++){var c=a[s];if(r.includes(c)&&(r=r.filter(function(e){return e!==c}),!u))return null}return r.length?r:null}(r,n,o,i);return!l||(this.data(l),!(!a.includes(n)||Aa(r,!1,!0)||i.length||r.hasAttr("aria-owns")&&Da(e,"aria-owns").length)&&void 0)}function Dl(e,t,r){var a=xo(e);if(!(t=t||ul(a)))return null;for(var n=r?e:e.parent;n;){var o=Bo(n);if(t.includes(o))return null;if(o&&!["presentation","none"].includes(o))return t;n=n.parent}return t}function wl(e,t,r){var a=Dl(r);if(!a)return!0;var n=function(e){for(var t,r=[],a=null;e;){e.getAttribute("id")&&(t=vt(e.getAttribute("id")),(a=Gr(e).querySelector("[aria-owns~=".concat(t,"]")))&&r.push(a)),e=e.parentElement}return r.length?r:null}(e);if(n)for(var o=0,i=n.length;o<i;o++)if(!(a=Dl(wn(n[o]),a,!0)))return!0;return this.data(a),!1}function xl(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},r=Bo(e);return!!(t.supportedRoles||[]).includes(r)||!(!r||"presentation"===r||"none"===r)&&void 0}function El(n){var e=Array.from(xt(n)).filter(function(e){var t=e.name,r=Ga.ariaAttrs[t];if(!dl(t))return!1;var a=r.unsupported;return"object"!==Gs(a)?!!a:!Ko(n,a.exceptions)}).map(function(e){return e.name.toString()});return!!e.length&&(this.data(e),!0)}function Al(e,t){t=Array.isArray(t.value)?t.value:[];for(var r,a=[],n=/^aria-/,o=xt(e),i=0,l=o.length;i<l;i++)r=o[i].name,-1===t.indexOf(r)&&n.test(r)&&!dl(r)&&a.push(r);return!a.length||(this.data(a),!1)}function Cl(e,t){t=Array.isArray(t.value)?t.value:[];for(var r="",a="",n=[],o=/^aria-/,i=xt(e),l=["aria-errormessage"],u={"aria-controls":function(){return"false"!==e.getAttribute("aria-expanded")&&"false"!==e.getAttribute("aria-selected")},"aria-current":function(){cl(e,"aria-current")||(r=\'aria-current="\'.concat(e.getAttribute("aria-current"),\'"\'),a="ariaCurrent")},"aria-owns":function(){return"false"!==e.getAttribute("aria-expanded")},"aria-describedby":function(){cl(e,"aria-describedby")||(r=\'aria-describedby="\'.concat(e.getAttribute("aria-describedby"),\'"\'),a="noId")}},s=0,c=i.length;s<c;s++){var d=i[s],p=d.name;l.includes(p)||-1!==t.indexOf(p)||!o.test(p)||u[p]&&!u[p]()||cl(e,p)||n.push("".concat(p,\'="\').concat(d.nodeValue,\'"\'))}if(!r)return!n.length||(this.data(n),!1);this.data({messageKey:a,needsReview:r})}function Fl(e,t,r){return 1<so(r.attr("role")).length}function kl(e,t,r){var a=vo().filter(function(e){return r.hasAttr(e)});return this.data(a),0<a.length}function Rl(e){var t=e.getAttribute("role");if(null===t)return!1;var r=Wi(t);return"widget"===r||"composite"===r}function Tl(e,t,r){var a=so(r.attr("role"));return!!a.every(function(e){return!wo(e,{allowAbstract:!0})})&&(this.data(a),!0)}function Nl(e,t,r){return _a(r)}function _l(e,t,r){var a=Bo(r,{noImplicit:!0});this.data(a);try{var n=ga(ai(r)).toLowerCase(),o=ga(Ai(r)).toLowerCase();if(!o&&!n)return!1;if(!o&&n)return;if(!o.includes(n))return;return!1}catch(e){return}}function Ol(e){return Do(Bo(e))}var Sl={ARTICLE:!0,ASIDE:!0,NAV:!0,SECTION:!0},Pl={application:!0,banner:!1,complementary:!0,contentinfo:!0,form:!0,main:!0,navigation:!0,region:!0,search:!1};function Il(e){return(r=e.getAttribute("role"))&&Pl[r.toLowerCase()]||!1||(t=e.nodeName.toUpperCase(),Sl[t]||!1);var t,r}var Bl={};t(Bl,{getAllCells:function(){return Ll},getCellPosition:function(){return Co},getHeaders:function(){return jl},getScope:function(){return Fo},isColumnHeader:function(){return ko},isDataCell:function(){return Ml},isDataTable:function(){return Ul},isHeader:function(){return Vl},isRowHeader:function(){return Ro},toArray:function(){return Ao},toGrid:function(){return Ao},traverse:function(){return Hl}});var Ll=function(e){for(var t,r,a=[],n=0,o=e.rows.length;n<o;n++)for(t=0,r=e.rows[n].cells.length;t<r;t++)a.push(e.rows[n].cells[t]);return a};function ql(e,t,r){for(var a,n="row"===e?"_rowHeaders":"_colHeaders",o="row"===e?Ro:ko,i=r[t.y][t.x],l=i.colSpan-1,u=i.rowSpan-1,s=t.y+u,c=t.x+l,d="row"===e?t.y:0,p="row"===e?0:t.x,f=[],m=s;d<=m&&!a;m--)for(var h=c;p<=h;h--){var g=r[m]?r[m][h]:void 0;if(g){var v=axe.utils.getNodeFromTree(g);if(v[n]){a=v[n];break}f.push(g)}}return a=(a||[]).concat(f.filter(o)),f.forEach(function(e){axe.utils.getNodeFromTree(e)[n]=a}),a}var jl=function(e,t){if(e.getAttribute("headers")){var r=Da(e,"headers");if(r.filter(function(e){return e}).length)return r}t=t||Ao(Xr(e,"table"));var a=Co(e,t),n=ql("row",a,t),o=ql("col",a,t);return[].concat(n,o).reverse()};var Ml=function(e){if(!e.children.length&&!e.textContent.trim())return!1;var t=e.getAttribute("role");return wo(t)?["cell","gridcell"].includes(t):"TD"===e.nodeName.toUpperCase()};var Ul=function(e){var t=(e.getAttribute("role")||"").toLowerCase();if(("presentation"===t||"none"===t)&&!_a(e))return!1;if("true"===e.getAttribute("contenteditable")||Xr(e,\'[contenteditable="true"]\'))return!0;if("grid"===t||"treegrid"===t||"table"===t)return!0;if("landmark"===Wi(t))return!0;if("0"===e.getAttribute("datatable"))return!1;if(e.getAttribute("summary"))return!0;if(e.tHead||e.tFoot||e.caption)return!0;for(var r=0,a=e.children.length;r<a;r++)if("COLGROUP"===e.children[r].nodeName.toUpperCase())return!0;for(var n,o,i=0,l=e.rows.length,u=!1,s=0;s<l;s++)for(var c=0,d=(n=e.rows[s]).cells.length;c<d;c++){if("TH"===(o=n.cells[c]).nodeName.toUpperCase())return!0;if(u||o.offsetWidth===o.clientWidth&&o.offsetHeight===o.clientHeight||(u=!0),o.getAttribute("scope")||o.getAttribute("headers")||o.getAttribute("abbr"))return!0;if(["columnheader","rowheader"].includes((o.getAttribute("role")||"").toLowerCase()))return!0;if(1===o.children.length&&"ABBR"===o.children[0].nodeName.toUpperCase())return!0;i++}if(e.getElementsByTagName("table").length)return!1;if(l<2)return!1;var p,f,m=e.rows[Math.ceil(l/2)];if(1===m.cells.length&&1===m.cells[0].colSpan)return!1;if(5<=m.cells.length)return!0;if(u)return!0;for(s=0;s<l;s++){if(n=e.rows[s],p&&p!==window.getComputedStyle(n).getPropertyValue("background-color"))return!0;if(p=window.getComputedStyle(n).getPropertyValue("background-color"),f&&f!==window.getComputedStyle(n).getPropertyValue("background-image"))return!0;f=window.getComputedStyle(n).getPropertyValue("background-image")}return 20<=l||!(ea(e).width>.95*ta(window).width)&&(!(i<10)&&!e.querySelector("object, embed, iframe, applet"))};var Vl=function(e){if(ko(e)||Ro(e))return!0;if(e.getAttribute("id")){var t=vt(e.getAttribute("id"));return!!document.querySelector(\'[headers~="\'.concat(t,\'"]\'))}return!1};var Hl=function(e,t,r,a){if(Array.isArray(t)&&(a=r,r=t,t={x:0,y:0}),"string"==typeof e)switch(e){case"left":e={x:-1,y:0};break;case"up":e={x:0,y:-1};break;case"right":e={x:1,y:0};break;case"down":e={x:0,y:1}}return function e(t,r,a,n){var o,i=a[r.y]?a[r.y][r.x]:void 0;return i?"function"==typeof n&&!0===(o=n(i,r,a))?[i]:((o=e(t,{x:r.x+t.x,y:r.y+t.y},a,n)).unshift(i),o):[]}(e,{x:t.x+e.x,y:t.y+e.y},r,a)};function zl(e){var t=Ao(e),a=t[0];return t.length<=1||a.length<=1||e.rows.length<=1||a.reduce(function(e,t,r){return e||t!==a[r+1]&&void 0!==a[r+1]},!1)}function $l(e){return!Sa(document)||"TH"===e.nodeName.toUpperCase()}function Wl(e){return!(!e.summary||!e.caption)&&e.summary.toLowerCase()===Ci(e.caption).toLowerCase()}function Gl(e,t){var r=e.getAttribute("scope").toLowerCase();return-1!==t.values.indexOf(r)}function Yl(e){var t=[],r=Ll(e),a=Ao(e);return r.forEach(function(e){Ca(e)&&Ml(e)&&!il(e)&&(jl(e,a).some(function(e){return null!==e&&!!Ca(e)})||t.push(e))}),!t.length||(this.relatedNodes(t),!1)}function Kl(e){for(var t=[],o=[],i=[],r=0;r<e.rows.length;r++)for(var a=e.rows[r],n=0;n<a.cells.length;n++)t.push(a.cells[n]);var l=t.reduce(function(e,t){return t.getAttribute("id")&&e.push(t.getAttribute("id")),e},[]);return t.forEach(function(e){var t,r=!1;if(e.hasAttribute("headers")){var a=e.getAttribute("headers").trim();if(!a)return o.push(e);var n=so(a);0!==n.length&&(e.getAttribute("id")&&(r=-1!==n.indexOf(e.getAttribute("id").trim())),t=n.some(function(e){return!l.includes(e)}),(r||t)&&i.push(e))}}),0<i.length?(this.relatedNodes(i),!1):!o.length||void this.relatedNodes(o)}function Xl(e){var t=Ll(e),a=this,n=[];t.forEach(function(e){var t=e.getAttribute("headers");t&&(n=n.concat(t.split(/\\s+/)));var r=e.getAttribute("aria-labelledby");r&&(n=n.concat(r.split(/\\s+/)))});var r=t.filter(function(e){return""!==ga(e.textContent)&&("TH"===e.nodeName.toUpperCase()||-1!==["rowheader","columnheader"].indexOf(e.getAttribute("role")))}),o=Ao(e),i=!0;return r.forEach(function(t){var e,r;t.getAttribute("id")&&n.includes(t.getAttribute("id"))||(e=Co(t,o),r=!1,ko(t)&&(r=Hl("down",e,o).find(function(e){return!ko(e)&&jl(e,o).includes(t)})),!r&&Ro(t)&&(r=Hl("right",e,o).find(function(e){return!Ro(e)&&jl(e,o).includes(t)})),r||a.relatedNodes(t),i=i&&r)}),!!i||void 0}function Jl(e,t,r){if(!["SCRIPT","HEAD","TITLE","NOSCRIPT","STYLE","TEMPLATE"].includes(e.nodeName.toUpperCase())&&Aa(r)){var a=window.getComputedStyle(e);if("none"===a.getPropertyValue("display"))return;if("hidden"===a.getPropertyValue("visibility")){var n=Jr(e),o=n&&window.getComputedStyle(n);if(!o||"hidden"!==o.getPropertyValue("visibility"))return}}return!0}var Ql={};t(Ql,{Color:function(){return Ya},centerPointOfRect:function(){return Zl},elementHasImage:function(){return Ua},elementIsDistinct:function(){return tu},filteredRectStack:function(){return au},flattenColors:function(){return nu},getBackgroundColor:function(){return uu},getBackgroundStack:function(){return iu},getContrast:function(){return su},getForegroundColor:function(){return cu},getOwnBackgroundColor:function(){return Ka},getRectStack:function(){return ru},getTextShadowColors:function(){return lu},hasValidContrastRatio:function(){return du},incompleteData:function(){return Ma}});var Zl=function(e){if(!(e.left>window.innerWidth||e.top>window.innerHeight))return{x:Math.min(Math.ceil(e.left+e.width/2),window.innerWidth-1),y:Math.min(Math.ceil(e.top+e.height/2),window.innerHeight-1)}};function eu(e){return e.getPropertyValue("font-family").split(/[,;]/g).map(function(e){return e.trim().toLowerCase()})}var tu=function(e,t){var a=window.getComputedStyle(e);if("none"!==a.getPropertyValue("background-image"))return!0;if(["border-bottom","border-top","outline"].reduce(function(e,t){var r=new Ya;return r.parseString(a.getPropertyValue(t+"-color")),e||"none"!==a.getPropertyValue(t+"-style")&&0<parseFloat(a.getPropertyValue(t+"-width"))&&0!==r.alpha},!1))return!0;var r=window.getComputedStyle(t);if(eu(a)[0]!==eu(r)[0])return!0;var n=["text-decoration-line","text-decoration-style","font-weight","font-style","font-size"].reduce(function(e,t){return e||a.getPropertyValue(t)!==r.getPropertyValue(t)},!1),o=a.getPropertyValue("text-decoration");return o.split(" ").length<3&&(n=n||o!==r.getPropertyValue("text-decoration")),n};var ru=function(e){var t=ma(e),r=va(e);return!r||r.length<=1?[t]:r.some(function(e){return void 0===e})?null:(r.splice(0,0,t),r)};var au=function(n){var o=ru(n);if(o&&1===o.length)return o[0];if(o&&1<o.length){var i,l=o.shift();return o.forEach(function(e,t){var r,a;0!==t&&(r=o[t-1],a=o[t],i=r.every(function(e,t){return e===a[t]})||l.includes(n))}),i?o[0]:(Ma.set("bgColor","elmPartiallyObscuring"),null)}return Ma.set("bgColor","outsideViewport"),null};var nu=function(e,t){var r=e.alpha,a=(1-r)*t.red+r*e.red,n=(1-r)*t.green+r*e.green,o=(1-r)*t.blue+r*e.blue,i=e.alpha+t.alpha*(1-e.alpha);return new Ya(a,n,o,i)};function ou(e,t,r){if(0<e)for(var a=e-1;0<=a;a--){if(function(e,t){var r=e.getClientRects()[0],a=rn(r.left,r.top);if(a)for(var n=0;n<a.length;n++)if(a[n]!==e&&a[n]===t)return 1}(r,t[a]))return 1;t.splice(a,1)}}var iu=function(e){var t,r,a,n=au(e);if(null===n)return null;n=Za(n,e),r=(t=n).indexOf(document.body),a=t,(1<r||-1===r)&&!Ua(document.documentElement)&&0===Ka(window.getComputedStyle(document.documentElement)).alpha&&(1<r&&a.splice(r,1),a.splice(t.indexOf(document.documentElement),1),a.push(document.body));var o=(n=a).indexOf(e);return ou(o,n,e)?(Ma.set("bgColor","bgOverlap"),null):-1!==o?n:null};var lu=function(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},s=t.minRatio,c=t.maxRatio,d=window.getComputedStyle(e),r=d.getPropertyValue("text-shadow");if("none"===r)return[];var a=d.getPropertyValue("font-size"),p=parseInt(a);ht(!1===isNaN(p),"Unable to determine font-size value ".concat(a));var f=[];return function(e){var t={pixels:[]},r=e.trim(),a=[t];if(!r)return[];for(;r;){var n=r.match(/^rgba?\\([0-9,.\\s]+\\)/i)||r.match(/^[a-z]+/i)||r.match(/^#[0-9a-f]+/i),o=r.match(/^([0-9.-]+)px/i)||r.match(/^(0)/);if(n)ht(!t.colorStr,"Multiple colors identified in text-shadow: ".concat(e)),r=r.replace(n[0],"").trim(),t.colorStr=n[0];else if(o){ht(t.pixels.length<3,"Too many pixel units in text-shadow: ".concat(e)),r=r.replace(o[0],"").trim();var i=parseFloat(("."===o[1][0]?"0":"")+o[1]);t.pixels.push(i)}else{if(","!==r[0])throw new Error("Unable to process text-shadows: ".concat(e));ht(2<=t.pixels.length,"Missing pixel value in text-shadow: ".concat(e)),t={pixels:[]},a.push(t),r=r.substr(1).trim()}}return a}(r).forEach(function(e){var t,r=e.colorStr,a=e.pixels,r=r||d.getPropertyValue("color"),n=tc(a,3),o=n[0],i=n[1],l=n[2],u=void 0===l?0:l;(!s||p*s<=u)&&(!c||u<p*c)&&(t=function(e){var t=e.colorStr,r=e.offsetX,a=e.offsetY,n=e.blurRadius,o=e.fontSize;if(n<r||n<a)return new Ya(0,0,0,0);var i=new Ya;return i.parseString(t),i.alpha*=function(e,t){return.185/(e/t+.4)}(n,o),i}({colorStr:r,offsetY:o,offsetX:i,blurRadius:u,fontSize:p}),f.push(t))}),f};var uu=function(l){var u=1<arguments.length&&void 0!==arguments[1]?arguments[1]:[],s=lu(l,{minRatio:2<arguments.length&&void 0!==arguments[2]?arguments[2]:.1}),e=iu(l);return(e||[]).some(function(e){var t,r,a,n,o=window.getComputedStyle(e),i=Ka(o);return a=i,(n=(t=l)!==(r=e)&&!tn(t,r)&&0!==a.alpha)&&Ma.set("bgColor","elmPartiallyObscured"),n||Ua(e,o)?(s=null,u.push(e),!0):0!==i.alpha&&(u.push(e),s.push(i),1===i.alpha)}),null===s||null===e?null:(s.push(new Ya(255,255,255,1)),s.reduce(nu))};var su=function(e,t){if(!t||!e)return null;t.alpha<1&&(t=nu(t,e));var r=e.getRelativeLuminance(),a=t.getRelativeLuminance();return(Math.max(a,r)+.05)/(Math.min(a,r)+.05)};var cu=function(e,t,r){var a=window.getComputedStyle(e),n=new Ya;n.parseString(a.getPropertyValue("color"));var o=function e(t){if(!t)return 1;var r=wn(t);if(r&&void 0!==r._opacity&&null!==r._opacity)return r._opacity;var a=window.getComputedStyle(t).getPropertyValue("opacity")*e(t.parentElement);return r&&(r._opacity=a),a}(e);if(n.alpha=n.alpha*o,1===n.alpha)return n;if(null!==(r=r||uu(e,[])))return nu(n,r);var i=Ma.get("bgColor");return Ma.set("fgColor",i),null};var du=function(e,t,r,a){var n=su(e,t),o=a&&Math.ceil(72*r)/96<14||!a&&Math.ceil(72*r)/96<18?4.5:3;return{isValid:o<n,contrastRatio:n,expectedContrastRatio:o}},pu=Sn(function(e,t){var r=window.getComputedStyle(e,t),a=Ka(r);return"none"!==r.getPropertyValue("content")&&"absolute"===r.getPropertyValue("position")&&0!==parseInt(r.getPropertyValue("width"))&&0!==parseInt(r.getPropertyValue("height"))&&(0!==a.alpha||"none"!==r.getPropertyValue("background-image"))});function fu(e,t,r){if(!ia(e,!1))return!0;var a=t.ignoreUnicode,n=t.ignoreLength,o=t.boldValue,i=t.boldTextPt,l=t.largeTextPt,u=t.contrastRatio,s=t.shadowOutlineEmMax,c=wa(r,!1,!0);if(!Oi(c,{nonBmp:!0})||""!==ga(Pi(c,{nonBmp:!0}))||!a){var d,p,f,m=[],h=uu(e,m,s),g=cu(e,!1,h),v=lu(e,{maxRatio:s}),b=window.getComputedStyle(e),y=parseFloat(b.getPropertyValue("font-size")),D=b.getPropertyValue("font-weight"),w=parseFloat(D)>=o||"bold"===D,x=null;0===v.length?x=su(h,g):g&&h&&(d=[].concat(Zs(v),[h]).reduce(nu),p=su(h,d),f=su(d,g),x=Math.max(p,f));for(var E=Math.ceil(72*y)/96,A=w&&E<i||!w&&E<l?u.normal:u.large,C=A.expected,F=A.minThreshold,k=A.maxThreshold,R=C<x,T=e.parentElement;T;){if(pu(T,":before")||pu(T,":after"))return this.data({messageKey:"pseudoContent"}),void this.relatedNodes(T);T=T.parentElement}if("number"==typeof F&&x<F||"number"==typeof k&&k<x)return!0;var N,_=Math.floor(100*x)/100;null===h&&(N=Ma.get("bgColor"));var O=1==_,S=1===c.length;O?N=Ma.set("bgColor","equalRatio"):S&&!n&&(N="shortTextContent");var P={fgColor:g?g.toHexString():void 0,bgColor:h?h.toHexString():void 0,contrastRatio:_,fontSize:"".concat((72*y/96).toFixed(1),"pt (").concat(y,"px)"),fontWeight:w?"bold":"normal",messageKey:N,expectedContrastRatio:C+":1"};return(this.data(P),null===g||null===h||O||S&&!n&&!R)?(N=null,Ma.clear(),void this.relatedNodes(m)):(R||this.relatedNodes(m),R)}this.data({messageKey:"nonBmp"})}function mu(e,t){var r=e.getRelativeLuminance(),a=t.getRelativeLuminance();return(Math.max(r,a)+.05)/(Math.min(r,a)+.05)}var hu=["block","list-item","table","flex","grid","inline-block"];function gu(e){var t=window.getComputedStyle(e).getPropertyValue("display");return-1!==hu.indexOf(t)||"table-"===t.substr(0,6)}function vu(e){if(gu(e))return!1;for(var t=Jr(e);1===t.nodeType&&!gu(t);)t=Jr(t);if(this.relatedNodes([t]),tu(e,t))return!0;var r=cu(e),a=cu(t);if(r&&a){var n=mu(r,a);if(1===n)return!0;if(3<=n)return Ma.set("fgColor","bgContrast"),this.data({messageKey:Ma.get("fgColor")}),void Ma.clear();if(r=uu(e),a=uu(t),!r||!a||3<=mu(r,a)){var o=r&&a?"bgContrast":Ma.get("bgColor");return Ma.set("fgColor",o),this.data({messageKey:Ma.get("fgColor")}),void Ma.clear()}return!1}}function bu(e,t,r){if("input"!==r.props.nodeName)return!0;var a=["text","search","number","tel"],n=["text","search","url"],o={bday:["text","search","date"],email:["text","search","email"],"street-address":["text"],tel:["text","search","tel"],"tel-country-code":["text","search","tel"],"tel-national":["text","search","tel"],"tel-area-code":["text","search","tel"],"tel-local":["text","search","tel"],"tel-local-prefix":["text","search","tel"],"tel-local-suffix":["text","search","tel"],"tel-extension":["text","search","tel"],"cc-number":a,"cc-exp":["text","search","month","tel"],"cc-exp-month":a,"cc-exp-year":a,"cc-csc":a,"transaction-amount":a,"bday-day":a,"bday-month":a,"bday-year":a,"new-password":["text","search","password"],"current-password":["text","search","password"],url:n,photo:n,impp:n};"object"===Gs(t)&&Object.keys(t).forEach(function(e){o[e]||(o[e]=[]),o[e]=o[e].concat(t[e])});var i=r.attr("autocomplete").split(/\\s+/g).map(function(e){return e.toLowerCase()}),l=i[i.length-1];if(Li.stateTerms.includes(l))return!0;var u=o[l],s=r.hasAttr("type")?ga(r.attr("type")).toLowerCase():"text",s=co().includes(s)?s:"text";return void 0===u?"text"===s:u.includes(s)}function yu(e,t,r){var a=r.attr("autocomplete")||"";return qi(a,t)}function Du(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},r=2<arguments.length?arguments[2]:void 0;if(!t.attribute||"string"!=typeof t.attribute)throw new TypeError("attr-non-space-content requires options.attribute to be a string");if(!r.hasAttr(t.attribute))return this.data({messageKey:"noAttr"}),!1;var a=r.attr(t.attribute);return!!ga(a)||(this.data({messageKey:"emptyAttr"}),!1)}function wu(e){return e.some(function(e){return!0===e.result})&&e.forEach(function(e){e.result=!0}),e}function xu(e,t,r){if(!t||!t.selector||"string"!=typeof t.selector)throw new TypeError("has-descendant requires options.selector to be a string");var a=Yn(r,t.selector,function(e){return ia(e.actualNode,!0)});return this.relatedNodes(a.map(function(e){return e.actualNode})),0<a.length}function Eu(e,t,r){try{return""!==ga(ri(r))}catch(e){return}}function Au(e,t,r){return Ko(r,t.matcher)}function Cu(e){return e.filter(function(e){return"ignored"!==e.data})}function Fu(e,t,r){if(!t||!t.selector||"string"!=typeof t.selector)throw new TypeError("page-no-duplicate requires options.selector to be a string");var a="page-no-duplicate;"+t.selector;if(!xr.get(a)){xr.set(a,!0);var n=Yn(axe._tree[0],t.selector,function(e){return ia(e.actualNode)});return"string"==typeof t.nativeScopeFilter&&(n=n.filter(function(e){return e.actualNode.hasAttribute("role")||!Kr(e,t.nativeScopeFilter)})),this.relatedNodes(n.filter(function(e){return e!==r}).map(function(e){return e.actualNode})),n.length<=1}this.data("ignored")}function ku(e){if(e.length<2)return e;for(var t=e[0].data,r=1;r<e.length;r++)e[r].result&&e[r].data>t+1&&(e[r].result=!1),t=e[r].data;return e}function Ru(e,t,r){var a=r.attr("aria-level"),n=r.props.nodeName;if(null!==a)return this.data(parseInt(a,10)),!0;var o=n.toUpperCase().match(/H(\\d)/);return o&&this.data(parseInt(o[1],10)),!0}function Tu(e){if(e.length<2)return e;function t(r){var e,t=u[r],a=t.data,n=a.name,o=a.urlProps;if(c[n])return"continue";var i=u.filter(function(e,t){return e.data.name===n&&t!==r}),l=i.every(function(e){return function a(n,o){if(!n||!o)return!1;var e=Object.getOwnPropertyNames(n),t=Object.getOwnPropertyNames(o);return e.length===t.length&&e.every(function(e){var t=n[e],r=o[e];return Gs(t)===Gs(r)&&("object"==typeof t||"object"==typeof r?a(t,r):t===r)})}(e.data.urlProps,o)});i.length&&!l&&(t.result=void 0),t.relatedNodes=[],(e=t.relatedNodes).push.apply(e,Zs(i.map(function(e){return e.relatedNodes[0]}))),c[n]=i,s.push(t)}for(var u=e.filter(function(e){return void 0!==e.result}),s=[],c={},r=0;r<u.length;r++)t(r);return s}var Nu={};t(Nu,{aria:function(){return go},color:function(){return Ql},dom:function(){return $r},forms:function(){return _u},matches:function(){return Ko},standards:function(){return vl},table:function(){return Bl},text:function(){return ki},utils:function(){return rt}});var _u={};t(_u,{isAriaCombobox:function(){return hi},isAriaListbox:function(){return mi},isAriaRange:function(){return vi},isAriaTextbox:function(){return fi},isDisabled:function(){return Su},isNativeSelect:function(){return pi},isNativeTextbox:function(){return di}});var Ou=["fieldset","button","select","input","textarea"];var Su=function e(t){if("boolean"==typeof(n=t._isDisabled))return n;var r=t.props.nodeName,a=t.attr("aria-disabled"),n=!(!Ou.includes(r)||!t.hasAttr("disabled"))||(a?"true"===a.toLowerCase():!!t.parent&&e(t.parent));return t._isDisabled=n};function Pu(e,t,r){var a=ki.accessibleTextVirtual(r),n=ki.sanitize(ki.removeUnicode(a,{emoji:!0,nonBmp:!0,punctuations:!0})).toLowerCase();if(n){var o={name:n,urlProps:$r.urlPropsFromAttribute(e,"href")};return this.data(o),this.relatedNodes([e]),!0}}function Iu(e,t,r){return no(r,"a[href]").some(function(e){return/^#[^/!]/.test(e.actualNode.getAttribute("href"))})}function Bu(e,t,r){var a=r.attr("content")||"",n=a.split(/[;,]/);return""===a||"0"===n[0]}function Lu(e){var t=window.getComputedStyle(function(e){for(var t=e,r=e.textContent.trim(),a=r;a===r&&void 0!==t;){var n=-1;if(0===(e=t).children.length)return e;for(;n++,""===(a=e.children[n].textContent.trim())&&n+1<e.children.length;);t=e.children[n]}return e}(e));return{fontWeight:function(e){switch(e){case"lighter":return 100;case"normal":return 400;case"bold":return 700;case"bolder":return 900}return e=parseInt(e),isNaN(e)?400:e}(t.getPropertyValue("font-weight")),fontSize:parseInt(t.getPropertyValue("font-size")),isItalic:"italic"===t.getPropertyValue("font-style")}}function qu(r,a,e){return e.reduce(function(e,t){return e||(!t.size||r.fontSize/t.size>a.fontSize)&&(!t.weight||r.fontWeight-t.weight>a.fontWeight)&&(!t.italic||r.isItalic&&!a.isItalic)},!1)}function ju(e,t,r){var a=Array.from(e.parentNode.children),n=a.indexOf(e),o=(t=t||{}).margins||[],i=a.slice(n+1).find(function(e){return"P"===e.nodeName.toUpperCase()}),l=a.slice(0,n).reverse().find(function(e){return"P"===e.nodeName.toUpperCase()}),u=Lu(e),s=i?Lu(i):null,c=l?Lu(l):null;if(!s||!qu(u,s,o))return!0;var d=Kr(r,"blockquote");return!!(d&&"BLOCKQUOTE"===d.nodeName.toUpperCase()||c&&!qu(u,c,o))&&void 0}var Mu=Xi("landmark"),Uu=["alert","log","status"];function Vu(e,t){var r,a,n,o,i,l=e.actualNode;if(a=t,n=(r=e).actualNode,o=Bo(r),i=(n.getAttribute("aria-live")||"").toLowerCase().trim(),["assertive","polite"].includes(i)||Uu.includes(o)||Mu.includes(o)||a.regionMatcher&&Ko(r,a.regionMatcher)||Qa(e.actualNode)&&Qr(e.actualNode,"href")||!ia(l,!0)){for(var u=e;u;)u._hasRegionDescendant=!0,u=u.parent;return[]}return l!==document.body&&Ca(l,!0)?[e]:e.children.filter(function(e){return 1===e.actualNode.nodeType}).map(function(e){return Vu(e,t)}).reduce(function(e,t){return e.concat(t)},[])}function Hu(e,t){var r=zu(t),a=zu(e);return!(!r||!a)&&r.includes(a)}function zu(e){var t=Pi(e,{emoji:!0,nonBmp:!0,punctuations:!0});return ga(t)}function $u(e){return""!==(e||"").trim()}var Wu=function(e,t,r){return r.initiator};var Gu=function(e,t){try{return"svg"===t.props.nodeName?!0:!!er(t,"svg")}catch(e){return!1}};function Yu(e,t){var r=Xo(t).namingMethods;return(!r||0===r.length)&&("combobox"!==xo(t)||!no(t,\'input:not([type="hidden"])\').length)}var Ku={"abstractrole-evaluate":pl,"aria-allowed-attr-evaluate":fl,"aria-allowed-role-evaluate":ml,"aria-errormessage-evaluate":hl,"aria-hidden-body-evaluate":gl,"aria-required-attr-evaluate":bl,"aria-required-children-evaluate":yl,"aria-required-parent-evaluate":wl,"aria-roledescription-evaluate":xl,"aria-unsupported-attr-evaluate":El,"aria-valid-attr-evaluate":Al,"aria-valid-attr-value-evaluate":Cl,"fallbackrole-evaluate":Fl,"has-global-aria-attribute-evaluate":kl,"has-widget-role-evaluate":Rl,"invalidrole-evaluate":Tl,"is-element-focusable-evaluate":Nl,"no-implicit-explicit-label-evaluate":_l,"unsupportedrole-evaluate":Ol,"valid-scrollable-semantics-evaluate":Il,"caption-faked-evaluate":zl,"html5-scope-evaluate":$l,"same-caption-summary-evaluate":Wl,"scope-value-evaluate":Gl,"td-has-header-evaluate":Yl,"td-headers-attr-evaluate":Kl,"th-has-data-cells-evaluate":Xl,"hidden-content-evaluate":Jl,"color-contrast-evaluate":fu,"link-in-text-block-evaluate":vu,"autocomplete-appropriate-evaluate":bu,"autocomplete-valid-evaluate":yu,"attr-non-space-content-evaluate":Du,"has-descendant-after":wu,"has-descendant-evaluate":xu,"has-text-content-evaluate":Eu,"matches-definition-evaluate":Au,"page-no-duplicate-after":Cu,"page-no-duplicate-evaluate":Fu,"heading-order-after":ku,"heading-order-evaluate":Ru,"identical-links-same-purpose-after":Tu,"identical-links-same-purpose-evaluate":Pu,"internal-link-present-evaluate":Iu,"meta-refresh-evaluate":Bu,"p-as-heading-evaluate":ju,"region-evaluate":function(e,t,r){if(a=xr.get("regionlessNodes"))return!a.includes(r);var a=Vu(axe._tree[0],t).map(function(e){for(;e.parent&&!e.parent._hasRegionDescendant&&e.parent.actualNode!==document.body;)e=e.parent;return e}).filter(function(e,t,r){return r.indexOf(e)===t});return xr.set("regionlessNodes",a),!a.includes(r)},"skip-link-evaluate":function(e){var t=Qr(e,"href");return!!t&&(ia(t,!0)||void 0)},"unique-frame-title-after":function(e){var t={};return e.forEach(function(e){t[e.data]=void 0!==t[e.data]?++t[e.data]:0}),e.forEach(function(e){e.result=!!t[e.data]}),e},"unique-frame-title-evaluate":function(e,t,r){var a=ga(r.attr("title")).toLowerCase();return this.data(a),!0},"aria-label-evaluate":function(e,t,r){return!!ga(yo(r))},"aria-labelledby-evaluate":function(e,t,r){try{return!!ga(Fi(r))}catch(e){return}},"avoid-inline-spacing-evaluate":function(t,e){var r=e.cssProperties.filter(function(e){if("important"===t.style.getPropertyPriority(e))return e});return!(0<r.length)||(this.data(r),!1)},"doc-has-title-evaluate":function(){var e=document.title;return!!ga(e)},"exists-evaluate":function(){},"has-alt-evaluate":function(e,t,r){var a=r.props.nodeName;return!!["img","input","area"].includes(a)&&r.hasAttr("alt")},"is-on-screen-evaluate":function(e){return ia(e,!1)&&!ra(e)},"non-empty-if-present-evaluate":function(e,t,r){var a=r.props.nodeName,n=(r.attr("type")||"").toLowerCase(),o=r.attr("value");return o&&this.data({messageKey:"has-label"}),!("input"!==a||!["submit","reset"].includes(n))&&null===o},"presentational-role-evaluate":function(e,t,r){var a=Bo(r),n=xo(r);if(["presentation","none"].includes(a))return this.data({role:a}),!0;if(!["presentation","none"].includes(n))return!1;var o=vo().some(function(e){return r.hasAttr(e)}),i=_a(r),l=o&&!i?"globalAria":!o&&i?"focusable":"both";return this.data({messageKey:l,role:a}),!1},"svg-non-empty-title-evaluate":function(e,t,r){try{var a=r.children.find(function(e){return"title"===e.props.nodeName});return a?""!==wa(a)||(this.data({messageKey:"emptyTitle"}),!1):(this.data({messageKey:"noTitle"}),!1)}catch(e){return}},"css-orientation-lock-evaluate":function(e,t,r,a){var n=(a||{}).cssom,o=void 0===n?void 0:n,i=(t||{}).degreeThreshold,s=void 0===i?0:i;if(o&&o.length){function l(){var e=f[p],t=d[e],a=t.root,r=t.rules.filter(m);if(!r.length)return"continue";r.forEach(function(e){var t=e.cssRules;Array.from(t).forEach(function(e){var t,r=function(e){var t=e.selectorText,r=e.style;if(!t||r.length<=0)return!1;var a=r.transform||r.webkitTransform||r.msTransform||!1;if(!a)return!1;var n=a.match(/(rotate|rotateZ|rotate3d|matrix|matrix3d)\\(([^)]+)\\)(?!.*(rotate|rotateZ|rotate3d|matrix|matrix3d))/);if(!n)return!1;var o=tc(n,3),i=o[1],l=o[2],u=function(e,t){switch(e){case"rotate":case"rotateZ":return h(t);case"rotate3d":var r=tc(t.split(",").map(function(e){return e.trim()}),4),a=r[2],n=r[3];if(0===parseInt(a))return;return h(n);case"matrix":case"matrix3d":return function(e){var t=e.split(",");if(t.length<=6){var r=tc(t,2),a=r[0],n=r[1];return g(Math.atan2(parseFloat(n),parseFloat(a)))}var o=parseFloat(t[8]),i=Math.asin(o),l=Math.cos(i);return g(Math.acos(parseFloat(t[0])/l))}(t);default:return}}(i,l);if(!u)return!1;if(u=Math.abs(u),Math.abs(u-180)%180<=s)return!1;return Math.abs(u-90)%90<=s}(e);r&&"HTML"!==e.selectorText.toUpperCase()&&(t=Array.from(a.querySelectorAll(e.selectorText))||[],c=c.concat(t)),u=u||r})})}for(var u=!1,c=[],d=o.reduce(function(e,t){var r=t.sheet,a=t.root,n=t.shadowId,o=n||"topDocument";if(e[o]||(e[o]={root:a,rules:[]}),!r||!r.cssRules)return e;var i=Array.from(r.cssRules);return e[o].rules=e[o].rules.concat(i),e},{}),p=0,f=Object.keys(d);p<f.length;p++)l();return u?(c.length&&this.relatedNodes(c),!1):!0}function m(e){var t=e.type,r=e.cssText;return 4===t&&(/orientation:\\s*landscape/i.test(r)||/orientation:\\s*portrait/i.test(r))}function h(e){var t=tc(e.match(/(deg|grad|rad|turn)/)||[],1)[0];if(t){var r,a=parseFloat(e.replace(t,""));switch(t){case"rad":return g(a);case"grad":return function(e){(e%=400)<0&&(e+=400);return Math.round(e/400*360)}(a);case"turn":return r=a,Math.round(360/(1/r));case"deg":default:return parseInt(a)}}}function g(e){return Math.round(e*(180/Math.PI))}},"meta-viewport-scale-evaluate":function(e,t){var r=t||{},a=r.scaleMinimum,n=void 0===a?2:a,o=r.lowerBound,i=void 0!==o&&o,l=e.getAttribute("content")||"";if(!l)return!0;var u=l.split(/[;,]/).reduce(function(e,t){var r=t.trim();if(!r)return e;var a=tc(r.split("="),2),n=a[0],o=a[1];if(!n||!o)return e;var i=n.toLowerCase().trim(),l=o.toLowerCase().trim();return"maximum-scale"===i&&"yes"===l&&(l=1),"maximum-scale"===i&&parseFloat(l)<0||(e[i]=l),e},{});return!!(i&&u["maximum-scale"]&&parseFloat(u["maximum-scale"])<i)||(i||"no"!==u["user-scalable"]?!(u["maximum-scale"]&&parseFloat(u["maximum-scale"])<n)||(this.data("maximum-scale"),!1):(this.data("user-scalable=no"),!1))},"duplicate-id-after":function(e){var t=[];return e.filter(function(e){return-1===t.indexOf(e.data)&&(t.push(e.data),!0)})},"duplicate-id-evaluate":function(t){var e=t.getAttribute("id").trim();if(!e)return!0;var r=Gr(t),a=Array.from(r.querySelectorAll(\'[id="\'.concat(vt(e),\'"]\'))).filter(function(e){return e!==t});return a.length&&this.relatedNodes(a),this.data(e),0===a.length},"accesskeys-after":function(e){var r={};return e.filter(function(e){if(!e.data)return!1;var t=e.data.toUpperCase();return r[t]?(r[t].relatedNodes.push(e.relatedNodes[0]),!1):((r[t]=e).relatedNodes=[],!0)}).map(function(e){return e.result=!!e.relatedNodes.length,e})},"accesskeys-evaluate":function(e){return ia(e,!1)&&(this.data(e.getAttribute("accesskey")),this.relatedNodes([e])),!0},"focusable-content-evaluate":function(e,t,r){var a=r.tabbableElements;return!!a&&0<a.filter(function(e){return e!==r}).length},"focusable-disabled-evaluate":function(e,t,r){var n=["BUTTON","FIELDSET","INPUT","SELECT","TEXTAREA"],a=r.tabbableElements;if(!a||!a.length)return!0;var o=a.reduce(function(e,t){var r=t.actualNode,a=r.nodeName.toUpperCase();return n.includes(a)&&e.push(r),e},[]);return this.relatedNodes(o),!(!o.length||!La())||0===o.length},"focusable-element-evaluate":function(e,t,n){if(n.hasAttr("contenteditable")&&function e(t){var r=t.attr("contenteditable");if("true"===r||""===r)return!0;if("false"===r)return!1;var a=er(n.parent,"[contenteditable]");if(!a)return!1;return e(a)}(n))return!0;var r=n.isFocusable,a=parseInt(n.attr("tabindex"),10);return(a=isNaN(a)?null:a)?r&&0<=a:r},"focusable-modal-open-evaluate":function(e,t,r){var a=r.tabbableElements.map(function(e){return e.actualNode});return!a||!a.length||(!La()||void this.relatedNodes(a))},"focusable-no-name-evaluate":function(e,t,r){var a=r.attr("tabindex");if(!(_a(r)&&-1<a))return!1;try{return!Ai(r)}catch(e){return}},"focusable-not-tabbable-evaluate":function(e,t,r){var n=["BUTTON","FIELDSET","INPUT","SELECT","TEXTAREA"],a=r.tabbableElements;if(!a||!a.length)return!0;var o=a.reduce(function(e,t){var r=t.actualNode,a=r.nodeName.toUpperCase();return n.includes(a)||e.push(r),e},[]);return this.relatedNodes(o),!!(0<o.length&&La())||0===o.length},"landmark-is-top-level-evaluate":function(e){var t=Xi("landmark"),r=Jr(e);for(this.data({role:e.getAttribute("role")||Oo(e)});r;){var a=r.getAttribute("role");if(a||"FORM"===r.nodeName.toUpperCase()||(a=Oo(r)),a&&t.includes(a))return!1;r=Jr(r)}return!0},"tabindex-evaluate":function(e,t,r){var a=parseInt(r.attr("tabindex"),10);return!!isNaN(a)||a<=0},"alt-space-value-evaluate":function(e,t,r){var a=r.attr("alt");return"string"==typeof a&&/^\\s+$/.test(a)},"duplicate-img-label-evaluate":function(e,t,r){if(["none","presentation"].includes(Bo(r)))return!1;var a=er(r,t.parentSelector);if(!a)return!1;var n=wa(a,!0).toLowerCase();return""!==n&&n===Ai(r).toLowerCase()},"explicit-evaluate":function(e,t,r){try{if(r.attr("id")){var a=Gr(r.actualNode),n=vt(r.attr("id")),o=Array.from(a.querySelectorAll(\'label[for="\'.concat(n,\'"]\')));if(o.length)return o.some(function(e){return!ia(e)||!!Ci(e)})}return!1}catch(e){return}},"help-same-as-label-evaluate":function(e,t,r){var a=Mi(r),n=e.getAttribute("title");return!!a&&(n||(n="",e.getAttribute("aria-describedby")&&(n=Da(e,"aria-describedby").map(function(e){return e?Ci(e):""}).join(""))),ga(n)===ga(a))},"hidden-explicit-label-evaluate":function(e,t,r){try{if(r.hasAttr("id")){var a=Gr(e),n=vt(e.getAttribute("id")),o=a.querySelector(\'label[for="\'.concat(n,\'"]\'));if(o&&!ia(o,!0))return""===Ai(r).trim()}return!1}catch(e){return}},"implicit-evaluate":function(e,t,r){try{var a=er(r,"label");return a?!!Ai(a,{inControlContext:!0}):!1}catch(e){return}},"label-content-name-mismatch-evaluate":function(e,t,r){var a=t||{},n=a.pixelThreshold,o=a.occuranceThreshold,i=Ci(e).toLowerCase();if(!(Ii(i)<1)){var l=Hi(r).filter(function(e){return!Bi(e,n,o)}).map(function(e){return e.actualNode.nodeValue}).join(""),u=ga(l).toLowerCase();return!u||(Ii(u)<1?!!Hu(u,i)||void 0:Hu(u,i))}},"multiple-label-evaluate":function(e){var t=vt(e.getAttribute("id")),r=e.parentNode,a=(a=Gr(e)).documentElement||a,n=Array.from(a.querySelectorAll(\'label[for="\'.concat(t,\'"]\')));for(n.length&&(n=n.filter(function(e){return ia(e)}));r;)"LABEL"===r.nodeName.toUpperCase()&&-1===n.indexOf(r)&&n.push(r),r=r.parentNode;if(this.relatedNodes(n),1<n.length){var o=n.filter(function(e){return ia(e,!0)});if(1<o.length)return;return!Da(e,"aria-labelledby").includes(o[0])&&void 0}return!1},"title-only-evaluate":function(e,t,r){var a=Mi(r),n=Qo(r),o=r.attr("aria-describedby");return!(a||!n&&!o)},"landmark-is-unique-after":function(e){var r=[];return e.filter(function(t){var e=r.find(function(e){return t.data.role===e.data.role&&t.data.accessibleText===e.data.accessibleText});return e?(e.result=!1,e.relatedNodes.push(t.relatedNodes[0]),!1):(r.push(t),t.relatedNodes=[],!0)})},"landmark-is-unique-evaluate":function(e,t,r){var a=Bo(e),n=(n=Ai(r))?n.toLowerCase():null;return this.data({role:a,accessibleText:n}),this.relatedNodes([e]),!0},"has-lang-evaluate":function(e,t,r){return t.attributes.includes("xml:lang")&&t.attributes.includes("lang")&&$u(r.attr("xml:lang"))&&!$u(r.attr("lang"))&&!At(document)?(this.data({messageKey:"noXHTML"}),!1):!!t.attributes.some(function(e){return $u(r.attr(e))})||(this.data({messageKey:"noLang"}),!1)},"valid-lang-evaluate":function(e,n,o){var i=[];return n.attributes.forEach(function(e){var t,r,a=o.attr(e);"string"==typeof a&&(t=cn(a),r=n.value?!n.value.map(cn).includes(t):!mo(t),(""!==t&&r||""!==a&&!ga(a))&&i.push(e+\'="\'+o.attr(e)+\'"\'))}),!!i.length&&(this.data(i),!0)},"xml-lang-mismatch-evaluate":function(e,t,r){return cn(r.attr("lang"))===cn(r.attr("xml:lang"))},"dlitem-evaluate":function(e){var t=Jr(e),r=t.nodeName.toUpperCase(),a=xo(t);return"DIV"===r&&["presentation","none",null].includes(a)&&(r=(t=Jr(t)).nodeName.toUpperCase(),a=xo(t)),"DL"===r&&!(a&&!["presentation","none","list"].includes(a))},"listitem-evaluate":function(e){var t=Jr(e);if(t){var r=t.nodeName.toUpperCase(),a=(t.getAttribute("role")||"").toLowerCase();return!!["presentation","none","list"].includes(a)||(a&&wo(a)?(this.data({messageKey:"roleNotValid"}),!1):["UL","OL"].includes(r))}},"only-dlitems-evaluate":function(e,t,r){var o=["definition","term","list"],a=r.children.reduce(function(e,t){var r=t.actualNode;return"DIV"===r.nodeName.toUpperCase()&&null===Bo(r)?e.concat(t.children):e.concat(t)},[]).reduce(function(e,t){var r,a=t.actualNode,n=a.nodeName.toUpperCase();return 1===a.nodeType&&ia(a,!0,!1)?(r=xo(a),("DT"!==n&&"DD"!==n||r)&&(o.includes(r)||e.badNodes.push(a))):3===a.nodeType&&""!==a.nodeValue.trim()&&(e.hasNonEmptyTextNode=!0),e},{badNodes:[],hasNonEmptyTextNode:!1});return a.badNodes.length&&this.relatedNodes(a.badNodes),!!a.badNodes.length||a.hasNonEmptyTextNode},"only-listitems-evaluate":function(e,t,r){var o=!1,i=!1,l=!0,u=[],s=[],c=[];return r.children.forEach(function(e){var t,r,a,n=e.actualNode;3!==n.nodeType||""===n.nodeValue.trim()?1===n.nodeType&&ia(n,!0,!1)&&(l=!1,t="LI"===n.nodeName.toUpperCase(),a="listitem"===(r=Bo(e)),t||a||u.push(n),t&&!a&&(s.push(n),c.includes(r)||c.push(r)),a&&(i=!0)):o=!0}),o||u.length?(this.relatedNodes(u),!0):!l&&!i&&(this.relatedNodes(s),this.data({messageKey:"roleNotValid",roles:c.join(", ")}),!0)},"structured-dlitems-evaluate":function(e,t,r){var a=r.children;if(!a||!a.length)return!1;for(var n,o=!1,i=!1,l=0;l<a.length;l++){if("DT"===(n=a[l].props.nodeName.toUpperCase())&&(o=!0),o&&"DD"===n)return!1;"DD"===n&&(i=!0)}return o||i},"caption-evaluate":function(e,t,r){return!no(r,"track").some(function(e){return"captions"===(e.attr("kind")||"").toLowerCase()})&&void 0},"frame-tested-evaluate":function(e,t){var r=this.async(),a=Object.assign({isViolation:!1,timeout:500},t),n=a.isViolation,o=a.timeout,i=setTimeout(function(){i=setTimeout(function(){i=null,r(!n&&void 0)},0)},o);Or(e.contentWindow,"axe.ping",null,void 0,function(){null!==i&&(clearTimeout(i),r(!0))})},"no-autoplay-audio-evaluate":function(e,t){if(e.duration){var r=t.allowedDuration,a=void 0===r?3:r;return function(e){if(!e.currentSrc)return 0;var t=function(e){var t=e.match(/#t=(.*)/);return t?tc(t,2)[1].split(",").map(function(e){return(/:/.test(e)?function(e){var t=e.split(":"),r=0,a=1;for(;0<t.length;)r+=a*parseInt(t.pop(),10),a*=60;return parseFloat(r)}:parseFloat)(e)}):void 0}(e.currentSrc);return t?1!==t.length?Math.abs(t[1]-t[0]):Math.abs(e.duration-t[0]):Math.abs(e.duration-(e.currentTime||0))}(e)<=a&&!e.hasAttribute("loop")||!!e.hasAttribute("controls")}console.warn("axe.utils.preloadMedia did not load metadata")},"aria-allowed-attr-matches":function(e){var t=/^aria-/;if(e.hasAttributes())for(var r=xt(e),a=0,n=r.length;a<n;a++)if(t.test(r[a].name))return!0;return!1},"aria-allowed-role-matches":function(e){return null!==xo(e,{dpub:!0,fallback:!0})},"aria-form-field-name-matches":Yu,"aria-has-attr-matches":function(e){var t=/^aria-/;if(e.hasAttributes())for(var r=xt(e),a=0,n=r.length;a<n;a++)if(t.test(r[a].name))return!0;return!1},"aria-hidden-focus-matches":function(e){return function e(t){return!t||"true"!==t.getAttribute("aria-hidden")&&e(Jr(t))}(Jr(e))},"autocomplete-matches":function(e,t){var r=t.attr("autocomplete");if(!r||""===ga(r))return!1;var a=t.props.nodeName;if(!1===["textarea","input","select"].includes(a))return!1;if("input"===a&&["submit","reset","button","hidden"].includes(t.props.type))return!1;var n=t.attr("aria-disabled")||"false";if(t.hasAttr("disabled")||"true"===n.toLowerCase())return!1;var o=t.attr("role"),i=t.attr("tabindex");if("-1"===i&&o){var l=Ga.ariaRoles[o];if(void 0===l||"widget"!==l.type)return!1}return!("-1"===i&&t.actualNode&&!ia(t.actualNode,!1)&&!ia(t.actualNode,!0))},"bypass-matches":function(e,t,r){return!Wu(e,t,r)||!!e.querySelector("a[href]")},"color-contrast-matches":function(e,t){var r=t.props,a=r.nodeName,n=r.type;if("option"===a)return!1;if("select"===a&&!e.options.length)return!1;if("input"===a&&["hidden","range","color","checkbox","radio","image"].includes(n))return!1;if(Su(t))return!1;if(["input","select","textarea"].includes(a)){var o=window.getComputedStyle(e),i=parseInt(o.getPropertyValue("text-indent"),10);if(i){var l={top:(l=e.getBoundingClientRect()).top,bottom:l.bottom,left:l.left+i,right:l.right+i};if(!on(l,e))return!1}return!0}var u=Kr(t,"label");if("label"===a||u){var s=u||e,c=u?wn(u):t,d=Gr(s).getElementById(s.htmlFor||""),p=d&&wn(d);if(p&&Su(p))return!1;var f=no(c,\'input:not([type="hidden"]):not([type="image"]):not([type="button"]):not([type="submit"]):not([type="reset"]), select, textarea\')[0];if(f&&Su(f))return!1}for(var m,h=[],g=t;g;){g.props.id&&(m=$i(g).filter(function(e){return so(e.getAttribute("aria-labelledby")||"").includes(g.props.id)}).map(function(e){return wn(e)}),h.push.apply(h,Zs(m))),g=g.parent}if(0<h.length&&h.every(Su))return!1;var v=wa(t,!1,!0);if(!v||!Pi(v,{emoji:!0,nonBmp:!1,punctuations:!0}))return!1;for(var b=document.createRange(),y=t.children,D=0;D<y.length;D++){var w=y[D];3===w.actualNode.nodeType&&""!==ga(w.actualNode.nodeValue)&&b.selectNodeContents(w.actualNode)}for(var x=b.getClientRects(),E=0;E<x.length;E++)if(on(x[E],e))return!0;return!1},"data-table-large-matches":function(e){if(Ul(e)){var t=Ao(e);return 3<=t.length&&3<=t[0].length&&3<=t[1].length&&3<=t[2].length}return!1},"data-table-matches":function(e){return Ul(e)},"duplicate-id-active-matches":function(e){var t=e.getAttribute("id").trim(),r=\'*[id="\'.concat(vt(t),\'"]\'),a=Array.from(Gr(e).querySelectorAll(r));return!ol(e)&&a.some(_a)},"duplicate-id-aria-matches":function(e){return ol(e)},"duplicate-id-misc-matches":function(e){var t=e.getAttribute("id").trim(),r=\'*[id="\'.concat(vt(t),\'"]\'),a=Array.from(Gr(e).querySelectorAll(r));return!ol(e)&&a.every(function(e){return!_a(e)})},"frame-title-has-text-matches":function(e){var t=e.getAttribute("title");return!!ga(t)},"heading-matches":function(e){var t;return e.hasAttribute("role")&&(t=e.getAttribute("role").split(/\\s+/i).filter(axe.commons.aria.isValidRole)),t&&0<t.length?t.includes("heading"):"heading"===axe.commons.aria.implicitRole(e)},"html-namespace-matches":function(e,t){return!Gu(e,t)},"identical-links-same-purpose-matches":function(e,t){if(!!!Ai(t))return!1;var r=Bo(e);return!r||"link"===r},"inserted-into-focus-order-matches":function(e){return Oa(e)},"is-initiator-matches":Wu,"label-content-name-mismatch-matches":function(e,t){var r=Bo(e);return!!r&&(!!Xi("widget").includes(r)&&(!!Qi().includes(r)&&(!(!ga(yo(t))&&!ga(Fi(e)))&&!!ga(wa(t)))))},"label-matches":function(e,t){if("input"!==t.props.nodeName||!1===t.hasAttr("type"))return!0;var r=t.attr("type").toLowerCase();return!1===["hidden","image","button","submit","reset"].includes(r)},"landmark-has-body-context-matches":function(e,t){return e.hasAttribute("role")||!Kr(t,"article, aside, main, nav, section")},"landmark-unique-matches":function(e,t){var o=["article","aside","main","nav","section"].join(",");return function(e){var t=e.actualNode,r=Xi("landmark"),a=Bo(t);if(!a)return!1;var n=t.nodeName.toUpperCase();return"HEADER"===n||"FOOTER"===n?!Kr(e,o):"SECTION"!==n&&"FORM"!==n?0<=r.indexOf(a)||"region"===a:!!Ai(e)}(t)&&ia(e,!0)},"layout-table-matches":function(e){return!Ul(e)&&!_a(e)},"link-in-text-block-matches":function(e){var t=ga(e.textContent),r=e.getAttribute("role");return(!r||"link"===r)&&(!!t&&(!!ia(e,!1)&&Ba(e)))},"no-autoplay-audio-matches":function(e){return!!e.currentSrc&&(!e.hasAttribute("paused")&&!e.hasAttribute("muted"))},"no-empty-role-matches":function(e,t){return!!t.hasAttr("role")&&!!t.attr("role").trim()},"no-explicit-name-required-matches":function(e,t){var r=xo(t);return!(r&&!["none","presentation"].includes(r))||!(!(Va[r]||{}).accessibleNameRequired&&!_a(t))},"no-naming-method-matches":Yu,"no-role-matches":function(e){return!e.getAttribute("role")},"not-html-matches":function(e){return"html"!==e.nodeName.toLowerCase()},"p-as-heading-matches":function(e){var t=Array.from(e.parentNode.childNodes),r=e.textContent.trim();return!(0===r.length||2<=(r.match(/[.!?:;](?![.!?:;])/g)||[]).length)&&0!==t.slice(t.indexOf(e)+1).filter(function(e){return"P"===e.nodeName.toUpperCase()&&""!==e.textContent.trim()}).length},"scrollable-region-focusable-matches":function(e,t){if(!1==!!xn(e,13))return!1;var r=xo(t);if(Ga.ariaRoles.combobox.requiredOwned.includes(r)){if(er(t,\'[role~="combobox"]\'))return!1;var a=t.attr("id");if(a){var n=Wr(e);if(Array.from(n.querySelectorAll(\'[aria-owns~="\'.concat(a,\'"], [aria-controls~="\').concat(a,\'"]\'))).some(function(e){return so(e.getAttribute("role")).includes("combobox")}))return!1}}return!!no(t,"*").some(function(e){return Aa(e,!0,!0)})},"skip-link-matches":function(e){return Qa(e)&&ra(e)},"svg-namespace-matches":Gu,"window-is-top-matches":function(e){return e.ownerDocument.defaultView.self===e.ownerDocument.defaultView.top},"xml-lang-mismatch-matches":function(e){var t=cn(e.getAttribute("lang")),r=cn(e.getAttribute("xml:lang"));return mo(t)&&mo(r)}};var Xu=function(e){this.id=e.id,this.data=null,this.relatedNodes=[],this.result=null};function Ju(e){if("string"!=typeof e)return e;if(Ku[e])return Ku[e];if(/^\\s*function[\\s\\w]*\\(/.test(e))return new Function("return "+e+";")();throw new ReferenceError("Function ID does not exist in the metadata-function-map: ".concat(e))}function Qu(e){var t=0<arguments.length&&void 0!==e?e:{};return!Array.isArray(t)&&"object"===Gs(t)||(t={value:t}),t}function Zu(e){e&&(this.id=e.id,this.configure(e))}Zu.prototype.enabled=!0,Zu.prototype.run=function(t,e,r,a,n){var o=(e=e||{}).hasOwnProperty("enabled")?e.enabled:this.enabled,i=this.getOptions(e.options);if(o){var l,u=new Xu(this),s=Vt(u,e,a,n);try{l=this.evaluate.call(s,t.actualNode,i,t,r)}catch(e){return t&&t.actualNode&&(e.errorNode=new Ut(t.actualNode).toJSON()),void n(e)}s.isAsync||(u.result=l,a(u))}else a(null)},Zu.prototype.runSync=function(t,e,r){var a=(e=e||{}).enabled;if(!(void 0===a?this.enabled:a))return null;var n,o=this.getOptions(e.options),i=new Xu(this),l=Vt(i,e);l.async=function(){throw new Error("Cannot run async check while in a synchronous run")};try{n=this.evaluate.call(l,t.actualNode,o,t,r)}catch(e){throw t&&t.actualNode&&(e.errorNode=new Ut(t.actualNode).toJSON()),e}return i.result=n,i},Zu.prototype.configure=function(t){var r=this;t.evaluate&&!Ku[t.evaluate]||(this._internalCheck=!0),t.hasOwnProperty("enabled")&&(this.enabled=t.enabled),t.hasOwnProperty("options")&&(this._internalCheck?this.options=Qu(t.options):this.options=t.options),["evaluate","after"].filter(function(e){return t.hasOwnProperty(e)}).forEach(function(e){return r[e]=Ju(t[e])})},Zu.prototype.getOptions=function(e){return this._internalCheck?Ur(this.options,Qu(e||{})):e||this.options};var es=Zu;var ts=function(e){this.id=e.id,this.result=Je.NA,this.pageLevel=e.pageLevel,this.impact=null,this.nodes=[]};function rs(e,t){this._audit=t,this.id=e.id,this.selector=e.selector||"*",e.impact&&(ht(Je.impact.includes(e.impact),"Impact ".concat(e.impact," is not a valid impact")),this.impact=e.impact),this.excludeHidden="boolean"!=typeof e.excludeHidden||e.excludeHidden,this.enabled="boolean"!=typeof e.enabled||e.enabled,this.pageLevel="boolean"==typeof e.pageLevel&&e.pageLevel,this.reviewOnFail="boolean"==typeof e.reviewOnFail&&e.reviewOnFail,this.any=e.any||[],this.all=e.all||[],this.none=e.none||[],this.tags=e.tags||[],this.preload=!!e.preload,e.matches&&(this.matches=Ju(e.matches))}function as(e){if(e.length){var r=!1,a={};return e.forEach(function(e){var t=e.results.filter(function(e){return e});(a[e.type]=t).length&&(r=!0)}),r?a:null}}function ns(e){var a=["any","all","none"],t=e.nodes.filter(function(t){var r=0;return a.forEach(function(e){t[e]=t[e].filter(function(e){return!0!==e.filtered}),r+=t[e].length}),0<r});return e.pageLevel&&t.length&&(t=[t.reduce(function(t,r){if(t)return a.forEach(function(e){t[e].push.apply(t[e],r[e])}),t})]),t}rs.prototype.matches=function(){return!0},rs.prototype.gather=function(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},r="mark_gather_start_"+this.id,a="mark_gather_end_"+this.id,n="mark_isHidden_start_"+this.id,o="mark_isHidden_end_"+this.id;t.performanceTimer&&Vn.mark(r);var i=lo(this.selector,e);return this.excludeHidden&&(t.performanceTimer&&Vn.mark(n),i=i.filter(function(e){return!kn(e.actualNode)}),t.performanceTimer&&(Vn.mark(o),Vn.measure("rule_"+this.id+"#gather_axe.utils.isHidden",n,o))),t.performanceTimer&&(Vn.mark(a),Vn.measure("rule_"+this.id+"#gather",r,a)),i},rs.prototype.runChecks=function(t,n,o,i,r,e){var l=this,u=lr();this[t].forEach(function(e){var r=l._audit.checks[e.id||e],a=Dn(r,l.id,o);u.defer(function(e,t){r.run(n,a,i,e,t)})}),u.then(function(e){e=e.filter(function(e){return e}),r({type:t,results:e})}).catch(e)},rs.prototype.runChecksSync=function(e,a,n,o){var i=this,l=[];return this[e].forEach(function(e){var t=i._audit.checks[e.id||e],r=Dn(t,i.id,n);l.push(t.runSync(a,r,o))}),{type:e,results:l=l.filter(function(e){return e})}},rs.prototype.run=function(n){var o=this,i=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},e=2<arguments.length?arguments[2]:void 0,t=3<arguments.length?arguments[3]:void 0;i.performanceTimer&&this._trackPerformance();var r,l=lr(),u=new ts(this);try{r=this.gatherAndMatchNodes(n,i)}catch(e){return void t(new Ys({cause:e,ruleId:this.id}))}i.performanceTimer&&this._logGatherPerformance(r),r.forEach(function(a){l.defer(function(r,t){var e=lr();["any","all","none"].forEach(function(r){e.defer(function(e,t){o.runChecks(r,a,i,n,e,t)})}),e.then(function(e){var t=as(e);t&&(t.node=new Ut(a.actualNode,i),u.nodes.push(t),o.reviewOnFail&&(["any","all"].forEach(function(e){t[e].forEach(function(e){!1===e.result&&(e.result=void 0)})}),t.none.forEach(function(e){!0===e.result&&(e.result=void 0)}))),r()}).catch(function(e){return t(e)})})}),l.defer(function(e){return setTimeout(e,0)}),i.performanceTimer&&this._logRulePerformance(),l.then(function(){return e(u)}).catch(function(e){return t(e)})},rs.prototype.runSync=function(n){var o=this,i=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{};i.performanceTimer&&this._trackPerformance();var e,l=new ts(this);try{e=this.gatherAndMatchNodes(n,i)}catch(e){throw new Ys({cause:e,ruleId:this.id})}return i.performanceTimer&&this._logGatherPerformance(e),e.forEach(function(t){var r=[];["any","all","none"].forEach(function(e){r.push(o.runChecksSync(e,t,i,n))});var a=as(r);a&&(a.node=t.actualNode?new Ut(t.actualNode,i):null,l.nodes.push(a),o.reviewOnFail&&(["any","all"].forEach(function(e){a[e].forEach(function(e){!1===e.result&&(e.result=void 0)})}),a.none.forEach(function(e){!0===e.result&&(e.result=void 0)})))}),i.performanceTimer&&this._logRulePerformance(),l},rs.prototype._trackPerformance=function(){this._markStart="mark_rule_start_"+this.id,this._markEnd="mark_rule_end_"+this.id,this._markChecksStart="mark_runchecks_start_"+this.id,this._markChecksEnd="mark_runchecks_end_"+this.id},rs.prototype._logGatherPerformance=function(e){Qe("gather (",e.length,"):",Vn.timeElapsed()+"ms"),Vn.mark(this._markChecksStart)},rs.prototype._logRulePerformance=function(){Vn.mark(this._markChecksEnd),Vn.mark(this._markEnd),Vn.measure("runchecks_"+this.id,this._markChecksStart,this._markChecksEnd),Vn.measure("rule_"+this.id,this._markStart,this._markEnd)},rs.prototype.gatherAndMatchNodes=function(t,e){var r=this,a="mark_matches_start_"+this.id,n="mark_matches_end_"+this.id,o=this.gather(t,e);return e.performanceTimer&&Vn.mark(a),o=o.filter(function(e){return r.matches(e.actualNode,e,t)}),e.performanceTimer&&(Vn.mark(n),Vn.measure("rule_"+this.id+"#matches",a,n)),o},rs.prototype.after=function(l,u){var r,e=Ir(r=this).map(function(e){var t=r._audit.checks[e.id||e];return t&&"function"==typeof t.after?t:null}).filter(Boolean),s=this.id;return e.forEach(function(e){var t,r,a,n=(t=l.nodes,r=e.id,a=[],t.forEach(function(t){Ir(t).forEach(function(e){e.id===r&&(e.node=t.node,a.push(e))})}),a),o=Dn(e,s,u),i=e.after(n,o);n.forEach(function(e){delete e.node,-1===i.indexOf(e)&&(e.filtered=!0)})}),l.nodes=ns(l),l},rs.prototype.configure=function(e){e.hasOwnProperty("selector")&&(this.selector=e.selector),e.hasOwnProperty("excludeHidden")&&(this.excludeHidden="boolean"!=typeof e.excludeHidden||e.excludeHidden),e.hasOwnProperty("enabled")&&(this.enabled="boolean"!=typeof e.enabled||e.enabled),e.hasOwnProperty("pageLevel")&&(this.pageLevel="boolean"==typeof e.pageLevel&&e.pageLevel),e.hasOwnProperty("reviewOnFail")&&(this.reviewOnFail="boolean"==typeof e.reviewOnFail&&e.reviewOnFail),e.hasOwnProperty("any")&&(this.any=e.any),e.hasOwnProperty("all")&&(this.all=e.all),e.hasOwnProperty("none")&&(this.none=e.none),e.hasOwnProperty("tags")&&(this.tags=e.tags),e.hasOwnProperty("matches")&&(this.matches=Ju(e.matches)),e.impact&&(ht(Je.impact.includes(e.impact),"Impact ".concat(e.impact," is not a valid impact")),this.impact=e.impact)};var os=rs,is=a(We()),ls=/\\{\\{.+?\\}\\}/g;function us(e,t,r){for(var a=0,n=e.length;a<n;a++)t[r](e[a])}function ss(e){rc(this,ss),this.lang="en",this.defaultConfig=e,this.standards=Ga,this._init(),this._defaultLocale=null}function cs(n,e,o){return o.performanceTimer&&Vn.mark("mark_rule_start_"+n.id),function(r,a){n.run(e,o,function(e){r(e)},function(e){var t;o.debug?a(e):(t=Object.assign(new ts(n),{result:Je.CANTTELL,description:"An error occured while running this rule",message:e.message,stack:e.stack,error:e,errorNode:e.errorNode}),r(t))})}}function ds(e,t,r){var a=e.brand,n=e.application,o=e.lang;return Je.helpUrlBase+a+"/"+(r||axe.version.substring(0,axe.version.lastIndexOf(".")))+"/"+t+"?application="+encodeURIComponent(n)+(o&&"en"!==o?"&lang="+encodeURIComponent(o):"")}var ps=(ac(ss,[{key:"_setDefaultLocale",value:function(){if(!this._defaultLocale){for(var e={checks:{},rules:{},failureSummaries:{},incompleteFallbackMessage:"",lang:this.lang},t=Object.keys(this.data.checks),r=0;r<t.length;r++){var a=t[r],n=this.data.checks[a].messages,o=n.pass,i=n.fail,l=n.incomplete;e.checks[a]={pass:o,fail:i,incomplete:l}}for(var u=Object.keys(this.data.rules),s=0;s<u.length;s++){var c=u[s],d=this.data.rules[c],p=d.description,f=d.help;e.rules[c]={description:p,help:f}}for(var m=Object.keys(this.data.failureSummaries),h=0;h<m.length;h++){var g=m[h],v=this.data.failureSummaries[g].failureMessage;e.failureSummaries[g]={failureMessage:v}}e.incompleteFallbackMessage=this.data.incompleteFallbackMessage,this._defaultLocale=e}}},{key:"_resetLocale",value:function(){var e=this._defaultLocale;e&&this.applyLocale(e)}},{key:"_applyCheckLocale",value:function(e){for(var t,r,a,n,o=Object.keys(e),i=0;i<o.length;i++){var l=o[i];if(!this.data.checks[l])throw new Error(\'Locale provided for unknown check: "\'.concat(l,\'"\'));this.data.checks[l]=(t=this.data.checks[l],r=e[l],n=a=void 0,a=r.pass,n=r.fail,"string"==typeof a&&ls.test(a)&&(a=is.default.compile(a)),"string"==typeof n&&ls.test(n)&&(n=is.default.compile(n)),ec({},t,{messages:{pass:a||t.messages.pass,fail:n||t.messages.fail,incomplete:"object"===Gs(t.messages.incomplete)?ec({},t.messages.incomplete,r.incomplete):r.incomplete}}))}}},{key:"_applyRuleLocale",value:function(e){for(var t,r,a,n,o=Object.keys(e),i=0;i<o.length;i++){var l=o[i];if(!this.data.rules[l])throw new Error(\'Locale provided for unknown rule: "\'.concat(l,\'"\'));this.data.rules[l]=(t=this.data.rules[l],r=e[l],n=a=void 0,a=r.help,n=r.description,"string"==typeof a&&ls.test(a)&&(a=is.default.compile(a)),"string"==typeof n&&ls.test(n)&&(n=is.default.compile(n)),ec({},t,{help:a||t.help,description:n||t.description}))}}},{key:"_applyFailureSummaries",value:function(e){for(var t,r,a,n=Object.keys(e),o=0;o<n.length;o++){var i=n[o];if(!this.data.failureSummaries[i])throw new Error(\'Locale provided for unknown failureMessage: "\'.concat(i,\'"\'));this.data.failureSummaries[i]=(t=this.data.failureSummaries[i],r=e[i],a=void 0,"string"==typeof(a=r.failureMessage)&&ls.test(a)&&(a=is.default.compile(a)),ec({},t,{failureMessage:a||t.failureMessage}))}}},{key:"applyLocale",value:function(e){var t,r;this._setDefaultLocale(),e.checks&&this._applyCheckLocale(e.checks),e.rules&&this._applyRuleLocale(e.rules),e.failureSummaries&&this._applyFailureSummaries(e.failureSummaries,"failureSummaries"),e.incompleteFallbackMessage&&(this.data.incompleteFallbackMessage=(t=this.data.incompleteFallbackMessage,"string"==typeof(r=e.incompleteFallbackMessage)&&ls.test(r)&&(r=is.default.compile(r)),r||t)),e.lang&&(this.lang=e.lang)}},{key:"_init",value:function(){var e,t,r=((e=this.defaultConfig)?(t=Ht(e)).commons=e.commons:t={},t.reporter=t.reporter||null,t.rules=t.rules||[],t.checks=t.checks||[],t.data=ec({checks:{},rules:{}},t.data),t);this.lang=r.lang||"en",this.reporter=r.reporter,this.commands={},this.rules=[],this.checks={},this.brand="axe",this.application="axeAPI",this.tagExclude=["experimental"],us(r.rules,this,"addRule"),us(r.checks,this,"addCheck"),this.data={},this.data.checks=r.data&&r.data.checks||{},this.data.rules=r.data&&r.data.rules||{},this.data.failureSummaries=r.data&&r.data.failureSummaries||{},this.data.incompleteFallbackMessage=r.data&&r.data.incompleteFallbackMessage||"",this._constructHelpUrls()}},{key:"registerCommand",value:function(e){this.commands[e.id]=e.callback}},{key:"addRule",value:function(e){e.metadata&&(this.data.rules[e.id]=e.metadata);var t=this.getRule(e.id);t?t.configure(e):this.rules.push(new os(e,this))}},{key:"addCheck",value:function(e){var t=e.metadata;"object"===Gs(t)&&(this.data.checks[e.id]=t,"object"===Gs(t.messages)&&Object.keys(t.messages).filter(function(e){return t.messages.hasOwnProperty(e)&&"string"==typeof t.messages[e]}).forEach(function(e){0===t.messages[e].indexOf("function")&&(t.messages[e]=new Function("return "+t.messages[e]+";")())})),this.checks[e.id]?this.checks[e.id].configure(e):this.checks[e.id]=new es(e)}},{key:"run",value:function(o,i,l,u){this.normalizeOptions(i),axe._selectCache=[];var e,r,a,t=(e=this.rules,r=o,a=i,e.reduce(function(e,t){return io(t,r,a)&&(t.preload?e.later.push(t):e.now.push(t)),e},{now:[],later:[]})),n=t.now,s=t.later,c=lr();n.forEach(function(e){c.defer(cs(e,o,i))});var d=lr();s.length&&d.defer(function(t){to(i).then(function(e){return t(e)}).catch(function(e){console.warn("Couldn\'t load preload assets: ",e),t(void 0)})});var p=lr();p.defer(c),p.defer(d),p.then(function(e){var t,r=e.pop();r&&r.length&&(t=r[0])&&(o=ec({},o,t));var a=e[0];if(!s.length)return axe._selectCache=void 0,void l(a.filter(function(e){return!!e}));var n=lr();s.forEach(function(e){var t=cs(e,o,i);n.defer(t)}),n.then(function(e){axe._selectCache=void 0,l(a.concat(e).filter(function(e){return!!e}))}).catch(u)}).catch(u)}},{key:"after",value:function(e,r){var a=this.rules;return e.map(function(e){var t=Lr(a,"id",e.id);if(!t)throw new Error("Result for unknown rule. You may be running mismatch axe-core versions");return t.after(e,r)})}},{key:"getRule",value:function(t){return this.rules.find(function(e){return e.id===t})}},{key:"normalizeOptions",value:function(e){var t=[],r=[];if(this.rules.forEach(function(e){r.push(e.id),e.tags.forEach(function(e){t.includes(e)||t.push(e)})}),"object"===Gs(e.runOnly)){if(Array.isArray(e.runOnly)){var a=e.runOnly.find(function(e){return t.includes(e)}),n=e.runOnly.find(function(e){return r.includes(e)});if(a&&n)throw new Error("runOnly cannot be both rules and tags");e.runOnly=n?{type:"rule",values:e.runOnly}:{type:"tag",values:e.runOnly}}var o=e.runOnly;if(o.value&&!o.values&&(o.values=o.value,delete o.value),!Array.isArray(o.values)||0===o.values.length)throw new Error("runOnly.values must be a non-empty array");if(["rule","rules"].includes(o.type))o.type="rule",o.values.forEach(function(e){if(!r.includes(e))throw new Error("unknown rule `"+e+"` in options.runOnly")});else{if(!["tag","tags",void 0].includes(o.type))throw new Error("Unknown runOnly type \'".concat(o.type,"\'"));o.type="tag";var i=o.values.filter(function(e){return!t.includes(e)});0!==i.length&&Qe("Could not find tags `"+i.join("`, `")+"`")}}return"object"===Gs(e.rules)&&Object.keys(e.rules).forEach(function(e){if(!r.includes(e))throw new Error("unknown rule `"+e+"` in options.rules")}),e}},{key:"setBranding",value:function(e){var t={brand:this.brand,application:this.application};e&&e.hasOwnProperty("brand")&&e.brand&&"string"==typeof e.brand&&(this.brand=e.brand),e&&e.hasOwnProperty("application")&&e.application&&"string"==typeof e.application&&(this.application=e.application),this._constructHelpUrls(t)}},{key:"_constructHelpUrls",value:function(e){var r=this,a=0<arguments.length&&void 0!==e?e:null,n=(axe.version.match(/^[1-9][0-9]*\\.[0-9]+/)||["x.y"])[0];this.rules.forEach(function(e){r.data.rules[e.id]||(r.data.rules[e.id]={});var t=r.data.rules[e.id];("string"!=typeof t.helpUrl||a&&t.helpUrl===ds(a,e.id,n))&&(t.helpUrl=ds(r,e.id,n))})}},{key:"resetRulesAndChecks",value:function(){this._init(),this._resetLocale()}}]),ss);function fs(e,t){for(var r,a,n=[],o=0,i=e[t].length;o<i;o++){if("string"==typeof(r=e[t][o])){a=Array.from(document.querySelectorAll(r)),n=n.concat(a.map(function(e){return wn(e)}));break}!r||!r.length||r instanceof window.Node?r instanceof window.Node&&(r.documentElement instanceof window.Node?n.push(e.flatTree[0]):n.push(wn(r))):1<r.length?function(e,t,r){var a,n;e.frames=e.frames||[];var o=document.querySelectorAll(r.shift());e:for(var i=0,l=o.length;i<l;i++){n=o[i];for(var u=0,s=e.frames.length;u<s;u++)if(e.frames[u].node===n){e.frames[u][t].push(r);break e}a={node:n,include:[],exclude:[]},r&&a[t].push(r),e.frames.push(a)}}(e,t,r):(a=Array.from(document.querySelectorAll(r[0])),n=n.concat(a.map(function(e){return wn(e)})))}return n.filter(function(e){return e})}var ms=function(e){var a=this;this.frames=[],this.initiator=!e||"boolean"!=typeof e.initiator||e.initiator,this.page=!1,e=function(e){if(e&&"object"===Gs(e)||e instanceof window.NodeList){if(e instanceof window.Node)return{include:[e],exclude:[]};if(e.hasOwnProperty("include")||e.hasOwnProperty("exclude"))return{include:e.include&&+e.include.length?e.include:[document],exclude:e.exclude||[]};if(e.length===+e.length)return{include:e,exclude:[]}}return"string"==typeof e?{include:[e],exclude:[]}:{include:[document],exclude:[]}}(e),this.flatTree=sn(function(e){for(var t=e.include,r=e.exclude,a=Array.from(t).concat(Array.from(r)),n=0;n<a.length;++n){var o=a[n];if(o instanceof window.Element)return o.ownerDocument.documentElement;if(o instanceof window.Document)return o.documentElement}return document.documentElement}(e)),this.exclude=e.exclude,this.include=e.include,this.include=fs(this,"include"),this.exclude=fs(this,"exclude"),lo("frame, iframe",this).forEach(function(e){var t,r;_n(e,a)&&(t=a.frames,r=e.actualNode,kn(r)||Lr(t,"node",r)||t.push({node:r,include:[],exclude:[]}))}),1===this.include.length&&this.include[0].actualNode===document.documentElement&&(this.page=!0);var t=function(e){if(0===e.include.length){if(0===e.frames.length){var t=Or.isInFrame()?"frame":"page";return new Error("No elements found for include in "+t+" Context")}e.frames.forEach(function(e,t){if(0===e.include.length)return new Error("No elements found for include in Context of frame "+t)})}}(this);if(t instanceof Error)throw t;Array.isArray(this.include)||(this.include=Array.from(this.include)),this.include.sort(Br)},hs={};t(hs,{CssSelectorParser:function(){return gs.CssSelectorParser},doT:function(){return vs.default},emojiRegexText:function(){return bs.default},memoize:function(){return ys.default}});var gs=a(m()),vs=a(We()),bs=a($e()),ys=a(ze()),Ds=a(Ge()),ws=a(Ye());a(Ke());"Promise"in window||Ds.default.polyfill(),"Uint32Array"in window||(window.Uint32Array=ws.Uint32Array),window.Uint32Array&&("some"in window.Uint32Array.prototype||Object.defineProperty(window.Uint32Array.prototype,"some",{value:Array.prototype.some}),"reduce"in window.Uint32Array.prototype||Object.defineProperty(window.Uint32Array.prototype,"reduce",{value:Array.prototype.reduce}));var xs,Es=function(t,r){if(t=t||function(){},r=r||axe.log,!axe._audit)throw new Error("No audit configured");var a=axe.utils.queue(),n=[];Object.keys(axe.plugins).forEach(function(e){a.defer(function(t){function r(e){n.push(e),t()}try{axe.plugins[e].cleanup(t,r)}catch(e){r(e)}})});var e=axe.utils.getFlattenedTree(document.body);axe.utils.querySelectorAll(e,"iframe, frame").forEach(function(r){a.defer(function(e,t){return axe.utils.sendCommandToFrame(r.actualNode,{command:"cleanup-plugin"},e,t)})}),a.then(function(e){0===n.length?t(e):r(n)}).catch(r)},As={};function Cs(e){return As.hasOwnProperty(e)}function Fs(e){return"string"==typeof e&&As[e]?As[e]:"function"==typeof e?e:xs}function ks(e){var t=axe._audit;if(!t)throw new Error("No audit configured");if(e.axeVersion||e.ver){var r=e.axeVersion||e.ver;if(!/^\\d+\\.\\d+\\.\\d+(-canary)?/.test(r))throw new Error("Invalid configured version ".concat(r));var a=tc(r.split("-"),2),n=a[0],o=a[1],i=tc(n.split(".").map(Number),3),l=i[0],u=i[1],s=i[2],c=tc(axe.version.split("-"),2),d=c[0],p=c[1],f=tc(d.split(".").map(Number),3),m=f[0],h=f[1],g=f[2];if(l!==m||h<u||h===u&&g<s||l===m&&u===h&&s===g&&o&&o!==p)throw new Error("Configured version ".concat(r," is not compatible with current axe version ").concat(axe.version))}if(e.reporter&&("function"==typeof e.reporter||Cs(e.reporter))&&(t.reporter=e.reporter),e.checks){if(!Array.isArray(e.checks))throw new TypeError("Checks property must be an array");e.checks.forEach(function(e){if(!e.id)throw new TypeError("Configured check ".concat(JSON.stringify(e)," is invalid. Checks must be an object with at least an id property"));t.addCheck(e)})}var v,b=[];if(e.rules){if(!Array.isArray(e.rules))throw new TypeError("Rules property must be an array");e.rules.forEach(function(e){if(!e.id)throw new TypeError("Configured rule ".concat(JSON.stringify(e)," is invalid. Rules must be an object with at least an id property"));b.push(e.id),t.addRule(e)})}e.disableOtherRules&&t.rules.forEach(function(e){!1===b.includes(e.id)&&(e.enabled=!1)}),void 0!==e.branding?t.setBranding(e.branding):t._constructHelpUrls(),e.tagExclude&&(t.tagExclude=e.tagExclude),e.locale&&t.applyLocale(e.locale),e.standards&&(v=e.standards,Object.keys(Wa).forEach(function(e){v[e]&&(Wa[e]=Ur(Wa[e],v[e]))}))}function Rs(e){var t=(e=e||[]).length?axe._audit.rules.filter(function(t){return!!e.filter(function(e){return-1!==t.tags.indexOf(e)}).length}):axe._audit.rules,r=axe._audit.data.rules||{};return t.map(function(e){var t=r[e.id]||{};return{ruleId:e.id,description:t.description,help:t.help,helpUrl:t.helpUrl,tags:e.tags}})}function Ts(){xr.get("globalDocumentSet")&&(document=null),xr.get("globalWindowSet")&&(window=null),axe._memoizedFns.forEach(function(e){return e.clear()}),xr.clear(),axe._tree=void 0,axe._selectorData=void 0}var Ns=function(r,a,n,o){try{r=new ms(r),axe._tree=r.flatTree,axe._selectorData=Ot(r.flatTree)}catch(e){return Ts(),o(e)}var e=lr(),i=axe._audit;a.performanceTimer&&Vn.auditStart(),r.frames.length&&!1!==a.iframes&&e.defer(function(e,t){jr(r,a,"rules",null,e,t)}),e.defer(function(e,t){i.run(r,a,e,t)}),e.then(function(e){try{a.performanceTimer&&Vn.auditEnd();var t=qr(e.map(function(e){return{results:e}}));r.initiator&&((t=i.after(t,a)).forEach(ao),t=t.map(ct));try{n(t,Ts)}catch(e){Ts(),Qe(e)}}catch(e){Ts(),o(e)}}).catch(function(e){Ts(),o(e)})};function _s(e,t,r){function a(e){e instanceof Error==!1&&(e=new Error(e)),r(e)}var n=r,o=e&&e.context||{};o.hasOwnProperty("include")&&!o.include.length&&(o.include=[document]);var i=e&&e.options||{};switch(e.command){case"rules":return Ns(o,i,function(e,t){n(e),t()},a);case"cleanup-plugin":return Es(n,a);default:if(axe._audit&&axe._audit.commands&&axe._audit.commands[e.command])return axe._audit.commands[e.command](e,r)}}function Os(e){axe.utils.respondable.subscribe("axe.ping",function(e,t,r){r({axe:!0})}),axe.utils.respondable.subscribe("axe.start",_s),axe._audit=new ps(e)}function Ss(e){this._run=e.run,this._collect=e.collect,this._registry={},e.commands.forEach(function(e){axe._audit.registerCommand(e)})}Ss.prototype.run=function(){return this._run.apply(this,arguments)},Ss.prototype.collect=function(){return this._collect.apply(this,arguments)},Ss.prototype.cleanup=function(e){var r=axe.utils.queue(),a=this;Object.keys(this._registry).forEach(function(t){r.defer(function(e){a._registry[t].cleanup(e)})}),r.then(function(){e()})},Ss.prototype.add=function(e){this._registry[e.id]=e};function Ps(e){axe.plugins[e.id]=new Ss(e)}function Is(){var e=axe._audit;if(!e)throw new Error("No audit configured");e.resetRulesAndChecks(),Object.keys(Wa).forEach(function(e){Wa[e]=$a[e]})}function Bs(t,e){var r=2<arguments.length&&void 0!==arguments[2]?arguments[2]:{};r.reporter=r.reporter||axe._audit.reporter||"v1",axe._selectorData={},e instanceof tt||(e=new ho(e));var a=axe._audit.rules.find(function(e){return e.id===t});if(!a)throw new Error("unknown rule `"+t+"`");var n={include:[e]},o=(a=Object.create(a,{excludeHidden:{value:!1}})).runSync(n,r);ao(o),ct(o);var i=ft([o]);return i.violations.forEach(function(e){return e.nodes.forEach(function(e){e.failureSummary=dn(e)})}),ec({},pn(),i,{toolOptions:r})}var Ls=function(){};function qs(e,t,r){var a=new TypeError("axe.run arguments are invalid");if(!function(e){switch(!0){case"string"==typeof e:case Array.isArray(e):case window.Node&&e instanceof window.Node:case window.NodeList&&e instanceof window.NodeList:return 1;case"object"!==Gs(e):return;case void 0!==e.include:case void 0!==e.exclude:case"number"==typeof e.length:return 1;default:return}}(e)){if(void 0!==r)throw a;r=t,t=e,e=document}if("object"!==Gs(t)){if(void 0!==r)throw a;r=t,t={}}if("function"!=typeof r&&void 0!==r)throw a;return{context:e,options:t,callback:r||Ls}}function js(e,n,o){if(!axe._audit)throw new Error("No audit configured");var t=window&&"Node"in window&&"NodeList"in window,r=!!document;if(!t||!r){if(!e||!e.ownerDocument)throw new Error(\'Required "window" or "document" globals not defined and cannot be deduced from the context. Either set the globals before running or pass in a valid Element.\');r||(xr.set("globalDocumentSet",!0),document=e.ownerDocument),t||(xr.set("globalWindowSet",!0),window=document.defaultView)}var a,i=qs(e,n,o);e=i.context,n=i.options,o=i.callback,n.reporter=n.reporter||axe._audit.reporter||"v1",n.performanceTimer&&axe.utils.performanceTimer.start();var l=Ls,u=Ls;if("function"==typeof Promise&&o===Ls&&(a=new Promise(function(e,t){l=t,u=e})),axe._running){var s="Axe is already running. Use `await axe.run()` to wait for the previous run to finish before starting a new run.";return o(s),l(s),a}return axe._running=!0,axe._runRules(e,n,function(e,t){function r(e){axe._running=!1,t();try{o(null,e)}catch(e){axe.log(e)}u(e)}n.performanceTimer&&axe.utils.performanceTimer.end();try{var a=Fs(n.reporter)(e,n,r);void 0!==a&&r(a)}catch(e){axe._running=!1,t(),o(e),l(e)}},function(e){axe._running=!1,o(e),l(e)}),a}function Ms(e,t,r){console.warn(\'"na" reporter will be deprecated in axe v4.0. Use the "v2" reporter instead.\'),"function"==typeof t&&(r=t,t={});var a=hn(e,t);r(ec({},pn(),{toolOptions:t,violations:a.violations,passes:a.passes,incomplete:a.incomplete,inapplicable:a.inapplicable}))}function Us(e,t,r){"function"==typeof t&&(r=t,t={}),t.resultTypes=["violations"];var a=hn(e,t);r(ec({},pn(),{toolOptions:t,violations:a.violations}))}function Vs(e,t,r){"function"==typeof t&&(r=t,t={}),$s(e,t,function(e){var t=pn();r({raw:e,env:t})})}function Hs(e,t,r){function a(e){e.nodes.forEach(function(e){e.failureSummary=dn(e)})}"function"==typeof t&&(r=t,t={});var n=hn(e,t);n.incomplete.forEach(a),n.violations.forEach(a),r(ec({},pn(),{toolOptions:t,violations:n.violations,passes:n.passes,incomplete:n.incomplete,inapplicable:n.inapplicable}))}function zs(e,t,r){"function"==typeof t&&(r=t,t={});var a=hn(e,t);r(ec({},pn(),{toolOptions:t,violations:a.violations,passes:a.passes,incomplete:a.incomplete,inapplicable:a.inapplicable}))}var $s=function(e,t,r){if("function"==typeof t&&(r=t,t={}),!e||!Array.isArray(e))return r(e);r(e.map(function(e){for(var t=ec({},e),r=0,a=["passes","violations","incomplete","inapplicable"];r<a.length;r++){var n=a[r];t[n]&&Array.isArray(t[n])&&(t[n]=t[n].map(function(e){return ec({},e,{node:e.node.toJSON()})}))}return t}))};axe.constants=Je,axe.log=Qe,axe.AbstractVirtualNode=tt,axe.SerialVirtualNode=ho,axe.VirtualNode=ln,axe._cache=xr,axe._thisWillBeDeletedDoNotUse=axe._thisWillBeDeletedDoNotUse||{},axe._thisWillBeDeletedDoNotUse.base={Audit:ps,CheckResult:Xu,Check:es,Context:ms,RuleResult:ts,Rule:os,metadataFunctionMap:Ku},axe.imports=hs,axe.cleanup=Es,axe.configure=ks,axe.getRules=Rs,axe._load=Os,axe.plugins={},axe.registerPlugin=Ps,axe.hasReporter=Cs,axe.getReporter=Fs,axe.addReporter=function(e,t,r){As[e]=t,r&&(xs=t)},axe.reset=Is,axe._runRules=Ns,axe.runVirtualRule=Bs,axe.run=js,axe.commons=Nu,axe.utils=rt,axe.addReporter("na",Ms),axe.addReporter("no-passes",Us),axe.addReporter("rawEnv",Vs),axe.addReporter("raw",$s),axe.addReporter("v1",Hs),axe.addReporter("v2",zs,!0)}(),axe._load({lang:"en",data:{rules:{accesskeys:{description:"Ensures every accesskey attribute value is unique",help:"accesskey attribute value must be unique"},"area-alt":{description:"Ensures <area> elements of image maps have alternate text",help:"Active <area> elements must have alternate text"},"aria-allowed-attr":{description:"Ensures ARIA attributes are allowed for an element\'s role",help:"Elements must only use allowed ARIA attributes"},"aria-allowed-role":{description:"Ensures role attribute has an appropriate value for the element",help:"ARIA role must be appropriate for the element"},"aria-command-name":{description:"Ensures every ARIA button, link and menuitem has an accessible name",help:"ARIA commands must have an accessible name"},"aria-dialog-name":{description:"Ensures every ARIA dialog and alertdialog node has an accessible name",help:"ARIA dialog and alertdialog nodes must have an accessible name"},"aria-hidden-body":{description:"Ensures aria-hidden=\'true\' is not present on the document body.",help:"aria-hidden=\'true\' must not be present on the document body"},"aria-hidden-focus":{description:"Ensures aria-hidden elements do not contain focusable elements",help:"ARIA hidden element must not contain focusable elements"},"aria-input-field-name":{description:"Ensures every ARIA input field has an accessible name",help:"ARIA input fields must have an accessible name"},"aria-meter-name":{description:"Ensures every ARIA meter node has an accessible name",help:"ARIA meter nodes must have an accessible name"},"aria-progressbar-name":{description:"Ensures every ARIA progressbar node has an accessible name",help:"ARIA progressbar nodes must have an accessible name"},"aria-required-attr":{description:"Ensures elements with ARIA roles have all required ARIA attributes",help:"Required ARIA attributes must be provided"},"aria-required-children":{description:"Ensures elements with an ARIA role that require child roles contain them",help:"Certain ARIA roles must contain particular children"},"aria-required-parent":{description:"Ensures elements with an ARIA role that require parent roles are contained by them",help:"Certain ARIA roles must be contained by particular parents"},"aria-roledescription":{description:"Ensure aria-roledescription is only used on elements with an implicit or explicit role",help:"Use aria-roledescription on elements with a semantic role"},"aria-roles":{description:"Ensures all elements with a role attribute use a valid value",help:"ARIA roles used must conform to valid values"},"aria-toggle-field-name":{description:"Ensures every ARIA toggle field has an accessible name",help:"ARIA toggle fields have an accessible name"},"aria-tooltip-name":{description:"Ensures every ARIA tooltip node has an accessible name",help:"ARIA tooltip nodes must have an accessible name"},"aria-treeitem-name":{description:"Ensures every ARIA treeitem node has an accessible name",help:"ARIA treeitem nodes must have an accessible name"},"aria-valid-attr-value":{description:"Ensures all ARIA attributes have valid values",help:"ARIA attributes must conform to valid values"},"aria-valid-attr":{description:"Ensures attributes that begin with aria- are valid ARIA attributes",help:"ARIA attributes must conform to valid names"},"audio-caption":{description:"Ensures <audio> elements have captions",help:"<audio> elements must have a captions track"},"autocomplete-valid":{description:"Ensure the autocomplete attribute is correct and suitable for the form field",help:"autocomplete attribute must be used correctly"},"avoid-inline-spacing":{description:"Ensure that text spacing set through style attributes can be adjusted with custom stylesheets",help:"Inline text spacing must be adjustable with custom stylesheets"},blink:{description:"Ensures <blink> elements are not used",help:"<blink> elements are deprecated and must not be used"},"button-name":{description:"Ensures buttons have discernible text",help:"Buttons must have discernible text"},bypass:{description:"Ensures each page has at least one mechanism for a user to bypass navigation and jump straight to the content",help:"Page must have means to bypass repeated blocks"},"color-contrast":{description:"Ensures the contrast between foreground and background colors meets WCAG 2 AA contrast ratio thresholds",help:"Elements must have sufficient color contrast"},"css-orientation-lock":{description:"Ensures content is not locked to any specific display orientation, and the content is operable in all display orientations",help:"CSS Media queries are not used to lock display orientation"},"definition-list":{description:"Ensures <dl> elements are structured correctly",help:"<dl> elements must only directly contain properly-ordered <dt> and <dd> groups, <script>, <template> or <div> elements"},dlitem:{description:"Ensures <dt> and <dd> elements are contained by a <dl>",help:"<dt> and <dd> elements must be contained by a <dl>"},"document-title":{description:"Ensures each HTML document contains a non-empty <title> element",help:"Documents must have <title> element to aid in navigation"},"duplicate-id-active":{description:"Ensures every id attribute value of active elements is unique",help:"IDs of active elements must be unique"},"duplicate-id-aria":{description:"Ensures every id attribute value used in ARIA and in labels is unique",help:"IDs used in ARIA and labels must be unique"},"duplicate-id":{description:"Ensures every id attribute value is unique",help:"id attribute value must be unique"},"empty-heading":{description:"Ensures headings have discernible text",help:"Headings must not be empty"},"focus-order-semantics":{description:"Ensures elements in the focus order have an appropriate role",help:"Elements in the focus order need a role appropriate for interactive content"},"form-field-multiple-labels":{description:"Ensures form field does not have multiple label elements",help:"Form field should not have multiple label elements"},"frame-tested":{description:"Ensures <iframe> and <frame> elements contain the axe-core script",help:"Frames must be tested with axe-core"},"frame-title-unique":{description:"Ensures <iframe> and <frame> elements contain a unique title attribute",help:"Frames must have a unique title attribute"},"frame-title":{description:"Ensures <iframe> and <frame> elements contain a non-empty title attribute",help:"Frames must have title attribute"},"heading-order":{description:"Ensures the order of headings is semantically correct",help:"Heading levels should only increase by one"},"hidden-content":{description:"Informs users about hidden content.",help:"Hidden content on the page cannot be analyzed"},"html-has-lang":{description:"Ensures every HTML document has a lang attribute",help:"<html> element must have a lang attribute"},"html-lang-valid":{description:"Ensures the lang attribute of the <html> element has a valid value",help:"<html> element must have a valid value for the lang attribute"},"html-xml-lang-mismatch":{description:"Ensure that HTML elements with both valid lang and xml:lang attributes agree on the base language of the page",help:"HTML elements with lang and xml:lang must have the same base language"},"identical-links-same-purpose":{description:"Ensure that links with the same accessible name serve a similar purpose",help:"Links with the same name have a similar purpose"},"image-alt":{description:"Ensures <img> elements have alternate text or a role of none or presentation",help:"Images must have alternate text"},"image-redundant-alt":{description:"Ensure image alternative is not repeated as text",help:"Alternative text of images should not be repeated as text"},"input-button-name":{description:"Ensures input buttons have discernible text",help:"Input buttons must have discernible text"},"input-image-alt":{description:\'Ensures <input type="image"> elements have alternate text\',help:"Image buttons must have alternate text"},"label-content-name-mismatch":{description:"Ensures that elements labelled through their content must have their visible text as part of their accessible name",help:"Elements must have their visible text as part of their accessible name"},"label-title-only":{description:"Ensures that every form element is not solely labeled using the title or aria-describedby attributes",help:"Form elements should have a visible label"},label:{description:"Ensures every form element has a label",help:"Form elements must have labels"},"landmark-banner-is-top-level":{description:"Ensures the banner landmark is at top level",help:"Banner landmark must not be contained in another landmark"},"landmark-complementary-is-top-level":{description:"Ensures the complementary landmark or aside is at top level",help:"Aside must not be contained in another landmark"},"landmark-contentinfo-is-top-level":{description:"Ensures the contentinfo landmark is at top level",help:"Contentinfo landmark must not be contained in another landmark"},"landmark-main-is-top-level":{description:"Ensures the main landmark is at top level",help:"Main landmark must not be contained in another landmark"},"landmark-no-duplicate-banner":{description:"Ensures the document has at most one banner landmark",help:"Document must not have more than one banner landmark"},"landmark-no-duplicate-contentinfo":{description:"Ensures the document has at most one contentinfo landmark",help:"Document must not have more than one contentinfo landmark"},"landmark-no-duplicate-main":{description:"Ensures the document has at most one main landmark",help:"Document must not have more than one main landmark"},"landmark-one-main":{description:"Ensures the document has a main landmark",help:"Document must have one main landmark"},"landmark-unique":{help:"Ensures landmarks are unique",description:"Landmarks must have a unique role or role/label/title (i.e. accessible name) combination"},"link-in-text-block":{description:"Links can be distinguished without relying on color",help:"Links must be distinguished from surrounding text in a way that does not rely on color"},"link-name":{description:"Ensures links have discernible text",help:"Links must have discernible text"},list:{description:"Ensures that lists are structured correctly",help:"<ul> and <ol> must only directly contain <li>, <script> or <template> elements"},listitem:{description:"Ensures <li> elements are used semantically",help:"<li> elements must be contained in a <ul> or <ol>"},marquee:{description:"Ensures <marquee> elements are not used",help:"<marquee> elements are deprecated and must not be used"},"meta-refresh":{description:\'Ensures <meta http-equiv="refresh"> is not used\',help:"Timed refresh must not exist"},"meta-viewport-large":{description:\'Ensures <meta name="viewport"> can scale a significant amount\',help:"Users should be able to zoom and scale the text up to 500%"},"meta-viewport":{description:\'Ensures <meta name="viewport"> does not disable text scaling and zooming\',help:"Zooming and scaling must not be disabled"},"no-autoplay-audio":{description:"Ensures <video> or <audio> elements do not autoplay audio for more than 3 seconds without a control mechanism to stop or mute the audio",help:"<video> or <audio> elements do not autoplay audio"},"object-alt":{description:"Ensures <object> elements have alternate text",help:"<object> elements must have alternate text"},"p-as-heading":{description:"Ensure p elements are not used to style headings",help:"Bold, italic text and font-size are not used to style p elements as a heading"},"page-has-heading-one":{description:"Ensure that the page, or at least one of its frames contains a level-one heading",help:"Page must contain a level-one heading"},"presentation-role-conflict":{description:"Flags elements whose role is none or presentation and which cause the role conflict resolution to trigger.",help:"Elements of role none or presentation should be flagged"},region:{description:"Ensures all page content is contained by landmarks",help:"All page content must be contained by landmarks"},"role-img-alt":{description:"Ensures [role=\'img\'] elements have alternate text",help:"[role=\'img\'] elements have an alternative text"},"scope-attr-valid":{description:"Ensures the scope attribute is used correctly on tables",help:"scope attribute should be used correctly"},"scrollable-region-focusable":{description:"Elements that have scrollable content should be accessible by keyboard",help:"Ensure that scrollable region has keyboard access"},"select-name":{description:"Ensures select element has an accessible name",help:"Select element must have and accessible name"},"server-side-image-map":{description:"Ensures that server-side image maps are not used",help:"Server-side image maps must not be used"},"skip-link":{description:"Ensure all skip links have a focusable target",help:"The skip-link target should exist and be focusable"},"svg-img-alt":{description:"Ensures svg elements with an img, graphics-document or graphics-symbol role have an accessible text",help:"svg elements with an img role have an alternative text"},tabindex:{description:"Ensures tabindex attribute values are not greater than 0",help:"Elements should not have tabindex greater than zero"},"table-duplicate-name":{description:"Ensure that tables do not have the same summary and caption",help:"The <caption> element should not contain the same text as the summary attribute"},"table-fake-caption":{description:"Ensure that tables with a caption use the <caption> element.",help:"Data or header cells should not be used to give caption to a data table."},"td-has-header":{description:"Ensure that each non-empty data cell in a large table has one or more table headers",help:"All non-empty td element in table larger than 3 by 3 must have an associated table header"},"td-headers-attr":{description:"Ensure that each cell in a table using the headers refers to another cell in that table",help:"All cells in a table element that use the headers attribute must only refer to other cells of that same table"},"th-has-data-cells":{description:"Ensure that each table header in a data table refers to data cells",help:"All th elements and elements with role=columnheader/rowheader must have data cells they describe"},"valid-lang":{description:"Ensures lang attributes have valid values",help:"lang attribute must have a valid value"},"video-caption":{description:"Ensures <video> elements have captions",help:"<video> elements must have captions"}},checks:{abstractrole:{impact:"serious",messages:{pass:"Abstract roles are not used",fail:{singular:"Abstract role cannot be directly used: ${data.values}",plural:"Abstract roles cannot be directly used: ${data.values}"}}},"aria-allowed-attr":{impact:"critical",messages:{pass:"ARIA attributes are used correctly for the defined role",fail:{singular:"ARIA attribute is not allowed: ${data.values}",plural:"ARIA attributes are not allowed: ${data.values}"}}},"aria-allowed-role":{impact:"minor",messages:{pass:"ARIA role is allowed for given element",fail:{singular:"ARIA role ${data.values} is not allowed for given element",plural:"ARIA roles ${data.values} are not allowed for given element"},incomplete:{singular:"ARIA role ${data.values} must be removed when the element is made visible, as it is not allowed for the element",plural:"ARIA roles ${data.values} must be removed when the element is made visible, as they are not allowed for the element"}}},"aria-errormessage":{impact:"critical",messages:{pass:"aria-errormessage exists and references elements visible to screen readers that use a supported aria-errormessage technique",fail:{singular:"aria-errormessage value `${data.values}` must use a technique to announce the message (e.g., aria-live, aria-describedby, role=alert, etc.)",plural:"aria-errormessage values `${data.values}` must use a technique to announce the message (e.g., aria-live, aria-describedby, role=alert, etc.)"},incomplete:{singular:"ensure aria-errormessage value `${data.values}` references an existing element",plural:"ensure aria-errormessage values `${data.values}` reference existing elements"}}},"aria-hidden-body":{impact:"critical",messages:{pass:"No aria-hidden attribute is present on document body",fail:"aria-hidden=true should not be present on the document body"}},"aria-required-attr":{impact:"critical",messages:{pass:"All required ARIA attributes are present",fail:{singular:"Required ARIA attribute not present: ${data.values}",plural:"Required ARIA attributes not present: ${data.values}"}}},"aria-required-children":{impact:"critical",messages:{pass:"Required ARIA children are present",fail:{singular:"Required ARIA child role not present: ${data.values}",plural:"Required ARIA children role not present: ${data.values}"},incomplete:{singular:"Expecting ARIA child role to be added: ${data.values}",plural:"Expecting ARIA children role to be added: ${data.values}"}}},"aria-required-parent":{impact:"critical",messages:{pass:"Required ARIA parent role present",fail:{singular:"Required ARIA parent role not present: ${data.values}",plural:"Required ARIA parents role not present: ${data.values}"}}},"aria-roledescription":{impact:"serious",messages:{pass:"aria-roledescription used on a supported semantic role",incomplete:"Check that the aria-roledescription is announced by supported screen readers",fail:"Give the element a role that supports aria-roledescription"}},"aria-unsupported-attr":{impact:"critical",messages:{pass:"ARIA attribute is supported",fail:"ARIA attribute is not widely supported in screen readers and assistive technologies: ${data.values}"}},"aria-valid-attr-value":{impact:"critical",messages:{pass:"ARIA attribute values are valid",fail:{singular:"Invalid ARIA attribute value: ${data.values}",plural:"Invalid ARIA attribute values: ${data.values}"},incomplete:{noId:"ARIA attribute element ID does not exist on the page: ${data.needsReview}",ariaCurrent:\'ARIA attribute value is invalid and will be treated as "aria-current=true": ${data.needsReview}\'}}},"aria-valid-attr":{impact:"critical",messages:{pass:"ARIA attribute name is valid",fail:{singular:"Invalid ARIA attribute name: ${data.values}",plural:"Invalid ARIA attribute names: ${data.values}"}}},fallbackrole:{impact:"serious",messages:{pass:"Only one role value used",fail:"Use only one role value, since fallback roles are not supported in older browsers"}},"has-global-aria-attribute":{impact:"minor",messages:{pass:{singular:"Element has global ARIA attribute: ${data.values}",plural:"Element has global ARIA attributes: ${data.values}"},fail:"Element does not have global ARIA attribute"}},"has-widget-role":{impact:"minor",messages:{pass:"Element has a widget role.",fail:"Element does not have a widget role."}},invalidrole:{impact:"critical",messages:{pass:"ARIA role is valid",fail:{singular:"Role must be one of the valid ARIA roles: ${data.values}",plural:"Roles must be one of the valid ARIA roles: ${data.values}"}}},"is-element-focusable":{impact:"minor",messages:{pass:"Element is focusable.",fail:"Element is not focusable."}},"no-implicit-explicit-label":{impact:"moderate",messages:{pass:"There is no mismatch between a <label> and accessible name",incomplete:"Check that the <label> does not need be part of the ARIA ${data} field\'s name"}},unsupportedrole:{impact:"critical",messages:{pass:"ARIA role is supported",fail:"The role used is not widely supported in screen readers and assistive technologies: ${data.values}"}},"valid-scrollable-semantics":{impact:"minor",messages:{pass:"Element has valid semantics for an element in the focus order.",fail:"Element has invalid semantics for an element in the focus order."}},"color-contrast":{impact:"serious",messages:{pass:"Element has sufficient color contrast of ${data.contrastRatio}",fail:"Element has insufficient color contrast of ${data.contrastRatio} (foreground color: ${data.fgColor}, background color: ${data.bgColor}, font size: ${data.fontSize}, font weight: ${data.fontWeight}). Expected contrast ratio of ${data.expectedContrastRatio}",incomplete:{default:"Unable to determine contrast ratio",bgImage:"Element\'s background color could not be determined due to a background image",bgGradient:"Element\'s background color could not be determined due to a background gradient",imgNode:"Element\'s background color could not be determined because element contains an image node",bgOverlap:"Element\'s background color could not be determined because it is overlapped by another element",fgAlpha:"Element\'s foreground color could not be determined because of alpha transparency",elmPartiallyObscured:"Element\'s background color could not be determined because it\'s partially obscured by another element",elmPartiallyObscuring:"Element\'s background color could not be determined because it partially overlaps other elements",outsideViewport:"Element\'s background color could not be determined because it\'s outside the viewport",equalRatio:"Element has a 1:1 contrast ratio with the background",shortTextContent:"Element content is too short to determine if it is actual text content",nonBmp:"Element content contains only non-text characters",pseudoContent:"Element\'s background color could not be determined due to a pseudo element"}}},"link-in-text-block":{impact:"serious",messages:{pass:"Links can be distinguished from surrounding text in some way other than by color",fail:"Links need to be distinguished from surrounding text in some way other than by color",incomplete:{default:"Unable to determine contrast ratio",bgContrast:"Element\'s contrast ratio could not be determined. Check for a distinct hover/focus style",bgImage:"Element\'s contrast ratio could not be determined due to a background image",bgGradient:"Element\'s contrast ratio could not be determined due to a background gradient",imgNode:"Element\'s contrast ratio could not be determined because element contains an image node",bgOverlap:"Element\'s contrast ratio could not be determined because of element overlap"}}},"autocomplete-appropriate":{impact:"serious",messages:{pass:"the autocomplete value is on an appropriate element",fail:"the autocomplete value is inappropriate for this type of input"}},"autocomplete-valid":{impact:"serious",messages:{pass:"the autocomplete attribute is correctly formatted",fail:"the autocomplete attribute is incorrectly formatted"}},accesskeys:{impact:"serious",messages:{pass:"Accesskey attribute value is unique",fail:"Document has multiple elements with the same accesskey"}},"focusable-content":{impact:"moderate",messages:{pass:"Element contains focusable elements",fail:"Element should have focusable content"}},"focusable-disabled":{impact:"serious",messages:{pass:"No focusable elements contained within element",fail:"Focusable content should be disabled or be removed from the DOM"}},"focusable-element":{impact:"moderate",messages:{pass:"Element is focusable",fail:"Element should be focusable"}},"focusable-modal-open":{impact:"serious",messages:{pass:"No focusable elements while a modal is open",incomplete:"Check that focusable elements are not tabbable in the current state"}},"focusable-no-name":{impact:"serious",messages:{pass:"Element is not in tab order or has accessible text",fail:"Element is in tab order and does not have accessible text",incomplete:"Unable to determine if element has an accessible name"}},"focusable-not-tabbable":{impact:"serious",messages:{pass:"No focusable elements contained within element",fail:"Focusable content should have tabindex=\'-1\' or be removed from the DOM"}},"landmark-is-top-level":{impact:"moderate",messages:{pass:"The ${data.role} landmark is at the top level.",fail:"The ${data.role} landmark is contained in another landmark."}},"page-has-heading-one":{impact:"moderate",messages:{pass:"Page has at least one level-one heading",fail:"Page must have a level-one heading"}},"page-has-main":{impact:"moderate",messages:{pass:"Document has at least one main landmark",fail:"Document does not have a main landmark"}},"page-no-duplicate-banner":{impact:"moderate",messages:{pass:"Document does not have more than one banner landmark",fail:"Document has more than one banner landmark"}},"page-no-duplicate-contentinfo":{impact:"moderate",messages:{pass:"Document does not have more than one contentinfo landmark",fail:"Document has more than one contentinfo landmark"}},"page-no-duplicate-main":{impact:"moderate",messages:{pass:"Document does not have more than one main landmark",fail:"Document has more than one main landmark"}},tabindex:{impact:"serious",messages:{pass:"Element does not have a tabindex greater than 0",fail:"Element has a tabindex greater than 0"}},"alt-space-value":{impact:"critical",messages:{pass:"Element has a valid alt attribute value",fail:"Element has an alt attribute containing only a space character, which is not ignored by all screen readers"}},"duplicate-img-label":{impact:"minor",messages:{pass:"Element does not duplicate existing text in <img> alt text",fail:"Element contains <img> element with alt text that duplicates existing text"}},"explicit-label":{impact:"critical",messages:{pass:"Form element has an explicit <label>",fail:"Form element does not have an explicit <label>",incomplete:"Unable to determine if form element has an explicit <label>"}},"help-same-as-label":{impact:"minor",messages:{pass:"Help text (title or aria-describedby) does not duplicate label text",fail:"Help text (title or aria-describedby) text is the same as the label text"}},"hidden-explicit-label":{impact:"critical",messages:{pass:"Form element has a visible explicit <label>",fail:"Form element has explicit <label> that is hidden",incomplete:"Unable to determine if form element has explicit <label> that is hidden"}},"implicit-label":{impact:"critical",messages:{pass:"Form element has an implicit (wrapped) <label>",fail:"Form element does not have an implicit (wrapped) <label>",incomplete:"Unable to determine if form element has an implicit (wrapped} <label>"}},"label-content-name-mismatch":{impact:"serious",messages:{pass:"Element contains visible text as part of it\'s accessible name",fail:"Text inside the element is not included in the accessible name"}},"multiple-label":{impact:"moderate",messages:{pass:"Form field does not have multiple label elements",incomplete:"Multiple label elements is not widely supported in assistive technologies. Ensure the first label contains all necessary information."}},"title-only":{impact:"serious",messages:{pass:"Form element does not solely use title attribute for its label",fail:"Only title used to generate label for form element"}},"landmark-is-unique":{impact:"moderate",messages:{pass:"Landmarks must have a unique role or role/label/title (i.e. accessible name) combination",fail:"The landmark must have a unique aria-label, aria-labelledby, or title to make landmarks distinguishable"}},"has-lang":{impact:"serious",messages:{pass:"The <html> element has a lang attribute",fail:{noXHTML:"The xml:lang attribute is not valid on HTML pages, use the lang attribute.",noLang:"The <html> element does not have a lang attribute"}}},"valid-lang":{impact:"serious",messages:{pass:"Value of lang attribute is included in the list of valid languages",fail:"Value of lang attribute not included in the list of valid languages"}},"xml-lang-mismatch":{impact:"moderate",messages:{pass:"Lang and xml:lang attributes have the same base language",fail:"Lang and xml:lang attributes do not have the same base language"}},dlitem:{impact:"serious",messages:{pass:"Description list item has a <dl> parent element",fail:"Description list item does not have a <dl> parent element"}},listitem:{impact:"serious",messages:{pass:\'List item has a <ul>, <ol> or role="list" parent element\',fail:{default:"List item does not have a <ul>, <ol> parent element",roleNotValid:\'List item does not have a <ul>, <ol> parent element without a role, or a role="list"\'}}},"only-dlitems":{impact:"serious",messages:{pass:"List element only has direct children that are allowed inside <dt> or <dd> elements",fail:"List element has direct children that are not allowed inside <dt> or <dd> elements"}},"only-listitems":{impact:"serious",messages:{pass:"List element only has direct children that are allowed inside <li> elements",fail:{default:"List element has direct children that are not allowed inside <li> elements",roleNotValid:"List element has direct children with a role that is not allowed: ${data.roles}"}}},"structured-dlitems":{impact:"serious",messages:{pass:"When not empty, element has both <dt> and <dd> elements",fail:"When not empty, element does not have at least one <dt> element followed by at least one <dd> element"}},caption:{impact:"critical",messages:{pass:"The multimedia element has a captions track",incomplete:"Check that captions is available for the element"}},"frame-tested":{impact:"critical",messages:{pass:"The iframe was tested with axe-core",fail:"The iframe could not be tested with axe-core",incomplete:"The iframe still has to be tested with axe-core"}},"no-autoplay-audio":{impact:"moderate",messages:{pass:"<video> or <audio> does not output audio for more than allowed duration or has controls mechanism",fail:"<video> or <audio> outputs audio for more than allowed duration and does not have a controls mechanism",incomplete:"Check that the <video> or <audio> does not output audio for more than allowed duration or provides a controls mechanism"}},"css-orientation-lock":{impact:"serious",messages:{pass:"Display is operable, and orientation lock does not exist",fail:"CSS Orientation lock is applied, and makes display inoperable",incomplete:"CSS Orientation lock cannot be determined"}},"meta-viewport-large":{impact:"minor",messages:{pass:"<meta> tag does not prevent significant zooming on mobile devices",fail:"<meta> tag limits zooming on mobile devices"}},"meta-viewport":{impact:"critical",messages:{pass:"<meta> tag does not disable zooming on mobile devices",fail:"${data} on <meta> tag disables zooming on mobile devices"}},"header-present":{impact:"serious",messages:{pass:"Page has a heading",fail:"Page does not have a heading"}},"heading-order":{impact:"moderate",messages:{pass:"Heading order valid",fail:"Heading order invalid"}},"identical-links-same-purpose":{impact:"minor",messages:{pass:"There are no other links with the same name, that go to a different URL",incomplete:"Check that links have the same purpose, or are intentionally ambiguous."}},"internal-link-present":{impact:"serious",messages:{pass:"Valid skip link found",fail:"No valid skip link found"}},landmark:{impact:"serious",messages:{pass:"Page has a landmark region",fail:"Page does not have a landmark region"}},"meta-refresh":{impact:"critical",messages:{pass:"<meta> tag does not immediately refresh the page",fail:"<meta> tag forces timed refresh of page"}},"p-as-heading":{impact:"serious",messages:{pass:"<p> elements are not styled as headings",fail:"Heading elements should be used instead of styled p elements"}},region:{impact:"moderate",messages:{pass:"All page content is contained by landmarks",fail:"Some page content is not contained by landmarks"}},"skip-link":{impact:"moderate",messages:{pass:"Skip link target exists",incomplete:"Skip link target should become visible on activation",fail:"No skip link target"}},"unique-frame-title":{impact:"serious",messages:{pass:"Element\'s title attribute is unique",fail:"Element\'s title attribute is not unique"}},"duplicate-id-active":{impact:"serious",messages:{pass:"Document has no active elements that share the same id attribute",fail:"Document has active elements with the same id attribute: ${data}"}},"duplicate-id-aria":{impact:"critical",messages:{pass:"Document has no elements referenced with ARIA or labels that share the same id attribute",fail:"Document has multiple elements referenced with ARIA with the same id attribute: ${data}"}},"duplicate-id":{impact:"minor",messages:{pass:"Document has no static elements that share the same id attribute",fail:"Document has multiple static elements with the same id attribute: ${data}"}},"aria-label":{impact:"serious",messages:{pass:"aria-label attribute exists and is not empty",fail:"aria-label attribute does not exist or is empty"}},"aria-labelledby":{impact:"serious",messages:{pass:"aria-labelledby attribute exists and references elements that are visible to screen readers",fail:"aria-labelledby attribute does not exist, references elements that do not exist or references elements that are empty",incomplete:"ensure aria-labelledby references an existing element"}},"avoid-inline-spacing":{impact:"serious",messages:{pass:"No inline styles with \'!important\' that affect text spacing has been specified",fail:{singular:"Remove \'!important\' from inline style ${data.values}, as overriding this is not supported by most browsers",plural:"Remove \'!important\' from inline styles ${data.values}, as overriding this is not supported by most browsers"}}},"button-has-visible-text":{impact:"critical",messages:{pass:"Element has inner text that is visible to screen readers",fail:"Element does not have inner text that is visible to screen readers",incomplete:"Unable to determine if element has children"}},"doc-has-title":{impact:"serious",messages:{pass:"Document has a non-empty <title> element",fail:"Document does not have a non-empty <title> element"}},exists:{impact:"minor",messages:{pass:"Element does not exist",incomplete:"Element exists"}},"has-alt":{impact:"critical",messages:{pass:"Element has an alt attribute",fail:"Element does not have an alt attribute"}},"has-visible-text":{impact:"minor",messages:{pass:"Element has text that is visible to screen readers",fail:"Element does not have text that is visible to screen readers",incomplete:"Unable to determine if element has children"}},"is-on-screen":{impact:"serious",messages:{pass:"Element is not visible",fail:"Element is visible"}},"non-empty-alt":{impact:"critical",messages:{pass:"Element has a non-empty alt attribute",fail:{noAttr:"Element has no alt attribute",emptyAttr:"Element has an empty alt attribute"}}},"non-empty-if-present":{impact:"critical",messages:{pass:{default:"Element does not have a value attribute","has-label":"Element has a non-empty value attribute"},fail:"Element has a value attribute and the value attribute is empty"}},"non-empty-placeholder":{impact:"serious",messages:{pass:"Element has a placeholder attribute",fail:{noAttr:"Element has no placeholder attribute",emptyAttr:"Element has an empty placeholder attribute"}}},"non-empty-title":{impact:"serious",messages:{pass:"Element has a title attribute",fail:{noAttr:"Element has no title attribute",emptyAttr:"Element has an empty title attribute"}}},"non-empty-value":{impact:"critical",messages:{pass:"Element has a non-empty value attribute",fail:{noAttr:"Element has no value attribute",emptyAttr:"Element has an empty value attribute"}}},"presentational-role":{impact:"minor",messages:{pass:\'Element\\\'s default semantics were overriden with role="${data.role}"\',fail:{default:\'Element\\\'s default semantics were not overridden with role="none" or role="presentation"\',globalAria:"Element\'s role is not presentational because it has a global ARIA attribute",focusable:"Element\'s role is not presentational because it is focusable",both:"Element\'s role is not presentational because it has a global ARIA attribute and is focusable"}}},"role-none":{impact:"minor",messages:{pass:\'Element\\\'s default semantics were overriden with role="none"\',fail:\'Element\\\'s default semantics were not overridden with role="none"\'}},"role-presentation":{impact:"minor",messages:{pass:\'Element\\\'s default semantics were overriden with role="presentation"\',fail:\'Element\\\'s default semantics were not overridden with role="presentation"\'}},"svg-non-empty-title":{impact:"serious",messages:{pass:"Element has a child that is a title",fail:{noTitle:"Element has no child that is a title",emptyTitle:"Element child title is empty"},incomplete:"Unable to determine element has a child that is a title"}},"caption-faked":{impact:"serious",messages:{pass:"The first row of a table is not used as a caption",fail:"The first child of the table should be a caption instead of a table cell"}},"html5-scope":{impact:"moderate",messages:{pass:"Scope attribute is only used on table header elements (<th>)",fail:"In HTML 5, scope attributes may only be used on table header elements (<th>)"}},"same-caption-summary":{impact:"minor",messages:{pass:"Content of summary attribute and <caption> are not duplicated",fail:"Content of summary attribute and <caption> element are identical"}},"scope-value":{impact:"critical",messages:{pass:"Scope attribute is used correctly",fail:"The value of the scope attribute may only be \'row\' or \'col\'"}},"td-has-header":{impact:"critical",messages:{pass:"All non-empty data cells have table headers",fail:"Some non-empty data cells do not have table headers"}},"td-headers-attr":{impact:"serious",messages:{pass:"The headers attribute is exclusively used to refer to other cells in the table",incomplete:"The headers attribute is empty",fail:"The headers attribute is not exclusively used to refer to other cells in the table"}},"th-has-data-cells":{impact:"serious",messages:{pass:"All table header cells refer to data cells",fail:"Not all table header cells refer to data cells",incomplete:"Table data cells are missing or empty"}},"hidden-content":{impact:"minor",messages:{pass:"All content on the page has been analyzed.",fail:"There were problems analyzing the content on this page.",incomplete:"There is hidden content on the page that was not analyzed. You will need to trigger the display of this content in order to analyze it."}}},failureSummaries:{any:{failureMessage:function(e){var t="Fix any of the following:",r=e;if(r)for(var a=-1,n=r.length-1;a<n;)t+="\\n  "+r[a+=1].split("\\n").join("\\n  ");return t}},none:{failureMessage:function(e){var t="Fix all of the following:",r=e;if(r)for(var a=-1,n=r.length-1;a<n;)t+="\\n  "+r[a+=1].split("\\n").join("\\n  ");return t}}},incompleteFallbackMessage:{}},rules:[{id:"accesskeys",selector:"[accesskey]",excludeHidden:!1,tags:["cat.keyboard","best-practice"],all:[],any:[],none:["accesskeys"]},{id:"area-alt",selector:"map area[href]",excludeHidden:!1,tags:["cat.text-alternatives","wcag2a","wcag111","wcag244","wcag412","section508","section508.22.a","ACT"],all:[],any:[{options:{attribute:"alt"},id:"non-empty-alt"},{options:{attribute:"title"},id:"non-empty-title"},"aria-label","aria-labelledby"],none:[]},{id:"aria-allowed-attr",matches:"aria-allowed-attr-matches",tags:["cat.aria","wcag2a","wcag412"],all:[],any:["aria-allowed-attr"],none:["aria-unsupported-attr"]},{id:"aria-allowed-role",excludeHidden:!1,selector:"[role]",matches:"aria-allowed-role-matches",tags:["cat.aria","best-practice"],all:[],any:[{options:{allowImplicit:!0,ignoredTags:[]},id:"aria-allowed-role"}],none:[]},{id:"aria-command-name",selector:\'[role="link"], [role="button"], [role="menuitem"]\',matches:"no-naming-method-matches",tags:["cat.aria","wcag2a","wcag412"],all:[],any:["aria-label","aria-labelledby",{options:{attribute:"title"},id:"non-empty-title"},"has-visible-text"],none:[]},{id:"aria-dialog-name",selector:\'[role="dialog"], [role="alertdialog"]\',matches:"no-naming-method-matches",tags:["cat.aria","best-practice"],all:[],any:["aria-label","aria-labelledby",{options:{attribute:"title"},id:"non-empty-title"}],none:[]},{id:"aria-hidden-body",selector:"body",excludeHidden:!1,matches:"is-initiator-matches",tags:["cat.aria","wcag2a","wcag412"],all:[],any:["aria-hidden-body"],none:[]},{id:"aria-hidden-focus",selector:\'[aria-hidden="true"]\',matches:"aria-hidden-focus-matches",excludeHidden:!1,tags:["cat.name-role-value","wcag2a","wcag412","wcag131"],all:["focusable-modal-open","focusable-disabled","focusable-not-tabbable"],any:[],none:[]},{id:"aria-input-field-name",selector:\'[role="combobox"], [role="listbox"], [role="searchbox"], [role="slider"], [role="spinbutton"], [role="textbox"]\',matches:"no-naming-method-matches",tags:["cat.aria","wcag2a","wcag412","ACT"],all:[],any:["aria-label","aria-labelledby",{options:{attribute:"title"},id:"non-empty-title"}],none:["no-implicit-explicit-label"]},{id:"aria-meter-name",selector:\'[role="meter"]\',matches:"no-naming-method-matches",tags:["cat.aria","wcag2a","wcag111"],all:[],any:["aria-label","aria-labelledby",{options:{attribute:"title"},id:"non-empty-title"}],none:[]},{id:"aria-progressbar-name",selector:\'[role="progressbar"]\',matches:"no-naming-method-matches",tags:["cat.aria","wcag2a","wcag111"],all:[],any:["aria-label","aria-labelledby",{options:{attribute:"title"},id:"non-empty-title"}],none:[]},{id:"aria-required-attr",selector:"[role]",tags:["cat.aria","wcag2a","wcag412"],all:[],any:["aria-required-attr"],none:[]},{id:"aria-required-children",selector:"[role]",tags:["cat.aria","wcag2a","wcag131"],all:[],any:[{options:{reviewEmpty:["doc-bibliography","doc-endnotes","grid","list","listbox","table","tablist","tree","treegrid","rowgroup"]},id:"aria-required-children"}],none:[]},{id:"aria-required-parent",selector:"[role]",tags:["cat.aria","wcag2a","wcag131"],all:[],any:["aria-required-parent"],none:[]},{id:"aria-roledescription",selector:"[aria-roledescription]",tags:["cat.aria","wcag2a","wcag412"],all:[],any:[{options:{supportedRoles:["button","img","checkbox","radio","combobox","menuitemcheckbox","menuitemradio"]},id:"aria-roledescription"}],none:[]},{id:"aria-roles",selector:"[role]",matches:"no-empty-role-matches",tags:["cat.aria","wcag2a","wcag412"],all:[],any:[],none:["fallbackrole","invalidrole","abstractrole","unsupportedrole"]},{id:"aria-toggle-field-name",selector:\'[role="checkbox"], [role="menuitemcheckbox"], [role="menuitemradio"], [role="radio"], [role="switch"], [role="option"]\',matches:"no-naming-method-matches",tags:["cat.aria","wcag2a","wcag412","ACT"],all:[],any:["aria-label","aria-labelledby",{options:{attribute:"title"},id:"non-empty-title"},"has-visible-text"],none:["no-implicit-explicit-label"]},{id:"aria-tooltip-name",selector:\'[role="tooltip"]\',matches:"no-naming-method-matches",tags:["cat.aria","wcag2a","wcag412"],all:[],any:["aria-label","aria-labelledby",{options:{attribute:"title"},id:"non-empty-title"},"has-visible-text"],none:[]},{id:"aria-treeitem-name",selector:\'[role="treeitem"]\',matches:"no-naming-method-matches",tags:["cat.aria","best-practice"],all:[],any:["has-visible-text","aria-labelledby","aria-label",{options:{attribute:"title"},id:"non-empty-title"}],none:[]},{id:"aria-valid-attr-value",matches:"aria-has-attr-matches",tags:["cat.aria","wcag2a","wcag412"],all:[{options:[],id:"aria-valid-attr-value"},"aria-errormessage"],any:[],none:[]},{id:"aria-valid-attr",matches:"aria-has-attr-matches",tags:["cat.aria","wcag2a","wcag412"],all:[],any:[{options:[],id:"aria-valid-attr"}],none:[]},{id:"audio-caption",selector:"audio",enabled:!1,excludeHidden:!1,tags:["cat.time-and-media","wcag2a","wcag121","section508","section508.22.a"],all:[],any:[],none:["caption"]},{id:"autocomplete-valid",matches:"autocomplete-matches",tags:["cat.forms","wcag21aa","wcag135"],all:["autocomplete-valid","autocomplete-appropriate"],any:[],none:[]},{id:"avoid-inline-spacing",selector:"[style]",tags:["cat.structure","wcag21aa","wcag1412"],all:[{options:{cssProperties:["line-height","letter-spacing","word-spacing"]},id:"avoid-inline-spacing"}],any:[],none:[]},{id:"blink",selector:"blink",excludeHidden:!1,tags:["cat.time-and-media","wcag2a","wcag222","section508","section508.22.j"],all:[],any:[],none:["is-on-screen"]},{id:"button-name",selector:"button",matches:"no-explicit-name-required-matches",tags:["cat.name-role-value","wcag2a","wcag412","section508","section508.22.a","ACT"],all:[],any:["button-has-visible-text","aria-label","aria-labelledby","presentational-role",{options:{attribute:"title"},id:"non-empty-title"}],none:[]},{id:"bypass",selector:"html",pageLevel:!0,matches:"bypass-matches",tags:["cat.keyboard","wcag2a","wcag241","section508","section508.22.o"],all:[],any:["internal-link-present",{options:{selector:"h1:not([role]), h2:not([role]), h3:not([role]), h4:not([role]), h5:not([role]), h6:not([role]), [role=heading]"},id:"header-present"},{options:{selector:"main, [role=main]"},id:"landmark"}],none:[]},{id:"color-contrast",matches:"color-contrast-matches",excludeHidden:!1,tags:["cat.color","wcag2aa","wcag143"],all:[],any:[{options:{ignoreUnicode:!0,ignoreLength:!1,boldValue:700,boldTextPt:14,largeTextPt:18,contrastRatio:{normal:{expected:4.5},large:{expected:3}},shadowOutlineEmMax:.1},id:"color-contrast"}],none:[]},{id:"css-orientation-lock",selector:"html",tags:["cat.structure","wcag134","wcag21aa","experimental"],all:[{options:{degreeThreshold:2},id:"css-orientation-lock"}],any:[],none:[],preload:!0},{id:"definition-list",selector:"dl",matches:"no-role-matches",tags:["cat.structure","wcag2a","wcag131"],all:[],any:[],none:["structured-dlitems","only-dlitems"]},{id:"dlitem",selector:"dd, dt",matches:"no-role-matches",tags:["cat.structure","wcag2a","wcag131"],all:[],any:["dlitem"],none:[]},{id:"document-title",selector:"html",matches:"is-initiator-matches",tags:["cat.text-alternatives","wcag2a","wcag242","ACT"],all:[],any:["doc-has-title"],none:[]},{id:"duplicate-id-active",selector:"[id]",matches:"duplicate-id-active-matches",excludeHidden:!1,tags:["cat.parsing","wcag2a","wcag411"],all:[],any:["duplicate-id-active"],none:[]},{id:"duplicate-id-aria",selector:"[id]",matches:"duplicate-id-aria-matches",excludeHidden:!1,tags:["cat.parsing","wcag2a","wcag411"],all:[],any:["duplicate-id-aria"],none:[]},{id:"duplicate-id",selector:"[id]",matches:"duplicate-id-misc-matches",excludeHidden:!1,tags:["cat.parsing","wcag2a","wcag411"],all:[],any:["duplicate-id"],none:[]},{id:"empty-heading",selector:\'h1, h2, h3, h4, h5, h6, [role="heading"]\',matches:"heading-matches",tags:["cat.name-role-value","best-practice"],impact:"minor",all:[],any:["has-visible-text","aria-label","aria-labelledby",{options:{attribute:"title"},id:"non-empty-title"}],none:[]},{id:"focus-order-semantics",selector:"div, h1, h2, h3, h4, h5, h6, [role=heading], p, span",matches:"inserted-into-focus-order-matches",tags:["cat.keyboard","best-practice","experimental"],all:[],any:[{options:[],id:"has-widget-role"},{options:[],id:"valid-scrollable-semantics"}],none:[]},{id:"form-field-multiple-labels",selector:"input, select, textarea",matches:"label-matches",tags:["cat.forms","wcag2a","wcag332"],all:[],any:[],none:["multiple-label"]},{id:"frame-tested",selector:"frame, iframe",tags:["cat.structure","review-item","best-practice"],all:[{options:{isViolation:!1},id:"frame-tested"}],any:[],none:[]},{id:"frame-title-unique",selector:"frame[title], iframe[title]",matches:"frame-title-has-text-matches",tags:["cat.text-alternatives","best-practice"],all:[],any:[],none:["unique-frame-title"]},{id:"frame-title",selector:"frame, iframe",tags:["cat.text-alternatives","wcag2a","wcag241","wcag412","section508","section508.22.i"],all:[],any:["aria-label","aria-labelledby",{options:{attribute:"title"},id:"non-empty-title"},"presentational-role"],none:[]},{id:"heading-order",selector:"h1, h2, h3, h4, h5, h6, [role=heading]",matches:"heading-matches",tags:["cat.semantics","best-practice"],all:[],any:["heading-order"],none:[]},{id:"hidden-content",selector:"*",excludeHidden:!1,tags:["cat.structure","experimental","review-item","best-practice"],all:[],any:["hidden-content"],none:[]},{id:"html-has-lang",selector:"html",matches:"is-initiator-matches",tags:["cat.language","wcag2a","wcag311","ACT"],all:[],any:[{options:{attributes:["lang","xml:lang"]},id:"has-lang"}],none:[]},{id:"html-lang-valid",selector:"html[lang], html[xml\\\\:lang]",tags:["cat.language","wcag2a","wcag311","ACT"],all:[],any:[],none:[{options:{attributes:["lang","xml:lang"]},id:"valid-lang"}]},{id:"html-xml-lang-mismatch",selector:"html[lang][xml\\\\:lang]",matches:"xml-lang-mismatch-matches",tags:["cat.language","wcag2a","wcag311","ACT"],all:["xml-lang-mismatch"],any:[],none:[]},{id:"identical-links-same-purpose",selector:\'a[href], area[href], [role="link"]\',excludeHidden:!1,matches:"identical-links-same-purpose-matches",tags:["cat.semantics","wcag2aaa","wcag249","best-practice"],all:["identical-links-same-purpose"],any:[],none:[]},{id:"image-alt",selector:"img",matches:"no-explicit-name-required-matches",tags:["cat.text-alternatives","wcag2a","wcag111","section508","section508.22.a","ACT"],all:[],any:["has-alt","aria-label","aria-labelledby",{options:{attribute:"title"},id:"non-empty-title"},"presentational-role"],none:["alt-space-value"]},{id:"image-redundant-alt",selector:"img",tags:["cat.text-alternatives","best-practice"],all:[],any:[],none:[{options:{parentSelector:"button, [role=button], a[href], p, li, td, th"},id:"duplicate-img-label"}]},{id:"input-button-name",selector:\'input[type="button"], input[type="submit"], input[type="reset"]\',matches:"no-explicit-name-required-matches",tags:["cat.name-role-value","wcag2a","wcag412","section508","section508.22.a"],all:[],any:["non-empty-if-present",{options:{attribute:"value"},id:"non-empty-value"},"aria-label","aria-labelledby","presentational-role",{options:{attribute:"title"},id:"non-empty-title"}],none:[]},{id:"input-image-alt",selector:\'input[type="image"]\',matches:"no-explicit-name-required-matches",tags:["cat.text-alternatives","wcag2a","wcag111","section508","section508.22.a","ACT"],all:[],any:[{options:{attribute:"alt"},id:"non-empty-alt"},"aria-label","aria-labelledby",{options:{attribute:"title"},id:"non-empty-title"}],none:[]},{id:"label-content-name-mismatch",matches:"label-content-name-mismatch-matches",tags:["cat.semantics","wcag21a","wcag253","experimental"],all:[],any:[{options:{pixelThreshold:.1,occuranceThreshold:3},id:"label-content-name-mismatch"}],none:[]},{id:"label-title-only",selector:"input, select, textarea",matches:"label-matches",tags:["cat.forms","best-practice"],all:[],any:[],none:["title-only"]},{id:"label",selector:"input, textarea",matches:"label-matches",tags:["cat.forms","wcag2a","wcag412","wcag131","section508","section508.22.n","ACT"],all:[],any:["aria-label","aria-labelledby","implicit-label","explicit-label",{options:{attribute:"title"},id:"non-empty-title"},{options:{attribute:"placeholder"},id:"non-empty-placeholder"},"presentational-role"],none:["help-same-as-label","hidden-explicit-label"]},{id:"landmark-banner-is-top-level",selector:"header:not([role]), [role=banner]",matches:"landmark-has-body-context-matches",tags:["cat.semantics","best-practice"],all:[],any:["landmark-is-top-level"],none:[]},{id:"landmark-complementary-is-top-level",selector:"aside:not([role]), [role=complementary]",tags:["cat.semantics","best-practice"],all:[],any:["landmark-is-top-level"],none:[]},{id:"landmark-contentinfo-is-top-level",selector:"footer:not([role]), [role=contentinfo]",matches:"landmark-has-body-context-matches",tags:["cat.semantics","best-practice"],all:[],any:["landmark-is-top-level"],none:[]},{id:"landmark-main-is-top-level",selector:"main:not([role]), [role=main]",tags:["cat.semantics","best-practice"],all:[],any:["landmark-is-top-level"],none:[]},{id:"landmark-no-duplicate-banner",selector:"header:not([role]), [role=banner]",tags:["cat.semantics","best-practice"],all:[],any:[{options:{selector:"header:not([role]), [role=banner]",nativeScopeFilter:"article, aside, main, nav, section"},id:"page-no-duplicate-banner"}],none:[]},{id:"landmark-no-duplicate-contentinfo",selector:"footer:not([role]), [role=contentinfo]",tags:["cat.semantics","best-practice"],all:[],any:[{options:{selector:"footer:not([role]), [role=contentinfo]",nativeScopeFilter:"article, aside, main, nav, section"},id:"page-no-duplicate-contentinfo"}],none:[]},{id:"landmark-no-duplicate-main",selector:"main:not([role]), [role=main]",tags:["cat.semantics","best-practice"],all:[],any:[{options:{selector:"main:not([role]), [role=\'main\']"},id:"page-no-duplicate-main"}],none:[]},{id:"landmark-one-main",selector:"html",tags:["cat.semantics","best-practice"],all:[{options:{selector:"main:not([role]), [role=\'main\']"},id:"page-has-main"}],any:[],none:[]},{id:"landmark-unique",selector:"[role=banner], [role=complementary], [role=contentinfo], [role=main], [role=navigation], [role=region], [role=search], [role=form], form, footer, header, aside, main, nav, section",tags:["cat.semantics","best-practice"],matches:"landmark-unique-matches",all:[],any:["landmark-is-unique"],none:[]},{id:"link-in-text-block",selector:"a[href], [role=link]",matches:"link-in-text-block-matches",excludeHidden:!1,tags:["cat.color","experimental","wcag2a","wcag141"],all:["link-in-text-block"],any:[],none:[]},{id:"link-name",selector:"a[href]",tags:["cat.name-role-value","wcag2a","wcag412","wcag244","section508","section508.22.a","ACT"],all:[],any:["has-visible-text","aria-label","aria-labelledby",{options:{attribute:"title"},id:"non-empty-title"}],none:["focusable-no-name"]},{id:"list",selector:"ul, ol",matches:"no-role-matches",tags:["cat.structure","wcag2a","wcag131"],all:[],any:[],none:["only-listitems"]},{id:"listitem",selector:"li",matches:"no-role-matches",tags:["cat.structure","wcag2a","wcag131"],all:[],any:["listitem"],none:[]},{id:"marquee",selector:"marquee",excludeHidden:!1,tags:["cat.parsing","wcag2a","wcag222"],all:[],any:[],none:["is-on-screen"]},{id:"meta-refresh",selector:\'meta[http-equiv="refresh"]\',excludeHidden:!1,tags:["cat.time-and-media","wcag2a","wcag2aaa","wcag221","wcag224","wcag325"],all:[],any:["meta-refresh"],none:[]},{id:"meta-viewport-large",selector:\'meta[name="viewport"]\',excludeHidden:!1,tags:["cat.sensory-and-visual-cues","best-practice"],all:[],any:[{options:{scaleMinimum:5,lowerBound:2},id:"meta-viewport-large"}],none:[]},{id:"meta-viewport",selector:\'meta[name="viewport"]\',excludeHidden:!1,tags:["cat.sensory-and-visual-cues","best-practice","ACT"],all:[],any:[{options:{scaleMinimum:2},id:"meta-viewport"}],none:[]},{id:"no-autoplay-audio",excludeHidden:!1,selector:"audio[autoplay], video[autoplay]",matches:"no-autoplay-audio-matches",tags:["cat.time-and-media","wcag2a","wcag142","experimental"],preload:!0,all:[{options:{allowedDuration:3},id:"no-autoplay-audio"}],any:[],none:[]},{id:"object-alt",selector:"object",matches:"no-explicit-name-required-matches",tags:["cat.text-alternatives","wcag2a","wcag111","section508","section508.22.a"],all:[],any:["aria-label","aria-labelledby",{options:{attribute:"title"},id:"non-empty-title"},"presentational-role"],none:[]},{id:"p-as-heading",selector:"p",matches:"p-as-heading-matches",tags:["cat.semantics","wcag2a","wcag131","experimental"],all:[{options:{margins:[{weight:150,italic:!0},{weight:150,size:1.15},{italic:!0,size:1.15},{size:1.4}]},id:"p-as-heading"}],any:[],none:[]},{id:"page-has-heading-one",selector:"html",tags:["cat.semantics","best-practice"],all:[{options:{selector:"h1:not([role]):not([aria-level]), h1:not([role])[aria-level=1], h2:not([role])[aria-level=1], h3:not([role])[aria-level=1], h4:not([role])[aria-level=1], h5:not([role])[aria-level=1], h6:not([role])[aria-level=1], [role=heading][aria-level=1]"},id:"page-has-heading-one"}],any:[],none:[]},{id:"presentation-role-conflict",selector:\'[role="none"], [role="presentation"]\',tags:["cat.aria","best-practice"],all:[],any:[],none:["is-element-focusable","has-global-aria-attribute"]},{id:"region",selector:"body *",tags:["cat.keyboard","best-practice"],all:[],any:[{options:{regionMatcher:"dialog, [role=dialog], svg, iframe"},id:"region"}],none:[]},{id:"role-img-alt",selector:"[role=\'img\']:not(img):not(area):not(input):not(object)",matches:"html-namespace-matches",tags:["cat.text-alternatives","wcag2a","wcag111","section508","section508.22.a","ACT"],all:[],any:["aria-label","aria-labelledby",{options:{attribute:"title"},id:"non-empty-title"}],none:[]},{id:"scope-attr-valid",selector:"td[scope], th[scope]",tags:["cat.tables","best-practice"],all:["html5-scope",{options:{values:["row","col","rowgroup","colgroup"]},id:"scope-value"}],any:[],none:[]},{id:"scrollable-region-focusable",matches:"scrollable-region-focusable-matches",tags:["cat.keyboard","wcag2a","wcag211"],all:[],any:["focusable-content","focusable-element"],none:[]},{id:"select-name",selector:"select",tags:["cat.forms","wcag2a","wcag412","wcag131","section508","section508.22.n","ACT"],all:[],any:["aria-label","aria-labelledby","implicit-label","explicit-label",{options:{attribute:"title"},id:"non-empty-title"},"presentational-role"],none:["help-same-as-label","hidden-explicit-label"]},{id:"server-side-image-map",selector:"img[ismap]",tags:["cat.text-alternatives","wcag2a","wcag211","section508","section508.22.f"],all:[],any:[],none:["exists"]},{id:"skip-link",selector:\'a[href^="#"], a[href^="/#"]\',matches:"skip-link-matches",tags:["cat.keyboard","best-practice"],all:[],any:["skip-link"],none:[]},{id:"svg-img-alt",selector:\'[role="img"], [role="graphics-symbol"], svg[role="graphics-document"]\',matches:"svg-namespace-matches",tags:["cat.text-alternatives","wcag2a","wcag111","section508","section508.22.a","ACT"],all:[],any:["svg-non-empty-title","aria-label","aria-labelledby",{options:{attribute:"title"},id:"non-empty-title"}],none:[]},{id:"tabindex",selector:"[tabindex]",tags:["cat.keyboard","best-practice"],all:[],any:["tabindex"],none:[]},{id:"table-duplicate-name",selector:"table",tags:["cat.tables","best-practice"],all:[],any:[],none:["same-caption-summary"]},{id:"table-fake-caption",selector:"table",matches:"data-table-matches",tags:["cat.tables","experimental","wcag2a","wcag131","section508","section508.22.g"],all:["caption-faked"],any:[],none:[]},{id:"td-has-header",selector:"table",matches:"data-table-large-matches",tags:["cat.tables","experimental","wcag2a","wcag131","section508","section508.22.g"],all:["td-has-header"],any:[],none:[]},{id:"td-headers-attr",selector:"table",tags:["cat.tables","wcag2a","wcag131","section508","section508.22.g"],all:["td-headers-attr"],any:[],none:[]},{id:"th-has-data-cells",selector:"table",matches:"data-table-matches",tags:["cat.tables","wcag2a","wcag131","section508","section508.22.g"],all:["th-has-data-cells"],any:[],none:[]},{id:"valid-lang",selector:"[lang], [xml\\\\:lang]",matches:"not-html-matches",tags:["cat.language","wcag2aa","wcag312"],all:[],any:[],none:[{options:{attributes:["lang","xml:lang"]},id:"valid-lang"}]},{id:"video-caption",selector:"video",excludeHidden:!1,tags:["cat.text-alternatives","wcag2a","wcag122","section508","section508.22.a"],all:[],any:[],none:["caption"]}],checks:[{id:"abstractrole",evaluate:"abstractrole-evaluate"},{id:"aria-allowed-attr",evaluate:"aria-allowed-attr-evaluate"},{id:"aria-allowed-role",evaluate:"aria-allowed-role-evaluate",options:{allowImplicit:!0,ignoredTags:[]}},{id:"aria-errormessage",evaluate:"aria-errormessage-evaluate"},{id:"aria-hidden-body",evaluate:"aria-hidden-body-evaluate"},{id:"aria-required-attr",evaluate:"aria-required-attr-evaluate"},{id:"aria-required-children",evaluate:"aria-required-children-evaluate",options:{reviewEmpty:["doc-bibliography","doc-endnotes","grid","list","listbox","table","tablist","tree","treegrid","rowgroup"]}},{id:"aria-required-parent",evaluate:"aria-required-parent-evaluate"},{id:"aria-roledescription",evaluate:"aria-roledescription-evaluate",options:{supportedRoles:["button","img","checkbox","radio","combobox","menuitemcheckbox","menuitemradio"]}},{id:"aria-unsupported-attr",evaluate:"aria-unsupported-attr-evaluate"},{id:"aria-valid-attr-value",evaluate:"aria-valid-attr-value-evaluate",options:[]},{id:"aria-valid-attr",evaluate:"aria-valid-attr-evaluate",options:[]},{id:"fallbackrole",evaluate:"fallbackrole-evaluate"},{id:"has-global-aria-attribute",evaluate:"has-global-aria-attribute-evaluate"},{id:"has-widget-role",evaluate:"has-widget-role-evaluate",options:[]},{id:"invalidrole",evaluate:"invalidrole-evaluate"},{id:"is-element-focusable",evaluate:"is-element-focusable-evaluate"},{id:"no-implicit-explicit-label",evaluate:"no-implicit-explicit-label-evaluate"},{id:"unsupportedrole",evaluate:"unsupportedrole-evaluate"},{id:"valid-scrollable-semantics",evaluate:"valid-scrollable-semantics-evaluate",options:[]},{id:"color-contrast",evaluate:"color-contrast-evaluate",options:{ignoreUnicode:!0,ignoreLength:!1,boldValue:700,boldTextPt:14,largeTextPt:18,contrastRatio:{normal:{expected:4.5},large:{expected:3}},shadowOutlineEmMax:.1}},{id:"link-in-text-block",evaluate:"link-in-text-block-evaluate"},{id:"autocomplete-appropriate",evaluate:"autocomplete-appropriate-evaluate"},{id:"autocomplete-valid",evaluate:"autocomplete-valid-evaluate"},{id:"accesskeys",evaluate:"accesskeys-evaluate",after:"accesskeys-after"},{id:"focusable-content",evaluate:"focusable-content-evaluate"},{id:"focusable-disabled",evaluate:"focusable-disabled-evaluate"},{id:"focusable-element",evaluate:"focusable-element-evaluate"},{id:"focusable-modal-open",evaluate:"focusable-modal-open-evaluate"},{id:"focusable-no-name",evaluate:"focusable-no-name-evaluate"},{id:"focusable-not-tabbable",evaluate:"focusable-not-tabbable-evaluate"},{id:"landmark-is-top-level",evaluate:"landmark-is-top-level-evaluate"},{id:"page-has-heading-one",evaluate:"has-descendant-evaluate",after:"has-descendant-after",options:{selector:"h1:not([role]):not([aria-level]), h1:not([role])[aria-level=1], h2:not([role])[aria-level=1], h3:not([role])[aria-level=1], h4:not([role])[aria-level=1], h5:not([role])[aria-level=1], h6:not([role])[aria-level=1], [role=heading][aria-level=1]"}},{id:"page-has-main",evaluate:"has-descendant-evaluate",after:"has-descendant-after",options:{selector:"main:not([role]), [role=\'main\']"}},{id:"page-no-duplicate-banner",evaluate:"page-no-duplicate-evaluate",after:"page-no-duplicate-after",options:{selector:"header:not([role]), [role=banner]",nativeScopeFilter:"article, aside, main, nav, section"}},{id:"page-no-duplicate-contentinfo",evaluate:"page-no-duplicate-evaluate",after:"page-no-duplicate-after",options:{selector:"footer:not([role]), [role=contentinfo]",nativeScopeFilter:"article, aside, main, nav, section"}},{id:"page-no-duplicate-main",evaluate:"page-no-duplicate-evaluate",after:"page-no-duplicate-after",options:{selector:"main:not([role]), [role=\'main\']"}},{id:"tabindex",evaluate:"tabindex-evaluate"},{id:"alt-space-value",evaluate:"alt-space-value-evaluate"},{id:"duplicate-img-label",evaluate:"duplicate-img-label-evaluate",options:{parentSelector:"button, [role=button], a[href], p, li, td, th"}},{id:"explicit-label",evaluate:"explicit-evaluate"},{id:"help-same-as-label",evaluate:"help-same-as-label-evaluate",enabled:!1},{id:"hidden-explicit-label",evaluate:"hidden-explicit-label-evaluate"},{id:"implicit-label",evaluate:"implicit-evaluate"},{id:"label-content-name-mismatch",evaluate:"label-content-name-mismatch-evaluate",options:{pixelThreshold:.1,occuranceThreshold:3}},{id:"multiple-label",evaluate:"multiple-label-evaluate"},{id:"title-only",evaluate:"title-only-evaluate"},{id:"landmark-is-unique",evaluate:"landmark-is-unique-evaluate",after:"landmark-is-unique-after"},{id:"has-lang",evaluate:"has-lang-evaluate",options:{attributes:["lang","xml:lang"]}},{id:"valid-lang",evaluate:"valid-lang-evaluate",options:{attributes:["lang","xml:lang"]}},{id:"xml-lang-mismatch",evaluate:"xml-lang-mismatch-evaluate"},{id:"dlitem",evaluate:"dlitem-evaluate"},{id:"listitem",evaluate:"listitem-evaluate"},{id:"only-dlitems",evaluate:"only-dlitems-evaluate"},{id:"only-listitems",evaluate:"only-listitems-evaluate"},{id:"structured-dlitems",evaluate:"structured-dlitems-evaluate"},{id:"caption",evaluate:"caption-evaluate"},{id:"frame-tested",evaluate:"frame-tested-evaluate",options:{isViolation:!1}},{id:"no-autoplay-audio",evaluate:"no-autoplay-audio-evaluate",options:{allowedDuration:3}},{id:"css-orientation-lock",evaluate:"css-orientation-lock-evaluate",options:{degreeThreshold:2}},{id:"meta-viewport-large",evaluate:"meta-viewport-scale-evaluate",options:{scaleMinimum:5,lowerBound:2}},{id:"meta-viewport",evaluate:"meta-viewport-scale-evaluate",options:{scaleMinimum:2}},{id:"header-present",evaluate:"has-descendant-evaluate",after:"has-descendant-after",options:{selector:"h1:not([role]), h2:not([role]), h3:not([role]), h4:not([role]), h5:not([role]), h6:not([role]), [role=heading]"}},{id:"heading-order",evaluate:"heading-order-evaluate",after:"heading-order-after"},{id:"identical-links-same-purpose",evaluate:"identical-links-same-purpose-evaluate",after:"identical-links-same-purpose-after"},{id:"internal-link-present",evaluate:"internal-link-present-evaluate"},{id:"landmark",evaluate:"has-descendant-evaluate",options:{selector:"main, [role=main]"}},{id:"meta-refresh",evaluate:"meta-refresh-evaluate"},{id:"p-as-heading",evaluate:"p-as-heading-evaluate",options:{margins:[{weight:150,italic:!0},{weight:150,size:1.15},{italic:!0,size:1.15},{size:1.4}]}},{id:"region",evaluate:"region-evaluate",options:{regionMatcher:"dialog, [role=dialog], svg, iframe"}},{id:"skip-link",evaluate:"skip-link-evaluate"},{id:"unique-frame-title",evaluate:"unique-frame-title-evaluate",after:"unique-frame-title-after"},{id:"duplicate-id-active",evaluate:"duplicate-id-evaluate",after:"duplicate-id-after"},{id:"duplicate-id-aria",evaluate:"duplicate-id-evaluate",after:"duplicate-id-after"},{id:"duplicate-id",evaluate:"duplicate-id-evaluate",after:"duplicate-id-after"},{id:"aria-label",evaluate:"aria-label-evaluate"},{id:"aria-labelledby",evaluate:"aria-labelledby-evaluate"},{id:"avoid-inline-spacing",evaluate:"avoid-inline-spacing-evaluate",options:{cssProperties:["line-height","letter-spacing","word-spacing"]}},{id:"button-has-visible-text",evaluate:"has-text-content-evaluate"},{id:"doc-has-title",evaluate:"doc-has-title-evaluate"},{id:"exists",evaluate:"exists-evaluate"},{id:"has-alt",evaluate:"has-alt-evaluate"},{id:"has-visible-text",evaluate:"has-text-content-evaluate"},{id:"is-on-screen",evaluate:"is-on-screen-evaluate"},{id:"non-empty-alt",evaluate:"attr-non-space-content-evaluate",options:{attribute:"alt"}},{id:"non-empty-if-present",evaluate:"non-empty-if-present-evaluate"},{id:"non-empty-placeholder",evaluate:"attr-non-space-content-evaluate",options:{attribute:"placeholder"}},{id:"non-empty-title",evaluate:"attr-non-space-content-evaluate",options:{attribute:"title"}},{id:"non-empty-value",evaluate:"attr-non-space-content-evaluate",options:{attribute:"value"}},{id:"presentational-role",evaluate:"presentational-role-evaluate"},{id:"role-none",evaluate:"matches-definition-evaluate",deprecated:!0,options:{matcher:{attributes:{role:"none"}}}},{id:"role-presentation",evaluate:"matches-definition-evaluate",deprecated:!0,options:{matcher:{attributes:{role:"presentation"}}}},{id:"svg-non-empty-title",evaluate:"svg-non-empty-title-evaluate"},{id:"caption-faked",evaluate:"caption-faked-evaluate"},{id:"html5-scope",evaluate:"html5-scope-evaluate"},{id:"same-caption-summary",evaluate:"same-caption-summary-evaluate"},{id:"scope-value",evaluate:"scope-value-evaluate",options:{values:["row","col","rowgroup","colgroup"]}},{id:"td-has-header",evaluate:"td-has-header-evaluate"},{id:"td-headers-attr",evaluate:"td-headers-attr-evaluate"},{id:"th-has-data-cells",evaluate:"th-has-data-cells-evaluate"},{id:"hidden-content",evaluate:"hidden-content-evaluate"}]})}("object"==typeof window?window:this);'
}},{}],71:[function(e,t,n){"use strict";const i={console};t.exports=i},{}],72:[function(e,t,n){"use strict";const i={TextSourceMap:e("./generated/SourceMap.js")};function extendArray(e){e.lowerBound||(e.lowerBound=lowerBound.bind(e),e.upperBound=upperBound.bind(e),e.slice=function(t,n){const i=Array.prototype.slice.call(e,t,n);return extendArray(i),i},e.filter=function(t){const n=Array.prototype.filter.call(e,t);return extendArray(n),n})}const a=i.TextSourceMap.prototype.mappings;i.TextSourceMap.prototype.mappings=function(){const e=a.call(this);return extendArray(e),e};const s=i.TextSourceMap.prototype._reversedMappings;function upperBound(e,t,n,i){t=t||function defaultComparator(e,t){return e<t?-1:e>t?1:0};let a=n||0,s=void 0!==i?i:this.length;for(;a<s;){const n=a+s>>1;t(e,this[n])>=0?a=n+1:s=n}return s}function lowerBound(e,t,n,i){t=t||function defaultComparator(e,t){return e<t?-1:e>t?1:0};let a=n||0,s=void 0!==i?i:this.length;for(;a<s;){const n=a+s>>1;t(e,this[n])>0?a=n+1:s=n}
return s}i.TextSourceMap.prototype._reversedMappings=function(e){const t=s.call(this,e);return extendArray(t),t},i.TextSourceMap.prototype.computeLastGeneratedColumns=function(){const e=this.mappings();if(!e.length||void 0===e[0].lastColumnNumber)for(let t=0;t<e.length-1;t++){const n=e[t],i=e[t+1];n.lineNumber===i.lineNumber&&(n.lastColumnNumber=i.columnNumber)}},t.exports=i},{"./generated/SourceMap.js":73}],73:[function(e,t,n){const i=e("../Common.js");Object.defineProperty(n,"__esModule",{value:!0});class SourceMapV3{constructor(){this.version,this.file,this.sources,this.sections,this.mappings,this.sourceRoot,this.names}}SourceMapV3.Section=class{constructor(){this.map,this.offset}},SourceMapV3.Offset=class{constructor(){this.line,this.column}};class SourceMapEntry{constructor(e,t,n,i,a,s){this.lineNumber=e,this.columnNumber=t,this.sourceURL=n,this.sourceLineNumber=i,this.sourceColumnNumber=a,this.name=s}static compare(e,t){
return e.lineNumber!==t.lineNumber?e.lineNumber-t.lineNumber:e.columnNumber-t.columnNumber}}class TextSourceMap{constructor(e,t,n){if(!TextSourceMap._base64Map){const e="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";TextSourceMap._base64Map={};for(let t=0;t<e.length;++t)TextSourceMap._base64Map[e.charAt(t)]=t}if(this._json=n,this._compiledURL=e,this._sourceMappingURL=t,this._baseURL=t.startsWith("data:")?e:t,this._mappings=null,this._sourceInfos=new Map,this._json.sections){!!this._json.sections.find((e=>!!e.url))&&i.console.warn(`SourceMap "${t}" contains unsupported "URL" field in one of its sections.`)}this._eachSection(this._parseSources.bind(this))}compiledURL(){return this._compiledURL}url(){return this._sourceMappingURL}sourceURLs(){return this._sourceInfos.keysArray()}embeddedContentByURL(e){return this._sourceInfos.has(e)?this._sourceInfos.get(e).content:null}findEntry(e,t){
const n=this.mappings(),i=n.upperBound(void 0,((n,i)=>e-i.lineNumber||t-i.columnNumber));return i?n[i-1]:null}sourceLineMapping(e,t,n){const i=this._reversedMappings(e),a=i.lowerBound(t,lineComparator),s=i.upperBound(t,lineComparator);if(a>=i.length||i[a].sourceLineNumber!==t)return null;const l=i.slice(a,s);if(!l.length)return null;const c=l.lowerBound(n,((e,t)=>e-t.sourceColumnNumber));return c>=l.length?l[l.length-1]:l[c];function lineComparator(e,t){return e-t.sourceLineNumber}}findReverseEntries(e,t,n){const i=this._reversedMappings(e),a=i.upperBound(void 0,((e,i)=>t-i.sourceLineNumber||n-i.sourceColumnNumber));let s=a;for(;s>0&&i[s-1].sourceLineNumber===i[a-1].sourceLineNumber&&i[s-1].sourceColumnNumber===i[a-1].sourceColumnNumber;)--s;return i.slice(s,a)}mappings(){return null===this._mappings&&(this._mappings=[],this._eachSection(this._parseMap.bind(this)),this._json=null),this._mappings}_reversedMappings(e){if(!this._sourceInfos.has(e))return[]
;const t=this.mappings(),n=this._sourceInfos.get(e);return null===n.reverseMappings&&(n.reverseMappings=t.filter((t=>t.sourceURL===e)).sort((function sourceMappingComparator(e,t){if(e.sourceLineNumber!==t.sourceLineNumber)return e.sourceLineNumber-t.sourceLineNumber;if(e.sourceColumnNumber!==t.sourceColumnNumber)return e.sourceColumnNumber-t.sourceColumnNumber;if(e.lineNumber!==t.lineNumber)return e.lineNumber-t.lineNumber;return e.columnNumber-t.columnNumber}))),n.reverseMappings}_eachSection(e){if(this._json.sections)for(const t of this._json.sections)e(t.map,t.offset.line,t.offset.column);else e(this._json,0,0)}_parseSources(e){const t=[];let n=e.sourceRoot||"";n&&!n.endsWith("/")&&(n+="/");for(let i=0;i<e.sources.length;++i){let a=n+e.sources[i];const s=e.sourcesContent&&e.sourcesContent[i];this._compiledURL,this._sourceInfos.set(a,new TextSourceMap.SourceInfo(s,null)),t.push(a)}e[TextSourceMap._sourcesListSymbol]=t}_parseMap(e,t,n){let i=0,a=0,s=0,l=0
;const c=e[TextSourceMap._sourcesListSymbol],u=e.names||[],d=new TextSourceMap.StringCharIterator(e.mappings);let m=c[i];for(;;){if(","===d.peek())d.next();else{for(;";"===d.peek();)t+=1,n=0,d.next();if(!d.hasNext())break}if(n+=this._decodeVLQ(d),!d.hasNext()||this._isSeparator(d.peek())){this._mappings.push(new SourceMapEntry(t,n));continue}const e=this._decodeVLQ(d);e&&(i+=e,m=c[i]),a+=this._decodeVLQ(d),s+=this._decodeVLQ(d),d.hasNext()&&!this._isSeparator(d.peek())?(l+=this._decodeVLQ(d),this._mappings.push(new SourceMapEntry(t,n,m,a,s,u[l]))):this._mappings.push(new SourceMapEntry(t,n,m,a,s))}this._mappings.sort(SourceMapEntry.compare)}_isSeparator(e){return","===e||";"===e}_decodeVLQ(e){let t,n=0,i=0;do{t=TextSourceMap._base64Map[e.next()],n+=(t&TextSourceMap._VLQ_BASE_MASK)<<i,i+=TextSourceMap._VLQ_BASE_SHIFT}while(t&TextSourceMap._VLQ_CONTINUATION_MASK);const a=1&n;return n>>=1,a?-n:n}reverseMapTextRange(e,t){function comparator(e,t){
return e.lineNumber!==t.sourceLineNumber?e.lineNumber-t.sourceLineNumber:e.columnNumber-t.sourceColumnNumber}const n=this._reversedMappings(e),i=n.lowerBound({lineNumber:t.startLine,columnNumber:t.startColumn},comparator),a=n.upperBound({lineNumber:t.endLine,columnNumber:t.endColumn},comparator),s=n[i],l=n[a];return new TextUtils.TextRange(s.lineNumber,s.columnNumber,l.lineNumber,l.columnNumber)}dispose(){}}TextSourceMap._VLQ_BASE_SHIFT=5,TextSourceMap._VLQ_BASE_MASK=31,TextSourceMap._VLQ_CONTINUATION_MASK=32,TextSourceMap.StringCharIterator=class{constructor(e){this._string=e,this._position=0}next(){return this._string.charAt(this._position++)}peek(){return this._string.charAt(this._position)}hasNext(){return this._position<this._string.length}},TextSourceMap.SourceInfo=class{constructor(e,t){this.content=e,this.reverseMappings=t}},TextSourceMap._sourcesListSymbol=Symbol("sourcesList"),t.exports=TextSourceMap},{"../Common.js":71}],74:[function(e,t,n){"use strict";class BaseNode{
constructor(e){this._id=e,this._isMainDocument=!1,this._dependents=[],this._dependencies=[]}get id(){return this._id}get type(){throw new Error("Unimplemented")}get startTime(){throw new Error("Unimplemented")}get endTime(){throw new Error("Unimplemented")}setIsMainDocument(e){this._isMainDocument=e}isMainDocument(){return this._isMainDocument}getDependents(){return this._dependents.slice()}getNumberOfDependents(){return this._dependents.length}getDependencies(){return this._dependencies.slice()}getNumberOfDependencies(){return this._dependencies.length}getRootNode(){let e=this;for(;e._dependencies.length;)e=e._dependencies[0];return e}addDependent(e){e.addDependency(this)}addDependency(e){if(e===this)throw new Error("Cannot add dependency on itself");this._dependencies.includes(e)||(e._dependents.push(this),this._dependencies.push(e))}removeDependent(e){e.removeDependency(this)}removeDependency(e){if(!this._dependencies.includes(e))return;const t=e._dependents.indexOf(this)
;e._dependents.splice(t,1),this._dependencies.splice(this._dependencies.indexOf(e),1)}removeAllDependencies(){for(const e of this._dependencies.slice())this.removeDependency(e)}isDependentOn(e){let t=!1;return this.traverse((n=>{t||(t=n===e)}),(e=>t?[]:e.getDependencies())),t}cloneWithoutRelationships(){const e=new BaseNode(this.id);return e.setIsMainDocument(this._isMainDocument),e}cloneWithRelationships(e){const t=this.getRootNode(),n=new Map;t.traverse((t=>{n.has(t.id)||(void 0!==e?e(t)&&t.traverse((e=>n.set(e.id,e.cloneWithoutRelationships())),(e=>e._dependencies.filter((e=>!n.has(e.id))))):n.set(t.id,t.cloneWithoutRelationships()))})),t.traverse((e=>{const t=n.get(e.id);if(t)for(const i of e._dependencies){const e=n.get(i.id);if(!e)throw new Error("Dependency somehow not cloned");t.addDependency(e)}}));const i=n.get(this.id);if(!i)throw new Error("Cloned graph missing node");return i}traverse(e,t){for(const{node:n,traversalPath:i}of this.traverseGenerator(t))e(n,i)}
*traverseGenerator(e){e||(e=e=>e.getDependents());const t=[[this]],n=new Set([this.id]);for(;t.length;){const i=t.shift(),a=i[0];yield{node:a,traversalPath:i};for(const s of e(a))n.has(s.id)||(n.add(s.id),t.push([s,...i]))}}static hasCycle(e,t="both"){if("both"===t)return BaseNode.hasCycle(e,"dependents")||BaseNode.hasCycle(e,"dependencies");const n=new Set,i=[],a=[e],s=new Map([[e,0]]);for(;a.length;){const e=a.pop();if(i.includes(e))return!0;if(n.has(e))continue;for(;i.length>s.get(e);)i.pop();n.add(e),i.push(e);const l="dependents"===t?e._dependents:e._dependencies;for(const e of l)a.includes(e)||(a.push(e),s.set(e,i.length))}return!1}}BaseNode.TYPES={NETWORK:"network",CPU:"cpu"},t.exports=BaseNode},{}],75:[function(e,t,n){"use strict";const i=e("./base-node.js");class CPUNode extends i{constructor(e,t=[]){super(`${e.tid}.${e.ts}`),this._event=e,this._childEvents=t}get type(){return i.TYPES.CPU}get startTime(){return this._event.ts}get endTime(){return this._event.ts+this._event.dur
}get event(){return this._event}get childEvents(){return this._childEvents}didPerformLayout(){return this._childEvents.some((e=>"Layout"===e.name))}getEvaluateScriptURLs(){const e=new Set;for(const t of this._childEvents)"EvaluateScript"===t.name&&t.args.data&&t.args.data.url&&e.add(t.args.data.url);return e}cloneWithoutRelationships(){return new CPUNode(this._event,this._childEvents)}}t.exports=CPUNode},{"./base-node.js":74}],76:[function(e,t,n){"use strict";const i=e("./base-node.js"),a=e("../network-request.js"),s=e("../url-shim.js");class NetworkNode extends i{constructor(e){super(e.requestId),this._record=e}get type(){return i.TYPES.NETWORK}get startTime(){return 1e3*this._record.startTime*1e3}get endTime(){return 1e3*this._record.endTime*1e3}get record(){return this._record}get initiatorType(){return this._record.initiator&&this._record.initiator.type}get fromDiskCache(){return!!this._record.fromDiskCache}get isNonNetworkProtocol(){
return s.NON_NETWORK_PROTOCOLS.includes(this._record.protocol)}get isConnectionless(){return this.fromDiskCache||this.isNonNetworkProtocol}hasRenderBlockingPriority(){const e=this._record.priority,t=this._record.resourceType===a.TYPES.Script,n=this._record.resourceType===a.TYPES.Document;return"VeryHigh"===e||"High"===e&&t||"High"===e&&n}cloneWithoutRelationships(){const e=new NetworkNode(this._record);return e.setIsMainDocument(this._isMainDocument),e}}t.exports=NetworkNode},{"../network-request.js":96,"../url-shim.js":"url","./base-node.js":74}],77:[function(e,t,n){"use strict";const i=e("./network-analyzer.js"),a=e("./tcp-connection.js"),s=["https","wss"];t.exports=class ConnectionPool{constructor(e,t){this._options=t,this._records=e,this._connectionsByOrigin=new Map,this._connectionsByRecord=new Map,this._connectionsInUse=new Set,this._connectionReusedByRequestId=i.estimateIfConnectionWasReused(e,{forceCoarseEstimates:!0}),this._initializeConnections()}connectionsInUse(){
return Array.from(this._connectionsInUse)}_initializeConnections(){const e=this._connectionReusedByRequestId,t=this._options.additionalRttByOrigin,n=this._options.serverResponseTimeByOrigin,l=i.groupByOrigin(this._records);for(const[i,c]of l.entries()){const l=[],u=t.get(i)||0,d=n.get(i)||30;for(const t of c){if(e.get(t.requestId))continue;const n=s.includes(t.parsedURL.scheme),i="h2"===t.protocol,c=new a(this._options.rtt+u,this._options.throughput,d,n,i);l.push(c)}if(!l.length)throw new Error("Could not find a connection for origin: "+i);const m=l[0].isH2()?1:6;for(;l.length<m;)l.push(l[0].clone());this._connectionsByOrigin.set(i,l)}}_findAvailableConnectionWithLargestCongestionWindow(e,t){const{ignoreConnectionReused:n,observedConnectionWasReused:i}=t;let a=null;for(let t=0;t<e.length;t++){const s=e[t];if(!n&&s._warmed!==i)continue;if(this._connectionsInUse.has(s))continue;const l=a&&a.congestionWindow||-1/0;s.congestionWindow>l&&(a=s)}return a}acquire(e,t={}){
if(this._connectionsByRecord.has(e))throw new Error("Record already has a connection");const n=e.parsedURL.securityOrigin,i=!!this._connectionReusedByRequestId.get(e.requestId),a=this._connectionsByOrigin.get(n)||[],s=this._findAvailableConnectionWithLargestCongestionWindow(a,{ignoreConnectionReused:t.ignoreConnectionReused,observedConnectionWasReused:i});return s?(this._connectionsInUse.add(s),this._connectionsByRecord.set(e,s),s):null}acquireActiveConnectionFromRecord(e){const t=this._connectionsByRecord.get(e);if(!t)throw new Error("Could not find an active connection for record");return t}release(e){const t=this._connectionsByRecord.get(e);this._connectionsByRecord.delete(e),this._connectionsInUse.delete(t)}}},{"./network-analyzer.js":79,"./tcp-connection.js":82}],78:[function(e,t,n){"use strict";class DNSCache{constructor({rtt:e}){this._rtt=e,this._resolvedDomainNames=new Map}getTimeUntilResolution(e,t){
const{requestedAt:n=0,shouldUpdateCache:i=!1}=t||{},a=e.parsedURL.host,s=this._resolvedDomainNames.get(a);let l=this._rtt*DNSCache.RTT_MULTIPLIER;if(s){const e=Math.max(s.resolvedAt-n,0);l=Math.min(e,l)}const c=n+l;return i&&this._updateCacheResolvedAtIfNeeded(e,c),l}_updateCacheResolvedAtIfNeeded(e,t){const n=e.parsedURL.host,i=this._resolvedDomainNames.get(n)||{resolvedAt:t};i.resolvedAt=Math.min(i.resolvedAt,t),this._resolvedDomainNames.set(n,i)}setResolvedAt(e,t){this._resolvedDomainNames.set(e,{resolvedAt:t})}}DNSCache.RTT_MULTIPLIER=2,t.exports=DNSCache},{}],79:[function(e,t,n){"use strict";const i=e("../../network-request.js"),a=e("../../url-shim.js"),s={Document:.9,XHR:.9,Fetch:.9};class NetworkAnalyzer{static get SUMMARY(){return"__SUMMARY__"}static groupByOrigin(e){const t=new Map;return e.forEach((e=>{const n=e.parsedURL.securityOrigin,i=t.get(n)||[];i.push(e),t.set(n,i)})),t}static getSummary(e){return e.sort(((e,t)=>e-t)),{min:e[0],max:e[e.length-1],
avg:e.reduce(((e,t)=>e+t),0)/e.length,median:e[Math.floor((e.length-1)/2)]}}static summarize(e){const t=new Map,n=[];for(const[i,a]of e)t.set(i,NetworkAnalyzer.getSummary(a)),n.push(...a);return t.set(NetworkAnalyzer.SUMMARY,NetworkAnalyzer.getSummary(n)),t}static _estimateValueByOrigin(e,t){const n=NetworkAnalyzer.estimateIfConnectionWasReused(e),i=NetworkAnalyzer.groupByOrigin(e),a=new Map;for(const[e,s]of i.entries()){let i=[];for(const e of s){const a=e.timing;if(!a)continue;const s=t({record:e,timing:a,connectionReused:n.get(e.requestId)});void 0!==s&&(i=i.concat(s))}i.length&&a.set(e,i)}return a}static _estimateRTTByOriginViaTCPTiming(e){return NetworkAnalyzer._estimateValueByOrigin(e,(({timing:e,connectionReused:t})=>{if(!t)return e.sslStart>0&&e.sslEnd>0?[e.connectEnd-e.sslStart,e.sslStart-e.connectStart]:e.connectStart>0&&e.connectEnd>0?e.connectEnd-e.connectStart:void 0}))}static _estimateRTTByOriginViaDownloadTiming(e){
return NetworkAnalyzer._estimateValueByOrigin(e,(({record:e,timing:t,connectionReused:n})=>{if(n)return;if(e.transferSize<=14336)return;if(!Number.isFinite(t.receiveHeadersEnd)||t.receiveHeadersEnd<0)return;const i=1e3*(e.endTime-e.startTime)-t.receiveHeadersEnd,a=Math.log2(e.transferSize/14336);return a>5?void 0:i/a}))}static _estimateRTTByOriginViaSendStartTiming(e){return NetworkAnalyzer._estimateValueByOrigin(e,(({record:e,timing:t,connectionReused:n})=>{if(n)return;if(!Number.isFinite(t.sendStart)||t.sendStart<0)return;let i=2;return"https"===e.parsedURL.scheme&&(i+=1),t.sendStart/i}))}static _estimateRTTByOriginViaHeadersEndTiming(e){return NetworkAnalyzer._estimateValueByOrigin(e,(({record:e,timing:t,connectionReused:n})=>{if(!Number.isFinite(t.receiveHeadersEnd)||t.receiveHeadersEnd<0)return;if(!e.resourceType)return;const i=s[e.resourceType]||.4,a=t.receiveHeadersEnd*i;let l=1;return n||(l+=1,"https"===e.parsedURL.scheme&&(l+=1),l+=1),Math.max((t.receiveHeadersEnd-a)/l,3)}))}
static _estimateResponseTimeByOrigin(e,t){return NetworkAnalyzer._estimateValueByOrigin(e,(({record:e,timing:n})=>{if(!Number.isFinite(n.receiveHeadersEnd)||n.receiveHeadersEnd<0)return;if(!Number.isFinite(n.sendEnd)||n.sendEnd<0)return;const i=n.receiveHeadersEnd-n.sendEnd,a=e.parsedURL.securityOrigin,s=t.get(a)||t.get(NetworkAnalyzer.SUMMARY)||0;return Math.max(i-s,0)}))}static canTrustConnectionInformation(e){const t=new Map;for(const n of e){const e=t.get(n.connectionId)||!n.connectionReused;t.set(n.connectionId,e)}return!(t.size<=1)&&Array.from(t.values()).every((e=>e))}static estimateIfConnectionWasReused(e,t){const{forceCoarseEstimates:n=!1}=t||{};if(!n&&NetworkAnalyzer.canTrustConnectionInformation(e))return new Map(e.map((e=>[e.requestId,!!e.connectionReused])));const i=new Map,a=NetworkAnalyzer.groupByOrigin(e);for(const[e,t]of a.entries()){const e=t.map((e=>e.endTime)).reduce(((e,t)=>Math.min(e,t)),1/0);for(const n of t)i.set(n.requestId,n.startTime>=e||"h2"===n.protocol)
;const n=t.reduce(((e,t)=>e.startTime>t.startTime?t:e));i.set(n.requestId,!1)}return i}static estimateRTTByOrigin(e,t){const{forceCoarseEstimates:n=!1,coarseEstimateMultiplier:i=.3,useDownloadEstimates:a=!0,useSendStartEstimates:s=!0,useHeadersEndEstimates:l=!0}=t||{};let c=NetworkAnalyzer._estimateRTTByOriginViaTCPTiming(e);if(!c.size||n){c=new Map;const t=NetworkAnalyzer._estimateRTTByOriginViaDownloadTiming(e),n=NetworkAnalyzer._estimateRTTByOriginViaSendStartTiming(e),u=NetworkAnalyzer._estimateRTTByOriginViaHeadersEndTiming(e);for(const[e,n]of t.entries())a&&c.set(e,n);for(const[e,t]of n.entries()){if(!s)continue;const n=c.get(e)||[];c.set(e,n.concat(t))}for(const[e,t]of u.entries()){if(!l)continue;const n=c.get(e)||[];c.set(e,n.concat(t))}for(const e of c.values())e.forEach(((t,n)=>e[n]=t*i))}if(!c.size)throw new Error("No timing information available");return NetworkAnalyzer.summarize(c)}static estimateServerResponseTimeByOrigin(e,t){let n=(t||{}).rttByOrigin;if(!n){n=new Map
;const i=NetworkAnalyzer.estimateRTTByOrigin(e,t);for(const[e,t]of i.entries())n.set(e,t.min)}const i=NetworkAnalyzer._estimateResponseTimeByOrigin(e,n);return NetworkAnalyzer.summarize(i)}static estimateThroughput(e){let t=0;const n=e.reduce(((e,n)=>("data"===(n.parsedURL&&n.parsedURL.scheme)||n.failed||!n.finished||n.statusCode>300||!n.transferSize||(t+=n.transferSize,e.push({time:n.responseReceivedTime,isStart:!0}),e.push({time:n.endTime,isStart:!1})),e)),[]).sort(((e,t)=>e.time-t.time));if(!n.length)return 1/0;let i=0,a=0,s=0;return n.forEach((e=>{e.isStart?(0===i&&(a=e.time),i++):(i--,0===i&&(s+=e.time-a))})),8*t/s}static findMainDocument(e,t){if(t){const n=e.find((e=>t.startsWith(e.url)&&a.equalWithExcludedFragments(e.url,t)));if(n)return n}const n=e.filter((e=>e.resourceType===i.TYPES.Document));if(!n.length)throw new Error("Unable to identify the main resource");return n.reduce(((e,t)=>t.startTime<e.startTime?t:e))}static resolveRedirects(e){
for(;e.redirectDestination;)e=e.redirectDestination;return e}}t.exports=NetworkAnalyzer},{"../../network-request.js":96,"../../url-shim.js":"url"}],80:[function(e,t,n){"use strict";const i=e("../base-node.js");t.exports=class SimulatorTimingMap{constructor(){this._nodeTimings=new Map}getNodes(){return Array.from(this._nodeTimings.keys())}setReadyToStart(e,t){this._nodeTimings.set(e,t)}setInProgress(e,t){const n={...this.getQueued(e),startTime:t.startTime,timeElapsed:0};this._nodeTimings.set(e,e.type===i.TYPES.NETWORK?{...n,timeElapsedOvershoot:0,bytesDownloaded:0}:n)}setCompleted(e,t){const n={...this.getInProgress(e),endTime:t.endTime};this._nodeTimings.set(e,n)}setCpu(e,t){const n={...this.getCpuStarted(e),timeElapsed:t.timeElapsed};this._nodeTimings.set(e,n)}setCpuEstimated(e,t){const n={...this.getCpuStarted(e),estimatedTimeElapsed:t.estimatedTimeElapsed};this._nodeTimings.set(e,n)}setNetwork(e,t){const n={...this.getNetworkStarted(e),timeElapsed:t.timeElapsed,
timeElapsedOvershoot:t.timeElapsedOvershoot,bytesDownloaded:t.bytesDownloaded};this._nodeTimings.set(e,n)}setNetworkEstimated(e,t){const n={...this.getNetworkStarted(e),estimatedTimeElapsed:t.estimatedTimeElapsed};this._nodeTimings.set(e,n)}getQueued(e){const t=this._nodeTimings.get(e);if(!t)throw new Error(`Node ${e.id} not yet queued`);return t}getCpuStarted(e){const t=this._nodeTimings.get(e);if(!t)throw new Error(`Node ${e.id} not yet queued`);if(!("startTime"in t))throw new Error(`Node ${e.id} not yet started`);if("bytesDownloaded"in t)throw new Error(`Node ${e.id} timing not valid`);return t}getNetworkStarted(e){const t=this._nodeTimings.get(e);if(!t)throw new Error(`Node ${e.id} not yet queued`);if(!("startTime"in t))throw new Error(`Node ${e.id} not yet started`);if(!("bytesDownloaded"in t))throw new Error(`Node ${e.id} timing not valid`);return t}getInProgress(e){const t=this._nodeTimings.get(e);if(!t)throw new Error(`Node ${e.id} not yet queued`)
;if(!("startTime"in t))throw new Error(`Node ${e.id} not yet started`);if(!("estimatedTimeElapsed"in t))throw new Error(`Node ${e.id} not yet in progress`);return t}getCompleted(e){const t=this._nodeTimings.get(e);if(!t)throw new Error(`Node ${e.id} not yet queued`);if(!("startTime"in t))throw new Error(`Node ${e.id} not yet started`);if(!("estimatedTimeElapsed"in t))throw new Error(`Node ${e.id} not yet in progress`);if(!("endTime"in t))throw new Error(`Node ${e.id} not yet completed`);return t}}},{"../base-node.js":74}],81:[function(e,t,n){"use strict";const i=e("../base-node.js"),a=e("./tcp-connection.js"),s=e("./connection-pool.js"),l=e("./dns-cache.js"),c=e("../../../config/constants.js").throttling.mobileSlow4G,u=e("./simulator-timing-map.js"),d={NotReadyToStart:0,ReadyToStart:1,InProgress:2,Complete:3},m={VeryHigh:0,High:.25,Medium:.5,Low:1,VeryLow:2},p=new Map;class Simulator{constructor(e){if(this._options=Object.assign({rtt:c.rttMs,throughput:1024*c.throughputKbps,
maximumConcurrentRequests:10,cpuSlowdownMultiplier:c.cpuSlowdownMultiplier,layoutTaskMultiplier:.5,additionalRttByOrigin:new Map,serverResponseTimeByOrigin:new Map},e),this._rtt=this._options.rtt,this._throughput=this._options.throughput,this._maximumConcurrentRequests=Math.max(Math.min(a.maximumSaturatedConnections(this._rtt,this._throughput),this._options.maximumConcurrentRequests),1),this._cpuSlowdownMultiplier=this._options.cpuSlowdownMultiplier,this._layoutTaskMultiplier=this._cpuSlowdownMultiplier*this._options.layoutTaskMultiplier,this._cachedNodeListByStartPosition=[],this._flexibleOrdering=!1,this._nodeTimings=new u,this._numberInProgressByType=new Map,this._nodes={},this._dns=new l({rtt:this._rtt}),this._connectionPool=null,!Number.isFinite(this._rtt))throw new Error("Invalid rtt "+this._rtt);if(!Number.isFinite(this._throughput))throw new Error("Invalid rtt "+this._throughput)}get rtt(){return this._rtt}_initializeConnectionPool(e){const t=[];e.getRootNode().traverse((e=>{
e.type===i.TYPES.NETWORK&&t.push(e.record)})),this._connectionPool=new s(t,this._options)}_initializeAuxiliaryData(){this._nodeTimings=new u,this._numberInProgressByType=new Map,this._nodes={},this._cachedNodeListByStartPosition=[];for(const e of Object.values(d))this._nodes[e]=new Set}_numberInProgress(e){return this._numberInProgressByType.get(e)||0}_markNodeAsReadyToStart(e,t){const n=Simulator._computeNodeStartPosition(e),i=this._cachedNodeListByStartPosition.findIndex((e=>Simulator._computeNodeStartPosition(e)>n)),a=-1===i?this._cachedNodeListByStartPosition.length:i;this._cachedNodeListByStartPosition.splice(a,0,e),this._nodes[d.ReadyToStart].add(e),this._nodes[d.NotReadyToStart].delete(e),this._nodeTimings.setReadyToStart(e,{queuedTime:t})}_markNodeAsInProgress(e,t){const n=this._cachedNodeListByStartPosition.indexOf(e);this._cachedNodeListByStartPosition.splice(n,1),this._nodes[d.InProgress].add(e),this._nodes[d.ReadyToStart].delete(e),
this._numberInProgressByType.set(e.type,this._numberInProgress(e.type)+1),this._nodeTimings.setInProgress(e,{startTime:t})}_markNodeAsComplete(e,t){this._nodes[d.Complete].add(e),this._nodes[d.InProgress].delete(e),this._numberInProgressByType.set(e.type,this._numberInProgress(e.type)-1),this._nodeTimings.setCompleted(e,{endTime:t});for(const n of e.getDependents()){n.getDependencies().some((e=>!this._nodes[d.Complete].has(e)))||this._markNodeAsReadyToStart(n,t)}}_acquireConnection(e){return this._connectionPool.acquire(e,{ignoreConnectionReused:this._flexibleOrdering})}_getNodesSortedByStartPosition(){return Array.from(this._cachedNodeListByStartPosition)}_startNodeIfPossible(e,t){if(e.type!==i.TYPES.CPU){if(e.type!==i.TYPES.NETWORK)throw new Error("Unsupported");if(!e.isConnectionless){if(this._numberInProgress(e.type)>=this._maximumConcurrentRequests)return;if(!this._acquireConnection(e.record))return}this._markNodeAsInProgress(e,t)
}else 0===this._numberInProgress(e.type)&&this._markNodeAsInProgress(e,t)}_updateNetworkCapacity(){for(const e of this._connectionPool.connectionsInUse())e.setThroughput(this._throughput/this._nodes[d.InProgress].size)}_estimateTimeRemaining(e){if(e.type===i.TYPES.CPU)return this._estimateCPUTimeRemaining(e);if(e.type===i.TYPES.NETWORK)return this._estimateNetworkTimeRemaining(e);throw new Error("Unsupported")}_estimateCPUTimeRemaining(e){const t=this._nodeTimings.getCpuStarted(e),n=e.didPerformLayout()?this._layoutTaskMultiplier:this._cpuSlowdownMultiplier,i=Math.min(Math.round(e.event.dur/1e3*n),1e4)-t.timeElapsed;return this._nodeTimings.setCpuEstimated(e,{estimatedTimeElapsed:i}),i}_estimateNetworkTimeRemaining(e){const t=e.record,n=this._nodeTimings.getNetworkStarted(e);let i=0;if(e.fromDiskCache){i=8+20*((t.resourceSize||0)/1024/1024)-n.timeElapsed}else if(e.isNonNetworkProtocol){i=2+10*((t.resourceSize||0)/1024/1024)-n.timeElapsed}else{
const e=this._connectionPool.acquireActiveConnectionFromRecord(t),a=this._dns.getTimeUntilResolution(t,{requestedAt:n.startTime,shouldUpdateCache:!0}),s=n.timeElapsed;i=e.simulateDownloadUntil(t.transferSize-n.bytesDownloaded,{timeAlreadyElapsed:s,dnsResolutionTime:a,maximumTimeToElapse:1/0}).timeElapsed}const a=i+n.timeElapsedOvershoot;return this._nodeTimings.setNetworkEstimated(e,{estimatedTimeElapsed:a}),a}_findNextNodeCompletionTime(){let e=1/0;for(const t of this._nodes[d.InProgress])e=Math.min(e,this._estimateTimeRemaining(t));return e}_updateProgressMadeInTimePeriod(e,t,n){const a=this._nodeTimings.getInProgress(e),s=a.estimatedTimeElapsed===t;if(e.type===i.TYPES.CPU||e.isConnectionless)return s?this._markNodeAsComplete(e,n):a.timeElapsed+=t;if(e.type!==i.TYPES.NETWORK)throw new Error("Unsupported");if(!("bytesDownloaded"in a))throw new Error("Invalid timing data")
;const l=e.record,c=this._connectionPool.acquireActiveConnectionFromRecord(l),u=this._dns.getTimeUntilResolution(l,{requestedAt:a.startTime,shouldUpdateCache:!0}),d=c.simulateDownloadUntil(l.transferSize-a.bytesDownloaded,{dnsResolutionTime:u,timeAlreadyElapsed:a.timeElapsed,maximumTimeToElapse:t-a.timeElapsedOvershoot});c.setCongestionWindow(d.congestionWindow),c.setH2OverflowBytesDownloaded(d.extraBytesDownloaded),s?(c.setWarmed(!0),this._connectionPool.release(l),this._markNodeAsComplete(e,n)):(a.timeElapsed+=d.timeElapsed,a.timeElapsedOvershoot+=d.timeElapsed-t,a.bytesDownloaded+=d.bytesDownloaded)}_computeFinalNodeTimings(){const e=[];for(const t of this._nodeTimings.getNodes()){const n=this._nodeTimings.getCompleted(t);e.push([t,{startTime:n.startTime,endTime:n.endTime,duration:n.endTime-n.startTime}])}return e.sort(((e,t)=>e[1].startTime-t[1].startTime)),new Map(e)}getOptions(){return this._options}simulate(e,t){
if(i.hasCycle(e))throw new Error("Cannot simulate graph with cycle");t=Object.assign({label:void 0,flexibleOrdering:!1},t),this._flexibleOrdering=!!t.flexibleOrdering,this._dns=new l({rtt:this._rtt}),this._initializeConnectionPool(e),this._initializeAuxiliaryData();const n=this._nodes[d.NotReadyToStart],a=this._nodes[d.ReadyToStart],s=this._nodes[d.InProgress],c=e.getRootNode();c.traverse((e=>n.add(e)));let u=0,m=0;for(this._markNodeAsReadyToStart(c,u);a.size||s.size;){for(const e of this._getNodesSortedByStartPosition())this._startNodeIfPossible(e,u);if(!s.size){if(this._flexibleOrdering)throw new Error("Failed to start a node");this._flexibleOrdering=!0;continue}this._updateNetworkCapacity();const e=this._findNextNodeCompletionTime();if(u+=e,!Number.isFinite(e)||m>1e5)throw new Error("Simulation failed, depth exceeded");m++;for(const t of s)this._updateProgressMadeInTimePeriod(t,e,u)}const h=this._computeFinalNodeTimings();return p.set(t.label||"unlabeled",h),{timeInMs:u,
nodeTimings:h}}static get ALL_NODE_TIMINGS(){return p}static _computeNodeStartPosition(e){return"cpu"===e.type?e.startTime:e.startTime+(1e3*m[e.record.priority]*1e3||0)}}t.exports=Simulator},{"../../../config/constants.js":56,"../base-node.js":74,"./connection-pool.js":77,"./dns-cache.js":78,"./simulator-timing-map.js":80,"./tcp-connection.js":82}],82:[function(e,t,n){"use strict";const i=1460;class TcpConnection{constructor(e,t,n=0,i=!0,a=!1){this._warmed=!1,this._ssl=i,this._h2=a,this._rtt=e,this._throughput=t,this._serverLatency=n,this._congestionWindow=10,this._h2OverflowBytesDownloaded=0}static maximumSaturatedConnections(e,t){const n=8*(1460*(1e3/e));return Math.floor(t/n)}_computeMaximumCongestionWindowInSegments(){const e=this._throughput/8*(this._rtt/1e3);return Math.floor(e/i)}setThroughput(e){this._throughput=e}setCongestionWindow(e){this._congestionWindow=e}setWarmed(e){this._warmed=e}isWarm(){return this._warmed}isH2(){return this._h2}get congestionWindow(){
return this._congestionWindow}setH2OverflowBytesDownloaded(e){this._h2&&(this._h2OverflowBytesDownloaded=e)}clone(){return Object.assign(new TcpConnection(this._rtt,this._throughput),this)}simulateDownloadUntil(e,t){const{timeAlreadyElapsed:n=0,maximumTimeToElapse:a=1/0,dnsResolutionTime:s=0}=t||{};this._warmed&&this._h2&&(e-=this._h2OverflowBytesDownloaded);const l=this._rtt,c=l/2,u=this._computeMaximumCongestionWindowInSegments();let d=c;this._warmed||(d=s+c+c+c+(this._ssl?l:0));let m=Math.ceil(d/l),p=d+this._serverLatency+c;this._warmed&&this._h2&&(p=0);const h=Math.max(p-n,0),f=a-h;let g=Math.min(this._congestionWindow,u),y=0;h>0?y=g*i:m=0;let b=0,v=e-y;for(;v>0&&b<=f;){m++,b+=l,g=Math.max(Math.min(u,2*g),1);const e=g*i;y+=e,v-=e}const w=h+b,T=this._h2?Math.max(y-e,0):0;return{roundTrips:m,timeElapsed:w,bytesDownloaded:Math.max(Math.min(y,e),0),extraBytesDownloaded:T,congestionWindow:g}}}t.exports=TcpConnection},{}],83:[function(e,t,n){"use strict";const i={offline:!0,latency:0,
downloadThroughput:0,uploadThroughput:0},a={latency:0,downloadThroughput:0,uploadThroughput:0,offline:!1},s={rate:1};t.exports={emulate:async function emulate(e,t){if(!1!==t.emulatedUserAgent&&(await e.sendCommand("Network.enable"),await e.sendCommand("Network.setUserAgentOverride",{userAgent:t.emulatedUserAgent})),!0!==t.screenEmulation.disabled){const{width:n,height:i,deviceScaleFactor:a,mobile:s}=t.screenEmulation,l={width:n,height:i,deviceScaleFactor:a,mobile:s};await e.sendCommand("Emulation.setDeviceMetricsOverride",l),await e.sendCommand("Emulation.setTouchEmulationEnabled",{enabled:l.mobile})}},enableNetworkThrottling:function enableNetworkThrottling(e,t){const n={offline:!1,latency:t.requestLatencyMs||0,downloadThroughput:t.downloadThroughputKbps||0,uploadThroughput:t.uploadThroughputKbps||0};return n.downloadThroughput=Math.floor(1024*n.downloadThroughput/8),n.uploadThroughput=Math.floor(1024*n.uploadThroughput/8),e.sendCommand("Network.emulateNetworkConditions",n)},
clearAllNetworkEmulation:function clearAllNetworkEmulation(e){return e.sendCommand("Network.emulateNetworkConditions",a)},enableCPUThrottling:function enableCPUThrottling(e,t){const n=t.cpuSlowdownMultiplier;return e.sendCommand("Emulation.setCPUThrottlingRate",{rate:n})},disableCPUThrottling:function disableCPUThrottling(e){return e.sendCommand("Emulation.setCPUThrottlingRate",s)},goOffline:function goOffline(e){return e.sendCommand("Network.emulateNetworkConditions",i)}}},{}],84:[function(e,t,n){(function(n,i){"use strict";const a=e("path"),s=e("intl-messageformat").default,l=e("lookup-closest-locale"),c=e("./locales.js"),{isObjectOfUnknownValues:u,isObjectOrArrayOfUnknownValues:d}=e("../type-verifiers.js"),m=a.join(i,"../../../"),p=/ | [^\s]+$/;(()=>{e("intl-pluralrules");const t=e("intl");if(!t.NumberFormat)return;const n=["en","es","ru","zh"];Intl.NumberFormat.supportedLocalesOf(n).length!==n.length&&(Intl.NumberFormat=t.NumberFormat,Intl.DateTimeFormat=t.DateTimeFormat)})()
;const h={ms:"{timeInMs, number, milliseconds} ms",seconds:"{timeInMs, number, seconds} s",displayValueByteSavings:"Potential savings of {wastedBytes, number, bytes} KiB",displayValueMsSavings:"Potential savings of {wastedMs, number, milliseconds} ms",displayValueElementsFound:"{nodeCount, plural, =1 {1 element found} other {# elements found}}",columnURL:"URL",columnSize:"Size",columnResourceSize:"Resource Size",columnTransferSize:"Transfer Size",columnCacheTTL:"Cache TTL",columnWastedBytes:"Potential Savings",columnWastedMs:"Potential Savings",columnBlockingTime:"Main-Thread Blocking Time",columnTimeSpent:"Time Spent",columnLocation:"Location",columnResourceType:"Resource Type",columnRequests:"Requests",columnName:"Name",columnSource:"Source",columnOverBudget:"Over Budget",columnElement:"Element",columnStartTime:"Start Time",columnDuration:"Duration",columnFailingElem:"Failing Elements",columnDescription:"Description",totalResourceType:"Total",documentResourceType:"Document",
scriptResourceType:"Script",stylesheetResourceType:"Stylesheet",imageResourceType:"Image",mediaResourceType:"Media",fontResourceType:"Font",otherResourceType:"Other",thirdPartyResourceType:"Third-party",otherResourcesLabel:"Other resources",firstContentfulPaintMetric:"First Contentful Paint",firstCPUIdleMetric:"First CPU Idle",interactiveMetric:"Time to Interactive",firstMeaningfulPaintMetric:"First Meaningful Paint",estimatedInputLatencyMetric:"Estimated Input Latency",totalBlockingTimeMetric:"Total Blocking Time",maxPotentialFIDMetric:"Max Potential First Input Delay",speedIndexMetric:"Speed Index",largestContentfulPaintMetric:"Largest Contentful Paint",cumulativeLayoutShiftMetric:"Cumulative Layout Shift"},f={number:{bytes:{maximumFractionDigits:0},milliseconds:{maximumFractionDigits:0},seconds:{minimumFractionDigits:1,maximumFractionDigits:1},extendedPercent:{maximumFractionDigits:2,style:"percent"}}};function collectAllCustomElementsFromICU(e,t=new Map){
for(const n of e)if("argumentElement"===n.type&&(t.set(n.id,n),n.format&&"pluralFormat"===n.format.type))for(const e of n.format.options)collectAllCustomElementsFromICU(e.value.elements,t);return t}function _formatMessage(e,t={},n){const i=new s(e,"en-XA"===n||"en-XL"===n?"de-DE":n,f),a=function _preformatValues(e,t,n){const i=[...collectAllCustomElementsFromICU(e.getAst().elements).values()],a={};for(const{id:e,format:s}of i){if(e&&e in t==0)throw new Error(`ICU Message "${n}" contains a value reference ("${e}") that wasn't provided`);const i=t[e];if(s&&"numberFormat"===s.type){if("number"!=typeof i)throw new Error(`ICU Message "${n}" contains a numeric reference ("${e}") but provided value was not a number`);"milliseconds"===s.style?a[e]=10*Math.round(i/10):"seconds"===s.style&&"timeInMs"===e?a[e]=Math.round(i/100)/10:"bytes"===s.style?a[e]=i/1024:a[e]=i}else a[e]=i}for(const e of Object.keys(t))if(!(e in a)){
if("errorCode"!==e)throw new Error(`Provided value "${e}" does not match any placeholder in ICU message "${n}"`);a.errorCode=t.errorCode}return a}(i,t,e);return i.format(a)}function _localizeIcuMessage(e,t){const n=c[t];if(!n)throw new Error(`Unsupported locale '${t}'`);const i=n[e.i18nId];return i?_formatMessage(i.message,e.values,t):e.formattedDefault}function _formatPathAsString(e){let t="";for(const n of e)if(/^[a-z]+$/i.test(n))t.length&&(t+="."),t+=n;else{if(/]|"|'|\s/.test(n))throw new Error(`Cannot handle "${n}" in i18n`);t+=`[${n}]`}return t}function createIcuMessageFn(e,t){const i={...h,...t};return(s,l)=>{const c=Object.keys(i).find((e=>i[e]===s));if(!c)throw new Error("Could not locate: "+s);const u=c in t?e:n;return{i18nId:`${a.relative(m,u).replace(/\\/g,"/")} | ${c}`,values:l,formattedDefault:_formatMessage(s,l,"en")}}}function isIcuMessage(e){if(!u(e))return!1;const{i18nId:t,values:n,formattedDefault:i}=e;if("string"!=typeof t)return!1;if("string"!=typeof i)return!1
;if(void 0!==n){if(!u(n))return!1;for(const e of Object.values(n))if("string"!=typeof e&&"number"!=typeof e)return!1}return p.test(t)}t.exports={_formatPathAsString,UIStrings:h,lookupLocale:function lookupLocale(e){const t=Intl.getCanonicalLocales(e);return l(t,c)||"en"},getRendererFormattedStrings:function getRendererFormattedStrings(e){const t=c[e];if(!t)throw new Error(`Unsupported locale '${e}'`);const n=Object.keys(t).filter((e=>e.includes("core/report/html/"))),i={};for(const e of n){const[n,a]=e.split(" | ");if(!n.endsWith("util.js"))throw new Error("Unexpected message: "+e);i[a]=t[e].message}return i},createIcuMessageFn,getFormatted:function getFormatted(e,t){if(isIcuMessage(e))return _localizeIcuMessage(e,t);if("string"==typeof e)return e;throw new Error("Attempted to format invalid icuMessage type")},replaceIcuMessages:function replaceIcuMessages(e,t){const n={};return function replaceInObject(e,n,i=[]){if(d(e))for(const[a,s]of Object.entries(e)){const l=i.concat([a])
;if(isIcuMessage(s)){const i=_localizeIcuMessage(s,t),c=n[s.i18nId]||[],u=_formatPathAsString(l);c.push(s.values?{values:s.values,path:u}:u),e[a]=i,n[s.i18nId]=c}else replaceInObject(s,n,l)}}(e,n),n},isIcuMessage,collectAllCustomElementsFromICU,registerLocaleData:function registerLocaleData(e,t){c[e]=t},isStringOrIcuMessage:function isStringOrIcuMessage(e){return"string"==typeof e||isIcuMessage(e)},createMessageInstanceIdFn:createIcuMessageFn}}).call(this,"/lighthouse-core/lib/i18n/i18n.js","/lighthouse-core/lib/i18n")},{"../type-verifiers.js":109,"./locales.js":85,intl:129,"intl-messageformat":145,"intl-pluralrules":129,"lookup-closest-locale":177,path:188}],85:[function(e,t,n){"use strict";const i={"en-US":e("./locales/en-US.json"),en:e("./locales/en-US.json"),"en-AU":e("./locales/en-GB.json"),"en-GB":e("./locales/en-GB.json"),"en-IE":e("./locales/en-GB.json"),"en-SG":e("./locales/en-GB.json"),"en-ZA":e("./locales/en-GB.json"),"en-IN":e("./locales/en-GB.json"),
"ar-XB":e("./locales/ar-XB.json"),ar:e("./locales/ar.json"),bg:e("./locales/bg.json"),ca:e("./locales/ca.json"),cs:e("./locales/cs.json"),da:e("./locales/da.json"),de:e("./locales/de.json"),el:e("./locales/el.json"),"en-XA":e("./locales/en-XA.json"),"en-XL":e("./locales/en-XL.json"),es:e("./locales/es.json"),"es-419":e("./locales/es-419.json"),"es-AR":e("./locales/es-419.json"),"es-BO":e("./locales/es-419.json"),"es-BR":e("./locales/es-419.json"),"es-BZ":e("./locales/es-419.json"),"es-CL":e("./locales/es-419.json"),"es-CO":e("./locales/es-419.json"),"es-CR":e("./locales/es-419.json"),"es-CU":e("./locales/es-419.json"),"es-DO":e("./locales/es-419.json"),"es-EC":e("./locales/es-419.json"),"es-GT":e("./locales/es-419.json"),"es-HN":e("./locales/es-419.json"),"es-MX":e("./locales/es-419.json"),"es-NI":e("./locales/es-419.json"),"es-PA":e("./locales/es-419.json"),"es-PE":e("./locales/es-419.json"),"es-PR":e("./locales/es-419.json"),"es-PY":e("./locales/es-419.json"),
"es-SV":e("./locales/es-419.json"),"es-US":e("./locales/es-419.json"),"es-UY":e("./locales/es-419.json"),"es-VE":e("./locales/es-419.json"),fi:e("./locales/fi.json"),fil:e("./locales/fil.json"),fr:e("./locales/fr.json"),he:e("./locales/he.json"),hi:e("./locales/hi.json"),hr:e("./locales/hr.json"),hu:e("./locales/hu.json"),gsw:e("./locales/de.json"),id:e("./locales/id.json"),in:e("./locales/id.json"),it:e("./locales/it.json"),iw:e("./locales/he.json"),ja:e("./locales/ja.json"),ko:e("./locales/ko.json"),lt:e("./locales/lt.json"),lv:e("./locales/lv.json"),mo:e("./locales/ro.json"),nl:e("./locales/nl.json"),nb:e("./locales/no.json"),no:e("./locales/no.json"),pl:e("./locales/pl.json"),pt:e("./locales/pt.json"),"pt-PT":e("./locales/pt-PT.json"),ro:e("./locales/ro.json"),ru:e("./locales/ru.json"),sk:e("./locales/sk.json"),sl:e("./locales/sl.json"),sr:e("./locales/sr.json"),"sr-Latn":e("./locales/sr-Latn.json"),sv:e("./locales/sv.json"),ta:e("./locales/ta.json"),te:e("./locales/te.json"),
th:e("./locales/th.json"),tl:e("./locales/fil.json"),tr:e("./locales/tr.json"),uk:e("./locales/uk.json"),vi:e("./locales/vi.json"),zh:e("./locales/zh.json"),"zh-HK":e("./locales/zh-HK.json"),"zh-TW":e("./locales/zh-TW.json")};t.exports=i},{"./locales/ar-XB.json":129,"./locales/ar.json":129,"./locales/bg.json":129,"./locales/ca.json":129,"./locales/cs.json":129,"./locales/da.json":129,"./locales/de.json":129,"./locales/el.json":129,"./locales/en-GB.json":129,"./locales/en-US.json":129,"./locales/en-XA.json":129,"./locales/en-XL.json":129,"./locales/es-419.json":129,"./locales/es.json":129,"./locales/fi.json":129,"./locales/fil.json":129,"./locales/fr.json":129,"./locales/he.json":129,"./locales/hi.json":129,"./locales/hr.json":129,"./locales/hu.json":129,"./locales/id.json":129,"./locales/it.json":129,"./locales/ja.json":129,"./locales/ko.json":129,"./locales/lt.json":129,"./locales/lv.json":129,"./locales/nl.json":129,"./locales/no.json":129,"./locales/pl.json":129,
"./locales/pt-PT.json":129,"./locales/pt.json":129,"./locales/ro.json":129,"./locales/ru.json":129,"./locales/sk.json":129,"./locales/sl.json":129,"./locales/sr-Latn.json":129,"./locales/sr.json":129,"./locales/sv.json":129,"./locales/ta.json":129,"./locales/te.json":129,"./locales/th.json":129,"./locales/tr.json":129,"./locales/uk.json":129,"./locales/vi.json":129,"./locales/zh-HK.json":129,"./locales/zh-TW.json":129,"./locales/zh.json":129}],86:[function(e,t,n){"use strict";const i=e("./url-shim.js");t.exports={doExist:function doExist(e){return!(!e||!e.icons)&&0!==e.icons.value.length},pngSizedAtLeast:function pngSizedAtLeast(e,t){const n=t.icons.value,a=[];return n.filter((e=>{const t=e.value.type.value;if(t)return"image/png"===t;const n=e.value.src.value;return n&&new i(n).pathname.endsWith(".png")})).forEach((e=>{e.value.sizes.value&&a.push(...e.value.sizes.value)})),a.filter((e=>/\d+x\d+/.test(e))).filter((t=>{const n=t.split(/x/i),i=[parseFloat(n[0]),parseFloat(n[1])]
;return i[0]>=e&&i[1]>=e&&i[0]===i[1]}))},containsMaskableIcon:function containsMaskableIcon(e){return e.icons.value.some((e=>e.value.purpose&&e.value.purpose.value&&e.value.purpose.value.includes("maskable")))}}},{"./url-shim.js":"url"}],87:[function(e,t,n){"use strict";t.exports={simulationNamesToIgnore:["unlabeled","optimisticFirstCPUIdle","optimisticFlexFirstCPUIdle","pessimisticFirstCPUIdle","optimisticSpeedIndex","optimisticFlexSpeedIndex","pessimisticSpeedIndex","optimisticEstimatedInputLatency","optimisticFlexEstimatedInputLatency","pessimisticEstimatedInputLatency"],convertNodeTimingsToTrace:function convertNodeTimingsToTrace(e){const t=[],n=1e9,i={pid:1,tid:1,cat:"devtools.timeline"},a="A00001",toMicroseconds=e=>n+1e3*e;t.push(createFakeTracingStartedEvent()),t.push({...createFakeTracingStartedEvent(),name:"TracingStartedInBrowser"});let s=1,l=0;for(const[n,i]of e.entries())if(l=Math.max(l,i.endTime),"cpu"===n.type)t.push(...createFakeTaskEvents(n,i));else{
if(/^data/.test(n.record.url))continue;t.push(...createFakeNetworkEvents(n.record,i))}return t.push(...createFakeTaskEvents({childEvents:[],event:{}},{startTime:l+1e3,endTime:l+1001})),{traceEvents:t};function createFakeTracingStartedEvent(){const e={frameTreeNodeId:1,sessionId:"1.1",page:a,persistentIds:!0,frames:[{frame:a,url:"about:blank",name:"",processId:1}]};return{...i,ts:9999e5,ph:"I",s:"t",cat:"disabled-by-default-devtools.timeline",name:"TracingStartedInPage",args:{data:e},dur:0}}function createFakeTaskEvents(e,t){const n={url:"",frame:a,lineNumber:0,columnNumber:0},s=toMicroseconds(t.startTime),l=[{...i,ph:"X",name:"Task",ts:s,dur:1e3*(t.endTime-t.startTime),args:{data:n}}],c=e.event.ts||0,u=1e3*(t.endTime-t.startTime)/e.event.dur,d=new Set(["ResourceSendRequest","ResourceFinish","ResourceReceiveResponse","ResourceReceivedData"]);for(const t of e.childEvents){if(d.has(t.name))continue;const e=s+(t.ts-c)*u,n={...t,pid:i.pid,tid:i.tid,ts:e};t.dur&&(n.dur=t.dur*u),l.push(n)}
return l}function createFakeNetworkEvents(e,t){s++;let{startTime:n,endTime:l}=t;n===l&&(l+=.3);const c={requestId:s.toString(),frame:a},u={...i,ph:"I",s:"t",dur:0},d={...c,requestMethod:e.requestMethod,url:e.url,priority:e.priority},m={...c,statusCode:e.statusCode,mimeType:e.mimeType,encodedDataLength:e.transferSize,fromCache:e.fromDiskCache,fromServiceWorker:e.fetchedViaServiceWorker},p={...c,decodedBodyLength:e.resourceSize,didFail:!!e.failed,finishTime:l},h=[{...u,name:"ResourceSendRequest",ts:toMicroseconds(n),args:{data:d}},{...u,name:"ResourceFinish",ts:toMicroseconds(l),args:{data:p}}];return e.failed||h.push({...u,name:"ResourceReceiveResponse",ts:toMicroseconds((n+l)/2),args:{data:m}}),h}}}},{}],88:[function(e,t,n){t.exports={moment:{repository:"https://github.com/moment/moment.git",lastScraped:1597344573775,versions:{latest:{gzip:72054},"2.25.3":{gzip:71090},"2.25.2":{gzip:71119},"2.25.1":{gzip:20811},"2.25.0":{gzip:20876},"2.24.0":{gzip:67489},"2.23.0":{gzip:66675},
"2.22.2":{gzip:65962},"2.22.1":{gzip:65949}}},"date-fns":{repository:"https://github.com/date-fns/date-fns.git",lastScraped:1597344603463,versions:{latest:{gzip:18463}}},luxon:{repository:"https://github.com/moment/luxon.git",lastScraped:1597344608583,versions:{latest:{gzip:20912}}},dayjs:{repository:"https://github.com/iamkun/dayjs.git",lastScraped:1597344613371,versions:{latest:{gzip:2856}}}}},{}],89:[function(e,t,n){"use strict";t.exports={suggestions:{moment:["date-fns","luxon","dayjs"]}}},{}],90:[function(e,t,n){"use strict";e("../gather/driver.js");t.exports=class LHElement{constructor(e,t){if(!e||!t)throw Error("Driver and element required to create Element");this.driver=t,this.element=e}getAttribute(e){return this.driver.sendCommand("DOM.getAttributes",{nodeId:this.element.nodeId}).then((t=>{const n=t.attributes.indexOf(e);return-1===n?null:t.attributes[n+1]}))}getNodeId(){return this.element.nodeId}getProperty(e){return this.driver.sendCommand("DOM.resolveNode",{
nodeId:this.element.nodeId}).then((t=>t.object.objectId?this.driver.getObjectProperty(t.object.objectId,e):null)).catch((()=>null))}}},{"../gather/driver.js":61}],91:[function(e,t,n){(function(e){"use strict";t.exports={isUnderTest:!!e.env.CI||"test"===e.env.NODE_ENV}}).call(this,e("_process"))},{_process:190}],92:[function(e,t,n){(function(n){"use strict";const i={didntCollectScreenshots:"Chrome didn't collect any screenshots during the page load. Please make sure there is content visible on the page, and then try re-running Lighthouse. ({errorCode})",badTraceRecording:"Something went wrong with recording the trace over your page load. Please run Lighthouse again. ({errorCode})",noFcp:"The page did not paint any content. Please ensure you keep the browser window in the foreground during the load and try again. ({errorCode})",
pageLoadTookTooLong:"Your page took too long to load. Please follow the opportunities in the report to reduce your page load time, and then try re-running Lighthouse. ({errorCode})",pageLoadFailed:"Lighthouse was unable to reliably load the page you requested. Make sure you are testing the correct URL and that the server is properly responding to all requests.",pageLoadFailedWithStatusCode:"Lighthouse was unable to reliably load the page you requested. Make sure you are testing the correct URL and that the server is properly responding to all requests. (Status code: {statusCode})",pageLoadFailedWithDetails:"Lighthouse was unable to reliably load the page you requested. Make sure you are testing the correct URL and that the server is properly responding to all requests. (Details: {errorDetails})",pageLoadFailedInsecure:"The URL you have provided does not have a valid security certificate. {securityMessages}",
pageLoadFailedInterstitial:"Chrome prevented page load with an interstitial. Make sure you are testing the correct URL and that the server is properly responding to all requests.",internalChromeError:"An internal Chrome error occurred. Please restart Chrome and try re-running Lighthouse.",requestContentTimeout:"Fetching resource content has exceeded the allotted time",notHtml:"The page provided is not HTML (served as MIME type {mimeType}).",urlInvalid:"The URL you have provided appears to be invalid.",protocolTimeout:"Waiting for DevTools protocol response has exceeded the allotted time. (Method: {protocolMethod})",dnsFailure:"DNS servers could not resolve the provided domain.",pageLoadFailedHung:"Lighthouse was unable to reliably load the URL you requested because the page stopped responding.",criTimeout:"Timeout waiting for initial Debugger Protocol connection.",missingRequiredArtifact:"Required {artifactName} gatherer did not run.",
erroredRequiredArtifact:"Required {artifactName} gatherer encountered an error: {errorMessage}",oldChromeDoesNotSupportFeature:"This version of Chrome is too old to support '{featureName}'. Use a newer version to see full results."},a=e("./i18n/i18n.js").createMessageInstanceIdFn(n,i),s="__LighthouseErrorSentinel",l="__ErrorSentinel";class LighthouseError extends Error{constructor(e,t){super(e.code),this.name="LHError",this.code=e.code,this.friendlyMessage=a(e.message,{errorCode:this.code,...t}),this.lhrRuntimeError=!!e.lhrRuntimeError,t&&Object.assign(this,t),Error.captureStackTrace(this,LighthouseError)}static fromProtocolMessage(e,t){const n=Object.values(LighthouseError.errors).filter((e=>e.pattern)).find((e=>e.pattern&&e.pattern.test(t.message)));if(n)return new LighthouseError(n);let i=`(${e}): ${t.message}`;t.data&&(i+=` (${t.data})`);const a=new Error("Protocol error "+i);return Object.assign(a,{protocolMethod:e,protocolError:t.message})}static stringifyReplacer(e){
if(e instanceof LighthouseError){const{name:t,code:n,message:i,friendlyMessage:a,lhrRuntimeError:l,stack:c,...u}=e;return{sentinel:s,code:n,stack:c,...u}}if(e instanceof Error){const{message:t,stack:n}=e,i=e.code;return{sentinel:l,message:t,code:i,stack:n}}throw new Error("Invalid value for LHError stringification")}static parseReviver(e,t){if("object"==typeof t&&null!==t){if(t.sentinel===s){const{sentinel:e,code:n,stack:i,...a}=t,s=LighthouseError.errors[n],l=new LighthouseError(s,a);return l.stack=i,l}if(t.sentinel===l){const{message:e,code:n,stack:i}=t,a=new Error(e);return Object.assign(a,{code:n,stack:i}),a}}return t}}const c={NO_SPEEDLINE_FRAMES:{code:"NO_SPEEDLINE_FRAMES",message:i.didntCollectScreenshots,lhrRuntimeError:!0},SPEEDINDEX_OF_ZERO:{code:"SPEEDINDEX_OF_ZERO",message:i.didntCollectScreenshots,lhrRuntimeError:!0},NO_SCREENSHOTS:{code:"NO_SCREENSHOTS",message:i.didntCollectScreenshots,lhrRuntimeError:!0},INVALID_SPEEDLINE:{code:"INVALID_SPEEDLINE",
message:i.didntCollectScreenshots,lhrRuntimeError:!0},NO_TRACING_STARTED:{code:"NO_TRACING_STARTED",message:i.badTraceRecording,lhrRuntimeError:!0},NO_RESOURCE_REQUEST:{code:"NO_RESOURCE_REQUEST",message:i.badTraceRecording,lhrRuntimeError:!0},NO_NAVSTART:{code:"NO_NAVSTART",message:i.badTraceRecording,lhrRuntimeError:!0},NO_FCP:{code:"NO_FCP",message:i.noFcp,lhrRuntimeError:!0},NO_DCL:{code:"NO_DCL",message:i.badTraceRecording,lhrRuntimeError:!0},NO_FMP:{code:"NO_FMP",message:i.badTraceRecording},NO_LCP:{code:"NO_LCP",message:i.badTraceRecording},NO_LCP_ALL_FRAMES:{code:"NO_LCP_ALL_FRAMES",message:i.badTraceRecording},UNSUPPORTED_OLD_CHROME:{code:"UNSUPPORTED_OLD_CHROME",message:i.oldChromeDoesNotSupportFeature},LAYOUT_SHIFT_MISSING_DATA:{code:"LAYOUT_SHIFT_MISSING_DATA",message:i.badTraceRecording},FMP_TOO_LATE_FOR_FCPUI:{code:"FMP_TOO_LATE_FOR_FCPUI",message:i.pageLoadTookTooLong},NO_FCPUI_IDLE_PERIOD:{code:"NO_FCPUI_IDLE_PERIOD",message:i.pageLoadTookTooLong},
NO_TTI_CPU_IDLE_PERIOD:{code:"NO_TTI_CPU_IDLE_PERIOD",message:i.pageLoadTookTooLong},NO_TTI_NETWORK_IDLE_PERIOD:{code:"NO_TTI_NETWORK_IDLE_PERIOD",message:i.pageLoadTookTooLong},NO_DOCUMENT_REQUEST:{code:"NO_DOCUMENT_REQUEST",message:i.pageLoadFailed,lhrRuntimeError:!0},FAILED_DOCUMENT_REQUEST:{code:"FAILED_DOCUMENT_REQUEST",message:i.pageLoadFailedWithDetails,lhrRuntimeError:!0},ERRORED_DOCUMENT_REQUEST:{code:"ERRORED_DOCUMENT_REQUEST",message:i.pageLoadFailedWithStatusCode,lhrRuntimeError:!0},INSECURE_DOCUMENT_REQUEST:{code:"INSECURE_DOCUMENT_REQUEST",message:i.pageLoadFailedInsecure,lhrRuntimeError:!0},CHROME_INTERSTITIAL_ERROR:{code:"CHROME_INTERSTITIAL_ERROR",message:i.pageLoadFailedInterstitial,lhrRuntimeError:!0},PAGE_HUNG:{code:"PAGE_HUNG",message:i.pageLoadFailedHung,lhrRuntimeError:!0},NOT_HTML:{code:"NOT_HTML",message:i.notHtml,lhrRuntimeError:!0},TRACING_ALREADY_STARTED:{code:"TRACING_ALREADY_STARTED",message:i.internalChromeError,pattern:/Tracing.*started/,
lhrRuntimeError:!0},PARSING_PROBLEM:{code:"PARSING_PROBLEM",message:i.internalChromeError,pattern:/Parsing problem/,lhrRuntimeError:!0},READ_FAILED:{code:"READ_FAILED",message:i.internalChromeError,pattern:/Read failed/,lhrRuntimeError:!0},INVALID_URL:{code:"INVALID_URL",message:i.urlInvalid},PROTOCOL_TIMEOUT:{code:"PROTOCOL_TIMEOUT",message:i.protocolTimeout,lhrRuntimeError:!0},DNS_FAILURE:{code:"DNS_FAILURE",message:i.dnsFailure,lhrRuntimeError:!0},CRI_TIMEOUT:{code:"CRI_TIMEOUT",message:i.criTimeout,lhrRuntimeError:!0},MISSING_REQUIRED_ARTIFACT:{code:"MISSING_REQUIRED_ARTIFACT",message:i.missingRequiredArtifact},ERRORED_REQUIRED_ARTIFACT:{code:"ERRORED_REQUIRED_ARTIFACT",message:i.erroredRequiredArtifact}};LighthouseError.errors=c,LighthouseError.NO_ERROR="NO_ERROR",LighthouseError.UNKNOWN_ERROR="UNKNOWN_ERROR",t.exports=LighthouseError,t.exports.UIStrings=i}).call(this,"/lighthouse-core/lib/lh-error.js")},{"./i18n/i18n.js":84}],93:[function(e,t,n){"use strict"
;const i=e("./url-shim.js"),a=e("cssstyle/lib/parsers"),s=["fullscreen","standalone","minimal-ui","browser"],l="browser",c=["any","natural","landscape","portrait","portrait-primary","portrait-secondary","landscape-primary","landscape-secondary"];function parseString(e,t){let n,i;return"string"==typeof e?n=t?e.trim():e:(void 0!==e&&(i="ERROR: expected a string."),n=void 0),{raw:e,value:n,warning:i}}function parseColor(e){const t=parseString(e);return void 0===t.value||function isValidColor(e){return a.valueType(e)===a.TYPES.COLOR}(t.raw)||(t.value=void 0,t.warning="ERROR: color parsing failed."),t}function parseName(e){return parseString(e.name,!0)}function parseShortName(e){return parseString(e.short_name,!0)}function parseStartUrl(e,t,n){const a=e.start_url;if(""===a)return{raw:a,value:n,warning:"ERROR: start_url string empty"};if(void 0===a)return{raw:a,value:n};if("string"!=typeof a)return{raw:a,value:n,warning:"ERROR: expected a string."};let s;try{s=new i(a,t).href}catch(e){
return{raw:a,value:n,warning:"ERROR: invalid start_url relative to "+t}}return function checkSameOrigin(e,t){const n=new i(e),a=new i(t);return n.origin===a.origin}(s,n)?{raw:a,value:s}:{raw:a,value:n,warning:"ERROR: start_url must be same-origin as document"}}function parseDisplay(e){const t=parseString(e.display,!0),n=t.value;if(!n)return{raw:e,value:l,warning:t.warning};const i=n.toLowerCase();return s.includes(i)?{raw:e,value:i,warning:void 0}:{raw:e,value:l,warning:"ERROR: 'display' has invalid value "+i+". will fall back to browser."}}function parseOrientation(e){const t=parseString(e.orientation,!0);return t.value&&!c.includes(t.value.toLowerCase())&&(t.value=void 0,t.warning="ERROR: 'orientation' has an invalid value, will be ignored."),t}function parseIcons(e,t){const n=e.icons;if(void 0===n)return{raw:n,value:[],warning:void 0};if(!Array.isArray(n))return{raw:n,value:[],warning:"ERROR: 'icons' expected to be an array but is not."}
;const a=n.filter((e=>void 0!==e.src)).map((e=>function parseIcon(e,t){const n=parseString(e.src,!0);if(""===n.value&&(n.value=void 0),n.value)try{n.value=new i(n.value,t).href}catch(t){n.warning=`ERROR: invalid icon url will be ignored: '${e.src}'`,n.value=void 0}const a=parseString(e.type,!0),s=parseString(e.purpose),l={raw:e.purpose,value:["any"],warning:void 0};void 0!==s.value&&(l.value=s.value.split(/\s+/).map((e=>e.toLowerCase())));const c={raw:e.density,value:1,warning:void 0};let u;void 0!==c.raw&&(c.value=parseFloat(c.raw),(isNaN(c.value)||!isFinite(c.value)||c.value<=0)&&(c.value=1,c.warning="ERROR: icon density cannot be NaN, +∞, or less than or equal to +0."));const d=parseString(e.sizes);if(void 0!==d.value){const t=new Set;d.value.trim().split(/\s+/).forEach((e=>t.add(e.toLowerCase()))),u={raw:e.sizes,value:t.size>0?Array.from(t):void 0,warning:void 0}}else u={...d,value:void 0};return{raw:e,value:{src:n,type:a,density:c,sizes:u,purpose:l},warning:void 0}
}(e,t))),s=a.filter((e=>{const t=[e.warning,e.value.type.warning,e.value.src.warning,e.value.sizes.warning,e.value.density.warning].filter(Boolean),n=!!e.value.src.value;return!!t.length&&!n}));return{raw:n,value:a.filter((e=>void 0!==e.value.src.value)),warning:s.length?"WARNING: Some icons were ignored due to warnings.":void 0}}function parseApplication(e){const t=parseString(e.platform,!0),n=parseString(e.id,!0),a=parseString(e.url,!0);if(a.value)try{a.value=new i(a.value).href}catch(t){a.value=void 0,a.warning="ERROR: invalid application URL "+e.url}return{raw:e,value:{platform:t,id:n,url:a},warning:void 0}}function parseRelatedApplications(e){const t=e.related_applications;if(void 0===t)return{raw:t,value:void 0,warning:void 0};if(!Array.isArray(t))return{raw:t,value:void 0,warning:"ERROR: 'related_applications' expected to be an array but is not."};const n=t.filter((e=>!!e.platform)).map(parseApplication).filter((e=>!!e.value.id.value||!!e.value.url.value));return{raw:t,value:n,
warning:void 0}}function parsePreferRelatedApplications(e){const t=e.prefer_related_applications;let n,i;return"boolean"==typeof t?n=t:(void 0!==t&&(i="ERROR: 'prefer_related_applications' expected to be a boolean."),n=void 0),{raw:t,value:n,warning:i}}function parseThemeColor(e){return parseColor(e.theme_color)}function parseBackgroundColor(e){return parseColor(e.background_color)}t.exports=function parse(e,t,n){if(void 0===t||void 0===n)throw new Error("Manifest and document URLs required for manifest parsing.");let a;try{a=JSON.parse(e)}catch(n){return{raw:e,value:void 0,warning:"ERROR: file isn't valid JSON: "+n,url:t}}const s={name:parseName(a),short_name:parseShortName(a),start_url:parseStartUrl(a,t,n),display:parseDisplay(a),orientation:parseOrientation(a),icons:parseIcons(a,t),related_applications:parseRelatedApplications(a),prefer_related_applications:parsePreferRelatedApplications(a),theme_color:parseThemeColor(a),background_color:parseBackgroundColor(a)};let l;try{
new i(t).protocol.startsWith("http")||(l="WARNING: manifest URL not available over a valid network protocol")}catch(e){l=`ERROR: invalid manifest URL: '${t}'`}return{raw:e,value:s,warning:l,url:t}}},{"./url-shim.js":"url","cssstyle/lib/parsers":133}],94:[function(e,t,n){"use strict";const i=/(return|{|\(|\[|\.\.\.|;|,|<|>|<=|>=|==|!=|===|!==|\+|-|\*|%|\*\*|\+\+|--|<<|>>|>>>|&|\||\^|!|~|&&|\|\||\?|:|=|\+=|-=|\*=|%=|\*\*=|<<=|>>=|>>>=|&=|\|=|\^=|=>|\/|\/=|\})$/,a=/( |\n|\t)+$/;function hasPunctuatorBefore(e,t){for(let n=t;n>0;n--){const t=Math.max(0,n-6),s=e.slice(t,n);if(!a.test(s))return i.test(s)}return!0}function computeTokenLength(e,t){let n=0,i=!1,a=!1,s=!1,l=!1,c=!1,u=!1,d=null;const m=[];for(let p=0;p<e.length;p++){const h=e.substr(p,2),f=h.charAt(0),g=" "===f||"\n"===f||"\t"===f,y="'"===f||'"'===f||"`"===f;i?"\n"===f&&(i=!1):a?(s&&n++,"*/"===h&&(s&&n++,a=!1,p++)):l?(n++,"`"===d&&"${"===h?(m.push("templateBrace"),l=!1,n++,p++):"\\"===f?(n++,p++):f===d&&(l=!1)):c?(n++,
"\\"===f?(n++,p++):"["===f?u=!0:"]"===f&&u?u=!1:"/"!==f||u||(c=!1)):"/*"===h?(a=!0,s="!"===e.charAt(p+2),s&&(n+=2),p++):"//"===h&&t.singlelineComments?(i=!0,a=!1,s=!1,p++):"/"===f&&t.regex&&hasPunctuatorBefore(e,p)?(c=!0,n++):"{"===f&&m.length?(m.push("normalBrace"),n++):"}"===f&&m.length?("templateBrace"===m[m.length-1]&&(l=!0,d="`"),m.pop(),n++):y?(l=!0,d=f,n++):g||n++}return a||l?e.length:n}t.exports={computeJSTokenLength:function computeJSTokenLength(e){return computeTokenLength(e,{singlelineComments:!0,regex:!0})},computeCSSTokenLength:function computeCSSTokenLength(e){return computeTokenLength(e,{singlelineComments:!1,regex:!1})}}},{}],95:[function(e,t,n){"use strict";const i=e("./network-request.js"),a=e("events").EventEmitter,s=e("lighthouse-logger"),l=["data","ws"];class NetworkRecorder extends a{constructor(){super(),this._records=[],this._recordsById=new Map}getInflightRecords(){return this._records.filter((e=>!e.finished))}getRecords(){return Array.from(this._records)}
on(e,t){return super.on(e,t)}once(e,t){return super.once(e,t)}isIdle(){return this._isActiveIdlePeriod(0)}isCriticalIdle(){const e=this._records.find((e=>"Document"===e.resourceType)),t=e&&e.frameId;return this._isActiveIdlePeriod(0,(e=>e.frameId===t&&("VeryHigh"===e.priority||"High"===e.priority)))}is2Idle(){return this._isActiveIdlePeriod(2)}_isActiveIdlePeriod(e,t){let n=0;for(let e=0;e<this._records.length;e++){const i=this._records[e];i.finished||(t&&!t(i)||l.includes(i.parsedURL.scheme)||n++)}return n<=e}_emitNetworkStatus(){const e=this.isIdle(),t=this.is2Idle(),n=this.isCriticalIdle();this.emit(e?"networkidle":"networkbusy"),this.emit(t?"network-2-idle":"network-2-busy"),this.emit(n?"network-critical-idle":"network-critical-busy"),t&&e?s.verbose("NetworkRecorder","network fully-quiet"):t&&!e?s.verbose("NetworkRecorder","network semi-quiet"):s.verbose("NetworkRecorder","network busy")}static findNetworkQuietPeriods(e,t,n=1/0){let i=[];e.forEach((e=>{
const t=e.parsedURL&&e.parsedURL.scheme;l.includes(t)||(i.push({time:1e3*e.startTime,isStart:!0}),e.finished&&i.push({time:1e3*e.endTime,isStart:!1}))})),i=i.filter((e=>e.time<=n)).sort(((e,t)=>e.time-t.time));let a=0,s=0;const c=[];return i.forEach((e=>{e.isStart?(a===t&&c.push({start:s,end:e.time}),a++):(a--,a===t&&(s=e.time))})),a<=t&&c.push({start:s,end:n}),c.filter((e=>e.start!==e.end))}onRequestStarted(e){this._records.push(e),this._recordsById.set(e.requestId,e),this.emit("requeststarted",e),this._emitNetworkStatus()}onRequestFinished(e){this.emit("requestloaded",e),this._emitNetworkStatus()}onRequestWillBeSent(e){const t=e.params,n=this._findRealRequestAndSetSession(t.requestId,e.sessionId);if(!n){const n=new i;return n.onRequestWillBeSent(t),n.sessionId=e.sessionId,void this.onRequestStarted(n)}if(!t.redirectResponse)return;const a={...t,initiator:n.initiator,requestId:n.requestId+":redirect"},s=new i;s.onRequestWillBeSent(a),n.onRedirectResponse(t),n.redirectDestination=s,
s.redirectSource=n,this.onRequestStarted(s),this.onRequestFinished(n)}onRequestServedFromCache(e){const t=e.params,n=this._findRealRequestAndSetSession(t.requestId,e.sessionId);n&&n.onRequestServedFromCache()}onResponseReceived(e){const t=e.params,n=this._findRealRequestAndSetSession(t.requestId,e.sessionId);n&&n.onResponseReceived(t)}onDataReceived(e){const t=e.params,n=this._findRealRequestAndSetSession(t.requestId,e.sessionId);n&&n.onDataReceived(t)}onLoadingFinished(e){const t=e.params,n=this._findRealRequestAndSetSession(t.requestId,e.sessionId);n&&(n.onLoadingFinished(t),this.onRequestFinished(n))}onLoadingFailed(e){const t=e.params,n=this._findRealRequestAndSetSession(t.requestId,e.sessionId);n&&(n.onLoadingFailed(t),this.onRequestFinished(n))}onResourceChangedPriority(e){const t=e.params,n=this._findRealRequestAndSetSession(t.requestId,e.sessionId);n&&n.onResourceChangedPriority(t)}dispatch(e){switch(e.method){case"Network.requestWillBeSent":return this.onRequestWillBeSent(e)
;case"Network.requestServedFromCache":return this.onRequestServedFromCache(e);case"Network.responseReceived":return this.onResponseReceived(e);case"Network.dataReceived":return this.onDataReceived(e);case"Network.loadingFinished":return this.onLoadingFinished(e);case"Network.loadingFailed":return this.onLoadingFailed(e);case"Network.resourceChangedPriority":return this.onResourceChangedPriority(e);default:return}}_findRealRequestAndSetSession(e,t){let n=this._recordsById.get(e);if(n&&n.isValid){for(;n.redirectDestination;)n=n.redirectDestination;return n.setSession(t),n}}static _chooseInitiatorRequest(e,t){if(e.redirectSource)return e.redirectSource;const n=e.initiator.stack&&e.initiator.stack.callFrames||[],a=e.initiator.url||n[0]&&n[0].url;let s=t.get(a)||[];if(s=s.filter((t=>t.responseReceivedTime<=e.startTime)),s.length>1){const e=s.filter((e=>e.resourceType!==i.TYPES.Other));e.length&&(s=e)}if(s.length>1){const t=s.filter((t=>t.frameId===e.frameId));t.length&&(s=t)}
if(s.length>1&&"parser"===e.initiator.type){const e=s.filter((e=>e.resourceType===i.TYPES.Document));e.length&&(s=e)}return 1===s.length?s[0]:null}static recordsFromLogs(e){const t=new NetworkRecorder;e.forEach((e=>t.dispatch(e)));const n=t.getRecords().filter((e=>e.isValid)),i=new Map;for(const e of n){const t=i.get(e.url)||[];t.push(e),i.set(e.url,t)}for(const e of n){const t=NetworkRecorder._chooseInitiatorRequest(e,i);t&&e.setInitiatorRequest(t);let n=e;for(;n.redirectDestination;)n=n.redirectDestination;if(n===e||n.redirects)continue;const a=[];for(let e=n.redirectSource;e;e=e.redirectSource)a.unshift(e);n.redirects=a}return n}}t.exports=NetworkRecorder},{"./network-request.js":96,events:134,"lighthouse-logger":115}],96:[function(e,t,n){(function(n){"use strict";const i=e("./url-shim.js"),a=["data","https","wss","blob","chrome","chrome-extension","about"],s="X-TCPMs",l="X-SSLMs",c="X-RequestMs",u="X-ResponseMs",d="X-TotalMs",m="X-TotalFetchedSize",p="X-ProtocolIsH2",h={XHR:"XHR",
Fetch:"Fetch",EventSource:"EventSource",Script:"Script",Stylesheet:"Stylesheet",Image:"Image",Media:"Media",Font:"Font",Document:"Document",TextTrack:"TextTrack",WebSocket:"WebSocket",Other:"Other",Manifest:"Manifest",SignedExchange:"SignedExchange",Ping:"Ping",CSPViolationReport:"CSPViolationReport"};class NetworkRequest{constructor(){this.requestId="",this.connectionId="0",this.connectionReused=!1,this.url="",this.protocol="",this.isSecure=!1,this.isValid=!1,this.parsedURL={scheme:""},this.documentURL="",this.startTime=-1,this.endTime=-1,this.responseReceivedTime=-1,this.transferSize=0,this.resourceSize=0,this.fromDiskCache=!1,this.fromMemoryCache=!1,this.lrStatistics=void 0,this.finished=!1,this.requestMethod="",this.statusCode=-1,this.redirectSource=void 0,this.redirectDestination=void 0,this.redirects=void 0,this.failed=!1,this.localizedFailDescription="",this.initiator={type:"other"},this.timing=void 0,this.resourceType=void 0,this.mimeType="",this.priority="Low",
this.initiatorRequest=void 0,this.responseHeaders=[],this.responseHeadersText="",this.fetchedViaServiceWorker=!1,this.frameId="",this.sessionId=void 0,this.isLinkPreload=!1}hasErrorStatusCode(){return this.statusCode>=400}setInitiatorRequest(e){this.initiatorRequest=e}onRequestWillBeSent(e){let t;this.requestId=e.requestId;try{t=new i(e.request.url)}catch(e){return}this.url=e.request.url,this.documentURL=e.documentURL,this.parsedURL={scheme:t.protocol.split(":")[0],host:t.hostname,securityOrigin:t.origin},this.isSecure=a.includes(this.parsedURL.scheme),this.startTime=e.timestamp,this.requestMethod=e.request.method,this.initiator=e.initiator,this.resourceType=e.type&&h[e.type],this.priority=e.request.initialPriority,this.frameId=e.frameId,this.isLinkPreload="preload"===e.initiator.type||!!e.request.isLinkPreload,this.isValid=!0}onRequestServedFromCache(){this.fromMemoryCache=!0}onResponseReceived(e){this._onResponse(e.response,e.timestamp,e.type),this._updateProtocolForLightrider(),
this.frameId=e.frameId}onDataReceived(e){this.resourceSize+=e.dataLength,-1!==e.encodedDataLength&&(this.transferSize+=e.encodedDataLength)}onLoadingFinished(e){this.finished||(this.finished=!0,this.endTime=e.timestamp,e.encodedDataLength>=0&&(this.transferSize=e.encodedDataLength),this._updateResponseReceivedTimeIfNecessary(),this._updateTransferSizeForLightrider(),this._updateTimingsForLightrider())}onLoadingFailed(e){this.finished||(this.finished=!0,this.endTime=e.timestamp,this.failed=!0,this.resourceType=e.type&&h[e.type],this.localizedFailDescription=e.errorText,this._updateResponseReceivedTimeIfNecessary(),this._updateTransferSizeForLightrider(),this._updateTimingsForLightrider())}onResourceChangedPriority(e){this.priority=e.newPriority}onRedirectResponse(e){if(!e.redirectResponse)throw new Error("Missing redirectResponse data");this._onResponse(e.redirectResponse,e.timestamp,e.type),this.resourceType=void 0,this.finished=!0,this.endTime=e.timestamp,
this._updateResponseReceivedTimeIfNecessary()}setSession(e){this.sessionId=e}_onResponse(e,t,n){this.url=e.url,this.connectionId=String(e.connectionId),this.connectionReused=e.connectionReused,e.protocol&&(this.protocol=e.protocol),this.responseReceivedTime=t,this.transferSize=e.encodedDataLength,"boolean"==typeof e.fromDiskCache&&(this.fromDiskCache=e.fromDiskCache),this.statusCode=e.status,this.timing=e.timing,n&&(this.resourceType=h[n]),this.mimeType=e.mimeType,this.responseHeadersText=e.headersText||"",this.responseHeaders=NetworkRequest._headersDictToHeadersArray(e.headers),this.fetchedViaServiceWorker=!!e.fromServiceWorker,this.fromMemoryCache&&(this.timing=void 0),this.timing&&this._recomputeTimesWithResourceTiming(this.timing)}_recomputeTimesWithResourceTiming(e){if(0===e.requestTime||-1===e.receiveHeadersEnd)return;this.startTime=e.requestTime;const t=e.requestTime+e.receiveHeadersEnd/1e3;(!this.responseReceivedTime||this.responseReceivedTime<0)&&(this.responseReceivedTime=t),
this.responseReceivedTime=Math.min(this.responseReceivedTime,t),this.responseReceivedTime=Math.max(this.responseReceivedTime,this.startTime),this.endTime=Math.max(this.endTime,this.responseReceivedTime)}_updateResponseReceivedTimeIfNecessary(){this.responseReceivedTime=Math.min(this.endTime,this.responseReceivedTime)}_updateTransferSizeForLightrider(){if(!n.isLightrider)return;const e=this.responseHeaders.find((e=>e.name===m));if(!e)return;const t=parseFloat(e.value);isNaN(t)||(this.transferSize=t)}_updateProtocolForLightrider(){n.isLightrider&&this.responseHeaders.some((e=>e.name===p))&&(this.protocol="h2")}_updateTimingsForLightrider(){if(!n.isLightrider)return;const e=this.responseHeaders.find((e=>e.name===d));if(!e)return
;const t=parseInt(e.value),i=this.responseHeaders.find((e=>e.name===s)),a=this.responseHeaders.find((e=>e.name===l)),m=this.responseHeaders.find((e=>e.name===c)),p=this.responseHeaders.find((e=>e.name===u)),h=i?Math.max(0,parseInt(i.value)):0,f=a?Math.max(0,parseInt(a.value)):0,g=m?Math.max(0,parseInt(m.value)):0,y=p?Math.max(0,parseInt(p.value)):0;h+g+y===t&&(f>h||(this.lrStatistics={endTimeDeltaMs:1e3*(this.endTime-(this.startTime+t/1e3)),TCPMs:h,requestMs:g,responseMs:y}))}static getRequestIdForBackend(e){return e.replace(/(:redirect)+$/,"")}static _headersDictToHeadersArray(e){const t=[];for(const n of Object.keys(e)){const i=e[n].split("\n");for(let e=0;e<i.length;++e)t.push({name:n,value:i[e]})}return t}static get TYPES(){return h}}NetworkRequest.HEADER_TCP=s,NetworkRequest.HEADER_SSL=l,NetworkRequest.HEADER_REQ=c,NetworkRequest.HEADER_RES=u,NetworkRequest.HEADER_TOTAL=d,NetworkRequest.HEADER_FETCHED_SIZE=m,NetworkRequest.HEADER_PROTOCOL_IS_H2=p,t.exports=NetworkRequest
}).call(this,"undefined"!=typeof global?global:"undefined"!=typeof self?self:"undefined"!=typeof window?window:{})},{"./url-shim.js":"url"}],97:[function(e,t,n){"use strict";function getElementsInDocument(e){const t=window.__ElementMatches||window.Element.prototype.matches,n=[],_findAllElements=i=>{for(let a,s=0;a=i[s];++s)e&&!t.call(a,e)||n.push(a),a.shadowRoot&&_findAllElements(a.shadowRoot.querySelectorAll("*"))};return _findAllElements(document.querySelectorAll("*")),n}function getOuterHTMLSnippet(e,t=[],n=500){const i=["autofill-information","autofill-prediction","title"];try{e instanceof ShadowRoot&&(e=e.host);const a=e.cloneNode();e.ownerDocument.createElement("template").content.append(a),t.concat(i).forEach((e=>{a.removeAttribute(e)}));let s=0;for(const e of a.getAttributeNames())if(s>n)a.removeAttribute(e);else{let t=a.getAttribute(e);t.length>75&&(t=t.slice(0,74)+"…",a.setAttribute(e,t)),s+=e.length+t.length}const l=/^[\s\S]*?>/,[c]=a.outerHTML.match(l)||[]
;return c&&s>n?c.slice(0,c.length-1)+" …>":c||""}catch(t){return`<${e.localName}>`}}function computeBenchmarkIndex(){return(function benchmarkIndexGC(){const e=Date.now();let t=0;for(;Date.now()-e<500;){let e="";for(let t=0;t<1e4;t++)e+="a";t++}const n=(Date.now()-e)/1e3;return Math.round(t/10/n)}()+function benchmarkIndexNoGC(){const e=[],t=[];for(let n=0;n<1e5;n++)e[n]=t[n]=n;const n=Date.now();let i=0;for(;i%10!=0||Date.now()-n<500;){const n=i%2==0?e:t,a=i%2==0?t:e;for(let e=0;e<n.length;e++)a[e]=n[e];i++}const a=(Date.now()-n)/1e3;return Math.round(i/10/a)}())/2}function getNodePath(e){const isShadowRoot=e=>e.nodeType===Node.DOCUMENT_FRAGMENT_NODE,getNodeParent=e=>isShadowRoot(e)?e.host:e.parentNode;function getNodeIndex(e){if(isShadowRoot(e))return"a";let t,n=0;for(;t=e.previousSibling;)(e=t).nodeType===Node.TEXT_NODE&&0===e.nodeValue.trim().length||n++;return n}const t=[];for(;e&&getNodeParent(e);){const n=getNodeIndex(e);t.push([n,e.nodeName]),e=getNodeParent(e)}
return t.reverse(),t.join(",")}function getNodeSelector(e){function getSelectorPart(e){let t=e.tagName.toLowerCase();return e.id?t+="#"+e.id:e.classList.length>0&&(t+="."+e.classList[0]),t}const t=[];for(;t.length<4&&(t.unshift(getSelectorPart(e)),e.parentElement)&&"HTML"!==(e=e.parentElement).tagName;);return t.join(" > ")}function getNodeLabel(e){const t=e.tagName.toLowerCase();if("html"!==t&&"body"!==t){const t=e.innerText||e.getAttribute("alt")||e.getAttribute("aria-label");if(t)return function truncate(e,t){return e.length<=t?e:Array.from(e).slice(0,t-1).join("")+"…"}(t,80);{const t=e.querySelector("[alt], [aria-label]");if(t)return getNodeLabel(t)}}return t}function getBoundingClientRect(e){const t=e.getBoundingClientRect();return{top:Math.round(t.top),bottom:Math.round(t.bottom),left:Math.round(t.left),right:Math.round(t.right),width:Math.round(t.width),height:Math.round(t.height)}}
const i=`function getNodeDetails(element) {\n  ${getNodePath.toString()};\n  ${getNodeSelector.toString()};\n  ${getBoundingClientRect.toString()};\n  ${getOuterHTMLSnippet.toString()};\n  ${getNodeLabel.toString()};\n  ${function getNodeDetailsImpl(e){window.__lighthouseNodesDontTouchOrAllVarianceGoesAway||(window.__lighthouseNodesDontTouchOrAllVarianceGoesAway=new Map);const t=e instanceof ShadowRoot?e.host:e;let n=window.__lighthouseNodesDontTouchOrAllVarianceGoesAway.get(t);return n||(n=[void 0!==window.__lighthouseExecutionContextId?window.__lighthouseExecutionContextId:"page",window.__lighthouseNodesDontTouchOrAllVarianceGoesAway.size,t.tagName].join("-"),window.__lighthouseNodesDontTouchOrAllVarianceGoesAway.set(t,n)),{lhId:n,devtoolsNodePath:getNodePath(e),selector:getNodeSelector(t),boundingRect:getBoundingClientRect(t),snippet:getOuterHTMLSnippet(e),nodeLabel:getNodeLabel(t)}}.toString()};\n  return getNodeDetailsImpl(element);\n}`;t.exports={
wrapRuntimeEvalErrorInBrowserString:function wrapRuntimeEvalErrorInBrowser(e){const t="string"==typeof(e=e||new Error)?e:"unknown error";return{__failedInBrowser:!0,name:e.name||"Error",message:e.message||t,stack:e.stack||(new Error).stack}}.toString(),registerPerformanceObserverInPageString:function registerPerformanceObserverInPage(){window.____lastLongTask=window.__perfNow();const e=new window.PerformanceObserver((e=>{const t=e.getEntries();for(const e of t)if("longtask"===e.entryType){const t=e.startTime+e.duration;window.____lastLongTask=Math.max(window.____lastLongTask,t)}}));e.observe({entryTypes:["longtask"]}),window.____lhPerformanceObserver=e}.toString(),checkTimeSinceLastLongTaskString:function checkTimeSinceLastLongTask(){return new window.__nativePromise((e=>{const t=window.__perfNow()+50;setTimeout((()=>{const n=window.__perfNow(),i=n-t<50?n-window.____lastLongTask:0;e(i)}),50)}))}.toString(),getElementsInDocument,
getElementsInDocumentString:getElementsInDocument.toString(),getOuterHTMLSnippetString:getOuterHTMLSnippet.toString(),getOuterHTMLSnippet,computeBenchmarkIndex,computeBenchmarkIndexString:computeBenchmarkIndex.toString(),getNodeDetailsString:i,getNodePathString:getNodePath.toString(),getNodeSelectorString:getNodeSelector.toString(),getNodePath,getNodeSelector,getNodeLabel,getNodeLabelString:getNodeLabel.toString(),isPositionFixedString:function isPositionFixed(e){function getStyleAttrValue(e,t){return e.style[t]||window.getComputedStyle(e)[t]}const t=document.querySelector("html");if(t.scrollHeight<=t.clientHeight||!["scroll","auto","visible"].includes(getStyleAttrValue(t,"overflowY")))return!1;let n=e;for(;n;){const e=getStyleAttrValue(n,"position");if("fixed"===e||"sticky"===e)return!0;n=n.parentElement}return!1}.toString(),wrapRequestIdleCallbackString:function wrapRequestIdleCallback(e){const t=Math.floor(40/e),n=window.requestIdleCallback;window.requestIdleCallback=e=>n(((n,i)=>{
const a=Date.now();n.__timeRemaining=n.timeRemaining,n.timeRemaining=()=>Math.min(n.__timeRemaining(),Math.max(0,t-(Date.now()-a))),n.timeRemaining.toString=()=>"function timeRemaining() { [native code] }",e(n,i)})),window.requestIdleCallback.toString=()=>"function requestIdleCallback() { [native code] }"}.toString(),getBoundingClientRectString:getBoundingClientRect.toString()}},{}],98:[function(e,t,n){"use strict";function rectContains(e,t){return t.top>=e.top&&t.right<=e.right&&t.bottom<=e.bottom&&t.left>=e.left}function getBoundingRectWithPadding(e,t){if(0===e.length)throw new Error("No rects to take bounds of");let n=Number.MAX_VALUE,i=-Number.MAX_VALUE,a=Number.MAX_VALUE,s=-Number.MAX_VALUE;for(const t of e)n=Math.min(n,t.left),i=Math.max(i,t.right),a=Math.min(a,t.top),s=Math.max(s,t.bottom);const l=t/2;return n-=l,i+=l,a-=l,s+=l,{left:n,right:i,top:a,bottom:s,width:i-n,height:s-a}}function addRectWidthAndHeight({left:e,top:t,right:n,bottom:i}){return{left:e,top:t,right:n,
bottom:i,width:n-e,height:i-t}}function getRectArea(e){return e.width*e.height}t.exports={rectContainsPoint:function rectContainsPoint(e,{x:t,y:n}){return e.left<=t&&e.right>=t&&e.top<=n&&e.bottom>=n},rectContains,addRectWidthAndHeight,addRectTopAndBottom:function addRectTopAndBottom({x:e,y:t,width:n,height:i}){return{left:e,top:t,right:e+n,bottom:t+i,width:n,height:i}},getRectOverlapArea:function getRectOverlapArea(e,t){const n=Math.min(e.bottom,t.bottom)-Math.max(e.top,t.top);if(n<=0)return 0;const i=Math.min(e.right,t.right)-Math.max(e.left,t.left);return i<=0?0:i*n},getRectAtCenter:function getRectAtCenter(e,t){return addRectWidthAndHeight({left:e.left+e.width/2-t/2,top:e.top+e.height/2-t/2,right:e.right-e.width/2+t/2,bottom:e.bottom-e.height/2+t/2})},getLargestRect:function getLargestRect(e){let t=e[0];for(const n of e)getRectArea(n)>getRectArea(t)&&(t=n);return t},getRectArea,getRectCenterPoint:function getRectCenterPoint(e){return{x:e.left+e.width/2,y:e.top+e.height/2}},
getBoundingRect:function getBoundingRect(e){return getBoundingRectWithPadding(e,0)},getBoundingRectWithPadding,rectsTouchOrOverlap:function rectsTouchOrOverlap(e,t){return e.left<=t.right&&t.left<=e.right&&e.top<=t.bottom&&t.top<=e.bottom},allRectsContainedWithinEachOther:function allRectsContainedWithinEachOther(e,t){for(const n of e)for(const e of t)if(!rectContains(n,e)&&!rectContains(e,n))return!1;return!0},filterOutRectsContainedByOthers:function filterOutRectsContainedByOthers(e){const t=new Set(e);for(const n of e)for(const i of e)if(n!==i&&t.has(i)&&rectContains(i,n)){t.delete(n);break}return Array.from(t)},filterOutTinyRects:function filterOutTinyRects(e){return e.filter((e=>e.width>1&&e.height>1))}}},{}],99:[function(e,t,n){"use strict";const i=e("lighthouse-logger"),a=[],noop=()=>{},s={init:function init(t){if(!t.flags.enableErrorReporting)return;if(!s._shouldSample())return;try{const n=e("raven"),i=Object.assign({},t.environmentData,{captureUnhandledRejections:!0})
;n.config("https://a6bb0da87ee048cc9ae2a345fc09ab2e:63a7029f46f74265981b7e005e0f69f8@sentry.io/174697",i).install(),s.captureMessage=(...e)=>n.captureMessage(...e),s.captureBreadcrumb=(...e)=>n.captureBreadcrumb(...e),s.getContext=()=>n.getContext();const l=new Map;s.captureException=async(e,t={})=>{if(!e)return;if(e.expected)return;const i=t.tags||{};if(i.audit){const t=`audit-${i.audit}-${e.message}`;if(l.has(t))return;l.set(t,!0)}if(i.gatherer){const t=`gatherer-${i.gatherer}-${e.message}`;if(l.has(t))return;l.set(t,!0)}const s=a.find((t=>t.pattern.test(e.message)));return s&&s.rate<=Math.random()?void 0:(e.protocolMethod&&(t.fingerprint=["{{ default }}",e.protocolMethod,e.protocolError]),new Promise((i=>{n.captureException(e,t,(()=>i()))})))};const c=Object.assign({url:t.url,formFactor:t.flags.formFactor,throttlingMethod:t.flags.throttlingMethod},t.flags.throttling);n.mergeContext({extra:Object.assign({},t.environmentData.extra,c)})}catch(e){
i.warn("sentry","Could not load raven library, errors will not be reported.")}},captureMessage:noop,captureBreadcrumb:noop,getContext:noop,captureException:async()=>{},_shouldSample:()=>.01>=Math.random()};t.exports=s},{"lighthouse-logger":115,raven:129}],100:[function(e,t,n){"use strict";const i=e("lighthouse-logger");async function detectLibraries(){const e=[],t=d41d8cd98f00b204e9800998ecf8427e_LibraryDetectorTests;for(const[n,i]of Object.entries(t))try{let t;const a=new Promise((e=>t=setTimeout((()=>e(!1)),1e3))),s=await Promise.race([i.test(window),a]);t&&clearTimeout(t),s&&e.push({id:i.id,name:n,version:s.version,npm:i.npm})}catch(e){}return e}t.exports=async function collectStacks(e){const t={msg:"Collect stacks",id:"lh:gather:collectStacks"};i.time(t)
;const n=`(function () {\n    function _createTimeoutHelper() {\n    let timeout;\n    const timeoutPromise = new Promise((_, reject) => {\n        timeout = setTimeout(() => reject(new Error('Timed out')), 5000);\n    });\n\n    return {timeoutPromise, clearTimeout: () => clearTimeout(timeout)};\n}\n\nvar UNKNOWN_VERSION = null;\nvar d41d8cd98f00b204e9800998ecf8427e_LibraryDetectorTests = {\n\n    'GWT': {\n        id: 'gwt',\n        icon: 'gwt',\n        url: 'http://www.gwtproject.org/',\n        test: function(win) {\n            // pretty complicated, many possible tell tales\n            var doc = win.document,\n                hasHistFrame = doc.getElementById('__gwt_historyFrame'),\n                hasGwtUid = doc.gwt_uid,\n                hasBodyListener = doc.body.__listener,\n                hasBodyEventBits = doc.body.__eventBits,\n                hasModules = win.__gwt_activeModules,\n                hasJsonP = win.__gwt_jsonp__,\n                hasRootWinApp = win.__gwt_scriptsLoaded || win.__gwt_stylesLoaded || win.__gwt_activeModules;\n\n            // use the many possible indicators\n            if(hasHistFrame || hasGwtUid || hasBodyListener || hasBodyEventBits || hasModules || hasJsonP || hasRootWinApp) {\n\n                // carefully look at frames, but only if certain is GWT frame\n                var frames = doc.getElementsByTagName('iframe'),\n                    gwtVersion = UNKNOWN_VERSION;\n                for(var n=0; n<frames.length; n++) {\n                    // catch security access errors\n                    try {\n                        var hasNegativeTabIndex = frames[n].tabIndex < 0; // on for GWT\n                        if(hasNegativeTabIndex && frames[n].contentWindow && frames[n].contentWindow.$gwt_version) {\n                            gwtVersion = frames[n].contentWindow.$gwt_version;\n                            break;\n                        }\n                    }\n                    catch(e) {}\n                }\n\n                if(gwtVersion=='0.0.999') {\n                  gwtVersion = 'Google Internal';\n                }\n\n                return { version: gwtVersion };\n            }\n            return false;\n        }\n    },\n\n    'Ink': {\n        id: 'ink',\n        icon: 'ink',\n        url: 'http://ink.sapo.pt/',\n        test: function(win) {\n            if (win.Ink && win.Ink.createModule) {\n                return { version: UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'Vaadin': {\n        id: 'vaadin',\n        icon: 'vaadin',\n        url: 'https://vaadin.com/',\n        test: function(win) {\n            if (win.vaadin && win.vaadin.registerWidgetset) {\n                return { version: UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'Bootstrap': {\n        id: 'bootstrap',\n        icon: 'bootstrap',\n        url: 'http://getbootstrap.com/',\n        npm: 'bootstrap',\n        // look for a function Boostrap has added to jQuery - regex for BS 2 & 3\n        test: function(win) {\n            var jQueryAvailable = win.$ && win.$.fn,\n                RE_PREFIX_V2 = '\\\\$this\\\\.data\\\\((?:\\'|")',\n                RE_PREFIX_V3 = '\\\\$this\\\\.data\\\\((?:\\'|")(?:bs\\\\.){1}',\n                bootstrapComponents = [\n                    'affix', 'alert', 'button', 'carousel', 'collapse', 'dropdown',\n                    'modal', 'popover', 'scrollspy', 'tab', 'tooltip'\n                ];\n\n            if(jQueryAvailable) {\n                var bootstrapVersion;\n\n                bootstrapComponents.some(function(component) {\n                    if(win.$.fn[component]) {\n                        // Bootstrap >= 3.2.0 detection\n                        if(win.$.fn[component].Constructor && win.$.fn[component].Constructor.VERSION) {\n                            bootstrapVersion = win.$.fn[component].Constructor.VERSION;\n                            return true;\n                        // Bootstrap >= 2.0.0 and <= 3.1.0 detection\n                        } else if(new RegExp(RE_PREFIX_V3 + component).test(win.$.fn[component].toString())) {\n                            bootstrapVersion = '>= 3.0.0 & <= 3.1.1';\n                            return true;\n                        // Bootstrap < 3.1.0 detection\n                        } else if(new RegExp(RE_PREFIX_V2 + component).test(win.$.fn[component].toString())) {\n                            bootstrapVersion = '>= 2.0.0 & <= 2.3.2';\n                            return true;\n                        }\n                    }\n\n                    return false;\n                });\n\n                if (bootstrapVersion) {\n                    return { version: bootstrapVersion };\n                }\n            }\n\n            return false;\n        }\n    },\n\n    'Zurb': {\n        id: 'zurb',\n        icon: 'zurb',\n        url: 'https://foundation.zurb.com/',\n        npm: 'foundation-sites',\n        test: function(win) {\n            if(win.Foundation && win.Foundation.Toggler) {\n                return { version: win.Foundation.version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'Polymer': {\n        id: 'polymer',\n        icon: 'polymer',\n        url: 'https://www.polymer-project.org/',\n        npm: '@polymer/polymer',\n        test: function(win) {\n            if(win.Polymer && win.Polymer.dom) {\n                return { version: win.Polymer.version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'LitElement': {\n        id: 'litelement',\n        icon: 'polymer',\n        url: 'https://lit-element.polymer-project.org/',\n        npm: 'lit-element',\n        test: function(win) {\n            if(win.litElementVersions && win.litElementVersions.length) {\n                // Get latest version if multiple versions are used\n                var versions = [...win.litElementVersions].sort( (a, b) => a.localeCompare(b, undefined, { numeric:true }) );\n                return { version: versions[versions.length - 1] };\n            }\n            return false;\n        }\n    },\n\n    'Highcharts': {\n        id: 'highcharts',\n        icon: 'highcharts',\n        url: 'http://www.highcharts.com',\n        npm: 'highcharts',\n        test: function(win) {\n            if(win.Highcharts && win.Highcharts.Point) {\n                return { version: win.Highcharts.version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'InfoVis': {\n        id: 'jit',\n        icon: 'jit',\n        url: 'http://philogb.github.com/jit/',\n        test: function test(win) {\n            if(win.$jit && win.$jit.PieChart) {\n                return { version: win.$jit.version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'FlotCharts': {\n        id: 'flotcharts',\n        icon: 'flotcharts',\n        url: 'http://www.flotcharts.org/',\n        npm: 'flot',\n        test: function(win) {\n            if(win.$ && win.$.plot) {\n                return { version: win.$.plot.version || UNKNOWN_VERSION};\n            }\n            return false;\n        }\n    },\n\n    'CreateJS': {\n        id: 'createjs',\n        icon: 'createjs',\n        url: 'https://createjs.com/',\n        npm: 'createjs',\n        test: function(win) {\n            if(win.createjs && win.createjs.promote) {\n                return { version: UNKNOWN_VERSION}; // no version info available\n            }\n            return false;\n        }\n    },\n\n    'Google Maps': {\n        id: 'gmaps',\n        icon: 'gmaps',\n        url: 'https://developers.google.com/maps/',\n        test: function(win) {\n            if (win.google && win.google.maps) {\n                return { version: win.google.maps.version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'jQuery': {\n        id: 'jquery',\n        icon: 'jquery',\n        url: 'http://jquery.com',\n        npm: 'jquery',\n        test: function(win) {\n            var jq = win.jQuery || win.$;\n            if (jq && jq.fn && jq.fn.jquery) {\n                return { version: jq.fn.jquery.replace(/[^\\d+\\.+]/g, '') || UNKNOWN_VERSION};\n            }\n            return false;\n        }\n    },\n\n    'jQuery (Fast path)': {\n        id: 'jquery-fast',\n        icon: 'jquery',\n        url: 'http://jquery.com',\n        npm: 'jquery',\n        test: function (win) {\n            var jq = win.jQuery || win.$;\n            if (jq && jq.fn) {\n                return { version: UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'jQuery UI': {\n        id: 'jquery_ui',\n        icon: 'jquery_ui',\n        url: 'http://jqueryui.com',\n        npm: 'jquery-ui',\n        test: function(win) {\n            var jq = win.jQuery || win.$ || win.$jq || win.$j;\n            if(jq && jq.fn && jq.fn.jquery && jq.ui) {\n                var plugins = 'accordion,datepicker,dialog,draggable,droppable,progressbar,resizable,selectable,slider,menu,grid,tabs'.split(','), concat = [];\n                for (var i=0; i < plugins.length; i++) { if(jq.ui[plugins[i]]) concat.push(plugins[i].substr(0,1).toUpperCase() + plugins[i].substr(1)); }\n                return { version: jq.ui.version || UNKNOWN_VERSION, details: concat.length ? 'Plugins used: '+concat.join(',') : '' };\n            }\n            return false;\n        }\n    },\n\n    'Dojo': {\n        id: 'dojo',\n        icon: 'dojo',\n        url: 'http://dojotoolkit.org',\n        npm: 'dojo',\n        test: function(win) {\n            if(win.dojo && win.dojo.delegate) {\n                var version = win.dojo.version ? win.dojo.version.toString() : UNKNOWN_VERSION;\n                return { version: version, details: 'Details: '+(win.dijit ? 'Uses Dijit' : 'none') };\n            }\n            return false;\n        }\n    },\n\n    'Prototype': {\n        id: 'prototype',\n        icon: 'prototype',\n        url: 'http://prototypejs.org',\n        test: function(win) {\n            if(win.Prototype && win.Prototype.BrowserFeatures) {\n                return { version: win.Prototype.Version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'Scriptaculous': {\n        id: 'scriptaculous',\n        icon: 'scriptaculous',\n        url: 'http://script.aculo.us',\n        test: function(win) {\n            if(win.Scriptaculous && win.Scriptaculous.load) {\n                return { version: win.Scriptaculous.Version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'MooTools': {\n        id: 'mootools',\n        icon: 'mootools',\n        url: 'https://mootools.net/',\n        test: function(win) {\n            if(win.MooTools && win.MooTools.build) {\n                return { version: win.MooTools.version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'Spry': {\n        id: 'spry',\n        icon: 'spry',\n        url: 'http://labs.adobe.com/technologies/spry',\n        test: function(win) {\n            if (win.Spry && win.Spry.Data) {\n                return { version: UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'YUI 2': {\n        id: 'yui',\n        icon: 'yui',\n        url: 'http://developer.yahoo.com/yui/2/',\n        test: function(win) {\n            if (win.YAHOO && win.YAHOO.util) {\n                return { version: win.YAHOO.VERSION || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'YUI 3': {\n        id: 'yui3',\n        icon: 'yui3',\n        url: 'https://yuilibrary.com/',\n        npm: 'yui',\n        test: function(win) {\n            if (win.YUI && win.YUI.Env) {\n                return { version: win.YUI.version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'Qooxdoo': {\n        id: 'qooxdoo',\n        icon: 'qooxdoo',\n        url: 'http://www.qooxdoo.org/',\n        npm: 'qooxdoo',\n        test: function(win) {\n            if(win.qx && win.qx.Bootstrap) {\n                return { version: UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'Ext JS': {\n        id: 'extjs',\n        icon: 'extjs',\n        url: 'https://www.sencha.com/products/extjs/',\n        test: function(win) {\n            if (win.Ext && win.Ext.versions) {\n                return { version: win.Ext.versions.core.version };\n            }\n            else if(win.Ext) {\n                return { version: win.Ext.version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'base2': {\n        id: 'base2',\n        icon: 'base2',\n        url: 'http://code.google.com/p/base2',\n        test: function(win) {\n            if(win.base2 && win.base2.dom) {\n                return { version: win.base2.version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'Closure Library': {\n        id: 'closure',\n        icon: 'closure',\n        url: 'https://developers.google.com/closure/library/',\n        npm: 'google-closure-library',\n        test: function(win) {\n            if(win.goog && win.goog.provide) {\n                return { version: UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'Rapha&euml;l': {\n        id: 'raphael',\n        icon: 'raphael',\n        url: 'http://dmitrybaranovskiy.github.io/raphael/',\n        test: function(win) {\n            if (win.Raphael && win.Raphael.circle) {\n                return { version: win.Raphael.version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'React': {\n        id: 'react',\n        icon: 'react',\n        url: 'https://reactjs.org/',\n        npm: 'react',\n        test: function(win) {\n            function isMatch(node) {\n                return node!=null && node._reactRootContainer!=null;\n            }\n            function nodeFilter(node) {\n                return isMatch(node) ? NodeFilter.FILTER_ACCEPT : NodeFilter.FILTER_SKIP;\n            }\n            var reactRoot = document.getElementById('react-root');\n            var altHasReact = document.querySelector('*[data-reactroot]');\n            var bodyReactRoot = isMatch(document.body) || isMatch(document.body.firstElementChild);\n            var hasReactRoot = bodyReactRoot|| document.createTreeWalker(document.body, NodeFilter.SHOW_ELEMENT, nodeFilter).nextNode() != null;\n            if (hasReactRoot || reactRoot && reactRoot.innerText.length > 0 || altHasReact || win.React && win.React.Component) {\n                return { version: win.React && win.React.version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'React (Fast path)': {\n        id: 'react-fast',\n        icon: 'react',\n        url: 'https://reactjs.org/',\n        npm: 'react',\n        test: function (win) {\n            function isMatch(node) {\n                return node != null && node._reactRootContainer != null;\n            }\n            var reactRoot = document.getElementById('react-root');\n            var altHasReact = document.querySelector('*[data-reactroot]');\n            var hasReactRoot = isMatch(document.body) || isMatch(document.body.firstElementChild);\n            if (hasReactRoot || reactRoot || altHasReact || win.React) {\n                return { version: win.React && win.React.version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'Next.js': {\n        id: 'next',\n        icon: 'next',\n        url: 'https://nextjs.org/',\n        npm: 'next',\n        test: function(win) {\n            if (win.__NEXT_DATA__ && win.__NEXT_DATA__.buildId) {\n                return { version: window.next && window.next.version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'Next.js (Fast path)': {\n        id: 'next-fast',\n        icon: 'next',\n        url: 'https://nextjs.org/',\n        npm: 'next',\n        test: function (win) {\n            if (win.__NEXT_DATA__) {\n                return { version: UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'Preact': {\n        id: 'preact',\n        icon: 'preact',\n        url: 'https://preactjs.com/',\n        npm: 'preact',\n        test: function(win) {\n            var expando = typeof Symbol!='undefined' && Symbol.for && Symbol.for('preactattr');\n            function isMatch(node) {\n                if ('__k' in node && 'props' in node.__k && 'type' in node.__k) {\n                    return true;\n                }\n                return '_component' in node || '__preactattr_' in node || expando && node[expando]!=null;\n            }\n            function getMatch(node) {\n                return node!=null && isMatch(node) && node;\n            }\n            function nodeFilter(node) {\n                return isMatch(node) ? NodeFilter.FILTER_ACCEPT : NodeFilter.FILTER_SKIP;\n            }\n            var preactRoot = getMatch(document.body) || getMatch(document.body.firstElementChild);\n            if (!preactRoot) {\n                preactRoot = document.createTreeWalker(document.body, NodeFilter.SHOW_ELEMENT, nodeFilter).nextNode();\n            }\n            if (preactRoot || win.preact) {\n                var version = UNKNOWN_VERSION;\n                if (preactRoot) {\n                    if ('__k' in preactRoot) {\n                        version = '10';\n                    }\n                    if ('__preactattr_' in preactRoot) {\n                        version = '8';\n                    }\n                    if (expando && preactRoot[expando]!=null) {\n                        version = '7';\n                    }\n                }\n                return { version: version };\n            }\n            return false;\n        }\n    },\n\n    'Preact (Fast path)': {\n        id: 'preact-fast',\n        icon: 'preact',\n        url: 'https://preactjs.com/',\n        npm: 'preact',\n        test: function (win) {\n            var version = UNKNOWN_VERSION;\n            function isMatch(node) {\n                if (node.__k != null) { version = '10'; return true; }\n                return node._component != null || node.__preactattr_ != null;\n            }\n            function getMatch(node) {\n                return node != null && isMatch(node);\n            }\n            var preactRoot = getMatch(document.body) || getMatch(document.body.firstElementChild);\n            if (preactRoot || win.preact) {\n                return { version: version };\n            }\n            return false;\n        }\n    },\n\n    'Modernizr': {\n        id: 'modernizr',\n        icon: 'modernizr',\n        url: 'https://modernizr.com/',\n        npm: 'modernizr',\n        test: function(win) {\n            if (win.Modernizr && win.Modernizr.addTest) {\n                return { version: win.Modernizr._version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'Processing.js': {\n        id: 'processingjs',\n        icon: 'processingjs',\n        url: 'http://processingjs.org',\n        npm: 'processing-js',\n        test: function(win) {\n            if(win.Processing && win.Processing.box) {\n                return { version: Processing.version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'Backbone': {\n        id: 'backbone',\n        icon: 'backbone',\n        url: 'http://backbonejs.org/',\n        npm: 'backbone',\n        test: function(win) {\n            if (win.Backbone && win.Backbone.Model.extend) {\n                return {version: win.Backbone.VERSION || UNKNOWN_VERSION};\n            }\n            return false;\n        }\n    },\n\n    'Leaflet': {\n        id: 'leaflet',\n        icon: 'leaflet',\n        url: 'http://leafletjs.com',\n        npm: 'leaflet',\n        test: function(win) {\n            // Leaflet 3.1 uses L.Marker and L.VERSION; later versions use L.marker and L.version\n            if (win.L && win.L.GeoJSON && (win.L.marker || win.L.Marker)) {\n                return { version: win.L.version || win.L.VERSION || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'Mapbox': {\n        id: 'mapbox',\n        icon: 'mapbox',\n        url: 'https://www.mapbox.com/',\n        npm: 'mapbox-gl',\n        test: function(win) {\n            if (win.L && win.L.mapbox && win.L.mapbox.geocoder) {\n                return { version: win.L.mapbox.VERSION || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'Lo-Dash': {\n        id: 'lodash',\n        icon: 'lodash',\n        url: 'https://lodash.com/',\n        npm: 'lodash',\n        test: function(win) {\n            var _ = typeof (_ = win._) == 'function' && _,\n                chain = typeof (chain = _ && _.chain) == 'function' && chain,\n                wrapper = (chain || _ || function() { return {}; })(1);\n\n            if (_ && wrapper.__wrapped__) {\n                return { version: _.VERSION || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'Underscore': {\n        id: 'underscore',\n        icon: 'underscore',\n        url: 'http://underscorejs.org/',\n        npm: 'underscore',\n        test: function(win) {\n            if (win._ && typeof win._.tap === 'function' &&\n                !d41d8cd98f00b204e9800998ecf8427e_LibraryDetectorTests['Lo-Dash'].test(win)) {\n                return {version: win._.VERSION || UNKNOWN_VERSION};\n            }\n            return false;\n        }\n    },\n\n    'Sammy': {\n        id: 'sammy',\n        icon: 'sammy',\n        url: 'http://sammyjs.org',\n        test: function(win) {\n            if (win.Sammy && win.Sammy.Application.curry) {\n                return {version: win.Sammy.VERSION || UNKNOWN_VERSION};\n            }\n            return false;\n        }\n    },\n\n    'Rico': {\n        id: 'rico',\n        icon: 'rico',\n        url: 'http://openrico.sourceforge.net/examples/index.html',\n        test:  function(win) {\n            if (win.Rico && window.Rico.checkIfComplete) {\n                return {version: win.Rico.Version || UNKNOWN_VERSION};\n            }\n            return false;\n        }\n    },\n\n    'MochiKit': {\n        id: 'mochikit',\n        icon: 'mochikit',\n        url: 'https://mochi.github.io/mochikit/',\n        test: function(win) {\n            if (win.MochiKit && win.MochiKit.Base.module) {\n                return {version: MochiKit.VERSION || UNKNOWN_VERSION};\n            }\n            return false;\n        }\n    },\n\n    'gRapha&euml;l': {\n        id: 'graphael',\n        icon: 'graphael',\n        url: 'https://github.com/DmitryBaranovskiy/g.raphael',\n        test: function(win) {\n            if (win.Raphael && win.Raphael.fn.g) {\n                return {version: UNKNOWN_VERSION};\n            }\n            return false;\n        }\n    },\n\n    'Glow': {\n        id: 'glow',\n        icon: 'glow',\n        url: 'http://www.bbc.co.uk/glow/',\n        test: function(win) {\n            if (win.gloader && win.gloader.getRequests) {\n                return {version: UNKNOWN_VERSION};\n            }\n            else if (win.glow && win.glow.dom) {\n                return {version: win.glow.VERSION || UNKNOWN_VERSION};\n            }\n            else if (win.Glow) {\n                return {version: win.Glow.version || UNKNOWN_VERSION};\n            }\n            return false;\n        }\n    },\n\n    'Socket.IO': {\n        id: 'socketio',\n        icon: 'socketio', // currently has no icon\n        url: 'https://socket.io/',\n        npm: 'socket.io',\n        test: function(win) {\n            // version 0.6.2 uses only io.Socket; more recent versions also have io.sockets\n            if (win.io && (win.io.sockets || win.io.Socket)) {\n                return {version: win.io.version || UNKNOWN_VERSION};\n            }\n            return false;\n        }\n    },\n\n    'Mustache': {\n        id: 'mustache',\n        icon: 'mustache',\n        url: 'http://mustache.github.io/',\n        npm: 'mustache',\n        test: function(win) {\n            if (win.Mustache && win.Mustache.to_html) {\n                return {version: win.Mustache.version || UNKNOWN_VERSION};\n            }\n            return false;\n        }\n    },\n\n    'Fabric.js': {\n        id: 'fabricjs',\n        icon: 'icon38', // currently has no icon\n        url: 'http://fabricjs.com/',\n        npm: 'fabric',\n        test: function(win) {\n            if (win.fabric && win.fabric.util) {\n                return {version: win.fabric.version || UNKNOWN_VERSION};\n            }\n            return false;\n        }\n    },\n\n    'FuseJS': {\n        id: 'fusejs',\n        icon: 'fusejs',\n        url: 'http://fusejs.io/',\n        npm: 'fuse.js',\n        test: function(win) {\n            if (win.Fuse) {\n                return {version: UNKNOWN_VERSION};\n            }\n            return false;\n        }\n    },\n\n    'Tween.js': {\n        id: 'tweenjs',\n        icon: 'icon38', // currently has no icon\n        url: 'https://github.com/tweenjs/tween.js',\n        npm: 'tween.js',\n        test: function(win) {\n            if (win.TWEEN && win.TWEEN.Easing) {\n                return {version: UNKNOWN_VERSION};\n            }\n            return false;\n        }\n    },\n\n    'SproutCore': {\n       id: 'sproutcore',\n       icon: 'sproutcore',\n       url: 'http://sproutcore.com/',\n       test: function(win) {\n           if (win.SC && win.SC.Application) {\n               return {version: UNKNOWN_VERSION};\n           }\n           return false;\n       }\n    },\n\n    'Zepto.js': {\n       id: 'zepto',\n       icon: 'zepto',\n       url: 'http://zeptojs.com',\n       npm: 'zepto',\n       test: function(win) {\n           if (win.Zepto && win.Zepto.fn) {\n               return {version: UNKNOWN_VERSION};\n           }\n           return false;\n       }\n    },\n\n    'three.js': {\n       id: 'threejs',\n       icon: 'icon38', // currently has no icon\n       url: 'https://threejs.org/',\n       npm: 'three',\n       test: function(win) {\n           if (win.THREE && win.THREE.REVISION) {\n               return {version: 'r' + win.THREE.REVISION};\n           }\n           else if (win.THREE) {\n               return {version: UNKNOWN_VERSION};\n           }\n           return false;\n       }\n    },\n\n    'PhiloGL': {\n       id: 'philogl',\n       icon: 'philogl',\n       url: 'http://www.senchalabs.org/philogl/',\n       npm: 'philogl',\n       test: function(win) {\n           if (win.PhiloGL && win.PhiloGL.Camera) {\n               return {version: win.PhiloGL.version || UNKNOWN_VERSION};\n           }\n           return false;\n       }\n    },\n\n    'CamanJS': {\n        id: 'camanjs',\n        icon: 'camanjs',\n        url: 'http://camanjs.com/',\n        npm: 'caman',\n        test: function(win) {\n            if (win.Caman && win.Caman.version) {\n                return {version: win.Caman.version.release};\n            }\n            else if (win.Caman) {\n                return {version: UNKNOWN_VERSION};\n            }\n            return false;\n        }\n    },\n\n    'yepnope': {\n        id: 'yepnope',\n        icon: 'yepnope',\n        url: 'http://yepnopejs.com/',\n        test: function(win) {\n            if (win.yepnope && win.yepnope.injectJs) {\n                return {version: UNKNOWN_VERSION};\n            }\n            return false;\n        }\n    },\n\n    'LABjs': {\n        id: 'labjs',\n        icon: 'icon38',\n        url: 'https://github.com/getify/LABjs',\n        test: function(win) {\n            if (win.$LAB && win.$LAB.setOptions) {\n                return {version: UNKNOWN_VERSION};\n            }\n            return false;\n        }\n    },\n\n    'Head JS': {\n        id: 'headjs',\n        icon: 'headjs',\n        url: 'http://headjs.com/',\n        npm: 'headjs',\n        test: function(win) {\n            if (win.head && win.head.js) {\n                return {version: UNKNOWN_VERSION};\n            }\n            return false;\n        }\n    },\n\n    'ControlJS': {\n        id: 'controljs',\n        icon: 'icon38',\n        url: 'http://stevesouders.com/controljs/',\n        test: function(win) {\n            if (win.CJS && win.CJS.start) {\n                return {version: UNKNOWN_VERSION};\n            }\n            return false;\n        }\n    },\n\n    'RequireJS': {\n        id: 'requirejs',\n        icon: 'requirejs',\n        url: 'http://requirejs.org/',\n        npm: 'requirejs',\n        test: function(win) {\n            var req = win.require || win.requirejs;\n            if (req && (req.load || (req.s && req.s.contexts && req.s.contexts._ && (req.s.contexts._.loaded || req.s.contexts._.load)))) {\n                return { version: req.version || UNKNOWN_VERSION };\n            }\n         