/*
 * Copyright (c) 2015 Canon Inc.
 * Copyright (c) 2015 Igalia.
 * Copyright (c) 2016 Apple Inc. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */

// DO NOT EDIT THIS FILE. It is automatically generated from JavaScript files for
// builtins by the script: Source/JavaScriptCore/Scripts/generate-js-builtins.py

#pragma once

#include <JavaScriptCore/BuiltinUtils.h>
#include <JavaScriptCore/Identifier.h>
#include <JavaScriptCore/JSFunction.h>
#include <JavaScriptCore/UnlinkedFunctionExecutable.h>

namespace JSC {
class FunctionExecutable;
}

namespace WebCore {

/* StreamInternals */
extern const char* const s_streamInternalsShieldingPromiseResolveCode;
extern const int s_streamInternalsShieldingPromiseResolveCodeLength;
extern const JSC::ConstructAbility s_streamInternalsShieldingPromiseResolveCodeConstructAbility;
extern const JSC::ConstructorKind s_streamInternalsShieldingPromiseResolveCodeConstructorKind;
extern const char* const s_streamInternalsPromiseInvokeOrNoopMethodNoCatchCode;
extern const int s_streamInternalsPromiseInvokeOrNoopMethodNoCatchCodeLength;
extern const JSC::ConstructAbility s_streamInternalsPromiseInvokeOrNoopMethodNoCatchCodeConstructAbility;
extern const JSC::ConstructorKind s_streamInternalsPromiseInvokeOrNoopMethodNoCatchCodeConstructorKind;
extern const char* const s_streamInternalsPromiseInvokeOrNoopNoCatchCode;
extern const int s_streamInternalsPromiseInvokeOrNoopNoCatchCodeLength;
extern const JSC::ConstructAbility s_streamInternalsPromiseInvokeOrNoopNoCatchCodeConstructAbility;
extern const JSC::ConstructorKind s_streamInternalsPromiseInvokeOrNoopNoCatchCodeConstructorKind;
extern const char* const s_streamInternalsPromiseInvokeOrNoopMethodCode;
extern const int s_streamInternalsPromiseInvokeOrNoopMethodCodeLength;
extern const JSC::ConstructAbility s_streamInternalsPromiseInvokeOrNoopMethodCodeConstructAbility;
extern const JSC::ConstructorKind s_streamInternalsPromiseInvokeOrNoopMethodCodeConstructorKind;
extern const char* const s_streamInternalsPromiseInvokeOrNoopCode;
extern const int s_streamInternalsPromiseInvokeOrNoopCodeLength;
extern const JSC::ConstructAbility s_streamInternalsPromiseInvokeOrNoopCodeConstructAbility;
extern const JSC::ConstructorKind s_streamInternalsPromiseInvokeOrNoopCodeConstructorKind;
extern const char* const s_streamInternalsPromiseInvokeOrFallbackOrNoopCode;
extern const int s_streamInternalsPromiseInvokeOrFallbackOrNoopCodeLength;
extern const JSC::ConstructAbility s_streamInternalsPromiseInvokeOrFallbackOrNoopCodeConstructAbility;
extern const JSC::ConstructorKind s_streamInternalsPromiseInvokeOrFallbackOrNoopCodeConstructorKind;
extern const char* const s_streamInternalsValidateAndNormalizeQueuingStrategyCode;
extern const int s_streamInternalsValidateAndNormalizeQueuingStrategyCodeLength;
extern const JSC::ConstructAbility s_streamInternalsValidateAndNormalizeQueuingStrategyCodeConstructAbility;
extern const JSC::ConstructorKind s_streamInternalsValidateAndNormalizeQueuingStrategyCodeConstructorKind;
extern const char* const s_streamInternalsNewQueueCode;
extern const int s_streamInternalsNewQueueCodeLength;
extern const JSC::ConstructAbility s_streamInternalsNewQueueCodeConstructAbility;
extern const JSC::ConstructorKind s_streamInternalsNewQueueCodeConstructorKind;
extern const char* const s_streamInternalsDequeueValueCode;
extern const int s_streamInternalsDequeueValueCodeLength;
extern const JSC::ConstructAbility s_streamInternalsDequeueValueCodeConstructAbility;
extern const JSC::ConstructorKind s_streamInternalsDequeueValueCodeConstructorKind;
extern const char* const s_streamInternalsEnqueueValueWithSizeCode;
extern const int s_streamInternalsEnqueueValueWithSizeCodeLength;
extern const JSC::ConstructAbility s_streamInternalsEnqueueValueWithSizeCodeConstructAbility;
extern const JSC::ConstructorKind s_streamInternalsEnqueueValueWithSizeCodeConstructorKind;
extern const char* const s_streamInternalsPeekQueueValueCode;
extern const int s_streamInternalsPeekQueueValueCodeLength;
extern const JSC::ConstructAbility s_streamInternalsPeekQueueValueCodeConstructAbility;
extern const JSC::ConstructorKind s_streamInternalsPeekQueueValueCodeConstructorKind;

#define WEBCORE_FOREACH_STREAMINTERNALS_BUILTIN_DATA(macro) \
    macro(shieldingPromiseResolve, streamInternalsShieldingPromiseResolve, 1) \
    macro(promiseInvokeOrNoopMethodNoCatch, streamInternalsPromiseInvokeOrNoopMethodNoCatch, 3) \
    macro(promiseInvokeOrNoopNoCatch, streamInternalsPromiseInvokeOrNoopNoCatch, 3) \
    macro(promiseInvokeOrNoopMethod, streamInternalsPromiseInvokeOrNoopMethod, 3) \
    macro(promiseInvokeOrNoop, streamInternalsPromiseInvokeOrNoop, 3) \
    macro(promiseInvokeOrFallbackOrNoop, streamInternalsPromiseInvokeOrFallbackOrNoop, 5) \
    macro(validateAndNormalizeQueuingStrategy, streamInternalsValidateAndNormalizeQueuingStrategy, 2) \
    macro(newQueue, streamInternalsNewQueue, 0) \
    macro(dequeueValue, streamInternalsDequeueValue, 1) \
    macro(enqueueValueWithSize, streamInternalsEnqueueValueWithSize, 3) \
    macro(peekQueueValue, streamInternalsPeekQueueValue, 1) \

#define WEBCORE_BUILTIN_STREAMINTERNALS_SHIELDINGPROMISERESOLVE 1
#define WEBCORE_BUILTIN_STREAMINTERNALS_PROMISEINVOKEORNOOPMETHODNOCATCH 1
#define WEBCORE_BUILTIN_STREAMINTERNALS_PROMISEINVOKEORNOOPNOCATCH 1
#define WEBCORE_BUILTIN_STREAMINTERNALS_PROMISEINVOKEORNOOPMETHOD 1
#define WEBCORE_BUILTIN_STREAMINTERNALS_PROMISEINVOKEORNOOP 1
#define WEBCORE_BUILTIN_STREAMINTERNALS_PROMISEINVOKEORFALLBACKORNOOP 1
#define WEBCORE_BUILTIN_STREAMINTERNALS_VALIDATEANDNORMALIZEQUEUINGSTRATEGY 1
#define WEBCORE_BUILTIN_STREAMINTERNALS_NEWQUEUE 1
#define WEBCORE_BUILTIN_STREAMINTERNALS_DEQUEUEVALUE 1
#define WEBCORE_BUILTIN_STREAMINTERNALS_ENQUEUEVALUEWITHSIZE 1
#define WEBCORE_BUILTIN_STREAMINTERNALS_PEEKQUEUEVALUE 1

#define WEBCORE_FOREACH_STREAMINTERNALS_BUILTIN_CODE(macro) \
    macro(streamInternalsShieldingPromiseResolveCode, shieldingPromiseResolve, static_cast<const char*>(nullptr), s_streamInternalsShieldingPromiseResolveCodeLength) \
    macro(streamInternalsPromiseInvokeOrNoopMethodNoCatchCode, promiseInvokeOrNoopMethodNoCatch, static_cast<const char*>(nullptr), s_streamInternalsPromiseInvokeOrNoopMethodNoCatchCodeLength) \
    macro(streamInternalsPromiseInvokeOrNoopNoCatchCode, promiseInvokeOrNoopNoCatch, static_cast<const char*>(nullptr), s_streamInternalsPromiseInvokeOrNoopNoCatchCodeLength) \
    macro(streamInternalsPromiseInvokeOrNoopMethodCode, promiseInvokeOrNoopMethod, static_cast<const char*>(nullptr), s_streamInternalsPromiseInvokeOrNoopMethodCodeLength) \
    macro(streamInternalsPromiseInvokeOrNoopCode, promiseInvokeOrNoop, static_cast<const char*>(nullptr), s_streamInternalsPromiseInvokeOrNoopCodeLength) \
    macro(streamInternalsPromiseInvokeOrFallbackOrNoopCode, promiseInvokeOrFallbackOrNoop, static_cast<const char*>(nullptr), s_streamInternalsPromiseInvokeOrFallbackOrNoopCodeLength) \
    macro(streamInternalsValidateAndNormalizeQueuingStrategyCode, validateAndNormalizeQueuingStrategy, static_cast<const char*>(nullptr), s_streamInternalsValidateAndNormalizeQueuingStrategyCodeLength) \
    macro(streamInternalsNewQueueCode, newQueue, static_cast<const char*>(nullptr), s_streamInternalsNewQueueCodeLength) \
    macro(streamInternalsDequeueValueCode, dequeueValue, static_cast<const char*>(nullptr), s_streamInternalsDequeueValueCodeLength) \
    macro(streamInternalsEnqueueValueWithSizeCode, enqueueValueWithSize, static_cast<const char*>(nullptr), s_streamInternalsEnqueueValueWithSizeCodeLength) \
    macro(streamInternalsPeekQueueValueCode, peekQueueValue, static_cast<const char*>(nullptr), s_streamInternalsPeekQueueValueCodeLength) \

#define WEBCORE_FOREACH_STREAMINTERNALS_BUILTIN_FUNCTION_NAME(macro) \
    macro(dequeueValue) \
    macro(enqueueValueWithSize) \
    macro(newQueue) \
    macro(peekQueueValue) \
    macro(promiseInvokeOrFallbackOrNoop) \
    macro(promiseInvokeOrNoop) \
    macro(promiseInvokeOrNoopMethod) \
    macro(promiseInvokeOrNoopMethodNoCatch) \
    macro(promiseInvokeOrNoopNoCatch) \
    macro(shieldingPromiseResolve) \
    macro(validateAndNormalizeQueuingStrategy) \

#define DECLARE_BUILTIN_GENERATOR(codeName, functionName, overriddenName, argumentCount) \
    JSC::FunctionExecutable* codeName##Generator(JSC::VM&);

WEBCORE_FOREACH_STREAMINTERNALS_BUILTIN_CODE(DECLARE_BUILTIN_GENERATOR)
#undef DECLARE_BUILTIN_GENERATOR

class StreamInternalsBuiltinsWrapper : private JSC::WeakHandleOwner {
public:
    explicit StreamInternalsBuiltinsWrapper(JSC::VM& vm)
        : m_vm(vm)
        WEBCORE_FOREACH_STREAMINTERNALS_BUILTIN_FUNCTION_NAME(INITIALIZE_BUILTIN_NAMES)
#define INITIALIZE_BUILTIN_SOURCE_MEMBERS(name, functionName, overriddenName, length) , m_##name##Source(JSC::makeSource(StringImpl::createFromLiteral(s_##name, length), { }))
        WEBCORE_FOREACH_STREAMINTERNALS_BUILTIN_CODE(INITIALIZE_BUILTIN_SOURCE_MEMBERS)
#undef INITIALIZE_BUILTIN_SOURCE_MEMBERS
    {
    }

#define EXPOSE_BUILTIN_EXECUTABLES(name, functionName, overriddenName, length) \
    JSC::UnlinkedFunctionExecutable* name##Executable(); \
    const JSC::SourceCode& name##Source() const { return m_##name##Source; }
    WEBCORE_FOREACH_STREAMINTERNALS_BUILTIN_CODE(EXPOSE_BUILTIN_EXECUTABLES)
#undef EXPOSE_BUILTIN_EXECUTABLES

    WEBCORE_FOREACH_STREAMINTERNALS_BUILTIN_FUNCTION_NAME(DECLARE_BUILTIN_IDENTIFIER_ACCESSOR)

    void exportNames();

private:
    JSC::VM& m_vm;

    WEBCORE_FOREACH_STREAMINTERNALS_BUILTIN_FUNCTION_NAME(DECLARE_BUILTIN_NAMES)

#define DECLARE_BUILTIN_SOURCE_MEMBERS(name, functionName, overriddenName, length) \
    JSC::SourceCode m_##name##Source;\
    JSC::Weak<JSC::UnlinkedFunctionExecutable> m_##name##Executable;
    WEBCORE_FOREACH_STREAMINTERNALS_BUILTIN_CODE(DECLARE_BUILTIN_SOURCE_MEMBERS)
#undef DECLARE_BUILTIN_SOURCE_MEMBERS

};

#define DEFINE_BUILTIN_EXECUTABLES(name, functionName, overriddenName, length) \
inline JSC::UnlinkedFunctionExecutable* StreamInternalsBuiltinsWrapper::name##Executable() \
{\
    if (!m_##name##Executable) {\
        JSC::Identifier executableName = functionName##PublicName();\
        if (overriddenName)\
            executableName = JSC::Identifier::fromString(m_vm, overriddenName);\
        m_##name##Executable = JSC::Weak<JSC::UnlinkedFunctionExecutable>(JSC::createBuiltinExecutable(m_vm, m_##name##Source, executableName, s_##name##ConstructorKind, s_##name##ConstructAbility), this, &m_##name##Executable);\
    }\
    return m_##name##Executable.get();\
}
WEBCORE_FOREACH_STREAMINTERNALS_BUILTIN_CODE(DEFINE_BUILTIN_EXECUTABLES)
#undef DEFINE_BUILTIN_EXECUTABLES

inline void StreamInternalsBuiltinsWrapper::exportNames()
{
#define EXPORT_FUNCTION_NAME(name) m_vm.propertyNames->appendExternalName(name##PublicName(), name##PrivateName());
    WEBCORE_FOREACH_STREAMINTERNALS_BUILTIN_FUNCTION_NAME(EXPORT_FUNCTION_NAME)
#undef EXPORT_FUNCTION_NAME
}

class StreamInternalsBuiltinFunctions {
public:
    explicit StreamInternalsBuiltinFunctions(JSC::VM& vm) : m_vm(vm) { }

    void init(JSC::JSGlobalObject&);
    void visit(JSC::SlotVisitor&);

public:
    JSC::VM& m_vm;

#define DECLARE_BUILTIN_SOURCE_MEMBERS(functionName) \
    JSC::WriteBarrier<JSC::JSFunction> m_##functionName##Function;
    WEBCORE_FOREACH_STREAMINTERNALS_BUILTIN_FUNCTION_NAME(DECLARE_BUILTIN_SOURCE_MEMBERS)
#undef DECLARE_BUILTIN_SOURCE_MEMBERS
};

inline void StreamInternalsBuiltinFunctions::init(JSC::JSGlobalObject& globalObject)
{
#define EXPORT_FUNCTION(codeName, functionName, overriddenName, length)\
    m_##functionName##Function.set(m_vm, &globalObject, JSC::JSFunction::create(m_vm, codeName##Generator(m_vm), &globalObject));
    WEBCORE_FOREACH_STREAMINTERNALS_BUILTIN_CODE(EXPORT_FUNCTION)
#undef EXPORT_FUNCTION
}

inline void StreamInternalsBuiltinFunctions::visit(JSC::SlotVisitor& visitor)
{
#define VISIT_FUNCTION(name) visitor.append(m_##name##Function);
    WEBCORE_FOREACH_STREAMINTERNALS_BUILTIN_FUNCTION_NAME(VISIT_FUNCTION)
#undef VISIT_FUNCTION
}


} // namespace WebCore
