/*
 * Copyright (c) 2015 Canon Inc. All rights reserved.
 * Copyright (c) 2015 Igalia.
 * Copyright (c) 2016 Apple Inc. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */

// DO NOT EDIT THIS FILE. It is automatically generated from JavaScript files for
// builtins by the script: Source/JavaScriptCore/Scripts/generate-js-builtins.py

#pragma once

#include <JavaScriptCore/BuiltinUtils.h>
#include <JavaScriptCore/Identifier.h>
#include <JavaScriptCore/JSFunction.h>
#include <JavaScriptCore/UnlinkedFunctionExecutable.h>

namespace JSC {
class FunctionExecutable;
}

namespace WebCore {

/* ReadableStreamInternals */
extern const char* const s_readableStreamInternalsReadableStreamReaderGenericInitializeCode;
extern const int s_readableStreamInternalsReadableStreamReaderGenericInitializeCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsReadableStreamReaderGenericInitializeCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsReadableStreamReaderGenericInitializeCodeConstructorKind;
extern const char* const s_readableStreamInternalsPrivateInitializeReadableStreamDefaultControllerCode;
extern const int s_readableStreamInternalsPrivateInitializeReadableStreamDefaultControllerCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsPrivateInitializeReadableStreamDefaultControllerCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsPrivateInitializeReadableStreamDefaultControllerCodeConstructorKind;
extern const char* const s_readableStreamInternalsSetupReadableStreamDefaultControllerCode;
extern const int s_readableStreamInternalsSetupReadableStreamDefaultControllerCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsSetupReadableStreamDefaultControllerCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsSetupReadableStreamDefaultControllerCodeConstructorKind;
extern const char* const s_readableStreamInternalsReadableStreamDefaultControllerErrorCode;
extern const int s_readableStreamInternalsReadableStreamDefaultControllerErrorCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsReadableStreamDefaultControllerErrorCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsReadableStreamDefaultControllerErrorCodeConstructorKind;
extern const char* const s_readableStreamInternalsReadableStreamPipeToCode;
extern const int s_readableStreamInternalsReadableStreamPipeToCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsReadableStreamPipeToCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsReadableStreamPipeToCodeConstructorKind;
extern const char* const s_readableStreamInternalsReadableStreamTeeCode;
extern const int s_readableStreamInternalsReadableStreamTeeCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsReadableStreamTeeCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsReadableStreamTeeCodeConstructorKind;
extern const char* const s_readableStreamInternalsDoStructuredCloneCode;
extern const int s_readableStreamInternalsDoStructuredCloneCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsDoStructuredCloneCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsDoStructuredCloneCodeConstructorKind;
extern const char* const s_readableStreamInternalsReadableStreamTeePullFunctionCode;
extern const int s_readableStreamInternalsReadableStreamTeePullFunctionCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsReadableStreamTeePullFunctionCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsReadableStreamTeePullFunctionCodeConstructorKind;
extern const char* const s_readableStreamInternalsReadableStreamTeeBranch1CancelFunctionCode;
extern const int s_readableStreamInternalsReadableStreamTeeBranch1CancelFunctionCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsReadableStreamTeeBranch1CancelFunctionCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsReadableStreamTeeBranch1CancelFunctionCodeConstructorKind;
extern const char* const s_readableStreamInternalsReadableStreamTeeBranch2CancelFunctionCode;
extern const int s_readableStreamInternalsReadableStreamTeeBranch2CancelFunctionCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsReadableStreamTeeBranch2CancelFunctionCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsReadableStreamTeeBranch2CancelFunctionCodeConstructorKind;
extern const char* const s_readableStreamInternalsIsReadableStreamCode;
extern const int s_readableStreamInternalsIsReadableStreamCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsIsReadableStreamCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsIsReadableStreamCodeConstructorKind;
extern const char* const s_readableStreamInternalsIsReadableStreamDefaultReaderCode;
extern const int s_readableStreamInternalsIsReadableStreamDefaultReaderCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsIsReadableStreamDefaultReaderCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsIsReadableStreamDefaultReaderCodeConstructorKind;
extern const char* const s_readableStreamInternalsIsReadableStreamDefaultControllerCode;
extern const int s_readableStreamInternalsIsReadableStreamDefaultControllerCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsIsReadableStreamDefaultControllerCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsIsReadableStreamDefaultControllerCodeConstructorKind;
extern const char* const s_readableStreamInternalsReadableStreamErrorCode;
extern const int s_readableStreamInternalsReadableStreamErrorCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsReadableStreamErrorCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsReadableStreamErrorCodeConstructorKind;
extern const char* const s_readableStreamInternalsReadableStreamDefaultControllerCallPullIfNeededCode;
extern const int s_readableStreamInternalsReadableStreamDefaultControllerCallPullIfNeededCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsReadableStreamDefaultControllerCallPullIfNeededCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsReadableStreamDefaultControllerCallPullIfNeededCodeConstructorKind;
extern const char* const s_readableStreamInternalsIsReadableStreamLockedCode;
extern const int s_readableStreamInternalsIsReadableStreamLockedCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsIsReadableStreamLockedCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsIsReadableStreamLockedCodeConstructorKind;
extern const char* const s_readableStreamInternalsReadableStreamDefaultControllerGetDesiredSizeCode;
extern const int s_readableStreamInternalsReadableStreamDefaultControllerGetDesiredSizeCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsReadableStreamDefaultControllerGetDesiredSizeCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsReadableStreamDefaultControllerGetDesiredSizeCodeConstructorKind;
extern const char* const s_readableStreamInternalsReadableStreamReaderGenericCancelCode;
extern const int s_readableStreamInternalsReadableStreamReaderGenericCancelCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsReadableStreamReaderGenericCancelCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsReadableStreamReaderGenericCancelCodeConstructorKind;
extern const char* const s_readableStreamInternalsReadableStreamCancelCode;
extern const int s_readableStreamInternalsReadableStreamCancelCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsReadableStreamCancelCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsReadableStreamCancelCodeConstructorKind;
extern const char* const s_readableStreamInternalsReadableStreamDefaultControllerCancelCode;
extern const int s_readableStreamInternalsReadableStreamDefaultControllerCancelCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsReadableStreamDefaultControllerCancelCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsReadableStreamDefaultControllerCancelCodeConstructorKind;
extern const char* const s_readableStreamInternalsReadableStreamDefaultControllerPullCode;
extern const int s_readableStreamInternalsReadableStreamDefaultControllerPullCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsReadableStreamDefaultControllerPullCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsReadableStreamDefaultControllerPullCodeConstructorKind;
extern const char* const s_readableStreamInternalsReadableStreamDefaultControllerCloseCode;
extern const int s_readableStreamInternalsReadableStreamDefaultControllerCloseCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsReadableStreamDefaultControllerCloseCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsReadableStreamDefaultControllerCloseCodeConstructorKind;
extern const char* const s_readableStreamInternalsReadableStreamCloseCode;
extern const int s_readableStreamInternalsReadableStreamCloseCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsReadableStreamCloseCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsReadableStreamCloseCodeConstructorKind;
extern const char* const s_readableStreamInternalsReadableStreamFulfillReadRequestCode;
extern const int s_readableStreamInternalsReadableStreamFulfillReadRequestCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsReadableStreamFulfillReadRequestCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsReadableStreamFulfillReadRequestCodeConstructorKind;
extern const char* const s_readableStreamInternalsReadableStreamDefaultControllerEnqueueCode;
extern const int s_readableStreamInternalsReadableStreamDefaultControllerEnqueueCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsReadableStreamDefaultControllerEnqueueCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsReadableStreamDefaultControllerEnqueueCodeConstructorKind;
extern const char* const s_readableStreamInternalsReadableStreamDefaultReaderReadCode;
extern const int s_readableStreamInternalsReadableStreamDefaultReaderReadCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsReadableStreamDefaultReaderReadCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsReadableStreamDefaultReaderReadCodeConstructorKind;
extern const char* const s_readableStreamInternalsReadableStreamAddReadRequestCode;
extern const int s_readableStreamInternalsReadableStreamAddReadRequestCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsReadableStreamAddReadRequestCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsReadableStreamAddReadRequestCodeConstructorKind;
extern const char* const s_readableStreamInternalsIsReadableStreamDisturbedCode;
extern const int s_readableStreamInternalsIsReadableStreamDisturbedCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsIsReadableStreamDisturbedCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsIsReadableStreamDisturbedCodeConstructorKind;
extern const char* const s_readableStreamInternalsReadableStreamReaderGenericReleaseCode;
extern const int s_readableStreamInternalsReadableStreamReaderGenericReleaseCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsReadableStreamReaderGenericReleaseCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsReadableStreamReaderGenericReleaseCodeConstructorKind;
extern const char* const s_readableStreamInternalsReadableStreamDefaultControllerCanCloseOrEnqueueCode;
extern const int s_readableStreamInternalsReadableStreamDefaultControllerCanCloseOrEnqueueCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsReadableStreamDefaultControllerCanCloseOrEnqueueCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInternalsReadableStreamDefaultControllerCanCloseOrEnqueueCodeConstructorKind;

#define WEBCORE_FOREACH_READABLESTREAMINTERNALS_BUILTIN_DATA(macro) \
    macro(readableStreamReaderGenericInitialize, readableStreamInternalsReadableStreamReaderGenericInitialize, 2) \
    macro(privateInitializeReadableStreamDefaultController, readableStreamInternalsPrivateInitializeReadableStreamDefaultController, 4) \
    macro(setupReadableStreamDefaultController, readableStreamInternalsSetupReadableStreamDefaultController, 7) \
    macro(readableStreamDefaultControllerError, readableStreamInternalsReadableStreamDefaultControllerError, 2) \
    macro(readableStreamPipeTo, readableStreamInternalsReadableStreamPipeTo, 2) \
    macro(readableStreamTee, readableStreamInternalsReadableStreamTee, 2) \
    macro(doStructuredClone, readableStreamInternalsDoStructuredClone, 1) \
    macro(readableStreamTeePullFunction, readableStreamInternalsReadableStreamTeePullFunction, 3) \
    macro(readableStreamTeeBranch1CancelFunction, readableStreamInternalsReadableStreamTeeBranch1CancelFunction, 2) \
    macro(readableStreamTeeBranch2CancelFunction, readableStreamInternalsReadableStreamTeeBranch2CancelFunction, 2) \
    macro(isReadableStream, readableStreamInternalsIsReadableStream, 1) \
    macro(isReadableStreamDefaultReader, readableStreamInternalsIsReadableStreamDefaultReader, 1) \
    macro(isReadableStreamDefaultController, readableStreamInternalsIsReadableStreamDefaultController, 1) \
    macro(readableStreamError, readableStreamInternalsReadableStreamError, 2) \
    macro(readableStreamDefaultControllerCallPullIfNeeded, readableStreamInternalsReadableStreamDefaultControllerCallPullIfNeeded, 1) \
    macro(isReadableStreamLocked, readableStreamInternalsIsReadableStreamLocked, 1) \
    macro(readableStreamDefaultControllerGetDesiredSize, readableStreamInternalsReadableStreamDefaultControllerGetDesiredSize, 1) \
    macro(readableStreamReaderGenericCancel, readableStreamInternalsReadableStreamReaderGenericCancel, 2) \
    macro(readableStreamCancel, readableStreamInternalsReadableStreamCancel, 2) \
    macro(readableStreamDefaultControllerCancel, readableStreamInternalsReadableStreamDefaultControllerCancel, 2) \
    macro(readableStreamDefaultControllerPull, readableStreamInternalsReadableStreamDefaultControllerPull, 1) \
    macro(readableStreamDefaultControllerClose, readableStreamInternalsReadableStreamDefaultControllerClose, 1) \
    macro(readableStreamClose, readableStreamInternalsReadableStreamClose, 1) \
    macro(readableStreamFulfillReadRequest, readableStreamInternalsReadableStreamFulfillReadRequest, 3) \
    macro(readableStreamDefaultControllerEnqueue, readableStreamInternalsReadableStreamDefaultControllerEnqueue, 2) \
    macro(readableStreamDefaultReaderRead, readableStreamInternalsReadableStreamDefaultReaderRead, 1) \
    macro(readableStreamAddReadRequest, readableStreamInternalsReadableStreamAddReadRequest, 1) \
    macro(isReadableStreamDisturbed, readableStreamInternalsIsReadableStreamDisturbed, 1) \
    macro(readableStreamReaderGenericRelease, readableStreamInternalsReadableStreamReaderGenericRelease, 1) \
    macro(readableStreamDefaultControllerCanCloseOrEnqueue, readableStreamInternalsReadableStreamDefaultControllerCanCloseOrEnqueue, 1) \

#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_READABLESTREAMREADERGENERICINITIALIZE 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_PRIVATEINITIALIZEREADABLESTREAMDEFAULTCONTROLLER 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_SETUPREADABLESTREAMDEFAULTCONTROLLER 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_READABLESTREAMDEFAULTCONTROLLERERROR 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_READABLESTREAMPIPETO 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_READABLESTREAMTEE 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_DOSTRUCTUREDCLONE 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_READABLESTREAMTEEPULLFUNCTION 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_READABLESTREAMTEEBRANCH1CANCELFUNCTION 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_READABLESTREAMTEEBRANCH2CANCELFUNCTION 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_ISREADABLESTREAM 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_ISREADABLESTREAMDEFAULTREADER 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_ISREADABLESTREAMDEFAULTCONTROLLER 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_READABLESTREAMERROR 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_READABLESTREAMDEFAULTCONTROLLERCALLPULLIFNEEDED 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_ISREADABLESTREAMLOCKED 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_READABLESTREAMDEFAULTCONTROLLERGETDESIREDSIZE 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_READABLESTREAMREADERGENERICCANCEL 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_READABLESTREAMCANCEL 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_READABLESTREAMDEFAULTCONTROLLERCANCEL 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_READABLESTREAMDEFAULTCONTROLLERPULL 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_READABLESTREAMDEFAULTCONTROLLERCLOSE 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_READABLESTREAMCLOSE 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_READABLESTREAMFULFILLREADREQUEST 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_READABLESTREAMDEFAULTCONTROLLERENQUEUE 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_READABLESTREAMDEFAULTREADERREAD 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_READABLESTREAMADDREADREQUEST 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_ISREADABLESTREAMDISTURBED 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_READABLESTREAMREADERGENERICRELEASE 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_READABLESTREAMDEFAULTCONTROLLERCANCLOSEORENQUEUE 1

#define WEBCORE_FOREACH_READABLESTREAMINTERNALS_BUILTIN_CODE(macro) \
    macro(readableStreamInternalsReadableStreamReaderGenericInitializeCode, readableStreamReaderGenericInitialize, static_cast<const char*>(nullptr), s_readableStreamInternalsReadableStreamReaderGenericInitializeCodeLength) \
    macro(readableStreamInternalsPrivateInitializeReadableStreamDefaultControllerCode, privateInitializeReadableStreamDefaultController, static_cast<const char*>(nullptr), s_readableStreamInternalsPrivateInitializeReadableStreamDefaultControllerCodeLength) \
    macro(readableStreamInternalsSetupReadableStreamDefaultControllerCode, setupReadableStreamDefaultController, static_cast<const char*>(nullptr), s_readableStreamInternalsSetupReadableStreamDefaultControllerCodeLength) \
    macro(readableStreamInternalsReadableStreamDefaultControllerErrorCode, readableStreamDefaultControllerError, static_cast<const char*>(nullptr), s_readableStreamInternalsReadableStreamDefaultControllerErrorCodeLength) \
    macro(readableStreamInternalsReadableStreamPipeToCode, readableStreamPipeTo, static_cast<const char*>(nullptr), s_readableStreamInternalsReadableStreamPipeToCodeLength) \
    macro(readableStreamInternalsReadableStreamTeeCode, readableStreamTee, static_cast<const char*>(nullptr), s_readableStreamInternalsReadableStreamTeeCodeLength) \
    macro(readableStreamInternalsDoStructuredCloneCode, doStructuredClone, static_cast<const char*>(nullptr), s_readableStreamInternalsDoStructuredCloneCodeLength) \
    macro(readableStreamInternalsReadableStreamTeePullFunctionCode, readableStreamTeePullFunction, static_cast<const char*>(nullptr), s_readableStreamInternalsReadableStreamTeePullFunctionCodeLength) \
    macro(readableStreamInternalsReadableStreamTeeBranch1CancelFunctionCode, readableStreamTeeBranch1CancelFunction, static_cast<const char*>(nullptr), s_readableStreamInternalsReadableStreamTeeBranch1CancelFunctionCodeLength) \
    macro(readableStreamInternalsReadableStreamTeeBranch2CancelFunctionCode, readableStreamTeeBranch2CancelFunction, static_cast<const char*>(nullptr), s_readableStreamInternalsReadableStreamTeeBranch2CancelFunctionCodeLength) \
    macro(readableStreamInternalsIsReadableStreamCode, isReadableStream, static_cast<const char*>(nullptr), s_readableStreamInternalsIsReadableStreamCodeLength) \
    macro(readableStreamInternalsIsReadableStreamDefaultReaderCode, isReadableStreamDefaultReader, static_cast<const char*>(nullptr), s_readableStreamInternalsIsReadableStreamDefaultReaderCodeLength) \
    macro(readableStreamInternalsIsReadableStreamDefaultControllerCode, isReadableStreamDefaultController, static_cast<const char*>(nullptr), s_readableStreamInternalsIsReadableStreamDefaultControllerCodeLength) \
    macro(readableStreamInternalsReadableStreamErrorCode, readableStreamError, static_cast<const char*>(nullptr), s_readableStreamInternalsReadableStreamErrorCodeLength) \
    macro(readableStreamInternalsReadableStreamDefaultControllerCallPullIfNeededCode, readableStreamDefaultControllerCallPullIfNeeded, static_cast<const char*>(nullptr), s_readableStreamInternalsReadableStreamDefaultControllerCallPullIfNeededCodeLength) \
    macro(readableStreamInternalsIsReadableStreamLockedCode, isReadableStreamLocked, static_cast<const char*>(nullptr), s_readableStreamInternalsIsReadableStreamLockedCodeLength) \
    macro(readableStreamInternalsReadableStreamDefaultControllerGetDesiredSizeCode, readableStreamDefaultControllerGetDesiredSize, static_cast<const char*>(nullptr), s_readableStreamInternalsReadableStreamDefaultControllerGetDesiredSizeCodeLength) \
    macro(readableStreamInternalsReadableStreamReaderGenericCancelCode, readableStreamReaderGenericCancel, static_cast<const char*>(nullptr), s_readableStreamInternalsReadableStreamReaderGenericCancelCodeLength) \
    macro(readableStreamInternalsReadableStreamCancelCode, readableStreamCancel, static_cast<const char*>(nullptr), s_readableStreamInternalsReadableStreamCancelCodeLength) \
    macro(readableStreamInternalsReadableStreamDefaultControllerCancelCode, readableStreamDefaultControllerCancel, static_cast<const char*>(nullptr), s_readableStreamInternalsReadableStreamDefaultControllerCancelCodeLength) \
    macro(readableStreamInternalsReadableStreamDefaultControllerPullCode, readableStreamDefaultControllerPull, static_cast<const char*>(nullptr), s_readableStreamInternalsReadableStreamDefaultControllerPullCodeLength) \
    macro(readableStreamInternalsReadableStreamDefaultControllerCloseCode, readableStreamDefaultControllerClose, static_cast<const char*>(nullptr), s_readableStreamInternalsReadableStreamDefaultControllerCloseCodeLength) \
    macro(readableStreamInternalsReadableStreamCloseCode, readableStreamClose, static_cast<const char*>(nullptr), s_readableStreamInternalsReadableStreamCloseCodeLength) \
    macro(readableStreamInternalsReadableStreamFulfillReadRequestCode, readableStreamFulfillReadRequest, static_cast<const char*>(nullptr), s_readableStreamInternalsReadableStreamFulfillReadRequestCodeLength) \
    macro(readableStreamInternalsReadableStreamDefaultControllerEnqueueCode, readableStreamDefaultControllerEnqueue, static_cast<const char*>(nullptr), s_readableStreamInternalsReadableStreamDefaultControllerEnqueueCodeLength) \
    macro(readableStreamInternalsReadableStreamDefaultReaderReadCode, readableStreamDefaultReaderRead, static_cast<const char*>(nullptr), s_readableStreamInternalsReadableStreamDefaultReaderReadCodeLength) \
    macro(readableStreamInternalsReadableStreamAddReadRequestCode, readableStreamAddReadRequest, static_cast<const char*>(nullptr), s_readableStreamInternalsReadableStreamAddReadRequestCodeLength) \
    macro(readableStreamInternalsIsReadableStreamDisturbedCode, isReadableStreamDisturbed, static_cast<const char*>(nullptr), s_readableStreamInternalsIsReadableStreamDisturbedCodeLength) \
    macro(readableStreamInternalsReadableStreamReaderGenericReleaseCode, readableStreamReaderGenericRelease, static_cast<const char*>(nullptr), s_readableStreamInternalsReadableStreamReaderGenericReleaseCodeLength) \
    macro(readableStreamInternalsReadableStreamDefaultControllerCanCloseOrEnqueueCode, readableStreamDefaultControllerCanCloseOrEnqueue, static_cast<const char*>(nullptr), s_readableStreamInternalsReadableStreamDefaultControllerCanCloseOrEnqueueCodeLength) \

#define WEBCORE_FOREACH_READABLESTREAMINTERNALS_BUILTIN_FUNCTION_NAME(macro) \
    macro(doStructuredClone) \
    macro(isReadableStream) \
    macro(isReadableStreamDefaultController) \
    macro(isReadableStreamDefaultReader) \
    macro(isReadableStreamDisturbed) \
    macro(isReadableStreamLocked) \
    macro(privateInitializeReadableStreamDefaultController) \
    macro(readableStreamAddReadRequest) \
    macro(readableStreamCancel) \
    macro(readableStreamClose) \
    macro(readableStreamDefaultControllerCallPullIfNeeded) \
    macro(readableStreamDefaultControllerCanCloseOrEnqueue) \
    macro(readableStreamDefaultControllerCancel) \
    macro(readableStreamDefaultControllerClose) \
    macro(readableStreamDefaultControllerEnqueue) \
    macro(readableStreamDefaultControllerError) \
    macro(readableStreamDefaultControllerGetDesiredSize) \
    macro(readableStreamDefaultControllerPull) \
    macro(readableStreamDefaultReaderRead) \
    macro(readableStreamError) \
    macro(readableStreamFulfillReadRequest) \
    macro(readableStreamPipeTo) \
    macro(readableStreamReaderGenericCancel) \
    macro(readableStreamReaderGenericInitialize) \
    macro(readableStreamReaderGenericRelease) \
    macro(readableStreamTee) \
    macro(readableStreamTeeBranch1CancelFunction) \
    macro(readableStreamTeeBranch2CancelFunction) \
    macro(readableStreamTeePullFunction) \
    macro(setupReadableStreamDefaultController) \

#define DECLARE_BUILTIN_GENERATOR(codeName, functionName, overriddenName, argumentCount) \
    JSC::FunctionExecutable* codeName##Generator(JSC::VM&);

WEBCORE_FOREACH_READABLESTREAMINTERNALS_BUILTIN_CODE(DECLARE_BUILTIN_GENERATOR)
#undef DECLARE_BUILTIN_GENERATOR

class ReadableStreamInternalsBuiltinsWrapper : private JSC::WeakHandleOwner {
public:
    explicit ReadableStreamInternalsBuiltinsWrapper(JSC::VM& vm)
        : m_vm(vm)
        WEBCORE_FOREACH_READABLESTREAMINTERNALS_BUILTIN_FUNCTION_NAME(INITIALIZE_BUILTIN_NAMES)
#define INITIALIZE_BUILTIN_SOURCE_MEMBERS(name, functionName, overriddenName, length) , m_##name##Source(JSC::makeSource(StringImpl::createFromLiteral(s_##name, length), { }))
        WEBCORE_FOREACH_READABLESTREAMINTERNALS_BUILTIN_CODE(INITIALIZE_BUILTIN_SOURCE_MEMBERS)
#undef INITIALIZE_BUILTIN_SOURCE_MEMBERS
    {
    }

#define EXPOSE_BUILTIN_EXECUTABLES(name, functionName, overriddenName, length) \
    JSC::UnlinkedFunctionExecutable* name##Executable(); \
    const JSC::SourceCode& name##Source() const { return m_##name##Source; }
    WEBCORE_FOREACH_READABLESTREAMINTERNALS_BUILTIN_CODE(EXPOSE_BUILTIN_EXECUTABLES)
#undef EXPOSE_BUILTIN_EXECUTABLES

    WEBCORE_FOREACH_READABLESTREAMINTERNALS_BUILTIN_FUNCTION_NAME(DECLARE_BUILTIN_IDENTIFIER_ACCESSOR)

    void exportNames();

private:
    JSC::VM& m_vm;

    WEBCORE_FOREACH_READABLESTREAMINTERNALS_BUILTIN_FUNCTION_NAME(DECLARE_BUILTIN_NAMES)

#define DECLARE_BUILTIN_SOURCE_MEMBERS(name, functionName, overriddenName, length) \
    JSC::SourceCode m_##name##Source;\
    JSC::Weak<JSC::UnlinkedFunctionExecutable> m_##name##Executable;
    WEBCORE_FOREACH_READABLESTREAMINTERNALS_BUILTIN_CODE(DECLARE_BUILTIN_SOURCE_MEMBERS)
#undef DECLARE_BUILTIN_SOURCE_MEMBERS

};

#define DEFINE_BUILTIN_EXECUTABLES(name, functionName, overriddenName, length) \
inline JSC::UnlinkedFunctionExecutable* ReadableStreamInternalsBuiltinsWrapper::name##Executable() \
{\
    if (!m_##name##Executable) {\
        JSC::Identifier executableName = functionName##PublicName();\
        if (overriddenName)\
            executableName = JSC::Identifier::fromString(m_vm, overriddenName);\
        m_##name##Executable = JSC::Weak<JSC::UnlinkedFunctionExecutable>(JSC::createBuiltinExecutable(m_vm, m_##name##Source, executableName, s_##name##ConstructorKind, s_##name##ConstructAbility), this, &m_##name##Executable);\
    }\
    return m_##name##Executable.get();\
}
WEBCORE_FOREACH_READABLESTREAMINTERNALS_BUILTIN_CODE(DEFINE_BUILTIN_EXECUTABLES)
#undef DEFINE_BUILTIN_EXECUTABLES

inline void ReadableStreamInternalsBuiltinsWrapper::exportNames()
{
#define EXPORT_FUNCTION_NAME(name) m_vm.propertyNames->appendExternalName(name##PublicName(), name##PrivateName());
    WEBCORE_FOREACH_READABLESTREAMINTERNALS_BUILTIN_FUNCTION_NAME(EXPORT_FUNCTION_NAME)
#undef EXPORT_FUNCTION_NAME
}

class ReadableStreamInternalsBuiltinFunctions {
public:
    explicit ReadableStreamInternalsBuiltinFunctions(JSC::VM& vm) : m_vm(vm) { }

    void init(JSC::JSGlobalObject&);
    void visit(JSC::SlotVisitor&);

public:
    JSC::VM& m_vm;

#define DECLARE_BUILTIN_SOURCE_MEMBERS(functionName) \
    JSC::WriteBarrier<JSC::JSFunction> m_##functionName##Function;
    WEBCORE_FOREACH_READABLESTREAMINTERNALS_BUILTIN_FUNCTION_NAME(DECLARE_BUILTIN_SOURCE_MEMBERS)
#undef DECLARE_BUILTIN_SOURCE_MEMBERS
};

inline void ReadableStreamInternalsBuiltinFunctions::init(JSC::JSGlobalObject& globalObject)
{
#define EXPORT_FUNCTION(codeName, functionName, overriddenName, length)\
    m_##functionName##Function.set(m_vm, &globalObject, JSC::JSFunction::create(m_vm, codeName##Generator(m_vm), &globalObject));
    WEBCORE_FOREACH_READABLESTREAMINTERNALS_BUILTIN_CODE(EXPORT_FUNCTION)
#undef EXPORT_FUNCTION
}

inline void ReadableStreamInternalsBuiltinFunctions::visit(JSC::SlotVisitor& visitor)
{
#define VISIT_FUNCTION(name) visitor.append(m_##name##Function);
    WEBCORE_FOREACH_READABLESTREAMINTERNALS_BUILTIN_FUNCTION_NAME(VISIT_FUNCTION)
#undef VISIT_FUNCTION
}


} // namespace WebCore
