/*
 * Copyright (C) 2014-2020 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#import <WebKit/WKPreferences.h>
#import <WebKit/WKPreferencesRefPrivate.h>

typedef NS_ENUM(NSInteger, _WKStorageBlockingPolicy) {
    _WKStorageBlockingPolicyAllowAll,
    _WKStorageBlockingPolicyBlockThirdParty,
    _WKStorageBlockingPolicyBlockAll,
} API_AVAILABLE(macos(10.10), ios(8.0));

typedef NS_OPTIONS(NSUInteger, _WKDebugOverlayRegions) {
    _WKNonFastScrollableRegion = 1 << 0,
    _WKWheelEventHandlerRegion = 1 << 1,
    _WKTouchActionRegion = 1 << 2,
    _WKEditableElementRegion = 1 << 3,
} API_AVAILABLE(macos(10.11), ios(9.0));

typedef NS_OPTIONS(NSUInteger, _WKJavaScriptRuntimeFlags) {
    _WKJavaScriptRuntimeFlagsAllEnabled = 0
} API_AVAILABLE(macos(10.11), ios(9.0));

typedef NS_ENUM(NSInteger, _WKEditableLinkBehavior) {
    _WKEditableLinkBehaviorDefault,
    _WKEditableLinkBehaviorAlwaysLive,
    _WKEditableLinkBehaviorOnlyLiveWithShiftKey,
    _WKEditableLinkBehaviorLiveWhenNotFocused,
    _WKEditableLinkBehaviorNeverLive,
} API_AVAILABLE(macos(10.13.4), ios(11.3));

typedef NS_ENUM(NSInteger, _WKPitchCorrectionAlgorithm) {
    _WKPitchCorrectionAlgorithmBestAllAround,
    _WKPitchCorrectionAlgorithmBestForMusic,
    _WKPitchCorrectionAlgorithmBestForSpeech,
} API_AVAILABLE(macos(12.0), ios(15.0));

@class _WKExperimentalFeature;
@class _WKInternalDebugFeature;

@interface WKPreferences () <NSCopying>
@end

@interface WKPreferences (WKPrivate)

// FIXME: This property should not have the verb "is" in it.
@property (nonatomic, setter=_setTelephoneNumberDetectionIsEnabled:) BOOL _telephoneNumberDetectionIsEnabled;
@property (nonatomic, setter=_setStorageBlockingPolicy:) _WKStorageBlockingPolicy _storageBlockingPolicy;

@property (nonatomic, setter=_setCompositingBordersVisible:) BOOL _compositingBordersVisible;
@property (nonatomic, setter=_setCompositingRepaintCountersVisible:) BOOL _compositingRepaintCountersVisible;
@property (nonatomic, setter=_setTiledScrollingIndicatorVisible:) BOOL _tiledScrollingIndicatorVisible;
@property (nonatomic, setter=_setResourceUsageOverlayVisible:) BOOL _resourceUsageOverlayVisible API_AVAILABLE(macos(10.12), ios(10.0));
@property (nonatomic, setter=_setVisibleDebugOverlayRegions:) _WKDebugOverlayRegions _visibleDebugOverlayRegions API_AVAILABLE(macos(10.11), ios(9.0));
@property (nonatomic, setter=_setSimpleLineLayoutEnabled:) BOOL _simpleLineLayoutEnabled API_AVAILABLE(macos(10.12), ios(10.0));
@property (nonatomic, setter=_setLegacyLineLayoutVisualCoverageEnabled:) BOOL _legacyLineLayoutVisualCoverageEnabled API_AVAILABLE(macos(10.11), ios(9.0));
@property (nonatomic, setter=_setContentChangeObserverEnabled:) BOOL _contentChangeObserverEnabled API_AVAILABLE(macos(10.15), ios(13.0));
@property (nonatomic, setter=_setAcceleratedDrawingEnabled:) BOOL _acceleratedDrawingEnabled API_AVAILABLE(macos(10.12), ios(10.0));
@property (nonatomic, setter=_setDisplayListDrawingEnabled:) BOOL _displayListDrawingEnabled API_AVAILABLE(macos(10.12), ios(10.0));
@property (nonatomic, setter=_setLargeImageAsyncDecodingEnabled:) BOOL _largeImageAsyncDecodingEnabled API_AVAILABLE(macos(10.12.3), ios(10.3));
@property (nonatomic, setter=_setNeedsInAppBrowserPrivacyQuirks:) BOOL _needsInAppBrowserPrivacyQuirks API_AVAILABLE(macos(11.0), ios(14.0));
@property (nonatomic, setter=_setAnimatedImageAsyncDecodingEnabled:) BOOL _animatedImageAsyncDecodingEnabled API_AVAILABLE(macos(10.12.3), ios(10.3));
@property (nonatomic, setter=_setTextAutosizingEnabled:) BOOL _textAutosizingEnabled API_AVAILABLE(macos(10.12), ios(10.0));
@property (nonatomic, setter=_setSubpixelAntialiasedLayerTextEnabled:) BOOL _subpixelAntialiasedLayerTextEnabled API_AVAILABLE(macos(10.12), ios(10.0));

@property (nonatomic, setter=_setDeveloperExtrasEnabled:) BOOL _developerExtrasEnabled API_AVAILABLE(macos(10.11), ios(9.0));

@property (nonatomic, setter=_setLogsPageMessagesToSystemConsoleEnabled:) BOOL _logsPageMessagesToSystemConsoleEnabled API_AVAILABLE(macos(10.11), ios(9.0));

@property (nonatomic, setter=_setHiddenPageDOMTimerThrottlingEnabled:) BOOL _hiddenPageDOMTimerThrottlingEnabled API_AVAILABLE(macos(10.12), ios(10.0));
@property (nonatomic, setter=_setHiddenPageDOMTimerThrottlingAutoIncreases:) BOOL _hiddenPageDOMTimerThrottlingAutoIncreases API_AVAILABLE(macos(10.12), ios(10.0));
@property (nonatomic, setter=_setPageVisibilityBasedProcessSuppressionEnabled:) BOOL _pageVisibilityBasedProcessSuppressionEnabled API_AVAILABLE(macos(10.12), ios(10.0));

@property (nonatomic, setter=_setAllowFileAccessFromFileURLs:) BOOL _allowFileAccessFromFileURLs API_AVAILABLE(macos(10.11), ios(9.0));
@property (nonatomic, setter=_setJavaScriptRuntimeFlags:) _WKJavaScriptRuntimeFlags _javaScriptRuntimeFlags API_AVAILABLE(macos(10.11), ios(9.0));

@property (nonatomic, setter=_setStandalone:, getter=_isStandalone) BOOL _standalone API_AVAILABLE(macos(10.11), ios(9.0));

@property (nonatomic, setter=_setDiagnosticLoggingEnabled:) BOOL _diagnosticLoggingEnabled API_AVAILABLE(macos(10.11), ios(9.0));

@property (nonatomic, setter=_setDefaultFontSize:) NSUInteger _defaultFontSize API_AVAILABLE(macos(10.12), ios(10.0));
@property (nonatomic, setter=_setDefaultFixedPitchFontSize:) NSUInteger _defaultFixedPitchFontSize API_AVAILABLE(macos(10.12), ios(10.0));
@property (nonatomic, copy, setter=_setFixedPitchFontFamily:) NSString *_fixedPitchFontFamily API_AVAILABLE(macos(10.12), ios(10.0));

// FIXME: This should be configured on the WKWebsiteDataStore.
// FIXME: This property should not have the verb "is" in it.
@property (nonatomic, setter=_setOfflineApplicationCacheIsEnabled:) BOOL _offlineApplicationCacheIsEnabled;
@property (nonatomic, setter=_setFullScreenEnabled:) BOOL _fullScreenEnabled API_AVAILABLE(macos(10.11), ios(9.0));
@property (nonatomic, setter=_setShouldSuppressKeyboardInputDuringProvisionalNavigation:) BOOL _shouldSuppressKeyboardInputDuringProvisionalNavigation API_AVAILABLE(macos(10.12.3), ios(10.3));
@property (nonatomic, setter=_setAllowsPictureInPictureMediaPlayback:) BOOL _allowsPictureInPictureMediaPlayback API_AVAILABLE(macos(10.13), ios(11.0));

@property (nonatomic, setter=_setApplePayCapabilityDisclosureAllowed:) BOOL _applePayCapabilityDisclosureAllowed API_AVAILABLE(macos(10.12), ios(10.0));

@property (nonatomic, setter=_setLoadsImagesAutomatically:) BOOL _loadsImagesAutomatically API_AVAILABLE(macos(10.13), ios(11.0));

@property (nonatomic, setter=_setPeerConnectionEnabled:) BOOL _peerConnectionEnabled API_AVAILABLE(macos(10.13.4), ios(11.3));
@property (nonatomic, setter=_setMediaDevicesEnabled:) BOOL _mediaDevicesEnabled API_AVAILABLE(macos(10.13), ios(11.0));
@property (nonatomic, setter=_setGetUserMediaRequiresFocus:) BOOL _getUserMediaRequiresFocus API_AVAILABLE(macos(12.1), ios(NA));
@property (nonatomic, setter=_setScreenCaptureEnabled:) BOOL _screenCaptureEnabled API_AVAILABLE(macos(10.13.4), ios(11.3));
@property (nonatomic, setter=_setMockCaptureDevicesEnabled:) BOOL _mockCaptureDevicesEnabled API_AVAILABLE(macos(10.13), ios(11.0));
@property (nonatomic, setter=_setMockCaptureDevicesPromptEnabled:) BOOL _mockCaptureDevicesPromptEnabled API_AVAILABLE(macos(10.13.4), ios(11.3));
@property (nonatomic, setter=_setMediaCaptureRequiresSecureConnection:) BOOL _mediaCaptureRequiresSecureConnection API_AVAILABLE(macos(10.13), ios(11.0));
@property (nonatomic, setter=_setEnumeratingAllNetworkInterfacesEnabled:) BOOL _enumeratingAllNetworkInterfacesEnabled API_AVAILABLE(macos(10.13), ios(11.0));
@property (nonatomic, setter=_setICECandidateFilteringEnabled:) BOOL _iceCandidateFilteringEnabled API_AVAILABLE(macos(10.13.4), ios(11.3));
@property (nonatomic, setter=_setWebRTCLegacyAPIEnabled:) BOOL _webRTCLegacyAPIEnabled API_AVAILABLE(macos(10.13), ios(11.0));
@property (nonatomic, setter=_setInactiveMediaCaptureSteamRepromptIntervalInMinutes:) double _inactiveMediaCaptureSteamRepromptIntervalInMinutes API_AVAILABLE(macos(10.13.4), ios(11.3));
@property (nonatomic, setter=_setInterruptAudioOnPageVisibilityChangeEnabled:) BOOL _interruptAudioOnPageVisibilityChangeEnabled API_AVAILABLE(macos(10.15), ios(13.0));

@property (nonatomic, setter=_setJavaScriptCanAccessClipboard:) BOOL _javaScriptCanAccessClipboard API_AVAILABLE(macos(10.13), ios(11.0));
@property (nonatomic, setter=_setDOMPasteAllowed:) BOOL _domPasteAllowed API_AVAILABLE(macos(10.13), ios(11.0));

@property (nonatomic, setter=_setShouldAllowUserInstalledFonts:) BOOL _shouldAllowUserInstalledFonts API_AVAILABLE(macos(10.13.4), ios(11.3));
@property (nonatomic, setter=_setShouldAllowDesignSystemUIFonts:) BOOL _shouldAllowDesignSystemUIFonts API_AVAILABLE(macos(10.15), ios(13.0));

@property (nonatomic, setter=_setEditableLinkBehavior:) _WKEditableLinkBehavior _editableLinkBehavior API_AVAILABLE(macos(10.13.4), ios(11.3));

@property (nonatomic, setter=_setAVFoundationEnabled:) BOOL _avFoundationEnabled API_AVAILABLE(macos(10.10), ios(12.0));

+ (NSArray<_WKInternalDebugFeature *> *)_internalDebugFeatures API_AVAILABLE(macos(10.14.4), ios(12.2));
- (BOOL)_isEnabledForInternalDebugFeature:(_WKInternalDebugFeature *)feature API_AVAILABLE(macos(10.14.4), ios(12.2));
- (void)_setEnabled:(BOOL)value forInternalDebugFeature:(_WKInternalDebugFeature *)feature API_AVAILABLE(macos(10.14.4), ios(12.2));

+ (NSArray<_WKExperimentalFeature *> *)_experimentalFeatures API_AVAILABLE(macos(10.12), ios(10.0));
- (BOOL)_isEnabledForFeature:(_WKExperimentalFeature *)feature API_AVAILABLE(macos(10.12), ios(10.0));
- (void)_setEnabled:(BOOL)value forFeature:(_WKExperimentalFeature *)feature API_AVAILABLE(macos(10.12), ios(10.0));
- (BOOL)_isEnabledForExperimentalFeature:(_WKExperimentalFeature *)feature API_AVAILABLE(macos(10.12), ios(10.0));
- (void)_setEnabled:(BOOL)value forExperimentalFeature:(_WKExperimentalFeature *)feature API_AVAILABLE(macos(10.12), ios(10.0));

@property (nonatomic, setter=_setShouldEnableTextAutosizingBoost:) BOOL _shouldEnableTextAutosizingBoost API_AVAILABLE(macos(10.14), ios(12.0));

@property (nonatomic, getter=_isSafeBrowsingEnabled, setter=_setSafeBrowsingEnabled:) BOOL _safeBrowsingEnabled API_AVAILABLE(macos(10.14.4), ios(12.2));

@property (nonatomic, setter=_setColorFilterEnabled:) BOOL _colorFilterEnabled API_AVAILABLE(macos(10.14), ios(12.0));
@property (nonatomic, setter=_setPunchOutWhiteBackgroundsInDarkMode:) BOOL _punchOutWhiteBackgroundsInDarkMode API_AVAILABLE(macos(10.14), ios(12.0));
@property (nonatomic, setter=_setLowPowerVideoAudioBufferSizeEnabled:) BOOL _lowPowerVideoAudioBufferSizeEnabled API_AVAILABLE(macos(10.14.4), ios(12.2));
@property (nonatomic, setter=_setShouldIgnoreMetaViewport:) BOOL _shouldIgnoreMetaViewport API_AVAILABLE(macos(10.14.4), ios(12.2));
@property (nonatomic, setter=_setVideoQualityIncludesDisplayCompositingEnabled:) BOOL _videoQualityIncludesDisplayCompositingEnabled API_AVAILABLE(macos(10.14.4), ios(12.2));
@property (nonatomic, setter=_setDeviceOrientationEventEnabled:) BOOL _deviceOrientationEventEnabled API_AVAILABLE(macos(10.14.4), ios(12.2));
@property (nonatomic, setter=_setNeedsSiteSpecificQuirks:) BOOL _needsSiteSpecificQuirks API_DEPRECATED_WITH_REPLACEMENT("siteSpecificQuirksModeEnabled", macos(10.13.4, 12.1), ios(13.0, NA));
@property (nonatomic, setter=_setItpDebugModeEnabled:) BOOL _itpDebugModeEnabled API_AVAILABLE(macos(10.15), ios(13.0));
@property (nonatomic, setter=_setMediaSourceEnabled:) BOOL _mediaSourceEnabled API_AVAILABLE(macos(10.13.4), ios(13.0));
@property (nonatomic, setter=_setSecureContextChecksEnabled:) BOOL _secureContextChecksEnabled API_AVAILABLE(macos(10.15.4), ios(13.4));
@property (nonatomic, setter=_setRemotePlaybackEnabled:) BOOL _remotePlaybackEnabled API_AVAILABLE(macos(10.15.4), ios(13.4));
@property (nonatomic, setter=_setWebAudioEnabled:) BOOL _webAudioEnabled API_AVAILABLE(macos(10.14), ios(13.4));
@property (nonatomic, setter=_setAcceleratedCompositingEnabled:) BOOL _acceleratedCompositingEnabled API_AVAILABLE(macos(10.13.4), ios(13.4));
@property (nonatomic, setter=_setRequestAnimationFrameEnabled:) BOOL _requestAnimationFrameEnabled API_AVAILABLE(macos(10.15.4), ios(13.4));
@property (nonatomic, setter=_setServiceWorkerEntitlementDisabledForTesting:) BOOL _serviceWorkerEntitlementDisabledForTesting API_AVAILABLE(macos(11.0), ios(14.0));
@property (nonatomic, setter=_setAccessibilityIsolatedTreeEnabled:) BOOL _accessibilityIsolatedTreeEnabled API_AVAILABLE(macos(10.16));
@property (nonatomic, setter=_setSpeechRecognitionEnabled:) BOOL _speechRecognitionEnabled API_AVAILABLE(macos(12.0), ios(15.0));
@property (nonatomic, setter=_setPrivateClickMeasurementEnabled:) BOOL _privateClickMeasurementEnabled API_AVAILABLE(macos(12.0), ios(15.0));
@property (nonatomic, setter=_setPitchCorrectionAlgorithm:) _WKPitchCorrectionAlgorithm _pitchCorrectionAlgorithm API_AVAILABLE(macos(12.0), ios(15.0));
@property (nonatomic, setter=_setMediaSessionEnabled:) BOOL _mediaSessionEnabled API_AVAILABLE(macos(12.0), ios(15.0));
@property (nonatomic, getter=_isExtensibleSSOEnabled, setter=_setExtensibleSSOEnabled:) BOOL _extensibleSSOEnabled API_AVAILABLE(macos(12.0), ios(15.0));
@property (nonatomic, setter=_setRequiresPageVisibilityToPlayAudio:) BOOL _requiresPageVisibilityToPlayAudio API_AVAILABLE(macos(12.0), ios(15.0));
@property (nonatomic, setter=_setFileSystemAccessEnabled:) BOOL _fileSystemAccessEnabled API_AVAILABLE(macos(12.1), ios(NA));
@property (nonatomic, setter=_setStorageAPIEnabled:) BOOL _storageAPIEnabled API_AVAILABLE(macos(12.1), ios(NA));
@property (nonatomic, setter=_setAccessHandleEnabled:) BOOL _accessHandleEnabled API_AVAILABLE(macos(12.1), ios(NA));
@property (nonatomic, setter=_setNotificationsEnabled:) BOOL _notificationsEnabled API_AVAILABLE(macos(10.13.4), ios(NA));
@property (nonatomic, setter=_setModelDocumentEnabled:) BOOL _modelDocumentEnabled API_AVAILABLE(macos(12.1), ios(NA));

#if !TARGET_OS_IPHONE
@property (nonatomic, setter=_setWebGLEnabled:) BOOL _webGLEnabled API_AVAILABLE(macos(10.13.4));
@property (nonatomic, setter=_setJavaEnabledForLocalFiles:) BOOL _javaEnabledForLocalFiles API_AVAILABLE(macos(10.13.4));
@property (nonatomic, setter=_setCanvasUsesAcceleratedDrawing:) BOOL _canvasUsesAcceleratedDrawing API_AVAILABLE(macos(10.13.4));
@property (nonatomic, setter=_setDefaultTextEncodingName:) NSString *_defaultTextEncodingName API_AVAILABLE(macos(10.13.4));
@property (nonatomic, setter=_setAuthorAndUserStylesEnabled:) BOOL _authorAndUserStylesEnabled API_AVAILABLE(macos(10.13.4));
@property (nonatomic, setter=_setDOMTimersThrottlingEnabled:) BOOL _domTimersThrottlingEnabled API_AVAILABLE(macos(10.13.4));
@property (nonatomic, setter=_setWebArchiveDebugModeEnabled:) BOOL _webArchiveDebugModeEnabled API_AVAILABLE(macos(10.13.4));
@property (nonatomic, setter=_setLocalFileContentSniffingEnabled:) BOOL _localFileContentSniffingEnabled API_AVAILABLE(macos(10.13.4));
@property (nonatomic, setter=_setUsesPageCache:) BOOL _usesPageCache API_AVAILABLE(macos(10.13.4));
@property (nonatomic, setter=_setPageCacheSupportsPlugins:) BOOL _pageCacheSupportsPlugins API_AVAILABLE(macos(10.13.4));
@property (nonatomic, setter=_setShouldPrintBackgrounds:) BOOL _shouldPrintBackgrounds API_AVAILABLE(macos(10.13.4));
@property (nonatomic, setter=_setWebSecurityEnabled:) BOOL _webSecurityEnabled API_AVAILABLE(macos(10.13.4));
@property (nonatomic, setter=_setUniversalAccessFromFileURLsAllowed:) BOOL _universalAccessFromFileURLsAllowed API_AVAILABLE(macos(10.13.4));
@property (nonatomic, setter=_setTopNavigationToDataURLsAllowed:) BOOL _topNavigationToDataURLsAllowed API_AVAILABLE(macos(11.0));
@property (nonatomic, setter=_setSuppressesIncrementalRendering:) BOOL _suppressesIncrementalRendering API_AVAILABLE(macos(10.13.4));
@property (nonatomic, setter=_setAsynchronousPluginInitializationEnabled:) BOOL _asynchronousPluginInitializationEnabled API_AVAILABLE(macos(10.13.4));
@property (nonatomic, setter=_setArtificialPluginInitializationDelayEnabled:) BOOL _artificialPluginInitializationDelayEnabled API_AVAILABLE(macos(10.13.4));
@property (nonatomic, setter=_setExperimentalPlugInSandboxProfilesEnabled:) BOOL _experimentalPlugInSandboxProfilesEnabled API_AVAILABLE(macos(10.14.4));
@property (nonatomic, setter=_setCookieEnabled:) BOOL _cookieEnabled API_AVAILABLE(macos(10.13.4));
@property (nonatomic, setter=_setPlugInSnapshottingEnabled:) BOOL _plugInSnapshottingEnabled API_AVAILABLE(macos(10.13.4));
@property (nonatomic, setter=_setViewGestureDebuggingEnabled:) BOOL _viewGestureDebuggingEnabled API_AVAILABLE(macos(10.13.4));
@property (nonatomic, setter=_setStandardFontFamily:) NSString *_standardFontFamily API_AVAILABLE(macos(10.13.4));
@property (nonatomic, setter=_setBackspaceKeyNavigationEnabled:) BOOL _backspaceKeyNavigationEnabled API_AVAILABLE(macos(10.13.4));
@property (nonatomic, setter=_setAllowsInlineMediaPlayback:) BOOL _allowsInlineMediaPlayback API_AVAILABLE(macos(10.14));
@property (nonatomic, setter=_setApplePayEnabled:) BOOL _applePayEnabled API_AVAILABLE(macos(10.14));
@property (nonatomic, setter=_setDNSPrefetchingEnabled:) BOOL _dnsPrefetchingEnabled API_AVAILABLE(macos(10.14));
@property (nonatomic, setter=_setInlineMediaPlaybackRequiresPlaysInlineAttribute:) BOOL _inlineMediaPlaybackRequiresPlaysInlineAttribute API_AVAILABLE(macos(10.14));
@property (nonatomic, setter=_setInvisibleMediaAutoplayNotPermitted:) BOOL _invisibleMediaAutoplayNotPermitted API_AVAILABLE(macos(10.14));
@property (nonatomic, setter=_setLegacyEncryptedMediaAPIEnabled:) BOOL _legacyEncryptedMediaAPIEnabled API_AVAILABLE(macos(10.14));
@property (nonatomic, setter=_setMainContentUserGestureOverrideEnabled:) BOOL _mainContentUserGestureOverrideEnabled API_AVAILABLE(macos(10.14));
@property (nonatomic, setter=_setMediaStreamEnabled:) BOOL _mediaStreamEnabled API_AVAILABLE(macos(10.14));
@property (nonatomic, setter=_setNeedsStorageAccessFromFileURLsQuirk:) BOOL _needsStorageAccessFromFileURLsQuirk API_AVAILABLE(macos(10.14));
@property (nonatomic, setter=_setPDFPluginEnabled:) BOOL _pdfPluginEnabled API_AVAILABLE(macos(10.14));
@property (nonatomic, setter=_setRequiresUserGestureForAudioPlayback:) BOOL _requiresUserGestureForAudioPlayback API_AVAILABLE(macos(10.14));
@property (nonatomic, setter=_setRequiresUserGestureForVideoPlayback:) BOOL _requiresUserGestureForVideoPlayback API_AVAILABLE(macos(10.14));
@property (nonatomic, setter=_setServiceControlsEnabled:) BOOL _serviceControlsEnabled API_AVAILABLE(macos(10.14));
@property (nonatomic, setter=_setShowsToolTipOverTruncatedText:) BOOL _showsToolTipOverTruncatedText API_AVAILABLE(macos(10.14));
@property (nonatomic, setter=_setTextAreasAreResizable:) BOOL _textAreasAreResizable API_AVAILABLE(macos(10.14));
@property (nonatomic, setter=_setUseGiantTiles:) BOOL _useGiantTiles API_AVAILABLE(macos(10.14));
@property (nonatomic, setter=_setWantsBalancedSetDefersLoadingBehavior:) BOOL _wantsBalancedSetDefersLoadingBehavior API_AVAILABLE(macos(10.14));
@property (nonatomic, setter=_setAggressiveTileRetentionEnabled:) BOOL _aggressiveTileRetentionEnabled API_AVAILABLE(macos(10.14));
@property (nonatomic, setter=_setAppNapEnabled:) BOOL _appNapEnabled API_AVAILABLE(macos(10.15));
#endif

@end

@interface WKPreferences (WKPrivateDeprecated)

#if !TARGET_OS_IPHONE
@property (nonatomic, setter=_setSubpixelCSSOMElementMetricsEnabled:) BOOL _subpixelCSSOMElementMetricsEnabled API_DEPRECATED("Subpixel CSSOM element metrics are no longer supported", macos(10.13.4, 10.15));
#endif

@end
