#!/bin/bash
set -eu -o pipefail

REQUIREDPACKAGES="libpixman-1-0:arm64 libxslt1.1:arm64 libgssapi-krb5-2:arm64 libxrender1:arm64 libx11-xcb1:arm64 libasound2:arm64 libicu70:arm64 libbrotli1:arm64 libdbus-1-3:arm64 libc6:arm64 libk5crypto3:arm64 gstreamer1.0-plugins-bad:arm64 shared-mime-info libflite1:arm64 gstreamer1.0-plugins-good:arm64 libdw1:arm64 libx11-6:arm64 libxext6:arm64 libxcb-render0:arm64 libsoup2.4-1:arm64 libgstreamer1.0-0:arm64 libudev1:arm64 gstreamer1.0-plugins-ugly:arm64 libxcb-shm0:arm64 libcap2:arm64 libwoff1:arm64 libwayland-server0:arm64 libffi8:arm64 ca-certificates libgpg-error0:arm64 libjpeg-turbo8:arm64 libsystemd0:arm64 libwayland-cursor0:arm64 libselinux1:arm64 libmd0:arm64 libopus0:arm64 libbz2-1.0:arm64 libharfbuzz0b:arm64 libwayland-client0:arm64 libevent-2.1-7:arm64 libcairo2:arm64 libxkbcommon0:arm64 liblzma5:arm64 libpcre3:arm64 libpng16-16:arm64 libgcrypt20:arm64 libdrm2:arm64 libfreetype6:arm64 libepoxy0:arm64 gstreamer1.0-gl:arm64 libxdmcp6:arm64 glib-networking:arm64 libzstd1:arm64 libpsl5:arm64 libgstreamer-gl1.0-0:arm64 libcom-err2:arm64 libxau6:arm64 libkrb5-3:arm64 dconf-gsettings-backend:arm64 libwayland-egl1:arm64 gstreamer1.0-libav:arm64 libgcc-s1:arm64 libwebpdemux2:arm64 libegl1:arm64 libtasn1-6:arm64 liborc-0.4-0:arm64 libelf1:arm64 libmount1:arm64 gstreamer1.0-plugins-base:arm64 libkrb5support0:arm64 libbsd0:arm64 libxml2:arm64 libunistring2:arm64 libsqlite3-0:arm64 libgudev-1.0-0:arm64 libgl1:arm64 libkeyutils1:arm64 libidn2-0:arm64 libgraphite2-3:arm64 zlib1g:arm64 libuuid1:arm64 libharfbuzz-icu0:arm64 libvpx7:arm64 libgstreamer-plugins-bad1.0-0:arm64 libxcb1:arm64 libglx0:arm64 liblz4-1:arm64 libpcre2-8-0:arm64 libstdc++6:arm64 libgbm1:arm64 libgstreamer-plugins-base1.0-0:arm64 liblcms2-2:arm64 libblkid1:arm64 libwebp7:arm64 libfontconfig1:arm64 libunwind8:arm64 libglib2.0-0:arm64 libexpat1:arm64 libglvnd0:arm64 libopenjp2-7:arm64"

if ! which apt-get >/dev/null; then
    echo "This script only supports apt-get based distributions like Debian or Ubuntu."
    exit 1
fi

# Calling dpkg-query is slow, so call it only once and cache the results
TMPCHECKPACKAGES="$(mktemp)"
dpkg-query --show --showformat='${binary:Package} ${db:Status-Status}\n' > "${TMPCHECKPACKAGES}"
TOINSTALL=""
for PACKAGE in ${REQUIREDPACKAGES}; do
    if ! grep -qxF "${PACKAGE} installed" "${TMPCHECKPACKAGES}"; then
        TOINSTALL="${TOINSTALL} ${PACKAGE}"
    fi
done
rm -f "${TMPCHECKPACKAGES}"

if [[ -z "${TOINSTALL}" ]]; then
    echo "All required dependencies are already installed"
else
    echo "Need to install the following extra packages: ${TOINSTALL}"
    [[ ${#} -gt 0 ]] && [[ "${1}" == "--printonly" ]] && exit 0
    SUDO=""
    [[ ${UID} -ne 0 ]] && SUDO="sudo"
    AUTOINSTALL=""
    if [[ ${#} -gt 0 ]] && [[ "${1}" == "--autoinstall" ]]; then
        AUTOINSTALL="-y"
        export DEBIAN_FRONTEND="noninteractive"
        [[ ${UID} -ne 0 ]] && SUDO="sudo --preserve-env=DEBIAN_FRONTEND"
        ${SUDO} apt-get update
    fi
    set -x
    ${SUDO} apt-get install --no-install-recommends ${AUTOINSTALL} ${TOINSTALL}
fi
