import'../text_editor/text_editor.js';(function(mod){if(typeof exports=="object"&&typeof module=="object")
mod(require("../../lib/codemirror"));else if(typeof define=="function"&&define.amd)
define(["../../lib/codemirror"],mod);else
mod(CodeMirror);})(function(CodeMirror){"use strict";function Context(indented,column,type,info,align,prev){this.indented=indented;this.column=column;this.type=type;this.info=info;this.align=align;this.prev=prev;}
function pushContext(state,col,type,info){var indent=state.indented;if(state.context&&state.context.type=="statement"&&type!="statement")
indent=state.context.indented;return state.context=new Context(indent,col,type,info,null,state.context);}
function popContext(state){var t=state.context.type;if(t==")"||t=="]"||t=="}")
state.indented=state.context.indented;return state.context=state.context.prev;}
function typeBefore(stream,state,pos){if(state.prevToken=="variable"||state.prevToken=="type")return true;if(/\S(?:[^- ]>|[*\]])\s*$|\*$/.test(stream.string.slice(0,pos)))return true;if(state.typeAtEndOfLine&&stream.column()==stream.indentation())return true;}
function isTopScope(context){for(;;){if(!context||context.type=="top")return true;if(context.type=="}"&&context.prev.info!="namespace")return false;context=context.prev;}}
CodeMirror.defineMode("clike",function(config,parserConfig){var indentUnit=config.indentUnit,statementIndentUnit=parserConfig.statementIndentUnit||indentUnit,dontAlignCalls=parserConfig.dontAlignCalls,keywords=parserConfig.keywords||{},types=parserConfig.types||{},builtin=parserConfig.builtin||{},blockKeywords=parserConfig.blockKeywords||{},defKeywords=parserConfig.defKeywords||{},atoms=parserConfig.atoms||{},hooks=parserConfig.hooks||{},multiLineStrings=parserConfig.multiLineStrings,indentStatements=parserConfig.indentStatements!==false,indentSwitch=parserConfig.indentSwitch!==false,namespaceSeparator=parserConfig.namespaceSeparator,isPunctuationChar=parserConfig.isPunctuationChar||/[\[\]{}\(\),;\:\.]/,numberStart=parserConfig.numberStart||/[\d\.]/,number=parserConfig.number||/^(?:0x[a-f\d]+|0b[01]+|(?:\d+\.?\d*|\.\d+)(?:e[-+]?\d+)?)(u|ll?|l|f)?/i,isOperatorChar=parserConfig.isOperatorChar||/[+\-*&%=<>!?|\/]/,isIdentifierChar=parserConfig.isIdentifierChar||/[\w\$_\xa1-\uffff]/,isReservedIdentifier=parserConfig.isReservedIdentifier||false;var curPunc,isDefKeyword;function tokenBase(stream,state){var ch=stream.next();if(hooks[ch]){var result=hooks[ch](stream,state);if(result!==false)return result;}
if(ch=='"'||ch=="'"){state.tokenize=tokenString(ch);return state.tokenize(stream,state);}
if(isPunctuationChar.test(ch)){curPunc=ch;return null;}
if(numberStart.test(ch)){stream.backUp(1);if(stream.match(number))return"number"
stream.next();}
if(ch=="/"){if(stream.eat("*")){state.tokenize=tokenComment;return tokenComment(stream,state);}
if(stream.eat("/")){stream.skipToEnd();return"comment";}}
if(isOperatorChar.test(ch)){while(!stream.match(/^\/[\/*]/,false)&&stream.eat(isOperatorChar)){}
return"operator";}
stream.eatWhile(isIdentifierChar);if(namespaceSeparator)while(stream.match(namespaceSeparator))
stream.eatWhile(isIdentifierChar);var cur=stream.current();if(contains(keywords,cur)){if(contains(blockKeywords,cur))curPunc="newstatement";if(contains(defKeywords,cur))isDefKeyword=true;return"keyword";}
if(contains(types,cur))return"type";if(contains(builtin,cur)||(isReservedIdentifier&&isReservedIdentifier(cur))){if(contains(blockKeywords,cur))curPunc="newstatement";return"builtin";}
if(contains(atoms,cur))return"atom";return"variable";}
function tokenString(quote){return function(stream,state){var escaped=false,next,end=false;while((next=stream.next())!=null){if(next==quote&&!escaped){end=true;break;}
escaped=!escaped&&next=="\\";}
if(end||!(escaped||multiLineStrings))
state.tokenize=null;return"string";};}
function tokenComment(stream,state){var maybeEnd=false,ch;while(ch=stream.next()){if(ch=="/"&&maybeEnd){state.tokenize=null;break;}
maybeEnd=(ch=="*");}
return"comment";}
function maybeEOL(stream,state){if(parserConfig.typeFirstDefinitions&&stream.eol()&&isTopScope(state.context))
state.typeAtEndOfLine=typeBefore(stream,state,stream.pos);}
return{startState:function(basecolumn){return{tokenize:null,context:new Context((basecolumn||0)-indentUnit,0,"top",null,false),indented:0,startOfLine:true,prevToken:null};},token:function(stream,state){var ctx=state.context;if(stream.sol()){if(ctx.align==null)ctx.align=false;state.indented=stream.indentation();state.startOfLine=true;}
if(stream.eatSpace()){maybeEOL(stream,state);return null;}
curPunc=isDefKeyword=null;var style=(state.tokenize||tokenBase)(stream,state);if(style=="comment"||style=="meta")return style;if(ctx.align==null)ctx.align=true;if(curPunc==";"||curPunc==":"||(curPunc==","&&stream.match(/^\s*(?:\/\/.*)?$/,false)))
while(state.context.type=="statement")popContext(state);else if(curPunc=="{")pushContext(state,stream.column(),"}");else if(curPunc=="[")pushContext(state,stream.column(),"]");else if(curPunc=="(")pushContext(state,stream.column(),")");else if(curPunc=="}"){while(ctx.type=="statement")ctx=popContext(state);if(ctx.type=="}")ctx=popContext(state);while(ctx.type=="statement")ctx=popContext(state);}
else if(curPunc==ctx.type)popContext(state);else if(indentStatements&&(((ctx.type=="}"||ctx.type=="top")&&curPunc!=";")||(ctx.type=="statement"&&curPunc=="newstatement"))){pushContext(state,stream.column(),"statement",stream.current());}
if(style=="variable"&&((state.prevToken=="def"||(parserConfig.typeFirstDefinitions&&typeBefore(stream,state,stream.start)&&isTopScope(state.context)&&stream.match(/^\s*\(/,false)))))
style="def";if(hooks.token){var result=hooks.token(stream,state,style);if(result!==undefined)style=result;}
if(style=="def"&&parserConfig.styleDefs===false)style="variable";state.startOfLine=false;state.prevToken=isDefKeyword?"def":style||curPunc;maybeEOL(stream,state);return style;},indent:function(state,textAfter){if(state.tokenize!=tokenBase&&state.tokenize!=null||state.typeAtEndOfLine)return CodeMirror.Pass;var ctx=state.context,firstChar=textAfter&&textAfter.charAt(0);var closing=firstChar==ctx.type;if(ctx.type=="statement"&&firstChar=="}")ctx=ctx.prev;if(parserConfig.dontIndentStatements)
while(ctx.type=="statement"&&parserConfig.dontIndentStatements.test(ctx.info))
ctx=ctx.prev;if(hooks.indent){var hook=hooks.indent(state,ctx,textAfter,indentUnit);if(typeof hook=="number")return hook}
var switchBlock=ctx.prev&&ctx.prev.info=="switch";if(parserConfig.allmanIndentation&&/[{(]/.test(firstChar)){while(ctx.type!="top"&&ctx.type!="}")ctx=ctx.prev;return ctx.indented}
if(ctx.type=="statement")
return ctx.indented+(firstChar=="{"?0:statementIndentUnit);if(ctx.align&&(!dontAlignCalls||ctx.type!=")"))
return ctx.column+(closing?0:1);if(ctx.type==")"&&!closing)
return ctx.indented+statementIndentUnit;return ctx.indented+(closing?0:indentUnit)+
(!closing&&switchBlock&&!/^(?:case|default)\b/.test(textAfter)?indentUnit:0);},electricInput:indentSwitch?/^\s*(?:case .*?:|default:|\{\}?|\})$/:/^\s*[{}]$/,blockCommentStart:"/*",blockCommentEnd:"*/",blockCommentContinue:" * ",lineComment:"//",fold:"brace"};});function words(str){var obj={},words=str.split(" ");for(var i=0;i<words.length;++i)obj[words[i]]=true;return obj;}
function contains(words,word){if(typeof words==="function"){return words(word);}else{return words.propertyIsEnumerable(word);}}
var cKeywords="auto if break case register continue return default do sizeof "+"static else struct switch extern typedef union for goto while enum const "+"volatile inline restrict asm fortran";var cppKeywords="alignas alignof and and_eq audit axiom bitand bitor catch "+"class compl concept constexpr const_cast decltype delete dynamic_cast "+"explicit export final friend import module mutable namespace new noexcept "+"not not_eq operator or or_eq override private protected public "+"reinterpret_cast requires static_assert static_cast template this "+"thread_local throw try typeid typename using virtual xor xor_eq";var objCKeywords="bycopy byref in inout oneway out self super atomic nonatomic retain copy "+"readwrite readonly strong weak assign typeof nullable nonnull null_resettable _cmd "+"@interface @implementation @end @protocol @encode @property @synthesize @dynamic @class "+"@public @package @private @protected @required @optional @try @catch @finally @import "+"@selector @encode @defs @synchronized @autoreleasepool @compatibility_alias @available";var objCBuiltins="FOUNDATION_EXPORT FOUNDATION_EXTERN NS_INLINE NS_FORMAT_FUNCTION "+" NS_RETURNS_RETAINEDNS_ERROR_ENUM NS_RETURNS_NOT_RETAINED NS_RETURNS_INNER_POINTER "+"NS_DESIGNATED_INITIALIZER NS_ENUM NS_OPTIONS NS_REQUIRES_NIL_TERMINATION "+"NS_ASSUME_NONNULL_BEGIN NS_ASSUME_NONNULL_END NS_SWIFT_NAME NS_REFINED_FOR_SWIFT";var basicCTypes=words("int long char short double float unsigned signed "+"void bool");var basicObjCTypes=words("SEL instancetype id Class Protocol BOOL");function cTypes(identifier){return contains(basicCTypes,identifier)||/.+_t$/.test(identifier);}
function objCTypes(identifier){return cTypes(identifier)||contains(basicObjCTypes,identifier);}
var cBlockKeywords="case do else for if switch while struct enum union";var cDefKeywords="struct enum union";function cppHook(stream,state){if(!state.startOfLine)return false
for(var ch,next=null;ch=stream.peek();){if(ch=="\\"&&stream.match(/^.$/)){next=cppHook;break}else if(ch=="/"&&stream.match(/^\/[\/\*]/,false)){break}
stream.next();}
state.tokenize=next;return"meta"}
function pointerHook(_stream,state){if(state.prevToken=="type")return"type";return false;}
function cIsReservedIdentifier(token){if(!token||token.length<2)return false;if(token[0]!='_')return false;return(token[1]=='_')||(token[1]!==token[1].toLowerCase());}
function cpp14Literal(stream){stream.eatWhile(/[\w\.']/);return"number";}
function cpp11StringHook(stream,state){stream.backUp(1);if(stream.match(/(R|u8R|uR|UR|LR)/)){var match=stream.match(/"([^\s\\()]{0,16})\(/);if(!match){return false;}
state.cpp11RawStringDelim=match[1];state.tokenize=tokenRawString;return tokenRawString(stream,state);}
if(stream.match(/(u8|u|U|L)/)){if(stream.match(/["']/,false)){return"string";}
return false;}
stream.next();return false;}
function cppLooksLikeConstructor(word){var lastTwo=/(\w+)::~?(\w+)$/.exec(word);return lastTwo&&lastTwo[1]==lastTwo[2];}
function tokenAtString(stream,state){var next;while((next=stream.next())!=null){if(next=='"'&&!stream.eat('"')){state.tokenize=null;break;}}
return"string";}
function tokenRawString(stream,state){var delim=state.cpp11RawStringDelim.replace(/[^\w\s]/g,'\\$&');var match=stream.match(new RegExp(".*?\\)"+delim+'"'));if(match)
state.tokenize=null;else
stream.skipToEnd();return"string";}
function def(mimes,mode){if(typeof mimes=="string")mimes=[mimes];var words=[];function add(obj){if(obj)for(var prop in obj)if(obj.hasOwnProperty(prop))
words.push(prop);}
add(mode.keywords);add(mode.types);add(mode.builtin);add(mode.atoms);if(words.length){mode.helperType=mimes[0];CodeMirror.registerHelper("hintWords",mimes[0],words);}
for(var i=0;i<mimes.length;++i)
CodeMirror.defineMIME(mimes[i],mode);}
def(["text/x-csrc","text/x-c","text/x-chdr"],{name:"clike",keywords:words(cKeywords),types:cTypes,blockKeywords:words(cBlockKeywords),defKeywords:words(cDefKeywords),typeFirstDefinitions:true,atoms:words("NULL true false"),isReservedIdentifier:cIsReservedIdentifier,hooks:{"#":cppHook,"*":pointerHook,},modeProps:{fold:["brace","include"]}});def(["text/x-c++src","text/x-c++hdr"],{name:"clike",keywords:words(cKeywords+" "+cppKeywords),types:cTypes,blockKeywords:words(cBlockKeywords+" class try catch"),defKeywords:words(cDefKeywords+" class namespace"),typeFirstDefinitions:true,atoms:words("true false NULL nullptr"),dontIndentStatements:/^template$/,isIdentifierChar:/[\w\$_~\xa1-\uffff]/,isReservedIdentifier:cIsReservedIdentifier,hooks:{"#":cppHook,"*":pointerHook,"u":cpp11StringHook,"U":cpp11StringHook,"L":cpp11StringHook,"R":cpp11StringHook,"0":cpp14Literal,"1":cpp14Literal,"2":cpp14Literal,"3":cpp14Literal,"4":cpp14Literal,"5":cpp14Literal,"6":cpp14Literal,"7":cpp14Literal,"8":cpp14Literal,"9":cpp14Literal,token:function(stream,state,style){if(style=="variable"&&stream.peek()=="("&&(state.prevToken==";"||state.prevToken==null||state.prevToken=="}")&&cppLooksLikeConstructor(stream.current()))
return"def";}},namespaceSeparator:"::",modeProps:{fold:["brace","include"]}});def("text/x-java",{name:"clike",keywords:words("abstract assert break case catch class const continue default "+"do else enum extends final finally for goto if implements import "+"instanceof interface native new package private protected public "+"return static strictfp super switch synchronized this throw throws transient "+"try volatile while @interface"),types:words("byte short int long float double boolean char void Boolean Byte Character Double Float "+"Integer Long Number Object Short String StringBuffer StringBuilder Void"),blockKeywords:words("catch class do else finally for if switch try while"),defKeywords:words("class interface enum @interface"),typeFirstDefinitions:true,atoms:words("true false null"),number:/^(?:0x[a-f\d_]+|0b[01_]+|(?:[\d_]+\.?\d*|\.\d+)(?:e[-+]?[\d_]+)?)(u|ll?|l|f)?/i,hooks:{"@":function(stream){if(stream.match('interface',false))return false;stream.eatWhile(/[\w\$_]/);return"meta";}},modeProps:{fold:["brace","import"]}});def("text/x-csharp",{name:"clike",keywords:words("abstract as async await base break case catch checked class const continue"+" default delegate do else enum event explicit extern finally fixed for"+" foreach goto if implicit in interface internal is lock namespace new"+" operator out override params private protected public readonly ref return sealed"+" sizeof stackalloc static struct switch this throw try typeof unchecked"+" unsafe using virtual void volatile while add alias ascending descending dynamic from get"+" global group into join let orderby partial remove select set value var yield"),types:words("Action Boolean Byte Char DateTime DateTimeOffset Decimal Double Func"+" Guid Int16 Int32 Int64 Object SByte Single String Task TimeSpan UInt16 UInt32"+" UInt64 bool byte char decimal double short int long object"+" sbyte float string ushort uint ulong"),blockKeywords:words("catch class do else finally for foreach if struct switch try while"),defKeywords:words("class interface namespace struct var"),typeFirstDefinitions:true,atoms:words("true false null"),hooks:{"@":function(stream,state){if(stream.eat('"')){state.tokenize=tokenAtString;return tokenAtString(stream,state);}
stream.eatWhile(/[\w\$_]/);return"meta";}}});function tokenTripleString(stream,state){var escaped=false;while(!stream.eol()){if(!escaped&&stream.match('"""')){state.tokenize=null;break;}
escaped=stream.next()=="\\"&&!escaped;}
return"string";}
function tokenNestedComment(depth){return function(stream,state){var ch;while(ch=stream.next()){if(ch=="*"&&stream.eat("/")){if(depth==1){state.tokenize=null;break}else{state.tokenize=tokenNestedComment(depth-1);return state.tokenize(stream,state)}}else if(ch=="/"&&stream.eat("*")){state.tokenize=tokenNestedComment(depth+1);return state.tokenize(stream,state)}}
return"comment"}}
def("text/x-scala",{name:"clike",keywords:words("abstract case catch class def do else extends final finally for forSome if "+"implicit import lazy match new null object override package private protected return "+"sealed super this throw trait try type val var while with yield _ "+"assert assume require print println printf readLine readBoolean readByte readShort "+"readChar readInt readLong readFloat readDouble"),types:words("AnyVal App Application Array BufferedIterator BigDecimal BigInt Char Console Either "+"Enumeration Equiv Error Exception Fractional Function IndexedSeq Int Integral Iterable "+"Iterator List Map Numeric Nil NotNull Option Ordered Ordering PartialFunction PartialOrdering "+"Product Proxy Range Responder Seq Serializable Set Specializable Stream StringBuilder "+"StringContext Symbol Throwable Traversable TraversableOnce Tuple Unit Vector "+"Boolean Byte Character CharSequence Class ClassLoader Cloneable Comparable "+"Compiler Double Exception Float Integer Long Math Number Object Package Pair Process "+"Runtime Runnable SecurityManager Short StackTraceElement StrictMath String "+"StringBuffer System Thread ThreadGroup ThreadLocal Throwable Triple Void"),multiLineStrings:true,blockKeywords:words("catch class enum do else finally for forSome if match switch try while"),defKeywords:words("class enum def object package trait type val var"),atoms:words("true false null"),indentStatements:false,indentSwitch:false,isOperatorChar:/[+\-*&%=<>!?|\/#:@]/,hooks:{"@":function(stream){stream.eatWhile(/[\w\$_]/);return"meta";},'"':function(stream,state){if(!stream.match('""'))return false;state.tokenize=tokenTripleString;return state.tokenize(stream,state);},"'":function(stream){stream.eatWhile(/[\w\$_\xa1-\uffff]/);return"atom";},"=":function(stream,state){var cx=state.context;if(cx.type=="}"&&cx.align&&stream.eat(">")){state.context=new Context(cx.indented,cx.column,cx.type,cx.info,null,cx.prev);return"operator"}else{return false}},"/":function(stream,state){if(!stream.eat("*"))return false
state.tokenize=tokenNestedComment(1);return state.tokenize(stream,state)}},modeProps:{closeBrackets:{pairs:'()[]{}""',triples:'"'}}});function tokenKotlinString(tripleString){return function(stream,state){var escaped=false,next,end=false;while(!stream.eol()){if(!tripleString&&!escaped&&stream.match('"')){end=true;break;}
if(tripleString&&stream.match('"""')){end=true;break;}
next=stream.next();if(!escaped&&next=="$"&&stream.match('{'))
stream.skipTo("}");escaped=!escaped&&next=="\\"&&!tripleString;}
if(end||!tripleString)
state.tokenize=null;return"string";}}
def("text/x-kotlin",{name:"clike",keywords:words("package as typealias class interface this super val operator "+"var fun for is in This throw return annotation "+"break continue object if else while do try when !in !is as? "+"file import where by get set abstract enum open inner override private public internal "+"protected catch finally out final vararg reified dynamic companion constructor init "+"sealed field property receiver param sparam lateinit data inline noinline tailrec "+"external annotation crossinline const operator infix suspend actual expect setparam"),types:words("Boolean Byte Character CharSequence Class ClassLoader Cloneable Comparable "+"Compiler Double Exception Float Integer Long Math Number Object Package Pair Process "+"Runtime Runnable SecurityManager Short StackTraceElement StrictMath String "+"StringBuffer System Thread ThreadGroup ThreadLocal Throwable Triple Void Annotation Any BooleanArray "+"ByteArray Char CharArray DeprecationLevel DoubleArray Enum FloatArray Function Int IntArray Lazy "+"LazyThreadSafetyMode LongArray Nothing ShortArray Unit"),intendSwitch:false,indentStatements:false,multiLineStrings:true,number:/^(?:0x[a-f\d_]+|0b[01_]+|(?:[\d_]+(\.\d+)?|\.\d+)(?:e[-+]?[\d_]+)?)(u|ll?|l|f)?/i,blockKeywords:words("catch class do else finally for if where try while enum"),defKeywords:words("class val var object interface fun"),atoms:words("true false null this"),hooks:{"@":function(stream){stream.eatWhile(/[\w\$_]/);return"meta";},'*':function(_stream,state){return state.prevToken=='.'?'variable':'operator';},'"':function(stream,state){state.tokenize=tokenKotlinString(stream.match('""'));return state.tokenize(stream,state);},"/":function(stream,state){if(!stream.eat("*"))return false;state.tokenize=tokenNestedComment(1);return state.tokenize(stream,state)},indent:function(state,ctx,textAfter,indentUnit){var firstChar=textAfter&&textAfter.charAt(0);if((state.prevToken=="}"||state.prevToken==")")&&textAfter=="")
return state.indented;if((state.prevToken=="operator"&&textAfter!="}"&&state.context.type!="}")||state.prevToken=="variable"&&firstChar=="."||(state.prevToken=="}"||state.prevToken==")")&&firstChar==".")
return indentUnit*2+ctx.indented;if(ctx.align&&ctx.type=="}")
return ctx.indented+(state.context.type==(textAfter||"").charAt(0)?0:indentUnit);}},modeProps:{closeBrackets:{triples:'"'}}});def(["x-shader/x-vertex","x-shader/x-fragment"],{name:"clike",keywords:words("sampler1D sampler2D sampler3D samplerCube "+"sampler1DShadow sampler2DShadow "+"const attribute uniform varying "+"break continue discard return "+"for while do if else struct "+"in out inout"),types:words("float int bool void "+"vec2 vec3 vec4 ivec2 ivec3 ivec4 bvec2 bvec3 bvec4 "+"mat2 mat3 mat4"),blockKeywords:words("for while do if else struct"),builtin:words("radians degrees sin cos tan asin acos atan "+"pow exp log exp2 sqrt inversesqrt "+"abs sign floor ceil fract mod min max clamp mix step smoothstep "+"length distance dot cross normalize ftransform faceforward "+"reflect refract matrixCompMult "+"lessThan lessThanEqual greaterThan greaterThanEqual "+"equal notEqual any all not "+"texture1D texture1DProj texture1DLod texture1DProjLod "+"texture2D texture2DProj texture2DLod texture2DProjLod "+"texture3D texture3DProj texture3DLod texture3DProjLod "+"textureCube textureCubeLod "+"shadow1D shadow2D shadow1DProj shadow2DProj "+"shadow1DLod shadow2DLod shadow1DProjLod shadow2DProjLod "+"dFdx dFdy fwidth "+"noise1 noise2 noise3 noise4"),atoms:words("true false "+"gl_FragColor gl_SecondaryColor gl_Normal gl_Vertex "+"gl_MultiTexCoord0 gl_MultiTexCoord1 gl_MultiTexCoord2 gl_MultiTexCoord3 "+"gl_MultiTexCoord4 gl_MultiTexCoord5 gl_MultiTexCoord6 gl_MultiTexCoord7 "+"gl_FogCoord gl_PointCoord "+"gl_Position gl_PointSize gl_ClipVertex "+"gl_FrontColor gl_BackColor gl_FrontSecondaryColor gl_BackSecondaryColor "+"gl_TexCoord gl_FogFragCoord "+"gl_FragCoord gl_FrontFacing "+"gl_FragData gl_FragDepth "+"gl_ModelViewMatrix gl_ProjectionMatrix gl_ModelViewProjectionMatrix "+"gl_TextureMatrix gl_NormalMatrix gl_ModelViewMatrixInverse "+"gl_ProjectionMatrixInverse gl_ModelViewProjectionMatrixInverse "+"gl_TexureMatrixTranspose gl_ModelViewMatrixInverseTranspose "+"gl_ProjectionMatrixInverseTranspose "+"gl_ModelViewProjectionMatrixInverseTranspose "+"gl_TextureMatrixInverseTranspose "+"gl_NormalScale gl_DepthRange gl_ClipPlane "+"gl_Point gl_FrontMaterial gl_BackMaterial gl_LightSource gl_LightModel "+"gl_FrontLightModelProduct gl_BackLightModelProduct "+"gl_TextureColor gl_EyePlaneS gl_EyePlaneT gl_EyePlaneR gl_EyePlaneQ "+"gl_FogParameters "+"gl_MaxLights gl_MaxClipPlanes gl_MaxTextureUnits gl_MaxTextureCoords "+"gl_MaxVertexAttribs gl_MaxVertexUniformComponents gl_MaxVaryingFloats "+"gl_MaxVertexTextureImageUnits gl_MaxTextureImageUnits "+"gl_MaxFragmentUniformComponents gl_MaxCombineTextureImageUnits "+"gl_MaxDrawBuffers"),indentSwitch:false,hooks:{"#":cppHook},modeProps:{fold:["brace","include"]}});def("text/x-nesc",{name:"clike",keywords:words(cKeywords+" as atomic async call command component components configuration event generic "+"implementation includes interface module new norace nx_struct nx_union post provides "+"signal task uses abstract extends"),types:cTypes,blockKeywords:words(cBlockKeywords),atoms:words("null true false"),hooks:{"#":cppHook},modeProps:{fold:["brace","include"]}});def("text/x-objectivec",{name:"clike",keywords:words(cKeywords+" "+objCKeywords),types:objCTypes,builtin:words(objCBuiltins),blockKeywords:words(cBlockKeywords+" @synthesize @try @catch @finally @autoreleasepool @synchronized"),defKeywords:words(cDefKeywords+" @interface @implementation @protocol @class"),dontIndentStatements:/^@.*$/,typeFirstDefinitions:true,atoms:words("YES NO NULL Nil nil true false nullptr"),isReservedIdentifier:cIsReservedIdentifier,hooks:{"#":cppHook,"*":pointerHook,},modeProps:{fold:["brace","include"]}});def("text/x-objectivec++",{name:"clike",keywords:words(cKeywords+" "+objCKeywords+" "+cppKeywords),types:objCTypes,builtin:words(objCBuiltins),blockKeywords:words(cBlockKeywords+" @synthesize @try @catch @finally @autoreleasepool @synchronized class try catch"),defKeywords:words(cDefKeywords+" @interface @implementation @protocol @class class namespace"),dontIndentStatements:/^@.*$|^template$/,typeFirstDefinitions:true,atoms:words("YES NO NULL Nil nil true false nullptr"),isReservedIdentifier:cIsReservedIdentifier,hooks:{"#":cppHook,"*":pointerHook,"u":cpp11StringHook,"U":cpp11StringHook,"L":cpp11StringHook,"R":cpp11StringHook,"0":cpp14Literal,"1":cpp14Literal,"2":cpp14Literal,"3":cpp14Literal,"4":cpp14Literal,"5":cpp14Literal,"6":cpp14Literal,"7":cpp14Literal,"8":cpp14Literal,"9":cpp14Literal,token:function(stream,state,style){if(style=="variable"&&stream.peek()=="("&&(state.prevToken==";"||state.prevToken==null||state.prevToken=="}")&&cppLooksLikeConstructor(stream.current()))
return"def";}},namespaceSeparator:"::",modeProps:{fold:["brace","include"]}});def("text/x-squirrel",{name:"clike",keywords:words("base break clone continue const default delete enum extends function in class"+" foreach local resume return this throw typeof yield constructor instanceof static"),types:cTypes,blockKeywords:words("case catch class else for foreach if switch try while"),defKeywords:words("function local class"),typeFirstDefinitions:true,atoms:words("true false null"),hooks:{"#":cppHook},modeProps:{fold:["brace","include"]}});var stringTokenizer=null;function tokenCeylonString(type){return function(stream,state){var escaped=false,next,end=false;while(!stream.eol()){if(!escaped&&stream.match('"')&&(type=="single"||stream.match('""'))){end=true;break;}
if(!escaped&&stream.match('``')){stringTokenizer=tokenCeylonString(type);end=true;break;}
next=stream.next();escaped=type=="single"&&!escaped&&next=="\\";}
if(end)
state.tokenize=null;return"string";}}
def("text/x-ceylon",{name:"clike",keywords:words("abstracts alias assembly assert assign break case catch class continue dynamic else"+" exists extends finally for function given if import in interface is let module new"+" nonempty object of out outer package return satisfies super switch then this throw"+" try value void while"),types:function(word){var first=word.charAt(0);return(first===first.toUpperCase()&&first!==first.toLowerCase());},blockKeywords:words("case catch class dynamic else finally for function if interface module new object switch try while"),defKeywords:words("class dynamic function interface module object package value"),builtin:words("abstract actual aliased annotation by default deprecated doc final formal late license"+" native optional sealed see serializable shared suppressWarnings tagged throws variable"),isPunctuationChar:/[\[\]{}\(\),;\:\.`]/,isOperatorChar:/[+\-*&%=<>!?|^~:\/]/,numberStart:/[\d#$]/,number:/^(?:#[\da-fA-F_]+|\$[01_]+|[\d_]+[kMGTPmunpf]?|[\d_]+\.[\d_]+(?:[eE][-+]?\d+|[kMGTPmunpf]|)|)/i,multiLineStrings:true,typeFirstDefinitions:true,atoms:words("true false null larger smaller equal empty finished"),indentSwitch:false,styleDefs:false,hooks:{"@":function(stream){stream.eatWhile(/[\w\$_]/);return"meta";},'"':function(stream,state){state.tokenize=tokenCeylonString(stream.match('""')?"triple":"single");return state.tokenize(stream,state);},'`':function(stream,state){if(!stringTokenizer||!stream.match('`'))return false;state.tokenize=stringTokenizer;stringTokenizer=null;return state.tokenize(stream,state);},"'":function(stream){stream.eatWhile(/[\w\$_\xa1-\uffff]/);return"atom";},token:function(_stream,state,style){if((style=="variable"||style=="type")&&state.prevToken=="."){return"variable-2";}}},modeProps:{fold:["brace","import"],closeBrackets:{triples:'"'}}});});(function(mod){if(typeof exports=="object"&&typeof module=="object")
mod(require("../../lib/codemirror"));else if(typeof define=="function"&&define.amd)
define(["../../lib/codemirror"],mod);else
mod(CodeMirror);})(function(CodeMirror){"use strict";CodeMirror.defineMode("coffeescript",function(conf,parserConf){var ERRORCLASS="error";function wordRegexp(words){return new RegExp("^(("+words.join(")|(")+"))\\b");}
var operators=/^(?:->|=>|\+[+=]?|-[\-=]?|\*[\*=]?|\/[\/=]?|[=!]=|<[><]?=?|>>?=?|%=?|&=?|\|=?|\^=?|\~|!|\?|(or|and|\|\||&&|\?)=)/;var delimiters=/^(?:[()\[\]{},:`=;]|\.\.?\.?)/;var identifiers=/^[_A-Za-z$][_A-Za-z$0-9]*/;var atProp=/^@[_A-Za-z$][_A-Za-z$0-9]*/;var wordOperators=wordRegexp(["and","or","not","is","isnt","in","instanceof","typeof"]);var indentKeywords=["for","while","loop","if","unless","else","switch","try","catch","finally","class"];var commonKeywords=["break","by","continue","debugger","delete","do","in","of","new","return","then","this","@","throw","when","until","extends"];var keywords=wordRegexp(indentKeywords.concat(commonKeywords));indentKeywords=wordRegexp(indentKeywords);var stringPrefixes=/^('{3}|\"{3}|['\"])/;var regexPrefixes=/^(\/{3}|\/)/;var commonConstants=["Infinity","NaN","undefined","null","true","false","on","off","yes","no"];var constants=wordRegexp(commonConstants);function tokenBase(stream,state){if(stream.sol()){if(state.scope.align===null)state.scope.align=false;var scopeOffset=state.scope.offset;if(stream.eatSpace()){var lineOffset=stream.indentation();if(lineOffset>scopeOffset&&state.scope.type=="coffee"){return"indent";}else if(lineOffset<scopeOffset){return"dedent";}
return null;}else{if(scopeOffset>0){dedent(stream,state);}}}
if(stream.eatSpace()){return null;}
var ch=stream.peek();if(stream.match("####")){stream.skipToEnd();return"comment";}
if(stream.match("###")){state.tokenize=longComment;return state.tokenize(stream,state);}
if(ch==="#"){stream.skipToEnd();return"comment";}
if(stream.match(/^-?[0-9\.]/,false)){var floatLiteral=false;if(stream.match(/^-?\d*\.\d+(e[\+\-]?\d+)?/i)){floatLiteral=true;}
if(stream.match(/^-?\d+\.\d*/)){floatLiteral=true;}
if(stream.match(/^-?\.\d+/)){floatLiteral=true;}
if(floatLiteral){if(stream.peek()=="."){stream.backUp(1);}
return"number";}
var intLiteral=false;if(stream.match(/^-?0x[0-9a-f]+/i)){intLiteral=true;}
if(stream.match(/^-?[1-9]\d*(e[\+\-]?\d+)?/)){intLiteral=true;}
if(stream.match(/^-?0(?![\dx])/i)){intLiteral=true;}
if(intLiteral){return"number";}}
if(stream.match(stringPrefixes)){state.tokenize=tokenFactory(stream.current(),false,"string");return state.tokenize(stream,state);}
if(stream.match(regexPrefixes)){if(stream.current()!="/"||stream.match(/^.*\//,false)){state.tokenize=tokenFactory(stream.current(),true,"string-2");return state.tokenize(stream,state);}else{stream.backUp(1);}}
if(stream.match(operators)||stream.match(wordOperators)){return"operator";}
if(stream.match(delimiters)){return"punctuation";}
if(stream.match(constants)){return"atom";}
if(stream.match(atProp)||state.prop&&stream.match(identifiers)){return"property";}
if(stream.match(keywords)){return"keyword";}
if(stream.match(identifiers)){return"variable";}
stream.next();return ERRORCLASS;}
function tokenFactory(delimiter,singleline,outclass){return function(stream,state){while(!stream.eol()){stream.eatWhile(/[^'"\/\\]/);if(stream.eat("\\")){stream.next();if(singleline&&stream.eol()){return outclass;}}else if(stream.match(delimiter)){state.tokenize=tokenBase;return outclass;}else{stream.eat(/['"\/]/);}}
if(singleline){if(parserConf.singleLineStringErrors){outclass=ERRORCLASS;}else{state.tokenize=tokenBase;}}
return outclass;};}
function longComment(stream,state){while(!stream.eol()){stream.eatWhile(/[^#]/);if(stream.match("###")){state.tokenize=tokenBase;break;}
stream.eatWhile("#");}
return"comment";}
function indent(stream,state,type){type=type||"coffee";var offset=0,align=false,alignOffset=null;for(var scope=state.scope;scope;scope=scope.prev){if(scope.type==="coffee"||scope.type=="}"){offset=scope.offset+conf.indentUnit;break;}}
if(type!=="coffee"){align=null;alignOffset=stream.column()+stream.current().length;}else if(state.scope.align){state.scope.align=false;}
state.scope={offset:offset,type:type,prev:state.scope,align:align,alignOffset:alignOffset};}
function dedent(stream,state){if(!state.scope.prev)return;if(state.scope.type==="coffee"){var _indent=stream.indentation();var matched=false;for(var scope=state.scope;scope;scope=scope.prev){if(_indent===scope.offset){matched=true;break;}}
if(!matched){return true;}
while(state.scope.prev&&state.scope.offset!==_indent){state.scope=state.scope.prev;}
return false;}else{state.scope=state.scope.prev;return false;}}
function tokenLexer(stream,state){var style=state.tokenize(stream,state);var current=stream.current();if(current==="return"){state.dedent=true;}
if(((current==="->"||current==="=>")&&stream.eol())||style==="indent"){indent(stream,state);}
var delimiter_index="[({".indexOf(current);if(delimiter_index!==-1){indent(stream,state,"])}".slice(delimiter_index,delimiter_index+1));}
if(indentKeywords.exec(current)){indent(stream,state);}
if(current=="then"){dedent(stream,state);}
if(style==="dedent"){if(dedent(stream,state)){return ERRORCLASS;}}
delimiter_index="])}".indexOf(current);if(delimiter_index!==-1){while(state.scope.type=="coffee"&&state.scope.prev)
state.scope=state.scope.prev;if(state.scope.type==current)
state.scope=state.scope.prev;}
if(state.dedent&&stream.eol()){if(state.scope.type=="coffee"&&state.scope.prev)
state.scope=state.scope.prev;state.dedent=false;}
return style;}
var external={startState:function(basecolumn){return{tokenize:tokenBase,scope:{offset:basecolumn||0,type:"coffee",prev:null,align:false},prop:false,dedent:0};},token:function(stream,state){var fillAlign=state.scope.align===null&&state.scope;if(fillAlign&&stream.sol())fillAlign.align=false;var style=tokenLexer(stream,state);if(style&&style!="comment"){if(fillAlign)fillAlign.align=true;state.prop=style=="punctuation"&&stream.current()==".";}
return style;},indent:function(state,text){if(state.tokenize!=tokenBase)return 0;var scope=state.scope;var closer=text&&"])}".indexOf(text.charAt(0))>-1;if(closer)while(scope.type=="coffee"&&scope.prev)scope=scope.prev;var closes=closer&&scope.type===text.charAt(0);if(scope.align)
return scope.alignOffset-(closes?1:0);else
return(closes?scope.prev:scope).offset;},lineComment:"#",fold:"indent"};return external;});CodeMirror.defineMIME("application/vnd.coffeescript","coffeescript");CodeMirror.defineMIME("text/x-coffeescript","coffeescript");CodeMirror.defineMIME("text/coffeescript","coffeescript");});(function(mod){if(typeof exports=="object"&&typeof module=="object")
mod(require("../../lib/codemirror"),require("../htmlmixed/htmlmixed"),require("../clike/clike"));else if(typeof define=="function"&&define.amd)
define(["../../lib/codemirror","../htmlmixed/htmlmixed","../clike/clike"],mod);else
mod(CodeMirror);})(function(CodeMirror){"use strict";function keywords(str){var obj={},words=str.split(" ");for(var i=0;i<words.length;++i)obj[words[i]]=true;return obj;}
function matchSequence(list,end,escapes){if(list.length==0)return phpString(end);return function(stream,state){var patterns=list[0];for(var i=0;i<patterns.length;i++)if(stream.match(patterns[i][0])){state.tokenize=matchSequence(list.slice(1),end);return patterns[i][1];}
state.tokenize=phpString(end,escapes);return"string";};}
function phpString(closing,escapes){return function(stream,state){return phpString_(stream,state,closing,escapes);};}
function phpString_(stream,state,closing,escapes){if(escapes!==false&&stream.match("${",false)||stream.match("{$",false)){state.tokenize=null;return"string";}
if(escapes!==false&&stream.match(/^\$[a-zA-Z_][a-zA-Z0-9_]*/)){if(stream.match("[",false)){state.tokenize=matchSequence([[["[",null]],[[/\d[\w\.]*/,"number"],[/\$[a-zA-Z_][a-zA-Z0-9_]*/,"variable-2"],[/[\w\$]+/,"variable"]],[["]",null]]],closing,escapes);}
if(stream.match(/\-\>\w/,false)){state.tokenize=matchSequence([[["->",null]],[[/[\w]+/,"variable"]]],closing,escapes);}
return"variable-2";}
var escaped=false;while(!stream.eol()&&(escaped||escapes===false||(!stream.match("{$",false)&&!stream.match(/^(\$[a-zA-Z_][a-zA-Z0-9_]*|\$\{)/,false)))){if(!escaped&&stream.match(closing)){state.tokenize=null;state.tokStack.pop();state.tokStack.pop();break;}
escaped=stream.next()=="\\"&&!escaped;}
return"string";}
var phpKeywords="abstract and array as break case catch class clone const continue declare default "+"do else elseif enddeclare endfor endforeach endif endswitch endwhile extends final "+"for foreach function global goto if implements interface instanceof namespace "+"new or private protected public static switch throw trait try use var while xor "+"die echo empty exit eval include include_once isset list require require_once return "+"print unset __halt_compiler self static parent yield insteadof finally";var phpAtoms="true false null TRUE FALSE NULL __CLASS__ __DIR__ __FILE__ __LINE__ __METHOD__ __FUNCTION__ __NAMESPACE__ __TRAIT__";var phpBuiltin="func_num_args func_get_arg func_get_args strlen strcmp strncmp strcasecmp strncasecmp each error_reporting define defined trigger_error user_error set_error_handler restore_error_handler get_declared_classes get_loaded_extensions extension_loaded get_extension_funcs debug_backtrace constant bin2hex hex2bin sleep usleep time mktime gmmktime strftime gmstrftime strtotime date gmdate getdate localtime checkdate flush wordwrap htmlspecialchars htmlentities html_entity_decode md5 md5_file crc32 getimagesize image_type_to_mime_type phpinfo phpversion phpcredits strnatcmp strnatcasecmp substr_count strspn strcspn strtok strtoupper strtolower strpos strrpos strrev hebrev hebrevc nl2br basename dirname pathinfo stripslashes stripcslashes strstr stristr strrchr str_shuffle str_word_count strcoll substr substr_replace quotemeta ucfirst ucwords strtr addslashes addcslashes rtrim str_replace str_repeat count_chars chunk_split trim ltrim strip_tags similar_text explode implode setlocale localeconv parse_str str_pad chop strchr sprintf printf vprintf vsprintf sscanf fscanf parse_url urlencode urldecode rawurlencode rawurldecode readlink linkinfo link unlink exec system escapeshellcmd escapeshellarg passthru shell_exec proc_open proc_close rand srand getrandmax mt_rand mt_srand mt_getrandmax base64_decode base64_encode abs ceil floor round is_finite is_nan is_infinite bindec hexdec octdec decbin decoct dechex base_convert number_format fmod ip2long long2ip getenv putenv getopt microtime gettimeofday getrusage uniqid quoted_printable_decode set_time_limit get_cfg_var magic_quotes_runtime set_magic_quotes_runtime get_magic_quotes_gpc get_magic_quotes_runtime import_request_variables error_log serialize unserialize memory_get_usage var_dump var_export debug_zval_dump print_r highlight_file show_source highlight_string ini_get ini_get_all ini_set ini_alter ini_restore get_include_path set_include_path restore_include_path setcookie header headers_sent connection_aborted connection_status ignore_user_abort parse_ini_file is_uploaded_file move_uploaded_file intval floatval doubleval strval gettype settype is_null is_resource is_bool is_long is_float is_int is_integer is_double is_real is_numeric is_string is_array is_object is_scalar ereg ereg_replace eregi eregi_replace split spliti join sql_regcase dl pclose popen readfile rewind rmdir umask fclose feof fgetc fgets fgetss fread fopen fpassthru ftruncate fstat fseek ftell fflush fwrite fputs mkdir rename copy tempnam tmpfile file file_get_contents file_put_contents stream_select stream_context_create stream_context_set_params stream_context_set_option stream_context_get_options stream_filter_prepend stream_filter_append fgetcsv flock get_meta_tags stream_set_write_buffer set_file_buffer set_socket_blocking stream_set_blocking socket_set_blocking stream_get_meta_data stream_register_wrapper stream_wrapper_register stream_set_timeout socket_set_timeout socket_get_status realpath fnmatch fsockopen pfsockopen pack unpack get_browser crypt opendir closedir chdir getcwd rewinddir readdir dir glob fileatime filectime filegroup fileinode filemtime fileowner fileperms filesize filetype file_exists is_writable is_writeable is_readable is_executable is_file is_dir is_link stat lstat chown touch clearstatcache mail ob_start ob_flush ob_clean ob_end_flush ob_end_clean ob_get_flush ob_get_clean ob_get_length ob_get_level ob_get_status ob_get_contents ob_implicit_flush ob_list_handlers ksort krsort natsort natcasesort asort arsort sort rsort usort uasort uksort shuffle array_walk count end prev next reset current key min max in_array array_search extract compact array_fill range array_multisort array_push array_pop array_shift array_unshift array_splice array_slice array_merge array_merge_recursive array_keys array_values array_count_values array_reverse array_reduce array_pad array_flip array_change_key_case array_rand array_unique array_intersect array_intersect_assoc array_diff array_diff_assoc array_sum array_filter array_map array_chunk array_key_exists array_intersect_key array_combine array_column pos sizeof key_exists assert assert_options version_compare ftok str_rot13 aggregate session_name session_module_name session_save_path session_id session_regenerate_id session_decode session_register session_unregister session_is_registered session_encode session_start session_destroy session_unset session_set_save_handler session_cache_limiter session_cache_expire session_set_cookie_params session_get_cookie_params session_write_close preg_match preg_match_all preg_replace preg_replace_callback preg_split preg_quote preg_grep overload ctype_alnum ctype_alpha ctype_cntrl ctype_digit ctype_lower ctype_graph ctype_print ctype_punct ctype_space ctype_upper ctype_xdigit virtual apache_request_headers apache_note apache_lookup_uri apache_child_terminate apache_setenv apache_response_headers apache_get_version getallheaders mysql_connect mysql_pconnect mysql_close mysql_select_db mysql_create_db mysql_drop_db mysql_query mysql_unbuffered_query mysql_db_query mysql_list_dbs mysql_list_tables mysql_list_fields mysql_list_processes mysql_error mysql_errno mysql_affected_rows mysql_insert_id mysql_result mysql_num_rows mysql_num_fields mysql_fetch_row mysql_fetch_array mysql_fetch_assoc mysql_fetch_object mysql_data_seek mysql_fetch_lengths mysql_fetch_field mysql_field_seek mysql_free_result mysql_field_name mysql_field_table mysql_field_len mysql_field_type mysql_field_flags mysql_escape_string mysql_real_escape_string mysql_stat mysql_thread_id mysql_client_encoding mysql_get_client_info mysql_get_host_info mysql_get_proto_info mysql_get_server_info mysql_info mysql mysql_fieldname mysql_fieldtable mysql_fieldlen mysql_fieldtype mysql_fieldflags mysql_selectdb mysql_createdb mysql_dropdb mysql_freeresult mysql_numfields mysql_numrows mysql_listdbs mysql_listtables mysql_listfields mysql_db_name mysql_dbname mysql_tablename mysql_table_name pg_connect pg_pconnect pg_close pg_connection_status pg_connection_busy pg_connection_reset pg_host pg_dbname pg_port pg_tty pg_options pg_ping pg_query pg_send_query pg_cancel_query pg_fetch_result pg_fetch_row pg_fetch_assoc pg_fetch_array pg_fetch_object pg_fetch_all pg_affected_rows pg_get_result pg_result_seek pg_result_status pg_free_result pg_last_oid pg_num_rows pg_num_fields pg_field_name pg_field_num pg_field_size pg_field_type pg_field_prtlen pg_field_is_null pg_get_notify pg_get_pid pg_result_error pg_last_error pg_last_notice pg_put_line pg_end_copy pg_copy_to pg_copy_from pg_trace pg_untrace pg_lo_create pg_lo_unlink pg_lo_open pg_lo_close pg_lo_read pg_lo_write pg_lo_read_all pg_lo_import pg_lo_export pg_lo_seek pg_lo_tell pg_escape_string pg_escape_bytea pg_unescape_bytea pg_client_encoding pg_set_client_encoding pg_meta_data pg_convert pg_insert pg_update pg_delete pg_select pg_exec pg_getlastoid pg_cmdtuples pg_errormessage pg_numrows pg_numfields pg_fieldname pg_fieldsize pg_fieldtype pg_fieldnum pg_fieldprtlen pg_fieldisnull pg_freeresult pg_result pg_loreadall pg_locreate pg_lounlink pg_loopen pg_loclose pg_loread pg_lowrite pg_loimport pg_loexport http_response_code get_declared_traits getimagesizefromstring socket_import_stream stream_set_chunk_size trait_exists header_register_callback class_uses session_status session_register_shutdown echo print global static exit array empty eval isset unset die include require include_once require_once json_decode json_encode json_last_error json_last_error_msg curl_close curl_copy_handle curl_errno curl_error curl_escape curl_exec curl_file_create curl_getinfo curl_init curl_multi_add_handle curl_multi_close curl_multi_exec curl_multi_getcontent curl_multi_info_read curl_multi_init curl_multi_remove_handle curl_multi_select curl_multi_setopt curl_multi_strerror curl_pause curl_reset curl_setopt_array curl_setopt curl_share_close curl_share_init curl_share_setopt curl_strerror curl_unescape curl_version mysqli_affected_rows mysqli_autocommit mysqli_change_user mysqli_character_set_name mysqli_close mysqli_commit mysqli_connect_errno mysqli_connect_error mysqli_connect mysqli_data_seek mysqli_debug mysqli_dump_debug_info mysqli_errno mysqli_error_list mysqli_error mysqli_fetch_all mysqli_fetch_array mysqli_fetch_assoc mysqli_fetch_field_direct mysqli_fetch_field mysqli_fetch_fields mysqli_fetch_lengths mysqli_fetch_object mysqli_fetch_row mysqli_field_count mysqli_field_seek mysqli_field_tell mysqli_free_result mysqli_get_charset mysqli_get_client_info mysqli_get_client_stats mysqli_get_client_version mysqli_get_connection_stats mysqli_get_host_info mysqli_get_proto_info mysqli_get_server_info mysqli_get_server_version mysqli_info mysqli_init mysqli_insert_id mysqli_kill mysqli_more_results mysqli_multi_query mysqli_next_result mysqli_num_fields mysqli_num_rows mysqli_options mysqli_ping mysqli_prepare mysqli_query mysqli_real_connect mysqli_real_escape_string mysqli_real_query mysqli_reap_async_query mysqli_refresh mysqli_rollback mysqli_select_db mysqli_set_charset mysqli_set_local_infile_default mysqli_set_local_infile_handler mysqli_sqlstate mysqli_ssl_set mysqli_stat mysqli_stmt_init mysqli_store_result mysqli_thread_id mysqli_thread_safe mysqli_use_result mysqli_warning_count";CodeMirror.registerHelper("hintWords","php",[phpKeywords,phpAtoms,phpBuiltin].join(" ").split(" "));CodeMirror.registerHelper("wordChars","php",/[\w$]/);var phpConfig={name:"clike",helperType:"php",keywords:keywords(phpKeywords),blockKeywords:keywords("catch do else elseif for foreach if switch try while finally"),defKeywords:keywords("class function interface namespace trait"),atoms:keywords(phpAtoms),builtin:keywords(phpBuiltin),multiLineStrings:true,hooks:{"$":function(stream){stream.eatWhile(/[\w\$_]/);return"variable-2";},"<":function(stream,state){var before;if(before=stream.match(/<<\s*/)){var quoted=stream.eat(/['"]/);stream.eatWhile(/[\w\.]/);var delim=stream.current().slice(before[0].length+(quoted?2:1));if(quoted)stream.eat(quoted);if(delim){(state.tokStack||(state.tokStack=[])).push(delim,0);state.tokenize=phpString(delim,quoted!="'");return"string";}}
return false;},"#":function(stream){while(!stream.eol()&&!stream.match("?>",false))stream.next();return"comment";},"/":function(stream){if(stream.eat("/")){while(!stream.eol()&&!stream.match("?>",false))stream.next();return"comment";}
return false;},'"':function(_stream,state){(state.tokStack||(state.tokStack=[])).push('"',0);state.tokenize=phpString('"');return"string";},"{":function(_stream,state){if(state.tokStack&&state.tokStack.length)
state.tokStack[state.tokStack.length-1]++;return false;},"}":function(_stream,state){if(state.tokStack&&state.tokStack.length>0&&!--state.tokStack[state.tokStack.length-1]){state.tokenize=phpString(state.tokStack[state.tokStack.length-2]);}
return false;}}};CodeMirror.defineMode("php",function(config,parserConfig){var htmlMode=CodeMirror.getMode(config,(parserConfig&&parserConfig.htmlMode)||"text/html");var phpMode=CodeMirror.getMode(config,phpConfig);function dispatch(stream,state){var isPHP=state.curMode==phpMode;if(stream.sol()&&state.pending&&state.pending!='"'&&state.pending!="'")state.pending=null;if(!isPHP){if(stream.match(/^<\?\w*/)){state.curMode=phpMode;if(!state.php)state.php=CodeMirror.startState(phpMode,htmlMode.indent(state.html,"",""));state.curState=state.php;return"meta";}
if(state.pending=='"'||state.pending=="'"){while(!stream.eol()&&stream.next()!=state.pending){}
var style="string";}else if(state.pending&&stream.pos<state.pending.end){stream.pos=state.pending.end;var style=state.pending.style;}else{var style=htmlMode.token(stream,state.curState);}
if(state.pending)state.pending=null;var cur=stream.current(),openPHP=cur.search(/<\?/),m;if(openPHP!=-1){if(style=="string"&&(m=cur.match(/[\'\"]$/))&&!/\?>/.test(cur))state.pending=m[0];else state.pending={end:stream.pos,style:style};stream.backUp(cur.length-openPHP);}
return style;}else if(isPHP&&state.php.tokenize==null&&stream.match("?>")){state.curMode=htmlMode;state.curState=state.html;if(!state.php.context.prev)state.php=null;return"meta";}else{return phpMode.token(stream,state.curState);}}
return{startState:function(){var html=CodeMirror.startState(htmlMode);var php=parserConfig.startOpen?CodeMirror.startState(phpMode):null;return{html:html,php:php,curMode:parserConfig.startOpen?phpMode:htmlMode,curState:parserConfig.startOpen?php:html,pending:null};},copyState:function(state){var html=state.html,htmlNew=CodeMirror.copyState(htmlMode,html),php=state.php,phpNew=php&&CodeMirror.copyState(phpMode,php),cur;if(state.curMode==htmlMode)cur=htmlNew;else cur=phpNew;return{html:htmlNew,php:phpNew,curMode:state.curMode,curState:cur,pending:state.pending};},token:dispatch,indent:function(state,textAfter,line){if((state.curMode!=phpMode&&/^\s*<\//.test(textAfter))||(state.curMode==phpMode&&/^\?>/.test(textAfter)))
return htmlMode.indent(state.html,textAfter,line);return state.curMode.indent(state.curState,textAfter,line);},blockCommentStart:"/*",blockCommentEnd:"*/",lineComment:"//",innerMode:function(state){return{state:state.curState,mode:state.curMode};}};},"htmlmixed","clike");CodeMirror.defineMIME("application/x-httpd-php","php");CodeMirror.defineMIME("application/x-httpd-php-open",{name:"php",startOpen:true});CodeMirror.defineMIME("text/x-php",phpConfig);});(function(mod){if(typeof exports=="object"&&typeof module=="object")
mod(require("../../lib/codemirror"));else if(typeof define=="function"&&define.amd)
define(["../../lib/codemirror"],mod);else
mod(CodeMirror);})(function(CodeMirror){"use strict";function wordRegexp(words){return new RegExp("^(("+words.join(")|(")+"))\\b");}
var wordOperators=wordRegexp(["and","or","not","is"]);var commonKeywords=["as","assert","break","class","continue","def","del","elif","else","except","finally","for","from","global","if","import","lambda","pass","raise","return","try","while","with","yield","in"];var commonBuiltins=["abs","all","any","bin","bool","bytearray","callable","chr","classmethod","compile","complex","delattr","dict","dir","divmod","enumerate","eval","filter","float","format","frozenset","getattr","globals","hasattr","hash","help","hex","id","input","int","isinstance","issubclass","iter","len","list","locals","map","max","memoryview","min","next","object","oct","open","ord","pow","property","range","repr","reversed","round","set","setattr","slice","sorted","staticmethod","str","sum","super","tuple","type","vars","zip","__import__","NotImplemented","Ellipsis","__debug__"];CodeMirror.registerHelper("hintWords","python",commonKeywords.concat(commonBuiltins));function top(state){return state.scopes[state.scopes.length-1];}
CodeMirror.defineMode("python",function(conf,parserConf){var ERRORCLASS="error";var delimiters=parserConf.delimiters||parserConf.singleDelimiters||/^[\(\)\[\]\{\}@,:`=;\.\\]/;var operators=[parserConf.singleOperators,parserConf.doubleOperators,parserConf.doubleDelimiters,parserConf.tripleDelimiters,parserConf.operators||/^([-+*/%\/&|^]=?|[<>=]+|\/\/=?|\*\*=?|!=|[~!@]|\.\.\.)/];for(var i=0;i<operators.length;i++)if(!operators[i])operators.splice(i--,1);var hangingIndent=parserConf.hangingIndent||conf.indentUnit;var myKeywords=commonKeywords,myBuiltins=commonBuiltins;if(parserConf.extra_keywords!=undefined)
myKeywords=myKeywords.concat(parserConf.extra_keywords);if(parserConf.extra_builtins!=undefined)
myBuiltins=myBuiltins.concat(parserConf.extra_builtins);var py3=!(parserConf.version&&Number(parserConf.version)<3);if(py3){var identifiers=parserConf.identifiers||/^[_A-Za-z\u00A1-\uFFFF][_A-Za-z0-9\u00A1-\uFFFF]*/;myKeywords=myKeywords.concat(["nonlocal","False","True","None","async","await"]);myBuiltins=myBuiltins.concat(["ascii","bytes","exec","print"]);var stringPrefixes=new RegExp("^(([rbuf]|(br)|(fr))?('{3}|\"{3}|['\"]))","i");}else{var identifiers=parserConf.identifiers||/^[_A-Za-z][_A-Za-z0-9]*/;myKeywords=myKeywords.concat(["exec","print"]);myBuiltins=myBuiltins.concat(["apply","basestring","buffer","cmp","coerce","execfile","file","intern","long","raw_input","reduce","reload","unichr","unicode","xrange","False","True","None"]);var stringPrefixes=new RegExp("^(([rubf]|(ur)|(br))?('{3}|\"{3}|['\"]))","i");}
var keywords=wordRegexp(myKeywords);var builtins=wordRegexp(myBuiltins);function tokenBase(stream,state){var sol=stream.sol()&&state.lastToken!="\\";if(sol)state.indent=stream.indentation();if(sol&&top(state).type=="py"){var scopeOffset=top(state).offset;if(stream.eatSpace()){var lineOffset=stream.indentation();if(lineOffset>scopeOffset)
pushPyScope(state);else if(lineOffset<scopeOffset&&dedent(stream,state)&&stream.peek()!="#")
state.errorToken=true;return null;}else{var style=tokenBaseInner(stream,state);if(scopeOffset>0&&dedent(stream,state))
style+=" "+ERRORCLASS;return style;}}
return tokenBaseInner(stream,state);}
function tokenBaseInner(stream,state){if(stream.eatSpace())return null;if(stream.match(/^#.*/))return"comment";if(stream.match(/^[0-9\.]/,false)){var floatLiteral=false;if(stream.match(/^[\d_]*\.\d+(e[\+\-]?\d+)?/i)){floatLiteral=true;}
if(stream.match(/^[\d_]+\.\d*/)){floatLiteral=true;}
if(stream.match(/^\.\d+/)){floatLiteral=true;}
if(floatLiteral){stream.eat(/J/i);return"number";}
var intLiteral=false;if(stream.match(/^0x[0-9a-f_]+/i))intLiteral=true;if(stream.match(/^0b[01_]+/i))intLiteral=true;if(stream.match(/^0o[0-7_]+/i))intLiteral=true;if(stream.match(/^[1-9][\d_]*(e[\+\-]?[\d_]+)?/)){stream.eat(/J/i);intLiteral=true;}
if(stream.match(/^0(?![\dx])/i))intLiteral=true;if(intLiteral){stream.eat(/L/i);return"number";}}
if(stream.match(stringPrefixes)){var isFmtString=stream.current().toLowerCase().indexOf('f')!==-1;if(!isFmtString){state.tokenize=tokenStringFactory(stream.current(),state.tokenize);return state.tokenize(stream,state);}else{state.tokenize=formatStringFactory(stream.current(),state.tokenize);return state.tokenize(stream,state);}}
for(var i=0;i<operators.length;i++)
if(stream.match(operators[i]))return"operator"
if(stream.match(delimiters))return"punctuation";if(state.lastToken=="."&&stream.match(identifiers))
return"property";if(stream.match(keywords)||stream.match(wordOperators))
return"keyword";if(stream.match(builtins))
return"builtin";if(stream.match(/^(self|cls)\b/))
return"variable-2";if(stream.match(identifiers)){if(state.lastToken=="def"||state.lastToken=="class")
return"def";return"variable";}
stream.next();return ERRORCLASS;}
function formatStringFactory(delimiter,tokenOuter){while("rubf".indexOf(delimiter.charAt(0).toLowerCase())>=0)
delimiter=delimiter.substr(1);var singleline=delimiter.length==1;var OUTCLASS="string";function tokenNestedExpr(depth){return function(stream,state){var inner=tokenBaseInner(stream,state);if(inner=="punctuation"){if(stream.current()=="{"){state.tokenize=tokenNestedExpr(depth+1);}else if(stream.current()=="}"){if(depth>1)state.tokenize=tokenNestedExpr(depth-1);else state.tokenize=tokenString;}}
return inner}}
function tokenString(stream,state){while(!stream.eol()){stream.eatWhile(/[^'"\{\}\\]/);if(stream.eat("\\")){stream.next();if(singleline&&stream.eol())
return OUTCLASS;}else if(stream.match(delimiter)){state.tokenize=tokenOuter;return OUTCLASS;}else if(stream.match('{{')){return OUTCLASS;}else if(stream.match('{',false)){state.tokenize=tokenNestedExpr(0);if(stream.current())return OUTCLASS;else return state.tokenize(stream,state)}else if(stream.match('}}')){return OUTCLASS;}else if(stream.match('}')){return ERRORCLASS;}else{stream.eat(/['"]/);}}
if(singleline){if(parserConf.singleLineStringErrors)
return ERRORCLASS;else
state.tokenize=tokenOuter;}
return OUTCLASS;}
tokenString.isString=true;return tokenString;}
function tokenStringFactory(delimiter,tokenOuter){while("rubf".indexOf(delimiter.charAt(0).toLowerCase())>=0)
delimiter=delimiter.substr(1);var singleline=delimiter.length==1;var OUTCLASS="string";function tokenString(stream,state){while(!stream.eol()){stream.eatWhile(/[^'"\\]/);if(stream.eat("\\")){stream.next();if(singleline&&stream.eol())
return OUTCLASS;}else if(stream.match(delimiter)){state.tokenize=tokenOuter;return OUTCLASS;}else{stream.eat(/['"]/);}}
if(singleline){if(parserConf.singleLineStringErrors)
return ERRORCLASS;else
state.tokenize=tokenOuter;}
return OUTCLASS;}
tokenString.isString=true;return tokenString;}
function pushPyScope(state){while(top(state).type!="py")state.scopes.pop();state.scopes.push({offset:top(state).offset+conf.indentUnit,type:"py",align:null});}
function pushBracketScope(stream,state,type){var align=stream.match(/^([\s\[\{\(]|#.*)*$/,false)?null:stream.column()+1;state.scopes.push({offset:state.indent+hangingIndent,type:type,align:align});}
function dedent(stream,state){var indented=stream.indentation();while(state.scopes.length>1&&top(state).offset>indented){if(top(state).type!="py")return true;state.scopes.pop();}
return top(state).offset!=indented;}
function tokenLexer(stream,state){if(stream.sol())state.beginningOfLine=true;var style=state.tokenize(stream,state);var current=stream.current();if(state.beginningOfLine&&current=="@")
return stream.match(identifiers,false)?"meta":py3?"operator":ERRORCLASS;if(/\S/.test(current))state.beginningOfLine=false;if((style=="variable"||style=="builtin")&&state.lastToken=="meta")
style="meta";if(current=="pass"||current=="return")
state.dedent+=1;if(current=="lambda")state.lambda=true;if(current==":"&&!state.lambda&&top(state).type=="py")
pushPyScope(state);if(current.length==1&&!/string|comment/.test(style)){var delimiter_index="[({".indexOf(current);if(delimiter_index!=-1)
pushBracketScope(stream,state,"])}".slice(delimiter_index,delimiter_index+1));delimiter_index="])}".indexOf(current);if(delimiter_index!=-1){if(top(state).type==current)state.indent=state.scopes.pop().offset-hangingIndent;else return ERRORCLASS;}}
if(state.dedent>0&&stream.eol()&&top(state).type=="py"){if(state.scopes.length>1)state.scopes.pop();state.dedent-=1;}
return style;}
var external={startState:function(basecolumn){return{tokenize:tokenBase,scopes:[{offset:basecolumn||0,type:"py",align:null}],indent:basecolumn||0,lastToken:null,lambda:false,dedent:0};},token:function(stream,state){var addErr=state.errorToken;if(addErr)state.errorToken=false;var style=tokenLexer(stream,state);if(style&&style!="comment")
state.lastToken=(style=="keyword"||style=="punctuation")?stream.current():style;if(style=="punctuation")style=null;if(stream.eol()&&state.lambda)
state.lambda=false;return addErr?style+" "+ERRORCLASS:style;},indent:function(state,textAfter){if(state.tokenize!=tokenBase)
return state.tokenize.isString?CodeMirror.Pass:0;var scope=top(state),closing=scope.type==textAfter.charAt(0);if(scope.align!=null)
return scope.align-(closing?1:0)
else
return scope.offset-(closing?hangingIndent:0)},electricInput:/^\s*[\}\]\)]$/,closeBrackets:{triples:"'\""},lineComment:"#",fold:"indent"};return external;});CodeMirror.defineMIME("text/x-python","python");var words=function(str){return str.split(" ");};CodeMirror.defineMIME("text/x-cython",{name:"python",extra_keywords:words("by cdef cimport cpdef ctypedef enum except "+"extern gil include nogil property public "+"readonly struct union DEF IF ELIF ELSE")});});(function(mod){if(typeof exports=="object"&&typeof module=="object")
mod(require("../../lib/codemirror"));else if(typeof define=="function"&&define.amd)
define(["../../lib/codemirror"],mod);else
mod(CodeMirror);})(function(CodeMirror){"use strict";CodeMirror.defineMode('shell',function(){var words={};function define(style,dict){for(var i=0;i<dict.length;i++){words[dict[i]]=style;}};var commonAtoms=["true","false"];var commonKeywords=["if","then","do","else","elif","while","until","for","in","esac","fi","fin","fil","done","exit","set","unset","export","function"];var commonCommands=["ab","awk","bash","beep","cat","cc","cd","chown","chmod","chroot","clear","cp","curl","cut","diff","echo","find","gawk","gcc","get","git","grep","hg","kill","killall","ln","ls","make","mkdir","openssl","mv","nc","nl","node","npm","ping","ps","restart","rm","rmdir","sed","service","sh","shopt","shred","source","sort","sleep","ssh","start","stop","su","sudo","svn","tee","telnet","top","touch","vi","vim","wall","wc","wget","who","write","yes","zsh"];CodeMirror.registerHelper("hintWords","shell",commonAtoms.concat(commonKeywords,commonCommands));define('atom',commonAtoms);define('keyword',commonKeywords);define('builtin',commonCommands);function tokenBase(stream,state){if(stream.eatSpace())return null;var sol=stream.sol();var ch=stream.next();if(ch==='\\'){stream.next();return null;}
if(ch==='\''||ch==='"'||ch==='`'){state.tokens.unshift(tokenString(ch,ch==="`"?"quote":"string"));return tokenize(stream,state);}
if(ch==='#'){if(sol&&stream.eat('!')){stream.skipToEnd();return'meta';}
stream.skipToEnd();return'comment';}
if(ch==='$'){state.tokens.unshift(tokenDollar);return tokenize(stream,state);}
if(ch==='+'||ch==='='){return'operator';}
if(ch==='-'){stream.eat('-');stream.eatWhile(/\w/);return'attribute';}
if(/\d/.test(ch)){stream.eatWhile(/\d/);if(stream.eol()||!/\w/.test(stream.peek())){return'number';}}
stream.eatWhile(/[\w-]/);var cur=stream.current();if(stream.peek()==='='&&/\w+/.test(cur))return'def';return words.hasOwnProperty(cur)?words[cur]:null;}
function tokenString(quote,style){var close=quote=="("?")":quote=="{"?"}":quote;return function(stream,state){var next,escaped=false;while((next=stream.next())!=null){if(next===close&&!escaped){state.tokens.shift();break;}else if(next==='$'&&!escaped&&quote!=="'"&&stream.peek()!=close){escaped=true;stream.backUp(1);state.tokens.unshift(tokenDollar);break;}else if(!escaped&&quote!==close&&next===quote){state.tokens.unshift(tokenString(quote,style));return tokenize(stream,state)}else if(!escaped&&/['"]/.test(next)&&!/['"]/.test(quote)){state.tokens.unshift(tokenStringStart(next,"string"));stream.backUp(1);break;}
escaped=!escaped&&next==='\\';}
return style;};};function tokenStringStart(quote,style){return function(stream,state){state.tokens[0]=tokenString(quote,style);stream.next();return tokenize(stream,state)}}
var tokenDollar=function(stream,state){if(state.tokens.length>1)stream.eat('$');var ch=stream.next();if(/['"({]/.test(ch)){state.tokens[0]=tokenString(ch,ch=="("?"quote":ch=="{"?"def":"string");return tokenize(stream,state);}
if(!/\d/.test(ch))stream.eatWhile(/\w/);state.tokens.shift();return'def';};function tokenize(stream,state){return(state.tokens[0]||tokenBase)(stream,state);};return{startState:function(){return{tokens:[]};},token:function(stream,state){return tokenize(stream,state);},closeBrackets:"()[]{}''\"\"``",lineComment:'#',fold:"brace"};});CodeMirror.defineMIME('text/x-sh','shell');CodeMirror.defineMIME('application/x-sh','shell');});(function(mod){if(typeof exports=="object"&&typeof module=="object")
mod(require("../../lib/codemirror"));else if(typeof define=="function"&&define.amd)
define(["../../lib/codemirror"],mod);else
mod(CodeMirror);})(function(CodeMirror){"use strict";CodeMirror.defineMode('livescript',function(){var tokenBase=function(stream,state){var next_rule=state.next||"start";if(next_rule){state.next=state.next;var nr=Rules[next_rule];if(nr.splice){for(var i$=0;i$<nr.length;++i$){var r=nr[i$];if(r.regex&&stream.match(r.regex)){state.next=r.next||state.next;return r.token;}}
stream.next();return'error';}
if(stream.match(r=Rules[next_rule])){if(r.regex&&stream.match(r.regex)){state.next=r.next;return r.token;}else{stream.next();return'error';}}}
stream.next();return'error';};var external={startState:function(){return{next:'start',lastToken:{style:null,indent:0,content:""}};},token:function(stream,state){while(stream.pos==stream.start)
var style=tokenBase(stream,state);state.lastToken={style:style,indent:stream.indentation(),content:stream.current()};return style.replace(/\./g,' ');},indent:function(state){var indentation=state.lastToken.indent;if(state.lastToken.content.match(indenter)){indentation+=2;}
return indentation;}};return external;});var identifier='(?![\\d\\s])[$\\w\\xAA-\\uFFDC](?:(?!\\s)[$\\w\\xAA-\\uFFDC]|-[A-Za-z])*';var indenter=RegExp('(?:[({[=:]|[-~]>|\\b(?:e(?:lse|xport)|d(?:o|efault)|t(?:ry|hen)|finally|import(?:\\s*all)?|const|var|let|new|catch(?:\\s*'+identifier+')?))\\s*$');var keywordend='(?![$\\w]|-[A-Za-z]|\\s*:(?![:=]))';var stringfill={token:'string',regex:'.+'};var Rules={start:[{token:'comment.doc',regex:'/\\*',next:'comment'},{token:'comment',regex:'#.*'},{token:'keyword',regex:'(?:t(?:h(?:is|row|en)|ry|ypeof!?)|c(?:on(?:tinue|st)|a(?:se|tch)|lass)|i(?:n(?:stanceof)?|mp(?:ort(?:\\s+all)?|lements)|[fs])|d(?:e(?:fault|lete|bugger)|o)|f(?:or(?:\\s+own)?|inally|unction)|s(?:uper|witch)|e(?:lse|x(?:tends|port)|val)|a(?:nd|rguments)|n(?:ew|ot)|un(?:less|til)|w(?:hile|ith)|o[fr]|return|break|let|var|loop)'+keywordend},{token:'constant.language',regex:'(?:true|false|yes|no|on|off|null|void|undefined)'+keywordend},{token:'invalid.illegal',regex:'(?:p(?:ackage|r(?:ivate|otected)|ublic)|i(?:mplements|nterface)|enum|static|yield)'+keywordend},{token:'language.support.class',regex:'(?:R(?:e(?:gExp|ferenceError)|angeError)|S(?:tring|yntaxError)|E(?:rror|valError)|Array|Boolean|Date|Function|Number|Object|TypeError|URIError)'+keywordend},{token:'language.support.function',regex:'(?:is(?:NaN|Finite)|parse(?:Int|Float)|Math|JSON|(?:en|de)codeURI(?:Component)?)'+keywordend},{token:'variable.language',regex:'(?:t(?:hat|il|o)|f(?:rom|allthrough)|it|by|e)'+keywordend},{token:'identifier',regex:identifier+'\\s*:(?![:=])'},{token:'variable',regex:identifier},{token:'keyword.operator',regex:'(?:\\.{3}|\\s+\\?)'},{token:'keyword.variable',regex:'(?:@+|::|\\.\\.)',next:'key'},{token:'keyword.operator',regex:'\\.\\s*',next:'key'},{token:'string',regex:'\\\\\\S[^\\s,;)}\\]]*'},{token:'string.doc',regex:'\'\'\'',next:'qdoc'},{token:'string.doc',regex:'"""',next:'qqdoc'},{token:'string',regex:'\'',next:'qstring'},{token:'string',regex:'"',next:'qqstring'},{token:'string',regex:'`',next:'js'},{token:'string',regex:'<\\[',next:'words'},{token:'string.regex',regex:'//',next:'heregex'},{token:'string.regex',regex:'\\/(?:[^[\\/\\n\\\\]*(?:(?:\\\\.|\\[[^\\]\\n\\\\]*(?:\\\\.[^\\]\\n\\\\]*)*\\])[^[\\/\\n\\\\]*)*)\\/[gimy$]{0,4}',next:'key'},{token:'constant.numeric',regex:'(?:0x[\\da-fA-F][\\da-fA-F_]*|(?:[2-9]|[12]\\d|3[0-6])r[\\da-zA-Z][\\da-zA-Z_]*|(?:\\d[\\d_]*(?:\\.\\d[\\d_]*)?|\\.\\d[\\d_]*)(?:e[+-]?\\d[\\d_]*)?[\\w$]*)'},{token:'lparen',regex:'[({[]'},{token:'rparen',regex:'[)}\\]]',next:'key'},{token:'keyword.operator',regex:'\\S+'},{token:'text',regex:'\\s+'}],heregex:[{token:'string.regex',regex:'.*?//[gimy$?]{0,4}',next:'start'},{token:'string.regex',regex:'\\s*#{'},{token:'comment.regex',regex:'\\s+(?:#.*)?'},{token:'string.regex',regex:'\\S+'}],key:[{token:'keyword.operator',regex:'[.?@!]+'},{token:'identifier',regex:identifier,next:'start'},{token:'text',regex:'',next:'start'}],comment:[{token:'comment.doc',regex:'.*?\\*/',next:'start'},{token:'comment.doc',regex:'.+'}],qdoc:[{token:'string',regex:".*?'''",next:'key'},stringfill],qqdoc:[{token:'string',regex:'.*?"""',next:'key'},stringfill],qstring:[{token:'string',regex:'[^\\\\\']*(?:\\\\.[^\\\\\']*)*\'',next:'key'},stringfill],qqstring:[{token:'string',regex:'[^\\\\"]*(?:\\\\.[^\\\\"]*)*"',next:'key'},stringfill],js:[{token:'string',regex:'[^\\\\`]*(?:\\\\.[^\\\\`]*)*`',next:'key'},stringfill],words:[{token:'string',regex:'.*?\\]>',next:'key'},stringfill]};for(var idx in Rules){var r=Rules[idx];if(r.splice){for(var i=0,len=r.length;i<len;++i){var rr=r[i];if(typeof rr.regex==='string'){Rules[idx][i].regex=new RegExp('^'+rr.regex);}}}else if(typeof rr.regex==='string'){Rules[idx].regex=new RegExp('^'+r.regex);}}
CodeMirror.defineMIME('text/x-livescript','livescript');});(function(mod){if(typeof exports=="object"&&typeof module=="object")
mod(require("../../lib/codemirror"),require("../xml/xml"),require("../meta"));else if(typeof define=="function"&&define.amd)
define(["../../lib/codemirror","../xml/xml","../meta"],mod);else
mod(CodeMirror);})(function(CodeMirror){"use strict";CodeMirror.defineMode("markdown",function(cmCfg,modeCfg){var htmlMode=CodeMirror.getMode(cmCfg,"text/html");var htmlModeMissing=htmlMode.name=="null";function getMode(name){if(CodeMirror.findModeByName){var found=CodeMirror.findModeByName(name);if(found)name=found.mime||found.mimes[0];}
var mode=CodeMirror.getMode(cmCfg,name);return mode.name=="null"?null:mode;}
if(modeCfg.highlightFormatting===undefined)
modeCfg.highlightFormatting=false;if(modeCfg.maxBlockquoteDepth===undefined)
modeCfg.maxBlockquoteDepth=0;if(modeCfg.taskLists===undefined)modeCfg.taskLists=false;if(modeCfg.strikethrough===undefined)
modeCfg.strikethrough=false;if(modeCfg.emoji===undefined)
modeCfg.emoji=false;if(modeCfg.fencedCodeBlockHighlighting===undefined)
modeCfg.fencedCodeBlockHighlighting=true;if(modeCfg.xml===undefined)
modeCfg.xml=true;if(modeCfg.tokenTypeOverrides===undefined)
modeCfg.tokenTypeOverrides={};var tokenTypes={header:"header",code:"comment",quote:"quote",list1:"variable-2",list2:"variable-3",list3:"keyword",hr:"hr",image:"image",imageAltText:"image-alt-text",imageMarker:"image-marker",formatting:"formatting",linkInline:"link",linkEmail:"link",linkText:"link",linkHref:"string",em:"em",strong:"strong",strikethrough:"strikethrough",emoji:"builtin"};for(var tokenType in tokenTypes){if(tokenTypes.hasOwnProperty(tokenType)&&modeCfg.tokenTypeOverrides[tokenType]){tokenTypes[tokenType]=modeCfg.tokenTypeOverrides[tokenType];}}
var hrRE=/^([*\-_])(?:\s*\1){2,}\s*$/,listRE=/^(?:[*\-+]|^[0-9]+([.)]))\s+/,taskListRE=/^\[(x| )\](?=\s)/i,atxHeaderRE=modeCfg.allowAtxHeaderWithoutSpace?/^(#+)/:/^(#+)(?: |$)/,setextHeaderRE=/^ {0,3}(?:\={1,}|-{2,})\s*$/,textRE=/^[^#!\[\]*_\\<>` "'(~:]+/,fencedCodeRE=/^(~~~+|```+)[ \t]*([\w+#-]*)[^\n`]*$/,linkDefRE=/^\s*\[[^\]]+?\]:.*$/,punctuation=/[!"#$%&'()*+,\-.\/:;<=>?@\[\\\]^_`{|}~\xA1\xA7\xAB\xB6\xB7\xBB\xBF\u037E\u0387\u055A-\u055F\u0589\u058A\u05BE\u05C0\u05C3\u05C6\u05F3\u05F4\u0609\u060A\u060C\u060D\u061B\u061E\u061F\u066A-\u066D\u06D4\u0700-\u070D\u07F7-\u07F9\u0830-\u083E\u085E\u0964\u0965\u0970\u0AF0\u0DF4\u0E4F\u0E5A\u0E5B\u0F04-\u0F12\u0F14\u0F3A-\u0F3D\u0F85\u0FD0-\u0FD4\u0FD9\u0FDA\u104A-\u104F\u10FB\u1360-\u1368\u1400\u166D\u166E\u169B\u169C\u16EB-\u16ED\u1735\u1736\u17D4-\u17D6\u17D8-\u17DA\u1800-\u180A\u1944\u1945\u1A1E\u1A1F\u1AA0-\u1AA6\u1AA8-\u1AAD\u1B5A-\u1B60\u1BFC-\u1BFF\u1C3B-\u1C3F\u1C7E\u1C7F\u1CC0-\u1CC7\u1CD3\u2010-\u2027\u2030-\u2043\u2045-\u2051\u2053-\u205E\u207D\u207E\u208D\u208E\u2308-\u230B\u2329\u232A\u2768-\u2775\u27C5\u27C6\u27E6-\u27EF\u2983-\u2998\u29D8-\u29DB\u29FC\u29FD\u2CF9-\u2CFC\u2CFE\u2CFF\u2D70\u2E00-\u2E2E\u2E30-\u2E42\u3001-\u3003\u3008-\u3011\u3014-\u301F\u3030\u303D\u30A0\u30FB\uA4FE\uA4FF\uA60D-\uA60F\uA673\uA67E\uA6F2-\uA6F7\uA874-\uA877\uA8CE\uA8CF\uA8F8-\uA8FA\uA8FC\uA92E\uA92F\uA95F\uA9C1-\uA9CD\uA9DE\uA9DF\uAA5C-\uAA5F\uAADE\uAADF\uAAF0\uAAF1\uABEB\uFD3E\uFD3F\uFE10-\uFE19\uFE30-\uFE52\uFE54-\uFE61\uFE63\uFE68\uFE6A\uFE6B\uFF01-\uFF03\uFF05-\uFF0A\uFF0C-\uFF0F\uFF1A\uFF1B\uFF1F\uFF20\uFF3B-\uFF3D\uFF3F\uFF5B\uFF5D\uFF5F-\uFF65]|\uD800[\uDD00-\uDD02\uDF9F\uDFD0]|\uD801\uDD6F|\uD802[\uDC57\uDD1F\uDD3F\uDE50-\uDE58\uDE7F\uDEF0-\uDEF6\uDF39-\uDF3F\uDF99-\uDF9C]|\uD804[\uDC47-\uDC4D\uDCBB\uDCBC\uDCBE-\uDCC1\uDD40-\uDD43\uDD74\uDD75\uDDC5-\uDDC9\uDDCD\uDDDB\uDDDD-\uDDDF\uDE38-\uDE3D\uDEA9]|\uD805[\uDCC6\uDDC1-\uDDD7\uDE41-\uDE43\uDF3C-\uDF3E]|\uD809[\uDC70-\uDC74]|\uD81A[\uDE6E\uDE6F\uDEF5\uDF37-\uDF3B\uDF44]|\uD82F\uDC9F|\uD836[\uDE87-\uDE8B]/,expandedTab="    ";function switchInline(stream,state,f){state.f=state.inline=f;return f(stream,state);}
function switchBlock(stream,state,f){state.f=state.block=f;return f(stream,state);}
function lineIsEmpty(line){return!line||!/\S/.test(line.string)}
function blankLine(state){state.linkTitle=false;state.linkHref=false;state.linkText=false;state.em=false;state.strong=false;state.strikethrough=false;state.quote=0;state.indentedCode=false;if(state.f==htmlBlock){var exit=htmlModeMissing;if(!exit){var inner=CodeMirror.innerMode(htmlMode,state.htmlState);exit=inner.mode.name=="xml"&&inner.state.tagStart===null&&(!inner.state.context&&inner.state.tokenize.isInText);}
if(exit){state.f=inlineNormal;state.block=blockNormal;state.htmlState=null;}}
state.trailingSpace=0;state.trailingSpaceNewLine=false;state.prevLine=state.thisLine;state.thisLine={stream:null};return null;}
function blockNormal(stream,state){var firstTokenOnLine=stream.column()===state.indentation;var prevLineLineIsEmpty=lineIsEmpty(state.prevLine.stream);var prevLineIsIndentedCode=state.indentedCode;var prevLineIsHr=state.prevLine.hr;var prevLineIsList=state.list!==false;var maxNonCodeIndentation=(state.listStack[state.listStack.length-1]||0)+3;state.indentedCode=false;var lineIndentation=state.indentation;if(state.indentationDiff===null){state.indentationDiff=state.indentation;if(prevLineIsList){state.list=null;while(lineIndentation<state.listStack[state.listStack.length-1]){state.listStack.pop();if(state.listStack.length){state.indentation=state.listStack[state.listStack.length-1];}else{state.list=false;}}
if(state.list!==false){state.indentationDiff=lineIndentation-state.listStack[state.listStack.length-1];}}}
var allowsInlineContinuation=(!prevLineLineIsEmpty&&!prevLineIsHr&&!state.prevLine.header&&(!prevLineIsList||!prevLineIsIndentedCode)&&!state.prevLine.fencedCodeEnd);var isHr=(state.list===false||prevLineIsHr||prevLineLineIsEmpty)&&state.indentation<=maxNonCodeIndentation&&stream.match(hrRE);var match=null;if(state.indentationDiff>=4&&(prevLineIsIndentedCode||state.prevLine.fencedCodeEnd||state.prevLine.header||prevLineLineIsEmpty)){stream.skipToEnd();state.indentedCode=true;return tokenTypes.code;}else if(stream.eatSpace()){return null;}else if(firstTokenOnLine&&state.indentation<=maxNonCodeIndentation&&(match=stream.match(atxHeaderRE))&&match[1].length<=6){state.quote=0;state.header=match[1].length;state.thisLine.header=true;if(modeCfg.highlightFormatting)state.formatting="header";state.f=state.inline;return getType(state);}else if(state.indentation<=maxNonCodeIndentation&&stream.eat('>')){state.quote=firstTokenOnLine?1:state.quote+1;if(modeCfg.highlightFormatting)state.formatting="quote";stream.eatSpace();return getType(state);}else if(!isHr&&!state.setext&&firstTokenOnLine&&state.indentation<=maxNonCodeIndentation&&(match=stream.match(listRE))){var listType=match[1]?"ol":"ul";state.indentation=lineIndentation+stream.current().length;state.list=true;state.quote=0;state.listStack.push(state.indentation);state.em=false;state.strong=false;state.code=false;state.strikethrough=false;if(modeCfg.taskLists&&stream.match(taskListRE,false)){state.taskList=true;}
state.f=state.inline;if(modeCfg.highlightFormatting)state.formatting=["list","list-"+listType];return getType(state);}else if(firstTokenOnLine&&state.indentation<=maxNonCodeIndentation&&(match=stream.match(fencedCodeRE,true))){state.quote=0;state.fencedEndRE=new RegExp(match[1]+"+ *$");state.localMode=modeCfg.fencedCodeBlockHighlighting&&getMode(match[2]);if(state.localMode)state.localState=CodeMirror.startState(state.localMode);state.f=state.block=local;if(modeCfg.highlightFormatting)state.formatting="code-block";state.code=-1;return getType(state);}else if(state.setext||((!allowsInlineContinuation||!prevLineIsList)&&!state.quote&&state.list===false&&!state.code&&!isHr&&!linkDefRE.test(stream.string)&&(match=stream.lookAhead(1))&&(match=match.match(setextHeaderRE)))){if(!state.setext){state.header=match[0].charAt(0)=='='?1:2;state.setext=state.header;}else{state.header=state.setext;state.setext=0;stream.skipToEnd();if(modeCfg.highlightFormatting)state.formatting="header";}
state.thisLine.header=true;state.f=state.inline;return getType(state);}else if(isHr){stream.skipToEnd();state.hr=true;state.thisLine.hr=true;return tokenTypes.hr;}else if(stream.peek()==='['){return switchInline(stream,state,footnoteLink);}
return switchInline(stream,state,state.inline);}
function htmlBlock(stream,state){var style=htmlMode.token(stream,state.htmlState);if(!htmlModeMissing){var inner=CodeMirror.innerMode(htmlMode,state.htmlState);if((inner.mode.name=="xml"&&inner.state.tagStart===null&&(!inner.state.context&&inner.state.tokenize.isInText))||(state.md_inside&&stream.current().indexOf(">")>-1)){state.f=inlineNormal;state.block=blockNormal;state.htmlState=null;}}
return style;}
function local(stream,state){var currListInd=state.listStack[state.listStack.length-1]||0;var hasExitedList=state.indentation<currListInd;var maxFencedEndInd=currListInd+3;if(state.fencedEndRE&&state.indentation<=maxFencedEndInd&&(hasExitedList||stream.match(state.fencedEndRE))){if(modeCfg.highlightFormatting)state.formatting="code-block";var returnType;if(!hasExitedList)returnType=getType(state);state.localMode=state.localState=null;state.block=blockNormal;state.f=inlineNormal;state.fencedEndRE=null;state.code=0;state.thisLine.fencedCodeEnd=true;if(hasExitedList)return switchBlock(stream,state,state.block);return returnType;}else if(state.localMode){return state.localMode.token(stream,state.localState);}else{stream.skipToEnd();return tokenTypes.code;}}
function getType(state){var styles=[];if(state.formatting){styles.push(tokenTypes.formatting);if(typeof state.formatting==="string")state.formatting=[state.formatting];for(var i=0;i<state.formatting.length;i++){styles.push(tokenTypes.formatting+"-"+state.formatting[i]);if(state.formatting[i]==="header"){styles.push(tokenTypes.formatting+"-"+state.formatting[i]+"-"+state.header);}
if(state.formatting[i]==="quote"){if(!modeCfg.maxBlockquoteDepth||modeCfg.maxBlockquoteDepth>=state.quote){styles.push(tokenTypes.formatting+"-"+state.formatting[i]+"-"+state.quote);}else{styles.push("error");}}}}
if(state.taskOpen){styles.push("meta");return styles.length?styles.join(' '):null;}
if(state.taskClosed){styles.push("property");return styles.length?styles.join(' '):null;}
if(state.linkHref){styles.push(tokenTypes.linkHref,"url");}else{if(state.strong){styles.push(tokenTypes.strong);}
if(state.em){styles.push(tokenTypes.em);}
if(state.strikethrough){styles.push(tokenTypes.strikethrough);}
if(state.emoji){styles.push(tokenTypes.emoji);}
if(state.linkText){styles.push(tokenTypes.linkText);}
if(state.code){styles.push(tokenTypes.code);}
if(state.image){styles.push(tokenTypes.image);}
if(state.imageAltText){styles.push(tokenTypes.imageAltText,"link");}
if(state.imageMarker){styles.push(tokenTypes.imageMarker);}}
if(state.header){styles.push(tokenTypes.header,tokenTypes.header+"-"+state.header);}
if(state.quote){styles.push(tokenTypes.quote);if(!modeCfg.maxBlockquoteDepth||modeCfg.maxBlockquoteDepth>=state.quote){styles.push(tokenTypes.quote+"-"+state.quote);}else{styles.push(tokenTypes.quote+"-"+modeCfg.maxBlockquoteDepth);}}
if(state.list!==false){var listMod=(state.listStack.length-1)%3;if(!listMod){styles.push(tokenTypes.list1);}else if(listMod===1){styles.push(tokenTypes.list2);}else{styles.push(tokenTypes.list3);}}
if(state.trailingSpaceNewLine){styles.push("trailing-space-new-line");}else if(state.trailingSpace){styles.push("trailing-space-"+(state.trailingSpace%2?"a":"b"));}
return styles.length?styles.join(' '):null;}
function handleText(stream,state){if(stream.match(textRE,true)){return getType(state);}
return undefined;}
function inlineNormal(stream,state){var style=state.text(stream,state);if(typeof style!=='undefined')
return style;if(state.list){state.list=null;return getType(state);}
if(state.taskList){var taskOpen=stream.match(taskListRE,true)[1]===" ";if(taskOpen)state.taskOpen=true;else state.taskClosed=true;if(modeCfg.highlightFormatting)state.formatting="task";state.taskList=false;return getType(state);}
state.taskOpen=false;state.taskClosed=false;if(state.header&&stream.match(/^#+$/,true)){if(modeCfg.highlightFormatting)state.formatting="header";return getType(state);}
var ch=stream.next();if(state.linkTitle){state.linkTitle=false;var matchCh=ch;if(ch==='('){matchCh=')';}
matchCh=(matchCh+'').replace(/([.?*+^\[\]\\(){}|-])/g,"\\$1");var regex='^\\s*(?:[^'+matchCh+'\\\\]+|\\\\\\\\|\\\\.)'+matchCh;if(stream.match(new RegExp(regex),true)){return tokenTypes.linkHref;}}
if(ch==='`'){var previousFormatting=state.formatting;if(modeCfg.highlightFormatting)state.formatting="code";stream.eatWhile('`');var count=stream.current().length;if(state.code==0&&(!state.quote||count==1)){state.code=count;return getType(state)}else if(count==state.code){var t=getType(state);state.code=0;return t}else{state.formatting=previousFormatting;return getType(state)}}else if(state.code){return getType(state);}
if(ch==='\\'){stream.next();if(modeCfg.highlightFormatting){var type=getType(state);var formattingEscape=tokenTypes.formatting+"-escape";return type?type+" "+formattingEscape:formattingEscape;}}
if(ch==='!'&&stream.match(/\[[^\]]*\] ?(?:\(|\[)/,false)){state.imageMarker=true;state.image=true;if(modeCfg.highlightFormatting)state.formatting="image";return getType(state);}
if(ch==='['&&state.imageMarker&&stream.match(/[^\]]*\](\(.*?\)| ?\[.*?\])/,false)){state.imageMarker=false;state.imageAltText=true;if(modeCfg.highlightFormatting)state.formatting="image";return getType(state);}
if(ch===']'&&state.imageAltText){if(modeCfg.highlightFormatting)state.formatting="image";var type=getType(state);state.imageAltText=false;state.image=false;state.inline=state.f=linkHref;return type;}
if(ch==='['&&!state.image){if(state.linkText&&stream.match(/^.*?\]/))return getType(state)
state.linkText=true;if(modeCfg.highlightFormatting)state.formatting="link";return getType(state);}
if(ch===']'&&state.linkText){if(modeCfg.highlightFormatting)state.formatting="link";var type=getType(state);state.linkText=false;state.inline=state.f=stream.match(/\(.*?\)| ?\[.*?\]/,false)?linkHref:inlineNormal;return type;}
if(ch==='<'&&stream.match(/^(https?|ftps?):\/\/(?:[^\\>]|\\.)+>/,false)){state.f=state.inline=linkInline;if(modeCfg.highlightFormatting)state.formatting="link";var type=getType(state);if(type){type+=" ";}else{type="";}
return type+tokenTypes.linkInline;}
if(ch==='<'&&stream.match(/^[^> \\]+@(?:[^\\>]|\\.)+>/,false)){state.f=state.inline=linkInline;if(modeCfg.highlightFormatting)state.formatting="link";var type=getType(state);if(type){type+=" ";}else{type="";}
return type+tokenTypes.linkEmail;}
if(modeCfg.xml&&ch==='<'&&stream.match(/^(!--|\?|!\[CDATA\[|[a-z][a-z0-9-]*(?:\s+[a-z_:.\-]+(?:\s*=\s*[^>]+)?)*\s*(?:>|$))/i,false)){var end=stream.string.indexOf(">",stream.pos);if(end!=-1){var atts=stream.string.substring(stream.start,end);if(/markdown\s*=\s*('|"){0,1}1('|"){0,1}/.test(atts))state.md_inside=true;}
stream.backUp(1);state.htmlState=CodeMirror.startState(htmlMode);return switchBlock(stream,state,htmlBlock);}
if(modeCfg.xml&&ch==='<'&&stream.match(/^\/\w*?>/)){state.md_inside=false;return"tag";}else if(ch==="*"||ch==="_"){var len=1,before=stream.pos==1?" ":stream.string.charAt(stream.pos-2);while(len<3&&stream.eat(ch))len++;var after=stream.peek()||" ";var leftFlanking=!/\s/.test(after)&&(!punctuation.test(after)||/\s/.test(before)||punctuation.test(before));var rightFlanking=!/\s/.test(before)&&(!punctuation.test(before)||/\s/.test(after)||punctuation.test(after));var setEm=null,setStrong=null;if(len%2){if(!state.em&&leftFlanking&&(ch==="*"||!rightFlanking||punctuation.test(before)))
setEm=true;else if(state.em==ch&&rightFlanking&&(ch==="*"||!leftFlanking||punctuation.test(after)))
setEm=false;}
if(len>1){if(!state.strong&&leftFlanking&&(ch==="*"||!rightFlanking||punctuation.test(before)))
setStrong=true;else if(state.strong==ch&&rightFlanking&&(ch==="*"||!leftFlanking||punctuation.test(after)))
setStrong=false;}
if(setStrong!=null||setEm!=null){if(modeCfg.highlightFormatting)state.formatting=setEm==null?"strong":setStrong==null?"em":"strong em";if(setEm===true)state.em=ch;if(setStrong===true)state.strong=ch;var t=getType(state);if(setEm===false)state.em=false;if(setStrong===false)state.strong=false;return t}}else if(ch===' '){if(stream.eat('*')||stream.eat('_')){if(stream.peek()===' '){return getType(state);}else{stream.backUp(1);}}}
if(modeCfg.strikethrough){if(ch==='~'&&stream.eatWhile(ch)){if(state.strikethrough){if(modeCfg.highlightFormatting)state.formatting="strikethrough";var t=getType(state);state.strikethrough=false;return t;}else if(stream.match(/^[^\s]/,false)){state.strikethrough=true;if(modeCfg.highlightFormatting)state.formatting="strikethrough";return getType(state);}}else if(ch===' '){if(stream.match(/^~~/,true)){if(stream.peek()===' '){return getType(state);}else{stream.backUp(2);}}}}
if(modeCfg.emoji&&ch===":"&&stream.match(/^(?:[a-z_\d+][a-z_\d+-]*|\-[a-z_\d+][a-z_\d+-]*):/)){state.emoji=true;if(modeCfg.highlightFormatting)state.formatting="emoji";var retType=getType(state);state.emoji=false;return retType;}
if(ch===' '){if(stream.match(/^ +$/,false)){state.trailingSpace++;}else if(state.trailingSpace){state.trailingSpaceNewLine=true;}}
return getType(state);}
function linkInline(stream,state){var ch=stream.next();if(ch===">"){state.f=state.inline=inlineNormal;if(modeCfg.highlightFormatting)state.formatting="link";var type=getType(state);if(type){type+=" ";}else{type="";}
return type+tokenTypes.linkInline;}
stream.match(/^[^>]+/,true);return tokenTypes.linkInline;}
function linkHref(stream,state){if(stream.eatSpace()){return null;}
var ch=stream.next();if(ch==='('||ch==='['){state.f=state.inline=getLinkHrefInside(ch==="("?")":"]");if(modeCfg.highlightFormatting)state.formatting="link-string";state.linkHref=true;return getType(state);}
return'error';}
var linkRE={")":/^(?:[^\\\(\)]|\\.|\((?:[^\\\(\)]|\\.)*\))*?(?=\))/,"]":/^(?:[^\\\[\]]|\\.|\[(?:[^\\\[\]]|\\.)*\])*?(?=\])/};function getLinkHrefInside(endChar){return function(stream,state){var ch=stream.next();if(ch===endChar){state.f=state.inline=inlineNormal;if(modeCfg.highlightFormatting)state.formatting="link-string";var returnState=getType(state);state.linkHref=false;return returnState;}
stream.match(linkRE[endChar]);state.linkHref=true;return getType(state);};}
function footnoteLink(stream,state){if(stream.match(/^([^\]\\]|\\.)*\]:/,false)){state.f=footnoteLinkInside;stream.next();if(modeCfg.highlightFormatting)state.formatting="link";state.linkText=true;return getType(state);}
return switchInline(stream,state,inlineNormal);}
function footnoteLinkInside(stream,state){if(stream.match(/^\]:/,true)){state.f=state.inline=footnoteUrl;if(modeCfg.highlightFormatting)state.formatting="link";var returnType=getType(state);state.linkText=false;return returnType;}
stream.match(/^([^\]\\]|\\.)+/,true);return tokenTypes.linkText;}
function footnoteUrl(stream,state){if(stream.eatSpace()){return null;}
stream.match(/^[^\s]+/,true);if(stream.peek()===undefined){state.linkTitle=true;}else{stream.match(/^(?:\s+(?:"(?:[^"\\]|\\\\|\\.)+"|'(?:[^'\\]|\\\\|\\.)+'|\((?:[^)\\]|\\\\|\\.)+\)))?/,true);}
state.f=state.inline=inlineNormal;return tokenTypes.linkHref+" url";}
var mode={startState:function(){return{f:blockNormal,prevLine:{stream:null},thisLine:{stream:null},block:blockNormal,htmlState:null,indentation:0,inline:inlineNormal,text:handleText,formatting:false,linkText:false,linkHref:false,linkTitle:false,code:0,em:false,strong:false,header:0,setext:0,hr:false,taskList:false,list:false,listStack:[],quote:0,trailingSpace:0,trailingSpaceNewLine:false,strikethrough:false,emoji:false,fencedEndRE:null};},copyState:function(s){return{f:s.f,prevLine:s.prevLine,thisLine:s.thisLine,block:s.block,htmlState:s.htmlState&&CodeMirror.copyState(htmlMode,s.htmlState),indentation:s.indentation,localMode:s.localMode,localState:s.localMode?CodeMirror.copyState(s.localMode,s.localState):null,inline:s.inline,text:s.text,formatting:false,linkText:s.linkText,linkTitle:s.linkTitle,linkHref:s.linkHref,code:s.code,em:s.em,strong:s.strong,strikethrough:s.strikethrough,emoji:s.emoji,header:s.header,setext:s.setext,hr:s.hr,taskList:s.taskList,list:s.list,listStack:s.listStack.slice(0),quote:s.quote,indentedCode:s.indentedCode,trailingSpace:s.trailingSpace,trailingSpaceNewLine:s.trailingSpaceNewLine,md_inside:s.md_inside,fencedEndRE:s.fencedEndRE};},token:function(stream,state){state.formatting=false;if(stream!=state.thisLine.stream){state.header=0;state.hr=false;if(stream.match(/^\s*$/,true)){blankLine(state);return null;}
state.prevLine=state.thisLine;state.thisLine={stream:stream};state.taskList=false;state.trailingSpace=0;state.trailingSpaceNewLine=false;if(!state.localState){state.f=state.block;if(state.f!=htmlBlock){var indentation=stream.match(/^\s*/,true)[0].replace(/\t/g,expandedTab).length;state.indentation=indentation;state.indentationDiff=null;if(indentation>0)return null;}}}
return state.f(stream,state);},innerMode:function(state){if(state.block==htmlBlock)return{state:state.htmlState,mode:htmlMode};if(state.localState)return{state:state.localState,mode:state.localMode};return{state:state,mode:mode};},indent:function(state,textAfter,line){if(state.block==htmlBlock&&htmlMode.indent)return htmlMode.indent(state.htmlState,textAfter,line)
if(state.localState&&state.localMode.indent)return state.localMode.indent(state.localState,textAfter,line)
return CodeMirror.Pass},blankLine:blankLine,getType:getType,blockCommentStart:"<!--",blockCommentEnd:"-->",closeBrackets:"()[]{}''\"\"``",fold:"markdown"};return mode;},"xml");CodeMirror.defineMIME("text/markdown","markdown");CodeMirror.defineMIME("text/x-markdown","markdown");});(function(mod){if(typeof exports==="object"&&typeof module==="object")
mod(require("../../lib/codemirror"));else if(typeof define==="function"&&define.amd)
define(["../../lib/codemirror"],mod);else
mod(CodeMirror);})(function(CodeMirror){"use strict";CodeMirror.defineMode("clojure",function(options){var atoms=["false","nil","true"];var specialForms=[".","catch","def","do","if","monitor-enter","monitor-exit","new","quote","recur","set!","throw","try","var"];var coreSymbols=["*","*'","*1","*2","*3","*agent*","*allow-unresolved-vars*","*assert*","*clojure-version*","*command-line-args*","*compile-files*","*compile-path*","*compiler-options*","*data-readers*","*default-data-reader-fn*","*e","*err*","*file*","*flush-on-newline*","*fn-loader*","*in*","*math-context*","*ns*","*out*","*print-dup*","*print-length*","*print-level*","*print-meta*","*print-namespace-maps*","*print-readably*","*read-eval*","*reader-resolver*","*source-path*","*suppress-read*","*unchecked-math*","*use-context-classloader*","*verbose-defrecords*","*warn-on-reflection*","+","+'","-","-'","->","->>","->ArrayChunk","->Eduction","->Vec","->VecNode","->VecSeq","-cache-protocol-fn","-reset-methods","..","/","<","<=","=","==",">",">=","EMPTY-NODE","Inst","StackTraceElement->vec","Throwable->map","accessor","aclone","add-classpath","add-watch","agent","agent-error","agent-errors","aget","alength","alias","all-ns","alter","alter-meta!","alter-var-root","amap","ancestors","and","any?","apply","areduce","array-map","as->","aset","aset-boolean","aset-byte","aset-char","aset-double","aset-float","aset-int","aset-long","aset-short","assert","assoc","assoc!","assoc-in","associative?","atom","await","await-for","await1","bases","bean","bigdec","bigint","biginteger","binding","bit-and","bit-and-not","bit-clear","bit-flip","bit-not","bit-or","bit-set","bit-shift-left","bit-shift-right","bit-test","bit-xor","boolean","boolean-array","boolean?","booleans","bound-fn","bound-fn*","bound?","bounded-count","butlast","byte","byte-array","bytes","bytes?","case","cast","cat","char","char-array","char-escape-string","char-name-string","char?","chars","chunk","chunk-append","chunk-buffer","chunk-cons","chunk-first","chunk-next","chunk-rest","chunked-seq?","class","class?","clear-agent-errors","clojure-version","coll?","comment","commute","comp","comparator","compare","compare-and-set!","compile","complement","completing","concat","cond","cond->","cond->>","condp","conj","conj!","cons","constantly","construct-proxy","contains?","count","counted?","create-ns","create-struct","cycle","dec","dec'","decimal?","declare","dedupe","default-data-readers","definline","definterface","defmacro","defmethod","defmulti","defn","defn-","defonce","defprotocol","defrecord","defstruct","deftype","delay","delay?","deliver","denominator","deref","derive","descendants","destructure","disj","disj!","dissoc","dissoc!","distinct","distinct?","doall","dorun","doseq","dosync","dotimes","doto","double","double-array","double?","doubles","drop","drop-last","drop-while","eduction","empty","empty?","ensure","ensure-reduced","enumeration-seq","error-handler","error-mode","eval","even?","every-pred","every?","ex-data","ex-info","extend","extend-protocol","extend-type","extenders","extends?","false?","ffirst","file-seq","filter","filterv","find","find-keyword","find-ns","find-protocol-impl","find-protocol-method","find-var","first","flatten","float","float-array","float?","floats","flush","fn","fn?","fnext","fnil","for","force","format","frequencies","future","future-call","future-cancel","future-cancelled?","future-done?","future?","gen-class","gen-interface","gensym","get","get-in","get-method","get-proxy-class","get-thread-bindings","get-validator","group-by","halt-when","hash","hash-combine","hash-map","hash-ordered-coll","hash-set","hash-unordered-coll","ident?","identical?","identity","if-let","if-not","if-some","ifn?","import","in-ns","inc","inc'","indexed?","init-proxy","inst-ms","inst-ms*","inst?","instance?","int","int-array","int?","integer?","interleave","intern","interpose","into","into-array","ints","io!","isa?","iterate","iterator-seq","juxt","keep","keep-indexed","key","keys","keyword","keyword?","last","lazy-cat","lazy-seq","let","letfn","line-seq","list","list*","list?","load","load-file","load-reader","load-string","loaded-libs","locking","long","long-array","longs","loop","macroexpand","macroexpand-1","make-array","make-hierarchy","map","map-entry?","map-indexed","map?","mapcat","mapv","max","max-key","memfn","memoize","merge","merge-with","meta","method-sig","methods","min","min-key","mix-collection-hash","mod","munge","name","namespace","namespace-munge","nat-int?","neg-int?","neg?","newline","next","nfirst","nil?","nnext","not","not-any?","not-empty","not-every?","not=","ns","ns-aliases","ns-imports","ns-interns","ns-map","ns-name","ns-publics","ns-refers","ns-resolve","ns-unalias","ns-unmap","nth","nthnext","nthrest","num","number?","numerator","object-array","odd?","or","parents","partial","partition","partition-all","partition-by","pcalls","peek","persistent!","pmap","pop","pop!","pop-thread-bindings","pos-int?","pos?","pr","pr-str","prefer-method","prefers","primitives-classnames","print","print-ctor","print-dup","print-method","print-simple","print-str","printf","println","println-str","prn","prn-str","promise","proxy","proxy-call-with-super","proxy-mappings","proxy-name","proxy-super","push-thread-bindings","pvalues","qualified-ident?","qualified-keyword?","qualified-symbol?","quot","rand","rand-int","rand-nth","random-sample","range","ratio?","rational?","rationalize","re-find","re-groups","re-matcher","re-matches","re-pattern","re-seq","read","read-line","read-string","reader-conditional","reader-conditional?","realized?","record?","reduce","reduce-kv","reduced","reduced?","reductions","ref","ref-history-count","ref-max-history","ref-min-history","ref-set","refer","refer-clojure","reify","release-pending-sends","rem","remove","remove-all-methods","remove-method","remove-ns","remove-watch","repeat","repeatedly","replace","replicate","require","reset!","reset-meta!","reset-vals!","resolve","rest","restart-agent","resultset-seq","reverse","reversible?","rseq","rsubseq","run!","satisfies?","second","select-keys","send","send-off","send-via","seq","seq?","seqable?","seque","sequence","sequential?","set","set-agent-send-executor!","set-agent-send-off-executor!","set-error-handler!","set-error-mode!","set-validator!","set?","short","short-array","shorts","shuffle","shutdown-agents","simple-ident?","simple-keyword?","simple-symbol?","slurp","some","some->","some->>","some-fn","some?","sort","sort-by","sorted-map","sorted-map-by","sorted-set","sorted-set-by","sorted?","special-symbol?","spit","split-at","split-with","str","string?","struct","struct-map","subs","subseq","subvec","supers","swap!","swap-vals!","symbol","symbol?","sync","tagged-literal","tagged-literal?","take","take-last","take-nth","take-while","test","the-ns","thread-bound?","time","to-array","to-array-2d","trampoline","transduce","transient","tree-seq","true?","type","unchecked-add","unchecked-add-int","unchecked-byte","unchecked-char","unchecked-dec","unchecked-dec-int","unchecked-divide-int","unchecked-double","unchecked-float","unchecked-inc","unchecked-inc-int","unchecked-int","unchecked-long","unchecked-multiply","unchecked-multiply-int","unchecked-negate","unchecked-negate-int","unchecked-remainder-int","unchecked-short","unchecked-subtract","unchecked-subtract-int","underive","unquote","unquote-splicing","unreduced","unsigned-bit-shift-right","update","update-in","update-proxy","uri?","use","uuid?","val","vals","var-get","var-set","var?","vary-meta","vec","vector","vector-of","vector?","volatile!","volatile?","vreset!","vswap!","when","when-first","when-let","when-not","when-some","while","with-bindings","with-bindings*","with-in-str","with-loading-context","with-local-vars","with-meta","with-open","with-out-str","with-precision","with-redefs","with-redefs-fn","xml-seq","zero?","zipmap"];var haveBodyParameter=["->","->>","as->","binding","bound-fn","case","catch","comment","cond","cond->","cond->>","condp","def","definterface","defmethod","defn","defmacro","defprotocol","defrecord","defstruct","deftype","do","doseq","dotimes","doto","extend","extend-protocol","extend-type","fn","for","future","if","if-let","if-not","if-some","let","letfn","locking","loop","ns","proxy","reify","struct-map","some->","some->>","try","when","when-first","when-let","when-not","when-some","while","with-bindings","with-bindings*","with-in-str","with-loading-context","with-local-vars","with-meta","with-open","with-out-str","with-precision","with-redefs","with-redefs-fn"];CodeMirror.registerHelper("hintWords","clojure",[].concat(atoms,specialForms,coreSymbols));var atom=createLookupMap(atoms);var specialForm=createLookupMap(specialForms);var coreSymbol=createLookupMap(coreSymbols);var hasBodyParameter=createLookupMap(haveBodyParameter);var delimiter=/^(?:[\\\[\]\s"(),;@^`{}~]|$)/;var numberLiteral=/^(?:[+\-]?\d+(?:(?:N|(?:[eE][+\-]?\d+))|(?:\.?\d*(?:M|(?:[eE][+\-]?\d+))?)|\/\d+|[xX][0-9a-fA-F]+|r[0-9a-zA-Z]+)?(?=[\\\[\]\s"#'(),;@^`{}~]|$))/;var characterLiteral=/^(?:\\(?:backspace|formfeed|newline|return|space|tab|o[0-7]{3}|u[0-9A-Fa-f]{4}|x[0-9A-Fa-f]{4}|.)?(?=[\\\[\]\s"(),;@^`{}~]|$))/;var qualifiedSymbol=/^(?:(?:[^\\\/\[\]\d\s"#'(),;@^`{}~][^\\\[\]\s"(),;@^`{}~]*(?:\.[^\\\/\[\]\d\s"#'(),;@^`{}~][^\\\[\]\s"(),;@^`{}~]*)*\/)?(?:\/|[^\\\/\[\]\d\s"#'(),;@^`{}~][^\\\[\]\s"(),;@^`{}~]*)*(?=[\\\[\]\s"(),;@^`{}~]|$))/;function base(stream,state){if(stream.eatSpace()||stream.eat(","))return["space",null];if(stream.match(numberLiteral))return[null,"number"];if(stream.match(characterLiteral))return[null,"string-2"];if(stream.eat(/^"/))return(state.tokenize=inString)(stream,state);if(stream.eat(/^[(\[{]/))return["open","bracket"];if(stream.eat(/^[)\]}]/))return["close","bracket"];if(stream.eat(/^;/)){stream.skipToEnd();return["space","comment"];}
if(stream.eat(/^[#'@^`~]/))return[null,"meta"];var matches=stream.match(qualifiedSymbol);var symbol=matches&&matches[0];if(!symbol){stream.next();stream.eatWhile(function(c){return!is(c,delimiter);});return[null,"error"];}
if(symbol==="comment"&&state.lastToken==="(")
return(state.tokenize=inComment)(stream,state);if(is(symbol,atom)||symbol.charAt(0)===":")return["symbol","atom"];if(is(symbol,specialForm)||is(symbol,coreSymbol))return["symbol","keyword"];if(state.lastToken==="(")return["symbol","builtin"];return["symbol","variable"];}
function inString(stream,state){var escaped=false,next;while(next=stream.next()){if(next==="\""&&!escaped){state.tokenize=base;break;}
escaped=!escaped&&next==="\\";}
return[null,"string"];}
function inComment(stream,state){var parenthesisCount=1;var next;while(next=stream.next()){if(next===")")parenthesisCount--;if(next==="(")parenthesisCount++;if(parenthesisCount===0){stream.backUp(1);state.tokenize=base;break;}}
return["space","comment"];}
function createLookupMap(words){var obj={};for(var i=0;i<words.length;++i)obj[words[i]]=true;return obj;}
function is(value,test){if(test instanceof RegExp)return test.test(value);if(test instanceof Object)return test.propertyIsEnumerable(value);}
return{startState:function(){return{ctx:{prev:null,start:0,indentTo:0},lastToken:null,tokenize:base};},token:function(stream,state){if(stream.sol()&&(typeof state.ctx.indentTo!=="number"))
state.ctx.indentTo=state.ctx.start+1;var typeStylePair=state.tokenize(stream,state);var type=typeStylePair[0];var style=typeStylePair[1];var current=stream.current();if(type!=="space"){if(state.lastToken==="("&&state.ctx.indentTo===null){if(type==="symbol"&&is(current,hasBodyParameter))
state.ctx.indentTo=state.ctx.start+options.indentUnit;else state.ctx.indentTo="next";}else if(state.ctx.indentTo==="next"){state.ctx.indentTo=stream.column();}
state.lastToken=current;}
if(type==="open")
state.ctx={prev:state.ctx,start:stream.column(),indentTo:null};else if(type==="close")state.ctx=state.ctx.prev||state.ctx;return style;},indent:function(state){var i=state.ctx.indentTo;return(typeof i==="number")?i:state.ctx.start+1;},closeBrackets:{pairs:"()[]{}\"\""},lineComment:";;"};});CodeMirror.defineMIME("text/x-clojure","clojure");CodeMirror.defineMIME("text/x-clojurescript","clojure");CodeMirror.defineMIME("application/edn","clojure");});(function(mod){if(typeof exports=="object"&&typeof module=="object")
mod(require("../../lib/codemirror"),require("../xml/xml"),require("../javascript/javascript"));else if(typeof define=="function"&&define.amd)
define(["../../lib/codemirror","../xml/xml","../javascript/javascript"],mod);else
mod(CodeMirror);})(function(CodeMirror){"use strict";function Context(state,mode,depth,prev){this.state=state;this.mode=mode;this.depth=depth;this.prev=prev;}
function copyContext(context){return new Context(CodeMirror.copyState(context.mode,context.state),context.mode,context.depth,context.prev&&copyContext(context.prev))}
CodeMirror.defineMode("jsx",function(config,modeConfig){var xmlMode=CodeMirror.getMode(config,{name:"xml",allowMissing:true,multilineTagIndentPastTag:false,allowMissingTagName:true});var jsMode=CodeMirror.getMode(config,modeConfig&&modeConfig.base||"javascript");function flatXMLIndent(state){var tagName=state.tagName;state.tagName=null;var result=xmlMode.indent(state,"","");state.tagName=tagName;return result}
function token(stream,state){if(state.context.mode==xmlMode)
return xmlToken(stream,state,state.context)
else
return jsToken(stream,state,state.context)}
function xmlToken(stream,state,cx){if(cx.depth==2){if(stream.match(/^.*?\*\//))cx.depth=1;else stream.skipToEnd();return"comment"}
if(stream.peek()=="{"){xmlMode.skipAttribute(cx.state);var indent=flatXMLIndent(cx.state),xmlContext=cx.state.context;if(xmlContext&&stream.match(/^[^>]*>\s*$/,false)){while(xmlContext.prev&&!xmlContext.startOfLine)
xmlContext=xmlContext.prev;if(xmlContext.startOfLine)indent-=config.indentUnit;else if(cx.prev.state.lexical)indent=cx.prev.state.lexical.indented;}else if(cx.depth==1){indent+=config.indentUnit;}
state.context=new Context(CodeMirror.startState(jsMode,indent),jsMode,0,state.context);return null}
if(cx.depth==1){if(stream.peek()=="<"){xmlMode.skipAttribute(cx.state);state.context=new Context(CodeMirror.startState(xmlMode,flatXMLIndent(cx.state)),xmlMode,0,state.context);return null}else if(stream.match("//")){stream.skipToEnd();return"comment"}else if(stream.match("/*")){cx.depth=2;return token(stream,state)}}
var style=xmlMode.token(stream,cx.state),cur=stream.current(),stop;if(/\btag\b/.test(style)){if(/>$/.test(cur)){if(cx.state.context)cx.depth=0;else state.context=state.context.prev;}else if(/^</.test(cur)){cx.depth=1;}}else if(!style&&(stop=cur.indexOf("{"))>-1){stream.backUp(cur.length-stop);}
return style}
function jsToken(stream,state,cx){if(stream.peek()=="<"&&jsMode.expressionAllowed(stream,cx.state)){jsMode.skipExpression(cx.state);state.context=new Context(CodeMirror.startState(xmlMode,jsMode.indent(cx.state,"","")),xmlMode,0,state.context);return null}
var style=jsMode.token(stream,cx.state);if(!style&&cx.depth!=null){var cur=stream.current();if(cur=="{"){cx.depth++;}else if(cur=="}"){if(--cx.depth==0)state.context=state.context.prev;}}
return style}
return{startState:function(){return{context:new Context(CodeMirror.startState(jsMode),jsMode)}},copyState:function(state){return{context:copyContext(state.context)}},token:token,indent:function(state,textAfter,fullLine){return state.context.mode.indent(state.context.state,textAfter,fullLine)},innerMode:function(state){return state.context}}},"xml","javascript");CodeMirror.defineMIME("text/jsx","jsx");CodeMirror.defineMIME("text/typescript-jsx",{name:"jsx",base:{name:"javascript",typescript:true}});});class DefaultCodeMirrorMimeMode{async install(extension){return Promise.resolve();}}
CmModes.DefaultCodeMirrorMimeMode=DefaultCodeMirrorMimeMode;var DefaultCodeMirrorMimeMode$1=Object.freeze({__proto__:null,DefaultCodeMirrorMimeMode:DefaultCodeMirrorMimeMode});export{DefaultCodeMirrorMimeMode$1 as DefaultCodeMirrorMimeMode};