self.Runtime.cachedResources["issues/issuesPane.css"]="/*\n * Copyright (c) 2020 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.issues-pane {\n  overflow: hidden;\n}\n\n.issues-toolbar-container {\n  display: flex;\n  flex: none;\n}\n\n.issues-toolbar-container > .toolbar {\n  background-color: var(--toolbar-bg-color);\n  border-bottom: var(--divider-border);\n}\n\n.issues-toolbar-left {\n  flex: 1 1 auto;\n}\n\n.issues-toolbar-right {\n  padding-right: 6px;\n}\n\n/*# sourceURL=issues/issuesPane.css */";self.Runtime.cachedResources["issues/issuesTree.css"]="/*\n * Copyright (c) 2020 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n/* Remove container padding from TreeOutline.\n * Allows issues to touch the edges of the container. */\n:host,\n.issues {\n  padding: 0;\n  overflow: auto;\n}\n\n.issues {\n  --breaking-change-color: #F29900;\n  --issue-gray: #5F6368;\n  --issue-link: #1967D2;\n  --issue-black: #202124;\n  --affected-resource-background: #F8F9FA;\n}\n\n:host-context(.-theme-with-dark-background) .issues {\n  --issue-gray: #A09C97;\n  --issue-black: #DFDEDB;\n  --affected-resource-background: #070605;\n}\n\n/* Override whitespace behavior for tree items to allow wrapping */\n.issues li {\n  white-space: normal;\n}\n\n/* Hide toggle for tree items which cannot be collapsed */\n.issues .always-parent::before {\n  display: none;\n}\n\n/* Override TreeOutline toggle switching to allow animation */\n.issues li.parent::before {\n  transition: transform 200ms;\n  transform-origin: 25% 50%;\n}\n.issues li.parent.expanded::before {\n  -webkit-mask-position: 0 0;\n  transform: rotate(90deg);\n}\n\n.issue {\n  padding: 0 8px;\n  overflow: hidden;\n  flex: none;\n  transition: background-color 200ms;\n  background: #F3F3F3;\n  border: 1px solid #E5E5E5;\n  border-width: 0 0 1px;\n}\n\n.issue.expanded {\n  background: #FFFFFF;\n  border-width: 0;\n}\n\n.issue::before {\n  /* Move toggle for issue items to the right */\n  order: 3;\n  /* Point toggle arrow up for issue items when closed */\n  transform: rotate(180deg);\n}\n\np {\n  margin-block-start: 2px;\n  margin-block-end: 2px;\n}\n\n/* Override selected tree item styles for issues to avoid changing width. */\n.tree-outline-disclosure:not(.tree-outline-disclosure-hide-overflow) .tree-outline.hide-selection-when-blurred .issue.selected:focus[data-keyboard-focus=\"true\"] {\n  width: auto;\n  padding-right: 8px;\n}\n\n.header {\n  display: flex;\n  flex-direction: row;\n  align-items: center;\n  padding: 6px 0;\n  cursor: pointer;\n  width: 100%;\n}\n\n.icon {\n  margin-right: 4px;\n}\n\n.title {\n  flex: 1;\n  font-size: 14px;\n  color: var(--issue-black);\n  font-weight: normal;\n}\n\n.issue.expanded .title {\n  font-weight: 450;\n}\n\n.body.children {\n  border-bottom: 1px solid #E5E5E5;\n  padding: 6px 0;\n  position: relative;\n  padding-left: 38.5px;\n  padding-bottom: 26px;\n  padding-right: 8px;\n}\n\n/* Show a colored border on the left side of opened issues. */\n.body::before {\n  content: '';\n  display: block;\n  position: absolute;\n  left: 17.5px;\n  top: 0;\n  bottom: 20px;\n  border-left: 2px solid var(--breaking-change-color);\n  width: 2px;\n}\n\n.message {\n  line-height: 20px;\n  font-size: 14px;\n  color: var(--issue-gray);\n  margin-bottom: 4px;\n}\n\n.message .example {\n  margin-top: 2px;\n  margin-bottom: 2px;\n}\n\n.message .example code {\n  color: var(--issue-black);\n  font-size: 90%;\n  user-select: text;\n  cursor: text;\n}\n\n.message .example .comment::before {\n   content: ' — ';\n}\n\n.kind-code-line {\n  font-size: 12px;\n  color: var(--issue-gray);\n  margin-bottom: 4px;\n  user-select: none;\n}\n\n.separator::before {\n  content: '·';\n  padding-left: 1ex;\n  padding-right: 1ex;\n}\n\n.issue-code {\n  color: rgba(95, 99, 104, 0.5);\n  user-select: text;\n  cursor: text;\n}\n\n.issue-kind {\n  color: var(--breaking-change-color);\n}\n\n.link {\n  font-size: 14px;\n  color: var(--issue-link);\n}\n\n.link-wrapper {\n  margin-top: 8px;\n}\n\n.affected-resources-label,\n.resolutions-label {\n  font-size: 10px;\n  font-weight: 500;\n  line-height: 2em;\n  letter-spacing: 0.06em;\n  text-transform: uppercase;\n  color: var(--issue-black);\n}\n\n.resolutions-list {\n  list-style-type: circle;\n  padding-inline-start: 20px;\n}\n\n/* We inherit all the styles from treeoutline, but these are simple text <li>, so we override some styles */\n.resolutions-list li::before {\n  content: none;\n  -webkit-mask-image: none;\n}\n\n.resolutions-list li {\n  display: list-item;\n}\n\n.affected-resources {\n  background: var(--affected-resource-background);\n  padding: 12px 3px 12px 20px;\n  position: relative;\n}\n\n.affected-resource-label {\n  font-size: 14px;\n  line-height: 20px;\n  color: var(--issue-black);\n  position: relative;\n  cursor: pointer;\n}\n\n.affected-resource-cookie {\n  font-size: 14px;\n  line-height: 20px;\n  color: var(--issue-link);\n  border: 0;\n  border-collapse: collapse;\n}\n\n.affected-resource-mixed-content {\n  font-size: 14px;\n  line-height: 20px;\n  color: var(--issue-link);\n  border: 0;\n  border-collapse: collapse;\n}\n\n.affected-resource-request {\n  font-size: 14px;\n  line-height: 20px;\n  color: var(--issue-link);\n  border: 0;\n  border-collapse: collapse;\n}\n\n.affected-resource-list {\n  border-spacing: 10px 0;\n  margin-left: -10px;\n}\n\n.affected-resource-header {\n  font-size: 12px;\n  color: rgba(95, 99, 104, 0.5);\n  padding-left: 2px;\n}\n\n.affected-resource-cookie-info {\n  color: var(--issue-gray);\n  padding: 2px;\n}\n\n.affected-resource-mixed-content-info {\n  color: var(--issue-gray);\n  padding: 2px;\n}\n\n/*# sourceURL=issues/issuesTree.css */";