import{SDKModel,WebAuthnModel}from'../sdk/sdk.js';import{Widget,Toolbar,UIUtils,ARIAUtils}from'../ui/ui.js';class WebauthnPaneImpl extends Widget.VBox{constructor(){super(true);this.registerRequiredCSS('webauthn/webauthnPane.css');this.contentElement.classList.add('webauthn-pane');this._enabled=false;this._activeAuthId=null;const mainTarget=SDKModel.TargetManager.instance().mainTarget();if(mainTarget){this._model=mainTarget.model(WebAuthnModel.WebAuthnModel);}
this._createToolbar();this._authenticatorsView=this.contentElement.createChild('div','authenticators-view');this._createNewAuthenticatorSection();this._updateVisibility(false);}
ownerViewDisposed(){this._enableCheckbox.setChecked(false);this._setVirtualAuthEnvEnabled(false);}
_createToolbar(){this._topToolbarContainer=this.contentElement.createChild('div','webauthn-toolbar-container');this._topToolbar=new Toolbar.Toolbar('webauthn-toolbar',this._topToolbarContainer);const enableCheckboxTitle=ls`Enable virtual authenticator environment`;this._enableCheckbox=new Toolbar.ToolbarCheckbox(enableCheckboxTitle,enableCheckboxTitle,this._handleCheckboxToggle.bind(this));this._topToolbar.appendToolbarItem(this._enableCheckbox);}
_setVirtualAuthEnvEnabled(enable){this._enabled=enable;this._model.setVirtualAuthEnvEnabled(enable);this._updateVisibility(enable);if(!enable){this._removeAuthenticatorSections();}}
_updateVisibility(enabled){if(enabled){if(this._newAuthenticatorSection){this._newAuthenticatorSection.style.visibility='visible';}}else{if(this._newAuthenticatorSection){this._newAuthenticatorSection.style.visibility='hidden';}}}
_removeAuthenticatorSections(){this._authenticatorsView.innerHTML='';}
_handleCheckboxToggle(){this._setVirtualAuthEnvEnabled(!this._enabled);}
_createNewAuthenticatorSection(){this._newAuthenticatorSection=this.contentElement.createChild('div','new-authenticator-container');const newAuthenticatorTitle=UIUtils.createLabel(ls`New authenticator`,'new-authenticator-title');this._newAuthenticatorSection.appendChild(newAuthenticatorTitle);this._newAuthenticatorForm=this._newAuthenticatorSection.createChild('div','new-authenticator-form');const protocolGroup=this._newAuthenticatorForm.createChild('div','authenticator-option');const transportGroup=this._newAuthenticatorForm.createChild('div','authenticator-option');const residentKeyGroup=this._newAuthenticatorForm.createChild('div','authenticator-option');const userVerificationGroup=this._newAuthenticatorForm.createChild('div','authenticator-option');const addButtonGroup=this._newAuthenticatorForm.createChild('div','authenticator-option');const protocolSelectTitle=UIUtils.createLabel(ls`Protocol`,'authenticator-option-label');protocolGroup.appendChild(protocolSelectTitle);this._protocolSelect=protocolGroup.createChild('select','chrome-select');ARIAUtils.bindLabelToControl(protocolSelectTitle,this._protocolSelect);Object.values(Protocol.WebAuthn.AuthenticatorProtocol).forEach(option=>{this._protocolSelect.appendChild(new Option(option,option));});this._protocolSelect.selectedIndex=0;const transportSelectTitle=UIUtils.createLabel(ls`Transport`,'authenticator-option-label');transportGroup.appendChild(transportSelectTitle);this._transportSelect=transportGroup.createChild('select','chrome-select');ARIAUtils.bindLabelToControl(transportSelectTitle,this._transportSelect);Object.values(Protocol.WebAuthn.AuthenticatorTransport).forEach(option=>{if(option!==Protocol.WebAuthn.AuthenticatorTransport.Cable){this._transportSelect.appendChild(new Option(option,option));}});this._transportSelect.selectedIndex=0;this._residentKeyCheckboxLabel=UIUtils.CheckboxLabel.create(ls`Supports resident keys`,false);this._residentKeyCheckboxLabel.textElement.classList.add('authenticator-option-label');residentKeyGroup.appendChild(this._residentKeyCheckboxLabel.textElement);this._residentKeyCheckbox=this._residentKeyCheckboxLabel.checkboxElement;this._residentKeyCheckbox.checked=false;this._residentKeyCheckbox.classList.add('authenticator-option-checkbox');residentKeyGroup.appendChild(this._residentKeyCheckbox);this._userVerificationCheckboxLabel=UIUtils.CheckboxLabel.create('Supports user verification',false);this._userVerificationCheckboxLabel.textElement.classList.add('authenticator-option-label');userVerificationGroup.appendChild(this._userVerificationCheckboxLabel.textElement);this._userVerificationCheckbox=this._userVerificationCheckboxLabel.checkboxElement;this._userVerificationCheckbox.checked=false;this._userVerificationCheckbox.classList.add('authenticator-option-checkbox');userVerificationGroup.appendChild(this._userVerificationCheckbox);this._addAuthenticatorButton=UIUtils.createTextButton(ls`Add`,this._handleAddAuthenticatorButton.bind(this),'');addButtonGroup.createChild('div','authenticator-option-label');addButtonGroup.appendChild(this._addAuthenticatorButton);const addAuthenticatorTitle=UIUtils.createLabel(ls`Add authenticator`,'');ARIAUtils.bindLabelToControl(addAuthenticatorTitle,this._addAuthenticatorButton);}
async _handleAddAuthenticatorButton(){const options=this._createOptionsFromCurrentInputs();const authenticatorId=await this._model.addAuthenticator(options);this._addAuthenticatorSection(authenticatorId,options);}
_addAuthenticatorSection(authenticatorId,options){const section=document.createElement('div');section.classList.add('authenticator-section');section.setAttribute('data-authenticator-id',authenticatorId);this._authenticatorsView.insertAdjacentElement('afterbegin',section);const headerElement=section.createChild('div','authenticator-section-header');const titleElement=headerElement.createChild('div','authenticator-section-title');ARIAUtils.markAsHeading(titleElement,2);const removeButton=headerElement.createChild('button','remove-authenticator-button');removeButton.textContent=ls`Remove`;removeButton.addEventListener('click',this._removeAuthenticator.bind(this,authenticatorId));this._clearActiveAuthenticator();const activeButtonContainer=headerElement.createChild('div','active-button-container');const activeLabel=UIUtils.createRadioLabel('active-authenticator',ls`Active`);activeLabel.radioElement.addEventListener('click',this._setActiveAuthenticator.bind(this,authenticatorId));activeButtonContainer.appendChild(activeLabel);activeLabel.radioElement.checked=true;this._activeAuthId=authenticatorId;const toolbar=new Toolbar.Toolbar('edit-name-toolbar',titleElement);const editName=new Toolbar.ToolbarButton(ls`Edit name`,'largeicon-edit');const saveName=new Toolbar.ToolbarButton(ls`Save name`,'largeicon-checkmark');saveName.setVisible(false);const nameField=titleElement.createChild('input','authenticator-name-field');nameField.setAttribute('readOnly','true');const userFriendlyName=authenticatorId.slice(-5);nameField.value=ls`Authenticator ${userFriendlyName}`;this._updateActiveLabelTitle(activeLabel,nameField.value);editName.addEventListener(Toolbar.ToolbarButton.Events.Click,()=>this._handleEditNameButton(titleElement,nameField,editName,saveName));saveName.addEventListener(Toolbar.ToolbarButton.Events.Click,()=>this._handleSaveNameButton(titleElement,nameField,editName,saveName,activeLabel));nameField.addEventListener('focusout',()=>this._handleSaveNameButton(titleElement,nameField,editName,saveName,activeLabel));nameField.addEventListener('keydown',event=>{if(event.key==='Enter'){this._handleSaveNameButton(titleElement,nameField,editName,saveName,activeLabel);}});toolbar.appendToolbarItem(editName);toolbar.appendToolbarItem(saveName);this._createAuthenticatorFields(section,authenticatorId,options);}
_createAuthenticatorFields(section,authenticatorId,options){const sectionFields=section.createChild('div','authenticator-fields');const uuidField=sectionFields.createChild('div','authenticator-field');const protocolField=sectionFields.createChild('div','authenticator-field');const transportField=sectionFields.createChild('div','authenticator-field');const srkField=sectionFields.createChild('div','authenticator-field');const suvField=sectionFields.createChild('div','authenticator-field');uuidField.appendChild(UIUtils.createLabel(ls`UUID`,'authenticator-option-label'));protocolField.appendChild(UIUtils.createLabel(ls`Protocol`,'authenticator-option-label'));transportField.appendChild(UIUtils.createLabel(ls`Transport`,'authenticator-option-label'));srkField.appendChild(UIUtils.createLabel(ls`Supports resident keys`,'authenticator-option-label'));suvField.appendChild(UIUtils.createLabel(ls`Supports user verification`,'authenticator-option-label'));uuidField.createChild('div','authenticator-field-value').textContent=authenticatorId;protocolField.createChild('div','authenticator-field-value').textContent=options.protocol;transportField.createChild('div','authenticator-field-value').textContent=options.transport;srkField.createChild('div','authenticator-field-value').textContent=options.hasResidentKey?ls`Yes`:ls`No`;suvField.createChild('div','authenticator-field-value').textContent=options.hasUserVerification?ls`Yes`:ls`No`;}
_handleEditNameButton(titleElement,nameField,editName,saveName){nameField.removeAttribute('readonly');titleElement.classList.add('editing-name');nameField.focus();saveName.setVisible(true);editName.setVisible(false);}
_handleSaveNameButton(titleElement,nameField,editName,saveName,activeLabel){nameField.setAttribute('readonly','');titleElement.classList.remove('editing-name');editName.setVisible(true);saveName.setVisible(false);this._updateActiveLabelTitle(activeLabel,nameField.value);}
_updateActiveLabelTitle(activeLabel,authenticatorName){activeLabel.radioElement.title=ls`Set ${authenticatorName} as the active authenticator`;}
_removeAuthenticator(authenticatorId){this._authenticatorsView.querySelector(`[data-authenticator-id=${CSS.escape(authenticatorId)}]`).remove();this._model.removeAuthenticator(authenticatorId);if(this._activeAuthId===authenticatorId){this._activeAuthId=null;}}
_createOptionsFromCurrentInputs(){return{protocol:this._protocolSelect.options[this._protocolSelect.selectedIndex].value,transport:this._transportSelect.options[this._transportSelect.selectedIndex].value,hasResidentKey:this._residentKeyCheckbox.checked,hasUserVerification:this._userVerificationCheckbox.checked,automaticPresenceSimulation:true,isUserVerified:true,};}
async _setActiveAuthenticator(authenticatorId){await this._clearActiveAuthenticator();await this._model.setAutomaticPresenceSimulation(authenticatorId,true);this._activeAuthId=authenticatorId;this._updateActiveButtons();}
_updateActiveButtons(){const authenticators=this._authenticatorsView.getElementsByClassName('authenticator-section');Array.from(authenticators).forEach(authenticator=>{authenticator.querySelector('input.dt-radio-button').checked=authenticator.getAttribute('data-authenticator-id')===this._activeAuthId;});}
async _clearActiveAuthenticator(){if(this._activeAuthId){await this._model.setAutomaticPresenceSimulation(this._activeAuthId,false);}
this._activeAuthId=null;}}
var WebauthnPane=Object.freeze({__proto__:null,WebauthnPaneImpl:WebauthnPaneImpl});export{WebauthnPane};