import{Throttler}from'../common/common.js';import{FrameManager,OverlayModel,PageResourceLoader}from'../sdk/sdk.js';import{Widget,UIUtils,Toolbar}from'../ui/ui.js';import{DataGrid,SortableDataGrid}from'../data_grid/data_grid.js';import{ls as ls$1}from'../platform/platform.js';import{TextRange}from'../text_utils/text_utils.js';class DeveloperResourcesListView extends Widget.VBox{constructor(isVisibleFilter){super(true);this._nodeForItem=new Map();this._isVisibleFilter=isVisibleFilter;this._highlightRegExp=null;this.registerRequiredCSS('developer_resources/developerResourcesListView.css');const columns=[{id:'status',title:ls$1`Status`,width:'60px',fixedWidth:true,sortable:true},{id:'url',title:ls$1`URL`,width:'250px',fixedWidth:false,sortable:true},{id:'frame',title:ls$1`Frame`,width:'80px',fixedWidth:false,sortable:true},{id:'size',title:ls$1`Total Bytes`,width:'80px',fixedWidth:true,sortable:true,align:DataGrid.Align.Right},{id:'errorMessage',title:ls$1`Error`,width:'200px',fixedWidth:false,sortable:true,}];this._dataGrid=new SortableDataGrid.SortableDataGrid({displayName:ls$1`Developer Resources`,columns});this._dataGrid.setResizeMethod(DataGrid.ResizeMethod.Last);this._dataGrid.element.classList.add('flex-auto');this._dataGrid.addEventListener(DataGrid.Events.SortingChanged,this._sortingChanged,this);const dataGridWidget=this._dataGrid.asWidget();dataGridWidget.show(this.contentElement);this.setDefaultFocusedChild(dataGridWidget);}
update(items){let hadUpdates=false;const rootNode=this._dataGrid.rootNode();for(const item of items){let node=this._nodeForItem.get(item);if(node){if(this._isVisibleFilter(node.item)){hadUpdates=node._refreshIfNeeded()||hadUpdates;}
continue;}
node=new GridNode(item);this._nodeForItem.set(item,node);if(this._isVisibleFilter(node.item)){rootNode.appendChild(node);hadUpdates=true;}}
if(hadUpdates){this._sortingChanged();}}
reset(){this._nodeForItem.clear();this._dataGrid.rootNode().removeChildren();}
updateFilterAndHighlight(highlightRegExp){this._highlightRegExp=highlightRegExp;let hadTreeUpdates=false;for(const node of this._nodeForItem.values()){const shouldBeVisible=this._isVisibleFilter(node.item);const isVisible=!!node.parent;if(shouldBeVisible){node._setHighlight(this._highlightRegExp);}
if(shouldBeVisible===isVisible){continue;}
hadTreeUpdates=true;if(!shouldBeVisible){node.remove();}else{this._dataGrid.rootNode().appendChild(node);}}
if(hadTreeUpdates){this._sortingChanged();}}
_sortingChanged(){const columnId=this._dataGrid.sortColumnId();if(!columnId){return;}
const sortFunction=GridNode.sortFunctionForColumn(columnId);if(sortFunction){this._dataGrid.sortNodes(sortFunction,!this._dataGrid.isSortOrderAscending());}}}
class GridNode extends SortableDataGrid.SortableDataGridNode{constructor(item){super();this.item=item;this._highlightRegExp=null;}
_setHighlight(highlightRegExp){if(this._highlightRegExp===highlightRegExp){return;}
this._highlightRegExp=highlightRegExp;this.refresh();}
_refreshIfNeeded(){this.refresh();return true;}
createCell(columnId){const cell=(this.createTD(columnId));switch(columnId){case'url':{cell.title=this.item.url;const outer=cell.createChild('div','url-outer');const prefix=outer.createChild('div','url-prefix');const suffix=outer.createChild('div','url-suffix');const splitURL=/^(.*)(\/[^/]*)$/.exec(this.item.url);prefix.textContent=splitURL?splitURL[1]:this.item.url;suffix.textContent=splitURL?splitURL[2]:'';if(this._highlightRegExp){this._highlight(outer,this.item.url);}
this.setCellAccessibleName(this.item.url,cell,columnId);break;}
case'frame':{const frame=FrameManager.FrameManager.instance().getFrame(this.item.frameId);if(frame){cell.textContent=frame.displayName();}else{cell.textContent=this.item.frameId;}
cell.onmouseenter=()=>{const frame=FrameManager.FrameManager.instance().getFrame(this.item.frameId);if(frame){frame.highlight();}};cell.onmouseleave=()=>OverlayModel.OverlayModel.hideDOMNodeHighlight();break;}
case'status':{if(this.item.success===null){cell.textContent=ls$1`pending`;}else{cell.textContent=this.item.success?ls$1`success`:ls$1`failure`;}
break;}
case'size':{const size=this.item.size;if(size!==null){const sizeSpan=cell.createChild('span');sizeSpan.textContent=Number.withThousandsSeparator(size);const sizeAccessibleName=(size===1)?ls$1`1 byte`:ls$1`${size} bytes`;this.setCellAccessibleName(sizeAccessibleName,cell,columnId);}
break;}
case'errorMessage':{cell.classList.add('error-message');if(this.item.errorMessage){cell.textContent=this.item.errorMessage;if(this._highlightRegExp){this._highlight(cell,this.item.errorMessage);}}
break;}}
return cell;}
_highlight(element,textContent){if(!this._highlightRegExp){return;}
const matches=this._highlightRegExp.exec(textContent);if(!matches||!matches.length){return;}
const range=new TextRange.SourceRange(matches.index,matches[0].length);UIUtils.highlightRangesWithStyleClass(element,[range],'filter-highlight');}
static sortFunctionForColumn(columnId){const nullToNegative=x=>x===null?-1:Number(x);switch(columnId){case'url':return(a,b)=>a.item.url.localeCompare(b.item.url);case'status':return(a,b)=>{return nullToNegative(a.item.success)-nullToNegative(b.item.success);};case'size':return(a,b)=>nullToNegative(a.item.size)-nullToNegative(b.item.size);case'frame':return(a,b)=>a.item.frameId.localeCompare(b.item.frameId);case'errorMessage':return(a,b)=>(a.item.errorMessage||'').localeCompare(b.item.errorMessage||'');default:console.assert(false,'Unknown sort field: '+columnId);return null;}}}
class DeveloperResourcesView extends Widget.VBox{constructor(){super(true);this.registerRequiredCSS('developer_resources/developerResourcesView.css');const toolbarContainer=this.contentElement.createChild('div','developer-resource-view-toolbar-container');const toolbar=new Toolbar.Toolbar('developer-resource-view-toolbar',toolbarContainer);this._textFilterRegExp=null;const accessiblePlaceholder='';this._filterInput=new Toolbar.ToolbarInput(ls`Enter text to search the URL and Error columns`,accessiblePlaceholder,1);this._filterInput.addEventListener(Toolbar.ToolbarInput.Event.TextChanged,this._onFilterChanged,this);toolbar.appendToolbarItem(this._filterInput);this._coverageResultsElement=this.contentElement.createChild('div','developer-resource-view-results');this._listView=new DeveloperResourcesListView(this._isVisible.bind(this));this._listView.show(this._coverageResultsElement);this._statusToolbarElement=this.contentElement.createChild('div','developer-resource-view-toolbar-summary');this._statusMessageElement=this._statusToolbarElement.createChild('div','developer-resource-view-message');this._throttler=new Throttler.Throttler(100);this._loader=PageResourceLoader.PageResourceLoader.instance();this._loader.addEventListener(PageResourceLoader.Events.Update,this._onUpdate,this);this._onUpdate();}
_onUpdate(){this._throttler.schedule(this._update.bind(this));}
async _update(){this._listView.reset();this._listView.update(this._loader.getResourcesLoaded().values());this._updateStats();}
_updateStats(){const{loading,resources}=this._loader.getNumberOfResources();if(loading>0){this._statusMessageElement.textContent=`${resources} resources, ${loading} currently loading`;}else{this._statusMessageElement.textContent=`${resources} resources`;}}
_isVisible(item){return!this._textFilterRegExp||this._textFilterRegExp.test(item.url)||this._textFilterRegExp.test(item.errorMessage||'');}
_onFilterChanged(){if(!this._listView){return;}
const text=this._filterInput.value();this._textFilterRegExp=text?createPlainTextSearchRegex(text,'i'):null;this._listView.updateFilterAndHighlight(this._textFilterRegExp);this._updateStats();}}
var DeveloperResourcesView$1=Object.freeze({__proto__:null,DeveloperResourcesView:DeveloperResourcesView});export{DeveloperResourcesView$1 as DeveloperResourcesView};