import{SDKModel as t,TracingManager as e,TracingModel as i}from"../sdk/sdk.js";import{FileUtils as s,TempFile as a}from"../bindings/bindings.js";import{DateUtilities as n}from"../platform/platform.js";import{InspectorBackend as o}from"../protocol_client/protocol_client.js";import{TimelineLoader as l}from"../timeline/timeline.js";import{Widget as r,ActionRegistry as c,Toolbar as h,UIUtils as d,ViewManager as p}from"../ui/ui.js";class _ extends t.SDKModel{constructor(t){super(t),this._inputAgent=t.inputAgent(),this._eventDispatchTimer=null,this._dispatchEventDataList=[],this._finishCallback=null,this._reset()}_reset(){this._lastEventTime=null,this._replayPaused=!1,this._dispatchingIndex=0,clearTimeout(this._eventDispatchTimer)}setEvents(t){this._dispatchEventDataList=[];for(const e of t.sortedProcesses())for(const i of e.sortedThreads())this._processThreadEvents(t,i);this._dispatchEventDataList.sort((function(t,e){return t.timestamp-e.timestamp}))}startReplay(t){this._reset(),this._finishCallback=t,this._dispatchEventDataList.length?this._dispatchNextEvent():this._replayStopped()}pause(){clearTimeout(this._eventDispatchTimer),this._dispatchingIndex>=this._dispatchEventDataList.length?this._replayStopped():this._replayPaused=!0}resume(){this._replayPaused=!1,this._dispatchingIndex<this._dispatchEventDataList.length&&this._dispatchNextEvent()}_processThreadEvents(t,e){for(const t of e.events())"EventDispatch"===t.name&&this._isValidInputEvent(t.args.data)&&this._dispatchEventDataList.push(t.args.data)}_isValidInputEvent(t){return this._isMouseEvent(t)||this._isKeyboardEvent(t)}_isMouseEvent(t){return!!_.MouseEventTypes.has(t.type)&&("x"in t&&"y"in t)}_isKeyboardEvent(t){return!!_.KeyboardEventTypes.has(t.type)&&("code"in t&&"key"in t)}_dispatchNextEvent(){const t=this._dispatchEventDataList[this._dispatchingIndex];if(this._lastEventTime=t.timestamp,_.MouseEventTypes.has(t.type)?this._dispatchMouseEvent(t):_.KeyboardEventTypes.has(t.type)&&this._dispatchKeyEvent(t),++this._dispatchingIndex,this._dispatchingIndex<this._dispatchEventDataList.length){const t=(this._dispatchEventDataList[this._dispatchingIndex].timestamp-this._lastEventTime)/1e3;this._eventDispatchTimer=setTimeout(this._dispatchNextEvent.bind(this),t)}else this._replayStopped()}async _dispatchMouseEvent(t){console.assert(_.MouseEventTypes.has(t.type));const e={type:_.MouseEventTypes.get(t.type),x:t.x,y:t.y,modifiers:t.modifiers,button:"mousedown"===t.type||"mouseup"===t.type?{0:"left",1:"middle",2:"right",3:"back",4:"forward"}[t.button]:"none",buttons:t.buttons,clickCount:t.clickCount,deltaX:t.deltaX,deltaY:t.deltaY};await this._inputAgent.invoke_dispatchMouseEvent(e)}async _dispatchKeyEvent(t){console.assert(_.KeyboardEventTypes.has(t.type));const e="keypress"===t.type?t.key[0]:void 0,i={type:_.KeyboardEventTypes.get(t.type),modifiers:t.modifiers,text:e,unmodifiedText:e?e.toLowerCase():void 0,code:t.code,key:t.key};await this._inputAgent.invoke_dispatchKeyEvent(i)}_replayStopped(){clearTimeout(this._eventDispatchTimer),this._reset(),this._finishCallback()}}_.MouseEventTypes=new Map([["mousedown","mousePressed"],["mouseup","mouseReleased"],["mousemove","mouseMoved"],["wheel","mouseWheel"]]),_.KeyboardEventTypes=new Map([["keydown","keyDown"],["keyup","keyUp"],["keypress","char"]]),t.SDKModel.register(_,t.Capability.Input,!1);var g=Object.freeze({__proto__:null,InputModel:_,EventData:void 0,MouseEventData:void 0,KeyboardEventData:void 0});class u extends r.VBox{constructor(){super(!0),this.registerRequiredCSS("input/inputTimeline.css"),this.element.classList.add("inputs-timeline"),this._tracingClient=null,this._tracingModel=null,this._inputModel=null,this._state=m.Idle,this._toggleRecordAction=c.ActionRegistry.instance().action("input.toggle-recording"),this._startReplayAction=c.ActionRegistry.instance().action("input.start-replaying"),this._togglePauseAction=c.ActionRegistry.instance().action("input.toggle-pause");const t=this.contentElement.createChild("div","input-timeline-toolbar-container");this._panelToolbar=new h.Toolbar("input-timeline-toolbar",t),this._panelToolbar.appendToolbarItem(h.Toolbar.createActionButton(this._toggleRecordAction)),this._panelToolbar.appendToolbarItem(h.Toolbar.createActionButton(this._startReplayAction)),this._panelToolbar.appendToolbarItem(h.Toolbar.createActionButton(this._togglePauseAction)),this._clearButton=new h.ToolbarButton(ls`Clear all`,"largeicon-clear"),this._clearButton.addEventListener(h.ToolbarButton.Events.Click,this._reset.bind(this)),this._panelToolbar.appendToolbarItem(this._clearButton),this._panelToolbar.appendSeparator(),this._loadButton=new h.ToolbarButton(Common.UIString("Load profile…"),"largeicon-load"),this._loadButton.addEventListener(h.ToolbarButton.Events.Click,()=>this._selectFileToLoad()),this._saveButton=new h.ToolbarButton(Common.UIString("Save profile…"),"largeicon-download"),this._saveButton.addEventListener(h.ToolbarButton.Events.Click,t=>{this._saveToFile()}),this._panelToolbar.appendSeparator(),this._panelToolbar.appendToolbarItem(this._loadButton),this._panelToolbar.appendToolbarItem(this._saveButton),this._panelToolbar.appendSeparator(),this._createFileSelector(),this._updateControls()}_reset(){this._tracingClient=null,this._tracingModel=null,this._inputModel=null,this._setState(m.Idle)}_createFileSelector(){this._fileSelectorElement&&this._fileSelectorElement.remove(),this._fileSelectorElement=d.createFileSelectorElement(this._loadFromFile.bind(this)),this.element.appendChild(this._fileSelectorElement)}wasShown(){}willHide(){}_setState(t){this._state=t,this._updateControls()}_isAvailableState(){return this._state===m.Idle||this._state===m.ReplayPaused}_updateControls(){this._toggleRecordAction.setToggled(this._state===m.Recording),this._toggleRecordAction.setEnabled(this._isAvailableState()||this._state===m.Recording),this._startReplayAction.setEnabled(this._isAvailableState()&&!!this._tracingModel),this._togglePauseAction.setEnabled(this._state===m.Replaying||this._state===m.ReplayPaused),this._togglePauseAction.setToggled(this._state===m.ReplayPaused),this._clearButton.setEnabled(this._isAvailableState()),this._loadButton.setEnabled(this._isAvailableState()),this._saveButton.setEnabled(this._isAvailableState()&&!!this._tracingModel)}_toggleRecording(){switch(this._state){case m.Recording:this._stopRecording();break;case m.Idle:this._startRecording()}}_startReplay(){this._replayEvents()}_toggleReplayPause(){switch(this._state){case m.Replaying:this._pauseReplay();break;case m.ReplayPaused:this._resumeReplay()}}async _saveToFile(){console.assert(this._state===m.Idle&&this._tracingModel);const t=`InputProfile-${n.toISO8601Compact(new Date)}.json`,e=new s.FileOutputStream;if(!await e.open(t))return;const i=this._tracingModel.backingStorage();await i.writeToStream(e),e.close()}_selectFileToLoad(){this._fileSelectorElement.click()}_loadFromFile(t){console.assert(this._isAvailableState()),this._setState(m.Loading),this._loader=l.TimelineLoader.loadFromFile(t,this),this._createFileSelector()}async _startRecording(){this._setState(m.StartPending),this._tracingClient=new u.TracingClient(t.TargetManager.instance().mainTarget(),this);const e=await this._tracingClient.startRecording();e[o.ProtocolError]?this._recordingFailed(e[o.ProtocolError]):this._setState(m.Recording)}async _stopRecording(){this._setState(m.StopPending),await this._tracingClient.stopRecording(),this._tracingClient=null}async _replayEvents(){this._setState(m.Replaying),await this._inputModel.startReplay(this.replayStopped.bind(this))}_pauseReplay(){this._inputModel.pause(),this._setState(m.ReplayPaused)}_resumeReplay(){this._inputModel.resume(),this._setState(m.Replaying)}loadingStarted(){}loadingProgress(t){}processingStarted(){}loadingComplete(e){e?(this._inputModel=new _(t.TargetManager.instance().mainTarget()),this._tracingModel=e,this._inputModel.setEvents(e),this._setState(m.Idle)):this._reset()}_recordingFailed(t){this._tracingClient=null,this._setState(m.Idle)}replayStopped(){this._setState(m.Idle)}}const m={Idle:Symbol("Idle"),StartPending:Symbol("StartPending"),Recording:Symbol("Recording"),StopPending:Symbol("StopPending"),Replaying:Symbol("Replaying"),ReplayPaused:Symbol("ReplayPaused"),Loading:Symbol("Loading")};var y=Object.freeze({__proto__:null,InputTimeline:u,State:m,ActionDelegate:class{handleAction(t,e){return p.ViewManager.instance().showView("Inputs").then(()=>p.ViewManager.instance().view("Inputs").widget()).then(t=>this._innerHandleAction(t,e)),!0}_innerHandleAction(t,e){switch(e){case"input.toggle-recording":t._toggleRecording();break;case"input.start-replaying":t._startReplay();break;case"input.toggle-pause":t._toggleReplayPause();break;default:console.assert(!1,"Unknown action: "+e)}}},TracingClient:class{constructor(t,s){this._target=t,this._tracingManager=t.model(e.TracingManager),this._client=s;const n=new a.TempFileBackingStorage;this._tracingModel=new i.TracingModel(n),this._tracingCompleteCallback=null}async startRecording(){var t;const e=["devtools.timeline",(t="devtools.timeline.inputs","disabled-by-default-"+t)].join(","),i=await this._tracingManager.start(this,e,"");return i["Protocol.Error"]&&await this._waitForTracingToStop(!1),i}async stopRecording(){this._tracingManager&&this._tracingManager.stop(),await this._waitForTracingToStop(!0),await t.TargetManager.instance().resumeAllTargets(),this._tracingModel.tracingComplete(),this._client.loadingComplete(this._tracingModel)}traceEventsCollected(t){this._tracingModel.addEvents(t)}tracingComplete(){this._tracingCompleteCallback(),this._tracingCompleteCallback=null}tracingBufferUsage(t){}eventsRetrievalProgress(t){}_waitForTracingToStop(t){return new Promise(e=>{this._tracingManager&&t?this._tracingCompleteCallback=e:e()})}}});export{g as InputModel,y as InputTimeline};
