// @ts-nocheck - Prevent tsc stepping into any required bundles.
/*!
 * Lighthouse v6.4.0 ae69bd67915c59c78c3363eff7b393bac7e9bfee (September 30th 2020)
 * 
 * Automated auditing, performance metrics, and best practices for the web.
 * 
 * @homepage https://github.com/GoogleChrome/lighthouse#readme
 * @author   The Lighthouse Authors
 * @license  Apache-2.0
 */
globalThis.require=function r(e,t,n){function o(a,s){if(!t[a]){if(!e[a]){var l="function"==typeof require&&require;if(!s&&l)return l(a,!0);if(i)return i(a,!0);var c=new Error("Cannot find module '"+a+"'");throw c.code="MODULE_NOT_FOUND",c}var u=t[a]={exports:{}};e[a][0].call(u.exports,function(t){return o(e[a][1][t]||t)},u,u.exports,r,e,t,n)}return t[a].exports}for(var i="function"==typeof require&&require,a=0;a<n.length;a++)o(n[a]);return o}({"../audits/accessibility/accesskeys":[function(e,t,r){(function(r){"use strict";const n=e("./axe-audit.js"),i=e("../../lib/i18n/i18n.js"),a={title:"`[accesskey]` values are unique",failureTitle:"`[accesskey]` values are not unique",description:"Access keys let users quickly focus a part of the page. For proper navigation, each access key must be unique. [Learn more](https://web.dev/accesskeys/)."},s=i.createMessageInstanceIdFn(r,a);t.exports=class Accesskeys extends n{static get meta(){return{id:"accesskeys",title:s(a.title),failureTitle:s(a.failureTitle),
description:s(a.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=a}).call(this,"/lighthouse-core/audits/accessibility/accesskeys.js")},{"../../lib/i18n/i18n.js":78,"./axe-audit.js":2}],"../audits/accessibility/aria-allowed-attr":[function(e,t,r){(function(r){"use strict";const n=e("./axe-audit.js"),i=e("../../lib/i18n/i18n.js"),a={title:"`[aria-*]` attributes match their roles",failureTitle:"`[aria-*]` attributes do not match their roles",description:"Each ARIA `role` supports a specific subset of `aria-*` attributes. Mismatching these invalidates the `aria-*` attributes. [Learn more](https://web.dev/aria-allowed-attr/)."},s=i.createMessageInstanceIdFn(r,a);t.exports=class ARIAAllowedAttr extends n{static get meta(){return{id:"aria-allowed-attr",title:s(a.title),failureTitle:s(a.failureTitle),description:s(a.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=a}).call(this,"/lighthouse-core/audits/accessibility/aria-allowed-attr.js")},{
"../../lib/i18n/i18n.js":78,"./axe-audit.js":2}],"../audits/accessibility/aria-hidden-body":[function(e,t,r){(function(r){"use strict";const n=e("./axe-audit.js"),i=e("../../lib/i18n/i18n.js"),a={title:'`[aria-hidden="true"]` is not present on the document `<body>`',failureTitle:'`[aria-hidden="true"]` is present on the document `<body>`',description:'Assistive technologies, like screen readers, work inconsistently when `aria-hidden="true"` is set on the document `<body>`. [Learn more](https://web.dev/aria-hidden-body/).'},s=i.createMessageInstanceIdFn(r,a);t.exports=class AriaHiddenBody extends n{static get meta(){return{id:"aria-hidden-body",title:s(a.title),failureTitle:s(a.failureTitle),description:s(a.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=a}).call(this,"/lighthouse-core/audits/accessibility/aria-hidden-body.js")},{"../../lib/i18n/i18n.js":78,"./axe-audit.js":2}],"../audits/accessibility/aria-hidden-focus":[function(e,t,r){(function(r){"use strict"
;const n=e("./axe-audit.js"),i=e("../../lib/i18n/i18n.js"),a={title:'`[aria-hidden="true"]` elements do not contain focusable descendents',failureTitle:'`[aria-hidden="true"]` elements contain focusable descendents',description:'Focusable descendents within an `[aria-hidden="true"]` element prevent those interactive elements from being available to users of assistive technologies like screen readers. [Learn more](https://web.dev/aria-hidden-focus/).'},s=i.createMessageInstanceIdFn(r,a);t.exports=class AriaHiddenFocus extends n{static get meta(){return{id:"aria-hidden-focus",title:s(a.title),failureTitle:s(a.failureTitle),description:s(a.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=a}).call(this,"/lighthouse-core/audits/accessibility/aria-hidden-focus.js")},{"../../lib/i18n/i18n.js":78,"./axe-audit.js":2}],"../audits/accessibility/aria-input-field-name":[function(e,t,r){(function(r){"use strict";const n=e("./axe-audit.js"),i=e("../../lib/i18n/i18n.js"),a={
title:"ARIA input fields have accessible names",failureTitle:"ARIA input fields do not have accessible names",description:"When an input field doesn't have an accessible name, screen readers announce it with a generic name, making it unusable for users who rely on screen readers. [Learn more](https://web.dev/aria-input-field-name/)."},s=i.createMessageInstanceIdFn(r,a);t.exports=class AriaInputFieldName extends n{static get meta(){return{id:"aria-input-field-name",title:s(a.title),failureTitle:s(a.failureTitle),description:s(a.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=a}).call(this,"/lighthouse-core/audits/accessibility/aria-input-field-name.js")},{"../../lib/i18n/i18n.js":78,"./axe-audit.js":2}],"../audits/accessibility/aria-required-attr":[function(e,t,r){(function(r){"use strict";const n=e("./axe-audit.js"),i=e("../../lib/i18n/i18n.js"),a={title:"`[role]`s have all required `[aria-*]` attributes",
failureTitle:"`[role]`s do not have all required `[aria-*]` attributes",description:"Some ARIA roles have required attributes that describe the state of the element to screen readers. [Learn more](https://web.dev/aria-required-attr/)."},s=i.createMessageInstanceIdFn(r,a);t.exports=class ARIARequiredAttr extends n{static get meta(){return{id:"aria-required-attr",title:s(a.title),failureTitle:s(a.failureTitle),description:s(a.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=a}).call(this,"/lighthouse-core/audits/accessibility/aria-required-attr.js")},{"../../lib/i18n/i18n.js":78,"./axe-audit.js":2}],"../audits/accessibility/aria-required-children":[function(e,t,r){(function(r){"use strict";const n=e("./axe-audit.js"),i=e("../../lib/i18n/i18n.js"),a={title:"Elements with an ARIA `[role]` that require children to contain a specific `[role]` have all required children.",
failureTitle:"Elements with an ARIA `[role]` that require children to contain a specific `[role]` are missing some or all of those required children.",description:"Some ARIA parent roles must contain specific child roles to perform their intended accessibility functions. [Learn more](https://web.dev/aria-required-children/)."},s=i.createMessageInstanceIdFn(r,a);t.exports=class AriaRequiredChildren extends n{static get meta(){return{id:"aria-required-children",title:s(a.title),failureTitle:s(a.failureTitle),description:s(a.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=a}).call(this,"/lighthouse-core/audits/accessibility/aria-required-children.js")},{"../../lib/i18n/i18n.js":78,"./axe-audit.js":2}],"../audits/accessibility/aria-required-parent":[function(e,t,r){(function(r){"use strict";const n=e("./axe-audit.js"),i=e("../../lib/i18n/i18n.js"),a={title:"`[role]`s are contained by their required parent element",
failureTitle:"`[role]`s are not contained by their required parent element",description:"Some ARIA child roles must be contained by specific parent roles to properly perform their intended accessibility functions. [Learn more](https://web.dev/aria-required-parent/)."},s=i.createMessageInstanceIdFn(r,a);t.exports=class AriaRequiredParent extends n{static get meta(){return{id:"aria-required-parent",title:s(a.title),failureTitle:s(a.failureTitle),description:s(a.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=a}).call(this,"/lighthouse-core/audits/accessibility/aria-required-parent.js")},{"../../lib/i18n/i18n.js":78,"./axe-audit.js":2}],"../audits/accessibility/aria-roles":[function(e,t,r){(function(r){"use strict";const n=e("./axe-audit.js"),i=e("../../lib/i18n/i18n.js"),a={title:"`[role]` values are valid",failureTitle:"`[role]` values are not valid",
description:"ARIA roles must have valid values in order to perform their intended accessibility functions. [Learn more](https://web.dev/aria-roles/)."},s=i.createMessageInstanceIdFn(r,a);t.exports=class AriaRoles extends n{static get meta(){return{id:"aria-roles",title:s(a.title),failureTitle:s(a.failureTitle),description:s(a.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=a}).call(this,"/lighthouse-core/audits/accessibility/aria-roles.js")},{"../../lib/i18n/i18n.js":78,"./axe-audit.js":2}],"../audits/accessibility/aria-toggle-field-name":[function(e,t,r){(function(r){"use strict";const n=e("./axe-audit.js"),i=e("../../lib/i18n/i18n.js"),a={title:"ARIA toggle fields have accessible names",failureTitle:"ARIA toggle fields do not have accessible names",
description:"When a toggle field doesn't have an accessible name, screen readers announce it with a generic name, making it unusable for users who rely on screen readers. [Learn more](https://web.dev/aria-toggle-field-name/)."},s=i.createMessageInstanceIdFn(r,a);t.exports=class AriaToggleFieldName extends n{static get meta(){return{id:"aria-toggle-field-name",title:s(a.title),failureTitle:s(a.failureTitle),description:s(a.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=a}).call(this,"/lighthouse-core/audits/accessibility/aria-toggle-field-name.js")},{"../../lib/i18n/i18n.js":78,"./axe-audit.js":2}],"../audits/accessibility/aria-valid-attr-value":[function(e,t,r){(function(r){"use strict";const n=e("./axe-audit.js"),i=e("../../lib/i18n/i18n.js"),a={title:"`[aria-*]` attributes have valid values",failureTitle:"`[aria-*]` attributes do not have valid values",
description:"Assistive technologies, like screen readers, can't interpret ARIA attributes with invalid values. [Learn more](https://web.dev/aria-valid-attr-value/)."},s=i.createMessageInstanceIdFn(r,a);t.exports=class ARIAValidAttr extends n{static get meta(){return{id:"aria-valid-attr-value",title:s(a.title),failureTitle:s(a.failureTitle),description:s(a.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=a}).call(this,"/lighthouse-core/audits/accessibility/aria-valid-attr-value.js")},{"../../lib/i18n/i18n.js":78,"./axe-audit.js":2}],"../audits/accessibility/aria-valid-attr":[function(e,t,r){(function(r){"use strict";const n=e("./axe-audit.js"),i=e("../../lib/i18n/i18n.js"),a={title:"`[aria-*]` attributes are valid and not misspelled",failureTitle:"`[aria-*]` attributes are not valid or misspelled",description:"Assistive technologies, like screen readers, can't interpret ARIA attributes with invalid names. [Learn more](https://web.dev/aria-valid-attr/)."
},s=i.createMessageInstanceIdFn(r,a);t.exports=class ARIAValidAttr extends n{static get meta(){return{id:"aria-valid-attr",title:s(a.title),failureTitle:s(a.failureTitle),description:s(a.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=a}).call(this,"/lighthouse-core/audits/accessibility/aria-valid-attr.js")},{"../../lib/i18n/i18n.js":78,"./axe-audit.js":2}],"../audits/accessibility/button-name":[function(e,t,r){(function(r){"use strict";const n=e("./axe-audit.js"),i=e("../../lib/i18n/i18n.js"),a={title:"Buttons have an accessible name",failureTitle:"Buttons do not have an accessible name",description:'When a button doesn\'t have an accessible name, screen readers announce it as "button", making it unusable for users who rely on screen readers. [Learn more](https://web.dev/button-name/).'},s=i.createMessageInstanceIdFn(r,a);t.exports=class ButtonName extends n{static get meta(){return{id:"button-name",title:s(a.title),failureTitle:s(a.failureTitle),
description:s(a.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=a}).call(this,"/lighthouse-core/audits/accessibility/button-name.js")},{"../../lib/i18n/i18n.js":78,"./axe-audit.js":2}],"../audits/accessibility/bypass":[function(e,t,r){(function(r){"use strict";const n=e("./axe-audit.js"),i=e("../../lib/i18n/i18n.js"),a={title:"The page contains a heading, skip link, or landmark region",failureTitle:"The page does not contain a heading, skip link, or landmark region",description:"Adding ways to bypass repetitive content lets keyboard users navigate the page more efficiently. [Learn more](https://web.dev/bypass/)."},s=i.createMessageInstanceIdFn(r,a);t.exports=class Bypass extends n{static get meta(){return{id:"bypass",title:s(a.title),failureTitle:s(a.failureTitle),description:s(a.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=a}).call(this,"/lighthouse-core/audits/accessibility/bypass.js")},{"../../lib/i18n/i18n.js":78,"./axe-audit.js":2
}],"../audits/accessibility/color-contrast":[function(e,t,r){(function(r){"use strict";const n=e("./axe-audit.js"),i=e("../../lib/i18n/i18n.js"),a={title:"Background and foreground colors have a sufficient contrast ratio",failureTitle:"Background and foreground colors do not have a sufficient contrast ratio.",description:"Low-contrast text is difficult or impossible for many users to read. [Learn more](https://web.dev/color-contrast/)."},s=i.createMessageInstanceIdFn(r,a);t.exports=class ColorContrast extends n{static get meta(){return{id:"color-contrast",title:s(a.title),failureTitle:s(a.failureTitle),description:s(a.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=a}).call(this,"/lighthouse-core/audits/accessibility/color-contrast.js")},{"../../lib/i18n/i18n.js":78,"./axe-audit.js":2}],"../audits/accessibility/definition-list":[function(e,t,r){(function(r){"use strict";const n=e("./axe-audit.js"),i=e("../../lib/i18n/i18n.js"),a={
title:"`<dl>`'s contain only properly-ordered `<dt>` and `<dd>` groups, `<script>`, `<template>` or `<div>` elements.",failureTitle:"`<dl>`'s do not contain only properly-ordered `<dt>` and `<dd>` groups, `<script>`, `<template>` or `<div>` elements.",description:"When definition lists are not properly marked up, screen readers may produce confusing or inaccurate output. [Learn more](https://web.dev/definition-list/)."},s=i.createMessageInstanceIdFn(r,a);t.exports=class DefinitionList extends n{static get meta(){return{id:"definition-list",title:s(a.title),failureTitle:s(a.failureTitle),description:s(a.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=a}).call(this,"/lighthouse-core/audits/accessibility/definition-list.js")},{"../../lib/i18n/i18n.js":78,"./axe-audit.js":2}],"../audits/accessibility/dlitem":[function(e,t,r){(function(r){"use strict";const n=e("./axe-audit.js"),i=e("../../lib/i18n/i18n.js"),a={
title:"Definition list items are wrapped in `<dl>` elements",failureTitle:"Definition list items are not wrapped in `<dl>` elements",description:"Definition list items (`<dt>` and `<dd>`) must be wrapped in a parent `<dl>` element to ensure that screen readers can properly announce them. [Learn more](https://web.dev/dlitem/)."},s=i.createMessageInstanceIdFn(r,a);t.exports=class DLItem extends n{static get meta(){return{id:"dlitem",title:s(a.title),failureTitle:s(a.failureTitle),description:s(a.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=a}).call(this,"/lighthouse-core/audits/accessibility/dlitem.js")},{"../../lib/i18n/i18n.js":78,"./axe-audit.js":2}],"../audits/accessibility/document-title":[function(e,t,r){(function(r){"use strict";const n=e("./axe-audit.js"),i=e("../../lib/i18n/i18n.js"),a={title:"Document has a `<title>` element",failureTitle:"Document doesn't have a `<title>` element",
description:"The title gives screen reader users an overview of the page, and search engine users rely on it heavily to determine if a page is relevant to their search. [Learn more](https://web.dev/document-title/)."},s=i.createMessageInstanceIdFn(r,a);t.exports=class DocumentTitle extends n{static get meta(){return{id:"document-title",title:s(a.title),failureTitle:s(a.failureTitle),description:s(a.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=a}).call(this,"/lighthouse-core/audits/accessibility/document-title.js")},{"../../lib/i18n/i18n.js":78,"./axe-audit.js":2}],"../audits/accessibility/duplicate-id-active":[function(e,t,r){(function(r){"use strict";const n=e("./axe-audit.js"),i=e("../../lib/i18n/i18n.js"),a={title:"`[id]` attributes on active, focusable elements are unique",failureTitle:"`[id]` attributes on active, focusable elements are not unique",
description:"All focusable elements must have a unique `id` to ensure that they're visible to assistive technologies. [Learn more](https://web.dev/duplicate-id-active/)."},s=i.createMessageInstanceIdFn(r,a);t.exports=class DuplicateIdActive extends n{static get meta(){return{id:"duplicate-id-active",title:s(a.title),failureTitle:s(a.failureTitle),description:s(a.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=a}).call(this,"/lighthouse-core/audits/accessibility/duplicate-id-active.js")},{"../../lib/i18n/i18n.js":78,"./axe-audit.js":2}],"../audits/accessibility/duplicate-id-aria":[function(e,t,r){(function(r){"use strict";const n=e("./axe-audit.js"),i=e("../../lib/i18n/i18n.js"),a={title:"ARIA IDs are unique",failureTitle:"ARIA IDs are not unique",description:"The value of an ARIA ID must be unique to prevent other instances from being overlooked by assistive technologies. [Learn more](https://web.dev/duplicate-id-aria/)."},s=i.createMessageInstanceIdFn(r,a)
;t.exports=class DuplicateIdAria extends n{static get meta(){return{id:"duplicate-id-aria",title:s(a.title),failureTitle:s(a.failureTitle),description:s(a.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=a}).call(this,"/lighthouse-core/audits/accessibility/duplicate-id-aria.js")},{"../../lib/i18n/i18n.js":78,"./axe-audit.js":2}],"../audits/accessibility/form-field-multiple-labels":[function(e,t,r){(function(r){"use strict";const n=e("./axe-audit.js"),i=e("../../lib/i18n/i18n.js"),a={title:"No form fields have multiple labels",failureTitle:"Form fields have multiple labels",description:"Form fields with multiple labels can be confusingly announced by assistive technologies like screen readers which use either the first, the last, or all of the labels. [Learn more](https://web.dev/form-field-multiple-labels/)."},s=i.createMessageInstanceIdFn(r,a);t.exports=class FormFieldMultipleLabels extends n{static get meta(){return{id:"form-field-multiple-labels",
title:s(a.title),failureTitle:s(a.failureTitle),description:s(a.description),scoreDisplayMode:n.SCORING_MODES.INFORMATIVE,requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=a}).call(this,"/lighthouse-core/audits/accessibility/form-field-multiple-labels.js")},{"../../lib/i18n/i18n.js":78,"./axe-audit.js":2}],"../audits/accessibility/frame-title":[function(e,t,r){(function(r){"use strict";const n=e("./axe-audit.js"),i=e("../../lib/i18n/i18n.js"),a={title:"`<frame>` or `<iframe>` elements have a title",failureTitle:"`<frame>` or `<iframe>` elements do not have a title",description:"Screen reader users rely on frame titles to describe the contents of frames. [Learn more](https://web.dev/frame-title/)."},s=i.createMessageInstanceIdFn(r,a);t.exports=class FrameTitle extends n{static get meta(){return{id:"frame-title",title:s(a.title),failureTitle:s(a.failureTitle),description:s(a.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=a
}).call(this,"/lighthouse-core/audits/accessibility/frame-title.js")},{"../../lib/i18n/i18n.js":78,"./axe-audit.js":2}],"../audits/accessibility/heading-order":[function(e,t,r){(function(r){"use strict";const n=e("./axe-audit.js"),i=e("../../lib/i18n/i18n.js"),a={title:"Heading elements appear in a sequentially-descending order",failureTitle:"Heading elements are not in a sequentially-descending order",description:"Properly ordered headings that do not skip levels convey the semantic structure of the page, making it easier to navigate and understand when using assistive technologies. [Learn more](https://web.dev/heading-order/)."},s=i.createMessageInstanceIdFn(r,a);t.exports=class HeadingOrder extends n{static get meta(){return{id:"heading-order",title:s(a.title),failureTitle:s(a.failureTitle),description:s(a.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=a}).call(this,"/lighthouse-core/audits/accessibility/heading-order.js")},{"../../lib/i18n/i18n.js":78,
"./axe-audit.js":2}],"../audits/accessibility/html-has-lang":[function(e,t,r){(function(r){"use strict";const n=e("./axe-audit.js"),i=e("../../lib/i18n/i18n.js"),a={title:"`<html>` element has a `[lang]` attribute",failureTitle:"`<html>` element does not have a `[lang]` attribute",description:"If a page doesn't specify a lang attribute, a screen reader assumes that the page is in the default language that the user chose when setting up the screen reader. If the page isn't actually in the default language, then the screen reader might not announce the page's text correctly. [Learn more](https://web.dev/html-has-lang/)."},s=i.createMessageInstanceIdFn(r,a);t.exports=class HTMLHasLang extends n{static get meta(){return{id:"html-has-lang",title:s(a.title),failureTitle:s(a.failureTitle),description:s(a.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=a}).call(this,"/lighthouse-core/audits/accessibility/html-has-lang.js")},{"../../lib/i18n/i18n.js":78,
"./axe-audit.js":2}],"../audits/accessibility/html-lang-valid":[function(e,t,r){(function(r){"use strict";const n=e("./axe-audit.js"),i=e("../../lib/i18n/i18n.js"),a={title:"`<html>` element has a valid value for its `[lang]` attribute",failureTitle:"`<html>` element does not have a valid value for its `[lang]` attribute.",description:"Specifying a valid [BCP 47 language](https://www.w3.org/International/questions/qa-choosing-language-tags#question) helps screen readers announce text properly. [Learn more](https://web.dev/html-lang-valid/)."},s=i.createMessageInstanceIdFn(r,a);t.exports=class HTMLLangValid extends n{static get meta(){return{id:"html-lang-valid",title:s(a.title),failureTitle:s(a.failureTitle),description:s(a.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=a}).call(this,"/lighthouse-core/audits/accessibility/html-lang-valid.js")},{"../../lib/i18n/i18n.js":78,"./axe-audit.js":2}],"../audits/accessibility/image-alt":[function(e,t,r){(function(r){
"use strict";const n=e("./axe-audit.js"),i=e("../../lib/i18n/i18n.js"),a={title:"Image elements have `[alt]` attributes",failureTitle:"Image elements do not have `[alt]` attributes",description:"Informative elements should aim for short, descriptive alternate text. Decorative elements can be ignored with an empty alt attribute. [Learn more](https://web.dev/image-alt/)."},s=i.createMessageInstanceIdFn(r,a);t.exports=class ImageAlt extends n{static get meta(){return{id:"image-alt",title:s(a.title),failureTitle:s(a.failureTitle),description:s(a.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=a}).call(this,"/lighthouse-core/audits/accessibility/image-alt.js")},{"../../lib/i18n/i18n.js":78,"./axe-audit.js":2}],"../audits/accessibility/input-image-alt":[function(e,t,r){(function(r){"use strict";const n=e("./axe-audit.js"),i=e("../../lib/i18n/i18n.js"),a={title:'`<input type="image">` elements have `[alt]` text',
failureTitle:'`<input type="image">` elements do not have `[alt]` text',description:"When an image is being used as an `<input>` button, providing alternative text can help screen reader users understand the purpose of the button. [Learn more](https://web.dev/input-image-alt/)."},s=i.createMessageInstanceIdFn(r,a);t.exports=class InputImageAlt extends n{static get meta(){return{id:"input-image-alt",title:s(a.title),failureTitle:s(a.failureTitle),description:s(a.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=a}).call(this,"/lighthouse-core/audits/accessibility/input-image-alt.js")},{"../../lib/i18n/i18n.js":78,"./axe-audit.js":2}],"../audits/accessibility/label":[function(e,t,r){(function(r){"use strict";const n=e("./axe-audit.js"),i=e("../../lib/i18n/i18n.js"),a={title:"Form elements have associated labels",failureTitle:"Form elements do not have associated labels",
description:"Labels ensure that form controls are announced properly by assistive technologies, like screen readers. [Learn more](https://web.dev/label/)."},s=i.createMessageInstanceIdFn(r,a);t.exports=class Label extends n{static get meta(){return{id:"label",title:s(a.title),failureTitle:s(a.failureTitle),description:s(a.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=a}).call(this,"/lighthouse-core/audits/accessibility/label.js")},{"../../lib/i18n/i18n.js":78,"./axe-audit.js":2}],"../audits/accessibility/layout-table":[function(e,t,r){(function(r){"use strict";const n=e("./axe-audit.js"),i=e("../../lib/i18n/i18n.js"),a={title:"Presentational `<table>` elements avoid using `<th>`, `<caption>` or the `[summary]` attribute.",failureTitle:"Presentational `<table>` elements do not avoid using `<th>`, `<caption>` or the `[summary]` attribute.",
description:"A table being used for layout purposes should not include data elements, such as the th or caption elements or the summary attribute, because this can create a confusing experience for screen reader users. [Learn more](https://web.dev/layout-table/)."},s=i.createMessageInstanceIdFn(r,a);t.exports=class LayoutTable extends n{static get meta(){return{id:"layout-table",title:s(a.title),failureTitle:s(a.failureTitle),description:s(a.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=a}).call(this,"/lighthouse-core/audits/accessibility/layout-table.js")},{"../../lib/i18n/i18n.js":78,"./axe-audit.js":2}],"../audits/accessibility/link-name":[function(e,t,r){(function(r){"use strict";const n=e("./axe-audit.js"),i=e("../../lib/i18n/i18n.js"),a={title:"Links have a discernible name",failureTitle:"Links do not have a discernible name",
description:"Link text (and alternate text for images, when used as links) that is discernible, unique, and focusable improves the navigation experience for screen reader users. [Learn more](https://web.dev/link-name/)."},s=i.createMessageInstanceIdFn(r,a);t.exports=class LinkName extends n{static get meta(){return{id:"link-name",title:s(a.title),failureTitle:s(a.failureTitle),description:s(a.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=a}).call(this,"/lighthouse-core/audits/accessibility/link-name.js")},{"../../lib/i18n/i18n.js":78,"./axe-audit.js":2}],"../audits/accessibility/listitem":[function(e,t,r){(function(r){"use strict";const n=e("./axe-audit.js"),i=e("../../lib/i18n/i18n.js"),a={title:"List items (`<li>`) are contained within `<ul>` or `<ol>` parent elements",failureTitle:"List items (`<li>`) are not contained within `<ul>` or `<ol>` parent elements.",
description:"Screen readers require list items (`<li>`) to be contained within a parent `<ul>` or `<ol>` to be announced properly. [Learn more](https://web.dev/listitem/)."},s=i.createMessageInstanceIdFn(r,a);t.exports=class ListItem extends n{static get meta(){return{id:"listitem",title:s(a.title),failureTitle:s(a.failureTitle),description:s(a.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=a}).call(this,"/lighthouse-core/audits/accessibility/listitem.js")},{"../../lib/i18n/i18n.js":78,"./axe-audit.js":2}],"../audits/accessibility/list":[function(e,t,r){(function(r){"use strict";const n=e("./axe-audit.js"),i=e("../../lib/i18n/i18n.js"),a={title:"Lists contain only `<li>` elements and script supporting elements (`<script>` and `<template>`).",failureTitle:"Lists do not contain only `<li>` elements and script supporting elements (`<script>` and `<template>`).",
description:"Screen readers have a specific way of announcing lists. Ensuring proper list structure aids screen reader output. [Learn more](https://web.dev/list/)."},s=i.createMessageInstanceIdFn(r,a);t.exports=class List extends n{static get meta(){return{id:"list",title:s(a.title),failureTitle:s(a.failureTitle),description:s(a.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=a}).call(this,"/lighthouse-core/audits/accessibility/list.js")},{"../../lib/i18n/i18n.js":78,"./axe-audit.js":2}],"../audits/accessibility/manual/custom-controls-labels":[function(e,t,r){"use strict";const n=e("../../manual/manual-audit.js");t.exports=class CustomControlsLabels extends n{static get meta(){return Object.assign({id:"custom-controls-labels",description:"Custom interactive controls have associated labels, provided by aria-label or aria-labelledby. [Learn more](https://web.dev/custom-controls-labels/).",title:"Custom controls have associated labels"},super.partialMeta)}}},{
"../../manual/manual-audit.js":6}],"../audits/accessibility/manual/custom-controls-roles":[function(e,t,r){"use strict";const n=e("../../manual/manual-audit.js");t.exports=class CustomControlsRoles extends n{static get meta(){return Object.assign({id:"custom-controls-roles",description:"Custom interactive controls have appropriate ARIA roles. [Learn more](https://web.dev/custom-control-roles/).",title:"Custom controls have ARIA roles"},super.partialMeta)}}},{"../../manual/manual-audit.js":6}],"../audits/accessibility/manual/focus-traps":[function(e,t,r){"use strict";const n=e("../../manual/manual-audit.js");t.exports=class FocusTraps extends n{static get meta(){return Object.assign({id:"focus-traps",description:"A user can tab into and out of any control or region without accidentally trapping their focus. [Learn more](https://web.dev/focus-traps/).",title:"User focus is not accidentally trapped in a region"},super.partialMeta)}}},{"../../manual/manual-audit.js":6}],
"../audits/accessibility/manual/focusable-controls":[function(e,t,r){"use strict";const n=e("../../manual/manual-audit.js");t.exports=class FocusableControls extends n{static get meta(){return Object.assign({id:"focusable-controls",description:"Custom interactive controls are keyboard focusable and display a focus indicator. [Learn more](https://web.dev/focusable-controls/).",title:"Interactive controls are keyboard focusable"},super.partialMeta)}}},{"../../manual/manual-audit.js":6}],"../audits/accessibility/manual/interactive-element-affordance":[function(e,t,r){"use strict";const n=e("../../manual/manual-audit.js");t.exports=class InteractiveElementAffordance extends n{static get meta(){return Object.assign({id:"interactive-element-affordance",description:"Interactive elements, such as links and buttons, should indicate their state and be distinguishable from non-interactive elements. [Learn more](https://web.dev/interactive-element-affordance/).",
title:"Interactive elements indicate their purpose and state"},super.partialMeta)}}},{"../../manual/manual-audit.js":6}],"../audits/accessibility/manual/logical-tab-order":[function(e,t,r){"use strict";const n=e("../../manual/manual-audit.js");t.exports=class LogicalTabOrder extends n{static get meta(){return Object.assign({id:"logical-tab-order",description:"Tabbing through the page follows the visual layout. Users cannot focus elements that are offscreen. [Learn more](https://web.dev/logical-tab-order/).",title:"The page has a logical tab order"},super.partialMeta)}}},{"../../manual/manual-audit.js":6}],"../audits/accessibility/manual/managed-focus":[function(e,t,r){"use strict";const n=e("../../manual/manual-audit.js");t.exports=class ManagedFocus extends n{static get meta(){return Object.assign({id:"managed-focus",description:"If new content, such as a dialog, is added to the page, the user's focus is directed to it. [Learn more](https://web.dev/managed-focus/).",
title:"The user's focus is directed to new content added to the page"},super.partialMeta)}}},{"../../manual/manual-audit.js":6}],"../audits/accessibility/manual/offscreen-content-hidden":[function(e,t,r){"use strict";const n=e("../../manual/manual-audit.js");t.exports=class OffscreenContentHidden extends n{static get meta(){return Object.assign({id:"offscreen-content-hidden",description:"Offscreen content is hidden with display: none or aria-hidden=true. [Learn more](https://web.dev/offscreen-content-hidden/).",title:"Offscreen content is hidden from assistive technology"},super.partialMeta)}}},{"../../manual/manual-audit.js":6}],"../audits/accessibility/manual/use-landmarks":[function(e,t,r){"use strict";const n=e("../../manual/manual-audit.js");t.exports=class UseLandmarks extends n{static get meta(){return Object.assign({id:"use-landmarks",
description:"Landmark elements (<main>, <nav>, etc.) are used to improve the keyboard navigation of the page for assistive technology. [Learn more](https://web.dev/use-landmarks/).",title:"HTML5 landmark elements are used to improve navigation"},super.partialMeta)}}},{"../../manual/manual-audit.js":6}],"../audits/accessibility/manual/visual-order-follows-dom":[function(e,t,r){"use strict";const n=e("../../manual/manual-audit.js");t.exports=class VisualOrderFollowsDOM extends n{static get meta(){return Object.assign({id:"visual-order-follows-dom",description:"DOM order matches the visual order, improving navigation for assistive technology. [Learn more](https://web.dev/visual-order-follows-dom/).",title:"Visual order on the page follows DOM order"},super.partialMeta)}}},{"../../manual/manual-audit.js":6}],"../audits/accessibility/meta-refresh":[function(e,t,r){(function(r){"use strict";const n=e("./axe-audit.js"),i=e("../../lib/i18n/i18n.js"),a={
title:'The document does not use `<meta http-equiv="refresh">`',failureTitle:'The document uses `<meta http-equiv="refresh">`',description:"Users do not expect a page to refresh automatically, and doing so will move focus back to the top of the page. This may create a frustrating or confusing experience. [Learn more](https://web.dev/meta-refresh/)."},s=i.createMessageInstanceIdFn(r,a);t.exports=class MetaRefresh extends n{static get meta(){return{id:"meta-refresh",title:s(a.title),failureTitle:s(a.failureTitle),description:s(a.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=a}).call(this,"/lighthouse-core/audits/accessibility/meta-refresh.js")},{"../../lib/i18n/i18n.js":78,"./axe-audit.js":2}],"../audits/accessibility/meta-viewport":[function(e,t,r){(function(r){"use strict";const n=e("./axe-audit.js"),i=e("../../lib/i18n/i18n.js"),a={
title:'`[user-scalable="no"]` is not used in the `<meta name="viewport">` element and the `[maximum-scale]` attribute is not less than 5.',failureTitle:'`[user-scalable="no"]` is used in the `<meta name="viewport">` element or the `[maximum-scale]` attribute is less than 5.',description:"Disabling zooming is problematic for users with low vision who rely on screen magnification to properly see the contents of a web page. [Learn more](https://web.dev/meta-viewport/)."},s=i.createMessageInstanceIdFn(r,a);t.exports=class MetaViewport extends n{static get meta(){return{id:"meta-viewport",title:s(a.title),failureTitle:s(a.failureTitle),description:s(a.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=a}).call(this,"/lighthouse-core/audits/accessibility/meta-viewport.js")},{"../../lib/i18n/i18n.js":78,"./axe-audit.js":2}],"../audits/accessibility/object-alt":[function(e,t,r){(function(r){"use strict";const n=e("./axe-audit.js"),i=e("../../lib/i18n/i18n.js"),a={
title:"`<object>` elements have `[alt]` text",failureTitle:"`<object>` elements do not have `[alt]` text",description:"Screen readers cannot translate non-text content. Adding alt text to `<object>` elements helps screen readers convey meaning to users. [Learn more](https://web.dev/object-alt/)."},s=i.createMessageInstanceIdFn(r,a);t.exports=class ObjectAlt extends n{static get meta(){return{id:"object-alt",title:s(a.title),failureTitle:s(a.failureTitle),description:s(a.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=a}).call(this,"/lighthouse-core/audits/accessibility/object-alt.js")},{"../../lib/i18n/i18n.js":78,"./axe-audit.js":2}],"../audits/accessibility/tabindex":[function(e,t,r){(function(r){"use strict";const n=e("./axe-audit.js"),i=e("../../lib/i18n/i18n.js"),a={title:"No element has a `[tabindex]` value greater than 0",failureTitle:"Some elements have a `[tabindex]` value greater than 0",
description:"A value greater than 0 implies an explicit navigation ordering. Although technically valid, this often creates frustrating experiences for users who rely on assistive technologies. [Learn more](https://web.dev/tabindex/)."},s=i.createMessageInstanceIdFn(r,a);t.exports=class TabIndex extends n{static get meta(){return{id:"tabindex",title:s(a.title),failureTitle:s(a.failureTitle),description:s(a.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=a}).call(this,"/lighthouse-core/audits/accessibility/tabindex.js")},{"../../lib/i18n/i18n.js":78,"./axe-audit.js":2}],"../audits/accessibility/td-headers-attr":[function(e,t,r){(function(r){"use strict";const n=e("./axe-audit.js"),i=e("../../lib/i18n/i18n.js"),a={title:"Cells in a `<table>` element that use the `[headers]` attribute refer to table cells within the same table.",failureTitle:"Cells in a `<table>` element that use the `[headers]` attribute refer to an element `id` not found within the same table.",
description:"Screen readers have features to make navigating tables easier. Ensuring `<td>` cells using the `[headers]` attribute only refer to other cells in the same table may improve the experience for screen reader users. [Learn more](https://web.dev/td-headers-attr/)."},s=i.createMessageInstanceIdFn(r,a);t.exports=class TDHeadersAttr extends n{static get meta(){return{id:"td-headers-attr",title:s(a.title),failureTitle:s(a.failureTitle),description:s(a.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=a}).call(this,"/lighthouse-core/audits/accessibility/td-headers-attr.js")},{"../../lib/i18n/i18n.js":78,"./axe-audit.js":2}],"../audits/accessibility/th-has-data-cells":[function(e,t,r){(function(r){"use strict";const n=e("./axe-audit.js"),i=e("../../lib/i18n/i18n.js"),a={title:'`<th>` elements and elements with `[role="columnheader"/"rowheader"]` have data cells they describe.',
failureTitle:'`<th>` elements and elements with `[role="columnheader"/"rowheader"]` do not have data cells they describe.',description:"Screen readers have features to make navigating tables easier. Ensuring table headers always refer to some set of cells may improve the experience for screen reader users. [Learn more](https://web.dev/th-has-data-cells/)."},s=i.createMessageInstanceIdFn(r,a);t.exports=class THHasDataCells extends n{static get meta(){return{id:"th-has-data-cells",title:s(a.title),failureTitle:s(a.failureTitle),description:s(a.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=a}).call(this,"/lighthouse-core/audits/accessibility/th-has-data-cells.js")},{"../../lib/i18n/i18n.js":78,"./axe-audit.js":2}],"../audits/accessibility/valid-lang":[function(e,t,r){(function(r){"use strict";const n=e("./axe-audit.js"),i=e("../../lib/i18n/i18n.js"),a={title:"`[lang]` attributes have a valid value",failureTitle:"`[lang]` attributes do not have a valid value",
description:"Specifying a valid [BCP 47 language](https://www.w3.org/International/questions/qa-choosing-language-tags#question) on elements helps ensure that text is pronounced correctly by a screen reader. [Learn more](https://web.dev/valid-lang/)."},s=i.createMessageInstanceIdFn(r,a);t.exports=class ValidLang extends n{static get meta(){return{id:"valid-lang",title:s(a.title),failureTitle:s(a.failureTitle),description:s(a.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=a}).call(this,"/lighthouse-core/audits/accessibility/valid-lang.js")},{"../../lib/i18n/i18n.js":78,"./axe-audit.js":2}],"../audits/accessibility/video-caption":[function(e,t,r){(function(r){"use strict";const n=e("./axe-audit.js"),i=e("../../lib/i18n/i18n.js"),a={title:'`<video>` elements contain a `<track>` element with `[kind="captions"]`',failureTitle:'`<video>` elements do not contain a `<track>` element with `[kind="captions"]`.',
description:"When a video provides a caption it is easier for deaf and hearing impaired users to access its information. [Learn more](https://web.dev/video-caption/)."},s=i.createMessageInstanceIdFn(r,a);t.exports=class VideoCaption extends n{static get meta(){return{id:"video-caption",title:s(a.title),failureTitle:s(a.failureTitle),description:s(a.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=a}).call(this,"/lighthouse-core/audits/accessibility/video-caption.js")},{"../../lib/i18n/i18n.js":78,"./axe-audit.js":2}],"../audits/accessibility/video-description":[function(e,t,r){(function(r){"use strict";const n=e("./axe-audit.js"),i=e("../../lib/i18n/i18n.js"),a={title:'`<video>` elements contain a `<track>` element with `[kind="description"]`',failureTitle:'`<video>` elements do not contain a `<track>` element with `[kind="description"]`.',
description:"Audio descriptions provide relevant information for videos that dialogue cannot, such as facial expressions and scenes. [Learn more](https://web.dev/video-description/)."},s=i.createMessageInstanceIdFn(r,a);t.exports=class VideoDescription extends n{static get meta(){return{id:"video-description",title:s(a.title),failureTitle:s(a.failureTitle),description:s(a.description),requiredArtifacts:["Accessibility"]}}},t.exports.UIStrings=a}).call(this,"/lighthouse-core/audits/accessibility/video-description.js")},{"../../lib/i18n/i18n.js":78,"./axe-audit.js":2}],"../audits/apple-touch-icon":[function(e,t,r){(function(r){"use strict";const n=e("./audit.js"),i=e("../lib/i18n/i18n.js"),a={title:"Provides a valid `apple-touch-icon`",failureTitle:"Does not provide a valid `apple-touch-icon`",
description:"For ideal appearance on iOS when users add a progressive web app to the home screen, define an `apple-touch-icon`. It must point to a non-transparent 192px (or 180px) square PNG. [Learn More](https://web.dev/apple-touch-icon/).",precomposedWarning:"`apple-touch-icon-precomposed` is out of date; `apple-touch-icon` is preferred."},s=i.createMessageInstanceIdFn(r,a);t.exports=class AppleTouchIcon extends n{static get meta(){return{id:"apple-touch-icon",title:s(a.title),failureTitle:s(a.failureTitle),description:s(a.description),requiredArtifacts:["LinkElements"]}}static audit(e){const t=e.LinkElements.filter(e=>"apple-touch-icon"===e.rel||"apple-touch-icon-precomposed"===e.rel).filter(e=>!!e.href),r=0!==t.length,n=[];return 0!==t.filter(e=>"apple-touch-icon-precomposed"===e.rel).length&&0===t.filter(e=>"apple-touch-icon"===e.rel).length&&n.push(s(a.precomposedWarning)),{score:r?1:0,warnings:n}}},t.exports.UIStrings=a}).call(this,"/lighthouse-core/audits/apple-touch-icon.js")
},{"../lib/i18n/i18n.js":78,"./audit.js":3}],"../audits/autocomplete":[function(e,t,r){(function(r){"use strict";const n=e("./audit.js"),i=e("../lib/i18n/i18n.js"),a=e("lighthouse-logger"),s={title:"`<input>` elements correctly use `autocomplete`",failureTitle:"`<input>` elements do not have correct `autocomplete` attributes",description:"`autocomplete` helps users submit forms quicker. To reduce user effort, consider enabling by setting the `autocomplete` attribute to a valid value. [Learn more](https://developers.google.com/web/fundamentals/design-and-ux/input/forms#use_metadata_to_enable_auto-complete)",columnSuggestions:"Suggested Token",columnCurrent:"Current Value",warningInvalid:'`autocomplete` token(s): "{token}" is invalid in {snippet}',warningOrder:'Review order of tokens: "{tokens}" in {snippet}',reviewOrder:"Review order of tokens",manualReview:"Requires manual review"
},o=i.createMessageInstanceIdFn(r,s),l=["name","honorific-prefix","given-name","additional-name","family-name","honorific-suffix","nickname","username","new-password","current-password","one-time-code","organization-title","organization","street-address","address-line1","address-line2","address-line3","address-level4","address-level3","address-level2","address-level1","country","country-name","postal-code","cc-name","cc-given-name","cc-additional-name","cc-family-name","cc-number","cc-exp","cc-exp-month","cc-exp-year","cc-csc","cc-type","transaction-currency","transaction-amount","language","bday","bday-day","bday-month","bday-year","sex","url","photo","tel","tel-country-code","tel-national","tel-area-code","on","tel-local","tel-local-prefix","tel-local-suffix","tel-extension","email","impp","off","additional-name-initial","home","work","mobile","fax","pager","shipping","billing"],c=["NO_SERVER_DATA","UNKNOWN_TYPE","EMPTY_TYPE","HTML_TYPE_UNSPECIFIED","HTML_TYPE_UNRECOGNIZED"],u={
NO_SERVER_DATA:o(s.manualReview),UNKNOWN_TYPE:o(s.manualReview),EMPTY_TYPE:o(s.manualReview),NAME_FIRST:"given-name",NAME_MIDDLE:"additional-name",NAME_LAST:"family-name",NAME_FULL:"name",NAME_MIDDLE_INITIAL:"additional-name-initial",NAME_SUFFIX:"honorific-suffix",NAME_BILLING_FIRST:"billing given-name",NAME_BILLING_MIDDLE:"billing additional-name",NAME_BILLING_LAST:"billing family-name",NAME_BILLING_MIDDLE_INITIAL:"billing additional-name-initial",NAME_BILLING_FULL:"billing name",NAME_BILLING_SUFFIX:"billing honorific-suffix",EMAIL_ADDRESS:"email",MERCHANT_EMAIL_SIGNUP:"email",PHONE_HOME_NUMBER:"tel-local",PHONE_HOME_CITY_CODE:"tel-area-code",PHONE_HOME_COUNTRY_CODE:"tel-country-code",PHONE_HOME_CITY_AND_NUMBER:"tel-national",PHONE_HOME_WHOLE_NUMBER:"tel",PHONE_HOME_EXTENSION:"tel-extension",PHONE_BILLING_NUMBER:"billing tel-local",PHONE_BILLING_CITY_CODE:"billing tel-area-code",PHONE_BILLING_COUNTRY_CODE:"tel-country-code",PHONE_BILLING_CITY_AND_NUMBER:"tel-national",
PHONE_BILLING_WHOLE_NUMBER:"tel",ADDRESS_HOME_STREET_ADDRESS:"street-address",ADDRESS_HOME_LINE1:"address-line1",ADDRESS_HOME_LINE2:"address-line2",ADDRESS_HOME_LINE3:"address-line3",ADDRESS_HOME_STATE:"address-level1",ADDRESS_HOME_CITY:"address-level2",ADDRESS_HOME_DEPENDENT_LOCALITY:"address-level3",ADDRESS_HOME_ZIP:"postal-code",ADDRESS_HOME_COUNTRY:"country-name",ADDRESS_BILLING_DEPENDENT_LOCALITY:"billing address-level3",ADDRESS_BILLING_STREET_ADDRESS:"billing street-address",ADDRESS_BILLING_LINE1:"billing address-line1",ADDRESS_BILLING_LINE2:"billing address-line2",ADDRESS_BILLING_LINE3:"billing address-line3",ADDRESS_BILLING_APT_NUM:"billing address-level3",ADDRESS_BILLING_CITY:"billing address-level2",ADDRESS_BILLING_STATE:"billing address-level1",ADDRESS_BILLING_ZIP:"billing postal-code",ADDRESS_BILLING_COUNTRY:"billing country-name",CREDIT_CARD_NAME_FULL:"cc-name",CREDIT_CARD_NAME_FIRST:"cc-given-name",CREDIT_CARD_NAME_LAST:"cc-family-name",CREDIT_CARD_NUMBER:"cc-number",
CREDIT_CARD_EXP_MONTH:"cc-exp-month",CREDIT_CARD_EXP_2_DIGIT_YEAR:"cc-exp-year",CREDIT_CARD_EXP_4_DIGIT_YEAR:"cc-exp-year",CREDIT_CARD_EXP_DATE_2_DIGIT_YEAR:"cc-exp",CREDIT_CARD_EXP_DATE_4_DIGIT_YEAR:"cc-exp",CREDIT_CARD_TYPE:"cc-type",CREDIT_CARD_VERIFICATION_CODE:"cc-csc",COMPANY_NAME:"organization",PASSWORD:"current-password",ACCOUNT_CREATION_PASSWORD:"new-password",HTML_TYPE_UNSPECIFIED:o(s.manualReview),HTML_TYPE_NAME:"name",HTML_TYPE_HONORIFIC_PREFIX:"honorific-prefix",HTML_TYPE_GIVEN_NAME:"given-name",HTML_TYPE_ADDITIONAL_NAME:"additional-name",HTML_TYPE_FAMILY_NAME:"family-name",HTML_TYPE_ORGANIZATION:"organization",HTML_TYPE_STREET_ADDRESS:"street-address",HTML_TYPE_ADDRESS_LINE1:"address-line1",HTML_TYPE_ADDRESS_LINE2:"address-line2",HTML_TYPE_ADDRESS_LINE3:"address-line3",HTML_TYPE_ADDRESS_LEVEL1:"address-level1",HTML_TYPE_ADDRESS_LEVEL2:"address-level2",HTML_TYPE_ADDRESS_LEVEL3:"address-level3",HTML_TYPE_COUNTRY_CODE:"tel-country-code",HTML_TYPE_COUNTRY_NAME:"country-name",
HTML_TYPE_POSTAL_CODE:"postal-code",HTML_TYPE_FULL_ADDRESS:"street-address",HTML_TYPE_CREDIT_CARD_NAME_FULL:"cc-name",HTML_TYPE_CREDIT_CARD_NAME_FIRST:"cc-given-name",HTML_TYPE_CREDIT_CARD_NAME_LAST:"cc-family-name",HTML_TYPE_CREDIT_CARD_NUMBER:"cc-number",HTML_TYPE_CREDIT_CARD_EXP:"cc-exp",HTML_TYPE_CREDIT_CARD_EXP_MONTH:"cc-exp-month",HTML_TYPE_CREDIT_CARD_EXP_YEAR:"cc-exp-year",HTML_TYPE_CREDIT_CARD_VERIFICATION_CODE:"cc-csc",HTML_TYPE_CREDIT_CARD_TYPE:"cc-csc",HTML_TYPE_TEL:"tel",HTML_TYPE_TEL_COUNTRY_CODE:"tel-country-code",HTML_TYPE_TEL_NATIONAL:"tel-national",HTML_TYPE_TEL_AREA_CODE:"tel-area-code",HTML_TYPE_TEL_LOCAL:"tel-local",HTML_TYPE_TEL_LOCAL_PREFIX:"tel-local-prefix",HTML_TYPE_TEL_LOCAL_SUFFIX:"tel-local-suffix",HTML_TYPE_TEL_EXTENSION:"tel-extension",HTML_TYPE_EMAIL:"email",HTML_TYPE_ADDITIONAL_NAME_INITIAL:"additional-name-initial",HTML_TYPE_CREDIT_CARD_EXP_DATE_2_DIGIT_YEAR:"cc-exp-year",HTML_TYPE_CREDIT_CARD_EXP_DATE_4_DIGIT_YEAR:"cc-exp-year",
HTML_TYPE_CREDIT_CARD_EXP_2_DIGIT_YEAR:"cc-exp-year",HTML_TYPE_CREDIT_CARD_EXP_4_DIGIT_YEAR:"cc-exp-year",HTML_TYPE_UPI_VPA:o(s.manualReview),HTML_TYPE_ONE_TIME_CODE:"one-time-code",HTML_TYPE_UNRECOGNIZED:o(s.manualReview),HTML_TYPE_TRANSACTION_AMOUNT:"transaction-amount",HTML_TYPE_TRANSACTION_CURRENCY:"transaction-currency"};t.exports=class AutocompleteAudit extends n{static get meta(){return{id:"autocomplete",title:o(s.title),failureTitle:o(s.failureTitle),description:o(s.description),requiredArtifacts:["FormElements"]}}static checkAttributeValidity(e){if(!e.autocomplete.attribute)return{hasValidTokens:!1};const t=e.autocomplete.attribute.split(" ");for(const e of t)if("section-"!==e.slice(0,8)&&!l.includes(e))return{hasValidTokens:!1};return e.autocomplete.property?{hasValidTokens:!0,isValidOrder:!0}:{hasValidTokens:!0,isValidOrder:!1}}static audit(e){const t=e.FormElements,r=[],l=[];let d=!1;for(const e of t)for(const t of e.inputs){const e=this.checkAttributeValidity(t)
;if(e.hasValidTokens&&e.isValidOrder)continue;if(!t.autocomplete.prediction)continue;if(c.includes(t.autocomplete.prediction)&&!t.autocomplete.attribute)continue;d=!0;let n=u[t.autocomplete.prediction];t.autocomplete.attribute||(t.autocomplete.attribute=""),t.autocomplete.attribute&&l.push(o(s.warningInvalid,{token:t.autocomplete.attribute,snippet:t.snippet})),!1===e.isValidOrder&&(l.push(o(s.warningOrder,{tokens:t.autocomplete.attribute,snippet:t.snippet})),n=s.reviewOrder),t.autocomplete.prediction in u||!e.isValidOrder?r.push({node:{type:"node",snippet:t.snippet,nodeLabel:t.nodeLabel},suggestion:n,current:t.autocomplete.attribute}):a.warn(`Autocomplete prediction (${t.autocomplete.prediction})\n             not found in our mapping`)}const m=[{key:"node",itemType:"node",text:o(i.UIStrings.columnFailingElem)},{key:"current",itemType:"text",text:o(s.columnCurrent)},{key:"suggestion",itemType:"text",text:o(s.columnSuggestions)}],p=n.makeTableDetails(m,r);let h
;return r.length>0&&(h=o(i.UIStrings.displayValueElementsFound,{nodeCount:r.length})),{score:r.length>0?0:1,notApplicable:!d,displayValue:h,details:p,warnings:l}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/autocomplete.js")},{"../lib/i18n/i18n.js":78,"./audit.js":3,"lighthouse-logger":141}],"../audits/bootup-time":[function(e,t,r){(function(r){"use strict";const n=e("./audit.js"),i=e("../lib/network-request.js"),{taskGroups:a}=e("../lib/tracehouse/task-groups.js"),s=e("../lib/i18n/i18n.js"),o=e("../computed/network-records.js"),l=e("../computed/main-thread-tasks.js"),c={title:"JavaScript execution time",failureTitle:"Reduce JavaScript execution time",description:"Consider reducing the time spent parsing, compiling, and executing JS. You may find delivering smaller JS payloads helps with this. [Learn more](https://web.dev/bootup-time/).",columnTotal:"Total CPU Time",columnScriptEval:"Script Evaluation",columnScriptParse:"Script Parse",
chromeExtensionsWarning:"Chrome extensions negatively affected this page's load performance. Try auditing the page in incognito mode or from a Chrome profile without extensions."},u=s.createMessageInstanceIdFn(r,c),d=new Set(["CpuProfiler::StartProfiling"]),m=new Set(["V8.GCCompactor","MajorGC","MinorGC"]);class BootupTime extends n{static get meta(){return{id:"bootup-time",title:u(c.title),failureTitle:u(c.failureTitle),description:u(c.description),scoreDisplayMode:n.SCORING_MODES.NUMERIC,requiredArtifacts:["traces","devtoolsLogs"]}}static get defaultOptions(){return{p10:1282,median:3500,thresholdInMs:50}}static getJavaScriptURLs(e){const t=new Set;for(const r of e)r.resourceType===i.TYPES.Script&&t.add(r.url);return t}static getAttributableURLForTask(e,t){const r=e.attributableURLs.find(e=>t.has(e)),n=e.attributableURLs[0];let i=r||n;return i&&"about:blank"!==i||(i=d.has(e.event.name)?"Browser":m.has(e.event.name)?"Browser GC":"Unattributable"),i}static getExecutionTimingsByURL(e,t){
const r=new Map;for(const n of e){const e=BootupTime.getAttributableURLForTask(n,t),i=r.get(e)||{},a=i[n.group.id]||0;i[n.group.id]=a+n.selfTime,r.set(e,i)}return r}static async audit(e,t){const r=t.settings||{},i=e.traces[BootupTime.DEFAULT_PASS],d=e.devtoolsLogs[BootupTime.DEFAULT_PASS],m=await o.request(d,t),p=await l.request(i,t),h="simulate"===r.throttlingMethod?r.throttling.cpuSlowdownMultiplier:1,g=BootupTime.getJavaScriptURLs(m),f=BootupTime.getExecutionTimingsByURL(p,g);let b=!1,y=0;const v=Array.from(f).map(([e,r])=>{let n=0;for(const[e,t]of Object.entries(r))r[e]=t*h,n+=t*h;const i=r[a.scriptEvaluation.id]||0,s=r[a.scriptParseCompile.id]||0;return n>=t.options.thresholdInMs&&(y+=i+s),b=b||e.startsWith("chrome-extension:")&&i>100,{url:e,total:n,scripting:i,scriptParseCompile:s}}).filter(e=>e.total>=t.options.thresholdInMs).sort((e,t)=>t.total-e.total);let w;b&&(w=[u(c.chromeExtensionsWarning)]);const k={wastedMs:y},x=[{key:"url",itemType:"url",text:u(s.UIStrings.columnURL)},{
key:"total",granularity:1,itemType:"ms",text:u(c.columnTotal)},{key:"scripting",granularity:1,itemType:"ms",text:u(c.columnScriptEval)},{key:"scriptParseCompile",granularity:1,itemType:"ms",text:u(c.columnScriptParse)}],T=BootupTime.makeTableDetails(x,v,k);return{score:n.computeLogNormalScore({p10:t.options.p10,median:t.options.median},y),numericValue:y,numericUnit:"millisecond",displayValue:y>0?u(s.UIStrings.seconds,{timeInMs:y}):"",details:T,runWarnings:w}}}t.exports=BootupTime,t.exports.UIStrings=c}).call(this,"/lighthouse-core/audits/bootup-time.js")},{"../computed/main-thread-tasks.js":14,"../computed/network-records.js":40,"../lib/i18n/i18n.js":78,"../lib/network-request.js":90,"../lib/tracehouse/task-groups.js":100,"./audit.js":3}],"../audits/byte-efficiency/duplicated-javascript":[function(e,t,r){(function(r){"use strict"
;const n=e("./byte-efficiency-audit.js"),i=e("../../computed/module-duplication.js"),a=e("../../lib/dependency-graph/simulator/network-analyzer.js"),s=e("../../lib/i18n/i18n.js"),o={title:"Remove duplicate modules in JavaScript bundles",description:"Remove large, duplicate JavaScript modules from bundles to reduce unnecessary bytes consumed by network activity. "},l=s.createMessageInstanceIdFn(r,o),c=1024;function indexOfOrEnd(e,t,r=0){const n=e.indexOf(t,r);return-1===n?e.length:n}class DuplicatedJavascript extends n{static get meta(){return{id:"duplicated-javascript",title:l(o.title),description:l(o.description),scoreDisplayMode:n.SCORING_MODES.NUMERIC,requiredArtifacts:["devtoolsLogs","traces","SourceMaps","ScriptElements","URL"]}}static _getNodeModuleName(e){const t=e.split("node_modules/"),r=indexOfOrEnd(e=t[t.length-1],"/");return"@"===e[0]?e.slice(0,indexOfOrEnd(e,"/",r+1)):e.slice(0,r)}static async _getDuplicationGroupedByNodeModules(e,t){const r=await i.request(e,t),n=new Map
;for(const[e,t]of r.entries()){if(!e.includes("node_modules")){n.set(e,t);continue}const r="node_modules/"+DuplicatedJavascript._getNodeModuleName(e),i=n.get(r)||[];for(const{scriptUrl:e,resourceSize:r}of t){let t=i.find(t=>t.scriptUrl===e);t||(t={scriptUrl:e,resourceSize:0},i.push(t)),t.resourceSize+=r}n.set(r,i)}for(const e of r.values())e.sort((e,t)=>t.resourceSize-e.resourceSize);return n}static _estimateTransferRatio(e,t){return n.estimateTransferSize(e,t,"Script")/t}static async audit_(e,t,r){const n=r.options&&r.options.ignoreThresholdInBytes||c,i=await DuplicatedJavascript._getDuplicationGroupedByNodeModules(e,r),o=await a.findMainDocument(t),u=new Map,d=[];let m=0;const p=new Set,h=new Map;for(const[r,a]of i.entries()){const i=[];let s=0;for(let r=0;r<a.length;r++){const n=a[r],l=n.scriptUrl;let c=u.get(l);if(void 0===c){const r=l===e.URL.finalUrl?o:t.find(e=>e.url===l),n=e.ScriptElements.find(e=>e.src===l);if(!n||null===n.content)continue;const i=n.content.length
;c=DuplicatedJavascript._estimateTransferRatio(r,i),u.set(l,c)}if(void 0===c)continue;const d=Math.round(n.resourceSize*c);i.push({url:l,sourceTransferBytes:d}),0!==r&&(s+=d,h.set(l,(h.get(l)||0)+d))}if(s<=n){m+=s;for(const e of i)p.add(e.url)}else d.push({source:r,wastedBytes:s,url:"",totalBytes:0,subItems:{type:"subitems",items:i}})}return m>n&&d.push({source:"Other",wastedBytes:m,url:"",totalBytes:0,subItems:{type:"subitems",items:Array.from(p).map(e=>({url:e}))}}),{items:d,headings:[{key:"source",valueType:"code",subItemsHeading:{key:"url",valueType:"url"},label:l(s.UIStrings.columnSource)},{key:null,valueType:"bytes",subItemsHeading:{key:"sourceTransferBytes"},granularity:.05,label:l(s.UIStrings.columnTransferSize)},{key:"wastedBytes",valueType:"bytes",granularity:.05,label:l(s.UIStrings.columnWastedBytes)}],wastedBytesByUrl:h}}}t.exports=DuplicatedJavascript,t.exports.UIStrings=o}).call(this,"/lighthouse-core/audits/byte-efficiency/duplicated-javascript.js")},{
"../../computed/module-duplication.js":38,"../../lib/dependency-graph/simulator/network-analyzer.js":74,"../../lib/i18n/i18n.js":78,"./byte-efficiency-audit.js":4}],"../audits/byte-efficiency/efficient-animated-content":[function(e,t,r){(function(r){"use strict";const n=e("../../lib/network-request.js"),i=e("./byte-efficiency-audit.js"),a=e("../../lib/i18n/i18n.js"),s={title:"Use video formats for animated content",description:"Large GIFs are inefficient for delivering animated content. Consider using MPEG4/WebM videos for animations and PNG/WebP for static images instead of GIF to save network bytes. [Learn more](https://web.dev/efficient-animated-content/)"},o=a.createMessageInstanceIdFn(r,s),l=102400;class EfficientAnimatedContent extends i{static get meta(){return{id:"efficient-animated-content",title:o(s.title),description:o(s.description),scoreDisplayMode:i.SCORING_MODES.NUMERIC,requiredArtifacts:["devtoolsLogs","traces"]}}static getPercentSavings(e){
return Math.round(29.1*Math.log10(e)-100.7)/100}static audit_(e,t){return{items:t.filter(e=>"image/gif"===e.mimeType&&e.resourceType===n.TYPES.Image&&(e.resourceSize||0)>l).map(e=>{const t=e.resourceSize||0;return{url:e.url,totalBytes:t,wastedBytes:Math.round(t*EfficientAnimatedContent.getPercentSavings(t))}}),headings:[{key:"url",valueType:"url",label:o(a.UIStrings.columnURL)},{key:"totalBytes",valueType:"bytes",label:o(a.UIStrings.columnResourceSize)},{key:"wastedBytes",valueType:"bytes",label:o(a.UIStrings.columnWastedBytes)}]}}}t.exports=EfficientAnimatedContent,t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/byte-efficiency/efficient-animated-content.js")},{"../../lib/i18n/i18n.js":78,"../../lib/network-request.js":90,"./byte-efficiency-audit.js":4}],"../audits/byte-efficiency/legacy-javascript":[function(e,t,r){(function(r){"use strict"
;const n=e("./byte-efficiency-audit.js"),i=e("../../computed/js-bundles.js"),a=e("../../lib/i18n/i18n.js"),s=e("../../lib/third-party-web.js"),o=e("../../lib/dependency-graph/simulator/network-analyzer.js"),l={title:"Avoid serving legacy JavaScript to modern browsers",description:"Polyfills and transforms enable legacy browsers to use new JavaScript features. However, many aren't necessary for modern browsers. For your bundled JavaScript, adopt a modern script deployment strategy using module/nomodule feature detection to reduce the amount of code shipped to modern browsers, while retaining support for legacy browsers. [Learn More](https://philipwalton.com/articles/deploying-es2015-code-in-production-today/)"},c=a.createMessageInstanceIdFn(r,l);class CodePatternMatcher{constructor(e){const t=e.map(e=>`(${e.expression})`).join("|");this.re=new RegExp(`(^\r\n|\r|\n)|${t}`,"g"),this.patterns=e}match(e){this.re.lastIndex=0;const t=new Set,r=[];let n,i=0,a=0
;for(;null!==(n=this.re.exec(e));){const e=n.slice(1),[s,...o]=e;if(s){i++,a=n.index+1;continue}const l=this.patterns[o.findIndex(Boolean)];if(t.has(l)){const e=r.find(e=>e.name===l.name);e&&(e.count+=1)}else t.add(l),r.push({name:l.name,line:i,column:n.index-a,count:1})}return r}}t.exports=class LegacyJavascript extends n{static get meta(){return{id:"legacy-javascript",scoreDisplayMode:n.SCORING_MODES.NUMERIC,description:c(l.description),title:c(l.title),requiredArtifacts:["devtoolsLogs","traces","ScriptElements","SourceMaps","URL"]}}static buildPolyfillExpression(e,t){const r=e=>`['"]${e}['"]`;let n="";if(n+=e?`${e}\\.${t}\\s?=[^=]`:`(?:window\\.|[\\s;]+)${t}\\s?=[^=]`,e&&(n+=`|${e}\\[${r(t)}\\]\\s?=[^=]`),n+=`|defineProperty\\(${e||"window"},\\s?${r(t)}`,e){const i=e.replace(".prototype","");n+=`|\\$export\\([^,]+,${r(i)},{${t}:`,n+=`|{target:${r(i)}\\S*},{${t}:`}else n+=`|function ${t}\\(`;return n}static getPolyfillData(){
return[["Array.prototype.fill","es6.array.fill"],["Array.prototype.filter","es6.array.filter"],["Array.prototype.find","es6.array.find"],["Array.prototype.findIndex","es6.array.find-index"],["Array.prototype.forEach","es6.array.for-each"],["Array.from","es6.array.from"],["Array.isArray","es6.array.is-array"],["Array.prototype.map","es6.array.map"],["Array.of","es6.array.of"],["Array.prototype.reduce","es6.array.reduce"],["Array.prototype.reduceRight","es6.array.reduce-right"],["Array.prototype.some","es6.array.some"],["Date.now","es6.date.now"],["Date.prototype.toISOString","es6.date.to-iso-string"],["Date.prototype.toJSON","es6.date.to-json"],["Date.prototype.toString","es6.date.to-string"],["Function.prototype.name","es6.function.name"],["Number.isInteger","es6.number.is-integer"],["Number.isSafeInteger","es6.number.is-safe-integer"],["Number.parseInt","es6.number.parse-int"],["Object.defineProperties","es6.object.define-properties"],["Object.defineProperty","es6.object.define-property"],["Object.freeze","es6.object.freeze"],["Object.getOwnPropertyNames","es6.object.get-own-property-names"],["Object.getPrototypeOf","es6.object.get-prototype-of"],["Object.isExtensible","es6.object.is-extensible"],["Object.isFrozen","es6.object.is-frozen"],["Object.isSealed","es6.object.is-sealed"],["Object.keys","es6.object.keys"],["Object.preventExtensions","es6.object.prevent-extensions"],["Object.seal","es6.object.seal"],["Object.setPrototypeOf","es6.object.set-prototype-of"],["Reflect.apply","es6.reflect.apply"],["Reflect.construct","es6.reflect.construct"],["Reflect.defineProperty","es6.reflect.define-property"],["Reflect.deleteProperty","es6.reflect.delete-property"],["Reflect.get","es6.reflect.get"],["Reflect.getOwnPropertyDescriptor","es6.reflect.get-own-property-descriptor"],["Reflect.getPrototypeOf","es6.reflect.get-prototype-of"],["Reflect.has","es6.reflect.has"],["Reflect.isExtensible","es6.reflect.is-extensible"],["Reflect.ownKeys","es6.reflect.own-keys"],["Reflect.preventExtensions","es6.reflect.prevent-extensions"],["Reflect.setPrototypeOf","es6.reflect.set-prototype-of"],["String.prototype.codePointAt","es6.string.code-point-at"],["String.fromCodePoint","es6.string.from-code-point"],["String.raw","es6.string.raw"],["String.prototype.repeat","es6.string.repeat"],["Array.prototype.includes","es7.array.includes"],["Object.entries","es7.object.entries"],["Object.getOwnPropertyDescriptors","es7.object.get-own-property-descriptors"],["Object.values","es7.object.values"]].map(e=>{
const[t,r]=e;return{name:t,coreJs2Module:r,coreJs3Module:r.replace("es6.","es.").replace("es7.","es.").replace("typed.","typed-array.")}})}static getPolyfillPatterns(){return this.getPolyfillData().map(({name:e})=>{const t=e.split("."),r=t.length>1?t.slice(0,t.length-1).join("."):null,n=t[t.length-1];return{name:e,expression:this.buildPolyfillExpression(r,n)}})}static getTransformPatterns(){return[{name:"@babel/plugin-transform-classes",expression:"Cannot call a class as a function",estimateBytes:e=>150+e.count*"_classCallCheck()".length},{name:"@babel/plugin-transform-regenerator",expression:/regeneratorRuntime\.a?wrap/.source,estimateBytes:e=>80*e.count},{name:"@babel/plugin-transform-spread",expression:/\.apply\(void 0,\s?_toConsumableArray/.source,estimateBytes:e=>1169+e.count*"_toConsumableArray()".length}]}static detectAcrossScripts(e,t,r,n){const i=new Map,a=this.getPolyfillData();for(const{requestId:s,content:o}of Object.values(t)){if(!o)continue
;const t=r.find(e=>e.requestId===s);if(!t)continue;const l=e.match(o),c=n.find(e=>e.script.src===t.url);if(c)for(const{coreJs2Module:e,coreJs3Module:t,name:r}of a){if(l.some(e=>e.name===r))continue;const n=c.rawMap.sources.find(r=>r.endsWith(`${e}.js`)||r.endsWith(`${t}.js`));if(!n)continue;const i=c.map.mappings().find(e=>e.sourceURL===n);i?l.push({name:r,line:i.lineNumber,column:i.columnNumber,count:1}):l.push({name:r,line:0,column:0,count:1})}l.length&&i.set(t.url,l)}return i}static estimateWastedBytes(t){const r=t.filter(e=>!e.name.startsWith("@")),n=t.filter(e=>e.name.startsWith("@"));let i=0;const a=e("./polyfill-graph-data.json"),s=new Set;for(const e of r){const t=a.dependencies[e.name];if(t)for(const e of t)s.add(e)}r.length>0&&(i+=a.baseSize),i+=[...s].reduce((e,t)=>e+a.moduleSizes[t],0),i=Math.min(i,a.maxSize);let o=0;for(const e of n){const t=this.getTransformPatterns().find(t=>t.name===e.name);t&&t.estimateBytes&&(o+=t.estimateBytes(e))}return i+o}
static async estimateTransferRatioForScript(e,t,r,i){let a=e.get(t);if(void 0!==a)return a;const s=await o.findMainDocument(i),l=t===r.URL.finalUrl?s:i.find(e=>e.url===t),c=r.ScriptElements.find(e=>e.src===t);if(c&&null!==c.content){const e=c.content.length;a=n.estimateTransferSize(l,e,"Script")/e}else a=1;return e.set(t,a),a}static async audit_(e,t,r){const n=s.getEntity(e.URL.finalUrl),o=await i.request(e,r),l=[],u=new CodePatternMatcher([...this.getPolyfillPatterns(),...this.getTransformPatterns()]),d=new Map,m=this.detectAcrossScripts(u,e.ScriptElements,t,o);for(const[r,n]of m.entries()){const i=await this.estimateTransferRatioForScript(d,r,e,t),a={url:r,wastedBytes:Math.round(this.estimateWastedBytes(n)*i),subItems:{type:"subitems",items:[]},totalBytes:0};for(const e of n){const{name:t,line:n,column:i}=e,s={signal:t,location:{type:"source-location",url:r,line:n,column:i,urlProvider:"network"}};a.subItems.items.push(s)}l.push(a)}const p=new Map
;for(const e of l)s.isFirstParty(e.url,n)&&p.set(e.url,e.wastedBytes);return{items:l,headings:[{key:"url",valueType:"url",subItemsHeading:{key:"location",valueType:"source-location"},label:c(a.UIStrings.columnURL)},{key:null,valueType:"code",subItemsHeading:{key:"signal"},label:""},{key:"wastedBytes",valueType:"bytes",label:c(a.UIStrings.columnWastedBytes)}],wastedBytesByUrl:p}}},t.exports.UIStrings=l}).call(this,"/lighthouse-core/audits/byte-efficiency/legacy-javascript.js")},{"../../computed/js-bundles.js":11,"../../lib/dependency-graph/simulator/network-analyzer.js":74,"../../lib/i18n/i18n.js":78,"../../lib/third-party-web.js":98,"./byte-efficiency-audit.js":4,"./polyfill-graph-data.json":5}],"../audits/byte-efficiency/offscreen-images":[function(e,t,r){(function(r){"use strict"
;const n=e("./byte-efficiency-audit.js"),i=e("../../lib/sentry.js"),a=e("../../lib/url-shim.js"),s=e("../../lib/i18n/i18n.js"),o=e("../../computed/metrics/interactive.js"),l=e("../../computed/trace-of-tab.js"),c={title:"Defer offscreen images",description:"Consider lazy-loading offscreen and hidden images after all critical resources have finished loading to lower time to interactive. [Learn more](https://web.dev/offscreen-images/)."},u=s.createMessageInstanceIdFn(r,c),d=100,m=3,p=2048,h=75,g=50;class OffscreenImages extends n{static get meta(){return{id:"offscreen-images",title:u(c.title),description:u(c.description),scoreDisplayMode:n.SCORING_MODES.NUMERIC,requiredArtifacts:["ImageElements","ViewportDimensions","devtoolsLogs","traces"]}}static computeVisiblePixels(e,t){const r=t.innerWidth,n=t.innerHeight,i=m*t.innerHeight,a=Math.max(e.top,-1*d),s=Math.min(e.right,r+d),o=Math.min(e.bottom,n+i),l=Math.max(e.left,-1*d);return Math.max(s-l,0)*Math.max(o-a,0)}static computeWaste(e,t,r){
const n=r.find(t=>t.url===e.src);if(!e.resourceSize||!n)return null;if("lazy"===e.loading||"eager"===e.loading)return null;const i=a.elideDataURI(e.src),s=e.displayedWidth*e.displayedHeight,o=this.computeVisiblePixels(e.clientRect,t),l=0===s?1:1-o/s,c=e.resourceSize,u=Math.round(c*l);return Number.isFinite(l)?{url:i,requestStartTime:n.startTime,totalBytes:c,wastedBytes:u,wastedPercent:100*l}:new Error(`Invalid image sizing information ${i}`)}static filterLanternResults(e,t){const r=t.pessimisticEstimate.nodeTimings;let n=0;const i=new Map;for(const[e,t]of r)if("cpu"===e.type&&t.duration>=50)n=Math.max(n,t.startTime);else if("network"===e.type){const r=e;i.set(r.record.url,t.startTime)}return e.filter(e=>{if(e.wastedBytes<p)return!1;if(e.wastedPercent<h)return!1;return(i.get(e.url)||0)<n-g})}static filterObservedResults(e,t){return e.filter(e=>!(e.wastedBytes<p)&&(!(e.wastedPercent<h)&&e.requestStartTime<t/1e6-g/1e3))}static computeWasteWithTTIGraph(e,t,r){
return super.computeWasteWithTTIGraph(e,t,r,{includeLoad:!1})}static async audit_(e,t,r){const a=e.ImageElements,c=e.ViewportDimensions,d=e.traces[n.DEFAULT_PASS],m=e.devtoolsLogs[n.DEFAULT_PASS],p=[],h=a.reduce((e,r)=>{const n=OffscreenImages.computeWaste(r,c,t);if(null===n)return e;if(n instanceof Error)return p.push(n.message),i.captureException(n,{tags:{audit:this.meta.id},level:"warning"}),e;const a=e.get(n.url);return(!a||a.wastedBytes>n.wastedBytes)&&e.set(n.url,n),e},new Map),g=r.settings;let f;const b=Array.from(h.values());try{const e=await o.request({trace:d,devtoolsLog:m,settings:g},r),t=e;f="simulate"===r.settings.throttlingMethod?OffscreenImages.filterLanternResults(b,t):OffscreenImages.filterObservedResults(b,e.timestamp)}catch(e){if("simulate"===r.settings.throttlingMethod)throw e;f=OffscreenImages.filterObservedResults(b,await l.request(d,r).then(e=>e.timestamps.traceEnd))}const y=[{key:"url",valueType:"thumbnail",label:""},{key:"url",valueType:"url",
label:u(s.UIStrings.columnURL)},{key:"totalBytes",valueType:"bytes",label:u(s.UIStrings.columnResourceSize)},{key:"wastedBytes",valueType:"bytes",label:u(s.UIStrings.columnWastedBytes)}];return{warnings:p,items:f,headings:y}}}t.exports=OffscreenImages,t.exports.UIStrings=c}).call(this,"/lighthouse-core/audits/byte-efficiency/offscreen-images.js")},{"../../computed/metrics/interactive.js":21,"../../computed/trace-of-tab.js":45,"../../lib/i18n/i18n.js":78,"../../lib/sentry.js":93,"../../lib/url-shim.js":"url","./byte-efficiency-audit.js":4}],"../audits/byte-efficiency/render-blocking-resources":[function(e,t,r){(function(r){"use strict";const n=e("../audit.js"),i=e("../../lib/i18n/i18n.js"),a=e("../../lib/dependency-graph/base-node.js"),s=e("./byte-efficiency-audit.js"),o=e("../../computed/unused-css.js"),l=e("../../lib/network-request.js"),c=e("../../computed/trace-of-tab.js"),u=e("../../computed/load-simulator.js"),d=e("../../computed/metrics/first-contentful-paint.js"),m=50,p={
title:"Eliminate render-blocking resources",description:"Resources are blocking the first paint of your page. Consider delivering critical JS/CSS inline and deferring all non-critical JS/styles. [Learn more](https://web.dev/render-blocking-resources/)."},h=i.createMessageInstanceIdFn(r,p);function computeStackSpecificTiming(e,t,r){const n={...t};return r.some(e=>"amp"===e.id)&&e.type===a.TYPES.NETWORK&&e.record.resourceType===l.TYPES.Stylesheet&&t.endTime>2100&&(n.endTime=Math.max(t.startTime,2100),n.duration=n.endTime-n.startTime),n}class RenderBlockingResources extends n{static get meta(){return{id:"render-blocking-resources",title:h(p.title),scoreDisplayMode:n.SCORING_MODES.NUMERIC,description:h(p.description),requiredArtifacts:["URL","TagsBlockingFirstPaint","traces","devtoolsLogs","CSSUsage","Stacks"]}}static async computeResults(e,t){const r=e.traces[n.DEFAULT_PASS],i=e.devtoolsLogs[n.DEFAULT_PASS],a={devtoolsLog:i,settings:t.settings
},s=await c.request(r,t),o=await u.request(a,t),l=await RenderBlockingResources.computeWastedCSSBytes(e,t),p={trace:r,devtoolsLog:i,simulator:o,settings:{throttlingMethod:"simulate"}},h=await d.request(p,t),g=s.timestamps.firstContentfulPaint/1e3,f=function getNodesAndTimingByUrl(e){const t={};return Array.from(e.keys()).forEach(r=>{if("network"!==r.type)return;const n=e.get(r);n&&(t[r.record.url]={node:r,nodeTiming:n})}),t}(h.optimisticEstimate.nodeTimings),b=[],y=new Set;for(const t of e.TagsBlockingFirstPaint){if(1e3*t.endTime>g)continue;if(!f[t.tag.url])continue;const{node:r,nodeTiming:n}=f[t.tag.url],i=computeStackSpecificTiming(r,n,e.Stacks);r.traverse(e=>y.add(e.id));const a=Math.round(i.duration);a<m||b.push({url:t.tag.url,totalBytes:t.transferSize,wastedMs:a})}return b.length?{results:b,wastedMs:RenderBlockingResources.estimateSavingsWithGraphs(o,h.optimisticGraph,y,l,e.Stacks)}:{results:b,wastedMs:0}}static estimateSavingsWithGraphs(e,t,r,n,i){
const{nodeTimings:s}=e.simulate(t),o=new Map(s);let c=0;const u=t.cloneWithRelationships(e=>{!function adjustNodeTimings(e,t,r){const n=e.get(t);if(!n)return;const i=computeStackSpecificTiming(t,n,r);n.duration-i.duration&&(t.traverse(t=>{e.delete(t)}),e.set(t,i))}(o,e,i);const t=r.has(e.id);if(e.type!==a.TYPES.NETWORK)return!t;const s=e.record.resourceType===l.TYPES.Stylesheet;if(t&&s){const t=n.get(e.record.url)||0;c+=(e.record.transferSize||0)-t}return!t}),d=Math.max(...Array.from(Array.from(o).map(e=>e[1].endTime))),m=u.record.transferSize,p=m||0;u.record.transferSize=p+c;const h=e.simulate(u).timeInMs;return u.record.transferSize=m,Math.round(Math.max(d-h,0))}static async computeWastedCSSBytes(e,t){const r=new Map;try{const i=await o.request({CSSUsage:e.CSSUsage,URL:e.URL,devtoolsLog:e.devtoolsLogs[n.DEFAULT_PASS]},t);for(const e of i)r.set(e.url,e.wastedBytes)}catch(e){}return r}static async audit(e,t){const{results:r,wastedMs:a}=await RenderBlockingResources.computeResults(e,t)
;let o;r.length>0&&(o=h(i.UIStrings.displayValueMsSavings,{wastedMs:a}));const l=[{key:"url",valueType:"url",label:h(i.UIStrings.columnURL)},{key:"totalBytes",valueType:"bytes",label:h(i.UIStrings.columnTransferSize)},{key:"wastedMs",valueType:"timespanMs",label:h(i.UIStrings.columnWastedMs)}],c=n.makeOpportunityDetails(l,r,a);return{displayValue:o,score:s.scoreForWastedMs(a),numericValue:a,numericUnit:"millisecond",details:c}}}t.exports=RenderBlockingResources,t.exports.UIStrings=p}).call(this,"/lighthouse-core/audits/byte-efficiency/render-blocking-resources.js")},{"../../computed/load-simulator.js":12,"../../computed/metrics/first-contentful-paint.js":18,"../../computed/trace-of-tab.js":45,"../../computed/unused-css.js":46,"../../lib/dependency-graph/base-node.js":69,"../../lib/i18n/i18n.js":78,"../../lib/network-request.js":90,"../audit.js":3,"./byte-efficiency-audit.js":4}],"../audits/byte-efficiency/total-byte-weight":[function(e,t,r){(function(r){"use strict"
;const n=e("./byte-efficiency-audit.js"),i=e("../../lib/i18n/i18n.js"),a=e("../../computed/network-records.js"),s={title:"Avoids enormous network payloads",failureTitle:"Avoid enormous network payloads",description:"Large network payloads cost users real money and are highly correlated with long load times. [Learn more](https://web.dev/total-byte-weight/).",displayValue:"Total size was {totalBytes, number, bytes} KiB"},o=i.createMessageInstanceIdFn(r,s);t.exports=class TotalByteWeight extends n{static get meta(){return{id:"total-byte-weight",title:o(s.title),failureTitle:o(s.failureTitle),description:o(s.description),scoreDisplayMode:n.SCORING_MODES.NUMERIC,requiredArtifacts:["devtoolsLogs","traces"]}}static get defaultOptions(){return{p10:2731008,median:4096e3}}static async audit(e,t){const r=e.devtoolsLogs[n.DEFAULT_PASS],l=await a.request(r,t);let c=0,u=[];l.forEach(e=>{if("data"===e.parsedURL.scheme||!e.finished)return;const t={url:e.url,totalBytes:e.transferSize};c+=t.totalBytes,
u.push(t)}),u=u.sort((e,t)=>t.totalBytes-e.totalBytes||e.url.localeCompare(t.url)).slice(0,10);const d=n.computeLogNormalScore({p10:t.options.p10,median:t.options.median},c),m=[{key:"url",itemType:"url",text:o(i.UIStrings.columnURL)},{key:"totalBytes",itemType:"bytes",text:o(i.UIStrings.columnTransferSize)}],p=n.makeTableDetails(m,u);return{score:d,numericValue:c,numericUnit:"byte",displayValue:o(s.displayValue,{totalBytes:c}),details:p}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/byte-efficiency/total-byte-weight.js")},{"../../computed/network-records.js":40,"../../lib/i18n/i18n.js":78,"./byte-efficiency-audit.js":4}],"../audits/byte-efficiency/unminified-css":[function(e,t,r){(function(r){"use strict";const n=e("./byte-efficiency-audit.js"),i=e("../../computed/unused-css.js"),a=e("../../lib/i18n/i18n.js"),s=e("../../lib/minification-estimator.js").computeCSSTokenLength,o={title:"Minify CSS",
description:"Minifying CSS files can reduce network payload sizes. [Learn more](https://web.dev/unminified-css/)."},l=a.createMessageInstanceIdFn(r,o),c=5,u=2048;class UnminifiedCSS extends n{static get meta(){return{id:"unminified-css",title:l(o.title),description:l(o.description),scoreDisplayMode:n.SCORING_MODES.NUMERIC,requiredArtifacts:["CSSUsage","devtoolsLogs","traces","URL"]}}static computeTokenLength(e){return s(e)}static computeWaste(e,t,r){const a=e.content,s=UnminifiedCSS.computeTokenLength(a);let o=e.header.sourceURL;if(!o||o===r){o=i.determineContentPreview(e.content)}const l=n.estimateTransferSize(t,a.length,"Stylesheet"),c=1-s/a.length;return{url:o,totalBytes:l,wastedBytes:Math.round(l*c),wastedPercent:100*c}}static audit_(e,t){const r=e.URL.finalUrl,n=[];for(const i of e.CSSUsage.stylesheets){const e=t.find(e=>e.url===i.header.sourceURL);if(!i.content)continue;const a=UnminifiedCSS.computeWaste(i,e,r)
;a.wastedPercent<c||a.wastedBytes<u||!Number.isFinite(a.wastedBytes)||n.push(a)}return{items:n,headings:[{key:"url",valueType:"url",label:l(a.UIStrings.columnURL)},{key:"totalBytes",valueType:"bytes",label:l(a.UIStrings.columnTransferSize)},{key:"wastedBytes",valueType:"bytes",label:l(a.UIStrings.columnWastedBytes)}]}}}t.exports=UnminifiedCSS,t.exports.UIStrings=o}).call(this,"/lighthouse-core/audits/byte-efficiency/unminified-css.js")},{"../../computed/unused-css.js":46,"../../lib/i18n/i18n.js":78,"../../lib/minification-estimator.js":88,"./byte-efficiency-audit.js":4}],"../audits/byte-efficiency/unminified-javascript":[function(e,t,r){(function(r){"use strict";const n=e("./byte-efficiency-audit.js"),i=e("../../lib/i18n/i18n.js"),a=e("../../lib/minification-estimator.js").computeJSTokenLength,s={title:"Minify JavaScript",description:"Minifying JavaScript files can reduce payload sizes and script parse time. [Learn more](https://web.dev/unminified-javascript/)."
},o=i.createMessageInstanceIdFn(r,s),l=10,c=2048;class UnminifiedJavaScript extends n{static get meta(){return{id:"unminified-javascript",title:o(s.title),description:o(s.description),scoreDisplayMode:n.SCORING_MODES.NUMERIC,requiredArtifacts:["ScriptElements","devtoolsLogs","traces"]}}static computeWaste(e,t,r){const i=e.length,s=a(e),o=n.estimateTransferSize(r,i,"Script"),l=1-s/i;return{url:t,totalBytes:o,wastedBytes:Math.round(o*l),wastedPercent:100*l}}static audit_(e,t){const r=[],n=[];for(const{requestId:i,src:a,content:s}of e.ScriptElements){if(!s)continue;const e=t.find(e=>e.requestId===i),o=a&&e?e.url:`inline: ${s.substr(0,40)}...`;try{const t=UnminifiedJavaScript.computeWaste(s,o,e);if(t.wastedPercent<l||t.wastedBytes<c||!Number.isFinite(t.wastedBytes))continue;r.push(t)}catch(t){const r=e?e.url:"?";n.push(`Unable to process script ${r}: ${t.message}`)}}return{items:r,warnings:n,headings:[{key:"url",valueType:"url",label:o(i.UIStrings.columnURL)},{key:"totalBytes",
valueType:"bytes",label:o(i.UIStrings.columnTransferSize)},{key:"wastedBytes",valueType:"bytes",label:o(i.UIStrings.columnWastedBytes)}]}}}t.exports=UnminifiedJavaScript,t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/byte-efficiency/unminified-javascript.js")},{"../../lib/i18n/i18n.js":78,"../../lib/minification-estimator.js":88,"./byte-efficiency-audit.js":4}],"../audits/byte-efficiency/unused-css-rules":[function(e,t,r){(function(r){"use strict";const n=e("./byte-efficiency-audit.js"),i=e("../../computed/unused-css.js"),a=e("../../lib/i18n/i18n.js"),s={title:"Remove unused CSS",description:"Remove dead rules from stylesheets and defer the loading of CSS not used for above-the-fold content to reduce unnecessary bytes consumed by network activity. [Learn more](https://web.dev/unused-css-rules/)."},o=a.createMessageInstanceIdFn(r,s),l=10240;t.exports=class UnusedCSSRules extends n{static get meta(){return{id:"unused-css-rules",title:o(s.title),description:o(s.description),
scoreDisplayMode:n.SCORING_MODES.NUMERIC,requiredArtifacts:["CSSUsage","URL","devtoolsLogs","traces"]}}static async audit_(e,t,r){return{items:(await i.request({CSSUsage:e.CSSUsage,URL:e.URL,devtoolsLog:e.devtoolsLogs[n.DEFAULT_PASS]},r)).filter(e=>e&&e.wastedBytes>l),headings:[{key:"url",valueType:"url",label:o(a.UIStrings.columnURL)},{key:"totalBytes",valueType:"bytes",label:o(a.UIStrings.columnTransferSize)},{key:"wastedBytes",valueType:"bytes",label:o(a.UIStrings.columnWastedBytes)}]}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/byte-efficiency/unused-css-rules.js")},{"../../computed/unused-css.js":46,"../../lib/i18n/i18n.js":78,"./byte-efficiency-audit.js":4}],"../audits/byte-efficiency/unused-javascript":[function(e,t,r){(function(r){"use strict";const n=e("./byte-efficiency-audit.js"),i=e("../../computed/unused-javascript-summary.js"),a=e("../../computed/js-bundles.js"),s=e("../../lib/i18n/i18n.js"),o={title:"Remove unused JavaScript",
description:"Remove unused JavaScript to reduce bytes consumed by network activity. [Learn more](https://web.dev/unused-javascript/)."},l=s.createMessageInstanceIdFn(r,o),c=20480,u=512;function commonPrefix(e){if(!e.length)return"";const t=e.reduce((e,t)=>e>t?e:t);let r=e.reduce((e,t)=>e>t?t:e);for(;!t.startsWith(r);)r=r.slice(0,-1);return r}function trimCommonPrefix(e,t){return t&&e.startsWith(t)?"…"+e.slice(t.length):e}t.exports=class UnusedJavaScript extends n{static get meta(){return{id:"unused-javascript",title:l(o.title),description:l(o.description),scoreDisplayMode:n.SCORING_MODES.NUMERIC,requiredArtifacts:["JsUsage","ScriptElements","SourceMaps","devtoolsLogs","traces"]}}static async audit_(e,t,r){const o=await a.request(e,r),{unusedThreshold:d=c,bundleSourceUnusedThreshold:m=u}=r.options||{},p=[];for(const[a,s]of Object.entries(e.JsUsage)){const e=t.find(e=>e.url===a);if(!e)continue;const l=o.find(e=>e.script.src===a),c=await i.request({url:a,scriptCoverages:s,bundle:l
},r),u=n.estimateTransferSize(e,c.totalBytes,"Script")/c.totalBytes,h={url:c.url,totalBytes:Math.round(u*c.totalBytes),wastedBytes:Math.round(u*c.wastedBytes),wastedPercent:c.wastedPercent};if(!(h.wastedBytes<=d)){if(l&&c.sourcesWastedBytes){const e=Object.entries(c.sourcesWastedBytes).sort((e,t)=>t[1]-e[1]).slice(0,5).map(([e,t])=>{const r="(unmapped)"===e?l.sizes.unmappedBytes:l.sizes.files[e];return{source:e,unused:Math.round(t*u),total:Math.round(r*u)}}).filter(e=>e.unused>=m),t=commonPrefix([...l.map._sourceInfos.keys()]);h.subItems={type:"subitems",items:e.map(({source:e,unused:r,total:n})=>({source:trimCommonPrefix(e,t),sourceBytes:n,sourceWastedBytes:r}))}}p.push(h)}}return{items:p,headings:[{key:"url",valueType:"url",subItemsHeading:{key:"source",valueType:"code"},label:l(s.UIStrings.columnURL)},{key:"totalBytes",valueType:"bytes",subItemsHeading:{key:"sourceBytes"},label:l(s.UIStrings.columnTransferSize)},{key:"wastedBytes",valueType:"bytes",subItemsHeading:{
key:"sourceWastedBytes"},label:l(s.UIStrings.columnWastedBytes)}]}}},t.exports.UIStrings=o}).call(this,"/lighthouse-core/audits/byte-efficiency/unused-javascript.js")},{"../../computed/js-bundles.js":11,"../../computed/unused-javascript-summary.js":47,"../../lib/i18n/i18n.js":78,"./byte-efficiency-audit.js":4}],"../audits/byte-efficiency/uses-long-cache-ttl":[function(e,t,r){(function(r){"use strict";const n=e("parse-cache-control"),i=e("../audit.js"),a=e("../../lib/network-request.js"),s=e("../../lib/url-shim.js"),o=e("../../lib/statistics.js").linearInterpolation,l=e("../../lib/i18n/i18n.js"),c=e("../../computed/network-records.js"),u={title:"Uses efficient cache policy on static assets",failureTitle:"Serve static assets with an efficient cache policy",description:"A long cache lifetime can speed up repeat visits to your page. [Learn more](https://web.dev/uses-long-cache-ttl/).",displayValue:"{itemCount, plural,\n    =1 {1 resource found}\n    other {# resources found}\n    }"
},d=l.createMessageInstanceIdFn(r,u),m=.925;class CacheHeaders extends i{static get meta(){return{id:"uses-long-cache-ttl",title:d(u.title),failureTitle:d(u.failureTitle),description:d(u.description),scoreDisplayMode:i.SCORING_MODES.NUMERIC,requiredArtifacts:["devtoolsLogs","traces"]}}static get defaultOptions(){return{p10:28672,median:131072}}static getCacheHitProbability(e){const t=[0,.2,1,3,8,12,24,48,72,168,8760,1/0];if(12!==t.length)throw new Error("deciles 0-10 and 1 for overflow");const r=e/3600,n=t.findIndex(e=>e>=r);if(n===t.length-1)return 1;if(0===n)return 0;const i=t[n],a=t[n-1];return o(a,(n-1)/10,i,n/10,r)}static computeCacheLifetimeInSeconds(e,t){if(t&&void 0!==t["max-age"])return t["max-age"];const r=e.get("expires");if(r){const e=new Date(r).getTime();return e?Math.ceil((e-Date.now())/1e3):0}return null}static isCacheableAsset(e){const t=new Set([200,203,206]),r=new Set([a.TYPES.Font,a.TYPES.Image,a.TYPES.Media,a.TYPES.Script,a.TYPES.Stylesheet])
;return!s.NON_NETWORK_PROTOCOLS.includes(e.protocol)&&(t.has(e.statusCode)&&r.has(e.resourceType||"Other"))}static shouldSkipRecord(e,t){return!(t||!(e.get("pragma")||"").includes("no-cache"))||!(!t||!(t["must-revalidate"]||t["no-cache"]||t["no-store"]||t.private))}static audit(e,t){const r=e.devtoolsLogs[i.DEFAULT_PASS];return c.request(r,t).then(e=>{const r=[];let a=0;for(const t of e){if(!CacheHeaders.isCacheableAsset(t))continue;const e=new Map;for(const r of t.responseHeaders||[])if(e.has(r.name.toLowerCase())){const t=e.get(r.name.toLowerCase());e.set(r.name.toLowerCase(),`${t}, ${r.value}`)}else e.set(r.name.toLowerCase(),r.value);const i=n(e.get("cache-control"));if(this.shouldSkipRecord(e,i))continue;let o=CacheHeaders.computeCacheLifetimeInSeconds(e,i);if(null!==o&&(!Number.isFinite(o)||o<=0))continue;o=o||0;const l=CacheHeaders.getCacheHitProbability(o);if(l>m)continue;const c=s.elideDataURI(t.url),u=t.transferSize||0,d=(1-l)*u;let p;a+=d,i&&(p={type:"debugdata",...i}),
r.push({url:c,debugData:p,cacheLifetimeMs:1e3*o,cacheHitProbability:l,totalBytes:u,wastedBytes:d})}r.sort((e,t)=>e.cacheLifetimeMs-t.cacheLifetimeMs||t.totalBytes-e.totalBytes||e.url.localeCompare(t.url));const o=i.computeLogNormalScore({p10:t.options.p10,median:t.options.median},a),c=[{key:"url",itemType:"url",text:d(l.UIStrings.columnURL)},{key:"cacheLifetimeMs",itemType:"ms",text:d(l.UIStrings.columnCacheTTL),displayUnit:"duration"},{key:"totalBytes",itemType:"bytes",text:d(l.UIStrings.columnTransferSize),displayUnit:"kb",granularity:1}],p={wastedBytes:a},h=i.makeTableDetails(c,r,p);return{score:o,numericValue:a,numericUnit:"byte",displayValue:d(u.displayValue,{itemCount:r.length}),details:h}})}}t.exports=CacheHeaders,t.exports.UIStrings=u}).call(this,"/lighthouse-core/audits/byte-efficiency/uses-long-cache-ttl.js")},{"../../computed/network-records.js":40,"../../lib/i18n/i18n.js":78,"../../lib/network-request.js":90,"../../lib/statistics.js":96,"../../lib/url-shim.js":"url",
"../audit.js":3,"parse-cache-control":181}],"../audits/byte-efficiency/uses-optimized-images":[function(e,t,r){(function(r){"use strict";const n=e("./byte-efficiency-audit.js"),i=e("../../lib/url-shim.js"),a=e("../../lib/i18n/i18n.js"),s={title:"Efficiently encode images",description:"Optimized images load faster and consume less cellular data. [Learn more](https://web.dev/uses-optimized-images/)."},o=a.createMessageInstanceIdFn(r,s),l=4096;class UsesOptimizedImages extends n{static get meta(){return{id:"uses-optimized-images",title:o(s.title),description:o(s.description),scoreDisplayMode:n.SCORING_MODES.NUMERIC,requiredArtifacts:["OptimizedImages","ImageElements","devtoolsLogs","traces","URL"]}}static computeSavings(e){const t=e.originalSize-e.jpegSize;return{bytes:t,percent:100*t/e.originalSize}}static estimateJPEGSizeFromDimensions(e){const t=e.naturalWidth*e.naturalHeight;return Math.round(.25*t)}static audit_(e){
const t=e.URL.finalUrl,r=e.OptimizedImages,n=e.ImageElements,s=new Map;n.forEach(e=>s.set(e.src,e));const c=[],u=[];for(const e of r){if(e.failed){u.push(`Unable to decode ${i.getURLDisplayName(e.url)}`);continue}if(!1===/(jpeg|bmp)/.test(e.mimeType))continue;let r=e.jpegSize,n=!0;if(void 0===r){const t=s.get(e.url);if(!t){u.push(`Unable to locate resource ${i.getURLDisplayName(e.url)}`);continue}r=UsesOptimizedImages.estimateJPEGSizeFromDimensions(t),n=!1}if(e.originalSize<r+l)continue;const a=i.elideDataURI(e.url),o=!i.originsMatch(t,e.url),d=UsesOptimizedImages.computeSavings({...e,jpegSize:r});c.push({url:a,fromProtocol:n,isCrossOrigin:o,totalBytes:e.originalSize,wastedBytes:d.bytes})}return{warnings:u,items:c,headings:[{key:"url",valueType:"thumbnail",label:""},{key:"url",valueType:"url",label:o(a.UIStrings.columnURL)},{key:"totalBytes",valueType:"bytes",label:o(a.UIStrings.columnResourceSize)},{key:"wastedBytes",valueType:"bytes",label:o(a.UIStrings.columnWastedBytes)}]}}}
t.exports=UsesOptimizedImages,t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/byte-efficiency/uses-optimized-images.js")},{"../../lib/i18n/i18n.js":78,"../../lib/url-shim.js":"url","./byte-efficiency-audit.js":4}],"../audits/byte-efficiency/uses-responsive-images":[function(e,t,r){(function(r){"use strict";const n=e("./byte-efficiency-audit.js"),i=e("../../lib/sentry.js"),a=e("../../lib/url-shim.js"),s=e("../../lib/i18n/i18n.js"),o={title:"Properly size images",description:"Serve images that are appropriately-sized to save cellular data and improve load time. [Learn more](https://web.dev/uses-responsive-images/)."},l=s.createMessageInstanceIdFn(r,o),c=4096;class UsesResponsiveImages extends n{static get meta(){return{id:"uses-responsive-images",title:l(o.title),description:l(o.description),scoreDisplayMode:n.SCORING_MODES.NUMERIC,requiredArtifacts:["ImageElements","ViewportDimensions","devtoolsLogs","traces"]}}static computeWaste(e,t){if(!e.resourceSize)return null
;let r=e.displayedWidth*e.displayedHeight*Math.pow(t.devicePixelRatio,2);if(!r){const n=t.innerWidth,i=2*t.innerHeight,a=e.naturalWidth/e.naturalHeight;let s=n,o=i;a>n/i?o=n/a:s=i*a,r=s*o*Math.pow(t.devicePixelRatio,2)}const n=a.elideDataURI(e.src),i=1-r/(e.naturalWidth*e.naturalHeight),s=e.resourceSize,o=Math.round(s*i);return Number.isFinite(i)?{url:n,totalBytes:s,wastedBytes:o,wastedPercent:100*i}:new Error(`Invalid image sizing information ${n}`)}static audit_(e){const t=e.ImageElements,r=e.ViewportDimensions,n=[],a=new Map;for(const e of t){if(!e.resourceSize||"image/svg+xml"===e.mimeType||e.isCss)continue;const t=UsesResponsiveImages.computeWaste(e,r);if(!t)continue;if(t instanceof Error){n.push(t.message),i.captureException(t,{tags:{audit:this.meta.id},level:"warning"});continue}const s=a.get(t.url);(!s||s.wastedBytes>t.wastedBytes)&&a.set(t.url,t)}return{warnings:n,items:Array.from(a.values()).filter(e=>e.wastedBytes>c),headings:[{key:"url",valueType:"thumbnail",label:""},{
key:"url",valueType:"url",label:l(s.UIStrings.columnURL)},{key:"totalBytes",valueType:"bytes",label:l(s.UIStrings.columnResourceSize)},{key:"wastedBytes",valueType:"bytes",label:l(s.UIStrings.columnWastedBytes)}]}}}t.exports=UsesResponsiveImages,t.exports.UIStrings=o}).call(this,"/lighthouse-core/audits/byte-efficiency/uses-responsive-images.js")},{"../../lib/i18n/i18n.js":78,"../../lib/sentry.js":93,"../../lib/url-shim.js":"url","./byte-efficiency-audit.js":4}],"../audits/byte-efficiency/uses-text-compression":[function(e,t,r){(function(r){"use strict";const n=e("./byte-efficiency-audit.js"),i=e("../../lib/url-shim.js"),a=e("../../lib/i18n/i18n.js"),s={title:"Enable text compression",description:"Text-based resources should be served with compression (gzip, deflate or brotli) to minimize total network bytes. [Learn more](https://web.dev/uses-text-compression/)."},o=a.createMessageInstanceIdFn(r,s),l=1400,c=.1;t.exports=class ResponsesAreCompressed extends n{static get meta(){return{
id:"uses-text-compression",title:o(s.title),description:o(s.description),scoreDisplayMode:n.SCORING_MODES.NUMERIC,requiredArtifacts:["ResponseCompression","devtoolsLogs","traces"]}}static audit_(e){const t=e.ResponseCompression,r=[];t.forEach(e=>{if(!e.gzipSize||e.gzipSize<0)return;const t=e.resourceSize,n=e.gzipSize,a=t-n;if(1-n/t<c||a<l||e.transferSize<n)return;const s=i.elideDataURI(e.url);r.find(t=>t.url===s&&t.totalBytes===e.resourceSize)||r.push({url:s,totalBytes:t,wastedBytes:a})});const n=[{key:"url",valueType:"url",label:o(a.UIStrings.columnURL)},{key:"totalBytes",valueType:"bytes",label:o(a.UIStrings.columnTransferSize)},{key:"wastedBytes",valueType:"bytes",label:o(a.UIStrings.columnWastedBytes)}];return{items:r,headings:n}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/byte-efficiency/uses-text-compression.js")},{"../../lib/i18n/i18n.js":78,"../../lib/url-shim.js":"url","./byte-efficiency-audit.js":4}],
"../audits/byte-efficiency/uses-webp-images":[function(e,t,r){(function(r){"use strict";const n=e("./byte-efficiency-audit.js"),i=e("../../lib/url-shim.js"),a=e("../../lib/i18n/i18n.js"),s={title:"Serve images in next-gen formats",description:"Image formats like JPEG 2000, JPEG XR, and WebP often provide better compression than PNG or JPEG, which means faster downloads and less data consumption. [Learn more](https://web.dev/uses-webp-images/)."},o=a.createMessageInstanceIdFn(r,s),l=8192;class UsesWebPImages extends n{static get meta(){return{id:"uses-webp-images",title:o(s.title),description:o(s.description),scoreDisplayMode:n.SCORING_MODES.NUMERIC,requiredArtifacts:["OptimizedImages","devtoolsLogs","traces","URL","ImageElements"]}}static computeSavings(e){const t=e.originalSize-e.webpSize;return{bytes:t,percent:100*t/e.originalSize}}static estimateWebPSizeFromDimensions(e){const t=e.naturalWidth*e.naturalHeight;return Math.round(.2*t)}static audit_(e){
const t=e.URL.finalUrl,r=e.OptimizedImages,n=e.ImageElements,s=new Map;n.forEach(e=>s.set(e.src,e));const c=[],u=[];for(const e of r){if(e.failed){u.push(`Unable to decode ${i.getURLDisplayName(e.url)}`);continue}let r=e.webpSize,n=!0;if(void 0===r){const t=s.get(e.url);if(!t){u.push(`Unable to locate resource ${i.getURLDisplayName(e.url)}`);continue}r=UsesWebPImages.estimateWebPSizeFromDimensions(t),n=!1}if(e.originalSize<r+l)continue;const a=i.elideDataURI(e.url),o=!i.originsMatch(t,e.url),d=UsesWebPImages.computeSavings({...e,webpSize:r});c.push({url:a,fromProtocol:n,isCrossOrigin:o,totalBytes:e.originalSize,wastedBytes:d.bytes})}return{warnings:u,items:c,headings:[{key:"url",valueType:"thumbnail",label:""},{key:"url",valueType:"url",label:o(a.UIStrings.columnURL)},{key:"totalBytes",valueType:"bytes",label:o(a.UIStrings.columnResourceSize)},{key:"wastedBytes",valueType:"bytes",label:o(a.UIStrings.columnWastedBytes)}]}}}t.exports=UsesWebPImages,t.exports.UIStrings=s
}).call(this,"/lighthouse-core/audits/byte-efficiency/uses-webp-images.js")},{"../../lib/i18n/i18n.js":78,"../../lib/url-shim.js":"url","./byte-efficiency-audit.js":4}],"../audits/content-width":[function(e,t,r){(function(r){"use strict";const n=e("./audit.js"),i=e("../lib/i18n/i18n.js"),a={title:"Content is sized correctly for the viewport",failureTitle:"Content is not sized correctly for the viewport",description:"If the width of your app's content doesn't match the width of the viewport, your app might not be optimized for mobile screens. [Learn more](https://web.dev/content-width/).",explanation:"The viewport size of {innerWidth}px does not match the window size of {outerWidth}px."},s=i.createMessageInstanceIdFn(r,a);t.exports=class ContentWidth extends n{static get meta(){return{id:"content-width",title:s(a.title),failureTitle:s(a.failureTitle),description:s(a.description),requiredArtifacts:["ViewportDimensions","TestedAsMobileDevice"]}}static audit(e){
const t=e.TestedAsMobileDevice,r=e.ViewportDimensions.innerWidth===e.ViewportDimensions.outerWidth;if(!t)return{score:1,notApplicable:!0};let n;return r||(n=s(a.explanation,{innerWidth:e.ViewportDimensions.innerWidth,outerWidth:e.ViewportDimensions.outerWidth})),{score:Number(r),explanation:n}}},t.exports.UIStrings=a}).call(this,"/lighthouse-core/audits/content-width.js")},{"../lib/i18n/i18n.js":78,"./audit.js":3}],"../audits/critical-request-chains":[function(e,t,r){(function(r){"use strict";const n=e("./audit.js"),i=e("../lib/i18n/i18n.js"),a=e("../computed/critical-request-chains.js"),s={title:"Avoid chaining critical requests",description:"The Critical Request Chains below show you what resources are loaded with a high priority. Consider reducing the length of chains, reducing the download size of resources, or deferring the download of unnecessary resources to improve page load. [Learn more](https://web.dev/critical-request-chains/).",
displayValue:"{itemCount, plural,\n    =1 {1 chain found}\n    other {# chains found}\n    }"},o=i.createMessageInstanceIdFn(r,s);class CriticalRequestChains extends n{static get meta(){return{id:"critical-request-chains",title:o(s.title),description:o(s.description),scoreDisplayMode:n.SCORING_MODES.INFORMATIVE,requiredArtifacts:["devtoolsLogs","URL"]}}static _traverse(e,t){!function walk(e,r,n,i=0){const a=Object.keys(e);0!==a.length&&a.forEach(a=>{const s=e[a];n||(n=s.request.startTime),t({depth:r,id:a,node:s,chainDuration:1e3*(s.request.endTime-n),chainTransferSize:i+s.request.transferSize}),s.children&&walk(s.children,r+1,n)},"")}(e,0)}static _getLongestChain(e){const t={duration:0,length:0,transferSize:0};return CriticalRequestChains._traverse(e,e=>{const r=e.chainDuration;r>t.duration&&(t.duration=r,t.transferSize=e.chainTransferSize,t.length=e.depth)}),t.length++,t}static flattenRequests(e){const t={},r=new Map;return CriticalRequestChains._traverse(e,function flatten(e){
const n=e.node.request,i={url:n.url,startTime:n.startTime,endTime:n.endTime,responseReceivedTime:n.responseReceivedTime,transferSize:n.transferSize};let a=r.get(e.id);if(a?a.request=i:(a={request:i},t[e.id]=a),e.node.children)for(const t of Object.keys(e.node.children)){const e={request:{}};r.set(t,e),a.children||(a.children={}),a.children[t]=e}r.set(e.id,a)}),t}static audit(e,t){const r=e.devtoolsLogs[n.DEFAULT_PASS],i=e.URL;return a.request({devtoolsLog:r,URL:i},t).then(e=>{let t=0;const r=CriticalRequestChains.flattenRequests(e),n=Object.keys(r)[0],i=n&&r[n].children;i&&Object.keys(i).length>0&&function walk(e,r){Object.keys(e).forEach(n=>{const i=e[n];i.children?walk(i.children,r+1):t++},"")}(i,0);const a=CriticalRequestChains._getLongestChain(r);return{score:Number(0===t),notApplicable:0===t,displayValue:t?o(s.displayValue,{itemCount:t}):"",details:{type:"criticalrequestchain",chains:r,longestChain:a}}})}}t.exports=CriticalRequestChains,t.exports.UIStrings=s
}).call(this,"/lighthouse-core/audits/critical-request-chains.js")},{"../computed/critical-request-chains.js":10,"../lib/i18n/i18n.js":78,"./audit.js":3}],"../audits/deprecations":[function(e,t,r){(function(r){"use strict";const n=e("./audit.js"),i=e("../lib/i18n/i18n.js"),a={title:"Avoids deprecated APIs",failureTitle:"Uses deprecated APIs",description:"Deprecated APIs will eventually be removed from the browser. [Learn more](https://web.dev/deprecations/).",displayValue:"{itemCount, plural,\n    =1 {1 warning found}\n    other {# warnings found}\n    }",columnDeprecate:"Deprecation / Warning",columnLine:"Line"},s=i.createMessageInstanceIdFn(r,a);t.exports=class Deprecations extends n{static get meta(){return{id:"deprecations",title:s(a.title),failureTitle:s(a.failureTitle),description:s(a.description),requiredArtifacts:["ConsoleMessages"]}}static audit(e){const t=e.ConsoleMessages.filter(e=>"deprecation"===e.entry.source).map(e=>{let t;if(e.entry.url){
const r=e.entry.stackTrace&&e.entry.stackTrace.callFrames[0],n=e.entry.lineNumber||0,i=r?r.columnNumber:0;t={type:"source-location",url:e.entry.url,urlProvider:"network",line:n,column:i}}return{value:e.entry.text,source:t}}),r=[{key:"value",itemType:"text",text:s(a.columnDeprecate)},{key:"source",itemType:"source-location",text:s(i.UIStrings.columnURL)}],o=n.makeTableDetails(r,t);let l;return t.length>0&&(l=s(a.displayValue,{itemCount:t.length})),{score:Number(0===t.length),displayValue:l,details:o}}},t.exports.UIStrings=a}).call(this,"/lighthouse-core/audits/deprecations.js")},{"../lib/i18n/i18n.js":78,"./audit.js":3}],"../audits/diagnostics":[function(e,t,r){"use strict";const n=e("./audit.js"),i=e("../computed/main-thread-tasks.js"),a=e("../computed/network-records.js"),s=e("../computed/network-analysis.js"),o=e("../lib/dependency-graph/simulator/network-analyzer.js");t.exports=class Diagnostics extends n{static get meta(){return{id:"diagnostics",
scoreDisplayMode:n.SCORING_MODES.INFORMATIVE,title:"Diagnostics",description:"Collection of useful page vitals.",requiredArtifacts:["traces","devtoolsLogs"]}}static async audit(e,t){const r=e.traces[n.DEFAULT_PASS],l=e.devtoolsLogs[n.DEFAULT_PASS],c=await i.request(r,t),u=await a.request(l,t),d=await s.request(l,t),m=c.filter(e=>!e.parent),p=o.findMainDocument(u).transferSize,h=u.reduce((e,t)=>e+(t.transferSize||0),0),g=m.reduce((e,t)=>e+(t.duration||0),0),f=Math.max(...d.additionalRttByOrigin.values())+d.rtt,b=Math.max(...d.serverResponseTimeByOrigin.values());return{score:1,details:{type:"debugdata",items:[{numRequests:u.length,numScripts:u.filter(e=>"Script"===e.resourceType).length,numStylesheets:u.filter(e=>"Stylesheet"===e.resourceType).length,numFonts:u.filter(e=>"Font"===e.resourceType).length,numTasks:m.length,numTasksOver10ms:m.filter(e=>e.duration>10).length,numTasksOver25ms:m.filter(e=>e.duration>25).length,numTasksOver50ms:m.filter(e=>e.duration>50).length,
numTasksOver100ms:m.filter(e=>e.duration>100).length,numTasksOver500ms:m.filter(e=>e.duration>500).length,rtt:d.rtt,throughput:d.throughput,maxRtt:f,maxServerLatency:b,totalByteWeight:h,totalTaskTime:g,mainDocumentTransferSize:p}]}}}}},{"../computed/main-thread-tasks.js":14,"../computed/network-analysis.js":39,"../computed/network-records.js":40,"../lib/dependency-graph/simulator/network-analyzer.js":74,"./audit.js":3}],"../audits/dobetterweb/appcache-manifest":[function(e,t,r){(function(r){"use strict";const n=e("../audit.js"),i=e("../../lib/i18n/i18n.js"),a={title:"Avoids Application Cache",failureTitle:"Uses Application Cache",description:"Application Cache is deprecated. [Learn more](https://web.dev/appcache-manifest/).",displayValue:'Found "{AppCacheManifest}"'},s=i.createMessageInstanceIdFn(r,a);t.exports=class AppCacheManifestAttr extends n{static get meta(){return{id:"appcache-manifest",title:s(a.title),failureTitle:s(a.failureTitle),description:s(a.description),
requiredArtifacts:["AppCacheManifest"]}}static audit(e){return null!==e.AppCacheManifest?{score:0,displayValue:s(a.displayValue,{AppCacheManifest:e.AppCacheManifest})}:{score:1}}},t.exports.UIStrings=a}).call(this,"/lighthouse-core/audits/dobetterweb/appcache-manifest.js")},{"../../lib/i18n/i18n.js":78,"../audit.js":3}],"../audits/dobetterweb/charset":[function(e,t,r){(function(r){"use strict";const n=e("../audit.js"),i=e("../../lib/i18n/i18n.js"),a=e("../../computed/main-resource.js"),s={title:"Properly defines charset",failureTitle:"Charset declaration is missing or occurs too late in the HTML",description:"A character encoding declaration is required. It can be done with a `<meta>` tag in the first 1024 bytes of the HTML or in the Content-Type HTTP response header. [Learn more](https://web.dev/charset/)."},o=i.createMessageInstanceIdFn(r,s),l="content-type",c=/^[a-zA-Z0-9-_:.()]{2,}$/,u=/<meta[^>]+charset[^<]+>/i,d=/charset\s*=\s*[a-zA-Z0-9-_:.()]{2,}/i
;t.exports=class CharsetDefined extends n{static get meta(){return{id:"charset",title:o(s.title),failureTitle:o(s.failureTitle),description:o(s.description),requiredArtifacts:["MainDocumentContent","URL","devtoolsLogs","MetaElements"]}}static async audit(e,t){const r=e.devtoolsLogs[n.DEFAULT_PASS],i=await a.request({devtoolsLog:r,URL:e.URL},t);let s=!1;if(i.responseHeaders){const e=i.responseHeaders.find(e=>e.name.toLowerCase()===l);e&&(s=d.test(e.value))}return s=s||65279===e.MainDocumentContent.charCodeAt(0),u.test(e.MainDocumentContent.slice(0,1024))&&(s=s||e.MetaElements.some(e=>e.charset&&c.test(e.charset)||"content-type"===e.httpEquiv&&e.content&&d.test(e.content))),{score:Number(s)}}},t.exports.UIStrings=s,t.exports.CHARSET_HTML_REGEX=u,t.exports.CHARSET_HTTP_REGEX=d,t.exports.IANA_REGEX=c}).call(this,"/lighthouse-core/audits/dobetterweb/charset.js")},{"../../computed/main-resource.js":13,"../../lib/i18n/i18n.js":78,"../audit.js":3}],
"../audits/dobetterweb/doctype":[function(e,t,r){(function(r){"use strict";const n=e("../audit.js"),i=e("../../lib/i18n/i18n.js"),a={title:"Page has the HTML doctype",failureTitle:"Page lacks the HTML doctype, thus triggering quirks-mode",description:"Specifying a doctype prevents the browser from switching to quirks-mode. [Learn more](https://web.dev/doctype/).",explanationNoDoctype:"Document must contain a doctype",explanationPublicId:"Expected publicId to be an empty string",explanationSystemId:"Expected systemId to be an empty string",explanationBadDoctype:"Doctype name must be the lowercase string `html`"},s=i.createMessageInstanceIdFn(r,a);t.exports=class Doctype extends n{static get meta(){return{id:"doctype",title:s(a.title),failureTitle:s(a.failureTitle),description:s(a.description),requiredArtifacts:["Doctype"]}}static audit(e){if(!e.Doctype)return{score:0,explanation:s(a.explanationNoDoctype)};const t=e.Doctype.name.trim(),r=e.Doctype.publicId,n=e.Doctype.systemId
;return""!==r?{score:0,explanation:s(a.explanationPublicId)}:""!==n?{score:0,explanation:s(a.explanationSystemId)}:"html"===t?{score:1}:{score:0,explanation:s(a.explanationBadDoctype)}}},t.exports.UIStrings=a}).call(this,"/lighthouse-core/audits/dobetterweb/doctype.js")},{"../../lib/i18n/i18n.js":78,"../audit.js":3}],"../audits/dobetterweb/dom-size":[function(e,t,r){(function(r){"use strict";const n=e("../audit.js"),i=e("../../report/html/renderer/i18n.js"),a=e("../../lib/i18n/i18n.js"),s={title:"Avoids an excessive DOM size",failureTitle:"Avoid an excessive DOM size",description:"A large DOM will increase memory usage, cause longer [style calculations](https://developers.google.com/web/fundamentals/performance/rendering/reduce-the-scope-and-complexity-of-style-calculations), and produce costly [layout reflows](https://developers.google.com/speed/articles/reflow). [Learn more](https://web.dev/dom-size/).",columnStatistic:"Statistic",columnValue:"Value",
displayValue:"{itemCount, plural,\n    =1 {1 element}\n    other {# elements}\n    }",statisticDOMElements:"Total DOM Elements",statisticDOMDepth:"Maximum DOM Depth",statisticDOMWidth:"Maximum Child Elements"},o=a.createMessageInstanceIdFn(r,s);t.exports=class DOMSize extends n{static get meta(){return{id:"dom-size",title:o(s.title),failureTitle:o(s.failureTitle),description:o(s.description),scoreDisplayMode:n.SCORING_MODES.NUMERIC,requiredArtifacts:["DOMStats"]}}static get defaultOptions(){return{p10:818,median:1400}}static audit(e,t){const r=e.DOMStats,l=n.computeLogNormalScore({p10:t.options.p10,median:t.options.median},r.totalBodyElements),c=[{key:"statistic",itemType:"text",text:o(s.columnStatistic)},{key:"element",itemType:"code",text:o(a.UIStrings.columnElement)},{key:"value",itemType:"numeric",text:o(s.columnValue)}],u=new i(t.settings.locale),d=[{statistic:o(s.statisticDOMElements),element:"",value:u.formatNumber(r.totalBodyElements)},{statistic:o(s.statisticDOMDepth),
element:{type:"code",value:r.depth.snippet},value:u.formatNumber(r.depth.max)},{statistic:o(s.statisticDOMWidth),element:{type:"code",value:r.width.snippet},value:u.formatNumber(r.width.max)}];return{score:l,numericValue:r.totalBodyElements,numericUnit:"element",displayValue:o(s.displayValue,{itemCount:r.totalBodyElements}),details:n.makeTableDetails(c,d)}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/dobetterweb/dom-size.js")},{"../../lib/i18n/i18n.js":78,"../../report/html/renderer/i18n.js":104,"../audit.js":3}],"../audits/dobetterweb/external-anchors-use-rel-noopener":[function(e,t,r){(function(r){"use strict";const n=e("../../lib/url-shim.js"),i=e("../audit.js"),a=e("../../lib/i18n/i18n.js"),s={title:"Links to cross-origin destinations are safe",failureTitle:"Links to cross-origin destinations are unsafe",
description:'Add `rel="noopener"` or `rel="noreferrer"` to any external links to improve performance and prevent security vulnerabilities. [Learn more](https://web.dev/external-anchors-use-rel-noopener/).',warning:"Unable to determine the destination for anchor ({anchorHTML}). If not used as a hyperlink, consider removing target=_blank.",columnFailingAnchors:"Failing Anchors"},o=a.createMessageInstanceIdFn(r,s);t.exports=class ExternalAnchorsUseRelNoopenerAudit extends i{static get meta(){return{id:"external-anchors-use-rel-noopener",title:o(s.title),failureTitle:o(s.failureTitle),description:o(s.description),requiredArtifacts:["URL","AnchorElements"]}}static audit(e){const t=[],r=new n(e.URL.finalUrl).host,a=e.AnchorElements.filter(e=>"_blank"===e.target&&!e.rel.includes("noopener")&&!e.rel.includes("noreferrer")).filter(e=>{try{return new n(e.href).host!==r}catch(r){return t.push(o(s.warning,{anchorHTML:e.snippet})),!0}
}).filter(e=>!e.href||e.href.toLowerCase().startsWith("http")).map(e=>({node:{type:"node",path:e.devtoolsNodePath||"",selector:e.selector||"",nodeLabel:e.nodeLabel||"",snippet:e.snippet||""},href:e.href||"Unknown",target:e.target||"",rel:e.rel||"",outerHTML:e.snippet||""})),l=[{key:"node",itemType:"node",text:o(s.columnFailingAnchors)}],c=i.makeTableDetails(l,a);return{score:Number(0===a.length),details:c,warnings:t}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/dobetterweb/external-anchors-use-rel-noopener.js")},{"../../lib/i18n/i18n.js":78,"../../lib/url-shim.js":"url","../audit.js":3}],"../audits/dobetterweb/geolocation-on-start":[function(e,t,r){(function(r){"use strict";const n=e("../violation-audit.js"),i=e("../../lib/i18n/i18n.js"),a={title:"Avoids requesting the geolocation permission on page load",failureTitle:"Requests the geolocation permission on page load",
description:"Users are mistrustful of or confused by sites that request their location without context. Consider tying the request to a user action instead. [Learn more](https://web.dev/geolocation-on-start/)."},s=i.createMessageInstanceIdFn(r,a);t.exports=class GeolocationOnStart extends n{static get meta(){return{id:"geolocation-on-start",title:s(a.title),failureTitle:s(a.failureTitle),description:s(a.description),requiredArtifacts:["ConsoleMessages"]}}static audit(e){const t=n.getViolationResults(e,/geolocation/),r=[{key:"url",itemType:"url",text:s(i.UIStrings.columnURL)},{key:"label",itemType:"text",text:s(i.UIStrings.columnLocation)}],a=n.makeTableDetails(r,t);return{score:Number(0===t.length),details:a}}},t.exports.UIStrings=a}).call(this,"/lighthouse-core/audits/dobetterweb/geolocation-on-start.js")},{"../../lib/i18n/i18n.js":78,"../violation-audit.js":8}],"../audits/dobetterweb/js-libraries":[function(e,t,r){(function(r){"use strict"
;const n=e("../audit.js"),i=e("../../lib/i18n/i18n.js"),a={title:"Detected JavaScript libraries",description:"All front-end JavaScript libraries detected on the page. [Learn more](https://web.dev/js-libraries/).",columnVersion:"Version"},s=i.createMessageInstanceIdFn(r,a);t.exports=class JsLibrariesAudit extends n{static get meta(){return{id:"js-libraries",title:s(a.title),description:s(a.description),requiredArtifacts:["Stacks"]}}static audit(e){const t=e.Stacks.filter(e=>"js"===e.detector).filter(e=>!e.id.endsWith("-fast")).map(e=>({name:e.name,version:e.version,npm:e.npm})),r=[{key:"name",itemType:"text",text:s(i.UIStrings.columnName)},{key:"version",itemType:"text",text:s(a.columnVersion)}];return{score:1,details:{...n.makeTableDetails(r,t,{}),debugData:{type:"debugdata",stacks:e.Stacks.map(e=>({id:e.id,version:e.version}))}}}}},t.exports.UIStrings=a}).call(this,"/lighthouse-core/audits/dobetterweb/js-libraries.js")},{"../../lib/i18n/i18n.js":78,"../audit.js":3}],
"../audits/dobetterweb/no-document-write":[function(e,t,r){(function(r){"use strict";const n=e("../violation-audit.js"),i=e("../../lib/i18n/i18n.js"),a={title:"Avoids `document.write()`",failureTitle:"Avoid `document.write()`",description:"For users on slow connections, external scripts dynamically injected via `document.write()` can delay page load by tens of seconds. [Learn more](https://web.dev/no-document-write/)."},s=i.createMessageInstanceIdFn(r,a);t.exports=class NoDocWriteAudit extends n{static get meta(){return{id:"no-document-write",title:s(a.title),failureTitle:s(a.failureTitle),description:s(a.description),requiredArtifacts:["ConsoleMessages"]}}static audit(e){const t=n.getViolationResults(e,/document\.write/),r=[{key:"url",itemType:"url",text:s(i.UIStrings.columnURL)},{key:"label",itemType:"text",text:s(i.UIStrings.columnLocation)}],a=n.makeTableDetails(r,t);return{score:Number(0===t.length),details:a}}},t.exports.UIStrings=a
}).call(this,"/lighthouse-core/audits/dobetterweb/no-document-write.js")},{"../../lib/i18n/i18n.js":78,"../violation-audit.js":8}],"../audits/dobetterweb/no-vulnerable-libraries":[function(e,t,r){(function(r){"use strict";const n=e("../audit.js"),i=e("../../lib/sentry.js"),a=e("semver"),s=e("../../../third-party/snyk/snapshot.json"),o=e("../../lib/i18n/i18n.js"),l={title:"Avoids front-end JavaScript libraries with known security vulnerabilities",failureTitle:"Includes front-end JavaScript libraries with known security vulnerabilities",description:"Some third-party scripts may contain known security vulnerabilities that are easily identified and exploited by attackers. [Learn more](https://web.dev/no-vulnerable-libraries/).",displayValue:"{itemCount, plural,\n    =1 {1 vulnerability detected}\n    other {# vulnerabilities detected}\n    }",columnVersion:"Library Version",columnVuln:"Vulnerability Count",columnSeverity:"Highest Severity",rowSeverityLow:"Low",rowSeverityMedium:"Medium",
rowSeverityHigh:"High"},c=o.createMessageInstanceIdFn(r,l),u=/^(\d+\.\d+\.\d+)[^-0-9]+/,d={low:c(l.rowSeverityLow),medium:c(l.rowSeverityMedium),high:c(l.rowSeverityHigh)};class NoVulnerableLibrariesAudit extends n{static get meta(){return{id:"no-vulnerable-libraries",title:c(l.title),failureTitle:c(l.failureTitle),description:c(l.description),requiredArtifacts:["Stacks"]}}static get snykDB(){return s}static get severityMap(){return{high:3,medium:2,low:1}}static normalizeVersion(e){if(!e)return e;if(a.valid(e))return e;if(/^\d+\.\d+$/.test(e))return`${e}.0`;const t=e.match(u);return t?t[1]:e}static getVulnerabilities(e,t,r){if(!t.npm||!r.npm[t.npm])return[];try{a.satisfies(e,"*")}catch(e){return e.pkgName=t.npm,i.captureException(e,{level:"warning"}),[]}return r.npm[t.npm].filter(t=>{return t.semver.vulnerable.some(t=>a.satisfies(e,t))}).map(r=>({severity:d[r.severity],numericSeverity:this.severityMap[r.severity],library:`${t.name}@${e}`,url:"https://snyk.io/vuln/"+r.id}))}
static highestSeverity(e){return e.sort((e,t)=>t.numericSeverity-e.numericSeverity)[0].severity}static audit(e){const t=e.Stacks.filter(e=>"js"===e.detector),r=NoVulnerableLibrariesAudit.snykDB;if(!t.length)return{score:1};let i=0;const a=[];for(const e of t){const t=this.normalizeVersion(e.version)||"",n=this.getVulnerabilities(t,e,r),s=n.length;let o;i+=s,n.length>0&&(o=this.highestSeverity(n),a.push({highestSeverity:o,vulnCount:s,detectedLib:{text:e.name+"@"+t,url:`https://snyk.io/vuln/npm:${e.npm}?lh=${t}&utm_source=lighthouse&utm_medium=ref&utm_campaign=audit`,type:"link"}}))}let s;i>0&&(s=c(l.displayValue,{itemCount:i}));const o=[{key:"detectedLib",itemType:"link",text:c(l.columnVersion)},{key:"vulnCount",itemType:"text",text:c(l.columnVuln)},{key:"highestSeverity",itemType:"text",text:c(l.columnSeverity)}],u=n.makeTableDetails(o,a,{});return{score:Number(0===i),displayValue:s,details:u}}}t.exports=NoVulnerableLibrariesAudit,t.exports.UIStrings=l
}).call(this,"/lighthouse-core/audits/dobetterweb/no-vulnerable-libraries.js")},{"../../../third-party/snyk/snapshot.json":220,"../../lib/i18n/i18n.js":78,"../../lib/sentry.js":93,"../audit.js":3,semver:205}],"../audits/dobetterweb/notification-on-start":[function(e,t,r){(function(r){"use strict";const n=e("../violation-audit.js"),i=e("../../lib/i18n/i18n.js"),a={title:"Avoids requesting the notification permission on page load",failureTitle:"Requests the notification permission on page load",description:"Users are mistrustful of or confused by sites that request to send notifications without context. Consider tying the request to user gestures instead. [Learn more](https://web.dev/notification-on-start/)."},s=i.createMessageInstanceIdFn(r,a);t.exports=class NotificationOnStart extends n{static get meta(){return{id:"notification-on-start",title:s(a.title),failureTitle:s(a.failureTitle),description:s(a.description),requiredArtifacts:["ConsoleMessages"]}}static audit(e){
const t=n.getViolationResults(e,/notification permission/),r=[{key:"url",itemType:"url",text:s(i.UIStrings.columnURL)},{key:"label",itemType:"text",text:s(i.UIStrings.columnLocation)}],a=n.makeTableDetails(r,t);return{score:Number(0===t.length),details:a}}},t.exports.UIStrings=a}).call(this,"/lighthouse-core/audits/dobetterweb/notification-on-start.js")},{"../../lib/i18n/i18n.js":78,"../violation-audit.js":8}],"../audits/dobetterweb/password-inputs-can-be-pasted-into":[function(e,t,r){(function(r){"use strict";const n=e("../audit.js"),i=e("../../lib/i18n/i18n.js"),a={title:"Allows users to paste into password fields",failureTitle:"Prevents users to paste into password fields",description:"Preventing password pasting undermines good security policy. [Learn more](https://web.dev/password-inputs-can-be-pasted-into/)."},s=i.createMessageInstanceIdFn(r,a);t.exports=class PasswordInputsCanBePastedIntoAudit extends n{static get meta(){return{id:"password-inputs-can-be-pasted-into",
title:s(a.title),failureTitle:s(a.failureTitle),description:s(a.description),requiredArtifacts:["PasswordInputsWithPreventedPaste"]}}static audit(e){const t=e.PasswordInputsWithPreventedPaste,r=[];t.forEach(e=>{r.push({node:{type:"node",snippet:e.snippet,path:e.devtoolsNodePath}})});const a=[{key:"node",itemType:"node",text:s(i.UIStrings.columnFailingElem)}];return{score:Number(0===t.length),details:n.makeTableDetails(a,r)}}},t.exports.UIStrings=a}).call(this,"/lighthouse-core/audits/dobetterweb/password-inputs-can-be-pasted-into.js")},{"../../lib/i18n/i18n.js":78,"../audit.js":3}],"../audits/dobetterweb/uses-http2":[function(e,t,r){(function(r){"use strict"
;const n=e("../audit.js"),i=e("../../lib/third-party-web.js"),a=e("../byte-efficiency/byte-efficiency-audit.js"),s=e("../../computed/metrics/lantern-interactive.js"),o=e("../../lib/network-request.js"),l=e("../../computed/network-records.js"),c=e("../../computed/load-simulator.js"),u=e("../../computed/page-dependency-graph.js"),d=e("../../lib/i18n/i18n.js"),m={title:"Use HTTP/2",description:"HTTP/2 offers many benefits over HTTP/1.1, including binary headers, multiplexing, and server push. [Learn more](https://web.dev/uses-http2/).",displayValue:"{itemCount, plural,\n    =1 {1 request not served via HTTP/2}\n    other {# requests not served via HTTP/2}\n    }",columnProtocol:"Protocol"},p=d.createMessageInstanceIdFn(r,m),h=new Set([o.TYPES.Document,o.TYPES.Font,o.TYPES.Image,o.TYPES.Stylesheet,o.TYPES.Script,o.TYPES.Media]);class UsesHTTP2Audit extends n{static get meta(){return{id:"uses-http2",title:p(m.title),description:p(m.description),
requiredArtifacts:["URL","devtoolsLogs","traces"]}}static computeWasteWithTTIGraph(e,t,r){const n=new Set(e.map(e=>e.url)),i=r.simulate(t,{label:"uses-http2-before",flexibleOrdering:!0}),a=new Map;t.traverse(e=>{"network"===e.type&&n.has(e.record.url)&&(a.set(e.record.requestId,e.record.protocol),e.record.protocol="h2")});const o=r.simulate(t,{label:"uses-http2-after",flexibleOrdering:!0});t.traverse(e=>{if("network"!==e.type)return;const t=a.get(e.record.requestId);void 0!==t&&(e.record.protocol=t)});const l=i.timeInMs-o.timeInMs,c=s.getLastLongTaskEndTime(i.nodeTimings)-s.getLastLongTaskEndTime(o.nodeTimings),u=Math.max(c,l);return 10*Math.round(Math.max(u,0)/10)}static isStaticAsset(e){if(!h.has(e.resourceType))return!1;if(e.resourceSize<100){if(i.getEntity(e.url))return!1}return!0}static determineNonHttp2Resources(e){const t=[],r=new Set,n=new Map;for(const t of e){if(!UsesHTTP2Audit.isStaticAsset(t))continue;const e=n.get(t.parsedURL.securityOrigin)||[];e.push(t),
n.set(t.parsedURL.securityOrigin,e)}for(const i of e){if(r.has(i.url))continue;if(i.fetchedViaServiceWorker)continue;/HTTP\/[01][.\d]?/i.test(i.protocol)&&((n.get(i.parsedURL.securityOrigin)||[]).length<6||(r.add(i.url),t.push({protocol:i.protocol,url:i.url})))}return t}static async audit(e,t){const r=e.traces[n.DEFAULT_PASS],i=e.devtoolsLogs[n.DEFAULT_PASS],s={devtoolsLog:i,settings:t&&t.settings||{}},o=await l.request(i,t),h=await u.request({trace:r,devtoolsLog:i},t),g=await c.request(s,t),f=UsesHTTP2Audit.determineNonHttp2Resources(o),b=UsesHTTP2Audit.computeWasteWithTTIGraph(f,h,g);let y;f.length>0&&(y=p(m.displayValue,{itemCount:f.length}));const v=[{key:"url",valueType:"url",label:p(d.UIStrings.columnURL)},{key:"protocol",valueType:"text",label:p(m.columnProtocol)}],w=n.makeOpportunityDetails(v,f,b);return{displayValue:y,numericValue:b,numericUnit:"millisecond",score:a.scoreForWastedMs(b),details:w}}}t.exports=UsesHTTP2Audit,t.exports.UIStrings=m
}).call(this,"/lighthouse-core/audits/dobetterweb/uses-http2.js")},{"../../computed/load-simulator.js":12,"../../computed/metrics/lantern-interactive.js":26,"../../computed/network-records.js":40,"../../computed/page-dependency-graph.js":41,"../../lib/i18n/i18n.js":78,"../../lib/network-request.js":90,"../../lib/third-party-web.js":98,"../audit.js":3,"../byte-efficiency/byte-efficiency-audit.js":4}],"../audits/dobetterweb/uses-passive-event-listeners":[function(e,t,r){(function(r){"use strict";const n=e("../violation-audit.js"),i=e("../../lib/i18n/i18n.js"),a={title:"Uses passive listeners to improve scrolling performance",failureTitle:"Does not use passive listeners to improve scrolling performance",description:"Consider marking your touch and wheel event listeners as `passive` to improve your page's scroll performance. [Learn more](https://web.dev/uses-passive-event-listeners/)."},s=i.createMessageInstanceIdFn(r,a);t.exports=class PassiveEventsAudit extends n{static get meta(){
return{id:"uses-passive-event-listeners",title:s(a.title),failureTitle:s(a.failureTitle),description:s(a.description),requiredArtifacts:["ConsoleMessages"]}}static audit(e){const t=n.getViolationResults(e,/passive event listener/),r=[{key:"url",itemType:"url",text:s(i.UIStrings.columnURL)},{key:"label",itemType:"text",text:s(i.UIStrings.columnLocation)}],a=n.makeTableDetails(r,t);return{score:Number(0===t.length),details:a}}},t.exports.UIStrings=a}).call(this,"/lighthouse-core/audits/dobetterweb/uses-passive-event-listeners.js")},{"../../lib/i18n/i18n.js":78,"../violation-audit.js":8}],"../audits/errors-in-console":[function(e,t,r){(function(r){"use strict";const n=e("lighthouse-logger"),i=e("./audit.js"),a=e("../lib/i18n/i18n.js"),s={title:"No browser errors logged to the console",failureTitle:"Browser errors were logged to the console",
description:"Errors logged to the console indicate unresolved problems. They can come from network request failures and other browser concerns. [Learn more](https://web.dev/errors-in-console/)",columnDesc:"Description"},o=a.createMessageInstanceIdFn(r,s);class ErrorLogs extends i{static get meta(){return{id:"errors-in-console",title:o(s.title),failureTitle:o(s.failureTitle),description:o(s.description),requiredArtifacts:["ConsoleMessages","RuntimeExceptions"]}}static defaultOptions(){return{}}static filterAccordingToOptions(e,t){const{ignoredPatterns:r,...i}=t,a=Object.keys(i);return a.length&&n.warn(this.meta.id,"Unrecognized options",a),r?e.filter(({description:e})=>{if(!e)return!0;for(const t of r){if(t instanceof RegExp&&t.test(e))return!1;if("string"==typeof t&&e.includes(t))return!1}return!0}):e}static audit(e,t){const r=t.options,n=e.ConsoleMessages,l=e.RuntimeExceptions,c=n.filter(e=>e.entry&&"error"===e.entry.level).map(e=>({source:e.entry.source,description:e.entry.text,
url:e.entry.url})),u=l.filter(e=>void 0!==e.exceptionDetails).map(e=>{return{source:"Runtime.exception",description:e.exceptionDetails.exception?e.exceptionDetails.exception.description:e.exceptionDetails.text,url:e.exceptionDetails.url}}),d=ErrorLogs.filterAccordingToOptions(c.concat(u),r).sort((e,t)=>(e.description||"").localeCompare(t.description||"")),m=[{key:"url",itemType:"url",text:o(a.UIStrings.columnURL)},{key:"description",itemType:"code",text:o(s.columnDesc)}],p=i.makeTableDetails(m,d),h=d.length;return{score:Number(0===h),details:p}}}t.exports=ErrorLogs,t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/errors-in-console.js")},{"../lib/i18n/i18n.js":78,"./audit.js":3,"lighthouse-logger":141}],"../audits/final-screenshot":[function(e,t,r){"use strict";const n=e("./audit.js"),i=e("../lib/lh-error.js"),a=e("../computed/trace-of-tab.js"),s=e("../computed/screenshots.js");t.exports=class FinalScreenshot extends n{static get meta(){return{id:"final-screenshot",
scoreDisplayMode:n.SCORING_MODES.INFORMATIVE,title:"Final Screenshot",description:"The last screenshot captured of the pageload.",requiredArtifacts:["traces"]}}static async audit(e,t){const r=e.traces[n.DEFAULT_PASS],o=await a.request(r,t),l=await s.request(r,t),{timeOrigin:c}=o.timestamps,u=l[l.length-1];if(!u)throw new i(i.errors.NO_SCREENSHOTS);return{score:1,details:{type:"screenshot",timing:Math.round((u.timestamp-c)/1e3),timestamp:u.timestamp,data:u.datauri}}}}},{"../computed/screenshots.js":43,"../computed/trace-of-tab.js":45,"../lib/lh-error.js":86,"./audit.js":3}],"../audits/font-display":[function(e,t,r){(function(r){"use strict";const n=e("./audit.js"),i=e("../lib/url-shim.js"),a=/^(block|fallback|optional|swap)$/,s=/url\((.*?)\)/,o=new RegExp(s,"g"),l=e("../lib/i18n/i18n.js"),c=e("../lib/sentry.js"),u=e("../computed/network-records.js"),d={title:"All text remains visible during webfont loads",failureTitle:"Ensure text remains visible during webfont load",
description:"Leverage the font-display CSS feature to ensure text is user-visible while webfonts are loading. [Learn more](https://web.dev/font-display/).",undeclaredFontOriginWarning:"{fontCountForOrigin, plural, =1 {Lighthouse was unable to automatically check the `font-display` value for the origin {fontOrigin}.} other {Lighthouse was unable to automatically check the `font-display` values for the origin {fontOrigin}.}}"},m=l.createMessageInstanceIdFn(r,d);class FontDisplay extends n{static get meta(){return{id:"font-display",title:m(d.title),failureTitle:m(d.failureTitle),description:m(d.description),requiredArtifacts:["devtoolsLogs","CSSUsage","URL"]}}static findFontDisplayDeclarations(e,t){const r=new Set,n=new Set;for(const a of e.CSSUsage.stylesheets){const l=a.content.replace(/(\r|\n)+/g," ").match(/@font-face\s*{(.*?)}/g)||[];for(const u of l){const l=u.match(o);if(!l)continue
;const d=u.match(/font-display\s*:\s*(\w+)\s*(;|\})/),m=d&&d[1]||"",p=t.test(m)?r:n,h=l.map(e=>e.match(s)[1].trim()).map(e=>/^('|").*\1$/.test(e)?e.substr(1,e.length-2):e);for(const t of h)try{const r=i.isValid(a.header.sourceURL)?a.header.sourceURL:e.URL.finalUrl,n=new i(t,r);p.add(n.href)}catch(e){c.captureException(e,{tags:{audit:this.meta.id}})}}}return{passingURLs:r,failingURLs:n}}static getWarningsForFontUrls(e){const t=new Map;for(const r of e){const e=i.getOrigin(r);if(!e)continue;const n=t.get(e)||0;t.set(e,n+1)}return[...t].map(([e,t])=>m(d.undeclaredFontOriginWarning,{fontCountForOrigin:t,fontOrigin:e}))}static async audit(e,t){const r=e.devtoolsLogs[this.DEFAULT_PASS],i=await u.request(r,t),{passingURLs:s,failingURLs:o}=FontDisplay.findFontDisplayDeclarations(e,a),c=[],d=i.filter(e=>"Font"===e.resourceType).filter(e=>!/^data:/.test(e.url)).filter(e=>!/^blob:/.test(e.url)).filter(e=>!!o.has(e.url)||(s.has(e.url)||c.push(e.url),!1)).map(e=>{
const t=Math.min(1e3*(e.endTime-e.startTime),3e3);return{url:e.url,wastedMs:t}}),p=[{key:"url",itemType:"url",text:m(l.UIStrings.columnURL)},{key:"wastedMs",itemType:"ms",text:m(l.UIStrings.columnWastedMs)}],h=n.makeTableDetails(p,d);return{score:Number(0===d.length),details:h,warnings:FontDisplay.getWarningsForFontUrls(c)}}}t.exports=FontDisplay,t.exports.UIStrings=d}).call(this,"/lighthouse-core/audits/font-display.js")},{"../computed/network-records.js":40,"../lib/i18n/i18n.js":78,"../lib/sentry.js":93,"../lib/url-shim.js":"url","./audit.js":3}],"../audits/full-page-screenshot":[function(e,t,r){"use strict";const n=e("./audit.js");t.exports=class FullPageScreenshot extends n{static get meta(){return{id:"full-page-screenshot",scoreDisplayMode:n.SCORING_MODES.INFORMATIVE,title:"Full-page screenshot",description:"A full-height screenshot of the final rendered page",requiredArtifacts:["FullPageScreenshot"]}}static async audit(e){return e.FullPageScreenshot?{score:1,details:{
type:"full-page-screenshot",...e.FullPageScreenshot}}:{score:0,notApplicable:!0}}}},{"./audit.js":3}],"../audits/image-aspect-ratio":[function(e,t,r){(function(r){"use strict";const n=e("./audit.js"),i=e("../lib/url-shim.js"),a=e("../lib/i18n/i18n.js"),s={title:"Displays images with correct aspect ratio",failureTitle:"Displays images with incorrect aspect ratio",description:"Image display dimensions should match natural aspect ratio. [Learn more](https://web.dev/image-aspect-ratio/).",warningCompute:"Invalid image sizing information {url}",columnDisplayed:"Aspect Ratio (Displayed)",columnActual:"Aspect Ratio (Actual)"},o=a.createMessageInstanceIdFn(r,s),l=2;class ImageAspectRatio extends n{static get meta(){return{id:"image-aspect-ratio",title:o(s.title),failureTitle:o(s.failureTitle),description:o(s.description),requiredArtifacts:["ImageElements"]}}static computeAspectRatios(e){
const t=i.elideDataURI(e.src),r=e.naturalWidth/e.naturalHeight,n=e.displayedWidth/e.displayedHeight,a=e.displayedWidth/r,c=Math.abs(a-e.displayedHeight)<l;return Number.isFinite(r)&&Number.isFinite(n)?{url:t,displayedAspectRatio:`${e.displayedWidth} x ${e.displayedHeight}\n        (${n.toFixed(2)})`,actualAspectRatio:`${e.naturalWidth} x ${e.naturalHeight}\n        (${r.toFixed(2)})`,doRatiosMatch:c}:o(s.warningCompute,{url:t})}static audit(e){const t=e.ImageElements,r=[],i=[];t.filter(e=>!e.isCss&&e.mimeType&&"image/svg+xml"!==e.mimeType&&e.naturalHeight>5&&e.naturalWidth>5&&e.displayedWidth&&e.displayedHeight&&!e.usesObjectFit).forEach(e=>{const t=e,n=ImageAspectRatio.computeAspectRatios(t);a.isIcuMessage(n)?r.push(n):n.doRatiosMatch||i.push(n)});const l=[{key:"url",itemType:"thumbnail",text:""},{key:"url",itemType:"url",text:o(a.UIStrings.columnURL)},{key:"displayedAspectRatio",itemType:"text",text:o(s.columnDisplayed)},{key:"actualAspectRatio",itemType:"text",text:o(s.columnActual)
}];return{score:Number(0===i.length),warnings:r,details:n.makeTableDetails(l,i)}}}t.exports=ImageAspectRatio,t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/image-aspect-ratio.js")},{"../lib/i18n/i18n.js":78,"../lib/url-shim.js":"url","./audit.js":3}],"../audits/image-size-responsive":[function(e,t,r){(function(r){"use strict";const n=e("./audit.js"),i=e("../lib/url-shim.js"),a=e("../lib/i18n/i18n.js"),s={title:"Serves images with appropriate resolution",failureTitle:"Serves images with low resolution",description:"Image natural dimensions should be proportional to the display size and the pixel ratio to maximize image clarity. [Learn more](https://web.dev/serve-responsive-images/).",columnDisplayed:"Displayed size",columnActual:"Actual size",columnExpected:"Expected size"},o=a.createMessageInstanceIdFn(r,s),l=1,c=.75,u=64;function isCandidate(e){
return!(e.displayedWidth<=1||e.displayedHeight<=1)&&(0!==e.naturalWidth&&0!==e.naturalHeight&&("image/svg+xml"!==e.mimeType&&(!e.isCss&&(!e.usesObjectFit&&(!e.usesPixelArtScaling&&!e.usesSrcSetDensityDescriptor)))))}function imageHasRightSize(e,t){const[r,n]=function allowedImageSize(e,t,r){let n=l;(e>u||t>u)&&(n=c);const i=function quantizeDpr(e){if(e>=2)return Math.floor(e);if(e>=1.5)return 1.5;return 1}(r),a=Math.ceil(n*i*e),s=Math.ceil(n*i*t);return[a,s]}(e.displayedWidth,e.displayedHeight,t);return e.naturalWidth>=r&&e.naturalHeight>=n}function getResult(e,t){const[r,n]=function expectedImageSize(e,t,r){const n=Math.ceil(r*e),i=Math.ceil(r*t);return[n,i]}(e.displayedWidth,e.displayedHeight,t);return{url:e.src,elidedUrl:i.elideDataURI(e.src),displayedSize:`${e.displayedWidth} x ${e.displayedHeight}`,actualSize:`${e.naturalWidth} x ${e.naturalHeight}`,actualPixels:e.naturalWidth*e.naturalHeight,expectedSize:`${r} x ${n}`,expectedPixels:r*n}}
t.exports=class ImageSizeResponsive extends n{static get meta(){return{id:"image-size-responsive",title:o(s.title),failureTitle:o(s.failureTitle),description:o(s.description),requiredArtifacts:["ImageElements","ViewportDimensions"]}}static audit(e){const t=e.ViewportDimensions.devicePixelRatio,r=Array.from(e.ImageElements).filter(isCandidate).filter(e=>!imageHasRightSize(e,t)).filter(t=>(function isVisible(e,t){return(e.bottom-e.top)*(e.right-e.left)>0&&e.top<=t.innerHeight&&e.bottom>=0&&e.left<=t.innerWidth&&e.right>=0})(t.clientRect,e.ViewportDimensions)).map(e=>getResult(e,t)),i=[{key:"url",itemType:"thumbnail",text:""},{key:"elidedUrl",itemType:"url",text:o(a.UIStrings.columnURL)},{key:"displayedSize",itemType:"text",text:o(s.columnDisplayed)},{key:"actualSize",itemType:"text",text:o(s.columnActual)},{key:"expectedSize",itemType:"text",text:o(s.columnExpected)}],l=function sortResultsBySizeDelta(e){
return e.sort((e,t)=>t.expectedPixels-t.actualPixels-(e.expectedPixels-e.actualPixels))}(function deduplicateResultsByUrl(e){e.sort((e,t)=>e.url===t.url?0:e.url<t.url?-1:1);const t=[];for(const r of e){const e=t[t.length-1];e&&e.url===r.url?e.expectedPixels<r.expectedPixels&&(t[t.length-1]=r):t.push(r)}return t}(r));return{score:Number(0===r.length),details:n.makeTableDetails(i,l)}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/image-size-responsive.js")},{"../lib/i18n/i18n.js":78,"../lib/url-shim.js":"url","./audit.js":3}],"../audits/installable-manifest":[function(e,t,r){(function(r){"use strict";const n=e("./multi-check-audit.js"),i=e("../computed/manifest-values.js"),a=e("../lib/i18n/i18n.js"),s={title:"Web app manifest meets the installability requirements",failureTitle:"Web app manifest does not meet the installability requirements",
description:"Browsers can proactively prompt users to add your app to their homescreen, which can lead to higher engagement. [Learn more](https://web.dev/installable-manifest/)."},o=a.createMessageInstanceIdFn(r,s);class InstallableManifest extends n{static get meta(){return{id:"installable-manifest",title:o(s.title),failureTitle:o(s.failureTitle),description:o(s.description),requiredArtifacts:["URL","WebAppManifest","InstallabilityErrors"]}}static assessManifest(e){if(e.isParseFailure&&e.parseFailureReason)return[e.parseFailureReason];const t=[],r=["hasName","hasShortName","hasStartUrl","hasPWADisplayValue","hasIconsAtLeast144px","fetchesIcon"];return e.allChecks.filter(e=>r.includes(e.id)).forEach(e=>{e.passing||t.push(e.failureText)}),t}static async audit_(e,t){const r=await i.request(e,t);return{failures:[...InstallableManifest.assessManifest(r)],manifestValues:r,manifestUrl:e.WebAppManifest?e.WebAppManifest.url:null}}}t.exports=InstallableManifest,t.exports.UIStrings=s
}).call(this,"/lighthouse-core/audits/installable-manifest.js")},{"../computed/manifest-values.js":15,"../lib/i18n/i18n.js":78,"./multi-check-audit.js":7}],"../audits/is-on-https":[function(e,t,r){(function(r){"use strict";const n=e("./audit.js"),i=e("../lib/url-shim.js"),a=e("../computed/network-records.js"),s=e("../lib/i18n/i18n.js"),o={title:"Uses HTTPS",failureTitle:"Does not use HTTPS",description:"All sites should be protected with HTTPS, even ones that don't handle sensitive data. This includes avoiding [mixed content](https://developers.google.com/web/fundamentals/security/prevent-mixed-content/what-is-mixed-content), where some resources are loaded over HTTP despite the initial request being served over HTTPS. HTTPS prevents intruders from tampering with or passively listening in on the communications between your app and your users, and is a prerequisite for HTTP/2 and many new web platform APIs. [Learn more](https://web.dev/is-on-https/).",
displayValue:"{itemCount, plural,\n    =1 {1 insecure request found}\n    other {# insecure requests found}\n    }",columnInsecureURL:"Insecure URL",columnResolution:"Request Resolution",allowed:"Allowed",blocked:"Blocked",warning:"Allowed with warning",upgraded:"Automatically upgraded to HTTPS"},l={MixedContentAutomaticallyUpgraded:o.upgraded,MixedContentBlocked:o.blocked,MixedContentWarning:o.warning},c=s.createMessageInstanceIdFn(r,o),u=["data","https","wss","blob","chrome","chrome-extension","about","filesystem"],d=["localhost","127.0.0.1"];class HTTPS extends n{static get meta(){return{id:"is-on-https",title:c(o.title),failureTitle:c(o.failureTitle),description:c(o.description),requiredArtifacts:["devtoolsLogs","InspectorIssues"]}}static isSecureRecord(e){return u.includes(e.parsedURL.scheme)||u.includes(e.protocol)||d.includes(e.parsedURL.host)}static audit(e,t){const r=e.devtoolsLogs[n.DEFAULT_PASS];return a.request(r,t).then(t=>{
const r=t.filter(e=>!HTTPS.isSecureRecord(e)).map(e=>i.elideDataURI(e.url)),a=Array.from(new Set(r)).map(e=>({url:e,resolution:void 0})),s=[{key:"url",itemType:"url",text:c(o.columnInsecureURL)},{key:"resolution",itemType:"text",text:c(o.columnResolution)}];for(const t of e.InspectorIssues.mixedContent){let e=a.find(e=>e.url===t.insecureURL);e||(e={url:t.insecureURL},a.push(e)),e.resolution=l[t.resolutionStatus]?c(l[t.resolutionStatus]):t.resolutionStatus}for(const e of a)e.resolution||(e.resolution=c(o.allowed));let u;return a.length>0&&(u=c(o.displayValue,{itemCount:a.length})),{score:Number(0===a.length),displayValue:u,details:n.makeTableDetails(s,a)}})}}t.exports=HTTPS,t.exports.UIStrings=o}).call(this,"/lighthouse-core/audits/is-on-https.js")},{"../computed/network-records.js":40,"../lib/i18n/i18n.js":78,"../lib/url-shim.js":"url","./audit.js":3}],"../audits/large-javascript-libraries":[function(e,t,r){(function(r){"use strict"
;const n=e("../lib/large-javascript-libraries/bundlephobia-database.json"),i=e("../lib/large-javascript-libraries/library-suggestions.js").suggestions,a=e("./audit.js"),s=e("../lib/i18n/i18n.js"),o={title:"Avoids large JavaScript libraries with smaller alternatives",failureTitle:"Replace unnecessarily large JavaScript libraries",description:"Large JavaScript libraries can lead to poor performance. Prefer smaller, functionally equivalent libraries to reduce your bundle size. [Learn more](https://developers.google.com/web/fundamentals/performance/webpack/decrease-frontend-size#optimize_dependencies).",columnLibraryName:"Library",displayValue:"{libraryCount, plural,\n    =1 {1 large library found}\n    other {# large libraries found}\n    }"},l=s.createMessageInstanceIdFn(r,o);t.exports=class LargeJavascriptLibraries extends a{static get meta(){return{id:"large-javascript-libraries",title:l(o.title),failureTitle:l(o.failureTitle),description:l(o.description),requiredArtifacts:["Stacks"]}}
static audit(e){const t=[],r=e.Stacks,c=new Set;for(const e of r){if(!e.npm||!n[e.npm])continue;const r=i[e.npm];if(!r)continue;if(c.has(e.npm))continue;c.add(e.npm);let a="latest";e.version&&n[e.npm].versions[e.version]&&(a=e.version);const s=n[e.npm].versions[a],o=[];for(const e of r)n[e].versions.latest.gzip>=s.gzip||o.push({name:e,repository:n[e].repository,gzip:n[e].versions.latest.gzip});o.sort((e,t)=>e.gzip-t.gzip),o.length&&t.push({original:{gzip:s.gzip,name:e.npm,repository:n[e.npm].repository},suggestions:o})}const u=t.map(e=>{const t=e.original,r=e.suggestions.map(e=>({suggestion:{type:"link",text:e.name,url:e.repository},transferSize:e.gzip,wastedBytes:t.gzip-e.gzip}));return{name:{type:"link",text:t.name,url:t.repository},transferSize:t.gzip,subItems:{type:"subitems",items:r}}}),d=[{key:"name",itemType:"text",subItemsHeading:{key:"suggestion"},text:l(o.columnLibraryName)},{key:"transferSize",itemType:"bytes",subItemsHeading:{key:"transferSize"},
text:l(s.UIStrings.columnTransferSize)},{key:null,itemType:"bytes",subItemsHeading:{key:"wastedBytes"},text:l(s.UIStrings.columnWastedBytes)}],m=l(o.displayValue,{libraryCount:u.length}),p=a.makeTableDetails(d,u,{});return{score:t.length>0?0:1,displayValue:m,details:p}}},t.exports.UIStrings=o}).call(this,"/lighthouse-core/audits/large-javascript-libraries.js")},{"../lib/i18n/i18n.js":78,"../lib/large-javascript-libraries/bundlephobia-database.json":82,"../lib/large-javascript-libraries/library-suggestions.js":83,"./audit.js":3}],"../audits/largest-contentful-paint-element":[function(e,t,r){(function(r){"use strict";const n=e("./audit.js"),i=e("../lib/i18n/i18n.js"),a={title:"Largest Contentful Paint element",description:"This is the largest contentful element painted within the viewport. [Learn More](https://web.dev/lighthouse-largest-contentful-paint/)"},s=i.createMessageInstanceIdFn(r,a);t.exports=class LargestContentfulPaintElement extends n{static get meta(){return{
id:"largest-contentful-paint-element",title:s(a.title),description:s(a.description),scoreDisplayMode:n.SCORING_MODES.INFORMATIVE,requiredArtifacts:["traces","TraceElements"]}}static audit(e){const t=e.TraceElements.find(e=>"largest-contentful-paint"===e.traceEventType),r=[];t&&r.push({node:{type:"node",path:t.devtoolsNodePath,selector:t.selector,nodeLabel:t.nodeLabel,snippet:t.snippet,boundingRect:t.boundingRect}});const a=[{key:"node",itemType:"node",text:s(i.UIStrings.columnElement)}],o=n.makeTableDetails(a,r),l=s(i.UIStrings.displayValueElementsFound,{nodeCount:r.length});return{score:1,notApplicable:0===r.length,displayValue:l,details:o}}},t.exports.UIStrings=a}).call(this,"/lighthouse-core/audits/largest-contentful-paint-element.js")},{"../lib/i18n/i18n.js":78,"./audit.js":3}],"../audits/layout-shift-elements":[function(e,t,r){(function(r){"use strict";const n=e("./audit.js"),i=e("../lib/i18n/i18n.js"),a={title:"Avoid large layout shifts",
description:"These DOM elements contribute most to the CLS of the page.",columnContribution:"CLS Contribution"},s=i.createMessageInstanceIdFn(r,a);t.exports=class LayoutShiftElements extends n{static get meta(){return{id:"layout-shift-elements",title:s(a.title),description:s(a.description),scoreDisplayMode:n.SCORING_MODES.INFORMATIVE,requiredArtifacts:["TraceElements"]}}static audit(e){const t=e.TraceElements.filter(e=>"layout-shift"===e.traceEventType).map(e=>({node:{type:"node",path:e.devtoolsNodePath,selector:e.selector,nodeLabel:e.nodeLabel,snippet:e.snippet,boundingRect:e.boundingRect},score:e.score})),r=[{key:"node",itemType:"node",text:s(i.UIStrings.columnElement)},{key:"score",itemType:"numeric",granularity:.001,text:s(a.columnContribution)}],o=n.makeTableDetails(r,t);let l;return t.length>0&&(l=s(i.UIStrings.displayValueElementsFound,{nodeCount:t.length})),{score:1,notApplicable:0===o.items.length,displayValue:l,details:o}}},t.exports.UIStrings=a
}).call(this,"/lighthouse-core/audits/layout-shift-elements.js")},{"../lib/i18n/i18n.js":78,"./audit.js":3}],"../audits/load-fast-enough-for-pwa":[function(e,t,r){(function(r){"use strict";const n=e("lodash.isequal"),i=e("./audit.js"),a=e("../config/constants.js").throttling.mobileSlow4G,s=e("../computed/metrics/interactive.js"),o=e("../lib/i18n/i18n.js"),l=1e4,c={title:"Page load is fast enough on mobile networks",failureTitle:"Page load is not fast enough on mobile networks",description:"A fast page load over a cellular network ensures a good mobile user experience. [Learn more](https://web.dev/load-fast-enough-for-pwa/).",displayValueText:"Interactive at {timeInMs, number, seconds} s",displayValueTextWithOverride:"Interactive on simulated mobile network at {timeInMs, number, seconds} s",explanationLoadSlow:'Your page loads too slowly and is not interactive within 10 seconds. Look at the opportunities and diagnostics in the "Performance" section to learn how to improve.'
},u=o.createMessageInstanceIdFn(r,c);t.exports=class LoadFastEnough4Pwa extends i{static get meta(){return{id:"load-fast-enough-for-pwa",title:u(c.title),failureTitle:u(c.failureTitle),description:u(c.description),requiredArtifacts:["traces","devtoolsLogs"]}}static async audit(e,t){const r=e.traces[i.DEFAULT_PASS],o=e.devtoolsLogs[i.DEFAULT_PASS],d={throttlingMethod:"simulate",throttling:a},m="provided"===t.settings.throttlingMethod||!n(t.settings.throttling,a),p=m?c.displayValueTextWithOverride:c.displayValueText,h={trace:r,devtoolsLog:o,settings:m?Object.assign({},t.settings,d):t.settings},g=await s.request(h,t),f=Number(g.timing<l);let b,y;return f||(b=u(p,{timeInMs:g.timing}),y=u(c.explanationLoadSlow)),{score:f,displayValue:b,explanation:y,numericValue:g.timing,numericUnit:"millisecond"}}},t.exports.UIStrings=c}).call(this,"/lighthouse-core/audits/load-fast-enough-for-pwa.js")},{"../computed/metrics/interactive.js":21,"../config/constants.js":54,"../lib/i18n/i18n.js":78,
"./audit.js":3,"lodash.isequal":169}],"../audits/long-tasks":[function(e,t,r){(function(r){"use strict";const n=e("./audit.js"),i=e("../computed/network-records.js"),a=e("../lib/i18n/i18n.js"),s=e("../computed/main-thread-tasks.js"),o=e("./bootup-time.js"),l=e("../computed/page-dependency-graph.js"),c=e("../computed/load-simulator.js"),u={startTime:0,endTime:0,duration:0},d={title:"Avoid long main-thread tasks",description:"Lists the longest tasks on the main thread, useful for identifying worst contributors to input delay. [Learn more](https://web.dev/long-tasks-devtools/)",displayValue:"{itemCount, plural,\n  =1 {# long task found}\n  other {# long tasks found}\n  }"},m=a.createMessageInstanceIdFn(r,d);class LongTasks extends n{static get meta(){return{id:"long-tasks",scoreDisplayMode:n.SCORING_MODES.INFORMATIVE,title:m(d.title),description:m(d.description),requiredArtifacts:["traces","devtoolsLogs"]}}static async audit(e,t){
const r=t.settings||{},p=e.traces[n.DEFAULT_PASS],h=await s.request(p,t),g=e.devtoolsLogs[LongTasks.DEFAULT_PASS],f=await i.request(g,t),b=new Map;if("simulate"===r.throttlingMethod){const e={trace:p,devtoolsLog:g,settings:t.settings},r=await l.request({trace:p,devtoolsLog:g},t),n=await c.request(e,t),i=await n.simulate(r,{label:"long-tasks-diagnostic"});for(const[e,t]of i.nodeTimings.entries())"cpu"===e.type&&b.set(e.event,t)}else for(const e of h)e.unbounded||e.parent||b.set(e.event,e);const y=o.getJavaScriptURLs(f),v=h.map(e=>{const t=b.get(e.event)||u;return{...e,duration:t.duration,startTime:t.startTime}}).filter(e=>e.duration>=50&&!e.unbounded&&!e.parent).sort((e,t)=>t.duration-e.duration).slice(0,20).map(e=>({url:o.getAttributableURLForTask(e,y),duration:e.duration,startTime:e.startTime})),w=[{key:"url",itemType:"url",text:m(a.UIStrings.columnURL)},{key:"startTime",itemType:"ms",granularity:1,text:m(a.UIStrings.columnStartTime)},{key:"duration",itemType:"ms",granularity:1,
text:m(a.UIStrings.columnDuration)}],k=n.makeTableDetails(w,v);let x;return v.length>0&&(x=m(d.displayValue,{itemCount:v.length})),{score:0===v.length?1:0,notApplicable:0===v.length,details:k,displayValue:x}}}t.exports=LongTasks,t.exports.UIStrings=d}).call(this,"/lighthouse-core/audits/long-tasks.js")},{"../computed/load-simulator.js":12,"../computed/main-thread-tasks.js":14,"../computed/network-records.js":40,"../computed/page-dependency-graph.js":41,"../lib/i18n/i18n.js":78,"./audit.js":3,"./bootup-time.js":"../audits/bootup-time"}],"../audits/main-thread-tasks":[function(e,t,r){"use strict";const n=e("./audit.js"),i=e("../computed/main-thread-tasks.js");t.exports=class MainThreadTasks extends n{static get meta(){return{id:"main-thread-tasks",scoreDisplayMode:n.SCORING_MODES.INFORMATIVE,title:"Tasks",description:"Lists the toplevel main thread tasks that executed during page load.",requiredArtifacts:["traces"]}}static async audit(e,t){
const r=e.traces[n.DEFAULT_PASS],a=(await i.request(r,t)).filter(e=>e.duration>5&&!e.parent).map(e=>({duration:e.duration,startTime:e.startTime}));return{score:1,details:n.makeTableDetails([{key:"startTime",itemType:"ms",granularity:1,text:"Start Time"},{key:"duration",itemType:"ms",granularity:1,text:"End Time"}],a)}}}},{"../computed/main-thread-tasks.js":14,"./audit.js":3}],"../audits/mainthread-work-breakdown":[function(e,t,r){(function(r){"use strict";const n=e("./audit.js"),{taskGroups:i}=e("../lib/tracehouse/task-groups.js"),a=e("../lib/i18n/i18n.js"),s=e("../computed/main-thread-tasks.js"),o={title:"Minimizes main-thread work",failureTitle:"Minimize main-thread work",description:"Consider reducing the time spent parsing, compiling and executing JS. You may find delivering smaller JS payloads helps with this. [Learn more](https://web.dev/mainthread-work-breakdown/)",columnCategory:"Category"},l=a.createMessageInstanceIdFn(r,o);class MainThreadWorkBreakdown extends n{
static get meta(){return{id:"mainthread-work-breakdown",title:l(o.title),failureTitle:l(o.failureTitle),description:l(o.description),scoreDisplayMode:n.SCORING_MODES.NUMERIC,requiredArtifacts:["traces"]}}static get defaultOptions(){return{p10:2017,median:4e3}}static getExecutionTimingsByGroup(e){const t=new Map;for(const r of e){const e=t.get(r.group.id)||0;t.set(r.group.id,e+r.selfTime)}return t}static async audit(e,t){const r=t.settings||{},c=e.traces[MainThreadWorkBreakdown.DEFAULT_PASS],u=await s.request(c,t),d="simulate"===r.throttlingMethod?r.throttling.cpuSlowdownMultiplier:1,m=MainThreadWorkBreakdown.getExecutionTimingsByGroup(u);let p=0;const h={},g=Array.from(m).map(([e,t])=>{const r=t*d;p+=r;const n=h[e]||0;return h[e]=n+r,{group:e,groupLabel:i[e].label,duration:r}}),f=[{key:"groupLabel",itemType:"text",text:l(o.columnCategory)},{key:"duration",itemType:"ms",granularity:1,text:l(a.UIStrings.columnTimeSpent)}];g.sort((e,t)=>h[t.group]-h[e.group])
;const b=MainThreadWorkBreakdown.makeTableDetails(f,g);return{score:n.computeLogNormalScore({p10:t.options.p10,median:t.options.median},p),numericValue:p,numericUnit:"millisecond",displayValue:l(a.UIStrings.seconds,{timeInMs:p}),details:b}}}t.exports=MainThreadWorkBreakdown,t.exports.UIStrings=o}).call(this,"/lighthouse-core/audits/mainthread-work-breakdown.js")},{"../computed/main-thread-tasks.js":14,"../lib/i18n/i18n.js":78,"../lib/tracehouse/task-groups.js":100,"./audit.js":3}],"../audits/manual/pwa-cross-browser":[function(e,t,r){(function(r){"use strict";const n=e("./manual-audit.js"),i=e("../../lib/i18n/i18n.js"),a={title:"Site works cross-browser",description:"To reach the most number of users, sites should work across every major browser. [Learn more](https://web.dev/pwa-cross-browser/)."},s=i.createMessageInstanceIdFn(r,a);t.exports=class PWACrossBrowser extends n{static get meta(){return Object.assign({id:"pwa-cross-browser",title:s(a.title),description:s(a.description)
},super.partialMeta)}},t.exports.UIStrings=a}).call(this,"/lighthouse-core/audits/manual/pwa-cross-browser.js")},{"../../lib/i18n/i18n.js":78,"./manual-audit.js":6}],"../audits/manual/pwa-each-page-has-url":[function(e,t,r){(function(r){"use strict";const n=e("./manual-audit.js"),i=e("../../lib/i18n/i18n.js"),a={title:"Each page has a URL",description:"Ensure individual pages are deep linkable via URL and that URLs are unique for the purpose of shareability on social media. [Learn more](https://web.dev/pwa-each-page-has-url/)."},s=i.createMessageInstanceIdFn(r,a);t.exports=class PWAEachPageHasURL extends n{static get meta(){return Object.assign({id:"pwa-each-page-has-url",title:s(a.title),description:s(a.description)},super.partialMeta)}},t.exports.UIStrings=a}).call(this,"/lighthouse-core/audits/manual/pwa-each-page-has-url.js")},{"../../lib/i18n/i18n.js":78,"./manual-audit.js":6}],"../audits/manual/pwa-page-transitions":[function(e,t,r){(function(r){"use strict"
;const n=e("./manual-audit.js"),i=e("../../lib/i18n/i18n.js"),a={title:"Page transitions don't feel like they block on the network",description:"Transitions should feel snappy as you tap around, even on a slow network. This experience is key to a user's perception of performance. [Learn more](https://web.dev/pwa-page-transitions/)."},s=i.createMessageInstanceIdFn(r,a);t.exports=class PWAPageTransitions extends n{static get meta(){return Object.assign({id:"pwa-page-transitions",title:s(a.title),description:s(a.description)},super.partialMeta)}},t.exports.UIStrings=a}).call(this,"/lighthouse-core/audits/manual/pwa-page-transitions.js")},{"../../lib/i18n/i18n.js":78,"./manual-audit.js":6}],"../audits/maskable-icon":[function(e,t,r){(function(r){"use strict";const n=e("./audit.js"),i=e("../computed/manifest-values.js"),a=e("../lib/i18n/i18n.js"),s={title:"Manifest has a maskable icon",failureTitle:"Manifest doesn't have a maskable icon",
description:"A maskable icon ensures that the image fills the entire shape without being letterboxed when installing the app on a device. [Learn more](https://web.dev/maskable-icon-audit/)."},o=a.createMessageInstanceIdFn(r,s);t.exports=class MaskableIcon extends n{static get meta(){return{id:"maskable-icon",title:o(s.title),failureTitle:o(s.failureTitle),description:o(s.description),requiredArtifacts:["WebAppManifest","InstallabilityErrors"]}}static async audit(e,t){const r=await i.request(e,t);if(r.isParseFailure)return{score:0,explanation:r.parseFailureReason};const n=r.allChecks.find(e=>"hasMaskableIcon"===e.id);return{score:n&&n.passing?1:0}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/maskable-icon.js")},{"../computed/manifest-values.js":15,"../lib/i18n/i18n.js":78,"./audit.js":3}],"../audits/metrics/cumulative-layout-shift":[function(e,t,r){(function(r){"use strict"
;const n=e("../audit.js"),i=e("../../computed/metrics/cumulative-layout-shift.js"),a=e("../../lib/i18n/i18n.js"),s={description:"Cumulative Layout Shift measures the movement of visible elements within the viewport. [Learn more](https://web.dev/cls/)."},o=a.createMessageInstanceIdFn(r,s);t.exports=class CumulativeLayoutShift extends n{static get meta(){return{id:"cumulative-layout-shift",title:o(a.UIStrings.cumulativeLayoutShiftMetric),description:o(s.description),scoreDisplayMode:n.SCORING_MODES.NUMERIC,requiredArtifacts:["traces"]}}static get defaultOptions(){return{p10:.1,median:.25}}static async audit(e,t){const r=e.traces[n.DEFAULT_PASS],a=await i.request(r,t),s={type:"debugdata",items:[a.debugInfo]};return{score:n.computeLogNormalScore({p10:t.options.p10,median:t.options.median},a.value),numericValue:a.value,numericUnit:"unitless",displayValue:a.value.toLocaleString(t.settings.locale),details:s}}},t.exports.UIStrings=s
}).call(this,"/lighthouse-core/audits/metrics/cumulative-layout-shift.js")},{"../../computed/metrics/cumulative-layout-shift.js":16,"../../lib/i18n/i18n.js":78,"../audit.js":3}],"../audits/metrics/estimated-input-latency":[function(e,t,r){(function(r){"use strict";const n=e("../audit.js"),i=e("../../lib/i18n/i18n.js"),a=e("../../computed/metrics/estimated-input-latency.js"),s={description:"Estimated Input Latency is an estimate of how long your app takes to respond to user input, in milliseconds, during the busiest 5s window of page load. If your latency is higher than 50 ms, users may perceive your app as laggy. [Learn more](https://web.dev/estimated-input-latency/)."},o=i.createMessageInstanceIdFn(r,s);t.exports=class EstimatedInputLatency extends n{static get meta(){return{id:"estimated-input-latency",title:o(i.UIStrings.estimatedInputLatencyMetric),description:o(s.description),scoreDisplayMode:n.SCORING_MODES.NUMERIC,requiredArtifacts:["traces","devtoolsLogs"]}}
static get defaultOptions(){return{p10:58,median:100}}static async audit(e,t){const r={trace:e.traces[n.DEFAULT_PASS],devtoolsLog:e.devtoolsLogs[n.DEFAULT_PASS],settings:t.settings},s=await a.request(r,t);return{score:n.computeLogNormalScore({p10:t.options.p10,median:t.options.median},s.timing),numericValue:s.timing,numericUnit:"millisecond",displayValue:o(i.UIStrings.ms,{timeInMs:s.timing})}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/metrics/estimated-input-latency.js")},{"../../computed/metrics/estimated-input-latency.js":17,"../../lib/i18n/i18n.js":78,"../audit.js":3}],"../audits/metrics/first-contentful-paint-3g":[function(e,t,r){"use strict";const n=e("../audit.js"),i=e("../../config/constants.js").throttling.mobileRegular3G,a=e("../../computed/metrics/first-contentful-paint.js");t.exports=class FirstContentfulPaint3G extends n{static get meta(){return{id:"first-contentful-paint-3g",title:"First Contentful Paint (3G)",
description:"First Contentful Paint 3G marks the time at which the first text or image is painted while on a 3G network. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/first-contentful-paint).",scoreDisplayMode:n.SCORING_MODES.NUMERIC,requiredArtifacts:["traces","devtoolsLogs"]}}static get defaultOptions(){return{p10:3504,median:6e3}}static async audit(e,t){const r={trace:e.traces[n.DEFAULT_PASS],devtoolsLog:e.devtoolsLogs[n.DEFAULT_PASS],settings:{...t.settings,throttlingMethod:"simulate",throttling:i}},s=await a.request(r,t);return{score:n.computeLogNormalScore({p10:t.options.p10,median:t.options.median},s.timing),numericValue:s.timing,numericUnit:"millisecond",displayValue:`${s.timing} ms`}}}},{"../../computed/metrics/first-contentful-paint.js":18,"../../config/constants.js":54,"../audit.js":3}],"../audits/metrics/first-contentful-paint":[function(e,t,r){(function(r){"use strict"
;const n=e("../audit.js"),i=e("../../lib/i18n/i18n.js"),a=e("../../computed/metrics/first-contentful-paint.js"),s={description:"First Contentful Paint marks the time at which the first text or image is painted. [Learn more](https://web.dev/first-contentful-paint/)."},o=i.createMessageInstanceIdFn(r,s);t.exports=class FirstContentfulPaint extends n{static get meta(){return{id:"first-contentful-paint",title:o(i.UIStrings.firstContentfulPaintMetric),description:o(s.description),scoreDisplayMode:n.SCORING_MODES.NUMERIC,requiredArtifacts:["traces","devtoolsLogs","TestedAsMobileDevice"]}}static get defaultOptions(){return{mobile:{scoring:{p10:2336,median:4e3}},desktop:{scoring:{p10:934,median:1600}}}}static async audit(e,t){const r={trace:e.traces[n.DEFAULT_PASS],devtoolsLog:e.devtoolsLogs[n.DEFAULT_PASS],settings:t.settings},s=await a.request(r,t),l=!1===e.TestedAsMobileDevice?t.options.desktop:t.options.mobile;return{score:n.computeLogNormalScore(l.scoring,s.timing),numericValue:s.timing,
numericUnit:"millisecond",displayValue:o(i.UIStrings.seconds,{timeInMs:s.timing})}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/metrics/first-contentful-paint.js")},{"../../computed/metrics/first-contentful-paint.js":18,"../../lib/i18n/i18n.js":78,"../audit.js":3}],"../audits/metrics/first-cpu-idle":[function(e,t,r){(function(r){"use strict";const n=e("../audit.js"),i=e("../../lib/i18n/i18n.js"),a=e("../../computed/metrics/first-cpu-idle.js"),s={description:"First CPU Idle marks the first time at which the page's main thread is quiet enough to handle input.  [Learn more](https://web.dev/first-cpu-idle/)."},o=i.createMessageInstanceIdFn(r,s);t.exports=class FirstCPUIdle extends n{static get meta(){return{id:"first-cpu-idle",title:o(i.UIStrings.firstCPUIdleMetric),description:o(s.description),scoreDisplayMode:n.SCORING_MODES.NUMERIC,requiredArtifacts:["traces","devtoolsLogs","TestedAsMobileDevice"]}}static get defaultOptions(){return{mobile:{scoring:{p10:3572,median:6500}
},desktop:{scoring:{p10:2468,median:4500}}}}static async audit(e,t){const r={trace:e.traces[n.DEFAULT_PASS],devtoolsLog:e.devtoolsLogs[n.DEFAULT_PASS],settings:t.settings},s=await a.request(r,t),l=!1===e.TestedAsMobileDevice?t.options.desktop:t.options.mobile;return{score:n.computeLogNormalScore(l.scoring,s.timing),numericValue:s.timing,numericUnit:"millisecond",displayValue:o(i.UIStrings.seconds,{timeInMs:s.timing})}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/metrics/first-cpu-idle.js")},{"../../computed/metrics/first-cpu-idle.js":19,"../../lib/i18n/i18n.js":78,"../audit.js":3}],"../audits/metrics/first-meaningful-paint":[function(e,t,r){(function(r){"use strict";const n=e("../audit.js"),i=e("../../lib/i18n/i18n.js"),a=e("../../computed/metrics/first-meaningful-paint.js"),s={description:"First Meaningful Paint measures when the primary content of a page is visible. [Learn more](https://web.dev/first-meaningful-paint/)."},o=i.createMessageInstanceIdFn(r,s)
;t.exports=class FirstMeaningfulPaint extends n{static get meta(){return{id:"first-meaningful-paint",title:o(i.UIStrings.firstMeaningfulPaintMetric),description:o(s.description),scoreDisplayMode:n.SCORING_MODES.NUMERIC,requiredArtifacts:["traces","devtoolsLogs","TestedAsMobileDevice"]}}static get defaultOptions(){return{mobile:{scoring:{p10:2336,median:4e3}},desktop:{scoring:{p10:934,median:1600}}}}static async audit(e,t){const r={trace:e.traces[n.DEFAULT_PASS],devtoolsLog:e.devtoolsLogs[n.DEFAULT_PASS],settings:t.settings},s=await a.request(r,t),l=!1===e.TestedAsMobileDevice?t.options.desktop:t.options.mobile;return{score:n.computeLogNormalScore(l.scoring,s.timing),numericValue:s.timing,numericUnit:"millisecond",displayValue:o(i.UIStrings.seconds,{timeInMs:s.timing})}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/metrics/first-meaningful-paint.js")},{"../../computed/metrics/first-meaningful-paint.js":20,"../../lib/i18n/i18n.js":78,"../audit.js":3}],
"../audits/metrics/interactive":[function(e,t,r){(function(r){"use strict";const n=e("../audit.js"),i=e("../../lib/i18n/i18n.js"),a=e("../../computed/metrics/interactive.js"),s={description:"Time to interactive is the amount of time it takes for the page to become fully interactive. [Learn more](https://web.dev/interactive/)."},o=i.createMessageInstanceIdFn(r,s);t.exports=class InteractiveMetric extends n{static get meta(){return{id:"interactive",title:o(i.UIStrings.interactiveMetric),description:o(s.description),scoreDisplayMode:n.SCORING_MODES.NUMERIC,requiredArtifacts:["traces","devtoolsLogs","TestedAsMobileDevice"]}}static get defaultOptions(){return{mobile:{scoring:{p10:3785,median:7300}},desktop:{scoring:{p10:2468,median:4500}}}}static async audit(e,t){const r={trace:e.traces[n.DEFAULT_PASS],devtoolsLog:e.devtoolsLogs[n.DEFAULT_PASS],settings:t.settings},s=(await a.request(r,t)).timing,l=!1===e.TestedAsMobileDevice?t.options.desktop:t.options.mobile;return{
score:n.computeLogNormalScore(l.scoring,s),numericValue:s,numericUnit:"millisecond",displayValue:o(i.UIStrings.seconds,{timeInMs:s})}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/metrics/interactive.js")},{"../../computed/metrics/interactive.js":21,"../../lib/i18n/i18n.js":78,"../audit.js":3}],"../audits/metrics/largest-contentful-paint":[function(e,t,r){(function(r){"use strict";const n=e("../audit.js"),i=e("../../lib/i18n/i18n.js"),a=e("../../computed/metrics/largest-contentful-paint.js"),s=e("../../lib/lh-error.js"),o={description:"Largest Contentful Paint marks the time at which the largest text or image is painted. [Learn More](https://web.dev/lighthouse-largest-contentful-paint/)"},l=i.createMessageInstanceIdFn(r,o);t.exports=class LargestContentfulPaint extends n{static get meta(){return{id:"largest-contentful-paint",title:l(i.UIStrings.largestContentfulPaintMetric),description:l(o.description),scoreDisplayMode:n.SCORING_MODES.NUMERIC,
requiredArtifacts:["HostUserAgent","traces","devtoolsLogs","TestedAsMobileDevice"]}}static get defaultOptions(){return{mobile:{scoring:{p10:2500,median:4e3}},desktop:{scoring:{p10:1200,median:2400}}}}static async audit(e,t){const r={trace:e.traces[n.DEFAULT_PASS],devtoolsLog:e.devtoolsLogs[n.DEFAULT_PASS],settings:t.settings};let o;try{o=await a.request(r,t)}catch(t){const r=e.HostUserAgent.match(/Chrome\/(\d+)/);if(!r)throw t;if(Number(r[1])<79&&"NO_LCP"===t.code)throw new s(s.errors.UNSUPPORTED_OLD_CHROME,{featureName:"Largest Contentful Paint"});throw t}const c=!1===e.TestedAsMobileDevice?t.options.desktop:t.options.mobile;return{score:n.computeLogNormalScore(c.scoring,o.timing),numericValue:o.timing,numericUnit:"millisecond",displayValue:l(i.UIStrings.seconds,{timeInMs:o.timing})}}},t.exports.UIStrings=o}).call(this,"/lighthouse-core/audits/metrics/largest-contentful-paint.js")},{"../../computed/metrics/largest-contentful-paint.js":32,"../../lib/i18n/i18n.js":78,
"../../lib/lh-error.js":86,"../audit.js":3}],"../audits/metrics/max-potential-fid":[function(e,t,r){(function(r){"use strict";const n=e("../audit.js"),i=e("../../computed/metrics/max-potential-fid.js"),a=e("../../lib/i18n/i18n.js"),s={description:"The maximum potential First Input Delay that your users could experience is the duration of the longest task. [Learn more](https://web.dev/lighthouse-max-potential-fid/)."},o=a.createMessageInstanceIdFn(r,s);t.exports=class MaxPotentialFID extends n{static get meta(){return{id:"max-potential-fid",title:o(a.UIStrings.maxPotentialFIDMetric),description:o(s.description),scoreDisplayMode:n.SCORING_MODES.NUMERIC,requiredArtifacts:["traces","devtoolsLogs"]}}static get defaultOptions(){return{p10:130,median:250}}static async audit(e,t){const r={trace:e.traces[n.DEFAULT_PASS],devtoolsLog:e.devtoolsLogs[n.DEFAULT_PASS],settings:t.settings},s=await i.request(r,t);return{score:n.computeLogNormalScore({p10:t.options.p10,median:t.options.median
},s.timing),numericValue:s.timing,numericUnit:"millisecond",displayValue:o(a.UIStrings.ms,{timeInMs:s.timing})}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/metrics/max-potential-fid.js")},{"../../computed/metrics/max-potential-fid.js":33,"../../lib/i18n/i18n.js":78,"../audit.js":3}],"../audits/metrics/speed-index":[function(e,t,r){(function(r){"use strict";const n=e("../audit.js"),i=e("../../lib/i18n/i18n.js"),a=e("../../computed/metrics/speed-index.js"),s={description:"Speed Index shows how quickly the contents of a page are visibly populated. [Learn more](https://web.dev/speed-index/)."},o=i.createMessageInstanceIdFn(r,s);t.exports=class SpeedIndex extends n{static get meta(){return{id:"speed-index",title:o(i.UIStrings.speedIndexMetric),description:o(s.description),scoreDisplayMode:n.SCORING_MODES.NUMERIC,requiredArtifacts:["traces","devtoolsLogs","TestedAsMobileDevice"]}}static get defaultOptions(){return{mobile:{scoring:{p10:3387,median:5800}},desktop:{scoring:{
p10:1311,median:2300}}}}static async audit(e,t){const r={trace:e.traces[n.DEFAULT_PASS],devtoolsLog:e.devtoolsLogs[n.DEFAULT_PASS],settings:t.settings},s=await a.request(r,t),l=!1===e.TestedAsMobileDevice?t.options.desktop:t.options.mobile;return{score:n.computeLogNormalScore(l.scoring,s.timing),numericValue:s.timing,numericUnit:"millisecond",displayValue:o(i.UIStrings.seconds,{timeInMs:s.timing})}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/metrics/speed-index.js")},{"../../computed/metrics/speed-index.js":35,"../../lib/i18n/i18n.js":78,"../audit.js":3}],"../audits/metrics/total-blocking-time":[function(e,t,r){(function(r){"use strict";const n=e("../audit.js"),i=e("../../computed/metrics/total-blocking-time.js"),a=e("../../lib/i18n/i18n.js"),s={description:"Sum of all time periods between FCP and Time to Interactive, when task length exceeded 50ms, expressed in milliseconds. [Learn more](https://web.dev/lighthouse-total-blocking-time/)."
},o=a.createMessageInstanceIdFn(r,s);t.exports=class TotalBlockingTime extends n{static get meta(){return{id:"total-blocking-time",title:o(a.UIStrings.totalBlockingTimeMetric),description:o(s.description),scoreDisplayMode:n.SCORING_MODES.NUMERIC,requiredArtifacts:["traces","devtoolsLogs","TestedAsMobileDevice"]}}static get defaultOptions(){return{mobile:{scoring:{p10:287,median:600}},desktop:{scoring:{p10:150,median:350}}}}static async audit(e,t){const r={trace:e.traces[n.DEFAULT_PASS],devtoolsLog:e.devtoolsLogs[n.DEFAULT_PASS],settings:t.settings},s=await i.request(r,t),l=!1===e.TestedAsMobileDevice?t.options.desktop:t.options.mobile;return{score:n.computeLogNormalScore(l.scoring,s.timing),numericValue:s.timing,numericUnit:"millisecond",displayValue:o(a.UIStrings.ms,{timeInMs:s.timing})}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/metrics/total-blocking-time.js")},{"../../computed/metrics/total-blocking-time.js":37,"../../lib/i18n/i18n.js":78,"../audit.js":3}],
"../audits/metrics":[function(e,t,r){"use strict";const n=e("./audit.js"),i=e("../computed/metrics/timing-summary.js"),a=new Set(["cumulativeLayoutShift","observedCumulativeLayoutShift"]);t.exports=class Metrics extends n{static get meta(){return{id:"metrics",scoreDisplayMode:n.SCORING_MODES.INFORMATIVE,title:"Metrics",description:"Collects all available metrics.",requiredArtifacts:["traces","devtoolsLogs"]}}static async audit(e,t){const r=e.traces[n.DEFAULT_PASS],s=e.devtoolsLogs[n.DEFAULT_PASS],o=await i.request({trace:r,devtoolsLog:s},t),l=o.metrics,c=o.debugInfo;for(const[e,t]of Object.entries(l)){const r=e;"number"!=typeof t||a.has(r)||(l[r]=Math.round(t))}const u={type:"debugdata",items:[l,c]};return{score:1,numericValue:l.interactive||0,numericUnit:"millisecond",details:u}}}},{"../computed/metrics/timing-summary.js":36,"./audit.js":3}],"../audits/network-requests":[function(e,t,r){"use strict"
;const n=e("./audit.js"),i=e("../lib/url-shim.js"),a=e("../computed/network-records.js");t.exports=class NetworkRequests extends n{static get meta(){return{id:"network-requests",scoreDisplayMode:n.SCORING_MODES.INFORMATIVE,title:"Network Requests",description:"Lists the network requests that were made during page load.",requiredArtifacts:["devtoolsLogs"]}}static audit(e,t){const r=e.devtoolsLogs[n.DEFAULT_PASS];return a.request(r,t).then(e=>{const t=e.reduce((e,t)=>Math.min(e,t.startTime),1/0),r=e=>e<t||!Number.isFinite(e)?void 0:1e3*(e-t),a=e.map(e=>{const t=e.lrStatistics&&e.lrStatistics.endTimeDeltaMs,n=e.lrStatistics&&e.lrStatistics.TCPMs,a=e.lrStatistics&&e.lrStatistics.requestMs,s=e.lrStatistics&&e.lrStatistics.responseMs;return{url:i.elideDataURI(e.url),protocol:e.protocol,startTime:r(e.startTime),endTime:r(e.endTime),finished:e.finished,transferSize:e.transferSize,resourceSize:e.resourceSize,statusCode:e.statusCode,mimeType:e.mimeType,resourceType:e.resourceType,
lrEndTimeDeltaMs:t,lrTCPMs:n,lrRequestMs:a,lrResponseMs:s}});return{score:1,details:n.makeTableDetails([{key:"url",itemType:"url",text:"URL"},{key:"protocol",itemType:"text",text:"Protocol"},{key:"startTime",itemType:"ms",granularity:1,text:"Start Time"},{key:"endTime",itemType:"ms",granularity:1,text:"End Time"},{key:"transferSize",itemType:"bytes",displayUnit:"kb",granularity:1,text:"Transfer Size"},{key:"resourceSize",itemType:"bytes",displayUnit:"kb",granularity:1,text:"Resource Size"},{key:"statusCode",itemType:"text",text:"Status Code"},{key:"mimeType",itemType:"text",text:"MIME Type"},{key:"resourceType",itemType:"text",text:"Resource Type"}],a)}})}}},{"../computed/network-records.js":40,"../lib/url-shim.js":"url","./audit.js":3}],"../audits/network-rtt":[function(e,t,r){(function(r){"use strict";const n=e("./audit.js"),i=e("../lib/i18n/i18n.js"),a=e("../computed/network-analysis.js"),s={title:"Network Round Trip Times",
description:"Network round trip times (RTT) have a large impact on performance. If the RTT to an origin is high, it's an indication that servers closer to the user could improve performance. [Learn more](https://hpbn.co/primer-on-latency-and-bandwidth/)."},o=i.createMessageInstanceIdFn(r,s);t.exports=class NetworkRTT extends n{static get meta(){return{id:"network-rtt",scoreDisplayMode:n.SCORING_MODES.INFORMATIVE,title:o(s.title),description:o(s.description),requiredArtifacts:["devtoolsLogs"]}}static async audit(e,t){const r=e.devtoolsLogs[n.DEFAULT_PASS],s=await a.request(r,t);let l=0;const c=s.rtt,u=[];for(const[e,t]of s.additionalRttByOrigin.entries()){if(!e.startsWith("http"))continue;const r=t+c;u.push({origin:e,rtt:r}),l=Number.isFinite(r)?Math.max(r,l):l}u.sort((e,t)=>t.rtt-e.rtt);const d=[{key:"origin",itemType:"text",text:o(i.UIStrings.columnURL)},{key:"rtt",itemType:"ms",granularity:1,text:o(i.UIStrings.columnTimeSpent)}],m=n.makeTableDetails(d,u);return{score:1,
numericValue:l,numericUnit:"millisecond",displayValue:o(i.UIStrings.ms,{timeInMs:l}),details:m}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/network-rtt.js")},{"../computed/network-analysis.js":39,"../lib/i18n/i18n.js":78,"./audit.js":3}],"../audits/network-server-latency":[function(e,t,r){(function(r){"use strict";const n=e("./audit.js"),i=e("../lib/i18n/i18n.js"),a=e("../computed/network-analysis.js"),s={title:"Server Backend Latencies",description:"Server latencies can impact web performance. If the server latency of an origin is high, it's an indication the server is overloaded or has poor backend performance. [Learn more](https://hpbn.co/primer-on-web-performance/#analyzing-the-resource-waterfall)."},o=i.createMessageInstanceIdFn(r,s);t.exports=class NetworkServerLatency extends n{static get meta(){return{id:"network-server-latency",scoreDisplayMode:n.SCORING_MODES.INFORMATIVE,title:o(s.title),description:o(s.description),requiredArtifacts:["devtoolsLogs"]}}
static async audit(e,t){const r=e.devtoolsLogs[n.DEFAULT_PASS],s=await a.request(r,t);let l=0;const c=[];for(const[e,t]of s.serverResponseTimeByOrigin.entries())e.startsWith("http")&&(l=Math.max(t,l),c.push({origin:e,serverResponseTime:t}));c.sort((e,t)=>t.serverResponseTime-e.serverResponseTime);const u=[{key:"origin",itemType:"text",text:o(i.UIStrings.columnURL)},{key:"serverResponseTime",itemType:"ms",granularity:1,text:o(i.UIStrings.columnTimeSpent)}],d=n.makeTableDetails(u,c);return{score:Math.max(1-l/500,0),numericValue:l,numericUnit:"millisecond",displayValue:o(i.UIStrings.ms,{timeInMs:l}),details:d}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/network-server-latency.js")},{"../computed/network-analysis.js":39,"../lib/i18n/i18n.js":78,"./audit.js":3}],"../audits/no-unload-listeners":[function(e,t,r){(function(r){"use strict";const n=e("./audit.js"),i=e("./../lib/i18n/i18n.js"),a={title:"Avoids `unload` event listeners",
failureTitle:"Registers an `unload` listener",description:"The `unload` event does not fire reliably and listening for it can prevent browser optimizations like the Back-Forward Cache. Consider using the `pagehide` or `visibilitychange` events instead. [Learn More](https://developers.google.com/web/updates/2018/07/page-lifecycle-api#the-unload-event)"},s=i.createMessageInstanceIdFn(r,a);t.exports=class NoUnloadListeners extends n{static get meta(){return{id:"no-unload-listeners",title:s(a.title),failureTitle:s(a.failureTitle),description:s(a.description),requiredArtifacts:["GlobalListeners","JsUsage"]}}static audit(e){const t=e.GlobalListeners.filter(e=>"unload"===e.type);if(!t.length)return{score:1};const r=[{key:"source",itemType:"source-location",text:s(i.UIStrings.columnURL)}],a=new Map;for(const[t,r]of Object.entries(e.JsUsage))for(const e of r)a.set(e.scriptId,t);const o=t.map(e=>{const t=a.get(e.scriptId);return t?{source:{type:"source-location",url:t,urlProvider:"network",
line:e.lineNumber,column:e.columnNumber}}:{source:{type:"url",value:"(unknown)"}}});return{score:0,details:n.makeTableDetails(r,o)}}},t.exports.UIStrings=a}).call(this,"/lighthouse-core/audits/no-unload-listeners.js")},{"./../lib/i18n/i18n.js":78,"./audit.js":3}],"../audits/non-composited-animations":[function(e,t,r){(function(r){"use strict";const n=e("./audit.js"),i=e("../lib/i18n/i18n.js"),a={title:"Avoid non-composited animations",description:"Animations which are not composited can be janky and increase CLS. [Learn more](https://web.dev/non-composited-animations)",displayValue:"{itemCount, plural,\n  =1 {# animated element found}\n  other {# animated elements found}\n  }",unsupportedCSSProperty:"{propertyCount, plural,\n    =1 {Unsupported CSS Property: {properties}}\n    other {Unsupported CSS Properties: {properties}}\n  }",transformDependsBoxSize:"Transform-related property depends on box size",filterMayMovePixels:"Filter-related property may move pixels",
nonReplaceCompositeMode:'Effect has composite mode other than "replace"',incompatibleAnimations:"Target has another animation which is incompatible",unsupportedTimingParameters:"Effect has unsupported timing parameters"},s=i.createMessageInstanceIdFn(r,a),o=[{flag:8192,text:a.unsupportedCSSProperty},{flag:2048,text:a.transformDependsBoxSize},{flag:4096,text:a.filterMayMovePixels},{flag:16,text:a.nonReplaceCompositeMode},{flag:64,text:a.incompatibleAnimations},{flag:8,text:a.unsupportedTimingParameters}];function getActionableFailureReasons(e,t){return o.filter(t=>e&t.flag).map(e=>e.text===a.unsupportedCSSProperty?s(e.text,{propertyCount:t.length,properties:t.join(", ")}):s(e.text))}t.exports=class NonCompositedAnimations extends n{static get meta(){return{id:"non-composited-animations",scoreDisplayMode:n.SCORING_MODES.INFORMATIVE,title:s(a.title),description:s(a.description),requiredArtifacts:["TraceElements","HostUserAgent"]}}static async audit(e){
const t=e.HostUserAgent.match(/Chrome\/(\d+)/);if(!t||Number(t[1])<86)return{score:1,notApplicable:!0};const r=[];let o=!1;e.TraceElements.forEach(e=>{if("animation"!==e.traceEventType)return;const t={type:"node",path:e.devtoolsNodePath,selector:e.selector,nodeLabel:e.nodeLabel,snippet:e.snippet},n=e.animations||[],i=new Map;for(const{name:e,failureReasonsMask:t,unsupportedProperties:r}of n){if(!t)continue;const n=getActionableFailureReasons(t,r||[]);for(const t of n){e&&(o=!0);const r=i.get(e)||new Set;r.add(t),i.set(e,r)}}if(!i.size)return;const a=[];for(const[e,t]of i)for(const r of t)a.push({failureReason:r,animation:e});r.push({node:t,subItems:{type:"subitems",items:a}})});const l=[{key:"node",itemType:"node",subItemsHeading:{key:"failureReason",itemType:"text"},text:s(i.UIStrings.columnElement)}];o&&l.push({key:null,itemType:"text",subItemsHeading:{key:"animation",itemType:"text"},text:s(i.UIStrings.columnName)});const c=n.makeTableDetails(l,r);let u
;return r.length>0&&(u=s(a.displayValue,{itemCount:r.length})),{score:0===r.length?1:0,notApplicable:0===r.length,details:c,displayValue:u}}},t.exports.UIStrings=a}).call(this,"/lighthouse-core/audits/non-composited-animations.js")},{"../lib/i18n/i18n.js":78,"./audit.js":3}],"../audits/offline-start-url":[function(e,t,r){(function(r){"use strict";const n=e("./audit.js"),i=e("../lib/i18n/i18n.js"),a={title:"`start_url` responds with a 200 when offline",failureTitle:"`start_url` does not respond with a 200 when offline",description:"A service worker enables your web app to be reliable in unpredictable network conditions. [Learn more](https://web.dev/offline-start-url/).",warningCantStart:"Lighthouse couldn't read the `start_url` from the manifest. As a result, the `start_url` was assumed to be the document's URL. Error message: '{manifestWarning}'.",errorLoading:"Error loading {url} in Service Worker, got status code {statusCode}"},s=i.createMessageInstanceIdFn(r,a)
;t.exports=class OfflineStartUrl extends n{static get meta(){return{id:"offline-start-url",title:s(a.title),failureTitle:s(a.failureTitle),description:s(a.description),requiredArtifacts:["WebAppManifest","StartUrl"]}}static audit(e){const t=[],r=e.WebAppManifest;if(r&&r.value&&r.value.start_url.warning){const e=r.value.start_url.warning;t.push(s(a.warningCantStart,{manifestWarning:e}))}const n=200===e.StartUrl.statusCode;let i=e.StartUrl.explanation;return i||-1===e.StartUrl.statusCode||n||(i=s(a.errorLoading,{url:e.StartUrl.url||"",statusCode:e.StartUrl.statusCode})),{score:Number(n),explanation:i,warnings:t}}},t.exports.UIStrings=a}).call(this,"/lighthouse-core/audits/offline-start-url.js")},{"../lib/i18n/i18n.js":78,"./audit.js":3}],"../audits/performance-budget":[function(e,t,r){(function(r){"use strict";const n=e("./audit.js"),i=e("../computed/resource-summary.js"),a=e("../computed/main-resource.js"),s=e("../config/budget.js"),o=e("../lib/i18n/i18n.js"),l={
title:"Performance budget",description:"Keep the quantity and size of network requests under the targets set by the provided performance budget. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/budgets).",requestCountOverBudget:"{count, plural,\n    =1 {1 request}\n    other {# requests}\n   }"},c=o.createMessageInstanceIdFn(r,l);t.exports=class ResourceBudget extends n{static get meta(){return{id:"performance-budget",title:c(l.title),description:c(l.description),scoreDisplayMode:n.SCORING_MODES.INFORMATIVE,requiredArtifacts:["devtoolsLogs","URL"]}}static getRowLabel(e){return{total:o.UIStrings.totalResourceType,document:o.UIStrings.documentResourceType,script:o.UIStrings.scriptResourceType,stylesheet:o.UIStrings.stylesheetResourceType,image:o.UIStrings.imageResourceType,media:o.UIStrings.mediaResourceType,font:o.UIStrings.fontResourceType,other:o.UIStrings.otherResourceType,"third-party":o.UIStrings.thirdPartyResourceType}[e]}static tableItems(e,t){
return Object.keys(t).map(r=>{const n=c(this.getRowLabel(r)),i=t[r].count,a=t[r].transferSize;let s,o;if(e.resourceSizes){const t=e.resourceSizes.find(e=>e.resourceType===r);t&&a>1024*t.budget&&(s=a-1024*t.budget)}if(e.resourceCounts){const t=e.resourceCounts.find(e=>e.resourceType===r);if(t&&i>t.budget){const e=i-t.budget;o=c(l.requestCountOverBudget,{count:e})}}return{resourceType:r,label:n,requestCount:i,transferSize:a,countOverBudget:o,sizeOverBudget:s}}).filter(t=>!(!e.resourceSizes||!e.resourceSizes.some(e=>e.resourceType===t.resourceType))||!(!e.resourceCounts||!e.resourceCounts.some(e=>e.resourceType===t.resourceType))).sort((e,t)=>(t.sizeOverBudget||0)-(e.sizeOverBudget||0))}static async audit(e,t){const r=e.devtoolsLogs[n.DEFAULT_PASS],l=await i.request({devtoolsLog:r,URL:e.URL},t),u=await a.request({URL:e.URL,devtoolsLog:r},t),d=s.getMatchingBudget(t.settings.budgets,u.url);if(!d)return{score:0,notApplicable:!0};const m=[{key:"label",itemType:"text",
text:c(o.UIStrings.columnResourceType)},{key:"requestCount",itemType:"numeric",text:c(o.UIStrings.columnRequests)},{key:"transferSize",itemType:"bytes",text:c(o.UIStrings.columnTransferSize)},{key:"countOverBudget",itemType:"text",text:""},{key:"sizeOverBudget",itemType:"bytes",text:c(o.UIStrings.columnOverBudget)}];return{details:n.makeTableDetails(m,this.tableItems(d,l)),score:1}}},t.exports.UIStrings=l}).call(this,"/lighthouse-core/audits/performance-budget.js")},{"../computed/main-resource.js":13,"../computed/resource-summary.js":42,"../config/budget.js":50,"../lib/i18n/i18n.js":78,"./audit.js":3}],"../audits/predictive-perf":[function(e,t,r){"use strict"
;const n=e("./audit.js"),i=e("../report/html/renderer/i18n.js"),a=e("../computed/metrics/lantern-first-contentful-paint.js"),s=e("../computed/metrics/lantern-first-meaningful-paint.js"),o=e("../computed/metrics/lantern-interactive.js"),l=e("../computed/metrics/lantern-first-cpu-idle.js"),c=e("../computed/metrics/lantern-speed-index.js"),u=e("../computed/metrics/lantern-estimated-input-latency.js"),d=e("../computed/metrics/lantern-largest-contentful-paint.js"),m=3651,p=1e4;t.exports=class PredictivePerf extends n{static get meta(){return{id:"predictive-perf",title:"Predicted Performance (beta)",description:"Predicted performance evaluates how your site will perform under a cellular connection on a mobile device.",scoreDisplayMode:n.SCORING_MODES.NUMERIC,requiredArtifacts:["traces","devtoolsLogs"]}}static async audit(e,t){const r=e.traces[n.DEFAULT_PASS],h=e.devtoolsLogs[n.DEFAULT_PASS],g={},f=await a.request({trace:r,devtoolsLog:h,settings:g},t),b=await s.request({trace:r,devtoolsLog:h,
settings:g},t),y=await o.request({trace:r,devtoolsLog:h,settings:g},t),v=await l.request({trace:r,devtoolsLog:h,settings:g},t),w=await c.request({trace:r,devtoolsLog:h,settings:g},t),k=await u.request({trace:r,devtoolsLog:h,settings:g},t),x=await d.request({trace:r,devtoolsLog:h,settings:g},t),T={roughEstimateOfFCP:f.timing,optimisticFCP:f.optimisticEstimate.timeInMs,pessimisticFCP:f.pessimisticEstimate.timeInMs,roughEstimateOfFMP:b.timing,optimisticFMP:b.optimisticEstimate.timeInMs,pessimisticFMP:b.pessimisticEstimate.timeInMs,roughEstimateOfTTI:y.timing,optimisticTTI:y.optimisticEstimate.timeInMs,pessimisticTTI:y.pessimisticEstimate.timeInMs,roughEstimateOfTTFCPUI:v.timing,optimisticTTFCPUI:v.optimisticEstimate.timeInMs,pessimisticTTFCPUI:v.pessimisticEstimate.timeInMs,roughEstimateOfSI:w.timing,optimisticSI:w.optimisticEstimate.timeInMs,pessimisticSI:w.pessimisticEstimate.timeInMs,roughEstimateOfEIL:k.timing,optimisticEIL:k.optimisticEstimate.timeInMs,
pessimisticEIL:k.pessimisticEstimate.timeInMs,roughEstimateOfLCP:x.timing,optimisticLCP:x.optimisticEstimate.timeInMs,pessimisticLCP:x.pessimisticEstimate.timeInMs},S=n.computeLogNormalScore({p10:m,median:p},T.roughEstimateOfTTI),j=new i(t.settings.locale);return{score:S,numericValue:T.roughEstimateOfTTI,numericUnit:"millisecond",displayValue:j.formatMilliseconds(T.roughEstimateOfTTI),details:{type:"debugdata",items:[T]}}}}},{"../computed/metrics/lantern-estimated-input-latency.js":22,"../computed/metrics/lantern-first-contentful-paint.js":23,"../computed/metrics/lantern-first-cpu-idle.js":24,"../computed/metrics/lantern-first-meaningful-paint.js":25,"../computed/metrics/lantern-interactive.js":26,"../computed/metrics/lantern-largest-contentful-paint.js":27,"../computed/metrics/lantern-speed-index.js":30,"../report/html/renderer/i18n.js":104,"./audit.js":3}],"../audits/preload-fonts":[function(e,t,r){(function(r){"use strict"
;const n=e("./audit.js"),i=e("./../lib/i18n/i18n.js"),a=e("./../audits/font-display.js"),s=/^(optional)$/,o=e("../computed/network-records.js"),l={title:"Fonts with `font-display: optional` are preloaded",failureTitle:"Fonts with `font-display: optional` are not preloaded",description:"Preload `optional` fonts so first-time visitors may use them. [Learn More](https://web.dev/preload-optional-fonts/)"},c=i.createMessageInstanceIdFn(r,l);class PreloadFontsAudit extends n{static get meta(){return{id:"preload-fonts",title:c(l.title),failureTitle:c(l.failureTitle),description:c(l.description),requiredArtifacts:["devtoolsLogs","URL","CSSUsage"]}}static getURLsAttemptedToPreload(e){const t=e.filter(e=>"Font"===e.resourceType).filter(e=>e.isLinkPreload).map(e=>e.url);return new Set(t)}static async audit(e,t){
const r=e.devtoolsLogs[this.DEFAULT_PASS],l=await o.request(r,t),u=a.findFontDisplayDeclarations(e,s).passingURLs,d=PreloadFontsAudit.getURLsAttemptedToPreload(l),m=Array.from(u).filter(e=>!d.has(e)).map(e=>({url:e})),p=[{key:"url",itemType:"url",text:c(i.UIStrings.columnURL)}];return{score:m.length>0?0:1,details:n.makeTableDetails(p,m),notApplicable:0===u.size}}}t.exports=PreloadFontsAudit,t.exports.UIStrings=l}).call(this,"/lighthouse-core/audits/preload-fonts.js")},{"../computed/network-records.js":40,"./../audits/font-display.js":"../audits/font-display","./../lib/i18n/i18n.js":78,"./audit.js":3}],"../audits/redirects-http":[function(e,t,r){(function(r){"use strict";const n=e("./audit.js"),i=e("../lib/i18n/i18n.js"),a={title:"Redirects HTTP traffic to HTTPS",failureTitle:"Does not redirect HTTP traffic to HTTPS",
description:"If you've already set up HTTPS, make sure that you redirect all HTTP traffic to HTTPS in order to enable secure web features for all your users. [Learn more](https://web.dev/redirects-http/)."},s=i.createMessageInstanceIdFn(r,a);t.exports=class RedirectsHTTP extends n{static get meta(){return{id:"redirects-http",title:s(a.title),failureTitle:s(a.failureTitle),description:s(a.description),requiredArtifacts:["HTTPRedirect"]}}static audit(e){return{score:Number(e.HTTPRedirect.value)}}},t.exports.UIStrings=a}).call(this,"/lighthouse-core/audits/redirects-http.js")},{"../lib/i18n/i18n.js":78,"./audit.js":3}],"../audits/redirects":[function(e,t,r){(function(r){"use strict";const n=e("./audit.js"),i=e("./byte-efficiency/byte-efficiency-audit.js"),a=e("../lib/i18n/i18n.js"),s=e("../computed/trace-of-tab.js"),o=e("../computed/network-records.js"),l=e("../computed/main-resource.js"),c=e("../computed/metrics/lantern-interactive.js"),u={title:"Avoid multiple page redirects",
description:"Redirects introduce additional delays before the page can be loaded. [Learn more](https://web.dev/redirects/)."},d=a.createMessageInstanceIdFn(r,u);class Redirects extends n{static get meta(){return{id:"redirects",title:d(u.title),description:d(u.description),scoreDisplayMode:n.SCORING_MODES.NUMERIC,requiredArtifacts:["URL","devtoolsLogs","traces"]}}static getDocumentRequestChain(e,t,r){const n=[];for(const e of r.processEvents){if("navigationStart"!==e.name)continue;const r=e.args.data||{};if(!r.documentLoaderURL||!r.isLoadingMainFrame)continue;let i=t.find(e=>e.url===r.documentLoaderURL);for(;i;)n.push(i),i=i.redirectDestination}return n.length?n:(e.redirects||[]).concat(e)}static async audit(e,t){const r=t.settings,u=e.traces[n.DEFAULT_PASS],m=e.devtoolsLogs[n.DEFAULT_PASS],p=await s.request(u,t),h=await o.request(m,t),g=await l.request({URL:e.URL,devtoolsLog:m},t),f={trace:u,devtoolsLog:m,traceOfTab:p,networkRecords:h,settings:r},b=await c.request(f,t),y=new Map
;for(const[e,t]of b.pessimisticEstimate.nodeTimings.entries())if("network"===e.type){const r=e;y.set(r.record.url,t)}const v=Redirects.getDocumentRequestChain(g,h,p);let w=0;const k=[];for(let e=0;e<v.length&&!(v.length<2);e++){const t=v[e],n=v[e+1]||t,i=y.get(t.url),a=y.get(n.url);if(!i||!a)throw new Error("Could not find redirects in graph");const s=a.startTime-i.startTime,o=n.startTime-t.startTime,l="simulate"===r.throttlingMethod?s:1e3*o;w+=l,k.push({url:t.url,wastedMs:l})}const x=[{key:"url",valueType:"url",label:d(a.UIStrings.columnURL)},{key:"wastedMs",valueType:"timespanMs",label:d(a.UIStrings.columnTimeSpent)}],T=n.makeOpportunityDetails(x,k,w);return{score:v.length<=2?1:i.scoreForWastedMs(w),numericValue:w,numericUnit:"millisecond",displayValue:w?d(a.UIStrings.displayValueMsSavings,{wastedMs:w}):"",details:T}}}t.exports=Redirects,t.exports.UIStrings=u}).call(this,"/lighthouse-core/audits/redirects.js")},{"../computed/main-resource.js":13,
"../computed/metrics/lantern-interactive.js":26,"../computed/network-records.js":40,"../computed/trace-of-tab.js":45,"../lib/i18n/i18n.js":78,"./audit.js":3,"./byte-efficiency/byte-efficiency-audit.js":4}],"../audits/resource-summary":[function(e,t,r){(function(r){"use strict";const n=e("./audit.js"),i=e("../computed/resource-summary.js"),a=e("../lib/i18n/i18n.js"),s={title:"Keep request counts low and transfer sizes small",description:"To set budgets for the quantity and size of page resources, add a budget.json file. [Learn more](https://web.dev/use-lighthouse-for-performance-budgets/).",displayValue:"{requestCount, plural, =1 {1 request • {byteCount, number, bytes} KiB} other {# requests • {byteCount, number, bytes} KiB}}"},o=a.createMessageInstanceIdFn(r,s);t.exports=class ResourceSummary extends n{static get meta(){return{id:"resource-summary",title:o(s.title),description:o(s.description),scoreDisplayMode:n.SCORING_MODES.INFORMATIVE,requiredArtifacts:["devtoolsLogs","URL"]}}
static async audit(e,t){const r=e.devtoolsLogs[n.DEFAULT_PASS],l=await i.request({devtoolsLog:r,URL:e.URL},t),c=[{key:"label",itemType:"text",text:o(a.UIStrings.columnResourceType)},{key:"requestCount",itemType:"numeric",text:o(a.UIStrings.columnRequests)},{key:"transferSize",itemType:"bytes",text:o(a.UIStrings.columnTransferSize)}],u={total:o(a.UIStrings.totalResourceType),document:o(a.UIStrings.documentResourceType),script:o(a.UIStrings.scriptResourceType),stylesheet:o(a.UIStrings.stylesheetResourceType),image:o(a.UIStrings.imageResourceType),media:o(a.UIStrings.mediaResourceType),font:o(a.UIStrings.fontResourceType),other:o(a.UIStrings.otherResourceType),"third-party":o(a.UIStrings.thirdPartyResourceType)},d=Object.keys(l).map(e=>({resourceType:e,label:u[e],requestCount:l[e].count,transferSize:l[e].transferSize})),m=d.find(e=>"third-party"===e.resourceType)||[],p=d.filter(e=>"third-party"!==e.resourceType).sort((e,t)=>t.transferSize-e.transferSize).concat(m);return{
details:n.makeTableDetails(c,p),score:1,displayValue:o(s.displayValue,{requestCount:l.total.count,byteCount:l.total.transferSize})}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/resource-summary.js")},{"../computed/resource-summary.js":42,"../lib/i18n/i18n.js":78,"./audit.js":3}],"../audits/screenshot-thumbnails":[function(e,t,r){"use strict";const n=e("./audit.js"),i=e("../lib/lh-error.js"),a=e("jpeg-js"),s=e("../computed/speedline.js"),o=e("../computed/metrics/interactive.js"),l=10,c=120;class ScreenshotThumbnails extends n{static get meta(){return{id:"screenshot-thumbnails",scoreDisplayMode:n.SCORING_MODES.INFORMATIVE,title:"Screenshot Thumbnails",description:"This is what the load of your site looked like.",requiredArtifacts:["traces","devtoolsLogs"]}}static scaleImageToThumbnail(e){const t=c,r=e.width/t,n=Math.floor(e.height/r),i=new Uint8Array(t*n*4);for(let a=0;a<t;a++)for(let s=0;s<n;s++){const n=Math.floor(a*r),o=4*(Math.floor(s*r)*e.width+n),l=4*(s*t+a)
;i[l]=e.data[o],i[l+1]=e.data[o+1],i[l+2]=e.data[o+2],i[l+3]=e.data[o+3]}return{width:t,height:n,data:i}}static async audit(e,t){const r=e.traces[n.DEFAULT_PASS],c=new Map,u=await s.request(r,t);let d=t.options.minimumTimelineDuration||3e3;if("simulate"!==t.settings.throttlingMethod){const i={trace:r,devtoolsLog:e.devtoolsLogs[n.DEFAULT_PASS],settings:t.settings},a=o.request(i,t);try{d=Math.max((await a).timing,d)}catch(e){}}const m=[],p=u.frames.filter(e=>!e.isProgressInterpolated()),h=u.complete||Math.max(...u.frames.map(e=>e.getTimeStamp()-u.beginning)),g=Math.max(h,d);if(!p.length||!Number.isFinite(g))throw new i(i.errors.INVALID_SPEEDLINE);for(let e=1;e<=l;e++){const t=u.beginning+g*e/l;let r,n=null;e===l?n=p[p.length-1]:p.forEach(e=>{e.getTimeStamp()<=t&&(n=e)});const i=c.get(n);if(i)r=i;else{const e=n.getParsedImage(),t=ScreenshotThumbnails.scaleImageToThumbnail(e);r=a.encode(t,90).data.toString("base64"),c.set(n,r)}m.push({timing:Math.round(t-u.beginning),timestamp:1e3*t,
data:`data:image/jpeg;base64,${r}`})}return{score:1,details:{type:"filmstrip",scale:g,items:m}}}}t.exports=ScreenshotThumbnails},{"../computed/metrics/interactive.js":21,"../computed/speedline.js":44,"../lib/lh-error.js":86,"./audit.js":3,"jpeg-js":138}],"../audits/seo/canonical":[function(e,t,r){(function(r){"use strict";const n=e("../audit.js"),i=e("../../lib/url-shim.js"),a=e("../../computed/main-resource.js"),s=e("../../lib/i18n/i18n.js"),o={title:"Document has a valid `rel=canonical`",failureTitle:"Document does not have a valid `rel=canonical`",description:"Canonical links suggest which URL to show in search results. [Learn more](https://web.dev/canonical/).",explanationConflict:"Multiple conflicting URLs ({urlList})",explanationInvalid:"Invalid URL ({url})",explanationRelative:"Relative URL ({url})",explanationPointsElsewhere:"Points to another `hreflang` location ({url})",explanationDifferentDomain:"Points to a different domain ({url})",
explanationRoot:"Points to the domain's root URL (the homepage), instead of an equivalent page of content"},l=s.createMessageInstanceIdFn(r,o);class Canonical extends n{static get meta(){return{id:"canonical",title:l(o.title),failureTitle:l(o.failureTitle),description:l(o.description),requiredArtifacts:["LinkElements","URL","devtoolsLogs"]}}static collectCanonicalURLs(e){const t=new Set,r=new Set;let n,a;for(const s of e)if("body"!==s.source)if("canonical"===s.rel){if(!s.hrefRaw)continue;s.href?i.isValid(s.hrefRaw)?t.add(s.href):a=s:n=s}else"alternate"===s.rel&&s.href&&s.hreflang&&r.add(s.href);return{uniqueCanonicalURLs:t,hreflangURLs:r,invalidCanonicalLink:n,relativeCanonicallink:a}}static findInvalidCanonicalURLReason(e){const{uniqueCanonicalURLs:t,invalidCanonicalLink:r,relativeCanonicallink:n}=e;if(r)return{score:0,explanation:l(o.explanationInvalid,{url:r.hrefRaw})};if(n)return{score:0,explanation:l(o.explanationRelative,{url:n.hrefRaw})};const i=Array.from(t)
;return 0===i.length?{score:1,notApplicable:!0}:i.length>1?{score:0,explanation:l(o.explanationConflict,{urlList:i.join(", ")})}:void 0}static findCommonCanonicalURLMistakes(e,t,r){const{hreflangURLs:n}=e;return n.has(r.href)&&n.has(t.href)&&r.href!==t.href?{score:0,explanation:l(o.explanationPointsElsewhere,{url:r.href})}:i.rootDomainsMatch(t,r)?t.origin===r.origin&&"/"===t.pathname&&"/"!==r.pathname?{score:0,explanation:l(o.explanationRoot)}:void 0:{score:0,explanation:l(o.explanationDifferentDomain,{url:t.href})}}static async audit(e,t){const r=e.devtoolsLogs[n.DEFAULT_PASS],s=await a.request({devtoolsLog:r,URL:e.URL},t),o=new i(s.url),l=Canonical.collectCanonicalURLs(e.LinkElements),c=Canonical.findInvalidCanonicalURLReason(l);if(c)return c;const u=new i([...l.uniqueCanonicalURLs][0]),d=Canonical.findCommonCanonicalURLMistakes(l,u,o);return d||{score:1}}}t.exports=Canonical,t.exports.UIStrings=o}).call(this,"/lighthouse-core/audits/seo/canonical.js")},{
"../../computed/main-resource.js":13,"../../lib/i18n/i18n.js":78,"../../lib/url-shim.js":"url","../audit.js":3}],"../audits/seo/crawlable-anchors":[function(e,t,r){(function(r){"use strict";const n=e("../audit.js"),i=e("../../lib/i18n/i18n.js"),a={title:"Links are crawlable",failureTitle:"Links are not crawlable",description:"Search engines may use `href` attributes on links to crawl websites. Ensure that the `href` attribute of anchor elements links to an appropriate destination, so more pages of the site can be discovered. [Learn More](https://support.google.com/webmasters/answer/9112205)",columnFailingLink:"Uncrawlable Link"},s=i.createMessageInstanceIdFn(r,a);t.exports=class CrawlableAnchors extends n{static get meta(){return{id:"crawlable-anchors",title:s(a.title),failureTitle:s(a.failureTitle),description:s(a.description),requiredArtifacts:["AnchorElements"]}}static audit({AnchorElements:e}){const t=e.filter(({rawHref:e,listeners:t=[],onclick:r="",name:n="",role:i=""})=>{
if(r=r.replace(/\s/g,""),e=e.replace(/\s/g,""),n=n.trim(),(i=i.trim()).length>0)return;return!!e.startsWith("file:")||(!!/window\.location=/.test(r)||(!!/window\.open\(/.test(r)||(t.some(({type:e})=>"click"===e)||n.length>0?void 0:""===e||(!!/javascript:void(\(|)0(\)|)/.test(e)||void 0))))}),r=[{key:"node",itemType:"node",text:s(a.columnFailingLink)}],i=t.map(e=>({node:{type:"node",path:e.devtoolsNodePath||"",selector:e.selector||"",nodeLabel:e.nodeLabel||"",snippet:e.snippet||""}}));return{score:Number(0===t.length),details:n.makeTableDetails(r,i)}}},t.exports.UIStrings=a}).call(this,"/lighthouse-core/audits/seo/crawlable-anchors.js")},{"../../lib/i18n/i18n.js":78,"../audit.js":3}],"../audits/seo/font-size":[function(e,t,r){(function(r){"use strict";const n=e("../../lib/i18n/i18n.js"),i=e("../audit.js"),a=e("../../computed/viewport-meta.js"),s=60,o={title:"Document uses legible font sizes",failureTitle:"Document doesn't use legible font sizes",
description:"Font sizes less than 12px are too small to be legible and require mobile visitors to “pinch to zoom” in order to read. Strive to have >60% of page text ≥12px. [Learn more](https://web.dev/font-size/).",displayValue:"{decimalProportion, number, extendedPercent} legible text",explanationViewport:"Text is illegible because there's no viewport meta tag optimized for mobile screens.",additionalIllegibleText:"Add'l illegible text",legibleText:"Legible text",columnSelector:"Selector",columnPercentPageText:"% of Page Text",columnFontSize:"Font Size"},l=n.createMessageInstanceIdFn(r,o);function getSelector(e){const t=function getAttributeMap(e=[]){const t=new Map;for(let r=0;r<e.length;r+=2){const n=e[r].toLowerCase(),i=e[r+1].trim();i&&t.set(n,i)}return t}(e.attributes);if(t.has("id"))return"#"+t.get("id");{const e=t.get("class");if(e)return"."+e.split(/\s+/).join(".")}return e.nodeName.toLowerCase()}function nodeToTableNode(e){
const t=(e.attributes||[]).map((e,t)=>t%2==0?` ${e}`:`="${e}"`).join("");return{type:"node",selector:e.parentNode?getSelector(e.parentNode):"",snippet:`<${e.nodeName.toLowerCase()}${t}>`}}t.exports=class FontSize extends i{static get meta(){return{id:"font-size",title:l(o.title),failureTitle:l(o.failureTitle),description:l(o.description),requiredArtifacts:["FontSize","URL","MetaElements","TestedAsMobileDevice"]}}static async audit(e,t){if(!e.TestedAsMobileDevice)return{score:1,notApplicable:!0};if(!(await a.request(e.MetaElements,t)).isMobileOptimized)return{score:0,explanation:l(o.explanationViewport)};const{analyzedFailingNodesData:r,analyzedFailingTextLength:c,failingTextLength:u,totalTextLength:d}=e.FontSize;if(0===d)return{score:1};const m=function getUniqueFailingRules(e){const t=new Map;return e.forEach(e=>{const{nodeId:r,cssRule:n,fontSize:i,textLength:a,parentNode:s}=e,o=function getFontArtifactId(e,t){if(e&&"Regular"===e.type){
const t=e.range?e.range.startLine:0,r=e.range?e.range.startColumn:0;return`${e.styleSheetId}@${t}:${r}`}return`node_${t}`}(n,r),l=t.get(o);l?l.textLength+=a:t.set(o,{nodeId:r,parentNode:s,cssRule:n,fontSize:i,textLength:a})}),[...t.values()]}(r),p=(d-u)/d*100,h=e.URL.finalUrl,g=[{key:"source",itemType:"source-location",text:l(n.UIStrings.columnSource)},{key:"selector",itemType:"code",text:l(o.columnSelector)},{key:"coverage",itemType:"text",text:l(o.columnPercentPageText)},{key:"fontSize",itemType:"text",text:l(o.columnFontSize)}],f=m.sort((e,t)=>t.textLength-e.textLength).map(({cssRule:e,textLength:t,fontSize:r,parentNode:n})=>{const i=t/d*100,a=function findStyleRuleSource(e,t,r){if(!t||"Attributes"===t.type||"Inline"===t.type)return{source:{type:"url",value:e},selector:nodeToTableNode(r)};if(t.parentRule&&"user-agent"===t.parentRule.origin)return{source:{type:"code",value:"User Agent Stylesheet"},selector:t.parentRule.selectors.map(e=>e.text).join(", ")};let n="";if(t.parentRule){
n=t.parentRule.selectors.map(e=>e.text).join(", ")}if(t.stylesheet&&!t.stylesheet.sourceURL)return{source:{type:"code",value:"dynamic"},selector:n};if(t.stylesheet&&t.range){const{range:e,stylesheet:r}=t,i=r.hasSourceURL?"comment":"network";let a=e.startLine,s=e.startColumn;return r.isInline&&"comment"!==i&&(a+=r.startLine,0===e.startLine&&(s+=r.startColumn)),{source:{type:"source-location",url:r.sourceURL,urlProvider:i,line:a,column:s},selector:n}}return{selector:n,source:{type:"code",value:"Unknown"}}}(h,e,n);return{source:a.source,selector:a.selector,coverage:`${i.toFixed(2)}%`,fontSize:`${r}px`}});if(c<u){const e=(u-c)/d*100;f.push({source:{type:"code",value:l(o.additionalIllegibleText)},selector:"",coverage:`${e.toFixed(2)}%`,fontSize:"< 12px"})}p>0&&f.push({source:{type:"code",value:l(o.legibleText)},selector:"",coverage:`${p.toFixed(2)}%`,fontSize:"≥ 12px"});const b=p/100,y=l(o.displayValue,{decimalProportion:b}),v=i.makeTableDetails(g,f);return{score:Number(p>=s),details:v,
displayValue:y}}},t.exports.UIStrings=o}).call(this,"/lighthouse-core/audits/seo/font-size.js")},{"../../computed/viewport-meta.js":49,"../../lib/i18n/i18n.js":78,"../audit.js":3}],"../audits/seo/hreflang":[function(e,t,r){(function(r,n){"use strict";const i=e("../audit.js"),a=function importValidLangs(){const t=r.axe;r.axe={utils:{}},e("axe-core/lib/core/utils/valid-langs.js");const n=r.axe.utils.validLangs();return r.axe=t,n}(),s="x-default",o=e("../../lib/i18n/i18n.js"),l={title:"Document has a valid `hreflang`",failureTitle:"Document doesn't have a valid `hreflang`",description:"hreflang links tell search engines what version of a page they should list in search results for a given language or region. [Learn more](https://web.dev/hreflang/).",unexpectedLanguage:"Unexpected language code",notFullyQualified:"Relative href value"},c=o.createMessageInstanceIdFn(n,l);function isExpectedLanguageCode(e){if(e.toLowerCase()===s)return!0;const[t]=e.split("-")
;return a.includes(t.toLowerCase())}t.exports=class Hreflang extends i{static get meta(){return{id:"hreflang",title:c(l.title),failureTitle:c(l.failureTitle),description:c(l.description),requiredArtifacts:["LinkElements","URL"]}}static audit({LinkElements:e}){const t=[],r=e.filter(e=>{const t="alternate"===e.rel,r=e.hreflang,n="body"===e.source;return t&&r&&!n});for(const e of r){const r=[];let i;isExpectedLanguageCode(e.hreflang)||r.push(c(l.unexpectedLanguage)),(n=e.hrefRaw.toLowerCase()).startsWith("http:")||n.startsWith("https:")||r.push(c(l.notFullyQualified)),"head"===e.source?i={type:"node",snippet:`<link rel="alternate" hreflang="${e.hreflang}" href="${e.hrefRaw}" />`,path:e.devtoolsNodePath||"",selector:e.selector||"",nodeLabel:e.nodeLabel||""}:"headers"===e.source&&(i=`Link: <${e.hrefRaw}>; rel="alternate"; hreflang="${e.hreflang}"`),i&&r.length&&t.push({source:i,subItems:{type:"subitems",items:r.map(e=>({reason:e}))}})}var n;const a=i.makeTableDetails([{key:"source",
itemType:"code",subItemsHeading:{key:"reason",itemType:"text"},text:""}],t);return{score:Number(0===t.length),details:a}}},t.exports.UIStrings=l}).call(this,"undefined"!=typeof global?global:"undefined"!=typeof self?self:"undefined"!=typeof window?window:{},"/lighthouse-core/audits/seo/hreflang.js")},{"../../lib/i18n/i18n.js":78,"../audit.js":3,"axe-core/lib/core/utils/valid-langs.js":114}],"../audits/seo/http-status-code":[function(e,t,r){(function(r){"use strict";const n=e("../audit.js"),i=e("../../computed/main-resource.js"),a=400,s=599,o=e("../../lib/i18n/i18n.js"),l={title:"Page has successful HTTP status code",failureTitle:"Page has unsuccessful HTTP status code",description:"Pages with unsuccessful HTTP status codes may not be indexed properly. [Learn more](https://web.dev/http-status-code/)."},c=o.createMessageInstanceIdFn(r,l);t.exports=class HTTPStatusCode extends n{static get meta(){return{id:"http-status-code",title:c(l.title),failureTitle:c(l.failureTitle),
description:c(l.description),requiredArtifacts:["devtoolsLogs","URL"]}}static audit(e,t){const r=e.devtoolsLogs[n.DEFAULT_PASS],o=e.URL;return i.request({devtoolsLog:r,URL:o},t).then(e=>{const t=e.statusCode;return t>=a&&t<=s?{score:0,displayValue:`${t}`}:{score:1}})}},t.exports.UIStrings=l}).call(this,"/lighthouse-core/audits/seo/http-status-code.js")},{"../../computed/main-resource.js":13,"../../lib/i18n/i18n.js":78,"../audit.js":3}],"../audits/seo/is-crawlable":[function(e,t,r){(function(r){"use strict";const n=e("../audit.js"),i=e("robots-parser"),a=e("../../lib/url-shim.js"),s=e("../../computed/main-resource.js"),o=new Set(["noindex","none"]),l="x-robots-tag",c="unavailable_after",u=e("../../lib/i18n/i18n.js"),d={title:"Page isn’t blocked from indexing",failureTitle:"Page is blocked from indexing",description:"Search engines are unable to include your pages in search results if they don't have permission to crawl them. [Learn more](https://web.dev/is-crawable/)."
},m=u.createMessageInstanceIdFn(r,d);function hasBlockingDirective(e){return e.split(",").map(e=>e.toLowerCase().trim()).some(e=>o.has(e)||function isUnavailable(e){const t=e.split(":");if(t.length<=1||t[0]!==c)return!1;const r=Date.parse(t.slice(1).join(":"));return!isNaN(r)&&r<Date.now()}(e))}t.exports=class IsCrawlable extends n{static get meta(){return{id:"is-crawlable",title:m(d.title),failureTitle:m(d.failureTitle),description:m(d.description),requiredArtifacts:["MetaElements","RobotsTxt","URL","devtoolsLogs"]}}static audit(e,t){const r=e.devtoolsLogs[n.DEFAULT_PASS],o=e.MetaElements.find(e=>"robots"===e.name);return s.request({devtoolsLog:r,URL:e.URL},t).then(t=>{const r=[];if(o){const e=o.content||"";hasBlockingDirective(e)&&r.push({source:{type:"node",snippet:`<meta name="robots" content="${e}" />`}})}if(t.responseHeaders&&t.responseHeaders.filter(e=>e.name.toLowerCase()===l&&!function hasUserAgent(e){const t=e.match(/^([^,:]+):/);return!!t&&t[1].toLowerCase()!==c
}(e.value)&&hasBlockingDirective(e.value)).forEach(e=>r.push({source:`${e.name}: ${e.value}`})),e.RobotsTxt.content){const n=new a("/robots.txt",t.url),s=i(n.href,e.RobotsTxt.content);if(!s.isAllowed(t.url)){const e=s.getMatchingLineNumber(t.url)||1;r.push({source:{type:"source-location",url:n.href,urlProvider:"network",line:e-1,column:0}})}}const s=n.makeTableDetails([{key:"source",itemType:"code",text:"Blocking Directive Source"}],r);return{score:Number(0===r.length),details:s}})}},t.exports.UIStrings=d}).call(this,"/lighthouse-core/audits/seo/is-crawlable.js")},{"../../computed/main-resource.js":13,"../../lib/i18n/i18n.js":78,"../../lib/url-shim.js":"url","../audit.js":3,"robots-parser":203}],"../audits/seo/link-text":[function(e,t,r){(function(r){"use strict"
;const n=e("../audit.js"),i=e("../../lib/url-shim.js"),a=new Set(["click here","click this","go","here","information","learn more","more","more info","more information","right here","read more","see more","start","this","ここをクリック","こちらをクリック","リンク","続きを読む","続く","全文表示","click aquí","click aqui","clicka aquí","clicka aqui","pincha aquí","pincha aqui","aquí","aqui","más","mas","más información","más informacion","mas información","mas informacion","este","enlace","este enlace","empezar","clique aqui","ir","mais informação","mais informações","mais","veja mais","여기","여기를 클릭","클릭","링크","자세히","자세히 보기","계속","이동","전체 보기","här","klicka här","läs mer","mer","mer info","mer information"]),s=e("../../lib/i18n/i18n.js"),o={title:"Links have descriptive text",failureTitle:"Links do not have descriptive text",description:"Descriptive link text helps search engines understand your content. [Learn more](https://web.dev/link-text/).",
displayValue:"{itemCount, plural,\n    =1 {1 link found}\n    other {# links found}\n    }"},l=s.createMessageInstanceIdFn(r,o);t.exports=class LinkText extends n{static get meta(){return{id:"link-text",title:l(o.title),failureTitle:l(o.failureTitle),description:l(o.description),requiredArtifacts:["URL","AnchorElements"]}}static audit(e){const t=e.AnchorElements.filter(e=>e.href&&!e.rel.includes("nofollow")).filter(t=>{const r=t.href.toLowerCase();return!(r.startsWith("javascript:")||r.startsWith("mailto:")||i.equalWithExcludedFragments(t.href,e.URL.finalUrl))&&a.has(t.text.trim().toLowerCase())}).map(e=>({href:e.href,text:e.text.trim()})),r=n.makeTableDetails([{key:"href",itemType:"url",text:"Link destination"},{key:"text",itemType:"text",text:"Link Text"}],t,{});let s;return t.length&&(s=l(o.displayValue,{itemCount:t.length})),{score:Number(0===t.length),details:r,displayValue:s}}},t.exports.UIStrings=o}).call(this,"/lighthouse-core/audits/seo/link-text.js")},{
"../../lib/i18n/i18n.js":78,"../../lib/url-shim.js":"url","../audit.js":3}],"../audits/seo/manual/structured-data":[function(e,t,r){(function(r){"use strict";const n=e("../../manual/manual-audit.js"),i=e("../../../lib/i18n/i18n.js"),a={description:"Run the [Structured Data Testing Tool](https://search.google.com/structured-data/testing-tool/) and the [Structured Data Linter](http://linter.structured-data.org/) to validate structured data. [Learn more](https://web.dev/structured-data/).",title:"Structured data is valid"},s=i.createMessageInstanceIdFn(r,a);t.exports=class StructuredData extends n{static get meta(){return Object.assign({id:"structured-data",description:s(a.description),title:s(a.title)},super.partialMeta)}},t.exports.UIStrings=a}).call(this,"/lighthouse-core/audits/seo/manual/structured-data.js")},{"../../../lib/i18n/i18n.js":78,"../../manual/manual-audit.js":6}],"../audits/seo/meta-description":[function(e,t,r){(function(r){"use strict"
;const n=e("../audit.js"),i=e("../../lib/i18n/i18n.js"),a={title:"Document has a meta description",failureTitle:"Document does not have a meta description",description:"Meta descriptions may be included in search results to concisely summarize page content. [Learn more](https://web.dev/meta-description/).",explanation:"Description text is empty."},s=i.createMessageInstanceIdFn(r,a);t.exports=class Description extends n{static get meta(){return{id:"meta-description",title:s(a.title),failureTitle:s(a.failureTitle),description:s(a.description),requiredArtifacts:["MetaElements"]}}static audit(e){const t=e.MetaElements.find(e=>"description"===e.name);return t?0===(t.content||"").trim().length?{score:0,explanation:s(a.explanation)}:{score:1}:{score:0}}},t.exports.UIStrings=a}).call(this,"/lighthouse-core/audits/seo/meta-description.js")},{"../../lib/i18n/i18n.js":78,"../audit.js":3}],"../audits/seo/plugins":[function(e,t,r){(function(r){"use strict"
;const n=e("../audit.js"),i=e("../../lib/url-shim.js"),a="application/x-java-applet",s="application/x-java-bean",o=new Set(["application/x-shockwave-flash",a,s,"application/x-silverlight","application/x-silverlight-2"]),l=new Set(["swf","flv","class","xap"]),c=new Set(["code","movie","source","src"]),u=e("../../lib/i18n/i18n.js"),d={title:"Document avoids plugins",failureTitle:"Document uses plugins",description:"Search engines can't index plugin content, and many devices restrict plugins or don't support them. [Learn more](https://web.dev/plugins/)."},m=u.createMessageInstanceIdFn(r,d);function isPluginURL(e){try{const t=new i(e,"http://example.com").pathname.split(".");if(t.length<2)return!1;const r=t.pop();return l.has(r.trim().toLowerCase())}catch(e){return!1}}t.exports=class Plugins extends n{static get meta(){return{id:"plugins",title:m(d.title),failureTitle:m(d.failureTitle),description:m(d.description),requiredArtifacts:["EmbeddedContent"]}}static audit(e){
const t=e.EmbeddedContent.filter(e=>{if("APPLET"===e.tagName)return!0;if(("EMBED"===e.tagName||"OBJECT"===e.tagName)&&e.type&&function isPluginType(e){return e=e.trim().toLowerCase(),o.has(e)||e.startsWith(a)||e.startsWith(s)}(e.type))return!0;const t=e.src||e.code;return!("EMBED"!==e.tagName||!t||!isPluginURL(t))||(!("OBJECT"!==e.tagName||!e.data||!isPluginURL(e.data))||e.params.filter(e=>c.has(e.name.trim().toLowerCase())&&isPluginURL(e.value)).length>0)}).map(e=>{const t=e.tagName.toLowerCase();return{source:{type:"node",snippet:`<${t}${["src","data","code","type"].reduce((t,r)=>(null!==e[r]&&(t+=` ${r}="${e[r]}"`),t),"")}>${e.params.filter(e=>c.has(e.name.trim().toLowerCase())).map(e=>`<param ${e.name}="${e.value}" />`).join("")}</${t}>`}}}),r=n.makeTableDetails([{key:"source",itemType:"code",text:"Element source"}],t);return{score:Number(0===t.length),details:r}}},t.exports.UIStrings=d}).call(this,"/lighthouse-core/audits/seo/plugins.js")},{"../../lib/i18n/i18n.js":78,
"../../lib/url-shim.js":"url","../audit.js":3}],"../audits/seo/robots-txt":[function(e,t,r){(function(r){"use strict";const n=e("../audit.js"),i=e("../../lib/url-shim.js"),a=400,s=500,o="sitemap",l="user-agent",c="allow",u="disallow",d=new Set([c,u]),m=new Set([l,u,c,o,"crawl-delay","clean-param","host","request-rate","visit-time","noindex"]),p=new Set(["https:","http:","ftp:"]),h=e("../../lib/i18n/i18n.js"),g={title:"robots.txt is valid",failureTitle:"robots.txt is not valid",description:"If your robots.txt file is malformed, crawlers may not be able to understand how you want your website to be crawled or indexed. [Learn more](https://web.dev/robots-txt/).",displayValueHttpBadCode:"Request for robots.txt returned HTTP status: {statusCode}",displayValueValidationError:"{itemCount, plural,\n    =1 {1 error found}\n    other {# errors found}\n    }",explanation:"Lighthouse was unable to download a robots.txt file"},f=h.createMessageInstanceIdFn(r,g);function parseLine(e){
const t=e.indexOf("#");if(-1!==t&&(e=e.substr(0,t)),0===(e=e.trim()).length)return null;const r=e.indexOf(":");if(-1===r)throw new Error("Syntax not understood");const n=e.slice(0,r).trim().toLowerCase(),a=e.slice(r+1).trim();return function verifyDirective(e,t){if(!m.has(e))throw new Error("Unknown directive");if(e===o){let e;try{e=new i(t)}catch(e){throw new Error("Invalid sitemap URL")}if(!p.has(e.protocol))throw new Error("Invalid sitemap URL protocol")}if(e===l&&!t)throw new Error("No user-agent specified");if(e===c||e===u){if(""!==t&&"/"!==t[0]&&"*"!==t[0])throw new Error('Pattern should either be empty, start with "/" or "*"');const e=t.indexOf("$");if(-1!==e&&e!==t.length-1)throw new Error('"$" should only be used at the end of the pattern')}}(n,a),{directive:n,value:a}}t.exports=class RobotsTxt extends n{static get meta(){return{id:"robots-txt",title:f(g.title),failureTitle:f(g.failureTitle),description:f(g.description),requiredArtifacts:["RobotsTxt"]}}static audit(e){
const{status:t,content:r}=e.RobotsTxt;if(!t)return{score:0,explanation:f(g.explanation)};if(t>=s)return{score:0,displayValue:f(g.displayValueHttpBadCode,{statusCode:t})};if(t>=a||""===r)return{score:1,notApplicable:!0};if(null===r)throw new Error(`Status ${t} was valid, but content was null`);const i=function validateRobots(e){const t=[];let r=!1;return e.split(/\r\n|\r|\n/).forEach((e,n)=>{let i;try{i=parseLine(e)}catch(r){t.push({index:(n+1).toString(),line:e,message:r.message.toString()})}i&&(i.directive===l?r=!0:!r&&d.has(i.directive)&&t.push({index:(n+1).toString(),line:e,message:"No user-agent specified"}))}),t}(r),o=n.makeTableDetails([{key:"index",itemType:"text",text:"Line #"},{key:"line",itemType:"code",text:"Content"},{key:"message",itemType:"code",text:"Error"}],i,{});let c;return i.length&&(c=f(g.displayValueValidationError,{itemCount:i.length})),{score:Number(0===i.length),details:o,displayValue:c}}},t.exports.UIStrings=g
}).call(this,"/lighthouse-core/audits/seo/robots-txt.js")},{"../../lib/i18n/i18n.js":78,"../../lib/url-shim.js":"url","../audit.js":3}],"../audits/seo/tap-targets":[function(e,t,r){(function(r){"use strict";const n=e("../audit.js"),i=e("../../computed/viewport-meta.js"),{rectsTouchOrOverlap:a,getRectOverlapArea:s,getRectAtCenter:o,allRectsContainedWithinEachOther:l,getLargestRect:c,getBoundingRectWithPadding:u,getBoundingRect:d}=e("../../lib/rect-helpers.js"),{getTappableRectsFromClientRects:m}=e("../../lib/tappable-rects.js"),p=e("../../lib/i18n/i18n.js"),h={title:"Tap targets are sized appropriately",failureTitle:"Tap targets are not sized appropriately",description:"Interactive elements like buttons and links should be large enough (48x48px), and have enough space around them, to be easy enough to tap without overlapping onto other elements. [Learn more](https://web.dev/tap-targets/).",tapTargetHeader:"Tap Target",overlappingTargetHeader:"Overlapping Target",
explanationViewportMetaNotOptimized:"Tap targets are too small because there's no viewport meta tag optimized for mobile screens",displayValue:"{decimalProportion, number, percent} appropriately sized tap targets"},g=p.createMessageInstanceIdFn(r,h),f=48,b=.25;function clientRectBelowMinimumSize(e){return e.width<f||e.height<f}function getOverlapFailureForTargetPair(e,t){let r=null;for(const n of e){const e=o(n,f),i=s(e,n);for(const n of t){const t=s(e,n),a=t/i;a<b||(!r||a>r.overlapScoreRatio)&&(r={overlapScoreRatio:a,tapTargetScore:i,overlappingTargetScore:t})}}return r}function targetToTableNode(e){const t=d(e.clientRects);return{type:"node",snippet:e.snippet,path:e.devtoolsNodePath,selector:e.selector,boundingRect:t,nodeLabel:e.nodeLabel}}class TapTargets extends n{static get meta(){return{id:"tap-targets",title:g(h.title),failureTitle:g(h.failureTitle),description:g(h.description),requiredArtifacts:["MetaElements","TapTargets","TestedAsMobileDevice"]}}static async audit(e,t){
if(!e.TestedAsMobileDevice)return{score:1,notApplicable:!0};if(!(await i.request(e.MetaElements,t)).isMobileOptimized)return{score:0,explanation:g(h.explanationViewportMetaNotOptimized)};const r=function getBoundedTapTargets(e){return e.map(e=>({tapTarget:e,paddedBoundsRect:u(e.clientRects,f)}))}(e.TapTargets),s=function getAllOverlapFailures(e,t){const r=[];return e.forEach(e=>{const n=m(e.tapTarget.clientRects);for(const i of t){if(i===e)continue;if(!a(e.paddedBoundsRect,i.paddedBoundsRect))continue;if(e.tapTarget.href===i.tapTarget.href){if(/https?:\/\//.test(e.tapTarget.href))continue}const t=i.tapTarget.clientRects;if(l(n,t))continue;const s=getOverlapFailureForTargetPair(n,t);s&&r.push({...s,tapTarget:e.tapTarget,overlappingTarget:i.tapTarget})}}),r}(function getTooSmallTargets(e){return e.filter(e=>e.tapTarget.clientRects.every(clientRectBelowMinimumSize))}(r),r),o=function getTableItems(e){const t=e.map(e=>{
const t=c(e.tapTarget.clientRects),r=Math.floor(t.width),n=Math.floor(t.height),i=r+"x"+n;return{tapTarget:targetToTableNode(e.tapTarget),overlappingTarget:targetToTableNode(e.overlappingTarget),tapTargetScore:e.tapTargetScore,overlappingTargetScore:e.overlappingTargetScore,overlapScoreRatio:e.overlapScoreRatio,size:i,width:r,height:n}});return t.sort((e,t)=>t.overlapScoreRatio-e.overlapScoreRatio),t}(function mergeSymmetricFailures(e){const t=[];return e.forEach((r,n)=>{const i=e.find(e=>e.tapTarget===r.overlappingTarget&&e.overlappingTarget===r.tapTarget);if(!i)return void t.push(r);const{overlapScoreRatio:a}=r,{overlapScoreRatio:s}=i;(a>s||a===s&&n<e.indexOf(i))&&t.push(r)}),t}(s)),d=[{key:"tapTarget",itemType:"node",text:g(h.tapTargetHeader)},{key:"size",itemType:"text",text:g(p.UIStrings.columnSize)},{key:"overlappingTarget",itemType:"node",text:g(h.overlappingTargetHeader)}],b=n.makeTableDetails(d,o),y=e.TapTargets.length,v=new Set(s.map(e=>e.tapTarget)).size;let w=1,k=1
;return v>0&&(w=.89*(k=(y-v)/y)),{score:w,details:b,displayValue:g(h.displayValue,{decimalProportion:k})}}}TapTargets.FINGER_SIZE_PX=f,t.exports=TapTargets,t.exports.UIStrings=h}).call(this,"/lighthouse-core/audits/seo/tap-targets.js")},{"../../computed/viewport-meta.js":49,"../../lib/i18n/i18n.js":78,"../../lib/rect-helpers.js":92,"../../lib/tappable-rects.js":97,"../audit.js":3}],"../audits/server-response-time":[function(e,t,r){(function(r){"use strict";const n=e("./audit.js"),i=e("../lib/i18n/i18n.js"),a=e("../computed/main-resource.js"),s={title:"Initial server response time was short",failureTitle:"Reduce initial server response time",description:"Keep the server response time for the main document short because all other requests depend on it. [Learn more](https://web.dev/time-to-first-byte/).",displayValue:"Root document took {timeInMs, number, milliseconds} ms"},o=i.createMessageInstanceIdFn(r,s),l=600,c=100;class ServerResponseTime extends n{static get meta(){return{
id:"server-response-time",title:o(s.title),failureTitle:o(s.failureTitle),description:o(s.description),requiredArtifacts:["devtoolsLogs","URL"]}}static calculateResponseTime(e){const t=e.timing;return t?t.receiveHeadersEnd-t.sendEnd:0}static async audit(e,t){const r=e.devtoolsLogs[n.DEFAULT_PASS],u=await a.request({devtoolsLog:r,URL:e.URL},t),d=ServerResponseTime.calculateResponseTime(u),m=d<l,p=o(s.displayValue,{timeInMs:d}),h=[{key:"url",valueType:"url",label:o(i.UIStrings.columnURL)},{key:"responseTime",valueType:"timespanMs",label:o(i.UIStrings.columnTimeSpent)}],g=n.makeOpportunityDetails(h,[{url:u.url,responseTime:d}],d-c);return{numericValue:d,numericUnit:"millisecond",score:Number(m),displayValue:p,details:g}}}t.exports=ServerResponseTime,t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/server-response-time.js")},{"../computed/main-resource.js":13,"../lib/i18n/i18n.js":78,"./audit.js":3}],"../audits/service-worker":[function(e,t,r){(function(r){"use strict"
;const n=e("../lib/url-shim.js"),i=e("./audit.js"),a=e("../lib/i18n/i18n.js"),s={title:"Registers a service worker that controls page and `start_url`",failureTitle:"Does not register a service worker that controls page and `start_url`",description:"The service worker is the technology that enables your app to use many Progressive Web App features, such as offline, add to homescreen, and push notifications. [Learn more](https://web.dev/service-worker/).",explanationOutOfScope:"This origin has one or more service workers, however the page ({pageUrl}) is not in scope.",explanationNoManifest:"This page is controlled by a service worker, however no `start_url` was found because no manifest was fetched.",explanationBadManifest:"This page is controlled by a service worker, however no `start_url` was found because manifest failed to parse as valid JSON",
explanationBadStartUrl:"This page is controlled by a service worker, however the `start_url` ({startUrl}) is not in the service worker's scope ({scopeUrl})"},o=a.createMessageInstanceIdFn(r,s);class ServiceWorker extends i{static get meta(){return{id:"service-worker",title:o(s.title),failureTitle:o(s.failureTitle),description:o(s.description),requiredArtifacts:["URL","ServiceWorker","WebAppManifest"]}}static getVersionsForOrigin(e,t){return e.filter(e=>"activated"===e.status).filter(e=>new n(e.scriptURL).origin===t.origin)}static getControllingServiceWorker(e,t,r){const i=[];for(const r of e){const e=t.find(e=>e.registrationId===r.registrationId);if(e){const t=new n(e.scopeURL).href,a=new n(r.scriptURL).href;i.push({scopeUrl:t,scriptUrl:a})}}return i.filter(e=>r.href.startsWith(e.scopeUrl)).sort((e,t)=>e.scopeUrl.length-t.scopeUrl.length).pop()}static checkStartUrl(e,t){if(!e)return o(s.explanationNoManifest);if(!e.value)return o(s.explanationBadManifest)
;const r=e.value.start_url.value;return r.startsWith(t)?void 0:o(s.explanationBadStartUrl,{startUrl:r,scopeUrl:t})}static audit(e){const t=new n(e.URL.finalUrl),{versions:r,registrations:i}=e.ServiceWorker,a=ServiceWorker.getVersionsForOrigin(r,t);if(0===a.length)return{score:0};const l=ServiceWorker.getControllingServiceWorker(a,i,t);if(!l)return{score:0,explanation:o(s.explanationOutOfScope,{pageUrl:t.href})};const{scriptUrl:c,scopeUrl:u}=l,d={type:"debugdata",scriptUrl:c,scopeUrl:u},m=ServiceWorker.checkStartUrl(e.WebAppManifest,l.scopeUrl);return m?{score:0,details:d,explanation:m}:{score:1,details:d}}}t.exports=ServiceWorker,t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/service-worker.js")},{"../lib/i18n/i18n.js":78,"../lib/url-shim.js":"url","./audit.js":3}],"../audits/splash-screen":[function(e,t,r){(function(r){"use strict";const n=e("./multi-check-audit.js"),i=e("../computed/manifest-values.js"),a=e("../lib/i18n/i18n.js"),s={
title:"Configured for a custom splash screen",failureTitle:"Is not configured for a custom splash screen",description:"A themed splash screen ensures a high-quality experience when users launch your app from their homescreens. [Learn more](https://web.dev/splash-screen/)."},o=a.createMessageInstanceIdFn(r,s);class SplashScreen extends n{static get meta(){return{id:"splash-screen",title:o(s.title),failureTitle:o(s.failureTitle),description:o(s.description),requiredArtifacts:["WebAppManifest","InstallabilityErrors"]}}static assessManifest(e,t){if(e.isParseFailure&&e.parseFailureReason)return void t.push(e.parseFailureReason);const r=["hasName","hasBackgroundColor","hasThemeColor","hasIconsAtLeast512px"];e.allChecks.filter(e=>r.includes(e.id)).forEach(e=>{e.passing||t.push(e.failureText)})}static async audit_(e,t){const r=[],n=await i.request(e,t);return SplashScreen.assessManifest(n,r),{failures:r,manifestValues:n}}}t.exports=SplashScreen,t.exports.UIStrings=s
}).call(this,"/lighthouse-core/audits/splash-screen.js")},{"../computed/manifest-values.js":15,"../lib/i18n/i18n.js":78,"./multi-check-audit.js":7}],"../audits/themed-omnibox":[function(e,t,r){(function(r){"use strict";const n=e("./multi-check-audit.js"),i=e("../computed/manifest-values.js"),a=e("cssstyle/lib/parsers"),s=e("../lib/i18n/i18n.js"),o={title:"Sets a theme color for the address bar.",failureTitle:"Does not set a theme color for the address bar.",description:"The browser address bar can be themed to match your site. [Learn more](https://web.dev/themed-omnibox/)."},l=s.createMessageInstanceIdFn(r,o);class ThemedOmnibox extends n{static get meta(){return{id:"themed-omnibox",title:l(o.title),failureTitle:l(o.failureTitle),description:l(o.description),requiredArtifacts:["WebAppManifest","InstallabilityErrors","MetaElements"]}}static isValidColor(e){return a.valueType(e)===a.TYPES.COLOR}static assessMetaThemecolor(e,t){
e?ThemedOmnibox.isValidColor(e.content||"")||t.push("The theme-color meta tag did not contain a valid CSS color"):t.push('No `<meta name="theme-color">` tag found')}static assessManifest(e,t){if(e.isParseFailure&&e.parseFailureReason)return void t.push(e.parseFailureReason);const r=e.allChecks.find(e=>"hasThemeColor"===e.id);r&&!r.passing&&t.push(r.failureText)}static async audit_(e,t){const r=[],n=e.MetaElements.find(e=>"theme-color"===e.name),a=await i.request(e,t);return ThemedOmnibox.assessManifest(a,r),ThemedOmnibox.assessMetaThemecolor(n,r),{failures:r,manifestValues:a,themeColor:n&&n.content||null}}}t.exports=ThemedOmnibox,t.exports.UIStrings=o}).call(this,"/lighthouse-core/audits/themed-omnibox.js")},{"../computed/manifest-values.js":15,"../lib/i18n/i18n.js":78,"./multi-check-audit.js":7,"cssstyle/lib/parsers":123}],"../audits/third-party-summary":[function(e,t,r){(function(r){"use strict"
;const n=e("./audit.js"),i=e("./bootup-time.js"),a=e("../lib/i18n/i18n.js"),s=e("../lib/third-party-web.js"),o=e("../computed/network-records.js"),l=e("../computed/main-resource.js"),c=e("../computed/main-thread-tasks.js"),u={title:"Minimize third-party usage",failureTitle:"Reduce the impact of third-party code",description:"Third-party code can significantly impact load performance. Limit the number of redundant third-party providers and try to load third-party code after your page has primarily finished loading. [Learn more](https://developers.google.com/web/fundamentals/performance/optimizing-content-efficiency/loading-third-party-javascript/).",columnThirdParty:"Third-Party",columnBlockingTime:"Main-Thread Blocking Time",displayValue:"Third-party code blocked the main thread for {timeInMs, number, milliseconds} ms",otherValue:"Other resources"},d=a.createMessageInstanceIdFn(r,u),m=250,p=4096,h=5;class ThirdPartySummary extends n{static get meta(){return{id:"third-party-summary",
title:d(u.title),failureTitle:d(u.failureTitle),description:d(u.description),requiredArtifacts:["traces","devtoolsLogs","URL"]}}static getSummaries(e,t,r){const n=new Map,a=new Map,o={mainThreadTime:0,blockingTime:0,transferSize:0};for(const t of e){const e=n.get(t.url)||{...o};e.transferSize+=t.transferSize,n.set(t.url,e)}const l=i.getJavaScriptURLs(e);for(const e of t){const t=i.getAttributableURLForTask(e,l),a=n.get(t)||{...o},s=e.selfTime*r;a.mainThreadTime+=s,a.blockingTime+=Math.max(s-50,0),n.set(t,a)}const c=new Map;for(const[e,t]of n.entries()){const r=s.getEntity(e);if(!r){n.delete(e);continue}const i=a.get(r)||{...o};i.transferSize+=t.transferSize,i.mainThreadTime+=t.mainThreadTime,i.blockingTime+=t.blockingTime,a.set(r,i);const l=c.get(r)||[];l.push(e),c.set(r,l)}return{byURL:n,byEntity:a,urls:c}}static makeSubItems(e,t,r){let n=(t.urls.get(e)||[]).map(e=>({url:e,...t.byURL.get(e)
})).filter(e=>e.transferSize>0).sort((e,t)=>t.blockingTime-e.blockingTime||t.transferSize-e.transferSize);const i={transferSize:0,blockingTime:0},a=Math.max(p,r.transferSize/20),s=Math.min(h,n.length);let o=0;for(;o<s;){const e=n[o];if(0===e.blockingTime&&e.transferSize<a)break;o++,i.transferSize+=e.transferSize,i.blockingTime+=e.blockingTime}if(!i.blockingTime&&!i.transferSize)return[];n=n.slice(0,o);const l={url:d(u.otherValue),transferSize:r.transferSize-i.transferSize,blockingTime:r.blockingTime-i.blockingTime};return l.transferSize>a&&n.push(l),n}static async audit(e,t){const r=t.settings||{},i=e.traces[n.DEFAULT_PASS],p=e.devtoolsLogs[n.DEFAULT_PASS],h=await o.request(p,t),g=await l.request({devtoolsLog:p,URL:e.URL},t),f=s.getEntity(g.url),b=await c.request(i,t),y="simulate"===r.throttlingMethod?r.throttling.cpuSlowdownMultiplier:1,v=ThirdPartySummary.getSummaries(h,b,y),w={wastedBytes:0,wastedMs:0
},k=Array.from(v.byEntity.entries()).filter(([e])=>!(f&&f.name===e.name)).map(([e,t])=>(w.wastedBytes+=t.transferSize,w.wastedMs+=t.blockingTime,{...t,entity:{type:"link",text:e.name,url:e.homepage||""},subItems:{type:"subitems",items:ThirdPartySummary.makeSubItems(e,v,t)}})).sort((e,t)=>t.blockingTime-e.blockingTime||t.transferSize-e.transferSize),x=[{key:"entity",itemType:"link",text:d(u.columnThirdParty),subItemsHeading:{key:"url",itemType:"url"}},{key:"transferSize",granularity:1,itemType:"bytes",text:d(a.UIStrings.columnTransferSize),subItemsHeading:{key:"transferSize"}},{key:"blockingTime",granularity:1,itemType:"ms",text:d(u.columnBlockingTime),subItemsHeading:{key:"blockingTime"}}];return k.length?{score:Number(w.wastedMs<=m),displayValue:d(u.displayValue,{timeInMs:w.wastedMs}),details:n.makeTableDetails(x,k,w)}:{score:1,notApplicable:!0}}}t.exports=ThirdPartySummary,t.exports.UIStrings=u}).call(this,"/lighthouse-core/audits/third-party-summary.js")},{
"../computed/main-resource.js":13,"../computed/main-thread-tasks.js":14,"../computed/network-records.js":40,"../lib/i18n/i18n.js":78,"../lib/third-party-web.js":98,"./audit.js":3,"./bootup-time.js":"../audits/bootup-time"}],"../audits/timing-budget":[function(e,t,r){(function(r){"use strict";const n=e("./audit.js"),i=e("../computed/metrics/timing-summary.js"),a=e("../computed/main-resource.js"),s=e("../config/budget.js"),o=e("../lib/i18n/i18n.js"),l={title:"Timing budget",description:"Set a timing budget to help you keep an eye on the performance of your site. Performant sites load fast and respond to user input events quickly. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/budgets).",columnTimingMetric:"Metric",columnMeasurement:"Measurement"},c=o.createMessageInstanceIdFn(r,l);t.exports=class TimingBudget extends n{static get meta(){return{id:"timing-budget",title:c(l.title),description:c(l.description),scoreDisplayMode:n.SCORING_MODES.INFORMATIVE,
requiredArtifacts:["devtoolsLogs","traces","URL"]}}static getRowLabel(e){const t={"first-contentful-paint":o.UIStrings.firstContentfulPaintMetric,"first-cpu-idle":o.UIStrings.firstCPUIdleMetric,interactive:o.UIStrings.interactiveMetric,"first-meaningful-paint":o.UIStrings.firstMeaningfulPaintMetric,"max-potential-fid":o.UIStrings.maxPotentialFIDMetric,"estimated-input-latency":o.UIStrings.estimatedInputLatencyMetric,"total-blocking-time":o.UIStrings.totalBlockingTimeMetric,"speed-index":o.UIStrings.speedIndexMetric,"largest-contentful-paint":o.UIStrings.largestContentfulPaintMetric,"cumulative-layout-shift":o.UIStrings.cumulativeLayoutShiftMetric};return c(t[e])}static getMeasurement(e,t){return{"first-contentful-paint":t.firstContentfulPaint,"first-cpu-idle":t.firstCPUIdle,interactive:t.interactive,"first-meaningful-paint":t.firstMeaningfulPaint,"max-potential-fid":t.maxPotentialFID,"estimated-input-latency":t.estimatedInputLatency,"total-blocking-time":t.totalBlockingTime,
"speed-index":t.speedIndex,"largest-contentful-paint":t.largestContentfulPaint,"cumulative-layout-shift":t.cumulativeLayoutShift}[e]}static tableItems(e,t){let r=[];if(!e.timings)return r;const n=(r=e.timings.map(e=>{const r=e.metric,n=this.getRowLabel(r),i=this.getMeasurement(r,t);return{metric:r,label:n,measurement:i,overBudget:i&&i>e.budget?i-e.budget:void 0}}).sort((e,t)=>(t.overBudget||0)-(e.overBudget||0))).find(e=>"cumulative-layout-shift"===e.metric);return n&&("object"!=typeof n.measurement&&(n.measurement={type:"numeric",value:Number(n.measurement),granularity:.01}),"object"!=typeof n.overBudget&&(n.overBudget={type:"numeric",value:Number(n.overBudget),granularity:.01})),r}static async audit(e,t){const r=e.devtoolsLogs[n.DEFAULT_PASS],u=e.traces[n.DEFAULT_PASS],d=await a.request({URL:e.URL,devtoolsLog:r},t),m=(await i.request({trace:u,devtoolsLog:r},t)).metrics,p=s.getMatchingBudget(t.settings.budgets,d.url);if(!p)return{score:0,notApplicable:!0};const h=[{key:"label",
itemType:"text",text:c(l.columnTimingMetric)},{key:"measurement",itemType:"ms",text:c(l.columnMeasurement)},{key:"overBudget",itemType:"ms",text:c(o.UIStrings.columnOverBudget)}];return{details:n.makeTableDetails(h,this.tableItems(p,m)),score:1}}},t.exports.UIStrings=l}).call(this,"/lighthouse-core/audits/timing-budget.js")},{"../computed/main-resource.js":13,"../computed/metrics/timing-summary.js":36,"../config/budget.js":50,"../lib/i18n/i18n.js":78,"./audit.js":3}],"../audits/unsized-images":[function(e,t,r){(function(r){"use strict";const n=e("./audit.js"),i=e("./../lib/i18n/i18n.js"),a=e("./../lib/url-shim.js"),s={title:"Image elements have explicit `width` and `height`",failureTitle:"Image elements do not have explicit `width` and `height`",description:"Set an explicit width and height on image elements to reduce layout shifts and improve CLS. [Learn more](https://web.dev/optimize-cls/#images-without-dimensions)"},o=i.createMessageInstanceIdFn(r,s);class UnsizedImages extends n{
static get meta(){return{id:"unsized-images",title:o(s.title),failureTitle:o(s.failureTitle),description:o(s.description),requiredArtifacts:["ImageElements"]}}static isValidAttr(e){return/^\d+$/.test(e)&&!/^0+$/.test(e)}static isValidCss(e){return!!e&&"auto"!==e}static isSizedImage(e){const t=e.attributeWidth,r=e.attributeHeight,n=e.cssWidth,i=e.cssHeight,a=UnsizedImages.isValidAttr(t),s=UnsizedImages.isValidCss(n),o=UnsizedImages.isValidAttr(r),l=UnsizedImages.isValidCss(i);return(a||s)&&(o||l)}static async audit(e){const t=e.ImageElements.filter(e=>!e.isCss&&!e.isInShadowDOM),r=[];for(const e of t){if("fixed"===e.cssComputedPosition||"absolute"===e.cssComputedPosition||UnsizedImages.isSizedImage(e))continue;const t=a.elideDataURI(e.src);r.push({url:t,node:{type:"node",path:e.devtoolsNodePath,selector:e.selector,nodeLabel:e.nodeLabel,snippet:e.snippet}})}const s=[{key:"url",itemType:"thumbnail",text:""},{key:"url",itemType:"url",text:o(i.UIStrings.columnURL)},{key:"node",
itemType:"node",text:o(i.UIStrings.columnFailingElem)}];return{score:r.length>0?0:1,notApplicable:0===t.length,details:n.makeTableDetails(s,r)}}}t.exports=UnsizedImages,t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/unsized-images.js")},{"./../lib/i18n/i18n.js":78,"./../lib/url-shim.js":"url","./audit.js":3}],"../audits/user-timings":[function(e,t,r){(function(r){"use strict";const n=e("./audit.js"),i=e("../lib/i18n/i18n.js"),a=e("../computed/user-timings.js"),s={title:"User Timing marks and measures",description:"Consider instrumenting your app with the User Timing API to measure your app's real-world performance during key user experiences. [Learn more](https://web.dev/user-timings/).",displayValue:"{itemCount, plural,\n    =1 {1 user timing}\n    other {# user timings}\n    }",columnType:"Type"},o=i.createMessageInstanceIdFn(r,s);class UserTimings extends n{static get meta(){return{id:"user-timings",title:o(s.title),description:o(s.description),
scoreDisplayMode:n.SCORING_MODES.INFORMATIVE,requiredArtifacts:["traces"]}}static get excludedPrefixes(){return["goog_"]}static excludeEvent(e){return UserTimings.excludedPrefixes.every(t=>!e.name.startsWith(t))}static audit(e,t){const r=e.traces[n.DEFAULT_PASS];return a.request(r,t).then(e=>{const t=e.filter(UserTimings.excludeEvent),r=t.map(e=>({name:e.name,startTime:e.startTime,duration:e.isMark?void 0:e.duration,timingType:e.isMark?"Mark":"Measure"})).sort((e,t)=>e.timingType===t.timingType?e.startTime-t.startTime:"Measure"===e.timingType?-1:1),a=[{key:"name",itemType:"text",text:o(i.UIStrings.columnName)},{key:"timingType",itemType:"text",text:o(s.columnType)},{key:"startTime",itemType:"ms",granularity:.01,text:o(i.UIStrings.columnStartTime)},{key:"duration",itemType:"ms",granularity:.01,text:o(i.UIStrings.columnDuration)}],l=n.makeTableDetails(a,r);let c;return t.length&&(c=o(s.displayValue,{itemCount:t.length})),{score:Number(0===t.length),notApplicable:0===t.length,
displayValue:c,details:l}})}}t.exports=UserTimings,t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/user-timings.js")},{"../computed/user-timings.js":48,"../lib/i18n/i18n.js":78,"./audit.js":3}],"../audits/uses-rel-preconnect":[function(e,t,r){(function(r){"use strict";const n=e("./audit.js"),i=e("./byte-efficiency/byte-efficiency-audit.js"),a=e("../lib/url-shim.js"),s=e("../lib/i18n/i18n.js"),o=e("../computed/network-records.js"),l=e("../computed/main-resource.js"),c=e("../computed/load-simulator.js"),u=e("../computed/trace-of-tab.js"),d=e("../computed/page-dependency-graph.js"),m=e("../computed/metrics/lantern-largest-contentful-paint.js"),p=15,h=50,g={title:"Preconnect to required origins",description:"Consider adding `preconnect` or `dns-prefetch` resource hints to establish early connections to important third-party origins. [Learn more](https://web.dev/uses-rel-preconnect/).",
unusedWarning:'A `<link rel=preconnect>` was found for "{securityOrigin}" but was not used by the browser. Only use `preconnect` for important origins that the page will certainly request.',crossoriginWarning:'A `<link rel=preconnect>` was found for "{securityOrigin}" but was not used by the browser. Check that you are using the `crossorigin` attribute properly.',tooManyPreconnectLinksWarning:"More than 2 `<link rel=preconnect>` connections were found. These should be used sparingly and only to the most important origins."},f=s.createMessageInstanceIdFn(r,g);class UsesRelPreconnectAudit extends n{static get meta(){return{id:"uses-rel-preconnect",title:f(g.title),description:f(g.description),requiredArtifacts:["traces","devtoolsLogs","URL","LinkElements"],scoreDisplayMode:n.SCORING_MODES.NUMERIC}}static hasValidTiming(e){return!!e.timing&&e.timing.connectEnd>0&&e.timing.connectStart>0}static hasAlreadyConnectedToOrigin(e){
return!!e.timing&&e.timing.dnsEnd-e.timing.dnsStart==0&&e.timing.connectEnd-e.timing.connectStart==0}static socketStartTimeIsBelowThreshold(e,t){return Math.max(0,e.startTime-t.endTime)<p}static async audit(e,t){const r=e.traces[UsesRelPreconnectAudit.DEFAULT_PASS],p=e.devtoolsLogs[UsesRelPreconnectAudit.DEFAULT_PASS],b=t.settings;let y=0;const v=[],[w,k,x,T,S]=await Promise.all([o.request(p,t),l.request({devtoolsLog:p,URL:e.URL},t),c.request({devtoolsLog:p,settings:b},t),u.request(r,t),d.request({trace:r,devtoolsLog:p},t)]),{rtt:j,additionalRttByOrigin:E}=x.getOptions(),_=await m.getPessimisticGraph(S,T),D=new Set;_.traverse(e=>{"network"===e.type&&D.add(e.record.url)});const A=new Map;w.forEach(e=>{
if(!UsesRelPreconnectAudit.hasValidTiming(e)||e.initiator.url===k.url||!e.parsedURL||!e.parsedURL.securityOrigin||k.parsedURL.securityOrigin===e.parsedURL.securityOrigin||!D.has(e.url)||UsesRelPreconnectAudit.hasAlreadyConnectedToOrigin(e)||!UsesRelPreconnectAudit.socketStartTimeIsBelowThreshold(e,k))return;const t=e.parsedURL.securityOrigin,r=A.get(t)||[];r.push(e),A.set(t,r)});const R=e.LinkElements.filter(e=>"preconnect"===e.rel),C=new Set(R.map(e=>a.getOrigin(e.href||"")));let I=[];A.forEach(e=>{const t=e.reduce((e,t)=>t.startTime<e.startTime?t:e);if(!t.timing)return;const r=t.parsedURL.securityOrigin,n=E.get(r)||0;let i=j+n;"https"===t.parsedURL.scheme&&(i*=2);const a=1e3*t.startTime-1e3*k.endTime+t.timing.dnsStart,s=Math.min(i,a);s<h||(C.has(r)?v.push(f(g.crossoriginWarning,{securityOrigin:r})):(y=Math.max(s,y),I.push({url:r,wastedMs:s})))}),I=I.sort((e,t)=>t.wastedMs-e.wastedMs);for(const e of C)e&&(w.some(t=>e===t.parsedURL.securityOrigin)||v.push(f(g.unusedWarning,{
securityOrigin:e})));if(R.length>=2)return{score:1,warnings:R.length>=3?[...v,f(g.tooManyPreconnectLinksWarning)]:v};const N=[{key:"url",valueType:"url",label:f(s.UIStrings.columnURL)},{key:"wastedMs",valueType:"timespanMs",label:f(s.UIStrings.columnWastedMs)}],L=n.makeOpportunityDetails(N,I,y);return{score:i.scoreForWastedMs(y),numericValue:y,numericUnit:"millisecond",displayValue:y?f(s.UIStrings.displayValueMsSavings,{wastedMs:y}):"",warnings:v,details:L}}}t.exports=UsesRelPreconnectAudit,t.exports.UIStrings=g}).call(this,"/lighthouse-core/audits/uses-rel-preconnect.js")},{"../computed/load-simulator.js":12,"../computed/main-resource.js":13,"../computed/metrics/lantern-largest-contentful-paint.js":27,"../computed/network-records.js":40,"../computed/page-dependency-graph.js":41,"../computed/trace-of-tab.js":45,"../lib/i18n/i18n.js":78,"../lib/url-shim.js":"url","./audit.js":3,"./byte-efficiency/byte-efficiency-audit.js":4}],"../audits/uses-rel-preload":[function(e,t,r){(function(r){
"use strict";const n=e("../lib/url-shim.js"),i=e("./audit.js"),a=e("./byte-efficiency/byte-efficiency-audit.js"),s=e("../computed/critical-request-chains.js"),o=e("../lib/i18n/i18n.js"),l=e("../computed/main-resource.js"),c=e("../computed/page-dependency-graph.js"),u=e("../computed/load-simulator.js"),d={title:"Preload key requests",description:"Consider using `<link rel=preload>` to prioritize fetching resources that are currently requested later in page load. [Learn more](https://web.dev/uses-rel-preload/).",crossoriginWarning:'A preload `<link>` was found for "{preloadURL}" but was not used by the browser. Check that you are using the `crossorigin` attribute properly.'},m=o.createMessageInstanceIdFn(r,d),p=100;class UsesRelPreloadAudit extends i{static get meta(){return{id:"uses-rel-preload",title:m(d.title),description:m(d.description),requiredArtifacts:["devtoolsLogs","traces","URL"],scoreDisplayMode:i.SCORING_MODES.NUMERIC}}static getURLsToPreload(e,t){const r=new Set
;return t.traverse((t,n)=>{if("network"!==t.type)return;const i=n.slice(1).filter(e=>"network"===e.type);UsesRelPreloadAudit.shouldPreloadRequest(t.record,e,i)&&r.add(t.record.url)}),r}static getURLsFailedToPreload(e){const t=[];e.traverse(e=>"network"===e.type&&t.push(e.record));const r=t.filter(e=>e.isLinkPreload),n=new Map;for(const e of r){const t=n.get(e.frameId)||new Set;t.add(e.url),n.set(e.frameId,t)}const i=t.filter(e=>{const t=n.get(e.frameId);return!!t&&(!!t.has(e.url)&&!e.isLinkPreload)});return new Set(i.map(e=>e.url))}static shouldPreloadRequest(e,t,r){const i=t.redirects?t.redirects.length:0;return!e.isLinkPreload&&(!!s.isCritical(e,t)&&(!n.NON_NETWORK_PROTOCOLS.includes(e.protocol)&&(r.length===i+2&&(e.frameId===t.frameId&&n.rootDomainsMatch(e.url,t.url)))))}static computeWasteWithGraph(e,t,r){if(!e.size)return{wastedMs:0,results:[]};const n=r.simulate(t,{flexibleOrdering:!0}),i=t.cloneWithRelationships(),a=[];let s=null;if(i.traverse(t=>{if("network"!==t.type)return
;const r=t;t.isMainDocument()?s=r:r.record&&e.has(r.record.url)&&a.push(r)}),!s)throw new Error("Could not find main document node");for(const e of a)e.removeAllDependencies(),e.addDependency(s);const o=r.simulate(i,{flexibleOrdering:!0}),l=Array.from(n.nodeTimings.keys()).reduce((e,t)=>e.set(t.record,t),new Map),c=[];for(const e of a){const t=l.get(e.record),r=o.nodeTimings.get(e),i=n.nodeTimings.get(t);if(!i||!r)throw new Error("Missing preload node");const a=Math.round(i.endTime-r.endTime);a<p||c.push({url:e.record.url,wastedMs:a})}return c.length?{wastedMs:Math.max(...c.map(e=>e.wastedMs)),results:c}:{wastedMs:0,results:c}}static async audit(e,t){const r=e.traces[UsesRelPreloadAudit.DEFAULT_PASS],n=e.devtoolsLogs[UsesRelPreloadAudit.DEFAULT_PASS],s=e.URL,p={trace:r,devtoolsLog:n,settings:t.settings},[h,g,f]=await Promise.all([l.request({devtoolsLog:n,URL:s},t),c.request({trace:r,devtoolsLog:n
},t),u.request(p,t)]),b=UsesRelPreloadAudit.getURLsToPreload(h,g),{results:y,wastedMs:v}=UsesRelPreloadAudit.computeWasteWithGraph(b,g,f);let w;y.sort((e,t)=>t.wastedMs-e.wastedMs);const k=UsesRelPreloadAudit.getURLsFailedToPreload(g);k.size&&(w=Array.from(k).map(e=>m(d.crossoriginWarning,{preloadURL:e})));const x=[{key:"url",valueType:"url",label:m(o.UIStrings.columnURL)},{key:"wastedMs",valueType:"timespanMs",label:m(o.UIStrings.columnWastedMs)}],T=i.makeOpportunityDetails(x,y,v);return{score:a.scoreForWastedMs(v),numericValue:v,numericUnit:"millisecond",displayValue:v?m(o.UIStrings.displayValueMsSavings,{wastedMs:v}):"",details:T,warnings:w}}}t.exports=UsesRelPreloadAudit,t.exports.UIStrings=d}).call(this,"/lighthouse-core/audits/uses-rel-preload.js")},{"../computed/critical-request-chains.js":10,"../computed/load-simulator.js":12,"../computed/main-resource.js":13,"../computed/page-dependency-graph.js":41,"../lib/i18n/i18n.js":78,"../lib/url-shim.js":"url","./audit.js":3,
"./byte-efficiency/byte-efficiency-audit.js":4}],"../audits/valid-source-maps":[function(e,t,r){(function(r){"use strict";const n=e("../lib/third-party-web.js"),i=e("./audit.js"),a=e("../lib/i18n/i18n.js"),s={title:"Page has valid source maps",failureTitle:"Missing source maps for large first-party JavaScript",description:"Source maps translate minified code to the original source code. This helps developers debug in production. In addition, Lighthouse is able to provide further insights. Consider deploying source maps to take advantage of these benefits. [Learn more](https://developers.google.com/web/tools/chrome-devtools/javascript/source-maps).",columnMapURL:"Map URL",missingSourceMapErrorMessage:"Large JavaScript file is missing a source map",missingSourceMapItemsWarningMesssage:"{missingItems, plural,\n    =1 {Warning: missing 1 item in `.sourcesContent`}\n    other {Warning: missing # items in `.sourcesContent`}\n    }"},o=a.createMessageInstanceIdFn(r,s),l=512e3
;t.exports=class ValidSourceMaps extends i{static get meta(){return{id:"valid-source-maps",title:o(s.title),failureTitle:o(s.failureTitle),description:o(s.description),requiredArtifacts:["ScriptElements","SourceMaps","URL"]}}static isLargeFirstPartyJS(e,t){if(null===e.content)return!1;const r=e.content.length>=l,i=!!e.src&&n.isFirstParty(e.src,n.getEntity(t));return r&&i}static async audit(e){const{SourceMaps:t}=e,r=new Set;let n=!1;const l=[];for(const i of e.ScriptElements){if(!i.src)continue;const a=t.find(e=>e.scriptUrl===i.src),c=[];if(!this.isLargeFirstPartyJS(i,e.URL.finalUrl)||a&&a.map||(n=!0,r.add(i.src),c.push({error:o(s.missingSourceMapErrorMessage)})),a&&!a.map&&c.push({error:a.errorMessage}),a&&a.map){const e=a.map.sourcesContent||[];let t=0;for(let r=0;r<a.map.sources.length;r++)(e.length<r||!e[r])&&(t+=1);t>0&&c.push({error:o(s.missingSourceMapItemsWarningMesssage,{missingItems:t})})}(a||c.length)&&l.push({scriptUrl:i.src,sourceMapUrl:a&&a.sourceMapUrl,subItems:{
type:"subitems",items:c}})}const c=[{key:"scriptUrl",itemType:"url",subItemsHeading:{key:"error"},text:o(a.UIStrings.columnURL)},{key:"sourceMapUrl",itemType:"url",text:o(s.columnMapURL)}];return l.sort((e,t)=>{const n=r.has(e.scriptUrl),i=r.has(t.scriptUrl);return n&&!i?-1:!n&&i?1:e.subItems.items.length&&!t.subItems.items.length?-1:!e.subItems.items.length&&t.subItems.items.length?1:t.scriptUrl.localeCompare(e.scriptUrl)}),{score:n?0:1,details:i.makeTableDetails(c,l)}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/valid-source-maps.js")},{"../lib/i18n/i18n.js":78,"../lib/third-party-web.js":98,"./audit.js":3}],"../audits/viewport":[function(e,t,r){(function(r){"use strict";const n=e("./audit.js"),i=e("../computed/viewport-meta.js"),a=e("../lib/i18n/i18n.js"),s={title:'Has a `<meta name="viewport">` tag with `width` or `initial-scale`',failureTitle:'Does not have a `<meta name="viewport">` tag with `width` or `initial-scale`',
description:'Add a `<meta name="viewport">` tag to optimize your app for mobile screens. [Learn more](https://web.dev/viewport/).',explanationNoTag:'No `<meta name="viewport">` tag found'},o=a.createMessageInstanceIdFn(r,s);t.exports=class Viewport extends n{static get meta(){return{id:"viewport",title:o(s.title),failureTitle:o(s.failureTitle),description:o(s.description),requiredArtifacts:["MetaElements"]}}static async audit(e,t){const r=await i.request(e.MetaElements,t);return r.hasViewportTag?{score:Number(r.isMobileOptimized),warnings:r.parserWarnings}:{score:0,explanation:o(s.explanationNoTag)}}},t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/viewport.js")},{"../computed/viewport-meta.js":49,"../lib/i18n/i18n.js":78,"./audit.js":3}],"../audits/without-javascript":[function(e,t,r){(function(r){"use strict";const n=e("./audit.js"),i=e("../lib/i18n/i18n.js"),a={title:"Contains some content when JavaScript is not available",
failureTitle:"Does not provide fallback content when JavaScript is not available",description:"Your app should display some content when JavaScript is disabled, even if it's just a warning to the user that JavaScript is required to use the app. [Learn more](https://web.dev/without-javascript/).",explanation:"The page body should render some content if its scripts are not available."},s=i.createMessageInstanceIdFn(r,a);t.exports=class WithoutJavaScript extends n{static get meta(){return{id:"without-javascript",title:s(a.title),failureTitle:s(a.failureTitle),description:s(a.description),requiredArtifacts:["HTMLWithoutJavaScript"]}}static audit(e){const t=e.HTMLWithoutJavaScript;return""!==t.bodyText.trim()||t.hasNoScript?{score:1}:{score:0,explanation:s(a.explanation)}}},t.exports.UIStrings=a}).call(this,"/lighthouse-core/audits/without-javascript.js")},{"../lib/i18n/i18n.js":78,"./audit.js":3}],"../audits/works-offline":[function(e,t,r){(function(r){"use strict"
;const n=e("../lib/url-shim.js"),i=e("./audit.js"),a=e("../lib/i18n/i18n.js"),s={title:"Current page responds with a 200 when offline",failureTitle:"Current page does not respond with a 200 when offline",description:"If you're building a Progressive Web App, consider using a service worker so that your app can work offline. [Learn more](https://web.dev/works-offline/).",warningNoLoad:'The page may not be loading offline because your test URL ({requested}) was redirected to "{final}". Try testing the second URL directly.'},o=a.createMessageInstanceIdFn(r,s);t.exports=class WorksOffline extends i{static get meta(){return{id:"works-offline",title:o(s.title),failureTitle:o(s.failureTitle),description:o(s.description),requiredArtifacts:["Offline","URL"]}}static audit(e){const t=[],r=200===e.Offline;return r||n.equalWithExcludedFragments(e.URL.requestedUrl,e.URL.finalUrl)||t.push(o(s.warningNoLoad,{requested:e.URL.requestedUrl,final:e.URL.finalUrl})),{score:Number(r),warnings:t}}},
t.exports.UIStrings=s}).call(this,"/lighthouse-core/audits/works-offline.js")},{"../lib/i18n/i18n.js":78,"../lib/url-shim.js":"url","./audit.js":3}],"../gather/gatherers/accessibility":[function(e,t,r){"use strict"
;const n=e("./gatherer.js"),i='!function e(t){var r=t,n=t.document;function a(e){return(a="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function o(e){this.name="SupportError",this.cause=e.cause,this.message="`".concat(e.cause,"` - feature unsupported in your environment."),e.ruleId&&(this.ruleId=e.ruleId,this.message+=" Skipping ".concat(this.ruleId," rule.")),this.stack=(new Error).stack}(re=re||{}).version="3.5.5","function"==typeof define&&define.amd&&define("axe-core",[],function(){"use strict";return re}),"object"===("undefined"==typeof module?"undefined":a(module))&&module.exports&&"function"==typeof e.toString&&(re.source="("+e.toString()+\')(typeof window === "object" ? window : this);\',module.exports=re),"function"==typeof t.getComputedStyle&&(t.axe=re),(o.prototype=Object.create(Error.prototype)).constructor=o,function e(t,r,n){function a(i,s){if(!r[i]){if(!t[i]){var l="function"==typeof require&&require;if(!s&&l)return l(i,!0);if(o)return o(i,!0);var u=new Error("Cannot find module \'"+i+"\'");throw u.code="MODULE_NOT_FOUND",u}var c=r[i]={exports:{}};t[i][0].call(c.exports,function(e){return a(t[i][1][e]||e)},c,c.exports,e,t,r,n)}return r[i].exports}for(var o="function"==typeof require&&require,i=0;i<n.length;i++)a(n[i]);return a}({1:[function(e,r,n){"Promise"in t||e("es6-promise").polyfill(),"Uint32Array"in t||e("core-js/features/typed-array/uint32-array"),t.Uint32Array&&("some"in t.Uint32Array.prototype||e("core-js/features/typed-array/some"),"reduce"in t.Uint32Array.prototype||e("core-js/features/typed-array/reduce")),e("weakmap-polyfill"),re.imports={axios:e("axios"),CssSelectorParser:e("css-selector-parser").CssSelectorParser,doT:e("@deque/dot"),emojiRegexText:e("emoji-regex"),memoize:e("memoizee")}},{"@deque/dot":2,axios:3,"core-js/features/typed-array/reduce":31,"core-js/features/typed-array/some":32,"core-js/features/typed-array/uint32-array":33,"css-selector-parser":155,"emoji-regex":158,"es6-promise":202,memoizee:223,"weakmap-polyfill":245}],2:[function(e,n,a){(function(e){!function(){"use strict";var r={name:"doT",version:"1.1.1",templateSettings:{evaluate:/\\{\\{([\\s\\S]+?(\\}?)+)\\}\\}/g,interpolate:/\\{\\{=([\\s\\S]+?)\\}\\}/g,encode:/\\{\\{!([\\s\\S]+?)\\}\\}/g,use:/\\{\\{#([\\s\\S]+?)\\}\\}/g,useParams:/(^|[^\\w$])def(?:\\.|\\[[\\\'\\"])([\\w$\\.]+)(?:[\\\'\\"]\\])?\\s*\\:\\s*([\\w$\\.]+|\\"[^\\"]+\\"|\\\'[^\\\']+\\\'|\\{[^\\}]+\\})/g,define:/\\{\\{##\\s*([\\w\\.$]+)\\s*(\\:|=)([\\s\\S]+?)#\\}\\}/g,defineParams:/^\\s*([\\w$]+):([\\s\\S]+)/,conditional:/\\{\\{\\?(\\?)?\\s*([\\s\\S]*?)\\s*\\}\\}/g,iterate:/\\{\\{~\\s*(?:\\}\\}|([\\s\\S]+?)\\s*\\:\\s*([\\w$]+)\\s*(?:\\:\\s*([\\w$]+))?\\s*\\}\\})/g,varname:"it",strip:!0,append:!0,selfcontained:!1,doNotSkipEncoded:!1},template:void 0,compile:void 0,log:!0};!function(){if("object"!=typeof globalThis)try{Object.defineProperty(Object.prototype,"__magic__",{get:function(){return this},configurable:!0}),__magic__.globalThis=__magic__,delete Object.prototype.__magic__}catch(r){t.globalThis=function(){if("undefined"!=typeof self)return self;if(void 0!==t)return t;if(void 0!==e)return e;if(void 0!==this)return this;throw new Error("Unable to locate global `this`")}()}}(),r.encodeHTMLSource=function(e){var t={"&":"&#38;","<":"&#60;",">":"&#62;",\'"\':"&#34;","\'":"&#39;","/":"&#47;"},r=e?/[&<>"\'\\/]/g:/&(?!#?\\w+;)|<|>|"|\'|\\//g;return function(e){return e?e.toString().replace(r,function(e){return t[e]||e}):""}},void 0!==n&&n.exports?n.exports=r:"function"==typeof define&&define.amd?define(function(){return r}):globalThis.doT=r;var a={append:{start:"\'+(",end:")+\'",startencode:"\'+encodeHTML("},split:{start:"\';out+=(",end:");out+=\'",startencode:"\';out+=encodeHTML("}},o=/$^/;function i(e){return e.replace(/\\\\(\'|\\\\)/g,"$1").replace(/[\\r\\t\\n]/g," ")}r.template=function(e,t,n){var s,l,u=(t=t||r.templateSettings).append?a.append:a.split,c=0,d=t.use||t.define?function e(t,r,n){return("string"==typeof r?r:r.toString()).replace(t.define||o,function(e,r,a,o){return 0===r.indexOf("def.")&&(r=r.substring(4)),r in n||(":"===a?(t.defineParams&&o.replace(t.defineParams,function(e,t,a){n[r]={arg:t,text:a}}),r in n||(n[r]=o)):new Function("def","def[\'"+r+"\']="+o)(n)),""}).replace(t.use||o,function(r,a){t.useParams&&(a=a.replace(t.useParams,function(e,t,r,a){if(n[r]&&n[r].arg&&a){var o=(r+":"+a).replace(/\'|\\\\/g,"_");return n.__exp=n.__exp||{},n.__exp[o]=n[r].text.replace(new RegExp("(^|[^\\\\w$])"+n[r].arg+"([^\\\\w$])","g"),"$1"+a+"$2"),t+"def.__exp[\'"+o+"\']"}}));var o=new Function("def","return "+a)(n);return o?e(t,o,n):o})}(t,e,n||{}):e;d=("var out=\'"+(t.strip?d.replace(/(^|\\r|\\n)\\t* +| +\\t*(\\r|\\n|$)/g," ").replace(/\\r|\\n|\\t|\\/\\*[\\s\\S]*?\\*\\//g,""):d).replace(/\'|\\\\/g,"\\\\$&").replace(t.interpolate||o,function(e,t){return u.start+i(t)+u.end}).replace(t.encode||o,function(e,t){return s=!0,u.startencode+i(t)+u.end}).replace(t.conditional||o,function(e,t,r){return t?r?"\';}else if("+i(r)+"){out+=\'":"\';}else{out+=\'":r?"\';if("+i(r)+"){out+=\'":"\';}out+=\'"}).replace(t.iterate||o,function(e,t,r,n){return t?(c+=1,l=n||"i"+c,t=i(t),"\';var arr"+c+"="+t+";if(arr"+c+"){var "+r+","+l+"=-1,l"+c+"=arr"+c+".length-1;while("+l+"<l"+c+"){"+r+"=arr"+c+"["+l+"+=1];out+=\'"):"\';} } out+=\'"}).replace(t.evaluate||o,function(e,t){return"\';"+i(t)+"out+=\'"})+"\';return out;").replace(/\\n/g,"\\\\n").replace(/\\t/g,"\\\\t").replace(/\\r/g,"\\\\r").replace(/(\\s|;|\\}|^|\\{)out\\+=\'\';/g,"$1").replace(/\\+\'\'/g,""),s&&(t.selfcontained||!globalThis||globalThis._encodeHTML||(globalThis._encodeHTML=r.encodeHTMLSource(t.doNotSkipEncoded)),d="var encodeHTML = typeof _encodeHTML !== \'undefined\' ? _encodeHTML : ("+r.encodeHTMLSource.toString()+"("+(t.doNotSkipEncoded||"")+"));"+d);try{return new Function(t.varname,d)}catch(e){throw"undefined"!=typeof console&&console.log("Could not create a template function: "+d),e}},r.compile=function(e,t){return r.template(e,null,t)}}()}).call(this,void 0!==r?r:"undefined"!=typeof self?self:void 0!==t?t:{})},{}],3:[function(e,t,r){t.exports=e("./lib/axios")},{"./lib/axios":5}],4:[function(e,t,r){"use strict";var n=e("./../utils"),a=e("./../core/settle"),o=e("./../helpers/buildURL"),i=e("../core/buildFullPath"),s=e("./../helpers/parseHeaders"),l=e("./../helpers/isURLSameOrigin"),u=e("../core/createError");t.exports=function(t){return new Promise(function(r,c){var d=t.data,p=t.headers;n.isFormData(d)&&delete p["Content-Type"];var m=new XMLHttpRequest;if(t.auth){var f=t.auth.username||"",h=t.auth.password||"";p.Authorization="Basic "+btoa(f+":"+h)}var b=i(t.baseURL,t.url);if(m.open(t.method.toUpperCase(),o(b,t.params,t.paramsSerializer),!0),m.timeout=t.timeout,m.onreadystatechange=function(){if(m&&4===m.readyState&&(0!==m.status||m.responseURL&&0===m.responseURL.indexOf("file:"))){var e="getAllResponseHeaders"in m?s(m.getAllResponseHeaders()):null,n={data:t.responseType&&"text"!==t.responseType?m.response:m.responseText,status:m.status,statusText:m.statusText,headers:e,config:t,request:m};a(r,c,n),m=null}},m.onabort=function(){m&&(c(u("Request aborted",t,"ECONNABORTED",m)),m=null)},m.onerror=function(){c(u("Network Error",t,null,m)),m=null},m.ontimeout=function(){var e="timeout of "+t.timeout+"ms exceeded";t.timeoutErrorMessage&&(e=t.timeoutErrorMessage),c(u(e,t,"ECONNABORTED",m)),m=null},n.isStandardBrowserEnv()){var g=e("./../helpers/cookies"),y=(t.withCredentials||l(b))&&t.xsrfCookieName?g.read(t.xsrfCookieName):void 0;y&&(p[t.xsrfHeaderName]=y)}if("setRequestHeader"in m&&n.forEach(p,function(e,t){void 0===d&&"content-type"===t.toLowerCase()?delete p[t]:m.setRequestHeader(t,e)}),n.isUndefined(t.withCredentials)||(m.withCredentials=!!t.withCredentials),t.responseType)try{m.responseType=t.responseType}catch(f){if("json"!==t.responseType)throw f}"function"==typeof t.onDownloadProgress&&m.addEventListener("progress",t.onDownloadProgress),"function"==typeof t.onUploadProgress&&m.upload&&m.upload.addEventListener("progress",t.onUploadProgress),t.cancelToken&&t.cancelToken.promise.then(function(e){m&&(m.abort(),c(e),m=null)}),void 0===d&&(d=null),m.send(d)})}},{"../core/buildFullPath":11,"../core/createError":12,"./../core/settle":16,"./../helpers/buildURL":20,"./../helpers/cookies":22,"./../helpers/isURLSameOrigin":24,"./../helpers/parseHeaders":26,"./../utils":28}],5:[function(e,t,r){"use strict";var n=e("./utils"),a=e("./helpers/bind"),o=e("./core/Axios"),i=e("./core/mergeConfig");function s(e){var t=new o(e),r=a(o.prototype.request,t);return n.extend(r,o.prototype,t),n.extend(r,t),r}var l=s(e("./defaults"));l.Axios=o,l.create=function(e){return s(i(l.defaults,e))},l.Cancel=e("./cancel/Cancel"),l.CancelToken=e("./cancel/CancelToken"),l.isCancel=e("./cancel/isCancel"),l.all=function(e){return Promise.all(e)},l.spread=e("./helpers/spread"),t.exports=l,t.exports.default=l},{"./cancel/Cancel":6,"./cancel/CancelToken":7,"./cancel/isCancel":8,"./core/Axios":9,"./core/mergeConfig":15,"./defaults":18,"./helpers/bind":19,"./helpers/spread":27,"./utils":28}],6:[function(e,t,r){"use strict";function n(e){this.message=e}n.prototype.toString=function(){return"Cancel"+(this.message?": "+this.message:"")},n.prototype.__CANCEL__=!0,t.exports=n},{}],7:[function(e,t,r){"use strict";var n=e("./Cancel");function a(e){if("function"!=typeof e)throw new TypeError("executor must be a function.");var t;this.promise=new Promise(function(e){t=e});var r=this;e(function(e){r.reason||(r.reason=new n(e),t(r.reason))})}a.prototype.throwIfRequested=function(){if(this.reason)throw this.reason},a.source=function(){var e;return{token:new a(function(t){e=t}),cancel:e}},t.exports=a},{"./Cancel":6}],8:[function(e,t,r){"use strict";t.exports=function(e){return!(!e||!e.__CANCEL__)}},{}],9:[function(e,t,r){"use strict";var n=e("./../utils"),a=e("../helpers/buildURL"),o=e("./InterceptorManager"),i=e("./dispatchRequest"),s=e("./mergeConfig");function l(e){this.defaults=e,this.interceptors={request:new o,response:new o}}l.prototype.request=function(e,t){"string"==typeof e?(e=t||{}).url=arguments[0]:e=e||{},(e=s(this.defaults,e)).method?e.method=e.method.toLowerCase():this.defaults.method?e.method=this.defaults.method.toLowerCase():e.method="get";var r=[i,void 0],n=Promise.resolve(e);for(this.interceptors.request.forEach(function(e){r.unshift(e.fulfilled,e.rejected)}),this.interceptors.response.forEach(function(e){r.push(e.fulfilled,e.rejected)});r.length;)n=n.then(r.shift(),r.shift());return n},l.prototype.getUri=function(e){return e=s(this.defaults,e),a(e.url,e.params,e.paramsSerializer).replace(/^\\?/,"")},n.forEach(["delete","get","head","options"],function(e){l.prototype[e]=function(t,r){return this.request(n.merge(r||{},{method:e,url:t}))}}),n.forEach(["post","put","patch"],function(e){l.prototype[e]=function(t,r,a){return this.request(n.merge(a||{},{method:e,url:t,data:r}))}}),t.exports=l},{"../helpers/buildURL":20,"./../utils":28,"./InterceptorManager":10,"./dispatchRequest":13,"./mergeConfig":15}],10:[function(e,t,r){"use strict";var n=e("./../utils");function a(){this.handlers=[]}a.prototype.use=function(e,t){return this.handlers.push({fulfilled:e,rejected:t}),this.handlers.length-1},a.prototype.eject=function(e){this.handlers[e]&&(this.handlers[e]=null)},a.prototype.forEach=function(e){n.forEach(this.handlers,function(t){null!==t&&e(t)})},t.exports=a},{"./../utils":28}],11:[function(e,t,r){"use strict";var n=e("../helpers/isAbsoluteURL"),a=e("../helpers/combineURLs");t.exports=function(e,t){return e&&!n(t)?a(e,t):t}},{"../helpers/combineURLs":21,"../helpers/isAbsoluteURL":23}],12:[function(e,t,r){"use strict";var n=e("./enhanceError");t.exports=function(e,t,r,a,o){var i=new Error(e);return n(i,t,r,a,o)}},{"./enhanceError":14}],13:[function(e,t,r){"use strict";var n=e("./../utils"),a=e("./transformData"),o=e("../cancel/isCancel"),i=e("../defaults");function s(e){e.cancelToken&&e.cancelToken.throwIfRequested()}t.exports=function(e){return s(e),e.headers=e.headers||{},e.data=a(e.data,e.headers,e.transformRequest),e.headers=n.merge(e.headers.common||{},e.headers[e.method]||{},e.headers),n.forEach(["delete","get","head","post","put","patch","common"],function(t){delete e.headers[t]}),(e.adapter||i.adapter)(e).then(function(t){return s(e),t.data=a(t.data,t.headers,e.transformResponse),t},function(t){return o(t)||(s(e),t&&t.response&&(t.response.data=a(t.response.data,t.response.headers,e.transformResponse))),Promise.reject(t)})}},{"../cancel/isCancel":8,"../defaults":18,"./../utils":28,"./transformData":17}],14:[function(e,t,r){"use strict";t.exports=function(e,t,r,n,a){return e.config=t,r&&(e.code=r),e.request=n,e.response=a,e.isAxiosError=!0,e.toJSON=function(){return{message:this.message,name:this.name,description:this.description,number:this.number,fileName:this.fileName,lineNumber:this.lineNumber,columnNumber:this.columnNumber,stack:this.stack,config:this.config,code:this.code}},e}},{}],15:[function(e,t,r){"use strict";var n=e("../utils");t.exports=function(e,t){t=t||{};var r={},a=["url","method","params","data"],o=["headers","auth","proxy"],i=["baseURL","url","transformRequest","transformResponse","paramsSerializer","timeout","withCredentials","adapter","responseType","xsrfCookieName","xsrfHeaderName","onUploadProgress","onDownloadProgress","maxContentLength","validateStatus","maxRedirects","httpAgent","httpsAgent","cancelToken","socketPath"];n.forEach(a,function(e){void 0!==t[e]&&(r[e]=t[e])}),n.forEach(o,function(a){n.isObject(t[a])?r[a]=n.deepMerge(e[a],t[a]):void 0!==t[a]?r[a]=t[a]:n.isObject(e[a])?r[a]=n.deepMerge(e[a]):void 0!==e[a]&&(r[a]=e[a])}),n.forEach(i,function(n){void 0!==t[n]?r[n]=t[n]:void 0!==e[n]&&(r[n]=e[n])});var s=a.concat(o).concat(i),l=Object.keys(t).filter(function(e){return-1===s.indexOf(e)});return n.forEach(l,function(n){void 0!==t[n]?r[n]=t[n]:void 0!==e[n]&&(r[n]=e[n])}),r}},{"../utils":28}],16:[function(e,t,r){"use strict";var n=e("./createError");t.exports=function(e,t,r){var a=r.config.validateStatus;!a||a(r.status)?e(r):t(n("Request failed with status code "+r.status,r.config,null,r.request,r))}},{"./createError":12}],17:[function(e,t,r){"use strict";var n=e("./../utils");t.exports=function(e,t,r){return n.forEach(r,function(r){e=r(e,t)}),e}},{"./../utils":28}],18:[function(e,t,r){(function(r){"use strict";var n=e("./utils"),a=e("./helpers/normalizeHeaderName"),o={"Content-Type":"application/x-www-form-urlencoded"};function i(e,t){!n.isUndefined(e)&&n.isUndefined(e["Content-Type"])&&(e["Content-Type"]=t)}var s,l={adapter:("undefined"!=typeof XMLHttpRequest?s=e("./adapters/xhr"):void 0!==r&&"[object process]"===Object.prototype.toString.call(r)&&(s=e("./adapters/http")),s),transformRequest:[function(e,t){return a(t,"Accept"),a(t,"Content-Type"),n.isFormData(e)||n.isArrayBuffer(e)||n.isBuffer(e)||n.isStream(e)||n.isFile(e)||n.isBlob(e)?e:n.isArrayBufferView(e)?e.buffer:n.isURLSearchParams(e)?(i(t,"application/x-www-form-urlencoded;charset=utf-8"),e.toString()):n.isObject(e)?(i(t,"application/json;charset=utf-8"),JSON.stringify(e)):e}],transformResponse:[function(e){if("string"==typeof e)try{e=JSON.parse(e)}catch(e){}return e}],timeout:0,xsrfCookieName:"XSRF-TOKEN",xsrfHeaderName:"X-XSRF-TOKEN",maxContentLength:-1,validateStatus:function(e){return 200<=e&&e<300},headers:{common:{Accept:"application/json, text/plain, */*"}}};n.forEach(["delete","get","head"],function(e){l.headers[e]={}}),n.forEach(["post","put","patch"],function(e){l.headers[e]=n.merge(o)}),t.exports=l}).call(this,e("_process"))},{"./adapters/http":4,"./adapters/xhr":4,"./helpers/normalizeHeaderName":25,"./utils":28,_process:236}],19:[function(e,t,r){"use strict";t.exports=function(e,t){return function(){for(var r=new Array(arguments.length),n=0;n<r.length;n++)r[n]=arguments[n];return e.apply(t,r)}}},{}],20:[function(e,t,r){"use strict";var n=e("./../utils");function a(e){return encodeURIComponent(e).replace(/%40/gi,"@").replace(/%3A/gi,":").replace(/%24/g,"$").replace(/%2C/gi,",").replace(/%20/g,"+").replace(/%5B/gi,"[").replace(/%5D/gi,"]")}t.exports=function(e,t,r){if(!t)return e;var o;if(r)o=r(t);else if(n.isURLSearchParams(t))o=t.toString();else{var i=[];n.forEach(t,function(e,t){null!=e&&(n.isArray(e)?t+="[]":e=[e],n.forEach(e,function(e){n.isDate(e)?e=e.toISOString():n.isObject(e)&&(e=JSON.stringify(e)),i.push(a(t)+"="+a(e))}))}),o=i.join("&")}if(o){var s=e.indexOf("#");-1!==s&&(e=e.slice(0,s)),e+=(-1===e.indexOf("?")?"?":"&")+o}return e}},{"./../utils":28}],21:[function(e,t,r){"use strict";t.exports=function(e,t){return t?e.replace(/\\/+$/,"")+"/"+t.replace(/^\\/+/,""):e}},{}],22:[function(e,t,r){"use strict";var a=e("./../utils");t.exports=a.isStandardBrowserEnv()?{write:function(e,t,r,o,i,s){var l=[];l.push(e+"="+encodeURIComponent(t)),a.isNumber(r)&&l.push("expires="+new Date(r).toGMTString()),a.isString(o)&&l.push("path="+o),a.isString(i)&&l.push("domain="+i),!0===s&&l.push("secure"),n.cookie=l.join("; ")},read:function(e){var t=n.cookie.match(new RegExp("(^|;\\\\s*)("+e+")=([^;]*)"));return t?decodeURIComponent(t[3]):null},remove:function(e){this.write(e,"",Date.now()-864e5)}}:{write:function(){},read:function(){return null},remove:function(){}}},{"./../utils":28}],23:[function(e,t,r){"use strict";t.exports=function(e){return/^([a-z][a-z\\d\\+\\-\\.]*:)?\\/\\//i.test(e)}},{}],24:[function(e,r,a){"use strict";var o,i,s,l=e("./../utils");function u(e){var t=e;return i&&(s.setAttribute("href",t),t=s.href),s.setAttribute("href",t),{href:s.href,protocol:s.protocol?s.protocol.replace(/:$/,""):"",host:s.host,search:s.search?s.search.replace(/^\\?/,""):"",hash:s.hash?s.hash.replace(/^#/,""):"",hostname:s.hostname,port:s.port,pathname:"/"===s.pathname.charAt(0)?s.pathname:"/"+s.pathname}}r.exports=l.isStandardBrowserEnv()?(i=/(msie|trident)/i.test(navigator.userAgent),s=n.createElement("a"),o=u(t.location.href),function(e){var t=l.isString(e)?u(e):e;return t.protocol===o.protocol&&t.host===o.host}):function(){return!0}},{"./../utils":28}],25:[function(e,t,r){"use strict";var n=e("../utils");t.exports=function(e,t){n.forEach(e,function(r,n){n!==t&&n.toUpperCase()===t.toUpperCase()&&(e[t]=r,delete e[n])})}},{"../utils":28}],26:[function(e,t,r){"use strict";var n=e("./../utils"),a=["age","authorization","content-length","content-type","etag","expires","from","host","if-modified-since","if-unmodified-since","last-modified","location","max-forwards","proxy-authorization","referer","retry-after","user-agent"];t.exports=function(e){var t,r,o,i={};return e&&n.forEach(e.split("\\n"),function(e){if(o=e.indexOf(":"),t=n.trim(e.substr(0,o)).toLowerCase(),r=n.trim(e.substr(o+1)),t){if(i[t]&&0<=a.indexOf(t))return;i[t]="set-cookie"===t?(i[t]?i[t]:[]).concat([r]):i[t]?i[t]+", "+r:r}}),i}},{"./../utils":28}],27:[function(e,t,r){"use strict";t.exports=function(e){return function(t){return e.apply(null,t)}}},{}],28:[function(e,r,a){"use strict";var o=e("./helpers/bind"),i=Object.prototype.toString;function s(e){return"[object Array]"===i.call(e)}function l(e){return void 0===e}function u(e){return null!==e&&"object"==typeof e}function c(e){return"[object Function]"===i.call(e)}function d(e,t){if(null!=e)if("object"!=typeof e&&(e=[e]),s(e))for(var r=0,n=e.length;r<n;r++)t.call(null,e[r],r,e);else for(var a in e)Object.prototype.hasOwnProperty.call(e,a)&&t.call(null,e[a],a,e)}r.exports={isArray:s,isArrayBuffer:function(e){return"[object ArrayBuffer]"===i.call(e)},isBuffer:function(e){return null!==e&&!l(e)&&null!==e.constructor&&!l(e.constructor)&&"function"==typeof e.constructor.isBuffer&&e.constructor.isBuffer(e)},isFormData:function(e){return"undefined"!=typeof FormData&&e instanceof FormData},isArrayBufferView:function(e){return"undefined"!=typeof ArrayBuffer&&ArrayBuffer.isView?ArrayBuffer.isView(e):e&&e.buffer&&e.buffer instanceof ArrayBuffer},isString:function(e){return"string"==typeof e},isNumber:function(e){return"number"==typeof e},isObject:u,isUndefined:l,isDate:function(e){return"[object Date]"===i.call(e)},isFile:function(e){return"[object File]"===i.call(e)},isBlob:function(e){return"[object Blob]"===i.call(e)},isFunction:c,isStream:function(e){return u(e)&&c(e.pipe)},isURLSearchParams:function(e){return"undefined"!=typeof URLSearchParams&&e instanceof URLSearchParams},isStandardBrowserEnv:function(){return("undefined"==typeof navigator||"ReactNative"!==navigator.product&&"NativeScript"!==navigator.product&&"NS"!==navigator.product)&&void 0!==t&&void 0!==n},forEach:d,merge:function e(){var t={};function r(r,n){"object"==typeof t[n]&&"object"==typeof r?t[n]=e(t[n],r):t[n]=r}for(var n=0,a=arguments.length;n<a;n++)d(arguments[n],r);return t},deepMerge:function e(){var t={};function r(r,n){"object"==typeof t[n]&&"object"==typeof r?t[n]=e(t[n],r):t[n]="object"==typeof r?e({},r):r}for(var n=0,a=arguments.length;n<a;n++)d(arguments[n],r);return t},extend:function(e,t,r){return d(t,function(t,n){e[n]=r&&"function"==typeof t?o(t,r):t}),e},trim:function(e){return e.replace(/^\\s*/,"").replace(/\\s*$/,"")}}},{"./helpers/bind":19}],29:[function(e,t,r){e("../../modules/es.typed-array.from"),e("../../modules/es.typed-array.of"),e("../../modules/es.typed-array.copy-within"),e("../../modules/es.typed-array.every"),e("../../modules/es.typed-array.fill"),e("../../modules/es.typed-array.filter"),e("../../modules/es.typed-array.find"),e("../../modules/es.typed-array.find-index"),e("../../modules/es.typed-array.for-each"),e("../../modules/es.typed-array.includes"),e("../../modules/es.typed-array.index-of"),e("../../modules/es.typed-array.join"),e("../../modules/es.typed-array.last-index-of"),e("../../modules/es.typed-array.map"),e("../../modules/es.typed-array.reduce"),e("../../modules/es.typed-array.reduce-right"),e("../../modules/es.typed-array.reverse"),e("../../modules/es.typed-array.set"),e("../../modules/es.typed-array.slice"),e("../../modules/es.typed-array.some"),e("../../modules/es.typed-array.sort"),e("../../modules/es.typed-array.subarray"),e("../../modules/es.typed-array.to-locale-string"),e("../../modules/es.typed-array.to-string"),e("../../modules/es.typed-array.iterator"),e("../../modules/es.object.to-string")},{"../../modules/es.object.to-string":128,"../../modules/es.typed-array.copy-within":129,"../../modules/es.typed-array.every":130,"../../modules/es.typed-array.fill":131,"../../modules/es.typed-array.filter":132,"../../modules/es.typed-array.find":134,"../../modules/es.typed-array.find-index":133,"../../modules/es.typed-array.for-each":135,"../../modules/es.typed-array.from":136,"../../modules/es.typed-array.includes":137,"../../modules/es.typed-array.index-of":138,"../../modules/es.typed-array.iterator":139,"../../modules/es.typed-array.join":140,"../../modules/es.typed-array.last-index-of":141,"../../modules/es.typed-array.map":142,"../../modules/es.typed-array.of":143,"../../modules/es.typed-array.reduce":145,"../../modules/es.typed-array.reduce-right":144,"../../modules/es.typed-array.reverse":146,"../../modules/es.typed-array.set":147,"../../modules/es.typed-array.slice":148,"../../modules/es.typed-array.some":149,"../../modules/es.typed-array.sort":150,"../../modules/es.typed-array.subarray":151,"../../modules/es.typed-array.to-locale-string":152,"../../modules/es.typed-array.to-string":153}],30:[function(e,t,r){e("../../modules/es.typed-array.uint32-array"),e("./methods");var n=e("../../internals/global");t.exports=n.Uint32Array},{"../../internals/global":68,"../../modules/es.typed-array.uint32-array":154,"./methods":29}],31:[function(e,t,r){e("../../modules/es.typed-array.reduce")},{"../../modules/es.typed-array.reduce":145}],32:[function(e,t,r){e("../../modules/es.typed-array.some")},{"../../modules/es.typed-array.some":149}],33:[function(e,t,r){var n=e("../../es/typed-array/uint32-array");t.exports=n},{"../../es/typed-array/uint32-array":30}],34:[function(e,t,r){t.exports=function(e){if("function"!=typeof e)throw TypeError(String(e)+" is not a function");return e}},{}],35:[function(e,t,r){var n=e("../internals/is-object");t.exports=function(e){if(!n(e)&&null!==e)throw TypeError("Can\'t set "+String(e)+" as a prototype");return e}},{"../internals/is-object":81}],36:[function(e,t,r){var n=e("../internals/well-known-symbol"),a=e("../internals/object-create"),o=e("../internals/object-define-property"),i=n("unscopables"),s=Array.prototype;null==s[i]&&o.f(s,i,{configurable:!0,value:a(null)}),t.exports=function(e){s[i][e]=!0}},{"../internals/object-create":87,"../internals/object-define-property":89,"../internals/well-known-symbol":126}],37:[function(e,t,r){t.exports=function(e,t,r){if(!(e instanceof t))throw TypeError("Incorrect "+(r?r+" ":"")+"invocation");return e}},{}],38:[function(e,t,r){var n=e("../internals/is-object");t.exports=function(e){if(!n(e))throw TypeError(String(e)+" is not an object");return e}},{"../internals/is-object":81}],39:[function(e,t,r){t.exports="undefined"!=typeof ArrayBuffer&&"undefined"!=typeof DataView},{}],40:[function(e,t,r){"use strict";function n(e){return l(e)&&u(N,c(e))}var a,o=e("../internals/array-buffer-native"),i=e("../internals/descriptors"),s=e("../internals/global"),l=e("../internals/is-object"),u=e("../internals/has"),c=e("../internals/classof"),d=e("../internals/create-non-enumerable-property"),p=e("../internals/redefine"),m=e("../internals/object-define-property").f,f=e("../internals/object-get-prototype-of"),h=e("../internals/object-set-prototype-of"),b=e("../internals/well-known-symbol"),g=e("../internals/uid"),y=s.Int8Array,v=y&&y.prototype,w=s.Uint8ClampedArray,x=w&&w.prototype,D=y&&f(y),k=v&&f(v),E=Object.prototype,A=E.isPrototypeOf,j=b("toStringTag"),C=g("TYPED_ARRAY_TAG"),F=o&&!!h&&"Opera"!==c(s.opera),T=!1,N={Int8Array:1,Uint8Array:1,Uint8ClampedArray:1,Int16Array:2,Uint16Array:2,Int32Array:4,Uint32Array:4,Float32Array:4,Float64Array:8};for(a in N)s[a]||(F=!1);if((!F||"function"!=typeof D||D===Function.prototype)&&(D=function(){throw TypeError("Incorrect invocation")},F))for(a in N)s[a]&&h(s[a],D);if((!F||!k||k===E)&&(k=D.prototype,F))for(a in N)s[a]&&h(s[a].prototype,k);if(F&&f(x)!==k&&h(x,k),i&&!u(k,j))for(a in T=!0,m(k,j,{get:function(){return l(this)?this[C]:void 0}}),N)s[a]&&d(s[a],C,a);t.exports={NATIVE_ARRAY_BUFFER_VIEWS:F,TYPED_ARRAY_TAG:T&&C,aTypedArray:function(e){if(n(e))return e;throw TypeError("Target is not a typed array")},aTypedArrayConstructor:function(e){if(h){if(A.call(D,e))return e}else for(var t in N)if(u(N,a)){var r=s[t];if(r&&(e===r||A.call(r,e)))return e}throw TypeError("Target is not a typed array constructor")},exportTypedArrayMethod:function(e,t,r){if(i){if(r)for(var n in N){var a=s[n];a&&u(a.prototype,e)&&delete a.prototype[e]}k[e]&&!r||p(k,e,!r&&F&&v[e]||t)}},exportTypedArrayStaticMethod:function(e,t,r){var n,a;if(i){if(h){if(r)for(n in N)(a=s[n])&&u(a,e)&&delete a[e];if(D[e]&&!r)return;try{return p(D,e,!r&&F&&y[e]||t)}catch(e){}}for(n in N)!(a=s[n])||a[e]&&!r||p(a,e,t)}},isView:function(e){var t=c(e);return"DataView"===t||u(N,t)},isTypedArray:n,TypedArray:D,TypedArrayPrototype:k}},{"../internals/array-buffer-native":39,"../internals/classof":53,"../internals/create-non-enumerable-property":57,"../internals/descriptors":60,"../internals/global":68,"../internals/has":69,"../internals/is-object":81,"../internals/object-define-property":89,"../internals/object-get-prototype-of":93,"../internals/object-set-prototype-of":97,"../internals/redefine":102,"../internals/uid":124,"../internals/well-known-symbol":126}],41:[function(e,t,r){"use strict";function n(e){return[255&e]}function a(e){return[255&e,e>>8&255]}function o(e){return[255&e,e>>8&255,e>>16&255,e>>24&255]}function i(e){return e[3]<<24|e[2]<<16|e[1]<<8|e[0]}function s(e){return V(e,23,4)}function l(e){return V(e,52,8)}function u(e,t){j(e[O],t,{get:function(){return N(this)[t]}})}function c(e,t,r,n){var a=x(r),o=N(e);if(a+t>o.byteLength)throw M(_);var i=N(o.buffer).bytes,s=a+o.byteOffset,l=i.slice(s,s+t);return n?l:l.reverse()}function d(e,t,r,n,a,o){var i=x(r),s=N(e);if(i+t>s.byteLength)throw M(_);for(var l=N(s.buffer).bytes,u=i+s.byteOffset,c=n(+a),d=0;d<t;d++)l[u+d]=c[o?d:t-d-1]}var p=e("../internals/global"),m=e("../internals/descriptors"),f=e("../internals/array-buffer-native"),h=e("../internals/create-non-enumerable-property"),b=e("../internals/redefine-all"),g=e("../internals/fails"),y=e("../internals/an-instance"),v=e("../internals/to-integer"),w=e("../internals/to-length"),x=e("../internals/to-index"),D=e("../internals/ieee754"),k=e("../internals/object-get-prototype-of"),E=e("../internals/object-set-prototype-of"),A=e("../internals/object-get-own-property-names").f,j=e("../internals/object-define-property").f,C=e("../internals/array-fill"),F=e("../internals/set-to-string-tag"),T=e("../internals/internal-state"),N=T.get,S=T.set,z="ArrayBuffer",q="DataView",O="prototype",_="Wrong index",R=p[z],P=R,I=p[q],L=I&&I[O],B=Object.prototype,M=p.RangeError,V=D.pack,U=D.unpack;if(f){if(!g(function(){R(1)})||!g(function(){new R(-1)})||g(function(){return new R,new R(1.5),new R(NaN),R.name!=z})){for(var H,$=(P=function(e){return y(this,P),new R(x(e))})[O]=R[O],G=A(R),W=0;G.length>W;)(H=G[W++])in P||h(P,H,R[H]);$.constructor=P}E&&k(L)!==B&&E(L,B);var Y=new I(new P(2)),K=L.setInt8;Y.setInt8(0,2147483648),Y.setInt8(1,2147483649),!Y.getInt8(0)&&Y.getInt8(1)||b(L,{setInt8:function(e,t){K.call(this,e,t<<24>>24)},setUint8:function(e,t){K.call(this,e,t<<24>>24)}},{unsafe:!0})}else P=function(e){y(this,P,z);var t=x(e);S(this,{bytes:C.call(new Array(t),0),byteLength:t}),m||(this.byteLength=t)},I=function(e,t,r){y(this,I,q),y(e,P,q);var n=N(e).byteLength,a=v(t);if(a<0||n<a)throw M("Wrong offset");if(n<a+(r=void 0===r?n-a:w(r)))throw M("Wrong length");S(this,{buffer:e,byteLength:r,byteOffset:a}),m||(this.buffer=e,this.byteLength=r,this.byteOffset=a)},m&&(u(P,"byteLength"),u(I,"buffer"),u(I,"byteLength"),u(I,"byteOffset")),b(I[O],{getInt8:function(e){return c(this,1,e)[0]<<24>>24},getUint8:function(e){return c(this,1,e)[0]},getInt16:function(e,t){var r=c(this,2,e,1<arguments.length?t:void 0);return(r[1]<<8|r[0])<<16>>16},getUint16:function(e,t){var r=c(this,2,e,1<arguments.length?t:void 0);return r[1]<<8|r[0]},getInt32:function(e,t){return i(c(this,4,e,1<arguments.length?t:void 0))},getUint32:function(e,t){return i(c(this,4,e,1<arguments.length?t:void 0))>>>0},getFloat32:function(e,t){return U(c(this,4,e,1<arguments.length?t:void 0),23)},getFloat64:function(e,t){return U(c(this,8,e,1<arguments.length?t:void 0),52)},setInt8:function(e,t){d(this,1,e,n,t)},setUint8:function(e,t){d(this,1,e,n,t)},setInt16:function(e,t,r){d(this,2,e,a,t,2<arguments.length?r:void 0)},setUint16:function(e,t,r){d(this,2,e,a,t,2<arguments.length?r:void 0)},setInt32:function(e,t,r){d(this,4,e,o,t,2<arguments.length?r:void 0)},setUint32:function(e,t,r){d(this,4,e,o,t,2<arguments.length?r:void 0)},setFloat32:function(e,t,r){d(this,4,e,s,t,2<arguments.length?r:void 0)},setFloat64:function(e,t,r){d(this,8,e,l,t,2<arguments.length?r:void 0)}});F(P,z),F(I,q),t.exports={ArrayBuffer:P,DataView:I}},{"../internals/an-instance":37,"../internals/array-buffer-native":39,"../internals/array-fill":43,"../internals/create-non-enumerable-property":57,"../internals/descriptors":60,"../internals/fails":64,"../internals/global":68,"../internals/ieee754":73,"../internals/internal-state":77,"../internals/object-define-property":89,"../internals/object-get-own-property-names":91,"../internals/object-get-prototype-of":93,"../internals/object-set-prototype-of":97,"../internals/redefine-all":101,"../internals/set-to-string-tag":106,"../internals/to-index":112,"../internals/to-integer":114,"../internals/to-length":115}],42:[function(e,t,r){"use strict";var n=e("../internals/to-object"),a=e("../internals/to-absolute-index"),o=e("../internals/to-length"),i=Math.min;t.exports=[].copyWithin||function(e,t,r){var s=n(this),l=o(s.length),u=a(e,l),c=a(t,l),d=2<arguments.length?r:void 0,p=i((void 0===d?l:a(d,l))-c,l-u),m=1;for(c<u&&u<c+p&&(m=-1,c+=p-1,u+=p-1);0<p--;)c in s?s[u]=s[c]:delete s[u],u+=m,c+=m;return s}},{"../internals/to-absolute-index":111,"../internals/to-length":115,"../internals/to-object":116}],43:[function(e,t,r){"use strict";var n=e("../internals/to-object"),a=e("../internals/to-absolute-index"),o=e("../internals/to-length");t.exports=function(e,t,r){for(var i=n(this),s=o(i.length),l=arguments.length,u=a(1<l?t:void 0,s),c=2<l?r:void 0,d=void 0===c?s:a(c,s);u<d;)i[u++]=e;return i}},{"../internals/to-absolute-index":111,"../internals/to-length":115,"../internals/to-object":116}],44:[function(e,t,r){function n(e){return function(t,r,n){var s,l=a(t),u=o(l.length),c=i(n,u);if(e&&r!=r){for(;c<u;)if((s=l[c++])!=s)return!0}else for(;c<u;c++)if((e||c in l)&&l[c]===r)return e||c||0;return!e&&-1}}var a=e("../internals/to-indexed-object"),o=e("../internals/to-length"),i=e("../internals/to-absolute-index");t.exports={includes:n(!0),indexOf:n(!1)}},{"../internals/to-absolute-index":111,"../internals/to-indexed-object":113,"../internals/to-length":115}],45:[function(e,t,r){function n(e){var t=1==e,r=2==e,n=3==e,c=4==e,d=6==e,p=5==e||d;return function(m,f,h,b){for(var g,y,v=i(m),w=o(v),x=a(f,h,3),D=s(w.length),k=0,E=b||l,A=t?E(m,D):r?E(m,0):void 0;k<D;k++)if((p||k in w)&&(y=x(g=w[k],k,v),e))if(t)A[k]=y;else if(y)switch(e){case 3:return!0;case 5:return g;case 6:return k;case 2:u.call(A,g)}else if(c)return!1;return d?-1:n||c?c:A}}var a=e("../internals/function-bind-context"),o=e("../internals/indexed-object"),i=e("../internals/to-object"),s=e("../internals/to-length"),l=e("../internals/array-species-create"),u=[].push;t.exports={forEach:n(0),map:n(1),filter:n(2),some:n(3),every:n(4),find:n(5),findIndex:n(6)}},{"../internals/array-species-create":50,"../internals/function-bind-context":65,"../internals/indexed-object":74,"../internals/to-length":115,"../internals/to-object":116}],46:[function(e,t,r){"use strict";var n=e("../internals/to-indexed-object"),a=e("../internals/to-integer"),o=e("../internals/to-length"),i=e("../internals/array-method-is-strict"),s=e("../internals/array-method-uses-to-length"),l=Math.min,u=[].lastIndexOf,c=!!u&&1/[1].lastIndexOf(1,-0)<0,d=i("lastIndexOf"),p=s("indexOf",{ACCESSORS:!0,1:0}),m=c||!d||!p;t.exports=m?function(e,t){if(c)return u.apply(this,arguments)||0;var r=n(this),i=o(r.length),s=i-1;for(1<arguments.length&&(s=l(s,a(t))),s<0&&(s=i+s);0<=s;s--)if(s in r&&r[s]===e)return s||0;return-1}:u},{"../internals/array-method-is-strict":47,"../internals/array-method-uses-to-length":48,"../internals/to-indexed-object":113,"../internals/to-integer":114,"../internals/to-length":115}],47:[function(e,t,r){"use strict";var n=e("../internals/fails");t.exports=function(e,t){var r=[][e];return!!r&&n(function(){r.call(null,t||function(){throw 1},1)})}},{"../internals/fails":64}],48:[function(e,t,r){function n(e){throw e}var a=e("../internals/descriptors"),o=e("../internals/fails"),i=e("../internals/has"),s=Object.defineProperty,l={};t.exports=function(e,t){if(i(l,e))return l[e];var r=[][e],u=!!i(t=t||{},"ACCESSORS")&&t.ACCESSORS,c=i(t,0)?t[0]:n,d=i(t,1)?t[1]:void 0;return l[e]=!!r&&!o(function(){if(u&&!a)return!0;var e={length:-1};u?s(e,1,{enumerable:!0,get:n}):e[1]=1,r.call(e,c,d)})}},{"../internals/descriptors":60,"../internals/fails":64,"../internals/has":69}],49:[function(e,t,r){function n(e){return function(t,r,n,l){a(r);var u=o(t),c=i(u),d=s(u.length),p=e?d-1:0,m=e?-1:1;if(n<2)for(;;){if(p in c){l=c[p],p+=m;break}if(p+=m,e?p<0:d<=p)throw TypeError("Reduce of empty array with no initial value")}for(;e?0<=p:p<d;p+=m)p in c&&(l=r(l,c[p],p,u));return l}}var a=e("../internals/a-function"),o=e("../internals/to-object"),i=e("../internals/indexed-object"),s=e("../internals/to-length");t.exports={left:n(!1),right:n(!0)}},{"../internals/a-function":34,"../internals/indexed-object":74,"../internals/to-length":115,"../internals/to-object":116}],50:[function(e,t,r){var n=e("../internals/is-object"),a=e("../internals/is-array"),o=e("../internals/well-known-symbol")("species");t.exports=function(e,t){var r;return a(e)&&("function"==typeof(r=e.constructor)&&(r===Array||a(r.prototype))||n(r)&&null===(r=r[o]))&&(r=void 0),new(void 0===r?Array:r)(0===t?0:t)}},{"../internals/is-array":79,"../internals/is-object":81,"../internals/well-known-symbol":126}],51:[function(e,t,r){var n=e("../internals/well-known-symbol")("iterator"),a=!1;try{var o=0,i={next:function(){return{done:!!o++}},return:function(){a=!0}};i[n]=function(){return this},Array.from(i,function(){throw 2})}catch(e){}t.exports=function(e,t){if(!t&&!a)return!1;var r=!1;try{var o={};o[n]=function(){return{next:function(){return{done:r=!0}}}},e(o)}catch(e){}return r}},{"../internals/well-known-symbol":126}],52:[function(e,t,r){var n={}.toString;t.exports=function(e){return n.call(e).slice(8,-1)}},{}],53:[function(e,t,r){var n=e("../internals/to-string-tag-support"),a=e("../internals/classof-raw"),o=e("../internals/well-known-symbol")("toStringTag"),i="Arguments"==a(function(){return arguments}());t.exports=n?a:function(e){var t,r,n;return void 0===e?"Undefined":null===e?"Null":"string"==typeof(r=function(e,t){try{return e[t]}catch(e){}}(t=Object(e),o))?r:i?a(t):"Object"==(n=a(t))&&"function"==typeof t.callee?"Arguments":n}},{"../internals/classof-raw":52,"../internals/to-string-tag-support":120,"../internals/well-known-symbol":126}],54:[function(e,t,r){var n=e("../internals/has"),a=e("../internals/own-keys"),o=e("../internals/object-get-own-property-descriptor"),i=e("../internals/object-define-property");t.exports=function(e,t){for(var r=a(t),s=i.f,l=o.f,u=0;u<r.length;u++){var c=r[u];n(e,c)||s(e,c,l(t,c))}}},{"../internals/has":69,"../internals/object-define-property":89,"../internals/object-get-own-property-descriptor":90,"../internals/own-keys":99}],55:[function(e,t,r){var n=e("../internals/fails");t.exports=!n(function(){function e(){}return e.prototype.constructor=null,Object.getPrototypeOf(new e)!==e.prototype})},{"../internals/fails":64}],56:[function(e,t,r){"use strict";function n(){return this}var a=e("../internals/iterators-core").IteratorPrototype,o=e("../internals/object-create"),i=e("../internals/create-property-descriptor"),s=e("../internals/set-to-string-tag"),l=e("../internals/iterators");t.exports=function(e,t,r){var u=t+" Iterator";return e.prototype=o(a,{next:i(1,r)}),s(e,u,!1,!0),l[u]=n,e}},{"../internals/create-property-descriptor":58,"../internals/iterators":84,"../internals/iterators-core":83,"../internals/object-create":87,"../internals/set-to-string-tag":106}],57:[function(e,t,r){var n=e("../internals/descriptors"),a=e("../internals/object-define-property"),o=e("../internals/create-property-descriptor");t.exports=n?function(e,t,r){return a.f(e,t,o(1,r))}:function(e,t,r){return e[t]=r,e}},{"../internals/create-property-descriptor":58,"../internals/descriptors":60,"../internals/object-define-property":89}],58:[function(e,t,r){t.exports=function(e,t){return{enumerable:!(1&e),configurable:!(2&e),writable:!(4&e),value:t}}},{}],59:[function(e,t,r){"use strict";function n(){return this}var a=e("../internals/export"),o=e("../internals/create-iterator-constructor"),i=e("../internals/object-get-prototype-of"),s=e("../internals/object-set-prototype-of"),l=e("../internals/set-to-string-tag"),u=e("../internals/create-non-enumerable-property"),c=e("../internals/redefine"),d=e("../internals/well-known-symbol"),p=e("../internals/is-pure"),m=e("../internals/iterators"),f=e("../internals/iterators-core"),h=f.IteratorPrototype,b=f.BUGGY_SAFARI_ITERATORS,g=d("iterator"),y="values",v="entries";t.exports=function(e,t,r,d,f,w,x){function D(e){if(e===f&&N)return N;if(!b&&e in F)return F[e];switch(e){case"keys":case y:case v:return function(){return new r(this,e)}}return function(){return new r(this)}}o(r,t,d);var k,E,A,j=t+" Iterator",C=!1,F=e.prototype,T=F[g]||F["@@iterator"]||f&&F[f],N=!b&&T||D(f),S="Array"==t&&F.entries||T;if(S&&(k=i(S.call(new e)),h!==Object.prototype&&k.next&&(p||i(k)===h||(s?s(k,h):"function"!=typeof k[g]&&u(k,g,n)),l(k,j,!0,!0),p&&(m[j]=n))),f==y&&T&&T.name!==y&&(C=!0,N=function(){return T.call(this)}),p&&!x||F[g]===N||u(F,g,N),m[t]=N,f)if(E={values:D(y),keys:w?N:D("keys"),entries:D(v)},x)for(A in E)!b&&!C&&A in F||c(F,A,E[A]);else a({target:t,proto:!0,forced:b||C},E);return E}},{"../internals/create-iterator-constructor":56,"../internals/create-non-enumerable-property":57,"../internals/export":63,"../internals/is-pure":82,"../internals/iterators":84,"../internals/iterators-core":83,"../internals/object-get-prototype-of":93,"../internals/object-set-prototype-of":97,"../internals/redefine":102,"../internals/set-to-string-tag":106,"../internals/well-known-symbol":126}],60:[function(e,t,r){var n=e("../internals/fails");t.exports=!n(function(){return 7!=Object.defineProperty({},1,{get:function(){return 7}})[1]})},{"../internals/fails":64}],61:[function(e,t,r){var n=e("../internals/global"),a=e("../internals/is-object"),o=n.document,i=a(o)&&a(o.createElement);t.exports=function(e){return i?o.createElement(e):{}}},{"../internals/global":68,"../internals/is-object":81}],62:[function(e,t,r){t.exports=["constructor","hasOwnProperty","isPrototypeOf","propertyIsEnumerable","toLocaleString","toString","valueOf"]},{}],63:[function(e,t,r){var n=e("../internals/global"),a=e("../internals/object-get-own-property-descriptor").f,o=e("../internals/create-non-enumerable-property"),i=e("../internals/redefine"),s=e("../internals/set-global"),l=e("../internals/copy-constructor-properties"),u=e("../internals/is-forced");t.exports=function(e,t){var r,c,d,p,m,f=e.target,h=e.global,b=e.stat;if(r=h?n:b?n[f]||s(f,{}):(n[f]||{}).prototype)for(c in t){if(p=t[c],d=e.noTargetGet?(m=a(r,c))&&m.value:r[c],!u(h?c:f+(b?".":"#")+c,e.forced)&&void 0!==d){if(typeof p==typeof d)continue;l(p,d)}(e.sham||d&&d.sham)&&o(p,"sham",!0),i(r,c,p,e)}}},{"../internals/copy-constructor-properties":54,"../internals/create-non-enumerable-property":57,"../internals/global":68,"../internals/is-forced":80,"../internals/object-get-own-property-descriptor":90,"../internals/redefine":102,"../internals/set-global":104}],64:[function(e,t,r){t.exports=function(e){try{return!!e()}catch(e){return!0}}},{}],65:[function(e,t,r){var n=e("../internals/a-function");t.exports=function(e,t,r){if(n(e),void 0===t)return e;switch(r){case 0:return function(){return e.call(t)};case 1:return function(r){return e.call(t,r)};case 2:return function(r,n){return e.call(t,r,n)};case 3:return function(r,n,a){return e.call(t,r,n,a)}}return function(){return e.apply(t,arguments)}}},{"../internals/a-function":34}],66:[function(e,t,r){function n(e){return"function"==typeof e?e:void 0}var a=e("../internals/path"),o=e("../internals/global");t.exports=function(e,t){return arguments.length<2?n(a[e])||n(o[e]):a[e]&&a[e][t]||o[e]&&o[e][t]}},{"../internals/global":68,"../internals/path":100}],67:[function(e,t,r){var n=e("../internals/classof"),a=e("../internals/iterators"),o=e("../internals/well-known-symbol")("iterator");t.exports=function(e){if(null!=e)return e[o]||e["@@iterator"]||a[n(e)]}},{"../internals/classof":53,"../internals/iterators":84,"../internals/well-known-symbol":126}],68:[function(e,n,a){(function(e){function r(e){return e&&e.Math==Math&&e}n.exports=r("object"==typeof globalThis&&globalThis)||r("object"==typeof t&&t)||r("object"==typeof self&&self)||r("object"==typeof e&&e)||Function("return this")()}).call(this,void 0!==r?r:"undefined"!=typeof self?self:void 0!==t?t:{})},{}],69:[function(e,t,r){var n={}.hasOwnProperty;t.exports=function(e,t){return n.call(e,t)}},{}],70:[function(e,t,r){t.exports={}},{}],71:[function(e,t,r){var n=e("../internals/get-built-in");t.exports=n("document","documentElement")},{"../internals/get-built-in":66}],72:[function(e,t,r){var n=e("../internals/descriptors"),a=e("../internals/fails"),o=e("../internals/document-create-element");t.exports=!n&&!a(function(){return 7!=Object.defineProperty(o("div"),"a",{get:function(){return 7}}).a})},{"../internals/descriptors":60,"../internals/document-create-element":61,"../internals/fails":64}],73:[function(e,t,r){var n=Math.abs,a=Math.pow,o=Math.floor,i=Math.log,s=Math.LN2;t.exports={pack:function(e,t,r){var l,u,c,d=new Array(r),p=8*r-t-1,m=(1<<p)-1,f=m>>1,h=23===t?a(2,-24)-a(2,-77):0,b=e<0||0===e&&1/e<0?1:0,g=0;for((e=n(e))!=e||e===1/0?(u=e!=e?1:0,l=m):(l=o(i(e)/s),e*(c=a(2,-l))<1&&(l--,c*=2),2<=(e+=1<=l+f?h/c:h*a(2,1-f))*c&&(l++,c/=2),m<=l+f?(u=0,l=m):1<=l+f?(u=(e*c-1)*a(2,t),l+=f):(u=e*a(2,f-1)*a(2,t),l=0));8<=t;d[g++]=255&u,u/=256,t-=8);for(l=l<<t|u,p+=t;0<p;d[g++]=255&l,l/=256,p-=8);return d[--g]|=128*b,d},unpack:function(e,t){var r,n=e.length,o=8*n-t-1,i=(1<<o)-1,s=i>>1,l=o-7,u=n-1,c=e[u--],d=127&c;for(c>>=7;0<l;d=256*d+e[u],u--,l-=8);for(r=d&(1<<-l)-1,d>>=-l,l+=t;0<l;r=256*r+e[u],u--,l-=8);if(0===d)d=1-s;else{if(d===i)return r?NaN:c?-1/0:1/0;r+=a(2,t),d-=s}return(c?-1:1)*r*a(2,d-t)}}},{}],74:[function(e,t,r){var n=e("../internals/fails"),a=e("../internals/classof-raw"),o="".split;t.exports=n(function(){return!Object("z").propertyIsEnumerable(0)})?function(e){return"String"==a(e)?o.call(e,""):Object(e)}:Object},{"../internals/classof-raw":52,"../internals/fails":64}],75:[function(e,t,r){var n=e("../internals/is-object"),a=e("../internals/object-set-prototype-of");t.exports=function(e,t,r){var o,i;return a&&"function"==typeof(o=t.constructor)&&o!==r&&n(i=o.prototype)&&i!==r.prototype&&a(e,i),e}},{"../internals/is-object":81,"../internals/object-set-prototype-of":97}],76:[function(e,t,r){var n=e("../internals/shared-store"),a=Function.toString;"function"!=typeof n.inspectSource&&(n.inspectSource=function(e){return a.call(e)}),t.exports=n.inspectSource},{"../internals/shared-store":108}],77:[function(e,t,r){var n,a,o,i=e("../internals/native-weak-map"),s=e("../internals/global"),l=e("../internals/is-object"),u=e("../internals/create-non-enumerable-property"),c=e("../internals/has"),d=e("../internals/shared-key"),p=e("../internals/hidden-keys"),m=s.WeakMap;if(i){var f=new m,h=f.get,b=f.has,g=f.set;n=function(e,t){return g.call(f,e,t),t},a=function(e){return h.call(f,e)||{}},o=function(e){return b.call(f,e)}}else{var y=d("state");p[y]=!0,n=function(e,t){return u(e,y,t),t},a=function(e){return c(e,y)?e[y]:{}},o=function(e){return c(e,y)}}t.exports={set:n,get:a,has:o,enforce:function(e){return o(e)?a(e):n(e,{})},getterFor:function(e){return function(t){var r;if(!l(t)||(r=a(t)).type!==e)throw TypeError("Incompatible receiver, "+e+" required");return r}}}},{"../internals/create-non-enumerable-property":57,"../internals/global":68,"../internals/has":69,"../internals/hidden-keys":70,"../internals/is-object":81,"../internals/native-weak-map":86,"../internals/shared-key":107}],78:[function(e,t,r){var n=e("../internals/well-known-symbol"),a=e("../internals/iterators"),o=n("iterator"),i=Array.prototype;t.exports=function(e){return void 0!==e&&(a.Array===e||i[o]===e)}},{"../internals/iterators":84,"../internals/well-known-symbol":126}],79:[function(e,t,r){var n=e("../internals/classof-raw");t.exports=Array.isArray||function(e){return"Array"==n(e)}},{"../internals/classof-raw":52}],80:[function(e,t,r){function n(e,t){var r=s[i(e)];return r==u||r!=l&&("function"==typeof t?a(t):!!t)}var a=e("../internals/fails"),o=/#|\\.prototype\\./,i=n.normalize=function(e){return String(e).replace(o,".").toLowerCase()},s=n.data={},l=n.NATIVE="N",u=n.POLYFILL="P";t.exports=n},{"../internals/fails":64}],81:[function(e,t,r){t.exports=function(e){return"object"==typeof e?null!==e:"function"==typeof e}},{}],82:[function(e,t,r){t.exports=!1},{}],83:[function(e,t,r){"use strict";var n,a,o,i=e("../internals/object-get-prototype-of"),s=e("../internals/create-non-enumerable-property"),l=e("../internals/has"),u=e("../internals/well-known-symbol"),c=e("../internals/is-pure"),d=u("iterator"),p=!1;[].keys&&("next"in(o=[].keys())?(a=i(i(o)))!==Object.prototype&&(n=a):p=!0),null==n&&(n={}),c||l(n,d)||s(n,d,function(){return this}),t.exports={IteratorPrototype:n,BUGGY_SAFARI_ITERATORS:p}},{"../internals/create-non-enumerable-property":57,"../internals/has":69,"../internals/is-pure":82,"../internals/object-get-prototype-of":93,"../internals/well-known-symbol":126}],84:[function(e,t,r){arguments[4][70][0].apply(r,arguments)},{dup:70}],85:[function(e,t,r){var n=e("../internals/fails");t.exports=!!Object.getOwnPropertySymbols&&!n(function(){return!String(Symbol())})},{"../internals/fails":64}],86:[function(e,t,r){var n=e("../internals/global"),a=e("../internals/inspect-source"),o=n.WeakMap;t.exports="function"==typeof o&&/native code/.test(a(o))},{"../internals/global":68,"../internals/inspect-source":76}],87:[function(e,t,r){function a(){}function o(e){return"<script>"+e+"</"+h+">"}var i,s=e("../internals/an-object"),l=e("../internals/object-define-properties"),u=e("../internals/enum-bug-keys"),c=e("../internals/hidden-keys"),d=e("../internals/html"),p=e("../internals/document-create-element"),m=e("../internals/shared-key"),f="prototype",h="script",b=m("IE_PROTO"),g=function(){try{i=n.domain&&new ActiveXObject("htmlfile")}catch(e){}var e,t;g=i?function(e){e.write(o("")),e.close();var t=e.parentWindow.Object;return e=null,t}(i):((t=p("iframe")).style.display="none",d.appendChild(t),t.src=String("javascript:"),(e=t.contentWindow.document).open(),e.write(o("document.F=Object")),e.close(),e.F);for(var r=u.length;r--;)delete g[f][u[r]];return g()};c[b]=!0,t.exports=Object.create||function(e,t){var r;return null!==e?(a[f]=s(e),r=new a,a[f]=null,r[b]=e):r=g(),void 0===t?r:l(r,t)}},{"../internals/an-object":38,"../internals/document-create-element":61,"../internals/enum-bug-keys":62,"../internals/hidden-keys":70,"../internals/html":71,"../internals/object-define-properties":88,"../internals/shared-key":107}],88:[function(e,t,r){var n=e("../internals/descriptors"),a=e("../internals/object-define-property"),o=e("../internals/an-object"),i=e("../internals/object-keys");t.exports=n?Object.defineProperties:function(e,t){o(e);for(var r,n=i(t),s=n.length,l=0;l<s;)a.f(e,r=n[l++],t[r]);return e}},{"../internals/an-object":38,"../internals/descriptors":60,"../internals/object-define-property":89,"../internals/object-keys":95}],89:[function(e,t,r){var n=e("../internals/descriptors"),a=e("../internals/ie8-dom-define"),o=e("../internals/an-object"),i=e("../internals/to-primitive"),s=Object.defineProperty;r.f=n?s:function(e,t,r){if(o(e),t=i(t,!0),o(r),a)try{return s(e,t,r)}catch(e){}if("get"in r||"set"in r)throw TypeError("Accessors not supported");return"value"in r&&(e[t]=r.value),e}},{"../internals/an-object":38,"../internals/descriptors":60,"../internals/ie8-dom-define":72,"../internals/to-primitive":119}],90:[function(e,t,r){var n=e("../internals/descriptors"),a=e("../internals/object-property-is-enumerable"),o=e("../internals/create-property-descriptor"),i=e("../internals/to-indexed-object"),s=e("../internals/to-primitive"),l=e("../internals/has"),u=e("../internals/ie8-dom-define"),c=Object.getOwnPropertyDescriptor;r.f=n?c:function(e,t){if(e=i(e),t=s(t,!0),u)try{return c(e,t)}catch(e){}if(l(e,t))return o(!a.f.call(e,t),e[t])}},{"../internals/create-property-descriptor":58,"../internals/descriptors":60,"../internals/has":69,"../internals/ie8-dom-define":72,"../internals/object-property-is-enumerable":96,"../internals/to-indexed-object":113,"../internals/to-primitive":119}],91:[function(e,t,r){var n=e("../internals/object-keys-internal"),a=e("../internals/enum-bug-keys").concat("length","prototype");r.f=Object.getOwnPropertyNames||function(e){return n(e,a)}},{"../internals/enum-bug-keys":62,"../internals/object-keys-internal":94}],92:[function(e,t,r){r.f=Object.getOwnPropertySymbols},{}],93:[function(e,t,r){var n=e("../internals/has"),a=e("../internals/to-object"),o=e("../internals/shared-key"),i=e("../internals/correct-prototype-getter"),s=o("IE_PROTO"),l=Object.prototype;t.exports=i?Object.getPrototypeOf:function(e){return e=a(e),n(e,s)?e[s]:"function"==typeof e.constructor&&e instanceof e.constructor?e.constructor.prototype:e instanceof Object?l:null}},{"../internals/correct-prototype-getter":55,"../internals/has":69,"../internals/shared-key":107,"../internals/to-object":116}],94:[function(e,t,r){var n=e("../internals/has"),a=e("../internals/to-indexed-object"),o=e("../internals/array-includes").indexOf,i=e("../internals/hidden-keys");t.exports=function(e,t){var r,s=a(e),l=0,u=[];for(r in s)!n(i,r)&&n(s,r)&&u.push(r);for(;t.length>l;)n(s,r=t[l++])&&(~o(u,r)||u.push(r));return u}},{"../internals/array-includes":44,"../internals/has":69,"../internals/hidden-keys":70,"../internals/to-indexed-object":113}],95:[function(e,t,r){var n=e("../internals/object-keys-internal"),a=e("../internals/enum-bug-keys");t.exports=Object.keys||function(e){return n(e,a)}},{"../internals/enum-bug-keys":62,"../internals/object-keys-internal":94}],96:[function(e,t,r){"use strict";var n={}.propertyIsEnumerable,a=Object.getOwnPropertyDescriptor,o=a&&!n.call({1:2},1);r.f=o?function(e){var t=a(this,e);return!!t&&t.enumerable}:n},{}],97:[function(e,t,r){var n=e("../internals/an-object"),a=e("../internals/a-possible-prototype");t.exports=Object.setPrototypeOf||("__proto__"in{}?function(){var e,t=!1,r={};try{(e=Object.getOwnPropertyDescriptor(Object.prototype,"__proto__").set).call(r,[]),t=r instanceof Array}catch(r){}return function(r,o){return n(r),a(o),t?e.call(r,o):r.__proto__=o,r}}():void 0)},{"../internals/a-possible-prototype":35,"../internals/an-object":38}],98:[function(e,t,r){"use strict";var n=e("../internals/to-string-tag-support"),a=e("../internals/classof");t.exports=n?{}.toString:function(){return"[object "+a(this)+"]"}},{"../internals/classof":53,"../internals/to-string-tag-support":120}],99:[function(e,t,r){var n=e("../internals/get-built-in"),a=e("../internals/object-get-own-property-names"),o=e("../internals/object-get-own-property-symbols"),i=e("../internals/an-object");t.exports=n("Reflect","ownKeys")||function(e){var t=a.f(i(e)),r=o.f;return r?t.concat(r(e)):t}},{"../internals/an-object":38,"../internals/get-built-in":66,"../internals/object-get-own-property-names":91,"../internals/object-get-own-property-symbols":92}],100:[function(e,t,r){var n=e("../internals/global");t.exports=n},{"../internals/global":68}],101:[function(e,t,r){var n=e("../internals/redefine");t.exports=function(e,t,r){for(var a in t)n(e,a,t[a],r);return e}},{"../internals/redefine":102}],102:[function(e,t,r){var n=e("../internals/global"),a=e("../internals/create-non-enumerable-property"),o=e("../internals/has"),i=e("../internals/set-global"),s=e("../internals/inspect-source"),l=e("../internals/internal-state"),u=l.get,c=l.enforce,d=String(String).split("String");(t.exports=function(e,t,r,s){var l=!!s&&!!s.unsafe,u=!!s&&!!s.enumerable,p=!!s&&!!s.noTargetGet;"function"==typeof r&&("string"!=typeof t||o(r,"name")||a(r,"name",t),c(r).source=d.join("string"==typeof t?t:"")),e!==n?(l?!p&&e[t]&&(u=!0):delete e[t],u?e[t]=r:a(e,t,r)):u?e[t]=r:i(t,r)})(Function.prototype,"toString",function(){return"function"==typeof this&&u(this).source||s(this)})},{"../internals/create-non-enumerable-property":57,"../internals/global":68,"../internals/has":69,"../internals/inspect-source":76,"../internals/internal-state":77,"../internals/set-global":104}],103:[function(e,t,r){t.exports=function(e){if(null==e)throw TypeError("Can\'t call method on "+e);return e}},{}],104:[function(e,t,r){var n=e("../internals/global"),a=e("../internals/create-non-enumerable-property");t.exports=function(e,t){try{a(n,e,t)}catch(r){n[e]=t}return t}},{"../internals/create-non-enumerable-property":57,"../internals/global":68}],105:[function(e,t,r){"use strict";var n=e("../internals/get-built-in"),a=e("../internals/object-define-property"),o=e("../internals/well-known-symbol"),i=e("../internals/descriptors"),s=o("species");t.exports=function(e){var t=n(e),r=a.f;i&&t&&!t[s]&&r(t,s,{configurable:!0,get:function(){return this}})}},{"../internals/descriptors":60,"../internals/get-built-in":66,"../internals/object-define-property":89,"../internals/well-known-symbol":126}],106:[function(e,t,r){var n=e("../internals/object-define-property").f,a=e("../internals/has"),o=e("../internals/well-known-symbol")("toStringTag");t.exports=function(e,t,r){e&&!a(e=r?e:e.prototype,o)&&n(e,o,{configurable:!0,value:t})}},{"../internals/has":69,"../internals/object-define-property":89,"../internals/well-known-symbol":126}],107:[function(e,t,r){var n=e("../internals/shared"),a=e("../internals/uid"),o=n("keys");t.exports=function(e){return o[e]||(o[e]=a(e))}},{"../internals/shared":109,"../internals/uid":124}],108:[function(e,t,r){var n=e("../internals/global"),a=e("../internals/set-global"),o="__core-js_shared__",i=n[o]||a(o,{});t.exports=i},{"../internals/global":68,"../internals/set-global":104}],109:[function(e,t,r){var n=e("../internals/is-pure"),a=e("../internals/shared-store");(t.exports=function(e,t){return a[e]||(a[e]=void 0!==t?t:{})})("versions",[]).push({version:"3.6.4",mode:n?"pure":"global",copyright:"© 2020 Denis Pushkarev (zloirock.ru)"})},{"../internals/is-pure":82,"../internals/shared-store":108}],110:[function(e,t,r){var n=e("../internals/an-object"),a=e("../internals/a-function"),o=e("../internals/well-known-symbol")("species");t.exports=function(e,t){var r,i=n(e).constructor;return void 0===i||null==(r=n(i)[o])?t:a(r)}},{"../internals/a-function":34,"../internals/an-object":38,"../internals/well-known-symbol":126}],111:[function(e,t,r){var n=e("../internals/to-integer"),a=Math.max,o=Math.min;t.exports=function(e,t){var r=n(e);return r<0?a(r+t,0):o(r,t)}},{"../internals/to-integer":114}],112:[function(e,t,r){var n=e("../internals/to-integer"),a=e("../internals/to-length");t.exports=function(e){if(void 0===e)return 0;var t=n(e),r=a(t);if(t!==r)throw RangeError("Wrong length or index");return r}},{"../internals/to-integer":114,"../internals/to-length":115}],113:[function(e,t,r){var n=e("../internals/indexed-object"),a=e("../internals/require-object-coercible");t.exports=function(e){return n(a(e))}},{"../internals/indexed-object":74,"../internals/require-object-coercible":103}],114:[function(e,t,r){var n=Math.ceil,a=Math.floor;t.exports=function(e){return isNaN(e=+e)?0:(0<e?a:n)(e)}},{}],115:[function(e,t,r){var n=e("../internals/to-integer"),a=Math.min;t.exports=function(e){return 0<e?a(n(e),9007199254740991):0}},{"../internals/to-integer":114}],116:[function(e,t,r){var n=e("../internals/require-object-coercible");t.exports=function(e){return Object(n(e))}},{"../internals/require-object-coercible":103}],117:[function(e,t,r){var n=e("../internals/to-positive-integer");t.exports=function(e,t){var r=n(e);if(r%t)throw RangeError("Wrong offset");return r}},{"../internals/to-positive-integer":118}],118:[function(e,t,r){var n=e("../internals/to-integer");t.exports=function(e){var t=n(e);if(t<0)throw RangeError("The argument can\'t be less than 0");return t}},{"../internals/to-integer":114}],119:[function(e,t,r){var n=e("../internals/is-object");t.exports=function(e,t){if(!n(e))return e;var r,a;if(t&&"function"==typeof(r=e.toString)&&!n(a=r.call(e)))return a;if("function"==typeof(r=e.valueOf)&&!n(a=r.call(e)))return a;if(!t&&"function"==typeof(r=e.toString)&&!n(a=r.call(e)))return a;throw TypeError("Can\'t convert object to primitive value")}},{"../internals/is-object":81}],120:[function(e,t,r){var n={};n[e("../internals/well-known-symbol")("toStringTag")]="z",t.exports="[object z]"===String(n)},{"../internals/well-known-symbol":126}],121:[function(e,t,r){"use strict";function n(e,t){for(var r=0,n=t.length,a=new(W(e))(n);r<n;)a[r]=t[r++];return a}function a(e,t){P(e,t,{get:function(){return _(this)[t]}})}function o(e){var t;return e instanceof M||"ArrayBuffer"==(t=k(e))||"SharedArrayBuffer"==t}function i(e,t){return Y(e)&&"symbol"!=typeof t&&t in e&&String(+t)==String(t)}function s(e,t){return i(e,t=x(t,!0))?b(2,e[t]):I(e,t)}function l(e,t,r){return!(i(e,t=x(t,!0))&&E(r)&&D(r,"value"))||D(r,"get")||D(r,"set")||r.configurable||D(r,"writable")&&!r.writable||D(r,"enumerable")&&!r.enumerable?P(e,t,r):(e[t]=r.value,e)}var u=e("../internals/export"),c=e("../internals/global"),d=e("../internals/descriptors"),p=e("../internals/typed-array-constructors-require-wrappers"),m=e("../internals/array-buffer-view-core"),f=e("../internals/array-buffer"),h=e("../internals/an-instance"),b=e("../internals/create-property-descriptor"),g=e("../internals/create-non-enumerable-property"),y=e("../internals/to-length"),v=e("../internals/to-index"),w=e("../internals/to-offset"),x=e("../internals/to-primitive"),D=e("../internals/has"),k=e("../internals/classof"),E=e("../internals/is-object"),A=e("../internals/object-create"),j=e("../internals/object-set-prototype-of"),C=e("../internals/object-get-own-property-names").f,F=e("../internals/typed-array-from"),T=e("../internals/array-iteration").forEach,N=e("../internals/set-species"),S=e("../internals/object-define-property"),z=e("../internals/object-get-own-property-descriptor"),q=e("../internals/internal-state"),O=e("../internals/inherit-if-required"),_=q.get,R=q.set,P=S.f,I=z.f,L=Math.round,B=c.RangeError,M=f.ArrayBuffer,V=f.DataView,U=m.NATIVE_ARRAY_BUFFER_VIEWS,H=m.TYPED_ARRAY_TAG,$=m.TypedArray,G=m.TypedArrayPrototype,W=m.aTypedArrayConstructor,Y=m.isTypedArray,K="BYTES_PER_ELEMENT",X="Wrong length";d?(U||(z.f=s,S.f=l,a(G,"buffer"),a(G,"byteOffset"),a(G,"byteLength"),a(G,"length")),u({target:"Object",stat:!0,forced:!U},{getOwnPropertyDescriptor:s,defineProperty:l}),t.exports=function(e,t,r){function a(e,t){P(e,t,{get:function(){return e=t,(r=_(this)).view[l](e*i+r.byteOffset,!0);var e,r},set:function(e){return n=t,a=e,o=_(this),r&&(a=(a=L(a))<0?0:255<a?255:255&a),void o.view[d](n*i+o.byteOffset,a,!0);var n,a,o},enumerable:!0})}var i=e.match(/\\d+$/)[0]/8,s=e+(r?"Clamped":"")+"Array",l="get"+e,d="set"+e,m=c[s],f=m,b=f&&f.prototype,x={};U?p&&(f=t(function(e,t,r,a){return h(e,f,s),O(E(t)?o(t)?void 0!==a?new m(t,w(r,i),a):void 0!==r?new m(t,w(r,i)):new m(t):Y(t)?n(f,t):F.call(f,t):new m(v(t)),e,f)}),j&&j(f,$),T(C(m),function(e){e in f||g(f,e,m[e])}),f.prototype=b):(f=t(function(e,t,r,l){h(e,f,s);var u,c,d,p=0,m=0;if(E(t)){if(!o(t))return Y(t)?n(f,t):F.call(f,t);u=t,m=w(r,i);var b=t.byteLength;if(void 0===l){if(b%i)throw B(X);if((c=b-m)<0)throw B(X)}else if(b<(c=y(l)*i)+m)throw B(X);d=c/i}else d=v(t),u=new M(c=d*i);for(R(e,{buffer:u,byteOffset:m,byteLength:c,length:d,view:new V(u)});p<d;)a(e,p++)}),j&&j(f,$),b=f.prototype=A(G)),b.constructor!==f&&g(b,"constructor",f),H&&g(b,H,s),x[s]=f,u({global:!0,forced:f!=m,sham:!U},x),K in f||g(f,K,i),K in b||g(b,K,i),N(s)}):t.exports=function(){}},{"../internals/an-instance":37,"../internals/array-buffer":41,"../internals/array-buffer-view-core":40,"../internals/array-iteration":45,"../internals/classof":53,"../internals/create-non-enumerable-property":57,"../internals/create-property-descriptor":58,"../internals/descriptors":60,"../internals/export":63,"../internals/global":68,"../internals/has":69,"../internals/inherit-if-required":75,"../internals/internal-state":77,"../internals/is-object":81,"../internals/object-create":87,"../internals/object-define-property":89,"../internals/object-get-own-property-descriptor":90,"../internals/object-get-own-property-names":91,"../internals/object-set-prototype-of":97,"../internals/set-species":105,"../internals/to-index":112,"../internals/to-length":115,"../internals/to-offset":117,"../internals/to-primitive":119,"../internals/typed-array-constructors-require-wrappers":122,"../internals/typed-array-from":123}],122:[function(e,t,r){var n=e("../internals/global"),a=e("../internals/fails"),o=e("../internals/check-correctness-of-iteration"),i=e("../internals/array-buffer-view-core").NATIVE_ARRAY_BUFFER_VIEWS,s=n.ArrayBuffer,l=n.Int8Array;t.exports=!i||!a(function(){l(1)})||!a(function(){new l(-1)})||!o(function(e){new l,new l(null),new l(1.5),new l(e)},!0)||a(function(){return 1!==new l(new s(2),1,void 0).length})},{"../internals/array-buffer-view-core":40,"../internals/check-correctness-of-iteration":51,"../internals/fails":64,"../internals/global":68}],123:[function(e,t,r){var n=e("../internals/to-object"),a=e("../internals/to-length"),o=e("../internals/get-iterator-method"),i=e("../internals/is-array-iterator-method"),s=e("../internals/function-bind-context"),l=e("../internals/array-buffer-view-core").aTypedArrayConstructor;t.exports=function(e,t,r){var u,c,d,p,m,f,h=n(e),b=arguments.length,g=1<b?t:void 0,y=void 0!==g,v=o(h);if(null!=v&&!i(v))for(f=(m=v.call(h)).next,h=[];!(p=f.call(m)).done;)h.push(p.value);for(y&&2<b&&(g=s(g,r,2)),c=a(h.length),d=new(l(this))(c),u=0;u<c;u++)d[u]=y?g(h[u],u):h[u];return d}},{"../internals/array-buffer-view-core":40,"../internals/function-bind-context":65,"../internals/get-iterator-method":67,"../internals/is-array-iterator-method":78,"../internals/to-length":115,"../internals/to-object":116}],124:[function(e,t,r){var n=0,a=Math.random();t.exports=function(e){return"Symbol("+String(void 0===e?"":e)+")_"+(++n+a).toString(36)}},{}],125:[function(e,t,r){var n=e("../internals/native-symbol");t.exports=n&&!Symbol.sham&&"symbol"==typeof Symbol.iterator},{"../internals/native-symbol":85}],126:[function(e,t,r){var n=e("../internals/global"),a=e("../internals/shared"),o=e("../internals/has"),i=e("../internals/uid"),s=e("../internals/native-symbol"),l=e("../internals/use-symbol-as-uid"),u=a("wks"),c=n.Symbol,d=l?c:c&&c.withoutSetter||i;t.exports=function(e){return o(u,e)||(s&&o(c,e)?u[e]=c[e]:u[e]=d("Symbol."+e)),u[e]}},{"../internals/global":68,"../internals/has":69,"../internals/native-symbol":85,"../internals/shared":109,"../internals/uid":124,"../internals/use-symbol-as-uid":125}],127:[function(e,t,r){"use strict";var n=e("../internals/to-indexed-object"),a=e("../internals/add-to-unscopables"),o=e("../internals/iterators"),i=e("../internals/internal-state"),s=e("../internals/define-iterator"),l="Array Iterator",u=i.set,c=i.getterFor(l);t.exports=s(Array,"Array",function(e,t){u(this,{type:l,target:n(e),index:0,kind:t})},function(){var e=c(this),t=e.target,r=e.kind,n=e.index++;return!t||n>=t.length?{value:e.target=void 0,done:!0}:"keys"==r?{value:n,done:!1}:"values"==r?{value:t[n],done:!1}:{value:[n,t[n]],done:!1}},"values"),o.Arguments=o.Array,a("keys"),a("values"),a("entries")},{"../internals/add-to-unscopables":36,"../internals/define-iterator":59,"../internals/internal-state":77,"../internals/iterators":84,"../internals/to-indexed-object":113}],128:[function(e,t,r){var n=e("../internals/to-string-tag-support"),a=e("../internals/redefine"),o=e("../internals/object-to-string");n||a(Object.prototype,"toString",o,{unsafe:!0})},{"../internals/object-to-string":98,"../internals/redefine":102,"../internals/to-string-tag-support":120}],129:[function(e,t,r){"use strict";var n=e("../internals/array-buffer-view-core"),a=e("../internals/array-copy-within"),o=n.aTypedArray;(0,n.exportTypedArrayMethod)("copyWithin",function(e,t,r){return a.call(o(this),e,t,2<arguments.length?r:void 0)})},{"../internals/array-buffer-view-core":40,"../internals/array-copy-within":42}],130:[function(e,t,r){"use strict";var n=e("../internals/array-buffer-view-core"),a=e("../internals/array-iteration").every,o=n.aTypedArray;(0,n.exportTypedArrayMethod)("every",function(e,t){return a(o(this),e,1<arguments.length?t:void 0)})},{"../internals/array-buffer-view-core":40,"../internals/array-iteration":45}],131:[function(e,t,r){"use strict";var n=e("../internals/array-buffer-view-core"),a=e("../internals/array-fill"),o=n.aTypedArray;(0,n.exportTypedArrayMethod)("fill",function(e){return a.apply(o(this),arguments)})},{"../internals/array-buffer-view-core":40,"../internals/array-fill":43}],132:[function(e,t,r){"use strict";var n=e("../internals/array-buffer-view-core"),a=e("../internals/array-iteration").filter,o=e("../internals/species-constructor"),i=n.aTypedArray,s=n.aTypedArrayConstructor;(0,n.exportTypedArrayMethod)("filter",function(e,t){for(var r=a(i(this),e,1<arguments.length?t:void 0),n=o(this,this.constructor),l=0,u=r.length,c=new(s(n))(u);l<u;)c[l]=r[l++];return c})},{"../internals/array-buffer-view-core":40,"../internals/array-iteration":45,"../internals/species-constructor":110}],133:[function(e,t,r){"use strict";var n=e("../internals/array-buffer-view-core"),a=e("../internals/array-iteration").findIndex,o=n.aTypedArray;(0,n.exportTypedArrayMethod)("findIndex",function(e,t){return a(o(this),e,1<arguments.length?t:void 0)})},{"../internals/array-buffer-view-core":40,"../internals/array-iteration":45}],134:[function(e,t,r){"use strict";var n=e("../internals/array-buffer-view-core"),a=e("../internals/array-iteration").find,o=n.aTypedArray;(0,n.exportTypedArrayMethod)("find",function(e,t){return a(o(this),e,1<arguments.length?t:void 0)})},{"../internals/array-buffer-view-core":40,"../internals/array-iteration":45}],135:[function(e,t,r){"use strict";var n=e("../internals/array-buffer-view-core"),a=e("../internals/array-iteration").forEach,o=n.aTypedArray;(0,n.exportTypedArrayMethod)("forEach",function(e,t){a(o(this),e,1<arguments.length?t:void 0)})},{"../internals/array-buffer-view-core":40,"../internals/array-iteration":45}],136:[function(e,t,r){"use strict";var n=e("../internals/typed-array-constructors-require-wrappers");(0,e("../internals/array-buffer-view-core").exportTypedArrayStaticMethod)("from",e("../internals/typed-array-from"),n)},{"../internals/array-buffer-view-core":40,"../internals/typed-array-constructors-require-wrappers":122,"../internals/typed-array-from":123}],137:[function(e,t,r){"use strict";var n=e("../internals/array-buffer-view-core"),a=e("../internals/array-includes").includes,o=n.aTypedArray;(0,n.exportTypedArrayMethod)("includes",function(e,t){return a(o(this),e,1<arguments.length?t:void 0)})},{"../internals/array-buffer-view-core":40,"../internals/array-includes":44}],138:[function(e,t,r){"use strict";var n=e("../internals/array-buffer-view-core"),a=e("../internals/array-includes").indexOf,o=n.aTypedArray;(0,n.exportTypedArrayMethod)("indexOf",function(e,t){return a(o(this),e,1<arguments.length?t:void 0)})},{"../internals/array-buffer-view-core":40,"../internals/array-includes":44}],139:[function(e,t,r){"use strict";function n(){return u.call(p(this))}var a=e("../internals/global"),o=e("../internals/array-buffer-view-core"),i=e("../modules/es.array.iterator"),s=e("../internals/well-known-symbol")("iterator"),l=a.Uint8Array,u=i.values,c=i.keys,d=i.entries,p=o.aTypedArray,m=o.exportTypedArrayMethod,f=l&&l.prototype[s],h=!!f&&("values"==f.name||null==f.name);m("entries",function(){return d.call(p(this))}),m("keys",function(){return c.call(p(this))}),m("values",n,!h),m(s,n,!h)},{"../internals/array-buffer-view-core":40,"../internals/global":68,"../internals/well-known-symbol":126,"../modules/es.array.iterator":127}],140:[function(e,t,r){"use strict";var n=e("../internals/array-buffer-view-core"),a=n.aTypedArray,o=n.exportTypedArrayMethod,i=[].join;o("join",function(e){return i.apply(a(this),arguments)})},{"../internals/array-buffer-view-core":40}],141:[function(e,t,r){"use strict";var n=e("../internals/array-buffer-view-core"),a=e("../internals/array-last-index-of"),o=n.aTypedArray;(0,n.exportTypedArrayMethod)("lastIndexOf",function(e){return a.apply(o(this),arguments)})},{"../internals/array-buffer-view-core":40,"../internals/array-last-index-of":46}],142:[function(e,t,r){"use strict";var n=e("../internals/array-buffer-view-core"),a=e("../internals/array-iteration").map,o=e("../internals/species-constructor"),i=n.aTypedArray,s=n.aTypedArrayConstructor;(0,n.exportTypedArrayMethod)("map",function(e,t){return a(i(this),e,1<arguments.length?t:void 0,function(e,t){return new(s(o(e,e.constructor)))(t)})})},{"../internals/array-buffer-view-core":40,"../internals/array-iteration":45,"../internals/species-constructor":110}],143:[function(e,t,r){"use strict";var n=e("../internals/array-buffer-view-core"),a=e("../internals/typed-array-constructors-require-wrappers"),o=n.aTypedArrayConstructor;(0,n.exportTypedArrayStaticMethod)("of",function(){for(var e=0,t=arguments.length,r=new(o(this))(t);e<t;)r[e]=arguments[e++];return r},a)},{"../internals/array-buffer-view-core":40,"../internals/typed-array-constructors-require-wrappers":122}],144:[function(e,t,r){"use strict";var n=e("../internals/array-buffer-view-core"),a=e("../internals/array-reduce").right,o=n.aTypedArray;(0,n.exportTypedArrayMethod)("reduceRight",function(e,t){return a(o(this),e,arguments.length,1<arguments.length?t:void 0)})},{"../internals/array-buffer-view-core":40,"../internals/array-reduce":49}],145:[function(e,t,r){"use strict";var n=e("../internals/array-buffer-view-core"),a=e("../internals/array-reduce").left,o=n.aTypedArray;(0,n.exportTypedArrayMethod)("reduce",function(e,t){return a(o(this),e,arguments.length,1<arguments.length?t:void 0)})},{"../internals/array-buffer-view-core":40,"../internals/array-reduce":49}],146:[function(e,t,r){"use strict";var n=e("../internals/array-buffer-view-core"),a=n.aTypedArray,o=n.exportTypedArrayMethod,i=Math.floor;o("reverse",function(){for(var e,t=this,r=a(t).length,n=i(r/2),o=0;o<n;)e=t[o],t[o++]=t[--r],t[r]=e;return t})},{"../internals/array-buffer-view-core":40}],147:[function(e,t,r){"use strict";var n=e("../internals/array-buffer-view-core"),a=e("../internals/to-length"),o=e("../internals/to-offset"),i=e("../internals/to-object"),s=e("../internals/fails"),l=n.aTypedArray;(0,n.exportTypedArrayMethod)("set",function(e,t){l(this);var r=o(1<arguments.length?t:void 0,1),n=this.length,s=i(e),u=a(s.length),c=0;if(n<u+r)throw RangeError("Wrong length");for(;c<u;)this[r+c]=s[c++]},s(function(){new Int8Array(1).set({})}))},{"../internals/array-buffer-view-core":40,"../internals/fails":64,"../internals/to-length":115,"../internals/to-object":116,"../internals/to-offset":117}],148:[function(e,t,r){"use strict";var n=e("../internals/array-buffer-view-core"),a=e("../internals/species-constructor"),o=e("../internals/fails"),i=n.aTypedArray,s=n.aTypedArrayConstructor,l=n.exportTypedArrayMethod,u=[].slice;l("slice",function(e,t){for(var r=u.call(i(this),e,t),n=a(this,this.constructor),o=0,l=r.length,c=new(s(n))(l);o<l;)c[o]=r[o++];return c},o(function(){new Int8Array(1).slice()}))},{"../internals/array-buffer-view-core":40,"../internals/fails":64,"../internals/species-constructor":110}],149:[function(e,t,r){"use strict";var n=e("../internals/array-buffer-view-core"),a=e("../internals/array-iteration").some,o=n.aTypedArray;(0,n.exportTypedArrayMethod)("some",function(e,t){return a(o(this),e,1<arguments.length?t:void 0)})},{"../internals/array-buffer-view-core":40,"../internals/array-iteration":45}],150:[function(e,t,r){"use strict";var n=e("../internals/array-buffer-view-core"),a=n.aTypedArray,o=n.exportTypedArrayMethod,i=[].sort;o("sort",function(e){return i.call(a(this),e)})},{"../internals/array-buffer-view-core":40}],151:[function(e,t,r){"use strict";var n=e("../internals/array-buffer-view-core"),a=e("../internals/to-length"),o=e("../internals/to-absolute-index"),i=e("../internals/species-constructor"),s=n.aTypedArray;(0,n.exportTypedArrayMethod)("subarray",function(e,t){var r=s(this),n=r.length,l=o(e,n);return new(i(r,r.constructor))(r.buffer,r.byteOffset+l*r.BYTES_PER_ELEMENT,a((void 0===t?n:o(t,n))-l))})},{"../internals/array-buffer-view-core":40,"../internals/species-constructor":110,"../internals/to-absolute-index":111,"../internals/to-length":115}],152:[function(e,t,r){"use strict";var n=e("../internals/global"),a=e("../internals/array-buffer-view-core"),o=e("../internals/fails"),i=n.Int8Array,s=a.aTypedArray,l=a.exportTypedArrayMethod,u=[].toLocaleString,c=[].slice,d=!!i&&o(function(){u.call(new i(1))});l("toLocaleString",function(){return u.apply(d?c.call(s(this)):s(this),arguments)},o(function(){return[1,2].toLocaleString()!=new i([1,2]).toLocaleString()})||!o(function(){i.prototype.toLocaleString.call([1,2])}))},{"../internals/array-buffer-view-core":40,"../internals/fails":64,"../internals/global":68}],153:[function(e,t,r){"use strict";var n=e("../internals/array-buffer-view-core").exportTypedArrayMethod,a=e("../internals/fails"),o=e("../internals/global").Uint8Array,i=o&&o.prototype||{},s=[].toString,l=[].join;a(function(){s.call({})})&&(s=function(){return l.call(this)}),n("toString",s,i.toString!=s)},{"../internals/array-buffer-view-core":40,"../internals/fails":64,"../internals/global":68}],154:[function(e,t,r){e("../internals/typed-array-constructor")("Uint32",function(e){return function(t,r,n){return e(this,t,r,n)}})},{"../internals/typed-array-constructor":121}],155:[function(e,t,r){t.exports={CssSelectorParser:e("./lib/css-selector-parser.js").CssSelectorParser}},{"./lib/css-selector-parser.js":156}],156:[function(e,t,r){function n(){this.pseudos={},this.attrEqualityMods={},this.ruleNestingOperators={},this.substitutesEnabled=!1}function a(e){return"a"<=e&&e<="f"||"A"<=e&&e<="F"||"0"<=e&&e<="9"}n.prototype.registerSelectorPseudos=function(e){for(var t=0,r=arguments.length;t<r;t++)e=arguments[t],this.pseudos[e]="selector";return this},n.prototype.unregisterSelectorPseudos=function(e){for(var t=0,r=arguments.length;t<r;t++)e=arguments[t],delete this.pseudos[e];return this},n.prototype.registerNumericPseudos=function(e){for(var t=0,r=arguments.length;t<r;t++)e=arguments[t],this.pseudos[e]="numeric";return this},n.prototype.unregisterNumericPseudos=function(e){for(var t=0,r=arguments.length;t<r;t++)e=arguments[t],delete this.pseudos[e];return this},n.prototype.registerNestingOperators=function(e){for(var t=0,r=arguments.length;t<r;t++)e=arguments[t],this.ruleNestingOperators[e]=!0;return this},n.prototype.unregisterNestingOperators=function(e){for(var t=0,r=arguments.length;t<r;t++)e=arguments[t],delete this.ruleNestingOperators[e];return this},n.prototype.registerAttrEqualityMods=function(e){for(var t=0,r=arguments.length;t<r;t++)e=arguments[t],this.attrEqualityMods[e]=!0;return this},n.prototype.unregisterAttrEqualityMods=function(e){for(var t=0,r=arguments.length;t<r;t++)e=arguments[t],delete this.attrEqualityMods[e];return this},n.prototype.enableSubstitutes=function(){return this.substitutesEnabled=!0,this},n.prototype.disableSubstitutes=function(){return this.substitutesEnabled=!1,this};var o={"!":!0,\'"\':!0,"#":!0,$:!0,"%":!0,"&":!0,"\'":!0,"(":!0,")":!0,"*":!0,"+":!0,",":!0,".":!0,"/":!0,";":!0,"<":!0,"=":!0,">":!0,"?":!0,"@":!0,"[":!0,"\\\\":!0,"]":!0,"^":!0,"`":!0,"{":!0,"|":!0,"}":!0,"~":!0},i={"\\n":"\\\\n","\\r":"\\\\r","\\t":"\\\\t","\\f":"\\\\f","\\v":"\\\\v"},s={n:"\\n",r:"\\r",t:"\\t",f:"\\f","\\\\":"\\\\","\'":"\'"},l={n:"\\n",r:"\\r",t:"\\t",f:"\\f","\\\\":"\\\\",\'"\':\'"\'};function u(e,t,r,n,i,u){var c,d,p,m,f;return m=e.length,c=null,p=function(r,n){var o,i,s;for(s="",t++,c=e.charAt(t);t<m;){if(c===r)return t++,s;if("\\\\"===c)if(t++,(c=e.charAt(t))===r)s+=r;else if(o=n[c])s+=o;else{if(a(c)){for(i=c,t++,c=e.charAt(t);a(c);)i+=c,t++,c=e.charAt(t);" "===c&&(t++,c=e.charAt(t)),s+=String.fromCharCode(parseInt(i,16));continue}s+=c}else s+=c;t++,c=e.charAt(t)}return s},d=function(){var r,n="";for(c=e.charAt(t);t<m;){if("a"<=(r=c)&&r<="z"||"A"<=r&&r<="Z"||"0"<=r&&r<="9"||"-"===r||"_"===r)n+=c;else{if("\\\\"!==c)return n;if(m<=++t)throw Error("Expected symbol but end of file reached.");if(c=e.charAt(t),o[c])n+=c;else{if(a(c)){var i=c;for(t++,c=e.charAt(t);a(c);)i+=c,t++,c=e.charAt(t);" "===c&&(t++,c=e.charAt(t)),n+=String.fromCharCode(parseInt(i,16));continue}n+=c}}t++,c=e.charAt(t)}return n},f=function(){c=e.charAt(t);for(var r=!1;" "===c||"\\t"===c||"\\n"===c||"\\r"===c||"\\f"===c;)r=!0,t++,c=e.charAt(t);return r},this.parse=function(){var r=this.parseSelector();if(t<m)throw Error(\'Rule expected but "\'+e.charAt(t)+\'" found.\');return r},this.parseSelector=function(){var r,n=r=this.parseSingleSelector();for(c=e.charAt(t);","===c;){if(t++,f(),"selectors"!==r.type&&(r={type:"selectors",selectors:[n]}),!(n=this.parseSingleSelector()))throw Error(\'Rule expected after ",".\');r.selectors.push(n)}return r},this.parseSingleSelector=function(){f();var r={type:"ruleSet"},n=this.parseRule();if(!n)return null;for(var a=r;n&&(n.type="rule",a.rule=n,a=n,f(),c=e.charAt(t),!(m<=t||","===c||")"===c));)if(i[c]){var o=c;if(t++,f(),!(n=this.parseRule()))throw Error(\'Rule expected after "\'+o+\'".\');n.nestingOperator=o}else(n=this.parseRule())&&(n.nestingOperator=null);return r},this.parseRule=function(){for(var a,o=null;t<m;)if("*"===(c=e.charAt(t)))t++,(o=o||{}).tagName="*";else if("a"<=(a=c)&&a<="z"||"A"<=a&&a<="Z"||"-"===a||"_"===a||"\\\\"===c)(o=o||{}).tagName=d();else if("."===c)t++,((o=o||{}).classNames=o.classNames||[]).push(d());else if("#"===c)t++,(o=o||{}).id=d();else if("["===c){t++,f();var i={name:d()};if(f(),"]"===c)t++;else{var h="";if(n[c]&&(h=c,t++,c=e.charAt(t)),m<=t)throw Error(\'Expected "=" but end of file reached.\');if("="!==c)throw Error(\'Expected "=" but "\'+c+\'" found.\');i.operator=h+"=",t++,f();var b="";if(i.valueType="string",\'"\'===c)b=p(\'"\',l);else if("\'"===c)b=p("\'",s);else if(u&&"$"===c)t++,b=d(),i.valueType="substitute";else{for(;t<m&&"]"!==c;)b+=c,t++,c=e.charAt(t);b=b.trim()}if(f(),m<=t)throw Error(\'Expected "]" but end of file reached.\');if("]"!==c)throw Error(\'Expected "]" but "\'+c+\'" found.\');t++,i.value=b}((o=o||{}).attrs=o.attrs||[]).push(i)}else{if(":"!==c)break;t++;var g=d(),y={name:g};if("("===c){t++;var v="";if(f(),"selector"===r[g])y.valueType="selector",v=this.parseSelector();else{if(y.valueType=r[g]||"string",\'"\'===c)v=p(\'"\',l);else if("\'"===c)v=p("\'",s);else if(u&&"$"===c)t++,v=d(),y.valueType="substitute";else{for(;t<m&&")"!==c;)v+=c,t++,c=e.charAt(t);v=v.trim()}f()}if(m<=t)throw Error(\'Expected ")" but end of file reached.\');if(")"!==c)throw Error(\'Expected ")" but "\'+c+\'" found.\');t++,y.value=v}((o=o||{}).pseudos=o.pseudos||[]).push(y)}return o},this}n.prototype.parse=function(e){return new u(e,0,this.pseudos,this.attrEqualityMods,this.ruleNestingOperators,this.substitutesEnabled).parse()},n.prototype.escapeIdentifier=function(e){for(var t="",r=0,n=e.length;r<n;){var a=e.charAt(r);if(o[a])t+="\\\\"+a;else if("_"===a||"-"===a||"A"<=a&&a<="Z"||"a"<=a&&a<="z"||0!==r&&"0"<=a&&a<="9")t+=a;else{var i=a.charCodeAt(0);if(55296==(63488&i)){var s=e.charCodeAt(r++);if(55296!=(64512&i)||56320!=(64512&s))throw Error("UCS-2(decode): illegal sequence");i=((1023&i)<<10)+(1023&s)+65536}t+="\\\\"+i.toString(16)+" "}r++}return t},n.prototype.escapeStr=function(e){for(var t,r,n="",a=0,o=e.length;a<o;)\'"\'===(t=e.charAt(a))?t=\'\\\\"\':"\\\\"===t?t="\\\\\\\\":(r=i[t])&&(t=r),n+=t,a++;return\'"\'+n+\'"\'},n.prototype.render=function(e){return this._renderEntity(e).trim()},n.prototype._renderEntity=function(e){var t,r,n;switch(n="",e.type){case"ruleSet":for(t=e.rule,r=[];t;)t.nestingOperator&&r.push(t.nestingOperator),r.push(this._renderEntity(t)),t=t.rule;n=r.join(" ");break;case"selectors":n=e.selectors.map(this._renderEntity,this).join(", ");break;case"rule":e.tagName&&(n="*"===e.tagName?"*":this.escapeIdentifier(e.tagName)),e.id&&(n+="#"+this.escapeIdentifier(e.id)),e.classNames&&(n+=e.classNames.map(function(e){return"."+this.escapeIdentifier(e)},this).join("")),e.attrs&&(n+=e.attrs.map(function(e){return e.operator?"substitute"===e.valueType?"["+this.escapeIdentifier(e.name)+e.operator+"$"+e.value+"]":"["+this.escapeIdentifier(e.name)+e.operator+this.escapeStr(e.value)+"]":"["+this.escapeIdentifier(e.name)+"]"},this).join("")),e.pseudos&&(n+=e.pseudos.map(function(e){return e.valueType?"selector"===e.valueType?":"+this.escapeIdentifier(e.name)+"("+this._renderEntity(e.value)+")":"substitute"===e.valueType?":"+this.escapeIdentifier(e.name)+"($"+e.value+")":"numeric"===e.valueType?":"+this.escapeIdentifier(e.name)+"("+e.value+")":":"+this.escapeIdentifier(e.name)+"("+this.escapeIdentifier(e.value)+")":":"+this.escapeIdentifier(e.name)},this).join(""));break;default:throw Error(\'Unknown entity type: "\'+e.type(NaN))}return n},r.CssSelectorParser=n},{}],157:[function(e,t,r){"use strict";var n=e("type/value/is"),a=e("type/plain-function/is"),o=e("es5-ext/object/assign"),i=e("es5-ext/object/normalize-options"),s=e("es5-ext/string/#/contains");(t.exports=function(e,t){var r,a,l,u,c;return arguments.length<2||"string"!=typeof e?(u=t,t=e,e=null):u=arguments[2],n(e)?(r=s.call(e,"c"),a=s.call(e,"e"),l=s.call(e,"w")):(r=l=!0,a=!1),c={value:t,configurable:r,enumerable:a,writable:l},u?o(i(u),c):c}).gs=function(e,t,r){var l,u,c,d;return"string"!=typeof e?(c=r,r=t,t=e,e=null):c=arguments[3],n(t)?a(t)?n(r)?a(r)||(c=r,r=void 0):r=void 0:(c=t,t=r=void 0):t=void 0,u=n(e)?(l=s.call(e,"c"),s.call(e,"e")):!(l=!0),d={get:t,set:r,configurable:l,enumerable:u},c?o(i(c),d):d}},{"es5-ext/object/assign":178,"es5-ext/object/normalize-options":190,"es5-ext/string/#/contains":197,"type/plain-function/is":242,"type/value/is":244}],158:[function(e,t,r){"use strict";t.exports=function(){return/\\uD83C\\uDFF4\\uDB40\\uDC67\\uDB40\\uDC62(?:\\uDB40\\uDC65\\uDB40\\uDC6E\\uDB40\\uDC67|\\uDB40\\uDC73\\uDB40\\uDC63\\uDB40\\uDC74|\\uDB40\\uDC77\\uDB40\\uDC6C\\uDB40\\uDC73)\\uDB40\\uDC7F|\\uD83D\\uDC68(?:\\uD83C\\uDFFC\\u200D(?:\\uD83E\\uDD1D\\u200D\\uD83D\\uDC68\\uD83C\\uDFFB|\\uD83C[\\uDF3E\\uDF73\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD])|\\uD83C\\uDFFF\\u200D(?:\\uD83E\\uDD1D\\u200D\\uD83D\\uDC68(?:\\uD83C[\\uDFFB-\\uDFFE])|\\uD83C[\\uDF3E\\uDF73\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD])|\\uD83C\\uDFFE\\u200D(?:\\uD83E\\uDD1D\\u200D\\uD83D\\uDC68(?:\\uD83C[\\uDFFB-\\uDFFD])|\\uD83C[\\uDF3E\\uDF73\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD])|\\uD83C\\uDFFD\\u200D(?:\\uD83E\\uDD1D\\u200D\\uD83D\\uDC68(?:\\uD83C[\\uDFFB\\uDFFC])|\\uD83C[\\uDF3E\\uDF73\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD])|\\u200D(?:\\u2764\\uFE0F\\u200D(?:\\uD83D\\uDC8B\\u200D)?\\uD83D\\uDC68|(?:\\uD83D[\\uDC68\\uDC69])\\u200D(?:\\uD83D\\uDC66\\u200D\\uD83D\\uDC66|\\uD83D\\uDC67\\u200D(?:\\uD83D[\\uDC66\\uDC67]))|\\uD83D\\uDC66\\u200D\\uD83D\\uDC66|\\uD83D\\uDC67\\u200D(?:\\uD83D[\\uDC66\\uDC67])|(?:\\uD83D[\\uDC68\\uDC69])\\u200D(?:\\uD83D[\\uDC66\\uDC67])|[\\u2695\\u2696\\u2708]\\uFE0F|\\uD83D[\\uDC66\\uDC67]|\\uD83C[\\uDF3E\\uDF73\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD])|(?:\\uD83C\\uDFFB\\u200D[\\u2695\\u2696\\u2708]|\\uD83C\\uDFFF\\u200D[\\u2695\\u2696\\u2708]|\\uD83C\\uDFFE\\u200D[\\u2695\\u2696\\u2708]|\\uD83C\\uDFFD\\u200D[\\u2695\\u2696\\u2708]|\\uD83C\\uDFFC\\u200D[\\u2695\\u2696\\u2708])\\uFE0F|\\uD83C\\uDFFB\\u200D(?:\\uD83C[\\uDF3E\\uDF73\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD])|\\uD83C[\\uDFFB-\\uDFFF])|(?:\\uD83E\\uDDD1\\uD83C\\uDFFB\\u200D\\uD83E\\uDD1D\\u200D\\uD83E\\uDDD1|\\uD83D\\uDC69\\uD83C\\uDFFC\\u200D\\uD83E\\uDD1D\\u200D\\uD83D\\uDC69)\\uD83C\\uDFFB|\\uD83E\\uDDD1(?:\\uD83C\\uDFFF\\u200D\\uD83E\\uDD1D\\u200D\\uD83E\\uDDD1(?:\\uD83C[\\uDFFB-\\uDFFF])|\\u200D\\uD83E\\uDD1D\\u200D\\uD83E\\uDDD1)|(?:\\uD83E\\uDDD1\\uD83C\\uDFFE\\u200D\\uD83E\\uDD1D\\u200D\\uD83E\\uDDD1|\\uD83D\\uDC69\\uD83C\\uDFFF\\u200D\\uD83E\\uDD1D\\u200D(?:\\uD83D[\\uDC68\\uDC69]))(?:\\uD83C[\\uDFFB-\\uDFFE])|(?:\\uD83E\\uDDD1\\uD83C\\uDFFC\\u200D\\uD83E\\uDD1D\\u200D\\uD83E\\uDDD1|\\uD83D\\uDC69\\uD83C\\uDFFD\\u200D\\uD83E\\uDD1D\\u200D\\uD83D\\uDC69)(?:\\uD83C[\\uDFFB\\uDFFC])|\\uD83D\\uDC69(?:\\uD83C\\uDFFE\\u200D(?:\\uD83E\\uDD1D\\u200D\\uD83D\\uDC68(?:\\uD83C[\\uDFFB-\\uDFFD\\uDFFF])|\\uD83C[\\uDF3E\\uDF73\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD])|\\uD83C\\uDFFC\\u200D(?:\\uD83E\\uDD1D\\u200D\\uD83D\\uDC68(?:\\uD83C[\\uDFFB\\uDFFD-\\uDFFF])|\\uD83C[\\uDF3E\\uDF73\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD])|\\uD83C\\uDFFB\\u200D(?:\\uD83E\\uDD1D\\u200D\\uD83D\\uDC68(?:\\uD83C[\\uDFFC-\\uDFFF])|\\uD83C[\\uDF3E\\uDF73\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD])|\\uD83C\\uDFFD\\u200D(?:\\uD83E\\uDD1D\\u200D\\uD83D\\uDC68(?:\\uD83C[\\uDFFB\\uDFFC\\uDFFE\\uDFFF])|\\uD83C[\\uDF3E\\uDF73\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD])|\\u200D(?:\\u2764\\uFE0F\\u200D(?:\\uD83D\\uDC8B\\u200D(?:\\uD83D[\\uDC68\\uDC69])|\\uD83D[\\uDC68\\uDC69])|\\uD83C[\\uDF3E\\uDF73\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD])|\\uD83C\\uDFFF\\u200D(?:\\uD83C[\\uDF3E\\uDF73\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]))|\\uD83D\\uDC69\\u200D\\uD83D\\uDC69\\u200D(?:\\uD83D\\uDC66\\u200D\\uD83D\\uDC66|\\uD83D\\uDC67\\u200D(?:\\uD83D[\\uDC66\\uDC67]))|(?:\\uD83E\\uDDD1\\uD83C\\uDFFD\\u200D\\uD83E\\uDD1D\\u200D\\uD83E\\uDDD1|\\uD83D\\uDC69\\uD83C\\uDFFE\\u200D\\uD83E\\uDD1D\\u200D\\uD83D\\uDC69)(?:\\uD83C[\\uDFFB-\\uDFFD])|\\uD83D\\uDC69\\u200D\\uD83D\\uDC66\\u200D\\uD83D\\uDC66|\\uD83D\\uDC69\\u200D\\uD83D\\uDC69\\u200D(?:\\uD83D[\\uDC66\\uDC67])|(?:\\uD83D\\uDC41\\uFE0F\\u200D\\uD83D\\uDDE8|\\uD83D\\uDC69(?:\\uD83C\\uDFFF\\u200D[\\u2695\\u2696\\u2708]|\\uD83C\\uDFFE\\u200D[\\u2695\\u2696\\u2708]|\\uD83C\\uDFFC\\u200D[\\u2695\\u2696\\u2708]|\\uD83C\\uDFFB\\u200D[\\u2695\\u2696\\u2708]|\\uD83C\\uDFFD\\u200D[\\u2695\\u2696\\u2708]|\\u200D[\\u2695\\u2696\\u2708])|(?:(?:\\u26F9|\\uD83C[\\uDFCB\\uDFCC]|\\uD83D\\uDD75)\\uFE0F|\\uD83D\\uDC6F|\\uD83E[\\uDD3C\\uDDDE\\uDDDF])\\u200D[\\u2640\\u2642]|(?:\\u26F9|\\uD83C[\\uDFCB\\uDFCC]|\\uD83D\\uDD75)(?:\\uD83C[\\uDFFB-\\uDFFF])\\u200D[\\u2640\\u2642]|(?:\\uD83C[\\uDFC3\\uDFC4\\uDFCA]|\\uD83D[\\uDC6E\\uDC71\\uDC73\\uDC77\\uDC81\\uDC82\\uDC86\\uDC87\\uDE45-\\uDE47\\uDE4B\\uDE4D\\uDE4E\\uDEA3\\uDEB4-\\uDEB6]|\\uD83E[\\uDD26\\uDD37-\\uDD39\\uDD3D\\uDD3E\\uDDB8\\uDDB9\\uDDCD-\\uDDCF\\uDDD6-\\uDDDD])(?:(?:\\uD83C[\\uDFFB-\\uDFFF])\\u200D[\\u2640\\u2642]|\\u200D[\\u2640\\u2642])|\\uD83C\\uDFF4\\u200D\\u2620)\\uFE0F|\\uD83D\\uDC69\\u200D\\uD83D\\uDC67\\u200D(?:\\uD83D[\\uDC66\\uDC67])|\\uD83C\\uDFF3\\uFE0F\\u200D\\uD83C\\uDF08|\\uD83D\\uDC15\\u200D\\uD83E\\uDDBA|\\uD83D\\uDC69\\u200D\\uD83D\\uDC66|\\uD83D\\uDC69\\u200D\\uD83D\\uDC67|\\uD83C\\uDDFD\\uD83C\\uDDF0|\\uD83C\\uDDF4\\uD83C\\uDDF2|\\uD83C\\uDDF6\\uD83C\\uDDE6|[#\\*0-9]\\uFE0F\\u20E3|\\uD83C\\uDDE7(?:\\uD83C[\\uDDE6\\uDDE7\\uDDE9-\\uDDEF\\uDDF1-\\uDDF4\\uDDF6-\\uDDF9\\uDDFB\\uDDFC\\uDDFE\\uDDFF])|\\uD83C\\uDDF9(?:\\uD83C[\\uDDE6\\uDDE8\\uDDE9\\uDDEB-\\uDDED\\uDDEF-\\uDDF4\\uDDF7\\uDDF9\\uDDFB\\uDDFC\\uDDFF])|\\uD83C\\uDDEA(?:\\uD83C[\\uDDE6\\uDDE8\\uDDEA\\uDDEC\\uDDED\\uDDF7-\\uDDFA])|\\uD83E\\uDDD1(?:\\uD83C[\\uDFFB-\\uDFFF])|\\uD83C\\uDDF7(?:\\uD83C[\\uDDEA\\uDDF4\\uDDF8\\uDDFA\\uDDFC])|\\uD83D\\uDC69(?:\\uD83C[\\uDFFB-\\uDFFF])|\\uD83C\\uDDF2(?:\\uD83C[\\uDDE6\\uDDE8-\\uDDED\\uDDF0-\\uDDFF])|\\uD83C\\uDDE6(?:\\uD83C[\\uDDE8-\\uDDEC\\uDDEE\\uDDF1\\uDDF2\\uDDF4\\uDDF6-\\uDDFA\\uDDFC\\uDDFD\\uDDFF])|\\uD83C\\uDDF0(?:\\uD83C[\\uDDEA\\uDDEC-\\uDDEE\\uDDF2\\uDDF3\\uDDF5\\uDDF7\\uDDFC\\uDDFE\\uDDFF])|\\uD83C\\uDDED(?:\\uD83C[\\uDDF0\\uDDF2\\uDDF3\\uDDF7\\uDDF9\\uDDFA])|\\uD83C\\uDDE9(?:\\uD83C[\\uDDEA\\uDDEC\\uDDEF\\uDDF0\\uDDF2\\uDDF4\\uDDFF])|\\uD83C\\uDDFE(?:\\uD83C[\\uDDEA\\uDDF9])|\\uD83C\\uDDEC(?:\\uD83C[\\uDDE6\\uDDE7\\uDDE9-\\uDDEE\\uDDF1-\\uDDF3\\uDDF5-\\uDDFA\\uDDFC\\uDDFE])|\\uD83C\\uDDF8(?:\\uD83C[\\uDDE6-\\uDDEA\\uDDEC-\\uDDF4\\uDDF7-\\uDDF9\\uDDFB\\uDDFD-\\uDDFF])|\\uD83C\\uDDEB(?:\\uD83C[\\uDDEE-\\uDDF0\\uDDF2\\uDDF4\\uDDF7])|\\uD83C\\uDDF5(?:\\uD83C[\\uDDE6\\uDDEA-\\uDDED\\uDDF0-\\uDDF3\\uDDF7-\\uDDF9\\uDDFC\\uDDFE])|\\uD83C\\uDDFB(?:\\uD83C[\\uDDE6\\uDDE8\\uDDEA\\uDDEC\\uDDEE\\uDDF3\\uDDFA])|\\uD83C\\uDDF3(?:\\uD83C[\\uDDE6\\uDDE8\\uDDEA-\\uDDEC\\uDDEE\\uDDF1\\uDDF4\\uDDF5\\uDDF7\\uDDFA\\uDDFF])|\\uD83C\\uDDE8(?:\\uD83C[\\uDDE6\\uDDE8\\uDDE9\\uDDEB-\\uDDEE\\uDDF0-\\uDDF5\\uDDF7\\uDDFA-\\uDDFF])|\\uD83C\\uDDF1(?:\\uD83C[\\uDDE6-\\uDDE8\\uDDEE\\uDDF0\\uDDF7-\\uDDFB\\uDDFE])|\\uD83C\\uDDFF(?:\\uD83C[\\uDDE6\\uDDF2\\uDDFC])|\\uD83C\\uDDFC(?:\\uD83C[\\uDDEB\\uDDF8])|\\uD83C\\uDDFA(?:\\uD83C[\\uDDE6\\uDDEC\\uDDF2\\uDDF3\\uDDF8\\uDDFE\\uDDFF])|\\uD83C\\uDDEE(?:\\uD83C[\\uDDE8-\\uDDEA\\uDDF1-\\uDDF4\\uDDF6-\\uDDF9])|\\uD83C\\uDDEF(?:\\uD83C[\\uDDEA\\uDDF2\\uDDF4\\uDDF5])|(?:\\uD83C[\\uDFC3\\uDFC4\\uDFCA]|\\uD83D[\\uDC6E\\uDC71\\uDC73\\uDC77\\uDC81\\uDC82\\uDC86\\uDC87\\uDE45-\\uDE47\\uDE4B\\uDE4D\\uDE4E\\uDEA3\\uDEB4-\\uDEB6]|\\uD83E[\\uDD26\\uDD37-\\uDD39\\uDD3D\\uDD3E\\uDDB8\\uDDB9\\uDDCD-\\uDDCF\\uDDD6-\\uDDDD])(?:\\uD83C[\\uDFFB-\\uDFFF])|(?:\\u26F9|\\uD83C[\\uDFCB\\uDFCC]|\\uD83D\\uDD75)(?:\\uD83C[\\uDFFB-\\uDFFF])|(?:[\\u261D\\u270A-\\u270D]|\\uD83C[\\uDF85\\uDFC2\\uDFC7]|\\uD83D[\\uDC42\\uDC43\\uDC46-\\uDC50\\uDC66\\uDC67\\uDC6B-\\uDC6D\\uDC70\\uDC72\\uDC74-\\uDC76\\uDC78\\uDC7C\\uDC83\\uDC85\\uDCAA\\uDD74\\uDD7A\\uDD90\\uDD95\\uDD96\\uDE4C\\uDE4F\\uDEC0\\uDECC]|\\uD83E[\\uDD0F\\uDD18-\\uDD1C\\uDD1E\\uDD1F\\uDD30-\\uDD36\\uDDB5\\uDDB6\\uDDBB\\uDDD2-\\uDDD5])(?:\\uD83C[\\uDFFB-\\uDFFF])|(?:[\\u231A\\u231B\\u23E9-\\u23EC\\u23F0\\u23F3\\u25FD\\u25FE\\u2614\\u2615\\u2648-\\u2653\\u267F\\u2693\\u26A1\\u26AA\\u26AB\\u26BD\\u26BE\\u26C4\\u26C5\\u26CE\\u26D4\\u26EA\\u26F2\\u26F3\\u26F5\\u26FA\\u26FD\\u2705\\u270A\\u270B\\u2728\\u274C\\u274E\\u2753-\\u2755\\u2757\\u2795-\\u2797\\u27B0\\u27BF\\u2B1B\\u2B1C\\u2B50\\u2B55]|\\uD83C[\\uDC04\\uDCCF\\uDD8E\\uDD91-\\uDD9A\\uDDE6-\\uDDFF\\uDE01\\uDE1A\\uDE2F\\uDE32-\\uDE36\\uDE38-\\uDE3A\\uDE50\\uDE51\\uDF00-\\uDF20\\uDF2D-\\uDF35\\uDF37-\\uDF7C\\uDF7E-\\uDF93\\uDFA0-\\uDFCA\\uDFCF-\\uDFD3\\uDFE0-\\uDFF0\\uDFF4\\uDFF8-\\uDFFF]|\\uD83D[\\uDC00-\\uDC3E\\uDC40\\uDC42-\\uDCFC\\uDCFF-\\uDD3D\\uDD4B-\\uDD4E\\uDD50-\\uDD67\\uDD7A\\uDD95\\uDD96\\uDDA4\\uDDFB-\\uDE4F\\uDE80-\\uDEC5\\uDECC\\uDED0-\\uDED2\\uDED5\\uDEEB\\uDEEC\\uDEF4-\\uDEFA\\uDFE0-\\uDFEB]|\\uD83E[\\uDD0D-\\uDD3A\\uDD3C-\\uDD45\\uDD47-\\uDD71\\uDD73-\\uDD76\\uDD7A-\\uDDA2\\uDDA5-\\uDDAA\\uDDAE-\\uDDCA\\uDDCD-\\uDDFF\\uDE70-\\uDE73\\uDE78-\\uDE7A\\uDE80-\\uDE82\\uDE90-\\uDE95])|(?:[#\\*0-9\\xA9\\xAE\\u203C\\u2049\\u2122\\u2139\\u2194-\\u2199\\u21A9\\u21AA\\u231A\\u231B\\u2328\\u23CF\\u23E9-\\u23F3\\u23F8-\\u23FA\\u24C2\\u25AA\\u25AB\\u25B6\\u25C0\\u25FB-\\u25FE\\u2600-\\u2604\\u260E\\u2611\\u2614\\u2615\\u2618\\u261D\\u2620\\u2622\\u2623\\u2626\\u262A\\u262E\\u262F\\u2638-\\u263A\\u2640\\u2642\\u2648-\\u2653\\u265F\\u2660\\u2663\\u2665\\u2666\\u2668\\u267B\\u267E\\u267F\\u2692-\\u2697\\u2699\\u269B\\u269C\\u26A0\\u26A1\\u26AA\\u26AB\\u26B0\\u26B1\\u26BD\\u26BE\\u26C4\\u26C5\\u26C8\\u26CE\\u26CF\\u26D1\\u26D3\\u26D4\\u26E9\\u26EA\\u26F0-\\u26F5\\u26F7-\\u26FA\\u26FD\\u2702\\u2705\\u2708-\\u270D\\u270F\\u2712\\u2714\\u2716\\u271D\\u2721\\u2728\\u2733\\u2734\\u2744\\u2747\\u274C\\u274E\\u2753-\\u2755\\u2757\\u2763\\u2764\\u2795-\\u2797\\u27A1\\u27B0\\u27BF\\u2934\\u2935\\u2B05-\\u2B07\\u2B1B\\u2B1C\\u2B50\\u2B55\\u3030\\u303D\\u3297\\u3299]|\\uD83C[\\uDC04\\uDCCF\\uDD70\\uDD71\\uDD7E\\uDD7F\\uDD8E\\uDD91-\\uDD9A\\uDDE6-\\uDDFF\\uDE01\\uDE02\\uDE1A\\uDE2F\\uDE32-\\uDE3A\\uDE50\\uDE51\\uDF00-\\uDF21\\uDF24-\\uDF93\\uDF96\\uDF97\\uDF99-\\uDF9B\\uDF9E-\\uDFF0\\uDFF3-\\uDFF5\\uDFF7-\\uDFFF]|\\uD83D[\\uDC00-\\uDCFD\\uDCFF-\\uDD3D\\uDD49-\\uDD4E\\uDD50-\\uDD67\\uDD6F\\uDD70\\uDD73-\\uDD7A\\uDD87\\uDD8A-\\uDD8D\\uDD90\\uDD95\\uDD96\\uDDA4\\uDDA5\\uDDA8\\uDDB1\\uDDB2\\uDDBC\\uDDC2-\\uDDC4\\uDDD1-\\uDDD3\\uDDDC-\\uDDDE\\uDDE1\\uDDE3\\uDDE8\\uDDEF\\uDDF3\\uDDFA-\\uDE4F\\uDE80-\\uDEC5\\uDECB-\\uDED2\\uDED5\\uDEE0-\\uDEE5\\uDEE9\\uDEEB\\uDEEC\\uDEF0\\uDEF3-\\uDEFA\\uDFE0-\\uDFEB]|\\uD83E[\\uDD0D-\\uDD3A\\uDD3C-\\uDD45\\uDD47-\\uDD71\\uDD73-\\uDD76\\uDD7A-\\uDDA2\\uDDA5-\\uDDAA\\uDDAE-\\uDDCA\\uDDCD-\\uDDFF\\uDE70-\\uDE73\\uDE78-\\uDE7A\\uDE80-\\uDE82\\uDE90-\\uDE95])\\uFE0F|(?:[\\u261D\\u26F9\\u270A-\\u270D]|\\uD83C[\\uDF85\\uDFC2-\\uDFC4\\uDFC7\\uDFCA-\\uDFCC]|\\uD83D[\\uDC42\\uDC43\\uDC46-\\uDC50\\uDC66-\\uDC78\\uDC7C\\uDC81-\\uDC83\\uDC85-\\uDC87\\uDC8F\\uDC91\\uDCAA\\uDD74\\uDD75\\uDD7A\\uDD90\\uDD95\\uDD96\\uDE45-\\uDE47\\uDE4B-\\uDE4F\\uDEA3\\uDEB4-\\uDEB6\\uDEC0\\uDECC]|\\uD83E[\\uDD0F\\uDD18-\\uDD1F\\uDD26\\uDD30-\\uDD39\\uDD3C-\\uDD3E\\uDDB5\\uDDB6\\uDDB8\\uDDB9\\uDDBB\\uDDCD-\\uDDCF\\uDDD1-\\uDDDD])/g}},{}],159:[function(e,t,r){"use strict";var n=e("../../number/is-nan"),a=e("../../number/to-pos-integer"),o=e("../../object/valid-value"),i=Array.prototype.indexOf,s=Object.prototype.hasOwnProperty,l=Math.abs,u=Math.floor;t.exports=function(e){var t,r,c,d;if(!n(e))return i.apply(this,arguments);for(r=a(o(this).length),c=arguments[1],t=c=isNaN(c)?0:0<=c?u(c):a(this.length)-u(l(c));t<r;++t)if(s.call(this,t)&&(d=this[t],n(d)))return t;return-1}},{"../../number/is-nan":172,"../../number/to-pos-integer":176,"../../object/valid-value":193}],160:[function(e,t,r){"use strict";t.exports=e("./is-implemented")()?Array.from:e("./shim")},{"./is-implemented":161,"./shim":162}],161:[function(e,t,r){"use strict";t.exports=function(){var e,t,r=Array.from;return"function"==typeof r&&(t=r(e=["raz","dwa"]),Boolean(t&&t!==e&&"dwa"===t[1]))}},{}],162:[function(e,t,r){"use strict";var n=e("es6-symbol").iterator,a=e("../../function/is-arguments"),o=e("../../function/is-function"),i=e("../../number/to-pos-integer"),s=e("../../object/valid-callable"),l=e("../../object/valid-value"),u=e("../../object/is-value"),c=e("../../string/is-string"),d=Array.isArray,p=Function.prototype.call,m={configurable:!0,enumerable:!0,writable:!0,value:null},f=Object.defineProperty;t.exports=function(e){var t,r,h,b,g,y,v,w,x,D,k=arguments[1],E=arguments[2];if(e=Object(l(e)),u(k)&&s(k),this&&this!==Array&&o(this))t=this;else{if(!k){if(a(e))return 1!==(g=e.length)?Array.apply(null,e):((b=new Array(1))[0]=e[0],b);if(d(e)){for(b=new Array(g=e.length),r=0;r<g;++r)b[r]=e[r];return b}}b=[]}if(!d(e))if(void 0!==(x=e[n])){for(v=s(x).call(e),t&&(b=new t),w=v.next(),r=0;!w.done;)D=k?p.call(k,E,w.value,r):w.value,t?(m.value=D,f(b,r,m)):b[r]=D,w=v.next(),++r;g=r}else if(c(e)){for(g=e.length,t&&(b=new t),h=r=0;r<g;++r)D=e[r],r+1<g&&55296<=(y=D.charCodeAt(0))&&y<=56319&&(D+=e[++r]),D=k?p.call(k,E,D,h):D,t?(m.value=D,f(b,h,m)):b[h]=D,++h;g=h}if(void 0===g)for(g=i(e.length),t&&(b=new t(g)),r=0;r<g;++r)D=k?p.call(k,E,e[r],r):e[r],t?(m.value=D,f(b,r,m)):b[r]=D;return t&&(m.value=null,b.length=g),b}},{"../../function/is-arguments":166,"../../function/is-function":167,"../../number/to-pos-integer":176,"../../object/is-value":184,"../../object/valid-callable":192,"../../object/valid-value":193,"../../string/is-string":200,"es6-symbol":203}],163:[function(e,t,r){"use strict";var n=e("./from"),a=Array.isArray;t.exports=function(e){return a(e)?e:n(e)}},{"./from":160}],164:[function(e,t,r){"use strict";var n=e("../object/assign"),a=e("../object/is-object"),o=e("../object/is-value"),i=Error.captureStackTrace;t.exports=function(e){var r=new Error(e),s=arguments[1],l=arguments[2];return o(l)||a(s)&&(l=s,s=null),o(l)&&n(r,l),o(s)&&(r.code=s),i&&i(r,t.exports),r}},{"../object/assign":178,"../object/is-object":183,"../object/is-value":184}],165:[function(e,t,r){"use strict";function n(e,t){return t}var a,o,i,s,l,u=e("../number/to-pos-integer");try{Object.defineProperty(n,"length",{configurable:!0,writable:!1,enumerable:!1,value:1})}catch(e){}1===n.length?(a={configurable:!0,writable:!1,enumerable:!1},o=Object.defineProperty,t.exports=function(e,t){return t=u(t),e.length===t?e:(a.value=t,o(e,"length",a))}):(s=e("../object/mixin"),l=[],i=function(e){var t,r=0;if(l[e])return l[e];for(t=[];e--;)t.push("a"+(++r).toString(36));return new Function("fn","return function ("+t.join(", ")+") { return fn.apply(this, arguments); };")},t.exports=function(e,t){var r;if(t=u(t),e.length===t)return e;r=i(t)(e);try{s(r,e)}catch(e){}return r})},{"../number/to-pos-integer":176,"../object/mixin":189}],166:[function(e,t,r){"use strict";var n=Object.prototype.toString,a=n.call(function(){return arguments}());t.exports=function(e){return n.call(e)===a}},{}],167:[function(e,t,r){"use strict";var n=Object.prototype.toString,a=RegExp.prototype.test.bind(/^[object [A-Za-z0-9]*Function]$/);t.exports=function(e){return"function"==typeof e&&a(n.call(e))}},{}],168:[function(e,t,r){"use strict";t.exports=function(){}},{}],169:[function(e,t,r){"use strict";t.exports=e("./is-implemented")()?Math.sign:e("./shim")},{"./is-implemented":170,"./shim":171}],170:[function(e,t,r){"use strict";t.exports=function(){var e=Math.sign;return"function"==typeof e&&1===e(10)&&-1===e(-20)}},{}],171:[function(e,t,r){"use strict";t.exports=function(e){return e=Number(e),isNaN(e)||0===e?e:0<e?1:-1}},{}],172:[function(e,t,r){"use strict";t.exports=e("./is-implemented")()?Number.isNaN:e("./shim")},{"./is-implemented":173,"./shim":174}],173:[function(e,t,r){"use strict";t.exports=function(){var e=Number.isNaN;return"function"==typeof e&&!e({})&&e(NaN)&&!e(34)}},{}],174:[function(e,t,r){"use strict";t.exports=function(e){return e!=e}},{}],175:[function(e,t,r){"use strict";var n=e("../math/sign"),a=Math.abs,o=Math.floor;t.exports=function(e){return isNaN(e)?0:0!==(e=Number(e))&&isFinite(e)?n(e)*o(a(e)):e}},{"../math/sign":169}],176:[function(e,t,r){"use strict";var n=e("./to-integer"),a=Math.max;t.exports=function(e){return a(0,n(e))}},{"./to-integer":175}],177:[function(e,t,r){"use strict";var n=e("./valid-callable"),a=e("./valid-value"),o=Function.prototype.bind,i=Function.prototype.call,s=Object.keys,l=Object.prototype.propertyIsEnumerable;t.exports=function(e,t){return function(r,u){var c,d=arguments[2],p=arguments[3];return r=Object(a(r)),n(u),c=s(r),p&&c.sort("function"==typeof p?o.call(p,r):void 0),"function"!=typeof e&&(e=c[e]),i.call(e,c,function(e,n){return l.call(r,e)?i.call(u,d,r[e],e,r,n):t})}}},{"./valid-callable":192,"./valid-value":193}],178:[function(e,t,r){"use strict";t.exports=e("./is-implemented")()?Object.assign:e("./shim")},{"./is-implemented":179,"./shim":180}],179:[function(e,t,r){"use strict";t.exports=function(){var e,t=Object.assign;return"function"==typeof t&&(t(e={foo:"raz"},{bar:"dwa"},{trzy:"trzy"}),e.foo+e.bar+e.trzy==="razdwatrzy")}},{}],180:[function(e,t,r){"use strict";var n=e("../keys"),a=e("../valid-value"),o=Math.max;t.exports=function(e,t){var r,i,s,l=o(arguments.length,2);for(e=Object(a(e)),s=function(n){try{e[n]=t[n]}catch(n){r=r||n}},i=1;i<l;++i)n(t=arguments[i]).forEach(s);if(void 0!==r)throw r;return e}},{"../keys":185,"../valid-value":193}],181:[function(e,t,r){"use strict";t.exports=e("./_iterate")("forEach")},{"./_iterate":177}],182:[function(e,t,r){"use strict";t.exports=function(e){return"function"==typeof e}},{}],183:[function(e,t,r){"use strict";var n=e("./is-value"),a={function:!0,object:!0};t.exports=function(e){return n(e)&&a[typeof e]||!1}},{"./is-value":184}],184:[function(e,t,r){"use strict";var n=e("../function/noop")();t.exports=function(e){return e!==n&&null!==e}},{"../function/noop":168}],185:[function(e,t,r){"use strict";t.exports=e("./is-implemented")()?Object.keys:e("./shim")},{"./is-implemented":186,"./shim":187}],186:[function(e,t,r){"use strict";t.exports=function(){try{return Object.keys("primitive"),!0}catch(e){return!1}}},{}],187:[function(e,t,r){"use strict";var n=e("../is-value"),a=Object.keys;t.exports=function(e){return a(n(e)?Object(e):e)}},{"../is-value":184}],188:[function(e,t,r){"use strict";var n=e("./valid-callable"),a=e("./for-each"),o=Function.prototype.call;t.exports=function(e,t){var r={},i=arguments[2];return n(t),a(e,function(e,n,a,s){r[n]=o.call(t,i,e,n,a,s)}),r}},{"./for-each":181,"./valid-callable":192}],189:[function(e,t,r){"use strict";var n=e("./valid-value"),a=Object.defineProperty,o=Object.getOwnPropertyDescriptor,i=Object.getOwnPropertyNames,s=Object.getOwnPropertySymbols;t.exports=function(e,t){var r,l=Object(n(t));if(e=Object(n(e)),i(l).forEach(function(n){try{a(e,n,o(t,n))}catch(n){r=n}}),"function"==typeof s&&s(l).forEach(function(n){try{a(e,n,o(t,n))}catch(n){r=n}}),void 0!==r)throw r;return e}},{"./valid-value":193}],190:[function(e,t,r){"use strict";var n=e("./is-value"),a=Array.prototype.forEach,o=Object.create;t.exports=function(e){var t=o(null);return a.call(arguments,function(e){n(e)&&function(e,t){var r;for(r in e)t[r]=e[r]}(Object(e),t)}),t}},{"./is-value":184}],191:[function(e,t,r){"use strict";var n=Array.prototype.forEach,a=Object.create;t.exports=function(e){var t=a(null);return n.call(arguments,function(e){t[e]=!0}),t}},{}],192:[function(e,t,r){"use strict";t.exports=function(e){if("function"!=typeof e)throw new TypeError(e+" is not a function");return e}},{}],193:[function(e,t,r){"use strict";var n=e("./is-value");t.exports=function(e){if(!n(e))throw new TypeError("Cannot use null or undefined");return e}},{"./is-value":184}],194:[function(e,t,r){"use strict";var n=e("./valid-value"),a=e("./validate-stringifiable");t.exports=function(e){return a(n(e))}},{"./valid-value":193,"./validate-stringifiable":195}],195:[function(e,t,r){"use strict";var n=e("./is-callable");t.exports=function(e){try{return e&&n(e.toString)?e.toString():String(e)}catch(e){throw new TypeError("Passed argument cannot be stringifed")}}},{"./is-callable":182}],196:[function(e,t,r){"use strict";var n=e("./object/is-callable");t.exports=function(e){try{return e&&n(e.toString)?e.toString():String(e)}catch(e){return"<Non-coercible to string value>"}}},{"./object/is-callable":182}],197:[function(e,t,r){"use strict";t.exports=e("./is-implemented")()?String.prototype.contains:e("./shim")},{"./is-implemented":198,"./shim":199}],198:[function(e,t,r){"use strict";var n="razdwatrzy";t.exports=function(){return"function"==typeof n.contains&&!0===n.contains("dwa")&&!1===n.contains("foo")}},{}],199:[function(e,t,r){"use strict";var n=String.prototype.indexOf;t.exports=function(e){return-1<n.call(this,e,arguments[1])}},{}],200:[function(e,t,r){"use strict";var n=Object.prototype.toString,a=n.call("");t.exports=function(e){return"string"==typeof e||e&&"object"==typeof e&&(e instanceof String||n.call(e)===a)||!1}},{}],201:[function(e,t,r){"use strict";var n=e("./safe-to-string"),a=/[\\n\\r\\u2028\\u2029]/g;t.exports=function(e){var t=n(e);return 100<t.length&&(t=t.slice(0,99)+"…"),t.replace(a,function(e){return JSON.stringify(e).slice(1,-1)})}},{"./safe-to-string":196}],202:[function(e,a,o){(function(r,i){var s;s=function(){"use strict";function a(e){return"function"==typeof e}var o=Array.isArray?Array.isArray:function(e){return"[object Array]"===Object.prototype.toString.call(e)},s=0,l=void 0,u=void 0,c=function(e,t){g[s]=e,g[s+1]=t,2===(s+=2)&&(u?u(y):k())},d=void 0!==t?t:void 0,p=d||{},m=p.MutationObserver||p.WebKitMutationObserver,f="undefined"==typeof self&&void 0!==r&&"[object process]"==={}.toString.call(r),h="undefined"!=typeof Uint8ClampedArray&&"undefined"!=typeof importScripts&&"undefined"!=typeof MessageChannel;function b(){var e=setTimeout;return function(){return e(y,1)}}var g=new Array(1e3);function y(){for(var e=0;e<s;e+=2)(0,g[e])(g[e+1]),g[e]=void 0,g[e+1]=void 0;s=0}var v,w,x,D,k=void 0;function E(e,t){var r=this,n=new this.constructor(C);void 0===n[j]&&B(n);var a=r._state;if(a){var o=arguments[a-1];c(function(){return I(a,n,o,r._result)})}else R(r,n,e,t);return n}function A(e){if(e&&"object"==typeof e&&e.constructor===this)return e;var t=new this(C);return z(t,e),t}k=f?function(){return r.nextTick(y)}:m?(w=0,x=new m(y),D=n.createTextNode(""),x.observe(D,{characterData:!0}),function(){D.data=w=++w%2}):h?((v=new MessageChannel).port1.onmessage=y,function(){return v.port2.postMessage(0)}):(void 0===d&&"function"==typeof e?function(){try{var e=Function("return this")().require("vertx");return void 0!==(l=e.runOnLoop||e.runOnContext)?function(){l(y)}:b()}catch(e){return b()}}:b)();var j=Math.random().toString(36).substring(2);function C(){}var F=void 0,T=1,N=2;function S(e,t,r){var n,o;t.constructor===e.constructor&&r===E&&t.constructor.resolve===A?(n=e,(o=t)._state===T?O(n,o._result):o._state===N?_(n,o._result):R(o,void 0,function(e){return z(n,e)},function(e){return _(n,e)})):void 0!==r&&a(r)?function(e,t,r){c(function(e){var n=!1,a=function(e,t,r,n){try{e.call(t,r,n)}catch(e){return e}}(r,t,function(r){n||(n=!0,(t!==r?z:O)(e,r))},function(t){n||(n=!0,_(e,t))},e._label);!n&&a&&(n=!0,_(e,a))},e)}(e,t,r):O(e,t)}function z(e,t){if(e===t)_(e,new TypeError("You cannot resolve a promise with itself"));else if(a=typeof(n=t),null===n||"object"!=a&&"function"!=a)O(e,t);else{var r=void 0;try{r=t.then}catch(t){return void _(e,t)}S(e,t,r)}var n,a}function q(e){e._onerror&&e._onerror(e._result),P(e)}function O(e,t){e._state===F&&(e._result=t,e._state=T,0!==e._subscribers.length&&c(P,e))}function _(e,t){e._state===F&&(e._state=N,e._result=t,c(q,e))}function R(e,t,r,n){var a=e._subscribers,o=a.length;e._onerror=null,a[o]=t,a[o+T]=r,a[o+N]=n,0===o&&e._state&&c(P,e)}function P(e){var t=e._subscribers,r=e._state;if(0!==t.length){for(var n=void 0,a=void 0,o=e._result,i=0;i<t.length;i+=3)n=t[i],a=t[i+r],n?I(r,n,a,o):a(o);e._subscribers.length=0}}function I(e,t,r,n){var o=a(r),i=void 0,s=void 0,l=!0;if(o){try{i=r(n)}catch(e){l=!1,s=e}if(t===i)return void _(t,new TypeError("A promises callback cannot return that same promise."))}else i=n;t._state!==F||(o&&l?z(t,i):!1===l?_(t,s):e===T?O(t,i):e===N&&_(t,i))}var L=0;function B(e){e[j]=L++,e._state=void 0,e._result=void 0,e._subscribers=[]}var M=(V.prototype._enumerate=function(e){for(var t=0;this._state===F&&t<e.length;t++)this._eachEntry(e[t],t)},V.prototype._eachEntry=function(e,t){var r=this._instanceConstructor,n=r.resolve;if(n===A){var a=void 0,o=void 0,i=!1;try{a=e.then}catch(t){i=!0,o=t}if(a===E&&e._state!==F)this._settledAt(e._state,t,e._result);else if("function"!=typeof a)this._remaining--,this._result[t]=e;else if(r===U){var s=new r(C);i?_(s,o):S(s,e,a),this._willSettleAt(s,t)}else this._willSettleAt(new r(function(t){return t(e)}),t)}else this._willSettleAt(n(e),t)},V.prototype._settledAt=function(e,t,r){var n=this.promise;n._state===F&&(this._remaining--,e===N?_(n,r):this._result[t]=r),0===this._remaining&&O(n,this._result)},V.prototype._willSettleAt=function(e,t){var r=this;R(e,void 0,function(e){return r._settledAt(T,t,e)},function(e){return r._settledAt(N,t,e)})},V);function V(e,t){this._instanceConstructor=e,this.promise=new e(C),this.promise[j]||B(this.promise),o(t)?(this.length=t.length,this._remaining=t.length,this._result=new Array(this.length),0===this.length?O(this.promise,this._result):(this.length=this.length||0,this._enumerate(t),0===this._remaining&&O(this.promise,this._result))):_(this.promise,new Error("Array Methods must be provided an Array"))}var U=(H.prototype.catch=function(e){return this.then(null,e)},H.prototype.finally=function(e){var t=this.constructor;return a(e)?this.then(function(r){return t.resolve(e()).then(function(){return r})},function(r){return t.resolve(e()).then(function(){throw r})}):this.then(e,e)},H);function H(e){this[j]=L++,this._result=this._state=void 0,this._subscribers=[],C!==e&&("function"!=typeof e&&function(){throw new TypeError("You must pass a resolver function as the first argument to the promise constructor")}(),this instanceof H?function(e,t){try{t(function(t){z(e,t)},function(t){_(e,t)})}catch(t){_(e,t)}}(this,e):function(){throw new TypeError("Failed to construct \'Promise\': Please use the \'new\' operator, this object constructor cannot be called as a function.")}())}return U.prototype.then=E,U.all=function(e){return new M(this,e).promise},U.race=function(e){var t=this;return o(e)?new t(function(r,n){for(var a=e.length,o=0;o<a;o++)t.resolve(e[o]).then(r,n)}):new t(function(e,t){return t(new TypeError("You must pass an array to race."))})},U.resolve=A,U.reject=function(e){var t=new this(C);return _(t,e),t},U._setScheduler=function(e){u=e},U._setAsap=function(e){c=e},U._asap=c,U.polyfill=function(){var e=void 0;if(void 0!==i)e=i;else if("undefined"!=typeof self)e=self;else try{e=Function("return this")()}catch(e){throw new Error("polyfill failed because global object is unavailable in this environment")}var t=e.Promise;if(t){var r=null;try{r=Object.prototype.toString.call(t.resolve())}catch(e){}if("[object Promise]"===r&&!t.cast)return}e.Promise=U},U.Promise=U},"object"==typeof o&&void 0!==a?a.exports=s():"function"==typeof define&&define.amd?define(s):this.ES6Promise=s()}).call(this,e("_process"),void 0!==r?r:"undefined"!=typeof self?self:void 0!==t?t:{})},{_process:236}],203:[function(e,t,r){"use strict";t.exports=e("./is-implemented")()?e("ext/global-this").Symbol:e("./polyfill")},{"./is-implemented":204,"./polyfill":209,"ext/global-this":213}],204:[function(e,t,r){"use strict";var n=e("ext/global-this"),a={object:!0,symbol:!0};t.exports=function(){var e,t=n.Symbol;if("function"!=typeof t)return!1;e=t("test symbol");try{String(e)}catch(e){return!1}return!!a[typeof t.iterator]&&!!a[typeof t.toPrimitive]&&!!a[typeof t.toStringTag]}},{"ext/global-this":213}],205:[function(e,t,r){"use strict";t.exports=function(e){return!!e&&("symbol"==typeof e||!!e.constructor&&"Symbol"===e.constructor.name&&"Symbol"===e[e.constructor.toStringTag])}},{}],206:[function(e,t,r){"use strict";var n=e("d"),a=Object.create,o=Object.defineProperty,i=Object.prototype,s=a(null);t.exports=function(e){for(var t,r,a=0;s[e+(a||"")];)++a;return s[e+=a||""]=!0,o(i,t="@@"+e,n.gs(null,function(e){r||(r=!0,o(this,t,n(e)),r=!1)})),t}},{d:157}],207:[function(e,t,r){"use strict";var n=e("d"),a=e("ext/global-this").Symbol;t.exports=function(e){return Object.defineProperties(e,{hasInstance:n("",a&&a.hasInstance||e("hasInstance")),isConcatSpreadable:n("",a&&a.isConcatSpreadable||e("isConcatSpreadable")),iterator:n("",a&&a.iterator||e("iterator")),match:n("",a&&a.match||e("match")),replace:n("",a&&a.replace||e("replace")),search:n("",a&&a.search||e("search")),species:n("",a&&a.species||e("species")),split:n("",a&&a.split||e("split")),toPrimitive:n("",a&&a.toPrimitive||e("toPrimitive")),toStringTag:n("",a&&a.toStringTag||e("toStringTag")),unscopables:n("",a&&a.unscopables||e("unscopables"))})}},{d:157,"ext/global-this":213}],208:[function(e,t,r){"use strict";var n=e("d"),a=e("../../../validate-symbol"),o=Object.create(null);t.exports=function(e){return Object.defineProperties(e,{for:n(function(t){return o[t]?o[t]:o[t]=e(String(t))}),keyFor:n(function(e){var t;for(t in a(e),o)if(o[t]===e)return t})})}},{"../../../validate-symbol":210,d:157}],209:[function(e,t,r){"use strict";var n,a,o,i=e("d"),s=e("./validate-symbol"),l=e("ext/global-this").Symbol,u=e("./lib/private/generate-name"),c=e("./lib/private/setup/standard-symbols"),d=e("./lib/private/setup/symbol-registry"),p=Object.create,m=Object.defineProperties,f=Object.defineProperty;if("function"==typeof l)try{String(l()),o=!0}catch(e){}else l=null;a=function(e){if(this instanceof a)throw new TypeError("Symbol is not a constructor");return n(e)},t.exports=n=function e(t){var r;if(this instanceof e)throw new TypeError("Symbol is not a constructor");return o?l(t):(r=p(a.prototype),t=void 0===t?"":String(t),m(r,{__description__:i("",t),__name__:i("",u(t))}))},c(n),d(n),m(a.prototype,{constructor:i(n),toString:i("",function(){return this.__name__})}),m(n.prototype,{toString:i(function(){return"Symbol ("+s(this).__description__+")"}),valueOf:i(function(){return s(this)})}),f(n.prototype,n.toPrimitive,i("",function(){var e=s(this);return"symbol"==typeof e?e:e.toString()})),f(n.prototype,n.toStringTag,i("c","Symbol")),f(a.prototype,n.toStringTag,i("c",n.prototype[n.toStringTag])),f(a.prototype,n.toPrimitive,i("c",n.prototype[n.toPrimitive]))},{"./lib/private/generate-name":206,"./lib/private/setup/standard-symbols":207,"./lib/private/setup/symbol-registry":208,"./validate-symbol":210,d:157,"ext/global-this":213}],210:[function(e,t,r){"use strict";var n=e("./is-symbol");t.exports=function(e){if(!n(e))throw new TypeError(e+" is not a symbol");return e}},{"./is-symbol":205}],211:[function(e,t,r){"use strict";var n,a,o,i,s,l,u,c=e("d"),d=e("es5-ext/object/valid-callable"),p=Function.prototype.apply,m=Function.prototype.call,f=Object.create,h=Object.defineProperty,b=Object.defineProperties,g=Object.prototype.hasOwnProperty,y={configurable:!0,enumerable:!1,writable:!0};a=function(e,t){var r,a;return d(t),n.call(a=this,e,r=function(){o.call(a,e,r),p.call(t,this,arguments)}),r.__eeOnceListener__=t,this},s={on:n=function(e,t){var r;return d(t),g.call(this,"__ee__")?r=this.__ee__:(r=y.value=f(null),h(this,"__ee__",y),y.value=null),r[e]?"object"==typeof r[e]?r[e].push(t):r[e]=[r[e],t]:r[e]=t,this},once:a,off:o=function(e,t){var r,n,a,o;if(d(t),!g.call(this,"__ee__"))return this;if(!(r=this.__ee__)[e])return this;if("object"==typeof(n=r[e]))for(o=0;a=n[o];++o)a!==t&&a.__eeOnceListener__!==t||(2===n.length?r[e]=n[o?0:1]:n.splice(o,1));else n!==t&&n.__eeOnceListener__!==t||delete r[e];return this},emit:i=function(e){var t,r,n,a,o;if(g.call(this,"__ee__")&&(a=this.__ee__[e]))if("object"==typeof a){for(r=arguments.length,o=new Array(r-1),t=1;t<r;++t)o[t-1]=arguments[t];for(a=a.slice(),t=0;n=a[t];++t)p.call(n,this,o)}else switch(arguments.length){case 1:m.call(a,this);break;case 2:m.call(a,this,arguments[1]);break;case 3:m.call(a,this,arguments[1],arguments[2]);break;default:for(r=arguments.length,o=new Array(r-1),t=1;t<r;++t)o[t-1]=arguments[t];p.call(a,this,o)}}},l={on:c(n),once:c(a),off:c(o),emit:c(i)},u=b({},l),t.exports=r=function(e){return null==e?f(u):b(Object(e),l)},r.methods=s},{d:157,"es5-ext/object/valid-callable":192}],212:[function(e,r,n){function a(){if("object"==typeof self&&self)return self;if("object"==typeof t&&t)return t;throw new Error("Unable to resolve global `this`")}r.exports=function(){if(this)return this;try{Object.defineProperty(Object.prototype,"__global__",{get:function(){return this},configurable:!0})}catch(e){return a()}try{return __global__||a()}finally{delete Object.prototype.__global__}}()},{}],213:[function(e,t,r){"use strict";t.exports=e("./is-implemented")()?globalThis:e("./implementation")},{"./implementation":212,"./is-implemented":214}],214:[function(e,t,r){"use strict";t.exports=function(){return"object"==typeof globalThis&&!!globalThis&&globalThis.Array===Array}},{}],215:[function(e,t,r){t.exports=function(e){return!!e&&("object"==typeof e||"function"==typeof e)&&"function"==typeof e.then}},{}],216:[function(e,t,r){"use strict";var n=e("es5-ext/number/to-pos-integer"),a=Object.create,o=Object.prototype.hasOwnProperty;t.exports=function(e){var t,r=0,i=1,s=a(null),l=a(null),u=0;return e=n(e),{hit:function(n){var a=l[n],c=++u;if(s[c]=n,l[n]=c,!a){if(++r<=e)return;return n=s[i],t(n),n}if(delete s[a],i===a)for(;!o.call(s,++i););},delete:t=function(e){var t=l[e];if(t&&(delete s[t],delete l[e],--r,i===t)){if(!r)return u=0,void(i=1);for(;!o.call(s,++i););}},clear:function(){r=0,i=1,s=a(null),l=a(null),u=0}}}},{"es5-ext/number/to-pos-integer":176}],217:[function(e,t,r){"use strict";var n=e("es5-ext/array/from"),a=e("es5-ext/object/map"),o=e("es5-ext/object/mixin"),i=e("es5-ext/function/_define-length"),s=e("next-tick"),l=Array.prototype.slice,u=Function.prototype.apply,c=Object.create;e("../lib/registered-extensions").async=function(e,t){var r,d,p,m=c(null),f=c(null),h=t.memoized,b=t.original;t.memoized=i(function(e){var t=arguments,n=t[t.length-1];return"function"==typeof n&&(r=n,t=l.call(t,0,-1)),h.apply(d=this,p=t)},h);try{o(t.memoized,h)}catch(e){}t.on("get",function(e){var n,a,o;if(r){if(m[e])return"function"==typeof m[e]?m[e]=[m[e],r]:m[e].push(r),void(r=null);n=r,a=d,o=p,r=d=p=null,s(function(){var i;hasOwnProperty.call(f,e)?(i=f[e],t.emit("getasync",e,o,a),u.call(n,i.context,i.args)):(r=n,d=a,p=o,h.apply(a,o))})}}),t.original=function(){var e,a,o,i;return r?(e=n(arguments),a=function e(r){var a,o,l=e.id;if(null!=l){if(delete e.id,a=m[l],delete m[l],a)return o=n(arguments),t.has(l)&&(r?t.delete(l):(f[l]={context:this,args:o},t.emit("setasync",l,"function"==typeof a?1:a.length))),"function"==typeof a?i=u.call(a,this,o):a.forEach(function(e){i=u.call(e,this,o)},this),i}else s(u.bind(e,this,arguments))},o=r,r=d=p=null,e.push(a),i=u.call(b,this,e),a.cb=o,r=a,i):u.call(b,this,arguments)},t.on("set",function(e){r?(m[e]?"function"==typeof m[e]?m[e]=[m[e],r.cb]:m[e].push(r.cb):m[e]=r.cb,delete r.cb,r.id=e,r=null):t.delete(e)}),t.on("delete",function(e){var r;hasOwnProperty.call(m,e)||f[e]&&(r=f[e],delete f[e],t.emit("deleteasync",e,l.call(r.args,1)))}),t.on("clear",function(){var e=f;f=c(null),t.emit("clearasync",a(e,function(e){return l.call(e.args,1)}))})}},{"../lib/registered-extensions":225,"es5-ext/array/from":160,"es5-ext/function/_define-length":165,"es5-ext/object/map":188,"es5-ext/object/mixin":189,"next-tick":235}],218:[function(e,t,r){"use strict";var n=e("es5-ext/object/valid-callable"),a=e("es5-ext/object/for-each"),o=e("../lib/registered-extensions"),i=Function.prototype.apply;o.dispose=function(e,t,r){var s;if(n(e),r.async&&o.async||r.promise&&o.promise)return t.on("deleteasync",s=function(t,r){i.call(e,null,r)}),void t.on("clearasync",function(e){a(e,function(e,t){s(t,e)})});t.on("delete",s=function(t,r){e(r)}),t.on("clear",function(e){a(e,function(e,t){s(t,e)})})}},{"../lib/registered-extensions":225,"es5-ext/object/for-each":181,"es5-ext/object/valid-callable":192}],219:[function(e,t,r){"use strict";var n=e("es5-ext/array/from"),a=e("es5-ext/object/for-each"),o=e("next-tick"),i=e("is-promise"),s=e("timers-ext/valid-timeout"),l=e("../lib/registered-extensions"),u=Function.prototype,c=Math.max,d=Math.min,p=Object.create;l.maxAge=function(e,t,r){var m,f,h,b;(e=s(e))&&(m=p(null),f=r.async&&l.async||r.promise&&l.promise?"async":"",t.on("set"+f,function(r){m[r]=setTimeout(function(){t.delete(r)},e),"function"==typeof m[r].unref&&m[r].unref(),b&&(b[r]&&"nextTick"!==b[r]&&clearTimeout(b[r]),b[r]=setTimeout(function(){delete b[r]},h),"function"==typeof b[r].unref&&b[r].unref())}),t.on("delete"+f,function(e){clearTimeout(m[e]),delete m[e],b&&("nextTick"!==b[e]&&clearTimeout(b[e]),delete b[e])}),r.preFetch&&(h=!0===r.preFetch||isNaN(r.preFetch)?.333:c(d(Number(r.preFetch),1),0))&&(b={},h=(1-h)*e,t.on("get"+f,function(e,a,s){b[e]||(b[e]="nextTick",o(function(){var o;"nextTick"===b[e]&&(delete b[e],t.delete(e),r.async&&(a=n(a)).push(u),o=t.memoized.apply(s,a),r.promise&&i(o)&&("function"==typeof o.done?o.done(u,u):o.then(u,u)))}))})),t.on("clear"+f,function(){a(m,function(e){clearTimeout(e)}),m={},b&&(a(b,function(e){"nextTick"!==e&&clearTimeout(e)}),b={})}))}},{"../lib/registered-extensions":225,"es5-ext/array/from":160,"es5-ext/object/for-each":181,"is-promise":215,"next-tick":235,"timers-ext/valid-timeout":239}],220:[function(e,t,r){"use strict";var n=e("es5-ext/number/to-pos-integer"),a=e("lru-queue"),o=e("../lib/registered-extensions");o.max=function(e,t,r){var i,s,l;(e=n(e))&&(s=a(e),i=r.async&&o.async||r.promise&&o.promise?"async":"",t.on("set"+i,l=function(e){void 0!==(e=s.hit(e))&&t.delete(e)}),t.on("get"+i,l),t.on("delete"+i,s.delete),t.on("clear"+i,s.clear))}},{"../lib/registered-extensions":225,"es5-ext/number/to-pos-integer":176,"lru-queue":216}],221:[function(e,t,r){"use strict";var n=e("es5-ext/object/map"),a=e("es5-ext/object/primitive-set"),o=e("es5-ext/object/validate-stringifiable-value"),i=e("es5-ext/to-short-string-representation"),s=e("is-promise"),l=e("next-tick"),u=Object.create,c=a("then","then:finally","done","done:finally");e("../lib/registered-extensions").promise=function(e,t){var r=u(null),a=u(null),d=u(null);if(!0===e)e=null;else if(e=o(e),!c[e])throw new TypeError("\'"+i(e)+"\' is not valid promise mode");t.on("set",function(n,o,i){var u=!1;if(!s(i))return a[n]=i,void t.emit("setasync",n,1);function c(e){var o=r[n];if(u)throw new Error("Memoizee error: Detected unordered then|done & finally resolution, which in turn makes proper detection of success/failure impossible (when in \'done:finally\' mode)\\nConsider to rely on \'then\' or \'done\' mode instead.");o&&(delete r[n],a[n]=e,t.emit("setasync",n,o))}function p(){u=!0,r[n]&&(delete r[n],delete d[n],t.delete(n))}r[n]=1,d[n]=i;var m=e;if("then"===(m=m||"then")){var f=function(){l(p)};"function"==typeof(i=i.then(function(e){l(c.bind(this,e))},f)).finally&&i.finally(f)}else if("done"===m){if("function"!=typeof i.done)throw new Error("Memoizee error: Retrieved promise does not implement \'done\' in \'done\' mode");i.done(c,p)}else if("done:finally"===m){if("function"!=typeof i.done)throw new Error("Memoizee error: Retrieved promise does not implement \'done\' in \'done:finally\' mode");if("function"!=typeof i.finally)throw new Error("Memoizee error: Retrieved promise does not implement \'finally\' in \'done:finally\' mode");i.done(c),i.finally(p)}}),t.on("get",function(e,n,a){var o;if(r[e])++r[e];else{o=d[e];var i=function(){t.emit("getasync",e,n,a)};s(o)?"function"==typeof o.done?o.done(i):o.then(function(){l(i)}):i()}}),t.on("delete",function(e){if(delete d[e],r[e])delete r[e];else if(hasOwnProperty.call(a,e)){var n=a[e];delete a[e],t.emit("deleteasync",e,[n])}}),t.on("clear",function(){var e=a;a=u(null),r=u(null),d=u(null),t.emit("clearasync",n(e,function(e){return[e]}))})}},{"../lib/registered-extensions":225,"es5-ext/object/map":188,"es5-ext/object/primitive-set":191,"es5-ext/object/validate-stringifiable-value":194,"es5-ext/to-short-string-representation":201,"is-promise":215,"next-tick":235}],222:[function(e,t,r){"use strict";var n=e("d"),a=e("../lib/registered-extensions"),o=Object.create,i=Object.defineProperties;a.refCounter=function(e,t,r){var s,l;s=o(null),l=r.async&&a.async||r.promise&&a.promise?"async":"",t.on("set"+l,function(e,t){s[e]=t||1}),t.on("get"+l,function(e){++s[e]}),t.on("delete"+l,function(e){delete s[e]}),t.on("clear"+l,function(){s={}}),i(t.memoized,{deleteRef:n(function(){var e=t.get(arguments);return null!==e&&s[e]?!--s[e]&&(t.delete(e),!0):null}),getRefCount:n(function(){var e=t.get(arguments);return null!==e&&s[e]?s[e]:0})})}},{"../lib/registered-extensions":225,d:157}],223:[function(e,t,r){"use strict";var n=e("es5-ext/object/normalize-options"),a=e("./lib/resolve-length"),o=e("./plain");t.exports=function(t){var r,i=n(arguments[1]);return i.normalizer||0!==(r=i.length=a(i.length,t.length,i.async))&&(i.primitive?!1===r?i.normalizer=e("./normalizers/primitive"):1<r&&(i.normalizer=e("./normalizers/get-primitive-fixed")(r)):i.normalizer=!1===r?e("./normalizers/get")():1===r?e("./normalizers/get-1")():e("./normalizers/get-fixed")(r)),i.async&&e("./ext/async"),i.promise&&e("./ext/promise"),i.dispose&&e("./ext/dispose"),i.maxAge&&e("./ext/max-age"),i.max&&e("./ext/max"),i.refCounter&&e("./ext/ref-counter"),o(t,i)}},{"./ext/async":217,"./ext/dispose":218,"./ext/max":220,"./ext/max-age":219,"./ext/promise":221,"./ext/ref-counter":222,"./lib/resolve-length":226,"./normalizers/get":232,"./normalizers/get-1":229,"./normalizers/get-fixed":230,"./normalizers/get-primitive-fixed":231,"./normalizers/primitive":233,"./plain":234,"es5-ext/object/normalize-options":190}],224:[function(e,t,r){"use strict";var n=e("es5-ext/error/custom"),a=e("es5-ext/function/_define-length"),o=e("d"),i=e("event-emitter").methods,s=e("./resolve-resolve"),l=e("./resolve-normalize"),u=Function.prototype.apply,c=Function.prototype.call,d=Object.create,p=Object.defineProperties,m=i.on,f=i.emit;t.exports=function(e,t,r){var i,h,b,g,y,v,w,x,D,k,E,A,j,C,F,T=d(null);return h=!1!==t?t:isNaN(e.length)?1:e.length,r.normalizer&&(k=l(r.normalizer),b=k.get,g=k.set,y=k.delete,v=k.clear),null!=r.resolvers&&(F=s(r.resolvers)),C=b?a(function(t){var r,a,o=arguments;if(F&&(o=F(o)),null!==(r=b(o))&&hasOwnProperty.call(T,r))return E&&i.emit("get",r,o,this),T[r];if(a=1===o.length?c.call(e,this,o[0]):u.call(e,this,o),null===r){if(null!==(r=b(o)))throw n("Circular invocation","CIRCULAR_INVOCATION");r=g(o)}else if(hasOwnProperty.call(T,r))throw n("Circular invocation","CIRCULAR_INVOCATION");return T[r]=a,A&&i.emit("set",r,null,a),a},h):0===t?function(){var t;if(hasOwnProperty.call(T,"data"))return E&&i.emit("get","data",arguments,this),T.data;if(t=arguments.length?u.call(e,this,arguments):c.call(e,this),hasOwnProperty.call(T,"data"))throw n("Circular invocation","CIRCULAR_INVOCATION");return T.data=t,A&&i.emit("set","data",null,t),t}:function(t){var r,a,o=arguments;if(F&&(o=F(arguments)),a=String(o[0]),hasOwnProperty.call(T,a))return E&&i.emit("get",a,o,this),T[a];if(r=1===o.length?c.call(e,this,o[0]):u.call(e,this,o),hasOwnProperty.call(T,a))throw n("Circular invocation","CIRCULAR_INVOCATION");return T[a]=r,A&&i.emit("set",a,null,r),r},i={original:e,memoized:C,profileName:r.profileName,get:function(e){return F&&(e=F(e)),b?b(e):String(e[0])},has:function(e){return hasOwnProperty.call(T,e)},delete:function(e){var t;hasOwnProperty.call(T,e)&&(y&&y(e),t=T[e],delete T[e],j&&i.emit("delete",e,t))},clear:function(){var e=T;v&&v(),T=d(null),i.emit("clear",e)},on:function(e,t){return"get"===e?E=!0:"set"===e?A=!0:"delete"===e&&(j=!0),m.call(this,e,t)},emit:f,updateEnv:function(){e=i.original}},w=b?a(function(e){var t,r=arguments;F&&(r=F(r)),null!==(t=b(r))&&i.delete(t)},h):0===t?function(){return i.delete("data")}:function(e){return F&&(e=F(arguments)[0]),i.delete(e)},x=a(function(){var e,r=arguments;return 0===t?T.data:(F&&(r=F(r)),e=b?b(r):String(r[0]),T[e])}),D=a(function(){var e,r=arguments;return 0===t?i.has("data"):(F&&(r=F(r)),null!==(e=b?b(r):String(r[0]))&&i.has(e))}),p(C,{__memoized__:o(!0),delete:o(w),clear:o(i.clear),_get:o(x),_has:o(D)}),i}},{"./resolve-normalize":227,"./resolve-resolve":228,d:157,"es5-ext/error/custom":164,"es5-ext/function/_define-length":165,"event-emitter":211}],225:[function(e,t,r){},{}],226:[function(e,t,r){"use strict";var n=e("es5-ext/number/to-pos-integer");t.exports=function(e,t,r){return isNaN(e)?0<=t?r&&t?t-1:t:1:!1!==e&&n(e)}},{"es5-ext/number/to-pos-integer":176}],227:[function(e,t,r){"use strict";var n=e("es5-ext/object/valid-callable");t.exports=function(e){var t;return"function"==typeof e?{set:e,get:e}:(t={get:n(e.get)},void 0!==e.set?(t.set=n(e.set),e.delete&&(t.delete=n(e.delete)),e.clear&&(t.clear=n(e.clear))):t.set=t.get,t)}},{"es5-ext/object/valid-callable":192}],228:[function(e,t,r){"use strict";var n,a=e("es5-ext/array/to-array"),o=e("es5-ext/object/is-value"),i=e("es5-ext/object/valid-callable"),s=Array.prototype.slice;n=function(e){return this.map(function(t,r){return t?t(e[r]):e[r]}).concat(s.call(e,this.length))},t.exports=function(e){return(e=a(e)).forEach(function(e){o(e)&&i(e)}),n.bind(e)}},{"es5-ext/array/to-array":163,"es5-ext/object/is-value":184,"es5-ext/object/valid-callable":192}],229:[function(e,t,r){"use strict";var n=e("es5-ext/array/#/e-index-of");t.exports=function(){var e=0,t=[],r=[];return{get:function(e){var a=n.call(t,e[0]);return-1===a?null:r[a]},set:function(n){return t.push(n[0]),r.push(++e),e},delete:function(e){var a=n.call(r,e);-1!==a&&(t.splice(a,1),r.splice(a,1))},clear:function(){t=[],r=[]}}}},{"es5-ext/array/#/e-index-of":159}],230:[function(e,t,r){"use strict";var n=e("es5-ext/array/#/e-index-of"),a=Object.create;t.exports=function(e){var t=0,r=[[],[]],o=a(null);return{get:function(t){for(var a,o=0,i=r;o<e-1;){if(-1===(a=n.call(i[0],t[o])))return null;i=i[1][a],++o}return-1!==(a=n.call(i[0],t[o]))&&i[1][a]||null},set:function(a){for(var i,s=0,l=r;s<e-1;)-1===(i=n.call(l[0],a[s]))&&(i=l[0].push(a[s])-1,l[1].push([[],[]])),l=l[1][i],++s;return-1===(i=n.call(l[0],a[s]))&&(i=l[0].push(a[s])-1),l[1][i]=++t,o[t]=a,t},delete:function(t){for(var a,i=0,s=r,l=[],u=o[t];i<e-1;){if(-1===(a=n.call(s[0],u[i])))return;l.push(s,a),s=s[1][a],++i}if(-1!==(a=n.call(s[0],u[i]))){for(t=s[1][a],s[0].splice(a,1),s[1].splice(a,1);!s[0].length&&l.length;)a=l.pop(),(s=l.pop())[0].splice(a,1),s[1].splice(a,1);delete o[t]}},clear:function(){r=[[],[]],o=a(null)}}}},{"es5-ext/array/#/e-index-of":159}],231:[function(e,t,r){"use strict";t.exports=function(e){return e?function(t){for(var r=String(t[0]),n=0,a=e;--a;)r+=""+t[++n];return r}:function(){return""}}},{}],232:[function(e,t,r){"use strict";var n=e("es5-ext/array/#/e-index-of"),a=Object.create;t.exports=function(){var e=0,t=[],r=a(null);return{get:function(e){var r,a=0,o=t,i=e.length;if(0===i)return o[i]||null;if(o=o[i]){for(;a<i-1;){if(-1===(r=n.call(o[0],e[a])))return null;o=o[1][r],++a}return-1!==(r=n.call(o[0],e[a]))&&o[1][r]||null}return null},set:function(a){var o,i=0,s=t,l=a.length;if(0===l)s[l]=++e;else{for(s[l]||(s[l]=[[],[]]),s=s[l];i<l-1;)-1===(o=n.call(s[0],a[i]))&&(o=s[0].push(a[i])-1,s[1].push([[],[]])),s=s[1][o],++i;-1===(o=n.call(s[0],a[i]))&&(o=s[0].push(a[i])-1),s[1][o]=++e}return r[e]=a,e},delete:function(e){var a,o=0,i=t,s=r[e],l=s.length,u=[];if(0===l)delete i[l];else if(i=i[l]){for(;o<l-1;){if(-1===(a=n.call(i[0],s[o])))return;u.push(i,a),i=i[1][a],++o}if(-1===(a=n.call(i[0],s[o])))return;for(e=i[1][a],i[0].splice(a,1),i[1].splice(a,1);!i[0].length&&u.length;)a=u.pop(),(i=u.pop())[0].splice(a,1),i[1].splice(a,1)}delete r[e]},clear:function(){t=[],r=a(null)}}}},{"es5-ext/array/#/e-index-of":159}],233:[function(e,t,r){"use strict";t.exports=function(e){var t,r,n=e.length;if(!n)return"";for(t=String(e[r=0]);--n;)t+=""+e[++r];return t}},{}],234:[function(e,t,r){"use strict";var n=e("es5-ext/object/valid-callable"),a=e("es5-ext/object/for-each"),o=e("./lib/registered-extensions"),i=e("./lib/configure-map"),s=e("./lib/resolve-length");t.exports=function e(t){var r,l,u;if(n(t),(r=Object(arguments[1])).async&&r.promise)throw new Error("Options \'async\' and \'promise\' cannot be used together");return hasOwnProperty.call(t,"__memoized__")&&!r.force?t:(l=s(r.length,t.length,r.async&&o.async),u=i(t,l,r),a(o,function(e,t){r[t]&&e(r[t],u,r)}),e.__profiler__&&e.__profiler__(u),u.updateEnv(),u.memoized)}},{"./lib/configure-map":224,"./lib/registered-extensions":225,"./lib/resolve-length":226,"es5-ext/object/for-each":181,"es5-ext/object/valid-callable":192}],235:[function(e,t,r){(function(e,r){"use strict";var a,o;a=function(e){if("function"!=typeof e)throw new TypeError(e+" is not a function");return e},o=function(e){var t,r,o=n.createTextNode(""),i=0;return new e(function(){var e;if(t)r&&(t=r.concat(t));else{if(!r)return;t=r}if(r=t,t=null,"function"==typeof r)return e=r,r=null,void e();for(o.data=i=++i%2;r;)e=r.shift(),r.length||(r=null),e()}).observe(o,{characterData:!0}),function(e){a(e),t?"function"==typeof t?t=[t,e]:t.push(e):(t=e,o.data=i=++i%2)}},t.exports=function(){if("object"==typeof e&&e&&"function"==typeof e.nextTick)return e.nextTick;if("object"==typeof n&&n){if("function"==typeof MutationObserver)return o(MutationObserver);if("function"==typeof WebKitMutationObserver)return o(WebKitMutationObserver)}return"function"==typeof r?function(e){r(a(e))}:"function"==typeof setTimeout||"object"==typeof setTimeout?function(e){setTimeout(a(e),0)}:null}()}).call(this,e("_process"),e("timers").setImmediate)},{_process:236,timers:237}],236:[function(e,t,r){var n,a,o=t.exports={};function i(){throw new Error("setTimeout has not been defined")}function s(){throw new Error("clearTimeout has not been defined")}function l(e){if(n===setTimeout)return setTimeout(e,0);if((n===i||!n)&&setTimeout)return n=setTimeout,setTimeout(e,0);try{return n(e,0)}catch(t){try{return n.call(null,e,0)}catch(t){return n.call(this,e,0)}}}!function(){try{n="function"==typeof setTimeout?setTimeout:i}catch(e){n=i}try{a="function"==typeof clearTimeout?clearTimeout:s}catch(e){a=s}}();var u,c=[],d=!1,p=-1;function m(){d&&u&&(d=!1,u.length?c=u.concat(c):p=-1,c.length&&f())}function f(){if(!d){var e=l(m);d=!0;for(var t=c.length;t;){for(u=c,c=[];++p<t;)u&&u[p].run();p=-1,t=c.length}u=null,d=!1,function(e){if(a===clearTimeout)return clearTimeout(e);if((a===s||!a)&&clearTimeout)return a=clearTimeout,clearTimeout(e);try{a(e)}catch(t){try{return a.call(null,e)}catch(t){return a.call(this,e)}}}(e)}}function h(e,t){this.fun=e,this.array=t}function b(){}o.nextTick=function(e){var t=new Array(arguments.length-1);if(1<arguments.length)for(var r=1;r<arguments.length;r++)t[r-1]=arguments[r];c.push(new h(e,t)),1!==c.length||d||l(f)},h.prototype.run=function(){this.fun.apply(null,this.array)},o.title="browser",o.browser=!0,o.env={},o.argv=[],o.version="",o.versions={},o.on=b,o.addListener=b,o.once=b,o.off=b,o.removeListener=b,o.removeAllListeners=b,o.emit=b,o.prependListener=b,o.prependOnceListener=b,o.listeners=function(e){return[]},o.binding=function(e){throw new Error("process.binding is not supported")},o.cwd=function(){return"/"},o.chdir=function(e){throw new Error("process.chdir is not supported")},o.umask=function(){return 0}},{}],237:[function(e,r,n){(function(r,a){var o=e("process/browser.js").nextTick,i=Function.prototype.apply,s=Array.prototype.slice,l={},u=0;function c(e,t){this._id=e,this._clearFn=t}n.setTimeout=function(){return new c(i.call(setTimeout,t,arguments),clearTimeout)},n.setInterval=function(){return new c(i.call(setInterval,t,arguments),clearInterval)},n.clearTimeout=n.clearInterval=function(e){e.close()},c.prototype.unref=c.prototype.ref=function(){},c.prototype.close=function(){this._clearFn.call(t,this._id)},n.enroll=function(e,t){clearTimeout(e._idleTimeoutId),e._idleTimeout=t},n.unenroll=function(e){clearTimeout(e._idleTimeoutId),e._idleTimeout=-1},n._unrefActive=n.active=function(e){clearTimeout(e._idleTimeoutId);var t=e._idleTimeout;0<=t&&(e._idleTimeoutId=setTimeout(function(){e._onTimeout&&e._onTimeout()},t))},n.setImmediate="function"==typeof r?r:function(e){var t=u++,r=!(arguments.length<2)&&s.call(arguments,1);return l[t]=!0,o(function(){l[t]&&(r?e.apply(null,r):e.call(null),n.clearImmediate(t))}),t},n.clearImmediate="function"==typeof a?a:function(e){delete l[e]}}).call(this,e("timers").setImmediate,e("timers").clearImmediate)},{"process/browser.js":236,timers:237}],238:[function(e,t,r){"use strict";t.exports=2147483647},{}],239:[function(e,t,r){"use strict";var n=e("es5-ext/number/to-pos-integer"),a=e("./max-timeout");t.exports=function(e){if(e=n(e),a<e)throw new TypeError(e+" exceeds maximum possible timeout");return e}},{"./max-timeout":238,"es5-ext/number/to-pos-integer":176}],240:[function(e,t,r){"use strict";var n=e("../prototype/is");t.exports=function(e){if("function"!=typeof e)return!1;if(!hasOwnProperty.call(e,"length"))return!1;try{if("number"!=typeof e.length)return!1;if("function"!=typeof e.call)return!1;if("function"!=typeof e.apply)return!1}catch(e){return!1}return!n(e)}},{"../prototype/is":243}],241:[function(e,t,r){"use strict";var n=e("../value/is"),a={object:!0,function:!0,undefined:!0};t.exports=function(e){return!!n(e)&&hasOwnProperty.call(a,typeof e)}},{"../value/is":244}],242:[function(e,t,r){"use strict";var n=e("../function/is"),a=/^\\s*class[\\s{/}]/,o=Function.prototype.toString;t.exports=function(e){return!!n(e)&&!a.test(o.call(e))}},{"../function/is":240}],243:[function(e,t,r){"use strict";var n=e("../object/is");t.exports=function(e){if(!n(e))return!1;try{return!!e.constructor&&e.constructor.prototype===e}catch(e){return!1}}},{"../object/is":241}],244:[function(e,t,r){"use strict";t.exports=function(e){return null!=e}},{}],245:[function(e,n,a){(function(e){!function(e){"use strict";if(!e.WeakMap){var t=Object.prototype.hasOwnProperty,r=function(e,t,r){Object.defineProperty?Object.defineProperty(e,t,{configurable:!0,writable:!0,value:r}):e[t]=r};e.WeakMap=(r(n.prototype,"delete",function(e){if(a(this,"delete"),!i(e))return!1;var t=e[this._id];return!(!t||t[0]!==e||(delete e[this._id],0))}),r(n.prototype,"get",function(e){if(a(this,"get"),i(e)){var t=e[this._id];return t&&t[0]===e?t[1]:void 0}}),r(n.prototype,"has",function(e){if(a(this,"has"),!i(e))return!1;var t=e[this._id];return!(!t||t[0]!==e)}),r(n.prototype,"set",function(e,t){if(a(this,"set"),!i(e))throw new TypeError("Invalid value used as weak map key");var n=e[this._id];return n&&n[0]===e?n[1]=t:r(e,this._id,[e,t]),this}),r(n,"_polyfill",!0),n)}function n(){if(void 0===this)throw new TypeError("Constructor WeakMap requires \'new\'");if(r(this,"_id","_WeakMap_"+o()+"."+o()),0<arguments.length)throw new TypeError("WeakMap iterable is not supported")}function a(e,r){if(!i(e)||!t.call(e,"_id"))throw new TypeError(r+" method called on incompatible receiver "+typeof e)}function o(){return Math.random().toString().substring(2)}function i(e){return Object(e)===e}}("undefined"!=typeof self?self:void 0!==t?t:void 0!==e?e:this)}).call(this,void 0!==r?r:"undefined"!=typeof self?self:void 0!==t?t:{})},{}]},{},[1]);var i=re.utils={},s={};function a(e){return(a="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function l(){return(l=Object.assign||function(e){for(var t=1;t<arguments.length;t++){var r=arguments[t];for(var n in r)Object.prototype.hasOwnProperty.call(r,n)&&(e[n]=r[n])}return e}).apply(this,arguments)}var u=/\\{\\{.+?\\}\\}/g;function c(e,t,r){"use strict";var n,a;for(n=0,a=e.length;n<a;n++)t[r](e[n])}function d(e){this.brand="axe",this.application="axeAPI",this.tagExclude=["experimental"],this.lang="en",this.defaultConfig=e,this._init(),this._defaultLocale=null}function p(e,t,r){return r.performanceTimer&&re.utils.performanceTimer.mark("mark_rule_start_"+e.id),function(n,a){e.run(t,r,function(e){n(e)},function(t){if(r.debug)a(t);else{var o=Object.assign(new w(e),{result:re.constants.CANTTELL,description:"An error occured while running this rule",message:t.message,stack:t.stack,error:t,errorNode:t.errorNode});n(o)}})}}function m(e,t,r){var n=e.brand,a=e.application,o=e.lang;return re.constants.helpUrlBase+n+"/"+(r||re.version.substring(0,re.version.lastIndexOf(".")))+"/"+t+"?application="+encodeURIComponent(a)+(o&&"en"!==o?"&lang="+encodeURIComponent(o):"")}function f(e){"use strict";this.id=e.id,this.data=null,this.relatedNodes=[],this.result=null}function h(e){"use strict";return"string"==typeof e?new Function("return "+e+";")():e}function b(e){e&&(this.id=e.id,this.configure(e))}function a(e){return(a="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function g(e,t,r){"use strict";var a,o;e.frames=e.frames||[];var i=n.querySelectorAll(r.shift());e:for(var s=0,l=i.length;s<l;s++){o=i[s];for(var u=0,c=e.frames.length;u<c;u++)if(e.frames[u].node===o){e.frames[u][t].push(r);break e}a={node:o,include:[],exclude:[]},r&&a[t].push(r),e.frames.push(a)}}function y(e,t){"use strict";for(var r,a,o=[],i=0,s=e[t].length;i<s;i++){if("string"==typeof(r=e[t][i])){a=Array.from(n.querySelectorAll(r)),o=o.concat(a.map(function(e){return re.utils.getNodeFromTree(e)}));break}!r||!r.length||r instanceof Node?r instanceof Node&&(r.documentElement instanceof Node?o.push(e.flatTree[0]):o.push(re.utils.getNodeFromTree(r))):1<r.length?g(e,t,r):(a=Array.from(n.querySelectorAll(r[0])),o=o.concat(a.map(function(e){return re.utils.getNodeFromTree(e)})))}return o.filter(function(e){return e})}function v(e){"use strict";var t=this;this.frames=[],this.initiator=!e||"boolean"!=typeof e.initiator||e.initiator,this.page=!1,e=function(e){if(e&&"object"===a(e)||e instanceof NodeList){if(e instanceof Node)return{include:[e],exclude:[]};if(e.hasOwnProperty("include")||e.hasOwnProperty("exclude"))return{include:e.include&&+e.include.length?e.include:[n],exclude:e.exclude||[]};if(e.length===+e.length)return{include:e,exclude:[]}}return"string"==typeof e?{include:[e],exclude:[]}:{include:[n],exclude:[]}}(e),this.flatTree=re.utils.getFlattenedTree(function(e){for(var t=e.include,r=e.exclude,a=Array.from(t).concat(Array.from(r)),o=0;o<a.length;++o){var i=a[o];if(i instanceof Element)return i.ownerDocument.documentElement;if(i instanceof Document)return i.documentElement}return n.documentElement}(e)),this.exclude=e.exclude,this.include=e.include,this.include=y(this,"include"),this.exclude=y(this,"exclude"),re.utils.select("frame, iframe",this).forEach(function(e){We(e,t)&&function(e,t){re.utils.isHidden(t)||re.utils.findBy(e,"node",t)||e.push({node:t,include:[],exclude:[]})}(t.frames,e.actualNode)}),1===this.include.length&&this.include[0].actualNode===n.documentElement&&(this.page=!0);var r=function(e){if(0===e.include.length){if(0===e.frames.length){var t=re.utils.respondable.isInFrame()?"frame":"page";return new Error("No elements found for include in "+t+" Context")}e.frames.forEach(function(e,t){if(0===e.include.length)return new Error("No elements found for include in Context of frame "+t)})}}(this);if(r instanceof Error)throw r;Array.isArray(this.include)||(this.include=Array.from(this.include)),this.include.sort(re.utils.nodeSorter)}function w(e){"use strict";this.id=e.id,this.result=re.constants.NA,this.pageLevel=e.pageLevel,this.impact=null,this.nodes=[]}function x(e,t){"use strict";this._audit=t,this.id=e.id,this.selector=e.selector||"*",this.excludeHidden="boolean"!=typeof e.excludeHidden||e.excludeHidden,this.enabled="boolean"!=typeof e.enabled||e.enabled,this.pageLevel="boolean"==typeof e.pageLevel&&e.pageLevel,this.any=e.any||[],this.all=e.all||[],this.none=e.none||[],this.tags=e.tags||[],this.preload=!!e.preload,e.matches&&(this.matches=h(e.matches))}function D(e){if(e.length){var t=!1,r={};return e.forEach(function(e){var n=e.results.filter(function(e){return e});(r[e.type]=n).length&&(t=!0)}),t?r:null}}function k(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}function E(e,t){for(var r=0;r<t.length;r++){var n=t[r];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}function A(e,t,r){return t&&E(e.prototype,t),r&&E(e,r),e}d.prototype._setDefaultLocale=function(){if(!this._defaultLocale){for(var e={checks:{},rules:{},failureSummaries:{},incompleteFallbackMessage:"",lang:this.lang},t=Object.keys(this.data.checks),r=0;r<t.length;r++){var n=t[r],a=this.data.checks[n].messages,o=a.pass,i=a.fail,s=a.incomplete;e.checks[n]={pass:o,fail:i,incomplete:s}}for(var l=Object.keys(this.data.rules),u=0;u<l.length;u++){var c=l[u],d=this.data.rules[c],p=d.description,m=d.help;e.rules[c]={description:p,help:m}}for(var f=Object.keys(this.data.failureSummaries),h=0;h<f.length;h++){var b=f[h],g=this.data.failureSummaries[b].failureMessage;e.failureSummaries[b]={failureMessage:g}}e.incompleteFallbackMessage=this.data.incompleteFallbackMessage,this._defaultLocale=e}},d.prototype._resetLocale=function(){var e=this._defaultLocale;e&&this.applyLocale(e)},d.prototype._applyCheckLocale=function(e){for(var t,r,n,o,i=Object.keys(e),s=0;s<i.length;s++){var c=i[s];if(!this.data.checks[c])throw new Error(\'Locale provided for unknown check: "\'.concat(c,\'"\'));this.data.checks[c]=(t=this.data.checks[c],o=n=void 0,n=(r=e[c]).pass,o=r.fail,"string"==typeof n&&u.test(n)&&(n=re.imports.doT.compile(n)),"string"==typeof o&&u.test(o)&&(o=re.imports.doT.compile(o)),l({},t,{messages:{pass:n||t.messages.pass,fail:o||t.messages.fail,incomplete:"object"===a(t.messages.incomplete)?l({},t.messages.incomplete,{},r.incomplete):r.incomplete}}))}},d.prototype._applyRuleLocale=function(e){for(var t,r,n,a,o=Object.keys(e),i=0;i<o.length;i++){var s=o[i];if(!this.data.rules[s])throw new Error(\'Locale provided for unknown rule: "\'.concat(s,\'"\'));this.data.rules[s]=(t=this.data.rules[s],a=n=void 0,n=(r=e[s]).help,a=r.description,"string"==typeof n&&u.test(n)&&(n=re.imports.doT.compile(n)),"string"==typeof a&&u.test(a)&&(a=re.imports.doT.compile(a)),l({},t,{help:n||t.help,description:a||t.description}))}},d.prototype._applyFailureSummaries=function(e){for(var t,r,n=Object.keys(e),a=0;a<n.length;a++){var o=n[a];if(!this.data.failureSummaries[o])throw new Error(\'Locale provided for unknown failureMessage: "\'.concat(o,\'"\'));this.data.failureSummaries[o]=(t=this.data.failureSummaries[o],r=void 0,"string"==typeof(r=e[o].failureMessage)&&u.test(r)&&(r=re.imports.doT.compile(r)),l({},t,{failureMessage:r||t.failureMessage}))}},d.prototype.applyLocale=function(e){var t,r;this._setDefaultLocale(),e.checks&&this._applyCheckLocale(e.checks),e.rules&&this._applyRuleLocale(e.rules),e.failureSummaries&&this._applyFailureSummaries(e.failureSummaries,"failureSummaries"),e.incompleteFallbackMessage&&(this.data.incompleteFallbackMessage=(t=this.data.incompleteFallbackMessage,"string"==typeof(r=e.incompleteFallbackMessage)&&u.test(r)&&(r=re.imports.doT.compile(r)),r||t)),e.lang&&(this.lang=e.lang)},d.prototype._init=function(){var e=function(e){"use strict";var t;return e?(t=re.utils.clone(e)).commons=e.commons:t={},t.reporter=t.reporter||null,t.rules=t.rules||[],t.checks=t.checks||[],t.data=l({checks:{},rules:{}},t.data),t}(this.defaultConfig);re.commons=e.commons,this.lang=e.lang||"en",this.reporter=e.reporter,this.commands={},this.rules=[],this.checks={},c(e.rules,this,"addRule"),c(e.checks,this,"addCheck"),this.data={},this.data.checks=e.data&&e.data.checks||{},this.data.rules=e.data&&e.data.rules||{},this.data.failureSummaries=e.data&&e.data.failureSummaries||{},this.data.incompleteFallbackMessage=e.data&&e.data.incompleteFallbackMessage||"",this._constructHelpUrls()},d.prototype.registerCommand=function(e){"use strict";this.commands[e.id]=e.callback},d.prototype.addRule=function(e){"use strict";e.metadata&&(this.data.rules[e.id]=e.metadata);var t=this.getRule(e.id);t?t.configure(e):this.rules.push(new x(e,this))},d.prototype.addCheck=function(e){"use strict";var t=e.metadata;"object"===a(t)&&(this.data.checks[e.id]=t,"object"===a(t.messages)&&Object.keys(t.messages).filter(function(e){return t.messages.hasOwnProperty(e)&&"string"==typeof t.messages[e]}).forEach(function(e){0===t.messages[e].indexOf("function")&&(t.messages[e]=new Function("return "+t.messages[e]+";")())})),this.checks[e.id]?this.checks[e.id].configure(e):this.checks[e.id]=new b(e)},d.prototype.run=function(e,t,r,n){"use strict";this.normalizeOptions(t),re._selectCache=[];var a,o,i,s=(a=this.rules,o=e,i=t,a.reduce(function(e,t){return re.utils.ruleShouldRun(t,o,i)&&(t.preload?e.later.push(t):e.now.push(t)),e},{now:[],later:[]})),u=s.now,c=s.later,d=re.utils.queue();u.forEach(function(r){d.defer(p(r,e,t))});var m=re.utils.queue();c.length&&m.defer(function(e){re.utils.preload(t).then(function(t){return e(t)}).catch(function(t){console.warn("Couldn\'t load preload assets: ",t),e(void 0)})});var f=re.utils.queue();f.defer(d),f.defer(m),f.then(function(a){var o=a.pop();if(o&&o.length){var i=o[0];i&&(e=l({},e,{},i))}var s=a[0];if(!c.length)return re._selectCache=void 0,void r(s.filter(function(e){return!!e}));var u=re.utils.queue();c.forEach(function(r){var n=p(r,e,t);u.defer(n)}),u.then(function(e){re._selectCache=void 0,r(s.concat(e).filter(function(e){return!!e}))}).catch(n)}).catch(n)},d.prototype.after=function(e,t){"use strict";var r=this.rules;return e.map(function(e){var n=re.utils.findBy(r,"id",e.id);if(!n)throw new Error("Result for unknown rule. You may be running mismatch axe-core versions");return n.after(e,t)})},d.prototype.getRule=function(e){return this.rules.find(function(t){return t.id===e})},d.prototype.normalizeOptions=function(e){"use strict";var t=[],r=[];if(this.rules.forEach(function(e){r.push(e.id),e.tags.forEach(function(e){t.includes(e)||t.push(e)})}),"object"===a(e.runOnly)){if(Array.isArray(e.runOnly)){var n=e.runOnly.find(function(e){return t.includes(e)}),o=e.runOnly.find(function(e){return r.includes(e)});if(n&&o)throw new Error("runOnly cannot be both rules and tags");e.runOnly=o?{type:"rule",values:e.runOnly}:{type:"tag",values:e.runOnly}}var i=e.runOnly;if(i.value&&!i.values&&(i.values=i.value,delete i.value),!Array.isArray(i.values)||0===i.values.length)throw new Error("runOnly.values must be a non-empty array");if(["rule","rules"].includes(i.type))i.type="rule",i.values.forEach(function(e){if(!r.includes(e))throw new Error("unknown rule `"+e+"` in options.runOnly")});else{if(!["tag","tags",void 0].includes(i.type))throw new Error("Unknown runOnly type \'".concat(i.type,"\'"));i.type="tag";var s=i.values.filter(function(e){return!t.includes(e)});0!==s.length&&re.log("Could not find tags `"+s.join("`, `")+"`")}}return"object"===a(e.rules)&&Object.keys(e.rules).forEach(function(e){if(!r.includes(e))throw new Error("unknown rule `"+e+"` in options.rules")}),e},d.prototype.setBranding=function(e){"use strict";var t={brand:this.brand,application:this.application};e&&e.hasOwnProperty("brand")&&e.brand&&"string"==typeof e.brand&&(this.brand=e.brand),e&&e.hasOwnProperty("application")&&e.application&&"string"==typeof e.application&&(this.application=e.application),this._constructHelpUrls(t)},d.prototype._constructHelpUrls=function(){var e=this,t=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null,r=(re.version.match(/^[1-9][0-9]*\\.[0-9]+/)||["x.y"])[0];this.rules.forEach(function(n){e.data.rules[n.id]||(e.data.rules[n.id]={});var a=e.data.rules[n.id];("string"!=typeof a.helpUrl||t&&a.helpUrl===m(t,n.id,r))&&(a.helpUrl=m(e,n.id,r))})},d.prototype.resetRulesAndChecks=function(){"use strict";this._init(),this._resetLocale()},function(){"use strict";var e={},t={set:function(t,r){e[t]=r},get:function(t){return e[t]},clear:function(){e={}}};re._cache=t}(),b.prototype.enabled=!0,b.prototype.run=function(e,t,r,n,a){"use strict";var o=(t=t||{}).hasOwnProperty("enabled")?t.enabled:this.enabled,i=t.options||this.options;if(o){var s,l=new f(this),u=re.utils.checkHelper(l,t,n,a);try{s=this.evaluate.call(u,e.actualNode,i,e,r)}catch(t){return e&&e.actualNode&&(t.errorNode=new se(e.actualNode).toJSON()),void a(t)}u.isAsync||(l.result=s,n(l))}else n(null)},b.prototype.runSync=function(e,t,r){var n=(t=t||{}).enabled;if(!(void 0===n?this.enabled:n))return null;var a,o=t.options||this.options,i=new f(this),s=re.utils.checkHelper(i,t);s.async=function(){throw new Error("Cannot run async check while in a synchronous run")};try{a=this.evaluate.call(s,e.actualNode,o,e,r)}catch(t){throw e&&e.actualNode&&(t.errorNode=new se(e.actualNode).toJSON()),t}return i.result=a,i},b.prototype.configure=function(e){var t=this;["options","enabled"].filter(function(t){return e.hasOwnProperty(t)}).forEach(function(r){return t[r]=e[r]}),["evaluate","after"].filter(function(t){return e.hasOwnProperty(t)}).forEach(function(r){return t[r]=h(e[r])})},x.prototype.matches=function(){"use strict";return!0},x.prototype.gather=function(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},r="mark_gather_start_"+this.id,n="mark_gather_end_"+this.id,a="mark_isHidden_start_"+this.id,o="mark_isHidden_end_"+this.id;t.performanceTimer&&re.utils.performanceTimer.mark(r);var i=re.utils.select(this.selector,e);return this.excludeHidden&&(t.performanceTimer&&re.utils.performanceTimer.mark(a),i=i.filter(function(e){return!re.utils.isHidden(e.actualNode)}),t.performanceTimer&&(re.utils.performanceTimer.mark(o),re.utils.performanceTimer.measure("rule_"+this.id+"#gather_axe.utils.isHidden",a,o))),t.performanceTimer&&(re.utils.performanceTimer.mark(n),re.utils.performanceTimer.measure("rule_"+this.id+"#gather",r,n)),i},x.prototype.runChecks=function(e,t,r,n,a,o){"use strict";var i=this,s=re.utils.queue();this[e].forEach(function(e){var a=i._audit.checks[e.id||e],o=re.utils.getCheckOption(a,i.id,r);s.defer(function(e,r){a.run(t,o,n,e,r)})}),s.then(function(t){t=t.filter(function(e){return e}),a({type:e,results:t})}).catch(o)},x.prototype.runChecksSync=function(e,t,r,n){"use strict";var a=this,o=[];return this[e].forEach(function(e){var i=a._audit.checks[e.id||e],s=re.utils.getCheckOption(i,a.id,r);o.push(i.runSync(t,s,n))}),{type:e,results:o=o.filter(function(e){return e})}},x.prototype.run=function(e){var t=this,r=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},n=2<arguments.length?arguments[2]:void 0,a=3<arguments.length?arguments[3]:void 0;r.performanceTimer&&this._trackPerformance();var i,s=re.utils.queue(),l=new w(this);try{i=this.gatherAndMatchNodes(e,r)}catch(n){return void a(new o({cause:n,ruleId:this.id}))}r.performanceTimer&&this._logGatherPerformance(i),i.forEach(function(n){s.defer(function(a,o){var i=re.utils.queue();["any","all","none"].forEach(function(a){i.defer(function(o,i){t.runChecks(a,n,r,e,o,i)})}),i.then(function(e){var t=D(e);t&&(t.node=new re.utils.DqElement(n.actualNode,r),l.nodes.push(t)),a()}).catch(function(e){return o(e)})})}),s.defer(function(e){return setTimeout(e,0)}),r.performanceTimer&&this._logRulePerformance(),s.then(function(){return n(l)}).catch(function(e){return a(e)})},x.prototype.runSync=function(e){var t=this,r=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{};r.performanceTimer&&this._trackPerformance();var n,a=new w(this);try{n=this.gatherAndMatchNodes(e,r)}catch(n){throw new o({cause:n,ruleId:this.id})}return r.performanceTimer&&this._logGatherPerformance(n),n.forEach(function(n){var o=[];["any","all","none"].forEach(function(a){o.push(t.runChecksSync(a,n,r,e))});var i=D(o);i&&(i.node=n.actualNode?new re.utils.DqElement(n.actualNode,r):null,a.nodes.push(i))}),r.performanceTimer&&this._logRulePerformance(),a},x.prototype._trackPerformance=function(){this._markStart="mark_rule_start_"+this.id,this._markEnd="mark_rule_end_"+this.id,this._markChecksStart="mark_runchecks_start_"+this.id,this._markChecksEnd="mark_runchecks_end_"+this.id},x.prototype._logGatherPerformance=function(e){re.log("gather (",e.length,"):",re.utils.performanceTimer.timeElapsed()+"ms"),re.utils.performanceTimer.mark(this._markChecksStart)},x.prototype._logRulePerformance=function(){re.utils.performanceTimer.mark(this._markChecksEnd),re.utils.performanceTimer.mark(this._markEnd),re.utils.performanceTimer.measure("runchecks_"+this.id,this._markChecksStart,this._markChecksEnd),re.utils.performanceTimer.measure("rule_"+this.id,this._markStart,this._markEnd)},x.prototype.gatherAndMatchNodes=function(e,t){var r=this,n="mark_matches_start_"+this.id,a="mark_matches_end_"+this.id,o=this.gather(e,t);return t.performanceTimer&&re.utils.performanceTimer.mark(n),o=o.filter(function(t){return r.matches(t.actualNode,t,e)}),t.performanceTimer&&(re.utils.performanceTimer.mark(a),re.utils.performanceTimer.measure("rule_"+this.id+"#matches",n,a)),o},x.prototype.after=function(e,t){"use strict";var r=function(e){return re.utils.getAllChecks(e).map(function(t){var r=e._audit.checks[t.id||t];return r&&"function"==typeof r.after?r:null}).filter(Boolean)}(this),n=this.id;return r.forEach(function(r){var a=function(e,t){var r=[];return e.forEach(function(e){re.utils.getAllChecks(e).forEach(function(e){e.id===t&&r.push(e)})}),r}(e.nodes,r.id),o=re.utils.getCheckOption(r,n,t),i=r.after(a,o);a.forEach(function(e){-1===i.indexOf(e)&&(e.filtered=!0)})}),e.nodes=function(e){"use strict";var t=["any","all","none"],r=e.nodes.filter(function(e){var r=0;return t.forEach(function(t){e[t]=function(e){return e.filter(function(e){return!0!==e.filtered})}(e[t]),r+=e[t].length}),0<r});return e.pageLevel&&r.length&&(r=[r.reduce(function(e,r){if(e)return t.forEach(function(t){e[t].push.apply(e[t],r[t])}),e})]),r}(e),e},x.prototype.configure=function(e){"use strict";e.hasOwnProperty("selector")&&(this.selector=e.selector),e.hasOwnProperty("excludeHidden")&&(this.excludeHidden="boolean"!=typeof e.excludeHidden||e.excludeHidden),e.hasOwnProperty("enabled")&&(this.enabled="boolean"!=typeof e.enabled||e.enabled),e.hasOwnProperty("pageLevel")&&(this.pageLevel="boolean"==typeof e.pageLevel&&e.pageLevel),e.hasOwnProperty("any")&&(this.any=e.any),e.hasOwnProperty("all")&&(this.all=e.all),e.hasOwnProperty("none")&&(this.none=e.none),e.hasOwnProperty("tags")&&(this.tags=e.tags),e.hasOwnProperty("matches")&&("string"==typeof e.matches?this.matches=new Function("return "+e.matches+";")():this.matches=e.matches)};var j=/[\\t\\r\\n\\f]/g,C=(A(F,[{key:"attr",value:function(){throw new Error(\'VirtualNode class must have a "attr" function\')}},{key:"hasAttr",value:function(){throw new Error(\'VirtualNode class must have a "hasAttr" function\')}},{key:"hasClass",value:function(e){var t=this.attr("class");if(!t)return!1;var r=" "+e+" ";return 0<=(" "+t+" ").replace(j," ").indexOf(r)}},{key:"props",get:function(){throw new Error(\'VirtualNode class must have a "props" object consisting of "nodeType" and "nodeName" properties\')}}]),F);function F(){k(this,F),this.children=[],this.parent=null}function l(){return(l=Object.assign||function(e){for(var t=1;t<arguments.length;t++){var r=arguments[t];for(var n in r)Object.prototype.hasOwnProperty.call(r,n)&&(e[n]=r[n])}return e}).apply(this,arguments)}function a(e){return(a="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function k(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}function E(e,t){for(var r=0;r<t.length;r++){var n=t[r];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}function A(e,t,r){return t&&E(e.prototype,t),r&&E(e,r),e}function T(e,t){return!t||"object"!==a(t)&&"function"!=typeof t?N(e):t}function N(e){if(void 0===e)throw new ReferenceError("this hasn\'t been initialised - super() hasn\'t been called");return e}function S(e){return(S=Object.setPrototypeOf?Object.getPrototypeOf:function(e){return e.__proto__||Object.getPrototypeOf(e)})(e)}function z(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function");e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,writable:!0,configurable:!0}}),t&&q(e,t)}function q(e,t){return(q=Object.setPrototypeOf||function(e,t){return e.__proto__=t,e})(e,t)}re.AbstractVirtualNode=C;var O,_=(z(R,re.AbstractVirtualNode),A(R,[{key:"attr",value:function(e){return this._attrs[e]||null}},{key:"hasAttr",value:function(e){return void 0!==this._attrs[e]}},{key:"props",get:function(){return this._props}}]),R);function R(e){var t,r,n,o;return k(this,R),(t=T(this,S(R).call(this)))._props=function(e){var t=e.nodeName,r=e.nodeType,n=void 0===r?1:r;re.utils.assert(1===n,"nodeType has to be undefined or 1, got \'".concat(n,"\'")),re.utils.assert("string"==typeof t,"nodeName has to be a string, got \'".concat(t,"\'"));var a=l({},e,{nodeType:n,nodeName:t.toLowerCase()});return delete a.attributes,Object.freeze(a)}(e),t._attrs=(r=e.attributes,n=void 0===r?{}:r,o={htmlFor:"for",className:"class"},Object.keys(n).reduce(function(e,t){var r=n[t];return re.utils.assert("object"!==a(r)||null===r,"expects attributes not to be an object, \'".concat(t,"\' was")),void 0!==r&&(e[o[t]||t]=null!==r?String(r):null),e},{})),t}function a(e){return(a="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function k(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}function E(e,t){for(var r=0;r<t.length;r++){var n=t[r];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}function A(e,t,r){return t&&E(e.prototype,t),r&&E(e,r),e}function T(e,t){return!t||"object"!==a(t)&&"function"!=typeof t?N(e):t}function S(e){return(S=Object.setPrototypeOf?Object.getPrototypeOf:function(e){return e.__proto__||Object.getPrototypeOf(e)})(e)}function N(e){if(void 0===e)throw new ReferenceError("this hasn\'t been initialised - super() hasn\'t been called");return e}function z(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function");e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,writable:!0,configurable:!0}}),t&&q(e,t)}function q(e,t){return(q=Object.setPrototypeOf||function(e,t){return e.__proto__=t,e})(e,t)}re.SerialVirtualNode=_;var P=(z(I,re.AbstractVirtualNode),A(I,[{key:"attr",value:function(e){return"function"!=typeof this.actualNode.getAttribute?null:this.actualNode.getAttribute(e)}},{key:"hasAttr",value:function(e){return"function"==typeof this.actualNode.hasAttribute&&this.actualNode.hasAttribute(e)}},{key:"getComputedStylePropertyValue",value:function(e){var r="computedStyle_"+e;return this._cache.hasOwnProperty(r)||(this._cache.hasOwnProperty("computedStyle")||(this._cache.computedStyle=t.getComputedStyle(this.actualNode)),this._cache[r]=this._cache.computedStyle.getPropertyValue(e)),this._cache[r]}},{key:"props",get:function(){var e=this.actualNode,t=e.nodeType,r=e.nodeName,n=e.id,a=e.type,o=e.multiple;return{nodeType:t,nodeName:this._isXHTML?r:r.toLowerCase(),id:n,type:a,multiple:o}}},{key:"isFocusable",get:function(){return this._cache.hasOwnProperty("isFocusable")||(this._cache.isFocusable=re.commons.dom.isFocusable(this.actualNode)),this._cache.isFocusable}},{key:"tabbableElements",get:function(){return this._cache.hasOwnProperty("tabbableElements")||(this._cache.tabbableElements=re.commons.dom.getTabbableElements(this)),this._cache.tabbableElements}},{key:"clientRects",get:function(){return this._cache.hasOwnProperty("clientRects")||(this._cache.clientRects=Array.from(this.actualNode.getClientRects()).filter(function(e){return 0<e.width})),this._cache.clientRects}},{key:"boundingClientRect",get:function(){return this._cache.hasOwnProperty("boundingClientRect")||(this._cache.boundingClientRect=this.actualNode.getBoundingClientRect()),this._cache.boundingClientRect}}]),I);function I(e,t,r){var n;return k(this,I),(n=T(this,S(I).call(this))).shadowId=r,n.children=[],n.actualNode=e,n.parent=t,n._isHidden=null,n._cache={},void 0===O&&(O=re.utils.isXHTML(e.ownerDocument)),n._isXHTML=O,re._cache.get("nodeMap")&&re._cache.get("nodeMap").set(e,N(n)),n}function a(e){return(a="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function L(e,t){"use strict";if(e=e||function(){},t=t||re.log,!re._audit)throw new Error("No audit configured");var r=re.utils.queue(),a=[];Object.keys(re.plugins).forEach(function(e){r.defer(function(t){function r(e){a.push(e),t()}try{re.plugins[e].cleanup(t,r)}catch(e){r(e)}})});var o=re.utils.getFlattenedTree(n.body);re.utils.querySelectorAll(o,"iframe, frame").forEach(function(e){r.defer(function(t,r){return re.utils.sendCommandToFrame(e.actualNode,{command:"cleanup-plugin"},t,r)})}),r.then(function(r){0===a.length?e(r):t(a)}).catch(t)}function B(e,t){return function(e){if(Array.isArray(e))return e}(e)||function(e,t){if(Symbol.iterator in Object(e)||"[object Arguments]"===Object.prototype.toString.call(e)){var r=[],n=!0,a=!1,o=void 0;try{for(var i,s=e[Symbol.iterator]();!(n=(i=s.next()).done)&&(r.push(i.value),!t||r.length!==t);n=!0);}catch(e){a=!0,o=e}finally{try{n||null==s.return||s.return()}finally{if(a)throw o}}return r}}(e,t)||function(){throw new TypeError("Invalid attempt to destructure non-iterable instance")}()}function M(){throw new TypeError("Invalid attempt to destructure non-iterable instance")}function V(e,t){if(Symbol.iterator in Object(e)||"[object Arguments]"===Object.prototype.toString.call(e)){var r=[],n=!0,a=!1,o=void 0;try{for(var i,s=e[Symbol.iterator]();!(n=(i=s.next()).done)&&(r.push(i.value),!t||r.length!==t);n=!0);}catch(e){a=!0,o=e}finally{try{n||null==s.return||s.return()}finally{if(a)throw o}}return r}}function U(e){if(Array.isArray(e))return e}function H(e,t,r){"use strict";function a(e){e instanceof Error==0&&(e=new Error(e)),r(e)}var o=r,i=e&&e.context||{};i.hasOwnProperty("include")&&!i.include.length&&(i.include=[n]);var s=e&&e.options||{};switch(e.command){case"rules":return K(i,s,function(e,t){o(e),t()},a);case"cleanup-plugin":return L(o,a);default:if(re._audit&&re._audit.commands&&re._audit.commands[e.command])return re._audit.commands[e.command](e,r)}}function $(e){"use strict";this._run=e.run,this._collect=e.collect,this._registry={},e.commands.forEach(function(e){re._audit.registerCommand(e)})}re.VirtualNode=P,function(e){var t={helpUrlBase:"https://dequeuniversity.com/rules/",results:[],resultGroups:[],resultGroupMap:{},impact:Object.freeze(["minor","moderate","serious","critical"]),preload:Object.freeze({assets:["cssom","media"],timeout:1e4})};[{name:"NA",value:"inapplicable",priority:0,group:"inapplicable"},{name:"PASS",value:"passed",priority:1,group:"passes"},{name:"CANTTELL",value:"cantTell",priority:2,group:"incomplete"},{name:"FAIL",value:"failed",priority:3,group:"violations"}].forEach(function(e){var r=e.name,n=e.value,a=e.priority,o=e.group;t[r]=n,t[r+"_PRIO"]=a,t[r+"_GROUP"]=o,t.results[a]=n,t.resultGroups[a]=o,t.resultGroupMap[n]=o}),Object.freeze(t.results),Object.freeze(t.resultGroups),Object.freeze(t.resultGroupMap),Object.freeze(t),Object.defineProperty(e,"constants",{value:t,enumerable:!0,configurable:!1,writable:!1})}(re),re.log=function(){"use strict";"object"===("undefined"==typeof console?"undefined":a(console))&&console.log&&Function.prototype.apply.call(console.log,console,arguments)},re.cleanup=L,re.configure=function(e){"use strict";var t;if(!(t=re._audit))throw new Error("No audit configured");if(e.axeVersion||e.ver){var r=e.axeVersion||e.ver;if(!/^\\d+\\.\\d+\\.\\d+(-canary)?/.test(r))throw new Error("Invalid configured version ".concat(r));var n=r.split("-"),a=B(n,2),o=a[0],i=a[1],s=o.split(".").map(Number),l=B(s,3),u=l[0],c=l[1],d=l[2],p=re.version.split("-"),m=B(p,2),f=m[0],h=m[1],b=f.split(".").map(Number),g=B(b,3),y=g[0],v=g[1],w=g[2];if(u!==y||v<c||v===c&&w<d||u===y&&c===v&&d===w&&i&&i!==h)throw new Error("Configured version ".concat(r," is not compatible with current axe version ").concat(re.version))}if(e.reporter&&("function"==typeof e.reporter||W[e.reporter])&&(t.reporter=e.reporter),e.checks){if(!Array.isArray(e.checks))throw new TypeError("Checks property must be an array");e.checks.forEach(function(e){if(!e.id)throw new TypeError("Configured check ".concat(JSON.stringify(e)," is invalid. Checks must be an object with at least an id property"));t.addCheck(e)})}var x=[];if(e.rules){if(!Array.isArray(e.rules))throw new TypeError("Rules property must be an array");e.rules.forEach(function(e){if(!e.id)throw new TypeError("Configured rule ".concat(JSON.stringify(e)," is invalid. Rules must be an object with at least an id property"));x.push(e.id),t.addRule(e)})}e.disableOtherRules&&t.rules.forEach(function(e){!1===x.includes(e.id)&&(e.enabled=!1)}),void 0!==e.branding?t.setBranding(e.branding):t._constructHelpUrls(),e.tagExclude&&(t.tagExclude=e.tagExclude),e.locale&&t.applyLocale(e.locale)},re.getRules=function(e){"use strict";var t=(e=e||[]).length?re._audit.rules.filter(function(t){return!!e.filter(function(e){return-1!==t.tags.indexOf(e)}).length}):re._audit.rules,r=re._audit.data.rules||{};return t.map(function(e){var t=r[e.id]||{};return{ruleId:e.id,description:t.description,help:t.help,helpUrl:t.helpUrl,tags:e.tags}})},re._load=function(e){"use strict";re.utils.respondable.subscribe("axe.ping",function(e,t,r){r({axe:!0})}),re.utils.respondable.subscribe("axe.start",H),re._audit=new d(e)},(re=re||{}).plugins={},$.prototype.run=function(){"use strict";return this._run.apply(this,arguments)},$.prototype.collect=function(){"use strict";return this._collect.apply(this,arguments)},$.prototype.cleanup=function(e){"use strict";var t=re.utils.queue(),r=this;Object.keys(this._registry).forEach(function(e){t.defer(function(t){r._registry[e].cleanup(t)})}),t.then(function(){e()})},$.prototype.add=function(e){"use strict";this._registry[e.id]=e},re.registerPlugin=function(e){"use strict";re.plugins[e.id]=new $(e)};var G,W={};function Y(){re._memoizedFns.forEach(function(e){return e.clear()}),re._cache.clear(),re._tree=void 0,re._selectorData=void 0}function K(e,t,r,n){"use strict";try{e=new v(e),re._tree=e.flatTree,re._selectorData=re.utils.getSelectorData(e.flatTree)}catch(o){return Y(),n(o)}var a,o=re.utils.queue(),i=re._audit;t.performanceTimer&&re.utils.performanceTimer.auditStart(),e.frames.length&&!1!==t.iframes&&o.defer(function(r,n){re.utils.collectResultsFromFrames(e,t,"rules",null,r,n)}),o.defer(function(r,n){t.restoreScroll&&(a=re.utils.getScrollState()),i.run(e,t,r,n)}),o.then(function(o){try{a&&re.utils.setScrollState(a),t.performanceTimer&&re.utils.performanceTimer.auditEnd();var s=re.utils.mergeResults(o.map(function(e){return{results:e}}));e.initiator&&((s=i.after(s,t)).forEach(re.utils.publishMetaData),s=s.map(re.utils.finalizeRuleResult));try{r(s,Y)}catch(o){Y(),re.log(o)}}catch(o){Y(),n(o)}}).catch(function(e){Y(),n(e)})}function l(){return(l=Object.assign||function(e){for(var t=1;t<arguments.length;t++){var r=arguments[t];for(var n in r)Object.prototype.hasOwnProperty.call(r,n)&&(e[n]=r[n])}return e}).apply(this,arguments)}function a(e){return(a="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function X(){}function a(e){return(a="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}re.getReporter=function(e){"use strict";return"string"==typeof e&&W[e]?W[e]:"function"==typeof e?e:G},re.addReporter=function(e,t,r){"use strict";W[e]=t,r&&(G=t)},re.reset=function(){"use strict";var e=re._audit;if(!e)throw new Error("No audit configured");e.resetRulesAndChecks()},re._runRules=K,re.runVirtualRule=function(e,t){var r=2<arguments.length&&void 0!==arguments[2]?arguments[2]:{};r.reporter=r.reporter||re._audit.reporter||"v1",re._selectorData={},t instanceof re.AbstractVirtualNode==0&&(t=new _(t));var n=re._audit.rules.find(function(t){return t.id===e});if(!n)throw new Error("unknown rule `"+e+"`");var a={include:[t]},o=(n=Object.create(n,{excludeHidden:{value:!1}})).runSync(a,r);re.utils.publishMetaData(o),re.utils.finalizeRuleResult(o);var i=re.utils.aggregateResult([o]);return i.violations.forEach(function(e){return e.nodes.forEach(function(e){e.failureSummary=s.failureSummary(e)})}),l({},s.getEnvironmentData(),{},i,{toolOptions:r})},re.run=function(e,t,r){"use strict";if(!re._audit)throw new Error("No audit configured");var o,i=function(e,t,r){"use strict";var o=new TypeError("axe.run arguments are invalid");if(!function(e){switch(!0){case"string"==typeof e:case Array.isArray(e):case Node&&e instanceof Node:case NodeList&&e instanceof NodeList:return 1;case"object"!==a(e):return;case void 0!==e.include:case void 0!==e.exclude:case"number"==typeof e.length:return 1;default:return}}(e)){if(void 0!==r)throw o;r=t,t=e,e=n}if("object"!==a(t)){if(void 0!==r)throw o;r=t,t={}}if("function"!=typeof r&&void 0!==r)throw o;return{context:e,options:t,callback:r||X}}(e,t,r);e=i.context,t=i.options,r=i.callback,t.reporter=t.reporter||re._audit.reporter||"v1",t.performanceTimer&&re.utils.performanceTimer.start();var s=X,l=X;if("function"==typeof Promise&&r===X&&(o=new Promise(function(e,t){s=t,l=e})),re._running){var u="Axe is already running. Use `await axe.run()` to wait for the previous run to finish before starting a new run.";return r(u),s(u),o}return re._running=!0,re._runRules(e,t,function(e,n){function a(e){re._running=!1,n();try{r(null,e)}catch(e){re.log(e)}l(e)}t.performanceTimer&&re.utils.performanceTimer.end();try{var o=re.getReporter(t.reporter)(e,t,a);void 0!==o&&a(o)}catch(e){re._running=!1,n(),r(e),s(e)}},function(e){re._running=!1,r(e),s(e)}),o},s.failureSummary=function(e){"use strict";var t={};return t.none=e.none.concat(e.all),t.any=e.any,Object.keys(t).map(function(e){if(t[e].length){var r=re._audit.data.failureSummaries[e];return r&&"function"==typeof r.failureMessage?r.failureMessage(t[e].map(function(e){return e.message||""})):void 0}}).filter(function(e){return void 0!==e}).join("\\n\\n")},s.getEnvironmentData=function(e){var r=0<arguments.length&&void 0!==e?e:t,n=r.screen,a=void 0===n?{}:n,o=r.navigator,i=void 0===o?{}:o,s=r.location,l=void 0===s?{}:s,u=r.innerHeight,c=r.innerWidth,d=a.msOrientation||a.orientation||a.mozOrientation||{};return{testEngine:{name:"axe-core",version:re.version},testRunner:{name:re._audit.brand},testEnvironment:{userAgent:i.userAgent,windowWidth:c,windowHeight:u,orientationAngle:d.angle,orientationType:d.type},timestamp:(new Date).toISOString(),url:l.href}},s.incompleteFallbackMessage=function(){"use strict";return"function"==typeof re._audit.data.incompleteFallbackMessage?re._audit.data.incompleteFallbackMessage():re._audit.data.incompleteFallbackMessage};var J=re.constants.resultGroups;function l(){return(l=Object.assign||function(e){for(var t=1;t<arguments.length;t++){var r=arguments[t];for(var n in r)Object.prototype.hasOwnProperty.call(r,n)&&(e[n]=r[n])}return e}).apply(this,arguments)}function l(){return(l=Object.assign||function(e){for(var t=1;t<arguments.length;t++){var r=arguments[t];for(var n in r)Object.prototype.hasOwnProperty.call(r,n)&&(e[n]=r[n])}return e}).apply(this,arguments)}function l(){return(l=Object.assign||function(e){for(var t=1;t<arguments.length;t++){var r=arguments[t];for(var n in r)Object.prototype.hasOwnProperty.call(r,n)&&(e[n]=r[n])}return e}).apply(this,arguments)}function l(){return(l=Object.assign||function(e){for(var t=1;t<arguments.length;t++){var r=arguments[t];for(var n in r)Object.prototype.hasOwnProperty.call(r,n)&&(e[n]=r[n])}return e}).apply(this,arguments)}function l(){return(l=Object.assign||function(e){for(var t=1;t<arguments.length;t++){var r=arguments[t];for(var n in r)Object.prototype.hasOwnProperty.call(r,n)&&(e[n]=r[n])}return e}).apply(this,arguments)}s.processAggregate=function(e,t){var r=re.utils.aggregateResult(e);return J.forEach(function(e){t.resultTypes&&!t.resultTypes.includes(e)&&(r[e]||[]).forEach(function(e){Array.isArray(e.nodes)&&0<e.nodes.length&&(e.nodes=[e.nodes[0]])}),r[e]=(r[e]||[]).map(function(e){return e=Object.assign({},e),Array.isArray(e.nodes)&&0<e.nodes.length&&(e.nodes=e.nodes.map(function(e){return"object"===a(e.node)&&(e.html=e.node.source,t.elementRef&&!e.node.fromFrame&&(e.element=e.node.element),!1===t.selectors&&!e.node.fromFrame||(e.target=e.node.selector),t.xpath&&(e.xpath=e.node.xpath)),delete e.result,delete e.node,function(e,t){"use strict";["any","all","none"].forEach(function(r){Array.isArray(e[r])&&e[r].filter(function(e){return Array.isArray(e.relatedNodes)}).forEach(function(e){e.relatedNodes=e.relatedNodes.map(function(e){var r={html:e.source};return t.elementRef&&!e.fromFrame&&(r.element=e.element),!1===t.selectors&&!e.fromFrame||(r.target=e.selector),t.xpath&&(r.xpath=e.xpath),r})})})}(e,t),e})),J.forEach(function(t){return delete e[t]}),delete e.pageLevel,delete e.result,e})}),r},re.addReporter("na",function(e,t,r){"use strict";console.warn(\'"na" reporter will be deprecated in axe v4.0. Use the "v2" reporter instead.\'),"function"==typeof t&&(r=t,t={});var n=s.processAggregate(e,t);r(l({},s.getEnvironmentData(),{toolOptions:t,violations:n.violations,passes:n.passes,incomplete:n.incomplete,inapplicable:n.inapplicable}))}),re.addReporter("no-passes",function(e,t,r){"use strict";"function"==typeof t&&(r=t,t={}),t.resultTypes=["violations"];var n=s.processAggregate(e,t);r(l({},s.getEnvironmentData(),{toolOptions:t,violations:n.violations}))}),re.addReporter("rawEnv",function(e,t,r){"function"==typeof t&&(r=t,t={}),re.getReporter("raw")(e,t,function(e){var t=s.getEnvironmentData();r({raw:e,env:t})})}),re.addReporter("raw",function(e,t,r){"use strict";if("function"==typeof t&&(r=t,t={}),!e||!Array.isArray(e))return r(e);r(e.map(function(e){for(var t=l({},e),r=0,n=["passes","violations","incomplete","inapplicable"];r<n.length;r++){var a=n[r];t[a]&&Array.isArray(t[a])&&(t[a]=t[a].map(function(e){return l({},e,{node:e.node.toJSON()})}))}return t}))}),re.addReporter("v1",function(e,t,r){"use strict";function n(e){e.nodes.forEach(function(e){e.failureSummary=s.failureSummary(e)})}"function"==typeof t&&(r=t,t={});var a=s.processAggregate(e,t);a.incomplete.forEach(n),a.violations.forEach(n),r(l({},s.getEnvironmentData(),{toolOptions:t,violations:a.violations,passes:a.passes,incomplete:a.incomplete,inapplicable:a.inapplicable}))}),re.addReporter("v2",function(e,t,r){"use strict";"function"==typeof t&&(r=t,t={});var n=s.processAggregate(e,t);r(l({},s.getEnvironmentData(),{toolOptions:t,violations:n.violations,passes:n.passes,incomplete:n.incomplete,inapplicable:n.inapplicable}))},!0),re.utils.aggregate=function(e,t,r){t=t.slice(),r&&t.push(r);var n=t.map(function(t){return e.indexOf(t)}).sort();return e[n.pop()]};var Z=re.constants,Q=Z.CANTTELL_PRIO,ee=Z.FAIL_PRIO,te=[];te[re.constants.PASS_PRIO]=!0,te[re.constants.CANTTELL_PRIO]=null,te[re.constants.FAIL_PRIO]=!1;var re,ne=["any","all","none"];function ae(e,t){return ne.reduce(function(r,n){return r[n]=(e[n]||[]).map(function(e){return t(e,n)}),r},{})}function oe(e,t,r){var n=Object.assign({},t);n.nodes=(n[r]||[]).concat(),re.constants.resultGroups.forEach(function(e){delete n[e]}),e[r].push(n)}function a(e){return(a="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function ie(e,t){"use strict";var r;return re._tree&&(r=re.utils.getSelector(t)),new Error(e+": "+(r||t))}function se(e,t,r){this._fromFrame=!!r,this.spec=r||{},t&&t.absolutePaths&&(this._options={toRoot:!0}),this.source=void 0!==this.spec.source?this.spec.source:function(e){var t=e.outerHTML;return t||"function"!=typeof XMLSerializer||(t=(new XMLSerializer).serializeToString(e)),function(e,t){if(t=t||300,e.length>t){var r=e.indexOf(">");e=e.substring(0,r+1)}return e}(t||"")}(e),this._element=e}function a(e){return(a="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function B(e,t){return U(e)||V(e,t)||M()}function M(){throw new TypeError("Invalid attempt to destructure non-iterable instance")}function V(e,t){if(Symbol.iterator in Object(e)||"[object Arguments]"===Object.prototype.toString.call(e)){var r=[],n=!0,a=!1,o=void 0;try{for(var i,s=e[Symbol.iterator]();!(n=(i=s.next()).done)&&(r.push(i.value),!t||r.length!==t);n=!0);}catch(e){a=!0,o=e}finally{try{n||null==s.return||s.return()}finally{if(a)throw o}}return r}}function U(e){if(Array.isArray(e))return e}function le(e,t){return[e.substring(0,t),e.substring(t)]}function ue(e){return e.replace(/\\s+$/,"")}re.utils.aggregateChecks=function(e){var t=Object.assign({},e);ae(t,function(e,t){var r=void 0===e.result?-1:te.indexOf(e.result);e.priority=-1!==r?r:re.constants.CANTTELL_PRIO,"none"===t&&(e.priority===re.constants.PASS_PRIO?e.priority=re.constants.FAIL_PRIO:e.priority===re.constants.FAIL_PRIO&&(e.priority=re.constants.PASS_PRIO))});var r={all:t.all.reduce(function(e,t){return Math.max(e,t.priority)},0),none:t.none.reduce(function(e,t){return Math.max(e,t.priority)},0),any:t.any.reduce(function(e,t){return Math.min(e,t.priority)},4)%4};t.priority=Math.max(r.all,r.none,r.any);var n=[];return ne.forEach(function(e){t[e]=t[e].filter(function(n){return n.priority===t.priority&&n.priority===r[e]}),t[e].forEach(function(e){return n.push(e.impact)})}),[Q,ee].includes(t.priority)?t.impact=re.utils.aggregate(re.constants.impact,n):t.impact=null,ae(t,function(e){delete e.result,delete e.priority}),t.result=re.constants.results[t.priority],delete t.priority,t},re.utils.aggregateNodeResults=function(e){var t={};if((e=e.map(function(e){if(e.any&&e.all&&e.none)return re.utils.aggregateChecks(e);if(Array.isArray(e.node))return re.utils.finalizeRuleResult(e);throw new TypeError("Invalid Result type")}))&&e.length){var r=e.map(function(e){return e.result});t.result=re.utils.aggregate(re.constants.results,r,t.result)}else t.result="inapplicable";re.constants.resultGroups.forEach(function(e){return t[e]=[]}),e.forEach(function(e){var r=re.constants.resultGroupMap[e.result];t[r].push(e)});var n=re.constants.FAIL_GROUP;if(0===t[n].length&&(n=re.constants.CANTTELL_GROUP),0<t[n].length){var a=t[n].map(function(e){return e.impact});t.impact=re.utils.aggregate(re.constants.impact,a)||null}else t.impact=null;return t},re.utils.aggregateResult=function(e){var t={};return re.constants.resultGroups.forEach(function(e){return t[e]=[]}),e.forEach(function(e){e.error?oe(t,e,re.constants.CANTTELL_GROUP):e.result===re.constants.NA?oe(t,e,re.constants.NA_GROUP):re.constants.resultGroups.forEach(function(r){Array.isArray(e[r])&&0<e[r].length&&oe(t,e,r)})}),t},re.utils.areStylesSet=function e(r,n,a){"use strict";var o=t.getComputedStyle(r,null);if(!o)return!1;for(var i=0;i<n.length;++i){var s=n[i];if(o.getPropertyValue(s.property)===s.value)return!0}return!(!r.parentNode||r.nodeName.toUpperCase()===a.toUpperCase())&&e(r.parentNode,n,a)},re.utils.assert=function(e,t){if(!e)throw new Error(t)},re.utils.checkHelper=function(e,t,r,n){"use strict";return{isAsync:!1,async:function(){return this.isAsync=!0,function(t){t instanceof Error==0?(e.result=t,r(e)):n(t)}},data:function(t){e.data=t},relatedNodes:function(r){r=r instanceof Node?[r]:re.utils.toArray(r),e.relatedNodes=r.map(function(e){return new re.utils.DqElement(e,t)})}}},re.utils.clone=function(e){"use strict";var t,r,n=e;if(null!==e&&"object"===a(e))if(Array.isArray(e))for(n=[],t=0,r=e.length;t<r;t++)n[t]=re.utils.clone(e[t]);else for(t in n={},e)n[t]=re.utils.clone(e[t]);return n},re.utils.sendCommandToFrame=function(e,t,r,n){"use strict";var a=e.contentWindow;if(!a)return re.log("Frame does not have a content window",e),void r(null);var o=setTimeout(function(){o=setTimeout(function(){t.debug?n(ie("No response from frame",e)):r(null)},0)},500);re.utils.respondable(a,"axe.ping",null,void 0,function(){clearTimeout(o);var i=t.options&&t.options.frameWaitTime||6e4;o=setTimeout(function(){n(ie("Axe in frame timed out",e))},i),re.utils.respondable(a,"axe.start",t,void 0,function(e){clearTimeout(o),(e instanceof Error==0?r:n)(e)})})},re.utils.collectResultsFromFrames=function(e,t,r,n,a,o){"use strict";var i=re.utils.queue();e.frames.forEach(function(a){var o={options:t,command:r,parameter:n,context:{initiator:!1,page:e.page,include:a.include||[],exclude:a.exclude||[]}};i.defer(function(e,t){var r=a.node;re.utils.sendCommandToFrame(r,o,function(t){if(t)return e({results:t,frameElement:r,frame:re.utils.getSelector(r)});e(null)},t)})}),i.then(function(e){a(re.utils.mergeResults(e,t))}).catch(o)},re.utils.contains=function(e,t){"use strict";if(e.shadowId||t.shadowId)return function e(t,r){return t.shadowId===r.shadowId||!!t.children.find(function(t){return e(t,r)})}(e,t);if(e.actualNode)return"function"==typeof e.actualNode.contains?e.actualNode.contains(t.actualNode):!!(16&e.actualNode.compareDocumentPosition(t.actualNode));do{if(t===e)return!0}while(t=t&&t.parent);return!1},function(e){var t=new e.imports.CssSelectorParser;t.registerSelectorPseudos("not"),t.registerNestingOperators(">"),t.registerAttrEqualityMods("^","$","*"),e.utils.cssParser=t}(re),se.prototype={get selector(){return this.spec.selector||[re.utils.getSelector(this.element,this._options)]},get xpath(){return this.spec.xpath||[re.utils.getXpath(this.element)]},get element(){return this._element},get fromFrame(){return this._fromFrame},toJSON:function(){"use strict";return{selector:this.selector,source:this.source,xpath:this.xpath}}},se.fromFrame=function(e,t,r){return e.selector.unshift(r.selector),e.xpath.unshift(r.xpath),new re.utils.DqElement(r.element,t,e)},re.utils.DqElement=se,re.utils.matchesSelector=function(){"use strict";var e;return function(t,r){return e&&t[e]||(e=function(e){var t,r,n=["matches","matchesSelector","mozMatchesSelector","webkitMatchesSelector","msMatchesSelector"],a=n.length;for(t=0;t<a;t++)if(e[r=n[t]])return r}(t)),!!t[e]&&t[e](r)}}(),re.utils.escapeSelector=function(e){"use strict";for(var t,r=String(e),n=r.length,a=-1,o="",i=r.charCodeAt(0);++a<n;)0!=(t=r.charCodeAt(a))?o+=1<=t&&t<=31||127==t||0==a&&48<=t&&t<=57||1==a&&48<=t&&t<=57&&45==i?"\\\\"+t.toString(16)+" ":0==a&&1==n&&45==t||!(128<=t||45==t||95==t||48<=t&&t<=57||65<=t&&t<=90||97<=t&&t<=122)?"\\\\"+r.charAt(a):r.charAt(a):o+="�";return o},re.utils.extendMetaData=function(e,t){Object.assign(e,t),Object.keys(t).filter(function(e){return"function"==typeof t[e]}).forEach(function(r){e[r]=null;try{e[r]=t[r](e)}catch(r){}})},re.utils.finalizeRuleResult=function(e){return Object.assign(e,re.utils.aggregateNodeResults(e.nodes)),delete e.nodes,e},re.utils.findBy=function(e,t,r){if(Array.isArray(e))return e.find(function(e){return"object"===a(e)&&e[t]===r})},(re=re||{utils:{}}).utils.getFlattenedTree=function(e,r){return re._cache.set("nodeMap",new WeakMap),function e(r,n,a){var o,i,s;function l(t,r,a){var o=e(r,n,a);return o&&(t=t.concat(o)),t}return r.documentElement&&(r=r.documentElement),s=r.nodeName.toLowerCase(),re.utils.isShadowRoot(r)?(o=new P(r,a,n),n="a"+Math.random().toString().substring(2),i=Array.from(r.shadowRoot.childNodes),o.children=i.reduce(function(e,t){return l(e,t,o)},[]),[o]):"content"===s&&"function"==typeof r.getDistributedNodes?(i=Array.from(r.getDistributedNodes())).reduce(function(e,t){return l(e,t,a)},[]):"slot"!==s||"function"!=typeof r.assignedNodes?1===r.nodeType?(o=new P(r,a,n),i=Array.from(r.childNodes),o.children=i.reduce(function(e,t){return l(e,t,o)},[]),[o]):3===r.nodeType?[new P(r,a)]:void 0:((i=Array.from(r.assignedNodes())).length||(i=function(e){var t=[];for(e=e.firstChild;e;)t.push(e),e=e.nextSibling;return t}(r)),t.getComputedStyle(r),i.reduce(function(e,t){return l(e,t,a)},[]))}(e,r)},re.utils.getNodeFromTree=function(e,t){var r=t||e;return re._cache.get("nodeMap")?re._cache.get("nodeMap").get(r):null},re.utils.getAllChecks=function(e){"use strict";return[].concat(e.any||[]).concat(e.all||[]).concat(e.none||[])},re.utils.getBaseLang=function(e){return e?e.trim().split("-")[0].toLowerCase():""},re.utils.getCheckMessage=function(e,t,r){var n=re._audit.data.checks[e];if(!n)throw new Error("Cannot get message for unknown check: ".concat(e,"."));if(!n.messages[t])throw new Error(\'Check "\'.concat(e,\'"" does not have a "\').concat(t,\'" message.\'));return re.utils.processMessage(n.messages[t],r)},re.utils.getCheckOption=function(e,t,r){var n=((r.rules&&r.rules[t]||{}).checks||{})[e.id],a=(r.checks||{})[e.id],o=e.enabled,i=e.options;return a&&(a.hasOwnProperty("enabled")&&(o=a.enabled),a.hasOwnProperty("options")&&(i=a.options)),n&&(n.hasOwnProperty("enabled")&&(o=n.enabled),n.hasOwnProperty("options")&&(i=n.options)),{enabled:o,options:i,absolutePaths:r.absolutePaths}},re.utils.getFriendlyUriEnd=function(e,t){var r=0<arguments.length&&void 0!==e?e:"",n=1<arguments.length&&void 0!==t?t:{};if(!(r.length<=1||"data:"===r.substr(0,5)||"javascript:"===r.substr(0,11)||r.includes("?"))){var a=n.currentDomain,o=n.maxLength,i=void 0===o?25:o,s=function(e){var t=e,r="",n="",a="",o="",i="";if(e.includes("#")){var s=le(e,e.indexOf("#")),l=B(s,2);e=l[0],i=l[1]}if(e.includes("?")){var u=le(e,e.indexOf("?")),c=B(u,2);e=c[0],o=c[1]}if(e.includes("://")){var d=e.split("://"),p=B(d,2);r=p[0];var m=le(e=p[1],e.indexOf("/")),f=B(m,2);n=f[0],e=f[1]}else if("//"===e.substr(0,2)){var h=le(e=e.substr(2),e.indexOf("/")),b=B(h,2);n=b[0],e=b[1]}if("www."===n.substr(0,4)&&(n=n.substr(4)),n&&n.includes(":")){var g=le(n,n.indexOf(":")),y=B(g,2);n=y[0],a=y[1]}return{original:t,protocol:r,domain:n,port:a,path:e,query:o,hash:i}}(r),l=s.path,u=s.domain,c=s.hash,d=l.substr(l.substr(0,l.length-2).lastIndexOf("/")+1);if(c)return d&&(d+c).length<=i?ue(d+c):d.length<2&&2<c.length&&c.length<=i?ue(c):void 0;if(u&&u.length<i&&l.length<=1)return ue(u+l);if(l==="/"+d&&u&&a&&u!==a&&(u+l).length<=i)return ue(u+l);var p=d.lastIndexOf(".");return(-1===p||1<p)&&(-1!==p||2<d.length)&&d.length<=i&&!d.match(/index(\\.[a-zA-Z]{2-4})?/)&&!function(e){var t=0<arguments.length&&void 0!==e?e:"";return 0!==t.length&&(t.match(/[0-9]/g)||"").length>=t.length/2}(d)?ue(d):void 0}},re.utils.getNodeAttributes=function(e){return e.attributes instanceof t.NamedNodeMap?e.attributes:e.cloneNode(!1).attributes},re.utils.getRootNode=function(e){var t=e.getRootNode&&e.getRootNode()||n;return t===e&&(t=n),t},re.utils.getScroll=function(e,r){var n=1<arguments.length&&void 0!==r?r:0,a=e.scrollWidth>e.clientWidth+n,o=e.scrollHeight>e.clientHeight+n;if(a||o){var i=t.getComputedStyle(e),s=i.getPropertyValue("overflow-x"),l=i.getPropertyValue("overflow-y");return a&&"visible"!==s&&"hidden"!==s||o&&"visible"!==l&&"hidden"!==l?{elm:e,top:e.scrollTop,left:e.scrollLeft}:void 0}};var ce,de,pe=re.utils.escapeSelector,me=["class","style","id","selected","checked","disabled","tabindex","aria-checked","aria-selected","aria-invalid","aria-activedescendant","aria-busy","aria-disabled","aria-expanded","aria-grabbed","aria-pressed","aria-valuenow"],fe=31;function he(e,t){var r,n=t.name;if(-1!==n.indexOf("href")||-1!==n.indexOf("src")){var a=re.utils.getFriendlyUriEnd(e.getAttribute(n));if(a){var o=encodeURI(a);if(!o)return;r=pe(t.name)+\'$="\'+pe(o)+\'"\'}else r=pe(t.name)+\'="\'+pe(e.getAttribute(n))+\'"\'}else r=pe(n)+\'="\'+pe(t.value)+\'"\';return r}function be(e,t){return e.count<t.count?-1:e.count===t.count?0:1}function ge(e){return!me.includes(e.name)&&-1===e.name.indexOf(":")&&(!e.value||e.value.length<fe)}function ye(e,t){var r=e.parentNode&&Array.from(e.parentNode.children||"")||[];return r.find(function(r){return r!==e&&re.utils.matchesSelector(r,t)})?":nth-child("+(1+r.indexOf(e))+")":""}function ve(e){if(e.getAttribute("id")){var t=e.getRootNode&&e.getRootNode()||n,r="#"+pe(e.getAttribute("id")||"");return r.match(/player_uid_/)||1!==t.querySelectorAll(r).length?void 0:r}}function we(e){return void 0===ce&&(ce=re.utils.isXHTML(n)),pe(ce?e.localName:e.nodeName.toLowerCase())}function xe(e,t){var r,n,a,o,i,s,l,u,c,d,p,m="",f=(n=e,o=[],i=(a=t).classes,s=a.tags,n.classList&&Array.from(n.classList).forEach(function(e){var t=pe(e);i[t]<s[n.nodeName]&&o.push({name:t,count:i[t],species:"class"})}),o.sort(be)),h=(l=e,c=[],d=(u=t).attributes,p=u.tags,l.hasAttributes()&&Array.from(re.utils.getNodeAttributes(l)).filter(ge).forEach(function(e){var t=he(l,e);t&&d[t]<p[l.nodeName]&&c.push({name:t,count:d[t],species:"attribute"})}),c.sort(be));return f.length&&1===f[0].count?r=[f[0]]:h.length&&1===h[0].count?(r=[h[0]],m=we(e)):((r=f.concat(h)).sort(be),(r=r.slice(0,3)).some(function(e){return"class"===e.species})?r.sort(function(e,t){return e.species!==t.species&&"class"===e.species?-1:e.species===t.species?0:1}):m=we(e)),m+r.reduce(function(e,t){switch(t.species){case"class":return e+"."+t.name;case"attribute":return e+"["+t.name+"]"}return e},"")}function De(e,t,r){if(!re._selectorData)throw new Error("Expect axe._selectorData to be set up");var n,a,o=t.toRoot,i=void 0!==o&&o;do{var s=ve(e);s||(s=xe(e,re._selectorData),s+=ye(e,s)),n=n?s+" > "+n:s,a=a?a.filter(function(e){return re.utils.matchesSelector(e,n)}):Array.from(r.querySelectorAll(n)),e=e.parentElement}while((1<a.length||i)&&e&&11!==e.nodeType);return 1===a.length?n:-1!==n.indexOf(" > ")?":root"+n.substring(n.indexOf(" > ")):":root"}re.utils.getSelectorData=function(e){function t(){var e=n.pop(),t=e.actualNode;if(t.querySelectorAll){var o=t.nodeName;r.tags[o]?r.tags[o]++:r.tags[o]=1,t.classList&&Array.from(t.classList).forEach(function(e){var t=pe(e);r.classes[t]?r.classes[t]++:r.classes[t]=1}),t.hasAttributes()&&Array.from(re.utils.getNodeAttributes(t)).filter(ge).forEach(function(e){var n=he(t,e);n&&(r.attributes[n]?r.attributes[n]++:r.attributes[n]=1)})}for(e.children.length&&(a.push(n),n=e.children.slice());!n.length&&a.length;)n=a.pop()}for(var r={classes:{},tags:{},attributes:{}},n=(e=Array.isArray(e)?e:[e]).slice(),a=[];n.length;)t();return r},re.utils.getSelector=function(e,t){var r=1<arguments.length&&void 0!==t?t:{};if(!e)return"";var a=e.getRootNode&&e.getRootNode()||n;if(11!==a.nodeType)return De(e,r,a);for(var o=[];11===a.nodeType;){if(!a.host)return"";o.push({elm:e,doc:a}),a=(e=a.host).getRootNode()}return o.push({elm:e,doc:a}),o.reverse().map(function(e){return De(e.elm,r,e.doc)})},re.utils.getStyleSheetFactory=function(e){if(!e)throw new Error("axe.utils.getStyleSheetFactory should be invoked with an argument");return function(t){var r=t.data,n=t.isCrossOrigin,a=void 0!==n&&n,o=t.shadowId,i=t.root,s=t.priority,l=t.isLink,u=void 0!==l&&l,c=e.createElement("style");if(u){var d=e.createTextNode(\'@import "\'.concat(r.href,\'"\'));c.appendChild(d)}else c.appendChild(e.createTextNode(r));return e.head.appendChild(c),{sheet:c.sheet,isCrossOrigin:a,shadowId:o,root:i,priority:s}}},re.utils.getXpath=function(e){return function e(t,r){var n,a;if(!t)return[];if(!r&&9===t.nodeType)return[{str:"html"}];if(r=r||[],t.parentNode&&t.parentNode!==t&&(r=e(t.parentNode,r)),t.previousSibling){for(a=1,n=t.previousSibling;1===n.nodeType&&n.nodeName===t.nodeName&&a++,n=n.previousSibling;);1===a&&(a=null)}else if(t.nextSibling)for(n=t.nextSibling;n=1===n.nodeType&&n.nodeName===t.nodeName?(a=1,null):(a=null,n.previousSibling););if(1===t.nodeType){var o={};o.str=t.nodeName.toLowerCase();var i=t.getAttribute&&re.utils.escapeSelector(t.getAttribute("id"));i&&1===t.ownerDocument.querySelectorAll("#"+i).length&&(o.id=t.getAttribute("id")),1<a&&(o.count=a),r.push(o)}return r}(e).reduce(function(e,t){return t.id?"/".concat(t.str,"[@id=\'").concat(t.id,"\']"):e+"/".concat(t.str)+(0<t.count?"[".concat(t.count,"]"):"")},"")},re.utils.injectStyle=function(e){"use strict";if(de&&de.parentNode)return void 0===de.styleSheet?de.appendChild(n.createTextNode(e)):de.styleSheet.cssText+=e,de;if(e){var t=n.head||n.getElementsByTagName("head")[0];return(de=n.createElement("style")).type="text/css",void 0===de.styleSheet?de.appendChild(n.createTextNode(e)):de.styleSheet.cssText=e,t.appendChild(de),de}},re.utils.isHidden=function(e,r){"use strict";var n=re.utils.getNodeFromTree(e);if(9===e.nodeType)return!1;if(11===e.nodeType&&(e=e.host),n&&null!==n._isHidden)return n._isHidden;var a=t.getComputedStyle(e,null);if(!a||!e.parentNode||"none"===a.getPropertyValue("display")||!r&&"hidden"===a.getPropertyValue("visibility")||"true"===e.getAttribute("aria-hidden"))return!0;var o=e.assignedSlot?e.assignedSlot:e.parentNode,i=re.utils.isHidden(o,!0);return n&&(n._isHidden=i),i};var ke=["a","abbr","address","area","article","aside","audio","b","base","bdi","bdo","blockquote","body","br","button","canvas","caption","cite","code","col","colgroup","data","datalist","dd","del","details","dfn","dialog","div","dl","dt","em","embed","fieldset","figcaption","figure","footer","form","h1","h2","h3","h4","h5","h6","head","header","hgroup","hr","html","i","iframe","img","input","ins","kbd","keygen","label","legend","li","link","main","map","mark","math","menu","menuitem","meta","meter","nav","noscript","object","ol","optgroup","option","output","p","param","picture","pre","progress","q","rb","rp","rt","rtc","ruby","s","samp","script","section","select","slot","small","source","span","strong","style","sub","summary","sup","svg","table","tbody","td","template","textarea","tfoot","th","thead","time","title","tr","track","u","ul","var","video","wbr"];re.utils.isHtmlElement=function(e){return"http://www.w3.org/2000/svg"!==e.namespaceURI&&ke.includes(e.nodeName.toLowerCase())};var Ee=["article","aside","blockquote","body","div","footer","h1","h2","h3","h4","h5","h6","header","main","nav","p","section","span"];function Ae(e,t){return d=t,1===(c=e).props.nodeType&&("*"===d.tag||c.props.nodeName===d.tag)&&(l=e,!(u=t).classes||u.classes.every(function(e){return l.hasClass(e.value)}))&&(i=e,!(s=t).attributes||s.attributes.every(function(e){var t=i.attr(e.key);return null!==t&&(!e.value||e.test(t))}))&&(a=e,!(o=t).id||a.props.id===o.id)&&(r=e,!((n=t).pseudos&&!n.pseudos.every(function(e){if("not"===e.name)return!re.utils.matchesExpression(r,e.expressions[0]);throw new Error("the pseudo selector "+e.name+" has not yet been implemented")})));var r,n,a,o,i,s,l,u,c,d}re.utils.isShadowRoot=function(e){if(e.shadowRoot){var t=e.nodeName.toLowerCase();if(Ee.includes(t)||/^[a-z][a-z0-9_.-]*-[a-z0-9_.-]*$/.test(t))return!0}return!1},re.utils.isXHTML=function(e){"use strict";return!!e.createElement&&"A"===e.createElement("A").localName};var je,Ce,Fe,Te=(je=/(?=[\\-\\[\\]{}()*+?.\\\\\\^$|,#\\s])/g,function(e){return e.replace(je,"\\\\")}),Ne=/\\\\/g;function Se(e){if(e)return e.map(function(e){var t,r,n=e.name.replace(Ne,""),a=(e.value||"").replace(Ne,"");switch(e.operator){case"^=":r=new RegExp("^"+Te(a));break;case"$=":r=new RegExp(Te(a)+"$");break;case"~=":r=new RegExp("(^|\\\\s)"+Te(a)+"(\\\\s|$)");break;case"|=":r=new RegExp("^"+Te(a)+"(-|$)");break;case"=":t=function(e){return a===e};break;case"*=":t=function(e){return e&&e.includes(a)};break;case"!=":t=function(e){return a!==e};break;default:t=function(e){return!!e}}return""===a&&/^[*$^]=$/.test(e.operator)&&(t=function(){return!1}),{key:n,value:a,test:t=t||function(e){return e&&r.test(e)}}})}function ze(e){if(e)return e.map(function(e){return{value:e=e.replace(Ne,""),regexp:new RegExp("(^|\\\\s)"+Te(e)+"(\\\\s|$)")}})}function qe(e){if(e)return e.map(function(e){var t;return"not"===e.name&&(t=Oe(t=(t=e.value).selectors?t.selectors:[t])),{name:e.name,expressions:t,value:e.value}})}function Oe(e){return e.map(function(e){for(var t=[],r=e.rule;r;)t.push({tag:r.tagName?r.tagName.toLowerCase():"*",combinator:r.nestingOperator?r.nestingOperator:" ",id:r.id,attributes:Se(r.attrs),classes:ze(r.classNames),pseudos:qe(r.pseudos)}),r=r.rule;return t})}function _e(e){return function(e){if(Array.isArray(e)){for(var t=0,r=new Array(e.length);t<e.length;t++)r[t]=e[t];return r}}(e)||function(e){if(Symbol.iterator in Object(e)||"[object Arguments]"===Object.prototype.toString.call(e))return Array.from(e)}(e)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance")}()}function Re(e){return"function"==typeof e||"[object Function]"===Ce.call(e)}function Pe(e){var t,r=(t=Number(e),isNaN(t)?0:0!==t&&isFinite(t)?(0<t?1:-1)*Math.floor(Math.abs(t)):t);return Math.min(Math.max(r,0),Fe)}function Ie(e){var t=e.nodeName.toUpperCase(),r=e.getAttribute("href"),n=e.getAttribute("rel"),a="LINK"===t&&r&&n&&e.rel.toUpperCase().includes("STYLESHEET");return"STYLE"===t||a&&Le(e.media)}function Le(e){return!e||!e.toUpperCase().includes("PRINT")}function l(){return(l=Object.assign||function(e){for(var t=1;t<arguments.length;t++){var r=arguments[t];for(var n in r)Object.prototype.hasOwnProperty.call(r,n)&&(e[n]=r[n])}return e}).apply(this,arguments)}function a(e){return(a="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}re.utils.convertSelector=function(e){var t=re.utils.cssParser.parse(e);return Oe(t=t.selectors?t.selectors:[t])},re.utils.matchesExpression=function(e,t,r){for(var n=[].concat(t),a=n.pop(),o=Ae(e,a);!o&&r&&e.parent;)o=Ae(e=e.parent,a);if(n.length){if(!1===[" ",">"].includes(a.combinator))throw new Error("axe.utils.matchesExpression does not support the combinator: "+a.combinator);o=o&&re.utils.matchesExpression(e.parent,n," "===a.combinator)}return o},re.utils.matches=function(e,t){return re.utils.convertSelector(t).some(function(t){return re.utils.matchesExpression(e,t)})},re._memoizedFns=[],re.utils.memoize=function(e){var t=re.imports.memoize(e);return re._memoizedFns.push(t),t},re.utils.mergeResults=function(e,t){"use strict";var r=[];return e.forEach(function(e){var n=function(e){return e&&e.results?Array.isArray(e.results)?e.results.length?e.results:null:[e.results]:null}(e);n&&n.length&&n.forEach(function(n){n.nodes&&e.frame&&function(e,t,r,n){var a={element:r,selector:n,xpath:re.utils.getXpath(r)};e.forEach(function(e){e.node=re.utils.DqElement.fromFrame(e.node,t,a);var r=re.utils.getAllChecks(e);r.length&&r.forEach(function(e){e.relatedNodes=e.relatedNodes.map(function(e){return re.utils.DqElement.fromFrame(e,t,a)})})})}(n.nodes,t,e.frameElement,e.frame);var a=re.utils.findBy(r,"id",n.id);a?n.nodes.length&&function(e,t){for(var r,n,a=t[0].node,o=0,i=e.length;o<i;o++)if(n=e[o].node,0<(r=re.utils.nodeSorter({actualNode:n.element},{actualNode:a.element}))||0===r&&a.selector.length<n.selector.length)return e.splice.apply(e,[o,0].concat(t));e.push.apply(e,t)}(a.nodes,n.nodes):r.push(n)})}),r},re.utils.nodeSorter=function(e,t){return(e=e.actualNode||e)===(t=t.actualNode||t)?0:4&e.compareDocumentPosition(t)?-1:1},re.utils.parseCrossOriginStylesheet=function(e,t,r,n,a){var o={method:"get",timeout:re.constants.preload.timeout,url:e};return n.push(e),re.imports.axios(o).then(function(e){var o=e.data,i=t.convertDataToStylesheet({data:o,isCrossOrigin:a,priority:r,root:t.rootNode,shadowId:t.shadowId});return re.utils.parseStylesheet(i.sheet,t,r,n,i.isCrossOrigin)})},re.utils.parseSameOriginStylesheet=function(e,t,r,n,a){var o=4<arguments.length&&void 0!==a&&a,i=Array.from(e.cssRules);if(!i)return Promise.resolve();var s=i.filter(function(e){return 3===e.type});if(!s.length)return Promise.resolve({isCrossOrigin:o,priority:r,root:t.rootNode,shadowId:t.shadowId,sheet:e});var l=s.filter(function(e){return e.href}).map(function(e){return e.href}).filter(function(e){return!n.includes(e)}).map(function(e,a){var o=[].concat(_e(r),[a]),i=/^https?:\\/\\/|^\\/\\//i.test(e);return re.utils.parseCrossOriginStylesheet(e,t,o,n,i)}),u=i.filter(function(e){return 3!==e.type});return u.length&&l.push(Promise.resolve(t.convertDataToStylesheet({data:u.map(function(e){return e.cssText}).join(),isCrossOrigin:o,priority:r,root:t.rootNode,shadowId:t.shadowId}))),Promise.all(l)},re.utils.parseStylesheet=function(e,t,r,n,a){var o=4<arguments.length&&void 0!==a&&a;return function(e){try{return!(!e.cssRules&&e.href)}catch(e){return!1}}(e)?re.utils.parseSameOriginStylesheet(e,t,r,n,o):re.utils.parseCrossOriginStylesheet(e.href,t,r,n,!0)},i.performanceTimer=function(){"use strict";function e(){if(t.performance&&t.performance)return t.performance.now()}var r=null,n=e();return{start:function(){this.mark("mark_axe_start")},end:function(){this.mark("mark_axe_end"),this.measure("axe","mark_axe_start","mark_axe_end"),this.logMeasures("axe")},auditStart:function(){this.mark("mark_audit_start")},auditEnd:function(){this.mark("mark_audit_end"),this.measure("audit_start_to_end","mark_audit_start","mark_audit_end"),this.logMeasures()},mark:function(e){t.performance&&void 0!==t.performance.mark&&t.performance.mark(e)},measure:function(e,r,n){t.performance&&void 0!==t.performance.measure&&t.performance.measure(e,r,n)},logMeasures:function(e){function r(e){re.log("Measure "+e.name+" took "+e.duration+"ms")}if(t.performance&&void 0!==t.performance.getEntriesByType)for(var n=t.performance.getEntriesByName("mark_axe_start")[0],a=t.performance.getEntriesByType("measure").filter(function(e){return e.startTime>=n.startTime}),o=0;o<a.length;++o){var i=a[o];if(i.name===e)return void r(i);r(i)}},timeElapsed:function(){return e()-n},reset:function(){r=r||e(),n=e()}}}(),"function"!=typeof Object.assign&&(Object.assign=function(e){"use strict";if(null==e)throw new TypeError("Cannot convert undefined or null to object");for(var t=Object(e),r=1;r<arguments.length;r++){var n=arguments[r];if(null!=n)for(var a in n)n.hasOwnProperty(a)&&(t[a]=n[a])}return t}),Array.prototype.find||Object.defineProperty(Array.prototype,"find",{value:function(e){if(null===this)throw new TypeError("Array.prototype.find called on null or undefined");if("function"!=typeof e)throw new TypeError("predicate must be a function");for(var t,r=Object(this),n=r.length>>>0,a=arguments[1],o=0;o<n;o++)if(t=r[o],e.call(a,t,o,r))return t}}),re.utils.pollyfillElementsFromPoint=function(){if(n.elementsFromPoint)return n.elementsFromPoint;if(n.msElementsFromPoint)return n.msElementsFromPoint;var e,t=((e=n.createElement("x")).style.cssText="pointer-events:auto","auto"===e.style.pointerEvents),r=t?"pointer-events":"visibility",a=t?"none":"hidden",o=n.createElement("style");return o.innerHTML=t?"* { pointer-events: all }":"* { visibility: visible }",function(e,t){var i,s,l,u=[],c=[];for(n.head.appendChild(o);(i=n.elementFromPoint(e,t))&&-1===u.indexOf(i);)u.push(i),c.push({value:i.style.getPropertyValue(r),priority:i.style.getPropertyPriority(r)}),i.style.setProperty(r,a,"important");for(u.indexOf(n.documentElement)<u.length-1&&(u.splice(u.indexOf(n.documentElement),1),u.push(n.documentElement)),s=c.length;l=c[--s];)u[s].style.setProperty(r,l.value?l.value:"",l.priority);return n.head.removeChild(o),u}},"function"==typeof t.addEventListener&&(n.elementsFromPoint=re.utils.pollyfillElementsFromPoint()),Array.prototype.includes||Object.defineProperty(Array.prototype,"includes",{value:function(e,t){"use strict";var r=Object(this),n=parseInt(r.length,10)||0;if(0===n)return!1;var a,o,i=parseInt(t,10)||0;for(0<=i?a=i:(a=n+i)<0&&(a=0);a<n;){if(e===(o=r[a])||e!=e&&o!=o)return!0;a++}return!1}}),Array.prototype.some||Object.defineProperty(Array.prototype,"some",{value:function(e,t){"use strict";if(null==this)throw new TypeError("Array.prototype.some called on null or undefined");if("function"!=typeof e)throw new TypeError;for(var r=Object(this),n=r.length>>>0,a=2<=arguments.length?t:void 0,o=0;o<n;o++)if(o in r&&e.call(a,r[o],o,r))return!0;return!1}}),Array.from||Object.defineProperty(Array,"from",{value:(Ce=Object.prototype.toString,Fe=Math.pow(2,53)-1,function(e,t,r){var n=Object(e);if(null==e)throw new TypeError("Array.from requires an array-like object - not null or undefined");var a,o=1<arguments.length?t:void 0;if(void 0!==o){if(!Re(o))throw new TypeError("Array.from: when provided, the second argument must be a function");2<arguments.length&&(a=r)}for(var i,s=Pe(n.length),l=Re(this)?Object(new this(s)):new Array(s),u=0;u<s;)i=n[u],l[u]=o?void 0===a?o(i,u):o.call(a,i,u):i,u+=1;return l.length=s,l})}),String.prototype.includes||(String.prototype.includes=function(e,t){return"number"!=typeof t&&(t=0),!(t+e.length>this.length)&&-1!==this.indexOf(e,t)}),re.utils.preloadCssom=function(e){var t,r,a,o=e.treeRoot,i=(t=void 0===o?re._tree[0]:o,r=[],a=re.utils.querySelectorAllFilter(t,"*",function(e){return!r.includes(e.shadowId)&&(r.push(e.shadowId),!0)}).map(function(e){return{shadowId:e.shadowId,rootNode:re.utils.getRootNode(e.actualNode)}}),re.utils.uniqueArray(a,[]));if(!i.length)return Promise.resolve();var s,l,u=n.implementation.createHTMLDocument("Dynamic document for loading cssom"),c=re.utils.getStyleSheetFactory(u);return s=c,l=[],i.forEach(function(e,t){var r=e.rootNode,n=e.shadowId,a=function(e,t,r){return function(e){var t=[];return e.filter(function(e){return!e.href||!t.includes(e.href)&&(t.push(e.href),!0)})}(11===e.nodeType&&t?function(e,t){return Array.from(e.children).filter(Ie).reduce(function(r,n){var a=n.nodeName.toUpperCase(),o="STYLE"===a?n.textContent:n,i=t({data:o,isLink:"LINK"===a,root:e});return r.push(i.sheet),r},[])}(e,r):function(e){return Array.from(e.styleSheets).filter(function(e){return Le(e.media.mediaText)})}(e))}(r,n,s);if(!a)return Promise.all(l);var o=t+1,i={rootNode:r,shadowId:n,convertDataToStylesheet:s,rootIndex:o},u=[],c=Promise.all(a.map(function(e,t){var r=[o,t];return re.utils.parseStylesheet(e,i,r,u)}));l.push(c)}),Promise.all(l).then(function(e){return function e(t){return t.reduce(function(t,r){return Array.isArray(r)?t.concat(e(r)):t.concat(r)},[])}(e)})},re.utils.preloadMedia=function(e){var t=e.treeRoot,r=void 0===t?re._tree[0]:t,n=re.utils.querySelectorAllFilter(r,"video, audio",function(e){var t=e.actualNode;return t.hasAttribute("src")?!!t.getAttribute("src"):!(Array.from(t.getElementsByTagName("source")).filter(function(e){return!!e.getAttribute("src")}).length<=0)});return Promise.all(n.map(function(e){var t,r=e.actualNode;return t=r,new Promise(function(e){0<t.readyState&&e(t),t.addEventListener("loadedmetadata",function r(){t.removeEventListener("loadedmetadata",r),e(t)})})}))},re.utils.shouldPreload=function(e){return!e||void 0===e.preload||null===e.preload||("boolean"==typeof e.preload?e.preload:(t=e.preload,"object"===a(t)&&Array.isArray(t.assets)));var t},re.utils.getPreloadConfig=function(e){var t=re.constants.preload,r=t.assets,n=t.timeout,a={assets:r,timeout:n};if(!e.preload)return a;if("boolean"==typeof e.preload)return a;if(!e.preload.assets.every(function(e){return r.includes(e.toLowerCase())}))throw new Error("Requested assets, not supported. "+"Supported assets are: ".concat(r.join(", "),"."));return a.assets=re.utils.uniqueArray(e.preload.assets.map(function(e){return e.toLowerCase()}),[]),e.preload.timeout&&"number"==typeof e.preload.timeout&&!isNaN(e.preload.timeout)&&(a.timeout=e.preload.timeout),a},re.utils.preload=function(e){var t={cssom:re.utils.preloadCssom,media:re.utils.preloadMedia};return re.utils.shouldPreload(e)?new Promise(function(r,n){var a=re.utils.getPreloadConfig(e),o=a.assets,i=a.timeout,s=setTimeout(function(){return n(new Error("Preload assets timed out."))},i);Promise.all(o.map(function(r){return t[r](e).then(function(e){return a=e,(n=r)in(t={})?Object.defineProperty(t,n,{value:a,enumerable:!0,configurable:!0,writable:!0}):t[n]=a,t;var t,n,a})})).then(function(e){var t=e.reduce(function(e,t){return l({},e,{},t)},{});clearTimeout(s),r(t)}).catch(function(e){clearTimeout(s),n(e)})}):Promise.resolve()};var Be,Me=/\\$\\{\\s?data\\s?\\}/g;function Ve(e,t){if("string"==typeof t)return e.replace(Me,t);for(var r in t)if(t.hasOwnProperty(r)){var n=new RegExp("\\\\${\\\\s?data\\\\."+r+"\\\\s?}","g");e=e.replace(n,t[r])}return e}function a(e){return(a="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function Ue(e,t){"use strict";return function(r){var n=e[r.id]||{},o=n.messages||{},i=Object.assign({},n);delete i.messages,void 0===r.result?("object"!==a(o.incomplete)||Array.isArray(r.data)||(i.message=function(e,t){function r(e){return e.incomplete&&e.incomplete.default?e.incomplete.default:s.incompleteFallbackMessage()}if(!e||!e.missingData)return e&&e.messageKey?t.incomplete[e.messageKey]:r(t);try{var n=t.incomplete[e.missingData[0].reason];if(!n)throw new Error;return n}catch(n){return"string"==typeof e.missingData?t.incomplete[e.missingData]:r(t)}}(r.data,o)),i.message||(i.message=o.incomplete)):i.message=r.result===t?o.pass:o.fail,"function"!=typeof i.message&&(i.message=re.utils.processMessage(i.message,r.data)),re.utils.extendMetaData(r,i)}}function He(e,t,r,n){var a={vNodes:e.slice(),anyLevel:t,thisLevel:r,parentShadowId:n};return a.vNodes.reverse(),a}function a(e){return(a="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function a(e){return(a="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function $e(e,t){"use strict";var r,n,a=re._audit&&re._audit.tagExclude?re._audit.tagExclude:[];return n=t.hasOwnProperty("include")||t.hasOwnProperty("exclude")?(r=t.include||[],r=Array.isArray(r)?r:[r],n=t.exclude||[],(n=Array.isArray(n)?n:[n]).concat(a.filter(function(e){return-1===r.indexOf(e)}))):(r=Array.isArray(t)?t:[t],a.filter(function(e){return-1===r.indexOf(e)})),!!(r.some(function(t){return-1!==e.tags.indexOf(t)})||0===r.length&&!1!==e.enabled)&&n.every(function(t){return-1===e.tags.indexOf(t)})}function Ge(e){"use strict";return e.sort(function(e,t){return re.utils.contains(e,t)?1:-1})[0]}function We(e,t){"use strict";var r=t.include&&Ge(t.include.filter(function(t){return re.utils.contains(t,e)})),n=t.exclude&&Ge(t.exclude.filter(function(t){return re.utils.contains(t,e)}));return!!(!n&&r||n&&re.utils.contains(n,r))}function Ye(e,t){"use strict";var r;if(0===e.length)return t;e.length<t.length&&(r=e,e=t,t=r);for(var n=0,a=t.length;n<a;n++)e.includes(t[n])||e.push(t[n]);return e}re.utils.processMessage=function e(t,r){if(t){if(Array.isArray(r))return r.values=r.join(", "),"string"!=typeof t.singular||"string"!=typeof t.plural?Ve(t,r):Ve(1===r.length?t.singular:t.plural,r);if("string"==typeof t)return Ve(t,r);if("string"==typeof r)return Ve(t[r],r);var n=t.default||s.incompleteFallbackMessage();return r&&r.messageKey&&t[r.messageKey]&&(n=t[r.messageKey]),e(n,r)}},re.utils.publishMetaData=function(e){"use strict";var t=re._audit.data.checks||{},r=re._audit.data.rules||{},n=re.utils.findBy(re._audit.rules,"id",e.id)||{};e.tags=re.utils.clone(n.tags||[]);var a=Ue(t,!0),o=Ue(t,!1);e.nodes.forEach(function(e){e.any.forEach(a),e.all.forEach(a),e.none.forEach(o)}),re.utils.extendMetaData(e,re.utils.clone(r[e.id]||{}))},re.utils.querySelectorAll=function(e,t){return re.utils.querySelectorAllFilter(e,t)},re.utils.querySelectorAllFilter=function(e,t,r){return function(e,t,r){for(var n=[],a=He(Array.isArray(e)?e:[e],t,[],e[0].shadowId),o=[];a.vNodes.length;){for(var i=a.vNodes.pop(),s=[],l=[],u=a.anyLevel.slice().concat(a.thisLevel),c=!1,d=0;d<u.length;d++){var p=u[d];if((!p[0].id||i.shadowId===a.parentShadowId)&&re.utils.matchesExpression(i,p[0]))if(1===p.length)c||r&&!r(i)||(o.push(i),c=!0);else{var m=p.slice(1);if(!1===[" ",">"].includes(m[0].combinator))throw new Error("axe.utils.querySelectorAll does not support the combinator: "+p[1].combinator);">"===m[0].combinator?s.push(m):l.push(m)}p[0].id&&i.shadowId!==a.parentShadowId||!a.anyLevel.includes(p)||l.push(p)}for(i.children&&i.children.length&&(n.push(a),a=He(i.children,l,s,i.shadowId));!a.vNodes.length&&n.length;)a=n.pop()}return o}(e=Array.isArray(e)?e:[e],re.utils.convertSelector(t),r)},function(){"use strict";function e(){}function t(e){if("function"!=typeof e)throw new TypeError("Queue methods require functions as arguments")}re.utils.queue=function(){function r(e){n=e,setTimeout(function(){null!=n&&re.log("Uncaught error (of queue)",n)},1)}var n,o=[],i=0,s=0,l=e,u=!1,c=r;function d(t){return function(r){o[t]=r,--s||l===e||(u=!0,l(o))}}function p(t){return l=e,c(t),o}var m={defer:function(e){if("object"===a(e)&&e.then&&e.catch){var r=e;e=function(e,t){r.then(e).catch(t)}}if(t(e),void 0===n){if(u)throw new Error("Queue already completed");return o.push(e),++s,function(){for(var e=o.length;i<e;i++){var t=o[i];try{t.call(null,d(i),p)}catch(e){p(e)}}}(),m}},then:function(r){if(t(r),l!==e)throw new Error("queue `then` already set");return n||(l=r,s||(u=!0,l(o))),m},catch:function(e){if(t(e),c!==r)throw new Error("queue `catch` already set");return n?(e(n),n=null):c=e,m},abort:p};return m}}(),function(e){"use strict";var r={},n={},o=Object.freeze(["EvalError","RangeError","ReferenceError","SyntaxError","TypeError","URIError"]);function i(){var e="axeAPI",t="";return void 0!==re&&re._audit&&re._audit.application&&(e=re._audit.application),void 0!==re&&(t=re.version),e+"."+t}function s(e,t,n,a,o,s){var l;n instanceof Error&&(l={name:n.name,message:n.message,stack:n.stack},n=void 0);var u={uuid:a,topic:t,message:n,error:l,_respondable:!0,_source:i(),_axeuuid:re._uuid,_keepalive:o},c=re._cache.get("axeRespondables");c||(c={},re._cache.set("axeRespondables",c)),c[a]=!0,"function"==typeof s&&(r[a]=s),e.postMessage(JSON.stringify(u),"*")}function l(e,t,r,n,a){s(e,t,r,Be.v1(),n,a)}function u(e,t,r){return function(n,a,o){s(e,t,n,r,a,o)}}l.subscribe=function(e,t){n[e]=t},l.isInFrame=function(e){return!!(e=e||t).frameElement},"function"==typeof t.addEventListener&&t.addEventListener("message",function(e){var l=function(e){var r;if("string"==typeof e){try{r=JSON.parse(e)}catch(e){}var n,s,l,u;if(function(e){if("object"===a(e)&&"string"==typeof e.uuid&&!0===e._respondable){var t=i();return e._source===t||"axeAPI.x.y.z"===e._source||"axeAPI.x.y.z"===t}}(r))return"object"===a(r.error)?r.error=(s=(n=r.error).message||"Unknown error occurred",l=o.includes(n.name)?n.name:"Error",u=t[l]||Error,n.stack&&(s+="\\n"+n.stack.replace(n.message,"")),new u(s)):r.error=void 0,r}}(e.data);if(l&&l._axeuuid){var c=l.uuid;if(!(re._cache.get("axeRespondables")||{})[c]||l._axeuuid!==re._uuid){var d=l._keepalive,p=r[c];if(p&&(p(l.error||l.message,d,u(e.source,l.topic,c)),d||delete r[c]),!l.error)try{!function(e,t,r){var a=t.topic,o=n[a];if(o){var i=u(e,null,t.uuid);o(t.message,r,i)}}(e.source,l,d)}catch(l){s(e.source,null,l,c,!1)}}}},!1),e.respondable=l}(i),re.utils.ruleShouldRun=function(e,t,r){"use strict";var n=r.runOnly||{},a=(r.rules||{})[e.id];return!(e.pageLevel&&!t.page)&&("rule"===n.type?-1!==n.values.indexOf(e.id):a&&"boolean"==typeof a.enabled?a.enabled:"tag"===n.type&&n.values?$e(e,n.values):$e(e,[]))},re.utils.getScrollState=function(e){var r=0<arguments.length&&void 0!==e?e:t,a=r.document.documentElement;return[void 0!==r.pageXOffset?{elm:r,top:r.pageYOffset,left:r.pageXOffset}:{elm:a,top:a.scrollTop,left:a.scrollLeft}].concat(function e(t){return Array.from(t.children||t.childNodes||[]).reduce(function(t,r){var n=re.utils.getScroll(r);return n&&t.push(n),t.concat(e(r))},[])}(n.body))},re.utils.setScrollState=function(e){e.forEach(function(e){return function(e,r,n){if(e===t)return e.scroll(n,r);e.scrollTop=r,e.scrollLeft=n}(e.elm,e.top,e.left)})},re.utils.select=function(e,t){"use strict";var r,n=[];if(re._selectCache)for(var a=0,o=re._selectCache.length;a<o;a++){var i=re._selectCache[a];if(i.selector===e)return i.result}for(var s,l=function(e){return We(e,s)},u=(s=t).include.reduce(function(e,t){return e.length&&re.utils.contains(e[e.length-1],t)||e.push(t),e},[]),c=0;c<u.length;c++)r=u[c],n=Ye(n,re.utils.querySelectorAllFilter(r,e,l));return re._selectCache&&re._selectCache.push({selector:e,result:n}),n},re.utils.toArray=function(e){"use strict";return Array.prototype.slice.call(e)},re.utils.uniqueArray=function(e,t){return e.concat(t).filter(function(e,t,r){return r.indexOf(e)===t})},re.utils.tokenList=function(e){"use strict";return e.trim().replace(/\\s{2,}/g," ").split(" ")},function(e){var t,r=e.crypto||e.msCrypto;if(!t&&r&&r.getRandomValues){var n=new Uint8Array(16);t=function(){return r.getRandomValues(n),n}}if(!t){var a=new Array(16);t=function(){for(var e,t=0;t<16;t++)0==(3&t)&&(e=4294967296*Math.random()),a[t]=e>>>((3&t)<<3)&255;return a}}for(var o="function"==typeof e.Buffer?e.Buffer:Array,i=[],s={},l=0;l<256;l++)i[l]=(l+256).toString(16).substr(1),s[i[l]]=l;function u(e,t){var r=t||0;return i[e[r++]]+i[e[r++]]+i[e[r++]]+i[e[r++]]+"-"+i[e[r++]]+i[e[r++]]+"-"+i[e[r++]]+i[e[r++]]+"-"+i[e[r++]]+i[e[r++]]+"-"+i[e[r++]]+i[e[r++]]+i[e[r++]]+i[e[r++]]+i[e[r++]]+i[e[r++]]}var c=t(),d=[1|c[0],c[1],c[2],c[3],c[4],c[5]],p=16383&(c[6]<<8|c[7]),m=0,f=0;function h(e,t,r){var n=t&&r||0,a=t||[],o=null!=(e=e||{}).clockseq?e.clockseq:p,i=null!=e.msecs?e.msecs:(new Date).getTime(),s=null!=e.nsecs?e.nsecs:f+1,l=i-m+(s-f)/1e4;if(l<0&&null==e.clockseq&&(o=o+1&16383),(l<0||m<i)&&null==e.nsecs&&(s=0),1e4<=s)throw new Error("uuid.v1(): Can\'t create more than 10M uuids/sec");m=i,p=o;var c=(1e4*(268435455&(i+=122192928e5))+(f=s))%4294967296;a[n++]=c>>>24&255,a[n++]=c>>>16&255,a[n++]=c>>>8&255,a[n++]=255&c;var h=i/4294967296*1e4&268435455;a[n++]=h>>>8&255,a[n++]=255&h,a[n++]=h>>>24&15|16,a[n++]=h>>>16&255,a[n++]=o>>>8|128,a[n++]=255&o;for(var b=e.node||d,g=0;g<6;g++)a[n+g]=b[g];return t||u(a)}function b(e,r,n){var a=r&&n||0;"string"==typeof e&&(r="binary"==e?new o(16):null,e=null);var i=(e=e||{}).random||(e.rng||t)();if(i[6]=15&i[6]|64,i[8]=63&i[8]|128,r)for(var s=0;s<16;s++)r[a+s]=i[s];return r||u(i)}(Be=b).v1=h,Be.v4=b,Be.parse=function(e,t,r){var n=t&&r||0,a=0;for(t=t||[],e.toLowerCase().replace(/[0-9a-f]{2}/g,function(e){a<16&&(t[n+a++]=s[e])});a<16;)t[n+a++]=0;return t},Be.unparse=u,Be.BufferClass=o,re._uuid=h()}(t),re.utils.validInputTypes=function(){"use strict";return["hidden","text","search","tel","url","email","password","date","month","week","time","datetime-local","number","range","color","checkbox","radio","file","submit","image","reset","button"]};var Ke=["aa","ab","ae","af","ak","am","an","ar","as","av","ay","az","ba","be","bg","bh","bi","bm","bn","bo","br","bs","ca","ce","ch","co","cr","cs","cu","cv","cy","da","de","dv","dz","ee","el","en","eo","es","et","eu","fa","ff","fi","fj","fo","fr","fy","ga","gd","gl","gn","gu","gv","ha","he","hi","ho","hr","ht","hu","hy","hz","ia","id","ie","ig","ii","ik","in","io","is","it","iu","iw","ja","ji","jv","jw","ka","kg","ki","kj","kk","kl","km","kn","ko","kr","ks","ku","kv","kw","ky","la","lb","lg","li","ln","lo","lt","lu","lv","mg","mh","mi","mk","ml","mn","mo","mr","ms","mt","my","na","nb","nd","ne","ng","nl","nn","no","nr","nv","ny","oc","oj","om","or","os","pa","pi","pl","ps","pt","qu","rm","rn","ro","ru","rw","sa","sc","sd","se","sg","sh","si","sk","sl","sm","sn","so","sq","sr","ss","st","su","sv","sw","ta","te","tg","th","ti","tk","tl","tn","to","tr","ts","tt","tw","ty","ug","uk","ur","uz","ve","vi","vo","wa","wo","xh","yi","yo","za","zh","zu","aaa","aab","aac","aad","aae","aaf","aag","aah","aai","aak","aal","aam","aan","aao","aap","aaq","aas","aat","aau","aav","aaw","aax","aaz","aba","abb","abc","abd","abe","abf","abg","abh","abi","abj","abl","abm","abn","abo","abp","abq","abr","abs","abt","abu","abv","abw","abx","aby","abz","aca","acb","acd","ace","acf","ach","aci","ack","acl","acm","acn","acp","acq","acr","acs","act","acu","acv","acw","acx","acy","acz","ada","adb","add","ade","adf","adg","adh","adi","adj","adl","adn","ado","adp","adq","adr","ads","adt","adu","adw","adx","ady","adz","aea","aeb","aec","aed","aee","aek","ael","aem","aen","aeq","aer","aes","aeu","aew","aey","aez","afa","afb","afd","afe","afg","afh","afi","afk","afn","afo","afp","afs","aft","afu","afz","aga","agb","agc","agd","age","agf","agg","agh","agi","agj","agk","agl","agm","agn","ago","agp","agq","agr","ags","agt","agu","agv","agw","agx","agy","agz","aha","ahb","ahg","ahh","ahi","ahk","ahl","ahm","ahn","aho","ahp","ahr","ahs","aht","aia","aib","aic","aid","aie","aif","aig","aih","aii","aij","aik","ail","aim","ain","aio","aip","aiq","air","ais","ait","aiw","aix","aiy","aja","ajg","aji","ajn","ajp","ajt","aju","ajw","ajz","akb","akc","akd","ake","akf","akg","akh","aki","akj","akk","akl","akm","ako","akp","akq","akr","aks","akt","aku","akv","akw","akx","aky","akz","ala","alc","ald","ale","alf","alg","alh","ali","alj","alk","all","alm","aln","alo","alp","alq","alr","als","alt","alu","alv","alw","alx","aly","alz","ama","amb","amc","ame","amf","amg","ami","amj","amk","aml","amm","amn","amo","amp","amq","amr","ams","amt","amu","amv","amw","amx","amy","amz","ana","anb","anc","and","ane","anf","ang","anh","ani","anj","ank","anl","anm","ann","ano","anp","anq","anr","ans","ant","anu","anv","anw","anx","any","anz","aoa","aob","aoc","aod","aoe","aof","aog","aoh","aoi","aoj","aok","aol","aom","aon","aor","aos","aot","aou","aox","aoz","apa","apb","apc","apd","ape","apf","apg","aph","api","apj","apk","apl","apm","apn","apo","app","apq","apr","aps","apt","apu","apv","apw","apx","apy","apz","aqa","aqc","aqd","aqg","aql","aqm","aqn","aqp","aqr","aqt","aqz","arb","arc","ard","are","arh","ari","arj","ark","arl","arn","aro","arp","arq","arr","ars","art","aru","arv","arw","arx","ary","arz","asa","asb","asc","asd","ase","asf","asg","ash","asi","asj","ask","asl","asn","aso","asp","asq","asr","ass","ast","asu","asv","asw","asx","asy","asz","ata","atb","atc","atd","ate","atg","ath","ati","atj","atk","atl","atm","atn","ato","atp","atq","atr","ats","att","atu","atv","atw","atx","aty","atz","aua","aub","auc","aud","aue","auf","aug","auh","aui","auj","auk","aul","aum","aun","auo","aup","auq","aur","aus","aut","auu","auw","aux","auy","auz","avb","avd","avi","avk","avl","avm","avn","avo","avs","avt","avu","avv","awa","awb","awc","awd","awe","awg","awh","awi","awk","awm","awn","awo","awr","aws","awt","awu","awv","aww","awx","awy","axb","axe","axg","axk","axl","axm","axx","aya","ayb","ayc","ayd","aye","ayg","ayh","ayi","ayk","ayl","ayn","ayo","ayp","ayq","ayr","ays","ayt","ayu","ayx","ayy","ayz","aza","azb","azc","azd","azg","azj","azm","azn","azo","azt","azz","baa","bab","bac","bad","bae","baf","bag","bah","bai","baj","bal","ban","bao","bap","bar","bas","bat","bau","bav","baw","bax","bay","baz","bba","bbb","bbc","bbd","bbe","bbf","bbg","bbh","bbi","bbj","bbk","bbl","bbm","bbn","bbo","bbp","bbq","bbr","bbs","bbt","bbu","bbv","bbw","bbx","bby","bbz","bca","bcb","bcc","bcd","bce","bcf","bcg","bch","bci","bcj","bck","bcl","bcm","bcn","bco","bcp","bcq","bcr","bcs","bct","bcu","bcv","bcw","bcy","bcz","bda","bdb","bdc","bdd","bde","bdf","bdg","bdh","bdi","bdj","bdk","bdl","bdm","bdn","bdo","bdp","bdq","bdr","bds","bdt","bdu","bdv","bdw","bdx","bdy","bdz","bea","beb","bec","bed","bee","bef","beg","beh","bei","bej","bek","bem","beo","bep","beq","ber","bes","bet","beu","bev","bew","bex","bey","bez","bfa","bfb","bfc","bfd","bfe","bff","bfg","bfh","bfi","bfj","bfk","bfl","bfm","bfn","bfo","bfp","bfq","bfr","bfs","bft","bfu","bfw","bfx","bfy","bfz","bga","bgb","bgc","bgd","bge","bgf","bgg","bgi","bgj","bgk","bgl","bgm","bgn","bgo","bgp","bgq","bgr","bgs","bgt","bgu","bgv","bgw","bgx","bgy","bgz","bha","bhb","bhc","bhd","bhe","bhf","bhg","bhh","bhi","bhj","bhk","bhl","bhm","bhn","bho","bhp","bhq","bhr","bhs","bht","bhu","bhv","bhw","bhx","bhy","bhz","bia","bib","bic","bid","bie","bif","big","bij","bik","bil","bim","bin","bio","bip","biq","bir","bit","biu","biv","biw","bix","biy","biz","bja","bjb","bjc","bjd","bje","bjf","bjg","bjh","bji","bjj","bjk","bjl","bjm","bjn","bjo","bjp","bjq","bjr","bjs","bjt","bju","bjv","bjw","bjx","bjy","bjz","bka","bkb","bkc","bkd","bkf","bkg","bkh","bki","bkj","bkk","bkl","bkm","bkn","bko","bkp","bkq","bkr","bks","bkt","bku","bkv","bkw","bkx","bky","bkz","bla","blb","blc","bld","ble","blf","blg","blh","bli","blj","blk","bll","blm","bln","blo","blp","blq","blr","bls","blt","blv","blw","blx","bly","blz","bma","bmb","bmc","bmd","bme","bmf","bmg","bmh","bmi","bmj","bmk","bml","bmm","bmn","bmo","bmp","bmq","bmr","bms","bmt","bmu","bmv","bmw","bmx","bmy","bmz","bna","bnb","bnc","bnd","bne","bnf","bng","bni","bnj","bnk","bnl","bnm","bnn","bno","bnp","bnq","bnr","bns","bnt","bnu","bnv","bnw","bnx","bny","bnz","boa","bob","boe","bof","bog","boh","boi","boj","bok","bol","bom","bon","boo","bop","boq","bor","bot","bou","bov","bow","box","boy","boz","bpa","bpb","bpd","bpg","bph","bpi","bpj","bpk","bpl","bpm","bpn","bpo","bpp","bpq","bpr","bps","bpt","bpu","bpv","bpw","bpx","bpy","bpz","bqa","bqb","bqc","bqd","bqf","bqg","bqh","bqi","bqj","bqk","bql","bqm","bqn","bqo","bqp","bqq","bqr","bqs","bqt","bqu","bqv","bqw","bqx","bqy","bqz","bra","brb","brc","brd","brf","brg","brh","bri","brj","brk","brl","brm","brn","bro","brp","brq","brr","brs","brt","bru","brv","brw","brx","bry","brz","bsa","bsb","bsc","bse","bsf","bsg","bsh","bsi","bsj","bsk","bsl","bsm","bsn","bso","bsp","bsq","bsr","bss","bst","bsu","bsv","bsw","bsx","bsy","bta","btb","btc","btd","bte","btf","btg","bth","bti","btj","btk","btl","btm","btn","bto","btp","btq","btr","bts","btt","btu","btv","btw","btx","bty","btz","bua","bub","buc","bud","bue","buf","bug","buh","bui","buj","buk","bum","bun","buo","bup","buq","bus","but","buu","buv","buw","bux","buy","buz","bva","bvb","bvc","bvd","bve","bvf","bvg","bvh","bvi","bvj","bvk","bvl","bvm","bvn","bvo","bvp","bvq","bvr","bvt","bvu","bvv","bvw","bvx","bvy","bvz","bwa","bwb","bwc","bwd","bwe","bwf","bwg","bwh","bwi","bwj","bwk","bwl","bwm","bwn","bwo","bwp","bwq","bwr","bws","bwt","bwu","bww","bwx","bwy","bwz","bxa","bxb","bxc","bxd","bxe","bxf","bxg","bxh","bxi","bxj","bxk","bxl","bxm","bxn","bxo","bxp","bxq","bxr","bxs","bxu","bxv","bxw","bxx","bxz","bya","byb","byc","byd","bye","byf","byg","byh","byi","byj","byk","byl","bym","byn","byo","byp","byq","byr","bys","byt","byv","byw","byx","byy","byz","bza","bzb","bzc","bzd","bze","bzf","bzg","bzh","bzi","bzj","bzk","bzl","bzm","bzn","bzo","bzp","bzq","bzr","bzs","bzt","bzu","bzv","bzw","bzx","bzy","bzz","caa","cab","cac","cad","cae","caf","cag","cah","cai","caj","cak","cal","cam","can","cao","cap","caq","car","cas","cau","cav","caw","cax","cay","caz","cba","cbb","cbc","cbd","cbe","cbg","cbh","cbi","cbj","cbk","cbl","cbn","cbo","cbq","cbr","cbs","cbt","cbu","cbv","cbw","cby","cca","ccc","ccd","cce","ccg","cch","ccj","ccl","ccm","ccn","cco","ccp","ccq","ccr","ccs","cda","cdc","cdd","cde","cdf","cdg","cdh","cdi","cdj","cdm","cdn","cdo","cdr","cds","cdy","cdz","cea","ceb","ceg","cek","cel","cen","cet","cfa","cfd","cfg","cfm","cga","cgc","cgg","cgk","chb","chc","chd","chf","chg","chh","chj","chk","chl","chm","chn","cho","chp","chq","chr","cht","chw","chx","chy","chz","cia","cib","cic","cid","cie","cih","cik","cim","cin","cip","cir","ciw","ciy","cja","cje","cjh","cji","cjk","cjm","cjn","cjo","cjp","cjr","cjs","cjv","cjy","cka","ckb","ckh","ckl","ckn","cko","ckq","ckr","cks","ckt","cku","ckv","ckx","cky","ckz","cla","clc","cld","cle","clh","cli","clj","clk","cll","clm","clo","clt","clu","clw","cly","cma","cmc","cme","cmg","cmi","cmk","cml","cmm","cmn","cmo","cmr","cms","cmt","cna","cnb","cnc","cng","cnh","cni","cnk","cnl","cno","cnr","cns","cnt","cnu","cnw","cnx","coa","cob","coc","cod","coe","cof","cog","coh","coj","cok","col","com","con","coo","cop","coq","cot","cou","cov","cow","cox","coy","coz","cpa","cpb","cpc","cpe","cpf","cpg","cpi","cpn","cpo","cpp","cps","cpu","cpx","cpy","cqd","cqu","cra","crb","crc","crd","crf","crg","crh","cri","crj","crk","crl","crm","crn","cro","crp","crq","crr","crs","crt","crv","crw","crx","cry","crz","csa","csb","csc","csd","cse","csf","csg","csh","csi","csj","csk","csl","csm","csn","cso","csq","csr","css","cst","csu","csv","csw","csy","csz","cta","ctc","ctd","cte","ctg","cth","ctl","ctm","ctn","cto","ctp","cts","ctt","ctu","ctz","cua","cub","cuc","cug","cuh","cui","cuj","cuk","cul","cum","cuo","cup","cuq","cur","cus","cut","cuu","cuv","cuw","cux","cuy","cvg","cvn","cwa","cwb","cwd","cwe","cwg","cwt","cya","cyb","cyo","czh","czk","czn","czo","czt","daa","dac","dad","dae","daf","dag","dah","dai","daj","dak","dal","dam","dao","dap","daq","dar","das","dau","dav","daw","dax","day","daz","dba","dbb","dbd","dbe","dbf","dbg","dbi","dbj","dbl","dbm","dbn","dbo","dbp","dbq","dbr","dbt","dbu","dbv","dbw","dby","dcc","dcr","dda","ddd","dde","ddg","ddi","ddj","ddn","ddo","ddr","dds","ddw","dec","ded","dee","def","deg","deh","dei","dek","del","dem","den","dep","deq","der","des","dev","dez","dga","dgb","dgc","dgd","dge","dgg","dgh","dgi","dgk","dgl","dgn","dgo","dgr","dgs","dgt","dgu","dgw","dgx","dgz","dha","dhd","dhg","dhi","dhl","dhm","dhn","dho","dhr","dhs","dhu","dhv","dhw","dhx","dia","dib","dic","did","dif","dig","dih","dii","dij","dik","dil","dim","din","dio","dip","diq","dir","dis","dit","diu","diw","dix","diy","diz","dja","djb","djc","djd","dje","djf","dji","djj","djk","djl","djm","djn","djo","djr","dju","djw","dka","dkk","dkl","dkr","dks","dkx","dlg","dlk","dlm","dln","dma","dmb","dmc","dmd","dme","dmg","dmk","dml","dmm","dmn","dmo","dmr","dms","dmu","dmv","dmw","dmx","dmy","dna","dnd","dne","dng","dni","dnj","dnk","dnn","dnr","dnt","dnu","dnv","dnw","dny","doa","dob","doc","doe","dof","doh","doi","dok","dol","don","doo","dop","doq","dor","dos","dot","dov","dow","dox","doy","doz","dpp","dra","drb","drc","drd","dre","drg","drh","dri","drl","drn","dro","drq","drr","drs","drt","dru","drw","dry","dsb","dse","dsh","dsi","dsl","dsn","dso","dsq","dta","dtb","dtd","dth","dti","dtk","dtm","dtn","dto","dtp","dtr","dts","dtt","dtu","dty","dua","dub","duc","dud","due","duf","dug","duh","dui","duj","duk","dul","dum","dun","duo","dup","duq","dur","dus","duu","duv","duw","dux","duy","duz","dva","dwa","dwl","dwr","dws","dwu","dww","dwy","dya","dyb","dyd","dyg","dyi","dym","dyn","dyo","dyu","dyy","dza","dzd","dze","dzg","dzl","dzn","eaa","ebg","ebk","ebo","ebr","ebu","ecr","ecs","ecy","eee","efa","efe","efi","ega","egl","ego","egx","egy","ehu","eip","eit","eiv","eja","eka","ekc","eke","ekg","eki","ekk","ekl","ekm","eko","ekp","ekr","eky","ele","elh","eli","elk","elm","elo","elp","elu","elx","ema","emb","eme","emg","emi","emk","emm","emn","emo","emp","ems","emu","emw","emx","emy","ena","enb","enc","end","enf","enh","enl","enm","enn","eno","enq","enr","enu","env","enw","enx","eot","epi","era","erg","erh","eri","erk","ero","err","ers","ert","erw","ese","esg","esh","esi","esk","esl","esm","esn","eso","esq","ess","esu","esx","esy","etb","etc","eth","etn","eto","etr","ets","ett","etu","etx","etz","euq","eve","evh","evn","ewo","ext","eya","eyo","eza","eze","faa","fab","fad","faf","fag","fah","fai","faj","fak","fal","fam","fan","fap","far","fat","fau","fax","fay","faz","fbl","fcs","fer","ffi","ffm","fgr","fia","fie","fil","fip","fir","fit","fiu","fiw","fkk","fkv","fla","flh","fli","fll","fln","flr","fly","fmp","fmu","fnb","fng","fni","fod","foi","fom","fon","for","fos","fox","fpe","fqs","frc","frd","frk","frm","fro","frp","frq","frr","frs","frt","fse","fsl","fss","fub","fuc","fud","fue","fuf","fuh","fui","fuj","fum","fun","fuq","fur","fut","fuu","fuv","fuy","fvr","fwa","fwe","gaa","gab","gac","gad","gae","gaf","gag","gah","gai","gaj","gak","gal","gam","gan","gao","gap","gaq","gar","gas","gat","gau","gav","gaw","gax","gay","gaz","gba","gbb","gbc","gbd","gbe","gbf","gbg","gbh","gbi","gbj","gbk","gbl","gbm","gbn","gbo","gbp","gbq","gbr","gbs","gbu","gbv","gbw","gbx","gby","gbz","gcc","gcd","gce","gcf","gcl","gcn","gcr","gct","gda","gdb","gdc","gdd","gde","gdf","gdg","gdh","gdi","gdj","gdk","gdl","gdm","gdn","gdo","gdq","gdr","gds","gdt","gdu","gdx","gea","geb","gec","ged","geg","geh","gei","gej","gek","gel","gem","geq","ges","gev","gew","gex","gey","gez","gfk","gft","gfx","gga","ggb","ggd","gge","ggg","ggk","ggl","ggn","ggo","ggr","ggt","ggu","ggw","gha","ghc","ghe","ghh","ghk","ghl","ghn","gho","ghr","ghs","ght","gia","gib","gic","gid","gie","gig","gih","gil","gim","gin","gio","gip","giq","gir","gis","git","giu","giw","gix","giy","giz","gji","gjk","gjm","gjn","gjr","gju","gka","gkd","gke","gkn","gko","gkp","gku","glc","gld","glh","gli","glj","glk","gll","glo","glr","glu","glw","gly","gma","gmb","gmd","gme","gmg","gmh","gml","gmm","gmn","gmq","gmu","gmv","gmw","gmx","gmy","gmz","gna","gnb","gnc","gnd","gne","gng","gnh","gni","gnj","gnk","gnl","gnm","gnn","gno","gnq","gnr","gnt","gnu","gnw","gnz","goa","gob","goc","god","goe","gof","gog","goh","goi","goj","gok","gol","gom","gon","goo","gop","goq","gor","gos","got","gou","gow","gox","goy","goz","gpa","gpe","gpn","gqa","gqi","gqn","gqr","gqu","gra","grb","grc","grd","grg","grh","gri","grj","grk","grm","gro","grq","grr","grs","grt","gru","grv","grw","grx","gry","grz","gse","gsg","gsl","gsm","gsn","gso","gsp","gss","gsw","gta","gti","gtu","gua","gub","guc","gud","gue","guf","gug","guh","gui","guk","gul","gum","gun","guo","gup","guq","gur","gus","gut","guu","guv","guw","gux","guz","gva","gvc","gve","gvf","gvj","gvl","gvm","gvn","gvo","gvp","gvr","gvs","gvy","gwa","gwb","gwc","gwd","gwe","gwf","gwg","gwi","gwj","gwm","gwn","gwr","gwt","gwu","gww","gwx","gxx","gya","gyb","gyd","gye","gyf","gyg","gyi","gyl","gym","gyn","gyo","gyr","gyy","gza","gzi","gzn","haa","hab","hac","had","hae","haf","hag","hah","hai","haj","hak","hal","ham","han","hao","hap","haq","har","has","hav","haw","hax","hay","haz","hba","hbb","hbn","hbo","hbu","hca","hch","hdn","hds","hdy","hea","hed","heg","heh","hei","hem","hgm","hgw","hhi","hhr","hhy","hia","hib","hid","hif","hig","hih","hii","hij","hik","hil","him","hio","hir","hit","hiw","hix","hji","hka","hke","hkk","hkn","hks","hla","hlb","hld","hle","hlt","hlu","hma","hmb","hmc","hmd","hme","hmf","hmg","hmh","hmi","hmj","hmk","hml","hmm","hmn","hmp","hmq","hmr","hms","hmt","hmu","hmv","hmw","hmx","hmy","hmz","hna","hnd","hne","hnh","hni","hnj","hnn","hno","hns","hnu","hoa","hob","hoc","hod","hoe","hoh","hoi","hoj","hok","hol","hom","hoo","hop","hor","hos","hot","hov","how","hoy","hoz","hpo","hps","hra","hrc","hre","hrk","hrm","hro","hrp","hrr","hrt","hru","hrw","hrx","hrz","hsb","hsh","hsl","hsn","hss","hti","hto","hts","htu","htx","hub","huc","hud","hue","huf","hug","huh","hui","huj","huk","hul","hum","huo","hup","huq","hur","hus","hut","huu","huv","huw","hux","huy","huz","hvc","hve","hvk","hvn","hvv","hwa","hwc","hwo","hya","hyw","hyx","iai","ian","iap","iar","iba","ibb","ibd","ibe","ibg","ibh","ibi","ibl","ibm","ibn","ibr","ibu","iby","ica","ich","icl","icr","ida","idb","idc","idd","ide","idi","idr","ids","idt","idu","ifa","ifb","ife","iff","ifk","ifm","ifu","ify","igb","ige","igg","igl","igm","ign","igo","igs","igw","ihb","ihi","ihp","ihw","iin","iir","ijc","ije","ijj","ijn","ijo","ijs","ike","iki","ikk","ikl","iko","ikp","ikr","iks","ikt","ikv","ikw","ikx","ikz","ila","ilb","ilg","ili","ilk","ill","ilm","ilo","ilp","ils","ilu","ilv","ilw","ima","ime","imi","iml","imn","imo","imr","ims","imy","inb","inc","ine","ing","inh","inj","inl","inm","inn","ino","inp","ins","int","inz","ior","iou","iow","ipi","ipo","iqu","iqw","ira","ire","irh","iri","irk","irn","iro","irr","iru","irx","iry","isa","isc","isd","ise","isg","ish","isi","isk","ism","isn","iso","isr","ist","isu","itb","itc","itd","ite","iti","itk","itl","itm","ito","itr","its","itt","itv","itw","itx","ity","itz","ium","ivb","ivv","iwk","iwm","iwo","iws","ixc","ixl","iya","iyo","iyx","izh","izi","izr","izz","jaa","jab","jac","jad","jae","jaf","jah","jaj","jak","jal","jam","jan","jao","jaq","jar","jas","jat","jau","jax","jay","jaz","jbe","jbi","jbj","jbk","jbn","jbo","jbr","jbt","jbu","jbw","jcs","jct","jda","jdg","jdt","jeb","jee","jeg","jeh","jei","jek","jel","jen","jer","jet","jeu","jgb","jge","jgk","jgo","jhi","jhs","jia","jib","jic","jid","jie","jig","jih","jii","jil","jim","jio","jiq","jit","jiu","jiv","jiy","jje","jjr","jka","jkm","jko","jkp","jkr","jku","jle","jls","jma","jmb","jmc","jmd","jmi","jml","jmn","jmr","jms","jmw","jmx","jna","jnd","jng","jni","jnj","jnl","jns","job","jod","jog","jor","jos","jow","jpa","jpr","jpx","jqr","jra","jrb","jrr","jrt","jru","jsl","jua","jub","juc","jud","juh","jui","juk","jul","jum","jun","juo","jup","jur","jus","jut","juu","juw","juy","jvd","jvn","jwi","jya","jye","jyy","kaa","kab","kac","kad","kae","kaf","kag","kah","kai","kaj","kak","kam","kao","kap","kaq","kar","kav","kaw","kax","kay","kba","kbb","kbc","kbd","kbe","kbf","kbg","kbh","kbi","kbj","kbk","kbl","kbm","kbn","kbo","kbp","kbq","kbr","kbs","kbt","kbu","kbv","kbw","kbx","kby","kbz","kca","kcb","kcc","kcd","kce","kcf","kcg","kch","kci","kcj","kck","kcl","kcm","kcn","kco","kcp","kcq","kcr","kcs","kct","kcu","kcv","kcw","kcx","kcy","kcz","kda","kdc","kdd","kde","kdf","kdg","kdh","kdi","kdj","kdk","kdl","kdm","kdn","kdo","kdp","kdq","kdr","kdt","kdu","kdv","kdw","kdx","kdy","kdz","kea","keb","kec","ked","kee","kef","keg","keh","kei","kej","kek","kel","kem","ken","keo","kep","keq","ker","kes","ket","keu","kev","kew","kex","key","kez","kfa","kfb","kfc","kfd","kfe","kff","kfg","kfh","kfi","kfj","kfk","kfl","kfm","kfn","kfo","kfp","kfq","kfr","kfs","kft","kfu","kfv","kfw","kfx","kfy","kfz","kga","kgb","kgc","kgd","kge","kgf","kgg","kgh","kgi","kgj","kgk","kgl","kgm","kgn","kgo","kgp","kgq","kgr","kgs","kgt","kgu","kgv","kgw","kgx","kgy","kha","khb","khc","khd","khe","khf","khg","khh","khi","khj","khk","khl","khn","kho","khp","khq","khr","khs","kht","khu","khv","khw","khx","khy","khz","kia","kib","kic","kid","kie","kif","kig","kih","kii","kij","kil","kim","kio","kip","kiq","kis","kit","kiu","kiv","kiw","kix","kiy","kiz","kja","kjb","kjc","kjd","kje","kjf","kjg","kjh","kji","kjj","kjk","kjl","kjm","kjn","kjo","kjp","kjq","kjr","kjs","kjt","kju","kjv","kjx","kjy","kjz","kka","kkb","kkc","kkd","kke","kkf","kkg","kkh","kki","kkj","kkk","kkl","kkm","kkn","kko","kkp","kkq","kkr","kks","kkt","kku","kkv","kkw","kkx","kky","kkz","kla","klb","klc","kld","kle","klf","klg","klh","kli","klj","klk","kll","klm","kln","klo","klp","klq","klr","kls","klt","klu","klv","klw","klx","kly","klz","kma","kmb","kmc","kmd","kme","kmf","kmg","kmh","kmi","kmj","kmk","kml","kmm","kmn","kmo","kmp","kmq","kmr","kms","kmt","kmu","kmv","kmw","kmx","kmy","kmz","kna","knb","knc","knd","kne","knf","kng","kni","knj","knk","knl","knm","knn","kno","knp","knq","knr","kns","knt","knu","knv","knw","knx","kny","knz","koa","koc","kod","koe","kof","kog","koh","koi","koj","kok","kol","koo","kop","koq","kos","kot","kou","kov","kow","kox","koy","koz","kpa","kpb","kpc","kpd","kpe","kpf","kpg","kph","kpi","kpj","kpk","kpl","kpm","kpn","kpo","kpp","kpq","kpr","kps","kpt","kpu","kpv","kpw","kpx","kpy","kpz","kqa","kqb","kqc","kqd","kqe","kqf","kqg","kqh","kqi","kqj","kqk","kql","kqm","kqn","kqo","kqp","kqq","kqr","kqs","kqt","kqu","kqv","kqw","kqx","kqy","kqz","kra","krb","krc","krd","kre","krf","krh","kri","krj","krk","krl","krm","krn","kro","krp","krr","krs","krt","kru","krv","krw","krx","kry","krz","ksa","ksb","ksc","ksd","kse","ksf","ksg","ksh","ksi","ksj","ksk","ksl","ksm","ksn","kso","ksp","ksq","ksr","kss","kst","ksu","ksv","ksw","ksx","ksy","ksz","kta","ktb","ktc","ktd","kte","ktf","ktg","kth","kti","ktj","ktk","ktl","ktm","ktn","kto","ktp","ktq","ktr","kts","ktt","ktu","ktv","ktw","ktx","kty","ktz","kub","kuc","kud","kue","kuf","kug","kuh","kui","kuj","kuk","kul","kum","kun","kuo","kup","kuq","kus","kut","kuu","kuv","kuw","kux","kuy","kuz","kva","kvb","kvc","kvd","kve","kvf","kvg","kvh","kvi","kvj","kvk","kvl","kvm","kvn","kvo","kvp","kvq","kvr","kvs","kvt","kvu","kvv","kvw","kvx","kvy","kvz","kwa","kwb","kwc","kwd","kwe","kwf","kwg","kwh","kwi","kwj","kwk","kwl","kwm","kwn","kwo","kwp","kwq","kwr","kws","kwt","kwu","kwv","kww","kwx","kwy","kwz","kxa","kxb","kxc","kxd","kxe","kxf","kxh","kxi","kxj","kxk","kxl","kxm","kxn","kxo","kxp","kxq","kxr","kxs","kxt","kxu","kxv","kxw","kxx","kxy","kxz","kya","kyb","kyc","kyd","kye","kyf","kyg","kyh","kyi","kyj","kyk","kyl","kym","kyn","kyo","kyp","kyq","kyr","kys","kyt","kyu","kyv","kyw","kyx","kyy","kyz","kza","kzb","kzc","kzd","kze","kzf","kzg","kzh","kzi","kzj","kzk","kzl","kzm","kzn","kzo","kzp","kzq","kzr","kzs","kzt","kzu","kzv","kzw","kzx","kzy","kzz","laa","lab","lac","lad","lae","laf","lag","lah","lai","laj","lak","lal","lam","lan","lap","laq","lar","las","lau","law","lax","lay","laz","lba","lbb","lbc","lbe","lbf","lbg","lbi","lbj","lbk","lbl","lbm","lbn","lbo","lbq","lbr","lbs","lbt","lbu","lbv","lbw","lbx","lby","lbz","lcc","lcd","lce","lcf","lch","lcl","lcm","lcp","lcq","lcs","lda","ldb","ldd","ldg","ldh","ldi","ldj","ldk","ldl","ldm","ldn","ldo","ldp","ldq","lea","leb","lec","led","lee","lef","leg","leh","lei","lej","lek","lel","lem","len","leo","lep","leq","ler","les","let","leu","lev","lew","lex","ley","lez","lfa","lfn","lga","lgb","lgg","lgh","lgi","lgk","lgl","lgm","lgn","lgq","lgr","lgt","lgu","lgz","lha","lhh","lhi","lhl","lhm","lhn","lhp","lhs","lht","lhu","lia","lib","lic","lid","lie","lif","lig","lih","lii","lij","lik","lil","lio","lip","liq","lir","lis","liu","liv","liw","lix","liy","liz","lja","lje","lji","ljl","ljp","ljw","ljx","lka","lkb","lkc","lkd","lke","lkh","lki","lkj","lkl","lkm","lkn","lko","lkr","lks","lkt","lku","lky","lla","llb","llc","lld","lle","llf","llg","llh","lli","llj","llk","lll","llm","lln","llo","llp","llq","lls","llu","llx","lma","lmb","lmc","lmd","lme","lmf","lmg","lmh","lmi","lmj","lmk","lml","lmm","lmn","lmo","lmp","lmq","lmr","lmu","lmv","lmw","lmx","lmy","lmz","lna","lnb","lnd","lng","lnh","lni","lnj","lnl","lnm","lnn","lno","lns","lnu","lnw","lnz","loa","lob","loc","loe","lof","log","loh","loi","loj","lok","lol","lom","lon","loo","lop","loq","lor","los","lot","lou","lov","low","lox","loy","loz","lpa","lpe","lpn","lpo","lpx","lra","lrc","lre","lrg","lri","lrk","lrl","lrm","lrn","lro","lrr","lrt","lrv","lrz","lsa","lsd","lse","lsg","lsh","lsi","lsl","lsm","lso","lsp","lsr","lss","lst","lsy","ltc","ltg","lth","lti","ltn","lto","lts","ltu","lua","luc","lud","lue","luf","lui","luj","luk","lul","lum","lun","luo","lup","luq","lur","lus","lut","luu","luv","luw","luy","luz","lva","lvk","lvs","lvu","lwa","lwe","lwg","lwh","lwl","lwm","lwo","lws","lwt","lwu","lww","lya","lyg","lyn","lzh","lzl","lzn","lzz","maa","mab","mad","mae","maf","mag","mai","maj","mak","mam","man","map","maq","mas","mat","mau","mav","maw","max","maz","mba","mbb","mbc","mbd","mbe","mbf","mbh","mbi","mbj","mbk","mbl","mbm","mbn","mbo","mbp","mbq","mbr","mbs","mbt","mbu","mbv","mbw","mbx","mby","mbz","mca","mcb","mcc","mcd","mce","mcf","mcg","mch","mci","mcj","mck","mcl","mcm","mcn","mco","mcp","mcq","mcr","mcs","mct","mcu","mcv","mcw","mcx","mcy","mcz","mda","mdb","mdc","mdd","mde","mdf","mdg","mdh","mdi","mdj","mdk","mdl","mdm","mdn","mdp","mdq","mdr","mds","mdt","mdu","mdv","mdw","mdx","mdy","mdz","mea","meb","mec","med","mee","mef","meg","meh","mei","mej","mek","mel","mem","men","meo","mep","meq","mer","mes","met","meu","mev","mew","mey","mez","mfa","mfb","mfc","mfd","mfe","mff","mfg","mfh","mfi","mfj","mfk","mfl","mfm","mfn","mfo","mfp","mfq","mfr","mfs","mft","mfu","mfv","mfw","mfx","mfy","mfz","mga","mgb","mgc","mgd","mge","mgf","mgg","mgh","mgi","mgj","mgk","mgl","mgm","mgn","mgo","mgp","mgq","mgr","mgs","mgt","mgu","mgv","mgw","mgx","mgy","mgz","mha","mhb","mhc","mhd","mhe","mhf","mhg","mhh","mhi","mhj","mhk","mhl","mhm","mhn","mho","mhp","mhq","mhr","mhs","mht","mhu","mhw","mhx","mhy","mhz","mia","mib","mic","mid","mie","mif","mig","mih","mii","mij","mik","mil","mim","min","mio","mip","miq","mir","mis","mit","miu","miw","mix","miy","miz","mja","mjb","mjc","mjd","mje","mjg","mjh","mji","mjj","mjk","mjl","mjm","mjn","mjo","mjp","mjq","mjr","mjs","mjt","mju","mjv","mjw","mjx","mjy","mjz","mka","mkb","mkc","mke","mkf","mkg","mkh","mki","mkj","mkk","mkl","mkm","mkn","mko","mkp","mkq","mkr","mks","mkt","mku","mkv","mkw","mkx","mky","mkz","mla","mlb","mlc","mld","mle","mlf","mlh","mli","mlj","mlk","mll","mlm","mln","mlo","mlp","mlq","mlr","mls","mlu","mlv","mlw","mlx","mlz","mma","mmb","mmc","mmd","mme","mmf","mmg","mmh","mmi","mmj","mmk","mml","mmm","mmn","mmo","mmp","mmq","mmr","mmt","mmu","mmv","mmw","mmx","mmy","mmz","mna","mnb","mnc","mnd","mne","mnf","mng","mnh","mni","mnj","mnk","mnl","mnm","mnn","mno","mnp","mnq","mnr","mns","mnt","mnu","mnv","mnw","mnx","mny","mnz","moa","moc","mod","moe","mof","mog","moh","moi","moj","mok","mom","moo","mop","moq","mor","mos","mot","mou","mov","mow","mox","moy","moz","mpa","mpb","mpc","mpd","mpe","mpg","mph","mpi","mpj","mpk","mpl","mpm","mpn","mpo","mpp","mpq","mpr","mps","mpt","mpu","mpv","mpw","mpx","mpy","mpz","mqa","mqb","mqc","mqe","mqf","mqg","mqh","mqi","mqj","mqk","mql","mqm","mqn","mqo","mqp","mqq","mqr","mqs","mqt","mqu","mqv","mqw","mqx","mqy","mqz","mra","mrb","mrc","mrd","mre","mrf","mrg","mrh","mrj","mrk","mrl","mrm","mrn","mro","mrp","mrq","mrr","mrs","mrt","mru","mrv","mrw","mrx","mry","mrz","msb","msc","msd","mse","msf","msg","msh","msi","msj","msk","msl","msm","msn","mso","msp","msq","msr","mss","mst","msu","msv","msw","msx","msy","msz","mta","mtb","mtc","mtd","mte","mtf","mtg","mth","mti","mtj","mtk","mtl","mtm","mtn","mto","mtp","mtq","mtr","mts","mtt","mtu","mtv","mtw","mtx","mty","mua","mub","muc","mud","mue","mug","muh","mui","muj","muk","mul","mum","mun","muo","mup","muq","mur","mus","mut","muu","muv","mux","muy","muz","mva","mvb","mvd","mve","mvf","mvg","mvh","mvi","mvk","mvl","mvm","mvn","mvo","mvp","mvq","mvr","mvs","mvt","mvu","mvv","mvw","mvx","mvy","mvz","mwa","mwb","mwc","mwd","mwe","mwf","mwg","mwh","mwi","mwj","mwk","mwl","mwm","mwn","mwo","mwp","mwq","mwr","mws","mwt","mwu","mwv","mww","mwx","mwy","mwz","mxa","mxb","mxc","mxd","mxe","mxf","mxg","mxh","mxi","mxj","mxk","mxl","mxm","mxn","mxo","mxp","mxq","mxr","mxs","mxt","mxu","mxv","mxw","mxx","mxy","mxz","myb","myc","myd","mye","myf","myg","myh","myi","myj","myk","myl","mym","myn","myo","myp","myq","myr","mys","myt","myu","myv","myw","myx","myy","myz","mza","mzb","mzc","mzd","mze","mzg","mzh","mzi","mzj","mzk","mzl","mzm","mzn","mzo","mzp","mzq","mzr","mzs","mzt","mzu","mzv","mzw","mzx","mzy","mzz","naa","nab","nac","nad","nae","naf","nag","nah","nai","naj","nak","nal","nam","nan","nao","nap","naq","nar","nas","nat","naw","nax","nay","naz","nba","nbb","nbc","nbd","nbe","nbf","nbg","nbh","nbi","nbj","nbk","nbm","nbn","nbo","nbp","nbq","nbr","nbs","nbt","nbu","nbv","nbw","nbx","nby","nca","ncb","ncc","ncd","nce","ncf","ncg","nch","nci","ncj","nck","ncl","ncm","ncn","nco","ncp","ncq","ncr","ncs","nct","ncu","ncx","ncz","nda","ndb","ndc","ndd","ndf","ndg","ndh","ndi","ndj","ndk","ndl","ndm","ndn","ndp","ndq","ndr","nds","ndt","ndu","ndv","ndw","ndx","ndy","ndz","nea","neb","nec","ned","nee","nef","neg","neh","nei","nej","nek","nem","nen","neo","neq","ner","nes","net","neu","nev","new","nex","ney","nez","nfa","nfd","nfl","nfr","nfu","nga","ngb","ngc","ngd","nge","ngf","ngg","ngh","ngi","ngj","ngk","ngl","ngm","ngn","ngo","ngp","ngq","ngr","ngs","ngt","ngu","ngv","ngw","ngx","ngy","ngz","nha","nhb","nhc","nhd","nhe","nhf","nhg","nhh","nhi","nhk","nhm","nhn","nho","nhp","nhq","nhr","nht","nhu","nhv","nhw","nhx","nhy","nhz","nia","nib","nic","nid","nie","nif","nig","nih","nii","nij","nik","nil","nim","nin","nio","niq","nir","nis","nit","niu","niv","niw","nix","niy","niz","nja","njb","njd","njh","nji","njj","njl","njm","njn","njo","njr","njs","njt","nju","njx","njy","njz","nka","nkb","nkc","nkd","nke","nkf","nkg","nkh","nki","nkj","nkk","nkm","nkn","nko","nkp","nkq","nkr","nks","nkt","nku","nkv","nkw","nkx","nkz","nla","nlc","nle","nlg","nli","nlj","nlk","nll","nlm","nln","nlo","nlq","nlr","nlu","nlv","nlw","nlx","nly","nlz","nma","nmb","nmc","nmd","nme","nmf","nmg","nmh","nmi","nmj","nmk","nml","nmm","nmn","nmo","nmp","nmq","nmr","nms","nmt","nmu","nmv","nmw","nmx","nmy","nmz","nna","nnb","nnc","nnd","nne","nnf","nng","nnh","nni","nnj","nnk","nnl","nnm","nnn","nnp","nnq","nnr","nns","nnt","nnu","nnv","nnw","nnx","nny","nnz","noa","noc","nod","noe","nof","nog","noh","noi","noj","nok","nol","nom","non","noo","nop","noq","nos","not","nou","nov","now","noy","noz","npa","npb","npg","nph","npi","npl","npn","npo","nps","npu","npx","npy","nqg","nqk","nql","nqm","nqn","nqo","nqq","nqy","nra","nrb","nrc","nre","nrf","nrg","nri","nrk","nrl","nrm","nrn","nrp","nrr","nrt","nru","nrx","nrz","nsa","nsc","nsd","nse","nsf","nsg","nsh","nsi","nsk","nsl","nsm","nsn","nso","nsp","nsq","nsr","nss","nst","nsu","nsv","nsw","nsx","nsy","nsz","ntd","nte","ntg","nti","ntj","ntk","ntm","nto","ntp","ntr","nts","ntu","ntw","ntx","nty","ntz","nua","nub","nuc","nud","nue","nuf","nug","nuh","nui","nuj","nuk","nul","num","nun","nuo","nup","nuq","nur","nus","nut","nuu","nuv","nuw","nux","nuy","nuz","nvh","nvm","nvo","nwa","nwb","nwc","nwe","nwg","nwi","nwm","nwo","nwr","nwx","nwy","nxa","nxd","nxe","nxg","nxi","nxk","nxl","nxm","nxn","nxo","nxq","nxr","nxu","nxx","nyb","nyc","nyd","nye","nyf","nyg","nyh","nyi","nyj","nyk","nyl","nym","nyn","nyo","nyp","nyq","nyr","nys","nyt","nyu","nyv","nyw","nyx","nyy","nza","nzb","nzd","nzi","nzk","nzm","nzs","nzu","nzy","nzz","oaa","oac","oar","oav","obi","obk","obl","obm","obo","obr","obt","obu","oca","och","oco","ocu","oda","odk","odt","odu","ofo","ofs","ofu","ogb","ogc","oge","ogg","ogo","ogu","oht","ohu","oia","oin","ojb","ojc","ojg","ojp","ojs","ojv","ojw","oka","okb","okd","oke","okg","okh","oki","okj","okk","okl","okm","okn","oko","okr","oks","oku","okv","okx","ola","old","ole","olk","olm","olo","olr","olt","olu","oma","omb","omc","ome","omg","omi","omk","oml","omn","omo","omp","omq","omr","omt","omu","omv","omw","omx","ona","onb","one","ong","oni","onj","onk","onn","ono","onp","onr","ons","ont","onu","onw","onx","ood","oog","oon","oor","oos","opa","opk","opm","opo","opt","opy","ora","orc","ore","org","orh","orn","oro","orr","ors","ort","oru","orv","orw","orx","ory","orz","osa","osc","osi","oso","osp","ost","osu","osx","ota","otb","otd","ote","oti","otk","otl","otm","otn","oto","otq","otr","ots","ott","otu","otw","otx","oty","otz","oua","oub","oue","oui","oum","oun","ovd","owi","owl","oyb","oyd","oym","oyy","ozm","paa","pab","pac","pad","pae","paf","pag","pah","pai","pak","pal","pam","pao","pap","paq","par","pas","pat","pau","pav","paw","pax","pay","paz","pbb","pbc","pbe","pbf","pbg","pbh","pbi","pbl","pbm","pbn","pbo","pbp","pbr","pbs","pbt","pbu","pbv","pby","pbz","pca","pcb","pcc","pcd","pce","pcf","pcg","pch","pci","pcj","pck","pcl","pcm","pcn","pcp","pcr","pcw","pda","pdc","pdi","pdn","pdo","pdt","pdu","pea","peb","ped","pee","pef","peg","peh","pei","pej","pek","pel","pem","peo","pep","peq","pes","pev","pex","pey","pez","pfa","pfe","pfl","pga","pgd","pgg","pgi","pgk","pgl","pgn","pgs","pgu","pgy","pgz","pha","phd","phg","phh","phi","phk","phl","phm","phn","pho","phq","phr","pht","phu","phv","phw","pia","pib","pic","pid","pie","pif","pig","pih","pii","pij","pil","pim","pin","pio","pip","pir","pis","pit","piu","piv","piw","pix","piy","piz","pjt","pka","pkb","pkc","pkg","pkh","pkn","pko","pkp","pkr","pks","pkt","pku","pla","plb","plc","pld","ple","plf","plg","plh","plj","plk","pll","pln","plo","plp","plq","plr","pls","plt","plu","plv","plw","ply","plz","pma","pmb","pmc","pmd","pme","pmf","pmh","pmi","pmj","pmk","pml","pmm","pmn","pmo","pmq","pmr","pms","pmt","pmu","pmw","pmx","pmy","pmz","pna","pnb","pnc","pne","png","pnh","pni","pnj","pnk","pnl","pnm","pnn","pno","pnp","pnq","pnr","pns","pnt","pnu","pnv","pnw","pnx","pny","pnz","poc","pod","poe","pof","pog","poh","poi","pok","pom","pon","poo","pop","poq","pos","pot","pov","pow","pox","poy","poz","ppa","ppe","ppi","ppk","ppl","ppm","ppn","ppo","ppp","ppq","ppr","pps","ppt","ppu","pqa","pqe","pqm","pqw","pra","prb","prc","prd","pre","prf","prg","prh","pri","prk","prl","prm","prn","pro","prp","prq","prr","prs","prt","pru","prw","prx","pry","prz","psa","psc","psd","pse","psg","psh","psi","psl","psm","psn","pso","psp","psq","psr","pss","pst","psu","psw","psy","pta","pth","pti","ptn","pto","ptp","ptq","ptr","ptt","ptu","ptv","ptw","pty","pua","pub","puc","pud","pue","puf","pug","pui","puj","puk","pum","puo","pup","puq","pur","put","puu","puw","pux","puy","puz","pwa","pwb","pwg","pwi","pwm","pwn","pwo","pwr","pww","pxm","pye","pym","pyn","pys","pyu","pyx","pyy","pzn","qaa..qtz","qua","qub","quc","qud","quf","qug","quh","qui","quk","qul","qum","qun","qup","quq","qur","qus","quv","quw","qux","quy","quz","qva","qvc","qve","qvh","qvi","qvj","qvl","qvm","qvn","qvo","qvp","qvs","qvw","qvy","qvz","qwa","qwc","qwe","qwh","qwm","qws","qwt","qxa","qxc","qxh","qxl","qxn","qxo","qxp","qxq","qxr","qxs","qxt","qxu","qxw","qya","qyp","raa","rab","rac","rad","raf","rag","rah","rai","raj","rak","ral","ram","ran","rao","rap","raq","rar","ras","rat","rau","rav","raw","rax","ray","raz","rbb","rbk","rbl","rbp","rcf","rdb","rea","reb","ree","reg","rei","rej","rel","rem","ren","rer","res","ret","rey","rga","rge","rgk","rgn","rgr","rgs","rgu","rhg","rhp","ria","rie","rif","ril","rim","rin","rir","rit","riu","rjg","rji","rjs","rka","rkb","rkh","rki","rkm","rkt","rkw","rma","rmb","rmc","rmd","rme","rmf","rmg","rmh","rmi","rmk","rml","rmm","rmn","rmo","rmp","rmq","rmr","rms","rmt","rmu","rmv","rmw","rmx","rmy","rmz","rna","rnd","rng","rnl","rnn","rnp","rnr","rnw","roa","rob","roc","rod","roe","rof","rog","rol","rom","roo","rop","ror","rou","row","rpn","rpt","rri","rro","rrt","rsb","rsi","rsl","rsm","rtc","rth","rtm","rts","rtw","rub","ruc","rue","ruf","rug","ruh","rui","ruk","ruo","rup","ruq","rut","ruu","ruy","ruz","rwa","rwk","rwm","rwo","rwr","rxd","rxw","ryn","rys","ryu","rzh","saa","sab","sac","sad","sae","saf","sah","sai","saj","sak","sal","sam","sao","sap","saq","sar","sas","sat","sau","sav","saw","sax","say","saz","sba","sbb","sbc","sbd","sbe","sbf","sbg","sbh","sbi","sbj","sbk","sbl","sbm","sbn","sbo","sbp","sbq","sbr","sbs","sbt","sbu","sbv","sbw","sbx","sby","sbz","sca","scb","sce","scf","scg","sch","sci","sck","scl","scn","sco","scp","scq","scs","sct","scu","scv","scw","scx","sda","sdb","sdc","sde","sdf","sdg","sdh","sdj","sdk","sdl","sdm","sdn","sdo","sdp","sdr","sds","sdt","sdu","sdv","sdx","sdz","sea","seb","sec","sed","see","sef","seg","seh","sei","sej","sek","sel","sem","sen","seo","sep","seq","ser","ses","set","seu","sev","sew","sey","sez","sfb","sfe","sfm","sfs","sfw","sga","sgb","sgc","sgd","sge","sgg","sgh","sgi","sgj","sgk","sgl","sgm","sgn","sgo","sgp","sgr","sgs","sgt","sgu","sgw","sgx","sgy","sgz","sha","shb","shc","shd","she","shg","shh","shi","shj","shk","shl","shm","shn","sho","shp","shq","shr","shs","sht","shu","shv","shw","shx","shy","shz","sia","sib","sid","sie","sif","sig","sih","sii","sij","sik","sil","sim","sio","sip","siq","sir","sis","sit","siu","siv","siw","six","siy","siz","sja","sjb","sjd","sje","sjg","sjk","sjl","sjm","sjn","sjo","sjp","sjr","sjs","sjt","sju","sjw","ska","skb","skc","skd","ske","skf","skg","skh","ski","skj","skk","skm","skn","sko","skp","skq","skr","sks","skt","sku","skv","skw","skx","sky","skz","sla","slc","sld","sle","slf","slg","slh","sli","slj","sll","slm","sln","slp","slq","slr","sls","slt","slu","slw","slx","sly","slz","sma","smb","smc","smd","smf","smg","smh","smi","smj","smk","sml","smm","smn","smp","smq","smr","sms","smt","smu","smv","smw","smx","smy","smz","snb","snc","sne","snf","sng","snh","sni","snj","snk","snl","snm","snn","sno","snp","snq","snr","sns","snu","snv","snw","snx","sny","snz","soa","sob","soc","sod","soe","sog","soh","soi","soj","sok","sol","son","soo","sop","soq","sor","sos","sou","sov","sow","sox","soy","soz","spb","spc","spd","spe","spg","spi","spk","spl","spm","spn","spo","spp","spq","spr","sps","spt","spu","spv","spx","spy","sqa","sqh","sqj","sqk","sqm","sqn","sqo","sqq","sqr","sqs","sqt","squ","sra","srb","src","sre","srf","srg","srh","sri","srk","srl","srm","srn","sro","srq","srr","srs","srt","sru","srv","srw","srx","sry","srz","ssa","ssb","ssc","ssd","sse","ssf","ssg","ssh","ssi","ssj","ssk","ssl","ssm","ssn","sso","ssp","ssq","ssr","sss","sst","ssu","ssv","ssx","ssy","ssz","sta","stb","std","ste","stf","stg","sth","sti","stj","stk","stl","stm","stn","sto","stp","stq","str","sts","stt","stu","stv","stw","sty","sua","sub","suc","sue","sug","sui","suj","suk","sul","sum","suq","sur","sus","sut","suv","suw","sux","suy","suz","sva","svb","svc","sve","svk","svm","svr","svs","svx","swb","swc","swf","swg","swh","swi","swj","swk","swl","swm","swn","swo","swp","swq","swr","sws","swt","swu","swv","sww","swx","swy","sxb","sxc","sxe","sxg","sxk","sxl","sxm","sxn","sxo","sxr","sxs","sxu","sxw","sya","syb","syc","syd","syi","syk","syl","sym","syn","syo","syr","sys","syw","syx","syy","sza","szb","szc","szd","sze","szg","szl","szn","szp","szs","szv","szw","taa","tab","tac","tad","tae","taf","tag","tai","taj","tak","tal","tan","tao","tap","taq","tar","tas","tau","tav","taw","tax","tay","taz","tba","tbb","tbc","tbd","tbe","tbf","tbg","tbh","tbi","tbj","tbk","tbl","tbm","tbn","tbo","tbp","tbq","tbr","tbs","tbt","tbu","tbv","tbw","tbx","tby","tbz","tca","tcb","tcc","tcd","tce","tcf","tcg","tch","tci","tck","tcl","tcm","tcn","tco","tcp","tcq","tcs","tct","tcu","tcw","tcx","tcy","tcz","tda","tdb","tdc","tdd","tde","tdf","tdg","tdh","tdi","tdj","tdk","tdl","tdm","tdn","tdo","tdq","tdr","tds","tdt","tdu","tdv","tdx","tdy","tea","teb","tec","ted","tee","tef","teg","teh","tei","tek","tem","ten","teo","tep","teq","ter","tes","tet","teu","tev","tew","tex","tey","tez","tfi","tfn","tfo","tfr","tft","tga","tgb","tgc","tgd","tge","tgf","tgg","tgh","tgi","tgj","tgn","tgo","tgp","tgq","tgr","tgs","tgt","tgu","tgv","tgw","tgx","tgy","tgz","thc","thd","the","thf","thh","thi","thk","thl","thm","thn","thp","thq","thr","ths","tht","thu","thv","thw","thx","thy","thz","tia","tic","tid","tie","tif","tig","tih","tii","tij","tik","til","tim","tin","tio","tip","tiq","tis","tit","tiu","tiv","tiw","tix","tiy","tiz","tja","tjg","tji","tjl","tjm","tjn","tjo","tjs","tju","tjw","tka","tkb","tkd","tke","tkf","tkg","tkk","tkl","tkm","tkn","tkp","tkq","tkr","tks","tkt","tku","tkv","tkw","tkx","tkz","tla","tlb","tlc","tld","tlf","tlg","tlh","tli","tlj","tlk","tll","tlm","tln","tlo","tlp","tlq","tlr","tls","tlt","tlu","tlv","tlw","tlx","tly","tma","tmb","tmc","tmd","tme","tmf","tmg","tmh","tmi","tmj","tmk","tml","tmm","tmn","tmo","tmp","tmq","tmr","tms","tmt","tmu","tmv","tmw","tmy","tmz","tna","tnb","tnc","tnd","tne","tnf","tng","tnh","tni","tnk","tnl","tnm","tnn","tno","tnp","tnq","tnr","tns","tnt","tnu","tnv","tnw","tnx","tny","tnz","tob","toc","tod","toe","tof","tog","toh","toi","toj","tol","tom","too","top","toq","tor","tos","tou","tov","tow","tox","toy","toz","tpa","tpc","tpe","tpf","tpg","tpi","tpj","tpk","tpl","tpm","tpn","tpo","tpp","tpq","tpr","tpt","tpu","tpv","tpw","tpx","tpy","tpz","tqb","tql","tqm","tqn","tqo","tqp","tqq","tqr","tqt","tqu","tqw","tra","trb","trc","trd","tre","trf","trg","trh","tri","trj","trk","trl","trm","trn","tro","trp","trq","trr","trs","trt","tru","trv","trw","trx","try","trz","tsa","tsb","tsc","tsd","tse","tsf","tsg","tsh","tsi","tsj","tsk","tsl","tsm","tsp","tsq","tsr","tss","tst","tsu","tsv","tsw","tsx","tsy","tsz","tta","ttb","ttc","ttd","tte","ttf","ttg","tth","tti","ttj","ttk","ttl","ttm","ttn","tto","ttp","ttq","ttr","tts","ttt","ttu","ttv","ttw","tty","ttz","tua","tub","tuc","tud","tue","tuf","tug","tuh","tui","tuj","tul","tum","tun","tuo","tup","tuq","tus","tut","tuu","tuv","tuw","tux","tuy","tuz","tva","tvd","tve","tvk","tvl","tvm","tvn","tvo","tvs","tvt","tvu","tvw","tvy","twa","twb","twc","twd","twe","twf","twg","twh","twl","twm","twn","two","twp","twq","twr","twt","twu","tww","twx","twy","txa","txb","txc","txe","txg","txh","txi","txj","txm","txn","txo","txq","txr","txs","txt","txu","txx","txy","tya","tye","tyh","tyi","tyj","tyl","tyn","typ","tyr","tys","tyt","tyu","tyv","tyx","tyz","tza","tzh","tzj","tzl","tzm","tzn","tzo","tzx","uam","uan","uar","uba","ubi","ubl","ubr","ubu","uby","uda","ude","udg","udi","udj","udl","udm","udu","ues","ufi","uga","ugb","uge","ugn","ugo","ugy","uha","uhn","uis","uiv","uji","uka","ukg","ukh","ukk","ukl","ukp","ukq","uks","uku","ukw","uky","ula","ulb","ulc","ule","ulf","uli","ulk","ull","ulm","uln","ulu","ulw","uma","umb","umc","umd","umg","umi","umm","umn","umo","ump","umr","ums","umu","una","und","une","ung","unk","unm","unn","unp","unr","unu","unx","unz","uok","upi","upv","ura","urb","urc","ure","urf","urg","urh","uri","urj","urk","url","urm","urn","uro","urp","urr","urt","uru","urv","urw","urx","ury","urz","usa","ush","usi","usk","usp","usu","uta","ute","utp","utr","utu","uum","uun","uur","uuu","uve","uvh","uvl","uwa","uya","uzn","uzs","vaa","vae","vaf","vag","vah","vai","vaj","val","vam","van","vao","vap","var","vas","vau","vav","vay","vbb","vbk","vec","ved","vel","vem","veo","vep","ver","vgr","vgt","vic","vid","vif","vig","vil","vin","vis","vit","viv","vka","vki","vkj","vkk","vkl","vkm","vko","vkp","vkt","vku","vlp","vls","vma","vmb","vmc","vmd","vme","vmf","vmg","vmh","vmi","vmj","vmk","vml","vmm","vmp","vmq","vmr","vms","vmu","vmv","vmw","vmx","vmy","vmz","vnk","vnm","vnp","vor","vot","vra","vro","vrs","vrt","vsi","vsl","vsv","vto","vum","vun","vut","vwa","waa","wab","wac","wad","wae","waf","wag","wah","wai","waj","wak","wal","wam","wan","wao","wap","waq","war","was","wat","wau","wav","waw","wax","way","waz","wba","wbb","wbe","wbf","wbh","wbi","wbj","wbk","wbl","wbm","wbp","wbq","wbr","wbs","wbt","wbv","wbw","wca","wci","wdd","wdg","wdj","wdk","wdu","wdy","wea","wec","wed","weg","weh","wei","wem","wen","weo","wep","wer","wes","wet","weu","wew","wfg","wga","wgb","wgg","wgi","wgo","wgu","wgw","wgy","wha","whg","whk","whu","wib","wic","wie","wif","wig","wih","wii","wij","wik","wil","wim","win","wir","wit","wiu","wiv","wiw","wiy","wja","wji","wka","wkb","wkd","wkl","wku","wkw","wky","wla","wlc","wle","wlg","wli","wlk","wll","wlm","wlo","wlr","wls","wlu","wlv","wlw","wlx","wly","wma","wmb","wmc","wmd","wme","wmh","wmi","wmm","wmn","wmo","wms","wmt","wmw","wmx","wnb","wnc","wnd","wne","wng","wni","wnk","wnm","wnn","wno","wnp","wnu","wnw","wny","woa","wob","woc","wod","woe","wof","wog","woi","wok","wom","won","woo","wor","wos","wow","woy","wpc","wra","wrb","wrd","wrg","wrh","wri","wrk","wrl","wrm","wrn","wro","wrp","wrr","wrs","wru","wrv","wrw","wrx","wry","wrz","wsa","wsg","wsi","wsk","wsr","wss","wsu","wsv","wtf","wth","wti","wtk","wtm","wtw","wua","wub","wud","wuh","wul","wum","wun","wur","wut","wuu","wuv","wux","wuy","wwa","wwb","wwo","wwr","www","wxa","wxw","wya","wyb","wyi","wym","wyr","wyy","xaa","xab","xac","xad","xae","xag","xai","xaj","xak","xal","xam","xan","xao","xap","xaq","xar","xas","xat","xau","xav","xaw","xay","xba","xbb","xbc","xbd","xbe","xbg","xbi","xbj","xbm","xbn","xbo","xbp","xbr","xbw","xbx","xby","xcb","xcc","xce","xcg","xch","xcl","xcm","xcn","xco","xcr","xct","xcu","xcv","xcw","xcy","xda","xdc","xdk","xdm","xdo","xdy","xeb","xed","xeg","xel","xem","xep","xer","xes","xet","xeu","xfa","xga","xgb","xgd","xgf","xgg","xgi","xgl","xgm","xgn","xgr","xgu","xgw","xha","xhc","xhd","xhe","xhr","xht","xhu","xhv","xia","xib","xii","xil","xin","xip","xir","xis","xiv","xiy","xjb","xjt","xka","xkb","xkc","xkd","xke","xkf","xkg","xkh","xki","xkj","xkk","xkl","xkn","xko","xkp","xkq","xkr","xks","xkt","xku","xkv","xkw","xkx","xky","xkz","xla","xlb","xlc","xld","xle","xlg","xli","xln","xlo","xlp","xls","xlu","xly","xma","xmb","xmc","xmd","xme","xmf","xmg","xmh","xmj","xmk","xml","xmm","xmn","xmo","xmp","xmq","xmr","xms","xmt","xmu","xmv","xmw","xmx","xmy","xmz","xna","xnb","xnd","xng","xnh","xni","xnk","xnn","xno","xnr","xns","xnt","xnu","xny","xnz","xoc","xod","xog","xoi","xok","xom","xon","xoo","xop","xor","xow","xpa","xpc","xpe","xpg","xpi","xpj","xpk","xpm","xpn","xpo","xpp","xpq","xpr","xps","xpt","xpu","xpy","xqa","xqt","xra","xrb","xrd","xre","xrg","xri","xrm","xrn","xrq","xrr","xrt","xru","xrw","xsa","xsb","xsc","xsd","xse","xsh","xsi","xsj","xsl","xsm","xsn","xso","xsp","xsq","xsr","xss","xsu","xsv","xsy","xta","xtb","xtc","xtd","xte","xtg","xth","xti","xtj","xtl","xtm","xtn","xto","xtp","xtq","xtr","xts","xtt","xtu","xtv","xtw","xty","xtz","xua","xub","xud","xug","xuj","xul","xum","xun","xuo","xup","xur","xut","xuu","xve","xvi","xvn","xvo","xvs","xwa","xwc","xwd","xwe","xwg","xwj","xwk","xwl","xwo","xwr","xwt","xww","xxb","xxk","xxm","xxr","xxt","xya","xyb","xyj","xyk","xyl","xyt","xyy","xzh","xzm","xzp","yaa","yab","yac","yad","yae","yaf","yag","yah","yai","yaj","yak","yal","yam","yan","yao","yap","yaq","yar","yas","yat","yau","yav","yaw","yax","yay","yaz","yba","ybb","ybd","ybe","ybh","ybi","ybj","ybk","ybl","ybm","ybn","ybo","ybx","yby","ych","ycl","ycn","ycp","yda","ydd","yde","ydg","ydk","yds","yea","yec","yee","yei","yej","yel","yen","yer","yes","yet","yeu","yev","yey","yga","ygi","ygl","ygm","ygp","ygr","ygs","ygu","ygw","yha","yhd","yhl","yhs","yia","yif","yig","yih","yii","yij","yik","yil","yim","yin","yip","yiq","yir","yis","yit","yiu","yiv","yix","yiy","yiz","yka","ykg","yki","ykk","ykl","ykm","ykn","yko","ykr","ykt","yku","yky","yla","ylb","yle","ylg","yli","yll","ylm","yln","ylo","ylr","ylu","yly","yma","ymb","ymc","ymd","yme","ymg","ymh","ymi","ymk","yml","ymm","ymn","ymo","ymp","ymq","ymr","yms","ymt","ymx","ymz","yna","ynd","yne","yng","ynh","ynk","ynl","ynn","yno","ynq","yns","ynu","yob","yog","yoi","yok","yol","yom","yon","yos","yot","yox","yoy","ypa","ypb","ypg","yph","ypk","ypm","ypn","ypo","ypp","ypz","yra","yrb","yre","yri","yrk","yrl","yrm","yrn","yro","yrs","yrw","yry","ysc","ysd","ysg","ysl","ysn","yso","ysp","ysr","yss","ysy","yta","ytl","ytp","ytw","yty","yua","yub","yuc","yud","yue","yuf","yug","yui","yuj","yuk","yul","yum","yun","yup","yuq","yur","yut","yuu","yuw","yux","yuy","yuz","yva","yvt","ywa","ywg","ywl","ywn","ywq","ywr","ywt","ywu","yww","yxa","yxg","yxl","yxm","yxu","yxy","yyr","yyu","yyz","yzg","yzk","zaa","zab","zac","zad","zae","zaf","zag","zah","zai","zaj","zak","zal","zam","zao","zap","zaq","zar","zas","zat","zau","zav","zaw","zax","zay","zaz","zbc","zbe","zbl","zbt","zbw","zca","zch","zdj","zea","zeg","zeh","zen","zga","zgb","zgh","zgm","zgn","zgr","zhb","zhd","zhi","zhn","zhw","zhx","zia","zib","zik","zil","zim","zin","zir","ziw","ziz","zka","zkb","zkd","zkg","zkh","zkk","zkn","zko","zkp","zkr","zkt","zku","zkv","zkz","zle","zlj","zlm","zln","zlq","zls","zlw","zma","zmb","zmc","zmd","zme","zmf","zmg","zmh","zmi","zmj","zmk","zml","zmm","zmn","zmo","zmp","zmq","zmr","zms","zmt","zmu","zmv","zmw","zmx","zmy","zmz","zna","znd","zne","zng","znk","zns","zoc","zoh","zom","zoo","zoq","zor","zos","zpa","zpb","zpc","zpd","zpe","zpf","zpg","zph","zpi","zpj","zpk","zpl","zpm","zpn","zpo","zpp","zpq","zpr","zps","zpt","zpu","zpv","zpw","zpx","zpy","zpz","zqe","zra","zrg","zrn","zro","zrp","zrs","zsa","zsk","zsl","zsm","zsr","zsu","zte","ztg","ztl","ztm","ztn","ztp","ztq","zts","ztt","ztu","ztx","zty","zua","zuh","zum","zun","zuy","zwa","zxx","zyb","zyg","zyj","zyn","zyp","zza","zzj"];function l(){return(l=Object.assign||function(e){for(var t=1;t<arguments.length;t++){var r=arguments[t];for(var n in r)Object.prototype.hasOwnProperty.call(r,n)&&(e[n]=r[n])}return e}).apply(this,arguments)}function _e(e){return function(e){if(Array.isArray(e)){for(var t=0,r=new Array(e.length);t<e.length;t++)r[t]=e[t];return r}}(e)||function(e){if(Symbol.iterator in Object(e)||"[object Arguments]"===Object.prototype.toString.call(e))return Array.from(e)}(e)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance")}()}function B(e,t){return U(e)||V(e,t)||M()}function M(){throw new TypeError("Invalid attempt to destructure non-iterable instance")}function V(e,t){if(Symbol.iterator in Object(e)||"[object Arguments]"===Object.prototype.toString.call(e)){var r=[],n=!0,a=!1,o=void 0;try{for(var i,s=e[Symbol.iterator]();!(n=(i=s.next()).done)&&(r.push(i.value),!t||r.length!==t);n=!0);}catch(e){a=!0,o=e}finally{try{n||null==s.return||s.return()}finally{if(a)throw o}}return r}}function U(e){if(Array.isArray(e))return e}function a(e){return(a="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}re.utils.validLangs=function(){"use strict";return Ke},re._load({lang:"en",data:{rules:{accesskeys:{description:"Ensures every accesskey attribute value is unique",help:"accesskey attribute value must be unique"},"area-alt":{description:"Ensures <area> elements of image maps have alternate text",help:"Active <area> elements must have alternate text"},"aria-allowed-attr":{description:"Ensures ARIA attributes are allowed for an element\'s role",help:"Elements must only use allowed ARIA attributes"},"aria-allowed-role":{description:"Ensures role attribute has an appropriate value for the element",help:"ARIA role must be appropriate for the element"},"aria-dpub-role-fallback":{description:"Ensures unsupported DPUB roles are only used on elements with implicit fallback roles",help:"Unsupported DPUB ARIA roles should be used on elements with implicit fallback roles"},"aria-hidden-body":{description:"Ensures aria-hidden=\'true\' is not present on the document body.",help:"aria-hidden=\'true\' must not be present on the document body"},"aria-hidden-focus":{description:"Ensures aria-hidden elements do not contain focusable elements",help:"ARIA hidden element must not contain focusable elements"},"aria-input-field-name":{description:"Ensures every ARIA input field has an accessible name",help:"ARIA input fields must have an accessible name"},"aria-required-attr":{description:"Ensures elements with ARIA roles have all required ARIA attributes",help:"Required ARIA attributes must be provided"},"aria-required-children":{description:"Ensures elements with an ARIA role that require child roles contain them",help:"Certain ARIA roles must contain particular children"},"aria-required-parent":{description:"Ensures elements with an ARIA role that require parent roles are contained by them",help:"Certain ARIA roles must be contained by particular parents"},"aria-roledescription":{description:"Ensure aria-roledescription is only used on elements with an implicit or explicit role",help:"Use aria-roledescription on elements with a semantic role"},"aria-roles":{description:"Ensures all elements with a role attribute use a valid value",help:"ARIA roles used must conform to valid values"},"aria-toggle-field-name":{description:"Ensures every ARIA toggle field has an accessible name",help:"ARIA toggle fields have an accessible name"},"aria-valid-attr-value":{description:"Ensures all ARIA attributes have valid values",help:"ARIA attributes must conform to valid values"},"aria-valid-attr":{description:"Ensures attributes that begin with aria- are valid ARIA attributes",help:"ARIA attributes must conform to valid names"},"audio-caption":{description:"Ensures <audio> elements have captions",help:"<audio> elements must have a captions track"},"autocomplete-valid":{description:"Ensure the autocomplete attribute is correct and suitable for the form field",help:"autocomplete attribute must be used correctly"},"avoid-inline-spacing":{description:"Ensure that text spacing set through style attributes can be adjusted with custom stylesheets",help:"Inline text spacing must be adjustable with custom stylesheets"},blink:{description:"Ensures <blink> elements are not used",help:"<blink> elements are deprecated and must not be used"},"button-name":{description:"Ensures buttons have discernible text",help:"Buttons must have discernible text"},bypass:{description:"Ensures each page has at least one mechanism for a user to bypass navigation and jump straight to the content",help:"Page must have means to bypass repeated blocks"},checkboxgroup:{description:\'Ensures related <input type="checkbox"> elements have a group and that the group designation is consistent\',help:"Checkbox inputs with the same name attribute value must be part of a group"},"color-contrast":{description:"Ensures the contrast between foreground and background colors meets WCAG 2 AA contrast ratio thresholds",help:"Elements must have sufficient color contrast"},"css-orientation-lock":{description:"Ensures content is not locked to any specific display orientation, and the content is operable in all display orientations",help:"CSS Media queries are not used to lock display orientation"},"definition-list":{description:"Ensures <dl> elements are structured correctly",help:"<dl> elements must only directly contain properly-ordered <dt> and <dd> groups, <script>, <template> or <div> elements"},dlitem:{description:"Ensures <dt> and <dd> elements are contained by a <dl>",help:"<dt> and <dd> elements must be contained by a <dl>"},"document-title":{description:"Ensures each HTML document contains a non-empty <title> element",help:"Documents must have <title> element to aid in navigation"},"duplicate-id-active":{description:"Ensures every id attribute value of active elements is unique",help:"IDs of active elements must be unique"},"duplicate-id-aria":{description:"Ensures every id attribute value used in ARIA and in labels is unique",help:"IDs used in ARIA and labels must be unique"},"duplicate-id":{description:"Ensures every id attribute value is unique",help:"id attribute value must be unique"},"empty-heading":{description:"Ensures headings have discernible text",help:"Headings must not be empty"},"focus-order-semantics":{description:"Ensures elements in the focus order have an appropriate role",help:"Elements in the focus order need a role appropriate for interactive content"},"form-field-multiple-labels":{description:"Ensures form field does not have multiple label elements",help:"Form field should not have multiple label elements"},"frame-tested":{description:"Ensures <iframe> and <frame> elements contain the axe-core script",help:"Frames must be tested with axe-core"},"frame-title-unique":{description:"Ensures <iframe> and <frame> elements contain a unique title attribute",help:"Frames must have a unique title attribute"},"frame-title":{description:"Ensures <iframe> and <frame> elements contain a non-empty title attribute",help:"Frames must have title attribute"},"heading-order":{description:"Ensures the order of headings is semantically correct",help:"Heading levels should only increase by one"},"hidden-content":{description:"Informs users about hidden content.",help:"Hidden content on the page cannot be analyzed"},"html-has-lang":{description:"Ensures every HTML document has a lang attribute",help:"<html> element must have a lang attribute"},"html-lang-valid":{description:"Ensures the lang attribute of the <html> element has a valid value",help:"<html> element must have a valid value for the lang attribute"},"html-xml-lang-mismatch":{description:"Ensure that HTML elements with both valid lang and xml:lang attributes agree on the base language of the page",help:"HTML elements with lang and xml:lang must have the same base language"},"identical-links-same-purpose":{description:"Ensure that links with the same accessible name serve a similar purpose",help:"Links with the same name have a similar purpose"},"image-alt":{description:"Ensures <img> elements have alternate text or a role of none or presentation",help:"Images must have alternate text"},"image-redundant-alt":{description:"Ensure image alternative is not repeated as text",help:"Alternative text of images should not be repeated as text"},"input-button-name":{description:"Ensures input buttons have discernible text",help:"Input buttons must have discernible text"},"input-image-alt":{description:\'Ensures <input type="image"> elements have alternate text\',help:"Image buttons must have alternate text"},"label-content-name-mismatch":{description:"Ensures that elements labelled through their content must have their visible text as part of their accessible name",help:"Elements must have their visible text as part of their accessible name"},"label-title-only":{description:"Ensures that every form element is not solely labeled using the title or aria-describedby attributes",help:"Form elements should have a visible label"},label:{description:"Ensures every form element has a label",help:"Form elements must have labels"},"landmark-banner-is-top-level":{description:"Ensures the banner landmark is at top level",help:"Banner landmark must not be contained in another landmark"},"landmark-complementary-is-top-level":{description:"Ensures the complementary landmark or aside is at top level",help:"Aside must not be contained in another landmark"},"landmark-contentinfo-is-top-level":{description:"Ensures the contentinfo landmark is at top level",help:"Contentinfo landmark must not be contained in another landmark"},"landmark-main-is-top-level":{description:"Ensures the main landmark is at top level",help:"Main landmark must not be contained in another landmark"},"landmark-no-duplicate-banner":{description:"Ensures the document has at most one banner landmark",help:"Document must not have more than one banner landmark"},"landmark-no-duplicate-contentinfo":{description:"Ensures the document has at most one contentinfo landmark",help:"Document must not have more than one contentinfo landmark"},"landmark-no-duplicate-main":{description:"Ensures the document has at most one main landmark",help:"Document must not have more than one main landmark"},"landmark-one-main":{description:"Ensures the document has a main landmark",help:"Document must have one main landmark"},"landmark-unique":{help:"Ensures landmarks are unique",description:"Landmarks must have a unique role or role/label/title (i.e. accessible name) combination"},"layout-table":{description:"Ensures presentational <table> elements do not use <th>, <caption> elements or the summary attribute",help:"Layout tables must not use data table elements"},"link-in-text-block":{description:"Links can be distinguished without relying on color",help:"Links must be distinguished from surrounding text in a way that does not rely on color"},"link-name":{description:"Ensures links have discernible text",help:"Links must have discernible text"},list:{description:"Ensures that lists are structured correctly",help:"<ul> and <ol> must only directly contain <li>, <script> or <template> elements"},listitem:{description:"Ensures <li> elements are used semantically",help:"<li> elements must be contained in a <ul> or <ol>"},marquee:{description:"Ensures <marquee> elements are not used",help:"<marquee> elements are deprecated and must not be used"},"meta-refresh":{description:\'Ensures <meta http-equiv="refresh"> is not used\',help:"Timed refresh must not exist"},"meta-viewport-large":{description:\'Ensures <meta name="viewport"> can scale a significant amount\',help:"Users should be able to zoom and scale the text up to 500%"},"meta-viewport":{description:\'Ensures <meta name="viewport"> does not disable text scaling and zooming\',help:"Zooming and scaling must not be disabled"},"no-autoplay-audio":{description:"Ensures <video> or <audio> elements do not autoplay audio for more than 3 seconds without a control mechanism to stop or mute the audio",help:"<video> or <audio> elements do not autoplay audio"},"object-alt":{description:"Ensures <object> elements have alternate text",help:"<object> elements must have alternate text"},"p-as-heading":{description:"Ensure p elements are not used to style headings",help:"Bold, italic text and font-size are not used to style p elements as a heading"},"page-has-heading-one":{description:"Ensure that the page, or at least one of its frames contains a level-one heading",help:"Page must contain a level-one heading"},radiogroup:{description:\'Ensures related <input type="radio"> elements have a group and that the group designation is consistent\',help:"Radio inputs with the same name attribute value must be part of a group"},region:{description:"Ensures all page content is contained by landmarks",help:"All page content must be contained by landmarks"},"role-img-alt":{description:"Ensures [role=\'img\'] elements have alternate text",help:"[role=\'img\'] elements have an alternative text"},"scope-attr-valid":{description:"Ensures the scope attribute is used correctly on tables",help:"scope attribute should be used correctly"},"scrollable-region-focusable":{description:"Elements that have scrollable content should be accessible by keyboard",help:"Ensure that scrollable region has keyboard access"},"server-side-image-map":{description:"Ensures that server-side image maps are not used",help:"Server-side image maps must not be used"},"skip-link":{description:"Ensure all skip links have a focusable target",help:"The skip-link target should exist and be focusable"},"svg-img-alt":{description:"Ensures svg elements with an img, graphics-document or graphics-symbol role have an accessible text",help:"svg elements with an img role have an alternative text"},tabindex:{description:"Ensures tabindex attribute values are not greater than 0",help:"Elements should not have tabindex greater than zero"},"table-duplicate-name":{description:"Ensure that tables do not have the same summary and caption",help:"The <caption> element should not contain the same text as the summary attribute"},"table-fake-caption":{description:"Ensure that tables with a caption use the <caption> element.",help:"Data or header cells should not be used to give caption to a data table."},"td-has-header":{description:"Ensure that each non-empty data cell in a large table has one or more table headers",help:"All non-empty td element in table larger than 3 by 3 must have an associated table header"},"td-headers-attr":{description:"Ensure that each cell in a table using the headers refers to another cell in that table",help:"All cells in a table element that use the headers attribute must only refer to other cells of that same table"},"th-has-data-cells":{description:"Ensure that each table header in a data table refers to data cells",help:"All th elements and elements with role=columnheader/rowheader must have data cells they describe"},"valid-lang":{description:"Ensures lang attributes have valid values",help:"lang attribute must have a valid value"},"video-caption":{description:"Ensures <video> elements have captions",help:"<video> elements must have captions"},"video-description":{description:"Ensures <video> elements have audio descriptions",help:"<video> elements must have an audio description track"}},checks:{accesskeys:{impact:"serious",messages:{pass:"Accesskey attribute value is unique",fail:"Document has multiple elements with the same accesskey"}},"non-empty-alt":{impact:"critical",messages:{pass:"Element has a non-empty alt attribute",fail:"Element has no alt attribute or the alt attribute is empty"}},"non-empty-title":{impact:"serious",messages:{pass:"Element has a title attribute",fail:"Element has no title attribute or the title attribute is empty"}},"aria-label":{impact:"serious",messages:{pass:"aria-label attribute exists and is not empty",fail:"aria-label attribute does not exist or is empty"}},"aria-labelledby":{impact:"serious",messages:{pass:"aria-labelledby attribute exists and references elements that are visible to screen readers",fail:"aria-labelledby attribute does not exist, references elements that do not exist or references elements that are empty"}},"aria-allowed-attr":{impact:"critical",messages:{pass:"ARIA attributes are used correctly for the defined role",fail:{singular:"ARIA attribute is not allowed: ${data.values}",plural:"ARIA attributes are not allowed: ${data.values}"}}},"aria-unsupported-attr":{impact:"critical",messages:{pass:"ARIA attribute is supported",fail:"ARIA attribute is not widely supported in screen readers and assistive technologies: ${data.values}"}},"aria-allowed-role":{impact:"minor",messages:{pass:"ARIA role is allowed for given element",fail:{singular:"ARIA role ${data.values} is not allowed for given element",plural:"ARIA roles ${data.values} are not allowed for given element"},incomplete:{singular:"ARIA role ${data.values} must be removed when the element is made visible, as it is not allowed for the element",plural:"ARIA roles ${data.values} must be removed when the element is made visible, as they are not allowed for the element"}}},"implicit-role-fallback":{impact:"moderate",messages:{pass:"Element’s implicit ARIA role is an appropriate fallback",fail:"Element’s implicit ARIA role is not a good fallback for the (unsupported) role"}},"aria-hidden-body":{impact:"critical",messages:{pass:"No aria-hidden attribute is present on document body",fail:"aria-hidden=true should not be present on the document body"}},"focusable-modal-open":{impact:"serious",messages:{pass:"No focusable elements while a modal is open",incomplete:"Check that focusable elements are not tabbable in the current state"}},"focusable-disabled":{impact:"serious",messages:{pass:"No focusable elements contained within element",fail:"Focusable content should be disabled or be removed from the DOM"}},"focusable-not-tabbable":{impact:"serious",messages:{pass:"No focusable elements contained within element",fail:"Focusable content should have tabindex=\'-1\' or be removed from the DOM"}},"no-implicit-explicit-label":{impact:"moderate",messages:{pass:"There is no mismatch between a <label> and accessible name",incomplete:"Check that the <label> does not need be part of the ARIA ${data} field\'s name"}},"aria-required-attr":{impact:"critical",messages:{pass:"All required ARIA attributes are present",fail:{singular:"Required ARIA attribute not present: ${data.values}",plural:"Required ARIA attributes not present: ${data.values}"}}},"aria-required-children":{impact:"critical",messages:{pass:"Required ARIA children are present",fail:{singular:"Required ARIA child role not present: ${data.values}",plural:"Required ARIA children role not present: ${data.values}"},incomplete:{singular:"Expecting ARIA child role to be added: ${data.values}",plural:"Expecting ARIA children role to be added: ${data.values}"}}},"aria-required-parent":{impact:"critical",messages:{pass:"Required ARIA parent role present",fail:{singular:"Required ARIA parent role not present: ${data.values}",plural:"Required ARIA parents role not present: ${data.values}"}}},"aria-roledescription":{impact:"serious",messages:{pass:"aria-roledescription used on a supported semantic role",incomplete:"Check that the aria-roledescription is announced by supported screen readers",fail:"Give the element a role that supports aria-roledescription"}},fallbackrole:{impact:"serious",messages:{pass:"Only one role value used",fail:"Use only one role value, since fallback roles are not supported in older browsers"}},invalidrole:{impact:"critical",messages:{pass:"ARIA role is valid",fail:{singular:"Role must be one of the valid ARIA roles: ${data.values}",plural:"Roles must be one of the valid ARIA roles: ${data.values}"}}},abstractrole:{impact:"serious",messages:{pass:"Abstract roles are not used",fail:{singular:"Abstract role cannot be directly used: ${data.values}",plural:"Abstract roles cannot be directly used: ${data.values}"}}},unsupportedrole:{impact:"critical",messages:{pass:"ARIA role is supported",fail:"The role used is not widely supported in screen readers and assistive technologies: ${data.values}"}},"has-visible-text":{impact:"minor",messages:{pass:"Element has text that is visible to screen readers",fail:"Element does not have text that is visible to screen readers"}},"aria-valid-attr-value":{impact:"critical",messages:{pass:"ARIA attribute values are valid",fail:{singular:"Invalid ARIA attribute value: ${data.values}",plural:"Invalid ARIA attribute values: ${data.values}"},incomplete:{noId:"ARIA attribute element ID does not exist on the page: ${data.needsReview}",ariaCurrent:\'ARIA attribute value is invalid and will be treated as "aria-current=true": ${data.needsReview}\'}}},"aria-errormessage":{impact:"critical",messages:{pass:"Uses a supported aria-errormessage technique",fail:{singular:"aria-errormessage value `${data.values}` must use a technique to announce the message (e.g., aria-live, aria-describedby, role=alert, etc.)",plural:"aria-errormessage values `${data.values}` must use a technique to announce the message (e.g., aria-live, aria-describedby, role=alert, etc.)"}}},"aria-valid-attr":{impact:"critical",messages:{pass:"ARIA attribute name is valid",fail:{singular:"Invalid ARIA attribute name: ${data.values}",plural:"Invalid ARIA attribute names: ${data.values}"}}},caption:{impact:"critical",messages:{pass:"The multimedia element has a captions track",incomplete:"Check that captions is available for the element"}},"autocomplete-valid":{impact:"serious",messages:{pass:"the autocomplete attribute is correctly formatted",fail:"the autocomplete attribute is incorrectly formatted"}},"autocomplete-appropriate":{impact:"serious",messages:{pass:"the autocomplete value is on an appropriate element",fail:"the autocomplete value is inappropriate for this type of input"}},"avoid-inline-spacing":{impact:"serious",messages:{pass:"No inline styles with \'!important\' that affect text spacing has been specified",fail:{singular:"Remove \'!important\' from inline style ${data.values}, as overriding this is not supported by most browsers",plural:"Remove \'!important\' from inline styles ${data.values}, as overriding this is not supported by most browsers"}}},"is-on-screen":{impact:"serious",messages:{pass:"Element is not visible",fail:"Element is visible"}},"button-has-visible-text":{impact:"critical",messages:{pass:"Element has inner text that is visible to screen readers",fail:"Element does not have inner text that is visible to screen readers"}},"role-presentation":{impact:"minor",messages:{pass:\'Element\\\'s default semantics were overriden with role="presentation"\',fail:\'Element\\\'s default semantics were not overridden with role="presentation"\'}},"role-none":{impact:"minor",messages:{pass:\'Element\\\'s default semantics were overriden with role="none"\',fail:\'Element\\\'s default semantics were not overridden with role="none"\'}},"internal-link-present":{impact:"serious",messages:{pass:"Valid skip link found",fail:"No valid skip link found"}},"header-present":{impact:"serious",messages:{pass:"Page has a heading",fail:"Page does not have a heading"}},landmark:{impact:"serious",messages:{pass:"Page has a landmark region",fail:"Page does not have a landmark region"}},"group-labelledby":{impact:"critical",messages:{pass:\'Elements with the name "${data.name}" have both a shared label, and a unique label, referenced through aria-labelledby\',fail:{default:\'Elements with the name "${data.name}" do not all have both a shared label, and a unique label referenced through aria-labelledby\',"no-shared-label":\'Elements with the name "${data.name}" do not all have a shared label referenced through aria-labelledby\',"no-unique-label":\'Elements with the name "${data.name}" do not all have a unique label referenced through aria-labelledby\'}}},fieldset:{impact:"critical",messages:{pass:"Element is contained in a fieldset",fail:{default:"Element does not have a containing fieldset or ARIA group","no-legend":"Fieldset does not have a legend as its first child","empty-legend":"Legend does not have text that is visible to screen readers","mixed-inputs":"Fieldset contains unrelated inputs","no-group-label":"ARIA group does not have aria-label or aria-labelledby","group-mixed-inputs":"ARIA group contains unrelated inputs"}}},"color-contrast":{impact:"serious",messages:{pass:"Element has sufficient color contrast of ${data.contrastRatio}",fail:"Element has insufficient color contrast of ${data.contrastRatio} (foreground color: ${data.fgColor}, background color: ${data.bgColor}, font size: ${data.fontSize}, font weight: ${data.fontWeight}). Expected contrast ratio of ${data.expectedContrastRatio}",incomplete:{default:"Unable to determine contrast ratio",bgImage:"Element\'s background color could not be determined due to a background image",bgGradient:"Element\'s background color could not be determined due to a background gradient",imgNode:"Element\'s background color could not be determined because element contains an image node",bgOverlap:"Element\'s background color could not be determined because it is overlapped by another element",fgAlpha:"Element\'s foreground color could not be determined because of alpha transparency",elmPartiallyObscured:"Element\'s background color could not be determined because it\'s partially obscured by another element",elmPartiallyObscuring:"Element\'s background color could not be determined because it partially overlaps other elements",outsideViewport:"Element\'s background color could not be determined because it\'s outside the viewport",equalRatio:"Element has a 1:1 contrast ratio with the background",shortTextContent:"Element content is too short to determine if it is actual text content",nonBmp:"Element content contains only non-text characters"}}},"css-orientation-lock":{impact:"serious",messages:{pass:"Display is operable, and orientation lock does not exist",fail:"CSS Orientation lock is applied, and makes display inoperable",incomplete:"CSS Orientation lock cannot be determined"}},"structured-dlitems":{impact:"serious",messages:{pass:"When not empty, element has both <dt> and <dd> elements",fail:"When not empty, element does not have at least one <dt> element followed by at least one <dd> element"}},"only-dlitems":{impact:"serious",messages:{pass:"List element only has direct children that are allowed inside <dt> or <dd> elements",fail:"List element has direct children that are not allowed inside <dt> or <dd> elements"}},dlitem:{impact:"serious",messages:{pass:"Description list item has a <dl> parent element",fail:"Description list item does not have a <dl> parent element"}},"doc-has-title":{impact:"serious",messages:{pass:"Document has a non-empty <title> element",fail:"Document does not have a non-empty <title> element"}},"duplicate-id-active":{impact:"serious",messages:{pass:"Document has no active elements that share the same id attribute",fail:"Document has active elements with the same id attribute: ${data}"}},"duplicate-id-aria":{impact:"critical",messages:{pass:"Document has no elements referenced with ARIA or labels that share the same id attribute",fail:"Document has multiple elements referenced with ARIA with the same id attribute: ${data}"}},"duplicate-id":{impact:"minor",messages:{pass:"Document has no static elements that share the same id attribute",fail:"Document has multiple static elements with the same id attribute"}},"has-widget-role":{impact:"minor",messages:{pass:"Element has a widget role.",fail:"Element does not have a widget role."}},"valid-scrollable-semantics":{impact:"minor",messages:{pass:"Element has valid semantics for an element in the focus order.",fail:"Element has invalid semantics for an element in the focus order."}},"multiple-label":{impact:"moderate",messages:{pass:"Form field does not have multiple label elements",incomplete:"Multiple label elements is not widely supported in assistive technologies. Ensure the first label contains all necessary information."}},"frame-tested":{impact:"critical",messages:{pass:"The iframe was tested with axe-core",fail:"The iframe could not be tested with axe-core",incomplete:"The iframe still has to be tested with axe-core"}},"unique-frame-title":{impact:"serious",messages:{pass:"Element\'s title attribute is unique",fail:"Element\'s title attribute is not unique"}},"heading-order":{impact:"moderate",messages:{pass:"Heading order valid",fail:"Heading order invalid"}},"hidden-content":{impact:"minor",messages:{pass:"All content on the page has been analyzed.",fail:"There were problems analyzing the content on this page.",incomplete:"There is hidden content on the page that was not analyzed. You will need to trigger the display of this content in order to analyze it."}},"has-lang":{impact:"serious",messages:{pass:"The <html> element has a lang attribute",fail:{noXHTML:"The xml:lang attribute is not valid on HTML pages, use the lang attribute.",noLang:"The <html> element does not have a lang attribute"}}},"valid-lang":{impact:"serious",messages:{pass:"Value of lang attribute is included in the list of valid languages",fail:"Value of lang attribute not included in the list of valid languages"}},"xml-lang-mismatch":{impact:"moderate",messages:{pass:"Lang and xml:lang attributes have the same base language",fail:"Lang and xml:lang attributes do not have the same base language"}},"identical-links-same-purpose":{impact:"minor",messages:{pass:"There are no other links with the same name, that go to a different URL",incomplete:"Check that links have the same purpose, or are intentionally ambiguous."}},"has-alt":{impact:"critical",messages:{pass:"Element has an alt attribute",fail:"Element does not have an alt attribute"}},"alt-space-value":{impact:"critical",messages:{pass:"Element has a valid alt attribute value",fail:"Element has an alt attribute containing only a space character, which is not ignored by all screen readers"}},"duplicate-img-label":{impact:"minor",messages:{pass:"Element does not duplicate existing text in <img> alt text",fail:"Element contains <img> element with alt text that duplicates existing text"}},"non-empty-if-present":{impact:"critical",messages:{pass:{default:"Element does not have a value attribute","has-label":"Element has a non-empty value attribute"},fail:"Element has a value attribute and the value attribute is empty"}},"non-empty-value":{impact:"critical",messages:{pass:"Element has a non-empty value attribute",fail:"Element has no value attribute or the value attribute is empty"}},"label-content-name-mismatch":{impact:"serious",messages:{pass:"Element contains visible text as part of it\'s accessible name",fail:"Text inside the element is not included in the accessible name"}},"title-only":{impact:"serious",messages:{pass:"Form element does not solely use title attribute for its label",fail:"Only title used to generate label for form element"}},"implicit-label":{impact:"critical",messages:{pass:"Form element has an implicit (wrapped) <label>",fail:"Form element does not have an implicit (wrapped) <label>"}},"explicit-label":{impact:"critical",messages:{pass:"Form element has an explicit <label>",fail:"Form element does not have an explicit <label>"}},"help-same-as-label":{impact:"minor",messages:{pass:"Help text (title or aria-describedby) does not duplicate label text",fail:"Help text (title or aria-describedby) text is the same as the label text"}},"hidden-explicit-label":{impact:"critical",messages:{pass:"Form element has a visible explicit <label>",fail:"Form element has explicit <label> that is hidden"}},"landmark-is-top-level":{impact:"moderate",messages:{pass:"The ${data.role} landmark is at the top level.",fail:"The ${data.role} landmark is contained in another landmark."}},"page-no-duplicate-banner":{impact:"moderate",messages:{pass:"Document does not have more than one banner landmark",fail:"Document has more than one banner landmark"}},"page-no-duplicate-contentinfo":{impact:"moderate",messages:{pass:"Document does not have more than one contentinfo landmark",fail:"Document has more than one contentinfo landmark"}},"page-no-duplicate-main":{impact:"moderate",messages:{pass:"Document does not have more than one main landmark",fail:"Document has more than one main landmark"}},"page-has-main":{impact:"moderate",messages:{pass:"Document has at least one main landmark",fail:"Document does not have a main landmark"}},"landmark-is-unique":{impact:"moderate",messages:{pass:"Landmarks must have a unique role or role/label/title (i.e. accessible name) combination",fail:"The landmark must have a unique aria-label, aria-labelledby, or title to make landmarks distinguishable"}},"has-th":{impact:"serious",messages:{pass:"Layout table does not use <th> elements",fail:"Layout table uses <th> elements"}},"has-caption":{impact:"serious",messages:{pass:"Layout table does not use <caption> element",fail:"Layout table uses <caption> element"}},"has-summary":{impact:"serious",messages:{pass:"Layout table does not use summary attribute",fail:"Layout table uses summary attribute"}},"link-in-text-block":{impact:"serious",messages:{pass:"Links can be distinguished from surrounding text in some way other than by color",fail:"Links need to be distinguished from surrounding text in some way other than by color",incomplete:{default:"Unable to determine contrast ratio",bgContrast:"Element\'s contrast ratio could not be determined. Check for a distinct hover/focus style",bgImage:"Element\'s contrast ratio could not be determined due to a background image",bgGradient:"Element\'s contrast ratio could not be determined due to a background gradient",imgNode:"Element\'s contrast ratio could not be determined because element contains an image node",bgOverlap:"Element\'s contrast ratio could not be determined because of element overlap"}}},"focusable-no-name":{impact:"serious",messages:{pass:"Element is not in tab order or has accessible text",fail:"Element is in tab order and does not have accessible text"}},"only-listitems":{impact:"serious",messages:{pass:"List element only has direct children that are allowed inside <li> elements",fail:{default:"List element has direct children that are not allowed inside <li> elements",roleNotValid:"List element has direct children with a role that is not allowed: ${data.roles}"}}},listitem:{impact:"serious",messages:{pass:\'List item has a <ul>, <ol> or role="list" parent element\',fail:{default:"List item does not have a <ul>, <ol> parent element",roleNotValid:\'List item does not have a <ul>, <ol> parent element without a role, or a role="list"\'}}},"meta-refresh":{impact:"critical",messages:{pass:"<meta> tag does not immediately refresh the page",fail:"<meta> tag forces timed refresh of page"}},"meta-viewport-large":{impact:"minor",messages:{pass:"<meta> tag does not prevent significant zooming on mobile devices",fail:"<meta> tag limits zooming on mobile devices"}},"meta-viewport":{impact:"critical",messages:{pass:"<meta> tag does not disable zooming on mobile devices",fail:"${data} on <meta> tag disables zooming on mobile devices"}},"no-autoplay-audio":{impact:"moderate",messages:{pass:"<video> or <audio> does not output audio for more than allowed duration or has controls mechanism",fail:"<video> or <audio> outputs audio for more than allowed duration and does not have a controls mechanism",incomplete:"Check that the <video> or <audio> does not output audio for more than allowed duration or provides a controls mechanism"}},"p-as-heading":{impact:"serious",messages:{pass:"<p> elements are not styled as headings",fail:"Heading elements should be used instead of styled p elements"}},"page-has-heading-one":{impact:"moderate",messages:{pass:"Page has at least one level-one heading",fail:"Page must have a level-one heading"}},region:{impact:"moderate",messages:{pass:"All page content is contained by landmarks",fail:"Some page content is not contained by landmarks"}},"html5-scope":{impact:"moderate",messages:{pass:"Scope attribute is only used on table header elements (<th>)",fail:"In HTML 5, scope attributes may only be used on table header elements (<th>)"}},"scope-value":{impact:"critical",messages:{pass:"Scope attribute is used correctly",fail:"The value of the scope attribute may only be \'row\' or \'col\'"}},"focusable-content":{impact:"moderate",messages:{pass:"Element contains focusable elements",fail:"Element should have focusable content"}},"focusable-element":{impact:"moderate",messages:{pass:"Element is focusable",fail:"Element should be focusable"}},exists:{impact:"minor",messages:{pass:"Element does not exist",incomplete:"Element exists"}},"skip-link":{impact:"moderate",messages:{pass:"Skip link target exists",incomplete:"Skip link target should become visible on activation",fail:"No skip link target"}},"svg-non-empty-title":{impact:"serious",messages:{pass:"element has a child that is a title",fail:"element has no child that is a title"}},tabindex:{impact:"serious",messages:{pass:"Element does not have a tabindex greater than 0",fail:"Element has a tabindex greater than 0"}},"same-caption-summary":{impact:"minor",messages:{pass:"Content of summary attribute and <caption> are not duplicated",fail:"Content of summary attribute and <caption> element are identical"}},"caption-faked":{impact:"serious",messages:{pass:"The first row of a table is not used as a caption",fail:"The first child of the table should be a caption instead of a table cell"}},"td-has-header":{impact:"critical",messages:{pass:"All non-empty data cells have table headers",fail:"Some non-empty data cells do not have table headers"}},"td-headers-attr":{impact:"serious",messages:{pass:"The headers attribute is exclusively used to refer to other cells in the table",incomplete:"The headers attribute is empty",fail:"The headers attribute is not exclusively used to refer to other cells in the table"}},"th-has-data-cells":{impact:"serious",messages:{pass:"All table header cells refer to data cells",fail:"Not all table header cells refer to data cells",incomplete:"Table data cells are missing or empty"}},description:{impact:"critical",messages:{pass:"The multimedia element has an audio description track",incomplete:"Check that audio description is available for the element"}}},failureSummaries:{any:{failureMessage:function(e){var t="Fix any of the following:",r=e;if(r)for(var n=-1,a=r.length-1;n<a;)t+="\\n  "+r[n+=1].split("\\n").join("\\n  ");return t}},none:{failureMessage:function(e){var t="Fix all of the following:",r=e;if(r)for(var n=-1,a=r.length-1;n<a;)t+="\\n  "+r[n+=1].split("\\n").join("\\n  ");return t}}},incompleteFallbackMessage:{}},rules:[{id:"accesskeys",selector:"[accesskey]",excludeHidden:!1,tags:["best-practice","cat.keyboard"],all:[],any:[],none:["accesskeys"]},{id:"area-alt",selector:"map area[href]",excludeHidden:!1,tags:["cat.text-alternatives","wcag2a","wcag111","wcag244","wcag412","section508","section508.22.a"],all:[],any:["non-empty-alt","non-empty-title","aria-label","aria-labelledby"],none:[]},{id:"aria-allowed-attr",matches:function(e){var t=/^aria-/;if(e.hasAttributes())for(var r=re.utils.getNodeAttributes(e),n=0,a=r.length;n<a;n++)if(t.test(r[n].name))return!0;return!1},tags:["cat.aria","wcag2a","wcag412"],all:[],any:["aria-allowed-attr"],none:["aria-unsupported-attr"]},{id:"aria-allowed-role",excludeHidden:!1,selector:"[role]",matches:function(e){return null!==re.commons.aria.getRole(e,{noImplicit:!0,dpub:!0,fallback:!0})},tags:["cat.aria","best-practice"],all:[],any:[{options:{allowImplicit:!0,ignoredTags:[]},id:"aria-allowed-role"}],none:[]},{id:"aria-dpub-role-fallback",selector:"[role]",matches:function(e){var t=e.getAttribute("role");return["doc-backlink","doc-biblioentry","doc-biblioref","doc-cover","doc-endnote","doc-glossref","doc-noteref"].includes(t)},tags:["cat.aria","wcag2a","wcag131","deprecated"],enabled:!1,all:["implicit-role-fallback"],any:[],none:[]},{id:"aria-hidden-body",selector:"body",excludeHidden:!1,tags:["cat.aria","wcag2a","wcag412"],all:[],any:["aria-hidden-body"],none:[]},{id:"aria-hidden-focus",selector:\'[aria-hidden="true"]\',matches:function(e){var t=re.commons.dom.getComposedParent;return function e(r){return!r||"true"!==r.getAttribute("aria-hidden")&&e(t(r))}(t(e))},excludeHidden:!1,tags:["cat.name-role-value","wcag2a","wcag412","wcag131"],all:["focusable-modal-open","focusable-disabled","focusable-not-tabbable"],any:[],none:[]},{id:"aria-input-field-name",selector:\'[role="combobox"], [role="listbox"], [role="searchbox"], [role="slider"], [role="spinbutton"], [role="textbox"]\',matches:function(e,t){var r=re.commons.aria,n=e.nodeName.toUpperCase(),a=r.getRole(e,{noImplicit:!0});return!("AREA"===n&&e.getAttribute("href")||["INPUT","SELECT","TEXTAREA"].includes(n)||"IMG"===n||"img"===a&&"SVG"!==n||"BUTTON"===n||"button"===a||"combobox"===a&&re.utils.querySelectorAll(t,\'input:not([type="hidden"])\').length)},tags:["wcag2a","wcag412"],all:[],any:["aria-label","aria-labelledby","non-empty-title"],none:["no-implicit-explicit-label"]},{id:"aria-required-attr",selector:"[role]",tags:["cat.aria","wcag2a","wcag412"],all:[],any:["aria-required-attr"],none:[]},{id:"aria-required-children",selector:"[role]",tags:["cat.aria","wcag2a","wcag131"],all:[],any:[{options:{reviewEmpty:["doc-bibliography","doc-endnotes","grid","list","listbox","table","tablist","tree","treegrid","rowgroup"]},id:"aria-required-children"}],none:[]},{id:"aria-required-parent",selector:"[role]",tags:["cat.aria","wcag2a","wcag131"],all:[],any:["aria-required-parent"],none:[]},{id:"aria-roledescription",selector:"[aria-roledescription]",tags:["cat.aria","wcag2a","wcag412"],all:[],any:[{options:{supportedRoles:["button","img","checkbox","radio","combobox","menuitemcheckbox","menuitemradio"]},id:"aria-roledescription"}],none:[]},{id:"aria-roles",selector:"[role]",matches:function(e,t){return!!t.hasAttr("role")&&!!t.attr("role").trim()},tags:["cat.aria","wcag2a","wcag412"],all:[],any:[],none:["fallbackrole","invalidrole","abstractrole","unsupportedrole"]},{id:"aria-toggle-field-name",selector:\'[role="checkbox"], [role="menuitemcheckbox"], [role="menuitemradio"], [role="radio"], [role="switch"]\',matches:function(e,t){var r=re.commons.aria,n=e.nodeName.toUpperCase(),a=r.getRole(e,{noImplicit:!0});return!("AREA"===n&&e.getAttribute("href")||["INPUT","SELECT","TEXTAREA"].includes(n)||"IMG"===n||"img"===a&&"SVG"!==n||"BUTTON"===n||"button"===a||"combobox"===a&&re.utils.querySelectorAll(t,\'input:not([type="hidden"])\').length)},tags:["wcag2a","wcag412"],all:[],any:["aria-label","aria-labelledby","non-empty-title","has-visible-text"],none:["no-implicit-explicit-label"]},{id:"aria-valid-attr-value",matches:function(e){var t=/^aria-/;if(e.hasAttributes())for(var r=re.utils.getNodeAttributes(e),n=0,a=r.length;n<a;n++)if(t.test(r[n].name))return!0;return!1},tags:["cat.aria","wcag2a","wcag412"],all:[{options:[],id:"aria-valid-attr-value"},"aria-errormessage"],any:[],none:[]},{id:"aria-valid-attr",matches:function(e){var t=/^aria-/;if(e.hasAttributes())for(var r=re.utils.getNodeAttributes(e),n=0,a=r.length;n<a;n++)if(t.test(r[n].name))return!0;return!1},tags:["cat.aria","wcag2a","wcag412"],all:[],any:[{options:[],id:"aria-valid-attr"}],none:[]},{id:"audio-caption",selector:"audio",enabled:!1,excludeHidden:!1,tags:["cat.time-and-media","wcag2a","wcag121","section508","section508.22.a"],all:[],any:[],none:["caption"]},{id:"autocomplete-valid",matches:function(e,t){var r=re.commons,n=r.text,a=r.aria,o=r.dom,i=t.attr("autocomplete");if(!i||""===n.sanitize(i))return!1;var s=t.props.nodeName;if(!1===["textarea","input","select"].includes(s))return!1;if("input"===s&&["submit","reset","button","hidden"].includes(t.props.type))return!1;var l=t.attr("aria-disabled")||"false";if(t.hasAttr("disabled")||"true"===l.toLowerCase())return!1;var u=t.attr("role"),c=t.attr("tabindex");if("-1"===c&&u){var d=a.lookupTable.role[u];if(void 0===d||"widget"!==d.type)return!1}return!("-1"===c&&t.actualNode&&!o.isVisible(t.actualNode,!1)&&!o.isVisible(t.actualNode,!0))},tags:["cat.forms","wcag21aa","wcag135"],all:["autocomplete-valid","autocomplete-appropriate"],any:[],none:[]},{id:"avoid-inline-spacing",selector:"[style]",tags:["wcag21aa","wcag1412"],all:["avoid-inline-spacing"],any:[],none:[]},{id:"blink",selector:"blink",excludeHidden:!1,tags:["cat.time-and-media","wcag2a","wcag222","section508","section508.22.j"],all:[],any:[],none:["is-on-screen"]},{id:"button-name",selector:\'button, [role="button"]:not(input)\',tags:["cat.name-role-value","wcag2a","wcag412","section508","section508.22.a"],all:[],any:["button-has-visible-text","aria-label","aria-labelledby","role-presentation","role-none","non-empty-title"],none:[]},{id:"bypass",selector:"html",pageLevel:!0,matches:function(e){return!!e.querySelector("a[href]")},tags:["cat.keyboard","wcag2a","wcag241","section508","section508.22.o"],all:[],any:["internal-link-present","header-present","landmark"],none:[]},{id:"checkboxgroup",selector:"input[type=checkbox][name]",tags:["cat.forms","best-practice","deprecated"],enabled:!1,all:[],any:["group-labelledby","fieldset"],none:[]},{id:"color-contrast",matches:function(e,r){var a=e.nodeName.toUpperCase(),o=e.type;if("true"===e.getAttribute("aria-disabled")||re.commons.dom.findUpVirtual(r,\'[aria-disabled="true"]\'))return!1;if(["INPUT","SELECT","TEXTAREA"].includes(a)){var i=t.getComputedStyle(e),s=parseInt(i.getPropertyValue("text-indent"),10);if(s){var l=e.getBoundingClientRect();if(l={top:l.top,bottom:l.bottom,left:l.left+s,right:l.right+s},!re.commons.dom.visuallyOverlaps(l,e))return!1}}if("INPUT"===a)return-1===["hidden","range","color","checkbox","radio","image"].indexOf(o)&&!e.disabled;if("SELECT"===a)return!!e.options.length&&!e.disabled;if("TEXTAREA"===a)return!e.disabled;if("OPTION"===a)return!1;if("BUTTON"===a&&e.disabled||re.commons.dom.findUpVirtual(r,"button[disabled]"))return!1;if("FIELDSET"===a&&e.disabled||re.commons.dom.findUpVirtual(r,"fieldset[disabled]"))return!1;var u=re.commons.dom.findUpVirtual(r,"label");if("LABEL"===a||u){var c=e,d=r;u&&(c=u,d=re.utils.getNodeFromTree(u));var p=re.commons.dom.getRootNode(c),m=c.htmlFor&&p.getElementById(c.htmlFor),f=re.utils.getNodeFromTree(m);if(m&&(m.disabled||"true"===m.getAttribute("aria-disabled")||re.commons.dom.findUpVirtual(f,\'[aria-disabled="true"]\')))return!1;if((m=re.utils.querySelectorAll(d,\'input:not([type="hidden"]):not([type="image"]):not([type="button"]):not([type="submit"]):not([type="reset"]), select, textarea\')).length&&m[0].actualNode.disabled)return!1}if(e.getAttribute("id")){var h=re.utils.escapeSelector(e.getAttribute("id")),b=re.commons.dom.getRootNode(e).querySelector("[aria-labelledby~="+h+"]");if(b&&b.disabled)return!1}var g=re.commons.text.visibleVirtual(r,!1,!0);if(""===g||""===re.commons.text.removeUnicode(g,{emoji:!0,nonBmp:!1,punctuations:!0}))return!1;var y=n.createRange(),v=r.children,w=v.length,x=null,D=0;for(D=0;D<w;D++)3===(x=v[D]).actualNode.nodeType&&""!==re.commons.text.sanitize(x.actualNode.nodeValue)&&y.selectNodeContents(x.actualNode);var k=y.getClientRects();for(w=k.length,D=0;D<w;D++)if(re.commons.dom.visuallyOverlaps(k[D],e))return!0;return!1},excludeHidden:!1,tags:["cat.color","wcag2aa","wcag143"],all:[],any:[{options:{noScroll:!1,ignoreUnicode:!0,ignoreLength:!1},id:"color-contrast"}],none:[]},{id:"css-orientation-lock",selector:"html",tags:["cat.structure","wcag134","wcag21aa","experimental"],all:[{options:{degreeThreshold:2},id:"css-orientation-lock"}],any:[],none:[],preload:!0},{id:"definition-list",selector:"dl",matches:function(e){return!e.getAttribute("role")},tags:["cat.structure","wcag2a","wcag131"],all:[],any:[],none:["structured-dlitems","only-dlitems"]},{id:"dlitem",selector:"dd, dt",matches:function(e){return!e.getAttribute("role")},tags:["cat.structure","wcag2a","wcag131"],all:[],any:["dlitem"],none:[]},{id:"document-title",selector:"html",matches:function(e){return e.ownerDocument.defaultView.self===e.ownerDocument.defaultView.top},tags:["cat.text-alternatives","wcag2a","wcag242"],all:[],any:["doc-has-title"],none:[]},{id:"duplicate-id-active",selector:"[id]",matches:function(e){var t=re.commons,r=t.dom,n=t.aria,a=e.getAttribute("id").trim(),o=\'*[id="\'.concat(re.utils.escapeSelector(a),\'"]\'),i=Array.from(r.getRootNode(e).querySelectorAll(o));return!n.isAccessibleRef(e)&&i.some(r.isFocusable)},excludeHidden:!1,tags:["cat.parsing","wcag2a","wcag411"],all:[],any:["duplicate-id-active"],none:[]},{id:"duplicate-id-aria",selector:"[id]",matches:function(e){return re.commons.aria.isAccessibleRef(e)},excludeHidden:!1,tags:["cat.parsing","wcag2a","wcag411"],all:[],any:["duplicate-id-aria"],none:[]},{id:"duplicate-id",selector:"[id]",matches:function(e){var t=re.commons,r=t.dom,n=t.aria,a=e.getAttribute("id").trim(),o=\'*[id="\'.concat(re.utils.escapeSelector(a),\'"]\'),i=Array.from(r.getRootNode(e).querySelectorAll(o));return!n.isAccessibleRef(e)&&i.every(function(e){return!r.isFocusable(e)})},excludeHidden:!1,tags:["cat.parsing","wcag2a","wcag411"],all:[],any:["duplicate-id"],none:[]},{id:"empty-heading",selector:\'h1, h2, h3, h4, h5, h6, [role="heading"]\',matches:function(e){var t;return e.hasAttribute("role")&&(t=e.getAttribute("role").split(/\\s+/i).filter(re.commons.aria.isValidRole)),t&&0<t.length?t.includes("heading"):"heading"===re.commons.aria.implicitRole(e)},tags:["cat.name-role-value","best-practice"],all:[],any:["has-visible-text"],none:[]},{id:"focus-order-semantics",selector:"div, h1, h2, h3, h4, h5, h6, [role=heading], p, span",matches:function(e){return re.commons.dom.insertedIntoFocusOrder(e)},tags:["cat.keyboard","best-practice","experimental"],all:[],any:[{options:[],id:"has-widget-role"},{options:[],id:"valid-scrollable-semantics"}],none:[]},{id:"form-field-multiple-labels",selector:"input, select, textarea",matches:function(e){if("input"!==e.nodeName.toLowerCase()||!1===e.hasAttribute("type"))return!0;var t=e.getAttribute("type").toLowerCase();return!1===["hidden","image","button","submit","reset"].includes(t)},tags:["cat.forms","wcag2a","wcag332"],all:[],any:[],none:["multiple-label"]},{id:"frame-tested",selector:"frame, iframe",tags:["cat.structure","review-item","best-practice"],all:[{options:{isViolation:!1},id:"frame-tested"}],any:[],none:[]},{id:"frame-title-unique",selector:"frame[title], iframe[title]",matches:function(e){var t=e.getAttribute("title");return!(!t||!re.commons.text.sanitize(t).trim())},tags:["cat.text-alternatives","best-practice"],all:[],any:[],none:["unique-frame-title"]},{id:"frame-title",selector:"frame, iframe",tags:["cat.text-alternatives","wcag2a","wcag241","wcag412","section508","section508.22.i"],all:[],any:["aria-label","aria-labelledby","non-empty-title","role-presentation","role-none"],none:[]},{id:"heading-order",selector:"h1, h2, h3, h4, h5, h6, [role=heading]",matches:function(e){var t;return e.hasAttribute("role")&&(t=e.getAttribute("role").split(/\\s+/i).filter(re.commons.aria.isValidRole)),t&&0<t.length?t.includes("heading"):"heading"===re.commons.aria.implicitRole(e)},tags:["cat.semantics","best-practice"],all:[],any:["heading-order"],none:[]},{id:"hidden-content",selector:"*",excludeHidden:!1,tags:["cat.structure","experimental","review-item","best-practice"],all:[],any:["hidden-content"],none:[]},{id:"html-has-lang",selector:"html",matches:function(e){return e.ownerDocument.defaultView.self===e.ownerDocument.defaultView.top},tags:["cat.language","wcag2a","wcag311"],all:[],any:["has-lang"],none:[]},{id:"html-lang-valid",selector:"html[lang], html[xml\\\\:lang]",tags:["cat.language","wcag2a","wcag311"],all:[],any:[],none:["valid-lang"]},{id:"html-xml-lang-mismatch",selector:"html[lang][xml\\\\:lang]",matches:function(e){var t=re.utils.getBaseLang,r=t(e.getAttribute("lang")),n=t(e.getAttribute("xml:lang"));return re.utils.validLangs().includes(r)&&re.utils.validLangs().includes(n)},tags:["cat.language","wcag2a","wcag311"],all:["xml-lang-mismatch"],any:[],none:[]},{id:"identical-links-same-purpose",selector:\'a[href], area[href], [role="link"]\',excludeHidden:!1,matches:function(e,t){var r=re.commons,n=r.aria;if(!r.text.accessibleTextVirtual(t))return!1;var a=n.getRole(e);return!a||"link"===a},tags:["wcag2aaa","wcag249","best-practice"],all:["identical-links-same-purpose"],any:[],none:[]},{id:"image-alt",selector:"img",tags:["cat.text-alternatives","wcag2a","wcag111","section508","section508.22.a"],all:[],any:["has-alt","aria-label","aria-labelledby","non-empty-title","role-presentation","role-none"],none:["alt-space-value"]},{id:"image-redundant-alt",selector:"img",tags:["cat.text-alternatives","best-practice"],all:[],any:[],none:["duplicate-img-label"]},{id:"input-button-name",selector:\'input[type="button"], input[type="submit"], input[type="reset"]\',tags:["cat.name-role-value","wcag2a","wcag412","section508","section508.22.a"],all:[],any:["non-empty-if-present","non-empty-value","aria-label","aria-labelledby","role-presentation","role-none","non-empty-title"],none:[]},{id:"input-image-alt",selector:\'input[type="image"]\',tags:["cat.text-alternatives","wcag2a","wcag111","section508","section508.22.a"],all:[],any:["non-empty-alt","aria-label","aria-labelledby","non-empty-title"],none:[]},{id:"label-content-name-mismatch",matches:function(e,t){var r=re.commons,n=r.aria,a=r.text,o=n.getRole(e);return!!(o&&Object.keys(n.lookupTable.role).filter(function(e){return"widget"===n.lookupTable.role[e].type}).includes(o)&&n.getRolesWithNameFromContents().includes(o)&&(a.sanitize(n.arialabelText(t))||a.sanitize(n.arialabelledbyText(e)))&&a.sanitize(a.visibleVirtual(t)))},tags:["wcag21a","wcag253","experimental"],all:[],any:[{options:{pixelThreshold:.1,occuranceThreshold:3},id:"label-content-name-mismatch"}],none:[]},{id:"label-title-only",selector:"input, select, textarea",matches:function(e){if("input"!==e.nodeName.toLowerCase()||!1===e.hasAttribute("type"))return!0;var t=e.getAttribute("type").toLowerCase();return!1===["hidden","image","button","submit","reset"].includes(t)},tags:["cat.forms","best-practice"],all:[],any:[],none:["title-only"]},{id:"label",selector:"input, select, textarea",matches:function(e){if("input"!==e.nodeName.toLowerCase()||!1===e.hasAttribute("type"))return!0;var t=e.getAttribute("type").toLowerCase();return!1===["hidden","image","button","submit","reset"].includes(t)},tags:["cat.forms","wcag2a","wcag412","wcag131","section508","section508.22.n"],all:[],any:["aria-label","aria-labelledby","implicit-label","explicit-label","non-empty-title"],none:["help-same-as-label","hidden-explicit-label"]},{id:"landmark-banner-is-top-level",selector:"header:not([role]), [role=banner]",matches:function(e,t){return e.hasAttribute("role")||!re.commons.dom.findUpVirtual(t,"article, aside, main, nav, section")},tags:["cat.semantics","best-practice"],all:[],any:["landmark-is-top-level"],none:[]},{id:"landmark-complementary-is-top-level",selector:"aside:not([role]), [role=complementary]",tags:["cat.semantics","best-practice"],all:[],any:["landmark-is-top-level"],none:[]},{id:"landmark-contentinfo-is-top-level",selector:"footer:not([role]), [role=contentinfo]",matches:function(e,t){return e.hasAttribute("role")||!re.commons.dom.findUpVirtual(t,"article, aside, main, nav, section")},tags:["cat.semantics","best-practice"],all:[],any:["landmark-is-top-level"],none:[]},{id:"landmark-main-is-top-level",selector:"main:not([role]), [role=main]",tags:["cat.semantics","best-practice"],all:[],any:["landmark-is-top-level"],none:[]},{id:"landmark-no-duplicate-banner",selector:"header:not([role]), [role=banner]",tags:["cat.semantics","best-practice"],all:[],any:[{options:{selector:"header:not([role]), [role=banner]",nativeScopeFilter:"article, aside, main, nav, section"},id:"page-no-duplicate-banner"}],none:[]},{id:"landmark-no-duplicate-contentinfo",selector:"footer:not([role]), [role=contentinfo]",tags:["cat.semantics","best-practice"],all:[],any:[{options:{selector:"footer:not([role]), [role=contentinfo]",nativeScopeFilter:"article, aside, main, nav, section"},id:"page-no-duplicate-contentinfo"}],none:[]},{id:"landmark-no-duplicate-main",selector:"main:not([role]), [role=main]",tags:["cat.semantics","best-practice"],all:[],any:[{options:{selector:"main:not([role]), [role=\'main\']"},id:"page-no-duplicate-main"}],none:[]},{id:"landmark-one-main",selector:"html",tags:["cat.semantics","best-practice"],all:[{options:{selector:"main:not([role]), [role=\'main\']"},id:"page-has-main"}],any:[],none:[]},{id:"landmark-unique",selector:"[role=banner], [role=complementary], [role=contentinfo], [role=main], [role=navigation], [role=region], [role=search], [role=form], form, footer, header, aside, main, nav, section",tags:["cat.semantics","best-practice"],matches:function(e,t){var r=["article","aside","main","nav","section"].join(",");return function(e){var t=e.actualNode,n=re.commons.aria.getRolesByType("landmark"),a=re.commons.aria.getRole(t);if(!a)return!1;var o,i=t.nodeName.toUpperCase();return"HEADER"===i||"FOOTER"===i?(o=e,!re.commons.dom.findUpVirtual(o,r)):"SECTION"!==i&&"FORM"!==i?0<=n.indexOf(a)||"region"===a:!!re.commons.text.accessibleTextVirtual(e)}(t)&&re.commons.dom.isVisible(e,!0)},all:[],any:["landmark-is-unique"],none:[]},{id:"layout-table",selector:"table",matches:function(e){var t=(e.getAttribute("role")||"").toLowerCase();return!(("presentation"===t||"none"===t)&&!re.commons.dom.isFocusable(e)||re.commons.table.isDataTable(e))},tags:["cat.semantics","wcag2a","wcag131","deprecated"],enabled:!1,all:[],any:[],none:["has-th","has-caption","has-summary"]},{id:"link-in-text-block",selector:"a[href], [role=link]",matches:function(e){var t=re.commons.text.sanitize(e.textContent),r=e.getAttribute("role");return(!r||"link"===r)&&!!t&&!!re.commons.dom.isVisible(e,!1)&&re.commons.dom.isInTextBlock(e)},excludeHidden:!1,tags:["cat.color","experimental","wcag2a","wcag141"],all:["link-in-text-block"],any:[],none:[]},{id:"link-name",selector:"a[href]:not([role=button]), [role=link]",tags:["cat.name-role-value","wcag2a","wcag412","wcag244","section508","section508.22.a"],all:[],any:["has-visible-text","aria-label","aria-labelledby","role-presentation","role-none"],none:["focusable-no-name"]},{id:"list",selector:"ul, ol",matches:function(e){return!e.getAttribute("role")},tags:["cat.structure","wcag2a","wcag131"],all:[],any:[],none:["only-listitems"]},{id:"listitem",selector:"li",matches:function(e){return!e.getAttribute("role")},tags:["cat.structure","wcag2a","wcag131"],all:[],any:["listitem"],none:[]},{id:"marquee",selector:"marquee",excludeHidden:!1,tags:["cat.parsing","wcag2a","wcag222"],all:[],any:[],none:["is-on-screen"]},{id:"meta-refresh",selector:\'meta[http-equiv="refresh"]\',excludeHidden:!1,tags:["cat.time-and-media","wcag2a","wcag2aaa","wcag221","wcag224","wcag325"],all:[],any:["meta-refresh"],none:[]},{id:"meta-viewport-large",selector:\'meta[name="viewport"]\',excludeHidden:!1,tags:["cat.sensory-and-visual-cues","best-practice"],all:[],any:[{options:{scaleMinimum:5,lowerBound:2},id:"meta-viewport-large"}],none:[]},{id:"meta-viewport",selector:\'meta[name="viewport"]\',excludeHidden:!1,tags:["cat.sensory-and-visual-cues","best-practice"],all:[],any:[{options:{scaleMinimum:2},id:"meta-viewport"}],none:[]},{id:"no-autoplay-audio",excludeHidden:!1,selector:"audio[autoplay], video[autoplay]",matches:function(e){return!!e.currentSrc&&!e.hasAttribute("paused")&&!e.hasAttribute("muted")},tags:["wcag2a","wcag142","experimental"],preload:!0,all:[{options:{allowedDuration:3},id:"no-autoplay-audio"}],any:[],none:[]},{id:"object-alt",selector:"object",tags:["cat.text-alternatives","wcag2a","wcag111","section508","section508.22.a"],all:[],any:["has-visible-text","aria-label","aria-labelledby","non-empty-title","role-presentation","role-none"],none:[]},{id:"p-as-heading",selector:"p",matches:function(e){var t=Array.from(e.parentNode.childNodes),r=e.textContent.trim();return!(0===r.length||2<=(r.match(/[.!?:;](?![.!?:;])/g)||[]).length)&&0!==t.slice(t.indexOf(e)+1).filter(function(e){return"P"===e.nodeName.toUpperCase()&&""!==e.textContent.trim()}).length},tags:["cat.semantics","wcag2a","wcag131","experimental"],all:[{options:{margins:[{weight:150,italic:!0},{weight:150,size:1.15},{italic:!0,size:1.15},{size:1.4}]},id:"p-as-heading"}],any:[],none:[]},{id:"page-has-heading-one",selector:"html",tags:["cat.semantics","best-practice"],all:[{options:{selector:\'h1:not([role]), [role="heading"][aria-level="1"]\'},id:"page-has-heading-one"}],any:[],none:[]},{id:"radiogroup",selector:"input[type=radio][name]",tags:["cat.forms","best-practice","deprecated"],enabled:!1,all:[],any:["group-labelledby","fieldset"],none:[]},{id:"region",selector:"body *",tags:["cat.keyboard","best-practice"],all:[],any:["region"],none:[]},{id:"role-img-alt",selector:"[role=\'img\']:not(img):not(area):not(input):not(object)",matches:function(e){return"http://www.w3.org/1999/xhtml"===e.namespaceURI},tags:["cat.text-alternatives","wcag2a","wcag111","section508","section508.22.a"],all:[],any:["aria-label","aria-labelledby","non-empty-title"],none:[]},{id:"scope-attr-valid",selector:"td[scope], th[scope]",tags:["cat.tables","best-practice"],all:["html5-scope","scope-value"],any:[],none:[]},{id:"scrollable-region-focusable",matches:function(e,t){var r=re.utils.querySelectorAll,n=re.commons.dom.hasContentVirtual;return 0!=!!re.utils.getScroll(e,13)&&!!r(t,"*").some(function(e){return n(e,!0,!0)})},tags:["wcag2a","wcag211"],all:[],any:["focusable-content","focusable-element"],none:[]},{id:"server-side-image-map",selector:"img[ismap]",tags:["cat.text-alternatives","wcag2a","wcag211","section508","section508.22.f"],all:[],any:[],none:["exists"]},{id:"skip-link",selector:\'a[href^="#"], a[href^="/#"]\',matches:function(e){return re.commons.dom.isSkipLink(e)&&re.commons.dom.isOffscreen(e)},tags:["cat.keyboard","best-practice"],all:[],any:["skip-link"],none:[]},{id:"svg-img-alt",selector:\'[role="img"], [role="graphics-symbol"], svg[role="graphics-document"]\',matches:function(e){return"http://www.w3.org/2000/svg"===e.namespaceURI},tags:["cat.text-alternatives","wcag2a","wcag111","section508","section508.22.a"],all:[],any:["svg-non-empty-title","aria-label","aria-labelledby","non-empty-title"],none:[]},{id:"tabindex",selector:"[tabindex]",tags:["cat.keyboard","best-practice"],all:[],any:["tabindex"],none:[]},{id:"table-duplicate-name",selector:"table",tags:["cat.tables","best-practice"],all:[],any:[],none:["same-caption-summary"]},{id:"table-fake-caption",selector:"table",matches:function(e){return re.commons.table.isDataTable(e)},tags:["cat.tables","experimental","wcag2a","wcag131","section508","section508.22.g"],all:["caption-faked"],any:[],none:[]},{id:"td-has-header",selector:"table",matches:function(e){if(re.commons.table.isDataTable(e)){var t=re.commons.table.toArray(e);return 3<=t.length&&3<=t[0].length&&3<=t[1].length&&3<=t[2].length}return!1},tags:["cat.tables","experimental","wcag2a","wcag131","section508","section508.22.g"],all:["td-has-header"],any:[],none:[]},{id:"td-headers-attr",selector:"table",tags:["cat.tables","wcag2a","wcag131","section508","section508.22.g"],all:["td-headers-attr"],any:[],none:[]},{id:"th-has-data-cells",selector:"table",matches:function(e){return re.commons.table.isDataTable(e)},tags:["cat.tables","wcag2a","wcag131","section508","section508.22.g"],all:["th-has-data-cells"],any:[],none:[]},{id:"valid-lang",selector:"[lang], [xml\\\\:lang]",matches:function(e){return"html"!==e.nodeName.toLowerCase()},tags:["cat.language","wcag2aa","wcag312"],all:[],any:[],none:["valid-lang"]},{id:"video-caption",selector:"video",excludeHidden:!1,tags:["cat.text-alternatives","wcag2a","wcag122","section508","section508.22.a"],all:[],any:[],none:["caption"]},{id:"video-description",selector:"video",excludeHidden:!1,tags:["cat.text-alternatives","wcag2aa","wcag125","section508","section508.22.b","deprecated"],enabled:!1,all:[],any:[],none:["description"]}],checks:[{id:"abstractrole",evaluate:function(e,t,r){var n=re.utils.tokenList(r.attr("role")).filter(function(e){return"abstract"===re.commons.aria.getRoleType(e)});return 0<n.length&&(this.data(n),!0)}},{id:"aria-allowed-attr",evaluate:function(e,t){t=t||{};var r,n,a,o=[],i=e.getAttribute("role"),s=re.utils.getNodeAttributes(e);if(i=i||re.commons.aria.implicitRole(e),a=re.commons.aria.allowedAttr(i),Array.isArray(t[i])&&(a=re.utils.uniqueArray(t[i].concat(a))),i&&a)for(var l=0,u=s.length;l<u;l++)n=(r=s[l]).name,re.commons.aria.validateAttr(n)&&!a.includes(n)&&o.push(n+\'="\'+r.nodeValue+\'"\');return!o.length||(this.data(o),!1)}},{id:"aria-allowed-role",evaluate:function(e,t){var r=re.commons.dom,n=t||{},a=n.allowImplicit,o=void 0===a||a,i=n.ignoredTags,s=void 0===i?[]:i,l=e.nodeName.toUpperCase();if(s.map(function(e){return e.toUpperCase()}).includes(l))return!0;var u=re.commons.aria.getElementUnallowedRoles(e,o);if(u.length){if(this.data(u),!r.isVisible(e,!0))return;return!1}return!0},options:{allowImplicit:!0,ignoredTags:[]}},{id:"aria-hidden-body",evaluate:function(e){return"true"!==e.getAttribute("aria-hidden")}},{id:"aria-roledescription",evaluate:function(e,t){t=t||{};var r=re.commons.aria.getRole(e);return!!(t.supportedRoles||[]).includes(r)||!(!r||"presentation"===r||"none"===r)&&void 0},options:{supportedRoles:["button","img","checkbox","radio","combobox","menuitemcheckbox","menuitemradio"]}},{id:"aria-errormessage",evaluate:function(e,t){var r=re.commons,n=r.aria,a=r.dom;t=Array.isArray(t)?t:[];var o=e.getAttribute("aria-errormessage"),i=e.hasAttribute("aria-errormessage"),s=a.getRootNode(e);return!(-1===t.indexOf(o)&&i&&!function(t){if(""===t.trim())return n.lookupTable.attributes["aria-errormessage"].allowEmpty;var r=t&&s.getElementById(t);return r&&("alert"===r.getAttribute("role")||"assertive"===r.getAttribute("aria-live")||-1<re.utils.tokenList(e.getAttribute("aria-describedby")||"").indexOf(t))}(o)&&(this.data(re.utils.tokenList(o)),1))}},{id:"fallbackrole",evaluate:function(e,t,r){return 1<re.utils.tokenList(r.attr("role")).length}},{id:"has-widget-role",evaluate:function(e){var t=e.getAttribute("role");if(null===t)return!1;var r=re.commons.aria.getRoleType(t);return"widget"===r||"composite"===r},options:[]},{id:"implicit-role-fallback",evaluate:function(e){var t=e.getAttribute("role");if(null===t||!re.commons.aria.isValidRole(t))return!0;var r=re.commons.aria.getRoleType(t);return re.commons.aria.implicitRole(e)===r},deprecated:!0},{id:"invalidrole",evaluate:function(e,t,r){var n=re.utils.tokenList,a=re.commons.aria,o=n(r.attr("role"));return!!o.every(function(e){return!a.isValidRole(e,{allowAbstract:!0})})&&(this.data(o),!0)}},{id:"no-implicit-explicit-label",evaluate:function(e,t,r){var n=re.commons,a=n.aria,o=n.text,i=a.getRole(e,{noImplicit:!0});this.data(i);var s=o.sanitize(o.labelText(r)).toLowerCase(),l=o.sanitize(o.accessibleText(e)).toLowerCase();return!(!l&&!s)&&!((l||!s)&&l.includes(s))&&void 0}},{id:"aria-required-attr",evaluate:function(e,t){t=t||{};var r=[],n=re.commons.forms,a=n.isNativeTextbox,o=n.isNativeSelect,i=n.isAriaTextbox,s=n.isAriaListbox,l=n.isAriaCombobox,u=n.isAriaRange,c={"aria-valuenow":function(){return!(a(e)||o(e)||i(e)||s(e)||l(e)||u(e)&&e.hasAttribute("aria-valuenow"))}};if(e.hasAttributes()){var d=e.getAttribute("role"),p=re.commons.aria.requiredAttr(d);if(Array.isArray(t[d])&&(p=re.utils.uniqueArray(t[d],p)),d&&p)for(var m=0,f=p.length;m<f;m++){var h=p[m];e.getAttribute(h)||c[h]&&!c[h]()||r.push(h)}}return!r.length||(this.data(r),!1)}},{id:"aria-required-children",evaluate:function(e,t,r){var n=re.commons.aria.requiredOwned,a=re.commons.aria.implicitNodes,o=re.utils.matchesSelector,i=re.commons.dom.idrefs,s=re.commons.dom.hasContentVirtual,l=t&&Array.isArray(t.reviewEmpty)?t.reviewEmpty:[];function u(e,t,r,n){if(null!==e){var i=a(r),s=[\'[role="\'+r+\'"]\'];return i&&(s=s.concat(i.map(function(e){return e+":not([role])"}))),s=s.join(","),n&&o(e,s)||re.utils.querySelectorAll(t,s)[0]}}function c(e,t){for(var r=0;r<e.length;r++){var n=e[r];if(null!==n&&u(n,re.utils.getNodeFromTree(n),t,!0))return 1}}var d=e.getAttribute("role"),p=n(d);if(!p)return!0;var m=!1,f=p.one;f||(m=!0,f=p.all);var h=function(e,t,n,a){for(var o=[],s=i(e,"aria-owns"),l=0;l<t.length;l++){var d=t[l];if(u(e,r,d)||c(s,d)){if(!n)return null}else n&&o.push(d)}if("combobox"===a){var p=o.indexOf("textbox");(0<=p&&"INPUT"===e.nodeName.toUpperCase()&&["text","search","email","url","tel"].includes(e.type)||u(e,r,"searchbox")||c(s,"searchbox"))&&o.splice(p,1);for(var m=["listbox","tree","grid","dialog"],f=e.getAttribute("aria-expanded"),h=f&&"false"!==f,b=(e.getAttribute("aria-haspopup")||"listbox").toLowerCase(),g=0;g<m.length;g++){var y=m[g];if(!h||y!==b){var v=o.indexOf(y);0<=v&&o.splice(v,1)}}}return o.length?o:!n&&t.length?t:null}(e,f,m,d);return!h||(this.data(h),!(!l.includes(d)||s(r,!1,!0)||function e(t){return t.children&&t.children.some(function(t){var r=re.commons.aria.getRole(t);return!["presentation","none",null].includes(r)||e(t)})}(r)||0!==i(e,"aria-owns").length)&&void 0)},options:{reviewEmpty:["doc-bibliography","doc-endnotes","grid","list","listbox","table","tablist","tree","treegrid","rowgroup"]}},{id:"aria-required-parent",evaluate:function(e,t,r){function n(e){return(re.commons.aria.implicitNodes(e)||[]).concat(\'[role="\'+e+\'"]\').join(",")}function a(e,t,r){var a,o,i=e.actualNode.getAttribute("role"),s=[];if(!(t=t||re.commons.aria.requiredContext(i)))return null;for(a=0,o=t.length;a<o;a++){if(r&&re.utils.matchesSelector(e.actualNode,n(t[a])))return null;if(re.commons.dom.findUpVirtual(e,n(t[a])))return null;s.push(t[a])}return s}var o=a(r);if(!o)return!0;var i=function(e){for(var t=[],r=null;e;){if(e.getAttribute("id")){var n=re.utils.escapeSelector(e.getAttribute("id"));(r=re.commons.dom.getRootNode(e).querySelector("[aria-owns~=".concat(n,"]")))&&t.push(r)}e=e.parentElement}return t.length?t:null}(e);if(i)for(var s=0,l=i.length;s<l;s++)if(!(o=a(re.utils.getNodeFromTree(i[s]),o,!0)))return!0;return this.data(o),!1}},{id:"aria-unsupported-attr",evaluate:function(e){var t=e.nodeName.toUpperCase(),r=re.commons.aria.lookupTable,n=re.commons.aria.getRole(e),o=Array.from(re.utils.getNodeAttributes(e)).filter(function(o){var i=o.name,s=r.attributes[i];if(!re.commons.aria.validateAttr(i))return!1;var l=s.unsupported;if("object"!==a(l))return!!l;var u=re.commons.matches(e,l.exceptions);return Object.keys(r.evaluateRoleForElement).includes(t)?!r.evaluateRoleForElement[t]({node:e,role:n,out:u}):!u}).map(function(e){return e.name.toString()});return!!o.length&&(this.data(o),!0)}},{id:"unsupportedrole",evaluate:function(e){return re.commons.aria.isUnsupportedRole(re.commons.aria.getRole(e))}},{id:"aria-valid-attr-value",evaluate:function(e,t){t=Array.isArray(t)?t:[];for(var r="",n="",a=[],o=/^aria-/,i=re.utils.getNodeAttributes(e),s=["aria-errormessage"],l={"aria-controls":function(){return"false"!==e.getAttribute("aria-expanded")&&"false"!==e.getAttribute("aria-selected")},"aria-current":function(){re.commons.aria.validateAttrValue(e,"aria-current")||(r=\'aria-current="\'.concat(e.getAttribute("aria-current"),\'"\'),n="ariaCurrent")},"aria-owns":function(){return"false"!==e.getAttribute("aria-expanded")},"aria-describedby":function(){re.commons.aria.validateAttrValue(e,"aria-describedby")||(r=\'aria-describedby="\'.concat(e.getAttribute("aria-describedby"),\'"\'),n="noId")}},u=0,c=i.length;u<c;u++){var d=i[u],p=d.name;s.includes(p)||-1!==t.indexOf(p)||!o.test(p)||l[p]&&!l[p]()||re.commons.aria.validateAttrValue(e,p)||a.push("".concat(p,\'="\').concat(d.nodeValue,\'"\'))}if(!r)return!a.length||(this.data(a),!1);this.data({messageKey:n,needsReview:r})},options:[]},{id:"aria-valid-attr",evaluate:function(e,t){t=Array.isArray(t)?t:[];for(var r,n=[],a=/^aria-/,o=re.utils.getNodeAttributes(e),i=0,s=o.length;i<s;i++)r=o[i].name,-1===t.indexOf(r)&&a.test(r)&&!re.commons.aria.validateAttr(r)&&n.push(r);return!n.length||(this.data(n),!1)},options:[]},{id:"valid-scrollable-semantics",evaluate:function(e){var t,r;return(r=(t=e).getAttribute("role"))&&{application:!0,banner:!1,complementary:!0,contentinfo:!0,form:!0,main:!0,navigation:!0,region:!0,search:!1}[r.toLowerCase()]||({ARTICLE:!0,ASIDE:!0,NAV:!0,SECTION:!0}[t.nodeName.toUpperCase()]||!1)},options:[]},{id:"color-contrast",evaluate:function(e,r,n){var a=re.commons,o=a.dom,i=a.color,s=a.text;if(!o.isVisible(e,!1))return!0;var l=s.visibleVirtual(n,!1,!0),u=!!(r||{}).ignoreUnicode;if(!s.hasUnicode(l,{nonBmp:!0})||""!==s.sanitize(s.removeUnicode(l,{nonBmp:!0}))||!u){var c,d=!!(r||{}).noScroll,p=[],m=i.getBackgroundColor(e,p,d),f=i.getForegroundColor(e,d,m),h=t.getComputedStyle(e),b=parseFloat(h.getPropertyValue("font-size")),g=h.getPropertyValue("font-weight"),y=700<=parseFloat(g)||"bold"===g,v=i.hasValidContrastRatio(m,f,b,y),w=Math.floor(100*v.contrastRatio)/100;null===m&&(c=i.incompleteData.get("bgColor"));var x=1==w,D=1===l.length,k=!!(r||{}).ignoreLength;x?c=i.incompleteData.set("bgColor","equalRatio"):D&&!k&&(c="shortTextContent");var E={fgColor:f?f.toHexString():void 0,bgColor:m?m.toHexString():void 0,contrastRatio:v?w:void 0,fontSize:"".concat((72*b/96).toFixed(1),"pt (").concat(b,"px)"),fontWeight:y?"bold":"normal",messageKey:c,expectedContrastRatio:v.expectedContrastRatio+":1"};return this.data(E),null===f||null===m||x||D&&!k&&!v.isValid?(c=null,i.incompleteData.clear(),void this.relatedNodes(p)):(v.isValid||this.relatedNodes(p),v.isValid)}this.data({messageKey:"nonBmp"})},options:{noScroll:!1,ignoreUnicode:!0,ignoreLength:!1}},{id:"link-in-text-block",evaluate:function(e){var r=re.commons,n=r.color,a=r.dom;function o(e,t){var r=e.getRelativeLuminance(),n=t.getRelativeLuminance();return(Math.max(r,n)+.05)/(Math.min(r,n)+.05)}var i=["block","list-item","table","flex","grid","inline-block"];function s(e){var r=t.getComputedStyle(e).getPropertyValue("display");return-1!==i.indexOf(r)||"table-"===r.substr(0,6)}if(s(e))return!1;for(var l,u,c=a.getComposedParent(e);1===c.nodeType&&!s(c);)c=a.getComposedParent(c);if(this.relatedNodes([c]),n.elementIsDistinct(e,c))return!0;if(l=n.getForegroundColor(e),u=n.getForegroundColor(c),l&&u){var d,p=o(l,u);return 1===p||(3<=p?(re.commons.color.incompleteData.set("fgColor","bgContrast"),this.data({messageKey:re.commons.color.incompleteData.get("fgColor")}),void re.commons.color.incompleteData.clear()):(l=n.getBackgroundColor(e),u=n.getBackgroundColor(c),(!l||!u||3<=o(l,u))&&(d=l&&u?"bgContrast":re.commons.color.incompleteData.get("bgColor"),re.commons.color.incompleteData.set("fgColor",d),this.data({messageKey:re.commons.color.incompleteData.get("fgColor")}),void re.commons.color.incompleteData.clear())))}}},{id:"autocomplete-appropriate",evaluate:function(e,t,r){if("input"!==r.props.nodeName)return!0;var n=["text","search","number"],o=["text","search","url"],i={bday:["text","search","date"],email:["text","search","email"],"cc-exp":["text","search","month"],"street-address":["text"],tel:["text","search","tel"],"cc-exp-month":n,"cc-exp-year":n,"transaction-amount":n,"bday-day":n,"bday-month":n,"bday-year":n,"new-password":["text","search","password"],"current-password":["text","search","password"],url:o,photo:o,impp:o};"object"===a(t)&&Object.keys(t).forEach(function(e){i[e]||(i[e]=[]),i[e]=i[e].concat(t[e])});var s=r.attr("autocomplete").split(/\\s+/g).map(function(e){return e.toLowerCase()}),l=s[s.length-1];if(re.commons.text.autocomplete.stateTerms.includes(l))return!0;var u=i[l],c=r.hasAttr("type")?re.commons.text.sanitize(r.attr("type")).toLowerCase():"text";return c=re.utils.validInputTypes().includes(c)?c:"text",void 0===u?"text"===c:u.includes(c)}},{id:"autocomplete-valid",evaluate:function(e,t,r){var n=r.attr("autocomplete")||"";return re.commons.text.isValidAutocomplete(n,t)}},{id:"fieldset",evaluate:function(e,t,r){var n,a=this;function o(e,t){return re.utils.toArray(e.querySelectorAll(\'select,textarea,button,input:not([name="\'+t+\'"]):not([type="hidden"])\'))}var i={name:e.getAttribute("name"),type:e.getAttribute("type")},s=function(e){var t=re.utils.escapeSelector(e.actualNode.name),r=re.commons.dom.getRootNode(e.actualNode).querySelectorAll(\'input[type="\'+re.utils.escapeSelector(e.actualNode.type)+\'"][name="\'+t+\'"]\');if(r.length<2)return!0;var i,s,l=re.commons.dom.findUpVirtual(e,"fieldset"),u=re.commons.dom.findUpVirtual(e,\'[role="group"]\'+("radio"===e.actualNode.type?\',[role="radiogroup"]\':""));return u||l?l?function(e,t){var r=e.firstElementChild;if(!r||"LEGEND"!==r.nodeName.toUpperCase())return a.relatedNodes([e]),!(n="no-legend");if(!re.commons.text.accessibleText(r))return a.relatedNodes([r]),!(n="empty-legend");var i=o(e,t);return!(i.length&&(a.relatedNodes(i),n="mixed-inputs"))}(l,t):function(e,t){var r=re.commons.dom.idrefs(e,"aria-labelledby").some(function(e){return e&&re.commons.text.accessibleText(e)}),i=e.getAttribute("aria-label");if(!(r||i&&re.commons.text.sanitize(i)))return a.relatedNodes(e),!(n="no-group-label");var s=o(e,t);return!(s.length&&(a.relatedNodes(s),n="group-mixed-inputs"))}(u,t):(n="no-group",a.relatedNodes((i=r,s=e.actualNode,re.utils.toArray(i).filter(function(e){return e!==s}))),!1)}(r);return s||(i.messageKey=n),this.data(i),s},after:function(e){var t={};return e.filter(function(e){if(e.result)return!0;var r=e.data;if(r){if(t[r.type]=t[r.type]||{},!t[r.type][r.name])return t[r.type][r.name]=[r],!0;var n=t[r.type][r.name].some(function(e){return e.failureCode===r.failureCode});return n||t[r.type][r.name].push(r),!n}return!1})},deprecated:!0},{id:"group-labelledby",evaluate:function(e){var t=re.commons,r=t.dom,n=t.text,a=re.utils.escapeSelector(e.type),o=re.utils.escapeSelector(e.name),i=r.getRootNode(e),s={name:e.name,type:e.type},l=Array.from(i.querySelectorAll(\'input[type="\'.concat(a,\'"][name="\').concat(o,\'"]\')));if(l.length<=1)return this.data(s),!0;var u=r.idrefs(e,"aria-labelledby").filter(function(e){return!!e}),c=u.slice();l.forEach(function(t){if(t!==e){var n=r.idrefs(t,"aria-labelledby").filter(function(e){return e});u=u.filter(function(e){return n.includes(e)}),c=c.filter(function(e){return!n.includes(e)})}});var d={inLabelledByContext:!0};return c=c.filter(function(e){return n.accessibleText(e,d)}),u=u.filter(function(e){return n.accessibleText(e,d)}),0<c.length&&0<u.length?(this.data(s),!0):(0<c.length&&0===u.length?s.messageKey="no-shared-label":0===c.length&&0<u.length&&(s.messageKey="no-unique-label"),this.data(s),!1)},after:function(e){var t={};return e.filter(function(e){var r=e.data;return!(!r||(t[r.type]=t[r.type]||{},t[r.type][r.name]))&&(t[r.type][r.name]=!0)})},deprecated:!0},{id:"accesskeys",evaluate:function(e){return re.commons.dom.isVisible(e,!1)&&(this.data(e.getAttribute("accesskey")),this.relatedNodes([e])),!0},after:function(e){var t={};return e.filter(function(e){if(!e.data)return!1;var r=e.data.toUpperCase();return t[r]?(t[r].relatedNodes.push(e.relatedNodes[0]),!1):((t[r]=e).relatedNodes=[],!0)}).map(function(e){return e.result=!!e.relatedNodes.length,e})}},{id:"focusable-content",evaluate:function(e,t,r){var n=r.tabbableElements;return!!n&&0<n.filter(function(e){return e!==r}).length}},{id:"focusable-disabled",evaluate:function(e,t,r){var n=["BUTTON","FIELDSET","INPUT","SELECT","TEXTAREA"],a=r.tabbableElements;if(!a||!a.length)return!0;var o=a.reduce(function(e,t){var r=t.actualNode,a=r.nodeName.toUpperCase();return n.includes(a)&&e.push(r),e},[]);return this.relatedNodes(o),!(!o.length||!re.commons.dom.isModalOpen())||0===o.length}},{id:"focusable-element",evaluate:function(e,t,r){var n=r.isFocusable,a=parseInt(r.actualNode.getAttribute("tabindex"),10);return(a=isNaN(a)?null:a)?n&&0<=a:n}},{id:"focusable-modal-open",evaluate:function(e,t,r){var n=r.tabbableElements.map(function(e){return e.actualNode});return!n||!n.length||!re.commons.dom.isModalOpen()||void this.relatedNodes(n)}},{id:"focusable-no-name",evaluate:function(e,t,r){var n=e.getAttribute("tabindex");return!!(re.commons.dom.isFocusable(e)&&-1<n)&&!re.commons.text.accessibleTextVirtual(r)}},{id:"focusable-not-tabbable",evaluate:function(e,t,r){var n=["BUTTON","FIELDSET","INPUT","SELECT","TEXTAREA"],a=r.tabbableElements;if(!a||!a.length)return!0;var o=a.reduce(function(e,t){var r=t.actualNode,a=r.nodeName.toUpperCase();return n.includes(a)||e.push(r),e},[]);return this.relatedNodes(o),!!(0<o.length&&re.commons.dom.isModalOpen())||0===o.length}},{id:"landmark-is-top-level",evaluate:function(e){var t=re.commons.aria.getRolesByType("landmark"),r=re.commons.dom.getComposedParent(e);for(this.data({role:e.getAttribute("role")||re.commons.aria.implicitRole(e)});r;){var n=r.getAttribute("role");if(n||"FORM"===r.nodeName.toUpperCase()||(n=re.commons.aria.implicitRole(r)),n&&t.includes(n))return!1;r=re.commons.dom.getComposedParent(r)}return!0}},{id:"page-has-heading-one",evaluate:function(e,t,r){if(!t||!t.selector||"string"!=typeof t.selector)throw new TypeError("visible-in-page requires options.selector to be a string");var n=re.utils.querySelectorAllFilter(r,t.selector,function(e){return re.commons.dom.isVisible(e.actualNode,!0)});return this.relatedNodes(n.map(function(e){return e.actualNode})),0<n.length},after:function(e){return e.some(function(e){return!0===e.result})&&e.forEach(function(e){e.result=!0}),e},options:{selector:\'h1:not([role]), [role="heading"][aria-level="1"]\'}},{id:"page-has-main",evaluate:function(e,t,r){if(!t||!t.selector||"string"!=typeof t.selector)throw new TypeError("visible-in-page requires options.selector to be a string");var n=re.utils.querySelectorAllFilter(r,t.selector,function(e){return re.commons.dom.isVisible(e.actualNode,!0)});return this.relatedNodes(n.map(function(e){return e.actualNode})),0<n.length},after:function(e){return e.some(function(e){return!0===e.result})&&e.forEach(function(e){e.result=!0}),e},options:{selector:"main:not([role]), [role=\'main\']"}},{id:"page-no-duplicate-banner",evaluate:function(e,t,r){if(!t||!t.selector||"string"!=typeof t.selector)throw new TypeError("visible-in-page requires options.selector to be a string");var n="page-no-duplicate;"+t.selector;if(!re._cache.get(n)){re._cache.set(n,!0);var a=re.utils.querySelectorAllFilter(re._tree[0],t.selector,function(e){return re.commons.dom.isVisible(e.actualNode)});return"string"==typeof t.nativeScopeFilter&&(a=a.filter(function(e){return e.actualNode.hasAttribute("role")||!re.commons.dom.findUpVirtual(e,t.nativeScopeFilter)})),this.relatedNodes(a.filter(function(e){return e!==r}).map(function(e){return e.actualNode})),a.length<=1}this.data("ignored")},after:function(e){return e.filter(function(e){return"ignored"!==e.data})},options:{selector:"header:not([role]), [role=banner]",nativeScopeFilter:"article, aside, main, nav, section"}},{id:"page-no-duplicate-contentinfo",evaluate:function(e,t,r){if(!t||!t.selector||"string"!=typeof t.selector)throw new TypeError("visible-in-page requires options.selector to be a string");var n="page-no-duplicate;"+t.selector;if(!re._cache.get(n)){re._cache.set(n,!0);var a=re.utils.querySelectorAllFilter(re._tree[0],t.selector,function(e){return re.commons.dom.isVisible(e.actualNode)});return"string"==typeof t.nativeScopeFilter&&(a=a.filter(function(e){return e.actualNode.hasAttribute("role")||!re.commons.dom.findUpVirtual(e,t.nativeScopeFilter)})),this.relatedNodes(a.filter(function(e){return e!==r}).map(function(e){return e.actualNode})),a.length<=1}this.data("ignored")},after:function(e){return e.filter(function(e){return"ignored"!==e.data})},options:{selector:"footer:not([role]), [role=contentinfo]",nativeScopeFilter:"article, aside, main, nav, section"}},{id:"page-no-duplicate-main",evaluate:function(e,t,r){if(!t||!t.selector||"string"!=typeof t.selector)throw new TypeError("visible-in-page requires options.selector to be a string");var n="page-no-duplicate;"+t.selector;if(!re._cache.get(n)){re._cache.set(n,!0);var a=re.utils.querySelectorAllFilter(re._tree[0],t.selector,function(e){return re.commons.dom.isVisible(e.actualNode)});return"string"==typeof t.nativeScopeFilter&&(a=a.filter(function(e){return e.actualNode.hasAttribute("role")||!re.commons.dom.findUpVirtual(e,t.nativeScopeFilter)})),this.relatedNodes(a.filter(function(e){return e!==r}).map(function(e){return e.actualNode})),a.length<=1}this.data("ignored")},after:function(e){return e.filter(function(e){return"ignored"!==e.data})},options:{selector:"main:not([role]), [role=\'main\']"}},{id:"tabindex",evaluate:function(e){var t=parseInt(e.getAttribute("tabindex"),10);return!!isNaN(t)||t<=0}},{id:"alt-space-value",evaluate:function(e,t,r){var n=r.attr("alt");return"string"==typeof n&&/^\\s+$/.test(n)}},{id:"duplicate-img-label",evaluate:function(e,t,r){var n=re.commons,a=n.aria,o=n.text,i=n.dom;if(["none","presentation"].includes(a.getRole(e)))return!1;var s=i.findUpVirtual(r,\'button, [role="button"], a[href], p, li, td, th\');if(!s)return!1;var l=re.utils.getNodeFromTree(s),u=o.visibleVirtual(l,!0).toLowerCase();return""!==u&&u===o.accessibleTextVirtual(r).toLowerCase()}},{id:"explicit-label",evaluate:function(e){if(e.getAttribute("id")){var t=re.commons.dom.getRootNode(e),r=re.utils.escapeSelector(e.getAttribute("id")),n=t.querySelector(\'label[for="\'.concat(r,\'"]\'));if(n)return!re.commons.dom.isVisible(n)||!!re.commons.text.accessibleText(n)}return!1}},{id:"help-same-as-label",evaluate:function(e,t,r){var n=re.commons.text.labelVirtual(r),a=e.getAttribute("title");return!!n&&(a||(a="",e.getAttribute("aria-describedby")&&(a=re.commons.dom.idrefs(e,"aria-describedby").map(function(e){return e?re.commons.text.accessibleText(e):""}).join(""))),re.commons.text.sanitize(a)===re.commons.text.sanitize(n))},enabled:!1},{id:"hidden-explicit-label",evaluate:function(e,t,r){if(e.getAttribute("id")){var n=re.commons.dom.getRootNode(e),a=re.utils.escapeSelector(e.getAttribute("id")),o=n.querySelector(\'label[for="\'.concat(a,\'"]\'));if(o&&!re.commons.dom.isVisible(o,!0))return""===re.commons.text.accessibleTextVirtual(r).trim()}return!1}},{id:"implicit-label",evaluate:function(e,t,r){var n=re.commons,a=n.dom,o=n.text,i=a.findUpVirtual(r,"label");return!!i&&!!o.accessibleText(i,{inControlContext:!0})}},{id:"label-content-name-mismatch",evaluate:function(e,t,r){var n=re.commons.text,a=t||{},o=a.pixelThreshold,i=a.occuranceThreshold,s=n.accessibleText(e).toLowerCase();if(!(n.isHumanInterpretable(s)<1)){var l=n.visibleTextNodes(r).filter(function(e){return!n.isIconLigature(e,o,i)}).map(function(e){return e.actualNode.nodeValue}).join(""),u=n.sanitize(l).toLowerCase();return!u||(n.isHumanInterpretable(u)<1?!!c(u,s)||void 0:c(u,s))}function c(e,t){var r=d(t),n=d(e);return!(!r||!n)&&r.includes(n)}function d(e){var t=n.removeUnicode(e,{emoji:!0,nonBmp:!0,punctuations:!0});return n.sanitize(t)}},options:{pixelThreshold:.1,occuranceThreshold:3}},{id:"multiple-label",evaluate:function(e){var t=re.utils.escapeSelector(e.getAttribute("id")),r=e.parentNode,n=re.commons.dom.getRootNode(e);n=n.documentElement||n;var a=Array.from(n.querySelectorAll(\'label[for="\'.concat(t,\'"]\')));for(a.length&&(a=a.filter(function(e){return re.commons.dom.isVisible(e)}));r;)"LABEL"===r.nodeName.toUpperCase()&&-1===a.indexOf(r)&&a.push(r),r=r.parentNode;if(this.relatedNodes(a),1<a.length){var o=a.filter(function(e){return re.commons.dom.isVisible(e,!0)});if(1<o.length)return;return!re.commons.dom.idrefs(e,"aria-labelledby").includes(o[0])&&void 0}return!1}},{id:"title-only",evaluate:function(e,t,r){return!(re.commons.text.labelVirtual(r)||!e.getAttribute("title")&&!e.getAttribute("aria-describedby"))}},{id:"landmark-is-unique",evaluate:function(e,t,r){var n=re.commons.aria.getRole(e),a=re.commons.text.accessibleTextVirtual(r);return a=a?a.toLowerCase():null,this.data({role:n,accessibleText:a}),this.relatedNodes([e]),!0},after:function(e){var t=[];return e.filter(function(e){var r=t.find(function(t){return e.data.role===t.data.role&&e.data.accessibleText===t.data.accessibleText});return r?(r.result=!1,r.relatedNodes.push(e.relatedNodes[0]),!1):(t.push(e),e.relatedNodes=[],!0)})}},{id:"has-lang",evaluate:function(e){var t=re.utils.isXHTML,r=(e.getAttribute("lang")||"").trim(),a=(e.getAttribute("xml:lang")||"").trim();return r||!a||t(n)?!(!r&&!a&&(this.data({messageKey:"noLang"}),1)):(this.data({messageKey:"noXHTML"}),!1)}},{id:"valid-lang",evaluate:function(e,t){var r,n;return r=(t||re.utils.validLangs()).map(re.utils.getBaseLang),!!(n=["lang","xml:lang"].reduce(function(t,n){var a=e.getAttribute(n);if("string"!=typeof a)return t;var o=re.utils.getBaseLang(a);return""!==o&&-1===r.indexOf(o)&&t.push(n+\'="\'+e.getAttribute(n)+\'"\'),t},[])).length&&(this.data(n),!0)}},{id:"xml-lang-mismatch",evaluate:function(e){var t=re.utils.getBaseLang;return t(e.getAttribute("lang"))===t(e.getAttribute("xml:lang"))}},{id:"dlitem",evaluate:function(e){var t=re.commons.dom.getComposedParent(e),r=t.nodeName.toUpperCase(),n=re.commons.aria.getRole(t,{noImplicit:!0});return"DIV"===r&&["presentation","none",null].includes(n)&&(r=(t=re.commons.dom.getComposedParent(t)).nodeName.toUpperCase(),n=re.commons.aria.getRole(t,{noImplicit:!0})),"DL"===r&&(!n||"list"===n)}},{id:"listitem",evaluate:function(e){var t=re.commons.dom.getComposedParent(e);if(t){var r=t.nodeName.toUpperCase(),n=(t.getAttribute("role")||"").toLowerCase();return!!["presentation","none","list"].includes(n)||(n&&re.commons.aria.isValidRole(n)?(this.data({messageKey:"roleNotValid"}),!1):["UL","OL"].includes(r))}}},{id:"only-dlitems",evaluate:function(e,t,r){var n=re.commons,a=n.dom,o=n.aria,i=["definition","term","list"],s=r.children.reduce(function(e,t){var r=t.actualNode;return"DIV"===r.nodeName.toUpperCase()&&null===o.getRole(r)?e.concat(t.children):e.concat(t)},[]).reduce(function(e,t){var r=t.actualNode,n=r.nodeName.toUpperCase();if(1===r.nodeType&&a.isVisible(r,!0,!1)){var s=o.getRole(r,{noImplicit:!0});("DT"!==n&&"DD"!==n||s)&&(i.includes(s)||e.badNodes.push(r))}else 3===r.nodeType&&""!==r.nodeValue.trim()&&(e.hasNonEmptyTextNode=!0);return e},{badNodes:[],hasNonEmptyTextNode:!1});return s.badNodes.length&&this.relatedNodes(s.badNodes),!!s.badNodes.length||s.hasNonEmptyTextNode}},{id:"only-listitems",evaluate:function(e,t,r){var n=re.commons,a=n.dom,o=n.aria,i=!1,s=!1,l=!0,u=[],c=[],d=[];return r.children.forEach(function(e){var t=e.actualNode;if(3!==t.nodeType||""===t.nodeValue.trim()){if(1===t.nodeType&&a.isVisible(t,!0,!1)){l=!1;var r="LI"===t.nodeName.toUpperCase(),n=o.getRole(e),p="listitem"===n;r||p||u.push(t),r&&!p&&(c.push(t),d.includes(n)||d.push(n)),p&&(s=!0)}}else i=!0}),i||u.length?(this.relatedNodes(u),!0):!l&&!s&&(this.relatedNodes(c),this.data({messageKey:"roleNotValid",roles:d.join(", ")}),!0)}},{id:"structured-dlitems",evaluate:function(e,t,r){var n=r.children;if(!n||!n.length)return!1;for(var a,o=!1,i=!1,s=0;s<n.length;s++){if("DT"===(a=n[s].actualNode.nodeName.toUpperCase())&&(o=!0),o&&"DD"===a)return!1;"DD"===a&&(i=!0)}return o||i}},{id:"caption",evaluate:function(e,t,r){return!re.utils.querySelectorAll(r,"track").some(function(e){return"captions"===(e.actualNode.getAttribute("kind")||"").toLowerCase()})&&void 0}},{id:"description",evaluate:function(e,t,r){return!re.utils.querySelectorAll(r,"track").some(function(e){return"descriptions"===(e.actualNode.getAttribute("kind")||"").toLowerCase()})&&void 0}},{id:"frame-tested",evaluate:function(e,t){var r=this.async(),n=Object.assign({isViolation:!1,timeout:500},t),a=n.isViolation,o=n.timeout,i=setTimeout(function(){i=setTimeout(function(){i=null,r(!a&&void 0)},0)},o);re.utils.respondable(e.contentWindow,"axe.ping",null,void 0,function(){null!==i&&(clearTimeout(i),r(!0))})},options:{isViolation:!1}},{id:"no-autoplay-audio",evaluate:function(e,t){if(e.duration){var r=t.allowedDuration,n=void 0===r?3:r;return function(e){if(!e.currentSrc)return 0;var t=function(e){var t=e.match(/#t=(.*)/);return t?B(t,2)[1].split(",").map(function(e){return(/:/.test(e)?function(e){for(var t=e.split(":"),r=0,n=1;0<t.length;)r+=n*parseInt(t.pop(),10),n*=60;return parseFloat(r)}:parseFloat)(e)}):void 0}(e.currentSrc);return t?1!==t.length?Math.abs(t[1]-t[0]):Math.abs(e.duration-t[0]):Math.abs(e.duration-(e.currentTime||0))}(e)<=n&&!e.hasAttribute("loop")||!!e.hasAttribute("controls")}console.warn("axe.utils.preloadMedia did not load metadata")},options:{allowedDuration:3}},{id:"css-orientation-lock",evaluate:function(e,t,r,n){var a=(n||{}).cssom,o=void 0===a?void 0:a,i=(t||{}).degreeThreshold,s=void 0===i?0:i;if(o&&o.length){function l(){var e=m[p],t=d[e],r=t.root,n=t.rules.filter(f);if(!n.length)return"continue";n.forEach(function(e){var t=e.cssRules;Array.from(t).forEach(function(e){var t=function(e){var t=e.selectorText,r=e.style;if(!t||r.length<=0)return!1;var n=r.transform||r.webkitTransform||r.msTransform||!1;if(!n)return!1;var a=n.match(/(rotate|rotateZ|rotate3d|matrix|matrix3d)\\(([^)]+)\\)(?!.*(rotate|rotateZ|rotate3d|matrix|matrix3d))/);if(!a)return!1;var o=B(a,3),i=o[1],l=function(e,t){switch(i){case"rotate":case"rotateZ":return h(t);case"rotate3d":var r=t.split(",").map(function(e){return e.trim()}),n=B(r,4),a=n[2],o=n[3];if(0===parseInt(a))return;return h(o);case"matrix":case"matrix3d":return function(e){var t=e.split(",");if(t.length<=6){var r=B(t,2),n=r[0],a=r[1];return b(Math.atan2(parseFloat(a),parseFloat(n)))}var o=parseFloat(t[8]),i=Math.asin(o),s=Math.cos(i);return b(Math.acos(parseFloat(t[0])/s))}(t);default:return}}(0,o[2]);return!!l&&(l=Math.abs(l),!(Math.abs(l-180)%180<=s)&&Math.abs(l-90)%90<=s)}(e);if(t&&"HTML"!==e.selectorText.toUpperCase()){var n=Array.from(r.querySelectorAll(e.selectorText))||[];c=c.concat(n)}u=u||t})})}for(var u=!1,c=[],d=o.reduce(function(e,t){var r=t.sheet,n=t.root,a=t.shadowId||"topDocument";if(e[a]||(e[a]={root:n,rules:[]}),!r||!r.cssRules)return e;var o=Array.from(r.cssRules);return e[a].rules=e[a].rules.concat(o),e},{}),p=0,m=Object.keys(d);p<m.length;p++)l();return!u||(c.length&&this.relatedNodes(c),!1)}function f(e){var t=e.type,r=e.cssText;return 4===t&&(/orientation:\\s*landscape/i.test(r)||/orientation:\\s*portrait/i.test(r))}function h(e){var t=e.match(/(deg|grad|rad|turn)/)||[],r=B(t,1)[0];if(r){var n,a=parseFloat(e.replace(r,""));switch(r){case"rad":return b(a);case"grad":return function(e){return(e%=400)<0&&(e+=400),Math.round(e/400*360)}(a);case"turn":return n=a,Math.round(360/(1/n));case"deg":default:return parseInt(a)}}}function b(e){return Math.round(e*(180/Math.PI))}},options:{degreeThreshold:2}},{id:"meta-viewport-large",evaluate:function(e,t){var r=t||{},n=r.scaleMinimum,a=void 0===n?2:n,o=r.lowerBound,i=void 0!==o&&o,s=e.getAttribute("content")||"";if(!s)return!0;var l=s.split(/[;,]/).reduce(function(e,t){var r=t.trim();if(!r)return e;var n=r.split("="),a=B(n,2),o=a[0],i=a[1];if(!o||!i)return e;var s=o.toLowerCase().trim(),l=i.toLowerCase().trim();return"maximum-scale"===s&&"yes"===l&&(l=1),"maximum-scale"===s&&parseFloat(l)<0||(e[s]=l),e},{});return!(!(i&&l["maximum-scale"]&&parseFloat(l["maximum-scale"])<i)&&(i||"no"!==l["user-scalable"]?l["maximum-scale"]&&parseFloat(l["maximum-scale"])<a&&(this.data("maximum-scale"),1):(this.data("user-scalable=no"),1)))},options:{scaleMinimum:5,lowerBound:2}},{id:"meta-viewport",evaluate:function(e,t){var r=t||{},n=r.scaleMinimum,a=void 0===n?2:n,o=r.lowerBound,i=void 0!==o&&o,s=e.getAttribute("content")||"";if(!s)return!0;var l=s.split(/[;,]/).reduce(function(e,t){var r=t.trim();if(!r)return e;var n=r.split("="),a=B(n,2),o=a[0],i=a[1];if(!o||!i)return e;var s=o.toLowerCase().trim(),l=i.toLowerCase().trim();return"maximum-scale"===s&&"yes"===l&&(l=1),"maximum-scale"===s&&parseFloat(l)<0||(e[s]=l),e},{});return!(!(i&&l["maximum-scale"]&&parseFloat(l["maximum-scale"])<i)&&(i||"no"!==l["user-scalable"]?l["maximum-scale"]&&parseFloat(l["maximum-scale"])<a&&(this.data("maximum-scale"),1):(this.data("user-scalable=no"),1)))},options:{scaleMinimum:2}},{id:"header-present",evaluate:function(e,t,r){return!!re.utils.querySelectorAll(r,\'h1, h2, h3, h4, h5, h6, [role="heading"]\')[0]}},{id:"heading-order",evaluate:function(e){var t=e.getAttribute("aria-level");if(null!==t)return this.data(parseInt(t,10)),!0;var r=e.nodeName.toUpperCase().match(/H(\\d)/);return r&&this.data(parseInt(r[1],10)),!0},after:function(e){if(e.length<2)return e;for(var t=e[0].data,r=1;r<e.length;r++)e[r].result&&e[r].data>t+1&&(e[r].result=!1),t=e[r].data;return e}},{id:"identical-links-same-purpose",evaluate:function(e,t,r){var n=re.commons,a=n.dom,o=n.text,i=o.accessibleTextVirtual(r),s=o.sanitize(o.removeUnicode(i,{emoji:!0,nonBmp:!0,punctuations:!0})).toLowerCase();if(s){var l={name:s,urlProps:a.urlPropsFromAttribute(e,"href")};return this.data(l),this.relatedNodes([e]),!0}},after:function(e){if(e.length<2)return e;function t(e){var t,i=r[e],s=i.data,l=s.name,u=s.urlProps;if(o[l])return"continue";var c=r.filter(function(t,r){return t.data.name===l&&r!==e}),d=c.every(function(e){return function e(t,r){if(!t||!r)return!1;var n=Object.getOwnPropertyNames(t),o=Object.getOwnPropertyNames(r);return n.length===o.length&&n.every(function(n){var o=t[n],i=r[n];return a(o)===a(i)&&("object"==typeof o||"object"==typeof i?e(o,i):o===i)})}(e.data.urlProps,u)});c.length&&!d&&(i.result=void 0),i.relatedNodes=[],(t=i.relatedNodes).push.apply(t,_e(c.map(function(e){return e.relatedNodes[0]}))),o[l]=c,n.push(i)}for(var r=e.filter(function(e){return void 0!==e.result}),n=[],o={},i=0;i<r.length;i++)t(i);return n}},{id:"internal-link-present",evaluate:function(e,t,r){return re.utils.querySelectorAll(r,"a[href]").some(function(e){return/^#[^/!]/.test(e.actualNode.getAttribute("href"))})}},{id:"landmark",evaluate:function(e,t,r){return 0<re.utils.querySelectorAll(r,\'main, [role="main"]\').length}},{id:"meta-refresh",evaluate:function(e){var t=e.getAttribute("content")||"",r=t.split(/[;,]/);return""===t||"0"===r[0]}},{id:"p-as-heading",evaluate:function(e,r,n){var a=Array.from(e.parentNode.children),o=a.indexOf(e),i=(r=r||{}).margins||[],s=a.slice(o+1).find(function(e){return"P"===e.nodeName.toUpperCase()}),l=a.slice(0,o).reverse().find(function(e){return"P"===e.nodeName.toUpperCase()});function u(e){var r=t.getComputedStyle(function(e){for(var t=e,r=e.textContent.trim(),n=r;n===r&&void 0!==t;){var a=-1;if(0===(e=t).children.length)return e;for(;a++,""===(n=e.children[a].textContent.trim())&&a+1<e.children.length;);t=e.children[a]}return e}(e));return{fontWeight:function(e){switch(e){case"lighter":return 100;case"normal":return 400;case"bold":return 700;case"bolder":return 900}return e=parseInt(e),isNaN(e)?400:e}(r.getPropertyValue("font-weight")),fontSize:parseInt(r.getPropertyValue("font-size")),isItalic:"italic"===r.getPropertyValue("font-style")}}function c(e,t,r){return r.reduce(function(r,n){return r||(!n.size||e.fontSize/n.size>t.fontSize)&&(!n.weight||e.fontWeight-n.weight>t.fontWeight)&&(!n.italic||e.isItalic&&!t.isItalic)},!1)}var d=u(e),p=s?u(s):null,m=l?u(l):null;if(!p||!c(d,p,i))return!0;var f=re.commons.dom.findUpVirtual(n,"blockquote");return!!(f&&"BLOCKQUOTE"===f.nodeName.toUpperCase()||m&&!c(d,m,i))&&void 0},options:{margins:[{weight:150,italic:!0},{weight:150,size:1.15},{italic:!0,size:1.15},{size:1.4}]}},{id:"region",evaluate:function(e,t,r){var a=re.commons,o=a.dom,i=a.aria,s=i.getRolesByType("landmark"),l=["alert","log","status"],u=re._cache.get("regionlessNodes");if(u)return!u.includes(r);var c=s.reduce(function(e,t){return e.concat(i.implicitNodes(t))},[]).filter(function(e){return null!==e});return u=function e(t){var r,a,u,d,p=t.actualNode;if(a=(r=t).actualNode,u=re.commons.aria.getRole(a,{noImplicit:!0}),d=(a.getAttribute("aria-live")||"").toLowerCase().trim(),["assertive","polite"].includes(d)||l.includes(u)||(u?"dialog"===u||s.includes(u):c.some(function(e){var t=re.utils.matchesSelector(a,e);if("FORM"!==a.nodeName.toUpperCase())return t;var n=a.getAttribute("title"),o=n&&""!==n.trim()?re.commons.text.sanitize(n):null;return t&&(!!i.labelVirtual(r)||!!o)}))||o.isSkipLink(t.actualNode)&&o.getElementByReference(t.actualNode,"href")||!o.isVisible(p,!0)){for(var m=t;m;)m._hasRegionDescendant=!0,m=m.parent;return[]}return p!==n.body&&o.hasContent(p,!0)?[t]:t.children.filter(function(e){return 1===e.actualNode.nodeType}).map(e).reduce(function(e,t){return e.concat(t)},[])}(re._tree[0]).map(function(e){for(;e.parent&&!e.parent._hasRegionDescendant&&e.parent.actualNode!==n.body;)e=e.parent;return e}).filter(function(e,t,r){return r.indexOf(e)===t}),re._cache.set("regionlessNodes",u),!u.includes(r)}},{id:"skip-link",evaluate:function(e){var t=re.commons.dom.getElementByReference(e,"href");return!!t&&(re.commons.dom.isVisible(t,!0)||void 0)}},{id:"unique-frame-title",evaluate:function(e){var t=re.commons.text.sanitize(e.title).trim().toLowerCase();return this.data(t),!0},after:function(e){var t={};return e.forEach(function(e){t[e.data]=void 0!==t[e.data]?++t[e.data]:0}),e.forEach(function(e){e.result=!!t[e.data]}),e}},{id:"duplicate-id-active",evaluate:function(e){var t=e.getAttribute("id").trim();if(!t)return!0;var r=re.commons.dom.getRootNode(e),n=Array.from(r.querySelectorAll(\'[id="\'.concat(re.utils.escapeSelector(t),\'"]\'))).filter(function(t){return t!==e});return n.length&&this.relatedNodes(n),this.data(t),0===n.length},after:function(e){var t=[];return e.filter(function(e){return-1===t.indexOf(e.data)&&(t.push(e.data),!0)})}},{id:"duplicate-id-aria",evaluate:function(e){var t=e.getAttribute("id").trim();if(!t)return!0;var r=re.commons.dom.getRootNode(e),n=Array.from(r.querySelectorAll(\'[id="\'.concat(re.utils.escapeSelector(t),\'"]\'))).filter(function(t){return t!==e});return n.length&&this.relatedNodes(n),this.data(t),0===n.length},after:function(e){var t=[];return e.filter(function(e){return-1===t.indexOf(e.data)&&(t.push(e.data),!0)})}},{id:"duplicate-id",evaluate:function(e){var t=e.getAttribute("id").trim();if(!t)return!0;var r=re.commons.dom.getRootNode(e),n=Array.from(r.querySelectorAll(\'[id="\'.concat(re.utils.escapeSelector(t),\'"]\'))).filter(function(t){return t!==e});return n.length&&this.relatedNodes(n),this.data(t),0===n.length},after:function(e){var t=[];return e.filter(function(e){return-1===t.indexOf(e.data)&&(t.push(e.data),!0)})}},{id:"aria-label",evaluate:function(e,t,r){var n=re.commons,a=n.text,o=n.aria;return!!a.sanitize(o.arialabelText(r))}},{id:"aria-labelledby",evaluate:function(e){var t=re.commons,r=t.text,n=t.aria;return!!r.sanitize(n.arialabelledbyText(e))}},{id:"avoid-inline-spacing",evaluate:function(e){var t=["line-height","letter-spacing","word-spacing"].filter(function(t){if("important"===e.style.getPropertyPriority(t))return t});return!(0<t.length&&(this.data(t),1))}},{id:"button-has-visible-text",evaluate:function(e,t,r){var n,a=e.nodeName.toUpperCase(),o=e.getAttribute("role");return("BUTTON"===a||"button"===o&&"INPUT"!==a)&&(n=re.commons.text.accessibleTextVirtual(r),this.data(n),!!n)}},{id:"doc-has-title",evaluate:function(){var e=n.title;return!(!e||!re.commons.text.sanitize(e).trim())}},{id:"exists",evaluate:function(){}},{id:"has-alt",evaluate:function(e,t,r){var n=r.props.nodeName;return!!["img","input","area"].includes(n)&&r.hasAttr("alt")}},{id:"has-visible-text",evaluate:function(e,t,r){return 0<re.commons.text.accessibleTextVirtual(r).length}},{id:"is-on-screen",evaluate:function(e){return re.commons.dom.isVisible(e,!1)&&!re.commons.dom.isOffscreen(e)}},{id:"non-empty-alt",evaluate:function(e,t,r){var n=r.attr("alt");return!(!n||!re.commons.text.sanitize(n).trim())}},{id:"non-empty-if-present",evaluate:function(e){var t=e.nodeName.toUpperCase(),r=(e.getAttribute("type")||"").toLowerCase(),n=e.getAttribute("value");return n&&this.data({messageKey:"has-label"}),!("INPUT"!==t||!["submit","reset"].includes(r))&&null===n}},{id:"non-empty-title",evaluate:function(e){var t=re.commons.text;return!!t.sanitize(t.titleText(e))}},{id:"non-empty-value",evaluate:function(e){var t=e.getAttribute("value");return!(!t||!re.commons.text.sanitize(t).trim())}},{id:"role-none",evaluate:function(e){return"none"===e.getAttribute("role")}},{id:"role-presentation",evaluate:function(e){return"presentation"===e.getAttribute("role")}},{id:"svg-non-empty-title",evaluate:function(e,t,r){var n=r.children.find(function(e){return"title"===e.props.nodeName});return!!n&&""!==n.actualNode.textContent.trim()}},{id:"caption-faked",evaluate:function(e){var t=re.commons.table.toGrid(e),r=t[0];return t.length<=1||r.length<=1||e.rows.length<=1||r.reduce(function(e,t,n){return e||t!==r[n+1]&&void 0!==r[n+1]},!1)}},{id:"has-caption",evaluate:function(e){return!!e.caption},deprecated:!0},{id:"has-summary",evaluate:function(e){return!!e.summary},deprecated:!0},{id:"has-th",evaluate:function(e){for(var t,r,n=[],a=0,o=e.rows.length;a<o;a++)for(var i=0,s=(t=e.rows[a]).cells.length;i<s;i++)"TH"!==(r=t.cells[i]).nodeName.toUpperCase()&&-1===["rowheader","columnheader"].indexOf(r.getAttribute("role"))||n.push(r);return!!n.length&&(this.relatedNodes(n),!0)},deprecated:!0},{id:"html5-scope",evaluate:function(e){return!re.commons.dom.isHTML5(n)||"TH"===e.nodeName.toUpperCase()}},{id:"same-caption-summary",evaluate:function(e){return!(!e.summary||!e.caption)&&e.summary.toLowerCase()===re.commons.text.accessibleText(e.caption).toLowerCase()}},{id:"scope-value",evaluate:function(e){var t=e.getAttribute("scope").toLowerCase();return-1!==["row","col","rowgroup","colgroup"].indexOf(t)}},{id:"td-has-header",evaluate:function(e){var t=re.commons.table,r=[],n=t.getAllCells(e),a=t.toGrid(e);return n.forEach(function(e){re.commons.dom.hasContent(e)&&t.isDataCell(e)&&!re.commons.aria.label(e)&&(t.getHeaders(e,a).some(function(e){return null!==e&&!!re.commons.dom.hasContent(e)})||r.push(e))}),!r.length||(this.relatedNodes(r),!1)}},{id:"td-headers-attr",evaluate:function(e){for(var t=[],r=[],n=[],a=0;a<e.rows.length;a++)for(var o=e.rows[a],i=0;i<o.cells.length;i++)t.push(o.cells[i]);var s=t.reduce(function(e,t){return t.getAttribute("id")&&e.push(t.getAttribute("id")),e},[]);return t.forEach(function(e){var t=!1,a=!1;if(e.hasAttribute("headers")){var o=e.getAttribute("headers").trim();if(!o)return r.push(e);var i=re.utils.tokenList(o);0!==i.length&&(e.getAttribute("id")&&(t=-1!==i.indexOf(e.getAttribute("id").trim())),a=i.some(function(e){return!s.includes(e)}),(t||a)&&n.push(e))}}),0<n.length?(this.relatedNodes(n),!1):!r.length||void this.relatedNodes(r)}},{id:"th-has-data-cells",evaluate:function(e){var t=re.commons.table,r=t.getAllCells(e),n=this,a=[];r.forEach(function(e){var t=e.getAttribute("headers");t&&(a=a.concat(t.split(/\\s+/)));var r=e.getAttribute("aria-labelledby");r&&(a=a.concat(r.split(/\\s+/)))});var o=r.filter(function(e){return""!==re.commons.text.sanitize(e.textContent)&&("TH"===e.nodeName.toUpperCase()||-1!==["rowheader","columnheader"].indexOf(e.getAttribute("role")))}),i=t.toGrid(e),s=!0;return o.forEach(function(e){if(!e.getAttribute("id")||!a.includes(e.getAttribute("id"))){var r=t.getCellPosition(e,i),o=!1;t.isColumnHeader(e)&&(o=t.traverse("down",r,i).find(function(r){return!t.isColumnHeader(r)&&t.getHeaders(r,i).includes(e)})),!o&&t.isRowHeader(e)&&(o=t.traverse("right",r,i).find(function(r){return!t.isRowHeader(r)&&t.getHeaders(r,i).includes(e)})),o||n.relatedNodes(e),s=s&&o}}),!!s||void 0}},{id:"hidden-content",evaluate:function(e,r,n){if(!["SCRIPT","HEAD","TITLE","NOSCRIPT","STYLE","TEMPLATE"].includes(e.nodeName.toUpperCase())&&re.commons.dom.hasContentVirtual(n)){var a=t.getComputedStyle(e);if("none"===a.getPropertyValue("display"))return;if("hidden"===a.getPropertyValue("visibility")){var o=re.commons.dom.getComposedParent(e),i=o&&t.getComputedStyle(o);if(!i||"hidden"!==i.getPropertyValue("visibility"))return}}return!0}}],commons:function(){function e(e){return null===e}function r(e){return null!==e}var o={},i=o.aria={},s=i.lookupTable={};s.attributes={"aria-activedescendant":{type:"idref",allowEmpty:!0,unsupported:!1},"aria-atomic":{type:"boolean",values:["true","false"],unsupported:!1},"aria-autocomplete":{type:"nmtoken",values:["inline","list","both","none"],unsupported:!1},"aria-busy":{type:"boolean",values:["true","false"],unsupported:!1},"aria-checked":{type:"nmtoken",values:["true","false","mixed","undefined"],unsupported:!1},"aria-colcount":{type:"int",unsupported:!1},"aria-colindex":{type:"int",unsupported:!1},"aria-colspan":{type:"int",unsupported:!1},"aria-controls":{type:"idrefs",allowEmpty:!0,unsupported:!1},"aria-current":{type:"nmtoken",allowEmpty:!0,values:["page","step","location","date","time","true","false"],unsupported:!1},"aria-describedby":{type:"idrefs",allowEmpty:!0,unsupported:!1},"aria-describedat":{unsupported:!0,unstandardized:!0},"aria-details":{type:"idref",allowEmpty:!0,unsupported:!1},"aria-disabled":{type:"boolean",values:["true","false"],unsupported:!1},"aria-dropeffect":{type:"nmtokens",values:["copy","move","reference","execute","popup","none"],unsupported:!1},"aria-errormessage":{type:"idref",allowEmpty:!0,unsupported:!1},"aria-expanded":{type:"nmtoken",values:["true","false","undefined"],unsupported:!1},"aria-flowto":{type:"idrefs",allowEmpty:!0,unsupported:!1},"aria-grabbed":{type:"nmtoken",values:["true","false","undefined"],unsupported:!1},"aria-haspopup":{type:"nmtoken",allowEmpty:!0,values:["true","false","menu","listbox","tree","grid","dialog"],unsupported:!1},"aria-hidden":{type:"boolean",values:["true","false"],unsupported:!1},"aria-invalid":{type:"nmtoken",allowEmpty:!0,values:["true","false","spelling","grammar"],unsupported:!1},"aria-keyshortcuts":{type:"string",allowEmpty:!0,unsupported:!1},"aria-label":{type:"string",allowEmpty:!0,unsupported:!1},"aria-labelledby":{type:"idrefs",allowEmpty:!0,unsupported:!1},"aria-level":{type:"int",unsupported:!1},"aria-live":{type:"nmtoken",values:["off","polite","assertive"],unsupported:!1},"aria-modal":{type:"boolean",values:["true","false"],unsupported:!1},"aria-multiline":{type:"boolean",values:["true","false"],unsupported:!1},"aria-multiselectable":{type:"boolean",values:["true","false"],unsupported:!1},"aria-orientation":{type:"nmtoken",values:["horizontal","vertical"],unsupported:!1},"aria-owns":{type:"idrefs",allowEmpty:!0,unsupported:!1},"aria-placeholder":{type:"string",allowEmpty:!0,unsupported:!1},"aria-posinset":{type:"int",unsupported:!1},"aria-pressed":{type:"nmtoken",values:["true","false","mixed","undefined"],unsupported:!1},"aria-readonly":{type:"boolean",values:["true","false"],unsupported:!1},"aria-relevant":{type:"nmtokens",values:["additions","removals","text","all"],unsupported:!1},"aria-required":{type:"boolean",values:["true","false"],unsupported:!1},"aria-roledescription":{type:"string",allowEmpty:!0,unsupported:!1},"aria-rowcount":{type:"int",unsupported:!1},"aria-rowindex":{type:"int",unsupported:!1},"aria-rowspan":{type:"int",unsupported:!1},"aria-selected":{type:"nmtoken",values:["true","false","undefined"],unsupported:!1},"aria-setsize":{type:"int",unsupported:!1},"aria-sort":{type:"nmtoken",values:["ascending","descending","other","none"],unsupported:!1},"aria-valuemax":{type:"decimal",unsupported:!1},"aria-valuemin":{type:"decimal",unsupported:!1},"aria-valuenow":{type:"decimal",unsupported:!1},"aria-valuetext":{type:"string",unsupported:!1}},s.globalAttributes=["aria-atomic","aria-busy","aria-controls","aria-current","aria-describedby","aria-details","aria-disabled","aria-dropeffect","aria-flowto","aria-grabbed","aria-haspopup","aria-hidden","aria-invalid","aria-keyshortcuts","aria-label","aria-labelledby","aria-live","aria-owns","aria-relevant","aria-roledescription"],s.role={alert:{type:"widget",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},alertdialog:{type:"widget",attributes:{allowed:["aria-expanded","aria-modal","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,unsupported:!1,allowedElements:["dialog","section"]},application:{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,unsupported:!1,allowedElements:["article","audio","embed","iframe","object","section","svg","video"]},article:{type:"structure",attributes:{allowed:["aria-expanded","aria-posinset","aria-setsize","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["article"],unsupported:!1},banner:{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["header"],unsupported:!1,allowedElements:["section"]},button:{type:"widget",attributes:{allowed:["aria-expanded","aria-pressed","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:null,implicit:["button",\'input[type="button"]\',\'input[type="image"]\',\'input[type="reset"]\',\'input[type="submit"]\',"summary"],unsupported:!1,allowedElements:[{nodeName:"a",attributes:{href:r}}]},cell:{type:"structure",attributes:{allowed:["aria-colindex","aria-colspan","aria-rowindex","aria-rowspan","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:["row"],implicit:["td","th"],unsupported:!1},checkbox:{type:"widget",attributes:{allowed:["aria-checked","aria-required","aria-readonly","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:null,implicit:[\'input[type="checkbox"]\'],unsupported:!1,allowedElements:["button"]},columnheader:{type:"structure",attributes:{allowed:["aria-colindex","aria-colspan","aria-expanded","aria-rowindex","aria-rowspan","aria-required","aria-readonly","aria-selected","aria-sort","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:["row"],implicit:["th"],unsupported:!1},combobox:{type:"composite",attributes:{allowed:["aria-autocomplete","aria-required","aria-activedescendant","aria-orientation","aria-errormessage"],required:["aria-expanded"]},owned:{all:["listbox","tree","grid","dialog","textbox"]},nameFrom:["author"],context:null,unsupported:!1,allowedElements:[{nodeName:"input",properties:{type:["text","search","tel","url","email"]}}]},command:{nameFrom:["author"],type:"abstract",unsupported:!1},complementary:{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["aside"],unsupported:!1,allowedElements:["section"]},composite:{nameFrom:["author"],type:"abstract",unsupported:!1},contentinfo:{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["footer"],unsupported:!1,allowedElements:["section"]},definition:{type:"structure",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["dd","dfn"],unsupported:!1},dialog:{type:"widget",attributes:{allowed:["aria-expanded","aria-modal","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["dialog"],unsupported:!1,allowedElements:["section"]},directory:{type:"structure",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:null,unsupported:!1,allowedElements:["ol","ul"]},document:{type:"structure",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["body"],unsupported:!1,allowedElements:["article","embed","iframe","object","section","svg"]},"doc-abstract":{type:"section",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-acknowledgments":{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-afterword":{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-appendix":{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-backlink":{type:"link",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:null,unsupported:!1,allowedElements:[{nodeName:"a",attributes:{href:r}}]},"doc-biblioentry":{type:"listitem",attributes:{allowed:["aria-expanded","aria-level","aria-posinset","aria-setsize","aria-errormessage"]},owned:null,nameFrom:["author"],context:["doc-bibliography"],unsupported:!1,allowedElements:["li"]},"doc-bibliography":{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:{one:["doc-biblioentry"]},nameFrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-biblioref":{type:"link",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:null,unsupported:!1,allowedElements:[{nodeName:"a",attributes:{href:r}}]},"doc-chapter":{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-colophon":{type:"section",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-conclusion":{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-cover":{type:"img",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1},"doc-credit":{type:"section",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-credits":{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-dedication":{type:"section",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-endnote":{type:"listitem",attributes:{allowed:["aria-expanded","aria-level","aria-posinset","aria-setsize","aria-errormessage"]},owned:null,namefrom:["author"],context:["doc-endnotes"],unsupported:!1,allowedElements:["li"]},"doc-endnotes":{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:{one:["doc-endnote"]},namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-epigraph":{type:"section",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1},"doc-epilogue":{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-errata":{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-example":{type:"section",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["aside","section"]},"doc-footnote":{type:"section",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["aside","footer","header"]},"doc-foreword":{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-glossary":{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:["term","definition"],namefrom:["author"],context:null,unsupported:!1,allowedElements:["dl"]},"doc-glossref":{type:"link",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author","contents"],context:null,unsupported:!1,allowedElements:[{nodeName:"a",attributes:{href:r}}]},"doc-index":{type:"navigation",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["nav","section"]},"doc-introduction":{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-noteref":{type:"link",attributes:{allowed:["aria-expanded"]},owned:null,namefrom:["author","contents"],context:null,unsupported:!1,allowedElements:[{nodeName:"a",attributes:{href:r}}]},"doc-notice":{type:"note",attributes:{allowed:["aria-expanded"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-pagebreak":{type:"separator",attributes:{allowed:["aria-expanded"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["hr"]},"doc-pagelist":{type:"navigation",attributes:{allowed:["aria-expanded"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["nav","section"]},"doc-part":{type:"landmark",attributes:{allowed:["aria-expanded"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-preface":{type:"landmark",attributes:{allowed:["aria-expanded"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-prologue":{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-pullquote":{type:"none",attributes:{allowed:["aria-expanded"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["aside","section"]},"doc-qna":{type:"section",attributes:{allowed:["aria-expanded"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-subtitle":{type:"sectionhead",attributes:{allowed:["aria-expanded"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:{nodeName:["h1","h2","h3","h4","h5","h6"]}},"doc-tip":{type:"note",attributes:{allowed:["aria-expanded"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["aside"]},"doc-toc":{type:"navigation",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["nav","section"]},feed:{type:"structure",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:{one:["article"]},nameFrom:["author"],context:null,unsupported:!1,allowedElements:["article","aside","section"]},figure:{type:"structure",unsupported:!1},form:{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["form"],unsupported:!1},grid:{type:"composite",attributes:{allowed:["aria-activedescendant","aria-expanded","aria-colcount","aria-level","aria-multiselectable","aria-readonly","aria-rowcount","aria-errormessage"]},owned:{one:["rowgroup","row"]},nameFrom:["author"],context:null,implicit:["table"],unsupported:!1},gridcell:{type:"widget",attributes:{allowed:["aria-colindex","aria-colspan","aria-expanded","aria-rowindex","aria-rowspan","aria-selected","aria-readonly","aria-required","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:["row"],implicit:["td","th"],unsupported:!1},group:{type:"structure",attributes:{allowed:["aria-activedescendant","aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["details","optgroup"],unsupported:!1,allowedElements:["dl","figcaption","fieldset","figure","footer","header","ol","ul"]},heading:{type:"structure",attributes:{required:["aria-level"],allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:null,implicit:["h1","h2","h3","h4","h5","h6"],unsupported:!1},img:{type:"structure",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["img"],unsupported:!1,allowedElements:["embed","iframe","object","svg"]},input:{nameFrom:["author"],type:"abstract",unsupported:!1},landmark:{nameFrom:["author"],type:"abstract",unsupported:!1},link:{type:"widget",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:null,implicit:["a[href]"],unsupported:!1,allowedElements:["button",{nodeName:"input",properties:{type:["image","button"]}}]},list:{type:"structure",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:{all:["listitem"]},nameFrom:["author"],context:null,implicit:["ol","ul","dl"],unsupported:!1},listbox:{type:"composite",attributes:{allowed:["aria-activedescendant","aria-multiselectable","aria-readonly","aria-required","aria-expanded","aria-orientation","aria-errormessage"]},owned:{all:["option"]},nameFrom:["author"],context:null,implicit:["select"],unsupported:!1,allowedElements:["ol","ul"]},listitem:{type:"structure",attributes:{allowed:["aria-level","aria-posinset","aria-setsize","aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:["list"],implicit:["li","dt"],unsupported:!1},log:{type:"widget",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},main:{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["main"],unsupported:!1,allowedElements:["article","section"]},marquee:{type:"widget",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},math:{type:"structure",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["math"],unsupported:!1},menu:{type:"composite",attributes:{allowed:["aria-activedescendant","aria-expanded","aria-orientation","aria-errormessage"]},owned:{one:["menuitem","menuitemradio","menuitemcheckbox"]},nameFrom:["author"],context:null,implicit:[\'menu[type="context"]\'],unsupported:!1,allowedElements:["ol","ul"]},menubar:{type:"composite",attributes:{allowed:["aria-activedescendant","aria-expanded","aria-orientation","aria-errormessage"]},owned:{one:["menuitem","menuitemradio","menuitemcheckbox"]},nameFrom:["author"],context:null,unsupported:!1,allowedElements:["ol","ul"]},menuitem:{type:"widget",attributes:{allowed:["aria-posinset","aria-setsize","aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:["menu","menubar"],implicit:[\'menuitem[type="command"]\'],unsupported:!1,allowedElements:["button","li",{nodeName:"iput",properties:{type:["image","button"]}},{nodeName:"a",attributes:{href:r}}]},menuitemcheckbox:{type:"widget",attributes:{allowed:["aria-checked","aria-posinset","aria-setsize","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:["menu","menubar"],implicit:[\'menuitem[type="checkbox"]\'],unsupported:!1,allowedElements:[{nodeName:["button","li"]},{nodeName:"input",properties:{type:["checkbox","image","button"]}},{nodeName:"a",attributes:{href:r}}]},menuitemradio:{type:"widget",attributes:{allowed:["aria-checked","aria-selected","aria-posinset","aria-setsize","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:["menu","menubar"],implicit:[\'menuitem[type="radio"]\'],unsupported:!1,allowedElements:[{nodeName:["button","li"]},{nodeName:"input",properties:{type:["image","button","radio"]}},{nodeName:"a",attributes:{href:r}}]},navigation:{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["nav"],unsupported:!1,allowedElements:["section"]},none:{type:"structure",attributes:null,owned:null,nameFrom:["author"],context:null,unsupported:!1,allowedElements:[{nodeName:["article","aside","dl","embed","figcaption","fieldset","figure","footer","form","h1","h2","h3","h4","h5","h6","header","iframe","li","ol","section","ul"]},{nodeName:"img",attributes:{alt:r}}]},note:{type:"structure",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,unsupported:!1,allowedElements:["aside"]},option:{type:"widget",attributes:{allowed:["aria-selected","aria-posinset","aria-setsize","aria-checked","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:["listbox"],implicit:["option"],unsupported:!1,allowedElements:[{nodeName:["button","li"]},{nodeName:"input",properties:{type:["checkbox","button"]}},{nodeName:"a",attributes:{href:r}}]},presentation:{type:"structure",attributes:null,owned:null,nameFrom:["author"],context:null,unsupported:!1,allowedElements:[{nodeName:["article","aside","dl","embed","figcaption","fieldset","figure","footer","form","h1","h2","h3","h4","h5","h6","header","iframe","li","ol","section","ul"]},{nodeName:"img",attributes:{alt:r}}]},progressbar:{type:"widget",attributes:{allowed:["aria-valuetext","aria-valuenow","aria-valuemax","aria-valuemin","aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["progress"],unsupported:!1},radio:{type:"widget",attributes:{allowed:["aria-selected","aria-posinset","aria-setsize","aria-required","aria-errormessage","aria-checked"]},owned:null,nameFrom:["author","contents"],context:null,implicit:[\'input[type="radio"]\'],unsupported:!1,allowedElements:[{nodeName:["button","li"]},{nodeName:"input",properties:{type:["image","button"]}}]},radiogroup:{type:"composite",attributes:{allowed:["aria-activedescendant","aria-required","aria-expanded","aria-readonly","aria-errormessage"]},owned:{all:["radio"]},nameFrom:["author"],context:null,unsupported:!1,allowedElements:{nodeName:["ol","ul"]}},range:{nameFrom:["author"],type:"abstract",unsupported:!1},region:{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["section[aria-label]","section[aria-labelledby]","section[title]"],unsupported:!1,allowedElements:{nodeName:["article","aside"]}},roletype:{type:"abstract",unsupported:!1},row:{type:"structure",attributes:{allowed:["aria-activedescendant","aria-colindex","aria-expanded","aria-level","aria-selected","aria-rowindex","aria-errormessage"]},owned:{one:["cell","columnheader","rowheader","gridcell"]},nameFrom:["author","contents"],context:["rowgroup","grid","treegrid","table"],implicit:["tr"],unsupported:!1},rowgroup:{type:"structure",attributes:{allowed:["aria-activedescendant","aria-expanded","aria-errormessage"]},owned:{all:["row"]},nameFrom:["author","contents"],context:["grid","table","treegrid"],implicit:["tbody","thead","tfoot"],unsupported:!1},rowheader:{type:"structure",attributes:{allowed:["aria-colindex","aria-colspan","aria-expanded","aria-rowindex","aria-rowspan","aria-required","aria-readonly","aria-selected","aria-sort","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:["row"],implicit:["th"],unsupported:!1},scrollbar:{type:"widget",attributes:{required:["aria-controls","aria-valuenow"],allowed:["aria-valuetext","aria-orientation","aria-errormessage","aria-valuemax","aria-valuemin"]},owned:null,nameFrom:["author"],context:null,unsupported:!1},search:{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,unsupported:!1,allowedElements:{nodeName:["aside","form","section"]}},searchbox:{type:"widget",attributes:{allowed:["aria-activedescendant","aria-autocomplete","aria-multiline","aria-readonly","aria-required","aria-placeholder","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:[\'input[type="search"]\'],unsupported:!1,allowedElements:{nodeName:"input",properties:{type:"text"}}},section:{nameFrom:["author","contents"],type:"abstract",unsupported:!1},sectionhead:{nameFrom:["author","contents"],type:"abstract",unsupported:!1},select:{nameFrom:["author"],type:"abstract",unsupported:!1},separator:{type:"structure",attributes:{allowed:["aria-expanded","aria-orientation","aria-valuenow","aria-valuemax","aria-valuemin","aria-valuetext","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["hr"],unsupported:!1,allowedElements:["li"]},slider:{type:"widget",attributes:{allowed:["aria-valuetext","aria-orientation","aria-readonly","aria-errormessage","aria-valuemax","aria-valuemin"],required:["aria-valuenow"]},owned:null,nameFrom:["author"],context:null,implicit:[\'input[type="range"]\'],unsupported:!1},spinbutton:{type:"widget",attributes:{allowed:["aria-valuetext","aria-required","aria-readonly","aria-errormessage","aria-valuemax","aria-valuemin"],required:["aria-valuenow"]},owned:null,nameFrom:["author"],context:null,implicit:[\'input[type="number"]\'],unsupported:!1,allowedElements:{nodeName:"input",properties:{type:["text","tel"]}}},status:{type:"widget",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["output"],unsupported:!1,allowedElements:["section"]},structure:{type:"abstract",unsupported:!1},switch:{type:"widget",attributes:{allowed:["aria-errormessage"],required:["aria-checked"]},owned:null,nameFrom:["author","contents"],context:null,unsupported:!1,allowedElements:["button",{nodeName:"input",properties:{type:["checkbox","image","button"]}},{nodeName:"a",attributes:{href:r}}]},tab:{type:"widget",attributes:{allowed:["aria-selected","aria-expanded","aria-setsize","aria-posinset","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:["tablist"],unsupported:!1,allowedElements:[{nodeName:["button","h1","h2","h3","h4","h5","h6","li"]},{nodeName:"input",properties:{type:"button"}},{nodeName:"a",attributes:{href:r}}]},table:{type:"structure",attributes:{allowed:["aria-colcount","aria-rowcount","aria-errormessage"]},owned:{one:["rowgroup","row"]},nameFrom:["author"],context:null,implicit:["table"],unsupported:!1},tablist:{type:"composite",attributes:{allowed:["aria-activedescendant","aria-expanded","aria-level","aria-multiselectable","aria-orientation","aria-errormessage"]},owned:{all:["tab"]},nameFrom:["author"],context:null,unsupported:!1,allowedElements:["ol","ul"]},tabpanel:{type:"widget",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},term:{type:"structure",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:null,implicit:["dt"],unsupported:!1},textbox:{type:"widget",attributes:{allowed:["aria-activedescendant","aria-autocomplete","aria-multiline","aria-readonly","aria-required","aria-placeholder","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:[\'input[type="text"]\',\'input[type="email"]\',\'input[type="password"]\',\'input[type="tel"]\',\'input[type="url"]\',"input:not([type])","textarea"],unsupported:!1},timer:{type:"widget",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,unsupported:!1},toolbar:{type:"structure",attributes:{allowed:["aria-activedescendant","aria-expanded","aria-orientation","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:[\'menu[type="toolbar"]\'],unsupported:!1,allowedElements:["ol","ul"]},tooltip:{type:"structure",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:null,unsupported:!1},tree:{type:"composite",attributes:{allowed:["aria-activedescendant","aria-multiselectable","aria-required","aria-expanded","aria-orientation","aria-errormessage"]},owned:{all:["treeitem"]},nameFrom:["author"],context:null,unsupported:!1,allowedElements:["ol","ul"]},treegrid:{type:"composite",attributes:{allowed:["aria-activedescendant","aria-colcount","aria-expanded","aria-level","aria-multiselectable","aria-readonly","aria-required","aria-rowcount","aria-orientation","aria-errormessage"]},owned:{one:["rowgroup","row"]},nameFrom:["author"],context:null,unsupported:!1},treeitem:{type:"widget",attributes:{allowed:["aria-checked","aria-selected","aria-expanded","aria-level","aria-posinset","aria-setsize","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:["group","tree"],unsupported:!1,allowedElements:["li",{nodeName:"a",attributes:{href:r}}]},widget:{type:"abstract",unsupported:!1},window:{nameFrom:["author"],type:"abstract",unsupported:!1}},s.elementsAllowedNoRole=[{nodeName:["base","body","caption","col","colgroup","datalist","dd","details","dt","head","html","keygen","label","legend","main","map","math","meta","meter","noscript","optgroup","param","picture","progress","script","source","style","template","textarea","title","track"]},{nodeName:"area",attributes:{href:r}},{nodeName:"input",properties:{type:["color","data","datatime","file","hidden","month","number","password","range","reset","submit","time","week"]}},{nodeName:"link",attributes:{href:r}},{nodeName:"menu",attributes:{type:"context"}},{nodeName:"menuitem",attributes:{type:["command","checkbox","radio"]}},{nodeName:"select",condition:function(e){return e instanceof re.AbstractVirtualNode||(e=re.utils.getNodeFromTree(e)),1<Number(e.attr("size"))},properties:{multiple:!0}},{nodeName:["clippath","cursor","defs","desc","feblend","fecolormatrix","fecomponenttransfer","fecomposite","feconvolvematrix","fediffuselighting","fedisplacementmap","fedistantlight","fedropshadow","feflood","fefunca","fefuncb","fefuncg","fefuncr","fegaussianblur","feimage","femerge","femergenode","femorphology","feoffset","fepointlight","fespecularlighting","fespotlight","fetile","feturbulence","filter","hatch","hatchpath","lineargradient","marker","mask","meshgradient","meshpatch","meshrow","metadata","mpath","pattern","radialgradient","solidcolor","stop","switch","view"]}],s.elementsAllowedAnyRole=[{nodeName:"a",attributes:{href:e}},{nodeName:"img",attributes:{alt:e}},{nodeName:["abbr","address","canvas","div","p","pre","blockquote","ins","del","output","span","table","tbody","thead","tfoot","td","em","strong","small","s","cite","q","dfn","abbr","time","code","var","samp","kbd","sub","sup","i","b","u","mark","ruby","rt","rp","bdi","bdo","br","wbr","th","tr"]}],s.evaluateRoleForElement={A:function(e){var t=e.node,r=e.out;return"http://www.w3.org/2000/svg"===t.namespaceURI||!t.href.length||r},AREA:function(e){return!e.node.href},BUTTON:function(e){var t=e.node,r=e.role,n=e.out;return"menu"===t.getAttribute("type")?"menuitem"===r:n},IMG:function(e){var t=e.node,r=e.role,n=e.out;switch(t.alt){case null:return n;case"":return"presentation"===r||"none"===r;default:return"presentation"!==r&&"none"!==r}},INPUT:function(e){var t=e.node,r=e.role,n=e.out;switch(t.type){case"button":case"image":return n;case"checkbox":return!("button"!==r||!t.hasAttribute("aria-pressed"))||n;case"radio":return"menuitemradio"===r;case"text":return"combobox"===r||"searchbox"===r||"spinbutton"===r;case"tel":return"combobox"===r||"spinbutton"===r;case"url":case"search":case"email":return"combobox"===r;default:return!1}},LI:function(e){var t=e.node,r=e.out;return!re.utils.matchesSelector(t,"ol li, ul li")||r},MENU:function(e){return"context"!==e.node.getAttribute("type")},OPTION:function(e){var t=e.node;return!re.utils.matchesSelector(t,"select > option, datalist > option, optgroup > option")},SELECT:function(e){var t=e.node,r=e.role;return!t.multiple&&t.size<=1&&"menu"===r},SVG:function(e){var t=e.node,r=e.out;return!(!t.parentNode||"http://www.w3.org/2000/svg"!==t.parentNode.namespaceURI)||r}},s.rolesOfType={widget:["button","checkbox","dialog","gridcell","link","log","marquee","menuitem","menuitemcheckbox","menuitemradio","option","progressbar","radio","scrollbar","searchbox","slider","spinbutton","status","switch","tab","tabpanel","textbox","timer","tooltip","tree","treeitem"]};var u={};o.color=u;var c=o.dom={},d={};function p(e,t){return p.fromDefinition(e,t)}o.forms=d,o.matches=p;var m=o.table={},f=o.text={EdgeFormDefaults:{}};o.utils=re.utils,i.arialabelText=function(e){if(e instanceof re.AbstractVirtualNode==0){if(1!==e.nodeType)return"";e=re.utils.getNodeFromTree(e)}return e.attr("aria-label")||""},i.arialabelledbyText=function(e,t){var r=1<arguments.length&&void 0!==t?t:{};return 1!==(e=e.actualNode||e).nodeType||r.inLabelledByContext||r.inControlContext?"":c.idrefs(e,"aria-labelledby").filter(function(e){return e}).reduce(function(t,n){var a=f.accessibleText(n,l({inLabelledByContext:!0,startNode:r.startNode||e},r));return t?"".concat(t," ").concat(a):a},"")},i.requiredAttr=function(e){var t=i.lookupTable.role[e];return t&&t.attributes&&t.attributes.required||[]},i.allowedAttr=function(e){var t=i.lookupTable.role[e],r=t&&t.attributes&&t.attributes.allowed||[],n=t&&t.attributes&&t.attributes.required||[];return r.concat(i.lookupTable.globalAttributes).concat(n)},i.validateAttr=function(e){return!!i.lookupTable.attributes[e]};var h=["doc-backlink","doc-biblioentry","doc-biblioref","doc-cover","doc-endnote","doc-glossref","doc-noteref"];i.getElementUnallowedRoles=function(e,t){var r=!(1<arguments.length&&void 0!==t)||t,n=e.nodeName.toUpperCase();if(!re.utils.isHtmlElement(e))return[];var a=function(e){var t=[];if(!e)return t;if(e.hasAttribute("role")){var r=re.utils.tokenList(e.getAttribute("role").toLowerCase());t=t.concat(r)}if(e.hasAttributeNS("http://www.idpf.org/2007/ops","type")){var n=re.utils.tokenList(e.getAttributeNS("http://www.idpf.org/2007/ops","type").toLowerCase()).map(function(e){return"doc-".concat(e)});t=t.concat(n)}return t.filter(function(e){return re.commons.aria.isValidRole(e)})}(e),o=re.commons.aria.implicitRole(e);return a.filter(function(t){if(r&&t===o)return!1;if(r&&h.includes(t)){var a=re.commons.aria.getRoleType(t);if(o!==a)return!0}return!(r||"row"===t&&"TR"===n&&re.utils.matchesSelector(e,\'table[role="grid"] > tr\'))||!i.isAriaRoleAllowedOnElement(e,t)})},i.getOwnedVirtual=function(e){var t=e.actualNode,r=e.children;if(!t||!r)throw new Error("getOwnedVirtual requires a virtual node");return c.idrefs(t,"aria-owns").reduce(function(e,t){if(t){var r=re.utils.getNodeFromTree(t);e.push(r)}return e},r)},i.getRole=function(e,t){var r=1<arguments.length&&void 0!==t?t:{},n=r.noImplicit,a=r.fallback,o=r.abstracts,s=r.dpub;if(1!==(e=e.actualNode||e).nodeType)return null;var l=(e.getAttribute("role")||"").trim().toLowerCase(),u=(a?re.utils.tokenList(l):[l]).filter(function(e){return!(!s&&"doc-"===e.substr(0,4))&&i.isValidRole(e,{allowAbstract:o})})[0];return u||n?u||null:i.implicitRole(e)};var b,g=/^idrefs?$/;function y(e){return e.getPropertyValue("font-family").split(/[,;]/g).map(function(e){return e.trim().toLowerCase()})}function v(e,t){var r=e.getClientRects()[0],n=c.shadowElementsFromPoint(r.left,r.top);if(n)for(var a=0;a<n.length;a++)if(n[a]!==e&&n[a]===t)return 1}i.isAccessibleRef=function(e){e=e.actualNode||e;var t=c.getRootNode(e);t=t.documentElement||t;var r=e.id;return re._cache.get("idRefs")||(re._cache.set("idRefs",{}),function e(t,r){if(t.hasAttribute){var n=re._cache.get("idRefs");"LABEL"===t.nodeName.toUpperCase()&&t.hasAttribute("for")&&(n[t.getAttribute("for")]=!0);for(var a=0;a<r.length;++a){var o=r[a];if(t.hasAttribute(o))for(var i=t.getAttribute(o),s=re.utils.tokenList(i),l=0;l<s.length;++l)n[s[l]]=!0}}for(var u=0;u<t.children.length;u++)e(t.children[u],r)}(t,Object.keys(i.lookupTable.attributes).filter(function(e){var t=i.lookupTable.attributes[e].type;return g.test(t)}))),!0===re._cache.get("idRefs")[r]},i.isAriaRoleAllowedOnElement=function(e,t){var r=e.nodeName.toUpperCase(),n=re.commons.aria.lookupTable;if(p(e,n.elementsAllowedNoRole))return!1;if(p(e,n.elementsAllowedAnyRole))return!0;var a=n.role[t];if(!a||!a.allowedElements)return!1;var o=p(e,a.allowedElements);return Object.keys(n.evaluateRoleForElement).includes(r)?n.evaluateRoleForElement[r]({node:e,role:t,out:o}):o},i.isUnsupportedRole=function(e){var t=i.lookupTable.role[e];return!!t&&t.unsupported},i.labelVirtual=function(e){var t,r=e.actualNode;return r.getAttribute("aria-labelledby")&&(t=c.idrefs(r,"aria-labelledby").map(function(e){var t=re.utils.getNodeFromTree(e);return t?f.visibleVirtual(t,!0):""}).join(" ").trim())||(t=(t=r.getAttribute("aria-label"))&&f.sanitize(t).trim())?t:null},i.label=function(e){return e=re.utils.getNodeFromTree(e),i.labelVirtual(e)},i.namedFromContents=function(e,t){var r=(1<arguments.length&&void 0!==t?t:{}).strict;if(1!==(e=e.actualNode||e).nodeType)return!1;var n=i.getRole(e),a=i.lookupTable.role[n];return!!(a&&a.nameFrom.includes("contents")||"TABLE"===e.nodeName.toUpperCase())||!r&&(!a||["presentation","none"].includes(n))},i.isValidRole=function(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},r=t.allowAbstract,n=t.flagUnsupported,a=void 0!==n&&n,o=i.lookupTable.role[e],s=!!o&&o.unsupported;return!(!o||a&&s||!r&&"abstract"===o.type)},i.getRolesWithNameFromContents=function(){return Object.keys(i.lookupTable.role).filter(function(e){return i.lookupTable.role[e].nameFrom&&-1!==i.lookupTable.role[e].nameFrom.indexOf("contents")})},i.getRolesByType=function(e){return Object.keys(i.lookupTable.role).filter(function(t){return i.lookupTable.role[t].type===e})},i.getRoleType=function(e){var t=i.lookupTable.role[e];return t&&t.type||null},i.requiredOwned=function(e){"use strict";var t=null,r=i.lookupTable.role[e];return r&&(t=re.utils.clone(r.owned)),t},i.requiredContext=function(e){"use strict";var t=null,r=i.lookupTable.role[e];return r&&(t=re.utils.clone(r.context)),t},i.implicitNodes=function(e){"use strict";var t=null,r=i.lookupTable.role[e];return r&&r.implicit&&(t=re.utils.clone(r.implicit)),t},i.implicitRole=function(e){"use strict";var t=Object.keys(i.lookupTable.role).map(function(e){var t=i.lookupTable.role[e];return{name:e,implicit:t&&t.implicit}}).reduce(function(t,r){return r.implicit&&r.implicit.some(function(t){return re.utils.matchesSelector(e,t)})&&t.push(r.name),t},[]);if(!t.length)return null;for(var r,n=re.utils.getNodeAttributes(e),a=[],o=0,s=n.length;o<s;o++){var l=n[o];l.name.match(/^aria-/)&&a.push(l.name)}return r=a,t.map(function(e){return{score:(t=e,i.allowedAttr(t).reduce(function(e,t){return e+(-1<r.indexOf(t)?1:0)},0)),name:e};var t}).sort(function(e,t){return t.score-e.score}).map(function(e){return e.name}).shift()},i.validateAttrValue=function(e,t){"use strict";var r,n,a=e.getAttribute(t),o=i.lookupTable.attributes[t],s=c.getRootNode(e);if(!o)return!0;if(o.allowEmpty&&(!a||""===a.trim()))return!0;switch(o.type){case"boolean":case"nmtoken":return"string"==typeof a&&o.values.includes(a.toLowerCase());case"nmtokens":return(n=re.utils.tokenList(a)).reduce(function(e,t){return e&&o.values.includes(t)},0!==n.length);case"idref":return!(!a||!s.getElementById(a));case"idrefs":return(n=re.utils.tokenList(a)).some(function(e){return s.getElementById(e)});case"string":return""!==a.trim();case"decimal":return!(!(r=a.match(/^[-+]?([0-9]*)\\.?([0-9]*)$/))||!r[1]&&!r[2]);case"int":return/^[-+]?[0-9]+$/.test(a)}},u.centerPointOfRect=function(e){if(!(e.left>t.innerWidth||e.top>t.innerHeight))return{x:Math.min(Math.ceil(e.left+e.width/2),t.innerWidth-1),y:Math.min(Math.ceil(e.top+e.height/2),t.innerHeight-1)}},u.Color=function(e,t,r,n){this.red=e,this.green=t,this.blue=r,this.alpha=n,this.toHexString=function(){var e=Math.round(this.red).toString(16),t=Math.round(this.green).toString(16),r=Math.round(this.blue).toString(16);return"#"+(15.5<this.red?e:"0"+e)+(15.5<this.green?t:"0"+t)+(15.5<this.blue?r:"0"+r)};var a=/^rgb\\((\\d+), (\\d+), (\\d+)\\)$/,o=/^rgba\\((\\d+), (\\d+), (\\d+), (\\d*(\\.\\d+)?)\\)/;this.parseRgbString=function(e){if("transparent"===e)return this.red=0,this.green=0,this.blue=0,void(this.alpha=0);var t=e.match(a);return t?(this.red=parseInt(t[1],10),this.green=parseInt(t[2],10),this.blue=parseInt(t[3],10),void(this.alpha=1)):(t=e.match(o))?(this.red=parseInt(t[1],10),this.green=parseInt(t[2],10),this.blue=parseInt(t[3],10),void(this.alpha=Math.round(100*parseFloat(t[4]))/100)):void 0},this.getRelativeLuminance=function(){var e=this.red/255,t=this.green/255,r=this.blue/255;return.2126*(e<=.03928?e/12.92:Math.pow((.055+e)/1.055,2.4))+.7152*(t<=.03928?t/12.92:Math.pow((.055+t)/1.055,2.4))+.0722*(r<=.03928?r/12.92:Math.pow((.055+r)/1.055,2.4))}},u.flattenColors=function(e,t){var r=e.alpha,n=(1-r)*t.red+r*e.red,a=(1-r)*t.green+r*e.green,o=(1-r)*t.blue+r*e.blue,i=e.alpha+t.alpha*(1-e.alpha);return new u.Color(n,a,o,i)},u.getContrast=function(e,t){if(!t||!e)return null;t.alpha<1&&(t=u.flattenColors(t,e));var r=e.getRelativeLuminance(),n=t.getRelativeLuminance();return(Math.max(n,r)+.05)/(Math.min(n,r)+.05)},u.hasValidContrastRatio=function(e,t,r,n){var a=u.getContrast(e,t),o=n&&Math.ceil(72*r)/96<14||!n&&Math.ceil(72*r)/96<18?4.5:3;return{isValid:o<a,contrastRatio:a,expectedContrastRatio:o}},u.elementHasImage=function(e,r){var n=e.nodeName.toUpperCase();if(["IMG","CANVAS","OBJECT","IFRAME","VIDEO","SVG"].includes(n))return re.commons.color.incompleteData.set("bgColor","imgNode"),!0;var a=(r=r||t.getComputedStyle(e)).getPropertyValue("background-image"),o="none"!==a;if(o){var i=/gradient/.test(a);re.commons.color.incompleteData.set("bgColor",i?"bgGradient":"bgImage")}return o},u.elementIsDistinct=function(e,r){var n=t.getComputedStyle(e);if("none"!==n.getPropertyValue("background-image"))return!0;if(["border-bottom","border-top","outline"].reduce(function(e,t){var r=new u.Color;return r.parseRgbString(n.getPropertyValue(t+"-color")),e||"none"!==n.getPropertyValue(t+"-style")&&0<parseFloat(n.getPropertyValue(t+"-width"))&&0!==r.alpha},!1))return!0;var a=t.getComputedStyle(r);if(y(n)[0]!==y(a)[0])return!0;var o=["text-decoration-line","text-decoration-style","font-weight","font-style","font-size"].reduce(function(e,t){return e||n.getPropertyValue(t)!==a.getPropertyValue(t)},!1),i=n.getPropertyValue("text-decoration");return i.split(" ").length<3&&(o=o||i!==a.getPropertyValue("text-decoration")),o},u.getBackgroundColor=function(e,r){var n=1<arguments.length&&void 0!==r?r:[],a=[],o=u.getBackgroundStack(e);return(o||[]).some(function(r){var o=t.getComputedStyle(r),i=u.getOwnBackgroundColor(o);return function(e,t,r){var n=e!==t&&!c.visuallyContains(e,t)&&0!==r.alpha;return n&&re.commons.color.incompleteData.set("bgColor","elmPartiallyObscured"),n}(e,r,i)||u.elementHasImage(r,o)?(a=null,n.push(r),!0):0!==i.alpha&&(n.push(r),a.push(i),1===i.alpha)}),null===a||null===o?null:(a.push(new u.Color(255,255,255,1)),a.reduce(u.flattenColors))},u.getBackgroundStack=function(e){var r=u.filteredRectStack(e);if(null===r)return null;var a=(r=function(e){var r=e.indexOf(n.body),a=e;return(1<r||-1===r)&&!u.elementHasImage(n.documentElement)&&0===u.getOwnBackgroundColor(t.getComputedStyle(n.documentElement)).alpha&&(1<r&&a.splice(r,1),a.splice(e.indexOf(n.documentElement),1),a.push(n.body)),a}(r=c.reduceToElementsBelowFloating(r,e))).indexOf(e);return function(e,t,r){if(0<e)for(var n=e-1;0<=n;n--){if(v(r,t[n]))return 1;t.splice(n,1)}}(a,r,e)?(re.commons.color.incompleteData.set("bgColor","bgOverlap"),null):-1!==a?r:null},u.filteredRectStack=function(e){var t=u.getRectStack(e);if(t&&1===t.length)return t[0];if(t&&1<t.length){var r,n=t.shift();return t.forEach(function(a,o){if(0!==o){var i=t[o-1],s=t[o];r=i.every(function(e,t){return e===s[t]})||n.includes(e)}}),r?t[0]:(re.commons.color.incompleteData.set("bgColor","elmPartiallyObscuring"),null)}return re.commons.color.incompleteData.set("bgColor","outsideViewport"),null},u.getRectStack=function(e){var t=re.commons.dom.getElementStack(e),r=re.commons.dom.getTextElementStack(e);return!r||r.length<=1?[t]:r.some(function(e){return void 0===e})?null:(r.splice(0,0,t),r)},c.isOpaque=function(e){var r=t.getComputedStyle(e);return u.elementHasImage(e,r)||1===u.getOwnBackgroundColor(r).alpha},u.getForegroundColor=function(e,r,n){var a=t.getComputedStyle(e),o=new u.Color;o.parseRgbString(a.getPropertyValue("color"));var i=function e(r){if(!r)return 1;var n=re.utils.getNodeFromTree(r);if(n&&void 0!==n._opacity&&null!==n._opacity)return n._opacity;var a=t.getComputedStyle(r).getPropertyValue("opacity")*e(r.parentElement);return n&&(n._opacity=a),a}(e);if(o.alpha=o.alpha*i,1===o.alpha)return o;if(null!==(n=n||u.getBackgroundColor(e,[],r)))return u.flattenColors(o,n);var s=re.commons.color.incompleteData.get("bgColor");return re.commons.color.incompleteData.set("fgColor",s),null},u.getOwnBackgroundColor=function(e){var t=new u.Color;if(t.parseRgbString(e.getPropertyValue("background-color")),0!==t.alpha){var r=e.getPropertyValue("opacity");t.alpha=t.alpha*r}return t},u.incompleteData=(b={},{set:function(e,t){if("string"!=typeof e)throw new Error("Incomplete data: key must be a string");return t&&(b[e]=t),b[e]},get:function(e){return b[e]},clear:function(){b={}}}),c.reduceToElementsBelowFloating=function(e,r){var n,a,o,i=["fixed","sticky"],s=[],l=!1;for(n=0;n<e.length;++n)(a=e[n])===r&&(l=!0),o=t.getComputedStyle(a),l||-1===i.indexOf(o.position)?s.push(a):s=[];return s},c.findElmsInContext=function(e){var t,r=e.context,n=e.value,a=e.attr,o=e.elm,i=void 0===o?"":o,s=re.utils.escapeSelector(n);return t=9===r.nodeType||11===r.nodeType?r:c.getRootNode(r),Array.from(t.querySelectorAll(i+"["+a+"="+s+"]"))},c.findUp=function(e,t){return c.findUpVirtual(re.utils.getNodeFromTree(e),t)},c.findUpVirtual=function(e,t){var r;if(r=e.actualNode,!e.shadowId&&"function"==typeof e.actualNode.closest){var a=e.actualNode.closest(t);return a||null}for(;(r=r.assignedSlot?r.assignedSlot:r.parentNode)&&11===r.nodeType&&(r=r.host),r&&!re.utils.matchesSelector(r,t)&&r!==n.documentElement;);return r&&re.utils.matchesSelector(r,t)?r:null},c.getComposedParent=function e(t){if(t.assignedSlot)return e(t.assignedSlot);if(t.parentNode){var r=t.parentNode;if(1===r.nodeType)return r;if(r.host)return r.host}return null},c.getElementByReference=function(e,t){var r=e.getAttribute(t);if(!r)return null;"#"===r.charAt(0)?r=decodeURIComponent(r.substring(1)):"/#"===r.substr(0,2)&&(r=decodeURIComponent(r.substring(2)));var a=n.getElementById(r);return a||((a=n.getElementsByName(r)).length?a[0]:null)},c.getElementCoordinates=function(e){"use strict";var t=c.getScrollOffset(n),r=t.left,a=t.top,o=e.getBoundingClientRect();return{top:o.top+a,right:o.right+r,bottom:o.bottom+a,left:o.left+r,width:o.right-o.left,height:o.bottom-o.top}};var w=200;function x(e){return"static"===e.getComputedStylePropertyValue("position")?-1!==e.getComputedStylePropertyValue("display").indexOf("inline")?2:function e(t){if(!t)return!1;if(void 0!==t._isFloated)return t._isFloated;if("none"!==t.getComputedStylePropertyValue("float"))return t._isFloated=!0;var r=e(t.parent);return t._isFloated=r}(e)?1:0:3}function D(e,r){for(var n=0;n<e._stackingOrder.length;n++){if(void 0===r._stackingOrder[n])return-1;if(r._stackingOrder[n]>e._stackingOrder[n])return 1;if(r._stackingOrder[n]<e._stackingOrder[n])return-1}var a=e.actualNode,o=r.actualNode;if(a.getRootNode&&a.getRootNode()!==o.getRootNode()){for(var i=[];a;)i.push({root:a.getRootNode(),node:a}),a=a.getRootNode().host;for(;o&&!i.find(function(e){return e.root===o.getRootNode()});)o=o.getRootNode().host;if((a=i.find(function(e){return e.root===o.getRootNode()}).node)===o)return e.actualNode.getRootNode()!==a.getRootNode()?-1:1}var s=t.Node,l=s.DOCUMENT_POSITION_FOLLOWING,u=s.DOCUMENT_POSITION_CONTAINS,c=s.DOCUMENT_POSITION_CONTAINED_BY,d=a.compareDocumentPosition(o),p=d&l?1:-1,m=d&u||d&c,f=x(e),h=x(r);return f===h||m?p:h-f}function k(e,t){var r=t._stackingOrder.slice(),n=e.getComputedStylePropertyValue("z-index");return"auto"!==n&&(r[r.length-1]=parseInt(n)),function(e,t){var r=e.getComputedStylePropertyValue("position"),n=e.getComputedStylePropertyValue("z-index");if("fixed"===r||"sticky"===r)return 1;if("auto"!==n&&"static"!==r)return 1;if("1"!==e.getComputedStylePropertyValue("opacity"))return 1;if("none"!==(e.getComputedStylePropertyValue("-webkit-transform")||e.getComputedStylePropertyValue("-ms-transform")||e.getComputedStylePropertyValue("transform")||"none"))return 1;var a=e.getComputedStylePropertyValue("mix-blend-mode");if(a&&"normal"!==a)return 1;var o=e.getComputedStylePropertyValue("filter");if(o&&"none"!==o)return 1;var i=e.getComputedStylePropertyValue("perspective");if(i&&"none"!==i)return 1;var s=e.getComputedStylePropertyValue("clip-path");if(s&&"none"!==s)return 1;if("none"!==(e.getComputedStylePropertyValue("-webkit-mask")||e.getComputedStylePropertyValue("mask")||"none"))return 1;if("none"!==(e.getComputedStylePropertyValue("-webkit-mask-image")||e.getComputedStylePropertyValue("mask-image")||"none"))return 1;if("none"!==(e.getComputedStylePropertyValue("-webkit-mask-border")||e.getComputedStylePropertyValue("mask-border")||"none"))return 1;if("isolate"===e.getComputedStylePropertyValue("isolation"))return 1;var l=e.getComputedStylePropertyValue("will-change");if("transform"===l||"opacity"===l)return 1;if("touch"===e.getComputedStylePropertyValue("-webkit-overflow-scrolling"))return 1;var u=e.getComputedStylePropertyValue("contain");if(["layout","paint","strict","content"].includes(u))return 1;if("auto"!==n&&t){var c=t.getComputedStylePropertyValue("display");if(["flex","inline-flex","inline flex","grid","inline-grid","inline grid"].includes(c))return 1}}(e,t)&&r.push(0),r}function E(e,t){for(var r=null,n=[e];t;){if(t._scrollRegionParent){r=t._scrollRegionParent;break}if(re.utils.getScroll(t.actualNode)){r=t;break}n.push(t),t=re.utils.getNodeFromTree(t.actualNode.parentElement||t.actualNode.parentNode)}return n.forEach(function(e){return e._scrollRegionParent=r}),r}function A(e,t){t._grid=e,t.clientRects.forEach(function(r){for(var n=r.left,a=r.top,o=a/w|0,i=n/w|0,s=(a+r.height)/w|0,l=(n+r.width)/w|0,u=o;u<=s;u++){e.cells[u]=e.cells[u]||[];for(var c=i;c<=l;c++)e.cells[u][c]=e.cells[u][c]||[],e.cells[u][c].includes(t)||e.cells[u][c].push(t)}})}function j(e,r,a){var o=0<arguments.length&&void 0!==e?e:n.body,i=1<arguments.length&&void 0!==r?r:{container:null,cells:[]},s=2<arguments.length&&void 0!==a?a:null;if(!s){var l=re.utils.getNodeFromTree(n.documentElement);if((l=l||new P(n.documentElement))._stackingOrder=[0],A(i,l),re.utils.getScroll(l.actualNode)){var u={container:l,cells:[]};l._subGrid=u}}for(var d=n.createTreeWalker(o,t.NodeFilter.SHOW_ELEMENT,null,!1),p=s?d.nextNode():d.currentNode;p;){var m=re.utils.getNodeFromTree(p);p.parentElement?s=re.utils.getNodeFromTree(p.parentElement):p.parentNode&&re.utils.getNodeFromTree(p.parentNode)&&(s=re.utils.getNodeFromTree(p.parentNode)),(m=m||new P(p,s))._stackingOrder=k(m,s);var f=E(m,s),h=f?f._subGrid:i;if(re.utils.getScroll(m.actualNode)){var b={container:m,cells:[]};m._subGrid=b}var g=m.boundingClientRect;0!==g.width&&0!==g.height&&c.isVisible(p)&&A(h,m),re.utils.isShadowRoot(p)&&j(p.shadowRoot,h,m),p=d.nextNode()}}function C(e,t,r){var a=2<arguments.length&&void 0!==r&&r,o=t.left+t.width/2,i=t.top+t.height/2,s=i/w|0,l=o/w|0,u=e.cells[s][l].filter(function(e){return e.clientRects.find(function(e){var t=e.left,r=e.top;return o<=t+e.width&&t<=o&&i<=r+e.height&&r<=i})}),c=e.container;return c&&(u=C(c._grid,c.boundingClientRect,!0).concat(u)),a||(u=u.sort(D).map(function(e){return e.actualNode}).concat(n.documentElement).filter(function(e,t,r){return r.indexOf(e)===t})),u}c.getElementStack=function(e){re._cache.get("gridCreated")||(j(),re._cache.set("gridCreated",!0));var t=re.utils.getNodeFromTree(e),r=t._grid;return r?C(r,t.boundingClientRect):[]},c.getTextElementStack=function(e){re._cache.get("gridCreated")||(j(),re._cache.set("gridCreated",!0));var t=re.utils.getNodeFromTree(e)._grid;if(!t)return[];var r=[];return Array.from(e.childNodes).forEach(function(e){if(3===e.nodeType&&""!==re.commons.text.sanitize(e.textContent)){var t=n.createRange();t.selectNodeContents(e);for(var a=t.getClientRects(),o=0;o<a.length;o++){var i=a[o];1<=i.width&&1<=i.height&&r.push(i)}}}),r.map(function(e){return C(t,e)})},c.getRootNode=re.utils.getRootNode,c.getScrollOffset=function(e){"use strict";if(!e.nodeType&&e.document&&(e=e.document),9!==e.nodeType)return{left:e.scrollLeft,top:e.scrollTop};var t=e.documentElement,r=e.body;return{left:t&&t.scrollLeft||r&&r.scrollLeft||0,top:t&&t.scrollTop||r&&r.scrollTop||0}},c.getTabbableElements=function(e){return re.utils.querySelectorAll(e,"*").filter(function(e){var t=e.isFocusable,r=e.actualNode.getAttribute("tabindex");return(r=r&&!isNaN(parseInt(r,10))?parseInt(r):null)?t&&0<=r:t})},c.getViewportSize=function(e){"use strict";var t,r=e.document,n=r.documentElement;return e.innerWidth?{width:e.innerWidth,height:e.innerHeight}:n?{width:n.clientWidth,height:n.clientHeight}:{width:(t=r.body).clientWidth,height:t.clientHeight}};var F=["HEAD","TITLE","TEMPLATE","SCRIPT","STYLE","IFRAME","OBJECT","VIDEO","AUDIO","NOSCRIPT"];function T(e){return e.disabled||"AREA"!==e.nodeName.toUpperCase()&&c.isHiddenWithCSS(e)}function N(e,r){if(9===e.nodeType)return!1;if(11===e.nodeType&&(e=e.host),["STYLE","SCRIPT"].includes(e.nodeName.toUpperCase()))return!1;var n=t.getComputedStyle(e,null);if(!n)throw new Error("Style does not exist for the given element.");if("none"===n.getPropertyValue("display"))return!0;var a=["hidden","collapse"],o=n.getPropertyValue("visibility");if(a.includes(o)&&!r)return!0;if(a.includes(o)&&r&&a.includes(r))return!0;var i=c.getComposedParent(e);return!(!i||a.includes(o))&&c.isHiddenWithCSS(i,o)}c.hasContentVirtual=function(e,t,r){return function(e){if(!F.includes(e.actualNode.nodeName.toUpperCase()))return e.children.some(function(e){var t=e.actualNode;return 3===t.nodeType&&t.nodeValue.trim()})}(e)||c.isVisualContent(e.actualNode)||!r&&!!i.labelVirtual(e)||!t&&e.children.some(function(e){return 1===e.actualNode.nodeType&&c.hasContentVirtual(e)})},c.hasContent=function(e,t,r){return e=re.utils.getNodeFromTree(e),c.hasContentVirtual(e,t,r)},c.idrefs=function(e,t){"use strict";var r,n,a=c.getRootNode(e),o=[],i=e.getAttribute(t);if(i)for(r=0,n=(i=re.utils.tokenList(i)).length;r<n;r++)o.push(a.getElementById(i[r]));return o},c.isFocusable=function(e){"use strict";if(T(e))return!1;if(c.isNativelyFocusable(e))return!0;var t=e.getAttribute("tabindex");return!(!t||isNaN(parseInt(t,10)))},c.isNativelyFocusable=function(e){"use strict";if(!e||T(e))return!1;switch(e.nodeName.toUpperCase()){case"A":case"AREA":if(e.href)return!0;break;case"INPUT":return"hidden"!==e.type;case"TEXTAREA":case"SELECT":case"SUMMARY":case"BUTTON":return!0;case"DETAILS":return!e.querySelector("summary")}return!1},c.insertedIntoFocusOrder=function(e){return-1<parseInt(e.getAttribute("tabindex"),10)&&c.isFocusable(e)&&!c.isNativelyFocusable(e)},c.isHiddenWithCSS=function(e,t){var r=re.utils.getNodeFromTree(e);return r?(void 0===r._isHiddenWithCSS&&(r._isHiddenWithCSS=N(e,t)),r._isHiddenWithCSS):N(e,t)},c.isHTML5=function(e){var t=e.doctype;return null!==t&&"html"===t.name&&!t.publicId&&!t.systemId};var S=["block","list-item","table","flex","grid","inline-block"];function z(e){var r=t.getComputedStyle(e).getPropertyValue("display");return S.includes(r)||"table-"===r.substr(0,6)}c.isInTextBlock=function(e){if(z(e))return!1;var t=function(e){for(var t=c.getComposedParent(e);t&&!z(t);)t=c.getComposedParent(t);return re.utils.getNodeFromTree(t)}(e),r="",n="",a=0;return function e(t,r){!1!==r(t.actualNode)&&t.children.forEach(function(t){return e(t,r)})}(t,function(t){if(2===a)return!1;if(3===t.nodeType&&(r+=t.nodeValue),1===t.nodeType){var o=(t.nodeName||"").toUpperCase();if(["BR","HR"].includes(o))0===a?n=r="":a=2;else{if("none"===t.style.display||"hidden"===t.style.overflow||!["",null,"none"].includes(t.style.float)||!["",null,"relative"].includes(t.style.position))return!1;if("A"===o&&t.href||"link"===(t.getAttribute("role")||"").toLowerCase())return t===e&&(a=1),n+=t.textContent,!1}}}),r=re.commons.text.sanitize(r),n=re.commons.text.sanitize(n),r.length>n.length},c.isModalOpen=function(e){var r=(e=e||{}).modalPercent||.75;if(re._cache.get("isModalOpen"))return re._cache.get("isModalOpen");if(re.utils.querySelectorAllFilter(re._tree[0],"dialog, [role=dialog], [aria-modal=true]",function(e){return c.isVisible(e.actualNode)}).length)return re._cache.set("isModalOpen",!0),!0;function o(e){var r=p[e].find(function(e){var r=t.getComputedStyle(e);return parseInt(r.width,10)>=s&&parseInt(r.height,10)>=l&&"none"!==r.getPropertyValue("pointer-events")&&("absolute"===r.position||"fixed"===r.position)});if(r&&p.every(function(e){return e.includes(r)}))return re._cache.set("isModalOpen",!0),{v:!0}}for(var i=c.getViewportSize(t),s=i.width*r,l=i.height*r,u=(i.width-s)/2,d=(i.height-l)/2,p=[{x:u,y:d},{x:i.width-u,y:d},{x:i.width/2,y:i.height/2},{x:u,y:i.height-d},{x:i.width-u,y:i.height-d}].map(function(e){return Array.from(n.elementsFromPoint(e.x,e.y))}),m=0;m<p.length;m++){var f=o(m);if("object"===a(f))return f.v}re._cache.set("isModalOpen",void 0)},c.isNode=function(e){"use strict";return e instanceof Node},c.isOffscreen=function(e){var r,a=n.documentElement,o=t.getComputedStyle(e),i=t.getComputedStyle(n.body||a).getPropertyValue("direction"),s=c.getElementCoordinates(e);if(s.bottom<0&&(function(e,t){for(e=c.getComposedParent(e);e&&"html"!==e.nodeName.toLowerCase();){if(e.scrollTop&&0<=(t+=e.scrollTop))return;e=c.getComposedParent(e)}return 1}(e,s.bottom)||"absolute"===o.position))return!0;if(0===s.left&&0===s.right)return!1;if("ltr"===i){if(s.right<=0)return!0}else if(r=Math.max(a.scrollWidth,c.getViewportSize(t).width),s.left>=r)return!0;return!1};var q=/^\\/?#[^/!]/;c.isSkipLink=function(e){return!!q.test(e.getAttribute("href"))&&(void 0!==re._cache.get("firstPageLink")?t=re._cache.get("firstPageLink"):(t=re.utils.querySelectorAll(re._tree,\'a:not([href^="#"]):not([href^="/#"]):not([href^="javascript"])\')[0],re._cache.set("firstPageLink",t||null)),!t||e.compareDocumentPosition(t.actualNode)===e.DOCUMENT_POSITION_FOLLOWING);var t};var O=/rect\\s*\\(([0-9]+)px,?\\s*([0-9]+)px,?\\s*([0-9]+)px,?\\s*([0-9]+)px\\s*\\)/,_=/(\\w+)\\((\\d+)/;c.isVisible=function(e,r,n){"use strict";var a=re.utils.getNodeFromTree(e),o="_isVisible"+(r?"ScreenReader":"");if(9===e.nodeType)return!0;if(11===e.nodeType&&(e=e.host),a&&void 0!==a[o])return a[o];var i=t.getComputedStyle(e,null);if(null===i)return!1;var s=e.nodeName.toUpperCase();if("AREA"===s)return function(e,t,r){var n=c.findUp(e,"map");if(!n)return!1;var a=n.getAttribute("name");if(!a)return!1;var o=c.getRootNode(e);if(!o||9!==o.nodeType)return!1;var i=re.utils.querySelectorAll(re._tree,\'img[usemap="#\'.concat(re.utils.escapeSelector(a),\'"]\'));return!(!i||!i.length)&&i.some(function(e){var n=e.actualNode;return c.isVisible(n,t,r)})}(e,r,n);if("none"===i.getPropertyValue("display")||["STYLE","SCRIPT","NOSCRIPT","TEMPLATE"].includes(s))return!1;if(r&&"true"===e.getAttribute("aria-hidden"))return!1;if(!r&&(function(e){var t=e.getPropertyValue("clip").match(O),r=e.getPropertyValue("clip-path").match(_);if(t&&5===t.length)return t[3]-t[1]<=0&&t[2]-t[4]<=0;if(r){var n=r[1],a=parseInt(r[2],10);switch(n){case"inset":return 50<=a;case"circle":return 0===a}}}(i)||"0"===i.getPropertyValue("opacity")||re.utils.getScroll(e)&&0===parseInt(i.getPropertyValue("height"))))return!1;if(!n&&("hidden"===i.getPropertyValue("visibility")||!r&&re.commons.dom.isOffscreen(e)))return!1;var l=e.assignedSlot?e.assignedSlot:e.parentNode,u=!1;return l&&(u=c.isVisible(l,r,!0)),a&&(a[o]=u),u};var R=["checkbox","img","radio","range","slider","spinbutton","textbox"];function I(e){for(var t=re.utils.getNodeFromTree(e).parent;t;){if(re.utils.getScroll(t.actualNode))return t.actualNode;t=t.parent}}c.isVisualContent=function(e){var t=e.getAttribute("role");if(t)return-1!==R.indexOf(t);switch(e.nodeName.toUpperCase()){case"IMG":case"IFRAME":case"OBJECT":case"VIDEO":case"AUDIO":case"CANVAS":case"SVG":case"MATH":case"BUTTON":case"SELECT":case"TEXTAREA":case"KEYGEN":case"PROGRESS":case"METER":return!0;case"INPUT":return"hidden"!==e.type;default:return!1}},c.shadowElementsFromPoint=function(e,t){var r=2<arguments.length&&void 0!==arguments[2]?arguments[2]:n,a=3<arguments.length&&void 0!==arguments[3]?arguments[3]:0;if(999<a)throw new Error("Infinite loop detected");return Array.from(r.elementsFromPoint(e,t)||[]).filter(function(e){return c.getRootNode(e)===r}).reduce(function(r,n){if(re.utils.isShadowRoot(n)){var o=c.shadowElementsFromPoint(e,t,n.shadowRoot,a+1);(r=r.concat(o)).length&&re.commons.dom.visuallyContains(r[0],n)&&r.push(n)}else r.push(n);return r},[])},c.urlPropsFromAttribute=function(e,t){if(e.hasAttribute(t)){var r=e.nodeName.toUpperCase(),a=e;["A","AREA"].includes(r)&&!e.ownerSVGElement||((a=n.createElement("a")).href=e.getAttribute(t));var o,i,s,l=["https:","ftps:"].includes(a.protocol)?a.protocol.replace(/s:$/,":"):a.protocol,u=(i=(o=/^\\//.test(a.pathname)?a.pathname:"/".concat(a.pathname)).split("/").pop())&&-1!==i.indexOf(".")?{pathname:o.replace(i,""),filename:/index./.test(i)?"":i}:{pathname:o,filename:""},c=u.pathname,d=u.filename;return{protocol:l,hostname:a.hostname,port:(s=a.port,["443","80"].includes(s)?"":s),pathname:/\\/$/.test(c)?c:"".concat(c,"/"),search:function(e){var t={};if(!e||!e.length)return t;var r=e.substring(1).split("&");if(!r||!r.length)return t;for(var n=0;n<r.length;n++){var a=r[n].split("="),o=B(a,2),i=o[0],s=o[1],l=void 0===s?"":s;t[decodeURIComponent(i)]=decodeURIComponent(l)}return t}(a.search),hash:function(e){if(!e)return"";var t=e.match(/#!?\\/?/g);return t&&"#"!==B(t,1)[0]?e:""}(a.hash),filename:d}}},c.visuallyContains=function(e,r){var n,a,o,i,s,l,u,c,d,p,m,f,h,b,g=I(r);do{var y=I(e);if(y===g||y===r)return n=r,b=void 0,o=(a=e.getBoundingClientRect()).top+.01,i=a.bottom-.01,s=a.left+.01,l=a.right-.01,c=(u=n.getBoundingClientRect()).top,d=u.left,p=c-n.scrollTop,m=c-n.scrollTop+n.scrollHeight,f=d-n.scrollLeft,h=d-n.scrollLeft+n.scrollWidth,"inline"===(b=t.getComputedStyle(n)).getPropertyValue("display")||!(s<f&&s<u.left||o<p&&o<u.top||h<l&&l>u.right||m<i&&i>u.bottom)&&(!(l>u.right||i>u.bottom)||"scroll"===b.overflow||"auto"===b.overflow||"hidden"===b.overflow||n instanceof HTMLBodyElement||n instanceof HTMLHtmlElement);e=y}while(e);return!1},c.visuallyOverlaps=function(e,r){var n=r.getBoundingClientRect(),a=n.top,o=n.left,i=a-r.scrollTop,s=a-r.scrollTop+r.scrollHeight,l=o-r.scrollLeft,u=o-r.scrollLeft+r.scrollWidth;if(e.left>u&&e.left>n.right||e.top>s&&e.top>n.bottom||e.right<l&&e.right<n.left||e.bottom<i&&e.bottom<n.top)return!1;var c=t.getComputedStyle(r);return!(e.left>n.right||e.top>n.bottom)||"scroll"===c.overflow||"auto"===c.overflow||r instanceof HTMLBodyElement||r instanceof HTMLHtmlElement},d.isAriaCombobox=function(e){return"combobox"===re.commons.aria.getRole(e,{noImplicit:!0})},d.isAriaListbox=function(e){return"listbox"===re.commons.aria.getRole(e,{noImplicit:!0})};var L=["progressbar","scrollbar","slider","spinbutton"];d.isAriaRange=function(e){var t=re.commons.aria.getRole(e,{noImplicit:!0});return L.includes(t)},d.isAriaTextbox=function(e){return"textbox"===re.commons.aria.getRole(e,{noImplicit:!0})},d.isNativeSelect=function(e){return"SELECT"===e.nodeName.toUpperCase()};var M=["button","checkbox","color","file","hidden","image","password","radio","reset","submit"];d.isNativeTextbox=function(e){var t=e.nodeName.toUpperCase();return"TEXTAREA"===t||"INPUT"===t&&!M.includes(e.type)},p.attributes=function(e,t){return e instanceof re.AbstractVirtualNode||(e=re.utils.getNodeFromTree(e)),p.fromFunction(function(t){return e.attr(t)},t)},p.condition=function(e,t){return!!t(e)};var V=["nodeName","attributes","properties","condition"];function U(e,t,r){for(var n,a="row"===e?"_rowHeaders":"_colHeaders",o="row"===e?m.isRowHeader:m.isColumnHeader,i="row"===e?t.y:0,s="row"===e?0:t.x,l=[],u=t.y;i<=u&&!n;u--)for(var c=t.x;s<=c;c--){var d=r[u]?r[u][c]:void 0;if(d){var p=re.utils.getNodeFromTree(d);if(p[a]){n=p[a];break}l.push(d)}}return n=(n||[]).concat(l.filter(o)),l.forEach(function(e){re.utils.getNodeFromTree(e)[a]=n}),n}function H(e){var t=e.actualNode;return 3!==t.nodeType?"":t.textContent}p.fromDefinition=function(e,t){return e instanceof re.AbstractVirtualNode||(e=re.utils.getNodeFromTree(e)),Array.isArray(t)?t.some(function(t){return p(e,t)}):"string"==typeof t?re.utils.matches(e,t):Object.keys(t).every(function(r){if(!V.includes(r))throw new Error(\'Unknown matcher type "\'.concat(r,\'"\'));var n=p[r],a=t[r];return n(e,a)})},p.fromFunction=function(e,t){if("object"!==a(t)||Array.isArray(t)||t instanceof RegExp)throw new Error("Expect matcher to be an object");return Object.keys(t).every(function(r){return p.fromPrimative(e(r),t[r])})},p.fromPrimative=function(e,t){var r=a(t);return Array.isArray(t)&&void 0!==e?t.includes(e):"function"===r?!!t(e):t instanceof RegExp?t.test(e):t===e},p.nodeName=function(e,t){return e instanceof re.AbstractVirtualNode||(e=re.utils.getNodeFromTree(e)),p.fromPrimative(e.props.nodeName,t)},p.properties=function(e,t){return e instanceof re.AbstractVirtualNode||(e=re.utils.getNodeFromTree(e)),p.fromFunction(function(t){return e.props[t]},t)},m.getAllCells=function(e){var t,r,n,a,o=[];for(t=0,n=e.rows.length;t<n;t++)for(r=0,a=e.rows[t].cells.length;r<a;r++)o.push(e.rows[t].cells[r]);return o},m.getCellPosition=re.utils.memoize(function(e,t){var r,n;for(t=t||m.toGrid(c.findUp(e,"table")),r=0;r<t.length;r++)if(t[r]&&-1!==(n=t[r].indexOf(e)))return{x:n,y:r}}),m.getHeaders=function(e,t){if(e.getAttribute("headers")){var r=o.dom.idrefs(e,"headers");if(r.filter(function(e){return e}).length)return r}t=t||o.table.toGrid(o.dom.findUp(e,"table"));var n=o.table.getCellPosition(e,t),a=U("row",n,t),i=U("col",n,t);return[].concat(a,i).reverse()},m.getScope=function(e){var t=e.getAttribute("scope"),r=e.getAttribute("role");if(e instanceof Element==0||-1===["TD","TH"].indexOf(e.nodeName.toUpperCase()))throw new TypeError("Expected TD or TH element");if("columnheader"===r)return"col";if("rowheader"===r)return"row";if("col"===t||"row"===t)return t;if("TH"!==e.nodeName.toUpperCase())return!1;var n=m.toGrid(c.findUp(e,"table")),a=m.getCellPosition(e,n);return n[a.y].reduce(function(e,t){return e&&"TH"===t.nodeName.toUpperCase()},!0)?"col":n.map(function(e){return e[a.x]}).reduce(function(e,t){return e&&t&&"TH"===t.nodeName.toUpperCase()},!0)?"row":"auto"},m.isColumnHeader=function(e){return-1!==["col","auto"].indexOf(m.getScope(e))},m.isDataCell=function(e){if(!e.children.length&&!e.textContent.trim())return!1;var t=e.getAttribute("role");return re.commons.aria.isValidRole(t)?["cell","gridcell"].includes(t):"TD"===e.nodeName.toUpperCase()},m.isDataTable=function(e){var r=(e.getAttribute("role")||"").toLowerCase();if(("presentation"===r||"none"===r)&&!c.isFocusable(e))return!1;if("true"===e.getAttribute("contenteditable")||c.findUp(e,\'[contenteditable="true"]\'))return!0;if("grid"===r||"treegrid"===r||"table"===r)return!0;if("landmark"===o.aria.getRoleType(r))return!0;if("0"===e.getAttribute("datatable"))return!1;if(e.getAttribute("summary"))return!0;if(e.tHead||e.tFoot||e.caption)return!0;for(var n=0,a=e.children.length;n<a;n++)if("COLGROUP"===e.children[n].nodeName.toUpperCase())return!0;for(var i,s,l=0,u=e.rows.length,d=!1,p=0;p<u;p++)for(var m=0,f=(i=e.rows[p]).cells.length;m<f;m++){if("TH"===(s=i.cells[m]).nodeName.toUpperCase())return!0;if(d||s.offsetWidth===s.clientWidth&&s.offsetHeight===s.clientHeight||(d=!0),s.getAttribute("scope")||s.getAttribute("headers")||s.getAttribute("abbr"))return!0;if(["columnheader","rowheader"].includes((s.getAttribute("role")||"").toLowerCase()))return!0;if(1===s.children.length&&"ABBR"===s.children[0].nodeName.toUpperCase())return!0;l++}if(e.getElementsByTagName("table").length)return!1;if(u<2)return!1;var h,b,g=e.rows[Math.ceil(u/2)];if(1===g.cells.length&&1===g.cells[0].colSpan)return!1;if(5<=g.cells.length)return!0;if(d)return!0;for(p=0;p<u;p++){if(i=e.rows[p],h&&h!==t.getComputedStyle(i).getPropertyValue("background-color"))return!0;if(h=t.getComputedStyle(i).getPropertyValue("background-color"),b&&b!==t.getComputedStyle(i).getPropertyValue("background-image"))return!0;b=t.getComputedStyle(i).getPropertyValue("background-image")}return 20<=u||!(c.getElementCoordinates(e).width>.95*c.getViewportSize(t).width)&&!(l<10)&&!e.querySelector("object, embed, iframe, applet")},m.isHeader=function(e){if(m.isColumnHeader(e)||m.isRowHeader(e))return!0;if(e.getAttribute("id")){var t=re.utils.escapeSelector(e.getAttribute("id"));return!!n.querySelector(\'[headers~="\'.concat(t,\'"]\'))}return!1},m.isRowHeader=function(e){return["row","auto"].includes(m.getScope(e))},m.toGrid=re.utils.memoize(function(e){for(var t=[],r=e.rows,n=0,a=r.length;n<a;n++){var o=r[n].cells;t[n]=t[n]||[];for(var i=0,s=0,l=o.length;s<l;s++)for(var u=0;u<o[s].colSpan;u++){for(var c=0;c<o[s].rowSpan;c++){for(t[n+c]=t[n+c]||[];t[n+c][i];)i++;t[n+c][i]=o[s]}i++}}return t}),m.toArray=m.toGrid,m.traverse=function(e,t,r,n){if(Array.isArray(t)&&(n=r,r=t,t={x:0,y:0}),"string"==typeof e)switch(e){case"left":e={x:-1,y:0};break;case"up":e={x:0,y:-1};break;case"right":e={x:1,y:0};break;case"down":e={x:0,y:1}}return function e(t,r,n,a){var o,i=n[r.y]?n[r.y][r.x]:void 0;return i?"function"==typeof a&&!0===(o=a(i,r,n))?[i]:((o=e(t,{x:r.x+t.x,y:r.y+t.y},n,a)).unshift(i),o):[]}(e,{x:t.x+e.x,y:t.y+e.y},r,n)},f.accessibleText=function(e,t){var r=re.utils.getNodeFromTree(e);return f.accessibleTextVirtual(r,t)},f.accessibleTextVirtual=function(e,t){var r=1<arguments.length&&void 0!==t?t:{},n=e.actualNode;if(r=function(e,t){var r=e.actualNode;return t.startNode||(t=l({startNode:e},t)),1===r.nodeType&&t.inLabelledByContext&&void 0===t.includeHidden&&(t=l({includeHidden:!c.isVisible(r,!0)},t)),t}(e,r),function(e,t){var r=e.actualNode;if(1===r.nodeType&&!t.includeHidden)return!c.isVisible(r,!0)}(e,r))return"";var a=[i.arialabelledbyText,i.arialabelText,f.nativeTextAlternative,f.formControlValue,f.subtreeText,H,f.titleText].reduce(function(t,n){return r.startNode===e&&(t=f.sanitize(t)),""!==t?t:n(e,r)},"");return r.debug&&re.log(a||"{empty-value}",n,r),a},f.accessibleTextVirtual.alreadyProcessed=function(e,t){return t.processed=t.processed||[],!!t.processed.includes(e)||(t.processed.push(e),!1)};var $=["textbox","progressbar","scrollbar","slider","spinbutton","combobox","listbox"];f.formControlValueMethods={nativeTextboxValue:function(e){return e=e.actualNode||e,re.commons.forms.isNativeTextbox(e)&&e.value||""},nativeSelectValue:function(e){return e=e.actualNode||e,re.commons.forms.isNativeSelect(e)&&Array.from(e.options).filter(function(e){return e.selected}).map(function(e){return e.text}).join(" ")||""},ariaTextboxValue:function(e){var t=e.actualNode;return re.commons.forms.isAriaTextbox(t)?c.isHiddenWithCSS(t)?t.textContent:f.visibleVirtual(e,!0):""},ariaListboxValue:function(e,t){var r=e.actualNode;if(!re.commons.forms.isAriaListbox(r))return"";var n=i.getOwnedVirtual(e).filter(function(e){return"option"===i.getRole(e)&&"true"===e.actualNode.getAttribute("aria-selected")});return 0!==n.length?re.commons.text.accessibleTextVirtual(n[0],t):""},ariaComboboxValue:function(e,t){var r,n=e.actualNode;return re.commons.forms.isAriaCombobox(n)&&(r=i.getOwnedVirtual(e).filter(function(e){return"listbox"===i.getRole(e)})[0])?f.formControlValueMethods.ariaListboxValue(r,t):""},ariaRangeValue:function(e){if(e=e.actualNode||e,!re.commons.forms.isAriaRange(e)||!e.hasAttribute("aria-valuenow"))return"";var t=+e.getAttribute("aria-valuenow");return isNaN(t)?"0":String(t)}},f.formControlValue=function(e,t){var r=1<arguments.length&&void 0!==t?t:{},n=e.actualNode,a=f.unsupported.accessibleNameFromFieldValue||[],o=i.getRole(n);if(r.startNode===e||!$.includes(o)||a.includes(o))return"";var s=Object.keys(f.formControlValueMethods).map(function(e){return f.formControlValueMethods[e]}).reduce(function(t,n){return t||n(e,r)},"");return r.debug&&re.log(s||"{empty-value}",n,r),s},f.isHumanInterpretable=function(e){if(!e.length)return 0;if(["x","i"].includes(e))return 0;var t=f.removeUnicode(e,{emoji:!0,nonBmp:!0,punctuations:!0});return f.sanitize(t)?1:0},f.isIconLigature=function(e){var r=1<arguments.length&&void 0!==arguments[1]?arguments[1]:.15,a=2<arguments.length&&void 0!==arguments[2]?arguments[2]:3,o=e.actualNode.nodeValue.trim();if(!f.sanitize(o)||f.hasUnicode(o,{emoji:!0,nonBmp:!0}))return!1;re._cache.get("canvasContext")||re._cache.set("canvasContext",n.createElement("canvas").getContext("2d"));var i=re._cache.get("canvasContext"),s=i.canvas;re._cache.get("fonts")||re._cache.set("fonts",{});var l=re._cache.get("fonts"),u=t.getComputedStyle(e.parent.actualNode).getPropertyValue("font-family");l[u]||(l[u]={occurances:0,numLigatures:0});var c=l[u];if(c.occurances>=a){if(c.numLigatures/c.occurances==1)return!0;if(0===c.numLigatures)return!1}c.occurances++;var d=30,p="".concat(d,"px ").concat(u);i.font=p;var m=o.charAt(0),h=i.measureText(m).width;if(h<30){var b=30/h;h*=b,p="".concat(d*=b,"px ").concat(u)}s.width=h,s.height=d,i.font=p,i.textAlign="left",i.textBaseline="top",i.fillText(m,0,0);var g=new Uint32Array(i.getImageData(0,0,h,d).data.buffer);if(!g.some(function(e){return e}))return c.numLigatures++,!0;i.clearRect(0,0,h,d),i.fillText(o,0,0);var y=new Uint32Array(i.getImageData(0,0,h,d).data.buffer),v=g.reduce(function(e,t,r){return 0===t&&0===y[r]||0!==t&&0!==y[r]?e:++e},0),w=o.split("").reduce(function(e,t){return e+i.measureText(t).width},0),x=i.measureText(o).width;return r<=v/g.length&&r<=1-x/w&&(c.numLigatures++,!0)},f.autocomplete={stateTerms:["on","off"],standaloneTerms:["name","honorific-prefix","given-name","additional-name","family-name","honorific-suffix","nickname","username","new-password","current-password","organization-title","organization","street-address","address-line1","address-line2","address-line3","address-level4","address-level3","address-level2","address-level1","country","country-name","postal-code","cc-name","cc-given-name","cc-additional-name","cc-family-name","cc-number","cc-exp","cc-exp-month","cc-exp-year","cc-csc","cc-type","transaction-currency","transaction-amount","language","bday","bday-day","bday-month","bday-year","sex","url","photo"],qualifiers:["home","work","mobile","fax","pager"],qualifiedTerms:["tel","tel-country-code","tel-national","tel-area-code","tel-local","tel-local-prefix","tel-local-suffix","tel-extension","email","impp"],locations:["billing","shipping"]},f.isValidAutocomplete=function(e,t){var r=1<arguments.length&&void 0!==t?t:{},n=r.looseTyped,a=void 0!==n&&n,o=r.stateTerms,i=void 0===o?[]:o,s=r.locations,l=void 0===s?[]:s,u=r.qualifiers,c=void 0===u?[]:u,d=r.standaloneTerms,p=void 0===d?[]:d,m=r.qualifiedTerms,h=void 0===m?[]:m;if(e=e.toLowerCase().trim(),(i=i.concat(f.autocomplete.stateTerms)).includes(e)||""===e)return!0;c=c.concat(f.autocomplete.qualifiers),l=l.concat(f.autocomplete.locations),p=p.concat(f.autocomplete.standaloneTerms),h=h.concat(f.autocomplete.qualifiedTerms);var b=e.split(/\\s+/g);if(!a&&(8<b[0].length&&"section-"===b[0].substr(0,8)&&b.shift(),l.includes(b[0])&&b.shift(),c.includes(b[0])&&(b.shift(),p=[]),1!==b.length))return!1;var g=b[b.length-1];return p.includes(g)||h.includes(g)},f.labelText=function(e,t){var r=1<arguments.length&&void 0!==t?t:{},n=f.accessibleTextVirtual.alreadyProcessed;if(r.inControlContext||r.inLabelledByContext||n(e,r))return"";r.startNode||(r.startNode=e);var a,o,i=l({inControlContext:!0},r),s=(a=e.actualNode).id?c.findElmsInContext({elm:"label",attr:"for",value:a.id,context:a}):[],u=c.findUpVirtual(e,"label");return u?(o=[].concat(_e(s),[u])).sort(re.utils.nodeSorter):o=s,o.map(function(e){return f.accessibleText(e,i)}).filter(function(e){return""!==e}).join(" ")},f.labelVirtual=function(e){var t,r;if(r=i.labelVirtual(e))return r;if(e.actualNode.id){var n=re.utils.escapeSelector(e.actualNode.getAttribute("id"));if(r=(t=re.commons.dom.getRootNode(e.actualNode).querySelector(\'label[for="\'+n+\'"]\'))&&f.visible(t,!0))return r}return(r=(t=c.findUpVirtual(e,"label"))&&f.visible(t,!0))||null},f.label=function(e){return e=re.utils.getNodeFromTree(e),f.labelVirtual(e)},f.nativeElementType=[{matches:[{nodeName:"textarea"},{nodeName:"input",properties:{type:["text","password","search","tel","email","url"]}}],namingMethods:"labelText"},{matches:{nodeName:"input",properties:{type:["button","submit","reset"]}},namingMethods:["valueText","titleText","buttonDefaultText"]},{matches:{nodeName:"input",properties:{type:"image"}},namingMethods:["altText","valueText","labelText","titleText","buttonDefaultText"]},{matches:"button",namingMethods:"subtreeText"},{matches:"fieldset",namingMethods:"fieldsetLegendText"},{matches:"OUTPUT",namingMethods:"subtreeText"},{matches:[{nodeName:"select"},{nodeName:"input",properties:{type:/^(?!text|password|search|tel|email|url|button|submit|reset)/}}],namingMethods:"labelText"},{matches:"summary",namingMethods:"subtreeText"},{matches:"figure",namingMethods:["figureText","titleText"]},{matches:"img",namingMethods:"altText"},{matches:"table",namingMethods:["tableCaptionText","tableSummaryText"]},{matches:["hr","br"],namingMethods:["titleText","singleSpace"]}],f.nativeTextAlternative=function(e,t){var r=1<arguments.length&&void 0!==t?t:{},n=e.actualNode;if(1!==n.nodeType||["presentation","none"].includes(i.getRole(n)))return"";var a,o,s,l,u=(a=e,o=f.nativeElementType,s=f.nativeTextMethods,((l=o.find(function(e){var t=e.matches;return re.commons.matches(a,t)}))?[].concat(l.namingMethods):[]).map(function(e){return s[e]})).reduce(function(t,n){return t||n(e,r)},"");return r.debug&&re.log(u||"{empty-value}",n,r),u};var G={submit:"Submit",image:"Submit",reset:"Reset",button:""};function W(e,t){return t.actualNode.getAttribute(e)||""}function Y(e,t,r){var n=t.actualNode,a=[e=e.toLowerCase(),n.nodeName.toLowerCase()].join(","),o=n.querySelector(a);return o&&o.nodeName.toLowerCase()===e?f.accessibleText(o,r):""}f.nativeTextMethods={valueText:function(e){return e.actualNode.value||""},buttonDefaultText:function(e){var t=e.actualNode;return G[t.type]||""},tableCaptionText:Y.bind(null,"caption"),figureText:Y.bind(null,"figcaption"),fieldsetLegendText:Y.bind(null,"legend"),altText:W.bind(null,"alt"),tableSummaryText:W.bind(null,"summary"),titleText:function(e,t){return f.titleText(e,t)},subtreeText:function(e,t){return f.subtreeText(e,t)},labelText:function(e,t){return f.labelText(e,t)},singleSpace:function(){return" "}},f.sanitize=function(e){"use strict";return e.replace(/\\r\\n/g,"\\n").replace(/\\u00A0/g," ").replace(/[\\s]{2,}/g," ").trim()},f.subtreeText=function(e,t){var r=1<arguments.length&&void 0!==t?t:{},n=f.accessibleTextVirtual.alreadyProcessed;r.startNode=r.startNode||e;var a=r.strict;return n(e,r)||!i.namedFromContents(e,{strict:a})?"":i.getOwnedVirtual(e).reduce(function(e,t){return function(e,t,r){var n=t.actualNode.nodeName.toUpperCase(),a=f.accessibleTextVirtual(t,r);return a?(K.includes(n)||(" "!==a[0]&&(a+=" "),e&&" "!==e[e.length-1]&&(a=" "+a)),e+a):e}(e,t,r)},"")};var K=["A","EM","STRONG","SMALL","MARK","ABBR","DFN","I","B","S","U","CODE","VAR","SAMP","KBD","SUP","SUB","Q","CITE","SPAN","BDO","BDI","WBR","INS","DEL","MAP","AREA","NOSCRIPT","RUBY","BUTTON","LABEL","OUTPUT","DATALIST","KEYGEN","PROGRESS","COMMAND","CANVAS","TIME","METER","#TEXT"],X=["button","iframe","a[href]",{nodeName:"input",properties:{type:"button"}}];return f.titleText=function(e){return 1!==(e=e.actualNode||e).nodeType||!e.hasAttribute("title")||!re.commons.matches(e,X)&&["none","presentation"].includes(i.getRole(e))?"":e.getAttribute("title")},f.hasUnicode=function(e,t){var r=t.emoji,n=t.nonBmp,a=t.punctuations;return r?re.imports.emojiRegexText().test(e):n?/[\\u1D00-\\u1D7F\\u1D80-\\u1DBF\\u1DC0-\\u1DFF\\u20A0-\\u20CF\\u20D0-\\u20FF\\u2100-\\u214F\\u2150-\\u218F\\u2190-\\u21FF\\u2200-\\u22FF\\u2300-\\u23FF\\u2400-\\u243F\\u2440-\\u245F\\u2460-\\u24FF\\u2500-\\u257F\\u2580-\\u259F\\u25A0-\\u25FF\\u2600-\\u26FF\\u2700-\\u27BF\\uE000-\\uF8FF]/g.test(e)||/[\\uDB80-\\uDBBF][\\uDC00-\\uDFFF]/g.test(e):!!a&&/[\\u2000-\\u206F\\u2E00-\\u2E7F\\\\\'!"#$%&\\xa3\\xa2\\xa5\\xa7\\u20ac()*+,\\-.\\/:;<=>?@\\[\\]^_`{|}~\\xb1]/g.test(e)},f.removeUnicode=function(e,t){var r=t.emoji,n=t.nonBmp,a=t.punctuations;return r&&(e=e.replace(re.imports.emojiRegexText(),"")),n&&(e=(e=e.replace(/[\\u1D00-\\u1D7F\\u1D80-\\u1DBF\\u1DC0-\\u1DFF\\u20A0-\\u20CF\\u20D0-\\u20FF\\u2100-\\u214F\\u2150-\\u218F\\u2190-\\u21FF\\u2200-\\u22FF\\u2300-\\u23FF\\u2400-\\u243F\\u2440-\\u245F\\u2460-\\u24FF\\u2500-\\u257F\\u2580-\\u259F\\u25A0-\\u25FF\\u2600-\\u26FF\\u2700-\\u27BF\\uE000-\\uF8FF]/g,"")).replace(/[\\uDB80-\\uDBBF][\\uDC00-\\uDFFF]/g,"")),a&&(e=e.replace(/[\\u2000-\\u206F\\u2E00-\\u2E7F\\\\\'!"#$%&\\xa3\\xa2\\xa5\\xa7\\u20ac()*+,\\-.\\/:;<=>?@\\[\\]^_`{|}~\\xb1]/g,"")),e},f.unsupported={accessibleNameFromFieldValue:["combobox","listbox","progressbar"]},f.visibleTextNodes=function(e){var t=re.commons.dom.isVisible(e.actualNode),r=[];return e.children.forEach(function(e){3===e.actualNode.nodeType?t&&r.push(e):r=r.concat(f.visibleTextNodes(e))}),r},f.visibleVirtual=function(e,t,r){var n=e.children.map(function(n){if(3===n.actualNode.nodeType){var a=n.actualNode.nodeValue;if(a&&c.isVisible(e.actualNode,t))return a}else if(!r)return f.visibleVirtual(n,t)}).join("");return f.sanitize(n)},f.visible=function(e,t,r){return e=re.utils.getNodeFromTree(e),f.visibleVirtual(e,t,r)},o}()})}("object"==typeof window?window:this);',a=e("../../lib/page-functions.js")
;t.exports=class Accessibility extends n{afterPass(e){const t=e.driver,r=`(function () {\n      ${a.getNodeDetailsString};\n      ${i};\n      return (${function runA11yChecks(){return window.axe.run(document,{elementRef:!0,runOnly:{type:"tag",values:["wcag2a","wcag2aa"]},resultTypes:["violations","inapplicable"],rules:{tabindex:{enabled:!0},accesskeys:{enabled:!0},"heading-order":{enabled:!0},"meta-viewport":{enabled:!0},"duplicate-id":{enabled:!1},"table-fake-caption":{enabled:!1},"td-has-header":{enabled:!1},marquee:{enabled:!1},"area-alt":{enabled:!1},"aria-dpub-role-fallback":{enabled:!1},"html-xml-lang-mismatch":{enabled:!1},blink:{enabled:!1},"server-side-image-map":{enabled:!1},"identical-links-same-purpose":{enabled:!1},"no-autoplay-audio":{enabled:!1},"svg-img-alt":{enabled:!1},"audio-caption":{enabled:!1}}}).then(e=>{document.documentElement.scrollTop=0;const t=e=>{e.nodes.forEach(e=>{Object.assign(e,getNodeDetails(e.element)),e.element=e.any=e.all=e.none=void 0}),
e.error instanceof Error&&(e.error={name:e.error.name,message:e.error.message,stack:e.error.stack,errorNode:e.error.errorNode})};return e.violations.forEach(t),e.incomplete.forEach(t),e={violations:e.violations,notApplicable:e.inapplicable,incomplete:e.incomplete,version:e.testEngine.version}})}.toString()}());\n    })()`;return t.evaluateAsync(r,{useIsolation:!0}).then(e=>{if(!e)throw new Error("No axe-core results returned");if(!Array.isArray(e.violations))throw new Error("Unable to parse axe results"+e);return e})}}},{"../../lib/page-functions.js":91,"./gatherer.js":62}],"../gather/gatherers/anchor-elements":[function(e,t,r){"use strict";const n=e("./gatherer.js"),i=e("../../lib/page-functions.js");t.exports=class AnchorElements extends n{async afterPass(e){const t=e.driver,r=`(() => {\n      ${i.getElementsInDocumentString};\n      ${i.getNodeDetailsString};\n\n      return (${function collectAnchorElements(){const e=e=>{try{return new URL(e,window.location.href).href}catch(e){
return""}};function getTruncatedOnclick(e){return(e.getAttribute("onclick")||"").slice(0,1024)}return getElementsInDocument("a").map(t=>{const r=getNodeDetails(t);return t instanceof HTMLAnchorElement?{href:t.href,rawHref:t.getAttribute("href")||"",onclick:getTruncatedOnclick(t),role:t.getAttribute("role")||"",name:t.name,text:t.innerText,rel:t.rel,target:t.target,...r}:{href:e(t.href.baseVal),rawHref:t.getAttribute("href")||"",onclick:getTruncatedOnclick(t),role:t.getAttribute("role")||"",text:t.textContent||"",rel:"",target:t.target.baseVal||"",...r}})}})();\n    })()`,n=await t.evaluateAsync(r,{useIsolation:!0});await t.sendCommand("DOM.enable"),await t.sendCommand("DOM.getDocument",{depth:-1,pierce:!0});const a=n.map(async e=>{const r=await async function getEventListeners(e,t){const r=await e.resolveDevtoolsNodePathToObjectId(t);return r?(await e.sendCommand("DOMDebugger.getEventListeners",{objectId:r})).listeners.map(({type:e})=>({type:e})):[]}(t,e.devtoolsNodePath);return{...e,
listeners:r}}),s=await Promise.all(a);return await t.sendCommand("DOM.disable"),s}}},{"../../lib/page-functions.js":91,"./gatherer.js":62}],"../gather/gatherers/cache-contents":[function(e,t,r){"use strict";const n=e("./gatherer.js");t.exports=class CacheContents extends n{async afterPass(e){const t=e.driver,r=await t.evaluateAsync(`(${function getCacheContents(){return caches.keys().then(e=>Promise.all(e.map(e=>caches.open(e)))).then(e=>{const t=[];return Promise.all(e.map(e=>e.keys().then(e=>{t.push(...e.map(e=>e.url))}))).then(e=>t)})}.toString()}())`);if(!r||!Array.isArray(r))throw new Error("Unable to retrieve cache contents");return r}}},{"./gatherer.js":62}],"../gather/gatherers/console-messages":[function(e,t,r){"use strict";const n=e("./gatherer.js");t.exports=class ConsoleMessages extends n{constructor(){super(),this._logEntries=[],this._onConsoleEntryAdded=this.onConsoleEntry.bind(this)}onConsoleEntry(e){this._logEntries.push(e)}async beforePass(e){const t=e.driver
;t.on("Log.entryAdded",this._onConsoleEntryAdded),await t.sendCommand("Log.enable"),await t.sendCommand("Log.startViolationsReport",{config:[{name:"discouragedAPIUse",threshold:-1}]})}async afterPass(e){return await e.driver.sendCommand("Log.stopViolationsReport"),await e.driver.off("Log.entryAdded",this._onConsoleEntryAdded),await e.driver.sendCommand("Log.disable"),this._logEntries}}},{"./gatherer.js":62}],"../gather/gatherers/css-usage":[function(e,t,r){"use strict";const n=e("./gatherer.js");t.exports=class CSSUsage extends n{async afterPass(e){const t=e.driver,r=[],n=e=>r.push(e);t.on("CSS.styleSheetAdded",n),await t.sendCommand("DOM.enable"),await t.sendCommand("CSS.enable"),await t.sendCommand("CSS.startRuleUsageTracking"),await t.evaluateAsync("getComputedStyle(document.body)"),t.off("CSS.styleSheetAdded",n);const i=r.map(e=>{const r=e.header.styleSheetId;return t.sendCommand("CSS.getStyleSheetText",{styleSheetId:r}).then(t=>({header:e.header,content:t.text}))
}),a=await Promise.all(i),s=await t.sendCommand("CSS.stopRuleUsageTracking");await t.sendCommand("CSS.disable"),await t.sendCommand("DOM.disable");const o=new Map(a.map(e=>[e.content,e]));return{rules:s.ruleUsage,stylesheets:Array.from(o.values())}}}},{"./gatherer.js":62}],"../gather/gatherers/dobetterweb/appcache":[function(e,t,r){"use strict";const n=e("../gatherer.js");t.exports=class AppCacheManifest extends n{afterPass(e){return e.driver.querySelector("html").then(e=>e&&e.getAttribute("manifest"))}}},{"../gatherer.js":62}],"../gather/gatherers/dobetterweb/doctype":[function(e,t,r){"use strict";const n=e("../gatherer.js");t.exports=class Doctype extends n{afterPass(e){return e.driver.evaluateAsync(`(${function getDoctype(){if(!document.doctype)return null;const{name:e,publicId:t,systemId:r}=document.doctype;return{name:e,publicId:t,systemId:r}}.toString()}())`)}}},{"../gatherer.js":62}],"../gather/gatherers/dobetterweb/domstats":[function(e,t,r){"use strict"
;const n=e("../gatherer.js"),i=e("../../../lib/page-functions.js");function createSelectorsLabel(e){let t=e.localName||"";const r=e.getAttribute&&e.getAttribute("id");if(r&&(t+=`#${r}`),e.classList){const r=e.classList.toString();r&&(t+=`.${r.trim().replace(/\s+/g,".")}`)}else ShadowRoot.prototype.isPrototypeOf(e)&&(t+="#shadow-root");return t}function elementPathInDOM(e){const t=new Set,r=[createSelectorsLabel(e)];let n=e;for(;n;){if(t.add(n),ShadowRoot.prototype.isPrototypeOf(n)){n=n.host&&"a"!==n.localName?n.host:n.parentElement}else{n=n.parentNode&&n.parentNode.host&&"a"!==n.parentNode.localName?n.parentNode.host:n.parentElement}t.has(n)&&(n=null),n&&r.unshift(createSelectorsLabel(n))}return r}t.exports=class DOMStats extends n{async afterPass(e){const t=e.driver,r=`(function() {\n      ${i.getOuterHTMLSnippetString};\n      ${createSelectorsLabel.toString()};\n      ${elementPathInDOM.toString()};\n      return (${function getDOMStats(e,t=!0){let r=null,n=-1,i=-1,a=0,s=null
;const o=function(e,l=1){l>n&&(r=e,n=l),e.children.length>i&&(s=e,i=e.children.length);let c=e.firstElementChild;for(;c;)o(c,l+1),t&&c.shadowRoot&&o(c.shadowRoot,l+1),c=c.nextElementSibling,a++;return{maxDepth:n,maxWidth:i,numElements:a}},l=o(e);return{depth:{max:l.maxDepth,pathToElement:elementPathInDOM(r),snippet:getOuterHTMLSnippet(r,["style"])},width:{max:l.maxWidth,pathToElement:elementPathInDOM(s),snippet:getOuterHTMLSnippet(s,["style"])},totalBodyElements:l.numElements}}.toString()}(document.body));\n    })()`;await t.sendCommand("DOM.enable");const n=await t.evaluateAsync(r,{useIsolation:!0});return await t.sendCommand("DOM.disable"),n}}},{"../../../lib/page-functions.js":91,"../gatherer.js":62}],"../gather/gatherers/dobetterweb/optimized-images":[function(e,t,r){"use strict";const n=e("lighthouse-logger"),i=e("../gatherer.js"),a=e("../../../lib/url-shim.js"),s=e("../../../lib/network-request.js"),o=e("../../../lib/sentry.js"),l=(e("../../driver.js"),
5e3),c=2048e3,u=.92,d=.85,m=4096,p=/^image\/((x|ms|x-ms)-)?(png|bmp|jpeg)$/;class OptimizedImages extends i{constructor(){super(),this._encodingStartAt=0}static filterImageRequests(e){const t=new Set;return e.reduce((e,r)=>{if(t.has(r.url)||!r.finished||r.sessionId)return e;t.add(r.url);const n=r.resourceType===s.TYPES.Image&&p.test(r.mimeType),i=Math.min(r.resourceSize||0,r.transferSize||0);return n&&i>m&&e.push({requestId:r.requestId,url:r.url,mimeType:r.mimeType,resourceSize:i}),e},[])}_getEncodedResponse(e,t,r){const n={requestId:t=s.getRequestIdForBackend(t),encoding:r,quality:"jpeg"===r?u:d,sizeOnly:!0};return e.sendCommand("Audits.getEncodedResponse",n)}async calculateImageStats(e,t){const r=t.resourceSize;if(Date.now()-this._encodingStartAt>l||r>c)return{originalSize:r,jpegSize:void 0,webpSize:void 0};const n=await this._getEncodedResponse(e,t.requestId,"jpeg"),i=await this._getEncodedResponse(e,t.requestId,"webp");return{originalSize:r,jpegSize:n.encodedSize,
webpSize:i.encodedSize}}async computeOptimizedImages(e,t){this._encodingStartAt=Date.now();const r=[];for(const i of t)try{const t={failed:!1,...await this.calculateImageStats(e,i),...i};r.push(t)}catch(e){n.warn("optimized-images",e.message),o.captureException(e,{tags:{gatherer:"OptimizedImages"},extra:{imageUrl:a.elideDataURI(i.url)},level:"warning"});const t={failed:!0,errMsg:e.message,...i};r.push(t)}return r}afterPass(e,t){const r=t.networkRecords,n=OptimizedImages.filterImageRequests(r).sort((e,t)=>t.resourceSize-e.resourceSize);return Promise.resolve().then(t=>this.computeOptimizedImages(e.driver,n)).then(e=>{const t=e.filter(e=>!e.failed);if(e.length&&!t.length)throw new Error("All image optimizations failed");return e})}}t.exports=OptimizedImages},{"../../../lib/network-request.js":90,"../../../lib/sentry.js":93,"../../../lib/url-shim.js":"url","../../driver.js":59,"../gatherer.js":62,"lighthouse-logger":141}],
"../gather/gatherers/dobetterweb/password-inputs-with-prevented-paste":[function(e,t,r){"use strict";const n=e("../gatherer.js"),i=e("../../../lib/page-functions.js");t.exports=class PasswordInputsWithPreventedPaste extends n{afterPass(e){const t=`(() => {\n      ${i.getNodeDetailsString};\n      return (${function findPasswordInputsWithPreventedPaste(){return Array.from(document.querySelectorAll('input[type="password"]')).filter(e=>!e.dispatchEvent(new ClipboardEvent("paste",{cancelable:!0}))).map(e=>getNodeDetails(e))}.toString()}());\n    })()`;return e.driver.evaluateAsync(t)}}},{"../../../lib/page-functions.js":91,"../gatherer.js":62}],"../gather/gatherers/dobetterweb/response-compression":[function(e,t,r){(function(r){"use strict"
;const n=e("../gatherer.js"),i=e("../../../lib/url-shim.js"),a=e("../../../lib/sentry.js"),s=e("../../../lib/network-request.js"),o=e("zlib").gzip,l="chrome-extension:",c=["content-encoding","x-original-content-encoding"],u=["gzip","br","deflate"],d=["image","audio","video"],m=[s.TYPES.Document,s.TYPES.Script,s.TYPES.Stylesheet,s.TYPES.XHR,s.TYPES.Fetch,s.TYPES.EventSource];class ResponseCompression extends n{static filterUnoptimizedResponses(e){const t=[];return e.forEach(e=>{if(e.sessionId)return;const r=e.mimeType,n=e.resourceType||s.TYPES.Other,i=e.resourceSize,a=!(r&&d.some(e=>r.startsWith(e)))&&m.includes(n),o=e.url.startsWith(l);a&&i&&e.finished&&!o&&e.transferSize&&304!==e.statusCode&&((e.responseHeaders||[]).find(e=>c.includes(e.name.toLowerCase())&&u.includes(e.value))||t.push({requestId:e.requestId,url:e.url,mimeType:r,transferSize:e.transferSize,resourceSize:i,gzipSize:0}))}),t}afterPass(e,t){
const n=t.networkRecords,s=ResponseCompression.filterUnoptimizedResponses(n),l=e.driver;return Promise.all(s.map(e=>l.getRequestContent(e.requestId).then(t=>t?new Promise((n,i)=>o(t,(t,a)=>{if(t)return i(t);e.gzipSize=r.byteLength(a,"utf8"),n(e)})):e).catch(t=>(a.captureException(t,{tags:{gatherer:"ResponseCompression"},extra:{url:i.elideDataURI(e.url)},level:"warning"}),e.gzipSize=void 0,e))))}}t.exports=ResponseCompression}).call(this,e("buffer").Buffer)},{"../../../lib/network-request.js":90,"../../../lib/sentry.js":93,"../../../lib/url-shim.js":"url","../gatherer.js":62,buffer:120,zlib:118}],"../gather/gatherers/dobetterweb/tags-blocking-first-paint":[function(e,t,r){"use strict";const n=e("../gatherer.js");e("../../driver.js");class TagsBlockingFirstPaint extends n{static _filteredAndIndexedByUrl(e){return e.reduce((e,t)=>{if(!t.finished)return e;const r="parser"===t.initiator.type,n=/(css|script)/.test(t.mimeType)&&r,i=t._failed
;return(t.mimeType&&t.mimeType.includes("html")||n||i&&r)&&(e[t.url]={isLinkPreload:!!t.isLinkPreload,transferSize:t.transferSize,startTime:t.startTime,endTime:t.endTime}),e},{})}static findBlockingTags(e,t){const r=`(${function collectTagsThatBlockFirstPaint(){return new Promise((e,t)=>{try{e([...document.querySelectorAll("link, head script[src]")].filter(e=>{if("SCRIPT"===e.tagName){const t=e;return!(t.hasAttribute("async")||t.hasAttribute("defer")||/^data:/.test(t.src)||/^blob:/.test(t.src)||"module"===t.getAttribute("type"))}if("LINK"===e.tagName){const t=e,r="stylesheet"===t.rel&&window.matchMedia(t.media).matches&&!t.disabled,n="import"===t.rel&&!t.hasAttribute("async");return r||n}return!1}).map(e=>({tagName:e.tagName,url:"LINK"===e.tagName?e.href:e.src,src:e.src,href:e.href,rel:e.rel,media:e.media,disabled:e.disabled,mediaChanges:window.___linkMediaChanges.filter(t=>t.href===e.href)})))}catch(e){
t(new Error(`${"Unable to gather Scripts/Stylesheets/HTML Imports on the page"}: ${e.message}`))}})}.toString()}())`,n=t.reduce((e,t)=>Math.min(e,t.endTime),1/0);return e.evaluateAsync(r).then(e=>{const r=TagsBlockingFirstPaint._filteredAndIndexedByUrl(t);return e.reduce((e,t)=>{const i=r[t.url];if(i&&!i.isLinkPreload){const a=(t.mediaChanges||[]).filter(e=>!e.matches).map(e=>e.msSinceHTMLEnd),s=Math.min(...a),o=Math.max(i.startTime,n+s/1e3);e.push({tag:t,transferSize:i.transferSize||0,startTime:i.startTime,endTime:Math.min(i.endTime,o)}),r[t.url]=null}return e},[])})}beforePass(e){return e.driver.evaluateScriptOnNewDocument(`(${function installMediaListener(){window.___linkMediaChanges=[],Object.defineProperty(HTMLLinkElement.prototype,"media",{set:function(e){return window.___linkMediaChanges.push({href:this.href,media:e,msSinceHTMLEnd:Date.now()-window.performance.timing.responseEnd,matches:window.matchMedia(e).matches}),this.setAttribute("media",e)}})}.toString()})()`)}
afterPass(e,t){return TagsBlockingFirstPaint.findBlockingTags(e.driver,t.networkRecords)}}t.exports=TagsBlockingFirstPaint},{"../../driver.js":59,"../gatherer.js":62}],"../gather/gatherers/form-elements":[function(e,t,r){"use strict";const n=e("./gatherer.js"),i=e("../../lib/page-functions.js");t.exports=class FormElements extends n{async afterPass(e){const t=e.driver,r=`(() => {\n      ${i.getElementsInDocumentString};\n      ${i.getNodeDetailsString};\n      return (${function collectFormElements(){const e=getElementsInDocument("textarea, input, label, select"),t=new Map,r={inputs:[],labels:[]};for(const n of e){if(n instanceof HTMLInputElement&&("submit"===n.type||"button"===n.type))continue;const e=n.form;if(!!e&&!t.has(e)){const r={attributes:{id:e.id,name:e.name,autocomplete:e.autocomplete,...getNodeDetails(e)},inputs:[],labels:[]};t.set(e,r)}const i=t.get(e)||r;(n instanceof HTMLInputElement||n instanceof HTMLTextAreaElement||n instanceof HTMLSelectElement)&&i.inputs.push({
id:n.id,name:n.name,placeholder:n instanceof HTMLSelectElement?void 0:n.placeholder,autocomplete:{property:n.autocomplete,attribute:n.getAttribute("autocomplete"),prediction:n.getAttribute("autofill-prediction")},...getNodeDetails(n)}),n instanceof HTMLLabelElement&&i.labels.push({for:n.htmlFor,...getNodeDetails(n)})}return(r.inputs.length>0||r.labels.length>0)&&t.set("formless",{inputs:r.inputs,labels:r.labels}),[...t.values()]}})();\n    })()`;return await t.evaluateAsync(r,{useIsolation:!0})}}},{"../../lib/page-functions.js":91,"./gatherer.js":62}],"../gather/gatherers/full-page-screenshot":[function(e,t,r){"use strict";const n=e("./gatherer.js"),i=30,a=16384,s=2097151;t.exports=class FullPageScreenshot extends n{async _takeScreenshot(e,t){const r=e.driver,n=await r.sendCommand("Page.getLayoutMetrics"),a=await r.evaluateAsync("window.devicePixelRatio"),s=Math.min(n.contentSize.width,t),o=Math.min(n.contentSize.height,t)
;return await r.sendCommand("Emulation.setDeviceMetricsOverride",{mobile:e.baseArtifacts.TestedAsMobileDevice,height:o,screenHeight:o,width:s,screenWidth:s,deviceScaleFactor:a,scale:1,positionX:0,positionY:0,screenOrientation:{angle:0,type:"portraitPrimary"}}),{width:s,height:o,data:"data:image/jpeg;base64,"+(await r.sendCommand("Page.captureScreenshot",{format:"jpeg",quality:i})).data}}async afterPass_(e){const t=await e.driver.evaluateAsync("window.devicePixelRatio"),r=Math.floor(a/t);let n=await this._takeScreenshot(e,r);return n.data.length>s&&(n=await this._takeScreenshot(e,5e3)).data.length>s?(e.LighthouseRunWarnings.push("Full page screenshot is too big–report won't show element screenshots."),null):n}async afterPass(e){const{driver:t}=e,r="none"!==e.settings.emulatedFormFactor&&!e.settings.internalDisableDeviceScreenEmulation;try{return await this.afterPass_(e)}finally{if(r)await t.beginEmulation(e.settings);else{
const r=await t.evaluateAsync("(function() {\n          return {\n            width: document.documentElement.clientWidth,\n            height: document.documentElement.clientHeight,\n            screenWidth: window.screen.width,\n            screenHeight: window.screen.height,\n            screenOrientation: {\n              type: window.screen.orientation.type,\n              angle: window.screen.orientation.angle,\n            },\n            deviceScaleFactor: window.devicePixelRatio,\n          };\n        })()",{useIsolation:!0});r.screenOrientation.type=function snakeCaseToCamelCase(e){return e.replace(/(-\w)/g,e=>e[1].toUpperCase())}(r.screenOrientation.type),await t.sendCommand("Emulation.setDeviceMetricsOverride",{mobile:e.baseArtifacts.TestedAsMobileDevice,...r})}}}},t.exports.MAX_SCREENSHOT_HEIGHT=a},{"./gatherer.js":62}],"../gather/gatherers/global-listeners":[function(e,t,r){"use strict";const n=e("./gatherer.js");class GlobalListeners extends n{
static _filterForAllowlistedTypes(e){return"pagehide"===e.type||"unload"===e.type||"visibilitychange"===e.type}getListenerIndentifier(e){return`${e.type}:${e.scriptId}:${e.columnNumber}:${e.lineNumber}`}dedupeListeners(e){const t=new Set;return e.filter(e=>{const r=this.getListenerIndentifier(e);return!t.has(r)&&(t.add(r),!0)})}async afterPass(e){const t=e.driver,{result:{objectId:r}}=await t.sendCommand("Runtime.evaluate",{expression:"window",returnByValue:!1});if(!r)throw new Error("Error fetching information about the global object");const{listeners:n}=await t.sendCommand("DOMDebugger.getEventListeners",{objectId:r}),i=n.filter(GlobalListeners._filterForAllowlistedTypes).map(e=>{const{type:t,scriptId:r,lineNumber:n,columnNumber:i}=e;return{type:t,scriptId:r,lineNumber:n,columnNumber:i}});return this.dedupeListeners(i)}}t.exports=GlobalListeners},{"./gatherer.js":62}],"../gather/gatherers/html-without-javascript":[function(e,t,r){"use strict";const n=e("./gatherer.js")
;t.exports=class HTMLWithoutJavaScript extends n{beforePass(e){e.disableJavaScript=!0}async afterPass(e){e.disableJavaScript=!1;const t=`(${function getBodyText(){const e=document.querySelector("body");return Promise.resolve({bodyText:e?e.innerText:"",hasNoScript:!!document.querySelector("noscript")})}.toString()}())`,{bodyText:r,hasNoScript:n}=await e.driver.evaluateAsync(t);if("string"!=typeof r)throw new Error("document body innerText returned by protocol was not a string");return{bodyText:r,hasNoScript:n}}}},{"./gatherer.js":62}],"../gather/gatherers/http-redirect":[function(e,t,r){"use strict";const n=e("./gatherer.js");t.exports=class HTTPRedirect extends n{constructor(){super(),this._preRedirectURL=""}beforePass(e){this._preRedirectURL=e.url,e.url=this._preRedirectURL.replace(/^https/,"http")}async afterPass(e){e.url=this._preRedirectURL;return{value:await e.driver.evaluateAsync("new URL(window.location).protocol === 'https:'",{useIsolation:!0})}}}},{"./gatherer.js":62}],
"../gather/gatherers/iframe-elements":[function(e,t,r){"use strict";const n=e("./gatherer.js"),i=e("../../lib/page-functions.js");t.exports=class IFrameElements extends n{async afterPass(e){const t=e.driver,r=`(() => {\n      ${i.getElementsInDocumentString};\n      ${i.isPositionFixedString};\n      ${i.getNodeDetailsString};\n      return (${function collectIFrameElements(){return getElementsInDocument("iframe").map(e=>{const t=e.getBoundingClientRect(),{top:r,bottom:n,left:i,right:a,width:s,height:o}=t;return{id:e.id,src:e.src,clientRect:{top:r,bottom:n,left:i,right:a,width:s,height:o},isPositionFixed:isPositionFixed(e),...getNodeDetails(e)}})}})();\n    })()`;return await t.evaluateAsync(r,{useIsolation:!0})}}},{"../../lib/page-functions.js":91,"./gatherer.js":62}],"../gather/gatherers/image-elements":[function(e,t,r){"use strict";const n=e("./gatherer.js"),i=e("../../lib/page-functions.js"),a=(e("../driver.js"),e("./seo/font-size.js"));function getClientRect(e){
const t=e.getBoundingClientRect();return{top:t.top,bottom:t.bottom,left:t.left,right:t.right}}function getPosition(e,t){if(e.parentElement&&"PICTURE"===e.parentElement.tagName){return window.getComputedStyle(e.parentElement).getPropertyValue("position")}return t.getPropertyValue("position")}function getHTMLImages(e){return e.filter(e=>"img"===e.localName).map(e=>{const t=window.getComputedStyle(e),r=!!e.parentElement&&"PICTURE"===e.parentElement.tagName,n=!r&&!e.srcset;return{src:e.currentSrc,srcset:e.srcset,displayedWidth:e.width,displayedHeight:e.height,clientRect:getClientRect(e),naturalWidth:n?e.naturalWidth:0,naturalHeight:n?e.naturalHeight:0,attributeWidth:e.getAttribute("width")||"",attributeHeight:e.getAttribute("height")||"",cssWidth:void 0,cssHeight:void 0,cssComputedPosition:getPosition(e,t),isCss:!1,isPicture:r,loading:e.loading,resourceSize:0,usesObjectFit:["cover","contain","scale-down","none"].includes(t.getPropertyValue("object-fit")),
usesPixelArtScaling:["pixelated","crisp-edges"].includes(t.getPropertyValue("image-rendering")),isInShadowDOM:e.getRootNode()instanceof ShadowRoot,usesSrcSetDensityDescriptor:/ \d+(\.\d+)?x/.test(e.srcset),...getNodeDetails(e)}})}function getCSSImages(e){const t=/^url\("([^"]+)"\)$/,r=[];for(const n of e){const e=window.getComputedStyle(n);if(!e.backgroundImage||!t.test(e.backgroundImage))continue;const i=e.backgroundImage.match(t)[1];r.push({src:i,srcset:"",displayedWidth:n.clientWidth,displayedHeight:n.clientHeight,clientRect:getClientRect(n),naturalWidth:0,naturalHeight:0,attributeWidth:"",attributeHeight:"",cssWidth:void 0,cssHeight:void 0,cssComputedPosition:getPosition(n,e),isCss:!0,isPicture:!1,isInShadowDOM:n.getRootNode()instanceof ShadowRoot,usesObjectFit:!1,usesPixelArtScaling:["pixelated","crisp-edges"].includes(e.getPropertyValue("image-rendering")),usesSrcSetDensityDescriptor:!1,resourceSize:0,...getNodeDetails(n)})}return r}function findSizeDeclaration(e,t){if(!e)return
;const r=e.cssProperties.find(({name:e})=>e===t);return r?r.value:void 0}function getEffectiveSizingRule({attributesStyle:e,inlineStyle:t,matchedCSSRules:r},n){const i=findSizeDeclaration(t,n);if(i)return i;const s=findSizeDeclaration(e,n);if(s)return s;const o=function findMostSpecificCSSRule(e,t){const r=a.findMostSpecificMatchedCSSRule(e,e=>findSizeDeclaration(e,t));if(r)return findSizeDeclaration(r.style,t)}(r,n);return o||void 0}t.exports=class ImageElements extends n{constructor(){super(),this._naturalSizeCache=new Map}async fetchElementWithSizeInformation(e,t){const r=JSON.stringify(t.src);if(this._naturalSizeCache.has(r))return Object.assign(t,this._naturalSizeCache.get(r));try{e.setNextProtocolTimeout(250);const n=await e.evaluateAsync(`(${function determineNaturalSize(e){return new Promise((t,r)=>{const n=new Image;n.addEventListener("error",e=>r(new Error("determineNaturalSize failed img load"))),n.addEventListener("load",()=>{t({naturalWidth:n.naturalWidth,
naturalHeight:n.naturalHeight})}),n.src=e})}.toString()})(${r})`);return this._naturalSizeCache.set(r,n),Object.assign(t,n)}catch(e){return t}}async fetchSourceRules(e,t,r){try{const{nodeId:n}=await e.sendCommand("DOM.pushNodeByPathToFrontend",{path:t});if(!n)return;const i=await e.sendCommand("CSS.getMatchedStylesForNode",{nodeId:n}),a={cssWidth:getEffectiveSizingRule(i,"width"),cssHeight:getEffectiveSizingRule(i,"height")};Object.assign(r,a)}catch(e){if(/No node.*found/.test(e.message))return;throw e}}async afterPass(e,t){const r=e.driver,n=t.networkRecords.reduce((e,t)=>(/^image/.test(t.mimeType)&&t.finished&&200===t.statusCode&&(e[t.url]=t),
e),{}),a=`(function() {\n      ${i.getElementsInDocumentString}; // define function on page\n      ${i.getBoundingClientRectString};\n      ${i.getNodeDetailsString};\n      ${getClientRect.toString()};\n      ${getPosition.toString()};\n      ${getHTMLImages.toString()};\n      ${getCSSImages.toString()};\n      ${function collectImageElementInfo(){const e=getElementsInDocument();return getHTMLImages(e).concat(getCSSImages(e))}.toString()};\n\n      return collectImageElementInfo();\n    })()`,s=await r.evaluateAsync(a),o=[],l=Object.values(n).sort((e,t)=>t.resourceSize-e.resourceSize).slice(0,50);await Promise.all([r.sendCommand("DOM.enable"),r.sendCommand("CSS.enable"),r.sendCommand("DOM.getDocument",{depth:-1,pierce:!0})]);for(let e of s){const t=n[e.src]||{};e.mimeType=t.mimeType;const{resourceSize:i=0,transferSize:a=0}=t;e.resourceSize=Math.min(i,a),e.isInShadowDOM||e.isCss||await this.fetchSourceRules(r,e.devtoolsNodePath,e),
(e.isPicture||e.isCss||e.srcset)&&l.includes(t)&&(e=await this.fetchElementWithSizeInformation(r,e)),o.push(e)}return await Promise.all([r.sendCommand("DOM.disable"),r.sendCommand("CSS.disable")]),o}}},{"../../lib/page-functions.js":91,"../driver.js":59,"./gatherer.js":62,"./seo/font-size.js":"../gather/gatherers/seo/font-size"}],"../gather/gatherers/inspector-issues":[function(e,t,r){"use strict";const n=e("./gatherer.js");t.exports=class InspectorIssues extends n{constructor(){super(),this._issues=[],this._onIssueAdded=this.onIssueAdded.bind(this)}onIssueAdded(e){this._issues.push(e.issue)}async beforePass(e){const t=e.driver;t.on("Audits.issueAdded",this._onIssueAdded),await t.sendCommand("Audits.enable")}async afterPass(e,t){const r=e.driver,n=t.networkRecords;r.off("Audits.issueAdded",this._onIssueAdded),await r.sendCommand("Audits.disable");const i={mixedContent:[]};for(const e of this._issues)if(e.details.mixedContentIssueDetails){
const t=e.details.mixedContentIssueDetails,r=t.request&&t.request.requestId;r&&n.find(e=>e.requestId===r)&&i.mixedContent.push(e.details.mixedContentIssueDetails)}return i}}},{"./gatherer.js":62}],"../gather/gatherers/js-usage":[function(e,t,r){"use strict";const n=e("./gatherer.js");t.exports=class JsUsage extends n{constructor(){super(),this._scriptParsedEvents=[],this.onScriptParsed=this.onScriptParsed.bind(this)}onScriptParsed(e){e.embedderName&&this._scriptParsedEvents.push(e)}async beforePass(e){await e.driver.sendCommand("Profiler.enable"),await e.driver.sendCommand("Profiler.startPreciseCoverage",{detailed:!1}),await e.driver.sendCommand("Debugger.enable"),await e.driver.on("Debugger.scriptParsed",this.onScriptParsed)}async afterPass(e){const t=e.driver,r=(await t.sendCommand("Profiler.takePreciseCoverage")).result;await t.sendCommand("Profiler.stopPreciseCoverage"),await t.sendCommand("Profiler.disable"),await e.driver.sendCommand("Debugger.disable");const n={}
;for(const e of r){let t=e.url;const r=this._scriptParsedEvents.find(t=>t.scriptId===e.scriptId);if(r&&r.embedderName&&(t=r.embedderName),""===e.url||r&&""===r.embedderName)continue;const i=n[t]||[];i.push(e),n[t]=i}return n}}},{"./gatherer.js":62}],"../gather/gatherers/link-elements":[function(e,t,r){"use strict";const n=e("http-link-header"),i=e("./gatherer.js"),{URL:a}=e("../../lib/url-shim.js"),s=e("../../lib/dependency-graph/simulator/network-analyzer.js"),{getElementsInDocumentString:o,getNodeDetailsString:l}=e("../../lib/page-functions.js");function normalizeUrlOrNull(e,t){try{return new a(e,t).href}catch(e){return null}}class LinkElements extends i{static getLinkElementsInDOM(e){return e.driver.evaluateAsync(`(() => {\n      ${o};\n      ${function getLinkElementsInDOM(){const e=getElementsInDocument("link"),t=[];for(const r of e){if(!(r instanceof HTMLLinkElement))continue;const e=r.getAttribute("href")||"",n=r.closest("head")?"head":"body";t.push({rel:r.rel,href:r.href,
hreflang:r.hreflang,as:r.as,crossOrigin:r.crossOrigin,hrefRaw:e,source:n,...getNodeDetails(r)})}return t}};\n      ${l};\n\n      return getLinkElementsInDOM();\n    })()`,{useIsolation:!0})}static getLinkElementsInHeaders(e,t){const r=e.url,i=t.networkRecords,a=s.findMainDocument(i,r),o=[];for(const e of a.responseHeaders)if("link"===e.name.toLowerCase())for(const t of n.parse(e.value).refs)o.push({rel:t.rel||"",href:normalizeUrlOrNull(t.uri,r),hrefRaw:t.uri||"",hreflang:t.hreflang||"",as:t.as||"",crossOrigin:(l=t.crossorigin,"anonymous"===l?"anonymous":"use-credentials"===l?"use-credentials":null),source:"headers",devtoolsNodePath:"",selector:"",nodeLabel:"",boundingRect:null,snippet:""});var l;return o}async afterPass(e,t){const r=await LinkElements.getLinkElementsInDOM(e),n=LinkElements.getLinkElementsInHeaders(e,t),i=r.concat(n);for(const e of i)e.rel=e.rel.toLowerCase();return i}}t.exports=LinkElements},{"../../lib/dependency-graph/simulator/network-analyzer.js":74,
"../../lib/page-functions.js":91,"../../lib/url-shim.js":"url","./gatherer.js":62,"http-link-header":125}],"../gather/gatherers/main-document-content":[function(e,t,r){"use strict";const n=e("./gatherer.js"),i=e("../../lib/dependency-graph/simulator/network-analyzer.js");t.exports=class MainDocumentContent extends n{async afterPass(e,t){const r=i.findMainDocument(t.networkRecords,e.url);return e.driver.getRequestContent(r.requestId)}}},{"../../lib/dependency-graph/simulator/network-analyzer.js":74,"./gatherer.js":62}],"../gather/gatherers/meta-elements":[function(e,t,r){"use strict";const n=e("./gatherer.js"),i=e("../../lib/page-functions.js").getElementsInDocumentString;t.exports=class MetaElements extends n{async afterPass(e){
return e.driver.evaluateAsync(`(() => {\n      ${i};\n\n      return getElementsInDocument('head meta').map(meta => {\n        return {\n          name: meta.name.toLowerCase(),\n          content: meta.content,\n          property: meta.attributes.property ? meta.attributes.property.value : undefined,\n          httpEquiv: meta.httpEquiv ? meta.httpEquiv.toLowerCase() : undefined,\n          charset: meta.attributes.charset ? meta.attributes.charset.value : undefined,\n        };\n      });\n    })()`,{useIsolation:!0})}}},{"../../lib/page-functions.js":91,"./gatherer.js":62}],"../gather/gatherers/offline":[function(e,t,r){"use strict";const n=e("./gatherer.js"),i=e("../../lib/url-shim.js");t.exports=class Offline extends n{beforePass(e){return e.driver.goOffline()}async afterPass(e,t){const r=t.networkRecords.filter(t=>i.equalWithExcludedFragments(t.url,e.url)&&t.fetchedViaServiceWorker).pop();return r?r.statusCode:-1}}},{"../../lib/url-shim.js":"url","./gatherer.js":62}],
"../gather/gatherers/runtime-exceptions":[function(e,t,r){"use strict";const n=e("./gatherer.js");t.exports=class RuntimeExceptions extends n{constructor(){super(),this._exceptions=[],this._onRuntimeExceptionThrown=this.onRuntimeExceptionThrown.bind(this)}onRuntimeExceptionThrown(e){this._exceptions.push(e)}beforePass(e){e.driver.on("Runtime.exceptionThrown",this._onRuntimeExceptionThrown)}async afterPass(e){return await e.driver.off("Runtime.exceptionThrown",this._onRuntimeExceptionThrown),this._exceptions}}},{"./gatherer.js":62}],"../gather/gatherers/script-elements":[function(e,t,r){"use strict";const n=e("./gatherer.js"),i=e("../../lib/dependency-graph/simulator/network-analyzer.js"),a=e("../../lib/network-request.js"),s=e("../../lib/page-functions.js").getElementsInDocumentString,o=e("../../lib/page-functions.js");t.exports=class ScriptElements extends n{async afterPass(e,t){
const r=e.driver,n=i.findMainDocument(t.networkRecords,e.url),l=await r.evaluateAsync(`(() => {\n      ${s}\n      ${o.getNodeDetailsString};\n      return (${function collectAllScriptElements(){return getElementsInDocument("script").map(e=>({type:e.type||null,src:e.src||null,id:e.id||null,async:e.async,defer:e.defer,source:e.closest("head")?"head":"body",...getNodeDetails(e),content:e.src?null:e.text,requestId:null}))}.toString()})();\n    })()`,{useIsolation:!0});for(const e of l)e.content&&(e.requestId=n.requestId);const c=t.networkRecords.filter(e=>!e.sessionId).filter(e=>e.resourceType===a.TYPES.Script),u=await async function runInSeriesOrParallel(e,t,r){if(r){const r=[];for(const n of e){const e=await t(n);r.push(e)}return r}{const r=e.map(t);return await Promise.all(r)}}(c,e=>r.getRequestContent(e.requestId).catch(()=>""),"mobile"===e.baseArtifacts.HostFormFactor);for(let e=0;e<c.length;e++){const t=c[e],r=u[e];if(!r)continue;const n=l.find(e=>e.src===t.url)
;n?(n.requestId=t.requestId,n.content=r):l.push({devtoolsNodePath:"",snippet:"",selector:"",nodeLabel:"",boundingRect:null,type:null,src:t.url,id:null,async:!1,defer:!1,source:"network",requestId:t.requestId,content:r})}return l}}},{"../../lib/dependency-graph/simulator/network-analyzer.js":74,"../../lib/network-request.js":90,"../../lib/page-functions.js":91,"./gatherer.js":62}],"../gather/gatherers/seo/embedded-content":[function(e,t,r){"use strict";const n=e("../gatherer.js"),i=e("../../../lib/page-functions.js");t.exports=class EmbeddedContent extends n{afterPass(e){
const t=`(function() {\n      ${i.getElementsInDocumentString}; // define function on page\n      const selector = 'object, embed, applet';\n      const elements = getElementsInDocument(selector);\n      return elements\n        .map(node => ({\n          tagName: node.tagName,\n          type: node.getAttribute('type'),\n          src: node.getAttribute('src'),\n          data: node.getAttribute('data'),\n          code: node.getAttribute('code'),\n          params: Array.from(node.children)\n            .filter(el => el.tagName === 'PARAM')\n            .map(el => ({\n              name: el.getAttribute('name') || '',\n              value: el.getAttribute('value') || '',\n            })),\n        }));\n    })()`;return e.driver.evaluateAsync(t)}}},{"../../../lib/page-functions.js":91,"../gatherer.js":62}],"../gather/gatherers/seo/font-size":[function(e,t,r){"use strict";const n=e("../gatherer.js"),i="font-size",a=12,s=50;function hasFontSizeDeclaration(e){
return!!e&&!!e.cssProperties.find(({name:e})=>e===i)}function computeSelectorSpecificity(e){const t=e.split(" ");let r=0,n=0,i=0;for(const e of t){const t=e.match(/\b#[a-z0-9]+/g)||[],a=e.match(/\b\.[a-z0-9]+/g)||[],s=e.match(/^[a-z]+/)?[1]:[];r+=t.length,n+=a.length,i+=s.length}return 100*Math.min(9,r)+10*Math.min(9,n)+Math.min(9,i)}function findMostSpecificMatchedCSSRule(e=[],t){let r,n=-1/0;for(const{rule:i,matchingSelectors:a}of e)if(t(i.style)){const e=a.map(e=>computeSelectorSpecificity(i.selectorList.selectors[e].text)),t=Math.max(...e);t>=n&&(n=t,r=i)}if(r)return{type:"Regular",...r.style,parentRule:{origin:r.origin,selectors:r.selectorList.selectors}}}function getEffectiveFontRule({attributesStyle:e,inlineStyle:t,matchedCSSRules:r,inherited:n}){if(hasFontSizeDeclaration(t))return{type:"Inline",...t};const i=findMostSpecificMatchedCSSRule(r,hasFontSizeDeclaration);if(i)return i;if(hasFontSizeDeclaration(e))return{type:"Attributes",...e}
;const a=function findInheritedCSSRule(e=[]){for(const{inlineStyle:t,matchedCSSRules:r}of e){if(hasFontSizeDeclaration(t))return{type:"Inline",...t};const e=findMostSpecificMatchedCSSRule(r,hasFontSizeDeclaration);if(e)return e}}(n);return a||void 0}function getTextLength(e){return e?Array.from(e.trim()).length:0}class FontSize extends n{static async fetchFailingNodeSourceRules(e,t){const r=t.sort((e,t)=>t.textLength-e.textLength).slice(0,s);await e.sendCommand("DOM.getDocument",{depth:-1,pierce:!0});const{nodeIds:n}=await e.sendCommand("DOM.pushNodesByBackendIdsToFrontend",{backendNodeIds:r.map(e=>e.parentNode.backendNodeId)}),i=r.map(async(t,r)=>{t.nodeId=n[r];try{const i=await async function fetchSourceRule(e,t){const r=getEffectiveFontRule(await e.sendCommand("CSS.getMatchedStylesForNode",{nodeId:t}));if(r)return{type:r.type,range:r.range,styleSheetId:r.styleSheetId,parentRule:r.parentRule&&{origin:r.parentRule.origin,selectors:r.parentRule.selectors}}}(e,n[r]);t.cssRule=i
}catch(e){t.cssRule=void 0}return t}),a=await Promise.all(i),o=a.reduce((e,{textLength:t})=>e+=t,0);return{analyzedFailingNodesData:a,analyzedFailingTextLength:o}}getTextNodesInLayoutFromSnapshot(e){const t=e.strings,r=e=>t[e],n=e=>parseFloat(t[e]),i=[];for(let a=0;a<e.documents.length;a++){const s=e.documents[a];if(!(s.nodes.backendNodeId&&s.nodes.parentIndex&&s.nodes.attributes&&s.nodes.nodeName))throw new Error("Unexpected response from DOMSnapshot.captureSnapshot.");const o=s.nodes,l=e=>({backendNodeId:o.backendNodeId[e],attributes:o.attributes[e].map(r),nodeName:r(o.nodeName[e])});for(const e of s.textBoxes.layoutIndex){const r=t[s.layout.text[e]];if(!r)continue;const a=s.layout.nodeIndex[e],c=s.layout.styles[e],[u]=c,d=n(u),m=o.parentIndex[a],p=o.parentIndex[m],h=l(m),g=void 0!==p?l(p):void 0;i.push({nodeIndex:a,backendNodeId:o.backendNodeId[a],fontSize:d,textLength:getTextLength(r),parentNode:{...h,parentNode:g}})}}return i}findFailingNodes(e){const t=[];let r=0,n=0
;for(const i of this.getTextNodesInLayoutFromSnapshot(e))r+=i.textLength,i.fontSize<a&&(n+=i.textLength,t.push({nodeId:0,parentNode:i.parentNode,textLength:i.textLength,fontSize:i.fontSize}));return{totalTextLength:r,failingTextLength:n,failingNodes:t}}async afterPass(e){const t=new Map,r=e=>t.set(e.header.styleSheetId,e.header);e.driver.on("CSS.styleSheetAdded",r),await Promise.all([e.driver.sendCommand("DOMSnapshot.enable"),e.driver.sendCommand("DOM.enable"),e.driver.sendCommand("CSS.enable")]);const n=await e.driver.sendCommand("DOMSnapshot.captureSnapshot",{computedStyles:["font-size"]}),{totalTextLength:i,failingTextLength:a,failingNodes:s}=this.findFailingNodes(n),{analyzedFailingNodesData:o,analyzedFailingTextLength:l}=await FontSize.fetchFailingNodeSourceRules(e.driver,s);return e.driver.off("CSS.styleSheetAdded",r),o.filter(e=>e.cssRule&&e.cssRule.styleSheetId).forEach(e=>e.cssRule.stylesheet=t.get(e.cssRule.styleSheetId)),
await Promise.all([e.driver.sendCommand("DOMSnapshot.disable"),e.driver.sendCommand("DOM.disable"),e.driver.sendCommand("CSS.disable")]),{analyzedFailingNodesData:o,analyzedFailingTextLength:l,failingTextLength:a,totalTextLength:i}}}t.exports=FontSize,t.exports.computeSelectorSpecificity=computeSelectorSpecificity,t.exports.getEffectiveFontRule=getEffectiveFontRule,t.exports.findMostSpecificMatchedCSSRule=findMostSpecificMatchedCSSRule},{"../gatherer.js":62}],"../gather/gatherers/seo/robots-txt":[function(e,t,r){"use strict";const n=e("../gatherer.js");t.exports=class RobotsTxt extends n{afterPass(e){return e.driver.evaluateAsync(`(${async function getRobotsTxtContent(){try{const e=await fetch(new URL("/robots.txt",location.href).href);if(!e.ok)return{status:e.status,content:null};const t=await e.text();return{status:e.status,content:t}}catch(e){return{status:null,content:null}}}.toString()}())`,{useIsolation:!0})}}},{"../gatherer.js":62}],
"../gather/gatherers/seo/tap-targets":[function(e,t,r){"use strict";const n=e("../gatherer.js"),i=e("../../../lib/page-functions.js"),a=e("../../../lib/rect-helpers.js"),s=["button","a","input","textarea","select","option","[role=button]","[role=checkbox]","[role=link]","[role=menuitem]","[role=menuitemcheckbox]","[role=menuitemradio]","[role=option]","[role=scrollbar]","[role=slider]","[role=spinbutton]"].join(",");function elementIsVisible(e){return!!(e.offsetWidth||e.offsetHeight||e.getClientRects().length)}function getClientRects(e){const t=Array.from(e.getClientRects()).map(e=>{const{width:t,height:r,left:n,top:i,right:a,bottom:s}=e;return{width:t,height:r,left:n,top:i,right:a,bottom:s}});for(const r of e.children)t.push(...getClientRects(r));return t}function elementHasAncestorTapTarget(e,t){return!!e.parentElement&&(!!e.parentElement.matches(t)||elementHasAncestorTapTarget(e.parentElement,t))}function hasTextNodeSiblingsFormingTextBlock(e){if(!e.parentElement)return!1
;const t=e.parentElement,r=e.textContent||"";if((t.textContent||"").length-r.length<5)return!1;for(const t of e.parentElement.childNodes){if(t===e)continue;const r=(t.textContent||"").trim();if(t.nodeType===Node.TEXT_NODE&&r.length>0)return!0}return!1}function elementIsInTextBlock(e){const{display:t}=getComputedStyle(e);return("inline"===t||"inline-block"===t)&&(!!hasTextNodeSiblingsFormingTextBlock(e)||!!e.parentElement&&elementIsInTextBlock(e.parentElement))}function elementCenterIsAtZAxisTop(e,t){const r=window.innerHeight,n=Math.floor(t.y/r)*r;window.scrollY!==n&&window.scrollTo(0,n);const i=document.elementFromPoint(t.x,t.y-window.scrollY);return i===e||e.contains(i)}function disableFixedAndStickyElementPointerEvents(){const e="lighthouse-disable-pointer-events",t=document.createElement("style");return t.textContent=`.${e} { pointer-events: none !important }`,document.body.appendChild(t),document.querySelectorAll("*").forEach(t=>{const r=getComputedStyle(t).position
;"fixed"!==r&&"sticky"!==r||t.classList.add(e)}),function undo(){Array.from(document.getElementsByClassName(e)).forEach(t=>{t.classList.remove(e)}),t.remove()}}t.exports=class TapTargets extends n{afterPass(e){const t=`(function() {\n      ${i.getElementsInDocumentString};\n      ${disableFixedAndStickyElementPointerEvents.toString()};\n      ${elementIsVisible.toString()};\n      ${elementHasAncestorTapTarget.toString()};\n      ${elementCenterIsAtZAxisTop.toString()}\n      ${getClientRects.toString()};\n      ${hasTextNodeSiblingsFormingTextBlock.toString()};\n      ${elementIsInTextBlock.toString()};\n      ${a.getRectCenterPoint.toString()};\n      ${i.getNodeDetailsString};\n      ${function gatherTapTargets(e){const t=[];window.scrollTo(0,0);const r=getElementsInDocument(e),n=[];r.forEach(t=>{elementHasAncestorTapTarget(t,e)||elementIsInTextBlock(t)||elementIsVisible(t)&&n.push({tapTargetElement:t,clientRects:getClientRects(t)})})
;const i=disableFixedAndStickyElementPointerEvents(),a=[];n.forEach(({tapTargetElement:e,clientRects:t})=>{let r=t.filter(e=>0!==e.width&&0!==e.height);(r=r.filter(t=>{const r=getRectCenterPoint(t);return elementCenterIsAtZAxisTop(e,r)})).length>0&&a.push({tapTargetElement:e,visibleClientRects:r})});for(const{tapTargetElement:e,visibleClientRects:r}of a)t.push({clientRects:r,href:e.href||"",...getNodeDetails(e)});return i(),t}.toString()};\n\n      return gatherTapTargets("${s}");\n    })()`;return e.driver.evaluateAsync(t,{useIsolation:!0})}}},{"../../../lib/page-functions.js":91,"../../../lib/rect-helpers.js":92,"../gatherer.js":62}],"../gather/gatherers/service-worker":[function(e,t,r){"use strict";const n=e("./gatherer.js");t.exports=class ServiceWorker extends n{async beforePass(e){const{versions:t}=await e.driver.getServiceWorkerVersions(),{registrations:r}=await e.driver.getServiceWorkerRegistrations();return{versions:t,registrations:r}}}},{"./gatherer.js":62}],
"../gather/gatherers/source-maps":[function(e,t,r){(function(r){"use strict";const n=e("./gatherer.js"),i=e("../../lib/url-shim.js");t.exports=class SourceMaps extends n{constructor(){super(),this._scriptParsedEvents=[],this.onScriptParsed=this.onScriptParsed.bind(this)}async fetchSourceMap(e,t){const r=await e.fetcher.fetchResource(t,{timeout:1500});return JSON.parse(r)}parseSourceMapFromDataUrl(e){const t=r.from(e.split(",")[1],"base64");return JSON.parse(t.toString())}onScriptParsed(e){e.sourceMapURL&&this._scriptParsedEvents.push(e)}async beforePass(e){const t=e.driver;t.on("Debugger.scriptParsed",this.onScriptParsed),await t.sendCommand("Debugger.enable")}_resolveUrl(e,t){try{return new i(e,t).href}catch(e){return}}async _retrieveMapFromScriptParsedEvent(e,t){if(!t.sourceMapURL)throw new Error("precondition failed: event.sourceMapURL should exist");const r=t.sourceMapURL.startsWith("data:"),n=t.url,i=r?t.sourceMapURL:this._resolveUrl(t.sourceMapURL,t.url);if(!i)return{scriptUrl:n,
errorMessage:`Could not resolve map url: ${t.sourceMapURL}`};const a=r?void 0:i;try{const t=r?this.parseSourceMapFromDataUrl(i):await this.fetchSourceMap(e,i);return t.sections&&(t.sections=t.sections.filter(e=>e.map)),{scriptUrl:n,sourceMapUrl:a,map:t}}catch(e){return{scriptUrl:n,sourceMapUrl:a,errorMessage:e.toString()}}}async afterPass(e){const t=e.driver;t.off("Debugger.scriptParsed",this.onScriptParsed),await t.sendCommand("Debugger.disable"),await t.fetcher.enableRequestInterception();const r=this._scriptParsedEvents.map(e=>this._retrieveMapFromScriptParsedEvent(t,e));return Promise.all(r)}}}).call(this,e("buffer").Buffer)},{"../../lib/url-shim.js":"url","./gatherer.js":62,buffer:120}],"../gather/gatherers/start-url":[function(e,t,r){"use strict";const n=e("./gatherer.js"),i=e("../../lib/url-shim.js");t.exports=class StartUrl extends n{async afterPass(e){await e.driver.goOffline();const t=await this._determineStartUrlAvailability(e);return await e.driver.goOnline(e),t}
async _determineStartUrlAvailability(e){const t=e.baseArtifacts.WebAppManifest,r=this._readManifestStartUrl(t);if(r.isReadFailure)return{statusCode:-1,explanation:r.reason};try{const t=await this._attemptStartURLFetch(e.driver,r.startUrl);return{url:r.startUrl,...t}}catch(e){return{url:r.startUrl,statusCode:-1,explanation:"Error while fetching start_url via service worker."}}}_readManifestStartUrl(e){if(!e||!e.value){const t=e&&e.warning;return t?{isReadFailure:!0,reason:`Error fetching web app manifest: ${t}.`}:{isReadFailure:!0,reason:"No usable web app manifest found on page."}}return{isReadFailure:!1,startUrl:e.value.start_url.value}}_attemptStartURLFetch(e,t){const r=new Promise(e=>setTimeout(()=>e({statusCode:-1,explanation:`Timed out waiting for start_url (${t}) to respond.`}),3e3)),n=new Promise(r=>{e.on("Network.responseReceived",function onResponseReceived(n){const{response:a}=n;if(!i.equalWithExcludedFragments(a.url,t))return
;e.off("Network.responseReceived",onResponseReceived);if(!a.fromServiceWorker)return r({statusCode:-1,explanation:"The start_url did respond, but not via a service worker."});return r({statusCode:a.status})})});return e.evaluateAsync(`window.location = '${t}'`).then(()=>Promise.race([n,r]))}}},{"../../lib/url-shim.js":"url","./gatherer.js":62}],"../gather/gatherers/trace-elements":[function(e,t,r){"use strict";const n=e("./gatherer.js"),i=e("../../lib/page-functions.js"),a=e("../../lib/tracehouse/trace-processor.js"),s=e("../../lib/rect-helpers.js"),o=e("../../lib/sentry.js");function getNodeDetailsData(){const e=this.nodeType===document.ELEMENT_NODE?this:this.parentElement;let t;return e&&(t=getNodeDetails(e)),t}class TraceElements extends n{static getNodeIDFromTraceEvent(e){return e&&e.args&&e.args.data&&e.args.data.nodeId}static getAnimationIDFromTraceEvent(e){return e&&e.args&&e.args.data&&e.args.data.id}static getFailureReasonsFromTraceEvent(e){
return e&&e.args&&e.args.data&&e.args.data.compositeFailed}static getUnsupportedPropertiesFromTraceEvent(e){return e&&e.args&&e.args.data&&e.args.data.unsupportedProperties}static traceRectToLHRect(e){const t={x:e[0],y:e[1],width:e[2],height:e[3]};return s.addRectTopAndBottom(t)}static async resolveAnimationName(e,t){const r=e.driver;try{const e=(await r.sendCommand("Animation.resolveAnimation",{animationId:t})).remoteObject.objectId;if(!e)return;const n=(await r.sendCommand("Runtime.getProperties",{objectId:e})).result.find(e=>"animationName"===e.name),i=n&&n.value&&n.value.value;if(""===i)return;return i}catch(e){return void o.captureException(e,{tags:{gatherer:TraceElements.name},level:"error"})}}static getTopLayoutShiftElements(e){const t=new Map,r=e.filter(e=>"LayoutShift"===e.name).map(e=>e.args&&e.args.data),n=r.findIndex(e=>e&&!e.had_recent_input);return r.forEach((e,r)=>{if(!e||!e.impacted_nodes||!e.score)return;if(-1!==n&&r>=n&&e.had_recent_input)return;let i=0
;const a=new Map;e.impacted_nodes.forEach(e=>{if(!e.node_id||!e.old_rect||!e.new_rect)return;const t=TraceElements.traceRectToLHRect(e.old_rect),r=TraceElements.traceRectToLHRect(e.new_rect),n=s.getRectArea(t)+s.getRectArea(r)-s.getRectOverlapArea(t,r);a.set(e.node_id,n),i+=n});for(const[r,n]of a.entries()){let a=t.get(r)||0;a+=n/i*e.score,t.set(r,a)}}),[...t.entries()].sort((e,t)=>t[1]-e[1]).slice(0,5).map(([e,t])=>({nodeId:e,score:t}))}static async getAnimatedElements(e,t){const r=new Map;for(const e of t){if("Animation"!==e.name)continue;if(!e.id2||!e.id2.local)continue;const t=e.id2.local,n=r.get(t)||{begin:void 0,status:void 0};"b"===e.ph?n.begin=e:"n"===e.ph&&e.args.data&&void 0!==e.args.data.compositeFailed&&(n.status=e),r.set(t,n)}const n=new Map;for(const{begin:e,status:t}of r.values()){const r=this.getNodeIDFromTraceEvent(e),i=this.getAnimationIDFromTraceEvent(e),a=this.getFailureReasonsFromTraceEvent(t),s=this.getUnsupportedPropertiesFromTraceEvent(t);if(!r||!i)continue
;const o=n.get(r)||new Set;o.add({animationId:i,failureReasonsMask:a,unsupportedProperties:s}),n.set(r,o)}const i=[];for(const[t,r]of n){const n=[];for(const{animationId:t,failureReasonsMask:i,unsupportedProperties:a}of r){const r=await this.resolveAnimationName(e,t);n.push({name:r,failureReasonsMask:i,unsupportedProperties:a})}i.push({nodeId:t,animations:n})}return i}async beforePass(e){await e.driver.sendCommand("Animation.enable")}async afterPass(e,t){const r=e.driver;if(!t.trace)throw new Error("Trace is missing!");const{largestContentfulPaintEvt:n,mainThreadEvents:s}=a.computeTraceOfTab(t.trace),l=TraceElements.getNodeIDFromTraceEvent(n),c=TraceElements.getTopLayoutShiftElements(s),u=await TraceElements.getAnimatedElements(e,s),d=new Map([["largest-contentful-paint",l?[{nodeId:l}]:[]],["layout-shift",c],["animation",u]]),m=[];for(const[e,t]of d)for(let n=0;n<t.length;n++){const a=t[n].nodeId;let s;try{const e=await r.resolveNodeIdToObjectId(a);if(!e)continue
;s=await r.sendCommand("Runtime.callFunctionOn",{objectId:e,functionDeclaration:`function () {\n              ${getNodeDetailsData.toString()};\n              ${i.getNodeDetailsString};\n              return getNodeDetailsData.call(this);\n            }`,returnByValue:!0,awaitPromise:!0})}catch(e){o.captureException(e,{tags:{gatherer:this.name},level:"error"});continue}s&&s.result&&s.result.value&&m.push({traceEventType:e,...s.result.value,score:t[n].score,animations:t[n].animations,nodeId:a})}return await r.sendCommand("Animation.disable"),m}}t.exports=TraceElements},{"../../lib/page-functions.js":91,"../../lib/rect-helpers.js":92,"../../lib/sentry.js":93,"../../lib/tracehouse/trace-processor.js":101,"./gatherer.js":62}],"../gather/gatherers/viewport-dimensions":[function(e,t,r){"use strict";const n=e("./gatherer.js");t.exports=class ViewportDimensions extends n{async afterPass(e){const t=e.driver,r=await t.evaluateAsync(`(${function getViewportDimensions(){return Promise.resolve({
innerWidth:window.innerWidth,innerHeight:window.innerHeight,outerWidth:window.outerWidth,outerHeight:window.outerHeight,devicePixelRatio:window.devicePixelRatio})}.toString()}())`,{useIsolation:!0});if(!Object.values(r).every(Number.isFinite)){const e=JSON.stringify(r);throw new Error(`ViewportDimensions results were not numeric: ${e}`)}return r}}},{"./gatherer.js":62}],1:[function(e,t,r){(function(r){"use strict";const n=e("../lighthouse-core/index.js"),i=e("../lighthouse-core/gather/connections/raw.js"),a=e("lighthouse-logger"),{registerLocaleData:s,lookupLocale:o}=e("../lighthouse-core/lib/i18n/i18n.js"),l=e("../lighthouse-core/config/constants.js").throttling.desktopDense4G;void 0!==t&&t.exports&&(r.runBundledLighthouse=n),"undefined"!=typeof self&&(r.isDevtools=!0,self.setUpWorkerConnection=function setUpWorkerConnection(e){return new i(e)},self.runLighthouse=n,self.createConfig=function createConfig(e,t){const r={onlyCategories:e};return"desktop"===t&&(r.throttling=l),{
extends:"lighthouse:default",plugins:["lighthouse-plugin-publisher-ads"],settings:r}},self.listenForStatus=function listenForStatus(e){a.events.addListener("status",e)},self.registerLocaleData=s,self.lookupLocale=o)}).call(this,"undefined"!=typeof global?global:"undefined"!=typeof self?self:"undefined"!=typeof window?window:{})},{"../lighthouse-core/config/constants.js":54,"../lighthouse-core/gather/connections/raw.js":57,"../lighthouse-core/index.js":63,"../lighthouse-core/lib/i18n/i18n.js":78,"lighthouse-logger":141}],2:[function(e,t,r){(function(r){"use strict";const n=e("../audit.js"),i=e("../../lib/i18n/i18n.js"),a={failingElementsHeader:"Failing Elements"},s=i.createMessageInstanceIdFn(r,a);t.exports=class AxeAudit extends n{static audit(e){if((e.Accessibility.notApplicable||[]).find(e=>e.id===this.meta.id))return{score:1,notApplicable:!0};const t=e.Accessibility.incomplete||[],r=t.find(e=>e.id===this.meta.id);if(r&&r.error)return{score:null,
errorMessage:`axe-core Error: ${r.error.message||"Unknown error"}`};const i=this.meta.scoreDisplayMode===n.SCORING_MODES.INFORMATIVE,o=e.Accessibility.violations||[],l=(i?o.concat(t):o).find(e=>e.id===this.meta.id),c=l&&l.impact,u=l&&l.tags;if(i&&!l)return{score:1,notApplicable:!0};let d=[];l&&l.nodes&&(d=l.nodes.map(e=>({node:{type:"node",selector:e.selector,path:e.devtoolsNodePath,snippet:e.snippet,boundingRect:e.boundingRect,explanation:e.failureSummary,nodeLabel:e.nodeLabel}})));const m=[{key:"node",itemType:"node",text:s(a.failingElementsHeader)}];let p;return(c||u)&&(p={type:"debugdata",impact:c,tags:u}),{score:Number(void 0===l),details:{...n.makeTableDetails(m,d),debugData:p}}}},t.exports.UIStrings=a}).call(this,"/lighthouse-core/audits/accessibility/axe-audit.js")},{"../../lib/i18n/i18n.js":78,"../audit.js":3}],3:[function(e,t,r){"use strict"
;const{isUnderTest:n}=e("../lib/lh-env.js"),i=e("../lib/statistics.js"),a=e("../report/html/renderer/util.js"),s="defaultPass",o=e=>Math.round(100*e)/100;class Audit{static get DEFAULT_PASS(){return s}static get SCORING_MODES(){return{NUMERIC:"numeric",BINARY:"binary",MANUAL:"manual",INFORMATIVE:"informative",NOT_APPLICABLE:"notApplicable",ERROR:"error"}}static get meta(){throw new Error("Audit meta information must be overridden.")}static get defaultOptions(){return{}}static audit(e,t){throw new Error("audit() method must be overriden")}static computeLogNormalScore(e,t){const r=i.getLogNormalScore(e,t);return o(r)}static assertHeadingKeysExist(e,t){if(t.length&&n)for(const r of e){if(null===r.key)continue;const e=r.key;if(!t.some(t=>e in t))throw new Error(`"${r.key}" is missing from items`)}}static makeTableDetails(e,t,r){return 0===t.length?{type:"table",headings:[],items:[],summary:r}:(Audit.assertHeadingKeysExist(e,t),{type:"table",headings:e,items:t,summary:r})}
static makeListDetails(e){return{type:"list",items:e}}static makeSnippetDetails({content:e,title:t,lineMessages:r,generalMessages:n,node:i,maxLineLength:s=200,maxLinesAroundMessage:o=20}){const l=Audit._makeSnippetLinesArray(e,s);return{type:"snippet",lines:a.filterRelevantLines(l,r,o),title:t,lineMessages:r,generalMessages:n,lineCount:l.length,node:i}}static _makeSnippetLinesArray(e,t){return e.split("\n").map((e,r)=>{const n=r+1,i={content:e.slice(0,t),lineNumber:n};return e.length>t&&(i.truncated=!0),i})}static makeOpportunityDetails(e,t,r,n){return Audit.assertHeadingKeysExist(e,t),{type:"opportunity",headings:0===t.length?[]:e,items:t,overallSavingsMs:r,overallSavingsBytes:n}}static _normalizeAuditScore(e,t,r){if(t!==Audit.SCORING_MODES.BINARY&&t!==Audit.SCORING_MODES.NUMERIC)return null;if(null===e||!Number.isFinite(e))throw new Error(`Invalid score for ${r}: ${e}`);if(e>1)throw new Error(`Audit score for ${r} is > 1`);if(e<0)throw new Error(`Audit score for ${r} is < 0`)
;return e=o(e)}static generateErrorAuditResult(e,t){return Audit.generateAuditResult(e,{score:null,errorMessage:t})}static generateAuditResult(e,t){if(void 0===t.score)throw new Error("generateAuditResult requires a score");let r=e.meta.scoreDisplayMode||Audit.SCORING_MODES.BINARY;t.errorMessage?r=Audit.SCORING_MODES.ERROR:t.notApplicable&&(r=Audit.SCORING_MODES.NOT_APPLICABLE);const n=Audit._normalizeAuditScore(t.score,r,e.meta.id);let i=e.meta.title;e.meta.failureTitle&&null!==n&&n<a.PASS_THRESHOLD&&(i=e.meta.failureTitle);const s="numericUnit"in t?t:void 0;return{id:e.meta.id,title:i,description:e.meta.description,score:n,scoreDisplayMode:r,numericValue:s&&s.numericValue,numericUnit:s&&s.numericUnit,displayValue:t.displayValue,explanation:t.explanation,errorMessage:t.errorMessage,warnings:t.warnings,details:t.details}}}t.exports=Audit},{"../lib/lh-env.js":85,"../lib/statistics.js":96,"../report/html/renderer/util.js":105}],4:[function(e,t,r){(function(r){"use strict"
;const n=e("../audit.js"),i=e("../../lib/statistics.js").linearInterpolation,a=e("../../computed/metrics/lantern-interactive.js"),s=e("../../lib/i18n/i18n.js"),o=e("../../computed/network-records.js"),l=e("../../computed/load-simulator.js"),c=e("../../computed/page-dependency-graph.js"),u=s.createMessageInstanceIdFn(r,{}),d=300,m=750,p=5e3;class UnusedBytes extends n{static scoreForWastedMs(e){return 0===e?1:e<d?i(0,1,d,.75,e):e<m?i(d,.75,m,.5,e):Math.max(0,i(m,.5,p,0,e))}static estimateTransferSize(e,t,r){if(e){if(e.resourceType===r)return e.transferSize||0;{const r=e.transferSize||0,n=e.resourceSize||0,i=Number.isFinite(n)&&n>0?r/n:1;return Math.round(t*i)}}switch(r){case"Stylesheet":return Math.round(.2*t);case"Script":case"Document":return Math.round(.33*t);default:return Math.round(.5*t)}}static audit(e,t){const r=e.traces[n.DEFAULT_PASS],i=e.devtoolsLogs[n.DEFAULT_PASS],a=t&&t.settings||{},s={devtoolsLog:i,settings:a}
;return o.request(i,t).then(n=>Promise.all([this.audit_(e,n,t),c.request({trace:r,devtoolsLog:i},t),l.request(s,t)])).then(([e,t,r])=>this.createAuditProduct(e,t,r))}static computeWasteWithTTIGraph(e,t,r,n){const i=`${(n=Object.assign({includeLoad:!0,label:this.meta.id},n)).label}-before`,s=`${n.label}-after`,o=r.simulate(t,{label:i}),l=n.providedWastedBytesByUrl||new Map;if(!n.providedWastedBytesByUrl)for(const{url:t,wastedBytes:r}of e)l.set(t,(l.get(t)||0)+r);const c=new Map;t.traverse(e=>{if("network"!==e.type)return;const t=l.get(e.record.url);if(!t)return;const r=e.record.transferSize;c.set(e.record.requestId,r),e.record.transferSize=Math.max(r-t,0)});const u=r.simulate(t,{label:s});t.traverse(e=>{if("network"!==e.type)return;const t=c.get(e.record.requestId);void 0!==t&&(e.record.transferSize=t)});const d=o.timeInMs-u.timeInMs;let m=a.getLastLongTaskEndTime(o.nodeTimings)-a.getLastLongTaskEndTime(u.nodeTimings);return n.includeLoad&&(m=Math.max(m,d)),
10*Math.round(Math.max(m,0)/10)}static createAuditProduct(e,t,r){const i=e.items.sort((e,t)=>t.wastedBytes-e.wastedBytes),a=i.reduce((e,t)=>e+t.wastedBytes,0),o=this.computeWasteWithTTIGraph(i,t,r,{providedWastedBytesByUrl:e.wastedBytesByUrl});let l=e.displayValue||"";void 0===e.displayValue&&a&&(l=u(s.UIStrings.displayValueByteSavings,{wastedBytes:a}));const c=n.makeOpportunityDetails(e.headings,i,o,a);return{explanation:e.explanation,warnings:e.warnings,displayValue:l,numericValue:o,numericUnit:"millisecond",score:UnusedBytes.scoreForWastedMs(o),details:c}}static audit_(e,t,r){throw new Error("audit_ unimplemented")}}t.exports=UnusedBytes}).call(this,"/lighthouse-core/audits/byte-efficiency/byte-efficiency-audit.js")},{"../../computed/load-simulator.js":12,"../../computed/metrics/lantern-interactive.js":26,"../../computed/network-records.js":40,"../../computed/page-dependency-graph.js":41,"../../lib/i18n/i18n.js":78,"../../lib/statistics.js":96,"../audit.js":3}],5:[function(e,t,r){
t.exports={moduleSizes:[498,155,242,615,220,657,651,1664,790,1534,558,279,868,974,618,356,720,133,826,732,235,552,170,585,1030,210,349,179,546,167,1634,118,199,478,849,470,452,417,147,60,180,433,360,303,1325,1518,397,201,550,226,132,156,198,312,544,2125,658,778,1084,701,401,81,716,632,321,428,648,804,718,130,1443,142,374,259,286,403,821,938,514,654,280,328,186,233,243,553,267,187,206,879,105,343,779,833,773,275,477,696,224,759,671,772,746,716,182,304,658,473,592,235,334,277,404,420,280,675,1034,508,725,526,498,498,499,752,661,276,275,843,1698,962,562,609,573,1048,205,374,226,625,632,308,772,641,233],dependencies:{"Array.prototype.fill":[3,5,8,17,19,21,22,29,30,35,38,39,40,42,43,45,48,51,52,53,55,56,58,60,61,63,64,65,68,69,70,71,72,73,74,75,80,81,82,83,84,87,88,89,91],"Array.prototype.filter":[1,8,9,10,12,14,17,19,21,22,27,28,29,30,33,35,38,39,42,43,45,47,48,51,52,53,58,60,61,63,65,68,69,70,71,72,73,74,75,80,81,82,83,84,87,88,89,92],
"Array.prototype.find":[1,3,8,9,12,14,17,19,21,22,29,30,33,35,38,39,40,42,43,45,47,48,51,52,53,55,56,58,60,61,63,64,65,68,69,70,71,72,73,74,75,80,81,82,83,84,87,88,89,94],"Array.prototype.findIndex":[1,3,8,9,12,14,17,19,21,22,29,30,33,35,38,39,40,42,43,45,47,48,51,52,53,55,56,58,60,61,63,64,65,68,69,70,71,72,73,74,75,80,81,82,83,84,87,88,89,93],"Array.prototype.forEach":[1,6,8,9,11,12,14,17,19,21,22,29,30,33,35,38,39,42,43,45,47,48,51,52,53,58,60,61,63,65,68,69,70,71,72,73,74,75,80,81,82,83,84,87,88,89,95],"Array.from":[1,7,8,15,16,17,18,19,21,22,23,29,30,33,35,36,38,39,42,43,45,46,48,51,52,53,58,60,61,63,65,68,69,70,71,72,73,74,75,80,81,82,83,84,86,87,88,89,96],"Array.isArray":[8,17,19,21,22,29,30,35,38,39,42,43,45,47,48,51,53,58,60,61,63,65,68,69,70,71,72,73,74,75,80,81,82,83,87,98],"Array.prototype.map":[1,8,9,10,12,14,17,19,21,22,27,28,29,30,33,35,38,39,42,43,45,47,48,51,52,53,58,60,61,63,65,68,69,70,71,72,73,74,75,80,81,82,83,84,87,88,89,99],
"Array.of":[8,17,19,21,22,23,29,30,35,38,39,42,43,45,48,51,53,58,60,61,63,65,68,69,70,71,72,73,74,75,80,81,82,83,87,100],"Array.prototype.reduce":[1,8,11,12,13,17,19,21,22,29,30,35,38,39,42,43,45,48,51,53,58,60,61,63,65,68,69,70,71,72,73,74,75,80,81,82,83,84,87,102],"Array.prototype.reduceRight":[1,8,11,12,13,17,19,21,22,29,30,35,38,39,42,43,45,48,51,53,58,60,61,63,65,68,69,70,71,72,73,74,75,80,81,82,83,84,87,101],"Array.prototype.some":[1,8,9,11,12,14,17,19,21,22,29,30,33,35,38,39,42,43,45,47,48,51,52,53,58,60,61,63,65,68,69,70,71,72,73,74,75,80,81,82,83,84,87,88,89,103],"Date.now":[8,17,19,21,22,29,30,35,38,39,42,43,45,48,51,53,58,60,61,63,65,68,69,70,71,72,73,74,75,80,81,82,83,87,104],"Date.prototype.toISOString":[8,17,19,21,22,24,29,30,35,38,39,42,43,45,48,51,53,58,60,61,63,65,68,69,70,71,72,73,74,75,77,78,80,81,82,83,87,105],"Date.prototype.toJSON":[8,17,19,21,22,29,30,35,38,39,42,43,45,48,51,53,58,60,61,63,65,68,69,70,71,72,73,74,75,80,81,82,83,84,87,106],
"Date.prototype.toString":[21,22,38,39,43,45,51,53,70,72,73,74,75,87,107],"Function.prototype.name":[108],"Number.isInteger":[8,17,19,21,22,29,30,35,38,39,42,43,45,48,49,51,53,58,60,61,63,65,68,69,70,71,72,73,74,75,80,81,82,83,87,109],"Number.isSafeInteger":[8,17,19,21,22,29,30,35,38,39,42,43,45,48,49,51,53,58,60,61,63,65,68,69,70,71,72,73,74,75,80,81,82,83,87,110],"Number.parseInt":[8,17,19,21,22,29,30,35,38,39,42,43,45,48,51,53,54,58,60,61,63,65,68,69,70,71,72,73,74,75,79,80,81,82,83,87,90,111],"Object.defineProperties":[8,17,19,21,22,29,30,35,38,39,42,43,45,48,51,53,56,58,60,61,63,64,65,68,69,70,71,72,73,74,75,80,81,82,83,87,112],"Object.defineProperty":[8,17,19,21,22,29,30,35,38,39,42,43,45,48,51,53,58,60,61,63,65,68,69,70,71,72,73,74,75,80,81,82,83,87,113],"Object.freeze":[8,17,19,21,22,29,30,32,35,38,39,42,43,44,45,48,51,53,58,60,61,63,65,68,69,70,71,72,73,74,75,80,81,82,83,87,115],
"Object.getOwnPropertyNames":[8,17,19,21,22,29,30,35,38,39,42,43,45,48,51,53,58,59,60,61,63,65,68,69,70,71,72,73,74,75,80,81,82,83,87,117],"Object.getPrototypeOf":[8,17,19,20,21,22,29,30,35,38,39,42,43,45,48,51,53,58,60,61,62,63,65,68,69,70,71,72,73,74,75,80,81,82,83,84,87,118],"Object.isExtensible":[8,17,19,21,22,29,30,35,38,39,42,43,45,48,51,53,58,60,61,63,65,68,69,70,71,72,73,74,75,80,81,82,83,87,119],"Object.isFrozen":[8,17,19,21,22,29,30,35,38,39,42,43,45,48,51,53,58,60,61,63,65,68,69,70,71,72,73,74,75,80,81,82,83,87,120],"Object.isSealed":[8,17,19,21,22,29,30,35,38,39,42,43,45,48,51,53,58,60,61,63,65,68,69,70,71,72,73,74,75,80,81,82,83,87,121],"Object.keys":[8,17,19,21,22,29,30,35,38,39,42,43,45,48,51,53,58,60,61,63,64,65,68,69,70,71,72,73,74,75,80,81,82,83,84,87,122],"Object.preventExtensions":[8,17,19,21,22,29,30,32,35,38,39,42,43,44,45,48,51,53,58,60,61,63,65,68,69,70,71,72,73,74,75,80,81,82,83,87,123],
"Object.seal":[8,17,19,21,22,29,30,32,35,38,39,42,43,44,45,48,51,53,58,60,61,63,65,68,69,70,71,72,73,74,75,80,81,82,83,87,124],"Object.setPrototypeOf":[2,8,17,19,21,22,29,30,35,38,39,42,43,45,48,51,53,58,60,61,63,65,66,68,69,70,71,72,73,74,75,80,81,82,83,87,125],"Reflect.apply":[1,8,17,19,21,22,29,30,35,38,39,42,43,45,48,51,53,58,60,61,63,65,68,69,70,71,72,73,74,75,80,81,82,83,87,127],"Reflect.construct":[1,8,17,19,21,22,29,30,34,35,38,39,40,42,43,45,48,51,53,55,56,58,60,61,63,64,65,68,69,70,71,72,73,74,75,80,81,82,83,87,128],"Reflect.defineProperty":[8,17,19,21,22,29,30,35,38,39,42,43,45,48,51,53,58,60,61,63,65,68,69,70,71,72,73,74,75,80,81,82,83,87,129],"Reflect.deleteProperty":[8,17,19,21,22,29,30,35,38,39,42,43,45,48,51,53,58,60,61,63,65,68,69,70,71,72,73,74,75,80,81,82,83,87,130],"Reflect.get":[8,17,19,20,21,22,29,30,35,38,39,42,43,45,48,51,53,58,60,61,62,63,65,68,69,70,71,72,73,74,75,80,81,82,83,84,87,133],
"Reflect.getOwnPropertyDescriptor":[8,17,19,21,22,29,30,35,38,39,42,43,45,48,51,53,58,60,61,63,65,68,69,70,71,72,73,74,75,80,81,82,83,87,131],"Reflect.getPrototypeOf":[8,17,19,20,21,22,29,30,35,38,39,42,43,45,48,51,53,58,60,61,62,63,65,68,69,70,71,72,73,74,75,80,81,82,83,84,87,132],"Reflect.has":[8,17,19,21,22,29,30,35,38,39,42,43,45,48,51,53,58,60,61,63,65,68,69,70,71,72,73,74,75,80,81,82,83,87,134],"Reflect.isExtensible":[8,17,19,21,22,29,30,35,38,39,42,43,45,48,51,53,58,60,61,63,65,68,69,70,71,72,73,74,75,80,81,82,83,87,135],"Reflect.ownKeys":[8,17,19,21,22,29,30,35,38,39,42,43,45,48,51,53,58,60,61,63,65,68,69,70,71,72,73,74,75,80,81,82,83,87,136],"Reflect.preventExtensions":[8,17,19,21,22,29,30,32,35,38,39,42,43,45,48,51,53,58,60,61,63,65,68,69,70,71,72,73,74,75,80,81,82,83,87,137],"Reflect.setPrototypeOf":[2,8,17,19,21,22,29,30,35,38,39,42,43,45,48,51,53,58,60,61,63,65,66,68,69,70,71,72,73,74,75,80,81,82,83,87,138],
"String.prototype.codePointAt":[8,17,19,21,22,29,30,35,38,39,42,43,45,48,51,53,58,60,61,63,65,68,69,70,71,72,73,74,75,76,80,81,82,83,87,139],"String.fromCodePoint":[8,17,19,21,22,29,30,35,38,39,42,43,45,48,51,53,58,60,61,63,65,68,69,70,71,72,73,74,75,80,81,82,83,87,140],"String.raw":[8,17,19,21,22,29,30,35,38,39,42,43,45,48,51,53,58,60,61,63,65,68,69,70,71,72,73,74,75,80,81,82,83,87,141],"String.prototype.repeat":[8,17,19,21,22,29,30,35,38,39,42,43,45,48,51,53,58,60,61,63,65,68,69,70,71,72,73,74,75,78,80,81,82,83,87,142],"Array.prototype.includes":[3,8,12,17,19,21,22,29,30,35,38,39,40,42,43,45,48,51,52,53,55,56,58,60,61,63,64,65,68,69,70,71,72,73,74,75,80,81,82,83,87,88,89,97],"Object.entries":[8,17,19,21,22,29,30,35,38,39,42,43,45,48,51,53,58,60,61,63,64,65,67,68,69,70,71,72,73,74,75,80,81,82,83,87,114],"Object.getOwnPropertyDescriptors":[8,17,19,21,22,23,29,30,35,38,39,42,43,45,48,51,53,58,60,61,63,65,68,69,70,71,72,73,74,75,80,81,82,83,87,116],
"Object.values":[8,17,19,21,22,29,30,35,38,39,42,43,45,48,51,53,58,60,61,63,64,65,67,68,69,70,71,72,73,74,75,80,81,82,83,87,126]},maxSize:77759,baseSize:3708}},{}],6:[function(e,t,r){"use strict";const n=e("../audit.js");t.exports=class ManualAudit extends n{static get partialMeta(){return{scoreDisplayMode:n.SCORING_MODES.MANUAL,requiredArtifacts:[]}}static audit(){return{score:0}}}},{"../audit.js":3}],7:[function(e,t,r){"use strict";const n=e("./audit.js");t.exports=class MultiCheckAudit extends n{static async audit(e,t){const r=await this.audit_(e,t);return this.createAuditProduct(r)}static createAuditProduct(e){const t={...e,...e.manifestValues,manifestValues:void 0,allChecks:void 0};e.manifestValues&&e.manifestValues.allChecks&&e.manifestValues.allChecks.forEach(e=>{t[e.id]=e.passing});const r={type:"debugdata",items:[t]};return e.failures.length>0?{score:0,explanation:`Failures: ${e.failures.join(",\n")}.`,details:r}:{score:1,details:r}}static audit_(e,t){
throw new Error("audit_ unimplemented")}}},{"./audit.js":3}],8:[function(e,t,r){"use strict";const n=e("./audit.js");t.exports=class ViolationAudit extends n{static getViolationResults(e,t){const r=new Set;return e.ConsoleMessages.map(e=>e.entry).filter(e=>e.url&&"violation"===e.source&&t.test(e.text)).map(e=>({label:`line: ${e.lineNumber}`,url:e.url})).filter(e=>{const t=`${e.url}!${e.label}`;return!r.has(t)&&(r.add(t),!0)})}}},{"./audit.js":3}],9:[function(e,t,r){"use strict";const n=e("../lib/arbitrary-equality-map.js"),i=e("lighthouse-logger");t.exports=function makeComputedArtifact(e){return Object.assign(e,{request:(t,r)=>{const a=r.computedCache,s=e.name,o=a.get(s)||new n;a.set(s,o);const l=o.get(t);if(l)return l;const c={msg:`Computing artifact: ${s}`,id:`lh:computed:${s}`};i.time(c,"verbose");const u=e.compute_(t,r);return o.set(t,u),u.then(()=>i.timeEnd(c)).catch(()=>i.timeEnd(c)),u}})}},{"../lib/arbitrary-equality-map.js":64,"lighthouse-logger":141}],10:[function(e,t,r){
"use strict";const n=e("./computed-artifact.js"),i=e("../lib/network-request.js"),a=e("./network-records.js"),s=e("./main-resource.js");class CriticalRequestChains{static isCritical(e,t){if(!t)throw new Error("mainResource not provided");if(e.requestId===t.requestId)return!0;if(e.isLinkPreload)return!1;for(;e.redirectDestination;)e=e.redirectDestination;const r=e.resourceType===i.TYPES.Document&&e.frameId!==t.frameId;return!([i.TYPES.Image,i.TYPES.XHR,i.TYPES.Fetch,i.TYPES.EventSource].includes(e.resourceType||"Other")||r||e.mimeType&&e.mimeType.startsWith("image/"))&&(!!e.initiatorRequest&&["VeryHigh","High","Medium"].includes(e.priority))}static extractChain(e,t){e=e.filter(e=>e.finished);const r=new Map;for(const t of e)r.set(t.requestId,t);const n=e.filter(e=>CriticalRequestChains.isCritical(e,t)),i={};for(const e of n){const n=[];let a=e.initiatorRequest,s=i;for(;a;){if(!CriticalRequestChains.isCritical(a,t)||n.includes(a.requestId)){n.length=0,s=void 0;break}n.push(a.requestId),
a=a.initiatorRequest}let o=n.pop();for(;o&&s;){const e=r.get(o);if(!e)throw new Error(`request with id ${o} not found.`);const t=e.requestId;s[t]||(s[t]={request:e,children:{}}),o=n.pop(),s=s[t].children}s&&(s[e.requestId]||(s[e.requestId]={request:e,children:{}}))}return i}static async compute_(e,t){const[r,n]=await Promise.all([a.request(e.devtoolsLog,t),s.request(e,t)]);return CriticalRequestChains.extractChain(r,n)}}t.exports=n(CriticalRequestChains)},{"../lib/network-request.js":90,"./computed-artifact.js":9,"./main-resource.js":13,"./network-records.js":40}],11:[function(e,t,r){"use strict";const n=e("lighthouse-logger"),i=e("./computed-artifact.js"),a=e("../lib/cdt/SDK.js");function computeGeneratedFileSizes(e,t){const r=t.split("\n"),i={},a=t.length;let s=a;const o={files:{},unmappedBytes:s,totalBytes:a};e.computeLastGeneratedColumns();for(const t of e.mappings()){const a=t.sourceURL,l=t.lineNumber,c=t.columnNumber,u=t.lastColumnNumber;if(!a)continue;const d=r[l]
;if(null===d)return n.error("JSBundles",`${e.url()} mapping for line out of bounds: ${l+1}`),o;if(c>d.length)return n.error("JSBundles",`${e.url()} mapping for column out of bounds: ${l+1}:${c}`),o;let m=0;if(void 0!==u){if(u>d.length)return n.error("JSBundles",`${e.url()} mapping for last column out of bounds: ${l+1}:${u}`),o;m=u-c}else m=d.length-c+1;i[a]=(i[a]||0)+m,s-=m}return{files:i,unmappedBytes:s,totalBytes:a}}t.exports=i(class JSBundles{static async compute_(e){const{SourceMaps:t,ScriptElements:r}=e,n=[];for(const e of t){if(!e.map)continue;const{scriptUrl:t,map:i}=e;if(!i.mappings)continue;const s=r.find(e=>e.src===t);if(!s)continue;const o=e.scriptUrl||"compiled.js",l=e.sourceMapUrl||"compiled.js.map",c=i,u=new a.TextSourceMap(o,l,c),d={rawMap:i,script:s,map:u,sizes:computeGeneratedFileSizes(u,s&&s.content?s.content:"")};n.push(d)}return n}})},{"../lib/cdt/SDK.js":67,"./computed-artifact.js":9,"lighthouse-logger":141}],12:[function(e,t,r){"use strict"
;const n=e("./computed-artifact.js"),i=e("../config/constants.js"),a=e("../lib/dependency-graph/simulator/simulator.js"),s=e("./network-analysis.js");t.exports=n(class LoadSimulator{static async compute_(e,t){const{throttlingMethod:r,throttling:n,precomputedLanternData:o}=e.settings,l=await s.request(e.devtoolsLog,t),c={additionalRttByOrigin:l.additionalRttByOrigin,serverResponseTimeByOrigin:l.serverResponseTimeByOrigin};switch(o&&(c.additionalRttByOrigin=new Map(Object.entries(o.additionalRttByOrigin)),c.serverResponseTimeByOrigin=new Map(Object.entries(o.serverResponseTimeByOrigin))),r){case"provided":c.rtt=l.rtt,c.throughput=l.throughput,c.cpuSlowdownMultiplier=1,c.layoutTaskMultiplier=1;break;case"devtools":n&&(c.rtt=n.requestLatencyMs/i.throttling.DEVTOOLS_RTT_ADJUSTMENT_FACTOR,c.throughput=1024*n.downloadThroughputKbps/i.throttling.DEVTOOLS_THROUGHPUT_ADJUSTMENT_FACTOR),c.cpuSlowdownMultiplier=1,c.layoutTaskMultiplier=1;break;case"simulate":n&&(c.rtt=n.rttMs,
c.throughput=1024*n.throughputKbps,c.cpuSlowdownMultiplier=n.cpuSlowdownMultiplier)}return new a(c)}static convertAnalysisToSaveableLanternData(e){const t={additionalRttByOrigin:{},serverResponseTimeByOrigin:{}};for(const[r,n]of e.additionalRttByOrigin.entries())r.startsWith("http")&&(t.additionalRttByOrigin[r]=n);for(const[r,n]of e.serverResponseTimeByOrigin.entries())r.startsWith("http")&&(t.serverResponseTimeByOrigin[r]=n);return t}})},{"../config/constants.js":54,"../lib/dependency-graph/simulator/simulator.js":75,"./computed-artifact.js":9,"./network-analysis.js":39}],13:[function(e,t,r){"use strict";const n=e("./computed-artifact.js"),i=e("../lib/dependency-graph/simulator/network-analyzer.js"),a=e("./network-records.js");t.exports=n(class MainResource{static async compute_(e,t){const r=e.URL.finalUrl,n=await a.request(e.devtoolsLog,t),s=i.findMainDocument(n,r);if(!s)throw new Error("Unable to identify the main resource");return s}})},{
"../lib/dependency-graph/simulator/network-analyzer.js":74,"./computed-artifact.js":9,"./network-records.js":40}],14:[function(e,t,r){"use strict";const n=e("./computed-artifact.js"),i=e("../lib/tracehouse/main-thread-tasks.js"),a=e("./trace-of-tab.js");t.exports=n(class MainThreadTasks{static async compute_(e,t){const{mainThreadEvents:r,frames:n,timestamps:s}=await a.request(e,t);return i.getMainThreadTasks(r,n,s.traceEnd)}})},{"../lib/tracehouse/main-thread-tasks.js":99,"./computed-artifact.js":9,"./trace-of-tab.js":45}],15:[function(e,t,r){"use strict";const n=e("./computed-artifact.js"),i=e("../lib/icons.js"),a=["minimal-ui","fullscreen","standalone"],s=12;class ManifestValues{static get manifestChecks(){return[{id:"hasStartUrl",failureText:"Manifest does not contain a `start_url`",validate:e=>!!e.start_url.value},{id:"hasIconsAtLeast144px",failureText:"Manifest does not have a PNG icon of at least 144px",validate:e=>i.doExist(e)&&i.pngSizedAtLeast(144,e).length>0},{
id:"hasIconsAtLeast512px",failureText:"Manifest does not have a PNG icon of at least 512px",validate:e=>i.doExist(e)&&i.pngSizedAtLeast(512,e).length>0},{id:"fetchesIcon",failureText:"Manifest icon failed to be fetched",validate:(e,t)=>{const r=["cannot-download-icon","no-icon-available"];return i.doExist(e)&&!t.some(e=>r.includes(e.errorId))}},{id:"hasPWADisplayValue",failureText:"Manifest's `display` value is not one of: "+a.join(" | "),validate:e=>a.includes(e.display.value)},{id:"hasBackgroundColor",failureText:"Manifest does not have `background_color`",validate:e=>!!e.background_color.value},{id:"hasThemeColor",failureText:"Manifest does not have `theme_color`",validate:e=>!!e.theme_color.value},{id:"hasShortName",failureText:"Manifest does not have `short_name`",validate:e=>!!e.short_name.value},{id:"shortNameLength",failureText:`Manifest's \`short_name\` is too long (>${s} `+"characters) to be displayed on a homescreen without truncation",
validate:e=>!!e.short_name.value&&e.short_name.value.length<=s},{id:"hasName",failureText:"Manifest does not have `name`",validate:e=>!!e.name.value},{id:"hasMaskableIcon",failureText:"Manifest does not have at least one icon that is maskable",validate:e=>i.doExist(e)&&i.containsMaskableIcon(e)}]}static async compute_({WebAppManifest:e,InstallabilityErrors:t}){if(null===e)return{isParseFailure:!0,parseFailureReason:"No manifest was fetched",allChecks:[]};const r=e.value;return void 0===r?{isParseFailure:!0,parseFailureReason:"Manifest failed to parse as valid JSON",allChecks:[]}:{isParseFailure:!1,allChecks:ManifestValues.manifestChecks.map(e=>({id:e.id,failureText:e.failureText,passing:e.validate(r,t.errors)}))}}}t.exports=n(ManifestValues)},{"../lib/icons.js":80,"./computed-artifact.js":9}],16:[function(e,t,r){"use strict";const n=e("../computed-artifact.js"),i=e("../trace-of-tab.js"),a=e("../../lib/lh-error.js");t.exports=n(class CumulativeLayoutShift{static async compute_(e,t){
const r=await i.request(e,t);let n;for(let e=r.mainThreadEvents.length-1;e>=0;e--){const t=r.mainThreadEvents[e];if("LayoutShift"===t.name&&t.args&&t.args.data&&t.args.data.is_main_frame){n=t;break}}const s=!!n;if(!n)return{value:0,debugInfo:{finalLayoutShiftTraceEventFound:s}};let o=n.args&&n.args.data&&n.args.data.cumulative_score;if(void 0===o)throw new a(a.errors.LAYOUT_SHIFT_MISSING_DATA);for(let e=0;e<r.mainThreadEvents.length;e++){const t=r.mainThreadEvents[e];if("LayoutShift"===t.name&&t.args&&t.args.data&&t.args.data.is_main_frame){if(!t.args.data.had_recent_input)break;if("number"!=typeof t.args.data.score)continue;o+=t.args.data.score}}return{value:o,debugInfo:{finalLayoutShiftTraceEventFound:s}}}})},{"../../lib/lh-error.js":86,"../computed-artifact.js":9,"../trace-of-tab.js":45}],17:[function(e,t,r){"use strict"
;const n=e("../computed-artifact.js"),i=e("./metric.js"),a=e("../../lib/lh-error.js"),s=e("../../lib/tracehouse/trace-processor.js"),o=e("./lantern-estimated-input-latency.js"),l=5e3;class EstimatedInputLatency extends i{static calculateRollingWindowEIL(e){const t=e.filter(e=>e.duration>=10);let r=16;for(const n of t){const t=s.getRiskToResponsiveness(e,n.start,n.start+l,[.9]);r=Math.max(t[0].time,r)}return r}static computeSimulatedMetric(e,t){return o.request(e,t)}static computeObservedMetric(e){const{firstMeaningfulPaint:t}=e.traceOfTab.timings;if(!t)throw new a(a.errors.NO_FMP);const r=s.getMainThreadTopLevelEvents(e.traceOfTab,t).filter(e=>e.duration>=1);return Promise.resolve({timing:EstimatedInputLatency.calculateRollingWindowEIL(r)})}}t.exports=n(EstimatedInputLatency)},{"../../lib/lh-error.js":86,"../../lib/tracehouse/trace-processor.js":101,"../computed-artifact.js":9,"./lantern-estimated-input-latency.js":22,"./metric.js":34}],18:[function(e,t,r){"use strict"
;const n=e("../computed-artifact.js"),i=e("./metric.js"),a=e("./lantern-first-contentful-paint.js");t.exports=n(class FirstContentfulPaint extends i{static computeSimulatedMetric(e,t){return a.request(e,t)}static async computeObservedMetric(e){const{traceOfTab:t}=e;return{timing:t.timings.firstContentfulPaint,timestamp:t.timestamps.firstContentfulPaint}}})},{"../computed-artifact.js":9,"./lantern-first-contentful-paint.js":23,"./metric.js":34}],19:[function(e,t,r){"use strict";const n=e("../computed-artifact.js"),i=e("./metric.js"),a=e("../../lib/tracehouse/trace-processor.js"),s=e("../../lib/lh-error.js"),o=e("./lantern-first-cpu-idle.js"),l=50,c=250,u=1e3,d=5e3,m=5e3,p=-Math.log(2)/15;class FirstCPUIdle extends i{static getRequiredWindowSizeInMs(e){const t=e/1e3;return 1e3*(4*Math.exp(p*t)+1)}static getTaskClustersInWindow(e,t,r){const n=[];let i=-1/0,a=[];const s=r+u,o=e=>e.start<s;for(let r=t;r<e.length&&o(e[r]);r++){const t=e[r];t.start-i>u&&(a=[],n.push(a)),a.push(t),i=t.end}
return n.map(e=>{const t=e[0].start,r=e[e.length-1].end;return{start:t,end:r,duration:r-t}}).filter(e=>e.start<r)}static findQuietWindow(e,t,r){if(0===r.length||r[0].start>e+FirstCPUIdle.getRequiredWindowSizeInMs(0))return e;const n=t=>(t=>t.start<e+d)(t)||(e=>e.duration>c)(t);for(let i=0;i<r.length;i++){const a=r[i].end,o=a+FirstCPUIdle.getRequiredWindowSizeInMs(a-e);if(o>t)throw new s(s.errors.NO_FCPUI_IDLE_PERIOD);if(!(i+1<r.length&&r[i+1].start-a<=u)&&!FirstCPUIdle.getTaskClustersInWindow(r,i+1,o).some(n))return a}throw new s(s.errors.NO_FCPUI_IDLE_PERIOD)}static computeSimulatedMetric(e,t){return o.request(e,t)}static async computeObservedMetric(e){const{traceOfTab:t}=e,r=t.timestamps.timeOrigin,n=t.timings.firstMeaningfulPaint,i=t.timings.domContentLoaded,o=t.timings.traceEnd;if(!n||!i)throw new s(n?s.errors.NO_DCL:s.errors.NO_FMP);if(o-n<m)throw new s(s.errors.FMP_TOO_LATE_FOR_FCPUI)
;const c=a.getMainThreadTopLevelEvents(t,n).filter(e=>e.duration>=l),u=FirstCPUIdle.findQuietWindow(n,o,c),d=Math.max(u,i);return Promise.resolve({timing:d,timestamp:1e3*d+r})}}t.exports=n(FirstCPUIdle)},{"../../lib/lh-error.js":86,"../../lib/tracehouse/trace-processor.js":101,"../computed-artifact.js":9,"./lantern-first-cpu-idle.js":24,"./metric.js":34}],20:[function(e,t,r){"use strict";const n=e("../computed-artifact.js"),i=e("./metric.js"),a=e("../../lib/lh-error.js"),s=e("./lantern-first-meaningful-paint.js");t.exports=n(class FirstMeaningfulPaint extends i{static computeSimulatedMetric(e,t){return s.request(e,t)}static async computeObservedMetric(e){const{traceOfTab:t}=e;if(!t.timestamps.firstMeaningfulPaint)throw new a(a.errors.NO_FMP);return{timing:t.timings.firstMeaningfulPaint,timestamp:t.timestamps.firstMeaningfulPaint}}})},{"../../lib/lh-error.js":86,"../computed-artifact.js":9,"./lantern-first-meaningful-paint.js":25,"./metric.js":34}],21:[function(e,t,r){"use strict"
;const n=e("../computed-artifact.js"),i=e("./metric.js"),a=e("./lantern-interactive.js"),s=e("../../lib/network-recorder.js"),o=e("../../lib/tracehouse/trace-processor.js"),l=e("../../lib/lh-error.js"),c=5e3,u=2;class Interactive extends i{static _findNetworkQuietPeriods(e,t){const r=t.timestamps.traceEnd/1e3,n=e.filter(e=>e.finished&&"GET"===e.requestMethod&&!e.failed&&e.statusCode<400);return s.findNetworkQuietPeriods(n,u,r)}static _findCPUQuietPeriods(e,t){const r=t.timestamps.timeOrigin/1e3,n=t.timestamps.traceEnd/1e3;if(0===e.length)return[{start:0,end:n}];const i=[];return e.forEach((t,a)=>{0===a&&i.push({start:0,end:t.start+r}),a===e.length-1?i.push({start:t.end+r,end:n}):i.push({start:t.end+r,end:e[a+1].start+r})}),i}static findOverlappingQuietPeriods(e,t,r){const n=r.timestamps.firstContentfulPaint/1e3,i=e=>e.end>n+c&&e.end-e.start>=c,a=this._findNetworkQuietPeriods(t,r).filter(i),s=this._findCPUQuietPeriods(e,r).filter(i),o=s.slice(),u=a.slice();let d=o.shift(),m=u.shift()
;for(;d&&m;)if(d.start>=m.start){if(m.end>=d.start+c)return{cpuQuietPeriod:d,networkQuietPeriod:m,cpuQuietPeriods:s,networkQuietPeriods:a};m=u.shift()}else{if(d.end>=m.start+c)return{cpuQuietPeriod:d,networkQuietPeriod:m,cpuQuietPeriods:s,networkQuietPeriods:a};d=o.shift()}throw new l(d?l.errors.NO_TTI_NETWORK_IDLE_PERIOD:l.errors.NO_TTI_CPU_IDLE_PERIOD)}static computeSimulatedMetric(e,t){return a.request(e,t)}static computeObservedMetric(e){const{traceOfTab:t,networkRecords:r}=e;if(!t.timestamps.domContentLoaded)throw new l(l.errors.NO_DCL);const n=o.getMainThreadTopLevelEvents(t).filter(e=>e.duration>=50),i=Interactive.findOverlappingQuietPeriods(n,r,t).cpuQuietPeriod,a=1e3*Math.max(i.start,t.timestamps.firstContentfulPaint/1e3,t.timestamps.domContentLoaded/1e3),s=(a-t.timestamps.timeOrigin)/1e3;return Promise.resolve({timing:s,timestamp:a})}}t.exports=n(Interactive)},{"../../lib/lh-error.js":86,"../../lib/network-recorder.js":89,"../../lib/tracehouse/trace-processor.js":101,
"../computed-artifact.js":9,"./lantern-interactive.js":26,"./metric.js":34}],22:[function(e,t,r){"use strict";const n=e("../computed-artifact.js"),i=e("./lantern-metric.js"),a=e("../../lib/dependency-graph/base-node.js"),s=e("./lantern-first-meaningful-paint.js");class LanternEstimatedInputLatency extends i{static get COEFFICIENTS(){return{intercept:0,optimistic:.4,pessimistic:.4}}static getOptimisticGraph(e){return e}static getPessimisticGraph(e){return e}static getEstimateFromSimulation(t,r){if(!r.fmpResult)throw new Error("missing fmpResult");const n=r.optimistic?r.fmpResult.pessimisticEstimate.timeInMs:r.fmpResult.optimisticEstimate.timeInMs,i=LanternEstimatedInputLatency.getEventsAfterFMP(t.nodeTimings,n);return{timeInMs:e("./estimated-input-latency.js").calculateRollingWindowEIL(i),nodeTimings:t.nodeTimings}}static async compute_(e,t){const r=await s.request(e,t);return this.computeMetricWithGraphs(e,t,{fmpResult:r})}static getEventsAfterFMP(e,t){const r=[]
;for(const[n,i]of e.entries())n.type===a.TYPES.CPU&&(i.endTime<t||r.push({start:i.startTime,end:i.endTime,duration:i.duration}));return r.sort((e,t)=>e.start-t.start)}}t.exports=n(LanternEstimatedInputLatency)},{"../../lib/dependency-graph/base-node.js":69,"../computed-artifact.js":9,"./estimated-input-latency.js":17,"./lantern-first-meaningful-paint.js":25,"./lantern-metric.js":29}],23:[function(e,t,r){"use strict";const n=e("../computed-artifact.js"),i=e("./lantern-metric.js"),a=e("../../lib/dependency-graph/base-node.js");t.exports=n(class LanternFirstContentfulPaint extends i{static get COEFFICIENTS(){return{intercept:0,optimistic:.5,pessimistic:.5}}static getBlockingNodeData(e,t,r,n){const s=new Map,o=[];e.traverse(e=>{if(e.type===a.TYPES.CPU){e.startTime<=t&&o.push(e);const r=e.getEvaluateScriptURLs();for(const t of r){const r=s.get(t)||e;s.set(t,e.startTime<r.startTime?e:r)}}}),o.sort((e,t)=>e.startTime-t.startTime)
;const l=i.getScriptUrls(e,e=>e.endTime<=t&&r(e)),c=new Set,u=new Set;for(const e of l){const t=s.get(e);t&&(o.includes(t)?u.add(t.id):c.add(e))}const d=o.find(e=>e.didPerformLayout());d&&u.add(d.id);const m=o.find(e=>e.childEvents.some(e=>"Paint"===e.name));m&&u.add(m.id);const p=o.find(e=>e.childEvents.some(e=>"ParseHTML"===e.name));return p&&u.add(p.id),n&&o.filter(n).forEach(e=>u.add(e.id)),{definitelyNotRenderBlockingScriptUrls:c,blockingCpuNodeIds:u}}static getFirstPaintBasedGraph(e,t,r,n){const{definitelyNotRenderBlockingScriptUrls:i,blockingCpuNodeIds:s}=this.getBlockingNodeData(e,t,r,n);return e.cloneWithRelationships(e=>{if(e.type===a.TYPES.NETWORK){if(e.endTime>t&&!e.isMainDocument())return!1;const n=e.record.url;return!i.has(n)&&r(e)}return s.has(e.id)})}static getOptimisticGraph(e,t){return this.getFirstPaintBasedGraph(e,t.timestamps.firstContentfulPaint,e=>e.hasRenderBlockingPriority()&&"script"!==e.initiatorType)}static getPessimisticGraph(e,t){
return this.getFirstPaintBasedGraph(e,t.timestamps.firstContentfulPaint,e=>e.hasRenderBlockingPriority())}})},{"../../lib/dependency-graph/base-node.js":69,"../computed-artifact.js":9,"./lantern-metric.js":29}],24:[function(e,t,r){"use strict";const n=e("../computed-artifact.js"),i=e("../../lib/dependency-graph/base-node.js"),a=e("./lantern-interactive.js");class LanternFirstCPUIdle extends a{static get COEFFICIENTS(){return{intercept:0,optimistic:1,pessimistic:0}}static getEstimateFromSimulation(e,t){const r=t.optimistic?t.fmpResult.optimisticEstimate.timeInMs:t.fmpResult.pessimisticEstimate.timeInMs;return{timeInMs:LanternFirstCPUIdle.getFirstCPUIdleWindowStart(e.nodeTimings,r),nodeTimings:e.nodeTimings}}static getFirstCPUIdleWindowStart(t,r,n=50){const a=[];for(const[e,r]of t.entries())e.type===i.TYPES.CPU&&(r.duration<n||a.push({start:r.startTime,end:r.endTime}));return a.sort((e,t)=>e.start-t.start),e("./first-cpu-idle.js").findQuietWindow(r,1/0,a)}static async compute_(e,t){
return super.compute_(e,t)}}t.exports=n(LanternFirstCPUIdle)},{"../../lib/dependency-graph/base-node.js":69,"../computed-artifact.js":9,"./first-cpu-idle.js":19,"./lantern-interactive.js":26}],25:[function(e,t,r){"use strict";const n=e("../computed-artifact.js"),i=e("./lantern-metric.js"),a=e("../../lib/lh-error.js"),s=e("./lantern-first-contentful-paint.js");t.exports=n(class LanternFirstMeaningfulPaint extends i{static get COEFFICIENTS(){return{intercept:0,optimistic:.5,pessimistic:.5}}static getOptimisticGraph(e,t){const r=t.timestamps.firstMeaningfulPaint;if(!r)throw new a(a.errors.NO_FMP);return s.getFirstPaintBasedGraph(e,r,e=>e.hasRenderBlockingPriority()&&"script"!==e.initiatorType)}static getPessimisticGraph(e,t){const r=t.timestamps.firstMeaningfulPaint;if(!r)throw new a(a.errors.NO_FMP);return s.getFirstPaintBasedGraph(e,r,e=>e.hasRenderBlockingPriority(),e=>e.didPerformLayout())}static async compute_(e,t){
const r=await s.request(e,t),n=await this.computeMetricWithGraphs(e,t);return n.timing=Math.max(n.timing,r.timing),n}})},{"../../lib/lh-error.js":86,"../computed-artifact.js":9,"./lantern-first-contentful-paint.js":23,"./lantern-metric.js":29}],26:[function(e,t,r){"use strict";const n=e("../computed-artifact.js"),i=e("./lantern-metric.js"),a=e("../../lib/dependency-graph/base-node.js"),s=e("../../lib/network-request.js"),o=e("./lantern-first-meaningful-paint.js"),l=20;class LanternInteractive extends i{static get COEFFICIENTS(){return{intercept:0,optimistic:.5,pessimistic:.5}}static getOptimisticGraph(e){const t=1e3*l;return e.cloneWithRelationships(e=>{if(e.type===a.TYPES.CPU)return e.event.dur>t;const r=e.record.resourceType===s.TYPES.Image,n=e.record.resourceType===s.TYPES.Script;return!r&&(n||"High"===e.record.priority||"VeryHigh"===e.record.priority)})}static getPessimisticGraph(e){return e}static getEstimateFromSimulation(e,t){if(!t.fmpResult)throw new Error("missing fmpResult")
;const r=LanternInteractive.getLastLongTaskEndTime(e.nodeTimings),n=t.optimistic?t.fmpResult.optimisticEstimate.timeInMs:t.fmpResult.pessimisticEstimate.timeInMs;return{timeInMs:Math.max(n,r),nodeTimings:e.nodeTimings}}static async compute_(e,t){const r=await o.request(e,t),n=await this.computeMetricWithGraphs(e,t,{fmpResult:r});return n.timing=Math.max(n.timing,r.timing),n}static getLastLongTaskEndTime(e,t=50){return Array.from(e.entries()).filter(([e,r])=>e.type===a.TYPES.CPU&&r.duration>t).map(([e,t])=>t.endTime).reduce((e,t)=>Math.max(e||0,t||0),0)}}t.exports=n(LanternInteractive)},{"../../lib/dependency-graph/base-node.js":69,"../../lib/network-request.js":90,"../computed-artifact.js":9,"./lantern-first-meaningful-paint.js":25,"./lantern-metric.js":29}],27:[function(e,t,r){"use strict";const n=e("../computed-artifact.js"),i=e("./lantern-metric.js"),a=e("../../lib/lh-error.js"),s=e("./lantern-first-contentful-paint.js");class LanternLargestContentfulPaint extends i{
static get COEFFICIENTS(){return{intercept:0,optimistic:.5,pessimistic:.5}}static isNotLowPriorityImageNode(e){if("network"!==e.type)return!0;const t="Image"===e.record.resourceType,r="Low"===e.record.priority||"VeryLow"===e.record.priority;return!t||!r}static getOptimisticGraph(e,t){const r=t.timestamps.largestContentfulPaint;if(!r)throw new a(a.errors.NO_LCP);return s.getFirstPaintBasedGraph(e,r,LanternLargestContentfulPaint.isNotLowPriorityImageNode)}static getPessimisticGraph(e,t){const r=t.timestamps.largestContentfulPaint;if(!r)throw new a(a.errors.NO_LCP);return s.getFirstPaintBasedGraph(e,r,e=>!0,e=>e.didPerformLayout())}static getEstimateFromSimulation(e){const t=Array.from(e.nodeTimings.entries()).filter(e=>LanternLargestContentfulPaint.isNotLowPriorityImageNode(e[0])).map(e=>e[1].endTime);return{timeInMs:Math.max(...t),nodeTimings:e.nodeTimings}}static async compute_(e,t){const r=await s.request(e,t),n=await this.computeMetricWithGraphs(e,t)
;return n.timing=Math.max(n.timing,r.timing),n}}t.exports=n(LanternLargestContentfulPaint)},{"../../lib/lh-error.js":86,"../computed-artifact.js":9,"./lantern-first-contentful-paint.js":23,"./lantern-metric.js":29}],28:[function(e,t,r){"use strict";const n=e("../computed-artifact.js"),i=e("./lantern-metric.js"),a=e("../../lib/dependency-graph/base-node.js"),s=e("./lantern-first-contentful-paint.js");class LanternMaxPotentialFID extends i{static get COEFFICIENTS(){return{intercept:0,optimistic:.5,pessimistic:.5}}static getOptimisticGraph(e){return e}static getPessimisticGraph(e){return e}static getEstimateFromSimulation(e,t){if(!t.fcpResult)throw new Error("missing fcpResult");const r=t.optimistic?t.fcpResult.pessimisticEstimate.timeInMs:t.fcpResult.optimisticEstimate.timeInMs,n=LanternMaxPotentialFID.getTimingsAfterFCP(e.nodeTimings,r);return{timeInMs:Math.max(...n.map(e=>e.duration),16),nodeTimings:e.nodeTimings}}static async compute_(e,t){const r=await s.request(e,t)
;return super.computeMetricWithGraphs(e,t,{fcpResult:r})}static getTimingsAfterFCP(e,t){return Array.from(e.entries()).filter(([e,r])=>e.type===a.TYPES.CPU&&r.endTime>t).map(([e,t])=>t)}}t.exports=n(LanternMaxPotentialFID)},{"../../lib/dependency-graph/base-node.js":69,"../computed-artifact.js":9,"./lantern-first-contentful-paint.js":23,"./lantern-metric.js":29}],29:[function(e,t,r){"use strict";const n=e("../../lib/dependency-graph/base-node.js"),i=e("../../lib/network-request.js"),a=e("../trace-of-tab.js"),s=e("../page-dependency-graph.js"),o=e("../load-simulator.js");t.exports=class LanternMetricArtifact{static getScriptUrls(e,t){const r=new Set;return e.traverse(e=>{e.type!==n.TYPES.CPU&&e.record.resourceType===i.TYPES.Script&&(t&&!t(e)||r.add(e.record.url))}),r}static get COEFFICIENTS(){throw new Error("COEFFICIENTS unimplemented!")}static getScaledCoefficients(e){return this.COEFFICIENTS}static getOptimisticGraph(e,t){throw new Error("Optimistic graph unimplemented!")}
static getPessimisticGraph(e,t){throw new Error("Pessmistic graph unimplemented!")}static getEstimateFromSimulation(e,t){return e}static async computeMetricWithGraphs(e,t,r){const{trace:n,devtoolsLog:i,settings:l}=e,c=this.name.replace("Lantern",""),u=await s.request({trace:n,devtoolsLog:i},t),d=await a.request(n,t),m=e.simulator||await o.request({devtoolsLog:i,settings:l},t),p=this.getOptimisticGraph(u,d),h=this.getPessimisticGraph(u,d);let g={label:`optimistic${c}`};const f=m.simulate(p,g);g={label:`optimisticFlex${c}`,flexibleOrdering:!0};const b=m.simulate(p,g);g={label:`pessimistic${c}`};const y=m.simulate(h,g),v=this.getEstimateFromSimulation(f.timeInMs<b.timeInMs?f:b,{...r,optimistic:!0}),w=this.getEstimateFromSimulation(y,{...r,optimistic:!1}),k=this.getScaledCoefficients(m.rtt),x=k.intercept>0?Math.min(1,v.timeInMs/1e3):1;return{timing:k.intercept*x+k.optimistic*v.timeInMs+k.pessimistic*w.timeInMs,optimisticEstimate:v,pessimisticEstimate:w,optimisticGraph:p,pessimisticGraph:h}
}static async compute_(e,t){return this.computeMetricWithGraphs(e,t)}}},{"../../lib/dependency-graph/base-node.js":69,"../../lib/network-request.js":90,"../load-simulator.js":12,"../page-dependency-graph.js":41,"../trace-of-tab.js":45}],30:[function(e,t,r){"use strict";const n=e("../computed-artifact.js"),i=e("./lantern-metric.js"),a=e("../../lib/dependency-graph/base-node.js"),s=e("../speedline.js"),o=e("./lantern-first-contentful-paint.js"),l=e("../../config/constants.js").throttling;class LanternSpeedIndex extends i{static get COEFFICIENTS(){return{intercept:-250,optimistic:1.4,pessimistic:.65}}static getScaledCoefficients(e){const t=this.COEFFICIENTS,r=l.mobileSlow4G.rttMs-30,n=Math.max((e-30)/r,0);return{intercept:t.intercept*n,optimistic:.5+(t.optimistic-.5)*n,pessimistic:.5+(t.pessimistic-.5)*n}}static getOptimisticGraph(e){return e}static getPessimisticGraph(e){return e}static getEstimateFromSimulation(e,t){if(!t.fcpResult)throw new Error("missing fcpResult")
;if(!t.speedline)throw new Error("missing speedline");const r=t.fcpResult.pessimisticEstimate.timeInMs;return{timeInMs:t.optimistic?t.speedline.speedIndex:LanternSpeedIndex.computeLayoutBasedSpeedIndex(e.nodeTimings,r),nodeTimings:e.nodeTimings}}static async compute_(e,t){const r=await s.request(e.trace,t),n=await o.request(e,t),i=await this.computeMetricWithGraphs(e,t,{speedline:r,fcpResult:n});return i.timing=Math.max(i.timing,n.timing),i}static computeLayoutBasedSpeedIndex(e,t){const r=[];for(const[t,n]of e.entries())if(t.type===a.TYPES.CPU&&t.childEvents.some(e=>"Layout"===e.name)){const e=Math.max(Math.log2(n.endTime-n.startTime),0);r.push({time:n.endTime,weight:e})}const n=r.map(e=>e.weight*Math.max(e.time,t)).reduce((e,t)=>e+t,0),i=r.map(e=>e.weight).reduce((e,t)=>e+t,0);return i?n/i:t}}t.exports=n(LanternSpeedIndex)},{"../../config/constants.js":54,"../../lib/dependency-graph/base-node.js":69,"../computed-artifact.js":9,"../speedline.js":44,
"./lantern-first-contentful-paint.js":23,"./lantern-metric.js":29}],31:[function(e,t,r){"use strict";const n=e("../computed-artifact.js"),i=e("./lantern-metric.js"),a=e("../../lib/dependency-graph/base-node.js"),s=e("./lantern-first-contentful-paint.js"),o=e("./lantern-interactive.js");class LanternTotalBlockingTime extends i{static get COEFFICIENTS(){return{intercept:0,optimistic:.5,pessimistic:.5}}static getOptimisticGraph(e){return e}static getPessimisticGraph(e){return e}static getEstimateFromSimulation(t,r){if(!r.fcpResult)throw new Error("missing fcpResult");if(!r.interactiveResult)throw new Error("missing interactiveResult");const n=r.optimistic?r.fcpResult.pessimisticEstimate.timeInMs:r.fcpResult.optimisticEstimate.timeInMs,i=r.optimistic?r.interactiveResult.optimisticEstimate.timeInMs:r.interactiveResult.pessimisticEstimate.timeInMs,a=e("./total-blocking-time.js"),s=a.BLOCKING_TIME_THRESHOLD,o=LanternTotalBlockingTime.getTopLevelEvents(t.nodeTimings,s);return{
timeInMs:a.calculateSumOfBlockingTime(o,n,i),nodeTimings:t.nodeTimings}}static async compute_(e,t){const r=await s.request(e,t),n=await o.request(e,t);return this.computeMetricWithGraphs(e,t,{fcpResult:r,interactiveResult:n})}static getTopLevelEvents(e,t){const r=[];for(const[n,i]of e.entries())n.type===a.TYPES.CPU&&(i.duration<t||r.push({start:i.startTime,end:i.endTime,duration:i.duration}));return r}}t.exports=n(LanternTotalBlockingTime)},{"../../lib/dependency-graph/base-node.js":69,"../computed-artifact.js":9,"./lantern-first-contentful-paint.js":23,"./lantern-interactive.js":26,"./lantern-metric.js":29,"./total-blocking-time.js":37}],32:[function(e,t,r){"use strict";const n=e("../computed-artifact.js"),i=e("./metric.js"),a=e("../../lib/lh-error.js"),s=e("./lantern-largest-contentful-paint.js");t.exports=n(class LargestContentfulPaint extends i{static computeSimulatedMetric(e,t){return s.request(e,t)}static async computeObservedMetric(e){const{traceOfTab:t}=e
;if(!t.timestamps.largestContentfulPaint)throw new a(a.errors.NO_LCP);return{timing:t.timings.largestContentfulPaint,timestamp:t.timestamps.largestContentfulPaint}}})},{"../../lib/lh-error.js":86,"../computed-artifact.js":9,"./lantern-largest-contentful-paint.js":27,"./metric.js":34}],33:[function(e,t,r){"use strict";const n=e("../computed-artifact.js"),i=e("./metric.js"),a=e("./lantern-max-potential-fid.js"),s=e("../../lib/lh-error.js"),o=e("../../lib/tracehouse/trace-processor.js");t.exports=n(class MaxPotentialFID extends i{static computeSimulatedMetric(e,t){return a.request(e,t)}static computeObservedMetric(e){const{firstContentfulPaint:t}=e.traceOfTab.timings;if(!t)throw new s(s.errors.NO_FCP);const r=o.getMainThreadTopLevelEvents(e.traceOfTab,t).filter(e=>e.duration>=1);return Promise.resolve({timing:Math.max(...r.map(e=>e.duration),16)})}})},{"../../lib/lh-error.js":86,"../../lib/tracehouse/trace-processor.js":101,"../computed-artifact.js":9,"./lantern-max-potential-fid.js":28,
"./metric.js":34}],34:[function(e,t,r){"use strict";const n=e("../../lib/tracehouse/trace-processor.js"),i=e("../trace-of-tab.js"),a=e("../network-records.js");t.exports=class ComputedMetric{constructor(){}static computeSimulatedMetric(e,t){throw new Error("Unimplemented")}static computeObservedMetric(e,t){throw new Error("Unimplemented")}static async compute_(e,t){const{trace:r,devtoolsLog:s,settings:o}=e;if(!r||!s||!o)throw new Error("Did not provide necessary metric computation data");const l=Object.assign({networkRecords:await a.request(s,t),traceOfTab:await i.request(r,t)},e);switch(n.assertHasToplevelEvents(l.traceOfTab.mainThreadEvents),o.throttlingMethod){case"simulate":return this.computeSimulatedMetric(l,t);case"provided":case"devtools":return this.computeObservedMetric(l,t);default:throw new TypeError(`Unrecognized throttling method: ${o.throttlingMethod}`)}}}},{"../../lib/tracehouse/trace-processor.js":101,"../network-records.js":40,"../trace-of-tab.js":45}],
35:[function(e,t,r){"use strict";const n=e("../computed-artifact.js"),i=e("./metric.js"),a=e("./lantern-speed-index.js"),s=e("../speedline.js");t.exports=n(class SpeedIndex extends i{static computeSimulatedMetric(e,t){return a.request(e,t)}static async computeObservedMetric(e,t){const r=await s.request(e.trace,t),n=Math.round(r.speedIndex),i=1e3*(n+r.beginning);return Promise.resolve({timing:n,timestamp:i})}})},{"../computed-artifact.js":9,"../speedline.js":44,"./lantern-speed-index.js":30,"./metric.js":34}],36:[function(e,t,r){"use strict";const n=e("../trace-of-tab.js"),i=e("../speedline.js"),a=e("./first-contentful-paint.js"),s=e("./first-meaningful-paint.js"),o=e("./largest-contentful-paint.js"),l=e("./first-cpu-idle.js"),c=e("./interactive.js"),u=e("./cumulative-layout-shift.js"),d=e("./speed-index.js"),m=e("./estimated-input-latency.js"),p=e("./max-potential-fid.js"),h=e("./total-blocking-time.js"),g=e("../computed-artifact.js");class TimingSummary{static async summarize(e,t,r){
const g={trace:e,devtoolsLog:t,settings:r.settings},f=(e,t)=>e.request(t,r).catch(e=>void 0),b=await n.request(e,r),y=await i.request(e,r),v=await a.request(g,r),w=await s.request(g,r),k=await f(o,g),x=await f(l,g),T=await f(c,g),S=await f(u,e),j=await f(p,g),E=await f(d,g),_=await m.request(g,r),D=await h.request(g,r),A=S&&null!==S.value?S.value:void 0;return{metrics:{firstContentfulPaint:v.timing,firstContentfulPaintTs:v.timestamp,firstMeaningfulPaint:w.timing,firstMeaningfulPaintTs:w.timestamp,largestContentfulPaint:k&&k.timing,largestContentfulPaintTs:k&&k.timestamp,firstCPUIdle:x&&x.timing,firstCPUIdleTs:x&&x.timestamp,interactive:T&&T.timing,interactiveTs:T&&T.timestamp,speedIndex:E&&E.timing,speedIndexTs:E&&E.timestamp,estimatedInputLatency:_.timing,estimatedInputLatencyTs:_.timestamp,totalBlockingTime:D.timing,maxPotentialFID:j&&j.timing,cumulativeLayoutShift:A,observedTimeOrigin:b.timings.timeOrigin,observedTimeOriginTs:b.timestamps.timeOrigin,
observedNavigationStart:b.timings.timeOrigin,observedNavigationStartTs:b.timestamps.timeOrigin,observedFirstPaint:b.timings.firstPaint,observedFirstPaintTs:b.timestamps.firstPaint,observedFirstContentfulPaint:b.timings.firstContentfulPaint,observedFirstContentfulPaintTs:b.timestamps.firstContentfulPaint,observedFirstMeaningfulPaint:b.timings.firstMeaningfulPaint,observedFirstMeaningfulPaintTs:b.timestamps.firstMeaningfulPaint,observedLargestContentfulPaint:b.timings.largestContentfulPaint,observedLargestContentfulPaintTs:b.timestamps.largestContentfulPaint,observedTraceEnd:b.timings.traceEnd,observedTraceEndTs:b.timestamps.traceEnd,observedLoad:b.timings.load,observedLoadTs:b.timestamps.load,observedDomContentLoaded:b.timings.domContentLoaded,observedDomContentLoadedTs:b.timestamps.domContentLoaded,observedCumulativeLayoutShift:A,observedFirstVisualChange:y.first,observedFirstVisualChangeTs:1e3*(y.first+y.beginning),observedLastVisualChange:y.complete,
observedLastVisualChangeTs:1e3*(y.complete+y.beginning),observedSpeedIndex:y.speedIndex,observedSpeedIndexTs:1e3*(y.speedIndex+y.beginning)},debugInfo:{lcpInvalidated:b.lcpInvalidated}}}static async compute_(e,t){return TimingSummary.summarize(e.trace,e.devtoolsLog,t)}}t.exports=g(TimingSummary)},{"../computed-artifact.js":9,"../speedline.js":44,"../trace-of-tab.js":45,"./cumulative-layout-shift.js":16,"./estimated-input-latency.js":17,"./first-contentful-paint.js":18,"./first-cpu-idle.js":19,"./first-meaningful-paint.js":20,"./interactive.js":21,"./largest-contentful-paint.js":32,"./max-potential-fid.js":33,"./speed-index.js":35,"./total-blocking-time.js":37}],37:[function(e,t,r){"use strict";const n=e("../computed-artifact.js"),i=e("./metric.js"),a=e("../../lib/lh-error.js"),s=e("../../lib/tracehouse/trace-processor.js"),o=e("./lantern-total-blocking-time.js"),l=e("./interactive.js");class TotalBlockingTime extends i{static get BLOCKING_TIME_THRESHOLD(){return 50}
static calculateSumOfBlockingTime(e,t,r){if(r<=t)return 0;const n=TotalBlockingTime.BLOCKING_TIME_THRESHOLD;let i=0;for(const a of e){if(a.duration<n)continue;if(a.end<t)continue;if(a.start>r)continue;const e=Math.max(a.start,t),s=Math.min(a.end,r)-e;s<n||(i+=s-n)}return i}static computeSimulatedMetric(e,t){return o.request(e,t)}static async computeObservedMetric(e,t){const{firstContentfulPaint:r}=e.traceOfTab.timings;if(!r)throw new a(a.errors.NO_FCP);const n=(await l.request(e,t)).timing,i=s.getMainThreadTopLevelEvents(e.traceOfTab);return{timing:TotalBlockingTime.calculateSumOfBlockingTime(i,r,n)}}}t.exports=n(TotalBlockingTime)},{"../../lib/lh-error.js":86,"../../lib/tracehouse/trace-processor.js":101,"../computed-artifact.js":9,"./interactive.js":21,"./lantern-total-blocking-time.js":31,"./metric.js":34}],38:[function(e,t,r){"use strict";const n=e("./computed-artifact.js"),i=e("./js-bundles.js"),a=.1,s=512;class ModuleDuplication{static _normalizeSource(e){
const t=(e=e.replace(/\?$/,"")).lastIndexOf("node_modules");return-1!==t&&(e=e.substring(t)),e}static _shouldIgnoreSource(e){return!!e.includes("webpack/bootstrap")||(!!e.includes("(webpack)/buildin")||!!e.includes("external "))}static _normalizeAggregatedData(e){for(const[t,r]of e.entries()){let n=r;if(n.sort((e,t)=>t.resourceSize-e.resourceSize),n.length>1){const e=n[0].resourceSize;n=n.filter(t=>{return t.resourceSize/e>=a})}(n=n.filter(e=>e.resourceSize>=s)).length>1?e.set(t,n):e.delete(t)}}static async compute_(e,t){const r=await i.request(e,t),n=new Map;for(const{rawMap:e,sizes:t}of r){const r=[];n.set(e,r);for(let n=0;n<e.sources.length;n++){if(this._shouldIgnoreSource(e.sources[n]))continue;const i=(e.sourceRoot||"")+e.sources[n],a=t.files[i];r.push({source:ModuleDuplication._normalizeSource(e.sources[n]),resourceSize:a})}}const a=new Map;for(const{rawMap:e,script:t}of r){const r=n.get(e);if(r)for(const e of r){let r=a.get(e.source);r||(r=[],a.set(e.source,r)),r.push({
scriptUrl:t.src||"",resourceSize:e.resourceSize})}}return this._normalizeAggregatedData(a),a}}t.exports=n(ModuleDuplication)},{"./computed-artifact.js":9,"./js-bundles.js":11}],39:[function(e,t,r){"use strict";const n=e("./computed-artifact.js"),i=e("../lib/dependency-graph/simulator/network-analyzer.js"),a=e("./network-records.js");class NetworkAnalysis{static computeRTTAndServerResponseTime(e){const t=new Map;for(const[r,n]of i.estimateRTTByOrigin(e).entries())t.set(r,n.min);const r=Math.min(...Array.from(t.values())),n=i.estimateServerResponseTimeByOrigin(e,{rttByOrigin:t}),a=new Map,s=new Map;for(const[e,i]of n.entries()){const n=t.get(e)||r;a.set(e,n-r),s.set(e,i.median)}return{rtt:r,additionalRttByOrigin:a,serverResponseTimeByOrigin:s}}static async compute_(e,t){const r=await a.request(e,t);return{throughput:i.estimateThroughput(r),...NetworkAnalysis.computeRTTAndServerResponseTime(r)}}}t.exports=n(NetworkAnalysis)},{"../lib/dependency-graph/simulator/network-analyzer.js":74,
"./computed-artifact.js":9,"./network-records.js":40}],40:[function(e,t,r){"use strict";const n=e("./computed-artifact.js"),i=e("../lib/network-recorder.js");t.exports=n(class NetworkRecords{static async compute_(e){return i.recordsFromLogs(e)}})},{"../lib/network-recorder.js":89,"./computed-artifact.js":9}],41:[function(e,t,r){"use strict";const n=e("./computed-artifact.js"),i=e("../lib/dependency-graph/network-node.js"),a=e("../lib/dependency-graph/cpu-node.js"),s=e("../lib/dependency-graph/simulator/network-analyzer.js"),o=e("../lib/tracehouse/trace-processor.js"),l=e("../lib/network-request.js"),c=e("./trace-of-tab.js"),u=e("./network-records.js"),d=10,m=/^video/;class PageDependencyGraph{static getNetworkInitiators(e){if(!e.initiator)return[];if(e.initiator.url)return[e.initiator.url];if("script"===e.initiator.type){const t=new Set;let r=e.initiator.stack;for(;r;){const e=r.callFrames||[];for(const r of e)r.url&&t.add(r.url);r=r.parent}return Array.from(t)}return[]}
static getNetworkNodeOutput(e){const t=[],r=new Map,n=new Map,a=new Map;return e.forEach(e=>{if(m.test(e.mimeType))return;for(;r.has(e.requestId);)e.requestId+=":duplicate";const s=new i(e);t.push(s);const o=n.get(e.url)||[];if(o.push(s),r.set(e.requestId,s),n.set(e.url,o),e.frameId&&e.resourceType===l.TYPES.Document&&e.documentURL===e.url){const t=a.has(e.frameId)?null:s;a.set(e.frameId,t)}}),{nodes:t,idToNodeMap:r,urlToNodeMap:n,frameIdToNodeMap:a}}static getCPUNodes(e){const t=[];let r=0;for(o.assertHasToplevelEvents(e.mainThreadEvents);r<e.mainThreadEvents.length;){const n=e.mainThreadEvents[r];if(r++,!o.isScheduleableTask(n)||!n.dur)continue;const i=[];for(const t=n.ts+n.dur;r<e.mainThreadEvents.length&&e.mainThreadEvents[r].ts<t;r++)i.push(e.mainThreadEvents[r]);t.push(new a(n,i))}return t}static linkNetworkNodes(e,t){t.nodes.forEach(r=>{const n=r.record.initiatorRequest||e.record,i=t.idToNodeMap.get(n.requestId)||e,a=PageDependencyGraph.getNetworkInitiators(r.record)
;if(a.length?a.forEach(e=>{const n=t.urlToNodeMap.get(e)||[];1===n.length&&n[0].startTime<=r.startTime&&!n[0].isDependentOn(r)?r.addDependency(n[0]):i.isDependentOn(r)||i.addDependent(r)}):i.isDependentOn(r)||i.addDependent(r),r!==e&&0===r.getDependencies().length&&r.addDependency(e),!r.record.redirects)return;const s=[...r.record.redirects,r.record];for(let e=1;e<s.length;e++){const r=t.idToNodeMap.get(s[e-1].requestId),n=t.idToNodeMap.get(s[e].requestId);n&&r&&n.addDependency(r)}})}static linkCPUNodes(e,t,r){function addDependentNetworkRequest(e,r){const n=t.idToNodeMap.get(r);!n||n.record.resourceType!==l.TYPES.XHR||n.startTime<=e.startTime||e.addDependent(n)}function addDependencyOnFrame(e,r){if(!r)return;const n=t.frameIdToNodeMap.get(r);n&&(n.startTime>=e.startTime||e.addDependency(n))}function addDependencyOnUrl(e,r){if(!r)return;const n=t.urlToNodeMap.get(r)||[];let i=null,a=1/0;for(const t of n){if(e.startTime<=t.startTime)return;const r=e.startTime-t.endTime
;r>=-1e5&&r<a&&(i=t,a=r)}i&&e.addDependency(i)}const n=new Map;for(const t of r){for(const e of t.childEvents){if(!e.args.data)continue;const r=e.args.data.url,i=(e.args.data.stackTrace||[]).map(e=>e.url).filter(Boolean);switch(e.name){case"TimerInstall":n.set(e.args.data.timerId,t),i.forEach(e=>addDependencyOnUrl(t,e));break;case"TimerFire":{const r=n.get(e.args.data.timerId);if(!r||r.endTime>t.startTime)break;r.addDependent(t);break}case"InvalidateLayout":case"ScheduleStyleRecalculation":addDependencyOnFrame(t,e.args.data.frame),i.forEach(e=>addDependencyOnUrl(t,e));break;case"EvaluateScript":addDependencyOnFrame(t,e.args.data.frame),addDependencyOnUrl(t,r),i.forEach(e=>addDependencyOnUrl(t,e));break;case"XHRReadyStateChange":if(4!==e.args.data.readyState)break;addDependencyOnUrl(t,r),i.forEach(e=>addDependencyOnUrl(t,e));break;case"FunctionCall":case"v8.compile":addDependencyOnFrame(t,e.args.data.frame),addDependencyOnUrl(t,r);break;case"ParseAuthorStyleSheet":
addDependencyOnFrame(t,e.args.data.frame),addDependencyOnUrl(t,e.args.data.styleSheetUrl);break;case"ResourceSendRequest":addDependencyOnFrame(t,e.args.data.frame),addDependentNetworkRequest(t,e.args.data.requestId),i.forEach(e=>addDependencyOnUrl(t,e))}}0===t.getNumberOfDependencies()&&t.addDependency(e)}const i=1e3*d;let a=!1,s=!1,o=!1;for(const e of r){let t=!1;!a&&e.childEvents.some(e=>"Layout"===e.name)&&(t=a=!0),!s&&e.childEvents.some(e=>"Paint"===e.name)&&(t=s=!0),!o&&e.childEvents.some(e=>"ParseHTML"===e.name)&&(t=o=!0),t||e.event.dur>=i||(1===e.getNumberOfDependencies()||e.getNumberOfDependents()<=1)&&PageDependencyGraph._pruneNode(e)}}static _pruneNode(e){const t=e.getDependencies(),r=e.getDependents();for(const n of t){e.removeDependency(n);for(const e of r)n.addDependent(e)}for(const t of r)e.removeDependent(t)}static createGraph(e,t){
const r=PageDependencyGraph.getNetworkNodeOutput(t),n=PageDependencyGraph.getCPUNodes(e),a=t.reduce((e,t)=>t.startTime<e.startTime?t:e),o=r.idToNodeMap.get(a.requestId),l=s.findMainDocument(t),c=r.idToNodeMap.get(l.requestId);if(!o||!c)throw new Error(`${o?"mainDocument":"root"}Node not found.`);if(!(c===o||c.record.redirects&&c.record.redirects.includes(o.record)))throw new Error("Root node was not in redirect chain of mainDocument");if(PageDependencyGraph.linkNetworkNodes(o,r),PageDependencyGraph.linkCPUNodes(o,r,n),c.setIsMainDocument(!0),i.hasCycle(o))throw new Error("Invalid dependency graph created, cycle detected");return o}static printGraph(e,t=100){function padRight(e,t,r=" "){return e+r.repeat(Math.max(t-e.length,0))}const r=[];e.traverse(e=>r.push(e)),r.sort((e,t)=>e.startTime-t.startTime);const n=r[0].startTime,i=(r.reduce((e,t)=>Math.max(e,t.endTime),0)-n)/t;r.forEach(e=>{
const r=Math.round((e.startTime-n)/i),a=Math.ceil((e.endTime-e.startTime)/i),s=padRight("",r)+padRight("",a,"="),o=e.record?e.record.url:e.type;console.log(padRight(s,t),`| ${o.slice(0,30)}`)})}static async compute_(e,t){const r=e.trace,n=e.devtoolsLog,[i,a]=await Promise.all([c.request(r,t),u.request(n,t)]);return PageDependencyGraph.createGraph(i,a)}}t.exports=n(PageDependencyGraph)},{"../lib/dependency-graph/cpu-node.js":70,"../lib/dependency-graph/network-node.js":71,"../lib/dependency-graph/simulator/network-analyzer.js":74,"../lib/network-request.js":90,"../lib/tracehouse/trace-processor.js":101,"./computed-artifact.js":9,"./network-records.js":40,"./trace-of-tab.js":45}],42:[function(e,t,r){"use strict";const n=e("./computed-artifact.js"),i=e("./network-records.js"),a=e("../lib/url-shim.js"),s=e("./main-resource.js"),o=e("../config/budget.js"),l=e("../report/html/renderer/util.js");class ResourceSummary{static determineResourceType(e){if(!e.resourceType)return"other";return{
Stylesheet:"stylesheet",Image:"image",Media:"media",Font:"font",Script:"script",Document:"document"}[e.resourceType]||"other"}static summarize(e,t,r){const n={stylesheet:{count:0,resourceSize:0,transferSize:0},image:{count:0,resourceSize:0,transferSize:0},media:{count:0,resourceSize:0,transferSize:0},font:{count:0,resourceSize:0,transferSize:0},script:{count:0,resourceSize:0,transferSize:0},document:{count:0,resourceSize:0,transferSize:0},other:{count:0,resourceSize:0,transferSize:0},total:{count:0,resourceSize:0,transferSize:0},"third-party":{count:0,resourceSize:0,transferSize:0}},i=o.getMatchingBudget(r.settings.budgets,t);let s=[];if(i&&i.options&&i.options.firstPartyHostnames)s=i.options.firstPartyHostnames;else{const e=l.getRootDomain(t);s=[`*.${e}`]}return e.filter(e=>{if("other"===this.determineResourceType(e)&&e.url.endsWith("/favicon.ico"))return!1;const t=new a(e.url).protocol.slice(0,-1);return!a.NON_NETWORK_PROTOCOLS.includes(t)}).forEach(e=>{
const t=this.determineResourceType(e);n[t].count++,n[t].resourceSize+=e.resourceSize,n[t].transferSize+=e.transferSize,n.total.count++,n.total.resourceSize+=e.resourceSize,n.total.transferSize+=e.transferSize,s.some(t=>{const r=new a(e.url);return t.startsWith("*.")?r.hostname.endsWith(t.slice(2)):r.hostname===t})||(n["third-party"].count++,n["third-party"].resourceSize+=e.resourceSize,n["third-party"].transferSize+=e.transferSize)}),n}static async compute_(e,t){const[r,n]=await Promise.all([i.request(e.devtoolsLog,t),s.request(e,t)]);return ResourceSummary.summarize(r,n.url,t)}}t.exports=n(ResourceSummary)},{"../config/budget.js":50,"../lib/url-shim.js":"url","../report/html/renderer/util.js":105,"./computed-artifact.js":9,"./main-resource.js":13,"./network-records.js":40}],43:[function(e,t,r){"use strict";const n=e("./computed-artifact.js"),i="Screenshot";t.exports=n(class Screenshots{static async compute_(e){return e.traceEvents.filter(e=>e.name===i).map(e=>({timestamp:e.ts,
datauri:`data:image/jpeg;base64,${e.args.snapshot}`}))}})},{"./computed-artifact.js":9}],44:[function(e,t,r){"use strict";const n=e("./computed-artifact.js"),i=e("speedline-core"),a=e("../lib/lh-error.js"),s=e("./trace-of-tab.js");t.exports=n(class Speedline{static async compute_(e,t){return s.request(e,t).then(t=>{const r=e.traceEvents.slice(),n=t.timestamps.timeOrigin;return i(r,{timeOrigin:n,fastMode:!0,include:"speedIndex"})}).catch(e=>{if(/No screenshots found in trace/.test(e.message))throw new a(a.errors.NO_SCREENSHOTS);throw e}).then(e=>{if(0===e.frames.length)throw new a(a.errors.NO_SPEEDLINE_FRAMES);if(0===e.speedIndex)throw new a(a.errors.SPEEDINDEX_OF_ZERO);return e})}})},{"../lib/lh-error.js":86,"./computed-artifact.js":9,"./trace-of-tab.js":45,"speedline-core":207}],45:[function(e,t,r){"use strict";const n=e("./computed-artifact.js"),i=e("../lib/lh-error.js"),a=e("../lib/tracehouse/trace-processor.js");class LHTraceProcessor extends a{static createNoNavstartError(){
return new i(i.errors.NO_NAVSTART)}static createNoTracingStartedError(){return new i(i.errors.NO_TRACING_STARTED)}}t.exports=n(class TraceOfTab{static async compute_(e){const t=await LHTraceProcessor.computeTraceOfTab(e),{timings:r,timestamps:n,firstContentfulPaintEvt:a}=t,{firstContentfulPaint:s}=r,{firstContentfulPaint:o}=n;if(!a||void 0===s||void 0===o)throw new i(i.errors.NO_FCP);return{...t,firstContentfulPaintEvt:a,timings:{...r,firstContentfulPaint:s},timestamps:{...n,firstContentfulPaint:o}}}})},{"../lib/lh-error.js":86,"../lib/tracehouse/trace-processor.js":101,"./computed-artifact.js":9}],46:[function(e,t,r){"use strict";const n=e("./computed-artifact.js"),i=e("../audits/byte-efficiency/byte-efficiency-audit.js"),a=e("./network-records.js"),s=100;class UnusedCSS{static indexStylesheetsById(e,t){const r=t.filter(e=>e.resourceSize>0).reduce((e,t)=>(e[t.url]=t,e),{});return e.reduce((e,t)=>(e[t.header.styleSheetId]=Object.assign({usedRules:[],networkRecord:r[t.header.sourceURL]
},t),e),{})}static indexUsedRules(e,t){e.forEach(e=>{const r=t[e.styleSheetId];r&&e.used&&r.usedRules.push(e)})}static computeUsage(e){let t=0;const r=e.content.length;for(const r of e.usedRules)t+=r.endOffset-r.startOffset;const n=i.estimateTransferSize(e.networkRecord,r,"Stylesheet"),a=(r-t)/r;return{wastedBytes:Math.round(a*n),wastedPercent:100*a,totalBytes:n}}static determineContentPreview(e){let t=(e||"").slice(0,5*s).replace(/( {2,}|\t)+/g,"  ").replace(/\n\s+}/g,"\n}").trim();if(t.length>s){const e=t.indexOf("{"),r=t.indexOf("}");if(-1===e||-1===r||e>r||e>s)t=t.slice(0,s)+"...";else if(r<s)t=t.slice(0,r+1)+" ...";else{const r=t.slice(0,s).lastIndexOf(";");t=r<e?t.slice(0,s)+"... } ...":t.slice(0,r+1)+" ... } ..."}}return t}static mapSheetToResult(e,t){let r=e.header.sourceURL;if(!r||r===t){r=UnusedCSS.determineContentPreview(e.content)}return{url:r,...UnusedCSS.computeUsage(e)}}static async compute_(e,t){
const{CSSUsage:r,URL:n,devtoolsLog:i}=e,s=await a.request(i,t),o=UnusedCSS.indexStylesheetsById(r.stylesheets,s);return UnusedCSS.indexUsedRules(r.rules,o),Object.keys(o).map(e=>UnusedCSS.mapSheetToResult(o[e],n.finalUrl))}}t.exports=n(UnusedCSS)},{"../audits/byte-efficiency/byte-efficiency-audit.js":4,"./computed-artifact.js":9,"./network-records.js":40}],47:[function(e,t,r){"use strict";const n=e("./computed-artifact.js");class UnusedJavascriptSummary{static computeWaste(e){let t=0;for(const r of e.functions)t=Math.max(t,...r.ranges.map(e=>e.endOffset));const r=new Uint8Array(t);for(const t of e.functions)for(const e of t.ranges)if(0===e.count)for(let t=e.startOffset;t<e.endOffset;t++)r[t]=1;let n=0;for(const e of r)n+=e;return{unusedByIndex:r,unusedLength:n,contentLength:t}}static createItem(e,t){const r=t.unused/t.content||0,n=Math.round(t.content*r);return{url:e,totalBytes:t.content,wastedBytes:n,wastedPercent:100*r}}static determineLengths(e){let t=0,r=0
;for(const n of e)t+=n.unusedLength,r+=n.contentLength;return{content:r,unused:t}}static createSourceWastedBytes(e,t){if(!t.script.content)return;const r={},n=t.script.content.split("\n").map(e=>e.length);let i=0;const a=n.map(e=>{const t=i;return i+=e+1,t});t.map.computeLastGeneratedColumns();for(const i of t.map.mappings()){let t=a[i.lineNumber];t+=i.columnNumber;const s=i.lastColumnNumber-1||n[i.lineNumber];for(let n=i.columnNumber;n<=s;n++){if(e.every(e=>1===e.unusedByIndex[t])){const e=i.sourceURL||"(unmapped)";r[e]=(r[e]||0)+1}t+=1}}const s=Object.entries(r).sort(([e,t],[r,n])=>n-t),o={};for(const[e,t]of s)o[e]=t;return o}static async compute_(e){const{url:t,scriptCoverages:r,bundle:n}=e,i=r.map(UnusedJavascriptSummary.computeWaste),a=UnusedJavascriptSummary.determineLengths(i),s=UnusedJavascriptSummary.createItem(t,a);return n?{...s,sourcesWastedBytes:UnusedJavascriptSummary.createSourceWastedBytes(i,n)}:s}}t.exports=n(UnusedJavascriptSummary)},{"./computed-artifact.js":9}],
48:[function(e,t,r){"use strict";const n=e("./computed-artifact.js"),i=e("./trace-of-tab.js");t.exports=n(class UserTimings{static async compute_(e,t){const r=await i.request(e,t),n=[],a={};return r.processEvents.filter(e=>!!e.cat.includes("blink.user_timing")&&("requestStart"!==e.name&&"navigationStart"!==e.name&&"paintNonDefaultBackgroundColor"!==e.name&&void 0===e.args.frame)).forEach(e=>{"R"===e.ph||"I"===e.ph.toUpperCase()?n.push({name:e.name,isMark:!0,args:e.args,startTime:e.ts}):"b"===e.ph.toLowerCase()?a[e.name]=e.ts:"e"===e.ph.toLowerCase()&&n.push({name:e.name,isMark:!1,args:e.args,startTime:a[e.name],endTime:e.ts,duration:e.ts-a[e.name]})}),n.forEach(e=>{e.startTime=(e.startTime-r.timeOriginEvt.ts)/1e3,e.isMark||(e.endTime=(e.endTime-r.timeOriginEvt.ts)/1e3,e.duration=e.duration/1e3)}),n}})},{"./computed-artifact.js":9,"./trace-of-tab.js":45}],49:[function(e,t,r){"use strict";const n=e("metaviewport-parser"),i=e("./computed-artifact.js");t.exports=i(class ViewportMeta{
static async compute_(e){const t=e.find(e=>"viewport"===e.name);if(!t)return{hasViewportTag:!1,isMobileOptimized:!1,parserWarnings:[]};const r=[],i=n.parseMetaViewPortContent(t.content||"");Object.keys(i.unknownProperties).length&&r.push(`Invalid properties found: ${JSON.stringify(i.unknownProperties)}`),Object.keys(i.invalidValues).length&&r.push(`Invalid values found: ${JSON.stringify(i.invalidValues)}`);const a=i.validProperties;return{hasViewportTag:!0,isMobileOptimized:Boolean(a.width||a["initial-scale"]),parserWarnings:r}}})},{"./computed-artifact.js":9,"metaviewport-parser":172}],50:[function(e,t,r){"use strict";function isArrayOfUnknownObjects(e){return Array.isArray(e)&&e.every(isObjectOfUnknownProperties)}function isObjectOfUnknownProperties(e){return"object"==typeof e&&null!==e&&!Array.isArray(e)}function isNumber(e){return"number"==typeof e&&!isNaN(e)}class Budget{static assertNoExcessProperties(e,t){const r=Object.keys(e);if(r.length>0){const e=r.join(", ")
;throw new Error(`${t} has unrecognized properties: [${e}]`)}}static assertNoDuplicateStrings(e,t){const r=new Set;for(const n of e){if(r.has(n))throw new Error(`${t} has duplicate entry of type '${n}'`);r.add(n)}}static validateResourceBudget(e){const{resourceType:t,budget:r,...n}=e;Budget.assertNoExcessProperties(n,"Resource Budget");const i=["total","document","script","stylesheet","image","media","font","other","third-party"];if(!i.includes(t))throw new Error(`Invalid resource type: ${t}. \n`+`Valid resource types are: ${i.join(", ")}`);if(!isNumber(r))throw new Error(`Invalid budget: ${r}`);return{resourceType:t,budget:r}}static throwInvalidPathError(e,t){throw new Error(`Invalid path ${e}. ${t}\n`+"'Path' should be specified using the 'robots.txt' format.\nLearn more about the 'robots.txt' format here:\nhttps://developers.google.com/search/reference/robots_txt#url-matching-based-on-path-values")}static validatePath(e){if(void 0!==e){
if("string"==typeof e)return e.startsWith("/")?(e.match(/\*/g)||[]).length>1?this.throwInvalidPathError(e,"Path should only contain one '*'."):(e.match(/\$/g)||[]).length>1?this.throwInvalidPathError(e,"Path should only contain one '$' character."):e.includes("$")&&!e.endsWith("$")&&this.throwInvalidPathError(e,"'$' character should only occur at end of path."):this.throwInvalidPathError(e,"Path should start with '/'."),e;this.throwInvalidPathError(e,"Path should be a string.")}}static getMatchingBudget(e,t){if(null!==e)for(let r=e.length-1;r>=0;r--){const n=e[r];if(this.urlMatchesPattern(t,n.path))return n}}static urlMatchesPattern(e,t="/"){const r=new URL(e),n=r.pathname+r.search,i=t.includes("*"),a=t.includes("$");if(!i&&!a)return n.startsWith(t);if(!i&&a)return n===t.slice(0,-1);if(i&&!a){const[e,r]=t.split("*"),i=n.slice(e.length);return n.startsWith(e)&&i.includes(r)}if(i&&a){const[e,r]=t.split("*"),i=n.slice(e.length);return n.startsWith(e)&&i.endsWith(r.slice(0,-1))}return!1}
static validateTimingBudget(e){const{metric:t,budget:r,...n}=e;Budget.assertNoExcessProperties(n,"Timing Budget");const i=["first-contentful-paint","first-cpu-idle","interactive","first-meaningful-paint","max-potential-fid","estimated-input-latency","total-blocking-time","speed-index","largest-contentful-paint","cumulative-layout-shift"];if(!i.includes(t))throw new Error(`Invalid timing metric: ${t}. \n`+`Valid timing metrics are: ${i.join(", ")}`);if(!isNumber(r))throw new Error(`Invalid budget: ${r}`);return{metric:t,budget:r}}static validateHostname(e){const t=`${e} is not a valid hostname.`;if(0===e.length)throw new Error(t);if(e.includes("/"))throw new Error(t);if(e.includes(":"))throw new Error(t);if(e.includes("*")&&(!e.startsWith("*.")||e.lastIndexOf("*")>0))throw new Error(t);return e}static validateHostnames(e){if(Array.isArray(e)&&e.every(e=>"string"==typeof e))return e.map(Budget.validateHostname)
;if(void 0!==e)throw new Error("firstPartyHostnames should be defined as an array of strings.")}static initializeBudget(e){if(!isArrayOfUnknownObjects(e=JSON.parse(JSON.stringify(e))))throw new Error("Budget file is not defined as an array of budgets.");return e.map((e,t)=>{const r={},{path:n,options:i,resourceSizes:a,resourceCounts:s,timings:o,...l}=e;if(Budget.assertNoExcessProperties(l,"Budget"),r.path=Budget.validatePath(n),isObjectOfUnknownProperties(i)){const{firstPartyHostnames:e,...t}=i;Budget.assertNoExcessProperties(t,"Options property"),r.options={},r.options.firstPartyHostnames=Budget.validateHostnames(e)}else if(void 0!==i)throw new Error(`Invalid options property in budget at index ${t}`);if(isArrayOfUnknownObjects(a))r.resourceSizes=a.map(Budget.validateResourceBudget),Budget.assertNoDuplicateStrings(r.resourceSizes.map(e=>e.resourceType),`budgets[${t}].resourceSizes`);else if(void 0!==a)throw new Error(`Invalid resourceSizes entry in budget at index ${t}`)
;if(isArrayOfUnknownObjects(s))r.resourceCounts=s.map(Budget.validateResourceBudget),Budget.assertNoDuplicateStrings(r.resourceCounts.map(e=>e.resourceType),`budgets[${t}].resourceCounts`);else if(void 0!==s)throw new Error(`Invalid resourceCounts entry in budget at index ${t}`);if(isArrayOfUnknownObjects(o))r.timings=o.map(Budget.validateTimingBudget),Budget.assertNoDuplicateStrings(r.timings.map(e=>e.metric),`budgets[${t}].timings`);else if(void 0!==o)throw new Error(`Invalid timings entry in budget at index ${t}`);return r})}}t.exports=Budget},{}],51:[function(e,t,r){(function(r,n,i){"use strict";const a=e("path"),s=e("../audits/audit.js"),o=e("../runner.js"),l=e("../lib/i18n/i18n.js"),c=function(e){const t=[];for(const r of e){const e=r.path&&t.find(e=>e.path===r.path);e?e.options=Object.assign({},e.options,r.options):t.push(r)}return t};function resolveModule(t,n,s){try{return e.resolve(t)}catch(e){}const o=a.resolve(r.cwd(),t);try{return e.resolve(o)}catch(e){}
const l="Unable to locate "+(s?`${s}: `:"")+`\`${t}\`.\n     Tried to require() from these locations:\n       ${i}\n       ${o}`;if(!n)throw new Error(l);const c=a.resolve(n,t);try{return e.resolve(c)}catch(e){}throw new Error(l+`\n       ${c}`)}t.exports={mergeOptionsOfItems:c,requireAudits:function requireAudits(t,r){const u=function expandAuditShorthand(e){return e?e.map(e=>{if("string"==typeof e)return{path:e,options:{}};if("implementation"in e&&"function"==typeof e.implementation.audit)return e;if("path"in e&&"string"==typeof e.path)return e;if("audit"in e&&"function"==typeof e.audit)return{implementation:e,options:{}};throw new Error("Invalid Audit type "+JSON.stringify(e))}):null}(t);if(!u)return null;const d=o.getAuditList(),m=u.map(t=>{let s;if("implementation"in t)s=t.implementation;else{const o=`${t.path}.js`,l=d.find(e=>e===o);let c=`../audits/${t.path}`;if(!l)if(n.isDevtools||n.isLightrider)c=t.path;else{const e=resolveModule(t.path,r,"audit");c=a.relative(i,e)}s=e(c)}
return{implementation:s,path:t.path,options:t.options||{}}}),p=c(m);return p.forEach(e=>(function assertValidAudit(e){const{implementation:t,path:r}=e,n=r||t&&t.meta&&t.meta.id||"Unknown audit";if("function"!=typeof t.audit||t.audit===s.audit)throw new Error(`${n} has no audit() method.`);if("string"!=typeof t.meta.id)throw new Error(`${n} has no meta.id property, or the property is not a string.`);if(!l.isStringOrIcuMessage(t.meta.title))throw new Error(`${n} has no meta.title property, or the property is not a string.`);if(!l.isStringOrIcuMessage(t.meta.failureTitle)&&t.meta.scoreDisplayMode===s.SCORING_MODES.BINARY)throw new Error(`${n} has no failureTitle and should.`);if(!l.isStringOrIcuMessage(t.meta.description))throw new Error(`${n} has no meta.description property, or the property is not a string.`);if(""===t.meta.description)throw new Error(`${n} has an empty meta.description string. Please add a description for the UI.`)
;if(!Array.isArray(t.meta.requiredArtifacts))throw new Error(`${n} has no meta.requiredArtifacts property, or the property is not an array.`)})(e)),p},resolveModule:resolveModule}}).call(this,e("_process"),"undefined"!=typeof global?global:"undefined"!=typeof self?self:"undefined"!=typeof window?window:{},"/lighthouse-core/config")},{"../audits/audit.js":3,"../lib/i18n/i18n.js":78,"../runner.js":107,_process:184,path:182}],52:[function(e,t,r){"use strict";const n=e("../lib/i18n/i18n.js");function isArrayOfUnknownObjects(e){return Array.isArray(e)&&e.every(isObjectOfUnknownProperties)}function isObjectOfUnknownProperties(e){return"object"==typeof e&&null!==e&&!Array.isArray(e)}function assertNoExcessProperties(e,t,r=""){r&&(r+=" ");const n=Object.keys(e);if(n.length>0){const e=n.join(", ");throw new Error(`${t} has unrecognized ${r}properties: [${e}]`)}}class ConfigPlugin{static _parseAuditsList(e,t){if(void 0!==e){
if(!isArrayOfUnknownObjects(e))throw new Error(`${t} has an invalid audits array.`);return e.map(e=>{const{path:r,...n}=e;if(assertNoExcessProperties(n,t,"audit"),"string"!=typeof r)throw new Error(`${t} has a missing audit path.`);return{path:r}})}}static _parseAuditRefsList(e,t){if(!isArrayOfUnknownObjects(e))throw new Error(`${t} has no valid auditsRefs.`);return e.map(e=>{const{id:r,weight:n,group:i,...a}=e;if(assertNoExcessProperties(a,t,"auditRef"),"string"!=typeof r)throw new Error(`${t} has an invalid auditRef id.`);if("number"!=typeof n)throw new Error(`${t} has an invalid auditRef weight.`);if("string"!=typeof i&&void 0!==i)throw new Error(`${t} has an invalid auditRef group.`);return{id:r,weight:n,group:i?`${t}-${i}`:i}})}static _parseCategory(e,t){if(!isObjectOfUnknownProperties(e))throw new Error(`${t} has no valid category.`);const{title:r,description:i,manualDescription:a,auditRefs:s,...o}=e;if(assertNoExcessProperties(o,t,"category"),
!n.isStringOrIcuMessage(r))throw new Error(`${t} has an invalid category tile.`);if(!n.isStringOrIcuMessage(i)&&void 0!==i)throw new Error(`${t} has an invalid category description.`);if(!n.isStringOrIcuMessage(a)&&void 0!==a)throw new Error(`${t} has an invalid category manualDescription.`);return{title:r,auditRefs:ConfigPlugin._parseAuditRefsList(s,t),description:i,manualDescription:a}}static _parseGroups(e,t){if(void 0===e)return;if(!isObjectOfUnknownProperties(e))throw new Error(`${t} groups json is not defined as an object.`);const r=Object.entries(e),i={};return r.forEach(([e,r])=>{if(!isObjectOfUnknownProperties(r))throw new Error(`${t} has a group not defined as an object.`);const{title:a,description:s,...o}=r;if(assertNoExcessProperties(o,t,"group"),!n.isStringOrIcuMessage(a))throw new Error(`${t} has an invalid group title.`);if(!n.isStringOrIcuMessage(s)&&void 0!==s)throw new Error(`${t} has an invalid group description.`);i[`${t}-${e}`]={title:a,description:s}}),i}
static parsePlugin(e,t){if(!isObjectOfUnknownProperties(e=JSON.parse(JSON.stringify(e))))throw new Error(`${t} is not defined as an object.`);const{audits:r,category:n,groups:i,...a}=e;return assertNoExcessProperties(a,t),{audits:ConfigPlugin._parseAuditsList(r,t),categories:{[t]:ConfigPlugin._parseCategory(n,t)},groups:ConfigPlugin._parseGroups(i,t)}}}t.exports=ConfigPlugin},{"../lib/i18n/i18n.js":78}],53:[function(e,t,r){(function(r,n){"use strict";const i="./default-config.js",a=e("./default-config.js"),s=e("./constants.js"),o=e("./../lib/i18n/i18n.js"),l=e("lodash.isequal"),c=e("lighthouse-logger"),u=e("path"),d=e("../runner.js"),m=e("./config-plugin.js"),p=e("./budget.js"),{requireAudits:h,mergeOptionsOfItems:g,resolveModule:f}=e("./config-helpers.js"),b=Object.keys({fetchTime:"",LighthouseRunWarnings:"",TestedAsMobileDevice:"",HostFormFactor:"",HostUserAgent:"",NetworkUserAgent:"",BenchmarkIndex:"",WebAppManifest:"",InstallabilityErrors:"",Stacks:"",traces:"",devtoolsLogs:"",
settings:"",URL:"",Timing:"",PageLoadError:""});function assertValidPluginName(e,t){if(!t.startsWith("lighthouse-plugin-"))throw new Error(`plugin name '${t}' does not start with 'lighthouse-plugin-'`);if(e.categories&&e.categories[t])throw new Error(`plugin name '${t}' not allowed because it is the id of a category already found in config`)}const y=function _merge(e,t,r=!1){if(null==e)return t;if(void 0===t)return e;if(Array.isArray(t)){if(r)return t;if(!Array.isArray(e))throw new TypeError(`Expected array but got ${typeof e}`);const n=e.slice();return t.forEach(e=>{n.some(t=>l(t,e))||n.push(e)}),n}if("object"==typeof t){if("object"!=typeof e)throw new TypeError(`Expected object but got ${typeof e}`);if(Array.isArray(e))throw new TypeError("Expected object but got Array");return Object.keys(t).forEach(n=>{const i=r||"settings"===n&&"object"==typeof e[n];e[n]=_merge(e[n],t[n],i)}),e}return t};function cloneArrayWithPluginSafety(e){
return e.map(e=>"object"==typeof e?Object.assign(Object.create(Object.getPrototypeOf(e)),e):e)}function deepClone(e){return JSON.parse(JSON.stringify(e))}function deepCloneConfigJson(e){const t=deepClone(e);if(Array.isArray(t.passes)&&Array.isArray(e.passes))for(let r=0;r<t.passes.length;r++){t.passes[r].gatherers=cloneArrayWithPluginSafety(e.passes[r].gatherers||[])}return Array.isArray(e.audits)&&(t.audits=cloneArrayWithPluginSafety(e.audits)),t}class Config{constructor(e,t){const r={msg:"Create config",id:"lh:init:config"};c.time(r,"verbose");let s=t&&t.configPath;if(e||(e=a,s=u.resolve(n,i)),s&&!u.isAbsolute(s))throw new Error("configPath must be an absolute path.");(e=deepCloneConfigJson(e)).extends&&(e=Config.extendConfigJSON(deepCloneConfigJson(a),e));const o=s?u.dirname(s):void 0;e=Config.mergePlugins(e,t,o);const l=Config.initSettings(e.settings,t),d=Config.augmentPassesWithDefaults(e.passes);Config.adjustDefaultPassForThrottling(l,d);const m=Config.requireGatherers(d,o)
;this.settings=l,this.passes=m,this.audits=Config.requireAudits(e.audits,o),this.categories=e.categories||null,this.groups=e.groups||null,Config.filterConfigIfNeeded(this),function assertValidPasses(e,t){if(!Array.isArray(e))return;const r=Config.getGatherersRequestedByAudits(t),n=new Set(b);e.forEach((e,t)=>{0===t&&"fatal"!==e.loadFailureMode&&(c.warn(`"${e.passName}" is the first pass but was marked as non-fatal. `+"The first pass will always be treated as loadFailureMode=fatal."),e.loadFailureMode="fatal"),e.gatherers.forEach(e=>{const t=e.instance;if(n.add(t.name),!r.has(t.name)){const e=`${t.name} gatherer requested, however no audit requires it.`;c.warn("config",e)}})});for(const e of t||[]){const t=e.implementation.meta;for(const e of t.requiredArtifacts)if(!n.has(e))throw new Error(`${e} gatherer, required by audit ${t.id}, `+"was not found in config.")}const i=new Set;e.forEach(e=>{const t=e.passName
;if(i.has(t))throw new Error(`Passes must have unique names (repeated passName: ${t}.`);i.add(t)})}(this.passes,this.audits),function assertValidCategories(e,t,r){if(!e)return;const n=new Map((t||[]).map(e=>[e.implementation.meta.id,e]));Object.keys(e).forEach(t=>{e[t].auditRefs.forEach((e,i)=>{if(!e.id)throw new Error(`missing an audit id at ${t}[${i}]`);const a=n.get(e.id);if(!a)throw new Error(`could not find ${e.id} audit for category ${t}`);const s="manual"===a.implementation.meta.scoreDisplayMode;if("accessibility"===t&&!e.group&&!s)throw new Error(`${e.id} accessibility audit does not have a group`);if(e.weight>0&&s)throw new Error(`${e.id} is manual but has a positive weight`);if(e.group&&(!r||!r[e.group]))throw new Error(`${e.id} references unknown group ${e.group}`)})})}(this.categories,this.audits,this.groups),c.timeEnd(r)}getPrintString(){const e=deepClone(this);if(e.passes)for(const t of e.passes)for(const e of t.gatherers)e.implementation=void 0,e.instance=void 0,
0===Object.keys(e.options).length&&(e.options=void 0);if(e.audits)for(const t of e.audits)t.implementation=void 0,0===Object.keys(t.options).length&&(t.options=void 0);return o.replaceIcuMessages(e,e.settings.locale),JSON.stringify(e,null,2)}static extendConfigJSON(e,t){if(t.passes&&e.passes){for(const r of t.passes){const t=r.passName||s.defaultPassConfig.passName,n=e.passes.find(e=>e.passName===t);n?y(n,r):e.passes.push(r)}delete t.passes}return y(e,t)}static mergePlugins(t,n,i){const a=t.plugins||[],s=n&&n.plugins||[],o=new Set([...a,...s]);for(const n of o){assertValidPluginName(t,n);const a=r.isDevtools?n:f(n,i,"plugin"),s=e(a),o=m.parsePlugin(s,n);t=Config.extendConfigJSON(t,o)}return t}static augmentPassesWithDefaults(e){if(!e)return null;const{defaultPassConfig:t}=s;return e.map(e=>y(deepClone(t),e))}static initSettings(e={},t){const r=o.lookupLocale(t&&t.locale||e.locale),{defaultSettings:n}=s,i=y(deepClone(n),e,!0),a=y(i||{},function cleanFlagsForSettings(e={}){const t={}
;for(const r of Object.keys(e))r in s.defaultSettings&&(t[r]=e[r]);return t}(t),!0);return a.budgets&&(a.budgets=p.initializeBudget(a.budgets)),a.locale=r,a}static expandGathererShorthand(e){return e.map(e=>{if("string"==typeof e)return{path:e,options:{}};if("implementation"in e||"instance"in e)return e;if("path"in e){if("string"!=typeof e.path)throw new Error("Invalid Gatherer type "+JSON.stringify(e));return e}if("function"==typeof e)return{implementation:e,options:{}};if(e&&"function"==typeof e.beforePass)return{instance:e,options:{}};throw new Error("Invalid Gatherer type "+JSON.stringify(e))})}static adjustDefaultPassForThrottling(e,t){if(!t||"devtools"!==e.throttlingMethod&&"provided"!==e.throttlingMethod)return;const r=t.find(e=>"defaultPass"===e.passName);if(!r)return;const n=s.nonSimulatedPassConfigOverrides;r.pauseAfterFcpMs=Math.max(n.pauseAfterFcpMs,r.pauseAfterFcpMs),r.pauseAfterLoadMs=Math.max(n.pauseAfterLoadMs,r.pauseAfterLoadMs),
r.cpuQuietThresholdMs=Math.max(n.cpuQuietThresholdMs,r.cpuQuietThresholdMs),r.networkQuietThresholdMs=Math.max(n.networkQuietThresholdMs,r.networkQuietThresholdMs)}static filterConfigIfNeeded(e){const t=e.settings;if(!t.onlyCategories&&!t.onlyAudits&&!t.skipAudits)return;const{categories:r,requestedAuditNames:n}=Config.filterCategoriesAndAudits(e.categories,t),i=e.audits&&e.audits.filter(e=>n.has(e.implementation.meta.id)),a=Config.getGatherersRequestedByAudits(i),s=Config.generatePassesNeededByGatherers(e.passes,a);e.categories=r,e.audits=i,e.passes=s}static filterCategoriesAndAudits(e,t){if(!e)return{categories:null,requestedAuditNames:new Set};if(t.onlyAudits&&t.skipAudits)throw new Error("Cannot set both skipAudits and onlyAudits");const r={},n=!!t.onlyCategories,i=!!t.onlyAudits,a=t.onlyCategories||[],s=t.onlyAudits||[],o=t.skipAudits||[];a.forEach(t=>{e[t]||c.warn("config",`unrecognized category in 'onlyCategories': ${t}`)});const l=new Set(s.concat(o));for(const t of l){
const r=Object.keys(e).find(r=>{return!!e[r].auditRefs.find(e=>e.id===t)});if(r)s.includes(t)&&a.includes(r)&&c.warn("config",`${t} in 'onlyAudits' is already included by `+`${r} in 'onlyCategories'`);else{const e=o.includes(t)?"skipAudits":"onlyAudits";c.warn("config",`unrecognized audit in '${e}': ${t}`)}}const u=new Set(s);return o.forEach(e=>u.delete(e)),Object.keys(e).forEach(t=>{const l=deepClone(e[t]);if(n&&i)a.includes(t)||(l.auditRefs=l.auditRefs.filter(e=>s.includes(e.id)));else if(n){if(!a.includes(t))return}else i&&(l.auditRefs=l.auditRefs.filter(e=>s.includes(e.id)));l.auditRefs=l.auditRefs.filter(e=>!o.includes(e.id)),l.auditRefs.length&&(r[t]=l,l.auditRefs.forEach(e=>u.add(e.id)))}),{categories:r,requestedAuditNames:u}}static getGatherersRequestedByAudits(e){if(!e)return new Set;const t=new Set;for(const r of e){const{requiredArtifacts:e,__internalOptionalArtifacts:n}=r.implementation.meta;e.forEach(e=>t.add(e)),n&&n.forEach(e=>t.add(e))}return t}
static generatePassesNeededByGatherers(e,t){if(!e)return null;const r=t.has("traces");return e.map(e=>{if(e.gatherers=e.gatherers.filter(e=>{const r=e.instance;return t.has(r.name)}),e.recordTrace&&!r){const t=e.passName||"unknown pass";c.warn("config",`Trace not requested by an audit, dropping trace in ${t}`),e.recordTrace=!1}return e}).filter(e=>!!e.recordTrace||("defaultPass"===e.passName||e.gatherers.length>0))}static requireAudits(e,t){const r={msg:"Requiring audits",id:"lh:config:requireAudits"};c.time(r,"verbose");const n=h(e,t);return c.timeEnd(r),n}static requireGathererFromPath(t,r,n,i){const a=n.find(e=>e===`${t}.js`);let s=`../gather/gatherers/${t}`;a||(s=f(t,i,"gatherer"));const o=e(s);return{instance:new o,implementation:o,path:t,options:r||{}}}static requireGatherers(e,t){if(!e)return null;const r={msg:"Requiring gatherers",id:"lh:config:requireGatherers"};c.time(r,"verbose");const n=d.getGathererList(),i=e.map(e=>{
const r=Config.expandGathererShorthand(e.gatherers).map(e=>{if(e.instance)return{instance:e.instance,implementation:e.implementation,path:e.path,options:e.options||{}};if(e.implementation){return{instance:new(0,e.implementation),implementation:e.implementation,path:e.path,options:e.options||{}}}if(e.path){const r=e.path,i=e.options;return Config.requireGathererFromPath(r,i,n,t)}throw new Error("Invalid expanded Gatherer: "+JSON.stringify(e))}),i=g(r);return i.forEach(e=>(function assertValidGatherer(e,t){if(t=t||e.name||"gatherer","function"!=typeof e.beforePass)throw new Error(`${t} has no beforePass() method.`);if("function"!=typeof e.pass)throw new Error(`${t} has no pass() method.`);if("function"!=typeof e.afterPass)throw new Error(`${t} has no afterPass() method.`)})(e.instance,e.path)),Object.assign(e,{gatherers:i})});return c.timeEnd(r),i}}t.exports=Config
}).call(this,"undefined"!=typeof global?global:"undefined"!=typeof self?self:"undefined"!=typeof window?window:{},"/lighthouse-core/config")},{"../runner.js":107,"./../lib/i18n/i18n.js":78,"./budget.js":50,"./config-helpers.js":51,"./config-plugin.js":52,"./constants.js":54,"./default-config.js":55,"lighthouse-logger":141,"lodash.isequal":169,path:182}],54:[function(e,t,r){"use strict";const n={DEVTOOLS_RTT_ADJUSTMENT_FACTOR:3.75,DEVTOOLS_THROUGHPUT_ADJUSTMENT_FACTOR:.9,mobileSlow4G:{rttMs:150,throughputKbps:1638.4,requestLatencyMs:562.5,downloadThroughputKbps:1638.4*.9,uploadThroughputKbps:675,cpuSlowdownMultiplier:4},mobileRegular3G:{rttMs:300,throughputKbps:700,requestLatencyMs:1125,downloadThroughputKbps:630,uploadThroughputKbps:630,cpuSlowdownMultiplier:4},desktopDense4G:{rttMs:40,throughputKbps:10240,cpuSlowdownMultiplier:1,requestLatencyMs:0,downloadThroughputKbps:0,uploadThroughputKbps:0}},i={output:"json",maxWaitForFcp:3e4,maxWaitForLoad:45e3,throttlingMethod:"simulate",
throttling:n.mobileSlow4G,auditMode:!1,gatherMode:!1,disableStorageReset:!1,emulatedFormFactor:"mobile",internalDisableDeviceScreenEmulation:!1,channel:"node",budgets:null,locale:"en-US",blockedUrlPatterns:null,additionalTraceCategories:null,extraHeaders:null,precomputedLanternData:null,onlyAudits:null,onlyCategories:null,skipAudits:null};t.exports={throttling:n,defaultSettings:i,defaultPassConfig:{passName:"defaultPass",loadFailureMode:"fatal",recordTrace:!1,useThrottling:!1,pauseAfterFcpMs:0,pauseAfterLoadMs:0,networkQuietThresholdMs:0,cpuQuietThresholdMs:0,blockedUrlPatterns:[],blankPage:"about:blank",gatherers:[]},nonSimulatedPassConfigOverrides:{pauseAfterFcpMs:5250,pauseAfterLoadMs:5250,networkQuietThresholdMs:5250,cpuQuietThresholdMs:5250}}},{}],55:[function(e,t,r){(function(r){"use strict";const n=e("./constants.js"),i=e("../lib/i18n/i18n.js"),a={performanceCategoryTitle:"Performance",budgetsGroupTitle:"Budgets",
budgetsGroupDescription:"Performance budgets set standards for the performance of your site.",metricGroupTitle:"Metrics",loadOpportunitiesGroupTitle:"Opportunities",loadOpportunitiesGroupDescription:"These suggestions can help your page load faster. They don't [directly affect](https://web.dev/performance-scoring/) the Performance score.",firstPaintImprovementsGroupTitle:"First Paint Improvements",firstPaintImprovementsGroupDescription:"The most critical aspect of performance is how quickly pixels are rendered onscreen. Key metrics: First Contentful Paint, First Meaningful Paint",overallImprovementsGroupTitle:"Overall Improvements",overallImprovementsGroupDescription:"Enhance the overall loading experience, so the page is responsive and ready to use as soon as possible. Key metrics: Time to Interactive, Speed Index",diagnosticsGroupTitle:"Diagnostics",
diagnosticsGroupDescription:"More information about the performance of your application. These numbers don't [directly affect](https://web.dev/performance-scoring/) the Performance score.",a11yCategoryTitle:"Accessibility",a11yCategoryDescription:"These checks highlight opportunities to [improve the accessibility of your web app](https://developers.google.com/web/fundamentals/accessibility). Only a subset of accessibility issues can be automatically detected so manual testing is also encouraged.",a11yCategoryManualDescription:"These items address areas which an automated testing tool cannot cover. Learn more in our guide on [conducting an accessibility review](https://developers.google.com/web/fundamentals/accessibility/how-to-review).",a11yBestPracticesGroupTitle:"Best practices",a11yBestPracticesGroupDescription:"These items highlight common accessibility best practices.",a11yColorContrastGroupTitle:"Contrast",
a11yColorContrastGroupDescription:"These are opportunities to improve the legibility of your content.",a11yNamesLabelsGroupTitle:"Names and labels",a11yNamesLabelsGroupDescription:"These are opportunities to improve the semantics of the controls in your application. This may enhance the experience for users of assistive technology, like a screen reader.",a11yNavigationGroupTitle:"Navigation",a11yNavigationGroupDescription:"These are opportunities to improve keyboard navigation in your application.",a11yAriaGroupTitle:"ARIA",a11yAriaGroupDescription:"These are opportunities to improve the usage of ARIA in your application which may enhance the experience for users of assistive technology, like a screen reader.",a11yLanguageGroupTitle:"Internationalization and localization",a11yLanguageGroupDescription:"These are opportunities to improve the interpretation of your content by users in different locales.",a11yAudioVideoGroupTitle:"Audio and video",
a11yAudioVideoGroupDescription:"These are opportunities to provide alternative content for audio and video. This may improve the experience for users with hearing or vision impairments.",a11yTablesListsVideoGroupTitle:"Tables and lists",a11yTablesListsVideoGroupDescription:"These are opportunities to improve the experience of reading tabular or list data using assistive technology, like a screen reader.",seoCategoryTitle:"SEO",seoCategoryDescription:"These checks ensure that your page is optimized for search engine results ranking. There are additional factors Lighthouse does not check that may affect your search ranking. [Learn more](https://support.google.com/webmasters/answer/35769).",seoCategoryManualDescription:"Run these additional validators on your site to check additional SEO best practices.",seoMobileGroupTitle:"Mobile Friendly",
seoMobileGroupDescription:"Make sure your pages are mobile friendly so users don’t have to pinch or zoom in order to read the content pages. [Learn more](https://developers.google.com/search/mobile-sites/).",seoContentGroupTitle:"Content Best Practices",seoContentGroupDescription:"Format your HTML in a way that enables crawlers to better understand your app’s content.",seoCrawlingGroupTitle:"Crawling and Indexing",seoCrawlingGroupDescription:"To appear in search results, crawlers need access to your app.",pwaCategoryTitle:"Progressive Web App",pwaCategoryDescription:"These checks validate the aspects of a Progressive Web App. [Learn more](https://developers.google.com/web/progressive-web-apps/checklist).",pwaCategoryManualDescription:"These checks are required by the baseline [PWA Checklist](https://developers.google.com/web/progressive-web-apps/checklist) but are not automatically checked by Lighthouse. They do not affect your score but it's important that you verify them manually.",
bestPracticesCategoryTitle:"Best Practices",bestPracticesTrustSafetyGroupTitle:"Trust and Safety",bestPracticesUXGroupTitle:"User Experience",bestPracticesBrowserCompatGroupTitle:"Browser Compatibility",bestPracticesGeneralGroupTitle:"General",pwaFastReliableGroupTitle:"Fast and reliable",pwaInstallableGroupTitle:"Installable",pwaOptimizedGroupTitle:"PWA Optimized"},s=i.createMessageInstanceIdFn(r,a),o={settings:n.defaultSettings,passes:[{passName:"defaultPass",recordTrace:!0,useThrottling:!0,pauseAfterFcpMs:1e3,pauseAfterLoadMs:1e3,networkQuietThresholdMs:1e3,cpuQuietThresholdMs:1e3,
gatherers:["css-usage","js-usage","viewport-dimensions","runtime-exceptions","console-messages","anchor-elements","image-elements","link-elements","meta-elements","script-elements","iframe-elements","form-elements","main-document-content","global-listeners","dobetterweb/appcache","dobetterweb/doctype","dobetterweb/domstats","dobetterweb/optimized-images","dobetterweb/password-inputs-with-prevented-paste","dobetterweb/response-compression","dobetterweb/tags-blocking-first-paint","seo/font-size","seo/embedded-content","seo/robots-txt","seo/tap-targets","accessibility","trace-elements","inspector-issues","source-maps"]},{passName:"offlinePass",loadFailureMode:"ignore",gatherers:["service-worker","offline","start-url"]},{passName:"redirectPass",loadFailureMode:"warn",blockedUrlPatterns:["*.css","*.jpg","*.jpeg","*.png","*.gif","*.svg","*.ttf","*.woff","*.woff2"],gatherers:["http-redirect","html-without-javascript"]}],
audits:["is-on-https","redirects-http","service-worker","works-offline","viewport","without-javascript","metrics/first-contentful-paint","metrics/largest-contentful-paint","metrics/first-meaningful-paint","load-fast-enough-for-pwa","metrics/speed-index","screenshot-thumbnails","final-screenshot","metrics/estimated-input-latency","metrics/total-blocking-time","metrics/max-potential-fid","metrics/cumulative-layout-shift","errors-in-console","server-response-time","metrics/first-cpu-idle","metrics/interactive","user-timings","critical-request-chains","redirects","installable-manifest","apple-touch-icon","splash-screen","themed-omnibox","maskable-icon","content-width","image-aspect-ratio","image-size-responsive","preload-fonts","deprecations","mainthread-work-breakdown","bootup-time","uses-rel-preload","uses-rel-preconnect","font-display","diagnostics","network-requests","network-rtt","network-server-latency","main-thread-tasks","metrics","offline-start-url","performance-budget","timing-budget","resource-summary","third-party-summary","largest-contentful-paint-element","layout-shift-elements","long-tasks","no-unload-listeners","non-composited-animations","unsized-images","valid-source-maps","manual/pwa-cross-browser","manual/pwa-page-transitions","manual/pwa-each-page-has-url","accessibility/accesskeys","accessibility/aria-allowed-attr","accessibility/aria-hidden-body","accessibility/aria-hidden-focus","accessibility/aria-input-field-name","accessibility/aria-required-attr","accessibility/aria-required-children","accessibility/aria-required-parent","accessibility/aria-roles","accessibility/aria-toggle-field-name","accessibility/aria-valid-attr-value","accessibility/aria-valid-attr","accessibility/button-name","accessibility/bypass","accessibility/color-contrast","accessibility/definition-list","accessibility/dlitem","accessibility/document-title","accessibility/duplicate-id-active","accessibility/duplicate-id-aria","accessibility/form-field-multiple-labels","accessibility/frame-title","accessibility/heading-order","accessibility/html-has-lang","accessibility/html-lang-valid","accessibility/image-alt","accessibility/input-image-alt","accessibility/label","accessibility/layout-table","accessibility/link-name","accessibility/list","accessibility/listitem","accessibility/meta-refresh","accessibility/meta-viewport","accessibility/object-alt","accessibility/tabindex","accessibility/td-headers-attr","accessibility/th-has-data-cells","accessibility/valid-lang","accessibility/video-caption","accessibility/video-description","accessibility/manual/custom-controls-labels","accessibility/manual/custom-controls-roles","accessibility/manual/focus-traps","accessibility/manual/focusable-controls","accessibility/manual/interactive-element-affordance","accessibility/manual/logical-tab-order","accessibility/manual/managed-focus","accessibility/manual/offscreen-content-hidden","accessibility/manual/use-landmarks","accessibility/manual/visual-order-follows-dom","byte-efficiency/uses-long-cache-ttl","byte-efficiency/total-byte-weight","byte-efficiency/offscreen-images","byte-efficiency/render-blocking-resources","byte-efficiency/unminified-css","byte-efficiency/unminified-javascript","byte-efficiency/unused-css-rules","byte-efficiency/unused-javascript","byte-efficiency/uses-webp-images","byte-efficiency/uses-optimized-images","byte-efficiency/uses-text-compression","byte-efficiency/uses-responsive-images","byte-efficiency/efficient-animated-content","byte-efficiency/duplicated-javascript","byte-efficiency/legacy-javascript","dobetterweb/appcache-manifest","dobetterweb/doctype","dobetterweb/charset","dobetterweb/dom-size","dobetterweb/external-anchors-use-rel-noopener","dobetterweb/geolocation-on-start","dobetterweb/no-document-write","dobetterweb/no-vulnerable-libraries","dobetterweb/js-libraries","dobetterweb/notification-on-start","dobetterweb/password-inputs-can-be-pasted-into","dobetterweb/uses-http2","dobetterweb/uses-passive-event-listeners","seo/meta-description","seo/http-status-code","seo/font-size","seo/link-text","seo/crawlable-anchors","seo/is-crawlable","seo/robots-txt","seo/tap-targets","seo/hreflang","seo/plugins","seo/canonical","seo/manual/structured-data"],
groups:{metrics:{title:s(a.metricGroupTitle)},"load-opportunities":{title:s(a.loadOpportunitiesGroupTitle),description:s(a.loadOpportunitiesGroupDescription)},budgets:{title:s(a.budgetsGroupTitle),description:s(a.budgetsGroupDescription)},diagnostics:{title:s(a.diagnosticsGroupTitle),description:s(a.diagnosticsGroupDescription)},"pwa-fast-reliable":{title:s(a.pwaFastReliableGroupTitle)},"pwa-installable":{title:s(a.pwaInstallableGroupTitle)},"pwa-optimized":{title:s(a.pwaOptimizedGroupTitle)},"a11y-best-practices":{title:s(a.a11yBestPracticesGroupTitle),description:s(a.a11yBestPracticesGroupDescription)},"a11y-color-contrast":{title:s(a.a11yColorContrastGroupTitle),description:s(a.a11yColorContrastGroupDescription)},"a11y-names-labels":{title:s(a.a11yNamesLabelsGroupTitle),description:s(a.a11yNamesLabelsGroupDescription)},"a11y-navigation":{title:s(a.a11yNavigationGroupTitle),description:s(a.a11yNavigationGroupDescription)},"a11y-aria":{title:s(a.a11yAriaGroupTitle),
description:s(a.a11yAriaGroupDescription)},"a11y-language":{title:s(a.a11yLanguageGroupTitle),description:s(a.a11yLanguageGroupDescription)},"a11y-audio-video":{title:s(a.a11yAudioVideoGroupTitle),description:s(a.a11yAudioVideoGroupDescription)},"a11y-tables-lists":{title:s(a.a11yTablesListsVideoGroupTitle),description:s(a.a11yTablesListsVideoGroupDescription)},"seo-mobile":{title:s(a.seoMobileGroupTitle),description:s(a.seoMobileGroupDescription)},"seo-content":{title:s(a.seoContentGroupTitle),description:s(a.seoContentGroupDescription)},"seo-crawl":{title:s(a.seoCrawlingGroupTitle),description:s(a.seoCrawlingGroupDescription)},"best-practices-trust-safety":{title:s(a.bestPracticesTrustSafetyGroupTitle)},"best-practices-ux":{title:s(a.bestPracticesUXGroupTitle)},"best-practices-browser-compat":{title:s(a.bestPracticesBrowserCompatGroupTitle)},"best-practices-general":{title:s(a.bestPracticesGeneralGroupTitle)}},categories:{performance:{title:s(a.performanceCategoryTitle),auditRefs:[{
id:"first-contentful-paint",weight:15,group:"metrics"},{id:"speed-index",weight:15,group:"metrics"},{id:"largest-contentful-paint",weight:25,group:"metrics"},{id:"interactive",weight:15,group:"metrics"},{id:"total-blocking-time",weight:25,group:"metrics"},{id:"cumulative-layout-shift",weight:5,group:"metrics"},{id:"first-cpu-idle",weight:0},{id:"max-potential-fid",weight:0},{id:"first-meaningful-paint",weight:0},{id:"estimated-input-latency",weight:0},{id:"render-blocking-resources",weight:0,group:"load-opportunities"},{id:"uses-responsive-images",weight:0,group:"load-opportunities"},{id:"offscreen-images",weight:0,group:"load-opportunities"},{id:"unminified-css",weight:0,group:"load-opportunities"},{id:"unminified-javascript",weight:0,group:"load-opportunities"},{id:"unused-css-rules",weight:0,group:"load-opportunities"},{id:"unused-javascript",weight:0,group:"load-opportunities"},{id:"uses-optimized-images",weight:0,group:"load-opportunities"},{id:"uses-webp-images",weight:0,
group:"load-opportunities"},{id:"uses-text-compression",weight:0,group:"load-opportunities"},{id:"uses-rel-preconnect",weight:0,group:"load-opportunities"},{id:"server-response-time",weight:0,group:"load-opportunities"},{id:"redirects",weight:0,group:"load-opportunities"},{id:"uses-rel-preload",weight:0,group:"load-opportunities"},{id:"uses-http2",weight:0,group:"load-opportunities"},{id:"efficient-animated-content",weight:0,group:"load-opportunities"},{id:"duplicated-javascript",weight:0,group:"load-opportunities"},{id:"legacy-javascript",weight:0,group:"load-opportunities"},{id:"total-byte-weight",weight:0,group:"diagnostics"},{id:"uses-long-cache-ttl",weight:0,group:"diagnostics"},{id:"dom-size",weight:0,group:"diagnostics"},{id:"critical-request-chains",weight:0,group:"diagnostics"},{id:"user-timings",weight:0,group:"diagnostics"},{id:"bootup-time",weight:0,group:"diagnostics"},{id:"mainthread-work-breakdown",weight:0,group:"diagnostics"},{id:"font-display",weight:0,
group:"diagnostics"},{id:"performance-budget",weight:0,group:"budgets"},{id:"timing-budget",weight:0,group:"budgets"},{id:"resource-summary",weight:0,group:"diagnostics"},{id:"third-party-summary",weight:0,group:"diagnostics"},{id:"largest-contentful-paint-element",weight:0,group:"diagnostics"},{id:"layout-shift-elements",weight:0,group:"diagnostics"},{id:"uses-passive-event-listeners",weight:0,group:"diagnostics"},{id:"no-document-write",weight:0,group:"diagnostics"},{id:"long-tasks",weight:0,group:"diagnostics"},{id:"non-composited-animations",weight:0,group:"diagnostics"},{id:"unsized-images",weight:0,group:"diagnostics"},{id:"network-requests",weight:0},{id:"network-rtt",weight:0},{id:"network-server-latency",weight:0},{id:"main-thread-tasks",weight:0},{id:"diagnostics",weight:0},{id:"metrics",weight:0},{id:"screenshot-thumbnails",weight:0},{id:"final-screenshot",weight:0}]},accessibility:{title:s(a.a11yCategoryTitle),description:s(a.a11yCategoryDescription),
manualDescription:s(a.a11yCategoryManualDescription),auditRefs:[{id:"accesskeys",weight:3,group:"a11y-navigation"},{id:"aria-allowed-attr",weight:10,group:"a11y-aria"},{id:"aria-hidden-body",weight:10,group:"a11y-aria"},{id:"aria-hidden-focus",weight:3,group:"a11y-aria"},{id:"aria-input-field-name",weight:3,group:"a11y-aria"},{id:"aria-required-attr",weight:10,group:"a11y-aria"},{id:"aria-required-children",weight:10,group:"a11y-aria"},{id:"aria-required-parent",weight:10,group:"a11y-aria"},{id:"aria-roles",weight:10,group:"a11y-aria"},{id:"aria-toggle-field-name",weight:3,group:"a11y-aria"},{id:"aria-valid-attr-value",weight:10,group:"a11y-aria"},{id:"aria-valid-attr",weight:10,group:"a11y-aria"},{id:"button-name",weight:10,group:"a11y-names-labels"},{id:"bypass",weight:3,group:"a11y-navigation"},{id:"color-contrast",weight:3,group:"a11y-color-contrast"},{id:"definition-list",weight:3,group:"a11y-tables-lists"},{id:"dlitem",weight:3,group:"a11y-tables-lists"},{id:"document-title",
weight:3,group:"a11y-names-labels"},{id:"duplicate-id-active",weight:3,group:"a11y-navigation"},{id:"duplicate-id-aria",weight:10,group:"a11y-aria"},{id:"form-field-multiple-labels",weight:2,group:"a11y-names-labels"},{id:"frame-title",weight:3,group:"a11y-names-labels"},{id:"heading-order",weight:2,group:"a11y-navigation"},{id:"html-has-lang",weight:3,group:"a11y-language"},{id:"html-lang-valid",weight:3,group:"a11y-language"},{id:"image-alt",weight:10,group:"a11y-names-labels"},{id:"input-image-alt",weight:10,group:"a11y-names-labels"},{id:"label",weight:10,group:"a11y-names-labels"},{id:"layout-table",weight:3,group:"a11y-tables-lists"},{id:"link-name",weight:3,group:"a11y-names-labels"},{id:"list",weight:3,group:"a11y-tables-lists"},{id:"listitem",weight:3,group:"a11y-tables-lists"},{id:"meta-refresh",weight:10,group:"a11y-best-practices"},{id:"meta-viewport",weight:10,group:"a11y-best-practices"},{id:"object-alt",weight:3,group:"a11y-names-labels"},{id:"tabindex",weight:3,
group:"a11y-navigation"},{id:"td-headers-attr",weight:3,group:"a11y-tables-lists"},{id:"th-has-data-cells",weight:3,group:"a11y-tables-lists"},{id:"valid-lang",weight:3,group:"a11y-language"},{id:"video-caption",weight:10,group:"a11y-audio-video"},{id:"video-description",weight:10,group:"a11y-audio-video"},{id:"logical-tab-order",weight:0},{id:"focusable-controls",weight:0},{id:"interactive-element-affordance",weight:0},{id:"managed-focus",weight:0},{id:"focus-traps",weight:0},{id:"custom-controls-labels",weight:0},{id:"custom-controls-roles",weight:0},{id:"visual-order-follows-dom",weight:0},{id:"offscreen-content-hidden",weight:0},{id:"use-landmarks",weight:0}]},"best-practices":{title:s(a.bestPracticesCategoryTitle),auditRefs:[{id:"is-on-https",weight:1,group:"best-practices-trust-safety"},{id:"external-anchors-use-rel-noopener",weight:1,group:"best-practices-trust-safety"},{id:"geolocation-on-start",weight:1,group:"best-practices-trust-safety"},{id:"notification-on-start",weight:1,
group:"best-practices-trust-safety"},{id:"no-vulnerable-libraries",weight:1,group:"best-practices-trust-safety"},{id:"password-inputs-can-be-pasted-into",weight:1,group:"best-practices-ux"},{id:"image-aspect-ratio",weight:1,group:"best-practices-ux"},{id:"image-size-responsive",weight:1,group:"best-practices-ux"},{id:"preload-fonts",weight:1,group:"best-practices-ux"},{id:"doctype",weight:1,group:"best-practices-browser-compat"},{id:"charset",weight:1,group:"best-practices-browser-compat"},{id:"no-unload-listeners",weight:1,group:"best-practices-general"},{id:"appcache-manifest",weight:1,group:"best-practices-general"},{id:"js-libraries",weight:0,group:"best-practices-general"},{id:"deprecations",weight:1,group:"best-practices-general"},{id:"errors-in-console",weight:1,group:"best-practices-general"},{id:"valid-source-maps",weight:0,group:"best-practices-general"}]},seo:{title:s(a.seoCategoryTitle),description:s(a.seoCategoryDescription),
manualDescription:s(a.seoCategoryManualDescription),auditRefs:[{id:"viewport",weight:1,group:"seo-mobile"},{id:"document-title",weight:1,group:"seo-content"},{id:"meta-description",weight:1,group:"seo-content"},{id:"http-status-code",weight:1,group:"seo-crawl"},{id:"link-text",weight:1,group:"seo-content"},{id:"crawlable-anchors",weight:1,group:"seo-crawl"},{id:"is-crawlable",weight:1,group:"seo-crawl"},{id:"robots-txt",weight:1,group:"seo-crawl"},{id:"image-alt",weight:1,group:"seo-content"},{id:"hreflang",weight:1,group:"seo-content"},{id:"canonical",weight:1,group:"seo-content"},{id:"font-size",weight:1,group:"seo-mobile"},{id:"plugins",weight:1,group:"seo-content"},{id:"tap-targets",weight:1,group:"seo-mobile"},{id:"structured-data",weight:0}]},pwa:{title:s(a.pwaCategoryTitle),description:s(a.pwaCategoryDescription),manualDescription:s(a.pwaCategoryManualDescription),auditRefs:[{id:"load-fast-enough-for-pwa",weight:7,group:"pwa-fast-reliable"},{id:"works-offline",weight:5,
group:"pwa-fast-reliable"},{id:"offline-start-url",weight:1,group:"pwa-fast-reliable"},{id:"is-on-https",weight:2,group:"pwa-installable"},{id:"service-worker",weight:1,group:"pwa-installable"},{id:"installable-manifest",weight:2,group:"pwa-installable"},{id:"redirects-http",weight:2,group:"pwa-optimized"},{id:"splash-screen",weight:1,group:"pwa-optimized"},{id:"themed-omnibox",weight:1,group:"pwa-optimized"},{id:"content-width",weight:1,group:"pwa-optimized"},{id:"viewport",weight:2,group:"pwa-optimized"},{id:"without-javascript",weight:1,group:"pwa-optimized"},{id:"apple-touch-icon",weight:1,group:"pwa-optimized"},{id:"maskable-icon",weight:1,group:"pwa-optimized"},{id:"pwa-cross-browser",weight:0},{id:"pwa-page-transitions",weight:0},{id:"pwa-each-page-has-url",weight:0}]}}};t.exports=o,Object.defineProperty(t.exports,"UIStrings",{enumerable:!1,get:()=>a})}).call(this,"/lighthouse-core/config/default-config.js")},{"../lib/i18n/i18n.js":78,"./constants.js":54}],56:[function(e,t,r){
"use strict";const n=e("events").EventEmitter,i=e("lighthouse-logger"),a=e("../../lib/lh-error.js");t.exports=class Connection{constructor(){this._lastCommandId=0,this._callbacks=new Map,this._eventEmitter=new n}connect(){return Promise.reject(new Error("Not implemented"))}disconnect(){return Promise.reject(new Error("Not implemented"))}wsEndpoint(){return Promise.reject(new Error("Not implemented"))}sendCommand(e,t,...r){const n=r.length?r[0]:void 0;i.formatProtocol("method => browser",{method:e,params:n},"verbose");const a=++this._lastCommandId,s=JSON.stringify({id:a,sessionId:t,method:e,params:n});return this.sendRawMessage(s),new Promise(t=>{this._callbacks.set(a,{method:e,resolve:t})})}on(e,t){if("protocolevent"!==e)throw new Error('Only supports "protocolevent" events');if(!this._eventEmitter)throw new Error("Attempted to add event listener after connection disposed.");this._eventEmitter.on(e,t)}sendRawMessage(e){throw new Error("Not implemented")}handleRawMessage(e){
const t=JSON.parse(e);if(!("id"in t))return i.formatProtocol("<= event",{method:t.method,params:t.params},"verbose"),void this.emitProtocolEvent(t);const r=this._callbacks.get(t.id);if(r)this._callbacks.delete(t.id),r.resolve(Promise.resolve().then(e=>{if(t.error)throw i.formatProtocol("method <= browser ERR",{method:r.method},"error"),a.fromProtocolMessage(r.method,t.error);return i.formatProtocol("method <= browser OK",{method:r.method,params:t.result},"verbose"),t.result}));else{const e=t.error&&t.error.message;i.formatProtocol(`disowned method <= browser ${e?"ERR":"OK"}`,{method:"UNKNOWN",params:e||t.result},"verbose")}}emitProtocolEvent(e){if(!this._eventEmitter)throw new Error("Attempted to emit event after connection disposed.");this._eventEmitter.emit("protocolevent",e)}dispose(){this._eventEmitter&&(this._eventEmitter.removeAllListeners(),this._eventEmitter=null)}}},{"../../lib/lh-error.js":86,events:124,"lighthouse-logger":141}],57:[function(e,t,r){"use strict"
;const n=e("./connection.js");t.exports=class RawConnection extends n{constructor(e){super(),this._port=e,this._port.on("message",this.handleRawMessage.bind(this)),this._port.on("close",this.dispose.bind(this))}connect(){return Promise.resolve()}disconnect(){return this._port.close(),Promise.resolve()}sendRawMessage(e){this._port.send(e)}}},{"./connection.js":56}],58:[function(e,t,r){"use strict";t.exports=class DevtoolsLog{constructor(e){this._filter=e,this._messages=[],this._isRecording=!1}get messages(){return this._messages}reset(){this._messages=[]}beginRecording(){this._isRecording=!0}endRecording(){this._isRecording=!1}record(e){!this._isRecording||this._filter&&!this._filter.test(e.method)||this._messages.push(e)}}},{}],59:[function(e,t,r){(function(r,n){"use strict"
;const i=e("./fetcher.js"),a=e("../lib/network-recorder.js"),s=e("../lib/emulation.js"),o=e("../lib/lh-element.js"),l=e("../lib/lh-error.js"),c=e("../lib/network-request.js"),u=e("events").EventEmitter,d=e("../lib/i18n/i18n.js"),m=e("../lib/url-shim.js"),p=e("../config/constants.js"),h=e("lighthouse-logger"),g=e("./devtools-log.js"),f=e("../lib/page-functions.js"),b=(e("./connections/connection.js"),{warningData:"{locationCount, plural,\n    =1 {There may be stored data affecting loading performance in this location: {locations}. Audit this page in an incognito window to prevent those resources from affecting your scores.}\n    other {There may be stored data affecting loading performance in these locations: {locations}. Audit this page in an incognito window to prevent those resources from affecting your scores.}\n  }"}),y=d.createMessageInstanceIdFn(n,b),v=0,w=0,k=5e3,x=0,T=3e4;class Driver{constructor(e){this._traceCategories=Driver.traceCategories,this._eventEmitter=new u,
this._connection=e,this._devtoolsLog=new g(/^(Page|Network)\./),this.online=!0,this._domainEnabledCounts=new Map,this._isolatedExecutionContextId=void 0,this._networkStatusMonitor=null,this._monitoredUrl=null,this._monitoredUrlNavigations=[],this.on("Target.attachedToTarget",e=>{this._handleTargetAttached(e).catch(this._handleEventError)}),this.on("Runtime.executionContextDestroyed",e=>{e.executionContextId===this._isolatedExecutionContextId&&this._clearIsolatedContextId()}),this.on("Page.frameNavigated",()=>this._clearIsolatedContextId()),this.on("Page.frameNavigated",e=>this._monitoredUrlNavigations.push(e.frame)),e.on("protocolevent",this._handleProtocolEvent.bind(this)),this._nextProtocolTimeout=T,this.fetcher=new i(this)}static get traceCategories(){
return["-*","disabled-by-default-lighthouse","loading","v8","v8.execute","blink.user_timing","blink.console","devtools.timeline","disabled-by-default-devtools.timeline","disabled-by-default-devtools.screenshot","disabled-by-default-devtools.timeline.stack"]}async getBrowserVersion(){const e={msg:"Getting browser version",id:"lh:gather:getVersion"};h.time(e,"verbose");const t=await this.sendCommand("Browser.getVersion"),r=t.product.match(/\/(\d+)/),n=r?parseInt(r[1]):0;return h.timeEnd(e),Object.assign(t,{milestone:n})}async getBenchmarkIndex(){const e={msg:"Benchmarking machine",id:"lh:gather:getBenchmarkIndex"};h.time(e);const t=await this.evaluateAsync(`(${f.computeBenchmarkIndexString})()`);return h.timeEnd(e),t}async connect(){const e={msg:"Connecting to browser",id:"lh:init:connect"};h.time(e),await this._connection.connect(),h.timeEnd(e)}disconnect(){return this._connection.disconnect()}wsEndpoint(){return this._connection.wsEndpoint()}on(e,t){
if(null===this._eventEmitter)throw new Error("connect() must be called before attempting to listen to events.");h.formatProtocol("listen for event =>",{method:e},"verbose"),this._eventEmitter.on(e,t)}once(e,t){if(null===this._eventEmitter)throw new Error("connect() must be called before attempting to listen to events.");h.formatProtocol("listen once for event =>",{method:e},"verbose"),this._eventEmitter.once(e,t)}off(e,t){if(null===this._eventEmitter)throw new Error("connect() must be called before attempting to remove an event listener.");this._eventEmitter.removeListener(e,t)}_shouldToggleDomain(e,t,r){const n=e+(t||""),i=(this._domainEnabledCounts.get(n)||0)+(r?1:-1);return this._domainEnabledCounts.set(n,Math.max(0,i)),r&&1===i||!r&&0===i?(h.verbose("Driver",`${e}.${r?"enable":"disable"}`),!0):(i<0&&h.error("Driver",`Attempted to disable domain '${e}' when already disabled.`),!1)}setNextProtocolTimeout(e){this._nextProtocolTimeout=e}_handleProtocolEvent(e){
this._devtoolsLog.record(e),this._networkStatusMonitor&&this._networkStatusMonitor.dispatch(e),this._eventEmitter.emit(e.method,e.params)}_handleEventError(e){h.error("Driver","Unhandled event error",e.message)}async _handleTargetAttached(e){"iframe"===e.targetInfo.type?(await this.sendCommandToSession("Network.enable",e.sessionId),await this.sendCommandToSession("Target.setAutoAttach",e.sessionId,{autoAttach:!0,flatten:!0,waitForDebuggerOnStart:!0}),await this.sendCommandToSession("Runtime.runIfWaitingForDebugger",e.sessionId)):await this.sendCommandToSession("Runtime.runIfWaitingForDebugger",e.sessionId)}sendCommandToSession(e,t,...r){const n=this._nextProtocolTimeout;return this._nextProtocolTimeout=T,new Promise(async(i,a)=>{const s=setTimeout(()=>{const t=new l(l.errors.PROTOCOL_TIMEOUT,{protocolMethod:e});a(t)},n);try{i(await this._innerSendCommand(e,t,...r))}catch(e){a(e)}finally{clearTimeout(s)}})}sendCommand(e,...t){return this.sendCommandToSession(e,void 0,...t)}
_innerSendCommand(e,t,...r){const n=/^(\w+)\.(enable|disable)$/.exec(e);if(n){const e="enable"===n[2];if(!this._shouldToggleDomain(n[1],t,e))return Promise.resolve()}return this._connection.sendCommand(e,t,...r)}isDomainEnabled(e){return!!this._domainEnabledCounts.get(e)}evaluateScriptOnNewDocument(e){return this.sendCommand("Page.addScriptToEvaluateOnLoad",{scriptSource:e})}async evaluateAsync(e,t={}){const r=t.useIsolation?await this._getOrCreateIsolatedContextId():void 0;try{return await this._evaluateInContext(e,r)}catch(t){if(r&&t.message.includes("Cannot find context")){this._clearIsolatedContextId();const t=await this._getOrCreateIsolatedContextId();return this._evaluateInContext(e,t)}throw t}}async _evaluateInContext(e,t){const r=this._nextProtocolTimeout===T?6e4:this._nextProtocolTimeout,n={
expression:`(function wrapInNativePromise() {\n        const __nativePromise = window.__nativePromise || Promise;\n        const URL = window.__nativeURL || window.URL;\n        return new __nativePromise(function (resolve) {\n          return __nativePromise.resolve()\n            .then(_ => ${e})\n            .catch(${f.wrapRuntimeEvalErrorInBrowserString})\n            .then(resolve);\n        });\n      }())`,includeCommandLineAPI:!0,awaitPromise:!0,returnByValue:!0,timeout:r,contextId:t};this.setNextProtocolTimeout(r);const i=await this.sendCommand("Runtime.evaluate",n);if(i.exceptionDetails){const e=i.exceptionDetails.exception?i.exceptionDetails.exception.description:i.exceptionDetails.text;return Promise.reject(new Error(`Evaluation exception: ${e}`))}if(void 0===i.result)return Promise.reject(new Error('Runtime.evaluate response did not contain a "result" object'));const a=i.result.value;return a&&a.__failedInBrowser?Promise.reject(Object.assign(new Error,a)):a}
async getAppManifest(){let e;this.setNextProtocolTimeout(1e4);try{e=await this.sendCommand("Page.getAppManifest")}catch(e){if("PROTOCOL_TIMEOUT"===e.code)return h.error("Driver","Failed fetching manifest",e),null;throw e}let t=e.data;if(!t)return null;return 65279===t.charCodeAt(0)&&(t=r.from(t).slice(3).toString()),{...e,data:t}}getServiceWorkerVersions(){return new Promise((e,t)=>{const r=n=>{const i=n.versions.filter(e=>"redundant"!==e.status),a=i.find(e=>"activated"===e.status);i.length&&!a||(this.off("ServiceWorker.workerVersionUpdated",r),this.sendCommand("ServiceWorker.disable").then(t=>e(n),t))};this.on("ServiceWorker.workerVersionUpdated",r),this.sendCommand("ServiceWorker.enable").catch(t)})}getServiceWorkerRegistrations(){return new Promise((e,t)=>{this.once("ServiceWorker.workerRegistrationUpdated",r=>{this.sendCommand("ServiceWorker.disable").then(t=>e(r),t)}),this.sendCommand("ServiceWorker.enable").catch(t)})}assertNoSameOriginServiceWorkerClients(e){let t,r
;return this.getServiceWorkerRegistrations().then(e=>{t=e.registrations}).then(e=>this.getServiceWorkerVersions()).then(e=>{r=e.versions}).then(n=>{const i=new m(e).origin;t.filter(e=>{const t=new m(e.scopeURL).origin;return i===t}).forEach(e=>{r.forEach(t=>{if(t.registrationId===e.registrationId&&t.controlledClients&&t.controlledClients.length>0)throw new Error("You probably have multiple tabs open to the same origin.")})})})}_waitForNothing(){return{promise:Promise.resolve(),cancel(){}}}_waitForFrameNavigated(){return new Promise(e=>{this.once("Page.frameNavigated",e)})}_waitForFcp(e,t){let r=()=>{throw new Error("_waitForFcp.cancel() called before it was defined")};return{promise:new Promise((n,i)=>{const a=setTimeout(()=>{i(new l(l.errors.NO_FCP))},t);let s;const o=t=>{"firstContentfulPaint"===t.name&&(s=setTimeout(()=>{n(),r()},e))};this.on("Page.lifecycleEvent",o);let c=!1;r=()=>{c||(c=!0,this.off("Page.lifecycleEvent",o),a&&clearTimeout(a),s&&clearTimeout(s),
i(new Error("Wait for FCP canceled")))}}),cancel:r}}_waitForNetworkIdle(e){let t,r=!1,n=()=>{throw new Error("_waitForNetworkIdle.cancel() called before it was defined")};if(!this._networkStatusMonitor)throw new Error("Driver._waitForNetworkIdle called with no networkStatusMonitor");const i=this._networkStatusMonitor;return{promise:new Promise((a,s)=>{const o=()=>{i.once("network-2-busy",l),t=setTimeout(e=>{n(),a()},e)},l=()=>{i.once("network-2-idle",o),t&&clearTimeout(t)},c=()=>{r=!0,i.is2Idle()?o():l()},u=()=>{if(!r)return void h.verbose("Driver","Waiting on DomContentLoaded");const e=i.getInflightRecords();if(e.length<20)for(const t of e)h.verbose("Driver",`Waiting on ${t.url.slice(0,120)} to finish`)};i.on("requeststarted",u),i.on("requestloaded",u),i.on("network-2-busy",u),this.once("Page.domContentEventFired",c);let d=!1;n=()=>{d||(d=!0,t&&clearTimeout(t),this.off("Page.domContentEventFired",c),i.removeListener("network-2-busy",l),i.removeListener("network-2-idle",o),
i.removeListener("requeststarted",u),i.removeListener("requestloaded",u),i.removeListener("network-2-busy",u))}}),cancel:n}}_waitForCPUIdle(e){if(!e)return{promise:Promise.resolve(),cancel:()=>void 0};let t,r=!1;const n=`(${f.checkTimeSinceLastLongTaskString})()`;let i=()=>{throw new Error("_waitForCPUIdle.cancel() called before it was defined")};return{promise:new Promise((a,s)=>{(async function checkForQuiet(i,a){if(r)return;const s=await i.evaluateAsync(n);r||"number"!=typeof s||(s>=e?(h.verbose("Driver",`CPU has been idle for ${s} ms`),a()):(h.verbose("Driver",`CPU has been idle for ${s} ms`),t=setTimeout(()=>checkForQuiet(i,a),e-s)))})(this,a).catch(s),i=()=>{r||(r=!0,t&&clearTimeout(t),s(new Error("Wait for CPU idle canceled")))}}),cancel:i}}_waitForLoadEvent(e){let t=()=>{throw new Error("_waitForLoadEvent.cancel() called before it was defined")};return{promise:new Promise((r,n)=>{let i;const a=function(){i=setTimeout(r,e)};this.once("Page.loadEventFired",a);let s=!1;t=()=>{
s||(s=!0,this.off("Page.loadEventFired",a),i&&clearTimeout(i))}}),cancel:t}}async isPageHung(){try{return this.setNextProtocolTimeout(1e3),await this.sendCommand("Runtime.evaluate",{expression:'"ping"',returnByValue:!0,timeout:1e3}),!1}catch(e){return!0}}async _waitForFullyLoaded(e,t,r,n,i,a){let s;const o=a?this._waitForFcp(e,a):this._waitForNothing(),c=this._waitForLoadEvent(t),u=this._waitForNetworkIdle(r);let d=this._waitForNothing();const m=Promise.all([o.promise,c.promise,u.promise]).then(()=>(d=this._waitForCPUIdle(n)).promise).then(()=>{return async function(){return h.verbose("Driver","loadEventFired and network considered idle"),{timedOut:!1}}}).catch(e=>(function(){throw e})),p=new Promise((e,t)=>{s=setTimeout(e,i)}).then(e=>async()=>{if(h.warn("Driver","Timed out waiting for page load. Checking if page is hung..."),await this.isPageHung())throw h.warn("Driver","Page appears to be hung, killing JavaScript..."),await this.sendCommand("Emulation.setScriptExecutionDisabled",{
value:!0}),await this.sendCommand("Runtime.terminateExecution"),new l(l.errors.PAGE_HUNG);return{timedOut:!0}}),g=await Promise.race([m,p]);return s&&clearTimeout(s),o.cancel(),c.cancel(),u.cancel(),d.cancel(),g()}_beginNetworkStatusMonitoring(e){return this._networkStatusMonitor=new a,this._monitoredUrl=e,this._monitoredUrlNavigations=[],this.sendCommand("Network.enable")}async _endNetworkStatusMonitoring(){const e=this._monitoredUrl,t=this._monitoredUrlNavigations,r=(await this.sendCommand("Page.getResourceTree")).frameTree.frame.id,n=t.filter(e=>e.id===r),i=n[n.length-1];this._networkStatusMonitor=null,this._monitoredUrl=null,this._monitoredUrlNavigations=[];const a=i&&i.url||e;if(i||h.warn("Driver","No detected navigations"),!a)throw new Error("Unable to determine finalUrl");return a}async _getOrCreateIsolatedContextId(){if("number"==typeof this._isolatedExecutionContextId)return this._isolatedExecutionContextId
;const e=(await this.sendCommand("Page.getResourceTree")).frameTree.frame.id,t=await this.sendCommand("Page.createIsolatedWorld",{frameId:e,worldName:"lighthouse_isolated_context"});return this._isolatedExecutionContextId=t.executionContextId,t.executionContextId}_clearIsolatedContextId(){this._isolatedExecutionContextId=void 0}async gotoURL(e,t={}){const r=t.waitForFcp||!1,n=t.waitForNavigated||!1,i=t.waitForLoad||!1,a=t.passContext||{},s=a.disableJavaScript||!1;if(n&&(r||i))throw new Error("Cannot use both waitForNavigated and another event, pick just one");await this._beginNetworkStatusMonitoring(e),await this._clearIsolatedContextId(),await this.sendCommand("Target.setAutoAttach",{flatten:!0,autoAttach:!0,waitForDebuggerOnStart:!0}),await this.sendCommand("Page.enable"),await this.sendCommand("Page.setLifecycleEventsEnabled",{enabled:!0}),await this.sendCommand("Emulation.setScriptExecutionDisabled",{value:s});const o=this._innerSendCommand("Page.navigate",void 0,{url:e});let l=!1
;if(n)await this._waitForFrameNavigated();else if(i){const e=a.passConfig||{};let{pauseAfterFcpMs:t,pauseAfterLoadMs:n,networkQuietThresholdMs:i,cpuQuietThresholdMs:s}=e,o=a.settings&&a.settings.maxWaitForLoad,c=a.settings&&a.settings.maxWaitForFcp;"number"!=typeof t&&(t=v),"number"!=typeof n&&(n=w),"number"!=typeof i&&(i=k),"number"!=typeof s&&(s=x),"number"!=typeof o&&(o=p.defaultSettings.maxWaitForLoad),"number"!=typeof c&&(c=p.defaultSettings.maxWaitForFcp),r||(c=void 0),l=(await this._waitForFullyLoaded(t,n,i,s,o,c)).timedOut}return await o,{finalUrl:await this._endNetworkStatusMonitoring(),timedOut:l}}async getObjectProperty(e,t){const r=(await this.sendCommand("Runtime.getProperties",{objectId:e,accessorPropertiesOnly:!0,generatePreview:!1,ownProperties:!1})).result.find(e=>e.name===t);return r&&r.value?r.value.value:null}async getRequestContent(e,t=1e3){return e=c.getRequestIdForBackend(e),this.setNextProtocolTimeout(t),(await this.sendCommand("Network.getResponseBody",{
requestId:e})).body}async querySelector(e){const t=(await this.sendCommand("DOM.getDocument")).root.nodeId,r=await this.sendCommand("DOM.querySelector",{nodeId:t,selector:e});return 0===r.nodeId?null:new o(r,this)}async resolveNodeIdToObjectId(e){try{return(await this.sendCommand("DOM.resolveNode",{backendNodeId:e})).object.objectId}catch(e){if(/No node.*found/.test(e.message)||/Node.*does not belong to the document/.test(e.message))return;throw e}}async resolveDevtoolsNodePathToObjectId(e){try{const{nodeId:t}=await this.sendCommand("DOM.pushNodeByPathToFrontend",{path:e}),{object:{objectId:r}}=await this.sendCommand("DOM.resolveNode",{nodeId:t});return r}catch(e){if(/No node.*found/.test(e.message))return;throw e}}scrollTo(e){const t=`window.scrollTo(${e.x}, ${e.y})`;return this.evaluateAsync(t,{useIsolation:!0})}getScrollPosition(){return this.evaluateAsync("({x: window.scrollX, y: window.scrollY})",{useIsolation:!0})}async beginTrace(e){
const t=e&&e.additionalTraceCategories&&e.additionalTraceCategories.split(",")||[],r=this._traceCategories.concat(t);if((await this.getBrowserVersion()).milestone<71){const e=r.indexOf("disabled-by-default-lighthouse");r[e]="toplevel"}const n=Array.from(new Set(r));if(this.isDomainEnabled("CSS"))throw new Error("CSS domain enabled when starting trace");if(this.isDomainEnabled("DOM"))throw new Error("DOM domain enabled when starting trace");return this.sendCommand("Page.enable").then(e=>this.sendCommand("Tracing.start",{categories:n.join(","),options:"sampling-frequency=10000"}))}endTrace(){const e=[],t=function(t){e.push(...t.value)};return this.on("Tracing.dataCollected",t),new Promise((r,n)=>{this.once("Tracing.tracingComplete",n=>{this.off("Tracing.dataCollected",t),r({traceEvents:e})}),this.sendCommand("Tracing.end").catch(n)})}beginDevtoolsLog(){this._devtoolsLog.reset(),this._devtoolsLog.beginRecording()}endDevtoolsLog(){return this._devtoolsLog.endRecording(),
this._devtoolsLog.messages}enableRuntimeEvents(){return this.sendCommand("Runtime.enable")}async enableAsyncStacks(){await this.sendCommand("Debugger.enable"),await this.sendCommand("Debugger.setSkipAllPauses",{skip:!0}),await this.sendCommand("Debugger.setAsyncCallStackDepth",{maxDepth:8})}async beginEmulation(e){await s.emulate(this,e),await this.setThrottling(e,{useThrottling:!0})}async setThrottling(e,t){if("devtools"!==e.throttlingMethod)return s.clearAllNetworkEmulation(this);const r=t.useThrottling?s.enableCPUThrottling(this,e.throttling):s.disableCPUThrottling(this),n=t.useThrottling?s.enableNetworkThrottling(this,e.throttling):s.clearAllNetworkEmulation(this);await Promise.all([r,n])}async goOffline(){await this.sendCommand("Network.enable"),await s.goOffline(this),this.online=!1}async goOnline(e){await this.setThrottling(e.settings,e.passConfig),this.online=!0}async cleanBrowserCaches(){const e={msg:"Cleaning browser cache",id:"lh:driver:cleanBrowserCaches"};h.time(e),
await this.sendCommand("Network.clearBrowserCache"),await this.sendCommand("Network.setCacheDisabled",{cacheDisabled:!0}),await this.sendCommand("Network.setCacheDisabled",{cacheDisabled:!1}),h.timeEnd(e)}async setExtraHTTPHeaders(e){if(e)return this.sendCommand("Network.setExtraHTTPHeaders",{headers:e})}async clearDataForOrigin(e){const t=new m(e).origin,r=["appcache","file_systems","shader_cache","service_workers","cache_storage"].join(",");this.setNextProtocolTimeout(5e3);try{await this.sendCommand("Storage.clearDataForOrigin",{origin:t,storageTypes:r})}catch(e){if("PROTOCOL_TIMEOUT"!==e.code)throw e;h.warn("Driver","clearDataForOrigin timed out")}}async getImportantStorageWarning(e){const t=await this.sendCommand("Storage.getUsageAndQuota",{origin:e}),r={local_storage:"Local Storage",indexeddb:"IndexedDB",websql:"Web SQL"},n=t.usageBreakdown.filter(e=>e.usage).map(e=>r[e.storageType]||"").filter(Boolean);if(n.length)return y(b.warningData,{locations:n.join(", "),
locationCount:n.length})}async cacheNatives(){await this.evaluateScriptOnNewDocument("\n        window.__nativePromise = Promise;\n        window.__nativeError = Error;\n        window.__nativeURL = URL;\n        window.__ElementMatches = Element.prototype.matches;\n        window.__perfNow = performance.now.bind(performance);\n    ")}async registerPerformanceObserver(){const e=`(${f.registerPerformanceObserverInPageString})()`;await this.evaluateScriptOnNewDocument(e)}async registerRequestIdleCallbackWrap(e){if("simulate"===e.throttlingMethod){const t=`(${f.wrapRequestIdleCallbackString})\n        (${e.throttling.cpuSlowdownMultiplier})`;await this.evaluateScriptOnNewDocument(t)}}blockUrlPatterns(e){return this.sendCommand("Network.setBlockedURLs",{urls:e}).catch(e=>{if(!/wasn't found/.test(e.message))throw e})}async dismissJavaScriptDialogs(){this.on("Page.javascriptDialogOpening",e=>{h.warn("Driver",`${e.type} dialog opened by the page automatically suppressed.`),
this.sendCommand("Page.handleJavaScriptDialog",{accept:!0,promptText:"Lighthouse prompt response"}).catch(e=>h.warn("Driver",e))}),await this.sendCommand("Page.enable")}}t.exports=Driver,t.exports.UIStrings=b}).call(this,e("buffer").Buffer,"/lighthouse-core/gather/driver.js")},{"../config/constants.js":54,"../lib/emulation.js":77,"../lib/i18n/i18n.js":78,"../lib/lh-element.js":84,"../lib/lh-error.js":86,"../lib/network-recorder.js":89,"../lib/network-request.js":90,"../lib/page-functions.js":91,"../lib/url-shim.js":"url","./connections/connection.js":56,"./devtools-log.js":58,"./fetcher.js":60,buffer:120,events:124,"lighthouse-logger":141}],60:[function(e,t,r){(function(r){"use strict";const n=e("lighthouse-logger");t.exports=class Fetcher{constructor(e){this.driver=e,this._onRequestPausedHandlers=new Map,this._onRequestPaused=this._onRequestPaused.bind(this),this._enabled=!1}async enableRequestInterception(){this._enabled||(this._enabled=!0,
await this.driver.sendCommand("Fetch.enable",{patterns:[{requestStage:"Request"},{requestStage:"Response"}]}),await this.driver.on("Fetch.requestPaused",this._onRequestPaused))}async disableRequestInterception(){this._enabled&&(this._enabled=!1,await this.driver.off("Fetch.requestPaused",this._onRequestPaused),await this.driver.sendCommand("Fetch.disable"),this._onRequestPausedHandlers.clear())}async _setOnRequestPausedHandler(e,t){this._onRequestPausedHandlers.set(e,t)}_onRequestPaused(e){const t=this._onRequestPausedHandlers.get(e.request.url);t?t(e):this.driver.sendCommand("Fetch.continueRequest",{requestId:e.requestId}).catch(e=>{n.error("Fetcher",`Failed to continueRequest: ${e.message}`)})}async fetchResource(e,{timeout:t=500}){if(!this._enabled)throw new Error("Must call `enableRequestInterception` before using fetchResource");const n=new Promise((t,n)=>{const i=async e=>{const{requestId:i,responseStatusCode:a}=e;if(!a){
const t=Object.entries(e.request.headers).filter(([e])=>"Cookie"!==e).map(([e,t])=>({name:e,value:t}));return void await this.driver.sendCommand("Fetch.continueRequest",{requestId:i,headers:t})}if(!(a>=200&&a<300))return void n(new Error(`Invalid response status code: ${a}`));const s=await this.driver.sendCommand("Fetch.getResponseBody",{requestId:i});s.base64Encoded?t(r.from(s.body,"base64").toString()):t(s.body),await this.driver.sendCommand("Fetch.failRequest",{requestId:i,errorReason:"Aborted"})};this._setOnRequestPausedHandler(e,e=>i(e).catch(n))});let i;const a=new Promise((e,r)=>{i=setTimeout(()=>r(new Error("Timed out fetching resource.")),t)}),s=Promise.race([a,n]).finally(()=>clearTimeout(i)),o=this.driver.evaluateAsync(`${function injectIframe(e){const t=document.createElement("iframe");t.style.display="none",t.style.visibility="hidden",t.style.position="absolute",t.style.top="-1000px",t.style.left="-1000px",t.style.width="1px",t.style.height="1px",t.src=e,
t.onload=t.onerror=()=>{t.remove(),delete t.onload,delete t.onerror},document.body.appendChild(t)}}(${JSON.stringify(e)})`,{useIsolation:!0}),[l]=await Promise.all([s,o]);return l}}}).call(this,e("buffer").Buffer)},{buffer:120,"lighthouse-logger":141}],61:[function(e,t,r){(function(r){"use strict";const n=e("lighthouse-logger"),i=e("../lib/manifest-parser.js"),a=e("../lib/stack-collector.js"),s=e("../lib/lh-error.js"),o=e("../lib/dependency-graph/simulator/network-analyzer.js"),l=e("../lib/network-recorder.js"),c=e("../config/constants.js"),u=e("../lib/i18n/i18n.js"),d=e("../lib/url-shim.js"),m={warningRedirected:"The page may not be loading as expected because your test URL ({requested}) was redirected to {final}. Try testing the second URL directly.",warningTimeout:"The page loaded too slowly to finish within the time limit. Results may be incomplete."},p=u.createMessageInstanceIdFn(r,m);class GatherRunner{static async loadBlank(e,t=c.defaultPassConfig.blankPage){const r={
msg:"Resetting state with about:blank",id:"lh:gather:loadBlank"};n.time(r),await e.gotoURL(t,{waitForNavigated:!0}),n.timeEnd(r)}static async loadPage(e,t){const r={msg:"Loading page & waiting for onload",id:`lh:gather:loadPage-${t.passConfig.passName}`};n.time(r);try{const{finalUrl:i,timedOut:a}=await e.gotoURL(t.url,{waitForFcp:t.passConfig.recordTrace,waitForLoad:!0,passContext:t});t.url=i,a&&t.LighthouseRunWarnings.push(p(m.warningTimeout))}catch(e){if("NO_FCP"===e.code||"PAGE_HUNG"===e.code)return{navigationError:e};throw e}finally{n.timeEnd(r)}return{}}static async setupDriver(e,t,r){const i={msg:"Initializing…",id:"lh:gather:setupDriver"};n.time(i);const a=!t.settings.disableStorageReset;if(await e.assertNoSameOriginServiceWorkerClients(t.requestedUrl),await e.beginEmulation(t.settings),await e.enableRuntimeEvents(),await e.enableAsyncStacks(),await e.cacheNatives(),await e.registerPerformanceObserver(),await e.dismissJavaScriptDialogs(),
await e.registerRequestIdleCallbackWrap(t.settings),a){const n=await e.getImportantStorageWarning(t.requestedUrl);n&&r.push(n),await e.clearDataForOrigin(t.requestedUrl)}n.timeEnd(i)}static async disposeDriver(e,t){const r={msg:"Disconnecting from browser...",id:"lh:gather:disconnect"};n.time(r);try{!t.settings.disableStorageReset&&await e.clearDataForOrigin(t.requestedUrl),await e.fetcher.disableRequestInterception(),await e.disconnect()}catch(e){/close\/.*status: (500|404)$/.test(e.message)||n.error("GatherRunner disconnect",e.message)}n.timeEnd(r)}static getNetworkError(e){if(!e)return new s(s.errors.NO_DOCUMENT_REQUEST);if(e.failed){const t=e.localizedFailDescription;return"net::ERR_NAME_NOT_RESOLVED"===t||"net::ERR_NAME_RESOLUTION_FAILED"===t||t.startsWith("net::ERR_DNS_")?new s(s.errors.DNS_FAILURE):new s(s.errors.FAILED_DOCUMENT_REQUEST,{errorDetails:t})}return e.hasErrorStatusCode()?new s(s.errors.ERRORED_DOCUMENT_REQUEST,{statusCode:`${e.statusCode}`}):void 0}
static getInterstitialError(e,t){if(!e)return;return t.find(e=>e.documentURL.startsWith("chrome-error://"))&&e.failed?e.localizedFailDescription.startsWith("net::ERR_CERT")?new s(s.errors.INSECURE_DOCUMENT_REQUEST,{securityMessages:e.localizedFailDescription}):new s(s.errors.CHROME_INTERSTITIAL_ERROR):void 0}static getNonHtmlError(e){if(e)return"text/html"!==e.mimeType?new s(s.errors.NOT_HTML,{mimeType:e.mimeType}):void 0}static getPageLoadError(e,t,r){const{networkRecords:n}=t;let i;try{i=o.findMainDocument(n,e.url)}catch(e){}const a=GatherRunner.getNetworkError(i),s=GatherRunner.getInterstitialError(i,n),l=GatherRunner.getNonHtmlError(i);if("ignore"!==e.passConfig.loadFailureMode)return s||(a||(l||r))}static async setupPassNetwork(e){const t={msg:"Setting up network for the pass trace",id:"lh:gather:setupPassNetwork"};n.time(t);const r=e.passConfig;await e.driver.setThrottling(e.settings,r);const i=(e.passConfig.blockedUrlPatterns||[]).concat(e.settings.blockedUrlPatterns||[])
;await e.driver.blockUrlPatterns(i),await e.driver.setExtraHTTPHeaders(e.settings.extraHeaders),n.timeEnd(t)}static async beginRecording(e){const t={msg:"Beginning devtoolsLog and trace",id:"lh:gather:beginRecording"};n.time(t);const{driver:r,passConfig:i,settings:a}=e;await r.beginDevtoolsLog(),i.recordTrace&&await r.beginTrace(a),n.timeEnd(t)}static async endRecording(e){const{driver:t,passConfig:r}=e;let i;if(r.recordTrace){const e={msg:"Gathering trace",id:"lh:gather:getTrace"};n.time(e),i=await t.endTrace(),n.timeEnd(e)}const a={msg:"Gathering devtoolsLog & network records",id:"lh:gather:getDevtoolsLog"};n.time(a);const s=t.endDevtoolsLog(),o=l.recordsFromLogs(s);return n.timeEnd(a),{networkRecords:o,devtoolsLog:s,trace:i}}static async beforePass(e,t){const r={msg:"Running beforePass methods",id:"lh:gather:beforePass"};n.time(r,"verbose");for(const r of e.passConfig.gatherers){const i=r.instance;e.options=r.options||{};const a={msg:`Gathering setup: ${i.name}`,
id:`lh:gather:beforePass:${i.name}`};n.time(a,"verbose");const s=Promise.resolve().then(t=>i.beforePass(e));t[i.name]=[s],await s.catch(()=>{}),n.timeEnd(a)}n.timeEnd(r)}static async pass(e,t){const r=e.passConfig.gatherers,i={msg:"Running pass methods",id:"lh:gather:pass"};n.time(i,"verbose");for(const i of r){const r=i.instance;e.options=i.options||{};const a={msg:`Gathering in-page: ${r.name}`,id:`lh:gather:pass:${r.name}`};n.time(a);const s=Promise.resolve().then(t=>r.pass(e)),o=t[r.name]||[];o.push(s),t[r.name]=o,await s.catch(()=>{})}n.timeEnd(i)}static async afterPass(e,t,r){const i=e.driver,a=e.passConfig.gatherers,s={msg:"Running afterPass methods",id:"lh:gather:afterPass"};n.time(s,"verbose");const o=await i.getScrollPosition();for(const s of a){const a=s.instance,l={msg:`Gathering: ${a.name}`,id:`lh:gather:afterPass:${a.name}`};n.time(l),e.options=s.options||{};const c=Promise.resolve().then(r=>a.afterPass(e,t)),u=r[a.name]||[];u.push(c),r[a.name]=u,await c.catch(()=>{}),
await i.scrollTo(o),n.timeEnd(l)}n.timeEnd(s)}static async collectArtifacts(e){const t={},r=Object.entries(e);for(const[e,n]of r){try{const r=(await Promise.all(n)).filter(e=>void 0!==e),i=r[r.length-1];t[e]=i}catch(r){t[e]=r}if(void 0===t[e])throw new Error(`${e} failed to provide an artifact.`)}return{artifacts:t}}static async initializeBaseArtifacts(e){const t=(await e.driver.getBrowserVersion()).userAgent,{emulatedFormFactor:r}=e.settings,n=t.includes("Android")||t.includes("Mobile")?"mobile":"desktop",i="mobile"===r||"desktop"!==r&&"mobile"===n;return{fetchTime:(new Date).toJSON(),LighthouseRunWarnings:[],TestedAsMobileDevice:i,HostFormFactor:n,HostUserAgent:t,NetworkUserAgent:"",BenchmarkIndex:0,WebAppManifest:null,InstallabilityErrors:{errors:[]},Stacks:[],traces:{},devtoolsLogs:{},settings:e.settings,URL:{requestedUrl:e.requestedUrl,finalUrl:e.requestedUrl},Timing:[],PageLoadError:null}}static async getInstallabilityErrors(e){
const t=await e.driver.sendCommand("Page.getInstallabilityErrors");let r=t.installabilityErrors;if(!r){r=(t.errors||[]).map(e=>{const t={"Could not download a required icon from the manifest":"cannot-download-icon","Downloaded icon was empty or corrupted":"no-icon-available"};for(const[r,n]of Object.entries(t))if(e.includes(r))return{errorId:n,errorArguments:[]};return{errorId:"",errorArguments:[]}}).filter(e=>e.errorId)}return{errors:r}}static async populateBaseArtifacts(e){const t=e.baseArtifacts;t.URL.finalUrl=e.url,d.equalWithExcludedFragments(t.URL.requestedUrl,t.URL.finalUrl)||t.LighthouseRunWarnings.push(p(m.warningRedirected,{requested:t.URL.requestedUrl,final:t.URL.finalUrl})),t.WebAppManifest=await GatherRunner.getWebAppManifest(e),t.WebAppManifest&&(t.InstallabilityErrors=await GatherRunner.getInstallabilityErrors(e)),t.Stacks=await a(e);const r=t.devtoolsLogs[e.passConfig.passName].find(e=>"Network.requestWillBeSent"===e.method&&!!e.params.request.headers["User-Agent"])
;r&&(t.NetworkUserAgent=r.params.request.headers["User-Agent"])}static finalizeBaseArtifacts(e){e.LighthouseRunWarnings=Array.from(new Set(e.LighthouseRunWarnings)),e.Timing=n.getTimeEntries()}static async getWebAppManifest(e){const t=await e.driver.getAppManifest();return t?i(t.data,t.url,e.url):null}static async run(e,t){const r=t.driver,n={};try{await r.connect(),await GatherRunner.loadBlank(r);const i=await GatherRunner.initializeBaseArtifacts(t);i.BenchmarkIndex=await t.driver.getBenchmarkIndex(),await GatherRunner.setupDriver(r,t,i.LighthouseRunWarnings);let a=!0;for(const s of e){const e={driver:r,url:t.requestedUrl,settings:t.settings,passConfig:s,baseArtifacts:i,LighthouseRunWarnings:i.LighthouseRunWarnings},o=await GatherRunner.runPass(e);if(Object.assign(n,o.artifacts),o.pageLoadError&&"fatal"===s.loadFailureMode){i.PageLoadError=o.pageLoadError;break}a&&(await GatherRunner.populateBaseArtifacts(e),a=!1),await r.fetcher.disableRequestInterception()}
return await GatherRunner.disposeDriver(r,t),GatherRunner.finalizeBaseArtifacts(i),{...i,...n}}catch(e){throw GatherRunner.disposeDriver(r,t),e}}static shouldClearCaches(e){const{settings:t,passConfig:r}=e;return!t.disableStorageReset&&r.recordTrace&&r.useThrottling}static _addLoadDataToBaseArtifacts(e,t,r){const n=e.baseArtifacts;n.devtoolsLogs[r]=t.devtoolsLog,t.trace&&(n.traces[r]=t.trace)}static async runPass(e){const t={msg:`Running ${e.passConfig.passName} pass`,id:`lh:gather:runPass-${e.passConfig.passName}`,args:[e.passConfig.gatherers.map(e=>e.instance.name).join(", ")]};n.time(t);const r={},{driver:i,passConfig:a}=e;await GatherRunner.loadBlank(i,a.blankPage),await GatherRunner.setupPassNetwork(e),GatherRunner.shouldClearCaches(e)&&await i.cleanBrowserCaches(),await GatherRunner.beforePass(e,r),await GatherRunner.beginRecording(e);const{navigationError:s}=await GatherRunner.loadPage(i,e);await GatherRunner.pass(e,r);const o=await GatherRunner.endRecording(e)
;await i.setThrottling(e.settings,{useThrottling:!1});const l=GatherRunner.getPageLoadError(e,o,s);if(l){const r=u.getFormatted(l.friendlyMessage,e.settings.locale);return n.error("GatherRunner",r,e.url),e.LighthouseRunWarnings.push(l.friendlyMessage),GatherRunner._addLoadDataToBaseArtifacts(e,o,`pageLoadError-${a.passName}`),n.timeEnd(t),{artifacts:{},pageLoadError:l}}GatherRunner._addLoadDataToBaseArtifacts(e,o,a.passName),await GatherRunner.afterPass(e,o,r);const c=GatherRunner.collectArtifacts(r);return n.timeEnd(t),c}}t.exports=GatherRunner,t.exports.UIStrings=m}).call(this,"/lighthouse-core/gather/gather-runner.js")},{"../config/constants.js":54,"../lib/dependency-graph/simulator/network-analyzer.js":74,"../lib/i18n/i18n.js":78,"../lib/lh-error.js":86,"../lib/manifest-parser.js":87,"../lib/network-recorder.js":89,"../lib/stack-collector.js":94,"../lib/url-shim.js":"url","lighthouse-logger":141}],62:[function(e,t,r){"use strict";t.exports=class Gatherer{get name(){
return this.constructor.name}beforePass(e){}pass(e){}afterPass(e,t){}}},{}],63:[function(e,t,r){"use strict";const n=e("./runner.js"),i=e("lighthouse-logger"),a=e("./gather/connections/cri.js"),s=e("./config/config.js");async function lighthouse(e,t={},r,s){t.logLevel=t.logLevel||"error",i.setLevel(t.logLevel);const o=generateConfig(r,t);return s=s||new a(t.port,t.hostname),n.run(s,{url:e,config:o})}function generateConfig(e,t){return new s(e,t)}lighthouse.generateConfig=generateConfig,lighthouse.getAuditList=n.getAuditList,lighthouse.traceCategories=e("./gather/driver.js").traceCategories,lighthouse.Audit=e("./audits/audit.js"),lighthouse.Gatherer=e("./gather/gatherers/gatherer.js"),lighthouse.NetworkRecords=e("./computed/network-records.js"),t.exports=lighthouse},{"./audits/audit.js":3,"./computed/network-records.js":40,"./config/config.js":53,"./gather/connections/cri.js":119,"./gather/driver.js":59,"./gather/gatherers/gatherer.js":62,"./runner.js":107,"lighthouse-logger":141}],
64:[function(e,t,r){"use strict";const n=e("lodash.isequal");class ArbitraryEqualityMap{constructor(){this._equalsFn=ArbitraryEqualityMap.deepEquals,this._entries=[]}setEqualityFn(e){this._equalsFn=e}has(e){return-1!==this._findIndexOf(e)}get(e){const t=this._entries[this._findIndexOf(e)];return t&&t.value}set(e,t){let r=this._findIndexOf(e);-1===r&&(r=this._entries.length),this._entries[r]={key:e,value:t}}_findIndexOf(e){for(let t=0;t<this._entries.length;t++)if(this._equalsFn(e,this._entries[t].key))return t;return-1}static deepEquals(e,t){return n(e,t)}}t.exports=ArbitraryEqualityMap},{"lodash.isequal":169}],65:[function(e,t,r){(function(r){"use strict"
;const n=e("fs"),i=e("path"),a=e("lighthouse-logger"),s=e("stream"),o=e("./dependency-graph/simulator/simulator.js"),l=e("./lantern-trace-saver.js"),c=e("./traces/pwmetrics-events.js"),u=e("rimraf"),d=e("../computed/network-analysis.js"),m=e("../computed/load-simulator.js"),p=e("../lib/lh-error.js"),h="artifacts.json",g=".trace.json",f=".devtoolslog.json";function stringifyReplacer(e,t){return t instanceof Error?p.stringifyReplacer(t):t}async function prepareAssets(e,t){const r=Object.keys(e.traces),n=[];for(const i of r){const r=e.traces[i],a=e.devtoolsLogs[i],s=Object.assign({},r);if(t){const e=new c(s.traceEvents,t).generateFakeEvents();s.traceEvents=s.traceEvents.concat(e)}n.push({passName:i,traceData:s,devtoolsLog:a})}return n}function saveTrace(e,t){return new Promise((r,i)=>{const a=function*traceJsonGenerator(e){const t=Object.keys(e);if(yield"{\n",yield'"traceEvents": [\n',e.traceEvents.length>0){const t=e.traceEvents[Symbol.iterator](),r=t.next().value
;yield`  ${JSON.stringify(r)}`;let n=500,i="";for(const e of t)i+=`,\n  ${JSON.stringify(e)}`,0===--n&&(yield i,n=500,i="");yield i}if(yield"\n]",t.length>1)for(const r of t)"traceEvents"!==r&&(yield`,\n"${r}": ${JSON.stringify(e[r],null,2)}`);yield"}\n"}(e),o=new s.Readable({read(){const e=a.next();this.push(e.done?null:e.value)}}),l=n.createWriteStream(t);l.on("finish",r),l.on("error",i),o.pipe(l)})}t.exports={saveArtifacts:async function saveArtifacts(e,t){const r={msg:"Saving artifacts",id:"lh:assetSaver:saveArtifacts"};a.time(r),n.mkdirSync(t,{recursive:!0}),u.sync(`${t}/*${g}`),u.sync(`${t}/${h}`);const{traces:i,devtoolsLogs:s,...o}=e;for(const[e,r]of Object.entries(i))await saveTrace(r,`${t}/${e}${g}`);for(const[e,r]of Object.entries(s)){const i=JSON.stringify(r);n.writeFileSync(`${t}/${e}${f}`,i,"utf8")}const l=JSON.stringify(o,stringifyReplacer,2);n.writeFileSync(`${t}/${h}`,l,"utf8"),a.log("Artifacts saved to disk in folder:",t),a.timeEnd(r)},
loadArtifacts:function loadArtifacts(e){if(a.log("Reading artifacts from disk:",e),!n.existsSync(e))throw new Error("No saved artifacts found at "+e);const t=n.readFileSync(i.join(e,h),"utf8"),r=JSON.parse(t,p.parseReviver),s=n.readdirSync(e);return r.devtoolsLogs={},s.filter(e=>e.endsWith(f)).forEach(t=>{const a=t.replace(f,""),s=JSON.parse(n.readFileSync(i.join(e,t),"utf8"));r.devtoolsLogs[a]=s}),r.traces={},s.filter(e=>e.endsWith(g)).forEach(t=>{const a=n.readFileSync(i.join(e,t),{encoding:"utf-8"}),s=JSON.parse(a),o=t.replace(g,"");r.traces[o]=Array.isArray(s)?{traceEvents:s}:s}),Array.isArray(r.Timing)&&r.Timing.forEach(e=>e.gather=!0),r},saveAssets:async function saveAssets(e,t,i){const s=(await prepareAssets(e,t)).map(async(e,t)=>{const r=`${i}-${t}${f}`;n.writeFileSync(r,JSON.stringify(e.devtoolsLog,null,2)),a.log("saveAssets","devtools log saved to disk: "+r);const s=`${i}-${t}${g}`;a.log("saveAssets","streaming trace file to disk: "+s),await saveTrace(e.traceData,s),
a.log("saveAssets","trace file streamed to disk: "+s)});await Promise.all(s),await async function saveLanternDebugTraces(e){if(r.env.LANTERN_DEBUG)for(const[t,r]of o.ALL_NODE_TIMINGS){if(l.simulationNamesToIgnore.includes(t))continue;const n=`${e}-${t}${g}`;await saveTrace(l.convertNodeTimingsToTrace(r),n),a.log("saveAssets",`${t} lantern trace file streamed to disk: ${n}`)}}(i)},prepareAssets:prepareAssets,saveTrace:saveTrace,saveLanternNetworkData:async function saveLanternNetworkData(e,t){const r={computedCache:new Map},i=await d.request(e,r),a=m.convertAnalysisToSaveableLanternData(i);n.writeFileSync(t,JSON.stringify(a))},stringifyReplacer:stringifyReplacer}}).call(this,e("_process"))},{"../computed/load-simulator.js":12,"../computed/network-analysis.js":39,"../lib/lh-error.js":86,"./dependency-graph/simulator/simulator.js":75,"./lantern-trace-saver.js":81,"./traces/pwmetrics-events.js":102,_process:184,fs:119,"lighthouse-logger":141,path:182,rimraf:119,stream:209}],
66:[function(e,t,r){"use strict";const n={console:console};t.exports=n},{}],67:[function(e,t,r){"use strict";const n={TextSourceMap:e("./generated/SourceMap.js")};function extendArray(e){e.lowerBound||(e.lowerBound=function lowerBound(e,t,r,n){t=t||function defaultComparator(e,t){return e<t?-1:e>t?1:0};let i=r||0,a=void 0!==n?n:this.length;for(;i<a;){const r=i+a>>1;t(e,this[r])>0?i=r+1:a=r}return a}.bind(e),e.upperBound=function upperBound(e,t,r,n){t=t||function defaultComparator(e,t){return e<t?-1:e>t?1:0};let i=r||0,a=void 0!==n?n:this.length;for(;i<a;){const r=i+a>>1;t(e,this[r])>=0?i=r+1:a=r}return a}.bind(e),e.slice=function(t,r){const n=Array.prototype.slice.call(e,t,r);return extendArray(n),n},e.filter=function(t){const r=Array.prototype.filter.call(e,t);return extendArray(r),r})}const i=n.TextSourceMap.prototype.mappings;n.TextSourceMap.prototype.mappings=function(){const e=i.call(this);return extendArray(e),e};const a=n.TextSourceMap.prototype._reversedMappings
;n.TextSourceMap.prototype._reversedMappings=function(e){const t=a.call(this,e);return extendArray(t),t},n.TextSourceMap.prototype.computeLastGeneratedColumns=function(){const e=this.mappings();if(!e.length||void 0===e[0].lastColumnNumber)for(let t=0;t<e.length-1;t++){const r=e[t],n=e[t+1];r.lineNumber===n.lineNumber&&(r.lastColumnNumber=n.columnNumber)}},t.exports=n},{"./generated/SourceMap.js":68}],68:[function(e,t,r){const n=e("../Common.js");Object.defineProperty(r,"__esModule",{value:!0});class SourceMapV3{constructor(){this.version,this.file,this.sources,this.sections,this.mappings,this.sourceRoot,this.names}}SourceMapV3.Section=class{constructor(){this.map,this.offset}},SourceMapV3.Offset=class{constructor(){this.line,this.column}};class SourceMapEntry{constructor(e,t,r,n,i,a){this.lineNumber=e,this.columnNumber=t,this.sourceURL=r,this.sourceLineNumber=n,this.sourceColumnNumber=i,this.name=a}static compare(e,t){
return e.lineNumber!==t.lineNumber?e.lineNumber-t.lineNumber:e.columnNumber-t.columnNumber}}class TextSourceMap{constructor(e,t,r){if(!TextSourceMap._base64Map){const e="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";TextSourceMap._base64Map={};for(let t=0;t<e.length;++t)TextSourceMap._base64Map[e.charAt(t)]=t}if(this._json=r,this._compiledURL=e,this._sourceMappingURL=t,this._baseURL=t.startsWith("data:")?e:t,this._mappings=null,this._sourceInfos=new Map,this._json.sections){!!this._json.sections.find(e=>!!e.url)&&n.console.warn(`SourceMap "${t}" contains unsupported "URL" field in one of its sections.`)}this._eachSection(this._parseSources.bind(this))}compiledURL(){return this._compiledURL}url(){return this._sourceMappingURL}sourceURLs(){return this._sourceInfos.keysArray()}embeddedContentByURL(e){return this._sourceInfos.has(e)?this._sourceInfos.get(e).content:null}findEntry(e,t){const r=this.mappings(),n=r.upperBound(void 0,(r,n)=>e-n.lineNumber||t-n.columnNumber)
;return n?r[n-1]:null}sourceLineMapping(e,t,r){const n=this._reversedMappings(e),i=n.lowerBound(t,lineComparator),a=n.upperBound(t,lineComparator);if(i>=n.length||n[i].sourceLineNumber!==t)return null;const s=n.slice(i,a);if(!s.length)return null;const o=s.lowerBound(r,(e,t)=>e-t.sourceColumnNumber);return o>=s.length?s[s.length-1]:s[o];function lineComparator(e,t){return e-t.sourceLineNumber}}findReverseEntries(e,t,r){const n=this._reversedMappings(e),i=n.upperBound(void 0,(e,n)=>t-n.sourceLineNumber||r-n.sourceColumnNumber);let a=i;for(;a>0&&n[a-1].sourceLineNumber===n[i-1].sourceLineNumber&&n[a-1].sourceColumnNumber===n[i-1].sourceColumnNumber;)--a;return n.slice(a,i)}mappings(){return null===this._mappings&&(this._mappings=[],this._eachSection(this._parseMap.bind(this)),this._json=null),this._mappings}_reversedMappings(e){if(!this._sourceInfos.has(e))return[];const t=this.mappings(),r=this._sourceInfos.get(e)
;return null===r.reverseMappings&&(r.reverseMappings=t.filter(t=>t.sourceURL===e).sort(function sourceMappingComparator(e,t){if(e.sourceLineNumber!==t.sourceLineNumber)return e.sourceLineNumber-t.sourceLineNumber;if(e.sourceColumnNumber!==t.sourceColumnNumber)return e.sourceColumnNumber-t.sourceColumnNumber;if(e.lineNumber!==t.lineNumber)return e.lineNumber-t.lineNumber;return e.columnNumber-t.columnNumber})),r.reverseMappings}_eachSection(e){if(this._json.sections)for(const t of this._json.sections)e(t.map,t.offset.line,t.offset.column);else e(this._json,0,0)}_parseSources(e){const t=[];let r=e.sourceRoot||"";r&&!r.endsWith("/")&&(r+="/");for(let n=0;n<e.sources.length;++n){let i=r+e.sources[n];const a=e.sourcesContent&&e.sourcesContent[n];this._compiledURL,this._sourceInfos.set(i,new TextSourceMap.SourceInfo(a,null)),t.push(i)}e[TextSourceMap._sourcesListSymbol]=t}_parseMap(e,t,r){let n=0,i=0,a=0,s=0
;const o=e[TextSourceMap._sourcesListSymbol],l=e.names||[],c=new TextSourceMap.StringCharIterator(e.mappings);let u=o[n];for(;;){if(","===c.peek())c.next();else{for(;";"===c.peek();)t+=1,r=0,c.next();if(!c.hasNext())break}if(r+=this._decodeVLQ(c),!c.hasNext()||this._isSeparator(c.peek())){this._mappings.push(new SourceMapEntry(t,r));continue}const e=this._decodeVLQ(c);e&&(u=o[n+=e]),i+=this._decodeVLQ(c),a+=this._decodeVLQ(c),c.hasNext()&&!this._isSeparator(c.peek())?(s+=this._decodeVLQ(c),this._mappings.push(new SourceMapEntry(t,r,u,i,a,l[s]))):this._mappings.push(new SourceMapEntry(t,r,u,i,a))}this._mappings.sort(SourceMapEntry.compare)}_isSeparator(e){return","===e||";"===e}_decodeVLQ(e){let t,r=0,n=0;do{r+=((t=TextSourceMap._base64Map[e.next()])&TextSourceMap._VLQ_BASE_MASK)<<n,n+=TextSourceMap._VLQ_BASE_SHIFT}while(t&TextSourceMap._VLQ_CONTINUATION_MASK);const i=1&r;return r>>=1,i?-r:r}reverseMapTextRange(e,t){function comparator(e,t){
return e.lineNumber!==t.sourceLineNumber?e.lineNumber-t.sourceLineNumber:e.columnNumber-t.sourceColumnNumber}const r=this._reversedMappings(e),n=r.lowerBound({lineNumber:t.startLine,columnNumber:t.startColumn},comparator),i=r.upperBound({lineNumber:t.endLine,columnNumber:t.endColumn},comparator),a=r[n],s=r[i];return new TextUtils.TextRange(a.lineNumber,a.columnNumber,s.lineNumber,s.columnNumber)}dispose(){}}TextSourceMap._VLQ_BASE_SHIFT=5,TextSourceMap._VLQ_BASE_MASK=31,TextSourceMap._VLQ_CONTINUATION_MASK=32,TextSourceMap.StringCharIterator=class{constructor(e){this._string=e,this._position=0}next(){return this._string.charAt(this._position++)}peek(){return this._string.charAt(this._position)}hasNext(){return this._position<this._string.length}},TextSourceMap.SourceInfo=class{constructor(e,t){this.content=e,this.reverseMappings=t}},TextSourceMap._sourcesListSymbol=Symbol("sourcesList"),t.exports=TextSourceMap},{"../Common.js":66}],69:[function(e,t,r){"use strict";class BaseNode{
constructor(e){this._id=e,this._isMainDocument=!1,this._dependents=[],this._dependencies=[]}get id(){return this._id}get type(){throw new Error("Unimplemented")}get startTime(){throw new Error("Unimplemented")}get endTime(){throw new Error("Unimplemented")}setIsMainDocument(e){this._isMainDocument=e}isMainDocument(){return this._isMainDocument}getDependents(){return this._dependents.slice()}getNumberOfDependents(){return this._dependents.length}getDependencies(){return this._dependencies.slice()}getNumberOfDependencies(){return this._dependencies.length}getRootNode(){let e=this;for(;e._dependencies.length;)e=e._dependencies[0];return e}addDependent(e){e.addDependency(this)}addDependency(e){if(e===this)throw new Error("Cannot add dependency on itself");this._dependencies.includes(e)||(e._dependents.push(this),this._dependencies.push(e))}removeDependent(e){e.removeDependency(this)}removeDependency(e){if(!this._dependencies.includes(e))return;const t=e._dependents.indexOf(this)
;e._dependents.splice(t,1),this._dependencies.splice(this._dependencies.indexOf(e),1)}removeAllDependencies(){for(const e of this._dependencies.slice())this.removeDependency(e)}isDependentOn(e){let t=!1;return this.traverse(r=>{t||(t=r===e)},e=>t?[]:e.getDependencies()),t}cloneWithoutRelationships(){const e=new BaseNode(this.id);return e.setIsMainDocument(this._isMainDocument),e}cloneWithRelationships(e){const t=this.getRootNode(),r=new Map;t.traverse(t=>{r.has(t.id)||(void 0!==e?e(t)&&t.traverse(e=>r.set(e.id,e.cloneWithoutRelationships()),e=>e._dependencies.filter(e=>!r.has(e.id))):r.set(t.id,t.cloneWithoutRelationships()))}),t.traverse(e=>{const t=r.get(e.id);if(t)for(const n of e._dependencies){const e=r.get(n.id);if(!e)throw new Error("Dependency somehow not cloned");t.addDependency(e)}});const n=r.get(this.id);if(!n)throw new Error("Cloned graph missing node");return n}traverse(e,t){t||(t=e=>e.getDependents());const r=[[this]],n=new Set([this.id]);for(;r.length;){
const i=r.shift(),a=i[0];e(a,i);for(const e of t(a))n.has(e.id)||(n.add(e.id),r.push([e,...i]))}}static hasCycle(e,t="both"){if("both"===t)return BaseNode.hasCycle(e,"dependents")||BaseNode.hasCycle(e,"dependencies");const r=new Set,n=[],i=[e],a=new Map([[e,0]]);for(;i.length;){const e=i.pop();if(n.includes(e))return!0;if(r.has(e))continue;for(;n.length>a.get(e);)n.pop();r.add(e),n.push(e);const s="dependents"===t?e._dependents:e._dependencies;for(const e of s)i.includes(e)||(i.push(e),a.set(e,n.length))}return!1}}BaseNode.TYPES={NETWORK:"network",CPU:"cpu"},t.exports=BaseNode},{}],70:[function(e,t,r){"use strict";const n=e("./base-node.js");class CPUNode extends n{constructor(e,t=[]){super(`${e.tid}.${e.ts}`),this._event=e,this._childEvents=t}get type(){return n.TYPES.CPU}get startTime(){return this._event.ts}get endTime(){return this._event.ts+this._event.dur}get event(){return this._event}get childEvents(){return this._childEvents}didPerformLayout(){
return this._childEvents.some(e=>"Layout"===e.name)}getEvaluateScriptURLs(){const e=new Set;for(const t of this._childEvents)"EvaluateScript"===t.name&&t.args.data&&t.args.data.url&&e.add(t.args.data.url);return e}cloneWithoutRelationships(){return new CPUNode(this._event,this._childEvents)}}t.exports=CPUNode},{"./base-node.js":69}],71:[function(e,t,r){"use strict";const n=e("./base-node.js"),i=e("../network-request.js"),a=e("../url-shim.js");class NetworkNode extends n{constructor(e){super(e.requestId),this._record=e}get type(){return n.TYPES.NETWORK}get startTime(){return 1e3*this._record.startTime*1e3}get endTime(){return 1e3*this._record.endTime*1e3}get record(){return this._record}get initiatorType(){return this._record.initiator&&this._record.initiator.type}get fromDiskCache(){return!!this._record.fromDiskCache}get isNonNetworkProtocol(){return a.NON_NETWORK_PROTOCOLS.includes(this._record.protocol)}get isConnectionless(){return this.fromDiskCache||this.isNonNetworkProtocol}
hasRenderBlockingPriority(){const e=this._record.priority,t=this._record.resourceType===i.TYPES.Script,r=this._record.resourceType===i.TYPES.Document;return"VeryHigh"===e||"High"===e&&t||"High"===e&&r}cloneWithoutRelationships(){const e=new NetworkNode(this._record);return e.setIsMainDocument(this._isMainDocument),e}}t.exports=NetworkNode},{"../network-request.js":90,"../url-shim.js":"url","./base-node.js":69}],72:[function(e,t,r){"use strict";const n=e("./network-analyzer.js"),i=e("./tcp-connection.js"),a=["https","wss"];t.exports=class ConnectionPool{constructor(e,t){this._options=t,this._records=e,this._connectionsByOrigin=new Map,this._connectionsByRecord=new Map,this._connectionsInUse=new Set,this._connectionReusedByRequestId=n.estimateIfConnectionWasReused(e,{forceCoarseEstimates:!0}),this._initializeConnections()}connectionsInUse(){return Array.from(this._connectionsInUse)}_initializeConnections(){
const e=this._connectionReusedByRequestId,t=this._options.additionalRttByOrigin,r=this._options.serverResponseTimeByOrigin,s=n.groupByOrigin(this._records);for(const[n,o]of s.entries()){const s=[],l=t.get(n)||0,c=r.get(n)||30;for(const t of o){if(e.get(t.requestId))continue;const r=a.includes(t.parsedURL.scheme),n="h2"===t.protocol,o=new i(this._options.rtt+l,this._options.throughput,c,r,n);s.push(o)}if(!s.length)throw new Error(`Could not find a connection for origin: ${n}`);for(;s.length<6;)s.push(s[0].clone());this._connectionsByOrigin.set(n,s)}}_findAvailableConnectionWithLargestCongestionWindow(e,t){const{ignoreConnectionReused:r,observedConnectionWasReused:n}=t;let i=null;for(let t=0;t<e.length;t++){const a=e[t];if(!r&&a._warmed!==n)continue;if(this._connectionsInUse.has(a))continue;const s=i&&i.congestionWindow||-1/0;a.congestionWindow>s&&(i=a)}return i}acquire(e,t={}){if(this._connectionsByRecord.has(e))throw new Error("Record already has a connection")
;const r=e.parsedURL.securityOrigin,n=!!this._connectionReusedByRequestId.get(e.requestId),i=this._connectionsByOrigin.get(r)||[],a=this._findAvailableConnectionWithLargestCongestionWindow(i,{ignoreConnectionReused:t.ignoreConnectionReused,observedConnectionWasReused:n});return a?(this._connectionsInUse.add(a),this._connectionsByRecord.set(e,a),a):null}acquireActiveConnectionFromRecord(e){const t=this._connectionsByRecord.get(e);if(!t)throw new Error("Could not find an active connection for record");return t}release(e){const t=this._connectionsByRecord.get(e);this._connectionsByRecord.delete(e),this._connectionsInUse.delete(t)}}},{"./network-analyzer.js":74,"./tcp-connection.js":76}],73:[function(e,t,r){"use strict";class DNSCache{constructor({rtt:e}){this._rtt=e,this._resolvedDomainNames=new Map}getTimeUntilResolution(e,t){const{requestedAt:r=0,shouldUpdateCache:n=!1}=t||{},i=e.parsedURL.host,a=this._resolvedDomainNames.get(i);let s=this._rtt*DNSCache.RTT_MULTIPLIER;if(a){
const e=Math.max(a.resolvedAt-r,0);s=Math.min(e,s)}const o=r+s;return n&&this._updateCacheResolvedAtIfNeeded(e,o),s}_updateCacheResolvedAtIfNeeded(e,t){const r=e.parsedURL.host,n=this._resolvedDomainNames.get(r)||{resolvedAt:t};n.resolvedAt=Math.min(n.resolvedAt,t),this._resolvedDomainNames.set(r,n)}setResolvedAt(e,t){this._resolvedDomainNames.set(e,{resolvedAt:t})}}DNSCache.RTT_MULTIPLIER=2,t.exports=DNSCache},{}],74:[function(e,t,r){"use strict";const n=14336,i=e("../../network-request.js"),a=e("../../url-shim.js"),s=.4,o={Document:.9,XHR:.9,Fetch:.9};class NetworkAnalyzer{static get SUMMARY(){return"__SUMMARY__"}static groupByOrigin(e){const t=new Map;return e.forEach(e=>{const r=e.parsedURL.securityOrigin,n=t.get(r)||[];n.push(e),t.set(r,n)}),t}static getSummary(e){return e.sort((e,t)=>e-t),{min:e[0],max:e[e.length-1],avg:e.reduce((e,t)=>e+t,0)/e.length,median:e[Math.floor((e.length-1)/2)]}}static summarize(e){const t=new Map,r=[]
;for(const[n,i]of e)t.set(n,NetworkAnalyzer.getSummary(i)),r.push(...i);return t.set(NetworkAnalyzer.SUMMARY,NetworkAnalyzer.getSummary(r)),t}static _estimateValueByOrigin(e,t){const r=NetworkAnalyzer.estimateIfConnectionWasReused(e),n=NetworkAnalyzer.groupByOrigin(e),i=new Map;for(const[e,a]of n.entries()){let n=[];for(const e of a){const i=e.timing;if(!i)continue;const a=t({record:e,timing:i,connectionReused:r.get(e.requestId)});void 0!==a&&(n=n.concat(a))}n.length&&i.set(e,n)}return i}static _estimateRTTByOriginViaTCPTiming(e){return NetworkAnalyzer._estimateValueByOrigin(e,({timing:e,connectionReused:t})=>{if(!t)return e.sslStart>0&&e.sslEnd>0?[e.connectEnd-e.sslStart,e.sslStart-e.connectStart]:e.connectStart>0&&e.connectEnd>0?e.connectEnd-e.connectStart:void 0})}static _estimateRTTByOriginViaDownloadTiming(e){return NetworkAnalyzer._estimateValueByOrigin(e,({record:e,timing:t,connectionReused:r})=>{if(r)return;if(e.transferSize<=n)return
;if(!Number.isFinite(t.receiveHeadersEnd)||t.receiveHeadersEnd<0)return;const i=1e3*(e.endTime-e.startTime)-t.receiveHeadersEnd,a=Math.log2(e.transferSize/n);return a>5?void 0:i/a})}static _estimateRTTByOriginViaSendStartTiming(e){return NetworkAnalyzer._estimateValueByOrigin(e,({record:e,timing:t,connectionReused:r})=>{if(r)return;if(!Number.isFinite(t.sendStart)||t.sendStart<0)return;let n=2;return"https"===e.parsedURL.scheme&&(n+=1),t.sendStart/n})}static _estimateRTTByOriginViaHeadersEndTiming(e){return NetworkAnalyzer._estimateValueByOrigin(e,({record:e,timing:t,connectionReused:r})=>{if(!Number.isFinite(t.receiveHeadersEnd)||t.receiveHeadersEnd<0)return;if(!e.resourceType)return;const n=o[e.resourceType]||s,i=t.receiveHeadersEnd*n;let a=1;return r||(a+=1,"https"===e.parsedURL.scheme&&(a+=1),a+=1),Math.max((t.receiveHeadersEnd-i)/a,3)})}static _estimateResponseTimeByOrigin(e,t){return NetworkAnalyzer._estimateValueByOrigin(e,({record:e,timing:r})=>{
if(!Number.isFinite(r.receiveHeadersEnd)||r.receiveHeadersEnd<0)return;if(!Number.isFinite(r.sendEnd)||r.sendEnd<0)return;const n=r.receiveHeadersEnd-r.sendEnd,i=e.parsedURL.securityOrigin,a=t.get(i)||t.get(NetworkAnalyzer.SUMMARY)||0;return Math.max(n-a,0)})}static canTrustConnectionInformation(e){const t=new Map;for(const r of e){const e=t.get(r.connectionId)||!r.connectionReused;t.set(r.connectionId,e)}return!(t.size<=1)&&Array.from(t.values()).every(e=>e)}static estimateIfConnectionWasReused(e,t){const{forceCoarseEstimates:r=!1}=t||{};if(!r&&NetworkAnalyzer.canTrustConnectionInformation(e))return new Map(e.map(e=>[e.requestId,!!e.connectionReused]));const n=new Map,i=NetworkAnalyzer.groupByOrigin(e);for(const[e,t]of i.entries()){const e=t.map(e=>e.endTime).reduce((e,t)=>Math.min(e,t),1/0);for(const r of t)n.set(r.requestId,r.startTime>=e||"h2"===r.protocol);const r=t.reduce((e,t)=>e.startTime>t.startTime?t:e);n.set(r.requestId,!1)}return n}static estimateRTTByOrigin(e,t){
const{forceCoarseEstimates:r=!1,coarseEstimateMultiplier:n=.3,useDownloadEstimates:i=!0,useSendStartEstimates:a=!0,useHeadersEndEstimates:s=!0}=t||{};let o=NetworkAnalyzer._estimateRTTByOriginViaTCPTiming(e);if(!o.size||r){o=new Map;const t=NetworkAnalyzer._estimateRTTByOriginViaDownloadTiming(e),r=NetworkAnalyzer._estimateRTTByOriginViaSendStartTiming(e),l=NetworkAnalyzer._estimateRTTByOriginViaHeadersEndTiming(e);for(const[e,r]of t.entries())i&&o.set(e,r);for(const[e,t]of r.entries()){if(!a)continue;const r=o.get(e)||[];o.set(e,r.concat(t))}for(const[e,t]of l.entries()){if(!s)continue;const r=o.get(e)||[];o.set(e,r.concat(t))}for(const e of o.values())e.forEach((t,r)=>e[r]=t*n)}if(!o.size)throw new Error("No timing information available");return NetworkAnalyzer.summarize(o)}static estimateServerResponseTimeByOrigin(e,t){let r=(t||{}).rttByOrigin;if(!r){r=new Map;const n=NetworkAnalyzer.estimateRTTByOrigin(e,t);for(const[e,t]of n.entries())r.set(e,t.min)}
const n=NetworkAnalyzer._estimateResponseTimeByOrigin(e,r);return NetworkAnalyzer.summarize(n)}static estimateThroughput(e){let t=0;const r=e.reduce((e,r)=>{return"data"===(r.parsedURL&&r.parsedURL.scheme)||r.failed||!r.finished||r.statusCode>300||!r.transferSize?e:(t+=r.transferSize,e.push({time:r.responseReceivedTime,isStart:!0}),e.push({time:r.endTime,isStart:!1}),e)},[]).sort((e,t)=>e.time-t.time);if(!r.length)return 1/0;let n=0,i=0,a=0;return r.forEach(e=>{e.isStart?(0===n&&(i=e.time),n++):0===--n&&(a+=e.time-i)}),8*t/a}static findMainDocument(e,t){if(t){const r=e.find(e=>t.startsWith(e.url)&&a.equalWithExcludedFragments(e.url,t));if(r)return r}const r=e.filter(e=>e.resourceType===i.TYPES.Document);if(!r.length)throw new Error("Unable to identify the main resource");return r.reduce((e,t)=>t.startTime<e.startTime?t:e)}}t.exports=NetworkAnalyzer},{"../../network-request.js":90,"../../url-shim.js":"url"}],75:[function(e,t,r){"use strict"
;const n=e("../base-node.js"),i=e("./tcp-connection.js"),a=e("./connection-pool.js"),s=e("./dns-cache.js"),o=e("../../../config/constants.js").throttling.mobileSlow4G,l=10,c=.5,u=1e4,d={NotReadyToStart:0,ReadyToStart:1,InProgress:2,Complete:3},m={VeryHigh:0,High:.25,Medium:.5,Low:1,VeryLow:2},p=new Map;class Simulator{constructor(e){if(this._options=Object.assign({rtt:o.rttMs,throughput:1024*o.throughputKbps,maximumConcurrentRequests:l,cpuSlowdownMultiplier:o.cpuSlowdownMultiplier,layoutTaskMultiplier:c,additionalRttByOrigin:new Map,serverResponseTimeByOrigin:new Map},e),this._rtt=this._options.rtt,this._throughput=this._options.throughput,this._maximumConcurrentRequests=Math.max(Math.min(i.maximumSaturatedConnections(this._rtt,this._throughput),this._options.maximumConcurrentRequests),1),this._cpuSlowdownMultiplier=this._options.cpuSlowdownMultiplier,this._layoutTaskMultiplier=this._cpuSlowdownMultiplier*this._options.layoutTaskMultiplier,this._cachedNodeListByStartPosition=[],
this._flexibleOrdering=!1,this._nodeTimings=new Map,this._numberInProgressByType=new Map,this._nodes={},this._dns=new s({rtt:this._rtt}),this._connectionPool=null,!Number.isFinite(this._rtt))throw new Error(`Invalid rtt ${this._rtt}`);if(!Number.isFinite(this._throughput))throw new Error(`Invalid rtt ${this._throughput}`)}get rtt(){return this._rtt}_initializeConnectionPool(e){const t=[];e.getRootNode().traverse(e=>{e.type===n.TYPES.NETWORK&&t.push(e.record)}),this._connectionPool=new a(t,this._options)}_initializeAuxiliaryData(){this._nodeTimings=new Map,this._numberInProgressByType=new Map,this._nodes={},this._cachedNodeListByStartPosition=[];for(const e of Object.values(d))this._nodes[e]=new Set}_numberInProgress(e){return this._numberInProgressByType.get(e)||0}_setTimingData(e,t){const r=this._nodeTimings.get(e)||{};Object.assign(r,t),this._nodeTimings.set(e,r)}_getTimingData(e){const t=this._nodeTimings.get(e);if(!t)throw new Error(`Unable to get timing data for node ${e.id}`)
;return t}_markNodeAsReadyToStart(e,t){const r=Simulator._computeNodeStartPosition(e),n=this._cachedNodeListByStartPosition.findIndex(e=>Simulator._computeNodeStartPosition(e)>r),i=-1===n?this._cachedNodeListByStartPosition.length:n;this._cachedNodeListByStartPosition.splice(i,0,e),this._nodes[d.ReadyToStart].add(e),this._nodes[d.NotReadyToStart].delete(e),this._setTimingData(e,{queuedTime:t})}_markNodeAsInProgress(e,t){const r=this._cachedNodeListByStartPosition.indexOf(e);this._cachedNodeListByStartPosition.splice(r,1),this._nodes[d.InProgress].add(e),this._nodes[d.ReadyToStart].delete(e),this._numberInProgressByType.set(e.type,this._numberInProgress(e.type)+1),this._setTimingData(e,{startTime:t})}_markNodeAsComplete(e,t){this._nodes[d.Complete].add(e),this._nodes[d.InProgress].delete(e),this._numberInProgressByType.set(e.type,this._numberInProgress(e.type)-1),this._setTimingData(e,{endTime:t});for(const r of e.getDependents()){
r.getDependencies().some(e=>!this._nodes[d.Complete].has(e))||this._markNodeAsReadyToStart(r,t)}}_acquireConnection(e){return this._connectionPool.acquire(e,{ignoreConnectionReused:this._flexibleOrdering})}_getNodesSortedByStartPosition(){return Array.from(this._cachedNodeListByStartPosition)}_startNodeIfPossible(e,t){if(e.type!==n.TYPES.CPU){if(e.type!==n.TYPES.NETWORK)throw new Error("Unsupported");if(!e.isConnectionless){if(this._numberInProgress(e.type)>=this._maximumConcurrentRequests)return;if(!this._acquireConnection(e.record))return}this._markNodeAsInProgress(e,t),this._setTimingData(e,{timeElapsed:0,timeElapsedOvershoot:0,bytesDownloaded:0})}else 0===this._numberInProgress(e.type)&&(this._markNodeAsInProgress(e,t),this._setTimingData(e,{timeElapsed:0}))}_updateNetworkCapacity(){for(const e of this._connectionPool.connectionsInUse())e.setThroughput(this._throughput/this._nodes[d.InProgress].size)}_estimateTimeRemaining(e){
if(e.type===n.TYPES.CPU)return this._estimateCPUTimeRemaining(e);if(e.type===n.TYPES.NETWORK)return this._estimateNetworkTimeRemaining(e);throw new Error("Unsupported")}_estimateCPUTimeRemaining(e){const t=this._getTimingData(e),r=e.didPerformLayout()?this._layoutTaskMultiplier:this._cpuSlowdownMultiplier,n=Math.min(Math.round(e.event.dur/1e3*r),u)-t.timeElapsed;return this._setTimingData(e,{estimatedTimeElapsed:n}),n}_estimateNetworkTimeRemaining(e){const t=e.record,r=this._getTimingData(e);let n=0;if(e.fromDiskCache){n=8+20*((t.resourceSize||0)/1024/1024)-r.timeElapsed}else if(e.isNonNetworkProtocol){n=2+10*((t.resourceSize||0)/1024/1024)-r.timeElapsed}else{const e=this._connectionPool.acquireActiveConnectionFromRecord(t),i=this._dns.getTimeUntilResolution(t,{requestedAt:r.startTime,shouldUpdateCache:!0}),a=r.timeElapsed;n=e.simulateDownloadUntil(t.transferSize-r.bytesDownloaded,{timeAlreadyElapsed:a,dnsResolutionTime:i,maximumTimeToElapse:1/0}).timeElapsed}
const i=n+r.timeElapsedOvershoot;return this._setTimingData(e,{estimatedTimeElapsed:i}),i}_findNextNodeCompletionTime(){let e=1/0;for(const t of this._nodes[d.InProgress])e=Math.min(e,this._estimateTimeRemaining(t));return e}_updateProgressMadeInTimePeriod(e,t,r){const i=this._getTimingData(e),a=i.estimatedTimeElapsed===t;if(e.type===n.TYPES.CPU||e.isConnectionless)return a?this._markNodeAsComplete(e,r):i.timeElapsed+=t;if(e.type!==n.TYPES.NETWORK)throw new Error("Unsupported");const s=e.record,o=this._connectionPool.acquireActiveConnectionFromRecord(s),l=this._dns.getTimeUntilResolution(s,{requestedAt:i.startTime,shouldUpdateCache:!0}),c=o.simulateDownloadUntil(s.transferSize-i.bytesDownloaded,{dnsResolutionTime:l,timeAlreadyElapsed:i.timeElapsed,maximumTimeToElapse:t-i.timeElapsedOvershoot});o.setCongestionWindow(c.congestionWindow),o.setH2OverflowBytesDownloaded(c.extraBytesDownloaded),a?(o.setWarmed(!0),this._connectionPool.release(s),
this._markNodeAsComplete(e,r)):(i.timeElapsed+=c.timeElapsed,i.timeElapsedOvershoot+=c.timeElapsed-t,i.bytesDownloaded+=c.bytesDownloaded)}_computeFinalNodeTimings(){const e=[];for(const[t,r]of this._nodeTimings)e.push([t,{startTime:r.startTime,endTime:r.endTime,duration:r.endTime-r.startTime}]);return e.sort((e,t)=>e[1].startTime-t[1].startTime),new Map(e)}getOptions(){return this._options}simulate(e,t){if(n.hasCycle(e))throw new Error("Cannot simulate graph with cycle");t=Object.assign({label:void 0,flexibleOrdering:!1},t),this._flexibleOrdering=!!t.flexibleOrdering,this._dns=new s({rtt:this._rtt}),this._initializeConnectionPool(e),this._initializeAuxiliaryData();const r=this._nodes[d.NotReadyToStart],i=this._nodes[d.ReadyToStart],a=this._nodes[d.InProgress],o=e.getRootNode();o.traverse(e=>r.add(e));let l=0,c=0;for(this._markNodeAsReadyToStart(o,l);i.size||a.size;){for(const e of this._getNodesSortedByStartPosition())this._startNodeIfPossible(e,l);if(!a.size){
if(this._flexibleOrdering)throw new Error("Failed to start a node");this._flexibleOrdering=!0;continue}this._updateNetworkCapacity();const e=this._findNextNodeCompletionTime();if(l+=e,!Number.isFinite(e)||c>1e5)throw new Error("Simulation failed, depth exceeded");c++;for(const t of a)this._updateProgressMadeInTimePeriod(t,e,l)}const u=this._computeFinalNodeTimings();return p.set(t.label||"unlabeled",u),{timeInMs:l,nodeTimings:u}}static get ALL_NODE_TIMINGS(){return p}static _computeNodeStartPosition(e){return"cpu"===e.type?e.startTime:e.startTime+(1e3*m[e.record.priority]*1e3||0)}}t.exports=Simulator},{"../../../config/constants.js":54,"../base-node.js":69,"./connection-pool.js":72,"./dns-cache.js":73,"./tcp-connection.js":76}],76:[function(e,t,r){"use strict";const n=10,i=1460;class TcpConnection{constructor(e,t,r=0,i=!0,a=!1){this._warmed=!1,this._ssl=i,this._h2=a,this._rtt=e,this._throughput=t,this._serverLatency=r,this._congestionWindow=n,this._h2OverflowBytesDownloaded=0}
static maximumSaturatedConnections(e,t){const r=8*(1e3/e*i);return Math.floor(t/r)}_computeMaximumCongestionWindowInSegments(){const e=this._throughput/8*(this._rtt/1e3);return Math.floor(e/i)}setThroughput(e){this._throughput=e}setCongestionWindow(e){this._congestionWindow=e}setWarmed(e){this._warmed=e}isWarm(){return this._warmed}isH2(){return this._h2}get congestionWindow(){return this._congestionWindow}setH2OverflowBytesDownloaded(e){this._h2&&(this._h2OverflowBytesDownloaded=e)}clone(){return Object.assign(new TcpConnection(this._rtt,this._throughput),this)}simulateDownloadUntil(e,t){const{timeAlreadyElapsed:r=0,maximumTimeToElapse:n=1/0,dnsResolutionTime:a=0}=t||{};this._warmed&&this._h2&&(e-=this._h2OverflowBytesDownloaded);const s=this._rtt,o=s/2,l=this._computeMaximumCongestionWindowInSegments();let c=o;this._warmed||(c=a+o+o+o+(this._ssl?s:0));let u=Math.ceil(c/s),d=c+this._serverLatency+o;this._warmed&&this._h2&&(d=0);const m=Math.max(d-r,0),p=n-m
;let h=Math.min(this._congestionWindow,l),g=0;m>0?g=h*i:u=0;let f=0,b=e-g;for(;b>0&&f<=p;){u++,f+=s;const e=(h=Math.max(Math.min(l,2*h),1))*i;g+=e,b-=e}const y=m+f,v=this._h2?Math.max(g-e,0):0;return{roundTrips:u,timeElapsed:y,bytesDownloaded:Math.max(Math.min(g,e),0),extraBytesDownloaded:v,congestionWindow:h}}}t.exports=TcpConnection},{}],77:[function(e,t,r){"use strict";const n="Mozilla/5.0 (Linux; Android 7.0; Moto G (4)) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4143.7 Mobile Safari/537.36 Chrome-Lighthouse",i="Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4143.7 Safari/537.36 Chrome-Lighthouse",a={offline:!0,latency:0,downloadThroughput:0,uploadThroughput:0},s={latency:0,downloadThroughput:0,uploadThroughput:0,offline:!1},o={rate:1},l={mobile:{userAgent:n,metrics:{mobile:!0,screenWidth:360,screenHeight:640,width:360,height:640,positionX:0,positionY:0,scale:1,deviceScaleFactor:2.625,screenOrientation:{angle:0,
type:"portraitPrimary"}},touchEnabled:!0},desktop:{userAgent:i,metrics:{mobile:!1,width:1350,height:940,deviceScaleFactor:1},touchEnabled:!1}};t.exports={emulate:async function emulate(e,t){if(!t.emulatedFormFactor||"none"===t.emulatedFormFactor)return;const r=l[t.emulatedFormFactor];await e.sendCommand("Network.enable"),await e.sendCommand("Network.setUserAgentOverride",{userAgent:r.userAgent}),t.internalDisableDeviceScreenEmulation||(await e.sendCommand("Emulation.setDeviceMetricsOverride",r.metrics),await e.sendCommand("Emulation.setTouchEmulationEnabled",{enabled:r.touchEnabled}))},enableNetworkThrottling:function enableNetworkThrottling(e,t){const r={offline:!1,latency:t.requestLatencyMs||0,downloadThroughput:t.downloadThroughputKbps||0,uploadThroughput:t.uploadThroughputKbps||0};return r.downloadThroughput=Math.floor(1024*r.downloadThroughput/8),r.uploadThroughput=Math.floor(1024*r.uploadThroughput/8),e.sendCommand("Network.emulateNetworkConditions",r)},
clearAllNetworkEmulation:function clearAllNetworkEmulation(e){return e.sendCommand("Network.emulateNetworkConditions",s)},enableCPUThrottling:function enableCPUThrottling(e,t){const r=t.cpuSlowdownMultiplier;return e.sendCommand("Emulation.setCPUThrottlingRate",{rate:r})},disableCPUThrottling:function disableCPUThrottling(e){return e.sendCommand("Emulation.setCPUThrottlingRate",o)},goOffline:function goOffline(e){return e.sendCommand("Network.emulateNetworkConditions",a)},MOBILE_USERAGENT:n,DESKTOP_USERAGENT:i}},{}],78:[function(e,t,r){(function(r,n){"use strict";const i=e("path"),a=e("intl-messageformat").default,s=e("lookup-closest-locale"),o=e("./locales.js"),{isObjectOfUnknownValues:l,isObjectOrArrayOfUnknownValues:c}=e("../type-verifiers.js"),u="en",d=i.join(n,"../../../"),m=/ | [^\s]+$/;(()=>{e("intl-pluralrules");const t=e("intl");if(!t.NumberFormat)return;const r=["en","es","ru","zh"];Intl.NumberFormat.supportedLocalesOf(r).length!==r.length&&(Intl.NumberFormat=t.NumberFormat,
Intl.DateTimeFormat=t.DateTimeFormat)})();const p={ms:"{timeInMs, number, milliseconds} ms",seconds:"{timeInMs, number, seconds} s",displayValueByteSavings:"Potential savings of {wastedBytes, number, bytes} KiB",displayValueMsSavings:"Potential savings of {wastedMs, number, milliseconds} ms",displayValueElementsFound:"{nodeCount, plural, =1 {1 element found} other {# elements found}}",columnURL:"URL",columnSize:"Size",columnResourceSize:"Resource Size",columnTransferSize:"Transfer Size",columnCacheTTL:"Cache TTL",columnWastedBytes:"Potential Savings",columnWastedMs:"Potential Savings",columnTimeSpent:"Time Spent",columnLocation:"Location",columnResourceType:"Resource Type",columnRequests:"Requests",columnName:"Name",columnSource:"Source",columnOverBudget:"Over Budget",columnElement:"Element",columnStartTime:"Start Time",columnDuration:"Duration",columnFailingElem:"Failing Elements",totalResourceType:"Total",documentResourceType:"Document",scriptResourceType:"Script",
stylesheetResourceType:"Stylesheet",imageResourceType:"Image",mediaResourceType:"Media",fontResourceType:"Font",otherResourceType:"Other",thirdPartyResourceType:"Third-party",firstContentfulPaintMetric:"First Contentful Paint",firstCPUIdleMetric:"First CPU Idle",interactiveMetric:"Time to Interactive",firstMeaningfulPaintMetric:"First Meaningful Paint",estimatedInputLatencyMetric:"Estimated Input Latency",totalBlockingTimeMetric:"Total Blocking Time",maxPotentialFIDMetric:"Max Potential First Input Delay",speedIndexMetric:"Speed Index",largestContentfulPaintMetric:"Largest Contentful Paint",cumulativeLayoutShiftMetric:"Cumulative Layout Shift"},h={number:{bytes:{maximumFractionDigits:0},milliseconds:{maximumFractionDigits:0},seconds:{minimumFractionDigits:1,maximumFractionDigits:1},extendedPercent:{maximumFractionDigits:2,style:"percent"}}};function collectAllCustomElementsFromICU(e,t=new Map){for(const r of e)if("argumentElement"===r.type&&(t.set(r.id,r),
r.format&&"pluralFormat"===r.format.type))for(const e of r.format.options)collectAllCustomElementsFromICU(e.value.elements,t);return t}function _formatMessage(e,t={},r){const n=new a(e,"en-XA"===r||"en-XL"===r?"de-DE":r,h),i=function _preformatValues(e,t,r){const n=[...collectAllCustomElementsFromICU(e.getAst().elements).values()],i={};for(const{id:e,format:a}of n){if(e&&e in t==!1)throw new Error(`ICU Message "${r}" contains a value reference ("${e}") `+"that wasn't provided");const n=t[e];if(a&&"numberFormat"===a.type){if("number"!=typeof n)throw new Error(`ICU Message "${r}" contains a numeric reference ("${e}") `+"but provided value was not a number");"milliseconds"===a.style?i[e]=10*Math.round(n/10):"seconds"===a.style&&"timeInMs"===e?i[e]=Math.round(n/100)/10:"bytes"===a.style?i[e]=n/1024:i[e]=n}else i[e]=n}for(const e of Object.keys(t))if(!(e in i)){if("errorCode"!==e)throw new Error(`Provided value "${e}" does not match any placeholder in `+`ICU message "${r}"`)
;i.errorCode=t.errorCode}return i}(n,t,e);return n.format(i)}function _localizeIcuMessage(e,t){const r=o[t];if(!r)throw new Error(`Unsupported locale '${t}'`);const n=r[e.i18nId];return n?_formatMessage(n.message,e.values,t):e.formattedDefault}function _formatPathAsString(e){let t="";for(const r of e)if(/^[a-z]+$/i.test(r))t.length&&(t+="."),t+=r;else{if(/]|"|'|\s/.test(r))throw new Error(`Cannot handle "${r}" in i18n`);t+=`[${r}]`}return t}function createIcuMessageFn(e,t){const n={...p,...t};return(a,s)=>{const o=Object.keys(n).find(e=>n[e]===a);if(!o)throw new Error(`Could not locate: ${a}`);const l=o in t?e:r;return{i18nId:`${i.relative(d,l).replace(/\\/g,"/")} | ${o}`,values:s,formattedDefault:_formatMessage(a,s,u)}}}function isIcuMessage(e){if(!l(e))return!1;const{i18nId:t,values:r,formattedDefault:n}=e;if("string"!=typeof t)return!1;if("string"!=typeof n)return!1;if(void 0!==r){if(!l(r))return!1;for(const e of Object.values(r))if("string"!=typeof e&&"number"!=typeof e)return!1}
return m.test(t)}t.exports={_formatPathAsString:_formatPathAsString,UIStrings:p,lookupLocale:function lookupLocale(e){const t=Intl.getCanonicalLocales(e);return s(t,o)||u},getRendererFormattedStrings:function getRendererFormattedStrings(e){const t=o[e];if(!t)throw new Error(`Unsupported locale '${e}'`);const r=Object.keys(t).filter(e=>e.includes("core/report/html/")),n={};for(const e of r){const[r,i]=e.split(" | ");if(!r.endsWith("util.js"))throw new Error(`Unexpected message: ${e}`);n[i]=t[e].message}return n},createIcuMessageFn:createIcuMessageFn,getFormatted:function getFormatted(e,t){if(isIcuMessage(e))return _localizeIcuMessage(e,t);if("string"==typeof e)return e;throw new Error("Attempted to format invalid icuMessage type")},replaceIcuMessages:function replaceIcuMessages(e,t){const r={};return function replaceInObject(e,r,n=[]){if(c(e))for(const[i,a]of Object.entries(e)){const s=n.concat([i]);if(isIcuMessage(a)){
const n=_localizeIcuMessage(a,t),o=r[a.i18nId]||[],l=_formatPathAsString(s);o.push(a.values?{values:a.values,path:l}:l),e[i]=n,r[a.i18nId]=o}else replaceInObject(a,r,s)}}(e,r),r},isIcuMessage:isIcuMessage,collectAllCustomElementsFromICU:collectAllCustomElementsFromICU,registerLocaleData:function registerLocaleData(e,t){o[e]=t},isStringOrIcuMessage:function isStringOrIcuMessage(e){return"string"==typeof e||isIcuMessage(e)},createMessageInstanceIdFn:createIcuMessageFn}}).call(this,"/lighthouse-core/lib/i18n/i18n.js","/lighthouse-core/lib/i18n")},{"../type-verifiers.js":103,"./locales.js":79,intl:119,"intl-messageformat":135,"intl-pluralrules":119,"lookup-closest-locale":170,path:182}],79:[function(e,t,r){"use strict";const n={"en-US":e("./locales/en-US.json"),en:e("./locales/en-US.json"),"en-AU":e("./locales/en-GB.json"),"en-GB":e("./locales/en-GB.json"),"en-IE":e("./locales/en-GB.json"),"en-SG":e("./locales/en-GB.json"),"en-ZA":e("./locales/en-GB.json"),
"en-IN":e("./locales/en-GB.json"),"ar-XB":e("./locales/ar-XB.json"),ar:e("./locales/ar.json"),bg:e("./locales/bg.json"),ca:e("./locales/ca.json"),cs:e("./locales/cs.json"),da:e("./locales/da.json"),de:e("./locales/de.json"),el:e("./locales/el.json"),"en-XA":e("./locales/en-XA.json"),"en-XL":e("./locales/en-XL.json"),es:e("./locales/es.json"),"es-419":e("./locales/es-419.json"),"es-AR":e("./locales/es-419.json"),"es-BO":e("./locales/es-419.json"),"es-BR":e("./locales/es-419.json"),"es-BZ":e("./locales/es-419.json"),"es-CL":e("./locales/es-419.json"),"es-CO":e("./locales/es-419.json"),"es-CR":e("./locales/es-419.json"),"es-CU":e("./locales/es-419.json"),"es-DO":e("./locales/es-419.json"),"es-EC":e("./locales/es-419.json"),"es-GT":e("./locales/es-419.json"),"es-HN":e("./locales/es-419.json"),"es-MX":e("./locales/es-419.json"),"es-NI":e("./locales/es-419.json"),"es-PA":e("./locales/es-419.json"),"es-PE":e("./locales/es-419.json"),"es-PR":e("./locales/es-419.json"),
"es-PY":e("./locales/es-419.json"),"es-SV":e("./locales/es-419.json"),"es-US":e("./locales/es-419.json"),"es-UY":e("./locales/es-419.json"),"es-VE":e("./locales/es-419.json"),fi:e("./locales/fi.json"),fil:e("./locales/fil.json"),fr:e("./locales/fr.json"),he:e("./locales/he.json"),hi:e("./locales/hi.json"),hr:e("./locales/hr.json"),hu:e("./locales/hu.json"),gsw:e("./locales/de.json"),id:e("./locales/id.json"),in:e("./locales/id.json"),it:e("./locales/it.json"),iw:e("./locales/he.json"),ja:e("./locales/ja.json"),ko:e("./locales/ko.json"),lt:e("./locales/lt.json"),lv:e("./locales/lv.json"),mo:e("./locales/ro.json"),nl:e("./locales/nl.json"),nb:e("./locales/no.json"),no:e("./locales/no.json"),pl:e("./locales/pl.json"),pt:e("./locales/pt.json"),"pt-PT":e("./locales/pt-PT.json"),ro:e("./locales/ro.json"),ru:e("./locales/ru.json"),sk:e("./locales/sk.json"),sl:e("./locales/sl.json"),sr:e("./locales/sr.json"),"sr-Latn":e("./locales/sr-Latn.json"),sv:e("./locales/sv.json"),
ta:e("./locales/ta.json"),te:e("./locales/te.json"),th:e("./locales/th.json"),tl:e("./locales/fil.json"),tr:e("./locales/tr.json"),uk:e("./locales/uk.json"),vi:e("./locales/vi.json"),zh:e("./locales/zh.json"),"zh-HK":e("./locales/zh-HK.json"),"zh-TW":e("./locales/zh-TW.json")};t.exports=n},{"./locales/ar-XB.json":119,"./locales/ar.json":119,"./locales/bg.json":119,"./locales/ca.json":119,"./locales/cs.json":119,"./locales/da.json":119,"./locales/de.json":119,"./locales/el.json":119,"./locales/en-GB.json":119,"./locales/en-US.json":119,"./locales/en-XA.json":119,"./locales/en-XL.json":119,"./locales/es-419.json":119,"./locales/es.json":119,"./locales/fi.json":119,"./locales/fil.json":119,"./locales/fr.json":119,"./locales/he.json":119,"./locales/hi.json":119,"./locales/hr.json":119,"./locales/hu.json":119,"./locales/id.json":119,"./locales/it.json":119,"./locales/ja.json":119,"./locales/ko.json":119,"./locales/lt.json":119,"./locales/lv.json":119,"./locales/nl.json":119,
"./locales/no.json":119,"./locales/pl.json":119,"./locales/pt-PT.json":119,"./locales/pt.json":119,"./locales/ro.json":119,"./locales/ru.json":119,"./locales/sk.json":119,"./locales/sl.json":119,"./locales/sr-Latn.json":119,"./locales/sr.json":119,"./locales/sv.json":119,"./locales/ta.json":119,"./locales/te.json":119,"./locales/th.json":119,"./locales/tr.json":119,"./locales/uk.json":119,"./locales/vi.json":119,"./locales/zh-HK.json":119,"./locales/zh-TW.json":119,"./locales/zh.json":119}],80:[function(e,t,r){"use strict";const n=e("./url-shim.js");t.exports={doExist:function doExist(e){return!(!e||!e.icons)&&0!==e.icons.value.length},pngSizedAtLeast:function pngSizedAtLeast(e,t){const r=t.icons.value,i=[];return r.filter(e=>{const t=e.value.type.value;if(t)return"image/png"===t;const r=e.value.src.value;return r&&new n(r).pathname.endsWith(".png")}).forEach(e=>{e.value.sizes.value&&i.push(...e.value.sizes.value)}),i.filter(e=>/\d+x\d+/.test(e)).filter(t=>{
const r=t.split(/x/i),n=[parseFloat(r[0]),parseFloat(r[1])];return n[0]>=e&&n[1]>=e&&n[0]===n[1]})},containsMaskableIcon:function containsMaskableIcon(e){return e.icons.value.some(e=>e.value.purpose&&e.value.purpose.value&&e.value.purpose.value.includes("maskable"))}}},{"./url-shim.js":"url"}],81:[function(e,t,r){"use strict";t.exports={simulationNamesToIgnore:["unlabeled","optimisticFirstCPUIdle","optimisticFlexFirstCPUIdle","pessimisticFirstCPUIdle","optimisticSpeedIndex","optimisticFlexSpeedIndex","pessimisticSpeedIndex","optimisticEstimatedInputLatency","optimisticFlexEstimatedInputLatency","pessimisticEstimatedInputLatency"],convertNodeTimingsToTrace:function convertNodeTimingsToTrace(e){const t=[],r=1e9,n={pid:1,tid:1,cat:"devtools.timeline"},i="A00001",a=e=>r+1e3*e;t.push(createFakeTracingStartedEvent()),t.push({...createFakeTracingStartedEvent(),name:"TracingStartedInBrowser"});let s=1,o=0;for(const[r,n]of e.entries())if(o=Math.max(o,n.endTime),"cpu"===r.type){const e=r
;t.push(...createFakeTaskEvents(e,n))}else{const e=r;if(/^data/.test(e.record.url))continue;t.push(...createFakeNetworkEvents(e.record,n))}return t.push(...createFakeTaskEvents({childEvents:[],event:{}},{startTime:o+1e3,endTime:o+1001})),{traceEvents:t};function createFakeTracingStartedEvent(){const e={frameTreeNodeId:1,sessionId:"1.1",page:i,persistentIds:!0,frames:[{frame:i,url:"about:blank",name:"",processId:1}]};return{...n,ts:r-1e5,ph:"I",s:"t",cat:"disabled-by-default-devtools.timeline",name:"TracingStartedInPage",args:{data:e},dur:0}}function createFakeTaskEvents(e,t){const r={url:"",frame:i,lineNumber:0,columnNumber:0},s=a(t.startTime),o=[{...n,ph:"X",name:"Task",ts:s,dur:1e3*(t.endTime-t.startTime),args:{data:r}}],l=e.event.ts||0,c=1e3*(t.endTime-t.startTime)/e.event.dur,u=new Set(["ResourceSendRequest","ResourceFinish","ResourceReceiveResponse","ResourceReceivedData"]);for(const t of e.childEvents){if(u.has(t.name))continue;const e=s+(t.ts-l)*c,r={...t,pid:n.pid,tid:n.tid,
ts:e};t.dur&&(r.dur=t.dur*c),o.push(r)}return o}function createFakeNetworkEvents(e,t){s++;let{startTime:r,endTime:o}=t;r===o&&(o+=.3);const l={requestId:s.toString(),frame:i},c={...n,ph:"I",s:"t",dur:0},u={...l,requestMethod:e.requestMethod,url:e.url,priority:e.priority},d={...l,statusCode:e.statusCode,mimeType:e.mimeType,encodedDataLength:e.transferSize,fromCache:e.fromDiskCache,fromServiceWorker:e.fetchedViaServiceWorker},m={...l,decodedBodyLength:e.resourceSize,didFail:!!e.failed,finishTime:o},p=[{...c,name:"ResourceSendRequest",ts:a(r),args:{data:u}},{...c,name:"ResourceFinish",ts:a(o),args:{data:m}}];return e.failed||p.push({...c,name:"ResourceReceiveResponse",ts:a((r+o)/2),args:{data:d}}),p}}}},{}],82:[function(e,t,r){t.exports={moment:{repository:"https://github.com/moment/moment.git",lastScraped:1597344573775,versions:{latest:{gzip:72054},"2.25.3":{gzip:71090},"2.25.2":{gzip:71119},"2.25.1":{gzip:20811},"2.25.0":{gzip:20876},"2.24.0":{gzip:67489},"2.23.0":{gzip:66675},
"2.22.2":{gzip:65962},"2.22.1":{gzip:65949}}},"date-fns":{repository:"https://github.com/date-fns/date-fns.git",lastScraped:1597344603463,versions:{latest:{gzip:18463}}},luxon:{repository:"https://github.com/moment/luxon.git",lastScraped:1597344608583,versions:{latest:{gzip:20912}}},dayjs:{repository:"https://github.com/iamkun/dayjs.git",lastScraped:1597344613371,versions:{latest:{gzip:2856}}}}},{}],83:[function(e,t,r){"use strict";t.exports={suggestions:{moment:["date-fns","luxon","dayjs"]}}},{}],84:[function(e,t,r){"use strict";e("../gather/driver.js");t.exports=class LHElement{constructor(e,t){if(!e||!t)throw Error("Driver and element required to create Element");this.driver=t,this.element=e}getAttribute(e){return this.driver.sendCommand("DOM.getAttributes",{nodeId:this.element.nodeId}).then(t=>{const r=t.attributes.indexOf(e);return-1===r?null:t.attributes[r+1]})}getNodeId(){return this.element.nodeId}getProperty(e){return this.driver.sendCommand("DOM.resolveNode",{
nodeId:this.element.nodeId}).then(t=>t.object.objectId?this.driver.getObjectProperty(t.object.objectId,e):null).catch(()=>null)}}},{"../gather/driver.js":59}],85:[function(e,t,r){(function(e){"use strict";t.exports={isUnderTest:!!e.env.CI||"test"===e.env.NODE_ENV}}).call(this,e("_process"))},{_process:184}],86:[function(e,t,r){(function(r){"use strict";const n={didntCollectScreenshots:"Chrome didn't collect any screenshots during the page load. Please make sure there is content visible on the page, and then try re-running Lighthouse. ({errorCode})",badTraceRecording:"Something went wrong with recording the trace over your page load. Please run Lighthouse again. ({errorCode})",pageLoadTookTooLong:"Your page took too long to load. Please follow the opportunities in the report to reduce your page load time, and then try re-running Lighthouse. ({errorCode})",
pageLoadFailed:"Lighthouse was unable to reliably load the page you requested. Make sure you are testing the correct URL and that the server is properly responding to all requests.",pageLoadFailedWithStatusCode:"Lighthouse was unable to reliably load the page you requested. Make sure you are testing the correct URL and that the server is properly responding to all requests. (Status code: {statusCode})",pageLoadFailedWithDetails:"Lighthouse was unable to reliably load the page you requested. Make sure you are testing the correct URL and that the server is properly responding to all requests. (Details: {errorDetails})",pageLoadFailedInsecure:"The URL you have provided does not have a valid security certificate. {securityMessages}",pageLoadFailedInterstitial:"Chrome prevented page load with an interstitial. Make sure you are testing the correct URL and that the server is properly responding to all requests.",
internalChromeError:"An internal Chrome error occurred. Please restart Chrome and try re-running Lighthouse.",requestContentTimeout:"Fetching resource content has exceeded the allotted time",notHtml:"The page provided is not HTML (served as MIME type {mimeType}).",urlInvalid:"The URL you have provided appears to be invalid.",protocolTimeout:"Waiting for DevTools protocol response has exceeded the allotted time. (Method: {protocolMethod})",dnsFailure:"DNS servers could not resolve the provided domain.",pageLoadFailedHung:"Lighthouse was unable to reliably load the URL you requested because the page stopped responding.",criTimeout:"Timeout waiting for initial Debugger Protocol connection.",missingRequiredArtifact:"Required {artifactName} gatherer did not run.",erroredRequiredArtifact:"Required {artifactName} gatherer encountered an error: {errorMessage}",oldChromeDoesNotSupportFeature:"This version of Chrome is too old to support '{featureName}'. Use a newer version to see full results."
},i=e("./i18n/i18n.js").createMessageInstanceIdFn(r,n),a="__LighthouseErrorSentinel",s="__ErrorSentinel";class LighthouseError extends Error{constructor(e,t){super(e.code),this.name="LHError",this.code=e.code,this.friendlyMessage=i(e.message,{errorCode:this.code,...t}),this.lhrRuntimeError=!!e.lhrRuntimeError,t&&Object.assign(this,t),Error.captureStackTrace(this,LighthouseError)}static fromProtocolMessage(e,t){const r=Object.values(LighthouseError.errors).filter(e=>e.pattern).find(e=>e.pattern.test(t.message));if(r)return new LighthouseError(r);let n=`(${e}): ${t.message}`;t.data&&(n+=` (${t.data})`);const i=new Error(`Protocol error ${n}`);return Object.assign(i,{protocolMethod:e,protocolError:t.message})}static stringifyReplacer(e){if(e instanceof LighthouseError){const{name:t,code:r,message:n,friendlyMessage:i,lhrRuntimeError:s,stack:o,...l}=e;return{sentinel:a,code:r,stack:o,...l}}if(e instanceof Error){const{message:t,stack:r}=e,n=e.code;return{sentinel:s,message:t,code:n,stack:r}
}throw new Error("Invalid value for LHError stringification")}static parseReviver(e,t){if("object"==typeof t&&null!==t){if(t.sentinel===a){const{sentinel:e,code:r,stack:n,...i}=t,a=LighthouseError.errors[r],s=new LighthouseError(a,i);return s.stack=n,s}if(t.sentinel===s){const{message:e,code:r,stack:n}=t,i=new Error(e);return Object.assign(i,{code:r,stack:n}),i}}return t}}const o={NO_SPEEDLINE_FRAMES:{code:"NO_SPEEDLINE_FRAMES",message:n.didntCollectScreenshots,lhrRuntimeError:!0},SPEEDINDEX_OF_ZERO:{code:"SPEEDINDEX_OF_ZERO",message:n.didntCollectScreenshots,lhrRuntimeError:!0},NO_SCREENSHOTS:{code:"NO_SCREENSHOTS",message:n.didntCollectScreenshots,lhrRuntimeError:!0},INVALID_SPEEDLINE:{code:"INVALID_SPEEDLINE",message:n.didntCollectScreenshots,lhrRuntimeError:!0},NO_TRACING_STARTED:{code:"NO_TRACING_STARTED",message:n.badTraceRecording,lhrRuntimeError:!0},NO_NAVSTART:{code:"NO_NAVSTART",message:n.badTraceRecording,lhrRuntimeError:!0},NO_FCP:{code:"NO_FCP",message:n.badTraceRecording,
lhrRuntimeError:!0},NO_DCL:{code:"NO_DCL",message:n.badTraceRecording,lhrRuntimeError:!0},NO_FMP:{code:"NO_FMP",message:n.badTraceRecording},NO_LCP:{code:"NO_LCP",message:n.badTraceRecording},UNSUPPORTED_OLD_CHROME:{code:"UNSUPPORTED_OLD_CHROME",message:n.oldChromeDoesNotSupportFeature},LAYOUT_SHIFT_MISSING_DATA:{code:"LAYOUT_SHIFT_MISSING_DATA",message:n.badTraceRecording},FMP_TOO_LATE_FOR_FCPUI:{code:"FMP_TOO_LATE_FOR_FCPUI",message:n.pageLoadTookTooLong},NO_FCPUI_IDLE_PERIOD:{code:"NO_FCPUI_IDLE_PERIOD",message:n.pageLoadTookTooLong},NO_TTI_CPU_IDLE_PERIOD:{code:"NO_TTI_CPU_IDLE_PERIOD",message:n.pageLoadTookTooLong},NO_TTI_NETWORK_IDLE_PERIOD:{code:"NO_TTI_NETWORK_IDLE_PERIOD",message:n.pageLoadTookTooLong},NO_DOCUMENT_REQUEST:{code:"NO_DOCUMENT_REQUEST",message:n.pageLoadFailed,lhrRuntimeError:!0},FAILED_DOCUMENT_REQUEST:{code:"FAILED_DOCUMENT_REQUEST",message:n.pageLoadFailedWithDetails,lhrRuntimeError:!0},ERRORED_DOCUMENT_REQUEST:{code:"ERRORED_DOCUMENT_REQUEST",
message:n.pageLoadFailedWithStatusCode,lhrRuntimeError:!0},INSECURE_DOCUMENT_REQUEST:{code:"INSECURE_DOCUMENT_REQUEST",message:n.pageLoadFailedInsecure,lhrRuntimeError:!0},CHROME_INTERSTITIAL_ERROR:{code:"CHROME_INTERSTITIAL_ERROR",message:n.pageLoadFailedInterstitial,lhrRuntimeError:!0},PAGE_HUNG:{code:"PAGE_HUNG",message:n.pageLoadFailedHung,lhrRuntimeError:!0},NOT_HTML:{code:"NOT_HTML",message:n.notHtml,lhrRuntimeError:!0},TRACING_ALREADY_STARTED:{code:"TRACING_ALREADY_STARTED",message:n.internalChromeError,pattern:/Tracing.*started/,lhrRuntimeError:!0},PARSING_PROBLEM:{code:"PARSING_PROBLEM",message:n.internalChromeError,pattern:/Parsing problem/,lhrRuntimeError:!0},READ_FAILED:{code:"READ_FAILED",message:n.internalChromeError,pattern:/Read failed/,lhrRuntimeError:!0},INVALID_URL:{code:"INVALID_URL",message:n.urlInvalid},PROTOCOL_TIMEOUT:{code:"PROTOCOL_TIMEOUT",message:n.protocolTimeout,lhrRuntimeError:!0},DNS_FAILURE:{code:"DNS_FAILURE",message:n.dnsFailure,lhrRuntimeError:!0},
CRI_TIMEOUT:{code:"CRI_TIMEOUT",message:n.criTimeout,lhrRuntimeError:!0},MISSING_REQUIRED_ARTIFACT:{code:"MISSING_REQUIRED_ARTIFACT",message:n.missingRequiredArtifact},ERRORED_REQUIRED_ARTIFACT:{code:"ERRORED_REQUIRED_ARTIFACT",message:n.erroredRequiredArtifact}};LighthouseError.errors=o,LighthouseError.NO_ERROR="NO_ERROR",LighthouseError.UNKNOWN_ERROR="UNKNOWN_ERROR",t.exports=LighthouseError,t.exports.UIStrings=n}).call(this,"/lighthouse-core/lib/lh-error.js")},{"./i18n/i18n.js":78}],87:[function(e,t,r){"use strict";const n=e("./url-shim.js"),i=e("cssstyle/lib/parsers"),a=["fullscreen","standalone","minimal-ui","browser"],s="browser",o=["any","natural","landscape","portrait","portrait-primary","portrait-secondary","landscape-primary","landscape-secondary"];function parseString(e,t){let r,n;return"string"==typeof e?r=t?e.trim():e:(void 0!==e&&(n="ERROR: expected a string."),r=void 0),{raw:e,value:r,warning:n}}function parseColor(e){const t=parseString(e)
;return void 0===t.value?t:(function isValidColor(e){return i.valueType(e)===i.TYPES.COLOR}(t.raw)||(t.value=void 0,t.warning="ERROR: color parsing failed."),t)}function parseName(e){return parseString(e.name,!0)}function parseShortName(e){return parseString(e.short_name,!0)}function parseStartUrl(e,t,r){const i=e.start_url;if(""===i)return{raw:i,value:r,warning:"ERROR: start_url string empty"};if(void 0===i)return{raw:i,value:r};if("string"!=typeof i)return{raw:i,value:r,warning:"ERROR: expected a string."};let a;try{a=new n(i,t).href}catch(e){return{raw:i,value:r,warning:`ERROR: invalid start_url relative to ${t}`}}return function checkSameOrigin(e,t){const r=new n(e),i=new n(t);return r.origin===i.origin}(a,r)?{raw:i,value:a}:{raw:i,value:r,warning:"ERROR: start_url must be same-origin as document"}}function parseDisplay(e){const t=parseString(e.display,!0),r=t.value;if(!r)return{raw:e,value:s,warning:t.warning};const n=r.toLowerCase();return a.includes(n)?{raw:e,value:n,
warning:void 0}:{raw:e,value:s,warning:"ERROR: 'display' has invalid value "+n+`. will fall back to ${s}.`}}function parseOrientation(e){const t=parseString(e.orientation,!0);return t.value&&!o.includes(t.value.toLowerCase())&&(t.value=void 0,t.warning="ERROR: 'orientation' has an invalid value, will be ignored."),t}function parseIcons(e,t){const r=e.icons;if(void 0===r)return{raw:r,value:[],warning:void 0};if(!Array.isArray(r))return{raw:r,value:[],warning:"ERROR: 'icons' expected to be an array but is not."};const i=r.filter(e=>void 0!==e.src).map(e=>(function parseIcon(e,t){const r=parseString(e.src,!0);if(""===r.value&&(r.value=void 0),r.value)try{r.value=new n(r.value,t).href}catch(t){r.warning=`ERROR: invalid icon url will be ignored: '${e.src}'`,r.value=void 0}const i=parseString(e.type,!0),a=parseString(e.purpose),s={raw:e.purpose,value:["any"],warning:void 0};void 0!==a.value&&(s.value=a.value.split(/\s+/).map(e=>e.toLowerCase()));const o={raw:e.density,value:1,warning:void 0}
;let l;void 0!==o.raw&&(o.value=parseFloat(o.raw),(isNaN(o.value)||!isFinite(o.value)||o.value<=0)&&(o.value=1,o.warning="ERROR: icon density cannot be NaN, +∞, or less than or equal to +0."));const c=parseString(e.sizes);if(void 0!==c.value){const t=new Set;c.value.trim().split(/\s+/).forEach(e=>t.add(e.toLowerCase())),l={raw:e.sizes,value:t.size>0?Array.from(t):void 0,warning:void 0}}else l={...c,value:void 0};return{raw:e,value:{src:r,type:i,density:o,sizes:l,purpose:s},warning:void 0}})(e,t)),a=i.filter(e=>{const t=[e.warning,e.value.type.warning,e.value.src.warning,e.value.sizes.warning,e.value.density.warning].filter(Boolean),r=!!e.value.src.value;return!!t.length&&!r});return{raw:r,value:i.filter(e=>void 0!==e.value.src.value),warning:a.length?"WARNING: Some icons were ignored due to warnings.":void 0}}function parseApplication(e){const t=parseString(e.platform,!0),r=parseString(e.id,!0),i=parseString(e.url,!0);if(i.value)try{i.value=new n(i.value).href}catch(t){i.value=void 0,
i.warning=`ERROR: invalid application URL ${e.url}`}return{raw:e,value:{platform:t,id:r,url:i},warning:void 0}}function parseRelatedApplications(e){const t=e.related_applications;if(void 0===t)return{raw:t,value:void 0,warning:void 0};if(!Array.isArray(t))return{raw:t,value:void 0,warning:"ERROR: 'related_applications' expected to be an array but is not."};const r=t.filter(e=>!!e.platform).map(parseApplication).filter(e=>!!e.value.id.value||!!e.value.url.value);return{raw:t,value:r,warning:void 0}}function parsePreferRelatedApplications(e){const t=e.prefer_related_applications;let r,n;return"boolean"==typeof t?r=t:(void 0!==t&&(n="ERROR: 'prefer_related_applications' expected to be a boolean."),r=void 0),{raw:t,value:r,warning:n}}function parseThemeColor(e){return parseColor(e.theme_color)}function parseBackgroundColor(e){return parseColor(e.background_color)}t.exports=function parse(e,t,r){
if(void 0===t||void 0===r)throw new Error("Manifest and document URLs required for manifest parsing.");let i;try{i=JSON.parse(e)}catch(r){return{raw:e,value:void 0,warning:"ERROR: file isn't valid JSON: "+r,url:t}}const a={name:parseName(i),short_name:parseShortName(i),start_url:parseStartUrl(i,t,r),display:parseDisplay(i),orientation:parseOrientation(i),icons:parseIcons(i,t),related_applications:parseRelatedApplications(i),prefer_related_applications:parsePreferRelatedApplications(i),theme_color:parseThemeColor(i),background_color:parseBackgroundColor(i)};let s;try{new n(t).protocol.startsWith("http")||(s="WARNING: manifest URL not available over a valid network protocol")}catch(e){s=`ERROR: invalid manifest URL: '${t}'`}return{raw:e,value:a,warning:s,url:t}}},{"./url-shim.js":"url","cssstyle/lib/parsers":123}],88:[function(e,t,r){"use strict"
;const n=/(return|{|\(|\[|\.\.\.|;|,|<|>|<=|>=|==|!=|===|!==|\+|-|\*|%|\*\*|\+\+|--|<<|>>|>>>|&|\||\^|!|~|&&|\|\||\?|:|=|\+=|-=|\*=|%=|\*\*=|<<=|>>=|>>>=|&=|\|=|\^=|=>|\/|\/=|\})$/,i=/( |\n|\t)+$/;function hasPunctuatorBefore(e,t){for(let r=t;r>0;r--){const t=Math.max(0,r-6),a=e.slice(t,r);if(!i.test(a))return n.test(a)}return!0}function computeTokenLength(e,t){let r=0,n=!1,i=!1,a=!1,s=!1,o=!1,l=!1,c=null;const u=[];for(let d=0;d<e.length;d++){const m=e.substr(d,2),p=m.charAt(0),h=" "===p||"\n"===p||"\t"===p,g="'"===p||'"'===p||"`"===p;n?"\n"===p&&(n=!1):i?(a&&r++,"*/"===m&&(a&&r++,i=!1,d++)):s?(r++,"`"===c&&"${"===m?(u.push("templateBrace"),s=!1,r++,d++):"\\"===p?(r++,d++):p===c&&(s=!1)):o?(r++,"\\"===p?(r++,d++):"["===p?l=!0:"]"===p&&l?l=!1:"/"!==p||l||(o=!1)):"/*"===m?(i=!0,(a="!"===e.charAt(d+2))&&(r+=2),d++):"//"===m&&t.singlelineComments?(n=!0,i=!1,a=!1,d++):"/"===p&&t.regex&&hasPunctuatorBefore(e,d)?(o=!0,r++):"{"===p&&u.length?(u.push("normalBrace"),
r++):"}"===p&&u.length?("templateBrace"===u[u.length-1]&&(s=!0,c="`"),u.pop(),r++):g?(s=!0,c=p,r++):h||r++}return i||s?e.length:r}t.exports={computeJSTokenLength:function computeJSTokenLength(e){return computeTokenLength(e,{singlelineComments:!0,regex:!0})},computeCSSTokenLength:function computeCSSTokenLength(e){return computeTokenLength(e,{singlelineComments:!1,regex:!1})}}},{}],89:[function(e,t,r){"use strict";const n=e("./network-request.js"),i=e("events").EventEmitter,a=e("lighthouse-logger"),s=["data","ws"];class NetworkRecorder extends i{constructor(){super(),this._records=[],this._recordsById=new Map}getInflightRecords(){return this._records.filter(e=>!e.finished)}getRecords(){return Array.from(this._records)}on(e,t){return super.on(e,t)}once(e,t){return super.once(e,t)}isIdle(){return this._isActiveIdlePeriod(0)}is2Idle(){return this._isActiveIdlePeriod(2)}_isActiveIdlePeriod(e){let t=0;for(let e=0;e<this._records.length;e++){const r=this._records[e]
;r.finished||(s.includes(r.parsedURL.scheme)||t++)}return t<=e}_emitNetworkStatus(){const e=this.isIdle(),t=this.is2Idle();t&&e?(a.verbose("NetworkRecorder","network fully-quiet"),this.emit("network-2-idle"),this.emit("networkidle")):t&&!e?(a.verbose("NetworkRecorder","network semi-quiet"),this.emit("network-2-idle"),this.emit("networkbusy")):(a.verbose("NetworkRecorder","network busy"),this.emit("network-2-busy"),this.emit("networkbusy"))}static findNetworkQuietPeriods(e,t,r=1/0){let n=[];e.forEach(e=>{const t=e.parsedURL&&e.parsedURL.scheme;s.includes(t)||(n.push({time:1e3*e.startTime,isStart:!0}),e.finished&&n.push({time:1e3*e.endTime,isStart:!1}))}),n=n.filter(e=>e.time<=r).sort((e,t)=>e.time-t.time);let i=0,a=0;const o=[];return n.forEach(e=>{e.isStart?(i===t&&o.push({start:a,end:e.time}),i++):--i===t&&(a=e.time)}),i<=t&&o.push({start:a,end:r}),o.filter(e=>e.start!==e.end)}onRequestStarted(e){this._records.push(e),this._recordsById.set(e.requestId,e),this.emit("requeststarted",e),
this._emitNetworkStatus()}onRequestFinished(e){this.emit("requestloaded",e),this._emitNetworkStatus()}onRequestWillBeSent(e){const t=e.params,r=this._findRealRequestAndSetSession(t.requestId,e.sessionId);if(!r){const r=new n;return r.onRequestWillBeSent(t),r.sessionId=e.sessionId,void this.onRequestStarted(r)}if(!t.redirectResponse)return;const i={...t,initiator:r.initiator,requestId:`${r.requestId}:redirect`},a=new n;a.onRequestWillBeSent(i),r.onRedirectResponse(t),r.redirectDestination=a,a.redirectSource=r,this.onRequestStarted(a),this.onRequestFinished(r)}onRequestServedFromCache(e){const t=e.params,r=this._findRealRequestAndSetSession(t.requestId,e.sessionId);r&&r.onRequestServedFromCache()}onResponseReceived(e){const t=e.params,r=this._findRealRequestAndSetSession(t.requestId,e.sessionId);r&&r.onResponseReceived(t)}onDataReceived(e){const t=e.params,r=this._findRealRequestAndSetSession(t.requestId,e.sessionId);r&&r.onDataReceived(t)}onLoadingFinished(e){
const t=e.params,r=this._findRealRequestAndSetSession(t.requestId,e.sessionId);r&&(r.onLoadingFinished(t),this.onRequestFinished(r))}onLoadingFailed(e){const t=e.params,r=this._findRealRequestAndSetSession(t.requestId,e.sessionId);r&&(r.onLoadingFailed(t),this.onRequestFinished(r))}onResourceChangedPriority(e){const t=e.params,r=this._findRealRequestAndSetSession(t.requestId,e.sessionId);r&&r.onResourceChangedPriority(t)}dispatch(e){switch(e.method){case"Network.requestWillBeSent":return this.onRequestWillBeSent(e);case"Network.requestServedFromCache":return this.onRequestServedFromCache(e);case"Network.responseReceived":return this.onResponseReceived(e);case"Network.dataReceived":return this.onDataReceived(e);case"Network.loadingFinished":return this.onLoadingFinished(e);case"Network.loadingFailed":return this.onLoadingFailed(e);case"Network.resourceChangedPriority":return this.onResourceChangedPriority(e);default:return}}_findRealRequestAndSetSession(e,t){
let r=this._recordsById.get(e);if(r&&r.isValid){for(;r.redirectDestination;)r=r.redirectDestination;return r.setSession(t),r}}static _chooseInitiator(e,t){if(e.redirectSource)return e.redirectSource;const r=e.initiator.stack&&e.initiator.stack.callFrames||[],i=e.initiator.url||r[0]&&r[0].url;let a=t.get(i)||[];if((a=a.filter(t=>t.responseReceivedTime<=e.startTime)).length>1){const e=a.filter(e=>e.resourceType!==n.TYPES.Other);e.length&&(a=e)}if(a.length>1){const t=a.filter(t=>t.frameId===e.frameId);t.length&&(a=t)}if(a.length>1&&"parser"===e.initiator.type){const e=a.filter(e=>e.resourceType===n.TYPES.Document);e.length&&(a=e)}return 1===a.length?a[0]:null}static recordsFromLogs(e){const t=new NetworkRecorder;e.forEach(e=>t.dispatch(e));const r=t.getRecords().filter(e=>e.isValid),n=new Map;for(const e of r){const t=n.get(e.url)||[];t.push(e),n.set(e.url,t)}for(const e of r){const t=NetworkRecorder._chooseInitiator(e,n);t&&e.setInitiatorRequest(t);let r=e
;for(;r.redirectDestination;)r=r.redirectDestination;if(r===e||r.redirects)continue;const i=[];for(let e=r.redirectSource;e;e=e.redirectSource)i.unshift(e);r.redirects=i}return r}}t.exports=NetworkRecorder},{"./network-request.js":90,events:124,"lighthouse-logger":141}],90:[function(e,t,r){(function(r){"use strict";const n=e("./url-shim.js"),i=["data","https","wss","blob","chrome","chrome-extension","about"],a="X-TCPMs",s="X-SSLMs",o="X-RequestMs",l="X-ResponseMs",c="X-TotalMs",u="X-TotalFetchedSize",d="X-ProtocolIsH2",m={XHR:"XHR",Fetch:"Fetch",EventSource:"EventSource",Script:"Script",Stylesheet:"Stylesheet",Image:"Image",Media:"Media",Font:"Font",Document:"Document",TextTrack:"TextTrack",WebSocket:"WebSocket",Other:"Other",Manifest:"Manifest",SignedExchange:"SignedExchange",Ping:"Ping",CSPViolationReport:"CSPViolationReport"};class NetworkRequest{constructor(){this.requestId="",this.connectionId="0",this.connectionReused=!1,this.url="",this.protocol="",this.isSecure=!1,
this.isValid=!1,this.parsedURL={scheme:""},this.documentURL="",this.startTime=-1,this.endTime=-1,this.responseReceivedTime=-1,this.transferSize=0,this.resourceSize=0,this.fromDiskCache=!1,this.fromMemoryCache=!1,this.lrStatistics=void 0,this.finished=!1,this.requestMethod="",this.statusCode=-1,this.redirectSource=void 0,this.redirectDestination=void 0,this.redirects=void 0,this.failed=!1,this.localizedFailDescription="",this.initiator={type:"other"},this.timing=void 0,this.resourceType=void 0,this.mimeType="",this.priority="Low",this.initiatorRequest=void 0,this.responseHeaders=[],this.responseHeadersText="",this.fetchedViaServiceWorker=!1,this.frameId="",this.sessionId=void 0,this.isLinkPreload=!1}hasErrorStatusCode(){return this.statusCode>=400}setInitiatorRequest(e){this.initiatorRequest=e}onRequestWillBeSent(e){let t;this.requestId=e.requestId;try{t=new n(e.request.url)}catch(e){return}this.url=e.request.url,this.documentURL=e.documentURL,this.parsedURL={
scheme:t.protocol.split(":")[0],host:t.hostname,securityOrigin:t.origin},this.isSecure=i.includes(this.parsedURL.scheme),this.startTime=e.timestamp,this.requestMethod=e.request.method,this.initiator=e.initiator,this.resourceType=e.type&&m[e.type],this.priority=e.request.initialPriority,this.frameId=e.frameId,this.isLinkPreload="preload"===e.initiator.type||!!e.request.isLinkPreload,this.isValid=!0}onRequestServedFromCache(){this.fromMemoryCache=!0}onResponseReceived(e){this._onResponse(e.response,e.timestamp,e.type),this._updateProtocolForLightrider(),this.frameId=e.frameId}onDataReceived(e){this.resourceSize+=e.dataLength,-1!==e.encodedDataLength&&(this.transferSize+=e.encodedDataLength)}onLoadingFinished(e){this.finished||(this.finished=!0,this.endTime=e.timestamp,e.encodedDataLength>=0&&(this.transferSize=e.encodedDataLength),this._updateResponseReceivedTimeIfNecessary(),this._updateTransferSizeForLightrider(),this._updateTimingsForLightrider())}onLoadingFailed(e){
this.finished||(this.finished=!0,this.endTime=e.timestamp,this.failed=!0,this.resourceType=e.type&&m[e.type],this.localizedFailDescription=e.errorText,this._updateResponseReceivedTimeIfNecessary(),this._updateTransferSizeForLightrider(),this._updateTimingsForLightrider())}onResourceChangedPriority(e){this.priority=e.newPriority}onRedirectResponse(e){if(!e.redirectResponse)throw new Error("Missing redirectResponse data");this._onResponse(e.redirectResponse,e.timestamp,e.type),this.resourceType=void 0,this.finished=!0,this.endTime=e.timestamp,this._updateResponseReceivedTimeIfNecessary()}setSession(e){this.sessionId=e}_onResponse(e,t,r){this.url=e.url,this.connectionId=String(e.connectionId),this.connectionReused=e.connectionReused,e.protocol&&(this.protocol=e.protocol),this.responseReceivedTime=t,this.transferSize=e.encodedDataLength,"boolean"==typeof e.fromDiskCache&&(this.fromDiskCache=e.fromDiskCache),this.statusCode=e.status,this.timing=e.timing,r&&(this.resourceType=m[r]),
this.mimeType=e.mimeType,this.responseHeadersText=e.headersText||"",this.responseHeaders=NetworkRequest._headersDictToHeadersArray(e.headers),this.fetchedViaServiceWorker=!!e.fromServiceWorker,this.fromMemoryCache&&(this.timing=void 0),this.timing&&this._recomputeTimesWithResourceTiming(this.timing)}_recomputeTimesWithResourceTiming(e){if(0===e.requestTime||-1===e.receiveHeadersEnd)return;this.startTime=e.requestTime;const t=e.requestTime+e.receiveHeadersEnd/1e3;(!this.responseReceivedTime||this.responseReceivedTime<0)&&(this.responseReceivedTime=t),this.responseReceivedTime=Math.min(this.responseReceivedTime,t),this.responseReceivedTime=Math.max(this.responseReceivedTime,this.startTime),this.endTime=Math.max(this.endTime,this.responseReceivedTime)}_updateResponseReceivedTimeIfNecessary(){this.responseReceivedTime=Math.min(this.endTime,this.responseReceivedTime)}_updateTransferSizeForLightrider(){if(!r.isLightrider)return;const e=this.responseHeaders.find(e=>e.name===u);if(!e)return
;const t=parseFloat(e.value);isNaN(t)||(this.transferSize=t)}_updateProtocolForLightrider(){r.isLightrider&&this.responseHeaders.some(e=>e.name===d)&&(this.protocol="h2")}_updateTimingsForLightrider(){if(!r.isLightrider)return;const e=this.responseHeaders.find(e=>e.name===c);if(!e)return;const t=parseInt(e.value),n=this.responseHeaders.find(e=>e.name===a),i=this.responseHeaders.find(e=>e.name===s),u=this.responseHeaders.find(e=>e.name===o),d=this.responseHeaders.find(e=>e.name===l),m=n?Math.max(0,parseInt(n.value)):0,p=i?Math.max(0,parseInt(i.value)):0,h=u?Math.max(0,parseInt(u.value)):0,g=d?Math.max(0,parseInt(d.value)):0;m+h+g===t&&(p>m||(this.lrStatistics={endTimeDeltaMs:1e3*(this.endTime-(this.startTime+t/1e3)),TCPMs:m,requestMs:h,responseMs:g}))}static getRequestIdForBackend(e){return e.replace(/(:redirect)+$/,"")}static _headersDictToHeadersArray(e){const t=[];for(const r of Object.keys(e)){const n=e[r].split("\n");for(let e=0;e<n.length;++e)t.push({name:r,value:n[e]})}return t}
static get TYPES(){return m}}NetworkRequest.HEADER_TCP=a,NetworkRequest.HEADER_SSL=s,NetworkRequest.HEADER_REQ=o,NetworkRequest.HEADER_RES=l,NetworkRequest.HEADER_TOTAL=c,NetworkRequest.HEADER_FETCHED_SIZE=u,NetworkRequest.HEADER_PROTOCOL_IS_H2=d,t.exports=NetworkRequest}).call(this,"undefined"!=typeof global?global:"undefined"!=typeof self?self:"undefined"!=typeof window?window:{})},{"./url-shim.js":"url"}],91:[function(e,t,r){"use strict";function getOuterHTMLSnippet(e,t=[],r=500){const n=["autofill-information","autofill-prediction","title"];try{e instanceof ShadowRoot&&(e=e.host);const i=e.cloneNode();t.concat(n).forEach(e=>{i.removeAttribute(e)});let a=0;for(const e of i.getAttributeNames())if(a>r)i.removeAttribute(e);else{let t=i.getAttribute(e);t.length>75&&(t=t.slice(0,74)+"…",i.setAttribute(e,t)),a+=e.length+t.length}const s=/^[\s\S]*?>/,[o]=i.outerHTML.match(s)||[];return o&&a>r?o.slice(0,o.length-1)+" …>":o||""}catch(t){return`<${e.localName}>`}}
function computeBenchmarkIndex(){return(function benchmarkIndexGC(){const e=Date.now();let t=0;for(;Date.now()-e<500;){let e="";for(let t=0;t<1e4;t++)e+="a";t++}const r=(Date.now()-e)/1e3;return Math.round(t/10/r)}()+function benchmarkIndexNoGC(){const e=[],t=[];for(let r=0;r<1e5;r++)e[r]=t[r]=r;const r=Date.now();let n=0;for(;n%10!=0||Date.now()-r<500;){const r=n%2==0?e:t,i=n%2==0?t:e;for(let e=0;e<r.length;e++)i[e]=r[e];n++}const i=(Date.now()-r)/1e3;return Math.round(n/10/i)}())/2}function getNodePath(e){const t=e=>e.nodeType===Node.DOCUMENT_FRAGMENT_NODE,r=e=>t(e)?e.host:e.parentNode;function getNodeIndex(e){if(t(e))return"a";let r,n=0;for(;r=e.previousSibling;)(e=r).nodeType===Node.TEXT_NODE&&0===e.nodeValue.trim().length||n++;return n}const n=[];for(;e&&r(e);){const t=getNodeIndex(e);n.push([t,e.nodeName]),e=r(e)}return n.reverse(),n.join(",")}function getNodeSelector(e){function getSelectorPart(e){let t=e.tagName.toLowerCase()
;return e.id?t+="#"+e.id:e.classList.length>0&&(t+="."+e.classList[0]),t}const t=[];for(;t.length<4&&(t.unshift(getSelectorPart(e)),e.parentElement)&&"HTML"!==(e=e.parentElement).tagName;);return t.join(" > ")}function getNodeLabel(e){const t=e.tagName.toLowerCase();if("html"!==t&&"body"!==t){const t=e.innerText||e.getAttribute("alt")||e.getAttribute("aria-label");if(t)return function truncate(e,t){return e.length<=t?e:e.slice(0,t-1)+"…"}(t,80);{const t=e.querySelector("[alt], [aria-label]");if(t)return getNodeLabel(t)}}return t}function getBoundingClientRect(e){const t=e.getBoundingClientRect();return{top:Math.round(t.top),bottom:Math.round(t.bottom),left:Math.round(t.left),right:Math.round(t.right),width:Math.round(t.width),height:Math.round(t.height)}}
const n=`function getNodeDetails(elem) {\n  ${getNodePath.toString()};\n  ${getNodeSelector.toString()};\n  ${getBoundingClientRect.toString()};\n  ${getOuterHTMLSnippet.toString()};\n  ${getNodeLabel.toString()};\n  return {\n    devtoolsNodePath: getNodePath(elem),\n    selector: getNodeSelector(elem),\n    boundingRect: getBoundingClientRect(elem),\n    snippet: getOuterHTMLSnippet(elem),\n    nodeLabel: getNodeLabel(elem),\n  };\n}`;t.exports={wrapRuntimeEvalErrorInBrowserString:function wrapRuntimeEvalErrorInBrowser(e){const t="string"==typeof(e=e||new Error)?e:"unknown error";return{__failedInBrowser:!0,name:e.name||"Error",message:e.message||t,stack:e.stack||(new Error).stack}}.toString(),registerPerformanceObserverInPageString:function registerPerformanceObserverInPage(){window.____lastLongTask=window.__perfNow();const e=new window.PerformanceObserver(e=>{const t=e.getEntries();for(const e of t)if("longtask"===e.entryType){const t=e.startTime+e.duration
;window.____lastLongTask=Math.max(window.____lastLongTask,t)}});e.observe({entryTypes:["longtask"]}),window.____lhPerformanceObserver=e}.toString(),checkTimeSinceLastLongTaskString:function checkTimeSinceLastLongTask(){return new window.__nativePromise(e=>{const t=window.__perfNow()+50;setTimeout(()=>{const r=window.__perfNow(),n=r-t<50?r-window.____lastLongTask:0;e(n)},50)})}.toString(),getElementsInDocumentString:function getElementsInDocument(e){const t=window.__ElementMatches||window.Element.prototype.matches,r=[],n=i=>{for(let a,s=0;a=i[s];++s)e&&!t.call(a,e)||r.push(a),a.shadowRoot&&n(a.shadowRoot.querySelectorAll("*"))};return n(document.querySelectorAll("*")),r}.toString(),getOuterHTMLSnippetString:getOuterHTMLSnippet.toString(),getOuterHTMLSnippet:getOuterHTMLSnippet,computeBenchmarkIndex:computeBenchmarkIndex,computeBenchmarkIndexString:computeBenchmarkIndex.toString(),getNodeDetailsString:n,getNodePathString:getNodePath.toString(),
getNodeSelectorString:getNodeSelector.toString(),getNodePath:getNodePath,getNodeSelector:getNodeSelector,getNodeLabel:getNodeLabel,getNodeLabelString:getNodeLabel.toString(),isPositionFixedString:function isPositionFixed(e){function getStyleAtt