import{RelatedIssue as t}from"../browser_sdk/browser_sdk.js";import{ParsedURL as e}from"../common/common.js";import{DataGrid as i}from"../data_grid/data_grid.js";import{i18n as s}from"../i18n/i18n.js";import{StringUtilities as a}from"../platform/platform.js";import{Cookie as o}from"../sdk/sdk.js";import{Widget as r,Tooltip as l,Icon as n}from"../ui/ui.js";const d={session:"Session",name:"Name",value:"Value",domain:"Domain",path:"Path",expiresMaxage:"Expires / Max-Age",size:"Size",httponly:"HttpOnly",secure:"Secure",samesite:"SameSite",priority:"Priority",editableCookies:"Editable Cookies",cookies:"Cookies",na:"N/A",showRequestsWithThisCookie:"Show Requests With This Cookie",showIssueAssociatedWithThis:"Show issue associated with this cookie"},u=s.registerUIStrings("cookie_table/CookiesTable.ts",d),c=s.getLocalizedString.bind(void 0,u),h=c(d.session);class b extends r.VBox{constructor(t,e,s,a,r){super(),this.registerRequiredCSS("cookie_table/cookiesTable.css",{enableLegacyPatching:!0}),this.element.classList.add("cookies-table"),this._saveCallback=e,this._refreshCallback=s,this._deleteCallback=r;const l=Boolean(e),n=[{id:o.Attributes.Name,title:c(d.name),sortable:!0,disclosure:l,sort:i.Order.Ascending,longText:!0,weight:24,editable:l},{id:o.Attributes.Value,title:c(d.value),sortable:!0,longText:!0,weight:34,editable:l},{id:o.Attributes.Domain,title:c(d.domain),sortable:!0,weight:7,editable:l},{id:o.Attributes.Path,title:c(d.path),sortable:!0,weight:7,editable:l},{id:o.Attributes.Expires,title:c(d.expiresMaxage),sortable:!0,weight:7,editable:l},{id:o.Attributes.Size,title:c(d.size),sortable:!0,align:i.Align.Right,weight:7},{id:o.Attributes.HttpOnly,title:c(d.httponly),sortable:!0,align:i.Align.Center,weight:7,dataType:i.DataType.Boolean,editable:l},{id:o.Attributes.Secure,title:c(d.secure),sortable:!0,align:i.Align.Center,weight:7,dataType:i.DataType.Boolean,editable:l},{id:o.Attributes.SameSite,title:c(d.samesite),sortable:!0,weight:7,editable:l},{id:o.Attributes.Priority,title:c(d.priority),sortable:!0,sort:i.Order.Descending,weight:7,editable:l}];this._dataGrid=l?new i.DataGridImpl({displayName:c(d.editableCookies),columns:n,editCallback:this._onUpdateCookie.bind(this),deleteCallback:this._onDeleteCookie.bind(this),refreshCallback:s}):new i.DataGridImpl({displayName:c(d.cookies),columns:n,editCallback:void 0,deleteCallback:void 0,refreshCallback:void 0}),this._dataGrid.setStriped(!0),this._dataGrid.setName("cookiesTable"),this._dataGrid.addEventListener(i.Events.SortingChanged,this._rebuildTable,this),this._dataGrid.setRowContextMenuCallback(this._populateContextMenu.bind(this)),t&&this._dataGrid.renderInline(),a&&this._dataGrid.addEventListener(i.Events.SelectedNode,a,this),this._lastEditedColumnId=null,this._dataGrid.asWidget().show(this.element),this._data=[],this._cookieDomain="",this._cookieToBlockedReasons=null}setCookies(t,e){this.setCookieFolders([{cookies:t,folderName:null}],e)}setCookieFolders(t,e){this._data=t,this._cookieToBlockedReasons=e||null,this._rebuildTable()}setCookieDomain(t){this._cookieDomain=t}selectedCookie(){const t=this._dataGrid.selectedNode;return t?t.cookie:null}_getSelectionCookies(){const t=this._dataGrid.selectedNode,e=t&&t.traverseNextNode(!0),i=t&&t.traversePreviousNode(!0);return{current:t&&t.cookie,neighbor:e&&e.cookie||i&&i.cookie}}willHide(){this._lastEditedColumnId=null}_findSelectedCookie(t,e){if(!e)return null;const i=t.current,s=e.find((t=>this._isSameCookie(t,i)));if(s)return s;const a=t.neighbor,o=e.find((t=>this._isSameCookie(t,a)));return o||null}_isSameCookie(t,e){return null!=e&&e.name()===t.name()&&e.domain()===t.domain()&&e.path()===t.path()}_rebuildTable(){const t=this._getSelectionCookies(),e=this._lastEditedColumnId;this._lastEditedColumnId=null,this._dataGrid.rootNode().removeChildren();for(let s=0;s<this._data.length;++s){const a=this._data[s],r=this._findSelectedCookie(t,a.cookies);if(a.folderName){const t={};t[o.Attributes.Name]=a.folderName,t[o.Attributes.Value]="",t[o.Attributes.Size]=this._totalSize(a.cookies),t[o.Attributes.Domain]="",t[o.Attributes.Path]="",t[o.Attributes.Expires]="",t[o.Attributes.HttpOnly]="",t[o.Attributes.Secure]="",t[o.Attributes.SameSite]="",t[o.Attributes.Priority]="";const s=new i.DataGridNode(t);s.selectable=!0,this._dataGrid.rootNode().appendChild(s),s.element().classList.add("row-group"),this._populateNode(s,a.cookies,r,e),s.expand()}else this._populateNode(this._dataGrid.rootNode(),a.cookies,r,e)}t.current&&e&&!this._dataGrid.selectedNode&&this._addInactiveNode(this._dataGrid.rootNode(),t.current,e),this._saveCallback&&this._dataGrid.addCreationNode(!1)}_populateNode(t,e,i,s){if(t.removeChildren(),e){this._sortCookies(e);for(let a=0;a<e.length;++a){const o=e[a],r=this._createGridNode(o);t.appendChild(r),this._isSameCookie(o,i)&&(r.select(),null!==s&&this._dataGrid.startEditingNextEditableColumnOfDataGridNode(r,s))}}}_addInactiveNode(t,e,i){const s=this._createGridNode(e);t.appendChild(s),s.select(),s.setInactive(!0),null!==i&&this._dataGrid.startEditingNextEditableColumnOfDataGridNode(s,i)}_totalSize(t){let e=0;for(let i=0;t&&i<t.length;++i)e+=t[i].size();return e}_sortCookies(t){const e=this._dataGrid.isSortOrderAscending()?1:-1;function i(t,e){switch(e){case o.Attributes.Name:return String(t.name());case o.Attributes.Value:return String(t.value());case o.Attributes.Domain:return String(t.domain());case o.Attributes.Path:return String(t.path());case o.Attributes.HttpOnly:return String(t.httpOnly());case o.Attributes.Secure:return String(t.secure());case o.Attributes.SameSite:return String(t.sameSite());default:return String(t.name())}}let s;const r=this._dataGrid.sortColumnId()||o.Attributes.Name;s=r===o.Attributes.Expires?function(t,i){return t.session()!==i.session()?e*(t.session()?1:-1):t.session()?0:t.maxAge()&&i.maxAge()?e*(t.maxAge()-i.maxAge()):t.expires()&&i.expires()?e*(t.expires()-i.expires()):e*(t.expires()?1:-1)}:r===o.Attributes.Size?function(t,i){return e*(t.size()-i.size())}:r===o.Attributes.Priority?function(t,i){const s=[Protocol.Network.CookiePriority.Low,Protocol.Network.CookiePriority.Medium,Protocol.Network.CookiePriority.High],a=s.indexOf(t.priority()),o=s.indexOf(i.priority());return e*(a-o)}:function(t,s,o){return e*a.compare(i(s,t),i(o,t))}.bind(null,r),t.sort(s)}_createGridNode(t){const e={};e[o.Attributes.Name]=t.name(),e[o.Attributes.Value]=t.value(),t.type()===o.Type.Request?(e[o.Attributes.Domain]=t.domain()?t.domain():c(d.na),e[o.Attributes.Path]=t.path()?t.path():c(d.na)):(e[o.Attributes.Domain]=t.domain()||"",e[o.Attributes.Path]=t.path()||""),t.maxAge()?e[o.Attributes.Expires]=Number.secondsToString(Math.floor(t.maxAge())):t.expires()?t.expires()<0?e[o.Attributes.Expires]=h:e[o.Attributes.Expires]=new Date(t.expires()).toISOString():e[o.Attributes.Expires]=t.type()===o.Type.Request?c(d.na):h,e[o.Attributes.Size]=t.size(),e[o.Attributes.HttpOnly]=t.httpOnly(),e[o.Attributes.Secure]=t.secure(),e[o.Attributes.SameSite]=t.sameSite()||"",e[o.Attributes.Priority]=t.priority()||"";const i=this._cookieToBlockedReasons?this._cookieToBlockedReasons.get(t):null,s=new m(e,t,i||null);return s.selectable=!0,s}_onDeleteCookie(t){t.cookie&&this._deleteCallback&&this._deleteCallback(t.cookie,(()=>this._refresh()))}_onUpdateCookie(t,e,i,s){this._lastEditedColumnId=e,this._setDefaults(t),this._isValidCookieData(t.data)?this._saveNode(t):t.setDirty(!0)}_setDefaults(t){null===t.data[o.Attributes.Name]&&(t.data[o.Attributes.Name]=""),null===t.data[o.Attributes.Value]&&(t.data[o.Attributes.Value]=""),null===t.data[o.Attributes.Domain]&&(t.data[o.Attributes.Domain]=this._cookieDomain),null===t.data[o.Attributes.Path]&&(t.data[o.Attributes.Path]="/"),null===t.data[o.Attributes.Expires]&&(t.data[o.Attributes.Expires]=h)}_saveNode(t){const e=t.cookie,i=this._createCookieFromData(t.data);t.cookie=i,this._saveCallback&&this._saveCallback(i,e).then((e=>{e?this._refresh():t.setDirty(!0)}))}_createCookieFromData(t){const e=new o.Cookie(t[o.Attributes.Name],t[o.Attributes.Value],null,t[o.Attributes.Priority]);return e.addAttribute(o.Attributes.Domain,t[o.Attributes.Domain]),e.addAttribute(o.Attributes.Path,t[o.Attributes.Path]),t.expires&&t.expires!==h&&e.addAttribute(o.Attributes.Expires,new Date(t[o.Attributes.Expires]).toUTCString()),t[o.Attributes.HttpOnly]&&e.addAttribute(o.Attributes.HttpOnly),t[o.Attributes.Secure]&&e.addAttribute(o.Attributes.Secure),t[o.Attributes.SameSite]&&e.addAttribute(o.Attributes.SameSite,t[o.Attributes.SameSite]),e.setSize(t[o.Attributes.Name].length+t[o.Attributes.Value].length),e}_isValidCookieData(t){return(Boolean(t.name)||Boolean(t.value))&&this._isValidDomain(t.domain)&&this._isValidPath(t.path)&&this._isValidDate(t.expires)}_isValidDomain(t){if(!t)return!0;const i=e.ParsedURL.fromString("http://"+t);return null!==i&&i.domain()===t}_isValidPath(t){const i=e.ParsedURL.fromString("http://example.com"+t);return null!==i&&i.path===t}_isValidDate(t){return""===t||t===h||!isNaN(Date.parse(t))}_refresh(){this._refreshCallback&&this._refreshCallback()}_populateContextMenu(e,i){const s=i.cookie;if(!s)return;const a=s;e.revealSection().appendItem(c(d.showRequestsWithThisCookie),(()=>{const t=new CustomEvent("networkrevealandfilter",{bubbles:!0,composed:!0,detail:[{filterType:"cookie-domain",filterValue:a.domain()},{filterType:"cookie-name",filterValue:a.name()}]});this.element.dispatchEvent(t)})),t.hasIssues(a)&&e.revealSection().appendItem(c(d.showIssueAssociatedWithThis),(()=>{t.reveal(a)}))}}class m extends i.DataGridNode{constructor(t,e,i){super(t),this.cookie=e,this._blockedReasons=i}createCells(t){super.createCells(t),this._blockedReasons&&this._blockedReasons.length&&t.classList.add("flagged-cookie-attribute-row")}createCell(t){const e=super.createCell(t);l.Tooltip.install(e,e.textContent||"");let i="";if(this._blockedReasons)for(const e of this._blockedReasons){const s=e.attribute===t,a=!e.attribute&&t===o.Attributes.Name;(s||a)&&(i&&(i+="\n"),i+=e.uiString)}if(i){const t=n.Icon.create("smallicon-info","cookie-warning-icon");l.Tooltip.install(t,i),e.insertBefore(t,e.firstChild),e.classList.add("flagged-cookie-attribute-cell")}return e}}var p=Object.freeze({__proto__:null,UIStrings:d,CookiesTable:b,DataGridNode:m});export{p as CookiesTable};
