/****************************************************************************
**
** Copyright (C) 2018 basysKom GmbH, opensource@basyskom.com
** Contact: http://www.qt.io/licensing/
**
** This file is part of the QtOpcUa module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL3$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see http://www.qt.io/terms-conditions. For further
** information use the contact form at http://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPLv3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or later as published by the Free
** Software Foundation and appearing in the file LICENSE.GPL included in
** the packaging of this file. Please review the following information to
** ensure the GNU General Public License version 2.0 requirements will be
** met: http://www.gnu.org/licenses/gpl-2.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#include "qopcuanodeids.h"

QT_BEGIN_NAMESPACE

/*!
    \namespace QOpcUa::NodeIds
    \inmodule QtOpcUa
    \inheaderfile QtOpcUa/qopcuanodeids.h
    \brief This namespace contains enums with known node ids.
*/

/*!
    \enum QOpcUa::NodeIds::Namespace0

    Contains all numeric node identifiers from namespace 0 defined in the OPC Foundation's
    \l {https://opcfoundation.org/UA/schemas/1.03/NodeIds.csv} {NodeIds.csv} file.

    The values in this enum follow the naming from the CSV file and can be converted between
    enum and node id string using \l QOpcUa::namespace0Id() and \l QOpcUa::namespace0IdFromNodeId().
    \l QOpcUa::namespace0IdName() provides a conversion from enum value to the name string from the CSV file.

    \code
    QScopedPointer<QOpcUaNode> rootNode(client->node(QOpcUa::namespace0Id(QOpcUa::NodeIds::RootFolder)));
    \endcode

    \value Unknown
    \value Boolean
    \value SByte
    \value Byte
    \value Int16
    \value UInt16
    \value Int32
    \value UInt32
    \value Int64
    \value UInt64
    \value Float
    \value Double
    \value String
    \value DateTime
    \value Guid
    \value ByteString
    \value XmlElement
    \value NodeId
    \value ExpandedNodeId
    \value StatusCode
    \value QualifiedName
    \value LocalizedText
    \value Structure
    \value DataValue
    \value BaseDataType
    \value DiagnosticInfo
    \value Number
    \value Integer
    \value UInteger
    \value Enumeration
    \value Image
    \value References
    \value NonHierarchicalReferences
    \value HierarchicalReferences
    \value HasChild
    \value Organizes
    \value HasEventSource
    \value HasModellingRule
    \value HasEncoding
    \value HasDescription
    \value HasTypeDefinition
    \value GeneratesEvent
    \value Aggregates
    \value HasSubtype
    \value HasProperty
    \value HasComponent
    \value HasNotifier
    \value HasOrderedComponent
    \value FromState
    \value ToState
    \value HasCause
    \value HasEffect
    \value HasHistoricalConfiguration
    \value BaseObjectType
    \value FolderType
    \value BaseVariableType
    \value BaseDataVariableType
    \value PropertyType
    \value DataTypeDescriptionType
    \value DataTypeDictionaryType
    \value DataTypeSystemType
    \value DataTypeEncodingType
    \value ModellingRuleType
    \value ModellingRule_Mandatory
    \value ModellingRule_MandatoryShared
    \value ModellingRule_Optional
    \value ModellingRule_ExposesItsArray
    \value RootFolder
    \value ObjectsFolder
    \value TypesFolder
    \value ViewsFolder
    \value ObjectTypesFolder
    \value VariableTypesFolder
    \value DataTypesFolder
    \value ReferenceTypesFolder
    \value XmlSchema_TypeSystem
    \value OPCBinarySchema_TypeSystem
    \value DataTypeDescriptionType_DataTypeVersion
    \value DataTypeDescriptionType_DictionaryFragment
    \value DataTypeDictionaryType_DataTypeVersion
    \value DataTypeDictionaryType_NamespaceUri
    \value ModellingRuleType_NamingRule
    \value ModellingRule_Mandatory_NamingRule
    \value ModellingRule_Optional_NamingRule
    \value ModellingRule_ExposesItsArray_NamingRule
    \value ModellingRule_MandatoryShared_NamingRule
    \value HasSubStateMachine
    \value NamingRuleType
    \value Decimal128
    \value IdType
    \value NodeClass
    \value Node
    \value Node_Encoding_DefaultXml
    \value Node_Encoding_DefaultBinary
    \value ObjectNode
    \value ObjectNode_Encoding_DefaultXml
    \value ObjectNode_Encoding_DefaultBinary
    \value ObjectTypeNode
    \value ObjectTypeNode_Encoding_DefaultXml
    \value ObjectTypeNode_Encoding_DefaultBinary
    \value VariableNode
    \value VariableNode_Encoding_DefaultXml
    \value VariableNode_Encoding_DefaultBinary
    \value VariableTypeNode
    \value VariableTypeNode_Encoding_DefaultXml
    \value VariableTypeNode_Encoding_DefaultBinary
    \value ReferenceTypeNode
    \value ReferenceTypeNode_Encoding_DefaultXml
    \value ReferenceTypeNode_Encoding_DefaultBinary
    \value MethodNode
    \value MethodNode_Encoding_DefaultXml
    \value MethodNode_Encoding_DefaultBinary
    \value ViewNode
    \value ViewNode_Encoding_DefaultXml
    \value ViewNode_Encoding_DefaultBinary
    \value DataTypeNode
    \value DataTypeNode_Encoding_DefaultXml
    \value DataTypeNode_Encoding_DefaultBinary
    \value ReferenceNode
    \value ReferenceNode_Encoding_DefaultXml
    \value ReferenceNode_Encoding_DefaultBinary
    \value IntegerId
    \value Counter
    \value Duration
    \value NumericRange
    \value Time
    \value Date
    \value UtcTime
    \value LocaleId
    \value Argument
    \value Argument_Encoding_DefaultXml
    \value Argument_Encoding_DefaultBinary
    \value StatusResult
    \value StatusResult_Encoding_DefaultXml
    \value StatusResult_Encoding_DefaultBinary
    \value MessageSecurityMode
    \value UserTokenType
    \value UserTokenPolicy
    \value UserTokenPolicy_Encoding_DefaultXml
    \value UserTokenPolicy_Encoding_DefaultBinary
    \value ApplicationType
    \value ApplicationDescription
    \value ApplicationDescription_Encoding_DefaultXml
    \value ApplicationDescription_Encoding_DefaultBinary
    \value ApplicationInstanceCertificate
    \value EndpointDescription
    \value EndpointDescription_Encoding_DefaultXml
    \value EndpointDescription_Encoding_DefaultBinary
    \value SecurityTokenRequestType
    \value UserIdentityToken
    \value UserIdentityToken_Encoding_DefaultXml
    \value UserIdentityToken_Encoding_DefaultBinary
    \value AnonymousIdentityToken
    \value AnonymousIdentityToken_Encoding_DefaultXml
    \value AnonymousIdentityToken_Encoding_DefaultBinary
    \value UserNameIdentityToken
    \value UserNameIdentityToken_Encoding_DefaultXml
    \value UserNameIdentityToken_Encoding_DefaultBinary
    \value X509IdentityToken
    \value X509IdentityToken_Encoding_DefaultXml
    \value X509IdentityToken_Encoding_DefaultBinary
    \value EndpointConfiguration
    \value EndpointConfiguration_Encoding_DefaultXml
    \value EndpointConfiguration_Encoding_DefaultBinary
    \value BuildInfo
    \value BuildInfo_Encoding_DefaultXml
    \value BuildInfo_Encoding_DefaultBinary
    \value SignedSoftwareCertificate
    \value SignedSoftwareCertificate_Encoding_DefaultXml
    \value SignedSoftwareCertificate_Encoding_DefaultBinary
    \value AttributeWriteMask
    \value NodeAttributesMask
    \value NodeAttributes
    \value NodeAttributes_Encoding_DefaultXml
    \value NodeAttributes_Encoding_DefaultBinary
    \value ObjectAttributes
    \value ObjectAttributes_Encoding_DefaultXml
    \value ObjectAttributes_Encoding_DefaultBinary
    \value VariableAttributes
    \value VariableAttributes_Encoding_DefaultXml
    \value VariableAttributes_Encoding_DefaultBinary
    \value MethodAttributes
    \value MethodAttributes_Encoding_DefaultXml
    \value MethodAttributes_Encoding_DefaultBinary
    \value ObjectTypeAttributes
    \value ObjectTypeAttributes_Encoding_DefaultXml
    \value ObjectTypeAttributes_Encoding_DefaultBinary
    \value VariableTypeAttributes
    \value VariableTypeAttributes_Encoding_DefaultXml
    \value VariableTypeAttributes_Encoding_DefaultBinary
    \value ReferenceTypeAttributes
    \value ReferenceTypeAttributes_Encoding_DefaultXml
    \value ReferenceTypeAttributes_Encoding_DefaultBinary
    \value DataTypeAttributes
    \value DataTypeAttributes_Encoding_DefaultXml
    \value DataTypeAttributes_Encoding_DefaultBinary
    \value ViewAttributes
    \value ViewAttributes_Encoding_DefaultXml
    \value ViewAttributes_Encoding_DefaultBinary
    \value AddNodesItem
    \value AddNodesItem_Encoding_DefaultXml
    \value AddNodesItem_Encoding_DefaultBinary
    \value AddReferencesItem
    \value AddReferencesItem_Encoding_DefaultXml
    \value AddReferencesItem_Encoding_DefaultBinary
    \value DeleteNodesItem
    \value DeleteNodesItem_Encoding_DefaultXml
    \value DeleteNodesItem_Encoding_DefaultBinary
    \value DeleteReferencesItem
    \value DeleteReferencesItem_Encoding_DefaultXml
    \value DeleteReferencesItem_Encoding_DefaultBinary
    \value SessionAuthenticationToken
    \value RequestHeader
    \value RequestHeader_Encoding_DefaultXml
    \value RequestHeader_Encoding_DefaultBinary
    \value ResponseHeader
    \value ResponseHeader_Encoding_DefaultXml
    \value ResponseHeader_Encoding_DefaultBinary
    \value ServiceFault
    \value ServiceFault_Encoding_DefaultXml
    \value ServiceFault_Encoding_DefaultBinary
    \value FindServersRequest
    \value FindServersRequest_Encoding_DefaultXml
    \value FindServersRequest_Encoding_DefaultBinary
    \value FindServersResponse
    \value FindServersResponse_Encoding_DefaultXml
    \value FindServersResponse_Encoding_DefaultBinary
    \value GetEndpointsRequest
    \value GetEndpointsRequest_Encoding_DefaultXml
    \value GetEndpointsRequest_Encoding_DefaultBinary
    \value GetEndpointsResponse
    \value GetEndpointsResponse_Encoding_DefaultXml
    \value GetEndpointsResponse_Encoding_DefaultBinary
    \value RegisteredServer
    \value RegisteredServer_Encoding_DefaultXml
    \value RegisteredServer_Encoding_DefaultBinary
    \value RegisterServerRequest
    \value RegisterServerRequest_Encoding_DefaultXml
    \value RegisterServerRequest_Encoding_DefaultBinary
    \value RegisterServerResponse
    \value RegisterServerResponse_Encoding_DefaultXml
    \value RegisterServerResponse_Encoding_DefaultBinary
    \value ChannelSecurityToken
    \value ChannelSecurityToken_Encoding_DefaultXml
    \value ChannelSecurityToken_Encoding_DefaultBinary
    \value OpenSecureChannelRequest
    \value OpenSecureChannelRequest_Encoding_DefaultXml
    \value OpenSecureChannelRequest_Encoding_DefaultBinary
    \value OpenSecureChannelResponse
    \value OpenSecureChannelResponse_Encoding_DefaultXml
    \value OpenSecureChannelResponse_Encoding_DefaultBinary
    \value CloseSecureChannelRequest
    \value CloseSecureChannelRequest_Encoding_DefaultXml
    \value CloseSecureChannelRequest_Encoding_DefaultBinary
    \value CloseSecureChannelResponse
    \value CloseSecureChannelResponse_Encoding_DefaultXml
    \value CloseSecureChannelResponse_Encoding_DefaultBinary
    \value SignatureData
    \value SignatureData_Encoding_DefaultXml
    \value SignatureData_Encoding_DefaultBinary
    \value CreateSessionRequest
    \value CreateSessionRequest_Encoding_DefaultXml
    \value CreateSessionRequest_Encoding_DefaultBinary
    \value CreateSessionResponse
    \value CreateSessionResponse_Encoding_DefaultXml
    \value CreateSessionResponse_Encoding_DefaultBinary
    \value ActivateSessionRequest
    \value ActivateSessionRequest_Encoding_DefaultXml
    \value ActivateSessionRequest_Encoding_DefaultBinary
    \value ActivateSessionResponse
    \value ActivateSessionResponse_Encoding_DefaultXml
    \value ActivateSessionResponse_Encoding_DefaultBinary
    \value CloseSessionRequest
    \value CloseSessionRequest_Encoding_DefaultXml
    \value CloseSessionRequest_Encoding_DefaultBinary
    \value CloseSessionResponse
    \value CloseSessionResponse_Encoding_DefaultXml
    \value CloseSessionResponse_Encoding_DefaultBinary
    \value CancelRequest
    \value CancelRequest_Encoding_DefaultXml
    \value CancelRequest_Encoding_DefaultBinary
    \value CancelResponse
    \value CancelResponse_Encoding_DefaultXml
    \value CancelResponse_Encoding_DefaultBinary
    \value AddNodesResult
    \value AddNodesResult_Encoding_DefaultXml
    \value AddNodesResult_Encoding_DefaultBinary
    \value AddNodesRequest
    \value AddNodesRequest_Encoding_DefaultXml
    \value AddNodesRequest_Encoding_DefaultBinary
    \value AddNodesResponse
    \value AddNodesResponse_Encoding_DefaultXml
    \value AddNodesResponse_Encoding_DefaultBinary
    \value AddReferencesRequest
    \value AddReferencesRequest_Encoding_DefaultXml
    \value AddReferencesRequest_Encoding_DefaultBinary
    \value AddReferencesResponse
    \value AddReferencesResponse_Encoding_DefaultXml
    \value AddReferencesResponse_Encoding_DefaultBinary
    \value DeleteNodesRequest
    \value DeleteNodesRequest_Encoding_DefaultXml
    \value DeleteNodesRequest_Encoding_DefaultBinary
    \value DeleteNodesResponse
    \value DeleteNodesResponse_Encoding_DefaultXml
    \value DeleteNodesResponse_Encoding_DefaultBinary
    \value DeleteReferencesRequest
    \value DeleteReferencesRequest_Encoding_DefaultXml
    \value DeleteReferencesRequest_Encoding_DefaultBinary
    \value DeleteReferencesResponse
    \value DeleteReferencesResponse_Encoding_DefaultXml
    \value DeleteReferencesResponse_Encoding_DefaultBinary
    \value BrowseDirection
    \value ViewDescription
    \value ViewDescription_Encoding_DefaultXml
    \value ViewDescription_Encoding_DefaultBinary
    \value BrowseDescription
    \value BrowseDescription_Encoding_DefaultXml
    \value BrowseDescription_Encoding_DefaultBinary
    \value BrowseResultMask
    \value ReferenceDescription
    \value ReferenceDescription_Encoding_DefaultXml
    \value ReferenceDescription_Encoding_DefaultBinary
    \value ContinuationPoint
    \value BrowseResult
    \value BrowseResult_Encoding_DefaultXml
    \value BrowseResult_Encoding_DefaultBinary
    \value BrowseRequest
    \value BrowseRequest_Encoding_DefaultXml
    \value BrowseRequest_Encoding_DefaultBinary
    \value BrowseResponse
    \value BrowseResponse_Encoding_DefaultXml
    \value BrowseResponse_Encoding_DefaultBinary
    \value BrowseNextRequest
    \value BrowseNextRequest_Encoding_DefaultXml
    \value BrowseNextRequest_Encoding_DefaultBinary
    \value BrowseNextResponse
    \value BrowseNextResponse_Encoding_DefaultXml
    \value BrowseNextResponse_Encoding_DefaultBinary
    \value RelativePathElement
    \value RelativePathElement_Encoding_DefaultXml
    \value RelativePathElement_Encoding_DefaultBinary
    \value RelativePath
    \value RelativePath_Encoding_DefaultXml
    \value RelativePath_Encoding_DefaultBinary
    \value BrowsePath
    \value BrowsePath_Encoding_DefaultXml
    \value BrowsePath_Encoding_DefaultBinary
    \value BrowsePathTarget
    \value BrowsePathTarget_Encoding_DefaultXml
    \value BrowsePathTarget_Encoding_DefaultBinary
    \value BrowsePathResult
    \value BrowsePathResult_Encoding_DefaultXml
    \value BrowsePathResult_Encoding_DefaultBinary
    \value TranslateBrowsePathsToNodeIdsRequest
    \value TranslateBrowsePathsToNodeIdsRequest_Encoding_DefaultXml
    \value TranslateBrowsePathsToNodeIdsRequest_Encoding_DefaultBinary
    \value TranslateBrowsePathsToNodeIdsResponse
    \value TranslateBrowsePathsToNodeIdsResponse_Encoding_DefaultXml
    \value TranslateBrowsePathsToNodeIdsResponse_Encoding_DefaultBinary
    \value RegisterNodesRequest
    \value RegisterNodesRequest_Encoding_DefaultXml
    \value RegisterNodesRequest_Encoding_DefaultBinary
    \value RegisterNodesResponse
    \value RegisterNodesResponse_Encoding_DefaultXml
    \value RegisterNodesResponse_Encoding_DefaultBinary
    \value UnregisterNodesRequest
    \value UnregisterNodesRequest_Encoding_DefaultXml
    \value UnregisterNodesRequest_Encoding_DefaultBinary
    \value UnregisterNodesResponse
    \value UnregisterNodesResponse_Encoding_DefaultXml
    \value UnregisterNodesResponse_Encoding_DefaultBinary
    \value QueryDataDescription
    \value QueryDataDescription_Encoding_DefaultXml
    \value QueryDataDescription_Encoding_DefaultBinary
    \value NodeTypeDescription
    \value NodeTypeDescription_Encoding_DefaultXml
    \value NodeTypeDescription_Encoding_DefaultBinary
    \value FilterOperator
    \value QueryDataSet
    \value QueryDataSet_Encoding_DefaultXml
    \value QueryDataSet_Encoding_DefaultBinary
    \value NodeReference
    \value NodeReference_Encoding_DefaultXml
    \value NodeReference_Encoding_DefaultBinary
    \value ContentFilterElement
    \value ContentFilterElement_Encoding_DefaultXml
    \value ContentFilterElement_Encoding_DefaultBinary
    \value ContentFilter
    \value ContentFilter_Encoding_DefaultXml
    \value ContentFilter_Encoding_DefaultBinary
    \value FilterOperand
    \value FilterOperand_Encoding_DefaultXml
    \value FilterOperand_Encoding_DefaultBinary
    \value ElementOperand
    \value ElementOperand_Encoding_DefaultXml
    \value ElementOperand_Encoding_DefaultBinary
    \value LiteralOperand
    \value LiteralOperand_Encoding_DefaultXml
    \value LiteralOperand_Encoding_DefaultBinary
    \value AttributeOperand
    \value AttributeOperand_Encoding_DefaultXml
    \value AttributeOperand_Encoding_DefaultBinary
    \value SimpleAttributeOperand
    \value SimpleAttributeOperand_Encoding_DefaultXml
    \value SimpleAttributeOperand_Encoding_DefaultBinary
    \value ContentFilterElementResult
    \value ContentFilterElementResult_Encoding_DefaultXml
    \value ContentFilterElementResult_Encoding_DefaultBinary
    \value ContentFilterResult
    \value ContentFilterResult_Encoding_DefaultXml
    \value ContentFilterResult_Encoding_DefaultBinary
    \value ParsingResult
    \value ParsingResult_Encoding_DefaultXml
    \value ParsingResult_Encoding_DefaultBinary
    \value QueryFirstRequest
    \value QueryFirstRequest_Encoding_DefaultXml
    \value QueryFirstRequest_Encoding_DefaultBinary
    \value QueryFirstResponse
    \value QueryFirstResponse_Encoding_DefaultXml
    \value QueryFirstResponse_Encoding_DefaultBinary
    \value QueryNextRequest
    \value QueryNextRequest_Encoding_DefaultXml
    \value QueryNextRequest_Encoding_DefaultBinary
    \value QueryNextResponse
    \value QueryNextResponse_Encoding_DefaultXml
    \value QueryNextResponse_Encoding_DefaultBinary
    \value TimestampsToReturn
    \value ReadValueId
    \value ReadValueId_Encoding_DefaultXml
    \value ReadValueId_Encoding_DefaultBinary
    \value ReadRequest
    \value ReadRequest_Encoding_DefaultXml
    \value ReadRequest_Encoding_DefaultBinary
    \value ReadResponse
    \value ReadResponse_Encoding_DefaultXml
    \value ReadResponse_Encoding_DefaultBinary
    \value HistoryReadValueId
    \value HistoryReadValueId_Encoding_DefaultXml
    \value HistoryReadValueId_Encoding_DefaultBinary
    \value HistoryReadResult
    \value HistoryReadResult_Encoding_DefaultXml
    \value HistoryReadResult_Encoding_DefaultBinary
    \value HistoryReadDetails
    \value HistoryReadDetails_Encoding_DefaultXml
    \value HistoryReadDetails_Encoding_DefaultBinary
    \value ReadEventDetails
    \value ReadEventDetails_Encoding_DefaultXml
    \value ReadEventDetails_Encoding_DefaultBinary
    \value ReadRawModifiedDetails
    \value ReadRawModifiedDetails_Encoding_DefaultXml
    \value ReadRawModifiedDetails_Encoding_DefaultBinary
    \value ReadProcessedDetails
    \value ReadProcessedDetails_Encoding_DefaultXml
    \value ReadProcessedDetails_Encoding_DefaultBinary
    \value ReadAtTimeDetails
    \value ReadAtTimeDetails_Encoding_DefaultXml
    \value ReadAtTimeDetails_Encoding_DefaultBinary
    \value HistoryData
    \value HistoryData_Encoding_DefaultXml
    \value HistoryData_Encoding_DefaultBinary
    \value HistoryEvent
    \value HistoryEvent_Encoding_DefaultXml
    \value HistoryEvent_Encoding_DefaultBinary
    \value HistoryReadRequest
    \value HistoryReadRequest_Encoding_DefaultXml
    \value HistoryReadRequest_Encoding_DefaultBinary
    \value HistoryReadResponse
    \value HistoryReadResponse_Encoding_DefaultXml
    \value HistoryReadResponse_Encoding_DefaultBinary
    \value WriteValue
    \value WriteValue_Encoding_DefaultXml
    \value WriteValue_Encoding_DefaultBinary
    \value WriteRequest
    \value WriteRequest_Encoding_DefaultXml
    \value WriteRequest_Encoding_DefaultBinary
    \value WriteResponse
    \value WriteResponse_Encoding_DefaultXml
    \value WriteResponse_Encoding_DefaultBinary
    \value HistoryUpdateDetails
    \value HistoryUpdateDetails_Encoding_DefaultXml
    \value HistoryUpdateDetails_Encoding_DefaultBinary
    \value UpdateDataDetails
    \value UpdateDataDetails_Encoding_DefaultXml
    \value UpdateDataDetails_Encoding_DefaultBinary
    \value UpdateEventDetails
    \value UpdateEventDetails_Encoding_DefaultXml
    \value UpdateEventDetails_Encoding_DefaultBinary
    \value DeleteRawModifiedDetails
    \value DeleteRawModifiedDetails_Encoding_DefaultXml
    \value DeleteRawModifiedDetails_Encoding_DefaultBinary
    \value DeleteAtTimeDetails
    \value DeleteAtTimeDetails_Encoding_DefaultXml
    \value DeleteAtTimeDetails_Encoding_DefaultBinary
    \value DeleteEventDetails
    \value DeleteEventDetails_Encoding_DefaultXml
    \value DeleteEventDetails_Encoding_DefaultBinary
    \value HistoryUpdateResult
    \value HistoryUpdateResult_Encoding_DefaultXml
    \value HistoryUpdateResult_Encoding_DefaultBinary
    \value HistoryUpdateRequest
    \value HistoryUpdateRequest_Encoding_DefaultXml
    \value HistoryUpdateRequest_Encoding_DefaultBinary
    \value HistoryUpdateResponse
    \value HistoryUpdateResponse_Encoding_DefaultXml
    \value HistoryUpdateResponse_Encoding_DefaultBinary
    \value CallMethodRequest
    \value CallMethodRequest_Encoding_DefaultXml
    \value CallMethodRequest_Encoding_DefaultBinary
    \value CallMethodResult
    \value CallMethodResult_Encoding_DefaultXml
    \value CallMethodResult_Encoding_DefaultBinary
    \value CallRequest
    \value CallRequest_Encoding_DefaultXml
    \value CallRequest_Encoding_DefaultBinary
    \value CallResponse
    \value CallResponse_Encoding_DefaultXml
    \value CallResponse_Encoding_DefaultBinary
    \value MonitoringMode
    \value DataChangeTrigger
    \value DeadbandType
    \value MonitoringFilter
    \value MonitoringFilter_Encoding_DefaultXml
    \value MonitoringFilter_Encoding_DefaultBinary
    \value DataChangeFilter
    \value DataChangeFilter_Encoding_DefaultXml
    \value DataChangeFilter_Encoding_DefaultBinary
    \value EventFilter
    \value EventFilter_Encoding_DefaultXml
    \value EventFilter_Encoding_DefaultBinary
    \value AggregateFilter
    \value AggregateFilter_Encoding_DefaultXml
    \value AggregateFilter_Encoding_DefaultBinary
    \value MonitoringFilterResult
    \value MonitoringFilterResult_Encoding_DefaultXml
    \value MonitoringFilterResult_Encoding_DefaultBinary
    \value EventFilterResult
    \value EventFilterResult_Encoding_DefaultXml
    \value EventFilterResult_Encoding_DefaultBinary
    \value AggregateFilterResult
    \value AggregateFilterResult_Encoding_DefaultXml
    \value AggregateFilterResult_Encoding_DefaultBinary
    \value MonitoringParameters
    \value MonitoringParameters_Encoding_DefaultXml
    \value MonitoringParameters_Encoding_DefaultBinary
    \value MonitoredItemCreateRequest
    \value MonitoredItemCreateRequest_Encoding_DefaultXml
    \value MonitoredItemCreateRequest_Encoding_DefaultBinary
    \value MonitoredItemCreateResult
    \value MonitoredItemCreateResult_Encoding_DefaultXml
    \value MonitoredItemCreateResult_Encoding_DefaultBinary
    \value CreateMonitoredItemsRequest
    \value CreateMonitoredItemsRequest_Encoding_DefaultXml
    \value CreateMonitoredItemsRequest_Encoding_DefaultBinary
    \value CreateMonitoredItemsResponse
    \value CreateMonitoredItemsResponse_Encoding_DefaultXml
    \value CreateMonitoredItemsResponse_Encoding_DefaultBinary
    \value MonitoredItemModifyRequest
    \value MonitoredItemModifyRequest_Encoding_DefaultXml
    \value MonitoredItemModifyRequest_Encoding_DefaultBinary
    \value MonitoredItemModifyResult
    \value MonitoredItemModifyResult_Encoding_DefaultXml
    \value MonitoredItemModifyResult_Encoding_DefaultBinary
    \value ModifyMonitoredItemsRequest
    \value ModifyMonitoredItemsRequest_Encoding_DefaultXml
    \value ModifyMonitoredItemsRequest_Encoding_DefaultBinary
    \value ModifyMonitoredItemsResponse
    \value ModifyMonitoredItemsResponse_Encoding_DefaultXml
    \value ModifyMonitoredItemsResponse_Encoding_DefaultBinary
    \value SetMonitoringModeRequest
    \value SetMonitoringModeRequest_Encoding_DefaultXml
    \value SetMonitoringModeRequest_Encoding_DefaultBinary
    \value SetMonitoringModeResponse
    \value SetMonitoringModeResponse_Encoding_DefaultXml
    \value SetMonitoringModeResponse_Encoding_DefaultBinary
    \value SetTriggeringRequest
    \value SetTriggeringRequest_Encoding_DefaultXml
    \value SetTriggeringRequest_Encoding_DefaultBinary
    \value SetTriggeringResponse
    \value SetTriggeringResponse_Encoding_DefaultXml
    \value SetTriggeringResponse_Encoding_DefaultBinary
    \value DeleteMonitoredItemsRequest
    \value DeleteMonitoredItemsRequest_Encoding_DefaultXml
    \value DeleteMonitoredItemsRequest_Encoding_DefaultBinary
    \value DeleteMonitoredItemsResponse
    \value DeleteMonitoredItemsResponse_Encoding_DefaultXml
    \value DeleteMonitoredItemsResponse_Encoding_DefaultBinary
    \value CreateSubscriptionRequest
    \value CreateSubscriptionRequest_Encoding_DefaultXml
    \value CreateSubscriptionRequest_Encoding_DefaultBinary
    \value CreateSubscriptionResponse
    \value CreateSubscriptionResponse_Encoding_DefaultXml
    \value CreateSubscriptionResponse_Encoding_DefaultBinary
    \value ModifySubscriptionRequest
    \value ModifySubscriptionRequest_Encoding_DefaultXml
    \value ModifySubscriptionRequest_Encoding_DefaultBinary
    \value ModifySubscriptionResponse
    \value ModifySubscriptionResponse_Encoding_DefaultXml
    \value ModifySubscriptionResponse_Encoding_DefaultBinary
    \value SetPublishingModeRequest
    \value SetPublishingModeRequest_Encoding_DefaultXml
    \value SetPublishingModeRequest_Encoding_DefaultBinary
    \value SetPublishingModeResponse
    \value SetPublishingModeResponse_Encoding_DefaultXml
    \value SetPublishingModeResponse_Encoding_DefaultBinary
    \value NotificationMessage
    \value NotificationMessage_Encoding_DefaultXml
    \value NotificationMessage_Encoding_DefaultBinary
    \value MonitoredItemNotification
    \value MonitoredItemNotification_Encoding_DefaultXml
    \value MonitoredItemNotification_Encoding_DefaultBinary
    \value DataChangeNotification
    \value DataChangeNotification_Encoding_DefaultXml
    \value DataChangeNotification_Encoding_DefaultBinary
    \value StatusChangeNotification
    \value StatusChangeNotification_Encoding_DefaultXml
    \value StatusChangeNotification_Encoding_DefaultBinary
    \value SubscriptionAcknowledgement
    \value SubscriptionAcknowledgement_Encoding_DefaultXml
    \value SubscriptionAcknowledgement_Encoding_DefaultBinary
    \value PublishRequest
    \value PublishRequest_Encoding_DefaultXml
    \value PublishRequest_Encoding_DefaultBinary
    \value PublishResponse
    \value PublishResponse_Encoding_DefaultXml
    \value PublishResponse_Encoding_DefaultBinary
    \value RepublishRequest
    \value RepublishRequest_Encoding_DefaultXml
    \value RepublishRequest_Encoding_DefaultBinary
    \value RepublishResponse
    \value RepublishResponse_Encoding_DefaultXml
    \value RepublishResponse_Encoding_DefaultBinary
    \value TransferResult
    \value TransferResult_Encoding_DefaultXml
    \value TransferResult_Encoding_DefaultBinary
    \value TransferSubscriptionsRequest
    \value TransferSubscriptionsRequest_Encoding_DefaultXml
    \value TransferSubscriptionsRequest_Encoding_DefaultBinary
    \value TransferSubscriptionsResponse
    \value TransferSubscriptionsResponse_Encoding_DefaultXml
    \value TransferSubscriptionsResponse_Encoding_DefaultBinary
    \value DeleteSubscriptionsRequest
    \value DeleteSubscriptionsRequest_Encoding_DefaultXml
    \value DeleteSubscriptionsRequest_Encoding_DefaultBinary
    \value DeleteSubscriptionsResponse
    \value DeleteSubscriptionsResponse_Encoding_DefaultXml
    \value DeleteSubscriptionsResponse_Encoding_DefaultBinary
    \value RedundancySupport
    \value ServerState
    \value RedundantServerDataType
    \value RedundantServerDataType_Encoding_DefaultXml
    \value RedundantServerDataType_Encoding_DefaultBinary
    \value SamplingIntervalDiagnosticsDataType
    \value SamplingIntervalDiagnosticsDataType_Encoding_DefaultXml
    \value SamplingIntervalDiagnosticsDataType_Encoding_DefaultBinary
    \value ServerDiagnosticsSummaryDataType
    \value ServerDiagnosticsSummaryDataType_Encoding_DefaultXml
    \value ServerDiagnosticsSummaryDataType_Encoding_DefaultBinary
    \value ServerStatusDataType
    \value ServerStatusDataType_Encoding_DefaultXml
    \value ServerStatusDataType_Encoding_DefaultBinary
    \value SessionDiagnosticsDataType
    \value SessionDiagnosticsDataType_Encoding_DefaultXml
    \value SessionDiagnosticsDataType_Encoding_DefaultBinary
    \value SessionSecurityDiagnosticsDataType
    \value SessionSecurityDiagnosticsDataType_Encoding_DefaultXml
    \value SessionSecurityDiagnosticsDataType_Encoding_DefaultBinary
    \value ServiceCounterDataType
    \value ServiceCounterDataType_Encoding_DefaultXml
    \value ServiceCounterDataType_Encoding_DefaultBinary
    \value SubscriptionDiagnosticsDataType
    \value SubscriptionDiagnosticsDataType_Encoding_DefaultXml
    \value SubscriptionDiagnosticsDataType_Encoding_DefaultBinary
    \value ModelChangeStructureDataType
    \value ModelChangeStructureDataType_Encoding_DefaultXml
    \value ModelChangeStructureDataType_Encoding_DefaultBinary
    \value Range
    \value Range_Encoding_DefaultXml
    \value Range_Encoding_DefaultBinary
    \value EUInformation
    \value EUInformation_Encoding_DefaultXml
    \value EUInformation_Encoding_DefaultBinary
    \value ExceptionDeviationFormat
    \value Annotation
    \value Annotation_Encoding_DefaultXml
    \value Annotation_Encoding_DefaultBinary
    \value ProgramDiagnosticDataType
    \value ProgramDiagnosticDataType_Encoding_DefaultXml
    \value ProgramDiagnosticDataType_Encoding_DefaultBinary
    \value SemanticChangeStructureDataType
    \value SemanticChangeStructureDataType_Encoding_DefaultXml
    \value SemanticChangeStructureDataType_Encoding_DefaultBinary
    \value EventNotificationList
    \value EventNotificationList_Encoding_DefaultXml
    \value EventNotificationList_Encoding_DefaultBinary
    \value EventFieldList
    \value EventFieldList_Encoding_DefaultXml
    \value EventFieldList_Encoding_DefaultBinary
    \value HistoryEventFieldList
    \value HistoryEventFieldList_Encoding_DefaultXml
    \value HistoryEventFieldList_Encoding_DefaultBinary
    \value IssuedIdentityToken
    \value IssuedIdentityToken_Encoding_DefaultXml
    \value IssuedIdentityToken_Encoding_DefaultBinary
    \value NotificationData
    \value NotificationData_Encoding_DefaultXml
    \value NotificationData_Encoding_DefaultBinary
    \value AggregateConfiguration
    \value AggregateConfiguration_Encoding_DefaultXml
    \value AggregateConfiguration_Encoding_DefaultBinary
    \value ImageBMP
    \value ImageGIF
    \value ImageJPG
    \value ImagePNG
    \value ServerType
    \value ServerType_ServerArray
    \value ServerType_NamespaceArray
    \value ServerType_ServerStatus
    \value ServerType_ServiceLevel
    \value ServerType_ServerCapabilities
    \value ServerType_ServerDiagnostics
    \value ServerType_VendorServerInfo
    \value ServerType_ServerRedundancy
    \value ServerCapabilitiesType
    \value ServerCapabilitiesType_ServerProfileArray
    \value ServerCapabilitiesType_LocaleIdArray
    \value ServerCapabilitiesType_MinSupportedSampleRate
    \value ServerCapabilitiesType_ModellingRules
    \value ServerDiagnosticsType
    \value ServerDiagnosticsType_ServerDiagnosticsSummary
    \value ServerDiagnosticsType_SamplingIntervalDiagnosticsArray
    \value ServerDiagnosticsType_SubscriptionDiagnosticsArray
    \value ServerDiagnosticsType_EnabledFlag
    \value SessionsDiagnosticsSummaryType
    \value SessionsDiagnosticsSummaryType_SessionDiagnosticsArray
    \value SessionsDiagnosticsSummaryType_SessionSecurityDiagnosticsArray
    \value SessionDiagnosticsObjectType
    \value SessionDiagnosticsObjectType_SessionDiagnostics
    \value SessionDiagnosticsObjectType_SessionSecurityDiagnostics
    \value SessionDiagnosticsObjectType_SubscriptionDiagnosticsArray
    \value VendorServerInfoType
    \value ServerRedundancyType
    \value ServerRedundancyType_RedundancySupport
    \value TransparentRedundancyType
    \value TransparentRedundancyType_CurrentServerId
    \value TransparentRedundancyType_RedundantServerArray
    \value NonTransparentRedundancyType
    \value NonTransparentRedundancyType_ServerUriArray
    \value BaseEventType
    \value BaseEventType_EventId
    \value BaseEventType_EventType
    \value BaseEventType_SourceNode
    \value BaseEventType_SourceName
    \value BaseEventType_Time
    \value BaseEventType_ReceiveTime
    \value BaseEventType_Message
    \value BaseEventType_Severity
    \value AuditEventType
    \value AuditEventType_ActionTimeStamp
    \value AuditEventType_Status
    \value AuditEventType_ServerId
    \value AuditEventType_ClientAuditEntryId
    \value AuditEventType_ClientUserId
    \value AuditSecurityEventType
    \value AuditChannelEventType
    \value AuditOpenSecureChannelEventType
    \value AuditOpenSecureChannelEventType_ClientCertificate
    \value AuditOpenSecureChannelEventType_RequestType
    \value AuditOpenSecureChannelEventType_SecurityPolicyUri
    \value AuditOpenSecureChannelEventType_SecurityMode
    \value AuditOpenSecureChannelEventType_RequestedLifetime
    \value AuditSessionEventType
    \value AuditSessionEventType_SessionId
    \value AuditCreateSessionEventType
    \value AuditCreateSessionEventType_SecureChannelId
    \value AuditCreateSessionEventType_ClientCertificate
    \value AuditCreateSessionEventType_RevisedSessionTimeout
    \value AuditActivateSessionEventType
    \value AuditActivateSessionEventType_ClientSoftwareCertificates
    \value AuditActivateSessionEventType_UserIdentityToken
    \value AuditCancelEventType
    \value AuditCancelEventType_RequestHandle
    \value AuditCertificateEventType
    \value AuditCertificateEventType_Certificate
    \value AuditCertificateDataMismatchEventType
    \value AuditCertificateDataMismatchEventType_InvalidHostname
    \value AuditCertificateDataMismatchEventType_InvalidUri
    \value AuditCertificateExpiredEventType
    \value AuditCertificateInvalidEventType
    \value AuditCertificateUntrustedEventType
    \value AuditCertificateRevokedEventType
    \value AuditCertificateMismatchEventType
    \value AuditNodeManagementEventType
    \value AuditAddNodesEventType
    \value AuditAddNodesEventType_NodesToAdd
    \value AuditDeleteNodesEventType
    \value AuditDeleteNodesEventType_NodesToDelete
    \value AuditAddReferencesEventType
    \value AuditAddReferencesEventType_ReferencesToAdd
    \value AuditDeleteReferencesEventType
    \value AuditDeleteReferencesEventType_ReferencesToDelete
    \value AuditUpdateEventType
    \value AuditWriteUpdateEventType
    \value AuditWriteUpdateEventType_IndexRange
    \value AuditWriteUpdateEventType_OldValue
    \value AuditWriteUpdateEventType_NewValue
    \value AuditHistoryUpdateEventType
    \value AuditUpdateMethodEventType
    \value AuditUpdateMethodEventType_MethodId
    \value AuditUpdateMethodEventType_InputArguments
    \value SystemEventType
    \value DeviceFailureEventType
    \value BaseModelChangeEventType
    \value GeneralModelChangeEventType
    \value GeneralModelChangeEventType_Changes
    \value ServerVendorCapabilityType
    \value ServerStatusType
    \value ServerStatusType_StartTime
    \value ServerStatusType_CurrentTime
    \value ServerStatusType_State
    \value ServerStatusType_BuildInfo
    \value ServerDiagnosticsSummaryType
    \value ServerDiagnosticsSummaryType_ServerViewCount
    \value ServerDiagnosticsSummaryType_CurrentSessionCount
    \value ServerDiagnosticsSummaryType_CumulatedSessionCount
    \value ServerDiagnosticsSummaryType_SecurityRejectedSessionCount
    \value ServerDiagnosticsSummaryType_RejectedSessionCount
    \value ServerDiagnosticsSummaryType_SessionTimeoutCount
    \value ServerDiagnosticsSummaryType_SessionAbortCount
    \value ServerDiagnosticsSummaryType_PublishingIntervalCount
    \value ServerDiagnosticsSummaryType_CurrentSubscriptionCount
    \value ServerDiagnosticsSummaryType_CumulatedSubscriptionCount
    \value ServerDiagnosticsSummaryType_SecurityRejectedRequestsCount
    \value ServerDiagnosticsSummaryType_RejectedRequestsCount
    \value SamplingIntervalDiagnosticsArrayType
    \value SamplingIntervalDiagnosticsType
    \value SamplingIntervalDiagnosticsType_SamplingInterval
    \value SubscriptionDiagnosticsArrayType
    \value SubscriptionDiagnosticsType
    \value SubscriptionDiagnosticsType_SessionId
    \value SubscriptionDiagnosticsType_SubscriptionId
    \value SubscriptionDiagnosticsType_Priority
    \value SubscriptionDiagnosticsType_PublishingInterval
    \value SubscriptionDiagnosticsType_MaxKeepAliveCount
    \value SubscriptionDiagnosticsType_MaxNotificationsPerPublish
    \value SubscriptionDiagnosticsType_PublishingEnabled
    \value SubscriptionDiagnosticsType_ModifyCount
    \value SubscriptionDiagnosticsType_EnableCount
    \value SubscriptionDiagnosticsType_DisableCount
    \value SubscriptionDiagnosticsType_RepublishRequestCount
    \value SubscriptionDiagnosticsType_RepublishMessageRequestCount
    \value SubscriptionDiagnosticsType_RepublishMessageCount
    \value SubscriptionDiagnosticsType_TransferRequestCount
    \value SubscriptionDiagnosticsType_TransferredToAltClientCount
    \value SubscriptionDiagnosticsType_TransferredToSameClientCount
    \value SubscriptionDiagnosticsType_PublishRequestCount
    \value SubscriptionDiagnosticsType_DataChangeNotificationsCount
    \value SubscriptionDiagnosticsType_NotificationsCount
    \value SessionDiagnosticsArrayType
    \value SessionDiagnosticsVariableType
    \value SessionDiagnosticsVariableType_SessionId
    \value SessionDiagnosticsVariableType_SessionName
    \value SessionDiagnosticsVariableType_ClientDescription
    \value SessionDiagnosticsVariableType_ServerUri
    \value SessionDiagnosticsVariableType_EndpointUrl
    \value SessionDiagnosticsVariableType_LocaleIds
    \value SessionDiagnosticsVariableType_ActualSessionTimeout
    \value SessionDiagnosticsVariableType_ClientConnectionTime
    \value SessionDiagnosticsVariableType_ClientLastContactTime
    \value SessionDiagnosticsVariableType_CurrentSubscriptionsCount
    \value SessionDiagnosticsVariableType_CurrentMonitoredItemsCount
    \value SessionDiagnosticsVariableType_CurrentPublishRequestsInQueue
    \value SessionDiagnosticsVariableType_ReadCount
    \value SessionDiagnosticsVariableType_HistoryReadCount
    \value SessionDiagnosticsVariableType_WriteCount
    \value SessionDiagnosticsVariableType_HistoryUpdateCount
    \value SessionDiagnosticsVariableType_CallCount
    \value SessionDiagnosticsVariableType_CreateMonitoredItemsCount
    \value SessionDiagnosticsVariableType_ModifyMonitoredItemsCount
    \value SessionDiagnosticsVariableType_SetMonitoringModeCount
    \value SessionDiagnosticsVariableType_SetTriggeringCount
    \value SessionDiagnosticsVariableType_DeleteMonitoredItemsCount
    \value SessionDiagnosticsVariableType_CreateSubscriptionCount
    \value SessionDiagnosticsVariableType_ModifySubscriptionCount
    \value SessionDiagnosticsVariableType_SetPublishingModeCount
    \value SessionDiagnosticsVariableType_PublishCount
    \value SessionDiagnosticsVariableType_RepublishCount
    \value SessionDiagnosticsVariableType_TransferSubscriptionsCount
    \value SessionDiagnosticsVariableType_DeleteSubscriptionsCount
    \value SessionDiagnosticsVariableType_AddNodesCount
    \value SessionDiagnosticsVariableType_AddReferencesCount
    \value SessionDiagnosticsVariableType_DeleteNodesCount
    \value SessionDiagnosticsVariableType_DeleteReferencesCount
    \value SessionDiagnosticsVariableType_BrowseCount
    \value SessionDiagnosticsVariableType_BrowseNextCount
    \value SessionDiagnosticsVariableType_TranslateBrowsePathsToNodeIdsCount
    \value SessionDiagnosticsVariableType_QueryFirstCount
    \value SessionDiagnosticsVariableType_QueryNextCount
    \value SessionSecurityDiagnosticsArrayType
    \value SessionSecurityDiagnosticsType
    \value SessionSecurityDiagnosticsType_SessionId
    \value SessionSecurityDiagnosticsType_ClientUserIdOfSession
    \value SessionSecurityDiagnosticsType_ClientUserIdHistory
    \value SessionSecurityDiagnosticsType_AuthenticationMechanism
    \value SessionSecurityDiagnosticsType_Encoding
    \value SessionSecurityDiagnosticsType_TransportProtocol
    \value SessionSecurityDiagnosticsType_SecurityMode
    \value SessionSecurityDiagnosticsType_SecurityPolicyUri
    \value Server
    \value Server_ServerArray
    \value Server_NamespaceArray
    \value Server_ServerStatus
    \value Server_ServerStatus_StartTime
    \value Server_ServerStatus_CurrentTime
    \value Server_ServerStatus_State
    \value Server_ServerStatus_BuildInfo
    \value Server_ServerStatus_BuildInfo_ProductName
    \value Server_ServerStatus_BuildInfo_ProductUri
    \value Server_ServerStatus_BuildInfo_ManufacturerName
    \value Server_ServerStatus_BuildInfo_SoftwareVersion
    \value Server_ServerStatus_BuildInfo_BuildNumber
    \value Server_ServerStatus_BuildInfo_BuildDate
    \value Server_ServiceLevel
    \value Server_ServerCapabilities
    \value Server_ServerCapabilities_ServerProfileArray
    \value Server_ServerCapabilities_LocaleIdArray
    \value Server_ServerCapabilities_MinSupportedSampleRate
    \value Server_ServerDiagnostics
    \value Server_ServerDiagnostics_ServerDiagnosticsSummary
    \value Server_ServerDiagnostics_ServerDiagnosticsSummary_ServerViewCount
    \value Server_ServerDiagnostics_ServerDiagnosticsSummary_CurrentSessionCount
    \value Server_ServerDiagnostics_ServerDiagnosticsSummary_CumulatedSessionCount
    \value Server_ServerDiagnostics_ServerDiagnosticsSummary_SecurityRejectedSessionCount
    \value Server_ServerDiagnostics_ServerDiagnosticsSummary_SessionTimeoutCount
    \value Server_ServerDiagnostics_ServerDiagnosticsSummary_SessionAbortCount
    \value Server_ServerDiagnostics_ServerDiagnosticsSummary_PublishingIntervalCount
    \value Server_ServerDiagnostics_ServerDiagnosticsSummary_CurrentSubscriptionCount
    \value Server_ServerDiagnostics_ServerDiagnosticsSummary_CumulatedSubscriptionCount
    \value Server_ServerDiagnostics_ServerDiagnosticsSummary_SecurityRejectedRequestsCount
    \value Server_ServerDiagnostics_ServerDiagnosticsSummary_RejectedRequestsCount
    \value Server_ServerDiagnostics_SamplingIntervalDiagnosticsArray
    \value Server_ServerDiagnostics_SubscriptionDiagnosticsArray
    \value Server_ServerDiagnostics_EnabledFlag
    \value Server_VendorServerInfo
    \value Server_ServerRedundancy
    \value StateMachineType
    \value StateType
    \value StateType_StateNumber
    \value InitialStateType
    \value TransitionType
    \value TransitionEventType
    \value TransitionType_TransitionNumber
    \value AuditUpdateStateEventType
    \value HistoricalDataConfigurationType
    \value HistoricalDataConfigurationType_Stepped
    \value HistoricalDataConfigurationType_Definition
    \value HistoricalDataConfigurationType_MaxTimeInterval
    \value HistoricalDataConfigurationType_MinTimeInterval
    \value HistoricalDataConfigurationType_ExceptionDeviation
    \value HistoricalDataConfigurationType_ExceptionDeviationFormat
    \value HistoryServerCapabilitiesType
    \value HistoryServerCapabilitiesType_AccessHistoryDataCapability
    \value HistoryServerCapabilitiesType_AccessHistoryEventsCapability
    \value HistoryServerCapabilitiesType_InsertDataCapability
    \value HistoryServerCapabilitiesType_ReplaceDataCapability
    \value HistoryServerCapabilitiesType_UpdateDataCapability
    \value HistoryServerCapabilitiesType_DeleteRawCapability
    \value HistoryServerCapabilitiesType_DeleteAtTimeCapability
    \value AggregateFunctionType
    \value AggregateFunction_Interpolative
    \value AggregateFunction_Average
    \value AggregateFunction_TimeAverage
    \value AggregateFunction_Total
    \value AggregateFunction_Minimum
    \value AggregateFunction_Maximum
    \value AggregateFunction_MinimumActualTime
    \value AggregateFunction_MaximumActualTime
    \value AggregateFunction_Range
    \value AggregateFunction_AnnotationCount
    \value AggregateFunction_Count
    \value AggregateFunction_NumberOfTransitions
    \value AggregateFunction_Start
    \value AggregateFunction_End
    \value AggregateFunction_Delta
    \value AggregateFunction_DurationGood
    \value AggregateFunction_DurationBad
    \value AggregateFunction_PercentGood
    \value AggregateFunction_PercentBad
    \value AggregateFunction_WorstQuality
    \value DataItemType
    \value DataItemType_Definition
    \value DataItemType_ValuePrecision
    \value AnalogItemType
    \value AnalogItemType_EURange
    \value AnalogItemType_InstrumentRange
    \value AnalogItemType_EngineeringUnits
    \value DiscreteItemType
    \value TwoStateDiscreteType
    \value TwoStateDiscreteType_FalseState
    \value TwoStateDiscreteType_TrueState
    \value MultiStateDiscreteType
    \value MultiStateDiscreteType_EnumStrings
    \value ProgramTransitionEventType
    \value ProgramTransitionEventType_IntermediateResult
    \value ProgramDiagnosticType
    \value ProgramDiagnosticType_CreateSessionId
    \value ProgramDiagnosticType_CreateClientName
    \value ProgramDiagnosticType_InvocationCreationTime
    \value ProgramDiagnosticType_LastTransitionTime
    \value ProgramDiagnosticType_LastMethodCall
    \value ProgramDiagnosticType_LastMethodSessionId
    \value ProgramDiagnosticType_LastMethodInputArguments
    \value ProgramDiagnosticType_LastMethodOutputArguments
    \value ProgramDiagnosticType_LastMethodCallTime
    \value ProgramDiagnosticType_LastMethodReturnStatus
    \value ProgramStateMachineType
    \value ProgramStateMachineType_Creatable
    \value ProgramStateMachineType_Deletable
    \value ProgramStateMachineType_AutoDelete
    \value ProgramStateMachineType_RecycleCount
    \value ProgramStateMachineType_InstanceCount
    \value ProgramStateMachineType_MaxInstanceCount
    \value ProgramStateMachineType_MaxRecycleCount
    \value ProgramStateMachineType_ProgramDiagnostics
    \value ProgramStateMachineType_Ready
    \value ProgramStateMachineType_Ready_StateNumber
    \value ProgramStateMachineType_Running
    \value ProgramStateMachineType_Running_StateNumber
    \value ProgramStateMachineType_Suspended
    \value ProgramStateMachineType_Suspended_StateNumber
    \value ProgramStateMachineType_Halted
    \value ProgramStateMachineType_Halted_StateNumber
    \value ProgramStateMachineType_HaltedToReady
    \value ProgramStateMachineType_HaltedToReady_TransitionNumber
    \value ProgramStateMachineType_ReadyToRunning
    \value ProgramStateMachineType_ReadyToRunning_TransitionNumber
    \value ProgramStateMachineType_RunningToHalted
    \value ProgramStateMachineType_RunningToHalted_TransitionNumber
    \value ProgramStateMachineType_RunningToReady
    \value ProgramStateMachineType_RunningToReady_TransitionNumber
    \value ProgramStateMachineType_RunningToSuspended
    \value ProgramStateMachineType_RunningToSuspended_TransitionNumber
    \value ProgramStateMachineType_SuspendedToRunning
    \value ProgramStateMachineType_SuspendedToRunning_TransitionNumber
    \value ProgramStateMachineType_SuspendedToHalted
    \value ProgramStateMachineType_SuspendedToHalted_TransitionNumber
    \value ProgramStateMachineType_SuspendedToReady
    \value ProgramStateMachineType_SuspendedToReady_TransitionNumber
    \value ProgramStateMachineType_ReadyToHalted
    \value ProgramStateMachineType_ReadyToHalted_TransitionNumber
    \value ProgramStateMachineType_Start
    \value ProgramStateMachineType_Suspend
    \value ProgramStateMachineType_Resume
    \value ProgramStateMachineType_Halt
    \value ProgramStateMachineType_Reset
    \value SessionDiagnosticsVariableType_RegisterNodesCount
    \value SessionDiagnosticsVariableType_UnregisterNodesCount
    \value ServerCapabilitiesType_MaxBrowseContinuationPoints
    \value ServerCapabilitiesType_MaxQueryContinuationPoints
    \value ServerCapabilitiesType_MaxHistoryContinuationPoints
    \value Server_ServerCapabilities_MaxBrowseContinuationPoints
    \value Server_ServerCapabilities_MaxQueryContinuationPoints
    \value Server_ServerCapabilities_MaxHistoryContinuationPoints
    \value SemanticChangeEventType
    \value SemanticChangeEventType_Changes
    \value ServerType_Auditing
    \value ServerDiagnosticsType_SessionsDiagnosticsSummary
    \value AuditChannelEventType_SecureChannelId
    \value AuditOpenSecureChannelEventType_ClientCertificateThumbprint
    \value AuditCreateSessionEventType_ClientCertificateThumbprint
    \value AuditUrlMismatchEventType
    \value AuditUrlMismatchEventType_EndpointUrl
    \value AuditWriteUpdateEventType_AttributeId
    \value AuditHistoryUpdateEventType_ParameterDataTypeId
    \value ServerStatusType_SecondsTillShutdown
    \value ServerStatusType_ShutdownReason
    \value ServerCapabilitiesType_AggregateFunctions
    \value StateVariableType
    \value StateVariableType_Id
    \value StateVariableType_Name
    \value StateVariableType_Number
    \value StateVariableType_EffectiveDisplayName
    \value FiniteStateVariableType
    \value FiniteStateVariableType_Id
    \value TransitionVariableType
    \value TransitionVariableType_Id
    \value TransitionVariableType_Name
    \value TransitionVariableType_Number
    \value TransitionVariableType_TransitionTime
    \value FiniteTransitionVariableType
    \value FiniteTransitionVariableType_Id
    \value StateMachineType_CurrentState
    \value StateMachineType_LastTransition
    \value FiniteStateMachineType
    \value FiniteStateMachineType_CurrentState
    \value FiniteStateMachineType_LastTransition
    \value TransitionEventType_Transition
    \value TransitionEventType_FromState
    \value TransitionEventType_ToState
    \value AuditUpdateStateEventType_OldStateId
    \value AuditUpdateStateEventType_NewStateId
    \value ConditionType
    \value RefreshStartEventType
    \value RefreshEndEventType
    \value RefreshRequiredEventType
    \value AuditConditionEventType
    \value AuditConditionEnableEventType
    \value AuditConditionCommentEventType
    \value DialogConditionType
    \value DialogConditionType_Prompt
    \value AcknowledgeableConditionType
    \value AlarmConditionType
    \value ShelvedStateMachineType
    \value ShelvedStateMachineType_Unshelved
    \value ShelvedStateMachineType_TimedShelved
    \value ShelvedStateMachineType_OneShotShelved
    \value ShelvedStateMachineType_UnshelvedToTimedShelved
    \value ShelvedStateMachineType_UnshelvedToOneShotShelved
    \value ShelvedStateMachineType_TimedShelvedToUnshelved
    \value ShelvedStateMachineType_TimedShelvedToOneShotShelved
    \value ShelvedStateMachineType_OneShotShelvedToUnshelved
    \value ShelvedStateMachineType_OneShotShelvedToTimedShelved
    \value ShelvedStateMachineType_Unshelve
    \value ShelvedStateMachineType_OneShotShelve
    \value ShelvedStateMachineType_TimedShelve
    \value LimitAlarmType
    \value ShelvedStateMachineType_TimedShelve_InputArguments
    \value Server_ServerStatus_SecondsTillShutdown
    \value Server_ServerStatus_ShutdownReason
    \value Server_Auditing
    \value Server_ServerCapabilities_ModellingRules
    \value Server_ServerCapabilities_AggregateFunctions
    \value SubscriptionDiagnosticsType_EventNotificationsCount
    \value AuditHistoryEventUpdateEventType
    \value AuditHistoryEventUpdateEventType_Filter
    \value AuditHistoryValueUpdateEventType
    \value AuditHistoryDeleteEventType
    \value AuditHistoryRawModifyDeleteEventType
    \value AuditHistoryRawModifyDeleteEventType_IsDeleteModified
    \value AuditHistoryRawModifyDeleteEventType_StartTime
    \value AuditHistoryRawModifyDeleteEventType_EndTime
    \value AuditHistoryAtTimeDeleteEventType
    \value AuditHistoryAtTimeDeleteEventType_ReqTimes
    \value AuditHistoryAtTimeDeleteEventType_OldValues
    \value AuditHistoryEventDeleteEventType
    \value AuditHistoryEventDeleteEventType_EventIds
    \value AuditHistoryEventDeleteEventType_OldValues
    \value AuditHistoryEventUpdateEventType_UpdatedNode
    \value AuditHistoryValueUpdateEventType_UpdatedNode
    \value AuditHistoryDeleteEventType_UpdatedNode
    \value AuditHistoryEventUpdateEventType_PerformInsertReplace
    \value AuditHistoryEventUpdateEventType_NewValues
    \value AuditHistoryEventUpdateEventType_OldValues
    \value AuditHistoryValueUpdateEventType_PerformInsertReplace
    \value AuditHistoryValueUpdateEventType_NewValues
    \value AuditHistoryValueUpdateEventType_OldValues
    \value AuditHistoryRawModifyDeleteEventType_OldValues
    \value EventQueueOverflowEventType
    \value EventTypesFolder
    \value ServerCapabilitiesType_SoftwareCertificates
    \value SessionDiagnosticsVariableType_MaxResponseMessageSize
    \value BuildInfoType
    \value BuildInfoType_ProductUri
    \value BuildInfoType_ManufacturerName
    \value BuildInfoType_ProductName
    \value BuildInfoType_SoftwareVersion
    \value BuildInfoType_BuildNumber
    \value BuildInfoType_BuildDate
    \value SessionSecurityDiagnosticsType_ClientCertificate
    \value HistoricalDataConfigurationType_AggregateConfiguration
    \value DefaultBinary
    \value DefaultXml
    \value AlwaysGeneratesEvent
    \value Icon
    \value NodeVersion
    \value LocalTime
    \value AllowNulls
    \value EnumValues
    \value InputArguments
    \value OutputArguments
    \value ServerType_ServerStatus_StartTime
    \value ServerType_ServerStatus_CurrentTime
    \value ServerType_ServerStatus_State
    \value ServerType_ServerStatus_BuildInfo
    \value ServerType_ServerStatus_BuildInfo_ProductUri
    \value ServerType_ServerStatus_BuildInfo_ManufacturerName
    \value ServerType_ServerStatus_BuildInfo_ProductName
    \value ServerType_ServerStatus_BuildInfo_SoftwareVersion
    \value ServerType_ServerStatus_BuildInfo_BuildNumber
    \value ServerType_ServerStatus_BuildInfo_BuildDate
    \value ServerType_ServerStatus_SecondsTillShutdown
    \value ServerType_ServerStatus_ShutdownReason
    \value ServerType_ServerCapabilities_ServerProfileArray
    \value ServerType_ServerCapabilities_LocaleIdArray
    \value ServerType_ServerCapabilities_MinSupportedSampleRate
    \value ServerType_ServerCapabilities_MaxBrowseContinuationPoints
    \value ServerType_ServerCapabilities_MaxQueryContinuationPoints
    \value ServerType_ServerCapabilities_MaxHistoryContinuationPoints
    \value ServerType_ServerCapabilities_SoftwareCertificates
    \value ServerType_ServerCapabilities_ModellingRules
    \value ServerType_ServerCapabilities_AggregateFunctions
    \value ServerType_ServerDiagnostics_ServerDiagnosticsSummary
    \value ServerType_ServerDiagnostics_ServerDiagnosticsSummary_ServerViewCount
    \value ServerType_ServerDiagnostics_ServerDiagnosticsSummary_CurrentSessionCount
    \value ServerType_ServerDiagnostics_ServerDiagnosticsSummary_CumulatedSessionCount
    \value ServerType_ServerDiagnostics_ServerDiagnosticsSummary_SecurityRejectedSessionCount
    \value ServerType_ServerDiagnostics_ServerDiagnosticsSummary_RejectedSessionCount
    \value ServerType_ServerDiagnostics_ServerDiagnosticsSummary_SessionTimeoutCount
    \value ServerType_ServerDiagnostics_ServerDiagnosticsSummary_SessionAbortCount
    \value ServerType_ServerDiagnostics_ServerDiagnosticsSummary_PublishingIntervalCount
    \value ServerType_ServerDiagnostics_ServerDiagnosticsSummary_CurrentSubscriptionCount
    \value ServerType_ServerDiagnostics_ServerDiagnosticsSummary_CumulatedSubscriptionCount
    \value ServerType_ServerDiagnostics_ServerDiagnosticsSummary_SecurityRejectedRequestsCount
    \value ServerType_ServerDiagnostics_ServerDiagnosticsSummary_RejectedRequestsCount
    \value ServerType_ServerDiagnostics_SamplingIntervalDiagnosticsArray
    \value ServerType_ServerDiagnostics_SubscriptionDiagnosticsArray
    \value ServerType_ServerDiagnostics_SessionsDiagnosticsSummary
    \value ServerType_ServerDiagnostics_SessionsDiagnosticsSummary_SessionDiagnosticsArray
    \value ServerType_ServerDiagnostics_SessionsDiagnosticsSummary_SessionSecurityDiagnosticsArray
    \value ServerType_ServerDiagnostics_EnabledFlag
    \value ServerType_ServerRedundancy_RedundancySupport
    \value ServerDiagnosticsType_ServerDiagnosticsSummary_ServerViewCount
    \value ServerDiagnosticsType_ServerDiagnosticsSummary_CurrentSessionCount
    \value ServerDiagnosticsType_ServerDiagnosticsSummary_CumulatedSessionCount
    \value ServerDiagnosticsType_ServerDiagnosticsSummary_SecurityRejectedSessionCount
    \value ServerDiagnosticsType_ServerDiagnosticsSummary_RejectedSessionCount
    \value ServerDiagnosticsType_ServerDiagnosticsSummary_SessionTimeoutCount
    \value ServerDiagnosticsType_ServerDiagnosticsSummary_SessionAbortCount
    \value ServerDiagnosticsType_ServerDiagnosticsSummary_PublishingIntervalCount
    \value ServerDiagnosticsType_ServerDiagnosticsSummary_CurrentSubscriptionCount
    \value ServerDiagnosticsType_ServerDiagnosticsSummary_CumulatedSubscriptionCount
    \value ServerDiagnosticsType_ServerDiagnosticsSummary_SecurityRejectedRequestsCount
    \value ServerDiagnosticsType_ServerDiagnosticsSummary_RejectedRequestsCount
    \value ServerDiagnosticsType_SessionsDiagnosticsSummary_SessionDiagnosticsArray
    \value ServerDiagnosticsType_SessionsDiagnosticsSummary_SessionSecurityDiagnosticsArray
    \value SessionDiagnosticsObjectType_SessionDiagnostics_SessionId
    \value SessionDiagnosticsObjectType_SessionDiagnostics_SessionName
    \value SessionDiagnosticsObjectType_SessionDiagnostics_ClientDescription
    \value SessionDiagnosticsObjectType_SessionDiagnostics_ServerUri
    \value SessionDiagnosticsObjectType_SessionDiagnostics_EndpointUrl
    \value SessionDiagnosticsObjectType_SessionDiagnostics_LocaleIds
    \value SessionDiagnosticsObjectType_SessionDiagnostics_ActualSessionTimeout
    \value SessionDiagnosticsObjectType_SessionDiagnostics_MaxResponseMessageSize
    \value SessionDiagnosticsObjectType_SessionDiagnostics_ClientConnectionTime
    \value SessionDiagnosticsObjectType_SessionDiagnostics_ClientLastContactTime
    \value SessionDiagnosticsObjectType_SessionDiagnostics_CurrentSubscriptionsCount
    \value SessionDiagnosticsObjectType_SessionDiagnostics_CurrentMonitoredItemsCount
    \value SessionDiagnosticsObjectType_SessionDiagnostics_CurrentPublishRequestsInQueue
    \value SessionDiagnosticsObjectType_SessionDiagnostics_ReadCount
    \value SessionDiagnosticsObjectType_SessionDiagnostics_HistoryReadCount
    \value SessionDiagnosticsObjectType_SessionDiagnostics_WriteCount
    \value SessionDiagnosticsObjectType_SessionDiagnostics_HistoryUpdateCount
    \value SessionDiagnosticsObjectType_SessionDiagnostics_CallCount
    \value SessionDiagnosticsObjectType_SessionDiagnostics_CreateMonitoredItemsCount
    \value SessionDiagnosticsObjectType_SessionDiagnostics_ModifyMonitoredItemsCount
    \value SessionDiagnosticsObjectType_SessionDiagnostics_SetMonitoringModeCount
    \value SessionDiagnosticsObjectType_SessionDiagnostics_SetTriggeringCount
    \value SessionDiagnosticsObjectType_SessionDiagnostics_DeleteMonitoredItemsCount
    \value SessionDiagnosticsObjectType_SessionDiagnostics_CreateSubscriptionCount
    \value SessionDiagnosticsObjectType_SessionDiagnostics_ModifySubscriptionCount
    \value SessionDiagnosticsObjectType_SessionDiagnostics_SetPublishingModeCount
    \value SessionDiagnosticsObjectType_SessionDiagnostics_PublishCount
    \value SessionDiagnosticsObjectType_SessionDiagnostics_RepublishCount
    \value SessionDiagnosticsObjectType_SessionDiagnostics_TransferSubscriptionsCount
    \value SessionDiagnosticsObjectType_SessionDiagnostics_DeleteSubscriptionsCount
    \value SessionDiagnosticsObjectType_SessionDiagnostics_AddNodesCount
    \value SessionDiagnosticsObjectType_SessionDiagnostics_AddReferencesCount
    \value SessionDiagnosticsObjectType_SessionDiagnostics_DeleteNodesCount
    \value SessionDiagnosticsObjectType_SessionDiagnostics_DeleteReferencesCount
    \value SessionDiagnosticsObjectType_SessionDiagnostics_BrowseCount
    \value SessionDiagnosticsObjectType_SessionDiagnostics_BrowseNextCount
    \value SessionDiagnosticsObjectType_SessionDiagnostics_TranslateBrowsePathsToNodeIdsCount
    \value SessionDiagnosticsObjectType_SessionDiagnostics_QueryFirstCount
    \value SessionDiagnosticsObjectType_SessionDiagnostics_QueryNextCount
    \value SessionDiagnosticsObjectType_SessionDiagnostics_RegisterNodesCount
    \value SessionDiagnosticsObjectType_SessionDiagnostics_UnregisterNodesCount
    \value SessionDiagnosticsObjectType_SessionSecurityDiagnostics_SessionId
    \value SessionDiagnosticsObjectType_SessionSecurityDiagnostics_ClientUserIdOfSession
    \value SessionDiagnosticsObjectType_SessionSecurityDiagnostics_ClientUserIdHistory
    \value SessionDiagnosticsObjectType_SessionSecurityDiagnostics_AuthenticationMechanism
    \value SessionDiagnosticsObjectType_SessionSecurityDiagnostics_Encoding
    \value SessionDiagnosticsObjectType_SessionSecurityDiagnostics_TransportProtocol
    \value SessionDiagnosticsObjectType_SessionSecurityDiagnostics_SecurityMode
    \value SessionDiagnosticsObjectType_SessionSecurityDiagnostics_SecurityPolicyUri
    \value SessionDiagnosticsObjectType_SessionSecurityDiagnostics_ClientCertificate
    \value TransparentRedundancyType_RedundancySupport
    \value NonTransparentRedundancyType_RedundancySupport
    \value BaseEventType_LocalTime
    \value EventQueueOverflowEventType_EventId
    \value EventQueueOverflowEventType_EventType
    \value EventQueueOverflowEventType_SourceNode
    \value EventQueueOverflowEventType_SourceName
    \value EventQueueOverflowEventType_Time
    \value EventQueueOverflowEventType_ReceiveTime
    \value EventQueueOverflowEventType_LocalTime
    \value EventQueueOverflowEventType_Message
    \value EventQueueOverflowEventType_Severity
    \value AuditEventType_EventId
    \value AuditEventType_EventType
    \value AuditEventType_SourceNode
    \value AuditEventType_SourceName
    \value AuditEventType_Time
    \value AuditEventType_ReceiveTime
    \value AuditEventType_LocalTime
    \value AuditEventType_Message
    \value AuditEventType_Severity
    \value AuditSecurityEventType_EventId
    \value AuditSecurityEventType_EventType
    \value AuditSecurityEventType_SourceNode
    \value AuditSecurityEventType_SourceName
    \value AuditSecurityEventType_Time
    \value AuditSecurityEventType_ReceiveTime
    \value AuditSecurityEventType_LocalTime
    \value AuditSecurityEventType_Message
    \value AuditSecurityEventType_Severity
    \value AuditSecurityEventType_ActionTimeStamp
    \value AuditSecurityEventType_Status
    \value AuditSecurityEventType_ServerId
    \value AuditSecurityEventType_ClientAuditEntryId
    \value AuditSecurityEventType_ClientUserId
    \value AuditChannelEventType_EventId
    \value AuditChannelEventType_EventType
    \value AuditChannelEventType_SourceNode
    \value AuditChannelEventType_SourceName
    \value AuditChannelEventType_Time
    \value AuditChannelEventType_ReceiveTime
    \value AuditChannelEventType_LocalTime
    \value AuditChannelEventType_Message
    \value AuditChannelEventType_Severity
    \value AuditChannelEventType_ActionTimeStamp
    \value AuditChannelEventType_Status
    \value AuditChannelEventType_ServerId
    \value AuditChannelEventType_ClientAuditEntryId
    \value AuditChannelEventType_ClientUserId
    \value AuditOpenSecureChannelEventType_EventId
    \value AuditOpenSecureChannelEventType_EventType
    \value AuditOpenSecureChannelEventType_SourceNode
    \value AuditOpenSecureChannelEventType_SourceName
    \value AuditOpenSecureChannelEventType_Time
    \value AuditOpenSecureChannelEventType_ReceiveTime
    \value AuditOpenSecureChannelEventType_LocalTime
    \value AuditOpenSecureChannelEventType_Message
    \value AuditOpenSecureChannelEventType_Severity
    \value AuditOpenSecureChannelEventType_ActionTimeStamp
    \value AuditOpenSecureChannelEventType_Status
    \value AuditOpenSecureChannelEventType_ServerId
    \value AuditOpenSecureChannelEventType_ClientAuditEntryId
    \value AuditOpenSecureChannelEventType_ClientUserId
    \value AuditOpenSecureChannelEventType_SecureChannelId
    \value AuditSessionEventType_EventId
    \value AuditSessionEventType_EventType
    \value AuditSessionEventType_SourceNode
    \value AuditSessionEventType_SourceName
    \value AuditSessionEventType_Time
    \value AuditSessionEventType_ReceiveTime
    \value AuditSessionEventType_LocalTime
    \value AuditSessionEventType_Message
    \value AuditSessionEventType_Severity
    \value AuditSessionEventType_ActionTimeStamp
    \value AuditSessionEventType_Status
    \value AuditSessionEventType_ServerId
    \value AuditSessionEventType_ClientAuditEntryId
    \value AuditSessionEventType_ClientUserId
    \value AuditCreateSessionEventType_EventId
    \value AuditCreateSessionEventType_EventType
    \value AuditCreateSessionEventType_SourceNode
    \value AuditCreateSessionEventType_SourceName
    \value AuditCreateSessionEventType_Time
    \value AuditCreateSessionEventType_ReceiveTime
    \value AuditCreateSessionEventType_LocalTime
    \value AuditCreateSessionEventType_Message
    \value AuditCreateSessionEventType_Severity
    \value AuditCreateSessionEventType_ActionTimeStamp
    \value AuditCreateSessionEventType_Status
    \value AuditCreateSessionEventType_ServerId
    \value AuditCreateSessionEventType_ClientAuditEntryId
    \value AuditCreateSessionEventType_ClientUserId
    \value AuditUrlMismatchEventType_EventId
    \value AuditUrlMismatchEventType_EventType
    \value AuditUrlMismatchEventType_SourceNode
    \value AuditUrlMismatchEventType_SourceName
    \value AuditUrlMismatchEventType_Time
    \value AuditUrlMismatchEventType_ReceiveTime
    \value AuditUrlMismatchEventType_LocalTime
    \value AuditUrlMismatchEventType_Message
    \value AuditUrlMismatchEventType_Severity
    \value AuditUrlMismatchEventType_ActionTimeStamp
    \value AuditUrlMismatchEventType_Status
    \value AuditUrlMismatchEventType_ServerId
    \value AuditUrlMismatchEventType_ClientAuditEntryId
    \value AuditUrlMismatchEventType_ClientUserId
    \value AuditUrlMismatchEventType_SecureChannelId
    \value AuditUrlMismatchEventType_ClientCertificate
    \value AuditUrlMismatchEventType_ClientCertificateThumbprint
    \value AuditUrlMismatchEventType_RevisedSessionTimeout
    \value AuditActivateSessionEventType_EventId
    \value AuditActivateSessionEventType_EventType
    \value AuditActivateSessionEventType_SourceNode
    \value AuditActivateSessionEventType_SourceName
    \value AuditActivateSessionEventType_Time
    \value AuditActivateSessionEventType_ReceiveTime
    \value AuditActivateSessionEventType_LocalTime
    \value AuditActivateSessionEventType_Message
    \value AuditActivateSessionEventType_Severity
    \value AuditActivateSessionEventType_ActionTimeStamp
    \value AuditActivateSessionEventType_Status
    \value AuditActivateSessionEventType_ServerId
    \value AuditActivateSessionEventType_ClientAuditEntryId
    \value AuditActivateSessionEventType_ClientUserId
    \value AuditActivateSessionEventType_SessionId
    \value AuditCancelEventType_EventId
    \value AuditCancelEventType_EventType
    \value AuditCancelEventType_SourceNode
    \value AuditCancelEventType_SourceName
    \value AuditCancelEventType_Time
    \value AuditCancelEventType_ReceiveTime
    \value AuditCancelEventType_LocalTime
    \value AuditCancelEventType_Message
    \value AuditCancelEventType_Severity
    \value AuditCancelEventType_ActionTimeStamp
    \value AuditCancelEventType_Status
    \value AuditCancelEventType_ServerId
    \value AuditCancelEventType_ClientAuditEntryId
    \value AuditCancelEventType_ClientUserId
    \value AuditCancelEventType_SessionId
    \value AuditCertificateEventType_EventId
    \value AuditCertificateEventType_EventType
    \value AuditCertificateEventType_SourceNode
    \value AuditCertificateEventType_SourceName
    \value AuditCertificateEventType_Time
    \value AuditCertificateEventType_ReceiveTime
    \value AuditCertificateEventType_LocalTime
    \value AuditCertificateEventType_Message
    \value AuditCertificateEventType_Severity
    \value AuditCertificateEventType_ActionTimeStamp
    \value AuditCertificateEventType_Status
    \value AuditCertificateEventType_ServerId
    \value AuditCertificateEventType_ClientAuditEntryId
    \value AuditCertificateEventType_ClientUserId
    \value AuditCertificateDataMismatchEventType_EventId
    \value AuditCertificateDataMismatchEventType_EventType
    \value AuditCertificateDataMismatchEventType_SourceNode
    \value AuditCertificateDataMismatchEventType_SourceName
    \value AuditCertificateDataMismatchEventType_Time
    \value AuditCertificateDataMismatchEventType_ReceiveTime
    \value AuditCertificateDataMismatchEventType_LocalTime
    \value AuditCertificateDataMismatchEventType_Message
    \value AuditCertificateDataMismatchEventType_Severity
    \value AuditCertificateDataMismatchEventType_ActionTimeStamp
    \value AuditCertificateDataMismatchEventType_Status
    \value AuditCertificateDataMismatchEventType_ServerId
    \value AuditCertificateDataMismatchEventType_ClientAuditEntryId
    \value AuditCertificateDataMismatchEventType_ClientUserId
    \value AuditCertificateDataMismatchEventType_Certificate
    \value AuditCertificateExpiredEventType_EventId
    \value AuditCertificateExpiredEventType_EventType
    \value AuditCertificateExpiredEventType_SourceNode
    \value AuditCertificateExpiredEventType_SourceName
    \value AuditCertificateExpiredEventType_Time
    \value AuditCertificateExpiredEventType_ReceiveTime
    \value AuditCertificateExpiredEventType_LocalTime
    \value AuditCertificateExpiredEventType_Message
    \value AuditCertificateExpiredEventType_Severity
    \value AuditCertificateExpiredEventType_ActionTimeStamp
    \value AuditCertificateExpiredEventType_Status
    \value AuditCertificateExpiredEventType_ServerId
    \value AuditCertificateExpiredEventType_ClientAuditEntryId
    \value AuditCertificateExpiredEventType_ClientUserId
    \value AuditCertificateExpiredEventType_Certificate
    \value AuditCertificateInvalidEventType_EventId
    \value AuditCertificateInvalidEventType_EventType
    \value AuditCertificateInvalidEventType_SourceNode
    \value AuditCertificateInvalidEventType_SourceName
    \value AuditCertificateInvalidEventType_Time
    \value AuditCertificateInvalidEventType_ReceiveTime
    \value AuditCertificateInvalidEventType_LocalTime
    \value AuditCertificateInvalidEventType_Message
    \value AuditCertificateInvalidEventType_Severity
    \value AuditCertificateInvalidEventType_ActionTimeStamp
    \value AuditCertificateInvalidEventType_Status
    \value AuditCertificateInvalidEventType_ServerId
    \value AuditCertificateInvalidEventType_ClientAuditEntryId
    \value AuditCertificateInvalidEventType_ClientUserId
    \value AuditCertificateInvalidEventType_Certificate
    \value AuditCertificateUntrustedEventType_EventId
    \value AuditCertificateUntrustedEventType_EventType
    \value AuditCertificateUntrustedEventType_SourceNode
    \value AuditCertificateUntrustedEventType_SourceName
    \value AuditCertificateUntrustedEventType_Time
    \value AuditCertificateUntrustedEventType_ReceiveTime
    \value AuditCertificateUntrustedEventType_LocalTime
    \value AuditCertificateUntrustedEventType_Message
    \value AuditCertificateUntrustedEventType_Severity
    \value AuditCertificateUntrustedEventType_ActionTimeStamp
    \value AuditCertificateUntrustedEventType_Status
    \value AuditCertificateUntrustedEventType_ServerId
    \value AuditCertificateUntrustedEventType_ClientAuditEntryId
    \value AuditCertificateUntrustedEventType_ClientUserId
    \value AuditCertificateUntrustedEventType_Certificate
    \value AuditCertificateRevokedEventType_EventId
    \value AuditCertificateRevokedEventType_EventType
    \value AuditCertificateRevokedEventType_SourceNode
    \value AuditCertificateRevokedEventType_SourceName
    \value AuditCertificateRevokedEventType_Time
    \value AuditCertificateRevokedEventType_ReceiveTime
    \value AuditCertificateRevokedEventType_LocalTime
    \value AuditCertificateRevokedEventType_Message
    \value AuditCertificateRevokedEventType_Severity
    \value AuditCertificateRevokedEventType_ActionTimeStamp
    \value AuditCertificateRevokedEventType_Status
    \value AuditCertificateRevokedEventType_ServerId
    \value AuditCertificateRevokedEventType_ClientAuditEntryId
    \value AuditCertificateRevokedEventType_ClientUserId
    \value AuditCertificateRevokedEventType_Certificate
    \value AuditCertificateMismatchEventType_EventId
    \value AuditCertificateMismatchEventType_EventType
    \value AuditCertificateMismatchEventType_SourceNode
    \value AuditCertificateMismatchEventType_SourceName
    \value AuditCertificateMismatchEventType_Time
    \value AuditCertificateMismatchEventType_ReceiveTime
    \value AuditCertificateMismatchEventType_LocalTime
    \value AuditCertificateMismatchEventType_Message
    \value AuditCertificateMismatchEventType_Severity
    \value AuditCertificateMismatchEventType_ActionTimeStamp
    \value AuditCertificateMismatchEventType_Status
    \value AuditCertificateMismatchEventType_ServerId
    \value AuditCertificateMismatchEventType_ClientAuditEntryId
    \value AuditCertificateMismatchEventType_ClientUserId
    \value AuditCertificateMismatchEventType_Certificate
    \value AuditNodeManagementEventType_EventId
    \value AuditNodeManagementEventType_EventType
    \value AuditNodeManagementEventType_SourceNode
    \value AuditNodeManagementEventType_SourceName
    \value AuditNodeManagementEventType_Time
    \value AuditNodeManagementEventType_ReceiveTime
    \value AuditNodeManagementEventType_LocalTime
    \value AuditNodeManagementEventType_Message
    \value AuditNodeManagementEventType_Severity
    \value AuditNodeManagementEventType_ActionTimeStamp
    \value AuditNodeManagementEventType_Status
    \value AuditNodeManagementEventType_ServerId
    \value AuditNodeManagementEventType_ClientAuditEntryId
    \value AuditNodeManagementEventType_ClientUserId
    \value AuditAddNodesEventType_EventId
    \value AuditAddNodesEventType_EventType
    \value AuditAddNodesEventType_SourceNode
    \value AuditAddNodesEventType_SourceName
    \value AuditAddNodesEventType_Time
    \value AuditAddNodesEventType_ReceiveTime
    \value AuditAddNodesEventType_LocalTime
    \value AuditAddNodesEventType_Message
    \value AuditAddNodesEventType_Severity
    \value AuditAddNodesEventType_ActionTimeStamp
    \value AuditAddNodesEventType_Status
    \value AuditAddNodesEventType_ServerId
    \value AuditAddNodesEventType_ClientAuditEntryId
    \value AuditAddNodesEventType_ClientUserId
    \value AuditDeleteNodesEventType_EventId
    \value AuditDeleteNodesEventType_EventType
    \value AuditDeleteNodesEventType_SourceNode
    \value AuditDeleteNodesEventType_SourceName
    \value AuditDeleteNodesEventType_Time
    \value AuditDeleteNodesEventType_ReceiveTime
    \value AuditDeleteNodesEventType_LocalTime
    \value AuditDeleteNodesEventType_Message
    \value AuditDeleteNodesEventType_Severity
    \value AuditDeleteNodesEventType_ActionTimeStamp
    \value AuditDeleteNodesEventType_Status
    \value AuditDeleteNodesEventType_ServerId
    \value AuditDeleteNodesEventType_ClientAuditEntryId
    \value AuditDeleteNodesEventType_ClientUserId
    \value AuditAddReferencesEventType_EventId
    \value AuditAddReferencesEventType_EventType
    \value AuditAddReferencesEventType_SourceNode
    \value AuditAddReferencesEventType_SourceName
    \value AuditAddReferencesEventType_Time
    \value AuditAddReferencesEventType_ReceiveTime
    \value AuditAddReferencesEventType_LocalTime
    \value AuditAddReferencesEventType_Message
    \value AuditAddReferencesEventType_Severity
    \value AuditAddReferencesEventType_ActionTimeStamp
    \value AuditAddReferencesEventType_Status
    \value AuditAddReferencesEventType_ServerId
    \value AuditAddReferencesEventType_ClientAuditEntryId
    \value AuditAddReferencesEventType_ClientUserId
    \value AuditDeleteReferencesEventType_EventId
    \value AuditDeleteReferencesEventType_EventType
    \value AuditDeleteReferencesEventType_SourceNode
    \value AuditDeleteReferencesEventType_SourceName
    \value AuditDeleteReferencesEventType_Time
    \value AuditDeleteReferencesEventType_ReceiveTime
    \value AuditDeleteReferencesEventType_LocalTime
    \value AuditDeleteReferencesEventType_Message
    \value AuditDeleteReferencesEventType_Severity
    \value AuditDeleteReferencesEventType_ActionTimeStamp
    \value AuditDeleteReferencesEventType_Status
    \value AuditDeleteReferencesEventType_ServerId
    \value AuditDeleteReferencesEventType_ClientAuditEntryId
    \value AuditDeleteReferencesEventType_ClientUserId
    \value AuditUpdateEventType_EventId
    \value AuditUpdateEventType_EventType
    \value AuditUpdateEventType_SourceNode
    \value AuditUpdateEventType_SourceName
    \value AuditUpdateEventType_Time
    \value AuditUpdateEventType_ReceiveTime
    \value AuditUpdateEventType_LocalTime
    \value AuditUpdateEventType_Message
    \value AuditUpdateEventType_Severity
    \value AuditUpdateEventType_ActionTimeStamp
    \value AuditUpdateEventType_Status
    \value AuditUpdateEventType_ServerId
    \value AuditUpdateEventType_ClientAuditEntryId
    \value AuditUpdateEventType_ClientUserId
    \value AuditWriteUpdateEventType_EventId
    \value AuditWriteUpdateEventType_EventType
    \value AuditWriteUpdateEventType_SourceNode
    \value AuditWriteUpdateEventType_SourceName
    \value AuditWriteUpdateEventType_Time
    \value AuditWriteUpdateEventType_ReceiveTime
    \value AuditWriteUpdateEventType_LocalTime
    \value AuditWriteUpdateEventType_Message
    \value AuditWriteUpdateEventType_Severity
    \value AuditWriteUpdateEventType_ActionTimeStamp
    \value AuditWriteUpdateEventType_Status
    \value AuditWriteUpdateEventType_ServerId
    \value AuditWriteUpdateEventType_ClientAuditEntryId
    \value AuditWriteUpdateEventType_ClientUserId
    \value AuditHistoryUpdateEventType_EventId
    \value AuditHistoryUpdateEventType_EventType
    \value AuditHistoryUpdateEventType_SourceNode
    \value AuditHistoryUpdateEventType_SourceName
    \value AuditHistoryUpdateEventType_Time
    \value AuditHistoryUpdateEventType_ReceiveTime
    \value AuditHistoryUpdateEventType_LocalTime
    \value AuditHistoryUpdateEventType_Message
    \value AuditHistoryUpdateEventType_Severity
    \value AuditHistoryUpdateEventType_ActionTimeStamp
    \value AuditHistoryUpdateEventType_Status
    \value AuditHistoryUpdateEventType_ServerId
    \value AuditHistoryUpdateEventType_ClientAuditEntryId
    \value AuditHistoryUpdateEventType_ClientUserId
    \value AuditHistoryEventUpdateEventType_EventId
    \value AuditHistoryEventUpdateEventType_EventType
    \value AuditHistoryEventUpdateEventType_SourceNode
    \value AuditHistoryEventUpdateEventType_SourceName
    \value AuditHistoryEventUpdateEventType_Time
    \value AuditHistoryEventUpdateEventType_ReceiveTime
    \value AuditHistoryEventUpdateEventType_LocalTime
    \value AuditHistoryEventUpdateEventType_Message
    \value AuditHistoryEventUpdateEventType_Severity
    \value AuditHistoryEventUpdateEventType_ActionTimeStamp
    \value AuditHistoryEventUpdateEventType_Status
    \value AuditHistoryEventUpdateEventType_ServerId
    \value AuditHistoryEventUpdateEventType_ClientAuditEntryId
    \value AuditHistoryEventUpdateEventType_ClientUserId
    \value AuditHistoryEventUpdateEventType_ParameterDataTypeId
    \value AuditHistoryValueUpdateEventType_EventId
    \value AuditHistoryValueUpdateEventType_EventType
    \value AuditHistoryValueUpdateEventType_SourceNode
    \value AuditHistoryValueUpdateEventType_SourceName
    \value AuditHistoryValueUpdateEventType_Time
    \value AuditHistoryValueUpdateEventType_ReceiveTime
    \value AuditHistoryValueUpdateEventType_LocalTime
    \value AuditHistoryValueUpdateEventType_Message
    \value AuditHistoryValueUpdateEventType_Severity
    \value AuditHistoryValueUpdateEventType_ActionTimeStamp
    \value AuditHistoryValueUpdateEventType_Status
    \value AuditHistoryValueUpdateEventType_ServerId
    \value AuditHistoryValueUpdateEventType_ClientAuditEntryId
    \value AuditHistoryValueUpdateEventType_ClientUserId
    \value AuditHistoryValueUpdateEventType_ParameterDataTypeId
    \value AuditHistoryDeleteEventType_EventId
    \value AuditHistoryDeleteEventType_EventType
    \value AuditHistoryDeleteEventType_SourceNode
    \value AuditHistoryDeleteEventType_SourceName
    \value AuditHistoryDeleteEventType_Time
    \value AuditHistoryDeleteEventType_ReceiveTime
    \value AuditHistoryDeleteEventType_LocalTime
    \value AuditHistoryDeleteEventType_Message
    \value AuditHistoryDeleteEventType_Severity
    \value AuditHistoryDeleteEventType_ActionTimeStamp
    \value AuditHistoryDeleteEventType_Status
    \value AuditHistoryDeleteEventType_ServerId
    \value AuditHistoryDeleteEventType_ClientAuditEntryId
    \value AuditHistoryDeleteEventType_ClientUserId
    \value AuditHistoryDeleteEventType_ParameterDataTypeId
    \value AuditHistoryRawModifyDeleteEventType_EventId
    \value AuditHistoryRawModifyDeleteEventType_EventType
    \value AuditHistoryRawModifyDeleteEventType_SourceNode
    \value AuditHistoryRawModifyDeleteEventType_SourceName
    \value AuditHistoryRawModifyDeleteEventType_Time
    \value AuditHistoryRawModifyDeleteEventType_ReceiveTime
    \value AuditHistoryRawModifyDeleteEventType_LocalTime
    \value AuditHistoryRawModifyDeleteEventType_Message
    \value AuditHistoryRawModifyDeleteEventType_Severity
    \value AuditHistoryRawModifyDeleteEventType_ActionTimeStamp
    \value AuditHistoryRawModifyDeleteEventType_Status
    \value AuditHistoryRawModifyDeleteEventType_ServerId
    \value AuditHistoryRawModifyDeleteEventType_ClientAuditEntryId
    \value AuditHistoryRawModifyDeleteEventType_ClientUserId
    \value AuditHistoryRawModifyDeleteEventType_ParameterDataTypeId
    \value AuditHistoryRawModifyDeleteEventType_UpdatedNode
    \value AuditHistoryAtTimeDeleteEventType_EventId
    \value AuditHistoryAtTimeDeleteEventType_EventType
    \value AuditHistoryAtTimeDeleteEventType_SourceNode
    \value AuditHistoryAtTimeDeleteEventType_SourceName
    \value AuditHistoryAtTimeDeleteEventType_Time
    \value AuditHistoryAtTimeDeleteEventType_ReceiveTime
    \value AuditHistoryAtTimeDeleteEventType_LocalTime
    \value AuditHistoryAtTimeDeleteEventType_Message
    \value AuditHistoryAtTimeDeleteEventType_Severity
    \value AuditHistoryAtTimeDeleteEventType_ActionTimeStamp
    \value AuditHistoryAtTimeDeleteEventType_Status
    \value AuditHistoryAtTimeDeleteEventType_ServerId
    \value AuditHistoryAtTimeDeleteEventType_ClientAuditEntryId
    \value AuditHistoryAtTimeDeleteEventType_ClientUserId
    \value AuditHistoryAtTimeDeleteEventType_ParameterDataTypeId
    \value AuditHistoryAtTimeDeleteEventType_UpdatedNode
    \value AuditHistoryEventDeleteEventType_EventId
    \value AuditHistoryEventDeleteEventType_EventType
    \value AuditHistoryEventDeleteEventType_SourceNode
    \value AuditHistoryEventDeleteEventType_SourceName
    \value AuditHistoryEventDeleteEventType_Time
    \value AuditHistoryEventDeleteEventType_ReceiveTime
    \value AuditHistoryEventDeleteEventType_LocalTime
    \value AuditHistoryEventDeleteEventType_Message
    \value AuditHistoryEventDeleteEventType_Severity
    \value AuditHistoryEventDeleteEventType_ActionTimeStamp
    \value AuditHistoryEventDeleteEventType_Status
    \value AuditHistoryEventDeleteEventType_ServerId
    \value AuditHistoryEventDeleteEventType_ClientAuditEntryId
    \value AuditHistoryEventDeleteEventType_ClientUserId
    \value AuditHistoryEventDeleteEventType_ParameterDataTypeId
    \value AuditHistoryEventDeleteEventType_UpdatedNode
    \value AuditUpdateMethodEventType_EventId
    \value AuditUpdateMethodEventType_EventType
    \value AuditUpdateMethodEventType_SourceNode
    \value AuditUpdateMethodEventType_SourceName
    \value AuditUpdateMethodEventType_Time
    \value AuditUpdateMethodEventType_ReceiveTime
    \value AuditUpdateMethodEventType_LocalTime
    \value AuditUpdateMethodEventType_Message
    \value AuditUpdateMethodEventType_Severity
    \value AuditUpdateMethodEventType_ActionTimeStamp
    \value AuditUpdateMethodEventType_Status
    \value AuditUpdateMethodEventType_ServerId
    \value AuditUpdateMethodEventType_ClientAuditEntryId
    \value AuditUpdateMethodEventType_ClientUserId
    \value SystemEventType_EventId
    \value SystemEventType_EventType
    \value SystemEventType_SourceNode
    \value SystemEventType_SourceName
    \value SystemEventType_Time
    \value SystemEventType_ReceiveTime
    \value SystemEventType_LocalTime
    \value SystemEventType_Message
    \value SystemEventType_Severity
    \value DeviceFailureEventType_EventId
    \value DeviceFailureEventType_EventType
    \value DeviceFailureEventType_SourceNode
    \value DeviceFailureEventType_SourceName
    \value DeviceFailureEventType_Time
    \value DeviceFailureEventType_ReceiveTime
    \value DeviceFailureEventType_LocalTime
    \value DeviceFailureEventType_Message
    \value DeviceFailureEventType_Severity
    \value BaseModelChangeEventType_EventId
    \value BaseModelChangeEventType_EventType
    \value BaseModelChangeEventType_SourceNode
    \value BaseModelChangeEventType_SourceName
    \value BaseModelChangeEventType_Time
    \value BaseModelChangeEventType_ReceiveTime
    \value BaseModelChangeEventType_LocalTime
    \value BaseModelChangeEventType_Message
    \value BaseModelChangeEventType_Severity
    \value GeneralModelChangeEventType_EventId
    \value GeneralModelChangeEventType_EventType
    \value GeneralModelChangeEventType_SourceNode
    \value GeneralModelChangeEventType_SourceName
    \value GeneralModelChangeEventType_Time
    \value GeneralModelChangeEventType_ReceiveTime
    \value GeneralModelChangeEventType_LocalTime
    \value GeneralModelChangeEventType_Message
    \value GeneralModelChangeEventType_Severity
    \value SemanticChangeEventType_EventId
    \value SemanticChangeEventType_EventType
    \value SemanticChangeEventType_SourceNode
    \value SemanticChangeEventType_SourceName
    \value SemanticChangeEventType_Time
    \value SemanticChangeEventType_ReceiveTime
    \value SemanticChangeEventType_LocalTime
    \value SemanticChangeEventType_Message
    \value SemanticChangeEventType_Severity
    \value ServerStatusType_BuildInfo_ProductUri
    \value ServerStatusType_BuildInfo_ManufacturerName
    \value ServerStatusType_BuildInfo_ProductName
    \value ServerStatusType_BuildInfo_SoftwareVersion
    \value ServerStatusType_BuildInfo_BuildNumber
    \value ServerStatusType_BuildInfo_BuildDate
    \value Server_ServerCapabilities_SoftwareCertificates
    \value Server_ServerDiagnostics_ServerDiagnosticsSummary_RejectedSessionCount
    \value Server_ServerDiagnostics_SessionsDiagnosticsSummary
    \value Server_ServerDiagnostics_SessionsDiagnosticsSummary_SessionDiagnosticsArray
    \value Server_ServerDiagnostics_SessionsDiagnosticsSummary_SessionSecurityDiagnosticsArray
    \value Server_ServerRedundancy_RedundancySupport
    \value FiniteStateVariableType_Name
    \value FiniteStateVariableType_Number
    \value FiniteStateVariableType_EffectiveDisplayName
    \value FiniteTransitionVariableType_Name
    \value FiniteTransitionVariableType_Number
    \value FiniteTransitionVariableType_TransitionTime
    \value StateMachineType_CurrentState_Id
    \value StateMachineType_CurrentState_Name
    \value StateMachineType_CurrentState_Number
    \value StateMachineType_CurrentState_EffectiveDisplayName
    \value StateMachineType_LastTransition_Id
    \value StateMachineType_LastTransition_Name
    \value StateMachineType_LastTransition_Number
    \value StateMachineType_LastTransition_TransitionTime
    \value FiniteStateMachineType_CurrentState_Id
    \value FiniteStateMachineType_CurrentState_Name
    \value FiniteStateMachineType_CurrentState_Number
    \value FiniteStateMachineType_CurrentState_EffectiveDisplayName
    \value FiniteStateMachineType_LastTransition_Id
    \value FiniteStateMachineType_LastTransition_Name
    \value FiniteStateMachineType_LastTransition_Number
    \value FiniteStateMachineType_LastTransition_TransitionTime
    \value InitialStateType_StateNumber
    \value TransitionEventType_EventId
    \value TransitionEventType_EventType
    \value TransitionEventType_SourceNode
    \value TransitionEventType_SourceName
    \value TransitionEventType_Time
    \value TransitionEventType_ReceiveTime
    \value TransitionEventType_LocalTime
    \value TransitionEventType_Message
    \value TransitionEventType_Severity
    \value TransitionEventType_FromState_Id
    \value TransitionEventType_FromState_Name
    \value TransitionEventType_FromState_Number
    \value TransitionEventType_FromState_EffectiveDisplayName
    \value TransitionEventType_ToState_Id
    \value TransitionEventType_ToState_Name
    \value TransitionEventType_ToState_Number
    \value TransitionEventType_ToState_EffectiveDisplayName
    \value TransitionEventType_Transition_Id
    \value TransitionEventType_Transition_Name
    \value TransitionEventType_Transition_Number
    \value TransitionEventType_Transition_TransitionTime
    \value AuditUpdateStateEventType_EventId
    \value AuditUpdateStateEventType_EventType
    \value AuditUpdateStateEventType_SourceNode
    \value AuditUpdateStateEventType_SourceName
    \value AuditUpdateStateEventType_Time
    \value AuditUpdateStateEventType_ReceiveTime
    \value AuditUpdateStateEventType_LocalTime
    \value AuditUpdateStateEventType_Message
    \value AuditUpdateStateEventType_Severity
    \value AuditUpdateStateEventType_ActionTimeStamp
    \value AuditUpdateStateEventType_Status
    \value AuditUpdateStateEventType_ServerId
    \value AuditUpdateStateEventType_ClientAuditEntryId
    \value AuditUpdateStateEventType_ClientUserId
    \value AuditUpdateStateEventType_MethodId
    \value AuditUpdateStateEventType_InputArguments
    \value AnalogItemType_Definition
    \value AnalogItemType_ValuePrecision
    \value DiscreteItemType_Definition
    \value DiscreteItemType_ValuePrecision
    \value TwoStateDiscreteType_Definition
    \value TwoStateDiscreteType_ValuePrecision
    \value MultiStateDiscreteType_Definition
    \value MultiStateDiscreteType_ValuePrecision
    \value ProgramTransitionEventType_EventId
    \value ProgramTransitionEventType_EventType
    \value ProgramTransitionEventType_SourceNode
    \value ProgramTransitionEventType_SourceName
    \value ProgramTransitionEventType_Time
    \value ProgramTransitionEventType_ReceiveTime
    \value ProgramTransitionEventType_LocalTime
    \value ProgramTransitionEventType_Message
    \value ProgramTransitionEventType_Severity
    \value ProgramTransitionEventType_FromState
    \value ProgramTransitionEventType_FromState_Id
    \value ProgramTransitionEventType_FromState_Name
    \value ProgramTransitionEventType_FromState_Number
    \value ProgramTransitionEventType_FromState_EffectiveDisplayName
    \value ProgramTransitionEventType_ToState
    \value ProgramTransitionEventType_ToState_Id
    \value ProgramTransitionEventType_ToState_Name
    \value ProgramTransitionEventType_ToState_Number
    \value ProgramTransitionEventType_ToState_EffectiveDisplayName
    \value ProgramTransitionEventType_Transition
    \value ProgramTransitionEventType_Transition_Id
    \value ProgramTransitionEventType_Transition_Name
    \value ProgramTransitionEventType_Transition_Number
    \value ProgramTransitionEventType_Transition_TransitionTime
    \value ProgramTransitionAuditEventType
    \value ProgramTransitionAuditEventType_EventId
    \value ProgramTransitionAuditEventType_EventType
    \value ProgramTransitionAuditEventType_SourceNode
    \value ProgramTransitionAuditEventType_SourceName
    \value ProgramTransitionAuditEventType_Time
    \value ProgramTransitionAuditEventType_ReceiveTime
    \value ProgramTransitionAuditEventType_LocalTime
    \value ProgramTransitionAuditEventType_Message
    \value ProgramTransitionAuditEventType_Severity
    \value ProgramTransitionAuditEventType_ActionTimeStamp
    \value ProgramTransitionAuditEventType_Status
    \value ProgramTransitionAuditEventType_ServerId
    \value ProgramTransitionAuditEventType_ClientAuditEntryId
    \value ProgramTransitionAuditEventType_ClientUserId
    \value ProgramTransitionAuditEventType_MethodId
    \value ProgramTransitionAuditEventType_InputArguments
    \value ProgramTransitionAuditEventType_OldStateId
    \value ProgramTransitionAuditEventType_NewStateId
    \value ProgramTransitionAuditEventType_Transition
    \value ProgramTransitionAuditEventType_Transition_Id
    \value ProgramTransitionAuditEventType_Transition_Name
    \value ProgramTransitionAuditEventType_Transition_Number
    \value ProgramTransitionAuditEventType_Transition_TransitionTime
    \value ProgramStateMachineType_CurrentState
    \value ProgramStateMachineType_CurrentState_Id
    \value ProgramStateMachineType_CurrentState_Name
    \value ProgramStateMachineType_CurrentState_Number
    \value ProgramStateMachineType_CurrentState_EffectiveDisplayName
    \value ProgramStateMachineType_LastTransition
    \value ProgramStateMachineType_LastTransition_Id
    \value ProgramStateMachineType_LastTransition_Name
    \value ProgramStateMachineType_LastTransition_Number
    \value ProgramStateMachineType_LastTransition_TransitionTime
    \value ProgramStateMachineType_ProgramDiagnostics_CreateSessionId
    \value ProgramStateMachineType_ProgramDiagnostics_CreateClientName
    \value ProgramStateMachineType_ProgramDiagnostics_InvocationCreationTime
    \value ProgramStateMachineType_ProgramDiagnostics_LastTransitionTime
    \value ProgramStateMachineType_ProgramDiagnostics_LastMethodCall
    \value ProgramStateMachineType_ProgramDiagnostics_LastMethodSessionId
    \value ProgramStateMachineType_ProgramDiagnostics_LastMethodInputArguments
    \value ProgramStateMachineType_ProgramDiagnostics_LastMethodOutputArguments
    \value ProgramStateMachineType_ProgramDiagnostics_LastMethodCallTime
    \value ProgramStateMachineType_ProgramDiagnostics_LastMethodReturnStatus
    \value ProgramStateMachineType_FinalResultData
    \value AddCommentMethodType
    \value AddCommentMethodType_InputArguments
    \value ConditionType_EventId
    \value ConditionType_EventType
    \value ConditionType_SourceNode
    \value ConditionType_SourceName
    \value ConditionType_Time
    \value ConditionType_ReceiveTime
    \value ConditionType_LocalTime
    \value ConditionType_Message
    \value ConditionType_Severity
    \value ConditionType_Retain
    \value ConditionType_ConditionRefresh
    \value ConditionType_ConditionRefresh_InputArguments
    \value RefreshStartEventType_EventId
    \value RefreshStartEventType_EventType
    \value RefreshStartEventType_SourceNode
    \value RefreshStartEventType_SourceName
    \value RefreshStartEventType_Time
    \value RefreshStartEventType_ReceiveTime
    \value RefreshStartEventType_LocalTime
    \value RefreshStartEventType_Message
    \value RefreshStartEventType_Severity
    \value RefreshEndEventType_EventId
    \value RefreshEndEventType_EventType
    \value RefreshEndEventType_SourceNode
    \value RefreshEndEventType_SourceName
    \value RefreshEndEventType_Time
    \value RefreshEndEventType_ReceiveTime
    \value RefreshEndEventType_LocalTime
    \value RefreshEndEventType_Message
    \value RefreshEndEventType_Severity
    \value RefreshRequiredEventType_EventId
    \value RefreshRequiredEventType_EventType
    \value RefreshRequiredEventType_SourceNode
    \value RefreshRequiredEventType_SourceName
    \value RefreshRequiredEventType_Time
    \value RefreshRequiredEventType_ReceiveTime
    \value RefreshRequiredEventType_LocalTime
    \value RefreshRequiredEventType_Message
    \value RefreshRequiredEventType_Severity
    \value AuditConditionEventType_EventId
    \value AuditConditionEventType_EventType
    \value AuditConditionEventType_SourceNode
    \value AuditConditionEventType_SourceName
    \value AuditConditionEventType_Time
    \value AuditConditionEventType_ReceiveTime
    \value AuditConditionEventType_LocalTime
    \value AuditConditionEventType_Message
    \value AuditConditionEventType_Severity
    \value AuditConditionEventType_ActionTimeStamp
    \value AuditConditionEventType_Status
    \value AuditConditionEventType_ServerId
    \value AuditConditionEventType_ClientAuditEntryId
    \value AuditConditionEventType_ClientUserId
    \value AuditConditionEventType_MethodId
    \value AuditConditionEventType_InputArguments
    \value AuditConditionEnableEventType_EventId
    \value AuditConditionEnableEventType_EventType
    \value AuditConditionEnableEventType_SourceNode
    \value AuditConditionEnableEventType_SourceName
    \value AuditConditionEnableEventType_Time
    \value AuditConditionEnableEventType_ReceiveTime
    \value AuditConditionEnableEventType_LocalTime
    \value AuditConditionEnableEventType_Message
    \value AuditConditionEnableEventType_Severity
    \value AuditConditionEnableEventType_ActionTimeStamp
    \value AuditConditionEnableEventType_Status
    \value AuditConditionEnableEventType_ServerId
    \value AuditConditionEnableEventType_ClientAuditEntryId
    \value AuditConditionEnableEventType_ClientUserId
    \value AuditConditionEnableEventType_MethodId
    \value AuditConditionEnableEventType_InputArguments
    \value AuditConditionCommentEventType_EventId
    \value AuditConditionCommentEventType_EventType
    \value AuditConditionCommentEventType_SourceNode
    \value AuditConditionCommentEventType_SourceName
    \value AuditConditionCommentEventType_Time
    \value AuditConditionCommentEventType_ReceiveTime
    \value AuditConditionCommentEventType_LocalTime
    \value AuditConditionCommentEventType_Message
    \value AuditConditionCommentEventType_Severity
    \value AuditConditionCommentEventType_ActionTimeStamp
    \value AuditConditionCommentEventType_Status
    \value AuditConditionCommentEventType_ServerId
    \value AuditConditionCommentEventType_ClientAuditEntryId
    \value AuditConditionCommentEventType_ClientUserId
    \value AuditConditionCommentEventType_MethodId
    \value AuditConditionCommentEventType_InputArguments
    \value DialogConditionType_EventId
    \value DialogConditionType_EventType
    \value DialogConditionType_SourceNode
    \value DialogConditionType_SourceName
    \value DialogConditionType_Time
    \value DialogConditionType_ReceiveTime
    \value DialogConditionType_LocalTime
    \value DialogConditionType_Message
    \value DialogConditionType_Severity
    \value DialogConditionType_Retain
    \value DialogConditionType_ConditionRefresh
    \value DialogConditionType_ConditionRefresh_InputArguments
    \value AcknowledgeableConditionType_EventId
    \value AcknowledgeableConditionType_EventType
    \value AcknowledgeableConditionType_SourceNode
    \value AcknowledgeableConditionType_SourceName
    \value AcknowledgeableConditionType_Time
    \value AcknowledgeableConditionType_ReceiveTime
    \value AcknowledgeableConditionType_LocalTime
    \value AcknowledgeableConditionType_Message
    \value AcknowledgeableConditionType_Severity
    \value AcknowledgeableConditionType_Retain
    \value AcknowledgeableConditionType_ConditionRefresh
    \value AcknowledgeableConditionType_ConditionRefresh_InputArguments
    \value AlarmConditionType_EventId
    \value AlarmConditionType_EventType
    \value AlarmConditionType_SourceNode
    \value AlarmConditionType_SourceName
    \value AlarmConditionType_Time
    \value AlarmConditionType_ReceiveTime
    \value AlarmConditionType_LocalTime
    \value AlarmConditionType_Message
    \value AlarmConditionType_Severity
    \value AlarmConditionType_Retain
    \value AlarmConditionType_ConditionRefresh
    \value AlarmConditionType_ConditionRefresh_InputArguments
    \value ShelvedStateMachineType_CurrentState
    \value ShelvedStateMachineType_CurrentState_Id
    \value ShelvedStateMachineType_CurrentState_Name
    \value ShelvedStateMachineType_CurrentState_Number
    \value ShelvedStateMachineType_CurrentState_EffectiveDisplayName
    \value ShelvedStateMachineType_LastTransition
    \value ShelvedStateMachineType_LastTransition_Id
    \value ShelvedStateMachineType_LastTransition_Name
    \value ShelvedStateMachineType_LastTransition_Number
    \value ShelvedStateMachineType_LastTransition_TransitionTime
    \value ShelvedStateMachineType_Unshelved_StateNumber
    \value ShelvedStateMachineType_TimedShelved_StateNumber
    \value ShelvedStateMachineType_OneShotShelved_StateNumber
    \value TimedShelveMethodType
    \value TimedShelveMethodType_InputArguments
    \value LimitAlarmType_EventId
    \value LimitAlarmType_EventType
    \value LimitAlarmType_SourceNode
    \value LimitAlarmType_SourceName
    \value LimitAlarmType_Time
    \value LimitAlarmType_ReceiveTime
    \value LimitAlarmType_LocalTime
    \value LimitAlarmType_Message
    \value LimitAlarmType_Severity
    \value LimitAlarmType_Retain
    \value LimitAlarmType_ConditionRefresh
    \value LimitAlarmType_ConditionRefresh_InputArguments
    \value IdType_EnumStrings
    \value EnumValueType
    \value MessageSecurityMode_EnumStrings
    \value UserTokenType_EnumStrings
    \value ApplicationType_EnumStrings
    \value SecurityTokenRequestType_EnumStrings
    \value BrowseDirection_EnumStrings
    \value FilterOperator_EnumStrings
    \value TimestampsToReturn_EnumStrings
    \value MonitoringMode_EnumStrings
    \value DataChangeTrigger_EnumStrings
    \value DeadbandType_EnumStrings
    \value RedundancySupport_EnumStrings
    \value ServerState_EnumStrings
    \value ExceptionDeviationFormat_EnumStrings
    \value EnumValueType_Encoding_DefaultXml
    \value OpcUa_BinarySchema
    \value OpcUa_BinarySchema_DataTypeVersion
    \value OpcUa_BinarySchema_NamespaceUri
    \value OpcUa_BinarySchema_Argument
    \value OpcUa_BinarySchema_Argument_DataTypeVersion
    \value OpcUa_BinarySchema_Argument_DictionaryFragment
    \value OpcUa_BinarySchema_EnumValueType
    \value OpcUa_BinarySchema_EnumValueType_DataTypeVersion
    \value OpcUa_BinarySchema_EnumValueType_DictionaryFragment
    \value OpcUa_BinarySchema_StatusResult
    \value OpcUa_BinarySchema_StatusResult_DataTypeVersion
    \value OpcUa_BinarySchema_StatusResult_DictionaryFragment
    \value OpcUa_BinarySchema_UserTokenPolicy
    \value OpcUa_BinarySchema_UserTokenPolicy_DataTypeVersion
    \value OpcUa_BinarySchema_UserTokenPolicy_DictionaryFragment
    \value OpcUa_BinarySchema_ApplicationDescription
    \value OpcUa_BinarySchema_ApplicationDescription_DataTypeVersion
    \value OpcUa_BinarySchema_ApplicationDescription_DictionaryFragment
    \value OpcUa_BinarySchema_EndpointDescription
    \value OpcUa_BinarySchema_EndpointDescription_DataTypeVersion
    \value OpcUa_BinarySchema_EndpointDescription_DictionaryFragment
    \value OpcUa_BinarySchema_UserIdentityToken
    \value OpcUa_BinarySchema_UserIdentityToken_DataTypeVersion
    \value OpcUa_BinarySchema_UserIdentityToken_DictionaryFragment
    \value OpcUa_BinarySchema_AnonymousIdentityToken
    \value OpcUa_BinarySchema_AnonymousIdentityToken_DataTypeVersion
    \value OpcUa_BinarySchema_AnonymousIdentityToken_DictionaryFragment
    \value OpcUa_BinarySchema_UserNameIdentityToken
    \value OpcUa_BinarySchema_UserNameIdentityToken_DataTypeVersion
    \value OpcUa_BinarySchema_UserNameIdentityToken_DictionaryFragment
    \value OpcUa_BinarySchema_X509IdentityToken
    \value OpcUa_BinarySchema_X509IdentityToken_DataTypeVersion
    \value OpcUa_BinarySchema_X509IdentityToken_DictionaryFragment
    \value OpcUa_BinarySchema_IssuedIdentityToken
    \value OpcUa_BinarySchema_IssuedIdentityToken_DataTypeVersion
    \value OpcUa_BinarySchema_IssuedIdentityToken_DictionaryFragment
    \value OpcUa_BinarySchema_EndpointConfiguration
    \value OpcUa_BinarySchema_EndpointConfiguration_DataTypeVersion
    \value OpcUa_BinarySchema_EndpointConfiguration_DictionaryFragment
    \value OpcUa_BinarySchema_BuildInfo
    \value OpcUa_BinarySchema_BuildInfo_DataTypeVersion
    \value OpcUa_BinarySchema_BuildInfo_DictionaryFragment
    \value OpcUa_BinarySchema_SignedSoftwareCertificate
    \value OpcUa_BinarySchema_SignedSoftwareCertificate_DataTypeVersion
    \value OpcUa_BinarySchema_SignedSoftwareCertificate_DictionaryFragment
    \value OpcUa_BinarySchema_AddNodesItem
    \value OpcUa_BinarySchema_AddNodesItem_DataTypeVersion
    \value OpcUa_BinarySchema_AddNodesItem_DictionaryFragment
    \value OpcUa_BinarySchema_AddReferencesItem
    \value OpcUa_BinarySchema_AddReferencesItem_DataTypeVersion
    \value OpcUa_BinarySchema_AddReferencesItem_DictionaryFragment
    \value OpcUa_BinarySchema_DeleteNodesItem
    \value OpcUa_BinarySchema_DeleteNodesItem_DataTypeVersion
    \value OpcUa_BinarySchema_DeleteNodesItem_DictionaryFragment
    \value OpcUa_BinarySchema_DeleteReferencesItem
    \value OpcUa_BinarySchema_DeleteReferencesItem_DataTypeVersion
    \value OpcUa_BinarySchema_DeleteReferencesItem_DictionaryFragment
    \value OpcUa_BinarySchema_RegisteredServer
    \value OpcUa_BinarySchema_RegisteredServer_DataTypeVersion
    \value OpcUa_BinarySchema_RegisteredServer_DictionaryFragment
    \value OpcUa_BinarySchema_ContentFilterElement
    \value OpcUa_BinarySchema_ContentFilterElement_DataTypeVersion
    \value OpcUa_BinarySchema_ContentFilterElement_DictionaryFragment
    \value OpcUa_BinarySchema_ContentFilter
    \value OpcUa_BinarySchema_ContentFilter_DataTypeVersion
    \value OpcUa_BinarySchema_ContentFilter_DictionaryFragment
    \value OpcUa_BinarySchema_FilterOperand
    \value OpcUa_BinarySchema_FilterOperand_DataTypeVersion
    \value OpcUa_BinarySchema_FilterOperand_DictionaryFragment
    \value OpcUa_BinarySchema_ElementOperand
    \value OpcUa_BinarySchema_ElementOperand_DataTypeVersion
    \value OpcUa_BinarySchema_ElementOperand_DictionaryFragment
    \value OpcUa_BinarySchema_LiteralOperand
    \value OpcUa_BinarySchema_LiteralOperand_DataTypeVersion
    \value OpcUa_BinarySchema_LiteralOperand_DictionaryFragment
    \value OpcUa_BinarySchema_AttributeOperand
    \value OpcUa_BinarySchema_AttributeOperand_DataTypeVersion
    \value OpcUa_BinarySchema_AttributeOperand_DictionaryFragment
    \value OpcUa_BinarySchema_SimpleAttributeOperand
    \value OpcUa_BinarySchema_SimpleAttributeOperand_DataTypeVersion
    \value OpcUa_BinarySchema_SimpleAttributeOperand_DictionaryFragment
    \value OpcUa_BinarySchema_HistoryEvent
    \value OpcUa_BinarySchema_HistoryEvent_DataTypeVersion
    \value OpcUa_BinarySchema_HistoryEvent_DictionaryFragment
    \value OpcUa_BinarySchema_MonitoringFilter
    \value OpcUa_BinarySchema_MonitoringFilter_DataTypeVersion
    \value OpcUa_BinarySchema_MonitoringFilter_DictionaryFragment
    \value OpcUa_BinarySchema_EventFilter
    \value OpcUa_BinarySchema_EventFilter_DataTypeVersion
    \value OpcUa_BinarySchema_EventFilter_DictionaryFragment
    \value OpcUa_BinarySchema_AggregateConfiguration
    \value OpcUa_BinarySchema_AggregateConfiguration_DataTypeVersion
    \value OpcUa_BinarySchema_AggregateConfiguration_DictionaryFragment
    \value OpcUa_BinarySchema_HistoryEventFieldList
    \value OpcUa_BinarySchema_HistoryEventFieldList_DataTypeVersion
    \value OpcUa_BinarySchema_HistoryEventFieldList_DictionaryFragment
    \value OpcUa_BinarySchema_RedundantServerDataType
    \value OpcUa_BinarySchema_RedundantServerDataType_DataTypeVersion
    \value OpcUa_BinarySchema_RedundantServerDataType_DictionaryFragment
    \value OpcUa_BinarySchema_SamplingIntervalDiagnosticsDataType
    \value OpcUa_BinarySchema_SamplingIntervalDiagnosticsDataType_DataTypeVersion
    \value OpcUa_BinarySchema_SamplingIntervalDiagnosticsDataType_DictionaryFragment
    \value OpcUa_BinarySchema_ServerDiagnosticsSummaryDataType
    \value OpcUa_BinarySchema_ServerDiagnosticsSummaryDataType_DataTypeVersion
    \value OpcUa_BinarySchema_ServerDiagnosticsSummaryDataType_DictionaryFragment
    \value OpcUa_BinarySchema_ServerStatusDataType
    \value OpcUa_BinarySchema_ServerStatusDataType_DataTypeVersion
    \value OpcUa_BinarySchema_ServerStatusDataType_DictionaryFragment
    \value OpcUa_BinarySchema_SessionDiagnosticsDataType
    \value OpcUa_BinarySchema_SessionDiagnosticsDataType_DataTypeVersion
    \value OpcUa_BinarySchema_SessionDiagnosticsDataType_DictionaryFragment
    \value OpcUa_BinarySchema_SessionSecurityDiagnosticsDataType
    \value OpcUa_BinarySchema_SessionSecurityDiagnosticsDataType_DataTypeVersion
    \value OpcUa_BinarySchema_SessionSecurityDiagnosticsDataType_DictionaryFragment
    \value OpcUa_BinarySchema_ServiceCounterDataType
    \value OpcUa_BinarySchema_ServiceCounterDataType_DataTypeVersion
    \value OpcUa_BinarySchema_ServiceCounterDataType_DictionaryFragment
    \value OpcUa_BinarySchema_SubscriptionDiagnosticsDataType
    \value OpcUa_BinarySchema_SubscriptionDiagnosticsDataType_DataTypeVersion
    \value OpcUa_BinarySchema_SubscriptionDiagnosticsDataType_DictionaryFragment
    \value OpcUa_BinarySchema_ModelChangeStructureDataType
    \value OpcUa_BinarySchema_ModelChangeStructureDataType_DataTypeVersion
    \value OpcUa_BinarySchema_ModelChangeStructureDataType_DictionaryFragment
    \value OpcUa_BinarySchema_SemanticChangeStructureDataType
    \value OpcUa_BinarySchema_SemanticChangeStructureDataType_DataTypeVersion
    \value OpcUa_BinarySchema_SemanticChangeStructureDataType_DictionaryFragment
    \value OpcUa_BinarySchema_Range
    \value OpcUa_BinarySchema_Range_DataTypeVersion
    \value OpcUa_BinarySchema_Range_DictionaryFragment
    \value OpcUa_BinarySchema_EUInformation
    \value OpcUa_BinarySchema_EUInformation_DataTypeVersion
    \value OpcUa_BinarySchema_EUInformation_DictionaryFragment
    \value OpcUa_BinarySchema_Annotation
    \value OpcUa_BinarySchema_Annotation_DataTypeVersion
    \value OpcUa_BinarySchema_Annotation_DictionaryFragment
    \value OpcUa_BinarySchema_ProgramDiagnosticDataType
    \value OpcUa_BinarySchema_ProgramDiagnosticDataType_DataTypeVersion
    \value OpcUa_BinarySchema_ProgramDiagnosticDataType_DictionaryFragment
    \value EnumValueType_Encoding_DefaultBinary
    \value OpcUa_XmlSchema
    \value OpcUa_XmlSchema_DataTypeVersion
    \value OpcUa_XmlSchema_NamespaceUri
    \value OpcUa_XmlSchema_Argument
    \value OpcUa_XmlSchema_Argument_DataTypeVersion
    \value OpcUa_XmlSchema_Argument_DictionaryFragment
    \value OpcUa_XmlSchema_EnumValueType
    \value OpcUa_XmlSchema_EnumValueType_DataTypeVersion
    \value OpcUa_XmlSchema_EnumValueType_DictionaryFragment
    \value OpcUa_XmlSchema_StatusResult
    \value OpcUa_XmlSchema_StatusResult_DataTypeVersion
    \value OpcUa_XmlSchema_StatusResult_DictionaryFragment
    \value OpcUa_XmlSchema_UserTokenPolicy
    \value OpcUa_XmlSchema_UserTokenPolicy_DataTypeVersion
    \value OpcUa_XmlSchema_UserTokenPolicy_DictionaryFragment
    \value OpcUa_XmlSchema_ApplicationDescription
    \value OpcUa_XmlSchema_ApplicationDescription_DataTypeVersion
    \value OpcUa_XmlSchema_ApplicationDescription_DictionaryFragment
    \value OpcUa_XmlSchema_EndpointDescription
    \value OpcUa_XmlSchema_EndpointDescription_DataTypeVersion
    \value OpcUa_XmlSchema_EndpointDescription_DictionaryFragment
    \value OpcUa_XmlSchema_UserIdentityToken
    \value OpcUa_XmlSchema_UserIdentityToken_DataTypeVersion
    \value OpcUa_XmlSchema_UserIdentityToken_DictionaryFragment
    \value OpcUa_XmlSchema_AnonymousIdentityToken
    \value OpcUa_XmlSchema_AnonymousIdentityToken_DataTypeVersion
    \value OpcUa_XmlSchema_AnonymousIdentityToken_DictionaryFragment
    \value OpcUa_XmlSchema_UserNameIdentityToken
    \value OpcUa_XmlSchema_UserNameIdentityToken_DataTypeVersion
    \value OpcUa_XmlSchema_UserNameIdentityToken_DictionaryFragment
    \value OpcUa_XmlSchema_X509IdentityToken
    \value OpcUa_XmlSchema_X509IdentityToken_DataTypeVersion
    \value OpcUa_XmlSchema_X509IdentityToken_DictionaryFragment
    \value OpcUa_XmlSchema_IssuedIdentityToken
    \value OpcUa_XmlSchema_IssuedIdentityToken_DataTypeVersion
    \value OpcUa_XmlSchema_IssuedIdentityToken_DictionaryFragment
    \value OpcUa_XmlSchema_EndpointConfiguration
    \value OpcUa_XmlSchema_EndpointConfiguration_DataTypeVersion
    \value OpcUa_XmlSchema_EndpointConfiguration_DictionaryFragment
    \value OpcUa_XmlSchema_BuildInfo
    \value OpcUa_XmlSchema_BuildInfo_DataTypeVersion
    \value OpcUa_XmlSchema_BuildInfo_DictionaryFragment
    \value OpcUa_XmlSchema_SignedSoftwareCertificate
    \value OpcUa_XmlSchema_SignedSoftwareCertificate_DataTypeVersion
    \value OpcUa_XmlSchema_SignedSoftwareCertificate_DictionaryFragment
    \value OpcUa_XmlSchema_AddNodesItem
    \value OpcUa_XmlSchema_AddNodesItem_DataTypeVersion
    \value OpcUa_XmlSchema_AddNodesItem_DictionaryFragment
    \value OpcUa_XmlSchema_AddReferencesItem
    \value OpcUa_XmlSchema_AddReferencesItem_DataTypeVersion
    \value OpcUa_XmlSchema_AddReferencesItem_DictionaryFragment
    \value OpcUa_XmlSchema_DeleteNodesItem
    \value OpcUa_XmlSchema_DeleteNodesItem_DataTypeVersion
    \value OpcUa_XmlSchema_DeleteNodesItem_DictionaryFragment
    \value OpcUa_XmlSchema_DeleteReferencesItem
    \value OpcUa_XmlSchema_DeleteReferencesItem_DataTypeVersion
    \value OpcUa_XmlSchema_DeleteReferencesItem_DictionaryFragment
    \value OpcUa_XmlSchema_RegisteredServer
    \value OpcUa_XmlSchema_RegisteredServer_DataTypeVersion
    \value OpcUa_XmlSchema_RegisteredServer_DictionaryFragment
    \value OpcUa_XmlSchema_ContentFilterElement
    \value OpcUa_XmlSchema_ContentFilterElement_DataTypeVersion
    \value OpcUa_XmlSchema_ContentFilterElement_DictionaryFragment
    \value OpcUa_XmlSchema_ContentFilter
    \value OpcUa_XmlSchema_ContentFilter_DataTypeVersion
    \value OpcUa_XmlSchema_ContentFilter_DictionaryFragment
    \value OpcUa_XmlSchema_FilterOperand
    \value OpcUa_XmlSchema_FilterOperand_DataTypeVersion
    \value OpcUa_XmlSchema_FilterOperand_DictionaryFragment
    \value OpcUa_XmlSchema_ElementOperand
    \value OpcUa_XmlSchema_ElementOperand_DataTypeVersion
    \value OpcUa_XmlSchema_ElementOperand_DictionaryFragment
    \value OpcUa_XmlSchema_LiteralOperand
    \value OpcUa_XmlSchema_LiteralOperand_DataTypeVersion
    \value OpcUa_XmlSchema_LiteralOperand_DictionaryFragment
    \value OpcUa_XmlSchema_AttributeOperand
    \value OpcUa_XmlSchema_AttributeOperand_DataTypeVersion
    \value OpcUa_XmlSchema_AttributeOperand_DictionaryFragment
    \value OpcUa_XmlSchema_SimpleAttributeOperand
    \value OpcUa_XmlSchema_SimpleAttributeOperand_DataTypeVersion
    \value OpcUa_XmlSchema_SimpleAttributeOperand_DictionaryFragment
    \value OpcUa_XmlSchema_HistoryEvent
    \value OpcUa_XmlSchema_HistoryEvent_DataTypeVersion
    \value OpcUa_XmlSchema_HistoryEvent_DictionaryFragment
    \value OpcUa_XmlSchema_MonitoringFilter
    \value OpcUa_XmlSchema_MonitoringFilter_DataTypeVersion
    \value OpcUa_XmlSchema_MonitoringFilter_DictionaryFragment
    \value OpcUa_XmlSchema_EventFilter
    \value OpcUa_XmlSchema_EventFilter_DataTypeVersion
    \value OpcUa_XmlSchema_EventFilter_DictionaryFragment
    \value OpcUa_XmlSchema_AggregateConfiguration
    \value OpcUa_XmlSchema_AggregateConfiguration_DataTypeVersion
    \value OpcUa_XmlSchema_AggregateConfiguration_DictionaryFragment
    \value OpcUa_XmlSchema_HistoryEventFieldList
    \value OpcUa_XmlSchema_HistoryEventFieldList_DataTypeVersion
    \value OpcUa_XmlSchema_HistoryEventFieldList_DictionaryFragment
    \value OpcUa_XmlSchema_RedundantServerDataType
    \value OpcUa_XmlSchema_RedundantServerDataType_DataTypeVersion
    \value OpcUa_XmlSchema_RedundantServerDataType_DictionaryFragment
    \value OpcUa_XmlSchema_SamplingIntervalDiagnosticsDataType
    \value OpcUa_XmlSchema_SamplingIntervalDiagnosticsDataType_DataTypeVersion
    \value OpcUa_XmlSchema_SamplingIntervalDiagnosticsDataType_DictionaryFragment
    \value OpcUa_XmlSchema_ServerDiagnosticsSummaryDataType
    \value OpcUa_XmlSchema_ServerDiagnosticsSummaryDataType_DataTypeVersion
    \value OpcUa_XmlSchema_ServerDiagnosticsSummaryDataType_DictionaryFragment
    \value OpcUa_XmlSchema_ServerStatusDataType
    \value OpcUa_XmlSchema_ServerStatusDataType_DataTypeVersion
    \value OpcUa_XmlSchema_ServerStatusDataType_DictionaryFragment
    \value OpcUa_XmlSchema_SessionDiagnosticsDataType
    \value OpcUa_XmlSchema_SessionDiagnosticsDataType_DataTypeVersion
    \value OpcUa_XmlSchema_SessionDiagnosticsDataType_DictionaryFragment
    \value OpcUa_XmlSchema_SessionSecurityDiagnosticsDataType
    \value OpcUa_XmlSchema_SessionSecurityDiagnosticsDataType_DataTypeVersion
    \value OpcUa_XmlSchema_SessionSecurityDiagnosticsDataType_DictionaryFragment
    \value OpcUa_XmlSchema_ServiceCounterDataType
    \value OpcUa_XmlSchema_ServiceCounterDataType_DataTypeVersion
    \value OpcUa_XmlSchema_ServiceCounterDataType_DictionaryFragment
    \value OpcUa_XmlSchema_SubscriptionDiagnosticsDataType
    \value OpcUa_XmlSchema_SubscriptionDiagnosticsDataType_DataTypeVersion
    \value OpcUa_XmlSchema_SubscriptionDiagnosticsDataType_DictionaryFragment
    \value OpcUa_XmlSchema_ModelChangeStructureDataType
    \value OpcUa_XmlSchema_ModelChangeStructureDataType_DataTypeVersion
    \value OpcUa_XmlSchema_ModelChangeStructureDataType_DictionaryFragment
    \value OpcUa_XmlSchema_SemanticChangeStructureDataType
    \value OpcUa_XmlSchema_SemanticChangeStructureDataType_DataTypeVersion
    \value OpcUa_XmlSchema_SemanticChangeStructureDataType_DictionaryFragment
    \value OpcUa_XmlSchema_Range
    \value OpcUa_XmlSchema_Range_DataTypeVersion
    \value OpcUa_XmlSchema_Range_DictionaryFragment
    \value OpcUa_XmlSchema_EUInformation
    \value OpcUa_XmlSchema_EUInformation_DataTypeVersion
    \value OpcUa_XmlSchema_EUInformation_DictionaryFragment
    \value OpcUa_XmlSchema_Annotation
    \value OpcUa_XmlSchema_Annotation_DataTypeVersion
    \value OpcUa_XmlSchema_Annotation_DictionaryFragment
    \value OpcUa_XmlSchema_ProgramDiagnosticDataType
    \value OpcUa_XmlSchema_ProgramDiagnosticDataType_DataTypeVersion
    \value OpcUa_XmlSchema_ProgramDiagnosticDataType_DictionaryFragment
    \value SubscriptionDiagnosticsType_MaxLifetimeCount
    \value SubscriptionDiagnosticsType_LatePublishRequestCount
    \value SubscriptionDiagnosticsType_CurrentKeepAliveCount
    \value SubscriptionDiagnosticsType_CurrentLifetimeCount
    \value SubscriptionDiagnosticsType_UnacknowledgedMessageCount
    \value SubscriptionDiagnosticsType_DiscardedMessageCount
    \value SubscriptionDiagnosticsType_MonitoredItemCount
    \value SubscriptionDiagnosticsType_DisabledMonitoredItemCount
    \value SubscriptionDiagnosticsType_MonitoringQueueOverflowCount
    \value SubscriptionDiagnosticsType_NextSequenceNumber
    \value SessionDiagnosticsObjectType_SessionDiagnostics_TotalRequestCount
    \value SessionDiagnosticsVariableType_TotalRequestCount
    \value SubscriptionDiagnosticsType_EventQueueOverFlowCount
    \value TimeZoneDataType
    \value TimeZoneDataType_Encoding_DefaultXml
    \value OpcUa_BinarySchema_TimeZoneDataType
    \value OpcUa_BinarySchema_TimeZoneDataType_DataTypeVersion
    \value OpcUa_BinarySchema_TimeZoneDataType_DictionaryFragment
    \value TimeZoneDataType_Encoding_DefaultBinary
    \value OpcUa_XmlSchema_TimeZoneDataType
    \value OpcUa_XmlSchema_TimeZoneDataType_DataTypeVersion
    \value OpcUa_XmlSchema_TimeZoneDataType_DictionaryFragment
    \value AuditConditionRespondEventType
    \value AuditConditionRespondEventType_EventId
    \value AuditConditionRespondEventType_EventType
    \value AuditConditionRespondEventType_SourceNode
    \value AuditConditionRespondEventType_SourceName
    \value AuditConditionRespondEventType_Time
    \value AuditConditionRespondEventType_ReceiveTime
    \value AuditConditionRespondEventType_LocalTime
    \value AuditConditionRespondEventType_Message
    \value AuditConditionRespondEventType_Severity
    \value AuditConditionRespondEventType_ActionTimeStamp
    \value AuditConditionRespondEventType_Status
    \value AuditConditionRespondEventType_ServerId
    \value AuditConditionRespondEventType_ClientAuditEntryId
    \value AuditConditionRespondEventType_ClientUserId
    \value AuditConditionRespondEventType_MethodId
    \value AuditConditionRespondEventType_InputArguments
    \value AuditConditionAcknowledgeEventType
    \value AuditConditionAcknowledgeEventType_EventId
    \value AuditConditionAcknowledgeEventType_EventType
    \value AuditConditionAcknowledgeEventType_SourceNode
    \value AuditConditionAcknowledgeEventType_SourceName
    \value AuditConditionAcknowledgeEventType_Time
    \value AuditConditionAcknowledgeEventType_ReceiveTime
    \value AuditConditionAcknowledgeEventType_LocalTime
    \value AuditConditionAcknowledgeEventType_Message
    \value AuditConditionAcknowledgeEventType_Severity
    \value AuditConditionAcknowledgeEventType_ActionTimeStamp
    \value AuditConditionAcknowledgeEventType_Status
    \value AuditConditionAcknowledgeEventType_ServerId
    \value AuditConditionAcknowledgeEventType_ClientAuditEntryId
    \value AuditConditionAcknowledgeEventType_ClientUserId
    \value AuditConditionAcknowledgeEventType_MethodId
    \value AuditConditionAcknowledgeEventType_InputArguments
    \value AuditConditionConfirmEventType
    \value AuditConditionConfirmEventType_EventId
    \value AuditConditionConfirmEventType_EventType
    \value AuditConditionConfirmEventType_SourceNode
    \value AuditConditionConfirmEventType_SourceName
    \value AuditConditionConfirmEventType_Time
    \value AuditConditionConfirmEventType_ReceiveTime
    \value AuditConditionConfirmEventType_LocalTime
    \value AuditConditionConfirmEventType_Message
    \value AuditConditionConfirmEventType_Severity
    \value AuditConditionConfirmEventType_ActionTimeStamp
    \value AuditConditionConfirmEventType_Status
    \value AuditConditionConfirmEventType_ServerId
    \value AuditConditionConfirmEventType_ClientAuditEntryId
    \value AuditConditionConfirmEventType_ClientUserId
    \value AuditConditionConfirmEventType_MethodId
    \value AuditConditionConfirmEventType_InputArguments
    \value TwoStateVariableType
    \value TwoStateVariableType_Id
    \value TwoStateVariableType_Name
    \value TwoStateVariableType_Number
    \value TwoStateVariableType_EffectiveDisplayName
    \value TwoStateVariableType_TransitionTime
    \value TwoStateVariableType_EffectiveTransitionTime
    \value ConditionVariableType
    \value ConditionVariableType_SourceTimestamp
    \value HasTrueSubState
    \value HasFalseSubState
    \value HasCondition
    \value ConditionRefreshMethodType
    \value ConditionRefreshMethodType_InputArguments
    \value ConditionType_ConditionName
    \value ConditionType_BranchId
    \value ConditionType_EnabledState
    \value ConditionType_EnabledState_Id
    \value ConditionType_EnabledState_Name
    \value ConditionType_EnabledState_Number
    \value ConditionType_EnabledState_EffectiveDisplayName
    \value ConditionType_EnabledState_TransitionTime
    \value ConditionType_EnabledState_EffectiveTransitionTime
    \value ConditionType_EnabledState_TrueState
    \value ConditionType_EnabledState_FalseState
    \value ConditionType_Quality
    \value ConditionType_Quality_SourceTimestamp
    \value ConditionType_LastSeverity
    \value ConditionType_LastSeverity_SourceTimestamp
    \value ConditionType_Comment
    \value ConditionType_Comment_SourceTimestamp
    \value ConditionType_ClientUserId
    \value ConditionType_Enable
    \value ConditionType_Disable
    \value ConditionType_AddComment
    \value ConditionType_AddComment_InputArguments
    \value DialogResponseMethodType
    \value DialogResponseMethodType_InputArguments
    \value DialogConditionType_ConditionName
    \value DialogConditionType_BranchId
    \value DialogConditionType_EnabledState
    \value DialogConditionType_EnabledState_Id
    \value DialogConditionType_EnabledState_Name
    \value DialogConditionType_EnabledState_Number
    \value DialogConditionType_EnabledState_EffectiveDisplayName
    \value DialogConditionType_EnabledState_TransitionTime
    \value DialogConditionType_EnabledState_EffectiveTransitionTime
    \value DialogConditionType_EnabledState_TrueState
    \value DialogConditionType_EnabledState_FalseState
    \value DialogConditionType_Quality
    \value DialogConditionType_Quality_SourceTimestamp
    \value DialogConditionType_LastSeverity
    \value DialogConditionType_LastSeverity_SourceTimestamp
    \value DialogConditionType_Comment
    \value DialogConditionType_Comment_SourceTimestamp
    \value DialogConditionType_ClientUserId
    \value DialogConditionType_Enable
    \value DialogConditionType_Disable
    \value DialogConditionType_AddComment
    \value DialogConditionType_AddComment_InputArguments
    \value DialogConditionType_DialogState
    \value DialogConditionType_DialogState_Id
    \value DialogConditionType_DialogState_Name
    \value DialogConditionType_DialogState_Number
    \value DialogConditionType_DialogState_EffectiveDisplayName
    \value DialogConditionType_DialogState_TransitionTime
    \value DialogConditionType_DialogState_EffectiveTransitionTime
    \value DialogConditionType_DialogState_TrueState
    \value DialogConditionType_DialogState_FalseState
    \value DialogConditionType_ResponseOptionSet
    \value DialogConditionType_DefaultResponse
    \value DialogConditionType_OkResponse
    \value DialogConditionType_CancelResponse
    \value DialogConditionType_LastResponse
    \value DialogConditionType_Respond
    \value DialogConditionType_Respond_InputArguments
    \value AcknowledgeableConditionType_ConditionName
    \value AcknowledgeableConditionType_BranchId
    \value AcknowledgeableConditionType_EnabledState
    \value AcknowledgeableConditionType_EnabledState_Id
    \value AcknowledgeableConditionType_EnabledState_Name
    \value AcknowledgeableConditionType_EnabledState_Number
    \value AcknowledgeableConditionType_EnabledState_EffectiveDisplayName
    \value AcknowledgeableConditionType_EnabledState_TransitionTime
    \value AcknowledgeableConditionType_EnabledState_EffectiveTransitionTime
    \value AcknowledgeableConditionType_EnabledState_TrueState
    \value AcknowledgeableConditionType_EnabledState_FalseState
    \value AcknowledgeableConditionType_Quality
    \value AcknowledgeableConditionType_Quality_SourceTimestamp
    \value AcknowledgeableConditionType_LastSeverity
    \value AcknowledgeableConditionType_LastSeverity_SourceTimestamp
    \value AcknowledgeableConditionType_Comment
    \value AcknowledgeableConditionType_Comment_SourceTimestamp
    \value AcknowledgeableConditionType_ClientUserId
    \value AcknowledgeableConditionType_Enable
    \value AcknowledgeableConditionType_Disable
    \value AcknowledgeableConditionType_AddComment
    \value AcknowledgeableConditionType_AddComment_InputArguments
    \value AcknowledgeableConditionType_AckedState
    \value AcknowledgeableConditionType_AckedState_Id
    \value AcknowledgeableConditionType_AckedState_Name
    \value AcknowledgeableConditionType_AckedState_Number
    \value AcknowledgeableConditionType_AckedState_EffectiveDisplayName
    \value AcknowledgeableConditionType_AckedState_TransitionTime
    \value AcknowledgeableConditionType_AckedState_EffectiveTransitionTime
    \value AcknowledgeableConditionType_AckedState_TrueState
    \value AcknowledgeableConditionType_AckedState_FalseState
    \value AcknowledgeableConditionType_ConfirmedState
    \value AcknowledgeableConditionType_ConfirmedState_Id
    \value AcknowledgeableConditionType_ConfirmedState_Name
    \value AcknowledgeableConditionType_ConfirmedState_Number
    \value AcknowledgeableConditionType_ConfirmedState_EffectiveDisplayName
    \value AcknowledgeableConditionType_ConfirmedState_TransitionTime
    \value AcknowledgeableConditionType_ConfirmedState_EffectiveTransitionTime
    \value AcknowledgeableConditionType_ConfirmedState_TrueState
    \value AcknowledgeableConditionType_ConfirmedState_FalseState
    \value AcknowledgeableConditionType_Acknowledge
    \value AcknowledgeableConditionType_Acknowledge_InputArguments
    \value AcknowledgeableConditionType_Confirm
    \value AcknowledgeableConditionType_Confirm_InputArguments
    \value ShelvedStateMachineType_UnshelveTime
    \value AlarmConditionType_ConditionName
    \value AlarmConditionType_BranchId
    \value AlarmConditionType_EnabledState
    \value AlarmConditionType_EnabledState_Id
    \value AlarmConditionType_EnabledState_Name
    \value AlarmConditionType_EnabledState_Number
    \value AlarmConditionType_EnabledState_EffectiveDisplayName
    \value AlarmConditionType_EnabledState_TransitionTime
    \value AlarmConditionType_EnabledState_EffectiveTransitionTime
    \value AlarmConditionType_EnabledState_TrueState
    \value AlarmConditionType_EnabledState_FalseState
    \value AlarmConditionType_Quality
    \value AlarmConditionType_Quality_SourceTimestamp
    \value AlarmConditionType_LastSeverity
    \value AlarmConditionType_LastSeverity_SourceTimestamp
    \value AlarmConditionType_Comment
    \value AlarmConditionType_Comment_SourceTimestamp
    \value AlarmConditionType_ClientUserId
    \value AlarmConditionType_Enable
    \value AlarmConditionType_Disable
    \value AlarmConditionType_AddComment
    \value AlarmConditionType_AddComment_InputArguments
    \value AlarmConditionType_AckedState
    \value AlarmConditionType_AckedState_Id
    \value AlarmConditionType_AckedState_Name
    \value AlarmConditionType_AckedState_Number
    \value AlarmConditionType_AckedState_EffectiveDisplayName
    \value AlarmConditionType_AckedState_TransitionTime
    \value AlarmConditionType_AckedState_EffectiveTransitionTime
    \value AlarmConditionType_AckedState_TrueState
    \value AlarmConditionType_AckedState_FalseState
    \value AlarmConditionType_ConfirmedState
    \value AlarmConditionType_ConfirmedState_Id
    \value AlarmConditionType_ConfirmedState_Name
    \value AlarmConditionType_ConfirmedState_Number
    \value AlarmConditionType_ConfirmedState_EffectiveDisplayName
    \value AlarmConditionType_ConfirmedState_TransitionTime
    \value AlarmConditionType_ConfirmedState_EffectiveTransitionTime
    \value AlarmConditionType_ConfirmedState_TrueState
    \value AlarmConditionType_ConfirmedState_FalseState
    \value AlarmConditionType_Acknowledge
    \value AlarmConditionType_Acknowledge_InputArguments
    \value AlarmConditionType_Confirm
    \value AlarmConditionType_Confirm_InputArguments
    \value AlarmConditionType_ActiveState
    \value AlarmConditionType_ActiveState_Id
    \value AlarmConditionType_ActiveState_Name
    \value AlarmConditionType_ActiveState_Number
    \value AlarmConditionType_ActiveState_EffectiveDisplayName
    \value AlarmConditionType_ActiveState_TransitionTime
    \value AlarmConditionType_ActiveState_EffectiveTransitionTime
    \value AlarmConditionType_ActiveState_TrueState
    \value AlarmConditionType_ActiveState_FalseState
    \value AlarmConditionType_SuppressedState
    \value AlarmConditionType_SuppressedState_Id
    \value AlarmConditionType_SuppressedState_Name
    \value AlarmConditionType_SuppressedState_Number
    \value AlarmConditionType_SuppressedState_EffectiveDisplayName
    \value AlarmConditionType_SuppressedState_TransitionTime
    \value AlarmConditionType_SuppressedState_EffectiveTransitionTime
    \value AlarmConditionType_SuppressedState_TrueState
    \value AlarmConditionType_SuppressedState_FalseState
    \value AlarmConditionType_ShelvingState
    \value AlarmConditionType_ShelvingState_CurrentState
    \value AlarmConditionType_ShelvingState_CurrentState_Id
    \value AlarmConditionType_ShelvingState_CurrentState_Name
    \value AlarmConditionType_ShelvingState_CurrentState_Number
    \value AlarmConditionType_ShelvingState_CurrentState_EffectiveDisplayName
    \value AlarmConditionType_ShelvingState_LastTransition
    \value AlarmConditionType_ShelvingState_LastTransition_Id
    \value AlarmConditionType_ShelvingState_LastTransition_Name
    \value AlarmConditionType_ShelvingState_LastTransition_Number
    \value AlarmConditionType_ShelvingState_LastTransition_TransitionTime
    \value AlarmConditionType_ShelvingState_UnshelveTime
    \value AlarmConditionType_ShelvingState_Unshelve
    \value AlarmConditionType_ShelvingState_OneShotShelve
    \value AlarmConditionType_ShelvingState_TimedShelve
    \value AlarmConditionType_ShelvingState_TimedShelve_InputArguments
    \value AlarmConditionType_SuppressedOrShelved
    \value AlarmConditionType_MaxTimeShelved
    \value LimitAlarmType_ConditionName
    \value LimitAlarmType_BranchId
    \value LimitAlarmType_EnabledState
    \value LimitAlarmType_EnabledState_Id
    \value LimitAlarmType_EnabledState_Name
    \value LimitAlarmType_EnabledState_Number
    \value LimitAlarmType_EnabledState_EffectiveDisplayName
    \value LimitAlarmType_EnabledState_TransitionTime
    \value LimitAlarmType_EnabledState_EffectiveTransitionTime
    \value LimitAlarmType_EnabledState_TrueState
    \value LimitAlarmType_EnabledState_FalseState
    \value LimitAlarmType_Quality
    \value LimitAlarmType_Quality_SourceTimestamp
    \value LimitAlarmType_LastSeverity
    \value LimitAlarmType_LastSeverity_SourceTimestamp
    \value LimitAlarmType_Comment
    \value LimitAlarmType_Comment_SourceTimestamp
    \value LimitAlarmType_ClientUserId
    \value LimitAlarmType_Enable
    \value LimitAlarmType_Disable
    \value LimitAlarmType_AddComment
    \value LimitAlarmType_AddComment_InputArguments
    \value LimitAlarmType_AckedState
    \value LimitAlarmType_AckedState_Id
    \value LimitAlarmType_AckedState_Name
    \value LimitAlarmType_AckedState_Number
    \value LimitAlarmType_AckedState_EffectiveDisplayName
    \value LimitAlarmType_AckedState_TransitionTime
    \value LimitAlarmType_AckedState_EffectiveTransitionTime
    \value LimitAlarmType_AckedState_TrueState
    \value LimitAlarmType_AckedState_FalseState
    \value LimitAlarmType_ConfirmedState
    \value LimitAlarmType_ConfirmedState_Id
    \value LimitAlarmType_ConfirmedState_Name
    \value LimitAlarmType_ConfirmedState_Number
    \value LimitAlarmType_ConfirmedState_EffectiveDisplayName
    \value LimitAlarmType_ConfirmedState_TransitionTime
    \value LimitAlarmType_ConfirmedState_EffectiveTransitionTime
    \value LimitAlarmType_ConfirmedState_TrueState
    \value LimitAlarmType_ConfirmedState_FalseState
    \value LimitAlarmType_Acknowledge
    \value LimitAlarmType_Acknowledge_InputArguments
    \value LimitAlarmType_Confirm
    \value LimitAlarmType_Confirm_InputArguments
    \value LimitAlarmType_ActiveState
    \value LimitAlarmType_ActiveState_Id
    \value LimitAlarmType_ActiveState_Name
    \value LimitAlarmType_ActiveState_Number
    \value LimitAlarmType_ActiveState_EffectiveDisplayName
    \value LimitAlarmType_ActiveState_TransitionTime
    \value LimitAlarmType_ActiveState_EffectiveTransitionTime
    \value LimitAlarmType_ActiveState_TrueState
    \value LimitAlarmType_ActiveState_FalseState
    \value LimitAlarmType_SuppressedState
    \value LimitAlarmType_SuppressedState_Id
    \value LimitAlarmType_SuppressedState_Name
    \value LimitAlarmType_SuppressedState_Number
    \value LimitAlarmType_SuppressedState_EffectiveDisplayName
    \value LimitAlarmType_SuppressedState_TransitionTime
    \value LimitAlarmType_SuppressedState_EffectiveTransitionTime
    \value LimitAlarmType_SuppressedState_TrueState
    \value LimitAlarmType_SuppressedState_FalseState
    \value LimitAlarmType_ShelvingState
    \value LimitAlarmType_ShelvingState_CurrentState
    \value LimitAlarmType_ShelvingState_CurrentState_Id
    \value LimitAlarmType_ShelvingState_CurrentState_Name
    \value LimitAlarmType_ShelvingState_CurrentState_Number
    \value LimitAlarmType_ShelvingState_CurrentState_EffectiveDisplayName
    \value LimitAlarmType_ShelvingState_LastTransition
    \value LimitAlarmType_ShelvingState_LastTransition_Id
    \value LimitAlarmType_ShelvingState_LastTransition_Name
    \value LimitAlarmType_ShelvingState_LastTransition_Number
    \value LimitAlarmType_ShelvingState_LastTransition_TransitionTime
    \value LimitAlarmType_ShelvingState_UnshelveTime
    \value LimitAlarmType_ShelvingState_Unshelve
    \value LimitAlarmType_ShelvingState_OneShotShelve
    \value LimitAlarmType_ShelvingState_TimedShelve
    \value LimitAlarmType_ShelvingState_TimedShelve_InputArguments
    \value LimitAlarmType_SuppressedOrShelved
    \value LimitAlarmType_MaxTimeShelved
    \value ExclusiveLimitStateMachineType
    \value ExclusiveLimitStateMachineType_CurrentState
    \value ExclusiveLimitStateMachineType_CurrentState_Id
    \value ExclusiveLimitStateMachineType_CurrentState_Name
    \value ExclusiveLimitStateMachineType_CurrentState_Number
    \value ExclusiveLimitStateMachineType_CurrentState_EffectiveDisplayName
    \value ExclusiveLimitStateMachineType_LastTransition
    \value ExclusiveLimitStateMachineType_LastTransition_Id
    \value ExclusiveLimitStateMachineType_LastTransition_Name
    \value ExclusiveLimitStateMachineType_LastTransition_Number
    \value ExclusiveLimitStateMachineType_LastTransition_TransitionTime
    \value ExclusiveLimitStateMachineType_HighHigh
    \value ExclusiveLimitStateMachineType_HighHigh_StateNumber
    \value ExclusiveLimitStateMachineType_High
    \value ExclusiveLimitStateMachineType_High_StateNumber
    \value ExclusiveLimitStateMachineType_Low
    \value ExclusiveLimitStateMachineType_Low_StateNumber
    \value ExclusiveLimitStateMachineType_LowLow
    \value ExclusiveLimitStateMachineType_LowLow_StateNumber
    \value ExclusiveLimitStateMachineType_LowLowToLow
    \value ExclusiveLimitStateMachineType_LowToLowLow
    \value ExclusiveLimitStateMachineType_HighHighToHigh
    \value ExclusiveLimitStateMachineType_HighToHighHigh
    \value ExclusiveLimitAlarmType
    \value ExclusiveLimitAlarmType_EventId
    \value ExclusiveLimitAlarmType_EventType
    \value ExclusiveLimitAlarmType_SourceNode
    \value ExclusiveLimitAlarmType_SourceName
    \value ExclusiveLimitAlarmType_Time
    \value ExclusiveLimitAlarmType_ReceiveTime
    \value ExclusiveLimitAlarmType_LocalTime
    \value ExclusiveLimitAlarmType_Message
    \value ExclusiveLimitAlarmType_Severity
    \value ExclusiveLimitAlarmType_ConditionName
    \value ExclusiveLimitAlarmType_BranchId
    \value ExclusiveLimitAlarmType_Retain
    \value ExclusiveLimitAlarmType_EnabledState
    \value ExclusiveLimitAlarmType_EnabledState_Id
    \value ExclusiveLimitAlarmType_EnabledState_Name
    \value ExclusiveLimitAlarmType_EnabledState_Number
    \value ExclusiveLimitAlarmType_EnabledState_EffectiveDisplayName
    \value ExclusiveLimitAlarmType_EnabledState_TransitionTime
    \value ExclusiveLimitAlarmType_EnabledState_EffectiveTransitionTime
    \value ExclusiveLimitAlarmType_EnabledState_TrueState
    \value ExclusiveLimitAlarmType_EnabledState_FalseState
    \value ExclusiveLimitAlarmType_Quality
    \value ExclusiveLimitAlarmType_Quality_SourceTimestamp
    \value ExclusiveLimitAlarmType_LastSeverity
    \value ExclusiveLimitAlarmType_LastSeverity_SourceTimestamp
    \value ExclusiveLimitAlarmType_Comment
    \value ExclusiveLimitAlarmType_Comment_SourceTimestamp
    \value ExclusiveLimitAlarmType_ClientUserId
    \value ExclusiveLimitAlarmType_Enable
    \value ExclusiveLimitAlarmType_Disable
    \value ExclusiveLimitAlarmType_AddComment
    \value ExclusiveLimitAlarmType_AddComment_InputArguments
    \value ExclusiveLimitAlarmType_ConditionRefresh
    \value ExclusiveLimitAlarmType_ConditionRefresh_InputArguments
    \value ExclusiveLimitAlarmType_AckedState
    \value ExclusiveLimitAlarmType_AckedState_Id
    \value ExclusiveLimitAlarmType_AckedState_Name
    \value ExclusiveLimitAlarmType_AckedState_Number
    \value ExclusiveLimitAlarmType_AckedState_EffectiveDisplayName
    \value ExclusiveLimitAlarmType_AckedState_TransitionTime
    \value ExclusiveLimitAlarmType_AckedState_EffectiveTransitionTime
    \value ExclusiveLimitAlarmType_AckedState_TrueState
    \value ExclusiveLimitAlarmType_AckedState_FalseState
    \value ExclusiveLimitAlarmType_ConfirmedState
    \value ExclusiveLimitAlarmType_ConfirmedState_Id
    \value ExclusiveLimitAlarmType_ConfirmedState_Name
    \value ExclusiveLimitAlarmType_ConfirmedState_Number
    \value ExclusiveLimitAlarmType_ConfirmedState_EffectiveDisplayName
    \value ExclusiveLimitAlarmType_ConfirmedState_TransitionTime
    \value ExclusiveLimitAlarmType_ConfirmedState_EffectiveTransitionTime
    \value ExclusiveLimitAlarmType_ConfirmedState_TrueState
    \value ExclusiveLimitAlarmType_ConfirmedState_FalseState
    \value ExclusiveLimitAlarmType_Acknowledge
    \value ExclusiveLimitAlarmType_Acknowledge_InputArguments
    \value ExclusiveLimitAlarmType_Confirm
    \value ExclusiveLimitAlarmType_Confirm_InputArguments
    \value ExclusiveLimitAlarmType_ActiveState
    \value ExclusiveLimitAlarmType_ActiveState_Id
    \value ExclusiveLimitAlarmType_ActiveState_Name
    \value ExclusiveLimitAlarmType_ActiveState_Number
    \value ExclusiveLimitAlarmType_ActiveState_EffectiveDisplayName
    \value ExclusiveLimitAlarmType_ActiveState_TransitionTime
    \value ExclusiveLimitAlarmType_ActiveState_EffectiveTransitionTime
    \value ExclusiveLimitAlarmType_ActiveState_TrueState
    \value ExclusiveLimitAlarmType_ActiveState_FalseState
    \value ExclusiveLimitAlarmType_SuppressedState
    \value ExclusiveLimitAlarmType_SuppressedState_Id
    \value ExclusiveLimitAlarmType_SuppressedState_Name
    \value ExclusiveLimitAlarmType_SuppressedState_Number
    \value ExclusiveLimitAlarmType_SuppressedState_EffectiveDisplayName
    \value ExclusiveLimitAlarmType_SuppressedState_TransitionTime
    \value ExclusiveLimitAlarmType_SuppressedState_EffectiveTransitionTime
    \value ExclusiveLimitAlarmType_SuppressedState_TrueState
    \value ExclusiveLimitAlarmType_SuppressedState_FalseState
    \value ExclusiveLimitAlarmType_ShelvingState
    \value ExclusiveLimitAlarmType_ShelvingState_CurrentState
    \value ExclusiveLimitAlarmType_ShelvingState_CurrentState_Id
    \value ExclusiveLimitAlarmType_ShelvingState_CurrentState_Name
    \value ExclusiveLimitAlarmType_ShelvingState_CurrentState_Number
    \value ExclusiveLimitAlarmType_ShelvingState_CurrentState_EffectiveDisplayName
    \value ExclusiveLimitAlarmType_ShelvingState_LastTransition
    \value ExclusiveLimitAlarmType_ShelvingState_LastTransition_Id
    \value ExclusiveLimitAlarmType_ShelvingState_LastTransition_Name
    \value ExclusiveLimitAlarmType_ShelvingState_LastTransition_Number
    \value ExclusiveLimitAlarmType_ShelvingState_LastTransition_TransitionTime
    \value ExclusiveLimitAlarmType_ShelvingState_UnshelveTime
    \value ExclusiveLimitAlarmType_ShelvingState_Unshelve
    \value ExclusiveLimitAlarmType_ShelvingState_OneShotShelve
    \value ExclusiveLimitAlarmType_ShelvingState_TimedShelve
    \value ExclusiveLimitAlarmType_ShelvingState_TimedShelve_InputArguments
    \value ExclusiveLimitAlarmType_SuppressedOrShelved
    \value ExclusiveLimitAlarmType_MaxTimeShelved
    \value ExclusiveLimitAlarmType_LimitState
    \value ExclusiveLimitAlarmType_LimitState_CurrentState
    \value ExclusiveLimitAlarmType_LimitState_CurrentState_Id
    \value ExclusiveLimitAlarmType_LimitState_CurrentState_Name
    \value ExclusiveLimitAlarmType_LimitState_CurrentState_Number
    \value ExclusiveLimitAlarmType_LimitState_CurrentState_EffectiveDisplayName
    \value ExclusiveLimitAlarmType_LimitState_LastTransition
    \value ExclusiveLimitAlarmType_LimitState_LastTransition_Id
    \value ExclusiveLimitAlarmType_LimitState_LastTransition_Name
    \value ExclusiveLimitAlarmType_LimitState_LastTransition_Number
    \value ExclusiveLimitAlarmType_LimitState_LastTransition_TransitionTime
    \value ExclusiveLimitAlarmType_HighHighLimit
    \value ExclusiveLimitAlarmType_HighLimit
    \value ExclusiveLimitAlarmType_LowLimit
    \value ExclusiveLimitAlarmType_LowLowLimit
    \value ExclusiveLevelAlarmType
    \value ExclusiveLevelAlarmType_EventId
    \value ExclusiveLevelAlarmType_EventType
    \value ExclusiveLevelAlarmType_SourceNode
    \value ExclusiveLevelAlarmType_SourceName
    \value ExclusiveLevelAlarmType_Time
    \value ExclusiveLevelAlarmType_ReceiveTime
    \value ExclusiveLevelAlarmType_LocalTime
    \value ExclusiveLevelAlarmType_Message
    \value ExclusiveLevelAlarmType_Severity
    \value ExclusiveLevelAlarmType_ConditionName
    \value ExclusiveLevelAlarmType_BranchId
    \value ExclusiveLevelAlarmType_Retain
    \value ExclusiveLevelAlarmType_EnabledState
    \value ExclusiveLevelAlarmType_EnabledState_Id
    \value ExclusiveLevelAlarmType_EnabledState_Name
    \value ExclusiveLevelAlarmType_EnabledState_Number
    \value ExclusiveLevelAlarmType_EnabledState_EffectiveDisplayName
    \value ExclusiveLevelAlarmType_EnabledState_TransitionTime
    \value ExclusiveLevelAlarmType_EnabledState_EffectiveTransitionTime
    \value ExclusiveLevelAlarmType_EnabledState_TrueState
    \value ExclusiveLevelAlarmType_EnabledState_FalseState
    \value ExclusiveLevelAlarmType_Quality
    \value ExclusiveLevelAlarmType_Quality_SourceTimestamp
    \value ExclusiveLevelAlarmType_LastSeverity
    \value ExclusiveLevelAlarmType_LastSeverity_SourceTimestamp
    \value ExclusiveLevelAlarmType_Comment
    \value ExclusiveLevelAlarmType_Comment_SourceTimestamp
    \value ExclusiveLevelAlarmType_ClientUserId
    \value ExclusiveLevelAlarmType_Enable
    \value ExclusiveLevelAlarmType_Disable
    \value ExclusiveLevelAlarmType_AddComment
    \value ExclusiveLevelAlarmType_AddComment_InputArguments
    \value ExclusiveLevelAlarmType_ConditionRefresh
    \value ExclusiveLevelAlarmType_ConditionRefresh_InputArguments
    \value ExclusiveLevelAlarmType_AckedState
    \value ExclusiveLevelAlarmType_AckedState_Id
    \value ExclusiveLevelAlarmType_AckedState_Name
    \value ExclusiveLevelAlarmType_AckedState_Number
    \value ExclusiveLevelAlarmType_AckedState_EffectiveDisplayName
    \value ExclusiveLevelAlarmType_AckedState_TransitionTime
    \value ExclusiveLevelAlarmType_AckedState_EffectiveTransitionTime
    \value ExclusiveLevelAlarmType_AckedState_TrueState
    \value ExclusiveLevelAlarmType_AckedState_FalseState
    \value ExclusiveLevelAlarmType_ConfirmedState
    \value ExclusiveLevelAlarmType_ConfirmedState_Id
    \value ExclusiveLevelAlarmType_ConfirmedState_Name
    \value ExclusiveLevelAlarmType_ConfirmedState_Number
    \value ExclusiveLevelAlarmType_ConfirmedState_EffectiveDisplayName
    \value ExclusiveLevelAlarmType_ConfirmedState_TransitionTime
    \value ExclusiveLevelAlarmType_ConfirmedState_EffectiveTransitionTime
    \value ExclusiveLevelAlarmType_ConfirmedState_TrueState
    \value ExclusiveLevelAlarmType_ConfirmedState_FalseState
    \value ExclusiveLevelAlarmType_Acknowledge
    \value ExclusiveLevelAlarmType_Acknowledge_InputArguments
    \value ExclusiveLevelAlarmType_Confirm
    \value ExclusiveLevelAlarmType_Confirm_InputArguments
    \value ExclusiveLevelAlarmType_ActiveState
    \value ExclusiveLevelAlarmType_ActiveState_Id
    \value ExclusiveLevelAlarmType_ActiveState_Name
    \value ExclusiveLevelAlarmType_ActiveState_Number
    \value ExclusiveLevelAlarmType_ActiveState_EffectiveDisplayName
    \value ExclusiveLevelAlarmType_ActiveState_TransitionTime
    \value ExclusiveLevelAlarmType_ActiveState_EffectiveTransitionTime
    \value ExclusiveLevelAlarmType_ActiveState_TrueState
    \value ExclusiveLevelAlarmType_ActiveState_FalseState
    \value ExclusiveLevelAlarmType_SuppressedState
    \value ExclusiveLevelAlarmType_SuppressedState_Id
    \value ExclusiveLevelAlarmType_SuppressedState_Name
    \value ExclusiveLevelAlarmType_SuppressedState_Number
    \value ExclusiveLevelAlarmType_SuppressedState_EffectiveDisplayName
    \value ExclusiveLevelAlarmType_SuppressedState_TransitionTime
    \value ExclusiveLevelAlarmType_SuppressedState_EffectiveTransitionTime
    \value ExclusiveLevelAlarmType_SuppressedState_TrueState
    \value ExclusiveLevelAlarmType_SuppressedState_FalseState
    \value ExclusiveLevelAlarmType_ShelvingState
    \value ExclusiveLevelAlarmType_ShelvingState_CurrentState
    \value ExclusiveLevelAlarmType_ShelvingState_CurrentState_Id
    \value ExclusiveLevelAlarmType_ShelvingState_CurrentState_Name
    \value ExclusiveLevelAlarmType_ShelvingState_CurrentState_Number
    \value ExclusiveLevelAlarmType_ShelvingState_CurrentState_EffectiveDisplayName
    \value ExclusiveLevelAlarmType_ShelvingState_LastTransition
    \value ExclusiveLevelAlarmType_ShelvingState_LastTransition_Id
    \value ExclusiveLevelAlarmType_ShelvingState_LastTransition_Name
    \value ExclusiveLevelAlarmType_ShelvingState_LastTransition_Number
    \value ExclusiveLevelAlarmType_ShelvingState_LastTransition_TransitionTime
    \value ExclusiveLevelAlarmType_ShelvingState_UnshelveTime
    \value ExclusiveLevelAlarmType_ShelvingState_Unshelve
    \value ExclusiveLevelAlarmType_ShelvingState_OneShotShelve
    \value ExclusiveLevelAlarmType_ShelvingState_TimedShelve
    \value ExclusiveLevelAlarmType_ShelvingState_TimedShelve_InputArguments
    \value ExclusiveLevelAlarmType_SuppressedOrShelved
    \value ExclusiveLevelAlarmType_MaxTimeShelved
    \value ExclusiveLevelAlarmType_LimitState
    \value ExclusiveLevelAlarmType_LimitState_CurrentState
    \value ExclusiveLevelAlarmType_LimitState_CurrentState_Id
    \value ExclusiveLevelAlarmType_LimitState_CurrentState_Name
    \value ExclusiveLevelAlarmType_LimitState_CurrentState_Number
    \value ExclusiveLevelAlarmType_LimitState_CurrentState_EffectiveDisplayName
    \value ExclusiveLevelAlarmType_LimitState_LastTransition
    \value ExclusiveLevelAlarmType_LimitState_LastTransition_Id
    \value ExclusiveLevelAlarmType_LimitState_LastTransition_Name
    \value ExclusiveLevelAlarmType_LimitState_LastTransition_Number
    \value ExclusiveLevelAlarmType_LimitState_LastTransition_TransitionTime
    \value ExclusiveLevelAlarmType_HighHighLimit
    \value ExclusiveLevelAlarmType_HighLimit
    \value ExclusiveLevelAlarmType_LowLimit
    \value ExclusiveLevelAlarmType_LowLowLimit
    \value ExclusiveRateOfChangeAlarmType
    \value ExclusiveRateOfChangeAlarmType_EventId
    \value ExclusiveRateOfChangeAlarmType_EventType
    \value ExclusiveRateOfChangeAlarmType_SourceNode
    \value ExclusiveRateOfChangeAlarmType_SourceName
    \value ExclusiveRateOfChangeAlarmType_Time
    \value ExclusiveRateOfChangeAlarmType_ReceiveTime
    \value ExclusiveRateOfChangeAlarmType_LocalTime
    \value ExclusiveRateOfChangeAlarmType_Message
    \value ExclusiveRateOfChangeAlarmType_Severity
    \value ExclusiveRateOfChangeAlarmType_ConditionName
    \value ExclusiveRateOfChangeAlarmType_BranchId
    \value ExclusiveRateOfChangeAlarmType_Retain
    \value ExclusiveRateOfChangeAlarmType_EnabledState
    \value ExclusiveRateOfChangeAlarmType_EnabledState_Id
    \value ExclusiveRateOfChangeAlarmType_EnabledState_Name
    \value ExclusiveRateOfChangeAlarmType_EnabledState_Number
    \value ExclusiveRateOfChangeAlarmType_EnabledState_EffectiveDisplayName
    \value ExclusiveRateOfChangeAlarmType_EnabledState_TransitionTime
    \value ExclusiveRateOfChangeAlarmType_EnabledState_EffectiveTransitionTime
    \value ExclusiveRateOfChangeAlarmType_EnabledState_TrueState
    \value ExclusiveRateOfChangeAlarmType_EnabledState_FalseState
    \value ExclusiveRateOfChangeAlarmType_Quality
    \value ExclusiveRateOfChangeAlarmType_Quality_SourceTimestamp
    \value ExclusiveRateOfChangeAlarmType_LastSeverity
    \value ExclusiveRateOfChangeAlarmType_LastSeverity_SourceTimestamp
    \value ExclusiveRateOfChangeAlarmType_Comment
    \value ExclusiveRateOfChangeAlarmType_Comment_SourceTimestamp
    \value ExclusiveRateOfChangeAlarmType_ClientUserId
    \value ExclusiveRateOfChangeAlarmType_Enable
    \value ExclusiveRateOfChangeAlarmType_Disable
    \value ExclusiveRateOfChangeAlarmType_AddComment
    \value ExclusiveRateOfChangeAlarmType_AddComment_InputArguments
    \value ExclusiveRateOfChangeAlarmType_ConditionRefresh
    \value ExclusiveRateOfChangeAlarmType_ConditionRefresh_InputArguments
    \value ExclusiveRateOfChangeAlarmType_AckedState
    \value ExclusiveRateOfChangeAlarmType_AckedState_Id
    \value ExclusiveRateOfChangeAlarmType_AckedState_Name
    \value ExclusiveRateOfChangeAlarmType_AckedState_Number
    \value ExclusiveRateOfChangeAlarmType_AckedState_EffectiveDisplayName
    \value ExclusiveRateOfChangeAlarmType_AckedState_TransitionTime
    \value ExclusiveRateOfChangeAlarmType_AckedState_EffectiveTransitionTime
    \value ExclusiveRateOfChangeAlarmType_AckedState_TrueState
    \value ExclusiveRateOfChangeAlarmType_AckedState_FalseState
    \value ExclusiveRateOfChangeAlarmType_ConfirmedState
    \value ExclusiveRateOfChangeAlarmType_ConfirmedState_Id
    \value ExclusiveRateOfChangeAlarmType_ConfirmedState_Name
    \value ExclusiveRateOfChangeAlarmType_ConfirmedState_Number
    \value ExclusiveRateOfChangeAlarmType_ConfirmedState_EffectiveDisplayName
    \value ExclusiveRateOfChangeAlarmType_ConfirmedState_TransitionTime
    \value ExclusiveRateOfChangeAlarmType_ConfirmedState_EffectiveTransitionTime
    \value ExclusiveRateOfChangeAlarmType_ConfirmedState_TrueState
    \value ExclusiveRateOfChangeAlarmType_ConfirmedState_FalseState
    \value ExclusiveRateOfChangeAlarmType_Acknowledge
    \value ExclusiveRateOfChangeAlarmType_Acknowledge_InputArguments
    \value ExclusiveRateOfChangeAlarmType_Confirm
    \value ExclusiveRateOfChangeAlarmType_Confirm_InputArguments
    \value ExclusiveRateOfChangeAlarmType_ActiveState
    \value ExclusiveRateOfChangeAlarmType_ActiveState_Id
    \value ExclusiveRateOfChangeAlarmType_ActiveState_Name
    \value ExclusiveRateOfChangeAlarmType_ActiveState_Number
    \value ExclusiveRateOfChangeAlarmType_ActiveState_EffectiveDisplayName
    \value ExclusiveRateOfChangeAlarmType_ActiveState_TransitionTime
    \value ExclusiveRateOfChangeAlarmType_ActiveState_EffectiveTransitionTime
    \value ExclusiveRateOfChangeAlarmType_ActiveState_TrueState
    \value ExclusiveRateOfChangeAlarmType_ActiveState_FalseState
    \value ExclusiveRateOfChangeAlarmType_SuppressedState
    \value ExclusiveRateOfChangeAlarmType_SuppressedState_Id
    \value ExclusiveRateOfChangeAlarmType_SuppressedState_Name
    \value ExclusiveRateOfChangeAlarmType_SuppressedState_Number
    \value ExclusiveRateOfChangeAlarmType_SuppressedState_EffectiveDisplayName
    \value ExclusiveRateOfChangeAlarmType_SuppressedState_TransitionTime
    \value ExclusiveRateOfChangeAlarmType_SuppressedState_EffectiveTransitionTime
    \value ExclusiveRateOfChangeAlarmType_SuppressedState_TrueState
    \value ExclusiveRateOfChangeAlarmType_SuppressedState_FalseState
    \value ExclusiveRateOfChangeAlarmType_ShelvingState
    \value ExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState
    \value ExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_Id
    \value ExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_Name
    \value ExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_Number
    \value ExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_EffectiveDisplayName
    \value ExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition
    \value ExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_Id
    \value ExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_Name
    \value ExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_Number
    \value ExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_TransitionTime
    \value ExclusiveRateOfChangeAlarmType_ShelvingState_UnshelveTime
    \value ExclusiveRateOfChangeAlarmType_ShelvingState_Unshelve
    \value ExclusiveRateOfChangeAlarmType_ShelvingState_OneShotShelve
    \value ExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve
    \value ExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve_InputArguments
    \value ExclusiveRateOfChangeAlarmType_SuppressedOrShelved
    \value ExclusiveRateOfChangeAlarmType_MaxTimeShelved
    \value ExclusiveRateOfChangeAlarmType_LimitState
    \value ExclusiveRateOfChangeAlarmType_LimitState_CurrentState
    \value ExclusiveRateOfChangeAlarmType_LimitState_CurrentState_Id
    \value ExclusiveRateOfChangeAlarmType_LimitState_CurrentState_Name
    \value ExclusiveRateOfChangeAlarmType_LimitState_CurrentState_Number
    \value ExclusiveRateOfChangeAlarmType_LimitState_CurrentState_EffectiveDisplayName
    \value ExclusiveRateOfChangeAlarmType_LimitState_LastTransition
    \value ExclusiveRateOfChangeAlarmType_LimitState_LastTransition_Id
    \value ExclusiveRateOfChangeAlarmType_LimitState_LastTransition_Name
    \value ExclusiveRateOfChangeAlarmType_LimitState_LastTransition_Number
    \value ExclusiveRateOfChangeAlarmType_LimitState_LastTransition_TransitionTime
    \value ExclusiveRateOfChangeAlarmType_HighHighLimit
    \value ExclusiveRateOfChangeAlarmType_HighLimit
    \value ExclusiveRateOfChangeAlarmType_LowLimit
    \value ExclusiveRateOfChangeAlarmType_LowLowLimit
    \value ExclusiveDeviationAlarmType
    \value ExclusiveDeviationAlarmType_EventId
    \value ExclusiveDeviationAlarmType_EventType
    \value ExclusiveDeviationAlarmType_SourceNode
    \value ExclusiveDeviationAlarmType_SourceName
    \value ExclusiveDeviationAlarmType_Time
    \value ExclusiveDeviationAlarmType_ReceiveTime
    \value ExclusiveDeviationAlarmType_LocalTime
    \value ExclusiveDeviationAlarmType_Message
    \value ExclusiveDeviationAlarmType_Severity
    \value ExclusiveDeviationAlarmType_ConditionName
    \value ExclusiveDeviationAlarmType_BranchId
    \value ExclusiveDeviationAlarmType_Retain
    \value ExclusiveDeviationAlarmType_EnabledState
    \value ExclusiveDeviationAlarmType_EnabledState_Id
    \value ExclusiveDeviationAlarmType_EnabledState_Name
    \value ExclusiveDeviationAlarmType_EnabledState_Number
    \value ExclusiveDeviationAlarmType_EnabledState_EffectiveDisplayName
    \value ExclusiveDeviationAlarmType_EnabledState_TransitionTime
    \value ExclusiveDeviationAlarmType_EnabledState_EffectiveTransitionTime
    \value ExclusiveDeviationAlarmType_EnabledState_TrueState
    \value ExclusiveDeviationAlarmType_EnabledState_FalseState
    \value ExclusiveDeviationAlarmType_Quality
    \value ExclusiveDeviationAlarmType_Quality_SourceTimestamp
    \value ExclusiveDeviationAlarmType_LastSeverity
    \value ExclusiveDeviationAlarmType_LastSeverity_SourceTimestamp
    \value ExclusiveDeviationAlarmType_Comment
    \value ExclusiveDeviationAlarmType_Comment_SourceTimestamp
    \value ExclusiveDeviationAlarmType_ClientUserId
    \value ExclusiveDeviationAlarmType_Enable
    \value ExclusiveDeviationAlarmType_Disable
    \value ExclusiveDeviationAlarmType_AddComment
    \value ExclusiveDeviationAlarmType_AddComment_InputArguments
    \value ExclusiveDeviationAlarmType_ConditionRefresh
    \value ExclusiveDeviationAlarmType_ConditionRefresh_InputArguments
    \value ExclusiveDeviationAlarmType_AckedState
    \value ExclusiveDeviationAlarmType_AckedState_Id
    \value ExclusiveDeviationAlarmType_AckedState_Name
    \value ExclusiveDeviationAlarmType_AckedState_Number
    \value ExclusiveDeviationAlarmType_AckedState_EffectiveDisplayName
    \value ExclusiveDeviationAlarmType_AckedState_TransitionTime
    \value ExclusiveDeviationAlarmType_AckedState_EffectiveTransitionTime
    \value ExclusiveDeviationAlarmType_AckedState_TrueState
    \value ExclusiveDeviationAlarmType_AckedState_FalseState
    \value ExclusiveDeviationAlarmType_ConfirmedState
    \value ExclusiveDeviationAlarmType_ConfirmedState_Id
    \value ExclusiveDeviationAlarmType_ConfirmedState_Name
    \value ExclusiveDeviationAlarmType_ConfirmedState_Number
    \value ExclusiveDeviationAlarmType_ConfirmedState_EffectiveDisplayName
    \value ExclusiveDeviationAlarmType_ConfirmedState_TransitionTime
    \value ExclusiveDeviationAlarmType_ConfirmedState_EffectiveTransitionTime
    \value ExclusiveDeviationAlarmType_ConfirmedState_TrueState
    \value ExclusiveDeviationAlarmType_ConfirmedState_FalseState
    \value ExclusiveDeviationAlarmType_Acknowledge
    \value ExclusiveDeviationAlarmType_Acknowledge_InputArguments
    \value ExclusiveDeviationAlarmType_Confirm
    \value ExclusiveDeviationAlarmType_Confirm_InputArguments
    \value ExclusiveDeviationAlarmType_ActiveState
    \value ExclusiveDeviationAlarmType_ActiveState_Id
    \value ExclusiveDeviationAlarmType_ActiveState_Name
    \value ExclusiveDeviationAlarmType_ActiveState_Number
    \value ExclusiveDeviationAlarmType_ActiveState_EffectiveDisplayName
    \value ExclusiveDeviationAlarmType_ActiveState_TransitionTime
    \value ExclusiveDeviationAlarmType_ActiveState_EffectiveTransitionTime
    \value ExclusiveDeviationAlarmType_ActiveState_TrueState
    \value ExclusiveDeviationAlarmType_ActiveState_FalseState
    \value ExclusiveDeviationAlarmType_SuppressedState
    \value ExclusiveDeviationAlarmType_SuppressedState_Id
    \value ExclusiveDeviationAlarmType_SuppressedState_Name
    \value ExclusiveDeviationAlarmType_SuppressedState_Number
    \value ExclusiveDeviationAlarmType_SuppressedState_EffectiveDisplayName
    \value ExclusiveDeviationAlarmType_SuppressedState_TransitionTime
    \value ExclusiveDeviationAlarmType_SuppressedState_EffectiveTransitionTime
    \value ExclusiveDeviationAlarmType_SuppressedState_TrueState
    \value ExclusiveDeviationAlarmType_SuppressedState_FalseState
    \value ExclusiveDeviationAlarmType_ShelvingState
    \value ExclusiveDeviationAlarmType_ShelvingState_CurrentState
    \value ExclusiveDeviationAlarmType_ShelvingState_CurrentState_Id
    \value ExclusiveDeviationAlarmType_ShelvingState_CurrentState_Name
    \value ExclusiveDeviationAlarmType_ShelvingState_CurrentState_Number
    \value ExclusiveDeviationAlarmType_ShelvingState_CurrentState_EffectiveDisplayName
    \value ExclusiveDeviationAlarmType_ShelvingState_LastTransition
    \value ExclusiveDeviationAlarmType_ShelvingState_LastTransition_Id
    \value ExclusiveDeviationAlarmType_ShelvingState_LastTransition_Name
    \value ExclusiveDeviationAlarmType_ShelvingState_LastTransition_Number
    \value ExclusiveDeviationAlarmType_ShelvingState_LastTransition_TransitionTime
    \value ExclusiveDeviationAlarmType_ShelvingState_UnshelveTime
    \value ExclusiveDeviationAlarmType_ShelvingState_Unshelve
    \value ExclusiveDeviationAlarmType_ShelvingState_OneShotShelve
    \value ExclusiveDeviationAlarmType_ShelvingState_TimedShelve
    \value ExclusiveDeviationAlarmType_ShelvingState_TimedShelve_InputArguments
    \value ExclusiveDeviationAlarmType_SuppressedOrShelved
    \value ExclusiveDeviationAlarmType_MaxTimeShelved
    \value ExclusiveDeviationAlarmType_LimitState
    \value ExclusiveDeviationAlarmType_LimitState_CurrentState
    \value ExclusiveDeviationAlarmType_LimitState_CurrentState_Id
    \value ExclusiveDeviationAlarmType_LimitState_CurrentState_Name
    \value ExclusiveDeviationAlarmType_LimitState_CurrentState_Number
    \value ExclusiveDeviationAlarmType_LimitState_CurrentState_EffectiveDisplayName
    \value ExclusiveDeviationAlarmType_LimitState_LastTransition
    \value ExclusiveDeviationAlarmType_LimitState_LastTransition_Id
    \value ExclusiveDeviationAlarmType_LimitState_LastTransition_Name
    \value ExclusiveDeviationAlarmType_LimitState_LastTransition_Number
    \value ExclusiveDeviationAlarmType_LimitState_LastTransition_TransitionTime
    \value ExclusiveDeviationAlarmType_HighHighLimit
    \value ExclusiveDeviationAlarmType_HighLimit
    \value ExclusiveDeviationAlarmType_LowLimit
    \value ExclusiveDeviationAlarmType_LowLowLimit
    \value ExclusiveDeviationAlarmType_SetpointNode
    \value NonExclusiveLimitAlarmType
    \value NonExclusiveLimitAlarmType_EventId
    \value NonExclusiveLimitAlarmType_EventType
    \value NonExclusiveLimitAlarmType_SourceNode
    \value NonExclusiveLimitAlarmType_SourceName
    \value NonExclusiveLimitAlarmType_Time
    \value NonExclusiveLimitAlarmType_ReceiveTime
    \value NonExclusiveLimitAlarmType_LocalTime
    \value NonExclusiveLimitAlarmType_Message
    \value NonExclusiveLimitAlarmType_Severity
    \value NonExclusiveLimitAlarmType_ConditionName
    \value NonExclusiveLimitAlarmType_BranchId
    \value NonExclusiveLimitAlarmType_Retain
    \value NonExclusiveLimitAlarmType_EnabledState
    \value NonExclusiveLimitAlarmType_EnabledState_Id
    \value NonExclusiveLimitAlarmType_EnabledState_Name
    \value NonExclusiveLimitAlarmType_EnabledState_Number
    \value NonExclusiveLimitAlarmType_EnabledState_EffectiveDisplayName
    \value NonExclusiveLimitAlarmType_EnabledState_TransitionTime
    \value NonExclusiveLimitAlarmType_EnabledState_EffectiveTransitionTime
    \value NonExclusiveLimitAlarmType_EnabledState_TrueState
    \value NonExclusiveLimitAlarmType_EnabledState_FalseState
    \value NonExclusiveLimitAlarmType_Quality
    \value NonExclusiveLimitAlarmType_Quality_SourceTimestamp
    \value NonExclusiveLimitAlarmType_LastSeverity
    \value NonExclusiveLimitAlarmType_LastSeverity_SourceTimestamp
    \value NonExclusiveLimitAlarmType_Comment
    \value NonExclusiveLimitAlarmType_Comment_SourceTimestamp
    \value NonExclusiveLimitAlarmType_ClientUserId
    \value NonExclusiveLimitAlarmType_Enable
    \value NonExclusiveLimitAlarmType_Disable
    \value NonExclusiveLimitAlarmType_AddComment
    \value NonExclusiveLimitAlarmType_AddComment_InputArguments
    \value NonExclusiveLimitAlarmType_ConditionRefresh
    \value NonExclusiveLimitAlarmType_ConditionRefresh_InputArguments
    \value NonExclusiveLimitAlarmType_AckedState
    \value NonExclusiveLimitAlarmType_AckedState_Id
    \value NonExclusiveLimitAlarmType_AckedState_Name
    \value NonExclusiveLimitAlarmType_AckedState_Number
    \value NonExclusiveLimitAlarmType_AckedState_EffectiveDisplayName
    \value NonExclusiveLimitAlarmType_AckedState_TransitionTime
    \value NonExclusiveLimitAlarmType_AckedState_EffectiveTransitionTime
    \value NonExclusiveLimitAlarmType_AckedState_TrueState
    \value NonExclusiveLimitAlarmType_AckedState_FalseState
    \value NonExclusiveLimitAlarmType_ConfirmedState
    \value NonExclusiveLimitAlarmType_ConfirmedState_Id
    \value NonExclusiveLimitAlarmType_ConfirmedState_Name
    \value NonExclusiveLimitAlarmType_ConfirmedState_Number
    \value NonExclusiveLimitAlarmType_ConfirmedState_EffectiveDisplayName
    \value NonExclusiveLimitAlarmType_ConfirmedState_TransitionTime
    \value NonExclusiveLimitAlarmType_ConfirmedState_EffectiveTransitionTime
    \value NonExclusiveLimitAlarmType_ConfirmedState_TrueState
    \value NonExclusiveLimitAlarmType_ConfirmedState_FalseState
    \value NonExclusiveLimitAlarmType_Acknowledge
    \value NonExclusiveLimitAlarmType_Acknowledge_InputArguments
    \value NonExclusiveLimitAlarmType_Confirm
    \value NonExclusiveLimitAlarmType_Confirm_InputArguments
    \value NonExclusiveLimitAlarmType_ActiveState
    \value NonExclusiveLimitAlarmType_ActiveState_Id
    \value NonExclusiveLimitAlarmType_ActiveState_Name
    \value NonExclusiveLimitAlarmType_ActiveState_Number
    \value NonExclusiveLimitAlarmType_ActiveState_EffectiveDisplayName
    \value NonExclusiveLimitAlarmType_ActiveState_TransitionTime
    \value NonExclusiveLimitAlarmType_ActiveState_EffectiveTransitionTime
    \value NonExclusiveLimitAlarmType_ActiveState_TrueState
    \value NonExclusiveLimitAlarmType_ActiveState_FalseState
    \value NonExclusiveLimitAlarmType_SuppressedState
    \value NonExclusiveLimitAlarmType_SuppressedState_Id
    \value NonExclusiveLimitAlarmType_SuppressedState_Name
    \value NonExclusiveLimitAlarmType_SuppressedState_Number
    \value NonExclusiveLimitAlarmType_SuppressedState_EffectiveDisplayName
    \value NonExclusiveLimitAlarmType_SuppressedState_TransitionTime
    \value NonExclusiveLimitAlarmType_SuppressedState_EffectiveTransitionTime
    \value NonExclusiveLimitAlarmType_SuppressedState_TrueState
    \value NonExclusiveLimitAlarmType_SuppressedState_FalseState
    \value NonExclusiveLimitAlarmType_ShelvingState
    \value NonExclusiveLimitAlarmType_ShelvingState_CurrentState
    \value NonExclusiveLimitAlarmType_ShelvingState_CurrentState_Id
    \value NonExclusiveLimitAlarmType_ShelvingState_CurrentState_Name
    \value NonExclusiveLimitAlarmType_ShelvingState_CurrentState_Number
    \value NonExclusiveLimitAlarmType_ShelvingState_CurrentState_EffectiveDisplayName
    \value NonExclusiveLimitAlarmType_ShelvingState_LastTransition
    \value NonExclusiveLimitAlarmType_ShelvingState_LastTransition_Id
    \value NonExclusiveLimitAlarmType_ShelvingState_LastTransition_Name
    \value NonExclusiveLimitAlarmType_ShelvingState_LastTransition_Number
    \value NonExclusiveLimitAlarmType_ShelvingState_LastTransition_TransitionTime
    \value NonExclusiveLimitAlarmType_ShelvingState_UnshelveTime
    \value NonExclusiveLimitAlarmType_ShelvingState_Unshelve
    \value NonExclusiveLimitAlarmType_ShelvingState_OneShotShelve
    \value NonExclusiveLimitAlarmType_ShelvingState_TimedShelve
    \value NonExclusiveLimitAlarmType_ShelvingState_TimedShelve_InputArguments
    \value NonExclusiveLimitAlarmType_SuppressedOrShelved
    \value NonExclusiveLimitAlarmType_MaxTimeShelved
    \value NonExclusiveLimitAlarmType_HighHighState
    \value NonExclusiveLimitAlarmType_HighHighState_Id
    \value NonExclusiveLimitAlarmType_HighHighState_Name
    \value NonExclusiveLimitAlarmType_HighHighState_Number
    \value NonExclusiveLimitAlarmType_HighHighState_EffectiveDisplayName
    \value NonExclusiveLimitAlarmType_HighHighState_TransitionTime
    \value NonExclusiveLimitAlarmType_HighHighState_EffectiveTransitionTime
    \value NonExclusiveLimitAlarmType_HighHighState_TrueState
    \value NonExclusiveLimitAlarmType_HighHighState_FalseState
    \value NonExclusiveLimitAlarmType_HighState
    \value NonExclusiveLimitAlarmType_HighState_Id
    \value NonExclusiveLimitAlarmType_HighState_Name
    \value NonExclusiveLimitAlarmType_HighState_Number
    \value NonExclusiveLimitAlarmType_HighState_EffectiveDisplayName
    \value NonExclusiveLimitAlarmType_HighState_TransitionTime
    \value NonExclusiveLimitAlarmType_HighState_EffectiveTransitionTime
    \value NonExclusiveLimitAlarmType_HighState_TrueState
    \value NonExclusiveLimitAlarmType_HighState_FalseState
    \value NonExclusiveLimitAlarmType_LowState
    \value NonExclusiveLimitAlarmType_LowState_Id
    \value NonExclusiveLimitAlarmType_LowState_Name
    \value NonExclusiveLimitAlarmType_LowState_Number
    \value NonExclusiveLimitAlarmType_LowState_EffectiveDisplayName
    \value NonExclusiveLimitAlarmType_LowState_TransitionTime
    \value NonExclusiveLimitAlarmType_LowState_EffectiveTransitionTime
    \value NonExclusiveLimitAlarmType_LowState_TrueState
    \value NonExclusiveLimitAlarmType_LowState_FalseState
    \value NonExclusiveLimitAlarmType_LowLowState
    \value NonExclusiveLimitAlarmType_LowLowState_Id
    \value NonExclusiveLimitAlarmType_LowLowState_Name
    \value NonExclusiveLimitAlarmType_LowLowState_Number
    \value NonExclusiveLimitAlarmType_LowLowState_EffectiveDisplayName
    \value NonExclusiveLimitAlarmType_LowLowState_TransitionTime
    \value NonExclusiveLimitAlarmType_LowLowState_EffectiveTransitionTime
    \value NonExclusiveLimitAlarmType_LowLowState_TrueState
    \value NonExclusiveLimitAlarmType_LowLowState_FalseState
    \value NonExclusiveLimitAlarmType_HighHighLimit
    \value NonExclusiveLimitAlarmType_HighLimit
    \value NonExclusiveLimitAlarmType_LowLimit
    \value NonExclusiveLimitAlarmType_LowLowLimit
    \value NonExclusiveLevelAlarmType
    \value NonExclusiveLevelAlarmType_EventId
    \value NonExclusiveLevelAlarmType_EventType
    \value NonExclusiveLevelAlarmType_SourceNode
    \value NonExclusiveLevelAlarmType_SourceName
    \value NonExclusiveLevelAlarmType_Time
    \value NonExclusiveLevelAlarmType_ReceiveTime
    \value NonExclusiveLevelAlarmType_LocalTime
    \value NonExclusiveLevelAlarmType_Message
    \value NonExclusiveLevelAlarmType_Severity
    \value NonExclusiveLevelAlarmType_ConditionName
    \value NonExclusiveLevelAlarmType_BranchId
    \value NonExclusiveLevelAlarmType_Retain
    \value NonExclusiveLevelAlarmType_EnabledState
    \value NonExclusiveLevelAlarmType_EnabledState_Id
    \value NonExclusiveLevelAlarmType_EnabledState_Name
    \value NonExclusiveLevelAlarmType_EnabledState_Number
    \value NonExclusiveLevelAlarmType_EnabledState_EffectiveDisplayName
    \value NonExclusiveLevelAlarmType_EnabledState_TransitionTime
    \value NonExclusiveLevelAlarmType_EnabledState_EffectiveTransitionTime
    \value NonExclusiveLevelAlarmType_EnabledState_TrueState
    \value NonExclusiveLevelAlarmType_EnabledState_FalseState
    \value NonExclusiveLevelAlarmType_Quality
    \value NonExclusiveLevelAlarmType_Quality_SourceTimestamp
    \value NonExclusiveLevelAlarmType_LastSeverity
    \value NonExclusiveLevelAlarmType_LastSeverity_SourceTimestamp
    \value NonExclusiveLevelAlarmType_Comment
    \value NonExclusiveLevelAlarmType_Comment_SourceTimestamp
    \value NonExclusiveLevelAlarmType_ClientUserId
    \value NonExclusiveLevelAlarmType_Enable
    \value NonExclusiveLevelAlarmType_Disable
    \value NonExclusiveLevelAlarmType_AddComment
    \value NonExclusiveLevelAlarmType_AddComment_InputArguments
    \value NonExclusiveLevelAlarmType_ConditionRefresh
    \value NonExclusiveLevelAlarmType_ConditionRefresh_InputArguments
    \value NonExclusiveLevelAlarmType_AckedState
    \value NonExclusiveLevelAlarmType_AckedState_Id
    \value NonExclusiveLevelAlarmType_AckedState_Name
    \value NonExclusiveLevelAlarmType_AckedState_Number
    \value NonExclusiveLevelAlarmType_AckedState_EffectiveDisplayName
    \value NonExclusiveLevelAlarmType_AckedState_TransitionTime
    \value NonExclusiveLevelAlarmType_AckedState_EffectiveTransitionTime
    \value NonExclusiveLevelAlarmType_AckedState_TrueState
    \value NonExclusiveLevelAlarmType_AckedState_FalseState
    \value NonExclusiveLevelAlarmType_ConfirmedState
    \value NonExclusiveLevelAlarmType_ConfirmedState_Id
    \value NonExclusiveLevelAlarmType_ConfirmedState_Name
    \value NonExclusiveLevelAlarmType_ConfirmedState_Number
    \value NonExclusiveLevelAlarmType_ConfirmedState_EffectiveDisplayName
    \value NonExclusiveLevelAlarmType_ConfirmedState_TransitionTime
    \value NonExclusiveLevelAlarmType_ConfirmedState_EffectiveTransitionTime
    \value NonExclusiveLevelAlarmType_ConfirmedState_TrueState
    \value NonExclusiveLevelAlarmType_ConfirmedState_FalseState
    \value NonExclusiveLevelAlarmType_Acknowledge
    \value NonExclusiveLevelAlarmType_Acknowledge_InputArguments
    \value NonExclusiveLevelAlarmType_Confirm
    \value NonExclusiveLevelAlarmType_Confirm_InputArguments
    \value NonExclusiveLevelAlarmType_ActiveState
    \value NonExclusiveLevelAlarmType_ActiveState_Id
    \value NonExclusiveLevelAlarmType_ActiveState_Name
    \value NonExclusiveLevelAlarmType_ActiveState_Number
    \value NonExclusiveLevelAlarmType_ActiveState_EffectiveDisplayName
    \value NonExclusiveLevelAlarmType_ActiveState_TransitionTime
    \value NonExclusiveLevelAlarmType_ActiveState_EffectiveTransitionTime
    \value NonExclusiveLevelAlarmType_ActiveState_TrueState
    \value NonExclusiveLevelAlarmType_ActiveState_FalseState
    \value NonExclusiveLevelAlarmType_SuppressedState
    \value NonExclusiveLevelAlarmType_SuppressedState_Id
    \value NonExclusiveLevelAlarmType_SuppressedState_Name
    \value NonExclusiveLevelAlarmType_SuppressedState_Number
    \value NonExclusiveLevelAlarmType_SuppressedState_EffectiveDisplayName
    \value NonExclusiveLevelAlarmType_SuppressedState_TransitionTime
    \value NonExclusiveLevelAlarmType_SuppressedState_EffectiveTransitionTime
    \value NonExclusiveLevelAlarmType_SuppressedState_TrueState
    \value NonExclusiveLevelAlarmType_SuppressedState_FalseState
    \value NonExclusiveLevelAlarmType_ShelvingState
    \value NonExclusiveLevelAlarmType_ShelvingState_CurrentState
    \value NonExclusiveLevelAlarmType_ShelvingState_CurrentState_Id
    \value NonExclusiveLevelAlarmType_ShelvingState_CurrentState_Name
    \value NonExclusiveLevelAlarmType_ShelvingState_CurrentState_Number
    \value NonExclusiveLevelAlarmType_ShelvingState_CurrentState_EffectiveDisplayName
    \value NonExclusiveLevelAlarmType_ShelvingState_LastTransition
    \value NonExclusiveLevelAlarmType_ShelvingState_LastTransition_Id
    \value NonExclusiveLevelAlarmType_ShelvingState_LastTransition_Name
    \value NonExclusiveLevelAlarmType_ShelvingState_LastTransition_Number
    \value NonExclusiveLevelAlarmType_ShelvingState_LastTransition_TransitionTime
    \value NonExclusiveLevelAlarmType_ShelvingState_UnshelveTime
    \value NonExclusiveLevelAlarmType_ShelvingState_Unshelve
    \value NonExclusiveLevelAlarmType_ShelvingState_OneShotShelve
    \value NonExclusiveLevelAlarmType_ShelvingState_TimedShelve
    \value NonExclusiveLevelAlarmType_ShelvingState_TimedShelve_InputArguments
    \value NonExclusiveLevelAlarmType_SuppressedOrShelved
    \value NonExclusiveLevelAlarmType_MaxTimeShelved
    \value NonExclusiveLevelAlarmType_HighHighState
    \value NonExclusiveLevelAlarmType_HighHighState_Id
    \value NonExclusiveLevelAlarmType_HighHighState_Name
    \value NonExclusiveLevelAlarmType_HighHighState_Number
    \value NonExclusiveLevelAlarmType_HighHighState_EffectiveDisplayName
    \value NonExclusiveLevelAlarmType_HighHighState_TransitionTime
    \value NonExclusiveLevelAlarmType_HighHighState_EffectiveTransitionTime
    \value NonExclusiveLevelAlarmType_HighHighState_TrueState
    \value NonExclusiveLevelAlarmType_HighHighState_FalseState
    \value NonExclusiveLevelAlarmType_HighState
    \value NonExclusiveLevelAlarmType_HighState_Id
    \value NonExclusiveLevelAlarmType_HighState_Name
    \value NonExclusiveLevelAlarmType_HighState_Number
    \value NonExclusiveLevelAlarmType_HighState_EffectiveDisplayName
    \value NonExclusiveLevelAlarmType_HighState_TransitionTime
    \value NonExclusiveLevelAlarmType_HighState_EffectiveTransitionTime
    \value NonExclusiveLevelAlarmType_HighState_TrueState
    \value NonExclusiveLevelAlarmType_HighState_FalseState
    \value NonExclusiveLevelAlarmType_LowState
    \value NonExclusiveLevelAlarmType_LowState_Id
    \value NonExclusiveLevelAlarmType_LowState_Name
    \value NonExclusiveLevelAlarmType_LowState_Number
    \value NonExclusiveLevelAlarmType_LowState_EffectiveDisplayName
    \value NonExclusiveLevelAlarmType_LowState_TransitionTime
    \value NonExclusiveLevelAlarmType_LowState_EffectiveTransitionTime
    \value NonExclusiveLevelAlarmType_LowState_TrueState
    \value NonExclusiveLevelAlarmType_LowState_FalseState
    \value NonExclusiveLevelAlarmType_LowLowState
    \value NonExclusiveLevelAlarmType_LowLowState_Id
    \value NonExclusiveLevelAlarmType_LowLowState_Name
    \value NonExclusiveLevelAlarmType_LowLowState_Number
    \value NonExclusiveLevelAlarmType_LowLowState_EffectiveDisplayName
    \value NonExclusiveLevelAlarmType_LowLowState_TransitionTime
    \value NonExclusiveLevelAlarmType_LowLowState_EffectiveTransitionTime
    \value NonExclusiveLevelAlarmType_LowLowState_TrueState
    \value NonExclusiveLevelAlarmType_LowLowState_FalseState
    \value NonExclusiveLevelAlarmType_HighHighLimit
    \value NonExclusiveLevelAlarmType_HighLimit
    \value NonExclusiveLevelAlarmType_LowLimit
    \value NonExclusiveLevelAlarmType_LowLowLimit
    \value NonExclusiveRateOfChangeAlarmType
    \value NonExclusiveRateOfChangeAlarmType_EventId
    \value NonExclusiveRateOfChangeAlarmType_EventType
    \value NonExclusiveRateOfChangeAlarmType_SourceNode
    \value NonExclusiveRateOfChangeAlarmType_SourceName
    \value NonExclusiveRateOfChangeAlarmType_Time
    \value NonExclusiveRateOfChangeAlarmType_ReceiveTime
    \value NonExclusiveRateOfChangeAlarmType_LocalTime
    \value NonExclusiveRateOfChangeAlarmType_Message
    \value NonExclusiveRateOfChangeAlarmType_Severity
    \value NonExclusiveRateOfChangeAlarmType_ConditionName
    \value NonExclusiveRateOfChangeAlarmType_BranchId
    \value NonExclusiveRateOfChangeAlarmType_Retain
    \value NonExclusiveRateOfChangeAlarmType_EnabledState
    \value NonExclusiveRateOfChangeAlarmType_EnabledState_Id
    \value NonExclusiveRateOfChangeAlarmType_EnabledState_Name
    \value NonExclusiveRateOfChangeAlarmType_EnabledState_Number
    \value NonExclusiveRateOfChangeAlarmType_EnabledState_EffectiveDisplayName
    \value NonExclusiveRateOfChangeAlarmType_EnabledState_TransitionTime
    \value NonExclusiveRateOfChangeAlarmType_EnabledState_EffectiveTransitionTime
    \value NonExclusiveRateOfChangeAlarmType_EnabledState_TrueState
    \value NonExclusiveRateOfChangeAlarmType_EnabledState_FalseState
    \value NonExclusiveRateOfChangeAlarmType_Quality
    \value NonExclusiveRateOfChangeAlarmType_Quality_SourceTimestamp
    \value NonExclusiveRateOfChangeAlarmType_LastSeverity
    \value NonExclusiveRateOfChangeAlarmType_LastSeverity_SourceTimestamp
    \value NonExclusiveRateOfChangeAlarmType_Comment
    \value NonExclusiveRateOfChangeAlarmType_Comment_SourceTimestamp
    \value NonExclusiveRateOfChangeAlarmType_ClientUserId
    \value NonExclusiveRateOfChangeAlarmType_Enable
    \value NonExclusiveRateOfChangeAlarmType_Disable
    \value NonExclusiveRateOfChangeAlarmType_AddComment
    \value NonExclusiveRateOfChangeAlarmType_AddComment_InputArguments
    \value NonExclusiveRateOfChangeAlarmType_ConditionRefresh
    \value NonExclusiveRateOfChangeAlarmType_ConditionRefresh_InputArguments
    \value NonExclusiveRateOfChangeAlarmType_AckedState
    \value NonExclusiveRateOfChangeAlarmType_AckedState_Id
    \value NonExclusiveRateOfChangeAlarmType_AckedState_Name
    \value NonExclusiveRateOfChangeAlarmType_AckedState_Number
    \value NonExclusiveRateOfChangeAlarmType_AckedState_EffectiveDisplayName
    \value NonExclusiveRateOfChangeAlarmType_AckedState_TransitionTime
    \value NonExclusiveRateOfChangeAlarmType_AckedState_EffectiveTransitionTime
    \value NonExclusiveRateOfChangeAlarmType_AckedState_TrueState
    \value NonExclusiveRateOfChangeAlarmType_AckedState_FalseState
    \value NonExclusiveRateOfChangeAlarmType_ConfirmedState
    \value NonExclusiveRateOfChangeAlarmType_ConfirmedState_Id
    \value NonExclusiveRateOfChangeAlarmType_ConfirmedState_Name
    \value NonExclusiveRateOfChangeAlarmType_ConfirmedState_Number
    \value NonExclusiveRateOfChangeAlarmType_ConfirmedState_EffectiveDisplayName
    \value NonExclusiveRateOfChangeAlarmType_ConfirmedState_TransitionTime
    \value NonExclusiveRateOfChangeAlarmType_ConfirmedState_EffectiveTransitionTime
    \value NonExclusiveRateOfChangeAlarmType_ConfirmedState_TrueState
    \value NonExclusiveRateOfChangeAlarmType_ConfirmedState_FalseState
    \value NonExclusiveRateOfChangeAlarmType_Acknowledge
    \value NonExclusiveRateOfChangeAlarmType_Acknowledge_InputArguments
    \value NonExclusiveRateOfChangeAlarmType_Confirm
    \value NonExclusiveRateOfChangeAlarmType_Confirm_InputArguments
    \value NonExclusiveRateOfChangeAlarmType_ActiveState
    \value NonExclusiveRateOfChangeAlarmType_ActiveState_Id
    \value NonExclusiveRateOfChangeAlarmType_ActiveState_Name
    \value NonExclusiveRateOfChangeAlarmType_ActiveState_Number
    \value NonExclusiveRateOfChangeAlarmType_ActiveState_EffectiveDisplayName
    \value NonExclusiveRateOfChangeAlarmType_ActiveState_TransitionTime
    \value NonExclusiveRateOfChangeAlarmType_ActiveState_EffectiveTransitionTime
    \value NonExclusiveRateOfChangeAlarmType_ActiveState_TrueState
    \value NonExclusiveRateOfChangeAlarmType_ActiveState_FalseState
    \value NonExclusiveRateOfChangeAlarmType_SuppressedState
    \value NonExclusiveRateOfChangeAlarmType_SuppressedState_Id
    \value NonExclusiveRateOfChangeAlarmType_SuppressedState_Name
    \value NonExclusiveRateOfChangeAlarmType_SuppressedState_Number
    \value NonExclusiveRateOfChangeAlarmType_SuppressedState_EffectiveDisplayName
    \value NonExclusiveRateOfChangeAlarmType_SuppressedState_TransitionTime
    \value NonExclusiveRateOfChangeAlarmType_SuppressedState_EffectiveTransitionTime
    \value NonExclusiveRateOfChangeAlarmType_SuppressedState_TrueState
    \value NonExclusiveRateOfChangeAlarmType_SuppressedState_FalseState
    \value NonExclusiveRateOfChangeAlarmType_ShelvingState
    \value NonExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState
    \value NonExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_Id
    \value NonExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_Name
    \value NonExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_Number
    \value NonExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_EffectiveDisplayName
    \value NonExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition
    \value NonExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_Id
    \value NonExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_Name
    \value NonExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_Number
    \value NonExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_TransitionTime
    \value NonExclusiveRateOfChangeAlarmType_ShelvingState_UnshelveTime
    \value NonExclusiveRateOfChangeAlarmType_ShelvingState_Unshelve
    \value NonExclusiveRateOfChangeAlarmType_ShelvingState_OneShotShelve
    \value NonExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve
    \value NonExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve_InputArguments
    \value NonExclusiveRateOfChangeAlarmType_SuppressedOrShelved
    \value NonExclusiveRateOfChangeAlarmType_MaxTimeShelved
    \value NonExclusiveRateOfChangeAlarmType_HighHighState
    \value NonExclusiveRateOfChangeAlarmType_HighHighState_Id
    \value NonExclusiveRateOfChangeAlarmType_HighHighState_Name
    \value NonExclusiveRateOfChangeAlarmType_HighHighState_Number
    \value NonExclusiveRateOfChangeAlarmType_HighHighState_EffectiveDisplayName
    \value NonExclusiveRateOfChangeAlarmType_HighHighState_TransitionTime
    \value NonExclusiveRateOfChangeAlarmType_HighHighState_EffectiveTransitionTime
    \value NonExclusiveRateOfChangeAlarmType_HighHighState_TrueState
    \value NonExclusiveRateOfChangeAlarmType_HighHighState_FalseState
    \value NonExclusiveRateOfChangeAlarmType_HighState
    \value NonExclusiveRateOfChangeAlarmType_HighState_Id
    \value NonExclusiveRateOfChangeAlarmType_HighState_Name
    \value NonExclusiveRateOfChangeAlarmType_HighState_Number
    \value NonExclusiveRateOfChangeAlarmType_HighState_EffectiveDisplayName
    \value NonExclusiveRateOfChangeAlarmType_HighState_TransitionTime
    \value NonExclusiveRateOfChangeAlarmType_HighState_EffectiveTransitionTime
    \value NonExclusiveRateOfChangeAlarmType_HighState_TrueState
    \value NonExclusiveRateOfChangeAlarmType_HighState_FalseState
    \value NonExclusiveRateOfChangeAlarmType_LowState
    \value NonExclusiveRateOfChangeAlarmType_LowState_Id
    \value NonExclusiveRateOfChangeAlarmType_LowState_Name
    \value NonExclusiveRateOfChangeAlarmType_LowState_Number
    \value NonExclusiveRateOfChangeAlarmType_LowState_EffectiveDisplayName
    \value NonExclusiveRateOfChangeAlarmType_LowState_TransitionTime
    \value NonExclusiveRateOfChangeAlarmType_LowState_EffectiveTransitionTime
    \value NonExclusiveRateOfChangeAlarmType_LowState_TrueState
    \value NonExclusiveRateOfChangeAlarmType_LowState_FalseState
    \value NonExclusiveRateOfChangeAlarmType_LowLowState
    \value NonExclusiveRateOfChangeAlarmType_LowLowState_Id
    \value NonExclusiveRateOfChangeAlarmType_LowLowState_Name
    \value NonExclusiveRateOfChangeAlarmType_LowLowState_Number
    \value NonExclusiveRateOfChangeAlarmType_LowLowState_EffectiveDisplayName
    \value NonExclusiveRateOfChangeAlarmType_LowLowState_TransitionTime
    \value NonExclusiveRateOfChangeAlarmType_LowLowState_EffectiveTransitionTime
    \value NonExclusiveRateOfChangeAlarmType_LowLowState_TrueState
    \value NonExclusiveRateOfChangeAlarmType_LowLowState_FalseState
    \value NonExclusiveRateOfChangeAlarmType_HighHighLimit
    \value NonExclusiveRateOfChangeAlarmType_HighLimit
    \value NonExclusiveRateOfChangeAlarmType_LowLimit
    \value NonExclusiveRateOfChangeAlarmType_LowLowLimit
    \value NonExclusiveDeviationAlarmType
    \value NonExclusiveDeviationAlarmType_EventId
    \value NonExclusiveDeviationAlarmType_EventType
    \value NonExclusiveDeviationAlarmType_SourceNode
    \value NonExclusiveDeviationAlarmType_SourceName
    \value NonExclusiveDeviationAlarmType_Time
    \value NonExclusiveDeviationAlarmType_ReceiveTime
    \value NonExclusiveDeviationAlarmType_LocalTime
    \value NonExclusiveDeviationAlarmType_Message
    \value NonExclusiveDeviationAlarmType_Severity
    \value NonExclusiveDeviationAlarmType_ConditionName
    \value NonExclusiveDeviationAlarmType_BranchId
    \value NonExclusiveDeviationAlarmType_Retain
    \value NonExclusiveDeviationAlarmType_EnabledState
    \value NonExclusiveDeviationAlarmType_EnabledState_Id
    \value NonExclusiveDeviationAlarmType_EnabledState_Name
    \value NonExclusiveDeviationAlarmType_EnabledState_Number
    \value NonExclusiveDeviationAlarmType_EnabledState_EffectiveDisplayName
    \value NonExclusiveDeviationAlarmType_EnabledState_TransitionTime
    \value NonExclusiveDeviationAlarmType_EnabledState_EffectiveTransitionTime
    \value NonExclusiveDeviationAlarmType_EnabledState_TrueState
    \value NonExclusiveDeviationAlarmType_EnabledState_FalseState
    \value NonExclusiveDeviationAlarmType_Quality
    \value NonExclusiveDeviationAlarmType_Quality_SourceTimestamp
    \value NonExclusiveDeviationAlarmType_LastSeverity
    \value NonExclusiveDeviationAlarmType_LastSeverity_SourceTimestamp
    \value NonExclusiveDeviationAlarmType_Comment
    \value NonExclusiveDeviationAlarmType_Comment_SourceTimestamp
    \value NonExclusiveDeviationAlarmType_ClientUserId
    \value NonExclusiveDeviationAlarmType_Enable
    \value NonExclusiveDeviationAlarmType_Disable
    \value NonExclusiveDeviationAlarmType_AddComment
    \value NonExclusiveDeviationAlarmType_AddComment_InputArguments
    \value NonExclusiveDeviationAlarmType_ConditionRefresh
    \value NonExclusiveDeviationAlarmType_ConditionRefresh_InputArguments
    \value NonExclusiveDeviationAlarmType_AckedState
    \value NonExclusiveDeviationAlarmType_AckedState_Id
    \value NonExclusiveDeviationAlarmType_AckedState_Name
    \value NonExclusiveDeviationAlarmType_AckedState_Number
    \value NonExclusiveDeviationAlarmType_AckedState_EffectiveDisplayName
    \value NonExclusiveDeviationAlarmType_AckedState_TransitionTime
    \value NonExclusiveDeviationAlarmType_AckedState_EffectiveTransitionTime
    \value NonExclusiveDeviationAlarmType_AckedState_TrueState
    \value NonExclusiveDeviationAlarmType_AckedState_FalseState
    \value NonExclusiveDeviationAlarmType_ConfirmedState
    \value NonExclusiveDeviationAlarmType_ConfirmedState_Id
    \value NonExclusiveDeviationAlarmType_ConfirmedState_Name
    \value NonExclusiveDeviationAlarmType_ConfirmedState_Number
    \value NonExclusiveDeviationAlarmType_ConfirmedState_EffectiveDisplayName
    \value NonExclusiveDeviationAlarmType_ConfirmedState_TransitionTime
    \value NonExclusiveDeviationAlarmType_ConfirmedState_EffectiveTransitionTime
    \value NonExclusiveDeviationAlarmType_ConfirmedState_TrueState
    \value NonExclusiveDeviationAlarmType_ConfirmedState_FalseState
    \value NonExclusiveDeviationAlarmType_Acknowledge
    \value NonExclusiveDeviationAlarmType_Acknowledge_InputArguments
    \value NonExclusiveDeviationAlarmType_Confirm
    \value NonExclusiveDeviationAlarmType_Confirm_InputArguments
    \value NonExclusiveDeviationAlarmType_ActiveState
    \value NonExclusiveDeviationAlarmType_ActiveState_Id
    \value NonExclusiveDeviationAlarmType_ActiveState_Name
    \value NonExclusiveDeviationAlarmType_ActiveState_Number
    \value NonExclusiveDeviationAlarmType_ActiveState_EffectiveDisplayName
    \value NonExclusiveDeviationAlarmType_ActiveState_TransitionTime
    \value NonExclusiveDeviationAlarmType_ActiveState_EffectiveTransitionTime
    \value NonExclusiveDeviationAlarmType_ActiveState_TrueState
    \value NonExclusiveDeviationAlarmType_ActiveState_FalseState
    \value NonExclusiveDeviationAlarmType_SuppressedState
    \value NonExclusiveDeviationAlarmType_SuppressedState_Id
    \value NonExclusiveDeviationAlarmType_SuppressedState_Name
    \value NonExclusiveDeviationAlarmType_SuppressedState_Number
    \value NonExclusiveDeviationAlarmType_SuppressedState_EffectiveDisplayName
    \value NonExclusiveDeviationAlarmType_SuppressedState_TransitionTime
    \value NonExclusiveDeviationAlarmType_SuppressedState_EffectiveTransitionTime
    \value NonExclusiveDeviationAlarmType_SuppressedState_TrueState
    \value NonExclusiveDeviationAlarmType_SuppressedState_FalseState
    \value NonExclusiveDeviationAlarmType_ShelvingState
    \value NonExclusiveDeviationAlarmType_ShelvingState_CurrentState
    \value NonExclusiveDeviationAlarmType_ShelvingState_CurrentState_Id
    \value NonExclusiveDeviationAlarmType_ShelvingState_CurrentState_Name
    \value NonExclusiveDeviationAlarmType_ShelvingState_CurrentState_Number
    \value NonExclusiveDeviationAlarmType_ShelvingState_CurrentState_EffectiveDisplayName
    \value NonExclusiveDeviationAlarmType_ShelvingState_LastTransition
    \value NonExclusiveDeviationAlarmType_ShelvingState_LastTransition_Id
    \value NonExclusiveDeviationAlarmType_ShelvingState_LastTransition_Name
    \value NonExclusiveDeviationAlarmType_ShelvingState_LastTransition_Number
    \value NonExclusiveDeviationAlarmType_ShelvingState_LastTransition_TransitionTime
    \value NonExclusiveDeviationAlarmType_ShelvingState_UnshelveTime
    \value NonExclusiveDeviationAlarmType_ShelvingState_Unshelve
    \value NonExclusiveDeviationAlarmType_ShelvingState_OneShotShelve
    \value NonExclusiveDeviationAlarmType_ShelvingState_TimedShelve
    \value NonExclusiveDeviationAlarmType_ShelvingState_TimedShelve_InputArguments
    \value NonExclusiveDeviationAlarmType_SuppressedOrShelved
    \value NonExclusiveDeviationAlarmType_MaxTimeShelved
    \value NonExclusiveDeviationAlarmType_HighHighState
    \value NonExclusiveDeviationAlarmType_HighHighState_Id
    \value NonExclusiveDeviationAlarmType_HighHighState_Name
    \value NonExclusiveDeviationAlarmType_HighHighState_Number
    \value NonExclusiveDeviationAlarmType_HighHighState_EffectiveDisplayName
    \value NonExclusiveDeviationAlarmType_HighHighState_TransitionTime
    \value NonExclusiveDeviationAlarmType_HighHighState_EffectiveTransitionTime
    \value NonExclusiveDeviationAlarmType_HighHighState_TrueState
    \value NonExclusiveDeviationAlarmType_HighHighState_FalseState
    \value NonExclusiveDeviationAlarmType_HighState
    \value NonExclusiveDeviationAlarmType_HighState_Id
    \value NonExclusiveDeviationAlarmType_HighState_Name
    \value NonExclusiveDeviationAlarmType_HighState_Number
    \value NonExclusiveDeviationAlarmType_HighState_EffectiveDisplayName
    \value NonExclusiveDeviationAlarmType_HighState_TransitionTime
    \value NonExclusiveDeviationAlarmType_HighState_EffectiveTransitionTime
    \value NonExclusiveDeviationAlarmType_HighState_TrueState
    \value NonExclusiveDeviationAlarmType_HighState_FalseState
    \value NonExclusiveDeviationAlarmType_LowState
    \value NonExclusiveDeviationAlarmType_LowState_Id
    \value NonExclusiveDeviationAlarmType_LowState_Name
    \value NonExclusiveDeviationAlarmType_LowState_Number
    \value NonExclusiveDeviationAlarmType_LowState_EffectiveDisplayName
    \value NonExclusiveDeviationAlarmType_LowState_TransitionTime
    \value NonExclusiveDeviationAlarmType_LowState_EffectiveTransitionTime
    \value NonExclusiveDeviationAlarmType_LowState_TrueState
    \value NonExclusiveDeviationAlarmType_LowState_FalseState
    \value NonExclusiveDeviationAlarmType_LowLowState
    \value NonExclusiveDeviationAlarmType_LowLowState_Id
    \value NonExclusiveDeviationAlarmType_LowLowState_Name
    \value NonExclusiveDeviationAlarmType_LowLowState_Number
    \value NonExclusiveDeviationAlarmType_LowLowState_EffectiveDisplayName
    \value NonExclusiveDeviationAlarmType_LowLowState_TransitionTime
    \value NonExclusiveDeviationAlarmType_LowLowState_EffectiveTransitionTime
    \value NonExclusiveDeviationAlarmType_LowLowState_TrueState
    \value NonExclusiveDeviationAlarmType_LowLowState_FalseState
    \value NonExclusiveDeviationAlarmType_HighHighLimit
    \value NonExclusiveDeviationAlarmType_HighLimit
    \value NonExclusiveDeviationAlarmType_LowLimit
    \value NonExclusiveDeviationAlarmType_LowLowLimit
    \value NonExclusiveDeviationAlarmType_SetpointNode
    \value DiscreteAlarmType
    \value DiscreteAlarmType_EventId
    \value DiscreteAlarmType_EventType
    \value DiscreteAlarmType_SourceNode
    \value DiscreteAlarmType_SourceName
    \value DiscreteAlarmType_Time
    \value DiscreteAlarmType_ReceiveTime
    \value DiscreteAlarmType_LocalTime
    \value DiscreteAlarmType_Message
    \value DiscreteAlarmType_Severity
    \value DiscreteAlarmType_ConditionName
    \value DiscreteAlarmType_BranchId
    \value DiscreteAlarmType_Retain
    \value DiscreteAlarmType_EnabledState
    \value DiscreteAlarmType_EnabledState_Id
    \value DiscreteAlarmType_EnabledState_Name
    \value DiscreteAlarmType_EnabledState_Number
    \value DiscreteAlarmType_EnabledState_EffectiveDisplayName
    \value DiscreteAlarmType_EnabledState_TransitionTime
    \value DiscreteAlarmType_EnabledState_EffectiveTransitionTime
    \value DiscreteAlarmType_EnabledState_TrueState
    \value DiscreteAlarmType_EnabledState_FalseState
    \value DiscreteAlarmType_Quality
    \value DiscreteAlarmType_Quality_SourceTimestamp
    \value DiscreteAlarmType_LastSeverity
    \value DiscreteAlarmType_LastSeverity_SourceTimestamp
    \value DiscreteAlarmType_Comment
    \value DiscreteAlarmType_Comment_SourceTimestamp
    \value DiscreteAlarmType_ClientUserId
    \value DiscreteAlarmType_Enable
    \value DiscreteAlarmType_Disable
    \value DiscreteAlarmType_AddComment
    \value DiscreteAlarmType_AddComment_InputArguments
    \value DiscreteAlarmType_ConditionRefresh
    \value DiscreteAlarmType_ConditionRefresh_InputArguments
    \value DiscreteAlarmType_AckedState
    \value DiscreteAlarmType_AckedState_Id
    \value DiscreteAlarmType_AckedState_Name
    \value DiscreteAlarmType_AckedState_Number
    \value DiscreteAlarmType_AckedState_EffectiveDisplayName
    \value DiscreteAlarmType_AckedState_TransitionTime
    \value DiscreteAlarmType_AckedState_EffectiveTransitionTime
    \value DiscreteAlarmType_AckedState_TrueState
    \value DiscreteAlarmType_AckedState_FalseState
    \value DiscreteAlarmType_ConfirmedState
    \value DiscreteAlarmType_ConfirmedState_Id
    \value DiscreteAlarmType_ConfirmedState_Name
    \value DiscreteAlarmType_ConfirmedState_Number
    \value DiscreteAlarmType_ConfirmedState_EffectiveDisplayName
    \value DiscreteAlarmType_ConfirmedState_TransitionTime
    \value DiscreteAlarmType_ConfirmedState_EffectiveTransitionTime
    \value DiscreteAlarmType_ConfirmedState_TrueState
    \value DiscreteAlarmType_ConfirmedState_FalseState
    \value DiscreteAlarmType_Acknowledge
    \value DiscreteAlarmType_Acknowledge_InputArguments
    \value DiscreteAlarmType_Confirm
    \value DiscreteAlarmType_Confirm_InputArguments
    \value DiscreteAlarmType_ActiveState
    \value DiscreteAlarmType_ActiveState_Id
    \value DiscreteAlarmType_ActiveState_Name
    \value DiscreteAlarmType_ActiveState_Number
    \value DiscreteAlarmType_ActiveState_EffectiveDisplayName
    \value DiscreteAlarmType_ActiveState_TransitionTime
    \value DiscreteAlarmType_ActiveState_EffectiveTransitionTime
    \value DiscreteAlarmType_ActiveState_TrueState
    \value DiscreteAlarmType_ActiveState_FalseState
    \value DiscreteAlarmType_SuppressedState
    \value DiscreteAlarmType_SuppressedState_Id
    \value DiscreteAlarmType_SuppressedState_Name
    \value DiscreteAlarmType_SuppressedState_Number
    \value DiscreteAlarmType_SuppressedState_EffectiveDisplayName
    \value DiscreteAlarmType_SuppressedState_TransitionTime
    \value DiscreteAlarmType_SuppressedState_EffectiveTransitionTime
    \value DiscreteAlarmType_SuppressedState_TrueState
    \value DiscreteAlarmType_SuppressedState_FalseState
    \value DiscreteAlarmType_ShelvingState
    \value DiscreteAlarmType_ShelvingState_CurrentState
    \value DiscreteAlarmType_ShelvingState_CurrentState_Id
    \value DiscreteAlarmType_ShelvingState_CurrentState_Name
    \value DiscreteAlarmType_ShelvingState_CurrentState_Number
    \value DiscreteAlarmType_ShelvingState_CurrentState_EffectiveDisplayName
    \value DiscreteAlarmType_ShelvingState_LastTransition
    \value DiscreteAlarmType_ShelvingState_LastTransition_Id
    \value DiscreteAlarmType_ShelvingState_LastTransition_Name
    \value DiscreteAlarmType_ShelvingState_LastTransition_Number
    \value DiscreteAlarmType_ShelvingState_LastTransition_TransitionTime
    \value DiscreteAlarmType_ShelvingState_UnshelveTime
    \value DiscreteAlarmType_ShelvingState_Unshelve
    \value DiscreteAlarmType_ShelvingState_OneShotShelve
    \value DiscreteAlarmType_ShelvingState_TimedShelve
    \value DiscreteAlarmType_ShelvingState_TimedShelve_InputArguments
    \value DiscreteAlarmType_SuppressedOrShelved
    \value DiscreteAlarmType_MaxTimeShelved
    \value OffNormalAlarmType
    \value OffNormalAlarmType_EventId
    \value OffNormalAlarmType_EventType
    \value OffNormalAlarmType_SourceNode
    \value OffNormalAlarmType_SourceName
    \value OffNormalAlarmType_Time
    \value OffNormalAlarmType_ReceiveTime
    \value OffNormalAlarmType_LocalTime
    \value OffNormalAlarmType_Message
    \value OffNormalAlarmType_Severity
    \value OffNormalAlarmType_ConditionName
    \value OffNormalAlarmType_BranchId
    \value OffNormalAlarmType_Retain
    \value OffNormalAlarmType_EnabledState
    \value OffNormalAlarmType_EnabledState_Id
    \value OffNormalAlarmType_EnabledState_Name
    \value OffNormalAlarmType_EnabledState_Number
    \value OffNormalAlarmType_EnabledState_EffectiveDisplayName
    \value OffNormalAlarmType_EnabledState_TransitionTime
    \value OffNormalAlarmType_EnabledState_EffectiveTransitionTime
    \value OffNormalAlarmType_EnabledState_TrueState
    \value OffNormalAlarmType_EnabledState_FalseState
    \value OffNormalAlarmType_Quality
    \value OffNormalAlarmType_Quality_SourceTimestamp
    \value OffNormalAlarmType_LastSeverity
    \value OffNormalAlarmType_LastSeverity_SourceTimestamp
    \value OffNormalAlarmType_Comment
    \value OffNormalAlarmType_Comment_SourceTimestamp
    \value OffNormalAlarmType_ClientUserId
    \value OffNormalAlarmType_Enable
    \value OffNormalAlarmType_Disable
    \value OffNormalAlarmType_AddComment
    \value OffNormalAlarmType_AddComment_InputArguments
    \value OffNormalAlarmType_ConditionRefresh
    \value OffNormalAlarmType_ConditionRefresh_InputArguments
    \value OffNormalAlarmType_AckedState
    \value OffNormalAlarmType_AckedState_Id
    \value OffNormalAlarmType_AckedState_Name
    \value OffNormalAlarmType_AckedState_Number
    \value OffNormalAlarmType_AckedState_EffectiveDisplayName
    \value OffNormalAlarmType_AckedState_TransitionTime
    \value OffNormalAlarmType_AckedState_EffectiveTransitionTime
    \value OffNormalAlarmType_AckedState_TrueState
    \value OffNormalAlarmType_AckedState_FalseState
    \value OffNormalAlarmType_ConfirmedState
    \value OffNormalAlarmType_ConfirmedState_Id
    \value OffNormalAlarmType_ConfirmedState_Name
    \value OffNormalAlarmType_ConfirmedState_Number
    \value OffNormalAlarmType_ConfirmedState_EffectiveDisplayName
    \value OffNormalAlarmType_ConfirmedState_TransitionTime
    \value OffNormalAlarmType_ConfirmedState_EffectiveTransitionTime
    \value OffNormalAlarmType_ConfirmedState_TrueState
    \value OffNormalAlarmType_ConfirmedState_FalseState
    \value OffNormalAlarmType_Acknowledge
    \value OffNormalAlarmType_Acknowledge_InputArguments
    \value OffNormalAlarmType_Confirm
    \value OffNormalAlarmType_Confirm_InputArguments
    \value OffNormalAlarmType_ActiveState
    \value OffNormalAlarmType_ActiveState_Id
    \value OffNormalAlarmType_ActiveState_Name
    \value OffNormalAlarmType_ActiveState_Number
    \value OffNormalAlarmType_ActiveState_EffectiveDisplayName
    \value OffNormalAlarmType_ActiveState_TransitionTime
    \value OffNormalAlarmType_ActiveState_EffectiveTransitionTime
    \value OffNormalAlarmType_ActiveState_TrueState
    \value OffNormalAlarmType_ActiveState_FalseState
    \value OffNormalAlarmType_SuppressedState
    \value OffNormalAlarmType_SuppressedState_Id
    \value OffNormalAlarmType_SuppressedState_Name
    \value OffNormalAlarmType_SuppressedState_Number
    \value OffNormalAlarmType_SuppressedState_EffectiveDisplayName
    \value OffNormalAlarmType_SuppressedState_TransitionTime
    \value OffNormalAlarmType_SuppressedState_EffectiveTransitionTime
    \value OffNormalAlarmType_SuppressedState_TrueState
    \value OffNormalAlarmType_SuppressedState_FalseState
    \value OffNormalAlarmType_ShelvingState
    \value OffNormalAlarmType_ShelvingState_CurrentState
    \value OffNormalAlarmType_ShelvingState_CurrentState_Id
    \value OffNormalAlarmType_ShelvingState_CurrentState_Name
    \value OffNormalAlarmType_ShelvingState_CurrentState_Number
    \value OffNormalAlarmType_ShelvingState_CurrentState_EffectiveDisplayName
    \value OffNormalAlarmType_ShelvingState_LastTransition
    \value OffNormalAlarmType_ShelvingState_LastTransition_Id
    \value OffNormalAlarmType_ShelvingState_LastTransition_Name
    \value OffNormalAlarmType_ShelvingState_LastTransition_Number
    \value OffNormalAlarmType_ShelvingState_LastTransition_TransitionTime
    \value OffNormalAlarmType_ShelvingState_UnshelveTime
    \value OffNormalAlarmType_ShelvingState_Unshelve
    \value OffNormalAlarmType_ShelvingState_OneShotShelve
    \value OffNormalAlarmType_ShelvingState_TimedShelve
    \value OffNormalAlarmType_ShelvingState_TimedShelve_InputArguments
    \value OffNormalAlarmType_SuppressedOrShelved
    \value OffNormalAlarmType_MaxTimeShelved
    \value TripAlarmType
    \value TripAlarmType_EventId
    \value TripAlarmType_EventType
    \value TripAlarmType_SourceNode
    \value TripAlarmType_SourceName
    \value TripAlarmType_Time
    \value TripAlarmType_ReceiveTime
    \value TripAlarmType_LocalTime
    \value TripAlarmType_Message
    \value TripAlarmType_Severity
    \value TripAlarmType_ConditionName
    \value TripAlarmType_BranchId
    \value TripAlarmType_Retain
    \value TripAlarmType_EnabledState
    \value TripAlarmType_EnabledState_Id
    \value TripAlarmType_EnabledState_Name
    \value TripAlarmType_EnabledState_Number
    \value TripAlarmType_EnabledState_EffectiveDisplayName
    \value TripAlarmType_EnabledState_TransitionTime
    \value TripAlarmType_EnabledState_EffectiveTransitionTime
    \value TripAlarmType_EnabledState_TrueState
    \value TripAlarmType_EnabledState_FalseState
    \value TripAlarmType_Quality
    \value TripAlarmType_Quality_SourceTimestamp
    \value TripAlarmType_LastSeverity
    \value TripAlarmType_LastSeverity_SourceTimestamp
    \value TripAlarmType_Comment
    \value TripAlarmType_Comment_SourceTimestamp
    \value TripAlarmType_ClientUserId
    \value TripAlarmType_Enable
    \value TripAlarmType_Disable
    \value TripAlarmType_AddComment
    \value TripAlarmType_AddComment_InputArguments
    \value TripAlarmType_ConditionRefresh
    \value TripAlarmType_ConditionRefresh_InputArguments
    \value TripAlarmType_AckedState
    \value TripAlarmType_AckedState_Id
    \value TripAlarmType_AckedState_Name
    \value TripAlarmType_AckedState_Number
    \value TripAlarmType_AckedState_EffectiveDisplayName
    \value TripAlarmType_AckedState_TransitionTime
    \value TripAlarmType_AckedState_EffectiveTransitionTime
    \value TripAlarmType_AckedState_TrueState
    \value TripAlarmType_AckedState_FalseState
    \value TripAlarmType_ConfirmedState
    \value TripAlarmType_ConfirmedState_Id
    \value TripAlarmType_ConfirmedState_Name
    \value TripAlarmType_ConfirmedState_Number
    \value TripAlarmType_ConfirmedState_EffectiveDisplayName
    \value TripAlarmType_ConfirmedState_TransitionTime
    \value TripAlarmType_ConfirmedState_EffectiveTransitionTime
    \value TripAlarmType_ConfirmedState_TrueState
    \value TripAlarmType_ConfirmedState_FalseState
    \value TripAlarmType_Acknowledge
    \value TripAlarmType_Acknowledge_InputArguments
    \value TripAlarmType_Confirm
    \value TripAlarmType_Confirm_InputArguments
    \value TripAlarmType_ActiveState
    \value TripAlarmType_ActiveState_Id
    \value TripAlarmType_ActiveState_Name
    \value TripAlarmType_ActiveState_Number
    \value TripAlarmType_ActiveState_EffectiveDisplayName
    \value TripAlarmType_ActiveState_TransitionTime
    \value TripAlarmType_ActiveState_EffectiveTransitionTime
    \value TripAlarmType_ActiveState_TrueState
    \value TripAlarmType_ActiveState_FalseState
    \value TripAlarmType_SuppressedState
    \value TripAlarmType_SuppressedState_Id
    \value TripAlarmType_SuppressedState_Name
    \value TripAlarmType_SuppressedState_Number
    \value TripAlarmType_SuppressedState_EffectiveDisplayName
    \value TripAlarmType_SuppressedState_TransitionTime
    \value TripAlarmType_SuppressedState_EffectiveTransitionTime
    \value TripAlarmType_SuppressedState_TrueState
    \value TripAlarmType_SuppressedState_FalseState
    \value TripAlarmType_ShelvingState
    \value TripAlarmType_ShelvingState_CurrentState
    \value TripAlarmType_ShelvingState_CurrentState_Id
    \value TripAlarmType_ShelvingState_CurrentState_Name
    \value TripAlarmType_ShelvingState_CurrentState_Number
    \value TripAlarmType_ShelvingState_CurrentState_EffectiveDisplayName
    \value TripAlarmType_ShelvingState_LastTransition
    \value TripAlarmType_ShelvingState_LastTransition_Id
    \value TripAlarmType_ShelvingState_LastTransition_Name
    \value TripAlarmType_ShelvingState_LastTransition_Number
    \value TripAlarmType_ShelvingState_LastTransition_TransitionTime
    \value TripAlarmType_ShelvingState_UnshelveTime
    \value TripAlarmType_ShelvingState_Unshelve
    \value TripAlarmType_ShelvingState_OneShotShelve
    \value TripAlarmType_ShelvingState_TimedShelve
    \value TripAlarmType_ShelvingState_TimedShelve_InputArguments
    \value TripAlarmType_SuppressedOrShelved
    \value TripAlarmType_MaxTimeShelved
    \value AuditConditionShelvingEventType
    \value AuditConditionShelvingEventType_EventId
    \value AuditConditionShelvingEventType_EventType
    \value AuditConditionShelvingEventType_SourceNode
    \value AuditConditionShelvingEventType_SourceName
    \value AuditConditionShelvingEventType_Time
    \value AuditConditionShelvingEventType_ReceiveTime
    \value AuditConditionShelvingEventType_LocalTime
    \value AuditConditionShelvingEventType_Message
    \value AuditConditionShelvingEventType_Severity
    \value AuditConditionShelvingEventType_ActionTimeStamp
    \value AuditConditionShelvingEventType_Status
    \value AuditConditionShelvingEventType_ServerId
    \value AuditConditionShelvingEventType_ClientAuditEntryId
    \value AuditConditionShelvingEventType_ClientUserId
    \value AuditConditionShelvingEventType_MethodId
    \value AuditConditionShelvingEventType_InputArguments
    \value TwoStateVariableType_TrueState
    \value TwoStateVariableType_FalseState
    \value ConditionType_ConditionClassId
    \value ConditionType_ConditionClassName
    \value DialogConditionType_ConditionClassId
    \value DialogConditionType_ConditionClassName
    \value AcknowledgeableConditionType_ConditionClassId
    \value AcknowledgeableConditionType_ConditionClassName
    \value AlarmConditionType_ConditionClassId
    \value AlarmConditionType_ConditionClassName
    \value AlarmConditionType_InputNode
    \value LimitAlarmType_ConditionClassId
    \value LimitAlarmType_ConditionClassName
    \value LimitAlarmType_InputNode
    \value LimitAlarmType_HighHighLimit
    \value LimitAlarmType_HighLimit
    \value LimitAlarmType_LowLimit
    \value LimitAlarmType_LowLowLimit
    \value ExclusiveLimitAlarmType_ConditionClassId
    \value ExclusiveLimitAlarmType_ConditionClassName
    \value ExclusiveLimitAlarmType_InputNode
    \value ExclusiveLevelAlarmType_ConditionClassId
    \value ExclusiveLevelAlarmType_ConditionClassName
    \value ExclusiveLevelAlarmType_InputNode
    \value ExclusiveRateOfChangeAlarmType_ConditionClassId
    \value ExclusiveRateOfChangeAlarmType_ConditionClassName
    \value ExclusiveRateOfChangeAlarmType_InputNode
    \value ExclusiveDeviationAlarmType_ConditionClassId
    \value ExclusiveDeviationAlarmType_ConditionClassName
    \value ExclusiveDeviationAlarmType_InputNode
    \value NonExclusiveLimitAlarmType_ConditionClassId
    \value NonExclusiveLimitAlarmType_ConditionClassName
    \value NonExclusiveLimitAlarmType_InputNode
    \value NonExclusiveLevelAlarmType_ConditionClassId
    \value NonExclusiveLevelAlarmType_ConditionClassName
    \value NonExclusiveLevelAlarmType_InputNode
    \value NonExclusiveRateOfChangeAlarmType_ConditionClassId
    \value NonExclusiveRateOfChangeAlarmType_ConditionClassName
    \value NonExclusiveRateOfChangeAlarmType_InputNode
    \value NonExclusiveDeviationAlarmType_ConditionClassId
    \value NonExclusiveDeviationAlarmType_ConditionClassName
    \value NonExclusiveDeviationAlarmType_InputNode
    \value DiscreteAlarmType_ConditionClassId
    \value DiscreteAlarmType_ConditionClassName
    \value DiscreteAlarmType_InputNode
    \value OffNormalAlarmType_ConditionClassId
    \value OffNormalAlarmType_ConditionClassName
    \value OffNormalAlarmType_InputNode
    \value OffNormalAlarmType_NormalState
    \value TripAlarmType_ConditionClassId
    \value TripAlarmType_ConditionClassName
    \value TripAlarmType_InputNode
    \value TripAlarmType_NormalState
    \value BaseConditionClassType
    \value ProcessConditionClassType
    \value MaintenanceConditionClassType
    \value SystemConditionClassType
    \value HistoricalDataConfigurationType_AggregateConfiguration_TreatUncertainAsBad
    \value HistoricalDataConfigurationType_AggregateConfiguration_PercentDataBad
    \value HistoricalDataConfigurationType_AggregateConfiguration_PercentDataGood
    \value HistoricalDataConfigurationType_AggregateConfiguration_UseSlopedExtrapolation
    \value HistoryServerCapabilitiesType_AggregateFunctions
    \value AggregateConfigurationType
    \value AggregateConfigurationType_TreatUncertainAsBad
    \value AggregateConfigurationType_PercentDataBad
    \value AggregateConfigurationType_PercentDataGood
    \value AggregateConfigurationType_UseSlopedExtrapolation
    \value HistoryServerCapabilities
    \value HistoryServerCapabilities_AccessHistoryDataCapability
    \value HistoryServerCapabilities_InsertDataCapability
    \value HistoryServerCapabilities_ReplaceDataCapability
    \value HistoryServerCapabilities_UpdateDataCapability
    \value HistoryServerCapabilities_DeleteRawCapability
    \value HistoryServerCapabilities_DeleteAtTimeCapability
    \value HistoryServerCapabilities_AggregateFunctions
    \value HAConfiguration
    \value HAConfiguration_AggregateConfiguration
    \value HAConfiguration_AggregateConfiguration_TreatUncertainAsBad
    \value HAConfiguration_AggregateConfiguration_PercentDataBad
    \value HAConfiguration_AggregateConfiguration_PercentDataGood
    \value HAConfiguration_AggregateConfiguration_UseSlopedExtrapolation
    \value HAConfiguration_Stepped
    \value HAConfiguration_Definition
    \value HAConfiguration_MaxTimeInterval
    \value HAConfiguration_MinTimeInterval
    \value HAConfiguration_ExceptionDeviation
    \value HAConfiguration_ExceptionDeviationFormat
    \value Annotations
    \value HistoricalEventFilter
    \value ModificationInfo
    \value HistoryModifiedData
    \value ModificationInfo_Encoding_DefaultXml
    \value HistoryModifiedData_Encoding_DefaultXml
    \value ModificationInfo_Encoding_DefaultBinary
    \value HistoryModifiedData_Encoding_DefaultBinary
    \value HistoryUpdateType
    \value MultiStateValueDiscreteType
    \value MultiStateValueDiscreteType_Definition
    \value MultiStateValueDiscreteType_ValuePrecision
    \value MultiStateValueDiscreteType_EnumValues
    \value HistoryServerCapabilities_AccessHistoryEventsCapability
    \value HistoryServerCapabilitiesType_MaxReturnDataValues
    \value HistoryServerCapabilitiesType_MaxReturnEventValues
    \value HistoryServerCapabilitiesType_InsertAnnotationCapability
    \value HistoryServerCapabilities_MaxReturnDataValues
    \value HistoryServerCapabilities_MaxReturnEventValues
    \value HistoryServerCapabilities_InsertAnnotationCapability
    \value HistoryServerCapabilitiesType_InsertEventCapability
    \value HistoryServerCapabilitiesType_ReplaceEventCapability
    \value HistoryServerCapabilitiesType_UpdateEventCapability
    \value HistoryServerCapabilities_InsertEventCapability
    \value HistoryServerCapabilities_ReplaceEventCapability
    \value HistoryServerCapabilities_UpdateEventCapability
    \value AggregateFunction_TimeAverage2
    \value AggregateFunction_Minimum2
    \value AggregateFunction_Maximum2
    \value AggregateFunction_Range2
    \value AggregateFunction_WorstQuality2
    \value PerformUpdateType
    \value UpdateStructureDataDetails
    \value UpdateStructureDataDetails_Encoding_DefaultXml
    \value UpdateStructureDataDetails_Encoding_DefaultBinary
    \value AggregateFunction_Total2
    \value AggregateFunction_MinimumActualTime2
    \value AggregateFunction_MaximumActualTime2
    \value AggregateFunction_DurationInStateZero
    \value AggregateFunction_DurationInStateNonZero
    \value Server_ServerRedundancy_CurrentServerId
    \value Server_ServerRedundancy_RedundantServerArray
    \value Server_ServerRedundancy_ServerUriArray
    \value ShelvedStateMachineType_UnshelvedToTimedShelved_TransitionNumber
    \value ShelvedStateMachineType_UnshelvedToOneShotShelved_TransitionNumber
    \value ShelvedStateMachineType_TimedShelvedToUnshelved_TransitionNumber
    \value ShelvedStateMachineType_TimedShelvedToOneShotShelved_TransitionNumber
    \value ShelvedStateMachineType_OneShotShelvedToUnshelved_TransitionNumber
    \value ShelvedStateMachineType_OneShotShelvedToTimedShelved_TransitionNumber
    \value ExclusiveLimitStateMachineType_LowLowToLow_TransitionNumber
    \value ExclusiveLimitStateMachineType_LowToLowLow_TransitionNumber
    \value ExclusiveLimitStateMachineType_HighHighToHigh_TransitionNumber
    \value ExclusiveLimitStateMachineType_HighToHighHigh_TransitionNumber
    \value AggregateFunction_StandardDeviationSample
    \value AggregateFunction_StandardDeviationPopulation
    \value AggregateFunction_VarianceSample
    \value AggregateFunction_VariancePopulation
    \value EnumStrings
    \value ValueAsText
    \value ProgressEventType
    \value ProgressEventType_EventId
    \value ProgressEventType_EventType
    \value ProgressEventType_SourceNode
    \value ProgressEventType_SourceName
    \value ProgressEventType_Time
    \value ProgressEventType_ReceiveTime
    \value ProgressEventType_LocalTime
    \value ProgressEventType_Message
    \value ProgressEventType_Severity
    \value SystemStatusChangeEventType
    \value SystemStatusChangeEventType_EventId
    \value SystemStatusChangeEventType_EventType
    \value SystemStatusChangeEventType_SourceNode
    \value SystemStatusChangeEventType_SourceName
    \value SystemStatusChangeEventType_Time
    \value SystemStatusChangeEventType_ReceiveTime
    \value SystemStatusChangeEventType_LocalTime
    \value SystemStatusChangeEventType_Message
    \value SystemStatusChangeEventType_Severity
    \value TransitionVariableType_EffectiveTransitionTime
    \value FiniteTransitionVariableType_EffectiveTransitionTime
    \value StateMachineType_LastTransition_EffectiveTransitionTime
    \value FiniteStateMachineType_LastTransition_EffectiveTransitionTime
    \value TransitionEventType_Transition_EffectiveTransitionTime
    \value MultiStateValueDiscreteType_ValueAsText
    \value ProgramTransitionEventType_Transition_EffectiveTransitionTime
    \value ProgramTransitionAuditEventType_Transition_EffectiveTransitionTime
    \value ProgramStateMachineType_LastTransition_EffectiveTransitionTime
    \value ShelvedStateMachineType_LastTransition_EffectiveTransitionTime
    \value AlarmConditionType_ShelvingState_LastTransition_EffectiveTransitionTime
    \value LimitAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime
    \value ExclusiveLimitStateMachineType_LastTransition_EffectiveTransitionTime
    \value ExclusiveLimitAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime
    \value ExclusiveLimitAlarmType_LimitState_LastTransition_EffectiveTransitionTime
    \value ExclusiveLevelAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime
    \value ExclusiveLevelAlarmType_LimitState_LastTransition_EffectiveTransitionTime
    \value ExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime
    \value ExclusiveRateOfChangeAlarmType_LimitState_LastTransition_EffectiveTransitionTime
    \value ExclusiveDeviationAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime
    \value ExclusiveDeviationAlarmType_LimitState_LastTransition_EffectiveTransitionTime
    \value NonExclusiveLimitAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime
    \value NonExclusiveLevelAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime
    \value NonExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime
    \value NonExclusiveDeviationAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime
    \value DiscreteAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime
    \value OffNormalAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime
    \value TripAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime
    \value AuditActivateSessionEventType_SecureChannelId
    \value OptionSetType
    \value OptionSetType_OptionSetValues
    \value ServerType_GetMonitoredItems
    \value ServerType_GetMonitoredItems_InputArguments
    \value ServerType_GetMonitoredItems_OutputArguments
    \value Server_GetMonitoredItems
    \value Server_GetMonitoredItems_InputArguments
    \value Server_GetMonitoredItems_OutputArguments
    \value GetMonitoredItemsMethodType
    \value GetMonitoredItemsMethodType_InputArguments
    \value GetMonitoredItemsMethodType_OutputArguments
    \value MaxStringLength
    \value HistoricalDataConfigurationType_StartOfArchive
    \value HistoricalDataConfigurationType_StartOfOnlineArchive
    \value HistoryServerCapabilitiesType_DeleteEventCapability
    \value HistoryServerCapabilities_DeleteEventCapability
    \value HAConfiguration_StartOfArchive
    \value HAConfiguration_StartOfOnlineArchive
    \value AggregateFunction_StartBound
    \value AggregateFunction_EndBound
    \value AggregateFunction_DeltaBounds
    \value ModellingRule_OptionalPlaceholder
    \value ModellingRule_OptionalPlaceholder_NamingRule
    \value ModellingRule_MandatoryPlaceholder
    \value ModellingRule_MandatoryPlaceholder_NamingRule
    \value MaxArrayLength
    \value EngineeringUnits
    \value ServerType_ServerCapabilities_MaxArrayLength
    \value ServerType_ServerCapabilities_MaxStringLength
    \value ServerType_ServerCapabilities_OperationLimits
    \value ServerType_ServerCapabilities_OperationLimits_MaxNodesPerRead
    \value ServerType_ServerCapabilities_OperationLimits_MaxNodesPerWrite
    \value ServerType_ServerCapabilities_OperationLimits_MaxNodesPerMethodCall
    \value ServerType_ServerCapabilities_OperationLimits_MaxNodesPerBrowse
    \value ServerType_ServerCapabilities_OperationLimits_MaxNodesPerRegisterNodes
    \value ServerType_ServerCapabilities_OperationLimits_MaxNodesPerTranslateBrowsePathsToNodeIds
    \value ServerType_ServerCapabilities_OperationLimits_MaxNodesPerNodeManagement
    \value ServerType_ServerCapabilities_OperationLimits_MaxMonitoredItemsPerCall
    \value ServerType_Namespaces
    \value ServerType_Namespaces_AddressSpaceFile
    \value ServerType_Namespaces_AddressSpaceFile_Size
    \value ServerType_Namespaces_AddressSpaceFile_OpenCount
    \value ServerType_Namespaces_AddressSpaceFile_Open
    \value ServerType_Namespaces_AddressSpaceFile_Open_InputArguments
    \value ServerType_Namespaces_AddressSpaceFile_Open_OutputArguments
    \value ServerType_Namespaces_AddressSpaceFile_Close
    \value ServerType_Namespaces_AddressSpaceFile_Close_InputArguments
    \value ServerType_Namespaces_AddressSpaceFile_Read
    \value ServerType_Namespaces_AddressSpaceFile_Read_InputArguments
    \value ServerType_Namespaces_AddressSpaceFile_Read_OutputArguments
    \value ServerType_Namespaces_AddressSpaceFile_Write
    \value ServerType_Namespaces_AddressSpaceFile_Write_InputArguments
    \value ServerType_Namespaces_AddressSpaceFile_GetPosition
    \value ServerType_Namespaces_AddressSpaceFile_GetPosition_InputArguments
    \value ServerType_Namespaces_AddressSpaceFile_GetPosition_OutputArguments
    \value ServerType_Namespaces_AddressSpaceFile_SetPosition
    \value ServerType_Namespaces_AddressSpaceFile_SetPosition_InputArguments
    \value ServerType_Namespaces_AddressSpaceFile_ExportNamespace
    \value ServerCapabilitiesType_MaxArrayLength
    \value ServerCapabilitiesType_MaxStringLength
    \value ServerCapabilitiesType_OperationLimits
    \value ServerCapabilitiesType_OperationLimits_MaxNodesPerRead
    \value ServerCapabilitiesType_OperationLimits_MaxNodesPerWrite
    \value ServerCapabilitiesType_OperationLimits_MaxNodesPerMethodCall
    \value ServerCapabilitiesType_OperationLimits_MaxNodesPerBrowse
    \value ServerCapabilitiesType_OperationLimits_MaxNodesPerRegisterNodes
    \value ServerCapabilitiesType_OperationLimits_MaxNodesPerTranslateBrowsePathsToNodeIds
    \value ServerCapabilitiesType_OperationLimits_MaxNodesPerNodeManagement
    \value ServerCapabilitiesType_OperationLimits_MaxMonitoredItemsPerCall
    \value ServerCapabilitiesType_VendorCapability_Placeholder
    \value OperationLimitsType
    \value OperationLimitsType_MaxNodesPerRead
    \value OperationLimitsType_MaxNodesPerWrite
    \value OperationLimitsType_MaxNodesPerMethodCall
    \value OperationLimitsType_MaxNodesPerBrowse
    \value OperationLimitsType_MaxNodesPerRegisterNodes
    \value OperationLimitsType_MaxNodesPerTranslateBrowsePathsToNodeIds
    \value OperationLimitsType_MaxNodesPerNodeManagement
    \value OperationLimitsType_MaxMonitoredItemsPerCall
    \value FileType
    \value FileType_Size
    \value FileType_OpenCount
    \value FileType_Open
    \value FileType_Open_InputArguments
    \value FileType_Open_OutputArguments
    \value FileType_Close
    \value FileType_Close_InputArguments
    \value FileType_Read
    \value FileType_Read_InputArguments
    \value FileType_Read_OutputArguments
    \value FileType_Write
    \value FileType_Write_InputArguments
    \value FileType_GetPosition
    \value FileType_GetPosition_InputArguments
    \value FileType_GetPosition_OutputArguments
    \value FileType_SetPosition
    \value FileType_SetPosition_InputArguments
    \value AddressSpaceFileType
    \value AddressSpaceFileType_Size
    \value AddressSpaceFileType_OpenCount
    \value AddressSpaceFileType_Open
    \value AddressSpaceFileType_Open_InputArguments
    \value AddressSpaceFileType_Open_OutputArguments
    \value AddressSpaceFileType_Close
    \value AddressSpaceFileType_Close_InputArguments
    \value AddressSpaceFileType_Read
    \value AddressSpaceFileType_Read_InputArguments
    \value AddressSpaceFileType_Read_OutputArguments
    \value AddressSpaceFileType_Write
    \value AddressSpaceFileType_Write_InputArguments
    \value AddressSpaceFileType_GetPosition
    \value AddressSpaceFileType_GetPosition_InputArguments
    \value AddressSpaceFileType_GetPosition_OutputArguments
    \value AddressSpaceFileType_SetPosition
    \value AddressSpaceFileType_SetPosition_InputArguments
    \value AddressSpaceFileType_ExportNamespace
    \value NamespaceMetadataType
    \value NamespaceMetadataType_NamespaceUri
    \value NamespaceMetadataType_NamespaceVersion
    \value NamespaceMetadataType_NamespacePublicationDate
    \value NamespaceMetadataType_IsNamespaceSubset
    \value NamespaceMetadataType_StaticNodeIdTypes
    \value NamespaceMetadataType_StaticNumericNodeIdRange
    \value NamespaceMetadataType_StaticStringNodeIdPattern
    \value NamespaceMetadataType_NamespaceFile
    \value NamespaceMetadataType_NamespaceFile_Size
    \value NamespaceMetadataType_NamespaceFile_OpenCount
    \value NamespaceMetadataType_NamespaceFile_Open
    \value NamespaceMetadataType_NamespaceFile_Open_InputArguments
    \value NamespaceMetadataType_NamespaceFile_Open_OutputArguments
    \value NamespaceMetadataType_NamespaceFile_Close
    \value NamespaceMetadataType_NamespaceFile_Close_InputArguments
    \value NamespaceMetadataType_NamespaceFile_Read
    \value NamespaceMetadataType_NamespaceFile_Read_InputArguments
    \value NamespaceMetadataType_NamespaceFile_Read_OutputArguments
    \value NamespaceMetadataType_NamespaceFile_Write
    \value NamespaceMetadataType_NamespaceFile_Write_InputArguments
    \value NamespaceMetadataType_NamespaceFile_GetPosition
    \value NamespaceMetadataType_NamespaceFile_GetPosition_InputArguments
    \value NamespaceMetadataType_NamespaceFile_GetPosition_OutputArguments
    \value NamespaceMetadataType_NamespaceFile_SetPosition
    \value NamespaceMetadataType_NamespaceFile_SetPosition_InputArguments
    \value NamespaceMetadataType_NamespaceFile_ExportNamespace
    \value NamespacesType
    \value NamespacesType_NamespaceIdentifier_Placeholder
    \value NamespacesType_NamespaceIdentifier_Placeholder_NamespaceUri
    \value NamespacesType_NamespaceIdentifier_Placeholder_NamespaceVersion
    \value NamespacesType_NamespaceIdentifier_Placeholder_NamespacePublicationDate
    \value NamespacesType_NamespaceIdentifier_Placeholder_IsNamespaceSubset
    \value NamespacesType_NamespaceIdentifier_Placeholder_StaticNodeIdTypes
    \value NamespacesType_NamespaceIdentifier_Placeholder_StaticNumericNodeIdRange
    \value NamespacesType_NamespaceIdentifier_Placeholder_StaticStringNodeIdPattern
    \value NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile
    \value NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Size
    \value NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_OpenCount
    \value NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Open
    \value NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Open_InputArguments
    \value NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Open_OutputArguments
    \value NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Close
    \value NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Close_InputArguments
    \value NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Read
    \value NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Read_InputArguments
    \value NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Read_OutputArguments
    \value NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Write
    \value NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Write_InputArguments
    \value NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_GetPosition
    \value NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_GetPosition_InputArguments
    \value NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_GetPosition_OutputArguments
    \value NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_SetPosition
    \value NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_SetPosition_InputArguments
    \value NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_ExportNamespace
    \value NamespacesType_AddressSpaceFile
    \value NamespacesType_AddressSpaceFile_Size
    \value NamespacesType_AddressSpaceFile_OpenCount
    \value NamespacesType_AddressSpaceFile_Open
    \value NamespacesType_AddressSpaceFile_Open_InputArguments
    \value NamespacesType_AddressSpaceFile_Open_OutputArguments
    \value NamespacesType_AddressSpaceFile_Close
    \value NamespacesType_AddressSpaceFile_Close_InputArguments
    \value NamespacesType_AddressSpaceFile_Read
    \value NamespacesType_AddressSpaceFile_Read_InputArguments
    \value NamespacesType_AddressSpaceFile_Read_OutputArguments
    \value NamespacesType_AddressSpaceFile_Write
    \value NamespacesType_AddressSpaceFile_Write_InputArguments
    \value NamespacesType_AddressSpaceFile_GetPosition
    \value NamespacesType_AddressSpaceFile_GetPosition_InputArguments
    \value NamespacesType_AddressSpaceFile_GetPosition_OutputArguments
    \value NamespacesType_AddressSpaceFile_SetPosition
    \value NamespacesType_AddressSpaceFile_SetPosition_InputArguments
    \value NamespacesType_AddressSpaceFile_ExportNamespace
    \value SystemStatusChangeEventType_SystemState
    \value SamplingIntervalDiagnosticsType_SampledMonitoredItemsCount
    \value SamplingIntervalDiagnosticsType_MaxSampledMonitoredItemsCount
    \value SamplingIntervalDiagnosticsType_DisabledMonitoredItemsSamplingCount
    \value OptionSetType_BitMask
    \value Server_ServerCapabilities_MaxArrayLength
    \value Server_ServerCapabilities_MaxStringLength
    \value Server_ServerCapabilities_OperationLimits
    \value Server_ServerCapabilities_OperationLimits_MaxNodesPerRead
    \value Server_ServerCapabilities_OperationLimits_MaxNodesPerWrite
    \value Server_ServerCapabilities_OperationLimits_MaxNodesPerMethodCall
    \value Server_ServerCapabilities_OperationLimits_MaxNodesPerBrowse
    \value Server_ServerCapabilities_OperationLimits_MaxNodesPerRegisterNodes
    \value Server_ServerCapabilities_OperationLimits_MaxNodesPerTranslateBrowsePathsToNodeIds
    \value Server_ServerCapabilities_OperationLimits_MaxNodesPerNodeManagement
    \value Server_ServerCapabilities_OperationLimits_MaxMonitoredItemsPerCall
    \value Server_Namespaces
    \value Server_Namespaces_AddressSpaceFile
    \value Server_Namespaces_AddressSpaceFile_Size
    \value Server_Namespaces_AddressSpaceFile_OpenCount
    \value Server_Namespaces_AddressSpaceFile_Open
    \value Server_Namespaces_AddressSpaceFile_Open_InputArguments
    \value Server_Namespaces_AddressSpaceFile_Open_OutputArguments
    \value Server_Namespaces_AddressSpaceFile_Close
    \value Server_Namespaces_AddressSpaceFile_Close_InputArguments
    \value Server_Namespaces_AddressSpaceFile_Read
    \value Server_Namespaces_AddressSpaceFile_Read_InputArguments
    \value Server_Namespaces_AddressSpaceFile_Read_OutputArguments
    \value Server_Namespaces_AddressSpaceFile_Write
    \value Server_Namespaces_AddressSpaceFile_Write_InputArguments
    \value Server_Namespaces_AddressSpaceFile_GetPosition
    \value Server_Namespaces_AddressSpaceFile_GetPosition_InputArguments
    \value Server_Namespaces_AddressSpaceFile_GetPosition_OutputArguments
    \value Server_Namespaces_AddressSpaceFile_SetPosition
    \value Server_Namespaces_AddressSpaceFile_SetPosition_InputArguments
    \value Server_Namespaces_AddressSpaceFile_ExportNamespace
    \value BitFieldMaskDataType
    \value OpenMethodType
    \value OpenMethodType_InputArguments
    \value OpenMethodType_OutputArguments
    \value CloseMethodType
    \value CloseMethodType_InputArguments
    \value ReadMethodType
    \value ReadMethodType_InputArguments
    \value ReadMethodType_OutputArguments
    \value WriteMethodType
    \value WriteMethodType_InputArguments
    \value GetPositionMethodType
    \value GetPositionMethodType_InputArguments
    \value GetPositionMethodType_OutputArguments
    \value SetPositionMethodType
    \value SetPositionMethodType_InputArguments
    \value SystemOffNormalAlarmType
    \value SystemOffNormalAlarmType_EventId
    \value SystemOffNormalAlarmType_EventType
    \value SystemOffNormalAlarmType_SourceNode
    \value SystemOffNormalAlarmType_SourceName
    \value SystemOffNormalAlarmType_Time
    \value SystemOffNormalAlarmType_ReceiveTime
    \value SystemOffNormalAlarmType_LocalTime
    \value SystemOffNormalAlarmType_Message
    \value SystemOffNormalAlarmType_Severity
    \value SystemOffNormalAlarmType_ConditionClassId
    \value SystemOffNormalAlarmType_ConditionClassName
    \value SystemOffNormalAlarmType_ConditionName
    \value SystemOffNormalAlarmType_BranchId
    \value SystemOffNormalAlarmType_Retain
    \value SystemOffNormalAlarmType_EnabledState
    \value SystemOffNormalAlarmType_EnabledState_Id
    \value SystemOffNormalAlarmType_EnabledState_Name
    \value SystemOffNormalAlarmType_EnabledState_Number
    \value SystemOffNormalAlarmType_EnabledState_EffectiveDisplayName
    \value SystemOffNormalAlarmType_EnabledState_TransitionTime
    \value SystemOffNormalAlarmType_EnabledState_EffectiveTransitionTime
    \value SystemOffNormalAlarmType_EnabledState_TrueState
    \value SystemOffNormalAlarmType_EnabledState_FalseState
    \value SystemOffNormalAlarmType_Quality
    \value SystemOffNormalAlarmType_Quality_SourceTimestamp
    \value SystemOffNormalAlarmType_LastSeverity
    \value SystemOffNormalAlarmType_LastSeverity_SourceTimestamp
    \value SystemOffNormalAlarmType_Comment
    \value SystemOffNormalAlarmType_Comment_SourceTimestamp
    \value SystemOffNormalAlarmType_ClientUserId
    \value SystemOffNormalAlarmType_Disable
    \value SystemOffNormalAlarmType_Enable
    \value SystemOffNormalAlarmType_AddComment
    \value SystemOffNormalAlarmType_AddComment_InputArguments
    \value SystemOffNormalAlarmType_ConditionRefresh
    \value SystemOffNormalAlarmType_ConditionRefresh_InputArguments
    \value SystemOffNormalAlarmType_AckedState
    \value SystemOffNormalAlarmType_AckedState_Id
    \value SystemOffNormalAlarmType_AckedState_Name
    \value SystemOffNormalAlarmType_AckedState_Number
    \value SystemOffNormalAlarmType_AckedState_EffectiveDisplayName
    \value SystemOffNormalAlarmType_AckedState_TransitionTime
    \value SystemOffNormalAlarmType_AckedState_EffectiveTransitionTime
    \value SystemOffNormalAlarmType_AckedState_TrueState
    \value SystemOffNormalAlarmType_AckedState_FalseState
    \value SystemOffNormalAlarmType_ConfirmedState
    \value SystemOffNormalAlarmType_ConfirmedState_Id
    \value SystemOffNormalAlarmType_ConfirmedState_Name
    \value SystemOffNormalAlarmType_ConfirmedState_Number
    \value SystemOffNormalAlarmType_ConfirmedState_EffectiveDisplayName
    \value SystemOffNormalAlarmType_ConfirmedState_TransitionTime
    \value SystemOffNormalAlarmType_ConfirmedState_EffectiveTransitionTime
    \value SystemOffNormalAlarmType_ConfirmedState_TrueState
    \value SystemOffNormalAlarmType_ConfirmedState_FalseState
    \value SystemOffNormalAlarmType_Acknowledge
    \value SystemOffNormalAlarmType_Acknowledge_InputArguments
    \value SystemOffNormalAlarmType_Confirm
    \value SystemOffNormalAlarmType_Confirm_InputArguments
    \value SystemOffNormalAlarmType_ActiveState
    \value SystemOffNormalAlarmType_ActiveState_Id
    \value SystemOffNormalAlarmType_ActiveState_Name
    \value SystemOffNormalAlarmType_ActiveState_Number
    \value SystemOffNormalAlarmType_ActiveState_EffectiveDisplayName
    \value SystemOffNormalAlarmType_ActiveState_TransitionTime
    \value SystemOffNormalAlarmType_ActiveState_EffectiveTransitionTime
    \value SystemOffNormalAlarmType_ActiveState_TrueState
    \value SystemOffNormalAlarmType_ActiveState_FalseState
    \value SystemOffNormalAlarmType_InputNode
    \value SystemOffNormalAlarmType_SuppressedState
    \value SystemOffNormalAlarmType_SuppressedState_Id
    \value SystemOffNormalAlarmType_SuppressedState_Name
    \value SystemOffNormalAlarmType_SuppressedState_Number
    \value SystemOffNormalAlarmType_SuppressedState_EffectiveDisplayName
    \value SystemOffNormalAlarmType_SuppressedState_TransitionTime
    \value SystemOffNormalAlarmType_SuppressedState_EffectiveTransitionTime
    \value SystemOffNormalAlarmType_SuppressedState_TrueState
    \value SystemOffNormalAlarmType_SuppressedState_FalseState
    \value SystemOffNormalAlarmType_ShelvingState
    \value SystemOffNormalAlarmType_ShelvingState_CurrentState
    \value SystemOffNormalAlarmType_ShelvingState_CurrentState_Id
    \value SystemOffNormalAlarmType_ShelvingState_CurrentState_Name
    \value SystemOffNormalAlarmType_ShelvingState_CurrentState_Number
    \value SystemOffNormalAlarmType_ShelvingState_CurrentState_EffectiveDisplayName
    \value SystemOffNormalAlarmType_ShelvingState_LastTransition
    \value SystemOffNormalAlarmType_ShelvingState_LastTransition_Id
    \value SystemOffNormalAlarmType_ShelvingState_LastTransition_Name
    \value SystemOffNormalAlarmType_ShelvingState_LastTransition_Number
    \value SystemOffNormalAlarmType_ShelvingState_LastTransition_TransitionTime
    \value SystemOffNormalAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime
    \value SystemOffNormalAlarmType_ShelvingState_UnshelveTime
    \value SystemOffNormalAlarmType_ShelvingState_Unshelve
    \value SystemOffNormalAlarmType_ShelvingState_OneShotShelve
    \value SystemOffNormalAlarmType_ShelvingState_TimedShelve
    \value SystemOffNormalAlarmType_ShelvingState_TimedShelve_InputArguments
    \value SystemOffNormalAlarmType_SuppressedOrShelved
    \value SystemOffNormalAlarmType_MaxTimeShelved
    \value SystemOffNormalAlarmType_NormalState
    \value AuditConditionCommentEventType_Comment
    \value AuditConditionRespondEventType_SelectedResponse
    \value AuditConditionAcknowledgeEventType_Comment
    \value AuditConditionConfirmEventType_Comment
    \value AuditConditionShelvingEventType_ShelvingTime
    \value AuditProgramTransitionEventType
    \value AuditProgramTransitionEventType_EventId
    \value AuditProgramTransitionEventType_EventType
    \value AuditProgramTransitionEventType_SourceNode
    \value AuditProgramTransitionEventType_SourceName
    \value AuditProgramTransitionEventType_Time
    \value AuditProgramTransitionEventType_ReceiveTime
    \value AuditProgramTransitionEventType_LocalTime
    \value AuditProgramTransitionEventType_Message
    \value AuditProgramTransitionEventType_Severity
    \value AuditProgramTransitionEventType_ActionTimeStamp
    \value AuditProgramTransitionEventType_Status
    \value AuditProgramTransitionEventType_ServerId
    \value AuditProgramTransitionEventType_ClientAuditEntryId
    \value AuditProgramTransitionEventType_ClientUserId
    \value AuditProgramTransitionEventType_MethodId
    \value AuditProgramTransitionEventType_InputArguments
    \value AuditProgramTransitionEventType_OldStateId
    \value AuditProgramTransitionEventType_NewStateId
    \value AuditProgramTransitionEventType_TransitionNumber
    \value HistoricalDataConfigurationType_AggregateFunctions
    \value HAConfiguration_AggregateFunctions
    \value NodeClass_EnumValues
    \value InstanceNode
    \value TypeNode
    \value NodeAttributesMask_EnumValues
    \value AttributeWriteMask_EnumValues
    \value BrowseResultMask_EnumValues
    \value HistoryUpdateType_EnumValues
    \value PerformUpdateType_EnumValues
    \value InstanceNode_Encoding_DefaultXml
    \value TypeNode_Encoding_DefaultXml
    \value InstanceNode_Encoding_DefaultBinary
    \value TypeNode_Encoding_DefaultBinary
    \value SessionDiagnosticsObjectType_SessionDiagnostics_UnauthorizedRequestCount
    \value SessionDiagnosticsVariableType_UnauthorizedRequestCount
    \value OpenFileMode
    \value OpenFileMode_EnumValues
    \value ModelChangeStructureVerbMask
    \value ModelChangeStructureVerbMask_EnumValues
    \value EndpointUrlListDataType
    \value NetworkGroupDataType
    \value NonTransparentNetworkRedundancyType
    \value NonTransparentNetworkRedundancyType_RedundancySupport
    \value NonTransparentNetworkRedundancyType_ServerUriArray
    \value NonTransparentNetworkRedundancyType_ServerNetworkGroups
    \value EndpointUrlListDataType_Encoding_DefaultXml
    \value NetworkGroupDataType_Encoding_DefaultXml
    \value OpcUa_XmlSchema_EndpointUrlListDataType
    \value OpcUa_XmlSchema_EndpointUrlListDataType_DataTypeVersion
    \value OpcUa_XmlSchema_EndpointUrlListDataType_DictionaryFragment
    \value OpcUa_XmlSchema_NetworkGroupDataType
    \value OpcUa_XmlSchema_NetworkGroupDataType_DataTypeVersion
    \value OpcUa_XmlSchema_NetworkGroupDataType_DictionaryFragment
    \value EndpointUrlListDataType_Encoding_DefaultBinary
    \value NetworkGroupDataType_Encoding_DefaultBinary
    \value OpcUa_BinarySchema_EndpointUrlListDataType
    \value OpcUa_BinarySchema_EndpointUrlListDataType_DataTypeVersion
    \value OpcUa_BinarySchema_EndpointUrlListDataType_DictionaryFragment
    \value OpcUa_BinarySchema_NetworkGroupDataType
    \value OpcUa_BinarySchema_NetworkGroupDataType_DataTypeVersion
    \value OpcUa_BinarySchema_NetworkGroupDataType_DictionaryFragment
    \value ArrayItemType
    \value ArrayItemType_Definition
    \value ArrayItemType_ValuePrecision
    \value ArrayItemType_InstrumentRange
    \value ArrayItemType_EURange
    \value ArrayItemType_EngineeringUnits
    \value ArrayItemType_Title
    \value ArrayItemType_AxisScaleType
    \value YArrayItemType
    \value YArrayItemType_Definition
    \value YArrayItemType_ValuePrecision
    \value YArrayItemType_InstrumentRange
    \value YArrayItemType_EURange
    \value YArrayItemType_EngineeringUnits
    \value YArrayItemType_Title
    \value YArrayItemType_AxisScaleType
    \value YArrayItemType_XAxisDefinition
    \value XYArrayItemType
    \value XYArrayItemType_Definition
    \value XYArrayItemType_ValuePrecision
    \value XYArrayItemType_InstrumentRange
    \value XYArrayItemType_EURange
    \value XYArrayItemType_EngineeringUnits
    \value XYArrayItemType_Title
    \value XYArrayItemType_AxisScaleType
    \value XYArrayItemType_XAxisDefinition
    \value ImageItemType
    \value ImageItemType_Definition
    \value ImageItemType_ValuePrecision
    \value ImageItemType_InstrumentRange
    \value ImageItemType_EURange
    \value ImageItemType_EngineeringUnits
    \value ImageItemType_Title
    \value ImageItemType_AxisScaleType
    \value ImageItemType_XAxisDefinition
    \value ImageItemType_YAxisDefinition
    \value CubeItemType
    \value CubeItemType_Definition
    \value CubeItemType_ValuePrecision
    \value CubeItemType_InstrumentRange
    \value CubeItemType_EURange
    \value CubeItemType_EngineeringUnits
    \value CubeItemType_Title
    \value CubeItemType_AxisScaleType
    \value CubeItemType_XAxisDefinition
    \value CubeItemType_YAxisDefinition
    \value CubeItemType_ZAxisDefinition
    \value NDimensionArrayItemType
    \value NDimensionArrayItemType_Definition
    \value NDimensionArrayItemType_ValuePrecision
    \value NDimensionArrayItemType_InstrumentRange
    \value NDimensionArrayItemType_EURange
    \value NDimensionArrayItemType_EngineeringUnits
    \value NDimensionArrayItemType_Title
    \value NDimensionArrayItemType_AxisScaleType
    \value NDimensionArrayItemType_AxisDefinition
    \value AxisScaleEnumeration
    \value AxisScaleEnumeration_EnumStrings
    \value AxisInformation
    \value XVType
    \value AxisInformation_Encoding_DefaultXml
    \value XVType_Encoding_DefaultXml
    \value OpcUa_XmlSchema_AxisInformation
    \value OpcUa_XmlSchema_AxisInformation_DataTypeVersion
    \value OpcUa_XmlSchema_AxisInformation_DictionaryFragment
    \value OpcUa_XmlSchema_XVType
    \value OpcUa_XmlSchema_XVType_DataTypeVersion
    \value OpcUa_XmlSchema_XVType_DictionaryFragment
    \value AxisInformation_Encoding_DefaultBinary
    \value XVType_Encoding_DefaultBinary
    \value OpcUa_BinarySchema_AxisInformation
    \value OpcUa_BinarySchema_AxisInformation_DataTypeVersion
    \value OpcUa_BinarySchema_AxisInformation_DictionaryFragment
    \value OpcUa_BinarySchema_XVType
    \value OpcUa_BinarySchema_XVType_DataTypeVersion
    \value OpcUa_BinarySchema_XVType_DictionaryFragment
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_SessionId
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_SessionName
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ClientDescription
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ServerUri
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_EndpointUrl
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_LocaleIds
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ActualSessionTimeout
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_MaxResponseMessageSize
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ClientConnectionTime
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ClientLastContactTime
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CurrentSubscriptionsCount
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CurrentMonitoredItemsCount
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CurrentPublishRequestsInQueue
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_TotalRequestCount
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_UnauthorizedRequestCount
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ReadCount
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_HistoryReadCount
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_WriteCount
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_HistoryUpdateCount
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CallCount
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CreateMonitoredItemsCount
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ModifyMonitoredItemsCount
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_SetMonitoringModeCount
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_SetTriggeringCount
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_DeleteMonitoredItemsCount
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CreateSubscriptionCount
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ModifySubscriptionCount
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_SetPublishingModeCount
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_PublishCount
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_RepublishCount
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_TransferSubscriptionsCount
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_DeleteSubscriptionsCount
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_AddNodesCount
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_AddReferencesCount
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_DeleteNodesCount
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_DeleteReferencesCount
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_BrowseCount
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_BrowseNextCount
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_TranslateBrowsePathsToNodeIdsCount
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_QueryFirstCount
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_QueryNextCount
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_RegisterNodesCount
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_UnregisterNodesCount
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_SessionId
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_ClientUserIdOfSession
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_ClientUserIdHistory
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_AuthenticationMechanism
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_Encoding
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_TransportProtocol
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_SecurityMode
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_SecurityPolicyUri
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_ClientCertificate
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SubscriptionDiagnosticsArray
    \value ServerType_ServerCapabilities_OperationLimits_MaxNodesPerHistoryReadData
    \value ServerType_ServerCapabilities_OperationLimits_MaxNodesPerHistoryReadEvents
    \value ServerType_ServerCapabilities_OperationLimits_MaxNodesPerHistoryUpdateData
    \value ServerType_ServerCapabilities_OperationLimits_MaxNodesPerHistoryUpdateEvents
    \value ServerCapabilitiesType_OperationLimits_MaxNodesPerHistoryReadData
    \value ServerCapabilitiesType_OperationLimits_MaxNodesPerHistoryReadEvents
    \value ServerCapabilitiesType_OperationLimits_MaxNodesPerHistoryUpdateData
    \value ServerCapabilitiesType_OperationLimits_MaxNodesPerHistoryUpdateEvents
    \value OperationLimitsType_MaxNodesPerHistoryReadData
    \value OperationLimitsType_MaxNodesPerHistoryReadEvents
    \value OperationLimitsType_MaxNodesPerHistoryUpdateData
    \value OperationLimitsType_MaxNodesPerHistoryUpdateEvents
    \value Server_ServerCapabilities_OperationLimits_MaxNodesPerHistoryReadData
    \value Server_ServerCapabilities_OperationLimits_MaxNodesPerHistoryReadEvents
    \value Server_ServerCapabilities_OperationLimits_MaxNodesPerHistoryUpdateData
    \value Server_ServerCapabilities_OperationLimits_MaxNodesPerHistoryUpdateEvents
    \value NamingRuleType_EnumValues
    \value ViewVersion
    \value ComplexNumberType
    \value DoubleComplexNumberType
    \value ComplexNumberType_Encoding_DefaultXml
    \value DoubleComplexNumberType_Encoding_DefaultXml
    \value OpcUa_XmlSchema_ComplexNumberType
    \value OpcUa_XmlSchema_ComplexNumberType_DataTypeVersion
    \value OpcUa_XmlSchema_ComplexNumberType_DictionaryFragment
    \value OpcUa_XmlSchema_DoubleComplexNumberType
    \value OpcUa_XmlSchema_DoubleComplexNumberType_DataTypeVersion
    \value OpcUa_XmlSchema_DoubleComplexNumberType_DictionaryFragment
    \value ComplexNumberType_Encoding_DefaultBinary
    \value DoubleComplexNumberType_Encoding_DefaultBinary
    \value OpcUa_BinarySchema_ComplexNumberType
    \value OpcUa_BinarySchema_ComplexNumberType_DataTypeVersion
    \value OpcUa_BinarySchema_ComplexNumberType_DictionaryFragment
    \value OpcUa_BinarySchema_DoubleComplexNumberType
    \value OpcUa_BinarySchema_DoubleComplexNumberType_DataTypeVersion
    \value OpcUa_BinarySchema_DoubleComplexNumberType_DictionaryFragment
    \value ServerOnNetwork
    \value FindServersOnNetworkRequest
    \value FindServersOnNetworkResponse
    \value RegisterServer2Request
    \value RegisterServer2Response
    \value ServerOnNetwork_Encoding_DefaultXml
    \value FindServersOnNetworkRequest_Encoding_DefaultXml
    \value FindServersOnNetworkResponse_Encoding_DefaultXml
    \value RegisterServer2Request_Encoding_DefaultXml
    \value RegisterServer2Response_Encoding_DefaultXml
    \value OpcUa_XmlSchema_ServerOnNetwork
    \value OpcUa_XmlSchema_ServerOnNetwork_DataTypeVersion
    \value OpcUa_XmlSchema_ServerOnNetwork_DictionaryFragment
    \value ServerOnNetwork_Encoding_DefaultBinary
    \value FindServersOnNetworkRequest_Encoding_DefaultBinary
    \value FindServersOnNetworkResponse_Encoding_DefaultBinary
    \value RegisterServer2Request_Encoding_DefaultBinary
    \value RegisterServer2Response_Encoding_DefaultBinary
    \value OpcUa_BinarySchema_ServerOnNetwork
    \value OpcUa_BinarySchema_ServerOnNetwork_DataTypeVersion
    \value OpcUa_BinarySchema_ServerOnNetwork_DictionaryFragment
    \value ProgressEventType_Context
    \value ProgressEventType_Progress
    \value OpenWithMasksMethodType
    \value OpenWithMasksMethodType_InputArguments
    \value OpenWithMasksMethodType_OutputArguments
    \value CloseAndUpdateMethodType
    \value CloseAndUpdateMethodType_OutputArguments
    \value AddCertificateMethodType
    \value AddCertificateMethodType_InputArguments
    \value RemoveCertificateMethodType
    \value RemoveCertificateMethodType_InputArguments
    \value TrustListType
    \value TrustListType_Size
    \value TrustListType_OpenCount
    \value TrustListType_Open
    \value TrustListType_Open_InputArguments
    \value TrustListType_Open_OutputArguments
    \value TrustListType_Close
    \value TrustListType_Close_InputArguments
    \value TrustListType_Read
    \value TrustListType_Read_InputArguments
    \value TrustListType_Read_OutputArguments
    \value TrustListType_Write
    \value TrustListType_Write_InputArguments
    \value TrustListType_GetPosition
    \value TrustListType_GetPosition_InputArguments
    \value TrustListType_GetPosition_OutputArguments
    \value TrustListType_SetPosition
    \value TrustListType_SetPosition_InputArguments
    \value TrustListType_LastUpdateTime
    \value TrustListType_OpenWithMasks
    \value TrustListType_OpenWithMasks_InputArguments
    \value TrustListType_OpenWithMasks_OutputArguments
    \value TrustListType_CloseAndUpdate
    \value TrustListType_CloseAndUpdate_OutputArguments
    \value TrustListType_AddCertificate
    \value TrustListType_AddCertificate_InputArguments
    \value TrustListType_RemoveCertificate
    \value TrustListType_RemoveCertificate_InputArguments
    \value TrustListMasks
    \value TrustListMasks_EnumValues
    \value TrustListDataType
    \value CertificateGroupType
    \value CertificateType
    \value ApplicationCertificateType
    \value HttpsCertificateType
    \value RsaMinApplicationCertificateType
    \value RsaSha256ApplicationCertificateType
    \value TrustListUpdatedAuditEventType
    \value TrustListUpdatedAuditEventType_EventId
    \value TrustListUpdatedAuditEventType_EventType
    \value TrustListUpdatedAuditEventType_SourceNode
    \value TrustListUpdatedAuditEventType_SourceName
    \value TrustListUpdatedAuditEventType_Time
    \value TrustListUpdatedAuditEventType_ReceiveTime
    \value TrustListUpdatedAuditEventType_LocalTime
    \value TrustListUpdatedAuditEventType_Message
    \value TrustListUpdatedAuditEventType_Severity
    \value TrustListUpdatedAuditEventType_ActionTimeStamp
    \value TrustListUpdatedAuditEventType_Status
    \value TrustListUpdatedAuditEventType_ServerId
    \value TrustListUpdatedAuditEventType_ClientAuditEntryId
    \value TrustListUpdatedAuditEventType_ClientUserId
    \value TrustListUpdatedAuditEventType_MethodId
    \value TrustListUpdatedAuditEventType_InputArguments
    \value UpdateCertificateMethodType
    \value UpdateCertificateMethodType_InputArguments
    \value UpdateCertificateMethodType_OutputArguments
    \value ServerConfigurationType
    \value ServerConfigurationType_SupportedPrivateKeyFormats
    \value ServerConfigurationType_MaxTrustListSize
    \value ServerConfigurationType_MulticastDnsEnabled
    \value ServerConfigurationType_UpdateCertificate
    \value ServerConfigurationType_UpdateCertificate_InputArguments
    \value ServerConfigurationType_UpdateCertificate_OutputArguments
    \value CertificateUpdatedAuditEventType
    \value CertificateUpdatedAuditEventType_EventId
    \value CertificateUpdatedAuditEventType_EventType
    \value CertificateUpdatedAuditEventType_SourceNode
    \value CertificateUpdatedAuditEventType_SourceName
    \value CertificateUpdatedAuditEventType_Time
    \value CertificateUpdatedAuditEventType_ReceiveTime
    \value CertificateUpdatedAuditEventType_LocalTime
    \value CertificateUpdatedAuditEventType_Message
    \value CertificateUpdatedAuditEventType_Severity
    \value CertificateUpdatedAuditEventType_ActionTimeStamp
    \value CertificateUpdatedAuditEventType_Status
    \value CertificateUpdatedAuditEventType_ServerId
    \value CertificateUpdatedAuditEventType_ClientAuditEntryId
    \value CertificateUpdatedAuditEventType_ClientUserId
    \value CertificateUpdatedAuditEventType_MethodId
    \value CertificateUpdatedAuditEventType_InputArguments
    \value ServerConfiguration
    \value ServerConfiguration_SupportedPrivateKeyFormats
    \value ServerConfiguration_MaxTrustListSize
    \value ServerConfiguration_MulticastDnsEnabled
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Size
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_OpenCount
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Open
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Open_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Open_OutputArguments
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Close
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Close_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Read
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Read_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Read_OutputArguments
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Write
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Write_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition_OutputArguments
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_LastUpdateTime
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks_OutputArguments
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate_OutputArguments
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate_InputArguments
    \value TrustListDataType_Encoding_DefaultXml
    \value OpcUa_XmlSchema_TrustListDataType
    \value OpcUa_XmlSchema_TrustListDataType_DataTypeVersion
    \value OpcUa_XmlSchema_TrustListDataType_DictionaryFragment
    \value TrustListDataType_Encoding_DefaultBinary
    \value OpcUa_BinarySchema_TrustListDataType
    \value OpcUa_BinarySchema_TrustListDataType_DataTypeVersion
    \value OpcUa_BinarySchema_TrustListDataType_DictionaryFragment
    \value ServerType_Namespaces_AddressSpaceFile_Writable
    \value ServerType_Namespaces_AddressSpaceFile_UserWritable
    \value FileType_Writable
    \value FileType_UserWritable
    \value AddressSpaceFileType_Writable
    \value AddressSpaceFileType_UserWritable
    \value NamespaceMetadataType_NamespaceFile_Writable
    \value NamespaceMetadataType_NamespaceFile_UserWritable
    \value NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Writable
    \value NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_UserWritable
    \value NamespacesType_AddressSpaceFile_Writable
    \value NamespacesType_AddressSpaceFile_UserWritable
    \value Server_Namespaces_AddressSpaceFile_Writable
    \value Server_Namespaces_AddressSpaceFile_UserWritable
    \value TrustListType_Writable
    \value TrustListType_UserWritable
    \value CloseAndUpdateMethodType_InputArguments
    \value TrustListType_CloseAndUpdate_InputArguments
    \value ServerConfigurationType_ServerCapabilities
    \value ServerConfiguration_ServerCapabilities
    \value OpcUa_XmlSchema_RelativePathElement
    \value OpcUa_XmlSchema_RelativePathElement_DataTypeVersion
    \value OpcUa_XmlSchema_RelativePathElement_DictionaryFragment
    \value OpcUa_XmlSchema_RelativePath
    \value OpcUa_XmlSchema_RelativePath_DataTypeVersion
    \value OpcUa_XmlSchema_RelativePath_DictionaryFragment
    \value OpcUa_BinarySchema_RelativePathElement
    \value OpcUa_BinarySchema_RelativePathElement_DataTypeVersion
    \value OpcUa_BinarySchema_RelativePathElement_DictionaryFragment
    \value OpcUa_BinarySchema_RelativePath
    \value OpcUa_BinarySchema_RelativePath_DataTypeVersion
    \value OpcUa_BinarySchema_RelativePath_DictionaryFragment
    \value ServerConfigurationType_CreateSigningRequest
    \value ServerConfigurationType_CreateSigningRequest_InputArguments
    \value ServerConfigurationType_CreateSigningRequest_OutputArguments
    \value ServerConfigurationType_ApplyChanges
    \value ServerConfiguration_CreateSigningRequest
    \value ServerConfiguration_CreateSigningRequest_InputArguments
    \value ServerConfiguration_CreateSigningRequest_OutputArguments
    \value ServerConfiguration_ApplyChanges
    \value CreateSigningRequestMethodType
    \value CreateSigningRequestMethodType_InputArguments
    \value CreateSigningRequestMethodType_OutputArguments
    \value OptionSetValues
    \value ServerType_SetSubscriptionDurable
    \value ServerType_SetSubscriptionDurable_InputArguments
    \value ServerType_SetSubscriptionDurable_OutputArguments
    \value Server_SetSubscriptionDurable
    \value Server_SetSubscriptionDurable_InputArguments
    \value Server_SetSubscriptionDurable_OutputArguments
    \value SetSubscriptionDurableMethodType
    \value SetSubscriptionDurableMethodType_InputArguments
    \value SetSubscriptionDurableMethodType_OutputArguments
    \value OptionSet
    \value Union
    \value OptionSet_Encoding_DefaultXml
    \value Union_Encoding_DefaultXml
    \value OpcUa_XmlSchema_OptionSet
    \value OpcUa_XmlSchema_OptionSet_DataTypeVersion
    \value OpcUa_XmlSchema_OptionSet_DictionaryFragment
    \value OpcUa_XmlSchema_Union
    \value OpcUa_XmlSchema_Union_DataTypeVersion
    \value OpcUa_XmlSchema_Union_DictionaryFragment
    \value OptionSet_Encoding_DefaultBinary
    \value Union_Encoding_DefaultBinary
    \value OpcUa_BinarySchema_OptionSet
    \value OpcUa_BinarySchema_OptionSet_DataTypeVersion
    \value OpcUa_BinarySchema_OptionSet_DictionaryFragment
    \value OpcUa_BinarySchema_Union
    \value OpcUa_BinarySchema_Union_DataTypeVersion
    \value OpcUa_BinarySchema_Union_DictionaryFragment
    \value GetRejectedListMethodType
    \value GetRejectedListMethodType_OutputArguments
    \value ServerConfigurationType_GetRejectedList
    \value ServerConfigurationType_GetRejectedList_OutputArguments
    \value ServerConfiguration_GetRejectedList
    \value ServerConfiguration_GetRejectedList_OutputArguments
    \value SamplingIntervalDiagnosticsArrayType_SamplingIntervalDiagnostics
    \value SamplingIntervalDiagnosticsArrayType_SamplingIntervalDiagnostics_SamplingInterval
    \value SamplingIntervalDiagnosticsArrayType_SamplingIntervalDiagnostics_SampledMonitoredItemsCount
    \value SamplingIntervalDiagnosticsArrayType_SamplingIntervalDiagnostics_MaxSampledMonitoredItemsCount
    \value SamplingIntervalDiagnosticsArrayType_SamplingIntervalDiagnostics_DisabledMonitoredItemsSamplingCount
    \value SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics
    \value SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_SessionId
    \value SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_SubscriptionId
    \value SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_Priority
    \value SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_PublishingInterval
    \value SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_MaxKeepAliveCount
    \value SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_MaxLifetimeCount
    \value SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_MaxNotificationsPerPublish
    \value SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_PublishingEnabled
    \value SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_ModifyCount
    \value SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_EnableCount
    \value SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_DisableCount
    \value SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_RepublishRequestCount
    \value SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_RepublishMessageRequestCount
    \value SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_RepublishMessageCount
    \value SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_TransferRequestCount
    \value SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_TransferredToAltClientCount
    \value SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_TransferredToSameClientCount
    \value SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_PublishRequestCount
    \value SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_DataChangeNotificationsCount
    \value SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_EventNotificationsCount
    \value SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_NotificationsCount
    \value SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_LatePublishRequestCount
    \value SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_CurrentKeepAliveCount
    \value SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_CurrentLifetimeCount
    \value SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_UnacknowledgedMessageCount
    \value SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_DiscardedMessageCount
    \value SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_MonitoredItemCount
    \value SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_DisabledMonitoredItemCount
    \value SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_MonitoringQueueOverflowCount
    \value SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_NextSequenceNumber
    \value SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_EventQueueOverFlowCount
    \value SessionDiagnosticsArrayType_SessionDiagnostics
    \value SessionDiagnosticsArrayType_SessionDiagnostics_SessionId
    \value SessionDiagnosticsArrayType_SessionDiagnostics_SessionName
    \value SessionDiagnosticsArrayType_SessionDiagnostics_ClientDescription
    \value SessionDiagnosticsArrayType_SessionDiagnostics_ServerUri
    \value SessionDiagnosticsArrayType_SessionDiagnostics_EndpointUrl
    \value SessionDiagnosticsArrayType_SessionDiagnostics_LocaleIds
    \value SessionDiagnosticsArrayType_SessionDiagnostics_ActualSessionTimeout
    \value SessionDiagnosticsArrayType_SessionDiagnostics_MaxResponseMessageSize
    \value SessionDiagnosticsArrayType_SessionDiagnostics_ClientConnectionTime
    \value SessionDiagnosticsArrayType_SessionDiagnostics_ClientLastContactTime
    \value SessionDiagnosticsArrayType_SessionDiagnostics_CurrentSubscriptionsCount
    \value SessionDiagnosticsArrayType_SessionDiagnostics_CurrentMonitoredItemsCount
    \value SessionDiagnosticsArrayType_SessionDiagnostics_CurrentPublishRequestsInQueue
    \value SessionDiagnosticsArrayType_SessionDiagnostics_TotalRequestCount
    \value SessionDiagnosticsArrayType_SessionDiagnostics_UnauthorizedRequestCount
    \value SessionDiagnosticsArrayType_SessionDiagnostics_ReadCount
    \value SessionDiagnosticsArrayType_SessionDiagnostics_HistoryReadCount
    \value SessionDiagnosticsArrayType_SessionDiagnostics_WriteCount
    \value SessionDiagnosticsArrayType_SessionDiagnostics_HistoryUpdateCount
    \value SessionDiagnosticsArrayType_SessionDiagnostics_CallCount
    \value SessionDiagnosticsArrayType_SessionDiagnostics_CreateMonitoredItemsCount
    \value SessionDiagnosticsArrayType_SessionDiagnostics_ModifyMonitoredItemsCount
    \value SessionDiagnosticsArrayType_SessionDiagnostics_SetMonitoringModeCount
    \value SessionDiagnosticsArrayType_SessionDiagnostics_SetTriggeringCount
    \value SessionDiagnosticsArrayType_SessionDiagnostics_DeleteMonitoredItemsCount
    \value SessionDiagnosticsArrayType_SessionDiagnostics_CreateSubscriptionCount
    \value SessionDiagnosticsArrayType_SessionDiagnostics_ModifySubscriptionCount
    \value SessionDiagnosticsArrayType_SessionDiagnostics_SetPublishingModeCount
    \value SessionDiagnosticsArrayType_SessionDiagnostics_PublishCount
    \value SessionDiagnosticsArrayType_SessionDiagnostics_RepublishCount
    \value SessionDiagnosticsArrayType_SessionDiagnostics_TransferSubscriptionsCount
    \value SessionDiagnosticsArrayType_SessionDiagnostics_DeleteSubscriptionsCount
    \value SessionDiagnosticsArrayType_SessionDiagnostics_AddNodesCount
    \value SessionDiagnosticsArrayType_SessionDiagnostics_AddReferencesCount
    \value SessionDiagnosticsArrayType_SessionDiagnostics_DeleteNodesCount
    \value SessionDiagnosticsArrayType_SessionDiagnostics_DeleteReferencesCount
    \value SessionDiagnosticsArrayType_SessionDiagnostics_BrowseCount
    \value SessionDiagnosticsArrayType_SessionDiagnostics_BrowseNextCount
    \value SessionDiagnosticsArrayType_SessionDiagnostics_TranslateBrowsePathsToNodeIdsCount
    \value SessionDiagnosticsArrayType_SessionDiagnostics_QueryFirstCount
    \value SessionDiagnosticsArrayType_SessionDiagnostics_QueryNextCount
    \value SessionDiagnosticsArrayType_SessionDiagnostics_RegisterNodesCount
    \value SessionDiagnosticsArrayType_SessionDiagnostics_UnregisterNodesCount
    \value SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics
    \value SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_SessionId
    \value SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_ClientUserIdOfSession
    \value SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_ClientUserIdHistory
    \value SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_AuthenticationMechanism
    \value SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_Encoding
    \value SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_TransportProtocol
    \value SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_SecurityMode
    \value SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_SecurityPolicyUri
    \value SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_ClientCertificate
    \value ServerType_ResendData
    \value ServerType_ResendData_InputArguments
    \value Server_ResendData
    \value Server_ResendData_InputArguments
    \value ResendDataMethodType
    \value ResendDataMethodType_InputArguments
    \value NormalizedString
    \value DecimalString
    \value DurationString
    \value TimeString
    \value DateString
    \value ServerType_EstimatedReturnTime
    \value ServerType_RequestServerStateChange
    \value ServerType_RequestServerStateChange_InputArguments
    \value Server_EstimatedReturnTime
    \value Server_RequestServerStateChange
    \value Server_RequestServerStateChange_InputArguments
    \value RequestServerStateChangeMethodType
    \value RequestServerStateChangeMethodType_InputArguments
    \value DiscoveryConfiguration
    \value MdnsDiscoveryConfiguration
    \value DiscoveryConfiguration_Encoding_DefaultXml
    \value MdnsDiscoveryConfiguration_Encoding_DefaultXml
    \value OpcUa_XmlSchema_DiscoveryConfiguration
    \value OpcUa_XmlSchema_DiscoveryConfiguration_DataTypeVersion
    \value OpcUa_XmlSchema_DiscoveryConfiguration_DictionaryFragment
    \value OpcUa_XmlSchema_MdnsDiscoveryConfiguration
    \value OpcUa_XmlSchema_MdnsDiscoveryConfiguration_DataTypeVersion
    \value OpcUa_XmlSchema_MdnsDiscoveryConfiguration_DictionaryFragment
    \value DiscoveryConfiguration_Encoding_DefaultBinary
    \value MdnsDiscoveryConfiguration_Encoding_DefaultBinary
    \value OpcUa_BinarySchema_DiscoveryConfiguration
    \value OpcUa_BinarySchema_DiscoveryConfiguration_DataTypeVersion
    \value OpcUa_BinarySchema_DiscoveryConfiguration_DictionaryFragment
    \value OpcUa_BinarySchema_MdnsDiscoveryConfiguration
    \value OpcUa_BinarySchema_MdnsDiscoveryConfiguration_DataTypeVersion
    \value OpcUa_BinarySchema_MdnsDiscoveryConfiguration_DictionaryFragment
    \value MaxByteStringLength
    \value ServerType_ServerCapabilities_MaxByteStringLength
    \value ServerCapabilitiesType_MaxByteStringLength
    \value Server_ServerCapabilities_MaxByteStringLength
    \value ConditionType_ConditionRefresh2
    \value ConditionType_ConditionRefresh2_InputArguments
    \value ConditionRefresh2MethodType
    \value ConditionRefresh2MethodType_InputArguments
    \value DialogConditionType_ConditionRefresh2
    \value DialogConditionType_ConditionRefresh2_InputArguments
    \value AcknowledgeableConditionType_ConditionRefresh2
    \value AcknowledgeableConditionType_ConditionRefresh2_InputArguments
    \value AlarmConditionType_ConditionRefresh2
    \value AlarmConditionType_ConditionRefresh2_InputArguments
    \value LimitAlarmType_ConditionRefresh2
    \value LimitAlarmType_ConditionRefresh2_InputArguments
    \value ExclusiveLimitAlarmType_ConditionRefresh2
    \value ExclusiveLimitAlarmType_ConditionRefresh2_InputArguments
    \value NonExclusiveLimitAlarmType_ConditionRefresh2
    \value NonExclusiveLimitAlarmType_ConditionRefresh2_InputArguments
    \value NonExclusiveLevelAlarmType_ConditionRefresh2
    \value NonExclusiveLevelAlarmType_ConditionRefresh2_InputArguments
    \value ExclusiveLevelAlarmType_ConditionRefresh2
    \value ExclusiveLevelAlarmType_ConditionRefresh2_InputArguments
    \value NonExclusiveDeviationAlarmType_ConditionRefresh2
    \value NonExclusiveDeviationAlarmType_ConditionRefresh2_InputArguments
    \value ExclusiveDeviationAlarmType_ConditionRefresh2
    \value ExclusiveDeviationAlarmType_ConditionRefresh2_InputArguments
    \value NonExclusiveRateOfChangeAlarmType_ConditionRefresh2
    \value NonExclusiveRateOfChangeAlarmType_ConditionRefresh2_InputArguments
    \value ExclusiveRateOfChangeAlarmType_ConditionRefresh2
    \value ExclusiveRateOfChangeAlarmType_ConditionRefresh2_InputArguments
    \value DiscreteAlarmType_ConditionRefresh2
    \value DiscreteAlarmType_ConditionRefresh2_InputArguments
    \value OffNormalAlarmType_ConditionRefresh2
    \value OffNormalAlarmType_ConditionRefresh2_InputArguments
    \value SystemOffNormalAlarmType_ConditionRefresh2
    \value SystemOffNormalAlarmType_ConditionRefresh2_InputArguments
    \value TripAlarmType_ConditionRefresh2
    \value TripAlarmType_ConditionRefresh2_InputArguments
    \value CertificateExpirationAlarmType
    \value CertificateExpirationAlarmType_EventId
    \value CertificateExpirationAlarmType_EventType
    \value CertificateExpirationAlarmType_SourceNode
    \value CertificateExpirationAlarmType_SourceName
    \value CertificateExpirationAlarmType_Time
    \value CertificateExpirationAlarmType_ReceiveTime
    \value CertificateExpirationAlarmType_LocalTime
    \value CertificateExpirationAlarmType_Message
    \value CertificateExpirationAlarmType_Severity
    \value CertificateExpirationAlarmType_ConditionClassId
    \value CertificateExpirationAlarmType_ConditionClassName
    \value CertificateExpirationAlarmType_ConditionName
    \value CertificateExpirationAlarmType_BranchId
    \value CertificateExpirationAlarmType_Retain
    \value CertificateExpirationAlarmType_EnabledState
    \value CertificateExpirationAlarmType_EnabledState_Id
    \value CertificateExpirationAlarmType_EnabledState_Name
    \value CertificateExpirationAlarmType_EnabledState_Number
    \value CertificateExpirationAlarmType_EnabledState_EffectiveDisplayName
    \value CertificateExpirationAlarmType_EnabledState_TransitionTime
    \value CertificateExpirationAlarmType_EnabledState_EffectiveTransitionTime
    \value CertificateExpirationAlarmType_EnabledState_TrueState
    \value CertificateExpirationAlarmType_EnabledState_FalseState
    \value CertificateExpirationAlarmType_Quality
    \value CertificateExpirationAlarmType_Quality_SourceTimestamp
    \value CertificateExpirationAlarmType_LastSeverity
    \value CertificateExpirationAlarmType_LastSeverity_SourceTimestamp
    \value CertificateExpirationAlarmType_Comment
    \value CertificateExpirationAlarmType_Comment_SourceTimestamp
    \value CertificateExpirationAlarmType_ClientUserId
    \value CertificateExpirationAlarmType_Disable
    \value CertificateExpirationAlarmType_Enable
    \value CertificateExpirationAlarmType_AddComment
    \value CertificateExpirationAlarmType_AddComment_InputArguments
    \value CertificateExpirationAlarmType_ConditionRefresh
    \value CertificateExpirationAlarmType_ConditionRefresh_InputArguments
    \value CertificateExpirationAlarmType_ConditionRefresh2
    \value CertificateExpirationAlarmType_ConditionRefresh2_InputArguments
    \value CertificateExpirationAlarmType_AckedState
    \value CertificateExpirationAlarmType_AckedState_Id
    \value CertificateExpirationAlarmType_AckedState_Name
    \value CertificateExpirationAlarmType_AckedState_Number
    \value CertificateExpirationAlarmType_AckedState_EffectiveDisplayName
    \value CertificateExpirationAlarmType_AckedState_TransitionTime
    \value CertificateExpirationAlarmType_AckedState_EffectiveTransitionTime
    \value CertificateExpirationAlarmType_AckedState_TrueState
    \value CertificateExpirationAlarmType_AckedState_FalseState
    \value CertificateExpirationAlarmType_ConfirmedState
    \value CertificateExpirationAlarmType_ConfirmedState_Id
    \value CertificateExpirationAlarmType_ConfirmedState_Name
    \value CertificateExpirationAlarmType_ConfirmedState_Number
    \value CertificateExpirationAlarmType_ConfirmedState_EffectiveDisplayName
    \value CertificateExpirationAlarmType_ConfirmedState_TransitionTime
    \value CertificateExpirationAlarmType_ConfirmedState_EffectiveTransitionTime
    \value CertificateExpirationAlarmType_ConfirmedState_TrueState
    \value CertificateExpirationAlarmType_ConfirmedState_FalseState
    \value CertificateExpirationAlarmType_Acknowledge
    \value CertificateExpirationAlarmType_Acknowledge_InputArguments
    \value CertificateExpirationAlarmType_Confirm
    \value CertificateExpirationAlarmType_Confirm_InputArguments
    \value CertificateExpirationAlarmType_ActiveState
    \value CertificateExpirationAlarmType_ActiveState_Id
    \value CertificateExpirationAlarmType_ActiveState_Name
    \value CertificateExpirationAlarmType_ActiveState_Number
    \value CertificateExpirationAlarmType_ActiveState_EffectiveDisplayName
    \value CertificateExpirationAlarmType_ActiveState_TransitionTime
    \value CertificateExpirationAlarmType_ActiveState_EffectiveTransitionTime
    \value CertificateExpirationAlarmType_ActiveState_TrueState
    \value CertificateExpirationAlarmType_ActiveState_FalseState
    \value CertificateExpirationAlarmType_InputNode
    \value CertificateExpirationAlarmType_SuppressedState
    \value CertificateExpirationAlarmType_SuppressedState_Id
    \value CertificateExpirationAlarmType_SuppressedState_Name
    \value CertificateExpirationAlarmType_SuppressedState_Number
    \value CertificateExpirationAlarmType_SuppressedState_EffectiveDisplayName
    \value CertificateExpirationAlarmType_SuppressedState_TransitionTime
    \value CertificateExpirationAlarmType_SuppressedState_EffectiveTransitionTime
    \value CertificateExpirationAlarmType_SuppressedState_TrueState
    \value CertificateExpirationAlarmType_SuppressedState_FalseState
    \value CertificateExpirationAlarmType_ShelvingState
    \value CertificateExpirationAlarmType_ShelvingState_CurrentState
    \value CertificateExpirationAlarmType_ShelvingState_CurrentState_Id
    \value CertificateExpirationAlarmType_ShelvingState_CurrentState_Name
    \value CertificateExpirationAlarmType_ShelvingState_CurrentState_Number
    \value CertificateExpirationAlarmType_ShelvingState_CurrentState_EffectiveDisplayName
    \value CertificateExpirationAlarmType_ShelvingState_LastTransition
    \value CertificateExpirationAlarmType_ShelvingState_LastTransition_Id
    \value CertificateExpirationAlarmType_ShelvingState_LastTransition_Name
    \value CertificateExpirationAlarmType_ShelvingState_LastTransition_Number
    \value CertificateExpirationAlarmType_ShelvingState_LastTransition_TransitionTime
    \value CertificateExpirationAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime
    \value CertificateExpirationAlarmType_ShelvingState_UnshelveTime
    \value CertificateExpirationAlarmType_ShelvingState_Unshelve
    \value CertificateExpirationAlarmType_ShelvingState_OneShotShelve
    \value CertificateExpirationAlarmType_ShelvingState_TimedShelve
    \value CertificateExpirationAlarmType_ShelvingState_TimedShelve_InputArguments
    \value CertificateExpirationAlarmType_SuppressedOrShelved
    \value CertificateExpirationAlarmType_MaxTimeShelved
    \value CertificateExpirationAlarmType_NormalState
    \value CertificateExpirationAlarmType_ExpirationDate
    \value CertificateExpirationAlarmType_CertificateType
    \value CertificateExpirationAlarmType_Certificate
    \value ServerType_Namespaces_AddressSpaceFile_MimeType
    \value FileType_MimeType
    \value CreateDirectoryMethodType
    \value CreateDirectoryMethodType_InputArguments
    \value CreateDirectoryMethodType_OutputArguments
    \value CreateFileMethodType
    \value CreateFileMethodType_InputArguments
    \value CreateFileMethodType_OutputArguments
    \value DeleteFileMethodType
    \value DeleteFileMethodType_InputArguments
    \value MoveOrCopyMethodType
    \value MoveOrCopyMethodType_InputArguments
    \value MoveOrCopyMethodType_OutputArguments
    \value FileDirectoryType
    \value FileDirectoryType_FileDirectoryName_Placeholder
    \value FileDirectoryType_FileDirectoryName_Placeholder_CreateDirectory
    \value FileDirectoryType_FileDirectoryName_Placeholder_CreateDirectory_InputArguments
    \value FileDirectoryType_FileDirectoryName_Placeholder_CreateDirectory_OutputArguments
    \value FileDirectoryType_FileDirectoryName_Placeholder_CreateFile
    \value FileDirectoryType_FileDirectoryName_Placeholder_CreateFile_InputArguments
    \value FileDirectoryType_FileDirectoryName_Placeholder_CreateFile_OutputArguments
    \value FileDirectoryType_FileDirectoryName_Placeholder_Delete
    \value FileDirectoryType_FileDirectoryName_Placeholder_Delete_InputArguments
    \value FileDirectoryType_FileDirectoryName_Placeholder_MoveOrCopy
    \value FileDirectoryType_FileDirectoryName_Placeholder_MoveOrCopy_InputArguments
    \value FileDirectoryType_FileDirectoryName_Placeholder_MoveOrCopy_OutputArguments
    \value FileDirectoryType_FileName_Placeholder
    \value FileDirectoryType_FileName_Placeholder_Size
    \value FileDirectoryType_FileName_Placeholder_Writable
    \value FileDirectoryType_FileName_Placeholder_UserWritable
    \value FileDirectoryType_FileName_Placeholder_OpenCount
    \value FileDirectoryType_FileName_Placeholder_MimeType
    \value FileDirectoryType_FileName_Placeholder_Open
    \value FileDirectoryType_FileName_Placeholder_Open_InputArguments
    \value FileDirectoryType_FileName_Placeholder_Open_OutputArguments
    \value FileDirectoryType_FileName_Placeholder_Close
    \value FileDirectoryType_FileName_Placeholder_Close_InputArguments
    \value FileDirectoryType_FileName_Placeholder_Read
    \value FileDirectoryType_FileName_Placeholder_Read_InputArguments
    \value FileDirectoryType_FileName_Placeholder_Read_OutputArguments
    \value FileDirectoryType_FileName_Placeholder_Write
    \value FileDirectoryType_FileName_Placeholder_Write_InputArguments
    \value FileDirectoryType_FileName_Placeholder_GetPosition
    \value FileDirectoryType_FileName_Placeholder_GetPosition_InputArguments
    \value FileDirectoryType_FileName_Placeholder_GetPosition_OutputArguments
    \value FileDirectoryType_FileName_Placeholder_SetPosition
    \value FileDirectoryType_FileName_Placeholder_SetPosition_InputArguments
    \value FileDirectoryType_CreateDirectory
    \value FileDirectoryType_CreateDirectory_InputArguments
    \value FileDirectoryType_CreateDirectory_OutputArguments
    \value FileDirectoryType_CreateFile
    \value FileDirectoryType_CreateFile_InputArguments
    \value FileDirectoryType_CreateFile_OutputArguments
    \value FileDirectoryType_Delete
    \value FileDirectoryType_Delete_InputArguments
    \value FileDirectoryType_MoveOrCopy
    \value FileDirectoryType_MoveOrCopy_InputArguments
    \value FileDirectoryType_MoveOrCopy_OutputArguments
    \value AddressSpaceFileType_MimeType
    \value NamespaceMetadataType_NamespaceFile_MimeType
    \value NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_MimeType
    \value NamespacesType_AddressSpaceFile_MimeType
    \value Server_Namespaces_AddressSpaceFile_MimeType
    \value TrustListType_MimeType
    \value CertificateGroupType_TrustList
    \value CertificateGroupType_TrustList_Size
    \value CertificateGroupType_TrustList_Writable
    \value CertificateGroupType_TrustList_UserWritable
    \value CertificateGroupType_TrustList_OpenCount
    \value CertificateGroupType_TrustList_MimeType
    \value CertificateGroupType_TrustList_Open
    \value CertificateGroupType_TrustList_Open_InputArguments
    \value CertificateGroupType_TrustList_Open_OutputArguments
    \value CertificateGroupType_TrustList_Close
    \value CertificateGroupType_TrustList_Close_InputArguments
    \value CertificateGroupType_TrustList_Read
    \value CertificateGroupType_TrustList_Read_InputArguments
    \value CertificateGroupType_TrustList_Read_OutputArguments
    \value CertificateGroupType_TrustList_Write
    \value CertificateGroupType_TrustList_Write_InputArguments
    \value CertificateGroupType_TrustList_GetPosition
    \value CertificateGroupType_TrustList_GetPosition_InputArguments
    \value CertificateGroupType_TrustList_GetPosition_OutputArguments
    \value CertificateGroupType_TrustList_SetPosition
    \value CertificateGroupType_TrustList_SetPosition_InputArguments
    \value CertificateGroupType_TrustList_LastUpdateTime
    \value CertificateGroupType_TrustList_OpenWithMasks
    \value CertificateGroupType_TrustList_OpenWithMasks_InputArguments
    \value CertificateGroupType_TrustList_OpenWithMasks_OutputArguments
    \value CertificateGroupType_TrustList_CloseAndUpdate
    \value CertificateGroupType_TrustList_CloseAndUpdate_InputArguments
    \value CertificateGroupType_TrustList_CloseAndUpdate_OutputArguments
    \value CertificateGroupType_TrustList_AddCertificate
    \value CertificateGroupType_TrustList_AddCertificate_InputArguments
    \value CertificateGroupType_TrustList_RemoveCertificate
    \value CertificateGroupType_TrustList_RemoveCertificate_InputArguments
    \value CertificateGroupType_CertificateTypes
    \value CertificateUpdatedAuditEventType_CertificateGroup
    \value CertificateUpdatedAuditEventType_CertificateType
    \value ServerConfiguration_UpdateCertificate
    \value ServerConfiguration_UpdateCertificate_InputArguments
    \value ServerConfiguration_UpdateCertificate_OutputArguments
    \value CertificateGroupFolderType
    \value CertificateGroupFolderType_DefaultApplicationGroup
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustList
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Size
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Writable
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustList_UserWritable
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustList_OpenCount
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustList_MimeType
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Open
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Open_InputArguments
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Open_OutputArguments
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Close
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Close_InputArguments
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Read
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Read_InputArguments
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Read_OutputArguments
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Write
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Write_InputArguments
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustList_GetPosition
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustList_GetPosition_InputArguments
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustList_GetPosition_OutputArguments
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustList_SetPosition
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustList_SetPosition_InputArguments
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustList_LastUpdateTime
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustList_OpenWithMasks
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustList_OpenWithMasks_InputArguments
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustList_OpenWithMasks_OutputArguments
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustList_CloseAndUpdate
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustList_CloseAndUpdate_InputArguments
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustList_CloseAndUpdate_OutputArguments
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustList_AddCertificate
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustList_AddCertificate_InputArguments
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustList_RemoveCertificate
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustList_RemoveCertificate_InputArguments
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateTypes
    \value CertificateGroupFolderType_DefaultHttpsGroup
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustList
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Size
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Writable
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustList_UserWritable
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustList_OpenCount
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustList_MimeType
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Open
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Open_InputArguments
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Open_OutputArguments
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Close
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Close_InputArguments
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Read
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Read_InputArguments
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Read_OutputArguments
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Write
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Write_InputArguments
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustList_GetPosition
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustList_GetPosition_InputArguments
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustList_GetPosition_OutputArguments
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustList_SetPosition
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustList_SetPosition_InputArguments
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustList_LastUpdateTime
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustList_OpenWithMasks
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustList_OpenWithMasks_InputArguments
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustList_OpenWithMasks_OutputArguments
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustList_CloseAndUpdate
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustList_CloseAndUpdate_InputArguments
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustList_CloseAndUpdate_OutputArguments
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustList_AddCertificate
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustList_AddCertificate_InputArguments
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustList_RemoveCertificate
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustList_RemoveCertificate_InputArguments
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateTypes
    \value CertificateGroupFolderType_DefaultUserTokenGroup
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustList
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Size
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Writable
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_UserWritable
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_OpenCount
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_MimeType
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Open
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Open_InputArguments
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Open_OutputArguments
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Close
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Close_InputArguments
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Read
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Read_InputArguments
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Read_OutputArguments
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Write
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Write_InputArguments
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_GetPosition
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_GetPosition_InputArguments
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_GetPosition_OutputArguments
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_SetPosition
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_SetPosition_InputArguments
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_LastUpdateTime
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_OpenWithMasks
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_OpenWithMasks_InputArguments
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_OpenWithMasks_OutputArguments
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_CloseAndUpdate
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_CloseAndUpdate_InputArguments
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_CloseAndUpdate_OutputArguments
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_AddCertificate
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_AddCertificate_InputArguments
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_RemoveCertificate
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_RemoveCertificate_InputArguments
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateTypes
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Size
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Writable
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_UserWritable
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_OpenCount
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_MimeType
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Open
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Open_InputArguments
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Open_OutputArguments
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Close
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Close_InputArguments
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Read
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Read_InputArguments
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Read_OutputArguments
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Write
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Write_InputArguments
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_GetPosition
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_GetPosition_InputArguments
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_GetPosition_OutputArguments
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_SetPosition
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_SetPosition_InputArguments
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_LastUpdateTime
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_OpenWithMasks
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_OpenWithMasks_InputArguments
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_OpenWithMasks_OutputArguments
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_CloseAndUpdate
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_CloseAndUpdate_InputArguments
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_CloseAndUpdate_OutputArguments
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_AddCertificate
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_AddCertificate_InputArguments
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_RemoveCertificate
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_RemoveCertificate_InputArguments
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateTypes
    \value ServerConfigurationType_CertificateGroups
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Size
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Writable
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_UserWritable
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_OpenCount
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_MimeType
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Open
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Open_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Open_OutputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Close
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Close_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Read
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Read_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Read_OutputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Write
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Write_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition_OutputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_LastUpdateTime
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks_OutputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate_OutputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateTypes
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Size
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Writable
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_UserWritable
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_OpenCount
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_MimeType
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Open
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Open_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Open_OutputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Close
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Close_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Read
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Read_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Read_OutputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Write
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Write_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition_OutputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_LastUpdateTime
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks_OutputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate_OutputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateTypes
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Size
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Writable
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_UserWritable
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenCount
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_MimeType
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Open
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Open_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Open_OutputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Close
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Close_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Read
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Read_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Read_OutputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Write
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Write_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition_OutputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_LastUpdateTime
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks_OutputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate_OutputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateTypes
    \value ServerConfiguration_CertificateGroups
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Size
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Writable
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_UserWritable
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_OpenCount
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_MimeType
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Open
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Open_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Open_OutputArguments
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Close
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Close_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Read
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Read_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Read_OutputArguments
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Write
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Write_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition_OutputArguments
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_LastUpdateTime
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks_OutputArguments
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate_OutputArguments
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateTypes
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Size
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Writable
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_UserWritable
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenCount
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_MimeType
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Open
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Open_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Open_OutputArguments
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Close
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Close_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Read
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Read_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Read_OutputArguments
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Write
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Write_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition_OutputArguments
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_LastUpdateTime
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks_OutputArguments
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate_OutputArguments
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateTypes
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Writable
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_UserWritable
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_MimeType
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateTypes
    \value AuditCreateSessionEventType_SessionId
    \value AuditUrlMismatchEventType_SessionId
    \value Server_ServerRedundancy_ServerNetworkGroups
    \value CertificateExpirationAlarmType_ExpirationLimit
    \value Server_Namespaces_OPCUANamespaceUri
    \value Server_Namespaces_OPCUANamespaceUri_NamespaceUri
    \value Server_Namespaces_OPCUANamespaceUri_NamespaceVersion
    \value Server_Namespaces_OPCUANamespaceUri_NamespacePublicationDate
    \value Server_Namespaces_OPCUANamespaceUri_IsNamespaceSubset
    \value Server_Namespaces_OPCUANamespaceUri_StaticNodeIdTypes
    \value Server_Namespaces_OPCUANamespaceUri_StaticNumericNodeIdRange
    \value Server_Namespaces_OPCUANamespaceUri_StaticStringNodeIdPattern
    \value Server_Namespaces_OPCUANamespaceUri_NamespaceFile
    \value Server_Namespaces_OPCUANamespaceUri_NamespaceFile_Size
    \value Server_Namespaces_OPCUANamespaceUri_NamespaceFile_Writable
    \value Server_Namespaces_OPCUANamespaceUri_NamespaceFile_UserWritable
    \value Server_Namespaces_OPCUANamespaceUri_NamespaceFile_OpenCount
    \value Server_Namespaces_OPCUANamespaceUri_NamespaceFile_MimeType
    \value Server_Namespaces_OPCUANamespaceUri_NamespaceFile_Open
    \value Server_Namespaces_OPCUANamespaceUri_NamespaceFile_Open_InputArguments
    \value Server_Namespaces_OPCUANamespaceUri_NamespaceFile_Open_OutputArguments
    \value Server_Namespaces_OPCUANamespaceUri_NamespaceFile_Close
    \value Server_Namespaces_OPCUANamespaceUri_NamespaceFile_Close_InputArguments
    \value Server_Namespaces_OPCUANamespaceUri_NamespaceFile_Read
    \value Server_Namespaces_OPCUANamespaceUri_NamespaceFile_Read_InputArguments
    \value Server_Namespaces_OPCUANamespaceUri_NamespaceFile_Read_OutputArguments
    \value Server_Namespaces_OPCUANamespaceUri_NamespaceFile_Write
    \value Server_Namespaces_OPCUANamespaceUri_NamespaceFile_Write_InputArguments
    \value Server_Namespaces_OPCUANamespaceUri_NamespaceFile_GetPosition
    \value Server_Namespaces_OPCUANamespaceUri_NamespaceFile_GetPosition_InputArguments
    \value Server_Namespaces_OPCUANamespaceUri_NamespaceFile_GetPosition_OutputArguments
    \value Server_Namespaces_OPCUANamespaceUri_NamespaceFile_SetPosition
    \value Server_Namespaces_OPCUANamespaceUri_NamespaceFile_SetPosition_InputArguments
    \value Server_Namespaces_OPCUANamespaceUri_NamespaceFile_ExportNamespace
*/

QT_END_NAMESPACE
