// Copyright (C) 2021 The Qt Company Ltd.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR GPL-3.0-only

#include <QtWaylandCompositor/QWaylandShellSurface>

/*!
 * \class QWaylandShellSurfaceTemplate
 * \inmodule QtWaylandCompositor
 * \since 5.8
 * \brief QWaylandShellSurfaceTemplate is a convenience class for creating custom shell surface
 * classes.
 *
 * QWaylandShellSurfaceTemplate is a template class which inherits from QWaylandShellSurface and
 * is convenience for building custom shell extensions.
 *
 * It provides the connection between Qt Wayland Compositor and the class generated by
 * \c qtwaylandscanner, based on the XML description of the extension protocol.
 *
 * It provides two specific pieces of convenience:
 * \list
 *   \li A reimplementation of \l{QWaylandCompositorExtension::extensionInterface()} which returns
 *   the \c wl_interface pointer for the qtwaylandscanner-generated base class.
 *   \li A static \l{findIn()} function which searches for an instance of the extension in a
 *   provided container, and returns this if it is found.
 * \endlist
 *
 * The same usage pattern applies as for QWaylandCompositorExtensionTemplate.
 *
 * \sa { Custom Shell}
 */

/*!
 *  \fn template <typename T> T *QWaylandShellSurfaceTemplate<T>::findIn(QWaylandObject *container)
 *
 *  If any instance of the interface has been registered with \a container, this is returned.
 *  Otherwise null is returned. The look-up is based on the generated \c interfaceName() which
 *  matches the interface name in the protocol description.
 */


/*!
 * \qmltype ShellSurface
 * \instantiates QWaylandShellSurface
 * \inqmlmodule QtWayland.Compositor
 * \since 5.8
 * \brief Provides a common interface for surface roles specified by shell extensions.
 *
 * This interface represents a Wayland surface role given by a Wayland protocol extension that
 * defines how the WaylandSurface should map onto the screen.
 *
 * \note Even though this type contains a very limited API, the properties and signals of the
 * implementations are named consistently. For example, if you're only using desktop shell
 * extensions in your compositor, it's safe to access properties such as title, maximized, etc.
 * directly on the ShellSurface. See the various implementations for additional properties and
 * signals.
 *
 * \sa WaylandSurface, ShellSurfaceItem, WlShellSurface, IviSurface
 */

/*!
 * \class QWaylandShellSurface
 * \inmodule QtWaylandCompositor
 * \since 5.8
 * \brief The QWaylandShellSurface class is a common interface for surface roles specified by shell extensions.
 *
 * This interface represents a Wayland surface role given by a Wayland protocol extension that
 * defines how the QWaylandSurface should map onto the screen.
 *
 * \sa QWaylandSurface, QWaylandWlShellSurface, QWaylandIviSurface, QWaylandShellSurfaceTemplate
 */

#if QT_CONFIG(wayland_compositor_quick)
/*!
 * \fn QWaylandQuickShellIntegration *QWaylandShellSurface::createIntegration(QWaylandQuickShellSurfaceItem *item)
 *
 * Creates a QWaylandQuickShellIntegration for this QWaylandQuickShellSurface. It's called
 * automatically when \a {item}'s \l {QWaylandQuickShellSurfaceItem::}{shellSurface} is assigned.
 *
 * \sa QWaylandQuickShellSurfaceItem
 */
#endif

/*!
 * \qmlproperty enum QtWayland.Compositor::ShellSurface::windowType
 *
 * This property holds the window type of the ShellSurface.
 */

/*!
 * \property QWaylandShellSurface::windowType
 *
 * This property holds the window type of the QWaylandShellSurface.
 */

QT_BEGIN_NAMESPACE

QT_END_NAMESPACE

#include "moc_qwaylandshellsurface.cpp"
