// Copyright (C) 2022 The Qt Company Ltd.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR GPL-3.0-only WITH Qt-GPL-exception-1.0

// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT!

#include "clangformatchecks.h"

#include <utils/layoutbuilder.h>

#include <QCheckBox>
#include <QComboBox>
#include <QLabel>
#include <QLineEdit>
#include <QPlainTextEdit>
#include <QPushButton>
#include <QWidget>

using namespace Utils;

using namespace ClangFormat;

ClangFormatChecks::ClangFormatChecks(QWidget *parent)
    : QWidget(parent)
{
    m_BasedOnStyle = new QComboBox(this);
    m_BasedOnStyle->addItems({"LLVM","Google","Chromium","Mozilla","WebKit","Microsoft","GNU",});
    m_BasedOnStyle->setObjectName("BasedOnStyle");

    m_InheritsParentConfig = new QComboBox(this);
    m_InheritsParentConfig->addItems({"Default","true","false",});
    m_InheritsParentConfig->setObjectName("InheritsParentConfig");

    m_AccessModifierOffset = new QLineEdit(this);
    m_AccessModifierOffset->setObjectName("AccessModifierOffset");
    m_setAccessModifierOffset = new QPushButton("Set", this);

    m_setAccessModifierOffset->setObjectName("setAccessModifierOffset");
    m_AlignAfterOpenBracket = new QComboBox(this);
    m_AlignAfterOpenBracket->addItems({"Align","DontAlign","AlwaysBreak","BlockIndent",});
    m_AlignAfterOpenBracket->setObjectName("AlignAfterOpenBracket");

    m_AlignArrayOfStructures = new QComboBox(this);
    m_AlignArrayOfStructures->addItems({"Left","Right","None",});
    m_AlignArrayOfStructures->setObjectName("AlignArrayOfStructures");

    m_AlignConsecutiveMacros = new QComboBox(this);
    m_AlignConsecutiveMacros->addItems({"None","Consecutive","AcrossEmptyLines","AcrossComments","AcrossEmptyLinesAndComments",});
    m_AlignConsecutiveMacros->setObjectName("AlignConsecutiveMacros");

    m_AlignConsecutiveAssignments = new QComboBox(this);
    m_AlignConsecutiveAssignments->addItems({"None","Consecutive","AcrossEmptyLines","AcrossComments","AcrossEmptyLinesAndComments",});
    m_AlignConsecutiveAssignments->setObjectName("AlignConsecutiveAssignments");

    m_AlignConsecutiveBitFields = new QComboBox(this);
    m_AlignConsecutiveBitFields->addItems({"None","Consecutive","AcrossEmptyLines","AcrossComments","AcrossEmptyLinesAndComments",});
    m_AlignConsecutiveBitFields->setObjectName("AlignConsecutiveBitFields");

    m_AlignConsecutiveDeclarations = new QComboBox(this);
    m_AlignConsecutiveDeclarations->addItems({"None","Consecutive","AcrossEmptyLines","AcrossComments","AcrossEmptyLinesAndComments",});
    m_AlignConsecutiveDeclarations->setObjectName("AlignConsecutiveDeclarations");

    m_AlignEscapedNewlines = new QComboBox(this);
    m_AlignEscapedNewlines->addItems({"DontAlign","Left","Right",});
    m_AlignEscapedNewlines->setObjectName("AlignEscapedNewlines");

    m_AlignOperands = new QComboBox(this);
    m_AlignOperands->addItems({"DontAlign","Align","AlignAfterOperator",});
    m_AlignOperands->setObjectName("AlignOperands");

    m_AlignTrailingComments = new QComboBox(this);
    m_AlignTrailingComments->addItems({"Default","true","false",});
    m_AlignTrailingComments->setObjectName("AlignTrailingComments");

    m_AllowAllArgumentsOnNextLine = new QComboBox(this);
    m_AllowAllArgumentsOnNextLine->addItems({"Default","true","false",});
    m_AllowAllArgumentsOnNextLine->setObjectName("AllowAllArgumentsOnNextLine");

    m_AllowAllParametersOfDeclarationOnNextLine = new QComboBox(this);
    m_AllowAllParametersOfDeclarationOnNextLine->addItems({"Default","true","false",});
    m_AllowAllParametersOfDeclarationOnNextLine->setObjectName("AllowAllParametersOfDeclarationOnNextLine");

    m_AllowShortEnumsOnASingleLine = new QComboBox(this);
    m_AllowShortEnumsOnASingleLine->addItems({"Default","true","false",});
    m_AllowShortEnumsOnASingleLine->setObjectName("AllowShortEnumsOnASingleLine");

    m_AllowShortBlocksOnASingleLine = new QComboBox(this);
    m_AllowShortBlocksOnASingleLine->addItems({"Never","Empty","Always",});
    m_AllowShortBlocksOnASingleLine->setObjectName("AllowShortBlocksOnASingleLine");

    m_AllowShortCaseLabelsOnASingleLine = new QComboBox(this);
    m_AllowShortCaseLabelsOnASingleLine->addItems({"Default","true","false",});
    m_AllowShortCaseLabelsOnASingleLine->setObjectName("AllowShortCaseLabelsOnASingleLine");

    m_AllowShortFunctionsOnASingleLine = new QComboBox(this);
    m_AllowShortFunctionsOnASingleLine->addItems({"None","InlineOnly","Empty","Inline","All",});
    m_AllowShortFunctionsOnASingleLine->setObjectName("AllowShortFunctionsOnASingleLine");

    m_AllowShortIfStatementsOnASingleLine = new QComboBox(this);
    m_AllowShortIfStatementsOnASingleLine->addItems({"Never","WithoutElse","OnlyFirstIf","AllIfsAndElse",});
    m_AllowShortIfStatementsOnASingleLine->setObjectName("AllowShortIfStatementsOnASingleLine");

    m_AllowShortLambdasOnASingleLine = new QComboBox(this);
    m_AllowShortLambdasOnASingleLine->addItems({"None","Empty","Inline","All",});
    m_AllowShortLambdasOnASingleLine->setObjectName("AllowShortLambdasOnASingleLine");

    m_AllowShortLoopsOnASingleLine = new QComboBox(this);
    m_AllowShortLoopsOnASingleLine->addItems({"Default","true","false",});
    m_AllowShortLoopsOnASingleLine->setObjectName("AllowShortLoopsOnASingleLine");

    m_AlwaysBreakAfterReturnType = new QComboBox(this);
    m_AlwaysBreakAfterReturnType->addItems({"None","All","TopLevel","AllDefinitions","TopLevelDefinitions",});
    m_AlwaysBreakAfterReturnType->setObjectName("AlwaysBreakAfterReturnType");

    m_AlwaysBreakBeforeMultilineStrings = new QComboBox(this);
    m_AlwaysBreakBeforeMultilineStrings->addItems({"Default","true","false",});
    m_AlwaysBreakBeforeMultilineStrings->setObjectName("AlwaysBreakBeforeMultilineStrings");

    m_AlwaysBreakTemplateDeclarations = new QComboBox(this);
    m_AlwaysBreakTemplateDeclarations->addItems({"No","MultiLine","Yes",});
    m_AlwaysBreakTemplateDeclarations->setObjectName("AlwaysBreakTemplateDeclarations");

    m_AttributeMacros = new QPlainTextEdit(this);
    m_AttributeMacros->setObjectName("AttributeMacros");
    m_AttributeMacros->setFixedHeight(100);
    m_setAttributeMacros = new QPushButton("Set", this);

    m_setAttributeMacros->setObjectName("setAttributeMacros");
    m_BinPackArguments = new QComboBox(this);
    m_BinPackArguments->addItems({"Default","true","false",});
    m_BinPackArguments->setObjectName("BinPackArguments");

    m_InsertTrailingCommas = new QComboBox(this);
    m_InsertTrailingCommas->addItems({"None","Wrapped",});
    m_InsertTrailingCommas->setObjectName("InsertTrailingCommas");

    m_BinPackParameters = new QComboBox(this);
    m_BinPackParameters->addItems({"Default","true","false",});
    m_BinPackParameters->setObjectName("BinPackParameters");

    m_BreakBeforeBinaryOperators = new QComboBox(this);
    m_BreakBeforeBinaryOperators->addItems({"None","NonAssignment","All",});
    m_BreakBeforeBinaryOperators->setObjectName("BreakBeforeBinaryOperators");

    m_BreakBeforeBraces = new QComboBox(this);
    m_BreakBeforeBraces->addItems({"Attach","Linux","Mozilla","Stroustrup","Allman","Whitesmiths","GNU","WebKit","Custom",});
    m_BreakBeforeBraces->setObjectName("BreakBeforeBraces");

    m_AfterCaseLabel = new QComboBox(this);
    m_AfterCaseLabel->addItems({"Default","true","false",});
    m_AfterCaseLabel->setObjectName("AfterCaseLabel");

    m_AfterClass = new QComboBox(this);
    m_AfterClass->addItems({"Default","true","false",});
    m_AfterClass->setObjectName("AfterClass");

    m_AfterControlStatement = new QComboBox(this);
    m_AfterControlStatement->addItems({"Never","MultiLine","Always",});
    m_AfterControlStatement->setObjectName("AfterControlStatement");

    m_AfterEnum = new QComboBox(this);
    m_AfterEnum->addItems({"Default","true","false",});
    m_AfterEnum->setObjectName("AfterEnum");

    m_AfterFunction = new QComboBox(this);
    m_AfterFunction->addItems({"Default","true","false",});
    m_AfterFunction->setObjectName("AfterFunction");

    m_AfterNamespace = new QComboBox(this);
    m_AfterNamespace->addItems({"Default","true","false",});
    m_AfterNamespace->setObjectName("AfterNamespace");

    m_AfterObjCDeclaration = new QComboBox(this);
    m_AfterObjCDeclaration->addItems({"Default","true","false",});
    m_AfterObjCDeclaration->setObjectName("AfterObjCDeclaration");

    m_AfterStruct = new QComboBox(this);
    m_AfterStruct->addItems({"Default","true","false",});
    m_AfterStruct->setObjectName("AfterStruct");

    m_AfterUnion = new QComboBox(this);
    m_AfterUnion->addItems({"Default","true","false",});
    m_AfterUnion->setObjectName("AfterUnion");

    m_AfterExternBlock = new QComboBox(this);
    m_AfterExternBlock->addItems({"Default","true","false",});
    m_AfterExternBlock->setObjectName("AfterExternBlock");

    m_BeforeCatch = new QComboBox(this);
    m_BeforeCatch->addItems({"Default","true","false",});
    m_BeforeCatch->setObjectName("BeforeCatch");

    m_BeforeElse = new QComboBox(this);
    m_BeforeElse->addItems({"Default","true","false",});
    m_BeforeElse->setObjectName("BeforeElse");

    m_BeforeLambdaBody = new QComboBox(this);
    m_BeforeLambdaBody->addItems({"Default","true","false",});
    m_BeforeLambdaBody->setObjectName("BeforeLambdaBody");

    m_BeforeWhile = new QComboBox(this);
    m_BeforeWhile->addItems({"Default","true","false",});
    m_BeforeWhile->setObjectName("BeforeWhile");

    m_IndentBraces = new QComboBox(this);
    m_IndentBraces->addItems({"Default","true","false",});
    m_IndentBraces->setObjectName("IndentBraces");

    m_SplitEmptyFunction = new QComboBox(this);
    m_SplitEmptyFunction->addItems({"Default","true","false",});
    m_SplitEmptyFunction->setObjectName("SplitEmptyFunction");

    m_SplitEmptyRecord = new QComboBox(this);
    m_SplitEmptyRecord->addItems({"Default","true","false",});
    m_SplitEmptyRecord->setObjectName("SplitEmptyRecord");

    m_SplitEmptyNamespace = new QComboBox(this);
    m_SplitEmptyNamespace->addItems({"Default","true","false",});
    m_SplitEmptyNamespace->setObjectName("SplitEmptyNamespace");

    m_BreakBeforeConceptDeclarations = new QComboBox(this);
    m_BreakBeforeConceptDeclarations->addItems({"Default","true","false",});
    m_BreakBeforeConceptDeclarations->setObjectName("BreakBeforeConceptDeclarations");

    m_BreakBeforeTernaryOperators = new QComboBox(this);
    m_BreakBeforeTernaryOperators->addItems({"Default","true","false",});
    m_BreakBeforeTernaryOperators->setObjectName("BreakBeforeTernaryOperators");

    m_BreakConstructorInitializers = new QComboBox(this);
    m_BreakConstructorInitializers->addItems({"BeforeColon","BeforeComma","AfterColon",});
    m_BreakConstructorInitializers->setObjectName("BreakConstructorInitializers");

    m_BreakAfterJavaFieldAnnotations = new QComboBox(this);
    m_BreakAfterJavaFieldAnnotations->addItems({"Default","true","false",});
    m_BreakAfterJavaFieldAnnotations->setObjectName("BreakAfterJavaFieldAnnotations");

    m_BreakStringLiterals = new QComboBox(this);
    m_BreakStringLiterals->addItems({"Default","true","false",});
    m_BreakStringLiterals->setObjectName("BreakStringLiterals");

    m_ColumnLimit = new QLineEdit(this);
    m_ColumnLimit->setObjectName("ColumnLimit");
    m_setColumnLimit = new QPushButton("Set", this);

    m_setColumnLimit->setObjectName("setColumnLimit");
    m_CommentPragmas = new QLineEdit(this);
    m_CommentPragmas->setObjectName("CommentPragmas");
    m_setCommentPragmas = new QPushButton("Set", this);

    m_setCommentPragmas->setObjectName("setCommentPragmas");
    m_QualifierAlignment = new QComboBox(this);
    m_QualifierAlignment->addItems({"Leave","Left","Right","Custom",});
    m_QualifierAlignment->setObjectName("QualifierAlignment");

    m_QualifierOrder = new QPlainTextEdit(this);
    m_QualifierOrder->setObjectName("QualifierOrder");
    m_QualifierOrder->setFixedHeight(100);
    m_setQualifierOrder = new QPushButton("Set", this);

    m_setQualifierOrder->setObjectName("setQualifierOrder");
    m_BreakInheritanceList = new QComboBox(this);
    m_BreakInheritanceList->addItems({"BeforeColon","BeforeComma","AfterColon","AfterComma",});
    m_BreakInheritanceList->setObjectName("BreakInheritanceList");

    m_CompactNamespaces = new QComboBox(this);
    m_CompactNamespaces->addItems({"Default","true","false",});
    m_CompactNamespaces->setObjectName("CompactNamespaces");

    m_ConstructorInitializerIndentWidth = new QLineEdit(this);
    m_ConstructorInitializerIndentWidth->setObjectName("ConstructorInitializerIndentWidth");
    m_setConstructorInitializerIndentWidth = new QPushButton("Set", this);

    m_setConstructorInitializerIndentWidth->setObjectName("setConstructorInitializerIndentWidth");
    m_ContinuationIndentWidth = new QLineEdit(this);
    m_ContinuationIndentWidth->setObjectName("ContinuationIndentWidth");
    m_setContinuationIndentWidth = new QPushButton("Set", this);

    m_setContinuationIndentWidth->setObjectName("setContinuationIndentWidth");
    m_Cpp11BracedListStyle = new QComboBox(this);
    m_Cpp11BracedListStyle->addItems({"Default","true","false",});
    m_Cpp11BracedListStyle->setObjectName("Cpp11BracedListStyle");

    m_DeriveLineEnding = new QComboBox(this);
    m_DeriveLineEnding->addItems({"Default","true","false",});
    m_DeriveLineEnding->setObjectName("DeriveLineEnding");

    m_DerivePointerAlignment = new QComboBox(this);
    m_DerivePointerAlignment->addItems({"Default","true","false",});
    m_DerivePointerAlignment->setObjectName("DerivePointerAlignment");

    m_DisableFormat = new QComboBox(this);
    m_DisableFormat->addItems({"Default","true","false",});
    m_DisableFormat->setObjectName("DisableFormat");

    m_EmptyLineAfterAccessModifier = new QComboBox(this);
    m_EmptyLineAfterAccessModifier->addItems({"Never","Leave","Always",});
    m_EmptyLineAfterAccessModifier->setObjectName("EmptyLineAfterAccessModifier");

    m_EmptyLineBeforeAccessModifier = new QComboBox(this);
    m_EmptyLineBeforeAccessModifier->addItems({"Never","Leave","LogicalBlock","Always",});
    m_EmptyLineBeforeAccessModifier->setObjectName("EmptyLineBeforeAccessModifier");

    m_ExperimentalAutoDetectBinPacking = new QComboBox(this);
    m_ExperimentalAutoDetectBinPacking->addItems({"Default","true","false",});
    m_ExperimentalAutoDetectBinPacking->setObjectName("ExperimentalAutoDetectBinPacking");

    m_PackConstructorInitializers = new QComboBox(this);
    m_PackConstructorInitializers->addItems({"Never","BinPack","CurrentLine","NextLine",});
    m_PackConstructorInitializers->setObjectName("PackConstructorInitializers");

    m_FixNamespaceComments = new QComboBox(this);
    m_FixNamespaceComments->addItems({"Default","true","false",});
    m_FixNamespaceComments->setObjectName("FixNamespaceComments");

    m_ForEachMacros = new QPlainTextEdit(this);
    m_ForEachMacros->setObjectName("ForEachMacros");
    m_ForEachMacros->setFixedHeight(100);
    m_setForEachMacros = new QPushButton("Set", this);

    m_setForEachMacros->setObjectName("setForEachMacros");
    m_IfMacros = new QPlainTextEdit(this);
    m_IfMacros->setObjectName("IfMacros");
    m_IfMacros->setFixedHeight(100);
    m_setIfMacros = new QPushButton("Set", this);

    m_setIfMacros->setObjectName("setIfMacros");
    m_TypenameMacros = new QPlainTextEdit(this);
    m_TypenameMacros->setObjectName("TypenameMacros");
    m_TypenameMacros->setFixedHeight(100);
    m_setTypenameMacros = new QPushButton("Set", this);

    m_setTypenameMacros->setObjectName("setTypenameMacros");
    m_StatementMacros = new QPlainTextEdit(this);
    m_StatementMacros->setObjectName("StatementMacros");
    m_StatementMacros->setFixedHeight(100);
    m_setStatementMacros = new QPushButton("Set", this);

    m_setStatementMacros->setObjectName("setStatementMacros");
    m_NamespaceMacros = new QPlainTextEdit(this);
    m_NamespaceMacros->setObjectName("NamespaceMacros");
    m_NamespaceMacros->setFixedHeight(100);
    m_setNamespaceMacros = new QPushButton("Set", this);

    m_setNamespaceMacros->setObjectName("setNamespaceMacros");
    m_WhitespaceSensitiveMacros = new QPlainTextEdit(this);
    m_WhitespaceSensitiveMacros->setObjectName("WhitespaceSensitiveMacros");
    m_WhitespaceSensitiveMacros->setFixedHeight(100);
    m_setWhitespaceSensitiveMacros = new QPushButton("Set", this);

    m_setWhitespaceSensitiveMacros->setObjectName("setWhitespaceSensitiveMacros");
    m_IndentAccessModifiers = new QComboBox(this);
    m_IndentAccessModifiers->addItems({"Default","true","false",});
    m_IndentAccessModifiers->setObjectName("IndentAccessModifiers");

    m_IndentCaseLabels = new QComboBox(this);
    m_IndentCaseLabels->addItems({"Default","true","false",});
    m_IndentCaseLabels->setObjectName("IndentCaseLabels");

    m_IndentCaseBlocks = new QComboBox(this);
    m_IndentCaseBlocks->addItems({"Default","true","false",});
    m_IndentCaseBlocks->setObjectName("IndentCaseBlocks");

    m_IndentGotoLabels = new QComboBox(this);
    m_IndentGotoLabels->addItems({"Default","true","false",});
    m_IndentGotoLabels->setObjectName("IndentGotoLabels");

    m_IndentPPDirectives = new QComboBox(this);
    m_IndentPPDirectives->addItems({"None","AfterHash","BeforeHash",});
    m_IndentPPDirectives->setObjectName("IndentPPDirectives");

    m_IndentExternBlock = new QComboBox(this);
    m_IndentExternBlock->addItems({"AfterExternBlock","NoIndent","Indent",});
    m_IndentExternBlock->setObjectName("IndentExternBlock");

    m_IndentRequires = new QComboBox(this);
    m_IndentRequires->addItems({"Default","true","false",});
    m_IndentRequires->setObjectName("IndentRequires");

    m_IndentWidth = new QLineEdit(this);
    m_IndentWidth->setObjectName("IndentWidth");
    m_setIndentWidth = new QPushButton("Set", this);

    m_setIndentWidth->setObjectName("setIndentWidth");
    m_IndentWrappedFunctionNames = new QComboBox(this);
    m_IndentWrappedFunctionNames->addItems({"Default","true","false",});
    m_IndentWrappedFunctionNames->setObjectName("IndentWrappedFunctionNames");

    m_JavaImportGroups = new QPlainTextEdit(this);
    m_JavaImportGroups->setObjectName("JavaImportGroups");
    m_JavaImportGroups->setFixedHeight(100);
    m_setJavaImportGroups = new QPushButton("Set", this);

    m_setJavaImportGroups->setObjectName("setJavaImportGroups");
    m_JavaScriptQuotes = new QComboBox(this);
    m_JavaScriptQuotes->addItems({"Leave","Single","Double",});
    m_JavaScriptQuotes->setObjectName("JavaScriptQuotes");

    m_JavaScriptWrapImports = new QComboBox(this);
    m_JavaScriptWrapImports->addItems({"Default","true","false",});
    m_JavaScriptWrapImports->setObjectName("JavaScriptWrapImports");

    m_KeepEmptyLinesAtTheStartOfBlocks = new QComboBox(this);
    m_KeepEmptyLinesAtTheStartOfBlocks->addItems({"Default","true","false",});
    m_KeepEmptyLinesAtTheStartOfBlocks->setObjectName("KeepEmptyLinesAtTheStartOfBlocks");

    m_Language = new QComboBox(this);
    m_Language->addItems({"None","Cpp","CSharp","Java","JavaScript","Json","ObjC","Proto","TableGen","TextProto",});
    m_Language->setObjectName("Language");

    m_LambdaBodyIndentation = new QComboBox(this);
    m_LambdaBodyIndentation->addItems({"Signature","OuterScope",});
    m_LambdaBodyIndentation->setObjectName("LambdaBodyIndentation");

    m_MacroBlockBegin = new QLineEdit(this);
    m_MacroBlockBegin->setObjectName("MacroBlockBegin");
    m_setMacroBlockBegin = new QPushButton("Set", this);

    m_setMacroBlockBegin->setObjectName("setMacroBlockBegin");
    m_MacroBlockEnd = new QLineEdit(this);
    m_MacroBlockEnd->setObjectName("MacroBlockEnd");
    m_setMacroBlockEnd = new QPushButton("Set", this);

    m_setMacroBlockEnd->setObjectName("setMacroBlockEnd");
    m_MaxEmptyLinesToKeep = new QLineEdit(this);
    m_MaxEmptyLinesToKeep->setObjectName("MaxEmptyLinesToKeep");
    m_setMaxEmptyLinesToKeep = new QPushButton("Set", this);

    m_setMaxEmptyLinesToKeep->setObjectName("setMaxEmptyLinesToKeep");
    m_NamespaceIndentation = new QComboBox(this);
    m_NamespaceIndentation->addItems({"None","Inner","All",});
    m_NamespaceIndentation->setObjectName("NamespaceIndentation");

    m_ObjCBinPackProtocolList = new QComboBox(this);
    m_ObjCBinPackProtocolList->addItems({"Auto","Always","Never",});
    m_ObjCBinPackProtocolList->setObjectName("ObjCBinPackProtocolList");

    m_ObjCBlockIndentWidth = new QLineEdit(this);
    m_ObjCBlockIndentWidth->setObjectName("ObjCBlockIndentWidth");
    m_setObjCBlockIndentWidth = new QPushButton("Set", this);

    m_setObjCBlockIndentWidth->setObjectName("setObjCBlockIndentWidth");
    m_ObjCSpaceAfterProperty = new QComboBox(this);
    m_ObjCSpaceAfterProperty->addItems({"Default","true","false",});
    m_ObjCSpaceAfterProperty->setObjectName("ObjCSpaceAfterProperty");

    m_ObjCBreakBeforeNestedBlockParam = new QComboBox(this);
    m_ObjCBreakBeforeNestedBlockParam->addItems({"Default","true","false",});
    m_ObjCBreakBeforeNestedBlockParam->setObjectName("ObjCBreakBeforeNestedBlockParam");

    m_ObjCSpaceBeforeProtocolList = new QComboBox(this);
    m_ObjCSpaceBeforeProtocolList->addItems({"Default","true","false",});
    m_ObjCSpaceBeforeProtocolList->setObjectName("ObjCSpaceBeforeProtocolList");

    m_PenaltyBreakAssignment = new QLineEdit(this);
    m_PenaltyBreakAssignment->setObjectName("PenaltyBreakAssignment");
    m_setPenaltyBreakAssignment = new QPushButton("Set", this);

    m_setPenaltyBreakAssignment->setObjectName("setPenaltyBreakAssignment");
    m_PenaltyBreakBeforeFirstCallParameter = new QLineEdit(this);
    m_PenaltyBreakBeforeFirstCallParameter->setObjectName("PenaltyBreakBeforeFirstCallParameter");
    m_setPenaltyBreakBeforeFirstCallParameter = new QPushButton("Set", this);

    m_setPenaltyBreakBeforeFirstCallParameter->setObjectName("setPenaltyBreakBeforeFirstCallParameter");
    m_PenaltyBreakComment = new QLineEdit(this);
    m_PenaltyBreakComment->setObjectName("PenaltyBreakComment");
    m_setPenaltyBreakComment = new QPushButton("Set", this);

    m_setPenaltyBreakComment->setObjectName("setPenaltyBreakComment");
    m_PenaltyBreakFirstLessLess = new QLineEdit(this);
    m_PenaltyBreakFirstLessLess->setObjectName("PenaltyBreakFirstLessLess");
    m_setPenaltyBreakFirstLessLess = new QPushButton("Set", this);

    m_setPenaltyBreakFirstLessLess->setObjectName("setPenaltyBreakFirstLessLess");
    m_PenaltyBreakOpenParenthesis = new QLineEdit(this);
    m_PenaltyBreakOpenParenthesis->setObjectName("PenaltyBreakOpenParenthesis");
    m_setPenaltyBreakOpenParenthesis = new QPushButton("Set", this);

    m_setPenaltyBreakOpenParenthesis->setObjectName("setPenaltyBreakOpenParenthesis");
    m_PenaltyBreakString = new QLineEdit(this);
    m_PenaltyBreakString->setObjectName("PenaltyBreakString");
    m_setPenaltyBreakString = new QPushButton("Set", this);

    m_setPenaltyBreakString->setObjectName("setPenaltyBreakString");
    m_PenaltyBreakTemplateDeclaration = new QLineEdit(this);
    m_PenaltyBreakTemplateDeclaration->setObjectName("PenaltyBreakTemplateDeclaration");
    m_setPenaltyBreakTemplateDeclaration = new QPushButton("Set", this);

    m_setPenaltyBreakTemplateDeclaration->setObjectName("setPenaltyBreakTemplateDeclaration");
    m_PenaltyExcessCharacter = new QLineEdit(this);
    m_PenaltyExcessCharacter->setObjectName("PenaltyExcessCharacter");
    m_setPenaltyExcessCharacter = new QPushButton("Set", this);

    m_setPenaltyExcessCharacter->setObjectName("setPenaltyExcessCharacter");
    m_PenaltyReturnTypeOnItsOwnLine = new QLineEdit(this);
    m_PenaltyReturnTypeOnItsOwnLine->setObjectName("PenaltyReturnTypeOnItsOwnLine");
    m_setPenaltyReturnTypeOnItsOwnLine = new QPushButton("Set", this);

    m_setPenaltyReturnTypeOnItsOwnLine->setObjectName("setPenaltyReturnTypeOnItsOwnLine");
    m_PenaltyIndentedWhitespace = new QLineEdit(this);
    m_PenaltyIndentedWhitespace->setObjectName("PenaltyIndentedWhitespace");
    m_setPenaltyIndentedWhitespace = new QPushButton("Set", this);

    m_setPenaltyIndentedWhitespace->setObjectName("setPenaltyIndentedWhitespace");
    m_PointerAlignment = new QComboBox(this);
    m_PointerAlignment->addItems({"Left","Right","Middle",});
    m_PointerAlignment->setObjectName("PointerAlignment");

    m_PPIndentWidth = new QLineEdit(this);
    m_PPIndentWidth->setObjectName("PPIndentWidth");
    m_setPPIndentWidth = new QPushButton("Set", this);

    m_setPPIndentWidth->setObjectName("setPPIndentWidth");
    m_ReferenceAlignment = new QComboBox(this);
    m_ReferenceAlignment->addItems({"Pointer","Left","Right","Middle",});
    m_ReferenceAlignment->setObjectName("ReferenceAlignment");

    m_ReflowComments = new QComboBox(this);
    m_ReflowComments->addItems({"Default","true","false",});
    m_ReflowComments->setObjectName("ReflowComments");

    m_RemoveBracesLLVM = new QComboBox(this);
    m_RemoveBracesLLVM->addItems({"Default","true","false",});
    m_RemoveBracesLLVM->setObjectName("RemoveBracesLLVM");

    m_SeparateDefinitionBlocks = new QComboBox(this);
    m_SeparateDefinitionBlocks->addItems({"Leave","Always","Never",});
    m_SeparateDefinitionBlocks->setObjectName("SeparateDefinitionBlocks");

    m_ShortNamespaceLines = new QLineEdit(this);
    m_ShortNamespaceLines->setObjectName("ShortNamespaceLines");
    m_setShortNamespaceLines = new QPushButton("Set", this);

    m_setShortNamespaceLines->setObjectName("setShortNamespaceLines");
    m_SortIncludes = new QComboBox(this);
    m_SortIncludes->addItems({"Never","CaseSensitive","CaseInsensitive",});
    m_SortIncludes->setObjectName("SortIncludes");

    m_SortJavaStaticImport = new QComboBox(this);
    m_SortJavaStaticImport->addItems({"Before","After",});
    m_SortJavaStaticImport->setObjectName("SortJavaStaticImport");

    m_SortUsingDeclarations = new QComboBox(this);
    m_SortUsingDeclarations->addItems({"Default","true","false",});
    m_SortUsingDeclarations->setObjectName("SortUsingDeclarations");

    m_SpaceAfterCStyleCast = new QComboBox(this);
    m_SpaceAfterCStyleCast->addItems({"Default","true","false",});
    m_SpaceAfterCStyleCast->setObjectName("SpaceAfterCStyleCast");

    m_SpaceAfterLogicalNot = new QComboBox(this);
    m_SpaceAfterLogicalNot->addItems({"Default","true","false",});
    m_SpaceAfterLogicalNot->setObjectName("SpaceAfterLogicalNot");

    m_SpaceAfterTemplateKeyword = new QComboBox(this);
    m_SpaceAfterTemplateKeyword->addItems({"Default","true","false",});
    m_SpaceAfterTemplateKeyword->setObjectName("SpaceAfterTemplateKeyword");

    m_SpaceAroundPointerQualifiers = new QComboBox(this);
    m_SpaceAroundPointerQualifiers->addItems({"Default","Before","After","Both",});
    m_SpaceAroundPointerQualifiers->setObjectName("SpaceAroundPointerQualifiers");

    m_SpaceBeforeAssignmentOperators = new QComboBox(this);
    m_SpaceBeforeAssignmentOperators->addItems({"Default","true","false",});
    m_SpaceBeforeAssignmentOperators->setObjectName("SpaceBeforeAssignmentOperators");

    m_SpaceBeforeCaseColon = new QComboBox(this);
    m_SpaceBeforeCaseColon->addItems({"Default","true","false",});
    m_SpaceBeforeCaseColon->setObjectName("SpaceBeforeCaseColon");

    m_SpaceBeforeCpp11BracedList = new QComboBox(this);
    m_SpaceBeforeCpp11BracedList->addItems({"Default","true","false",});
    m_SpaceBeforeCpp11BracedList->setObjectName("SpaceBeforeCpp11BracedList");

    m_SpaceBeforeCtorInitializerColon = new QComboBox(this);
    m_SpaceBeforeCtorInitializerColon->addItems({"Default","true","false",});
    m_SpaceBeforeCtorInitializerColon->setObjectName("SpaceBeforeCtorInitializerColon");

    m_SpaceBeforeInheritanceColon = new QComboBox(this);
    m_SpaceBeforeInheritanceColon->addItems({"Default","true","false",});
    m_SpaceBeforeInheritanceColon->setObjectName("SpaceBeforeInheritanceColon");

    m_SpaceBeforeParens = new QComboBox(this);
    m_SpaceBeforeParens->addItems({"Never","ControlStatements","ControlStatementsExceptControlMacros","NonEmptyParentheses","Always","Custom",});
    m_SpaceBeforeParens->setObjectName("SpaceBeforeParens");

    m_AfterControlStatements = new QComboBox(this);
    m_AfterControlStatements->addItems({"Default","true","false",});
    m_AfterControlStatements->setObjectName("AfterControlStatements");

    m_AfterForeachMacros = new QComboBox(this);
    m_AfterForeachMacros->addItems({"Default","true","false",});
    m_AfterForeachMacros->setObjectName("AfterForeachMacros");

    m_AfterFunctionDeclarationName = new QComboBox(this);
    m_AfterFunctionDeclarationName->addItems({"Default","true","false",});
    m_AfterFunctionDeclarationName->setObjectName("AfterFunctionDeclarationName");

    m_AfterFunctionDefinitionName = new QComboBox(this);
    m_AfterFunctionDefinitionName->addItems({"Default","true","false",});
    m_AfterFunctionDefinitionName->setObjectName("AfterFunctionDefinitionName");

    m_AfterIfMacros = new QComboBox(this);
    m_AfterIfMacros->addItems({"Default","true","false",});
    m_AfterIfMacros->setObjectName("AfterIfMacros");

    m_AfterOverloadedOperator = new QComboBox(this);
    m_AfterOverloadedOperator->addItems({"Default","true","false",});
    m_AfterOverloadedOperator->setObjectName("AfterOverloadedOperator");

    m_BeforeNonEmptyParentheses = new QComboBox(this);
    m_BeforeNonEmptyParentheses->addItems({"Default","true","false",});
    m_BeforeNonEmptyParentheses->setObjectName("BeforeNonEmptyParentheses");

    m_SpaceBeforeRangeBasedForLoopColon = new QComboBox(this);
    m_SpaceBeforeRangeBasedForLoopColon->addItems({"Default","true","false",});
    m_SpaceBeforeRangeBasedForLoopColon->setObjectName("SpaceBeforeRangeBasedForLoopColon");

    m_SpaceInEmptyBlock = new QComboBox(this);
    m_SpaceInEmptyBlock->addItems({"Default","true","false",});
    m_SpaceInEmptyBlock->setObjectName("SpaceInEmptyBlock");

    m_SpaceInEmptyParentheses = new QComboBox(this);
    m_SpaceInEmptyParentheses->addItems({"Default","true","false",});
    m_SpaceInEmptyParentheses->setObjectName("SpaceInEmptyParentheses");

    m_SpacesBeforeTrailingComments = new QLineEdit(this);
    m_SpacesBeforeTrailingComments->setObjectName("SpacesBeforeTrailingComments");
    m_setSpacesBeforeTrailingComments = new QPushButton("Set", this);

    m_setSpacesBeforeTrailingComments->setObjectName("setSpacesBeforeTrailingComments");
    m_SpacesInAngles = new QComboBox(this);
    m_SpacesInAngles->addItems({"Never","Always","Leave",});
    m_SpacesInAngles->setObjectName("SpacesInAngles");

    m_SpacesInConditionalStatement = new QComboBox(this);
    m_SpacesInConditionalStatement->addItems({"Default","true","false",});
    m_SpacesInConditionalStatement->setObjectName("SpacesInConditionalStatement");

    m_SpacesInContainerLiterals = new QComboBox(this);
    m_SpacesInContainerLiterals->addItems({"Default","true","false",});
    m_SpacesInContainerLiterals->setObjectName("SpacesInContainerLiterals");

    m_SpacesInCStyleCastParentheses = new QComboBox(this);
    m_SpacesInCStyleCastParentheses->addItems({"Default","true","false",});
    m_SpacesInCStyleCastParentheses->setObjectName("SpacesInCStyleCastParentheses");

    m_Minimum = new QLineEdit(this);
    m_Minimum->setObjectName("Minimum");
    m_setMinimum = new QPushButton("Set", this);

    m_setMinimum->setObjectName("setMinimum");
    m_Maximum = new QLineEdit(this);
    m_Maximum->setObjectName("Maximum");
    m_setMaximum = new QPushButton("Set", this);

    m_setMaximum->setObjectName("setMaximum");
    m_SpacesInParentheses = new QComboBox(this);
    m_SpacesInParentheses->addItems({"Default","true","false",});
    m_SpacesInParentheses->setObjectName("SpacesInParentheses");

    m_SpacesInSquareBrackets = new QComboBox(this);
    m_SpacesInSquareBrackets->addItems({"Default","true","false",});
    m_SpacesInSquareBrackets->setObjectName("SpacesInSquareBrackets");

    m_SpaceBeforeSquareBrackets = new QComboBox(this);
    m_SpaceBeforeSquareBrackets->addItems({"Default","true","false",});
    m_SpaceBeforeSquareBrackets->setObjectName("SpaceBeforeSquareBrackets");

    m_BitFieldColonSpacing = new QComboBox(this);
    m_BitFieldColonSpacing->addItems({"Both","None","Before","After",});
    m_BitFieldColonSpacing->setObjectName("BitFieldColonSpacing");

    m_Standard = new QComboBox(this);
    m_Standard->addItems({"Cpp03","Cpp11","Cpp14","Cpp17","Cpp20","Latest","Auto",});
    m_Standard->setObjectName("Standard");

    m_StatementAttributeLikeMacros = new QPlainTextEdit(this);
    m_StatementAttributeLikeMacros->setObjectName("StatementAttributeLikeMacros");
    m_StatementAttributeLikeMacros->setFixedHeight(100);
    m_setStatementAttributeLikeMacros = new QPushButton("Set", this);

    m_setStatementAttributeLikeMacros->setObjectName("setStatementAttributeLikeMacros");
    m_TabWidth = new QLineEdit(this);
    m_TabWidth->setObjectName("TabWidth");
    m_setTabWidth = new QPushButton("Set", this);

    m_setTabWidth->setObjectName("setTabWidth");
    m_UseCRLF = new QComboBox(this);
    m_UseCRLF->addItems({"Default","true","false",});
    m_UseCRLF->setObjectName("UseCRLF");

    m_UseTab = new QComboBox(this);
    m_UseTab->addItems({"Never","ForIndentation","ForContinuationAndIndentation","AlignWithSpaces","Always",});
    m_UseTab->setObjectName("UseTab");


    using namespace Layouting;

    Grid {
        new QLabel("BasedOnStyle"), m_BasedOnStyle, br,
        new QLabel("InheritsParentConfig"), m_InheritsParentConfig, br,
        new QLabel("AccessModifierOffset"), Row {m_AccessModifierOffset, m_setAccessModifierOffset}, br,
        new QLabel("AlignAfterOpenBracket"), m_AlignAfterOpenBracket, br,
        new QLabel("AlignArrayOfStructures"), m_AlignArrayOfStructures, br,
        new QLabel("AlignConsecutiveMacros"), m_AlignConsecutiveMacros, br,
        new QLabel("AlignConsecutiveAssignments"), m_AlignConsecutiveAssignments, br,
        new QLabel("AlignConsecutiveBitFields"), m_AlignConsecutiveBitFields, br,
        new QLabel("AlignConsecutiveDeclarations"), m_AlignConsecutiveDeclarations, br,
        new QLabel("AlignEscapedNewlines"), m_AlignEscapedNewlines, br,
        new QLabel("AlignOperands"), m_AlignOperands, br,
        new QLabel("AlignTrailingComments"), m_AlignTrailingComments, br,
        new QLabel("AllowAllArgumentsOnNextLine"), m_AllowAllArgumentsOnNextLine, br,
        new QLabel("AllowAllParametersOfDeclarationOnNextLine"), m_AllowAllParametersOfDeclarationOnNextLine, br,
        new QLabel("AllowShortEnumsOnASingleLine"), m_AllowShortEnumsOnASingleLine, br,
        new QLabel("AllowShortBlocksOnASingleLine"), m_AllowShortBlocksOnASingleLine, br,
        new QLabel("AllowShortCaseLabelsOnASingleLine"), m_AllowShortCaseLabelsOnASingleLine, br,
        new QLabel("AllowShortFunctionsOnASingleLine"), m_AllowShortFunctionsOnASingleLine, br,
        new QLabel("AllowShortIfStatementsOnASingleLine"), m_AllowShortIfStatementsOnASingleLine, br,
        new QLabel("AllowShortLambdasOnASingleLine"), m_AllowShortLambdasOnASingleLine, br,
        new QLabel("AllowShortLoopsOnASingleLine"), m_AllowShortLoopsOnASingleLine, br,
        new QLabel("AlwaysBreakAfterReturnType"), m_AlwaysBreakAfterReturnType, br,
        new QLabel("AlwaysBreakBeforeMultilineStrings"), m_AlwaysBreakBeforeMultilineStrings, br,
        new QLabel("AlwaysBreakTemplateDeclarations"), m_AlwaysBreakTemplateDeclarations, br,
        new QLabel("AttributeMacros"), Row {m_AttributeMacros, m_setAttributeMacros}, br,
        new QLabel("BinPackArguments"), m_BinPackArguments, br,
        new QLabel("InsertTrailingCommas"), m_InsertTrailingCommas, br,
        new QLabel("BinPackParameters"), m_BinPackParameters, br,
        new QLabel("BreakBeforeBinaryOperators"), m_BreakBeforeBinaryOperators, br,
        new QLabel("BreakBeforeBraces"), m_BreakBeforeBraces, br,
        new QLabel("BraceWrapping"), br,
        new QLabel("  AfterCaseLabel"), m_AfterCaseLabel, br,
        new QLabel("  AfterClass"), m_AfterClass, br,
        new QLabel("  AfterControlStatement"), m_AfterControlStatement, br,
        new QLabel("  AfterEnum"), m_AfterEnum, br,
        new QLabel("  AfterFunction"), m_AfterFunction, br,
        new QLabel("  AfterNamespace"), m_AfterNamespace, br,
        new QLabel("  AfterObjCDeclaration"), m_AfterObjCDeclaration, br,
        new QLabel("  AfterStruct"), m_AfterStruct, br,
        new QLabel("  AfterUnion"), m_AfterUnion, br,
        new QLabel("  AfterExternBlock"), m_AfterExternBlock, br,
        new QLabel("  BeforeCatch"), m_BeforeCatch, br,
        new QLabel("  BeforeElse"), m_BeforeElse, br,
        new QLabel("  BeforeLambdaBody"), m_BeforeLambdaBody, br,
        new QLabel("  BeforeWhile"), m_BeforeWhile, br,
        new QLabel("  IndentBraces"), m_IndentBraces, br,
        new QLabel("  SplitEmptyFunction"), m_SplitEmptyFunction, br,
        new QLabel("  SplitEmptyRecord"), m_SplitEmptyRecord, br,
        new QLabel("  SplitEmptyNamespace"), m_SplitEmptyNamespace, br,
        new QLabel("BreakBeforeConceptDeclarations"), m_BreakBeforeConceptDeclarations, br,
        new QLabel("BreakBeforeTernaryOperators"), m_BreakBeforeTernaryOperators, br,
        new QLabel("BreakConstructorInitializers"), m_BreakConstructorInitializers, br,
        new QLabel("BreakAfterJavaFieldAnnotations"), m_BreakAfterJavaFieldAnnotations, br,
        new QLabel("BreakStringLiterals"), m_BreakStringLiterals, br,
        new QLabel("ColumnLimit"), Row {m_ColumnLimit, m_setColumnLimit}, br,
        new QLabel("CommentPragmas"), Row {m_CommentPragmas, m_setCommentPragmas}, br,
        new QLabel("QualifierAlignment"), m_QualifierAlignment, br,
        new QLabel("QualifierOrder"), Row {m_QualifierOrder, m_setQualifierOrder}, br,
        new QLabel("BreakInheritanceList"), m_BreakInheritanceList, br,
        new QLabel("CompactNamespaces"), m_CompactNamespaces, br,
        new QLabel("ConstructorInitializerIndentWidth"), Row {m_ConstructorInitializerIndentWidth, m_setConstructorInitializerIndentWidth}, br,
        new QLabel("ContinuationIndentWidth"), Row {m_ContinuationIndentWidth, m_setContinuationIndentWidth}, br,
        new QLabel("Cpp11BracedListStyle"), m_Cpp11BracedListStyle, br,
        new QLabel("DeriveLineEnding"), m_DeriveLineEnding, br,
        new QLabel("DerivePointerAlignment"), m_DerivePointerAlignment, br,
        new QLabel("DisableFormat"), m_DisableFormat, br,
        new QLabel("EmptyLineAfterAccessModifier"), m_EmptyLineAfterAccessModifier, br,
        new QLabel("EmptyLineBeforeAccessModifier"), m_EmptyLineBeforeAccessModifier, br,
        new QLabel("ExperimentalAutoDetectBinPacking"), m_ExperimentalAutoDetectBinPacking, br,
        new QLabel("PackConstructorInitializers"), m_PackConstructorInitializers, br,
        new QLabel("FixNamespaceComments"), m_FixNamespaceComments, br,
        new QLabel("ForEachMacros"), Row {m_ForEachMacros, m_setForEachMacros}, br,
        new QLabel("IfMacros"), Row {m_IfMacros, m_setIfMacros}, br,
        new QLabel("TypenameMacros"), Row {m_TypenameMacros, m_setTypenameMacros}, br,
        new QLabel("StatementMacros"), Row {m_StatementMacros, m_setStatementMacros}, br,
        new QLabel("NamespaceMacros"), Row {m_NamespaceMacros, m_setNamespaceMacros}, br,
        new QLabel("WhitespaceSensitiveMacros"), Row {m_WhitespaceSensitiveMacros, m_setWhitespaceSensitiveMacros}, br,
        new QLabel("IndentAccessModifiers"), m_IndentAccessModifiers, br,
        new QLabel("IndentCaseLabels"), m_IndentCaseLabels, br,
        new QLabel("IndentCaseBlocks"), m_IndentCaseBlocks, br,
        new QLabel("IndentGotoLabels"), m_IndentGotoLabels, br,
        new QLabel("IndentPPDirectives"), m_IndentPPDirectives, br,
        new QLabel("IndentExternBlock"), m_IndentExternBlock, br,
        new QLabel("IndentRequires"), m_IndentRequires, br,
        new QLabel("IndentWidth"), Row {m_IndentWidth, m_setIndentWidth}, br,
        new QLabel("IndentWrappedFunctionNames"), m_IndentWrappedFunctionNames, br,
        new QLabel("JavaImportGroups"), Row {m_JavaImportGroups, m_setJavaImportGroups}, br,
        new QLabel("JavaScriptQuotes"), m_JavaScriptQuotes, br,
        new QLabel("JavaScriptWrapImports"), m_JavaScriptWrapImports, br,
        new QLabel("KeepEmptyLinesAtTheStartOfBlocks"), m_KeepEmptyLinesAtTheStartOfBlocks, br,
        new QLabel("Language"), m_Language, br,
        new QLabel("LambdaBodyIndentation"), m_LambdaBodyIndentation, br,
        new QLabel("MacroBlockBegin"), Row {m_MacroBlockBegin, m_setMacroBlockBegin}, br,
        new QLabel("MacroBlockEnd"), Row {m_MacroBlockEnd, m_setMacroBlockEnd}, br,
        new QLabel("MaxEmptyLinesToKeep"), Row {m_MaxEmptyLinesToKeep, m_setMaxEmptyLinesToKeep}, br,
        new QLabel("NamespaceIndentation"), m_NamespaceIndentation, br,
        new QLabel("ObjCBinPackProtocolList"), m_ObjCBinPackProtocolList, br,
        new QLabel("ObjCBlockIndentWidth"), Row {m_ObjCBlockIndentWidth, m_setObjCBlockIndentWidth}, br,
        new QLabel("ObjCSpaceAfterProperty"), m_ObjCSpaceAfterProperty, br,
        new QLabel("ObjCBreakBeforeNestedBlockParam"), m_ObjCBreakBeforeNestedBlockParam, br,
        new QLabel("ObjCSpaceBeforeProtocolList"), m_ObjCSpaceBeforeProtocolList, br,
        new QLabel("PenaltyBreakAssignment"), Row {m_PenaltyBreakAssignment, m_setPenaltyBreakAssignment}, br,
        new QLabel("PenaltyBreakBeforeFirstCallParameter"), Row {m_PenaltyBreakBeforeFirstCallParameter, m_setPenaltyBreakBeforeFirstCallParameter}, br,
        new QLabel("PenaltyBreakComment"), Row {m_PenaltyBreakComment, m_setPenaltyBreakComment}, br,
        new QLabel("PenaltyBreakFirstLessLess"), Row {m_PenaltyBreakFirstLessLess, m_setPenaltyBreakFirstLessLess}, br,
        new QLabel("PenaltyBreakOpenParenthesis"), Row {m_PenaltyBreakOpenParenthesis, m_setPenaltyBreakOpenParenthesis}, br,
        new QLabel("PenaltyBreakString"), Row {m_PenaltyBreakString, m_setPenaltyBreakString}, br,
        new QLabel("PenaltyBreakTemplateDeclaration"), Row {m_PenaltyBreakTemplateDeclaration, m_setPenaltyBreakTemplateDeclaration}, br,
        new QLabel("PenaltyExcessCharacter"), Row {m_PenaltyExcessCharacter, m_setPenaltyExcessCharacter}, br,
        new QLabel("PenaltyReturnTypeOnItsOwnLine"), Row {m_PenaltyReturnTypeOnItsOwnLine, m_setPenaltyReturnTypeOnItsOwnLine}, br,
        new QLabel("PenaltyIndentedWhitespace"), Row {m_PenaltyIndentedWhitespace, m_setPenaltyIndentedWhitespace}, br,
        new QLabel("PointerAlignment"), m_PointerAlignment, br,
        new QLabel("PPIndentWidth"), Row {m_PPIndentWidth, m_setPPIndentWidth}, br,
        new QLabel("ReferenceAlignment"), m_ReferenceAlignment, br,
        new QLabel("ReflowComments"), m_ReflowComments, br,
        new QLabel("RemoveBracesLLVM"), m_RemoveBracesLLVM, br,
        new QLabel("SeparateDefinitionBlocks"), m_SeparateDefinitionBlocks, br,
        new QLabel("ShortNamespaceLines"), Row {m_ShortNamespaceLines, m_setShortNamespaceLines}, br,
        new QLabel("SortIncludes"), m_SortIncludes, br,
        new QLabel("SortJavaStaticImport"), m_SortJavaStaticImport, br,
        new QLabel("SortUsingDeclarations"), m_SortUsingDeclarations, br,
        new QLabel("SpaceAfterCStyleCast"), m_SpaceAfterCStyleCast, br,
        new QLabel("SpaceAfterLogicalNot"), m_SpaceAfterLogicalNot, br,
        new QLabel("SpaceAfterTemplateKeyword"), m_SpaceAfterTemplateKeyword, br,
        new QLabel("SpaceAroundPointerQualifiers"), m_SpaceAroundPointerQualifiers, br,
        new QLabel("SpaceBeforeAssignmentOperators"), m_SpaceBeforeAssignmentOperators, br,
        new QLabel("SpaceBeforeCaseColon"), m_SpaceBeforeCaseColon, br,
        new QLabel("SpaceBeforeCpp11BracedList"), m_SpaceBeforeCpp11BracedList, br,
        new QLabel("SpaceBeforeCtorInitializerColon"), m_SpaceBeforeCtorInitializerColon, br,
        new QLabel("SpaceBeforeInheritanceColon"), m_SpaceBeforeInheritanceColon, br,
        new QLabel("SpaceBeforeParens"), m_SpaceBeforeParens, br,
        new QLabel("SpaceBeforeParensOptions"), br,
        new QLabel("  AfterControlStatements"), m_AfterControlStatements, br,
        new QLabel("  AfterForeachMacros"), m_AfterForeachMacros, br,
        new QLabel("  AfterFunctionDeclarationName"), m_AfterFunctionDeclarationName, br,
        new QLabel("  AfterFunctionDefinitionName"), m_AfterFunctionDefinitionName, br,
        new QLabel("  AfterIfMacros"), m_AfterIfMacros, br,
        new QLabel("  AfterOverloadedOperator"), m_AfterOverloadedOperator, br,
        new QLabel("  BeforeNonEmptyParentheses"), m_BeforeNonEmptyParentheses, br,
        new QLabel("SpaceBeforeRangeBasedForLoopColon"), m_SpaceBeforeRangeBasedForLoopColon, br,
        new QLabel("SpaceInEmptyBlock"), m_SpaceInEmptyBlock, br,
        new QLabel("SpaceInEmptyParentheses"), m_SpaceInEmptyParentheses, br,
        new QLabel("SpacesBeforeTrailingComments"), Row {m_SpacesBeforeTrailingComments, m_setSpacesBeforeTrailingComments}, br,
        new QLabel("SpacesInAngles"), m_SpacesInAngles, br,
        new QLabel("SpacesInConditionalStatement"), m_SpacesInConditionalStatement, br,
        new QLabel("SpacesInContainerLiterals"), m_SpacesInContainerLiterals, br,
        new QLabel("SpacesInCStyleCastParentheses"), m_SpacesInCStyleCastParentheses, br,
        new QLabel("SpacesInLineCommentPrefix"), br,
        new QLabel("  Minimum"), Row {m_Minimum, m_setMinimum}, br,
        new QLabel("  Maximum"), Row {m_Maximum, m_setMaximum}, br,
        new QLabel("SpacesInParentheses"), m_SpacesInParentheses, br,
        new QLabel("SpacesInSquareBrackets"), m_SpacesInSquareBrackets, br,
        new QLabel("SpaceBeforeSquareBrackets"), m_SpaceBeforeSquareBrackets, br,
        new QLabel("BitFieldColonSpacing"), m_BitFieldColonSpacing, br,
        new QLabel("Standard"), m_Standard, br,
        new QLabel("StatementAttributeLikeMacros"), Row {m_StatementAttributeLikeMacros, m_setStatementAttributeLikeMacros}, br,
        new QLabel("TabWidth"), Row {m_TabWidth, m_setTabWidth}, br,
        new QLabel("UseCRLF"), m_UseCRLF, br,
        new QLabel("UseTab"), m_UseTab, br,
    }.attachTo(this);
}
