/****************************************************************************
**
** Copyright (C) 2013 Digia Plc and/or its subsidiary(-ies).
** Contact: http://www.qt-project.org/legal
**
** This file is part of Qt Creator.
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and Digia.  For licensing terms and
** conditions see http://qt.digia.com/licensing.  For further information
** use the contact form at http://qt.digia.com/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Digia gives you certain additional
** rights.  These rights are described in the Digia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
****************************************************************************/

#include "pluginerroroverview.h"
#include "ui_pluginerroroverview.h"
#include "pluginspec.h"
#include "pluginmanager.h"

Q_DECLARE_METATYPE(ExtensionSystem::PluginSpec*)

namespace ExtensionSystem {
namespace Internal {

class PluginErrorOverviewPrivate : public QObject
{
    Q_OBJECT
public:
    PluginErrorOverviewPrivate(QDialog *dialog);
    ~PluginErrorOverviewPrivate();

private slots:
    void showDetails(QListWidgetItem *item);

private:
    Ui::PluginErrorOverview *m_ui;
};

} // Internal
} // ExtensionSystem

using namespace ExtensionSystem;
using namespace ExtensionSystem::Internal;

PluginErrorOverview::PluginErrorOverview(QWidget *parent) :
    QDialog(parent),
    d(new PluginErrorOverviewPrivate(this))
{
}

PluginErrorOverview::~PluginErrorOverview()
{
    delete d;
}

PluginErrorOverviewPrivate::PluginErrorOverviewPrivate(QDialog *dialog)
    : m_ui(new Ui::PluginErrorOverview)
{
    m_ui->setupUi(dialog);
    m_ui->buttonBox->addButton(tr("Continue"), QDialogButtonBox::AcceptRole);

    foreach (PluginSpec *spec, PluginManager::plugins()) {
        // only show errors on startup if plugin is enabled.
        if (spec->hasError() && spec->isEnabled() && !spec->isDisabledIndirectly()) {
            QListWidgetItem *item = new QListWidgetItem(spec->name());
            item->setData(Qt::UserRole, qVariantFromValue(spec));
            m_ui->pluginList->addItem(item);
        }
    }

    connect(m_ui->pluginList, SIGNAL(currentItemChanged(QListWidgetItem*,QListWidgetItem*)),
            this, SLOT(showDetails(QListWidgetItem*)));

    if (m_ui->pluginList->count() > 0)
        m_ui->pluginList->setCurrentRow(0);
}

PluginErrorOverviewPrivate::~PluginErrorOverviewPrivate()
{
    delete m_ui;
}

void PluginErrorOverviewPrivate::showDetails(QListWidgetItem *item)
{
    if (item) {
        PluginSpec *spec = item->data(Qt::UserRole).value<PluginSpec *>();
        m_ui->pluginError->setText(spec->errorString());
    } else {
        m_ui->pluginError->setText(QString());
    }
}

#include "pluginerroroverview.moc"
