TARGET = QtWebSockets

QT = core-private network

QMAKE_DOCS = $$PWD/doc/qtwebsockets.qdocconf
OTHER_FILES += doc/src/*.qdoc   # show .qdoc files in Qt Creator
OTHER_FILES += doc/snippets/*.cpp
OTHER_FILES += doc/qtwebsockets.qdocconf

PUBLIC_HEADERS += \
    $$PWD/qwebsockets_global.h \
    $$PWD/qwebsocket.h \
    $$PWD/qwebsocketserver.h \
    $$PWD/qwebsocketprotocol.h \
    $$PWD/qwebsocketcorsauthenticator.h \
    $$PWD/qmaskgenerator.h

PRIVATE_HEADERS += \
    $$PWD/qwebsocketserver_p.h \
    $$PWD/qwebsocketprotocol_p.h \
    $$PWD/qwebsockethandshakerequest_p.h \
    $$PWD/qwebsockethandshakeresponse_p.h \
    $$PWD/qwebsocketdataprocessor_p.h \
    $$PWD/qwebsocketcorsauthenticator_p.h \
    $$PWD/qwebsocketframe_p.h \
    $$PWD/qdefaultmaskgenerator_p.h

SOURCES += \
    $$PWD/qwebsocket.cpp \
    $$PWD/qwebsocketserver.cpp \
    $$PWD/qwebsocketserver_p.cpp \
    $$PWD/qwebsocketprotocol.cpp \
    $$PWD/qwebsockethandshakerequest.cpp \
    $$PWD/qwebsockethandshakeresponse.cpp \
    $$PWD/qwebsocketdataprocessor.cpp \
    $$PWD/qwebsocketcorsauthenticator.cpp \
    $$PWD/qwebsocketframe.cpp \
    $$PWD/qmaskgenerator.cpp \
    $$PWD/qdefaultmaskgenerator_p.cpp

emscripten: {
    SOURCES += \
    $$PWD/qwebsocket_wasm_p.cpp
    PRIVATE_HEADERS += \
    $$PWD/qwebsocket_wasm_p.h
 } else {
    SOURCES += \
    $$PWD/qwebsocket_p.cpp
    PRIVATE_HEADERS += \
    $$PWD/qwebsocket_p.h
}

qtConfig(ssl) {
    SOURCES += $$PWD/qsslserver.cpp
    PRIVATE_HEADERS += $$PWD/qsslserver_p.h
}

HEADERS += $$PUBLIC_HEADERS $$PRIVATE_HEADERS

load(qt_module)
