CppApplication {
    Depends { name: "Sanitizers.address" }
    Sanitizers.address.enabled: sanitizer === "address"
    property string sanitizer

    property bool supportsSanitizer: {
        if (qbs.toolchain.includes("mingw") || qbs.toolchain.contains("emscripten"))
            return false;
        if (sanitizer === "address")
            return Sanitizers.address._supported;
        if (qbs.toolchain.includes("clang-cl")) {
            if (cpp.toolchainInstallPath.includes("Microsoft Visual Studio")
                    && qbs.architecture === "x86_64") {
                // 32 bit sanitizer shipped with VS misses the x86_64 libraries
                return false;
            }
            // only these are supported
            return sanitizer === "address" || sanitizer === "undefined";
        }
        if (!qbs.toolchain.includes("gcc"))
            return false;
        if (qbs.targetOS.includes("ios")) {
            // thread sanitizer is not supported
            return sanitizer !== "thread";
        }
        return true;
    }

    condition: {
        if (!sanitizer)
            return true;
        if (!supportsSanitizer)
            console.info("Compiler does not support sanitizer");
        return supportsSanitizer;
    }
    qbs.buildVariant: "release"
    cpp.cxxLanguageVersion: "c++11"
    cpp.minimumMacosVersion: "10.8"
    consoleApplication: true
    cpp.runtimeLibrary: "static"
    cpp.driverFlags: sanitizer && sanitizer !== "address" ? ["-fsanitize=" + sanitizer] : []
    cpp.debugInformation: true
    files: "sanitizer.cpp"
}
