import QtQuick 2.15
import QtQuick.Controls 2.15
import QtQuick.Studio.Components
import QtQuick.Effects

Item{
    id: root

    width: 355
    height: 355
    property alias glowRectRadius: sourceItem.radius

    RectangleItem {
        id: sourceItem
        anchors.fill: root

        fillColor: "transparent"
        strokeColor: "#e4e4e4"
        strokeWidth: 6
        radius: 48
        //border.width: 6
        z:2

        BorderItem{
            radius: sourceItem.radius
            anchors.fill: parent
            antialiasing: true
            strokeWidth: 1
            strokeColor: "#000000"
        }
        BorderItem{
            radius: sourceItem.radius - sourceItem.strokeWidth
            anchors.left: parent.left
            anchors.right: parent.right
            anchors.top: parent.top
            anchors.bottom: parent.bottom
            antialiasing: true
            anchors.rightMargin: sourceItem.strokeWidth
            anchors.leftMargin: sourceItem.strokeWidth
            anchors.bottomMargin: sourceItem.strokeWidth
            anchors.topMargin: sourceItem.strokeWidth


            strokeWidth: 1
            strokeColor: "#000000"
        }
    }
    GlowEffect {
        id: glowEffectID
        source: sourceItem
        anchors.fill: sourceItem
    }
}
