

/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the Qt Virtual Keyboard module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:GPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 or (at your option) any later version
** approved by the KDE Free Qt Foundation. The licenses are as published by
** the Free Software Foundation and appearing in the file LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/
import QtQuick

import QtQuick.VirtualKeyboard
import QtQuick.VirtualKeyboard.Styles

KeyboardStyle {
    id: test
    readonly property bool compactSelectionList: [InputEngine.InputMode.Pinyin, InputEngine.InputMode.Cangjie, InputEngine.InputMode.Zhuyin].indexOf(
        InputContext.inputEngine.inputMode) !== -1
    readonly property real keyBackgroundMargin: Math.round(13 * scaleHint)
    readonly property real keyContentMargin: Math.round(45 * scaleHint)
    readonly property real keyIconScale: scaleHint * 0.6
    readonly property string resourcePrefix: "./"

    readonly property string inputLocale: InputContext.locale
    property color inputLocaleIndicatorColor: "white"
    property Timer inputLocaleIndicatorHighlightTimer: Timer {
        interval: 1000
        onTriggered: inputLocaleIndicatorColor = "gray"
    }

    fullScreenInputFont.weight: Font.Normal
    fullScreenInputFont.family: "Noto Sans Display"

    onInputLocaleChanged: {
        inputLocaleIndicatorColor = "white"
        inputLocaleIndicatorHighlightTimer.restart()
    }

    keyboardDesignWidth: 1663
    keyboardDesignHeight: 503

    // spacing around the keyboard.  Set the number to the margin that you want
    keyboardRelativeLeftMargin: 22 / keyboardDesignWidth
    keyboardRelativeRightMargin: 22 / keyboardDesignWidth
    keyboardRelativeTopMargin: 25 / keyboardDesignHeight
    keyboardRelativeBottomMargin: 10 / keyboardDesignHeight

    keyboardBackground: KeyboardBackground {}

    keyPanel: KeyboardBasicKey {}

    spaceKeyPanel: KeyboardSpacebar {}

    backspaceKeyPanel: KeyboardBackspaceKey {}

    shiftKeyPanel: KeyboardShiftKey {}

    enterKeyPanel: KeyboardEnterKey {}
}
