import QtQuick

Item {
    id: lighting
    property color color: "#ffbbaa"
    property color ambientColor: "#997766"
    property real brightness: 5.0
    property vector3d lightPosition: Qt.vector3d(-85, 20, 100)
    property int probeRotation: -25

    Behavior on color { ColorAnimation { duration: 3000; easing.type: Easing.InOutCubic } }
    Behavior on ambientColor { ColorAnimation { duration: 3000; easing.type: Easing.InOutCubic } }
    Behavior on brightness { NumberAnimation { duration: 3000; easing.type: Easing.InOutCubic } }
    Behavior on lightPosition { PropertyAnimation { duration: 3000; easing.type: Easing.InOutQuad } }
    Behavior on probeRotation { NumberAnimation { duration: 3000; easing.type: Easing.InOutQuad } }

    states: [
        State {
            name: "Day"

            PropertyChanges {
                target: lighting
                color: "#ffffff"
                ambientColor: "#888888"
                brightness: 10.0
                lightPosition: Qt.vector3d(20, 60, 20)
                probeRotation: 75
            }
        },
        State {
            name: "Dusk"

            PropertyChanges {
                target: lighting
                color: "#aabbff"
                ambientColor: "#667799"
                brightness: 5.0
                lightPosition: Qt.vector3d(-85, 20, -100)
                probeRotation: 175
            }
        }
    ]
}




/*##^##
Designer {
    D{i:0;height:0;width:0}
}
##^##*/
