/****************************************************************************
**
** Copyright (C) 2022 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt Quick Studio Components.
**
** $QT_BEGIN_LICENSE:GPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 or (at your option) any later version
** approved by the KDE Free Qt Foundation. The licenses are as published by
** the Free Software Foundation and appearing in the file LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

import QtQuick 2.8
import QtQuick.Studio.Components 1.0

Rectangle {
    id: iconsPreview
    width: 862
    height: 324
    color: "#ffffff"

    Item {
        id: variantFrame_LargeButton
        x: 0
        y: 0
        width: 862
        height: 324
        Image {
            id: variantFrame_Icons_merged_child
            x: 0
            y: 0
            source: "assets/variantFrame_Icons_merged_child.png"
        }
    }

    Rectangle {
        id: iconGroup
        x: 96
        y: 155
        width: 671
        height: 41
        color: "transparent"
        SvgPathItem {
            id: tornado
            x: 0
            y: 0
            width: 36
            height: 41
            strokeWidth: 1
            path: "M 29.315955363929316 0 L 23.75191904395419 5.041407650709256 C 26.34203853060695 5.819986469802502 28.7261026694476 7.161216641303248 30.731965183025626 8.96825222595009 C 37.75601224144524 15.337184831447773 37.75601224144524 25.662817066642027 30.731965183025626 32.03174967213971 C 25.54793056060211 36.72883718991231 17.535879851492844 39.718252344580705 6.6998070703978465 41 L 12.263844344053657 35.958593772858094 C 9.673724857400895 35.18001495376485 7.289659764879564 33.83878525678655 5.283797251301535 32.03174967213971 C -1.740249807118082 25.662817066642027 -1.7822499043935114 15.375000474522448 5.283797251301535 8.96825222595009 C 10.467831873725046 4.271164708177489 18.48188531226843 1.2817476554192964 29.31795809336343 0 L 29.315955363929316 0 Z M 18.00788121716358 12.538836259848308 C 13.037848248422371 12.538836259848308 9.007822088961241 16.101457807037782 9.007822088961241 20.5000018980898 C 9.007822088961241 24.898545989141816 13.037848248422371 28.461167536331292 18.00788121716358 28.461167536331292 C 22.977914185904787 28.461167536331292 27.007941299046603 24.898545989141816 27.007941299046603 20.5000018980898 C 27.007941299046603 16.101457807037782 22.977914185904787 12.538836259848308 18.00788121716358 12.538836259848308 Z"
            strokeColor: "transparent"
            fillColor: "#dcdada"
        }

        SvgPathItem {
            id: plant
            x: 57
            y: 0
            width: 39
            height: 41
            strokeWidth: 1
            path: "M 8.210526315789474 0 C 13.732105380610417 0 18.52294648948469 3.1098504066467285 20.930683286566484 7.669050359725952 C 23.346630748949554 4.27015037536621 27.320526198336953 2.05 31.815789473684212 2.05 L 39 2.05 L 39 7.174999999999999 C 39 14.534499824047087 33.02684192908438 20.5 25.657894736842106 20.5 L 22.578947368421055 20.5 L 22.578947368421055 22.549999999999997 L 32.8421052631579 22.549999999999997 L 32.8421052631579 36.9 C 32.8421052631579 39.16525003910065 31.005000039150843 41 28.73684210526316 41 L 12.315789473684212 41 C 10.04763153979653 41 8.210526315789474 39.16525003910065 8.210526315789474 36.9 L 8.210526315789474 22.549999999999997 L 18.47368421052632 22.549999999999997 L 18.47368421052632 18.45 L 14.36842105263158 18.45 C 6.432947497618827 18.45 0 12.025299870967864 0 4.1 L 0 0 L 8.210526315789474 0 Z M 28.73684210526316 26.65 L 12.315789473684212 26.65 L 12.315789473684212 36.9 L 28.73684210526316 36.9 L 28.73684210526316 26.65 Z M 34.89473684210527 6.1499999999999995 L 31.815789473684212 6.1499999999999995 C 26.715000215329624 6.1499999999999995 22.578947368421055 10.280750215053557 22.578947368421055 15.374999999999998 L 22.578947368421055 16.4 L 25.657894736842106 16.4 C 30.758683995196694 16.4 34.89473684210527 12.26924978494644 34.89473684210527 7.174999999999999 L 34.89473684210527 6.1499999999999995 Z M 8.210526315789474 4.1 L 4.105263157894737 4.1 C 4.105263157894737 9.760049831867217 8.701105431506509 14.349999999999998 14.36842105263158 14.349999999999998 L 18.47368421052632 14.349999999999998 C 18.47368421052632 8.68995016813278 13.877841936914546 4.1 8.210526315789474 4.1 Z"
            strokeColor: "transparent"
            fillColor: "#dcdada"
        }

        SvgPathItem {
            id: cactus
            x: 117
            y: 0
            width: 33
            height: 41
            strokeWidth: 1
            path: "M 16.5 0 C 21.05812507867813 0 24.75 3.669499921798706 24.75 8.2 L 24.75 26.65 L 26.8125 26.65 C 27.946875024586916 26.65 28.875 25.7275000244379 28.875 24.599999999999998 L 28.875 12.299999999999999 C 28.875 11.168400028347968 29.799000028520823 10.25 30.9375 10.25 C 32.07599997147918 10.25 33 11.168400028347968 33 12.299999999999999 L 33 24.599999999999998 C 33 28.002999931573864 30.236249931156635 30.749999999999996 26.8125 30.749999999999996 L 24.75 30.749999999999996 L 24.75 36.9 L 28.875 36.9 L 28.875 41 L 4.125 41 L 4.125 36.9 L 8.25 36.9 L 8.25 24.599999999999998 L 6.1875 24.599999999999998 C 2.769937612116337 24.599999999999998 0 21.846849888563156 0 18.45 L 0 14.349999999999998 C 0 13.218400028347967 0.9240000285208225 12.299999999999999 2.0625 12.299999999999999 C 3.2009999714791775 12.299999999999999 4.125 13.218400028347967 4.125 14.349999999999998 L 4.125 18.45 C 4.125 19.577500024437903 5.053124975413084 20.5 6.1875 20.5 L 8.25 20.5 L 8.25 8.2 C 8.25 3.669499921798706 11.941874921321869 0 16.5 0 Z M 16.5 4.1 C 14.220937460660934 4.1 12.375 5.934749960899353 12.375 8.2 L 12.375 36.9 L 20.625 36.9 L 20.625 8.2 C 20.625 5.934749960899353 18.779062539339066 4.1 16.5 4.1 Z"
            strokeColor: "transparent"
            fillColor: "#dcdada"
        }

        SvgPathItem {
            id: lightning
            x: 171
            y: 0
            width: 30
            height: 41
            strokeWidth: 1
            path: "M 16.875 16.772727272727273 L 30 16.772727272727273 L 13.125 41 L 13.125 24.227272727272727 L 0 24.227272727272727 L 16.875 0 L 16.875 16.772727272727273 Z"
            strokeColor: "transparent"
            fillColor: "#dcdada"
        }

        SvgPathItem {
            id: key
            x: 222
            y: 10
            width: 41
            height: 22
            strokeWidth: 1
            path: "M 29.817091094578952 14.666659090269698 L 21.72625724093663 14.666659090269698 C 20.846923835597476 17.11310484483036 19.11665480671428 19.175014541516457 16.841263981037024 20.487961555560396 C 14.56587315535977 21.800908569604335 11.891866340388638 22.280355636636692 9.291857163629452 21.84156180376952 C 6.691847986870265 21.402767970902346 4.333243201416327 20.073986933735192 2.6329113592043014 18.09007212782897 C 0.9325795169922757 16.10615732192275 0 13.594847483155366 0 11 C -1.6554030598778874e-15 8.405152516844634 0.9325795169922757 5.893842678077251 2.6329113592043014 3.9099278721710307 C 4.333243201416327 1.9260130662648105 6.691847986870265 0.5972320700757645 9.291857163629452 0.15843823720859151 C 11.891866340388638 -0.2803555956585815 14.56587315535977 0.19909055619601723 16.841263981037024 1.512037570239955 C 19.11665480671428 2.824984584283893 20.846923835597476 4.886895155169643 21.72625724093663 7.333340909730303 L 41 7.333340909730303 L 41 14.666659090269698 L 37.27236369819298 14.666659090269698 L 37.27236369819298 21.999977270809094 L 29.817091094578952 21.999977270809094 L 29.817091094578952 14.666659090269698 Z M 11.17890958554387 14.666659090269698 C 12.167540237168122 14.666659090269698 13.11567838604314 14.280350756516484 13.814745780685014 13.592718807006758 C 14.513813175326888 12.905086857497032 14.906545887350886 11.972458489026966 14.906545887350886 11 C 14.906545887350886 10.027541510973034 14.513813175326888 9.094913142502968 13.814745780685014 8.407281192993242 C 13.11567838604314 7.719649243483517 12.167540237168122 7.333340909730303 11.17890958554387 7.333340909730303 C 10.190278933919618 7.333340909730303 9.242139896306849 7.719649243483517 8.543072501664975 8.407281192993242 C 7.844005107023101 9.094913142502968 7.451273283736857 10.027541510973034 7.451273283736853 11 C 7.451273283736855 11.972458489026966 7.844005107023101 12.905086857497032 8.543072501664975 13.592718807006758 C 9.242139896306849 14.280350756516484 10.190278933919618 14.666659090269698 11.17890958554387 14.666659090269698 L 11.17890958554387 14.666659090269698 Z"
            strokeColor: "transparent"
            fillColor: "#dcdada"
        }

        SvgPathItem {
            id: ghost
            x: 284
            y: 0
            width: 37
            height: 41
            strokeWidth: 1
            path: "M 18.5 0 C 23.406504935688442 5.4618357803679014e-15 28.112050996886357 1.9436692031942342 31.581473880343964 5.403422934272789 C 35.050896763801575 8.863176665351343 36.99999999999999 13.555610499772758 37 18.44844118891779 L 37 33.82214217968262 C 37.0007426218217 35.35529318668715 36.5089533113771 36.848362819008095 35.596728748745385 38.08247412947858 C 34.68450418611367 39.31658543994906 33.39982404973772 40.2268260256306 31.931012577480736 40.67976538923885 C 30.46220110522376 41.132704752847104 28.886514862378437 41.10451755365228 27.434939596388073 40.59933433435247 C 25.98336433039771 40.09415111505266 24.732249096035954 39.13854456837296 23.864999294281002 37.87259958999284 C 23.328033026721737 38.820992646266504 22.548042989439434 39.61010361415843 21.604838159349228 40.15918817131808 C 20.661633329259022 40.70827272847772 19.589077926344338 40.99761897178564 18.49691640006171 40.99761897178564 C 17.404754873779083 40.99761897178564 16.3321994708644 40.70827272847772 15.388994640774195 40.15918817131808 C 14.44578981068399 39.61010361415843 13.665799773401682 38.820992646266504 13.128833505842419 37.87259958999284 C 12.279924127790661 39.108331240989735 11.064445926083458 40.04810822020692 9.652856747309366 40.56013924757258 C 8.241267568535275 41.07217027493824 6.704367200533548 41.13077532949406 5.2576908005608445 40.72773001014815 C 3.811014400588141 40.32468469080224 2.527122010787328 39.48020647819617 1.5860652128855386 38.31272620435552 C 0.6450084149837493 37.14524593051487 0.09398780266443887 35.71332063357055 0.010278013017442491 34.21776037829446 L 0 33.820093478887344 L 0 18.44844118891779 C 3.651400169878292e-15 13.555610499772758 1.9491012758678856 8.863176665351343 5.418524159325493 5.403422934272789 C 8.8879470427831 1.9436692031942342 13.593495064311558 2.7309178901839507e-15 18.5 0 L 18.5 0 Z M 18.5 20.498267987686436 C 16.2286110719045 20.498267987686436 14.388888888888888 22.79407401208165 14.388888888888888 25.622834984608044 C 14.388888888888888 28.451595957134437 16.2286110719045 30.747401981529656 18.5 30.747401981529656 C 20.7713889280955 30.747401981529656 22.611111111111107 28.451595957134437 22.611111111111107 25.622834984608044 C 22.611111111111107 22.79407401208165 20.7713889280955 20.498267987686436 18.5 20.498267987686436 Z M 13.36111111111111 12.298960792611862 C 12.54336026807626 12.298960792611865 11.759101978606646 12.622905313636505 11.180864810943602 13.19953095584613 C 10.602627643280558 13.776156598055756 10.277777777777779 14.558229188877457 10.277777777777777 15.373700990764828 C 10.277777777777777 16.1891727926522 10.602627643280558 16.9712453834739 11.180864810943602 17.547871025683524 C 11.759101978606646 18.124496667893148 12.54336026807626 18.44844118891779 13.36111111111111 18.44844118891779 C 14.178861954145962 18.448441188917787 14.963120243615574 18.124496667893148 15.541357411278618 17.547871025683524 C 16.119594578941662 16.9712453834739 16.44444444444444 16.1891727926522 16.444444444444443 15.373700990764828 C 16.44444444444444 14.558229188877457 16.119594578941662 13.776156598055756 15.541357411278618 13.19953095584613 C 14.963120243615574 12.622905313636505 14.178861954145962 12.298960792611867 13.36111111111111 12.298960792611862 L 13.36111111111111 12.298960792611862 Z M 23.638888888888886 12.298960792611862 C 22.821138045854035 12.298960792611865 22.036879756384423 12.622905313636505 21.45864258872138 13.19953095584613 C 20.880405421058335 13.776156598055756 20.555555555555557 14.558229188877457 20.555555555555554 15.373700990764828 C 20.555555555555557 16.1891727926522 20.880405421058335 16.9712453834739 21.45864258872138 17.547871025683524 C 22.036879756384423 18.124496667893148 22.821138045854035 18.44844118891779 23.638888888888886 18.44844118891779 C 24.456639731923737 18.448441188917787 25.24089802139335 18.124496667893148 25.819135189056393 17.547871025683524 C 26.397372356719437 16.9712453834739 26.722222222222218 16.1891727926522 26.72222222222222 15.373700990764828 C 26.722222222222218 14.558229188877457 26.397372356719437 13.776156598055756 25.819135189056393 13.19953095584613 C 25.24089802139335 12.622905313636505 24.456639731923737 12.298960792611867 23.638888888888886 12.298960792611862 L 23.638888888888886 12.298960792611862 Z"
            strokeColor: "transparent"
            fillColor: "#dcdada"
        }

        SvgPathItem {
            id: meteor
            x: 342
            y: 0
            width: 35
            height: 41
            strokeWidth: 1
            path: "M 35 0 L 35 23.43000999512052 C 34.999561671405296 26.502521039574283 34.196855227152504 29.521215350657602 32.67194641960992 32.18498502911883 C 31.14703761206733 34.84875470758005 28.9532290564643 37.06448841382597 26.309354570176865 38.611165014680225 C 23.66548008388943 40.15784161553448 20.663953655295902 40.98139691955998 17.604174613952637 40.99968717561728 C 14.544395572609371 41.01797743167459 11.5333182281918 40.23036240736529 8.871293200386894 38.715402567921224 C 6.209268172581989 37.20044272847716 3.989346888330248 35.011096131323384 2.4329634507497153 32.36574538493204 C 0.8765800131691828 29.720394638540693 0.03813785059416356 26.711508675290474 0.0012706243271370314 23.63922061131189 C -0.0355966019398895 20.56693254733331 0.7303998205396864 17.53863331736815 2.2228525744544134 14.856393034952402 C 3.7153053283691406 12.174152752536656 5.8820456928677025 9.931727608418537 8.506944444444445 8.35279832491808 L 21.38888888888889 0.8844827786271552 L 21.38888888888889 6.292910281349381 L 35 0 Z M 17.5 13.667505830486972 C 14.921506312158373 13.667505830486975 12.448621127340529 14.696052383823528 10.625350740220812 16.526877100710195 C 8.802080353101095 18.357701817596862 7.7777777777777795 20.8408328717569 7.777777777777778 23.43000999512052 C 7.7777777777777795 26.019187118484144 8.802080353101095 28.50231817264418 10.625350740220812 30.333142889530848 C 12.448621127340529 32.163967606417515 14.921506312158373 33.192514159754076 17.5 33.192514159754076 C 20.07849368784163 33.192514159754076 22.55137887265947 32.163967606417515 24.374649259779186 30.333142889530848 C 26.197919646898903 28.50231817264418 27.22222222222223 26.019187118484144 27.22222222222222 23.43000999512052 C 27.22222222222223 20.8408328717569 26.197919646898903 18.357701817596862 24.374649259779186 16.526877100710195 C 22.55137887265947 14.696052383823528 20.07849368784163 13.667505830486975 17.5 13.667505830486972 L 17.5 13.667505830486972 Z"
            strokeColor: "transparent"
            fillColor: "#dcdada"
        }

        SvgPathItem {
            id: rocket
            x: 398
            y: 0
            width: 30
            height: 41
            strokeWidth: 1
            path: "M 8.43375027179718 34.48745736863588 L 21.56624972820282 34.48745736863588 C 20.32582126557827 37.430042085035545 17.96685218811035 39.76971766556697 15 41 C 12.033147811889648 39.76971766556697 9.67417873442173 37.430042085035545 8.43375027179718 34.48745736863588 L 8.43375027179718 34.48745736863588 Z M 26.25 24.826506720576855 L 30 29.04422259476573 L 30 32.62779399701254 L 0 32.62779399701254 L 0 29.04422259476573 L 3.75 24.826506720576855 L 3.75 14.03116028077915 C 3.75 7.553952682927505 8.444999903440475 2.041910474265112 15 0 C 21.555000096559525 2.041910474265112 26.25 7.553952682927505 26.25 14.03116028077915 L 26.25 24.826506720576855 Z M 15 17.750487024025826 C 15.99456187337637 17.750487024025826 16.948388312011957 17.358629782462167 17.651649713516235 16.661120732300034 C 18.354911115020514 15.9636116821379 18.75 15.01758710036908 18.75 14.03116028077915 C 18.75 13.044733461189217 18.354911115020514 12.0987079926638 17.651649713516235 11.401198942501665 C 16.948388312011957 10.703689892339531 15.99456187337637 10.311833537532474 15 10.31183353753247 C 14.00543812662363 10.311833537532474 13.051611687988043 10.703689892339531 12.348350286483765 11.401198942501665 C 11.645088884979486 12.0987079926638 11.25 13.044733461189217 11.25 14.03116028077915 C 11.25 15.01758710036908 11.645088884979486 15.9636116821379 12.348350286483765 16.661120732300034 C 13.051611687988043 17.358629782462167 14.00543812662363 17.750487024025826 15 17.750487024025826 Z"
            strokeColor: "transparent"
            fillColor: "#dcdada"
        }

        SvgPathItem {
            id: branch
            x: 449
            y: 0
            width: 41
            height: 41
            strokeWidth: 1
            path: "M 9.353151823227225 27.811305735520914 C 10.841794780883873 28.401437539215483 12.075968456035758 29.495572090351413 12.8403092794646 30.90278178040896 C 13.604650102893443 32.309991470466514 13.850623101025697 33.94092302112916 13.535308870507725 35.510978799428194 C 13.219994639989753 37.08103457772723 12.363414561598228 38.49051599293819 11.115039304357996 39.493476641185914 C 9.866664047117764 40.496437289433636 8.305764799418306 41.02918701068923 6.70471595878986 40.998761950856064 C 5.103667118161415 40.9683368910229 3.5641317021781083 40.37667042436478 2.3547595349461066 39.327004643664345 C 1.1453873677141047 38.27733886296391 0.3429706270895472 36.83633009189958 0.08752944376938307 35.25542807999291 C -0.167911739550781 33.67452606808624 0.139843220925285 32.054116034632955 0.9570912311143502 30.676961616556312 C 1.7743392413034154 29.299807198479673 3.0491868247443916 28.253353082874806 4.559173795335942 27.720204866672116 L 4.559173795335942 13.280701950025406 C 3.0390096090827843 12.743420760610086 1.7577276411171388 11.685987409352762 0.9418041635173808 10.295310426651758 C 0.12588068591762291 8.904633443950754 -0.172144508607059 7.270262913138641 0.10040676475857559 5.681086606120042 C 0.37295803812421013 4.091910299101443 1.1985359092213206 2.6502605118027347 2.431212248300816 1.6109587771486111 C 3.663888587380311 0.5716570424944873 5.224287885960998 0.001627333040812433 6.83659827392652 0.0016273330408134443 C 8.448908661892043 0.0016273330408114214 10.00930741749242 0.5716570424944873 11.241983756571916 1.6109587771486111 C 12.47466009565141 2.6502605118027347 13.30023844185629 4.091910299101443 13.572789715221925 5.681086606120042 C 13.845340988587559 7.270262913138641 13.547315251082571 8.904633443950754 12.731391773482812 10.295310426651758 C 11.915468295883054 11.685987409352762 10.634186395789948 12.743420760610086 9.11402220953679 13.280701950025406 L 9.11402220953679 20.50045395135277 C 11.017949131194426 19.07016889861622 13.38191557599139 18.22293005811679 15.946295645308522 18.22293005811679 L 25.055993559670835 18.22293005811679 C 26.55479024909076 18.222990873434984 28.01205030238441 17.730346413514134 29.2033900935812 16.820855692737496 C 30.394729884777988 15.91136497196086 31.254087409254748 14.635460303440174 31.64913846771275 13.189601081176608 C 30.153269799604775 12.597228096304223 28.9143214949853 11.496103386665686 28.150414444950165 10.080081013019806 C 27.386507394915032 8.664058639373925 27.146615742298316 7.023924256741408 27.47297266515289 5.448422419719108 C 27.799329588007467 3.8729205826968087 28.671012018882365 2.4630612366945472 29.93455868891392 1.467051854287178 C 31.198105358945476 0.47104247187980874 32.77250635498855 -0.047260590822286674 34.38059004848999 0.003389923926311465 C 35.988673741991434 0.05404043867490961 37.5273452763044 0.6703974347669415 38.725711775669566 1.7439507763950803 C 39.92407827503473 2.817504118023219 40.70531133462851 4.279425874045743 40.93187986245488 5.872343478696655 C 41.158448390281244 7.465261083347566 40.81582698437053 9.08704844647347 39.96432804783058 10.452189715323922 C 39.11282911129062 11.817330984174372 37.807044070956984 12.838302702134964 36.27686406993883 13.335362905737894 C 35.81818620566738 15.97884163682705 34.441091357840655 18.37554187827047 32.38831276470952 20.103001079862803 C 30.335534171578384 21.830460281455135 27.738856819059254 22.777779294396787 25.055993559670835 22.777977844588754 L 15.946295645308522 22.777977844588754 C 14.447498955888596 22.77791702927056 12.990238902594946 23.27056040318339 11.798899111398157 24.180051123960027 C 10.607559320201368 25.089541844736665 9.748202881685227 26.365446513257346 9.353151823227225 27.811305735520914 L 9.353151823227225 27.811305735520914 Z"
            strokeColor: "transparent"
            fillColor: "#dcdada"
        }

        SvgPathItem {
            id: compass
            x: 511
            y: 0
            width: 36
            height: 41
            strokeWidth: 1
            path: "M 15.969773921297014 4.282078658544412 L 15.969773921297014 0 L 20.030229951055613 0 L 20.030229951055613 4.282078658544412 C 21.422285903001438 4.6395354269367255 22.69378607876322 5.3570944123710795 23.714897392336226 6.361486354484044 C 24.73600870590923 7.365878296597009 25.47015064540824 8.621120945935626 25.8423601817166 9.999042085820003 C 26.21456971802496 11.37696322570438 26.21151186031692 12.828199996261386 25.83350023890264 14.204565614860826 C 25.45548861748836 15.580931233460266 24.71606608987257 16.83311824449489 23.69073197575821 17.833267228283177 L 36 38.985851926374245 L 32.483648238068795 40.99999999999999 L 20.174376341474378 19.849428343577973 C 18.751692984501766 20.241233565855854 17.24831088785086 20.241233565855854 15.825627530878247 19.849428343577973 L 3.516355150239752 40.99999999999999 L 0 38.985851926374245 L 12.309271896594415 17.833267228283177 C 11.283937782480056 16.83311824449489 10.544515254864267 15.580931233460266 10.166503633449985 14.204565614860826 C 9.788492012035702 12.828199996261386 9.785434154327666 11.37696322570438 10.157643690636027 9.999042085820003 C 10.529853226944388 8.621120945935626 11.263995166443395 7.365878296597009 12.2851064800164 6.361486354484044 C 13.306217793589406 5.3570944123710795 14.57771796935119 4.6395354269367255 15.969773921297014 4.282078658544412 L 15.969773921297014 4.282078658544412 Z M 18.000001936176314 14.099036515380268 C 18.538451903605527 14.099036515380268 19.054847945485662 13.886831844288967 19.435589545250266 13.509105818396916 C 19.81633114501487 13.131379792504866 20.030229951055613 12.619073743451217 20.030229951055613 12.084888441754515 C 20.030229951055613 11.550703140057813 19.81633114501487 11.038397091004166 19.435589545250266 10.660671065112115 C 19.054847945485662 10.282945039220065 18.538451903605527 10.070740368128764 18.000001936176314 10.070740368128764 C 17.461551968747102 10.070740368128764 16.945155926866963 10.282945039220065 16.56441432710236 10.660671065112115 C 16.183672727337754 11.038397091004166 15.969773921297014 11.550703140057813 15.969773921297014 12.084888441754515 C 15.969773921297014 12.619073743451217 16.183672727337754 13.131379792504866 16.56441432710236 13.509105818396916 C 16.945155926866963 13.886831844288967 17.461551968747102 14.099036515380268 18.000001936176314 14.099036515380268 L 18.000001936176314 14.099036515380268 Z"
            strokeColor: "transparent"
            fillColor: "#dcdada"
        }

        SvgPathItem {
            id: crown
            x: 568
            y: 1
            width: 41
            height: 39
            strokeWidth: 1
            path: "M 0 34.89473684210527 L 41 34.89473684210527 L 41 39 L 0 39 L 0 34.89473684210527 Z M 0 6.157894736842106 L 10.25 12.315789473684212 L 20.5 0 L 30.749999999999996 12.315789473684212 L 41 6.157894736842106 L 41 30.789473684210527 L 0 30.789473684210527 L 0 6.157894736842106 Z"
            strokeColor: "transparent"
            fillColor: "#dcdada"
        }

        SvgPathItem {
            id: rainbow
            x: 630
            y: 6
            width: 41
            height: 30
            strokeWidth: 1
            path: "M 20.5 0 C 31.82159055363048 0 41 9.234375357627869 41 20.625 L 41 30 L 37.27272727272727 30 L 37.27272727272727 20.625 C 37.27267987992689 16.23554214835167 35.57265135916796 12.018837556242943 32.53338761763139 8.869675397872925 C 29.494123876094818 5.720513239502907 25.354827414859425 3.886745497584343 20.993864276192404 3.7575003504753113 L 20.5 3.75 C 16.137144923210144 3.7500476817808703 11.945996116508136 5.460444018244743 8.815919789400967 8.518239855766296 C 5.685843462293798 11.57603569328785 3.863189019940116 15.740569978952408 3.734727176752957 20.128124356269836 L 3.727272727272727 20.625 L 3.727272727272727 30 L 0 30 L 0 20.625 C 0 9.234375357627869 9.17840944636952 0 20.5 0 Z M 20.5 7.5 C 23.959869623184204 7.500000000000007 27.278031392530963 8.882809281349182 29.724528659473766 11.344224214553833 C 32.17102592641657 13.805639147758484 33.54545454545455 17.14403361082077 33.54545454545455 20.625 L 33.54545454545455 30 L 29.818181818181817 30 L 29.818181818181817 20.625 C 29.81804308446292 18.209131434559822 28.890945854512125 15.886572785675526 27.230225519700483 14.14166808128357 C 25.56950518488884 12.396763376891613 23.30337353728034 11.36422390351072 20.904409105127506 11.259375214576721 L 20.5 11.25 C 18.098773062229156 11.250139579656206 15.7902905263684 12.182889841496944 14.055961002003063 13.853736519813538 C 12.321631477637725 15.52458319813013 11.295349819247017 17.80453272163868 11.19113657691262 20.218124985694885 L 11.181818181818182 20.625 L 11.181818181818182 30 L 7.454545454545454 30 L 7.454545454545454 20.625 C 7.454545454545452 17.14403361082077 8.82897318493236 13.805639147758484 11.275470451875165 11.344224214553833 C 13.72196771881797 8.882809281349182 17.040130376815796 7.5000000000000036 20.5 7.5 L 20.5 7.5 Z M 20.5 15 C 21.98280128294771 15 23.404871596531436 15.59263151139021 24.453370441089977 16.647523641586304 C 25.501869285648517 17.7024157717824 26.09090909090909 19.1331572458148 26.09090909090909 20.625 L 26.09090909090909 30 L 22.363636363636363 30 L 22.363636363636363 20.625 C 22.36357614850931 20.165750049054623 22.195991173386574 19.722492154687643 21.892667293548584 19.37930166721344 C 21.589343413710594 19.036111179739237 21.171376325867392 18.81685718544759 20.718044757843018 18.76312494277954 L 20.5 18.75 C 20.043533382090654 18.750060582292463 19.602961899204686 18.918667417019606 19.26185135407881 19.223840832710266 C 18.920740808952935 19.529014248400927 18.702815626747906 19.94952991604805 18.649409034035422 20.405625700950623 L 18.636363636363637 20.625 L 18.636363636363637 30 L 14.909090909090908 30 L 14.909090909090908 20.625 C 14.909090909090908 19.1331572458148 15.49813071435148 17.7024157717824 16.546629558910023 16.647523641586304 C 17.595128403468564 15.59263151139021 19.01719871705229 15.000000000000004 20.5 15 L 20.5 15 Z"
            strokeColor: "transparent"
            fillColor: "#dcdada"
        }
    }
}
