/****************************************************************************
**
** Copyright (C) 2022 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Outrun demo.
**
** $QT_BEGIN_LICENSE:GPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 or (at your option) any later version
** approved by the KDE Free Qt Foundation. The licenses are as published by
** the Free Software Foundation and appearing in the file LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

import QtQuick
import QtQuick.Studio.Effects 1.0

Item {
    id: navigation

    property bool show: true
    property alias roadName: roadNameText.text
    property string timeofarrival: ""
    property string drivingtime: ""
    property string distanceremaining: ""
    property string distanceToTurn: ""
    property bool night: false

    property color color1: night ? "black" : "white"
    property color color2: night ? "white" : "black"
    // These animate the show/hide
    property real showAnimated: show
    property real showAnimated2: show
    readonly property alias bar1X: bar1.x

    width: 700
    height: 156

    Behavior on color1 {
        ColorAnimation {
            duration: 2000
        }
    }
    Behavior on color2 {
        ColorAnimation {
            duration: 2000
        }
    }

    Behavior on showAnimated {
        NumberAnimation {
            duration: 800
            easing.type: Easing.InOutQuad
        }
    }
    Behavior on showAnimated2 {
        SequentialAnimation {
            PauseAnimation {
                duration: 200
            }
            NumberAnimation {
                duration: 800
                easing.type: Easing.InOutQuad
            }
        }
    }

    // Bottom bar area
    Item {
        id: bar2
        anchors.top: bar1.bottom
        anchors.topMargin: -8
        width: background2.width
        height: background2.height
        x: (1 - showAnimated2) * -width
        Image {
            id: background2
            y: -8
            source: "../images/navigation_bar1.png"
            layer.enabled: true
            layer.effect: ColorOverlayEffect {
                color: color1
            }
        }
        Row {
            id: row
            anchors.verticalCenter: parent.verticalCenter
            anchors.verticalCenterOffset: 0
            x: 160
            spacing: 10
            Image {
                x: 8
                y: 7
                source: "../images/icon_time.png"
                layer.enabled: true
                layer.effect: ColorOverlayEffect {
                    color: color2
                }

            }
            Text {
                anchors.verticalCenter: parent.verticalCenter
                color: color2
                text: drivingtime + " min"
                font.pixelSize: 20
                font.styleName: "Bold"
                font.weight: Font.Bold
                font.family: "Exo 2"
            }
        }
        Row {
            anchors.verticalCenter: parent.verticalCenter
            anchors.verticalCenterOffset: 0
            x: 280
            width: 63
            height: 25
            spacing: 10
            Image {
                x: -1
                y: 9
                source: "../images/icon_arrival.png"
                layer.enabled: true
                layer.effect: ColorOverlayEffect {
                    color: color2
                }

            }
            Text {
                anchors.verticalCenter: parent.verticalCenter
                color: color2
                text: timeofarrival
                font.pixelSize: 20
                font.weight: Font.Thin
                font.family: "Exo 2"
            }
        }
        Row {
            anchors.verticalCenter: parent.verticalCenter
            anchors.verticalCenterOffset: 0
            x: 380
            spacing: 10
            Image {
                y: 7
                source: "../images/icon_distance.png"
                layer.enabled: true
                layer.effect: ColorOverlayEffect {
                    color: color2
                }

            }
            Text {
                anchors.verticalCenter: parent.verticalCenter
                color: color2
                text: distanceremaining + " km"
                font.pixelSize: 20
                font.weight: Font.Thin
                font.family: "Exo 2"
            }
        }
    }

    // Top bar area
    Item {
        id: bar1
        width: background1.width
        height: background1.height
        x: (1 - showAnimated) * -width
        Image {
            id: background1
            opacity: 0.2
            visible: true
            source: "../images/Basis.png"
            layer.effect: ColorOverlayEffect {
                color: color2
            }
            layer.enabled: true
            fillMode: Image.PreserveAspectFit
        }
        Image {
            anchors.verticalCenter: parent.verticalCenter
            x: 240
            source: "../images/turn_right.png"
            layer.enabled: true
            layer.effect: ColorOverlayEffect {
                color: color2
            }
        }
        Text {
            id: distanceToTurnText
            x: 360
            y: 20
            color: color2
            text: distanceToTurn + " km"
            font.pixelSize: 30
            font.weight: Font.Bold
            font.family: "Exo 2"
        }
        Text {
            id: roadNameText
            x: 360
            y: 65
            color: color2
            font.pixelSize: 20
            font.weight: Font.Normal
            font.family: "Open Sans"
        }
    }
}

/*##^##
Designer {
    D{i:0;height:156;width:700}D{i:2}D{i:5}D{i:7}D{i:4}D{i:9}D{i:11}D{i:8}D{i:13}D{i:15}
D{i:12}D{i:1}D{i:17}D{i:19}D{i:21}D{i:22}D{i:16}
}
##^##*/
