import QtQuick
import QtQuick3D

import QtQuick.Timeline

Node {
    id: node

    Texture {
        id: _0_texture
        generateMipmaps: true
        mipFilter: Texture.Linear
        source: "maps/textureData.png"
    }
    Texture {
        id: _1_texture
        generateMipmaps: true
        mipFilter: Texture.Linear
        source: "maps/textureData7.png"
    }

    // Nodes:
    Model {
        id: grass_Models_001
        x: 40.4532585144043
        y: 1.9326496124267578
        z: 1.5955982208251953
        rotation: Qt.quaternion(0.983104, 0, -0.183049, 0)
        scale.x: 3.66583
        scale.y: 3.66583
        scale.z: 3.66583
        source: "meshes/plane_209.mesh"
        materials: grass_medium_01_material
    }

    // Animations:

    Node {
        id: __materialLibrary__

        PrincipledMaterial {
            id: grass_medium_01_material_old
            objectName: "grass_medium_01_material"
            baseColorMap: _0_texture
            roughness: 0.44999998807907104
            normalMap: _1_texture
            normalStrength: 0.5
            cullMode: PrincipledMaterial.NoCulling
            alphaMode: PrincipledMaterial.Mask
        }

        CustomMaterial {
                    id: grass_medium_01_material
                    objectName: "leaf_material"
                    property TextureInput baseColorMap: TextureInput{
                        texture: _0_texture
                    }
                    property real roughness: 0.44999998807907104
                    property vector3d windDirection: windSource.direction
                    property real windSpeed: windSource.speed*0.5
                    property real windIntensity: windSource.intensity*0.5
                    property real windGust: windSource.gust*0.5
                    property real noiseResolution: windSource.noiseResolution
                    property real subAnimation: 0.0
                    property real constrain: 0

                    property vector3d shockposition: shockSource.sourceposition
                    property real shockResolution: shockSource.noiseResolution
                    property real shockSpeed: shockSource.speed*0.25
                    property real shockGust: shockSource.gust*0.25
                    property real shockIntensity: shockSource.intensity*0.25
                    property real shockScale: shockSource.sourcescale
                    property real shockLength: shockSource.length
                    property vector2d heightMask: Qt.vector2d(-130, -50)
                    property real time: timeSource.timeSeconds
                    depthDrawMode: Material.OpaqueOnlyDepthDraw
                    destinationBlend: CustomMaterial.NoBlend
                    sourceBlend: CustomMaterial.NoBlend
                    fragmentShader: "../../../ParticleEffectsContent/shaders/foliage.frag"
                    vertexShader: "../../../ParticleEffectsContent/shaders/foliage.vert"
                    cullMode: PrincipledMaterial.NoCulling
                    //alphaMode: PrincipledMaterial.Mask
        }
    }
}
